/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ConfigIllegalValueException;

public class CoreConfig {
    private static int defaultStreamFileThreshold = 0x3200000;
    public static final Config.SectionParser<CoreConfig> KEY = new Config.SectionParser<CoreConfig>(){

        @Override
        public CoreConfig parse(Config cfg) throws ConfigIllegalValueException {
            return new CoreConfig(cfg);
        }
    };
    private final int compression;
    private final int packIndexVersion;
    private final boolean logAllRefUpdates;
    private final String excludesfile;
    private final String attributesfile;
    private final long streamFileThreshold;

    public static int getDefaultStreamFileThreshold() {
        return defaultStreamFileThreshold;
    }

    public static void setDefaultStreamFileThreshold(int threshold) {
        defaultStreamFileThreshold = threshold;
    }

    private CoreConfig(Config rc) throws ConfigIllegalValueException {
        this.compression = rc.getInt("core", "compression", -1);
        this.packIndexVersion = rc.getInt("pack", "indexversion", 2);
        this.logAllRefUpdates = rc.getBoolean("core", "logallrefupdates", true);
        this.excludesfile = rc.getString("core", null, "excludesfile");
        this.attributesfile = rc.getString("core", null, "attributesfile");
        this.streamFileThreshold = rc.getLong("core", "streamFileThreshold", defaultStreamFileThreshold);
    }

    public int getCompression() {
        return this.compression;
    }

    public int getPackIndexVersion() {
        return this.packIndexVersion;
    }

    public boolean isLogAllRefUpdates() {
        return this.logAllRefUpdates;
    }

    public String getExcludesFile() {
        return this.excludesfile;
    }

    public String getAttributesFile() {
        return this.attributesfile;
    }

    public long getStreamFileThreshold() {
        return this.streamFileThreshold;
    }

    public static enum HideDotFiles {
        FALSE,
        TRUE,
        DOTGITONLY;

    }

    public static enum SymLinks {
        FALSE,
        TRUE;

    }

    public static enum CheckStat {
        MINIMAL,
        DEFAULT;

    }

    public static enum AutoCRLF {
        FALSE,
        TRUE,
        INPUT;

    }
}

