/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.mozilla.MozillaVersion;
import org.eclipse.swt.internal.mozilla.nsIBaseWindow;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class MozillaDelegate {
    Browser browser;
    Shell eventShell;
    long mozillaHandle;
    long embedHandle;
    boolean hasFocus;
    Listener listener;
    static Callback eventCallback;
    static long eventProc;
    static Boolean IsXULRunner24;
    static final int STOP_PROPOGATE = 1;
    static final String LIB_FIX_XULRUNNER10 = "libswt-xulrunner-fix10.so";
    static final String LIB_FIX_XULRUNNER31 = "libswt-xulrunner-fix31.so";
    static final String LIB_XPCOM = "libxpcom.so";
    static final String LIB_XUL = "libxul.so";
    static boolean IsSparc;

    MozillaDelegate(Browser browser) {
        if (IsSparc) {
            byte[] buffer = Converter.wcsToMbcs(null, "libCrun.so.1", true);
            OS.dlopen(buffer, OS.RTLD_NOW | OS.RTLD_GLOBAL);
        }
        if (OS.GTK3) {
            String errorString = " [Browser style SWT.MOZILLA and Java system property org.eclipse.swt.browser.DefaultType=mozilla are not supported with GTK 3 as XULRunner is not ported for GTK 3 yet]";
            SWT.error(2, null, errorString);
        }
        this.browser = browser;
    }

    static long eventProc(long handle, long gdkEvent, long pointer) {
        long parent = OS.gtk_widget_get_parent(handle);
        if ((parent = OS.gtk_widget_get_parent(parent)) == 0L) {
            return 0L;
        }
        Widget widget = Display.getCurrent().findWidget(parent);
        if (widget != null && widget instanceof Browser) {
            return ((Mozilla)((Browser)widget).webBrowser).delegate.gtk_event(handle, gdkEvent, pointer);
        }
        return 0L;
    }

    static Browser findBrowser(long handle) {
        long parent = OS.gtk_widget_get_parent(handle);
        Display display = Display.getCurrent();
        return (Browser)display.findWidget(parent);
    }

    static String getCacheParentPath() {
        return MozillaDelegate.getProfilePath();
    }

    static String[] getJSLibraryNames() {
        return new String[]{LIB_XUL};
    }

    static String getJSLibraryName_Pre10() {
        return "libmozjs.so";
    }

    static String getLibraryName(String mozillaPath) {
        if (IsXULRunner24 == null) {
            IsXULRunner24 = new File(mozillaPath, LIB_XPCOM).exists() ? Boolean.FALSE : Boolean.TRUE;
        }
        return IsXULRunner24 != false ? LIB_XUL : LIB_XPCOM;
    }

    static String getProfilePath() {
        long ptr;
        String baseDir = System.getProperty("user.home");
        if (baseDir.equals("?") && (ptr = C.getenv(MozillaDelegate.wcsToMbcs(null, "HOME", true))) != 0L) {
            int length = C.strlen(ptr);
            byte[] bytes = new byte[length];
            C.memmove(bytes, ptr, (long)length);
            baseDir = new String(MozillaDelegate.mbcsToWcs(null, bytes));
        }
        return baseDir + Mozilla.SEPARATOR_OS + ".mozilla" + Mozilla.SEPARATOR_OS + "eclipse";
    }

    static String getSWTInitLibraryName() {
        return "swt-xpcominit";
    }

    static void loadAdditionalLibraries(String mozillaPath, boolean isGlued) {
        InputStream is;
        String libName = null;
        if (!isGlued) {
            if (IsXULRunner24 == null) {
                Boolean bl = IsXULRunner24 = new File(mozillaPath, LIB_XPCOM).exists() ? Boolean.FALSE : Boolean.TRUE;
            }
            if (IsXULRunner24.booleanValue()) {
                libName = LIB_FIX_XULRUNNER31;
            }
        } else if (MozillaVersion.CheckVersion(5, true)) {
            libName = LIB_FIX_XULRUNNER10;
        }
        if (libName == null) {
            return;
        }
        File libsDir = new File(MozillaDelegate.getProfilePath() + "/libs/" + Mozilla.OS() + '/' + Mozilla.Arch());
        File file = new File(libsDir, libName);
        if (!file.exists() && (is = Library.class.getResourceAsStream('/' + libName)) != null) {
            if (!libsDir.exists()) {
                libsDir.mkdirs();
            }
            byte[] buffer = new byte[4096];
            try {
                int read;
                FileOutputStream os = new FileOutputStream(file);
                while ((read = is.read(buffer)) != -1) {
                    os.write(buffer, 0, read);
                }
                os.close();
                is.close();
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (file.exists()) {
            byte[] bytes = Converter.wcsToMbcs(null, file.getAbsolutePath(), true);
            OS.dlopen(bytes, OS.RTLD_NOW | OS.RTLD_GLOBAL);
        }
    }

    static char[] mbcsToWcs(String codePage, byte[] buffer) {
        return Converter.mbcsToWcs(codePage, buffer);
    }

    static boolean needsSpinup() {
        return true;
    }

    static byte[] wcsToMbcs(String codePage, String string, boolean terminate) {
        return Converter.wcsToMbcs(codePage, string, terminate);
    }

    void addWindowSubclass() {
    }

    int createBaseWindow(nsIBaseWindow baseWindow) {
        return baseWindow.Create();
    }

    long getHandle() {
        if (OS.GTK3) {
            this.embedHandle = OS.gtk_box_new(0, 0);
            OS.gtk_box_set_homogeneous(this.embedHandle, false);
        } else {
            this.embedHandle = OS.gtk_hbox_new(false, 0);
        }
        OS.gtk_container_add(this.browser.handle, this.embedHandle);
        OS.gtk_widget_show(this.embedHandle);
        return this.embedHandle;
    }

    Point getNativeSize(int width, int height) {
        return new Point(width, height);
    }

    long getSiteWindow() {
        return this.embedHandle;
    }

    long gtk_event(long handle, long gdkEvent, long pointer) {
        GdkEvent event = new GdkEvent();
        OS.memmove(event, gdkEvent, (long)GdkEvent.sizeof);
        if (event.type == 4 && !this.hasFocus) {
            this.browser.setFocus();
        }
        if (pointer == 1L) {
            return 1L;
        }
        return 0L;
    }

    void handleFocus() {
        if (this.hasFocus) {
            return;
        }
        this.hasFocus = true;
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == MozillaDelegate.this.browser) {
                    return;
                }
                if (event.type != 12) {
                    ((Mozilla)MozillaDelegate.this.browser.webBrowser).Deactivate();
                    MozillaDelegate.this.hasFocus = false;
                }
                MozillaDelegate.this.eventShell.getDisplay().removeFilter(15, this);
                MozillaDelegate.this.eventShell.removeListener(27, this);
                MozillaDelegate.this.eventShell.removeListener(12, this);
                MozillaDelegate.this.eventShell = null;
                MozillaDelegate.this.listener = null;
            }
        };
        this.eventShell = this.browser.getShell();
        this.eventShell.getDisplay().addFilter(15, this.listener);
        this.eventShell.addListener(27, this.listener);
        this.eventShell.addListener(12, this.listener);
    }

    void handleMouseDown() {
        int shellStyle = this.browser.getShell().getStyle();
        if ((shellStyle & 0x4000) != 0 && ((shellStyle & 0x80000) == 0 || (this.browser.getStyle() & 0x80000) == 0)) {
            this.browser.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (MozillaDelegate.this.browser == null || MozillaDelegate.this.browser.isDisposed()) {
                        return;
                    }
                    ((Mozilla)MozillaDelegate.this.browser.webBrowser).Activate();
                }
            });
        }
    }

    boolean hookEnterExit() {
        return false;
    }

    void init() {
        long list;
        if (eventCallback == null && (eventProc = (eventCallback = new Callback(this.getClass(), "eventProc", 3)).getAddress()) == 0L) {
            this.browser.dispose();
            Mozilla.error(3);
        }
        if ((list = OS.gtk_container_get_children(this.embedHandle)) != 0L) {
            this.mozillaHandle = OS.g_list_data(list);
            OS.g_list_free(list);
            if (this.mozillaHandle != 0L) {
                OS.g_signal_connect(this.mozillaHandle, OS.event, eventProc, 0L);
                OS.g_signal_connect(this.mozillaHandle, OS.key_press_event, eventProc, 1L);
                OS.g_signal_connect(this.mozillaHandle, OS.key_release_event, eventProc, 1L);
                OS.g_signal_connect(this.mozillaHandle, OS.button_press_event, eventProc, 1L);
            }
        }
    }

    void onDispose(long embedHandle) {
        if (this.listener != null) {
            this.eventShell.getDisplay().removeFilter(15, this.listener);
            this.eventShell.removeListener(27, this.listener);
            this.eventShell.removeListener(12, this.listener);
            this.eventShell = null;
            this.listener = null;
        }
        this.browser = null;
    }

    void removeWindowSubclass() {
    }

    boolean sendTraverse() {
        return true;
    }

    void setSize(long embedHandle, int width, int height) {
        OS.gtk_widget_set_size_request(embedHandle, width, height);
    }

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        IsSparc = (osName.startsWith("sunos") || osName.startsWith("solaris")) && osArch.startsWith("sparc");
    }
}

