/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnadmin;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svnadmin.SVNAdminCommand;
import org.tmatesoft.svn.cli.svnadmin.SVNAdminOption;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAdminSetRevPropCommand
extends SVNAdminCommand {
    public SVNAdminSetRevPropCommand() {
        super("setrevprop", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNAdminOption> options = new LinkedList<SVNAdminOption>();
        options.add(SVNAdminOption.REVISION);
        options.add(SVNAdminOption.USE_PRE_REVPROP_CHANGE_HOOK);
        options.add(SVNAdminOption.USE_POST_REVPROP_CHANGE_HOOK);
        return options;
    }

    @Override
    public void run() throws SVNException {
        if (this.getSVNAdminEnvironment().getStartRevision() == SVNRevision.UNDEFINED) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Missing revision"), SVNLogType.CLIENT);
        }
        if (this.getSVNAdminEnvironment().getEndRevision() != SVNRevision.UNDEFINED) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Only one revision allowed"), SVNLogType.CLIENT);
        }
        File repos = this.getLocalRepository();
        List<String> targets = this.getEnvironment().combineTargets(null, false);
        if (!targets.isEmpty()) {
            targets.remove(0);
        }
        if (targets.size() != 2) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Exactly one property name and one file argument required"), SVNLogType.CLIENT);
        }
        String propertyName = targets.get(0);
        SVNPath target = new SVNPath(targets.get(1));
        if (!target.isFile()) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Exactly one property name and one file argument required"), SVNLogType.CLIENT);
        }
        SVNPropertyValue propertyValue = SVNPropertyValue.create(propertyName, this.getEnvironment().readFromFile(target.getFile()));
        SVNURL url = SVNURL.fromFile(repos);
        FSRepository repository = (FSRepository)SVNRepositoryFactory.create(url);
        long rev = this.getRevisionNumber(this.getSVNAdminEnvironment().getStartRevision(), repository.getLatestRevision(), repository);
        repository.setRevisionPropertyValue(rev, propertyName, propertyValue, !this.getSVNAdminEnvironment().isUsePreRevPropChangeHook(), !this.getSVNAdminEnvironment().isUsePostRevPropChangeHook());
    }
}

