/******************************************************************************
 *
 * Copyright(c) 2018 - 2019 Realtek Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 ******************************************************************************/

#ifndef __INC_HALMAC_BIT_8812F_H
#define __INC_HALMAC_BIT_8812F_H

#define CPU_OPT_WIDTH 0x1F

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_SYS_ISO_CTRL_8812F */
#define BIT_PWC_EV12V_8812F BIT(15)

/* 2 REG_NOT_VALID_8812F */
#define BIT_PA33V_EN_8812F BIT(13)
#define BIT_PA12V_EN_8812F BIT(12)
#define BIT_UA33V_EN_8812F BIT(11)
#define BIT_UA12V_EN_8812F BIT(10)
#define BIT_ISO_RFDIO_8812F BIT(9)
#define BIT_ISO_EB2CORE_8812F BIT(8)
#define BIT_ISO_DIOE_8812F BIT(7)
#define BIT_ISO_WLPON2PP_8812F BIT(6)
#define BIT_ISO_IP2MAC_WA2PP_8812F BIT(5)
#define BIT_ISO_PD2CORE_8812F BIT(4)
#define BIT_ISO_PA2PCIE_8812F BIT(3)
#define BIT_ISO_UD2CORE_8812F BIT(2)
#define BIT_ISO_UA2USB_8812F BIT(1)
#define BIT_ISO_WD2PP_8812F BIT(0)

/* 2 REG_SYS_FUNC_EN_8812F */
#define BIT_FEN_MREGEN_8812F BIT(15)
#define BIT_FEN_HWPDN_8812F BIT(14)

/* 2 REG_NOT_VALID_8812F */
#define BIT_FEN_ELDR_8812F BIT(12)
#define BIT_FEN_DCORE_8812F BIT(11)
#define BIT_FEN_CPUEN_8812F BIT(10)
#define BIT_FEN_DIOE_8812F BIT(9)
#define BIT_FEN_PCIED_8812F BIT(8)
#define BIT_FEN_PPLL_8812F BIT(7)
#define BIT_FEN_PCIEA_8812F BIT(6)
#define BIT_FEN_DIO_PCIE_8812F BIT(5)
#define BIT_FEN_USBD_8812F BIT(4)
#define BIT_FEN_UPLL_8812F BIT(3)
#define BIT_FEN_USBA_8812F BIT(2)
#define BIT_FEN_BB_GLB_RSTN_8812F BIT(1)
#define BIT_FEN_BBRSTB_8812F BIT(0)

/* 2 REG_SYS_PW_CTRL_8812F */
#define BIT_SOP_EABM_8812F BIT(31)
#define BIT_SOP_ACKF_8812F BIT(30)
#define BIT_SOP_ERCK_8812F BIT(29)
#define BIT_SOP_ESWR_8812F BIT(28)
#define BIT_SOP_PWMM_8812F BIT(27)
#define BIT_SOP_EECK_8812F BIT(26)
#define BIT_SOP_ANA_CLK_DIVISION_2_8812F BIT(25)
#define BIT_SOP_EXTL_8812F BIT(24)
#define BIT_SYM_OP_RING_12M_8812F BIT(22)
#define BIT_ROP_SWPR_8812F BIT(21)
#define BIT_DIS_HW_LPLDM_8812F BIT(20)
#define BIT_OPT_SWRST_WLMCU_8812F BIT(19)
#define BIT_RDY_SYSPWR_8812F BIT(17)
#define BIT_EN_WLON_8812F BIT(16)
#define BIT_APDM_HPDN_8812F BIT(15)
#define BIT_AFSM_PCIE_SUS_EN_8812F BIT(12)
#define BIT_AFSM_WLSUS_EN_8812F BIT(11)
#define BIT_APFM_SWLPS_8812F BIT(10)
#define BIT_APFM_OFFMAC_8812F BIT(9)
#define BIT_APFN_ONMAC_8812F BIT(8)
#define BIT_CHIP_PDN_EN_8812F BIT(7)
#define BIT_RDY_MACDIS_8812F BIT(6)

/* 2 REG_NOT_VALID_8812F */
#define BIT_PFM_WOWL_8812F BIT(3)
#define BIT_PFM_LDKP_8812F BIT(2)
#define BIT_WL_HCI_ALD_8812F BIT(1)
#define BIT_PFM_LDALL_8812F BIT(0)

/* 2 REG_SYS_CLK_CTRL_8812F */

/* 2 REG_NOT_VALID_8812F */
#define BIT_CPU_CLK_EN_8812F BIT(14)
#define BIT_SYMREG_CLK_EN_8812F BIT(13)
#define BIT_HCI_CLK_EN_8812F BIT(12)
#define BIT_MAC_CLK_EN_8812F BIT(11)
#define BIT_SEC_CLK_EN_8812F BIT(10)
#define BIT_PHY_SSC_RSTB_8812F BIT(9)
#define BIT_EXT_32K_EN_8812F BIT(8)
#define BIT_WL_CLK_TEST_8812F BIT(7)
#define BIT_OP_SPS_PWM_EN_8812F BIT(6)
#define BIT_LOADER_CLK_EN_8812F BIT(5)
#define BIT_MACSLP_8812F BIT(4)
#define BIT_WAKEPAD_EN_8812F BIT(3)
#define BIT_ROMD16V_EN_8812F BIT(2)
#define BIT_ANA_CLK_DIVISION_2_8812F BIT(1)
#define BIT_CNTD16V_EN_8812F BIT(0)

/* 2 REG_SYS_EEPROM_CTRL_8812F */

#define BIT_SHIFT_VPDIDX_8812F 8
#define BIT_MASK_VPDIDX_8812F 0xff
#define BIT_VPDIDX_8812F(x)                                                    \
	(((x) & BIT_MASK_VPDIDX_8812F) << BIT_SHIFT_VPDIDX_8812F)
#define BITS_VPDIDX_8812F (BIT_MASK_VPDIDX_8812F << BIT_SHIFT_VPDIDX_8812F)
#define BIT_CLEAR_VPDIDX_8812F(x) ((x) & (~BITS_VPDIDX_8812F))
#define BIT_GET_VPDIDX_8812F(x)                                                \
	(((x) >> BIT_SHIFT_VPDIDX_8812F) & BIT_MASK_VPDIDX_8812F)
#define BIT_SET_VPDIDX_8812F(x, v)                                             \
	(BIT_CLEAR_VPDIDX_8812F(x) | BIT_VPDIDX_8812F(v))

#define BIT_SHIFT_EEM1_0_8812F 6
#define BIT_MASK_EEM1_0_8812F 0x3
#define BIT_EEM1_0_8812F(x)                                                    \
	(((x) & BIT_MASK_EEM1_0_8812F) << BIT_SHIFT_EEM1_0_8812F)
#define BITS_EEM1_0_8812F (BIT_MASK_EEM1_0_8812F << BIT_SHIFT_EEM1_0_8812F)
#define BIT_CLEAR_EEM1_0_8812F(x) ((x) & (~BITS_EEM1_0_8812F))
#define BIT_GET_EEM1_0_8812F(x)                                                \
	(((x) >> BIT_SHIFT_EEM1_0_8812F) & BIT_MASK_EEM1_0_8812F)
#define BIT_SET_EEM1_0_8812F(x, v)                                             \
	(BIT_CLEAR_EEM1_0_8812F(x) | BIT_EEM1_0_8812F(v))

#define BIT_AUTOLOAD_SUS_8812F BIT(5)
#define BIT_EERPOMSEL_8812F BIT(4)
#define BIT_EECS_V1_8812F BIT(3)
#define BIT_EESK_V1_8812F BIT(2)
#define BIT_EEDI_V1_8812F BIT(1)
#define BIT_EEDO_V1_8812F BIT(0)

/* 2 REG_EE_VPD_8812F */

#define BIT_SHIFT_VPD_DATA_8812F 0
#define BIT_MASK_VPD_DATA_8812F 0xffffffffL
#define BIT_VPD_DATA_8812F(x)                                                  \
	(((x) & BIT_MASK_VPD_DATA_8812F) << BIT_SHIFT_VPD_DATA_8812F)
#define BITS_VPD_DATA_8812F                                                    \
	(BIT_MASK_VPD_DATA_8812F << BIT_SHIFT_VPD_DATA_8812F)
#define BIT_CLEAR_VPD_DATA_8812F(x) ((x) & (~BITS_VPD_DATA_8812F))
#define BIT_GET_VPD_DATA_8812F(x)                                              \
	(((x) >> BIT_SHIFT_VPD_DATA_8812F) & BIT_MASK_VPD_DATA_8812F)
#define BIT_SET_VPD_DATA_8812F(x, v)                                           \
	(BIT_CLEAR_VPD_DATA_8812F(x) | BIT_VPD_DATA_8812F(v))

/* 2 REG_SYS_SWR_CTRL1_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */
#define BIT_HW_AUTO_CTRL_EXT_SWR_8812F BIT(9)
#define BIT_USE_INTERNAL_SWR_AND_LDO_8812F BIT(8)
#define BIT_MAC_ID_EN_8812F BIT(7)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_SYS_SWR_CTRL2_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */
#define BIT_SW18_SEL_8812F BIT(13)

/* 2 REG_NOT_VALID_8812F */
#define BIT_SW18_SD_8812F BIT(10)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_SYS_SWR_CTRL3_8812F */
#define BIT_SPS18_OCP_DIS_8812F BIT(31)

#define BIT_SHIFT_SPS18_OCP_TH_8812F 16
#define BIT_MASK_SPS18_OCP_TH_8812F 0x7fff
#define BIT_SPS18_OCP_TH_8812F(x)                                              \
	(((x) & BIT_MASK_SPS18_OCP_TH_8812F) << BIT_SHIFT_SPS18_OCP_TH_8812F)
#define BITS_SPS18_OCP_TH_8812F                                                \
	(BIT_MASK_SPS18_OCP_TH_8812F << BIT_SHIFT_SPS18_OCP_TH_8812F)
#define BIT_CLEAR_SPS18_OCP_TH_8812F(x) ((x) & (~BITS_SPS18_OCP_TH_8812F))
#define BIT_GET_SPS18_OCP_TH_8812F(x)                                          \
	(((x) >> BIT_SHIFT_SPS18_OCP_TH_8812F) & BIT_MASK_SPS18_OCP_TH_8812F)
#define BIT_SET_SPS18_OCP_TH_8812F(x, v)                                       \
	(BIT_CLEAR_SPS18_OCP_TH_8812F(x) | BIT_SPS18_OCP_TH_8812F(v))

#define BIT_SHIFT_OCP_WINDOW_8812F 0
#define BIT_MASK_OCP_WINDOW_8812F 0xffff
#define BIT_OCP_WINDOW_8812F(x)                                                \
	(((x) & BIT_MASK_OCP_WINDOW_8812F) << BIT_SHIFT_OCP_WINDOW_8812F)
#define BITS_OCP_WINDOW_8812F                                                  \
	(BIT_MASK_OCP_WINDOW_8812F << BIT_SHIFT_OCP_WINDOW_8812F)
#define BIT_CLEAR_OCP_WINDOW_8812F(x) ((x) & (~BITS_OCP_WINDOW_8812F))
#define BIT_GET_OCP_WINDOW_8812F(x)                                            \
	(((x) >> BIT_SHIFT_OCP_WINDOW_8812F) & BIT_MASK_OCP_WINDOW_8812F)
#define BIT_SET_OCP_WINDOW_8812F(x, v)                                         \
	(BIT_CLEAR_OCP_WINDOW_8812F(x) | BIT_OCP_WINDOW_8812F(v))

/* 2 REG_RSV_CTRL_8812F */
#define BIT_HREG_DBG_8812F BIT(23)
#define BIT_WLMCUIOIF_8812F BIT(8)
#define BIT_LOCK_ALL_EN_8812F BIT(7)
#define BIT_R_DIS_PRST_8812F BIT(6)
#define BIT_WLOCK_1C_B6_8812F BIT(5)
#define BIT_WLOCK_40_8812F BIT(4)
#define BIT_WLOCK_08_8812F BIT(3)
#define BIT_WLOCK_04_8812F BIT(2)
#define BIT_WLOCK_00_8812F BIT(1)
#define BIT_WLOCK_ALL_8812F BIT(0)

/* 2 REG_RF_CTRL_8812F */
#define BIT_RF_SDMRSTB_8812F BIT(2)
#define BIT_RF_RSTB_8812F BIT(1)
#define BIT_RF_EN_8812F BIT(0)

/* 2 REG_AFE_LDO_CTRL_8812F */
#define BIT_R_SYM_WLPON_EMEM1_EN_8812F BIT(31)
#define BIT_R_SYM_WLPON_EMEM0_EN_8812F BIT(30)
#define BIT_R_SYM_WLPOFF_P4EN_8812F BIT(28)
#define BIT_R_SYM_WLPOFF_P3EN_8812F BIT(27)
#define BIT_R_SYM_WLPOFF_P2EN_8812F BIT(26)
#define BIT_R_SYM_WLPOFF_P1EN_8812F BIT(25)
#define BIT_R_SYM_WLPOFF_EN_8812F BIT(24)
#define BIT_R_SYM_WLPON_P3EN_8812F BIT(21)
#define BIT_R_SYM_WLPON_P2EN_8812F BIT(20)
#define BIT_R_SYM_WLPON_P1EN_8812F BIT(19)
#define BIT_R_SYM_WLPON_EN_8812F BIT(18)
#define BIT_R_SYM_LDOV12D_STBY_8812F BIT(16)
#define BIT_BB_POWER_CUT_CTRL_BY_BB_8812F BIT(15)
#define BIT_R_SYM_WLBBOFF1_P4_EN_8812F BIT(9)
#define BIT_R_SYM_WLBBOFF1_P3_EN_8812F BIT(8)
#define BIT_R_SYM_WLBBOFF1_P2_EN_8812F BIT(7)
#define BIT_R_SYM_WLBBOFF1_P1_EN_8812F BIT(6)
#define BIT_R_SYM_WLBBOFF_P4_EN_8812F BIT(4)
#define BIT_R_SYM_WLBBOFF_P3_EN_8812F BIT(3)
#define BIT_R_SYM_WLBBOFF_P2_EN_8812F BIT(2)
#define BIT_R_SYM_WLBBOFF_P1_EN_8812F BIT(1)
#define BIT_R_SYM_WLBBOFF_EN_8812F BIT(0)

/* 2 REG_AFE_CTRL1_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_MAC_CLK_SEL_8812F 20
#define BIT_MASK_MAC_CLK_SEL_8812F 0x3
#define BIT_MAC_CLK_SEL_8812F(x)                                               \
	(((x) & BIT_MASK_MAC_CLK_SEL_8812F) << BIT_SHIFT_MAC_CLK_SEL_8812F)
#define BITS_MAC_CLK_SEL_8812F                                                 \
	(BIT_MASK_MAC_CLK_SEL_8812F << BIT_SHIFT_MAC_CLK_SEL_8812F)
#define BIT_CLEAR_MAC_CLK_SEL_8812F(x) ((x) & (~BITS_MAC_CLK_SEL_8812F))
#define BIT_GET_MAC_CLK_SEL_8812F(x)                                           \
	(((x) >> BIT_SHIFT_MAC_CLK_SEL_8812F) & BIT_MASK_MAC_CLK_SEL_8812F)
#define BIT_SET_MAC_CLK_SEL_8812F(x, v)                                        \
	(BIT_CLEAR_MAC_CLK_SEL_8812F(x) | BIT_MAC_CLK_SEL_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_ANAPARSW_POW_MAC_8812F */
#define BIT_POW_LDO15_8812F BIT(2)
#define BIT_POW_SW_8812F BIT(1)
#define BIT_POW_LDO14_8812F BIT(0)

/* 2 REG_ANAPARLDO_POW_MAC_8812F */
#define BIT_LDOE25_POW_L_8812F BIT(0)

/* 2 REG_ANAPAR_POW_MAC_8812F */
#define BIT_DUMMY_V4_8812F BIT(7)
#define BIT_DUMMY_V3_8812F BIT(6)
#define BIT_DUMMY_V2_8812F BIT(5)
#define BIT_DUMMY_V1_8812F BIT(4)
#define BIT_POW_PC_LDO_PORT1_8812F BIT(3)
#define BIT_POW_PC_LDO_PORT0_8812F BIT(2)
#define BIT_POW_PLL_V1_8812F BIT(1)
#define BIT_POW_POWER_CUT_POW_LDO_8812F BIT(0)

/* 2 REG_ANAPAR_POW_XTAL_8812F */
#define BIT_POW_XTAL_8812F BIT(1)
#define BIT_POW_BG_8812F BIT(0)

/* 2 REG_ANAPARLDO_MAC_8812F */

/* 2 REG_NOT_VALID_8812F */
#define BIT_REG_STANDBY_L_8812F BIT(19)
#define BIT_PD_REGU_L_8812F BIT(18)
#define BIT_EN_PC_BT_L_8812F BIT(17)

#define BIT_SHIFT_REG_LDOADJ_L_8812F 13
#define BIT_MASK_REG_LDOADJ_L_8812F 0xf
#define BIT_REG_LDOADJ_L_8812F(x)                                              \
	(((x) & BIT_MASK_REG_LDOADJ_L_8812F) << BIT_SHIFT_REG_LDOADJ_L_8812F)
#define BITS_REG_LDOADJ_L_8812F                                                \
	(BIT_MASK_REG_LDOADJ_L_8812F << BIT_SHIFT_REG_LDOADJ_L_8812F)
#define BIT_CLEAR_REG_LDOADJ_L_8812F(x) ((x) & (~BITS_REG_LDOADJ_L_8812F))
#define BIT_GET_REG_LDOADJ_L_8812F(x)                                          \
	(((x) >> BIT_SHIFT_REG_LDOADJ_L_8812F) & BIT_MASK_REG_LDOADJ_L_8812F)
#define BIT_SET_REG_LDOADJ_L_8812F(x, v)                                       \
	(BIT_CLEAR_REG_LDOADJ_L_8812F(x) | BIT_REG_LDOADJ_L_8812F(v))

#define BIT_CK12M_EN_8812F BIT(11)
#define BIT_CK12M_SEL_8812F BIT(10)
#define BIT_EN_25_L_8812F BIT(9)
#define BIT_EN_SLEEP_8812F BIT(8)

#define BIT_SHIFT_LDOH12_V12ADJ_L_8812F 4
#define BIT_MASK_LDOH12_V12ADJ_L_8812F 0xf
#define BIT_LDOH12_V12ADJ_L_8812F(x)                                           \
	(((x) & BIT_MASK_LDOH12_V12ADJ_L_8812F)                                \
	 << BIT_SHIFT_LDOH12_V12ADJ_L_8812F)
#define BITS_LDOH12_V12ADJ_L_8812F                                             \
	(BIT_MASK_LDOH12_V12ADJ_L_8812F << BIT_SHIFT_LDOH12_V12ADJ_L_8812F)
#define BIT_CLEAR_LDOH12_V12ADJ_L_8812F(x) ((x) & (~BITS_LDOH12_V12ADJ_L_8812F))
#define BIT_GET_LDOH12_V12ADJ_L_8812F(x)                                       \
	(((x) >> BIT_SHIFT_LDOH12_V12ADJ_L_8812F) &                            \
	 BIT_MASK_LDOH12_V12ADJ_L_8812F)
#define BIT_SET_LDOH12_V12ADJ_L_8812F(x, v)                                    \
	(BIT_CLEAR_LDOH12_V12ADJ_L_8812F(x) | BIT_LDOH12_V12ADJ_L_8812F(v))

#define BIT_SHIFT_LDOE25_V12ADJ_L_V1_8812F 0
#define BIT_MASK_LDOE25_V12ADJ_L_V1_8812F 0xf
#define BIT_LDOE25_V12ADJ_L_V1_8812F(x)                                        \
	(((x) & BIT_MASK_LDOE25_V12ADJ_L_V1_8812F)                             \
	 << BIT_SHIFT_LDOE25_V12ADJ_L_V1_8812F)
#define BITS_LDOE25_V12ADJ_L_V1_8812F                                          \
	(BIT_MASK_LDOE25_V12ADJ_L_V1_8812F                                     \
	 << BIT_SHIFT_LDOE25_V12ADJ_L_V1_8812F)
#define BIT_CLEAR_LDOE25_V12ADJ_L_V1_8812F(x)                                  \
	((x) & (~BITS_LDOE25_V12ADJ_L_V1_8812F))
#define BIT_GET_LDOE25_V12ADJ_L_V1_8812F(x)                                    \
	(((x) >> BIT_SHIFT_LDOE25_V12ADJ_L_V1_8812F) &                         \
	 BIT_MASK_LDOE25_V12ADJ_L_V1_8812F)
#define BIT_SET_LDOE25_V12ADJ_L_V1_8812F(x, v)                                 \
	(BIT_CLEAR_LDOE25_V12ADJ_L_V1_8812F(x) |                               \
	 BIT_LDOE25_V12ADJ_L_V1_8812F(v))

/* 2 REG_EFUSE_CTRL_8812F */
#define BIT_EF_FLAG_8812F BIT(31)

#define BIT_SHIFT_EF_PGPD_8812F 28
#define BIT_MASK_EF_PGPD_8812F 0x7
#define BIT_EF_PGPD_8812F(x)                                                   \
	(((x) & BIT_MASK_EF_PGPD_8812F) << BIT_SHIFT_EF_PGPD_8812F)
#define BITS_EF_PGPD_8812F (BIT_MASK_EF_PGPD_8812F << BIT_SHIFT_EF_PGPD_8812F)
#define BIT_CLEAR_EF_PGPD_8812F(x) ((x) & (~BITS_EF_PGPD_8812F))
#define BIT_GET_EF_PGPD_8812F(x)                                               \
	(((x) >> BIT_SHIFT_EF_PGPD_8812F) & BIT_MASK_EF_PGPD_8812F)
#define BIT_SET_EF_PGPD_8812F(x, v)                                            \
	(BIT_CLEAR_EF_PGPD_8812F(x) | BIT_EF_PGPD_8812F(v))

#define BIT_SHIFT_EF_RDT_8812F 24
#define BIT_MASK_EF_RDT_8812F 0xf
#define BIT_EF_RDT_8812F(x)                                                    \
	(((x) & BIT_MASK_EF_RDT_8812F) << BIT_SHIFT_EF_RDT_8812F)
#define BITS_EF_RDT_8812F (BIT_MASK_EF_RDT_8812F << BIT_SHIFT_EF_RDT_8812F)
#define BIT_CLEAR_EF_RDT_8812F(x) ((x) & (~BITS_EF_RDT_8812F))
#define BIT_GET_EF_RDT_8812F(x)                                                \
	(((x) >> BIT_SHIFT_EF_RDT_8812F) & BIT_MASK_EF_RDT_8812F)
#define BIT_SET_EF_RDT_8812F(x, v)                                             \
	(BIT_CLEAR_EF_RDT_8812F(x) | BIT_EF_RDT_8812F(v))

#define BIT_SHIFT_EF_PGTS_8812F 20
#define BIT_MASK_EF_PGTS_8812F 0xf
#define BIT_EF_PGTS_8812F(x)                                                   \
	(((x) & BIT_MASK_EF_PGTS_8812F) << BIT_SHIFT_EF_PGTS_8812F)
#define BITS_EF_PGTS_8812F (BIT_MASK_EF_PGTS_8812F << BIT_SHIFT_EF_PGTS_8812F)
#define BIT_CLEAR_EF_PGTS_8812F(x) ((x) & (~BITS_EF_PGTS_8812F))
#define BIT_GET_EF_PGTS_8812F(x)                                               \
	(((x) >> BIT_SHIFT_EF_PGTS_8812F) & BIT_MASK_EF_PGTS_8812F)
#define BIT_SET_EF_PGTS_8812F(x, v)                                            \
	(BIT_CLEAR_EF_PGTS_8812F(x) | BIT_EF_PGTS_8812F(v))

#define BIT_EF_PDWN_8812F BIT(19)
#define BIT_EF_ALDEN_8812F BIT(18)

#define BIT_SHIFT_EF_ADDR_8812F 8
#define BIT_MASK_EF_ADDR_8812F 0x3ff
#define BIT_EF_ADDR_8812F(x)                                                   \
	(((x) & BIT_MASK_EF_ADDR_8812F) << BIT_SHIFT_EF_ADDR_8812F)
#define BITS_EF_ADDR_8812F (BIT_MASK_EF_ADDR_8812F << BIT_SHIFT_EF_ADDR_8812F)
#define BIT_CLEAR_EF_ADDR_8812F(x) ((x) & (~BITS_EF_ADDR_8812F))
#define BIT_GET_EF_ADDR_8812F(x)                                               \
	(((x) >> BIT_SHIFT_EF_ADDR_8812F) & BIT_MASK_EF_ADDR_8812F)
#define BIT_SET_EF_ADDR_8812F(x, v)                                            \
	(BIT_CLEAR_EF_ADDR_8812F(x) | BIT_EF_ADDR_8812F(v))

#define BIT_SHIFT_EF_DATA_8812F 0
#define BIT_MASK_EF_DATA_8812F 0xff
#define BIT_EF_DATA_8812F(x)                                                   \
	(((x) & BIT_MASK_EF_DATA_8812F) << BIT_SHIFT_EF_DATA_8812F)
#define BITS_EF_DATA_8812F (BIT_MASK_EF_DATA_8812F << BIT_SHIFT_EF_DATA_8812F)
#define BIT_CLEAR_EF_DATA_8812F(x) ((x) & (~BITS_EF_DATA_8812F))
#define BIT_GET_EF_DATA_8812F(x)                                               \
	(((x) >> BIT_SHIFT_EF_DATA_8812F) & BIT_MASK_EF_DATA_8812F)
#define BIT_SET_EF_DATA_8812F(x, v)                                            \
	(BIT_CLEAR_EF_DATA_8812F(x) | BIT_EF_DATA_8812F(v))

/* 2 REG_LDO_EFUSE_CTRL_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */
#define BIT_EF_CRES_SEL_8812F BIT(26)

#define BIT_SHIFT_EF_SCAN_START_V1_8812F 16
#define BIT_MASK_EF_SCAN_START_V1_8812F 0x3ff
#define BIT_EF_SCAN_START_V1_8812F(x)                                          \
	(((x) & BIT_MASK_EF_SCAN_START_V1_8812F)                               \
	 << BIT_SHIFT_EF_SCAN_START_V1_8812F)
#define BITS_EF_SCAN_START_V1_8812F                                            \
	(BIT_MASK_EF_SCAN_START_V1_8812F << BIT_SHIFT_EF_SCAN_START_V1_8812F)
#define BIT_CLEAR_EF_SCAN_START_V1_8812F(x)                                    \
	((x) & (~BITS_EF_SCAN_START_V1_8812F))
#define BIT_GET_EF_SCAN_START_V1_8812F(x)                                      \
	(((x) >> BIT_SHIFT_EF_SCAN_START_V1_8812F) &                           \
	 BIT_MASK_EF_SCAN_START_V1_8812F)
#define BIT_SET_EF_SCAN_START_V1_8812F(x, v)                                   \
	(BIT_CLEAR_EF_SCAN_START_V1_8812F(x) | BIT_EF_SCAN_START_V1_8812F(v))

#define BIT_SHIFT_EF_SCAN_END_8812F 12
#define BIT_MASK_EF_SCAN_END_8812F 0xf
#define BIT_EF_SCAN_END_8812F(x)                                               \
	(((x) & BIT_MASK_EF_SCAN_END_8812F) << BIT_SHIFT_EF_SCAN_END_8812F)
#define BITS_EF_SCAN_END_8812F                                                 \
	(BIT_MASK_EF_SCAN_END_8812F << BIT_SHIFT_EF_SCAN_END_8812F)
#define BIT_CLEAR_EF_SCAN_END_8812F(x) ((x) & (~BITS_EF_SCAN_END_8812F))
#define BIT_GET_EF_SCAN_END_8812F(x)                                           \
	(((x) >> BIT_SHIFT_EF_SCAN_END_8812F) & BIT_MASK_EF_SCAN_END_8812F)
#define BIT_SET_EF_SCAN_END_8812F(x, v)                                        \
	(BIT_CLEAR_EF_SCAN_END_8812F(x) | BIT_EF_SCAN_END_8812F(v))

#define BIT_EF_PD_DIS_8812F BIT(11)

#define BIT_SHIFT_EF_CELL_SEL_8812F 8
#define BIT_MASK_EF_CELL_SEL_8812F 0x3
#define BIT_EF_CELL_SEL_8812F(x)                                               \
	(((x) & BIT_MASK_EF_CELL_SEL_8812F) << BIT_SHIFT_EF_CELL_SEL_8812F)
#define BITS_EF_CELL_SEL_8812F                                                 \
	(BIT_MASK_EF_CELL_SEL_8812F << BIT_SHIFT_EF_CELL_SEL_8812F)
#define BIT_CLEAR_EF_CELL_SEL_8812F(x) ((x) & (~BITS_EF_CELL_SEL_8812F))
#define BIT_GET_EF_CELL_SEL_8812F(x)                                           \
	(((x) >> BIT_SHIFT_EF_CELL_SEL_8812F) & BIT_MASK_EF_CELL_SEL_8812F)
#define BIT_SET_EF_CELL_SEL_8812F(x, v)                                        \
	(BIT_CLEAR_EF_CELL_SEL_8812F(x) | BIT_EF_CELL_SEL_8812F(v))

#define BIT_EF_TRPT_8812F BIT(7)

#define BIT_SHIFT_EF_TTHD_8812F 0
#define BIT_MASK_EF_TTHD_8812F 0x7f
#define BIT_EF_TTHD_8812F(x)                                                   \
	(((x) & BIT_MASK_EF_TTHD_8812F) << BIT_SHIFT_EF_TTHD_8812F)
#define BITS_EF_TTHD_8812F (BIT_MASK_EF_TTHD_8812F << BIT_SHIFT_EF_TTHD_8812F)
#define BIT_CLEAR_EF_TTHD_8812F(x) ((x) & (~BITS_EF_TTHD_8812F))
#define BIT_GET_EF_TTHD_8812F(x)                                               \
	(((x) >> BIT_SHIFT_EF_TTHD_8812F) & BIT_MASK_EF_TTHD_8812F)
#define BIT_SET_EF_TTHD_8812F(x, v)                                            \
	(BIT_CLEAR_EF_TTHD_8812F(x) | BIT_EF_TTHD_8812F(v))

/* 2 REG_PWR_OPTION_CTRL_8812F */

#define BIT_SHIFT_DBG_SEL_V1_8812F 16
#define BIT_MASK_DBG_SEL_V1_8812F 0xff
#define BIT_DBG_SEL_V1_8812F(x)                                                \
	(((x) & BIT_MASK_DBG_SEL_V1_8812F) << BIT_SHIFT_DBG_SEL_V1_8812F)
#define BITS_DBG_SEL_V1_8812F                                                  \
	(BIT_MASK_DBG_SEL_V1_8812F << BIT_SHIFT_DBG_SEL_V1_8812F)
#define BIT_CLEAR_DBG_SEL_V1_8812F(x) ((x) & (~BITS_DBG_SEL_V1_8812F))
#define BIT_GET_DBG_SEL_V1_8812F(x)                                            \
	(((x) >> BIT_SHIFT_DBG_SEL_V1_8812F) & BIT_MASK_DBG_SEL_V1_8812F)
#define BIT_SET_DBG_SEL_V1_8812F(x, v)                                         \
	(BIT_CLEAR_DBG_SEL_V1_8812F(x) | BIT_DBG_SEL_V1_8812F(v))

#define BIT_SHIFT_DBG_SEL_BYTE_8812F 14
#define BIT_MASK_DBG_SEL_BYTE_8812F 0x3
#define BIT_DBG_SEL_BYTE_8812F(x)                                              \
	(((x) & BIT_MASK_DBG_SEL_BYTE_8812F) << BIT_SHIFT_DBG_SEL_BYTE_8812F)
#define BITS_DBG_SEL_BYTE_8812F                                                \
	(BIT_MASK_DBG_SEL_BYTE_8812F << BIT_SHIFT_DBG_SEL_BYTE_8812F)
#define BIT_CLEAR_DBG_SEL_BYTE_8812F(x) ((x) & (~BITS_DBG_SEL_BYTE_8812F))
#define BIT_GET_DBG_SEL_BYTE_8812F(x)                                          \
	(((x) >> BIT_SHIFT_DBG_SEL_BYTE_8812F) & BIT_MASK_DBG_SEL_BYTE_8812F)
#define BIT_SET_DBG_SEL_BYTE_8812F(x, v)                                       \
	(BIT_CLEAR_DBG_SEL_BYTE_8812F(x) | BIT_DBG_SEL_BYTE_8812F(v))

/* 2 REG_NOT_VALID_8812F */
#define BIT_SYSON_DBG_PAD_E2_8812F BIT(11)
#define BIT_SYSON_LED_PAD_E2_8812F BIT(10)
#define BIT_SYSON_GPEE_PAD_E2_8812F BIT(9)
#define BIT_SYSON_PCI_PAD_E2_8812F BIT(8)
#define BIT_AUTO_SW_LDO_VOL_EN_8812F BIT(7)

#define BIT_SHIFT_SYSON_SPS0WWV_WT_8812F 4
#define BIT_MASK_SYSON_SPS0WWV_WT_8812F 0x3
#define BIT_SYSON_SPS0WWV_WT_8812F(x)                                          \
	(((x) & BIT_MASK_SYSON_SPS0WWV_WT_8812F)                               \
	 << BIT_SHIFT_SYSON_SPS0WWV_WT_8812F)
#define BITS_SYSON_SPS0WWV_WT_8812F                                            \
	(BIT_MASK_SYSON_SPS0WWV_WT_8812F << BIT_SHIFT_SYSON_SPS0WWV_WT_8812F)
#define BIT_CLEAR_SYSON_SPS0WWV_WT_8812F(x)                                    \
	((x) & (~BITS_SYSON_SPS0WWV_WT_8812F))
#define BIT_GET_SYSON_SPS0WWV_WT_8812F(x)                                      \
	(((x) >> BIT_SHIFT_SYSON_SPS0WWV_WT_8812F) &                           \
	 BIT_MASK_SYSON_SPS0WWV_WT_8812F)
#define BIT_SET_SYSON_SPS0WWV_WT_8812F(x, v)                                   \
	(BIT_CLEAR_SYSON_SPS0WWV_WT_8812F(x) | BIT_SYSON_SPS0WWV_WT_8812F(v))

#define BIT_SHIFT_SYSON_SPS0LDO_WT_8812F 2
#define BIT_MASK_SYSON_SPS0LDO_WT_8812F 0x3
#define BIT_SYSON_SPS0LDO_WT_8812F(x)                                          \
	(((x) & BIT_MASK_SYSON_SPS0LDO_WT_8812F)                               \
	 << BIT_SHIFT_SYSON_SPS0LDO_WT_8812F)
#define BITS_SYSON_SPS0LDO_WT_8812F                                            \
	(BIT_MASK_SYSON_SPS0LDO_WT_8812F << BIT_SHIFT_SYSON_SPS0LDO_WT_8812F)
#define BIT_CLEAR_SYSON_SPS0LDO_WT_8812F(x)                                    \
	((x) & (~BITS_SYSON_SPS0LDO_WT_8812F))
#define BIT_GET_SYSON_SPS0LDO_WT_8812F(x)                                      \
	(((x) >> BIT_SHIFT_SYSON_SPS0LDO_WT_8812F) &                           \
	 BIT_MASK_SYSON_SPS0LDO_WT_8812F)
#define BIT_SET_SYSON_SPS0LDO_WT_8812F(x, v)                                   \
	(BIT_CLEAR_SYSON_SPS0LDO_WT_8812F(x) | BIT_SYSON_SPS0LDO_WT_8812F(v))

#define BIT_SHIFT_SYSON_RCLK_SCALE_8812F 0
#define BIT_MASK_SYSON_RCLK_SCALE_8812F 0x3
#define BIT_SYSON_RCLK_SCALE_8812F(x)                                          \
	(((x) & BIT_MASK_SYSON_RCLK_SCALE_8812F)                               \
	 << BIT_SHIFT_SYSON_RCLK_SCALE_8812F)
#define BITS_SYSON_RCLK_SCALE_8812F                                            \
	(BIT_MASK_SYSON_RCLK_SCALE_8812F << BIT_SHIFT_SYSON_RCLK_SCALE_8812F)
#define BIT_CLEAR_SYSON_RCLK_SCALE_8812F(x)                                    \
	((x) & (~BITS_SYSON_RCLK_SCALE_8812F))
#define BIT_GET_SYSON_RCLK_SCALE_8812F(x)                                      \
	(((x) >> BIT_SHIFT_SYSON_RCLK_SCALE_8812F) &                           \
	 BIT_MASK_SYSON_RCLK_SCALE_8812F)
#define BIT_SET_SYSON_RCLK_SCALE_8812F(x, v)                                   \
	(BIT_CLEAR_SYSON_RCLK_SCALE_8812F(x) | BIT_SYSON_RCLK_SCALE_8812F(v))

/* 2 REG_CAL_TIMER_8812F */

#define BIT_SHIFT_MATCH_CNT_8812F 8
#define BIT_MASK_MATCH_CNT_8812F 0xff
#define BIT_MATCH_CNT_8812F(x)                                                 \
	(((x) & BIT_MASK_MATCH_CNT_8812F) << BIT_SHIFT_MATCH_CNT_8812F)
#define BITS_MATCH_CNT_8812F                                                   \
	(BIT_MASK_MATCH_CNT_8812F << BIT_SHIFT_MATCH_CNT_8812F)
#define BIT_CLEAR_MATCH_CNT_8812F(x) ((x) & (~BITS_MATCH_CNT_8812F))
#define BIT_GET_MATCH_CNT_8812F(x)                                             \
	(((x) >> BIT_SHIFT_MATCH_CNT_8812F) & BIT_MASK_MATCH_CNT_8812F)
#define BIT_SET_MATCH_CNT_8812F(x, v)                                          \
	(BIT_CLEAR_MATCH_CNT_8812F(x) | BIT_MATCH_CNT_8812F(v))

#define BIT_SHIFT_CAL_SCAL_8812F 0
#define BIT_MASK_CAL_SCAL_8812F 0xff
#define BIT_CAL_SCAL_8812F(x)                                                  \
	(((x) & BIT_MASK_CAL_SCAL_8812F) << BIT_SHIFT_CAL_SCAL_8812F)
#define BITS_CAL_SCAL_8812F                                                    \
	(BIT_MASK_CAL_SCAL_8812F << BIT_SHIFT_CAL_SCAL_8812F)
#define BIT_CLEAR_CAL_SCAL_8812F(x) ((x) & (~BITS_CAL_SCAL_8812F))
#define BIT_GET_CAL_SCAL_8812F(x)                                              \
	(((x) >> BIT_SHIFT_CAL_SCAL_8812F) & BIT_MASK_CAL_SCAL_8812F)
#define BIT_SET_CAL_SCAL_8812F(x, v)                                           \
	(BIT_CLEAR_CAL_SCAL_8812F(x) | BIT_CAL_SCAL_8812F(v))

/* 2 REG_ACLK_MON_8812F */

#define BIT_SHIFT_RCLK_MON_8812F 5
#define BIT_MASK_RCLK_MON_8812F 0x7ff
#define BIT_RCLK_MON_8812F(x)                                                  \
	(((x) & BIT_MASK_RCLK_MON_8812F) << BIT_SHIFT_RCLK_MON_8812F)
#define BITS_RCLK_MON_8812F                                                    \
	(BIT_MASK_RCLK_MON_8812F << BIT_SHIFT_RCLK_MON_8812F)
#define BIT_CLEAR_RCLK_MON_8812F(x) ((x) & (~BITS_RCLK_MON_8812F))
#define BIT_GET_RCLK_MON_8812F(x)                                              \
	(((x) >> BIT_SHIFT_RCLK_MON_8812F) & BIT_MASK_RCLK_MON_8812F)
#define BIT_SET_RCLK_MON_8812F(x, v)                                           \
	(BIT_CLEAR_RCLK_MON_8812F(x) | BIT_RCLK_MON_8812F(v))

#define BIT_CAL_EN_8812F BIT(4)

#define BIT_SHIFT_DPSTU_8812F 2
#define BIT_MASK_DPSTU_8812F 0x3
#define BIT_DPSTU_8812F(x)                                                     \
	(((x) & BIT_MASK_DPSTU_8812F) << BIT_SHIFT_DPSTU_8812F)
#define BITS_DPSTU_8812F (BIT_MASK_DPSTU_8812F << BIT_SHIFT_DPSTU_8812F)
#define BIT_CLEAR_DPSTU_8812F(x) ((x) & (~BITS_DPSTU_8812F))
#define BIT_GET_DPSTU_8812F(x)                                                 \
	(((x) >> BIT_SHIFT_DPSTU_8812F) & BIT_MASK_DPSTU_8812F)
#define BIT_SET_DPSTU_8812F(x, v)                                              \
	(BIT_CLEAR_DPSTU_8812F(x) | BIT_DPSTU_8812F(v))

#define BIT_SUS_16X_8812F BIT(1)

/* 2 REG_GPIO_MUXCFG_2_8812F */
#define BIT_SOUT_GPIO8_8812F BIT(7)
#define BIT_SOUT_GPIO5_8812F BIT(6)
#define BIT_RFE_CTRL_5_GPIO14_V1_8812F BIT(5)
#define BIT_RFE_CTRL_10_GPIO13_V1_8812F BIT(4)
#define BIT_RFE_CTRL_11_GPIO4_V1_8812F BIT(3)
#define BIT_RFE_CTRL_5_GPIO14_8812F BIT(2)
#define BIT_RFE_CTRL_10_GPIO13_8812F BIT(1)
#define BIT_RFE_CTRL_11_GPIO4_8812F BIT(0)

/* 2 REG_GPIO_MUXCFG_8812F */
#define BIT_RFE_CTRL_3_GPIO12_8812F BIT(31)
#define BIT_BT_RFE_CTRL_5_GPIO12_8812F BIT(30)
#define BIT_S0_TRSW_GPIO12_8812F BIT(29)
#define BIT_RFE_CTRL_9_GPIO13_8812F BIT(28)
#define BIT_RFE_CTRL_9_GPIO12_8812F BIT(27)
#define BIT_RFE_CTRL_8_GPIO4_8812F BIT(26)
#define BIT_BT_RFE_CTRL_1_GPIO13_8812F BIT(25)
#define BIT_BT_RFE_CTRL_1_GPIO12_8812F BIT(24)
#define BIT_BT_RFE_CTRL_0_GPIO4_8812F BIT(23)
#define BIT_ANTSW_GPIO13_8812F BIT(22)
#define BIT_ANTSW_GPIO12_8812F BIT(21)
#define BIT_ANTSWB_GPIO4_8812F BIT(20)
#define BIT_FSPI_EN_8812F BIT(19)
#define BIT_WL_RTS_EXT_32K_SEL_8812F BIT(18)
#define BIT_WLBT_DPDT_SEL_EN_8812F BIT(17)
#define BIT_WLBT_LNAON_SEL_EN_8812F BIT(16)
#define BIT_SIC_LBK_8812F BIT(15)
#define BIT_ENHTP_8812F BIT(14)
#define BIT_BT_AOD_GPIO3_8812F BIT(13)
#define BIT_ENSIC_8812F BIT(12)
#define BIT_SIC_SWRST_8812F BIT(11)
#define BIT_PO_WIFI_PTA_PINS_8812F BIT(10)
#define BIT_PO_BT_PTA_PINS_8812F BIT(9)
#define BIT_ENUART_8812F BIT(8)

#define BIT_SHIFT_BTMODE_8812F 6
#define BIT_MASK_BTMODE_8812F 0x3
#define BIT_BTMODE_8812F(x)                                                    \
	(((x) & BIT_MASK_BTMODE_8812F) << BIT_SHIFT_BTMODE_8812F)
#define BITS_BTMODE_8812F (BIT_MASK_BTMODE_8812F << BIT_SHIFT_BTMODE_8812F)
#define BIT_CLEAR_BTMODE_8812F(x) ((x) & (~BITS_BTMODE_8812F))
#define BIT_GET_BTMODE_8812F(x)                                                \
	(((x) >> BIT_SHIFT_BTMODE_8812F) & BIT_MASK_BTMODE_8812F)
#define BIT_SET_BTMODE_8812F(x, v)                                             \
	(BIT_CLEAR_BTMODE_8812F(x) | BIT_BTMODE_8812F(v))

#define BIT_ENBT_8812F BIT(5)
#define BIT_EROM_EN_8812F BIT(4)
#define BIT_WLRFE_6_7_EN_8812F BIT(3)
#define BIT_WLRFE_4_5_EN_8812F BIT(2)

#define BIT_SHIFT_GPIOSEL_8812F 0
#define BIT_MASK_GPIOSEL_8812F 0x3
#define BIT_GPIOSEL_8812F(x)                                                   \
	(((x) & BIT_MASK_GPIOSEL_8812F) << BIT_SHIFT_GPIOSEL_8812F)
#define BITS_GPIOSEL_8812F (BIT_MASK_GPIOSEL_8812F << BIT_SHIFT_GPIOSEL_8812F)
#define BIT_CLEAR_GPIOSEL_8812F(x) ((x) & (~BITS_GPIOSEL_8812F))
#define BIT_GET_GPIOSEL_8812F(x)                                               \
	(((x) >> BIT_SHIFT_GPIOSEL_8812F) & BIT_MASK_GPIOSEL_8812F)
#define BIT_SET_GPIOSEL_8812F(x, v)                                            \
	(BIT_CLEAR_GPIOSEL_8812F(x) | BIT_GPIOSEL_8812F(v))

/* 2 REG_GPIO_PIN_CTRL_8812F */

#define BIT_SHIFT_GPIO_MOD_7_TO_0_8812F 24
#define BIT_MASK_GPIO_MOD_7_TO_0_8812F 0xff
#define BIT_GPIO_MOD_7_TO_0_8812F(x)                                           \
	(((x) & BIT_MASK_GPIO_MOD_7_TO_0_8812F)                                \
	 << BIT_SHIFT_GPIO_MOD_7_TO_0_8812F)
#define BITS_GPIO_MOD_7_TO_0_8812F                                             \
	(BIT_MASK_GPIO_MOD_7_TO_0_8812F << BIT_SHIFT_GPIO_MOD_7_TO_0_8812F)
#define BIT_CLEAR_GPIO_MOD_7_TO_0_8812F(x) ((x) & (~BITS_GPIO_MOD_7_TO_0_8812F))
#define BIT_GET_GPIO_MOD_7_TO_0_8812F(x)                                       \
	(((x) >> BIT_SHIFT_GPIO_MOD_7_TO_0_8812F) &                            \
	 BIT_MASK_GPIO_MOD_7_TO_0_8812F)
#define BIT_SET_GPIO_MOD_7_TO_0_8812F(x, v)                                    \
	(BIT_CLEAR_GPIO_MOD_7_TO_0_8812F(x) | BIT_GPIO_MOD_7_TO_0_8812F(v))

#define BIT_SHIFT_GPIO_IO_SEL_7_TO_0_8812F 16
#define BIT_MASK_GPIO_IO_SEL_7_TO_0_8812F 0xff
#define BIT_GPIO_IO_SEL_7_TO_0_8812F(x)                                        \
	(((x) & BIT_MASK_GPIO_IO_SEL_7_TO_0_8812F)                             \
	 << BIT_SHIFT_GPIO_IO_SEL_7_TO_0_8812F)
#define BITS_GPIO_IO_SEL_7_TO_0_8812F                                          \
	(BIT_MASK_GPIO_IO_SEL_7_TO_0_8812F                                     \
	 << BIT_SHIFT_GPIO_IO_SEL_7_TO_0_8812F)
#define BIT_CLEAR_GPIO_IO_SEL_7_TO_0_8812F(x)                                  \
	((x) & (~BITS_GPIO_IO_SEL_7_TO_0_8812F))
#define BIT_GET_GPIO_IO_SEL_7_TO_0_8812F(x)                                    \
	(((x) >> BIT_SHIFT_GPIO_IO_SEL_7_TO_0_8812F) &                         \
	 BIT_MASK_GPIO_IO_SEL_7_TO_0_8812F)
#define BIT_SET_GPIO_IO_SEL_7_TO_0_8812F(x, v)                                 \
	(BIT_CLEAR_GPIO_IO_SEL_7_TO_0_8812F(x) |                               \
	 BIT_GPIO_IO_SEL_7_TO_0_8812F(v))

#define BIT_SHIFT_GPIO_OUT_7_TO_0_8812F 8
#define BIT_MASK_GPIO_OUT_7_TO_0_8812F 0xff
#define BIT_GPIO_OUT_7_TO_0_8812F(x)                                           \
	(((x) & BIT_MASK_GPIO_OUT_7_TO_0_8812F)                                \
	 << BIT_SHIFT_GPIO_OUT_7_TO_0_8812F)
#define BITS_GPIO_OUT_7_TO_0_8812F                                             \
	(BIT_MASK_GPIO_OUT_7_TO_0_8812F << BIT_SHIFT_GPIO_OUT_7_TO_0_8812F)
#define BIT_CLEAR_GPIO_OUT_7_TO_0_8812F(x) ((x) & (~BITS_GPIO_OUT_7_TO_0_8812F))
#define BIT_GET_GPIO_OUT_7_TO_0_8812F(x)                                       \
	(((x) >> BIT_SHIFT_GPIO_OUT_7_TO_0_8812F) &                            \
	 BIT_MASK_GPIO_OUT_7_TO_0_8812F)
#define BIT_SET_GPIO_OUT_7_TO_0_8812F(x, v)                                    \
	(BIT_CLEAR_GPIO_OUT_7_TO_0_8812F(x) | BIT_GPIO_OUT_7_TO_0_8812F(v))

#define BIT_SHIFT_GPIO_IN_7_TO_0_8812F 0
#define BIT_MASK_GPIO_IN_7_TO_0_8812F 0xff
#define BIT_GPIO_IN_7_TO_0_8812F(x)                                            \
	(((x) & BIT_MASK_GPIO_IN_7_TO_0_8812F)                                 \
	 << BIT_SHIFT_GPIO_IN_7_TO_0_8812F)
#define BITS_GPIO_IN_7_TO_0_8812F                                              \
	(BIT_MASK_GPIO_IN_7_TO_0_8812F << BIT_SHIFT_GPIO_IN_7_TO_0_8812F)
#define BIT_CLEAR_GPIO_IN_7_TO_0_8812F(x) ((x) & (~BITS_GPIO_IN_7_TO_0_8812F))
#define BIT_GET_GPIO_IN_7_TO_0_8812F(x)                                        \
	(((x) >> BIT_SHIFT_GPIO_IN_7_TO_0_8812F) &                             \
	 BIT_MASK_GPIO_IN_7_TO_0_8812F)
#define BIT_SET_GPIO_IN_7_TO_0_8812F(x, v)                                     \
	(BIT_CLEAR_GPIO_IN_7_TO_0_8812F(x) | BIT_GPIO_IN_7_TO_0_8812F(v))

/* 2 REG_GPIO_INTM_8812F */

#define BIT_SHIFT_MUXDBG_SEL_8812F 30
#define BIT_MASK_MUXDBG_SEL_8812F 0x3
#define BIT_MUXDBG_SEL_8812F(x)                                                \
	(((x) & BIT_MASK_MUXDBG_SEL_8812F) << BIT_SHIFT_MUXDBG_SEL_8812F)
#define BITS_MUXDBG_SEL_8812F                                                  \
	(BIT_MASK_MUXDBG_SEL_8812F << BIT_SHIFT_MUXDBG_SEL_8812F)
#define BIT_CLEAR_MUXDBG_SEL_8812F(x) ((x) & (~BITS_MUXDBG_SEL_8812F))
#define BIT_GET_MUXDBG_SEL_8812F(x)                                            \
	(((x) >> BIT_SHIFT_MUXDBG_SEL_8812F) & BIT_MASK_MUXDBG_SEL_8812F)
#define BIT_SET_MUXDBG_SEL_8812F(x, v)                                         \
	(BIT_CLEAR_MUXDBG_SEL_8812F(x) | BIT_MUXDBG_SEL_8812F(v))

#define BIT_EXTWOL_SEL_8812F BIT(17)
#define BIT_EXTWOL_EN_8812F BIT(16)
#define BIT_GPIOF_INT_MD_8812F BIT(15)
#define BIT_GPIOE_INT_MD_8812F BIT(14)
#define BIT_GPIOD_INT_MD_8812F BIT(13)
#define BIT_GPIOF_INT_MD_8812F BIT(15)
#define BIT_GPIOE_INT_MD_8812F BIT(14)
#define BIT_GPIOD_INT_MD_8812F BIT(13)
#define BIT_GPIOC_INT_MD_8812F BIT(12)
#define BIT_GPIOB_INT_MD_8812F BIT(11)
#define BIT_GPIOA_INT_MD_8812F BIT(10)
#define BIT_GPIO9_INT_MD_8812F BIT(9)
#define BIT_GPIO8_INT_MD_8812F BIT(8)
#define BIT_GPIO7_INT_MD_8812F BIT(7)
#define BIT_GPIO6_INT_MD_8812F BIT(6)
#define BIT_GPIO5_INT_MD_8812F BIT(5)
#define BIT_GPIO4_INT_MD_8812F BIT(4)
#define BIT_GPIO3_INT_MD_8812F BIT(3)
#define BIT_GPIO2_INT_MD_8812F BIT(2)
#define BIT_GPIO1_INT_MD_8812F BIT(1)
#define BIT_GPIO0_INT_MD_8812F BIT(0)

/* 2 REG_LED_CFG_8812F */
#define BIT_MAILBOX_1WIRE_GPIO_CFG_8812F BIT(31)
#define BIT_BT_RF_GPIO_CFG_8812F BIT(30)
#define BIT_BT_SDIO_INT_GPIO_CFG_8812F BIT(29)
#define BIT_MAILBOX_3WIRE_GPIO_CFG_8812F BIT(28)
#define BIT_WLBT_PAPE_SEL_EN_8812F BIT(27)
#define BIT_LNAON_SEL_EN_8812F BIT(26)
#define BIT_PAPE_SEL_EN_8812F BIT(25)
#define BIT_DPDT_WLBT_SEL_8812F BIT(24)
#define BIT_DPDT_SEL_EN_8812F BIT(23)
#define BIT_GPIO13_14_WL_CTRL_EN_8812F BIT(22)
#define BIT_LED2DIS_8812F BIT(21)
#define BIT_LED2PL_8812F BIT(20)
#define BIT_LED2SV_8812F BIT(19)

#define BIT_SHIFT_LED2CM_8812F 16
#define BIT_MASK_LED2CM_8812F 0x7
#define BIT_LED2CM_8812F(x)                                                    \
	(((x) & BIT_MASK_LED2CM_8812F) << BIT_SHIFT_LED2CM_8812F)
#define BITS_LED2CM_8812F (BIT_MASK_LED2CM_8812F << BIT_SHIFT_LED2CM_8812F)
#define BIT_CLEAR_LED2CM_8812F(x) ((x) & (~BITS_LED2CM_8812F))
#define BIT_GET_LED2CM_8812F(x)                                                \
	(((x) >> BIT_SHIFT_LED2CM_8812F) & BIT_MASK_LED2CM_8812F)
#define BIT_SET_LED2CM_8812F(x, v)                                             \
	(BIT_CLEAR_LED2CM_8812F(x) | BIT_LED2CM_8812F(v))

#define BIT_LED1DIS_8812F BIT(15)
#define BIT_LED1PL_8812F BIT(12)
#define BIT_LED1SV_8812F BIT(11)

#define BIT_SHIFT_LED1CM_8812F 8
#define BIT_MASK_LED1CM_8812F 0x7
#define BIT_LED1CM_8812F(x)                                                    \
	(((x) & BIT_MASK_LED1CM_8812F) << BIT_SHIFT_LED1CM_8812F)
#define BITS_LED1CM_8812F (BIT_MASK_LED1CM_8812F << BIT_SHIFT_LED1CM_8812F)
#define BIT_CLEAR_LED1CM_8812F(x) ((x) & (~BITS_LED1CM_8812F))
#define BIT_GET_LED1CM_8812F(x)                                                \
	(((x) >> BIT_SHIFT_LED1CM_8812F) & BIT_MASK_LED1CM_8812F)
#define BIT_SET_LED1CM_8812F(x, v)                                             \
	(BIT_CLEAR_LED1CM_8812F(x) | BIT_LED1CM_8812F(v))

#define BIT_LED0DIS_8812F BIT(7)

#define BIT_SHIFT_AFE_LDO_SWR_CHECK_8812F 5
#define BIT_MASK_AFE_LDO_SWR_CHECK_8812F 0x3
#define BIT_AFE_LDO_SWR_CHECK_8812F(x)                                         \
	(((x) & BIT_MASK_AFE_LDO_SWR_CHECK_8812F)                              \
	 << BIT_SHIFT_AFE_LDO_SWR_CHECK_8812F)
#define BITS_AFE_LDO_SWR_CHECK_8812F                                           \
	(BIT_MASK_AFE_LDO_SWR_CHECK_8812F << BIT_SHIFT_AFE_LDO_SWR_CHECK_8812F)
#define BIT_CLEAR_AFE_LDO_SWR_CHECK_8812F(x)                                   \
	((x) & (~BITS_AFE_LDO_SWR_CHECK_8812F))
#define BIT_GET_AFE_LDO_SWR_CHECK_8812F(x)                                     \
	(((x) >> BIT_SHIFT_AFE_LDO_SWR_CHECK_8812F) &                          \
	 BIT_MASK_AFE_LDO_SWR_CHECK_8812F)
#define BIT_SET_AFE_LDO_SWR_CHECK_8812F(x, v)                                  \
	(BIT_CLEAR_AFE_LDO_SWR_CHECK_8812F(x) | BIT_AFE_LDO_SWR_CHECK_8812F(v))

#define BIT_LED0PL_8812F BIT(4)
#define BIT_LED0SV_8812F BIT(3)

#define BIT_SHIFT_LED0CM_8812F 0
#define BIT_MASK_LED0CM_8812F 0x7
#define BIT_LED0CM_8812F(x)                                                    \
	(((x) & BIT_MASK_LED0CM_8812F) << BIT_SHIFT_LED0CM_8812F)
#define BITS_LED0CM_8812F (BIT_MASK_LED0CM_8812F << BIT_SHIFT_LED0CM_8812F)
#define BIT_CLEAR_LED0CM_8812F(x) ((x) & (~BITS_LED0CM_8812F))
#define BIT_GET_LED0CM_8812F(x)                                                \
	(((x) >> BIT_SHIFT_LED0CM_8812F) & BIT_MASK_LED0CM_8812F)
#define BIT_SET_LED0CM_8812F(x, v)                                             \
	(BIT_CLEAR_LED0CM_8812F(x) | BIT_LED0CM_8812F(v))

/* 2 REG_FSIMR_8812F */
#define BIT_FS_PDNINT_EN_8812F BIT(31)
#define BIT_FS_SPS_OCP_INT_EN_8812F BIT(29)
#define BIT_FS_PWMERR_INT_EN_8812F BIT(28)
#define BIT_FS_GPIOF_INT_EN_8812F BIT(27)
#define BIT_FS_GPIOE_INT_EN_8812F BIT(26)
#define BIT_FS_GPIOD_INT_EN_8812F BIT(25)
#define BIT_FS_GPIOC_INT_EN_8812F BIT(24)
#define BIT_FS_GPIOB_INT_EN_8812F BIT(23)
#define BIT_FS_GPIOA_INT_EN_8812F BIT(22)
#define BIT_FS_GPIO9_INT_EN_8812F BIT(21)
#define BIT_FS_GPIO8_INT_EN_8812F BIT(20)
#define BIT_FS_GPIO7_INT_EN_8812F BIT(19)
#define BIT_FS_GPIO6_INT_EN_8812F BIT(18)
#define BIT_FS_GPIO5_INT_EN_8812F BIT(17)
#define BIT_FS_GPIO4_INT_EN_8812F BIT(16)
#define BIT_FS_GPIO3_INT_EN_8812F BIT(15)
#define BIT_FS_GPIO2_INT_EN_8812F BIT(14)
#define BIT_FS_GPIO1_INT_EN_8812F BIT(13)
#define BIT_FS_GPIO0_INT_EN_8812F BIT(12)
#define BIT_FS_HCI_SUS_EN_8812F BIT(11)
#define BIT_FS_HCI_RES_EN_8812F BIT(10)
#define BIT_FS_HCI_RESET_EN_8812F BIT(9)
#define BIT_USB_SCSI_CMD_EN_8812F BIT(8)
#define BIT_FS_BTON_STS_UPDATE_MSK_EN_8812F BIT(7)
#define BIT_ACT2RECOVERY_INT_EN_V1_8812F BIT(6)
#define BIT_GEN1GEN2_SWITCH_8812F BIT(5)
#define BIT_HCI_TXDMA_REQ_HIMR_8812F BIT(4)
#define BIT_FS_32K_LEAVE_SETTING_MAK_8812F BIT(3)
#define BIT_FS_32K_ENTER_SETTING_MAK_8812F BIT(2)
#define BIT_FS_USB_LPMRSM_MSK_8812F BIT(1)
#define BIT_FS_USB_LPMINT_MSK_8812F BIT(0)

/* 2 REG_FSISR_8812F */
#define BIT_FS_PDNINT_8812F BIT(31)
#define BIT_FS_SPS_OCP_INT_8812F BIT(29)
#define BIT_FS_PWMERR_INT_8812F BIT(28)
#define BIT_FS_GPIOF_INT_8812F BIT(27)
#define BIT_FS_GPIOE_INT_8812F BIT(26)
#define BIT_FS_GPIOD_INT_8812F BIT(25)
#define BIT_FS_GPIOC_INT_8812F BIT(24)
#define BIT_FS_GPIOB_INT_8812F BIT(23)
#define BIT_FS_GPIOA_INT_8812F BIT(22)
#define BIT_FS_GPIO9_INT_8812F BIT(21)
#define BIT_FS_GPIO8_INT_8812F BIT(20)
#define BIT_FS_GPIO7_INT_8812F BIT(19)
#define BIT_FS_GPIO6_INT_8812F BIT(18)
#define BIT_FS_GPIO5_INT_8812F BIT(17)
#define BIT_FS_GPIO4_INT_8812F BIT(16)
#define BIT_FS_GPIO3_INT_8812F BIT(15)
#define BIT_FS_GPIO2_INT_8812F BIT(14)
#define BIT_FS_GPIO1_INT_8812F BIT(13)
#define BIT_FS_GPIO0_INT_8812F BIT(12)
#define BIT_FS_HCI_SUS_INT_8812F BIT(11)
#define BIT_FS_HCI_RES_INT_8812F BIT(10)
#define BIT_FS_HCI_RESET_INT_8812F BIT(9)
#define BIT_USB_SCSI_CMD_INT_8812F BIT(8)
#define BIT_ACT2RECOVERY_8812F BIT(6)
#define BIT_GEN1GEN2_SWITCH_8812F BIT(5)
#define BIT_HCI_TXDMA_REQ_HISR_8812F BIT(4)
#define BIT_FS_32K_LEAVE_SETTING_INT_8812F BIT(3)
#define BIT_FS_32K_ENTER_SETTING_INT_8812F BIT(2)
#define BIT_FS_USB_LPMRSM_INT_8812F BIT(1)
#define BIT_FS_USB_LPMINT_INT_8812F BIT(0)

/* 2 REG_HSIMR_8812F */
#define BIT_GPIOF_INT_EN_8812F BIT(31)
#define BIT_GPIOE_INT_EN_8812F BIT(30)
#define BIT_GPIOD_INT_EN_8812F BIT(29)
#define BIT_GPIOC_INT_EN_8812F BIT(28)
#define BIT_GPIOB_INT_EN_8812F BIT(27)
#define BIT_GPIOA_INT_EN_8812F BIT(26)
#define BIT_GPIO9_INT_EN_8812F BIT(25)
#define BIT_GPIO8_INT_EN_8812F BIT(24)
#define BIT_GPIO7_INT_EN_8812F BIT(23)
#define BIT_GPIO6_INT_EN_8812F BIT(22)
#define BIT_GPIO5_INT_EN_8812F BIT(21)
#define BIT_GPIO4_INT_EN_8812F BIT(20)
#define BIT_GPIO3_INT_EN_8812F BIT(19)
#define BIT_GPIO2_INT_EN_V1_8812F BIT(18)
#define BIT_GPIO1_INT_EN_8812F BIT(17)
#define BIT_GPIO0_INT_EN_8812F BIT(16)
#define BIT_PDNINT_EN_8812F BIT(7)
#define BIT_RON_INT_EN_8812F BIT(6)
#define BIT_SPS_OCP_INT_EN_8812F BIT(5)
#define BIT_GPIO15_0_INT_EN_8812F BIT(0)

/* 2 REG_HSISR_8812F */
#define BIT_GPIOF_INT_8812F BIT(31)
#define BIT_GPIOE_INT_8812F BIT(30)
#define BIT_GPIOD_INT_8812F BIT(29)
#define BIT_GPIOC_INT_8812F BIT(28)
#define BIT_GPIOB_INT_8812F BIT(27)
#define BIT_GPIOA_INT_8812F BIT(26)
#define BIT_GPIO9_INT_8812F BIT(25)
#define BIT_GPIO8_INT_8812F BIT(24)
#define BIT_GPIO7_INT_8812F BIT(23)
#define BIT_GPIO6_INT_8812F BIT(22)
#define BIT_GPIO5_INT_8812F BIT(21)
#define BIT_GPIO4_INT_8812F BIT(20)
#define BIT_GPIO3_INT_8812F BIT(19)
#define BIT_GPIO2_INT_V1_8812F BIT(18)
#define BIT_GPIO1_INT_8812F BIT(17)
#define BIT_GPIO0_INT_8812F BIT(16)
#define BIT_PDNINT_8812F BIT(7)
#define BIT_RON_INT_8812F BIT(6)
#define BIT_SPS_OCP_INT_8812F BIT(5)
#define BIT_GPIO15_0_INT_8812F BIT(0)

/* 2 REG_GPIO_EXT_CTRL_8812F */

#define BIT_SHIFT_GPIO_MOD_15_TO_8_8812F 24
#define BIT_MASK_GPIO_MOD_15_TO_8_8812F 0xff
#define BIT_GPIO_MOD_15_TO_8_8812F(x)                                          \
	(((x) & BIT_MASK_GPIO_MOD_15_TO_8_8812F)                               \
	 << BIT_SHIFT_GPIO_MOD_15_TO_8_8812F)
#define BITS_GPIO_MOD_15_TO_8_8812F                                            \
	(BIT_MASK_GPIO_MOD_15_TO_8_8812F << BIT_SHIFT_GPIO_MOD_15_TO_8_8812F)
#define BIT_CLEAR_GPIO_MOD_15_TO_8_8812F(x)                                    \
	((x) & (~BITS_GPIO_MOD_15_TO_8_8812F))
#define BIT_GET_GPIO_MOD_15_TO_8_8812F(x)                                      \
	(((x) >> BIT_SHIFT_GPIO_MOD_15_TO_8_8812F) &                           \
	 BIT_MASK_GPIO_MOD_15_TO_8_8812F)
#define BIT_SET_GPIO_MOD_15_TO_8_8812F(x, v)                                   \
	(BIT_CLEAR_GPIO_MOD_15_TO_8_8812F(x) | BIT_GPIO_MOD_15_TO_8_8812F(v))

#define BIT_SHIFT_GPIO_IO_SEL_15_TO_8_8812F 16
#define BIT_MASK_GPIO_IO_SEL_15_TO_8_8812F 0xff
#define BIT_GPIO_IO_SEL_15_TO_8_8812F(x)                                       \
	(((x) & BIT_MASK_GPIO_IO_SEL_15_TO_8_8812F)                            \
	 << BIT_SHIFT_GPIO_IO_SEL_15_TO_8_8812F)
#define BITS_GPIO_IO_SEL_15_TO_8_8812F                                         \
	(BIT_MASK_GPIO_IO_SEL_15_TO_8_8812F                                    \
	 << BIT_SHIFT_GPIO_IO_SEL_15_TO_8_8812F)
#define BIT_CLEAR_GPIO_IO_SEL_15_TO_8_8812F(x)                                 \
	((x) & (~BITS_GPIO_IO_SEL_15_TO_8_8812F))
#define BIT_GET_GPIO_IO_SEL_15_TO_8_8812F(x)                                   \
	(((x) >> BIT_SHIFT_GPIO_IO_SEL_15_TO_8_8812F) &                        \
	 BIT_MASK_GPIO_IO_SEL_15_TO_8_8812F)
#define BIT_SET_GPIO_IO_SEL_15_TO_8_8812F(x, v)                                \
	(BIT_CLEAR_GPIO_IO_SEL_15_TO_8_8812F(x) |                              \
	 BIT_GPIO_IO_SEL_15_TO_8_8812F(v))

#define BIT_SHIFT_GPIO_OUT_15_TO_8_8812F 8
#define BIT_MASK_GPIO_OUT_15_TO_8_8812F 0xff
#define BIT_GPIO_OUT_15_TO_8_8812F(x)                                          \
	(((x) & BIT_MASK_GPIO_OUT_15_TO_8_8812F)                               \
	 << BIT_SHIFT_GPIO_OUT_15_TO_8_8812F)
#define BITS_GPIO_OUT_15_TO_8_8812F                                            \
	(BIT_MASK_GPIO_OUT_15_TO_8_8812F << BIT_SHIFT_GPIO_OUT_15_TO_8_8812F)
#define BIT_CLEAR_GPIO_OUT_15_TO_8_8812F(x)                                    \
	((x) & (~BITS_GPIO_OUT_15_TO_8_8812F))
#define BIT_GET_GPIO_OUT_15_TO_8_8812F(x)                                      \
	(((x) >> BIT_SHIFT_GPIO_OUT_15_TO_8_8812F) &                           \
	 BIT_MASK_GPIO_OUT_15_TO_8_8812F)
#define BIT_SET_GPIO_OUT_15_TO_8_8812F(x, v)                                   \
	(BIT_CLEAR_GPIO_OUT_15_TO_8_8812F(x) | BIT_GPIO_OUT_15_TO_8_8812F(v))

#define BIT_SHIFT_GPIO_IN_15_TO_8_8812F 0
#define BIT_MASK_GPIO_IN_15_TO_8_8812F 0xff
#define BIT_GPIO_IN_15_TO_8_8812F(x)                                           \
	(((x) & BIT_MASK_GPIO_IN_15_TO_8_8812F)                                \
	 << BIT_SHIFT_GPIO_IN_15_TO_8_8812F)
#define BITS_GPIO_IN_15_TO_8_8812F                                             \
	(BIT_MASK_GPIO_IN_15_TO_8_8812F << BIT_SHIFT_GPIO_IN_15_TO_8_8812F)
#define BIT_CLEAR_GPIO_IN_15_TO_8_8812F(x) ((x) & (~BITS_GPIO_IN_15_TO_8_8812F))
#define BIT_GET_GPIO_IN_15_TO_8_8812F(x)                                       \
	(((x) >> BIT_SHIFT_GPIO_IN_15_TO_8_8812F) &                            \
	 BIT_MASK_GPIO_IN_15_TO_8_8812F)
#define BIT_SET_GPIO_IN_15_TO_8_8812F(x, v)                                    \
	(BIT_CLEAR_GPIO_IN_15_TO_8_8812F(x) | BIT_GPIO_IN_15_TO_8_8812F(v))

/* 2 REG_PAD_CTRL1_8812F */
#define BIT_PAPE_WLBT_SEL_8812F BIT(29)
#define BIT_LNAON_WLBT_SEL_8812F BIT(28)
#define BIT_BT_BQB_GPIO_SEL_8812F BIT(27)
#define BIT_BTGP_GPG3_FEN_8812F BIT(26)
#define BIT_BTGP_GPG2_FEN_8812F BIT(25)
#define BIT_BTGP_JTAG_EN_8812F BIT(24)
#define BIT_XTAL_CLK_EXTARNAL_EN_8812F BIT(23)
#define BIT_BTGP_UART0_EN_8812F BIT(22)
#define BIT_BTGP_UART1_EN_8812F BIT(21)
#define BIT_BTGP_SPI_EN_8812F BIT(20)
#define BIT_BTGP_GPIO_E2_8812F BIT(19)
#define BIT_BTGP_GPIO_EN_8812F BIT(18)

#define BIT_SHIFT_BTGP_GPIO_SL_8812F 16
#define BIT_MASK_BTGP_GPIO_SL_8812F 0x3
#define BIT_BTGP_GPIO_SL_8812F(x)                                              \
	(((x) & BIT_MASK_BTGP_GPIO_SL_8812F) << BIT_SHIFT_BTGP_GPIO_SL_8812F)
#define BITS_BTGP_GPIO_SL_8812F                                                \
	(BIT_MASK_BTGP_GPIO_SL_8812F << BIT_SHIFT_BTGP_GPIO_SL_8812F)
#define BIT_CLEAR_BTGP_GPIO_SL_8812F(x) ((x) & (~BITS_BTGP_GPIO_SL_8812F))
#define BIT_GET_BTGP_GPIO_SL_8812F(x)                                          \
	(((x) >> BIT_SHIFT_BTGP_GPIO_SL_8812F) & BIT_MASK_BTGP_GPIO_SL_8812F)
#define BIT_SET_BTGP_GPIO_SL_8812F(x, v)                                       \
	(BIT_CLEAR_BTGP_GPIO_SL_8812F(x) | BIT_BTGP_GPIO_SL_8812F(v))

#define BIT_PAD_SDIO_SR_8812F BIT(14)
#define BIT_GPIO14_OUTPUT_PL_8812F BIT(13)
#define BIT_HOST_WAKE_PAD_PULL_EN_8812F BIT(12)
#define BIT_HOST_WAKE_PAD_SL_8812F BIT(11)
#define BIT_PAD_LNAON_SR_8812F BIT(10)
#define BIT_PAD_LNAON_E2_8812F BIT(9)
#define BIT_SW_LNAON_G_SEL_DATA_8812F BIT(8)
#define BIT_SW_LNAON_A_SEL_DATA_8812F BIT(7)
#define BIT_PAD_PAPE_SR_8812F BIT(6)
#define BIT_PAD_PAPE_E2_8812F BIT(5)
#define BIT_SW_PAPE_G_SEL_DATA_8812F BIT(4)
#define BIT_SW_PAPE_A_SEL_DATA_8812F BIT(3)
#define BIT_PAD_DPDT_SR_8812F BIT(2)
#define BIT_PAD_DPDT_PAD_E2_8812F BIT(1)
#define BIT_SW_DPDT_SEL_DATA_8812F BIT(0)

/* 2 REG_WL_BT_PWR_CTRL_8812F */
#define BIT_ISO_BD2PP_8812F BIT(31)
#define BIT_LDOV12B_EN_8812F BIT(30)
#define BIT_CKEN_BTGPS_8812F BIT(29)
#define BIT_FEN_BTGPS_8812F BIT(28)
#define BIT_BTCPU_BOOTSEL_8812F BIT(27)
#define BIT_SPI_SPEEDUP_8812F BIT(26)
#define BIT_BT_LDO_MODE_8812F BIT(25)
#define BIT_DEVWAKE_PAD_TYPE_SEL_8812F BIT(24)
#define BIT_CLKREQ_PAD_TYPE_SEL_8812F BIT(23)
#define BIT_ISO_BTPON2PP_8812F BIT(22)
#define BIT_BT_HWROF_EN_8812F BIT(19)
#define BIT_BT_FUNC_EN_8812F BIT(18)
#define BIT_BT_HWPDN_SL_8812F BIT(17)
#define BIT_BT_DISN_EN_8812F BIT(16)
#define BIT_BT_PDN_PULL_EN_8812F BIT(15)
#define BIT_WL_PDN_PULL_EN_8812F BIT(14)
#define BIT_EXTERNAL_REQUEST_PL_8812F BIT(13)
#define BIT_GPIO0_2_3_PULL_LOW_EN_8812F BIT(12)
#define BIT_ISO_BA2PP_8812F BIT(11)
#define BIT_BT_AFE_LDO_EN_8812F BIT(10)
#define BIT_BT_AFE_PLL_EN_8812F BIT(9)
#define BIT_BT_DIG_CLK_EN_8812F BIT(8)
#define BIT_WLAN_32K_SEL_8812F BIT(6)
#define BIT_WL_DRV_EXIST_IDX_8812F BIT(5)
#define BIT_DOP_EHPAD_8812F BIT(4)
#define BIT_WL_HWROF_EN_8812F BIT(3)
#define BIT_WL_FUNC_EN_8812F BIT(2)
#define BIT_WL_HWPDN_SL_8812F BIT(1)
#define BIT_WL_HWPDN_EN_8812F BIT(0)

/* 2 REG_SDM_DEBUG_8812F */
#define BIT_GPIO_IE_V18_8812F BIT(10)
#define BIT_PCIE_IE_V18_8812F BIT(9)
#define BIT_UART_IE_V18_8812F BIT(8)

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_WLCLK_PHASE_8812F 0
#define BIT_MASK_WLCLK_PHASE_8812F 0x1f
#define BIT_WLCLK_PHASE_8812F(x)                                               \
	(((x) & BIT_MASK_WLCLK_PHASE_8812F) << BIT_SHIFT_WLCLK_PHASE_8812F)
#define BITS_WLCLK_PHASE_8812F                                                 \
	(BIT_MASK_WLCLK_PHASE_8812F << BIT_SHIFT_WLCLK_PHASE_8812F)
#define BIT_CLEAR_WLCLK_PHASE_8812F(x) ((x) & (~BITS_WLCLK_PHASE_8812F))
#define BIT_GET_WLCLK_PHASE_8812F(x)                                           \
	(((x) >> BIT_SHIFT_WLCLK_PHASE_8812F) & BIT_MASK_WLCLK_PHASE_8812F)
#define BIT_SET_WLCLK_PHASE_8812F(x, v)                                        \
	(BIT_CLEAR_WLCLK_PHASE_8812F(x) | BIT_WLCLK_PHASE_8812F(v))

/* 2 REG_SYS_SDIO_CTRL_8812F */
#define BIT_DBG_GNT_WL_BT_8812F BIT(27)
#define BIT_LTE_MUX_CTRL_PATH_8812F BIT(26)
#define BIT_LTE_COEX_UART_8812F BIT(25)
#define BIT_3W_LTE_WL_GPIO_8812F BIT(24)
#define BIT_SDIO_INT_POLARITY_8812F BIT(19)
#define BIT_SDIO_INT_8812F BIT(18)
#define BIT_SDIO_OFF_EN_8812F BIT(17)
#define BIT_SDIO_ON_EN_8812F BIT(16)
#define BIT_PCIE_FORCE_PWR_NGAT_8812F BIT(13)
#define BIT_PCIE_CALIB_EN_V1_8812F BIT(12)
#define BIT_PAGE3_AUXCLK_GATE_8812F BIT(11)
#define BIT_PCIE_WAIT_TIMEOUT_EVENT_8812F BIT(10)
#define BIT_PCIE_WAIT_TIME_8812F BIT(9)
#define BIT_MPCIE_REFCLK_XTAL_SEL_8812F BIT(8)
#define BIT_BT_CTRL_USB_PWR_BACKDOOR_8812F BIT(5)
#define BIT_USB_D_STATE_HOLD_8812F BIT(4)
#define BIT_REG_FORCE_DP_8812F BIT(3)
#define BIT_REG_DP_MODE_8812F BIT(2)
#define BIT_RES_USB_MASS_STORAGE_DESC_8812F BIT(1)
#define BIT_USB_WAIT_TIME_8812F BIT(0)

/* 2 REG_HCI_OPT_CTRL_8812F */

#define BIT_SHIFT_TSFT_SEL_8812F 29
#define BIT_MASK_TSFT_SEL_8812F 0x7
#define BIT_TSFT_SEL_8812F(x)                                                  \
	(((x) & BIT_MASK_TSFT_SEL_8812F) << BIT_SHIFT_TSFT_SEL_8812F)
#define BITS_TSFT_SEL_8812F                                                    \
	(BIT_MASK_TSFT_SEL_8812F << BIT_SHIFT_TSFT_SEL_8812F)
#define BIT_CLEAR_TSFT_SEL_8812F(x) ((x) & (~BITS_TSFT_SEL_8812F))
#define BIT_GET_TSFT_SEL_8812F(x)                                              \
	(((x) >> BIT_SHIFT_TSFT_SEL_8812F) & BIT_MASK_TSFT_SEL_8812F)
#define BIT_SET_TSFT_SEL_8812F(x, v)                                           \
	(BIT_CLEAR_TSFT_SEL_8812F(x) | BIT_TSFT_SEL_8812F(v))

#define BIT_SDIO_PAD_E5_8812F BIT(18)
#define BIT_USB_HOST_PWR_OFF_EN_8812F BIT(12)
#define BIT_SYM_LPS_BLOCK_EN_8812F BIT(11)
#define BIT_USB_LPM_ACT_EN_8812F BIT(10)
#define BIT_USB_LPM_NY_8812F BIT(9)
#define BIT_USB_SUS_DIS_8812F BIT(8)

#define BIT_SHIFT_SDIO_PAD_E_8812F 5
#define BIT_MASK_SDIO_PAD_E_8812F 0x7
#define BIT_SDIO_PAD_E_8812F(x)                                                \
	(((x) & BIT_MASK_SDIO_PAD_E_8812F) << BIT_SHIFT_SDIO_PAD_E_8812F)
#define BITS_SDIO_PAD_E_8812F                                                  \
	(BIT_MASK_SDIO_PAD_E_8812F << BIT_SHIFT_SDIO_PAD_E_8812F)
#define BIT_CLEAR_SDIO_PAD_E_8812F(x) ((x) & (~BITS_SDIO_PAD_E_8812F))
#define BIT_GET_SDIO_PAD_E_8812F(x)                                            \
	(((x) >> BIT_SHIFT_SDIO_PAD_E_8812F) & BIT_MASK_SDIO_PAD_E_8812F)
#define BIT_SET_SDIO_PAD_E_8812F(x, v)                                         \
	(BIT_CLEAR_SDIO_PAD_E_8812F(x) | BIT_SDIO_PAD_E_8812F(v))

#define BIT_USB_LPPLL_EN_8812F BIT(4)
#define BIT_USB1_1_USB2_0_DECISION_8812F BIT(3)
#define BIT_ROP_SW15_8812F BIT(2)
#define BIT_PCI_CKRDY_OPT_8812F BIT(1)
#define BIT_PCI_VAUX_EN_8812F BIT(0)

/* 2 REG_HCI_BG_CTRL_8812F */

/* 2 REG_NOT_VALID_8812F */
#define BIT_IBX_EN_VALUE_8812F BIT(9)
#define BIT_IB_EN_VALUE_8812F BIT(8)

/* 2 REG_NOT_VALID_8812F */
#define BIT_FORCED_IB_EN_8812F BIT(4)
#define BIT_EN_REGBG_8812F BIT(3)
#define BIT_REG_BG_LPF_8812F BIT(2)

#define BIT_SHIFT_REG_BG_8812F 0
#define BIT_MASK_REG_BG_8812F 0x3
#define BIT_REG_BG_8812F(x)                                                    \
	(((x) & BIT_MASK_REG_BG_8812F) << BIT_SHIFT_REG_BG_8812F)
#define BITS_REG_BG_8812F (BIT_MASK_REG_BG_8812F << BIT_SHIFT_REG_BG_8812F)
#define BIT_CLEAR_REG_BG_8812F(x) ((x) & (~BITS_REG_BG_8812F))
#define BIT_GET_REG_BG_8812F(x)                                                \
	(((x) >> BIT_SHIFT_REG_BG_8812F) & BIT_MASK_REG_BG_8812F)
#define BIT_SET_REG_BG_8812F(x, v)                                             \
	(BIT_CLEAR_REG_BG_8812F(x) | BIT_REG_BG_8812F(v))

/* 2 REG_HCI_LDO_CTRL_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */
#define BIT_EN_LW_PWR_8812F BIT(6)
#define BIT_EN_REGU_8812F BIT(5)
#define BIT_EN_PC_8812F BIT(4)

#define BIT_SHIFT_REG_VADJ_8812F 0
#define BIT_MASK_REG_VADJ_8812F 0xf
#define BIT_REG_VADJ_8812F(x)                                                  \
	(((x) & BIT_MASK_REG_VADJ_8812F) << BIT_SHIFT_REG_VADJ_8812F)
#define BITS_REG_VADJ_8812F                                                    \
	(BIT_MASK_REG_VADJ_8812F << BIT_SHIFT_REG_VADJ_8812F)
#define BIT_CLEAR_REG_VADJ_8812F(x) ((x) & (~BITS_REG_VADJ_8812F))
#define BIT_GET_REG_VADJ_8812F(x)                                              \
	(((x) >> BIT_SHIFT_REG_VADJ_8812F) & BIT_MASK_REG_VADJ_8812F)
#define BIT_SET_REG_VADJ_8812F(x, v)                                           \
	(BIT_CLEAR_REG_VADJ_8812F(x) | BIT_REG_VADJ_8812F(v))

/* 2 REG_LDO_SWR_CTRL_8812F */
#define BIT_EXT_SWR_CTRL_EN_8812F BIT(31)
#define BIT_ZCD_HW_AUTO_EN_8812F BIT(27)
#define BIT_ZCD_REGSEL_8812F BIT(26)

#define BIT_SHIFT_AUTO_ZCD_IN_CODE_8812F 21
#define BIT_MASK_AUTO_ZCD_IN_CODE_8812F 0x1f
#define BIT_AUTO_ZCD_IN_CODE_8812F(x)                                          \
	(((x) & BIT_MASK_AUTO_ZCD_IN_CODE_8812F)                               \
	 << BIT_SHIFT_AUTO_ZCD_IN_CODE_8812F)
#define BITS_AUTO_ZCD_IN_CODE_8812F                                            \
	(BIT_MASK_AUTO_ZCD_IN_CODE_8812F << BIT_SHIFT_AUTO_ZCD_IN_CODE_8812F)
#define BIT_CLEAR_AUTO_ZCD_IN_CODE_8812F(x)                                    \
	((x) & (~BITS_AUTO_ZCD_IN_CODE_8812F))
#define BIT_GET_AUTO_ZCD_IN_CODE_8812F(x)                                      \
	(((x) >> BIT_SHIFT_AUTO_ZCD_IN_CODE_8812F) &                           \
	 BIT_MASK_AUTO_ZCD_IN_CODE_8812F)
#define BIT_SET_AUTO_ZCD_IN_CODE_8812F(x, v)                                   \
	(BIT_CLEAR_AUTO_ZCD_IN_CODE_8812F(x) | BIT_AUTO_ZCD_IN_CODE_8812F(v))

#define BIT_SHIFT_ZCD_CODE_IN_L_8812F 16
#define BIT_MASK_ZCD_CODE_IN_L_8812F 0x1f
#define BIT_ZCD_CODE_IN_L_8812F(x)                                             \
	(((x) & BIT_MASK_ZCD_CODE_IN_L_8812F) << BIT_SHIFT_ZCD_CODE_IN_L_8812F)
#define BITS_ZCD_CODE_IN_L_8812F                                               \
	(BIT_MASK_ZCD_CODE_IN_L_8812F << BIT_SHIFT_ZCD_CODE_IN_L_8812F)
#define BIT_CLEAR_ZCD_CODE_IN_L_8812F(x) ((x) & (~BITS_ZCD_CODE_IN_L_8812F))
#define BIT_GET_ZCD_CODE_IN_L_8812F(x)                                         \
	(((x) >> BIT_SHIFT_ZCD_CODE_IN_L_8812F) & BIT_MASK_ZCD_CODE_IN_L_8812F)
#define BIT_SET_ZCD_CODE_IN_L_8812F(x, v)                                      \
	(BIT_CLEAR_ZCD_CODE_IN_L_8812F(x) | BIT_ZCD_CODE_IN_L_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_MCUFW_CTRL_8812F */

#define BIT_SHIFT_RPWM_8812F 24
#define BIT_MASK_RPWM_8812F 0xff
#define BIT_RPWM_8812F(x) (((x) & BIT_MASK_RPWM_8812F) << BIT_SHIFT_RPWM_8812F)
#define BITS_RPWM_8812F (BIT_MASK_RPWM_8812F << BIT_SHIFT_RPWM_8812F)
#define BIT_CLEAR_RPWM_8812F(x) ((x) & (~BITS_RPWM_8812F))
#define BIT_GET_RPWM_8812F(x)                                                  \
	(((x) >> BIT_SHIFT_RPWM_8812F) & BIT_MASK_RPWM_8812F)
#define BIT_SET_RPWM_8812F(x, v) (BIT_CLEAR_RPWM_8812F(x) | BIT_RPWM_8812F(v))

#define BIT_ANA_PORT_EN_8812F BIT(22)
#define BIT_MAC_PORT_EN_8812F BIT(21)
#define BIT_BOOT_FSPI_EN_8812F BIT(20)
#define BIT_ROM_DLEN_8812F BIT(19)

#define BIT_SHIFT_ROM_PGE_8812F 16
#define BIT_MASK_ROM_PGE_8812F 0x7
#define BIT_ROM_PGE_8812F(x)                                                   \
	(((x) & BIT_MASK_ROM_PGE_8812F) << BIT_SHIFT_ROM_PGE_8812F)
#define BITS_ROM_PGE_8812F (BIT_MASK_ROM_PGE_8812F << BIT_SHIFT_ROM_PGE_8812F)
#define BIT_CLEAR_ROM_PGE_8812F(x) ((x) & (~BITS_ROM_PGE_8812F))
#define BIT_GET_ROM_PGE_8812F(x)                                               \
	(((x) >> BIT_SHIFT_ROM_PGE_8812F) & BIT_MASK_ROM_PGE_8812F)
#define BIT_SET_ROM_PGE_8812F(x, v)                                            \
	(BIT_CLEAR_ROM_PGE_8812F(x) | BIT_ROM_PGE_8812F(v))

#define BIT_FW_INIT_RDY_8812F BIT(15)
#define BIT_FW_DW_RDY_8812F BIT(14)

#define BIT_SHIFT_CPU_CLK_SEL_8812F 12
#define BIT_MASK_CPU_CLK_SEL_8812F 0x3
#define BIT_CPU_CLK_SEL_8812F(x)                                               \
	(((x) & BIT_MASK_CPU_CLK_SEL_8812F) << BIT_SHIFT_CPU_CLK_SEL_8812F)
#define BITS_CPU_CLK_SEL_8812F                                                 \
	(BIT_MASK_CPU_CLK_SEL_8812F << BIT_SHIFT_CPU_CLK_SEL_8812F)
#define BIT_CLEAR_CPU_CLK_SEL_8812F(x) ((x) & (~BITS_CPU_CLK_SEL_8812F))
#define BIT_GET_CPU_CLK_SEL_8812F(x)                                           \
	(((x) >> BIT_SHIFT_CPU_CLK_SEL_8812F) & BIT_MASK_CPU_CLK_SEL_8812F)
#define BIT_SET_CPU_CLK_SEL_8812F(x, v)                                        \
	(BIT_CLEAR_CPU_CLK_SEL_8812F(x) | BIT_CPU_CLK_SEL_8812F(v))

#define BIT_CCLK_CHG_MASK_8812F BIT(11)
#define BIT_EMEM__TXBUF_CHKSUM_OK_8812F BIT(10)
#define BIT_EMEM_TXBUF_DW_RDY_8812F BIT(9)
#define BIT_EMEM_CHKSUM_OK_8812F BIT(8)
#define BIT_EMEM_DW_OK_8812F BIT(7)
#define BIT_DMEM_CHKSUM_OK_8812F BIT(6)
#define BIT_DMEM_DW_OK_8812F BIT(5)
#define BIT_IMEM_CHKSUM_OK_8812F BIT(4)
#define BIT_IMEM_DW_OK_8812F BIT(3)
#define BIT_IMEM_BOOT_LOAD_CHKSUM_OK_8812F BIT(2)
#define BIT_IMEM_BOOT_LOAD_DW_OK_8812F BIT(1)
#define BIT_MCUFWDL_EN_8812F BIT(0)

/* 2 REG_MCU_TST_CFG_8812F */

#define BIT_SHIFT_LBKTST_8812F 0
#define BIT_MASK_LBKTST_8812F 0xffff
#define BIT_LBKTST_8812F(x)                                                    \
	(((x) & BIT_MASK_LBKTST_8812F) << BIT_SHIFT_LBKTST_8812F)
#define BITS_LBKTST_8812F (BIT_MASK_LBKTST_8812F << BIT_SHIFT_LBKTST_8812F)
#define BIT_CLEAR_LBKTST_8812F(x) ((x) & (~BITS_LBKTST_8812F))
#define BIT_GET_LBKTST_8812F(x)                                                \
	(((x) >> BIT_SHIFT_LBKTST_8812F) & BIT_MASK_LBKTST_8812F)
#define BIT_SET_LBKTST_8812F(x, v)                                             \
	(BIT_CLEAR_LBKTST_8812F(x) | BIT_LBKTST_8812F(v))

/* 2 REG_HMEBOX_E0_E1_8812F */

#define BIT_SHIFT_HOST_MSG_E1_8812F 16
#define BIT_MASK_HOST_MSG_E1_8812F 0xffff
#define BIT_HOST_MSG_E1_8812F(x)                                               \
	(((x) & BIT_MASK_HOST_MSG_E1_8812F) << BIT_SHIFT_HOST_MSG_E1_8812F)
#define BITS_HOST_MSG_E1_8812F                                                 \
	(BIT_MASK_HOST_MSG_E1_8812F << BIT_SHIFT_HOST_MSG_E1_8812F)
#define BIT_CLEAR_HOST_MSG_E1_8812F(x) ((x) & (~BITS_HOST_MSG_E1_8812F))
#define BIT_GET_HOST_MSG_E1_8812F(x)                                           \
	(((x) >> BIT_SHIFT_HOST_MSG_E1_8812F) & BIT_MASK_HOST_MSG_E1_8812F)
#define BIT_SET_HOST_MSG_E1_8812F(x, v)                                        \
	(BIT_CLEAR_HOST_MSG_E1_8812F(x) | BIT_HOST_MSG_E1_8812F(v))

#define BIT_SHIFT_HOST_MSG_E0_8812F 0
#define BIT_MASK_HOST_MSG_E0_8812F 0xffff
#define BIT_HOST_MSG_E0_8812F(x)                                               \
	(((x) & BIT_MASK_HOST_MSG_E0_8812F) << BIT_SHIFT_HOST_MSG_E0_8812F)
#define BITS_HOST_MSG_E0_8812F                                                 \
	(BIT_MASK_HOST_MSG_E0_8812F << BIT_SHIFT_HOST_MSG_E0_8812F)
#define BIT_CLEAR_HOST_MSG_E0_8812F(x) ((x) & (~BITS_HOST_MSG_E0_8812F))
#define BIT_GET_HOST_MSG_E0_8812F(x)                                           \
	(((x) >> BIT_SHIFT_HOST_MSG_E0_8812F) & BIT_MASK_HOST_MSG_E0_8812F)
#define BIT_SET_HOST_MSG_E0_8812F(x, v)                                        \
	(BIT_CLEAR_HOST_MSG_E0_8812F(x) | BIT_HOST_MSG_E0_8812F(v))

/* 2 REG_HMEBOX_E2_E3_8812F */

#define BIT_SHIFT_HOST_MSG_E3_8812F 16
#define BIT_MASK_HOST_MSG_E3_8812F 0xffff
#define BIT_HOST_MSG_E3_8812F(x)                                               \
	(((x) & BIT_MASK_HOST_MSG_E3_8812F) << BIT_SHIFT_HOST_MSG_E3_8812F)
#define BITS_HOST_MSG_E3_8812F                                                 \
	(BIT_MASK_HOST_MSG_E3_8812F << BIT_SHIFT_HOST_MSG_E3_8812F)
#define BIT_CLEAR_HOST_MSG_E3_8812F(x) ((x) & (~BITS_HOST_MSG_E3_8812F))
#define BIT_GET_HOST_MSG_E3_8812F(x)                                           \
	(((x) >> BIT_SHIFT_HOST_MSG_E3_8812F) & BIT_MASK_HOST_MSG_E3_8812F)
#define BIT_SET_HOST_MSG_E3_8812F(x, v)                                        \
	(BIT_CLEAR_HOST_MSG_E3_8812F(x) | BIT_HOST_MSG_E3_8812F(v))

#define BIT_SHIFT_HOST_MSG_E2_8812F 0
#define BIT_MASK_HOST_MSG_E2_8812F 0xffff
#define BIT_HOST_MSG_E2_8812F(x)                                               \
	(((x) & BIT_MASK_HOST_MSG_E2_8812F) << BIT_SHIFT_HOST_MSG_E2_8812F)
#define BITS_HOST_MSG_E2_8812F                                                 \
	(BIT_MASK_HOST_MSG_E2_8812F << BIT_SHIFT_HOST_MSG_E2_8812F)
#define BIT_CLEAR_HOST_MSG_E2_8812F(x) ((x) & (~BITS_HOST_MSG_E2_8812F))
#define BIT_GET_HOST_MSG_E2_8812F(x)                                           \
	(((x) >> BIT_SHIFT_HOST_MSG_E2_8812F) & BIT_MASK_HOST_MSG_E2_8812F)
#define BIT_SET_HOST_MSG_E2_8812F(x, v)                                        \
	(BIT_CLEAR_HOST_MSG_E2_8812F(x) | BIT_HOST_MSG_E2_8812F(v))

/* 2 REG_WLLPS_CTRL_8812F */
#define BIT_WLLPSOP_EABM_8812F BIT(31)
#define BIT_WLLPSOP_ACKF_8812F BIT(30)
#define BIT_WLLPSOP_DLDM_8812F BIT(29)
#define BIT_WLLPSOP_ESWR_8812F BIT(28)
#define BIT_WLLPSOP_PWMM_8812F BIT(27)
#define BIT_WLLPSOP_EECK_8812F BIT(26)
#define BIT_WLLPSOP_WLMACOFF_8812F BIT(25)
#define BIT_WLLPSOP_EXTAL_8812F BIT(24)
#define BIT_WL_SYNPON_VOLTSPDN_8812F BIT(23)
#define BIT_WLLPSOP_WLBBOFF_8812F BIT(22)
#define BIT_WLLPSOP_WLMEM_DS_8812F BIT(21)
#define BIT_WLLPSOP_LDO_WAIT_TIME_8812F BIT(20)
#define BIT_WLLPSOP_ANA_CLK_DIVISION_2_8812F BIT(19)
#define BIT_AFE_BCN_8812F BIT(18)

#define BIT_SHIFT_LPLDH12_VADJ_STEP_DN_8812F 12
#define BIT_MASK_LPLDH12_VADJ_STEP_DN_8812F 0xf
#define BIT_LPLDH12_VADJ_STEP_DN_8812F(x)                                      \
	(((x) & BIT_MASK_LPLDH12_VADJ_STEP_DN_8812F)                           \
	 << BIT_SHIFT_LPLDH12_VADJ_STEP_DN_8812F)
#define BITS_LPLDH12_VADJ_STEP_DN_8812F                                        \
	(BIT_MASK_LPLDH12_VADJ_STEP_DN_8812F                                   \
	 << BIT_SHIFT_LPLDH12_VADJ_STEP_DN_8812F)
#define BIT_CLEAR_LPLDH12_VADJ_STEP_DN_8812F(x)                                \
	((x) & (~BITS_LPLDH12_VADJ_STEP_DN_8812F))
#define BIT_GET_LPLDH12_VADJ_STEP_DN_8812F(x)                                  \
	(((x) >> BIT_SHIFT_LPLDH12_VADJ_STEP_DN_8812F) &                       \
	 BIT_MASK_LPLDH12_VADJ_STEP_DN_8812F)
#define BIT_SET_LPLDH12_VADJ_STEP_DN_8812F(x, v)                               \
	(BIT_CLEAR_LPLDH12_VADJ_STEP_DN_8812F(x) |                             \
	 BIT_LPLDH12_VADJ_STEP_DN_8812F(v))

#define BIT_SHIFT_V15ADJ_L1_STEP_DN_V1_8812F 8
#define BIT_MASK_V15ADJ_L1_STEP_DN_V1_8812F 0xf
#define BIT_V15ADJ_L1_STEP_DN_V1_8812F(x)                                      \
	(((x) & BIT_MASK_V15ADJ_L1_STEP_DN_V1_8812F)                           \
	 << BIT_SHIFT_V15ADJ_L1_STEP_DN_V1_8812F)
#define BITS_V15ADJ_L1_STEP_DN_V1_8812F                                        \
	(BIT_MASK_V15ADJ_L1_STEP_DN_V1_8812F                                   \
	 << BIT_SHIFT_V15ADJ_L1_STEP_DN_V1_8812F)
#define BIT_CLEAR_V15ADJ_L1_STEP_DN_V1_8812F(x)                                \
	((x) & (~BITS_V15ADJ_L1_STEP_DN_V1_8812F))
#define BIT_GET_V15ADJ_L1_STEP_DN_V1_8812F(x)                                  \
	(((x) >> BIT_SHIFT_V15ADJ_L1_STEP_DN_V1_8812F) &                       \
	 BIT_MASK_V15ADJ_L1_STEP_DN_V1_8812F)
#define BIT_SET_V15ADJ_L1_STEP_DN_V1_8812F(x, v)                               \
	(BIT_CLEAR_V15ADJ_L1_STEP_DN_V1_8812F(x) |                             \
	 BIT_V15ADJ_L1_STEP_DN_V1_8812F(v))

#define BIT_FORCE_LEAVE_LPS_8812F BIT(3)
#define BIT_SW_AFE_MODE_8812F BIT(2)
#define BIT_REGU_32K_CLK_EN_8812F BIT(1)
#define BIT_WL_LPS_EN_8812F BIT(0)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_GPIO_DEBOUNCE_CTRL_8812F */
#define BIT_WLGP_DBC1EN_8812F BIT(15)

#define BIT_SHIFT_WLGP_DBC1_8812F 8
#define BIT_MASK_WLGP_DBC1_8812F 0xf
#define BIT_WLGP_DBC1_8812F(x)                                                 \
	(((x) & BIT_MASK_WLGP_DBC1_8812F) << BIT_SHIFT_WLGP_DBC1_8812F)
#define BITS_WLGP_DBC1_8812F                                                   \
	(BIT_MASK_WLGP_DBC1_8812F << BIT_SHIFT_WLGP_DBC1_8812F)
#define BIT_CLEAR_WLGP_DBC1_8812F(x) ((x) & (~BITS_WLGP_DBC1_8812F))
#define BIT_GET_WLGP_DBC1_8812F(x)                                             \
	(((x) >> BIT_SHIFT_WLGP_DBC1_8812F) & BIT_MASK_WLGP_DBC1_8812F)
#define BIT_SET_WLGP_DBC1_8812F(x, v)                                          \
	(BIT_CLEAR_WLGP_DBC1_8812F(x) | BIT_WLGP_DBC1_8812F(v))

#define BIT_WLGP_DBC0EN_8812F BIT(7)

#define BIT_SHIFT_WLGP_DBC0_8812F 0
#define BIT_MASK_WLGP_DBC0_8812F 0xf
#define BIT_WLGP_DBC0_8812F(x)                                                 \
	(((x) & BIT_MASK_WLGP_DBC0_8812F) << BIT_SHIFT_WLGP_DBC0_8812F)
#define BITS_WLGP_DBC0_8812F                                                   \
	(BIT_MASK_WLGP_DBC0_8812F << BIT_SHIFT_WLGP_DBC0_8812F)
#define BIT_CLEAR_WLGP_DBC0_8812F(x) ((x) & (~BITS_WLGP_DBC0_8812F))
#define BIT_GET_WLGP_DBC0_8812F(x)                                             \
	(((x) >> BIT_SHIFT_WLGP_DBC0_8812F) & BIT_MASK_WLGP_DBC0_8812F)
#define BIT_SET_WLGP_DBC0_8812F(x, v)                                          \
	(BIT_CLEAR_WLGP_DBC0_8812F(x) | BIT_WLGP_DBC0_8812F(v))

/* 2 REG_RPWM2_8812F */

#define BIT_SHIFT_RPWM2_8812F 16
#define BIT_MASK_RPWM2_8812F 0xffff
#define BIT_RPWM2_8812F(x)                                                     \
	(((x) & BIT_MASK_RPWM2_8812F) << BIT_SHIFT_RPWM2_8812F)
#define BITS_RPWM2_8812F (BIT_MASK_RPWM2_8812F << BIT_SHIFT_RPWM2_8812F)
#define BIT_CLEAR_RPWM2_8812F(x) ((x) & (~BITS_RPWM2_8812F))
#define BIT_GET_RPWM2_8812F(x)                                                 \
	(((x) >> BIT_SHIFT_RPWM2_8812F) & BIT_MASK_RPWM2_8812F)
#define BIT_SET_RPWM2_8812F(x, v)                                              \
	(BIT_CLEAR_RPWM2_8812F(x) | BIT_RPWM2_8812F(v))

/* 2 REG_SYSON_FSM_MON_8812F */

#define BIT_SHIFT_FSM_MON_SEL_8812F 24
#define BIT_MASK_FSM_MON_SEL_8812F 0x7
#define BIT_FSM_MON_SEL_8812F(x)                                               \
	(((x) & BIT_MASK_FSM_MON_SEL_8812F) << BIT_SHIFT_FSM_MON_SEL_8812F)
#define BITS_FSM_MON_SEL_8812F                                                 \
	(BIT_MASK_FSM_MON_SEL_8812F << BIT_SHIFT_FSM_MON_SEL_8812F)
#define BIT_CLEAR_FSM_MON_SEL_8812F(x) ((x) & (~BITS_FSM_MON_SEL_8812F))
#define BIT_GET_FSM_MON_SEL_8812F(x)                                           \
	(((x) >> BIT_SHIFT_FSM_MON_SEL_8812F) & BIT_MASK_FSM_MON_SEL_8812F)
#define BIT_SET_FSM_MON_SEL_8812F(x, v)                                        \
	(BIT_CLEAR_FSM_MON_SEL_8812F(x) | BIT_FSM_MON_SEL_8812F(v))

#define BIT_DOP_ELDO_8812F BIT(23)
#define BIT_FSM_MON_UPD_8812F BIT(15)

#define BIT_SHIFT_FSM_PAR_8812F 0
#define BIT_MASK_FSM_PAR_8812F 0x7fff
#define BIT_FSM_PAR_8812F(x)                                                   \
	(((x) & BIT_MASK_FSM_PAR_8812F) << BIT_SHIFT_FSM_PAR_8812F)
#define BITS_FSM_PAR_8812F (BIT_MASK_FSM_PAR_8812F << BIT_SHIFT_FSM_PAR_8812F)
#define BIT_CLEAR_FSM_PAR_8812F(x) ((x) & (~BITS_FSM_PAR_8812F))
#define BIT_GET_FSM_PAR_8812F(x)                                               \
	(((x) >> BIT_SHIFT_FSM_PAR_8812F) & BIT_MASK_FSM_PAR_8812F)
#define BIT_SET_FSM_PAR_8812F(x, v)                                            \
	(BIT_CLEAR_FSM_PAR_8812F(x) | BIT_FSM_PAR_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_PMC_DBG_CTRL1_8812F */
#define BIT_BT_INT_EN_8812F BIT(31)

#define BIT_SHIFT_RD_WR_WIFI_BT_INFO_8812F 16
#define BIT_MASK_RD_WR_WIFI_BT_INFO_8812F 0x7fff
#define BIT_RD_WR_WIFI_BT_INFO_8812F(x)                                        \
	(((x) & BIT_MASK_RD_WR_WIFI_BT_INFO_8812F)                             \
	 << BIT_SHIFT_RD_WR_WIFI_BT_INFO_8812F)
#define BITS_RD_WR_WIFI_BT_INFO_8812F                                          \
	(BIT_MASK_RD_WR_WIFI_BT_INFO_8812F                                     \
	 << BIT_SHIFT_RD_WR_WIFI_BT_INFO_8812F)
#define BIT_CLEAR_RD_WR_WIFI_BT_INFO_8812F(x)                                  \
	((x) & (~BITS_RD_WR_WIFI_BT_INFO_8812F))
#define BIT_GET_RD_WR_WIFI_BT_INFO_8812F(x)                                    \
	(((x) >> BIT_SHIFT_RD_WR_WIFI_BT_INFO_8812F) &                         \
	 BIT_MASK_RD_WR_WIFI_BT_INFO_8812F)
#define BIT_SET_RD_WR_WIFI_BT_INFO_8812F(x, v)                                 \
	(BIT_CLEAR_RD_WR_WIFI_BT_INFO_8812F(x) |                               \
	 BIT_RD_WR_WIFI_BT_INFO_8812F(v))

#define BIT_PMC_WR_OVF_8812F BIT(8)

#define BIT_SHIFT_WLPMC_ERRINT_8812F 0
#define BIT_MASK_WLPMC_ERRINT_8812F 0xff
#define BIT_WLPMC_ERRINT_8812F(x)                                              \
	(((x) & BIT_MASK_WLPMC_ERRINT_8812F) << BIT_SHIFT_WLPMC_ERRINT_8812F)
#define BITS_WLPMC_ERRINT_8812F                                                \
	(BIT_MASK_WLPMC_ERRINT_8812F << BIT_SHIFT_WLPMC_ERRINT_8812F)
#define BIT_CLEAR_WLPMC_ERRINT_8812F(x) ((x) & (~BITS_WLPMC_ERRINT_8812F))
#define BIT_GET_WLPMC_ERRINT_8812F(x)                                          \
	(((x) >> BIT_SHIFT_WLPMC_ERRINT_8812F) & BIT_MASK_WLPMC_ERRINT_8812F)
#define BIT_SET_WLPMC_ERRINT_8812F(x, v)                                       \
	(BIT_CLEAR_WLPMC_ERRINT_8812F(x) | BIT_WLPMC_ERRINT_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_HIMR0_8812F */
#define BIT_TIMEOUT_INTERRUPT2_MASK_8812F BIT(31)
#define BIT_TIMEOUT_INTERRUTP1_MASK_8812F BIT(30)
#define BIT_PSTIMEOUT_MSK_8812F BIT(29)
#define BIT_GTINT4_MSK_8812F BIT(28)
#define BIT_GTINT3_MSK_8812F BIT(27)
#define BIT_TXBCN0ERR_MSK_8812F BIT(26)
#define BIT_TXBCN0OK_MSK_8812F BIT(25)
#define BIT_TSF_BIT32_TOGGLE_MSK_8812F BIT(24)
#define BIT_BCNDMAINT0_MSK_8812F BIT(20)
#define BIT_BCNDERR0_MSK_8812F BIT(16)
#define BIT_HSISR_IND_ON_INT_MSK_8812F BIT(15)
#define BIT_BCNDMAINT_E_MSK_8812F BIT(14)
#define BIT_CTWEND_MSK_8812F BIT(12)
#define BIT_HISR1_IND_MSK_8812F BIT(11)
#define BIT_C2HCMD_MSK_8812F BIT(10)
#define BIT_CPWM2_MSK_8812F BIT(9)
#define BIT_CPWM_MSK_8812F BIT(8)
#define BIT_HIGHDOK_MSK_8812F BIT(7)
#define BIT_MGTDOK_MSK_8812F BIT(6)
#define BIT_BKDOK_MSK_8812F BIT(5)
#define BIT_BEDOK_MSK_8812F BIT(4)
#define BIT_VIDOK_MSK_8812F BIT(3)
#define BIT_VODOK_MSK_8812F BIT(2)
#define BIT_RDU_MSK_8812F BIT(1)
#define BIT_RXOK_MSK_8812F BIT(0)

/* 2 REG_HISR0_8812F */
#define BIT_PSTIMEOUT2_8812F BIT(31)
#define BIT_PSTIMEOUT1_8812F BIT(30)
#define BIT_PSTIMEOUT_8812F BIT(29)
#define BIT_GTINT4_8812F BIT(28)
#define BIT_GTINT3_8812F BIT(27)
#define BIT_TXBCN0ERR_8812F BIT(26)
#define BIT_TXBCN0OK_8812F BIT(25)
#define BIT_TSF_BIT32_TOGGLE_8812F BIT(24)
#define BIT_BCNDMAINT0_8812F BIT(20)
#define BIT_BCNDERR0_8812F BIT(16)
#define BIT_HSISR_IND_ON_INT_8812F BIT(15)
#define BIT_BCNDMAINT_E_8812F BIT(14)
#define BIT_CTWEND_8812F BIT(12)
#define BIT_HISR1_IND_INT_8812F BIT(11)
#define BIT_C2HCMD_8812F BIT(10)
#define BIT_CPWM2_8812F BIT(9)
#define BIT_CPWM_8812F BIT(8)
#define BIT_HIGHDOK_8812F BIT(7)
#define BIT_MGTDOK_8812F BIT(6)
#define BIT_BKDOK_8812F BIT(5)
#define BIT_BEDOK_8812F BIT(4)
#define BIT_VIDOK_8812F BIT(3)
#define BIT_VODOK_8812F BIT(2)
#define BIT_RDU_8812F BIT(1)
#define BIT_RXOK_8812F BIT(0)

/* 2 REG_HIMR1_8812F */
#define BIT_TXFIFO_TH_INT_8812F BIT(30)
#define BIT_BTON_STS_UPDATE_MASK_8812F BIT(29)
#define BIT_MCU_ERR_MASK_8812F BIT(28)
#define BIT_BCNDMAINT7__MSK_8812F BIT(27)
#define BIT_BCNDMAINT6__MSK_8812F BIT(26)
#define BIT_BCNDMAINT5__MSK_8812F BIT(25)
#define BIT_BCNDMAINT4__MSK_8812F BIT(24)
#define BIT_BCNDMAINT3_MSK_8812F BIT(23)
#define BIT_BCNDMAINT2_MSK_8812F BIT(22)
#define BIT_BCNDMAINT1_MSK_8812F BIT(21)
#define BIT_BCNDERR7_MSK_8812F BIT(20)
#define BIT_BCNDERR6_MSK_8812F BIT(19)
#define BIT_BCNDERR5_MSK_8812F BIT(18)
#define BIT_BCNDERR4_MSK_8812F BIT(17)
#define BIT_BCNDERR3_MSK_8812F BIT(16)
#define BIT_BCNDERR2_MSK_8812F BIT(15)
#define BIT_BCNDERR1_MSK_8812F BIT(14)
#define BIT_ATIMEND_E_MSK_8812F BIT(13)
#define BIT_ATIMEND__MSK_8812F BIT(12)
#define BIT_TXERR_MSK_8812F BIT(11)
#define BIT_RXERR_MSK_8812F BIT(10)
#define BIT_TXFOVW_MSK_8812F BIT(9)
#define BIT_FOVW_MSK_8812F BIT(8)
#define BIT_CPU_MGQ_TXDONE_MSK_8812F BIT(5)
#define BIT_PS_TIMER_C_MSK_8812F BIT(4)
#define BIT_PS_TIMER_B_MSK_8812F BIT(3)
#define BIT_PS_TIMER_A_MSK_8812F BIT(2)
#define BIT_CPUMGQ_TX_TIMER_MSK_8812F BIT(1)

/* 2 REG_HISR1_8812F */
#define BIT_TXFIFO_TH_INT_8812F BIT(30)
#define BIT_BTON_STS_UPDATE_INT_8812F BIT(29)
#define BIT_MCU_ERR_8812F BIT(28)
#define BIT_BCNDMAINT7_8812F BIT(27)
#define BIT_BCNDMAINT6_8812F BIT(26)
#define BIT_BCNDMAINT5_8812F BIT(25)
#define BIT_BCNDMAINT4_8812F BIT(24)
#define BIT_BCNDMAINT3_8812F BIT(23)
#define BIT_BCNDMAINT2_8812F BIT(22)
#define BIT_BCNDMAINT1_8812F BIT(21)
#define BIT_BCNDERR7_8812F BIT(20)
#define BIT_BCNDERR6_8812F BIT(19)
#define BIT_BCNDERR5_8812F BIT(18)
#define BIT_BCNDERR4_8812F BIT(17)
#define BIT_BCNDERR3_8812F BIT(16)
#define BIT_BCNDERR2_8812F BIT(15)
#define BIT_BCNDERR1_8812F BIT(14)
#define BIT_ATIMEND_E_8812F BIT(13)
#define BIT_ATIMEND_8812F BIT(12)
#define BIT_TXERR_INT_8812F BIT(11)
#define BIT_RXERR_INT_8812F BIT(10)
#define BIT_TXFOVW_8812F BIT(9)
#define BIT_FOVW_8812F BIT(8)

/* 2 REG_NOT_VALID_8812F */
#define BIT_CPU_MGQ_TXDONE_8812F BIT(5)
#define BIT_PS_TIMER_C_8812F BIT(4)
#define BIT_PS_TIMER_B_8812F BIT(3)
#define BIT_PS_TIMER_A_8812F BIT(2)
#define BIT_CPUMGQ_TX_TIMER_8812F BIT(1)

/* 2 REG_DBG_PORT_SEL_8812F */

#define BIT_SHIFT_DEBUG_ST_8812F 0
#define BIT_MASK_DEBUG_ST_8812F 0xffffffffL
#define BIT_DEBUG_ST_8812F(x)                                                  \
	(((x) & BIT_MASK_DEBUG_ST_8812F) << BIT_SHIFT_DEBUG_ST_8812F)
#define BITS_DEBUG_ST_8812F                                                    \
	(BIT_MASK_DEBUG_ST_8812F << BIT_SHIFT_DEBUG_ST_8812F)
#define BIT_CLEAR_DEBUG_ST_8812F(x) ((x) & (~BITS_DEBUG_ST_8812F))
#define BIT_GET_DEBUG_ST_8812F(x)                                              \
	(((x) >> BIT_SHIFT_DEBUG_ST_8812F) & BIT_MASK_DEBUG_ST_8812F)
#define BIT_SET_DEBUG_ST_8812F(x, v)                                           \
	(BIT_CLEAR_DEBUG_ST_8812F(x) | BIT_DEBUG_ST_8812F(v))

/* 2 REG_PAD_CTRL2_8812F */
#define BIT_USB3_USB2_TRANSITION_8812F BIT(20)

#define BIT_SHIFT_USB23_SW_MODE_V1_8812F 18
#define BIT_MASK_USB23_SW_MODE_V1_8812F 0x3
#define BIT_USB23_SW_MODE_V1_8812F(x)                                          \
	(((x) & BIT_MASK_USB23_SW_MODE_V1_8812F)                               \
	 << BIT_SHIFT_USB23_SW_MODE_V1_8812F)
#define BITS_USB23_SW_MODE_V1_8812F                                            \
	(BIT_MASK_USB23_SW_MODE_V1_8812F << BIT_SHIFT_USB23_SW_MODE_V1_8812F)
#define BIT_CLEAR_USB23_SW_MODE_V1_8812F(x)                                    \
	((x) & (~BITS_USB23_SW_MODE_V1_8812F))
#define BIT_GET_USB23_SW_MODE_V1_8812F(x)                                      \
	(((x) >> BIT_SHIFT_USB23_SW_MODE_V1_8812F) &                           \
	 BIT_MASK_USB23_SW_MODE_V1_8812F)
#define BIT_SET_USB23_SW_MODE_V1_8812F(x, v)                                   \
	(BIT_CLEAR_USB23_SW_MODE_V1_8812F(x) | BIT_USB23_SW_MODE_V1_8812F(v))

#define BIT_NO_PDN_CHIPOFF_V1_8812F BIT(17)
#define BIT_RSM_EN_V1_8812F BIT(16)

#define BIT_SHIFT_MATCH_CNT_8812F 8
#define BIT_MASK_MATCH_CNT_8812F 0xff
#define BIT_MATCH_CNT_8812F(x)                                                 \
	(((x) & BIT_MASK_MATCH_CNT_8812F) << BIT_SHIFT_MATCH_CNT_8812F)
#define BITS_MATCH_CNT_8812F                                                   \
	(BIT_MASK_MATCH_CNT_8812F << BIT_SHIFT_MATCH_CNT_8812F)
#define BIT_CLEAR_MATCH_CNT_8812F(x) ((x) & (~BITS_MATCH_CNT_8812F))
#define BIT_GET_MATCH_CNT_8812F(x)                                             \
	(((x) >> BIT_SHIFT_MATCH_CNT_8812F) & BIT_MASK_MATCH_CNT_8812F)
#define BIT_SET_MATCH_CNT_8812F(x, v)                                          \
	(BIT_CLEAR_MATCH_CNT_8812F(x) | BIT_MATCH_CNT_8812F(v))

#define BIT_LD_B12V_EN_8812F BIT(7)
#define BIT_EECS_IOSEL_V1_8812F BIT(6)
#define BIT_EECS_DATA_O_V1_8812F BIT(5)
#define BIT_EECS_DATA_I_V1_8812F BIT(4)
#define BIT_EESK_IOSEL_V1_8812F BIT(2)
#define BIT_EESK_DATA_O_V1_8812F BIT(1)
#define BIT_EESK_DATA_I_V1_8812F BIT(0)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_PMC_DBG_CTRL2_8812F */

#define BIT_SHIFT_EFUSE_BURN_GNT_8812F 24
#define BIT_MASK_EFUSE_BURN_GNT_8812F 0xff
#define BIT_EFUSE_BURN_GNT_8812F(x)                                            \
	(((x) & BIT_MASK_EFUSE_BURN_GNT_8812F)                                 \
	 << BIT_SHIFT_EFUSE_BURN_GNT_8812F)
#define BITS_EFUSE_BURN_GNT_8812F                                              \
	(BIT_MASK_EFUSE_BURN_GNT_8812F << BIT_SHIFT_EFUSE_BURN_GNT_8812F)
#define BIT_CLEAR_EFUSE_BURN_GNT_8812F(x) ((x) & (~BITS_EFUSE_BURN_GNT_8812F))
#define BIT_GET_EFUSE_BURN_GNT_8812F(x)                                        \
	(((x) >> BIT_SHIFT_EFUSE_BURN_GNT_8812F) &                             \
	 BIT_MASK_EFUSE_BURN_GNT_8812F)
#define BIT_SET_EFUSE_BURN_GNT_8812F(x, v)                                     \
	(BIT_CLEAR_EFUSE_BURN_GNT_8812F(x) | BIT_EFUSE_BURN_GNT_8812F(v))

#define BIT_STOP_WL_PMC_8812F BIT(9)
#define BIT_STOP_SYM_PMC_8812F BIT(8)
#define BIT_BT_ACCESS_WL_PAGE0_8812F BIT(6)
#define BIT_REG_RST_WLPMC_8812F BIT(5)
#define BIT_REG_RST_PD12N_8812F BIT(4)
#define BIT_SYSON_DIS_WLREG_WRMSK_8812F BIT(3)
#define BIT_SYSON_DIS_PMCREG_WRMSK_8812F BIT(2)

#define BIT_SHIFT_SYSON_REG_ARB_8812F 0
#define BIT_MASK_SYSON_REG_ARB_8812F 0x3
#define BIT_SYSON_REG_ARB_8812F(x)                                             \
	(((x) & BIT_MASK_SYSON_REG_ARB_8812F) << BIT_SHIFT_SYSON_REG_ARB_8812F)
#define BITS_SYSON_REG_ARB_8812F                                               \
	(BIT_MASK_SYSON_REG_ARB_8812F << BIT_SHIFT_SYSON_REG_ARB_8812F)
#define BIT_CLEAR_SYSON_REG_ARB_8812F(x) ((x) & (~BITS_SYSON_REG_ARB_8812F))
#define BIT_GET_SYSON_REG_ARB_8812F(x)                                         \
	(((x) >> BIT_SHIFT_SYSON_REG_ARB_8812F) & BIT_MASK_SYSON_REG_ARB_8812F)
#define BIT_SET_SYSON_REG_ARB_8812F(x, v)                                      \
	(BIT_CLEAR_SYSON_REG_ARB_8812F(x) | BIT_SYSON_REG_ARB_8812F(v))

/* 2 REG_BIST_CTRL_8812F */
#define BIT_BIST_USB_DIS_8812F BIT(27)
#define BIT_BIST_PCI_DIS_8812F BIT(26)
#define BIT_BIST_BT_DIS_8812F BIT(25)
#define BIT_BIST_WL_DIS_8812F BIT(24)

#define BIT_SHIFT_BIST_RPT_SEL_8812F 16
#define BIT_MASK_BIST_RPT_SEL_8812F 0xf
#define BIT_BIST_RPT_SEL_8812F(x)                                              \
	(((x) & BIT_MASK_BIST_RPT_SEL_8812F) << BIT_SHIFT_BIST_RPT_SEL_8812F)
#define BITS_BIST_RPT_SEL_8812F                                                \
	(BIT_MASK_BIST_RPT_SEL_8812F << BIT_SHIFT_BIST_RPT_SEL_8812F)
#define BIT_CLEAR_BIST_RPT_SEL_8812F(x) ((x) & (~BITS_BIST_RPT_SEL_8812F))
#define BIT_GET_BIST_RPT_SEL_8812F(x)                                          \
	(((x) >> BIT_SHIFT_BIST_RPT_SEL_8812F) & BIT_MASK_BIST_RPT_SEL_8812F)
#define BIT_SET_BIST_RPT_SEL_8812F(x, v)                                       \
	(BIT_CLEAR_BIST_RPT_SEL_8812F(x) | BIT_BIST_RPT_SEL_8812F(v))

#define BIT_BIST_RESUME_PS_8812F BIT(4)
#define BIT_BIST_RESUME_8812F BIT(3)
#define BIT_BIST_NORMAL_8812F BIT(2)
#define BIT_BIST_RSTN_8812F BIT(1)
#define BIT_BIST_CLK_EN_8812F BIT(0)

/* 2 REG_BIST_RPT_8812F */

#define BIT_SHIFT_MBIST_REPORT_8812F 0
#define BIT_MASK_MBIST_REPORT_8812F 0xffffffffL
#define BIT_MBIST_REPORT_8812F(x)                                              \
	(((x) & BIT_MASK_MBIST_REPORT_8812F) << BIT_SHIFT_MBIST_REPORT_8812F)
#define BITS_MBIST_REPORT_8812F                                                \
	(BIT_MASK_MBIST_REPORT_8812F << BIT_SHIFT_MBIST_REPORT_8812F)
#define BIT_CLEAR_MBIST_REPORT_8812F(x) ((x) & (~BITS_MBIST_REPORT_8812F))
#define BIT_GET_MBIST_REPORT_8812F(x)                                          \
	(((x) >> BIT_SHIFT_MBIST_REPORT_8812F) & BIT_MASK_MBIST_REPORT_8812F)
#define BIT_SET_MBIST_REPORT_8812F(x, v)                                       \
	(BIT_CLEAR_MBIST_REPORT_8812F(x) | BIT_MBIST_REPORT_8812F(v))

/* 2 REG_MEM_CTRL_8812F */
#define BIT_UMEM_RME_8812F BIT(31)

#define BIT_SHIFT_BT_SPRAM_8812F 28
#define BIT_MASK_BT_SPRAM_8812F 0x3
#define BIT_BT_SPRAM_8812F(x)                                                  \
	(((x) & BIT_MASK_BT_SPRAM_8812F) << BIT_SHIFT_BT_SPRAM_8812F)
#define BITS_BT_SPRAM_8812F                                                    \
	(BIT_MASK_BT_SPRAM_8812F << BIT_SHIFT_BT_SPRAM_8812F)
#define BIT_CLEAR_BT_SPRAM_8812F(x) ((x) & (~BITS_BT_SPRAM_8812F))
#define BIT_GET_BT_SPRAM_8812F(x)                                              \
	(((x) >> BIT_SHIFT_BT_SPRAM_8812F) & BIT_MASK_BT_SPRAM_8812F)
#define BIT_SET_BT_SPRAM_8812F(x, v)                                           \
	(BIT_CLEAR_BT_SPRAM_8812F(x) | BIT_BT_SPRAM_8812F(v))

#define BIT_SHIFT_BT_ROM_8812F 24
#define BIT_MASK_BT_ROM_8812F 0xf
#define BIT_BT_ROM_8812F(x)                                                    \
	(((x) & BIT_MASK_BT_ROM_8812F) << BIT_SHIFT_BT_ROM_8812F)
#define BITS_BT_ROM_8812F (BIT_MASK_BT_ROM_8812F << BIT_SHIFT_BT_ROM_8812F)
#define BIT_CLEAR_BT_ROM_8812F(x) ((x) & (~BITS_BT_ROM_8812F))
#define BIT_GET_BT_ROM_8812F(x)                                                \
	(((x) >> BIT_SHIFT_BT_ROM_8812F) & BIT_MASK_BT_ROM_8812F)
#define BIT_SET_BT_ROM_8812F(x, v)                                             \
	(BIT_CLEAR_BT_ROM_8812F(x) | BIT_BT_ROM_8812F(v))

#define BIT_SHIFT_PCI_DPRAM_8812F 10
#define BIT_MASK_PCI_DPRAM_8812F 0x3
#define BIT_PCI_DPRAM_8812F(x)                                                 \
	(((x) & BIT_MASK_PCI_DPRAM_8812F) << BIT_SHIFT_PCI_DPRAM_8812F)
#define BITS_PCI_DPRAM_8812F                                                   \
	(BIT_MASK_PCI_DPRAM_8812F << BIT_SHIFT_PCI_DPRAM_8812F)
#define BIT_CLEAR_PCI_DPRAM_8812F(x) ((x) & (~BITS_PCI_DPRAM_8812F))
#define BIT_GET_PCI_DPRAM_8812F(x)                                             \
	(((x) >> BIT_SHIFT_PCI_DPRAM_8812F) & BIT_MASK_PCI_DPRAM_8812F)
#define BIT_SET_PCI_DPRAM_8812F(x, v)                                          \
	(BIT_CLEAR_PCI_DPRAM_8812F(x) | BIT_PCI_DPRAM_8812F(v))

#define BIT_SHIFT_PCI_SPRAM_8812F 8
#define BIT_MASK_PCI_SPRAM_8812F 0x3
#define BIT_PCI_SPRAM_8812F(x)                                                 \
	(((x) & BIT_MASK_PCI_SPRAM_8812F) << BIT_SHIFT_PCI_SPRAM_8812F)
#define BITS_PCI_SPRAM_8812F                                                   \
	(BIT_MASK_PCI_SPRAM_8812F << BIT_SHIFT_PCI_SPRAM_8812F)
#define BIT_CLEAR_PCI_SPRAM_8812F(x) ((x) & (~BITS_PCI_SPRAM_8812F))
#define BIT_GET_PCI_SPRAM_8812F(x)                                             \
	(((x) >> BIT_SHIFT_PCI_SPRAM_8812F) & BIT_MASK_PCI_SPRAM_8812F)
#define BIT_SET_PCI_SPRAM_8812F(x, v)                                          \
	(BIT_CLEAR_PCI_SPRAM_8812F(x) | BIT_PCI_SPRAM_8812F(v))

#define BIT_SHIFT_USB_SPRAM_8812F 6
#define BIT_MASK_USB_SPRAM_8812F 0x3
#define BIT_USB_SPRAM_8812F(x)                                                 \
	(((x) & BIT_MASK_USB_SPRAM_8812F) << BIT_SHIFT_USB_SPRAM_8812F)
#define BITS_USB_SPRAM_8812F                                                   \
	(BIT_MASK_USB_SPRAM_8812F << BIT_SHIFT_USB_SPRAM_8812F)
#define BIT_CLEAR_USB_SPRAM_8812F(x) ((x) & (~BITS_USB_SPRAM_8812F))
#define BIT_GET_USB_SPRAM_8812F(x)                                             \
	(((x) >> BIT_SHIFT_USB_SPRAM_8812F) & BIT_MASK_USB_SPRAM_8812F)
#define BIT_SET_USB_SPRAM_8812F(x, v)                                          \
	(BIT_CLEAR_USB_SPRAM_8812F(x) | BIT_USB_SPRAM_8812F(v))

#define BIT_SHIFT_USB_SPRF_8812F 4
#define BIT_MASK_USB_SPRF_8812F 0x3
#define BIT_USB_SPRF_8812F(x)                                                  \
	(((x) & BIT_MASK_USB_SPRF_8812F) << BIT_SHIFT_USB_SPRF_8812F)
#define BITS_USB_SPRF_8812F                                                    \
	(BIT_MASK_USB_SPRF_8812F << BIT_SHIFT_USB_SPRF_8812F)
#define BIT_CLEAR_USB_SPRF_8812F(x) ((x) & (~BITS_USB_SPRF_8812F))
#define BIT_GET_USB_SPRF_8812F(x)                                              \
	(((x) >> BIT_SHIFT_USB_SPRF_8812F) & BIT_MASK_USB_SPRF_8812F)
#define BIT_SET_USB_SPRF_8812F(x, v)                                           \
	(BIT_CLEAR_USB_SPRF_8812F(x) | BIT_USB_SPRF_8812F(v))

#define BIT_SHIFT_MCU_ROM_8812F 0
#define BIT_MASK_MCU_ROM_8812F 0xf
#define BIT_MCU_ROM_8812F(x)                                                   \
	(((x) & BIT_MASK_MCU_ROM_8812F) << BIT_SHIFT_MCU_ROM_8812F)
#define BITS_MCU_ROM_8812F (BIT_MASK_MCU_ROM_8812F << BIT_SHIFT_MCU_ROM_8812F)
#define BIT_CLEAR_MCU_ROM_8812F(x) ((x) & (~BITS_MCU_ROM_8812F))
#define BIT_GET_MCU_ROM_8812F(x)                                               \
	(((x) >> BIT_SHIFT_MCU_ROM_8812F) & BIT_MASK_MCU_ROM_8812F)
#define BIT_SET_MCU_ROM_8812F(x, v)                                            \
	(BIT_CLEAR_MCU_ROM_8812F(x) | BIT_MCU_ROM_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_USB_SIE_INTF_8812F */
#define BIT_RD_SEL_8812F BIT(31)
#define BIT_USB_SIE_INTF_WE_V1_8812F BIT(30)
#define BIT_USB_SIE_INTF_BYIOREG_V1_8812F BIT(29)
#define BIT_USB_SIE_SELECT_8812F BIT(28)

#define BIT_SHIFT_USB_SIE_INTF_ADDR_V1_8812F 16
#define BIT_MASK_USB_SIE_INTF_ADDR_V1_8812F 0x1ff
#define BIT_USB_SIE_INTF_ADDR_V1_8812F(x)                                      \
	(((x) & BIT_MASK_USB_SIE_INTF_ADDR_V1_8812F)                           \
	 << BIT_SHIFT_USB_SIE_INTF_ADDR_V1_8812F)
#define BITS_USB_SIE_INTF_ADDR_V1_8812F                                        \
	(BIT_MASK_USB_SIE_INTF_ADDR_V1_8812F                                   \
	 << BIT_SHIFT_USB_SIE_INTF_ADDR_V1_8812F)
#define BIT_CLEAR_USB_SIE_INTF_ADDR_V1_8812F(x)                                \
	((x) & (~BITS_USB_SIE_INTF_ADDR_V1_8812F))
#define BIT_GET_USB_SIE_INTF_ADDR_V1_8812F(x)                                  \
	(((x) >> BIT_SHIFT_USB_SIE_INTF_ADDR_V1_8812F) &                       \
	 BIT_MASK_USB_SIE_INTF_ADDR_V1_8812F)
#define BIT_SET_USB_SIE_INTF_ADDR_V1_8812F(x, v)                               \
	(BIT_CLEAR_USB_SIE_INTF_ADDR_V1_8812F(x) |                             \
	 BIT_USB_SIE_INTF_ADDR_V1_8812F(v))

#define BIT_SHIFT_USB_SIE_INTF_RD_8812F 8
#define BIT_MASK_USB_SIE_INTF_RD_8812F 0xff
#define BIT_USB_SIE_INTF_RD_8812F(x)                                           \
	(((x) & BIT_MASK_USB_SIE_INTF_RD_8812F)                                \
	 << BIT_SHIFT_USB_SIE_INTF_RD_8812F)
#define BITS_USB_SIE_INTF_RD_8812F                                             \
	(BIT_MASK_USB_SIE_INTF_RD_8812F << BIT_SHIFT_USB_SIE_INTF_RD_8812F)
#define BIT_CLEAR_USB_SIE_INTF_RD_8812F(x) ((x) & (~BITS_USB_SIE_INTF_RD_8812F))
#define BIT_GET_USB_SIE_INTF_RD_8812F(x)                                       \
	(((x) >> BIT_SHIFT_USB_SIE_INTF_RD_8812F) &                            \
	 BIT_MASK_USB_SIE_INTF_RD_8812F)
#define BIT_SET_USB_SIE_INTF_RD_8812F(x, v)                                    \
	(BIT_CLEAR_USB_SIE_INTF_RD_8812F(x) | BIT_USB_SIE_INTF_RD_8812F(v))

#define BIT_SHIFT_USB_SIE_INTF_WD_8812F 0
#define BIT_MASK_USB_SIE_INTF_WD_8812F 0xff
#define BIT_USB_SIE_INTF_WD_8812F(x)                                           \
	(((x) & BIT_MASK_USB_SIE_INTF_WD_8812F)                                \
	 << BIT_SHIFT_USB_SIE_INTF_WD_8812F)
#define BITS_USB_SIE_INTF_WD_8812F                                             \
	(BIT_MASK_USB_SIE_INTF_WD_8812F << BIT_SHIFT_USB_SIE_INTF_WD_8812F)
#define BIT_CLEAR_USB_SIE_INTF_WD_8812F(x) ((x) & (~BITS_USB_SIE_INTF_WD_8812F))
#define BIT_GET_USB_SIE_INTF_WD_8812F(x)                                       \
	(((x) >> BIT_SHIFT_USB_SIE_INTF_WD_8812F) &                            \
	 BIT_MASK_USB_SIE_INTF_WD_8812F)
#define BIT_SET_USB_SIE_INTF_WD_8812F(x, v)                                    \
	(BIT_CLEAR_USB_SIE_INTF_WD_8812F(x) | BIT_USB_SIE_INTF_WD_8812F(v))

/* 2 REG_PCIE_MIO_INTF_8812F */

#define BIT_SHIFT_PCIE_MIO_ADDR_PAGE_8812F 16
#define BIT_MASK_PCIE_MIO_ADDR_PAGE_8812F 0x3
#define BIT_PCIE_MIO_ADDR_PAGE_8812F(x)                                        \
	(((x) & BIT_MASK_PCIE_MIO_ADDR_PAGE_8812F)                             \
	 << BIT_SHIFT_PCIE_MIO_ADDR_PAGE_8812F)
#define BITS_PCIE_MIO_ADDR_PAGE_8812F                                          \
	(BIT_MASK_PCIE_MIO_ADDR_PAGE_8812F                                     \
	 << BIT_SHIFT_PCIE_MIO_ADDR_PAGE_8812F)
#define BIT_CLEAR_PCIE_MIO_ADDR_PAGE_8812F(x)                                  \
	((x) & (~BITS_PCIE_MIO_ADDR_PAGE_8812F))
#define BIT_GET_PCIE_MIO_ADDR_PAGE_8812F(x)                                    \
	(((x) >> BIT_SHIFT_PCIE_MIO_ADDR_PAGE_8812F) &                         \
	 BIT_MASK_PCIE_MIO_ADDR_PAGE_8812F)
#define BIT_SET_PCIE_MIO_ADDR_PAGE_8812F(x, v)                                 \
	(BIT_CLEAR_PCIE_MIO_ADDR_PAGE_8812F(x) |                               \
	 BIT_PCIE_MIO_ADDR_PAGE_8812F(v))

#define BIT_PCIE_MIO_BYIOREG_8812F BIT(13)
#define BIT_PCIE_MIO_RE_8812F BIT(12)

#define BIT_SHIFT_PCIE_MIO_WE_8812F 8
#define BIT_MASK_PCIE_MIO_WE_8812F 0xf
#define BIT_PCIE_MIO_WE_8812F(x)                                               \
	(((x) & BIT_MASK_PCIE_MIO_WE_8812F) << BIT_SHIFT_PCIE_MIO_WE_8812F)
#define BITS_PCIE_MIO_WE_8812F                                                 \
	(BIT_MASK_PCIE_MIO_WE_8812F << BIT_SHIFT_PCIE_MIO_WE_8812F)
#define BIT_CLEAR_PCIE_MIO_WE_8812F(x) ((x) & (~BITS_PCIE_MIO_WE_8812F))
#define BIT_GET_PCIE_MIO_WE_8812F(x)                                           \
	(((x) >> BIT_SHIFT_PCIE_MIO_WE_8812F) & BIT_MASK_PCIE_MIO_WE_8812F)
#define BIT_SET_PCIE_MIO_WE_8812F(x, v)                                        \
	(BIT_CLEAR_PCIE_MIO_WE_8812F(x) | BIT_PCIE_MIO_WE_8812F(v))

#define BIT_SHIFT_PCIE_MIO_ADDR_8812F 0
#define BIT_MASK_PCIE_MIO_ADDR_8812F 0xff
#define BIT_PCIE_MIO_ADDR_8812F(x)                                             \
	(((x) & BIT_MASK_PCIE_MIO_ADDR_8812F) << BIT_SHIFT_PCIE_MIO_ADDR_8812F)
#define BITS_PCIE_MIO_ADDR_8812F                                               \
	(BIT_MASK_PCIE_MIO_ADDR_8812F << BIT_SHIFT_PCIE_MIO_ADDR_8812F)
#define BIT_CLEAR_PCIE_MIO_ADDR_8812F(x) ((x) & (~BITS_PCIE_MIO_ADDR_8812F))
#define BIT_GET_PCIE_MIO_ADDR_8812F(x)                                         \
	(((x) >> BIT_SHIFT_PCIE_MIO_ADDR_8812F) & BIT_MASK_PCIE_MIO_ADDR_8812F)
#define BIT_SET_PCIE_MIO_ADDR_8812F(x, v)                                      \
	(BIT_CLEAR_PCIE_MIO_ADDR_8812F(x) | BIT_PCIE_MIO_ADDR_8812F(v))

/* 2 REG_PCIE_MIO_INTD_8812F */

#define BIT_SHIFT_PCIE_MIO_DATA_8812F 0
#define BIT_MASK_PCIE_MIO_DATA_8812F 0xffffffffL
#define BIT_PCIE_MIO_DATA_8812F(x)                                             \
	(((x) & BIT_MASK_PCIE_MIO_DATA_8812F) << BIT_SHIFT_PCIE_MIO_DATA_8812F)
#define BITS_PCIE_MIO_DATA_8812F                                               \
	(BIT_MASK_PCIE_MIO_DATA_8812F << BIT_SHIFT_PCIE_MIO_DATA_8812F)
#define BIT_CLEAR_PCIE_MIO_DATA_8812F(x) ((x) & (~BITS_PCIE_MIO_DATA_8812F))
#define BIT_GET_PCIE_MIO_DATA_8812F(x)                                         \
	(((x) >> BIT_SHIFT_PCIE_MIO_DATA_8812F) & BIT_MASK_PCIE_MIO_DATA_8812F)
#define BIT_SET_PCIE_MIO_DATA_8812F(x, v)                                      \
	(BIT_CLEAR_PCIE_MIO_DATA_8812F(x) | BIT_PCIE_MIO_DATA_8812F(v))

/* 2 REG_WLRF1_8812F */

#define BIT_SHIFT_WLRF1_CTRL_8812F 24
#define BIT_MASK_WLRF1_CTRL_8812F 0xff
#define BIT_WLRF1_CTRL_8812F(x)                                                \
	(((x) & BIT_MASK_WLRF1_CTRL_8812F) << BIT_SHIFT_WLRF1_CTRL_8812F)
#define BITS_WLRF1_CTRL_8812F                                                  \
	(BIT_MASK_WLRF1_CTRL_8812F << BIT_SHIFT_WLRF1_CTRL_8812F)
#define BIT_CLEAR_WLRF1_CTRL_8812F(x) ((x) & (~BITS_WLRF1_CTRL_8812F))
#define BIT_GET_WLRF1_CTRL_8812F(x)                                            \
	(((x) >> BIT_SHIFT_WLRF1_CTRL_8812F) & BIT_MASK_WLRF1_CTRL_8812F)
#define BIT_SET_WLRF1_CTRL_8812F(x, v)                                         \
	(BIT_CLEAR_WLRF1_CTRL_8812F(x) | BIT_WLRF1_CTRL_8812F(v))

/* 2 REG_SYS_CFG1_8812F */

#define BIT_SHIFT_TRP_ICFG_8812F 28
#define BIT_MASK_TRP_ICFG_8812F 0xf
#define BIT_TRP_ICFG_8812F(x)                                                  \
	(((x) & BIT_MASK_TRP_ICFG_8812F) << BIT_SHIFT_TRP_ICFG_8812F)
#define BITS_TRP_ICFG_8812F                                                    \
	(BIT_MASK_TRP_ICFG_8812F << BIT_SHIFT_TRP_ICFG_8812F)
#define BIT_CLEAR_TRP_ICFG_8812F(x) ((x) & (~BITS_TRP_ICFG_8812F))
#define BIT_GET_TRP_ICFG_8812F(x)                                              \
	(((x) >> BIT_SHIFT_TRP_ICFG_8812F) & BIT_MASK_TRP_ICFG_8812F)
#define BIT_SET_TRP_ICFG_8812F(x, v)                                           \
	(BIT_CLEAR_TRP_ICFG_8812F(x) | BIT_TRP_ICFG_8812F(v))

#define BIT_RF_TYPE_ID_8812F BIT(27)
#define BIT_BD_HCI_SEL_8812F BIT(26)
#define BIT_BD_PKG_SEL_8812F BIT(25)
#define BIT_INTERNAL_EXTERNAL_SWR_8812F BIT(24)
#define BIT_RTL_ID_8812F BIT(23)
#define BIT_PAD_HWPD_IDN_8812F BIT(22)
#define BIT_TESTMODE_8812F BIT(20)

#define BIT_SHIFT_VENDOR_ID_8812F 16
#define BIT_MASK_VENDOR_ID_8812F 0xf
#define BIT_VENDOR_ID_8812F(x)                                                 \
	(((x) & BIT_MASK_VENDOR_ID_8812F) << BIT_SHIFT_VENDOR_ID_8812F)
#define BITS_VENDOR_ID_8812F                                                   \
	(BIT_MASK_VENDOR_ID_8812F << BIT_SHIFT_VENDOR_ID_8812F)
#define BIT_CLEAR_VENDOR_ID_8812F(x) ((x) & (~BITS_VENDOR_ID_8812F))
#define BIT_GET_VENDOR_ID_8812F(x)                                             \
	(((x) >> BIT_SHIFT_VENDOR_ID_8812F) & BIT_MASK_VENDOR_ID_8812F)
#define BIT_SET_VENDOR_ID_8812F(x, v)                                          \
	(BIT_CLEAR_VENDOR_ID_8812F(x) | BIT_VENDOR_ID_8812F(v))

#define BIT_SHIFT_CHIP_VER_8812F 12
#define BIT_MASK_CHIP_VER_8812F 0xf
#define BIT_CHIP_VER_8812F(x)                                                  \
	(((x) & BIT_MASK_CHIP_VER_8812F) << BIT_SHIFT_CHIP_VER_8812F)
#define BITS_CHIP_VER_8812F                                                    \
	(BIT_MASK_CHIP_VER_8812F << BIT_SHIFT_CHIP_VER_8812F)
#define BIT_CLEAR_CHIP_VER_8812F(x) ((x) & (~BITS_CHIP_VER_8812F))
#define BIT_GET_CHIP_VER_8812F(x)                                              \
	(((x) >> BIT_SHIFT_CHIP_VER_8812F) & BIT_MASK_CHIP_VER_8812F)
#define BIT_SET_CHIP_VER_8812F(x, v)                                           \
	(BIT_CLEAR_CHIP_VER_8812F(x) | BIT_CHIP_VER_8812F(v))

#define BIT_BD_MAC3_8812F BIT(11)
#define BIT_BD_MAC1_8812F BIT(10)
#define BIT_BD_MAC2_8812F BIT(9)
#define BIT_SIC_IDLE_8812F BIT(8)
#define BIT_SW_OFFLOAD_EN_8812F BIT(7)
#define BIT_OCP_SHUTDN_8812F BIT(6)
#define BIT_V15_VLD_8812F BIT(5)
#define BIT_PCIRSTB_8812F BIT(4)
#define BIT_PCLK_VLD_8812F BIT(3)
#define BIT_UCLK_VLD_8812F BIT(2)
#define BIT_ACLK_VLD_8812F BIT(1)
#define BIT_XCLK_VLD_8812F BIT(0)

/* 2 REG_SYS_STATUS1_8812F */

#define BIT_SHIFT_RF_RL_ID_8812F 28
#define BIT_MASK_RF_RL_ID_8812F 0xf
#define BIT_RF_RL_ID_8812F(x)                                                  \
	(((x) & BIT_MASK_RF_RL_ID_8812F) << BIT_SHIFT_RF_RL_ID_8812F)
#define BITS_RF_RL_ID_8812F                                                    \
	(BIT_MASK_RF_RL_ID_8812F << BIT_SHIFT_RF_RL_ID_8812F)
#define BIT_CLEAR_RF_RL_ID_8812F(x) ((x) & (~BITS_RF_RL_ID_8812F))
#define BIT_GET_RF_RL_ID_8812F(x)                                              \
	(((x) >> BIT_SHIFT_RF_RL_ID_8812F) & BIT_MASK_RF_RL_ID_8812F)
#define BIT_SET_RF_RL_ID_8812F(x, v)                                           \
	(BIT_CLEAR_RF_RL_ID_8812F(x) | BIT_RF_RL_ID_8812F(v))

#define BIT_HPHY_ICFG_8812F BIT(19)

#define BIT_SHIFT_SEL_0XC0_8812F 16
#define BIT_MASK_SEL_0XC0_8812F 0x3
#define BIT_SEL_0XC0_8812F(x)                                                  \
	(((x) & BIT_MASK_SEL_0XC0_8812F) << BIT_SHIFT_SEL_0XC0_8812F)
#define BITS_SEL_0XC0_8812F                                                    \
	(BIT_MASK_SEL_0XC0_8812F << BIT_SHIFT_SEL_0XC0_8812F)
#define BIT_CLEAR_SEL_0XC0_8812F(x) ((x) & (~BITS_SEL_0XC0_8812F))
#define BIT_GET_SEL_0XC0_8812F(x)                                              \
	(((x) >> BIT_SHIFT_SEL_0XC0_8812F) & BIT_MASK_SEL_0XC0_8812F)
#define BIT_SET_SEL_0XC0_8812F(x, v)                                           \
	(BIT_CLEAR_SEL_0XC0_8812F(x) | BIT_SEL_0XC0_8812F(v))

#define BIT_SHIFT_HCI_SEL_V4_8812F 12
#define BIT_MASK_HCI_SEL_V4_8812F 0x3
#define BIT_HCI_SEL_V4_8812F(x)                                                \
	(((x) & BIT_MASK_HCI_SEL_V4_8812F) << BIT_SHIFT_HCI_SEL_V4_8812F)
#define BITS_HCI_SEL_V4_8812F                                                  \
	(BIT_MASK_HCI_SEL_V4_8812F << BIT_SHIFT_HCI_SEL_V4_8812F)
#define BIT_CLEAR_HCI_SEL_V4_8812F(x) ((x) & (~BITS_HCI_SEL_V4_8812F))
#define BIT_GET_HCI_SEL_V4_8812F(x)                                            \
	(((x) >> BIT_SHIFT_HCI_SEL_V4_8812F) & BIT_MASK_HCI_SEL_V4_8812F)
#define BIT_SET_HCI_SEL_V4_8812F(x, v)                                         \
	(BIT_CLEAR_HCI_SEL_V4_8812F(x) | BIT_HCI_SEL_V4_8812F(v))

#define BIT_USB_OPERATION_MODE_8812F BIT(10)
#define BIT_BT_PDN_8812F BIT(9)
#define BIT_AUTO_WLPON_8812F BIT(8)
#define BIT_WL_MODE_8812F BIT(7)
#define BIT_PKG_SEL_HCI_8812F BIT(6)

#define BIT_SHIFT_PAD_HCI_SEL_V2_8812F 3
#define BIT_MASK_PAD_HCI_SEL_V2_8812F 0x3
#define BIT_PAD_HCI_SEL_V2_8812F(x)                                            \
	(((x) & BIT_MASK_PAD_HCI_SEL_V2_8812F)                                 \
	 << BIT_SHIFT_PAD_HCI_SEL_V2_8812F)
#define BITS_PAD_HCI_SEL_V2_8812F                                              \
	(BIT_MASK_PAD_HCI_SEL_V2_8812F << BIT_SHIFT_PAD_HCI_SEL_V2_8812F)
#define BIT_CLEAR_PAD_HCI_SEL_V2_8812F(x) ((x) & (~BITS_PAD_HCI_SEL_V2_8812F))
#define BIT_GET_PAD_HCI_SEL_V2_8812F(x)                                        \
	(((x) >> BIT_SHIFT_PAD_HCI_SEL_V2_8812F) &                             \
	 BIT_MASK_PAD_HCI_SEL_V2_8812F)
#define BIT_SET_PAD_HCI_SEL_V2_8812F(x, v)                                     \
	(BIT_CLEAR_PAD_HCI_SEL_V2_8812F(x) | BIT_PAD_HCI_SEL_V2_8812F(v))

#define BIT_SHIFT_EFS_HCI_SEL_V1_8812F 0
#define BIT_MASK_EFS_HCI_SEL_V1_8812F 0x7
#define BIT_EFS_HCI_SEL_V1_8812F(x)                                            \
	(((x) & BIT_MASK_EFS_HCI_SEL_V1_8812F)                                 \
	 << BIT_SHIFT_EFS_HCI_SEL_V1_8812F)
#define BITS_EFS_HCI_SEL_V1_8812F                                              \
	(BIT_MASK_EFS_HCI_SEL_V1_8812F << BIT_SHIFT_EFS_HCI_SEL_V1_8812F)
#define BIT_CLEAR_EFS_HCI_SEL_V1_8812F(x) ((x) & (~BITS_EFS_HCI_SEL_V1_8812F))
#define BIT_GET_EFS_HCI_SEL_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_EFS_HCI_SEL_V1_8812F) &                             \
	 BIT_MASK_EFS_HCI_SEL_V1_8812F)
#define BIT_SET_EFS_HCI_SEL_V1_8812F(x, v)                                     \
	(BIT_CLEAR_EFS_HCI_SEL_V1_8812F(x) | BIT_EFS_HCI_SEL_V1_8812F(v))

/* 2 REG_SYS_STATUS2_8812F */
#define BIT_HIOE_ON_TIMEOUT_8812F BIT(23)
#define BIT_SIC_ON_TIMEOUT_8812F BIT(22)
#define BIT_CPU_ON_TIMEOUT_8812F BIT(21)
#define BIT_HCI_ON_TIMEOUT_8812F BIT(20)
#define BIT_SIO_ALDN_8812F BIT(19)
#define BIT_USB_ALDN_8812F BIT(18)
#define BIT_PCI_ALDN_8812F BIT(17)
#define BIT_SYS_ALDN_8812F BIT(16)

#define BIT_SHIFT_EPVID1_8812F 8
#define BIT_MASK_EPVID1_8812F 0xff
#define BIT_EPVID1_8812F(x)                                                    \
	(((x) & BIT_MASK_EPVID1_8812F) << BIT_SHIFT_EPVID1_8812F)
#define BITS_EPVID1_8812F (BIT_MASK_EPVID1_8812F << BIT_SHIFT_EPVID1_8812F)
#define BIT_CLEAR_EPVID1_8812F(x) ((x) & (~BITS_EPVID1_8812F))
#define BIT_GET_EPVID1_8812F(x)                                                \
	(((x) >> BIT_SHIFT_EPVID1_8812F) & BIT_MASK_EPVID1_8812F)
#define BIT_SET_EPVID1_8812F(x, v)                                             \
	(BIT_CLEAR_EPVID1_8812F(x) | BIT_EPVID1_8812F(v))

#define BIT_SHIFT_EPVID0_8812F 0
#define BIT_MASK_EPVID0_8812F 0xff
#define BIT_EPVID0_8812F(x)                                                    \
	(((x) & BIT_MASK_EPVID0_8812F) << BIT_SHIFT_EPVID0_8812F)
#define BITS_EPVID0_8812F (BIT_MASK_EPVID0_8812F << BIT_SHIFT_EPVID0_8812F)
#define BIT_CLEAR_EPVID0_8812F(x) ((x) & (~BITS_EPVID0_8812F))
#define BIT_GET_EPVID0_8812F(x)                                                \
	(((x) >> BIT_SHIFT_EPVID0_8812F) & BIT_MASK_EPVID0_8812F)
#define BIT_SET_EPVID0_8812F(x, v)                                             \
	(BIT_CLEAR_EPVID0_8812F(x) | BIT_EPVID0_8812F(v))

/* 2 REG_SYS_CFG2_8812F */
#define BIT_HCI_SEL_EMBEDDED_8812F BIT(8)

#define BIT_SHIFT_HW_ID_8812F 0
#define BIT_MASK_HW_ID_8812F 0xff
#define BIT_HW_ID_8812F(x)                                                     \
	(((x) & BIT_MASK_HW_ID_8812F) << BIT_SHIFT_HW_ID_8812F)
#define BITS_HW_ID_8812F (BIT_MASK_HW_ID_8812F << BIT_SHIFT_HW_ID_8812F)
#define BIT_CLEAR_HW_ID_8812F(x) ((x) & (~BITS_HW_ID_8812F))
#define BIT_GET_HW_ID_8812F(x)                                                 \
	(((x) >> BIT_SHIFT_HW_ID_8812F) & BIT_MASK_HW_ID_8812F)
#define BIT_SET_HW_ID_8812F(x, v)                                              \
	(BIT_CLEAR_HW_ID_8812F(x) | BIT_HW_ID_8812F(v))

/* 2 REG_SYS_CFG3_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_ANAPARSW_MAC_0_8812F */
#define BIT_OCP_L_8812F BIT(31)
#define BIT_POWOCP_L_8812F BIT(30)

#define BIT_SHIFT_CF_L_V2_8812F 28
#define BIT_MASK_CF_L_V2_8812F 0x3
#define BIT_CF_L_V2_8812F(x)                                                   \
	(((x) & BIT_MASK_CF_L_V2_8812F) << BIT_SHIFT_CF_L_V2_8812F)
#define BITS_CF_L_V2_8812F (BIT_MASK_CF_L_V2_8812F << BIT_SHIFT_CF_L_V2_8812F)
#define BIT_CLEAR_CF_L_V2_8812F(x) ((x) & (~BITS_CF_L_V2_8812F))
#define BIT_GET_CF_L_V2_8812F(x)                                               \
	(((x) >> BIT_SHIFT_CF_L_V2_8812F) & BIT_MASK_CF_L_V2_8812F)
#define BIT_SET_CF_L_V2_8812F(x, v)                                            \
	(BIT_CLEAR_CF_L_V2_8812F(x) | BIT_CF_L_V2_8812F(v))

#define BIT_SHIFT_CFC_L_V2_8812F 26
#define BIT_MASK_CFC_L_V2_8812F 0x3
#define BIT_CFC_L_V2_8812F(x)                                                  \
	(((x) & BIT_MASK_CFC_L_V2_8812F) << BIT_SHIFT_CFC_L_V2_8812F)
#define BITS_CFC_L_V2_8812F                                                    \
	(BIT_MASK_CFC_L_V2_8812F << BIT_SHIFT_CFC_L_V2_8812F)
#define BIT_CLEAR_CFC_L_V2_8812F(x) ((x) & (~BITS_CFC_L_V2_8812F))
#define BIT_GET_CFC_L_V2_8812F(x)                                              \
	(((x) >> BIT_SHIFT_CFC_L_V2_8812F) & BIT_MASK_CFC_L_V2_8812F)
#define BIT_SET_CFC_L_V2_8812F(x, v)                                           \
	(BIT_CLEAR_CFC_L_V2_8812F(x) | BIT_CFC_L_V2_8812F(v))

#define BIT_SHIFT_R3_L_V2_8812F 24
#define BIT_MASK_R3_L_V2_8812F 0x3
#define BIT_R3_L_V2_8812F(x)                                                   \
	(((x) & BIT_MASK_R3_L_V2_8812F) << BIT_SHIFT_R3_L_V2_8812F)
#define BITS_R3_L_V2_8812F (BIT_MASK_R3_L_V2_8812F << BIT_SHIFT_R3_L_V2_8812F)
#define BIT_CLEAR_R3_L_V2_8812F(x) ((x) & (~BITS_R3_L_V2_8812F))
#define BIT_GET_R3_L_V2_8812F(x)                                               \
	(((x) >> BIT_SHIFT_R3_L_V2_8812F) & BIT_MASK_R3_L_V2_8812F)
#define BIT_SET_R3_L_V2_8812F(x, v)                                            \
	(BIT_CLEAR_R3_L_V2_8812F(x) | BIT_R3_L_V2_8812F(v))

#define BIT_SHIFT_R2_L_8812F 22
#define BIT_MASK_R2_L_8812F 0x3
#define BIT_R2_L_8812F(x) (((x) & BIT_MASK_R2_L_8812F) << BIT_SHIFT_R2_L_8812F)
#define BITS_R2_L_8812F (BIT_MASK_R2_L_8812F << BIT_SHIFT_R2_L_8812F)
#define BIT_CLEAR_R2_L_8812F(x) ((x) & (~BITS_R2_L_8812F))
#define BIT_GET_R2_L_8812F(x)                                                  \
	(((x) >> BIT_SHIFT_R2_L_8812F) & BIT_MASK_R2_L_8812F)
#define BIT_SET_R2_L_8812F(x, v) (BIT_CLEAR_R2_L_8812F(x) | BIT_R2_L_8812F(v))

#define BIT_SHIFT_R1_L_8812F 20
#define BIT_MASK_R1_L_8812F 0x3
#define BIT_R1_L_8812F(x) (((x) & BIT_MASK_R1_L_8812F) << BIT_SHIFT_R1_L_8812F)
#define BITS_R1_L_8812F (BIT_MASK_R1_L_8812F << BIT_SHIFT_R1_L_8812F)
#define BIT_CLEAR_R1_L_8812F(x) ((x) & (~BITS_R1_L_8812F))
#define BIT_GET_R1_L_8812F(x)                                                  \
	(((x) >> BIT_SHIFT_R1_L_8812F) & BIT_MASK_R1_L_8812F)
#define BIT_SET_R1_L_8812F(x, v) (BIT_CLEAR_R1_L_8812F(x) | BIT_R1_L_8812F(v))

#define BIT_SHIFT_C3_L_8812F 18
#define BIT_MASK_C3_L_8812F 0x3
#define BIT_C3_L_8812F(x) (((x) & BIT_MASK_C3_L_8812F) << BIT_SHIFT_C3_L_8812F)
#define BITS_C3_L_8812F (BIT_MASK_C3_L_8812F << BIT_SHIFT_C3_L_8812F)
#define BIT_CLEAR_C3_L_8812F(x) ((x) & (~BITS_C3_L_8812F))
#define BIT_GET_C3_L_8812F(x)                                                  \
	(((x) >> BIT_SHIFT_C3_L_8812F) & BIT_MASK_C3_L_8812F)
#define BIT_SET_C3_L_8812F(x, v) (BIT_CLEAR_C3_L_8812F(x) | BIT_C3_L_8812F(v))

#define BIT_SHIFT_C2_L_8812F 16
#define BIT_MASK_C2_L_8812F 0x3
#define BIT_C2_L_8812F(x) (((x) & BIT_MASK_C2_L_8812F) << BIT_SHIFT_C2_L_8812F)
#define BITS_C2_L_8812F (BIT_MASK_C2_L_8812F << BIT_SHIFT_C2_L_8812F)
#define BIT_CLEAR_C2_L_8812F(x) ((x) & (~BITS_C2_L_8812F))
#define BIT_GET_C2_L_8812F(x)                                                  \
	(((x) >> BIT_SHIFT_C2_L_8812F) & BIT_MASK_C2_L_8812F)
#define BIT_SET_C2_L_8812F(x, v) (BIT_CLEAR_C2_L_8812F(x) | BIT_C2_L_8812F(v))

#define BIT_SHIFT_C1_L_V2_8812F 14
#define BIT_MASK_C1_L_V2_8812F 0x3
#define BIT_C1_L_V2_8812F(x)                                                   \
	(((x) & BIT_MASK_C1_L_V2_8812F) << BIT_SHIFT_C1_L_V2_8812F)
#define BITS_C1_L_V2_8812F (BIT_MASK_C1_L_V2_8812F << BIT_SHIFT_C1_L_V2_8812F)
#define BIT_CLEAR_C1_L_V2_8812F(x) ((x) & (~BITS_C1_L_V2_8812F))
#define BIT_GET_C1_L_V2_8812F(x)                                               \
	(((x) >> BIT_SHIFT_C1_L_V2_8812F) & BIT_MASK_C1_L_V2_8812F)
#define BIT_SET_C1_L_V2_8812F(x, v)                                            \
	(BIT_CLEAR_C1_L_V2_8812F(x) | BIT_C1_L_V2_8812F(v))

#define BIT_REG_OCPS_L_V2_8812F BIT(13)
#define BIT_REG_PWM_L_8812F BIT(12)

#define BIT_SHIFT_V15ADJ_L_8812F 9
#define BIT_MASK_V15ADJ_L_8812F 0x7
#define BIT_V15ADJ_L_8812F(x)                                                  \
	(((x) & BIT_MASK_V15ADJ_L_8812F) << BIT_SHIFT_V15ADJ_L_8812F)
#define BITS_V15ADJ_L_8812F                                                    \
	(BIT_MASK_V15ADJ_L_8812F << BIT_SHIFT_V15ADJ_L_8812F)
#define BIT_CLEAR_V15ADJ_L_8812F(x) ((x) & (~BITS_V15ADJ_L_8812F))
#define BIT_GET_V15ADJ_L_8812F(x)                                              \
	(((x) >> BIT_SHIFT_V15ADJ_L_8812F) & BIT_MASK_V15ADJ_L_8812F)
#define BIT_SET_V15ADJ_L_8812F(x, v)                                           \
	(BIT_CLEAR_V15ADJ_L_8812F(x) | BIT_V15ADJ_L_8812F(v))

#define BIT_SHIFT_IN_L_8812F 6
#define BIT_MASK_IN_L_8812F 0x7
#define BIT_IN_L_8812F(x) (((x) & BIT_MASK_IN_L_8812F) << BIT_SHIFT_IN_L_8812F)
#define BITS_IN_L_8812F (BIT_MASK_IN_L_8812F << BIT_SHIFT_IN_L_8812F)
#define BIT_CLEAR_IN_L_8812F(x) ((x) & (~BITS_IN_L_8812F))
#define BIT_GET_IN_L_8812F(x)                                                  \
	(((x) >> BIT_SHIFT_IN_L_8812F) & BIT_MASK_IN_L_8812F)
#define BIT_SET_IN_L_8812F(x, v) (BIT_CLEAR_IN_L_8812F(x) | BIT_IN_L_8812F(v))

#define BIT_SHIFT_STD_L_8812F 4
#define BIT_MASK_STD_L_8812F 0x3
#define BIT_STD_L_8812F(x)                                                     \
	(((x) & BIT_MASK_STD_L_8812F) << BIT_SHIFT_STD_L_8812F)
#define BITS_STD_L_8812F (BIT_MASK_STD_L_8812F << BIT_SHIFT_STD_L_8812F)
#define BIT_CLEAR_STD_L_8812F(x) ((x) & (~BITS_STD_L_8812F))
#define BIT_GET_STD_L_8812F(x)                                                 \
	(((x) >> BIT_SHIFT_STD_L_8812F) & BIT_MASK_STD_L_8812F)
#define BIT_SET_STD_L_8812F(x, v)                                              \
	(BIT_CLEAR_STD_L_8812F(x) | BIT_STD_L_8812F(v))

#define BIT_SHIFT_VOL_L_8812F 0
#define BIT_MASK_VOL_L_8812F 0xf
#define BIT_VOL_L_8812F(x)                                                     \
	(((x) & BIT_MASK_VOL_L_8812F) << BIT_SHIFT_VOL_L_8812F)
#define BITS_VOL_L_8812F (BIT_MASK_VOL_L_8812F << BIT_SHIFT_VOL_L_8812F)
#define BIT_CLEAR_VOL_L_8812F(x) ((x) & (~BITS_VOL_L_8812F))
#define BIT_GET_VOL_L_8812F(x)                                                 \
	(((x) >> BIT_SHIFT_VOL_L_8812F) & BIT_MASK_VOL_L_8812F)
#define BIT_SET_VOL_L_8812F(x, v)                                              \
	(BIT_CLEAR_VOL_L_8812F(x) | BIT_VOL_L_8812F(v))

/* 2 REG_ANAPARSW_MAC_1_8812F */

#define BIT_SHIFT_OCP_L_PFM_8812F 29
#define BIT_MASK_OCP_L_PFM_8812F 0x7
#define BIT_OCP_L_PFM_8812F(x)                                                 \
	(((x) & BIT_MASK_OCP_L_PFM_8812F) << BIT_SHIFT_OCP_L_PFM_8812F)
#define BITS_OCP_L_PFM_8812F                                                   \
	(BIT_MASK_OCP_L_PFM_8812F << BIT_SHIFT_OCP_L_PFM_8812F)
#define BIT_CLEAR_OCP_L_PFM_8812F(x) ((x) & (~BITS_OCP_L_PFM_8812F))
#define BIT_GET_OCP_L_PFM_8812F(x)                                             \
	(((x) >> BIT_SHIFT_OCP_L_PFM_8812F) & BIT_MASK_OCP_L_PFM_8812F)
#define BIT_SET_OCP_L_PFM_8812F(x, v)                                          \
	(BIT_CLEAR_OCP_L_PFM_8812F(x) | BIT_OCP_L_PFM_8812F(v))

#define BIT_SHIFT_CFC_L_PFM_8812F 27
#define BIT_MASK_CFC_L_PFM_8812F 0x3
#define BIT_CFC_L_PFM_8812F(x)                                                 \
	(((x) & BIT_MASK_CFC_L_PFM_8812F) << BIT_SHIFT_CFC_L_PFM_8812F)
#define BITS_CFC_L_PFM_8812F                                                   \
	(BIT_MASK_CFC_L_PFM_8812F << BIT_SHIFT_CFC_L_PFM_8812F)
#define BIT_CLEAR_CFC_L_PFM_8812F(x) ((x) & (~BITS_CFC_L_PFM_8812F))
#define BIT_GET_CFC_L_PFM_8812F(x)                                             \
	(((x) >> BIT_SHIFT_CFC_L_PFM_8812F) & BIT_MASK_CFC_L_PFM_8812F)
#define BIT_SET_CFC_L_PFM_8812F(x, v)                                          \
	(BIT_CLEAR_CFC_L_PFM_8812F(x) | BIT_CFC_L_PFM_8812F(v))

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_REG_FREQ_L_V1_8812F 20
#define BIT_MASK_REG_FREQ_L_V1_8812F 0x7
#define BIT_REG_FREQ_L_V1_8812F(x)                                             \
	(((x) & BIT_MASK_REG_FREQ_L_V1_8812F) << BIT_SHIFT_REG_FREQ_L_V1_8812F)
#define BITS_REG_FREQ_L_V1_8812F                                               \
	(BIT_MASK_REG_FREQ_L_V1_8812F << BIT_SHIFT_REG_FREQ_L_V1_8812F)
#define BIT_CLEAR_REG_FREQ_L_V1_8812F(x) ((x) & (~BITS_REG_FREQ_L_V1_8812F))
#define BIT_GET_REG_FREQ_L_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_REG_FREQ_L_V1_8812F) & BIT_MASK_REG_FREQ_L_V1_8812F)
#define BIT_SET_REG_FREQ_L_V1_8812F(x, v)                                      \
	(BIT_CLEAR_REG_FREQ_L_V1_8812F(x) | BIT_REG_FREQ_L_V1_8812F(v))

#define BIT_EN_DUTY_8812F BIT(19)

#define BIT_SHIFT_REG_MODE_V2_8812F 17
#define BIT_MASK_REG_MODE_V2_8812F 0x3
#define BIT_REG_MODE_V2_8812F(x)                                               \
	(((x) & BIT_MASK_REG_MODE_V2_8812F) << BIT_SHIFT_REG_MODE_V2_8812F)
#define BITS_REG_MODE_V2_8812F                                                 \
	(BIT_MASK_REG_MODE_V2_8812F << BIT_SHIFT_REG_MODE_V2_8812F)
#define BIT_CLEAR_REG_MODE_V2_8812F(x) ((x) & (~BITS_REG_MODE_V2_8812F))
#define BIT_GET_REG_MODE_V2_8812F(x)                                           \
	(((x) >> BIT_SHIFT_REG_MODE_V2_8812F) & BIT_MASK_REG_MODE_V2_8812F)
#define BIT_SET_REG_MODE_V2_8812F(x, v)                                        \
	(BIT_CLEAR_REG_MODE_V2_8812F(x) | BIT_REG_MODE_V2_8812F(v))

#define BIT_EN_SP_8812F BIT(16)
#define BIT_REG_AUTO_L_V2_8812F BIT(15)
#define BIT_REG_LDOF_L_V2_8812F BIT(14)
#define BIT_REG_TYPE_L_V2_8812F BIT(13)
#define BIT_VO15_V1P05_H_8812F BIT(12)
#define BIT_ARENB_L_V2_8812F BIT(11)

#define BIT_SHIFT_TBOX_L1_V2_8812F 9
#define BIT_MASK_TBOX_L1_V2_8812F 0x3
#define BIT_TBOX_L1_V2_8812F(x)                                                \
	(((x) & BIT_MASK_TBOX_L1_V2_8812F) << BIT_SHIFT_TBOX_L1_V2_8812F)
#define BITS_TBOX_L1_V2_8812F                                                  \
	(BIT_MASK_TBOX_L1_V2_8812F << BIT_SHIFT_TBOX_L1_V2_8812F)
#define BIT_CLEAR_TBOX_L1_V2_8812F(x) ((x) & (~BITS_TBOX_L1_V2_8812F))
#define BIT_GET_TBOX_L1_V2_8812F(x)                                            \
	(((x) >> BIT_SHIFT_TBOX_L1_V2_8812F) & BIT_MASK_TBOX_L1_V2_8812F)
#define BIT_SET_TBOX_L1_V2_8812F(x, v)                                         \
	(BIT_CLEAR_TBOX_L1_V2_8812F(x) | BIT_TBOX_L1_V2_8812F(v))

#define BIT_SHIFT_REG_DELAY_L_8812F 7
#define BIT_MASK_REG_DELAY_L_8812F 0x3
#define BIT_REG_DELAY_L_8812F(x)                                               \
	(((x) & BIT_MASK_REG_DELAY_L_8812F) << BIT_SHIFT_REG_DELAY_L_8812F)
#define BITS_REG_DELAY_L_8812F                                                 \
	(BIT_MASK_REG_DELAY_L_8812F << BIT_SHIFT_REG_DELAY_L_8812F)
#define BIT_CLEAR_REG_DELAY_L_8812F(x) ((x) & (~BITS_REG_DELAY_L_8812F))
#define BIT_GET_REG_DELAY_L_8812F(x)                                           \
	(((x) >> BIT_SHIFT_REG_DELAY_L_8812F) & BIT_MASK_REG_DELAY_L_8812F)
#define BIT_SET_REG_DELAY_L_8812F(x, v)                                        \
	(BIT_CLEAR_REG_DELAY_L_8812F(x) | BIT_REG_DELAY_L_8812F(v))

#define BIT_REG_CLAMP_D_L_8812F BIT(6)
#define BIT_REG_BYPASS_L_V2_8812F BIT(5)
#define BIT_REG_AUTOZCD_L_8812F BIT(4)
#define BIT_POW_ZCD_L_V2_8812F BIT(3)
#define BIT_REG_HALF_L_8812F BIT(2)

#define BIT_SHIFT_OCP_L_V2_8812F 0
#define BIT_MASK_OCP_L_V2_8812F 0x3
#define BIT_OCP_L_V2_8812F(x)                                                  \
	(((x) & BIT_MASK_OCP_L_V2_8812F) << BIT_SHIFT_OCP_L_V2_8812F)
#define BITS_OCP_L_V2_8812F                                                    \
	(BIT_MASK_OCP_L_V2_8812F << BIT_SHIFT_OCP_L_V2_8812F)
#define BIT_CLEAR_OCP_L_V2_8812F(x) ((x) & (~BITS_OCP_L_V2_8812F))
#define BIT_GET_OCP_L_V2_8812F(x)                                              \
	(((x) >> BIT_SHIFT_OCP_L_V2_8812F) & BIT_MASK_OCP_L_V2_8812F)
#define BIT_SET_OCP_L_V2_8812F(x, v)                                           \
	(BIT_CLEAR_OCP_L_V2_8812F(x) | BIT_OCP_L_V2_8812F(v))

/* 2 REG_ANAPAR_MAC_0_8812F */

#define BIT_SHIFT_REG_LPF_R3_8812F 29
#define BIT_MASK_REG_LPF_R3_8812F 0x7
#define BIT_REG_LPF_R3_8812F(x)                                                \
	(((x) & BIT_MASK_REG_LPF_R3_8812F) << BIT_SHIFT_REG_LPF_R3_8812F)
#define BITS_REG_LPF_R3_8812F                                                  \
	(BIT_MASK_REG_LPF_R3_8812F << BIT_SHIFT_REG_LPF_R3_8812F)
#define BIT_CLEAR_REG_LPF_R3_8812F(x) ((x) & (~BITS_REG_LPF_R3_8812F))
#define BIT_GET_REG_LPF_R3_8812F(x)                                            \
	(((x) >> BIT_SHIFT_REG_LPF_R3_8812F) & BIT_MASK_REG_LPF_R3_8812F)
#define BIT_SET_REG_LPF_R3_8812F(x, v)                                         \
	(BIT_CLEAR_REG_LPF_R3_8812F(x) | BIT_REG_LPF_R3_8812F(v))

#define BIT_SHIFT_REG_LPF_R2_8812F 24
#define BIT_MASK_REG_LPF_R2_8812F 0x1f
#define BIT_REG_LPF_R2_8812F(x)                                                \
	(((x) & BIT_MASK_REG_LPF_R2_8812F) << BIT_SHIFT_REG_LPF_R2_8812F)
#define BITS_REG_LPF_R2_8812F                                                  \
	(BIT_MASK_REG_LPF_R2_8812F << BIT_SHIFT_REG_LPF_R2_8812F)
#define BIT_CLEAR_REG_LPF_R2_8812F(x) ((x) & (~BITS_REG_LPF_R2_8812F))
#define BIT_GET_REG_LPF_R2_8812F(x)                                            \
	(((x) >> BIT_SHIFT_REG_LPF_R2_8812F) & BIT_MASK_REG_LPF_R2_8812F)
#define BIT_SET_REG_LPF_R2_8812F(x, v)                                         \
	(BIT_CLEAR_REG_LPF_R2_8812F(x) | BIT_REG_LPF_R2_8812F(v))

#define BIT_SHIFT_REG_LPF_C3_8812F 21
#define BIT_MASK_REG_LPF_C3_8812F 0x7
#define BIT_REG_LPF_C3_8812F(x)                                                \
	(((x) & BIT_MASK_REG_LPF_C3_8812F) << BIT_SHIFT_REG_LPF_C3_8812F)
#define BITS_REG_LPF_C3_8812F                                                  \
	(BIT_MASK_REG_LPF_C3_8812F << BIT_SHIFT_REG_LPF_C3_8812F)
#define BIT_CLEAR_REG_LPF_C3_8812F(x) ((x) & (~BITS_REG_LPF_C3_8812F))
#define BIT_GET_REG_LPF_C3_8812F(x)                                            \
	(((x) >> BIT_SHIFT_REG_LPF_C3_8812F) & BIT_MASK_REG_LPF_C3_8812F)
#define BIT_SET_REG_LPF_C3_8812F(x, v)                                         \
	(BIT_CLEAR_REG_LPF_C3_8812F(x) | BIT_REG_LPF_C3_8812F(v))

#define BIT_SHIFT_REG_LPF_C2_8812F 18
#define BIT_MASK_REG_LPF_C2_8812F 0x7
#define BIT_REG_LPF_C2_8812F(x)                                                \
	(((x) & BIT_MASK_REG_LPF_C2_8812F) << BIT_SHIFT_REG_LPF_C2_8812F)
#define BITS_REG_LPF_C2_8812F                                                  \
	(BIT_MASK_REG_LPF_C2_8812F << BIT_SHIFT_REG_LPF_C2_8812F)
#define BIT_CLEAR_REG_LPF_C2_8812F(x) ((x) & (~BITS_REG_LPF_C2_8812F))
#define BIT_GET_REG_LPF_C2_8812F(x)                                            \
	(((x) >> BIT_SHIFT_REG_LPF_C2_8812F) & BIT_MASK_REG_LPF_C2_8812F)
#define BIT_SET_REG_LPF_C2_8812F(x, v)                                         \
	(BIT_CLEAR_REG_LPF_C2_8812F(x) | BIT_REG_LPF_C2_8812F(v))

#define BIT_SHIFT_REG_LPF_C1_8812F 15
#define BIT_MASK_REG_LPF_C1_8812F 0x7
#define BIT_REG_LPF_C1_8812F(x)                                                \
	(((x) & BIT_MASK_REG_LPF_C1_8812F) << BIT_SHIFT_REG_LPF_C1_8812F)
#define BITS_REG_LPF_C1_8812F                                                  \
	(BIT_MASK_REG_LPF_C1_8812F << BIT_SHIFT_REG_LPF_C1_8812F)
#define BIT_CLEAR_REG_LPF_C1_8812F(x) ((x) & (~BITS_REG_LPF_C1_8812F))
#define BIT_GET_REG_LPF_C1_8812F(x)                                            \
	(((x) >> BIT_SHIFT_REG_LPF_C1_8812F) & BIT_MASK_REG_LPF_C1_8812F)
#define BIT_SET_REG_LPF_C1_8812F(x, v)                                         \
	(BIT_CLEAR_REG_LPF_C1_8812F(x) | BIT_REG_LPF_C1_8812F(v))

#define BIT_SHIFT_REG_LDO_SEL_V1_8812F 13
#define BIT_MASK_REG_LDO_SEL_V1_8812F 0x3
#define BIT_REG_LDO_SEL_V1_8812F(x)                                            \
	(((x) & BIT_MASK_REG_LDO_SEL_V1_8812F)                                 \
	 << BIT_SHIFT_REG_LDO_SEL_V1_8812F)
#define BITS_REG_LDO_SEL_V1_8812F                                              \
	(BIT_MASK_REG_LDO_SEL_V1_8812F << BIT_SHIFT_REG_LDO_SEL_V1_8812F)
#define BIT_CLEAR_REG_LDO_SEL_V1_8812F(x) ((x) & (~BITS_REG_LDO_SEL_V1_8812F))
#define BIT_GET_REG_LDO_SEL_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_REG_LDO_SEL_V1_8812F) &                             \
	 BIT_MASK_REG_LDO_SEL_V1_8812F)
#define BIT_SET_REG_LDO_SEL_V1_8812F(x, v)                                     \
	(BIT_CLEAR_REG_LDO_SEL_V1_8812F(x) | BIT_REG_LDO_SEL_V1_8812F(v))

#define BIT_REG_CP_ICPX2_8812F BIT(12)

#define BIT_SHIFT_REG_CP_ICP_SEL_FAST_8812F 9
#define BIT_MASK_REG_CP_ICP_SEL_FAST_8812F 0x7
#define BIT_REG_CP_ICP_SEL_FAST_8812F(x)                                       \
	(((x) & BIT_MASK_REG_CP_ICP_SEL_FAST_8812F)                            \
	 << BIT_SHIFT_REG_CP_ICP_SEL_FAST_8812F)
#define BITS_REG_CP_ICP_SEL_FAST_8812F                                         \
	(BIT_MASK_REG_CP_ICP_SEL_FAST_8812F                                    \
	 << BIT_SHIFT_REG_CP_ICP_SEL_FAST_8812F)
#define BIT_CLEAR_REG_CP_ICP_SEL_FAST_8812F(x)                                 \
	((x) & (~BITS_REG_CP_ICP_SEL_FAST_8812F))
#define BIT_GET_REG_CP_ICP_SEL_FAST_8812F(x)                                   \
	(((x) >> BIT_SHIFT_REG_CP_ICP_SEL_FAST_8812F) &                        \
	 BIT_MASK_REG_CP_ICP_SEL_FAST_8812F)
#define BIT_SET_REG_CP_ICP_SEL_FAST_8812F(x, v)                                \
	(BIT_CLEAR_REG_CP_ICP_SEL_FAST_8812F(x) |                              \
	 BIT_REG_CP_ICP_SEL_FAST_8812F(v))

#define BIT_SHIFT_REG_CP_ICP_SEL_8812F 6
#define BIT_MASK_REG_CP_ICP_SEL_8812F 0x7
#define BIT_REG_CP_ICP_SEL_8812F(x)                                            \
	(((x) & BIT_MASK_REG_CP_ICP_SEL_8812F)                                 \
	 << BIT_SHIFT_REG_CP_ICP_SEL_8812F)
#define BITS_REG_CP_ICP_SEL_8812F                                              \
	(BIT_MASK_REG_CP_ICP_SEL_8812F << BIT_SHIFT_REG_CP_ICP_SEL_8812F)
#define BIT_CLEAR_REG_CP_ICP_SEL_8812F(x) ((x) & (~BITS_REG_CP_ICP_SEL_8812F))
#define BIT_GET_REG_CP_ICP_SEL_8812F(x)                                        \
	(((x) >> BIT_SHIFT_REG_CP_ICP_SEL_8812F) &                             \
	 BIT_MASK_REG_CP_ICP_SEL_8812F)
#define BIT_SET_REG_CP_ICP_SEL_8812F(x, v)                                     \
	(BIT_CLEAR_REG_CP_ICP_SEL_8812F(x) | BIT_REG_CP_ICP_SEL_8812F(v))

#define BIT_SHIFT_REG_IB_PI_8812F 4
#define BIT_MASK_REG_IB_PI_8812F 0x3
#define BIT_REG_IB_PI_8812F(x)                                                 \
	(((x) & BIT_MASK_REG_IB_PI_8812F) << BIT_SHIFT_REG_IB_PI_8812F)
#define BITS_REG_IB_PI_8812F                                                   \
	(BIT_MASK_REG_IB_PI_8812F << BIT_SHIFT_REG_IB_PI_8812F)
#define BIT_CLEAR_REG_IB_PI_8812F(x) ((x) & (~BITS_REG_IB_PI_8812F))
#define BIT_GET_REG_IB_PI_8812F(x)                                             \
	(((x) >> BIT_SHIFT_REG_IB_PI_8812F) & BIT_MASK_REG_IB_PI_8812F)
#define BIT_SET_REG_IB_PI_8812F(x, v)                                          \
	(BIT_CLEAR_REG_IB_PI_8812F(x) | BIT_REG_IB_PI_8812F(v))

#define BIT_LDO2PWRCUT_8812F BIT(3)
#define BIT_VPULSE_LDO_8812F BIT(2)

#define BIT_SHIFT_LDO_VSEL_8812F 0
#define BIT_MASK_LDO_VSEL_8812F 0x3
#define BIT_LDO_VSEL_8812F(x)                                                  \
	(((x) & BIT_MASK_LDO_VSEL_8812F) << BIT_SHIFT_LDO_VSEL_8812F)
#define BITS_LDO_VSEL_8812F                                                    \
	(BIT_MASK_LDO_VSEL_8812F << BIT_SHIFT_LDO_VSEL_8812F)
#define BIT_CLEAR_LDO_VSEL_8812F(x) ((x) & (~BITS_LDO_VSEL_8812F))
#define BIT_GET_LDO_VSEL_8812F(x)                                              \
	(((x) >> BIT_SHIFT_LDO_VSEL_8812F) & BIT_MASK_LDO_VSEL_8812F)
#define BIT_SET_LDO_VSEL_8812F(x, v)                                           \
	(BIT_CLEAR_LDO_VSEL_8812F(x) | BIT_LDO_VSEL_8812F(v))

/* 2 REG_ANAPAR_MAC_1_8812F */

#define BIT_SHIFT_REG_CK_MON_SEL_8812F 29
#define BIT_MASK_REG_CK_MON_SEL_8812F 0x7
#define BIT_REG_CK_MON_SEL_8812F(x)                                            \
	(((x) & BIT_MASK_REG_CK_MON_SEL_8812F)                                 \
	 << BIT_SHIFT_REG_CK_MON_SEL_8812F)
#define BITS_REG_CK_MON_SEL_8812F                                              \
	(BIT_MASK_REG_CK_MON_SEL_8812F << BIT_SHIFT_REG_CK_MON_SEL_8812F)
#define BIT_CLEAR_REG_CK_MON_SEL_8812F(x) ((x) & (~BITS_REG_CK_MON_SEL_8812F))
#define BIT_GET_REG_CK_MON_SEL_8812F(x)                                        \
	(((x) >> BIT_SHIFT_REG_CK_MON_SEL_8812F) &                             \
	 BIT_MASK_REG_CK_MON_SEL_8812F)
#define BIT_SET_REG_CK_MON_SEL_8812F(x, v)                                     \
	(BIT_CLEAR_REG_CK_MON_SEL_8812F(x) | BIT_REG_CK_MON_SEL_8812F(v))

#define BIT_REG_CK_MON_EN_8812F BIT(28)
#define BIT_REG_XTAL_FREQ_SEL_8812F BIT(27)
#define BIT_REG_XTAL_EDGE_SEL_8812F BIT(26)
#define BIT_REG_VCO_KVCO_8812F BIT(25)
#define BIT_REG_SDM_EDGE_SEL_8812F BIT(24)
#define BIT_REG_SDM_CK_SEL_8812F BIT(23)
#define BIT_REG_SDM_CK_GATED_8812F BIT(22)
#define BIT_REG_PFD_RESET_GATED_8812F BIT(21)

#define BIT_SHIFT_REG_LPF_R3_FAST_8812F 16
#define BIT_MASK_REG_LPF_R3_FAST_8812F 0x1f
#define BIT_REG_LPF_R3_FAST_8812F(x)                                           \
	(((x) & BIT_MASK_REG_LPF_R3_FAST_8812F)                                \
	 << BIT_SHIFT_REG_LPF_R3_FAST_8812F)
#define BITS_REG_LPF_R3_FAST_8812F                                             \
	(BIT_MASK_REG_LPF_R3_FAST_8812F << BIT_SHIFT_REG_LPF_R3_FAST_8812F)
#define BIT_CLEAR_REG_LPF_R3_FAST_8812F(x) ((x) & (~BITS_REG_LPF_R3_FAST_8812F))
#define BIT_GET_REG_LPF_R3_FAST_8812F(x)                                       \
	(((x) >> BIT_SHIFT_REG_LPF_R3_FAST_8812F) &                            \
	 BIT_MASK_REG_LPF_R3_FAST_8812F)
#define BIT_SET_REG_LPF_R3_FAST_8812F(x, v)                                    \
	(BIT_CLEAR_REG_LPF_R3_FAST_8812F(x) | BIT_REG_LPF_R3_FAST_8812F(v))

#define BIT_SHIFT_REG_LPF_R2_FAST_8812F 11
#define BIT_MASK_REG_LPF_R2_FAST_8812F 0x1f
#define BIT_REG_LPF_R2_FAST_8812F(x)                                           \
	(((x) & BIT_MASK_REG_LPF_R2_FAST_8812F)                                \
	 << BIT_SHIFT_REG_LPF_R2_FAST_8812F)
#define BITS_REG_LPF_R2_FAST_8812F                                             \
	(BIT_MASK_REG_LPF_R2_FAST_8812F << BIT_SHIFT_REG_LPF_R2_FAST_8812F)
#define BIT_CLEAR_REG_LPF_R2_FAST_8812F(x) ((x) & (~BITS_REG_LPF_R2_FAST_8812F))
#define BIT_GET_REG_LPF_R2_FAST_8812F(x)                                       \
	(((x) >> BIT_SHIFT_REG_LPF_R2_FAST_8812F) &                            \
	 BIT_MASK_REG_LPF_R2_FAST_8812F)
#define BIT_SET_REG_LPF_R2_FAST_8812F(x, v)                                    \
	(BIT_CLEAR_REG_LPF_R2_FAST_8812F(x) | BIT_REG_LPF_R2_FAST_8812F(v))

#define BIT_SHIFT_REG_LPF_C3_FAST_8812F 8
#define BIT_MASK_REG_LPF_C3_FAST_8812F 0x7
#define BIT_REG_LPF_C3_FAST_8812F(x)                                           \
	(((x) & BIT_MASK_REG_LPF_C3_FAST_8812F)                                \
	 << BIT_SHIFT_REG_LPF_C3_FAST_8812F)
#define BITS_REG_LPF_C3_FAST_8812F                                             \
	(BIT_MASK_REG_LPF_C3_FAST_8812F << BIT_SHIFT_REG_LPF_C3_FAST_8812F)
#define BIT_CLEAR_REG_LPF_C3_FAST_8812F(x) ((x) & (~BITS_REG_LPF_C3_FAST_8812F))
#define BIT_GET_REG_LPF_C3_FAST_8812F(x)                                       \
	(((x) >> BIT_SHIFT_REG_LPF_C3_FAST_8812F) &                            \
	 BIT_MASK_REG_LPF_C3_FAST_8812F)
#define BIT_SET_REG_LPF_C3_FAST_8812F(x, v)                                    \
	(BIT_CLEAR_REG_LPF_C3_FAST_8812F(x) | BIT_REG_LPF_C3_FAST_8812F(v))

#define BIT_SHIFT_REG_LPF_C2_FAST_8812F 5
#define BIT_MASK_REG_LPF_C2_FAST_8812F 0x7
#define BIT_REG_LPF_C2_FAST_8812F(x)                                           \
	(((x) & BIT_MASK_REG_LPF_C2_FAST_8812F)                                \
	 << BIT_SHIFT_REG_LPF_C2_FAST_8812F)
#define BITS_REG_LPF_C2_FAST_8812F                                             \
	(BIT_MASK_REG_LPF_C2_FAST_8812F << BIT_SHIFT_REG_LPF_C2_FAST_8812F)
#define BIT_CLEAR_REG_LPF_C2_FAST_8812F(x) ((x) & (~BITS_REG_LPF_C2_FAST_8812F))
#define BIT_GET_REG_LPF_C2_FAST_8812F(x)                                       \
	(((x) >> BIT_SHIFT_REG_LPF_C2_FAST_8812F) &                            \
	 BIT_MASK_REG_LPF_C2_FAST_8812F)
#define BIT_SET_REG_LPF_C2_FAST_8812F(x, v)                                    \
	(BIT_CLEAR_REG_LPF_C2_FAST_8812F(x) | BIT_REG_LPF_C2_FAST_8812F(v))

#define BIT_SHIFT_REG_LPF_C1_FAST_8812F 2
#define BIT_MASK_REG_LPF_C1_FAST_8812F 0x7
#define BIT_REG_LPF_C1_FAST_8812F(x)                                           \
	(((x) & BIT_MASK_REG_LPF_C1_FAST_8812F)                                \
	 << BIT_SHIFT_REG_LPF_C1_FAST_8812F)
#define BITS_REG_LPF_C1_FAST_8812F                                             \
	(BIT_MASK_REG_LPF_C1_FAST_8812F << BIT_SHIFT_REG_LPF_C1_FAST_8812F)
#define BIT_CLEAR_REG_LPF_C1_FAST_8812F(x) ((x) & (~BITS_REG_LPF_C1_FAST_8812F))
#define BIT_GET_REG_LPF_C1_FAST_8812F(x)                                       \
	(((x) >> BIT_SHIFT_REG_LPF_C1_FAST_8812F) &                            \
	 BIT_MASK_REG_LPF_C1_FAST_8812F)
#define BIT_SET_REG_LPF_C1_FAST_8812F(x, v)                                    \
	(BIT_CLEAR_REG_LPF_C1_FAST_8812F(x) | BIT_REG_LPF_C1_FAST_8812F(v))

#define BIT_SHIFT_REG_LPF_R3_V1_8812F 0
#define BIT_MASK_REG_LPF_R3_V1_8812F 0x3
#define BIT_REG_LPF_R3_V1_8812F(x)                                             \
	(((x) & BIT_MASK_REG_LPF_R3_V1_8812F) << BIT_SHIFT_REG_LPF_R3_V1_8812F)
#define BITS_REG_LPF_R3_V1_8812F                                               \
	(BIT_MASK_REG_LPF_R3_V1_8812F << BIT_SHIFT_REG_LPF_R3_V1_8812F)
#define BIT_CLEAR_REG_LPF_R3_V1_8812F(x) ((x) & (~BITS_REG_LPF_R3_V1_8812F))
#define BIT_GET_REG_LPF_R3_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_REG_LPF_R3_V1_8812F) & BIT_MASK_REG_LPF_R3_V1_8812F)
#define BIT_SET_REG_LPF_R3_V1_8812F(x, v)                                      \
	(BIT_CLEAR_REG_LPF_R3_V1_8812F(x) | BIT_REG_LPF_R3_V1_8812F(v))

/* 2 REG_ANAPAR_MAC_2_8812F */

#define BIT_SHIFT_AGPIO_DRV_V1_8812F 30
#define BIT_MASK_AGPIO_DRV_V1_8812F 0x3
#define BIT_AGPIO_DRV_V1_8812F(x)                                              \
	(((x) & BIT_MASK_AGPIO_DRV_V1_8812F) << BIT_SHIFT_AGPIO_DRV_V1_8812F)
#define BITS_AGPIO_DRV_V1_8812F                                                \
	(BIT_MASK_AGPIO_DRV_V1_8812F << BIT_SHIFT_AGPIO_DRV_V1_8812F)
#define BIT_CLEAR_AGPIO_DRV_V1_8812F(x) ((x) & (~BITS_AGPIO_DRV_V1_8812F))
#define BIT_GET_AGPIO_DRV_V1_8812F(x)                                          \
	(((x) >> BIT_SHIFT_AGPIO_DRV_V1_8812F) & BIT_MASK_AGPIO_DRV_V1_8812F)
#define BIT_SET_AGPIO_DRV_V1_8812F(x, v)                                       \
	(BIT_CLEAR_AGPIO_DRV_V1_8812F(x) | BIT_AGPIO_DRV_V1_8812F(v))

#define BIT_AGPIO_GPO_V1_8812F BIT(29)
#define BIT_AGPIO_GPE_V1_8812F BIT(28)
#define BIT_SEL_CLK_8812F BIT(27)

#define BIT_SHIFT_LS_XTAL_SEL_8812F 23
#define BIT_MASK_LS_XTAL_SEL_8812F 0xf
#define BIT_LS_XTAL_SEL_8812F(x)                                               \
	(((x) & BIT_MASK_LS_XTAL_SEL_8812F) << BIT_SHIFT_LS_XTAL_SEL_8812F)
#define BITS_LS_XTAL_SEL_8812F                                                 \
	(BIT_MASK_LS_XTAL_SEL_8812F << BIT_SHIFT_LS_XTAL_SEL_8812F)
#define BIT_CLEAR_LS_XTAL_SEL_8812F(x) ((x) & (~BITS_LS_XTAL_SEL_8812F))
#define BIT_GET_LS_XTAL_SEL_8812F(x)                                           \
	(((x) >> BIT_SHIFT_LS_XTAL_SEL_8812F) & BIT_MASK_LS_XTAL_SEL_8812F)
#define BIT_SET_LS_XTAL_SEL_8812F(x, v)                                        \
	(BIT_CLEAR_LS_XTAL_SEL_8812F(x) | BIT_LS_XTAL_SEL_8812F(v))

#define BIT_LS_SDM_ORDER_V1_8812F BIT(22)
#define BIT_LS_DELAY_PH_8812F BIT(21)
#define BIT_DIVIDER_SEL_8812F BIT(20)

#define BIT_SHIFT_PCODE_8812F 15
#define BIT_MASK_PCODE_8812F 0x1f
#define BIT_PCODE_8812F(x)                                                     \
	(((x) & BIT_MASK_PCODE_8812F) << BIT_SHIFT_PCODE_8812F)
#define BITS_PCODE_8812F (BIT_MASK_PCODE_8812F << BIT_SHIFT_PCODE_8812F)
#define BIT_CLEAR_PCODE_8812F(x) ((x) & (~BITS_PCODE_8812F))
#define BIT_GET_PCODE_8812F(x)                                                 \
	(((x) >> BIT_SHIFT_PCODE_8812F) & BIT_MASK_PCODE_8812F)
#define BIT_SET_PCODE_8812F(x, v)                                              \
	(BIT_CLEAR_PCODE_8812F(x) | BIT_PCODE_8812F(v))

#define BIT_SHIFT_NCODE_8812F 7
#define BIT_MASK_NCODE_8812F 0xff
#define BIT_NCODE_8812F(x)                                                     \
	(((x) & BIT_MASK_NCODE_8812F) << BIT_SHIFT_NCODE_8812F)
#define BITS_NCODE_8812F (BIT_MASK_NCODE_8812F << BIT_SHIFT_NCODE_8812F)
#define BIT_CLEAR_NCODE_8812F(x) ((x) & (~BITS_NCODE_8812F))
#define BIT_GET_NCODE_8812F(x)                                                 \
	(((x) >> BIT_SHIFT_NCODE_8812F) & BIT_MASK_NCODE_8812F)
#define BIT_SET_NCODE_8812F(x, v)                                              \
	(BIT_CLEAR_NCODE_8812F(x) | BIT_NCODE_8812F(v))

#define BIT_REG_BEACON_8812F BIT(6)
#define BIT_REG_MBIASE_8812F BIT(5)

#define BIT_SHIFT_REG_FAST_SEL_8812F 3
#define BIT_MASK_REG_FAST_SEL_8812F 0x3
#define BIT_REG_FAST_SEL_8812F(x)                                              \
	(((x) & BIT_MASK_REG_FAST_SEL_8812F) << BIT_SHIFT_REG_FAST_SEL_8812F)
#define BITS_REG_FAST_SEL_8812F                                                \
	(BIT_MASK_REG_FAST_SEL_8812F << BIT_SHIFT_REG_FAST_SEL_8812F)
#define BIT_CLEAR_REG_FAST_SEL_8812F(x) ((x) & (~BITS_REG_FAST_SEL_8812F))
#define BIT_GET_REG_FAST_SEL_8812F(x)                                          \
	(((x) >> BIT_SHIFT_REG_FAST_SEL_8812F) & BIT_MASK_REG_FAST_SEL_8812F)
#define BIT_SET_REG_FAST_SEL_8812F(x, v)                                       \
	(BIT_CLEAR_REG_FAST_SEL_8812F(x) | BIT_REG_FAST_SEL_8812F(v))

#define BIT_REG_CK960M_EN_8812F BIT(2)
#define BIT_REG_CK320M_EN_8812F BIT(1)
#define BIT_REG_CK_5M_EN_8812F BIT(0)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_ANAPAR_XTAL_0_8812F */
#define BIT_XTAL_SC_LPS_8812F BIT(31)

#define BIT_SHIFT_XTAL_SC_INIT_8812F 24
#define BIT_MASK_XTAL_SC_INIT_8812F 0x7f
#define BIT_XTAL_SC_INIT_8812F(x)                                              \
	(((x) & BIT_MASK_XTAL_SC_INIT_8812F) << BIT_SHIFT_XTAL_SC_INIT_8812F)
#define BITS_XTAL_SC_INIT_8812F                                                \
	(BIT_MASK_XTAL_SC_INIT_8812F << BIT_SHIFT_XTAL_SC_INIT_8812F)
#define BIT_CLEAR_XTAL_SC_INIT_8812F(x) ((x) & (~BITS_XTAL_SC_INIT_8812F))
#define BIT_GET_XTAL_SC_INIT_8812F(x)                                          \
	(((x) >> BIT_SHIFT_XTAL_SC_INIT_8812F) & BIT_MASK_XTAL_SC_INIT_8812F)
#define BIT_SET_XTAL_SC_INIT_8812F(x, v)                                       \
	(BIT_CLEAR_XTAL_SC_INIT_8812F(x) | BIT_XTAL_SC_INIT_8812F(v))

#define BIT_SHIFT_XTAL_SC_XO_8812F 17
#define BIT_MASK_XTAL_SC_XO_8812F 0x7f
#define BIT_XTAL_SC_XO_8812F(x)                                                \
	(((x) & BIT_MASK_XTAL_SC_XO_8812F) << BIT_SHIFT_XTAL_SC_XO_8812F)
#define BITS_XTAL_SC_XO_8812F                                                  \
	(BIT_MASK_XTAL_SC_XO_8812F << BIT_SHIFT_XTAL_SC_XO_8812F)
#define BIT_CLEAR_XTAL_SC_XO_8812F(x) ((x) & (~BITS_XTAL_SC_XO_8812F))
#define BIT_GET_XTAL_SC_XO_8812F(x)                                            \
	(((x) >> BIT_SHIFT_XTAL_SC_XO_8812F) & BIT_MASK_XTAL_SC_XO_8812F)
#define BIT_SET_XTAL_SC_XO_8812F(x, v)                                         \
	(BIT_CLEAR_XTAL_SC_XO_8812F(x) | BIT_XTAL_SC_XO_8812F(v))

#define BIT_SHIFT_XTAL_SC_XI_8812F 10
#define BIT_MASK_XTAL_SC_XI_8812F 0x7f
#define BIT_XTAL_SC_XI_8812F(x)                                                \
	(((x) & BIT_MASK_XTAL_SC_XI_8812F) << BIT_SHIFT_XTAL_SC_XI_8812F)
#define BITS_XTAL_SC_XI_8812F                                                  \
	(BIT_MASK_XTAL_SC_XI_8812F << BIT_SHIFT_XTAL_SC_XI_8812F)
#define BIT_CLEAR_XTAL_SC_XI_8812F(x) ((x) & (~BITS_XTAL_SC_XI_8812F))
#define BIT_GET_XTAL_SC_XI_8812F(x)                                            \
	(((x) >> BIT_SHIFT_XTAL_SC_XI_8812F) & BIT_MASK_XTAL_SC_XI_8812F)
#define BIT_SET_XTAL_SC_XI_8812F(x, v)                                         \
	(BIT_CLEAR_XTAL_SC_XI_8812F(x) | BIT_XTAL_SC_XI_8812F(v))

#define BIT_SHIFT_XTAL_GMN_V3_8812F 5
#define BIT_MASK_XTAL_GMN_V3_8812F 0x1f
#define BIT_XTAL_GMN_V3_8812F(x)                                               \
	(((x) & BIT_MASK_XTAL_GMN_V3_8812F) << BIT_SHIFT_XTAL_GMN_V3_8812F)
#define BITS_XTAL_GMN_V3_8812F                                                 \
	(BIT_MASK_XTAL_GMN_V3_8812F << BIT_SHIFT_XTAL_GMN_V3_8812F)
#define BIT_CLEAR_XTAL_GMN_V3_8812F(x) ((x) & (~BITS_XTAL_GMN_V3_8812F))
#define BIT_GET_XTAL_GMN_V3_8812F(x)                                           \
	(((x) >> BIT_SHIFT_XTAL_GMN_V3_8812F) & BIT_MASK_XTAL_GMN_V3_8812F)
#define BIT_SET_XTAL_GMN_V3_8812F(x, v)                                        \
	(BIT_CLEAR_XTAL_GMN_V3_8812F(x) | BIT_XTAL_GMN_V3_8812F(v))

#define BIT_SHIFT_XTAL_GMP_V3_8812F 0
#define BIT_MASK_XTAL_GMP_V3_8812F 0x1f
#define BIT_XTAL_GMP_V3_8812F(x)                                               \
	(((x) & BIT_MASK_XTAL_GMP_V3_8812F) << BIT_SHIFT_XTAL_GMP_V3_8812F)
#define BITS_XTAL_GMP_V3_8812F                                                 \
	(BIT_MASK_XTAL_GMP_V3_8812F << BIT_SHIFT_XTAL_GMP_V3_8812F)
#define BIT_CLEAR_XTAL_GMP_V3_8812F(x) ((x) & (~BITS_XTAL_GMP_V3_8812F))
#define BIT_GET_XTAL_GMP_V3_8812F(x)                                           \
	(((x) >> BIT_SHIFT_XTAL_GMP_V3_8812F) & BIT_MASK_XTAL_GMP_V3_8812F)
#define BIT_SET_XTAL_GMP_V3_8812F(x, v)                                        \
	(BIT_CLEAR_XTAL_GMP_V3_8812F(x) | BIT_XTAL_GMP_V3_8812F(v))

/* 2 REG_ANAPAR_XTAL_1_8812F */
#define BIT_XTAL_SEL_TOK_V1_8812F BIT(31)
#define BIT_XTAL_DELAY_DIGI_V2_8812F BIT(30)
#define BIT_XTAL_DELAY_USB_V2_8812F BIT(29)
#define BIT_XTAL_DELAY_AFE_V2_8812F BIT(28)

#define BIT_SHIFT_XTAL_DRV_DIGI_V2_8812F 26
#define BIT_MASK_XTAL_DRV_DIGI_V2_8812F 0x3
#define BIT_XTAL_DRV_DIGI_V2_8812F(x)                                          \
	(((x) & BIT_MASK_XTAL_DRV_DIGI_V2_8812F)                               \
	 << BIT_SHIFT_XTAL_DRV_DIGI_V2_8812F)
#define BITS_XTAL_DRV_DIGI_V2_8812F                                            \
	(BIT_MASK_XTAL_DRV_DIGI_V2_8812F << BIT_SHIFT_XTAL_DRV_DIGI_V2_8812F)
#define BIT_CLEAR_XTAL_DRV_DIGI_V2_8812F(x)                                    \
	((x) & (~BITS_XTAL_DRV_DIGI_V2_8812F))
#define BIT_GET_XTAL_DRV_DIGI_V2_8812F(x)                                      \
	(((x) >> BIT_SHIFT_XTAL_DRV_DIGI_V2_8812F) &                           \
	 BIT_MASK_XTAL_DRV_DIGI_V2_8812F)
#define BIT_SET_XTAL_DRV_DIGI_V2_8812F(x, v)                                   \
	(BIT_CLEAR_XTAL_DRV_DIGI_V2_8812F(x) | BIT_XTAL_DRV_DIGI_V2_8812F(v))

#define BIT_EN_XTAL_DRV_LPS_8812F BIT(25)
#define BIT_EN_XTAL_DRV_DIGI_V2_8812F BIT(24)

#define BIT_SHIFT_XTAL_DRV_USB_8812F 22
#define BIT_MASK_XTAL_DRV_USB_8812F 0x3
#define BIT_XTAL_DRV_USB_8812F(x)                                              \
	(((x) & BIT_MASK_XTAL_DRV_USB_8812F) << BIT_SHIFT_XTAL_DRV_USB_8812F)
#define BITS_XTAL_DRV_USB_8812F                                                \
	(BIT_MASK_XTAL_DRV_USB_8812F << BIT_SHIFT_XTAL_DRV_USB_8812F)
#define BIT_CLEAR_XTAL_DRV_USB_8812F(x) ((x) & (~BITS_XTAL_DRV_USB_8812F))
#define BIT_GET_XTAL_DRV_USB_8812F(x)                                          \
	(((x) >> BIT_SHIFT_XTAL_DRV_USB_8812F) & BIT_MASK_XTAL_DRV_USB_8812F)
#define BIT_SET_XTAL_DRV_USB_8812F(x, v)                                       \
	(BIT_CLEAR_XTAL_DRV_USB_8812F(x) | BIT_XTAL_DRV_USB_8812F(v))

#define BIT_EN_XTAL_DRV_USB_8812F BIT(21)

#define BIT_SHIFT_XTAL_DRV_AFE_V2_8812F 19
#define BIT_MASK_XTAL_DRV_AFE_V2_8812F 0x3
#define BIT_XTAL_DRV_AFE_V2_8812F(x)                                           \
	(((x) & BIT_MASK_XTAL_DRV_AFE_V2_8812F)                                \
	 << BIT_SHIFT_XTAL_DRV_AFE_V2_8812F)
#define BITS_XTAL_DRV_AFE_V2_8812F                                             \
	(BIT_MASK_XTAL_DRV_AFE_V2_8812F << BIT_SHIFT_XTAL_DRV_AFE_V2_8812F)
#define BIT_CLEAR_XTAL_DRV_AFE_V2_8812F(x) ((x) & (~BITS_XTAL_DRV_AFE_V2_8812F))
#define BIT_GET_XTAL_DRV_AFE_V2_8812F(x)                                       \
	(((x) >> BIT_SHIFT_XTAL_DRV_AFE_V2_8812F) &                            \
	 BIT_MASK_XTAL_DRV_AFE_V2_8812F)
#define BIT_SET_XTAL_DRV_AFE_V2_8812F(x, v)                                    \
	(BIT_CLEAR_XTAL_DRV_AFE_V2_8812F(x) | BIT_XTAL_DRV_AFE_V2_8812F(v))

#define BIT_EN_XTAL_DRV_AFE_8812F BIT(18)

#define BIT_SHIFT_XTAL_DRV_RF2_V2_8812F 16
#define BIT_MASK_XTAL_DRV_RF2_V2_8812F 0x3
#define BIT_XTAL_DRV_RF2_V2_8812F(x)                                           \
	(((x) & BIT_MASK_XTAL_DRV_RF2_V2_8812F)                                \
	 << BIT_SHIFT_XTAL_DRV_RF2_V2_8812F)
#define BITS_XTAL_DRV_RF2_V2_8812F                                             \
	(BIT_MASK_XTAL_DRV_RF2_V2_8812F << BIT_SHIFT_XTAL_DRV_RF2_V2_8812F)
#define BIT_CLEAR_XTAL_DRV_RF2_V2_8812F(x) ((x) & (~BITS_XTAL_DRV_RF2_V2_8812F))
#define BIT_GET_XTAL_DRV_RF2_V2_8812F(x)                                       \
	(((x) >> BIT_SHIFT_XTAL_DRV_RF2_V2_8812F) &                            \
	 BIT_MASK_XTAL_DRV_RF2_V2_8812F)
#define BIT_SET_XTAL_DRV_RF2_V2_8812F(x, v)                                    \
	(BIT_CLEAR_XTAL_DRV_RF2_V2_8812F(x) | BIT_XTAL_DRV_RF2_V2_8812F(v))

#define BIT_EN_XTAL_DRV_RF2_8812F BIT(15)

#define BIT_SHIFT_XTAL_DRV_RF1_8812F 13
#define BIT_MASK_XTAL_DRV_RF1_8812F 0x3
#define BIT_XTAL_DRV_RF1_8812F(x)                                              \
	(((x) & BIT_MASK_XTAL_DRV_RF1_8812F) << BIT_SHIFT_XTAL_DRV_RF1_8812F)
#define BITS_XTAL_DRV_RF1_8812F                                                \
	(BIT_MASK_XTAL_DRV_RF1_8812F << BIT_SHIFT_XTAL_DRV_RF1_8812F)
#define BIT_CLEAR_XTAL_DRV_RF1_8812F(x) ((x) & (~BITS_XTAL_DRV_RF1_8812F))
#define BIT_GET_XTAL_DRV_RF1_8812F(x)                                          \
	(((x) >> BIT_SHIFT_XTAL_DRV_RF1_8812F) & BIT_MASK_XTAL_DRV_RF1_8812F)
#define BIT_SET_XTAL_DRV_RF1_8812F(x, v)                                       \
	(BIT_CLEAR_XTAL_DRV_RF1_8812F(x) | BIT_XTAL_DRV_RF1_8812F(v))

#define BIT_EN_XTAL_DRV_RF1_8812F BIT(12)
#define BIT_XTAL_DRV_RF_LATCH_V4_8812F BIT(11)
#define BIT_XTAL_GM_SEP_V3_8812F BIT(10)
#define BIT_XQSEL_RF_AWAKE_V3_8812F BIT(9)
#define BIT_XQSEL_RF_INITIAL_V3_8812F BIT(8)
#define BIT_XQSEL_V2_8812F BIT(7)
#define BIT_GATED_XTAL_OK0_V2_8812F BIT(6)

#define BIT_SHIFT_XTAL_SC_LPS_V2_8812F 0
#define BIT_MASK_XTAL_SC_LPS_V2_8812F 0x3f
#define BIT_XTAL_SC_LPS_V2_8812F(x)                                            \
	(((x) & BIT_MASK_XTAL_SC_LPS_V2_8812F)                                 \
	 << BIT_SHIFT_XTAL_SC_LPS_V2_8812F)
#define BITS_XTAL_SC_LPS_V2_8812F                                              \
	(BIT_MASK_XTAL_SC_LPS_V2_8812F << BIT_SHIFT_XTAL_SC_LPS_V2_8812F)
#define BIT_CLEAR_XTAL_SC_LPS_V2_8812F(x) ((x) & (~BITS_XTAL_SC_LPS_V2_8812F))
#define BIT_GET_XTAL_SC_LPS_V2_8812F(x)                                        \
	(((x) >> BIT_SHIFT_XTAL_SC_LPS_V2_8812F) &                             \
	 BIT_MASK_XTAL_SC_LPS_V2_8812F)
#define BIT_SET_XTAL_SC_LPS_V2_8812F(x, v)                                     \
	(BIT_CLEAR_XTAL_SC_LPS_V2_8812F(x) | BIT_XTAL_SC_LPS_V2_8812F(v))

/* 2 REG_ANAPAR_XTAL_2_8812F */
#define BIT_XTAL_AAC_CAP_8812F BIT(31)

#define BIT_SHIFT_XTAL_PDSW_8812F 29
#define BIT_MASK_XTAL_PDSW_8812F 0x3
#define BIT_XTAL_PDSW_8812F(x)                                                 \
	(((x) & BIT_MASK_XTAL_PDSW_8812F) << BIT_SHIFT_XTAL_PDSW_8812F)
#define BITS_XTAL_PDSW_8812F                                                   \
	(BIT_MASK_XTAL_PDSW_8812F << BIT_SHIFT_XTAL_PDSW_8812F)
#define BIT_CLEAR_XTAL_PDSW_8812F(x) ((x) & (~BITS_XTAL_PDSW_8812F))
#define BIT_GET_XTAL_PDSW_8812F(x)                                             \
	(((x) >> BIT_SHIFT_XTAL_PDSW_8812F) & BIT_MASK_XTAL_PDSW_8812F)
#define BIT_SET_XTAL_PDSW_8812F(x, v)                                          \
	(BIT_CLEAR_XTAL_PDSW_8812F(x) | BIT_XTAL_PDSW_8812F(v))

#define BIT_SHIFT_XTAL_LPS_BUF_VB_8812F 27
#define BIT_MASK_XTAL_LPS_BUF_VB_8812F 0x3
#define BIT_XTAL_LPS_BUF_VB_8812F(x)                                           \
	(((x) & BIT_MASK_XTAL_LPS_BUF_VB_8812F)                                \
	 << BIT_SHIFT_XTAL_LPS_BUF_VB_8812F)
#define BITS_XTAL_LPS_BUF_VB_8812F                                             \
	(BIT_MASK_XTAL_LPS_BUF_VB_8812F << BIT_SHIFT_XTAL_LPS_BUF_VB_8812F)
#define BIT_CLEAR_XTAL_LPS_BUF_VB_8812F(x) ((x) & (~BITS_XTAL_LPS_BUF_VB_8812F))
#define BIT_GET_XTAL_LPS_BUF_VB_8812F(x)                                       \
	(((x) >> BIT_SHIFT_XTAL_LPS_BUF_VB_8812F) &                            \
	 BIT_MASK_XTAL_LPS_BUF_VB_8812F)
#define BIT_SET_XTAL_LPS_BUF_VB_8812F(x, v)                                    \
	(BIT_CLEAR_XTAL_LPS_BUF_VB_8812F(x) | BIT_XTAL_LPS_BUF_VB_8812F(v))

#define BIT_XTAL_PDCK_MANU_8812F BIT(26)
#define BIT_XTAL_PDCK_OK_MANU_8812F BIT(25)

#define BIT_SHIFT_XTAL_VREF_SEL_8812F 20
#define BIT_MASK_XTAL_VREF_SEL_8812F 0x1f
#define BIT_XTAL_VREF_SEL_8812F(x)                                             \
	(((x) & BIT_MASK_XTAL_VREF_SEL_8812F) << BIT_SHIFT_XTAL_VREF_SEL_8812F)
#define BITS_XTAL_VREF_SEL_8812F                                               \
	(BIT_MASK_XTAL_VREF_SEL_8812F << BIT_SHIFT_XTAL_VREF_SEL_8812F)
#define BIT_CLEAR_XTAL_VREF_SEL_8812F(x) ((x) & (~BITS_XTAL_VREF_SEL_8812F))
#define BIT_GET_XTAL_VREF_SEL_8812F(x)                                         \
	(((x) >> BIT_SHIFT_XTAL_VREF_SEL_8812F) & BIT_MASK_XTAL_VREF_SEL_8812F)
#define BIT_SET_XTAL_VREF_SEL_8812F(x, v)                                      \
	(BIT_CLEAR_XTAL_VREF_SEL_8812F(x) | BIT_XTAL_VREF_SEL_8812F(v))

#define BIT_EN_XTAL_PDCK_VREF_8812F BIT(19)
#define BIT_XTAL_SEL_PWR_V1_8812F BIT(18)
#define BIT_XTAL_LPS_DIVISOR_8812F BIT(17)
#define BIT_XTAL_CKDIGI_SEL_8812F BIT(16)
#define BIT_EN_XTAL_LPS_CLK_8812F BIT(15)
#define BIT_EN_XTAL_SCHMITT_8812F BIT(14)
#define BIT_XTAL_PK_SEL_OFFSET_8812F BIT(13)

#define BIT_SHIFT_XTAL_MANU_PK_SEL_8812F 11
#define BIT_MASK_XTAL_MANU_PK_SEL_8812F 0x3
#define BIT_XTAL_MANU_PK_SEL_8812F(x)                                          \
	(((x) & BIT_MASK_XTAL_MANU_PK_SEL_8812F)                               \
	 << BIT_SHIFT_XTAL_MANU_PK_SEL_8812F)
#define BITS_XTAL_MANU_PK_SEL_8812F                                            \
	(BIT_MASK_XTAL_MANU_PK_SEL_8812F << BIT_SHIFT_XTAL_MANU_PK_SEL_8812F)
#define BIT_CLEAR_XTAL_MANU_PK_SEL_8812F(x)                                    \
	((x) & (~BITS_XTAL_MANU_PK_SEL_8812F))
#define BIT_GET_XTAL_MANU_PK_SEL_8812F(x)                                      \
	(((x) >> BIT_SHIFT_XTAL_MANU_PK_SEL_8812F) &                           \
	 BIT_MASK_XTAL_MANU_PK_SEL_8812F)
#define BIT_SET_XTAL_MANU_PK_SEL_8812F(x, v)                                   \
	(BIT_CLEAR_XTAL_MANU_PK_SEL_8812F(x) | BIT_XTAL_MANU_PK_SEL_8812F(v))

#define BIT_XTAL_AACK_PK_MANU_8812F BIT(10)
#define BIT_EN_XTAL_AAC_PKDET_V1_8812F BIT(9)
#define BIT_EN_XTAL_AAC_GM_V1_8812F BIT(8)
#define BIT_XTAL_LDO_OPVB_SEL_8812F BIT(7)
#define BIT_XTAL_LDO_NC_8812F BIT(6)

#define BIT_SHIFT_XTAL_LDO_VREF_V2_8812F 3
#define BIT_MASK_XTAL_LDO_VREF_V2_8812F 0x7
#define BIT_XTAL_LDO_VREF_V2_8812F(x)                                          \
	(((x) & BIT_MASK_XTAL_LDO_VREF_V2_8812F)                               \
	 << BIT_SHIFT_XTAL_LDO_VREF_V2_8812F)
#define BITS_XTAL_LDO_VREF_V2_8812F                                            \
	(BIT_MASK_XTAL_LDO_VREF_V2_8812F << BIT_SHIFT_XTAL_LDO_VREF_V2_8812F)
#define BIT_CLEAR_XTAL_LDO_VREF_V2_8812F(x)                                    \
	((x) & (~BITS_XTAL_LDO_VREF_V2_8812F))
#define BIT_GET_XTAL_LDO_VREF_V2_8812F(x)                                      \
	(((x) >> BIT_SHIFT_XTAL_LDO_VREF_V2_8812F) &                           \
	 BIT_MASK_XTAL_LDO_VREF_V2_8812F)
#define BIT_SET_XTAL_LDO_VREF_V2_8812F(x, v)                                   \
	(BIT_CLEAR_XTAL_LDO_VREF_V2_8812F(x) | BIT_XTAL_LDO_VREF_V2_8812F(v))

#define BIT_XTAL_LPMODE_V1_8812F BIT(2)

#define BIT_SHIFT_XTAL_SEL_TOK_V3_8812F 0
#define BIT_MASK_XTAL_SEL_TOK_V3_8812F 0x3
#define BIT_XTAL_SEL_TOK_V3_8812F(x)                                           \
	(((x) & BIT_MASK_XTAL_SEL_TOK_V3_8812F)                                \
	 << BIT_SHIFT_XTAL_SEL_TOK_V3_8812F)
#define BITS_XTAL_SEL_TOK_V3_8812F                                             \
	(BIT_MASK_XTAL_SEL_TOK_V3_8812F << BIT_SHIFT_XTAL_SEL_TOK_V3_8812F)
#define BIT_CLEAR_XTAL_SEL_TOK_V3_8812F(x) ((x) & (~BITS_XTAL_SEL_TOK_V3_8812F))
#define BIT_GET_XTAL_SEL_TOK_V3_8812F(x)                                       \
	(((x) >> BIT_SHIFT_XTAL_SEL_TOK_V3_8812F) &                            \
	 BIT_MASK_XTAL_SEL_TOK_V3_8812F)
#define BIT_SET_XTAL_SEL_TOK_V3_8812F(x, v)                                    \
	(BIT_CLEAR_XTAL_SEL_TOK_V3_8812F(x) | BIT_XTAL_SEL_TOK_V3_8812F(v))

/* 2 REG_ANAPAR_XTAL_3_8812F */

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_XTAL_DUMMY_V1_8812F 7
#define BIT_MASK_XTAL_DUMMY_V1_8812F 0x3f
#define BIT_XTAL_DUMMY_V1_8812F(x)                                             \
	(((x) & BIT_MASK_XTAL_DUMMY_V1_8812F) << BIT_SHIFT_XTAL_DUMMY_V1_8812F)
#define BITS_XTAL_DUMMY_V1_8812F                                               \
	(BIT_MASK_XTAL_DUMMY_V1_8812F << BIT_SHIFT_XTAL_DUMMY_V1_8812F)
#define BIT_CLEAR_XTAL_DUMMY_V1_8812F(x) ((x) & (~BITS_XTAL_DUMMY_V1_8812F))
#define BIT_GET_XTAL_DUMMY_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_XTAL_DUMMY_V1_8812F) & BIT_MASK_XTAL_DUMMY_V1_8812F)
#define BIT_SET_XTAL_DUMMY_V1_8812F(x, v)                                      \
	(BIT_CLEAR_XTAL_DUMMY_V1_8812F(x) | BIT_XTAL_DUMMY_V1_8812F(v))

#define BIT_XTAL_EN_LNBUF_8812F BIT(6)
#define BIT_XTAL__AAC_TIE_MID_8812F BIT(5)

#define BIT_SHIFT_XTAL_AAC_OPCUR_8812F 3
#define BIT_MASK_XTAL_AAC_OPCUR_8812F 0x3
#define BIT_XTAL_AAC_OPCUR_8812F(x)                                            \
	(((x) & BIT_MASK_XTAL_AAC_OPCUR_8812F)                                 \
	 << BIT_SHIFT_XTAL_AAC_OPCUR_8812F)
#define BITS_XTAL_AAC_OPCUR_8812F                                              \
	(BIT_MASK_XTAL_AAC_OPCUR_8812F << BIT_SHIFT_XTAL_AAC_OPCUR_8812F)
#define BIT_CLEAR_XTAL_AAC_OPCUR_8812F(x) ((x) & (~BITS_XTAL_AAC_OPCUR_8812F))
#define BIT_GET_XTAL_AAC_OPCUR_8812F(x)                                        \
	(((x) >> BIT_SHIFT_XTAL_AAC_OPCUR_8812F) &                             \
	 BIT_MASK_XTAL_AAC_OPCUR_8812F)
#define BIT_SET_XTAL_AAC_OPCUR_8812F(x, v)                                     \
	(BIT_CLEAR_XTAL_AAC_OPCUR_8812F(x) | BIT_XTAL_AAC_OPCUR_8812F(v))

#define BIT_SHIFT_XTAL_AAC_IOFFSET_8812F 1
#define BIT_MASK_XTAL_AAC_IOFFSET_8812F 0x3
#define BIT_XTAL_AAC_IOFFSET_8812F(x)                                          \
	(((x) & BIT_MASK_XTAL_AAC_IOFFSET_8812F)                               \
	 << BIT_SHIFT_XTAL_AAC_IOFFSET_8812F)
#define BITS_XTAL_AAC_IOFFSET_8812F                                            \
	(BIT_MASK_XTAL_AAC_IOFFSET_8812F << BIT_SHIFT_XTAL_AAC_IOFFSET_8812F)
#define BIT_CLEAR_XTAL_AAC_IOFFSET_8812F(x)                                    \
	((x) & (~BITS_XTAL_AAC_IOFFSET_8812F))
#define BIT_GET_XTAL_AAC_IOFFSET_8812F(x)                                      \
	(((x) >> BIT_SHIFT_XTAL_AAC_IOFFSET_8812F) &                           \
	 BIT_MASK_XTAL_AAC_IOFFSET_8812F)
#define BIT_SET_XTAL_AAC_IOFFSET_8812F(x, v)                                   \
	(BIT_CLEAR_XTAL_AAC_IOFFSET_8812F(x) | BIT_XTAL_AAC_IOFFSET_8812F(v))

#define BIT_XTAL_AAC_CAP_V1_8812F BIT(0)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_ANAPAR_XTAL_AACK_0_8812F */
#define BIT_XAAC_LPOW_8812F BIT(31)

#define BIT_SHIFT_AAC_MODE_8812F 29
#define BIT_MASK_AAC_MODE_8812F 0x3
#define BIT_AAC_MODE_8812F(x)                                                  \
	(((x) & BIT_MASK_AAC_MODE_8812F) << BIT_SHIFT_AAC_MODE_8812F)
#define BITS_AAC_MODE_8812F                                                    \
	(BIT_MASK_AAC_MODE_8812F << BIT_SHIFT_AAC_MODE_8812F)
#define BIT_CLEAR_AAC_MODE_8812F(x) ((x) & (~BITS_AAC_MODE_8812F))
#define BIT_GET_AAC_MODE_8812F(x)                                              \
	(((x) >> BIT_SHIFT_AAC_MODE_8812F) & BIT_MASK_AAC_MODE_8812F)
#define BIT_SET_AAC_MODE_8812F(x, v)                                           \
	(BIT_CLEAR_AAC_MODE_8812F(x) | BIT_AAC_MODE_8812F(v))

#define BIT_EN_XTAL_AAC_TRIG_8812F BIT(28)
#define BIT_EN_XTAL_AAC_8812F BIT(27)
#define BIT_EN_XTAL_AAC_DIGI_8812F BIT(26)

#define BIT_SHIFT_GM_MANUAL_8812F 21
#define BIT_MASK_GM_MANUAL_8812F 0x1f
#define BIT_GM_MANUAL_8812F(x)                                                 \
	(((x) & BIT_MASK_GM_MANUAL_8812F) << BIT_SHIFT_GM_MANUAL_8812F)
#define BITS_GM_MANUAL_8812F                                                   \
	(BIT_MASK_GM_MANUAL_8812F << BIT_SHIFT_GM_MANUAL_8812F)
#define BIT_CLEAR_GM_MANUAL_8812F(x) ((x) & (~BITS_GM_MANUAL_8812F))
#define BIT_GET_GM_MANUAL_8812F(x)                                             \
	(((x) >> BIT_SHIFT_GM_MANUAL_8812F) & BIT_MASK_GM_MANUAL_8812F)
#define BIT_SET_GM_MANUAL_8812F(x, v)                                          \
	(BIT_CLEAR_GM_MANUAL_8812F(x) | BIT_GM_MANUAL_8812F(v))

#define BIT_SHIFT_GM_STUP_8812F 16
#define BIT_MASK_GM_STUP_8812F 0x1f
#define BIT_GM_STUP_8812F(x)                                                   \
	(((x) & BIT_MASK_GM_STUP_8812F) << BIT_SHIFT_GM_STUP_8812F)
#define BITS_GM_STUP_8812F (BIT_MASK_GM_STUP_8812F << BIT_SHIFT_GM_STUP_8812F)
#define BIT_CLEAR_GM_STUP_8812F(x) ((x) & (~BITS_GM_STUP_8812F))
#define BIT_GET_GM_STUP_8812F(x)                                               \
	(((x) >> BIT_SHIFT_GM_STUP_8812F) & BIT_MASK_GM_STUP_8812F)
#define BIT_SET_GM_STUP_8812F(x, v)                                            \
	(BIT_CLEAR_GM_STUP_8812F(x) | BIT_GM_STUP_8812F(v))

#define BIT_SHIFT_XTAL_CK_SET_8812F 13
#define BIT_MASK_XTAL_CK_SET_8812F 0x7
#define BIT_XTAL_CK_SET_8812F(x)                                               \
	(((x) & BIT_MASK_XTAL_CK_SET_8812F) << BIT_SHIFT_XTAL_CK_SET_8812F)
#define BITS_XTAL_CK_SET_8812F                                                 \
	(BIT_MASK_XTAL_CK_SET_8812F << BIT_SHIFT_XTAL_CK_SET_8812F)
#define BIT_CLEAR_XTAL_CK_SET_8812F(x) ((x) & (~BITS_XTAL_CK_SET_8812F))
#define BIT_GET_XTAL_CK_SET_8812F(x)                                           \
	(((x) >> BIT_SHIFT_XTAL_CK_SET_8812F) & BIT_MASK_XTAL_CK_SET_8812F)
#define BIT_SET_XTAL_CK_SET_8812F(x, v)                                        \
	(BIT_CLEAR_XTAL_CK_SET_8812F(x) | BIT_XTAL_CK_SET_8812F(v))

#define BIT_SHIFT_GM_INIT_8812F 8
#define BIT_MASK_GM_INIT_8812F 0x1f
#define BIT_GM_INIT_8812F(x)                                                   \
	(((x) & BIT_MASK_GM_INIT_8812F) << BIT_SHIFT_GM_INIT_8812F)
#define BITS_GM_INIT_8812F (BIT_MASK_GM_INIT_8812F << BIT_SHIFT_GM_INIT_8812F)
#define BIT_CLEAR_GM_INIT_8812F(x) ((x) & (~BITS_GM_INIT_8812F))
#define BIT_GET_GM_INIT_8812F(x)                                               \
	(((x) >> BIT_SHIFT_GM_INIT_8812F) & BIT_MASK_GM_INIT_8812F)
#define BIT_SET_GM_INIT_8812F(x, v)                                            \
	(BIT_CLEAR_GM_INIT_8812F(x) | BIT_GM_INIT_8812F(v))

#define BIT_GM_STEP_8812F BIT(7)

#define BIT_SHIFT_XAAC_GM_OFFSET_8812F 2
#define BIT_MASK_XAAC_GM_OFFSET_8812F 0x1f
#define BIT_XAAC_GM_OFFSET_8812F(x)                                            \
	(((x) & BIT_MASK_XAAC_GM_OFFSET_8812F)                                 \
	 << BIT_SHIFT_XAAC_GM_OFFSET_8812F)
#define BITS_XAAC_GM_OFFSET_8812F                                              \
	(BIT_MASK_XAAC_GM_OFFSET_8812F << BIT_SHIFT_XAAC_GM_OFFSET_8812F)
#define BIT_CLEAR_XAAC_GM_OFFSET_8812F(x) ((x) & (~BITS_XAAC_GM_OFFSET_8812F))
#define BIT_GET_XAAC_GM_OFFSET_8812F(x)                                        \
	(((x) >> BIT_SHIFT_XAAC_GM_OFFSET_8812F) &                             \
	 BIT_MASK_XAAC_GM_OFFSET_8812F)
#define BIT_SET_XAAC_GM_OFFSET_8812F(x, v)                                     \
	(BIT_CLEAR_XAAC_GM_OFFSET_8812F(x) | BIT_XAAC_GM_OFFSET_8812F(v))

#define BIT_OFFSET_PLUS_8812F BIT(1)
#define BIT_RESET_N_8812F BIT(0)

/* 2 REG_ANAPAR_XTAL_AACK_1_8812F */

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_PK_END_AR_8812F 3
#define BIT_MASK_PK_END_AR_8812F 0x3
#define BIT_PK_END_AR_8812F(x)                                                 \
	(((x) & BIT_MASK_PK_END_AR_8812F) << BIT_SHIFT_PK_END_AR_8812F)
#define BITS_PK_END_AR_8812F                                                   \
	(BIT_MASK_PK_END_AR_8812F << BIT_SHIFT_PK_END_AR_8812F)
#define BIT_CLEAR_PK_END_AR_8812F(x) ((x) & (~BITS_PK_END_AR_8812F))
#define BIT_GET_PK_END_AR_8812F(x)                                             \
	(((x) >> BIT_SHIFT_PK_END_AR_8812F) & BIT_MASK_PK_END_AR_8812F)
#define BIT_SET_PK_END_AR_8812F(x, v)                                          \
	(BIT_CLEAR_PK_END_AR_8812F(x) | BIT_PK_END_AR_8812F(v))

#define BIT_SHIFT_PK_START_AR_8812F 1
#define BIT_MASK_PK_START_AR_8812F 0x3
#define BIT_PK_START_AR_8812F(x)                                               \
	(((x) & BIT_MASK_PK_START_AR_8812F) << BIT_SHIFT_PK_START_AR_8812F)
#define BITS_PK_START_AR_8812F                                                 \
	(BIT_MASK_PK_START_AR_8812F << BIT_SHIFT_PK_START_AR_8812F)
#define BIT_CLEAR_PK_START_AR_8812F(x) ((x) & (~BITS_PK_START_AR_8812F))
#define BIT_GET_PK_START_AR_8812F(x)                                           \
	(((x) >> BIT_SHIFT_PK_START_AR_8812F) & BIT_MASK_PK_START_AR_8812F)
#define BIT_SET_PK_START_AR_8812F(x, v)                                        \
	(BIT_CLEAR_PK_START_AR_8812F(x) | BIT_PK_START_AR_8812F(v))

#define BIT_XAAC_LUT_MANUAL_EN_8812F BIT(0)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_ANAPAR_XTAL_MODE_DECODER_8812F */

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_XTAL_LDO_LPS_8812F 21
#define BIT_MASK_XTAL_LDO_LPS_8812F 0x7
#define BIT_XTAL_LDO_LPS_8812F(x)                                              \
	(((x) & BIT_MASK_XTAL_LDO_LPS_8812F) << BIT_SHIFT_XTAL_LDO_LPS_8812F)
#define BITS_XTAL_LDO_LPS_8812F                                                \
	(BIT_MASK_XTAL_LDO_LPS_8812F << BIT_SHIFT_XTAL_LDO_LPS_8812F)
#define BIT_CLEAR_XTAL_LDO_LPS_8812F(x) ((x) & (~BITS_XTAL_LDO_LPS_8812F))
#define BIT_GET_XTAL_LDO_LPS_8812F(x)                                          \
	(((x) >> BIT_SHIFT_XTAL_LDO_LPS_8812F) & BIT_MASK_XTAL_LDO_LPS_8812F)
#define BIT_SET_XTAL_LDO_LPS_8812F(x, v)                                       \
	(BIT_CLEAR_XTAL_LDO_LPS_8812F(x) | BIT_XTAL_LDO_LPS_8812F(v))

#define BIT_SHIFT_XTAL_WAIT_CYC_8812F 15
#define BIT_MASK_XTAL_WAIT_CYC_8812F 0x3f
#define BIT_XTAL_WAIT_CYC_8812F(x)                                             \
	(((x) & BIT_MASK_XTAL_WAIT_CYC_8812F) << BIT_SHIFT_XTAL_WAIT_CYC_8812F)
#define BITS_XTAL_WAIT_CYC_8812F                                               \
	(BIT_MASK_XTAL_WAIT_CYC_8812F << BIT_SHIFT_XTAL_WAIT_CYC_8812F)
#define BIT_CLEAR_XTAL_WAIT_CYC_8812F(x) ((x) & (~BITS_XTAL_WAIT_CYC_8812F))
#define BIT_GET_XTAL_WAIT_CYC_8812F(x)                                         \
	(((x) >> BIT_SHIFT_XTAL_WAIT_CYC_8812F) & BIT_MASK_XTAL_WAIT_CYC_8812F)
#define BIT_SET_XTAL_WAIT_CYC_8812F(x, v)                                      \
	(BIT_CLEAR_XTAL_WAIT_CYC_8812F(x) | BIT_XTAL_WAIT_CYC_8812F(v))

#define BIT_SHIFT_XTAL_LDO_OK_8812F 12
#define BIT_MASK_XTAL_LDO_OK_8812F 0x7
#define BIT_XTAL_LDO_OK_8812F(x)                                               \
	(((x) & BIT_MASK_XTAL_LDO_OK_8812F) << BIT_SHIFT_XTAL_LDO_OK_8812F)
#define BITS_XTAL_LDO_OK_8812F                                                 \
	(BIT_MASK_XTAL_LDO_OK_8812F << BIT_SHIFT_XTAL_LDO_OK_8812F)
#define BIT_CLEAR_XTAL_LDO_OK_8812F(x) ((x) & (~BITS_XTAL_LDO_OK_8812F))
#define BIT_GET_XTAL_LDO_OK_8812F(x)                                           \
	(((x) >> BIT_SHIFT_XTAL_LDO_OK_8812F) & BIT_MASK_XTAL_LDO_OK_8812F)
#define BIT_SET_XTAL_LDO_OK_8812F(x, v)                                        \
	(BIT_CLEAR_XTAL_LDO_OK_8812F(x) | BIT_XTAL_LDO_OK_8812F(v))

#define BIT_XTAL_MD_LPOW_8812F BIT(11)

#define BIT_SHIFT_XTAL_OV_RATIO_8812F 9
#define BIT_MASK_XTAL_OV_RATIO_8812F 0x3
#define BIT_XTAL_OV_RATIO_8812F(x)                                             \
	(((x) & BIT_MASK_XTAL_OV_RATIO_8812F) << BIT_SHIFT_XTAL_OV_RATIO_8812F)
#define BITS_XTAL_OV_RATIO_8812F                                               \
	(BIT_MASK_XTAL_OV_RATIO_8812F << BIT_SHIFT_XTAL_OV_RATIO_8812F)
#define BIT_CLEAR_XTAL_OV_RATIO_8812F(x) ((x) & (~BITS_XTAL_OV_RATIO_8812F))
#define BIT_GET_XTAL_OV_RATIO_8812F(x)                                         \
	(((x) >> BIT_SHIFT_XTAL_OV_RATIO_8812F) & BIT_MASK_XTAL_OV_RATIO_8812F)
#define BIT_SET_XTAL_OV_RATIO_8812F(x, v)                                      \
	(BIT_CLEAR_XTAL_OV_RATIO_8812F(x) | BIT_XTAL_OV_RATIO_8812F(v))

#define BIT_SHIFT_XTAL_OV_UNIT_8812F 6
#define BIT_MASK_XTAL_OV_UNIT_8812F 0x7
#define BIT_XTAL_OV_UNIT_8812F(x)                                              \
	(((x) & BIT_MASK_XTAL_OV_UNIT_8812F) << BIT_SHIFT_XTAL_OV_UNIT_8812F)
#define BITS_XTAL_OV_UNIT_8812F                                                \
	(BIT_MASK_XTAL_OV_UNIT_8812F << BIT_SHIFT_XTAL_OV_UNIT_8812F)
#define BIT_CLEAR_XTAL_OV_UNIT_8812F(x) ((x) & (~BITS_XTAL_OV_UNIT_8812F))
#define BIT_GET_XTAL_OV_UNIT_8812F(x)                                          \
	(((x) >> BIT_SHIFT_XTAL_OV_UNIT_8812F) & BIT_MASK_XTAL_OV_UNIT_8812F)
#define BIT_SET_XTAL_OV_UNIT_8812F(x, v)                                       \
	(BIT_CLEAR_XTAL_OV_UNIT_8812F(x) | BIT_XTAL_OV_UNIT_8812F(v))

#define BIT_SHIFT_XTAL_MODE_MANUAL_8812F 4
#define BIT_MASK_XTAL_MODE_MANUAL_8812F 0x3
#define BIT_XTAL_MODE_MANUAL_8812F(x)                                          \
	(((x) & BIT_MASK_XTAL_MODE_MANUAL_8812F)                               \
	 << BIT_SHIFT_XTAL_MODE_MANUAL_8812F)
#define BITS_XTAL_MODE_MANUAL_8812F                                            \
	(BIT_MASK_XTAL_MODE_MANUAL_8812F << BIT_SHIFT_XTAL_MODE_MANUAL_8812F)
#define BIT_CLEAR_XTAL_MODE_MANUAL_8812F(x)                                    \
	((x) & (~BITS_XTAL_MODE_MANUAL_8812F))
#define BIT_GET_XTAL_MODE_MANUAL_8812F(x)                                      \
	(((x) >> BIT_SHIFT_XTAL_MODE_MANUAL_8812F) &                           \
	 BIT_MASK_XTAL_MODE_MANUAL_8812F)
#define BIT_SET_XTAL_MODE_MANUAL_8812F(x, v)                                   \
	(BIT_CLEAR_XTAL_MODE_MANUAL_8812F(x) | BIT_XTAL_MODE_MANUAL_8812F(v))

#define BIT_XTAL_MANU_SEL_8812F BIT(3)

/* 2 REG_NOT_VALID_8812F */
#define BIT_XTAL_MODE_8812F BIT(1)
#define BIT_RESET_N_DECODER_8812F BIT(0)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_SYS_CFG5_8812F */
#define BIT_LPS_STATUS_8812F BIT(3)
#define BIT_HCI_TXDMA_BUSY_8812F BIT(2)
#define BIT_HCI_TXDMA_ALLOW_8812F BIT(1)
#define BIT_FW_CTRL_HCI_TXDMA_EN_8812F BIT(0)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_REGU_32K_1_8812F */
#define BIT_OUT_SEL_8812F BIT(26)

#define BIT_SHIFT_FREQ_SEL_8812F 24
#define BIT_MASK_FREQ_SEL_8812F 0x3
#define BIT_FREQ_SEL_8812F(x)                                                  \
	(((x) & BIT_MASK_FREQ_SEL_8812F) << BIT_SHIFT_FREQ_SEL_8812F)
#define BITS_FREQ_SEL_8812F                                                    \
	(BIT_MASK_FREQ_SEL_8812F << BIT_SHIFT_FREQ_SEL_8812F)
#define BIT_CLEAR_FREQ_SEL_8812F(x) ((x) & (~BITS_FREQ_SEL_8812F))
#define BIT_GET_FREQ_SEL_8812F(x)                                              \
	(((x) >> BIT_SHIFT_FREQ_SEL_8812F) & BIT_MASK_FREQ_SEL_8812F)
#define BIT_SET_FREQ_SEL_8812F(x, v)                                           \
	(BIT_CLEAR_FREQ_SEL_8812F(x) | BIT_FREQ_SEL_8812F(v))

#define BIT_SHIFT_CLKGEN0_8812F 16
#define BIT_MASK_CLKGEN0_8812F 0xff
#define BIT_CLKGEN0_8812F(x)                                                   \
	(((x) & BIT_MASK_CLKGEN0_8812F) << BIT_SHIFT_CLKGEN0_8812F)
#define BITS_CLKGEN0_8812F (BIT_MASK_CLKGEN0_8812F << BIT_SHIFT_CLKGEN0_8812F)
#define BIT_CLEAR_CLKGEN0_8812F(x) ((x) & (~BITS_CLKGEN0_8812F))
#define BIT_GET_CLKGEN0_8812F(x)                                               \
	(((x) >> BIT_SHIFT_CLKGEN0_8812F) & BIT_MASK_CLKGEN0_8812F)
#define BIT_SET_CLKGEN0_8812F(x, v)                                            \
	(BIT_CLEAR_CLKGEN0_8812F(x) | BIT_CLKGEN0_8812F(v))

#define BIT_SHIFT_TEMP_COMP_8812F 12
#define BIT_MASK_TEMP_COMP_8812F 0xf
#define BIT_TEMP_COMP_8812F(x)                                                 \
	(((x) & BIT_MASK_TEMP_COMP_8812F) << BIT_SHIFT_TEMP_COMP_8812F)
#define BITS_TEMP_COMP_8812F                                                   \
	(BIT_MASK_TEMP_COMP_8812F << BIT_SHIFT_TEMP_COMP_8812F)
#define BIT_CLEAR_TEMP_COMP_8812F(x) ((x) & (~BITS_TEMP_COMP_8812F))
#define BIT_GET_TEMP_COMP_8812F(x)                                             \
	(((x) >> BIT_SHIFT_TEMP_COMP_8812F) & BIT_MASK_TEMP_COMP_8812F)
#define BIT_SET_TEMP_COMP_8812F(x, v)                                          \
	(BIT_CLEAR_TEMP_COMP_8812F(x) | BIT_TEMP_COMP_8812F(v))

#define BIT_SHIFT_LDO_V18ADJ_8812F 8
#define BIT_MASK_LDO_V18ADJ_8812F 0xf
#define BIT_LDO_V18ADJ_8812F(x)                                                \
	(((x) & BIT_MASK_LDO_V18ADJ_8812F) << BIT_SHIFT_LDO_V18ADJ_8812F)
#define BITS_LDO_V18ADJ_8812F                                                  \
	(BIT_MASK_LDO_V18ADJ_8812F << BIT_SHIFT_LDO_V18ADJ_8812F)
#define BIT_CLEAR_LDO_V18ADJ_8812F(x) ((x) & (~BITS_LDO_V18ADJ_8812F))
#define BIT_GET_LDO_V18ADJ_8812F(x)                                            \
	(((x) >> BIT_SHIFT_LDO_V18ADJ_8812F) & BIT_MASK_LDO_V18ADJ_8812F)
#define BIT_SET_LDO_V18ADJ_8812F(x, v)                                         \
	(BIT_CLEAR_LDO_V18ADJ_8812F(x) | BIT_LDO_V18ADJ_8812F(v))

#define BIT_SHIFT_COMP_LOAD_CUR_8812F 5
#define BIT_MASK_COMP_LOAD_CUR_8812F 0x3
#define BIT_COMP_LOAD_CUR_8812F(x)                                             \
	(((x) & BIT_MASK_COMP_LOAD_CUR_8812F) << BIT_SHIFT_COMP_LOAD_CUR_8812F)
#define BITS_COMP_LOAD_CUR_8812F                                               \
	(BIT_MASK_COMP_LOAD_CUR_8812F << BIT_SHIFT_COMP_LOAD_CUR_8812F)
#define BIT_CLEAR_COMP_LOAD_CUR_8812F(x) ((x) & (~BITS_COMP_LOAD_CUR_8812F))
#define BIT_GET_COMP_LOAD_CUR_8812F(x)                                         \
	(((x) >> BIT_SHIFT_COMP_LOAD_CUR_8812F) & BIT_MASK_COMP_LOAD_CUR_8812F)
#define BIT_SET_COMP_LOAD_CUR_8812F(x, v)                                      \
	(BIT_CLEAR_COMP_LOAD_CUR_8812F(x) | BIT_COMP_LOAD_CUR_8812F(v))

#define BIT_SHIFT_COMP_LATCH_CUR_8812F 3
#define BIT_MASK_COMP_LATCH_CUR_8812F 0x3
#define BIT_COMP_LATCH_CUR_8812F(x)                                            \
	(((x) & BIT_MASK_COMP_LATCH_CUR_8812F)                                 \
	 << BIT_SHIFT_COMP_LATCH_CUR_8812F)
#define BITS_COMP_LATCH_CUR_8812F                                              \
	(BIT_MASK_COMP_LATCH_CUR_8812F << BIT_SHIFT_COMP_LATCH_CUR_8812F)
#define BIT_CLEAR_COMP_LATCH_CUR_8812F(x) ((x) & (~BITS_COMP_LATCH_CUR_8812F))
#define BIT_GET_COMP_LATCH_CUR_8812F(x)                                        \
	(((x) >> BIT_SHIFT_COMP_LATCH_CUR_8812F) &                             \
	 BIT_MASK_COMP_LATCH_CUR_8812F)
#define BIT_SET_COMP_LATCH_CUR_8812F(x, v)                                     \
	(BIT_CLEAR_COMP_LATCH_CUR_8812F(x) | BIT_COMP_LATCH_CUR_8812F(v))

#define BIT_SHIFT_COMP_GM_CUR_8812F 1
#define BIT_MASK_COMP_GM_CUR_8812F 0x3
#define BIT_COMP_GM_CUR_8812F(x)                                               \
	(((x) & BIT_MASK_COMP_GM_CUR_8812F) << BIT_SHIFT_COMP_GM_CUR_8812F)
#define BITS_COMP_GM_CUR_8812F                                                 \
	(BIT_MASK_COMP_GM_CUR_8812F << BIT_SHIFT_COMP_GM_CUR_8812F)
#define BIT_CLEAR_COMP_GM_CUR_8812F(x) ((x) & (~BITS_COMP_GM_CUR_8812F))
#define BIT_GET_COMP_GM_CUR_8812F(x)                                           \
	(((x) >> BIT_SHIFT_COMP_GM_CUR_8812F) & BIT_MASK_COMP_GM_CUR_8812F)
#define BIT_SET_COMP_GM_CUR_8812F(x, v)                                        \
	(BIT_CLEAR_COMP_GM_CUR_8812F(x) | BIT_COMP_GM_CUR_8812F(v))

/* 2 REG_REGU_32K_2_8812F */
#define BIT_SEL_RCAL_SOURCE_8812F BIT(16)

#define BIT_SHIFT_RCAL_8812F 0
#define BIT_MASK_RCAL_8812F 0x3f
#define BIT_RCAL_8812F(x) (((x) & BIT_MASK_RCAL_8812F) << BIT_SHIFT_RCAL_8812F)
#define BITS_RCAL_8812F (BIT_MASK_RCAL_8812F << BIT_SHIFT_RCAL_8812F)
#define BIT_CLEAR_RCAL_8812F(x) ((x) & (~BITS_RCAL_8812F))
#define BIT_GET_RCAL_8812F(x)                                                  \
	(((x) >> BIT_SHIFT_RCAL_8812F) & BIT_MASK_RCAL_8812F)
#define BIT_SET_RCAL_8812F(x, v) (BIT_CLEAR_RCAL_8812F(x) | BIT_RCAL_8812F(v))

/* 2 REG_CPU_DMEM_CON_8812F */
#define BIT_WDT_AUTO_MODE_8812F BIT(22)
#define BIT_WDT_PLATFORM_EN_8812F BIT(21)
#define BIT_WDT_CPU_EN_8812F BIT(20)
#define BIT_WDT_OPT_IOWRAPPER_8812F BIT(19)
#define BIT_ANA_PORT_IDLE_8812F BIT(18)
#define BIT_MAC_PORT_IDLE_8812F BIT(17)
#define BIT_WL_PLATFORM_RST_8812F BIT(16)
#define BIT_WL_SECURITY_CLK_8812F BIT(15)
#define BIT_DDMA_EN_8812F BIT(8)

#define BIT_SHIFT_CPU_DMEM_CON_8812F 0
#define BIT_MASK_CPU_DMEM_CON_8812F 0xff
#define BIT_CPU_DMEM_CON_8812F(x)                                              \
	(((x) & BIT_MASK_CPU_DMEM_CON_8812F) << BIT_SHIFT_CPU_DMEM_CON_8812F)
#define BITS_CPU_DMEM_CON_8812F                                                \
	(BIT_MASK_CPU_DMEM_CON_8812F << BIT_SHIFT_CPU_DMEM_CON_8812F)
#define BIT_CLEAR_CPU_DMEM_CON_8812F(x) ((x) & (~BITS_CPU_DMEM_CON_8812F))
#define BIT_GET_CPU_DMEM_CON_8812F(x)                                          \
	(((x) >> BIT_SHIFT_CPU_DMEM_CON_8812F) & BIT_MASK_CPU_DMEM_CON_8812F)
#define BIT_SET_CPU_DMEM_CON_8812F(x, v)                                       \
	(BIT_CLEAR_CPU_DMEM_CON_8812F(x) | BIT_CPU_DMEM_CON_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_BOOT_REASON_8812F */

#define BIT_SHIFT_BOOT_REASON_V1_8812F 0
#define BIT_MASK_BOOT_REASON_V1_8812F 0x7
#define BIT_BOOT_REASON_V1_8812F(x)                                            \
	(((x) & BIT_MASK_BOOT_REASON_V1_8812F)                                 \
	 << BIT_SHIFT_BOOT_REASON_V1_8812F)
#define BITS_BOOT_REASON_V1_8812F                                              \
	(BIT_MASK_BOOT_REASON_V1_8812F << BIT_SHIFT_BOOT_REASON_V1_8812F)
#define BIT_CLEAR_BOOT_REASON_V1_8812F(x) ((x) & (~BITS_BOOT_REASON_V1_8812F))
#define BIT_GET_BOOT_REASON_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_BOOT_REASON_V1_8812F) &                             \
	 BIT_MASK_BOOT_REASON_V1_8812F)
#define BIT_SET_BOOT_REASON_V1_8812F(x, v)                                     \
	(BIT_CLEAR_BOOT_REASON_V1_8812F(x) | BIT_BOOT_REASON_V1_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_HIMR2_8812F */
#define BIT_BCNDMAINT_P4_MSK_8812F BIT(31)
#define BIT_BCNDMAINT_P3_MSK_8812F BIT(30)
#define BIT_BCNDMAINT_P2_MSK_8812F BIT(29)
#define BIT_BCNDMAINT_P1_MSK_8812F BIT(28)
#define BIT_ATIMEND7_MSK_8812F BIT(22)
#define BIT_ATIMEND6_MSK_8812F BIT(21)
#define BIT_ATIMEND5_MSK_8812F BIT(20)
#define BIT_ATIMEND4_MSK_8812F BIT(19)
#define BIT_ATIMEND3_MSK_8812F BIT(18)
#define BIT_ATIMEND2_MSK_8812F BIT(17)
#define BIT_ATIMEND1_MSK_8812F BIT(16)
#define BIT_TXBCN7OK_MSK_8812F BIT(14)
#define BIT_TXBCN6OK_MSK_8812F BIT(13)
#define BIT_TXBCN5OK_MSK_8812F BIT(12)
#define BIT_TXBCN4OK_MSK_8812F BIT(11)
#define BIT_TXBCN3OK_MSK_8812F BIT(10)
#define BIT_TXBCN2OK_MSK_8812F BIT(9)
#define BIT_TXBCN1OK_MSK_V1_8812F BIT(8)
#define BIT_TXBCN7ERR_MSK_8812F BIT(6)
#define BIT_TXBCN6ERR_MSK_8812F BIT(5)
#define BIT_TXBCN5ERR_MSK_8812F BIT(4)
#define BIT_TXBCN4ERR_MSK_8812F BIT(3)
#define BIT_TXBCN3ERR_MSK_8812F BIT(2)
#define BIT_TXBCN2ERR_MSK_8812F BIT(1)
#define BIT_TXBCN1ERR_MSK_V1_8812F BIT(0)

/* 2 REG_HISR2_8812F */
#define BIT_BCNDMAINT_P4_8812F BIT(31)
#define BIT_BCNDMAINT_P3_8812F BIT(30)
#define BIT_BCNDMAINT_P2_8812F BIT(29)
#define BIT_BCNDMAINT_P1_8812F BIT(28)
#define BIT_ATIMEND7_8812F BIT(22)
#define BIT_ATIMEND6_8812F BIT(21)
#define BIT_ATIMEND5_8812F BIT(20)
#define BIT_ATIMEND4_8812F BIT(19)
#define BIT_ATIMEND3_8812F BIT(18)
#define BIT_ATIMEND2_8812F BIT(17)
#define BIT_ATIMEND1_8812F BIT(16)
#define BIT_TXBCN7OK_8812F BIT(14)
#define BIT_TXBCN6OK_8812F BIT(13)
#define BIT_TXBCN5OK_8812F BIT(12)
#define BIT_TXBCN4OK_8812F BIT(11)
#define BIT_TXBCN3OK_8812F BIT(10)
#define BIT_TXBCN2OK_8812F BIT(9)
#define BIT_TXBCN1OK_8812F BIT(8)
#define BIT_TXBCN7ERR_8812F BIT(6)
#define BIT_TXBCN6ERR_8812F BIT(5)
#define BIT_TXBCN5ERR_8812F BIT(4)
#define BIT_TXBCN4ERR_8812F BIT(3)
#define BIT_TXBCN3ERR_8812F BIT(2)
#define BIT_TXBCN2ERR_8812F BIT(1)
#define BIT_TXBCN1ERR_8812F BIT(0)

/* 2 REG_HIMR3_8812F */
#define BIT_WDT_PLATFORM_INT_MSK_8812F BIT(18)
#define BIT_WDT_CPU_INT_MSK_8812F BIT(17)
#define BIT_SETH2CDOK_MASK_8812F BIT(16)
#define BIT_H2C_CMD_FULL_MASK_8812F BIT(15)
#define BIT_PWR_INT_127_MASK_8812F BIT(14)
#define BIT_TXSHORTCUT_TXDESUPDATEOK_MASK_8812F BIT(13)
#define BIT_TXSHORTCUT_BKUPDATEOK_MASK_8812F BIT(12)
#define BIT_TXSHORTCUT_BEUPDATEOK_MASK_8812F BIT(11)
#define BIT_TXSHORTCUT_VIUPDATEOK_MAS_8812F BIT(10)
#define BIT_TXSHORTCUT_VOUPDATEOK_MASK_8812F BIT(9)
#define BIT_PWR_INT_127_MASK_V1_8812F BIT(8)
#define BIT_PWR_INT_126TO96_MASK_8812F BIT(7)
#define BIT_PWR_INT_95TO64_MASK_8812F BIT(6)
#define BIT_PWR_INT_63TO32_MASK_8812F BIT(5)
#define BIT_PWR_INT_31TO0_MASK_8812F BIT(4)
#define BIT_RX_DMA_STUCK_MSK_8812F BIT(3)
#define BIT_TX_DMA_STUCK_MSK_8812F BIT(2)
#define BIT_DDMA0_LP_INT_MSK_8812F BIT(1)
#define BIT_DDMA0_HP_INT_MSK_8812F BIT(0)

/* 2 REG_HISR3_8812F */
#define BIT_WDT_PLATFORM_INT_8812F BIT(18)
#define BIT_WDT_CPU_INT_8812F BIT(17)
#define BIT_SETH2CDOK_8812F BIT(16)
#define BIT_H2C_CMD_FULL_8812F BIT(15)
#define BIT_PWR_INT_127_8812F BIT(14)
#define BIT_TXSHORTCUT_TXDESUPDATEOK_8812F BIT(13)
#define BIT_TXSHORTCUT_BKUPDATEOK_8812F BIT(12)
#define BIT_TXSHORTCUT_BEUPDATEOK_8812F BIT(11)
#define BIT_TXSHORTCUT_VIUPDATEOK_8812F BIT(10)
#define BIT_TXSHORTCUT_VOUPDATEOK_8812F BIT(9)
#define BIT_PWR_INT_127_V1_8812F BIT(8)
#define BIT_PWR_INT_126TO96_8812F BIT(7)
#define BIT_PWR_INT_95TO64_8812F BIT(6)
#define BIT_PWR_INT_63TO32_8812F BIT(5)
#define BIT_PWR_INT_31TO0_8812F BIT(4)
#define BIT_RX_DMA_STUCK_8812F BIT(3)
#define BIT_TX_DMA_STUCK_8812F BIT(2)
#define BIT_DDMA0_LP_INT_8812F BIT(1)
#define BIT_DDMA0_HP_INT_8812F BIT(0)

/* 2 REG_SW_MDIO_8812F */
#define BIT_DIS_TIMEOUT_IO_8812F BIT(24)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_H2C_PKT_READADDR_8812F */

#define BIT_SHIFT_H2C_PKT_READADDR_8812F 0
#define BIT_MASK_H2C_PKT_READADDR_8812F 0x3ffff
#define BIT_H2C_PKT_READADDR_8812F(x)                                          \
	(((x) & BIT_MASK_H2C_PKT_READADDR_8812F)                               \
	 << BIT_SHIFT_H2C_PKT_READADDR_8812F)
#define BITS_H2C_PKT_READADDR_8812F                                            \
	(BIT_MASK_H2C_PKT_READADDR_8812F << BIT_SHIFT_H2C_PKT_READADDR_8812F)
#define BIT_CLEAR_H2C_PKT_READADDR_8812F(x)                                    \
	((x) & (~BITS_H2C_PKT_READADDR_8812F))
#define BIT_GET_H2C_PKT_READADDR_8812F(x)                                      \
	(((x) >> BIT_SHIFT_H2C_PKT_READADDR_8812F) &                           \
	 BIT_MASK_H2C_PKT_READADDR_8812F)
#define BIT_SET_H2C_PKT_READADDR_8812F(x, v)                                   \
	(BIT_CLEAR_H2C_PKT_READADDR_8812F(x) | BIT_H2C_PKT_READADDR_8812F(v))

/* 2 REG_H2C_PKT_WRITEADDR_8812F */

#define BIT_SHIFT_H2C_PKT_WRITEADDR_8812F 0
#define BIT_MASK_H2C_PKT_WRITEADDR_8812F 0x3ffff
#define BIT_H2C_PKT_WRITEADDR_8812F(x)                                         \
	(((x) & BIT_MASK_H2C_PKT_WRITEADDR_8812F)                              \
	 << BIT_SHIFT_H2C_PKT_WRITEADDR_8812F)
#define BITS_H2C_PKT_WRITEADDR_8812F                                           \
	(BIT_MASK_H2C_PKT_WRITEADDR_8812F << BIT_SHIFT_H2C_PKT_WRITEADDR_8812F)
#define BIT_CLEAR_H2C_PKT_WRITEADDR_8812F(x)                                   \
	((x) & (~BITS_H2C_PKT_WRITEADDR_8812F))
#define BIT_GET_H2C_PKT_WRITEADDR_8812F(x)                                     \
	(((x) >> BIT_SHIFT_H2C_PKT_WRITEADDR_8812F) &                          \
	 BIT_MASK_H2C_PKT_WRITEADDR_8812F)
#define BIT_SET_H2C_PKT_WRITEADDR_8812F(x, v)                                  \
	(BIT_CLEAR_H2C_PKT_WRITEADDR_8812F(x) | BIT_H2C_PKT_WRITEADDR_8812F(v))

/* 2 REG_MEM_PWR_CRTL_8812F */
#define BIT_MEM_BB_SD_8812F BIT(17)
#define BIT_MEM_BB_DS_8812F BIT(16)
#define BIT_MEM_BT_DS_8812F BIT(10)
#define BIT_MEM_SDIO_LS_8812F BIT(9)
#define BIT_MEM_SDIO_DS_8812F BIT(8)
#define BIT_MEM_USB_LS_8812F BIT(7)
#define BIT_MEM_USB_DS_8812F BIT(6)
#define BIT_MEM_PCI_LS_8812F BIT(5)
#define BIT_MEM_PCI_DS_8812F BIT(4)
#define BIT_MEM_WLMAC_LS_8812F BIT(3)
#define BIT_MEM_WLMAC_DS_8812F BIT(2)
#define BIT_MEM_WLMCU_LS_8812F BIT(1)
#define BIT_MEM_WLMCU_DS_8812F BIT(0)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_FW_DBG6_8812F */

#define BIT_SHIFT_FW_DBG6_8812F 0
#define BIT_MASK_FW_DBG6_8812F 0xffffffffL
#define BIT_FW_DBG6_8812F(x)                                                   \
	(((x) & BIT_MASK_FW_DBG6_8812F) << BIT_SHIFT_FW_DBG6_8812F)
#define BITS_FW_DBG6_8812F (BIT_MASK_FW_DBG6_8812F << BIT_SHIFT_FW_DBG6_8812F)
#define BIT_CLEAR_FW_DBG6_8812F(x) ((x) & (~BITS_FW_DBG6_8812F))
#define BIT_GET_FW_DBG6_8812F(x)                                               \
	(((x) >> BIT_SHIFT_FW_DBG6_8812F) & BIT_MASK_FW_DBG6_8812F)
#define BIT_SET_FW_DBG6_8812F(x, v)                                            \
	(BIT_CLEAR_FW_DBG6_8812F(x) | BIT_FW_DBG6_8812F(v))

/* 2 REG_FW_DBG7_8812F */

#define BIT_SHIFT_FW_DBG7_8812F 0
#define BIT_MASK_FW_DBG7_8812F 0xffffffffL
#define BIT_FW_DBG7_8812F(x)                                                   \
	(((x) & BIT_MASK_FW_DBG7_8812F) << BIT_SHIFT_FW_DBG7_8812F)
#define BITS_FW_DBG7_8812F (BIT_MASK_FW_DBG7_8812F << BIT_SHIFT_FW_DBG7_8812F)
#define BIT_CLEAR_FW_DBG7_8812F(x) ((x) & (~BITS_FW_DBG7_8812F))
#define BIT_GET_FW_DBG7_8812F(x)                                               \
	(((x) >> BIT_SHIFT_FW_DBG7_8812F) & BIT_MASK_FW_DBG7_8812F)
#define BIT_SET_FW_DBG7_8812F(x, v)                                            \
	(BIT_CLEAR_FW_DBG7_8812F(x) | BIT_FW_DBG7_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_CR_8812F */

#define BIT_SHIFT_LBMODE_8812F 24
#define BIT_MASK_LBMODE_8812F 0x1f
#define BIT_LBMODE_8812F(x)                                                    \
	(((x) & BIT_MASK_LBMODE_8812F) << BIT_SHIFT_LBMODE_8812F)
#define BITS_LBMODE_8812F (BIT_MASK_LBMODE_8812F << BIT_SHIFT_LBMODE_8812F)
#define BIT_CLEAR_LBMODE_8812F(x) ((x) & (~BITS_LBMODE_8812F))
#define BIT_GET_LBMODE_8812F(x)                                                \
	(((x) >> BIT_SHIFT_LBMODE_8812F) & BIT_MASK_LBMODE_8812F)
#define BIT_SET_LBMODE_8812F(x, v)                                             \
	(BIT_CLEAR_LBMODE_8812F(x) | BIT_LBMODE_8812F(v))

#define BIT_SHIFT_NETYPE1_8812F 18
#define BIT_MASK_NETYPE1_8812F 0x3
#define BIT_NETYPE1_8812F(x)                                                   \
	(((x) & BIT_MASK_NETYPE1_8812F) << BIT_SHIFT_NETYPE1_8812F)
#define BITS_NETYPE1_8812F (BIT_MASK_NETYPE1_8812F << BIT_SHIFT_NETYPE1_8812F)
#define BIT_CLEAR_NETYPE1_8812F(x) ((x) & (~BITS_NETYPE1_8812F))
#define BIT_GET_NETYPE1_8812F(x)                                               \
	(((x) >> BIT_SHIFT_NETYPE1_8812F) & BIT_MASK_NETYPE1_8812F)
#define BIT_SET_NETYPE1_8812F(x, v)                                            \
	(BIT_CLEAR_NETYPE1_8812F(x) | BIT_NETYPE1_8812F(v))

#define BIT_SHIFT_NETYPE0_8812F 16
#define BIT_MASK_NETYPE0_8812F 0x3
#define BIT_NETYPE0_8812F(x)                                                   \
	(((x) & BIT_MASK_NETYPE0_8812F) << BIT_SHIFT_NETYPE0_8812F)
#define BITS_NETYPE0_8812F (BIT_MASK_NETYPE0_8812F << BIT_SHIFT_NETYPE0_8812F)
#define BIT_CLEAR_NETYPE0_8812F(x) ((x) & (~BITS_NETYPE0_8812F))
#define BIT_GET_NETYPE0_8812F(x)                                               \
	(((x) >> BIT_SHIFT_NETYPE0_8812F) & BIT_MASK_NETYPE0_8812F)
#define BIT_SET_NETYPE0_8812F(x, v)                                            \
	(BIT_CLEAR_NETYPE0_8812F(x) | BIT_NETYPE0_8812F(v))

#define BIT_COUNTER_STS_EN_8812F BIT(13)
#define BIT_I2C_MAILBOX_EN_8812F BIT(12)
#define BIT_SHCUT_EN_8812F BIT(11)
#define BIT_32K_CAL_TMR_EN_8812F BIT(10)
#define BIT_MAC_SEC_EN_8812F BIT(9)
#define BIT_ENSWBCN_8812F BIT(8)
#define BIT_MACRXEN_8812F BIT(7)
#define BIT_MACTXEN_8812F BIT(6)
#define BIT_SCHEDULE_EN_8812F BIT(5)
#define BIT_PROTOCOL_EN_8812F BIT(4)
#define BIT_RXDMA_EN_8812F BIT(3)
#define BIT_TXDMA_EN_8812F BIT(2)
#define BIT_HCI_RXDMA_EN_8812F BIT(1)
#define BIT_HCI_TXDMA_EN_8812F BIT(0)

/* 2 REG_PG_SIZE_8812F */

#define BIT_SHIFT_DBG_FIFO_SEL_8812F 16
#define BIT_MASK_DBG_FIFO_SEL_8812F 0xff
#define BIT_DBG_FIFO_SEL_8812F(x)                                              \
	(((x) & BIT_MASK_DBG_FIFO_SEL_8812F) << BIT_SHIFT_DBG_FIFO_SEL_8812F)
#define BITS_DBG_FIFO_SEL_8812F                                                \
	(BIT_MASK_DBG_FIFO_SEL_8812F << BIT_SHIFT_DBG_FIFO_SEL_8812F)
#define BIT_CLEAR_DBG_FIFO_SEL_8812F(x) ((x) & (~BITS_DBG_FIFO_SEL_8812F))
#define BIT_GET_DBG_FIFO_SEL_8812F(x)                                          \
	(((x) >> BIT_SHIFT_DBG_FIFO_SEL_8812F) & BIT_MASK_DBG_FIFO_SEL_8812F)
#define BIT_SET_DBG_FIFO_SEL_8812F(x, v)                                       \
	(BIT_CLEAR_DBG_FIFO_SEL_8812F(x) | BIT_DBG_FIFO_SEL_8812F(v))

/* 2 REG_PKT_BUFF_ACCESS_CTRL_8812F */

#define BIT_SHIFT_PKT_BUFF_ACCESS_CTRL_8812F 0
#define BIT_MASK_PKT_BUFF_ACCESS_CTRL_8812F 0xff
#define BIT_PKT_BUFF_ACCESS_CTRL_8812F(x)                                      \
	(((x) & BIT_MASK_PKT_BUFF_ACCESS_CTRL_8812F)                           \
	 << BIT_SHIFT_PKT_BUFF_ACCESS_CTRL_8812F)
#define BITS_PKT_BUFF_ACCESS_CTRL_8812F                                        \
	(BIT_MASK_PKT_BUFF_ACCESS_CTRL_8812F                                   \
	 << BIT_SHIFT_PKT_BUFF_ACCESS_CTRL_8812F)
#define BIT_CLEAR_PKT_BUFF_ACCESS_CTRL_8812F(x)                                \
	((x) & (~BITS_PKT_BUFF_ACCESS_CTRL_8812F))
#define BIT_GET_PKT_BUFF_ACCESS_CTRL_8812F(x)                                  \
	(((x) >> BIT_SHIFT_PKT_BUFF_ACCESS_CTRL_8812F) &                       \
	 BIT_MASK_PKT_BUFF_ACCESS_CTRL_8812F)
#define BIT_SET_PKT_BUFF_ACCESS_CTRL_8812F(x, v)                               \
	(BIT_CLEAR_PKT_BUFF_ACCESS_CTRL_8812F(x) |                             \
	 BIT_PKT_BUFF_ACCESS_CTRL_8812F(v))

/* 2 REG_TSF_CLK_STATE_8812F */
#define BIT_TSF_CLK_STABLE_8812F BIT(15)

/* 2 REG_TXDMA_PQ_MAP_8812F */
#define BIT_CSI_BW_EN_8812F BIT(31)

#define BIT_SHIFT_TXDMA_H2C_MAP_8812F 16
#define BIT_MASK_TXDMA_H2C_MAP_8812F 0x3
#define BIT_TXDMA_H2C_MAP_8812F(x)                                             \
	(((x) & BIT_MASK_TXDMA_H2C_MAP_8812F) << BIT_SHIFT_TXDMA_H2C_MAP_8812F)
#define BITS_TXDMA_H2C_MAP_8812F                                               \
	(BIT_MASK_TXDMA_H2C_MAP_8812F << BIT_SHIFT_TXDMA_H2C_MAP_8812F)
#define BIT_CLEAR_TXDMA_H2C_MAP_8812F(x) ((x) & (~BITS_TXDMA_H2C_MAP_8812F))
#define BIT_GET_TXDMA_H2C_MAP_8812F(x)                                         \
	(((x) >> BIT_SHIFT_TXDMA_H2C_MAP_8812F) & BIT_MASK_TXDMA_H2C_MAP_8812F)
#define BIT_SET_TXDMA_H2C_MAP_8812F(x, v)                                      \
	(BIT_CLEAR_TXDMA_H2C_MAP_8812F(x) | BIT_TXDMA_H2C_MAP_8812F(v))

#define BIT_SHIFT_TXDMA_HIQ_MAP_8812F 14
#define BIT_MASK_TXDMA_HIQ_MAP_8812F 0x3
#define BIT_TXDMA_HIQ_MAP_8812F(x)                                             \
	(((x) & BIT_MASK_TXDMA_HIQ_MAP_8812F) << BIT_SHIFT_TXDMA_HIQ_MAP_8812F)
#define BITS_TXDMA_HIQ_MAP_8812F                                               \
	(BIT_MASK_TXDMA_HIQ_MAP_8812F << BIT_SHIFT_TXDMA_HIQ_MAP_8812F)
#define BIT_CLEAR_TXDMA_HIQ_MAP_8812F(x) ((x) & (~BITS_TXDMA_HIQ_MAP_8812F))
#define BIT_GET_TXDMA_HIQ_MAP_8812F(x)                                         \
	(((x) >> BIT_SHIFT_TXDMA_HIQ_MAP_8812F) & BIT_MASK_TXDMA_HIQ_MAP_8812F)
#define BIT_SET_TXDMA_HIQ_MAP_8812F(x, v)                                      \
	(BIT_CLEAR_TXDMA_HIQ_MAP_8812F(x) | BIT_TXDMA_HIQ_MAP_8812F(v))

#define BIT_SHIFT_TXDMA_MGQ_MAP_8812F 12
#define BIT_MASK_TXDMA_MGQ_MAP_8812F 0x3
#define BIT_TXDMA_MGQ_MAP_8812F(x)                                             \
	(((x) & BIT_MASK_TXDMA_MGQ_MAP_8812F) << BIT_SHIFT_TXDMA_MGQ_MAP_8812F)
#define BITS_TXDMA_MGQ_MAP_8812F                                               \
	(BIT_MASK_TXDMA_MGQ_MAP_8812F << BIT_SHIFT_TXDMA_MGQ_MAP_8812F)
#define BIT_CLEAR_TXDMA_MGQ_MAP_8812F(x) ((x) & (~BITS_TXDMA_MGQ_MAP_8812F))
#define BIT_GET_TXDMA_MGQ_MAP_8812F(x)                                         \
	(((x) >> BIT_SHIFT_TXDMA_MGQ_MAP_8812F) & BIT_MASK_TXDMA_MGQ_MAP_8812F)
#define BIT_SET_TXDMA_MGQ_MAP_8812F(x, v)                                      \
	(BIT_CLEAR_TXDMA_MGQ_MAP_8812F(x) | BIT_TXDMA_MGQ_MAP_8812F(v))

#define BIT_SHIFT_TXDMA_BKQ_MAP_8812F 10
#define BIT_MASK_TXDMA_BKQ_MAP_8812F 0x3
#define BIT_TXDMA_BKQ_MAP_8812F(x)                                             \
	(((x) & BIT_MASK_TXDMA_BKQ_MAP_8812F) << BIT_SHIFT_TXDMA_BKQ_MAP_8812F)
#define BITS_TXDMA_BKQ_MAP_8812F                                               \
	(BIT_MASK_TXDMA_BKQ_MAP_8812F << BIT_SHIFT_TXDMA_BKQ_MAP_8812F)
#define BIT_CLEAR_TXDMA_BKQ_MAP_8812F(x) ((x) & (~BITS_TXDMA_BKQ_MAP_8812F))
#define BIT_GET_TXDMA_BKQ_MAP_8812F(x)                                         \
	(((x) >> BIT_SHIFT_TXDMA_BKQ_MAP_8812F) & BIT_MASK_TXDMA_BKQ_MAP_8812F)
#define BIT_SET_TXDMA_BKQ_MAP_8812F(x, v)                                      \
	(BIT_CLEAR_TXDMA_BKQ_MAP_8812F(x) | BIT_TXDMA_BKQ_MAP_8812F(v))

#define BIT_SHIFT_TXDMA_BEQ_MAP_8812F 8
#define BIT_MASK_TXDMA_BEQ_MAP_8812F 0x3
#define BIT_TXDMA_BEQ_MAP_8812F(x)                                             \
	(((x) & BIT_MASK_TXDMA_BEQ_MAP_8812F) << BIT_SHIFT_TXDMA_BEQ_MAP_8812F)
#define BITS_TXDMA_BEQ_MAP_8812F                                               \
	(BIT_MASK_TXDMA_BEQ_MAP_8812F << BIT_SHIFT_TXDMA_BEQ_MAP_8812F)
#define BIT_CLEAR_TXDMA_BEQ_MAP_8812F(x) ((x) & (~BITS_TXDMA_BEQ_MAP_8812F))
#define BIT_GET_TXDMA_BEQ_MAP_8812F(x)                                         \
	(((x) >> BIT_SHIFT_TXDMA_BEQ_MAP_8812F) & BIT_MASK_TXDMA_BEQ_MAP_8812F)
#define BIT_SET_TXDMA_BEQ_MAP_8812F(x, v)                                      \
	(BIT_CLEAR_TXDMA_BEQ_MAP_8812F(x) | BIT_TXDMA_BEQ_MAP_8812F(v))

#define BIT_SHIFT_TXDMA_VIQ_MAP_8812F 6
#define BIT_MASK_TXDMA_VIQ_MAP_8812F 0x3
#define BIT_TXDMA_VIQ_MAP_8812F(x)                                             \
	(((x) & BIT_MASK_TXDMA_VIQ_MAP_8812F) << BIT_SHIFT_TXDMA_VIQ_MAP_8812F)
#define BITS_TXDMA_VIQ_MAP_8812F                                               \
	(BIT_MASK_TXDMA_VIQ_MAP_8812F << BIT_SHIFT_TXDMA_VIQ_MAP_8812F)
#define BIT_CLEAR_TXDMA_VIQ_MAP_8812F(x) ((x) & (~BITS_TXDMA_VIQ_MAP_8812F))
#define BIT_GET_TXDMA_VIQ_MAP_8812F(x)                                         \
	(((x) >> BIT_SHIFT_TXDMA_VIQ_MAP_8812F) & BIT_MASK_TXDMA_VIQ_MAP_8812F)
#define BIT_SET_TXDMA_VIQ_MAP_8812F(x, v)                                      \
	(BIT_CLEAR_TXDMA_VIQ_MAP_8812F(x) | BIT_TXDMA_VIQ_MAP_8812F(v))

#define BIT_SHIFT_TXDMA_VOQ_MAP_8812F 4
#define BIT_MASK_TXDMA_VOQ_MAP_8812F 0x3
#define BIT_TXDMA_VOQ_MAP_8812F(x)                                             \
	(((x) & BIT_MASK_TXDMA_VOQ_MAP_8812F) << BIT_SHIFT_TXDMA_VOQ_MAP_8812F)
#define BITS_TXDMA_VOQ_MAP_8812F                                               \
	(BIT_MASK_TXDMA_VOQ_MAP_8812F << BIT_SHIFT_TXDMA_VOQ_MAP_8812F)
#define BIT_CLEAR_TXDMA_VOQ_MAP_8812F(x) ((x) & (~BITS_TXDMA_VOQ_MAP_8812F))
#define BIT_GET_TXDMA_VOQ_MAP_8812F(x)                                         \
	(((x) >> BIT_SHIFT_TXDMA_VOQ_MAP_8812F) & BIT_MASK_TXDMA_VOQ_MAP_8812F)
#define BIT_SET_TXDMA_VOQ_MAP_8812F(x, v)                                      \
	(BIT_CLEAR_TXDMA_VOQ_MAP_8812F(x) | BIT_TXDMA_VOQ_MAP_8812F(v))

#define BIT_TXDMA_BW_EN_8812F BIT(3)
#define BIT_RXDMA_AGG_EN_8812F BIT(2)
#define BIT_RXSHFT_EN_8812F BIT(1)
#define BIT_RXDMA_ARBBW_EN_8812F BIT(0)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_TRXFF_BNDY_8812F */

#define BIT_SHIFT_FWFFOVFL_RSV_8812F 16
#define BIT_MASK_FWFFOVFL_RSV_8812F 0xf
#define BIT_FWFFOVFL_RSV_8812F(x)                                              \
	(((x) & BIT_MASK_FWFFOVFL_RSV_8812F) << BIT_SHIFT_FWFFOVFL_RSV_8812F)
#define BITS_FWFFOVFL_RSV_8812F                                                \
	(BIT_MASK_FWFFOVFL_RSV_8812F << BIT_SHIFT_FWFFOVFL_RSV_8812F)
#define BIT_CLEAR_FWFFOVFL_RSV_8812F(x) ((x) & (~BITS_FWFFOVFL_RSV_8812F))
#define BIT_GET_FWFFOVFL_RSV_8812F(x)                                          \
	(((x) >> BIT_SHIFT_FWFFOVFL_RSV_8812F) & BIT_MASK_FWFFOVFL_RSV_8812F)
#define BIT_SET_FWFFOVFL_RSV_8812F(x, v)                                       \
	(BIT_CLEAR_FWFFOVFL_RSV_8812F(x) | BIT_FWFFOVFL_RSV_8812F(v))

#define BIT_SHIFT_RXFFOVFL_RSV_V2_8812F 8
#define BIT_MASK_RXFFOVFL_RSV_V2_8812F 0xf
#define BIT_RXFFOVFL_RSV_V2_8812F(x)                                           \
	(((x) & BIT_MASK_RXFFOVFL_RSV_V2_8812F)                                \
	 << BIT_SHIFT_RXFFOVFL_RSV_V2_8812F)
#define BITS_RXFFOVFL_RSV_V2_8812F                                             \
	(BIT_MASK_RXFFOVFL_RSV_V2_8812F << BIT_SHIFT_RXFFOVFL_RSV_V2_8812F)
#define BIT_CLEAR_RXFFOVFL_RSV_V2_8812F(x) ((x) & (~BITS_RXFFOVFL_RSV_V2_8812F))
#define BIT_GET_RXFFOVFL_RSV_V2_8812F(x)                                       \
	(((x) >> BIT_SHIFT_RXFFOVFL_RSV_V2_8812F) &                            \
	 BIT_MASK_RXFFOVFL_RSV_V2_8812F)
#define BIT_SET_RXFFOVFL_RSV_V2_8812F(x, v)                                    \
	(BIT_CLEAR_RXFFOVFL_RSV_V2_8812F(x) | BIT_RXFFOVFL_RSV_V2_8812F(v))

/* 2 REG_PTA_I2C_MBOX_8812F */

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_I2C_M_STATUS_8812F 8
#define BIT_MASK_I2C_M_STATUS_8812F 0xf
#define BIT_I2C_M_STATUS_8812F(x)                                              \
	(((x) & BIT_MASK_I2C_M_STATUS_8812F) << BIT_SHIFT_I2C_M_STATUS_8812F)
#define BITS_I2C_M_STATUS_8812F                                                \
	(BIT_MASK_I2C_M_STATUS_8812F << BIT_SHIFT_I2C_M_STATUS_8812F)
#define BIT_CLEAR_I2C_M_STATUS_8812F(x) ((x) & (~BITS_I2C_M_STATUS_8812F))
#define BIT_GET_I2C_M_STATUS_8812F(x)                                          \
	(((x) >> BIT_SHIFT_I2C_M_STATUS_8812F) & BIT_MASK_I2C_M_STATUS_8812F)
#define BIT_SET_I2C_M_STATUS_8812F(x, v)                                       \
	(BIT_CLEAR_I2C_M_STATUS_8812F(x) | BIT_I2C_M_STATUS_8812F(v))

#define BIT_SHIFT_I2C_M_BUS_GNT_FW_8812F 4
#define BIT_MASK_I2C_M_BUS_GNT_FW_8812F 0x7
#define BIT_I2C_M_BUS_GNT_FW_8812F(x)                                          \
	(((x) & BIT_MASK_I2C_M_BUS_GNT_FW_8812F)                               \
	 << BIT_SHIFT_I2C_M_BUS_GNT_FW_8812F)
#define BITS_I2C_M_BUS_GNT_FW_8812F                                            \
	(BIT_MASK_I2C_M_BUS_GNT_FW_8812F << BIT_SHIFT_I2C_M_BUS_GNT_FW_8812F)
#define BIT_CLEAR_I2C_M_BUS_GNT_FW_8812F(x)                                    \
	((x) & (~BITS_I2C_M_BUS_GNT_FW_8812F))
#define BIT_GET_I2C_M_BUS_GNT_FW_8812F(x)                                      \
	(((x) >> BIT_SHIFT_I2C_M_BUS_GNT_FW_8812F) &                           \
	 BIT_MASK_I2C_M_BUS_GNT_FW_8812F)
#define BIT_SET_I2C_M_BUS_GNT_FW_8812F(x, v)                                   \
	(BIT_CLEAR_I2C_M_BUS_GNT_FW_8812F(x) | BIT_I2C_M_BUS_GNT_FW_8812F(v))

#define BIT_I2C_M_GNT_FW_8812F BIT(3)

#define BIT_SHIFT_I2C_M_SPEED_8812F 1
#define BIT_MASK_I2C_M_SPEED_8812F 0x3
#define BIT_I2C_M_SPEED_8812F(x)                                               \
	(((x) & BIT_MASK_I2C_M_SPEED_8812F) << BIT_SHIFT_I2C_M_SPEED_8812F)
#define BITS_I2C_M_SPEED_8812F                                                 \
	(BIT_MASK_I2C_M_SPEED_8812F << BIT_SHIFT_I2C_M_SPEED_8812F)
#define BIT_CLEAR_I2C_M_SPEED_8812F(x) ((x) & (~BITS_I2C_M_SPEED_8812F))
#define BIT_GET_I2C_M_SPEED_8812F(x)                                           \
	(((x) >> BIT_SHIFT_I2C_M_SPEED_8812F) & BIT_MASK_I2C_M_SPEED_8812F)
#define BIT_SET_I2C_M_SPEED_8812F(x, v)                                        \
	(BIT_CLEAR_I2C_M_SPEED_8812F(x) | BIT_I2C_M_SPEED_8812F(v))

#define BIT_I2C_M_UNLOCK_8812F BIT(0)

/* 2 REG_RXFF_BNDY_8812F */

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_RXFF0_BNDY_V2_8812F 0
#define BIT_MASK_RXFF0_BNDY_V2_8812F 0x3ffff
#define BIT_RXFF0_BNDY_V2_8812F(x)                                             \
	(((x) & BIT_MASK_RXFF0_BNDY_V2_8812F) << BIT_SHIFT_RXFF0_BNDY_V2_8812F)
#define BITS_RXFF0_BNDY_V2_8812F                                               \
	(BIT_MASK_RXFF0_BNDY_V2_8812F << BIT_SHIFT_RXFF0_BNDY_V2_8812F)
#define BIT_CLEAR_RXFF0_BNDY_V2_8812F(x) ((x) & (~BITS_RXFF0_BNDY_V2_8812F))
#define BIT_GET_RXFF0_BNDY_V2_8812F(x)                                         \
	(((x) >> BIT_SHIFT_RXFF0_BNDY_V2_8812F) & BIT_MASK_RXFF0_BNDY_V2_8812F)
#define BIT_SET_RXFF0_BNDY_V2_8812F(x, v)                                      \
	(BIT_CLEAR_RXFF0_BNDY_V2_8812F(x) | BIT_RXFF0_BNDY_V2_8812F(v))

/* 2 REG_FE1IMR_8812F */
#define BIT_FS_SW_PLL_LEAVE_32K_INT_EN_8812F BIT(31)
#define BIT_FS_FWFF_FULL_INT_EN_8812F BIT(30)
#define BIT_FS_BB_STOP_RX_INT_EN_8812F BIT(29)
#define BIT_FS_RXDMA2_DONE_INT_EN_8812F BIT(28)
#define BIT_FS_RXDONE2_INT_EN_8812F BIT(26)
#define BIT_FS_RX_BCN_P4_INT_EN_8812F BIT(25)
#define BIT_FS_RX_BCN_P3_INT_EN_8812F BIT(24)
#define BIT_FS_RX_BCN_P2_INT_EN_8812F BIT(23)
#define BIT_FS_RX_BCN_P1_INT_EN_8812F BIT(22)
#define BIT_FS_RX_BCN_P0_INT_EN_8812F BIT(21)
#define BIT_FS_RX_UMD0_INT_EN_8812F BIT(20)
#define BIT_FS_RX_UMD1_INT_EN_8812F BIT(19)
#define BIT_FS_RX_BMD0_INT_EN_8812F BIT(18)
#define BIT_FS_RX_BMD1_INT_EN_8812F BIT(17)
#define BIT_FS_RXDONE_INT_EN_8812F BIT(16)
#define BIT_FS_WWLAN_INT_EN_8812F BIT(15)
#define BIT_FS_SOUND_DONE_INT_EN_8812F BIT(14)
#define BIT_FS_BF1_PRETO_INT_EN_8812F BIT(11)
#define BIT_FS_BF0_PRETO_INT_EN_8812F BIT(10)
#define BIT_FS_PTCL_RELEASE_MACID_INT_EN_8812F BIT(9)
#define BIT_FS_PRETX_ERRHLD_INT_EN_8812F BIT(8)
#define BIT_FS_LTE_COEX_EN_8812F BIT(6)
#define BIT_FS_WLACTOFF_INT_EN_8812F BIT(5)
#define BIT_FS_WLACTON_INT_EN_8812F BIT(4)
#define BIT_FS_BTCMD_INT_EN_8812F BIT(3)
#define BIT_FS_REG_MAILBOX_TO_I2C_INT_EN_8812F BIT(2)
#define BIT_FS_TRPC_TO_INT_EN_V1_8812F BIT(1)
#define BIT_FS_RPC_O_T_INT_EN_V1_8812F BIT(0)

/* 2 REG_FE1ISR_8812F */
#define BIT_FS_SW_PLL_LEAVE_32K_INT_8812F BIT(31)
#define BIT_FS_FS_FWFF_FULL_INT_8812F BIT(30)
#define BIT_FS_BB_STOP_RX_INT_8812F BIT(29)
#define BIT_FS_RXDMA2_DONE_INT_8812F BIT(28)
#define BIT_FS_RXDONE2_INT_8812F BIT(26)
#define BIT_FS_RX_BCN_P4_INT_8812F BIT(25)
#define BIT_FS_RX_BCN_P3_INT_8812F BIT(24)
#define BIT_FS_RX_BCN_P2_INT_8812F BIT(23)
#define BIT_FS_RX_BCN_P1_INT_8812F BIT(22)
#define BIT_FS_RX_BCN_P0_INT_8812F BIT(21)
#define BIT_FS_RX_UMD0_INT_8812F BIT(20)
#define BIT_FS_RX_UMD1_INT_8812F BIT(19)
#define BIT_FS_RX_BMD0_INT_8812F BIT(18)
#define BIT_FS_RX_BMD1_INT_8812F BIT(17)
#define BIT_FS_RXDONE_INT_8812F BIT(16)
#define BIT_FS_WWLAN_INT_8812F BIT(15)
#define BIT_FS_SOUND_DONE_INT_8812F BIT(14)
#define BIT_FS_BF1_PRETO_INT_8812F BIT(11)
#define BIT_FS_BF0_PRETO_INT_8812F BIT(10)
#define BIT_FS_PTCL_RELEASE_MACID_INT_8812F BIT(9)
#define BIT_FS_PRETX_ERRHLD_INT_8812F BIT(8)
#define BIT_FS_LTE_COEX_INT_8812F BIT(6)
#define BIT_FS_WLACTOFF_INT_8812F BIT(5)
#define BIT_FS_WLACTON_INT_8812F BIT(4)
#define BIT_FS_BCN_RX_INT_INT_8812F BIT(3)
#define BIT_FS_MAILBOX_TO_I2C_INT_8812F BIT(2)
#define BIT_FS_TRPC_TO_INT_8812F BIT(1)
#define BIT_FS_RPC_O_T_INT_8812F BIT(0)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_CPWM_8812F */
#define BIT_CPWM_TOGGLING_8812F BIT(31)

#define BIT_SHIFT_CPWM_MOD_8812F 24
#define BIT_MASK_CPWM_MOD_8812F 0x7f
#define BIT_CPWM_MOD_8812F(x)                                                  \
	(((x) & BIT_MASK_CPWM_MOD_8812F) << BIT_SHIFT_CPWM_MOD_8812F)
#define BITS_CPWM_MOD_8812F                                                    \
	(BIT_MASK_CPWM_MOD_8812F << BIT_SHIFT_CPWM_MOD_8812F)
#define BIT_CLEAR_CPWM_MOD_8812F(x) ((x) & (~BITS_CPWM_MOD_8812F))
#define BIT_GET_CPWM_MOD_8812F(x)                                              \
	(((x) >> BIT_SHIFT_CPWM_MOD_8812F) & BIT_MASK_CPWM_MOD_8812F)
#define BIT_SET_CPWM_MOD_8812F(x, v)                                           \
	(BIT_CLEAR_CPWM_MOD_8812F(x) | BIT_CPWM_MOD_8812F(v))

/* 2 REG_FWIMR_8812F */
#define BIT_FS_TXBCNOK_MB7_INT_EN_8812F BIT(31)
#define BIT_FS_TXBCNOK_MB6_INT_EN_8812F BIT(30)
#define BIT_FS_TXBCNOK_MB5_INT_EN_8812F BIT(29)
#define BIT_FS_TXBCNOK_MB4_INT_EN_8812F BIT(28)
#define BIT_FS_TXBCNOK_MB3_INT_EN_8812F BIT(27)
#define BIT_FS_TXBCNOK_MB2_INT_EN_8812F BIT(26)
#define BIT_FS_TXBCNOK_MB1_INT_EN_8812F BIT(25)
#define BIT_FS_TXBCNOK_MB0_INT_EN_8812F BIT(24)
#define BIT_FS_TXBCNERR_MB7_INT_EN_8812F BIT(23)
#define BIT_FS_TXBCNERR_MB6_INT_EN_8812F BIT(22)
#define BIT_FS_TXBCNERR_MB5_INT_EN_8812F BIT(21)
#define BIT_FS_TXBCNERR_MB4_INT_EN_8812F BIT(20)
#define BIT_FS_TXBCNERR_MB3_INT_EN_8812F BIT(19)
#define BIT_FS_TXBCNERR_MB2_INT_EN_8812F BIT(18)
#define BIT_FS_TXBCNERR_MB1_INT_EN_8812F BIT(17)
#define BIT_FS_TXBCNERR_MB0_INT_EN_8812F BIT(16)
#define BIT_CPU_MGQ_TXDONE_INT_EN_8812F BIT(15)
#define BIT_SIFS_OVERSPEC_INT_EN_8812F BIT(14)
#define BIT_FS_MGNTQ_RPTR_RELEASE_INT_EN_8812F BIT(13)
#define BIT_FS_MGNTQFF_TO_INT_EN_8812F BIT(12)
#define BIT_FS_CPUMGQ_ERR_INT_EN_8812F BIT(11)
#define BIT_FS_DDMA0_LP_INT_EN_8812F BIT(9)
#define BIT_FS_DDMA0_HP_INT_EN_8812F BIT(8)
#define BIT_FS_TRXRPT_INT_EN_8812F BIT(7)
#define BIT_FS_C2H_W_READY_INT_EN_8812F BIT(6)
#define BIT_FS_HRCV_INT_EN_8812F BIT(5)
#define BIT_FS_H2CCMD_INT_EN_8812F BIT(4)
#define BIT_FS_TXPKTIN_INT_EN_8812F BIT(3)
#define BIT_FS_ERRORHDL_INT_EN_8812F BIT(2)
#define BIT_FS_TXCCX_INT_EN_8812F BIT(1)
#define BIT_FS_TXCLOSE_INT_EN_8812F BIT(0)

/* 2 REG_FWISR_8812F */
#define BIT_FS_TXBCNOK_MB7_INT_8812F BIT(31)
#define BIT_FS_TXBCNOK_MB6_INT_8812F BIT(30)
#define BIT_FS_TXBCNOK_MB5_INT_8812F BIT(29)
#define BIT_FS_TXBCNOK_MB4_INT_8812F BIT(28)
#define BIT_FS_TXBCNOK_MB3_INT_8812F BIT(27)
#define BIT_FS_TXBCNOK_MB2_INT_8812F BIT(26)
#define BIT_FS_TXBCNOK_MB1_INT_8812F BIT(25)
#define BIT_FS_TXBCNOK_MB0_INT_8812F BIT(24)
#define BIT_FS_TXBCNERR_MB7_INT_8812F BIT(23)
#define BIT_FS_TXBCNERR_MB6_INT_8812F BIT(22)
#define BIT_FS_TXBCNERR_MB5_INT_8812F BIT(21)
#define BIT_FS_TXBCNERR_MB4_INT_8812F BIT(20)
#define BIT_FS_TXBCNERR_MB3_INT_8812F BIT(19)
#define BIT_FS_TXBCNERR_MB2_INT_8812F BIT(18)
#define BIT_FS_TXBCNERR_MB1_INT_8812F BIT(17)
#define BIT_FS_TXBCNERR_MB0_INT_8812F BIT(16)
#define BIT_CPU_MGQ_TXDONE_INT_8812F BIT(15)
#define BIT_SIFS_OVERSPEC_INT_8812F BIT(14)
#define BIT_FS_MGNTQ_RPTR_RELEASE_INT_8812F BIT(13)
#define BIT_FS_MGNTQFF_TO_INT_8812F BIT(12)
#define BIT_FS_CPUMGQ_ERR_INT_8812F BIT(11)
#define BIT_FS_DDMA0_LP_INT_8812F BIT(9)
#define BIT_FS_DDMA0_HP_INT_8812F BIT(8)
#define BIT_FS_TRXRPT_INT_8812F BIT(7)
#define BIT_FS_C2H_W_READY_INT_8812F BIT(6)
#define BIT_FS_HRCV_INT_8812F BIT(5)
#define BIT_FS_H2CCMD_INT_8812F BIT(4)
#define BIT_FS_TXPKTIN_INT_8812F BIT(3)
#define BIT_FS_ERRORHDL_INT_8812F BIT(2)
#define BIT_FS_TXCCX_INT_8812F BIT(1)
#define BIT_FS_TXCLOSE_INT_8812F BIT(0)

/* 2 REG_FTIMR_8812F */
#define BIT_PS_TIMER_C_EARLY_INT_EN_8812F BIT(23)
#define BIT_PS_TIMER_B_EARLY_INT_EN_8812F BIT(22)
#define BIT_PS_TIMER_A_EARLY_INT_EN_8812F BIT(21)
#define BIT_CPUMGQ_TX_TIMER_EARLY_INT_EN_8812F BIT(20)
#define BIT_PS_TIMER_C_INT_EN_8812F BIT(19)
#define BIT_PS_TIMER_B_INT_EN_8812F BIT(18)
#define BIT_PS_TIMER_A_INT_EN_8812F BIT(17)
#define BIT_CPUMGQ_TX_TIMER_INT_EN_8812F BIT(16)
#define BIT_FS_PS_TIMEOUT2_EN_8812F BIT(15)
#define BIT_FS_PS_TIMEOUT1_EN_8812F BIT(14)
#define BIT_FS_PS_TIMEOUT0_EN_8812F BIT(13)
#define BIT_FS_GTINT8_EN_8812F BIT(8)
#define BIT_FS_GTINT7_EN_8812F BIT(7)
#define BIT_FS_GTINT6_EN_8812F BIT(6)
#define BIT_FS_GTINT5_EN_8812F BIT(5)
#define BIT_FS_GTINT4_EN_8812F BIT(4)
#define BIT_FS_GTINT3_EN_8812F BIT(3)
#define BIT_FS_GTINT2_EN_8812F BIT(2)
#define BIT_FS_GTINT1_EN_8812F BIT(1)
#define BIT_FS_GTINT0_EN_8812F BIT(0)

/* 2 REG_FTISR_8812F */
#define BIT_PS_TIMER_C_EARLY__INT_8812F BIT(23)
#define BIT_PS_TIMER_B_EARLY__INT_8812F BIT(22)
#define BIT_PS_TIMER_A_EARLY__INT_8812F BIT(21)
#define BIT_CPUMGQ_TX_TIMER_EARLY_INT_8812F BIT(20)
#define BIT_PS_TIMER_C_INT_8812F BIT(19)
#define BIT_PS_TIMER_B_INT_8812F BIT(18)
#define BIT_PS_TIMER_A_INT_8812F BIT(17)
#define BIT_CPUMGQ_TX_TIMER_INT_8812F BIT(16)
#define BIT_FS_PS_TIMEOUT2_INT_8812F BIT(15)
#define BIT_FS_PS_TIMEOUT1_INT_8812F BIT(14)
#define BIT_FS_PS_TIMEOUT0_INT_8812F BIT(13)
#define BIT_FS_GTINT8_INT_8812F BIT(8)
#define BIT_FS_GTINT7_INT_8812F BIT(7)
#define BIT_FS_GTINT6_INT_8812F BIT(6)
#define BIT_FS_GTINT5_INT_8812F BIT(5)
#define BIT_FS_GTINT4_INT_8812F BIT(4)
#define BIT_FS_GTINT3_INT_8812F BIT(3)
#define BIT_FS_GTINT2_INT_8812F BIT(2)
#define BIT_FS_GTINT1_INT_8812F BIT(1)
#define BIT_FS_GTINT0_INT_8812F BIT(0)

/* 2 REG_PKTBUF_DBG_CTRL_8812F */

#define BIT_SHIFT_PKTBUF_WRITE_EN_8812F 24
#define BIT_MASK_PKTBUF_WRITE_EN_8812F 0xff
#define BIT_PKTBUF_WRITE_EN_8812F(x)                                           \
	(((x) & BIT_MASK_PKTBUF_WRITE_EN_8812F)                                \
	 << BIT_SHIFT_PKTBUF_WRITE_EN_8812F)
#define BITS_PKTBUF_WRITE_EN_8812F                                             \
	(BIT_MASK_PKTBUF_WRITE_EN_8812F << BIT_SHIFT_PKTBUF_WRITE_EN_8812F)
#define BIT_CLEAR_PKTBUF_WRITE_EN_8812F(x) ((x) & (~BITS_PKTBUF_WRITE_EN_8812F))
#define BIT_GET_PKTBUF_WRITE_EN_8812F(x)                                       \
	(((x) >> BIT_SHIFT_PKTBUF_WRITE_EN_8812F) &                            \
	 BIT_MASK_PKTBUF_WRITE_EN_8812F)
#define BIT_SET_PKTBUF_WRITE_EN_8812F(x, v)                                    \
	(BIT_CLEAR_PKTBUF_WRITE_EN_8812F(x) | BIT_PKTBUF_WRITE_EN_8812F(v))

#define BIT_TXRPTBUF_DBG_8812F BIT(23)

/* 2 REG_NOT_VALID_8812F */
#define BIT_TXPKTBUF_DBG_V2_8812F BIT(20)
#define BIT_RXPKTBUF_DBG_8812F BIT(16)

#define BIT_SHIFT_PKTBUF_DBG_ADDR_8812F 0
#define BIT_MASK_PKTBUF_DBG_ADDR_8812F 0x1fff
#define BIT_PKTBUF_DBG_ADDR_8812F(x)                                           \
	(((x) & BIT_MASK_PKTBUF_DBG_ADDR_8812F)                                \
	 << BIT_SHIFT_PKTBUF_DBG_ADDR_8812F)
#define BITS_PKTBUF_DBG_ADDR_8812F                                             \
	(BIT_MASK_PKTBUF_DBG_ADDR_8812F << BIT_SHIFT_PKTBUF_DBG_ADDR_8812F)
#define BIT_CLEAR_PKTBUF_DBG_ADDR_8812F(x) ((x) & (~BITS_PKTBUF_DBG_ADDR_8812F))
#define BIT_GET_PKTBUF_DBG_ADDR_8812F(x)                                       \
	(((x) >> BIT_SHIFT_PKTBUF_DBG_ADDR_8812F) &                            \
	 BIT_MASK_PKTBUF_DBG_ADDR_8812F)
#define BIT_SET_PKTBUF_DBG_ADDR_8812F(x, v)                                    \
	(BIT_CLEAR_PKTBUF_DBG_ADDR_8812F(x) | BIT_PKTBUF_DBG_ADDR_8812F(v))

/* 2 REG_PKTBUF_DBG_DATA_L_8812F */

#define BIT_SHIFT_PKTBUF_DBG_DATA_L_8812F 0
#define BIT_MASK_PKTBUF_DBG_DATA_L_8812F 0xffffffffL
#define BIT_PKTBUF_DBG_DATA_L_8812F(x)                                         \
	(((x) & BIT_MASK_PKTBUF_DBG_DATA_L_8812F)                              \
	 << BIT_SHIFT_PKTBUF_DBG_DATA_L_8812F)
#define BITS_PKTBUF_DBG_DATA_L_8812F                                           \
	(BIT_MASK_PKTBUF_DBG_DATA_L_8812F << BIT_SHIFT_PKTBUF_DBG_DATA_L_8812F)
#define BIT_CLEAR_PKTBUF_DBG_DATA_L_8812F(x)                                   \
	((x) & (~BITS_PKTBUF_DBG_DATA_L_8812F))
#define BIT_GET_PKTBUF_DBG_DATA_L_8812F(x)                                     \
	(((x) >> BIT_SHIFT_PKTBUF_DBG_DATA_L_8812F) &                          \
	 BIT_MASK_PKTBUF_DBG_DATA_L_8812F)
#define BIT_SET_PKTBUF_DBG_DATA_L_8812F(x, v)                                  \
	(BIT_CLEAR_PKTBUF_DBG_DATA_L_8812F(x) | BIT_PKTBUF_DBG_DATA_L_8812F(v))

/* 2 REG_PKTBUF_DBG_DATA_H_8812F */

#define BIT_SHIFT_PKTBUF_DBG_DATA_H_8812F 0
#define BIT_MASK_PKTBUF_DBG_DATA_H_8812F 0xffffffffL
#define BIT_PKTBUF_DBG_DATA_H_8812F(x)                                         \
	(((x) & BIT_MASK_PKTBUF_DBG_DATA_H_8812F)                              \
	 << BIT_SHIFT_PKTBUF_DBG_DATA_H_8812F)
#define BITS_PKTBUF_DBG_DATA_H_8812F                                           \
	(BIT_MASK_PKTBUF_DBG_DATA_H_8812F << BIT_SHIFT_PKTBUF_DBG_DATA_H_8812F)
#define BIT_CLEAR_PKTBUF_DBG_DATA_H_8812F(x)                                   \
	((x) & (~BITS_PKTBUF_DBG_DATA_H_8812F))
#define BIT_GET_PKTBUF_DBG_DATA_H_8812F(x)                                     \
	(((x) >> BIT_SHIFT_PKTBUF_DBG_DATA_H_8812F) &                          \
	 BIT_MASK_PKTBUF_DBG_DATA_H_8812F)
#define BIT_SET_PKTBUF_DBG_DATA_H_8812F(x, v)                                  \
	(BIT_CLEAR_PKTBUF_DBG_DATA_H_8812F(x) | BIT_PKTBUF_DBG_DATA_H_8812F(v))

/* 2 REG_CPWM2_8812F */

#define BIT_SHIFT_L0S_TO_RCVY_NUM_8812F 16
#define BIT_MASK_L0S_TO_RCVY_NUM_8812F 0xff
#define BIT_L0S_TO_RCVY_NUM_8812F(x)                                           \
	(((x) & BIT_MASK_L0S_TO_RCVY_NUM_8812F)                                \
	 << BIT_SHIFT_L0S_TO_RCVY_NUM_8812F)
#define BITS_L0S_TO_RCVY_NUM_8812F                                             \
	(BIT_MASK_L0S_TO_RCVY_NUM_8812F << BIT_SHIFT_L0S_TO_RCVY_NUM_8812F)
#define BIT_CLEAR_L0S_TO_RCVY_NUM_8812F(x) ((x) & (~BITS_L0S_TO_RCVY_NUM_8812F))
#define BIT_GET_L0S_TO_RCVY_NUM_8812F(x)                                       \
	(((x) >> BIT_SHIFT_L0S_TO_RCVY_NUM_8812F) &                            \
	 BIT_MASK_L0S_TO_RCVY_NUM_8812F)
#define BIT_SET_L0S_TO_RCVY_NUM_8812F(x, v)                                    \
	(BIT_CLEAR_L0S_TO_RCVY_NUM_8812F(x) | BIT_L0S_TO_RCVY_NUM_8812F(v))

#define BIT_CPWM2_TOGGLING_8812F BIT(15)

#define BIT_SHIFT_CPWM2_MOD_8812F 0
#define BIT_MASK_CPWM2_MOD_8812F 0x7fff
#define BIT_CPWM2_MOD_8812F(x)                                                 \
	(((x) & BIT_MASK_CPWM2_MOD_8812F) << BIT_SHIFT_CPWM2_MOD_8812F)
#define BITS_CPWM2_MOD_8812F                                                   \
	(BIT_MASK_CPWM2_MOD_8812F << BIT_SHIFT_CPWM2_MOD_8812F)
#define BIT_CLEAR_CPWM2_MOD_8812F(x) ((x) & (~BITS_CPWM2_MOD_8812F))
#define BIT_GET_CPWM2_MOD_8812F(x)                                             \
	(((x) >> BIT_SHIFT_CPWM2_MOD_8812F) & BIT_MASK_CPWM2_MOD_8812F)
#define BIT_SET_CPWM2_MOD_8812F(x, v)                                          \
	(BIT_CLEAR_CPWM2_MOD_8812F(x) | BIT_CPWM2_MOD_8812F(v))

/* 2 REG_TC0_CTRL_8812F */
#define BIT_TC0INT_EN_8812F BIT(26)
#define BIT_TC0MODE_8812F BIT(25)
#define BIT_TC0EN_8812F BIT(24)

#define BIT_SHIFT_TC0DATA_8812F 0
#define BIT_MASK_TC0DATA_8812F 0xffffff
#define BIT_TC0DATA_8812F(x)                                                   \
	(((x) & BIT_MASK_TC0DATA_8812F) << BIT_SHIFT_TC0DATA_8812F)
#define BITS_TC0DATA_8812F (BIT_MASK_TC0DATA_8812F << BIT_SHIFT_TC0DATA_8812F)
#define BIT_CLEAR_TC0DATA_8812F(x) ((x) & (~BITS_TC0DATA_8812F))
#define BIT_GET_TC0DATA_8812F(x)                                               \
	(((x) >> BIT_SHIFT_TC0DATA_8812F) & BIT_MASK_TC0DATA_8812F)
#define BIT_SET_TC0DATA_8812F(x, v)                                            \
	(BIT_CLEAR_TC0DATA_8812F(x) | BIT_TC0DATA_8812F(v))

/* 2 REG_TC1_CTRL_8812F */
#define BIT_TC1INT_EN_8812F BIT(26)
#define BIT_TC1MODE_8812F BIT(25)
#define BIT_TC1EN_8812F BIT(24)

#define BIT_SHIFT_TC1DATA_8812F 0
#define BIT_MASK_TC1DATA_8812F 0xffffff
#define BIT_TC1DATA_8812F(x)                                                   \
	(((x) & BIT_MASK_TC1DATA_8812F) << BIT_SHIFT_TC1DATA_8812F)
#define BITS_TC1DATA_8812F (BIT_MASK_TC1DATA_8812F << BIT_SHIFT_TC1DATA_8812F)
#define BIT_CLEAR_TC1DATA_8812F(x) ((x) & (~BITS_TC1DATA_8812F))
#define BIT_GET_TC1DATA_8812F(x)                                               \
	(((x) >> BIT_SHIFT_TC1DATA_8812F) & BIT_MASK_TC1DATA_8812F)
#define BIT_SET_TC1DATA_8812F(x, v)                                            \
	(BIT_CLEAR_TC1DATA_8812F(x) | BIT_TC1DATA_8812F(v))

/* 2 REG_TC2_CTRL_8812F */
#define BIT_TC2INT_EN_8812F BIT(26)
#define BIT_TC2MODE_8812F BIT(25)
#define BIT_TC2EN_8812F BIT(24)

#define BIT_SHIFT_TC2DATA_8812F 0
#define BIT_MASK_TC2DATA_8812F 0xffffff
#define BIT_TC2DATA_8812F(x)                                                   \
	(((x) & BIT_MASK_TC2DATA_8812F) << BIT_SHIFT_TC2DATA_8812F)
#define BITS_TC2DATA_8812F (BIT_MASK_TC2DATA_8812F << BIT_SHIFT_TC2DATA_8812F)
#define BIT_CLEAR_TC2DATA_8812F(x) ((x) & (~BITS_TC2DATA_8812F))
#define BIT_GET_TC2DATA_8812F(x)                                               \
	(((x) >> BIT_SHIFT_TC2DATA_8812F) & BIT_MASK_TC2DATA_8812F)
#define BIT_SET_TC2DATA_8812F(x, v)                                            \
	(BIT_CLEAR_TC2DATA_8812F(x) | BIT_TC2DATA_8812F(v))

/* 2 REG_TC3_CTRL_8812F */
#define BIT_TC3INT_EN_8812F BIT(26)
#define BIT_TC3MODE_8812F BIT(25)
#define BIT_TC3EN_8812F BIT(24)

#define BIT_SHIFT_TC3DATA_8812F 0
#define BIT_MASK_TC3DATA_8812F 0xffffff
#define BIT_TC3DATA_8812F(x)                                                   \
	(((x) & BIT_MASK_TC3DATA_8812F) << BIT_SHIFT_TC3DATA_8812F)
#define BITS_TC3DATA_8812F (BIT_MASK_TC3DATA_8812F << BIT_SHIFT_TC3DATA_8812F)
#define BIT_CLEAR_TC3DATA_8812F(x) ((x) & (~BITS_TC3DATA_8812F))
#define BIT_GET_TC3DATA_8812F(x)                                               \
	(((x) >> BIT_SHIFT_TC3DATA_8812F) & BIT_MASK_TC3DATA_8812F)
#define BIT_SET_TC3DATA_8812F(x, v)                                            \
	(BIT_CLEAR_TC3DATA_8812F(x) | BIT_TC3DATA_8812F(v))

/* 2 REG_TC4_CTRL_8812F */
#define BIT_TC4INT_EN_8812F BIT(26)
#define BIT_TC4MODE_8812F BIT(25)
#define BIT_TC4EN_8812F BIT(24)

#define BIT_SHIFT_TC4DATA_8812F 0
#define BIT_MASK_TC4DATA_8812F 0xffffff
#define BIT_TC4DATA_8812F(x)                                                   \
	(((x) & BIT_MASK_TC4DATA_8812F) << BIT_SHIFT_TC4DATA_8812F)
#define BITS_TC4DATA_8812F (BIT_MASK_TC4DATA_8812F << BIT_SHIFT_TC4DATA_8812F)
#define BIT_CLEAR_TC4DATA_8812F(x) ((x) & (~BITS_TC4DATA_8812F))
#define BIT_GET_TC4DATA_8812F(x)                                               \
	(((x) >> BIT_SHIFT_TC4DATA_8812F) & BIT_MASK_TC4DATA_8812F)
#define BIT_SET_TC4DATA_8812F(x, v)                                            \
	(BIT_CLEAR_TC4DATA_8812F(x) | BIT_TC4DATA_8812F(v))

/* 2 REG_TCUNIT_BASE_8812F */

#define BIT_SHIFT_TCUNIT_BASE_8812F 0
#define BIT_MASK_TCUNIT_BASE_8812F 0x3fff
#define BIT_TCUNIT_BASE_8812F(x)                                               \
	(((x) & BIT_MASK_TCUNIT_BASE_8812F) << BIT_SHIFT_TCUNIT_BASE_8812F)
#define BITS_TCUNIT_BASE_8812F                                                 \
	(BIT_MASK_TCUNIT_BASE_8812F << BIT_SHIFT_TCUNIT_BASE_8812F)
#define BIT_CLEAR_TCUNIT_BASE_8812F(x) ((x) & (~BITS_TCUNIT_BASE_8812F))
#define BIT_GET_TCUNIT_BASE_8812F(x)                                           \
	(((x) >> BIT_SHIFT_TCUNIT_BASE_8812F) & BIT_MASK_TCUNIT_BASE_8812F)
#define BIT_SET_TCUNIT_BASE_8812F(x, v)                                        \
	(BIT_CLEAR_TCUNIT_BASE_8812F(x) | BIT_TCUNIT_BASE_8812F(v))

/* 2 REG_TC5_CTRL_8812F */
#define BIT_TC5INT_EN_8812F BIT(26)
#define BIT_TC5MODE_8812F BIT(25)
#define BIT_TC5EN_8812F BIT(24)

#define BIT_SHIFT_TC5DATA_8812F 0
#define BIT_MASK_TC5DATA_8812F 0xffffff
#define BIT_TC5DATA_8812F(x)                                                   \
	(((x) & BIT_MASK_TC5DATA_8812F) << BIT_SHIFT_TC5DATA_8812F)
#define BITS_TC5DATA_8812F (BIT_MASK_TC5DATA_8812F << BIT_SHIFT_TC5DATA_8812F)
#define BIT_CLEAR_TC5DATA_8812F(x) ((x) & (~BITS_TC5DATA_8812F))
#define BIT_GET_TC5DATA_8812F(x)                                               \
	(((x) >> BIT_SHIFT_TC5DATA_8812F) & BIT_MASK_TC5DATA_8812F)
#define BIT_SET_TC5DATA_8812F(x, v)                                            \
	(BIT_CLEAR_TC5DATA_8812F(x) | BIT_TC5DATA_8812F(v))

/* 2 REG_TC6_CTRL_8812F */
#define BIT_TC6INT_EN_8812F BIT(26)
#define BIT_TC6MODE_8812F BIT(25)
#define BIT_TC6EN_8812F BIT(24)

#define BIT_SHIFT_TC6DATA_8812F 0
#define BIT_MASK_TC6DATA_8812F 0xffffff
#define BIT_TC6DATA_8812F(x)                                                   \
	(((x) & BIT_MASK_TC6DATA_8812F) << BIT_SHIFT_TC6DATA_8812F)
#define BITS_TC6DATA_8812F (BIT_MASK_TC6DATA_8812F << BIT_SHIFT_TC6DATA_8812F)
#define BIT_CLEAR_TC6DATA_8812F(x) ((x) & (~BITS_TC6DATA_8812F))
#define BIT_GET_TC6DATA_8812F(x)                                               \
	(((x) >> BIT_SHIFT_TC6DATA_8812F) & BIT_MASK_TC6DATA_8812F)
#define BIT_SET_TC6DATA_8812F(x, v)                                            \
	(BIT_CLEAR_TC6DATA_8812F(x) | BIT_TC6DATA_8812F(v))

/* 2 REG_MBIST_DRF_FAIL_8812F */

#define BIT_SHIFT_8051_MBIST_DRF_FAIL_8812F 26
#define BIT_MASK_8051_MBIST_DRF_FAIL_8812F 0x3f
#define BIT_8051_MBIST_DRF_FAIL_8812F(x)                                       \
	(((x) & BIT_MASK_8051_MBIST_DRF_FAIL_8812F)                            \
	 << BIT_SHIFT_8051_MBIST_DRF_FAIL_8812F)
#define BITS_8051_MBIST_DRF_FAIL_8812F                                         \
	(BIT_MASK_8051_MBIST_DRF_FAIL_8812F                                    \
	 << BIT_SHIFT_8051_MBIST_DRF_FAIL_8812F)
#define BIT_CLEAR_8051_MBIST_DRF_FAIL_8812F(x)                                 \
	((x) & (~BITS_8051_MBIST_DRF_FAIL_8812F))
#define BIT_GET_8051_MBIST_DRF_FAIL_8812F(x)                                   \
	(((x) >> BIT_SHIFT_8051_MBIST_DRF_FAIL_8812F) &                        \
	 BIT_MASK_8051_MBIST_DRF_FAIL_8812F)
#define BIT_SET_8051_MBIST_DRF_FAIL_8812F(x, v)                                \
	(BIT_CLEAR_8051_MBIST_DRF_FAIL_8812F(x) |                              \
	 BIT_8051_MBIST_DRF_FAIL_8812F(v))

#define BIT_SHIFT_USB_MBIST_DRF_FAIL_8812F 24
#define BIT_MASK_USB_MBIST_DRF_FAIL_8812F 0x3
#define BIT_USB_MBIST_DRF_FAIL_8812F(x)                                        \
	(((x) & BIT_MASK_USB_MBIST_DRF_FAIL_8812F)                             \
	 << BIT_SHIFT_USB_MBIST_DRF_FAIL_8812F)
#define BITS_USB_MBIST_DRF_FAIL_8812F                                          \
	(BIT_MASK_USB_MBIST_DRF_FAIL_8812F                                     \
	 << BIT_SHIFT_USB_MBIST_DRF_FAIL_8812F)
#define BIT_CLEAR_USB_MBIST_DRF_FAIL_8812F(x)                                  \
	((x) & (~BITS_USB_MBIST_DRF_FAIL_8812F))
#define BIT_GET_USB_MBIST_DRF_FAIL_8812F(x)                                    \
	(((x) >> BIT_SHIFT_USB_MBIST_DRF_FAIL_8812F) &                         \
	 BIT_MASK_USB_MBIST_DRF_FAIL_8812F)
#define BIT_SET_USB_MBIST_DRF_FAIL_8812F(x, v)                                 \
	(BIT_CLEAR_USB_MBIST_DRF_FAIL_8812F(x) |                               \
	 BIT_USB_MBIST_DRF_FAIL_8812F(v))

#define BIT_SHIFT_PCIE_MBIST_DRF_FAIL_8812F 18
#define BIT_MASK_PCIE_MBIST_DRF_FAIL_8812F 0x3f
#define BIT_PCIE_MBIST_DRF_FAIL_8812F(x)                                       \
	(((x) & BIT_MASK_PCIE_MBIST_DRF_FAIL_8812F)                            \
	 << BIT_SHIFT_PCIE_MBIST_DRF_FAIL_8812F)
#define BITS_PCIE_MBIST_DRF_FAIL_8812F                                         \
	(BIT_MASK_PCIE_MBIST_DRF_FAIL_8812F                                    \
	 << BIT_SHIFT_PCIE_MBIST_DRF_FAIL_8812F)
#define BIT_CLEAR_PCIE_MBIST_DRF_FAIL_8812F(x)                                 \
	((x) & (~BITS_PCIE_MBIST_DRF_FAIL_8812F))
#define BIT_GET_PCIE_MBIST_DRF_FAIL_8812F(x)                                   \
	(((x) >> BIT_SHIFT_PCIE_MBIST_DRF_FAIL_8812F) &                        \
	 BIT_MASK_PCIE_MBIST_DRF_FAIL_8812F)
#define BIT_SET_PCIE_MBIST_DRF_FAIL_8812F(x, v)                                \
	(BIT_CLEAR_PCIE_MBIST_DRF_FAIL_8812F(x) |                              \
	 BIT_PCIE_MBIST_DRF_FAIL_8812F(v))

#define BIT_SHIFT_MAC_MBIST_DRF_FAIL_8812F 0
#define BIT_MASK_MAC_MBIST_DRF_FAIL_8812F 0x3ffff
#define BIT_MAC_MBIST_DRF_FAIL_8812F(x)                                        \
	(((x) & BIT_MASK_MAC_MBIST_DRF_FAIL_8812F)                             \
	 << BIT_SHIFT_MAC_MBIST_DRF_FAIL_8812F)
#define BITS_MAC_MBIST_DRF_FAIL_8812F                                          \
	(BIT_MASK_MAC_MBIST_DRF_FAIL_8812F                                     \
	 << BIT_SHIFT_MAC_MBIST_DRF_FAIL_8812F)
#define BIT_CLEAR_MAC_MBIST_DRF_FAIL_8812F(x)                                  \
	((x) & (~BITS_MAC_MBIST_DRF_FAIL_8812F))
#define BIT_GET_MAC_MBIST_DRF_FAIL_8812F(x)                                    \
	(((x) >> BIT_SHIFT_MAC_MBIST_DRF_FAIL_8812F) &                         \
	 BIT_MASK_MAC_MBIST_DRF_FAIL_8812F)
#define BIT_SET_MAC_MBIST_DRF_FAIL_8812F(x, v)                                 \
	(BIT_CLEAR_MAC_MBIST_DRF_FAIL_8812F(x) |                               \
	 BIT_MAC_MBIST_DRF_FAIL_8812F(v))

/* 2 REG_MBIST_START_PAUSE_8812F */

#define BIT_SHIFT_8051_MBIST_START_PAUSE_V1_8812F 26
#define BIT_MASK_8051_MBIST_START_PAUSE_V1_8812F 0x3f
#define BIT_8051_MBIST_START_PAUSE_V1_8812F(x)                                 \
	(((x) & BIT_MASK_8051_MBIST_START_PAUSE_V1_8812F)                      \
	 << BIT_SHIFT_8051_MBIST_START_PAUSE_V1_8812F)
#define BITS_8051_MBIST_START_PAUSE_V1_8812F                                   \
	(BIT_MASK_8051_MBIST_START_PAUSE_V1_8812F                              \
	 << BIT_SHIFT_8051_MBIST_START_PAUSE_V1_8812F)
#define BIT_CLEAR_8051_MBIST_START_PAUSE_V1_8812F(x)                           \
	((x) & (~BITS_8051_MBIST_START_PAUSE_V1_8812F))
#define BIT_GET_8051_MBIST_START_PAUSE_V1_8812F(x)                             \
	(((x) >> BIT_SHIFT_8051_MBIST_START_PAUSE_V1_8812F) &                  \
	 BIT_MASK_8051_MBIST_START_PAUSE_V1_8812F)
#define BIT_SET_8051_MBIST_START_PAUSE_V1_8812F(x, v)                          \
	(BIT_CLEAR_8051_MBIST_START_PAUSE_V1_8812F(x) |                        \
	 BIT_8051_MBIST_START_PAUSE_V1_8812F(v))

#define BIT_SHIFT_USB_MBIST_START_PAUSE_V1_8812F 24
#define BIT_MASK_USB_MBIST_START_PAUSE_V1_8812F 0x3
#define BIT_USB_MBIST_START_PAUSE_V1_8812F(x)                                  \
	(((x) & BIT_MASK_USB_MBIST_START_PAUSE_V1_8812F)                       \
	 << BIT_SHIFT_USB_MBIST_START_PAUSE_V1_8812F)
#define BITS_USB_MBIST_START_PAUSE_V1_8812F                                    \
	(BIT_MASK_USB_MBIST_START_PAUSE_V1_8812F                               \
	 << BIT_SHIFT_USB_MBIST_START_PAUSE_V1_8812F)
#define BIT_CLEAR_USB_MBIST_START_PAUSE_V1_8812F(x)                            \
	((x) & (~BITS_USB_MBIST_START_PAUSE_V1_8812F))
#define BIT_GET_USB_MBIST_START_PAUSE_V1_8812F(x)                              \
	(((x) >> BIT_SHIFT_USB_MBIST_START_PAUSE_V1_8812F) &                   \
	 BIT_MASK_USB_MBIST_START_PAUSE_V1_8812F)
#define BIT_SET_USB_MBIST_START_PAUSE_V1_8812F(x, v)                           \
	(BIT_CLEAR_USB_MBIST_START_PAUSE_V1_8812F(x) |                         \
	 BIT_USB_MBIST_START_PAUSE_V1_8812F(v))

#define BIT_SHIFT_PCIE_MBIST_START_PAUSE_V1_8812F 18
#define BIT_MASK_PCIE_MBIST_START_PAUSE_V1_8812F 0x3f
#define BIT_PCIE_MBIST_START_PAUSE_V1_8812F(x)                                 \
	(((x) & BIT_MASK_PCIE_MBIST_START_PAUSE_V1_8812F)                      \
	 << BIT_SHIFT_PCIE_MBIST_START_PAUSE_V1_8812F)
#define BITS_PCIE_MBIST_START_PAUSE_V1_8812F                                   \
	(BIT_MASK_PCIE_MBIST_START_PAUSE_V1_8812F                              \
	 << BIT_SHIFT_PCIE_MBIST_START_PAUSE_V1_8812F)
#define BIT_CLEAR_PCIE_MBIST_START_PAUSE_V1_8812F(x)                           \
	((x) & (~BITS_PCIE_MBIST_START_PAUSE_V1_8812F))
#define BIT_GET_PCIE_MBIST_START_PAUSE_V1_8812F(x)                             \
	(((x) >> BIT_SHIFT_PCIE_MBIST_START_PAUSE_V1_8812F) &                  \
	 BIT_MASK_PCIE_MBIST_START_PAUSE_V1_8812F)
#define BIT_SET_PCIE_MBIST_START_PAUSE_V1_8812F(x, v)                          \
	(BIT_CLEAR_PCIE_MBIST_START_PAUSE_V1_8812F(x) |                        \
	 BIT_PCIE_MBIST_START_PAUSE_V1_8812F(v))

#define BIT_SHIFT_MAC_MBIST_START_PAUSE_V1_8812F 0
#define BIT_MASK_MAC_MBIST_START_PAUSE_V1_8812F 0x3ffff
#define BIT_MAC_MBIST_START_PAUSE_V1_8812F(x)                                  \
	(((x) & BIT_MASK_MAC_MBIST_START_PAUSE_V1_8812F)                       \
	 << BIT_SHIFT_MAC_MBIST_START_PAUSE_V1_8812F)
#define BITS_MAC_MBIST_START_PAUSE_V1_8812F                                    \
	(BIT_MASK_MAC_MBIST_START_PAUSE_V1_8812F                               \
	 << BIT_SHIFT_MAC_MBIST_START_PAUSE_V1_8812F)
#define BIT_CLEAR_MAC_MBIST_START_PAUSE_V1_8812F(x)                            \
	((x) & (~BITS_MAC_MBIST_START_PAUSE_V1_8812F))
#define BIT_GET_MAC_MBIST_START_PAUSE_V1_8812F(x)                              \
	(((x) >> BIT_SHIFT_MAC_MBIST_START_PAUSE_V1_8812F) &                   \
	 BIT_MASK_MAC_MBIST_START_PAUSE_V1_8812F)
#define BIT_SET_MAC_MBIST_START_PAUSE_V1_8812F(x, v)                           \
	(BIT_CLEAR_MAC_MBIST_START_PAUSE_V1_8812F(x) |                         \
	 BIT_MAC_MBIST_START_PAUSE_V1_8812F(v))

/* 2 REG_MBIST_DONE_8812F */

#define BIT_SHIFT_8051_MBIST_DONE_V1_8812F 26
#define BIT_MASK_8051_MBIST_DONE_V1_8812F 0x3f
#define BIT_8051_MBIST_DONE_V1_8812F(x)                                        \
	(((x) & BIT_MASK_8051_MBIST_DONE_V1_8812F)                             \
	 << BIT_SHIFT_8051_MBIST_DONE_V1_8812F)
#define BITS_8051_MBIST_DONE_V1_8812F                                          \
	(BIT_MASK_8051_MBIST_DONE_V1_8812F                                     \
	 << BIT_SHIFT_8051_MBIST_DONE_V1_8812F)
#define BIT_CLEAR_8051_MBIST_DONE_V1_8812F(x)                                  \
	((x) & (~BITS_8051_MBIST_DONE_V1_8812F))
#define BIT_GET_8051_MBIST_DONE_V1_8812F(x)                                    \
	(((x) >> BIT_SHIFT_8051_MBIST_DONE_V1_8812F) &                         \
	 BIT_MASK_8051_MBIST_DONE_V1_8812F)
#define BIT_SET_8051_MBIST_DONE_V1_8812F(x, v)                                 \
	(BIT_CLEAR_8051_MBIST_DONE_V1_8812F(x) |                               \
	 BIT_8051_MBIST_DONE_V1_8812F(v))

#define BIT_SHIFT_USB_MBIST_DONE_V1_8812F 24
#define BIT_MASK_USB_MBIST_DONE_V1_8812F 0x3
#define BIT_USB_MBIST_DONE_V1_8812F(x)                                         \
	(((x) & BIT_MASK_USB_MBIST_DONE_V1_8812F)                              \
	 << BIT_SHIFT_USB_MBIST_DONE_V1_8812F)
#define BITS_USB_MBIST_DONE_V1_8812F                                           \
	(BIT_MASK_USB_MBIST_DONE_V1_8812F << BIT_SHIFT_USB_MBIST_DONE_V1_8812F)
#define BIT_CLEAR_USB_MBIST_DONE_V1_8812F(x)                                   \
	((x) & (~BITS_USB_MBIST_DONE_V1_8812F))
#define BIT_GET_USB_MBIST_DONE_V1_8812F(x)                                     \
	(((x) >> BIT_SHIFT_USB_MBIST_DONE_V1_8812F) &                          \
	 BIT_MASK_USB_MBIST_DONE_V1_8812F)
#define BIT_SET_USB_MBIST_DONE_V1_8812F(x, v)                                  \
	(BIT_CLEAR_USB_MBIST_DONE_V1_8812F(x) | BIT_USB_MBIST_DONE_V1_8812F(v))

#define BIT_SHIFT_PCIE_MBIST_DONE_V1_8812F 18
#define BIT_MASK_PCIE_MBIST_DONE_V1_8812F 0x3f
#define BIT_PCIE_MBIST_DONE_V1_8812F(x)                                        \
	(((x) & BIT_MASK_PCIE_MBIST_DONE_V1_8812F)                             \
	 << BIT_SHIFT_PCIE_MBIST_DONE_V1_8812F)
#define BITS_PCIE_MBIST_DONE_V1_8812F                                          \
	(BIT_MASK_PCIE_MBIST_DONE_V1_8812F                                     \
	 << BIT_SHIFT_PCIE_MBIST_DONE_V1_8812F)
#define BIT_CLEAR_PCIE_MBIST_DONE_V1_8812F(x)                                  \
	((x) & (~BITS_PCIE_MBIST_DONE_V1_8812F))
#define BIT_GET_PCIE_MBIST_DONE_V1_8812F(x)                                    \
	(((x) >> BIT_SHIFT_PCIE_MBIST_DONE_V1_8812F) &                         \
	 BIT_MASK_PCIE_MBIST_DONE_V1_8812F)
#define BIT_SET_PCIE_MBIST_DONE_V1_8812F(x, v)                                 \
	(BIT_CLEAR_PCIE_MBIST_DONE_V1_8812F(x) |                               \
	 BIT_PCIE_MBIST_DONE_V1_8812F(v))

#define BIT_SHIFT_MAC_MBIST_DONE_V1_8812F 0
#define BIT_MASK_MAC_MBIST_DONE_V1_8812F 0x3ffff
#define BIT_MAC_MBIST_DONE_V1_8812F(x)                                         \
	(((x) & BIT_MASK_MAC_MBIST_DONE_V1_8812F)                              \
	 << BIT_SHIFT_MAC_MBIST_DONE_V1_8812F)
#define BITS_MAC_MBIST_DONE_V1_8812F                                           \
	(BIT_MASK_MAC_MBIST_DONE_V1_8812F << BIT_SHIFT_MAC_MBIST_DONE_V1_8812F)
#define BIT_CLEAR_MAC_MBIST_DONE_V1_8812F(x)                                   \
	((x) & (~BITS_MAC_MBIST_DONE_V1_8812F))
#define BIT_GET_MAC_MBIST_DONE_V1_8812F(x)                                     \
	(((x) >> BIT_SHIFT_MAC_MBIST_DONE_V1_8812F) &                          \
	 BIT_MASK_MAC_MBIST_DONE_V1_8812F)
#define BIT_SET_MAC_MBIST_DONE_V1_8812F(x, v)                                  \
	(BIT_CLEAR_MAC_MBIST_DONE_V1_8812F(x) | BIT_MAC_MBIST_DONE_V1_8812F(v))

/* 2 REG_MBIST_READ_BIST_RPT_8812F */

#define BIT_SHIFT_MBIST_READ_BIST_RPT_8812F 0
#define BIT_MASK_MBIST_READ_BIST_RPT_8812F 0xffffffffL
#define BIT_MBIST_READ_BIST_RPT_8812F(x)                                       \
	(((x) & BIT_MASK_MBIST_READ_BIST_RPT_8812F)                            \
	 << BIT_SHIFT_MBIST_READ_BIST_RPT_8812F)
#define BITS_MBIST_READ_BIST_RPT_8812F                                         \
	(BIT_MASK_MBIST_READ_BIST_RPT_8812F                                    \
	 << BIT_SHIFT_MBIST_READ_BIST_RPT_8812F)
#define BIT_CLEAR_MBIST_READ_BIST_RPT_8812F(x)                                 \
	((x) & (~BITS_MBIST_READ_BIST_RPT_8812F))
#define BIT_GET_MBIST_READ_BIST_RPT_8812F(x)                                   \
	(((x) >> BIT_SHIFT_MBIST_READ_BIST_RPT_8812F) &                        \
	 BIT_MASK_MBIST_READ_BIST_RPT_8812F)
#define BIT_SET_MBIST_READ_BIST_RPT_8812F(x, v)                                \
	(BIT_CLEAR_MBIST_READ_BIST_RPT_8812F(x) |                              \
	 BIT_MBIST_READ_BIST_RPT_8812F(v))

/* 2 REG_AES_DECRPT_DATA_8812F */

#define BIT_SHIFT_IPS_CFG_ADDR_8812F 0
#define BIT_MASK_IPS_CFG_ADDR_8812F 0xff
#define BIT_IPS_CFG_ADDR_8812F(x)                                              \
	(((x) & BIT_MASK_IPS_CFG_ADDR_8812F) << BIT_SHIFT_IPS_CFG_ADDR_8812F)
#define BITS_IPS_CFG_ADDR_8812F                                                \
	(BIT_MASK_IPS_CFG_ADDR_8812F << BIT_SHIFT_IPS_CFG_ADDR_8812F)
#define BIT_CLEAR_IPS_CFG_ADDR_8812F(x) ((x) & (~BITS_IPS_CFG_ADDR_8812F))
#define BIT_GET_IPS_CFG_ADDR_8812F(x)                                          \
	(((x) >> BIT_SHIFT_IPS_CFG_ADDR_8812F) & BIT_MASK_IPS_CFG_ADDR_8812F)
#define BIT_SET_IPS_CFG_ADDR_8812F(x, v)                                       \
	(BIT_CLEAR_IPS_CFG_ADDR_8812F(x) | BIT_IPS_CFG_ADDR_8812F(v))

/* 2 REG_AES_DECRPT_CFG_8812F */

#define BIT_SHIFT_IPS_CFG_DATA_8812F 0
#define BIT_MASK_IPS_CFG_DATA_8812F 0xffffffffL
#define BIT_IPS_CFG_DATA_8812F(x)                                              \
	(((x) & BIT_MASK_IPS_CFG_DATA_8812F) << BIT_SHIFT_IPS_CFG_DATA_8812F)
#define BITS_IPS_CFG_DATA_8812F                                                \
	(BIT_MASK_IPS_CFG_DATA_8812F << BIT_SHIFT_IPS_CFG_DATA_8812F)
#define BIT_CLEAR_IPS_CFG_DATA_8812F(x) ((x) & (~BITS_IPS_CFG_DATA_8812F))
#define BIT_GET_IPS_CFG_DATA_8812F(x)                                          \
	(((x) >> BIT_SHIFT_IPS_CFG_DATA_8812F) & BIT_MASK_IPS_CFG_DATA_8812F)
#define BIT_SET_IPS_CFG_DATA_8812F(x, v)                                       \
	(BIT_CLEAR_IPS_CFG_DATA_8812F(x) | BIT_IPS_CFG_DATA_8812F(v))

/* 2 REG_HIOE_CTRL_8812F */
#define BIT_HIOE_CFG_FILE_LOC_SEL_8812F BIT(31)
#define BIT_HIOE_WRITE_REQ_8812F BIT(30)
#define BIT_HIOE_READ_REQ_8812F BIT(29)
#define BIT_INST_FORMAT_ERR_8812F BIT(25)
#define BIT_OP_TIMEOUT_ERR_8812F BIT(24)

#define BIT_SHIFT_HIOE_OP_TIMEOUT_8812F 16
#define BIT_MASK_HIOE_OP_TIMEOUT_8812F 0xff
#define BIT_HIOE_OP_TIMEOUT_8812F(x)                                           \
	(((x) & BIT_MASK_HIOE_OP_TIMEOUT_8812F)                                \
	 << BIT_SHIFT_HIOE_OP_TIMEOUT_8812F)
#define BITS_HIOE_OP_TIMEOUT_8812F                                             \
	(BIT_MASK_HIOE_OP_TIMEOUT_8812F << BIT_SHIFT_HIOE_OP_TIMEOUT_8812F)
#define BIT_CLEAR_HIOE_OP_TIMEOUT_8812F(x) ((x) & (~BITS_HIOE_OP_TIMEOUT_8812F))
#define BIT_GET_HIOE_OP_TIMEOUT_8812F(x)                                       \
	(((x) >> BIT_SHIFT_HIOE_OP_TIMEOUT_8812F) &                            \
	 BIT_MASK_HIOE_OP_TIMEOUT_8812F)
#define BIT_SET_HIOE_OP_TIMEOUT_8812F(x, v)                                    \
	(BIT_CLEAR_HIOE_OP_TIMEOUT_8812F(x) | BIT_HIOE_OP_TIMEOUT_8812F(v))

#define BIT_SHIFT_BITDATA_CHECKSUM_8812F 0
#define BIT_MASK_BITDATA_CHECKSUM_8812F 0xffff
#define BIT_BITDATA_CHECKSUM_8812F(x)                                          \
	(((x) & BIT_MASK_BITDATA_CHECKSUM_8812F)                               \
	 << BIT_SHIFT_BITDATA_CHECKSUM_8812F)
#define BITS_BITDATA_CHECKSUM_8812F                                            \
	(BIT_MASK_BITDATA_CHECKSUM_8812F << BIT_SHIFT_BITDATA_CHECKSUM_8812F)
#define BIT_CLEAR_BITDATA_CHECKSUM_8812F(x)                                    \
	((x) & (~BITS_BITDATA_CHECKSUM_8812F))
#define BIT_GET_BITDATA_CHECKSUM_8812F(x)                                      \
	(((x) >> BIT_SHIFT_BITDATA_CHECKSUM_8812F) &                           \
	 BIT_MASK_BITDATA_CHECKSUM_8812F)
#define BIT_SET_BITDATA_CHECKSUM_8812F(x, v)                                   \
	(BIT_CLEAR_BITDATA_CHECKSUM_8812F(x) | BIT_BITDATA_CHECKSUM_8812F(v))

/* 2 REG_HIOE_CFG_FILE_8812F */

#define BIT_SHIFT_TXBF_END_ADDR_8812F 16
#define BIT_MASK_TXBF_END_ADDR_8812F 0xffff
#define BIT_TXBF_END_ADDR_8812F(x)                                             \
	(((x) & BIT_MASK_TXBF_END_ADDR_8812F) << BIT_SHIFT_TXBF_END_ADDR_8812F)
#define BITS_TXBF_END_ADDR_8812F                                               \
	(BIT_MASK_TXBF_END_ADDR_8812F << BIT_SHIFT_TXBF_END_ADDR_8812F)
#define BIT_CLEAR_TXBF_END_ADDR_8812F(x) ((x) & (~BITS_TXBF_END_ADDR_8812F))
#define BIT_GET_TXBF_END_ADDR_8812F(x)                                         \
	(((x) >> BIT_SHIFT_TXBF_END_ADDR_8812F) & BIT_MASK_TXBF_END_ADDR_8812F)
#define BIT_SET_TXBF_END_ADDR_8812F(x, v)                                      \
	(BIT_CLEAR_TXBF_END_ADDR_8812F(x) | BIT_TXBF_END_ADDR_8812F(v))

#define BIT_SHIFT_TXBF_STR_ADDR_8812F 0
#define BIT_MASK_TXBF_STR_ADDR_8812F 0xffff
#define BIT_TXBF_STR_ADDR_8812F(x)                                             \
	(((x) & BIT_MASK_TXBF_STR_ADDR_8812F) << BIT_SHIFT_TXBF_STR_ADDR_8812F)
#define BITS_TXBF_STR_ADDR_8812F                                               \
	(BIT_MASK_TXBF_STR_ADDR_8812F << BIT_SHIFT_TXBF_STR_ADDR_8812F)
#define BIT_CLEAR_TXBF_STR_ADDR_8812F(x) ((x) & (~BITS_TXBF_STR_ADDR_8812F))
#define BIT_GET_TXBF_STR_ADDR_8812F(x)                                         \
	(((x) >> BIT_SHIFT_TXBF_STR_ADDR_8812F) & BIT_MASK_TXBF_STR_ADDR_8812F)
#define BIT_SET_TXBF_STR_ADDR_8812F(x, v)                                      \
	(BIT_CLEAR_TXBF_STR_ADDR_8812F(x) | BIT_TXBF_STR_ADDR_8812F(v))

/* 2 REG_TMETER_8812F */
#define BIT_TEMP_VALID_8812F BIT(31)

#define BIT_SHIFT_TEMP_VALUE_8812F 24
#define BIT_MASK_TEMP_VALUE_8812F 0x3f
#define BIT_TEMP_VALUE_8812F(x)                                                \
	(((x) & BIT_MASK_TEMP_VALUE_8812F) << BIT_SHIFT_TEMP_VALUE_8812F)
#define BITS_TEMP_VALUE_8812F                                                  \
	(BIT_MASK_TEMP_VALUE_8812F << BIT_SHIFT_TEMP_VALUE_8812F)
#define BIT_CLEAR_TEMP_VALUE_8812F(x) ((x) & (~BITS_TEMP_VALUE_8812F))
#define BIT_GET_TEMP_VALUE_8812F(x)                                            \
	(((x) >> BIT_SHIFT_TEMP_VALUE_8812F) & BIT_MASK_TEMP_VALUE_8812F)
#define BIT_SET_TEMP_VALUE_8812F(x, v)                                         \
	(BIT_CLEAR_TEMP_VALUE_8812F(x) | BIT_TEMP_VALUE_8812F(v))

#define BIT_SHIFT_REG_TMETER_TIMER_8812F 8
#define BIT_MASK_REG_TMETER_TIMER_8812F 0xfff
#define BIT_REG_TMETER_TIMER_8812F(x)                                          \
	(((x) & BIT_MASK_REG_TMETER_TIMER_8812F)                               \
	 << BIT_SHIFT_REG_TMETER_TIMER_8812F)
#define BITS_REG_TMETER_TIMER_8812F                                            \
	(BIT_MASK_REG_TMETER_TIMER_8812F << BIT_SHIFT_REG_TMETER_TIMER_8812F)
#define BIT_CLEAR_REG_TMETER_TIMER_8812F(x)                                    \
	((x) & (~BITS_REG_TMETER_TIMER_8812F))
#define BIT_GET_REG_TMETER_TIMER_8812F(x)                                      \
	(((x) >> BIT_SHIFT_REG_TMETER_TIMER_8812F) &                           \
	 BIT_MASK_REG_TMETER_TIMER_8812F)
#define BIT_SET_REG_TMETER_TIMER_8812F(x, v)                                   \
	(BIT_CLEAR_REG_TMETER_TIMER_8812F(x) | BIT_REG_TMETER_TIMER_8812F(v))

#define BIT_SHIFT_REG_TEMP_DELTA_8812F 2
#define BIT_MASK_REG_TEMP_DELTA_8812F 0x3f
#define BIT_REG_TEMP_DELTA_8812F(x)                                            \
	(((x) & BIT_MASK_REG_TEMP_DELTA_8812F)                                 \
	 << BIT_SHIFT_REG_TEMP_DELTA_8812F)
#define BITS_REG_TEMP_DELTA_8812F                                              \
	(BIT_MASK_REG_TEMP_DELTA_8812F << BIT_SHIFT_REG_TEMP_DELTA_8812F)
#define BIT_CLEAR_REG_TEMP_DELTA_8812F(x) ((x) & (~BITS_REG_TEMP_DELTA_8812F))
#define BIT_GET_REG_TEMP_DELTA_8812F(x)                                        \
	(((x) >> BIT_SHIFT_REG_TEMP_DELTA_8812F) &                             \
	 BIT_MASK_REG_TEMP_DELTA_8812F)
#define BIT_SET_REG_TEMP_DELTA_8812F(x, v)                                     \
	(BIT_CLEAR_REG_TEMP_DELTA_8812F(x) | BIT_REG_TEMP_DELTA_8812F(v))

#define BIT_REG_TMETER_EN_8812F BIT(0)

/* 2 REG_OSC_32K_CTRL_8812F */

#define BIT_SHIFT_OSC_32K_CLKGEN_0_8812F 16
#define BIT_MASK_OSC_32K_CLKGEN_0_8812F 0xffff
#define BIT_OSC_32K_CLKGEN_0_8812F(x)                                          \
	(((x) & BIT_MASK_OSC_32K_CLKGEN_0_8812F)                               \
	 << BIT_SHIFT_OSC_32K_CLKGEN_0_8812F)
#define BITS_OSC_32K_CLKGEN_0_8812F                                            \
	(BIT_MASK_OSC_32K_CLKGEN_0_8812F << BIT_SHIFT_OSC_32K_CLKGEN_0_8812F)
#define BIT_CLEAR_OSC_32K_CLKGEN_0_8812F(x)                                    \
	((x) & (~BITS_OSC_32K_CLKGEN_0_8812F))
#define BIT_GET_OSC_32K_CLKGEN_0_8812F(x)                                      \
	(((x) >> BIT_SHIFT_OSC_32K_CLKGEN_0_8812F) &                           \
	 BIT_MASK_OSC_32K_CLKGEN_0_8812F)
#define BIT_SET_OSC_32K_CLKGEN_0_8812F(x, v)                                   \
	(BIT_CLEAR_OSC_32K_CLKGEN_0_8812F(x) | BIT_OSC_32K_CLKGEN_0_8812F(v))

#define BIT_SHIFT_OSC_32K_RES_COMP_8812F 4
#define BIT_MASK_OSC_32K_RES_COMP_8812F 0x3
#define BIT_OSC_32K_RES_COMP_8812F(x)                                          \
	(((x) & BIT_MASK_OSC_32K_RES_COMP_8812F)                               \
	 << BIT_SHIFT_OSC_32K_RES_COMP_8812F)
#define BITS_OSC_32K_RES_COMP_8812F                                            \
	(BIT_MASK_OSC_32K_RES_COMP_8812F << BIT_SHIFT_OSC_32K_RES_COMP_8812F)
#define BIT_CLEAR_OSC_32K_RES_COMP_8812F(x)                                    \
	((x) & (~BITS_OSC_32K_RES_COMP_8812F))
#define BIT_GET_OSC_32K_RES_COMP_8812F(x)                                      \
	(((x) >> BIT_SHIFT_OSC_32K_RES_COMP_8812F) &                           \
	 BIT_MASK_OSC_32K_RES_COMP_8812F)
#define BIT_SET_OSC_32K_RES_COMP_8812F(x, v)                                   \
	(BIT_CLEAR_OSC_32K_RES_COMP_8812F(x) | BIT_OSC_32K_RES_COMP_8812F(v))

#define BIT_OSC_32K_OUT_SEL_8812F BIT(3)
#define BIT_ISO_WL_2_OSC_32K_8812F BIT(1)
#define BIT_POW_CKGEN_8812F BIT(0)

/* 2 REG_32K_CAL_REG1_8812F */
#define BIT_CAL_32K_REG_WR_8812F BIT(31)
#define BIT_CAL_32K_DBG_SEL_8812F BIT(22)

#define BIT_SHIFT_CAL_32K_REG_ADDR_8812F 16
#define BIT_MASK_CAL_32K_REG_ADDR_8812F 0x3f
#define BIT_CAL_32K_REG_ADDR_8812F(x)                                          \
	(((x) & BIT_MASK_CAL_32K_REG_ADDR_8812F)                               \
	 << BIT_SHIFT_CAL_32K_REG_ADDR_8812F)
#define BITS_CAL_32K_REG_ADDR_8812F                                            \
	(BIT_MASK_CAL_32K_REG_ADDR_8812F << BIT_SHIFT_CAL_32K_REG_ADDR_8812F)
#define BIT_CLEAR_CAL_32K_REG_ADDR_8812F(x)                                    \
	((x) & (~BITS_CAL_32K_REG_ADDR_8812F))
#define BIT_GET_CAL_32K_REG_ADDR_8812F(x)                                      \
	(((x) >> BIT_SHIFT_CAL_32K_REG_ADDR_8812F) &                           \
	 BIT_MASK_CAL_32K_REG_ADDR_8812F)
#define BIT_SET_CAL_32K_REG_ADDR_8812F(x, v)                                   \
	(BIT_CLEAR_CAL_32K_REG_ADDR_8812F(x) | BIT_CAL_32K_REG_ADDR_8812F(v))

#define BIT_SHIFT_CAL_32K_REG_DATA_8812F 0
#define BIT_MASK_CAL_32K_REG_DATA_8812F 0xffff
#define BIT_CAL_32K_REG_DATA_8812F(x)                                          \
	(((x) & BIT_MASK_CAL_32K_REG_DATA_8812F)                               \
	 << BIT_SHIFT_CAL_32K_REG_DATA_8812F)
#define BITS_CAL_32K_REG_DATA_8812F                                            \
	(BIT_MASK_CAL_32K_REG_DATA_8812F << BIT_SHIFT_CAL_32K_REG_DATA_8812F)
#define BIT_CLEAR_CAL_32K_REG_DATA_8812F(x)                                    \
	((x) & (~BITS_CAL_32K_REG_DATA_8812F))
#define BIT_GET_CAL_32K_REG_DATA_8812F(x)                                      \
	(((x) >> BIT_SHIFT_CAL_32K_REG_DATA_8812F) &                           \
	 BIT_MASK_CAL_32K_REG_DATA_8812F)
#define BIT_SET_CAL_32K_REG_DATA_8812F(x, v)                                   \
	(BIT_CLEAR_CAL_32K_REG_DATA_8812F(x) | BIT_CAL_32K_REG_DATA_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_C2HEVT_8812F */

#define BIT_SHIFT_C2HEVT_MSG_V1_8812F 0
#define BIT_MASK_C2HEVT_MSG_V1_8812F 0xffffffffL
#define BIT_C2HEVT_MSG_V1_8812F(x)                                             \
	(((x) & BIT_MASK_C2HEVT_MSG_V1_8812F) << BIT_SHIFT_C2HEVT_MSG_V1_8812F)
#define BITS_C2HEVT_MSG_V1_8812F                                               \
	(BIT_MASK_C2HEVT_MSG_V1_8812F << BIT_SHIFT_C2HEVT_MSG_V1_8812F)
#define BIT_CLEAR_C2HEVT_MSG_V1_8812F(x) ((x) & (~BITS_C2HEVT_MSG_V1_8812F))
#define BIT_GET_C2HEVT_MSG_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_C2HEVT_MSG_V1_8812F) & BIT_MASK_C2HEVT_MSG_V1_8812F)
#define BIT_SET_C2HEVT_MSG_V1_8812F(x, v)                                      \
	(BIT_CLEAR_C2HEVT_MSG_V1_8812F(x) | BIT_C2HEVT_MSG_V1_8812F(v))

/* 2 REG_C2HEVT_1_8812F */

#define BIT_SHIFT_C2HEVT_MSG_1_8812F 0
#define BIT_MASK_C2HEVT_MSG_1_8812F 0xffffffffL
#define BIT_C2HEVT_MSG_1_8812F(x)                                              \
	(((x) & BIT_MASK_C2HEVT_MSG_1_8812F) << BIT_SHIFT_C2HEVT_MSG_1_8812F)
#define BITS_C2HEVT_MSG_1_8812F                                                \
	(BIT_MASK_C2HEVT_MSG_1_8812F << BIT_SHIFT_C2HEVT_MSG_1_8812F)
#define BIT_CLEAR_C2HEVT_MSG_1_8812F(x) ((x) & (~BITS_C2HEVT_MSG_1_8812F))
#define BIT_GET_C2HEVT_MSG_1_8812F(x)                                          \
	(((x) >> BIT_SHIFT_C2HEVT_MSG_1_8812F) & BIT_MASK_C2HEVT_MSG_1_8812F)
#define BIT_SET_C2HEVT_MSG_1_8812F(x, v)                                       \
	(BIT_CLEAR_C2HEVT_MSG_1_8812F(x) | BIT_C2HEVT_MSG_1_8812F(v))

/* 2 REG_C2HEVT_2_8812F */

#define BIT_SHIFT_C2HEVT_MSG_2_8812F 0
#define BIT_MASK_C2HEVT_MSG_2_8812F 0xffffffffL
#define BIT_C2HEVT_MSG_2_8812F(x)                                              \
	(((x) & BIT_MASK_C2HEVT_MSG_2_8812F) << BIT_SHIFT_C2HEVT_MSG_2_8812F)
#define BITS_C2HEVT_MSG_2_8812F                                                \
	(BIT_MASK_C2HEVT_MSG_2_8812F << BIT_SHIFT_C2HEVT_MSG_2_8812F)
#define BIT_CLEAR_C2HEVT_MSG_2_8812F(x) ((x) & (~BITS_C2HEVT_MSG_2_8812F))
#define BIT_GET_C2HEVT_MSG_2_8812F(x)                                          \
	(((x) >> BIT_SHIFT_C2HEVT_MSG_2_8812F) & BIT_MASK_C2HEVT_MSG_2_8812F)
#define BIT_SET_C2HEVT_MSG_2_8812F(x, v)                                       \
	(BIT_CLEAR_C2HEVT_MSG_2_8812F(x) | BIT_C2HEVT_MSG_2_8812F(v))

/* 2 REG_C2HEVT_3_8812F */

#define BIT_SHIFT_C2HEVT_MSG_3_8812F 0
#define BIT_MASK_C2HEVT_MSG_3_8812F 0xffffffffL
#define BIT_C2HEVT_MSG_3_8812F(x)                                              \
	(((x) & BIT_MASK_C2HEVT_MSG_3_8812F) << BIT_SHIFT_C2HEVT_MSG_3_8812F)
#define BITS_C2HEVT_MSG_3_8812F                                                \
	(BIT_MASK_C2HEVT_MSG_3_8812F << BIT_SHIFT_C2HEVT_MSG_3_8812F)
#define BIT_CLEAR_C2HEVT_MSG_3_8812F(x) ((x) & (~BITS_C2HEVT_MSG_3_8812F))
#define BIT_GET_C2HEVT_MSG_3_8812F(x)                                          \
	(((x) >> BIT_SHIFT_C2HEVT_MSG_3_8812F) & BIT_MASK_C2HEVT_MSG_3_8812F)
#define BIT_SET_C2HEVT_MSG_3_8812F(x, v)                                       \
	(BIT_CLEAR_C2HEVT_MSG_3_8812F(x) | BIT_C2HEVT_MSG_3_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_SW_DEFINED_PAGE1_8812F */

#define BIT_SHIFT_SW_DEFINED_PAGE1_V1_8812F 0
#define BIT_MASK_SW_DEFINED_PAGE1_V1_8812F 0xffffffffL
#define BIT_SW_DEFINED_PAGE1_V1_8812F(x)                                       \
	(((x) & BIT_MASK_SW_DEFINED_PAGE1_V1_8812F)                            \
	 << BIT_SHIFT_SW_DEFINED_PAGE1_V1_8812F)
#define BITS_SW_DEFINED_PAGE1_V1_8812F                                         \
	(BIT_MASK_SW_DEFINED_PAGE1_V1_8812F                                    \
	 << BIT_SHIFT_SW_DEFINED_PAGE1_V1_8812F)
#define BIT_CLEAR_SW_DEFINED_PAGE1_V1_8812F(x)                                 \
	((x) & (~BITS_SW_DEFINED_PAGE1_V1_8812F))
#define BIT_GET_SW_DEFINED_PAGE1_V1_8812F(x)                                   \
	(((x) >> BIT_SHIFT_SW_DEFINED_PAGE1_V1_8812F) &                        \
	 BIT_MASK_SW_DEFINED_PAGE1_V1_8812F)
#define BIT_SET_SW_DEFINED_PAGE1_V1_8812F(x, v)                                \
	(BIT_CLEAR_SW_DEFINED_PAGE1_V1_8812F(x) |                              \
	 BIT_SW_DEFINED_PAGE1_V1_8812F(v))

/* 2 REG_SW_DEFINED_PAGE2_8812F */

#define BIT_SHIFT_SW_DEFINED_PAGE2_8812F 0
#define BIT_MASK_SW_DEFINED_PAGE2_8812F 0xffffffffL
#define BIT_SW_DEFINED_PAGE2_8812F(x)                                          \
	(((x) & BIT_MASK_SW_DEFINED_PAGE2_8812F)                               \
	 << BIT_SHIFT_SW_DEFINED_PAGE2_8812F)
#define BITS_SW_DEFINED_PAGE2_8812F                                            \
	(BIT_MASK_SW_DEFINED_PAGE2_8812F << BIT_SHIFT_SW_DEFINED_PAGE2_8812F)
#define BIT_CLEAR_SW_DEFINED_PAGE2_8812F(x)                                    \
	((x) & (~BITS_SW_DEFINED_PAGE2_8812F))
#define BIT_GET_SW_DEFINED_PAGE2_8812F(x)                                      \
	(((x) >> BIT_SHIFT_SW_DEFINED_PAGE2_8812F) &                           \
	 BIT_MASK_SW_DEFINED_PAGE2_8812F)
#define BIT_SET_SW_DEFINED_PAGE2_8812F(x, v)                                   \
	(BIT_CLEAR_SW_DEFINED_PAGE2_8812F(x) | BIT_SW_DEFINED_PAGE2_8812F(v))

/* 2 REG_MCUTST_I_8812F */

#define BIT_SHIFT_MCUDMSG_I_8812F 0
#define BIT_MASK_MCUDMSG_I_8812F 0xffffffffL
#define BIT_MCUDMSG_I_8812F(x)                                                 \
	(((x) & BIT_MASK_MCUDMSG_I_8812F) << BIT_SHIFT_MCUDMSG_I_8812F)
#define BITS_MCUDMSG_I_8812F                                                   \
	(BIT_MASK_MCUDMSG_I_8812F << BIT_SHIFT_MCUDMSG_I_8812F)
#define BIT_CLEAR_MCUDMSG_I_8812F(x) ((x) & (~BITS_MCUDMSG_I_8812F))
#define BIT_GET_MCUDMSG_I_8812F(x)                                             \
	(((x) >> BIT_SHIFT_MCUDMSG_I_8812F) & BIT_MASK_MCUDMSG_I_8812F)
#define BIT_SET_MCUDMSG_I_8812F(x, v)                                          \
	(BIT_CLEAR_MCUDMSG_I_8812F(x) | BIT_MCUDMSG_I_8812F(v))

/* 2 REG_MCUTST_II_8812F */

#define BIT_SHIFT_MCUDMSG_II_8812F 0
#define BIT_MASK_MCUDMSG_II_8812F 0xffffffffL
#define BIT_MCUDMSG_II_8812F(x)                                                \
	(((x) & BIT_MASK_MCUDMSG_II_8812F) << BIT_SHIFT_MCUDMSG_II_8812F)
#define BITS_MCUDMSG_II_8812F                                                  \
	(BIT_MASK_MCUDMSG_II_8812F << BIT_SHIFT_MCUDMSG_II_8812F)
#define BIT_CLEAR_MCUDMSG_II_8812F(x) ((x) & (~BITS_MCUDMSG_II_8812F))
#define BIT_GET_MCUDMSG_II_8812F(x)                                            \
	(((x) >> BIT_SHIFT_MCUDMSG_II_8812F) & BIT_MASK_MCUDMSG_II_8812F)
#define BIT_SET_MCUDMSG_II_8812F(x, v)                                         \
	(BIT_CLEAR_MCUDMSG_II_8812F(x) | BIT_MCUDMSG_II_8812F(v))

/* 2 REG_FMETHR_8812F */
#define BIT_FMSG_INT_8812F BIT(31)

#define BIT_SHIFT_FW_MSG_8812F 0
#define BIT_MASK_FW_MSG_8812F 0xffffffffL
#define BIT_FW_MSG_8812F(x)                                                    \
	(((x) & BIT_MASK_FW_MSG_8812F) << BIT_SHIFT_FW_MSG_8812F)
#define BITS_FW_MSG_8812F (BIT_MASK_FW_MSG_8812F << BIT_SHIFT_FW_MSG_8812F)
#define BIT_CLEAR_FW_MSG_8812F(x) ((x) & (~BITS_FW_MSG_8812F))
#define BIT_GET_FW_MSG_8812F(x)                                                \
	(((x) >> BIT_SHIFT_FW_MSG_8812F) & BIT_MASK_FW_MSG_8812F)
#define BIT_SET_FW_MSG_8812F(x, v)                                             \
	(BIT_CLEAR_FW_MSG_8812F(x) | BIT_FW_MSG_8812F(v))

/* 2 REG_HMETFR_8812F */

#define BIT_SHIFT_HRCV_MSG_8812F 24
#define BIT_MASK_HRCV_MSG_8812F 0xff
#define BIT_HRCV_MSG_8812F(x)                                                  \
	(((x) & BIT_MASK_HRCV_MSG_8812F) << BIT_SHIFT_HRCV_MSG_8812F)
#define BITS_HRCV_MSG_8812F                                                    \
	(BIT_MASK_HRCV_MSG_8812F << BIT_SHIFT_HRCV_MSG_8812F)
#define BIT_CLEAR_HRCV_MSG_8812F(x) ((x) & (~BITS_HRCV_MSG_8812F))
#define BIT_GET_HRCV_MSG_8812F(x)                                              \
	(((x) >> BIT_SHIFT_HRCV_MSG_8812F) & BIT_MASK_HRCV_MSG_8812F)
#define BIT_SET_HRCV_MSG_8812F(x, v)                                           \
	(BIT_CLEAR_HRCV_MSG_8812F(x) | BIT_HRCV_MSG_8812F(v))

#define BIT_INT_BOX3_8812F BIT(3)
#define BIT_INT_BOX2_8812F BIT(2)
#define BIT_INT_BOX1_8812F BIT(1)
#define BIT_INT_BOX0_8812F BIT(0)

/* 2 REG_HMEBOX0_8812F */

#define BIT_SHIFT_HOST_MSG_0_8812F 0
#define BIT_MASK_HOST_MSG_0_8812F 0xffffffffL
#define BIT_HOST_MSG_0_8812F(x)                                                \
	(((x) & BIT_MASK_HOST_MSG_0_8812F) << BIT_SHIFT_HOST_MSG_0_8812F)
#define BITS_HOST_MSG_0_8812F                                                  \
	(BIT_MASK_HOST_MSG_0_8812F << BIT_SHIFT_HOST_MSG_0_8812F)
#define BIT_CLEAR_HOST_MSG_0_8812F(x) ((x) & (~BITS_HOST_MSG_0_8812F))
#define BIT_GET_HOST_MSG_0_8812F(x)                                            \
	(((x) >> BIT_SHIFT_HOST_MSG_0_8812F) & BIT_MASK_HOST_MSG_0_8812F)
#define BIT_SET_HOST_MSG_0_8812F(x, v)                                         \
	(BIT_CLEAR_HOST_MSG_0_8812F(x) | BIT_HOST_MSG_0_8812F(v))

/* 2 REG_HMEBOX1_8812F */

#define BIT_SHIFT_HOST_MSG_1_8812F 0
#define BIT_MASK_HOST_MSG_1_8812F 0xffffffffL
#define BIT_HOST_MSG_1_8812F(x)                                                \
	(((x) & BIT_MASK_HOST_MSG_1_8812F) << BIT_SHIFT_HOST_MSG_1_8812F)
#define BITS_HOST_MSG_1_8812F                                                  \
	(BIT_MASK_HOST_MSG_1_8812F << BIT_SHIFT_HOST_MSG_1_8812F)
#define BIT_CLEAR_HOST_MSG_1_8812F(x) ((x) & (~BITS_HOST_MSG_1_8812F))
#define BIT_GET_HOST_MSG_1_8812F(x)                                            \
	(((x) >> BIT_SHIFT_HOST_MSG_1_8812F) & BIT_MASK_HOST_MSG_1_8812F)
#define BIT_SET_HOST_MSG_1_8812F(x, v)                                         \
	(BIT_CLEAR_HOST_MSG_1_8812F(x) | BIT_HOST_MSG_1_8812F(v))

/* 2 REG_HMEBOX2_8812F */

#define BIT_SHIFT_HOST_MSG_2_8812F 0
#define BIT_MASK_HOST_MSG_2_8812F 0xffffffffL
#define BIT_HOST_MSG_2_8812F(x)                                                \
	(((x) & BIT_MASK_HOST_MSG_2_8812F) << BIT_SHIFT_HOST_MSG_2_8812F)
#define BITS_HOST_MSG_2_8812F                                                  \
	(BIT_MASK_HOST_MSG_2_8812F << BIT_SHIFT_HOST_MSG_2_8812F)
#define BIT_CLEAR_HOST_MSG_2_8812F(x) ((x) & (~BITS_HOST_MSG_2_8812F))
#define BIT_GET_HOST_MSG_2_8812F(x)                                            \
	(((x) >> BIT_SHIFT_HOST_MSG_2_8812F) & BIT_MASK_HOST_MSG_2_8812F)
#define BIT_SET_HOST_MSG_2_8812F(x, v)                                         \
	(BIT_CLEAR_HOST_MSG_2_8812F(x) | BIT_HOST_MSG_2_8812F(v))

/* 2 REG_HMEBOX3_8812F */

#define BIT_SHIFT_HOST_MSG_3_8812F 0
#define BIT_MASK_HOST_MSG_3_8812F 0xffffffffL
#define BIT_HOST_MSG_3_8812F(x)                                                \
	(((x) & BIT_MASK_HOST_MSG_3_8812F) << BIT_SHIFT_HOST_MSG_3_8812F)
#define BITS_HOST_MSG_3_8812F                                                  \
	(BIT_MASK_HOST_MSG_3_8812F << BIT_SHIFT_HOST_MSG_3_8812F)
#define BIT_CLEAR_HOST_MSG_3_8812F(x) ((x) & (~BITS_HOST_MSG_3_8812F))
#define BIT_GET_HOST_MSG_3_8812F(x)                                            \
	(((x) >> BIT_SHIFT_HOST_MSG_3_8812F) & BIT_MASK_HOST_MSG_3_8812F)
#define BIT_SET_HOST_MSG_3_8812F(x, v)                                         \
	(BIT_CLEAR_HOST_MSG_3_8812F(x) | BIT_HOST_MSG_3_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_BB_ACCESS_CTRL_8812F */

#define BIT_SHIFT_BB_WRITE_READ_8812F 30
#define BIT_MASK_BB_WRITE_READ_8812F 0x3
#define BIT_BB_WRITE_READ_8812F(x)                                             \
	(((x) & BIT_MASK_BB_WRITE_READ_8812F) << BIT_SHIFT_BB_WRITE_READ_8812F)
#define BITS_BB_WRITE_READ_8812F                                               \
	(BIT_MASK_BB_WRITE_READ_8812F << BIT_SHIFT_BB_WRITE_READ_8812F)
#define BIT_CLEAR_BB_WRITE_READ_8812F(x) ((x) & (~BITS_BB_WRITE_READ_8812F))
#define BIT_GET_BB_WRITE_READ_8812F(x)                                         \
	(((x) >> BIT_SHIFT_BB_WRITE_READ_8812F) & BIT_MASK_BB_WRITE_READ_8812F)
#define BIT_SET_BB_WRITE_READ_8812F(x, v)                                      \
	(BIT_CLEAR_BB_WRITE_READ_8812F(x) | BIT_BB_WRITE_READ_8812F(v))

#define BIT_SHIFT_BB_WRITE_EN_8812F 12
#define BIT_MASK_BB_WRITE_EN_8812F 0xf
#define BIT_BB_WRITE_EN_8812F(x)                                               \
	(((x) & BIT_MASK_BB_WRITE_EN_8812F) << BIT_SHIFT_BB_WRITE_EN_8812F)
#define BITS_BB_WRITE_EN_8812F                                                 \
	(BIT_MASK_BB_WRITE_EN_8812F << BIT_SHIFT_BB_WRITE_EN_8812F)
#define BIT_CLEAR_BB_WRITE_EN_8812F(x) ((x) & (~BITS_BB_WRITE_EN_8812F))
#define BIT_GET_BB_WRITE_EN_8812F(x)                                           \
	(((x) >> BIT_SHIFT_BB_WRITE_EN_8812F) & BIT_MASK_BB_WRITE_EN_8812F)
#define BIT_SET_BB_WRITE_EN_8812F(x, v)                                        \
	(BIT_CLEAR_BB_WRITE_EN_8812F(x) | BIT_BB_WRITE_EN_8812F(v))

#define BIT_SHIFT_BB_ADDR_8812F 2
#define BIT_MASK_BB_ADDR_8812F 0x1ff
#define BIT_BB_ADDR_8812F(x)                                                   \
	(((x) & BIT_MASK_BB_ADDR_8812F) << BIT_SHIFT_BB_ADDR_8812F)
#define BITS_BB_ADDR_8812F (BIT_MASK_BB_ADDR_8812F << BIT_SHIFT_BB_ADDR_8812F)
#define BIT_CLEAR_BB_ADDR_8812F(x) ((x) & (~BITS_BB_ADDR_8812F))
#define BIT_GET_BB_ADDR_8812F(x)                                               \
	(((x) >> BIT_SHIFT_BB_ADDR_8812F) & BIT_MASK_BB_ADDR_8812F)
#define BIT_SET_BB_ADDR_8812F(x, v)                                            \
	(BIT_CLEAR_BB_ADDR_8812F(x) | BIT_BB_ADDR_8812F(v))

#define BIT_BB_ERRACC_8812F BIT(0)

/* 2 REG_BB_ACCESS_DATA_8812F */

#define BIT_SHIFT_BB_DATA_8812F 0
#define BIT_MASK_BB_DATA_8812F 0xffffffffL
#define BIT_BB_DATA_8812F(x)                                                   \
	(((x) & BIT_MASK_BB_DATA_8812F) << BIT_SHIFT_BB_DATA_8812F)
#define BITS_BB_DATA_8812F (BIT_MASK_BB_DATA_8812F << BIT_SHIFT_BB_DATA_8812F)
#define BIT_CLEAR_BB_DATA_8812F(x) ((x) & (~BITS_BB_DATA_8812F))
#define BIT_GET_BB_DATA_8812F(x)                                               \
	(((x) >> BIT_SHIFT_BB_DATA_8812F) & BIT_MASK_BB_DATA_8812F)
#define BIT_SET_BB_DATA_8812F(x, v)                                            \
	(BIT_CLEAR_BB_DATA_8812F(x) | BIT_BB_DATA_8812F(v))

/* 2 REG_HMEBOX_E0_8812F */

#define BIT_SHIFT_HMEBOX_E0_8812F 0
#define BIT_MASK_HMEBOX_E0_8812F 0xffffffffL
#define BIT_HMEBOX_E0_8812F(x)                                                 \
	(((x) & BIT_MASK_HMEBOX_E0_8812F) << BIT_SHIFT_HMEBOX_E0_8812F)
#define BITS_HMEBOX_E0_8812F                                                   \
	(BIT_MASK_HMEBOX_E0_8812F << BIT_SHIFT_HMEBOX_E0_8812F)
#define BIT_CLEAR_HMEBOX_E0_8812F(x) ((x) & (~BITS_HMEBOX_E0_8812F))
#define BIT_GET_HMEBOX_E0_8812F(x)                                             \
	(((x) >> BIT_SHIFT_HMEBOX_E0_8812F) & BIT_MASK_HMEBOX_E0_8812F)
#define BIT_SET_HMEBOX_E0_8812F(x, v)                                          \
	(BIT_CLEAR_HMEBOX_E0_8812F(x) | BIT_HMEBOX_E0_8812F(v))

/* 2 REG_HMEBOX_E1_8812F */

#define BIT_SHIFT_HMEBOX_E1_8812F 0
#define BIT_MASK_HMEBOX_E1_8812F 0xffffffffL
#define BIT_HMEBOX_E1_8812F(x)                                                 \
	(((x) & BIT_MASK_HMEBOX_E1_8812F) << BIT_SHIFT_HMEBOX_E1_8812F)
#define BITS_HMEBOX_E1_8812F                                                   \
	(BIT_MASK_HMEBOX_E1_8812F << BIT_SHIFT_HMEBOX_E1_8812F)
#define BIT_CLEAR_HMEBOX_E1_8812F(x) ((x) & (~BITS_HMEBOX_E1_8812F))
#define BIT_GET_HMEBOX_E1_8812F(x)                                             \
	(((x) >> BIT_SHIFT_HMEBOX_E1_8812F) & BIT_MASK_HMEBOX_E1_8812F)
#define BIT_SET_HMEBOX_E1_8812F(x, v)                                          \
	(BIT_CLEAR_HMEBOX_E1_8812F(x) | BIT_HMEBOX_E1_8812F(v))

/* 2 REG_HMEBOX_E2_8812F */

#define BIT_SHIFT_HMEBOX_E2_8812F 0
#define BIT_MASK_HMEBOX_E2_8812F 0xffffffffL
#define BIT_HMEBOX_E2_8812F(x)                                                 \
	(((x) & BIT_MASK_HMEBOX_E2_8812F) << BIT_SHIFT_HMEBOX_E2_8812F)
#define BITS_HMEBOX_E2_8812F                                                   \
	(BIT_MASK_HMEBOX_E2_8812F << BIT_SHIFT_HMEBOX_E2_8812F)
#define BIT_CLEAR_HMEBOX_E2_8812F(x) ((x) & (~BITS_HMEBOX_E2_8812F))
#define BIT_GET_HMEBOX_E2_8812F(x)                                             \
	(((x) >> BIT_SHIFT_HMEBOX_E2_8812F) & BIT_MASK_HMEBOX_E2_8812F)
#define BIT_SET_HMEBOX_E2_8812F(x, v)                                          \
	(BIT_CLEAR_HMEBOX_E2_8812F(x) | BIT_HMEBOX_E2_8812F(v))

/* 2 REG_HMEBOX_E3_8812F */

#define BIT_SHIFT_HMEBOX_E3_8812F 0
#define BIT_MASK_HMEBOX_E3_8812F 0xffffffffL
#define BIT_HMEBOX_E3_8812F(x)                                                 \
	(((x) & BIT_MASK_HMEBOX_E3_8812F) << BIT_SHIFT_HMEBOX_E3_8812F)
#define BITS_HMEBOX_E3_8812F                                                   \
	(BIT_MASK_HMEBOX_E3_8812F << BIT_SHIFT_HMEBOX_E3_8812F)
#define BIT_CLEAR_HMEBOX_E3_8812F(x) ((x) & (~BITS_HMEBOX_E3_8812F))
#define BIT_GET_HMEBOX_E3_8812F(x)                                             \
	(((x) >> BIT_SHIFT_HMEBOX_E3_8812F) & BIT_MASK_HMEBOX_E3_8812F)
#define BIT_SET_HMEBOX_E3_8812F(x, v)                                          \
	(BIT_CLEAR_HMEBOX_E3_8812F(x) | BIT_HMEBOX_E3_8812F(v))

/* 2 REG_CR_EXT_8812F */

#define BIT_SHIFT_PHY_REQ_DELAY_8812F 24
#define BIT_MASK_PHY_REQ_DELAY_8812F 0xf
#define BIT_PHY_REQ_DELAY_8812F(x)                                             \
	(((x) & BIT_MASK_PHY_REQ_DELAY_8812F) << BIT_SHIFT_PHY_REQ_DELAY_8812F)
#define BITS_PHY_REQ_DELAY_8812F                                               \
	(BIT_MASK_PHY_REQ_DELAY_8812F << BIT_SHIFT_PHY_REQ_DELAY_8812F)
#define BIT_CLEAR_PHY_REQ_DELAY_8812F(x) ((x) & (~BITS_PHY_REQ_DELAY_8812F))
#define BIT_GET_PHY_REQ_DELAY_8812F(x)                                         \
	(((x) >> BIT_SHIFT_PHY_REQ_DELAY_8812F) & BIT_MASK_PHY_REQ_DELAY_8812F)
#define BIT_SET_PHY_REQ_DELAY_8812F(x, v)                                      \
	(BIT_CLEAR_PHY_REQ_DELAY_8812F(x) | BIT_PHY_REQ_DELAY_8812F(v))

/* 2 REG_NOT_VALID_8812F */
#define BIT_SPD_DOWN_8812F BIT(16)

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_NETYPE4_8812F 4
#define BIT_MASK_NETYPE4_8812F 0x3
#define BIT_NETYPE4_8812F(x)                                                   \
	(((x) & BIT_MASK_NETYPE4_8812F) << BIT_SHIFT_NETYPE4_8812F)
#define BITS_NETYPE4_8812F (BIT_MASK_NETYPE4_8812F << BIT_SHIFT_NETYPE4_8812F)
#define BIT_CLEAR_NETYPE4_8812F(x) ((x) & (~BITS_NETYPE4_8812F))
#define BIT_GET_NETYPE4_8812F(x)                                               \
	(((x) >> BIT_SHIFT_NETYPE4_8812F) & BIT_MASK_NETYPE4_8812F)
#define BIT_SET_NETYPE4_8812F(x, v)                                            \
	(BIT_CLEAR_NETYPE4_8812F(x) | BIT_NETYPE4_8812F(v))

#define BIT_SHIFT_NETYPE3_8812F 2
#define BIT_MASK_NETYPE3_8812F 0x3
#define BIT_NETYPE3_8812F(x)                                                   \
	(((x) & BIT_MASK_NETYPE3_8812F) << BIT_SHIFT_NETYPE3_8812F)
#define BITS_NETYPE3_8812F (BIT_MASK_NETYPE3_8812F << BIT_SHIFT_NETYPE3_8812F)
#define BIT_CLEAR_NETYPE3_8812F(x) ((x) & (~BITS_NETYPE3_8812F))
#define BIT_GET_NETYPE3_8812F(x)                                               \
	(((x) >> BIT_SHIFT_NETYPE3_8812F) & BIT_MASK_NETYPE3_8812F)
#define BIT_SET_NETYPE3_8812F(x, v)                                            \
	(BIT_CLEAR_NETYPE3_8812F(x) | BIT_NETYPE3_8812F(v))

#define BIT_SHIFT_NETYPE2_8812F 0
#define BIT_MASK_NETYPE2_8812F 0x3
#define BIT_NETYPE2_8812F(x)                                                   \
	(((x) & BIT_MASK_NETYPE2_8812F) << BIT_SHIFT_NETYPE2_8812F)
#define BITS_NETYPE2_8812F (BIT_MASK_NETYPE2_8812F << BIT_SHIFT_NETYPE2_8812F)
#define BIT_CLEAR_NETYPE2_8812F(x) ((x) & (~BITS_NETYPE2_8812F))
#define BIT_GET_NETYPE2_8812F(x)                                               \
	(((x) >> BIT_SHIFT_NETYPE2_8812F) & BIT_MASK_NETYPE2_8812F)
#define BIT_SET_NETYPE2_8812F(x, v)                                            \
	(BIT_CLEAR_NETYPE2_8812F(x) | BIT_NETYPE2_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_FWFF_8812F */

#define BIT_SHIFT_PKTNUM_TH_V1_8812F 24
#define BIT_MASK_PKTNUM_TH_V1_8812F 0xff
#define BIT_PKTNUM_TH_V1_8812F(x)                                              \
	(((x) & BIT_MASK_PKTNUM_TH_V1_8812F) << BIT_SHIFT_PKTNUM_TH_V1_8812F)
#define BITS_PKTNUM_TH_V1_8812F                                                \
	(BIT_MASK_PKTNUM_TH_V1_8812F << BIT_SHIFT_PKTNUM_TH_V1_8812F)
#define BIT_CLEAR_PKTNUM_TH_V1_8812F(x) ((x) & (~BITS_PKTNUM_TH_V1_8812F))
#define BIT_GET_PKTNUM_TH_V1_8812F(x)                                          \
	(((x) >> BIT_SHIFT_PKTNUM_TH_V1_8812F) & BIT_MASK_PKTNUM_TH_V1_8812F)
#define BIT_SET_PKTNUM_TH_V1_8812F(x, v)                                       \
	(BIT_CLEAR_PKTNUM_TH_V1_8812F(x) | BIT_PKTNUM_TH_V1_8812F(v))

#define BIT_SHIFT_TIMER_TH_8812F 16
#define BIT_MASK_TIMER_TH_8812F 0xff
#define BIT_TIMER_TH_8812F(x)                                                  \
	(((x) & BIT_MASK_TIMER_TH_8812F) << BIT_SHIFT_TIMER_TH_8812F)
#define BITS_TIMER_TH_8812F                                                    \
	(BIT_MASK_TIMER_TH_8812F << BIT_SHIFT_TIMER_TH_8812F)
#define BIT_CLEAR_TIMER_TH_8812F(x) ((x) & (~BITS_TIMER_TH_8812F))
#define BIT_GET_TIMER_TH_8812F(x)                                              \
	(((x) >> BIT_SHIFT_TIMER_TH_8812F) & BIT_MASK_TIMER_TH_8812F)
#define BIT_SET_TIMER_TH_8812F(x, v)                                           \
	(BIT_CLEAR_TIMER_TH_8812F(x) | BIT_TIMER_TH_8812F(v))

#define BIT_SHIFT_RXPKT1ENADDR_8812F 0
#define BIT_MASK_RXPKT1ENADDR_8812F 0xffff
#define BIT_RXPKT1ENADDR_8812F(x)                                              \
	(((x) & BIT_MASK_RXPKT1ENADDR_8812F) << BIT_SHIFT_RXPKT1ENADDR_8812F)
#define BITS_RXPKT1ENADDR_8812F                                                \
	(BIT_MASK_RXPKT1ENADDR_8812F << BIT_SHIFT_RXPKT1ENADDR_8812F)
#define BIT_CLEAR_RXPKT1ENADDR_8812F(x) ((x) & (~BITS_RXPKT1ENADDR_8812F))
#define BIT_GET_RXPKT1ENADDR_8812F(x)                                          \
	(((x) >> BIT_SHIFT_RXPKT1ENADDR_8812F) & BIT_MASK_RXPKT1ENADDR_8812F)
#define BIT_SET_RXPKT1ENADDR_8812F(x, v)                                       \
	(BIT_CLEAR_RXPKT1ENADDR_8812F(x) | BIT_RXPKT1ENADDR_8812F(v))

/* 2 REG_RXFF_PTR_V1_8812F */

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_RXFF0_RDPTR_V2_8812F 0
#define BIT_MASK_RXFF0_RDPTR_V2_8812F 0x3ffff
#define BIT_RXFF0_RDPTR_V2_8812F(x)                                            \
	(((x) & BIT_MASK_RXFF0_RDPTR_V2_8812F)                                 \
	 << BIT_SHIFT_RXFF0_RDPTR_V2_8812F)
#define BITS_RXFF0_RDPTR_V2_8812F                                              \
	(BIT_MASK_RXFF0_RDPTR_V2_8812F << BIT_SHIFT_RXFF0_RDPTR_V2_8812F)
#define BIT_CLEAR_RXFF0_RDPTR_V2_8812F(x) ((x) & (~BITS_RXFF0_RDPTR_V2_8812F))
#define BIT_GET_RXFF0_RDPTR_V2_8812F(x)                                        \
	(((x) >> BIT_SHIFT_RXFF0_RDPTR_V2_8812F) &                             \
	 BIT_MASK_RXFF0_RDPTR_V2_8812F)
#define BIT_SET_RXFF0_RDPTR_V2_8812F(x, v)                                     \
	(BIT_CLEAR_RXFF0_RDPTR_V2_8812F(x) | BIT_RXFF0_RDPTR_V2_8812F(v))

/* 2 REG_RXFF_WTR_V1_8812F */

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_RXFF0_WTPTR_V2_8812F 0
#define BIT_MASK_RXFF0_WTPTR_V2_8812F 0x3ffff
#define BIT_RXFF0_WTPTR_V2_8812F(x)                                            \
	(((x) & BIT_MASK_RXFF0_WTPTR_V2_8812F)                                 \
	 << BIT_SHIFT_RXFF0_WTPTR_V2_8812F)
#define BITS_RXFF0_WTPTR_V2_8812F                                              \
	(BIT_MASK_RXFF0_WTPTR_V2_8812F << BIT_SHIFT_RXFF0_WTPTR_V2_8812F)
#define BIT_CLEAR_RXFF0_WTPTR_V2_8812F(x) ((x) & (~BITS_RXFF0_WTPTR_V2_8812F))
#define BIT_GET_RXFF0_WTPTR_V2_8812F(x)                                        \
	(((x) >> BIT_SHIFT_RXFF0_WTPTR_V2_8812F) &                             \
	 BIT_MASK_RXFF0_WTPTR_V2_8812F)
#define BIT_SET_RXFF0_WTPTR_V2_8812F(x, v)                                     \
	(BIT_CLEAR_RXFF0_WTPTR_V2_8812F(x) | BIT_RXFF0_WTPTR_V2_8812F(v))

/* 2 REG_FE2IMR_8812F */
#define BIT__FE4ISR__IND_MSK_8812F BIT(29)
#define BIT_FS_TXSC_DESC_DONE_INT_EN_8812F BIT(28)
#define BIT_FS_TXSC_BKDONE_INT_EN_8812F BIT(27)
#define BIT_FS_TXSC_BEDONE_INT_EN_8812F BIT(26)
#define BIT_FS_TXSC_VIDONE_INT_EN_8812F BIT(25)
#define BIT_FS_TXSC_VODONE_INT_EN_8812F BIT(24)
#define BIT_FS_ATIM_MB7_INT_EN_8812F BIT(23)
#define BIT_FS_ATIM_MB6_INT_EN_8812F BIT(22)
#define BIT_FS_ATIM_MB5_INT_EN_8812F BIT(21)
#define BIT_FS_ATIM_MB4_INT_EN_8812F BIT(20)
#define BIT_FS_ATIM_MB3_INT_EN_8812F BIT(19)
#define BIT_FS_ATIM_MB2_INT_EN_8812F BIT(18)
#define BIT_FS_ATIM_MB1_INT_EN_8812F BIT(17)
#define BIT_FS_ATIM_MB0_INT_EN_8812F BIT(16)
#define BIT_FS_TBTT4INT_EN_8812F BIT(11)
#define BIT_FS_TBTT3INT_EN_8812F BIT(10)
#define BIT_FS_TBTT2INT_EN_8812F BIT(9)
#define BIT_FS_TBTT1INT_EN_8812F BIT(8)
#define BIT_FS_TBTT0_MB7INT_EN_8812F BIT(7)
#define BIT_FS_TBTT0_MB6INT_EN_8812F BIT(6)
#define BIT_FS_TBTT0_MB5INT_EN_8812F BIT(5)
#define BIT_FS_TBTT0_MB4INT_EN_8812F BIT(4)
#define BIT_FS_TBTT0_MB3INT_EN_8812F BIT(3)
#define BIT_FS_TBTT0_MB2INT_EN_8812F BIT(2)
#define BIT_FS_TBTT0_MB1INT_EN_8812F BIT(1)
#define BIT_FS_TBTT0_INT_EN_8812F BIT(0)

/* 2 REG_FE2ISR_8812F */
#define BIT__FE4ISR__IND_INT_8812F BIT(29)
#define BIT_FS_TXSC_DESC_DONE_INT_8812F BIT(28)
#define BIT_FS_TXSC_BKDONE_INT_8812F BIT(27)
#define BIT_FS_TXSC_BEDONE_INT_8812F BIT(26)
#define BIT_FS_TXSC_VIDONE_INT_8812F BIT(25)
#define BIT_FS_TXSC_VODONE_INT_8812F BIT(24)
#define BIT_FS_ATIM_MB7_INT_8812F BIT(23)
#define BIT_FS_ATIM_MB6_INT_8812F BIT(22)
#define BIT_FS_ATIM_MB5_INT_8812F BIT(21)
#define BIT_FS_ATIM_MB4_INT_8812F BIT(20)
#define BIT_FS_ATIM_MB3_INT_8812F BIT(19)
#define BIT_FS_ATIM_MB2_INT_8812F BIT(18)
#define BIT_FS_ATIM_MB1_INT_8812F BIT(17)
#define BIT_FS_ATIM_MB0_INT_8812F BIT(16)
#define BIT_FS_TBTT4INT_8812F BIT(11)
#define BIT_FS_TBTT3INT_8812F BIT(10)
#define BIT_FS_TBTT2INT_8812F BIT(9)
#define BIT_FS_TBTT1INT_8812F BIT(8)
#define BIT_FS_TBTT0_MB7INT_8812F BIT(7)
#define BIT_FS_TBTT0_MB6INT_8812F BIT(6)
#define BIT_FS_TBTT0_MB5INT_8812F BIT(5)
#define BIT_FS_TBTT0_MB4INT_8812F BIT(4)
#define BIT_FS_TBTT0_MB3INT_8812F BIT(3)
#define BIT_FS_TBTT0_MB2INT_8812F BIT(2)
#define BIT_FS_TBTT0_MB1INT_8812F BIT(1)
#define BIT_FS_TBTT0_INT_8812F BIT(0)

/* 2 REG_FE3IMR_8812F */
#define BIT_FS_CLI3_MTI_BCNIVLEAR_INT__EN_8812F BIT(31)
#define BIT_FS_CLI2_MTI_BCNIVLEAR_INT__EN_8812F BIT(30)
#define BIT_FS_CLI1_MTI_BCNIVLEAR_INT__EN_8812F BIT(29)
#define BIT_FS_CLI0_MTI_BCNIVLEAR_INT__EN_8812F BIT(28)
#define BIT_FS_BCNDMA4_INT_EN_8812F BIT(27)
#define BIT_FS_BCNDMA3_INT_EN_8812F BIT(26)
#define BIT_FS_BCNDMA2_INT_EN_8812F BIT(25)
#define BIT_FS_BCNDMA1_INT_EN_8812F BIT(24)
#define BIT_FS_BCNDMA0_MB7_INT_EN_8812F BIT(23)
#define BIT_FS_BCNDMA0_MB6_INT_EN_8812F BIT(22)
#define BIT_FS_BCNDMA0_MB5_INT_EN_8812F BIT(21)
#define BIT_FS_BCNDMA0_MB4_INT_EN_8812F BIT(20)
#define BIT_FS_BCNDMA0_MB3_INT_EN_8812F BIT(19)
#define BIT_FS_BCNDMA0_MB2_INT_EN_8812F BIT(18)
#define BIT_FS_BCNDMA0_MB1_INT_EN_8812F BIT(17)
#define BIT_FS_BCNDMA0_INT_EN_8812F BIT(16)
#define BIT_FS_MTI_BCNIVLEAR_INT__EN_8812F BIT(15)
#define BIT_FS_BCNERLY4_INT_EN_8812F BIT(11)
#define BIT_FS_BCNERLY3_INT_EN_8812F BIT(10)
#define BIT_FS_BCNERLY2_INT_EN_8812F BIT(9)
#define BIT_FS_BCNERLY1_INT_EN_8812F BIT(8)
#define BIT_FS_BCNERLY0_MB7INT_EN_8812F BIT(7)
#define BIT_FS_BCNERLY0_MB6INT_EN_8812F BIT(6)
#define BIT_FS_BCNERLY0_MB5INT_EN_8812F BIT(5)
#define BIT_FS_BCNERLY0_MB4INT_EN_8812F BIT(4)
#define BIT_FS_BCNERLY0_MB3INT_EN_8812F BIT(3)
#define BIT_FS_BCNERLY0_MB2INT_EN_8812F BIT(2)
#define BIT_FS_BCNERLY0_MB1INT_EN_8812F BIT(1)
#define BIT_FS_BCNERLY0_INT_EN_8812F BIT(0)

/* 2 REG_FE3ISR_8812F */
#define BIT_FS_CLI3_MTI_BCNIVLEAR_INT_8812F BIT(31)
#define BIT_FS_CLI2_MTI_BCNIVLEAR_INT_8812F BIT(30)
#define BIT_FS_CLI1_MTI_BCNIVLEAR_INT_8812F BIT(29)
#define BIT_FS_CLI0_MTI_BCNIVLEAR_INT_8812F BIT(28)
#define BIT_FS_BCNDMA4_INT_8812F BIT(27)
#define BIT_FS_BCNDMA3_INT_8812F BIT(26)
#define BIT_FS_BCNDMA2_INT_8812F BIT(25)
#define BIT_FS_BCNDMA1_INT_8812F BIT(24)
#define BIT_FS_BCNDMA0_MB7_INT_8812F BIT(23)
#define BIT_FS_BCNDMA0_MB6_INT_8812F BIT(22)
#define BIT_FS_BCNDMA0_MB5_INT_8812F BIT(21)
#define BIT_FS_BCNDMA0_MB4_INT_8812F BIT(20)
#define BIT_FS_BCNDMA0_MB3_INT_8812F BIT(19)
#define BIT_FS_BCNDMA0_MB2_INT_8812F BIT(18)
#define BIT_FS_BCNDMA0_MB1_INT_8812F BIT(17)
#define BIT_FS_BCNDMA0_INT_8812F BIT(16)
#define BIT_FS_MTI_BCNIVLEAR_INT_8812F BIT(15)
#define BIT_FS_BCNERLY4_INT_8812F BIT(11)
#define BIT_FS_BCNERLY3_INT_8812F BIT(10)
#define BIT_FS_BCNERLY2_INT_8812F BIT(9)
#define BIT_FS_BCNERLY1_INT_8812F BIT(8)
#define BIT_FS_BCNERLY0_MB7INT_8812F BIT(7)
#define BIT_FS_BCNERLY0_MB6INT_8812F BIT(6)
#define BIT_FS_BCNERLY0_MB5INT_8812F BIT(5)
#define BIT_FS_BCNERLY0_MB4INT_8812F BIT(4)
#define BIT_FS_BCNERLY0_MB3INT_8812F BIT(3)
#define BIT_FS_BCNERLY0_MB2INT_8812F BIT(2)
#define BIT_FS_BCNERLY0_MB1INT_8812F BIT(1)
#define BIT_FS_BCNERLY0_INT_8812F BIT(0)

/* 2 REG_FE4IMR_8812F */
#define BIT_FS_CLI3_TXPKTIN_INT_EN_8812F BIT(19)
#define BIT_FS_CLI2_TXPKTIN_INT_EN_8812F BIT(18)
#define BIT_FS_CLI1_TXPKTIN_INT_EN_8812F BIT(17)
#define BIT_FS_CLI0_TXPKTIN_INT_EN_8812F BIT(16)
#define BIT_FS_CLI3_RX_UMD0_INT_EN_8812F BIT(15)
#define BIT_FS_CLI3_RX_UMD1_INT_EN_8812F BIT(14)
#define BIT_FS_CLI3_RX_BMD0_INT_EN_8812F BIT(13)
#define BIT_FS_CLI3_RX_BMD1_INT_EN_8812F BIT(12)
#define BIT_FS_CLI2_RX_UMD0_INT_EN_8812F BIT(11)
#define BIT_FS_CLI2_RX_UMD1_INT_EN_8812F BIT(10)
#define BIT_FS_CLI2_RX_BMD0_INT_EN_8812F BIT(9)
#define BIT_FS_CLI2_RX_BMD1_INT_EN_8812F BIT(8)
#define BIT_FS_CLI1_RX_UMD0_INT_EN_8812F BIT(7)
#define BIT_FS_CLI1_RX_UMD1_INT_EN_8812F BIT(6)
#define BIT_FS_CLI1_RX_BMD0_INT_EN_8812F BIT(5)
#define BIT_FS_CLI1_RX_BMD1_INT_EN_8812F BIT(4)
#define BIT_FS_CLI0_RX_UMD0_INT_EN_8812F BIT(3)
#define BIT_FS_CLI0_RX_UMD1_INT_EN_8812F BIT(2)
#define BIT_FS_CLI0_RX_BMD0_INT_EN_8812F BIT(1)
#define BIT_FS_CLI0_RX_BMD1_INT_EN_8812F BIT(0)

/* 2 REG_FE4ISR_8812F */
#define BIT_FS_CLI3_TXPKTIN_INT_8812F BIT(19)
#define BIT_FS_CLI2_TXPKTIN_INT_8812F BIT(18)
#define BIT_FS_CLI1_TXPKTIN_INT_8812F BIT(17)
#define BIT_FS_CLI0_TXPKTIN_INT_8812F BIT(16)
#define BIT_FS_CLI3_RX_UMD0_INT_8812F BIT(15)
#define BIT_FS_CLI3_RX_UMD1_INT_8812F BIT(14)
#define BIT_FS_CLI3_RX_BMD0_INT_8812F BIT(13)
#define BIT_FS_CLI3_RX_BMD1_INT_8812F BIT(12)
#define BIT_FS_CLI2_RX_UMD0_INT_8812F BIT(11)
#define BIT_FS_CLI2_RX_UMD1_INT_8812F BIT(10)
#define BIT_FS_CLI2_RX_BMD0_INT_8812F BIT(9)
#define BIT_FS_CLI2_RX_BMD1_INT_8812F BIT(8)
#define BIT_FS_CLI1_RX_UMD0_INT_8812F BIT(7)
#define BIT_FS_CLI1_RX_UMD1_INT_8812F BIT(6)
#define BIT_FS_CLI1_RX_BMD0_INT_8812F BIT(5)
#define BIT_FS_CLI1_RX_BMD1_INT_8812F BIT(4)
#define BIT_FS_CLI0_RX_UMD0_INT_8812F BIT(3)
#define BIT_FS_CLI0_RX_UMD1_INT_8812F BIT(2)
#define BIT_FS_CLI0_RX_BMD0_INT_8812F BIT(1)
#define BIT_FS_CLI0_RX_BMD1_INT_8812F BIT(0)

/* 2 REG_FT1IMR_8812F */
#define BIT__FT2ISR__IND_MSK_8812F BIT(30)
#define BIT_FTM_PTT_INT_EN_8812F BIT(29)
#define BIT_RXFTMREQ_INT_EN_8812F BIT(28)
#define BIT_RXFTM_INT_EN_8812F BIT(27)
#define BIT_TXFTM_INT_EN_8812F BIT(26)
#define BIT_FS_H2C_CMD_OK_INT_EN_8812F BIT(25)
#define BIT_FS_H2C_CMD_FULL_INT_EN_8812F BIT(24)
#define BIT_FS_MACID_PWRCHANGE5_INT_EN_8812F BIT(23)
#define BIT_FS_MACID_PWRCHANGE4_INT_EN_8812F BIT(22)
#define BIT_FS_MACID_PWRCHANGE3_INT_EN_8812F BIT(21)
#define BIT_FS_MACID_PWRCHANGE2_INT_EN_8812F BIT(20)
#define BIT_FS_MACID_PWRCHANGE1_INT_EN_8812F BIT(19)
#define BIT_FS_MACID_PWRCHANGE0_INT_EN_8812F BIT(18)
#define BIT_FS_CTWEND2_INT_EN_8812F BIT(17)
#define BIT_FS_CTWEND1_INT_EN_8812F BIT(16)
#define BIT_FS_CTWEND0_INT_EN_8812F BIT(15)
#define BIT_FS_TX_NULL1_INT_EN_8812F BIT(14)
#define BIT_FS_TX_NULL0_INT_EN_8812F BIT(13)
#define BIT_FS_TSF_BIT32_TOGGLE_EN_8812F BIT(12)
#define BIT_FS_P2P_RFON2_INT_EN_8812F BIT(11)
#define BIT_FS_P2P_RFOFF2_INT_EN_8812F BIT(10)
#define BIT_FS_P2P_RFON1_INT_EN_8812F BIT(9)
#define BIT_FS_P2P_RFOFF1_INT_EN_8812F BIT(8)
#define BIT_FS_P2P_RFON0_INT_EN_8812F BIT(7)
#define BIT_FS_P2P_RFOFF0_INT_EN_8812F BIT(6)
#define BIT_FS_RX_UAPSDMD1_EN_8812F BIT(5)
#define BIT_FS_RX_UAPSDMD0_EN_8812F BIT(4)
#define BIT_FS_TRIGGER_PKT_EN_8812F BIT(3)
#define BIT_FS_EOSP_INT_EN_8812F BIT(2)
#define BIT_FS_RPWM2_INT_EN_8812F BIT(1)
#define BIT_FS_RPWM_INT_EN_8812F BIT(0)

/* 2 REG_FT1ISR_8812F */
#define BIT__FT2ISR__IND_INT_8812F BIT(30)
#define BIT_FTM_PTT_INT_8812F BIT(29)
#define BIT_RXFTMREQ_INT_8812F BIT(28)
#define BIT_RXFTM_INT_8812F BIT(27)
#define BIT_TXFTM_INT_8812F BIT(26)
#define BIT_FS_H2C_CMD_OK_INT_8812F BIT(25)
#define BIT_FS_H2C_CMD_FULL_INT_8812F BIT(24)
#define BIT_FS_MACID_PWRCHANGE5_INT_8812F BIT(23)
#define BIT_FS_MACID_PWRCHANGE4_INT_8812F BIT(22)
#define BIT_FS_MACID_PWRCHANGE3_INT_8812F BIT(21)
#define BIT_FS_MACID_PWRCHANGE2_INT_8812F BIT(20)
#define BIT_FS_MACID_PWRCHANGE1_INT_8812F BIT(19)
#define BIT_FS_MACID_PWRCHANGE0_INT_8812F BIT(18)
#define BIT_FS_CTWEND2_INT_8812F BIT(17)
#define BIT_FS_CTWEND1_INT_8812F BIT(16)
#define BIT_FS_CTWEND0_INT_8812F BIT(15)
#define BIT_FS_TX_NULL1_INT_8812F BIT(14)
#define BIT_FS_TX_NULL0_INT_8812F BIT(13)
#define BIT_FS_TSF_BIT32_TOGGLE_INT_8812F BIT(12)
#define BIT_FS_P2P_RFON2_INT_8812F BIT(11)
#define BIT_FS_P2P_RFOFF2_INT_8812F BIT(10)
#define BIT_FS_P2P_RFON1_INT_8812F BIT(9)
#define BIT_FS_P2P_RFOFF1_INT_8812F BIT(8)
#define BIT_FS_P2P_RFON0_INT_8812F BIT(7)
#define BIT_FS_P2P_RFOFF0_INT_8812F BIT(6)
#define BIT_FS_RX_UAPSDMD1_INT_8812F BIT(5)
#define BIT_FS_RX_UAPSDMD0_INT_8812F BIT(4)
#define BIT_FS_TRIGGER_PKT_INT_8812F BIT(3)
#define BIT_FS_EOSP_INT_8812F BIT(2)
#define BIT_FS_RPWM2_INT_8812F BIT(1)
#define BIT_FS_RPWM_INT_8812F BIT(0)

/* 2 REG_SPWR0_8812F */

#define BIT_SHIFT_MID_31TO0_8812F 0
#define BIT_MASK_MID_31TO0_8812F 0xffffffffL
#define BIT_MID_31TO0_8812F(x)                                                 \
	(((x) & BIT_MASK_MID_31TO0_8812F) << BIT_SHIFT_MID_31TO0_8812F)
#define BITS_MID_31TO0_8812F                                                   \
	(BIT_MASK_MID_31TO0_8812F << BIT_SHIFT_MID_31TO0_8812F)
#define BIT_CLEAR_MID_31TO0_8812F(x) ((x) & (~BITS_MID_31TO0_8812F))
#define BIT_GET_MID_31TO0_8812F(x)                                             \
	(((x) >> BIT_SHIFT_MID_31TO0_8812F) & BIT_MASK_MID_31TO0_8812F)
#define BIT_SET_MID_31TO0_8812F(x, v)                                          \
	(BIT_CLEAR_MID_31TO0_8812F(x) | BIT_MID_31TO0_8812F(v))

/* 2 REG_SPWR1_8812F */

#define BIT_SHIFT_MID_63TO32_8812F 0
#define BIT_MASK_MID_63TO32_8812F 0xffffffffL
#define BIT_MID_63TO32_8812F(x)                                                \
	(((x) & BIT_MASK_MID_63TO32_8812F) << BIT_SHIFT_MID_63TO32_8812F)
#define BITS_MID_63TO32_8812F                                                  \
	(BIT_MASK_MID_63TO32_8812F << BIT_SHIFT_MID_63TO32_8812F)
#define BIT_CLEAR_MID_63TO32_8812F(x) ((x) & (~BITS_MID_63TO32_8812F))
#define BIT_GET_MID_63TO32_8812F(x)                                            \
	(((x) >> BIT_SHIFT_MID_63TO32_8812F) & BIT_MASK_MID_63TO32_8812F)
#define BIT_SET_MID_63TO32_8812F(x, v)                                         \
	(BIT_CLEAR_MID_63TO32_8812F(x) | BIT_MID_63TO32_8812F(v))

/* 2 REG_SPWR2_8812F */

#define BIT_SHIFT_MID_95O64_8812F 0
#define BIT_MASK_MID_95O64_8812F 0xffffffffL
#define BIT_MID_95O64_8812F(x)                                                 \
	(((x) & BIT_MASK_MID_95O64_8812F) << BIT_SHIFT_MID_95O64_8812F)
#define BITS_MID_95O64_8812F                                                   \
	(BIT_MASK_MID_95O64_8812F << BIT_SHIFT_MID_95O64_8812F)
#define BIT_CLEAR_MID_95O64_8812F(x) ((x) & (~BITS_MID_95O64_8812F))
#define BIT_GET_MID_95O64_8812F(x)                                             \
	(((x) >> BIT_SHIFT_MID_95O64_8812F) & BIT_MASK_MID_95O64_8812F)
#define BIT_SET_MID_95O64_8812F(x, v)                                          \
	(BIT_CLEAR_MID_95O64_8812F(x) | BIT_MID_95O64_8812F(v))

/* 2 REG_SPWR3_8812F */

#define BIT_SHIFT_MID_127TO96_8812F 0
#define BIT_MASK_MID_127TO96_8812F 0xffffffffL
#define BIT_MID_127TO96_8812F(x)                                               \
	(((x) & BIT_MASK_MID_127TO96_8812F) << BIT_SHIFT_MID_127TO96_8812F)
#define BITS_MID_127TO96_8812F                                                 \
	(BIT_MASK_MID_127TO96_8812F << BIT_SHIFT_MID_127TO96_8812F)
#define BIT_CLEAR_MID_127TO96_8812F(x) ((x) & (~BITS_MID_127TO96_8812F))
#define BIT_GET_MID_127TO96_8812F(x)                                           \
	(((x) >> BIT_SHIFT_MID_127TO96_8812F) & BIT_MASK_MID_127TO96_8812F)
#define BIT_SET_MID_127TO96_8812F(x, v)                                        \
	(BIT_CLEAR_MID_127TO96_8812F(x) | BIT_MID_127TO96_8812F(v))

/* 2 REG_POWSEQ_8812F */

#define BIT_SHIFT_SEQNUM_MID_8812F 16
#define BIT_MASK_SEQNUM_MID_8812F 0xffff
#define BIT_SEQNUM_MID_8812F(x)                                                \
	(((x) & BIT_MASK_SEQNUM_MID_8812F) << BIT_SHIFT_SEQNUM_MID_8812F)
#define BITS_SEQNUM_MID_8812F                                                  \
	(BIT_MASK_SEQNUM_MID_8812F << BIT_SHIFT_SEQNUM_MID_8812F)
#define BIT_CLEAR_SEQNUM_MID_8812F(x) ((x) & (~BITS_SEQNUM_MID_8812F))
#define BIT_GET_SEQNUM_MID_8812F(x)                                            \
	(((x) >> BIT_SHIFT_SEQNUM_MID_8812F) & BIT_MASK_SEQNUM_MID_8812F)
#define BIT_SET_SEQNUM_MID_8812F(x, v)                                         \
	(BIT_CLEAR_SEQNUM_MID_8812F(x) | BIT_SEQNUM_MID_8812F(v))

#define BIT_SHIFT_REF_MID_8812F 0
#define BIT_MASK_REF_MID_8812F 0x7f
#define BIT_REF_MID_8812F(x)                                                   \
	(((x) & BIT_MASK_REF_MID_8812F) << BIT_SHIFT_REF_MID_8812F)
#define BITS_REF_MID_8812F (BIT_MASK_REF_MID_8812F << BIT_SHIFT_REF_MID_8812F)
#define BIT_CLEAR_REF_MID_8812F(x) ((x) & (~BITS_REF_MID_8812F))
#define BIT_GET_REF_MID_8812F(x)                                               \
	(((x) >> BIT_SHIFT_REF_MID_8812F) & BIT_MASK_REF_MID_8812F)
#define BIT_SET_REF_MID_8812F(x, v)                                            \
	(BIT_CLEAR_REF_MID_8812F(x) | BIT_REF_MID_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_TC7_CTRL_V1_8812F */
#define BIT_TC7INT_EN_8812F BIT(26)
#define BIT_TC7MODE_8812F BIT(25)
#define BIT_TC7EN_8812F BIT(24)

#define BIT_SHIFT_TC7DATA_8812F 0
#define BIT_MASK_TC7DATA_8812F 0xffffff
#define BIT_TC7DATA_8812F(x)                                                   \
	(((x) & BIT_MASK_TC7DATA_8812F) << BIT_SHIFT_TC7DATA_8812F)
#define BITS_TC7DATA_8812F (BIT_MASK_TC7DATA_8812F << BIT_SHIFT_TC7DATA_8812F)
#define BIT_CLEAR_TC7DATA_8812F(x) ((x) & (~BITS_TC7DATA_8812F))
#define BIT_GET_TC7DATA_8812F(x)                                               \
	(((x) >> BIT_SHIFT_TC7DATA_8812F) & BIT_MASK_TC7DATA_8812F)
#define BIT_SET_TC7DATA_8812F(x, v)                                            \
	(BIT_CLEAR_TC7DATA_8812F(x) | BIT_TC7DATA_8812F(v))

/* 2 REG_TC8_CTRL_V1_8812F */
#define BIT_TC8INT_EN_8812F BIT(26)
#define BIT_TC8MODE_8812F BIT(25)
#define BIT_TC8EN_8812F BIT(24)

#define BIT_SHIFT_TC8DATA_8812F 0
#define BIT_MASK_TC8DATA_8812F 0xffffff
#define BIT_TC8DATA_8812F(x)                                                   \
	(((x) & BIT_MASK_TC8DATA_8812F) << BIT_SHIFT_TC8DATA_8812F)
#define BITS_TC8DATA_8812F (BIT_MASK_TC8DATA_8812F << BIT_SHIFT_TC8DATA_8812F)
#define BIT_CLEAR_TC8DATA_8812F(x) ((x) & (~BITS_TC8DATA_8812F))
#define BIT_GET_TC8DATA_8812F(x)                                               \
	(((x) >> BIT_SHIFT_TC8DATA_8812F) & BIT_MASK_TC8DATA_8812F)
#define BIT_SET_TC8DATA_8812F(x, v)                                            \
	(BIT_CLEAR_TC8DATA_8812F(x) | BIT_TC8DATA_8812F(v))

/* 2 REG_RX_BCN_TBTT_ITVL0_8812F */

#define BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT2_8812F 24
#define BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT2_8812F 0xff
#define BIT_RX_BCN_TBTT_ITVL_CLIENT2_8812F(x)                                  \
	(((x) & BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT2_8812F)                       \
	 << BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT2_8812F)
#define BITS_RX_BCN_TBTT_ITVL_CLIENT2_8812F                                    \
	(BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT2_8812F                               \
	 << BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT2_8812F)
#define BIT_CLEAR_RX_BCN_TBTT_ITVL_CLIENT2_8812F(x)                            \
	((x) & (~BITS_RX_BCN_TBTT_ITVL_CLIENT2_8812F))
#define BIT_GET_RX_BCN_TBTT_ITVL_CLIENT2_8812F(x)                              \
	(((x) >> BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT2_8812F) &                   \
	 BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT2_8812F)
#define BIT_SET_RX_BCN_TBTT_ITVL_CLIENT2_8812F(x, v)                           \
	(BIT_CLEAR_RX_BCN_TBTT_ITVL_CLIENT2_8812F(x) |                         \
	 BIT_RX_BCN_TBTT_ITVL_CLIENT2_8812F(v))

#define BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT1_8812F 16
#define BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT1_8812F 0xff
#define BIT_RX_BCN_TBTT_ITVL_CLIENT1_8812F(x)                                  \
	(((x) & BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT1_8812F)                       \
	 << BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT1_8812F)
#define BITS_RX_BCN_TBTT_ITVL_CLIENT1_8812F                                    \
	(BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT1_8812F                               \
	 << BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT1_8812F)
#define BIT_CLEAR_RX_BCN_TBTT_ITVL_CLIENT1_8812F(x)                            \
	((x) & (~BITS_RX_BCN_TBTT_ITVL_CLIENT1_8812F))
#define BIT_GET_RX_BCN_TBTT_ITVL_CLIENT1_8812F(x)                              \
	(((x) >> BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT1_8812F) &                   \
	 BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT1_8812F)
#define BIT_SET_RX_BCN_TBTT_ITVL_CLIENT1_8812F(x, v)                           \
	(BIT_CLEAR_RX_BCN_TBTT_ITVL_CLIENT1_8812F(x) |                         \
	 BIT_RX_BCN_TBTT_ITVL_CLIENT1_8812F(v))

#define BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT0_8812F 8
#define BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT0_8812F 0xff
#define BIT_RX_BCN_TBTT_ITVL_CLIENT0_8812F(x)                                  \
	(((x) & BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT0_8812F)                       \
	 << BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT0_8812F)
#define BITS_RX_BCN_TBTT_ITVL_CLIENT0_8812F                                    \
	(BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT0_8812F                               \
	 << BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT0_8812F)
#define BIT_CLEAR_RX_BCN_TBTT_ITVL_CLIENT0_8812F(x)                            \
	((x) & (~BITS_RX_BCN_TBTT_ITVL_CLIENT0_8812F))
#define BIT_GET_RX_BCN_TBTT_ITVL_CLIENT0_8812F(x)                              \
	(((x) >> BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT0_8812F) &                   \
	 BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT0_8812F)
#define BIT_SET_RX_BCN_TBTT_ITVL_CLIENT0_8812F(x, v)                           \
	(BIT_CLEAR_RX_BCN_TBTT_ITVL_CLIENT0_8812F(x) |                         \
	 BIT_RX_BCN_TBTT_ITVL_CLIENT0_8812F(v))

#define BIT_SHIFT_RX_BCN_TBTT_ITVL_PORT0_8812F 0
#define BIT_MASK_RX_BCN_TBTT_ITVL_PORT0_8812F 0xff
#define BIT_RX_BCN_TBTT_ITVL_PORT0_8812F(x)                                    \
	(((x) & BIT_MASK_RX_BCN_TBTT_ITVL_PORT0_8812F)                         \
	 << BIT_SHIFT_RX_BCN_TBTT_ITVL_PORT0_8812F)
#define BITS_RX_BCN_TBTT_ITVL_PORT0_8812F                                      \
	(BIT_MASK_RX_BCN_TBTT_ITVL_PORT0_8812F                                 \
	 << BIT_SHIFT_RX_BCN_TBTT_ITVL_PORT0_8812F)
#define BIT_CLEAR_RX_BCN_TBTT_ITVL_PORT0_8812F(x)                              \
	((x) & (~BITS_RX_BCN_TBTT_ITVL_PORT0_8812F))
#define BIT_GET_RX_BCN_TBTT_ITVL_PORT0_8812F(x)                                \
	(((x) >> BIT_SHIFT_RX_BCN_TBTT_ITVL_PORT0_8812F) &                     \
	 BIT_MASK_RX_BCN_TBTT_ITVL_PORT0_8812F)
#define BIT_SET_RX_BCN_TBTT_ITVL_PORT0_8812F(x, v)                             \
	(BIT_CLEAR_RX_BCN_TBTT_ITVL_PORT0_8812F(x) |                           \
	 BIT_RX_BCN_TBTT_ITVL_PORT0_8812F(v))

/* 2 REG_RX_BCN_TBTT_ITVL1_8812F */

#define BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT3_8812F 0
#define BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT3_8812F 0xff
#define BIT_RX_BCN_TBTT_ITVL_CLIENT3_8812F(x)                                  \
	(((x) & BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT3_8812F)                       \
	 << BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT3_8812F)
#define BITS_RX_BCN_TBTT_ITVL_CLIENT3_8812F                                    \
	(BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT3_8812F                               \
	 << BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT3_8812F)
#define BIT_CLEAR_RX_BCN_TBTT_ITVL_CLIENT3_8812F(x)                            \
	((x) & (~BITS_RX_BCN_TBTT_ITVL_CLIENT3_8812F))
#define BIT_GET_RX_BCN_TBTT_ITVL_CLIENT3_8812F(x)                              \
	(((x) >> BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT3_8812F) &                   \
	 BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT3_8812F)
#define BIT_SET_RX_BCN_TBTT_ITVL_CLIENT3_8812F(x, v)                           \
	(BIT_CLEAR_RX_BCN_TBTT_ITVL_CLIENT3_8812F(x) |                         \
	 BIT_RX_BCN_TBTT_ITVL_CLIENT3_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_IO_WRAP_ERR_FLAG_8812F */
#define BIT_IO_WRAP_ERR_8812F BIT(0)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_SPEED_SENSOR_8812F */
#define BIT_DSS_1_RST_N_8812F BIT(31)
#define BIT_DSS_1_SPEED_EN_8812F BIT(30)
#define BIT_DSS_1_WIRE_SEL_8812F BIT(29)
#define BIT_DSS_ENCLK_8812F BIT(28)

#define BIT_SHIFT_DSS_1_RO_SEL_8812F 24
#define BIT_MASK_DSS_1_RO_SEL_8812F 0x7
#define BIT_DSS_1_RO_SEL_8812F(x)                                              \
	(((x) & BIT_MASK_DSS_1_RO_SEL_8812F) << BIT_SHIFT_DSS_1_RO_SEL_8812F)
#define BITS_DSS_1_RO_SEL_8812F                                                \
	(BIT_MASK_DSS_1_RO_SEL_8812F << BIT_SHIFT_DSS_1_RO_SEL_8812F)
#define BIT_CLEAR_DSS_1_RO_SEL_8812F(x) ((x) & (~BITS_DSS_1_RO_SEL_8812F))
#define BIT_GET_DSS_1_RO_SEL_8812F(x)                                          \
	(((x) >> BIT_SHIFT_DSS_1_RO_SEL_8812F) & BIT_MASK_DSS_1_RO_SEL_8812F)
#define BIT_SET_DSS_1_RO_SEL_8812F(x, v)                                       \
	(BIT_CLEAR_DSS_1_RO_SEL_8812F(x) | BIT_DSS_1_RO_SEL_8812F(v))

#define BIT_SHIFT_DSS_1_DATA_IN_8812F 0
#define BIT_MASK_DSS_1_DATA_IN_8812F 0xfffff
#define BIT_DSS_1_DATA_IN_8812F(x)                                             \
	(((x) & BIT_MASK_DSS_1_DATA_IN_8812F) << BIT_SHIFT_DSS_1_DATA_IN_8812F)
#define BITS_DSS_1_DATA_IN_8812F                                               \
	(BIT_MASK_DSS_1_DATA_IN_8812F << BIT_SHIFT_DSS_1_DATA_IN_8812F)
#define BIT_CLEAR_DSS_1_DATA_IN_8812F(x) ((x) & (~BITS_DSS_1_DATA_IN_8812F))
#define BIT_GET_DSS_1_DATA_IN_8812F(x)                                         \
	(((x) >> BIT_SHIFT_DSS_1_DATA_IN_8812F) & BIT_MASK_DSS_1_DATA_IN_8812F)
#define BIT_SET_DSS_1_DATA_IN_8812F(x, v)                                      \
	(BIT_CLEAR_DSS_1_DATA_IN_8812F(x) | BIT_DSS_1_DATA_IN_8812F(v))

/* 2 REG_SPEED_SENSOR1_8812F */
#define BIT_DSS_1_READY_8812F BIT(31)
#define BIT_DSS_1_WSORT_GO_8812F BIT(30)

#define BIT_SHIFT_DSS_1_COUNT_OUT_8812F 0
#define BIT_MASK_DSS_1_COUNT_OUT_8812F 0xfffff
#define BIT_DSS_1_COUNT_OUT_8812F(x)                                           \
	(((x) & BIT_MASK_DSS_1_COUNT_OUT_8812F)                                \
	 << BIT_SHIFT_DSS_1_COUNT_OUT_8812F)
#define BITS_DSS_1_COUNT_OUT_8812F                                             \
	(BIT_MASK_DSS_1_COUNT_OUT_8812F << BIT_SHIFT_DSS_1_COUNT_OUT_8812F)
#define BIT_CLEAR_DSS_1_COUNT_OUT_8812F(x) ((x) & (~BITS_DSS_1_COUNT_OUT_8812F))
#define BIT_GET_DSS_1_COUNT_OUT_8812F(x)                                       \
	(((x) >> BIT_SHIFT_DSS_1_COUNT_OUT_8812F) &                            \
	 BIT_MASK_DSS_1_COUNT_OUT_8812F)
#define BIT_SET_DSS_1_COUNT_OUT_8812F(x, v)                                    \
	(BIT_CLEAR_DSS_1_COUNT_OUT_8812F(x) | BIT_DSS_1_COUNT_OUT_8812F(v))

/* 2 REG_SPEED_SENSOR2_8812F */
#define BIT_DSS_2_RST_N_8812F BIT(31)
#define BIT_DSS_2_SPEED_EN_8812F BIT(30)
#define BIT_DSS_2_WIRE_SEL_8812F BIT(29)
#define BIT_DSS_ENCLK_8812F BIT(28)

#define BIT_SHIFT_DSS_2_RO_SEL_8812F 24
#define BIT_MASK_DSS_2_RO_SEL_8812F 0x7
#define BIT_DSS_2_RO_SEL_8812F(x)                                              \
	(((x) & BIT_MASK_DSS_2_RO_SEL_8812F) << BIT_SHIFT_DSS_2_RO_SEL_8812F)
#define BITS_DSS_2_RO_SEL_8812F                                                \
	(BIT_MASK_DSS_2_RO_SEL_8812F << BIT_SHIFT_DSS_2_RO_SEL_8812F)
#define BIT_CLEAR_DSS_2_RO_SEL_8812F(x) ((x) & (~BITS_DSS_2_RO_SEL_8812F))
#define BIT_GET_DSS_2_RO_SEL_8812F(x)                                          \
	(((x) >> BIT_SHIFT_DSS_2_RO_SEL_8812F) & BIT_MASK_DSS_2_RO_SEL_8812F)
#define BIT_SET_DSS_2_RO_SEL_8812F(x, v)                                       \
	(BIT_CLEAR_DSS_2_RO_SEL_8812F(x) | BIT_DSS_2_RO_SEL_8812F(v))

#define BIT_SHIFT_DSS_2_DATA_IN_8812F 0
#define BIT_MASK_DSS_2_DATA_IN_8812F 0xfffff
#define BIT_DSS_2_DATA_IN_8812F(x)                                             \
	(((x) & BIT_MASK_DSS_2_DATA_IN_8812F) << BIT_SHIFT_DSS_2_DATA_IN_8812F)
#define BITS_DSS_2_DATA_IN_8812F                                               \
	(BIT_MASK_DSS_2_DATA_IN_8812F << BIT_SHIFT_DSS_2_DATA_IN_8812F)
#define BIT_CLEAR_DSS_2_DATA_IN_8812F(x) ((x) & (~BITS_DSS_2_DATA_IN_8812F))
#define BIT_GET_DSS_2_DATA_IN_8812F(x)                                         \
	(((x) >> BIT_SHIFT_DSS_2_DATA_IN_8812F) & BIT_MASK_DSS_2_DATA_IN_8812F)
#define BIT_SET_DSS_2_DATA_IN_8812F(x, v)                                      \
	(BIT_CLEAR_DSS_2_DATA_IN_8812F(x) | BIT_DSS_2_DATA_IN_8812F(v))

/* 2 REG_SPEED_SENSOR3_8812F */
#define BIT_DSS_2_READY_8812F BIT(31)
#define BIT_DSS_2_WSORT_GO_8812F BIT(30)

#define BIT_SHIFT_DSS_2_COUNT_OUT_8812F 0
#define BIT_MASK_DSS_2_COUNT_OUT_8812F 0xfffff
#define BIT_DSS_2_COUNT_OUT_8812F(x)                                           \
	(((x) & BIT_MASK_DSS_2_COUNT_OUT_8812F)                                \
	 << BIT_SHIFT_DSS_2_COUNT_OUT_8812F)
#define BITS_DSS_2_COUNT_OUT_8812F                                             \
	(BIT_MASK_DSS_2_COUNT_OUT_8812F << BIT_SHIFT_DSS_2_COUNT_OUT_8812F)
#define BIT_CLEAR_DSS_2_COUNT_OUT_8812F(x) ((x) & (~BITS_DSS_2_COUNT_OUT_8812F))
#define BIT_GET_DSS_2_COUNT_OUT_8812F(x)                                       \
	(((x) >> BIT_SHIFT_DSS_2_COUNT_OUT_8812F) &                            \
	 BIT_MASK_DSS_2_COUNT_OUT_8812F)
#define BIT_SET_DSS_2_COUNT_OUT_8812F(x, v)                                    \
	(BIT_CLEAR_DSS_2_COUNT_OUT_8812F(x) | BIT_DSS_2_COUNT_OUT_8812F(v))

/* 2 REG_SPEED_SENSOR4_8812F */
#define BIT_DSS_3_RST_N_8812F BIT(31)
#define BIT_DSS_3_SPEED_EN_8812F BIT(30)
#define BIT_DSS_3_WIRE_SEL_8812F BIT(29)
#define BIT_DSS_ENCLK_8812F BIT(28)

#define BIT_SHIFT_DSS_3_RO_SEL_8812F 24
#define BIT_MASK_DSS_3_RO_SEL_8812F 0x7
#define BIT_DSS_3_RO_SEL_8812F(x)                                              \
	(((x) & BIT_MASK_DSS_3_RO_SEL_8812F) << BIT_SHIFT_DSS_3_RO_SEL_8812F)
#define BITS_DSS_3_RO_SEL_8812F                                                \
	(BIT_MASK_DSS_3_RO_SEL_8812F << BIT_SHIFT_DSS_3_RO_SEL_8812F)
#define BIT_CLEAR_DSS_3_RO_SEL_8812F(x) ((x) & (~BITS_DSS_3_RO_SEL_8812F))
#define BIT_GET_DSS_3_RO_SEL_8812F(x)                                          \
	(((x) >> BIT_SHIFT_DSS_3_RO_SEL_8812F) & BIT_MASK_DSS_3_RO_SEL_8812F)
#define BIT_SET_DSS_3_RO_SEL_8812F(x, v)                                       \
	(BIT_CLEAR_DSS_3_RO_SEL_8812F(x) | BIT_DSS_3_RO_SEL_8812F(v))

#define BIT_SHIFT_DSS_3_DATA_IN_8812F 0
#define BIT_MASK_DSS_3_DATA_IN_8812F 0xfffff
#define BIT_DSS_3_DATA_IN_8812F(x)                                             \
	(((x) & BIT_MASK_DSS_3_DATA_IN_8812F) << BIT_SHIFT_DSS_3_DATA_IN_8812F)
#define BITS_DSS_3_DATA_IN_8812F                                               \
	(BIT_MASK_DSS_3_DATA_IN_8812F << BIT_SHIFT_DSS_3_DATA_IN_8812F)
#define BIT_CLEAR_DSS_3_DATA_IN_8812F(x) ((x) & (~BITS_DSS_3_DATA_IN_8812F))
#define BIT_GET_DSS_3_DATA_IN_8812F(x)                                         \
	(((x) >> BIT_SHIFT_DSS_3_DATA_IN_8812F) & BIT_MASK_DSS_3_DATA_IN_8812F)
#define BIT_SET_DSS_3_DATA_IN_8812F(x, v)                                      \
	(BIT_CLEAR_DSS_3_DATA_IN_8812F(x) | BIT_DSS_3_DATA_IN_8812F(v))

/* 2 REG_SPEED_SENSOR5_8812F */
#define BIT_DSS_3_READY_8812F BIT(31)
#define BIT_DSS_3_WSORT_GO_8812F BIT(30)

#define BIT_SHIFT_DSS_3_COUNT_OUT_8812F 0
#define BIT_MASK_DSS_3_COUNT_OUT_8812F 0xfffff
#define BIT_DSS_3_COUNT_OUT_8812F(x)                                           \
	(((x) & BIT_MASK_DSS_3_COUNT_OUT_8812F)                                \
	 << BIT_SHIFT_DSS_3_COUNT_OUT_8812F)
#define BITS_DSS_3_COUNT_OUT_8812F                                             \
	(BIT_MASK_DSS_3_COUNT_OUT_8812F << BIT_SHIFT_DSS_3_COUNT_OUT_8812F)
#define BIT_CLEAR_DSS_3_COUNT_OUT_8812F(x) ((x) & (~BITS_DSS_3_COUNT_OUT_8812F))
#define BIT_GET_DSS_3_COUNT_OUT_8812F(x)                                       \
	(((x) >> BIT_SHIFT_DSS_3_COUNT_OUT_8812F) &                            \
	 BIT_MASK_DSS_3_COUNT_OUT_8812F)
#define BIT_SET_DSS_3_COUNT_OUT_8812F(x, v)                                    \
	(BIT_CLEAR_DSS_3_COUNT_OUT_8812F(x) | BIT_DSS_3_COUNT_OUT_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_COUNTER_CTRL_8812F */

#define BIT_SHIFT_COUNTER_BASE_8812F 16
#define BIT_MASK_COUNTER_BASE_8812F 0x1fff
#define BIT_COUNTER_BASE_8812F(x)                                              \
	(((x) & BIT_MASK_COUNTER_BASE_8812F) << BIT_SHIFT_COUNTER_BASE_8812F)
#define BITS_COUNTER_BASE_8812F                                                \
	(BIT_MASK_COUNTER_BASE_8812F << BIT_SHIFT_COUNTER_BASE_8812F)
#define BIT_CLEAR_COUNTER_BASE_8812F(x) ((x) & (~BITS_COUNTER_BASE_8812F))
#define BIT_GET_COUNTER_BASE_8812F(x)                                          \
	(((x) >> BIT_SHIFT_COUNTER_BASE_8812F) & BIT_MASK_COUNTER_BASE_8812F)
#define BIT_SET_COUNTER_BASE_8812F(x, v)                                       \
	(BIT_CLEAR_COUNTER_BASE_8812F(x) | BIT_COUNTER_BASE_8812F(v))

#define BIT_EN_RTS_REQ_8812F BIT(9)
#define BIT_EN_EDCA_REQ_8812F BIT(8)
#define BIT_EN_PTCL_REQ_8812F BIT(7)
#define BIT_EN_SCH_REQ_8812F BIT(6)
#define BIT_USB_COUNT_EN_8812F BIT(5)
#define BIT_PCIE_COUNT_EN_8812F BIT(4)
#define BIT_RQPN_COUNT_EN_8812F BIT(3)
#define BIT_RDE_COUNT_EN_8812F BIT(2)
#define BIT_TDE_COUNT_EN_8812F BIT(1)
#define BIT_DISABLE_COUNTER_8812F BIT(0)

/* 2 REG_COUNTER_THRESHOLD_8812F */
#define BIT_SEL_ALL_MACID_8812F BIT(31)

#define BIT_SHIFT_COUNTER_MACID_8812F 24
#define BIT_MASK_COUNTER_MACID_8812F 0x7f
#define BIT_COUNTER_MACID_8812F(x)                                             \
	(((x) & BIT_MASK_COUNTER_MACID_8812F) << BIT_SHIFT_COUNTER_MACID_8812F)
#define BITS_COUNTER_MACID_8812F                                               \
	(BIT_MASK_COUNTER_MACID_8812F << BIT_SHIFT_COUNTER_MACID_8812F)
#define BIT_CLEAR_COUNTER_MACID_8812F(x) ((x) & (~BITS_COUNTER_MACID_8812F))
#define BIT_GET_COUNTER_MACID_8812F(x)                                         \
	(((x) >> BIT_SHIFT_COUNTER_MACID_8812F) & BIT_MASK_COUNTER_MACID_8812F)
#define BIT_SET_COUNTER_MACID_8812F(x, v)                                      \
	(BIT_CLEAR_COUNTER_MACID_8812F(x) | BIT_COUNTER_MACID_8812F(v))

#define BIT_SHIFT_AGG_VALUE2_8812F 16
#define BIT_MASK_AGG_VALUE2_8812F 0x7f
#define BIT_AGG_VALUE2_8812F(x)                                                \
	(((x) & BIT_MASK_AGG_VALUE2_8812F) << BIT_SHIFT_AGG_VALUE2_8812F)
#define BITS_AGG_VALUE2_8812F                                                  \
	(BIT_MASK_AGG_VALUE2_8812F << BIT_SHIFT_AGG_VALUE2_8812F)
#define BIT_CLEAR_AGG_VALUE2_8812F(x) ((x) & (~BITS_AGG_VALUE2_8812F))
#define BIT_GET_AGG_VALUE2_8812F(x)                                            \
	(((x) >> BIT_SHIFT_AGG_VALUE2_8812F) & BIT_MASK_AGG_VALUE2_8812F)
#define BIT_SET_AGG_VALUE2_8812F(x, v)                                         \
	(BIT_CLEAR_AGG_VALUE2_8812F(x) | BIT_AGG_VALUE2_8812F(v))

#define BIT_SHIFT_AGG_VALUE1_8812F 8
#define BIT_MASK_AGG_VALUE1_8812F 0x7f
#define BIT_AGG_VALUE1_8812F(x)                                                \
	(((x) & BIT_MASK_AGG_VALUE1_8812F) << BIT_SHIFT_AGG_VALUE1_8812F)
#define BITS_AGG_VALUE1_8812F                                                  \
	(BIT_MASK_AGG_VALUE1_8812F << BIT_SHIFT_AGG_VALUE1_8812F)
#define BIT_CLEAR_AGG_VALUE1_8812F(x) ((x) & (~BITS_AGG_VALUE1_8812F))
#define BIT_GET_AGG_VALUE1_8812F(x)                                            \
	(((x) >> BIT_SHIFT_AGG_VALUE1_8812F) & BIT_MASK_AGG_VALUE1_8812F)
#define BIT_SET_AGG_VALUE1_8812F(x, v)                                         \
	(BIT_CLEAR_AGG_VALUE1_8812F(x) | BIT_AGG_VALUE1_8812F(v))

#define BIT_SHIFT_AGG_VALUE0_8812F 0
#define BIT_MASK_AGG_VALUE0_8812F 0x7f
#define BIT_AGG_VALUE0_8812F(x)                                                \
	(((x) & BIT_MASK_AGG_VALUE0_8812F) << BIT_SHIFT_AGG_VALUE0_8812F)
#define BITS_AGG_VALUE0_8812F                                                  \
	(BIT_MASK_AGG_VALUE0_8812F << BIT_SHIFT_AGG_VALUE0_8812F)
#define BIT_CLEAR_AGG_VALUE0_8812F(x) ((x) & (~BITS_AGG_VALUE0_8812F))
#define BIT_GET_AGG_VALUE0_8812F(x)                                            \
	(((x) >> BIT_SHIFT_AGG_VALUE0_8812F) & BIT_MASK_AGG_VALUE0_8812F)
#define BIT_SET_AGG_VALUE0_8812F(x, v)                                         \
	(BIT_CLEAR_AGG_VALUE0_8812F(x) | BIT_AGG_VALUE0_8812F(v))

/* 2 REG_COUNTER_SET_8812F */

#define BIT_SHIFT_REQUEST_RESET_8812F 16
#define BIT_MASK_REQUEST_RESET_8812F 0xffff
#define BIT_REQUEST_RESET_8812F(x)                                             \
	(((x) & BIT_MASK_REQUEST_RESET_8812F) << BIT_SHIFT_REQUEST_RESET_8812F)
#define BITS_REQUEST_RESET_8812F                                               \
	(BIT_MASK_REQUEST_RESET_8812F << BIT_SHIFT_REQUEST_RESET_8812F)
#define BIT_CLEAR_REQUEST_RESET_8812F(x) ((x) & (~BITS_REQUEST_RESET_8812F))
#define BIT_GET_REQUEST_RESET_8812F(x)                                         \
	(((x) >> BIT_SHIFT_REQUEST_RESET_8812F) & BIT_MASK_REQUEST_RESET_8812F)
#define BIT_SET_REQUEST_RESET_8812F(x, v)                                      \
	(BIT_CLEAR_REQUEST_RESET_8812F(x) | BIT_REQUEST_RESET_8812F(v))

#define BIT_SHIFT_REQUEST_START_8812F 0
#define BIT_MASK_REQUEST_START_8812F 0xffff
#define BIT_REQUEST_START_8812F(x)                                             \
	(((x) & BIT_MASK_REQUEST_START_8812F) << BIT_SHIFT_REQUEST_START_8812F)
#define BITS_REQUEST_START_8812F                                               \
	(BIT_MASK_REQUEST_START_8812F << BIT_SHIFT_REQUEST_START_8812F)
#define BIT_CLEAR_REQUEST_START_8812F(x) ((x) & (~BITS_REQUEST_START_8812F))
#define BIT_GET_REQUEST_START_8812F(x)                                         \
	(((x) >> BIT_SHIFT_REQUEST_START_8812F) & BIT_MASK_REQUEST_START_8812F)
#define BIT_SET_REQUEST_START_8812F(x, v)                                      \
	(BIT_CLEAR_REQUEST_START_8812F(x) | BIT_REQUEST_START_8812F(v))

/* 2 REG_COUNTER_OVERFLOW_8812F */

#define BIT_SHIFT_CNT_OVF_REG_8812F 0
#define BIT_MASK_CNT_OVF_REG_8812F 0xffff
#define BIT_CNT_OVF_REG_8812F(x)                                               \
	(((x) & BIT_MASK_CNT_OVF_REG_8812F) << BIT_SHIFT_CNT_OVF_REG_8812F)
#define BITS_CNT_OVF_REG_8812F                                                 \
	(BIT_MASK_CNT_OVF_REG_8812F << BIT_SHIFT_CNT_OVF_REG_8812F)
#define BIT_CLEAR_CNT_OVF_REG_8812F(x) ((x) & (~BITS_CNT_OVF_REG_8812F))
#define BIT_GET_CNT_OVF_REG_8812F(x)                                           \
	(((x) >> BIT_SHIFT_CNT_OVF_REG_8812F) & BIT_MASK_CNT_OVF_REG_8812F)
#define BIT_SET_CNT_OVF_REG_8812F(x, v)                                        \
	(BIT_CLEAR_CNT_OVF_REG_8812F(x) | BIT_CNT_OVF_REG_8812F(v))

/* 2 REG_TXDMA_LEN_THRESHOLD_8812F */

#define BIT_SHIFT_TDE_LEN_TH1_8812F 16
#define BIT_MASK_TDE_LEN_TH1_8812F 0xffff
#define BIT_TDE_LEN_TH1_8812F(x)                                               \
	(((x) & BIT_MASK_TDE_LEN_TH1_8812F) << BIT_SHIFT_TDE_LEN_TH1_8812F)
#define BITS_TDE_LEN_TH1_8812F                                                 \
	(BIT_MASK_TDE_LEN_TH1_8812F << BIT_SHIFT_TDE_LEN_TH1_8812F)
#define BIT_CLEAR_TDE_LEN_TH1_8812F(x) ((x) & (~BITS_TDE_LEN_TH1_8812F))
#define BIT_GET_TDE_LEN_TH1_8812F(x)                                           \
	(((x) >> BIT_SHIFT_TDE_LEN_TH1_8812F) & BIT_MASK_TDE_LEN_TH1_8812F)
#define BIT_SET_TDE_LEN_TH1_8812F(x, v)                                        \
	(BIT_CLEAR_TDE_LEN_TH1_8812F(x) | BIT_TDE_LEN_TH1_8812F(v))

#define BIT_SHIFT_TDE_LEN_TH0_8812F 0
#define BIT_MASK_TDE_LEN_TH0_8812F 0xffff
#define BIT_TDE_LEN_TH0_8812F(x)                                               \
	(((x) & BIT_MASK_TDE_LEN_TH0_8812F) << BIT_SHIFT_TDE_LEN_TH0_8812F)
#define BITS_TDE_LEN_TH0_8812F                                                 \
	(BIT_MASK_TDE_LEN_TH0_8812F << BIT_SHIFT_TDE_LEN_TH0_8812F)
#define BIT_CLEAR_TDE_LEN_TH0_8812F(x) ((x) & (~BITS_TDE_LEN_TH0_8812F))
#define BIT_GET_TDE_LEN_TH0_8812F(x)                                           \
	(((x) >> BIT_SHIFT_TDE_LEN_TH0_8812F) & BIT_MASK_TDE_LEN_TH0_8812F)
#define BIT_SET_TDE_LEN_TH0_8812F(x, v)                                        \
	(BIT_CLEAR_TDE_LEN_TH0_8812F(x) | BIT_TDE_LEN_TH0_8812F(v))

/* 2 REG_RXDMA_LEN_THRESHOLD_8812F */

#define BIT_SHIFT_RDE_LEN_TH1_8812F 16
#define BIT_MASK_RDE_LEN_TH1_8812F 0xffff
#define BIT_RDE_LEN_TH1_8812F(x)                                               \
	(((x) & BIT_MASK_RDE_LEN_TH1_8812F) << BIT_SHIFT_RDE_LEN_TH1_8812F)
#define BITS_RDE_LEN_TH1_8812F                                                 \
	(BIT_MASK_RDE_LEN_TH1_8812F << BIT_SHIFT_RDE_LEN_TH1_8812F)
#define BIT_CLEAR_RDE_LEN_TH1_8812F(x) ((x) & (~BITS_RDE_LEN_TH1_8812F))
#define BIT_GET_RDE_LEN_TH1_8812F(x)                                           \
	(((x) >> BIT_SHIFT_RDE_LEN_TH1_8812F) & BIT_MASK_RDE_LEN_TH1_8812F)
#define BIT_SET_RDE_LEN_TH1_8812F(x, v)                                        \
	(BIT_CLEAR_RDE_LEN_TH1_8812F(x) | BIT_RDE_LEN_TH1_8812F(v))

#define BIT_SHIFT_RDE_LEN_TH0_8812F 0
#define BIT_MASK_RDE_LEN_TH0_8812F 0xffff
#define BIT_RDE_LEN_TH0_8812F(x)                                               \
	(((x) & BIT_MASK_RDE_LEN_TH0_8812F) << BIT_SHIFT_RDE_LEN_TH0_8812F)
#define BITS_RDE_LEN_TH0_8812F                                                 \
	(BIT_MASK_RDE_LEN_TH0_8812F << BIT_SHIFT_RDE_LEN_TH0_8812F)
#define BIT_CLEAR_RDE_LEN_TH0_8812F(x) ((x) & (~BITS_RDE_LEN_TH0_8812F))
#define BIT_GET_RDE_LEN_TH0_8812F(x)                                           \
	(((x) >> BIT_SHIFT_RDE_LEN_TH0_8812F) & BIT_MASK_RDE_LEN_TH0_8812F)
#define BIT_SET_RDE_LEN_TH0_8812F(x, v)                                        \
	(BIT_CLEAR_RDE_LEN_TH0_8812F(x) | BIT_RDE_LEN_TH0_8812F(v))

/* 2 REG_PCIE_EXEC_TIME_THRESHOLD_8812F */

#define BIT_SHIFT_COUNT_INT_SEL_8812F 16
#define BIT_MASK_COUNT_INT_SEL_8812F 0x3
#define BIT_COUNT_INT_SEL_8812F(x)                                             \
	(((x) & BIT_MASK_COUNT_INT_SEL_8812F) << BIT_SHIFT_COUNT_INT_SEL_8812F)
#define BITS_COUNT_INT_SEL_8812F                                               \
	(BIT_MASK_COUNT_INT_SEL_8812F << BIT_SHIFT_COUNT_INT_SEL_8812F)
#define BIT_CLEAR_COUNT_INT_SEL_8812F(x) ((x) & (~BITS_COUNT_INT_SEL_8812F))
#define BIT_GET_COUNT_INT_SEL_8812F(x)                                         \
	(((x) >> BIT_SHIFT_COUNT_INT_SEL_8812F) & BIT_MASK_COUNT_INT_SEL_8812F)
#define BIT_SET_COUNT_INT_SEL_8812F(x, v)                                      \
	(BIT_CLEAR_COUNT_INT_SEL_8812F(x) | BIT_COUNT_INT_SEL_8812F(v))

#define BIT_SHIFT_EXEC_TIME_TH_8812F 0
#define BIT_MASK_EXEC_TIME_TH_8812F 0xffff
#define BIT_EXEC_TIME_TH_8812F(x)                                              \
	(((x) & BIT_MASK_EXEC_TIME_TH_8812F) << BIT_SHIFT_EXEC_TIME_TH_8812F)
#define BITS_EXEC_TIME_TH_8812F                                                \
	(BIT_MASK_EXEC_TIME_TH_8812F << BIT_SHIFT_EXEC_TIME_TH_8812F)
#define BIT_CLEAR_EXEC_TIME_TH_8812F(x) ((x) & (~BITS_EXEC_TIME_TH_8812F))
#define BIT_GET_EXEC_TIME_TH_8812F(x)                                          \
	(((x) >> BIT_SHIFT_EXEC_TIME_TH_8812F) & BIT_MASK_EXEC_TIME_TH_8812F)
#define BIT_SET_EXEC_TIME_TH_8812F(x, v)                                       \
	(BIT_CLEAR_EXEC_TIME_TH_8812F(x) | BIT_EXEC_TIME_TH_8812F(v))

/* 2 REG_FT2IMR_8812F */
#define BIT_FS_CLI3_RX_UAPSDMD1_EN_8812F BIT(31)
#define BIT_FS_CLI3_RX_UAPSDMD0_EN_8812F BIT(30)
#define BIT_FS_CLI3_TRIGGER_PKT_EN_8812F BIT(29)
#define BIT_FS_CLI3_EOSP_INT_EN_8812F BIT(28)
#define BIT_FS_CLI2_RX_UAPSDMD1_EN_8812F BIT(27)
#define BIT_FS_CLI2_RX_UAPSDMD0_EN_8812F BIT(26)
#define BIT_FS_CLI2_TRIGGER_PKT_EN_8812F BIT(25)
#define BIT_FS_CLI2_EOSP_INT_EN_8812F BIT(24)
#define BIT_FS_CLI1_RX_UAPSDMD1_EN_8812F BIT(23)
#define BIT_FS_CLI1_RX_UAPSDMD0_EN_8812F BIT(22)
#define BIT_FS_CLI1_TRIGGER_PKT_EN_8812F BIT(21)
#define BIT_FS_CLI1_EOSP_INT_EN_8812F BIT(20)
#define BIT_FS_CLI0_RX_UAPSDMD1_EN_8812F BIT(19)
#define BIT_FS_CLI0_RX_UAPSDMD0_EN_8812F BIT(18)
#define BIT_FS_CLI0_TRIGGER_PKT_EN_8812F BIT(17)
#define BIT_FS_CLI0_EOSP_INT_EN_8812F BIT(16)
#define BIT_FS_TSF_BIT32_TOGGLE_P2P2_EN_8812F BIT(9)
#define BIT_FS_TSF_BIT32_TOGGLE_P2P1_EN_8812F BIT(8)
#define BIT_FS_CLI3_TX_NULL1_INT_EN_8812F BIT(7)
#define BIT_FS_CLI3_TX_NULL0_INT_EN_8812F BIT(6)
#define BIT_FS_CLI2_TX_NULL1_INT_EN_8812F BIT(5)
#define BIT_FS_CLI2_TX_NULL0_INT_EN_8812F BIT(4)
#define BIT_FS_CLI1_TX_NULL1_INT_EN_8812F BIT(3)
#define BIT_FS_CLI1_TX_NULL0_INT_EN_8812F BIT(2)
#define BIT_FS_CLI0_TX_NULL1_INT_EN_8812F BIT(1)
#define BIT_FS_CLI0_TX_NULL0_INT_EN_8812F BIT(0)

/* 2 REG_FT2ISR_8812F */
#define BIT_FS_CLI3_RX_UAPSDMD1_INT_8812F BIT(31)
#define BIT_FS_CLI3_RX_UAPSDMD0_INT_8812F BIT(30)
#define BIT_FS_CLI3_TRIGGER_PKT_INT_8812F BIT(29)
#define BIT_FS_CLI3_EOSP_INT_8812F BIT(28)
#define BIT_FS_CLI2_RX_UAPSDMD1_INT_8812F BIT(27)
#define BIT_FS_CLI2_RX_UAPSDMD0_INT_8812F BIT(26)
#define BIT_FS_CLI2_TRIGGER_PKT_INT_8812F BIT(25)
#define BIT_FS_CLI2_EOSP_INT_8812F BIT(24)
#define BIT_FS_CLI1_RX_UAPSDMD1_INT_8812F BIT(23)
#define BIT_FS_CLI1_RX_UAPSDMD0_INT_8812F BIT(22)
#define BIT_FS_CLI1_TRIGGER_PKT_INT_8812F BIT(21)
#define BIT_FS_CLI1_EOSP_INT_8812F BIT(20)
#define BIT_FS_CLI0_RX_UAPSDMD1_INT_8812F BIT(19)
#define BIT_FS_CLI0_RX_UAPSDMD0_INT_8812F BIT(18)
#define BIT_FS_CLI0_TRIGGER_PKT_INT_8812F BIT(17)
#define BIT_FS_CLI0_EOSP_INT_8812F BIT(16)
#define BIT_FS_TSF_BIT32_TOGGLE_P2P2_INT_8812F BIT(9)
#define BIT_FS_TSF_BIT32_TOGGLE_P2P1_INT_8812F BIT(8)
#define BIT_FS_CLI3_TX_NULL1_INT_8812F BIT(7)
#define BIT_FS_CLI3_TX_NULL0_INT_8812F BIT(6)
#define BIT_FS_CLI2_TX_NULL1_INT_8812F BIT(5)
#define BIT_FS_CLI2_TX_NULL0_INT_8812F BIT(4)
#define BIT_FS_CLI1_TX_NULL1_INT_8812F BIT(3)
#define BIT_FS_CLI1_TX_NULL0_INT_8812F BIT(2)
#define BIT_FS_CLI0_TX_NULL1_INT_8812F BIT(1)
#define BIT_FS_CLI0_TX_NULL0_INT_8812F BIT(0)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_MSG2_8812F */

#define BIT_SHIFT_FW_MSG2_8812F 0
#define BIT_MASK_FW_MSG2_8812F 0xffffffffL
#define BIT_FW_MSG2_8812F(x)                                                   \
	(((x) & BIT_MASK_FW_MSG2_8812F) << BIT_SHIFT_FW_MSG2_8812F)
#define BITS_FW_MSG2_8812F (BIT_MASK_FW_MSG2_8812F << BIT_SHIFT_FW_MSG2_8812F)
#define BIT_CLEAR_FW_MSG2_8812F(x) ((x) & (~BITS_FW_MSG2_8812F))
#define BIT_GET_FW_MSG2_8812F(x)                                               \
	(((x) >> BIT_SHIFT_FW_MSG2_8812F) & BIT_MASK_FW_MSG2_8812F)
#define BIT_SET_FW_MSG2_8812F(x, v)                                            \
	(BIT_CLEAR_FW_MSG2_8812F(x) | BIT_FW_MSG2_8812F(v))

/* 2 REG_MSG3_8812F */

#define BIT_SHIFT_FW_MSG3_8812F 0
#define BIT_MASK_FW_MSG3_8812F 0xffffffffL
#define BIT_FW_MSG3_8812F(x)                                                   \
	(((x) & BIT_MASK_FW_MSG3_8812F) << BIT_SHIFT_FW_MSG3_8812F)
#define BITS_FW_MSG3_8812F (BIT_MASK_FW_MSG3_8812F << BIT_SHIFT_FW_MSG3_8812F)
#define BIT_CLEAR_FW_MSG3_8812F(x) ((x) & (~BITS_FW_MSG3_8812F))
#define BIT_GET_FW_MSG3_8812F(x)                                               \
	(((x) >> BIT_SHIFT_FW_MSG3_8812F) & BIT_MASK_FW_MSG3_8812F)
#define BIT_SET_FW_MSG3_8812F(x, v)                                            \
	(BIT_CLEAR_FW_MSG3_8812F(x) | BIT_FW_MSG3_8812F(v))

/* 2 REG_MSG4_8812F */

#define BIT_SHIFT_FW_MSG4_8812F 0
#define BIT_MASK_FW_MSG4_8812F 0xffffffffL
#define BIT_FW_MSG4_8812F(x)                                                   \
	(((x) & BIT_MASK_FW_MSG4_8812F) << BIT_SHIFT_FW_MSG4_8812F)
#define BITS_FW_MSG4_8812F (BIT_MASK_FW_MSG4_8812F << BIT_SHIFT_FW_MSG4_8812F)
#define BIT_CLEAR_FW_MSG4_8812F(x) ((x) & (~BITS_FW_MSG4_8812F))
#define BIT_GET_FW_MSG4_8812F(x)                                               \
	(((x) >> BIT_SHIFT_FW_MSG4_8812F) & BIT_MASK_FW_MSG4_8812F)
#define BIT_SET_FW_MSG4_8812F(x, v)                                            \
	(BIT_CLEAR_FW_MSG4_8812F(x) | BIT_FW_MSG4_8812F(v))

/* 2 REG_MSG5_8812F */

#define BIT_SHIFT_FW_MSG5_8812F 0
#define BIT_MASK_FW_MSG5_8812F 0xffffffffL
#define BIT_FW_MSG5_8812F(x)                                                   \
	(((x) & BIT_MASK_FW_MSG5_8812F) << BIT_SHIFT_FW_MSG5_8812F)
#define BITS_FW_MSG5_8812F (BIT_MASK_FW_MSG5_8812F << BIT_SHIFT_FW_MSG5_8812F)
#define BIT_CLEAR_FW_MSG5_8812F(x) ((x) & (~BITS_FW_MSG5_8812F))
#define BIT_GET_FW_MSG5_8812F(x)                                               \
	(((x) >> BIT_SHIFT_FW_MSG5_8812F) & BIT_MASK_FW_MSG5_8812F)
#define BIT_SET_FW_MSG5_8812F(x, v)                                            \
	(BIT_CLEAR_FW_MSG5_8812F(x) | BIT_FW_MSG5_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_FIFOPAGE_CTRL_1_8812F */

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_TX_OQT_HE_FREE_SPACE_V1_8812F 16
#define BIT_MASK_TX_OQT_HE_FREE_SPACE_V1_8812F 0xff
#define BIT_TX_OQT_HE_FREE_SPACE_V1_8812F(x)                                   \
	(((x) & BIT_MASK_TX_OQT_HE_FREE_SPACE_V1_8812F)                        \
	 << BIT_SHIFT_TX_OQT_HE_FREE_SPACE_V1_8812F)
#define BITS_TX_OQT_HE_FREE_SPACE_V1_8812F                                     \
	(BIT_MASK_TX_OQT_HE_FREE_SPACE_V1_8812F                                \
	 << BIT_SHIFT_TX_OQT_HE_FREE_SPACE_V1_8812F)
#define BIT_CLEAR_TX_OQT_HE_FREE_SPACE_V1_8812F(x)                             \
	((x) & (~BITS_TX_OQT_HE_FREE_SPACE_V1_8812F))
#define BIT_GET_TX_OQT_HE_FREE_SPACE_V1_8812F(x)                               \
	(((x) >> BIT_SHIFT_TX_OQT_HE_FREE_SPACE_V1_8812F) &                    \
	 BIT_MASK_TX_OQT_HE_FREE_SPACE_V1_8812F)
#define BIT_SET_TX_OQT_HE_FREE_SPACE_V1_8812F(x, v)                            \
	(BIT_CLEAR_TX_OQT_HE_FREE_SPACE_V1_8812F(x) |                          \
	 BIT_TX_OQT_HE_FREE_SPACE_V1_8812F(v))

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_TX_OQT_NL_FREE_SPACE_V1_8812F 0
#define BIT_MASK_TX_OQT_NL_FREE_SPACE_V1_8812F 0xff
#define BIT_TX_OQT_NL_FREE_SPACE_V1_8812F(x)                                   \
	(((x) & BIT_MASK_TX_OQT_NL_FREE_SPACE_V1_8812F)                        \
	 << BIT_SHIFT_TX_OQT_NL_FREE_SPACE_V1_8812F)
#define BITS_TX_OQT_NL_FREE_SPACE_V1_8812F                                     \
	(BIT_MASK_TX_OQT_NL_FREE_SPACE_V1_8812F                                \
	 << BIT_SHIFT_TX_OQT_NL_FREE_SPACE_V1_8812F)
#define BIT_CLEAR_TX_OQT_NL_FREE_SPACE_V1_8812F(x)                             \
	((x) & (~BITS_TX_OQT_NL_FREE_SPACE_V1_8812F))
#define BIT_GET_TX_OQT_NL_FREE_SPACE_V1_8812F(x)                               \
	(((x) >> BIT_SHIFT_TX_OQT_NL_FREE_SPACE_V1_8812F) &                    \
	 BIT_MASK_TX_OQT_NL_FREE_SPACE_V1_8812F)
#define BIT_SET_TX_OQT_NL_FREE_SPACE_V1_8812F(x, v)                            \
	(BIT_CLEAR_TX_OQT_NL_FREE_SPACE_V1_8812F(x) |                          \
	 BIT_TX_OQT_NL_FREE_SPACE_V1_8812F(v))

/* 2 REG_FIFOPAGE_CTRL_2_8812F */
#define BIT_BCN_VALID_1_V1_8812F BIT(31)

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_BCN_HEAD_1_V1_8812F 16
#define BIT_MASK_BCN_HEAD_1_V1_8812F 0xfff
#define BIT_BCN_HEAD_1_V1_8812F(x)                                             \
	(((x) & BIT_MASK_BCN_HEAD_1_V1_8812F) << BIT_SHIFT_BCN_HEAD_1_V1_8812F)
#define BITS_BCN_HEAD_1_V1_8812F                                               \
	(BIT_MASK_BCN_HEAD_1_V1_8812F << BIT_SHIFT_BCN_HEAD_1_V1_8812F)
#define BIT_CLEAR_BCN_HEAD_1_V1_8812F(x) ((x) & (~BITS_BCN_HEAD_1_V1_8812F))
#define BIT_GET_BCN_HEAD_1_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_BCN_HEAD_1_V1_8812F) & BIT_MASK_BCN_HEAD_1_V1_8812F)
#define BIT_SET_BCN_HEAD_1_V1_8812F(x, v)                                      \
	(BIT_CLEAR_BCN_HEAD_1_V1_8812F(x) | BIT_BCN_HEAD_1_V1_8812F(v))

#define BIT_BCN_VALID_V1_8812F BIT(15)

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_BCN_HEAD_V1_8812F 0
#define BIT_MASK_BCN_HEAD_V1_8812F 0xfff
#define BIT_BCN_HEAD_V1_8812F(x)                                               \
	(((x) & BIT_MASK_BCN_HEAD_V1_8812F) << BIT_SHIFT_BCN_HEAD_V1_8812F)
#define BITS_BCN_HEAD_V1_8812F                                                 \
	(BIT_MASK_BCN_HEAD_V1_8812F << BIT_SHIFT_BCN_HEAD_V1_8812F)
#define BIT_CLEAR_BCN_HEAD_V1_8812F(x) ((x) & (~BITS_BCN_HEAD_V1_8812F))
#define BIT_GET_BCN_HEAD_V1_8812F(x)                                           \
	(((x) >> BIT_SHIFT_BCN_HEAD_V1_8812F) & BIT_MASK_BCN_HEAD_V1_8812F)
#define BIT_SET_BCN_HEAD_V1_8812F(x, v)                                        \
	(BIT_CLEAR_BCN_HEAD_V1_8812F(x) | BIT_BCN_HEAD_V1_8812F(v))

/* 2 REG_AUTO_LLT_V1_8812F */

#define BIT_SHIFT_MAX_TX_PKT_V1_8812F 24
#define BIT_MASK_MAX_TX_PKT_V1_8812F 0xff
#define BIT_MAX_TX_PKT_V1_8812F(x)                                             \
	(((x) & BIT_MASK_MAX_TX_PKT_V1_8812F) << BIT_SHIFT_MAX_TX_PKT_V1_8812F)
#define BITS_MAX_TX_PKT_V1_8812F                                               \
	(BIT_MASK_MAX_TX_PKT_V1_8812F << BIT_SHIFT_MAX_TX_PKT_V1_8812F)
#define BIT_CLEAR_MAX_TX_PKT_V1_8812F(x) ((x) & (~BITS_MAX_TX_PKT_V1_8812F))
#define BIT_GET_MAX_TX_PKT_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_MAX_TX_PKT_V1_8812F) & BIT_MASK_MAX_TX_PKT_V1_8812F)
#define BIT_SET_MAX_TX_PKT_V1_8812F(x, v)                                      \
	(BIT_CLEAR_MAX_TX_PKT_V1_8812F(x) | BIT_MAX_TX_PKT_V1_8812F(v))

#define BIT_TDE_ERROR_STOP_V1_8812F BIT(23)

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_LLT_FREE_PAGE_V2_8812F 8
#define BIT_MASK_LLT_FREE_PAGE_V2_8812F 0xfff
#define BIT_LLT_FREE_PAGE_V2_8812F(x)                                          \
	(((x) & BIT_MASK_LLT_FREE_PAGE_V2_8812F)                               \
	 << BIT_SHIFT_LLT_FREE_PAGE_V2_8812F)
#define BITS_LLT_FREE_PAGE_V2_8812F                                            \
	(BIT_MASK_LLT_FREE_PAGE_V2_8812F << BIT_SHIFT_LLT_FREE_PAGE_V2_8812F)
#define BIT_CLEAR_LLT_FREE_PAGE_V2_8812F(x)                                    \
	((x) & (~BITS_LLT_FREE_PAGE_V2_8812F))
#define BIT_GET_LLT_FREE_PAGE_V2_8812F(x)                                      \
	(((x) >> BIT_SHIFT_LLT_FREE_PAGE_V2_8812F) &                           \
	 BIT_MASK_LLT_FREE_PAGE_V2_8812F)
#define BIT_SET_LLT_FREE_PAGE_V2_8812F(x, v)                                   \
	(BIT_CLEAR_LLT_FREE_PAGE_V2_8812F(x) | BIT_LLT_FREE_PAGE_V2_8812F(v))

#define BIT_SHIFT_BLK_DESC_NUM_8812F 4
#define BIT_MASK_BLK_DESC_NUM_8812F 0xf
#define BIT_BLK_DESC_NUM_8812F(x)                                              \
	(((x) & BIT_MASK_BLK_DESC_NUM_8812F) << BIT_SHIFT_BLK_DESC_NUM_8812F)
#define BITS_BLK_DESC_NUM_8812F                                                \
	(BIT_MASK_BLK_DESC_NUM_8812F << BIT_SHIFT_BLK_DESC_NUM_8812F)
#define BIT_CLEAR_BLK_DESC_NUM_8812F(x) ((x) & (~BITS_BLK_DESC_NUM_8812F))
#define BIT_GET_BLK_DESC_NUM_8812F(x)                                          \
	(((x) >> BIT_SHIFT_BLK_DESC_NUM_8812F) & BIT_MASK_BLK_DESC_NUM_8812F)
#define BIT_SET_BLK_DESC_NUM_8812F(x, v)                                       \
	(BIT_CLEAR_BLK_DESC_NUM_8812F(x) | BIT_BLK_DESC_NUM_8812F(v))

#define BIT_R_BCN_HEAD_SEL_8812F BIT(3)
#define BIT_R_EN_BCN_SW_HEAD_SEL_8812F BIT(2)
#define BIT_LLT_DBG_SEL_8812F BIT(1)
#define BIT_AUTO_INIT_LLT_V1_8812F BIT(0)

/* 2 REG_TXDMA_OFFSET_CHK_8812F */
#define BIT_EM_CHKSUM_FIN_8812F BIT(31)
#define BIT_EMN_PCIE_DMA_MOD_8812F BIT(30)
#define BIT_EN_TXQUE_CLR_8812F BIT(29)
#define BIT_EN_PCIE_FIFO_MODE_8812F BIT(28)

#define BIT_SHIFT_PG_UNDER_TH_V1_8812F 16
#define BIT_MASK_PG_UNDER_TH_V1_8812F 0xfff
#define BIT_PG_UNDER_TH_V1_8812F(x)                                            \
	(((x) & BIT_MASK_PG_UNDER_TH_V1_8812F)                                 \
	 << BIT_SHIFT_PG_UNDER_TH_V1_8812F)
#define BITS_PG_UNDER_TH_V1_8812F                                              \
	(BIT_MASK_PG_UNDER_TH_V1_8812F << BIT_SHIFT_PG_UNDER_TH_V1_8812F)
#define BIT_CLEAR_PG_UNDER_TH_V1_8812F(x) ((x) & (~BITS_PG_UNDER_TH_V1_8812F))
#define BIT_GET_PG_UNDER_TH_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_PG_UNDER_TH_V1_8812F) &                             \
	 BIT_MASK_PG_UNDER_TH_V1_8812F)
#define BIT_SET_PG_UNDER_TH_V1_8812F(x, v)                                     \
	(BIT_CLEAR_PG_UNDER_TH_V1_8812F(x) | BIT_PG_UNDER_TH_V1_8812F(v))

#define BIT_R_EN_RESET_RESTORE_H2C_8812F BIT(15)
#define BIT_SDIO_TDE_FINISH_8812F BIT(14)
#define BIT_SDIO_TXDESC_CHKSUM_EN_8812F BIT(13)
#define BIT_RST_RDPTR_8812F BIT(12)
#define BIT_RST_WRPTR_8812F BIT(11)
#define BIT_CHK_PG_TH_EN_8812F BIT(10)
#define BIT_DROP_DATA_EN_8812F BIT(9)
#define BIT_CHECK_OFFSET_EN_8812F BIT(8)

#define BIT_SHIFT_CHECK_OFFSET_8812F 0
#define BIT_MASK_CHECK_OFFSET_8812F 0xff
#define BIT_CHECK_OFFSET_8812F(x)                                              \
	(((x) & BIT_MASK_CHECK_OFFSET_8812F) << BIT_SHIFT_CHECK_OFFSET_8812F)
#define BITS_CHECK_OFFSET_8812F                                                \
	(BIT_MASK_CHECK_OFFSET_8812F << BIT_SHIFT_CHECK_OFFSET_8812F)
#define BIT_CLEAR_CHECK_OFFSET_8812F(x) ((x) & (~BITS_CHECK_OFFSET_8812F))
#define BIT_GET_CHECK_OFFSET_8812F(x)                                          \
	(((x) >> BIT_SHIFT_CHECK_OFFSET_8812F) & BIT_MASK_CHECK_OFFSET_8812F)
#define BIT_SET_CHECK_OFFSET_8812F(x, v)                                       \
	(BIT_CLEAR_CHECK_OFFSET_8812F(x) | BIT_CHECK_OFFSET_8812F(v))

/* 2 REG_TXDMA_STATUS_8812F */
#define BIT_TXPKTBUF_REQ_ERR_8812F BIT(18)
#define BIT_HI_OQT_UDN_8812F BIT(17)
#define BIT_HI_OQT_OVF_8812F BIT(16)
#define BIT_PAYLOAD_CHKSUM_ERR_8812F BIT(15)
#define BIT_PAYLOAD_UDN_8812F BIT(14)
#define BIT_PAYLOAD_OVF_8812F BIT(13)
#define BIT_DSC_CHKSUM_FAIL_8812F BIT(12)
#define BIT_UNKNOWN_QSEL_8812F BIT(11)
#define BIT_EP_QSEL_DIFF_8812F BIT(10)
#define BIT_TX_OFFS_UNMATCH_8812F BIT(9)
#define BIT_TXOQT_UDN_8812F BIT(8)
#define BIT_TXOQT_OVF_8812F BIT(7)
#define BIT_TXDMA_SFF_UDN_8812F BIT(6)
#define BIT_TXDMA_SFF_OVF_8812F BIT(5)
#define BIT_LLT_NULL_PG_8812F BIT(4)
#define BIT_PAGE_UDN_8812F BIT(3)
#define BIT_PAGE_OVF_8812F BIT(2)
#define BIT_TXFF_PG_UDN_8812F BIT(1)
#define BIT_TXFF_PG_OVF_8812F BIT(0)

/* 2 REG_TX_DMA_DBG_8812F */

/* 2 REG_TQPNT1_8812F */
#define BIT_HPQ_INT_EN_8812F BIT(31)

#define BIT_SHIFT_HPQ_HIGH_TH_V1_8812F 16
#define BIT_MASK_HPQ_HIGH_TH_V1_8812F 0xfff
#define BIT_HPQ_HIGH_TH_V1_8812F(x)                                            \
	(((x) & BIT_MASK_HPQ_HIGH_TH_V1_8812F)                                 \
	 << BIT_SHIFT_HPQ_HIGH_TH_V1_8812F)
#define BITS_HPQ_HIGH_TH_V1_8812F                                              \
	(BIT_MASK_HPQ_HIGH_TH_V1_8812F << BIT_SHIFT_HPQ_HIGH_TH_V1_8812F)
#define BIT_CLEAR_HPQ_HIGH_TH_V1_8812F(x) ((x) & (~BITS_HPQ_HIGH_TH_V1_8812F))
#define BIT_GET_HPQ_HIGH_TH_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HPQ_HIGH_TH_V1_8812F) &                             \
	 BIT_MASK_HPQ_HIGH_TH_V1_8812F)
#define BIT_SET_HPQ_HIGH_TH_V1_8812F(x, v)                                     \
	(BIT_CLEAR_HPQ_HIGH_TH_V1_8812F(x) | BIT_HPQ_HIGH_TH_V1_8812F(v))

#define BIT_SHIFT_HPQ_LOW_TH_V1_8812F 0
#define BIT_MASK_HPQ_LOW_TH_V1_8812F 0xfff
#define BIT_HPQ_LOW_TH_V1_8812F(x)                                             \
	(((x) & BIT_MASK_HPQ_LOW_TH_V1_8812F) << BIT_SHIFT_HPQ_LOW_TH_V1_8812F)
#define BITS_HPQ_LOW_TH_V1_8812F                                               \
	(BIT_MASK_HPQ_LOW_TH_V1_8812F << BIT_SHIFT_HPQ_LOW_TH_V1_8812F)
#define BIT_CLEAR_HPQ_LOW_TH_V1_8812F(x) ((x) & (~BITS_HPQ_LOW_TH_V1_8812F))
#define BIT_GET_HPQ_LOW_TH_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_HPQ_LOW_TH_V1_8812F) & BIT_MASK_HPQ_LOW_TH_V1_8812F)
#define BIT_SET_HPQ_LOW_TH_V1_8812F(x, v)                                      \
	(BIT_CLEAR_HPQ_LOW_TH_V1_8812F(x) | BIT_HPQ_LOW_TH_V1_8812F(v))

/* 2 REG_TQPNT2_8812F */
#define BIT_NPQ_INT_EN_8812F BIT(31)

#define BIT_SHIFT_NPQ_HIGH_TH_V1_8812F 16
#define BIT_MASK_NPQ_HIGH_TH_V1_8812F 0xfff
#define BIT_NPQ_HIGH_TH_V1_8812F(x)                                            \
	(((x) & BIT_MASK_NPQ_HIGH_TH_V1_8812F)                                 \
	 << BIT_SHIFT_NPQ_HIGH_TH_V1_8812F)
#define BITS_NPQ_HIGH_TH_V1_8812F                                              \
	(BIT_MASK_NPQ_HIGH_TH_V1_8812F << BIT_SHIFT_NPQ_HIGH_TH_V1_8812F)
#define BIT_CLEAR_NPQ_HIGH_TH_V1_8812F(x) ((x) & (~BITS_NPQ_HIGH_TH_V1_8812F))
#define BIT_GET_NPQ_HIGH_TH_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_NPQ_HIGH_TH_V1_8812F) &                             \
	 BIT_MASK_NPQ_HIGH_TH_V1_8812F)
#define BIT_SET_NPQ_HIGH_TH_V1_8812F(x, v)                                     \
	(BIT_CLEAR_NPQ_HIGH_TH_V1_8812F(x) | BIT_NPQ_HIGH_TH_V1_8812F(v))

#define BIT_SHIFT_NPQ_LOW_TH_V1_8812F 0
#define BIT_MASK_NPQ_LOW_TH_V1_8812F 0xfff
#define BIT_NPQ_LOW_TH_V1_8812F(x)                                             \
	(((x) & BIT_MASK_NPQ_LOW_TH_V1_8812F) << BIT_SHIFT_NPQ_LOW_TH_V1_8812F)
#define BITS_NPQ_LOW_TH_V1_8812F                                               \
	(BIT_MASK_NPQ_LOW_TH_V1_8812F << BIT_SHIFT_NPQ_LOW_TH_V1_8812F)
#define BIT_CLEAR_NPQ_LOW_TH_V1_8812F(x) ((x) & (~BITS_NPQ_LOW_TH_V1_8812F))
#define BIT_GET_NPQ_LOW_TH_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_NPQ_LOW_TH_V1_8812F) & BIT_MASK_NPQ_LOW_TH_V1_8812F)
#define BIT_SET_NPQ_LOW_TH_V1_8812F(x, v)                                      \
	(BIT_CLEAR_NPQ_LOW_TH_V1_8812F(x) | BIT_NPQ_LOW_TH_V1_8812F(v))

/* 2 REG_TQPNT3_8812F */
#define BIT_LPQ_INT_EN_8812F BIT(31)

#define BIT_SHIFT_LPQ_HIGH_TH_V1_8812F 16
#define BIT_MASK_LPQ_HIGH_TH_V1_8812F 0xfff
#define BIT_LPQ_HIGH_TH_V1_8812F(x)                                            \
	(((x) & BIT_MASK_LPQ_HIGH_TH_V1_8812F)                                 \
	 << BIT_SHIFT_LPQ_HIGH_TH_V1_8812F)
#define BITS_LPQ_HIGH_TH_V1_8812F                                              \
	(BIT_MASK_LPQ_HIGH_TH_V1_8812F << BIT_SHIFT_LPQ_HIGH_TH_V1_8812F)
#define BIT_CLEAR_LPQ_HIGH_TH_V1_8812F(x) ((x) & (~BITS_LPQ_HIGH_TH_V1_8812F))
#define BIT_GET_LPQ_HIGH_TH_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_LPQ_HIGH_TH_V1_8812F) &                             \
	 BIT_MASK_LPQ_HIGH_TH_V1_8812F)
#define BIT_SET_LPQ_HIGH_TH_V1_8812F(x, v)                                     \
	(BIT_CLEAR_LPQ_HIGH_TH_V1_8812F(x) | BIT_LPQ_HIGH_TH_V1_8812F(v))

#define BIT_SHIFT_LPQ_LOW_TH_V1_8812F 0
#define BIT_MASK_LPQ_LOW_TH_V1_8812F 0xfff
#define BIT_LPQ_LOW_TH_V1_8812F(x)                                             \
	(((x) & BIT_MASK_LPQ_LOW_TH_V1_8812F) << BIT_SHIFT_LPQ_LOW_TH_V1_8812F)
#define BITS_LPQ_LOW_TH_V1_8812F                                               \
	(BIT_MASK_LPQ_LOW_TH_V1_8812F << BIT_SHIFT_LPQ_LOW_TH_V1_8812F)
#define BIT_CLEAR_LPQ_LOW_TH_V1_8812F(x) ((x) & (~BITS_LPQ_LOW_TH_V1_8812F))
#define BIT_GET_LPQ_LOW_TH_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_LPQ_LOW_TH_V1_8812F) & BIT_MASK_LPQ_LOW_TH_V1_8812F)
#define BIT_SET_LPQ_LOW_TH_V1_8812F(x, v)                                      \
	(BIT_CLEAR_LPQ_LOW_TH_V1_8812F(x) | BIT_LPQ_LOW_TH_V1_8812F(v))

/* 2 REG_TQPNT4_8812F */
#define BIT_EXQ_INT_EN_8812F BIT(31)

#define BIT_SHIFT_EXQ_HIGH_TH_V1_8812F 16
#define BIT_MASK_EXQ_HIGH_TH_V1_8812F 0xfff
#define BIT_EXQ_HIGH_TH_V1_8812F(x)                                            \
	(((x) & BIT_MASK_EXQ_HIGH_TH_V1_8812F)                                 \
	 << BIT_SHIFT_EXQ_HIGH_TH_V1_8812F)
#define BITS_EXQ_HIGH_TH_V1_8812F                                              \
	(BIT_MASK_EXQ_HIGH_TH_V1_8812F << BIT_SHIFT_EXQ_HIGH_TH_V1_8812F)
#define BIT_CLEAR_EXQ_HIGH_TH_V1_8812F(x) ((x) & (~BITS_EXQ_HIGH_TH_V1_8812F))
#define BIT_GET_EXQ_HIGH_TH_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_EXQ_HIGH_TH_V1_8812F) &                             \
	 BIT_MASK_EXQ_HIGH_TH_V1_8812F)
#define BIT_SET_EXQ_HIGH_TH_V1_8812F(x, v)                                     \
	(BIT_CLEAR_EXQ_HIGH_TH_V1_8812F(x) | BIT_EXQ_HIGH_TH_V1_8812F(v))

#define BIT_SHIFT_EXQ_LOW_TH_V1_8812F 0
#define BIT_MASK_EXQ_LOW_TH_V1_8812F 0xfff
#define BIT_EXQ_LOW_TH_V1_8812F(x)                                             \
	(((x) & BIT_MASK_EXQ_LOW_TH_V1_8812F) << BIT_SHIFT_EXQ_LOW_TH_V1_8812F)
#define BITS_EXQ_LOW_TH_V1_8812F                                               \
	(BIT_MASK_EXQ_LOW_TH_V1_8812F << BIT_SHIFT_EXQ_LOW_TH_V1_8812F)
#define BIT_CLEAR_EXQ_LOW_TH_V1_8812F(x) ((x) & (~BITS_EXQ_LOW_TH_V1_8812F))
#define BIT_GET_EXQ_LOW_TH_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_EXQ_LOW_TH_V1_8812F) & BIT_MASK_EXQ_LOW_TH_V1_8812F)
#define BIT_SET_EXQ_LOW_TH_V1_8812F(x, v)                                      \
	(BIT_CLEAR_EXQ_LOW_TH_V1_8812F(x) | BIT_EXQ_LOW_TH_V1_8812F(v))

/* 2 REG_RQPN_CTRL_1_8812F */

#define BIT_SHIFT_TXPKTNUM_H_V2_8812F 16
#define BIT_MASK_TXPKTNUM_H_V2_8812F 0xfff
#define BIT_TXPKTNUM_H_V2_8812F(x)                                             \
	(((x) & BIT_MASK_TXPKTNUM_H_V2_8812F) << BIT_SHIFT_TXPKTNUM_H_V2_8812F)
#define BITS_TXPKTNUM_H_V2_8812F                                               \
	(BIT_MASK_TXPKTNUM_H_V2_8812F << BIT_SHIFT_TXPKTNUM_H_V2_8812F)
#define BIT_CLEAR_TXPKTNUM_H_V2_8812F(x) ((x) & (~BITS_TXPKTNUM_H_V2_8812F))
#define BIT_GET_TXPKTNUM_H_V2_8812F(x)                                         \
	(((x) >> BIT_SHIFT_TXPKTNUM_H_V2_8812F) & BIT_MASK_TXPKTNUM_H_V2_8812F)
#define BIT_SET_TXPKTNUM_H_V2_8812F(x, v)                                      \
	(BIT_CLEAR_TXPKTNUM_H_V2_8812F(x) | BIT_TXPKTNUM_H_V2_8812F(v))

#define BIT_SHIFT_TXPKTNUM_V3_8812F 0
#define BIT_MASK_TXPKTNUM_V3_8812F 0xfff
#define BIT_TXPKTNUM_V3_8812F(x)                                               \
	(((x) & BIT_MASK_TXPKTNUM_V3_8812F) << BIT_SHIFT_TXPKTNUM_V3_8812F)
#define BITS_TXPKTNUM_V3_8812F                                                 \
	(BIT_MASK_TXPKTNUM_V3_8812F << BIT_SHIFT_TXPKTNUM_V3_8812F)
#define BIT_CLEAR_TXPKTNUM_V3_8812F(x) ((x) & (~BITS_TXPKTNUM_V3_8812F))
#define BIT_GET_TXPKTNUM_V3_8812F(x)                                           \
	(((x) >> BIT_SHIFT_TXPKTNUM_V3_8812F) & BIT_MASK_TXPKTNUM_V3_8812F)
#define BIT_SET_TXPKTNUM_V3_8812F(x, v)                                        \
	(BIT_CLEAR_TXPKTNUM_V3_8812F(x) | BIT_TXPKTNUM_V3_8812F(v))

/* 2 REG_RQPN_CTRL_2_8812F */
#define BIT_LD_RQPN_8812F BIT(31)
#define BIT_EXQ_PUBLIC_DIS_V1_8812F BIT(19)
#define BIT_NPQ_PUBLIC_DIS_V1_8812F BIT(18)
#define BIT_LPQ_PUBLIC_DIS_V1_8812F BIT(17)
#define BIT_HPQ_PUBLIC_DIS_V1_8812F BIT(16)
#define BIT_SDIO_TXAGG_ALIGN_ADJUST_EN_8812F BIT(15)

#define BIT_SHIFT_SDIO_TXAGG_ALIGN_SIZE_8812F 0
#define BIT_MASK_SDIO_TXAGG_ALIGN_SIZE_8812F 0xfff
#define BIT_SDIO_TXAGG_ALIGN_SIZE_8812F(x)                                     \
	(((x) & BIT_MASK_SDIO_TXAGG_ALIGN_SIZE_8812F)                          \
	 << BIT_SHIFT_SDIO_TXAGG_ALIGN_SIZE_8812F)
#define BITS_SDIO_TXAGG_ALIGN_SIZE_8812F                                       \
	(BIT_MASK_SDIO_TXAGG_ALIGN_SIZE_8812F                                  \
	 << BIT_SHIFT_SDIO_TXAGG_ALIGN_SIZE_8812F)
#define BIT_CLEAR_SDIO_TXAGG_ALIGN_SIZE_8812F(x)                               \
	((x) & (~BITS_SDIO_TXAGG_ALIGN_SIZE_8812F))
#define BIT_GET_SDIO_TXAGG_ALIGN_SIZE_8812F(x)                                 \
	(((x) >> BIT_SHIFT_SDIO_TXAGG_ALIGN_SIZE_8812F) &                      \
	 BIT_MASK_SDIO_TXAGG_ALIGN_SIZE_8812F)
#define BIT_SET_SDIO_TXAGG_ALIGN_SIZE_8812F(x, v)                              \
	(BIT_CLEAR_SDIO_TXAGG_ALIGN_SIZE_8812F(x) |                            \
	 BIT_SDIO_TXAGG_ALIGN_SIZE_8812F(v))

/* 2 REG_FIFOPAGE_INFO_1_8812F */

#define BIT_SHIFT_HPQ_AVAL_PG_V1_8812F 16
#define BIT_MASK_HPQ_AVAL_PG_V1_8812F 0xfff
#define BIT_HPQ_AVAL_PG_V1_8812F(x)                                            \
	(((x) & BIT_MASK_HPQ_AVAL_PG_V1_8812F)                                 \
	 << BIT_SHIFT_HPQ_AVAL_PG_V1_8812F)
#define BITS_HPQ_AVAL_PG_V1_8812F                                              \
	(BIT_MASK_HPQ_AVAL_PG_V1_8812F << BIT_SHIFT_HPQ_AVAL_PG_V1_8812F)
#define BIT_CLEAR_HPQ_AVAL_PG_V1_8812F(x) ((x) & (~BITS_HPQ_AVAL_PG_V1_8812F))
#define BIT_GET_HPQ_AVAL_PG_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HPQ_AVAL_PG_V1_8812F) &                             \
	 BIT_MASK_HPQ_AVAL_PG_V1_8812F)
#define BIT_SET_HPQ_AVAL_PG_V1_8812F(x, v)                                     \
	(BIT_CLEAR_HPQ_AVAL_PG_V1_8812F(x) | BIT_HPQ_AVAL_PG_V1_8812F(v))

#define BIT_SHIFT_HPQ_V1_8812F 0
#define BIT_MASK_HPQ_V1_8812F 0xfff
#define BIT_HPQ_V1_8812F(x)                                                    \
	(((x) & BIT_MASK_HPQ_V1_8812F) << BIT_SHIFT_HPQ_V1_8812F)
#define BITS_HPQ_V1_8812F (BIT_MASK_HPQ_V1_8812F << BIT_SHIFT_HPQ_V1_8812F)
#define BIT_CLEAR_HPQ_V1_8812F(x) ((x) & (~BITS_HPQ_V1_8812F))
#define BIT_GET_HPQ_V1_8812F(x)                                                \
	(((x) >> BIT_SHIFT_HPQ_V1_8812F) & BIT_MASK_HPQ_V1_8812F)
#define BIT_SET_HPQ_V1_8812F(x, v)                                             \
	(BIT_CLEAR_HPQ_V1_8812F(x) | BIT_HPQ_V1_8812F(v))

/* 2 REG_FIFOPAGE_INFO_2_8812F */

#define BIT_SHIFT_LPQ_AVAL_PG_V1_8812F 16
#define BIT_MASK_LPQ_AVAL_PG_V1_8812F 0xfff
#define BIT_LPQ_AVAL_PG_V1_8812F(x)                                            \
	(((x) & BIT_MASK_LPQ_AVAL_PG_V1_8812F)                                 \
	 << BIT_SHIFT_LPQ_AVAL_PG_V1_8812F)
#define BITS_LPQ_AVAL_PG_V1_8812F                                              \
	(BIT_MASK_LPQ_AVAL_PG_V1_8812F << BIT_SHIFT_LPQ_AVAL_PG_V1_8812F)
#define BIT_CLEAR_LPQ_AVAL_PG_V1_8812F(x) ((x) & (~BITS_LPQ_AVAL_PG_V1_8812F))
#define BIT_GET_LPQ_AVAL_PG_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_LPQ_AVAL_PG_V1_8812F) &                             \
	 BIT_MASK_LPQ_AVAL_PG_V1_8812F)
#define BIT_SET_LPQ_AVAL_PG_V1_8812F(x, v)                                     \
	(BIT_CLEAR_LPQ_AVAL_PG_V1_8812F(x) | BIT_LPQ_AVAL_PG_V1_8812F(v))

#define BIT_SHIFT_LPQ_V1_8812F 0
#define BIT_MASK_LPQ_V1_8812F 0xfff
#define BIT_LPQ_V1_8812F(x)                                                    \
	(((x) & BIT_MASK_LPQ_V1_8812F) << BIT_SHIFT_LPQ_V1_8812F)
#define BITS_LPQ_V1_8812F (BIT_MASK_LPQ_V1_8812F << BIT_SHIFT_LPQ_V1_8812F)
#define BIT_CLEAR_LPQ_V1_8812F(x) ((x) & (~BITS_LPQ_V1_8812F))
#define BIT_GET_LPQ_V1_8812F(x)                                                \
	(((x) >> BIT_SHIFT_LPQ_V1_8812F) & BIT_MASK_LPQ_V1_8812F)
#define BIT_SET_LPQ_V1_8812F(x, v)                                             \
	(BIT_CLEAR_LPQ_V1_8812F(x) | BIT_LPQ_V1_8812F(v))

/* 2 REG_FIFOPAGE_INFO_3_8812F */

#define BIT_SHIFT_NPQ_AVAL_PG_V1_8812F 16
#define BIT_MASK_NPQ_AVAL_PG_V1_8812F 0xfff
#define BIT_NPQ_AVAL_PG_V1_8812F(x)                                            \
	(((x) & BIT_MASK_NPQ_AVAL_PG_V1_8812F)                                 \
	 << BIT_SHIFT_NPQ_AVAL_PG_V1_8812F)
#define BITS_NPQ_AVAL_PG_V1_8812F                                              \
	(BIT_MASK_NPQ_AVAL_PG_V1_8812F << BIT_SHIFT_NPQ_AVAL_PG_V1_8812F)
#define BIT_CLEAR_NPQ_AVAL_PG_V1_8812F(x) ((x) & (~BITS_NPQ_AVAL_PG_V1_8812F))
#define BIT_GET_NPQ_AVAL_PG_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_NPQ_AVAL_PG_V1_8812F) &                             \
	 BIT_MASK_NPQ_AVAL_PG_V1_8812F)
#define BIT_SET_NPQ_AVAL_PG_V1_8812F(x, v)                                     \
	(BIT_CLEAR_NPQ_AVAL_PG_V1_8812F(x) | BIT_NPQ_AVAL_PG_V1_8812F(v))

#define BIT_SHIFT_NPQ_V1_8812F 0
#define BIT_MASK_NPQ_V1_8812F 0xfff
#define BIT_NPQ_V1_8812F(x)                                                    \
	(((x) & BIT_MASK_NPQ_V1_8812F) << BIT_SHIFT_NPQ_V1_8812F)
#define BITS_NPQ_V1_8812F (BIT_MASK_NPQ_V1_8812F << BIT_SHIFT_NPQ_V1_8812F)
#define BIT_CLEAR_NPQ_V1_8812F(x) ((x) & (~BITS_NPQ_V1_8812F))
#define BIT_GET_NPQ_V1_8812F(x)                                                \
	(((x) >> BIT_SHIFT_NPQ_V1_8812F) & BIT_MASK_NPQ_V1_8812F)
#define BIT_SET_NPQ_V1_8812F(x, v)                                             \
	(BIT_CLEAR_NPQ_V1_8812F(x) | BIT_NPQ_V1_8812F(v))

/* 2 REG_FIFOPAGE_INFO_4_8812F */

#define BIT_SHIFT_EXQ_AVAL_PG_V1_8812F 16
#define BIT_MASK_EXQ_AVAL_PG_V1_8812F 0xfff
#define BIT_EXQ_AVAL_PG_V1_8812F(x)                                            \
	(((x) & BIT_MASK_EXQ_AVAL_PG_V1_8812F)                                 \
	 << BIT_SHIFT_EXQ_AVAL_PG_V1_8812F)
#define BITS_EXQ_AVAL_PG_V1_8812F                                              \
	(BIT_MASK_EXQ_AVAL_PG_V1_8812F << BIT_SHIFT_EXQ_AVAL_PG_V1_8812F)
#define BIT_CLEAR_EXQ_AVAL_PG_V1_8812F(x) ((x) & (~BITS_EXQ_AVAL_PG_V1_8812F))
#define BIT_GET_EXQ_AVAL_PG_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_EXQ_AVAL_PG_V1_8812F) &                             \
	 BIT_MASK_EXQ_AVAL_PG_V1_8812F)
#define BIT_SET_EXQ_AVAL_PG_V1_8812F(x, v)                                     \
	(BIT_CLEAR_EXQ_AVAL_PG_V1_8812F(x) | BIT_EXQ_AVAL_PG_V1_8812F(v))

#define BIT_SHIFT_EXQ_V1_8812F 0
#define BIT_MASK_EXQ_V1_8812F 0xfff
#define BIT_EXQ_V1_8812F(x)                                                    \
	(((x) & BIT_MASK_EXQ_V1_8812F) << BIT_SHIFT_EXQ_V1_8812F)
#define BITS_EXQ_V1_8812F (BIT_MASK_EXQ_V1_8812F << BIT_SHIFT_EXQ_V1_8812F)
#define BIT_CLEAR_EXQ_V1_8812F(x) ((x) & (~BITS_EXQ_V1_8812F))
#define BIT_GET_EXQ_V1_8812F(x)                                                \
	(((x) >> BIT_SHIFT_EXQ_V1_8812F) & BIT_MASK_EXQ_V1_8812F)
#define BIT_SET_EXQ_V1_8812F(x, v)                                             \
	(BIT_CLEAR_EXQ_V1_8812F(x) | BIT_EXQ_V1_8812F(v))

/* 2 REG_FIFOPAGE_INFO_5_8812F */

#define BIT_SHIFT_PUBQ_AVAL_PG_V1_8812F 16
#define BIT_MASK_PUBQ_AVAL_PG_V1_8812F 0xfff
#define BIT_PUBQ_AVAL_PG_V1_8812F(x)                                           \
	(((x) & BIT_MASK_PUBQ_AVAL_PG_V1_8812F)                                \
	 << BIT_SHIFT_PUBQ_AVAL_PG_V1_8812F)
#define BITS_PUBQ_AVAL_PG_V1_8812F                                             \
	(BIT_MASK_PUBQ_AVAL_PG_V1_8812F << BIT_SHIFT_PUBQ_AVAL_PG_V1_8812F)
#define BIT_CLEAR_PUBQ_AVAL_PG_V1_8812F(x) ((x) & (~BITS_PUBQ_AVAL_PG_V1_8812F))
#define BIT_GET_PUBQ_AVAL_PG_V1_8812F(x)                                       \
	(((x) >> BIT_SHIFT_PUBQ_AVAL_PG_V1_8812F) &                            \
	 BIT_MASK_PUBQ_AVAL_PG_V1_8812F)
#define BIT_SET_PUBQ_AVAL_PG_V1_8812F(x, v)                                    \
	(BIT_CLEAR_PUBQ_AVAL_PG_V1_8812F(x) | BIT_PUBQ_AVAL_PG_V1_8812F(v))

#define BIT_SHIFT_PUBQ_V1_8812F 0
#define BIT_MASK_PUBQ_V1_8812F 0xfff
#define BIT_PUBQ_V1_8812F(x)                                                   \
	(((x) & BIT_MASK_PUBQ_V1_8812F) << BIT_SHIFT_PUBQ_V1_8812F)
#define BITS_PUBQ_V1_8812F (BIT_MASK_PUBQ_V1_8812F << BIT_SHIFT_PUBQ_V1_8812F)
#define BIT_CLEAR_PUBQ_V1_8812F(x) ((x) & (~BITS_PUBQ_V1_8812F))
#define BIT_GET_PUBQ_V1_8812F(x)                                               \
	(((x) >> BIT_SHIFT_PUBQ_V1_8812F) & BIT_MASK_PUBQ_V1_8812F)
#define BIT_SET_PUBQ_V1_8812F(x, v)                                            \
	(BIT_CLEAR_PUBQ_V1_8812F(x) | BIT_PUBQ_V1_8812F(v))

/* 2 REG_H2C_HEAD_8812F */

#define BIT_SHIFT_H2C_HEAD_8812F 0
#define BIT_MASK_H2C_HEAD_8812F 0x3ffff
#define BIT_H2C_HEAD_8812F(x)                                                  \
	(((x) & BIT_MASK_H2C_HEAD_8812F) << BIT_SHIFT_H2C_HEAD_8812F)
#define BITS_H2C_HEAD_8812F                                                    \
	(BIT_MASK_H2C_HEAD_8812F << BIT_SHIFT_H2C_HEAD_8812F)
#define BIT_CLEAR_H2C_HEAD_8812F(x) ((x) & (~BITS_H2C_HEAD_8812F))
#define BIT_GET_H2C_HEAD_8812F(x)                                              \
	(((x) >> BIT_SHIFT_H2C_HEAD_8812F) & BIT_MASK_H2C_HEAD_8812F)
#define BIT_SET_H2C_HEAD_8812F(x, v)                                           \
	(BIT_CLEAR_H2C_HEAD_8812F(x) | BIT_H2C_HEAD_8812F(v))

/* 2 REG_H2C_TAIL_8812F */

#define BIT_SHIFT_H2C_TAIL_8812F 0
#define BIT_MASK_H2C_TAIL_8812F 0x3ffff
#define BIT_H2C_TAIL_8812F(x)                                                  \
	(((x) & BIT_MASK_H2C_TAIL_8812F) << BIT_SHIFT_H2C_TAIL_8812F)
#define BITS_H2C_TAIL_8812F                                                    \
	(BIT_MASK_H2C_TAIL_8812F << BIT_SHIFT_H2C_TAIL_8812F)
#define BIT_CLEAR_H2C_TAIL_8812F(x) ((x) & (~BITS_H2C_TAIL_8812F))
#define BIT_GET_H2C_TAIL_8812F(x)                                              \
	(((x) >> BIT_SHIFT_H2C_TAIL_8812F) & BIT_MASK_H2C_TAIL_8812F)
#define BIT_SET_H2C_TAIL_8812F(x, v)                                           \
	(BIT_CLEAR_H2C_TAIL_8812F(x) | BIT_H2C_TAIL_8812F(v))

/* 2 REG_H2C_READ_ADDR_8812F */

#define BIT_SHIFT_H2C_READ_ADDR_8812F 0
#define BIT_MASK_H2C_READ_ADDR_8812F 0x3ffff
#define BIT_H2C_READ_ADDR_8812F(x)                                             \
	(((x) & BIT_MASK_H2C_READ_ADDR_8812F) << BIT_SHIFT_H2C_READ_ADDR_8812F)
#define BITS_H2C_READ_ADDR_8812F                                               \
	(BIT_MASK_H2C_READ_ADDR_8812F << BIT_SHIFT_H2C_READ_ADDR_8812F)
#define BIT_CLEAR_H2C_READ_ADDR_8812F(x) ((x) & (~BITS_H2C_READ_ADDR_8812F))
#define BIT_GET_H2C_READ_ADDR_8812F(x)                                         \
	(((x) >> BIT_SHIFT_H2C_READ_ADDR_8812F) & BIT_MASK_H2C_READ_ADDR_8812F)
#define BIT_SET_H2C_READ_ADDR_8812F(x, v)                                      \
	(BIT_CLEAR_H2C_READ_ADDR_8812F(x) | BIT_H2C_READ_ADDR_8812F(v))

/* 2 REG_H2C_WR_ADDR_8812F */

#define BIT_SHIFT_H2C_WR_ADDR_8812F 0
#define BIT_MASK_H2C_WR_ADDR_8812F 0x3ffff
#define BIT_H2C_WR_ADDR_8812F(x)                                               \
	(((x) & BIT_MASK_H2C_WR_ADDR_8812F) << BIT_SHIFT_H2C_WR_ADDR_8812F)
#define BITS_H2C_WR_ADDR_8812F                                                 \
	(BIT_MASK_H2C_WR_ADDR_8812F << BIT_SHIFT_H2C_WR_ADDR_8812F)
#define BIT_CLEAR_H2C_WR_ADDR_8812F(x) ((x) & (~BITS_H2C_WR_ADDR_8812F))
#define BIT_GET_H2C_WR_ADDR_8812F(x)                                           \
	(((x) >> BIT_SHIFT_H2C_WR_ADDR_8812F) & BIT_MASK_H2C_WR_ADDR_8812F)
#define BIT_SET_H2C_WR_ADDR_8812F(x, v)                                        \
	(BIT_CLEAR_H2C_WR_ADDR_8812F(x) | BIT_H2C_WR_ADDR_8812F(v))

/* 2 REG_H2C_INFO_8812F */
#define BIT_H2C_SPACE_VLD_8812F BIT(3)
#define BIT_H2C_WR_ADDR_RST_8812F BIT(2)

#define BIT_SHIFT_H2C_LEN_SEL_8812F 0
#define BIT_MASK_H2C_LEN_SEL_8812F 0x3
#define BIT_H2C_LEN_SEL_8812F(x)                                               \
	(((x) & BIT_MASK_H2C_LEN_SEL_8812F) << BIT_SHIFT_H2C_LEN_SEL_8812F)
#define BITS_H2C_LEN_SEL_8812F                                                 \
	(BIT_MASK_H2C_LEN_SEL_8812F << BIT_SHIFT_H2C_LEN_SEL_8812F)
#define BIT_CLEAR_H2C_LEN_SEL_8812F(x) ((x) & (~BITS_H2C_LEN_SEL_8812F))
#define BIT_GET_H2C_LEN_SEL_8812F(x)                                           \
	(((x) >> BIT_SHIFT_H2C_LEN_SEL_8812F) & BIT_MASK_H2C_LEN_SEL_8812F)
#define BIT_SET_H2C_LEN_SEL_8812F(x, v)                                        \
	(BIT_CLEAR_H2C_LEN_SEL_8812F(x) | BIT_H2C_LEN_SEL_8812F(v))

/* 2 REG_PGSUB_CNT_8812F */

/* 2 REG_NOT_VALID_8812F */
#define BIT_RST_PGSUB_CNT_8812F BIT(1)
#define BIT_PGSUB_CNT_EN_8812F BIT(0)

/* 2 REG_PGSUB_H_8812F */

#define BIT_SHIFT_HPQ_PGSUB_CNT_8812F 0
#define BIT_MASK_HPQ_PGSUB_CNT_8812F 0xffffffffL
#define BIT_HPQ_PGSUB_CNT_8812F(x)                                             \
	(((x) & BIT_MASK_HPQ_PGSUB_CNT_8812F) << BIT_SHIFT_HPQ_PGSUB_CNT_8812F)
#define BITS_HPQ_PGSUB_CNT_8812F                                               \
	(BIT_MASK_HPQ_PGSUB_CNT_8812F << BIT_SHIFT_HPQ_PGSUB_CNT_8812F)
#define BIT_CLEAR_HPQ_PGSUB_CNT_8812F(x) ((x) & (~BITS_HPQ_PGSUB_CNT_8812F))
#define BIT_GET_HPQ_PGSUB_CNT_8812F(x)                                         \
	(((x) >> BIT_SHIFT_HPQ_PGSUB_CNT_8812F) & BIT_MASK_HPQ_PGSUB_CNT_8812F)
#define BIT_SET_HPQ_PGSUB_CNT_8812F(x, v)                                      \
	(BIT_CLEAR_HPQ_PGSUB_CNT_8812F(x) | BIT_HPQ_PGSUB_CNT_8812F(v))

/* 2 REG_PGSUB_N_8812F */

#define BIT_SHIFT_NPQ_PGSUB_CNT_8812F 0
#define BIT_MASK_NPQ_PGSUB_CNT_8812F 0xffffffffL
#define BIT_NPQ_PGSUB_CNT_8812F(x)                                             \
	(((x) & BIT_MASK_NPQ_PGSUB_CNT_8812F) << BIT_SHIFT_NPQ_PGSUB_CNT_8812F)
#define BITS_NPQ_PGSUB_CNT_8812F                                               \
	(BIT_MASK_NPQ_PGSUB_CNT_8812F << BIT_SHIFT_NPQ_PGSUB_CNT_8812F)
#define BIT_CLEAR_NPQ_PGSUB_CNT_8812F(x) ((x) & (~BITS_NPQ_PGSUB_CNT_8812F))
#define BIT_GET_NPQ_PGSUB_CNT_8812F(x)                                         \
	(((x) >> BIT_SHIFT_NPQ_PGSUB_CNT_8812F) & BIT_MASK_NPQ_PGSUB_CNT_8812F)
#define BIT_SET_NPQ_PGSUB_CNT_8812F(x, v)                                      \
	(BIT_CLEAR_NPQ_PGSUB_CNT_8812F(x) | BIT_NPQ_PGSUB_CNT_8812F(v))

/* 2 REG_PGSUB_L_8812F */

#define BIT_SHIFT_LPQ_PGSUB_CNT_8812F 0
#define BIT_MASK_LPQ_PGSUB_CNT_8812F 0xffffffffL
#define BIT_LPQ_PGSUB_CNT_8812F(x)                                             \
	(((x) & BIT_MASK_LPQ_PGSUB_CNT_8812F) << BIT_SHIFT_LPQ_PGSUB_CNT_8812F)
#define BITS_LPQ_PGSUB_CNT_8812F                                               \
	(BIT_MASK_LPQ_PGSUB_CNT_8812F << BIT_SHIFT_LPQ_PGSUB_CNT_8812F)
#define BIT_CLEAR_LPQ_PGSUB_CNT_8812F(x) ((x) & (~BITS_LPQ_PGSUB_CNT_8812F))
#define BIT_GET_LPQ_PGSUB_CNT_8812F(x)                                         \
	(((x) >> BIT_SHIFT_LPQ_PGSUB_CNT_8812F) & BIT_MASK_LPQ_PGSUB_CNT_8812F)
#define BIT_SET_LPQ_PGSUB_CNT_8812F(x, v)                                      \
	(BIT_CLEAR_LPQ_PGSUB_CNT_8812F(x) | BIT_LPQ_PGSUB_CNT_8812F(v))

/* 2 REG_PGSUB_E_8812F */

#define BIT_SHIFT_EPQ_PGSUB_CNT_8812F 0
#define BIT_MASK_EPQ_PGSUB_CNT_8812F 0xffffffffL
#define BIT_EPQ_PGSUB_CNT_8812F(x)                                             \
	(((x) & BIT_MASK_EPQ_PGSUB_CNT_8812F) << BIT_SHIFT_EPQ_PGSUB_CNT_8812F)
#define BITS_EPQ_PGSUB_CNT_8812F                                               \
	(BIT_MASK_EPQ_PGSUB_CNT_8812F << BIT_SHIFT_EPQ_PGSUB_CNT_8812F)
#define BIT_CLEAR_EPQ_PGSUB_CNT_8812F(x) ((x) & (~BITS_EPQ_PGSUB_CNT_8812F))
#define BIT_GET_EPQ_PGSUB_CNT_8812F(x)                                         \
	(((x) >> BIT_SHIFT_EPQ_PGSUB_CNT_8812F) & BIT_MASK_EPQ_PGSUB_CNT_8812F)
#define BIT_SET_EPQ_PGSUB_CNT_8812F(x, v)                                      \
	(BIT_CLEAR_EPQ_PGSUB_CNT_8812F(x) | BIT_EPQ_PGSUB_CNT_8812F(v))

/* 2 REG_RXDMA_AGG_PG_TH_8812F */
#define BIT_USB_RXDMA_AGG_EN_8812F BIT(31)
#define BIT_EN_FW_ADD_8812F BIT(30)
#define BIT_EN_PRE_CALC_8812F BIT(29)
#define BIT_RXAGG_SW_EN_8812F BIT(28)
#define BIT_RXAGG_SW_TRIG_8812F BIT(27)

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_DMA_AGG_TO_V1_8812F 8
#define BIT_MASK_DMA_AGG_TO_V1_8812F 0xff
#define BIT_DMA_AGG_TO_V1_8812F(x)                                             \
	(((x) & BIT_MASK_DMA_AGG_TO_V1_8812F) << BIT_SHIFT_DMA_AGG_TO_V1_8812F)
#define BITS_DMA_AGG_TO_V1_8812F                                               \
	(BIT_MASK_DMA_AGG_TO_V1_8812F << BIT_SHIFT_DMA_AGG_TO_V1_8812F)
#define BIT_CLEAR_DMA_AGG_TO_V1_8812F(x) ((x) & (~BITS_DMA_AGG_TO_V1_8812F))
#define BIT_GET_DMA_AGG_TO_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_DMA_AGG_TO_V1_8812F) & BIT_MASK_DMA_AGG_TO_V1_8812F)
#define BIT_SET_DMA_AGG_TO_V1_8812F(x, v)                                      \
	(BIT_CLEAR_DMA_AGG_TO_V1_8812F(x) | BIT_DMA_AGG_TO_V1_8812F(v))

#define BIT_SHIFT_RXDMA_AGG_PG_TH_8812F 0
#define BIT_MASK_RXDMA_AGG_PG_TH_8812F 0xff
#define BIT_RXDMA_AGG_PG_TH_8812F(x)                                           \
	(((x) & BIT_MASK_RXDMA_AGG_PG_TH_8812F)                                \
	 << BIT_SHIFT_RXDMA_AGG_PG_TH_8812F)
#define BITS_RXDMA_AGG_PG_TH_8812F                                             \
	(BIT_MASK_RXDMA_AGG_PG_TH_8812F << BIT_SHIFT_RXDMA_AGG_PG_TH_8812F)
#define BIT_CLEAR_RXDMA_AGG_PG_TH_8812F(x) ((x) & (~BITS_RXDMA_AGG_PG_TH_8812F))
#define BIT_GET_RXDMA_AGG_PG_TH_8812F(x)                                       \
	(((x) >> BIT_SHIFT_RXDMA_AGG_PG_TH_8812F) &                            \
	 BIT_MASK_RXDMA_AGG_PG_TH_8812F)
#define BIT_SET_RXDMA_AGG_PG_TH_8812F(x, v)                                    \
	(BIT_CLEAR_RXDMA_AGG_PG_TH_8812F(x) | BIT_RXDMA_AGG_PG_TH_8812F(v))

/* 2 REG_RXPKT_NUM_8812F */

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_FW_UPD_RDPTR19_TO_16_8812F 20
#define BIT_MASK_FW_UPD_RDPTR19_TO_16_8812F 0xf
#define BIT_FW_UPD_RDPTR19_TO_16_8812F(x)                                      \
	(((x) & BIT_MASK_FW_UPD_RDPTR19_TO_16_8812F)                           \
	 << BIT_SHIFT_FW_UPD_RDPTR19_TO_16_8812F)
#define BITS_FW_UPD_RDPTR19_TO_16_8812F                                        \
	(BIT_MASK_FW_UPD_RDPTR19_TO_16_8812F                                   \
	 << BIT_SHIFT_FW_UPD_RDPTR19_TO_16_8812F)
#define BIT_CLEAR_FW_UPD_RDPTR19_TO_16_8812F(x)                                \
	((x) & (~BITS_FW_UPD_RDPTR19_TO_16_8812F))
#define BIT_GET_FW_UPD_RDPTR19_TO_16_8812F(x)                                  \
	(((x) >> BIT_SHIFT_FW_UPD_RDPTR19_TO_16_8812F) &                       \
	 BIT_MASK_FW_UPD_RDPTR19_TO_16_8812F)
#define BIT_SET_FW_UPD_RDPTR19_TO_16_8812F(x, v)                               \
	(BIT_CLEAR_FW_UPD_RDPTR19_TO_16_8812F(x) |                             \
	 BIT_FW_UPD_RDPTR19_TO_16_8812F(v))

#define BIT_RXDMA_REQ_8812F BIT(19)
#define BIT_RW_RELEASE_EN_8812F BIT(18)
#define BIT_RXDMA_IDLE_8812F BIT(17)
#define BIT_RXPKT_RELEASE_POLL_8812F BIT(16)

#define BIT_SHIFT_FW_UPD_RDPTR_8812F 0
#define BIT_MASK_FW_UPD_RDPTR_8812F 0xffff
#define BIT_FW_UPD_RDPTR_8812F(x)                                              \
	(((x) & BIT_MASK_FW_UPD_RDPTR_8812F) << BIT_SHIFT_FW_UPD_RDPTR_8812F)
#define BITS_FW_UPD_RDPTR_8812F                                                \
	(BIT_MASK_FW_UPD_RDPTR_8812F << BIT_SHIFT_FW_UPD_RDPTR_8812F)
#define BIT_CLEAR_FW_UPD_RDPTR_8812F(x) ((x) & (~BITS_FW_UPD_RDPTR_8812F))
#define BIT_GET_FW_UPD_RDPTR_8812F(x)                                          \
	(((x) >> BIT_SHIFT_FW_UPD_RDPTR_8812F) & BIT_MASK_FW_UPD_RDPTR_8812F)
#define BIT_SET_FW_UPD_RDPTR_8812F(x, v)                                       \
	(BIT_CLEAR_FW_UPD_RDPTR_8812F(x) | BIT_FW_UPD_RDPTR_8812F(v))

/* 2 REG_RXDMA_STATUS_8812F */
#define BIT_C2H_PKT_OVF_8812F BIT(7)
#define BIT_AGG_CONFGI_ISSUE_8812F BIT(6)
#define BIT_FW_POLL_ISSUE_8812F BIT(5)
#define BIT_RX_DATA_UDN_8812F BIT(4)
#define BIT_RX_SFF_UDN_8812F BIT(3)
#define BIT_RX_SFF_OVF_8812F BIT(2)
#define BIT_RXPKT_OVF_8812F BIT(0)

/* 2 REG_RXDMA_DPR_8812F */

#define BIT_SHIFT_RDE_DEBUG_8812F 0
#define BIT_MASK_RDE_DEBUG_8812F 0xffffffffL
#define BIT_RDE_DEBUG_8812F(x)                                                 \
	(((x) & BIT_MASK_RDE_DEBUG_8812F) << BIT_SHIFT_RDE_DEBUG_8812F)
#define BITS_RDE_DEBUG_8812F                                                   \
	(BIT_MASK_RDE_DEBUG_8812F << BIT_SHIFT_RDE_DEBUG_8812F)
#define BIT_CLEAR_RDE_DEBUG_8812F(x) ((x) & (~BITS_RDE_DEBUG_8812F))
#define BIT_GET_RDE_DEBUG_8812F(x)                                             \
	(((x) >> BIT_SHIFT_RDE_DEBUG_8812F) & BIT_MASK_RDE_DEBUG_8812F)
#define BIT_SET_RDE_DEBUG_8812F(x, v)                                          \
	(BIT_CLEAR_RDE_DEBUG_8812F(x) | BIT_RDE_DEBUG_8812F(v))

/* 2 REG_RXDMA_MODE_8812F */

#define BIT_SHIFT_PKTNUM_TH_V2_8812F 24
#define BIT_MASK_PKTNUM_TH_V2_8812F 0x1f
#define BIT_PKTNUM_TH_V2_8812F(x)                                              \
	(((x) & BIT_MASK_PKTNUM_TH_V2_8812F) << BIT_SHIFT_PKTNUM_TH_V2_8812F)
#define BITS_PKTNUM_TH_V2_8812F                                                \
	(BIT_MASK_PKTNUM_TH_V2_8812F << BIT_SHIFT_PKTNUM_TH_V2_8812F)
#define BIT_CLEAR_PKTNUM_TH_V2_8812F(x) ((x) & (~BITS_PKTNUM_TH_V2_8812F))
#define BIT_GET_PKTNUM_TH_V2_8812F(x)                                          \
	(((x) >> BIT_SHIFT_PKTNUM_TH_V2_8812F) & BIT_MASK_PKTNUM_TH_V2_8812F)
#define BIT_SET_PKTNUM_TH_V2_8812F(x, v)                                       \
	(BIT_CLEAR_PKTNUM_TH_V2_8812F(x) | BIT_PKTNUM_TH_V2_8812F(v))

#define BIT_TXBA_BREAK_USBAGG_8812F BIT(23)

#define BIT_SHIFT_PKTLEN_PARA_8812F 16
#define BIT_MASK_PKTLEN_PARA_8812F 0x7
#define BIT_PKTLEN_PARA_8812F(x)                                               \
	(((x) & BIT_MASK_PKTLEN_PARA_8812F) << BIT_SHIFT_PKTLEN_PARA_8812F)
#define BITS_PKTLEN_PARA_8812F                                                 \
	(BIT_MASK_PKTLEN_PARA_8812F << BIT_SHIFT_PKTLEN_PARA_8812F)
#define BIT_CLEAR_PKTLEN_PARA_8812F(x) ((x) & (~BITS_PKTLEN_PARA_8812F))
#define BIT_GET_PKTLEN_PARA_8812F(x)                                           \
	(((x) >> BIT_SHIFT_PKTLEN_PARA_8812F) & BIT_MASK_PKTLEN_PARA_8812F)
#define BIT_SET_PKTLEN_PARA_8812F(x, v)                                        \
	(BIT_CLEAR_PKTLEN_PARA_8812F(x) | BIT_PKTLEN_PARA_8812F(v))

#define BIT_RX_DBG_SEL_8812F BIT(7)
#define BIT_EN_SPD_8812F BIT(6)

#define BIT_SHIFT_BURST_SIZE_8812F 4
#define BIT_MASK_BURST_SIZE_8812F 0x3
#define BIT_BURST_SIZE_8812F(x)                                                \
	(((x) & BIT_MASK_BURST_SIZE_8812F) << BIT_SHIFT_BURST_SIZE_8812F)
#define BITS_BURST_SIZE_8812F                                                  \
	(BIT_MASK_BURST_SIZE_8812F << BIT_SHIFT_BURST_SIZE_8812F)
#define BIT_CLEAR_BURST_SIZE_8812F(x) ((x) & (~BITS_BURST_SIZE_8812F))
#define BIT_GET_BURST_SIZE_8812F(x)                                            \
	(((x) >> BIT_SHIFT_BURST_SIZE_8812F) & BIT_MASK_BURST_SIZE_8812F)
#define BIT_SET_BURST_SIZE_8812F(x, v)                                         \
	(BIT_CLEAR_BURST_SIZE_8812F(x) | BIT_BURST_SIZE_8812F(v))

#define BIT_SHIFT_BURST_CNT_8812F 2
#define BIT_MASK_BURST_CNT_8812F 0x3
#define BIT_BURST_CNT_8812F(x)                                                 \
	(((x) & BIT_MASK_BURST_CNT_8812F) << BIT_SHIFT_BURST_CNT_8812F)
#define BITS_BURST_CNT_8812F                                                   \
	(BIT_MASK_BURST_CNT_8812F << BIT_SHIFT_BURST_CNT_8812F)
#define BIT_CLEAR_BURST_CNT_8812F(x) ((x) & (~BITS_BURST_CNT_8812F))
#define BIT_GET_BURST_CNT_8812F(x)                                             \
	(((x) >> BIT_SHIFT_BURST_CNT_8812F) & BIT_MASK_BURST_CNT_8812F)
#define BIT_SET_BURST_CNT_8812F(x, v)                                          \
	(BIT_CLEAR_BURST_CNT_8812F(x) | BIT_BURST_CNT_8812F(v))

#define BIT_DMA_MODE_8812F BIT(1)

/* 2 REG_C2H_PKT_8812F */

#define BIT_SHIFT_R_C2H_STR_ADDR_16_TO_19_8812F 24
#define BIT_MASK_R_C2H_STR_ADDR_16_TO_19_8812F 0xf
#define BIT_R_C2H_STR_ADDR_16_TO_19_8812F(x)                                   \
	(((x) & BIT_MASK_R_C2H_STR_ADDR_16_TO_19_8812F)                        \
	 << BIT_SHIFT_R_C2H_STR_ADDR_16_TO_19_8812F)
#define BITS_R_C2H_STR_ADDR_16_TO_19_8812F                                     \
	(BIT_MASK_R_C2H_STR_ADDR_16_TO_19_8812F                                \
	 << BIT_SHIFT_R_C2H_STR_ADDR_16_TO_19_8812F)
#define BIT_CLEAR_R_C2H_STR_ADDR_16_TO_19_8812F(x)                             \
	((x) & (~BITS_R_C2H_STR_ADDR_16_TO_19_8812F))
#define BIT_GET_R_C2H_STR_ADDR_16_TO_19_8812F(x)                               \
	(((x) >> BIT_SHIFT_R_C2H_STR_ADDR_16_TO_19_8812F) &                    \
	 BIT_MASK_R_C2H_STR_ADDR_16_TO_19_8812F)
#define BIT_SET_R_C2H_STR_ADDR_16_TO_19_8812F(x, v)                            \
	(BIT_CLEAR_R_C2H_STR_ADDR_16_TO_19_8812F(x) |                          \
	 BIT_R_C2H_STR_ADDR_16_TO_19_8812F(v))

#define BIT_R_C2H_PKT_REQ_8812F BIT(16)

#define BIT_SHIFT_R_C2H_STR_ADDR_8812F 0
#define BIT_MASK_R_C2H_STR_ADDR_8812F 0xffff
#define BIT_R_C2H_STR_ADDR_8812F(x)                                            \
	(((x) & BIT_MASK_R_C2H_STR_ADDR_8812F)                                 \
	 << BIT_SHIFT_R_C2H_STR_ADDR_8812F)
#define BITS_R_C2H_STR_ADDR_8812F                                              \
	(BIT_MASK_R_C2H_STR_ADDR_8812F << BIT_SHIFT_R_C2H_STR_ADDR_8812F)
#define BIT_CLEAR_R_C2H_STR_ADDR_8812F(x) ((x) & (~BITS_R_C2H_STR_ADDR_8812F))
#define BIT_GET_R_C2H_STR_ADDR_8812F(x)                                        \
	(((x) >> BIT_SHIFT_R_C2H_STR_ADDR_8812F) &                             \
	 BIT_MASK_R_C2H_STR_ADDR_8812F)
#define BIT_SET_R_C2H_STR_ADDR_8812F(x, v)                                     \
	(BIT_CLEAR_R_C2H_STR_ADDR_8812F(x) | BIT_R_C2H_STR_ADDR_8812F(v))

/* 2 REG_FWFF_C2H_8812F */

#define BIT_SHIFT_C2H_DMA_ADDR_8812F 0
#define BIT_MASK_C2H_DMA_ADDR_8812F 0x3ffff
#define BIT_C2H_DMA_ADDR_8812F(x)                                              \
	(((x) & BIT_MASK_C2H_DMA_ADDR_8812F) << BIT_SHIFT_C2H_DMA_ADDR_8812F)
#define BITS_C2H_DMA_ADDR_8812F                                                \
	(BIT_MASK_C2H_DMA_ADDR_8812F << BIT_SHIFT_C2H_DMA_ADDR_8812F)
#define BIT_CLEAR_C2H_DMA_ADDR_8812F(x) ((x) & (~BITS_C2H_DMA_ADDR_8812F))
#define BIT_GET_C2H_DMA_ADDR_8812F(x)                                          \
	(((x) >> BIT_SHIFT_C2H_DMA_ADDR_8812F) & BIT_MASK_C2H_DMA_ADDR_8812F)
#define BIT_SET_C2H_DMA_ADDR_8812F(x, v)                                       \
	(BIT_CLEAR_C2H_DMA_ADDR_8812F(x) | BIT_C2H_DMA_ADDR_8812F(v))

/* 2 REG_FWFF_CTRL_8812F */
#define BIT_FWFF_DMAPKT_REQ_8812F BIT(31)

#define BIT_SHIFT_FWFF_DMA_PKT_NUM_8812F 16
#define BIT_MASK_FWFF_DMA_PKT_NUM_8812F 0xff
#define BIT_FWFF_DMA_PKT_NUM_8812F(x)                                          \
	(((x) & BIT_MASK_FWFF_DMA_PKT_NUM_8812F)                               \
	 << BIT_SHIFT_FWFF_DMA_PKT_NUM_8812F)
#define BITS_FWFF_DMA_PKT_NUM_8812F                                            \
	(BIT_MASK_FWFF_DMA_PKT_NUM_8812F << BIT_SHIFT_FWFF_DMA_PKT_NUM_8812F)
#define BIT_CLEAR_FWFF_DMA_PKT_NUM_8812F(x)                                    \
	((x) & (~BITS_FWFF_DMA_PKT_NUM_8812F))
#define BIT_GET_FWFF_DMA_PKT_NUM_8812F(x)                                      \
	(((x) >> BIT_SHIFT_FWFF_DMA_PKT_NUM_8812F) &                           \
	 BIT_MASK_FWFF_DMA_PKT_NUM_8812F)
#define BIT_SET_FWFF_DMA_PKT_NUM_8812F(x, v)                                   \
	(BIT_CLEAR_FWFF_DMA_PKT_NUM_8812F(x) | BIT_FWFF_DMA_PKT_NUM_8812F(v))

#define BIT_SHIFT_FWFF_STR_ADDR_8812F 0
#define BIT_MASK_FWFF_STR_ADDR_8812F 0xffff
#define BIT_FWFF_STR_ADDR_8812F(x)                                             \
	(((x) & BIT_MASK_FWFF_STR_ADDR_8812F) << BIT_SHIFT_FWFF_STR_ADDR_8812F)
#define BITS_FWFF_STR_ADDR_8812F                                               \
	(BIT_MASK_FWFF_STR_ADDR_8812F << BIT_SHIFT_FWFF_STR_ADDR_8812F)
#define BIT_CLEAR_FWFF_STR_ADDR_8812F(x) ((x) & (~BITS_FWFF_STR_ADDR_8812F))
#define BIT_GET_FWFF_STR_ADDR_8812F(x)                                         \
	(((x) >> BIT_SHIFT_FWFF_STR_ADDR_8812F) & BIT_MASK_FWFF_STR_ADDR_8812F)
#define BIT_SET_FWFF_STR_ADDR_8812F(x, v)                                      \
	(BIT_CLEAR_FWFF_STR_ADDR_8812F(x) | BIT_FWFF_STR_ADDR_8812F(v))

/* 2 REG_FWFF_PKT_INFO_8812F */

#define BIT_SHIFT_FWFF_PKT_QUEUED_8812F 16
#define BIT_MASK_FWFF_PKT_QUEUED_8812F 0xff
#define BIT_FWFF_PKT_QUEUED_8812F(x)                                           \
	(((x) & BIT_MASK_FWFF_PKT_QUEUED_8812F)                                \
	 << BIT_SHIFT_FWFF_PKT_QUEUED_8812F)
#define BITS_FWFF_PKT_QUEUED_8812F                                             \
	(BIT_MASK_FWFF_PKT_QUEUED_8812F << BIT_SHIFT_FWFF_PKT_QUEUED_8812F)
#define BIT_CLEAR_FWFF_PKT_QUEUED_8812F(x) ((x) & (~BITS_FWFF_PKT_QUEUED_8812F))
#define BIT_GET_FWFF_PKT_QUEUED_8812F(x)                                       \
	(((x) >> BIT_SHIFT_FWFF_PKT_QUEUED_8812F) &                            \
	 BIT_MASK_FWFF_PKT_QUEUED_8812F)
#define BIT_SET_FWFF_PKT_QUEUED_8812F(x, v)                                    \
	(BIT_CLEAR_FWFF_PKT_QUEUED_8812F(x) | BIT_FWFF_PKT_QUEUED_8812F(v))

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_FWFF_PKT_STR_ADDR_V2_8812F 0
#define BIT_MASK_FWFF_PKT_STR_ADDR_V2_8812F 0x3fff
#define BIT_FWFF_PKT_STR_ADDR_V2_8812F(x)                                      \
	(((x) & BIT_MASK_FWFF_PKT_STR_ADDR_V2_8812F)                           \
	 << BIT_SHIFT_FWFF_PKT_STR_ADDR_V2_8812F)
#define BITS_FWFF_PKT_STR_ADDR_V2_8812F                                        \
	(BIT_MASK_FWFF_PKT_STR_ADDR_V2_8812F                                   \
	 << BIT_SHIFT_FWFF_PKT_STR_ADDR_V2_8812F)
#define BIT_CLEAR_FWFF_PKT_STR_ADDR_V2_8812F(x)                                \
	((x) & (~BITS_FWFF_PKT_STR_ADDR_V2_8812F))
#define BIT_GET_FWFF_PKT_STR_ADDR_V2_8812F(x)                                  \
	(((x) >> BIT_SHIFT_FWFF_PKT_STR_ADDR_V2_8812F) &                       \
	 BIT_MASK_FWFF_PKT_STR_ADDR_V2_8812F)
#define BIT_SET_FWFF_PKT_STR_ADDR_V2_8812F(x, v)                               \
	(BIT_CLEAR_FWFF_PKT_STR_ADDR_V2_8812F(x) |                             \
	 BIT_FWFF_PKT_STR_ADDR_V2_8812F(v))

/* 2 REG_RXPKTNUM_8812F */

#define BIT_SHIFT_PKT_NUM_WOL_V1_8812F 16
#define BIT_MASK_PKT_NUM_WOL_V1_8812F 0xffff
#define BIT_PKT_NUM_WOL_V1_8812F(x)                                            \
	(((x) & BIT_MASK_PKT_NUM_WOL_V1_8812F)                                 \
	 << BIT_SHIFT_PKT_NUM_WOL_V1_8812F)
#define BITS_PKT_NUM_WOL_V1_8812F                                              \
	(BIT_MASK_PKT_NUM_WOL_V1_8812F << BIT_SHIFT_PKT_NUM_WOL_V1_8812F)
#define BIT_CLEAR_PKT_NUM_WOL_V1_8812F(x) ((x) & (~BITS_PKT_NUM_WOL_V1_8812F))
#define BIT_GET_PKT_NUM_WOL_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_PKT_NUM_WOL_V1_8812F) &                             \
	 BIT_MASK_PKT_NUM_WOL_V1_8812F)
#define BIT_SET_PKT_NUM_WOL_V1_8812F(x, v)                                     \
	(BIT_CLEAR_PKT_NUM_WOL_V1_8812F(x) | BIT_PKT_NUM_WOL_V1_8812F(v))

#define BIT_SHIFT_RXPKT_NUM_V1_8812F 0
#define BIT_MASK_RXPKT_NUM_V1_8812F 0xffff
#define BIT_RXPKT_NUM_V1_8812F(x)                                              \
	(((x) & BIT_MASK_RXPKT_NUM_V1_8812F) << BIT_SHIFT_RXPKT_NUM_V1_8812F)
#define BITS_RXPKT_NUM_V1_8812F                                                \
	(BIT_MASK_RXPKT_NUM_V1_8812F << BIT_SHIFT_RXPKT_NUM_V1_8812F)
#define BIT_CLEAR_RXPKT_NUM_V1_8812F(x) ((x) & (~BITS_RXPKT_NUM_V1_8812F))
#define BIT_GET_RXPKT_NUM_V1_8812F(x)                                          \
	(((x) >> BIT_SHIFT_RXPKT_NUM_V1_8812F) & BIT_MASK_RXPKT_NUM_V1_8812F)
#define BIT_SET_RXPKT_NUM_V1_8812F(x, v)                                       \
	(BIT_CLEAR_RXPKT_NUM_V1_8812F(x) | BIT_RXPKT_NUM_V1_8812F(v))

/* 2 REG_RXPKTNUM_TH_8812F */

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_RXPKT_NUM_TH_8812F 0
#define BIT_MASK_RXPKT_NUM_TH_8812F 0xff
#define BIT_RXPKT_NUM_TH_8812F(x)                                              \
	(((x) & BIT_MASK_RXPKT_NUM_TH_8812F) << BIT_SHIFT_RXPKT_NUM_TH_8812F)
#define BITS_RXPKT_NUM_TH_8812F                                                \
	(BIT_MASK_RXPKT_NUM_TH_8812F << BIT_SHIFT_RXPKT_NUM_TH_8812F)
#define BIT_CLEAR_RXPKT_NUM_TH_8812F(x) ((x) & (~BITS_RXPKT_NUM_TH_8812F))
#define BIT_GET_RXPKT_NUM_TH_8812F(x)                                          \
	(((x) >> BIT_SHIFT_RXPKT_NUM_TH_8812F) & BIT_MASK_RXPKT_NUM_TH_8812F)
#define BIT_SET_RXPKT_NUM_TH_8812F(x, v)                                       \
	(BIT_CLEAR_RXPKT_NUM_TH_8812F(x) | BIT_RXPKT_NUM_TH_8812F(v))

/* 2 REG_FW_MSG1_8812F */

#define BIT_SHIFT_FW_MSG_REG1_8812F 0
#define BIT_MASK_FW_MSG_REG1_8812F 0xffffffffL
#define BIT_FW_MSG_REG1_8812F(x)                                               \
	(((x) & BIT_MASK_FW_MSG_REG1_8812F) << BIT_SHIFT_FW_MSG_REG1_8812F)
#define BITS_FW_MSG_REG1_8812F                                                 \
	(BIT_MASK_FW_MSG_REG1_8812F << BIT_SHIFT_FW_MSG_REG1_8812F)
#define BIT_CLEAR_FW_MSG_REG1_8812F(x) ((x) & (~BITS_FW_MSG_REG1_8812F))
#define BIT_GET_FW_MSG_REG1_8812F(x)                                           \
	(((x) >> BIT_SHIFT_FW_MSG_REG1_8812F) & BIT_MASK_FW_MSG_REG1_8812F)
#define BIT_SET_FW_MSG_REG1_8812F(x, v)                                        \
	(BIT_CLEAR_FW_MSG_REG1_8812F(x) | BIT_FW_MSG_REG1_8812F(v))

/* 2 REG_FW_MSG2_8812F */

#define BIT_SHIFT_FW_MSG_REG2_8812F 0
#define BIT_MASK_FW_MSG_REG2_8812F 0xffffffffL
#define BIT_FW_MSG_REG2_8812F(x)                                               \
	(((x) & BIT_MASK_FW_MSG_REG2_8812F) << BIT_SHIFT_FW_MSG_REG2_8812F)
#define BITS_FW_MSG_REG2_8812F                                                 \
	(BIT_MASK_FW_MSG_REG2_8812F << BIT_SHIFT_FW_MSG_REG2_8812F)
#define BIT_CLEAR_FW_MSG_REG2_8812F(x) ((x) & (~BITS_FW_MSG_REG2_8812F))
#define BIT_GET_FW_MSG_REG2_8812F(x)                                           \
	(((x) >> BIT_SHIFT_FW_MSG_REG2_8812F) & BIT_MASK_FW_MSG_REG2_8812F)
#define BIT_SET_FW_MSG_REG2_8812F(x, v)                                        \
	(BIT_CLEAR_FW_MSG_REG2_8812F(x) | BIT_FW_MSG_REG2_8812F(v))

/* 2 REG_FW_MSG3_8812F */

#define BIT_SHIFT_FW_MSG_REG3_8812F 0
#define BIT_MASK_FW_MSG_REG3_8812F 0xffffffffL
#define BIT_FW_MSG_REG3_8812F(x)                                               \
	(((x) & BIT_MASK_FW_MSG_REG3_8812F) << BIT_SHIFT_FW_MSG_REG3_8812F)
#define BITS_FW_MSG_REG3_8812F                                                 \
	(BIT_MASK_FW_MSG_REG3_8812F << BIT_SHIFT_FW_MSG_REG3_8812F)
#define BIT_CLEAR_FW_MSG_REG3_8812F(x) ((x) & (~BITS_FW_MSG_REG3_8812F))
#define BIT_GET_FW_MSG_REG3_8812F(x)                                           \
	(((x) >> BIT_SHIFT_FW_MSG_REG3_8812F) & BIT_MASK_FW_MSG_REG3_8812F)
#define BIT_SET_FW_MSG_REG3_8812F(x, v)                                        \
	(BIT_CLEAR_FW_MSG_REG3_8812F(x) | BIT_FW_MSG_REG3_8812F(v))

/* 2 REG_FW_MSG4_8812F */

#define BIT_SHIFT_FW_MSG_REG4_8812F 0
#define BIT_MASK_FW_MSG_REG4_8812F 0xffffffffL
#define BIT_FW_MSG_REG4_8812F(x)                                               \
	(((x) & BIT_MASK_FW_MSG_REG4_8812F) << BIT_SHIFT_FW_MSG_REG4_8812F)
#define BITS_FW_MSG_REG4_8812F                                                 \
	(BIT_MASK_FW_MSG_REG4_8812F << BIT_SHIFT_FW_MSG_REG4_8812F)
#define BIT_CLEAR_FW_MSG_REG4_8812F(x) ((x) & (~BITS_FW_MSG_REG4_8812F))
#define BIT_GET_FW_MSG_REG4_8812F(x)                                           \
	(((x) >> BIT_SHIFT_FW_MSG_REG4_8812F) & BIT_MASK_FW_MSG_REG4_8812F)
#define BIT_SET_FW_MSG_REG4_8812F(x, v)                                        \
	(BIT_CLEAR_FW_MSG_REG4_8812F(x) | BIT_FW_MSG_REG4_8812F(v))

/* 2 REG_DDMA_CH0SA_8812F */

#define BIT_SHIFT_DDMACH0_SA_8812F 0
#define BIT_MASK_DDMACH0_SA_8812F 0xffffffffL
#define BIT_DDMACH0_SA_8812F(x)                                                \
	(((x) & BIT_MASK_DDMACH0_SA_8812F) << BIT_SHIFT_DDMACH0_SA_8812F)
#define BITS_DDMACH0_SA_8812F                                                  \
	(BIT_MASK_DDMACH0_SA_8812F << BIT_SHIFT_DDMACH0_SA_8812F)
#define BIT_CLEAR_DDMACH0_SA_8812F(x) ((x) & (~BITS_DDMACH0_SA_8812F))
#define BIT_GET_DDMACH0_SA_8812F(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH0_SA_8812F) & BIT_MASK_DDMACH0_SA_8812F)
#define BIT_SET_DDMACH0_SA_8812F(x, v)                                         \
	(BIT_CLEAR_DDMACH0_SA_8812F(x) | BIT_DDMACH0_SA_8812F(v))

/* 2 REG_DDMA_CH0DA_8812F */

#define BIT_SHIFT_DDMACH0_DA_8812F 0
#define BIT_MASK_DDMACH0_DA_8812F 0xffffffffL
#define BIT_DDMACH0_DA_8812F(x)                                                \
	(((x) & BIT_MASK_DDMACH0_DA_8812F) << BIT_SHIFT_DDMACH0_DA_8812F)
#define BITS_DDMACH0_DA_8812F                                                  \
	(BIT_MASK_DDMACH0_DA_8812F << BIT_SHIFT_DDMACH0_DA_8812F)
#define BIT_CLEAR_DDMACH0_DA_8812F(x) ((x) & (~BITS_DDMACH0_DA_8812F))
#define BIT_GET_DDMACH0_DA_8812F(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH0_DA_8812F) & BIT_MASK_DDMACH0_DA_8812F)
#define BIT_SET_DDMACH0_DA_8812F(x, v)                                         \
	(BIT_CLEAR_DDMACH0_DA_8812F(x) | BIT_DDMACH0_DA_8812F(v))

/* 2 REG_DDMA_CH0CTRL_8812F */
#define BIT_DDMACH0_OWN_8812F BIT(31)
#define BIT_DDMACH0_IDMEM_ERR_8812F BIT(30)
#define BIT_DDMACH0_CHKSUM_EN_8812F BIT(29)
#define BIT_DDMACH0_DA_W_DISABLE_8812F BIT(28)
#define BIT_DDMACH0_CHKSUM_STS_8812F BIT(27)
#define BIT_DDMACH0_DDMA_MODE_8812F BIT(26)
#define BIT_DDMACH0_RESET_CHKSUM_STS_8812F BIT(25)
#define BIT_DDMACH0_CHKSUM_CONT_8812F BIT(24)

#define BIT_SHIFT_DDMACH0_DLEN_8812F 0
#define BIT_MASK_DDMACH0_DLEN_8812F 0x3ffff
#define BIT_DDMACH0_DLEN_8812F(x)                                              \
	(((x) & BIT_MASK_DDMACH0_DLEN_8812F) << BIT_SHIFT_DDMACH0_DLEN_8812F)
#define BITS_DDMACH0_DLEN_8812F                                                \
	(BIT_MASK_DDMACH0_DLEN_8812F << BIT_SHIFT_DDMACH0_DLEN_8812F)
#define BIT_CLEAR_DDMACH0_DLEN_8812F(x) ((x) & (~BITS_DDMACH0_DLEN_8812F))
#define BIT_GET_DDMACH0_DLEN_8812F(x)                                          \
	(((x) >> BIT_SHIFT_DDMACH0_DLEN_8812F) & BIT_MASK_DDMACH0_DLEN_8812F)
#define BIT_SET_DDMACH0_DLEN_8812F(x, v)                                       \
	(BIT_CLEAR_DDMACH0_DLEN_8812F(x) | BIT_DDMACH0_DLEN_8812F(v))

/* 2 REG_DDMA_CH1SA_8812F */

#define BIT_SHIFT_DDMACH1_SA_8812F 0
#define BIT_MASK_DDMACH1_SA_8812F 0xffffffffL
#define BIT_DDMACH1_SA_8812F(x)                                                \
	(((x) & BIT_MASK_DDMACH1_SA_8812F) << BIT_SHIFT_DDMACH1_SA_8812F)
#define BITS_DDMACH1_SA_8812F                                                  \
	(BIT_MASK_DDMACH1_SA_8812F << BIT_SHIFT_DDMACH1_SA_8812F)
#define BIT_CLEAR_DDMACH1_SA_8812F(x) ((x) & (~BITS_DDMACH1_SA_8812F))
#define BIT_GET_DDMACH1_SA_8812F(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH1_SA_8812F) & BIT_MASK_DDMACH1_SA_8812F)
#define BIT_SET_DDMACH1_SA_8812F(x, v)                                         \
	(BIT_CLEAR_DDMACH1_SA_8812F(x) | BIT_DDMACH1_SA_8812F(v))

/* 2 REG_DDMA_CH1DA_8812F */

#define BIT_SHIFT_DDMACH1_DA_8812F 0
#define BIT_MASK_DDMACH1_DA_8812F 0xffffffffL
#define BIT_DDMACH1_DA_8812F(x)                                                \
	(((x) & BIT_MASK_DDMACH1_DA_8812F) << BIT_SHIFT_DDMACH1_DA_8812F)
#define BITS_DDMACH1_DA_8812F                                                  \
	(BIT_MASK_DDMACH1_DA_8812F << BIT_SHIFT_DDMACH1_DA_8812F)
#define BIT_CLEAR_DDMACH1_DA_8812F(x) ((x) & (~BITS_DDMACH1_DA_8812F))
#define BIT_GET_DDMACH1_DA_8812F(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH1_DA_8812F) & BIT_MASK_DDMACH1_DA_8812F)
#define BIT_SET_DDMACH1_DA_8812F(x, v)                                         \
	(BIT_CLEAR_DDMACH1_DA_8812F(x) | BIT_DDMACH1_DA_8812F(v))

/* 2 REG_DDMA_CH1CTRL_8812F */
#define BIT_DDMACH1_OWN_8812F BIT(31)
#define BIT_DDMACH1_IDMEM_ERR_8812F BIT(30)
#define BIT_DDMACH1_CHKSUM_EN_8812F BIT(29)
#define BIT_DDMACH1_DA_W_DISABLE_8812F BIT(28)
#define BIT_DDMACH1_CHKSUM_STS_8812F BIT(27)
#define BIT_DDMACH1_DDMA_MODE_8812F BIT(26)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_DDMACH1_DLEN_8812F 0
#define BIT_MASK_DDMACH1_DLEN_8812F 0x3ffff
#define BIT_DDMACH1_DLEN_8812F(x)                                              \
	(((x) & BIT_MASK_DDMACH1_DLEN_8812F) << BIT_SHIFT_DDMACH1_DLEN_8812F)
#define BITS_DDMACH1_DLEN_8812F                                                \
	(BIT_MASK_DDMACH1_DLEN_8812F << BIT_SHIFT_DDMACH1_DLEN_8812F)
#define BIT_CLEAR_DDMACH1_DLEN_8812F(x) ((x) & (~BITS_DDMACH1_DLEN_8812F))
#define BIT_GET_DDMACH1_DLEN_8812F(x)                                          \
	(((x) >> BIT_SHIFT_DDMACH1_DLEN_8812F) & BIT_MASK_DDMACH1_DLEN_8812F)
#define BIT_SET_DDMACH1_DLEN_8812F(x, v)                                       \
	(BIT_CLEAR_DDMACH1_DLEN_8812F(x) | BIT_DDMACH1_DLEN_8812F(v))

/* 2 REG_DDMA_CH2SA_8812F */

#define BIT_SHIFT_DDMACH2_SA_8812F 0
#define BIT_MASK_DDMACH2_SA_8812F 0xffffffffL
#define BIT_DDMACH2_SA_8812F(x)                                                \
	(((x) & BIT_MASK_DDMACH2_SA_8812F) << BIT_SHIFT_DDMACH2_SA_8812F)
#define BITS_DDMACH2_SA_8812F                                                  \
	(BIT_MASK_DDMACH2_SA_8812F << BIT_SHIFT_DDMACH2_SA_8812F)
#define BIT_CLEAR_DDMACH2_SA_8812F(x) ((x) & (~BITS_DDMACH2_SA_8812F))
#define BIT_GET_DDMACH2_SA_8812F(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH2_SA_8812F) & BIT_MASK_DDMACH2_SA_8812F)
#define BIT_SET_DDMACH2_SA_8812F(x, v)                                         \
	(BIT_CLEAR_DDMACH2_SA_8812F(x) | BIT_DDMACH2_SA_8812F(v))

/* 2 REG_DDMA_CH2DA_8812F */

#define BIT_SHIFT_DDMACH2_DA_8812F 0
#define BIT_MASK_DDMACH2_DA_8812F 0xffffffffL
#define BIT_DDMACH2_DA_8812F(x)                                                \
	(((x) & BIT_MASK_DDMACH2_DA_8812F) << BIT_SHIFT_DDMACH2_DA_8812F)
#define BITS_DDMACH2_DA_8812F                                                  \
	(BIT_MASK_DDMACH2_DA_8812F << BIT_SHIFT_DDMACH2_DA_8812F)
#define BIT_CLEAR_DDMACH2_DA_8812F(x) ((x) & (~BITS_DDMACH2_DA_8812F))
#define BIT_GET_DDMACH2_DA_8812F(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH2_DA_8812F) & BIT_MASK_DDMACH2_DA_8812F)
#define BIT_SET_DDMACH2_DA_8812F(x, v)                                         \
	(BIT_CLEAR_DDMACH2_DA_8812F(x) | BIT_DDMACH2_DA_8812F(v))

/* 2 REG_DDMA_CH2CTRL_8812F */
#define BIT_DDMACH2_OWN_8812F BIT(31)
#define BIT_DDMACH2_IDMEM_ERR_8812F BIT(30)
#define BIT_DDMACH2_CHKSUM_EN_8812F BIT(29)
#define BIT_DDMACH2_DA_W_DISABLE_8812F BIT(28)
#define BIT_DDMACH2_CHKSUM_STS_8812F BIT(27)
#define BIT_DDMACH2_DDMA_MODE_8812F BIT(26)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_DDMACH2_DLEN_8812F 0
#define BIT_MASK_DDMACH2_DLEN_8812F 0x3ffff
#define BIT_DDMACH2_DLEN_8812F(x)                                              \
	(((x) & BIT_MASK_DDMACH2_DLEN_8812F) << BIT_SHIFT_DDMACH2_DLEN_8812F)
#define BITS_DDMACH2_DLEN_8812F                                                \
	(BIT_MASK_DDMACH2_DLEN_8812F << BIT_SHIFT_DDMACH2_DLEN_8812F)
#define BIT_CLEAR_DDMACH2_DLEN_8812F(x) ((x) & (~BITS_DDMACH2_DLEN_8812F))
#define BIT_GET_DDMACH2_DLEN_8812F(x)                                          \
	(((x) >> BIT_SHIFT_DDMACH2_DLEN_8812F) & BIT_MASK_DDMACH2_DLEN_8812F)
#define BIT_SET_DDMACH2_DLEN_8812F(x, v)                                       \
	(BIT_CLEAR_DDMACH2_DLEN_8812F(x) | BIT_DDMACH2_DLEN_8812F(v))

/* 2 REG_DDMA_CH3SA_8812F */

#define BIT_SHIFT_DDMACH3_SA_8812F 0
#define BIT_MASK_DDMACH3_SA_8812F 0xffffffffL
#define BIT_DDMACH3_SA_8812F(x)                                                \
	(((x) & BIT_MASK_DDMACH3_SA_8812F) << BIT_SHIFT_DDMACH3_SA_8812F)
#define BITS_DDMACH3_SA_8812F                                                  \
	(BIT_MASK_DDMACH3_SA_8812F << BIT_SHIFT_DDMACH3_SA_8812F)
#define BIT_CLEAR_DDMACH3_SA_8812F(x) ((x) & (~BITS_DDMACH3_SA_8812F))
#define BIT_GET_DDMACH3_SA_8812F(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH3_SA_8812F) & BIT_MASK_DDMACH3_SA_8812F)
#define BIT_SET_DDMACH3_SA_8812F(x, v)                                         \
	(BIT_CLEAR_DDMACH3_SA_8812F(x) | BIT_DDMACH3_SA_8812F(v))

/* 2 REG_DDMA_CH3DA_8812F */

#define BIT_SHIFT_DDMACH3_DA_8812F 0
#define BIT_MASK_DDMACH3_DA_8812F 0xffffffffL
#define BIT_DDMACH3_DA_8812F(x)                                                \
	(((x) & BIT_MASK_DDMACH3_DA_8812F) << BIT_SHIFT_DDMACH3_DA_8812F)
#define BITS_DDMACH3_DA_8812F                                                  \
	(BIT_MASK_DDMACH3_DA_8812F << BIT_SHIFT_DDMACH3_DA_8812F)
#define BIT_CLEAR_DDMACH3_DA_8812F(x) ((x) & (~BITS_DDMACH3_DA_8812F))
#define BIT_GET_DDMACH3_DA_8812F(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH3_DA_8812F) & BIT_MASK_DDMACH3_DA_8812F)
#define BIT_SET_DDMACH3_DA_8812F(x, v)                                         \
	(BIT_CLEAR_DDMACH3_DA_8812F(x) | BIT_DDMACH3_DA_8812F(v))

/* 2 REG_DDMA_CH3CTRL_8812F */
#define BIT_DDMACH3_OWN_8812F BIT(31)
#define BIT_DDMACH3_IDMEM_ERR_8812F BIT(30)
#define BIT_DDMACH3_CHKSUM_EN_8812F BIT(29)
#define BIT_DDMACH3_DA_W_DISABLE_8812F BIT(28)
#define BIT_DDMACH3_CHKSUM_STS_8812F BIT(27)
#define BIT_DDMACH3_DDMA_MODE_8812F BIT(26)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_DDMACH3_DLEN_8812F 0
#define BIT_MASK_DDMACH3_DLEN_8812F 0x3ffff
#define BIT_DDMACH3_DLEN_8812F(x)                                              \
	(((x) & BIT_MASK_DDMACH3_DLEN_8812F) << BIT_SHIFT_DDMACH3_DLEN_8812F)
#define BITS_DDMACH3_DLEN_8812F                                                \
	(BIT_MASK_DDMACH3_DLEN_8812F << BIT_SHIFT_DDMACH3_DLEN_8812F)
#define BIT_CLEAR_DDMACH3_DLEN_8812F(x) ((x) & (~BITS_DDMACH3_DLEN_8812F))
#define BIT_GET_DDMACH3_DLEN_8812F(x)                                          \
	(((x) >> BIT_SHIFT_DDMACH3_DLEN_8812F) & BIT_MASK_DDMACH3_DLEN_8812F)
#define BIT_SET_DDMACH3_DLEN_8812F(x, v)                                       \
	(BIT_CLEAR_DDMACH3_DLEN_8812F(x) | BIT_DDMACH3_DLEN_8812F(v))

/* 2 REG_DDMA_CH4SA_8812F */

#define BIT_SHIFT_DDMACH4_SA_8812F 0
#define BIT_MASK_DDMACH4_SA_8812F 0xffffffffL
#define BIT_DDMACH4_SA_8812F(x)                                                \
	(((x) & BIT_MASK_DDMACH4_SA_8812F) << BIT_SHIFT_DDMACH4_SA_8812F)
#define BITS_DDMACH4_SA_8812F                                                  \
	(BIT_MASK_DDMACH4_SA_8812F << BIT_SHIFT_DDMACH4_SA_8812F)
#define BIT_CLEAR_DDMACH4_SA_8812F(x) ((x) & (~BITS_DDMACH4_SA_8812F))
#define BIT_GET_DDMACH4_SA_8812F(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH4_SA_8812F) & BIT_MASK_DDMACH4_SA_8812F)
#define BIT_SET_DDMACH4_SA_8812F(x, v)                                         \
	(BIT_CLEAR_DDMACH4_SA_8812F(x) | BIT_DDMACH4_SA_8812F(v))

/* 2 REG_DDMA_CH4DA_8812F */

#define BIT_SHIFT_DDMACH4_DA_8812F 0
#define BIT_MASK_DDMACH4_DA_8812F 0xffffffffL
#define BIT_DDMACH4_DA_8812F(x)                                                \
	(((x) & BIT_MASK_DDMACH4_DA_8812F) << BIT_SHIFT_DDMACH4_DA_8812F)
#define BITS_DDMACH4_DA_8812F                                                  \
	(BIT_MASK_DDMACH4_DA_8812F << BIT_SHIFT_DDMACH4_DA_8812F)
#define BIT_CLEAR_DDMACH4_DA_8812F(x) ((x) & (~BITS_DDMACH4_DA_8812F))
#define BIT_GET_DDMACH4_DA_8812F(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH4_DA_8812F) & BIT_MASK_DDMACH4_DA_8812F)
#define BIT_SET_DDMACH4_DA_8812F(x, v)                                         \
	(BIT_CLEAR_DDMACH4_DA_8812F(x) | BIT_DDMACH4_DA_8812F(v))

/* 2 REG_DDMA_CH4CTRL_8812F */
#define BIT_DDMACH4_OWN_8812F BIT(31)
#define BIT_DDMACH4_IDMEM_ERR_8812F BIT(30)
#define BIT_DDMACH4_CHKSUM_EN_8812F BIT(29)
#define BIT_DDMACH4_DA_W_DISABLE_8812F BIT(28)
#define BIT_DDMACH4_CHKSUM_STS_8812F BIT(27)
#define BIT_DDMACH4_DDMA_MODE_8812F BIT(26)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_DDMACH4_DLEN_8812F 0
#define BIT_MASK_DDMACH4_DLEN_8812F 0x3ffff
#define BIT_DDMACH4_DLEN_8812F(x)                                              \
	(((x) & BIT_MASK_DDMACH4_DLEN_8812F) << BIT_SHIFT_DDMACH4_DLEN_8812F)
#define BITS_DDMACH4_DLEN_8812F                                                \
	(BIT_MASK_DDMACH4_DLEN_8812F << BIT_SHIFT_DDMACH4_DLEN_8812F)
#define BIT_CLEAR_DDMACH4_DLEN_8812F(x) ((x) & (~BITS_DDMACH4_DLEN_8812F))
#define BIT_GET_DDMACH4_DLEN_8812F(x)                                          \
	(((x) >> BIT_SHIFT_DDMACH4_DLEN_8812F) & BIT_MASK_DDMACH4_DLEN_8812F)
#define BIT_SET_DDMACH4_DLEN_8812F(x, v)                                       \
	(BIT_CLEAR_DDMACH4_DLEN_8812F(x) | BIT_DDMACH4_DLEN_8812F(v))

/* 2 REG_DDMA_CH5SA_8812F */

#define BIT_SHIFT_DDMACH5_SA_8812F 0
#define BIT_MASK_DDMACH5_SA_8812F 0xffffffffL
#define BIT_DDMACH5_SA_8812F(x)                                                \
	(((x) & BIT_MASK_DDMACH5_SA_8812F) << BIT_SHIFT_DDMACH5_SA_8812F)
#define BITS_DDMACH5_SA_8812F                                                  \
	(BIT_MASK_DDMACH5_SA_8812F << BIT_SHIFT_DDMACH5_SA_8812F)
#define BIT_CLEAR_DDMACH5_SA_8812F(x) ((x) & (~BITS_DDMACH5_SA_8812F))
#define BIT_GET_DDMACH5_SA_8812F(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH5_SA_8812F) & BIT_MASK_DDMACH5_SA_8812F)
#define BIT_SET_DDMACH5_SA_8812F(x, v)                                         \
	(BIT_CLEAR_DDMACH5_SA_8812F(x) | BIT_DDMACH5_SA_8812F(v))

/* 2 REG_DDMA_CH5DA_8812F */

#define BIT_SHIFT_DDMACH5_DA_8812F 0
#define BIT_MASK_DDMACH5_DA_8812F 0xffffffffL
#define BIT_DDMACH5_DA_8812F(x)                                                \
	(((x) & BIT_MASK_DDMACH5_DA_8812F) << BIT_SHIFT_DDMACH5_DA_8812F)
#define BITS_DDMACH5_DA_8812F                                                  \
	(BIT_MASK_DDMACH5_DA_8812F << BIT_SHIFT_DDMACH5_DA_8812F)
#define BIT_CLEAR_DDMACH5_DA_8812F(x) ((x) & (~BITS_DDMACH5_DA_8812F))
#define BIT_GET_DDMACH5_DA_8812F(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH5_DA_8812F) & BIT_MASK_DDMACH5_DA_8812F)
#define BIT_SET_DDMACH5_DA_8812F(x, v)                                         \
	(BIT_CLEAR_DDMACH5_DA_8812F(x) | BIT_DDMACH5_DA_8812F(v))

/* 2 REG_DDMA_CH5CTRL_8812F */
#define BIT_DDMACH5_OWN_8812F BIT(31)
#define BIT_DDMACH5_IDMEM_ERR_8812F BIT(30)
#define BIT_DDMACH5_CHKSUM_EN_8812F BIT(29)
#define BIT_DDMACH5_DA_W_DISABLE_8812F BIT(28)
#define BIT_DDMACH5_CHKSUM_STS_8812F BIT(27)
#define BIT_DDMACH5_DDMA_MODE_8812F BIT(26)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_DDMACH5_DLEN_8812F 0
#define BIT_MASK_DDMACH5_DLEN_8812F 0x3ffff
#define BIT_DDMACH5_DLEN_8812F(x)                                              \
	(((x) & BIT_MASK_DDMACH5_DLEN_8812F) << BIT_SHIFT_DDMACH5_DLEN_8812F)
#define BITS_DDMACH5_DLEN_8812F                                                \
	(BIT_MASK_DDMACH5_DLEN_8812F << BIT_SHIFT_DDMACH5_DLEN_8812F)
#define BIT_CLEAR_DDMACH5_DLEN_8812F(x) ((x) & (~BITS_DDMACH5_DLEN_8812F))
#define BIT_GET_DDMACH5_DLEN_8812F(x)                                          \
	(((x) >> BIT_SHIFT_DDMACH5_DLEN_8812F) & BIT_MASK_DDMACH5_DLEN_8812F)
#define BIT_SET_DDMACH5_DLEN_8812F(x, v)                                       \
	(BIT_CLEAR_DDMACH5_DLEN_8812F(x) | BIT_DDMACH5_DLEN_8812F(v))

/* 2 REG_DDMA_INT_MSK_8812F */
#define BIT_DDMACH5_MSK_8812F BIT(5)
#define BIT_DDMACH4_MSK_8812F BIT(4)
#define BIT_DDMACH3_MSK_8812F BIT(3)
#define BIT_DDMACH2_MSK_8812F BIT(2)
#define BIT_DDMACH1_MSK_8812F BIT(1)
#define BIT_DDMACH0_MSK_8812F BIT(0)

/* 2 REG_DDMA_CHSTATUS_8812F */
#define BIT_DDMACH5_BUSY_8812F BIT(5)
#define BIT_DDMACH4_BUSY_8812F BIT(4)
#define BIT_DDMACH3_BUSY_8812F BIT(3)
#define BIT_DDMACH2_BUSY_8812F BIT(2)
#define BIT_DDMACH1_BUSY_8812F BIT(1)
#define BIT_DDMACH0_BUSY_8812F BIT(0)

/* 2 REG_DDMA_CHKSUM_8812F */

#define BIT_SHIFT_IDDMA0_CHKSUM_8812F 0
#define BIT_MASK_IDDMA0_CHKSUM_8812F 0xffff
#define BIT_IDDMA0_CHKSUM_8812F(x)                                             \
	(((x) & BIT_MASK_IDDMA0_CHKSUM_8812F) << BIT_SHIFT_IDDMA0_CHKSUM_8812F)
#define BITS_IDDMA0_CHKSUM_8812F                                               \
	(BIT_MASK_IDDMA0_CHKSUM_8812F << BIT_SHIFT_IDDMA0_CHKSUM_8812F)
#define BIT_CLEAR_IDDMA0_CHKSUM_8812F(x) ((x) & (~BITS_IDDMA0_CHKSUM_8812F))
#define BIT_GET_IDDMA0_CHKSUM_8812F(x)                                         \
	(((x) >> BIT_SHIFT_IDDMA0_CHKSUM_8812F) & BIT_MASK_IDDMA0_CHKSUM_8812F)
#define BIT_SET_IDDMA0_CHKSUM_8812F(x, v)                                      \
	(BIT_CLEAR_IDDMA0_CHKSUM_8812F(x) | BIT_IDDMA0_CHKSUM_8812F(v))

/* 2 REG_DDMA_MONITOR_8812F */
#define BIT_IDDMA0_PERMU_UNDERFLOW_8812F BIT(14)
#define BIT_IDDMA0_FIFO_UNDERFLOW_8812F BIT(13)
#define BIT_IDDMA0_FIFO_OVERFLOW_8812F BIT(12)
#define BIT_CH5_ERR_8812F BIT(5)
#define BIT_CH4_ERR_8812F BIT(4)
#define BIT_CH3_ERR_8812F BIT(3)
#define BIT_CH2_ERR_8812F BIT(2)
#define BIT_CH1_ERR_8812F BIT(1)
#define BIT_CH0_ERR_8812F BIT(0)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_PCIE_CTRL_8812F */
#define BIT_PCIEIO_PERSTB_SEL_8812F BIT(31)

#define BIT_SHIFT_PCIE_MAX_RXDMA_8812F 28
#define BIT_MASK_PCIE_MAX_RXDMA_8812F 0x7
#define BIT_PCIE_MAX_RXDMA_8812F(x)                                            \
	(((x) & BIT_MASK_PCIE_MAX_RXDMA_8812F)                                 \
	 << BIT_SHIFT_PCIE_MAX_RXDMA_8812F)
#define BITS_PCIE_MAX_RXDMA_8812F                                              \
	(BIT_MASK_PCIE_MAX_RXDMA_8812F << BIT_SHIFT_PCIE_MAX_RXDMA_8812F)
#define BIT_CLEAR_PCIE_MAX_RXDMA_8812F(x) ((x) & (~BITS_PCIE_MAX_RXDMA_8812F))
#define BIT_GET_PCIE_MAX_RXDMA_8812F(x)                                        \
	(((x) >> BIT_SHIFT_PCIE_MAX_RXDMA_8812F) &                             \
	 BIT_MASK_PCIE_MAX_RXDMA_8812F)
#define BIT_SET_PCIE_MAX_RXDMA_8812F(x, v)                                     \
	(BIT_CLEAR_PCIE_MAX_RXDMA_8812F(x) | BIT_PCIE_MAX_RXDMA_8812F(v))

#define BIT_SHIFT_PCIE_MAX_TXDMA_8812F 24
#define BIT_MASK_PCIE_MAX_TXDMA_8812F 0x7
#define BIT_PCIE_MAX_TXDMA_8812F(x)                                            \
	(((x) & BIT_MASK_PCIE_MAX_TXDMA_8812F)                                 \
	 << BIT_SHIFT_PCIE_MAX_TXDMA_8812F)
#define BITS_PCIE_MAX_TXDMA_8812F                                              \
	(BIT_MASK_PCIE_MAX_TXDMA_8812F << BIT_SHIFT_PCIE_MAX_TXDMA_8812F)
#define BIT_CLEAR_PCIE_MAX_TXDMA_8812F(x) ((x) & (~BITS_PCIE_MAX_TXDMA_8812F))
#define BIT_GET_PCIE_MAX_TXDMA_8812F(x)                                        \
	(((x) >> BIT_SHIFT_PCIE_MAX_TXDMA_8812F) &                             \
	 BIT_MASK_PCIE_MAX_TXDMA_8812F)
#define BIT_SET_PCIE_MAX_TXDMA_8812F(x, v)                                     \
	(BIT_CLEAR_PCIE_MAX_TXDMA_8812F(x) | BIT_PCIE_MAX_TXDMA_8812F(v))

#define BIT_EN_CPL_TIMEOUT_PS_8812F BIT(22)
#define BIT_REG_TXDMA_FAIL_PS_8812F BIT(21)
#define BIT_PCIE_RST_TRXDMA_INTF_8812F BIT(20)
#define BIT_EN_HWENTR_L1_8812F BIT(19)
#define BIT_EN_ADV_CLKGATE_8812F BIT(18)
#define BIT_PCIE_EN_SWENT_L23_8812F BIT(17)
#define BIT_PCIE_EN_HWEXT_L1_8812F BIT(16)
#define BIT_RX_CLOSE_EN_8812F BIT(15)
#define BIT_STOP_BCNQ_8812F BIT(14)
#define BIT_STOP_MGQ_8812F BIT(13)
#define BIT_STOP_VOQ_8812F BIT(12)
#define BIT_STOP_VIQ_8812F BIT(11)
#define BIT_STOP_BEQ_8812F BIT(10)
#define BIT_STOP_BKQ_8812F BIT(9)
#define BIT_STOP_RXQ_8812F BIT(8)
#define BIT_STOP_HI7Q_8812F BIT(7)
#define BIT_STOP_HI6Q_8812F BIT(6)
#define BIT_STOP_HI5Q_8812F BIT(5)
#define BIT_STOP_HI4Q_8812F BIT(4)
#define BIT_STOP_HI3Q_8812F BIT(3)
#define BIT_STOP_HI2Q_8812F BIT(2)
#define BIT_STOP_HI1Q_8812F BIT(1)
#define BIT_STOP_HI0Q_8812F BIT(0)

/* 2 REG_INT_MIG_8812F */

#define BIT_SHIFT_TRXCOUNTER_MATCH_8812F 24
#define BIT_MASK_TRXCOUNTER_MATCH_8812F 0xff
#define BIT_TRXCOUNTER_MATCH_8812F(x)                                          \
	(((x) & BIT_MASK_TRXCOUNTER_MATCH_8812F)                               \
	 << BIT_SHIFT_TRXCOUNTER_MATCH_8812F)
#define BITS_TRXCOUNTER_MATCH_8812F                                            \
	(BIT_MASK_TRXCOUNTER_MATCH_8812F << BIT_SHIFT_TRXCOUNTER_MATCH_8812F)
#define BIT_CLEAR_TRXCOUNTER_MATCH_8812F(x)                                    \
	((x) & (~BITS_TRXCOUNTER_MATCH_8812F))
#define BIT_GET_TRXCOUNTER_MATCH_8812F(x)                                      \
	(((x) >> BIT_SHIFT_TRXCOUNTER_MATCH_8812F) &                           \
	 BIT_MASK_TRXCOUNTER_MATCH_8812F)
#define BIT_SET_TRXCOUNTER_MATCH_8812F(x, v)                                   \
	(BIT_CLEAR_TRXCOUNTER_MATCH_8812F(x) | BIT_TRXCOUNTER_MATCH_8812F(v))

#define BIT_SHIFT_TRXTIMER_MATCH_8812F 16
#define BIT_MASK_TRXTIMER_MATCH_8812F 0xff
#define BIT_TRXTIMER_MATCH_8812F(x)                                            \
	(((x) & BIT_MASK_TRXTIMER_MATCH_8812F)                                 \
	 << BIT_SHIFT_TRXTIMER_MATCH_8812F)
#define BITS_TRXTIMER_MATCH_8812F                                              \
	(BIT_MASK_TRXTIMER_MATCH_8812F << BIT_SHIFT_TRXTIMER_MATCH_8812F)
#define BIT_CLEAR_TRXTIMER_MATCH_8812F(x) ((x) & (~BITS_TRXTIMER_MATCH_8812F))
#define BIT_GET_TRXTIMER_MATCH_8812F(x)                                        \
	(((x) >> BIT_SHIFT_TRXTIMER_MATCH_8812F) &                             \
	 BIT_MASK_TRXTIMER_MATCH_8812F)
#define BIT_SET_TRXTIMER_MATCH_8812F(x, v)                                     \
	(BIT_CLEAR_TRXTIMER_MATCH_8812F(x) | BIT_TRXTIMER_MATCH_8812F(v))

#define BIT_SHIFT_TRXTIMER_UNIT_8812F 0
#define BIT_MASK_TRXTIMER_UNIT_8812F 0x3
#define BIT_TRXTIMER_UNIT_8812F(x)                                             \
	(((x) & BIT_MASK_TRXTIMER_UNIT_8812F) << BIT_SHIFT_TRXTIMER_UNIT_8812F)
#define BITS_TRXTIMER_UNIT_8812F                                               \
	(BIT_MASK_TRXTIMER_UNIT_8812F << BIT_SHIFT_TRXTIMER_UNIT_8812F)
#define BIT_CLEAR_TRXTIMER_UNIT_8812F(x) ((x) & (~BITS_TRXTIMER_UNIT_8812F))
#define BIT_GET_TRXTIMER_UNIT_8812F(x)                                         \
	(((x) >> BIT_SHIFT_TRXTIMER_UNIT_8812F) & BIT_MASK_TRXTIMER_UNIT_8812F)
#define BIT_SET_TRXTIMER_UNIT_8812F(x, v)                                      \
	(BIT_CLEAR_TRXTIMER_UNIT_8812F(x) | BIT_TRXTIMER_UNIT_8812F(v))

/* 2 REG_BCNQ_TXBD_DESA_8812F */

#define BIT_SHIFT_BCNQ_TXBD_DESA_8812F 0
#define BIT_MASK_BCNQ_TXBD_DESA_8812F 0xffffffffffffffffL
#define BIT_BCNQ_TXBD_DESA_8812F(x)                                            \
	(((x) & BIT_MASK_BCNQ_TXBD_DESA_8812F)                                 \
	 << BIT_SHIFT_BCNQ_TXBD_DESA_8812F)
#define BITS_BCNQ_TXBD_DESA_8812F                                              \
	(BIT_MASK_BCNQ_TXBD_DESA_8812F << BIT_SHIFT_BCNQ_TXBD_DESA_8812F)
#define BIT_CLEAR_BCNQ_TXBD_DESA_8812F(x) ((x) & (~BITS_BCNQ_TXBD_DESA_8812F))
#define BIT_GET_BCNQ_TXBD_DESA_8812F(x)                                        \
	(((x) >> BIT_SHIFT_BCNQ_TXBD_DESA_8812F) &                             \
	 BIT_MASK_BCNQ_TXBD_DESA_8812F)
#define BIT_SET_BCNQ_TXBD_DESA_8812F(x, v)                                     \
	(BIT_CLEAR_BCNQ_TXBD_DESA_8812F(x) | BIT_BCNQ_TXBD_DESA_8812F(v))

/* 2 REG_MGQ_TXBD_DESA_8812F */

#define BIT_SHIFT_MGQ_TXBD_DESA_8812F 0
#define BIT_MASK_MGQ_TXBD_DESA_8812F 0xffffffffffffffffL
#define BIT_MGQ_TXBD_DESA_8812F(x)                                             \
	(((x) & BIT_MASK_MGQ_TXBD_DESA_8812F) << BIT_SHIFT_MGQ_TXBD_DESA_8812F)
#define BITS_MGQ_TXBD_DESA_8812F                                               \
	(BIT_MASK_MGQ_TXBD_DESA_8812F << BIT_SHIFT_MGQ_TXBD_DESA_8812F)
#define BIT_CLEAR_MGQ_TXBD_DESA_8812F(x) ((x) & (~BITS_MGQ_TXBD_DESA_8812F))
#define BIT_GET_MGQ_TXBD_DESA_8812F(x)                                         \
	(((x) >> BIT_SHIFT_MGQ_TXBD_DESA_8812F) & BIT_MASK_MGQ_TXBD_DESA_8812F)
#define BIT_SET_MGQ_TXBD_DESA_8812F(x, v)                                      \
	(BIT_CLEAR_MGQ_TXBD_DESA_8812F(x) | BIT_MGQ_TXBD_DESA_8812F(v))

/* 2 REG_VOQ_TXBD_DESA_8812F */

#define BIT_SHIFT_VOQ_TXBD_DESA_8812F 0
#define BIT_MASK_VOQ_TXBD_DESA_8812F 0xffffffffffffffffL
#define BIT_VOQ_TXBD_DESA_8812F(x)                                             \
	(((x) & BIT_MASK_VOQ_TXBD_DESA_8812F) << BIT_SHIFT_VOQ_TXBD_DESA_8812F)
#define BITS_VOQ_TXBD_DESA_8812F                                               \
	(BIT_MASK_VOQ_TXBD_DESA_8812F << BIT_SHIFT_VOQ_TXBD_DESA_8812F)
#define BIT_CLEAR_VOQ_TXBD_DESA_8812F(x) ((x) & (~BITS_VOQ_TXBD_DESA_8812F))
#define BIT_GET_VOQ_TXBD_DESA_8812F(x)                                         \
	(((x) >> BIT_SHIFT_VOQ_TXBD_DESA_8812F) & BIT_MASK_VOQ_TXBD_DESA_8812F)
#define BIT_SET_VOQ_TXBD_DESA_8812F(x, v)                                      \
	(BIT_CLEAR_VOQ_TXBD_DESA_8812F(x) | BIT_VOQ_TXBD_DESA_8812F(v))

/* 2 REG_VIQ_TXBD_DESA_8812F */

#define BIT_SHIFT_VIQ_TXBD_DESA_8812F 0
#define BIT_MASK_VIQ_TXBD_DESA_8812F 0xffffffffffffffffL
#define BIT_VIQ_TXBD_DESA_8812F(x)                                             \
	(((x) & BIT_MASK_VIQ_TXBD_DESA_8812F) << BIT_SHIFT_VIQ_TXBD_DESA_8812F)
#define BITS_VIQ_TXBD_DESA_8812F                                               \
	(BIT_MASK_VIQ_TXBD_DESA_8812F << BIT_SHIFT_VIQ_TXBD_DESA_8812F)
#define BIT_CLEAR_VIQ_TXBD_DESA_8812F(x) ((x) & (~BITS_VIQ_TXBD_DESA_8812F))
#define BIT_GET_VIQ_TXBD_DESA_8812F(x)                                         \
	(((x) >> BIT_SHIFT_VIQ_TXBD_DESA_8812F) & BIT_MASK_VIQ_TXBD_DESA_8812F)
#define BIT_SET_VIQ_TXBD_DESA_8812F(x, v)                                      \
	(BIT_CLEAR_VIQ_TXBD_DESA_8812F(x) | BIT_VIQ_TXBD_DESA_8812F(v))

/* 2 REG_BEQ_TXBD_DESA_8812F */

#define BIT_SHIFT_BEQ_TXBD_DESA_8812F 0
#define BIT_MASK_BEQ_TXBD_DESA_8812F 0xffffffffffffffffL
#define BIT_BEQ_TXBD_DESA_8812F(x)                                             \
	(((x) & BIT_MASK_BEQ_TXBD_DESA_8812F) << BIT_SHIFT_BEQ_TXBD_DESA_8812F)
#define BITS_BEQ_TXBD_DESA_8812F                                               \
	(BIT_MASK_BEQ_TXBD_DESA_8812F << BIT_SHIFT_BEQ_TXBD_DESA_8812F)
#define BIT_CLEAR_BEQ_TXBD_DESA_8812F(x) ((x) & (~BITS_BEQ_TXBD_DESA_8812F))
#define BIT_GET_BEQ_TXBD_DESA_8812F(x)                                         \
	(((x) >> BIT_SHIFT_BEQ_TXBD_DESA_8812F) & BIT_MASK_BEQ_TXBD_DESA_8812F)
#define BIT_SET_BEQ_TXBD_DESA_8812F(x, v)                                      \
	(BIT_CLEAR_BEQ_TXBD_DESA_8812F(x) | BIT_BEQ_TXBD_DESA_8812F(v))

/* 2 REG_BKQ_TXBD_DESA_8812F */

#define BIT_SHIFT_BKQ_TXBD_DESA_8812F 0
#define BIT_MASK_BKQ_TXBD_DESA_8812F 0xffffffffffffffffL
#define BIT_BKQ_TXBD_DESA_8812F(x)                                             \
	(((x) & BIT_MASK_BKQ_TXBD_DESA_8812F) << BIT_SHIFT_BKQ_TXBD_DESA_8812F)
#define BITS_BKQ_TXBD_DESA_8812F                                               \
	(BIT_MASK_BKQ_TXBD_DESA_8812F << BIT_SHIFT_BKQ_TXBD_DESA_8812F)
#define BIT_CLEAR_BKQ_TXBD_DESA_8812F(x) ((x) & (~BITS_BKQ_TXBD_DESA_8812F))
#define BIT_GET_BKQ_TXBD_DESA_8812F(x)                                         \
	(((x) >> BIT_SHIFT_BKQ_TXBD_DESA_8812F) & BIT_MASK_BKQ_TXBD_DESA_8812F)
#define BIT_SET_BKQ_TXBD_DESA_8812F(x, v)                                      \
	(BIT_CLEAR_BKQ_TXBD_DESA_8812F(x) | BIT_BKQ_TXBD_DESA_8812F(v))

/* 2 REG_RXQ_RXBD_DESA_8812F */

#define BIT_SHIFT_RXQ_RXBD_DESA_8812F 0
#define BIT_MASK_RXQ_RXBD_DESA_8812F 0xffffffffffffffffL
#define BIT_RXQ_RXBD_DESA_8812F(x)                                             \
	(((x) & BIT_MASK_RXQ_RXBD_DESA_8812F) << BIT_SHIFT_RXQ_RXBD_DESA_8812F)
#define BITS_RXQ_RXBD_DESA_8812F                                               \
	(BIT_MASK_RXQ_RXBD_DESA_8812F << BIT_SHIFT_RXQ_RXBD_DESA_8812F)
#define BIT_CLEAR_RXQ_RXBD_DESA_8812F(x) ((x) & (~BITS_RXQ_RXBD_DESA_8812F))
#define BIT_GET_RXQ_RXBD_DESA_8812F(x)                                         \
	(((x) >> BIT_SHIFT_RXQ_RXBD_DESA_8812F) & BIT_MASK_RXQ_RXBD_DESA_8812F)
#define BIT_SET_RXQ_RXBD_DESA_8812F(x, v)                                      \
	(BIT_CLEAR_RXQ_RXBD_DESA_8812F(x) | BIT_RXQ_RXBD_DESA_8812F(v))

/* 2 REG_HI0Q_TXBD_DESA_8812F */

#define BIT_SHIFT_HI0Q_TXBD_DESA_8812F 0
#define BIT_MASK_HI0Q_TXBD_DESA_8812F 0xffffffffffffffffL
#define BIT_HI0Q_TXBD_DESA_8812F(x)                                            \
	(((x) & BIT_MASK_HI0Q_TXBD_DESA_8812F)                                 \
	 << BIT_SHIFT_HI0Q_TXBD_DESA_8812F)
#define BITS_HI0Q_TXBD_DESA_8812F                                              \
	(BIT_MASK_HI0Q_TXBD_DESA_8812F << BIT_SHIFT_HI0Q_TXBD_DESA_8812F)
#define BIT_CLEAR_HI0Q_TXBD_DESA_8812F(x) ((x) & (~BITS_HI0Q_TXBD_DESA_8812F))
#define BIT_GET_HI0Q_TXBD_DESA_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HI0Q_TXBD_DESA_8812F) &                             \
	 BIT_MASK_HI0Q_TXBD_DESA_8812F)
#define BIT_SET_HI0Q_TXBD_DESA_8812F(x, v)                                     \
	(BIT_CLEAR_HI0Q_TXBD_DESA_8812F(x) | BIT_HI0Q_TXBD_DESA_8812F(v))

/* 2 REG_HI1Q_TXBD_DESA_8812F */

#define BIT_SHIFT_HI1Q_TXBD_DESA_8812F 0
#define BIT_MASK_HI1Q_TXBD_DESA_8812F 0xffffffffffffffffL
#define BIT_HI1Q_TXBD_DESA_8812F(x)                                            \
	(((x) & BIT_MASK_HI1Q_TXBD_DESA_8812F)                                 \
	 << BIT_SHIFT_HI1Q_TXBD_DESA_8812F)
#define BITS_HI1Q_TXBD_DESA_8812F                                              \
	(BIT_MASK_HI1Q_TXBD_DESA_8812F << BIT_SHIFT_HI1Q_TXBD_DESA_8812F)
#define BIT_CLEAR_HI1Q_TXBD_DESA_8812F(x) ((x) & (~BITS_HI1Q_TXBD_DESA_8812F))
#define BIT_GET_HI1Q_TXBD_DESA_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HI1Q_TXBD_DESA_8812F) &                             \
	 BIT_MASK_HI1Q_TXBD_DESA_8812F)
#define BIT_SET_HI1Q_TXBD_DESA_8812F(x, v)                                     \
	(BIT_CLEAR_HI1Q_TXBD_DESA_8812F(x) | BIT_HI1Q_TXBD_DESA_8812F(v))

/* 2 REG_HI2Q_TXBD_DESA_8812F */

#define BIT_SHIFT_HI2Q_TXBD_DESA_8812F 0
#define BIT_MASK_HI2Q_TXBD_DESA_8812F 0xffffffffffffffffL
#define BIT_HI2Q_TXBD_DESA_8812F(x)                                            \
	(((x) & BIT_MASK_HI2Q_TXBD_DESA_8812F)                                 \
	 << BIT_SHIFT_HI2Q_TXBD_DESA_8812F)
#define BITS_HI2Q_TXBD_DESA_8812F                                              \
	(BIT_MASK_HI2Q_TXBD_DESA_8812F << BIT_SHIFT_HI2Q_TXBD_DESA_8812F)
#define BIT_CLEAR_HI2Q_TXBD_DESA_8812F(x) ((x) & (~BITS_HI2Q_TXBD_DESA_8812F))
#define BIT_GET_HI2Q_TXBD_DESA_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HI2Q_TXBD_DESA_8812F) &                             \
	 BIT_MASK_HI2Q_TXBD_DESA_8812F)
#define BIT_SET_HI2Q_TXBD_DESA_8812F(x, v)                                     \
	(BIT_CLEAR_HI2Q_TXBD_DESA_8812F(x) | BIT_HI2Q_TXBD_DESA_8812F(v))

/* 2 REG_HI3Q_TXBD_DESA_8812F */

#define BIT_SHIFT_HI3Q_TXBD_DESA_8812F 0
#define BIT_MASK_HI3Q_TXBD_DESA_8812F 0xffffffffffffffffL
#define BIT_HI3Q_TXBD_DESA_8812F(x)                                            \
	(((x) & BIT_MASK_HI3Q_TXBD_DESA_8812F)                                 \
	 << BIT_SHIFT_HI3Q_TXBD_DESA_8812F)
#define BITS_HI3Q_TXBD_DESA_8812F                                              \
	(BIT_MASK_HI3Q_TXBD_DESA_8812F << BIT_SHIFT_HI3Q_TXBD_DESA_8812F)
#define BIT_CLEAR_HI3Q_TXBD_DESA_8812F(x) ((x) & (~BITS_HI3Q_TXBD_DESA_8812F))
#define BIT_GET_HI3Q_TXBD_DESA_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HI3Q_TXBD_DESA_8812F) &                             \
	 BIT_MASK_HI3Q_TXBD_DESA_8812F)
#define BIT_SET_HI3Q_TXBD_DESA_8812F(x, v)                                     \
	(BIT_CLEAR_HI3Q_TXBD_DESA_8812F(x) | BIT_HI3Q_TXBD_DESA_8812F(v))

/* 2 REG_HI4Q_TXBD_DESA_8812F */

#define BIT_SHIFT_HI4Q_TXBD_DESA_8812F 0
#define BIT_MASK_HI4Q_TXBD_DESA_8812F 0xffffffffffffffffL
#define BIT_HI4Q_TXBD_DESA_8812F(x)                                            \
	(((x) & BIT_MASK_HI4Q_TXBD_DESA_8812F)                                 \
	 << BIT_SHIFT_HI4Q_TXBD_DESA_8812F)
#define BITS_HI4Q_TXBD_DESA_8812F                                              \
	(BIT_MASK_HI4Q_TXBD_DESA_8812F << BIT_SHIFT_HI4Q_TXBD_DESA_8812F)
#define BIT_CLEAR_HI4Q_TXBD_DESA_8812F(x) ((x) & (~BITS_HI4Q_TXBD_DESA_8812F))
#define BIT_GET_HI4Q_TXBD_DESA_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HI4Q_TXBD_DESA_8812F) &                             \
	 BIT_MASK_HI4Q_TXBD_DESA_8812F)
#define BIT_SET_HI4Q_TXBD_DESA_8812F(x, v)                                     \
	(BIT_CLEAR_HI4Q_TXBD_DESA_8812F(x) | BIT_HI4Q_TXBD_DESA_8812F(v))

/* 2 REG_HI5Q_TXBD_DESA_8812F */

#define BIT_SHIFT_HI5Q_TXBD_DESA_8812F 0
#define BIT_MASK_HI5Q_TXBD_DESA_8812F 0xffffffffffffffffL
#define BIT_HI5Q_TXBD_DESA_8812F(x)                                            \
	(((x) & BIT_MASK_HI5Q_TXBD_DESA_8812F)                                 \
	 << BIT_SHIFT_HI5Q_TXBD_DESA_8812F)
#define BITS_HI5Q_TXBD_DESA_8812F                                              \
	(BIT_MASK_HI5Q_TXBD_DESA_8812F << BIT_SHIFT_HI5Q_TXBD_DESA_8812F)
#define BIT_CLEAR_HI5Q_TXBD_DESA_8812F(x) ((x) & (~BITS_HI5Q_TXBD_DESA_8812F))
#define BIT_GET_HI5Q_TXBD_DESA_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HI5Q_TXBD_DESA_8812F) &                             \
	 BIT_MASK_HI5Q_TXBD_DESA_8812F)
#define BIT_SET_HI5Q_TXBD_DESA_8812F(x, v)                                     \
	(BIT_CLEAR_HI5Q_TXBD_DESA_8812F(x) | BIT_HI5Q_TXBD_DESA_8812F(v))

/* 2 REG_HI6Q_TXBD_DESA_8812F */

#define BIT_SHIFT_HI6Q_TXBD_DESA_8812F 0
#define BIT_MASK_HI6Q_TXBD_DESA_8812F 0xffffffffffffffffL
#define BIT_HI6Q_TXBD_DESA_8812F(x)                                            \
	(((x) & BIT_MASK_HI6Q_TXBD_DESA_8812F)                                 \
	 << BIT_SHIFT_HI6Q_TXBD_DESA_8812F)
#define BITS_HI6Q_TXBD_DESA_8812F                                              \
	(BIT_MASK_HI6Q_TXBD_DESA_8812F << BIT_SHIFT_HI6Q_TXBD_DESA_8812F)
#define BIT_CLEAR_HI6Q_TXBD_DESA_8812F(x) ((x) & (~BITS_HI6Q_TXBD_DESA_8812F))
#define BIT_GET_HI6Q_TXBD_DESA_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HI6Q_TXBD_DESA_8812F) &                             \
	 BIT_MASK_HI6Q_TXBD_DESA_8812F)
#define BIT_SET_HI6Q_TXBD_DESA_8812F(x, v)                                     \
	(BIT_CLEAR_HI6Q_TXBD_DESA_8812F(x) | BIT_HI6Q_TXBD_DESA_8812F(v))

/* 2 REG_HI7Q_TXBD_DESA_8812F */

#define BIT_SHIFT_HI7Q_TXBD_DESA_8812F 0
#define BIT_MASK_HI7Q_TXBD_DESA_8812F 0xffffffffffffffffL
#define BIT_HI7Q_TXBD_DESA_8812F(x)                                            \
	(((x) & BIT_MASK_HI7Q_TXBD_DESA_8812F)                                 \
	 << BIT_SHIFT_HI7Q_TXBD_DESA_8812F)
#define BITS_HI7Q_TXBD_DESA_8812F                                              \
	(BIT_MASK_HI7Q_TXBD_DESA_8812F << BIT_SHIFT_HI7Q_TXBD_DESA_8812F)
#define BIT_CLEAR_HI7Q_TXBD_DESA_8812F(x) ((x) & (~BITS_HI7Q_TXBD_DESA_8812F))
#define BIT_GET_HI7Q_TXBD_DESA_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HI7Q_TXBD_DESA_8812F) &                             \
	 BIT_MASK_HI7Q_TXBD_DESA_8812F)
#define BIT_SET_HI7Q_TXBD_DESA_8812F(x, v)                                     \
	(BIT_CLEAR_HI7Q_TXBD_DESA_8812F(x) | BIT_HI7Q_TXBD_DESA_8812F(v))

/* 2 REG_MGQ_TXBD_NUM_8812F */
#define BIT_PCIE_MGQ_FLAG_8812F BIT(14)

#define BIT_SHIFT_MGQ_DESC_MODE_8812F 12
#define BIT_MASK_MGQ_DESC_MODE_8812F 0x3
#define BIT_MGQ_DESC_MODE_8812F(x)                                             \
	(((x) & BIT_MASK_MGQ_DESC_MODE_8812F) << BIT_SHIFT_MGQ_DESC_MODE_8812F)
#define BITS_MGQ_DESC_MODE_8812F                                               \
	(BIT_MASK_MGQ_DESC_MODE_8812F << BIT_SHIFT_MGQ_DESC_MODE_8812F)
#define BIT_CLEAR_MGQ_DESC_MODE_8812F(x) ((x) & (~BITS_MGQ_DESC_MODE_8812F))
#define BIT_GET_MGQ_DESC_MODE_8812F(x)                                         \
	(((x) >> BIT_SHIFT_MGQ_DESC_MODE_8812F) & BIT_MASK_MGQ_DESC_MODE_8812F)
#define BIT_SET_MGQ_DESC_MODE_8812F(x, v)                                      \
	(BIT_CLEAR_MGQ_DESC_MODE_8812F(x) | BIT_MGQ_DESC_MODE_8812F(v))

#define BIT_SHIFT_MGQ_DESC_NUM_8812F 0
#define BIT_MASK_MGQ_DESC_NUM_8812F 0xfff
#define BIT_MGQ_DESC_NUM_8812F(x)                                              \
	(((x) & BIT_MASK_MGQ_DESC_NUM_8812F) << BIT_SHIFT_MGQ_DESC_NUM_8812F)
#define BITS_MGQ_DESC_NUM_8812F                                                \
	(BIT_MASK_MGQ_DESC_NUM_8812F << BIT_SHIFT_MGQ_DESC_NUM_8812F)
#define BIT_CLEAR_MGQ_DESC_NUM_8812F(x) ((x) & (~BITS_MGQ_DESC_NUM_8812F))
#define BIT_GET_MGQ_DESC_NUM_8812F(x)                                          \
	(((x) >> BIT_SHIFT_MGQ_DESC_NUM_8812F) & BIT_MASK_MGQ_DESC_NUM_8812F)
#define BIT_SET_MGQ_DESC_NUM_8812F(x, v)                                       \
	(BIT_CLEAR_MGQ_DESC_NUM_8812F(x) | BIT_MGQ_DESC_NUM_8812F(v))

/* 2 REG_RX_RXBD_NUM_8812F */
#define BIT_SYS_32_64_8812F BIT(15)

#define BIT_SHIFT_BCNQ_DESC_MODE_8812F 13
#define BIT_MASK_BCNQ_DESC_MODE_8812F 0x3
#define BIT_BCNQ_DESC_MODE_8812F(x)                                            \
	(((x) & BIT_MASK_BCNQ_DESC_MODE_8812F)                                 \
	 << BIT_SHIFT_BCNQ_DESC_MODE_8812F)
#define BITS_BCNQ_DESC_MODE_8812F                                              \
	(BIT_MASK_BCNQ_DESC_MODE_8812F << BIT_SHIFT_BCNQ_DESC_MODE_8812F)
#define BIT_CLEAR_BCNQ_DESC_MODE_8812F(x) ((x) & (~BITS_BCNQ_DESC_MODE_8812F))
#define BIT_GET_BCNQ_DESC_MODE_8812F(x)                                        \
	(((x) >> BIT_SHIFT_BCNQ_DESC_MODE_8812F) &                             \
	 BIT_MASK_BCNQ_DESC_MODE_8812F)
#define BIT_SET_BCNQ_DESC_MODE_8812F(x, v)                                     \
	(BIT_CLEAR_BCNQ_DESC_MODE_8812F(x) | BIT_BCNQ_DESC_MODE_8812F(v))

#define BIT_PCIE_BCNQ_FLAG_8812F BIT(12)

#define BIT_SHIFT_RXQ_DESC_NUM_8812F 0
#define BIT_MASK_RXQ_DESC_NUM_8812F 0xfff
#define BIT_RXQ_DESC_NUM_8812F(x)                                              \
	(((x) & BIT_MASK_RXQ_DESC_NUM_8812F) << BIT_SHIFT_RXQ_DESC_NUM_8812F)
#define BITS_RXQ_DESC_NUM_8812F                                                \
	(BIT_MASK_RXQ_DESC_NUM_8812F << BIT_SHIFT_RXQ_DESC_NUM_8812F)
#define BIT_CLEAR_RXQ_DESC_NUM_8812F(x) ((x) & (~BITS_RXQ_DESC_NUM_8812F))
#define BIT_GET_RXQ_DESC_NUM_8812F(x)                                          \
	(((x) >> BIT_SHIFT_RXQ_DESC_NUM_8812F) & BIT_MASK_RXQ_DESC_NUM_8812F)
#define BIT_SET_RXQ_DESC_NUM_8812F(x, v)                                       \
	(BIT_CLEAR_RXQ_DESC_NUM_8812F(x) | BIT_RXQ_DESC_NUM_8812F(v))

/* 2 REG_VOQ_TXBD_NUM_8812F */
#define BIT_PCIE_VOQ_FLAG_8812F BIT(14)

#define BIT_SHIFT_VOQ_DESC_MODE_8812F 12
#define BIT_MASK_VOQ_DESC_MODE_8812F 0x3
#define BIT_VOQ_DESC_MODE_8812F(x)                                             \
	(((x) & BIT_MASK_VOQ_DESC_MODE_8812F) << BIT_SHIFT_VOQ_DESC_MODE_8812F)
#define BITS_VOQ_DESC_MODE_8812F                                               \
	(BIT_MASK_VOQ_DESC_MODE_8812F << BIT_SHIFT_VOQ_DESC_MODE_8812F)
#define BIT_CLEAR_VOQ_DESC_MODE_8812F(x) ((x) & (~BITS_VOQ_DESC_MODE_8812F))
#define BIT_GET_VOQ_DESC_MODE_8812F(x)                                         \
	(((x) >> BIT_SHIFT_VOQ_DESC_MODE_8812F) & BIT_MASK_VOQ_DESC_MODE_8812F)
#define BIT_SET_VOQ_DESC_MODE_8812F(x, v)                                      \
	(BIT_CLEAR_VOQ_DESC_MODE_8812F(x) | BIT_VOQ_DESC_MODE_8812F(v))

#define BIT_SHIFT_VOQ_DESC_NUM_8812F 0
#define BIT_MASK_VOQ_DESC_NUM_8812F 0xfff
#define BIT_VOQ_DESC_NUM_8812F(x)                                              \
	(((x) & BIT_MASK_VOQ_DESC_NUM_8812F) << BIT_SHIFT_VOQ_DESC_NUM_8812F)
#define BITS_VOQ_DESC_NUM_8812F                                                \
	(BIT_MASK_VOQ_DESC_NUM_8812F << BIT_SHIFT_VOQ_DESC_NUM_8812F)
#define BIT_CLEAR_VOQ_DESC_NUM_8812F(x) ((x) & (~BITS_VOQ_DESC_NUM_8812F))
#define BIT_GET_VOQ_DESC_NUM_8812F(x)                                          \
	(((x) >> BIT_SHIFT_VOQ_DESC_NUM_8812F) & BIT_MASK_VOQ_DESC_NUM_8812F)
#define BIT_SET_VOQ_DESC_NUM_8812F(x, v)                                       \
	(BIT_CLEAR_VOQ_DESC_NUM_8812F(x) | BIT_VOQ_DESC_NUM_8812F(v))

/* 2 REG_VIQ_TXBD_NUM_8812F */
#define BIT_PCIE_VIQ_FLAG_8812F BIT(14)

#define BIT_SHIFT_VIQ_DESC_MODE_8812F 12
#define BIT_MASK_VIQ_DESC_MODE_8812F 0x3
#define BIT_VIQ_DESC_MODE_8812F(x)                                             \
	(((x) & BIT_MASK_VIQ_DESC_MODE_8812F) << BIT_SHIFT_VIQ_DESC_MODE_8812F)
#define BITS_VIQ_DESC_MODE_8812F                                               \
	(BIT_MASK_VIQ_DESC_MODE_8812F << BIT_SHIFT_VIQ_DESC_MODE_8812F)
#define BIT_CLEAR_VIQ_DESC_MODE_8812F(x) ((x) & (~BITS_VIQ_DESC_MODE_8812F))
#define BIT_GET_VIQ_DESC_MODE_8812F(x)                                         \
	(((x) >> BIT_SHIFT_VIQ_DESC_MODE_8812F) & BIT_MASK_VIQ_DESC_MODE_8812F)
#define BIT_SET_VIQ_DESC_MODE_8812F(x, v)                                      \
	(BIT_CLEAR_VIQ_DESC_MODE_8812F(x) | BIT_VIQ_DESC_MODE_8812F(v))

#define BIT_SHIFT_VIQ_DESC_NUM_8812F 0
#define BIT_MASK_VIQ_DESC_NUM_8812F 0xfff
#define BIT_VIQ_DESC_NUM_8812F(x)                                              \
	(((x) & BIT_MASK_VIQ_DESC_NUM_8812F) << BIT_SHIFT_VIQ_DESC_NUM_8812F)
#define BITS_VIQ_DESC_NUM_8812F                                                \
	(BIT_MASK_VIQ_DESC_NUM_8812F << BIT_SHIFT_VIQ_DESC_NUM_8812F)
#define BIT_CLEAR_VIQ_DESC_NUM_8812F(x) ((x) & (~BITS_VIQ_DESC_NUM_8812F))
#define BIT_GET_VIQ_DESC_NUM_8812F(x)                                          \
	(((x) >> BIT_SHIFT_VIQ_DESC_NUM_8812F) & BIT_MASK_VIQ_DESC_NUM_8812F)
#define BIT_SET_VIQ_DESC_NUM_8812F(x, v)                                       \
	(BIT_CLEAR_VIQ_DESC_NUM_8812F(x) | BIT_VIQ_DESC_NUM_8812F(v))

/* 2 REG_BEQ_TXBD_NUM_8812F */
#define BIT_PCIE_BEQ_FLAG_8812F BIT(14)

#define BIT_SHIFT_BEQ_DESC_MODE_8812F 12
#define BIT_MASK_BEQ_DESC_MODE_8812F 0x3
#define BIT_BEQ_DESC_MODE_8812F(x)                                             \
	(((x) & BIT_MASK_BEQ_DESC_MODE_8812F) << BIT_SHIFT_BEQ_DESC_MODE_8812F)
#define BITS_BEQ_DESC_MODE_8812F                                               \
	(BIT_MASK_BEQ_DESC_MODE_8812F << BIT_SHIFT_BEQ_DESC_MODE_8812F)
#define BIT_CLEAR_BEQ_DESC_MODE_8812F(x) ((x) & (~BITS_BEQ_DESC_MODE_8812F))
#define BIT_GET_BEQ_DESC_MODE_8812F(x)                                         \
	(((x) >> BIT_SHIFT_BEQ_DESC_MODE_8812F) & BIT_MASK_BEQ_DESC_MODE_8812F)
#define BIT_SET_BEQ_DESC_MODE_8812F(x, v)                                      \
	(BIT_CLEAR_BEQ_DESC_MODE_8812F(x) | BIT_BEQ_DESC_MODE_8812F(v))

#define BIT_SHIFT_BEQ_DESC_NUM_8812F 0
#define BIT_MASK_BEQ_DESC_NUM_8812F 0xfff
#define BIT_BEQ_DESC_NUM_8812F(x)                                              \
	(((x) & BIT_MASK_BEQ_DESC_NUM_8812F) << BIT_SHIFT_BEQ_DESC_NUM_8812F)
#define BITS_BEQ_DESC_NUM_8812F                                                \
	(BIT_MASK_BEQ_DESC_NUM_8812F << BIT_SHIFT_BEQ_DESC_NUM_8812F)
#define BIT_CLEAR_BEQ_DESC_NUM_8812F(x) ((x) & (~BITS_BEQ_DESC_NUM_8812F))
#define BIT_GET_BEQ_DESC_NUM_8812F(x)                                          \
	(((x) >> BIT_SHIFT_BEQ_DESC_NUM_8812F) & BIT_MASK_BEQ_DESC_NUM_8812F)
#define BIT_SET_BEQ_DESC_NUM_8812F(x, v)                                       \
	(BIT_CLEAR_BEQ_DESC_NUM_8812F(x) | BIT_BEQ_DESC_NUM_8812F(v))

/* 2 REG_BKQ_TXBD_NUM_8812F */
#define BIT_PCIE_BKQ_FLAG_8812F BIT(14)

#define BIT_SHIFT_BKQ_DESC_MODE_8812F 12
#define BIT_MASK_BKQ_DESC_MODE_8812F 0x3
#define BIT_BKQ_DESC_MODE_8812F(x)                                             \
	(((x) & BIT_MASK_BKQ_DESC_MODE_8812F) << BIT_SHIFT_BKQ_DESC_MODE_8812F)
#define BITS_BKQ_DESC_MODE_8812F                                               \
	(BIT_MASK_BKQ_DESC_MODE_8812F << BIT_SHIFT_BKQ_DESC_MODE_8812F)
#define BIT_CLEAR_BKQ_DESC_MODE_8812F(x) ((x) & (~BITS_BKQ_DESC_MODE_8812F))
#define BIT_GET_BKQ_DESC_MODE_8812F(x)                                         \
	(((x) >> BIT_SHIFT_BKQ_DESC_MODE_8812F) & BIT_MASK_BKQ_DESC_MODE_8812F)
#define BIT_SET_BKQ_DESC_MODE_8812F(x, v)                                      \
	(BIT_CLEAR_BKQ_DESC_MODE_8812F(x) | BIT_BKQ_DESC_MODE_8812F(v))

#define BIT_SHIFT_BKQ_DESC_NUM_8812F 0
#define BIT_MASK_BKQ_DESC_NUM_8812F 0xfff
#define BIT_BKQ_DESC_NUM_8812F(x)                                              \
	(((x) & BIT_MASK_BKQ_DESC_NUM_8812F) << BIT_SHIFT_BKQ_DESC_NUM_8812F)
#define BITS_BKQ_DESC_NUM_8812F                                                \
	(BIT_MASK_BKQ_DESC_NUM_8812F << BIT_SHIFT_BKQ_DESC_NUM_8812F)
#define BIT_CLEAR_BKQ_DESC_NUM_8812F(x) ((x) & (~BITS_BKQ_DESC_NUM_8812F))
#define BIT_GET_BKQ_DESC_NUM_8812F(x)                                          \
	(((x) >> BIT_SHIFT_BKQ_DESC_NUM_8812F) & BIT_MASK_BKQ_DESC_NUM_8812F)
#define BIT_SET_BKQ_DESC_NUM_8812F(x, v)                                       \
	(BIT_CLEAR_BKQ_DESC_NUM_8812F(x) | BIT_BKQ_DESC_NUM_8812F(v))

/* 2 REG_HI0Q_TXBD_NUM_8812F */
#define BIT_HI0Q_FLAG_8812F BIT(14)

#define BIT_SHIFT_HI0Q_DESC_MODE_8812F 12
#define BIT_MASK_HI0Q_DESC_MODE_8812F 0x3
#define BIT_HI0Q_DESC_MODE_8812F(x)                                            \
	(((x) & BIT_MASK_HI0Q_DESC_MODE_8812F)                                 \
	 << BIT_SHIFT_HI0Q_DESC_MODE_8812F)
#define BITS_HI0Q_DESC_MODE_8812F                                              \
	(BIT_MASK_HI0Q_DESC_MODE_8812F << BIT_SHIFT_HI0Q_DESC_MODE_8812F)
#define BIT_CLEAR_HI0Q_DESC_MODE_8812F(x) ((x) & (~BITS_HI0Q_DESC_MODE_8812F))
#define BIT_GET_HI0Q_DESC_MODE_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HI0Q_DESC_MODE_8812F) &                             \
	 BIT_MASK_HI0Q_DESC_MODE_8812F)
#define BIT_SET_HI0Q_DESC_MODE_8812F(x, v)                                     \
	(BIT_CLEAR_HI0Q_DESC_MODE_8812F(x) | BIT_HI0Q_DESC_MODE_8812F(v))

#define BIT_SHIFT_HI0Q_DESC_NUM_8812F 0
#define BIT_MASK_HI0Q_DESC_NUM_8812F 0xfff
#define BIT_HI0Q_DESC_NUM_8812F(x)                                             \
	(((x) & BIT_MASK_HI0Q_DESC_NUM_8812F) << BIT_SHIFT_HI0Q_DESC_NUM_8812F)
#define BITS_HI0Q_DESC_NUM_8812F                                               \
	(BIT_MASK_HI0Q_DESC_NUM_8812F << BIT_SHIFT_HI0Q_DESC_NUM_8812F)
#define BIT_CLEAR_HI0Q_DESC_NUM_8812F(x) ((x) & (~BITS_HI0Q_DESC_NUM_8812F))
#define BIT_GET_HI0Q_DESC_NUM_8812F(x)                                         \
	(((x) >> BIT_SHIFT_HI0Q_DESC_NUM_8812F) & BIT_MASK_HI0Q_DESC_NUM_8812F)
#define BIT_SET_HI0Q_DESC_NUM_8812F(x, v)                                      \
	(BIT_CLEAR_HI0Q_DESC_NUM_8812F(x) | BIT_HI0Q_DESC_NUM_8812F(v))

/* 2 REG_HI1Q_TXBD_NUM_8812F */
#define BIT_HI1Q_FLAG_8812F BIT(14)

#define BIT_SHIFT_HI1Q_DESC_MODE_8812F 12
#define BIT_MASK_HI1Q_DESC_MODE_8812F 0x3
#define BIT_HI1Q_DESC_MODE_8812F(x)                                            \
	(((x) & BIT_MASK_HI1Q_DESC_MODE_8812F)                                 \
	 << BIT_SHIFT_HI1Q_DESC_MODE_8812F)
#define BITS_HI1Q_DESC_MODE_8812F                                              \
	(BIT_MASK_HI1Q_DESC_MODE_8812F << BIT_SHIFT_HI1Q_DESC_MODE_8812F)
#define BIT_CLEAR_HI1Q_DESC_MODE_8812F(x) ((x) & (~BITS_HI1Q_DESC_MODE_8812F))
#define BIT_GET_HI1Q_DESC_MODE_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HI1Q_DESC_MODE_8812F) &                             \
	 BIT_MASK_HI1Q_DESC_MODE_8812F)
#define BIT_SET_HI1Q_DESC_MODE_8812F(x, v)                                     \
	(BIT_CLEAR_HI1Q_DESC_MODE_8812F(x) | BIT_HI1Q_DESC_MODE_8812F(v))

#define BIT_SHIFT_HI1Q_DESC_NUM_8812F 0
#define BIT_MASK_HI1Q_DESC_NUM_8812F 0xfff
#define BIT_HI1Q_DESC_NUM_8812F(x)                                             \
	(((x) & BIT_MASK_HI1Q_DESC_NUM_8812F) << BIT_SHIFT_HI1Q_DESC_NUM_8812F)
#define BITS_HI1Q_DESC_NUM_8812F                                               \
	(BIT_MASK_HI1Q_DESC_NUM_8812F << BIT_SHIFT_HI1Q_DESC_NUM_8812F)
#define BIT_CLEAR_HI1Q_DESC_NUM_8812F(x) ((x) & (~BITS_HI1Q_DESC_NUM_8812F))
#define BIT_GET_HI1Q_DESC_NUM_8812F(x)                                         \
	(((x) >> BIT_SHIFT_HI1Q_DESC_NUM_8812F) & BIT_MASK_HI1Q_DESC_NUM_8812F)
#define BIT_SET_HI1Q_DESC_NUM_8812F(x, v)                                      \
	(BIT_CLEAR_HI1Q_DESC_NUM_8812F(x) | BIT_HI1Q_DESC_NUM_8812F(v))

/* 2 REG_HI2Q_TXBD_NUM_8812F */
#define BIT_HI2Q_FLAG_8812F BIT(14)

#define BIT_SHIFT_HI2Q_DESC_MODE_8812F 12
#define BIT_MASK_HI2Q_DESC_MODE_8812F 0x3
#define BIT_HI2Q_DESC_MODE_8812F(x)                                            \
	(((x) & BIT_MASK_HI2Q_DESC_MODE_8812F)                                 \
	 << BIT_SHIFT_HI2Q_DESC_MODE_8812F)
#define BITS_HI2Q_DESC_MODE_8812F                                              \
	(BIT_MASK_HI2Q_DESC_MODE_8812F << BIT_SHIFT_HI2Q_DESC_MODE_8812F)
#define BIT_CLEAR_HI2Q_DESC_MODE_8812F(x) ((x) & (~BITS_HI2Q_DESC_MODE_8812F))
#define BIT_GET_HI2Q_DESC_MODE_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HI2Q_DESC_MODE_8812F) &                             \
	 BIT_MASK_HI2Q_DESC_MODE_8812F)
#define BIT_SET_HI2Q_DESC_MODE_8812F(x, v)                                     \
	(BIT_CLEAR_HI2Q_DESC_MODE_8812F(x) | BIT_HI2Q_DESC_MODE_8812F(v))

#define BIT_SHIFT_HI2Q_DESC_NUM_8812F 0
#define BIT_MASK_HI2Q_DESC_NUM_8812F 0xfff
#define BIT_HI2Q_DESC_NUM_8812F(x)                                             \
	(((x) & BIT_MASK_HI2Q_DESC_NUM_8812F) << BIT_SHIFT_HI2Q_DESC_NUM_8812F)
#define BITS_HI2Q_DESC_NUM_8812F                                               \
	(BIT_MASK_HI2Q_DESC_NUM_8812F << BIT_SHIFT_HI2Q_DESC_NUM_8812F)
#define BIT_CLEAR_HI2Q_DESC_NUM_8812F(x) ((x) & (~BITS_HI2Q_DESC_NUM_8812F))
#define BIT_GET_HI2Q_DESC_NUM_8812F(x)                                         \
	(((x) >> BIT_SHIFT_HI2Q_DESC_NUM_8812F) & BIT_MASK_HI2Q_DESC_NUM_8812F)
#define BIT_SET_HI2Q_DESC_NUM_8812F(x, v)                                      \
	(BIT_CLEAR_HI2Q_DESC_NUM_8812F(x) | BIT_HI2Q_DESC_NUM_8812F(v))

/* 2 REG_HI3Q_TXBD_NUM_8812F */
#define BIT_HI3Q_FLAG_8812F BIT(14)

#define BIT_SHIFT_HI3Q_DESC_MODE_8812F 12
#define BIT_MASK_HI3Q_DESC_MODE_8812F 0x3
#define BIT_HI3Q_DESC_MODE_8812F(x)                                            \
	(((x) & BIT_MASK_HI3Q_DESC_MODE_8812F)                                 \
	 << BIT_SHIFT_HI3Q_DESC_MODE_8812F)
#define BITS_HI3Q_DESC_MODE_8812F                                              \
	(BIT_MASK_HI3Q_DESC_MODE_8812F << BIT_SHIFT_HI3Q_DESC_MODE_8812F)
#define BIT_CLEAR_HI3Q_DESC_MODE_8812F(x) ((x) & (~BITS_HI3Q_DESC_MODE_8812F))
#define BIT_GET_HI3Q_DESC_MODE_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HI3Q_DESC_MODE_8812F) &                             \
	 BIT_MASK_HI3Q_DESC_MODE_8812F)
#define BIT_SET_HI3Q_DESC_MODE_8812F(x, v)                                     \
	(BIT_CLEAR_HI3Q_DESC_MODE_8812F(x) | BIT_HI3Q_DESC_MODE_8812F(v))

#define BIT_SHIFT_HI3Q_DESC_NUM_8812F 0
#define BIT_MASK_HI3Q_DESC_NUM_8812F 0xfff
#define BIT_HI3Q_DESC_NUM_8812F(x)                                             \
	(((x) & BIT_MASK_HI3Q_DESC_NUM_8812F) << BIT_SHIFT_HI3Q_DESC_NUM_8812F)
#define BITS_HI3Q_DESC_NUM_8812F                                               \
	(BIT_MASK_HI3Q_DESC_NUM_8812F << BIT_SHIFT_HI3Q_DESC_NUM_8812F)
#define BIT_CLEAR_HI3Q_DESC_NUM_8812F(x) ((x) & (~BITS_HI3Q_DESC_NUM_8812F))
#define BIT_GET_HI3Q_DESC_NUM_8812F(x)                                         \
	(((x) >> BIT_SHIFT_HI3Q_DESC_NUM_8812F) & BIT_MASK_HI3Q_DESC_NUM_8812F)
#define BIT_SET_HI3Q_DESC_NUM_8812F(x, v)                                      \
	(BIT_CLEAR_HI3Q_DESC_NUM_8812F(x) | BIT_HI3Q_DESC_NUM_8812F(v))

/* 2 REG_HI4Q_TXBD_NUM_8812F */
#define BIT_HI4Q_FLAG_8812F BIT(14)

#define BIT_SHIFT_HI4Q_DESC_MODE_8812F 12
#define BIT_MASK_HI4Q_DESC_MODE_8812F 0x3
#define BIT_HI4Q_DESC_MODE_8812F(x)                                            \
	(((x) & BIT_MASK_HI4Q_DESC_MODE_8812F)                                 \
	 << BIT_SHIFT_HI4Q_DESC_MODE_8812F)
#define BITS_HI4Q_DESC_MODE_8812F                                              \
	(BIT_MASK_HI4Q_DESC_MODE_8812F << BIT_SHIFT_HI4Q_DESC_MODE_8812F)
#define BIT_CLEAR_HI4Q_DESC_MODE_8812F(x) ((x) & (~BITS_HI4Q_DESC_MODE_8812F))
#define BIT_GET_HI4Q_DESC_MODE_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HI4Q_DESC_MODE_8812F) &                             \
	 BIT_MASK_HI4Q_DESC_MODE_8812F)
#define BIT_SET_HI4Q_DESC_MODE_8812F(x, v)                                     \
	(BIT_CLEAR_HI4Q_DESC_MODE_8812F(x) | BIT_HI4Q_DESC_MODE_8812F(v))

#define BIT_SHIFT_HI4Q_DESC_NUM_8812F 0
#define BIT_MASK_HI4Q_DESC_NUM_8812F 0xfff
#define BIT_HI4Q_DESC_NUM_8812F(x)                                             \
	(((x) & BIT_MASK_HI4Q_DESC_NUM_8812F) << BIT_SHIFT_HI4Q_DESC_NUM_8812F)
#define BITS_HI4Q_DESC_NUM_8812F                                               \
	(BIT_MASK_HI4Q_DESC_NUM_8812F << BIT_SHIFT_HI4Q_DESC_NUM_8812F)
#define BIT_CLEAR_HI4Q_DESC_NUM_8812F(x) ((x) & (~BITS_HI4Q_DESC_NUM_8812F))
#define BIT_GET_HI4Q_DESC_NUM_8812F(x)                                         \
	(((x) >> BIT_SHIFT_HI4Q_DESC_NUM_8812F) & BIT_MASK_HI4Q_DESC_NUM_8812F)
#define BIT_SET_HI4Q_DESC_NUM_8812F(x, v)                                      \
	(BIT_CLEAR_HI4Q_DESC_NUM_8812F(x) | BIT_HI4Q_DESC_NUM_8812F(v))

/* 2 REG_HI5Q_TXBD_NUM_8812F */
#define BIT_HI5Q_FLAG_8812F BIT(14)

#define BIT_SHIFT_HI5Q_DESC_MODE_8812F 12
#define BIT_MASK_HI5Q_DESC_MODE_8812F 0x3
#define BIT_HI5Q_DESC_MODE_8812F(x)                                            \
	(((x) & BIT_MASK_HI5Q_DESC_MODE_8812F)                                 \
	 << BIT_SHIFT_HI5Q_DESC_MODE_8812F)
#define BITS_HI5Q_DESC_MODE_8812F                                              \
	(BIT_MASK_HI5Q_DESC_MODE_8812F << BIT_SHIFT_HI5Q_DESC_MODE_8812F)
#define BIT_CLEAR_HI5Q_DESC_MODE_8812F(x) ((x) & (~BITS_HI5Q_DESC_MODE_8812F))
#define BIT_GET_HI5Q_DESC_MODE_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HI5Q_DESC_MODE_8812F) &                             \
	 BIT_MASK_HI5Q_DESC_MODE_8812F)
#define BIT_SET_HI5Q_DESC_MODE_8812F(x, v)                                     \
	(BIT_CLEAR_HI5Q_DESC_MODE_8812F(x) | BIT_HI5Q_DESC_MODE_8812F(v))

#define BIT_SHIFT_HI5Q_DESC_NUM_8812F 0
#define BIT_MASK_HI5Q_DESC_NUM_8812F 0xfff
#define BIT_HI5Q_DESC_NUM_8812F(x)                                             \
	(((x) & BIT_MASK_HI5Q_DESC_NUM_8812F) << BIT_SHIFT_HI5Q_DESC_NUM_8812F)
#define BITS_HI5Q_DESC_NUM_8812F                                               \
	(BIT_MASK_HI5Q_DESC_NUM_8812F << BIT_SHIFT_HI5Q_DESC_NUM_8812F)
#define BIT_CLEAR_HI5Q_DESC_NUM_8812F(x) ((x) & (~BITS_HI5Q_DESC_NUM_8812F))
#define BIT_GET_HI5Q_DESC_NUM_8812F(x)                                         \
	(((x) >> BIT_SHIFT_HI5Q_DESC_NUM_8812F) & BIT_MASK_HI5Q_DESC_NUM_8812F)
#define BIT_SET_HI5Q_DESC_NUM_8812F(x, v)                                      \
	(BIT_CLEAR_HI5Q_DESC_NUM_8812F(x) | BIT_HI5Q_DESC_NUM_8812F(v))

/* 2 REG_HI6Q_TXBD_NUM_8812F */
#define BIT_HI6Q_FLAG_8812F BIT(14)

#define BIT_SHIFT_HI6Q_DESC_MODE_8812F 12
#define BIT_MASK_HI6Q_DESC_MODE_8812F 0x3
#define BIT_HI6Q_DESC_MODE_8812F(x)                                            \
	(((x) & BIT_MASK_HI6Q_DESC_MODE_8812F)                                 \
	 << BIT_SHIFT_HI6Q_DESC_MODE_8812F)
#define BITS_HI6Q_DESC_MODE_8812F                                              \
	(BIT_MASK_HI6Q_DESC_MODE_8812F << BIT_SHIFT_HI6Q_DESC_MODE_8812F)
#define BIT_CLEAR_HI6Q_DESC_MODE_8812F(x) ((x) & (~BITS_HI6Q_DESC_MODE_8812F))
#define BIT_GET_HI6Q_DESC_MODE_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HI6Q_DESC_MODE_8812F) &                             \
	 BIT_MASK_HI6Q_DESC_MODE_8812F)
#define BIT_SET_HI6Q_DESC_MODE_8812F(x, v)                                     \
	(BIT_CLEAR_HI6Q_DESC_MODE_8812F(x) | BIT_HI6Q_DESC_MODE_8812F(v))

#define BIT_SHIFT_HI6Q_DESC_NUM_8812F 0
#define BIT_MASK_HI6Q_DESC_NUM_8812F 0xfff
#define BIT_HI6Q_DESC_NUM_8812F(x)                                             \
	(((x) & BIT_MASK_HI6Q_DESC_NUM_8812F) << BIT_SHIFT_HI6Q_DESC_NUM_8812F)
#define BITS_HI6Q_DESC_NUM_8812F                                               \
	(BIT_MASK_HI6Q_DESC_NUM_8812F << BIT_SHIFT_HI6Q_DESC_NUM_8812F)
#define BIT_CLEAR_HI6Q_DESC_NUM_8812F(x) ((x) & (~BITS_HI6Q_DESC_NUM_8812F))
#define BIT_GET_HI6Q_DESC_NUM_8812F(x)                                         \
	(((x) >> BIT_SHIFT_HI6Q_DESC_NUM_8812F) & BIT_MASK_HI6Q_DESC_NUM_8812F)
#define BIT_SET_HI6Q_DESC_NUM_8812F(x, v)                                      \
	(BIT_CLEAR_HI6Q_DESC_NUM_8812F(x) | BIT_HI6Q_DESC_NUM_8812F(v))

/* 2 REG_HI7Q_TXBD_NUM_8812F */
#define BIT_HI7Q_FLAG_8812F BIT(14)

#define BIT_SHIFT_HI7Q_DESC_MODE_8812F 12
#define BIT_MASK_HI7Q_DESC_MODE_8812F 0x3
#define BIT_HI7Q_DESC_MODE_8812F(x)                                            \
	(((x) & BIT_MASK_HI7Q_DESC_MODE_8812F)                                 \
	 << BIT_SHIFT_HI7Q_DESC_MODE_8812F)
#define BITS_HI7Q_DESC_MODE_8812F                                              \
	(BIT_MASK_HI7Q_DESC_MODE_8812F << BIT_SHIFT_HI7Q_DESC_MODE_8812F)
#define BIT_CLEAR_HI7Q_DESC_MODE_8812F(x) ((x) & (~BITS_HI7Q_DESC_MODE_8812F))
#define BIT_GET_HI7Q_DESC_MODE_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HI7Q_DESC_MODE_8812F) &                             \
	 BIT_MASK_HI7Q_DESC_MODE_8812F)
#define BIT_SET_HI7Q_DESC_MODE_8812F(x, v)                                     \
	(BIT_CLEAR_HI7Q_DESC_MODE_8812F(x) | BIT_HI7Q_DESC_MODE_8812F(v))

#define BIT_SHIFT_HI7Q_DESC_NUM_8812F 0
#define BIT_MASK_HI7Q_DESC_NUM_8812F 0xfff
#define BIT_HI7Q_DESC_NUM_8812F(x)                                             \
	(((x) & BIT_MASK_HI7Q_DESC_NUM_8812F) << BIT_SHIFT_HI7Q_DESC_NUM_8812F)
#define BITS_HI7Q_DESC_NUM_8812F                                               \
	(BIT_MASK_HI7Q_DESC_NUM_8812F << BIT_SHIFT_HI7Q_DESC_NUM_8812F)
#define BIT_CLEAR_HI7Q_DESC_NUM_8812F(x) ((x) & (~BITS_HI7Q_DESC_NUM_8812F))
#define BIT_GET_HI7Q_DESC_NUM_8812F(x)                                         \
	(((x) >> BIT_SHIFT_HI7Q_DESC_NUM_8812F) & BIT_MASK_HI7Q_DESC_NUM_8812F)
#define BIT_SET_HI7Q_DESC_NUM_8812F(x, v)                                      \
	(BIT_CLEAR_HI7Q_DESC_NUM_8812F(x) | BIT_HI7Q_DESC_NUM_8812F(v))

/* 2 REG_TSFTIMER_HCI_8812F */

#define BIT_SHIFT_TSFT2_HCI_8812F 16
#define BIT_MASK_TSFT2_HCI_8812F 0xffff
#define BIT_TSFT2_HCI_8812F(x)                                                 \
	(((x) & BIT_MASK_TSFT2_HCI_8812F) << BIT_SHIFT_TSFT2_HCI_8812F)
#define BITS_TSFT2_HCI_8812F                                                   \
	(BIT_MASK_TSFT2_HCI_8812F << BIT_SHIFT_TSFT2_HCI_8812F)
#define BIT_CLEAR_TSFT2_HCI_8812F(x) ((x) & (~BITS_TSFT2_HCI_8812F))
#define BIT_GET_TSFT2_HCI_8812F(x)                                             \
	(((x) >> BIT_SHIFT_TSFT2_HCI_8812F) & BIT_MASK_TSFT2_HCI_8812F)
#define BIT_SET_TSFT2_HCI_8812F(x, v)                                          \
	(BIT_CLEAR_TSFT2_HCI_8812F(x) | BIT_TSFT2_HCI_8812F(v))

#define BIT_SHIFT_TSFT1_HCI_8812F 0
#define BIT_MASK_TSFT1_HCI_8812F 0xffff
#define BIT_TSFT1_HCI_8812F(x)                                                 \
	(((x) & BIT_MASK_TSFT1_HCI_8812F) << BIT_SHIFT_TSFT1_HCI_8812F)
#define BITS_TSFT1_HCI_8812F                                                   \
	(BIT_MASK_TSFT1_HCI_8812F << BIT_SHIFT_TSFT1_HCI_8812F)
#define BIT_CLEAR_TSFT1_HCI_8812F(x) ((x) & (~BITS_TSFT1_HCI_8812F))
#define BIT_GET_TSFT1_HCI_8812F(x)                                             \
	(((x) >> BIT_SHIFT_TSFT1_HCI_8812F) & BIT_MASK_TSFT1_HCI_8812F)
#define BIT_SET_TSFT1_HCI_8812F(x, v)                                          \
	(BIT_CLEAR_TSFT1_HCI_8812F(x) | BIT_TSFT1_HCI_8812F(v))

/* 2 REG_BD_RWPTR_CLR_8812F */
#define BIT_CLR_HI7Q_HW_IDX_8812F BIT(29)
#define BIT_CLR_HI6Q_HW_IDX_8812F BIT(28)
#define BIT_CLR_HI5Q_HW_IDX_8812F BIT(27)
#define BIT_CLR_HI4Q_HW_IDX_8812F BIT(26)
#define BIT_CLR_HI3Q_HW_IDX_8812F BIT(25)
#define BIT_CLR_HI2Q_HW_IDX_8812F BIT(24)
#define BIT_CLR_HI1Q_HW_IDX_8812F BIT(23)
#define BIT_CLR_HI0Q_HW_IDX_8812F BIT(22)
#define BIT_CLR_BKQ_HW_IDX_8812F BIT(21)
#define BIT_CLR_BEQ_HW_IDX_8812F BIT(20)
#define BIT_CLR_VIQ_HW_IDX_8812F BIT(19)
#define BIT_CLR_VOQ_HW_IDX_8812F BIT(18)
#define BIT_CLR_MGQ_HW_IDX_8812F BIT(17)
#define BIT_CLR_RXQ_HW_IDX_8812F BIT(16)
#define BIT_CLR_HI7Q_HOST_IDX_8812F BIT(13)
#define BIT_CLR_HI6Q_HOST_IDX_8812F BIT(12)
#define BIT_CLR_HI5Q_HOST_IDX_8812F BIT(11)
#define BIT_CLR_HI4Q_HOST_IDX_8812F BIT(10)
#define BIT_CLR_HI3Q_HOST_IDX_8812F BIT(9)
#define BIT_CLR_HI2Q_HOST_IDX_8812F BIT(8)
#define BIT_CLR_HI1Q_HOST_IDX_8812F BIT(7)
#define BIT_CLR_HI0Q_HOST_IDX_8812F BIT(6)
#define BIT_CLR_BKQ_HOST_IDX_8812F BIT(5)
#define BIT_CLR_BEQ_HOST_IDX_8812F BIT(4)
#define BIT_CLR_VIQ_HOST_IDX_8812F BIT(3)
#define BIT_CLR_VOQ_HOST_IDX_8812F BIT(2)
#define BIT_CLR_MGQ_HOST_IDX_8812F BIT(1)
#define BIT_CLR_RXQ_HOST_IDX_8812F BIT(0)

/* 2 REG_VOQ_TXBD_IDX_8812F */

#define BIT_SHIFT_VOQ_HW_IDX_8812F 16
#define BIT_MASK_VOQ_HW_IDX_8812F 0xfff
#define BIT_VOQ_HW_IDX_8812F(x)                                                \
	(((x) & BIT_MASK_VOQ_HW_IDX_8812F) << BIT_SHIFT_VOQ_HW_IDX_8812F)
#define BITS_VOQ_HW_IDX_8812F                                                  \
	(BIT_MASK_VOQ_HW_IDX_8812F << BIT_SHIFT_VOQ_HW_IDX_8812F)
#define BIT_CLEAR_VOQ_HW_IDX_8812F(x) ((x) & (~BITS_VOQ_HW_IDX_8812F))
#define BIT_GET_VOQ_HW_IDX_8812F(x)                                            \
	(((x) >> BIT_SHIFT_VOQ_HW_IDX_8812F) & BIT_MASK_VOQ_HW_IDX_8812F)
#define BIT_SET_VOQ_HW_IDX_8812F(x, v)                                         \
	(BIT_CLEAR_VOQ_HW_IDX_8812F(x) | BIT_VOQ_HW_IDX_8812F(v))

#define BIT_SHIFT_VOQ_HOST_IDX_8812F 0
#define BIT_MASK_VOQ_HOST_IDX_8812F 0xfff
#define BIT_VOQ_HOST_IDX_8812F(x)                                              \
	(((x) & BIT_MASK_VOQ_HOST_IDX_8812F) << BIT_SHIFT_VOQ_HOST_IDX_8812F)
#define BITS_VOQ_HOST_IDX_8812F                                                \
	(BIT_MASK_VOQ_HOST_IDX_8812F << BIT_SHIFT_VOQ_HOST_IDX_8812F)
#define BIT_CLEAR_VOQ_HOST_IDX_8812F(x) ((x) & (~BITS_VOQ_HOST_IDX_8812F))
#define BIT_GET_VOQ_HOST_IDX_8812F(x)                                          \
	(((x) >> BIT_SHIFT_VOQ_HOST_IDX_8812F) & BIT_MASK_VOQ_HOST_IDX_8812F)
#define BIT_SET_VOQ_HOST_IDX_8812F(x, v)                                       \
	(BIT_CLEAR_VOQ_HOST_IDX_8812F(x) | BIT_VOQ_HOST_IDX_8812F(v))

/* 2 REG_VIQ_TXBD_IDX_8812F */

#define BIT_SHIFT_VIQ_HW_IDX_8812F 16
#define BIT_MASK_VIQ_HW_IDX_8812F 0xfff
#define BIT_VIQ_HW_IDX_8812F(x)                                                \
	(((x) & BIT_MASK_VIQ_HW_IDX_8812F) << BIT_SHIFT_VIQ_HW_IDX_8812F)
#define BITS_VIQ_HW_IDX_8812F                                                  \
	(BIT_MASK_VIQ_HW_IDX_8812F << BIT_SHIFT_VIQ_HW_IDX_8812F)
#define BIT_CLEAR_VIQ_HW_IDX_8812F(x) ((x) & (~BITS_VIQ_HW_IDX_8812F))
#define BIT_GET_VIQ_HW_IDX_8812F(x)                                            \
	(((x) >> BIT_SHIFT_VIQ_HW_IDX_8812F) & BIT_MASK_VIQ_HW_IDX_8812F)
#define BIT_SET_VIQ_HW_IDX_8812F(x, v)                                         \
	(BIT_CLEAR_VIQ_HW_IDX_8812F(x) | BIT_VIQ_HW_IDX_8812F(v))

#define BIT_SHIFT_VIQ_HOST_IDX_8812F 0
#define BIT_MASK_VIQ_HOST_IDX_8812F 0xfff
#define BIT_VIQ_HOST_IDX_8812F(x)                                              \
	(((x) & BIT_MASK_VIQ_HOST_IDX_8812F) << BIT_SHIFT_VIQ_HOST_IDX_8812F)
#define BITS_VIQ_HOST_IDX_8812F                                                \
	(BIT_MASK_VIQ_HOST_IDX_8812F << BIT_SHIFT_VIQ_HOST_IDX_8812F)
#define BIT_CLEAR_VIQ_HOST_IDX_8812F(x) ((x) & (~BITS_VIQ_HOST_IDX_8812F))
#define BIT_GET_VIQ_HOST_IDX_8812F(x)                                          \
	(((x) >> BIT_SHIFT_VIQ_HOST_IDX_8812F) & BIT_MASK_VIQ_HOST_IDX_8812F)
#define BIT_SET_VIQ_HOST_IDX_8812F(x, v)                                       \
	(BIT_CLEAR_VIQ_HOST_IDX_8812F(x) | BIT_VIQ_HOST_IDX_8812F(v))

/* 2 REG_BEQ_TXBD_IDX_8812F */

#define BIT_SHIFT_BEQ_HW_IDX_8812F 16
#define BIT_MASK_BEQ_HW_IDX_8812F 0xfff
#define BIT_BEQ_HW_IDX_8812F(x)                                                \
	(((x) & BIT_MASK_BEQ_HW_IDX_8812F) << BIT_SHIFT_BEQ_HW_IDX_8812F)
#define BITS_BEQ_HW_IDX_8812F                                                  \
	(BIT_MASK_BEQ_HW_IDX_8812F << BIT_SHIFT_BEQ_HW_IDX_8812F)
#define BIT_CLEAR_BEQ_HW_IDX_8812F(x) ((x) & (~BITS_BEQ_HW_IDX_8812F))
#define BIT_GET_BEQ_HW_IDX_8812F(x)                                            \
	(((x) >> BIT_SHIFT_BEQ_HW_IDX_8812F) & BIT_MASK_BEQ_HW_IDX_8812F)
#define BIT_SET_BEQ_HW_IDX_8812F(x, v)                                         \
	(BIT_CLEAR_BEQ_HW_IDX_8812F(x) | BIT_BEQ_HW_IDX_8812F(v))

#define BIT_SHIFT_BEQ_HOST_IDX_8812F 0
#define BIT_MASK_BEQ_HOST_IDX_8812F 0xfff
#define BIT_BEQ_HOST_IDX_8812F(x)                                              \
	(((x) & BIT_MASK_BEQ_HOST_IDX_8812F) << BIT_SHIFT_BEQ_HOST_IDX_8812F)
#define BITS_BEQ_HOST_IDX_8812F                                                \
	(BIT_MASK_BEQ_HOST_IDX_8812F << BIT_SHIFT_BEQ_HOST_IDX_8812F)
#define BIT_CLEAR_BEQ_HOST_IDX_8812F(x) ((x) & (~BITS_BEQ_HOST_IDX_8812F))
#define BIT_GET_BEQ_HOST_IDX_8812F(x)                                          \
	(((x) >> BIT_SHIFT_BEQ_HOST_IDX_8812F) & BIT_MASK_BEQ_HOST_IDX_8812F)
#define BIT_SET_BEQ_HOST_IDX_8812F(x, v)                                       \
	(BIT_CLEAR_BEQ_HOST_IDX_8812F(x) | BIT_BEQ_HOST_IDX_8812F(v))

/* 2 REG_BKQ_TXBD_IDX_8812F */

#define BIT_SHIFT_BKQ_HW_IDX_8812F 16
#define BIT_MASK_BKQ_HW_IDX_8812F 0xfff
#define BIT_BKQ_HW_IDX_8812F(x)                                                \
	(((x) & BIT_MASK_BKQ_HW_IDX_8812F) << BIT_SHIFT_BKQ_HW_IDX_8812F)
#define BITS_BKQ_HW_IDX_8812F                                                  \
	(BIT_MASK_BKQ_HW_IDX_8812F << BIT_SHIFT_BKQ_HW_IDX_8812F)
#define BIT_CLEAR_BKQ_HW_IDX_8812F(x) ((x) & (~BITS_BKQ_HW_IDX_8812F))
#define BIT_GET_BKQ_HW_IDX_8812F(x)                                            \
	(((x) >> BIT_SHIFT_BKQ_HW_IDX_8812F) & BIT_MASK_BKQ_HW_IDX_8812F)
#define BIT_SET_BKQ_HW_IDX_8812F(x, v)                                         \
	(BIT_CLEAR_BKQ_HW_IDX_8812F(x) | BIT_BKQ_HW_IDX_8812F(v))

#define BIT_SHIFT_BKQ_HOST_IDX_8812F 0
#define BIT_MASK_BKQ_HOST_IDX_8812F 0xfff
#define BIT_BKQ_HOST_IDX_8812F(x)                                              \
	(((x) & BIT_MASK_BKQ_HOST_IDX_8812F) << BIT_SHIFT_BKQ_HOST_IDX_8812F)
#define BITS_BKQ_HOST_IDX_8812F                                                \
	(BIT_MASK_BKQ_HOST_IDX_8812F << BIT_SHIFT_BKQ_HOST_IDX_8812F)
#define BIT_CLEAR_BKQ_HOST_IDX_8812F(x) ((x) & (~BITS_BKQ_HOST_IDX_8812F))
#define BIT_GET_BKQ_HOST_IDX_8812F(x)                                          \
	(((x) >> BIT_SHIFT_BKQ_HOST_IDX_8812F) & BIT_MASK_BKQ_HOST_IDX_8812F)
#define BIT_SET_BKQ_HOST_IDX_8812F(x, v)                                       \
	(BIT_CLEAR_BKQ_HOST_IDX_8812F(x) | BIT_BKQ_HOST_IDX_8812F(v))

/* 2 REG_MGQ_TXBD_IDX_8812F */

#define BIT_SHIFT_MGQ_HW_IDX_8812F 16
#define BIT_MASK_MGQ_HW_IDX_8812F 0xfff
#define BIT_MGQ_HW_IDX_8812F(x)                                                \
	(((x) & BIT_MASK_MGQ_HW_IDX_8812F) << BIT_SHIFT_MGQ_HW_IDX_8812F)
#define BITS_MGQ_HW_IDX_8812F                                                  \
	(BIT_MASK_MGQ_HW_IDX_8812F << BIT_SHIFT_MGQ_HW_IDX_8812F)
#define BIT_CLEAR_MGQ_HW_IDX_8812F(x) ((x) & (~BITS_MGQ_HW_IDX_8812F))
#define BIT_GET_MGQ_HW_IDX_8812F(x)                                            \
	(((x) >> BIT_SHIFT_MGQ_HW_IDX_8812F) & BIT_MASK_MGQ_HW_IDX_8812F)
#define BIT_SET_MGQ_HW_IDX_8812F(x, v)                                         \
	(BIT_CLEAR_MGQ_HW_IDX_8812F(x) | BIT_MGQ_HW_IDX_8812F(v))

#define BIT_SHIFT_MGQ_HOST_IDX_8812F 0
#define BIT_MASK_MGQ_HOST_IDX_8812F 0xfff
#define BIT_MGQ_HOST_IDX_8812F(x)                                              \
	(((x) & BIT_MASK_MGQ_HOST_IDX_8812F) << BIT_SHIFT_MGQ_HOST_IDX_8812F)
#define BITS_MGQ_HOST_IDX_8812F                                                \
	(BIT_MASK_MGQ_HOST_IDX_8812F << BIT_SHIFT_MGQ_HOST_IDX_8812F)
#define BIT_CLEAR_MGQ_HOST_IDX_8812F(x) ((x) & (~BITS_MGQ_HOST_IDX_8812F))
#define BIT_GET_MGQ_HOST_IDX_8812F(x)                                          \
	(((x) >> BIT_SHIFT_MGQ_HOST_IDX_8812F) & BIT_MASK_MGQ_HOST_IDX_8812F)
#define BIT_SET_MGQ_HOST_IDX_8812F(x, v)                                       \
	(BIT_CLEAR_MGQ_HOST_IDX_8812F(x) | BIT_MGQ_HOST_IDX_8812F(v))

/* 2 REG_RXQ_RXBD_IDX_8812F */

#define BIT_SHIFT_RXQ_HW_IDX_8812F 16
#define BIT_MASK_RXQ_HW_IDX_8812F 0xfff
#define BIT_RXQ_HW_IDX_8812F(x)                                                \
	(((x) & BIT_MASK_RXQ_HW_IDX_8812F) << BIT_SHIFT_RXQ_HW_IDX_8812F)
#define BITS_RXQ_HW_IDX_8812F                                                  \
	(BIT_MASK_RXQ_HW_IDX_8812F << BIT_SHIFT_RXQ_HW_IDX_8812F)
#define BIT_CLEAR_RXQ_HW_IDX_8812F(x) ((x) & (~BITS_RXQ_HW_IDX_8812F))
#define BIT_GET_RXQ_HW_IDX_8812F(x)                                            \
	(((x) >> BIT_SHIFT_RXQ_HW_IDX_8812F) & BIT_MASK_RXQ_HW_IDX_8812F)
#define BIT_SET_RXQ_HW_IDX_8812F(x, v)                                         \
	(BIT_CLEAR_RXQ_HW_IDX_8812F(x) | BIT_RXQ_HW_IDX_8812F(v))

#define BIT_SHIFT_RXQ_HOST_IDX_8812F 0
#define BIT_MASK_RXQ_HOST_IDX_8812F 0xfff
#define BIT_RXQ_HOST_IDX_8812F(x)                                              \
	(((x) & BIT_MASK_RXQ_HOST_IDX_8812F) << BIT_SHIFT_RXQ_HOST_IDX_8812F)
#define BITS_RXQ_HOST_IDX_8812F                                                \
	(BIT_MASK_RXQ_HOST_IDX_8812F << BIT_SHIFT_RXQ_HOST_IDX_8812F)
#define BIT_CLEAR_RXQ_HOST_IDX_8812F(x) ((x) & (~BITS_RXQ_HOST_IDX_8812F))
#define BIT_GET_RXQ_HOST_IDX_8812F(x)                                          \
	(((x) >> BIT_SHIFT_RXQ_HOST_IDX_8812F) & BIT_MASK_RXQ_HOST_IDX_8812F)
#define BIT_SET_RXQ_HOST_IDX_8812F(x, v)                                       \
	(BIT_CLEAR_RXQ_HOST_IDX_8812F(x) | BIT_RXQ_HOST_IDX_8812F(v))

/* 2 REG_HI0Q_TXBD_IDX_8812F */

#define BIT_SHIFT_HI0Q_HW_IDX_8812F 16
#define BIT_MASK_HI0Q_HW_IDX_8812F 0xfff
#define BIT_HI0Q_HW_IDX_8812F(x)                                               \
	(((x) & BIT_MASK_HI0Q_HW_IDX_8812F) << BIT_SHIFT_HI0Q_HW_IDX_8812F)
#define BITS_HI0Q_HW_IDX_8812F                                                 \
	(BIT_MASK_HI0Q_HW_IDX_8812F << BIT_SHIFT_HI0Q_HW_IDX_8812F)
#define BIT_CLEAR_HI0Q_HW_IDX_8812F(x) ((x) & (~BITS_HI0Q_HW_IDX_8812F))
#define BIT_GET_HI0Q_HW_IDX_8812F(x)                                           \
	(((x) >> BIT_SHIFT_HI0Q_HW_IDX_8812F) & BIT_MASK_HI0Q_HW_IDX_8812F)
#define BIT_SET_HI0Q_HW_IDX_8812F(x, v)                                        \
	(BIT_CLEAR_HI0Q_HW_IDX_8812F(x) | BIT_HI0Q_HW_IDX_8812F(v))

#define BIT_SHIFT_HI0Q_HOST_IDX_8812F 0
#define BIT_MASK_HI0Q_HOST_IDX_8812F 0xfff
#define BIT_HI0Q_HOST_IDX_8812F(x)                                             \
	(((x) & BIT_MASK_HI0Q_HOST_IDX_8812F) << BIT_SHIFT_HI0Q_HOST_IDX_8812F)
#define BITS_HI0Q_HOST_IDX_8812F                                               \
	(BIT_MASK_HI0Q_HOST_IDX_8812F << BIT_SHIFT_HI0Q_HOST_IDX_8812F)
#define BIT_CLEAR_HI0Q_HOST_IDX_8812F(x) ((x) & (~BITS_HI0Q_HOST_IDX_8812F))
#define BIT_GET_HI0Q_HOST_IDX_8812F(x)                                         \
	(((x) >> BIT_SHIFT_HI0Q_HOST_IDX_8812F) & BIT_MASK_HI0Q_HOST_IDX_8812F)
#define BIT_SET_HI0Q_HOST_IDX_8812F(x, v)                                      \
	(BIT_CLEAR_HI0Q_HOST_IDX_8812F(x) | BIT_HI0Q_HOST_IDX_8812F(v))

/* 2 REG_HI1Q_TXBD_IDX_8812F */

#define BIT_SHIFT_HI1Q_HW_IDX_8812F 16
#define BIT_MASK_HI1Q_HW_IDX_8812F 0xfff
#define BIT_HI1Q_HW_IDX_8812F(x)                                               \
	(((x) & BIT_MASK_HI1Q_HW_IDX_8812F) << BIT_SHIFT_HI1Q_HW_IDX_8812F)
#define BITS_HI1Q_HW_IDX_8812F                                                 \
	(BIT_MASK_HI1Q_HW_IDX_8812F << BIT_SHIFT_HI1Q_HW_IDX_8812F)
#define BIT_CLEAR_HI1Q_HW_IDX_8812F(x) ((x) & (~BITS_HI1Q_HW_IDX_8812F))
#define BIT_GET_HI1Q_HW_IDX_8812F(x)                                           \
	(((x) >> BIT_SHIFT_HI1Q_HW_IDX_8812F) & BIT_MASK_HI1Q_HW_IDX_8812F)
#define BIT_SET_HI1Q_HW_IDX_8812F(x, v)                                        \
	(BIT_CLEAR_HI1Q_HW_IDX_8812F(x) | BIT_HI1Q_HW_IDX_8812F(v))

#define BIT_SHIFT_HI1Q_HOST_IDX_8812F 0
#define BIT_MASK_HI1Q_HOST_IDX_8812F 0xfff
#define BIT_HI1Q_HOST_IDX_8812F(x)                                             \
	(((x) & BIT_MASK_HI1Q_HOST_IDX_8812F) << BIT_SHIFT_HI1Q_HOST_IDX_8812F)
#define BITS_HI1Q_HOST_IDX_8812F                                               \
	(BIT_MASK_HI1Q_HOST_IDX_8812F << BIT_SHIFT_HI1Q_HOST_IDX_8812F)
#define BIT_CLEAR_HI1Q_HOST_IDX_8812F(x) ((x) & (~BITS_HI1Q_HOST_IDX_8812F))
#define BIT_GET_HI1Q_HOST_IDX_8812F(x)                                         \
	(((x) >> BIT_SHIFT_HI1Q_HOST_IDX_8812F) & BIT_MASK_HI1Q_HOST_IDX_8812F)
#define BIT_SET_HI1Q_HOST_IDX_8812F(x, v)                                      \
	(BIT_CLEAR_HI1Q_HOST_IDX_8812F(x) | BIT_HI1Q_HOST_IDX_8812F(v))

/* 2 REG_HI2Q_TXBD_IDX_8812F */

#define BIT_SHIFT_HI2Q_HW_IDX_8812F 16
#define BIT_MASK_HI2Q_HW_IDX_8812F 0xfff
#define BIT_HI2Q_HW_IDX_8812F(x)                                               \
	(((x) & BIT_MASK_HI2Q_HW_IDX_8812F) << BIT_SHIFT_HI2Q_HW_IDX_8812F)
#define BITS_HI2Q_HW_IDX_8812F                                                 \
	(BIT_MASK_HI2Q_HW_IDX_8812F << BIT_SHIFT_HI2Q_HW_IDX_8812F)
#define BIT_CLEAR_HI2Q_HW_IDX_8812F(x) ((x) & (~BITS_HI2Q_HW_IDX_8812F))
#define BIT_GET_HI2Q_HW_IDX_8812F(x)                                           \
	(((x) >> BIT_SHIFT_HI2Q_HW_IDX_8812F) & BIT_MASK_HI2Q_HW_IDX_8812F)
#define BIT_SET_HI2Q_HW_IDX_8812F(x, v)                                        \
	(BIT_CLEAR_HI2Q_HW_IDX_8812F(x) | BIT_HI2Q_HW_IDX_8812F(v))

#define BIT_SHIFT_HI2Q_HOST_IDX_8812F 0
#define BIT_MASK_HI2Q_HOST_IDX_8812F 0xfff
#define BIT_HI2Q_HOST_IDX_8812F(x)                                             \
	(((x) & BIT_MASK_HI2Q_HOST_IDX_8812F) << BIT_SHIFT_HI2Q_HOST_IDX_8812F)
#define BITS_HI2Q_HOST_IDX_8812F                                               \
	(BIT_MASK_HI2Q_HOST_IDX_8812F << BIT_SHIFT_HI2Q_HOST_IDX_8812F)
#define BIT_CLEAR_HI2Q_HOST_IDX_8812F(x) ((x) & (~BITS_HI2Q_HOST_IDX_8812F))
#define BIT_GET_HI2Q_HOST_IDX_8812F(x)                                         \
	(((x) >> BIT_SHIFT_HI2Q_HOST_IDX_8812F) & BIT_MASK_HI2Q_HOST_IDX_8812F)
#define BIT_SET_HI2Q_HOST_IDX_8812F(x, v)                                      \
	(BIT_CLEAR_HI2Q_HOST_IDX_8812F(x) | BIT_HI2Q_HOST_IDX_8812F(v))

/* 2 REG_HI3Q_TXBD_IDX_8812F */

#define BIT_SHIFT_HI3Q_HW_IDX_8812F 16
#define BIT_MASK_HI3Q_HW_IDX_8812F 0xfff
#define BIT_HI3Q_HW_IDX_8812F(x)                                               \
	(((x) & BIT_MASK_HI3Q_HW_IDX_8812F) << BIT_SHIFT_HI3Q_HW_IDX_8812F)
#define BITS_HI3Q_HW_IDX_8812F                                                 \
	(BIT_MASK_HI3Q_HW_IDX_8812F << BIT_SHIFT_HI3Q_HW_IDX_8812F)
#define BIT_CLEAR_HI3Q_HW_IDX_8812F(x) ((x) & (~BITS_HI3Q_HW_IDX_8812F))
#define BIT_GET_HI3Q_HW_IDX_8812F(x)                                           \
	(((x) >> BIT_SHIFT_HI3Q_HW_IDX_8812F) & BIT_MASK_HI3Q_HW_IDX_8812F)
#define BIT_SET_HI3Q_HW_IDX_8812F(x, v)                                        \
	(BIT_CLEAR_HI3Q_HW_IDX_8812F(x) | BIT_HI3Q_HW_IDX_8812F(v))

#define BIT_SHIFT_HI3Q_HOST_IDX_8812F 0
#define BIT_MASK_HI3Q_HOST_IDX_8812F 0xfff
#define BIT_HI3Q_HOST_IDX_8812F(x)                                             \
	(((x) & BIT_MASK_HI3Q_HOST_IDX_8812F) << BIT_SHIFT_HI3Q_HOST_IDX_8812F)
#define BITS_HI3Q_HOST_IDX_8812F                                               \
	(BIT_MASK_HI3Q_HOST_IDX_8812F << BIT_SHIFT_HI3Q_HOST_IDX_8812F)
#define BIT_CLEAR_HI3Q_HOST_IDX_8812F(x) ((x) & (~BITS_HI3Q_HOST_IDX_8812F))
#define BIT_GET_HI3Q_HOST_IDX_8812F(x)                                         \
	(((x) >> BIT_SHIFT_HI3Q_HOST_IDX_8812F) & BIT_MASK_HI3Q_HOST_IDX_8812F)
#define BIT_SET_HI3Q_HOST_IDX_8812F(x, v)                                      \
	(BIT_CLEAR_HI3Q_HOST_IDX_8812F(x) | BIT_HI3Q_HOST_IDX_8812F(v))

/* 2 REG_HI4Q_TXBD_IDX_8812F */

#define BIT_SHIFT_HI4Q_HW_IDX_8812F 16
#define BIT_MASK_HI4Q_HW_IDX_8812F 0xfff
#define BIT_HI4Q_HW_IDX_8812F(x)                                               \
	(((x) & BIT_MASK_HI4Q_HW_IDX_8812F) << BIT_SHIFT_HI4Q_HW_IDX_8812F)
#define BITS_HI4Q_HW_IDX_8812F                                                 \
	(BIT_MASK_HI4Q_HW_IDX_8812F << BIT_SHIFT_HI4Q_HW_IDX_8812F)
#define BIT_CLEAR_HI4Q_HW_IDX_8812F(x) ((x) & (~BITS_HI4Q_HW_IDX_8812F))
#define BIT_GET_HI4Q_HW_IDX_8812F(x)                                           \
	(((x) >> BIT_SHIFT_HI4Q_HW_IDX_8812F) & BIT_MASK_HI4Q_HW_IDX_8812F)
#define BIT_SET_HI4Q_HW_IDX_8812F(x, v)                                        \
	(BIT_CLEAR_HI4Q_HW_IDX_8812F(x) | BIT_HI4Q_HW_IDX_8812F(v))

#define BIT_SHIFT_HI4Q_HOST_IDX_8812F 0
#define BIT_MASK_HI4Q_HOST_IDX_8812F 0xfff
#define BIT_HI4Q_HOST_IDX_8812F(x)                                             \
	(((x) & BIT_MASK_HI4Q_HOST_IDX_8812F) << BIT_SHIFT_HI4Q_HOST_IDX_8812F)
#define BITS_HI4Q_HOST_IDX_8812F                                               \
	(BIT_MASK_HI4Q_HOST_IDX_8812F << BIT_SHIFT_HI4Q_HOST_IDX_8812F)
#define BIT_CLEAR_HI4Q_HOST_IDX_8812F(x) ((x) & (~BITS_HI4Q_HOST_IDX_8812F))
#define BIT_GET_HI4Q_HOST_IDX_8812F(x)                                         \
	(((x) >> BIT_SHIFT_HI4Q_HOST_IDX_8812F) & BIT_MASK_HI4Q_HOST_IDX_8812F)
#define BIT_SET_HI4Q_HOST_IDX_8812F(x, v)                                      \
	(BIT_CLEAR_HI4Q_HOST_IDX_8812F(x) | BIT_HI4Q_HOST_IDX_8812F(v))

/* 2 REG_HI5Q_TXBD_IDX_8812F */

#define BIT_SHIFT_HI5Q_HW_IDX_8812F 16
#define BIT_MASK_HI5Q_HW_IDX_8812F 0xfff
#define BIT_HI5Q_HW_IDX_8812F(x)                                               \
	(((x) & BIT_MASK_HI5Q_HW_IDX_8812F) << BIT_SHIFT_HI5Q_HW_IDX_8812F)
#define BITS_HI5Q_HW_IDX_8812F                                                 \
	(BIT_MASK_HI5Q_HW_IDX_8812F << BIT_SHIFT_HI5Q_HW_IDX_8812F)
#define BIT_CLEAR_HI5Q_HW_IDX_8812F(x) ((x) & (~BITS_HI5Q_HW_IDX_8812F))
#define BIT_GET_HI5Q_HW_IDX_8812F(x)                                           \
	(((x) >> BIT_SHIFT_HI5Q_HW_IDX_8812F) & BIT_MASK_HI5Q_HW_IDX_8812F)
#define BIT_SET_HI5Q_HW_IDX_8812F(x, v)                                        \
	(BIT_CLEAR_HI5Q_HW_IDX_8812F(x) | BIT_HI5Q_HW_IDX_8812F(v))

#define BIT_SHIFT_HI5Q_HOST_IDX_8812F 0
#define BIT_MASK_HI5Q_HOST_IDX_8812F 0xfff
#define BIT_HI5Q_HOST_IDX_8812F(x)                                             \
	(((x) & BIT_MASK_HI5Q_HOST_IDX_8812F) << BIT_SHIFT_HI5Q_HOST_IDX_8812F)
#define BITS_HI5Q_HOST_IDX_8812F                                               \
	(BIT_MASK_HI5Q_HOST_IDX_8812F << BIT_SHIFT_HI5Q_HOST_IDX_8812F)
#define BIT_CLEAR_HI5Q_HOST_IDX_8812F(x) ((x) & (~BITS_HI5Q_HOST_IDX_8812F))
#define BIT_GET_HI5Q_HOST_IDX_8812F(x)                                         \
	(((x) >> BIT_SHIFT_HI5Q_HOST_IDX_8812F) & BIT_MASK_HI5Q_HOST_IDX_8812F)
#define BIT_SET_HI5Q_HOST_IDX_8812F(x, v)                                      \
	(BIT_CLEAR_HI5Q_HOST_IDX_8812F(x) | BIT_HI5Q_HOST_IDX_8812F(v))

/* 2 REG_HI6Q_TXBD_IDX_8812F */

#define BIT_SHIFT_HI6Q_HW_IDX_8812F 16
#define BIT_MASK_HI6Q_HW_IDX_8812F 0xfff
#define BIT_HI6Q_HW_IDX_8812F(x)                                               \
	(((x) & BIT_MASK_HI6Q_HW_IDX_8812F) << BIT_SHIFT_HI6Q_HW_IDX_8812F)
#define BITS_HI6Q_HW_IDX_8812F                                                 \
	(BIT_MASK_HI6Q_HW_IDX_8812F << BIT_SHIFT_HI6Q_HW_IDX_8812F)
#define BIT_CLEAR_HI6Q_HW_IDX_8812F(x) ((x) & (~BITS_HI6Q_HW_IDX_8812F))
#define BIT_GET_HI6Q_HW_IDX_8812F(x)                                           \
	(((x) >> BIT_SHIFT_HI6Q_HW_IDX_8812F) & BIT_MASK_HI6Q_HW_IDX_8812F)
#define BIT_SET_HI6Q_HW_IDX_8812F(x, v)                                        \
	(BIT_CLEAR_HI6Q_HW_IDX_8812F(x) | BIT_HI6Q_HW_IDX_8812F(v))

#define BIT_SHIFT_HI6Q_HOST_IDX_8812F 0
#define BIT_MASK_HI6Q_HOST_IDX_8812F 0xfff
#define BIT_HI6Q_HOST_IDX_8812F(x)                                             \
	(((x) & BIT_MASK_HI6Q_HOST_IDX_8812F) << BIT_SHIFT_HI6Q_HOST_IDX_8812F)
#define BITS_HI6Q_HOST_IDX_8812F                                               \
	(BIT_MASK_HI6Q_HOST_IDX_8812F << BIT_SHIFT_HI6Q_HOST_IDX_8812F)
#define BIT_CLEAR_HI6Q_HOST_IDX_8812F(x) ((x) & (~BITS_HI6Q_HOST_IDX_8812F))
#define BIT_GET_HI6Q_HOST_IDX_8812F(x)                                         \
	(((x) >> BIT_SHIFT_HI6Q_HOST_IDX_8812F) & BIT_MASK_HI6Q_HOST_IDX_8812F)
#define BIT_SET_HI6Q_HOST_IDX_8812F(x, v)                                      \
	(BIT_CLEAR_HI6Q_HOST_IDX_8812F(x) | BIT_HI6Q_HOST_IDX_8812F(v))

/* 2 REG_HI7Q_TXBD_IDX_8812F */

#define BIT_SHIFT_HI7Q_HW_IDX_8812F 16
#define BIT_MASK_HI7Q_HW_IDX_8812F 0xfff
#define BIT_HI7Q_HW_IDX_8812F(x)                                               \
	(((x) & BIT_MASK_HI7Q_HW_IDX_8812F) << BIT_SHIFT_HI7Q_HW_IDX_8812F)
#define BITS_HI7Q_HW_IDX_8812F                                                 \
	(BIT_MASK_HI7Q_HW_IDX_8812F << BIT_SHIFT_HI7Q_HW_IDX_8812F)
#define BIT_CLEAR_HI7Q_HW_IDX_8812F(x) ((x) & (~BITS_HI7Q_HW_IDX_8812F))
#define BIT_GET_HI7Q_HW_IDX_8812F(x)                                           \
	(((x) >> BIT_SHIFT_HI7Q_HW_IDX_8812F) & BIT_MASK_HI7Q_HW_IDX_8812F)
#define BIT_SET_HI7Q_HW_IDX_8812F(x, v)                                        \
	(BIT_CLEAR_HI7Q_HW_IDX_8812F(x) | BIT_HI7Q_HW_IDX_8812F(v))

#define BIT_SHIFT_HI7Q_HOST_IDX_8812F 0
#define BIT_MASK_HI7Q_HOST_IDX_8812F 0xfff
#define BIT_HI7Q_HOST_IDX_8812F(x)                                             \
	(((x) & BIT_MASK_HI7Q_HOST_IDX_8812F) << BIT_SHIFT_HI7Q_HOST_IDX_8812F)
#define BITS_HI7Q_HOST_IDX_8812F                                               \
	(BIT_MASK_HI7Q_HOST_IDX_8812F << BIT_SHIFT_HI7Q_HOST_IDX_8812F)
#define BIT_CLEAR_HI7Q_HOST_IDX_8812F(x) ((x) & (~BITS_HI7Q_HOST_IDX_8812F))
#define BIT_GET_HI7Q_HOST_IDX_8812F(x)                                         \
	(((x) >> BIT_SHIFT_HI7Q_HOST_IDX_8812F) & BIT_MASK_HI7Q_HOST_IDX_8812F)
#define BIT_SET_HI7Q_HOST_IDX_8812F(x, v)                                      \
	(BIT_CLEAR_HI7Q_HOST_IDX_8812F(x) | BIT_HI7Q_HOST_IDX_8812F(v))

/* 2 REG_DBG_SEL_V1_8812F */

#define BIT_SHIFT_DBG_SEL_8812F 0
#define BIT_MASK_DBG_SEL_8812F 0xff
#define BIT_DBG_SEL_8812F(x)                                                   \
	(((x) & BIT_MASK_DBG_SEL_8812F) << BIT_SHIFT_DBG_SEL_8812F)
#define BITS_DBG_SEL_8812F (BIT_MASK_DBG_SEL_8812F << BIT_SHIFT_DBG_SEL_8812F)
#define BIT_CLEAR_DBG_SEL_8812F(x) ((x) & (~BITS_DBG_SEL_8812F))
#define BIT_GET_DBG_SEL_8812F(x)                                               \
	(((x) >> BIT_SHIFT_DBG_SEL_8812F) & BIT_MASK_DBG_SEL_8812F)
#define BIT_SET_DBG_SEL_8812F(x, v)                                            \
	(BIT_CLEAR_DBG_SEL_8812F(x) | BIT_DBG_SEL_8812F(v))

/* 2 REG_PCIE_HRPWM1_V1_8812F */

#define BIT_SHIFT_PCIE_HRPWM_8812F 0
#define BIT_MASK_PCIE_HRPWM_8812F 0xff
#define BIT_PCIE_HRPWM_8812F(x)                                                \
	(((x) & BIT_MASK_PCIE_HRPWM_8812F) << BIT_SHIFT_PCIE_HRPWM_8812F)
#define BITS_PCIE_HRPWM_8812F                                                  \
	(BIT_MASK_PCIE_HRPWM_8812F << BIT_SHIFT_PCIE_HRPWM_8812F)
#define BIT_CLEAR_PCIE_HRPWM_8812F(x) ((x) & (~BITS_PCIE_HRPWM_8812F))
#define BIT_GET_PCIE_HRPWM_8812F(x)                                            \
	(((x) >> BIT_SHIFT_PCIE_HRPWM_8812F) & BIT_MASK_PCIE_HRPWM_8812F)
#define BIT_SET_PCIE_HRPWM_8812F(x, v)                                         \
	(BIT_CLEAR_PCIE_HRPWM_8812F(x) | BIT_PCIE_HRPWM_8812F(v))

/* 2 REG_PCIE_HCPWM1_V1_8812F */

#define BIT_SHIFT_PCIE_HCPWM_8812F 0
#define BIT_MASK_PCIE_HCPWM_8812F 0xff
#define BIT_PCIE_HCPWM_8812F(x)                                                \
	(((x) & BIT_MASK_PCIE_HCPWM_8812F) << BIT_SHIFT_PCIE_HCPWM_8812F)
#define BITS_PCIE_HCPWM_8812F                                                  \
	(BIT_MASK_PCIE_HCPWM_8812F << BIT_SHIFT_PCIE_HCPWM_8812F)
#define BIT_CLEAR_PCIE_HCPWM_8812F(x) ((x) & (~BITS_PCIE_HCPWM_8812F))
#define BIT_GET_PCIE_HCPWM_8812F(x)                                            \
	(((x) >> BIT_SHIFT_PCIE_HCPWM_8812F) & BIT_MASK_PCIE_HCPWM_8812F)
#define BIT_SET_PCIE_HCPWM_8812F(x, v)                                         \
	(BIT_CLEAR_PCIE_HCPWM_8812F(x) | BIT_PCIE_HCPWM_8812F(v))

/* 2 REG_PCIE_CTRL2_8812F */
#define BIT_DIS_TXDMA_PRE_8812F BIT(7)
#define BIT_DIS_RXDMA_PRE_8812F BIT(6)

#define BIT_SHIFT_HPS_CLKR_PCIE_8812F 4
#define BIT_MASK_HPS_CLKR_PCIE_8812F 0x3
#define BIT_HPS_CLKR_PCIE_8812F(x)                                             \
	(((x) & BIT_MASK_HPS_CLKR_PCIE_8812F) << BIT_SHIFT_HPS_CLKR_PCIE_8812F)
#define BITS_HPS_CLKR_PCIE_8812F                                               \
	(BIT_MASK_HPS_CLKR_PCIE_8812F << BIT_SHIFT_HPS_CLKR_PCIE_8812F)
#define BIT_CLEAR_HPS_CLKR_PCIE_8812F(x) ((x) & (~BITS_HPS_CLKR_PCIE_8812F))
#define BIT_GET_HPS_CLKR_PCIE_8812F(x)                                         \
	(((x) >> BIT_SHIFT_HPS_CLKR_PCIE_8812F) & BIT_MASK_HPS_CLKR_PCIE_8812F)
#define BIT_SET_HPS_CLKR_PCIE_8812F(x, v)                                      \
	(BIT_CLEAR_HPS_CLKR_PCIE_8812F(x) | BIT_HPS_CLKR_PCIE_8812F(v))

#define BIT_PCIE_INT_8812F BIT(3)
#define BIT_TXFLAG_EXIT_L1_EN_8812F BIT(2)
#define BIT_EN_RXDMA_ALIGN_8812F BIT(1)
#define BIT_EN_TXDMA_ALIGN_8812F BIT(0)

/* 2 REG_PCIE_HRPWM2_V1_8812F */

#define BIT_SHIFT_PCIE_HRPWM2_8812F 0
#define BIT_MASK_PCIE_HRPWM2_8812F 0xffff
#define BIT_PCIE_HRPWM2_8812F(x)                                               \
	(((x) & BIT_MASK_PCIE_HRPWM2_8812F) << BIT_SHIFT_PCIE_HRPWM2_8812F)
#define BITS_PCIE_HRPWM2_8812F                                                 \
	(BIT_MASK_PCIE_HRPWM2_8812F << BIT_SHIFT_PCIE_HRPWM2_8812F)
#define BIT_CLEAR_PCIE_HRPWM2_8812F(x) ((x) & (~BITS_PCIE_HRPWM2_8812F))
#define BIT_GET_PCIE_HRPWM2_8812F(x)                                           \
	(((x) >> BIT_SHIFT_PCIE_HRPWM2_8812F) & BIT_MASK_PCIE_HRPWM2_8812F)
#define BIT_SET_PCIE_HRPWM2_8812F(x, v)                                        \
	(BIT_CLEAR_PCIE_HRPWM2_8812F(x) | BIT_PCIE_HRPWM2_8812F(v))

/* 2 REG_PCIE_HCPWM2_V1_8812F */

#define BIT_SHIFT_PCIE_HCPWM2_8812F 0
#define BIT_MASK_PCIE_HCPWM2_8812F 0xffff
#define BIT_PCIE_HCPWM2_8812F(x)                                               \
	(((x) & BIT_MASK_PCIE_HCPWM2_8812F) << BIT_SHIFT_PCIE_HCPWM2_8812F)
#define BITS_PCIE_HCPWM2_8812F                                                 \
	(BIT_MASK_PCIE_HCPWM2_8812F << BIT_SHIFT_PCIE_HCPWM2_8812F)
#define BIT_CLEAR_PCIE_HCPWM2_8812F(x) ((x) & (~BITS_PCIE_HCPWM2_8812F))
#define BIT_GET_PCIE_HCPWM2_8812F(x)                                           \
	(((x) >> BIT_SHIFT_PCIE_HCPWM2_8812F) & BIT_MASK_PCIE_HCPWM2_8812F)
#define BIT_SET_PCIE_HCPWM2_8812F(x, v)                                        \
	(BIT_CLEAR_PCIE_HCPWM2_8812F(x) | BIT_PCIE_HCPWM2_8812F(v))

/* 2 REG_PCIE_H2C_MSG_V1_8812F */

#define BIT_SHIFT_DRV2FW_INFO_8812F 0
#define BIT_MASK_DRV2FW_INFO_8812F 0xffffffffL
#define BIT_DRV2FW_INFO_8812F(x)                                               \
	(((x) & BIT_MASK_DRV2FW_INFO_8812F) << BIT_SHIFT_DRV2FW_INFO_8812F)
#define BITS_DRV2FW_INFO_8812F                                                 \
	(BIT_MASK_DRV2FW_INFO_8812F << BIT_SHIFT_DRV2FW_INFO_8812F)
#define BIT_CLEAR_DRV2FW_INFO_8812F(x) ((x) & (~BITS_DRV2FW_INFO_8812F))
#define BIT_GET_DRV2FW_INFO_8812F(x)                                           \
	(((x) >> BIT_SHIFT_DRV2FW_INFO_8812F) & BIT_MASK_DRV2FW_INFO_8812F)
#define BIT_SET_DRV2FW_INFO_8812F(x, v)                                        \
	(BIT_CLEAR_DRV2FW_INFO_8812F(x) | BIT_DRV2FW_INFO_8812F(v))

/* 2 REG_PCIE_C2H_MSG_V1_8812F */

#define BIT_SHIFT_HCI_PCIE_C2H_MSG_8812F 0
#define BIT_MASK_HCI_PCIE_C2H_MSG_8812F 0xffffffffL
#define BIT_HCI_PCIE_C2H_MSG_8812F(x)                                          \
	(((x) & BIT_MASK_HCI_PCIE_C2H_MSG_8812F)                               \
	 << BIT_SHIFT_HCI_PCIE_C2H_MSG_8812F)
#define BITS_HCI_PCIE_C2H_MSG_8812F                                            \
	(BIT_MASK_HCI_PCIE_C2H_MSG_8812F << BIT_SHIFT_HCI_PCIE_C2H_MSG_8812F)
#define BIT_CLEAR_HCI_PCIE_C2H_MSG_8812F(x)                                    \
	((x) & (~BITS_HCI_PCIE_C2H_MSG_8812F))
#define BIT_GET_HCI_PCIE_C2H_MSG_8812F(x)                                      \
	(((x) >> BIT_SHIFT_HCI_PCIE_C2H_MSG_8812F) &                           \
	 BIT_MASK_HCI_PCIE_C2H_MSG_8812F)
#define BIT_SET_HCI_PCIE_C2H_MSG_8812F(x, v)                                   \
	(BIT_CLEAR_HCI_PCIE_C2H_MSG_8812F(x) | BIT_HCI_PCIE_C2H_MSG_8812F(v))

/* 2 REG_DBI_WDATA_V1_8812F */

#define BIT_SHIFT_DBI_WDATA_8812F 0
#define BIT_MASK_DBI_WDATA_8812F 0xffffffffL
#define BIT_DBI_WDATA_8812F(x)                                                 \
	(((x) & BIT_MASK_DBI_WDATA_8812F) << BIT_SHIFT_DBI_WDATA_8812F)
#define BITS_DBI_WDATA_8812F                                                   \
	(BIT_MASK_DBI_WDATA_8812F << BIT_SHIFT_DBI_WDATA_8812F)
#define BIT_CLEAR_DBI_WDATA_8812F(x) ((x) & (~BITS_DBI_WDATA_8812F))
#define BIT_GET_DBI_WDATA_8812F(x)                                             \
	(((x) >> BIT_SHIFT_DBI_WDATA_8812F) & BIT_MASK_DBI_WDATA_8812F)
#define BIT_SET_DBI_WDATA_8812F(x, v)                                          \
	(BIT_CLEAR_DBI_WDATA_8812F(x) | BIT_DBI_WDATA_8812F(v))

/* 2 REG_DBI_RDATA_V1_8812F */

#define BIT_SHIFT_DBI_RDATA_8812F 0
#define BIT_MASK_DBI_RDATA_8812F 0xffffffffL
#define BIT_DBI_RDATA_8812F(x)                                                 \
	(((x) & BIT_MASK_DBI_RDATA_8812F) << BIT_SHIFT_DBI_RDATA_8812F)
#define BITS_DBI_RDATA_8812F                                                   \
	(BIT_MASK_DBI_RDATA_8812F << BIT_SHIFT_DBI_RDATA_8812F)
#define BIT_CLEAR_DBI_RDATA_8812F(x) ((x) & (~BITS_DBI_RDATA_8812F))
#define BIT_GET_DBI_RDATA_8812F(x)                                             \
	(((x) >> BIT_SHIFT_DBI_RDATA_8812F) & BIT_MASK_DBI_RDATA_8812F)
#define BIT_SET_DBI_RDATA_8812F(x, v)                                          \
	(BIT_CLEAR_DBI_RDATA_8812F(x) | BIT_DBI_RDATA_8812F(v))

/* 2 REG_DBI_FLAG_V1_8812F */
#define BIT_EN_STUCK_DBG_8812F BIT(26)
#define BIT_RX_STUCK_8812F BIT(25)
#define BIT_TX_STUCK_8812F BIT(24)
#define BIT_DBI_RFLAG_8812F BIT(17)
#define BIT_DBI_WFLAG_8812F BIT(16)

#define BIT_SHIFT_DBI_WREN_8812F 12
#define BIT_MASK_DBI_WREN_8812F 0xf
#define BIT_DBI_WREN_8812F(x)                                                  \
	(((x) & BIT_MASK_DBI_WREN_8812F) << BIT_SHIFT_DBI_WREN_8812F)
#define BITS_DBI_WREN_8812F                                                    \
	(BIT_MASK_DBI_WREN_8812F << BIT_SHIFT_DBI_WREN_8812F)
#define BIT_CLEAR_DBI_WREN_8812F(x) ((x) & (~BITS_DBI_WREN_8812F))
#define BIT_GET_DBI_WREN_8812F(x)                                              \
	(((x) >> BIT_SHIFT_DBI_WREN_8812F) & BIT_MASK_DBI_WREN_8812F)
#define BIT_SET_DBI_WREN_8812F(x, v)                                           \
	(BIT_CLEAR_DBI_WREN_8812F(x) | BIT_DBI_WREN_8812F(v))

#define BIT_SHIFT_DBI_ADDR_8812F 0
#define BIT_MASK_DBI_ADDR_8812F 0xfff
#define BIT_DBI_ADDR_8812F(x)                                                  \
	(((x) & BIT_MASK_DBI_ADDR_8812F) << BIT_SHIFT_DBI_ADDR_8812F)
#define BITS_DBI_ADDR_8812F                                                    \
	(BIT_MASK_DBI_ADDR_8812F << BIT_SHIFT_DBI_ADDR_8812F)
#define BIT_CLEAR_DBI_ADDR_8812F(x) ((x) & (~BITS_DBI_ADDR_8812F))
#define BIT_GET_DBI_ADDR_8812F(x)                                              \
	(((x) >> BIT_SHIFT_DBI_ADDR_8812F) & BIT_MASK_DBI_ADDR_8812F)
#define BIT_SET_DBI_ADDR_8812F(x, v)                                           \
	(BIT_CLEAR_DBI_ADDR_8812F(x) | BIT_DBI_ADDR_8812F(v))

/* 2 REG_MDIO_V1_8812F */

#define BIT_SHIFT_MDIO_RDATA_8812F 16
#define BIT_MASK_MDIO_RDATA_8812F 0xffff
#define BIT_MDIO_RDATA_8812F(x)                                                \
	(((x) & BIT_MASK_MDIO_RDATA_8812F) << BIT_SHIFT_MDIO_RDATA_8812F)
#define BITS_MDIO_RDATA_8812F                                                  \
	(BIT_MASK_MDIO_RDATA_8812F << BIT_SHIFT_MDIO_RDATA_8812F)
#define BIT_CLEAR_MDIO_RDATA_8812F(x) ((x) & (~BITS_MDIO_RDATA_8812F))
#define BIT_GET_MDIO_RDATA_8812F(x)                                            \
	(((x) >> BIT_SHIFT_MDIO_RDATA_8812F) & BIT_MASK_MDIO_RDATA_8812F)
#define BIT_SET_MDIO_RDATA_8812F(x, v)                                         \
	(BIT_CLEAR_MDIO_RDATA_8812F(x) | BIT_MDIO_RDATA_8812F(v))

#define BIT_SHIFT_MDIO_WDATA_8812F 0
#define BIT_MASK_MDIO_WDATA_8812F 0xffff
#define BIT_MDIO_WDATA_8812F(x)                                                \
	(((x) & BIT_MASK_MDIO_WDATA_8812F) << BIT_SHIFT_MDIO_WDATA_8812F)
#define BITS_MDIO_WDATA_8812F                                                  \
	(BIT_MASK_MDIO_WDATA_8812F << BIT_SHIFT_MDIO_WDATA_8812F)
#define BIT_CLEAR_MDIO_WDATA_8812F(x) ((x) & (~BITS_MDIO_WDATA_8812F))
#define BIT_GET_MDIO_WDATA_8812F(x)                                            \
	(((x) >> BIT_SHIFT_MDIO_WDATA_8812F) & BIT_MASK_MDIO_WDATA_8812F)
#define BIT_SET_MDIO_WDATA_8812F(x, v)                                         \
	(BIT_CLEAR_MDIO_WDATA_8812F(x) | BIT_MDIO_WDATA_8812F(v))

/* 2 REG_PCIE_MIX_CFG_8812F */

#define BIT_SHIFT_MDIO_PHY_ADDR_8812F 24
#define BIT_MASK_MDIO_PHY_ADDR_8812F 0x1f
#define BIT_MDIO_PHY_ADDR_8812F(x)                                             \
	(((x) & BIT_MASK_MDIO_PHY_ADDR_8812F) << BIT_SHIFT_MDIO_PHY_ADDR_8812F)
#define BITS_MDIO_PHY_ADDR_8812F                                               \
	(BIT_MASK_MDIO_PHY_ADDR_8812F << BIT_SHIFT_MDIO_PHY_ADDR_8812F)
#define BIT_CLEAR_MDIO_PHY_ADDR_8812F(x) ((x) & (~BITS_MDIO_PHY_ADDR_8812F))
#define BIT_GET_MDIO_PHY_ADDR_8812F(x)                                         \
	(((x) >> BIT_SHIFT_MDIO_PHY_ADDR_8812F) & BIT_MASK_MDIO_PHY_ADDR_8812F)
#define BIT_SET_MDIO_PHY_ADDR_8812F(x, v)                                      \
	(BIT_CLEAR_MDIO_PHY_ADDR_8812F(x) | BIT_MDIO_PHY_ADDR_8812F(v))

#define BIT_SHIFT_WATCH_DOG_RECORD_V1_8812F 10
#define BIT_MASK_WATCH_DOG_RECORD_V1_8812F 0x3fff
#define BIT_WATCH_DOG_RECORD_V1_8812F(x)                                       \
	(((x) & BIT_MASK_WATCH_DOG_RECORD_V1_8812F)                            \
	 << BIT_SHIFT_WATCH_DOG_RECORD_V1_8812F)
#define BITS_WATCH_DOG_RECORD_V1_8812F                                         \
	(BIT_MASK_WATCH_DOG_RECORD_V1_8812F                                    \
	 << BIT_SHIFT_WATCH_DOG_RECORD_V1_8812F)
#define BIT_CLEAR_WATCH_DOG_RECORD_V1_8812F(x)                                 \
	((x) & (~BITS_WATCH_DOG_RECORD_V1_8812F))
#define BIT_GET_WATCH_DOG_RECORD_V1_8812F(x)                                   \
	(((x) >> BIT_SHIFT_WATCH_DOG_RECORD_V1_8812F) &                        \
	 BIT_MASK_WATCH_DOG_RECORD_V1_8812F)
#define BIT_SET_WATCH_DOG_RECORD_V1_8812F(x, v)                                \
	(BIT_CLEAR_WATCH_DOG_RECORD_V1_8812F(x) |                              \
	 BIT_WATCH_DOG_RECORD_V1_8812F(v))

#define BIT_R_IO_TIMEOUT_FLAG_V1_8812F BIT(9)
#define BIT_EN_WATCH_DOG_8812F BIT(8)
#define BIT_ECRC_EN_V1_8812F BIT(7)
#define BIT_MDIO_RFLAG_V1_8812F BIT(6)
#define BIT_MDIO_WFLAG_V1_8812F BIT(5)

#define BIT_SHIFT_MDIO_REG_ADDR_V1_8812F 0
#define BIT_MASK_MDIO_REG_ADDR_V1_8812F 0x1f
#define BIT_MDIO_REG_ADDR_V1_8812F(x)                                          \
	(((x) & BIT_MASK_MDIO_REG_ADDR_V1_8812F)                               \
	 << BIT_SHIFT_MDIO_REG_ADDR_V1_8812F)
#define BITS_MDIO_REG_ADDR_V1_8812F                                            \
	(BIT_MASK_MDIO_REG_ADDR_V1_8812F << BIT_SHIFT_MDIO_REG_ADDR_V1_8812F)
#define BIT_CLEAR_MDIO_REG_ADDR_V1_8812F(x)                                    \
	((x) & (~BITS_MDIO_REG_ADDR_V1_8812F))
#define BIT_GET_MDIO_REG_ADDR_V1_8812F(x)                                      \
	(((x) >> BIT_SHIFT_MDIO_REG_ADDR_V1_8812F) &                           \
	 BIT_MASK_MDIO_REG_ADDR_V1_8812F)
#define BIT_SET_MDIO_REG_ADDR_V1_8812F(x, v)                                   \
	(BIT_CLEAR_MDIO_REG_ADDR_V1_8812F(x) | BIT_MDIO_REG_ADDR_V1_8812F(v))

/* 2 REG_HCI_MIX_CFG_8812F */

#define BIT_SHIFT_WATCH_DOG_TIMER_8812F 28
#define BIT_MASK_WATCH_DOG_TIMER_8812F 0xf
#define BIT_WATCH_DOG_TIMER_8812F(x)                                           \
	(((x) & BIT_MASK_WATCH_DOG_TIMER_8812F)                                \
	 << BIT_SHIFT_WATCH_DOG_TIMER_8812F)
#define BITS_WATCH_DOG_TIMER_8812F                                             \
	(BIT_MASK_WATCH_DOG_TIMER_8812F << BIT_SHIFT_WATCH_DOG_TIMER_8812F)
#define BIT_CLEAR_WATCH_DOG_TIMER_8812F(x) ((x) & (~BITS_WATCH_DOG_TIMER_8812F))
#define BIT_GET_WATCH_DOG_TIMER_8812F(x)                                       \
	(((x) >> BIT_SHIFT_WATCH_DOG_TIMER_8812F) &                            \
	 BIT_MASK_WATCH_DOG_TIMER_8812F)
#define BIT_SET_WATCH_DOG_TIMER_8812F(x, v)                                    \
	(BIT_CLEAR_WATCH_DOG_TIMER_8812F(x) | BIT_WATCH_DOG_TIMER_8812F(v))

#define BIT_EN_ALIGN_MTU_8812F BIT(23)

#define BIT_SHIFT_LATENCY_CONTROL_8812F 21
#define BIT_MASK_LATENCY_CONTROL_8812F 0x3
#define BIT_LATENCY_CONTROL_8812F(x)                                           \
	(((x) & BIT_MASK_LATENCY_CONTROL_8812F)                                \
	 << BIT_SHIFT_LATENCY_CONTROL_8812F)
#define BITS_LATENCY_CONTROL_8812F                                             \
	(BIT_MASK_LATENCY_CONTROL_8812F << BIT_SHIFT_LATENCY_CONTROL_8812F)
#define BIT_CLEAR_LATENCY_CONTROL_8812F(x) ((x) & (~BITS_LATENCY_CONTROL_8812F))
#define BIT_GET_LATENCY_CONTROL_8812F(x)                                       \
	(((x) >> BIT_SHIFT_LATENCY_CONTROL_8812F) &                            \
	 BIT_MASK_LATENCY_CONTROL_8812F)
#define BIT_SET_LATENCY_CONTROL_8812F(x, v)                                    \
	(BIT_CLEAR_LATENCY_CONTROL_8812F(x) | BIT_LATENCY_CONTROL_8812F(v))

#define BIT_HOST_GEN2_SUPPORT_8812F BIT(20)

#define BIT_SHIFT_TXDMA_ERR_FLAG_V1_8812F 15
#define BIT_MASK_TXDMA_ERR_FLAG_V1_8812F 0x1f
#define BIT_TXDMA_ERR_FLAG_V1_8812F(x)                                         \
	(((x) & BIT_MASK_TXDMA_ERR_FLAG_V1_8812F)                              \
	 << BIT_SHIFT_TXDMA_ERR_FLAG_V1_8812F)
#define BITS_TXDMA_ERR_FLAG_V1_8812F                                           \
	(BIT_MASK_TXDMA_ERR_FLAG_V1_8812F << BIT_SHIFT_TXDMA_ERR_FLAG_V1_8812F)
#define BIT_CLEAR_TXDMA_ERR_FLAG_V1_8812F(x)                                   \
	((x) & (~BITS_TXDMA_ERR_FLAG_V1_8812F))
#define BIT_GET_TXDMA_ERR_FLAG_V1_8812F(x)                                     \
	(((x) >> BIT_SHIFT_TXDMA_ERR_FLAG_V1_8812F) &                          \
	 BIT_MASK_TXDMA_ERR_FLAG_V1_8812F)
#define BIT_SET_TXDMA_ERR_FLAG_V1_8812F(x, v)                                  \
	(BIT_CLEAR_TXDMA_ERR_FLAG_V1_8812F(x) | BIT_TXDMA_ERR_FLAG_V1_8812F(v))

#define BIT_EPHY_RX50_EN_8812F BIT(11)

#define BIT_SHIFT_MSI_TIMEOUT_ID_V1_8812F 8
#define BIT_MASK_MSI_TIMEOUT_ID_V1_8812F 0x7
#define BIT_MSI_TIMEOUT_ID_V1_8812F(x)                                         \
	(((x) & BIT_MASK_MSI_TIMEOUT_ID_V1_8812F)                              \
	 << BIT_SHIFT_MSI_TIMEOUT_ID_V1_8812F)
#define BITS_MSI_TIMEOUT_ID_V1_8812F                                           \
	(BIT_MASK_MSI_TIMEOUT_ID_V1_8812F << BIT_SHIFT_MSI_TIMEOUT_ID_V1_8812F)
#define BIT_CLEAR_MSI_TIMEOUT_ID_V1_8812F(x)                                   \
	((x) & (~BITS_MSI_TIMEOUT_ID_V1_8812F))
#define BIT_GET_MSI_TIMEOUT_ID_V1_8812F(x)                                     \
	(((x) >> BIT_SHIFT_MSI_TIMEOUT_ID_V1_8812F) &                          \
	 BIT_MASK_MSI_TIMEOUT_ID_V1_8812F)
#define BIT_SET_MSI_TIMEOUT_ID_V1_8812F(x, v)                                  \
	(BIT_CLEAR_MSI_TIMEOUT_ID_V1_8812F(x) | BIT_MSI_TIMEOUT_ID_V1_8812F(v))

#define BIT_RADDR_RD_8812F BIT(7)
#define BIT_L1OFF_PWR_OFF_EN_8812F BIT(6)
#define BIT_L0S_LINK_OFF_8812F BIT(4)
#define BIT_ACT_LINK_OFF_8812F BIT(3)
#define BIT_EN_SLOW_MAC_TX_8812F BIT(2)
#define BIT_EN_SLOW_MAC_RX_8812F BIT(1)
#define BIT_EN_SLOW_MAC_HW_8812F BIT(0)

/* 2 REG_STC_INT_CS_8812F(PCIE STATE CHANGE INTERRUPT CONTROL AND STATUS) */
#define BIT_STC_INT_EN_8812F BIT(31)

#define BIT_SHIFT_STC_INT_FLAG_8812F 16
#define BIT_MASK_STC_INT_FLAG_8812F 0xff
#define BIT_STC_INT_FLAG_8812F(x)                                              \
	(((x) & BIT_MASK_STC_INT_FLAG_8812F) << BIT_SHIFT_STC_INT_FLAG_8812F)
#define BITS_STC_INT_FLAG_8812F                                                \
	(BIT_MASK_STC_INT_FLAG_8812F << BIT_SHIFT_STC_INT_FLAG_8812F)
#define BIT_CLEAR_STC_INT_FLAG_8812F(x) ((x) & (~BITS_STC_INT_FLAG_8812F))
#define BIT_GET_STC_INT_FLAG_8812F(x)                                          \
	(((x) >> BIT_SHIFT_STC_INT_FLAG_8812F) & BIT_MASK_STC_INT_FLAG_8812F)
#define BIT_SET_STC_INT_FLAG_8812F(x, v)                                       \
	(BIT_CLEAR_STC_INT_FLAG_8812F(x) | BIT_STC_INT_FLAG_8812F(v))

#define BIT_SHIFT_STC_INT_IDX_8812F 8
#define BIT_MASK_STC_INT_IDX_8812F 0x7
#define BIT_STC_INT_IDX_8812F(x)                                               \
	(((x) & BIT_MASK_STC_INT_IDX_8812F) << BIT_SHIFT_STC_INT_IDX_8812F)
#define BITS_STC_INT_IDX_8812F                                                 \
	(BIT_MASK_STC_INT_IDX_8812F << BIT_SHIFT_STC_INT_IDX_8812F)
#define BIT_CLEAR_STC_INT_IDX_8812F(x) ((x) & (~BITS_STC_INT_IDX_8812F))
#define BIT_GET_STC_INT_IDX_8812F(x)                                           \
	(((x) >> BIT_SHIFT_STC_INT_IDX_8812F) & BIT_MASK_STC_INT_IDX_8812F)
#define BIT_SET_STC_INT_IDX_8812F(x, v)                                        \
	(BIT_CLEAR_STC_INT_IDX_8812F(x) | BIT_STC_INT_IDX_8812F(v))

#define BIT_SHIFT_STC_INT_REALTIME_CS_8812F 0
#define BIT_MASK_STC_INT_REALTIME_CS_8812F 0x3f
#define BIT_STC_INT_REALTIME_CS_8812F(x)                                       \
	(((x) & BIT_MASK_STC_INT_REALTIME_CS_8812F)                            \
	 << BIT_SHIFT_STC_INT_REALTIME_CS_8812F)
#define BITS_STC_INT_REALTIME_CS_8812F                                         \
	(BIT_MASK_STC_INT_REALTIME_CS_8812F                                    \
	 << BIT_SHIFT_STC_INT_REALTIME_CS_8812F)
#define BIT_CLEAR_STC_INT_REALTIME_CS_8812F(x)                                 \
	((x) & (~BITS_STC_INT_REALTIME_CS_8812F))
#define BIT_GET_STC_INT_REALTIME_CS_8812F(x)                                   \
	(((x) >> BIT_SHIFT_STC_INT_REALTIME_CS_8812F) &                        \
	 BIT_MASK_STC_INT_REALTIME_CS_8812F)
#define BIT_SET_STC_INT_REALTIME_CS_8812F(x, v)                                \
	(BIT_CLEAR_STC_INT_REALTIME_CS_8812F(x) |                              \
	 BIT_STC_INT_REALTIME_CS_8812F(v))

#define BIT_STC_INT_GRP_EN_8812F BIT(31)

#define BIT_SHIFT_STC_INT_EXPECT_LS_8812F 8
#define BIT_MASK_STC_INT_EXPECT_LS_8812F 0x3f
#define BIT_STC_INT_EXPECT_LS_8812F(x)                                         \
	(((x) & BIT_MASK_STC_INT_EXPECT_LS_8812F)                              \
	 << BIT_SHIFT_STC_INT_EXPECT_LS_8812F)
#define BITS_STC_INT_EXPECT_LS_8812F                                           \
	(BIT_MASK_STC_INT_EXPECT_LS_8812F << BIT_SHIFT_STC_INT_EXPECT_LS_8812F)
#define BIT_CLEAR_STC_INT_EXPECT_LS_8812F(x)                                   \
	((x) & (~BITS_STC_INT_EXPECT_LS_8812F))
#define BIT_GET_STC_INT_EXPECT_LS_8812F(x)                                     \
	(((x) >> BIT_SHIFT_STC_INT_EXPECT_LS_8812F) &                          \
	 BIT_MASK_STC_INT_EXPECT_LS_8812F)
#define BIT_SET_STC_INT_EXPECT_LS_8812F(x, v)                                  \
	(BIT_CLEAR_STC_INT_EXPECT_LS_8812F(x) | BIT_STC_INT_EXPECT_LS_8812F(v))

#define BIT_SHIFT_STC_INT_EXPECT_CS_8812F 0
#define BIT_MASK_STC_INT_EXPECT_CS_8812F 0x3f
#define BIT_STC_INT_EXPECT_CS_8812F(x)                                         \
	(((x) & BIT_MASK_STC_INT_EXPECT_CS_8812F)                              \
	 << BIT_SHIFT_STC_INT_EXPECT_CS_8812F)
#define BITS_STC_INT_EXPECT_CS_8812F                                           \
	(BIT_MASK_STC_INT_EXPECT_CS_8812F << BIT_SHIFT_STC_INT_EXPECT_CS_8812F)
#define BIT_CLEAR_STC_INT_EXPECT_CS_8812F(x)                                   \
	((x) & (~BITS_STC_INT_EXPECT_CS_8812F))
#define BIT_GET_STC_INT_EXPECT_CS_8812F(x)                                     \
	(((x) >> BIT_SHIFT_STC_INT_EXPECT_CS_8812F) &                          \
	 BIT_MASK_STC_INT_EXPECT_CS_8812F)
#define BIT_SET_STC_INT_EXPECT_CS_8812F(x, v)                                  \
	(BIT_CLEAR_STC_INT_EXPECT_CS_8812F(x) | BIT_STC_INT_EXPECT_CS_8812F(v))

/* 2 REG_H2CQ_TXBD_DESA_8812F */

#define BIT_SHIFT_H2CQ_TXBD_DESA_8812F 0
#define BIT_MASK_H2CQ_TXBD_DESA_8812F 0xffffffffffffffffL
#define BIT_H2CQ_TXBD_DESA_8812F(x)                                            \
	(((x) & BIT_MASK_H2CQ_TXBD_DESA_8812F)                                 \
	 << BIT_SHIFT_H2CQ_TXBD_DESA_8812F)
#define BITS_H2CQ_TXBD_DESA_8812F                                              \
	(BIT_MASK_H2CQ_TXBD_DESA_8812F << BIT_SHIFT_H2CQ_TXBD_DESA_8812F)
#define BIT_CLEAR_H2CQ_TXBD_DESA_8812F(x) ((x) & (~BITS_H2CQ_TXBD_DESA_8812F))
#define BIT_GET_H2CQ_TXBD_DESA_8812F(x)                                        \
	(((x) >> BIT_SHIFT_H2CQ_TXBD_DESA_8812F) &                             \
	 BIT_MASK_H2CQ_TXBD_DESA_8812F)
#define BIT_SET_H2CQ_TXBD_DESA_8812F(x, v)                                     \
	(BIT_CLEAR_H2CQ_TXBD_DESA_8812F(x) | BIT_H2CQ_TXBD_DESA_8812F(v))

/* 2 REG_H2CQ_TXBD_NUM_8812F */
#define BIT_PCIE_H2CQ_FLAG_8812F BIT(14)

#define BIT_SHIFT_H2CQ_DESC_MODE_8812F 12
#define BIT_MASK_H2CQ_DESC_MODE_8812F 0x3
#define BIT_H2CQ_DESC_MODE_8812F(x)                                            \
	(((x) & BIT_MASK_H2CQ_DESC_MODE_8812F)                                 \
	 << BIT_SHIFT_H2CQ_DESC_MODE_8812F)
#define BITS_H2CQ_DESC_MODE_8812F                                              \
	(BIT_MASK_H2CQ_DESC_MODE_8812F << BIT_SHIFT_H2CQ_DESC_MODE_8812F)
#define BIT_CLEAR_H2CQ_DESC_MODE_8812F(x) ((x) & (~BITS_H2CQ_DESC_MODE_8812F))
#define BIT_GET_H2CQ_DESC_MODE_8812F(x)                                        \
	(((x) >> BIT_SHIFT_H2CQ_DESC_MODE_8812F) &                             \
	 BIT_MASK_H2CQ_DESC_MODE_8812F)
#define BIT_SET_H2CQ_DESC_MODE_8812F(x, v)                                     \
	(BIT_CLEAR_H2CQ_DESC_MODE_8812F(x) | BIT_H2CQ_DESC_MODE_8812F(v))

#define BIT_SHIFT_H2CQ_DESC_NUM_8812F 0
#define BIT_MASK_H2CQ_DESC_NUM_8812F 0xfff
#define BIT_H2CQ_DESC_NUM_8812F(x)                                             \
	(((x) & BIT_MASK_H2CQ_DESC_NUM_8812F) << BIT_SHIFT_H2CQ_DESC_NUM_8812F)
#define BITS_H2CQ_DESC_NUM_8812F                                               \
	(BIT_MASK_H2CQ_DESC_NUM_8812F << BIT_SHIFT_H2CQ_DESC_NUM_8812F)
#define BIT_CLEAR_H2CQ_DESC_NUM_8812F(x) ((x) & (~BITS_H2CQ_DESC_NUM_8812F))
#define BIT_GET_H2CQ_DESC_NUM_8812F(x)                                         \
	(((x) >> BIT_SHIFT_H2CQ_DESC_NUM_8812F) & BIT_MASK_H2CQ_DESC_NUM_8812F)
#define BIT_SET_H2CQ_DESC_NUM_8812F(x, v)                                      \
	(BIT_CLEAR_H2CQ_DESC_NUM_8812F(x) | BIT_H2CQ_DESC_NUM_8812F(v))

/* 2 REG_H2CQ_TXBD_IDX_8812F */

#define BIT_SHIFT_H2CQ_HW_IDX_8812F 16
#define BIT_MASK_H2CQ_HW_IDX_8812F 0xfff
#define BIT_H2CQ_HW_IDX_8812F(x)                                               \
	(((x) & BIT_MASK_H2CQ_HW_IDX_8812F) << BIT_SHIFT_H2CQ_HW_IDX_8812F)
#define BITS_H2CQ_HW_IDX_8812F                                                 \
	(BIT_MASK_H2CQ_HW_IDX_8812F << BIT_SHIFT_H2CQ_HW_IDX_8812F)
#define BIT_CLEAR_H2CQ_HW_IDX_8812F(x) ((x) & (~BITS_H2CQ_HW_IDX_8812F))
#define BIT_GET_H2CQ_HW_IDX_8812F(x)                                           \
	(((x) >> BIT_SHIFT_H2CQ_HW_IDX_8812F) & BIT_MASK_H2CQ_HW_IDX_8812F)
#define BIT_SET_H2CQ_HW_IDX_8812F(x, v)                                        \
	(BIT_CLEAR_H2CQ_HW_IDX_8812F(x) | BIT_H2CQ_HW_IDX_8812F(v))

#define BIT_SHIFT_H2CQ_HOST_IDX_8812F 0
#define BIT_MASK_H2CQ_HOST_IDX_8812F 0xfff
#define BIT_H2CQ_HOST_IDX_8812F(x)                                             \
	(((x) & BIT_MASK_H2CQ_HOST_IDX_8812F) << BIT_SHIFT_H2CQ_HOST_IDX_8812F)
#define BITS_H2CQ_HOST_IDX_8812F                                               \
	(BIT_MASK_H2CQ_HOST_IDX_8812F << BIT_SHIFT_H2CQ_HOST_IDX_8812F)
#define BIT_CLEAR_H2CQ_HOST_IDX_8812F(x) ((x) & (~BITS_H2CQ_HOST_IDX_8812F))
#define BIT_GET_H2CQ_HOST_IDX_8812F(x)                                         \
	(((x) >> BIT_SHIFT_H2CQ_HOST_IDX_8812F) & BIT_MASK_H2CQ_HOST_IDX_8812F)
#define BIT_SET_H2CQ_HOST_IDX_8812F(x, v)                                      \
	(BIT_CLEAR_H2CQ_HOST_IDX_8812F(x) | BIT_H2CQ_HOST_IDX_8812F(v))

/* 2 REG_H2CQ_CSR_8812F[31:0] (H2CQ CONTROL AND STATUS) */
#define BIT_H2CQ_FULL_8812F BIT(31)
#define BIT_CLR_H2CQ_HOST_IDX_8812F BIT(16)
#define BIT_CLR_H2CQ_HW_IDX_8812F BIT(8)
#define BIT_STOP_H2CQ_8812F BIT(0)

/* 2 REG_CHANGE_PCIE_SPEED_8812F */

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_RXDMA_ERR_CNT_8812F 8
#define BIT_MASK_RXDMA_ERR_CNT_8812F 0xff
#define BIT_RXDMA_ERR_CNT_8812F(x)                                             \
	(((x) & BIT_MASK_RXDMA_ERR_CNT_8812F) << BIT_SHIFT_RXDMA_ERR_CNT_8812F)
#define BITS_RXDMA_ERR_CNT_8812F                                               \
	(BIT_MASK_RXDMA_ERR_CNT_8812F << BIT_SHIFT_RXDMA_ERR_CNT_8812F)
#define BIT_CLEAR_RXDMA_ERR_CNT_8812F(x) ((x) & (~BITS_RXDMA_ERR_CNT_8812F))
#define BIT_GET_RXDMA_ERR_CNT_8812F(x)                                         \
	(((x) >> BIT_SHIFT_RXDMA_ERR_CNT_8812F) & BIT_MASK_RXDMA_ERR_CNT_8812F)
#define BIT_SET_RXDMA_ERR_CNT_8812F(x, v)                                      \
	(BIT_CLEAR_RXDMA_ERR_CNT_8812F(x) | BIT_RXDMA_ERR_CNT_8812F(v))

#define BIT_TXDMA_ERR_HANDLE_REQ_8812F BIT(7)
#define BIT_TXDMA_ERROR_PS_8812F BIT(6)
#define BIT_EN_TXDMA_STUCK_ERR_HANDLE_8812F BIT(5)
#define BIT_EN_TXDMA_RTN_ERR_HANDLE_8812F BIT(4)
#define BIT_RXDMA_ERR_HANDLE_REQ_8812F BIT(3)
#define BIT_RXDMA_ERROR_PS_8812F BIT(2)
#define BIT_EN_RXDMA_STUCK_ERR_HANDLE_8812F BIT(1)
#define BIT_EN_RXDMA_RTN_ERR_HANDLE_8812F BIT(0)

/* 2 REG_DEBUG_STATE1_8812F */

#define BIT_SHIFT_DEBUG_STATE1_8812F 0
#define BIT_MASK_DEBUG_STATE1_8812F 0xffffffffL
#define BIT_DEBUG_STATE1_8812F(x)                                              \
	(((x) & BIT_MASK_DEBUG_STATE1_8812F) << BIT_SHIFT_DEBUG_STATE1_8812F)
#define BITS_DEBUG_STATE1_8812F                                                \
	(BIT_MASK_DEBUG_STATE1_8812F << BIT_SHIFT_DEBUG_STATE1_8812F)
#define BIT_CLEAR_DEBUG_STATE1_8812F(x) ((x) & (~BITS_DEBUG_STATE1_8812F))
#define BIT_GET_DEBUG_STATE1_8812F(x)                                          \
	(((x) >> BIT_SHIFT_DEBUG_STATE1_8812F) & BIT_MASK_DEBUG_STATE1_8812F)
#define BIT_SET_DEBUG_STATE1_8812F(x, v)                                       \
	(BIT_CLEAR_DEBUG_STATE1_8812F(x) | BIT_DEBUG_STATE1_8812F(v))

/* 2 REG_DEBUG_STATE2_8812F */

#define BIT_SHIFT_DEBUG_STATE2_8812F 0
#define BIT_MASK_DEBUG_STATE2_8812F 0xffffffffL
#define BIT_DEBUG_STATE2_8812F(x)                                              \
	(((x) & BIT_MASK_DEBUG_STATE2_8812F) << BIT_SHIFT_DEBUG_STATE2_8812F)
#define BITS_DEBUG_STATE2_8812F                                                \
	(BIT_MASK_DEBUG_STATE2_8812F << BIT_SHIFT_DEBUG_STATE2_8812F)
#define BIT_CLEAR_DEBUG_STATE2_8812F(x) ((x) & (~BITS_DEBUG_STATE2_8812F))
#define BIT_GET_DEBUG_STATE2_8812F(x)                                          \
	(((x) >> BIT_SHIFT_DEBUG_STATE2_8812F) & BIT_MASK_DEBUG_STATE2_8812F)
#define BIT_SET_DEBUG_STATE2_8812F(x, v)                                       \
	(BIT_CLEAR_DEBUG_STATE2_8812F(x) | BIT_DEBUG_STATE2_8812F(v))

/* 2 REG_DEBUG_STATE3_8812F */

#define BIT_SHIFT_DEBUG_STATE3_8812F 0
#define BIT_MASK_DEBUG_STATE3_8812F 0xffffffffL
#define BIT_DEBUG_STATE3_8812F(x)                                              \
	(((x) & BIT_MASK_DEBUG_STATE3_8812F) << BIT_SHIFT_DEBUG_STATE3_8812F)
#define BITS_DEBUG_STATE3_8812F                                                \
	(BIT_MASK_DEBUG_STATE3_8812F << BIT_SHIFT_DEBUG_STATE3_8812F)
#define BIT_CLEAR_DEBUG_STATE3_8812F(x) ((x) & (~BITS_DEBUG_STATE3_8812F))
#define BIT_GET_DEBUG_STATE3_8812F(x)                                          \
	(((x) >> BIT_SHIFT_DEBUG_STATE3_8812F) & BIT_MASK_DEBUG_STATE3_8812F)
#define BIT_SET_DEBUG_STATE3_8812F(x, v)                                       \
	(BIT_CLEAR_DEBUG_STATE3_8812F(x) | BIT_DEBUG_STATE3_8812F(v))

/* 2 REG_CHNL_DMA_CFG_V1_8812F */
#define BIT_TXHCI_EN_V1_8812F BIT(26)
#define BIT_TXHCI_IDLE_V1_8812F BIT(25)
#define BIT_DMA_PRI_EN_V1_8812F BIT(24)

/* 2 REG_PCIE_HISR0_V1_8812F */
#define BIT_PSTIMER_2_8812F BIT(31)
#define BIT_PSTIMER_1_8812F BIT(30)
#define BIT_PSTIMER_0_8812F BIT(29)
#define BIT_GTINT4_8812F BIT(28)
#define BIT_GTINT3_8812F BIT(27)
#define BIT_TXBCN0ERR_8812F BIT(26)
#define BIT_TXBCN0OK_8812F BIT(25)
#define BIT_TSF_BIT32_TOGGLE_8812F BIT(24)
#define BIT_TXDMA_START_INT_8812F BIT(23)
#define BIT_TXDMA_STOP_INT_8812F BIT(22)
#define BIT_HISR7_IND_8812F BIT(21)
#define BIT_BCNDMAINT0_8812F BIT(20)
#define BIT_HISR6_IND_8812F BIT(19)
#define BIT_HISR5_IND_8812F BIT(18)
#define BIT_HISR4_IND_8812F BIT(17)
#define BIT_BCNDERR0_8812F BIT(16)
#define BIT_HSISR_IND_ON_INT_8812F BIT(15)
#define BIT_HISR3_IND_8812F BIT(14)
#define BIT_HISR2_IND_8812F BIT(13)
#define BIT_HISR1_IND_8812F BIT(11)
#define BIT_C2HCMD_8812F BIT(10)
#define BIT_CPWM2_8812F BIT(9)
#define BIT_CPWM_8812F BIT(8)
#define BIT_TXDMAOK_CHANNEL15_8812F BIT(7)
#define BIT_TXDMAOK_CHANNEL14_8812F BIT(6)
#define BIT_TXDMAOK_CHANNEL3_8812F BIT(5)
#define BIT_TXDMAOK_CHANNEL2_8812F BIT(4)
#define BIT_TXDMAOK_CHANNEL1_8812F BIT(3)
#define BIT_TXDMAOK_CHANNEL0_8812F BIT(2)
#define BIT_RDU_8812F BIT(1)
#define BIT_RXOK_8812F BIT(0)

/* 2 REG_PCIE_HISR1_V1_8812F */
#define BIT_PRE_TX_ERR_INT_8812F BIT(31)
#define BIT_TXFIFO_TH_INT_8812F BIT(30)
#define BIT_BTON_STS_UPDATE_INT_8812F BIT(29)
#define BIT_BCNDMAINT7_8812F BIT(27)
#define BIT_BCNDMAINT6_8812F BIT(26)
#define BIT_BCNDMAINT5_8812F BIT(25)
#define BIT_BCNDMAINT4_8812F BIT(24)
#define BIT_BCNDMAINT3_8812F BIT(23)
#define BIT_BCNDMAINT2_8812F BIT(22)
#define BIT_BCNDMAINT1_8812F BIT(21)
#define BIT_BCNDERR7_8812F BIT(20)
#define BIT_BCNDERR6_8812F BIT(19)
#define BIT_BCNDERR5_8812F BIT(18)
#define BIT_BCNDERR4_8812F BIT(17)
#define BIT_BCNDERR3_8812F BIT(16)
#define BIT_BCNDERR2_8812F BIT(15)
#define BIT_BCNDERR1_8812F BIT(14)
#define BIT_ATIMEND_8812F BIT(12)
#define BIT_TXERR_INT_8812F BIT(11)
#define BIT_RXERR_INT_8812F BIT(10)
#define BIT_TXFOVW_8812F BIT(9)
#define BIT_FOVW_8812F BIT(8)
#define BIT_CPU_MGQ_EARLY_INT_8812F BIT(6)
#define BIT_CPU_MGQ_TXDONE_8812F BIT(5)
#define BIT_PSTIMER_5_8812F BIT(4)
#define BIT_PSTIMER_4_8812F BIT(3)
#define BIT_PSTIMER_3_8812F BIT(2)
#define BIT_CPUMGQ_TX_TIMER_8812F BIT(1)
#define BIT_BB_STOPRX_INT_8812F BIT(0)

/* 2 REG_PCIE_HISR2_V1_8812F */
#define BIT_BCNDMAINT_P4_8812F BIT(31)
#define BIT_BCNDMAINT_P3_8812F BIT(30)
#define BIT_BCNDMAINT_P2_8812F BIT(29)
#define BIT_BCNDMAINT_P1_8812F BIT(28)
#define BIT_SCH_PHY_TXOP_SIFS_INT_8812F BIT(23)
#define BIT_ATIMEND7_8812F BIT(22)
#define BIT_ATIMEND6_8812F BIT(21)
#define BIT_ATIMEND5_8812F BIT(20)
#define BIT_ATIMEND4_8812F BIT(19)
#define BIT_ATIMEND3_8812F BIT(18)
#define BIT_ATIMEND2_8812F BIT(17)
#define BIT_ATIMEND1_8812F BIT(16)
#define BIT_TXBCN7OK_8812F BIT(14)
#define BIT_TXBCN6OK_8812F BIT(13)
#define BIT_TXBCN5OK_8812F BIT(12)
#define BIT_TXBCN4OK_8812F BIT(11)
#define BIT_TXBCN3OK_8812F BIT(10)
#define BIT_TXBCN2OK_8812F BIT(9)
#define BIT_TXBCN1OK_8812F BIT(8)
#define BIT_TXBCN7ERR_8812F BIT(6)
#define BIT_TXBCN6ERR_8812F BIT(5)
#define BIT_TXBCN5ERR_8812F BIT(4)
#define BIT_TXBCN4ERR_8812F BIT(3)
#define BIT_TXBCN3ERR_8812F BIT(2)
#define BIT_TXBCN2ERR_8812F BIT(1)
#define BIT_TXBCN1ERR_8812F BIT(0)

/* 2 REG_PCIE_HISR3_V1_8812F */
#define BIT_GTINT12_8812F BIT(24)
#define BIT_GTINT11_8812F BIT(23)
#define BIT_GTINT10_8812F BIT(22)
#define BIT_GTINT9_8812F BIT(21)
#define BIT_RX_DESC_BUF_FULL_8812F BIT(20)
#define BIT_CPHY_LDO_OCP_DET_INT_8812F BIT(19)
#define BIT_WDT_PLATFORM_INT_8812F BIT(18)
#define BIT_WDT_CPU_INT_8812F BIT(17)
#define BIT_SETH2CDOK_8812F BIT(16)
#define BIT_H2C_CMD_FULL_8812F BIT(15)
#define BIT_PKT_TRANS_ERR_8812F BIT(14)
#define BIT_TXSHORTCUT_TXDESUPDATEOK_8812F BIT(13)
#define BIT_TXSHORTCUT_BKUPDATEOK_8812F BIT(12)
#define BIT_TXSHORTCUT_BEUPDATEOK_8812F BIT(11)
#define BIT_TXSHORTCUT_VIUPDATEOK_8812F BIT(10)
#define BIT_TXSHORTCUT_VOUPDATEOK_8812F BIT(9)
#define BIT_SEARCH_FAIL_8812F BIT(8)
#define BIT_PWR_INT_127TO96_8812F BIT(7)
#define BIT_PWR_INT_95TO64_8812F BIT(6)
#define BIT_PWR_INT_63TO32_8812F BIT(5)
#define BIT_PWR_INT_31TO0_8812F BIT(4)
#define BIT_RX_DMA_STUCK_8812F BIT(3)
#define BIT_TX_DMA_STUCK_8812F BIT(2)
#define BIT_DDMA0_LP_INT_8812F BIT(1)
#define BIT_DDMA0_HP_INT_8812F BIT(0)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_Q0_INFO_8812F */

#define BIT_SHIFT_QUEUEMACID_Q0_V1_8812F 25
#define BIT_MASK_QUEUEMACID_Q0_V1_8812F 0x7f
#define BIT_QUEUEMACID_Q0_V1_8812F(x)                                          \
	(((x) & BIT_MASK_QUEUEMACID_Q0_V1_8812F)                               \
	 << BIT_SHIFT_QUEUEMACID_Q0_V1_8812F)
#define BITS_QUEUEMACID_Q0_V1_8812F                                            \
	(BIT_MASK_QUEUEMACID_Q0_V1_8812F << BIT_SHIFT_QUEUEMACID_Q0_V1_8812F)
#define BIT_CLEAR_QUEUEMACID_Q0_V1_8812F(x)                                    \
	((x) & (~BITS_QUEUEMACID_Q0_V1_8812F))
#define BIT_GET_QUEUEMACID_Q0_V1_8812F(x)                                      \
	(((x) >> BIT_SHIFT_QUEUEMACID_Q0_V1_8812F) &                           \
	 BIT_MASK_QUEUEMACID_Q0_V1_8812F)
#define BIT_SET_QUEUEMACID_Q0_V1_8812F(x, v)                                   \
	(BIT_CLEAR_QUEUEMACID_Q0_V1_8812F(x) | BIT_QUEUEMACID_Q0_V1_8812F(v))

#define BIT_SHIFT_QUEUEAC_Q0_V1_8812F 23
#define BIT_MASK_QUEUEAC_Q0_V1_8812F 0x3
#define BIT_QUEUEAC_Q0_V1_8812F(x)                                             \
	(((x) & BIT_MASK_QUEUEAC_Q0_V1_8812F) << BIT_SHIFT_QUEUEAC_Q0_V1_8812F)
#define BITS_QUEUEAC_Q0_V1_8812F                                               \
	(BIT_MASK_QUEUEAC_Q0_V1_8812F << BIT_SHIFT_QUEUEAC_Q0_V1_8812F)
#define BIT_CLEAR_QUEUEAC_Q0_V1_8812F(x) ((x) & (~BITS_QUEUEAC_Q0_V1_8812F))
#define BIT_GET_QUEUEAC_Q0_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_QUEUEAC_Q0_V1_8812F) & BIT_MASK_QUEUEAC_Q0_V1_8812F)
#define BIT_SET_QUEUEAC_Q0_V1_8812F(x, v)                                      \
	(BIT_CLEAR_QUEUEAC_Q0_V1_8812F(x) | BIT_QUEUEAC_Q0_V1_8812F(v))

#define BIT_TIDEMPTY_Q0_V1_8812F BIT(22)

#define BIT_SHIFT_TAIL_PKT_Q0_V2_8812F 11
#define BIT_MASK_TAIL_PKT_Q0_V2_8812F 0x7ff
#define BIT_TAIL_PKT_Q0_V2_8812F(x)                                            \
	(((x) & BIT_MASK_TAIL_PKT_Q0_V2_8812F)                                 \
	 << BIT_SHIFT_TAIL_PKT_Q0_V2_8812F)
#define BITS_TAIL_PKT_Q0_V2_8812F                                              \
	(BIT_MASK_TAIL_PKT_Q0_V2_8812F << BIT_SHIFT_TAIL_PKT_Q0_V2_8812F)
#define BIT_CLEAR_TAIL_PKT_Q0_V2_8812F(x) ((x) & (~BITS_TAIL_PKT_Q0_V2_8812F))
#define BIT_GET_TAIL_PKT_Q0_V2_8812F(x)                                        \
	(((x) >> BIT_SHIFT_TAIL_PKT_Q0_V2_8812F) &                             \
	 BIT_MASK_TAIL_PKT_Q0_V2_8812F)
#define BIT_SET_TAIL_PKT_Q0_V2_8812F(x, v)                                     \
	(BIT_CLEAR_TAIL_PKT_Q0_V2_8812F(x) | BIT_TAIL_PKT_Q0_V2_8812F(v))

#define BIT_SHIFT_HEAD_PKT_Q0_V1_8812F 0
#define BIT_MASK_HEAD_PKT_Q0_V1_8812F 0x7ff
#define BIT_HEAD_PKT_Q0_V1_8812F(x)                                            \
	(((x) & BIT_MASK_HEAD_PKT_Q0_V1_8812F)                                 \
	 << BIT_SHIFT_HEAD_PKT_Q0_V1_8812F)
#define BITS_HEAD_PKT_Q0_V1_8812F                                              \
	(BIT_MASK_HEAD_PKT_Q0_V1_8812F << BIT_SHIFT_HEAD_PKT_Q0_V1_8812F)
#define BIT_CLEAR_HEAD_PKT_Q0_V1_8812F(x) ((x) & (~BITS_HEAD_PKT_Q0_V1_8812F))
#define BIT_GET_HEAD_PKT_Q0_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HEAD_PKT_Q0_V1_8812F) &                             \
	 BIT_MASK_HEAD_PKT_Q0_V1_8812F)
#define BIT_SET_HEAD_PKT_Q0_V1_8812F(x, v)                                     \
	(BIT_CLEAR_HEAD_PKT_Q0_V1_8812F(x) | BIT_HEAD_PKT_Q0_V1_8812F(v))

/* 2 REG_Q1_INFO_8812F */

#define BIT_SHIFT_QUEUEMACID_Q1_V1_8812F 25
#define BIT_MASK_QUEUEMACID_Q1_V1_8812F 0x7f
#define BIT_QUEUEMACID_Q1_V1_8812F(x)                                          \
	(((x) & BIT_MASK_QUEUEMACID_Q1_V1_8812F)                               \
	 << BIT_SHIFT_QUEUEMACID_Q1_V1_8812F)
#define BITS_QUEUEMACID_Q1_V1_8812F                                            \
	(BIT_MASK_QUEUEMACID_Q1_V1_8812F << BIT_SHIFT_QUEUEMACID_Q1_V1_8812F)
#define BIT_CLEAR_QUEUEMACID_Q1_V1_8812F(x)                                    \
	((x) & (~BITS_QUEUEMACID_Q1_V1_8812F))
#define BIT_GET_QUEUEMACID_Q1_V1_8812F(x)                                      \
	(((x) >> BIT_SHIFT_QUEUEMACID_Q1_V1_8812F) &                           \
	 BIT_MASK_QUEUEMACID_Q1_V1_8812F)
#define BIT_SET_QUEUEMACID_Q1_V1_8812F(x, v)                                   \
	(BIT_CLEAR_QUEUEMACID_Q1_V1_8812F(x) | BIT_QUEUEMACID_Q1_V1_8812F(v))

#define BIT_SHIFT_QUEUEAC_Q1_V1_8812F 23
#define BIT_MASK_QUEUEAC_Q1_V1_8812F 0x3
#define BIT_QUEUEAC_Q1_V1_8812F(x)                                             \
	(((x) & BIT_MASK_QUEUEAC_Q1_V1_8812F) << BIT_SHIFT_QUEUEAC_Q1_V1_8812F)
#define BITS_QUEUEAC_Q1_V1_8812F                                               \
	(BIT_MASK_QUEUEAC_Q1_V1_8812F << BIT_SHIFT_QUEUEAC_Q1_V1_8812F)
#define BIT_CLEAR_QUEUEAC_Q1_V1_8812F(x) ((x) & (~BITS_QUEUEAC_Q1_V1_8812F))
#define BIT_GET_QUEUEAC_Q1_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_QUEUEAC_Q1_V1_8812F) & BIT_MASK_QUEUEAC_Q1_V1_8812F)
#define BIT_SET_QUEUEAC_Q1_V1_8812F(x, v)                                      \
	(BIT_CLEAR_QUEUEAC_Q1_V1_8812F(x) | BIT_QUEUEAC_Q1_V1_8812F(v))

#define BIT_TIDEMPTY_Q1_V1_8812F BIT(22)

#define BIT_SHIFT_TAIL_PKT_Q1_V2_8812F 11
#define BIT_MASK_TAIL_PKT_Q1_V2_8812F 0x7ff
#define BIT_TAIL_PKT_Q1_V2_8812F(x)                                            \
	(((x) & BIT_MASK_TAIL_PKT_Q1_V2_8812F)                                 \
	 << BIT_SHIFT_TAIL_PKT_Q1_V2_8812F)
#define BITS_TAIL_PKT_Q1_V2_8812F                                              \
	(BIT_MASK_TAIL_PKT_Q1_V2_8812F << BIT_SHIFT_TAIL_PKT_Q1_V2_8812F)
#define BIT_CLEAR_TAIL_PKT_Q1_V2_8812F(x) ((x) & (~BITS_TAIL_PKT_Q1_V2_8812F))
#define BIT_GET_TAIL_PKT_Q1_V2_8812F(x)                                        \
	(((x) >> BIT_SHIFT_TAIL_PKT_Q1_V2_8812F) &                             \
	 BIT_MASK_TAIL_PKT_Q1_V2_8812F)
#define BIT_SET_TAIL_PKT_Q1_V2_8812F(x, v)                                     \
	(BIT_CLEAR_TAIL_PKT_Q1_V2_8812F(x) | BIT_TAIL_PKT_Q1_V2_8812F(v))

#define BIT_SHIFT_HEAD_PKT_Q1_V1_8812F 0
#define BIT_MASK_HEAD_PKT_Q1_V1_8812F 0x7ff
#define BIT_HEAD_PKT_Q1_V1_8812F(x)                                            \
	(((x) & BIT_MASK_HEAD_PKT_Q1_V1_8812F)                                 \
	 << BIT_SHIFT_HEAD_PKT_Q1_V1_8812F)
#define BITS_HEAD_PKT_Q1_V1_8812F                                              \
	(BIT_MASK_HEAD_PKT_Q1_V1_8812F << BIT_SHIFT_HEAD_PKT_Q1_V1_8812F)
#define BIT_CLEAR_HEAD_PKT_Q1_V1_8812F(x) ((x) & (~BITS_HEAD_PKT_Q1_V1_8812F))
#define BIT_GET_HEAD_PKT_Q1_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HEAD_PKT_Q1_V1_8812F) &                             \
	 BIT_MASK_HEAD_PKT_Q1_V1_8812F)
#define BIT_SET_HEAD_PKT_Q1_V1_8812F(x, v)                                     \
	(BIT_CLEAR_HEAD_PKT_Q1_V1_8812F(x) | BIT_HEAD_PKT_Q1_V1_8812F(v))

/* 2 REG_Q2_INFO_8812F */

#define BIT_SHIFT_QUEUEMACID_Q2_V1_8812F 25
#define BIT_MASK_QUEUEMACID_Q2_V1_8812F 0x7f
#define BIT_QUEUEMACID_Q2_V1_8812F(x)                                          \
	(((x) & BIT_MASK_QUEUEMACID_Q2_V1_8812F)                               \
	 << BIT_SHIFT_QUEUEMACID_Q2_V1_8812F)
#define BITS_QUEUEMACID_Q2_V1_8812F                                            \
	(BIT_MASK_QUEUEMACID_Q2_V1_8812F << BIT_SHIFT_QUEUEMACID_Q2_V1_8812F)
#define BIT_CLEAR_QUEUEMACID_Q2_V1_8812F(x)                                    \
	((x) & (~BITS_QUEUEMACID_Q2_V1_8812F))
#define BIT_GET_QUEUEMACID_Q2_V1_8812F(x)                                      \
	(((x) >> BIT_SHIFT_QUEUEMACID_Q2_V1_8812F) &                           \
	 BIT_MASK_QUEUEMACID_Q2_V1_8812F)
#define BIT_SET_QUEUEMACID_Q2_V1_8812F(x, v)                                   \
	(BIT_CLEAR_QUEUEMACID_Q2_V1_8812F(x) | BIT_QUEUEMACID_Q2_V1_8812F(v))

#define BIT_SHIFT_QUEUEAC_Q2_V1_8812F 23
#define BIT_MASK_QUEUEAC_Q2_V1_8812F 0x3
#define BIT_QUEUEAC_Q2_V1_8812F(x)                                             \
	(((x) & BIT_MASK_QUEUEAC_Q2_V1_8812F) << BIT_SHIFT_QUEUEAC_Q2_V1_8812F)
#define BITS_QUEUEAC_Q2_V1_8812F                                               \
	(BIT_MASK_QUEUEAC_Q2_V1_8812F << BIT_SHIFT_QUEUEAC_Q2_V1_8812F)
#define BIT_CLEAR_QUEUEAC_Q2_V1_8812F(x) ((x) & (~BITS_QUEUEAC_Q2_V1_8812F))
#define BIT_GET_QUEUEAC_Q2_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_QUEUEAC_Q2_V1_8812F) & BIT_MASK_QUEUEAC_Q2_V1_8812F)
#define BIT_SET_QUEUEAC_Q2_V1_8812F(x, v)                                      \
	(BIT_CLEAR_QUEUEAC_Q2_V1_8812F(x) | BIT_QUEUEAC_Q2_V1_8812F(v))

#define BIT_TIDEMPTY_Q2_V1_8812F BIT(22)

#define BIT_SHIFT_TAIL_PKT_Q2_V2_8812F 11
#define BIT_MASK_TAIL_PKT_Q2_V2_8812F 0x7ff
#define BIT_TAIL_PKT_Q2_V2_8812F(x)                                            \
	(((x) & BIT_MASK_TAIL_PKT_Q2_V2_8812F)                                 \
	 << BIT_SHIFT_TAIL_PKT_Q2_V2_8812F)
#define BITS_TAIL_PKT_Q2_V2_8812F                                              \
	(BIT_MASK_TAIL_PKT_Q2_V2_8812F << BIT_SHIFT_TAIL_PKT_Q2_V2_8812F)
#define BIT_CLEAR_TAIL_PKT_Q2_V2_8812F(x) ((x) & (~BITS_TAIL_PKT_Q2_V2_8812F))
#define BIT_GET_TAIL_PKT_Q2_V2_8812F(x)                                        \
	(((x) >> BIT_SHIFT_TAIL_PKT_Q2_V2_8812F) &                             \
	 BIT_MASK_TAIL_PKT_Q2_V2_8812F)
#define BIT_SET_TAIL_PKT_Q2_V2_8812F(x, v)                                     \
	(BIT_CLEAR_TAIL_PKT_Q2_V2_8812F(x) | BIT_TAIL_PKT_Q2_V2_8812F(v))

#define BIT_SHIFT_HEAD_PKT_Q2_V1_8812F 0
#define BIT_MASK_HEAD_PKT_Q2_V1_8812F 0x7ff
#define BIT_HEAD_PKT_Q2_V1_8812F(x)                                            \
	(((x) & BIT_MASK_HEAD_PKT_Q2_V1_8812F)                                 \
	 << BIT_SHIFT_HEAD_PKT_Q2_V1_8812F)
#define BITS_HEAD_PKT_Q2_V1_8812F                                              \
	(BIT_MASK_HEAD_PKT_Q2_V1_8812F << BIT_SHIFT_HEAD_PKT_Q2_V1_8812F)
#define BIT_CLEAR_HEAD_PKT_Q2_V1_8812F(x) ((x) & (~BITS_HEAD_PKT_Q2_V1_8812F))
#define BIT_GET_HEAD_PKT_Q2_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HEAD_PKT_Q2_V1_8812F) &                             \
	 BIT_MASK_HEAD_PKT_Q2_V1_8812F)
#define BIT_SET_HEAD_PKT_Q2_V1_8812F(x, v)                                     \
	(BIT_CLEAR_HEAD_PKT_Q2_V1_8812F(x) | BIT_HEAD_PKT_Q2_V1_8812F(v))

/* 2 REG_Q3_INFO_8812F */

#define BIT_SHIFT_QUEUEMACID_Q3_V1_8812F 25
#define BIT_MASK_QUEUEMACID_Q3_V1_8812F 0x7f
#define BIT_QUEUEMACID_Q3_V1_8812F(x)                                          \
	(((x) & BIT_MASK_QUEUEMACID_Q3_V1_8812F)                               \
	 << BIT_SHIFT_QUEUEMACID_Q3_V1_8812F)
#define BITS_QUEUEMACID_Q3_V1_8812F                                            \
	(BIT_MASK_QUEUEMACID_Q3_V1_8812F << BIT_SHIFT_QUEUEMACID_Q3_V1_8812F)
#define BIT_CLEAR_QUEUEMACID_Q3_V1_8812F(x)                                    \
	((x) & (~BITS_QUEUEMACID_Q3_V1_8812F))
#define BIT_GET_QUEUEMACID_Q3_V1_8812F(x)                                      \
	(((x) >> BIT_SHIFT_QUEUEMACID_Q3_V1_8812F) &                           \
	 BIT_MASK_QUEUEMACID_Q3_V1_8812F)
#define BIT_SET_QUEUEMACID_Q3_V1_8812F(x, v)                                   \
	(BIT_CLEAR_QUEUEMACID_Q3_V1_8812F(x) | BIT_QUEUEMACID_Q3_V1_8812F(v))

#define BIT_SHIFT_QUEUEAC_Q3_V1_8812F 23
#define BIT_MASK_QUEUEAC_Q3_V1_8812F 0x3
#define BIT_QUEUEAC_Q3_V1_8812F(x)                                             \
	(((x) & BIT_MASK_QUEUEAC_Q3_V1_8812F) << BIT_SHIFT_QUEUEAC_Q3_V1_8812F)
#define BITS_QUEUEAC_Q3_V1_8812F                                               \
	(BIT_MASK_QUEUEAC_Q3_V1_8812F << BIT_SHIFT_QUEUEAC_Q3_V1_8812F)
#define BIT_CLEAR_QUEUEAC_Q3_V1_8812F(x) ((x) & (~BITS_QUEUEAC_Q3_V1_8812F))
#define BIT_GET_QUEUEAC_Q3_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_QUEUEAC_Q3_V1_8812F) & BIT_MASK_QUEUEAC_Q3_V1_8812F)
#define BIT_SET_QUEUEAC_Q3_V1_8812F(x, v)                                      \
	(BIT_CLEAR_QUEUEAC_Q3_V1_8812F(x) | BIT_QUEUEAC_Q3_V1_8812F(v))

#define BIT_TIDEMPTY_Q3_V1_8812F BIT(22)

#define BIT_SHIFT_TAIL_PKT_Q3_V2_8812F 11
#define BIT_MASK_TAIL_PKT_Q3_V2_8812F 0x7ff
#define BIT_TAIL_PKT_Q3_V2_8812F(x)                                            \
	(((x) & BIT_MASK_TAIL_PKT_Q3_V2_8812F)                                 \
	 << BIT_SHIFT_TAIL_PKT_Q3_V2_8812F)
#define BITS_TAIL_PKT_Q3_V2_8812F                                              \
	(BIT_MASK_TAIL_PKT_Q3_V2_8812F << BIT_SHIFT_TAIL_PKT_Q3_V2_8812F)
#define BIT_CLEAR_TAIL_PKT_Q3_V2_8812F(x) ((x) & (~BITS_TAIL_PKT_Q3_V2_8812F))
#define BIT_GET_TAIL_PKT_Q3_V2_8812F(x)                                        \
	(((x) >> BIT_SHIFT_TAIL_PKT_Q3_V2_8812F) &                             \
	 BIT_MASK_TAIL_PKT_Q3_V2_8812F)
#define BIT_SET_TAIL_PKT_Q3_V2_8812F(x, v)                                     \
	(BIT_CLEAR_TAIL_PKT_Q3_V2_8812F(x) | BIT_TAIL_PKT_Q3_V2_8812F(v))

#define BIT_SHIFT_HEAD_PKT_Q3_V1_8812F 0
#define BIT_MASK_HEAD_PKT_Q3_V1_8812F 0x7ff
#define BIT_HEAD_PKT_Q3_V1_8812F(x)                                            \
	(((x) & BIT_MASK_HEAD_PKT_Q3_V1_8812F)                                 \
	 << BIT_SHIFT_HEAD_PKT_Q3_V1_8812F)
#define BITS_HEAD_PKT_Q3_V1_8812F                                              \
	(BIT_MASK_HEAD_PKT_Q3_V1_8812F << BIT_SHIFT_HEAD_PKT_Q3_V1_8812F)
#define BIT_CLEAR_HEAD_PKT_Q3_V1_8812F(x) ((x) & (~BITS_HEAD_PKT_Q3_V1_8812F))
#define BIT_GET_HEAD_PKT_Q3_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HEAD_PKT_Q3_V1_8812F) &                             \
	 BIT_MASK_HEAD_PKT_Q3_V1_8812F)
#define BIT_SET_HEAD_PKT_Q3_V1_8812F(x, v)                                     \
	(BIT_CLEAR_HEAD_PKT_Q3_V1_8812F(x) | BIT_HEAD_PKT_Q3_V1_8812F(v))

/* 2 REG_MGQ_INFO_8812F */

#define BIT_SHIFT_QUEUEMACID_MGQ_V1_8812F 25
#define BIT_MASK_QUEUEMACID_MGQ_V1_8812F 0x7f
#define BIT_QUEUEMACID_MGQ_V1_8812F(x)                                         \
	(((x) & BIT_MASK_QUEUEMACID_MGQ_V1_8812F)                              \
	 << BIT_SHIFT_QUEUEMACID_MGQ_V1_8812F)
#define BITS_QUEUEMACID_MGQ_V1_8812F                                           \
	(BIT_MASK_QUEUEMACID_MGQ_V1_8812F << BIT_SHIFT_QUEUEMACID_MGQ_V1_8812F)
#define BIT_CLEAR_QUEUEMACID_MGQ_V1_8812F(x)                                   \
	((x) & (~BITS_QUEUEMACID_MGQ_V1_8812F))
#define BIT_GET_QUEUEMACID_MGQ_V1_8812F(x)                                     \
	(((x) >> BIT_SHIFT_QUEUEMACID_MGQ_V1_8812F) &                          \
	 BIT_MASK_QUEUEMACID_MGQ_V1_8812F)
#define BIT_SET_QUEUEMACID_MGQ_V1_8812F(x, v)                                  \
	(BIT_CLEAR_QUEUEMACID_MGQ_V1_8812F(x) | BIT_QUEUEMACID_MGQ_V1_8812F(v))

#define BIT_SHIFT_QUEUEAC_MGQ_V1_8812F 23
#define BIT_MASK_QUEUEAC_MGQ_V1_8812F 0x3
#define BIT_QUEUEAC_MGQ_V1_8812F(x)                                            \
	(((x) & BIT_MASK_QUEUEAC_MGQ_V1_8812F)                                 \
	 << BIT_SHIFT_QUEUEAC_MGQ_V1_8812F)
#define BITS_QUEUEAC_MGQ_V1_8812F                                              \
	(BIT_MASK_QUEUEAC_MGQ_V1_8812F << BIT_SHIFT_QUEUEAC_MGQ_V1_8812F)
#define BIT_CLEAR_QUEUEAC_MGQ_V1_8812F(x) ((x) & (~BITS_QUEUEAC_MGQ_V1_8812F))
#define BIT_GET_QUEUEAC_MGQ_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_QUEUEAC_MGQ_V1_8812F) &                             \
	 BIT_MASK_QUEUEAC_MGQ_V1_8812F)
#define BIT_SET_QUEUEAC_MGQ_V1_8812F(x, v)                                     \
	(BIT_CLEAR_QUEUEAC_MGQ_V1_8812F(x) | BIT_QUEUEAC_MGQ_V1_8812F(v))

#define BIT_TIDEMPTY_MGQ_V1_8812F BIT(22)

#define BIT_SHIFT_TAIL_PKT_MGQ_V2_8812F 11
#define BIT_MASK_TAIL_PKT_MGQ_V2_8812F 0x7ff
#define BIT_TAIL_PKT_MGQ_V2_8812F(x)                                           \
	(((x) & BIT_MASK_TAIL_PKT_MGQ_V2_8812F)                                \
	 << BIT_SHIFT_TAIL_PKT_MGQ_V2_8812F)
#define BITS_TAIL_PKT_MGQ_V2_8812F                                             \
	(BIT_MASK_TAIL_PKT_MGQ_V2_8812F << BIT_SHIFT_TAIL_PKT_MGQ_V2_8812F)
#define BIT_CLEAR_TAIL_PKT_MGQ_V2_8812F(x) ((x) & (~BITS_TAIL_PKT_MGQ_V2_8812F))
#define BIT_GET_TAIL_PKT_MGQ_V2_8812F(x)                                       \
	(((x) >> BIT_SHIFT_TAIL_PKT_MGQ_V2_8812F) &                            \
	 BIT_MASK_TAIL_PKT_MGQ_V2_8812F)
#define BIT_SET_TAIL_PKT_MGQ_V2_8812F(x, v)                                    \
	(BIT_CLEAR_TAIL_PKT_MGQ_V2_8812F(x) | BIT_TAIL_PKT_MGQ_V2_8812F(v))

#define BIT_SHIFT_HEAD_PKT_MGQ_V1_8812F 0
#define BIT_MASK_HEAD_PKT_MGQ_V1_8812F 0x7ff
#define BIT_HEAD_PKT_MGQ_V1_8812F(x)                                           \
	(((x) & BIT_MASK_HEAD_PKT_MGQ_V1_8812F)                                \
	 << BIT_SHIFT_HEAD_PKT_MGQ_V1_8812F)
#define BITS_HEAD_PKT_MGQ_V1_8812F                                             \
	(BIT_MASK_HEAD_PKT_MGQ_V1_8812F << BIT_SHIFT_HEAD_PKT_MGQ_V1_8812F)
#define BIT_CLEAR_HEAD_PKT_MGQ_V1_8812F(x) ((x) & (~BITS_HEAD_PKT_MGQ_V1_8812F))
#define BIT_GET_HEAD_PKT_MGQ_V1_8812F(x)                                       \
	(((x) >> BIT_SHIFT_HEAD_PKT_MGQ_V1_8812F) &                            \
	 BIT_MASK_HEAD_PKT_MGQ_V1_8812F)
#define BIT_SET_HEAD_PKT_MGQ_V1_8812F(x, v)                                    \
	(BIT_CLEAR_HEAD_PKT_MGQ_V1_8812F(x) | BIT_HEAD_PKT_MGQ_V1_8812F(v))

/* 2 REG_HIQ_INFO_8812F */

#define BIT_SHIFT_QUEUEMACID_HIQ_V1_8812F 25
#define BIT_MASK_QUEUEMACID_HIQ_V1_8812F 0x7f
#define BIT_QUEUEMACID_HIQ_V1_8812F(x)                                         \
	(((x) & BIT_MASK_QUEUEMACID_HIQ_V1_8812F)                              \
	 << BIT_SHIFT_QUEUEMACID_HIQ_V1_8812F)
#define BITS_QUEUEMACID_HIQ_V1_8812F                                           \
	(BIT_MASK_QUEUEMACID_HIQ_V1_8812F << BIT_SHIFT_QUEUEMACID_HIQ_V1_8812F)
#define BIT_CLEAR_QUEUEMACID_HIQ_V1_8812F(x)                                   \
	((x) & (~BITS_QUEUEMACID_HIQ_V1_8812F))
#define BIT_GET_QUEUEMACID_HIQ_V1_8812F(x)                                     \
	(((x) >> BIT_SHIFT_QUEUEMACID_HIQ_V1_8812F) &                          \
	 BIT_MASK_QUEUEMACID_HIQ_V1_8812F)
#define BIT_SET_QUEUEMACID_HIQ_V1_8812F(x, v)                                  \
	(BIT_CLEAR_QUEUEMACID_HIQ_V1_8812F(x) | BIT_QUEUEMACID_HIQ_V1_8812F(v))

#define BIT_SHIFT_QUEUEAC_HIQ_V1_8812F 23
#define BIT_MASK_QUEUEAC_HIQ_V1_8812F 0x3
#define BIT_QUEUEAC_HIQ_V1_8812F(x)                                            \
	(((x) & BIT_MASK_QUEUEAC_HIQ_V1_8812F)                                 \
	 << BIT_SHIFT_QUEUEAC_HIQ_V1_8812F)
#define BITS_QUEUEAC_HIQ_V1_8812F                                              \
	(BIT_MASK_QUEUEAC_HIQ_V1_8812F << BIT_SHIFT_QUEUEAC_HIQ_V1_8812F)
#define BIT_CLEAR_QUEUEAC_HIQ_V1_8812F(x) ((x) & (~BITS_QUEUEAC_HIQ_V1_8812F))
#define BIT_GET_QUEUEAC_HIQ_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_QUEUEAC_HIQ_V1_8812F) &                             \
	 BIT_MASK_QUEUEAC_HIQ_V1_8812F)
#define BIT_SET_QUEUEAC_HIQ_V1_8812F(x, v)                                     \
	(BIT_CLEAR_QUEUEAC_HIQ_V1_8812F(x) | BIT_QUEUEAC_HIQ_V1_8812F(v))

#define BIT_TIDEMPTY_HIQ_V1_8812F BIT(22)

#define BIT_SHIFT_TAIL_PKT_HIQ_V2_8812F 11
#define BIT_MASK_TAIL_PKT_HIQ_V2_8812F 0x7ff
#define BIT_TAIL_PKT_HIQ_V2_8812F(x)                                           \
	(((x) & BIT_MASK_TAIL_PKT_HIQ_V2_8812F)                                \
	 << BIT_SHIFT_TAIL_PKT_HIQ_V2_8812F)
#define BITS_TAIL_PKT_HIQ_V2_8812F                                             \
	(BIT_MASK_TAIL_PKT_HIQ_V2_8812F << BIT_SHIFT_TAIL_PKT_HIQ_V2_8812F)
#define BIT_CLEAR_TAIL_PKT_HIQ_V2_8812F(x) ((x) & (~BITS_TAIL_PKT_HIQ_V2_8812F))
#define BIT_GET_TAIL_PKT_HIQ_V2_8812F(x)                                       \
	(((x) >> BIT_SHIFT_TAIL_PKT_HIQ_V2_8812F) &                            \
	 BIT_MASK_TAIL_PKT_HIQ_V2_8812F)
#define BIT_SET_TAIL_PKT_HIQ_V2_8812F(x, v)                                    \
	(BIT_CLEAR_TAIL_PKT_HIQ_V2_8812F(x) | BIT_TAIL_PKT_HIQ_V2_8812F(v))

#define BIT_SHIFT_HEAD_PKT_HIQ_V1_8812F 0
#define BIT_MASK_HEAD_PKT_HIQ_V1_8812F 0x7ff
#define BIT_HEAD_PKT_HIQ_V1_8812F(x)                                           \
	(((x) & BIT_MASK_HEAD_PKT_HIQ_V1_8812F)                                \
	 << BIT_SHIFT_HEAD_PKT_HIQ_V1_8812F)
#define BITS_HEAD_PKT_HIQ_V1_8812F                                             \
	(BIT_MASK_HEAD_PKT_HIQ_V1_8812F << BIT_SHIFT_HEAD_PKT_HIQ_V1_8812F)
#define BIT_CLEAR_HEAD_PKT_HIQ_V1_8812F(x) ((x) & (~BITS_HEAD_PKT_HIQ_V1_8812F))
#define BIT_GET_HEAD_PKT_HIQ_V1_8812F(x)                                       \
	(((x) >> BIT_SHIFT_HEAD_PKT_HIQ_V1_8812F) &                            \
	 BIT_MASK_HEAD_PKT_HIQ_V1_8812F)
#define BIT_SET_HEAD_PKT_HIQ_V1_8812F(x, v)                                    \
	(BIT_CLEAR_HEAD_PKT_HIQ_V1_8812F(x) | BIT_HEAD_PKT_HIQ_V1_8812F(v))

/* 2 REG_BCNQ_INFO_8812F */

#define BIT_SHIFT_BCNQ_HEAD_PG_V1_8812F 0
#define BIT_MASK_BCNQ_HEAD_PG_V1_8812F 0xfff
#define BIT_BCNQ_HEAD_PG_V1_8812F(x)                                           \
	(((x) & BIT_MASK_BCNQ_HEAD_PG_V1_8812F)                                \
	 << BIT_SHIFT_BCNQ_HEAD_PG_V1_8812F)
#define BITS_BCNQ_HEAD_PG_V1_8812F                                             \
	(BIT_MASK_BCNQ_HEAD_PG_V1_8812F << BIT_SHIFT_BCNQ_HEAD_PG_V1_8812F)
#define BIT_CLEAR_BCNQ_HEAD_PG_V1_8812F(x) ((x) & (~BITS_BCNQ_HEAD_PG_V1_8812F))
#define BIT_GET_BCNQ_HEAD_PG_V1_8812F(x)                                       \
	(((x) >> BIT_SHIFT_BCNQ_HEAD_PG_V1_8812F) &                            \
	 BIT_MASK_BCNQ_HEAD_PG_V1_8812F)
#define BIT_SET_BCNQ_HEAD_PG_V1_8812F(x, v)                                    \
	(BIT_CLEAR_BCNQ_HEAD_PG_V1_8812F(x) | BIT_BCNQ_HEAD_PG_V1_8812F(v))

/* 2 REG_TXPKT_EMPTY_8812F */
#define BIT_BCNQ_EMPTY_8812F BIT(11)
#define BIT_HQQ_EMPTY_8812F BIT(10)
#define BIT_MQQ_EMPTY_8812F BIT(9)
#define BIT_MGQ_CPU_EMPTY_8812F BIT(8)
#define BIT_AC7Q_EMPTY_8812F BIT(7)
#define BIT_AC6Q_EMPTY_8812F BIT(6)
#define BIT_AC5Q_EMPTY_8812F BIT(5)
#define BIT_AC4Q_EMPTY_8812F BIT(4)
#define BIT_AC3Q_EMPTY_8812F BIT(3)
#define BIT_AC2Q_EMPTY_8812F BIT(2)
#define BIT_AC1Q_EMPTY_8812F BIT(1)
#define BIT_AC0Q_EMPTY_8812F BIT(0)

/* 2 REG_CPU_MGQ_INFO_8812F */
#define BIT_BCN1_POLL_8812F BIT(30)
#define BIT_CPUMGT_POLL_8812F BIT(29)
#define BIT_BCN_POLL_8812F BIT(28)
#define BIT_CPUMGQ_FW_NUM_V1_8812F BIT(12)

#define BIT_SHIFT_FW_FREE_TAIL_V1_8812F 0
#define BIT_MASK_FW_FREE_TAIL_V1_8812F 0xfff
#define BIT_FW_FREE_TAIL_V1_8812F(x)                                           \
	(((x) & BIT_MASK_FW_FREE_TAIL_V1_8812F)                                \
	 << BIT_SHIFT_FW_FREE_TAIL_V1_8812F)
#define BITS_FW_FREE_TAIL_V1_8812F                                             \
	(BIT_MASK_FW_FREE_TAIL_V1_8812F << BIT_SHIFT_FW_FREE_TAIL_V1_8812F)
#define BIT_CLEAR_FW_FREE_TAIL_V1_8812F(x) ((x) & (~BITS_FW_FREE_TAIL_V1_8812F))
#define BIT_GET_FW_FREE_TAIL_V1_8812F(x)                                       \
	(((x) >> BIT_SHIFT_FW_FREE_TAIL_V1_8812F) &                            \
	 BIT_MASK_FW_FREE_TAIL_V1_8812F)
#define BIT_SET_FW_FREE_TAIL_V1_8812F(x, v)                                    \
	(BIT_CLEAR_FW_FREE_TAIL_V1_8812F(x) | BIT_FW_FREE_TAIL_V1_8812F(v))

/* 2 REG_FWHW_TXQ_CTRL_8812F */
#define BIT_RTS_LIMIT_IN_OFDM_8812F BIT(23)
#define BIT_EN_BCNQ_DL_8812F BIT(22)
#define BIT_EN_RD_RESP_NAV_BK_8812F BIT(21)
#define BIT_EN_WR_FREE_TAIL_8812F BIT(20)
#define BIT_NOTXRPT_USERATE_EN_8812F BIT(19)
#define BIT_DIS_TXFAIL_RPT_8812F BIT(18)
#define BIT_FTM_TIMEOUT_BYPASS_8812F BIT(16)

#define BIT_SHIFT_EN_QUEUE_RPT_8812F 8
#define BIT_MASK_EN_QUEUE_RPT_8812F 0xff
#define BIT_EN_QUEUE_RPT_8812F(x)                                              \
	(((x) & BIT_MASK_EN_QUEUE_RPT_8812F) << BIT_SHIFT_EN_QUEUE_RPT_8812F)
#define BITS_EN_QUEUE_RPT_8812F                                                \
	(BIT_MASK_EN_QUEUE_RPT_8812F << BIT_SHIFT_EN_QUEUE_RPT_8812F)
#define BIT_CLEAR_EN_QUEUE_RPT_8812F(x) ((x) & (~BITS_EN_QUEUE_RPT_8812F))
#define BIT_GET_EN_QUEUE_RPT_8812F(x)                                          \
	(((x) >> BIT_SHIFT_EN_QUEUE_RPT_8812F) & BIT_MASK_EN_QUEUE_RPT_8812F)
#define BIT_SET_EN_QUEUE_RPT_8812F(x, v)                                       \
	(BIT_CLEAR_EN_QUEUE_RPT_8812F(x) | BIT_EN_QUEUE_RPT_8812F(v))

#define BIT_EN_RTY_BK_8812F BIT(7)
#define BIT_EN_USE_INI_RAT_8812F BIT(6)
#define BIT_EN_RTS_NAV_BK_8812F BIT(5)
#define BIT_DIS_SSN_CHECK_8812F BIT(4)
#define BIT_MACID_MATCH_RTS_8812F BIT(3)
#define BIT_EN_BCN_TRXRPT_V1_8812F BIT(2)
#define BIT_R_EN_FTMRPT_V1_8812F BIT(1)
#define BIT_R_BMC_NAV_PROTECT_8812F BIT(0)

/* 2 REG_DATAFB_SEL_8812F */
#define BIT_BROADCAST_RTY_EN_8812F BIT(3)
#define BIT_EN_RTY_BK_COD_8812F BIT(2)

#define BIT_SHIFT__R_DATA_FALLBACK_SEL_8812F 0
#define BIT_MASK__R_DATA_FALLBACK_SEL_8812F 0x3
#define BIT__R_DATA_FALLBACK_SEL_8812F(x)                                      \
	(((x) & BIT_MASK__R_DATA_FALLBACK_SEL_8812F)                           \
	 << BIT_SHIFT__R_DATA_FALLBACK_SEL_8812F)
#define BITS__R_DATA_FALLBACK_SEL_8812F                                        \
	(BIT_MASK__R_DATA_FALLBACK_SEL_8812F                                   \
	 << BIT_SHIFT__R_DATA_FALLBACK_SEL_8812F)
#define BIT_CLEAR__R_DATA_FALLBACK_SEL_8812F(x)                                \
	((x) & (~BITS__R_DATA_FALLBACK_SEL_8812F))
#define BIT_GET__R_DATA_FALLBACK_SEL_8812F(x)                                  \
	(((x) >> BIT_SHIFT__R_DATA_FALLBACK_SEL_8812F) &                       \
	 BIT_MASK__R_DATA_FALLBACK_SEL_8812F)
#define BIT_SET__R_DATA_FALLBACK_SEL_8812F(x, v)                               \
	(BIT_CLEAR__R_DATA_FALLBACK_SEL_8812F(x) |                             \
	 BIT__R_DATA_FALLBACK_SEL_8812F(v))

/* 2 REG_BCNQ_BDNY_V1_8812F */

#define BIT_SHIFT_BCNQ_PGBNDY_V1_8812F 0
#define BIT_MASK_BCNQ_PGBNDY_V1_8812F 0xfff
#define BIT_BCNQ_PGBNDY_V1_8812F(x)                                            \
	(((x) & BIT_MASK_BCNQ_PGBNDY_V1_8812F)                                 \
	 << BIT_SHIFT_BCNQ_PGBNDY_V1_8812F)
#define BITS_BCNQ_PGBNDY_V1_8812F                                              \
	(BIT_MASK_BCNQ_PGBNDY_V1_8812F << BIT_SHIFT_BCNQ_PGBNDY_V1_8812F)
#define BIT_CLEAR_BCNQ_PGBNDY_V1_8812F(x) ((x) & (~BITS_BCNQ_PGBNDY_V1_8812F))
#define BIT_GET_BCNQ_PGBNDY_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_BCNQ_PGBNDY_V1_8812F) &                             \
	 BIT_MASK_BCNQ_PGBNDY_V1_8812F)
#define BIT_SET_BCNQ_PGBNDY_V1_8812F(x, v)                                     \
	(BIT_CLEAR_BCNQ_PGBNDY_V1_8812F(x) | BIT_BCNQ_PGBNDY_V1_8812F(v))

/* 2 REG_LIFETIME_EN_8812F */
#define BIT_BT_INT_CPU_8812F BIT(7)
#define BIT_BT_INT_PTA_8812F BIT(6)
#define BIT_BA_PARSER_EN_8812F BIT(5)
#define BIT_EN_CTRL_RTYBIT_8812F BIT(4)
#define BIT_LIFETIME_BK_EN_8812F BIT(3)
#define BIT_LIFETIME_BE_EN_8812F BIT(2)
#define BIT_LIFETIME_VI_EN_8812F BIT(1)
#define BIT_LIFETIME_VO_EN_8812F BIT(0)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_SPEC_SIFS_8812F */

#define BIT_SHIFT_SPEC_SIFS_OFDM_PTCL_8812F 8
#define BIT_MASK_SPEC_SIFS_OFDM_PTCL_8812F 0xff
#define BIT_SPEC_SIFS_OFDM_PTCL_8812F(x)                                       \
	(((x) & BIT_MASK_SPEC_SIFS_OFDM_PTCL_8812F)                            \
	 << BIT_SHIFT_SPEC_SIFS_OFDM_PTCL_8812F)
#define BITS_SPEC_SIFS_OFDM_PTCL_8812F                                         \
	(BIT_MASK_SPEC_SIFS_OFDM_PTCL_8812F                                    \
	 << BIT_SHIFT_SPEC_SIFS_OFDM_PTCL_8812F)
#define BIT_CLEAR_SPEC_SIFS_OFDM_PTCL_8812F(x)                                 \
	((x) & (~BITS_SPEC_SIFS_OFDM_PTCL_8812F))
#define BIT_GET_SPEC_SIFS_OFDM_PTCL_8812F(x)                                   \
	(((x) >> BIT_SHIFT_SPEC_SIFS_OFDM_PTCL_8812F) &                        \
	 BIT_MASK_SPEC_SIFS_OFDM_PTCL_8812F)
#define BIT_SET_SPEC_SIFS_OFDM_PTCL_8812F(x, v)                                \
	(BIT_CLEAR_SPEC_SIFS_OFDM_PTCL_8812F(x) |                              \
	 BIT_SPEC_SIFS_OFDM_PTCL_8812F(v))

#define BIT_SHIFT_SPEC_SIFS_CCK_PTCL_8812F 0
#define BIT_MASK_SPEC_SIFS_CCK_PTCL_8812F 0xff
#define BIT_SPEC_SIFS_CCK_PTCL_8812F(x)                                        \
	(((x) & BIT_MASK_SPEC_SIFS_CCK_PTCL_8812F)                             \
	 << BIT_SHIFT_SPEC_SIFS_CCK_PTCL_8812F)
#define BITS_SPEC_SIFS_CCK_PTCL_8812F                                          \
	(BIT_MASK_SPEC_SIFS_CCK_PTCL_8812F                                     \
	 << BIT_SHIFT_SPEC_SIFS_CCK_PTCL_8812F)
#define BIT_CLEAR_SPEC_SIFS_CCK_PTCL_8812F(x)                                  \
	((x) & (~BITS_SPEC_SIFS_CCK_PTCL_8812F))
#define BIT_GET_SPEC_SIFS_CCK_PTCL_8812F(x)                                    \
	(((x) >> BIT_SHIFT_SPEC_SIFS_CCK_PTCL_8812F) &                         \
	 BIT_MASK_SPEC_SIFS_CCK_PTCL_8812F)
#define BIT_SET_SPEC_SIFS_CCK_PTCL_8812F(x, v)                                 \
	(BIT_CLEAR_SPEC_SIFS_CCK_PTCL_8812F(x) |                               \
	 BIT_SPEC_SIFS_CCK_PTCL_8812F(v))

/* 2 REG_RETRY_LIMIT_8812F */

#define BIT_SHIFT_SRL_8812F 8
#define BIT_MASK_SRL_8812F 0x3f
#define BIT_SRL_8812F(x) (((x) & BIT_MASK_SRL_8812F) << BIT_SHIFT_SRL_8812F)
#define BITS_SRL_8812F (BIT_MASK_SRL_8812F << BIT_SHIFT_SRL_8812F)
#define BIT_CLEAR_SRL_8812F(x) ((x) & (~BITS_SRL_8812F))
#define BIT_GET_SRL_8812F(x) (((x) >> BIT_SHIFT_SRL_8812F) & BIT_MASK_SRL_8812F)
#define BIT_SET_SRL_8812F(x, v) (BIT_CLEAR_SRL_8812F(x) | BIT_SRL_8812F(v))

#define BIT_SHIFT_LRL_8812F 0
#define BIT_MASK_LRL_8812F 0x3f
#define BIT_LRL_8812F(x) (((x) & BIT_MASK_LRL_8812F) << BIT_SHIFT_LRL_8812F)
#define BITS_LRL_8812F (BIT_MASK_LRL_8812F << BIT_SHIFT_LRL_8812F)
#define BIT_CLEAR_LRL_8812F(x) ((x) & (~BITS_LRL_8812F))
#define BIT_GET_LRL_8812F(x) (((x) >> BIT_SHIFT_LRL_8812F) & BIT_MASK_LRL_8812F)
#define BIT_SET_LRL_8812F(x, v) (BIT_CLEAR_LRL_8812F(x) | BIT_LRL_8812F(v))

/* 2 REG_TXBF_CTRL_8812F */
#define BIT_R_ENABLE_NDPA_8812F BIT(31)
#define BIT_USE_NDPA_PARAMETER_8812F BIT(30)
#define BIT_R_PROP_TXBF_8812F BIT(29)
#define BIT_R_EN_NDPA_INT_8812F BIT(28)
#define BIT_R_TXBF1_80M_8812F BIT(27)
#define BIT_R_TXBF1_40M_8812F BIT(26)
#define BIT_R_TXBF1_20M_8812F BIT(25)

#define BIT_SHIFT_R_TXBF1_AID_8812F 16
#define BIT_MASK_R_TXBF1_AID_8812F 0x1ff
#define BIT_R_TXBF1_AID_8812F(x)                                               \
	(((x) & BIT_MASK_R_TXBF1_AID_8812F) << BIT_SHIFT_R_TXBF1_AID_8812F)
#define BITS_R_TXBF1_AID_8812F                                                 \
	(BIT_MASK_R_TXBF1_AID_8812F << BIT_SHIFT_R_TXBF1_AID_8812F)
#define BIT_CLEAR_R_TXBF1_AID_8812F(x) ((x) & (~BITS_R_TXBF1_AID_8812F))
#define BIT_GET_R_TXBF1_AID_8812F(x)                                           \
	(((x) >> BIT_SHIFT_R_TXBF1_AID_8812F) & BIT_MASK_R_TXBF1_AID_8812F)
#define BIT_SET_R_TXBF1_AID_8812F(x, v)                                        \
	(BIT_CLEAR_R_TXBF1_AID_8812F(x) | BIT_R_TXBF1_AID_8812F(v))

#define BIT_DIS_NDP_BFEN_8812F BIT(15)
#define BIT_R_TXBCN_NOBLOCK_NDP_8812F BIT(14)
#define BIT_R_TXBF0_80M_8812F BIT(11)
#define BIT_R_TXBF0_40M_8812F BIT(10)
#define BIT_R_TXBF0_20M_8812F BIT(9)

#define BIT_SHIFT_R_TXBF0_AID_8812F 0
#define BIT_MASK_R_TXBF0_AID_8812F 0x1ff
#define BIT_R_TXBF0_AID_8812F(x)                                               \
	(((x) & BIT_MASK_R_TXBF0_AID_8812F) << BIT_SHIFT_R_TXBF0_AID_8812F)
#define BITS_R_TXBF0_AID_8812F                                                 \
	(BIT_MASK_R_TXBF0_AID_8812F << BIT_SHIFT_R_TXBF0_AID_8812F)
#define BIT_CLEAR_R_TXBF0_AID_8812F(x) ((x) & (~BITS_R_TXBF0_AID_8812F))
#define BIT_GET_R_TXBF0_AID_8812F(x)                                           \
	(((x) >> BIT_SHIFT_R_TXBF0_AID_8812F) & BIT_MASK_R_TXBF0_AID_8812F)
#define BIT_SET_R_TXBF0_AID_8812F(x, v)                                        \
	(BIT_CLEAR_R_TXBF0_AID_8812F(x) | BIT_R_TXBF0_AID_8812F(v))

/* 2 REG_DARFRC_8812F */

#define BIT_SHIFT_DARF_RC4_8812F 24
#define BIT_MASK_DARF_RC4_8812F 0x1f
#define BIT_DARF_RC4_8812F(x)                                                  \
	(((x) & BIT_MASK_DARF_RC4_8812F) << BIT_SHIFT_DARF_RC4_8812F)
#define BITS_DARF_RC4_8812F                                                    \
	(BIT_MASK_DARF_RC4_8812F << BIT_SHIFT_DARF_RC4_8812F)
#define BIT_CLEAR_DARF_RC4_8812F(x) ((x) & (~BITS_DARF_RC4_8812F))
#define BIT_GET_DARF_RC4_8812F(x)                                              \
	(((x) >> BIT_SHIFT_DARF_RC4_8812F) & BIT_MASK_DARF_RC4_8812F)
#define BIT_SET_DARF_RC4_8812F(x, v)                                           \
	(BIT_CLEAR_DARF_RC4_8812F(x) | BIT_DARF_RC4_8812F(v))

#define BIT_SHIFT_DARF_RC3_8812F 16
#define BIT_MASK_DARF_RC3_8812F 0x1f
#define BIT_DARF_RC3_8812F(x)                                                  \
	(((x) & BIT_MASK_DARF_RC3_8812F) << BIT_SHIFT_DARF_RC3_8812F)
#define BITS_DARF_RC3_8812F                                                    \
	(BIT_MASK_DARF_RC3_8812F << BIT_SHIFT_DARF_RC3_8812F)
#define BIT_CLEAR_DARF_RC3_8812F(x) ((x) & (~BITS_DARF_RC3_8812F))
#define BIT_GET_DARF_RC3_8812F(x)                                              \
	(((x) >> BIT_SHIFT_DARF_RC3_8812F) & BIT_MASK_DARF_RC3_8812F)
#define BIT_SET_DARF_RC3_8812F(x, v)                                           \
	(BIT_CLEAR_DARF_RC3_8812F(x) | BIT_DARF_RC3_8812F(v))

#define BIT_SHIFT_DARF_RC2_8812F 8
#define BIT_MASK_DARF_RC2_8812F 0x1f
#define BIT_DARF_RC2_8812F(x)                                                  \
	(((x) & BIT_MASK_DARF_RC2_8812F) << BIT_SHIFT_DARF_RC2_8812F)
#define BITS_DARF_RC2_8812F                                                    \
	(BIT_MASK_DARF_RC2_8812F << BIT_SHIFT_DARF_RC2_8812F)
#define BIT_CLEAR_DARF_RC2_8812F(x) ((x) & (~BITS_DARF_RC2_8812F))
#define BIT_GET_DARF_RC2_8812F(x)                                              \
	(((x) >> BIT_SHIFT_DARF_RC2_8812F) & BIT_MASK_DARF_RC2_8812F)
#define BIT_SET_DARF_RC2_8812F(x, v)                                           \
	(BIT_CLEAR_DARF_RC2_8812F(x) | BIT_DARF_RC2_8812F(v))

#define BIT_SHIFT_DARF_RC1_8812F 0
#define BIT_MASK_DARF_RC1_8812F 0x1f
#define BIT_DARF_RC1_8812F(x)                                                  \
	(((x) & BIT_MASK_DARF_RC1_8812F) << BIT_SHIFT_DARF_RC1_8812F)
#define BITS_DARF_RC1_8812F                                                    \
	(BIT_MASK_DARF_RC1_8812F << BIT_SHIFT_DARF_RC1_8812F)
#define BIT_CLEAR_DARF_RC1_8812F(x) ((x) & (~BITS_DARF_RC1_8812F))
#define BIT_GET_DARF_RC1_8812F(x)                                              \
	(((x) >> BIT_SHIFT_DARF_RC1_8812F) & BIT_MASK_DARF_RC1_8812F)
#define BIT_SET_DARF_RC1_8812F(x, v)                                           \
	(BIT_CLEAR_DARF_RC1_8812F(x) | BIT_DARF_RC1_8812F(v))

/* 2 REG_DARFRCH_8812F */

#define BIT_SHIFT_DARF_RC8_V1_8812F 24
#define BIT_MASK_DARF_RC8_V1_8812F 0x1f
#define BIT_DARF_RC8_V1_8812F(x)                                               \
	(((x) & BIT_MASK_DARF_RC8_V1_8812F) << BIT_SHIFT_DARF_RC8_V1_8812F)
#define BITS_DARF_RC8_V1_8812F                                                 \
	(BIT_MASK_DARF_RC8_V1_8812F << BIT_SHIFT_DARF_RC8_V1_8812F)
#define BIT_CLEAR_DARF_RC8_V1_8812F(x) ((x) & (~BITS_DARF_RC8_V1_8812F))
#define BIT_GET_DARF_RC8_V1_8812F(x)                                           \
	(((x) >> BIT_SHIFT_DARF_RC8_V1_8812F) & BIT_MASK_DARF_RC8_V1_8812F)
#define BIT_SET_DARF_RC8_V1_8812F(x, v)                                        \
	(BIT_CLEAR_DARF_RC8_V1_8812F(x) | BIT_DARF_RC8_V1_8812F(v))

#define BIT_SHIFT_DARF_RC7_V1_8812F 16
#define BIT_MASK_DARF_RC7_V1_8812F 0x1f
#define BIT_DARF_RC7_V1_8812F(x)                                               \
	(((x) & BIT_MASK_DARF_RC7_V1_8812F) << BIT_SHIFT_DARF_RC7_V1_8812F)
#define BITS_DARF_RC7_V1_8812F                                                 \
	(BIT_MASK_DARF_RC7_V1_8812F << BIT_SHIFT_DARF_RC7_V1_8812F)
#define BIT_CLEAR_DARF_RC7_V1_8812F(x) ((x) & (~BITS_DARF_RC7_V1_8812F))
#define BIT_GET_DARF_RC7_V1_8812F(x)                                           \
	(((x) >> BIT_SHIFT_DARF_RC7_V1_8812F) & BIT_MASK_DARF_RC7_V1_8812F)
#define BIT_SET_DARF_RC7_V1_8812F(x, v)                                        \
	(BIT_CLEAR_DARF_RC7_V1_8812F(x) | BIT_DARF_RC7_V1_8812F(v))

#define BIT_SHIFT_DARF_RC6_V1_8812F 8
#define BIT_MASK_DARF_RC6_V1_8812F 0x1f
#define BIT_DARF_RC6_V1_8812F(x)                                               \
	(((x) & BIT_MASK_DARF_RC6_V1_8812F) << BIT_SHIFT_DARF_RC6_V1_8812F)
#define BITS_DARF_RC6_V1_8812F                                                 \
	(BIT_MASK_DARF_RC6_V1_8812F << BIT_SHIFT_DARF_RC6_V1_8812F)
#define BIT_CLEAR_DARF_RC6_V1_8812F(x) ((x) & (~BITS_DARF_RC6_V1_8812F))
#define BIT_GET_DARF_RC6_V1_8812F(x)                                           \
	(((x) >> BIT_SHIFT_DARF_RC6_V1_8812F) & BIT_MASK_DARF_RC6_V1_8812F)
#define BIT_SET_DARF_RC6_V1_8812F(x, v)                                        \
	(BIT_CLEAR_DARF_RC6_V1_8812F(x) | BIT_DARF_RC6_V1_8812F(v))

#define BIT_SHIFT_DARF_RC5_V1_8812F 0
#define BIT_MASK_DARF_RC5_V1_8812F 0x1f
#define BIT_DARF_RC5_V1_8812F(x)                                               \
	(((x) & BIT_MASK_DARF_RC5_V1_8812F) << BIT_SHIFT_DARF_RC5_V1_8812F)
#define BITS_DARF_RC5_V1_8812F                                                 \
	(BIT_MASK_DARF_RC5_V1_8812F << BIT_SHIFT_DARF_RC5_V1_8812F)
#define BIT_CLEAR_DARF_RC5_V1_8812F(x) ((x) & (~BITS_DARF_RC5_V1_8812F))
#define BIT_GET_DARF_RC5_V1_8812F(x)                                           \
	(((x) >> BIT_SHIFT_DARF_RC5_V1_8812F) & BIT_MASK_DARF_RC5_V1_8812F)
#define BIT_SET_DARF_RC5_V1_8812F(x, v)                                        \
	(BIT_CLEAR_DARF_RC5_V1_8812F(x) | BIT_DARF_RC5_V1_8812F(v))

/* 2 REG_RARFRC_8812F */

#define BIT_SHIFT_RARF_RC4_8812F 24
#define BIT_MASK_RARF_RC4_8812F 0x1f
#define BIT_RARF_RC4_8812F(x)                                                  \
	(((x) & BIT_MASK_RARF_RC4_8812F) << BIT_SHIFT_RARF_RC4_8812F)
#define BITS_RARF_RC4_8812F                                                    \
	(BIT_MASK_RARF_RC4_8812F << BIT_SHIFT_RARF_RC4_8812F)
#define BIT_CLEAR_RARF_RC4_8812F(x) ((x) & (~BITS_RARF_RC4_8812F))
#define BIT_GET_RARF_RC4_8812F(x)                                              \
	(((x) >> BIT_SHIFT_RARF_RC4_8812F) & BIT_MASK_RARF_RC4_8812F)
#define BIT_SET_RARF_RC4_8812F(x, v)                                           \
	(BIT_CLEAR_RARF_RC4_8812F(x) | BIT_RARF_RC4_8812F(v))

#define BIT_SHIFT_RARF_RC3_8812F 16
#define BIT_MASK_RARF_RC3_8812F 0x1f
#define BIT_RARF_RC3_8812F(x)                                                  \
	(((x) & BIT_MASK_RARF_RC3_8812F) << BIT_SHIFT_RARF_RC3_8812F)
#define BITS_RARF_RC3_8812F                                                    \
	(BIT_MASK_RARF_RC3_8812F << BIT_SHIFT_RARF_RC3_8812F)
#define BIT_CLEAR_RARF_RC3_8812F(x) ((x) & (~BITS_RARF_RC3_8812F))
#define BIT_GET_RARF_RC3_8812F(x)                                              \
	(((x) >> BIT_SHIFT_RARF_RC3_8812F) & BIT_MASK_RARF_RC3_8812F)
#define BIT_SET_RARF_RC3_8812F(x, v)                                           \
	(BIT_CLEAR_RARF_RC3_8812F(x) | BIT_RARF_RC3_8812F(v))

#define BIT_SHIFT_RARF_RC2_8812F 8
#define BIT_MASK_RARF_RC2_8812F 0x1f
#define BIT_RARF_RC2_8812F(x)                                                  \
	(((x) & BIT_MASK_RARF_RC2_8812F) << BIT_SHIFT_RARF_RC2_8812F)
#define BITS_RARF_RC2_8812F                                                    \
	(BIT_MASK_RARF_RC2_8812F << BIT_SHIFT_RARF_RC2_8812F)
#define BIT_CLEAR_RARF_RC2_8812F(x) ((x) & (~BITS_RARF_RC2_8812F))
#define BIT_GET_RARF_RC2_8812F(x)                                              \
	(((x) >> BIT_SHIFT_RARF_RC2_8812F) & BIT_MASK_RARF_RC2_8812F)
#define BIT_SET_RARF_RC2_8812F(x, v)                                           \
	(BIT_CLEAR_RARF_RC2_8812F(x) | BIT_RARF_RC2_8812F(v))

#define BIT_SHIFT_RARF_RC1_8812F 0
#define BIT_MASK_RARF_RC1_8812F 0x1f
#define BIT_RARF_RC1_8812F(x)                                                  \
	(((x) & BIT_MASK_RARF_RC1_8812F) << BIT_SHIFT_RARF_RC1_8812F)
#define BITS_RARF_RC1_8812F                                                    \
	(BIT_MASK_RARF_RC1_8812F << BIT_SHIFT_RARF_RC1_8812F)
#define BIT_CLEAR_RARF_RC1_8812F(x) ((x) & (~BITS_RARF_RC1_8812F))
#define BIT_GET_RARF_RC1_8812F(x)                                              \
	(((x) >> BIT_SHIFT_RARF_RC1_8812F) & BIT_MASK_RARF_RC1_8812F)
#define BIT_SET_RARF_RC1_8812F(x, v)                                           \
	(BIT_CLEAR_RARF_RC1_8812F(x) | BIT_RARF_RC1_8812F(v))

/* 2 REG_RARFRCH_8812F */

#define BIT_SHIFT_RARF_RC8_V1_8812F 24
#define BIT_MASK_RARF_RC8_V1_8812F 0x1f
#define BIT_RARF_RC8_V1_8812F(x)                                               \
	(((x) & BIT_MASK_RARF_RC8_V1_8812F) << BIT_SHIFT_RARF_RC8_V1_8812F)
#define BITS_RARF_RC8_V1_8812F                                                 \
	(BIT_MASK_RARF_RC8_V1_8812F << BIT_SHIFT_RARF_RC8_V1_8812F)
#define BIT_CLEAR_RARF_RC8_V1_8812F(x) ((x) & (~BITS_RARF_RC8_V1_8812F))
#define BIT_GET_RARF_RC8_V1_8812F(x)                                           \
	(((x) >> BIT_SHIFT_RARF_RC8_V1_8812F) & BIT_MASK_RARF_RC8_V1_8812F)
#define BIT_SET_RARF_RC8_V1_8812F(x, v)                                        \
	(BIT_CLEAR_RARF_RC8_V1_8812F(x) | BIT_RARF_RC8_V1_8812F(v))

#define BIT_SHIFT_RARF_RC7_V1_8812F 16
#define BIT_MASK_RARF_RC7_V1_8812F 0x1f
#define BIT_RARF_RC7_V1_8812F(x)                                               \
	(((x) & BIT_MASK_RARF_RC7_V1_8812F) << BIT_SHIFT_RARF_RC7_V1_8812F)
#define BITS_RARF_RC7_V1_8812F                                                 \
	(BIT_MASK_RARF_RC7_V1_8812F << BIT_SHIFT_RARF_RC7_V1_8812F)
#define BIT_CLEAR_RARF_RC7_V1_8812F(x) ((x) & (~BITS_RARF_RC7_V1_8812F))
#define BIT_GET_RARF_RC7_V1_8812F(x)                                           \
	(((x) >> BIT_SHIFT_RARF_RC7_V1_8812F) & BIT_MASK_RARF_RC7_V1_8812F)
#define BIT_SET_RARF_RC7_V1_8812F(x, v)                                        \
	(BIT_CLEAR_RARF_RC7_V1_8812F(x) | BIT_RARF_RC7_V1_8812F(v))

#define BIT_SHIFT_RARF_RC6_V1_8812F 8
#define BIT_MASK_RARF_RC6_V1_8812F 0x1f
#define BIT_RARF_RC6_V1_8812F(x)                                               \
	(((x) & BIT_MASK_RARF_RC6_V1_8812F) << BIT_SHIFT_RARF_RC6_V1_8812F)
#define BITS_RARF_RC6_V1_8812F                                                 \
	(BIT_MASK_RARF_RC6_V1_8812F << BIT_SHIFT_RARF_RC6_V1_8812F)
#define BIT_CLEAR_RARF_RC6_V1_8812F(x) ((x) & (~BITS_RARF_RC6_V1_8812F))
#define BIT_GET_RARF_RC6_V1_8812F(x)                                           \
	(((x) >> BIT_SHIFT_RARF_RC6_V1_8812F) & BIT_MASK_RARF_RC6_V1_8812F)
#define BIT_SET_RARF_RC6_V1_8812F(x, v)                                        \
	(BIT_CLEAR_RARF_RC6_V1_8812F(x) | BIT_RARF_RC6_V1_8812F(v))

#define BIT_SHIFT_RARF_RC5_V1_8812F 0
#define BIT_MASK_RARF_RC5_V1_8812F 0x1f
#define BIT_RARF_RC5_V1_8812F(x)                                               \
	(((x) & BIT_MASK_RARF_RC5_V1_8812F) << BIT_SHIFT_RARF_RC5_V1_8812F)
#define BITS_RARF_RC5_V1_8812F                                                 \
	(BIT_MASK_RARF_RC5_V1_8812F << BIT_SHIFT_RARF_RC5_V1_8812F)
#define BIT_CLEAR_RARF_RC5_V1_8812F(x) ((x) & (~BITS_RARF_RC5_V1_8812F))
#define BIT_GET_RARF_RC5_V1_8812F(x)                                           \
	(((x) >> BIT_SHIFT_RARF_RC5_V1_8812F) & BIT_MASK_RARF_RC5_V1_8812F)
#define BIT_SET_RARF_RC5_V1_8812F(x, v)                                        \
	(BIT_CLEAR_RARF_RC5_V1_8812F(x) | BIT_RARF_RC5_V1_8812F(v))

/* 2 REG_RRSR_8812F */

#define BIT_SHIFT_RRSR_RSC_8812F 21
#define BIT_MASK_RRSR_RSC_8812F 0x3
#define BIT_RRSR_RSC_8812F(x)                                                  \
	(((x) & BIT_MASK_RRSR_RSC_8812F) << BIT_SHIFT_RRSR_RSC_8812F)
#define BITS_RRSR_RSC_8812F                                                    \
	(BIT_MASK_RRSR_RSC_8812F << BIT_SHIFT_RRSR_RSC_8812F)
#define BIT_CLEAR_RRSR_RSC_8812F(x) ((x) & (~BITS_RRSR_RSC_8812F))
#define BIT_GET_RRSR_RSC_8812F(x)                                              \
	(((x) >> BIT_SHIFT_RRSR_RSC_8812F) & BIT_MASK_RRSR_RSC_8812F)
#define BIT_SET_RRSR_RSC_8812F(x, v)                                           \
	(BIT_CLEAR_RRSR_RSC_8812F(x) | BIT_RRSR_RSC_8812F(v))

#define BIT_SHIFT_RRSC_BITMAP_8812F 0
#define BIT_MASK_RRSC_BITMAP_8812F 0xfffff
#define BIT_RRSC_BITMAP_8812F(x)                                               \
	(((x) & BIT_MASK_RRSC_BITMAP_8812F) << BIT_SHIFT_RRSC_BITMAP_8812F)
#define BITS_RRSC_BITMAP_8812F                                                 \
	(BIT_MASK_RRSC_BITMAP_8812F << BIT_SHIFT_RRSC_BITMAP_8812F)
#define BIT_CLEAR_RRSC_BITMAP_8812F(x) ((x) & (~BITS_RRSC_BITMAP_8812F))
#define BIT_GET_RRSC_BITMAP_8812F(x)                                           \
	(((x) >> BIT_SHIFT_RRSC_BITMAP_8812F) & BIT_MASK_RRSC_BITMAP_8812F)
#define BIT_SET_RRSC_BITMAP_8812F(x, v)                                        \
	(BIT_CLEAR_RRSC_BITMAP_8812F(x) | BIT_RRSC_BITMAP_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_ARFR0_8812F */

#define BIT_SHIFT_ARFRL0_8812F 0
#define BIT_MASK_ARFRL0_8812F 0xffffffffL
#define BIT_ARFRL0_8812F(x)                                                    \
	(((x) & BIT_MASK_ARFRL0_8812F) << BIT_SHIFT_ARFRL0_8812F)
#define BITS_ARFRL0_8812F (BIT_MASK_ARFRL0_8812F << BIT_SHIFT_ARFRL0_8812F)
#define BIT_CLEAR_ARFRL0_8812F(x) ((x) & (~BITS_ARFRL0_8812F))
#define BIT_GET_ARFRL0_8812F(x)                                                \
	(((x) >> BIT_SHIFT_ARFRL0_8812F) & BIT_MASK_ARFRL0_8812F)
#define BIT_SET_ARFRL0_8812F(x, v)                                             \
	(BIT_CLEAR_ARFRL0_8812F(x) | BIT_ARFRL0_8812F(v))

/* 2 REG_ARFRH0_8812F */

#define BIT_SHIFT_ARFRH0_8812F 0
#define BIT_MASK_ARFRH0_8812F 0xffffffffL
#define BIT_ARFRH0_8812F(x)                                                    \
	(((x) & BIT_MASK_ARFRH0_8812F) << BIT_SHIFT_ARFRH0_8812F)
#define BITS_ARFRH0_8812F (BIT_MASK_ARFRH0_8812F << BIT_SHIFT_ARFRH0_8812F)
#define BIT_CLEAR_ARFRH0_8812F(x) ((x) & (~BITS_ARFRH0_8812F))
#define BIT_GET_ARFRH0_8812F(x)                                                \
	(((x) >> BIT_SHIFT_ARFRH0_8812F) & BIT_MASK_ARFRH0_8812F)
#define BIT_SET_ARFRH0_8812F(x, v)                                             \
	(BIT_CLEAR_ARFRH0_8812F(x) | BIT_ARFRH0_8812F(v))

/* 2 REG_ARFR1_V1_8812F */

#define BIT_SHIFT_ARFRL1_8812F 0
#define BIT_MASK_ARFRL1_8812F 0xffffffffL
#define BIT_ARFRL1_8812F(x)                                                    \
	(((x) & BIT_MASK_ARFRL1_8812F) << BIT_SHIFT_ARFRL1_8812F)
#define BITS_ARFRL1_8812F (BIT_MASK_ARFRL1_8812F << BIT_SHIFT_ARFRL1_8812F)
#define BIT_CLEAR_ARFRL1_8812F(x) ((x) & (~BITS_ARFRL1_8812F))
#define BIT_GET_ARFRL1_8812F(x)                                                \
	(((x) >> BIT_SHIFT_ARFRL1_8812F) & BIT_MASK_ARFRL1_8812F)
#define BIT_SET_ARFRL1_8812F(x, v)                                             \
	(BIT_CLEAR_ARFRL1_8812F(x) | BIT_ARFRL1_8812F(v))

/* 2 REG_ARFRH1_V1_8812F */

#define BIT_SHIFT_ARFRH1_8812F 0
#define BIT_MASK_ARFRH1_8812F 0xffffffffL
#define BIT_ARFRH1_8812F(x)                                                    \
	(((x) & BIT_MASK_ARFRH1_8812F) << BIT_SHIFT_ARFRH1_8812F)
#define BITS_ARFRH1_8812F (BIT_MASK_ARFRH1_8812F << BIT_SHIFT_ARFRH1_8812F)
#define BIT_CLEAR_ARFRH1_8812F(x) ((x) & (~BITS_ARFRH1_8812F))
#define BIT_GET_ARFRH1_8812F(x)                                                \
	(((x) >> BIT_SHIFT_ARFRH1_8812F) & BIT_MASK_ARFRH1_8812F)
#define BIT_SET_ARFRH1_8812F(x, v)                                             \
	(BIT_CLEAR_ARFRH1_8812F(x) | BIT_ARFRH1_8812F(v))

/* 2 REG_CCK_CHECK_8812F */
#define BIT_CHECK_CCK_EN_8812F BIT(7)
#define BIT_EN_BCN_PKT_REL_8812F BIT(6)
#define BIT_BCN_PORT_SEL_8812F BIT(5)
#define BIT_MOREDATA_BYPASS_8812F BIT(4)
#define BIT_EN_CLR_CMD_REL_BCN_PKT_8812F BIT(3)
#define BIT_R_EN_SET_MOREDATA_8812F BIT(2)
#define BIT__R_DIS_CLEAR_MACID_RELEASE_8812F BIT(1)
#define BIT__R_MACID_RELEASE_EN_8812F BIT(0)

/* 2 REG_AMPDU_MAX_TIME_V1_8812F */

#define BIT_SHIFT_AMPDU_MAX_TIME_8812F 0
#define BIT_MASK_AMPDU_MAX_TIME_8812F 0xff
#define BIT_AMPDU_MAX_TIME_8812F(x)                                            \
	(((x) & BIT_MASK_AMPDU_MAX_TIME_8812F)                                 \
	 << BIT_SHIFT_AMPDU_MAX_TIME_8812F)
#define BITS_AMPDU_MAX_TIME_8812F                                              \
	(BIT_MASK_AMPDU_MAX_TIME_8812F << BIT_SHIFT_AMPDU_MAX_TIME_8812F)
#define BIT_CLEAR_AMPDU_MAX_TIME_8812F(x) ((x) & (~BITS_AMPDU_MAX_TIME_8812F))
#define BIT_GET_AMPDU_MAX_TIME_8812F(x)                                        \
	(((x) >> BIT_SHIFT_AMPDU_MAX_TIME_8812F) &                             \
	 BIT_MASK_AMPDU_MAX_TIME_8812F)
#define BIT_SET_AMPDU_MAX_TIME_8812F(x, v)                                     \
	(BIT_CLEAR_AMPDU_MAX_TIME_8812F(x) | BIT_AMPDU_MAX_TIME_8812F(v))

/* 2 REG_BCNQ1_BDNY_V1_8812F */

#define BIT_SHIFT_BCNQ1_PGBNDY_V1_8812F 0
#define BIT_MASK_BCNQ1_PGBNDY_V1_8812F 0xfff
#define BIT_BCNQ1_PGBNDY_V1_8812F(x)                                           \
	(((x) & BIT_MASK_BCNQ1_PGBNDY_V1_8812F)                                \
	 << BIT_SHIFT_BCNQ1_PGBNDY_V1_8812F)
#define BITS_BCNQ1_PGBNDY_V1_8812F                                             \
	(BIT_MASK_BCNQ1_PGBNDY_V1_8812F << BIT_SHIFT_BCNQ1_PGBNDY_V1_8812F)
#define BIT_CLEAR_BCNQ1_PGBNDY_V1_8812F(x) ((x) & (~BITS_BCNQ1_PGBNDY_V1_8812F))
#define BIT_GET_BCNQ1_PGBNDY_V1_8812F(x)                                       \
	(((x) >> BIT_SHIFT_BCNQ1_PGBNDY_V1_8812F) &                            \
	 BIT_MASK_BCNQ1_PGBNDY_V1_8812F)
#define BIT_SET_BCNQ1_PGBNDY_V1_8812F(x, v)                                    \
	(BIT_CLEAR_BCNQ1_PGBNDY_V1_8812F(x) | BIT_BCNQ1_PGBNDY_V1_8812F(v))

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_AMPDU_MAX_LENGTH_HT_8812F */

#define BIT_SHIFT_AMPDU_MAX_LENGTH_HT_8812F 0
#define BIT_MASK_AMPDU_MAX_LENGTH_HT_8812F 0xffff
#define BIT_AMPDU_MAX_LENGTH_HT_8812F(x)                                       \
	(((x) & BIT_MASK_AMPDU_MAX_LENGTH_HT_8812F)                            \
	 << BIT_SHIFT_AMPDU_MAX_LENGTH_HT_8812F)
#define BITS_AMPDU_MAX_LENGTH_HT_8812F                                         \
	(BIT_MASK_AMPDU_MAX_LENGTH_HT_8812F                                    \
	 << BIT_SHIFT_AMPDU_MAX_LENGTH_HT_8812F)
#define BIT_CLEAR_AMPDU_MAX_LENGTH_HT_8812F(x)                                 \
	((x) & (~BITS_AMPDU_MAX_LENGTH_HT_8812F))
#define BIT_GET_AMPDU_MAX_LENGTH_HT_8812F(x)                                   \
	(((x) >> BIT_SHIFT_AMPDU_MAX_LENGTH_HT_8812F) &                        \
	 BIT_MASK_AMPDU_MAX_LENGTH_HT_8812F)
#define BIT_SET_AMPDU_MAX_LENGTH_HT_8812F(x, v)                                \
	(BIT_CLEAR_AMPDU_MAX_LENGTH_HT_8812F(x) |                              \
	 BIT_AMPDU_MAX_LENGTH_HT_8812F(v))

/* 2 REG_ACQ_STOP_8812F */
#define BIT_AC7Q_STOP_8812F BIT(7)
#define BIT_AC6Q_STOP_8812F BIT(6)
#define BIT_AC5Q_STOP_8812F BIT(5)
#define BIT_AC4Q_STOP_8812F BIT(4)
#define BIT_AC3Q_STOP_8812F BIT(3)
#define BIT_AC2Q_STOP_8812F BIT(2)
#define BIT_AC1Q_STOP_8812F BIT(1)
#define BIT_AC0Q_STOP_8812F BIT(0)

/* 2 REG_NDPA_RATE_8812F */

#define BIT_SHIFT_R_NDPA_RATE_V1_8812F 0
#define BIT_MASK_R_NDPA_RATE_V1_8812F 0xff
#define BIT_R_NDPA_RATE_V1_8812F(x)                                            \
	(((x) & BIT_MASK_R_NDPA_RATE_V1_8812F)                                 \
	 << BIT_SHIFT_R_NDPA_RATE_V1_8812F)
#define BITS_R_NDPA_RATE_V1_8812F                                              \
	(BIT_MASK_R_NDPA_RATE_V1_8812F << BIT_SHIFT_R_NDPA_RATE_V1_8812F)
#define BIT_CLEAR_R_NDPA_RATE_V1_8812F(x) ((x) & (~BITS_R_NDPA_RATE_V1_8812F))
#define BIT_GET_R_NDPA_RATE_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_R_NDPA_RATE_V1_8812F) &                             \
	 BIT_MASK_R_NDPA_RATE_V1_8812F)
#define BIT_SET_R_NDPA_RATE_V1_8812F(x, v)                                     \
	(BIT_CLEAR_R_NDPA_RATE_V1_8812F(x) | BIT_R_NDPA_RATE_V1_8812F(v))

/* 2 REG_TX_HANG_CTRL_8812F */
#define BIT_R_EN_GNT_BT_AWAKE_8812F BIT(3)
#define BIT_EN_EOF_V1_8812F BIT(2)
#define BIT_DIS_OQT_BLOCK_8812F BIT(1)
#define BIT_SEARCH_QUEUE_EN_8812F BIT(0)

/* 2 REG_NDPA_OPT_CTRL_8812F */
#define BIT_R_DIS_MACID_RELEASE_RTY_8812F BIT(5)

#define BIT_SHIFT_BW_SIGTA_8812F 3
#define BIT_MASK_BW_SIGTA_8812F 0x3
#define BIT_BW_SIGTA_8812F(x)                                                  \
	(((x) & BIT_MASK_BW_SIGTA_8812F) << BIT_SHIFT_BW_SIGTA_8812F)
#define BITS_BW_SIGTA_8812F                                                    \
	(BIT_MASK_BW_SIGTA_8812F << BIT_SHIFT_BW_SIGTA_8812F)
#define BIT_CLEAR_BW_SIGTA_8812F(x) ((x) & (~BITS_BW_SIGTA_8812F))
#define BIT_GET_BW_SIGTA_8812F(x)                                              \
	(((x) >> BIT_SHIFT_BW_SIGTA_8812F) & BIT_MASK_BW_SIGTA_8812F)
#define BIT_SET_BW_SIGTA_8812F(x, v)                                           \
	(BIT_CLEAR_BW_SIGTA_8812F(x) | BIT_BW_SIGTA_8812F(v))

#define BIT_EN_BAR_SIGTA_8812F BIT(2)

#define BIT_SHIFT_R_NDPA_BW_8812F 0
#define BIT_MASK_R_NDPA_BW_8812F 0x3
#define BIT_R_NDPA_BW_8812F(x)                                                 \
	(((x) & BIT_MASK_R_NDPA_BW_8812F) << BIT_SHIFT_R_NDPA_BW_8812F)
#define BITS_R_NDPA_BW_8812F                                                   \
	(BIT_MASK_R_NDPA_BW_8812F << BIT_SHIFT_R_NDPA_BW_8812F)
#define BIT_CLEAR_R_NDPA_BW_8812F(x) ((x) & (~BITS_R_NDPA_BW_8812F))
#define BIT_GET_R_NDPA_BW_8812F(x)                                             \
	(((x) >> BIT_SHIFT_R_NDPA_BW_8812F) & BIT_MASK_R_NDPA_BW_8812F)
#define BIT_SET_R_NDPA_BW_8812F(x, v)                                          \
	(BIT_CLEAR_R_NDPA_BW_8812F(x) | BIT_R_NDPA_BW_8812F(v))

/* 2 REG_AMPDU_MAX_LENGTH_VHT_8812F */

#define BIT_SHIFT_AMPDU_MAX_LENGTH_VHT_V1_8812F 0
#define BIT_MASK_AMPDU_MAX_LENGTH_VHT_V1_8812F 0xfffff
#define BIT_AMPDU_MAX_LENGTH_VHT_V1_8812F(x)                                   \
	(((x) & BIT_MASK_AMPDU_MAX_LENGTH_VHT_V1_8812F)                        \
	 << BIT_SHIFT_AMPDU_MAX_LENGTH_VHT_V1_8812F)
#define BITS_AMPDU_MAX_LENGTH_VHT_V1_8812F                                     \
	(BIT_MASK_AMPDU_MAX_LENGTH_VHT_V1_8812F                                \
	 << BIT_SHIFT_AMPDU_MAX_LENGTH_VHT_V1_8812F)
#define BIT_CLEAR_AMPDU_MAX_LENGTH_VHT_V1_8812F(x)                             \
	((x) & (~BITS_AMPDU_MAX_LENGTH_VHT_V1_8812F))
#define BIT_GET_AMPDU_MAX_LENGTH_VHT_V1_8812F(x)                               \
	(((x) >> BIT_SHIFT_AMPDU_MAX_LENGTH_VHT_V1_8812F) &                    \
	 BIT_MASK_AMPDU_MAX_LENGTH_VHT_V1_8812F)
#define BIT_SET_AMPDU_MAX_LENGTH_VHT_V1_8812F(x, v)                            \
	(BIT_CLEAR_AMPDU_MAX_LENGTH_VHT_V1_8812F(x) |                          \
	 BIT_AMPDU_MAX_LENGTH_VHT_V1_8812F(v))

/* 2 REG_RD_RESP_PKT_TH_8812F */

#define BIT_SHIFT_RD_RESP_PKT_TH_V1_8812F 0
#define BIT_MASK_RD_RESP_PKT_TH_V1_8812F 0x3f
#define BIT_RD_RESP_PKT_TH_V1_8812F(x)                                         \
	(((x) & BIT_MASK_RD_RESP_PKT_TH_V1_8812F)                              \
	 << BIT_SHIFT_RD_RESP_PKT_TH_V1_8812F)
#define BITS_RD_RESP_PKT_TH_V1_8812F                                           \
	(BIT_MASK_RD_RESP_PKT_TH_V1_8812F << BIT_SHIFT_RD_RESP_PKT_TH_V1_8812F)
#define BIT_CLEAR_RD_RESP_PKT_TH_V1_8812F(x)                                   \
	((x) & (~BITS_RD_RESP_PKT_TH_V1_8812F))
#define BIT_GET_RD_RESP_PKT_TH_V1_8812F(x)                                     \
	(((x) >> BIT_SHIFT_RD_RESP_PKT_TH_V1_8812F) &                          \
	 BIT_MASK_RD_RESP_PKT_TH_V1_8812F)
#define BIT_SET_RD_RESP_PKT_TH_V1_8812F(x, v)                                  \
	(BIT_CLEAR_RD_RESP_PKT_TH_V1_8812F(x) | BIT_RD_RESP_PKT_TH_V1_8812F(v))

/* 2 REG_CMDQ_INFO_8812F */

#define BIT_SHIFT_QUEUEMACID_CMDQ_V1_8812F 25
#define BIT_MASK_QUEUEMACID_CMDQ_V1_8812F 0x7f
#define BIT_QUEUEMACID_CMDQ_V1_8812F(x)                                        \
	(((x) & BIT_MASK_QUEUEMACID_CMDQ_V1_8812F)                             \
	 << BIT_SHIFT_QUEUEMACID_CMDQ_V1_8812F)
#define BITS_QUEUEMACID_CMDQ_V1_8812F                                          \
	(BIT_MASK_QUEUEMACID_CMDQ_V1_8812F                                     \
	 << BIT_SHIFT_QUEUEMACID_CMDQ_V1_8812F)
#define BIT_CLEAR_QUEUEMACID_CMDQ_V1_8812F(x)                                  \
	((x) & (~BITS_QUEUEMACID_CMDQ_V1_8812F))
#define BIT_GET_QUEUEMACID_CMDQ_V1_8812F(x)                                    \
	(((x) >> BIT_SHIFT_QUEUEMACID_CMDQ_V1_8812F) &                         \
	 BIT_MASK_QUEUEMACID_CMDQ_V1_8812F)
#define BIT_SET_QUEUEMACID_CMDQ_V1_8812F(x, v)                                 \
	(BIT_CLEAR_QUEUEMACID_CMDQ_V1_8812F(x) |                               \
	 BIT_QUEUEMACID_CMDQ_V1_8812F(v))

#define BIT_SHIFT_QUEUEAC_CMDQ_V1_8812F 23
#define BIT_MASK_QUEUEAC_CMDQ_V1_8812F 0x3
#define BIT_QUEUEAC_CMDQ_V1_8812F(x)                                           \
	(((x) & BIT_MASK_QUEUEAC_CMDQ_V1_8812F)                                \
	 << BIT_SHIFT_QUEUEAC_CMDQ_V1_8812F)
#define BITS_QUEUEAC_CMDQ_V1_8812F                                             \
	(BIT_MASK_QUEUEAC_CMDQ_V1_8812F << BIT_SHIFT_QUEUEAC_CMDQ_V1_8812F)
#define BIT_CLEAR_QUEUEAC_CMDQ_V1_8812F(x) ((x) & (~BITS_QUEUEAC_CMDQ_V1_8812F))
#define BIT_GET_QUEUEAC_CMDQ_V1_8812F(x)                                       \
	(((x) >> BIT_SHIFT_QUEUEAC_CMDQ_V1_8812F) &                            \
	 BIT_MASK_QUEUEAC_CMDQ_V1_8812F)
#define BIT_SET_QUEUEAC_CMDQ_V1_8812F(x, v)                                    \
	(BIT_CLEAR_QUEUEAC_CMDQ_V1_8812F(x) | BIT_QUEUEAC_CMDQ_V1_8812F(v))

#define BIT_TIDEMPTY_CMDQ_V1_8812F BIT(22)

#define BIT_SHIFT_TAIL_PKT_Q4_V2_8812F 11
#define BIT_MASK_TAIL_PKT_Q4_V2_8812F 0x7ff
#define BIT_TAIL_PKT_Q4_V2_8812F(x)                                            \
	(((x) & BIT_MASK_TAIL_PKT_Q4_V2_8812F)                                 \
	 << BIT_SHIFT_TAIL_PKT_Q4_V2_8812F)
#define BITS_TAIL_PKT_Q4_V2_8812F                                              \
	(BIT_MASK_TAIL_PKT_Q4_V2_8812F << BIT_SHIFT_TAIL_PKT_Q4_V2_8812F)
#define BIT_CLEAR_TAIL_PKT_Q4_V2_8812F(x) ((x) & (~BITS_TAIL_PKT_Q4_V2_8812F))
#define BIT_GET_TAIL_PKT_Q4_V2_8812F(x)                                        \
	(((x) >> BIT_SHIFT_TAIL_PKT_Q4_V2_8812F) &                             \
	 BIT_MASK_TAIL_PKT_Q4_V2_8812F)
#define BIT_SET_TAIL_PKT_Q4_V2_8812F(x, v)                                     \
	(BIT_CLEAR_TAIL_PKT_Q4_V2_8812F(x) | BIT_TAIL_PKT_Q4_V2_8812F(v))

#define BIT_SHIFT_HEAD_PKT_CMDQ_V1_8812F 0
#define BIT_MASK_HEAD_PKT_CMDQ_V1_8812F 0x7ff
#define BIT_HEAD_PKT_CMDQ_V1_8812F(x)                                          \
	(((x) & BIT_MASK_HEAD_PKT_CMDQ_V1_8812F)                               \
	 << BIT_SHIFT_HEAD_PKT_CMDQ_V1_8812F)
#define BITS_HEAD_PKT_CMDQ_V1_8812F                                            \
	(BIT_MASK_HEAD_PKT_CMDQ_V1_8812F << BIT_SHIFT_HEAD_PKT_CMDQ_V1_8812F)
#define BIT_CLEAR_HEAD_PKT_CMDQ_V1_8812F(x)                                    \
	((x) & (~BITS_HEAD_PKT_CMDQ_V1_8812F))
#define BIT_GET_HEAD_PKT_CMDQ_V1_8812F(x)                                      \
	(((x) >> BIT_SHIFT_HEAD_PKT_CMDQ_V1_8812F) &                           \
	 BIT_MASK_HEAD_PKT_CMDQ_V1_8812F)
#define BIT_SET_HEAD_PKT_CMDQ_V1_8812F(x, v)                                   \
	(BIT_CLEAR_HEAD_PKT_CMDQ_V1_8812F(x) | BIT_HEAD_PKT_CMDQ_V1_8812F(v))

/* 2 REG_Q4_INFO_8812F */

#define BIT_SHIFT_QUEUEMACID_Q4_V1_8812F 25
#define BIT_MASK_QUEUEMACID_Q4_V1_8812F 0x7f
#define BIT_QUEUEMACID_Q4_V1_8812F(x)                                          \
	(((x) & BIT_MASK_QUEUEMACID_Q4_V1_8812F)                               \
	 << BIT_SHIFT_QUEUEMACID_Q4_V1_8812F)
#define BITS_QUEUEMACID_Q4_V1_8812F                                            \
	(BIT_MASK_QUEUEMACID_Q4_V1_8812F << BIT_SHIFT_QUEUEMACID_Q4_V1_8812F)
#define BIT_CLEAR_QUEUEMACID_Q4_V1_8812F(x)                                    \
	((x) & (~BITS_QUEUEMACID_Q4_V1_8812F))
#define BIT_GET_QUEUEMACID_Q4_V1_8812F(x)                                      \
	(((x) >> BIT_SHIFT_QUEUEMACID_Q4_V1_8812F) &                           \
	 BIT_MASK_QUEUEMACID_Q4_V1_8812F)
#define BIT_SET_QUEUEMACID_Q4_V1_8812F(x, v)                                   \
	(BIT_CLEAR_QUEUEMACID_Q4_V1_8812F(x) | BIT_QUEUEMACID_Q4_V1_8812F(v))

#define BIT_SHIFT_QUEUEAC_Q4_V1_8812F 23
#define BIT_MASK_QUEUEAC_Q4_V1_8812F 0x3
#define BIT_QUEUEAC_Q4_V1_8812F(x)                                             \
	(((x) & BIT_MASK_QUEUEAC_Q4_V1_8812F) << BIT_SHIFT_QUEUEAC_Q4_V1_8812F)
#define BITS_QUEUEAC_Q4_V1_8812F                                               \
	(BIT_MASK_QUEUEAC_Q4_V1_8812F << BIT_SHIFT_QUEUEAC_Q4_V1_8812F)
#define BIT_CLEAR_QUEUEAC_Q4_V1_8812F(x) ((x) & (~BITS_QUEUEAC_Q4_V1_8812F))
#define BIT_GET_QUEUEAC_Q4_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_QUEUEAC_Q4_V1_8812F) & BIT_MASK_QUEUEAC_Q4_V1_8812F)
#define BIT_SET_QUEUEAC_Q4_V1_8812F(x, v)                                      \
	(BIT_CLEAR_QUEUEAC_Q4_V1_8812F(x) | BIT_QUEUEAC_Q4_V1_8812F(v))

#define BIT_TIDEMPTY_Q4_V1_8812F BIT(22)

#define BIT_SHIFT_TAIL_PKT_Q4_V2_8812F 11
#define BIT_MASK_TAIL_PKT_Q4_V2_8812F 0x7ff
#define BIT_TAIL_PKT_Q4_V2_8812F(x)                                            \
	(((x) & BIT_MASK_TAIL_PKT_Q4_V2_8812F)                                 \
	 << BIT_SHIFT_TAIL_PKT_Q4_V2_8812F)
#define BITS_TAIL_PKT_Q4_V2_8812F                                              \
	(BIT_MASK_TAIL_PKT_Q4_V2_8812F << BIT_SHIFT_TAIL_PKT_Q4_V2_8812F)
#define BIT_CLEAR_TAIL_PKT_Q4_V2_8812F(x) ((x) & (~BITS_TAIL_PKT_Q4_V2_8812F))
#define BIT_GET_TAIL_PKT_Q4_V2_8812F(x)                                        \
	(((x) >> BIT_SHIFT_TAIL_PKT_Q4_V2_8812F) &                             \
	 BIT_MASK_TAIL_PKT_Q4_V2_8812F)
#define BIT_SET_TAIL_PKT_Q4_V2_8812F(x, v)                                     \
	(BIT_CLEAR_TAIL_PKT_Q4_V2_8812F(x) | BIT_TAIL_PKT_Q4_V2_8812F(v))

#define BIT_SHIFT_HEAD_PKT_Q4_V1_8812F 0
#define BIT_MASK_HEAD_PKT_Q4_V1_8812F 0x7ff
#define BIT_HEAD_PKT_Q4_V1_8812F(x)                                            \
	(((x) & BIT_MASK_HEAD_PKT_Q4_V1_8812F)                                 \
	 << BIT_SHIFT_HEAD_PKT_Q4_V1_8812F)
#define BITS_HEAD_PKT_Q4_V1_8812F                                              \
	(BIT_MASK_HEAD_PKT_Q4_V1_8812F << BIT_SHIFT_HEAD_PKT_Q4_V1_8812F)
#define BIT_CLEAR_HEAD_PKT_Q4_V1_8812F(x) ((x) & (~BITS_HEAD_PKT_Q4_V1_8812F))
#define BIT_GET_HEAD_PKT_Q4_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HEAD_PKT_Q4_V1_8812F) &                             \
	 BIT_MASK_HEAD_PKT_Q4_V1_8812F)
#define BIT_SET_HEAD_PKT_Q4_V1_8812F(x, v)                                     \
	(BIT_CLEAR_HEAD_PKT_Q4_V1_8812F(x) | BIT_HEAD_PKT_Q4_V1_8812F(v))

/* 2 REG_Q5_INFO_8812F */

#define BIT_SHIFT_QUEUEMACID_Q5_V1_8812F 25
#define BIT_MASK_QUEUEMACID_Q5_V1_8812F 0x7f
#define BIT_QUEUEMACID_Q5_V1_8812F(x)                                          \
	(((x) & BIT_MASK_QUEUEMACID_Q5_V1_8812F)                               \
	 << BIT_SHIFT_QUEUEMACID_Q5_V1_8812F)
#define BITS_QUEUEMACID_Q5_V1_8812F                                            \
	(BIT_MASK_QUEUEMACID_Q5_V1_8812F << BIT_SHIFT_QUEUEMACID_Q5_V1_8812F)
#define BIT_CLEAR_QUEUEMACID_Q5_V1_8812F(x)                                    \
	((x) & (~BITS_QUEUEMACID_Q5_V1_8812F))
#define BIT_GET_QUEUEMACID_Q5_V1_8812F(x)                                      \
	(((x) >> BIT_SHIFT_QUEUEMACID_Q5_V1_8812F) &                           \
	 BIT_MASK_QUEUEMACID_Q5_V1_8812F)
#define BIT_SET_QUEUEMACID_Q5_V1_8812F(x, v)                                   \
	(BIT_CLEAR_QUEUEMACID_Q5_V1_8812F(x) | BIT_QUEUEMACID_Q5_V1_8812F(v))

#define BIT_SHIFT_QUEUEAC_Q5_V1_8812F 23
#define BIT_MASK_QUEUEAC_Q5_V1_8812F 0x3
#define BIT_QUEUEAC_Q5_V1_8812F(x)                                             \
	(((x) & BIT_MASK_QUEUEAC_Q5_V1_8812F) << BIT_SHIFT_QUEUEAC_Q5_V1_8812F)
#define BITS_QUEUEAC_Q5_V1_8812F                                               \
	(BIT_MASK_QUEUEAC_Q5_V1_8812F << BIT_SHIFT_QUEUEAC_Q5_V1_8812F)
#define BIT_CLEAR_QUEUEAC_Q5_V1_8812F(x) ((x) & (~BITS_QUEUEAC_Q5_V1_8812F))
#define BIT_GET_QUEUEAC_Q5_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_QUEUEAC_Q5_V1_8812F) & BIT_MASK_QUEUEAC_Q5_V1_8812F)
#define BIT_SET_QUEUEAC_Q5_V1_8812F(x, v)                                      \
	(BIT_CLEAR_QUEUEAC_Q5_V1_8812F(x) | BIT_QUEUEAC_Q5_V1_8812F(v))

#define BIT_TIDEMPTY_Q5_V1_8812F BIT(22)

#define BIT_SHIFT_TAIL_PKT_Q5_V2_8812F 11
#define BIT_MASK_TAIL_PKT_Q5_V2_8812F 0x7ff
#define BIT_TAIL_PKT_Q5_V2_8812F(x)                                            \
	(((x) & BIT_MASK_TAIL_PKT_Q5_V2_8812F)                                 \
	 << BIT_SHIFT_TAIL_PKT_Q5_V2_8812F)
#define BITS_TAIL_PKT_Q5_V2_8812F                                              \
	(BIT_MASK_TAIL_PKT_Q5_V2_8812F << BIT_SHIFT_TAIL_PKT_Q5_V2_8812F)
#define BIT_CLEAR_TAIL_PKT_Q5_V2_8812F(x) ((x) & (~BITS_TAIL_PKT_Q5_V2_8812F))
#define BIT_GET_TAIL_PKT_Q5_V2_8812F(x)                                        \
	(((x) >> BIT_SHIFT_TAIL_PKT_Q5_V2_8812F) &                             \
	 BIT_MASK_TAIL_PKT_Q5_V2_8812F)
#define BIT_SET_TAIL_PKT_Q5_V2_8812F(x, v)                                     \
	(BIT_CLEAR_TAIL_PKT_Q5_V2_8812F(x) | BIT_TAIL_PKT_Q5_V2_8812F(v))

#define BIT_SHIFT_HEAD_PKT_Q5_V1_8812F 0
#define BIT_MASK_HEAD_PKT_Q5_V1_8812F 0x7ff
#define BIT_HEAD_PKT_Q5_V1_8812F(x)                                            \
	(((x) & BIT_MASK_HEAD_PKT_Q5_V1_8812F)                                 \
	 << BIT_SHIFT_HEAD_PKT_Q5_V1_8812F)
#define BITS_HEAD_PKT_Q5_V1_8812F                                              \
	(BIT_MASK_HEAD_PKT_Q5_V1_8812F << BIT_SHIFT_HEAD_PKT_Q5_V1_8812F)
#define BIT_CLEAR_HEAD_PKT_Q5_V1_8812F(x) ((x) & (~BITS_HEAD_PKT_Q5_V1_8812F))
#define BIT_GET_HEAD_PKT_Q5_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HEAD_PKT_Q5_V1_8812F) &                             \
	 BIT_MASK_HEAD_PKT_Q5_V1_8812F)
#define BIT_SET_HEAD_PKT_Q5_V1_8812F(x, v)                                     \
	(BIT_CLEAR_HEAD_PKT_Q5_V1_8812F(x) | BIT_HEAD_PKT_Q5_V1_8812F(v))

/* 2 REG_Q6_INFO_8812F */

#define BIT_SHIFT_QUEUEMACID_Q6_V1_8812F 25
#define BIT_MASK_QUEUEMACID_Q6_V1_8812F 0x7f
#define BIT_QUEUEMACID_Q6_V1_8812F(x)                                          \
	(((x) & BIT_MASK_QUEUEMACID_Q6_V1_8812F)                               \
	 << BIT_SHIFT_QUEUEMACID_Q6_V1_8812F)
#define BITS_QUEUEMACID_Q6_V1_8812F                                            \
	(BIT_MASK_QUEUEMACID_Q6_V1_8812F << BIT_SHIFT_QUEUEMACID_Q6_V1_8812F)
#define BIT_CLEAR_QUEUEMACID_Q6_V1_8812F(x)                                    \
	((x) & (~BITS_QUEUEMACID_Q6_V1_8812F))
#define BIT_GET_QUEUEMACID_Q6_V1_8812F(x)                                      \
	(((x) >> BIT_SHIFT_QUEUEMACID_Q6_V1_8812F) &                           \
	 BIT_MASK_QUEUEMACID_Q6_V1_8812F)
#define BIT_SET_QUEUEMACID_Q6_V1_8812F(x, v)                                   \
	(BIT_CLEAR_QUEUEMACID_Q6_V1_8812F(x) | BIT_QUEUEMACID_Q6_V1_8812F(v))

#define BIT_SHIFT_QUEUEAC_Q6_V1_8812F 23
#define BIT_MASK_QUEUEAC_Q6_V1_8812F 0x3
#define BIT_QUEUEAC_Q6_V1_8812F(x)                                             \
	(((x) & BIT_MASK_QUEUEAC_Q6_V1_8812F) << BIT_SHIFT_QUEUEAC_Q6_V1_8812F)
#define BITS_QUEUEAC_Q6_V1_8812F                                               \
	(BIT_MASK_QUEUEAC_Q6_V1_8812F << BIT_SHIFT_QUEUEAC_Q6_V1_8812F)
#define BIT_CLEAR_QUEUEAC_Q6_V1_8812F(x) ((x) & (~BITS_QUEUEAC_Q6_V1_8812F))
#define BIT_GET_QUEUEAC_Q6_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_QUEUEAC_Q6_V1_8812F) & BIT_MASK_QUEUEAC_Q6_V1_8812F)
#define BIT_SET_QUEUEAC_Q6_V1_8812F(x, v)                                      \
	(BIT_CLEAR_QUEUEAC_Q6_V1_8812F(x) | BIT_QUEUEAC_Q6_V1_8812F(v))

#define BIT_TIDEMPTY_Q6_V1_8812F BIT(22)

#define BIT_SHIFT_TAIL_PKT_Q6_V2_8812F 11
#define BIT_MASK_TAIL_PKT_Q6_V2_8812F 0x7ff
#define BIT_TAIL_PKT_Q6_V2_8812F(x)                                            \
	(((x) & BIT_MASK_TAIL_PKT_Q6_V2_8812F)                                 \
	 << BIT_SHIFT_TAIL_PKT_Q6_V2_8812F)
#define BITS_TAIL_PKT_Q6_V2_8812F                                              \
	(BIT_MASK_TAIL_PKT_Q6_V2_8812F << BIT_SHIFT_TAIL_PKT_Q6_V2_8812F)
#define BIT_CLEAR_TAIL_PKT_Q6_V2_8812F(x) ((x) & (~BITS_TAIL_PKT_Q6_V2_8812F))
#define BIT_GET_TAIL_PKT_Q6_V2_8812F(x)                                        \
	(((x) >> BIT_SHIFT_TAIL_PKT_Q6_V2_8812F) &                             \
	 BIT_MASK_TAIL_PKT_Q6_V2_8812F)
#define BIT_SET_TAIL_PKT_Q6_V2_8812F(x, v)                                     \
	(BIT_CLEAR_TAIL_PKT_Q6_V2_8812F(x) | BIT_TAIL_PKT_Q6_V2_8812F(v))

#define BIT_SHIFT_HEAD_PKT_Q6_V1_8812F 0
#define BIT_MASK_HEAD_PKT_Q6_V1_8812F 0x7ff
#define BIT_HEAD_PKT_Q6_V1_8812F(x)                                            \
	(((x) & BIT_MASK_HEAD_PKT_Q6_V1_8812F)                                 \
	 << BIT_SHIFT_HEAD_PKT_Q6_V1_8812F)
#define BITS_HEAD_PKT_Q6_V1_8812F                                              \
	(BIT_MASK_HEAD_PKT_Q6_V1_8812F << BIT_SHIFT_HEAD_PKT_Q6_V1_8812F)
#define BIT_CLEAR_HEAD_PKT_Q6_V1_8812F(x) ((x) & (~BITS_HEAD_PKT_Q6_V1_8812F))
#define BIT_GET_HEAD_PKT_Q6_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HEAD_PKT_Q6_V1_8812F) &                             \
	 BIT_MASK_HEAD_PKT_Q6_V1_8812F)
#define BIT_SET_HEAD_PKT_Q6_V1_8812F(x, v)                                     \
	(BIT_CLEAR_HEAD_PKT_Q6_V1_8812F(x) | BIT_HEAD_PKT_Q6_V1_8812F(v))

/* 2 REG_Q7_INFO_8812F */

#define BIT_SHIFT_QUEUEMACID_Q7_V1_8812F 25
#define BIT_MASK_QUEUEMACID_Q7_V1_8812F 0x7f
#define BIT_QUEUEMACID_Q7_V1_8812F(x)                                          \
	(((x) & BIT_MASK_QUEUEMACID_Q7_V1_8812F)                               \
	 << BIT_SHIFT_QUEUEMACID_Q7_V1_8812F)
#define BITS_QUEUEMACID_Q7_V1_8812F                                            \
	(BIT_MASK_QUEUEMACID_Q7_V1_8812F << BIT_SHIFT_QUEUEMACID_Q7_V1_8812F)
#define BIT_CLEAR_QUEUEMACID_Q7_V1_8812F(x)                                    \
	((x) & (~BITS_QUEUEMACID_Q7_V1_8812F))
#define BIT_GET_QUEUEMACID_Q7_V1_8812F(x)                                      \
	(((x) >> BIT_SHIFT_QUEUEMACID_Q7_V1_8812F) &                           \
	 BIT_MASK_QUEUEMACID_Q7_V1_8812F)
#define BIT_SET_QUEUEMACID_Q7_V1_8812F(x, v)                                   \
	(BIT_CLEAR_QUEUEMACID_Q7_V1_8812F(x) | BIT_QUEUEMACID_Q7_V1_8812F(v))

#define BIT_SHIFT_QUEUEAC_Q7_V1_8812F 23
#define BIT_MASK_QUEUEAC_Q7_V1_8812F 0x3
#define BIT_QUEUEAC_Q7_V1_8812F(x)                                             \
	(((x) & BIT_MASK_QUEUEAC_Q7_V1_8812F) << BIT_SHIFT_QUEUEAC_Q7_V1_8812F)
#define BITS_QUEUEAC_Q7_V1_8812F                                               \
	(BIT_MASK_QUEUEAC_Q7_V1_8812F << BIT_SHIFT_QUEUEAC_Q7_V1_8812F)
#define BIT_CLEAR_QUEUEAC_Q7_V1_8812F(x) ((x) & (~BITS_QUEUEAC_Q7_V1_8812F))
#define BIT_GET_QUEUEAC_Q7_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_QUEUEAC_Q7_V1_8812F) & BIT_MASK_QUEUEAC_Q7_V1_8812F)
#define BIT_SET_QUEUEAC_Q7_V1_8812F(x, v)                                      \
	(BIT_CLEAR_QUEUEAC_Q7_V1_8812F(x) | BIT_QUEUEAC_Q7_V1_8812F(v))

#define BIT_TIDEMPTY_Q7_V1_8812F BIT(22)

#define BIT_SHIFT_TAIL_PKT_Q7_V2_8812F 11
#define BIT_MASK_TAIL_PKT_Q7_V2_8812F 0x7ff
#define BIT_TAIL_PKT_Q7_V2_8812F(x)                                            \
	(((x) & BIT_MASK_TAIL_PKT_Q7_V2_8812F)                                 \
	 << BIT_SHIFT_TAIL_PKT_Q7_V2_8812F)
#define BITS_TAIL_PKT_Q7_V2_8812F                                              \
	(BIT_MASK_TAIL_PKT_Q7_V2_8812F << BIT_SHIFT_TAIL_PKT_Q7_V2_8812F)
#define BIT_CLEAR_TAIL_PKT_Q7_V2_8812F(x) ((x) & (~BITS_TAIL_PKT_Q7_V2_8812F))
#define BIT_GET_TAIL_PKT_Q7_V2_8812F(x)                                        \
	(((x) >> BIT_SHIFT_TAIL_PKT_Q7_V2_8812F) &                             \
	 BIT_MASK_TAIL_PKT_Q7_V2_8812F)
#define BIT_SET_TAIL_PKT_Q7_V2_8812F(x, v)                                     \
	(BIT_CLEAR_TAIL_PKT_Q7_V2_8812F(x) | BIT_TAIL_PKT_Q7_V2_8812F(v))

#define BIT_SHIFT_HEAD_PKT_Q7_V1_8812F 0
#define BIT_MASK_HEAD_PKT_Q7_V1_8812F 0x7ff
#define BIT_HEAD_PKT_Q7_V1_8812F(x)                                            \
	(((x) & BIT_MASK_HEAD_PKT_Q7_V1_8812F)                                 \
	 << BIT_SHIFT_HEAD_PKT_Q7_V1_8812F)
#define BITS_HEAD_PKT_Q7_V1_8812F                                              \
	(BIT_MASK_HEAD_PKT_Q7_V1_8812F << BIT_SHIFT_HEAD_PKT_Q7_V1_8812F)
#define BIT_CLEAR_HEAD_PKT_Q7_V1_8812F(x) ((x) & (~BITS_HEAD_PKT_Q7_V1_8812F))
#define BIT_GET_HEAD_PKT_Q7_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_HEAD_PKT_Q7_V1_8812F) &                             \
	 BIT_MASK_HEAD_PKT_Q7_V1_8812F)
#define BIT_SET_HEAD_PKT_Q7_V1_8812F(x, v)                                     \
	(BIT_CLEAR_HEAD_PKT_Q7_V1_8812F(x) | BIT_HEAD_PKT_Q7_V1_8812F(v))

/* 2 REG_WMAC_LBK_BUF_HD_V1_8812F */

#define BIT_SHIFT_WMAC_LBK_BUF_HEAD_V1_8812F 0
#define BIT_MASK_WMAC_LBK_BUF_HEAD_V1_8812F 0xfff
#define BIT_WMAC_LBK_BUF_HEAD_V1_8812F(x)                                      \
	(((x) & BIT_MASK_WMAC_LBK_BUF_HEAD_V1_8812F)                           \
	 << BIT_SHIFT_WMAC_LBK_BUF_HEAD_V1_8812F)
#define BITS_WMAC_LBK_BUF_HEAD_V1_8812F                                        \
	(BIT_MASK_WMAC_LBK_BUF_HEAD_V1_8812F                                   \
	 << BIT_SHIFT_WMAC_LBK_BUF_HEAD_V1_8812F)
#define BIT_CLEAR_WMAC_LBK_BUF_HEAD_V1_8812F(x)                                \
	((x) & (~BITS_WMAC_LBK_BUF_HEAD_V1_8812F))
#define BIT_GET_WMAC_LBK_BUF_HEAD_V1_8812F(x)                                  \
	(((x) >> BIT_SHIFT_WMAC_LBK_BUF_HEAD_V1_8812F) &                       \
	 BIT_MASK_WMAC_LBK_BUF_HEAD_V1_8812F)
#define BIT_SET_WMAC_LBK_BUF_HEAD_V1_8812F(x, v)                               \
	(BIT_CLEAR_WMAC_LBK_BUF_HEAD_V1_8812F(x) |                             \
	 BIT_WMAC_LBK_BUF_HEAD_V1_8812F(v))

/* 2 REG_MGQ_BDNY_V1_8812F */

#define BIT_SHIFT_MGQ_PGBNDY_V1_8812F 0
#define BIT_MASK_MGQ_PGBNDY_V1_8812F 0xfff
#define BIT_MGQ_PGBNDY_V1_8812F(x)                                             \
	(((x) & BIT_MASK_MGQ_PGBNDY_V1_8812F) << BIT_SHIFT_MGQ_PGBNDY_V1_8812F)
#define BITS_MGQ_PGBNDY_V1_8812F                                               \
	(BIT_MASK_MGQ_PGBNDY_V1_8812F << BIT_SHIFT_MGQ_PGBNDY_V1_8812F)
#define BIT_CLEAR_MGQ_PGBNDY_V1_8812F(x) ((x) & (~BITS_MGQ_PGBNDY_V1_8812F))
#define BIT_GET_MGQ_PGBNDY_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_MGQ_PGBNDY_V1_8812F) & BIT_MASK_MGQ_PGBNDY_V1_8812F)
#define BIT_SET_MGQ_PGBNDY_V1_8812F(x, v)                                      \
	(BIT_CLEAR_MGQ_PGBNDY_V1_8812F(x) | BIT_MGQ_PGBNDY_V1_8812F(v))

/* 2 REG_TXRPT_CTRL_8812F */

#define BIT_SHIFT_TRXRPT_TIMER_TH_8812F 24
#define BIT_MASK_TRXRPT_TIMER_TH_8812F 0xff
#define BIT_TRXRPT_TIMER_TH_8812F(x)                                           \
	(((x) & BIT_MASK_TRXRPT_TIMER_TH_8812F)                                \
	 << BIT_SHIFT_TRXRPT_TIMER_TH_8812F)
#define BITS_TRXRPT_TIMER_TH_8812F                                             \
	(BIT_MASK_TRXRPT_TIMER_TH_8812F << BIT_SHIFT_TRXRPT_TIMER_TH_8812F)
#define BIT_CLEAR_TRXRPT_TIMER_TH_8812F(x) ((x) & (~BITS_TRXRPT_TIMER_TH_8812F))
#define BIT_GET_TRXRPT_TIMER_TH_8812F(x)                                       \
	(((x) >> BIT_SHIFT_TRXRPT_TIMER_TH_8812F) &                            \
	 BIT_MASK_TRXRPT_TIMER_TH_8812F)
#define BIT_SET_TRXRPT_TIMER_TH_8812F(x, v)                                    \
	(BIT_CLEAR_TRXRPT_TIMER_TH_8812F(x) | BIT_TRXRPT_TIMER_TH_8812F(v))

#define BIT_SHIFT_TRXRPT_LEN_TH_8812F 16
#define BIT_MASK_TRXRPT_LEN_TH_8812F 0xff
#define BIT_TRXRPT_LEN_TH_8812F(x)                                             \
	(((x) & BIT_MASK_TRXRPT_LEN_TH_8812F) << BIT_SHIFT_TRXRPT_LEN_TH_8812F)
#define BITS_TRXRPT_LEN_TH_8812F                                               \
	(BIT_MASK_TRXRPT_LEN_TH_8812F << BIT_SHIFT_TRXRPT_LEN_TH_8812F)
#define BIT_CLEAR_TRXRPT_LEN_TH_8812F(x) ((x) & (~BITS_TRXRPT_LEN_TH_8812F))
#define BIT_GET_TRXRPT_LEN_TH_8812F(x)                                         \
	(((x) >> BIT_SHIFT_TRXRPT_LEN_TH_8812F) & BIT_MASK_TRXRPT_LEN_TH_8812F)
#define BIT_SET_TRXRPT_LEN_TH_8812F(x, v)                                      \
	(BIT_CLEAR_TRXRPT_LEN_TH_8812F(x) | BIT_TRXRPT_LEN_TH_8812F(v))

#define BIT_SHIFT_TRXRPT_READ_PTR_8812F 8
#define BIT_MASK_TRXRPT_READ_PTR_8812F 0xff
#define BIT_TRXRPT_READ_PTR_8812F(x)                                           \
	(((x) & BIT_MASK_TRXRPT_READ_PTR_8812F)                                \
	 << BIT_SHIFT_TRXRPT_READ_PTR_8812F)
#define BITS_TRXRPT_READ_PTR_8812F                                             \
	(BIT_MASK_TRXRPT_READ_PTR_8812F << BIT_SHIFT_TRXRPT_READ_PTR_8812F)
#define BIT_CLEAR_TRXRPT_READ_PTR_8812F(x) ((x) & (~BITS_TRXRPT_READ_PTR_8812F))
#define BIT_GET_TRXRPT_READ_PTR_8812F(x)                                       \
	(((x) >> BIT_SHIFT_TRXRPT_READ_PTR_8812F) &                            \
	 BIT_MASK_TRXRPT_READ_PTR_8812F)
#define BIT_SET_TRXRPT_READ_PTR_8812F(x, v)                                    \
	(BIT_CLEAR_TRXRPT_READ_PTR_8812F(x) | BIT_TRXRPT_READ_PTR_8812F(v))

#define BIT_SHIFT_TRXRPT_WRITE_PTR_8812F 0
#define BIT_MASK_TRXRPT_WRITE_PTR_8812F 0xff
#define BIT_TRXRPT_WRITE_PTR_8812F(x)                                          \
	(((x) & BIT_MASK_TRXRPT_WRITE_PTR_8812F)                               \
	 << BIT_SHIFT_TRXRPT_WRITE_PTR_8812F)
#define BITS_TRXRPT_WRITE_PTR_8812F                                            \
	(BIT_MASK_TRXRPT_WRITE_PTR_8812F << BIT_SHIFT_TRXRPT_WRITE_PTR_8812F)
#define BIT_CLEAR_TRXRPT_WRITE_PTR_8812F(x)                                    \
	((x) & (~BITS_TRXRPT_WRITE_PTR_8812F))
#define BIT_GET_TRXRPT_WRITE_PTR_8812F(x)                                      \
	(((x) >> BIT_SHIFT_TRXRPT_WRITE_PTR_8812F) &                           \
	 BIT_MASK_TRXRPT_WRITE_PTR_8812F)
#define BIT_SET_TRXRPT_WRITE_PTR_8812F(x, v)                                   \
	(BIT_CLEAR_TRXRPT_WRITE_PTR_8812F(x) | BIT_TRXRPT_WRITE_PTR_8812F(v))

/* 2 REG_INIRTS_RATE_SEL_8812F */
#define BIT_LEAG_RTS_BW_DUP_8812F BIT(5)

/* 2 REG_BASIC_CFEND_RATE_8812F */

#define BIT_SHIFT_BASIC_CFEND_RATE_8812F 0
#define BIT_MASK_BASIC_CFEND_RATE_8812F 0x1f
#define BIT_BASIC_CFEND_RATE_8812F(x)                                          \
	(((x) & BIT_MASK_BASIC_CFEND_RATE_8812F)                               \
	 << BIT_SHIFT_BASIC_CFEND_RATE_8812F)
#define BITS_BASIC_CFEND_RATE_8812F                                            \
	(BIT_MASK_BASIC_CFEND_RATE_8812F << BIT_SHIFT_BASIC_CFEND_RATE_8812F)
#define BIT_CLEAR_BASIC_CFEND_RATE_8812F(x)                                    \
	((x) & (~BITS_BASIC_CFEND_RATE_8812F))
#define BIT_GET_BASIC_CFEND_RATE_8812F(x)                                      \
	(((x) >> BIT_SHIFT_BASIC_CFEND_RATE_8812F) &                           \
	 BIT_MASK_BASIC_CFEND_RATE_8812F)
#define BIT_SET_BASIC_CFEND_RATE_8812F(x, v)                                   \
	(BIT_CLEAR_BASIC_CFEND_RATE_8812F(x) | BIT_BASIC_CFEND_RATE_8812F(v))

/* 2 REG_STBC_CFEND_RATE_8812F */

#define BIT_SHIFT_STBC_CFEND_RATE_8812F 0
#define BIT_MASK_STBC_CFEND_RATE_8812F 0x1f
#define BIT_STBC_CFEND_RATE_8812F(x)                                           \
	(((x) & BIT_MASK_STBC_CFEND_RATE_8812F)                                \
	 << BIT_SHIFT_STBC_CFEND_RATE_8812F)
#define BITS_STBC_CFEND_RATE_8812F                                             \
	(BIT_MASK_STBC_CFEND_RATE_8812F << BIT_SHIFT_STBC_CFEND_RATE_8812F)
#define BIT_CLEAR_STBC_CFEND_RATE_8812F(x) ((x) & (~BITS_STBC_CFEND_RATE_8812F))
#define BIT_GET_STBC_CFEND_RATE_8812F(x)                                       \
	(((x) >> BIT_SHIFT_STBC_CFEND_RATE_8812F) &                            \
	 BIT_MASK_STBC_CFEND_RATE_8812F)
#define BIT_SET_STBC_CFEND_RATE_8812F(x, v)                                    \
	(BIT_CLEAR_STBC_CFEND_RATE_8812F(x) | BIT_STBC_CFEND_RATE_8812F(v))

/* 2 REG_DATA_SC_8812F */

#define BIT_SHIFT_TXSC_40M_8812F 4
#define BIT_MASK_TXSC_40M_8812F 0xf
#define BIT_TXSC_40M_8812F(x)                                                  \
	(((x) & BIT_MASK_TXSC_40M_8812F) << BIT_SHIFT_TXSC_40M_8812F)
#define BITS_TXSC_40M_8812F                                                    \
	(BIT_MASK_TXSC_40M_8812F << BIT_SHIFT_TXSC_40M_8812F)
#define BIT_CLEAR_TXSC_40M_8812F(x) ((x) & (~BITS_TXSC_40M_8812F))
#define BIT_GET_TXSC_40M_8812F(x)                                              \
	(((x) >> BIT_SHIFT_TXSC_40M_8812F) & BIT_MASK_TXSC_40M_8812F)
#define BIT_SET_TXSC_40M_8812F(x, v)                                           \
	(BIT_CLEAR_TXSC_40M_8812F(x) | BIT_TXSC_40M_8812F(v))

#define BIT_SHIFT_TXSC_20M_8812F 0
#define BIT_MASK_TXSC_20M_8812F 0xf
#define BIT_TXSC_20M_8812F(x)                                                  \
	(((x) & BIT_MASK_TXSC_20M_8812F) << BIT_SHIFT_TXSC_20M_8812F)
#define BITS_TXSC_20M_8812F                                                    \
	(BIT_MASK_TXSC_20M_8812F << BIT_SHIFT_TXSC_20M_8812F)
#define BIT_CLEAR_TXSC_20M_8812F(x) ((x) & (~BITS_TXSC_20M_8812F))
#define BIT_GET_TXSC_20M_8812F(x)                                              \
	(((x) >> BIT_SHIFT_TXSC_20M_8812F) & BIT_MASK_TXSC_20M_8812F)
#define BIT_SET_TXSC_20M_8812F(x, v)                                           \
	(BIT_CLEAR_TXSC_20M_8812F(x) | BIT_TXSC_20M_8812F(v))

/* 2 REG_MACID_SLEEP3_8812F */

#define BIT_SHIFT_MACID127_96_PKTSLEEP_8812F 0
#define BIT_MASK_MACID127_96_PKTSLEEP_8812F 0xffffffffL
#define BIT_MACID127_96_PKTSLEEP_8812F(x)                                      \
	(((x) & BIT_MASK_MACID127_96_PKTSLEEP_8812F)                           \
	 << BIT_SHIFT_MACID127_96_PKTSLEEP_8812F)
#define BITS_MACID127_96_PKTSLEEP_8812F                                        \
	(BIT_MASK_MACID127_96_PKTSLEEP_8812F                                   \
	 << BIT_SHIFT_MACID127_96_PKTSLEEP_8812F)
#define BIT_CLEAR_MACID127_96_PKTSLEEP_8812F(x)                                \
	((x) & (~BITS_MACID127_96_PKTSLEEP_8812F))
#define BIT_GET_MACID127_96_PKTSLEEP_8812F(x)                                  \
	(((x) >> BIT_SHIFT_MACID127_96_PKTSLEEP_8812F) &                       \
	 BIT_MASK_MACID127_96_PKTSLEEP_8812F)
#define BIT_SET_MACID127_96_PKTSLEEP_8812F(x, v)                               \
	(BIT_CLEAR_MACID127_96_PKTSLEEP_8812F(x) |                             \
	 BIT_MACID127_96_PKTSLEEP_8812F(v))

/* 2 REG_MACID_SLEEP1_8812F */

#define BIT_SHIFT_MACID63_32_PKTSLEEP_8812F 0
#define BIT_MASK_MACID63_32_PKTSLEEP_8812F 0xffffffffL
#define BIT_MACID63_32_PKTSLEEP_8812F(x)                                       \
	(((x) & BIT_MASK_MACID63_32_PKTSLEEP_8812F)                            \
	 << BIT_SHIFT_MACID63_32_PKTSLEEP_8812F)
#define BITS_MACID63_32_PKTSLEEP_8812F                                         \
	(BIT_MASK_MACID63_32_PKTSLEEP_8812F                                    \
	 << BIT_SHIFT_MACID63_32_PKTSLEEP_8812F)
#define BIT_CLEAR_MACID63_32_PKTSLEEP_8812F(x)                                 \
	((x) & (~BITS_MACID63_32_PKTSLEEP_8812F))
#define BIT_GET_MACID63_32_PKTSLEEP_8812F(x)                                   \
	(((x) >> BIT_SHIFT_MACID63_32_PKTSLEEP_8812F) &                        \
	 BIT_MASK_MACID63_32_PKTSLEEP_8812F)
#define BIT_SET_MACID63_32_PKTSLEEP_8812F(x, v)                                \
	(BIT_CLEAR_MACID63_32_PKTSLEEP_8812F(x) |                              \
	 BIT_MACID63_32_PKTSLEEP_8812F(v))

/* 2 REG_ARFR2_V1_8812F */

#define BIT_SHIFT_ARFRL2_8812F 0
#define BIT_MASK_ARFRL2_8812F 0xffffffffL
#define BIT_ARFRL2_8812F(x)                                                    \
	(((x) & BIT_MASK_ARFRL2_8812F) << BIT_SHIFT_ARFRL2_8812F)
#define BITS_ARFRL2_8812F (BIT_MASK_ARFRL2_8812F << BIT_SHIFT_ARFRL2_8812F)
#define BIT_CLEAR_ARFRL2_8812F(x) ((x) & (~BITS_ARFRL2_8812F))
#define BIT_GET_ARFRL2_8812F(x)                                                \
	(((x) >> BIT_SHIFT_ARFRL2_8812F) & BIT_MASK_ARFRL2_8812F)
#define BIT_SET_ARFRL2_8812F(x, v)                                             \
	(BIT_CLEAR_ARFRL2_8812F(x) | BIT_ARFRL2_8812F(v))

/* 2 REG_ARFRH2_V1_8812F */

#define BIT_SHIFT_ARFRH2_8812F 0
#define BIT_MASK_ARFRH2_8812F 0xffffffffL
#define BIT_ARFRH2_8812F(x)                                                    \
	(((x) & BIT_MASK_ARFRH2_8812F) << BIT_SHIFT_ARFRH2_8812F)
#define BITS_ARFRH2_8812F (BIT_MASK_ARFRH2_8812F << BIT_SHIFT_ARFRH2_8812F)
#define BIT_CLEAR_ARFRH2_8812F(x) ((x) & (~BITS_ARFRH2_8812F))
#define BIT_GET_ARFRH2_8812F(x)                                                \
	(((x) >> BIT_SHIFT_ARFRH2_8812F) & BIT_MASK_ARFRH2_8812F)
#define BIT_SET_ARFRH2_8812F(x, v)                                             \
	(BIT_CLEAR_ARFRH2_8812F(x) | BIT_ARFRH2_8812F(v))

/* 2 REG_ARFR3_V1_8812F */

#define BIT_SHIFT_ARFRL3_8812F 0
#define BIT_MASK_ARFRL3_8812F 0xffffffffL
#define BIT_ARFRL3_8812F(x)                                                    \
	(((x) & BIT_MASK_ARFRL3_8812F) << BIT_SHIFT_ARFRL3_8812F)
#define BITS_ARFRL3_8812F (BIT_MASK_ARFRL3_8812F << BIT_SHIFT_ARFRL3_8812F)
#define BIT_CLEAR_ARFRL3_8812F(x) ((x) & (~BITS_ARFRL3_8812F))
#define BIT_GET_ARFRL3_8812F(x)                                                \
	(((x) >> BIT_SHIFT_ARFRL3_8812F) & BIT_MASK_ARFRL3_8812F)
#define BIT_SET_ARFRL3_8812F(x, v)                                             \
	(BIT_CLEAR_ARFRL3_8812F(x) | BIT_ARFRL3_8812F(v))

/* 2 REG_ARFRH3_V1_8812F */

#define BIT_SHIFT_ARFRH3_8812F 0
#define BIT_MASK_ARFRH3_8812F 0xffffffffL
#define BIT_ARFRH3_8812F(x)                                                    \
	(((x) & BIT_MASK_ARFRH3_8812F) << BIT_SHIFT_ARFRH3_8812F)
#define BITS_ARFRH3_8812F (BIT_MASK_ARFRH3_8812F << BIT_SHIFT_ARFRH3_8812F)
#define BIT_CLEAR_ARFRH3_8812F(x) ((x) & (~BITS_ARFRH3_8812F))
#define BIT_GET_ARFRH3_8812F(x)                                                \
	(((x) >> BIT_SHIFT_ARFRH3_8812F) & BIT_MASK_ARFRH3_8812F)
#define BIT_SET_ARFRH3_8812F(x, v)                                             \
	(BIT_CLEAR_ARFRH3_8812F(x) | BIT_ARFRH3_8812F(v))

/* 2 REG_ARFR4_8812F */

#define BIT_SHIFT_ARFRL4_8812F 0
#define BIT_MASK_ARFRL4_8812F 0xffffffffL
#define BIT_ARFRL4_8812F(x)                                                    \
	(((x) & BIT_MASK_ARFRL4_8812F) << BIT_SHIFT_ARFRL4_8812F)
#define BITS_ARFRL4_8812F (BIT_MASK_ARFRL4_8812F << BIT_SHIFT_ARFRL4_8812F)
#define BIT_CLEAR_ARFRL4_8812F(x) ((x) & (~BITS_ARFRL4_8812F))
#define BIT_GET_ARFRL4_8812F(x)                                                \
	(((x) >> BIT_SHIFT_ARFRL4_8812F) & BIT_MASK_ARFRL4_8812F)
#define BIT_SET_ARFRL4_8812F(x, v)                                             \
	(BIT_CLEAR_ARFRL4_8812F(x) | BIT_ARFRL4_8812F(v))

/* 2 REG_ARFRH4_8812F */

#define BIT_SHIFT_ARFRH4_8812F 0
#define BIT_MASK_ARFRH4_8812F 0xffffffffL
#define BIT_ARFRH4_8812F(x)                                                    \
	(((x) & BIT_MASK_ARFRH4_8812F) << BIT_SHIFT_ARFRH4_8812F)
#define BITS_ARFRH4_8812F (BIT_MASK_ARFRH4_8812F << BIT_SHIFT_ARFRH4_8812F)
#define BIT_CLEAR_ARFRH4_8812F(x) ((x) & (~BITS_ARFRH4_8812F))
#define BIT_GET_ARFRH4_8812F(x)                                                \
	(((x) >> BIT_SHIFT_ARFRH4_8812F) & BIT_MASK_ARFRH4_8812F)
#define BIT_SET_ARFRH4_8812F(x, v)                                             \
	(BIT_CLEAR_ARFRH4_8812F(x) | BIT_ARFRH4_8812F(v))

/* 2 REG_ARFR5_8812F */

#define BIT_SHIFT_ARFRL5_8812F 0
#define BIT_MASK_ARFRL5_8812F 0xffffffffL
#define BIT_ARFRL5_8812F(x)                                                    \
	(((x) & BIT_MASK_ARFRL5_8812F) << BIT_SHIFT_ARFRL5_8812F)
#define BITS_ARFRL5_8812F (BIT_MASK_ARFRL5_8812F << BIT_SHIFT_ARFRL5_8812F)
#define BIT_CLEAR_ARFRL5_8812F(x) ((x) & (~BITS_ARFRL5_8812F))
#define BIT_GET_ARFRL5_8812F(x)                                                \
	(((x) >> BIT_SHIFT_ARFRL5_8812F) & BIT_MASK_ARFRL5_8812F)
#define BIT_SET_ARFRL5_8812F(x, v)                                             \
	(BIT_CLEAR_ARFRL5_8812F(x) | BIT_ARFRL5_8812F(v))

/* 2 REG_ARFRH5_8812F */

#define BIT_SHIFT_ARFRH5_8812F 0
#define BIT_MASK_ARFRH5_8812F 0xffffffffL
#define BIT_ARFRH5_8812F(x)                                                    \
	(((x) & BIT_MASK_ARFRH5_8812F) << BIT_SHIFT_ARFRH5_8812F)
#define BITS_ARFRH5_8812F (BIT_MASK_ARFRH5_8812F << BIT_SHIFT_ARFRH5_8812F)
#define BIT_CLEAR_ARFRH5_8812F(x) ((x) & (~BITS_ARFRH5_8812F))
#define BIT_GET_ARFRH5_8812F(x)                                                \
	(((x) >> BIT_SHIFT_ARFRH5_8812F) & BIT_MASK_ARFRH5_8812F)
#define BIT_SET_ARFRH5_8812F(x, v)                                             \
	(BIT_CLEAR_ARFRH5_8812F(x) | BIT_ARFRH5_8812F(v))

/* 2 REG_TXRPT_START_OFFSET_8812F */

#define BIT_SHIFT_MACID_MURATE_OFFSET_8812F 24
#define BIT_MASK_MACID_MURATE_OFFSET_8812F 0xff
#define BIT_MACID_MURATE_OFFSET_8812F(x)                                       \
	(((x) & BIT_MASK_MACID_MURATE_OFFSET_8812F)                            \
	 << BIT_SHIFT_MACID_MURATE_OFFSET_8812F)
#define BITS_MACID_MURATE_OFFSET_8812F                                         \
	(BIT_MASK_MACID_MURATE_OFFSET_8812F                                    \
	 << BIT_SHIFT_MACID_MURATE_OFFSET_8812F)
#define BIT_CLEAR_MACID_MURATE_OFFSET_8812F(x)                                 \
	((x) & (~BITS_MACID_MURATE_OFFSET_8812F))
#define BIT_GET_MACID_MURATE_OFFSET_8812F(x)                                   \
	(((x) >> BIT_SHIFT_MACID_MURATE_OFFSET_8812F) &                        \
	 BIT_MASK_MACID_MURATE_OFFSET_8812F)
#define BIT_SET_MACID_MURATE_OFFSET_8812F(x, v)                                \
	(BIT_CLEAR_MACID_MURATE_OFFSET_8812F(x) |                              \
	 BIT_MACID_MURATE_OFFSET_8812F(v))

#define BIT_SHIFT_TXRPT_MISS_COUNT_8812F 17
#define BIT_MASK_TXRPT_MISS_COUNT_8812F 0x7
#define BIT_TXRPT_MISS_COUNT_8812F(x)                                          \
	(((x) & BIT_MASK_TXRPT_MISS_COUNT_8812F)                               \
	 << BIT_SHIFT_TXRPT_MISS_COUNT_8812F)
#define BITS_TXRPT_MISS_COUNT_8812F                                            \
	(BIT_MASK_TXRPT_MISS_COUNT_8812F << BIT_SHIFT_TXRPT_MISS_COUNT_8812F)
#define BIT_CLEAR_TXRPT_MISS_COUNT_8812F(x)                                    \
	((x) & (~BITS_TXRPT_MISS_COUNT_8812F))
#define BIT_GET_TXRPT_MISS_COUNT_8812F(x)                                      \
	(((x) >> BIT_SHIFT_TXRPT_MISS_COUNT_8812F) &                           \
	 BIT_MASK_TXRPT_MISS_COUNT_8812F)
#define BIT_SET_TXRPT_MISS_COUNT_8812F(x, v)                                   \
	(BIT_CLEAR_TXRPT_MISS_COUNT_8812F(x) | BIT_TXRPT_MISS_COUNT_8812F(v))

#define BIT_RPTFIFO_SIZE_OPT_8812F BIT(16)

#define BIT_SHIFT_MACID_CTRL_OFFSET_8812F 8
#define BIT_MASK_MACID_CTRL_OFFSET_8812F 0xff
#define BIT_MACID_CTRL_OFFSET_8812F(x)                                         \
	(((x) & BIT_MASK_MACID_CTRL_OFFSET_8812F)                              \
	 << BIT_SHIFT_MACID_CTRL_OFFSET_8812F)
#define BITS_MACID_CTRL_OFFSET_8812F                                           \
	(BIT_MASK_MACID_CTRL_OFFSET_8812F << BIT_SHIFT_MACID_CTRL_OFFSET_8812F)
#define BIT_CLEAR_MACID_CTRL_OFFSET_8812F(x)                                   \
	((x) & (~BITS_MACID_CTRL_OFFSET_8812F))
#define BIT_GET_MACID_CTRL_OFFSET_8812F(x)                                     \
	(((x) >> BIT_SHIFT_MACID_CTRL_OFFSET_8812F) &                          \
	 BIT_MASK_MACID_CTRL_OFFSET_8812F)
#define BIT_SET_MACID_CTRL_OFFSET_8812F(x, v)                                  \
	(BIT_CLEAR_MACID_CTRL_OFFSET_8812F(x) | BIT_MACID_CTRL_OFFSET_8812F(v))

#define BIT_SHIFT_AMPDU_TXRPT_OFFSET_8812F 0
#define BIT_MASK_AMPDU_TXRPT_OFFSET_8812F 0xff
#define BIT_AMPDU_TXRPT_OFFSET_8812F(x)                                        \
	(((x) & BIT_MASK_AMPDU_TXRPT_OFFSET_8812F)                             \
	 << BIT_SHIFT_AMPDU_TXRPT_OFFSET_8812F)
#define BITS_AMPDU_TXRPT_OFFSET_8812F                                          \
	(BIT_MASK_AMPDU_TXRPT_OFFSET_8812F                                     \
	 << BIT_SHIFT_AMPDU_TXRPT_OFFSET_8812F)
#define BIT_CLEAR_AMPDU_TXRPT_OFFSET_8812F(x)                                  \
	((x) & (~BITS_AMPDU_TXRPT_OFFSET_8812F))
#define BIT_GET_AMPDU_TXRPT_OFFSET_8812F(x)                                    \
	(((x) >> BIT_SHIFT_AMPDU_TXRPT_OFFSET_8812F) &                         \
	 BIT_MASK_AMPDU_TXRPT_OFFSET_8812F)
#define BIT_SET_AMPDU_TXRPT_OFFSET_8812F(x, v)                                 \
	(BIT_CLEAR_AMPDU_TXRPT_OFFSET_8812F(x) |                               \
	 BIT_AMPDU_TXRPT_OFFSET_8812F(v))

/* 2 REG_RRSR_CTS_8812F */

#define BIT_SHIFT_RRCTSSR_RSC_8812F 21
#define BIT_MASK_RRCTSSR_RSC_8812F 0x3
#define BIT_RRCTSSR_RSC_8812F(x)                                               \
	(((x) & BIT_MASK_RRCTSSR_RSC_8812F) << BIT_SHIFT_RRCTSSR_RSC_8812F)
#define BITS_RRCTSSR_RSC_8812F                                                 \
	(BIT_MASK_RRCTSSR_RSC_8812F << BIT_SHIFT_RRCTSSR_RSC_8812F)
#define BIT_CLEAR_RRCTSSR_RSC_8812F(x) ((x) & (~BITS_RRCTSSR_RSC_8812F))
#define BIT_GET_RRCTSSR_RSC_8812F(x)                                           \
	(((x) >> BIT_SHIFT_RRCTSSR_RSC_8812F) & BIT_MASK_RRCTSSR_RSC_8812F)
#define BIT_SET_RRCTSSR_RSC_8812F(x, v)                                        \
	(BIT_CLEAR_RRCTSSR_RSC_8812F(x) | BIT_RRCTSSR_RSC_8812F(v))

#define BIT_SHIFT_RRCTSSC_BITMAP_8812F 0
#define BIT_MASK_RRCTSSC_BITMAP_8812F 0xfffff
#define BIT_RRCTSSC_BITMAP_8812F(x)                                            \
	(((x) & BIT_MASK_RRCTSSC_BITMAP_8812F)                                 \
	 << BIT_SHIFT_RRCTSSC_BITMAP_8812F)
#define BITS_RRCTSSC_BITMAP_8812F                                              \
	(BIT_MASK_RRCTSSC_BITMAP_8812F << BIT_SHIFT_RRCTSSC_BITMAP_8812F)
#define BIT_CLEAR_RRCTSSC_BITMAP_8812F(x) ((x) & (~BITS_RRCTSSC_BITMAP_8812F))
#define BIT_GET_RRCTSSC_BITMAP_8812F(x)                                        \
	(((x) >> BIT_SHIFT_RRCTSSC_BITMAP_8812F) &                             \
	 BIT_MASK_RRCTSSC_BITMAP_8812F)
#define BIT_SET_RRCTSSC_BITMAP_8812F(x, v)                                     \
	(BIT_CLEAR_RRCTSSC_BITMAP_8812F(x) | BIT_RRCTSSC_BITMAP_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_POWER_STAGE1_8812F */
#define BIT_PTA_WL_PRI_MASK_CPU_MGQ_8812F BIT(31)
#define BIT_PTA_WL_PRI_MASK_BCNQ_8812F BIT(30)
#define BIT_PTA_WL_PRI_MASK_HIQ_8812F BIT(29)
#define BIT_PTA_WL_PRI_MASK_MGQ_8812F BIT(28)
#define BIT_PTA_WL_PRI_MASK_BK_8812F BIT(27)
#define BIT_PTA_WL_PRI_MASK_BE_8812F BIT(26)
#define BIT_PTA_WL_PRI_MASK_VI_8812F BIT(25)
#define BIT_PTA_WL_PRI_MASK_VO_8812F BIT(24)

#define BIT_SHIFT_POWER_STAGE1_8812F 0
#define BIT_MASK_POWER_STAGE1_8812F 0xffffff
#define BIT_POWER_STAGE1_8812F(x)                                              \
	(((x) & BIT_MASK_POWER_STAGE1_8812F) << BIT_SHIFT_POWER_STAGE1_8812F)
#define BITS_POWER_STAGE1_8812F                                                \
	(BIT_MASK_POWER_STAGE1_8812F << BIT_SHIFT_POWER_STAGE1_8812F)
#define BIT_CLEAR_POWER_STAGE1_8812F(x) ((x) & (~BITS_POWER_STAGE1_8812F))
#define BIT_GET_POWER_STAGE1_8812F(x)                                          \
	(((x) >> BIT_SHIFT_POWER_STAGE1_8812F) & BIT_MASK_POWER_STAGE1_8812F)
#define BIT_SET_POWER_STAGE1_8812F(x, v)                                       \
	(BIT_CLEAR_POWER_STAGE1_8812F(x) | BIT_POWER_STAGE1_8812F(v))

/* 2 REG_POWER_STAGE2_8812F */
#define BIT__R_CTRL_PKT_POW_ADJ_8812F BIT(24)

#define BIT_SHIFT_POWER_STAGE2_8812F 0
#define BIT_MASK_POWER_STAGE2_8812F 0xffffff
#define BIT_POWER_STAGE2_8812F(x)                                              \
	(((x) & BIT_MASK_POWER_STAGE2_8812F) << BIT_SHIFT_POWER_STAGE2_8812F)
#define BITS_POWER_STAGE2_8812F                                                \
	(BIT_MASK_POWER_STAGE2_8812F << BIT_SHIFT_POWER_STAGE2_8812F)
#define BIT_CLEAR_POWER_STAGE2_8812F(x) ((x) & (~BITS_POWER_STAGE2_8812F))
#define BIT_GET_POWER_STAGE2_8812F(x)                                          \
	(((x) >> BIT_SHIFT_POWER_STAGE2_8812F) & BIT_MASK_POWER_STAGE2_8812F)
#define BIT_SET_POWER_STAGE2_8812F(x, v)                                       \
	(BIT_CLEAR_POWER_STAGE2_8812F(x) | BIT_POWER_STAGE2_8812F(v))

/* 2 REG_SW_AMPDU_BURST_MODE_CTRL_8812F */

#define BIT_SHIFT_PAD_NUM_THRES_8812F 24
#define BIT_MASK_PAD_NUM_THRES_8812F 0x3f
#define BIT_PAD_NUM_THRES_8812F(x)                                             \
	(((x) & BIT_MASK_PAD_NUM_THRES_8812F) << BIT_SHIFT_PAD_NUM_THRES_8812F)
#define BITS_PAD_NUM_THRES_8812F                                               \
	(BIT_MASK_PAD_NUM_THRES_8812F << BIT_SHIFT_PAD_NUM_THRES_8812F)
#define BIT_CLEAR_PAD_NUM_THRES_8812F(x) ((x) & (~BITS_PAD_NUM_THRES_8812F))
#define BIT_GET_PAD_NUM_THRES_8812F(x)                                         \
	(((x) >> BIT_SHIFT_PAD_NUM_THRES_8812F) & BIT_MASK_PAD_NUM_THRES_8812F)
#define BIT_SET_PAD_NUM_THRES_8812F(x, v)                                      \
	(BIT_CLEAR_PAD_NUM_THRES_8812F(x) | BIT_PAD_NUM_THRES_8812F(v))

#define BIT_R_DMA_THIS_QUEUE_BK_8812F BIT(23)
#define BIT_R_DMA_THIS_QUEUE_BE_8812F BIT(22)
#define BIT_R_DMA_THIS_QUEUE_VI_8812F BIT(21)
#define BIT_R_DMA_THIS_QUEUE_VO_8812F BIT(20)

#define BIT_SHIFT_R_TOTAL_LEN_TH_8812F 8
#define BIT_MASK_R_TOTAL_LEN_TH_8812F 0xfff
#define BIT_R_TOTAL_LEN_TH_8812F(x)                                            \
	(((x) & BIT_MASK_R_TOTAL_LEN_TH_8812F)                                 \
	 << BIT_SHIFT_R_TOTAL_LEN_TH_8812F)
#define BITS_R_TOTAL_LEN_TH_8812F                                              \
	(BIT_MASK_R_TOTAL_LEN_TH_8812F << BIT_SHIFT_R_TOTAL_LEN_TH_8812F)
#define BIT_CLEAR_R_TOTAL_LEN_TH_8812F(x) ((x) & (~BITS_R_TOTAL_LEN_TH_8812F))
#define BIT_GET_R_TOTAL_LEN_TH_8812F(x)                                        \
	(((x) >> BIT_SHIFT_R_TOTAL_LEN_TH_8812F) &                             \
	 BIT_MASK_R_TOTAL_LEN_TH_8812F)
#define BIT_SET_R_TOTAL_LEN_TH_8812F(x, v)                                     \
	(BIT_CLEAR_R_TOTAL_LEN_TH_8812F(x) | BIT_R_TOTAL_LEN_TH_8812F(v))

#define BIT_EN_NEW_EARLY_8812F BIT(7)
#define BIT_PRE_TX_CMD_8812F BIT(6)

#define BIT_SHIFT_NUM_SCL_EN_8812F 4
#define BIT_MASK_NUM_SCL_EN_8812F 0x3
#define BIT_NUM_SCL_EN_8812F(x)                                                \
	(((x) & BIT_MASK_NUM_SCL_EN_8812F) << BIT_SHIFT_NUM_SCL_EN_8812F)
#define BITS_NUM_SCL_EN_8812F                                                  \
	(BIT_MASK_NUM_SCL_EN_8812F << BIT_SHIFT_NUM_SCL_EN_8812F)
#define BIT_CLEAR_NUM_SCL_EN_8812F(x) ((x) & (~BITS_NUM_SCL_EN_8812F))
#define BIT_GET_NUM_SCL_EN_8812F(x)                                            \
	(((x) >> BIT_SHIFT_NUM_SCL_EN_8812F) & BIT_MASK_NUM_SCL_EN_8812F)
#define BIT_SET_NUM_SCL_EN_8812F(x, v)                                         \
	(BIT_CLEAR_NUM_SCL_EN_8812F(x) | BIT_NUM_SCL_EN_8812F(v))

#define BIT_BK_EN_8812F BIT(3)
#define BIT_BE_EN_8812F BIT(2)
#define BIT_VI_EN_8812F BIT(1)
#define BIT_VO_EN_8812F BIT(0)

/* 2 REG_PKT_LIFE_TIME_8812F */

#define BIT_SHIFT_PKT_LIFTIME_BEBK_8812F 16
#define BIT_MASK_PKT_LIFTIME_BEBK_8812F 0xffff
#define BIT_PKT_LIFTIME_BEBK_8812F(x)                                          \
	(((x) & BIT_MASK_PKT_LIFTIME_BEBK_8812F)                               \
	 << BIT_SHIFT_PKT_LIFTIME_BEBK_8812F)
#define BITS_PKT_LIFTIME_BEBK_8812F                                            \
	(BIT_MASK_PKT_LIFTIME_BEBK_8812F << BIT_SHIFT_PKT_LIFTIME_BEBK_8812F)
#define BIT_CLEAR_PKT_LIFTIME_BEBK_8812F(x)                                    \
	((x) & (~BITS_PKT_LIFTIME_BEBK_8812F))
#define BIT_GET_PKT_LIFTIME_BEBK_8812F(x)                                      \
	(((x) >> BIT_SHIFT_PKT_LIFTIME_BEBK_8812F) &                           \
	 BIT_MASK_PKT_LIFTIME_BEBK_8812F)
#define BIT_SET_PKT_LIFTIME_BEBK_8812F(x, v)                                   \
	(BIT_CLEAR_PKT_LIFTIME_BEBK_8812F(x) | BIT_PKT_LIFTIME_BEBK_8812F(v))

#define BIT_SHIFT_PKT_LIFTIME_VOVI_8812F 0
#define BIT_MASK_PKT_LIFTIME_VOVI_8812F 0xffff
#define BIT_PKT_LIFTIME_VOVI_8812F(x)                                          \
	(((x) & BIT_MASK_PKT_LIFTIME_VOVI_8812F)                               \
	 << BIT_SHIFT_PKT_LIFTIME_VOVI_8812F)
#define BITS_PKT_LIFTIME_VOVI_8812F                                            \
	(BIT_MASK_PKT_LIFTIME_VOVI_8812F << BIT_SHIFT_PKT_LIFTIME_VOVI_8812F)
#define BIT_CLEAR_PKT_LIFTIME_VOVI_8812F(x)                                    \
	((x) & (~BITS_PKT_LIFTIME_VOVI_8812F))
#define BIT_GET_PKT_LIFTIME_VOVI_8812F(x)                                      \
	(((x) >> BIT_SHIFT_PKT_LIFTIME_VOVI_8812F) &                           \
	 BIT_MASK_PKT_LIFTIME_VOVI_8812F)
#define BIT_SET_PKT_LIFTIME_VOVI_8812F(x, v)                                   \
	(BIT_CLEAR_PKT_LIFTIME_VOVI_8812F(x) | BIT_PKT_LIFTIME_VOVI_8812F(v))

/* 2 REG_STBC_SETTING_8812F */

#define BIT_SHIFT_CDEND_TXTIME_L_8812F 4
#define BIT_MASK_CDEND_TXTIME_L_8812F 0xf
#define BIT_CDEND_TXTIME_L_8812F(x)                                            \
	(((x) & BIT_MASK_CDEND_TXTIME_L_8812F)                                 \
	 << BIT_SHIFT_CDEND_TXTIME_L_8812F)
#define BITS_CDEND_TXTIME_L_8812F                                              \
	(BIT_MASK_CDEND_TXTIME_L_8812F << BIT_SHIFT_CDEND_TXTIME_L_8812F)
#define BIT_CLEAR_CDEND_TXTIME_L_8812F(x) ((x) & (~BITS_CDEND_TXTIME_L_8812F))
#define BIT_GET_CDEND_TXTIME_L_8812F(x)                                        \
	(((x) >> BIT_SHIFT_CDEND_TXTIME_L_8812F) &                             \
	 BIT_MASK_CDEND_TXTIME_L_8812F)
#define BIT_SET_CDEND_TXTIME_L_8812F(x, v)                                     \
	(BIT_CLEAR_CDEND_TXTIME_L_8812F(x) | BIT_CDEND_TXTIME_L_8812F(v))

#define BIT_SHIFT_NESS_8812F 2
#define BIT_MASK_NESS_8812F 0x3
#define BIT_NESS_8812F(x) (((x) & BIT_MASK_NESS_8812F) << BIT_SHIFT_NESS_8812F)
#define BITS_NESS_8812F (BIT_MASK_NESS_8812F << BIT_SHIFT_NESS_8812F)
#define BIT_CLEAR_NESS_8812F(x) ((x) & (~BITS_NESS_8812F))
#define BIT_GET_NESS_8812F(x)                                                  \
	(((x) >> BIT_SHIFT_NESS_8812F) & BIT_MASK_NESS_8812F)
#define BIT_SET_NESS_8812F(x, v) (BIT_CLEAR_NESS_8812F(x) | BIT_NESS_8812F(v))

#define BIT_SHIFT_STBC_CFEND_8812F 0
#define BIT_MASK_STBC_CFEND_8812F 0x3
#define BIT_STBC_CFEND_8812F(x)                                                \
	(((x) & BIT_MASK_STBC_CFEND_8812F) << BIT_SHIFT_STBC_CFEND_8812F)
#define BITS_STBC_CFEND_8812F                                                  \
	(BIT_MASK_STBC_CFEND_8812F << BIT_SHIFT_STBC_CFEND_8812F)
#define BIT_CLEAR_STBC_CFEND_8812F(x) ((x) & (~BITS_STBC_CFEND_8812F))
#define BIT_GET_STBC_CFEND_8812F(x)                                            \
	(((x) >> BIT_SHIFT_STBC_CFEND_8812F) & BIT_MASK_STBC_CFEND_8812F)
#define BIT_SET_STBC_CFEND_8812F(x, v)                                         \
	(BIT_CLEAR_STBC_CFEND_8812F(x) | BIT_STBC_CFEND_8812F(v))

/* 2 REG_STBC_SETTING2_8812F */

#define BIT_SHIFT_CDEND_TXTIME_H_8812F 0
#define BIT_MASK_CDEND_TXTIME_H_8812F 0x1f
#define BIT_CDEND_TXTIME_H_8812F(x)                                            \
	(((x) & BIT_MASK_CDEND_TXTIME_H_8812F)                                 \
	 << BIT_SHIFT_CDEND_TXTIME_H_8812F)
#define BITS_CDEND_TXTIME_H_8812F                                              \
	(BIT_MASK_CDEND_TXTIME_H_8812F << BIT_SHIFT_CDEND_TXTIME_H_8812F)
#define BIT_CLEAR_CDEND_TXTIME_H_8812F(x) ((x) & (~BITS_CDEND_TXTIME_H_8812F))
#define BIT_GET_CDEND_TXTIME_H_8812F(x)                                        \
	(((x) >> BIT_SHIFT_CDEND_TXTIME_H_8812F) &                             \
	 BIT_MASK_CDEND_TXTIME_H_8812F)
#define BIT_SET_CDEND_TXTIME_H_8812F(x, v)                                     \
	(BIT_CLEAR_CDEND_TXTIME_H_8812F(x) | BIT_CDEND_TXTIME_H_8812F(v))

/* 2 REG_QUEUE_CTRL_8812F */
#define BIT_FORCE_RND_PRI_8812F BIT(6)
#define BIT_PTA_EDCCA_EN_8812F BIT(5)
#define BIT_PTA_WL_TX_EN_8812F BIT(4)
#define BIT_R_USE_DATA_BW_8812F BIT(3)
#define BIT_TRI_PKT_INT_MODE1_8812F BIT(2)
#define BIT_TRI_PKT_INT_MODE0_8812F BIT(1)
#define BIT_ACQ_MODE_SEL_8812F BIT(0)

/* 2 REG_SINGLE_AMPDU_CTRL_8812F */
#define BIT_EN_SINGLE_APMDU_8812F BIT(7)

#define BIT_SHIFT_SNDTX_MAXTIME_8812F 0
#define BIT_MASK_SNDTX_MAXTIME_8812F 0x7f
#define BIT_SNDTX_MAXTIME_8812F(x)                                             \
	(((x) & BIT_MASK_SNDTX_MAXTIME_8812F) << BIT_SHIFT_SNDTX_MAXTIME_8812F)
#define BITS_SNDTX_MAXTIME_8812F                                               \
	(BIT_MASK_SNDTX_MAXTIME_8812F << BIT_SHIFT_SNDTX_MAXTIME_8812F)
#define BIT_CLEAR_SNDTX_MAXTIME_8812F(x) ((x) & (~BITS_SNDTX_MAXTIME_8812F))
#define BIT_GET_SNDTX_MAXTIME_8812F(x)                                         \
	(((x) >> BIT_SHIFT_SNDTX_MAXTIME_8812F) & BIT_MASK_SNDTX_MAXTIME_8812F)
#define BIT_SET_SNDTX_MAXTIME_8812F(x, v)                                      \
	(BIT_CLEAR_SNDTX_MAXTIME_8812F(x) | BIT_SNDTX_MAXTIME_8812F(v))

/* 2 REG_PROT_MODE_CTRL_8812F */
#define BIT_SND_SIFS_TXDATA_8812F BIT(31)
#define BIT_TX_SND_MATCH_MACID_8812F BIT(30)

#define BIT_SHIFT_RTS_MAX_AGG_NUM_8812F 24
#define BIT_MASK_RTS_MAX_AGG_NUM_8812F 0x3f
#define BIT_RTS_MAX_AGG_NUM_8812F(x)                                           \
	(((x) & BIT_MASK_RTS_MAX_AGG_NUM_8812F)                                \
	 << BIT_SHIFT_RTS_MAX_AGG_NUM_8812F)
#define BITS_RTS_MAX_AGG_NUM_8812F                                             \
	(BIT_MASK_RTS_MAX_AGG_NUM_8812F << BIT_SHIFT_RTS_MAX_AGG_NUM_8812F)
#define BIT_CLEAR_RTS_MAX_AGG_NUM_8812F(x) ((x) & (~BITS_RTS_MAX_AGG_NUM_8812F))
#define BIT_GET_RTS_MAX_AGG_NUM_8812F(x)                                       \
	(((x) >> BIT_SHIFT_RTS_MAX_AGG_NUM_8812F) &                            \
	 BIT_MASK_RTS_MAX_AGG_NUM_8812F)
#define BIT_SET_RTS_MAX_AGG_NUM_8812F(x, v)                                    \
	(BIT_CLEAR_RTS_MAX_AGG_NUM_8812F(x) | BIT_RTS_MAX_AGG_NUM_8812F(v))

#define BIT_SHIFT_MAX_AGG_NUM_8812F 16
#define BIT_MASK_MAX_AGG_NUM_8812F 0x3f
#define BIT_MAX_AGG_NUM_8812F(x)                                               \
	(((x) & BIT_MASK_MAX_AGG_NUM_8812F) << BIT_SHIFT_MAX_AGG_NUM_8812F)
#define BITS_MAX_AGG_NUM_8812F                                                 \
	(BIT_MASK_MAX_AGG_NUM_8812F << BIT_SHIFT_MAX_AGG_NUM_8812F)
#define BIT_CLEAR_MAX_AGG_NUM_8812F(x) ((x) & (~BITS_MAX_AGG_NUM_8812F))
#define BIT_GET_MAX_AGG_NUM_8812F(x)                                           \
	(((x) >> BIT_SHIFT_MAX_AGG_NUM_8812F) & BIT_MASK_MAX_AGG_NUM_8812F)
#define BIT_SET_MAX_AGG_NUM_8812F(x, v)                                        \
	(BIT_CLEAR_MAX_AGG_NUM_8812F(x) | BIT_MAX_AGG_NUM_8812F(v))

#define BIT_SHIFT_RTS_TXTIME_TH_8812F 8
#define BIT_MASK_RTS_TXTIME_TH_8812F 0xff
#define BIT_RTS_TXTIME_TH_8812F(x)                                             \
	(((x) & BIT_MASK_RTS_TXTIME_TH_8812F) << BIT_SHIFT_RTS_TXTIME_TH_8812F)
#define BITS_RTS_TXTIME_TH_8812F                                               \
	(BIT_MASK_RTS_TXTIME_TH_8812F << BIT_SHIFT_RTS_TXTIME_TH_8812F)
#define BIT_CLEAR_RTS_TXTIME_TH_8812F(x) ((x) & (~BITS_RTS_TXTIME_TH_8812F))
#define BIT_GET_RTS_TXTIME_TH_8812F(x)                                         \
	(((x) >> BIT_SHIFT_RTS_TXTIME_TH_8812F) & BIT_MASK_RTS_TXTIME_TH_8812F)
#define BIT_SET_RTS_TXTIME_TH_8812F(x, v)                                      \
	(BIT_CLEAR_RTS_TXTIME_TH_8812F(x) | BIT_RTS_TXTIME_TH_8812F(v))

#define BIT_SHIFT_RTS_LEN_TH_8812F 0
#define BIT_MASK_RTS_LEN_TH_8812F 0xff
#define BIT_RTS_LEN_TH_8812F(x)                                                \
	(((x) & BIT_MASK_RTS_LEN_TH_8812F) << BIT_SHIFT_RTS_LEN_TH_8812F)
#define BITS_RTS_LEN_TH_8812F                                                  \
	(BIT_MASK_RTS_LEN_TH_8812F << BIT_SHIFT_RTS_LEN_TH_8812F)
#define BIT_CLEAR_RTS_LEN_TH_8812F(x) ((x) & (~BITS_RTS_LEN_TH_8812F))
#define BIT_GET_RTS_LEN_TH_8812F(x)                                            \
	(((x) >> BIT_SHIFT_RTS_LEN_TH_8812F) & BIT_MASK_RTS_LEN_TH_8812F)
#define BIT_SET_RTS_LEN_TH_8812F(x, v)                                         \
	(BIT_CLEAR_RTS_LEN_TH_8812F(x) | BIT_RTS_LEN_TH_8812F(v))

/* 2 REG_BAR_MODE_CTRL_8812F */

#define BIT_SHIFT_BAR_RTY_LMT_8812F 16
#define BIT_MASK_BAR_RTY_LMT_8812F 0x3
#define BIT_BAR_RTY_LMT_8812F(x)                                               \
	(((x) & BIT_MASK_BAR_RTY_LMT_8812F) << BIT_SHIFT_BAR_RTY_LMT_8812F)
#define BITS_BAR_RTY_LMT_8812F                                                 \
	(BIT_MASK_BAR_RTY_LMT_8812F << BIT_SHIFT_BAR_RTY_LMT_8812F)
#define BIT_CLEAR_BAR_RTY_LMT_8812F(x) ((x) & (~BITS_BAR_RTY_LMT_8812F))
#define BIT_GET_BAR_RTY_LMT_8812F(x)                                           \
	(((x) >> BIT_SHIFT_BAR_RTY_LMT_8812F) & BIT_MASK_BAR_RTY_LMT_8812F)
#define BIT_SET_BAR_RTY_LMT_8812F(x, v)                                        \
	(BIT_CLEAR_BAR_RTY_LMT_8812F(x) | BIT_BAR_RTY_LMT_8812F(v))

#define BIT_SHIFT_BAR_PKT_TXTIME_TH_8812F 8
#define BIT_MASK_BAR_PKT_TXTIME_TH_8812F 0xff
#define BIT_BAR_PKT_TXTIME_TH_8812F(x)                                         \
	(((x) & BIT_MASK_BAR_PKT_TXTIME_TH_8812F)                              \
	 << BIT_SHIFT_BAR_PKT_TXTIME_TH_8812F)
#define BITS_BAR_PKT_TXTIME_TH_8812F                                           \
	(BIT_MASK_BAR_PKT_TXTIME_TH_8812F << BIT_SHIFT_BAR_PKT_TXTIME_TH_8812F)
#define BIT_CLEAR_BAR_PKT_TXTIME_TH_8812F(x)                                   \
	((x) & (~BITS_BAR_PKT_TXTIME_TH_8812F))
#define BIT_GET_BAR_PKT_TXTIME_TH_8812F(x)                                     \
	(((x) >> BIT_SHIFT_BAR_PKT_TXTIME_TH_8812F) &                          \
	 BIT_MASK_BAR_PKT_TXTIME_TH_8812F)
#define BIT_SET_BAR_PKT_TXTIME_TH_8812F(x, v)                                  \
	(BIT_CLEAR_BAR_PKT_TXTIME_TH_8812F(x) | BIT_BAR_PKT_TXTIME_TH_8812F(v))

#define BIT_BAR_EN_V1_8812F BIT(6)

#define BIT_SHIFT_BAR_PKTNUM_TH_V1_8812F 0
#define BIT_MASK_BAR_PKTNUM_TH_V1_8812F 0x3f
#define BIT_BAR_PKTNUM_TH_V1_8812F(x)                                          \
	(((x) & BIT_MASK_BAR_PKTNUM_TH_V1_8812F)                               \
	 << BIT_SHIFT_BAR_PKTNUM_TH_V1_8812F)
#define BITS_BAR_PKTNUM_TH_V1_8812F                                            \
	(BIT_MASK_BAR_PKTNUM_TH_V1_8812F << BIT_SHIFT_BAR_PKTNUM_TH_V1_8812F)
#define BIT_CLEAR_BAR_PKTNUM_TH_V1_8812F(x)                                    \
	((x) & (~BITS_BAR_PKTNUM_TH_V1_8812F))
#define BIT_GET_BAR_PKTNUM_TH_V1_8812F(x)                                      \
	(((x) >> BIT_SHIFT_BAR_PKTNUM_TH_V1_8812F) &                           \
	 BIT_MASK_BAR_PKTNUM_TH_V1_8812F)
#define BIT_SET_BAR_PKTNUM_TH_V1_8812F(x, v)                                   \
	(BIT_CLEAR_BAR_PKTNUM_TH_V1_8812F(x) | BIT_BAR_PKTNUM_TH_V1_8812F(v))

/* 2 REG_RA_TRY_RATE_AGG_LMT_8812F */

#define BIT_SHIFT_RA_TRY_RATE_AGG_LMT_V1_8812F 0
#define BIT_MASK_RA_TRY_RATE_AGG_LMT_V1_8812F 0x3f
#define BIT_RA_TRY_RATE_AGG_LMT_V1_8812F(x)                                    \
	(((x) & BIT_MASK_RA_TRY_RATE_AGG_LMT_V1_8812F)                         \
	 << BIT_SHIFT_RA_TRY_RATE_AGG_LMT_V1_8812F)
#define BITS_RA_TRY_RATE_AGG_LMT_V1_8812F                                      \
	(BIT_MASK_RA_TRY_RATE_AGG_LMT_V1_8812F                                 \
	 << BIT_SHIFT_RA_TRY_RATE_AGG_LMT_V1_8812F)
#define BIT_CLEAR_RA_TRY_RATE_AGG_LMT_V1_8812F(x)                              \
	((x) & (~BITS_RA_TRY_RATE_AGG_LMT_V1_8812F))
#define BIT_GET_RA_TRY_RATE_AGG_LMT_V1_8812F(x)                                \
	(((x) >> BIT_SHIFT_RA_TRY_RATE_AGG_LMT_V1_8812F) &                     \
	 BIT_MASK_RA_TRY_RATE_AGG_LMT_V1_8812F)
#define BIT_SET_RA_TRY_RATE_AGG_LMT_V1_8812F(x, v)                             \
	(BIT_CLEAR_RA_TRY_RATE_AGG_LMT_V1_8812F(x) |                           \
	 BIT_RA_TRY_RATE_AGG_LMT_V1_8812F(v))

/* 2 REG_MACID_SLEEP2_8812F */

#define BIT_SHIFT_MACID95_64PKTSLEEP_8812F 0
#define BIT_MASK_MACID95_64PKTSLEEP_8812F 0xffffffffL
#define BIT_MACID95_64PKTSLEEP_8812F(x)                                        \
	(((x) & BIT_MASK_MACID95_64PKTSLEEP_8812F)                             \
	 << BIT_SHIFT_MACID95_64PKTSLEEP_8812F)
#define BITS_MACID95_64PKTSLEEP_8812F                                          \
	(BIT_MASK_MACID95_64PKTSLEEP_8812F                                     \
	 << BIT_SHIFT_MACID95_64PKTSLEEP_8812F)
#define BIT_CLEAR_MACID95_64PKTSLEEP_8812F(x)                                  \
	((x) & (~BITS_MACID95_64PKTSLEEP_8812F))
#define BIT_GET_MACID95_64PKTSLEEP_8812F(x)                                    \
	(((x) >> BIT_SHIFT_MACID95_64PKTSLEEP_8812F) &                         \
	 BIT_MASK_MACID95_64PKTSLEEP_8812F)
#define BIT_SET_MACID95_64PKTSLEEP_8812F(x, v)                                 \
	(BIT_CLEAR_MACID95_64PKTSLEEP_8812F(x) |                               \
	 BIT_MACID95_64PKTSLEEP_8812F(v))

/* 2 REG_MACID_SLEEP_8812F */

#define BIT_SHIFT_MACID31_0_PKTSLEEP_8812F 0
#define BIT_MASK_MACID31_0_PKTSLEEP_8812F 0xffffffffL
#define BIT_MACID31_0_PKTSLEEP_8812F(x)                                        \
	(((x) & BIT_MASK_MACID31_0_PKTSLEEP_8812F)                             \
	 << BIT_SHIFT_MACID31_0_PKTSLEEP_8812F)
#define BITS_MACID31_0_PKTSLEEP_8812F                                          \
	(BIT_MASK_MACID31_0_PKTSLEEP_8812F                                     \
	 << BIT_SHIFT_MACID31_0_PKTSLEEP_8812F)
#define BIT_CLEAR_MACID31_0_PKTSLEEP_8812F(x)                                  \
	((x) & (~BITS_MACID31_0_PKTSLEEP_8812F))
#define BIT_GET_MACID31_0_PKTSLEEP_8812F(x)                                    \
	(((x) >> BIT_SHIFT_MACID31_0_PKTSLEEP_8812F) &                         \
	 BIT_MASK_MACID31_0_PKTSLEEP_8812F)
#define BIT_SET_MACID31_0_PKTSLEEP_8812F(x, v)                                 \
	(BIT_CLEAR_MACID31_0_PKTSLEEP_8812F(x) |                               \
	 BIT_MACID31_0_PKTSLEEP_8812F(v))

/* 2 REG_HW_SEQ0_8812F */

#define BIT_SHIFT_HW_SSN_SEQ0_8812F 0
#define BIT_MASK_HW_SSN_SEQ0_8812F 0xfff
#define BIT_HW_SSN_SEQ0_8812F(x)                                               \
	(((x) & BIT_MASK_HW_SSN_SEQ0_8812F) << BIT_SHIFT_HW_SSN_SEQ0_8812F)
#define BITS_HW_SSN_SEQ0_8812F                                                 \
	(BIT_MASK_HW_SSN_SEQ0_8812F << BIT_SHIFT_HW_SSN_SEQ0_8812F)
#define BIT_CLEAR_HW_SSN_SEQ0_8812F(x) ((x) & (~BITS_HW_SSN_SEQ0_8812F))
#define BIT_GET_HW_SSN_SEQ0_8812F(x)                                           \
	(((x) >> BIT_SHIFT_HW_SSN_SEQ0_8812F) & BIT_MASK_HW_SSN_SEQ0_8812F)
#define BIT_SET_HW_SSN_SEQ0_8812F(x, v)                                        \
	(BIT_CLEAR_HW_SSN_SEQ0_8812F(x) | BIT_HW_SSN_SEQ0_8812F(v))

/* 2 REG_HW_SEQ1_8812F */

#define BIT_SHIFT_HW_SSN_SEQ1_8812F 0
#define BIT_MASK_HW_SSN_SEQ1_8812F 0xfff
#define BIT_HW_SSN_SEQ1_8812F(x)                                               \
	(((x) & BIT_MASK_HW_SSN_SEQ1_8812F) << BIT_SHIFT_HW_SSN_SEQ1_8812F)
#define BITS_HW_SSN_SEQ1_8812F                                                 \
	(BIT_MASK_HW_SSN_SEQ1_8812F << BIT_SHIFT_HW_SSN_SEQ1_8812F)
#define BIT_CLEAR_HW_SSN_SEQ1_8812F(x) ((x) & (~BITS_HW_SSN_SEQ1_8812F))
#define BIT_GET_HW_SSN_SEQ1_8812F(x)                                           \
	(((x) >> BIT_SHIFT_HW_SSN_SEQ1_8812F) & BIT_MASK_HW_SSN_SEQ1_8812F)
#define BIT_SET_HW_SSN_SEQ1_8812F(x, v)                                        \
	(BIT_CLEAR_HW_SSN_SEQ1_8812F(x) | BIT_HW_SSN_SEQ1_8812F(v))

/* 2 REG_HW_SEQ2_8812F */

#define BIT_SHIFT_HW_SSN_SEQ2_8812F 0
#define BIT_MASK_HW_SSN_SEQ2_8812F 0xfff
#define BIT_HW_SSN_SEQ2_8812F(x)                                               \
	(((x) & BIT_MASK_HW_SSN_SEQ2_8812F) << BIT_SHIFT_HW_SSN_SEQ2_8812F)
#define BITS_HW_SSN_SEQ2_8812F                                                 \
	(BIT_MASK_HW_SSN_SEQ2_8812F << BIT_SHIFT_HW_SSN_SEQ2_8812F)
#define BIT_CLEAR_HW_SSN_SEQ2_8812F(x) ((x) & (~BITS_HW_SSN_SEQ2_8812F))
#define BIT_GET_HW_SSN_SEQ2_8812F(x)                                           \
	(((x) >> BIT_SHIFT_HW_SSN_SEQ2_8812F) & BIT_MASK_HW_SSN_SEQ2_8812F)
#define BIT_SET_HW_SSN_SEQ2_8812F(x, v)                                        \
	(BIT_CLEAR_HW_SSN_SEQ2_8812F(x) | BIT_HW_SSN_SEQ2_8812F(v))

/* 2 REG_HW_SEQ3_8812F */

#define BIT_SHIFT_CSI_HWSEQ_SEL_8812F 12
#define BIT_MASK_CSI_HWSEQ_SEL_8812F 0x3
#define BIT_CSI_HWSEQ_SEL_8812F(x)                                             \
	(((x) & BIT_MASK_CSI_HWSEQ_SEL_8812F) << BIT_SHIFT_CSI_HWSEQ_SEL_8812F)
#define BITS_CSI_HWSEQ_SEL_8812F                                               \
	(BIT_MASK_CSI_HWSEQ_SEL_8812F << BIT_SHIFT_CSI_HWSEQ_SEL_8812F)
#define BIT_CLEAR_CSI_HWSEQ_SEL_8812F(x) ((x) & (~BITS_CSI_HWSEQ_SEL_8812F))
#define BIT_GET_CSI_HWSEQ_SEL_8812F(x)                                         \
	(((x) >> BIT_SHIFT_CSI_HWSEQ_SEL_8812F) & BIT_MASK_CSI_HWSEQ_SEL_8812F)
#define BIT_SET_CSI_HWSEQ_SEL_8812F(x, v)                                      \
	(BIT_CLEAR_CSI_HWSEQ_SEL_8812F(x) | BIT_CSI_HWSEQ_SEL_8812F(v))

#define BIT_SHIFT_HW_SSN_SEQ3_8812F 0
#define BIT_MASK_HW_SSN_SEQ3_8812F 0xfff
#define BIT_HW_SSN_SEQ3_8812F(x)                                               \
	(((x) & BIT_MASK_HW_SSN_SEQ3_8812F) << BIT_SHIFT_HW_SSN_SEQ3_8812F)
#define BITS_HW_SSN_SEQ3_8812F                                                 \
	(BIT_MASK_HW_SSN_SEQ3_8812F << BIT_SHIFT_HW_SSN_SEQ3_8812F)
#define BIT_CLEAR_HW_SSN_SEQ3_8812F(x) ((x) & (~BITS_HW_SSN_SEQ3_8812F))
#define BIT_GET_HW_SSN_SEQ3_8812F(x)                                           \
	(((x) >> BIT_SHIFT_HW_SSN_SEQ3_8812F) & BIT_MASK_HW_SSN_SEQ3_8812F)
#define BIT_SET_HW_SSN_SEQ3_8812F(x, v)                                        \
	(BIT_CLEAR_HW_SSN_SEQ3_8812F(x) | BIT_HW_SSN_SEQ3_8812F(v))

/* 2 REG_NULL_PKT_STATUS_V1_8812F */

#define BIT_SHIFT_PTCL_TOTAL_PG_V2_8812F 2
#define BIT_MASK_PTCL_TOTAL_PG_V2_8812F 0x3fff
#define BIT_PTCL_TOTAL_PG_V2_8812F(x)                                          \
	(((x) & BIT_MASK_PTCL_TOTAL_PG_V2_8812F)                               \
	 << BIT_SHIFT_PTCL_TOTAL_PG_V2_8812F)
#define BITS_PTCL_TOTAL_PG_V2_8812F                                            \
	(BIT_MASK_PTCL_TOTAL_PG_V2_8812F << BIT_SHIFT_PTCL_TOTAL_PG_V2_8812F)
#define BIT_CLEAR_PTCL_TOTAL_PG_V2_8812F(x)                                    \
	((x) & (~BITS_PTCL_TOTAL_PG_V2_8812F))
#define BIT_GET_PTCL_TOTAL_PG_V2_8812F(x)                                      \
	(((x) >> BIT_SHIFT_PTCL_TOTAL_PG_V2_8812F) &                           \
	 BIT_MASK_PTCL_TOTAL_PG_V2_8812F)
#define BIT_SET_PTCL_TOTAL_PG_V2_8812F(x, v)                                   \
	(BIT_CLEAR_PTCL_TOTAL_PG_V2_8812F(x) | BIT_PTCL_TOTAL_PG_V2_8812F(v))

#define BIT_TX_NULL_1_8812F BIT(1)
#define BIT_TX_NULL_0_8812F BIT(0)

/* 2 REG_PTCL_ERR_STATUS_8812F */
#define BIT_PTCL_RATE_TABLE_INVALID_8812F BIT(7)
#define BIT_FTM_T2R_ERROR_8812F BIT(6)
#define BIT_PTCL_ERR0_8812F BIT(5)
#define BIT_PTCL_ERR1_8812F BIT(4)
#define BIT_PTCL_ERR2_8812F BIT(3)
#define BIT_PTCL_ERR3_8812F BIT(2)
#define BIT_PTCL_ERR4_8812F BIT(1)
#define BIT_PTCL_ERR5_8812F BIT(0)

/* 2 REG_NULL_PKT_STATUS_EXTEND_8812F */
#define BIT_CLI3_TX_NULL_1_8812F BIT(7)
#define BIT_CLI3_TX_NULL_0_8812F BIT(6)
#define BIT_CLI2_TX_NULL_1_8812F BIT(5)
#define BIT_CLI2_TX_NULL_0_8812F BIT(4)
#define BIT_CLI1_TX_NULL_1_8812F BIT(3)
#define BIT_CLI1_TX_NULL_0_8812F BIT(2)
#define BIT_CLI0_TX_NULL_1_8812F BIT(1)
#define BIT_CLI0_TX_NULL_0_8812F BIT(0)

/* 2 REG_HQMGQ_DROP_8812F */
#define BIT_HIQ_DROP_8812F BIT(7)
#define BIT_MGQ_DROP_8812F BIT(6)
#define BIT_CLR_HGQ_REQ_BLOCK_8812F BIT(5)

/* 2 REG_PRECNT_CTRL_8812F */

#define BIT_SHIFT_COLLISION_DETECT_TIME_8812F 12
#define BIT_MASK_COLLISION_DETECT_TIME_8812F 0xf
#define BIT_COLLISION_DETECT_TIME_8812F(x)                                     \
	(((x) & BIT_MASK_COLLISION_DETECT_TIME_8812F)                          \
	 << BIT_SHIFT_COLLISION_DETECT_TIME_8812F)
#define BITS_COLLISION_DETECT_TIME_8812F                                       \
	(BIT_MASK_COLLISION_DETECT_TIME_8812F                                  \
	 << BIT_SHIFT_COLLISION_DETECT_TIME_8812F)
#define BIT_CLEAR_COLLISION_DETECT_TIME_8812F(x)                               \
	((x) & (~BITS_COLLISION_DETECT_TIME_8812F))
#define BIT_GET_COLLISION_DETECT_TIME_8812F(x)                                 \
	(((x) >> BIT_SHIFT_COLLISION_DETECT_TIME_8812F) &                      \
	 BIT_MASK_COLLISION_DETECT_TIME_8812F)
#define BIT_SET_COLLISION_DETECT_TIME_8812F(x, v)                              \
	(BIT_CLEAR_COLLISION_DETECT_TIME_8812F(x) |                            \
	 BIT_COLLISION_DETECT_TIME_8812F(v))

#define BIT_EN_PRECNT_8812F BIT(11)

#define BIT_SHIFT_PRECNT_TH_8812F 0
#define BIT_MASK_PRECNT_TH_8812F 0x7ff
#define BIT_PRECNT_TH_8812F(x)                                                 \
	(((x) & BIT_MASK_PRECNT_TH_8812F) << BIT_SHIFT_PRECNT_TH_8812F)
#define BITS_PRECNT_TH_8812F                                                   \
	(BIT_MASK_PRECNT_TH_8812F << BIT_SHIFT_PRECNT_TH_8812F)
#define BIT_CLEAR_PRECNT_TH_8812F(x) ((x) & (~BITS_PRECNT_TH_8812F))
#define BIT_GET_PRECNT_TH_8812F(x)                                             \
	(((x) >> BIT_SHIFT_PRECNT_TH_8812F) & BIT_MASK_PRECNT_TH_8812F)
#define BIT_SET_PRECNT_TH_8812F(x, v)                                          \
	(BIT_CLEAR_PRECNT_TH_8812F(x) | BIT_PRECNT_TH_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_BT_POLLUTE_PKT_CNT_8812F */

#define BIT_SHIFT_BT_POLLUTE_PKT_CNT_8812F 0
#define BIT_MASK_BT_POLLUTE_PKT_CNT_8812F 0xffff
#define BIT_BT_POLLUTE_PKT_CNT_8812F(x)                                        \
	(((x) & BIT_MASK_BT_POLLUTE_PKT_CNT_8812F)                             \
	 << BIT_SHIFT_BT_POLLUTE_PKT_CNT_8812F)
#define BITS_BT_POLLUTE_PKT_CNT_8812F                                          \
	(BIT_MASK_BT_POLLUTE_PKT_CNT_8812F                                     \
	 << BIT_SHIFT_BT_POLLUTE_PKT_CNT_8812F)
#define BIT_CLEAR_BT_POLLUTE_PKT_CNT_8812F(x)                                  \
	((x) & (~BITS_BT_POLLUTE_PKT_CNT_8812F))
#define BIT_GET_BT_POLLUTE_PKT_CNT_8812F(x)                                    \
	(((x) >> BIT_SHIFT_BT_POLLUTE_PKT_CNT_8812F) &                         \
	 BIT_MASK_BT_POLLUTE_PKT_CNT_8812F)
#define BIT_SET_BT_POLLUTE_PKT_CNT_8812F(x, v)                                 \
	(BIT_CLEAR_BT_POLLUTE_PKT_CNT_8812F(x) |                               \
	 BIT_BT_POLLUTE_PKT_CNT_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_PTCL_DBG_8812F */

#define BIT_SHIFT_PTCL_DBG_8812F 0
#define BIT_MASK_PTCL_DBG_8812F 0xffffffffL
#define BIT_PTCL_DBG_8812F(x)                                                  \
	(((x) & BIT_MASK_PTCL_DBG_8812F) << BIT_SHIFT_PTCL_DBG_8812F)
#define BITS_PTCL_DBG_8812F                                                    \
	(BIT_MASK_PTCL_DBG_8812F << BIT_SHIFT_PTCL_DBG_8812F)
#define BIT_CLEAR_PTCL_DBG_8812F(x) ((x) & (~BITS_PTCL_DBG_8812F))
#define BIT_GET_PTCL_DBG_8812F(x)                                              \
	(((x) >> BIT_SHIFT_PTCL_DBG_8812F) & BIT_MASK_PTCL_DBG_8812F)
#define BIT_SET_PTCL_DBG_8812F(x, v)                                           \
	(BIT_CLEAR_PTCL_DBG_8812F(x) | BIT_PTCL_DBG_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_CPUMGQ_TIMER_CTRL2_8812F */

#define BIT_SHIFT_TRI_HEAD_ADDR_8812F 16
#define BIT_MASK_TRI_HEAD_ADDR_8812F 0xfff
#define BIT_TRI_HEAD_ADDR_8812F(x)                                             \
	(((x) & BIT_MASK_TRI_HEAD_ADDR_8812F) << BIT_SHIFT_TRI_HEAD_ADDR_8812F)
#define BITS_TRI_HEAD_ADDR_8812F                                               \
	(BIT_MASK_TRI_HEAD_ADDR_8812F << BIT_SHIFT_TRI_HEAD_ADDR_8812F)
#define BIT_CLEAR_TRI_HEAD_ADDR_8812F(x) ((x) & (~BITS_TRI_HEAD_ADDR_8812F))
#define BIT_GET_TRI_HEAD_ADDR_8812F(x)                                         \
	(((x) >> BIT_SHIFT_TRI_HEAD_ADDR_8812F) & BIT_MASK_TRI_HEAD_ADDR_8812F)
#define BIT_SET_TRI_HEAD_ADDR_8812F(x, v)                                      \
	(BIT_CLEAR_TRI_HEAD_ADDR_8812F(x) | BIT_TRI_HEAD_ADDR_8812F(v))

#define BIT_DROP_TH_EN_8812F BIT(8)

#define BIT_SHIFT_DROP_TH_8812F 0
#define BIT_MASK_DROP_TH_8812F 0xff
#define BIT_DROP_TH_8812F(x)                                                   \
	(((x) & BIT_MASK_DROP_TH_8812F) << BIT_SHIFT_DROP_TH_8812F)
#define BITS_DROP_TH_8812F (BIT_MASK_DROP_TH_8812F << BIT_SHIFT_DROP_TH_8812F)
#define BIT_CLEAR_DROP_TH_8812F(x) ((x) & (~BITS_DROP_TH_8812F))
#define BIT_GET_DROP_TH_8812F(x)                                               \
	(((x) >> BIT_SHIFT_DROP_TH_8812F) & BIT_MASK_DROP_TH_8812F)
#define BIT_SET_DROP_TH_8812F(x, v)                                            \
	(BIT_CLEAR_DROP_TH_8812F(x) | BIT_DROP_TH_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_DUMMY_PAGE4_V1_8812F */

/* 2 REG_MOREDATA_8812F */
#define BIT_MOREDATA_CTRL2_EN_V1_8812F BIT(3)
#define BIT_MOREDATA_CTRL1_EN_V1_8812F BIT(2)
#define BIT_PKTIN_MOREDATA_REPLACE_ENABLE_V1_8812F BIT(0)

/* 2 REG_Q0_Q1_INFO_8812F */
#define BIT_QUEUE_MACID_AC_NOT_THE_SAME_8812F BIT(31)

#define BIT_SHIFT_GTAB_ID_8812F 28
#define BIT_MASK_GTAB_ID_8812F 0x7
#define BIT_GTAB_ID_8812F(x)                                                   \
	(((x) & BIT_MASK_GTAB_ID_8812F) << BIT_SHIFT_GTAB_ID_8812F)
#define BITS_GTAB_ID_8812F (BIT_MASK_GTAB_ID_8812F << BIT_SHIFT_GTAB_ID_8812F)
#define BIT_CLEAR_GTAB_ID_8812F(x) ((x) & (~BITS_GTAB_ID_8812F))
#define BIT_GET_GTAB_ID_8812F(x)                                               \
	(((x) >> BIT_SHIFT_GTAB_ID_8812F) & BIT_MASK_GTAB_ID_8812F)
#define BIT_SET_GTAB_ID_8812F(x, v)                                            \
	(BIT_CLEAR_GTAB_ID_8812F(x) | BIT_GTAB_ID_8812F(v))

#define BIT_SHIFT_AC1_PKT_INFO_8812F 16
#define BIT_MASK_AC1_PKT_INFO_8812F 0xfff
#define BIT_AC1_PKT_INFO_8812F(x)                                              \
	(((x) & BIT_MASK_AC1_PKT_INFO_8812F) << BIT_SHIFT_AC1_PKT_INFO_8812F)
#define BITS_AC1_PKT_INFO_8812F                                                \
	(BIT_MASK_AC1_PKT_INFO_8812F << BIT_SHIFT_AC1_PKT_INFO_8812F)
#define BIT_CLEAR_AC1_PKT_INFO_8812F(x) ((x) & (~BITS_AC1_PKT_INFO_8812F))
#define BIT_GET_AC1_PKT_INFO_8812F(x)                                          \
	(((x) >> BIT_SHIFT_AC1_PKT_INFO_8812F) & BIT_MASK_AC1_PKT_INFO_8812F)
#define BIT_SET_AC1_PKT_INFO_8812F(x, v)                                       \
	(BIT_CLEAR_AC1_PKT_INFO_8812F(x) | BIT_AC1_PKT_INFO_8812F(v))

#define BIT_QUEUE_MACID_AC_NOT_THE_SAME_V1_8812F BIT(15)

#define BIT_SHIFT_GTAB_ID_V1_8812F 12
#define BIT_MASK_GTAB_ID_V1_8812F 0x7
#define BIT_GTAB_ID_V1_8812F(x)                                                \
	(((x) & BIT_MASK_GTAB_ID_V1_8812F) << BIT_SHIFT_GTAB_ID_V1_8812F)
#define BITS_GTAB_ID_V1_8812F                                                  \
	(BIT_MASK_GTAB_ID_V1_8812F << BIT_SHIFT_GTAB_ID_V1_8812F)
#define BIT_CLEAR_GTAB_ID_V1_8812F(x) ((x) & (~BITS_GTAB_ID_V1_8812F))
#define BIT_GET_GTAB_ID_V1_8812F(x)                                            \
	(((x) >> BIT_SHIFT_GTAB_ID_V1_8812F) & BIT_MASK_GTAB_ID_V1_8812F)
#define BIT_SET_GTAB_ID_V1_8812F(x, v)                                         \
	(BIT_CLEAR_GTAB_ID_V1_8812F(x) | BIT_GTAB_ID_V1_8812F(v))

#define BIT_SHIFT_AC0_PKT_INFO_8812F 0
#define BIT_MASK_AC0_PKT_INFO_8812F 0xfff
#define BIT_AC0_PKT_INFO_8812F(x)                                              \
	(((x) & BIT_MASK_AC0_PKT_INFO_8812F) << BIT_SHIFT_AC0_PKT_INFO_8812F)
#define BITS_AC0_PKT_INFO_8812F                                                \
	(BIT_MASK_AC0_PKT_INFO_8812F << BIT_SHIFT_AC0_PKT_INFO_8812F)
#define BIT_CLEAR_AC0_PKT_INFO_8812F(x) ((x) & (~BITS_AC0_PKT_INFO_8812F))
#define BIT_GET_AC0_PKT_INFO_8812F(x)                                          \
	(((x) >> BIT_SHIFT_AC0_PKT_INFO_8812F) & BIT_MASK_AC0_PKT_INFO_8812F)
#define BIT_SET_AC0_PKT_INFO_8812F(x, v)                                       \
	(BIT_CLEAR_AC0_PKT_INFO_8812F(x) | BIT_AC0_PKT_INFO_8812F(v))

/* 2 REG_Q2_Q3_INFO_8812F */
#define BIT_QUEUE_MACID_AC_NOT_THE_SAME_8812F BIT(31)

#define BIT_SHIFT_GTAB_ID_8812F 28
#define BIT_MASK_GTAB_ID_8812F 0x7
#define BIT_GTAB_ID_8812F(x)                                                   \
	(((x) & BIT_MASK_GTAB_ID_8812F) << BIT_SHIFT_GTAB_ID_8812F)
#define BITS_GTAB_ID_8812F (BIT_MASK_GTAB_ID_8812F << BIT_SHIFT_GTAB_ID_8812F)
#define BIT_CLEAR_GTAB_ID_8812F(x) ((x) & (~BITS_GTAB_ID_8812F))
#define BIT_GET_GTAB_ID_8812F(x)                                               \
	(((x) >> BIT_SHIFT_GTAB_ID_8812F) & BIT_MASK_GTAB_ID_8812F)
#define BIT_SET_GTAB_ID_8812F(x, v)                                            \
	(BIT_CLEAR_GTAB_ID_8812F(x) | BIT_GTAB_ID_8812F(v))

#define BIT_SHIFT_AC3_PKT_INFO_8812F 16
#define BIT_MASK_AC3_PKT_INFO_8812F 0xfff
#define BIT_AC3_PKT_INFO_8812F(x)                                              \
	(((x) & BIT_MASK_AC3_PKT_INFO_8812F) << BIT_SHIFT_AC3_PKT_INFO_8812F)
#define BITS_AC3_PKT_INFO_8812F                                                \
	(BIT_MASK_AC3_PKT_INFO_8812F << BIT_SHIFT_AC3_PKT_INFO_8812F)
#define BIT_CLEAR_AC3_PKT_INFO_8812F(x) ((x) & (~BITS_AC3_PKT_INFO_8812F))
#define BIT_GET_AC3_PKT_INFO_8812F(x)                                          \
	(((x) >> BIT_SHIFT_AC3_PKT_INFO_8812F) & BIT_MASK_AC3_PKT_INFO_8812F)
#define BIT_SET_AC3_PKT_INFO_8812F(x, v)                                       \
	(BIT_CLEAR_AC3_PKT_INFO_8812F(x) | BIT_AC3_PKT_INFO_8812F(v))

#define BIT_QUEUE_MACID_AC_NOT_THE_SAME_V1_8812F BIT(15)

#define BIT_SHIFT_GTAB_ID_V1_8812F 12
#define BIT_MASK_GTAB_ID_V1_8812F 0x7
#define BIT_GTAB_ID_V1_8812F(x)                                                \
	(((x) & BIT_MASK_GTAB_ID_V1_8812F) << BIT_SHIFT_GTAB_ID_V1_8812F)
#define BITS_GTAB_ID_V1_8812F                                                  \
	(BIT_MASK_GTAB_ID_V1_8812F << BIT_SHIFT_GTAB_ID_V1_8812F)
#define BIT_CLEAR_GTAB_ID_V1_8812F(x) ((x) & (~BITS_GTAB_ID_V1_8812F))
#define BIT_GET_GTAB_ID_V1_8812F(x)                                            \
	(((x) >> BIT_SHIFT_GTAB_ID_V1_8812F) & BIT_MASK_GTAB_ID_V1_8812F)
#define BIT_SET_GTAB_ID_V1_8812F(x, v)                                         \
	(BIT_CLEAR_GTAB_ID_V1_8812F(x) | BIT_GTAB_ID_V1_8812F(v))

#define BIT_SHIFT_AC2_PKT_INFO_8812F 0
#define BIT_MASK_AC2_PKT_INFO_8812F 0xfff
#define BIT_AC2_PKT_INFO_8812F(x)                                              \
	(((x) & BIT_MASK_AC2_PKT_INFO_8812F) << BIT_SHIFT_AC2_PKT_INFO_8812F)
#define BITS_AC2_PKT_INFO_8812F                                                \
	(BIT_MASK_AC2_PKT_INFO_8812F << BIT_SHIFT_AC2_PKT_INFO_8812F)
#define BIT_CLEAR_AC2_PKT_INFO_8812F(x) ((x) & (~BITS_AC2_PKT_INFO_8812F))
#define BIT_GET_AC2_PKT_INFO_8812F(x)                                          \
	(((x) >> BIT_SHIFT_AC2_PKT_INFO_8812F) & BIT_MASK_AC2_PKT_INFO_8812F)
#define BIT_SET_AC2_PKT_INFO_8812F(x, v)                                       \
	(BIT_CLEAR_AC2_PKT_INFO_8812F(x) | BIT_AC2_PKT_INFO_8812F(v))

/* 2 REG_Q4_Q5_INFO_8812F */
#define BIT_QUEUE_MACID_AC_NOT_THE_SAME_8812F BIT(31)

#define BIT_SHIFT_GTAB_ID_8812F 28
#define BIT_MASK_GTAB_ID_8812F 0x7
#define BIT_GTAB_ID_8812F(x)                                                   \
	(((x) & BIT_MASK_GTAB_ID_8812F) << BIT_SHIFT_GTAB_ID_8812F)
#define BITS_GTAB_ID_8812F (BIT_MASK_GTAB_ID_8812F << BIT_SHIFT_GTAB_ID_8812F)
#define BIT_CLEAR_GTAB_ID_8812F(x) ((x) & (~BITS_GTAB_ID_8812F))
#define BIT_GET_GTAB_ID_8812F(x)                                               \
	(((x) >> BIT_SHIFT_GTAB_ID_8812F) & BIT_MASK_GTAB_ID_8812F)
#define BIT_SET_GTAB_ID_8812F(x, v)                                            \
	(BIT_CLEAR_GTAB_ID_8812F(x) | BIT_GTAB_ID_8812F(v))

#define BIT_SHIFT_AC5_PKT_INFO_8812F 16
#define BIT_MASK_AC5_PKT_INFO_8812F 0xfff
#define BIT_AC5_PKT_INFO_8812F(x)                                              \
	(((x) & BIT_MASK_AC5_PKT_INFO_8812F) << BIT_SHIFT_AC5_PKT_INFO_8812F)
#define BITS_AC5_PKT_INFO_8812F                                                \
	(BIT_MASK_AC5_PKT_INFO_8812F << BIT_SHIFT_AC5_PKT_INFO_8812F)
#define BIT_CLEAR_AC5_PKT_INFO_8812F(x) ((x) & (~BITS_AC5_PKT_INFO_8812F))
#define BIT_GET_AC5_PKT_INFO_8812F(x)                                          \
	(((x) >> BIT_SHIFT_AC5_PKT_INFO_8812F) & BIT_MASK_AC5_PKT_INFO_8812F)
#define BIT_SET_AC5_PKT_INFO_8812F(x, v)                                       \
	(BIT_CLEAR_AC5_PKT_INFO_8812F(x) | BIT_AC5_PKT_INFO_8812F(v))

#define BIT_QUEUE_MACID_AC_NOT_THE_SAME_V1_8812F BIT(15)

#define BIT_SHIFT_GTAB_ID_V1_8812F 12
#define BIT_MASK_GTAB_ID_V1_8812F 0x7
#define BIT_GTAB_ID_V1_8812F(x)                                                \
	(((x) & BIT_MASK_GTAB_ID_V1_8812F) << BIT_SHIFT_GTAB_ID_V1_8812F)
#define BITS_GTAB_ID_V1_8812F                                                  \
	(BIT_MASK_GTAB_ID_V1_8812F << BIT_SHIFT_GTAB_ID_V1_8812F)
#define BIT_CLEAR_GTAB_ID_V1_8812F(x) ((x) & (~BITS_GTAB_ID_V1_8812F))
#define BIT_GET_GTAB_ID_V1_8812F(x)                                            \
	(((x) >> BIT_SHIFT_GTAB_ID_V1_8812F) & BIT_MASK_GTAB_ID_V1_8812F)
#define BIT_SET_GTAB_ID_V1_8812F(x, v)                                         \
	(BIT_CLEAR_GTAB_ID_V1_8812F(x) | BIT_GTAB_ID_V1_8812F(v))

#define BIT_SHIFT_AC4_PKT_INFO_8812F 0
#define BIT_MASK_AC4_PKT_INFO_8812F 0xfff
#define BIT_AC4_PKT_INFO_8812F(x)                                              \
	(((x) & BIT_MASK_AC4_PKT_INFO_8812F) << BIT_SHIFT_AC4_PKT_INFO_8812F)
#define BITS_AC4_PKT_INFO_8812F                                                \
	(BIT_MASK_AC4_PKT_INFO_8812F << BIT_SHIFT_AC4_PKT_INFO_8812F)
#define BIT_CLEAR_AC4_PKT_INFO_8812F(x) ((x) & (~BITS_AC4_PKT_INFO_8812F))
#define BIT_GET_AC4_PKT_INFO_8812F(x)                                          \
	(((x) >> BIT_SHIFT_AC4_PKT_INFO_8812F) & BIT_MASK_AC4_PKT_INFO_8812F)
#define BIT_SET_AC4_PKT_INFO_8812F(x, v)                                       \
	(BIT_CLEAR_AC4_PKT_INFO_8812F(x) | BIT_AC4_PKT_INFO_8812F(v))

/* 2 REG_Q6_Q7_INFO_8812F */
#define BIT_QUEUE_MACID_AC_NOT_THE_SAME_8812F BIT(31)

#define BIT_SHIFT_GTAB_ID_8812F 28
#define BIT_MASK_GTAB_ID_8812F 0x7
#define BIT_GTAB_ID_8812F(x)                                                   \
	(((x) & BIT_MASK_GTAB_ID_8812F) << BIT_SHIFT_GTAB_ID_8812F)
#define BITS_GTAB_ID_8812F (BIT_MASK_GTAB_ID_8812F << BIT_SHIFT_GTAB_ID_8812F)
#define BIT_CLEAR_GTAB_ID_8812F(x) ((x) & (~BITS_GTAB_ID_8812F))
#define BIT_GET_GTAB_ID_8812F(x)                                               \
	(((x) >> BIT_SHIFT_GTAB_ID_8812F) & BIT_MASK_GTAB_ID_8812F)
#define BIT_SET_GTAB_ID_8812F(x, v)                                            \
	(BIT_CLEAR_GTAB_ID_8812F(x) | BIT_GTAB_ID_8812F(v))

#define BIT_SHIFT_AC7_PKT_INFO_8812F 16
#define BIT_MASK_AC7_PKT_INFO_8812F 0xfff
#define BIT_AC7_PKT_INFO_8812F(x)                                              \
	(((x) & BIT_MASK_AC7_PKT_INFO_8812F) << BIT_SHIFT_AC7_PKT_INFO_8812F)
#define BITS_AC7_PKT_INFO_8812F                                                \
	(BIT_MASK_AC7_PKT_INFO_8812F << BIT_SHIFT_AC7_PKT_INFO_8812F)
#define BIT_CLEAR_AC7_PKT_INFO_8812F(x) ((x) & (~BITS_AC7_PKT_INFO_8812F))
#define BIT_GET_AC7_PKT_INFO_8812F(x)                                          \
	(((x) >> BIT_SHIFT_AC7_PKT_INFO_8812F) & BIT_MASK_AC7_PKT_INFO_8812F)
#define BIT_SET_AC7_PKT_INFO_8812F(x, v)                                       \
	(BIT_CLEAR_AC7_PKT_INFO_8812F(x) | BIT_AC7_PKT_INFO_8812F(v))

#define BIT_QUEUE_MACID_AC_NOT_THE_SAME_V1_8812F BIT(15)

#define BIT_SHIFT_GTAB_ID_V1_8812F 12
#define BIT_MASK_GTAB_ID_V1_8812F 0x7
#define BIT_GTAB_ID_V1_8812F(x)                                                \
	(((x) & BIT_MASK_GTAB_ID_V1_8812F) << BIT_SHIFT_GTAB_ID_V1_8812F)
#define BITS_GTAB_ID_V1_8812F                                                  \
	(BIT_MASK_GTAB_ID_V1_8812F << BIT_SHIFT_GTAB_ID_V1_8812F)
#define BIT_CLEAR_GTAB_ID_V1_8812F(x) ((x) & (~BITS_GTAB_ID_V1_8812F))
#define BIT_GET_GTAB_ID_V1_8812F(x)                                            \
	(((x) >> BIT_SHIFT_GTAB_ID_V1_8812F) & BIT_MASK_GTAB_ID_V1_8812F)
#define BIT_SET_GTAB_ID_V1_8812F(x, v)                                         \
	(BIT_CLEAR_GTAB_ID_V1_8812F(x) | BIT_GTAB_ID_V1_8812F(v))

#define BIT_SHIFT_AC6_PKT_INFO_8812F 0
#define BIT_MASK_AC6_PKT_INFO_8812F 0xfff
#define BIT_AC6_PKT_INFO_8812F(x)                                              \
	(((x) & BIT_MASK_AC6_PKT_INFO_8812F) << BIT_SHIFT_AC6_PKT_INFO_8812F)
#define BITS_AC6_PKT_INFO_8812F                                                \
	(BIT_MASK_AC6_PKT_INFO_8812F << BIT_SHIFT_AC6_PKT_INFO_8812F)
#define BIT_CLEAR_AC6_PKT_INFO_8812F(x) ((x) & (~BITS_AC6_PKT_INFO_8812F))
#define BIT_GET_AC6_PKT_INFO_8812F(x)                                          \
	(((x) >> BIT_SHIFT_AC6_PKT_INFO_8812F) & BIT_MASK_AC6_PKT_INFO_8812F)
#define BIT_SET_AC6_PKT_INFO_8812F(x, v)                                       \
	(BIT_CLEAR_AC6_PKT_INFO_8812F(x) | BIT_AC6_PKT_INFO_8812F(v))

/* 2 REG_MGQ_HIQ_INFO_8812F */

#define BIT_SHIFT_HIQ_PKT_INFO_8812F 16
#define BIT_MASK_HIQ_PKT_INFO_8812F 0xfff
#define BIT_HIQ_PKT_INFO_8812F(x)                                              \
	(((x) & BIT_MASK_HIQ_PKT_INFO_8812F) << BIT_SHIFT_HIQ_PKT_INFO_8812F)
#define BITS_HIQ_PKT_INFO_8812F                                                \
	(BIT_MASK_HIQ_PKT_INFO_8812F << BIT_SHIFT_HIQ_PKT_INFO_8812F)
#define BIT_CLEAR_HIQ_PKT_INFO_8812F(x) ((x) & (~BITS_HIQ_PKT_INFO_8812F))
#define BIT_GET_HIQ_PKT_INFO_8812F(x)                                          \
	(((x) >> BIT_SHIFT_HIQ_PKT_INFO_8812F) & BIT_MASK_HIQ_PKT_INFO_8812F)
#define BIT_SET_HIQ_PKT_INFO_8812F(x, v)                                       \
	(BIT_CLEAR_HIQ_PKT_INFO_8812F(x) | BIT_HIQ_PKT_INFO_8812F(v))

#define BIT_SHIFT_MGQ_PKT_INFO_8812F 0
#define BIT_MASK_MGQ_PKT_INFO_8812F 0xfff
#define BIT_MGQ_PKT_INFO_8812F(x)                                              \
	(((x) & BIT_MASK_MGQ_PKT_INFO_8812F) << BIT_SHIFT_MGQ_PKT_INFO_8812F)
#define BITS_MGQ_PKT_INFO_8812F                                                \
	(BIT_MASK_MGQ_PKT_INFO_8812F << BIT_SHIFT_MGQ_PKT_INFO_8812F)
#define BIT_CLEAR_MGQ_PKT_INFO_8812F(x) ((x) & (~BITS_MGQ_PKT_INFO_8812F))
#define BIT_GET_MGQ_PKT_INFO_8812F(x)                                          \
	(((x) >> BIT_SHIFT_MGQ_PKT_INFO_8812F) & BIT_MASK_MGQ_PKT_INFO_8812F)
#define BIT_SET_MGQ_PKT_INFO_8812F(x, v)                                       \
	(BIT_CLEAR_MGQ_PKT_INFO_8812F(x) | BIT_MGQ_PKT_INFO_8812F(v))

/* 2 REG_CMDQ_BCNQ_INFO_8812F */

#define BIT_SHIFT_CMDQ_PKT_INFO_8812F 16
#define BIT_MASK_CMDQ_PKT_INFO_8812F 0xfff
#define BIT_CMDQ_PKT_INFO_8812F(x)                                             \
	(((x) & BIT_MASK_CMDQ_PKT_INFO_8812F) << BIT_SHIFT_CMDQ_PKT_INFO_8812F)
#define BITS_CMDQ_PKT_INFO_8812F                                               \
	(BIT_MASK_CMDQ_PKT_INFO_8812F << BIT_SHIFT_CMDQ_PKT_INFO_8812F)
#define BIT_CLEAR_CMDQ_PKT_INFO_8812F(x) ((x) & (~BITS_CMDQ_PKT_INFO_8812F))
#define BIT_GET_CMDQ_PKT_INFO_8812F(x)                                         \
	(((x) >> BIT_SHIFT_CMDQ_PKT_INFO_8812F) & BIT_MASK_CMDQ_PKT_INFO_8812F)
#define BIT_SET_CMDQ_PKT_INFO_8812F(x, v)                                      \
	(BIT_CLEAR_CMDQ_PKT_INFO_8812F(x) | BIT_CMDQ_PKT_INFO_8812F(v))

#define BIT_SHIFT_BCNQ_PKT_INFO_8812F 0
#define BIT_MASK_BCNQ_PKT_INFO_8812F 0xfff
#define BIT_BCNQ_PKT_INFO_8812F(x)                                             \
	(((x) & BIT_MASK_BCNQ_PKT_INFO_8812F) << BIT_SHIFT_BCNQ_PKT_INFO_8812F)
#define BITS_BCNQ_PKT_INFO_8812F                                               \
	(BIT_MASK_BCNQ_PKT_INFO_8812F << BIT_SHIFT_BCNQ_PKT_INFO_8812F)
#define BIT_CLEAR_BCNQ_PKT_INFO_8812F(x) ((x) & (~BITS_BCNQ_PKT_INFO_8812F))
#define BIT_GET_BCNQ_PKT_INFO_8812F(x)                                         \
	(((x) >> BIT_SHIFT_BCNQ_PKT_INFO_8812F) & BIT_MASK_BCNQ_PKT_INFO_8812F)
#define BIT_SET_BCNQ_PKT_INFO_8812F(x, v)                                      \
	(BIT_CLEAR_BCNQ_PKT_INFO_8812F(x) | BIT_BCNQ_PKT_INFO_8812F(v))

/* 2 REG_LOOPBACK_OPTION_8812F */
#define BIT_LOOPACK_FAST_EDCA_EN_8812F BIT(24)

/* 2 REG_AESIV_SETTING_8812F */

#define BIT_SHIFT_AESIV_OFFSET_8812F 0
#define BIT_MASK_AESIV_OFFSET_8812F 0xfff
#define BIT_AESIV_OFFSET_8812F(x)                                              \
	(((x) & BIT_MASK_AESIV_OFFSET_8812F) << BIT_SHIFT_AESIV_OFFSET_8812F)
#define BITS_AESIV_OFFSET_8812F                                                \
	(BIT_MASK_AESIV_OFFSET_8812F << BIT_SHIFT_AESIV_OFFSET_8812F)
#define BIT_CLEAR_AESIV_OFFSET_8812F(x) ((x) & (~BITS_AESIV_OFFSET_8812F))
#define BIT_GET_AESIV_OFFSET_8812F(x)                                          \
	(((x) >> BIT_SHIFT_AESIV_OFFSET_8812F) & BIT_MASK_AESIV_OFFSET_8812F)
#define BIT_SET_AESIV_OFFSET_8812F(x, v)                                       \
	(BIT_CLEAR_AESIV_OFFSET_8812F(x) | BIT_AESIV_OFFSET_8812F(v))

/* 2 REG_BF0_TIME_SETTING_8812F */
#define BIT_BF0_TIMER_SET_8812F BIT(31)
#define BIT_BF0_TIMER_CLR_8812F BIT(30)
#define BIT_BF0_UPDATE_EN_8812F BIT(29)
#define BIT_BF0_TIMER_EN_8812F BIT(28)

#define BIT_SHIFT_BF0_PRETIME_OVER_8812F 16
#define BIT_MASK_BF0_PRETIME_OVER_8812F 0xfff
#define BIT_BF0_PRETIME_OVER_8812F(x)                                          \
	(((x) & BIT_MASK_BF0_PRETIME_OVER_8812F)                               \
	 << BIT_SHIFT_BF0_PRETIME_OVER_8812F)
#define BITS_BF0_PRETIME_OVER_8812F                                            \
	(BIT_MASK_BF0_PRETIME_OVER_8812F << BIT_SHIFT_BF0_PRETIME_OVER_8812F)
#define BIT_CLEAR_BF0_PRETIME_OVER_8812F(x)                                    \
	((x) & (~BITS_BF0_PRETIME_OVER_8812F))
#define BIT_GET_BF0_PRETIME_OVER_8812F(x)                                      \
	(((x) >> BIT_SHIFT_BF0_PRETIME_OVER_8812F) &                           \
	 BIT_MASK_BF0_PRETIME_OVER_8812F)
#define BIT_SET_BF0_PRETIME_OVER_8812F(x, v)                                   \
	(BIT_CLEAR_BF0_PRETIME_OVER_8812F(x) | BIT_BF0_PRETIME_OVER_8812F(v))

#define BIT_SHIFT_BF0_LIFETIME_8812F 0
#define BIT_MASK_BF0_LIFETIME_8812F 0xffff
#define BIT_BF0_LIFETIME_8812F(x)                                              \
	(((x) & BIT_MASK_BF0_LIFETIME_8812F) << BIT_SHIFT_BF0_LIFETIME_8812F)
#define BITS_BF0_LIFETIME_8812F                                                \
	(BIT_MASK_BF0_LIFETIME_8812F << BIT_SHIFT_BF0_LIFETIME_8812F)
#define BIT_CLEAR_BF0_LIFETIME_8812F(x) ((x) & (~BITS_BF0_LIFETIME_8812F))
#define BIT_GET_BF0_LIFETIME_8812F(x)                                          \
	(((x) >> BIT_SHIFT_BF0_LIFETIME_8812F) & BIT_MASK_BF0_LIFETIME_8812F)
#define BIT_SET_BF0_LIFETIME_8812F(x, v)                                       \
	(BIT_CLEAR_BF0_LIFETIME_8812F(x) | BIT_BF0_LIFETIME_8812F(v))

/* 2 REG_BF1_TIME_SETTING_8812F */
#define BIT_BF1_TIMER_SET_8812F BIT(31)
#define BIT_BF1_TIMER_CLR_8812F BIT(30)
#define BIT_BF1_UPDATE_EN_8812F BIT(29)
#define BIT_BF1_TIMER_EN_8812F BIT(28)

#define BIT_SHIFT_BF1_PRETIME_OVER_8812F 16
#define BIT_MASK_BF1_PRETIME_OVER_8812F 0xfff
#define BIT_BF1_PRETIME_OVER_8812F(x)                                          \
	(((x) & BIT_MASK_BF1_PRETIME_OVER_8812F)                               \
	 << BIT_SHIFT_BF1_PRETIME_OVER_8812F)
#define BITS_BF1_PRETIME_OVER_8812F                                            \
	(BIT_MASK_BF1_PRETIME_OVER_8812F << BIT_SHIFT_BF1_PRETIME_OVER_8812F)
#define BIT_CLEAR_BF1_PRETIME_OVER_8812F(x)                                    \
	((x) & (~BITS_BF1_PRETIME_OVER_8812F))
#define BIT_GET_BF1_PRETIME_OVER_8812F(x)                                      \
	(((x) >> BIT_SHIFT_BF1_PRETIME_OVER_8812F) &                           \
	 BIT_MASK_BF1_PRETIME_OVER_8812F)
#define BIT_SET_BF1_PRETIME_OVER_8812F(x, v)                                   \
	(BIT_CLEAR_BF1_PRETIME_OVER_8812F(x) | BIT_BF1_PRETIME_OVER_8812F(v))

#define BIT_SHIFT_BF1_LIFETIME_8812F 0
#define BIT_MASK_BF1_LIFETIME_8812F 0xffff
#define BIT_BF1_LIFETIME_8812F(x)                                              \
	(((x) & BIT_MASK_BF1_LIFETIME_8812F) << BIT_SHIFT_BF1_LIFETIME_8812F)
#define BITS_BF1_LIFETIME_8812F                                                \
	(BIT_MASK_BF1_LIFETIME_8812F << BIT_SHIFT_BF1_LIFETIME_8812F)
#define BIT_CLEAR_BF1_LIFETIME_8812F(x) ((x) & (~BITS_BF1_LIFETIME_8812F))
#define BIT_GET_BF1_LIFETIME_8812F(x)                                          \
	(((x) >> BIT_SHIFT_BF1_LIFETIME_8812F) & BIT_MASK_BF1_LIFETIME_8812F)
#define BIT_SET_BF1_LIFETIME_8812F(x, v)                                       \
	(BIT_CLEAR_BF1_LIFETIME_8812F(x) | BIT_BF1_LIFETIME_8812F(v))

/* 2 REG_BF_TIMEOUT_EN_8812F */
#define BIT_EN_VHT_LDPC_8812F BIT(9)
#define BIT_EN_HT_LDPC_8812F BIT(8)
#define BIT_BF1_TIMEOUT_EN_8812F BIT(1)
#define BIT_BF0_TIMEOUT_EN_8812F BIT(0)

/* 2 REG_MACID_RELEASE0_8812F */

#define BIT_SHIFT_MACID31_0_RELEASE_8812F 0
#define BIT_MASK_MACID31_0_RELEASE_8812F 0xffffffffL
#define BIT_MACID31_0_RELEASE_8812F(x)                                         \
	(((x) & BIT_MASK_MACID31_0_RELEASE_8812F)                              \
	 << BIT_SHIFT_MACID31_0_RELEASE_8812F)
#define BITS_MACID31_0_RELEASE_8812F                                           \
	(BIT_MASK_MACID31_0_RELEASE_8812F << BIT_SHIFT_MACID31_0_RELEASE_8812F)
#define BIT_CLEAR_MACID31_0_RELEASE_8812F(x)                                   \
	((x) & (~BITS_MACID31_0_RELEASE_8812F))
#define BIT_GET_MACID31_0_RELEASE_8812F(x)                                     \
	(((x) >> BIT_SHIFT_MACID31_0_RELEASE_8812F) &                          \
	 BIT_MASK_MACID31_0_RELEASE_8812F)
#define BIT_SET_MACID31_0_RELEASE_8812F(x, v)                                  \
	(BIT_CLEAR_MACID31_0_RELEASE_8812F(x) | BIT_MACID31_0_RELEASE_8812F(v))

/* 2 REG_MACID_RELEASE1_8812F */

#define BIT_SHIFT_MACID63_32_RELEASE_8812F 0
#define BIT_MASK_MACID63_32_RELEASE_8812F 0xffffffffL
#define BIT_MACID63_32_RELEASE_8812F(x)                                        \
	(((x) & BIT_MASK_MACID63_32_RELEASE_8812F)                             \
	 << BIT_SHIFT_MACID63_32_RELEASE_8812F)
#define BITS_MACID63_32_RELEASE_8812F                                          \
	(BIT_MASK_MACID63_32_RELEASE_8812F                                     \
	 << BIT_SHIFT_MACID63_32_RELEASE_8812F)
#define BIT_CLEAR_MACID63_32_RELEASE_8812F(x)                                  \
	((x) & (~BITS_MACID63_32_RELEASE_8812F))
#define BIT_GET_MACID63_32_RELEASE_8812F(x)                                    \
	(((x) >> BIT_SHIFT_MACID63_32_RELEASE_8812F) &                         \
	 BIT_MASK_MACID63_32_RELEASE_8812F)
#define BIT_SET_MACID63_32_RELEASE_8812F(x, v)                                 \
	(BIT_CLEAR_MACID63_32_RELEASE_8812F(x) |                               \
	 BIT_MACID63_32_RELEASE_8812F(v))

/* 2 REG_MACID_RELEASE2_8812F */

#define BIT_SHIFT_MACID95_64_RELEASE_8812F 0
#define BIT_MASK_MACID95_64_RELEASE_8812F 0xffffffffL
#define BIT_MACID95_64_RELEASE_8812F(x)                                        \
	(((x) & BIT_MASK_MACID95_64_RELEASE_8812F)                             \
	 << BIT_SHIFT_MACID95_64_RELEASE_8812F)
#define BITS_MACID95_64_RELEASE_8812F                                          \
	(BIT_MASK_MACID95_64_RELEASE_8812F                                     \
	 << BIT_SHIFT_MACID95_64_RELEASE_8812F)
#define BIT_CLEAR_MACID95_64_RELEASE_8812F(x)                                  \
	((x) & (~BITS_MACID95_64_RELEASE_8812F))
#define BIT_GET_MACID95_64_RELEASE_8812F(x)                                    \
	(((x) >> BIT_SHIFT_MACID95_64_RELEASE_8812F) &                         \
	 BIT_MASK_MACID95_64_RELEASE_8812F)
#define BIT_SET_MACID95_64_RELEASE_8812F(x, v)                                 \
	(BIT_CLEAR_MACID95_64_RELEASE_8812F(x) |                               \
	 BIT_MACID95_64_RELEASE_8812F(v))

/* 2 REG_MACID_RELEASE3_8812F */

#define BIT_SHIFT_MACID127_96_RELEASE_8812F 0
#define BIT_MASK_MACID127_96_RELEASE_8812F 0xffffffffL
#define BIT_MACID127_96_RELEASE_8812F(x)                                       \
	(((x) & BIT_MASK_MACID127_96_RELEASE_8812F)                            \
	 << BIT_SHIFT_MACID127_96_RELEASE_8812F)
#define BITS_MACID127_96_RELEASE_8812F                                         \
	(BIT_MASK_MACID127_96_RELEASE_8812F                                    \
	 << BIT_SHIFT_MACID127_96_RELEASE_8812F)
#define BIT_CLEAR_MACID127_96_RELEASE_8812F(x)                                 \
	((x) & (~BITS_MACID127_96_RELEASE_8812F))
#define BIT_GET_MACID127_96_RELEASE_8812F(x)                                   \
	(((x) >> BIT_SHIFT_MACID127_96_RELEASE_8812F) &                        \
	 BIT_MASK_MACID127_96_RELEASE_8812F)
#define BIT_SET_MACID127_96_RELEASE_8812F(x, v)                                \
	(BIT_CLEAR_MACID127_96_RELEASE_8812F(x) |                              \
	 BIT_MACID127_96_RELEASE_8812F(v))

/* 2 REG_MACID_RELEASE_SETTING_8812F */
#define BIT_MACID_VALUE_8812F BIT(7)

#define BIT_SHIFT_MACID_OFFSET_8812F 0
#define BIT_MASK_MACID_OFFSET_8812F 0x7f
#define BIT_MACID_OFFSET_8812F(x)                                              \
	(((x) & BIT_MASK_MACID_OFFSET_8812F) << BIT_SHIFT_MACID_OFFSET_8812F)
#define BITS_MACID_OFFSET_8812F                                                \
	(BIT_MASK_MACID_OFFSET_8812F << BIT_SHIFT_MACID_OFFSET_8812F)
#define BIT_CLEAR_MACID_OFFSET_8812F(x) ((x) & (~BITS_MACID_OFFSET_8812F))
#define BIT_GET_MACID_OFFSET_8812F(x)                                          \
	(((x) >> BIT_SHIFT_MACID_OFFSET_8812F) & BIT_MASK_MACID_OFFSET_8812F)
#define BIT_SET_MACID_OFFSET_8812F(x, v)                                       \
	(BIT_CLEAR_MACID_OFFSET_8812F(x) | BIT_MACID_OFFSET_8812F(v))

/* 2 REG_FAST_EDCA_VOVI_SETTING_8812F */

#define BIT_SHIFT_VI_FAST_EDCA_TO_8812F 24
#define BIT_MASK_VI_FAST_EDCA_TO_8812F 0xff
#define BIT_VI_FAST_EDCA_TO_8812F(x)                                           \
	(((x) & BIT_MASK_VI_FAST_EDCA_TO_8812F)                                \
	 << BIT_SHIFT_VI_FAST_EDCA_TO_8812F)
#define BITS_VI_FAST_EDCA_TO_8812F                                             \
	(BIT_MASK_VI_FAST_EDCA_TO_8812F << BIT_SHIFT_VI_FAST_EDCA_TO_8812F)
#define BIT_CLEAR_VI_FAST_EDCA_TO_8812F(x) ((x) & (~BITS_VI_FAST_EDCA_TO_8812F))
#define BIT_GET_VI_FAST_EDCA_TO_8812F(x)                                       \
	(((x) >> BIT_SHIFT_VI_FAST_EDCA_TO_8812F) &                            \
	 BIT_MASK_VI_FAST_EDCA_TO_8812F)
#define BIT_SET_VI_FAST_EDCA_TO_8812F(x, v)                                    \
	(BIT_CLEAR_VI_FAST_EDCA_TO_8812F(x) | BIT_VI_FAST_EDCA_TO_8812F(v))

#define BIT_VI_THRESHOLD_SEL_8812F BIT(23)

#define BIT_SHIFT_VI_FAST_EDCA_PKT_TH_8812F 16
#define BIT_MASK_VI_FAST_EDCA_PKT_TH_8812F 0x7f
#define BIT_VI_FAST_EDCA_PKT_TH_8812F(x)                                       \
	(((x) & BIT_MASK_VI_FAST_EDCA_PKT_TH_8812F)                            \
	 << BIT_SHIFT_VI_FAST_EDCA_PKT_TH_8812F)
#define BITS_VI_FAST_EDCA_PKT_TH_8812F                                         \
	(BIT_MASK_VI_FAST_EDCA_PKT_TH_8812F                                    \
	 << BIT_SHIFT_VI_FAST_EDCA_PKT_TH_8812F)
#define BIT_CLEAR_VI_FAST_EDCA_PKT_TH_8812F(x)                                 \
	((x) & (~BITS_VI_FAST_EDCA_PKT_TH_8812F))
#define BIT_GET_VI_FAST_EDCA_PKT_TH_8812F(x)                                   \
	(((x) >> BIT_SHIFT_VI_FAST_EDCA_PKT_TH_8812F) &                        \
	 BIT_MASK_VI_FAST_EDCA_PKT_TH_8812F)
#define BIT_SET_VI_FAST_EDCA_PKT_TH_8812F(x, v)                                \
	(BIT_CLEAR_VI_FAST_EDCA_PKT_TH_8812F(x) |                              \
	 BIT_VI_FAST_EDCA_PKT_TH_8812F(v))

#define BIT_SHIFT_VO_FAST_EDCA_TO_8812F 8
#define BIT_MASK_VO_FAST_EDCA_TO_8812F 0xff
#define BIT_VO_FAST_EDCA_TO_8812F(x)                                           \
	(((x) & BIT_MASK_VO_FAST_EDCA_TO_8812F)                                \
	 << BIT_SHIFT_VO_FAST_EDCA_TO_8812F)
#define BITS_VO_FAST_EDCA_TO_8812F                                             \
	(BIT_MASK_VO_FAST_EDCA_TO_8812F << BIT_SHIFT_VO_FAST_EDCA_TO_8812F)
#define BIT_CLEAR_VO_FAST_EDCA_TO_8812F(x) ((x) & (~BITS_VO_FAST_EDCA_TO_8812F))
#define BIT_GET_VO_FAST_EDCA_TO_8812F(x)                                       \
	(((x) >> BIT_SHIFT_VO_FAST_EDCA_TO_8812F) &                            \
	 BIT_MASK_VO_FAST_EDCA_TO_8812F)
#define BIT_SET_VO_FAST_EDCA_TO_8812F(x, v)                                    \
	(BIT_CLEAR_VO_FAST_EDCA_TO_8812F(x) | BIT_VO_FAST_EDCA_TO_8812F(v))

#define BIT_VO_THRESHOLD_SEL_8812F BIT(7)

#define BIT_SHIFT_VO_FAST_EDCA_PKT_TH_8812F 0
#define BIT_MASK_VO_FAST_EDCA_PKT_TH_8812F 0x7f
#define BIT_VO_FAST_EDCA_PKT_TH_8812F(x)                                       \
	(((x) & BIT_MASK_VO_FAST_EDCA_PKT_TH_8812F)                            \
	 << BIT_SHIFT_VO_FAST_EDCA_PKT_TH_8812F)
#define BITS_VO_FAST_EDCA_PKT_TH_8812F                                         \
	(BIT_MASK_VO_FAST_EDCA_PKT_TH_8812F                                    \
	 << BIT_SHIFT_VO_FAST_EDCA_PKT_TH_8812F)
#define BIT_CLEAR_VO_FAST_EDCA_PKT_TH_8812F(x)                                 \
	((x) & (~BITS_VO_FAST_EDCA_PKT_TH_8812F))
#define BIT_GET_VO_FAST_EDCA_PKT_TH_8812F(x)                                   \
	(((x) >> BIT_SHIFT_VO_FAST_EDCA_PKT_TH_8812F) &                        \
	 BIT_MASK_VO_FAST_EDCA_PKT_TH_8812F)
#define BIT_SET_VO_FAST_EDCA_PKT_TH_8812F(x, v)                                \
	(BIT_CLEAR_VO_FAST_EDCA_PKT_TH_8812F(x) |                              \
	 BIT_VO_FAST_EDCA_PKT_TH_8812F(v))

/* 2 REG_FAST_EDCA_BEBK_SETTING_8812F */

#define BIT_SHIFT_BK_FAST_EDCA_TO_8812F 24
#define BIT_MASK_BK_FAST_EDCA_TO_8812F 0xff
#define BIT_BK_FAST_EDCA_TO_8812F(x)                                           \
	(((x) & BIT_MASK_BK_FAST_EDCA_TO_8812F)                                \
	 << BIT_SHIFT_BK_FAST_EDCA_TO_8812F)
#define BITS_BK_FAST_EDCA_TO_8812F                                             \
	(BIT_MASK_BK_FAST_EDCA_TO_8812F << BIT_SHIFT_BK_FAST_EDCA_TO_8812F)
#define BIT_CLEAR_BK_FAST_EDCA_TO_8812F(x) ((x) & (~BITS_BK_FAST_EDCA_TO_8812F))
#define BIT_GET_BK_FAST_EDCA_TO_8812F(x)                                       \
	(((x) >> BIT_SHIFT_BK_FAST_EDCA_TO_8812F) &                            \
	 BIT_MASK_BK_FAST_EDCA_TO_8812F)
#define BIT_SET_BK_FAST_EDCA_TO_8812F(x, v)                                    \
	(BIT_CLEAR_BK_FAST_EDCA_TO_8812F(x) | BIT_BK_FAST_EDCA_TO_8812F(v))

#define BIT_BK_THRESHOLD_SEL_8812F BIT(23)

#define BIT_SHIFT_BK_FAST_EDCA_PKT_TH_8812F 16
#define BIT_MASK_BK_FAST_EDCA_PKT_TH_8812F 0x7f
#define BIT_BK_FAST_EDCA_PKT_TH_8812F(x)                                       \
	(((x) & BIT_MASK_BK_FAST_EDCA_PKT_TH_8812F)                            \
	 << BIT_SHIFT_BK_FAST_EDCA_PKT_TH_8812F)
#define BITS_BK_FAST_EDCA_PKT_TH_8812F                                         \
	(BIT_MASK_BK_FAST_EDCA_PKT_TH_8812F                                    \
	 << BIT_SHIFT_BK_FAST_EDCA_PKT_TH_8812F)
#define BIT_CLEAR_BK_FAST_EDCA_PKT_TH_8812F(x)                                 \
	((x) & (~BITS_BK_FAST_EDCA_PKT_TH_8812F))
#define BIT_GET_BK_FAST_EDCA_PKT_TH_8812F(x)                                   \
	(((x) >> BIT_SHIFT_BK_FAST_EDCA_PKT_TH_8812F) &                        \
	 BIT_MASK_BK_FAST_EDCA_PKT_TH_8812F)
#define BIT_SET_BK_FAST_EDCA_PKT_TH_8812F(x, v)                                \
	(BIT_CLEAR_BK_FAST_EDCA_PKT_TH_8812F(x) |                              \
	 BIT_BK_FAST_EDCA_PKT_TH_8812F(v))

#define BIT_SHIFT_BE_FAST_EDCA_TO_8812F 8
#define BIT_MASK_BE_FAST_EDCA_TO_8812F 0xff
#define BIT_BE_FAST_EDCA_TO_8812F(x)                                           \
	(((x) & BIT_MASK_BE_FAST_EDCA_TO_8812F)                                \
	 << BIT_SHIFT_BE_FAST_EDCA_TO_8812F)
#define BITS_BE_FAST_EDCA_TO_8812F                                             \
	(BIT_MASK_BE_FAST_EDCA_TO_8812F << BIT_SHIFT_BE_FAST_EDCA_TO_8812F)
#define BIT_CLEAR_BE_FAST_EDCA_TO_8812F(x) ((x) & (~BITS_BE_FAST_EDCA_TO_8812F))
#define BIT_GET_BE_FAST_EDCA_TO_8812F(x)                                       \
	(((x) >> BIT_SHIFT_BE_FAST_EDCA_TO_8812F) &                            \
	 BIT_MASK_BE_FAST_EDCA_TO_8812F)
#define BIT_SET_BE_FAST_EDCA_TO_8812F(x, v)                                    \
	(BIT_CLEAR_BE_FAST_EDCA_TO_8812F(x) | BIT_BE_FAST_EDCA_TO_8812F(v))

#define BIT_BE_THRESHOLD_SEL_8812F BIT(7)

#define BIT_SHIFT_BE_FAST_EDCA_PKT_TH_8812F 0
#define BIT_MASK_BE_FAST_EDCA_PKT_TH_8812F 0x7f
#define BIT_BE_FAST_EDCA_PKT_TH_8812F(x)                                       \
	(((x) & BIT_MASK_BE_FAST_EDCA_PKT_TH_8812F)                            \
	 << BIT_SHIFT_BE_FAST_EDCA_PKT_TH_8812F)
#define BITS_BE_FAST_EDCA_PKT_TH_8812F                                         \
	(BIT_MASK_BE_FAST_EDCA_PKT_TH_8812F                                    \
	 << BIT_SHIFT_BE_FAST_EDCA_PKT_TH_8812F)
#define BIT_CLEAR_BE_FAST_EDCA_PKT_TH_8812F(x)                                 \
	((x) & (~BITS_BE_FAST_EDCA_PKT_TH_8812F))
#define BIT_GET_BE_FAST_EDCA_PKT_TH_8812F(x)                                   \
	(((x) >> BIT_SHIFT_BE_FAST_EDCA_PKT_TH_8812F) &                        \
	 BIT_MASK_BE_FAST_EDCA_PKT_TH_8812F)
#define BIT_SET_BE_FAST_EDCA_PKT_TH_8812F(x, v)                                \
	(BIT_CLEAR_BE_FAST_EDCA_PKT_TH_8812F(x) |                              \
	 BIT_BE_FAST_EDCA_PKT_TH_8812F(v))

/* 2 REG_MACID_DROP0_8812F */

#define BIT_SHIFT_MACID31_0_DROP_8812F 0
#define BIT_MASK_MACID31_0_DROP_8812F 0xffffffffL
#define BIT_MACID31_0_DROP_8812F(x)                                            \
	(((x) & BIT_MASK_MACID31_0_DROP_8812F)                                 \
	 << BIT_SHIFT_MACID31_0_DROP_8812F)
#define BITS_MACID31_0_DROP_8812F                                              \
	(BIT_MASK_MACID31_0_DROP_8812F << BIT_SHIFT_MACID31_0_DROP_8812F)
#define BIT_CLEAR_MACID31_0_DROP_8812F(x) ((x) & (~BITS_MACID31_0_DROP_8812F))
#define BIT_GET_MACID31_0_DROP_8812F(x)                                        \
	(((x) >> BIT_SHIFT_MACID31_0_DROP_8812F) &                             \
	 BIT_MASK_MACID31_0_DROP_8812F)
#define BIT_SET_MACID31_0_DROP_8812F(x, v)                                     \
	(BIT_CLEAR_MACID31_0_DROP_8812F(x) | BIT_MACID31_0_DROP_8812F(v))

/* 2 REG_MACID_DROP1_8812F */

#define BIT_SHIFT_MACID63_32_DROP_8812F 0
#define BIT_MASK_MACID63_32_DROP_8812F 0xffffffffL
#define BIT_MACID63_32_DROP_8812F(x)                                           \
	(((x) & BIT_MASK_MACID63_32_DROP_8812F)                                \
	 << BIT_SHIFT_MACID63_32_DROP_8812F)
#define BITS_MACID63_32_DROP_8812F                                             \
	(BIT_MASK_MACID63_32_DROP_8812F << BIT_SHIFT_MACID63_32_DROP_8812F)
#define BIT_CLEAR_MACID63_32_DROP_8812F(x) ((x) & (~BITS_MACID63_32_DROP_8812F))
#define BIT_GET_MACID63_32_DROP_8812F(x)                                       \
	(((x) >> BIT_SHIFT_MACID63_32_DROP_8812F) &                            \
	 BIT_MASK_MACID63_32_DROP_8812F)
#define BIT_SET_MACID63_32_DROP_8812F(x, v)                                    \
	(BIT_CLEAR_MACID63_32_DROP_8812F(x) | BIT_MACID63_32_DROP_8812F(v))

/* 2 REG_MACID_DROP2_8812F */

#define BIT_SHIFT_MACID95_64_DROP_8812F 0
#define BIT_MASK_MACID95_64_DROP_8812F 0xffffffffL
#define BIT_MACID95_64_DROP_8812F(x)                                           \
	(((x) & BIT_MASK_MACID95_64_DROP_8812F)                                \
	 << BIT_SHIFT_MACID95_64_DROP_8812F)
#define BITS_MACID95_64_DROP_8812F                                             \
	(BIT_MASK_MACID95_64_DROP_8812F << BIT_SHIFT_MACID95_64_DROP_8812F)
#define BIT_CLEAR_MACID95_64_DROP_8812F(x) ((x) & (~BITS_MACID95_64_DROP_8812F))
#define BIT_GET_MACID95_64_DROP_8812F(x)                                       \
	(((x) >> BIT_SHIFT_MACID95_64_DROP_8812F) &                            \
	 BIT_MASK_MACID95_64_DROP_8812F)
#define BIT_SET_MACID95_64_DROP_8812F(x, v)                                    \
	(BIT_CLEAR_MACID95_64_DROP_8812F(x) | BIT_MACID95_64_DROP_8812F(v))

/* 2 REG_MACID_DROP3_8812F */

#define BIT_SHIFT_MACID127_96_DROP_8812F 0
#define BIT_MASK_MACID127_96_DROP_8812F 0xffffffffL
#define BIT_MACID127_96_DROP_8812F(x)                                          \
	(((x) & BIT_MASK_MACID127_96_DROP_8812F)                               \
	 << BIT_SHIFT_MACID127_96_DROP_8812F)
#define BITS_MACID127_96_DROP_8812F                                            \
	(BIT_MASK_MACID127_96_DROP_8812F << BIT_SHIFT_MACID127_96_DROP_8812F)
#define BIT_CLEAR_MACID127_96_DROP_8812F(x)                                    \
	((x) & (~BITS_MACID127_96_DROP_8812F))
#define BIT_GET_MACID127_96_DROP_8812F(x)                                      \
	(((x) >> BIT_SHIFT_MACID127_96_DROP_8812F) &                           \
	 BIT_MASK_MACID127_96_DROP_8812F)
#define BIT_SET_MACID127_96_DROP_8812F(x, v)                                   \
	(BIT_CLEAR_MACID127_96_DROP_8812F(x) | BIT_MACID127_96_DROP_8812F(v))

/* 2 REG_R_MACID_RELEASE_SUCCESS_0_8812F */

#define BIT_SHIFT_R_MACID_RELEASE_SUCCESS_0_8812F 0
#define BIT_MASK_R_MACID_RELEASE_SUCCESS_0_8812F 0xffffffffL
#define BIT_R_MACID_RELEASE_SUCCESS_0_8812F(x)                                 \
	(((x) & BIT_MASK_R_MACID_RELEASE_SUCCESS_0_8812F)                      \
	 << BIT_SHIFT_R_MACID_RELEASE_SUCCESS_0_8812F)
#define BITS_R_MACID_RELEASE_SUCCESS_0_8812F                                   \
	(BIT_MASK_R_MACID_RELEASE_SUCCESS_0_8812F                              \
	 << BIT_SHIFT_R_MACID_RELEASE_SUCCESS_0_8812F)
#define BIT_CLEAR_R_MACID_RELEASE_SUCCESS_0_8812F(x)                           \
	((x) & (~BITS_R_MACID_RELEASE_SUCCESS_0_8812F))
#define BIT_GET_R_MACID_RELEASE_SUCCESS_0_8812F(x)                             \
	(((x) >> BIT_SHIFT_R_MACID_RELEASE_SUCCESS_0_8812F) &                  \
	 BIT_MASK_R_MACID_RELEASE_SUCCESS_0_8812F)
#define BIT_SET_R_MACID_RELEASE_SUCCESS_0_8812F(x, v)                          \
	(BIT_CLEAR_R_MACID_RELEASE_SUCCESS_0_8812F(x) |                        \
	 BIT_R_MACID_RELEASE_SUCCESS_0_8812F(v))

/* 2 REG_R_MACID_RELEASE_SUCCESS_1_8812F */

#define BIT_SHIFT_R_MACID_RELEASE_SUCCESS_1_8812F 0
#define BIT_MASK_R_MACID_RELEASE_SUCCESS_1_8812F 0xffffffffL
#define BIT_R_MACID_RELEASE_SUCCESS_1_8812F(x)                                 \
	(((x) & BIT_MASK_R_MACID_RELEASE_SUCCESS_1_8812F)                      \
	 << BIT_SHIFT_R_MACID_RELEASE_SUCCESS_1_8812F)
#define BITS_R_MACID_RELEASE_SUCCESS_1_8812F                                   \
	(BIT_MASK_R_MACID_RELEASE_SUCCESS_1_8812F                              \
	 << BIT_SHIFT_R_MACID_RELEASE_SUCCESS_1_8812F)
#define BIT_CLEAR_R_MACID_RELEASE_SUCCESS_1_8812F(x)                           \
	((x) & (~BITS_R_MACID_RELEASE_SUCCESS_1_8812F))
#define BIT_GET_R_MACID_RELEASE_SUCCESS_1_8812F(x)                             \
	(((x) >> BIT_SHIFT_R_MACID_RELEASE_SUCCESS_1_8812F) &                  \
	 BIT_MASK_R_MACID_RELEASE_SUCCESS_1_8812F)
#define BIT_SET_R_MACID_RELEASE_SUCCESS_1_8812F(x, v)                          \
	(BIT_CLEAR_R_MACID_RELEASE_SUCCESS_1_8812F(x) |                        \
	 BIT_R_MACID_RELEASE_SUCCESS_1_8812F(v))

/* 2 REG_R_MACID_RELEASE_SUCCESS_2_8812F */

#define BIT_SHIFT_R_MACID_RELEASE_SUCCESS_2_8812F 0
#define BIT_MASK_R_MACID_RELEASE_SUCCESS_2_8812F 0xffffffffL
#define BIT_R_MACID_RELEASE_SUCCESS_2_8812F(x)                                 \
	(((x) & BIT_MASK_R_MACID_RELEASE_SUCCESS_2_8812F)                      \
	 << BIT_SHIFT_R_MACID_RELEASE_SUCCESS_2_8812F)
#define BITS_R_MACID_RELEASE_SUCCESS_2_8812F                                   \
	(BIT_MASK_R_MACID_RELEASE_SUCCESS_2_8812F                              \
	 << BIT_SHIFT_R_MACID_RELEASE_SUCCESS_2_8812F)
#define BIT_CLEAR_R_MACID_RELEASE_SUCCESS_2_8812F(x)                           \
	((x) & (~BITS_R_MACID_RELEASE_SUCCESS_2_8812F))
#define BIT_GET_R_MACID_RELEASE_SUCCESS_2_8812F(x)                             \
	(((x) >> BIT_SHIFT_R_MACID_RELEASE_SUCCESS_2_8812F) &                  \
	 BIT_MASK_R_MACID_RELEASE_SUCCESS_2_8812F)
#define BIT_SET_R_MACID_RELEASE_SUCCESS_2_8812F(x, v)                          \
	(BIT_CLEAR_R_MACID_RELEASE_SUCCESS_2_8812F(x) |                        \
	 BIT_R_MACID_RELEASE_SUCCESS_2_8812F(v))

/* 2 REG_R_MACID_RELEASE_SUCCESS_3_8812F */

#define BIT_SHIFT_R_MACID_RELEASE_SUCCESS_3_8812F 0
#define BIT_MASK_R_MACID_RELEASE_SUCCESS_3_8812F 0xffffffffL
#define BIT_R_MACID_RELEASE_SUCCESS_3_8812F(x)                                 \
	(((x) & BIT_MASK_R_MACID_RELEASE_SUCCESS_3_8812F)                      \
	 << BIT_SHIFT_R_MACID_RELEASE_SUCCESS_3_8812F)
#define BITS_R_MACID_RELEASE_SUCCESS_3_8812F                                   \
	(BIT_MASK_R_MACID_RELEASE_SUCCESS_3_8812F                              \
	 << BIT_SHIFT_R_MACID_RELEASE_SUCCESS_3_8812F)
#define BIT_CLEAR_R_MACID_RELEASE_SUCCESS_3_8812F(x)                           \
	((x) & (~BITS_R_MACID_RELEASE_SUCCESS_3_8812F))
#define BIT_GET_R_MACID_RELEASE_SUCCESS_3_8812F(x)                             \
	(((x) >> BIT_SHIFT_R_MACID_RELEASE_SUCCESS_3_8812F) &                  \
	 BIT_MASK_R_MACID_RELEASE_SUCCESS_3_8812F)
#define BIT_SET_R_MACID_RELEASE_SUCCESS_3_8812F(x, v)                          \
	(BIT_CLEAR_R_MACID_RELEASE_SUCCESS_3_8812F(x) |                        \
	 BIT_R_MACID_RELEASE_SUCCESS_3_8812F(v))

/* 2 REG_MGQ_FIFO_WRITE_POINTER_8812F */
#define BIT_MGQ_FIFO_OV_8812F BIT(7)
#define BIT_MGQ_FIFO_WPTR_ERROR_8812F BIT(6)
#define BIT_EN_MGQ_FIFO_LIFETIME_8812F BIT(5)

#define BIT_SHIFT_MGQ_FIFO_WPTR_8812F 0
#define BIT_MASK_MGQ_FIFO_WPTR_8812F 0x1f
#define BIT_MGQ_FIFO_WPTR_8812F(x)                                             \
	(((x) & BIT_MASK_MGQ_FIFO_WPTR_8812F) << BIT_SHIFT_MGQ_FIFO_WPTR_8812F)
#define BITS_MGQ_FIFO_WPTR_8812F                                               \
	(BIT_MASK_MGQ_FIFO_WPTR_8812F << BIT_SHIFT_MGQ_FIFO_WPTR_8812F)
#define BIT_CLEAR_MGQ_FIFO_WPTR_8812F(x) ((x) & (~BITS_MGQ_FIFO_WPTR_8812F))
#define BIT_GET_MGQ_FIFO_WPTR_8812F(x)                                         \
	(((x) >> BIT_SHIFT_MGQ_FIFO_WPTR_8812F) & BIT_MASK_MGQ_FIFO_WPTR_8812F)
#define BIT_SET_MGQ_FIFO_WPTR_8812F(x, v)                                      \
	(BIT_CLEAR_MGQ_FIFO_WPTR_8812F(x) | BIT_MGQ_FIFO_WPTR_8812F(v))

/* 2 REG_MGQ_FIFO_READ_POINTER_8812F */

#define BIT_SHIFT_MGQ_FIFO_SIZE_8812F 14
#define BIT_MASK_MGQ_FIFO_SIZE_8812F 0x3
#define BIT_MGQ_FIFO_SIZE_8812F(x)                                             \
	(((x) & BIT_MASK_MGQ_FIFO_SIZE_8812F) << BIT_SHIFT_MGQ_FIFO_SIZE_8812F)
#define BITS_MGQ_FIFO_SIZE_8812F                                               \
	(BIT_MASK_MGQ_FIFO_SIZE_8812F << BIT_SHIFT_MGQ_FIFO_SIZE_8812F)
#define BIT_CLEAR_MGQ_FIFO_SIZE_8812F(x) ((x) & (~BITS_MGQ_FIFO_SIZE_8812F))
#define BIT_GET_MGQ_FIFO_SIZE_8812F(x)                                         \
	(((x) >> BIT_SHIFT_MGQ_FIFO_SIZE_8812F) & BIT_MASK_MGQ_FIFO_SIZE_8812F)
#define BIT_SET_MGQ_FIFO_SIZE_8812F(x, v)                                      \
	(BIT_CLEAR_MGQ_FIFO_SIZE_8812F(x) | BIT_MGQ_FIFO_SIZE_8812F(v))

#define BIT_MGQ_FIFO_PAUSE_8812F BIT(13)

#define BIT_SHIFT_MGQ_FIFO_RPTR_8812F 8
#define BIT_MASK_MGQ_FIFO_RPTR_8812F 0x1f
#define BIT_MGQ_FIFO_RPTR_8812F(x)                                             \
	(((x) & BIT_MASK_MGQ_FIFO_RPTR_8812F) << BIT_SHIFT_MGQ_FIFO_RPTR_8812F)
#define BITS_MGQ_FIFO_RPTR_8812F                                               \
	(BIT_MASK_MGQ_FIFO_RPTR_8812F << BIT_SHIFT_MGQ_FIFO_RPTR_8812F)
#define BIT_CLEAR_MGQ_FIFO_RPTR_8812F(x) ((x) & (~BITS_MGQ_FIFO_RPTR_8812F))
#define BIT_GET_MGQ_FIFO_RPTR_8812F(x)                                         \
	(((x) >> BIT_SHIFT_MGQ_FIFO_RPTR_8812F) & BIT_MASK_MGQ_FIFO_RPTR_8812F)
#define BIT_SET_MGQ_FIFO_RPTR_8812F(x, v)                                      \
	(BIT_CLEAR_MGQ_FIFO_RPTR_8812F(x) | BIT_MGQ_FIFO_RPTR_8812F(v))

/* 2 REG_MGQ_FIFO_ENABLE_8812F */
#define BIT_MGQ_FIFO_EN_8812F BIT(15)

#define BIT_SHIFT_MGQ_FIFO_PG_SIZE_8812F 12
#define BIT_MASK_MGQ_FIFO_PG_SIZE_8812F 0x7
#define BIT_MGQ_FIFO_PG_SIZE_8812F(x)                                          \
	(((x) & BIT_MASK_MGQ_FIFO_PG_SIZE_8812F)                               \
	 << BIT_SHIFT_MGQ_FIFO_PG_SIZE_8812F)
#define BITS_MGQ_FIFO_PG_SIZE_8812F                                            \
	(BIT_MASK_MGQ_FIFO_PG_SIZE_8812F << BIT_SHIFT_MGQ_FIFO_PG_SIZE_8812F)
#define BIT_CLEAR_MGQ_FIFO_PG_SIZE_8812F(x)                                    \
	((x) & (~BITS_MGQ_FIFO_PG_SIZE_8812F))
#define BIT_GET_MGQ_FIFO_PG_SIZE_8812F(x)                                      \
	(((x) >> BIT_SHIFT_MGQ_FIFO_PG_SIZE_8812F) &                           \
	 BIT_MASK_MGQ_FIFO_PG_SIZE_8812F)
#define BIT_SET_MGQ_FIFO_PG_SIZE_8812F(x, v)                                   \
	(BIT_CLEAR_MGQ_FIFO_PG_SIZE_8812F(x) | BIT_MGQ_FIFO_PG_SIZE_8812F(v))

#define BIT_SHIFT_MGQ_FIFO_START_PG_8812F 0
#define BIT_MASK_MGQ_FIFO_START_PG_8812F 0xfff
#define BIT_MGQ_FIFO_START_PG_8812F(x)                                         \
	(((x) & BIT_MASK_MGQ_FIFO_START_PG_8812F)                              \
	 << BIT_SHIFT_MGQ_FIFO_START_PG_8812F)
#define BITS_MGQ_FIFO_START_PG_8812F                                           \
	(BIT_MASK_MGQ_FIFO_START_PG_8812F << BIT_SHIFT_MGQ_FIFO_START_PG_8812F)
#define BIT_CLEAR_MGQ_FIFO_START_PG_8812F(x)                                   \
	((x) & (~BITS_MGQ_FIFO_START_PG_8812F))
#define BIT_GET_MGQ_FIFO_START_PG_8812F(x)                                     \
	(((x) >> BIT_SHIFT_MGQ_FIFO_START_PG_8812F) &                          \
	 BIT_MASK_MGQ_FIFO_START_PG_8812F)
#define BIT_SET_MGQ_FIFO_START_PG_8812F(x, v)                                  \
	(BIT_CLEAR_MGQ_FIFO_START_PG_8812F(x) | BIT_MGQ_FIFO_START_PG_8812F(v))

/* 2 REG_MGQ_FIFO_RELEASE_INT_MASK_8812F */

#define BIT_SHIFT_MGQ_FIFO_REL_INT_MASK_8812F 0
#define BIT_MASK_MGQ_FIFO_REL_INT_MASK_8812F 0xffff
#define BIT_MGQ_FIFO_REL_INT_MASK_8812F(x)                                     \
	(((x) & BIT_MASK_MGQ_FIFO_REL_INT_MASK_8812F)                          \
	 << BIT_SHIFT_MGQ_FIFO_REL_INT_MASK_8812F)
#define BITS_MGQ_FIFO_REL_INT_MASK_8812F                                       \
	(BIT_MASK_MGQ_FIFO_REL_INT_MASK_8812F                                  \
	 << BIT_SHIFT_MGQ_FIFO_REL_INT_MASK_8812F)
#define BIT_CLEAR_MGQ_FIFO_REL_INT_MASK_8812F(x)                               \
	((x) & (~BITS_MGQ_FIFO_REL_INT_MASK_8812F))
#define BIT_GET_MGQ_FIFO_REL_INT_MASK_8812F(x)                                 \
	(((x) >> BIT_SHIFT_MGQ_FIFO_REL_INT_MASK_8812F) &                      \
	 BIT_MASK_MGQ_FIFO_REL_INT_MASK_8812F)
#define BIT_SET_MGQ_FIFO_REL_INT_MASK_8812F(x, v)                              \
	(BIT_CLEAR_MGQ_FIFO_REL_INT_MASK_8812F(x) |                            \
	 BIT_MGQ_FIFO_REL_INT_MASK_8812F(v))

/* 2 REG_MGQ_FIFO_RELEASE_INT_FLAG_8812F */

#define BIT_SHIFT_MGQ_FIFO_REL_INT_FLAG_8812F 0
#define BIT_MASK_MGQ_FIFO_REL_INT_FLAG_8812F 0xffff
#define BIT_MGQ_FIFO_REL_INT_FLAG_8812F(x)                                     \
	(((x) & BIT_MASK_MGQ_FIFO_REL_INT_FLAG_8812F)                          \
	 << BIT_SHIFT_MGQ_FIFO_REL_INT_FLAG_8812F)
#define BITS_MGQ_FIFO_REL_INT_FLAG_8812F                                       \
	(BIT_MASK_MGQ_FIFO_REL_INT_FLAG_8812F                                  \
	 << BIT_SHIFT_MGQ_FIFO_REL_INT_FLAG_8812F)
#define BIT_CLEAR_MGQ_FIFO_REL_INT_FLAG_8812F(x)                               \
	((x) & (~BITS_MGQ_FIFO_REL_INT_FLAG_8812F))
#define BIT_GET_MGQ_FIFO_REL_INT_FLAG_8812F(x)                                 \
	(((x) >> BIT_SHIFT_MGQ_FIFO_REL_INT_FLAG_8812F) &                      \
	 BIT_MASK_MGQ_FIFO_REL_INT_FLAG_8812F)
#define BIT_SET_MGQ_FIFO_REL_INT_FLAG_8812F(x, v)                              \
	(BIT_CLEAR_MGQ_FIFO_REL_INT_FLAG_8812F(x) |                            \
	 BIT_MGQ_FIFO_REL_INT_FLAG_8812F(v))

/* 2 REG_MGQ_FIFO_VALID_MAP_8812F */

#define BIT_SHIFT_MGQ_FIFO_PKT_VALID_MAP_8812F 0
#define BIT_MASK_MGQ_FIFO_PKT_VALID_MAP_8812F 0xffff
#define BIT_MGQ_FIFO_PKT_VALID_MAP_8812F(x)                                    \
	(((x) & BIT_MASK_MGQ_FIFO_PKT_VALID_MAP_8812F)                         \
	 << BIT_SHIFT_MGQ_FIFO_PKT_VALID_MAP_8812F)
#define BITS_MGQ_FIFO_PKT_VALID_MAP_8812F                                      \
	(BIT_MASK_MGQ_FIFO_PKT_VALID_MAP_8812F                                 \
	 << BIT_SHIFT_MGQ_FIFO_PKT_VALID_MAP_8812F)
#define BIT_CLEAR_MGQ_FIFO_PKT_VALID_MAP_8812F(x)                              \
	((x) & (~BITS_MGQ_FIFO_PKT_VALID_MAP_8812F))
#define BIT_GET_MGQ_FIFO_PKT_VALID_MAP_8812F(x)                                \
	(((x) >> BIT_SHIFT_MGQ_FIFO_PKT_VALID_MAP_8812F) &                     \
	 BIT_MASK_MGQ_FIFO_PKT_VALID_MAP_8812F)
#define BIT_SET_MGQ_FIFO_PKT_VALID_MAP_8812F(x, v)                             \
	(BIT_CLEAR_MGQ_FIFO_PKT_VALID_MAP_8812F(x) |                           \
	 BIT_MGQ_FIFO_PKT_VALID_MAP_8812F(v))

/* 2 REG_MGQ_FIFO_LIFETIME_8812F */

#define BIT_SHIFT_MGQ_FIFO_LIFETIME_8812F 0
#define BIT_MASK_MGQ_FIFO_LIFETIME_8812F 0xffff
#define BIT_MGQ_FIFO_LIFETIME_8812F(x)                                         \
	(((x) & BIT_MASK_MGQ_FIFO_LIFETIME_8812F)                              \
	 << BIT_SHIFT_MGQ_FIFO_LIFETIME_8812F)
#define BITS_MGQ_FIFO_LIFETIME_8812F                                           \
	(BIT_MASK_MGQ_FIFO_LIFETIME_8812F << BIT_SHIFT_MGQ_FIFO_LIFETIME_8812F)
#define BIT_CLEAR_MGQ_FIFO_LIFETIME_8812F(x)                                   \
	((x) & (~BITS_MGQ_FIFO_LIFETIME_8812F))
#define BIT_GET_MGQ_FIFO_LIFETIME_8812F(x)                                     \
	(((x) >> BIT_SHIFT_MGQ_FIFO_LIFETIME_8812F) &                          \
	 BIT_MASK_MGQ_FIFO_LIFETIME_8812F)
#define BIT_SET_MGQ_FIFO_LIFETIME_8812F(x, v)                                  \
	(BIT_CLEAR_MGQ_FIFO_LIFETIME_8812F(x) | BIT_MGQ_FIFO_LIFETIME_8812F(v))

/* 2 REG_R_MACID_RELEASE_SUCCESS_CLEAR_OFFSET_8812F */

#define BIT_SHIFT_R_MACID_RELEASE_SUCCESS_CLEAR_OFFSET_8812F 0
#define BIT_MASK_R_MACID_RELEASE_SUCCESS_CLEAR_OFFSET_8812F 0x7f
#define BIT_R_MACID_RELEASE_SUCCESS_CLEAR_OFFSET_8812F(x)                      \
	(((x) & BIT_MASK_R_MACID_RELEASE_SUCCESS_CLEAR_OFFSET_8812F)           \
	 << BIT_SHIFT_R_MACID_RELEASE_SUCCESS_CLEAR_OFFSET_8812F)
#define BITS_R_MACID_RELEASE_SUCCESS_CLEAR_OFFSET_8812F                        \
	(BIT_MASK_R_MACID_RELEASE_SUCCESS_CLEAR_OFFSET_8812F                   \
	 << BIT_SHIFT_R_MACID_RELEASE_SUCCESS_CLEAR_OFFSET_8812F)
#define BIT_CLEAR_R_MACID_RELEASE_SUCCESS_CLEAR_OFFSET_8812F(x)                \
	((x) & (~BITS_R_MACID_RELEASE_SUCCESS_CLEAR_OFFSET_8812F))
#define BIT_GET_R_MACID_RELEASE_SUCCESS_CLEAR_OFFSET_8812F(x)                  \
	(((x) >> BIT_SHIFT_R_MACID_RELEASE_SUCCESS_CLEAR_OFFSET_8812F) &       \
	 BIT_MASK_R_MACID_RELEASE_SUCCESS_CLEAR_OFFSET_8812F)
#define BIT_SET_R_MACID_RELEASE_SUCCESS_CLEAR_OFFSET_8812F(x, v)               \
	(BIT_CLEAR_R_MACID_RELEASE_SUCCESS_CLEAR_OFFSET_8812F(x) |             \
	 BIT_R_MACID_RELEASE_SUCCESS_CLEAR_OFFSET_8812F(v))

/* 2 REG_SHCUT_SETTING_8812F */

/* 2 REG_SHCUT_LLC_ETH_TYPE0_8812F */

/* 2 REG_SHCUT_LLC_ETH_TYPE1_8812F */

/* 2 REG_SHCUT_LLC_OUI0_8812F */

/* 2 REG_SHCUT_LLC_OUI1_8812F */

/* 2 REG_SHCUT_LLC_OUI2_8812F */

/* 2 REG_MU_TX_CTL_8812F */
#define BIT_R_MU_P1_WAIT_STATE_EN_8812F BIT(16)

#define BIT_SHIFT_R_MU_RL_8812F 12
#define BIT_MASK_R_MU_RL_8812F 0xf
#define BIT_R_MU_RL_8812F(x)                                                   \
	(((x) & BIT_MASK_R_MU_RL_8812F) << BIT_SHIFT_R_MU_RL_8812F)
#define BITS_R_MU_RL_8812F (BIT_MASK_R_MU_RL_8812F << BIT_SHIFT_R_MU_RL_8812F)
#define BIT_CLEAR_R_MU_RL_8812F(x) ((x) & (~BITS_R_MU_RL_8812F))
#define BIT_GET_R_MU_RL_8812F(x)                                               \
	(((x) >> BIT_SHIFT_R_MU_RL_8812F) & BIT_MASK_R_MU_RL_8812F)
#define BIT_SET_R_MU_RL_8812F(x, v)                                            \
	(BIT_CLEAR_R_MU_RL_8812F(x) | BIT_R_MU_RL_8812F(v))

#define BIT_R_FORCE_P1_RATEDOWN_8812F BIT(11)

#define BIT_SHIFT_R_MU_TAB_SEL_8812F 8
#define BIT_MASK_R_MU_TAB_SEL_8812F 0x7
#define BIT_R_MU_TAB_SEL_8812F(x)                                              \
	(((x) & BIT_MASK_R_MU_TAB_SEL_8812F) << BIT_SHIFT_R_MU_TAB_SEL_8812F)
#define BITS_R_MU_TAB_SEL_8812F                                                \
	(BIT_MASK_R_MU_TAB_SEL_8812F << BIT_SHIFT_R_MU_TAB_SEL_8812F)
#define BIT_CLEAR_R_MU_TAB_SEL_8812F(x) ((x) & (~BITS_R_MU_TAB_SEL_8812F))
#define BIT_GET_R_MU_TAB_SEL_8812F(x)                                          \
	(((x) >> BIT_SHIFT_R_MU_TAB_SEL_8812F) & BIT_MASK_R_MU_TAB_SEL_8812F)
#define BIT_SET_R_MU_TAB_SEL_8812F(x, v)                                       \
	(BIT_CLEAR_R_MU_TAB_SEL_8812F(x) | BIT_R_MU_TAB_SEL_8812F(v))

#define BIT_R_EN_MU_MIMO_8812F BIT(7)
#define BIT_R_EN_REVERS_GTAB_8812F BIT(6)

#define BIT_SHIFT_R_MU_TABLE_VALID_8812F 0
#define BIT_MASK_R_MU_TABLE_VALID_8812F 0x3f
#define BIT_R_MU_TABLE_VALID_8812F(x)                                          \
	(((x) & BIT_MASK_R_MU_TABLE_VALID_8812F)                               \
	 << BIT_SHIFT_R_MU_TABLE_VALID_8812F)
#define BITS_R_MU_TABLE_VALID_8812F                                            \
	(BIT_MASK_R_MU_TABLE_VALID_8812F << BIT_SHIFT_R_MU_TABLE_VALID_8812F)
#define BIT_CLEAR_R_MU_TABLE_VALID_8812F(x)                                    \
	((x) & (~BITS_R_MU_TABLE_VALID_8812F))
#define BIT_GET_R_MU_TABLE_VALID_8812F(x)                                      \
	(((x) >> BIT_SHIFT_R_MU_TABLE_VALID_8812F) &                           \
	 BIT_MASK_R_MU_TABLE_VALID_8812F)
#define BIT_SET_R_MU_TABLE_VALID_8812F(x, v)                                   \
	(BIT_CLEAR_R_MU_TABLE_VALID_8812F(x) | BIT_R_MU_TABLE_VALID_8812F(v))

/* 2 REG_MU_STA_GID_VLD_8812F */

#define BIT_SHIFT_R_MU_STA_GTAB_VALID_8812F 0
#define BIT_MASK_R_MU_STA_GTAB_VALID_8812F 0xffffffffL
#define BIT_R_MU_STA_GTAB_VALID_8812F(x)                                       \
	(((x) & BIT_MASK_R_MU_STA_GTAB_VALID_8812F)                            \
	 << BIT_SHIFT_R_MU_STA_GTAB_VALID_8812F)
#define BITS_R_MU_STA_GTAB_VALID_8812F                                         \
	(BIT_MASK_R_MU_STA_GTAB_VALID_8812F                                    \
	 << BIT_SHIFT_R_MU_STA_GTAB_VALID_8812F)
#define BIT_CLEAR_R_MU_STA_GTAB_VALID_8812F(x)                                 \
	((x) & (~BITS_R_MU_STA_GTAB_VALID_8812F))
#define BIT_GET_R_MU_STA_GTAB_VALID_8812F(x)                                   \
	(((x) >> BIT_SHIFT_R_MU_STA_GTAB_VALID_8812F) &                        \
	 BIT_MASK_R_MU_STA_GTAB_VALID_8812F)
#define BIT_SET_R_MU_STA_GTAB_VALID_8812F(x, v)                                \
	(BIT_CLEAR_R_MU_STA_GTAB_VALID_8812F(x) |                              \
	 BIT_R_MU_STA_GTAB_VALID_8812F(v))

/* 2 REG_MU_STA_USER_POS_INFO_8812F */

#define BIT_SHIFT_R_MU_STA_GTAB_POSITION_L_8812F 0
#define BIT_MASK_R_MU_STA_GTAB_POSITION_L_8812F 0xffffffffL
#define BIT_R_MU_STA_GTAB_POSITION_L_8812F(x)                                  \
	(((x) & BIT_MASK_R_MU_STA_GTAB_POSITION_L_8812F)                       \
	 << BIT_SHIFT_R_MU_STA_GTAB_POSITION_L_8812F)
#define BITS_R_MU_STA_GTAB_POSITION_L_8812F                                    \
	(BIT_MASK_R_MU_STA_GTAB_POSITION_L_8812F                               \
	 << BIT_SHIFT_R_MU_STA_GTAB_POSITION_L_8812F)
#define BIT_CLEAR_R_MU_STA_GTAB_POSITION_L_8812F(x)                            \
	((x) & (~BITS_R_MU_STA_GTAB_POSITION_L_8812F))
#define BIT_GET_R_MU_STA_GTAB_POSITION_L_8812F(x)                              \
	(((x) >> BIT_SHIFT_R_MU_STA_GTAB_POSITION_L_8812F) &                   \
	 BIT_MASK_R_MU_STA_GTAB_POSITION_L_8812F)
#define BIT_SET_R_MU_STA_GTAB_POSITION_L_8812F(x, v)                           \
	(BIT_CLEAR_R_MU_STA_GTAB_POSITION_L_8812F(x) |                         \
	 BIT_R_MU_STA_GTAB_POSITION_L_8812F(v))

/* 2 REG_MU_STA_USER_POS_INFO_H_8812F */

#define BIT_SHIFT_R_MU_STA_GTAB_POSITION_H_8812F 0
#define BIT_MASK_R_MU_STA_GTAB_POSITION_H_8812F 0xffffffffL
#define BIT_R_MU_STA_GTAB_POSITION_H_8812F(x)                                  \
	(((x) & BIT_MASK_R_MU_STA_GTAB_POSITION_H_8812F)                       \
	 << BIT_SHIFT_R_MU_STA_GTAB_POSITION_H_8812F)
#define BITS_R_MU_STA_GTAB_POSITION_H_8812F                                    \
	(BIT_MASK_R_MU_STA_GTAB_POSITION_H_8812F                               \
	 << BIT_SHIFT_R_MU_STA_GTAB_POSITION_H_8812F)
#define BIT_CLEAR_R_MU_STA_GTAB_POSITION_H_8812F(x)                            \
	((x) & (~BITS_R_MU_STA_GTAB_POSITION_H_8812F))
#define BIT_GET_R_MU_STA_GTAB_POSITION_H_8812F(x)                              \
	(((x) >> BIT_SHIFT_R_MU_STA_GTAB_POSITION_H_8812F) &                   \
	 BIT_MASK_R_MU_STA_GTAB_POSITION_H_8812F)
#define BIT_SET_R_MU_STA_GTAB_POSITION_H_8812F(x, v)                           \
	(BIT_CLEAR_R_MU_STA_GTAB_POSITION_H_8812F(x) |                         \
	 BIT_R_MU_STA_GTAB_POSITION_H_8812F(v))

/* 2 REG_CHNL_INFO_CTRL_8812F */
#define BIT_CHNL_REF_RXNAV_8812F BIT(7)
#define BIT_CHNL_REF_VBON_8812F BIT(6)
#define BIT_CHNL_REF_EDCA_8812F BIT(5)
#define BIT_CHNL_REF_CCA_8812F BIT(4)
#define BIT_RST_CHNL_BUSY_8812F BIT(3)
#define BIT_RST_CHNL_IDLE_8812F BIT(2)
#define BIT_CHNL_INFO_RST_8812F BIT(1)
#define BIT_ATM_AIRTIME_EN_8812F BIT(0)

/* 2 REG_CHNL_IDLE_TIME_8812F */

#define BIT_SHIFT_CHNL_IDLE_TIME_8812F 0
#define BIT_MASK_CHNL_IDLE_TIME_8812F 0xffffffffL
#define BIT_CHNL_IDLE_TIME_8812F(x)                                            \
	(((x) & BIT_MASK_CHNL_IDLE_TIME_8812F)                                 \
	 << BIT_SHIFT_CHNL_IDLE_TIME_8812F)
#define BITS_CHNL_IDLE_TIME_8812F                                              \
	(BIT_MASK_CHNL_IDLE_TIME_8812F << BIT_SHIFT_CHNL_IDLE_TIME_8812F)
#define BIT_CLEAR_CHNL_IDLE_TIME_8812F(x) ((x) & (~BITS_CHNL_IDLE_TIME_8812F))
#define BIT_GET_CHNL_IDLE_TIME_8812F(x)                                        \
	(((x) >> BIT_SHIFT_CHNL_IDLE_TIME_8812F) &                             \
	 BIT_MASK_CHNL_IDLE_TIME_8812F)
#define BIT_SET_CHNL_IDLE_TIME_8812F(x, v)                                     \
	(BIT_CLEAR_CHNL_IDLE_TIME_8812F(x) | BIT_CHNL_IDLE_TIME_8812F(v))

/* 2 REG_CHNL_BUSY_TIME_8812F */

#define BIT_SHIFT_CHNL_BUSY_TIME_8812F 0
#define BIT_MASK_CHNL_BUSY_TIME_8812F 0xffffffffL
#define BIT_CHNL_BUSY_TIME_8812F(x)                                            \
	(((x) & BIT_MASK_CHNL_BUSY_TIME_8812F)                                 \
	 << BIT_SHIFT_CHNL_BUSY_TIME_8812F)
#define BITS_CHNL_BUSY_TIME_8812F                                              \
	(BIT_MASK_CHNL_BUSY_TIME_8812F << BIT_SHIFT_CHNL_BUSY_TIME_8812F)
#define BIT_CLEAR_CHNL_BUSY_TIME_8812F(x) ((x) & (~BITS_CHNL_BUSY_TIME_8812F))
#define BIT_GET_CHNL_BUSY_TIME_8812F(x)                                        \
	(((x) >> BIT_SHIFT_CHNL_BUSY_TIME_8812F) &                             \
	 BIT_MASK_CHNL_BUSY_TIME_8812F)
#define BIT_SET_CHNL_BUSY_TIME_8812F(x, v)                                     \
	(BIT_CLEAR_CHNL_BUSY_TIME_8812F(x) | BIT_CHNL_BUSY_TIME_8812F(v))

/* 2 REG_MU_TRX_DBG_CNT_V1_8812F */
#define BIT_MU_DNGCNT_RST_8812F BIT(20)

#define BIT_SHIFT_MU_DNGCNT_SEL_8812F 16
#define BIT_MASK_MU_DNGCNT_SEL_8812F 0xf
#define BIT_MU_DNGCNT_SEL_8812F(x)                                             \
	(((x) & BIT_MASK_MU_DNGCNT_SEL_8812F) << BIT_SHIFT_MU_DNGCNT_SEL_8812F)
#define BITS_MU_DNGCNT_SEL_8812F                                               \
	(BIT_MASK_MU_DNGCNT_SEL_8812F << BIT_SHIFT_MU_DNGCNT_SEL_8812F)
#define BIT_CLEAR_MU_DNGCNT_SEL_8812F(x) ((x) & (~BITS_MU_DNGCNT_SEL_8812F))
#define BIT_GET_MU_DNGCNT_SEL_8812F(x)                                         \
	(((x) >> BIT_SHIFT_MU_DNGCNT_SEL_8812F) & BIT_MASK_MU_DNGCNT_SEL_8812F)
#define BIT_SET_MU_DNGCNT_SEL_8812F(x, v)                                      \
	(BIT_CLEAR_MU_DNGCNT_SEL_8812F(x) | BIT_MU_DNGCNT_SEL_8812F(v))

#define BIT_SHIFT_MU_DNGCNT_8812F 0
#define BIT_MASK_MU_DNGCNT_8812F 0xffff
#define BIT_MU_DNGCNT_8812F(x)                                                 \
	(((x) & BIT_MASK_MU_DNGCNT_8812F) << BIT_SHIFT_MU_DNGCNT_8812F)
#define BITS_MU_DNGCNT_8812F                                                   \
	(BIT_MASK_MU_DNGCNT_8812F << BIT_SHIFT_MU_DNGCNT_8812F)
#define BIT_CLEAR_MU_DNGCNT_8812F(x) ((x) & (~BITS_MU_DNGCNT_8812F))
#define BIT_GET_MU_DNGCNT_8812F(x)                                             \
	(((x) >> BIT_SHIFT_MU_DNGCNT_8812F) & BIT_MASK_MU_DNGCNT_8812F)
#define BIT_SET_MU_DNGCNT_8812F(x, v)                                          \
	(BIT_CLEAR_MU_DNGCNT_8812F(x) | BIT_MU_DNGCNT_8812F(v))

/* 2 REG_SU_DURATION_8812F */

#define BIT_SHIFT_SU_DURATION_8812F 0
#define BIT_MASK_SU_DURATION_8812F 0xffff
#define BIT_SU_DURATION_8812F(x)                                               \
	(((x) & BIT_MASK_SU_DURATION_8812F) << BIT_SHIFT_SU_DURATION_8812F)
#define BITS_SU_DURATION_8812F                                                 \
	(BIT_MASK_SU_DURATION_8812F << BIT_SHIFT_SU_DURATION_8812F)
#define BIT_CLEAR_SU_DURATION_8812F(x) ((x) & (~BITS_SU_DURATION_8812F))
#define BIT_GET_SU_DURATION_8812F(x)                                           \
	(((x) >> BIT_SHIFT_SU_DURATION_8812F) & BIT_MASK_SU_DURATION_8812F)
#define BIT_SET_SU_DURATION_8812F(x, v)                                        \
	(BIT_CLEAR_SU_DURATION_8812F(x) | BIT_SU_DURATION_8812F(v))

/* 2 REG_MU_DURATION_8812F */

#define BIT_SHIFT_MU_DURATION_8812F 0
#define BIT_MASK_MU_DURATION_8812F 0xffff
#define BIT_MU_DURATION_8812F(x)                                               \
	(((x) & BIT_MASK_MU_DURATION_8812F) << BIT_SHIFT_MU_DURATION_8812F)
#define BITS_MU_DURATION_8812F                                                 \
	(BIT_MASK_MU_DURATION_8812F << BIT_SHIFT_MU_DURATION_8812F)
#define BIT_CLEAR_MU_DURATION_8812F(x) ((x) & (~BITS_MU_DURATION_8812F))
#define BIT_GET_MU_DURATION_8812F(x)                                           \
	(((x) >> BIT_SHIFT_MU_DURATION_8812F) & BIT_MASK_MU_DURATION_8812F)
#define BIT_SET_MU_DURATION_8812F(x, v)                                        \
	(BIT_CLEAR_MU_DURATION_8812F(x) | BIT_MU_DURATION_8812F(v))

/* 2 REG_HW_NDPA_RTY_LIMIT_8812F */

#define BIT_SHIFT_HW_NDPA_RTY_LIMIT_8812F 0
#define BIT_MASK_HW_NDPA_RTY_LIMIT_8812F 0xf
#define BIT_HW_NDPA_RTY_LIMIT_8812F(x)                                         \
	(((x) & BIT_MASK_HW_NDPA_RTY_LIMIT_8812F)                              \
	 << BIT_SHIFT_HW_NDPA_RTY_LIMIT_8812F)
#define BITS_HW_NDPA_RTY_LIMIT_8812F                                           \
	(BIT_MASK_HW_NDPA_RTY_LIMIT_8812F << BIT_SHIFT_HW_NDPA_RTY_LIMIT_8812F)
#define BIT_CLEAR_HW_NDPA_RTY_LIMIT_8812F(x)                                   \
	((x) & (~BITS_HW_NDPA_RTY_LIMIT_8812F))
#define BIT_GET_HW_NDPA_RTY_LIMIT_8812F(x)                                     \
	(((x) >> BIT_SHIFT_HW_NDPA_RTY_LIMIT_8812F) &                          \
	 BIT_MASK_HW_NDPA_RTY_LIMIT_8812F)
#define BIT_SET_HW_NDPA_RTY_LIMIT_8812F(x, v)                                  \
	(BIT_CLEAR_HW_NDPA_RTY_LIMIT_8812F(x) | BIT_HW_NDPA_RTY_LIMIT_8812F(v))

/* 2 REG_RSVD_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_EDCA_VO_PARAM_8812F */

#define BIT_SHIFT_TXOPLIMIT_8812F 16
#define BIT_MASK_TXOPLIMIT_8812F 0x7ff
#define BIT_TXOPLIMIT_8812F(x)                                                 \
	(((x) & BIT_MASK_TXOPLIMIT_8812F) << BIT_SHIFT_TXOPLIMIT_8812F)
#define BITS_TXOPLIMIT_8812F                                                   \
	(BIT_MASK_TXOPLIMIT_8812F << BIT_SHIFT_TXOPLIMIT_8812F)
#define BIT_CLEAR_TXOPLIMIT_8812F(x) ((x) & (~BITS_TXOPLIMIT_8812F))
#define BIT_GET_TXOPLIMIT_8812F(x)                                             \
	(((x) >> BIT_SHIFT_TXOPLIMIT_8812F) & BIT_MASK_TXOPLIMIT_8812F)
#define BIT_SET_TXOPLIMIT_8812F(x, v)                                          \
	(BIT_CLEAR_TXOPLIMIT_8812F(x) | BIT_TXOPLIMIT_8812F(v))

#define BIT_SHIFT_CW_8812F 8
#define BIT_MASK_CW_8812F 0xff
#define BIT_CW_8812F(x) (((x) & BIT_MASK_CW_8812F) << BIT_SHIFT_CW_8812F)
#define BITS_CW_8812F (BIT_MASK_CW_8812F << BIT_SHIFT_CW_8812F)
#define BIT_CLEAR_CW_8812F(x) ((x) & (~BITS_CW_8812F))
#define BIT_GET_CW_8812F(x) (((x) >> BIT_SHIFT_CW_8812F) & BIT_MASK_CW_8812F)
#define BIT_SET_CW_8812F(x, v) (BIT_CLEAR_CW_8812F(x) | BIT_CW_8812F(v))

#define BIT_SHIFT_AIFS_8812F 0
#define BIT_MASK_AIFS_8812F 0xff
#define BIT_AIFS_8812F(x) (((x) & BIT_MASK_AIFS_8812F) << BIT_SHIFT_AIFS_8812F)
#define BITS_AIFS_8812F (BIT_MASK_AIFS_8812F << BIT_SHIFT_AIFS_8812F)
#define BIT_CLEAR_AIFS_8812F(x) ((x) & (~BITS_AIFS_8812F))
#define BIT_GET_AIFS_8812F(x)                                                  \
	(((x) >> BIT_SHIFT_AIFS_8812F) & BIT_MASK_AIFS_8812F)
#define BIT_SET_AIFS_8812F(x, v) (BIT_CLEAR_AIFS_8812F(x) | BIT_AIFS_8812F(v))

/* 2 REG_EDCA_VI_PARAM_8812F */

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_TXOPLIMIT_8812F 16
#define BIT_MASK_TXOPLIMIT_8812F 0x7ff
#define BIT_TXOPLIMIT_8812F(x)                                                 \
	(((x) & BIT_MASK_TXOPLIMIT_8812F) << BIT_SHIFT_TXOPLIMIT_8812F)
#define BITS_TXOPLIMIT_8812F                                                   \
	(BIT_MASK_TXOPLIMIT_8812F << BIT_SHIFT_TXOPLIMIT_8812F)
#define BIT_CLEAR_TXOPLIMIT_8812F(x) ((x) & (~BITS_TXOPLIMIT_8812F))
#define BIT_GET_TXOPLIMIT_8812F(x)                                             \
	(((x) >> BIT_SHIFT_TXOPLIMIT_8812F) & BIT_MASK_TXOPLIMIT_8812F)
#define BIT_SET_TXOPLIMIT_8812F(x, v)                                          \
	(BIT_CLEAR_TXOPLIMIT_8812F(x) | BIT_TXOPLIMIT_8812F(v))

#define BIT_SHIFT_CW_8812F 8
#define BIT_MASK_CW_8812F 0xff
#define BIT_CW_8812F(x) (((x) & BIT_MASK_CW_8812F) << BIT_SHIFT_CW_8812F)
#define BITS_CW_8812F (BIT_MASK_CW_8812F << BIT_SHIFT_CW_8812F)
#define BIT_CLEAR_CW_8812F(x) ((x) & (~BITS_CW_8812F))
#define BIT_GET_CW_8812F(x) (((x) >> BIT_SHIFT_CW_8812F) & BIT_MASK_CW_8812F)
#define BIT_SET_CW_8812F(x, v) (BIT_CLEAR_CW_8812F(x) | BIT_CW_8812F(v))

#define BIT_SHIFT_AIFS_8812F 0
#define BIT_MASK_AIFS_8812F 0xff
#define BIT_AIFS_8812F(x) (((x) & BIT_MASK_AIFS_8812F) << BIT_SHIFT_AIFS_8812F)
#define BITS_AIFS_8812F (BIT_MASK_AIFS_8812F << BIT_SHIFT_AIFS_8812F)
#define BIT_CLEAR_AIFS_8812F(x) ((x) & (~BITS_AIFS_8812F))
#define BIT_GET_AIFS_8812F(x)                                                  \
	(((x) >> BIT_SHIFT_AIFS_8812F) & BIT_MASK_AIFS_8812F)
#define BIT_SET_AIFS_8812F(x, v) (BIT_CLEAR_AIFS_8812F(x) | BIT_AIFS_8812F(v))

/* 2 REG_EDCA_BE_PARAM_8812F */

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_TXOPLIMIT_8812F 16
#define BIT_MASK_TXOPLIMIT_8812F 0x7ff
#define BIT_TXOPLIMIT_8812F(x)                                                 \
	(((x) & BIT_MASK_TXOPLIMIT_8812F) << BIT_SHIFT_TXOPLIMIT_8812F)
#define BITS_TXOPLIMIT_8812F                                                   \
	(BIT_MASK_TXOPLIMIT_8812F << BIT_SHIFT_TXOPLIMIT_8812F)
#define BIT_CLEAR_TXOPLIMIT_8812F(x) ((x) & (~BITS_TXOPLIMIT_8812F))
#define BIT_GET_TXOPLIMIT_8812F(x)                                             \
	(((x) >> BIT_SHIFT_TXOPLIMIT_8812F) & BIT_MASK_TXOPLIMIT_8812F)
#define BIT_SET_TXOPLIMIT_8812F(x, v)                                          \
	(BIT_CLEAR_TXOPLIMIT_8812F(x) | BIT_TXOPLIMIT_8812F(v))

#define BIT_SHIFT_CW_8812F 8
#define BIT_MASK_CW_8812F 0xff
#define BIT_CW_8812F(x) (((x) & BIT_MASK_CW_8812F) << BIT_SHIFT_CW_8812F)
#define BITS_CW_8812F (BIT_MASK_CW_8812F << BIT_SHIFT_CW_8812F)
#define BIT_CLEAR_CW_8812F(x) ((x) & (~BITS_CW_8812F))
#define BIT_GET_CW_8812F(x) (((x) >> BIT_SHIFT_CW_8812F) & BIT_MASK_CW_8812F)
#define BIT_SET_CW_8812F(x, v) (BIT_CLEAR_CW_8812F(x) | BIT_CW_8812F(v))

#define BIT_SHIFT_AIFS_8812F 0
#define BIT_MASK_AIFS_8812F 0xff
#define BIT_AIFS_8812F(x) (((x) & BIT_MASK_AIFS_8812F) << BIT_SHIFT_AIFS_8812F)
#define BITS_AIFS_8812F (BIT_MASK_AIFS_8812F << BIT_SHIFT_AIFS_8812F)
#define BIT_CLEAR_AIFS_8812F(x) ((x) & (~BITS_AIFS_8812F))
#define BIT_GET_AIFS_8812F(x)                                                  \
	(((x) >> BIT_SHIFT_AIFS_8812F) & BIT_MASK_AIFS_8812F)
#define BIT_SET_AIFS_8812F(x, v) (BIT_CLEAR_AIFS_8812F(x) | BIT_AIFS_8812F(v))

/* 2 REG_EDCA_BK_PARAM_8812F */

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_TXOPLIMIT_8812F 16
#define BIT_MASK_TXOPLIMIT_8812F 0x7ff
#define BIT_TXOPLIMIT_8812F(x)                                                 \
	(((x) & BIT_MASK_TXOPLIMIT_8812F) << BIT_SHIFT_TXOPLIMIT_8812F)
#define BITS_TXOPLIMIT_8812F                                                   \
	(BIT_MASK_TXOPLIMIT_8812F << BIT_SHIFT_TXOPLIMIT_8812F)
#define BIT_CLEAR_TXOPLIMIT_8812F(x) ((x) & (~BITS_TXOPLIMIT_8812F))
#define BIT_GET_TXOPLIMIT_8812F(x)                                             \
	(((x) >> BIT_SHIFT_TXOPLIMIT_8812F) & BIT_MASK_TXOPLIMIT_8812F)
#define BIT_SET_TXOPLIMIT_8812F(x, v)                                          \
	(BIT_CLEAR_TXOPLIMIT_8812F(x) | BIT_TXOPLIMIT_8812F(v))

#define BIT_SHIFT_CW_8812F 8
#define BIT_MASK_CW_8812F 0xff
#define BIT_CW_8812F(x) (((x) & BIT_MASK_CW_8812F) << BIT_SHIFT_CW_8812F)
#define BITS_CW_8812F (BIT_MASK_CW_8812F << BIT_SHIFT_CW_8812F)
#define BIT_CLEAR_CW_8812F(x) ((x) & (~BITS_CW_8812F))
#define BIT_GET_CW_8812F(x) (((x) >> BIT_SHIFT_CW_8812F) & BIT_MASK_CW_8812F)
#define BIT_SET_CW_8812F(x, v) (BIT_CLEAR_CW_8812F(x) | BIT_CW_8812F(v))

#define BIT_SHIFT_AIFS_8812F 0
#define BIT_MASK_AIFS_8812F 0xff
#define BIT_AIFS_8812F(x) (((x) & BIT_MASK_AIFS_8812F) << BIT_SHIFT_AIFS_8812F)
#define BITS_AIFS_8812F (BIT_MASK_AIFS_8812F << BIT_SHIFT_AIFS_8812F)
#define BIT_CLEAR_AIFS_8812F(x) ((x) & (~BITS_AIFS_8812F))
#define BIT_GET_AIFS_8812F(x)                                                  \
	(((x) >> BIT_SHIFT_AIFS_8812F) & BIT_MASK_AIFS_8812F)
#define BIT_SET_AIFS_8812F(x, v) (BIT_CLEAR_AIFS_8812F(x) | BIT_AIFS_8812F(v))

/* 2 REG_BCNTCFG_8812F */

#define BIT_SHIFT_BCNCW_MAX_8812F 12
#define BIT_MASK_BCNCW_MAX_8812F 0xf
#define BIT_BCNCW_MAX_8812F(x)                                                 \
	(((x) & BIT_MASK_BCNCW_MAX_8812F) << BIT_SHIFT_BCNCW_MAX_8812F)
#define BITS_BCNCW_MAX_8812F                                                   \
	(BIT_MASK_BCNCW_MAX_8812F << BIT_SHIFT_BCNCW_MAX_8812F)
#define BIT_CLEAR_BCNCW_MAX_8812F(x) ((x) & (~BITS_BCNCW_MAX_8812F))
#define BIT_GET_BCNCW_MAX_8812F(x)                                             \
	(((x) >> BIT_SHIFT_BCNCW_MAX_8812F) & BIT_MASK_BCNCW_MAX_8812F)
#define BIT_SET_BCNCW_MAX_8812F(x, v)                                          \
	(BIT_CLEAR_BCNCW_MAX_8812F(x) | BIT_BCNCW_MAX_8812F(v))

#define BIT_SHIFT_BCNCW_MIN_8812F 8
#define BIT_MASK_BCNCW_MIN_8812F 0xf
#define BIT_BCNCW_MIN_8812F(x)                                                 \
	(((x) & BIT_MASK_BCNCW_MIN_8812F) << BIT_SHIFT_BCNCW_MIN_8812F)
#define BITS_BCNCW_MIN_8812F                                                   \
	(BIT_MASK_BCNCW_MIN_8812F << BIT_SHIFT_BCNCW_MIN_8812F)
#define BIT_CLEAR_BCNCW_MIN_8812F(x) ((x) & (~BITS_BCNCW_MIN_8812F))
#define BIT_GET_BCNCW_MIN_8812F(x)                                             \
	(((x) >> BIT_SHIFT_BCNCW_MIN_8812F) & BIT_MASK_BCNCW_MIN_8812F)
#define BIT_SET_BCNCW_MIN_8812F(x, v)                                          \
	(BIT_CLEAR_BCNCW_MIN_8812F(x) | BIT_BCNCW_MIN_8812F(v))

#define BIT_SHIFT_BCNIFS_8812F 0
#define BIT_MASK_BCNIFS_8812F 0xff
#define BIT_BCNIFS_8812F(x)                                                    \
	(((x) & BIT_MASK_BCNIFS_8812F) << BIT_SHIFT_BCNIFS_8812F)
#define BITS_BCNIFS_8812F (BIT_MASK_BCNIFS_8812F << BIT_SHIFT_BCNIFS_8812F)
#define BIT_CLEAR_BCNIFS_8812F(x) ((x) & (~BITS_BCNIFS_8812F))
#define BIT_GET_BCNIFS_8812F(x)                                                \
	(((x) >> BIT_SHIFT_BCNIFS_8812F) & BIT_MASK_BCNIFS_8812F)
#define BIT_SET_BCNIFS_8812F(x, v)                                             \
	(BIT_CLEAR_BCNIFS_8812F(x) | BIT_BCNIFS_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_PIFS_8812F */

#define BIT_SHIFT_PIFS_8812F 0
#define BIT_MASK_PIFS_8812F 0xff
#define BIT_PIFS_8812F(x) (((x) & BIT_MASK_PIFS_8812F) << BIT_SHIFT_PIFS_8812F)
#define BITS_PIFS_8812F (BIT_MASK_PIFS_8812F << BIT_SHIFT_PIFS_8812F)
#define BIT_CLEAR_PIFS_8812F(x) ((x) & (~BITS_PIFS_8812F))
#define BIT_GET_PIFS_8812F(x)                                                  \
	(((x) >> BIT_SHIFT_PIFS_8812F) & BIT_MASK_PIFS_8812F)
#define BIT_SET_PIFS_8812F(x, v) (BIT_CLEAR_PIFS_8812F(x) | BIT_PIFS_8812F(v))

/* 2 REG_RDG_PIFS_8812F */

#define BIT_SHIFT_RDG_PIFS_8812F 0
#define BIT_MASK_RDG_PIFS_8812F 0xff
#define BIT_RDG_PIFS_8812F(x)                                                  \
	(((x) & BIT_MASK_RDG_PIFS_8812F) << BIT_SHIFT_RDG_PIFS_8812F)
#define BITS_RDG_PIFS_8812F                                                    \
	(BIT_MASK_RDG_PIFS_8812F << BIT_SHIFT_RDG_PIFS_8812F)
#define BIT_CLEAR_RDG_PIFS_8812F(x) ((x) & (~BITS_RDG_PIFS_8812F))
#define BIT_GET_RDG_PIFS_8812F(x)                                              \
	(((x) >> BIT_SHIFT_RDG_PIFS_8812F) & BIT_MASK_RDG_PIFS_8812F)
#define BIT_SET_RDG_PIFS_8812F(x, v)                                           \
	(BIT_CLEAR_RDG_PIFS_8812F(x) | BIT_RDG_PIFS_8812F(v))

/* 2 REG_SIFS_8812F */

#define BIT_SHIFT_SIFS_OFDM_TRX_8812F 24
#define BIT_MASK_SIFS_OFDM_TRX_8812F 0xff
#define BIT_SIFS_OFDM_TRX_8812F(x)                                             \
	(((x) & BIT_MASK_SIFS_OFDM_TRX_8812F) << BIT_SHIFT_SIFS_OFDM_TRX_8812F)
#define BITS_SIFS_OFDM_TRX_8812F                                               \
	(BIT_MASK_SIFS_OFDM_TRX_8812F << BIT_SHIFT_SIFS_OFDM_TRX_8812F)
#define BIT_CLEAR_SIFS_OFDM_TRX_8812F(x) ((x) & (~BITS_SIFS_OFDM_TRX_8812F))
#define BIT_GET_SIFS_OFDM_TRX_8812F(x)                                         \
	(((x) >> BIT_SHIFT_SIFS_OFDM_TRX_8812F) & BIT_MASK_SIFS_OFDM_TRX_8812F)
#define BIT_SET_SIFS_OFDM_TRX_8812F(x, v)                                      \
	(BIT_CLEAR_SIFS_OFDM_TRX_8812F(x) | BIT_SIFS_OFDM_TRX_8812F(v))

#define BIT_SHIFT_SIFS_CCK_TRX_8812F 16
#define BIT_MASK_SIFS_CCK_TRX_8812F 0xff
#define BIT_SIFS_CCK_TRX_8812F(x)                                              \
	(((x) & BIT_MASK_SIFS_CCK_TRX_8812F) << BIT_SHIFT_SIFS_CCK_TRX_8812F)
#define BITS_SIFS_CCK_TRX_8812F                                                \
	(BIT_MASK_SIFS_CCK_TRX_8812F << BIT_SHIFT_SIFS_CCK_TRX_8812F)
#define BIT_CLEAR_SIFS_CCK_TRX_8812F(x) ((x) & (~BITS_SIFS_CCK_TRX_8812F))
#define BIT_GET_SIFS_CCK_TRX_8812F(x)                                          \
	(((x) >> BIT_SHIFT_SIFS_CCK_TRX_8812F) & BIT_MASK_SIFS_CCK_TRX_8812F)
#define BIT_SET_SIFS_CCK_TRX_8812F(x, v)                                       \
	(BIT_CLEAR_SIFS_CCK_TRX_8812F(x) | BIT_SIFS_CCK_TRX_8812F(v))

#define BIT_SHIFT_SIFS_OFDM_CTX_8812F 8
#define BIT_MASK_SIFS_OFDM_CTX_8812F 0xff
#define BIT_SIFS_OFDM_CTX_8812F(x)                                             \
	(((x) & BIT_MASK_SIFS_OFDM_CTX_8812F) << BIT_SHIFT_SIFS_OFDM_CTX_8812F)
#define BITS_SIFS_OFDM_CTX_8812F                                               \
	(BIT_MASK_SIFS_OFDM_CTX_8812F << BIT_SHIFT_SIFS_OFDM_CTX_8812F)
#define BIT_CLEAR_SIFS_OFDM_CTX_8812F(x) ((x) & (~BITS_SIFS_OFDM_CTX_8812F))
#define BIT_GET_SIFS_OFDM_CTX_8812F(x)                                         \
	(((x) >> BIT_SHIFT_SIFS_OFDM_CTX_8812F) & BIT_MASK_SIFS_OFDM_CTX_8812F)
#define BIT_SET_SIFS_OFDM_CTX_8812F(x, v)                                      \
	(BIT_CLEAR_SIFS_OFDM_CTX_8812F(x) | BIT_SIFS_OFDM_CTX_8812F(v))

#define BIT_SHIFT_SIFS_CCK_CTX_8812F 0
#define BIT_MASK_SIFS_CCK_CTX_8812F 0xff
#define BIT_SIFS_CCK_CTX_8812F(x)                                              \
	(((x) & BIT_MASK_SIFS_CCK_CTX_8812F) << BIT_SHIFT_SIFS_CCK_CTX_8812F)
#define BITS_SIFS_CCK_CTX_8812F                                                \
	(BIT_MASK_SIFS_CCK_CTX_8812F << BIT_SHIFT_SIFS_CCK_CTX_8812F)
#define BIT_CLEAR_SIFS_CCK_CTX_8812F(x) ((x) & (~BITS_SIFS_CCK_CTX_8812F))
#define BIT_GET_SIFS_CCK_CTX_8812F(x)                                          \
	(((x) >> BIT_SHIFT_SIFS_CCK_CTX_8812F) & BIT_MASK_SIFS_CCK_CTX_8812F)
#define BIT_SET_SIFS_CCK_CTX_8812F(x, v)                                       \
	(BIT_CLEAR_SIFS_CCK_CTX_8812F(x) | BIT_SIFS_CCK_CTX_8812F(v))

/* 2 REG_TSFTR_SYN_OFFSET_8812F */

#define BIT_SHIFT_TSFTR_SNC_OFFSET_8812F 0
#define BIT_MASK_TSFTR_SNC_OFFSET_8812F 0xffff
#define BIT_TSFTR_SNC_OFFSET_8812F(x)                                          \
	(((x) & BIT_MASK_TSFTR_SNC_OFFSET_8812F)                               \
	 << BIT_SHIFT_TSFTR_SNC_OFFSET_8812F)
#define BITS_TSFTR_SNC_OFFSET_8812F                                            \
	(BIT_MASK_TSFTR_SNC_OFFSET_8812F << BIT_SHIFT_TSFTR_SNC_OFFSET_8812F)
#define BIT_CLEAR_TSFTR_SNC_OFFSET_8812F(x)                                    \
	((x) & (~BITS_TSFTR_SNC_OFFSET_8812F))
#define BIT_GET_TSFTR_SNC_OFFSET_8812F(x)                                      \
	(((x) >> BIT_SHIFT_TSFTR_SNC_OFFSET_8812F) &                           \
	 BIT_MASK_TSFTR_SNC_OFFSET_8812F)
#define BIT_SET_TSFTR_SNC_OFFSET_8812F(x, v)                                   \
	(BIT_CLEAR_TSFTR_SNC_OFFSET_8812F(x) | BIT_TSFTR_SNC_OFFSET_8812F(v))

/* 2 REG_AGGR_BREAK_TIME_8812F */

#define BIT_SHIFT_AGGR_BK_TIME_8812F 0
#define BIT_MASK_AGGR_BK_TIME_8812F 0xff
#define BIT_AGGR_BK_TIME_8812F(x)                                              \
	(((x) & BIT_MASK_AGGR_BK_TIME_8812F) << BIT_SHIFT_AGGR_BK_TIME_8812F)
#define BITS_AGGR_BK_TIME_8812F                                                \
	(BIT_MASK_AGGR_BK_TIME_8812F << BIT_SHIFT_AGGR_BK_TIME_8812F)
#define BIT_CLEAR_AGGR_BK_TIME_8812F(x) ((x) & (~BITS_AGGR_BK_TIME_8812F))
#define BIT_GET_AGGR_BK_TIME_8812F(x)                                          \
	(((x) >> BIT_SHIFT_AGGR_BK_TIME_8812F) & BIT_MASK_AGGR_BK_TIME_8812F)
#define BIT_SET_AGGR_BK_TIME_8812F(x, v)                                       \
	(BIT_CLEAR_AGGR_BK_TIME_8812F(x) | BIT_AGGR_BK_TIME_8812F(v))

/* 2 REG_SLOT_8812F */

#define BIT_SHIFT_SLOT_8812F 0
#define BIT_MASK_SLOT_8812F 0xff
#define BIT_SLOT_8812F(x) (((x) & BIT_MASK_SLOT_8812F) << BIT_SHIFT_SLOT_8812F)
#define BITS_SLOT_8812F (BIT_MASK_SLOT_8812F << BIT_SHIFT_SLOT_8812F)
#define BIT_CLEAR_SLOT_8812F(x) ((x) & (~BITS_SLOT_8812F))
#define BIT_GET_SLOT_8812F(x)                                                  \
	(((x) >> BIT_SHIFT_SLOT_8812F) & BIT_MASK_SLOT_8812F)
#define BIT_SET_SLOT_8812F(x, v) (BIT_CLEAR_SLOT_8812F(x) | BIT_SLOT_8812F(v))

/* 2 REG_NOA_ON_ERLY_TIME_8812F */

#define BIT_SHIFT__NOA_ON_ERLY_TIME_8812F 0
#define BIT_MASK__NOA_ON_ERLY_TIME_8812F 0xff
#define BIT__NOA_ON_ERLY_TIME_8812F(x)                                         \
	(((x) & BIT_MASK__NOA_ON_ERLY_TIME_8812F)                              \
	 << BIT_SHIFT__NOA_ON_ERLY_TIME_8812F)
#define BITS__NOA_ON_ERLY_TIME_8812F                                           \
	(BIT_MASK__NOA_ON_ERLY_TIME_8812F << BIT_SHIFT__NOA_ON_ERLY_TIME_8812F)
#define BIT_CLEAR__NOA_ON_ERLY_TIME_8812F(x)                                   \
	((x) & (~BITS__NOA_ON_ERLY_TIME_8812F))
#define BIT_GET__NOA_ON_ERLY_TIME_8812F(x)                                     \
	(((x) >> BIT_SHIFT__NOA_ON_ERLY_TIME_8812F) &                          \
	 BIT_MASK__NOA_ON_ERLY_TIME_8812F)
#define BIT_SET__NOA_ON_ERLY_TIME_8812F(x, v)                                  \
	(BIT_CLEAR__NOA_ON_ERLY_TIME_8812F(x) | BIT__NOA_ON_ERLY_TIME_8812F(v))

/* 2 REG_NOA_OFF_ERLY_TIME_8812F */

#define BIT_SHIFT__NOA_OFF_ERLY_TIME_8812F 0
#define BIT_MASK__NOA_OFF_ERLY_TIME_8812F 0xff
#define BIT__NOA_OFF_ERLY_TIME_8812F(x)                                        \
	(((x) & BIT_MASK__NOA_OFF_ERLY_TIME_8812F)                             \
	 << BIT_SHIFT__NOA_OFF_ERLY_TIME_8812F)
#define BITS__NOA_OFF_ERLY_TIME_8812F                                          \
	(BIT_MASK__NOA_OFF_ERLY_TIME_8812F                                     \
	 << BIT_SHIFT__NOA_OFF_ERLY_TIME_8812F)
#define BIT_CLEAR__NOA_OFF_ERLY_TIME_8812F(x)                                  \
	((x) & (~BITS__NOA_OFF_ERLY_TIME_8812F))
#define BIT_GET__NOA_OFF_ERLY_TIME_8812F(x)                                    \
	(((x) >> BIT_SHIFT__NOA_OFF_ERLY_TIME_8812F) &                         \
	 BIT_MASK__NOA_OFF_ERLY_TIME_8812F)
#define BIT_SET__NOA_OFF_ERLY_TIME_8812F(x, v)                                 \
	(BIT_CLEAR__NOA_OFF_ERLY_TIME_8812F(x) |                               \
	 BIT__NOA_OFF_ERLY_TIME_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_TX_PTCL_CTRL_8812F */
#define BIT_DIS_EDCCA_8812F BIT(15)
#define BIT_DIS_CCA_8812F BIT(14)
#define BIT_LSIG_TXOP_TXCMD_NAV_8812F BIT(13)
#define BIT_SIFS_BK_EN_8812F BIT(12)

#define BIT_SHIFT_TXQ_NAV_MSK_8812F 8
#define BIT_MASK_TXQ_NAV_MSK_8812F 0xf
#define BIT_TXQ_NAV_MSK_8812F(x)                                               \
	(((x) & BIT_MASK_TXQ_NAV_MSK_8812F) << BIT_SHIFT_TXQ_NAV_MSK_8812F)
#define BITS_TXQ_NAV_MSK_8812F                                                 \
	(BIT_MASK_TXQ_NAV_MSK_8812F << BIT_SHIFT_TXQ_NAV_MSK_8812F)
#define BIT_CLEAR_TXQ_NAV_MSK_8812F(x) ((x) & (~BITS_TXQ_NAV_MSK_8812F))
#define BIT_GET_TXQ_NAV_MSK_8812F(x)                                           \
	(((x) >> BIT_SHIFT_TXQ_NAV_MSK_8812F) & BIT_MASK_TXQ_NAV_MSK_8812F)
#define BIT_SET_TXQ_NAV_MSK_8812F(x, v)                                        \
	(BIT_CLEAR_TXQ_NAV_MSK_8812F(x) | BIT_TXQ_NAV_MSK_8812F(v))

#define BIT_DIS_CW_8812F BIT(7)
#define BIT_NAV_END_TXOP_8812F BIT(6)
#define BIT_RDG_END_TXOP_8812F BIT(5)
#define BIT_AC_INBCN_HOLD_8812F BIT(4)
#define BIT_MGTQ_TXOP_EN_8812F BIT(3)
#define BIT_MGTQ_RTSMF_EN_8812F BIT(2)
#define BIT_HIQ_RTSMF_EN_8812F BIT(1)
#define BIT_BCN_RTSMF_EN_8812F BIT(0)

/* 2 REG_TXPAUSE_8812F */
#define BIT_STOP_BCN_HI_MGT_8812F BIT(7)
#define BIT_MAC_STOPBCNQ_8812F BIT(6)
#define BIT_MAC_STOPHIQ_8812F BIT(5)
#define BIT_MAC_STOPMGQ_8812F BIT(4)
#define BIT_MAC_STOPBK_8812F BIT(3)
#define BIT_MAC_STOPBE_8812F BIT(2)
#define BIT_MAC_STOPVI_8812F BIT(1)
#define BIT_MAC_STOPVO_8812F BIT(0)

/* 2 REG_DIS_TXREQ_CLR_8812F */
#define BIT_DIS_BT_CCA_8812F BIT(7)
#define BIT_DIS_TXREQ_CLR_HI_8812F BIT(5)
#define BIT_DIS_TXREQ_CLR_MGQ_8812F BIT(4)
#define BIT_DIS_TXREQ_CLR_VO_8812F BIT(3)
#define BIT_DIS_TXREQ_CLR_VI_8812F BIT(2)
#define BIT_DIS_TXREQ_CLR_BE_8812F BIT(1)
#define BIT_DIS_TXREQ_CLR_BK_8812F BIT(0)

/* 2 REG_RD_CTRL_8812F */
#define BIT_EN_CLR_TXREQ_INCCA_8812F BIT(15)
#define BIT_DIS_TX_OVER_BCNQ_8812F BIT(14)
#define BIT_EN_BCNERR_INCCCA_8812F BIT(13)
#define BIT_EDCCA_MSK_CNTDOWN_EN_8812F BIT(11)
#define BIT_DIS_TXOP_CFE_8812F BIT(10)
#define BIT_DIS_LSIG_CFE_8812F BIT(9)
#define BIT_DIS_STBC_CFE_8812F BIT(8)
#define BIT_BKQ_RD_INIT_EN_8812F BIT(7)
#define BIT_BEQ_RD_INIT_EN_8812F BIT(6)
#define BIT_VIQ_RD_INIT_EN_8812F BIT(5)
#define BIT_VOQ_RD_INIT_EN_8812F BIT(4)
#define BIT_BKQ_RD_RESP_EN_8812F BIT(3)
#define BIT_BEQ_RD_RESP_EN_8812F BIT(2)
#define BIT_VIQ_RD_RESP_EN_8812F BIT(1)
#define BIT_VOQ_RD_RESP_EN_8812F BIT(0)

/* 2 REG_MBSSID_CTRL_8812F */
#define BIT_MBID_BCNQ7_EN_8812F BIT(7)
#define BIT_MBID_BCNQ6_EN_8812F BIT(6)
#define BIT_MBID_BCNQ5_EN_8812F BIT(5)
#define BIT_MBID_BCNQ4_EN_8812F BIT(4)
#define BIT_MBID_BCNQ3_EN_8812F BIT(3)
#define BIT_MBID_BCNQ2_EN_8812F BIT(2)
#define BIT_MBID_BCNQ1_EN_8812F BIT(1)
#define BIT_MBID_BCNQ0_EN_8812F BIT(0)

/* 2 REG_P2PPS_CTRL_8812F */
#define BIT_P2P_CTW_ALLSTASLEEP_8812F BIT(7)
#define BIT_P2P_OFF_DISTX_EN_8812F BIT(6)
#define BIT_PWR_MGT_EN_8812F BIT(5)
#define BIT_P2P_NOA1_EN_8812F BIT(2)
#define BIT_P2P_NOA0_EN_8812F BIT(1)

/* 2 REG_PKT_LIFETIME_CTRL_8812F */
#define BIT_EN_P2P_CTWND1_8812F BIT(23)
#define BIT_EN_BKF_CLR_TXREQ_8812F BIT(22)
#define BIT_EN_TSFBIT32_RST_P2P_8812F BIT(21)
#define BIT_EN_BCN_TX_BTCCA_8812F BIT(20)
#define BIT_DIS_PKT_TX_ATIM_8812F BIT(19)
#define BIT_DIS_BCN_DIS_CTN_8812F BIT(18)
#define BIT_EN_NAVEND_RST_TXOP_8812F BIT(17)
#define BIT_EN_FILTER_CCA_8812F BIT(16)

#define BIT_SHIFT_CCA_FILTER_THRS_8812F 8
#define BIT_MASK_CCA_FILTER_THRS_8812F 0xff
#define BIT_CCA_FILTER_THRS_8812F(x)                                           \
	(((x) & BIT_MASK_CCA_FILTER_THRS_8812F)                                \
	 << BIT_SHIFT_CCA_FILTER_THRS_8812F)
#define BITS_CCA_FILTER_THRS_8812F                                             \
	(BIT_MASK_CCA_FILTER_THRS_8812F << BIT_SHIFT_CCA_FILTER_THRS_8812F)
#define BIT_CLEAR_CCA_FILTER_THRS_8812F(x) ((x) & (~BITS_CCA_FILTER_THRS_8812F))
#define BIT_GET_CCA_FILTER_THRS_8812F(x)                                       \
	(((x) >> BIT_SHIFT_CCA_FILTER_THRS_8812F) &                            \
	 BIT_MASK_CCA_FILTER_THRS_8812F)
#define BIT_SET_CCA_FILTER_THRS_8812F(x, v)                                    \
	(BIT_CLEAR_CCA_FILTER_THRS_8812F(x) | BIT_CCA_FILTER_THRS_8812F(v))

#define BIT_SHIFT_EDCCA_THRS_8812F 0
#define BIT_MASK_EDCCA_THRS_8812F 0xff
#define BIT_EDCCA_THRS_8812F(x)                                                \
	(((x) & BIT_MASK_EDCCA_THRS_8812F) << BIT_SHIFT_EDCCA_THRS_8812F)
#define BITS_EDCCA_THRS_8812F                                                  \
	(BIT_MASK_EDCCA_THRS_8812F << BIT_SHIFT_EDCCA_THRS_8812F)
#define BIT_CLEAR_EDCCA_THRS_8812F(x) ((x) & (~BITS_EDCCA_THRS_8812F))
#define BIT_GET_EDCCA_THRS_8812F(x)                                            \
	(((x) >> BIT_SHIFT_EDCCA_THRS_8812F) & BIT_MASK_EDCCA_THRS_8812F)
#define BIT_SET_EDCCA_THRS_8812F(x, v)                                         \
	(BIT_CLEAR_EDCCA_THRS_8812F(x) | BIT_EDCCA_THRS_8812F(v))

/* 2 REG_P2PPS_SPEC_STATE_8812F */
#define BIT_SPEC_POWER_STATE_8812F BIT(7)
#define BIT_SPEC_CTWINDOW_ON_8812F BIT(6)
#define BIT_SPEC_BEACON_AREA_ON_8812F BIT(5)
#define BIT_SPEC_CTWIN_EARLY_DISTX_8812F BIT(4)
#define BIT_SPEC_NOA1_OFF_PERIOD_8812F BIT(3)
#define BIT_SPEC_FORCE_DOZE1_8812F BIT(2)
#define BIT_SPEC_NOA0_OFF_PERIOD_8812F BIT(1)
#define BIT_SPEC_FORCE_DOZE0_8812F BIT(0)

/* 2 REG_TXOP_LIMIT_CTRL_8812F */

#define BIT_SHIFT_TXOP_TBTT_CNT_8812F 24
#define BIT_MASK_TXOP_TBTT_CNT_8812F 0xff
#define BIT_TXOP_TBTT_CNT_8812F(x)                                             \
	(((x) & BIT_MASK_TXOP_TBTT_CNT_8812F) << BIT_SHIFT_TXOP_TBTT_CNT_8812F)
#define BITS_TXOP_TBTT_CNT_8812F                                               \
	(BIT_MASK_TXOP_TBTT_CNT_8812F << BIT_SHIFT_TXOP_TBTT_CNT_8812F)
#define BIT_CLEAR_TXOP_TBTT_CNT_8812F(x) ((x) & (~BITS_TXOP_TBTT_CNT_8812F))
#define BIT_GET_TXOP_TBTT_CNT_8812F(x)                                         \
	(((x) >> BIT_SHIFT_TXOP_TBTT_CNT_8812F) & BIT_MASK_TXOP_TBTT_CNT_8812F)
#define BIT_SET_TXOP_TBTT_CNT_8812F(x, v)                                      \
	(BIT_CLEAR_TXOP_TBTT_CNT_8812F(x) | BIT_TXOP_TBTT_CNT_8812F(v))

#define BIT_SHIFT_TXOP_TBTT_CNT_SEL_8812F 20
#define BIT_MASK_TXOP_TBTT_CNT_SEL_8812F 0xf
#define BIT_TXOP_TBTT_CNT_SEL_8812F(x)                                         \
	(((x) & BIT_MASK_TXOP_TBTT_CNT_SEL_8812F)                              \
	 << BIT_SHIFT_TXOP_TBTT_CNT_SEL_8812F)
#define BITS_TXOP_TBTT_CNT_SEL_8812F                                           \
	(BIT_MASK_TXOP_TBTT_CNT_SEL_8812F << BIT_SHIFT_TXOP_TBTT_CNT_SEL_8812F)
#define BIT_CLEAR_TXOP_TBTT_CNT_SEL_8812F(x)                                   \
	((x) & (~BITS_TXOP_TBTT_CNT_SEL_8812F))
#define BIT_GET_TXOP_TBTT_CNT_SEL_8812F(x)                                     \
	(((x) >> BIT_SHIFT_TXOP_TBTT_CNT_SEL_8812F) &                          \
	 BIT_MASK_TXOP_TBTT_CNT_SEL_8812F)
#define BIT_SET_TXOP_TBTT_CNT_SEL_8812F(x, v)                                  \
	(BIT_CLEAR_TXOP_TBTT_CNT_SEL_8812F(x) | BIT_TXOP_TBTT_CNT_SEL_8812F(v))

#define BIT_SHIFT_TXOP_LMT_EN_8812F 16
#define BIT_MASK_TXOP_LMT_EN_8812F 0xf
#define BIT_TXOP_LMT_EN_8812F(x)                                               \
	(((x) & BIT_MASK_TXOP_LMT_EN_8812F) << BIT_SHIFT_TXOP_LMT_EN_8812F)
#define BITS_TXOP_LMT_EN_8812F                                                 \
	(BIT_MASK_TXOP_LMT_EN_8812F << BIT_SHIFT_TXOP_LMT_EN_8812F)
#define BIT_CLEAR_TXOP_LMT_EN_8812F(x) ((x) & (~BITS_TXOP_LMT_EN_8812F))
#define BIT_GET_TXOP_LMT_EN_8812F(x)                                           \
	(((x) >> BIT_SHIFT_TXOP_LMT_EN_8812F) & BIT_MASK_TXOP_LMT_EN_8812F)
#define BIT_SET_TXOP_LMT_EN_8812F(x, v)                                        \
	(BIT_CLEAR_TXOP_LMT_EN_8812F(x) | BIT_TXOP_LMT_EN_8812F(v))

#define BIT_SHIFT_TXOP_LMT_TX_TIME_8812F 8
#define BIT_MASK_TXOP_LMT_TX_TIME_8812F 0xff
#define BIT_TXOP_LMT_TX_TIME_8812F(x)                                          \
	(((x) & BIT_MASK_TXOP_LMT_TX_TIME_8812F)                               \
	 << BIT_SHIFT_TXOP_LMT_TX_TIME_8812F)
#define BITS_TXOP_LMT_TX_TIME_8812F                                            \
	(BIT_MASK_TXOP_LMT_TX_TIME_8812F << BIT_SHIFT_TXOP_LMT_TX_TIME_8812F)
#define BIT_CLEAR_TXOP_LMT_TX_TIME_8812F(x)                                    \
	((x) & (~BITS_TXOP_LMT_TX_TIME_8812F))
#define BIT_GET_TXOP_LMT_TX_TIME_8812F(x)                                      \
	(((x) >> BIT_SHIFT_TXOP_LMT_TX_TIME_8812F) &                           \
	 BIT_MASK_TXOP_LMT_TX_TIME_8812F)
#define BIT_SET_TXOP_LMT_TX_TIME_8812F(x, v)                                   \
	(BIT_CLEAR_TXOP_LMT_TX_TIME_8812F(x) | BIT_TXOP_LMT_TX_TIME_8812F(v))

#define BIT_TXOP_CNT_TRIGGER_RESET_8812F BIT(7)

#define BIT_SHIFT_TXOP_LMT_PKT_NUM_8812F 0
#define BIT_MASK_TXOP_LMT_PKT_NUM_8812F 0x3f
#define BIT_TXOP_LMT_PKT_NUM_8812F(x)                                          \
	(((x) & BIT_MASK_TXOP_LMT_PKT_NUM_8812F)                               \
	 << BIT_SHIFT_TXOP_LMT_PKT_NUM_8812F)
#define BITS_TXOP_LMT_PKT_NUM_8812F                                            \
	(BIT_MASK_TXOP_LMT_PKT_NUM_8812F << BIT_SHIFT_TXOP_LMT_PKT_NUM_8812F)
#define BIT_CLEAR_TXOP_LMT_PKT_NUM_8812F(x)                                    \
	((x) & (~BITS_TXOP_LMT_PKT_NUM_8812F))
#define BIT_GET_TXOP_LMT_PKT_NUM_8812F(x)                                      \
	(((x) >> BIT_SHIFT_TXOP_LMT_PKT_NUM_8812F) &                           \
	 BIT_MASK_TXOP_LMT_PKT_NUM_8812F)
#define BIT_SET_TXOP_LMT_PKT_NUM_8812F(x, v)                                   \
	(BIT_CLEAR_TXOP_LMT_PKT_NUM_8812F(x) | BIT_TXOP_LMT_PKT_NUM_8812F(v))

/* 2 REG_BAR_TX_CTRL_8812F */

/* 2 REG_P2PON_DIS_TXTIME_8812F */

#define BIT_SHIFT_P2PON_DIS_TXTIME_8812F 0
#define BIT_MASK_P2PON_DIS_TXTIME_8812F 0xff
#define BIT_P2PON_DIS_TXTIME_8812F(x)                                          \
	(((x) & BIT_MASK_P2PON_DIS_TXTIME_8812F)                               \
	 << BIT_SHIFT_P2PON_DIS_TXTIME_8812F)
#define BITS_P2PON_DIS_TXTIME_8812F                                            \
	(BIT_MASK_P2PON_DIS_TXTIME_8812F << BIT_SHIFT_P2PON_DIS_TXTIME_8812F)
#define BIT_CLEAR_P2PON_DIS_TXTIME_8812F(x)                                    \
	((x) & (~BITS_P2PON_DIS_TXTIME_8812F))
#define BIT_GET_P2PON_DIS_TXTIME_8812F(x)                                      \
	(((x) >> BIT_SHIFT_P2PON_DIS_TXTIME_8812F) &                           \
	 BIT_MASK_P2PON_DIS_TXTIME_8812F)
#define BIT_SET_P2PON_DIS_TXTIME_8812F(x, v)                                   \
	(BIT_CLEAR_P2PON_DIS_TXTIME_8812F(x) | BIT_P2PON_DIS_TXTIME_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_CCA_TXEN_CNT_8812F */
#define BIT_ENABLE_STOP_UPDATE_NAV_8812F BIT(21)
#define BIT_ENABLE_GEN_RANDON_SLOT_TX_8812F BIT(20)
#define BIT_ENABLE_RANDOM_SHIFT_TX_8812F BIT(19)
#define BIT_ENABLE_EDCA_REF_FUNCTION_8812F BIT(18)
#define BIT_CCA_TXEN_CNT_SWITCH_8812F BIT(17)
#define BIT_CCA_TXEN_CNT_EN_8812F BIT(16)

#define BIT_SHIFT_CCA_TXEN_BIG_CNT_8812F 8
#define BIT_MASK_CCA_TXEN_BIG_CNT_8812F 0xff
#define BIT_CCA_TXEN_BIG_CNT_8812F(x)                                          \
	(((x) & BIT_MASK_CCA_TXEN_BIG_CNT_8812F)                               \
	 << BIT_SHIFT_CCA_TXEN_BIG_CNT_8812F)
#define BITS_CCA_TXEN_BIG_CNT_8812F                                            \
	(BIT_MASK_CCA_TXEN_BIG_CNT_8812F << BIT_SHIFT_CCA_TXEN_BIG_CNT_8812F)
#define BIT_CLEAR_CCA_TXEN_BIG_CNT_8812F(x)                                    \
	((x) & (~BITS_CCA_TXEN_BIG_CNT_8812F))
#define BIT_GET_CCA_TXEN_BIG_CNT_8812F(x)                                      \
	(((x) >> BIT_SHIFT_CCA_TXEN_BIG_CNT_8812F) &                           \
	 BIT_MASK_CCA_TXEN_BIG_CNT_8812F)
#define BIT_SET_CCA_TXEN_BIG_CNT_8812F(x, v)                                   \
	(BIT_CLEAR_CCA_TXEN_BIG_CNT_8812F(x) | BIT_CCA_TXEN_BIG_CNT_8812F(v))

#define BIT_SHIFT_CCA_TXEN_SMALL_CNT_8812F 0
#define BIT_MASK_CCA_TXEN_SMALL_CNT_8812F 0xff
#define BIT_CCA_TXEN_SMALL_CNT_8812F(x)                                        \
	(((x) & BIT_MASK_CCA_TXEN_SMALL_CNT_8812F)                             \
	 << BIT_SHIFT_CCA_TXEN_SMALL_CNT_8812F)
#define BITS_CCA_TXEN_SMALL_CNT_8812F                                          \
	(BIT_MASK_CCA_TXEN_SMALL_CNT_8812F                                     \
	 << BIT_SHIFT_CCA_TXEN_SMALL_CNT_8812F)
#define BIT_CLEAR_CCA_TXEN_SMALL_CNT_8812F(x)                                  \
	((x) & (~BITS_CCA_TXEN_SMALL_CNT_8812F))
#define BIT_GET_CCA_TXEN_SMALL_CNT_8812F(x)                                    \
	(((x) >> BIT_SHIFT_CCA_TXEN_SMALL_CNT_8812F) &                         \
	 BIT_MASK_CCA_TXEN_SMALL_CNT_8812F)
#define BIT_SET_CCA_TXEN_SMALL_CNT_8812F(x, v)                                 \
	(BIT_CLEAR_CCA_TXEN_SMALL_CNT_8812F(x) |                               \
	 BIT_CCA_TXEN_SMALL_CNT_8812F(v))

/* 2 REG_MAX_INTER_COLLISION_8812F */

#define BIT_SHIFT_MAX_INTER_COLLISION_BK_8812F 24
#define BIT_MASK_MAX_INTER_COLLISION_BK_8812F 0xff
#define BIT_MAX_INTER_COLLISION_BK_8812F(x)                                    \
	(((x) & BIT_MASK_MAX_INTER_COLLISION_BK_8812F)                         \
	 << BIT_SHIFT_MAX_INTER_COLLISION_BK_8812F)
#define BITS_MAX_INTER_COLLISION_BK_8812F                                      \
	(BIT_MASK_MAX_INTER_COLLISION_BK_8812F                                 \
	 << BIT_SHIFT_MAX_INTER_COLLISION_BK_8812F)
#define BIT_CLEAR_MAX_INTER_COLLISION_BK_8812F(x)                              \
	((x) & (~BITS_MAX_INTER_COLLISION_BK_8812F))
#define BIT_GET_MAX_INTER_COLLISION_BK_8812F(x)                                \
	(((x) >> BIT_SHIFT_MAX_INTER_COLLISION_BK_8812F) &                     \
	 BIT_MASK_MAX_INTER_COLLISION_BK_8812F)
#define BIT_SET_MAX_INTER_COLLISION_BK_8812F(x, v)                             \
	(BIT_CLEAR_MAX_INTER_COLLISION_BK_8812F(x) |                           \
	 BIT_MAX_INTER_COLLISION_BK_8812F(v))

#define BIT_SHIFT_MAX_INTER_COLLISION_BE_8812F 16
#define BIT_MASK_MAX_INTER_COLLISION_BE_8812F 0xff
#define BIT_MAX_INTER_COLLISION_BE_8812F(x)                                    \
	(((x) & BIT_MASK_MAX_INTER_COLLISION_BE_8812F)                         \
	 << BIT_SHIFT_MAX_INTER_COLLISION_BE_8812F)
#define BITS_MAX_INTER_COLLISION_BE_8812F                                      \
	(BIT_MASK_MAX_INTER_COLLISION_BE_8812F                                 \
	 << BIT_SHIFT_MAX_INTER_COLLISION_BE_8812F)
#define BIT_CLEAR_MAX_INTER_COLLISION_BE_8812F(x)                              \
	((x) & (~BITS_MAX_INTER_COLLISION_BE_8812F))
#define BIT_GET_MAX_INTER_COLLISION_BE_8812F(x)                                \
	(((x) >> BIT_SHIFT_MAX_INTER_COLLISION_BE_8812F) &                     \
	 BIT_MASK_MAX_INTER_COLLISION_BE_8812F)
#define BIT_SET_MAX_INTER_COLLISION_BE_8812F(x, v)                             \
	(BIT_CLEAR_MAX_INTER_COLLISION_BE_8812F(x) |                           \
	 BIT_MAX_INTER_COLLISION_BE_8812F(v))

#define BIT_SHIFT_MAX_INTER_COLLISION_VI_8812F 8
#define BIT_MASK_MAX_INTER_COLLISION_VI_8812F 0xff
#define BIT_MAX_INTER_COLLISION_VI_8812F(x)                                    \
	(((x) & BIT_MASK_MAX_INTER_COLLISION_VI_8812F)                         \
	 << BIT_SHIFT_MAX_INTER_COLLISION_VI_8812F)
#define BITS_MAX_INTER_COLLISION_VI_8812F                                      \
	(BIT_MASK_MAX_INTER_COLLISION_VI_8812F                                 \
	 << BIT_SHIFT_MAX_INTER_COLLISION_VI_8812F)
#define BIT_CLEAR_MAX_INTER_COLLISION_VI_8812F(x)                              \
	((x) & (~BITS_MAX_INTER_COLLISION_VI_8812F))
#define BIT_GET_MAX_INTER_COLLISION_VI_8812F(x)                                \
	(((x) >> BIT_SHIFT_MAX_INTER_COLLISION_VI_8812F) &                     \
	 BIT_MASK_MAX_INTER_COLLISION_VI_8812F)
#define BIT_SET_MAX_INTER_COLLISION_VI_8812F(x, v)                             \
	(BIT_CLEAR_MAX_INTER_COLLISION_VI_8812F(x) |                           \
	 BIT_MAX_INTER_COLLISION_VI_8812F(v))

#define BIT_SHIFT_MAX_INTER_COLLISION_VO_8812F 0
#define BIT_MASK_MAX_INTER_COLLISION_VO_8812F 0xff
#define BIT_MAX_INTER_COLLISION_VO_8812F(x)                                    \
	(((x) & BIT_MASK_MAX_INTER_COLLISION_VO_8812F)                         \
	 << BIT_SHIFT_MAX_INTER_COLLISION_VO_8812F)
#define BITS_MAX_INTER_COLLISION_VO_8812F                                      \
	(BIT_MASK_MAX_INTER_COLLISION_VO_8812F                                 \
	 << BIT_SHIFT_MAX_INTER_COLLISION_VO_8812F)
#define BIT_CLEAR_MAX_INTER_COLLISION_VO_8812F(x)                              \
	((x) & (~BITS_MAX_INTER_COLLISION_VO_8812F))
#define BIT_GET_MAX_INTER_COLLISION_VO_8812F(x)                                \
	(((x) >> BIT_SHIFT_MAX_INTER_COLLISION_VO_8812F) &                     \
	 BIT_MASK_MAX_INTER_COLLISION_VO_8812F)
#define BIT_SET_MAX_INTER_COLLISION_VO_8812F(x, v)                             \
	(BIT_CLEAR_MAX_INTER_COLLISION_VO_8812F(x) |                           \
	 BIT_MAX_INTER_COLLISION_VO_8812F(v))

/* 2 REG_MAX_INTER_COLLISION_CNT_8812F */
#define BIT_MAX_INTER_COLLISION_EN_8812F BIT(16)

#define BIT_SHIFT_MAX_INTER_COLLISION_CNT_BK_8812F 12
#define BIT_MASK_MAX_INTER_COLLISION_CNT_BK_8812F 0xf
#define BIT_MAX_INTER_COLLISION_CNT_BK_8812F(x)                                \
	(((x) & BIT_MASK_MAX_INTER_COLLISION_CNT_BK_8812F)                     \
	 << BIT_SHIFT_MAX_INTER_COLLISION_CNT_BK_8812F)
#define BITS_MAX_INTER_COLLISION_CNT_BK_8812F                                  \
	(BIT_MASK_MAX_INTER_COLLISION_CNT_BK_8812F                             \
	 << BIT_SHIFT_MAX_INTER_COLLISION_CNT_BK_8812F)
#define BIT_CLEAR_MAX_INTER_COLLISION_CNT_BK_8812F(x)                          \
	((x) & (~BITS_MAX_INTER_COLLISION_CNT_BK_8812F))
#define BIT_GET_MAX_INTER_COLLISION_CNT_BK_8812F(x)                            \
	(((x) >> BIT_SHIFT_MAX_INTER_COLLISION_CNT_BK_8812F) &                 \
	 BIT_MASK_MAX_INTER_COLLISION_CNT_BK_8812F)
#define BIT_SET_MAX_INTER_COLLISION_CNT_BK_8812F(x, v)                         \
	(BIT_CLEAR_MAX_INTER_COLLISION_CNT_BK_8812F(x) |                       \
	 BIT_MAX_INTER_COLLISION_CNT_BK_8812F(v))

#define BIT_SHIFT_MAX_INTER_COLLISION_CNT_BE_8812F 8
#define BIT_MASK_MAX_INTER_COLLISION_CNT_BE_8812F 0xf
#define BIT_MAX_INTER_COLLISION_CNT_BE_8812F(x)                                \
	(((x) & BIT_MASK_MAX_INTER_COLLISION_CNT_BE_8812F)                     \
	 << BIT_SHIFT_MAX_INTER_COLLISION_CNT_BE_8812F)
#define BITS_MAX_INTER_COLLISION_CNT_BE_8812F                                  \
	(BIT_MASK_MAX_INTER_COLLISION_CNT_BE_8812F                             \
	 << BIT_SHIFT_MAX_INTER_COLLISION_CNT_BE_8812F)
#define BIT_CLEAR_MAX_INTER_COLLISION_CNT_BE_8812F(x)                          \
	((x) & (~BITS_MAX_INTER_COLLISION_CNT_BE_8812F))
#define BIT_GET_MAX_INTER_COLLISION_CNT_BE_8812F(x)                            \
	(((x) >> BIT_SHIFT_MAX_INTER_COLLISION_CNT_BE_8812F) &                 \
	 BIT_MASK_MAX_INTER_COLLISION_CNT_BE_8812F)
#define BIT_SET_MAX_INTER_COLLISION_CNT_BE_8812F(x, v)                         \
	(BIT_CLEAR_MAX_INTER_COLLISION_CNT_BE_8812F(x) |                       \
	 BIT_MAX_INTER_COLLISION_CNT_BE_8812F(v))

#define BIT_SHIFT_MAX_INTER_COLLISION_CNT_VI_8812F 4
#define BIT_MASK_MAX_INTER_COLLISION_CNT_VI_8812F 0xf
#define BIT_MAX_INTER_COLLISION_CNT_VI_8812F(x)                                \
	(((x) & BIT_MASK_MAX_INTER_COLLISION_CNT_VI_8812F)                     \
	 << BIT_SHIFT_MAX_INTER_COLLISION_CNT_VI_8812F)
#define BITS_MAX_INTER_COLLISION_CNT_VI_8812F                                  \
	(BIT_MASK_MAX_INTER_COLLISION_CNT_VI_8812F                             \
	 << BIT_SHIFT_MAX_INTER_COLLISION_CNT_VI_8812F)
#define BIT_CLEAR_MAX_INTER_COLLISION_CNT_VI_8812F(x)                          \
	((x) & (~BITS_MAX_INTER_COLLISION_CNT_VI_8812F))
#define BIT_GET_MAX_INTER_COLLISION_CNT_VI_8812F(x)                            \
	(((x) >> BIT_SHIFT_MAX_INTER_COLLISION_CNT_VI_8812F) &                 \
	 BIT_MASK_MAX_INTER_COLLISION_CNT_VI_8812F)
#define BIT_SET_MAX_INTER_COLLISION_CNT_VI_8812F(x, v)                         \
	(BIT_CLEAR_MAX_INTER_COLLISION_CNT_VI_8812F(x) |                       \
	 BIT_MAX_INTER_COLLISION_CNT_VI_8812F(v))

#define BIT_SHIFT_MAX_INTER_COLLISION_CNT_VO_8812F 0
#define BIT_MASK_MAX_INTER_COLLISION_CNT_VO_8812F 0xf
#define BIT_MAX_INTER_COLLISION_CNT_VO_8812F(x)                                \
	(((x) & BIT_MASK_MAX_INTER_COLLISION_CNT_VO_8812F)                     \
	 << BIT_SHIFT_MAX_INTER_COLLISION_CNT_VO_8812F)
#define BITS_MAX_INTER_COLLISION_CNT_VO_8812F                                  \
	(BIT_MASK_MAX_INTER_COLLISION_CNT_VO_8812F                             \
	 << BIT_SHIFT_MAX_INTER_COLLISION_CNT_VO_8812F)
#define BIT_CLEAR_MAX_INTER_COLLISION_CNT_VO_8812F(x)                          \
	((x) & (~BITS_MAX_INTER_COLLISION_CNT_VO_8812F))
#define BIT_GET_MAX_INTER_COLLISION_CNT_VO_8812F(x)                            \
	(((x) >> BIT_SHIFT_MAX_INTER_COLLISION_CNT_VO_8812F) &                 \
	 BIT_MASK_MAX_INTER_COLLISION_CNT_VO_8812F)
#define BIT_SET_MAX_INTER_COLLISION_CNT_VO_8812F(x, v)                         \
	(BIT_CLEAR_MAX_INTER_COLLISION_CNT_VO_8812F(x) |                       \
	 BIT_MAX_INTER_COLLISION_CNT_VO_8812F(v))

/* 2 REG_TBTT_PROHIBIT_8812F */

#define BIT_SHIFT_TBTT_HOLD_TIME_AP_8812F 8
#define BIT_MASK_TBTT_HOLD_TIME_AP_8812F 0xfff
#define BIT_TBTT_HOLD_TIME_AP_8812F(x)                                         \
	(((x) & BIT_MASK_TBTT_HOLD_TIME_AP_8812F)                              \
	 << BIT_SHIFT_TBTT_HOLD_TIME_AP_8812F)
#define BITS_TBTT_HOLD_TIME_AP_8812F                                           \
	(BIT_MASK_TBTT_HOLD_TIME_AP_8812F << BIT_SHIFT_TBTT_HOLD_TIME_AP_8812F)
#define BIT_CLEAR_TBTT_HOLD_TIME_AP_8812F(x)                                   \
	((x) & (~BITS_TBTT_HOLD_TIME_AP_8812F))
#define BIT_GET_TBTT_HOLD_TIME_AP_8812F(x)                                     \
	(((x) >> BIT_SHIFT_TBTT_HOLD_TIME_AP_8812F) &                          \
	 BIT_MASK_TBTT_HOLD_TIME_AP_8812F)
#define BIT_SET_TBTT_HOLD_TIME_AP_8812F(x, v)                                  \
	(BIT_CLEAR_TBTT_HOLD_TIME_AP_8812F(x) | BIT_TBTT_HOLD_TIME_AP_8812F(v))

#define BIT_SHIFT_TBTT_PROHIBIT_SETUP_8812F 0
#define BIT_MASK_TBTT_PROHIBIT_SETUP_8812F 0xf
#define BIT_TBTT_PROHIBIT_SETUP_8812F(x)                                       \
	(((x) & BIT_MASK_TBTT_PROHIBIT_SETUP_8812F)                            \
	 << BIT_SHIFT_TBTT_PROHIBIT_SETUP_8812F)
#define BITS_TBTT_PROHIBIT_SETUP_8812F                                         \
	(BIT_MASK_TBTT_PROHIBIT_SETUP_8812F                                    \
	 << BIT_SHIFT_TBTT_PROHIBIT_SETUP_8812F)
#define BIT_CLEAR_TBTT_PROHIBIT_SETUP_8812F(x)                                 \
	((x) & (~BITS_TBTT_PROHIBIT_SETUP_8812F))
#define BIT_GET_TBTT_PROHIBIT_SETUP_8812F(x)                                   \
	(((x) >> BIT_SHIFT_TBTT_PROHIBIT_SETUP_8812F) &                        \
	 BIT_MASK_TBTT_PROHIBIT_SETUP_8812F)
#define BIT_SET_TBTT_PROHIBIT_SETUP_8812F(x, v)                                \
	(BIT_CLEAR_TBTT_PROHIBIT_SETUP_8812F(x) |                              \
	 BIT_TBTT_PROHIBIT_SETUP_8812F(v))

/* 2 REG_P2PPS_STATE_8812F */
#define BIT_POWER_STATE_8812F BIT(7)
#define BIT_CTWINDOW_ON_8812F BIT(6)
#define BIT_BEACON_AREA_ON_8812F BIT(5)
#define BIT_CTWIN_EARLY_DISTX_8812F BIT(4)
#define BIT_NOA1_OFF_PERIOD_8812F BIT(3)
#define BIT_FORCE_DOZE1_8812F BIT(2)
#define BIT_NOA0_OFF_PERIOD_8812F BIT(1)
#define BIT_FORCE_DOZE0_8812F BIT(0)

/* 2 REG_RD_NAV_NXT_8812F */

#define BIT_SHIFT_RD_NAV_PROT_NXT_8812F 0
#define BIT_MASK_RD_NAV_PROT_NXT_8812F 0xffff
#define BIT_RD_NAV_PROT_NXT_8812F(x)                                           \
	(((x) & BIT_MASK_RD_NAV_PROT_NXT_8812F)                                \
	 << BIT_SHIFT_RD_NAV_PROT_NXT_8812F)
#define BITS_RD_NAV_PROT_NXT_8812F                                             \
	(BIT_MASK_RD_NAV_PROT_NXT_8812F << BIT_SHIFT_RD_NAV_PROT_NXT_8812F)
#define BIT_CLEAR_RD_NAV_PROT_NXT_8812F(x) ((x) & (~BITS_RD_NAV_PROT_NXT_8812F))
#define BIT_GET_RD_NAV_PROT_NXT_8812F(x)                                       \
	(((x) >> BIT_SHIFT_RD_NAV_PROT_NXT_8812F) &                            \
	 BIT_MASK_RD_NAV_PROT_NXT_8812F)
#define BIT_SET_RD_NAV_PROT_NXT_8812F(x, v)                                    \
	(BIT_CLEAR_RD_NAV_PROT_NXT_8812F(x) | BIT_RD_NAV_PROT_NXT_8812F(v))

/* 2 REG_NAV_PROT_LEN_8812F */

#define BIT_SHIFT_NAV_PROT_LEN_8812F 0
#define BIT_MASK_NAV_PROT_LEN_8812F 0xffff
#define BIT_NAV_PROT_LEN_8812F(x)                                              \
	(((x) & BIT_MASK_NAV_PROT_LEN_8812F) << BIT_SHIFT_NAV_PROT_LEN_8812F)
#define BITS_NAV_PROT_LEN_8812F                                                \
	(BIT_MASK_NAV_PROT_LEN_8812F << BIT_SHIFT_NAV_PROT_LEN_8812F)
#define BIT_CLEAR_NAV_PROT_LEN_8812F(x) ((x) & (~BITS_NAV_PROT_LEN_8812F))
#define BIT_GET_NAV_PROT_LEN_8812F(x)                                          \
	(((x) >> BIT_SHIFT_NAV_PROT_LEN_8812F) & BIT_MASK_NAV_PROT_LEN_8812F)
#define BIT_SET_NAV_PROT_LEN_8812F(x, v)                                       \
	(BIT_CLEAR_NAV_PROT_LEN_8812F(x) | BIT_NAV_PROT_LEN_8812F(v))

/* 2 REG_FTM_PTT_8812F */

#define BIT_SHIFT_FTM_PTT_TSF_R2T_SEL_8812F 22
#define BIT_MASK_FTM_PTT_TSF_R2T_SEL_8812F 0x7
#define BIT_FTM_PTT_TSF_R2T_SEL_8812F(x)                                       \
	(((x) & BIT_MASK_FTM_PTT_TSF_R2T_SEL_8812F)                            \
	 << BIT_SHIFT_FTM_PTT_TSF_R2T_SEL_8812F)
#define BITS_FTM_PTT_TSF_R2T_SEL_8812F                                         \
	(BIT_MASK_FTM_PTT_TSF_R2T_SEL_8812F                                    \
	 << BIT_SHIFT_FTM_PTT_TSF_R2T_SEL_8812F)
#define BIT_CLEAR_FTM_PTT_TSF_R2T_SEL_8812F(x)                                 \
	((x) & (~BITS_FTM_PTT_TSF_R2T_SEL_8812F))
#define BIT_GET_FTM_PTT_TSF_R2T_SEL_8812F(x)                                   \
	(((x) >> BIT_SHIFT_FTM_PTT_TSF_R2T_SEL_8812F) &                        \
	 BIT_MASK_FTM_PTT_TSF_R2T_SEL_8812F)
#define BIT_SET_FTM_PTT_TSF_R2T_SEL_8812F(x, v)                                \
	(BIT_CLEAR_FTM_PTT_TSF_R2T_SEL_8812F(x) |                              \
	 BIT_FTM_PTT_TSF_R2T_SEL_8812F(v))

#define BIT_SHIFT_FTM_PTT_TSF_T2R_SEL_8812F 19
#define BIT_MASK_FTM_PTT_TSF_T2R_SEL_8812F 0x7
#define BIT_FTM_PTT_TSF_T2R_SEL_8812F(x)                                       \
	(((x) & BIT_MASK_FTM_PTT_TSF_T2R_SEL_8812F)                            \
	 << BIT_SHIFT_FTM_PTT_TSF_T2R_SEL_8812F)
#define BITS_FTM_PTT_TSF_T2R_SEL_8812F                                         \
	(BIT_MASK_FTM_PTT_TSF_T2R_SEL_8812F                                    \
	 << BIT_SHIFT_FTM_PTT_TSF_T2R_SEL_8812F)
#define BIT_CLEAR_FTM_PTT_TSF_T2R_SEL_8812F(x)                                 \
	((x) & (~BITS_FTM_PTT_TSF_T2R_SEL_8812F))
#define BIT_GET_FTM_PTT_TSF_T2R_SEL_8812F(x)                                   \
	(((x) >> BIT_SHIFT_FTM_PTT_TSF_T2R_SEL_8812F) &                        \
	 BIT_MASK_FTM_PTT_TSF_T2R_SEL_8812F)
#define BIT_SET_FTM_PTT_TSF_T2R_SEL_8812F(x, v)                                \
	(BIT_CLEAR_FTM_PTT_TSF_T2R_SEL_8812F(x) |                              \
	 BIT_FTM_PTT_TSF_T2R_SEL_8812F(v))

#define BIT_SHIFT_FTM_PTT_TSF_SEL_8812F 16
#define BIT_MASK_FTM_PTT_TSF_SEL_8812F 0x7
#define BIT_FTM_PTT_TSF_SEL_8812F(x)                                           \
	(((x) & BIT_MASK_FTM_PTT_TSF_SEL_8812F)                                \
	 << BIT_SHIFT_FTM_PTT_TSF_SEL_8812F)
#define BITS_FTM_PTT_TSF_SEL_8812F                                             \
	(BIT_MASK_FTM_PTT_TSF_SEL_8812F << BIT_SHIFT_FTM_PTT_TSF_SEL_8812F)
#define BIT_CLEAR_FTM_PTT_TSF_SEL_8812F(x) ((x) & (~BITS_FTM_PTT_TSF_SEL_8812F))
#define BIT_GET_FTM_PTT_TSF_SEL_8812F(x)                                       \
	(((x) >> BIT_SHIFT_FTM_PTT_TSF_SEL_8812F) &                            \
	 BIT_MASK_FTM_PTT_TSF_SEL_8812F)
#define BIT_SET_FTM_PTT_TSF_SEL_8812F(x, v)                                    \
	(BIT_CLEAR_FTM_PTT_TSF_SEL_8812F(x) | BIT_FTM_PTT_TSF_SEL_8812F(v))

#define BIT_SHIFT_FTM_PTT_VALUE_8812F 0
#define BIT_MASK_FTM_PTT_VALUE_8812F 0xffff
#define BIT_FTM_PTT_VALUE_8812F(x)                                             \
	(((x) & BIT_MASK_FTM_PTT_VALUE_8812F) << BIT_SHIFT_FTM_PTT_VALUE_8812F)
#define BITS_FTM_PTT_VALUE_8812F                                               \
	(BIT_MASK_FTM_PTT_VALUE_8812F << BIT_SHIFT_FTM_PTT_VALUE_8812F)
#define BIT_CLEAR_FTM_PTT_VALUE_8812F(x) ((x) & (~BITS_FTM_PTT_VALUE_8812F))
#define BIT_GET_FTM_PTT_VALUE_8812F(x)                                         \
	(((x) >> BIT_SHIFT_FTM_PTT_VALUE_8812F) & BIT_MASK_FTM_PTT_VALUE_8812F)
#define BIT_SET_FTM_PTT_VALUE_8812F(x, v)                                      \
	(BIT_CLEAR_FTM_PTT_VALUE_8812F(x) | BIT_FTM_PTT_VALUE_8812F(v))

/* 2 REG_FTM_TSF_8812F */

#define BIT_SHIFT_FTM_T2_TSF_8812F 16
#define BIT_MASK_FTM_T2_TSF_8812F 0xffff
#define BIT_FTM_T2_TSF_8812F(x)                                                \
	(((x) & BIT_MASK_FTM_T2_TSF_8812F) << BIT_SHIFT_FTM_T2_TSF_8812F)
#define BITS_FTM_T2_TSF_8812F                                                  \
	(BIT_MASK_FTM_T2_TSF_8812F << BIT_SHIFT_FTM_T2_TSF_8812F)
#define BIT_CLEAR_FTM_T2_TSF_8812F(x) ((x) & (~BITS_FTM_T2_TSF_8812F))
#define BIT_GET_FTM_T2_TSF_8812F(x)                                            \
	(((x) >> BIT_SHIFT_FTM_T2_TSF_8812F) & BIT_MASK_FTM_T2_TSF_8812F)
#define BIT_SET_FTM_T2_TSF_8812F(x, v)                                         \
	(BIT_CLEAR_FTM_T2_TSF_8812F(x) | BIT_FTM_T2_TSF_8812F(v))

#define BIT_SHIFT_FTM_T1_TSF_8812F 0
#define BIT_MASK_FTM_T1_TSF_8812F 0xffff
#define BIT_FTM_T1_TSF_8812F(x)                                                \
	(((x) & BIT_MASK_FTM_T1_TSF_8812F) << BIT_SHIFT_FTM_T1_TSF_8812F)
#define BITS_FTM_T1_TSF_8812F                                                  \
	(BIT_MASK_FTM_T1_TSF_8812F << BIT_SHIFT_FTM_T1_TSF_8812F)
#define BIT_CLEAR_FTM_T1_TSF_8812F(x) ((x) & (~BITS_FTM_T1_TSF_8812F))
#define BIT_GET_FTM_T1_TSF_8812F(x)                                            \
	(((x) >> BIT_SHIFT_FTM_T1_TSF_8812F) & BIT_MASK_FTM_T1_TSF_8812F)
#define BIT_SET_FTM_T1_TSF_8812F(x, v)                                         \
	(BIT_CLEAR_FTM_T1_TSF_8812F(x) | BIT_FTM_T1_TSF_8812F(v))

/* 2 REG_BCN_CTRL_8812F */
#define BIT_DIS_RX_BSSID_FIT_8812F BIT(6)
#define BIT_P0_EN_TXBCN_RPT_8812F BIT(5)
#define BIT_DIS_TSF_UDT_8812F BIT(4)
#define BIT_EN_BCN_FUNCTION_8812F BIT(3)
#define BIT_P0_EN_RXBCN_RPT_8812F BIT(2)
#define BIT_EN_P2P_CTWINDOW_8812F BIT(1)
#define BIT_EN_P2P_BCNQ_AREA_8812F BIT(0)

/* 2 REG_BCN_CTRL_CLINT0_8812F */
#define BIT_CLI0_DIS_RX_BSSID_FIT_8812F BIT(6)
#define BIT_CLI0_DIS_TSF_UDT_8812F BIT(4)
#define BIT_CLI0_EN_BCN_FUNCTION_8812F BIT(3)
#define BIT_CLI0_EN_RXBCN_RPT_8812F BIT(2)
#define BIT_CLI0_ENP2P_CTWINDOW_8812F BIT(1)
#define BIT_CLI0_ENP2P_BCNQ_AREA_8812F BIT(0)

/* 2 REG_MBID_NUM_8812F */
#define BIT_EN_PRE_DL_BEACON_8812F BIT(3)

#define BIT_SHIFT_MBID_BCN_NUM_8812F 0
#define BIT_MASK_MBID_BCN_NUM_8812F 0x7
#define BIT_MBID_BCN_NUM_8812F(x)                                              \
	(((x) & BIT_MASK_MBID_BCN_NUM_8812F) << BIT_SHIFT_MBID_BCN_NUM_8812F)
#define BITS_MBID_BCN_NUM_8812F                                                \
	(BIT_MASK_MBID_BCN_NUM_8812F << BIT_SHIFT_MBID_BCN_NUM_8812F)
#define BIT_CLEAR_MBID_BCN_NUM_8812F(x) ((x) & (~BITS_MBID_BCN_NUM_8812F))
#define BIT_GET_MBID_BCN_NUM_8812F(x)                                          \
	(((x) >> BIT_SHIFT_MBID_BCN_NUM_8812F) & BIT_MASK_MBID_BCN_NUM_8812F)
#define BIT_SET_MBID_BCN_NUM_8812F(x, v)                                       \
	(BIT_CLEAR_MBID_BCN_NUM_8812F(x) | BIT_MBID_BCN_NUM_8812F(v))

/* 2 REG_DUAL_TSF_RST_8812F */
#define BIT_FREECNT_RST_8812F BIT(5)
#define BIT_TSFTR_CLI3_RST_8812F BIT(4)
#define BIT_TSFTR_CLI2_RST_8812F BIT(3)
#define BIT_TSFTR_CLI1_RST_8812F BIT(2)
#define BIT_TSFTR_CLI0_RST_8812F BIT(1)
#define BIT_TSFTR_RST_8812F BIT(0)

/* 2 REG_MBSSID_BCN_SPACE_8812F */

#define BIT_SHIFT_BCN_TIMER_SEL_FWRD_8812F 28
#define BIT_MASK_BCN_TIMER_SEL_FWRD_8812F 0x7
#define BIT_BCN_TIMER_SEL_FWRD_8812F(x)                                        \
	(((x) & BIT_MASK_BCN_TIMER_SEL_FWRD_8812F)                             \
	 << BIT_SHIFT_BCN_TIMER_SEL_FWRD_8812F)
#define BITS_BCN_TIMER_SEL_FWRD_8812F                                          \
	(BIT_MASK_BCN_TIMER_SEL_FWRD_8812F                                     \
	 << BIT_SHIFT_BCN_TIMER_SEL_FWRD_8812F)
#define BIT_CLEAR_BCN_TIMER_SEL_FWRD_8812F(x)                                  \
	((x) & (~BITS_BCN_TIMER_SEL_FWRD_8812F))
#define BIT_GET_BCN_TIMER_SEL_FWRD_8812F(x)                                    \
	(((x) >> BIT_SHIFT_BCN_TIMER_SEL_FWRD_8812F) &                         \
	 BIT_MASK_BCN_TIMER_SEL_FWRD_8812F)
#define BIT_SET_BCN_TIMER_SEL_FWRD_8812F(x, v)                                 \
	(BIT_CLEAR_BCN_TIMER_SEL_FWRD_8812F(x) |                               \
	 BIT_BCN_TIMER_SEL_FWRD_8812F(v))

#define BIT_SHIFT_BCN_SPACE_CLINT0_8812F 16
#define BIT_MASK_BCN_SPACE_CLINT0_8812F 0xfff
#define BIT_BCN_SPACE_CLINT0_8812F(x)                                          \
	(((x) & BIT_MASK_BCN_SPACE_CLINT0_8812F)                               \
	 << BIT_SHIFT_BCN_SPACE_CLINT0_8812F)
#define BITS_BCN_SPACE_CLINT0_8812F                                            \
	(BIT_MASK_BCN_SPACE_CLINT0_8812F << BIT_SHIFT_BCN_SPACE_CLINT0_8812F)
#define BIT_CLEAR_BCN_SPACE_CLINT0_8812F(x)                                    \
	((x) & (~BITS_BCN_SPACE_CLINT0_8812F))
#define BIT_GET_BCN_SPACE_CLINT0_8812F(x)                                      \
	(((x) >> BIT_SHIFT_BCN_SPACE_CLINT0_8812F) &                           \
	 BIT_MASK_BCN_SPACE_CLINT0_8812F)
#define BIT_SET_BCN_SPACE_CLINT0_8812F(x, v)                                   \
	(BIT_CLEAR_BCN_SPACE_CLINT0_8812F(x) | BIT_BCN_SPACE_CLINT0_8812F(v))

#define BIT_SHIFT_BCN_SPACE0_8812F 0
#define BIT_MASK_BCN_SPACE0_8812F 0xffff
#define BIT_BCN_SPACE0_8812F(x)                                                \
	(((x) & BIT_MASK_BCN_SPACE0_8812F) << BIT_SHIFT_BCN_SPACE0_8812F)
#define BITS_BCN_SPACE0_8812F                                                  \
	(BIT_MASK_BCN_SPACE0_8812F << BIT_SHIFT_BCN_SPACE0_8812F)
#define BIT_CLEAR_BCN_SPACE0_8812F(x) ((x) & (~BITS_BCN_SPACE0_8812F))
#define BIT_GET_BCN_SPACE0_8812F(x)                                            \
	(((x) >> BIT_SHIFT_BCN_SPACE0_8812F) & BIT_MASK_BCN_SPACE0_8812F)
#define BIT_SET_BCN_SPACE0_8812F(x, v)                                         \
	(BIT_CLEAR_BCN_SPACE0_8812F(x) | BIT_BCN_SPACE0_8812F(v))

/* 2 REG_DRVERLYINT_8812F */

#define BIT_SHIFT_DRVERLYITV_8812F 0
#define BIT_MASK_DRVERLYITV_8812F 0xff
#define BIT_DRVERLYITV_8812F(x)                                                \
	(((x) & BIT_MASK_DRVERLYITV_8812F) << BIT_SHIFT_DRVERLYITV_8812F)
#define BITS_DRVERLYITV_8812F                                                  \
	(BIT_MASK_DRVERLYITV_8812F << BIT_SHIFT_DRVERLYITV_8812F)
#define BIT_CLEAR_DRVERLYITV_8812F(x) ((x) & (~BITS_DRVERLYITV_8812F))
#define BIT_GET_DRVERLYITV_8812F(x)                                            \
	(((x) >> BIT_SHIFT_DRVERLYITV_8812F) & BIT_MASK_DRVERLYITV_8812F)
#define BIT_SET_DRVERLYITV_8812F(x, v)                                         \
	(BIT_CLEAR_DRVERLYITV_8812F(x) | BIT_DRVERLYITV_8812F(v))

/* 2 REG_BCNDMATIM_8812F */

#define BIT_SHIFT_BCNDMATIM_8812F 0
#define BIT_MASK_BCNDMATIM_8812F 0xff
#define BIT_BCNDMATIM_8812F(x)                                                 \
	(((x) & BIT_MASK_BCNDMATIM_8812F) << BIT_SHIFT_BCNDMATIM_8812F)
#define BITS_BCNDMATIM_8812F                                                   \
	(BIT_MASK_BCNDMATIM_8812F << BIT_SHIFT_BCNDMATIM_8812F)
#define BIT_CLEAR_BCNDMATIM_8812F(x) ((x) & (~BITS_BCNDMATIM_8812F))
#define BIT_GET_BCNDMATIM_8812F(x)                                             \
	(((x) >> BIT_SHIFT_BCNDMATIM_8812F) & BIT_MASK_BCNDMATIM_8812F)
#define BIT_SET_BCNDMATIM_8812F(x, v)                                          \
	(BIT_CLEAR_BCNDMATIM_8812F(x) | BIT_BCNDMATIM_8812F(v))

/* 2 REG_ATIMWND_8812F */

#define BIT_SHIFT_ATIMWND0_8812F 0
#define BIT_MASK_ATIMWND0_8812F 0xffff
#define BIT_ATIMWND0_8812F(x)                                                  \
	(((x) & BIT_MASK_ATIMWND0_8812F) << BIT_SHIFT_ATIMWND0_8812F)
#define BITS_ATIMWND0_8812F                                                    \
	(BIT_MASK_ATIMWND0_8812F << BIT_SHIFT_ATIMWND0_8812F)
#define BIT_CLEAR_ATIMWND0_8812F(x) ((x) & (~BITS_ATIMWND0_8812F))
#define BIT_GET_ATIMWND0_8812F(x)                                              \
	(((x) >> BIT_SHIFT_ATIMWND0_8812F) & BIT_MASK_ATIMWND0_8812F)
#define BIT_SET_ATIMWND0_8812F(x, v)                                           \
	(BIT_CLEAR_ATIMWND0_8812F(x) | BIT_ATIMWND0_8812F(v))

/* 2 REG_USTIME_TSF_8812F */

#define BIT_SHIFT_USTIME_TSF_V1_8812F 0
#define BIT_MASK_USTIME_TSF_V1_8812F 0xff
#define BIT_USTIME_TSF_V1_8812F(x)                                             \
	(((x) & BIT_MASK_USTIME_TSF_V1_8812F) << BIT_SHIFT_USTIME_TSF_V1_8812F)
#define BITS_USTIME_TSF_V1_8812F                                               \
	(BIT_MASK_USTIME_TSF_V1_8812F << BIT_SHIFT_USTIME_TSF_V1_8812F)
#define BIT_CLEAR_USTIME_TSF_V1_8812F(x) ((x) & (~BITS_USTIME_TSF_V1_8812F))
#define BIT_GET_USTIME_TSF_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_USTIME_TSF_V1_8812F) & BIT_MASK_USTIME_TSF_V1_8812F)
#define BIT_SET_USTIME_TSF_V1_8812F(x, v)                                      \
	(BIT_CLEAR_USTIME_TSF_V1_8812F(x) | BIT_USTIME_TSF_V1_8812F(v))

/* 2 REG_BCN_MAX_ERR_8812F */

#define BIT_SHIFT_BCN_MAX_ERR_8812F 0
#define BIT_MASK_BCN_MAX_ERR_8812F 0xff
#define BIT_BCN_MAX_ERR_8812F(x)                                               \
	(((x) & BIT_MASK_BCN_MAX_ERR_8812F) << BIT_SHIFT_BCN_MAX_ERR_8812F)
#define BITS_BCN_MAX_ERR_8812F                                                 \
	(BIT_MASK_BCN_MAX_ERR_8812F << BIT_SHIFT_BCN_MAX_ERR_8812F)
#define BIT_CLEAR_BCN_MAX_ERR_8812F(x) ((x) & (~BITS_BCN_MAX_ERR_8812F))
#define BIT_GET_BCN_MAX_ERR_8812F(x)                                           \
	(((x) >> BIT_SHIFT_BCN_MAX_ERR_8812F) & BIT_MASK_BCN_MAX_ERR_8812F)
#define BIT_SET_BCN_MAX_ERR_8812F(x, v)                                        \
	(BIT_CLEAR_BCN_MAX_ERR_8812F(x) | BIT_BCN_MAX_ERR_8812F(v))

/* 2 REG_RXTSF_OFFSET_CCK_8812F */

#define BIT_SHIFT_CCK_RXTSF_OFFSET_8812F 0
#define BIT_MASK_CCK_RXTSF_OFFSET_8812F 0xff
#define BIT_CCK_RXTSF_OFFSET_8812F(x)                                          \
	(((x) & BIT_MASK_CCK_RXTSF_OFFSET_8812F)                               \
	 << BIT_SHIFT_CCK_RXTSF_OFFSET_8812F)
#define BITS_CCK_RXTSF_OFFSET_8812F                                            \
	(BIT_MASK_CCK_RXTSF_OFFSET_8812F << BIT_SHIFT_CCK_RXTSF_OFFSET_8812F)
#define BIT_CLEAR_CCK_RXTSF_OFFSET_8812F(x)                                    \
	((x) & (~BITS_CCK_RXTSF_OFFSET_8812F))
#define BIT_GET_CCK_RXTSF_OFFSET_8812F(x)                                      \
	(((x) >> BIT_SHIFT_CCK_RXTSF_OFFSET_8812F) &                           \
	 BIT_MASK_CCK_RXTSF_OFFSET_8812F)
#define BIT_SET_CCK_RXTSF_OFFSET_8812F(x, v)                                   \
	(BIT_CLEAR_CCK_RXTSF_OFFSET_8812F(x) | BIT_CCK_RXTSF_OFFSET_8812F(v))

/* 2 REG_RXTSF_OFFSET_OFDM_8812F */

#define BIT_SHIFT_OFDM_RXTSF_OFFSET_8812F 0
#define BIT_MASK_OFDM_RXTSF_OFFSET_8812F 0xff
#define BIT_OFDM_RXTSF_OFFSET_8812F(x)                                         \
	(((x) & BIT_MASK_OFDM_RXTSF_OFFSET_8812F)                              \
	 << BIT_SHIFT_OFDM_RXTSF_OFFSET_8812F)
#define BITS_OFDM_RXTSF_OFFSET_8812F                                           \
	(BIT_MASK_OFDM_RXTSF_OFFSET_8812F << BIT_SHIFT_OFDM_RXTSF_OFFSET_8812F)
#define BIT_CLEAR_OFDM_RXTSF_OFFSET_8812F(x)                                   \
	((x) & (~BITS_OFDM_RXTSF_OFFSET_8812F))
#define BIT_GET_OFDM_RXTSF_OFFSET_8812F(x)                                     \
	(((x) >> BIT_SHIFT_OFDM_RXTSF_OFFSET_8812F) &                          \
	 BIT_MASK_OFDM_RXTSF_OFFSET_8812F)
#define BIT_SET_OFDM_RXTSF_OFFSET_8812F(x, v)                                  \
	(BIT_CLEAR_OFDM_RXTSF_OFFSET_8812F(x) | BIT_OFDM_RXTSF_OFFSET_8812F(v))

/* 2 REG_TSFTR_8812F */

#define BIT_SHIFT_TSF_TIMER_V1_8812F 0
#define BIT_MASK_TSF_TIMER_V1_8812F 0xffffffffL
#define BIT_TSF_TIMER_V1_8812F(x)                                              \
	(((x) & BIT_MASK_TSF_TIMER_V1_8812F) << BIT_SHIFT_TSF_TIMER_V1_8812F)
#define BITS_TSF_TIMER_V1_8812F                                                \
	(BIT_MASK_TSF_TIMER_V1_8812F << BIT_SHIFT_TSF_TIMER_V1_8812F)
#define BIT_CLEAR_TSF_TIMER_V1_8812F(x) ((x) & (~BITS_TSF_TIMER_V1_8812F))
#define BIT_GET_TSF_TIMER_V1_8812F(x)                                          \
	(((x) >> BIT_SHIFT_TSF_TIMER_V1_8812F) & BIT_MASK_TSF_TIMER_V1_8812F)
#define BIT_SET_TSF_TIMER_V1_8812F(x, v)                                       \
	(BIT_CLEAR_TSF_TIMER_V1_8812F(x) | BIT_TSF_TIMER_V1_8812F(v))

/* 2 REG_TSFTR_1_8812F */

#define BIT_SHIFT_TSF_TIMER_V2_8812F 0
#define BIT_MASK_TSF_TIMER_V2_8812F 0xffffffffL
#define BIT_TSF_TIMER_V2_8812F(x)                                              \
	(((x) & BIT_MASK_TSF_TIMER_V2_8812F) << BIT_SHIFT_TSF_TIMER_V2_8812F)
#define BITS_TSF_TIMER_V2_8812F                                                \
	(BIT_MASK_TSF_TIMER_V2_8812F << BIT_SHIFT_TSF_TIMER_V2_8812F)
#define BIT_CLEAR_TSF_TIMER_V2_8812F(x) ((x) & (~BITS_TSF_TIMER_V2_8812F))
#define BIT_GET_TSF_TIMER_V2_8812F(x)                                          \
	(((x) >> BIT_SHIFT_TSF_TIMER_V2_8812F) & BIT_MASK_TSF_TIMER_V2_8812F)
#define BIT_SET_TSF_TIMER_V2_8812F(x, v)                                       \
	(BIT_CLEAR_TSF_TIMER_V2_8812F(x) | BIT_TSF_TIMER_V2_8812F(v))

/* 2 REG_FREERUN_CNT_8812F */

#define BIT_SHIFT_FREERUN_CNT_V1_8812F 0
#define BIT_MASK_FREERUN_CNT_V1_8812F 0xffffffffL
#define BIT_FREERUN_CNT_V1_8812F(x)                                            \
	(((x) & BIT_MASK_FREERUN_CNT_V1_8812F)                                 \
	 << BIT_SHIFT_FREERUN_CNT_V1_8812F)
#define BITS_FREERUN_CNT_V1_8812F                                              \
	(BIT_MASK_FREERUN_CNT_V1_8812F << BIT_SHIFT_FREERUN_CNT_V1_8812F)
#define BIT_CLEAR_FREERUN_CNT_V1_8812F(x) ((x) & (~BITS_FREERUN_CNT_V1_8812F))
#define BIT_GET_FREERUN_CNT_V1_8812F(x)                                        \
	(((x) >> BIT_SHIFT_FREERUN_CNT_V1_8812F) &                             \
	 BIT_MASK_FREERUN_CNT_V1_8812F)
#define BIT_SET_FREERUN_CNT_V1_8812F(x, v)                                     \
	(BIT_CLEAR_FREERUN_CNT_V1_8812F(x) | BIT_FREERUN_CNT_V1_8812F(v))

/* 2 REG_FREERUN_CNT_1_8812F */

#define BIT_SHIFT_FREERUN_CNT_V2_8812F 0
#define BIT_MASK_FREERUN_CNT_V2_8812F 0xffffffffL
#define BIT_FREERUN_CNT_V2_8812F(x)                                            \
	(((x) & BIT_MASK_FREERUN_CNT_V2_8812F)                                 \
	 << BIT_SHIFT_FREERUN_CNT_V2_8812F)
#define BITS_FREERUN_CNT_V2_8812F                                              \
	(BIT_MASK_FREERUN_CNT_V2_8812F << BIT_SHIFT_FREERUN_CNT_V2_8812F)
#define BIT_CLEAR_FREERUN_CNT_V2_8812F(x) ((x) & (~BITS_FREERUN_CNT_V2_8812F))
#define BIT_GET_FREERUN_CNT_V2_8812F(x)                                        \
	(((x) >> BIT_SHIFT_FREERUN_CNT_V2_8812F) &                             \
	 BIT_MASK_FREERUN_CNT_V2_8812F)
#define BIT_SET_FREERUN_CNT_V2_8812F(x, v)                                     \
	(BIT_CLEAR_FREERUN_CNT_V2_8812F(x) | BIT_FREERUN_CNT_V2_8812F(v))

/* 2 REG_ATIMWND1_V1_8812F */

#define BIT_SHIFT_ATIMWND1_V1_8812F 0
#define BIT_MASK_ATIMWND1_V1_8812F 0xff
#define BIT_ATIMWND1_V1_8812F(x)                                               \
	(((x) & BIT_MASK_ATIMWND1_V1_8812F) << BIT_SHIFT_ATIMWND1_V1_8812F)
#define BITS_ATIMWND1_V1_8812F                                                 \
	(BIT_MASK_ATIMWND1_V1_8812F << BIT_SHIFT_ATIMWND1_V1_8812F)
#define BIT_CLEAR_ATIMWND1_V1_8812F(x) ((x) & (~BITS_ATIMWND1_V1_8812F))
#define BIT_GET_ATIMWND1_V1_8812F(x)                                           \
	(((x) >> BIT_SHIFT_ATIMWND1_V1_8812F) & BIT_MASK_ATIMWND1_V1_8812F)
#define BIT_SET_ATIMWND1_V1_8812F(x, v)                                        \
	(BIT_CLEAR_ATIMWND1_V1_8812F(x) | BIT_ATIMWND1_V1_8812F(v))

/* 2 REG_TBTT_PROHIBIT_INFRA_8812F */

#define BIT_SHIFT_TBTT_PROHIBIT_INFRA_8812F 0
#define BIT_MASK_TBTT_PROHIBIT_INFRA_8812F 0xff
#define BIT_TBTT_PROHIBIT_INFRA_8812F(x)                                       \
	(((x) & BIT_MASK_TBTT_PROHIBIT_INFRA_8812F)                            \
	 << BIT_SHIFT_TBTT_PROHIBIT_INFRA_8812F)
#define BITS_TBTT_PROHIBIT_INFRA_8812F                                         \
	(BIT_MASK_TBTT_PROHIBIT_INFRA_8812F                                    \
	 << BIT_SHIFT_TBTT_PROHIBIT_INFRA_8812F)
#define BIT_CLEAR_TBTT_PROHIBIT_INFRA_8812F(x)                                 \
	((x) & (~BITS_TBTT_PROHIBIT_INFRA_8812F))
#define BIT_GET_TBTT_PROHIBIT_INFRA_8812F(x)                                   \
	(((x) >> BIT_SHIFT_TBTT_PROHIBIT_INFRA_8812F) &                        \
	 BIT_MASK_TBTT_PROHIBIT_INFRA_8812F)
#define BIT_SET_TBTT_PROHIBIT_INFRA_8812F(x, v)                                \
	(BIT_CLEAR_TBTT_PROHIBIT_INFRA_8812F(x) |                              \
	 BIT_TBTT_PROHIBIT_INFRA_8812F(v))

/* 2 REG_CTWND_8812F */

#define BIT_SHIFT_CTWND_8812F 0
#define BIT_MASK_CTWND_8812F 0xff
#define BIT_CTWND_8812F(x)                                                     \
	(((x) & BIT_MASK_CTWND_8812F) << BIT_SHIFT_CTWND_8812F)
#define BITS_CTWND_8812F (BIT_MASK_CTWND_8812F << BIT_SHIFT_CTWND_8812F)
#define BIT_CLEAR_CTWND_8812F(x) ((x) & (~BITS_CTWND_8812F))
#define BIT_GET_CTWND_8812F(x)                                                 \
	(((x) >> BIT_SHIFT_CTWND_8812F) & BIT_MASK_CTWND_8812F)
#define BIT_SET_CTWND_8812F(x, v)                                              \
	(BIT_CLEAR_CTWND_8812F(x) | BIT_CTWND_8812F(v))

/* 2 REG_BCNIVLCUNT_8812F */

#define BIT_SHIFT_BCNIVLCUNT_8812F 0
#define BIT_MASK_BCNIVLCUNT_8812F 0x7f
#define BIT_BCNIVLCUNT_8812F(x)                                                \
	(((x) & BIT_MASK_BCNIVLCUNT_8812F) << BIT_SHIFT_BCNIVLCUNT_8812F)
#define BITS_BCNIVLCUNT_8812F                                                  \
	(BIT_MASK_BCNIVLCUNT_8812F << BIT_SHIFT_BCNIVLCUNT_8812F)
#define BIT_CLEAR_BCNIVLCUNT_8812F(x) ((x) & (~BITS_BCNIVLCUNT_8812F))
#define BIT_GET_BCNIVLCUNT_8812F(x)                                            \
	(((x) >> BIT_SHIFT_BCNIVLCUNT_8812F) & BIT_MASK_BCNIVLCUNT_8812F)
#define BIT_SET_BCNIVLCUNT_8812F(x, v)                                         \
	(BIT_CLEAR_BCNIVLCUNT_8812F(x) | BIT_BCNIVLCUNT_8812F(v))

/* 2 REG_BCNDROPCTRL_8812F */
#define BIT_BEACON_DROP_EN_8812F BIT(7)

#define BIT_SHIFT_BEACON_DROP_IVL_8812F 0
#define BIT_MASK_BEACON_DROP_IVL_8812F 0x7f
#define BIT_BEACON_DROP_IVL_8812F(x)                                           \
	(((x) & BIT_MASK_BEACON_DROP_IVL_8812F)                                \
	 << BIT_SHIFT_BEACON_DROP_IVL_8812F)
#define BITS_BEACON_DROP_IVL_8812F                                             \
	(BIT_MASK_BEACON_DROP_IVL_8812F << BIT_SHIFT_BEACON_DROP_IVL_8812F)
#define BIT_CLEAR_BEACON_DROP_IVL_8812F(x) ((x) & (~BITS_BEACON_DROP_IVL_8812F))
#define BIT_GET_BEACON_DROP_IVL_8812F(x)                                       \
	(((x) >> BIT_SHIFT_BEACON_DROP_IVL_8812F) &                            \
	 BIT_MASK_BEACON_DROP_IVL_8812F)
#define BIT_SET_BEACON_DROP_IVL_8812F(x, v)                                    \
	(BIT_CLEAR_BEACON_DROP_IVL_8812F(x) | BIT_BEACON_DROP_IVL_8812F(v))

/* 2 REG_HGQ_TIMEOUT_PERIOD_8812F */

#define BIT_SHIFT_HGQ_TIMEOUT_PERIOD_8812F 0
#define BIT_MASK_HGQ_TIMEOUT_PERIOD_8812F 0xff
#define BIT_HGQ_TIMEOUT_PERIOD_8812F(x)                                        \
	(((x) & BIT_MASK_HGQ_TIMEOUT_PERIOD_8812F)                             \
	 << BIT_SHIFT_HGQ_TIMEOUT_PERIOD_8812F)
#define BITS_HGQ_TIMEOUT_PERIOD_8812F                                          \
	(BIT_MASK_HGQ_TIMEOUT_PERIOD_8812F                                     \
	 << BIT_SHIFT_HGQ_TIMEOUT_PERIOD_8812F)
#define BIT_CLEAR_HGQ_TIMEOUT_PERIOD_8812F(x)                                  \
	((x) & (~BITS_HGQ_TIMEOUT_PERIOD_8812F))
#define BIT_GET_HGQ_TIMEOUT_PERIOD_8812F(x)                                    \
	(((x) >> BIT_SHIFT_HGQ_TIMEOUT_PERIOD_8812F) &                         \
	 BIT_MASK_HGQ_TIMEOUT_PERIOD_8812F)
#define BIT_SET_HGQ_TIMEOUT_PERIOD_8812F(x, v)                                 \
	(BIT_CLEAR_HGQ_TIMEOUT_PERIOD_8812F(x) |                               \
	 BIT_HGQ_TIMEOUT_PERIOD_8812F(v))

/* 2 REG_TXCMD_TIMEOUT_PERIOD_8812F */

#define BIT_SHIFT_TXCMD_TIMEOUT_PERIOD_8812F 0
#define BIT_MASK_TXCMD_TIMEOUT_PERIOD_8812F 0xff
#define BIT_TXCMD_TIMEOUT_PERIOD_8812F(x)                                      \
	(((x) & BIT_MASK_TXCMD_TIMEOUT_PERIOD_8812F)                           \
	 << BIT_SHIFT_TXCMD_TIMEOUT_PERIOD_8812F)
#define BITS_TXCMD_TIMEOUT_PERIOD_8812F                                        \
	(BIT_MASK_TXCMD_TIMEOUT_PERIOD_8812F                                   \
	 << BIT_SHIFT_TXCMD_TIMEOUT_PERIOD_8812F)
#define BIT_CLEAR_TXCMD_TIMEOUT_PERIOD_8812F(x)                                \
	((x) & (~BITS_TXCMD_TIMEOUT_PERIOD_8812F))
#define BIT_GET_TXCMD_TIMEOUT_PERIOD_8812F(x)                                  \
	(((x) >> BIT_SHIFT_TXCMD_TIMEOUT_PERIOD_8812F) &                       \
	 BIT_MASK_TXCMD_TIMEOUT_PERIOD_8812F)
#define BIT_SET_TXCMD_TIMEOUT_PERIOD_8812F(x, v)                               \
	(BIT_CLEAR_TXCMD_TIMEOUT_PERIOD_8812F(x) |                             \
	 BIT_TXCMD_TIMEOUT_PERIOD_8812F(v))

/* 2 REG_MISC_CTRL_8812F */
#define BIT_DIS_MARK_TSF_US_V2_8812F BIT(7)
#define BIT_AUTO_SYNC_BY_TBTT_8812F BIT(6)
#define BIT_DIS_TRX_CAL_BCN_8812F BIT(5)
#define BIT_DIS_TX_CAL_TBTT_8812F BIT(4)
#define BIT_EN_FREECNT_8812F BIT(3)
#define BIT_BCN_AGGRESSION_8812F BIT(2)

#define BIT_SHIFT_DIS_SECONDARY_CCA_8812F 0
#define BIT_MASK_DIS_SECONDARY_CCA_8812F 0x3
#define BIT_DIS_SECONDARY_CCA_8812F(x)                                         \
	(((x) & BIT_MASK_DIS_SECONDARY_CCA_8812F)                              \
	 << BIT_SHIFT_DIS_SECONDARY_CCA_8812F)
#define BITS_DIS_SECONDARY_CCA_8812F                                           \
	(BIT_MASK_DIS_SECONDARY_CCA_8812F << BIT_SHIFT_DIS_SECONDARY_CCA_8812F)
#define BIT_CLEAR_DIS_SECONDARY_CCA_8812F(x)                                   \
	((x) & (~BITS_DIS_SECONDARY_CCA_8812F))
#define BIT_GET_DIS_SECONDARY_CCA_8812F(x)                                     \
	(((x) >> BIT_SHIFT_DIS_SECONDARY_CCA_8812F) &                          \
	 BIT_MASK_DIS_SECONDARY_CCA_8812F)
#define BIT_SET_DIS_SECONDARY_CCA_8812F(x, v)                                  \
	(BIT_CLEAR_DIS_SECONDARY_CCA_8812F(x) | BIT_DIS_SECONDARY_CCA_8812F(v))

/* 2 REG_BCN_CTRL_CLINT1_8812F */
#define BIT_CLI1_DIS_RX_BSSID_FIT_8812F BIT(6)
#define BIT_CLI1_DIS_TSF_UDT_8812F BIT(4)
#define BIT_CLI1_EN_BCN_FUNCTION_8812F BIT(3)
#define BIT_CLI1_EN_RXBCN_RPT_8812F BIT(2)
#define BIT_CLI1_ENP2P_CTWINDOW_8812F BIT(1)
#define BIT_CLI1_ENP2P_BCNQ_AREA_8812F BIT(0)

/* 2 REG_BCN_CTRL_CLINT2_8812F */
#define BIT_CLI2_DIS_RX_BSSID_FIT_8812F BIT(6)
#define BIT_CLI2_DIS_TSF_UDT_8812F BIT(4)
#define BIT_CLI2_EN_BCN_FUNCTION_8812F BIT(3)
#define BIT_CLI2_EN_RXBCN_RPT_8812F BIT(2)
#define BIT_CLI2_ENP2P_CTWINDOW_8812F BIT(1)
#define BIT_CLI2_ENP2P_BCNQ_AREA_8812F BIT(0)

/* 2 REG_BCN_CTRL_CLINT3_8812F */
#define BIT_CLI3_DIS_RX_BSSID_FIT_8812F BIT(6)
#define BIT_CLI3_DIS_TSF_UDT_8812F BIT(4)
#define BIT_CLI3_EN_BCN_FUNCTION_8812F BIT(3)
#define BIT_CLI3_EN_RXBCN_RPT_8812F BIT(2)
#define BIT_CLI3_ENP2P_CTWINDOW_8812F BIT(1)
#define BIT_CLI3_ENP2P_BCNQ_AREA_8812F BIT(0)

/* 2 REG_EXTEND_CTRL_8812F */
#define BIT_EN_TSFBIT32_RST_P2P2_8812F BIT(5)
#define BIT_EN_TSFBIT32_RST_P2P1_8812F BIT(4)

#define BIT_SHIFT_PORT_SEL_8812F 0
#define BIT_MASK_PORT_SEL_8812F 0x7
#define BIT_PORT_SEL_8812F(x)                                                  \
	(((x) & BIT_MASK_PORT_SEL_8812F) << BIT_SHIFT_PORT_SEL_8812F)
#define BITS_PORT_SEL_8812F                                                    \
	(BIT_MASK_PORT_SEL_8812F << BIT_SHIFT_PORT_SEL_8812F)
#define BIT_CLEAR_PORT_SEL_8812F(x) ((x) & (~BITS_PORT_SEL_8812F))
#define BIT_GET_PORT_SEL_8812F(x)                                              \
	(((x) >> BIT_SHIFT_PORT_SEL_8812F) & BIT_MASK_PORT_SEL_8812F)
#define BIT_SET_PORT_SEL_8812F(x, v)                                           \
	(BIT_CLEAR_PORT_SEL_8812F(x) | BIT_PORT_SEL_8812F(v))

/* 2 REG_P2PPS1_SPEC_STATE_8812F */
#define BIT_P2P1_SPEC_POWER_STATE_8812F BIT(7)
#define BIT_P2P1_SPEC_CTWINDOW_ON_8812F BIT(6)
#define BIT_P2P1_SPEC_BCN_AREA_ON_8812F BIT(5)
#define BIT_P2P1_SPEC_CTWIN_EARLY_DISTX_8812F BIT(4)
#define BIT_P2P1_SPEC_NOA1_OFF_PERIOD_8812F BIT(3)
#define BIT_P2P1_SPEC_FORCE_DOZE1_8812F BIT(2)
#define BIT_P2P1_SPEC_NOA0_OFF_PERIOD_8812F BIT(1)
#define BIT_P2P1_SPEC_FORCE_DOZE0_8812F BIT(0)

/* 2 REG_P2PPS1_STATE_8812F */
#define BIT_P2P1_POWER_STATE_8812F BIT(7)
#define BIT_P2P1_CTWINDOW_ON_8812F BIT(6)
#define BIT_P2P1_BEACON_AREA_ON_8812F BIT(5)
#define BIT_P2P1_CTWIN_EARLY_DISTX_8812F BIT(4)
#define BIT_P2P1_NOA1_OFF_PERIOD_8812F BIT(3)
#define BIT_P2P1_FORCE_DOZE1_8812F BIT(2)
#define BIT_P2P1_NOA0_OFF_PERIOD_8812F BIT(1)
#define BIT_P2P1_FORCE_DOZE0_8812F BIT(0)

/* 2 REG_P2PPS2_SPEC_STATE_8812F */
#define BIT_P2P2_SPEC_POWER_STATE_8812F BIT(7)
#define BIT_P2P2_SPEC_CTWINDOW_ON_8812F BIT(6)
#define BIT_P2P2_SPEC_BCN_AREA_ON_8812F BIT(5)
#define BIT_P2P2_SPEC_CTWIN_EARLY_DISTX_8812F BIT(4)
#define BIT_P2P2_SPEC_NOA1_OFF_PERIOD_8812F BIT(3)
#define BIT_P2P2_SPEC_FORCE_DOZE1_8812F BIT(2)
#define BIT_P2P2_SPEC_NOA0_OFF_PERIOD_8812F BIT(1)
#define BIT_P2P2_SPEC_FORCE_DOZE0_8812F BIT(0)

/* 2 REG_P2PPS2_STATE_8812F */
#define BIT_P2P2_POWER_STATE_8812F BIT(7)
#define BIT_P2P2_CTWINDOW_ON_8812F BIT(6)
#define BIT_P2P2_BEACON_AREA_ON_8812F BIT(5)
#define BIT_P2P2_CTWIN_EARLY_DISTX_8812F BIT(4)
#define BIT_P2P2_NOA1_OFF_PERIOD_8812F BIT(3)
#define BIT_P2P2_FORCE_DOZE1_8812F BIT(2)
#define BIT_P2P2_NOA0_OFF_PERIOD_8812F BIT(1)
#define BIT_P2P2_FORCE_DOZE0_8812F BIT(0)

/* 2 REG_PS_TIMER0_8812F */

#define BIT_SHIFT_PSTIMER0_INT_8812F 5
#define BIT_MASK_PSTIMER0_INT_8812F 0x7ffffff
#define BIT_PSTIMER0_INT_8812F(x)                                              \
	(((x) & BIT_MASK_PSTIMER0_INT_8812F) << BIT_SHIFT_PSTIMER0_INT_8812F)
#define BITS_PSTIMER0_INT_8812F                                                \
	(BIT_MASK_PSTIMER0_INT_8812F << BIT_SHIFT_PSTIMER0_INT_8812F)
#define BIT_CLEAR_PSTIMER0_INT_8812F(x) ((x) & (~BITS_PSTIMER0_INT_8812F))
#define BIT_GET_PSTIMER0_INT_8812F(x)                                          \
	(((x) >> BIT_SHIFT_PSTIMER0_INT_8812F) & BIT_MASK_PSTIMER0_INT_8812F)
#define BIT_SET_PSTIMER0_INT_8812F(x, v)                                       \
	(BIT_CLEAR_PSTIMER0_INT_8812F(x) | BIT_PSTIMER0_INT_8812F(v))

/* 2 REG_PS_TIMER1_8812F */

#define BIT_SHIFT_PSTIMER1_INT_8812F 5
#define BIT_MASK_PSTIMER1_INT_8812F 0x7ffffff
#define BIT_PSTIMER1_INT_8812F(x)                                              \
	(((x) & BIT_MASK_PSTIMER1_INT_8812F) << BIT_SHIFT_PSTIMER1_INT_8812F)
#define BITS_PSTIMER1_INT_8812F                                                \
	(BIT_MASK_PSTIMER1_INT_8812F << BIT_SHIFT_PSTIMER1_INT_8812F)
#define BIT_CLEAR_PSTIMER1_INT_8812F(x) ((x) & (~BITS_PSTIMER1_INT_8812F))
#define BIT_GET_PSTIMER1_INT_8812F(x)                                          \
	(((x) >> BIT_SHIFT_PSTIMER1_INT_8812F) & BIT_MASK_PSTIMER1_INT_8812F)
#define BIT_SET_PSTIMER1_INT_8812F(x, v)                                       \
	(BIT_CLEAR_PSTIMER1_INT_8812F(x) | BIT_PSTIMER1_INT_8812F(v))

/* 2 REG_PS_TIMER2_8812F */

#define BIT_SHIFT_PSTIMER2_INT_8812F 5
#define BIT_MASK_PSTIMER2_INT_8812F 0x7ffffff
#define BIT_PSTIMER2_INT_8812F(x)                                              \
	(((x) & BIT_MASK_PSTIMER2_INT_8812F) << BIT_SHIFT_PSTIMER2_INT_8812F)
#define BITS_PSTIMER2_INT_8812F                                                \
	(BIT_MASK_PSTIMER2_INT_8812F << BIT_SHIFT_PSTIMER2_INT_8812F)
#define BIT_CLEAR_PSTIMER2_INT_8812F(x) ((x) & (~BITS_PSTIMER2_INT_8812F))
#define BIT_GET_PSTIMER2_INT_8812F(x)                                          \
	(((x) >> BIT_SHIFT_PSTIMER2_INT_8812F) & BIT_MASK_PSTIMER2_INT_8812F)
#define BIT_SET_PSTIMER2_INT_8812F(x, v)                                       \
	(BIT_CLEAR_PSTIMER2_INT_8812F(x) | BIT_PSTIMER2_INT_8812F(v))

/* 2 REG_TBTT_CTN_AREA_8812F */

#define BIT_SHIFT_TBTT_CTN_AREA_8812F 0
#define BIT_MASK_TBTT_CTN_AREA_8812F 0xff
#define BIT_TBTT_CTN_AREA_8812F(x)                                             \
	(((x) & BIT_MASK_TBTT_CTN_AREA_8812F) << BIT_SHIFT_TBTT_CTN_AREA_8812F)
#define BITS_TBTT_CTN_AREA_8812F                                               \
	(BIT_MASK_TBTT_CTN_AREA_8812F << BIT_SHIFT_TBTT_CTN_AREA_8812F)
#define BIT_CLEAR_TBTT_CTN_AREA_8812F(x) ((x) & (~BITS_TBTT_CTN_AREA_8812F))
#define BIT_GET_TBTT_CTN_AREA_8812F(x)                                         \
	(((x) >> BIT_SHIFT_TBTT_CTN_AREA_8812F) & BIT_MASK_TBTT_CTN_AREA_8812F)
#define BIT_SET_TBTT_CTN_AREA_8812F(x, v)                                      \
	(BIT_CLEAR_TBTT_CTN_AREA_8812F(x) | BIT_TBTT_CTN_AREA_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_FORCE_BCN_IFS_8812F */

#define BIT_SHIFT_FORCE_BCN_IFS_8812F 0
#define BIT_MASK_FORCE_BCN_IFS_8812F 0xff
#define BIT_FORCE_BCN_IFS_8812F(x)                                             \
	(((x) & BIT_MASK_FORCE_BCN_IFS_8812F) << BIT_SHIFT_FORCE_BCN_IFS_8812F)
#define BITS_FORCE_BCN_IFS_8812F                                               \
	(BIT_MASK_FORCE_BCN_IFS_8812F << BIT_SHIFT_FORCE_BCN_IFS_8812F)
#define BIT_CLEAR_FORCE_BCN_IFS_8812F(x) ((x) & (~BITS_FORCE_BCN_IFS_8812F))
#define BIT_GET_FORCE_BCN_IFS_8812F(x)                                         \
	(((x) >> BIT_SHIFT_FORCE_BCN_IFS_8812F) & BIT_MASK_FORCE_BCN_IFS_8812F)
#define BIT_SET_FORCE_BCN_IFS_8812F(x, v)                                      \
	(BIT_CLEAR_FORCE_BCN_IFS_8812F(x) | BIT_FORCE_BCN_IFS_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_TXOP_MIN_8812F */
#define BIT_HIQ_NAV_BREAK_EN_8812F BIT(15)
#define BIT_MGQ_NAV_BREAK_EN_8812F BIT(14)

#define BIT_SHIFT_TXOP_MIN_8812F 0
#define BIT_MASK_TXOP_MIN_8812F 0x3fff
#define BIT_TXOP_MIN_8812F(x)                                                  \
	(((x) & BIT_MASK_TXOP_MIN_8812F) << BIT_SHIFT_TXOP_MIN_8812F)
#define BITS_TXOP_MIN_8812F                                                    \
	(BIT_MASK_TXOP_MIN_8812F << BIT_SHIFT_TXOP_MIN_8812F)
#define BIT_CLEAR_TXOP_MIN_8812F(x) ((x) & (~BITS_TXOP_MIN_8812F))
#define BIT_GET_TXOP_MIN_8812F(x)                                              \
	(((x) >> BIT_SHIFT_TXOP_MIN_8812F) & BIT_MASK_TXOP_MIN_8812F)
#define BIT_SET_TXOP_MIN_8812F(x, v)                                           \
	(BIT_CLEAR_TXOP_MIN_8812F(x) | BIT_TXOP_MIN_8812F(v))

/* 2 REG_PRE_BKF_TIME_8812F */

#define BIT_SHIFT_PRE_BKF_TIME_8812F 0
#define BIT_MASK_PRE_BKF_TIME_8812F 0xff
#define BIT_PRE_BKF_TIME_8812F(x)                                              \
	(((x) & BIT_MASK_PRE_BKF_TIME_8812F) << BIT_SHIFT_PRE_BKF_TIME_8812F)
#define BITS_PRE_BKF_TIME_8812F                                                \
	(BIT_MASK_PRE_BKF_TIME_8812F << BIT_SHIFT_PRE_BKF_TIME_8812F)
#define BIT_CLEAR_PRE_BKF_TIME_8812F(x) ((x) & (~BITS_PRE_BKF_TIME_8812F))
#define BIT_GET_PRE_BKF_TIME_8812F(x)                                          \
	(((x) >> BIT_SHIFT_PRE_BKF_TIME_8812F) & BIT_MASK_PRE_BKF_TIME_8812F)
#define BIT_SET_PRE_BKF_TIME_8812F(x, v)                                       \
	(BIT_CLEAR_PRE_BKF_TIME_8812F(x) | BIT_PRE_BKF_TIME_8812F(v))

/* 2 REG_CROSS_TXOP_CTRL_8812F */
#define BIT_TXFAIL_BREACK_TXOP_EN_8812F BIT(3)
#define BIT_DTIM_BYPASS_8812F BIT(2)
#define BIT_RTS_NAV_TXOP_8812F BIT(1)
#define BIT_NOT_CROSS_TXOP_8812F BIT(0)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_RX_TBTT_SHIFT_V1_8812F */
#define BIT_RX_TBTT_SHIFT_RW_FLAG_V1_8812F BIT(31)

#define BIT_SHIFT_RX_TBTT_SHIFT_OFFSET_V1_8812F 16
#define BIT_MASK_RX_TBTT_SHIFT_OFFSET_V1_8812F 0xfff
#define BIT_RX_TBTT_SHIFT_OFFSET_V1_8812F(x)                                   \
	(((x) & BIT_MASK_RX_TBTT_SHIFT_OFFSET_V1_8812F)                        \
	 << BIT_SHIFT_RX_TBTT_SHIFT_OFFSET_V1_8812F)
#define BITS_RX_TBTT_SHIFT_OFFSET_V1_8812F                                     \
	(BIT_MASK_RX_TBTT_SHIFT_OFFSET_V1_8812F                                \
	 << BIT_SHIFT_RX_TBTT_SHIFT_OFFSET_V1_8812F)
#define BIT_CLEAR_RX_TBTT_SHIFT_OFFSET_V1_8812F(x)                             \
	((x) & (~BITS_RX_TBTT_SHIFT_OFFSET_V1_8812F))
#define BIT_GET_RX_TBTT_SHIFT_OFFSET_V1_8812F(x)                               \
	(((x) >> BIT_SHIFT_RX_TBTT_SHIFT_OFFSET_V1_8812F) &                    \
	 BIT_MASK_RX_TBTT_SHIFT_OFFSET_V1_8812F)
#define BIT_SET_RX_TBTT_SHIFT_OFFSET_V1_8812F(x, v)                            \
	(BIT_CLEAR_RX_TBTT_SHIFT_OFFSET_V1_8812F(x) |                          \
	 BIT_RX_TBTT_SHIFT_OFFSET_V1_8812F(v))

#define BIT_SHIFT_RX_TBTT_SHIFT_SEL_V1_8812F 8
#define BIT_MASK_RX_TBTT_SHIFT_SEL_V1_8812F 0x7
#define BIT_RX_TBTT_SHIFT_SEL_V1_8812F(x)                                      \
	(((x) & BIT_MASK_RX_TBTT_SHIFT_SEL_V1_8812F)                           \
	 << BIT_SHIFT_RX_TBTT_SHIFT_SEL_V1_8812F)
#define BITS_RX_TBTT_SHIFT_SEL_V1_8812F                                        \
	(BIT_MASK_RX_TBTT_SHIFT_SEL_V1_8812F                                   \
	 << BIT_SHIFT_RX_TBTT_SHIFT_SEL_V1_8812F)
#define BIT_CLEAR_RX_TBTT_SHIFT_SEL_V1_8812F(x)                                \
	((x) & (~BITS_RX_TBTT_SHIFT_SEL_V1_8812F))
#define BIT_GET_RX_TBTT_SHIFT_SEL_V1_8812F(x)                                  \
	(((x) >> BIT_SHIFT_RX_TBTT_SHIFT_SEL_V1_8812F) &                       \
	 BIT_MASK_RX_TBTT_SHIFT_SEL_V1_8812F)
#define BIT_SET_RX_TBTT_SHIFT_SEL_V1_8812F(x, v)                               \
	(BIT_CLEAR_RX_TBTT_SHIFT_SEL_V1_8812F(x) |                             \
	 BIT_RX_TBTT_SHIFT_SEL_V1_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_ATIMWND2_8812F */

#define BIT_SHIFT_ATIMWND2_8812F 0
#define BIT_MASK_ATIMWND2_8812F 0xff
#define BIT_ATIMWND2_8812F(x)                                                  \
	(((x) & BIT_MASK_ATIMWND2_8812F) << BIT_SHIFT_ATIMWND2_8812F)
#define BITS_ATIMWND2_8812F                                                    \
	(BIT_MASK_ATIMWND2_8812F << BIT_SHIFT_ATIMWND2_8812F)
#define BIT_CLEAR_ATIMWND2_8812F(x) ((x) & (~BITS_ATIMWND2_8812F))
#define BIT_GET_ATIMWND2_8812F(x)                                              \
	(((x) >> BIT_SHIFT_ATIMWND2_8812F) & BIT_MASK_ATIMWND2_8812F)
#define BIT_SET_ATIMWND2_8812F(x, v)                                           \
	(BIT_CLEAR_ATIMWND2_8812F(x) | BIT_ATIMWND2_8812F(v))

/* 2 REG_ATIMWND3_8812F */

#define BIT_SHIFT_ATIMWND3_8812F 0
#define BIT_MASK_ATIMWND3_8812F 0xff
#define BIT_ATIMWND3_8812F(x)                                                  \
	(((x) & BIT_MASK_ATIMWND3_8812F) << BIT_SHIFT_ATIMWND3_8812F)
#define BITS_ATIMWND3_8812F                                                    \
	(BIT_MASK_ATIMWND3_8812F << BIT_SHIFT_ATIMWND3_8812F)
#define BIT_CLEAR_ATIMWND3_8812F(x) ((x) & (~BITS_ATIMWND3_8812F))
#define BIT_GET_ATIMWND3_8812F(x)                                              \
	(((x) >> BIT_SHIFT_ATIMWND3_8812F) & BIT_MASK_ATIMWND3_8812F)
#define BIT_SET_ATIMWND3_8812F(x, v)                                           \
	(BIT_CLEAR_ATIMWND3_8812F(x) | BIT_ATIMWND3_8812F(v))

/* 2 REG_ATIMWND4_8812F */

#define BIT_SHIFT_ATIMWND4_8812F 0
#define BIT_MASK_ATIMWND4_8812F 0xff
#define BIT_ATIMWND4_8812F(x)                                                  \
	(((x) & BIT_MASK_ATIMWND4_8812F) << BIT_SHIFT_ATIMWND4_8812F)
#define BITS_ATIMWND4_8812F                                                    \
	(BIT_MASK_ATIMWND4_8812F << BIT_SHIFT_ATIMWND4_8812F)
#define BIT_CLEAR_ATIMWND4_8812F(x) ((x) & (~BITS_ATIMWND4_8812F))
#define BIT_GET_ATIMWND4_8812F(x)                                              \
	(((x) >> BIT_SHIFT_ATIMWND4_8812F) & BIT_MASK_ATIMWND4_8812F)
#define BIT_SET_ATIMWND4_8812F(x, v)                                           \
	(BIT_CLEAR_ATIMWND4_8812F(x) | BIT_ATIMWND4_8812F(v))

/* 2 REG_ATIMWND5_8812F */

#define BIT_SHIFT_ATIMWND5_8812F 0
#define BIT_MASK_ATIMWND5_8812F 0xff
#define BIT_ATIMWND5_8812F(x)                                                  \
	(((x) & BIT_MASK_ATIMWND5_8812F) << BIT_SHIFT_ATIMWND5_8812F)
#define BITS_ATIMWND5_8812F                                                    \
	(BIT_MASK_ATIMWND5_8812F << BIT_SHIFT_ATIMWND5_8812F)
#define BIT_CLEAR_ATIMWND5_8812F(x) ((x) & (~BITS_ATIMWND5_8812F))
#define BIT_GET_ATIMWND5_8812F(x)                                              \
	(((x) >> BIT_SHIFT_ATIMWND5_8812F) & BIT_MASK_ATIMWND5_8812F)
#define BIT_SET_ATIMWND5_8812F(x, v)                                           \
	(BIT_CLEAR_ATIMWND5_8812F(x) | BIT_ATIMWND5_8812F(v))

/* 2 REG_ATIMWND6_8812F */

#define BIT_SHIFT_ATIMWND6_8812F 0
#define BIT_MASK_ATIMWND6_8812F 0xff
#define BIT_ATIMWND6_8812F(x)                                                  \
	(((x) & BIT_MASK_ATIMWND6_8812F) << BIT_SHIFT_ATIMWND6_8812F)
#define BITS_ATIMWND6_8812F                                                    \
	(BIT_MASK_ATIMWND6_8812F << BIT_SHIFT_ATIMWND6_8812F)
#define BIT_CLEAR_ATIMWND6_8812F(x) ((x) & (~BITS_ATIMWND6_8812F))
#define BIT_GET_ATIMWND6_8812F(x)                                              \
	(((x) >> BIT_SHIFT_ATIMWND6_8812F) & BIT_MASK_ATIMWND6_8812F)
#define BIT_SET_ATIMWND6_8812F(x, v)                                           \
	(BIT_CLEAR_ATIMWND6_8812F(x) | BIT_ATIMWND6_8812F(v))

/* 2 REG_ATIMWND7_8812F */

#define BIT_SHIFT_ATIMWND7_8812F 0
#define BIT_MASK_ATIMWND7_8812F 0xff
#define BIT_ATIMWND7_8812F(x)                                                  \
	(((x) & BIT_MASK_ATIMWND7_8812F) << BIT_SHIFT_ATIMWND7_8812F)
#define BITS_ATIMWND7_8812F                                                    \
	(BIT_MASK_ATIMWND7_8812F << BIT_SHIFT_ATIMWND7_8812F)
#define BIT_CLEAR_ATIMWND7_8812F(x) ((x) & (~BITS_ATIMWND7_8812F))
#define BIT_GET_ATIMWND7_8812F(x)                                              \
	(((x) >> BIT_SHIFT_ATIMWND7_8812F) & BIT_MASK_ATIMWND7_8812F)
#define BIT_SET_ATIMWND7_8812F(x, v)                                           \
	(BIT_CLEAR_ATIMWND7_8812F(x) | BIT_ATIMWND7_8812F(v))

/* 2 REG_ATIMUGT_8812F */

#define BIT_SHIFT_ATIM_URGENT_8812F 0
#define BIT_MASK_ATIM_URGENT_8812F 0xff
#define BIT_ATIM_URGENT_8812F(x)                                               \
	(((x) & BIT_MASK_ATIM_URGENT_8812F) << BIT_SHIFT_ATIM_URGENT_8812F)
#define BITS_ATIM_URGENT_8812F                                                 \
	(BIT_MASK_ATIM_URGENT_8812F << BIT_SHIFT_ATIM_URGENT_8812F)
#define BIT_CLEAR_ATIM_URGENT_8812F(x) ((x) & (~BITS_ATIM_URGENT_8812F))
#define BIT_GET_ATIM_URGENT_8812F(x)                                           \
	(((x) >> BIT_SHIFT_ATIM_URGENT_8812F) & BIT_MASK_ATIM_URGENT_8812F)
#define BIT_SET_ATIM_URGENT_8812F(x, v)                                        \
	(BIT_CLEAR_ATIM_URGENT_8812F(x) | BIT_ATIM_URGENT_8812F(v))

/* 2 REG_HIQ_NO_LMT_EN_8812F */
#define BIT_HIQ_NO_LMT_EN_VAP7_8812F BIT(7)
#define BIT_HIQ_NO_LMT_EN_VAP6_8812F BIT(6)
#define BIT_HIQ_NO_LMT_EN_VAP5_8812F BIT(5)
#define BIT_HIQ_NO_LMT_EN_VAP4_8812F BIT(4)
#define BIT_HIQ_NO_LMT_EN_VAP3_8812F BIT(3)
#define BIT_HIQ_NO_LMT_EN_VAP2_8812F BIT(2)
#define BIT_HIQ_NO_LMT_EN_VAP1_8812F BIT(1)
#define BIT_HIQ_NO_LMT_EN_ROOT_8812F BIT(0)

/* 2 REG_DTIM_COUNTER_ROOT_8812F */

#define BIT_SHIFT_DTIM_COUNT_ROOT_8812F 0
#define BIT_MASK_DTIM_COUNT_ROOT_8812F 0xff
#define BIT_DTIM_COUNT_ROOT_8812F(x)                                           \
	(((x) & BIT_MASK_DTIM_COUNT_ROOT_8812F)                                \
	 << BIT_SHIFT_DTIM_COUNT_ROOT_8812F)
#define BITS_DTIM_COUNT_ROOT_8812F                                             \
	(BIT_MASK_DTIM_COUNT_ROOT_8812F << BIT_SHIFT_DTIM_COUNT_ROOT_8812F)
#define BIT_CLEAR_DTIM_COUNT_ROOT_8812F(x) ((x) & (~BITS_DTIM_COUNT_ROOT_8812F))
#define BIT_GET_DTIM_COUNT_ROOT_8812F(x)                                       \
	(((x) >> BIT_SHIFT_DTIM_COUNT_ROOT_8812F) &                            \
	 BIT_MASK_DTIM_COUNT_ROOT_8812F)
#define BIT_SET_DTIM_COUNT_ROOT_8812F(x, v)                                    \
	(BIT_CLEAR_DTIM_COUNT_ROOT_8812F(x) | BIT_DTIM_COUNT_ROOT_8812F(v))

/* 2 REG_DTIM_COUNTER_VAP1_8812F */

#define BIT_SHIFT_DTIM_COUNT_VAP1_8812F 0
#define BIT_MASK_DTIM_COUNT_VAP1_8812F 0xff
#define BIT_DTIM_COUNT_VAP1_8812F(x)                                           \
	(((x) & BIT_MASK_DTIM_COUNT_VAP1_8812F)                                \
	 << BIT_SHIFT_DTIM_COUNT_VAP1_8812F)
#define BITS_DTIM_COUNT_VAP1_8812F                                             \
	(BIT_MASK_DTIM_COUNT_VAP1_8812F << BIT_SHIFT_DTIM_COUNT_VAP1_8812F)
#define BIT_CLEAR_DTIM_COUNT_VAP1_8812F(x) ((x) & (~BITS_DTIM_COUNT_VAP1_8812F))
#define BIT_GET_DTIM_COUNT_VAP1_8812F(x)                                       \
	(((x) >> BIT_SHIFT_DTIM_COUNT_VAP1_8812F) &                            \
	 BIT_MASK_DTIM_COUNT_VAP1_8812F)
#define BIT_SET_DTIM_COUNT_VAP1_8812F(x, v)                                    \
	(BIT_CLEAR_DTIM_COUNT_VAP1_8812F(x) | BIT_DTIM_COUNT_VAP1_8812F(v))

/* 2 REG_DTIM_COUNTER_VAP2_8812F */

#define BIT_SHIFT_DTIM_COUNT_VAP2_8812F 0
#define BIT_MASK_DTIM_COUNT_VAP2_8812F 0xff
#define BIT_DTIM_COUNT_VAP2_8812F(x)                                           \
	(((x) & BIT_MASK_DTIM_COUNT_VAP2_8812F)                                \
	 << BIT_SHIFT_DTIM_COUNT_VAP2_8812F)
#define BITS_DTIM_COUNT_VAP2_8812F                                             \
	(BIT_MASK_DTIM_COUNT_VAP2_8812F << BIT_SHIFT_DTIM_COUNT_VAP2_8812F)
#define BIT_CLEAR_DTIM_COUNT_VAP2_8812F(x) ((x) & (~BITS_DTIM_COUNT_VAP2_8812F))
#define BIT_GET_DTIM_COUNT_VAP2_8812F(x)                                       \
	(((x) >> BIT_SHIFT_DTIM_COUNT_VAP2_8812F) &                            \
	 BIT_MASK_DTIM_COUNT_VAP2_8812F)
#define BIT_SET_DTIM_COUNT_VAP2_8812F(x, v)                                    \
	(BIT_CLEAR_DTIM_COUNT_VAP2_8812F(x) | BIT_DTIM_COUNT_VAP2_8812F(v))

/* 2 REG_DTIM_COUNTER_VAP3_8812F */

#define BIT_SHIFT_DTIM_COUNT_VAP3_8812F 0
#define BIT_MASK_DTIM_COUNT_VAP3_8812F 0xff
#define BIT_DTIM_COUNT_VAP3_8812F(x)                                           \
	(((x) & BIT_MASK_DTIM_COUNT_VAP3_8812F)                                \
	 << BIT_SHIFT_DTIM_COUNT_VAP3_8812F)
#define BITS_DTIM_COUNT_VAP3_8812F                                             \
	(BIT_MASK_DTIM_COUNT_VAP3_8812F << BIT_SHIFT_DTIM_COUNT_VAP3_8812F)
#define BIT_CLEAR_DTIM_COUNT_VAP3_8812F(x) ((x) & (~BITS_DTIM_COUNT_VAP3_8812F))
#define BIT_GET_DTIM_COUNT_VAP3_8812F(x)                                       \
	(((x) >> BIT_SHIFT_DTIM_COUNT_VAP3_8812F) &                            \
	 BIT_MASK_DTIM_COUNT_VAP3_8812F)
#define BIT_SET_DTIM_COUNT_VAP3_8812F(x, v)                                    \
	(BIT_CLEAR_DTIM_COUNT_VAP3_8812F(x) | BIT_DTIM_COUNT_VAP3_8812F(v))

/* 2 REG_DTIM_COUNTER_VAP4_8812F */

#define BIT_SHIFT_DTIM_COUNT_VAP4_8812F 0
#define BIT_MASK_DTIM_COUNT_VAP4_8812F 0xff
#define BIT_DTIM_COUNT_VAP4_8812F(x)                                           \
	(((x) & BIT_MASK_DTIM_COUNT_VAP4_8812F)                                \
	 << BIT_SHIFT_DTIM_COUNT_VAP4_8812F)
#define BITS_DTIM_COUNT_VAP4_8812F                                             \
	(BIT_MASK_DTIM_COUNT_VAP4_8812F << BIT_SHIFT_DTIM_COUNT_VAP4_8812F)
#define BIT_CLEAR_DTIM_COUNT_VAP4_8812F(x) ((x) & (~BITS_DTIM_COUNT_VAP4_8812F))
#define BIT_GET_DTIM_COUNT_VAP4_8812F(x)                                       \
	(((x) >> BIT_SHIFT_DTIM_COUNT_VAP4_8812F) &                            \
	 BIT_MASK_DTIM_COUNT_VAP4_8812F)
#define BIT_SET_DTIM_COUNT_VAP4_8812F(x, v)                                    \
	(BIT_CLEAR_DTIM_COUNT_VAP4_8812F(x) | BIT_DTIM_COUNT_VAP4_8812F(v))

/* 2 REG_DTIM_COUNTER_VAP5_8812F */

#define BIT_SHIFT_DTIM_COUNT_VAP5_8812F 0
#define BIT_MASK_DTIM_COUNT_VAP5_8812F 0xff
#define BIT_DTIM_COUNT_VAP5_8812F(x)                                           \
	(((x) & BIT_MASK_DTIM_COUNT_VAP5_8812F)                                \
	 << BIT_SHIFT_DTIM_COUNT_VAP5_8812F)
#define BITS_DTIM_COUNT_VAP5_8812F                                             \
	(BIT_MASK_DTIM_COUNT_VAP5_8812F << BIT_SHIFT_DTIM_COUNT_VAP5_8812F)
#define BIT_CLEAR_DTIM_COUNT_VAP5_8812F(x) ((x) & (~BITS_DTIM_COUNT_VAP5_8812F))
#define BIT_GET_DTIM_COUNT_VAP5_8812F(x)                                       \
	(((x) >> BIT_SHIFT_DTIM_COUNT_VAP5_8812F) &                            \
	 BIT_MASK_DTIM_COUNT_VAP5_8812F)
#define BIT_SET_DTIM_COUNT_VAP5_8812F(x, v)                                    \
	(BIT_CLEAR_DTIM_COUNT_VAP5_8812F(x) | BIT_DTIM_COUNT_VAP5_8812F(v))

/* 2 REG_DTIM_COUNTER_VAP6_8812F */

#define BIT_SHIFT_DTIM_COUNT_VAP6_8812F 0
#define BIT_MASK_DTIM_COUNT_VAP6_8812F 0xff
#define BIT_DTIM_COUNT_VAP6_8812F(x)                                           \
	(((x) & BIT_MASK_DTIM_COUNT_VAP6_8812F)                                \
	 << BIT_SHIFT_DTIM_COUNT_VAP6_8812F)
#define BITS_DTIM_COUNT_VAP6_8812F                                             \
	(BIT_MASK_DTIM_COUNT_VAP6_8812F << BIT_SHIFT_DTIM_COUNT_VAP6_8812F)
#define BIT_CLEAR_DTIM_COUNT_VAP6_8812F(x) ((x) & (~BITS_DTIM_COUNT_VAP6_8812F))
#define BIT_GET_DTIM_COUNT_VAP6_8812F(x)                                       \
	(((x) >> BIT_SHIFT_DTIM_COUNT_VAP6_8812F) &                            \
	 BIT_MASK_DTIM_COUNT_VAP6_8812F)
#define BIT_SET_DTIM_COUNT_VAP6_8812F(x, v)                                    \
	(BIT_CLEAR_DTIM_COUNT_VAP6_8812F(x) | BIT_DTIM_COUNT_VAP6_8812F(v))

/* 2 REG_DTIM_COUNTER_VAP7_8812F */

#define BIT_SHIFT_DTIM_COUNT_VAP7_8812F 0
#define BIT_MASK_DTIM_COUNT_VAP7_8812F 0xff
#define BIT_DTIM_COUNT_VAP7_8812F(x)                                           \
	(((x) & BIT_MASK_DTIM_COUNT_VAP7_8812F)                                \
	 << BIT_SHIFT_DTIM_COUNT_VAP7_8812F)
#define BITS_DTIM_COUNT_VAP7_8812F                                             \
	(BIT_MASK_DTIM_COUNT_VAP7_8812F << BIT_SHIFT_DTIM_COUNT_VAP7_8812F)
#define BIT_CLEAR_DTIM_COUNT_VAP7_8812F(x) ((x) & (~BITS_DTIM_COUNT_VAP7_8812F))
#define BIT_GET_DTIM_COUNT_VAP7_8812F(x)                                       \
	(((x) >> BIT_SHIFT_DTIM_COUNT_VAP7_8812F) &                            \
	 BIT_MASK_DTIM_COUNT_VAP7_8812F)
#define BIT_SET_DTIM_COUNT_VAP7_8812F(x, v)                                    \
	(BIT_CLEAR_DTIM_COUNT_VAP7_8812F(x) | BIT_DTIM_COUNT_VAP7_8812F(v))

/* 2 REG_DIS_ATIM_8812F */
#define BIT_DIS_ATIM_VAP7_8812F BIT(7)
#define BIT_DIS_ATIM_VAP6_8812F BIT(6)
#define BIT_DIS_ATIM_VAP5_8812F BIT(5)
#define BIT_DIS_ATIM_VAP4_8812F BIT(4)
#define BIT_DIS_ATIM_VAP3_8812F BIT(3)
#define BIT_DIS_ATIM_VAP2_8812F BIT(2)
#define BIT_DIS_ATIM_VAP1_8812F BIT(1)
#define BIT_DIS_ATIM_ROOT_8812F BIT(0)

/* 2 REG_EARLY_128US_8812F */

#define BIT_SHIFT_TSFT_SEL_TIMER1_8812F 3
#define BIT_MASK_TSFT_SEL_TIMER1_8812F 0x7
#define BIT_TSFT_SEL_TIMER1_8812F(x)                                           \
	(((x) & BIT_MASK_TSFT_SEL_TIMER1_8812F)                                \
	 << BIT_SHIFT_TSFT_SEL_TIMER1_8812F)
#define BITS_TSFT_SEL_TIMER1_8812F                                             \
	(BIT_MASK_TSFT_SEL_TIMER1_8812F << BIT_SHIFT_TSFT_SEL_TIMER1_8812F)
#define BIT_CLEAR_TSFT_SEL_TIMER1_8812F(x) ((x) & (~BITS_TSFT_SEL_TIMER1_8812F))
#define BIT_GET_TSFT_SEL_TIMER1_8812F(x)                                       \
	(((x) >> BIT_SHIFT_TSFT_SEL_TIMER1_8812F) &                            \
	 BIT_MASK_TSFT_SEL_TIMER1_8812F)
#define BIT_SET_TSFT_SEL_TIMER1_8812F(x, v)                                    \
	(BIT_CLEAR_TSFT_SEL_TIMER1_8812F(x) | BIT_TSFT_SEL_TIMER1_8812F(v))

#define BIT_SHIFT_EARLY_128US_8812F 0
#define BIT_MASK_EARLY_128US_8812F 0x7
#define BIT_EARLY_128US_8812F(x)                                               \
	(((x) & BIT_MASK_EARLY_128US_8812F) << BIT_SHIFT_EARLY_128US_8812F)
#define BITS_EARLY_128US_8812F                                                 \
	(BIT_MASK_EARLY_128US_8812F << BIT_SHIFT_EARLY_128US_8812F)
#define BIT_CLEAR_EARLY_128US_8812F(x) ((x) & (~BITS_EARLY_128US_8812F))
#define BIT_GET_EARLY_128US_8812F(x)                                           \
	(((x) >> BIT_SHIFT_EARLY_128US_8812F) & BIT_MASK_EARLY_128US_8812F)
#define BIT_SET_EARLY_128US_8812F(x, v)                                        \
	(BIT_CLEAR_EARLY_128US_8812F(x) | BIT_EARLY_128US_8812F(v))

/* 2 REG_P2PPS1_CTRL_8812F */
#define BIT_P2P1_CTW_ALLSTASLEEP_8812F BIT(7)
#define BIT_P2P1_OFF_DISTX_EN_8812F BIT(6)
#define BIT_P2P1_PWR_MGT_EN_8812F BIT(5)
#define BIT_P2P1_NOA1_EN_8812F BIT(2)
#define BIT_P2P1_NOA0_EN_8812F BIT(1)

/* 2 REG_P2PPS2_CTRL_8812F */
#define BIT_P2P2_CTW_ALLSTASLEEP_8812F BIT(7)
#define BIT_P2P2_OFF_DISTX_EN_8812F BIT(6)
#define BIT_P2P2_PWR_MGT_EN_8812F BIT(5)
#define BIT_P2P2_NOA1_EN_8812F BIT(2)
#define BIT_P2P2_NOA0_EN_8812F BIT(1)

/* 2 REG_TIMER0_SRC_SEL_8812F */

#define BIT_SHIFT_SYNC_CLI_SEL_8812F 4
#define BIT_MASK_SYNC_CLI_SEL_8812F 0x7
#define BIT_SYNC_CLI_SEL_8812F(x)                                              \
	(((x) & BIT_MASK_SYNC_CLI_SEL_8812F) << BIT_SHIFT_SYNC_CLI_SEL_8812F)
#define BITS_SYNC_CLI_SEL_8812F                                                \
	(BIT_MASK_SYNC_CLI_SEL_8812F << BIT_SHIFT_SYNC_CLI_SEL_8812F)
#define BIT_CLEAR_SYNC_CLI_SEL_8812F(x) ((x) & (~BITS_SYNC_CLI_SEL_8812F))
#define BIT_GET_SYNC_CLI_SEL_8812F(x)                                          \
	(((x) >> BIT_SHIFT_SYNC_CLI_SEL_8812F) & BIT_MASK_SYNC_CLI_SEL_8812F)
#define BIT_SET_SYNC_CLI_SEL_8812F(x, v)                                       \
	(BIT_CLEAR_SYNC_CLI_SEL_8812F(x) | BIT_SYNC_CLI_SEL_8812F(v))

#define BIT_SHIFT_TSFT_SEL_TIMER0_8812F 0
#define BIT_MASK_TSFT_SEL_TIMER0_8812F 0x7
#define BIT_TSFT_SEL_TIMER0_8812F(x)                                           \
	(((x) & BIT_MASK_TSFT_SEL_TIMER0_8812F)                                \
	 << BIT_SHIFT_TSFT_SEL_TIMER0_8812F)
#define BITS_TSFT_SEL_TIMER0_8812F                                             \
	(BIT_MASK_TSFT_SEL_TIMER0_8812F << BIT_SHIFT_TSFT_SEL_TIMER0_8812F)
#define BIT_CLEAR_TSFT_SEL_TIMER0_8812F(x) ((x) & (~BITS_TSFT_SEL_TIMER0_8812F))
#define BIT_GET_TSFT_SEL_TIMER0_8812F(x)                                       \
	(((x) >> BIT_SHIFT_TSFT_SEL_TIMER0_8812F) &                            \
	 BIT_MASK_TSFT_SEL_TIMER0_8812F)
#define BIT_SET_TSFT_SEL_TIMER0_8812F(x, v)                                    \
	(BIT_CLEAR_TSFT_SEL_TIMER0_8812F(x) | BIT_TSFT_SEL_TIMER0_8812F(v))

/* 2 REG_NOA_UNIT_SEL_8812F */

#define BIT_SHIFT_NOA_UNIT2_SEL_8812F 8
#define BIT_MASK_NOA_UNIT2_SEL_8812F 0x7
#define BIT_NOA_UNIT2_SEL_8812F(x)                                             \
	(((x) & BIT_MASK_NOA_UNIT2_SEL_8812F) << BIT_SHIFT_NOA_UNIT2_SEL_8812F)
#define BITS_NOA_UNIT2_SEL_8812F                                               \
	(BIT_MASK_NOA_UNIT2_SEL_8812F << BIT_SHIFT_NOA_UNIT2_SEL_8812F)
#define BIT_CLEAR_NOA_UNIT2_SEL_8812F(x) ((x) & (~BITS_NOA_UNIT2_SEL_8812F))
#define BIT_GET_NOA_UNIT2_SEL_8812F(x)                                         \
	(((x) >> BIT_SHIFT_NOA_UNIT2_SEL_8812F) & BIT_MASK_NOA_UNIT2_SEL_8812F)
#define BIT_SET_NOA_UNIT2_SEL_8812F(x, v)                                      \
	(BIT_CLEAR_NOA_UNIT2_SEL_8812F(x) | BIT_NOA_UNIT2_SEL_8812F(v))

#define BIT_SHIFT_NOA_UNIT1_SEL_8812F 4
#define BIT_MASK_NOA_UNIT1_SEL_8812F 0x7
#define BIT_NOA_UNIT1_SEL_8812F(x)                                             \
	(((x) & BIT_MASK_NOA_UNIT1_SEL_8812F) << BIT_SHIFT_NOA_UNIT1_SEL_8812F)
#define BITS_NOA_UNIT1_SEL_8812F                                               \
	(BIT_MASK_NOA_UNIT1_SEL_8812F << BIT_SHIFT_NOA_UNIT1_SEL_8812F)
#define BIT_CLEAR_NOA_UNIT1_SEL_8812F(x) ((x) & (~BITS_NOA_UNIT1_SEL_8812F))
#define BIT_GET_NOA_UNIT1_SEL_8812F(x)                                         \
	(((x) >> BIT_SHIFT_NOA_UNIT1_SEL_8812F) & BIT_MASK_NOA_UNIT1_SEL_8812F)
#define BIT_SET_NOA_UNIT1_SEL_8812F(x, v)                                      \
	(BIT_CLEAR_NOA_UNIT1_SEL_8812F(x) | BIT_NOA_UNIT1_SEL_8812F(v))

#define BIT_SHIFT_NOA_UNIT0_SEL_8812F 0
#define BIT_MASK_NOA_UNIT0_SEL_8812F 0x7
#define BIT_NOA_UNIT0_SEL_8812F(x)                                             \
	(((x) & BIT_MASK_NOA_UNIT0_SEL_8812F) << BIT_SHIFT_NOA_UNIT0_SEL_8812F)
#define BITS_NOA_UNIT0_SEL_8812F                                               \
	(BIT_MASK_NOA_UNIT0_SEL_8812F << BIT_SHIFT_NOA_UNIT0_SEL_8812F)
#define BIT_CLEAR_NOA_UNIT0_SEL_8812F(x) ((x) & (~BITS_NOA_UNIT0_SEL_8812F))
#define BIT_GET_NOA_UNIT0_SEL_8812F(x)                                         \
	(((x) >> BIT_SHIFT_NOA_UNIT0_SEL_8812F) & BIT_MASK_NOA_UNIT0_SEL_8812F)
#define BIT_SET_NOA_UNIT0_SEL_8812F(x, v)                                      \
	(BIT_CLEAR_NOA_UNIT0_SEL_8812F(x) | BIT_NOA_UNIT0_SEL_8812F(v))

/* 2 REG_P2POFF_DIS_TXTIME_8812F */

#define BIT_SHIFT_P2POFF_DIS_TXTIME_8812F 0
#define BIT_MASK_P2POFF_DIS_TXTIME_8812F 0xff
#define BIT_P2POFF_DIS_TXTIME_8812F(x)                                         \
	(((x) & BIT_MASK_P2POFF_DIS_TXTIME_8812F)                              \
	 << BIT_SHIFT_P2POFF_DIS_TXTIME_8812F)
#define BITS_P2POFF_DIS_TXTIME_8812F                                           \
	(BIT_MASK_P2POFF_DIS_TXTIME_8812F << BIT_SHIFT_P2POFF_DIS_TXTIME_8812F)
#define BIT_CLEAR_P2POFF_DIS_TXTIME_8812F(x)                                   \
	((x) & (~BITS_P2POFF_DIS_TXTIME_8812F))
#define BIT_GET_P2POFF_DIS_TXTIME_8812F(x)                                     \
	(((x) >> BIT_SHIFT_P2POFF_DIS_TXTIME_8812F) &                          \
	 BIT_MASK_P2POFF_DIS_TXTIME_8812F)
#define BIT_SET_P2POFF_DIS_TXTIME_8812F(x, v)                                  \
	(BIT_CLEAR_P2POFF_DIS_TXTIME_8812F(x) | BIT_P2POFF_DIS_TXTIME_8812F(v))

/* 2 REG_MBSSID_BCN_SPACE2_8812F */

#define BIT_SHIFT_BCN_SPACE_CLINT2_8812F 16
#define BIT_MASK_BCN_SPACE_CLINT2_8812F 0xfff
#define BIT_BCN_SPACE_CLINT2_8812F(x)                                          \
	(((x) & BIT_MASK_BCN_SPACE_CLINT2_8812F)                               \
	 << BIT_SHIFT_BCN_SPACE_CLINT2_8812F)
#define BITS_BCN_SPACE_CLINT2_8812F                                            \
	(BIT_MASK_BCN_SPACE_CLINT2_8812F << BIT_SHIFT_BCN_SPACE_CLINT2_8812F)
#define BIT_CLEAR_BCN_SPACE_CLINT2_8812F(x)                                    \
	((x) & (~BITS_BCN_SPACE_CLINT2_8812F))
#define BIT_GET_BCN_SPACE_CLINT2_8812F(x)                                      \
	(((x) >> BIT_SHIFT_BCN_SPACE_CLINT2_8812F) &                           \
	 BIT_MASK_BCN_SPACE_CLINT2_8812F)
#define BIT_SET_BCN_SPACE_CLINT2_8812F(x, v)                                   \
	(BIT_CLEAR_BCN_SPACE_CLINT2_8812F(x) | BIT_BCN_SPACE_CLINT2_8812F(v))

#define BIT_SHIFT_BCN_SPACE_CLINT1_8812F 0
#define BIT_MASK_BCN_SPACE_CLINT1_8812F 0xfff
#define BIT_BCN_SPACE_CLINT1_8812F(x)                                          \
	(((x) & BIT_MASK_BCN_SPACE_CLINT1_8812F)                               \
	 << BIT_SHIFT_BCN_SPACE_CLINT1_8812F)
#define BITS_BCN_SPACE_CLINT1_8812F                                            \
	(BIT_MASK_BCN_SPACE_CLINT1_8812F << BIT_SHIFT_BCN_SPACE_CLINT1_8812F)
#define BIT_CLEAR_BCN_SPACE_CLINT1_8812F(x)                                    \
	((x) & (~BITS_BCN_SPACE_CLINT1_8812F))
#define BIT_GET_BCN_SPACE_CLINT1_8812F(x)                                      \
	(((x) >> BIT_SHIFT_BCN_SPACE_CLINT1_8812F) &                           \
	 BIT_MASK_BCN_SPACE_CLINT1_8812F)
#define BIT_SET_BCN_SPACE_CLINT1_8812F(x, v)                                   \
	(BIT_CLEAR_BCN_SPACE_CLINT1_8812F(x) | BIT_BCN_SPACE_CLINT1_8812F(v))

/* 2 REG_MBSSID_BCN_SPACE3_8812F */

#define BIT_SHIFT_SUB_BCN_SPACE_8812F 16
#define BIT_MASK_SUB_BCN_SPACE_8812F 0xff
#define BIT_SUB_BCN_SPACE_8812F(x)                                             \
	(((x) & BIT_MASK_SUB_BCN_SPACE_8812F) << BIT_SHIFT_SUB_BCN_SPACE_8812F)
#define BITS_SUB_BCN_SPACE_8812F                                               \
	(BIT_MASK_SUB_BCN_SPACE_8812F << BIT_SHIFT_SUB_BCN_SPACE_8812F)
#define BIT_CLEAR_SUB_BCN_SPACE_8812F(x) ((x) & (~BITS_SUB_BCN_SPACE_8812F))
#define BIT_GET_SUB_BCN_SPACE_8812F(x)                                         \
	(((x) >> BIT_SHIFT_SUB_BCN_SPACE_8812F) & BIT_MASK_SUB_BCN_SPACE_8812F)
#define BIT_SET_SUB_BCN_SPACE_8812F(x, v)                                      \
	(BIT_CLEAR_SUB_BCN_SPACE_8812F(x) | BIT_SUB_BCN_SPACE_8812F(v))

#define BIT_SHIFT_BCN_SPACE_CLINT3_8812F 0
#define BIT_MASK_BCN_SPACE_CLINT3_8812F 0xfff
#define BIT_BCN_SPACE_CLINT3_8812F(x)                                          \
	(((x) & BIT_MASK_BCN_SPACE_CLINT3_8812F)                               \
	 << BIT_SHIFT_BCN_SPACE_CLINT3_8812F)
#define BITS_BCN_SPACE_CLINT3_8812F                                            \
	(BIT_MASK_BCN_SPACE_CLINT3_8812F << BIT_SHIFT_BCN_SPACE_CLINT3_8812F)
#define BIT_CLEAR_BCN_SPACE_CLINT3_8812F(x)                                    \
	((x) & (~BITS_BCN_SPACE_CLINT3_8812F))
#define BIT_GET_BCN_SPACE_CLINT3_8812F(x)                                      \
	(((x) >> BIT_SHIFT_BCN_SPACE_CLINT3_8812F) &                           \
	 BIT_MASK_BCN_SPACE_CLINT3_8812F)
#define BIT_SET_BCN_SPACE_CLINT3_8812F(x, v)                                   \
	(BIT_CLEAR_BCN_SPACE_CLINT3_8812F(x) | BIT_BCN_SPACE_CLINT3_8812F(v))

/* 2 REG_ACMHWCTRL_8812F */
#define BIT_BEQ_ACM_STATUS_8812F BIT(7)
#define BIT_VIQ_ACM_STATUS_8812F BIT(6)
#define BIT_VOQ_ACM_STATUS_8812F BIT(5)
#define BIT_BEQ_ACM_EN_8812F BIT(3)
#define BIT_VIQ_ACM_EN_8812F BIT(2)
#define BIT_VOQ_ACM_EN_8812F BIT(1)
#define BIT_ACMHWEN_8812F BIT(0)

/* 2 REG_ACMRSTCTRL_8812F */
#define BIT_BE_ACM_RESET_USED_TIME_8812F BIT(2)
#define BIT_VI_ACM_RESET_USED_TIME_8812F BIT(1)
#define BIT_VO_ACM_RESET_USED_TIME_8812F BIT(0)

/* 2 REG_ACMAVG_8812F */

#define BIT_SHIFT_AVGPERIOD_8812F 0
#define BIT_MASK_AVGPERIOD_8812F 0xffff
#define BIT_AVGPERIOD_8812F(x)                                                 \
	(((x) & BIT_MASK_AVGPERIOD_8812F) << BIT_SHIFT_AVGPERIOD_8812F)
#define BITS_AVGPERIOD_8812F                                                   \
	(BIT_MASK_AVGPERIOD_8812F << BIT_SHIFT_AVGPERIOD_8812F)
#define BIT_CLEAR_AVGPERIOD_8812F(x) ((x) & (~BITS_AVGPERIOD_8812F))
#define BIT_GET_AVGPERIOD_8812F(x)                                             \
	(((x) >> BIT_SHIFT_AVGPERIOD_8812F) & BIT_MASK_AVGPERIOD_8812F)
#define BIT_SET_AVGPERIOD_8812F(x, v)                                          \
	(BIT_CLEAR_AVGPERIOD_8812F(x) | BIT_AVGPERIOD_8812F(v))

/* 2 REG_VO_ADMTIME_8812F */

#define BIT_SHIFT_VO_ADMITTED_TIME_8812F 0
#define BIT_MASK_VO_ADMITTED_TIME_8812F 0xffff
#define BIT_VO_ADMITTED_TIME_8812F(x)                                          \
	(((x) & BIT_MASK_VO_ADMITTED_TIME_8812F)                               \
	 << BIT_SHIFT_VO_ADMITTED_TIME_8812F)
#define BITS_VO_ADMITTED_TIME_8812F                                            \
	(BIT_MASK_VO_ADMITTED_TIME_8812F << BIT_SHIFT_VO_ADMITTED_TIME_8812F)
#define BIT_CLEAR_VO_ADMITTED_TIME_8812F(x)                                    \
	((x) & (~BITS_VO_ADMITTED_TIME_8812F))
#define BIT_GET_VO_ADMITTED_TIME_8812F(x)                                      \
	(((x) >> BIT_SHIFT_VO_ADMITTED_TIME_8812F) &                           \
	 BIT_MASK_VO_ADMITTED_TIME_8812F)
#define BIT_SET_VO_ADMITTED_TIME_8812F(x, v)                                   \
	(BIT_CLEAR_VO_ADMITTED_TIME_8812F(x) | BIT_VO_ADMITTED_TIME_8812F(v))

/* 2 REG_VI_ADMTIME_8812F */

#define BIT_SHIFT_VI_ADMITTED_TIME_8812F 0
#define BIT_MASK_VI_ADMITTED_TIME_8812F 0xffff
#define BIT_VI_ADMITTED_TIME_8812F(x)                                          \
	(((x) & BIT_MASK_VI_ADMITTED_TIME_8812F)                               \
	 << BIT_SHIFT_VI_ADMITTED_TIME_8812F)
#define BITS_VI_ADMITTED_TIME_8812F                                            \
	(BIT_MASK_VI_ADMITTED_TIME_8812F << BIT_SHIFT_VI_ADMITTED_TIME_8812F)
#define BIT_CLEAR_VI_ADMITTED_TIME_8812F(x)                                    \
	((x) & (~BITS_VI_ADMITTED_TIME_8812F))
#define BIT_GET_VI_ADMITTED_TIME_8812F(x)                                      \
	(((x) >> BIT_SHIFT_VI_ADMITTED_TIME_8812F) &                           \
	 BIT_MASK_VI_ADMITTED_TIME_8812F)
#define BIT_SET_VI_ADMITTED_TIME_8812F(x, v)                                   \
	(BIT_CLEAR_VI_ADMITTED_TIME_8812F(x) | BIT_VI_ADMITTED_TIME_8812F(v))

/* 2 REG_BE_ADMTIME_8812F */

#define BIT_SHIFT_BE_ADMITTED_TIME_8812F 0
#define BIT_MASK_BE_ADMITTED_TIME_8812F 0xffff
#define BIT_BE_ADMITTED_TIME_8812F(x)                                          \
	(((x) & BIT_MASK_BE_ADMITTED_TIME_8812F)                               \
	 << BIT_SHIFT_BE_ADMITTED_TIME_8812F)
#define BITS_BE_ADMITTED_TIME_8812F                                            \
	(BIT_MASK_BE_ADMITTED_TIME_8812F << BIT_SHIFT_BE_ADMITTED_TIME_8812F)
#define BIT_CLEAR_BE_ADMITTED_TIME_8812F(x)                                    \
	((x) & (~BITS_BE_ADMITTED_TIME_8812F))
#define BIT_GET_BE_ADMITTED_TIME_8812F(x)                                      \
	(((x) >> BIT_SHIFT_BE_ADMITTED_TIME_8812F) &                           \
	 BIT_MASK_BE_ADMITTED_TIME_8812F)
#define BIT_SET_BE_ADMITTED_TIME_8812F(x, v)                                   \
	(BIT_CLEAR_BE_ADMITTED_TIME_8812F(x) | BIT_BE_ADMITTED_TIME_8812F(v))

/* 2 REG_MAC_HEADER_NAV_OFFSET_8812F */

#define BIT_SHIFT_MAC_HEADER_NAV_OFFSET_8812F 0
#define BIT_MASK_MAC_HEADER_NAV_OFFSET_8812F 0xff
#define BIT_MAC_HEADER_NAV_OFFSET_8812F(x)                                     \
	(((x) & BIT_MASK_MAC_HEADER_NAV_OFFSET_8812F)                          \
	 << BIT_SHIFT_MAC_HEADER_NAV_OFFSET_8812F)
#define BITS_MAC_HEADER_NAV_OFFSET_8812F                                       \
	(BIT_MASK_MAC_HEADER_NAV_OFFSET_8812F                                  \
	 << BIT_SHIFT_MAC_HEADER_NAV_OFFSET_8812F)
#define BIT_CLEAR_MAC_HEADER_NAV_OFFSET_8812F(x)                               \
	((x) & (~BITS_MAC_HEADER_NAV_OFFSET_8812F))
#define BIT_GET_MAC_HEADER_NAV_OFFSET_8812F(x)                                 \
	(((x) >> BIT_SHIFT_MAC_HEADER_NAV_OFFSET_8812F) &                      \
	 BIT_MASK_MAC_HEADER_NAV_OFFSET_8812F)
#define BIT_SET_MAC_HEADER_NAV_OFFSET_8812F(x, v)                              \
	(BIT_CLEAR_MAC_HEADER_NAV_OFFSET_8812F(x) |                            \
	 BIT_MAC_HEADER_NAV_OFFSET_8812F(v))

/* 2 REG_DIS_NDPA_NAV_CHECK_8812F */
#define BIT_CHG_POWER_BCN_AREA_V1_8812F BIT(1)
#define BIT_DIS_NDPA_NAV_CHECK_8812F BIT(0)

/* 2 REG_EDCA_RANDOM_GEN_8812F */

#define BIT_SHIFT_RANDOM_GEN_8812F 0
#define BIT_MASK_RANDOM_GEN_8812F 0xffffff
#define BIT_RANDOM_GEN_8812F(x)                                                \
	(((x) & BIT_MASK_RANDOM_GEN_8812F) << BIT_SHIFT_RANDOM_GEN_8812F)
#define BITS_RANDOM_GEN_8812F                                                  \
	(BIT_MASK_RANDOM_GEN_8812F << BIT_SHIFT_RANDOM_GEN_8812F)
#define BIT_CLEAR_RANDOM_GEN_8812F(x) ((x) & (~BITS_RANDOM_GEN_8812F))
#define BIT_GET_RANDOM_GEN_8812F(x)                                            \
	(((x) >> BIT_SHIFT_RANDOM_GEN_8812F) & BIT_MASK_RANDOM_GEN_8812F)
#define BIT_SET_RANDOM_GEN_8812F(x, v)                                         \
	(BIT_CLEAR_RANDOM_GEN_8812F(x) | BIT_RANDOM_GEN_8812F(v))

/* 2 REG_TXCMD_NOA_SEL_8812F */

#define BIT_SHIFT_NOA_SEL_V2_8812F 4
#define BIT_MASK_NOA_SEL_V2_8812F 0x7
#define BIT_NOA_SEL_V2_8812F(x)                                                \
	(((x) & BIT_MASK_NOA_SEL_V2_8812F) << BIT_SHIFT_NOA_SEL_V2_8812F)
#define BITS_NOA_SEL_V2_8812F                                                  \
	(BIT_MASK_NOA_SEL_V2_8812F << BIT_SHIFT_NOA_SEL_V2_8812F)
#define BIT_CLEAR_NOA_SEL_V2_8812F(x) ((x) & (~BITS_NOA_SEL_V2_8812F))
#define BIT_GET_NOA_SEL_V2_8812F(x)                                            \
	(((x) >> BIT_SHIFT_NOA_SEL_V2_8812F) & BIT_MASK_NOA_SEL_V2_8812F)
#define BIT_SET_NOA_SEL_V2_8812F(x, v)                                         \
	(BIT_CLEAR_NOA_SEL_V2_8812F(x) | BIT_NOA_SEL_V2_8812F(v))

#define BIT_SHIFT_TXCMD_SEG_SEL_8812F 0
#define BIT_MASK_TXCMD_SEG_SEL_8812F 0xf
#define BIT_TXCMD_SEG_SEL_8812F(x)                                             \
	(((x) & BIT_MASK_TXCMD_SEG_SEL_8812F) << BIT_SHIFT_TXCMD_SEG_SEL_8812F)
#define BITS_TXCMD_SEG_SEL_8812F                                               \
	(BIT_MASK_TXCMD_SEG_SEL_8812F << BIT_SHIFT_TXCMD_SEG_SEL_8812F)
#define BIT_CLEAR_TXCMD_SEG_SEL_8812F(x) ((x) & (~BITS_TXCMD_SEG_SEL_8812F))
#define BIT_GET_TXCMD_SEG_SEL_8812F(x)                                         \
	(((x) >> BIT_SHIFT_TXCMD_SEG_SEL_8812F) & BIT_MASK_TXCMD_SEG_SEL_8812F)
#define BIT_SET_TXCMD_SEG_SEL_8812F(x, v)                                      \
	(BIT_CLEAR_TXCMD_SEG_SEL_8812F(x) | BIT_TXCMD_SEG_SEL_8812F(v))

/* 2 REG_32K_CLK_SEL_8812F */
#define BIT_R_BCNERR_CNT_EN_8812F BIT(20)

#define BIT_SHIFT_R_BCNERR_PORT_SEL_8812F 16
#define BIT_MASK_R_BCNERR_PORT_SEL_8812F 0x7
#define BIT_R_BCNERR_PORT_SEL_8812F(x)                                         \
	(((x) & BIT_MASK_R_BCNERR_PORT_SEL_8812F)                              \
	 << BIT_SHIFT_R_BCNERR_PORT_SEL_8812F)
#define BITS_R_BCNERR_PORT_SEL_8812F                                           \
	(BIT_MASK_R_BCNERR_PORT_SEL_8812F << BIT_SHIFT_R_BCNERR_PORT_SEL_8812F)
#define BIT_CLEAR_R_BCNERR_PORT_SEL_8812F(x)                                   \
	((x) & (~BITS_R_BCNERR_PORT_SEL_8812F))
#define BIT_GET_R_BCNERR_PORT_SEL_8812F(x)                                     \
	(((x) >> BIT_SHIFT_R_BCNERR_PORT_SEL_8812F) &                          \
	 BIT_MASK_R_BCNERR_PORT_SEL_8812F)
#define BIT_SET_R_BCNERR_PORT_SEL_8812F(x, v)                                  \
	(BIT_CLEAR_R_BCNERR_PORT_SEL_8812F(x) | BIT_R_BCNERR_PORT_SEL_8812F(v))

#define BIT_SHIFT_R_TXPAUSE1_8812F 8
#define BIT_MASK_R_TXPAUSE1_8812F 0xff
#define BIT_R_TXPAUSE1_8812F(x)                                                \
	(((x) & BIT_MASK_R_TXPAUSE1_8812F) << BIT_SHIFT_R_TXPAUSE1_8812F)
#define BITS_R_TXPAUSE1_8812F                                                  \
	(BIT_MASK_R_TXPAUSE1_8812F << BIT_SHIFT_R_TXPAUSE1_8812F)
#define BIT_CLEAR_R_TXPAUSE1_8812F(x) ((x) & (~BITS_R_TXPAUSE1_8812F))
#define BIT_GET_R_TXPAUSE1_8812F(x)                                            \
	(((x) >> BIT_SHIFT_R_TXPAUSE1_8812F) & BIT_MASK_R_TXPAUSE1_8812F)
#define BIT_SET_R_TXPAUSE1_8812F(x, v)                                         \
	(BIT_CLEAR_R_TXPAUSE1_8812F(x) | BIT_R_TXPAUSE1_8812F(v))

#define BIT_SLEEP_32K_EN_V1_8812F BIT(2)

#define BIT_SHIFT_BW_CFG_8812F 0
#define BIT_MASK_BW_CFG_8812F 0x3
#define BIT_BW_CFG_8812F(x)                                                    \
	(((x) & BIT_MASK_BW_CFG_8812F) << BIT_SHIFT_BW_CFG_8812F)
#define BITS_BW_CFG_8812F (BIT_MASK_BW_CFG_8812F << BIT_SHIFT_BW_CFG_8812F)
#define BIT_CLEAR_BW_CFG_8812F(x) ((x) & (~BITS_BW_CFG_8812F))
#define BIT_GET_BW_CFG_8812F(x)                                                \
	(((x) >> BIT_SHIFT_BW_CFG_8812F) & BIT_MASK_BW_CFG_8812F)
#define BIT_SET_BW_CFG_8812F(x, v)                                             \
	(BIT_CLEAR_BW_CFG_8812F(x) | BIT_BW_CFG_8812F(v))

/* 2 REG_EARLYINT_ADJUST_8812F */

#define BIT_SHIFT_RXBCN_TIMER_8812F 16
#define BIT_MASK_RXBCN_TIMER_8812F 0xffff
#define BIT_RXBCN_TIMER_8812F(x)                                               \
	(((x) & BIT_MASK_RXBCN_TIMER_8812F) << BIT_SHIFT_RXBCN_TIMER_8812F)
#define BITS_RXBCN_TIMER_8812F                                                 \
	(BIT_MASK_RXBCN_TIMER_8812F << BIT_SHIFT_RXBCN_TIMER_8812F)
#define BIT_CLEAR_RXBCN_TIMER_8812F(x) ((x) & (~BITS_RXBCN_TIMER_8812F))
#define BIT_GET_RXBCN_TIMER_8812F(x)                                           \
	(((x) >> BIT_SHIFT_RXBCN_TIMER_8812F) & BIT_MASK_RXBCN_TIMER_8812F)
#define BIT_SET_RXBCN_TIMER_8812F(x, v)                                        \
	(BIT_CLEAR_RXBCN_TIMER_8812F(x) | BIT_RXBCN_TIMER_8812F(v))

#define BIT_SHIFT_R_ERLYINTADJ_8812F 0
#define BIT_MASK_R_ERLYINTADJ_8812F 0xffff
#define BIT_R_ERLYINTADJ_8812F(x)                                              \
	(((x) & BIT_MASK_R_ERLYINTADJ_8812F) << BIT_SHIFT_R_ERLYINTADJ_8812F)
#define BITS_R_ERLYINTADJ_8812F                                                \
	(BIT_MASK_R_ERLYINTADJ_8812F << BIT_SHIFT_R_ERLYINTADJ_8812F)
#define BIT_CLEAR_R_ERLYINTADJ_8812F(x) ((x) & (~BITS_R_ERLYINTADJ_8812F))
#define BIT_GET_R_ERLYINTADJ_8812F(x)                                          \
	(((x) >> BIT_SHIFT_R_ERLYINTADJ_8812F) & BIT_MASK_R_ERLYINTADJ_8812F)
#define BIT_SET_R_ERLYINTADJ_8812F(x, v)                                       \
	(BIT_CLEAR_R_ERLYINTADJ_8812F(x) | BIT_R_ERLYINTADJ_8812F(v))

/* 2 REG_BCNERR_CNT_8812F */

#define BIT_SHIFT_BCNERR_CNT_OTHERS_8812F 24
#define BIT_MASK_BCNERR_CNT_OTHERS_8812F 0xff
#define BIT_BCNERR_CNT_OTHERS_8812F(x)                                         \
	(((x) & BIT_MASK_BCNERR_CNT_OTHERS_8812F)                              \
	 << BIT_SHIFT_BCNERR_CNT_OTHERS_8812F)
#define BITS_BCNERR_CNT_OTHERS_8812F                                           \
	(BIT_MASK_BCNERR_CNT_OTHERS_8812F << BIT_SHIFT_BCNERR_CNT_OTHERS_8812F)
#define BIT_CLEAR_BCNERR_CNT_OTHERS_8812F(x)                                   \
	((x) & (~BITS_BCNERR_CNT_OTHERS_8812F))
#define BIT_GET_BCNERR_CNT_OTHERS_8812F(x)                                     \
	(((x) >> BIT_SHIFT_BCNERR_CNT_OTHERS_8812F) &                          \
	 BIT_MASK_BCNERR_CNT_OTHERS_8812F)
#define BIT_SET_BCNERR_CNT_OTHERS_8812F(x, v)                                  \
	(BIT_CLEAR_BCNERR_CNT_OTHERS_8812F(x) | BIT_BCNERR_CNT_OTHERS_8812F(v))

#define BIT_SHIFT_BCNERR_CNT_INVALID_8812F 16
#define BIT_MASK_BCNERR_CNT_INVALID_8812F 0xff
#define BIT_BCNERR_CNT_INVALID_8812F(x)                                        \
	(((x) & BIT_MASK_BCNERR_CNT_INVALID_8812F)                             \
	 << BIT_SHIFT_BCNERR_CNT_INVALID_8812F)
#define BITS_BCNERR_CNT_INVALID_8812F                                          \
	(BIT_MASK_BCNERR_CNT_INVALID_8812F                                     \
	 << BIT_SHIFT_BCNERR_CNT_INVALID_8812F)
#define BIT_CLEAR_BCNERR_CNT_INVALID_8812F(x)                                  \
	((x) & (~BITS_BCNERR_CNT_INVALID_8812F))
#define BIT_GET_BCNERR_CNT_INVALID_8812F(x)                                    \
	(((x) >> BIT_SHIFT_BCNERR_CNT_INVALID_8812F) &                         \
	 BIT_MASK_BCNERR_CNT_INVALID_8812F)
#define BIT_SET_BCNERR_CNT_INVALID_8812F(x, v)                                 \
	(BIT_CLEAR_BCNERR_CNT_INVALID_8812F(x) |                               \
	 BIT_BCNERR_CNT_INVALID_8812F(v))

#define BIT_SHIFT_BCNERR_CNT_MAC_8812F 8
#define BIT_MASK_BCNERR_CNT_MAC_8812F 0xff
#define BIT_BCNERR_CNT_MAC_8812F(x)                                            \
	(((x) & BIT_MASK_BCNERR_CNT_MAC_8812F)                                 \
	 << BIT_SHIFT_BCNERR_CNT_MAC_8812F)
#define BITS_BCNERR_CNT_MAC_8812F                                              \
	(BIT_MASK_BCNERR_CNT_MAC_8812F << BIT_SHIFT_BCNERR_CNT_MAC_8812F)
#define BIT_CLEAR_BCNERR_CNT_MAC_8812F(x) ((x) & (~BITS_BCNERR_CNT_MAC_8812F))
#define BIT_GET_BCNERR_CNT_MAC_8812F(x)                                        \
	(((x) >> BIT_SHIFT_BCNERR_CNT_MAC_8812F) &                             \
	 BIT_MASK_BCNERR_CNT_MAC_8812F)
#define BIT_SET_BCNERR_CNT_MAC_8812F(x, v)                                     \
	(BIT_CLEAR_BCNERR_CNT_MAC_8812F(x) | BIT_BCNERR_CNT_MAC_8812F(v))

#define BIT_SHIFT_BCNERR_CNT_CCA_8812F 0
#define BIT_MASK_BCNERR_CNT_CCA_8812F 0xff
#define BIT_BCNERR_CNT_CCA_8812F(x)                                            \
	(((x) & BIT_MASK_BCNERR_CNT_CCA_8812F)                                 \
	 << BIT_SHIFT_BCNERR_CNT_CCA_8812F)
#define BITS_BCNERR_CNT_CCA_8812F                                              \
	(BIT_MASK_BCNERR_CNT_CCA_8812F << BIT_SHIFT_BCNERR_CNT_CCA_8812F)
#define BIT_CLEAR_BCNERR_CNT_CCA_8812F(x) ((x) & (~BITS_BCNERR_CNT_CCA_8812F))
#define BIT_GET_BCNERR_CNT_CCA_8812F(x)                                        \
	(((x) >> BIT_SHIFT_BCNERR_CNT_CCA_8812F) &                             \
	 BIT_MASK_BCNERR_CNT_CCA_8812F)
#define BIT_SET_BCNERR_CNT_CCA_8812F(x, v)                                     \
	(BIT_CLEAR_BCNERR_CNT_CCA_8812F(x) | BIT_BCNERR_CNT_CCA_8812F(v))

/* 2 REG_BCNERR_CNT_2_8812F */

#define BIT_SHIFT_BCNERR_CNT_EDCCA_8812F 0
#define BIT_MASK_BCNERR_CNT_EDCCA_8812F 0xff
#define BIT_BCNERR_CNT_EDCCA_8812F(x)                                          \
	(((x) & BIT_MASK_BCNERR_CNT_EDCCA_8812F)                               \
	 << BIT_SHIFT_BCNERR_CNT_EDCCA_8812F)
#define BITS_BCNERR_CNT_EDCCA_8812F                                            \
	(BIT_MASK_BCNERR_CNT_EDCCA_8812F << BIT_SHIFT_BCNERR_CNT_EDCCA_8812F)
#define BIT_CLEAR_BCNERR_CNT_EDCCA_8812F(x)                                    \
	((x) & (~BITS_BCNERR_CNT_EDCCA_8812F))
#define BIT_GET_BCNERR_CNT_EDCCA_8812F(x)                                      \
	(((x) >> BIT_SHIFT_BCNERR_CNT_EDCCA_8812F) &                           \
	 BIT_MASK_BCNERR_CNT_EDCCA_8812F)
#define BIT_SET_BCNERR_CNT_EDCCA_8812F(x, v)                                   \
	(BIT_CLEAR_BCNERR_CNT_EDCCA_8812F(x) | BIT_BCNERR_CNT_EDCCA_8812F(v))

/* 2 REG_NOA_PARAM_8812F */

#define BIT_SHIFT_NOA_DURATION_V1_8812F 0
#define BIT_MASK_NOA_DURATION_V1_8812F 0xffffffffL
#define BIT_NOA_DURATION_V1_8812F(x)                                           \
	(((x) & BIT_MASK_NOA_DURATION_V1_8812F)                                \
	 << BIT_SHIFT_NOA_DURATION_V1_8812F)
#define BITS_NOA_DURATION_V1_8812F                                             \
	(BIT_MASK_NOA_DURATION_V1_8812F << BIT_SHIFT_NOA_DURATION_V1_8812F)
#define BIT_CLEAR_NOA_DURATION_V1_8812F(x) ((x) & (~BITS_NOA_DURATION_V1_8812F))
#define BIT_GET_NOA_DURATION_V1_8812F(x)                                       \
	(((x) >> BIT_SHIFT_NOA_DURATION_V1_8812F) &                            \
	 BIT_MASK_NOA_DURATION_V1_8812F)
#define BIT_SET_NOA_DURATION_V1_8812F(x, v)                                    \
	(BIT_CLEAR_NOA_DURATION_V1_8812F(x) | BIT_NOA_DURATION_V1_8812F(v))

/* 2 REG_NOA_PARAM_1_8812F */

#define BIT_SHIFT_NOA_INTERVAL_V1_8812F 0
#define BIT_MASK_NOA_INTERVAL_V1_8812F 0xffffffffL
#define BIT_NOA_INTERVAL_V1_8812F(x)                                           \
	(((x) & BIT_MASK_NOA_INTERVAL_V1_8812F)                                \
	 << BIT_SHIFT_NOA_INTERVAL_V1_8812F)
#define BITS_NOA_INTERVAL_V1_8812F                                             \
	(BIT_MASK_NOA_INTERVAL_V1_8812F << BIT_SHIFT_NOA_INTERVAL_V1_8812F)
#define BIT_CLEAR_NOA_INTERVAL_V1_8812F(x) ((x) & (~BITS_NOA_INTERVAL_V1_8812F))
#define BIT_GET_NOA_INTERVAL_V1_8812F(x)                                       \
	(((x) >> BIT_SHIFT_NOA_INTERVAL_V1_8812F) &                            \
	 BIT_MASK_NOA_INTERVAL_V1_8812F)
#define BIT_SET_NOA_INTERVAL_V1_8812F(x, v)                                    \
	(BIT_CLEAR_NOA_INTERVAL_V1_8812F(x) | BIT_NOA_INTERVAL_V1_8812F(v))

/* 2 REG_NOA_PARAM_2_8812F */

#define BIT_SHIFT_NOA_START_TIME_V1_8812F 0
#define BIT_MASK_NOA_START_TIME_V1_8812F 0xffffffffL
#define BIT_NOA_START_TIME_V1_8812F(x)                                         \
	(((x) & BIT_MASK_NOA_START_TIME_V1_8812F)                              \
	 << BIT_SHIFT_NOA_START_TIME_V1_8812F)
#define BITS_NOA_START_TIME_V1_8812F                                           \
	(BIT_MASK_NOA_START_TIME_V1_8812F << BIT_SHIFT_NOA_START_TIME_V1_8812F)
#define BIT_CLEAR_NOA_START_TIME_V1_8812F(x)                                   \
	((x) & (~BITS_NOA_START_TIME_V1_8812F))
#define BIT_GET_NOA_START_TIME_V1_8812F(x)                                     \
	(((x) >> BIT_SHIFT_NOA_START_TIME_V1_8812F) &                          \
	 BIT_MASK_NOA_START_TIME_V1_8812F)
#define BIT_SET_NOA_START_TIME_V1_8812F(x, v)                                  \
	(BIT_CLEAR_NOA_START_TIME_V1_8812F(x) | BIT_NOA_START_TIME_V1_8812F(v))

/* 2 REG_NOA_PARAM_3_8812F */

#define BIT_SHIFT_NOA_COUNT_V1_8812F 0
#define BIT_MASK_NOA_COUNT_V1_8812F 0xffffffffL
#define BIT_NOA_COUNT_V1_8812F(x)                                              \
	(((x) & BIT_MASK_NOA_COUNT_V1_8812F) << BIT_SHIFT_NOA_COUNT_V1_8812F)
#define BITS_NOA_COUNT_V1_8812F                                                \
	(BIT_MASK_NOA_COUNT_V1_8812F << BIT_SHIFT_NOA_COUNT_V1_8812F)
#define BIT_CLEAR_NOA_COUNT_V1_8812F(x) ((x) & (~BITS_NOA_COUNT_V1_8812F))
#define BIT_GET_NOA_COUNT_V1_8812F(x)                                          \
	(((x) >> BIT_SHIFT_NOA_COUNT_V1_8812F) & BIT_MASK_NOA_COUNT_V1_8812F)
#define BIT_SET_NOA_COUNT_V1_8812F(x, v)                                       \
	(BIT_CLEAR_NOA_COUNT_V1_8812F(x) | BIT_NOA_COUNT_V1_8812F(v))

/* 2 REG_P2P_RST_8812F */
#define BIT_P2P2_PWR_RST1_8812F BIT(5)
#define BIT_P2P2_PWR_RST0_8812F BIT(4)
#define BIT_P2P1_PWR_RST1_8812F BIT(3)
#define BIT_P2P1_PWR_RST0_8812F BIT(2)
#define BIT_P2P_PWR_RST1_V1_8812F BIT(1)
#define BIT_P2P_PWR_RST0_V1_8812F BIT(0)

/* 2 REG_SCHEDULER_RST_8812F */
#define BIT_SYNC_CLI_ONCE_RIGHT_NOW_8812F BIT(2)
#define BIT_SYNC_CLI_ONCE_BY_TBTT_8812F BIT(1)
#define BIT_SCHEDULER_RST_V1_8812F BIT(0)

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_SCH_DBG_VALUE_8812F */

#define BIT_SHIFT_SCH_DBG_VALUE_8812F 0
#define BIT_MASK_SCH_DBG_VALUE_8812F 0xffffffffL
#define BIT_SCH_DBG_VALUE_8812F(x)                                             \
	(((x) & BIT_MASK_SCH_DBG_VALUE_8812F) << BIT_SHIFT_SCH_DBG_VALUE_8812F)
#define BITS_SCH_DBG_VALUE_8812F                                               \
	(BIT_MASK_SCH_DBG_VALUE_8812F << BIT_SHIFT_SCH_DBG_VALUE_8812F)
#define BIT_CLEAR_SCH_DBG_VALUE_8812F(x) ((x) & (~BITS_SCH_DBG_VALUE_8812F))
#define BIT_GET_SCH_DBG_VALUE_8812F(x)                                         \
	(((x) >> BIT_SHIFT_SCH_DBG_VALUE_8812F) & BIT_MASK_SCH_DBG_VALUE_8812F)
#define BIT_SET_SCH_DBG_VALUE_8812F(x, v)                                      \
	(BIT_CLEAR_SCH_DBG_VALUE_8812F(x) | BIT_SCH_DBG_VALUE_8812F(v))

/* 2 REG_SCH_TXCMD_8812F */

#define BIT_SHIFT_SCH_TXCMD_8812F 0
#define BIT_MASK_SCH_TXCMD_8812F 0xffffffffL
#define BIT_SCH_TXCMD_8812F(x)                                                 \
	(((x) & BIT_MASK_SCH_TXCMD_8812F) << BIT_SHIFT_SCH_TXCMD_8812F)
#define BITS_SCH_TXCMD_8812F                                                   \
	(BIT_MASK_SCH_TXCMD_8812F << BIT_SHIFT_SCH_TXCMD_8812F)
#define BIT_CLEAR_SCH_TXCMD_8812F(x) ((x) & (~BITS_SCH_TXCMD_8812F))
#define BIT_GET_SCH_TXCMD_8812F(x)                                             \
	(((x) >> BIT_SHIFT_SCH_TXCMD_8812F) & BIT_MASK_SCH_TXCMD_8812F)
#define BIT_SET_SCH_TXCMD_8812F(x, v)                                          \
	(BIT_CLEAR_SCH_TXCMD_8812F(x) | BIT_SCH_TXCMD_8812F(v))

/* 2 REG_PAGE5_DUMMY_8812F */

/* 2 REG_CPUMGQ_TX_TIMER_8812F */

#define BIT_SHIFT_CPUMGQ_TX_TIMER_V1_8812F 0
#define BIT_MASK_CPUMGQ_TX_TIMER_V1_8812F 0xffffffffL
#define BIT_CPUMGQ_TX_TIMER_V1_8812F(x)                                        \
	(((x) & BIT_MASK_CPUMGQ_TX_TIMER_V1_8812F)                             \
	 << BIT_SHIFT_CPUMGQ_TX_TIMER_V1_8812F)
#define BITS_CPUMGQ_TX_TIMER_V1_8812F                                          \
	(BIT_MASK_CPUMGQ_TX_TIMER_V1_8812F                                     \
	 << BIT_SHIFT_CPUMGQ_TX_TIMER_V1_8812F)
#define BIT_CLEAR_CPUMGQ_TX_TIMER_V1_8812F(x)                                  \
	((x) & (~BITS_CPUMGQ_TX_TIMER_V1_8812F))
#define BIT_GET_CPUMGQ_TX_TIMER_V1_8812F(x)                                    \
	(((x) >> BIT_SHIFT_CPUMGQ_TX_TIMER_V1_8812F) &                         \
	 BIT_MASK_CPUMGQ_TX_TIMER_V1_8812F)
#define BIT_SET_CPUMGQ_TX_TIMER_V1_8812F(x, v)                                 \
	(BIT_CLEAR_CPUMGQ_TX_TIMER_V1_8812F(x) |                               \
	 BIT_CPUMGQ_TX_TIMER_V1_8812F(v))

/* 2 REG_PS_TIMER_A_8812F */

#define BIT_SHIFT_PS_TIMER_A_V1_8812F 0
#define BIT_MASK_PS_TIMER_A_V1_8812F 0xffffffffL
#define BIT_PS_TIMER_A_V1_8812F(x)                                             \
	(((x) & BIT_MASK_PS_TIMER_A_V1_8812F) << BIT_SHIFT_PS_TIMER_A_V1_8812F)
#define BITS_PS_TIMER_A_V1_8812F                                               \
	(BIT_MASK_PS_TIMER_A_V1_8812F << BIT_SHIFT_PS_TIMER_A_V1_8812F)
#define BIT_CLEAR_PS_TIMER_A_V1_8812F(x) ((x) & (~BITS_PS_TIMER_A_V1_8812F))
#define BIT_GET_PS_TIMER_A_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_PS_TIMER_A_V1_8812F) & BIT_MASK_PS_TIMER_A_V1_8812F)
#define BIT_SET_PS_TIMER_A_V1_8812F(x, v)                                      \
	(BIT_CLEAR_PS_TIMER_A_V1_8812F(x) | BIT_PS_TIMER_A_V1_8812F(v))

/* 2 REG_PS_TIMER_B_8812F */

#define BIT_SHIFT_PS_TIMER_B_V1_8812F 0
#define BIT_MASK_PS_TIMER_B_V1_8812F 0xffffffffL
#define BIT_PS_TIMER_B_V1_8812F(x)                                             \
	(((x) & BIT_MASK_PS_TIMER_B_V1_8812F) << BIT_SHIFT_PS_TIMER_B_V1_8812F)
#define BITS_PS_TIMER_B_V1_8812F                                               \
	(BIT_MASK_PS_TIMER_B_V1_8812F << BIT_SHIFT_PS_TIMER_B_V1_8812F)
#define BIT_CLEAR_PS_TIMER_B_V1_8812F(x) ((x) & (~BITS_PS_TIMER_B_V1_8812F))
#define BIT_GET_PS_TIMER_B_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_PS_TIMER_B_V1_8812F) & BIT_MASK_PS_TIMER_B_V1_8812F)
#define BIT_SET_PS_TIMER_B_V1_8812F(x, v)                                      \
	(BIT_CLEAR_PS_TIMER_B_V1_8812F(x) | BIT_PS_TIMER_B_V1_8812F(v))

/* 2 REG_PS_TIMER_C_8812F */

#define BIT_SHIFT_PS_TIMER_C_V1_8812F 0
#define BIT_MASK_PS_TIMER_C_V1_8812F 0xffffffffL
#define BIT_PS_TIMER_C_V1_8812F(x)                                             \
	(((x) & BIT_MASK_PS_TIMER_C_V1_8812F) << BIT_SHIFT_PS_TIMER_C_V1_8812F)
#define BITS_PS_TIMER_C_V1_8812F                                               \
	(BIT_MASK_PS_TIMER_C_V1_8812F << BIT_SHIFT_PS_TIMER_C_V1_8812F)
#define BIT_CLEAR_PS_TIMER_C_V1_8812F(x) ((x) & (~BITS_PS_TIMER_C_V1_8812F))
#define BIT_GET_PS_TIMER_C_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_PS_TIMER_C_V1_8812F) & BIT_MASK_PS_TIMER_C_V1_8812F)
#define BIT_SET_PS_TIMER_C_V1_8812F(x, v)                                      \
	(BIT_CLEAR_PS_TIMER_C_V1_8812F(x) | BIT_PS_TIMER_C_V1_8812F(v))

/* 2 REG_PS_TIMER_ABC_CPUMGQ_TIMER_CRTL_8812F */
#define BIT_CPUMGQ_TIMER_EN_8812F BIT(31)
#define BIT_CPUMGQ_TX_EN_8812F BIT(28)

#define BIT_SHIFT_CPUMGQ_TIMER_TSF_SEL_8812F 24
#define BIT_MASK_CPUMGQ_TIMER_TSF_SEL_8812F 0x7
#define BIT_CPUMGQ_TIMER_TSF_SEL_8812F(x)                                      \
	(((x) & BIT_MASK_CPUMGQ_TIMER_TSF_SEL_8812F)                           \
	 << BIT_SHIFT_CPUMGQ_TIMER_TSF_SEL_8812F)
#define BITS_CPUMGQ_TIMER_TSF_SEL_8812F                                        \
	(BIT_MASK_CPUMGQ_TIMER_TSF_SEL_8812F                                   \
	 << BIT_SHIFT_CPUMGQ_TIMER_TSF_SEL_8812F)
#define BIT_CLEAR_CPUMGQ_TIMER_TSF_SEL_8812F(x)                                \
	((x) & (~BITS_CPUMGQ_TIMER_TSF_SEL_8812F))
#define BIT_GET_CPUMGQ_TIMER_TSF_SEL_8812F(x)                                  \
	(((x) >> BIT_SHIFT_CPUMGQ_TIMER_TSF_SEL_8812F) &                       \
	 BIT_MASK_CPUMGQ_TIMER_TSF_SEL_8812F)
#define BIT_SET_CPUMGQ_TIMER_TSF_SEL_8812F(x, v)                               \
	(BIT_CLEAR_CPUMGQ_TIMER_TSF_SEL_8812F(x) |                             \
	 BIT_CPUMGQ_TIMER_TSF_SEL_8812F(v))

#define BIT_PS_TIMER_C_EN_8812F BIT(23)

#define BIT_SHIFT_PS_TIMER_C_TSF_SEL_8812F 16
#define BIT_MASK_PS_TIMER_C_TSF_SEL_8812F 0x7
#define BIT_PS_TIMER_C_TSF_SEL_8812F(x)                                        \
	(((x) & BIT_MASK_PS_TIMER_C_TSF_SEL_8812F)                             \
	 << BIT_SHIFT_PS_TIMER_C_TSF_SEL_8812F)
#define BITS_PS_TIMER_C_TSF_SEL_8812F                                          \
	(BIT_MASK_PS_TIMER_C_TSF_SEL_8812F                                     \
	 << BIT_SHIFT_PS_TIMER_C_TSF_SEL_8812F)
#define BIT_CLEAR_PS_TIMER_C_TSF_SEL_8812F(x)                                  \
	((x) & (~BITS_PS_TIMER_C_TSF_SEL_8812F))
#define BIT_GET_PS_TIMER_C_TSF_SEL_8812F(x)                                    \
	(((x) >> BIT_SHIFT_PS_TIMER_C_TSF_SEL_8812F) &                         \
	 BIT_MASK_PS_TIMER_C_TSF_SEL_8812F)
#define BIT_SET_PS_TIMER_C_TSF_SEL_8812F(x, v)                                 \
	(BIT_CLEAR_PS_TIMER_C_TSF_SEL_8812F(x) |                               \
	 BIT_PS_TIMER_C_TSF_SEL_8812F(v))

#define BIT_PS_TIMER_B_EN_8812F BIT(15)

#define BIT_SHIFT_PS_TIMER_B_TSF_SEL_8812F 8
#define BIT_MASK_PS_TIMER_B_TSF_SEL_8812F 0x7
#define BIT_PS_TIMER_B_TSF_SEL_8812F(x)                                        \
	(((x) & BIT_MASK_PS_TIMER_B_TSF_SEL_8812F)                             \
	 << BIT_SHIFT_PS_TIMER_B_TSF_SEL_8812F)
#define BITS_PS_TIMER_B_TSF_SEL_8812F                                          \
	(BIT_MASK_PS_TIMER_B_TSF_SEL_8812F                                     \
	 << BIT_SHIFT_PS_TIMER_B_TSF_SEL_8812F)
#define BIT_CLEAR_PS_TIMER_B_TSF_SEL_8812F(x)                                  \
	((x) & (~BITS_PS_TIMER_B_TSF_SEL_8812F))
#define BIT_GET_PS_TIMER_B_TSF_SEL_8812F(x)                                    \
	(((x) >> BIT_SHIFT_PS_TIMER_B_TSF_SEL_8812F) &                         \
	 BIT_MASK_PS_TIMER_B_TSF_SEL_8812F)
#define BIT_SET_PS_TIMER_B_TSF_SEL_8812F(x, v)                                 \
	(BIT_CLEAR_PS_TIMER_B_TSF_SEL_8812F(x) |                               \
	 BIT_PS_TIMER_B_TSF_SEL_8812F(v))

#define BIT_PS_TIMER_A_EN_8812F BIT(7)

#define BIT_SHIFT_PS_TIMER_A_TSF_SEL_8812F 0
#define BIT_MASK_PS_TIMER_A_TSF_SEL_8812F 0x7
#define BIT_PS_TIMER_A_TSF_SEL_8812F(x)                                        \
	(((x) & BIT_MASK_PS_TIMER_A_TSF_SEL_8812F)                             \
	 << BIT_SHIFT_PS_TIMER_A_TSF_SEL_8812F)
#define BITS_PS_TIMER_A_TSF_SEL_8812F                                          \
	(BIT_MASK_PS_TIMER_A_TSF_SEL_8812F                                     \
	 << BIT_SHIFT_PS_TIMER_A_TSF_SEL_8812F)
#define BIT_CLEAR_PS_TIMER_A_TSF_SEL_8812F(x)                                  \
	((x) & (~BITS_PS_TIMER_A_TSF_SEL_8812F))
#define BIT_GET_PS_TIMER_A_TSF_SEL_8812F(x)                                    \
	(((x) >> BIT_SHIFT_PS_TIMER_A_TSF_SEL_8812F) &                         \
	 BIT_MASK_PS_TIMER_A_TSF_SEL_8812F)
#define BIT_SET_PS_TIMER_A_TSF_SEL_8812F(x, v)                                 \
	(BIT_CLEAR_PS_TIMER_A_TSF_SEL_8812F(x) |                               \
	 BIT_PS_TIMER_A_TSF_SEL_8812F(v))

/* 2 REG_CPUMGQ_TX_TIMER_EARLY_8812F */

#define BIT_SHIFT_CPUMGQ_TX_TIMER_EARLY_8812F 0
#define BIT_MASK_CPUMGQ_TX_TIMER_EARLY_8812F 0xff
#define BIT_CPUMGQ_TX_TIMER_EARLY_8812F(x)                                     \
	(((x) & BIT_MASK_CPUMGQ_TX_TIMER_EARLY_8812F)                          \
	 << BIT_SHIFT_CPUMGQ_TX_TIMER_EARLY_8812F)
#define BITS_CPUMGQ_TX_TIMER_EARLY_8812F                                       \
	(BIT_MASK_CPUMGQ_TX_TIMER_EARLY_8812F                                  \
	 << BIT_SHIFT_CPUMGQ_TX_TIMER_EARLY_8812F)
#define BIT_CLEAR_CPUMGQ_TX_TIMER_EARLY_8812F(x)                               \
	((x) & (~BITS_CPUMGQ_TX_TIMER_EARLY_8812F))
#define BIT_GET_CPUMGQ_TX_TIMER_EARLY_8812F(x)                                 \
	(((x) >> BIT_SHIFT_CPUMGQ_TX_TIMER_EARLY_8812F) &                      \
	 BIT_MASK_CPUMGQ_TX_TIMER_EARLY_8812F)
#define BIT_SET_CPUMGQ_TX_TIMER_EARLY_8812F(x, v)                              \
	(BIT_CLEAR_CPUMGQ_TX_TIMER_EARLY_8812F(x) |                            \
	 BIT_CPUMGQ_TX_TIMER_EARLY_8812F(v))

/* 2 REG_PS_TIMER_A_EARLY_8812F */

#define BIT_SHIFT_PS_TIMER_A_EARLY_8812F 0
#define BIT_MASK_PS_TIMER_A_EARLY_8812F 0xff
#define BIT_PS_TIMER_A_EARLY_8812F(x)                                          \
	(((x) & BIT_MASK_PS_TIMER_A_EARLY_8812F)                               \
	 << BIT_SHIFT_PS_TIMER_A_EARLY_8812F)
#define BITS_PS_TIMER_A_EARLY_8812F                                            \
	(BIT_MASK_PS_TIMER_A_EARLY_8812F << BIT_SHIFT_PS_TIMER_A_EARLY_8812F)
#define BIT_CLEAR_PS_TIMER_A_EARLY_8812F(x)                                    \
	((x) & (~BITS_PS_TIMER_A_EARLY_8812F))
#define BIT_GET_PS_TIMER_A_EARLY_8812F(x)                                      \
	(((x) >> BIT_SHIFT_PS_TIMER_A_EARLY_8812F) &                           \
	 BIT_MASK_PS_TIMER_A_EARLY_8812F)
#define BIT_SET_PS_TIMER_A_EARLY_8812F(x, v)                                   \
	(BIT_CLEAR_PS_TIMER_A_EARLY_8812F(x) | BIT_PS_TIMER_A_EARLY_8812F(v))

/* 2 REG_PS_TIMER_B_EARLY_8812F */

#define BIT_SHIFT_PS_TIMER_B_EARLY_8812F 0
#define BIT_MASK_PS_TIMER_B_EARLY_8812F 0xff
#define BIT_PS_TIMER_B_EARLY_8812F(x)                                          \
	(((x) & BIT_MASK_PS_TIMER_B_EARLY_8812F)                               \
	 << BIT_SHIFT_PS_TIMER_B_EARLY_8812F)
#define BITS_PS_TIMER_B_EARLY_8812F                                            \
	(BIT_MASK_PS_TIMER_B_EARLY_8812F << BIT_SHIFT_PS_TIMER_B_EARLY_8812F)
#define BIT_CLEAR_PS_TIMER_B_EARLY_8812F(x)                                    \
	((x) & (~BITS_PS_TIMER_B_EARLY_8812F))
#define BIT_GET_PS_TIMER_B_EARLY_8812F(x)                                      \
	(((x) >> BIT_SHIFT_PS_TIMER_B_EARLY_8812F) &                           \
	 BIT_MASK_PS_TIMER_B_EARLY_8812F)
#define BIT_SET_PS_TIMER_B_EARLY_8812F(x, v)                                   \
	(BIT_CLEAR_PS_TIMER_B_EARLY_8812F(x) | BIT_PS_TIMER_B_EARLY_8812F(v))

/* 2 REG_PS_TIMER_C_EARLY_8812F */

#define BIT_SHIFT_PS_TIMER_C_EARLY_8812F 0
#define BIT_MASK_PS_TIMER_C_EARLY_8812F 0xff
#define BIT_PS_TIMER_C_EARLY_8812F(x)                                          \
	(((x) & BIT_MASK_PS_TIMER_C_EARLY_8812F)                               \
	 << BIT_SHIFT_PS_TIMER_C_EARLY_8812F)
#define BITS_PS_TIMER_C_EARLY_8812F                                            \
	(BIT_MASK_PS_TIMER_C_EARLY_8812F << BIT_SHIFT_PS_TIMER_C_EARLY_8812F)
#define BIT_CLEAR_PS_TIMER_C_EARLY_8812F(x)                                    \
	((x) & (~BITS_PS_TIMER_C_EARLY_8812F))
#define BIT_GET_PS_TIMER_C_EARLY_8812F(x)                                      \
	(((x) >> BIT_SHIFT_PS_TIMER_C_EARLY_8812F) &                           \
	 BIT_MASK_PS_TIMER_C_EARLY_8812F)
#define BIT_SET_PS_TIMER_C_EARLY_8812F(x, v)                                   \
	(BIT_CLEAR_PS_TIMER_C_EARLY_8812F(x) | BIT_PS_TIMER_C_EARLY_8812F(v))

/* 2 REG_CPUMGQ_PARAMETER_8812F */

/* 2 REG_NOT_VALID_8812F */
#define BIT_MAC_STOP_CPUMGQ_8812F BIT(16)

#define BIT_SHIFT_CW_8812F 8
#define BIT_MASK_CW_8812F 0xff
#define BIT_CW_8812F(x) (((x) & BIT_MASK_CW_8812F) << BIT_SHIFT_CW_8812F)
#define BITS_CW_8812F (BIT_MASK_CW_8812F << BIT_SHIFT_CW_8812F)
#define BIT_CLEAR_CW_8812F(x) ((x) & (~BITS_CW_8812F))
#define BIT_GET_CW_8812F(x) (((x) >> BIT_SHIFT_CW_8812F) & BIT_MASK_CW_8812F)
#define BIT_SET_CW_8812F(x, v) (BIT_CLEAR_CW_8812F(x) | BIT_CW_8812F(v))

#define BIT_SHIFT_AIFS_8812F 0
#define BIT_MASK_AIFS_8812F 0xff
#define BIT_AIFS_8812F(x) (((x) & BIT_MASK_AIFS_8812F) << BIT_SHIFT_AIFS_8812F)
#define BITS_AIFS_8812F (BIT_MASK_AIFS_8812F << BIT_SHIFT_AIFS_8812F)
#define BIT_CLEAR_AIFS_8812F(x) ((x) & (~BITS_AIFS_8812F))
#define BIT_GET_AIFS_8812F(x)                                                  \
	(((x) >> BIT_SHIFT_AIFS_8812F) & BIT_MASK_AIFS_8812F)
#define BIT_SET_AIFS_8812F(x, v) (BIT_CLEAR_AIFS_8812F(x) | BIT_AIFS_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_TSF_SYNC_ADJ_8812F */

#define BIT_SHIFT_R_P0_TSFT_ADJ_VAL_8812F 16
#define BIT_MASK_R_P0_TSFT_ADJ_VAL_8812F 0xffff
#define BIT_R_P0_TSFT_ADJ_VAL_8812F(x)                                         \
	(((x) & BIT_MASK_R_P0_TSFT_ADJ_VAL_8812F)                              \
	 << BIT_SHIFT_R_P0_TSFT_ADJ_VAL_8812F)
#define BITS_R_P0_TSFT_ADJ_VAL_8812F                                           \
	(BIT_MASK_R_P0_TSFT_ADJ_VAL_8812F << BIT_SHIFT_R_P0_TSFT_ADJ_VAL_8812F)
#define BIT_CLEAR_R_P0_TSFT_ADJ_VAL_8812F(x)                                   \
	((x) & (~BITS_R_P0_TSFT_ADJ_VAL_8812F))
#define BIT_GET_R_P0_TSFT_ADJ_VAL_8812F(x)                                     \
	(((x) >> BIT_SHIFT_R_P0_TSFT_ADJ_VAL_8812F) &                          \
	 BIT_MASK_R_P0_TSFT_ADJ_VAL_8812F)
#define BIT_SET_R_P0_TSFT_ADJ_VAL_8812F(x, v)                                  \
	(BIT_CLEAR_R_P0_TSFT_ADJ_VAL_8812F(x) | BIT_R_P0_TSFT_ADJ_VAL_8812F(v))

#define BIT_R_X_COMP_Y_OVER_8812F BIT(8)

#define BIT_SHIFT_R_X_SYNC_SEL_8812F 3
#define BIT_MASK_R_X_SYNC_SEL_8812F 0x7
#define BIT_R_X_SYNC_SEL_8812F(x)                                              \
	(((x) & BIT_MASK_R_X_SYNC_SEL_8812F) << BIT_SHIFT_R_X_SYNC_SEL_8812F)
#define BITS_R_X_SYNC_SEL_8812F                                                \
	(BIT_MASK_R_X_SYNC_SEL_8812F << BIT_SHIFT_R_X_SYNC_SEL_8812F)
#define BIT_CLEAR_R_X_SYNC_SEL_8812F(x) ((x) & (~BITS_R_X_SYNC_SEL_8812F))
#define BIT_GET_R_X_SYNC_SEL_8812F(x)                                          \
	(((x) >> BIT_SHIFT_R_X_SYNC_SEL_8812F) & BIT_MASK_R_X_SYNC_SEL_8812F)
#define BIT_SET_R_X_SYNC_SEL_8812F(x, v)                                       \
	(BIT_CLEAR_R_X_SYNC_SEL_8812F(x) | BIT_R_X_SYNC_SEL_8812F(v))

#define BIT_SHIFT_R_SYNC_Y_SEL_8812F 0
#define BIT_MASK_R_SYNC_Y_SEL_8812F 0x7
#define BIT_R_SYNC_Y_SEL_8812F(x)                                              \
	(((x) & BIT_MASK_R_SYNC_Y_SEL_8812F) << BIT_SHIFT_R_SYNC_Y_SEL_8812F)
#define BITS_R_SYNC_Y_SEL_8812F                                                \
	(BIT_MASK_R_SYNC_Y_SEL_8812F << BIT_SHIFT_R_SYNC_Y_SEL_8812F)
#define BIT_CLEAR_R_SYNC_Y_SEL_8812F(x) ((x) & (~BITS_R_SYNC_Y_SEL_8812F))
#define BIT_GET_R_SYNC_Y_SEL_8812F(x)                                          \
	(((x) >> BIT_SHIFT_R_SYNC_Y_SEL_8812F) & BIT_MASK_R_SYNC_Y_SEL_8812F)
#define BIT_SET_R_SYNC_Y_SEL_8812F(x, v)                                       \
	(BIT_CLEAR_R_SYNC_Y_SEL_8812F(x) | BIT_R_SYNC_Y_SEL_8812F(v))

/* 2 REG_TSF_ADJ_VLAUE_8812F */

#define BIT_SHIFT_R_CLI1_TSFT_ADJ_VAL_8812F 16
#define BIT_MASK_R_CLI1_TSFT_ADJ_VAL_8812F 0xffff
#define BIT_R_CLI1_TSFT_ADJ_VAL_8812F(x)                                       \
	(((x) & BIT_MASK_R_CLI1_TSFT_ADJ_VAL_8812F)                            \
	 << BIT_SHIFT_R_CLI1_TSFT_ADJ_VAL_8812F)
#define BITS_R_CLI1_TSFT_ADJ_VAL_8812F                                         \
	(BIT_MASK_R_CLI1_TSFT_ADJ_VAL_8812F                                    \
	 << BIT_SHIFT_R_CLI1_TSFT_ADJ_VAL_8812F)
#define BIT_CLEAR_R_CLI1_TSFT_ADJ_VAL_8812F(x)                                 \
	((x) & (~BITS_R_CLI1_TSFT_ADJ_VAL_8812F))
#define BIT_GET_R_CLI1_TSFT_ADJ_VAL_8812F(x)                                   \
	(((x) >> BIT_SHIFT_R_CLI1_TSFT_ADJ_VAL_8812F) &                        \
	 BIT_MASK_R_CLI1_TSFT_ADJ_VAL_8812F)
#define BIT_SET_R_CLI1_TSFT_ADJ_VAL_8812F(x, v)                                \
	(BIT_CLEAR_R_CLI1_TSFT_ADJ_VAL_8812F(x) |                              \
	 BIT_R_CLI1_TSFT_ADJ_VAL_8812F(v))

#define BIT_SHIFT_R_CLI0_TSFT_ADJ_VAL_8812F 0
#define BIT_MASK_R_CLI0_TSFT_ADJ_VAL_8812F 0xffff
#define BIT_R_CLI0_TSFT_ADJ_VAL_8812F(x)                                       \
	(((x) & BIT_MASK_R_CLI0_TSFT_ADJ_VAL_8812F)                            \
	 << BIT_SHIFT_R_CLI0_TSFT_ADJ_VAL_8812F)
#define BITS_R_CLI0_TSFT_ADJ_VAL_8812F                                         \
	(BIT_MASK_R_CLI0_TSFT_ADJ_VAL_8812F                                    \
	 << BIT_SHIFT_R_CLI0_TSFT_ADJ_VAL_8812F)
#define BIT_CLEAR_R_CLI0_TSFT_ADJ_VAL_8812F(x)                                 \
	((x) & (~BITS_R_CLI0_TSFT_ADJ_VAL_8812F))
#define BIT_GET_R_CLI0_TSFT_ADJ_VAL_8812F(x)                                   \
	(((x) >> BIT_SHIFT_R_CLI0_TSFT_ADJ_VAL_8812F) &                        \
	 BIT_MASK_R_CLI0_TSFT_ADJ_VAL_8812F)
#define BIT_SET_R_CLI0_TSFT_ADJ_VAL_8812F(x, v)                                \
	(BIT_CLEAR_R_CLI0_TSFT_ADJ_VAL_8812F(x) |                              \
	 BIT_R_CLI0_TSFT_ADJ_VAL_8812F(v))

/* 2 REG_TSF_ADJ_VLAUE_2_8812F */

#define BIT_SHIFT_R_CLI3_TSFT_ADJ_VAL_8812F 16
#define BIT_MASK_R_CLI3_TSFT_ADJ_VAL_8812F 0xffff
#define BIT_R_CLI3_TSFT_ADJ_VAL_8812F(x)                                       \
	(((x) & BIT_MASK_R_CLI3_TSFT_ADJ_VAL_8812F)                            \
	 << BIT_SHIFT_R_CLI3_TSFT_ADJ_VAL_8812F)
#define BITS_R_CLI3_TSFT_ADJ_VAL_8812F                                         \
	(BIT_MASK_R_CLI3_TSFT_ADJ_VAL_8812F                                    \
	 << BIT_SHIFT_R_CLI3_TSFT_ADJ_VAL_8812F)
#define BIT_CLEAR_R_CLI3_TSFT_ADJ_VAL_8812F(x)                                 \
	((x) & (~BITS_R_CLI3_TSFT_ADJ_VAL_8812F))
#define BIT_GET_R_CLI3_TSFT_ADJ_VAL_8812F(x)                                   \
	(((x) >> BIT_SHIFT_R_CLI3_TSFT_ADJ_VAL_8812F) &                        \
	 BIT_MASK_R_CLI3_TSFT_ADJ_VAL_8812F)
#define BIT_SET_R_CLI3_TSFT_ADJ_VAL_8812F(x, v)                                \
	(BIT_CLEAR_R_CLI3_TSFT_ADJ_VAL_8812F(x) |                              \
	 BIT_R_CLI3_TSFT_ADJ_VAL_8812F(v))

#define BIT_SHIFT_R_CLI2_TSFT_ADJ_VAL_8812F 0
#define BIT_MASK_R_CLI2_TSFT_ADJ_VAL_8812F 0xffff
#define BIT_R_CLI2_TSFT_ADJ_VAL_8812F(x)                                       \
	(((x) & BIT_MASK_R_CLI2_TSFT_ADJ_VAL_8812F)                            \
	 << BIT_SHIFT_R_CLI2_TSFT_ADJ_VAL_8812F)
#define BITS_R_CLI2_TSFT_ADJ_VAL_8812F                                         \
	(BIT_MASK_R_CLI2_TSFT_ADJ_VAL_8812F                                    \
	 << BIT_SHIFT_R_CLI2_TSFT_ADJ_VAL_8812F)
#define BIT_CLEAR_R_CLI2_TSFT_ADJ_VAL_8812F(x)                                 \
	((x) & (~BITS_R_CLI2_TSFT_ADJ_VAL_8812F))
#define BIT_GET_R_CLI2_TSFT_ADJ_VAL_8812F(x)                                   \
	(((x) >> BIT_SHIFT_R_CLI2_TSFT_ADJ_VAL_8812F) &                        \
	 BIT_MASK_R_CLI2_TSFT_ADJ_VAL_8812F)
#define BIT_SET_R_CLI2_TSFT_ADJ_VAL_8812F(x, v)                                \
	(BIT_CLEAR_R_CLI2_TSFT_ADJ_VAL_8812F(x) |                              \
	 BIT_R_CLI2_TSFT_ADJ_VAL_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_P2PPS_HW_AUTO_PAUSE_CTRL_8812F */
#define BIT_P2PPS_NOA_STOP_TX_HANG_8812F BIT(31)
#define BIT_P2PPS_MACID_PAUSE_EN_8812F BIT(11)
#define BIT_P2PPS__MGQ_PAUSE_8812F BIT(10)
#define BIT_P2PPS__HIQ_PAUSE_8812F BIT(9)
#define BIT_P2PPS__BCNQ_PAUSE_8812F BIT(8)

#define BIT_SHIFT_P2PPS_MACID_PAUSE_8812F 0
#define BIT_MASK_P2PPS_MACID_PAUSE_8812F 0xff
#define BIT_P2PPS_MACID_PAUSE_8812F(x)                                         \
	(((x) & BIT_MASK_P2PPS_MACID_PAUSE_8812F)                              \
	 << BIT_SHIFT_P2PPS_MACID_PAUSE_8812F)
#define BITS_P2PPS_MACID_PAUSE_8812F                                           \
	(BIT_MASK_P2PPS_MACID_PAUSE_8812F << BIT_SHIFT_P2PPS_MACID_PAUSE_8812F)
#define BIT_CLEAR_P2PPS_MACID_PAUSE_8812F(x)                                   \
	((x) & (~BITS_P2PPS_MACID_PAUSE_8812F))
#define BIT_GET_P2PPS_MACID_PAUSE_8812F(x)                                     \
	(((x) >> BIT_SHIFT_P2PPS_MACID_PAUSE_8812F) &                          \
	 BIT_MASK_P2PPS_MACID_PAUSE_8812F)
#define BIT_SET_P2PPS_MACID_PAUSE_8812F(x, v)                                  \
	(BIT_CLEAR_P2PPS_MACID_PAUSE_8812F(x) | BIT_P2PPS_MACID_PAUSE_8812F(v))

/* 2 REG_P2PPS1_HW_AUTO_PAUSE_CTRL_8812F */
#define BIT_P2PPS1_NOA_STOP_TX_HANG_8812F BIT(31)
#define BIT_P2PPS1_MACID_PAUSE_EN_8812F BIT(11)
#define BIT_P2PPS1__MGQ_PAUSE_8812F BIT(10)
#define BIT_P2PPS1__HIQ_PAUSE_8812F BIT(9)
#define BIT_P2PPS1__BCNQ_PAUSE_8812F BIT(8)

#define BIT_SHIFT_P2PPS1_MACID_PAUSE_8812F 0
#define BIT_MASK_P2PPS1_MACID_PAUSE_8812F 0xff
#define BIT_P2PPS1_MACID_PAUSE_8812F(x)                                        \
	(((x) & BIT_MASK_P2PPS1_MACID_PAUSE_8812F)                             \
	 << BIT_SHIFT_P2PPS1_MACID_PAUSE_8812F)
#define BITS_P2PPS1_MACID_PAUSE_8812F                                          \
	(BIT_MASK_P2PPS1_MACID_PAUSE_8812F                                     \
	 << BIT_SHIFT_P2PPS1_MACID_PAUSE_8812F)
#define BIT_CLEAR_P2PPS1_MACID_PAUSE_8812F(x)                                  \
	((x) & (~BITS_P2PPS1_MACID_PAUSE_8812F))
#define BIT_GET_P2PPS1_MACID_PAUSE_8812F(x)                                    \
	(((x) >> BIT_SHIFT_P2PPS1_MACID_PAUSE_8812F) &                         \
	 BIT_MASK_P2PPS1_MACID_PAUSE_8812F)
#define BIT_SET_P2PPS1_MACID_PAUSE_8812F(x, v)                                 \
	(BIT_CLEAR_P2PPS1_MACID_PAUSE_8812F(x) |                               \
	 BIT_P2PPS1_MACID_PAUSE_8812F(v))

/* 2 REG_P2PPS2_HW_AUTO_PAUSE_CTRL_8812F */
#define BIT_P2PPS2_NOA_STOP_TX_HANG_8812F BIT(31)
#define BIT_P2PPS2_MACID_PAUSE_EN_8812F BIT(11)
#define BIT_P2PPS2__MGQ_PAUSE_8812F BIT(10)
#define BIT_P2PPS2__HIQ_PAUSE_8812F BIT(9)
#define BIT_P2PPS2__BCNQ_PAUSE_8812F BIT(8)

#define BIT_SHIFT_P2PPS2_MACID_PAUSE_8812F 0
#define BIT_MASK_P2PPS2_MACID_PAUSE_8812F 0xff
#define BIT_P2PPS2_MACID_PAUSE_8812F(x)                                        \
	(((x) & BIT_MASK_P2PPS2_MACID_PAUSE_8812F)                             \
	 << BIT_SHIFT_P2PPS2_MACID_PAUSE_8812F)
#define BITS_P2PPS2_MACID_PAUSE_8812F                                          \
	(BIT_MASK_P2PPS2_MACID_PAUSE_8812F                                     \
	 << BIT_SHIFT_P2PPS2_MACID_PAUSE_8812F)
#define BIT_CLEAR_P2PPS2_MACID_PAUSE_8812F(x)                                  \
	((x) & (~BITS_P2PPS2_MACID_PAUSE_8812F))
#define BIT_GET_P2PPS2_MACID_PAUSE_8812F(x)                                    \
	(((x) >> BIT_SHIFT_P2PPS2_MACID_PAUSE_8812F) &                         \
	 BIT_MASK_P2PPS2_MACID_PAUSE_8812F)
#define BIT_SET_P2PPS2_MACID_PAUSE_8812F(x, v)                                 \
	(BIT_CLEAR_P2PPS2_MACID_PAUSE_8812F(x) |                               \
	 BIT_P2PPS2_MACID_PAUSE_8812F(v))

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_WMAC_CR_8812F (WMAC CR AND APSD CONTROL REGISTER) */
#define BIT_IC_MACPHY_M_8812F BIT(0)

/* 2 REG_WMAC_FWPKT_CR_8812F */
#define BIT_FWEN_8812F BIT(7)
#define BIT_PHYSTS_PKT_CTRL_8812F BIT(6)
#define BIT_APPHDR_MIDSRCH_FAIL_8812F BIT(4)
#define BIT_FWPARSING_EN_8812F BIT(3)

#define BIT_SHIFT_APPEND_MHDR_LEN_8812F 0
#define BIT_MASK_APPEND_MHDR_LEN_8812F 0x7
#define BIT_APPEND_MHDR_LEN_8812F(x)                                           \
	(((x) & BIT_MASK_APPEND_MHDR_LEN_8812F)                                \
	 << BIT_SHIFT_APPEND_MHDR_LEN_8812F)
#define BITS_APPEND_MHDR_LEN_8812F                                             \
	(BIT_MASK_APPEND_MHDR_LEN_8812F << BIT_SHIFT_APPEND_MHDR_LEN_8812F)
#define BIT_CLEAR_APPEND_MHDR_LEN_8812F(x) ((x) & (~BITS_APPEND_MHDR_LEN_8812F))
#define BIT_GET_APPEND_MHDR_LEN_8812F(x)                                       \
	(((x) >> BIT_SHIFT_APPEND_MHDR_LEN_8812F) &                            \
	 BIT_MASK_APPEND_MHDR_LEN_8812F)
#define BIT_SET_APPEND_MHDR_LEN_8812F(x, v)                                    \
	(BIT_CLEAR_APPEND_MHDR_LEN_8812F(x) | BIT_APPEND_MHDR_LEN_8812F(v))

/* 2 REG_FW_STS_FILTER_8812F */
#define BIT_DATA_FW_STS_FILTER_8812F BIT(2)
#define BIT_CTRL_FW_STS_FILTER_8812F BIT(1)
#define BIT_MGNT_FW_STS_FILTER_8812F BIT(0)

/* 2 REG_RSVD_8812F */

/* 2 REG_TCR_8812F (TRANSMISSION CONFIGURATION REGISTER) */
#define BIT_WMAC_EN_RTS_ADDR_8812F BIT(31)
#define BIT_WMAC_DISABLE_CCK_8812F BIT(30)
#define BIT_WMAC_RAW_LEN_8812F BIT(29)
#define BIT_WMAC_NOTX_IN_RXNDP_8812F BIT(28)
#define BIT_WMAC_EN_EOF_8812F BIT(27)
#define BIT_WMAC_BF_SEL_8812F BIT(26)
#define BIT_WMAC_ANTMODE_SEL_8812F BIT(25)
#define BIT_WMAC_TCRPWRMGT_HWCTL_8812F BIT(24)
#define BIT_WMAC_SMOOTH_VAL_8812F BIT(23)
#define BIT_WMAC_EN_SCRAM_INC_8812F BIT(22)
#define BIT_UNDERFLOWEN_CMPLEN_SEL_8812F BIT(21)
#define BIT_FETCH_MPDU_AFTER_WSEC_RDY_8812F BIT(20)
#define BIT_WMAC_TCR_EN_20MST_8812F BIT(19)
#define BIT_WMAC_DIS_SIGTA_8812F BIT(18)
#define BIT_WMAC_DIS_A2B0_8812F BIT(17)
#define BIT_WMAC_MSK_SIGBCRC_8812F BIT(16)
#define BIT_WMAC_TCR_ERRSTEN_3_8812F BIT(15)
#define BIT_WMAC_TCR_ERRSTEN_2_8812F BIT(14)
#define BIT_WMAC_TCR_ERRSTEN_1_8812F BIT(13)
#define BIT_WMAC_TCR_ERRSTEN_0_8812F BIT(12)
#define BIT_WMAC_TCR_TXSK_PERPKT_8812F BIT(11)
#define BIT_ICV_8812F BIT(10)
#define BIT_CFEND_FORMAT_8812F BIT(9)
#define BIT_CRC_8812F BIT(8)
#define BIT_WMAC_TCRPWRMGT_HWDATA_EN_8812F BIT(7)
#define BIT_PWR_ST_8812F BIT(6)
#define BIT_WMAC_TCR_UPD_TIMIE_8812F BIT(5)
#define BIT_WMAC_TCR_UPD_HGQMD_8812F BIT(4)
#define BIT_VHTSIGA1_TXPS_8812F BIT(3)
#define BIT_PAD_SEL_8812F BIT(2)
#define BIT_DIS_GCLK_8812F BIT(1)
#define BIT_WMAC_TCRPWRMGT_HWACT_EN_8812F BIT(0)

/* 2 REG_RCR_8812F (RECEIVE CONFIGURATION REGISTER) */
#define BIT_APP_FCS_8812F BIT(31)
#define BIT_APP_MIC_8812F BIT(30)
#define BIT_APP_ICV_8812F BIT(29)
#define BIT_APP_PHYSTS_8812F BIT(28)
#define BIT_APP_BASSN_8812F BIT(27)
#define BIT_VHT_DACK_8812F BIT(26)
#define BIT_TCPOFLD_EN_8812F BIT(25)
#define BIT_ENMBID_8812F BIT(24)
#define BIT_LSIGEN_8812F BIT(23)
#define BIT_MFBEN_8812F BIT(22)
#define BIT_DISCHKPPDLLEN_8812F BIT(21)
#define BIT_PKTCTL_DLEN_8812F BIT(20)
#define BIT_DISGCLK_8812F BIT(19)
#define BIT_TIM_PARSER_EN_8812F BIT(18)
#define BIT_BC_MD_EN_8812F BIT(17)
#define BIT_UC_MD_EN_8812F BIT(16)
#define BIT_RXSK_PERPKT_8812F BIT(15)
#define BIT_HTC_LOC_CTRL_8812F BIT(14)
#define BIT_ACK_WITH_CBSSID_DATA_OPTION_8812F BIT(13)
#define BIT_RPFM_CAM_ENABLE_8812F BIT(12)
#define BIT_TA_BCN_8812F BIT(11)
#define BIT_DISDECMYPKT_8812F BIT(10)
#define BIT_AICV_8812F BIT(9)
#define BIT_ACRC32_8812F BIT(8)
#define BIT_CBSSID_BCN_8812F BIT(7)
#define BIT_CBSSID_DATA_8812F BIT(6)
#define BIT_APWRMGT_8812F BIT(5)
#define BIT_ADD3_8812F BIT(4)
#define BIT_AB_8812F BIT(3)
#define BIT_AM_8812F BIT(2)
#define BIT_APM_8812F BIT(1)
#define BIT_AAP_8812F BIT(0)

/* 2 REG_RX_PKT_LIMIT_8812F (RX PACKET LENGTH LIMIT REGISTER) */

#define BIT_SHIFT_RXPKTLMT_8812F 0
#define BIT_MASK_RXPKTLMT_8812F 0x3f
#define BIT_RXPKTLMT_8812F(x)                                                  \
	(((x) & BIT_MASK_RXPKTLMT_8812F) << BIT_SHIFT_RXPKTLMT_8812F)
#define BITS_RXPKTLMT_8812F                                                    \
	(BIT_MASK_RXPKTLMT_8812F << BIT_SHIFT_RXPKTLMT_8812F)
#define BIT_CLEAR_RXPKTLMT_8812F(x) ((x) & (~BITS_RXPKTLMT_8812F))
#define BIT_GET_RXPKTLMT_8812F(x)                                              \
	(((x) >> BIT_SHIFT_RXPKTLMT_8812F) & BIT_MASK_RXPKTLMT_8812F)
#define BIT_SET_RXPKTLMT_8812F(x, v)                                           \
	(BIT_CLEAR_RXPKTLMT_8812F(x) | BIT_RXPKTLMT_8812F(v))

/* 2 REG_RX_DLK_TIME_8812F (RX DEADLOCK TIME REGISTER) */

#define BIT_SHIFT_RX_DLK_TIME_8812F 0
#define BIT_MASK_RX_DLK_TIME_8812F 0xff
#define BIT_RX_DLK_TIME_8812F(x)                                               \
	(((x) & BIT_MASK_RX_DLK_TIME_8812F) << BIT_SHIFT_RX_DLK_TIME_8812F)
#define BITS_RX_DLK_TIME_8812F                                                 \
	(BIT_MASK_RX_DLK_TIME_8812F << BIT_SHIFT_RX_DLK_TIME_8812F)
#define BIT_CLEAR_RX_DLK_TIME_8812F(x) ((x) & (~BITS_RX_DLK_TIME_8812F))
#define BIT_GET_RX_DLK_TIME_8812F(x)                                           \
	(((x) >> BIT_SHIFT_RX_DLK_TIME_8812F) & BIT_MASK_RX_DLK_TIME_8812F)
#define BIT_SET_RX_DLK_TIME_8812F(x, v)                                        \
	(BIT_CLEAR_RX_DLK_TIME_8812F(x) | BIT_RX_DLK_TIME_8812F(v))

/* 2 REG_RSVD_8812F */

/* 2 REG_RX_DRVINFO_SZ_8812F (RX DRIVER INFO SIZE REGISTER) */
#define BIT_PHYSTS_PER_PKT_MODE_8812F BIT(7)

#define BIT_SHIFT_DRVINFO_SZ_V1_8812F 0
#define BIT_MASK_DRVINFO_SZ_V1_8812F 0xf
#define BIT_DRVINFO_SZ_V1_8812F(x)                                             \
	(((x) & BIT_MASK_DRVINFO_SZ_V1_8812F) << BIT_SHIFT_DRVINFO_SZ_V1_8812F)
#define BITS_DRVINFO_SZ_V1_8812F                                               \
	(BIT_MASK_DRVINFO_SZ_V1_8812F << BIT_SHIFT_DRVINFO_SZ_V1_8812F)
#define BIT_CLEAR_DRVINFO_SZ_V1_8812F(x) ((x) & (~BITS_DRVINFO_SZ_V1_8812F))
#define BIT_GET_DRVINFO_SZ_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_DRVINFO_SZ_V1_8812F) & BIT_MASK_DRVINFO_SZ_V1_8812F)
#define BIT_SET_DRVINFO_SZ_V1_8812F(x, v)                                      \
	(BIT_CLEAR_DRVINFO_SZ_V1_8812F(x) | BIT_DRVINFO_SZ_V1_8812F(v))

/* 2 REG_MACID_8812F	(MAC ID REGISTER) */

#define BIT_SHIFT_MACID_V1_8812F 0
#define BIT_MASK_MACID_V1_8812F 0xffffffffL
#define BIT_MACID_V1_8812F(x)                                                  \
	(((x) & BIT_MASK_MACID_V1_8812F) << BIT_SHIFT_MACID_V1_8812F)
#define BITS_MACID_V1_8812F                                                    \
	(BIT_MASK_MACID_V1_8812F << BIT_SHIFT_MACID_V1_8812F)
#define BIT_CLEAR_MACID_V1_8812F(x) ((x) & (~BITS_MACID_V1_8812F))
#define BIT_GET_MACID_V1_8812F(x)                                              \
	(((x) >> BIT_SHIFT_MACID_V1_8812F) & BIT_MASK_MACID_V1_8812F)
#define BIT_SET_MACID_V1_8812F(x, v)                                           \
	(BIT_CLEAR_MACID_V1_8812F(x) | BIT_MACID_V1_8812F(v))

/* 2 REG_MACID_H_8812F	(MAC ID REGISTER) */

#define BIT_SHIFT_MACID_H_V1_8812F 0
#define BIT_MASK_MACID_H_V1_8812F 0xffff
#define BIT_MACID_H_V1_8812F(x)                                                \
	(((x) & BIT_MASK_MACID_H_V1_8812F) << BIT_SHIFT_MACID_H_V1_8812F)
#define BITS_MACID_H_V1_8812F                                                  \
	(BIT_MASK_MACID_H_V1_8812F << BIT_SHIFT_MACID_H_V1_8812F)
#define BIT_CLEAR_MACID_H_V1_8812F(x) ((x) & (~BITS_MACID_H_V1_8812F))
#define BIT_GET_MACID_H_V1_8812F(x)                                            \
	(((x) >> BIT_SHIFT_MACID_H_V1_8812F) & BIT_MASK_MACID_H_V1_8812F)
#define BIT_SET_MACID_H_V1_8812F(x, v)                                         \
	(BIT_CLEAR_MACID_H_V1_8812F(x) | BIT_MACID_H_V1_8812F(v))

/* 2 REG_BSSID_8812F (BSSID REGISTER) */

#define BIT_SHIFT_BSSID_V1_8812F 0
#define BIT_MASK_BSSID_V1_8812F 0xffffffffL
#define BIT_BSSID_V1_8812F(x)                                                  \
	(((x) & BIT_MASK_BSSID_V1_8812F) << BIT_SHIFT_BSSID_V1_8812F)
#define BITS_BSSID_V1_8812F                                                    \
	(BIT_MASK_BSSID_V1_8812F << BIT_SHIFT_BSSID_V1_8812F)
#define BIT_CLEAR_BSSID_V1_8812F(x) ((x) & (~BITS_BSSID_V1_8812F))
#define BIT_GET_BSSID_V1_8812F(x)                                              \
	(((x) >> BIT_SHIFT_BSSID_V1_8812F) & BIT_MASK_BSSID_V1_8812F)
#define BIT_SET_BSSID_V1_8812F(x, v)                                           \
	(BIT_CLEAR_BSSID_V1_8812F(x) | BIT_BSSID_V1_8812F(v))

/* 2 REG_BSSID_H_8812F	(BSSID REGISTER) */

/* 2 REG_NOT_VALID_8812F */

#define BIT_SHIFT_BSSID_H_V1_8812F 0
#define BIT_MASK_BSSID_H_V1_8812F 0xffff
#define BIT_BSSID_H_V1_8812F(x)                                                \
	(((x) & BIT_MASK_BSSID_H_V1_8812F) << BIT_SHIFT_BSSID_H_V1_8812F)
#define BITS_BSSID_H_V1_8812F                                                  \
	(BIT_MASK_BSSID_H_V1_8812F << BIT_SHIFT_BSSID_H_V1_8812F)
#define BIT_CLEAR_BSSID_H_V1_8812F(x) ((x) & (~BITS_BSSID_H_V1_8812F))
#define BIT_GET_BSSID_H_V1_8812F(x)                                            \
	(((x) >> BIT_SHIFT_BSSID_H_V1_8812F) & BIT_MASK_BSSID_H_V1_8812F)
#define BIT_SET_BSSID_H_V1_8812F(x, v)                                         \
	(BIT_CLEAR_BSSID_H_V1_8812F(x) | BIT_BSSID_H_V1_8812F(v))

/* 2 REG_MAR_8812F (MULTICAST ADDRESS REGISTER) */

#define BIT_SHIFT_MAR_V1_8812F 0
#define BIT_MASK_MAR_V1_8812F 0xffffffffL
#define BIT_MAR_V1_8812F(x)                                                    \
	(((x) & BIT_MASK_MAR_V1_8812F) << BIT_SHIFT_MAR_V1_8812F)
#define BITS_MAR_V1_8812F (BIT_MASK_MAR_V1_8812F << BIT_SHIFT_MAR_V1_8812F)
#define BIT_CLEAR_MAR_V1_8812F(x) ((x) & (~BITS_MAR_V1_8812F))
#define BIT_GET_MAR_V1_8812F(x)                                                \
	(((x) >> BIT_SHIFT_MAR_V1_8812F) & BIT_MASK_MAR_V1_8812F)
#define BIT_SET_MAR_V1_8812F(x, v)                                             \
	(BIT_CLEAR_MAR_V1_8812F(x) | BIT_MAR_V1_8812F(v))

/* 2 REG_MAR_H_8812F (MULTICAST ADDRESS REGISTER) */

#define BIT_SHIFT_MAR_H_V1_8812F 0
#define BIT_MASK_MAR_H_V1_8812F 0xffffffffL
#define BIT_MAR_H_V1_8812F(x)                                                  \
	(((x) & BIT_MASK_MAR_H_V1_8812F) << BIT_SHIFT_MAR_H_V1_8812F)
#define BITS_MAR_H_V1_8812F                                                    \
	(BIT_MASK_MAR_H_V1_8812F << BIT_SHIFT_MAR_H_V1_8812F)
#define BIT_CLEAR_MAR_H_V1_8812F(x) ((x) & (~BITS_MAR_H_V1_8812F))
#define BIT_GET_MAR_H_V1_8812F(x)                                              \
	(((x) >> BIT_SHIFT_MAR_H_V1_8812F) & BIT_MASK_MAR_H_V1_8812F)
#define BIT_SET_MAR_H_V1_8812F(x, v)                                           \
	(BIT_CLEAR_MAR_H_V1_8812F(x) | BIT_MAR_H_V1_8812F(v))

/* 2 REG_MBIDCAMCFG_1_8812F (MBSSID CAM CONFIGURATION REGISTER) */

#define BIT_SHIFT_MBIDCAM_RWDATA_L_8812F 0
#define BIT_MASK_MBIDCAM_RWDATA_L_8812F 0xffffffffL
#define BIT_MBIDCAM_RWDATA_L_8812F(x)                                          \
	(((x) & BIT_MASK_MBIDCAM_RWDATA_L_8812F)                               \
	 << BIT_SHIFT_MBIDCAM_RWDATA_L_8812F)
#define BITS_MBIDCAM_RWDATA_L_8812F                                            \
	(BIT_MASK_MBIDCAM_RWDATA_L_8812F << BIT_SHIFT_MBIDCAM_RWDATA_L_8812F)
#define BIT_CLEAR_MBIDCAM_RWDATA_L_8812F(x)                                    \
	((x) & (~BITS_MBIDCAM_RWDATA_L_8812F))
#define BIT_GET_MBIDCAM_RWDATA_L_8812F(x)                                      \
	(((x) >> BIT_SHIFT_MBIDCAM_RWDATA_L_8812F) &                           \
	 BIT_MASK_MBIDCAM_RWDATA_L_8812F)
#define BIT_SET_MBIDCAM_RWDATA_L_8812F(x, v)                                   \
	(BIT_CLEAR_MBIDCAM_RWDATA_L_8812F(x) | BIT_MBIDCAM_RWDATA_L_8812F(v))

/* 2 REG_MBIDCAMCFG_2_8812F (MBSSID CAM CONFIGURATION REGISTER) */
#define BIT_MBIDCAM_POLL_8812F BIT(31)
#define BIT_MBIDCAM_WT_EN_8812F BIT(30)

#define BIT_SHIFT_MBIDCAM_ADDR_V1_8812F 24
#define BIT_MASK_MBIDCAM_ADDR_V1_8812F 0x3f
#define BIT_MBIDCAM_ADDR_V1_8812F(x)                                           \
	(((x) & BIT_MASK_MBIDCAM_ADDR_V1_8812F)                                \
	 << BIT_SHIFT_MBIDCAM_ADDR_V1_8812F)
#define BITS_MBIDCAM_ADDR_V1_8812F                                             \
	(BIT_MASK_MBIDCAM_ADDR_V1_8812F << BIT_SHIFT_MBIDCAM_ADDR_V1_8812F)
#define BIT_CLEAR_MBIDCAM_ADDR_V1_8812F(x) ((x) & (~BITS_MBIDCAM_ADDR_V1_8812F))
#define BIT_GET_MBIDCAM_ADDR_V1_8812F(x)                                       \
	(((x) >> BIT_SHIFT_MBIDCAM_ADDR_V1_8812F) &                            \
	 BIT_MASK_MBIDCAM_ADDR_V1_8812F)
#define BIT_SET_MBIDCAM_ADDR_V1_8812F(x, v)                                    \
	(BIT_CLEAR_MBIDCAM_ADDR_V1_8812F(x) | BIT_MBIDCAM_ADDR_V1_8812F(v))

#define BIT_MBIDCAM_VALID_8812F BIT(23)
#define BIT_LSIC_TXOP_EN_8812F BIT(17)
#define BIT_CTS_EN_8812F BIT(16)

#define BIT_SHIFT_MBIDCAM_RWDATA_H_8812F 0
#define BIT_MASK_MBIDCAM_RWDATA_H_8812F 0xffff
#define BIT_MBIDCAM_RWDATA_H_8812F(x)                                          \
	(((x) & BIT_MASK_MBIDCAM_RWDATA_H_8812F)                               \
	 << BIT_SHIFT_MBIDCAM_RWDATA_H_8812F)
#define BITS_MBIDCAM_RWDATA_H_8812F                                            \
	(BIT_MASK_MBIDCAM_RWDATA_H_8812F << BIT_SHIFT_MBIDCAM_RWDATA_H_8812F)
#define BIT_CLEAR_MBIDCAM_RWDATA_H_8812F(x)                                    \
	((x) & (~BITS_MBIDCAM_RWDATA_H_8812F))
#define BIT_GET_MBIDCAM_RWDATA_H_8812F(x)                                      \
	(((x) >> BIT_SHIFT_MBIDCAM_RWDATA_H_8812F) &                           \
	 BIT_MASK_MBIDCAM_RWDATA_H_8812F)
#define BIT_SET_MBIDCAM_RWDATA_H_8812F(x, v)                                   \
	(BIT_CLEAR_MBIDCAM_RWDATA_H_8812F(x) | BIT_MBIDCAM_RWDATA_H_8812F(v))

/* 2 REG_WMAC_TCR_TSFT_OFS_8812F */

#define BIT_SHIFT_WMAC_TCR_TSFT_OFS_8812F 0
#define BIT_MASK_WMAC_TCR_TSFT_OFS_8812F 0xffff
#define BIT_WMAC_TCR_TSFT_OFS_8812F(x)                                         \
	(((x) & BIT_MASK_WMAC_TCR_TSFT_OFS_8812F)                              \
	 << BIT_SHIFT_WMAC_TCR_TSFT_OFS_8812F)
#define BITS_WMAC_TCR_TSFT_OFS_8812F                                           \
	(BIT_MASK_WMAC_TCR_TSFT_OFS_8812F << BIT_SHIFT_WMAC_TCR_TSFT_OFS_8812F)
#define BIT_CLEAR_WMAC_TCR_TSFT_OFS_8812F(x)                                   \
	((x) & (~BITS_WMAC_TCR_TSFT_OFS_8812F))
#define BIT_GET_WMAC_TCR_TSFT_OFS_8812F(x)                                     \
	(((x) >> BIT_SHIFT_WMAC_TCR_TSFT_OFS_8812F) &                          \
	 BIT_MASK_WMAC_TCR_TSFT_OFS_8812F)
#define BIT_SET_WMAC_TCR_TSFT_OFS_8812F(x, v)                                  \
	(BIT_CLEAR_WMAC_TCR_TSFT_OFS_8812F(x) | BIT_WMAC_TCR_TSFT_OFS_8812F(v))

/* 2 REG_UDF_THSD_8812F */
#define BIT_UDF_THSD_V1_8812F BIT(7)

#define BIT_SHIFT_UDF_THSD_VALUE_8812F 0
#define BIT_MASK_UDF_THSD_VALUE_8812F 0x7f
#define BIT_UDF_THSD_VALUE_8812F(x)                                            \
	(((x) & BIT_MASK_UDF_THSD_VALUE_8812F)                                 \
	 << BIT_SHIFT_UDF_THSD_VALUE_8812F)
#define BITS_UDF_THSD_VALUE_8812F                                              \
	(BIT_MASK_UDF_THSD_VALUE_8812F << BIT_SHIFT_UDF_THSD_VALUE_8812F)
#define BIT_CLEAR_UDF_THSD_VALUE_8812F(x) ((x) & (~BITS_UDF_THSD_VALUE_8812F))
#define BIT_GET_UDF_THSD_VALUE_8812F(x)                                        \
	(((x) >> BIT_SHIFT_UDF_THSD_VALUE_8812F) &                             \
	 BIT_MASK_UDF_THSD_VALUE_8812F)
#define BIT_SET_UDF_THSD_VALUE_8812F(x, v)                                     \
	(BIT_CLEAR_UDF_THSD_VALUE_8812F(x) | BIT_UDF_THSD_VALUE_8812F(v))

/* 2 REG_ZLD_NUM_8812F */

#define BIT_SHIFT_ZLD_NUM_8812F 0
#define BIT_MASK_ZLD_NUM_8812F 0xff
#define BIT_ZLD_NUM_8812F(x)                                                   \
	(((x) & BIT_MASK_ZLD_NUM_8812F) << BIT_SHIFT_ZLD_NUM_8812F)
#define BITS_ZLD_NUM_8812F (BIT_MASK_ZLD_NUM_8812F << BIT_SHIFT_ZLD_NUM_8812F)
#define BIT_CLEAR_ZLD_NUM_8812F(x) ((x) & (~BITS_ZLD_NUM_8812F))
#define BIT_GET_ZLD_NUM_8812F(x)                                               \
	(((x) >> BIT_SHIFT_ZLD_NUM_8812F) & BIT_MASK_ZLD_NUM_8812F)
#define BIT_SET_ZLD_NUM_8812F(x, v)                                            \
	(BIT_CLEAR_ZLD_NUM_8812F(x) | BIT_ZLD_NUM_8812F(v))

/* 2 REG_STMP_THSD_8812F */

#define BIT_SHIFT_STMP_THSD_8812F 0
#define BIT_MASK_STMP_THSD_8812F 0xff
#define BIT_STMP_THSD_8812F(x)                                                 \
	(((x) & BIT_MASK_STMP_THSD_8812F) << BIT_SHIFT_STMP_THSD_8812F)
#define BITS_STMP_THSD_8812F                                                   \
	(BIT_MASK_STMP_THSD_8812F << BIT_SHIFT_STMP_THSD_8812F)
#define BIT_CLEAR_STMP_THSD_8812F(x) ((x) & (~BITS_STMP_THSD_8812F))
#define BIT_GET_STMP_THSD_8812F(x)                                             \
	(((x) >> BIT_SHIFT_STMP_THSD_8812F) & BIT_MASK_STMP_THSD_8812F)
#define BIT_SET_STMP_THSD_8812F(x, v)                                          \
	(BIT_CLEAR_STMP_THSD_8812F(x) | BIT_STMP_THSD_8812F(v))

/* 2 REG_WMAC_TXTIMEOUT_8812F */

#define BIT_SHIFT_WMAC_TXTIMEOUT_8812F 0
#define BIT_MASK_WMAC_TXTIMEOUT_8812F 0xff
#define BIT_WMAC_TXTIMEOUT_8812F(x)                                            \
	(((x) & BIT_MASK_WMAC_TXTIMEOUT_8812F)                                 \
	 << BIT_SHIFT_WMAC_TXTIMEOUT_8812F)
#define BITS_WMAC_TXTIMEOUT_8812F                                              \
	(BIT_MASK_WMAC_TXTIMEOUT_8812F << BIT_SHIFT_WMAC_TXTIMEOUT_8812F)
#define BIT_CLEAR_WMAC_TXTIMEOUT_8812F(x) ((x) & (~BITS_WMAC_TXTIMEOUT_8812F))
#define BIT_GET_WMAC_TXTIMEOUT_8812F(x)                                        \
	(((x) >> BIT_SHIFT_WMAC_TXTIMEOUT_8812F) &                             \
	 BIT_MASK_WMAC_TXTIMEOUT_8812F)
#define BIT_SET_WMAC_TXTIMEOUT_8812F(x, v)                                     \
	(BIT_CLEAR_WMAC_TXTIMEOUT_8812F(x) | BIT_WMAC_TXTIMEOUT_8812F(v))

/* 2 REG_NOT_VALID_8812F */

/* 2 REG_USTIME_EDCA_8812F (US TIME TUNING FOR EDCA REGISTER) */

#define BIT_SHIFT_USTIME_EDCA_8812F 0
#define BIT_MASK_USTIME_EDCA_8812F 0xff
#define BIT_USTIME_EDCA_8812F(x)                                               \
	(((x) & BIT_MASK_USTIME_EDCA_8812F) << BIT_SHIFT_USTIME_EDCA_8812F)
#define BITS_USTIME_EDCA_8812F                                                 \
	(BIT_MASK_USTIME_EDCA_8812F << BIT_SHIFT_USTIME_EDCA_8812F)
#define BIT_CLEAR_USTIME_EDCA_8812F(x) ((x) & (~BITS_USTIME_EDCA_8812F))
#define BIT_GET_USTIME_EDCA_8812F(x)                                           \
	(((x) >> BIT_SHIFT_USTIME_EDCA_8812F) & BIT_MASK_USTIME_EDCA_8812F)
#define BIT_SET_USTIME_EDCA_8812F(x, v)                                        \
	(BIT_CLEAR_USTIME_EDCA_8812F(x) | BIT_USTIME_EDCA_8812F(v))

/* 2 REG_ACKTO_CCK_8812F (ACK TIMEOUT REGISTER FOR CCK RATE) */

#define BIT_SHIFT_ACKTO_CCK_8812F 0
#define BIT_MASK_ACKTO_CCK_8812F 0xff
#define BIT_ACKTO_CCK_8812F(x)                                                 \
	(((x) & BIT_MASK_ACKTO_CCK_8812F) << BIT_SHIFT_ACKTO_CCK_8812F)
#define BITS_ACKTO_CCK_8812F                                                   \
	(BIT_MASK_ACKTO_CCK_8812F << BIT_SHIFT_ACKTO_CCK_8812F)
#define BIT_CLEAR_ACKTO_CCK_8812F(x) ((x) & (~BITS_ACKTO_CCK_8812F))
#define BIT_GET_ACKTO_CCK_8812F(x)                                             \
	(((x) >> BIT_SHIFT_ACKTO_CCK_8812F) & BIT_MASK_ACKTO_CCK_8812F)
#define BIT_SET_ACKTO_CCK_8812F(x, v)                                          \
	(BIT_CLEAR_ACKTO_CCK_8812F(x) | BIT_ACKTO_CCK_8812F(v))

/* 2 REG_MAC_SPEC_SIFS_8812F (SPECIFICATION SIFS REGISTER) */

#define BIT_SHIFT_SPEC_SIFS_OFDM_8812F 8
#define BIT_MASK_SPEC_SIFS_OFDM_8812F 0xff
#define BIT_SPEC_SIFS_OFDM_8812F(x)                                            \
	(((x) & BIT_MASK_SPEC_SIFS_OFDM_8812F)                                 \
	 << BIT_SHIFT_SPEC_SIFS_OFDM_8812F)
#define BITS_SPEC_SIFS_OFDM_8812F                                              \
	(BIT_MASK_SPEC_SIFS_OFDM_8812F << BIT_SHIFT_SPEC_SIFS_OFDM_8812F)
#define BIT_CLEAR_SPEC_SIFS_OFDM_8812F(x) ((x) & (~BITS_SPEC_SIFS_OFDM_8812F))
#define BIT_GET_SPEC_SIFS_OFDM_8812F(x)                                        \
	(((x) >> BIT_SHIFT_SPEC_SIFS_OFDM_8812F) &                             \
	 BIT_MASK_SPEC_SIFS_OFDM_8812F)
#define BIT_SET_SPEC_SIFS_OFDM_8812F(x, v)                                     \
	(BIT_CLEAR_SPEC_SIFS_OFDM_8812F(x) | BIT_SPEC_SIFS_OFDM_8812F(v))

#define BIT_SHIFT_SPEC_SIFS_CCK_8812F 0
#define BIT_MASK_SPEC_SIFS_CCK_8812F 0xff
#define BIT_SPEC_SIFS_CCK_8812F(x)                                             \
	(((x) & BIT_MASK_SPEC_SIFS_CCK_8812F) << BIT_SHIFT_SPEC_SIFS_CCK_8812F)
#define BITS_SPEC_SIFS_CCK_8812F                                               \
	(BIT_MASK_SPEC_SIFS_CCK_8812F << BIT_SHIFT_SPEC_SIFS_CCK_8812F)
#define BIT_CLEAR_SPEC_SIFS_CCK_8812F(x) ((x) & (~BITS_SPEC_SIFS_CCK_8812F))
#define BIT_GET_SPEC_SIFS_CCK_8812F(x)                                         \
	(((x) >> BIT_SHIFT_SPEC_SIFS_CCK_8812F) & BIT_MASK_SPEC_SIFS_CCK_8812F)
#define BIT_SET_SPEC_SIFS_CCK_8812F(x, v)                                      \
	(BIT_CLEAR_SPEC_SIFS_CCK_8812F(x) | BIT_SPEC_SIFS_CCK_8812F(v))

/* 2 REG_RESP_SIFS_CCK_8812F (RESPONSE SIFS FOR CCK REGISTER) */

#define BIT_SHIFT_SIFS_R2T_CCK_8812F 8
#define BIT_MASK_SIFS_R2T_CCK_8812F 0xff
#define BIT_SIFS_R2T_CCK_8812F(x)                                              \
	(((x) & BIT_MASK_SIFS_R2T_CCK_8812F) << BIT_SHIFT_SIFS_R2T_CCK_8812F)
#define BITS_SIFS_R2T_CCK_8812F                                                \
	(BIT_MASK_SIFS_R2T_CCK_8812F << BIT_SHIFT_SIFS_R2T_CCK_8812F)
#define BIT_CLEAR_SIFS_R2T_CCK_8812F(x) ((x) & (~BITS_SIFS_R2T_CCK_8812F))
#define BIT_GET_SIFS_R2T_CCK_8812F(x)                                          \
	(((x) >> BIT_SHIFT_SIFS_R2T_CCK_8812F) & BIT_MASK_SIFS_R2T_CCK_8812F)
#define BIT_SET_SIFS_R2T_CCK_8812F(x, v)                                       \
	(BIT_CLEAR_SIFS_R2T_CCK_8812F(x) | BIT_SIFS_R2T_CCK_8812F(v))

#define BIT_SHIFT_SIFS_T2T_CCK_8812F 0
#define BIT_MASK_SIFS_T2T_CCK_8812F 0xff
#define BIT_SIFS_T2T_CCK_8812F(x)                                              \
	(((x) & BIT_MASK_SIFS_T2T_CCK_8812F) << BIT_SHIFT_SIFS_T2T_CCK_8812F)
#define BITS_SIFS_T2T_CCK_8812F                                                \
	(BIT_MASK_SIFS_T2T_CCK_8812F << BIT_SHIFT_SIFS_T2T_CCK_8812F)
#define BIT_CLEAR_SIFS_T2T_CCK_8812F(x) ((x) & (~BITS_SIFS_T2T_CCK_8812F))
#define BIT_GET_SIFS_T2T_CCK_8812F(x)                                          \
	(((x) >> BIT_SHIFT_SIFS_T2T_CCK_8812F) & BIT_MASK_SIFS_T2T_CCK_8812F)
#define BIT_SET_SIFS_T2T_CCK_8812F(x, v)                                       \
	(BIT_CLEAR_SIFS_T2T_CCK_8812F(x) | BIT_SIFS_T2T_CCK_8812F(v))

/* 2 REG_RESP_SIFS_OFDM_8812F (RESPONSE SIFS FOR OFDM REGISTER) */

#define BIT_SHIFT_SIFS_R2T_OFDM_8812F 8
#define BIT_MASK_SIFS_R2T_OFDM_8812F 0xff
#define BIT_SIFS_R2T_OFDM_8812F(x)                                             \
	(((x) & BIT_MASK_SIFS_R2T_OFDM_8812F) << BIT_SHIFT_SIFS_R2T_OFDM_8812F)
#define BITS_SIFS_R2T_OFDM_8812F                                               \
	(BIT_MASK_SIFS_R2T_OFDM_8812F << BIT_SHIFT_SIFS_R2T_OFDM_8812F)
#define BIT_CLEAR_SIFS_R2T_OFDM_8812F(x) ((x) & (~BITS_SIFS_R2T_OFDM_8812F))
#define BIT_GET_SIFS_R2T_OFDM_8812F(x)                                         \
	(((x) >> BIT_SHIFT_SIFS_R2T_OFDM_8812F) & BIT_MASK_SIFS_R2T_OFDM_8812F)
#define BIT_SET_SIFS_R2T_OFDM_8812F(x, v)                                      \
	(BIT_CLEAR_SIFS_R2T_OFDM_8812F(x) | BIT_SIFS_R2T_OFDM_8812F(v))

#define BIT_SHIFT_SIFS_T2T_OFDM_8812F 0
#define BIT_MASK_SIFS_T2T_OFDM_8812F 0xff
#define BIT_SIFS_T2T_OFDM_8812F(x)                                             \
	(((x) & BIT_MASK_SIFS_T2T_OFDM_8812F) << BIT_SHIFT_SIFS_T2T_OFDM_8812F)
#define BITS_SIFS_T2T_OFDM_8812F                                               \
	(BIT_MASK_SIFS_T2T_OFDM_8812F << BIT_SHIFT_SIFS_T2T_OFDM_8812F)
#define BIT_CLEAR_SIFS_T2T_OFDM_8812F(x) ((x) & (~BITS_SIFS_T2T_OFDM_8812F))
#define BIT_GET_SIFS_T2T_OFDM_8812F(x)                                         \
	(((x) >> BIT_SHIFT_SIFS_T2T_OFDM_8812F) & BIT_MASK_SIFS_T2T_OFDM_8812F)
#define BIT_SET_SIFS_T2T_OFDM_8812F(x, v)                                      \
	(BIT_CLEAR_SIFS_T2T_OFDM_8812F(x) | BIT_SIFS_T2T_OFDM_8812F(v))

/* 2 REG_ACKTO_8812F (ACK TIMEOUT REGISTER) */

#define BIT_SHIFT_ACKTO_8812F 0
#define BIT_MASK_ACKTO_8812F 0xff
#define BIT_ACKTO_8812F(x)                                                     \
	(((x) & BIT_MASK_ACKTO_8812F) << BIT_SHIFT_ACKTO_8812F)
#define BITS_ACKTO_8812F (BIT_MASK_ACKTO_8812F << BIT_SHIFT_ACKTO_8812F)
#define BIT_CLEAR_ACKTO_8812F(x) ((x) & (~BITS_ACKTO_8812F))
#define BIT_GET_ACKTO_8812F(x)                                                 \
	(((x) >> BIT_SHIFT_ACKTO_8812F) & BIT_MASK_ACKTO_8812F)
#define BIT_SET_ACKTO_8812F(x, v)                                              \
	(BIT_CLEAR_ACKTO_8812F(x) | BIT_ACKTO_8812F(v))

/* 2 REG_CTS2TO_8812F (CTS2 TIMEOUT REGISTER) */

#define BIT_SHIFT_CTS2TO_8812F 0
#define BIT_MASK_CTS2TO_8812F 0xff
#define BIT_CTS2TO_8812F(x)                                                    \
	(((x) & BIT_MASK_CTS2TO_8812F) << BIT_SHIFT_CTS2TO_8812F)
#define BITS_CTS2TO_8812F (BIT_MASK_CTS2TO_8812F << BIT_SHIFT_CTS2TO_8812F)
#define BIT_CLEAR_CTS2TO_8812F(x) ((x) & (~BITS_CTS2TO_8812F))
#define BIT_GET_CTS2TO_8812F(x)                                                \
	(((x) >> BIT_SHIFT_CTS2TO_8812F) & BIT_MASK_CTS2TO_8812F)
#define BIT_SET_CTS2TO_8812F(x, v)                                             \
	(BIT_CLEAR_CTS2TO_8812F(x) | BIT_CTS2TO_8812F(v))

/* 2 REG_EIFS_8812F (EIFS REGISTER) */

#define BIT_SHIFT_EIFS_8812F 0
#define BIT_MASK_EIFS_8812F 0xffff
#define BIT_EIFS_8812F(x) (((x) & BIT_MASK_EIFS_8812F) << BIT_SHIFT_EIFS_8812F)
#define BITS_EIFS_8812F (BIT_MASK_EIFS_8812F << BIT_SHIFT_EIFS_8812F)
#define BIT_CLEAR_EIFS_8812F(x) ((x) & (~BITS_EIFS_8812F))
#define BIT_GET_EIFS_8812F(x)                                                  \
	(((x) >> BIT_SHIFT_EIFS_8812F) & BIT_MASK_EIFS_8812F)
#define BIT_SET_EIFS_8812F(x, v) (BIT_CLEAR_EIFS_8812F(x) | BIT_EIFS_8812F(v))

/* 2 REG_RPFM_MAP0_8812F */
#define BIT_MGT_RPFM15EN_8812F BIT(15)
#define BIT_MGT_RPFM14EN_8812F BIT(14)
#define BIT_MGT_RPFM13EN_8812F BIT(13)
#define BIT_MGT_RPFM12EN_8812F BIT(12)
#define BIT_MGT_RPFM11EN_8812F BIT(11)
#define BIT_MGT_RPFM10EN_8812F BIT(10)
#define BIT_MGT_RPFM9EN_8812F BIT(9)
#define BIT_MGT_RPFM8EN_8812F BIT(8)
#define BIT_MGT_RPFM7EN_8812F BIT(7)
#define BIT_MGT_RPFM6EN_8812F BIT(6)
#define BIT_MGT_RPFM5EN_8812F BIT(5)
#define BIT_MGT_RPFM4EN_8812F BIT(4)
#define BIT_MGT_RPFM3EN_8812F BIT(3)
#define BIT_MGT_RPFM2EN_8812F BIT(2)
#define BIT_MGT_RPFM1EN_8812F BIT(1)
#define BIT_MGT_RPFM0EN_8812F BIT(0)

/* 2 REG_RPFM_MAP1_V1_8812F */
#define BIT_DATA_RPFM15EN_8812F BIT(15)
#define BIT_DATA_RPFM14EN_8812F BIT(14)
#define BIT_DATA_RPFM13EN_8812F BIT(13)
#define BIT_DATA_RPFM12EN_8812F BIT(12)
#define BIT_DATA_RPFM11EN_8812F BIT(11)
#define BIT_DATA_RPFM10EN_8812F BIT(10)
#define BIT_DATA_RPFM9EN_8812F BIT(9)
#define BIT_DATA_RPFM8EN_8812F BIT(8)
#define BIT_DATA_RPFM7EN_8812F BIT(7)
#define BIT_DATA_RPFM6EN_8812F BIT(6)
#define BIT_DATA_RPFM5EN_8812F BIT(5)
#define BIT_DATA_RPFM4EN_8812F BIT(4)
#define BIT_DATA_RPFM3EN_8812F BIT(3)
#define BIT_DATA_RPFM2EN_8812F BIT(2)
#define BIT_DATA_RPFM1EN_8812F BIT(1)
#define BIT_DATA_RPFM0EN_8812F BIT(0)

/* 2 REG_RPFM_CAM_CMD_8812F (RX PAYLOAD FRAME MASK CAM COMMAND REGISTER) */
#define BIT_RPFM_CAM_POLLING_8812F BIT(31)
#define BIT_RPFM_CAM_CLR_8812F BIT(30)
#define BIT_RPFM_CAM_WE_8812F BIT(16)

#define BIT_SHIFT_RPFM_CAM_ADDR_8812F 0
#define BIT_MASK_RPFM_CAM_ADDR_8812F 0x7f
#define BIT_RPFM_CAM_ADDR_8812F(x)                                             \
	(((x) & BIT_MASK_RPFM_CAM_ADDR_8812F) << BIT_SHIFT_RPFM_CAM_ADDR_8812F)
#define BITS_RPFM_CAM_ADDR_8812F                                               \
	(BIT_MASK_RPFM_CAM_ADDR_8812F << BIT_SHIFT_RPFM_CAM_ADDR_8812F)
#define BIT_CLEAR_RPFM_CAM_ADDR_8812F(x) ((x) & (~BITS_RPFM_CAM_ADDR_8812F))
#define BIT_GET_RPFM_CAM_ADDR_8812F(x)                                         \
	(((x) >> BIT_SHIFT_RPFM_CAM_ADDR_8812F) & BIT_MASK_RPFM_CAM_ADDR_8812F)
#define BIT_SET_RPFM_CAM_ADDR_8812F(x, v)                                      \
	(BIT_CLEAR_RPFM_CAM_ADDR_8812F(x) | BIT_RPFM_CAM_ADDR_8812F(v))

/* 2 REG_RPFM_CAM_RWD_8812F (ACK TIMEOUT REGISTER) */

#define BIT_SHIFT_RPFM_CAM_RWD_8812F 0
#define BIT_MASK_RPFM_CAM_RWD_8812F 0xffffffffL
#define BIT_RPFM_CAM_RWD_8812F(x)                                              \
	(((x) & BIT_MASK_RPFM_CAM_RWD_8812F) << BIT_SHIFT_RPFM_CAM_RWD_8812F)
#define BITS_RPFM_CAM_RWD_8812F                                                \
	(BIT_MASK_RPFM_CAM_RWD_8812F << BIT_SHIFT_RPFM_CAM_RWD_8812F)
#define BIT_CLEAR_RPFM_CAM_RWD_8812F(x) ((x) & (~BITS_RPFM_CAM_RWD_8812F))
#define BIT_GET_RPFM_CAM_RWD_8812F(x)                                          \
	(((x) >> BIT_SHIFT_RPFM_CAM_RWD_8812F) & BIT_MASK_RPFM_CAM_RWD_8812F)
#define BIT_SET_RPFM_CAM_RWD_8812F(x, v)                                       \
	(BIT_CLEAR_RPFM_CAM_RWD_8812F(x) | BIT_RPFM_CAM_RWD_8812F(v))

/* 2 REG_NAV_CTRL_8812F (NAV CONTROL REGISTER) */

#define BIT_SHIFT_NAV_UPPER_8812F 16
#define BIT_MASK_NAV_UPPER_8812F 0xff
#define BIT_NAV_UPPER_8812F(x)                                                 \
	(((x) & BIT_MASK_NAV_UPPER_8812F) << BIT_SHIFT_NAV_UPPER_8812F)
#define BITS_NAV_UPPER_8812F                                                   \
	(BIT_MASK_NAV_UPPER_8812F << BIT_SHIFT_NAV_UPPER_8812F)
#define BIT_CLEAR_NAV_UPPER_8812F(x) ((x) & (~BITS_NAV_UPPER_8812F))
#define BIT_GET_NAV_UPPER_8812F(x)                                             \
	(((x) >> BIT_SHIFT_NAV_UPPER_8812F) & BIT_MASK_NAV_UPPER_8812F)
#define BIT_SET_NAV_UPPER_8812F(x, v)                                          \
	(BIT_CLEAR_NAV_UPPER_8812F(x) | BIT_NAV_UPPER_8812F(v))

#define BIT_SHIFT_RXMYRTS_NAV_8812F 8
#define BIT_MASK_RXMYRTS_NAV_8812F 0xf
#define BIT_RXMYRTS_NAV_8812F(x)                                               \
	(((x) & BIT_MASK_RXMYRTS_NAV_8812F) << BIT_SHIFT_RXMYRTS_NAV_8812F)
#define BITS_RXMYRTS_NAV_8812F                                                 \
	(BIT_MASK_RXMYRTS_NAV_8812F << BIT_SHIFT_RXMYRTS_NAV_8812F)
#define BIT_CLEAR_RXMYRTS_NAV_8812F(x) ((x) & (~BITS_RXMYRTS_NAV_8812F))
#define BIT_GET_RXMYRTS_NAV_8812F(x)                                           \
	(((x) >> BIT_SHIFT_RXMYRTS_NAV_8812F) & BIT_MASK_RXMYRTS_NAV_8812F)
#define BIT_SET_RXMYRTS_NAV_8812F(x, v)                                        \
	(BIT_CLEAR_RXMYRTS_NAV_8812F(x) | BIT_RXMYRTS_NAV_8812F(v))

#define BIT_SHIFT_RTSRST_8812F 0
#define BIT_MASK_RTSRST_8812F 0xff
#define BIT_RTSRST_8812F(x)                                                    \
	(((x) & BIT_MASK_RTSRST_8812F) << BIT_SHIFT_RTSRST_8812F)
#define BITS_RTSRST_8812F (BIT_MASK_RTSRST_8812F << BIT_SHIFT_RTSRST_8812F)
#define BIT_CLEAR_RTSRST_8812F(x) ((x) & (~BITS_RTSRST_8812F))
#define BIT_GET_RTSRST_8812F(x)                                                \
	(((x) >> BIT_SHIFT_RTSRST_8812F) & BIT_MASK_RTSRST_8812F)
#define BIT_SET_RTSRST_8812F(x, v)                                             \
	(BIT_CLEAR_RTSRST_8812F(x) | BIT_RTSRST_8812F(v))

/* 2 REG_BACAMCMD_8812F (BLOCK ACK CAM COMMAND REGISTER) */
#define BIT_BACAM_POLL_8812F BIT(31)
#define BIT_BACAM_RST_8812F BIT(17)
#define BIT_BACAM_RW_8812F BIT(16)

#define BIT_SHIFT_TXSBM_8812F 14
#define BIT_MASK_TXSBM_8812F 0x3
#define BIT_TXSBM_8812F(x)                                                     \
	(((x) & BIT_MASK_TXSBM_8812F) << BIT_SHIFT_TXSBM_8812F)
#define BITS_TXSBM_8812F (BIT_MASK_TXSBM_8812F << BIT_SHIFT_TXSBM_8812F)
#define BIT_CLEAR_TXSBM_8812F(x) ((x) & (~BITS_TXSBM_8812F))
#define BIT_GET_TXSBM_8812F(x)                                                 \
	(((x) >> BIT_SHIFT_TXSBM_8812F) & BIT_MASK_TXSBM_8812F)
#define BIT_SET_TXSBM_8812F(x, v)                                              \
	(BIT_CLEAR_TXSBM_8812F(x) | BIT_TXSBM_8812F(v))

#define BIT_SHIFT_BACAM_ADDR_8812F 0
#define BIT_MASK_BACAM_ADDR_8812F 0x3f
#define BIT_BACAM_ADDR_8812F(x)                                                \
	(((x) & BIT_MASK_BACAM_ADDR_8812F) << BIT_SHIFT_BACAM_ADDR_8812F)
#define BITS_BACAM_ADDR_8812F                                                  \
	(BIT_MASK_BACAM_ADDR_8812F << BIT_SHIFT_BACAM_ADDR_8812F)
#define BIT_CLEAR_BACAM_ADDR_8812F(x) ((x) & (~BITS_BACAM_ADDR_8812F))
#define BIT_GET_BACAM_ADDR_8812F(x)                                            \
	(((x) >> BIT_SHIFT_BACAM_ADDR_8812F) & BIT_MASK_BACAM_ADDR_8812F)
#define BIT_SET_BACAM_ADDR_8812F(x, v)                                         \
	(BIT_CLEAR_BACAM_ADDR_8812F(x) | BIT_BACAM_ADDR_8812F(v))

/* 2 REG_BACAMCONTENT_8812F (BLOCK ACK CAM CONTENT REGISTER) */

#define BIT_SHIFT_BA_CONTENT_L_8812F 0
#define BIT_MASK_BA_CONTENT_L_8812F 0xffffffffL
#define BIT_BA_CONTENT_L_8812F(x)                                              \
	(((x) & BIT_MASK_BA_CONTENT_L_8812F) << BIT_SHIFT_BA_CONTENT_L_8812F)
#define BITS_BA_CONTENT_L_8812F                                                \
	(BIT_MASK_BA_CONTENT_L_8812F << BIT_SHIFT_BA_CONTENT_L_8812F)
#define BIT_CLEAR_BA_CONTENT_L_8812F(x) ((x) & (~BITS_BA_CONTENT_L_8812F))
#define BIT_GET_BA_CONTENT_L_8812F(x)                                          \
	(((x) >> BIT_SHIFT_BA_CONTENT_L_8812F) & BIT_MASK_BA_CONTENT_L_8812F)
#define BIT_SET_BA_CONTENT_L_8812F(x, v)                                       \
	(BIT_CLEAR_BA_CONTENT_L_8812F(x) | BIT_BA_CONTENT_L_8812F(v))

/* 2 REG_BACAMCONTENT_H_8812F (BLOCK ACK CAM CONTENT REGISTER) */

#define BIT_SHIFT_BA_CONTENT_H_8812F 0
#define BIT_MASK_BA_CONTENT_H_8812F 0xffffffffL
#define BIT_BA_CONTENT_H_8812F(x)                                              \
	(((x) & BIT_MASK_BA_CONTENT_H_8812F) << BIT_SHIFT_BA_CONTENT_H_8812F)
#define BITS_BA_CONTENT_H_8812F                                                \
	(BIT_MASK_BA_CONTENT_H_8812F << BIT_SHIFT_BA_CONTENT_H_8812F)
#define BIT_CLEAR_BA_CONTENT_H_8812F(x) ((x) & (~BITS_BA_CONTENT_H_8812F))
#define BIT_GET_BA_CONTENT_H_8812F(x)                                          \
	(((x) >> BIT_SHIFT_BA_CONTENT_H_8812F) & BIT_MASK_BA_CONTENT_H_8812F)
#define BIT_SET_BA_CONTENT_H_8812F(x, v)                                       \
	(BIT_CLEAR_BA_CONTENT_H_8812F(x) | BIT_BA_CONTENT_H_8812F(v))

/* 2 REG_LBDLY_8812F (LOOPBACK DELAY REGISTER) */

#define BIT_SHIFT_LBDLY_8812F 0
#define BIT_MASK_LBDLY_8812F 0x1f
#define BIT_LBDLY_8812F(x)                                                     \
	(((x) & BIT_MASK_LBDLY_8812F) << BIT_SHIFT_LBDLY_8812F)
#define BITS_LBDLY_8812F (BIT_MASK_LBDLY_8812F << BIT_SHIFT_LBDLY_8812F)
#define BIT_CLEAR_LBDLY_8812F(x) ((x) & (~BITS_LBDLY_8812F))
#define BIT_GET_LBDLY_8812F(x)                                                 \
	(((x) >> BIT_SHIFT_LBDLY_8812F) & BIT_MASK_LBDLY_8812F)
#define BIT_SET_LBDLY_8812F(x, v)                                              \
	(BIT_CLEAR_LBDLY_8812F(x) | BIT_LBDLY_8812F(v))

/* 2 REG_WMAC_BACAM_RPMEN_8812F */

#define BIT_SHIFT_BITMAP_SSNBK_COUNTER_8812F 2
#define BIT_MASK_BITMAP_SSNBK_COUNTER_8812F 0x3f
#define BIT_BITMAP_SSNBK_COUNTER_8812F(x)                                      \
	(((x) & BIT_MASK_BITMAP_SSNBK_COUNTER_8812F)                           \
	 << BIT_SHIFT_BITMAP_SSNBK_COUNTER_8812F)
#define BITS_BITMAP_SSNBK_COUNTER_8812F                                        \
	(BIT_MASK_BITMAP_SSNBK_COUNTER_8812F                                   \
	 << BIT_SHIFT_BITMAP_SSNBK_COUNTER_8812F)
#define BIT_CLEAR_BITMAP_SSNBK_COUNTER_8812F(x)                                \
	((x) & (~BITS_BITMAP_SSNBK_COUNTER_8812F))
#define BIT_GET_BITMAP_SSNBK_COUNTER_8812F(x)                                  \
	(((x) >> BIT_SHIFT_BITMAP_SSNBK_COUNTER_8812F) &                       \
	 BIT_MASK_BITMAP_SSNBK_COUNTER_8812F)
#define BIT_SET_BITMAP_SSNBK_COUNTER_8812F(x, v)                               \
	(BIT_CLEAR_BITMAP_SSNBK_COUNTER_8812F(x) |                             \
	 BIT_BITMAP_SSNBK_COUNTER_8812F(v))

#define BIT_BITMAP_EN_8812F BIT(1)
#define BIT_WMAC_BACAM_RPMEN_8812F BIT(0)

/* 2 REG_TX_RX_8812F STATUS */

#define BIT_SHIFT_RXPKT_TYPE_8812F 2
#define BIT_MASK_RXPKT_TYPE_8812F 0x3f
#define BIT_RXPKT_TYPE_8812F(x)                                                \
	(((x) & BIT_MASK_RXPKT_TYPE_8812F) << BIT_SHIFT_RXPKT_TYPE_8812F)
#define BITS_RXPKT_TYPE_8812F                                                  \
	(BIT_MASK_RXPKT_TYPE_8812F << BIT_SHIFT_RXPKT_TYPE_8812F)
#define BIT_CLEAR_RXPKT_TYPE_8812F(x) ((x) & (~BITS_RXPKT_TYPE_8812F))
#define BIT_GET_RXPKT_TYPE_8812F(x)                                            \
	(((x) >> BIT_SHIFT_RXPKT_TYPE_8812F) & BIT_MASK_RXPKT_TYPE_8812F)
#define BIT_SET_RXPKT_TYPE_8812F(x, v)                                         \
	(BIT_CLEAR_RXPKT_TYPE_8812F(x) | BIT_RXPKT_TYPE_8812F(v))

#define BIT_TXACT_IND_8812F BIT(1)
#define BIT_RXACT_IND_8812F BIT(0)

/* 2 REG_WMAC_BITMAP_CTL_8812F */
#define BIT_BITMAP_VO_8812F BIT(7)
#define BIT_BITMAP_VI_8812F BIT(6)
#define BIT_BITMAP_BE_8812F BIT(5)
#define BIT_BITMAP_BK_8812F BIT(4)

#define BIT_SHIFT_BITMAP_CONDITION_8812F 2
#define BIT_MASK_BITMAP_CONDITION_8812F 0x3
#define BIT_BITMAP_CONDITION_8812F(x)                                          \
	(((x) & BIT_MASK_BITMAP_CONDITION_8812F)                               \
	 << BIT_SHIFT_BITMAP_CONDITION_8812F)
#define BITS_BITMAP_CONDITION_8812F                                            \
	(BIT_MASK_BITMAP_CONDITION_8812F << BIT_SHIFT_BITMAP_CONDITION_8812F)
#define BIT_CLEAR_BITMAP_CONDITION_8812F(x)                                    \
	((x) & (~BITS_BITMAP_CONDITION_8812F))
#define BIT_GET_BITMAP_CONDITION_8812F(x)                                      \
	(((x) >> BIT_SHIFT_BITMAP_CONDITION_8812F) &                           \
	 BIT_MASK_BITMAP_CONDITION_8812F)
#define BIT_SET_BITMAP_CONDITION_8812F(x, v)                                   \
	(BIT_CLEAR_BITMAP_CONDITION_8812F(x) | BIT_BITMAP_CONDITION_8812F(v))

#define BIT_BITMAP_SSNBK_COUNTER_CLR_8812F BIT(1)
#define BIT_BITMAP_FORCE_8812F BIT(0)

/* 2 REG_RXERR_RPT_8812F (RX ERROR REPORT REGISTER) */

#define BIT_SHIFT_RXERR_RPT_SEL_V1_3_0_8812F 28
#define BIT_MASK_RXERR_RPT_SEL_V1_3_0_8812F 0xf
#define BIT_RXERR_RPT_SEL_V1_3_0_8812F(x)                                      \
	(((x) & BIT_MASK_RXERR_RPT_SEL_V1_3_0_8812F)                           \
	 << BIT_SHIFT_RXERR_RPT_SEL_V1_3_0_8812F)
#define BITS_RXERR_RPT_SEL_V1_3_0_8812F                                        \
	(BIT_MASK_RXERR_RPT_SEL_V1_3_0_8812F                                   \
	 << BIT_SHIFT_RXERR_RPT_SEL_V1_3_0_8812F)
#define BIT_CLEAR_RXERR_RPT_SEL_V1_3_0_8812F(x)                                \
	((x) & (~BITS_RXERR_RPT_SEL_V1_3_0_8812F))
#define BIT_GET_RXERR_RPT_SEL_V1_3_0_8812F(x)                                  \
	(((x) >> BIT_SHIFT_RXERR_RPT_SEL_V1_3_0_8812F) &                       \
	 BIT_MASK_RXERR_RPT_SEL_V1_3_0_8812F)
#define BIT_SET_RXERR_RPT_SEL_V1_3_0_8812F(x, v)                               \
	(BIT_CLEAR_RXERR_RPT_SEL_V1_3_0_8812F(x) |                             \
	 BIT_RXERR_RPT_SEL_V1_3_0_8812F(v))

#define BIT_RXERR_RPT_RST_8812F BIT(27)
#define BIT_RXERR_RPT_SEL_V1_4_8812F BIT(26)

#define BIT_SHIFT_UD_SELECT_BSSID_2_1_8812F 24
#define BIT_MASK_UD_SELECT_BSSID_2_1_8812F 0x3
#define BIT_UD_SELECT_BSSID_2_1_8812F(x)                                       \
	(((x) & BIT_MASK_UD_SELECT_BSSID_2_1_8812F)                            \
	 << BIT_SHIFT_UD_SELECT_BSSID_2_1_8812F)
#define BITS_UD_SELECT_BSSID_2_1_8812F                                         \
	(BIT_MASK_UD_SELECT_BSSID_2_1_8812F                                    \
	 << BIT_SHIFT_UD_SELECT_BSSID_2_1_8812F)
#define BIT_CLEAR_UD_SELECT_BSSID_2_1_8812F(x)                                 \
	((x) & (~BITS_UD_SELECT_BSSID_2_1_8812F))
#define BIT_GET_UD_SELECT_BSSID_2_1_8812F(x)                                   \
	(((x) >> BIT_SHIFT_UD_SELECT_BSSID_2_1_8812F) &                        \
	 BIT_MASK_UD_SELECT_BSSID_2_1_8812F)
#define BIT_SET_UD_SELECT_BSSID_2_1_8812F(x, v)                                \
	(BIT_CLEAR_UD_SELECT_BSSID_2_1_8812F(x) |                              \
	 BIT_UD_SELECT_BSSID_2_1_8812F(v))

#define BIT_W1S_8812F BIT(23)
#define BIT_UD_SELECT_BSSID_0_8812F BIT(22)

#define BIT_SHIFT_UD_SUB_TYPE_8812F 18
#define BIT_MASK_UD_SUB_TYPE_8812F 0xf
#define BIT_UD_SUB_TYPE_8812F(x)                                               \
	(((x) & BIT_MASK_UD_SUB_TYPE_8812F) << BIT_SHIFT_UD_SUB_TYPE_8812F)
#define BITS_UD_SUB_TYPE_8812F                                                 \
	(BIT_MASK_UD_SUB_TYPE_8812F << BIT_SHIFT_UD_SUB_TYPE_8812F)
#define BIT_CLEAR_UD_SUB_TYPE_8812F(x) ((x) & (~BITS_UD_SUB_TYPE_8812F))
#define BIT_GET_UD_SUB_TYPE_8812F(x)                                           \
	(((x) >> BIT_SHIFT_UD_SUB_TYPE_8812F) & BIT_MASK_UD_SUB_TYPE_8812F)
#define BIT_SET_UD_SUB_TYPE_8812F(x, v)                                        \
	(BIT_CLEAR_UD_SUB_TYPE_8812F(x) | BIT_UD_SUB_TYPE_8812F(v))

#define BIT_SHIFT_UD_TYPE_8812F 16
#define BIT_MASK_UD_TYPE_8812F 0x3
#define BIT_UD_TYPE_8812F(x)                                                   \
	(((x) & BIT_MASK_UD_TYPE_8812F) << BIT_SHIFT_UD_TYPE_8812F)
#define BITS_UD_TYPE_8812F (BIT_MASK_UD_TYPE_8812F << BIT_SHIFT_UD_TYPE_8812F)
#define BIT_CLEAR_UD_TYPE_8812F(x) ((x) & (~BITS_UD_TYPE_8812F))
#define BIT_GET_UD_TYPE_8812F(x)                                               \
	(((x) >> BIT_SHIFT_UD_TYPE_8812F) & BIT_MASK_UD_TYPE_8812F)
#define BIT_SET_UD_TYPE_8812F(x, v)                                            \
	(BIT_CLEAR_UD_TYPE_8812F(x) | BIT_UD_TYPE_8812F(v))

#define BIT_SHIFT_RPT_COUNTER_8812F 0
#define BIT_MASK_RPT_COUNTER_8812F 0xffff
#define BIT_RPT_COUNTER_8812F(x)                                               \
	(((x) & BIT_MASK_RPT_COUNTER_8812F) << BIT_SHIFT_RPT_COUNTER_8812F)
#define BITS_RPT_COUNTER_8812F                                                 \
	(BIT_MASK_RPT_COUNTER_8812F << BIT_SHIFT_RPT_COUNTER_8812F)
#define BIT_CLEAR_RPT_COUNTER_8812F(x) ((x) & (~BITS_RPT_COUNTER_8812F))
#define BIT_GET_RPT_COUNTER_8812F(x)                                           \
	(((x) >> BIT_SHIFT_RPT_COUNTER_8812F) & BIT_MASK_RPT_COUNTER_8812F)
#define BIT_SET_RPT_COUNTER_8812F(x, v)                                        \
	(BIT_CLEAR_RPT_COUNTER_8812F(x) | BIT_RPT_COUNTER_8812F(v))

/* 2 REG_WMAC_TRXPTCL_CTL_8812F	(WMAC TX/RX PROTOCOL CONTROL REGISTER) */
#define BIT_ACKTO_BLOCK_SCH_EN_8812F BIT(27)
#define BIT_EIFS_BLOCK_SCH_EN_8812F BIT(26)
#define BIT_PLCPCHK_RST_EIFS_8812F BIT(25)
#define BIT_CCA_RST_EIFS_8812F BIT(24)
#define BIT_DIS_UPD_MYRXPKTNAV_8812F BIT(23)
#define BIT_EARLY_TXBA_8812F BIT(22)

#define BIT_SHIFT_RESP_CHNBUSY_8812F 20
#define BIT_MASK_RESP_CHNBUSY_8812F 0x3
#define BIT_RESP_CHNBUSY_8812F(x)                                              \
	(((x) & BIT_MASK_RESP_CHNBUSY_8812F) << BIT_SHIFT_RESP_CHNBUSY_8812F)
#define BITS_RESP_CHNBUSY_8812F                                                \
	(BIT_MASK_RESP_CHNBUSY_8812F << BIT_SHIFT_RESP_CHNBUSY_8812F)
#define BIT_CLEAR_RESP_CHNBUSY_8812F(x) ((x) & (~BITS_RESP_CHNBUSY_8812F))
#define BIT_GET_RESP_CHNBUSY_8812F(x)                                          \
	(((x) >> BIT_SHIFT_RESP_CHNBUSY_8812F) & BIT_MASK_RESP_CHNBUSY_8812F)
#define BIT_SET_RESP_CHNBUSY_8812F(x, v)                                       \
	(BIT_CLEAR_RESP_CHNBUSY_8812F(x) | BIT_RESP_CHNBUSY_8812F(v))

#define BIT_RESP_DCTS_EN_8812F BIT(19)
#define BIT_RESP_DCFE_EN_8812F BIT(18)
#define BIT_RESP_SPLCPEN_8812F BIT(17)
#define BIT_RESP_SGIEN_8812F BIT(16)
#define BIT_RESP_LDPC_EN_8812F BIT(15)
#define BIT_DIS_RESP_ACKINCCA_8812F BIT(14)
#define BIT_DIS_RESP_CTSINCCA_8812F BIT(13)

#define BIT_SHIFT_R_WMAC_SECOND_CCA_TIMER_8812F 10
#define BIT_MASK_R_WMAC_SECOND_CCA_TIMER_8812F 0x7
#define BIT_R_WMAC_SECOND_CCA_TIMER_8812F(x)                                   \
	(((x) & BIT_MASK_R_WMAC_SECOND_CCA_TIMER_8812F)                        \
	 << BIT_SHIFT_R_WMAC_SECOND_CCA_TIMER_8812F)
#define BITS_R_WMAC_SECOND_CCA_TIMER_8812F                                     \
	(BIT_MASK_R_WMAC_SECOND_CCA_TIMER_8812F                                \
	 << BIT_SHIFT_R_WMAC_SECOND_CCA_TIMER_8812F)
#define BIT_CLEAR_R_WMAC_SECOND_CCA_TIMER_8812F(x)                             \
	((x) & (~BITS_R_WMAC_SECOND_CCA_TIMER_8812F))
#define BIT_GET_R_WMAC_SECOND_CCA_TIMER_8812F(x)                               \
	(((x) >> BIT_SHIFT_R_WMAC_SECOND_CCA_TIMER_8812F) &                    \
	 BIT_MASK_R_WMAC_SECOND_CCA_TIMER_8812F)
#define BIT_SET_R_WMAC_SECOND_CCA_TIMER_8812F(x, v)                            \
	(BIT_CLEAR_R_WMAC_SECOND_CCA_TIMER_8812F(x) |                          \
	 BIT_R_WMAC_SECOND_CCA_TIMER_8812F(v))

#define BIT_SHIFT_RFMOD_8812F 7
#define BIT_MASK_RFMOD_8812F 0x3
#define BIT_RFMOD_8812F(x)                                                     \
	(((x) & BIT_MASK_RFMOD_8812F) << BIT_SHIFT_RFMOD_8812F)
#define BITS_RFMOD_8812F (BIT_MASK_RFMOD_8812F << BIT_SHIFT_RFMOD_8812F)
#define BIT_CLEAR_RFMOD_8812F(x) ((x) & (~BITS_RFMOD_8812F))
#define BIT_GET_RFMOD_8812F(x)                                                 \
	(((x) >> BIT_SHIFT_RFMOD_8812F) & BIT_MASK_RFMOD_8812F)
#define BIT_SET_RFMOD_8812F(x, v)                                              \
	(BIT_CLEAR_RFMOD_8812F(x) | BIT_RFMOD_8812F(v))

#define BIT_SHIFT_RESP_CTS_DYNBW_SEL_8812F 5
#define BIT_MASK_RESP_CTS_DYNBW_SEL_8812F 0x3
#define BIT_RESP_CTS_DYNBW_SEL_8812F(x)                                        \
	(((x) & BIT_MASK_RESP_CTS_DYNBW_SEL_8812F)                             \
	 << BIT_SHIFT_RESP_CTS_DYNBW_SEL_8812F)
#define BITS_RESP_CTS_DYNBW_SEL_8812F                                          \
	(BIT_MASK_RESP_CTS_DYNBW_SEL_8812F                                     \
	 << BIT_SHIFT_RESP_CTS_DYNBW_SEL_8812F)
#define BIT_CLEAR_RESP_CTS_DYNBW_SEL_8812F(x)                                  \
	((x) & (~BITS_RESP_CTS_DYNBW_SEL_8812F))
#define BIT_GET_RESP_CTS_DYNBW_SEL_8812F(x)                                    \
	(((x) >> BIT_SHIFT_RESP_CTS_DYNBW_SEL_8812F) &                         \
	 BIT_MASK_RESP_CTS_DYNBW_SEL_8812F)
#define BIT_SET_RESP_CTS_DYNBW_SEL_8812F(x, v)                                 \
	(BIT_CLEAR_RESP_CTS_DYNBW_SEL_8812F(x) |                               \
	 BIT_RESP_CTS_DYNBW_SEL_8812F(v))

#define BIT_DLY_TX_WAIT_RXANTSEL_8812F BIT(4)
#define BIT_TXRESP_BY_RXANTSEL_8812F BIT(3)

#define BIT_SHIFT_ORIG_DCTS_CHK_8812F 0
#define BIT_MASK_ORIG_DCTS_CHK_8812F 0x3
#define BIT_ORIG_DCTS_CHK_8812F(x)                                             \
	(((x) & BIT_MASK_ORIG_DCTS_CHK_8812F) << BIT_SHIFT_ORIG_DCTS_CHK_8812F)
#define BITS_ORIG_DCTS_CHK_8812F                                               \
	(BIT_MASK_ORIG_DCTS_CHK_8812F << BIT_SHIFT_ORIG_DCTS_CHK_8812F)
#define BIT_CLEAR_ORIG_DCTS_CHK_8812F(x) ((x) & (~BITS_ORIG_DCTS_CHK_8812F))
#define BIT_GET_ORIG_DCTS_CHK_8812F(x)                                         \
	(((x) >> BIT_SHIFT_ORIG_DCTS_CHK_8812F) & BIT_MASK_ORIG_DCTS_CHK_8812F)
#define BIT_SET_ORIG_DCTS_CHK_8812F(x, v)                                      \
	(BIT_CLEAR_ORIG_DCTS_CHK_8812F(x) | BIT_ORIG_DCTS_CHK_8812F(v))

/* 2 REG_WMAC_TRXPTCL_CTL_H_8812F */

#define BIT_SHIFT_ACKBA_TYPSEL_8812F 28
#define BIT_MASK_ACKBA_TYPSEL_8812F 0xf
#define BIT_ACKBA_TYPSEL_8812F(x)                                              \
	(((x) & BIT_MASK_ACKBA_TYPSEL_8812F) << BIT_SHIFT_ACKBA_TYPSEL_8812F)
#define BITS_ACKBA_TYPSEL_8812F                                                \
	(BIT_MASK_ACKBA_TYPSEL_8812F << BIT_SHIFT_ACKBA_TYPSEL_8812F)
#define BIT_CLEAR_ACKBA_TYPSEL_8812F(x) ((x) & (~BITS_ACKBA_TYPSEL_8812F))
#define BIT_GET_ACKBA_TYPSEL_8812F(x)                                          \
	(((x) >> BIT_SHIFT_ACKBA_TYPSEL_8812F) & BIT_MASK_ACKBA_TYPSEL_8812F)
#define BIT_SET_ACKBA_TYPSEL_8812F(x, v)                                       \
	(BIT_CLEAR_ACKBA_TYPSEL_8812F(x) | BIT_ACKBA_TYPSEL_8812F(v))

#define BIT_SHIFT_ACKBA_ACKPCHK_8812F 24
#define BIT_MASK_ACKBA_ACKPCHK_8812F 0xf
#define BIT_ACKBA_ACKPCHK_8812F(x)                                             \
	(((x) & BIT_MASK_ACKBA_ACKPCHK_8812F) << BIT_SHIFT_ACKBA_ACKPCHK_8812F)
#define BITS_ACKBA_ACKPCHK_8812F                                               \
	(BIT_MASK_ACKBA_ACKPCHK_8812F << BIT_SHIFT_ACKBA_ACKPCHK_8812F)
#define BIT_CLEAR_ACKBA_ACKPCHK_8812F(x) ((x) & (~BITS_ACKBA_ACKPCHK_8812F))
#define BIT_GET_ACKBA_ACKPCHK_8812F(x)                                         \
	(((x) >> BIT_SHIFT_ACKBA_ACKPCHK_8812F) & BIT_MASK_ACKBA_ACKPCHK_8812F)
#define BIT_SET_ACKBA_ACKPCHK_8812F(x, v)                                      \
	(BIT_CLEAR_ACKBA_ACKPCHK_8812F(x) | BIT_ACKBA_ACKPCHK_8812F(v))

#define BIT_SHIFT_ACKBAR_TYPESEL_8812F 16
#define BIT_MASK_ACKBAR_TYPESEL_8812F 0xff
#define BIT_ACKBAR_TYPESEL_8812F(x)                                            \
	(((x) & BIT_MASK_ACKBAR_TYPESEL_8812F)                                 \
	 << BIT_SHIFT_ACKBAR_TYPESEL_8812F)
#define BITS_ACKBAR_TYPESEL_8812F                                              \
	(BIT_MASK_ACKBAR_TYPESEL_8812F << BIT_SHIFT_ACKBAR_TYPESEL_8812F)
#define BIT_CLEAR_ACKBAR_TYPESEL_8812F(x) ((x) & (~BITS_ACKBAR_TYPESEL_8812F))
#define BIT_GET_ACKBAR_TYPESEL_8812F(x)                                        \
	(((x) >> BIT_SHIFT_ACKBAR_TYPESEL_8812F) &                             \
	 BIT_MASK_ACKBAR_TYPESEL_8812F)
#define BIT_SET_ACKBAR_TYPESEL_8812F(x, v)                                     \
	(BIT_CLEAR_ACKBAR_TYPESEL_8812F(x) | BIT_ACKBAR_TYPESEL_8812F(v))

#define BIT_SHIFT_ACKBAR_ACKPCHK_8812F 12
#define BIT_MASK_ACKBAR_ACKPCHK_8812F 0xf
#define BIT_ACKBAR_ACKPCHK_8812F(x)                                            \
	(((x) & BIT_MASK_ACKBAR_ACKPCHK_8812F)                                 \
	 << BIT_SHIFT_ACKBAR_ACKPCHK_8812F)
#define BITS_ACKBAR_ACKPCHK_8812F                                              \
	(BIT_MASK_ACKBAR_ACKPCHK_8812F << BIT_SHIFT_ACKBAR_ACKPCHK_8812F)
#define BIT_CLEAR_ACKBAR_ACKPCHK_8812F(x) ((x) & (~BITS_ACKBAR_ACKPCHK_8812F))
#define BIT_GET_ACKBAR_ACKPCHK_8812F(x)                                        \
	(((x) >> BIT_SHIFT_ACKBAR_ACKPCHK_8812F) &                             \
	 BIT_MASK_ACKBAR_ACKPCHK_8812F)
#define BIT_SET_ACKBAR_ACKPCHK_8812F(x, v)                                     \
	(BIT_CLEAR_ACKBAR_ACKPCHK_8812F(x) | BIT_ACKBAR_ACKPCHK_8812F(v))

#define BIT_RXBA_IGNOREA2_V1_8812F BIT(10)
#define BIT_EN_SAVE_ALL_TXOPADDR_V1_8812F BIT(9)
#define BIT_EN_TXCTS_TO_TXOPOWNER_INRXNAV_V1_8812F BIT(8)
#define BIT_DIS_TXBA_AMPDUFCSERR_V1_8812F BIT(7)
#define BIT_DIS_TXBA_RXBARINFULL_V1_8812F BIT(6)
#define BIT_DIS_TXCFE_INFULL_V1_8812F BIT(5)
#define BIT_DIS_TXCTS_INFULL_V1_8812F BIT(4)
#define BIT_EN_TXACKBA_IN_TX_RDG_V1_8812F BIT(3)
#define BIT_EN_TXACKBA_IN_TXOP_V1_8812F BIT(2)
#define BIT_EN_TXCTS_IN_RXNAV_V1_8812F BIT(1)
#define BIT_EN_TXCTS_INTXOP_V1_8812F BIT(0)

/* 2 REG_CAMCMD_8812F (CAM COMMAND REGISTER) */
#define BIT_SECCAM_POLLING_8812F BIT(31)
#define BIT_SECCAM_CLR_8812F BIT(30)
#define BIT_SECCAM_WE_8812F BIT(16)

#define BIT_SHIFT_SECCAM_ADDR_V2_8812F 0
#define BIT_MASK_SECCAM_ADDR_V2_8812F 0x3ff
#define BIT_SECCAM_ADDR_V2_8812F(x)                                            \
	(((x) & BIT_MASK_SECCAM_ADDR_V2_8812F)                                 \
	 << BIT_SHIFT_SECCAM_ADDR_V2_8812F)
#define BITS_SECCAM_ADDR_V2_8812F                                              \
	(BIT_MASK_SECCAM_ADDR_V2_8812F << BIT_SHIFT_SECCAM_ADDR_V2_8812F)
#define BIT_CLEAR_SECCAM_ADDR_V2_8812F(x) ((x) & (~BITS_SECCAM_ADDR_V2_8812F))
#define BIT_GET_SECCAM_ADDR_V2_8812F(x)                                        \
	(((x) >> BIT_SHIFT_SECCAM_ADDR_V2_8812F) &                             \
	 BIT_MASK_SECCAM_ADDR_V2_8812F)
#define BIT_SET_SECCAM_ADDR_V2_8812F(x, v)                                     \
	(BIT_CLEAR_SECCAM_ADDR_V2_8812F(x) | BIT_SECCAM_ADDR_V2_8812F(v))

/* 2 REG_CAMWRITE_8812F (CAM WRITE REGISTER) */

#define BIT_SHIFT_CAMW_DATA_8812F 0
#define BIT_MASK_CAMW_DATA_8812F 0xffffffffL
#define BIT_CAMW_DATA_8812F(x)                                                 \
	(((x) & BIT_MASK_CAMW_DATA_8812F) << BIT_SHIFT_CAMW_DATA_8812F)
#define BITS_CAMW_DATA_8812F                                                   \
	(BIT_MASK_CAMW_DATA_8812F << BIT_SHIFT_CAMW_DATA_8812F)
#define BIT_CLEAR_CAMW_DATA_8812F(x) ((x) & (~BITS_CAMW_DATA_8812F))
#define BIT_GET_CAMW_DATA_8812F(x)                                             \
	(((x) >> BIT_SHIFT_CAMW_DATA_8812F) & BIT_MASK_CAMW_DATA_8812F)
#define BIT_SET_CAMW_DATA_8812F(x, v)                                          \
	(BIT_CLEAR_CAMW_DATA_8812F(x) | BIT_CAMW_DATA_8812F(v))

/* 2 REG_CAMREAD_8812F (CAM READ REGISTER) */

#define BIT_SHIFT_CAMR_DATA_8812F 0
#define BIT_MASK_CAMR_DATA_8812F 0xffffffffL
#define BIT_CAMR_DATA_8812F(x)                                                 \
	(((x) & BIT_MASK_CAMR_DATA_8812F) << BIT_SHIFT_CAMR_DATA_8812F)
#define BITS_CAMR_DATA_8812F                                                   \
	(BIT_MASK_CAMR_DATA_8812F << BIT_SHIFT_CAMR_DATA_8812F)
#define BIT_CLEAR_CAMR_DATA_8812F(x) ((x) & (~BITS_CAMR_DATA_8812F))
#define BIT_GET_CAMR_DATA_8812F(x)                                             \
	(((x) >> BIT_SHIFT_CAMR_DATA_8812F) & BIT_MASK_CAMR_DATA_8812F)
#define BIT_SET_CAMR_DATA_8812F(x, v)                                          \
	(BIT_CLEAR_CAMR_DATA_8812F(x) | BIT_CAMR_DATA_8812F(v))

/* 2 REG_CAMDBG_8812F (CAM DEBUG REGISTER) */
#define BIT_SECCAM_INFO_8812F BIT(31)
#define BIT_SEC_KEYFOUND_8812F BIT(15)

#define BIT_SHIFT_CAMDBG_SEC_TYPE_8812F 12
#define BIT_MASK_CAMDBG_SEC_TYPE_8812F 0x7
#define BIT_CAMDBG_SEC_TYPE_8812F(x)                                           \
	(((x) & BIT_MASK_CAMDBG_SEC_TYPE_8812F)                                \
	 << BIT_SHIFT_CAMDBG_SEC_TYPE_8812F)
#define BITS_CAMDBG_SEC_TYPE_8812F                                             \
	(BIT_MASK_CAMDBG_SEC_TYPE_8812F << BIT_SHIFT_CAMDBG_SEC_TYPE_8812F)
#define BIT_CLEAR_CAMDBG_SEC_TYPE_8812F(x) ((x) & (~BITS_CAMDBG_SEC_TYPE_8812F))
#define BIT_GET_CAMDBG_SEC_TYPE_8812F(x)                                       \
	(((x) >> BIT_SHIFT_CAMDBG_SEC_TYPE_8812F) &                            \
	 BIT_MASK_CAMDBG_SEC_TYPE_8812F)
#define BIT_SET_CAMDBG_SEC_TYPE_8812F(x, v)                                    \
	(BIT_CLEAR_CAMDBG_SEC_TYPE_8812F(x) | BIT_CAMDBG_SEC_TYPE_8812F(v))

#define BIT_CAMDBG_EXT_SECTYPE_8812F BIT(11)

#define BIT_SHIFT_CAMDBG_MIC_KEY_IDX_8812F 5
#define BIT_MASK_CAMDBG_MIC_KEY_IDX_8812F 0x1f
#define BIT_CAMDBG_MIC_KEY_IDX_8812F(x)                                        \
	(((x) & BIT_MASK_CAMDBG_MIC_KEY_IDX_8812F)                             \
	 << BIT_SHIFT_CAMDBG_MIC_KEY_IDX_8812F)
#define BITS_CAMDBG_MIC_KEY_IDX_8812F                                          \
	(BIT_MASK_CAMDBG_MIC_KEY_IDX_8812F                                     \
	 << BIT_SHIFT_CAMDBG_MIC_KEY_IDX_8812F)
#define BIT_CLEAR_CAMDBG_MIC_KEY_IDX_8812F(x)                                  \
	((x) & (~BITS_CAMDBG_MIC_KEY_IDX_8812F))
#define BIT_GET_CAMDBG_MIC_KEY_IDX_8812F(x)                                    \
	(((x) >> BIT_SHIFT_CAMDBG_MIC_KEY_IDX_8812F) &                         \
	 BIT_MASK_CAMDBG_MIC_KEY_IDX_8812F)
#define BIT_SET_CAMDBG_MIC_KEY_IDX_8812F(x, v)                                 \
	(BIT_CLEAR_CAMDBG_MIC_KEY_IDX_8812F(x) |                               \
	 BIT_CAMDBG_MIC_KEY_IDX_8812F(v))

#define BIT_SHIFT_CAMDBG_SEC_KEY_IDX_8812F 0
#define BIT_MASK_CAMDBG_SEC_KEY_IDX_8812F 0x1f
#define BIT_CAMDBG_SEC_KEY_IDX_8812F(x)                                        \
	(((x) & BIT_MASK_CAMDBG_SEC_KEY_IDX_8812F)                             \
	 << BIT_SHIFT_CAMDBG_SEC_KEY_IDX_8812F)
#define BITS_CAMDBG_SEC_KEY_IDX_8812F                                          \
	(BIT_MASK_CAMDBG_SEC_KEY_IDX_8812F                                     \
	 << BIT_SHIFT_CAMDBG_SEC_KEY_IDX_8812F)
#define BIT_CLEAR_CAMDBG_SEC_KEY_IDX_8812F(x)                                  \
	((x) & (~BITS_CAMDBG_SEC_KEY_IDX_8812F))
#define BIT_GET_CAMDBG_SEC_KEY_IDX_8812F(x)                                    \
	(((x) >> BIT_SHIFT_CAMDBG_SEC_KEY_IDX_8812F) &                         \
	 BIT_MASK_CAMDBG_SEC_KEY_IDX_8812F)
#define BIT_SET_CAMDBG_SEC_KEY_IDX_8812F(x, v)                                 \
	(BIT_CLEAR_CAMDBG_SEC_KEY_IDX_8812F(x) |                               \
	 BIT_CAMDBG_SEC_KEY_IDX_8812F(v))

/* 2 REG_SECCFG_8812F (SECURITY CONFIGURATION REGISTER) */
#define BIT_DIS_GCLK_WAPI_8812F BIT(15)
#define BIT_DIS_GCLK_AES_8812F BIT(14)
#define BIT_DIS_GCLK_TKIP_8812F BIT(13)
#define BIT_AES_SEL_QC_1_8812F BIT(12)
#define BIT_AES_SEL_QC_0_8812F BIT(11)
#define BIT_CHK_BMC_8812F BIT(9)
#define BIT_CHK_KEYID_8812F BIT(8)
#define BIT_RXBCUSEDK_8812F BIT(7)
#define BIT_TXBCUSEDK_8812F BIT(6)
#define BIT_NOSKMC_8812F BIT(5)
#define BIT_SKBYA2_8812F BIT(4)
#define BIT_RXDEC_8812F BIT(3)
#define BIT_TXENC_8812F BIT(2)
#define BIT_RXUHUSEDK_8812F BIT(1)
#define BIT_TXUHUSEDK_8812F BIT(0)

/* 2 REG_RXFILTER_CATEGORY_1_8812F */

#define BIT_SHIFT_RXFILTER_CATEGORY_1_8812F 0
#define BIT_MASK_RXFILTER_CATEGORY_1_8812F 0xff
#define BIT_RXFILTER_CATEGORY_1_8812F(x)                                       \
	(((x) & BIT_MASK_RXFILTER_CATEGORY_1_8812F)                            \
	 << BIT_SHIFT_RXFILTER_CATEGORY_1_8812F)
#define BITS_RXFILTER_CATEGORY_1_8812F                                         \
	(BIT_MASK_RXFILTER_CATEGORY_1_8812F                                    \
	 << BIT_SHIFT_RXFILTER_CATEGORY_1_8812F)
#define BIT_CLEAR_RXFILTER_CATEGORY_1_8812F(x)                                 \
	((x) & (~BITS_RXFILTER_CATEGORY_1_8812F))
#define BIT_GET_RXFILTER_CATEGORY_1_8812F(x)                                   \
	(((x) >> BIT_SHIFT_RXFILTER_CATEGORY_1_8812F) &                        \
	 BIT_MASK_RXFILTER_CATEGORY_1_8812F)
#define BIT_SET_RXFILTER_CATEGORY_1_8812F(x, v)                                \
	(BIT_CLEAR_RXFILTER_CATEGORY_1_8812F(x) |                              \
	 BIT_RXFILTER_CATEGORY_1_8812F(v))

/* 2 REG_RXFILTER_ACTION_1_8812F */

#define BIT_SHIFT_RXFILTER_ACTION_1_8812F 0
#define BIT_MASK_RXFILTER_ACTION_1_8812F 0xff
#define BIT_RXFILTER_ACTION_1_8812F(x)                                         \
	(((x) & BIT_MASK_RXFILTER_ACTION_1_8812F)                              \
	 << BIT_SHIFT_RXFILTER_ACTION_1_8812F)
#define BITS_RXFILTER_ACTION_1_8812F                                           \
	(BIT_MASK_RXFILTER_ACTION_1_8812F << BIT_SHIFT_RXFILTER_ACTION_1_8812F)
#define BIT_CLEAR_RXFILTER_ACTION_1_8812F(x)                                   \
	((x) & (~BITS_RXFILTER_ACTION_1_8812F))
#define BIT_GET_RXFILTER_ACTION_1_8812F(x)                                     \
	(((x) >> BIT_SHIFT_RXFILTER_ACTION_1_8812F) &                          \
	 BIT_MASK_RXFILTER_ACTION_1_8812F)
#define BIT_SET_RXFILTER_ACTION_1_8812F(x, v)                                  \
	(BIT_CLEAR_RXFILTER_ACTION_1_8812F(x) | BIT_RXFILTER_ACTION_1_8812F(v))

/* 2 REG_RXFILTER_CATEGORY_2_8812F */

#define BIT_SHIFT_RXFILTER_CATEGORY_2_8812F 0
#define BIT_MASK_RXFILTER_CATEGORY_2_8812F 0xff
#define BIT_RXFILTER_CATEGORY_2_8812F(x)                                       \
	(((x) & BIT_MASK_RXFILTER_CATEGORY_2_8812F)                            \
	 << BIT_SHIFT_RXFILTER_CATEGORY_2_8812F)
#define BITS_RXFILTER_CATEGORY_2_8812F                                         \
	(BIT_MASK_RXFILTER_CATEGORY_2_8812F                                    \
	 << BIT_SHIFT_RXFILTER_CATEGORY_2_8812F)
#define BIT_CLEAR_RXFILTER_CATEGORY_2_8812F(x)                                 \
	((x) & (~BITS_RXFILTER_CATEGORY_2_8812F))
#define BIT_GET_RXFILTER_CATEGORY_2_8812F(x)                                   \
	(((x) >> BIT_SHIFT_RXFILTER_CATEGORY_2_8812F) &                        \
	 BIT_MASK_RXFILTER_CATEGORY_2_8812F)
#define BIT_SET_RXFILTER_CATEGORY_2_8812F(x, v)                                \
	(BIT_CLEAR_RXFILTER_CATEGORY_2_8812F(x) |                              \
	 BIT_RXFILTER_CATEGORY_2_8812F(v))

/* 2 REG_RXFILTER_ACTION_2_8812F */

#define BIT_SHIFT_RXFILTER_ACTION_2_8812F 0
#define BIT_MASK_RXFILTER_ACTION_2_8812F 0xff
#define BIT_RXFILTER_ACTION_2_8812F(x)                                         \
	(((x) & BIT_MASK_RXFILTER_ACTION_2_8812F)                              \
	 << BIT_SHIFT_RXFILTER_ACTION_2_8812F)
#define BITS_RXFILTER_ACTION_2_8812F                                           \
	(BIT_MASK_RXFILTER_ACTION_2_8812F << BIT_SHIFT_RXFILTER_ACTION_2_8812F)
#define BIT_CLEAR_RXFILTER_ACTION_2_8812F(x)                                   \
	((x) & (~BITS_RXFILTER_ACTION_2_8812F))
#define BIT_GET_RXFILTER_ACTION_2_8812F(x)                                     \
	(((x) >> BIT_SHIFT_RXFILTER_ACTION_2_8812F) &                          \
	 BIT_MASK_RXFILTER_ACTION_2_8812F)
#define BIT_SET_RXFILTER_ACTION_2_8812F(x, v)                                  \
	(BIT_CLEAR_RXFILTER_ACTION_2_8812F(x) | BIT_RXFILTER_ACTION_2_8812F(v))

/* 2 REG_RXFILTER_CATEGORY_3_8812F */

#define BIT_SHIFT_RXFILTER_CATEGORY_3_8812F 0
#define BIT_MASK_RXFILTER_CATEGORY_3_8812F 0xff
#define BIT_RXFILTER_CATEGORY_3_8812F(x)                                       \
	(((x) & BIT_MASK_RXFILTER_CATEGORY_3_8812F)                            \
	 << BIT_SHIFT_RXFILTER_CATEGORY_3_8812F)
#define BITS_RXFILTER_CATEGORY_3_8812F                                         \
	(BIT_MASK_RXFILTER_CATEGORY_3_8812F                                    \
	 << BIT_SHIFT_RXFILTER_CATEGORY_3_8812F)
#define BIT_CLEAR_RXFILTER_CATEGORY_3_8812F(x)                                 \
	((x) & (~BITS_RXFILTER_CATEGORY_3_8812F))
#define BIT_GET_RXFILTER_CATEGORY_3_8812F(x)                                   \
	(((x) >> BIT_SHIFT_RXFILTER_CATEGORY_3_8812F) &                        \
	 BIT_MASK_RXFILTER_CATEGORY_3_8812F)
#define BIT_SET_RXFILTER_CATEGORY_3_8812F(x, v)                                \
	(BIT_CLEAR_RXFILTER_CATEGORY_3_8812F(x) |                              \
	 BIT_RXFILTER_CATEGORY_3_8812F(v))

/* 2 REG_RXFILTER_ACTION_3_8812F */

#define BIT_SHIFT_RXFILTER_ACTION_3_8812F 0
#define BIT_MASK_RXFILTER_ACTION_3_8812F 0xff
#define BIT_RXFILTER_ACTION_3_8812F(x)                                         \
	(((x) & BIT_MASK_RXFILTER_ACTION_3_8812F)                              \
	 << BIT_SHIFT_RXFILTER_ACTION_3_8812F)
#define BITS_RXFILTER_ACTION_3_8812F                                           \
	(BIT_MASK_RXFILTER_ACTION_3_8812F << BIT_SHIFT_RXFILTER_ACTION_3_8812F)
#define BIT_CLEAR_RXFILTER_ACTION_3_8812F(x)                                   \
	((x) & (~BITS_RXFILTER_ACTION_3_8812F))
#define BIT_GET_RXFILTER_ACTION_3_8812F(x)                                     \
	(((x) >> BIT_SHIFT_RXFILTER_ACTION_3_8812F) &                          \
	 BIT_MASK_RXFILTER_ACTION_3_8812F)
#define BIT_SET_RXFILTER_ACTION_3_8812F(x, v)                                  \
	(BIT_CLEAR_RXFILTER_ACTION_3_8812F(x) | BIT_RXFILTER_ACTION_3_8812F(v))

/* 2 REG_RXFLTMAP3_8812F (RX FILTER MAP GROUP 3) */
#define BIT_MGTFLT15EN_FW_8812F BIT(15)
#define BIT_MGTFLT14EN_FW_8812F BIT(14)
#define BIT_MGTFLT13EN_FW_8812F BIT(13)
#define BIT_MGTFLT12EN_FW_8812F BIT(12)
#define BIT_MGTFLT11EN_FW_8812F BIT(11)
#define BIT_MGTFLT10EN_FW_8812F BIT(10)
#define BIT_MGTFLT9EN_FW_8812F BIT(9)
#define BIT_MGTFLT8EN_FW_8812F BIT(8)
#define BIT_MGTFLT7EN_FW_8812F BIT(7)
#define BIT_MGTFLT6EN_FW_8812F BIT(6)
#define BIT_MGTFLT5EN_FW_8812F BIT(5)
#define BIT_MGTFLT4EN_FW_8812F BIT(4)
#define BIT_MGTFLT3EN_FW_8812F BIT(3)
#define BIT_MGTFLT2EN_FW_8812F BIT(2)
#define BIT_MGTFLT1EN_FW_8812F BIT(1)
#define BIT_MGTFLT0EN_FW_8812F BIT(0)

/* 2 REG_RXFLTMAP4_8812F (RX FILTER MAP GROUP 4) */
#define BIT_CTRLFLT15EN_FW_8812F BIT(15)
#define BIT_CTRLFLT14EN_FW_8812F BIT(14)
#define BIT_CTRLFLT13EN_FW_8812F BIT(13)
#define BIT_CTRLFLT12EN_FW_8812F BIT(12)
#define BIT_CTRLFLT11EN_FW_8812F BIT(11)
#define BIT_CTRLFLT10EN_FW_8812F BIT(10)
#define BIT_CTRLFLT9EN_FW_8812F BIT(9)
#define BIT_CTRLFLT8EN_FW_8812F BIT(8)
#define BIT_CTRLFLT7EN_FW_8812F BIT(7)
#define BIT_CTRLFLT6EN_FW_8812F BIT(6)
#define BIT_CTRLFLT5EN_FW_8812F BIT(5)
#define BIT_CTRLFLT4EN_FW_8812F BIT(4)
#define BIT_CTRLFLT3EN_FW_8812F BIT(3)
#define BIT_CTRLFLT2EN_FW_8812F BIT(2)
#define BIT_CTRLFLT1EN_FW_8812F BIT(1)
#define BIT_CTRLFLT0EN_FW_8812F BIT(0)

/* 2 REG_RXFLTMAP5_8812F (RX FILTER MAP GROUP 5) */
#define BIT_DATAFLT15EN_FW_8812F BIT(15)
#define BIT_DATAFLT14EN_FW_8812F BIT(14)
#define BIT_DATAFLT13EN_FW_8812F BIT(13)
#define BIT_DATAFLT12EN_FW_8812F BIT(12)
#define BIT_DATAFLT11EN_FW_8812F BIT(11)
#define BIT_DATAFLT10EN_FW_8812F BIT(10)
#define BIT_DATAFLT9EN_FW_8812F BIT(9)
#define BIT_DATAFLT8EN_FW_8812F BIT(8)
#define BIT_DATAFLT7EN_FW_8812F BIT(7)
#define BIT_DATAFLT6EN_FW_8812F BIT(6)
#define BIT_DATAFLT5EN_FW_8812F BIT(5)
#define BIT_DATAFLT4EN_FW_8812F BIT(4)
#define BIT_DATAFLT3EN_FW_8812F BIT(3)
#define BIT_DATAFLT2EN_FW_8812F BIT(2)
#define BIT_DATAFLT1EN_FW_8812F BIT(1)
#define BIT_DATAFLT0EN_FW_8812F BIT(0)

/* 2 REG_RXFLTMAP6_8812F (RX FILTER MAP GROUP 6) */
#define BIT_ACTIONFLT15EN_FW_8812F BIT(15)
#define BIT_ACTIONFLT14EN_FW_8812F BIT(14)
#define BIT_ACTIONFLT13EN_FW_8812F BIT(13)
#define BIT_ACTIONFLT12EN_FW_8812F BIT(12)
#define BIT_ACTIONFLT11EN_FW_8812F BIT(11)
#define BIT_ACTIONFLT10EN_FW_8812F BIT(10)
#define BIT_ACTIONFLT9EN_FW_8812F BIT(9)
#define BIT_ACTIONFLT8EN_FW_8812F BIT(8)
#define BIT_ACTIONFLT7EN_FW_8812F BIT(7)
#define BIT_ACTIONFLT6EN_FW_8812F BIT(6)
#define BIT_ACTIONFLT5EN_FW_8812F BIT(5)
#define BIT_ACTIONFLT4EN_FW_8812F BIT(4)
#define BIT_ACTIONFLT3EN_FW_8812F BIT(3)
#define BIT_ACTIONFLT2EN_FW_8812F BIT(2)
#define BIT_ACTIONFLT1EN_FW_8812F BIT(1)
#define BIT_ACTIONFLT0EN_FW_8812F BIT(0)

/* 2 REG_WOW_CTRL_8812F (WAKE ON WLAN CONTROL REGISTER) */

#define BIT_SHIFT_PSF_BSSIDSEL_B2B1_8812F 6
#define BIT_MASK_PSF_BSSIDSEL_B2B1_8812F 0x3
#define BIT_PSF_BSSIDSEL_B2B1_8812F(x)                                         \
	(((x) & BIT_MASK_PSF_BSSIDSEL_B2B1_8812F)                              \
	 << BIT_SHIFT_PSF_BSSIDSEL_B2B1_8812F)
#define BITS_PSF_BSSIDSEL_B2B1_8812F                                           \
	(BIT_MASK_PSF_BSSIDSEL_B2B1_8812F << BIT_SHIFT_PSF_BSSIDSEL_B2B1_8812F)
#define BIT_CLEAR_PSF_BSSIDSEL_B2B1_8812F(x)                                   \
	((x) & (~BITS_PSF_BSSIDSEL_B2B1_8812F))
#define BIT_GET_PSF_BSSIDSEL_B2B1_8812F(x)                                     \
	(((x) >> BIT_SHIFT_PSF_BSSIDSEL_B2B1_8812F) &                          \
	 BIT_MASK_PSF_BSSIDSEL_B2B1_8812F)
#define BIT_SET_PSF_BSSIDSEL_B2B1_8812F(x, v)                                  \
	(BIT_CLEAR_PSF_BSSIDSEL_B2B1_8812F(x) | BIT_PSF_BSSIDSEL_B2B1_8812F(v))

#define BIT_WOWHCI_8812F BIT(5)
#define BIT_PSF_BSSIDSEL_B0_8812F BIT(4)
#define BIT_UWF_8812F BIT(3)
#define BIT_MAGIC_8812F BIT(2)
#define BIT_WOWEN_8812F BIT(1)
#define BIT_FORCE_WAKEUP_8812F BIT(0)

/* 2 REG_NAN_RX_TSF_FILTER_8812F(NAN_RX_TSF_ADDRESS_FILTER) */
#define BIT_CHK_TSF_TA_8812F BIT(2)
#define BIT_CHK_TSF_CBSSID_8812F BIT(1)
#define BIT_CHK_TSF_EN_8812F BIT(0)

/* 2 REG_PS_RX_INFO_8812F (POWER SAVE RX INFORMATION REGISTER) */

#define BIT_SHIFT_PORTSEL__PS_RX_INFO_8812F 5
#define BIT_MASK_PORTSEL__PS_RX_INFO_8812F 0x7
#define BIT_PORTSEL__PS_RX_INFO_8812F(x)                                       \
	(((x) & BIT_MASK_PORTSEL__PS_RX_INFO_8812F)                            \
	 << BIT_SHIFT_PORTSEL__PS_RX_INFO_8812F)
#define BITS_PORTSEL__PS_RX_INFO_8812F                                         \
	(BIT_MASK_PORTSEL__PS_RX_INFO_8812F                                    \
	 << BIT_SHIFT_PORTSEL__PS_RX_INFO_8812F)
#define BIT_CLEAR_PORTSEL__PS_RX_INFO_8812F(x)                                 \
	((x) & (~BITS_PORTSEL__PS_RX_INFO_8812F))
#define BIT_GET_PORTSEL__PS_RX_INFO_8812F(x)                                   \
	(((x) >> BIT_SHIFT_PORTSEL__PS_RX_INFO_8812F) &                        \
	 BIT_MASK_PORTSEL__PS_RX_INFO_8812F)
#define BIT_SET_PORTSEL__PS_RX_INFO_8812F(x, v)                                \
	(BIT_CLEAR_PORTSEL__PS_RX_INFO_8812F(x) |                              \
	 BIT_PORTSEL__PS_RX_INFO_8812F(v))

#define BIT_RXCTRLIN0_8812F BIT(4)
#define BIT_RXMGTIN0_8812F BIT(3)
#define BIT_RXDATAIN2_8812F BIT(2)
#define BIT_RXDATAIN1_8812F BIT(1)
#define BIT_RXDATAIN0_8812F BIT(0)

/* 2 REG_WMMPS_UAPSD_TID_8812F (WMM POWER SAVE UAPSD TID REGISTER) */
#define BIT_WMMPS_UAPSD_TID7_8812F BIT(7)
#define BIT_WMMPS_UAPSD_TID6_8812F BIT(6)
#define BIT_WMMPS_UAPSD_TID5_8812F BIT(5)
#define BIT_WMMPS_UAPSD_TID4_8812F BIT(4)
#define BIT_WMMPS_UAPSD_TID3_8812F BIT(3)
#define BIT_WMMPS_UAPSD_TID2_8812F BIT(2)
#define BIT_WMMPS_UAPSD_TID1_8812F BIT(1)
#define BIT_WMMPS_UAPSD_TID0_8812F BIT(0)

/* 2 REG_LPNAV_CTRL_8812F (LOW POWER NAV CONTROL REGISTER) */

/* 2 REG_WKFMCAM_CMD_8812F (WAKEUP FRAME CAM COMMAND REGISTER) */
#define BIT_WKFCAM_POLLING_V1_8812F BIT(31)
#define BIT_WKFCAM_CLR_V1_8812F BIT(30)
#define BIT_WKFCAM_WE_8812F BIT(16)

#define BIT_SHIFT_WKFCAM_ADDR_V2_8812F 8
#define BIT_MASK_WKFCAM_ADDR_V2_8812F 0xff
#define BIT_WKFCAM_ADDR_V2_8812F(x)                                            \
	(((x) & BIT_MASK_WKFCAM_ADDR_V2_8812F)                                 \
	 << BIT_SHIFT_WKFCAM_ADDR_V2_8812F)
#define BITS_WKFCAM_ADDR_V2_8812F                                              \
	(BIT_MASK_WKFCAM_ADDR_V2_8812F << BIT_SHIFT_WKFCAM_ADDR_V2_8812F)
#define BIT_CLEAR_WKFCAM_ADDR_V2_8812F(x) ((x) & (~BITS_WKFCAM_ADDR_V2_8812F))
#define BIT_GET_WKFCAM_ADDR_V2_8812F(x)                                        \
	(((x) >> BIT_SHIFT_WKFCAM_ADDR_V2_8812F) &                             \
	 BIT_MASK_WKFCAM_ADDR_V2_8812F)
#define BIT_SET_WKFCAM_ADDR_V2_8812F(x, v)                                     \
	(BIT_CLEAR_WKFCAM_ADDR_V2_8812F(x) | BIT_WKFCAM_ADDR_V2_8812F(v))

#define BIT_SHIFT_WKFCAM_CAM_NUM_V1_8812F 0
#define BIT_MASK_WKFCAM_CAM_NUM_V1_8812F 0xff
#define BIT_WKFCAM_CAM_NUM_V1_8812F(x)                                         \
	(((x) & BIT_MASK_WKFCAM_CAM_NUM_V1_8812F)                              \
	 << BIT_SHIFT_WKFCAM_CAM_NUM_V1_8812F)
#define BITS_WKFCAM_CAM_NUM_V1_8812F                                           \
	(BIT_MASK_WKFCAM_CAM_NUM_V1_8812F << BIT_SHIFT_WKFCAM_CAM_NUM_V1_8812F)
#define BIT_CLEAR_WKFCAM_CAM_NUM_V1_8812F(x)                                   \
	((x) & (~BITS_WKFCAM_CAM_NUM_V1_8812F))
#define BIT_GET_WKFCAM_CAM_NUM_V1_8812F(x)                                     \
	(((x) >> BIT_SHIFT_WKFCAM_CAM_NUM_V1_8812F) &                          \
	 BIT_MASK_WKFCAM_CAM_NUM_V1_8812F)
#define BIT_SET_WKFCAM_CAM_NUM_V1_8812F(x, v)                                  \
	(BIT_CLEAR_WKFCAM_CAM_NUM_V1_8812F(x) | BIT_WKFCAM_CAM_NUM_V1_8812F(v))

/* 2 REG_WKFMCAM_RWD_8812F (WAKEUP FRAME READ/WRITE DATA) */

#define BIT_SHIFT_WKFMCAM_RWD_8812F 0
#define BIT_MASK_WKFMCAM_RWD_8812F 0xffffffffL
#define BIT_WKFMCAM_RWD_8812F(x)                                               \
	(((x) & BIT_MASK_WKFMCAM_RWD_8812F) << BIT_SHIFT_WKFMCAM_RWD_8812F)
#define BITS_WKFMCAM_RWD_8812F                                                 \
	(BIT_MASK_WKFMCAM_RWD_8812F << BIT_SHIFT_WKFMCAM_RWD_8812F)
#define BIT_CLEAR_WKFMCAM_RWD_8812F(x) ((x) & (~BITS_WKFMCAM_RWD_8812F))
#define BIT_GET_WKFMCAM_RWD_8812F(x)                                           \
	(((x) >> BIT_SHIFT_WKFMCAM_RWD_8812F) & BIT_MASK_WKFMCAM_RWD_8812F)
#define BIT_SET_WKFMCAM_RWD_8812F(x, v)                                        \
	(BIT_CLEAR_WKFMCAM_RWD_8812F(x) | BIT_WKFMCAM_RWD_8812F(v))

/* 2 REG_RXFLTMAP0_8812F (RX FILTER MAP GROUP 0) */
#define BIT_MGTFLT15EN_8812F BIT(15)
#define BIT_MGTFLT14EN_8812F BIT(14)
#define BIT_MGTFLT13EN_8812F BIT(13)
#define BIT_MGTFLT12EN_8812F BIT(12)
#define BIT_MGTFLT11EN_8812F BIT(11)
#define BIT_MGTFLT10EN_8812F BIT(10)
#define BIT_MGTFLT9EN_8812F BIT(9)
#define BIT_MGTFLT8EN_8812F BIT(8)
#define BIT_MGTFLT7EN_8812F BIT(7)
#define BIT_MGTFLT6EN_8812F BIT(6)
#define BIT_MGTFLT5EN_8812F BIT(5)
#define BIT_MGTFLT4EN_8812F BIT(4)
#define BIT_MGTFLT3EN_8812F BIT(3)
#define BIT_MGTFLT2EN_8812F BIT(2)
#define BIT_MGTFLT1EN_8812F BIT(1)
#define BIT_MGTFLT0EN_8812F BIT(0)

/* 2 REG_RXFLTMAP1_8812F (RX FILTER MAP GROUP 1) */
#define BIT_CTRLFLT15EN_8812F BIT(15)
#define BIT_CTRLFLT14EN_8812F BIT(14)
#define BIT_CTRLFLT13EN_8812F BIT(13)
#define BIT_CTRLFLT12EN_8812F BIT(12)
#define BIT_CTRLFLT11EN_8812F BIT(11)
#define BIT_CTRLFLT10EN_8812F BIT(10)
#define BIT_CTRLFLT9EN_8812F BIT(9)
#define BIT_CTRLFLT8EN_8812F BIT(8)
#define BIT_CTRLFLT7EN_8812F BIT(7)
#define BIT_CTRLFLT6EN_8812F BIT(6)
#define BIT_CTRLFLT5EN_8812F BIT(5)
#define BIT_CTRLFLT4EN_8812F BIT(4)
#define BIT_CTRLFLT3EN_8812F BIT(3)
#define BIT_CTRLFLT2EN_8812F BIT(2)
#define BIT_CTRLFLT1EN_8812F BIT(1)
#define BIT_CTRLFLT0EN_8812F BIT(0)

/* 2 REG_RXFLTMAP2_8812F (RX FILTER MAP GROUP 2) */
#define BIT_DATAFLT15EN_8812F BIT(15)
#define BIT_DATAFLT14EN_8812F BIT(14)
#define BIT_DATAFLT13EN_8812F BIT(13)
#define BIT_DATAFLT12EN_8812F BIT(12)
#define BIT_DATAFLT11EN_8812F BIT(11)
#define BIT_DATAFLT10EN_8812F BIT(10)
#define BIT_DATAFLT9EN_8812F BIT(9)
#define BIT_DATAFLT8EN_8812F BIT(8)
#define BIT_DATAFLT7EN_8812F BIT(7)
#define BIT_DATAFLT6EN_8812F BIT(6)
#define BIT_DATAFLT5EN_8812F BIT(5)
#define BIT_DATAFLT4EN_8812F BIT(4)
#define BIT_DATAFLT3EN_8812F BIT(3)
#define BIT_DATAFLT2EN_8812F BIT(2)
#define BIT_DATAFLT1EN_8812F BIT(1)
#define BIT_DATAFLT0EN_8812F BIT(0)

/* 2 REG_RSVD_8812F */

/* 2 REG_BCN_PSR_RPT_8812F (BEACON PARSER REPORT REGISTER) */

#define BIT_SHIFT_DTIM_CNT_8812F 24
#define BIT_MASK_DTIM_CNT_8812F 0xff
#define BIT_DTIM_CNT_8812F(x)                                                  \
	(((x) & BIT_MASK_DTIM_CNT_8812F) << BIT_SHIFT_DTIM_CNT_8812F)
#define BITS_DTIM_CNT_8812F                                                    \
	(BIT_MASK_DTIM_CNT_8812F << BIT_SHIFT_DTIM_CNT_8812F)
#define BIT_CLEAR_DTIM_CNT_8812F(x) ((x) & (~BITS_DTIM_CNT_8812F))
#define BIT_GET_DTIM_CNT_8812F(x)                                              \
	(((x) >> BIT_SHIFT_DTIM_CNT_8812F) & BIT_MASK_DTIM_CNT_8812F)
#define BIT_SET_DTIM_CNT_8812F(x, v)                                           \
	(BIT_CLEAR_DTIM_CNT_8812F(x) | BIT_DTIM_CNT_8812F(v))

#define BIT_SHIFT_DTIM_PERIOD_8812F 16
#define BIT_MASK_DTIM_PERIOD_8812F 0xff
#define BIT_DTIM_PERIOD_8812F(x)                                               \
	(((x) & BIT_MASK_DTIM_PERIOD_8812F) << BIT_SHIFT_DTIM_PERIOD_8812F)
#define BITS_DTIM_PERIOD_8812F                                                 \
	(BIT_MASK_DTIM_PERIOD_8812F << BIT_SHIFT_DTIM_PERIOD_8812F)
#define BIT_CLEAR_DTIM_PERIOD_8812F(x) ((x) & (~BITS_DTIM_PERIOD_8812F))
#define BIT_GET_DTIM_PERIOD_8812F(x)                                           \
	(((x) >> BIT_SHIFT_DTIM_PERIOD_8812F) & BIT_MASK_DTIM_PERIOD_8812F)
#define BIT_SET_DTIM_PERIOD_8812F(x, v)                                        \
	(BIT_CLEAR_DTIM_PERIOD_8812F(x) | BIT_DTIM_PERIOD_8812F(v))

#define BIT_DTIM_8812F BIT(15)
#define BIT_TIM_8812F BIT(14)
#define BIT_RPT_VALID_8812F BIT(13)

#define BIT_SHIFT_PS_AID_0_8812F 0
#define BIT_MASK_PS_AID_0_8812F 0x7ff
#define BIT_PS_AID_0_8812F(x)                                                  \
	(((x) & BIT_MASK_PS_AID_0_8812F) << BIT_SHIFT_PS_AID_0_8812F)
#define BITS_PS_AID_0_8812F                                                    \
	(BIT_MASK_PS_AID_0_8812F << BIT_SHIFT_PS_AID_0_8812F)
#define BIT_CLEAR_PS_AID_0_8812F(x) ((x) & (~BITS_PS_AID_0_8812F))
#define BIT_GET_PS_AID_0_8812F(x)                                              \
	(((x) >> BIT_SHIFT_PS_AID_0_8812F) & BIT_MASK_PS_AID_0_8812F)
#define BIT_SET_PS_AID_0_8812F(x, v)                                           \
	(BIT_CLEAR_PS_AID_0_8812F(x) | BIT_PS_AID_0_8812F(v))

/* 2 REG_FLC_RPC_8812F (FW LPS CONDITION -- RX PKT COUNTER) */

#define BIT_SHIFT_FLC_RPC_8812F 0
#define BIT_MASK_FLC_RPC_8812F 0xff
#define BIT_FLC_RPC_8812F(x)                                                   \
	(((x) & BIT_MASK_FLC_RPC_8812F) << BIT_SHIFT_FLC_RPC_8812F)
#define BITS_FLC_RPC_8812F (BIT_MASK_FLC_RPC_8812F << BIT_SHIFT_FLC_RPC_8812F)
#define BIT_CLEAR_FLC_RPC_8812F(x) ((x) & (~BITS_FLC_RPC_8812F))
#define BIT_GET_FLC_RPC_8812F(x)                                               \
	(((x) >> BIT_SHIFT_FLC_RPC_8812F) & BIT_MASK_FLC_RPC_8812F)
#define BIT_SET_FLC_RPC_8812F(x, v)                                            \
	(BIT_CLEAR_FLC_RPC_8812F(x) | BIT_FLC_RPC_8812F(v))

/* 2 REG_FLC_RPCT_8812F (FLC_RPC THRESHOLD) */

#define BIT_SHIFT_FLC_RPCT_8812F 0
#define BIT_MASK_FLC_RPCT_8812F 0xff
#define BIT_FLC_RPCT_8812F(x)                                                  \
	(((x) & BIT_MASK_FLC_RPCT_8812F) << BIT_SHIFT_FLC_RPCT_8812F)
#define BITS_FLC_RPCT_8812F                                                    \
	(BIT_MASK_FLC_RPCT_8812F << BIT_SHIFT_FLC_RPCT_8812F)
#define BIT_CLEAR_FLC_RPCT_8812F(x) ((x) & (~BITS_FLC_RPCT_8812F))
#define BIT_GET_FLC_RPCT_8812F(x)                                              \
	(((x) >> BIT_SHIFT_FLC_RPCT_8812F) & BIT_MASK_FLC_RPCT_8812F)
#define BIT_SET_FLC_RPCT_8812F(x, v)                                           \
	(BIT_CLEAR_FLC_RPCT_8812F(x) | BIT_FLC_RPCT_8812F(v))

/* 2 REG_FLC_PTS_8812F (PKT TYPE SELECTION OF FLC_RPC T) */
#define BIT_CMF_8812F BIT(2)
#define BIT_CCF_8812F BIT(1)
#define BIT_CDF_8812F BIT(0)

/* 2 REG_FLC_TRPC_8812F (TIMER OF FLC_RPC) */
#define BIT_FLC_RPCT_V1_8812F BIT(7)
#define BIT_MODE_8812F BIT(6)

#define BIT_SHIFT_TRPCD_8812F 0
#define BIT_MASK_TRPCD_8812F 0x3f
#define BIT_TRPCD_8812F(x)                                                     \
	(((x) & BIT_MASK_TRPCD_8812F) << BIT_SHIFT_TRPCD_8812F)
#define BITS_TRPCD_8812F (BIT_MASK_TRPCD_8812F << BIT_SHIFT_TRPCD_8812F)
#define BIT_CLEAR_TRPCD_8812F(x) ((x) & (~BITS_TRPCD_8812F))
#define BIT_GET_TRPCD_8812F(x)                                                 \
	(((x) >> BIT_SHIFT_TRPCD_8812F) & BIT_MASK_TRPCD_8812F)
#define BIT_SET_TRPCD_8812F(x, v)                                              \
	(BIT_CLEAR_TRPCD_8812F(x) | BIT_TRPCD_8812F(v))

/* 2 REG_RXPKTMON_CTRL_8812F */

#define BIT_SHIFT_RXBKQPKT_SEQ_8812F 20
#define BIT_MASK_RXBKQPKT_SEQ_8812F 0xf
#define BIT_RXBKQPKT_SEQ_8812F(x)                                              \
	(((x) & BIT_MASK_RXBKQPKT_SEQ_8812F) << BIT_SHIFT_RXBKQPKT_SEQ_8812F)
#define BITS_RXBKQPKT_SEQ_8812F                                                \
	(BIT_MASK_RXBKQPKT_SEQ_8812F << BIT_SHIFT_RXBKQPKT_SEQ_8812F)
#define BIT_CLEAR_RXBKQPKT_SEQ_8812F(x) ((x) & (~BITS_RXBKQPKT_SEQ_8812F))
#define BIT_GET_RXBKQPKT_SEQ_8812F(x)                                          \
	(((x) >> BIT_SHIFT_RXBKQPKT_SEQ_8812F) & BIT_MASK_RXBKQPKT_SEQ_8812F)
#define BIT_SET_RXBKQPKT_SEQ_8812F(x, v)                                       \
	(BIT_CLEAR_RXBKQPKT_SEQ_8812F(x) | BIT_RXBKQPKT_SEQ_8812F(v))

#define BIT_SHIFT_RXBEQPKT_SEQ_8812F 16
#define BIT_MASK_RXBEQPKT_SEQ_8812F 0xf
#define BIT_RXBEQPKT_SEQ_8812F(x)                                              \
	(((x) & BIT_MASK_RXBEQPKT_SEQ_8812F) << BIT_SHIFT_RXBEQPKT_SEQ_8812F)
#define BITS_RXBEQPKT_SEQ_8812F                                                \
	(BIT_MASK_RXBEQPKT_SEQ_8812F << BIT_SHIFT_RXBEQPKT_SEQ_8812F)
#define BIT_CLEAR_RXBEQPKT_SEQ_8812F(x) ((x) & (~BITS_RXBEQPKT_SEQ_8812F))
#define BIT_GET_RXBEQPKT_SEQ_8812F(x)                                          \
	(((x) >> BIT_SHIFT_RXBEQPKT_SEQ_8812F) & BIT_MASK_RXBEQPKT_SEQ_8812F)
#define BIT_SET_RXBEQPKT_SEQ_8812F(x, v)                                       \
	(BIT_CLEAR_RXBEQPKT_SEQ_8812F(x) | BIT_RXBEQPKT_SEQ_8812F(v))

#define BIT_SHIFT_RXVIQPKT_SEQ_8812F 12
#define BIT_MASK_RXVIQPKT_SEQ_8812F 0xf
#define BIT_RXVIQPKT_SEQ_8812F(x)                                              \
	(((x) & BIT_MASK_RXVIQPKT_SEQ_8812F) << BIT_SHIFT_RXVIQPKT_SEQ_8812F)
#define BITS_RXVIQPKT_SEQ_8812F                                                \
	(BIT_MASK_RXVIQPKT_SEQ_8812F << BIT_SHIFT_RXVIQPKT_SEQ_8812F)
#define BIT_CLEAR_RXVIQPKT_SEQ_8812F(x) ((x) & (~BITS_RXVIQPKT_SEQ_8812F))
#define BIT_GET_RXVIQPKT_SEQ_8812F(x)                                          \
	(((x) >> BIT_SHIFT_RXVIQPKT_SEQ_8812F) & BIT_MASK_RXVIQPKT_SEQ_8812F)
#define BIT_SET_RXVIQPKT_SEQ_8812F(x, v)                                       \
	(BIT_CLEAR_RXVIQPKT_SEQ_8812F(x) | BIT_RXVIQPKT_SEQ_8812F(v))

#define BIT_SHIFT_RXVOQPKT_SEQ_8812F 8
#define BIT_MASK_RXVOQPKT_SEQ_8812F 0xf
#define BIT_RXVOQPKT_SEQ_8812F(x)                                              \
	(((x) & BIT_MASK_RXVOQPKT_SEQ_8812F) << BIT_SHIFT_RXVOQPKT_SEQ_8812F)
#define BITS_RXVOQPKT_SEQ_8812F                                                \
	(BIT_MASK_RXVOQPKT_SEQ_8812F << BIT_SHIFT_RXVOQPKT_SEQ_8812F)
#define BIT_CLEAR_RXVOQPKT_SEQ_8812F(x) ((x) & (~BITS_RXVOQPKT_SEQ_8812F))
#define BIT_GET_RXVOQPKT_SEQ_8812F(x)                                          \
	(((x) >> BIT_SHIFT_RXVOQPKT_SEQ_8812F) & BIT_MASK_RXVOQPKT_SEQ_8812F)
#define BIT_SET_RXVOQPKT_SEQ_8812F(x, v)                                       \
	(BIT_CLEAR_RXVOQPKT_SEQ_8812F(x) | BIT_RXVOQPKT_SEQ_8812F(v))

#define BIT_RXBKQPKT_ERR_8812F BIT(7)
#define BIT_RXBEQPKT_ERR_8812F BIT(6)
#define BIT_RXVIQPKT_ERR_8812F BIT(5)
#define BIT_RXVOQPKT_ERR_8812F BIT(4)
#define BIT_RXDMA_MON_EN_8812F BIT(2)
#define BIT_RXPKT_MON_RST_8812F BIT(1)
#define BIT_RXPKT_MON_EN_8812F BIT(0)

/* 2 REG_STATE_MON_8812F */

#define BIT_SHIFT_STATE_SEL_8812F 24
#define BIT_MASK_STATE_SEL_8812F 0x1f
#define BIT_STATE_SEL_8812F(x)                                                 \
	(((x) & BIT_MASK_STATE_SEL_8812F) << BIT_SHIFT_STATE_SEL_8812F)
#define BITS_STATE_SEL_8812F                                                   \
	(BIT_MASK_STATE_SEL_8812F << BIT_SHIFT_STATE_SEL_8812F)
#define BIT_CLEAR_STATE_SEL_8812F(x) ((x) & (~BITS_STATE_SEL_8812F))
#define BIT_GET_STATE_SEL_8812F(x)                                             \
	(((x) >> BIT_SHIFT_STATE_SEL_8812F) & BIT_MASK_STATE_SEL_8812F)
#define BIT_SET_STATE_SEL_8812F(x, v)                                          \
	(BIT_CLEAR_STATE_SEL_8812F(x) | BIT_STATE_SEL_8812F(v))

#define BIT_SHIFT_STATE_INFO_8812F 8
#define BIT_MASK_STATE_INFO_8812F 0xff
#define BIT_STATE_INFO_8812F(x)                                                \
	(((x) & BIT_MASK_STATE_INFO_8812F) << BIT_SHIFT_STATE_INFO_8812F)
#define BITS_STATE_INFO_8812F                                                  \
	(BIT_MASK_STATE_INFO_8812F << BIT_SHIFT_STATE_INFO_8812F)
#define BIT_CLEAR_STATE_INFO_8812F(x) ((x) & (~BITS_STATE_INFO_8812F))
#define BIT_GET_STATE_INFO_8812F(x)                                            \
	(((x) >> BIT_SHIFT_STATE_INFO_8812F) & BIT_MASK_STATE_INFO_8812F)
#define BIT_SET_STATE_INFO_8812F(x, v)                                         \
	(BIT_CLEAR_STATE_INFO_8812F(x) | BIT_STATE_INFO_8812F(v))

#define BIT_UPD_NXT_STATE_8812F BIT(7)

#define BIT_SHIFT_CUR_STATE_8812F 0
#define BIT_MASK_CUR_STATE_8812F 0x7f
#define BIT_CUR_STATE_8812F(x)                                                 \
	(((x) & BIT_MASK_CUR_STATE_8812F) << BIT_SHIFT_CUR_STATE_8812F)
#define BITS_CUR_STATE_8812F                                                   \
	(BIT_MASK_CUR_STATE_8812F << BIT_SHIFT_CUR_STATE_8812F)
#define BIT_CLEAR_CUR_STATE_8812F(x) ((x) & (~BITS_CUR_STATE_8812F))
#define BIT_GET_CUR_STATE_8812F(x)                                             \
	(((x) >> BIT_SHIFT_CUR_STATE_8812F) & BIT_MASK_CUR_STATE_8812F)
#define BIT_SET_CUR_STATE_8812F(x, v)                                          \
	(BIT_CLEAR_CUR_STATE_8812F(x) | BIT_CUR_STATE_8812F(v))

/* 2 REG_ERROR_MON_8812F */
#define BIT_CSIRPT_LEN_BB_MORE_THAN_MAC_8812F BIT(23)
#define BIT_CSI_CHKSUM_ERROR_8812F BIT(22)
#define BIT_MACRX_ERR_4_8812F BIT(20)
#define BIT_MACRX_ERR_3_8812F BIT(19)
#define BIT_MACRX_ERR_2_8812F BIT(18)
#define BIT_MACRX_ERR_1_8812F BIT(17)
#define BIT_MACRX_ERR_0_8812F BIT(16)
#define BIT_WMAC_PRETX_ERRHDL_EN_8812F BIT(15)
#define BIT_MACTX_ERR_5_8812F BIT(5)
#define BIT_MACTX_ERR_4_8812F BIT(4)
#define BIT_MACTX_ERR_3_8812F BIT(3)
#define BIT_MACTX_ERR_2_8812F BIT(2)
#define BIT_MACTX_ERR_1_8812F BIT(1)
#define BIT_MACTX_ERR_0_8812F BIT(0)

/* 2 REG_SEARCH_MACID_8812F */
#define BIT_EN_TXRPTBUF_CLK_8812F BIT(31)

#define BIT_SHIFT_INFO_INDEX_OFFSET_8812F 16
#define BIT_MASK_INFO_INDEX_OFFSET_8812F 0x1fff
#define BIT_INFO_INDEX_OFFSET_8812F(x)                                         \
	(((x) & BIT_MASK_INFO_INDEX_OFFSET_8812F)                              \
	 << BIT_SHIFT_INFO_INDEX_OFFSET_8812F)
#define BITS_INFO_INDEX_OFFSET_8812F                                           \
	(BIT_MASK_INFO_INDEX_OFFSET_8812F << BIT_SHIFT_INFO_INDEX_OFFSET_8812F)
#define BIT_CLEAR_INFO_INDEX_OFFSET_8812F(x)                                   \
	((x) & (~BITS_INFO_INDEX_OFFSET_8812F))
#define BIT_GET_INFO_INDEX_OFFSET_8812F(x)                                     \
	(((x) >> BIT_SHIFT_INFO_INDEX_OFFSET_8812F) &                          \
	 BIT_MASK_INFO_INDEX_OFFSET_8812F)
#define BIT_SET_INFO_INDEX_OFFSET_8812F(x, v)                                  \
	(BIT_CLEAR_INFO_INDEX_OFFSET_8812F(x) | BIT_INFO_INDEX_OFFSET_8812F(v))

#define BIT_WMAC_SRCH_FIFOFULL_8812F BIT(15)
#define BIT_DIS_INFOSRCH_8812F BIT(14)

#define BIT_SHIFT_INFO_ADDR_OFFSET_8812F 0
#define BIT_MASK_INFO_ADDR_OFFSET_8812F 0x1fff
#define BIT_INFO_ADDR_OFFSET_8812F(x)                                          \
	(((x) & BIT_MASK_INFO_ADDR_OFFSET_8812F)                               \
	 << BIT_SHIFT_INFO_ADDR_OFFSET_8812F)
#define BITS_INFO_ADDR_OFFSET_8812F                                            \
	(BIT_MASK_INFO_ADDR_OFFSET_8812F << BIT_SHIFT_INFO_ADDR_OFFSET_8812F)
#define BIT_CLEAR_INFO_ADDR_OFFSET_8812F(x)                                    \
	((x) & (~BITS_INFO_ADDR_OFFSET_8812F))
#define BIT_GET_INFO_ADDR_OFFSET_8812F(x)                                      \
	(((x) >> BIT_SHIFT_INFO_ADDR_OFFSET_8812F) &                           \
	 BIT_MASK_INFO_ADDR_OFFSET_8812F)
#define BIT_SET_INFO_ADDR_OFFSET_8812F(x, v)                                   \
	(BIT_CLEAR_INFO_ADDR_OFFSET_8812F(x) | BIT_INFO_ADDR_OFFSET_8812F(v))

/* 2 REG_BT_COEX_TABLE_8812F (BT-COEXISTENCE CONTROL REGISTER) */

#define BIT_SHIFT_COEX_TABLE_1_8812F 0
#define BIT_MASK_COEX_TABLE_1_8812F 0xffffffffL
#define BIT_COEX_TABLE_1_8812F(x)                                              \
	(((x) & BIT_MASK_COEX_TABLE_1_8812F) << BIT_SHIFT_COEX_TABLE_1_8812F)
#define BITS_COEX_TABLE_1_8812F                                                \
	(BIT_MASK_COEX_TABLE_1_8812F << BIT_SHIFT_COEX_TABLE_1_8812F)
#define BIT_CLEAR_COEX_TABLE_1_8812F(x) ((x) & (~BITS_COEX_TABLE_1_8812F))
#define BIT_GET_COEX_TABLE_1_8812F(x)                                          \
	(((x) >> BIT_SHIFT_COEX_TABLE_1_8812F) & BIT_MASK_COEX_TABLE_1_8812F)
#define BIT_SET_COEX_TABLE_1_8812F(x, v)                                       \
	(BIT_CLEAR_COEX_TABLE_1_8812F(x) | BIT_COEX_TABLE_1_8812F(v))

/* 2 REG_BT_COEX_TABLE2_8812F (BT-COEXISTENCE CONTROL REGISTER) */

#define BIT_SHIFT_COEX_TABLE_2_8812F 0
#define BIT_MASK_COEX_TABLE_2_8812F 0xffffffffL
#define BIT_COEX_TABLE_2_8812F(x)                                              \
	(((x) & BIT_MASK_COEX_TABLE_2_8812F) << BIT_SHIFT_COEX_TABLE_2_8812F)
#define BITS_COEX_TABLE_2_8812F                                                \
	(BIT_MASK_COEX_TABLE_2_8812F << BIT_SHIFT_COEX_TABLE_2_8812F)
#define BIT_CLEAR_COEX_TABLE_2_8812F(x) ((x) & (~BITS_COEX_TABLE_2_8812F))
#define BIT_GET_COEX_TABLE_2_8812F(x)                                          \
	(((x) >> BIT_SHIFT_COEX_TABLE_2_8812F) & BIT_MASK_COEX_TABLE_2_8812F)
#define BIT_SET_COEX_TABLE_2_8812F(x, v)                                       \
	(BIT_CLEAR_COEX_TABLE_2_8812F(x) | BIT_COEX_TABLE_2_8812F(v))

/* 2 REG_BT_COEX_BREAK_TABLE_8812F (BT-COEXISTENCE CONTROL REGISTER) */

#define BIT_SHIFT_BREAK_TABLE_2_8812F 16
#define BIT_MASK_BREAK_TABLE_2_8812F 0xffff
#define BIT_BREAK_TABLE_2_8812F(x)                                             \
	(((x) & BIT_MASK_BREAK_TABLE_2_8812F) << BIT_SHIFT_BREAK_TABLE_2_8812F)
#define BITS_BREAK_TABLE_2_8812F                                               \
	(BIT_MASK_BREAK_TABLE_2_8812F << BIT_SHIFT_BREAK_TABLE_2_8812F)
#define BIT_CLEAR_BREAK_TABLE_2_8812F(x) ((x) & (~BITS_BREAK_TABLE_2_8812F))
#define BIT_GET_BREAK_TABLE_2_8812F(x)                                         \
	(((x) >> BIT_SHIFT_BREAK_TABLE_2_8812F) & BIT_MASK_BREAK_TABLE_2_8812F)
#define BIT_SET_BREAK_TABLE_2_8812F(x, v)                                      \
	(BIT_CLEAR_BREAK_TABLE_2_8812F(x) | BIT_BREAK_TABLE_2_8812F(v))

#define BIT_SHIFT_BREAK_TABLE_1_8812F 0
#define BIT_MASK_BREAK_TABLE_1_8812F 0xffff
#define BIT_BREAK_TABLE_1_8812F(x)                                             \
	(((x) & BIT_MASK_BREAK_TABLE_1_8812F) << BIT_SHIFT_BREAK_TABLE_1_8812F)
#define BITS_BREAK_TABLE_1_8812F                                               \
	(BIT_MASK_BREAK_TABLE_1_8812F << BIT_SHIFT_BREAK_TABLE_1_8812F)
#define BIT_CLEAR_BREAK_TABLE_1_8812F(x) ((x) & (~BITS_BREAK_TABLE_1_8812F))
#define BIT_GET_BREAK_TABLE_1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_BREAK_TABLE_1_8812F) & BIT_MASK_BREAK_TABLE_1_8812F)
#define BIT_SET_BREAK_TABLE_1_8812F(x, v)                                      \
	(BIT_CLEAR_BREAK_TABLE_1_8812F(x) | BIT_BREAK_TABLE_1_8812F(v))

/* 2 REG_BT_COEX_TABLE_H_8812F (BT-COEXISTENCE CONTROL REGISTER) */
#define BIT_PRI_MASK_RX_RESP_V1_8812F BIT(30)
#define BIT_PRI_MASK_RXOFDM_V1_8812F BIT(29)
#define BIT_PRI_MASK_RXCCK_V1_8812F BIT(28)

#define BIT_SHIFT_PRI_MASK_TXAC_8812F 21
#define BIT_MASK_PRI_MASK_TXAC_8812F 0x7f
#define BIT_PRI_MASK_TXAC_8812F(x)                                             \
	(((x) & BIT_MASK_PRI_MASK_TXAC_8812F) << BIT_SHIFT_PRI_MASK_TXAC_8812F)
#define BITS_PRI_MASK_TXAC_8812F                                               \
	(BIT_MASK_PRI_MASK_TXAC_8812F << BIT_SHIFT_PRI_MASK_TXAC_8812F)
#define BIT_CLEAR_PRI_MASK_TXAC_8812F(x) ((x) & (~BITS_PRI_MASK_TXAC_8812F))
#define BIT_GET_PRI_MASK_TXAC_8812F(x)                                         \
	(((x) >> BIT_SHIFT_PRI_MASK_TXAC_8812F) & BIT_MASK_PRI_MASK_TXAC_8812F)
#define BIT_SET_PRI_MASK_TXAC_8812F(x, v)                                      \
	(BIT_CLEAR_PRI_MASK_TXAC_8812F(x) | BIT_PRI_MASK_TXAC_8812F(v))

#define BIT_SHIFT_PRI_MASK_NAV_8812F 13
#define BIT_MASK_PRI_MASK_NAV_8812F 0xff
#define BIT_PRI_MASK_NAV_8812F(x)                                              \
	(((x) & BIT_MASK_PRI_MASK_NAV_8812F) << BIT_SHIFT_PRI_MASK_NAV_8812F)
#define BITS_PRI_MASK_NAV_8812F                                                \
	(BIT_MASK_PRI_MASK_NAV_8812F << BIT_SHIFT_PRI_MASK_NAV_8812F)
#define BIT_CLEAR_PRI_MASK_NAV_8812F(x) ((x) & (~BITS_PRI_MASK_NAV_8812F))
#define BIT_GET_PRI_MASK_NAV_8812F(x)                                          \
	(((x) >> BIT_SHIFT_PRI_MASK_NAV_8812F) & BIT_MASK_PRI_MASK_NAV_8812F)
#define BIT_SET_PRI_MASK_NAV_8812F(x, v)                                       \
	(BIT_CLEAR_PRI_MASK_NAV_8812F(x) | BIT_PRI_MASK_NAV_8812F(v))

#define BIT_PRI_MASK_CCK_V1_8812F BIT(12)
#define BIT_PRI_MASK_OFDM_V1_8812F BIT(11)
#define BIT_PRI_MASK_RTY_V1_8812F BIT(10)

#define BIT_SHIFT_PRI_MASK_NUM_8812F 6
#define BIT_MASK_PRI_MASK_NUM_8812F 0xf
#define BIT_PRI_MASK_NUM_8812F(x)                                              \
	(((x) & BIT_MASK_PRI_MASK_NUM_8812F) << BIT_SHIFT_PRI_MASK_NUM_8812F)
#define BITS_PRI_MASK_NUM_8812F                                                \
	(BIT_MASK_PRI_MASK_NUM_8812F << BIT_SHIFT_PRI_MASK_NUM_8812F)
#define BIT_CLEAR_PRI_MASK_NUM_8812F(x) ((x) & (~BITS_PRI_MASK_NUM_8812F))
#define BIT_GET_PRI_MASK_NUM_8812F(x)                                          \
	(((x) >> BIT_SHIFT_PRI_MASK_NUM_8812F) & BIT_MASK_PRI_MASK_NUM_8812F)
#define BIT_SET_PRI_MASK_NUM_8812F(x, v)                                       \
	(BIT_CLEAR_PRI_MASK_NUM_8812F(x) | BIT_PRI_MASK_NUM_8812F(v))

#define BIT_SHIFT_PRI_MASK_TYPE_8812F 2
#define BIT_MASK_PRI_MASK_TYPE_8812F 0xf
#define BIT_PRI_MASK_TYPE_8812F(x)                                             \
	(((x) & BIT_MASK_PRI_MASK_TYPE_8812F) << BIT_SHIFT_PRI_MASK_TYPE_8812F)
#define BITS_PRI_MASK_TYPE_8812F                                               \
	(BIT_MASK_PRI_MASK_TYPE_8812F << BIT_SHIFT_PRI_MASK_TYPE_8812F)
#define BIT_CLEAR_PRI_MASK_TYPE_8812F(x) ((x) & (~BITS_PRI_MASK_TYPE_8812F))
#define BIT_GET_PRI_MASK_TYPE_8812F(x)                                         \
	(((x) >> BIT_SHIFT_PRI_MASK_TYPE_8812F) & BIT_MASK_PRI_MASK_TYPE_8812F)
#define BIT_SET_PRI_MASK_TYPE_8812F(x, v)                                      \
	(BIT_CLEAR_PRI_MASK_TYPE_8812F(x) | BIT_PRI_MASK_TYPE_8812F(v))

#define BIT_OOB_V1_8812F BIT(1)
#define BIT_ANT_SEL_V1_8812F BIT(0)

/* 2 REG_RXCMD_0_8812F */
#define BIT_RXCMD_EN_8812F BIT(31)

#define BIT_SHIFT_RXCMD_INFO_8812F 0
#define BIT_MASK_RXCMD_INFO_8812F 0x7fffffffL
#define BIT_RXCMD_INFO_8812F(x)                                                \
	(((x) & BIT_MASK_RXCMD_INFO_8812F) << BIT_SHIFT_RXCMD_INFO_8812F)
#define BITS_RXCMD_INFO_8812F                                                  \
	(BIT_MASK_RXCMD_INFO_8812F << BIT_SHIFT_RXCMD_INFO_8812F)
#define BIT_CLEAR_RXCMD_INFO_8812F(x) ((x) & (~BITS_RXCMD_INFO_8812F))
#define BIT_GET_RXCMD_INFO_8812F(x)                                            \
	(((x) >> BIT_SHIFT_RXCMD_INFO_8812F) & BIT_MASK_RXCMD_INFO_8812F)
#define BIT_SET_RXCMD_INFO_8812F(x, v)                                         \
	(BIT_CLEAR_RXCMD_INFO_8812F(x) | BIT_RXCMD_INFO_8812F(v))

/* 2 REG_RXCMD_1_8812F */

#define BIT_SHIFT_RXCMD_PRD_8812F 0
#define BIT_MASK_RXCMD_PRD_8812F 0xffff
#define BIT_RXCMD_PRD_8812F(x)                                                 \
	(((x) & BIT_MASK_RXCMD_PRD_8812F) << BIT_SHIFT_RXCMD_PRD_8812F)
#define BITS_RXCMD_PRD_8812F                                                   \
	(BIT_MASK_RXCMD_PRD_8812F << BIT_SHIFT_RXCMD_PRD_8812F)
#define BIT_CLEAR_RXCMD_PRD_8812F(x) ((x) & (~BITS_RXCMD_PRD_8812F))
#define BIT_GET_RXCMD_PRD_8812F(x)                                             \
	(((x) >> BIT_SHIFT_RXCMD_PRD_8812F) & BIT_MASK_RXCMD_PRD_8812F)
#define BIT_SET_RXCMD_PRD_8812F(x, v)                                          \
	(BIT_CLEAR_RXCMD_PRD_8812F(x) | BIT_RXCMD_PRD_8812F(v))

/* 2 REG_WMAC_RESP_TXINFO_8812F (RESPONSE TXINFO REGISTER) */

#define BIT_SHIFT_WMAC_RESP_MFB_8812F 25
#define BIT_MASK_WMAC_RESP_MFB_8812F 0x7f
#define BIT_WMAC_RESP_MFB_8812F(x)                                             \
	(((x) & BIT_MASK_WMAC_RESP_MFB_8812F) << BIT_SHIFT_WMAC_RESP_MFB_8812F)
#define BITS_WMAC_RESP_MFB_8812F                                               \
	(BIT_MASK_WMAC_RESP_MFB_8812F << BIT_SHIFT_WMAC_RESP_MFB_8812F)
#define BIT_CLEAR_WMAC_RESP_MFB_8812F(x) ((x) & (~BITS_WMAC_RESP_MFB_8812F))
#define BIT_GET_WMAC_RESP_MFB_8812F(x)                                         \
	(((x) >> BIT_SHIFT_WMAC_RESP_MFB_8812F) & BIT_MASK_WMAC_RESP_MFB_8812F)
#define BIT_SET_WMAC_RESP_MFB_8812F(x, v)                                      \
	(BIT_CLEAR_WMAC_RESP_MFB_8812F(x) | BIT_WMAC_RESP_MFB_8812F(v))

#define BIT_SHIFT_WMAC_ANTINF_SEL_8812F 23
#define BIT_MASK_WMAC_ANTINF_SEL_8812F 0x3
#define BIT_WMAC_ANTINF_SEL_8812F(x)                                           \
	(((x) & BIT_MASK_WMAC_ANTINF_SEL_8812F)                                \
	 << BIT_SHIFT_WMAC_ANTINF_SEL_8812F)
#define BITS_WMAC_ANTINF_SEL_8812F                                             \
	(BIT_MASK_WMAC_ANTINF_SEL_8812F << BIT_SHIFT_WMAC_ANTINF_SEL_8812F)
#define BIT_CLEAR_WMAC_ANTINF_SEL_8812F(x) ((x) & (~BITS_WMAC_ANTINF_SEL_8812F))
#define BIT_GET_WMAC_ANTINF_SEL_8812F(x)                                       \
	(((x) >> BIT_SHIFT_WMAC_ANTINF_SEL_8812F) &                            \
	 BIT_MASK_WMAC_ANTINF_SEL_8812F)
#define BIT_SET_WMAC_ANTINF_SEL_8812F(x, v)                                    \
	(BIT_CLEAR_WMAC_ANTINF_SEL_8812F(x) | BIT_WMAC_ANTINF_SEL_8812F(v))

#define BIT_SHIFT_WMAC_ANTSEL_SEL_8812F 21
#define BIT_MASK_WMAC_ANTSEL_SEL_8812F 0x3
#define BIT_WMAC_ANTSEL_SEL_8812F(x)                                           \
	(((x) & BIT_MASK_WMAC_ANTSEL_SEL_8812F)                                \
	 << BIT_SHIFT_WMAC_ANTSEL_SEL_8812F)
#define BITS_WMAC_ANTSEL_SEL_8812F                                             \
	(BIT_MASK_WMAC_ANTSEL_SEL_8812F << BIT_SHIFT_WMAC_ANTSEL_SEL_8812F)
#define BIT_CLEAR_WMAC_ANTSEL_SEL_8812F(x) ((x) & (~BITS_WMAC_ANTSEL_SEL_8812F))
#define BIT_GET_WMAC_ANTSEL_SEL_8812F(x)                                       \
	(((x) >> BIT_SHIFT_WMAC_ANTSEL_SEL_8812F) &                            \
	 BIT_MASK_WMAC_ANTSEL_SEL_8812F)
#define BIT_SET_WMAC_ANTSEL_SEL_8812F(x, v)                                    \
	(BIT_CLEAR_WMAC_ANTSEL_SEL_8812F(x) | BIT_WMAC_ANTSEL_SEL_8812F(v))

#define BIT_SHIFT_WMAC_RESP_TXPOWER_OFFSET_TYPE_8812F 18
#define BIT_MASK_WMAC_RESP_TXPOWER_OFFSET_TYPE_8812F 0x3
#define BIT_WMAC_RESP_TXPOWER_OFFSET_TYPE_8812F(x)                             \
	(((x) & BIT_MASK_WMAC_RESP_TXPOWER_OFFSET_TYPE_8812F)                  \
	 << BIT_SHIFT_WMAC_RESP_TXPOWER_OFFSET_TYPE_8812F)
#define BITS_WMAC_RESP_TXPOWER_OFFSET_TYPE_8812F                               \
	(BIT_MASK_WMAC_RESP_TXPOWER_OFFSET_TYPE_8812F                          \
	 << BIT_SHIFT_WMAC_RESP_TXPOWER_OFFSET_TYPE_8812F)
#define BIT_CLEAR_WMAC_RESP_TXPOWER_OFFSET_TYPE_8812F(x)                       \
	((x) & (~BITS_WMAC_RESP_TXPOWER_OFFSET_TYPE_8812F))
#define BIT_GET_WMAC_RESP_TXPOWER_OFFSET_TYPE_8812F(x)                         \
	(((x) >> BIT_SHIFT_WMAC_RESP_TXPOWER_OFFSET_TYPE_8812F) &              \
	 BIT_MASK_WMAC_RESP_TXPOWER_OFFSET_TYPE_8812F)
#define BIT_SET_WMAC_RESP_TXPOWER_OFFSET_TYPE_8812F(x, v)                      \
	(BIT_CLEAR_WMAC_RESP_TXPOWER_OFFSET_TYPE_8812F(x) |                    \
	 BIT_WMAC_RESP_TXPOWER_OFFSET_TYPE_8812F(v))

#define BIT_SHIFT_WMAC_RESP_TXANT_V1_8812F 6
#define BIT_MASK_WMAC_RESP_TXANT_V1_8812F 0xfff
#define BIT_WMAC_RESP_TXANT_V1_8812F(x)                                        \
	(((x) & BIT_MASK_WMAC_RESP_TXANT_V1_8812F)                             \
	 << BIT_SHIFT_WMAC_RESP_TXANT_V1_8812F)
#define BITS_WMAC_RESP_TXANT_V1_8812F                                          \
	(BIT_MASK_WMAC_RESP_TXANT_V1_8812F                                     \
	 << BIT_SHIFT_WMAC_RESP_TXANT_V1_8812F)
#define BIT_CLEAR_WMAC_RESP_TXANT_V1_8812F(x)                                  \
	((x) & (~BITS_WMAC_RESP_TXANT_V1_8812F))
#define BIT_GET_WMAC_RESP_TXANT_V1_8812F(x)                                    \
	(((x) >> BIT_SHIFT_WMAC_RESP_TXANT_V1_8812F) &                         \
	 BIT_MASK_WMAC_RESP_TXANT_V1_8812F)
#define BIT_SET_WMAC_RESP_TXANT_V1_8812F(x, v)                                 \
	(BIT_CLEAR_WMAC_RESP_TXANT_V1_8812F(x) |                               \
	 BIT_WMAC_RESP_TXANT_V1_8812F(v))

/* 2 REG_BBPSF_CTRL_8812F */
#define BIT_CTL_IDLE_CLR_CSI_RPT_8812F BIT(31)
#define BIT_WMAC_USE_NDPARATE_8812F BIT(30)

#define BIT_SHIFT_WMAC_CSI_RATE_8812F 24
#define BIT_MASK_WMAC_CSI_RATE_8812F 0x3f
#define BIT_WMAC_CSI_RATE_8812F(x)                                             \
	(((x) & BIT_MASK_WMAC_CSI_RATE_8812F) << BIT_SHIFT_WMAC_CSI_RATE_8812F)
#define BITS_WMAC_CSI_RATE_8812F                                               \
	(BIT_MASK_WMAC_CSI_RATE_8812F << BIT_SHIFT_WMAC_CSI_RATE_8812F)
#define BIT_CLEAR_WMAC_CSI_RATE_8812F(x) ((x) & (~BITS_WMAC_CSI_RATE_8812F))
#define BIT_GET_WMAC_CSI_RATE_8812F(x)                                         \
	(((x) >> BIT_SHIFT_WMAC_CSI_RATE_8812F) & BIT_MASK_WMAC_CSI_RATE_8812F)
#define BIT_SET_WMAC_CSI_RATE_8812F(x, v)                                      \
	(BIT_CLEAR_WMAC_CSI_RATE_8812F(x) | BIT_WMAC_CSI_RATE_8812F(v))

#define BIT_SHIFT_WMAC_RESP_TXRATE_8812F 16
#define BIT_MASK_WMAC_RESP_TXRATE_8812F 0xff
#define BIT_WMAC_RESP_TXRATE_8812F(x)                                          \
	(((x) & BIT_MASK_WMAC_RESP_TXRATE_8812F)                               \
	 << BIT_SHIFT_WMAC_RESP_TXRATE_8812F)
#define BITS_WMAC_RESP_TXRATE_8812F                                            \
	(BIT_MASK_WMAC_RESP_TXRATE_8812F << BIT_SHIFT_WMAC_RESP_TXRATE_8812F)
#define BIT_CLEAR_WMAC_RESP_TXRATE_8812F(x)                                    \
	((x) & (~BITS_WMAC_RESP_TXRATE_8812F))
#define BIT_GET_WMAC_RESP_TXRATE_8812F(x)                                      \
	(((x) >> BIT_SHIFT_WMAC_RESP_TXRATE_8812F) &                           \
	 BIT_MASK_WMAC_RESP_TXRATE_8812F)
#define BIT_SET_WMAC_RESP_TXRATE_8812F(x, v)                                   \
	(BIT_CLEAR_WMAC_RESP_TXRATE_8812F(x) | BIT_WMAC_RESP_TXRATE_8812F(v))

#define BIT_SHIFT_CSI_RSC_8812F 13
#define BIT_MASK_CSI_RSC_8812F 0x3
#define BIT_CSI_RSC_8812F(x)                                                   \
	(((x) & BIT_MASK_CSI_RSC_8812F) << BIT_SHIFT_CSI_RSC_8812F)
#define BITS_CSI_RSC_8812F (BIT_MASK_CSI_RSC_8812F << BIT_SHIFT_CSI_RSC_8812F)
#define BIT_CLEAR_CSI_RSC_8812F(x) ((x) & (~BITS_CSI_RSC_8812F))
#define BIT_GET_CSI_RSC_8812F(x)                                               \
	(((x) >> BIT_SHIFT_CSI_RSC_8812F) & BIT_MASK_CSI_RSC_8812F)
#define BIT_SET_CSI_RSC_8812F(x, v)                                            \
	(BIT_CLEAR_CSI_RSC_8812F(x) | BIT_CSI_RSC_8812F(v))

#define BIT_CSI_GID_SEL_8812F BIT(12)
#define BIT_NDPVLD_PROTECT_RDRDY_DIS_8812F BIT(9)
#define BIT_RDCSI_EMPTY_APPZERO_8812F BIT(8)
#define BIT_CSI_RATE_FB_EN_8812F BIT(7)
#define BIT_RXFIFO_WRPTR_WO_CHKSUM_8812F BIT(6)

/* 2 REG_P2P_RX_BCN_NOA_8812F (P2P RX BEACON NOA REGISTER) */
#define BIT_NOA_PARSER_EN_8812F BIT(15)

#define BIT_SHIFT_BSSID_SEL_V1_8812F 12
#define BIT_MASK_BSSID_SEL_V1_8812F 0x7
#define BIT_BSSID_SEL_V1_8812F(x)                                              \
	(((x) & BIT_MASK_BSSID_SEL_V1_8812F) << BIT_SHIFT_BSSID_SEL_V1_8812F)
#define BITS_BSSID_SEL_V1_8812F                                                \
	(BIT_MASK_BSSID_SEL_V1_8812F << BIT_SHIFT_BSSID_SEL_V1_8812F)
#define BIT_CLEAR_BSSID_SEL_V1_8812F(x) ((x) & (~BITS_BSSID_SEL_V1_8812F))
#define BIT_GET_BSSID_SEL_V1_8812F(x)                                          \
	(((x) >> BIT_SHIFT_BSSID_SEL_V1_8812F) & BIT_MASK_BSSID_SEL_V1_8812F)
#define BIT_SET_BSSID_SEL_V1_8812F(x, v)                                       \
	(BIT_CLEAR_BSSID_SEL_V1_8812F(x) | BIT_BSSID_SEL_V1_8812F(v))

#define BIT_SHIFT_P2P_OUI_TYPE_8812F 0
#define BIT_MASK_P2P_OUI_TYPE_8812F 0xff
#define BIT_P2P_OUI_TYPE_8812F(x)                                              \
	(((x) & BIT_MASK_P2P_OUI_TYPE_8812F) << BIT_SHIFT_P2P_OUI_TYPE_8812F)
#define BITS_P2P_OUI_TYPE_8812F                                                \
	(BIT_MASK_P2P_OUI_TYPE_8812F << BIT_SHIFT_P2P_OUI_TYPE_8812F)
#define BIT_CLEAR_P2P_OUI_TYPE_8812F(x) ((x) & (~BITS_P2P_OUI_TYPE_8812F))
#define BIT_GET_P2P_OUI_TYPE_8812F(x)                                          \
	(((x) >> BIT_SHIFT_P2P_OUI_TYPE_8812F) & BIT_MASK_P2P_OUI_TYPE_8812F)
#define BIT_SET_P2P_OUI_TYPE_8812F(x, v)                                       \
	(BIT_CLEAR_P2P_OUI_TYPE_8812F(x) | BIT_P2P_OUI_TYPE_8812F(v))

/* 2 REG_RSVD_8812F */

/* 2 REG_ASSOCIATED_BFMER0_INFO_8812F (ASSOCIATED BEAMFORMER0 INFO REGISTER) */

#define BIT_SHIFT_R_WMAC_SOUNDING_RXADD_R0_V1_8812F 0
#define BIT_MASK_R_WMAC_SOUNDING_RXADD_R0_V1_8812F 0xffffffffL
#define BIT_R_WMAC_SOUNDING_RXADD_R0_V1_8812F(x)                               \
	(((x) & BIT_MASK_R_WMAC_SOUNDING_RXADD_R0_V1_8812F)                    \
	 << BIT_SHIFT_R_WMAC_SOUNDING_RXADD_R0_V1_8812F)
#define BITS_R_WMAC_SOUNDING_RXADD_R0_V1_8812F                                 \
	(BIT_MASK_R_WMAC_SOUNDING_RXADD_R0_V1_8812F                            \
	 << BIT_SHIFT_R_WMAC_SOUNDING_RXADD_R0_V1_8812F)
#define BIT_CLEAR_R_WMAC_SOUNDING_RXADD_R0_V1_8812F(x)                         \
	((x) & (~BITS_R_WMAC_SOUNDING_RXADD_R0_V1_8812F))
#define BIT_GET_R_WMAC_SOUNDING_RXADD_R0_V1_8812F(x)                           \
	(((x) >> BIT_SHIFT_R_WMAC_SOUNDING_RXADD_R0_V1_8812F) &                \
	 BIT_MASK_R_WMAC_SOUNDING_RXADD_R0_V1_8812F)
#define BIT_SET_R_WMAC_SOUNDING_RXADD_R0_V1_8812F(x, v)                        \
	(BIT_CLEAR_R_WMAC_SOUNDING_RXADD_R0_V1_8812F(x) |                      \
	 BIT_R_WMAC_SOUNDING_RXADD_R0_V1_8812F(v))

/* 2 REG_ASSOCIATED_BFMER0_INFO_H_8812F */

#define BIT_SHIFT_R_WMAC_TXCSI_AID0_8812F 16
#define BIT_MASK_R_WMAC_TXCSI_AID0_8812F 0x1ff
#define BIT_R_WMAC_TXCSI_AID0_8812F(x)                                         \
	(((x) & BIT_MASK_R_WMAC_TXCSI_AID0_8812F)                              \
	 << BIT_SHIFT_R_WMAC_TXCSI_AID0_8812F)
#define BITS_R_WMAC_TXCSI_AID0_8812F                                           \
	(BIT_MASK_R_WMAC_TXCSI_AID0_8812F << BIT_SHIFT_R_WMAC_TXCSI_AID0_8812F)
#define BIT_CLEAR_R_WMAC_TXCSI_AID0_8812F(x)                                   \
	((x) & (~BITS_R_WMAC_TXCSI_AID0_8812F))
#define BIT_GET_R_WMAC_TXCSI_AID0_8812F(x)                                     \
	(((x) >> BIT_SHIFT_R_WMAC_TXCSI_AID0_8812F) &                          \
	 BIT_MASK_R_WMAC_TXCSI_AID0_8812F)
#define BIT_SET_R_WMAC_TXCSI_AID0_8812F(x, v)                                  \
	(BIT_CLEAR_R_WMAC_TXCSI_AID0_8812F(x) | BIT_R_WMAC_TXCSI_AID0_8812F(v))

#define BIT_SHIFT_R_WMAC_SOUNDING_RXADD_R0_H_V1_8812F 0
#define BIT_MASK_R_WMAC_SOUNDING_RXADD_R0_H_V1_8812F 0xffff
#define BIT_R_WMAC_SOUNDING_RXADD_R0_H_V1_8812F(x)                             \
	(((x) & BIT_MASK_R_WMAC_SOUNDING_RXADD_R0_H_V1_8812F)                  \
	 << BIT_SHIFT_R_WMAC_SOUNDING_RXADD_R0_H_V1_8812F)
#define BITS_R_WMAC_SOUNDING_RXADD_R0_H_V1_8812F                               \
	(BIT_MASK_R_WMAC_SOUNDING_RXADD_R0_H_V1_8812F                          \
	 << BIT_SHIFT_R_WMAC_SOUNDING_RXADD_R0_H_V1_8812F)
#define BIT_CLEAR_R_WMAC_SOUNDING_RXADD_R0_H_V1_8812F(x)                       \
	((x) & (~BITS_R_WMAC_SOUNDING_RXADD_R0_H_V1_8812F))
#define BIT_GET_R_WMAC_SOUNDING_RXADD_R0_H_V1_8812F(x)                         \
	(((x) >> BIT_SHIFT_R_WMAC_SOUNDING_RXADD_R0_H_V1_8812F) &              \
	 BIT_MASK_R_WMAC_SOUNDING_RXADD_R0_H_V1_8812F)
#define BIT_SET_R_WMAC_SOUNDING_RXADD_R0_H_V1_8812F(x, v)                      \
	(BIT_CLEAR_R_WMAC_SOUNDING_RXADD_R0_H_V1_8812F(x) |                    \
	 BIT_R_WMAC_SOUNDING_RXADD_R0_H_V1_8812F(v))

/* 2 REG_ASSOCIATED_BFMER1_INFO_8812F */

#define BIT_SHIFT_R_WMAC_SOUNDING_RXADD_R1_V1_8812F 0
#define BIT_MASK_R_WMAC_SOUNDING_RXADD_R1_V1_8812F 0xffffffffL
#define BIT_R_WMAC_SOUNDING_RXADD_R1_V1_8812F(x)                               \
	(((x) & BIT_MASK_R_WMAC_SOUNDING_RXADD_R1_V1_8812F)                    \
	 << BIT_SHIFT_R_WMAC_SOUNDING_RXADD_R1_V1_8812F)
#define BITS_R_WMAC_SOUNDING_RXADD_R1_V1_8812F                                 \
	(BIT_MASK_R_WMAC_SOUNDING_RXADD_R1_V1_8812F                            \
	 << BIT_SHIFT_R_WMAC_SOUNDING_RXADD_R1_V1_8812F)
#define BIT_CLEAR_R_WMAC_SOUNDING_RXADD_R1_V1_8812F(x)                         \
	((x) & (~BITS_R_WMAC_SOUNDING_RXADD_R1_V1_8812F))
#define BIT_GET_R_WMAC_SOUNDING_RXADD_R1_V1_8812F(x)                           \
	(((x) >> BIT_SHIFT_R_WMAC_SOUNDING_RXADD_R1_V1_8812F) &                \
	 BIT_MASK_R_WMAC_SOUNDING_RXADD_R1_V1_8812F)
#define BIT_SET_R_WMAC_SOUNDING_RXADD_R1_V1_8812F(x, v)                        \
	(BIT_CLEAR_R_WMAC_SOUNDING_RXADD_R1_V1_8812F(x) |                      \
	 BIT_R_WMAC_SOUNDING_RXADD_R1_V1_8812F(v))

/* 2 REG_ASSOCIATED_BFMER1_INFO_H_8812F */

#define BIT_SHIFT_R_WMAC_TXCSI_AID1_8812F 16
#define BIT_MASK_R_WMAC_TXCSI_AID1_8812F 0x1ff
#define BIT_R_WMAC_TXCSI_AID1_8812F(x)                                         \
	(((x) & BIT_MASK_R_WMAC_TXCSI_AID1_8812F)                              \
	 << BIT_SHIFT_R_WMAC_TXCSI_AID1_8812F)
#define BITS_R_WMAC_TXCSI_AID1_8812F                                           \
	(BIT_MASK_R_WMAC_TXCSI_AID1_8812F << BIT_SHIFT_R_WMAC_TXCSI_AID1_8812F)
#define BIT_CLEAR_R_WMAC_TXCSI_AID1_8812F(x)                                   \
	((x) & (~BITS_R_WMAC_TXCSI_AID1_8812F))
#define BIT_GET_R_WMAC_TXCSI_AID1_8812F(x)                                     \
	(((x) >> BIT_SHIFT_R_WMAC_TXCSI_AID1_8812F) &                          \
	 BIT_MASK_R_WMAC_TXCSI_AID1_8812F)
#define BIT_SET_R_WMAC_TXCSI_AID1_8812F(x, v)                                  \
	(BIT_CLEAR_R_WMAC_TXCSI_AID1_8812F(x) | BIT_R_WMAC_TXCSI_AID1_8812F(v))

#define BIT_SHIFT_R_WMAC_SOUNDING_RXADD_R1_H_V1_8812F 0
#define BIT_MASK_R_WMAC_SOUNDING_RXADD_R1_H_V1_8812F 0xffff
#define BIT_R_WMAC_SOUNDING_RXADD_R1_H_V1_8812F(x)                             \
	(((x) & BIT_MASK_R_WMAC_SOUNDING_RXADD_R1_H_V1_8812F)                  \
	 << BIT_SHIFT_R_WMAC_SOUNDING_RXADD_R1_H_V1_8812F)
#define BITS_R_WMAC_SOUNDING_RXADD_R1_H_V1_8812F                               \
	(BIT_MASK_R_WMAC_SOUNDING_RXADD_R1_H_V1_8812F                          \
	 << BIT_SHIFT_R_WMAC_SOUNDING_RXADD_R1_H_V1_8812F)
#define BIT_CLEAR_R_WMAC_SOUNDING_RXADD_R1_H_V1_8812F(x)                       \
	((x) & (~BITS_R_WMAC_SOUNDING_RXADD_R1_H_V1_8812F))
#define BIT_GET_R_WMAC_SOUNDING_RXADD_R1_H_V1_8812F(x)                         \
	(((x) >> BIT_SHIFT_R_WMAC_SOUNDING_RXADD_R1_H_V1_8812F) &              \
	 BIT_MASK_R_WMAC_SOUNDING_RXADD_R1_H_V1_8812F)
#define BIT_SET_R_WMAC_SOUNDING_RXADD_R1_H_V1_8812F(x, v)                      \
	(BIT_CLEAR_R_WMAC_SOUNDING_RXADD_R1_H_V1_8812F(x) |                    \
	 BIT_R_WMAC_SOUNDING_RXADD_R1_H_V1_8812F(v))

/* 2 REG_TX_CSI_RPT_PARAM_BW20_8812F (TX CSI REPORT PARAMETER REGISTER) */

#define BIT_SHIFT_R_WMAC_BFINFO_20M_1_8812F 16
#define BIT_MASK_R_WMAC_BFINFO_20M_1_8812F 0xfff
#define BIT_R_WMAC_BFINFO_20M_1_8812F(x)                                       \
	(((x) & BIT_MASK_R_WMAC_BFINFO_20M_1_8812F)                            \
	 << BIT_SHIFT_R_WMAC_BFINFO_20M_1_8812F)
#define BITS_R_WMAC_BFINFO_20M_1_8812F                                         \
	(BIT_MASK_R_WMAC_BFINFO_20M_1_8812F                                    \
	 << BIT_SHIFT_R_WMAC_BFINFO_20M_1_8812F)
#define BIT_CLEAR_R_WMAC_BFINFO_20M_1_8812F(x)                                 \
	((x) & (~BITS_R_WMAC_BFINFO_20M_1_8812F))
#define BIT_GET_R_WMAC_BFINFO_20M_1_8812F(x)                                   \
	(((x) >> BIT_SHIFT_R_WMAC_BFINFO_20M_1_8812F) &                        \
	 BIT_MASK_R_WMAC_BFINFO_20M_1_8812F)
#define BIT_SET_R_WMAC_BFINFO_20M_1_8812F(x, v)                                \
	(BIT_CLEAR_R_WMAC_BFINFO_20M_1_8812F(x) |                              \
	 BIT_R_WMAC_BFINFO_20M_1_8812F(v))

#define BIT_SHIFT_R_WMAC_BFINFO_20M_0_8812F 0
#define BIT_MASK_R_WMAC_BFINFO_20M_0_8812F 0xfff
#define BIT_R_WMAC_BFINFO_20M_0_8812F(x)                                       \
	(((x) & BIT_MASK_R_WMAC_BFINFO_20M_0_8812F)                            \
	 << BIT_SHIFT_R_WMAC_BFINFO_20M_0_8812F)
#define BITS_R_WMAC_BFINFO_20M_0_8812F                                         \
	(BIT_MASK_R_WMAC_BFINFO_20M_0_8812F                                    \
	 << BIT_SHIFT_R_WMAC_BFINFO_20M_0_8812F)
#define BIT_CLEAR_R_WMAC_BFINFO_20M_0_8812F(x)                                 \
	((x) & (~BITS_R_WMAC_BFINFO_20M_0_8812F))
#define BIT_GET_R_WMAC_BFINFO_20M_0_8812F(x)                                   \
	(((x) >> BIT_SHIFT_R_WMAC_BFINFO_20M_0_8812F) &                        \
	 BIT_MASK_R_WMAC_BFINFO_20M_0_8812F)
#define BIT_SET_R_WMAC_BFINFO_20M_0_8812F(x, v)                                \
	(BIT_CLEAR_R_WMAC_BFINFO_20M_0_8812F(x) |                              \
	 BIT_R_WMAC_BFINFO_20M_0_8812F(v))

/* 2 REG_TX_CSI_RPT_PARAM_BW40_8812F (TX CSI REPORT PARAMETER_BW40 REGISTER) */

#define BIT_SHIFT_WMAC_RESP_ANTD_8812F 12
#define BIT_MASK_WMAC_RESP_ANTD_8812F 0xf
#define BIT_WMAC_RESP_ANTD_8812F(x)                                            \
	(((x) & BIT_MASK_WMAC_RESP_ANTD_8812F)                                 \
	 << BIT_SHIFT_WMAC_RESP_ANTD_8812F)
#define BITS_WMAC_RESP_ANTD_8812F                                              \
	(BIT_MASK_WMAC_RESP_ANTD_8812F << BIT_SHIFT_WMAC_RESP_ANTD_8812F)
#define BIT_CLEAR_WMAC_RESP_ANTD_8812F(x) ((x) & (~BITS_WMAC_RESP_ANTD_8812F))
#define BIT_GET_WMAC_RESP_ANTD_8812F(x)                                        \
	(((x) >> BIT_SHIFT_WMAC_RESP_ANTD_8812F) &                             \
	 BIT_MASK_WMAC_RESP_ANTD_8812F)
#define BIT_SET_WMAC_RESP_ANTD_8812F(x, v)                                     \
	(BIT_CLEAR_WMAC_RESP_ANTD_8812F(x) | BIT_WMAC_RESP_ANTD_8812F(v))

#define BIT_SHIFT_WMAC_RESP_ANTC_8812F 8
#define BIT_MASK_WMAC_RESP_ANTC_8812F 0xf
#define BIT_WMAC_RESP_ANTC_8812F(x)                                            \
	(((x) & BIT_MASK_WMAC_RESP_ANTC_8812F)                                 \
	 << BIT_SHIFT_WMAC_RESP_ANTC_8812F)
#define BITS_WMAC_RESP_ANTC_8812F                                              \
	(BIT_MASK_WMAC_RESP_ANTC_8812F << BIT_SHIFT_WMAC_RESP_ANTC_8812F)
#define BIT_CLEAR_WMAC_RESP_ANTC_8812F(x) ((x) & (~BITS_WMAC_RESP_ANTC_8812F))
#define BIT_GET_WMAC_RESP_ANTC_8812F(x)                                        \
	(((x) >> BIT_SHIFT_WMAC_RESP_ANTC_8812F) &                             \
	 BIT_MASK_WMAC_RESP_ANTC_8812F)
#define BIT_SET_WMAC_RESP_ANTC_8812F(x, v)                                     \
	(BIT_CLEAR_WMAC_RESP_ANTC_8812F(x) | BIT_WMAC_RESP_ANTC_8812F(v))

#define BIT_SHIFT_WMAC_RESP_ANTB_8812F 4
#define BIT_MASK_WMAC_RESP_ANTB_8812F 0xf
#define BIT_WMAC_RESP_ANTB_8812F(x)                                            \
	(((x) & BIT_MASK_WMAC_RESP_ANTB_8812F)                                 \
	 << BIT_SHIFT_WMAC_RESP_ANTB_8812F)
#define BITS_WMAC_RESP_ANTB_8812F                                              \
	(BIT_MASK_WMAC_RESP_ANTB_8812F << BIT_SHIFT_WMAC_RESP_ANTB_8812F)
#define BIT_CLEAR_WMAC_RESP_ANTB_8812F(x) ((x) & (~BITS_WMAC_RESP_ANTB_8812F))
#define BIT_GET_WMAC_RESP_ANTB_8812F(x)                                        \
	(((x) >> BIT_SHIFT_WMAC_RESP_ANTB_8812F) &                             \
	 BIT_MASK_WMAC_RESP_ANTB_8812F)
#define BIT_SET_WMAC_RESP_ANTB_8812F(x, v)                                     \
	(BIT_CLEAR_WMAC_RESP_ANTB_8812F(x) | BIT_WMAC_RESP_ANTB_8812F(v))

#define BIT_SHIFT_WMAC_RESP_ANTA_8812F 0
#define BIT_MASK_WMAC_RESP_ANTA_8812F 0xf
#define BIT_WMAC_RESP_ANTA_8812F(x)                                            \
	(((x) & BIT_MASK_WMAC_RESP_ANTA_8812F)                                 \
	 << BIT_SHIFT_WMAC_RESP_ANTA_8812F)
#define BITS_WMAC_RESP_ANTA_8812F                                              \
	(BIT_MASK_WMAC_RESP_ANTA_8812F << BIT_SHIFT_WMAC_RESP_ANTA_8812F)
#define BIT_CLEAR_WMAC_RESP_ANTA_8812F(x) ((x) & (~BITS_WMAC_RESP_ANTA_8812F))
#define BIT_GET_WMAC_RESP_ANTA_8812F(x)                                        \
	(((x) >> BIT_SHIFT_WMAC_RESP_ANTA_8812F) &                             \
	 BIT_MASK_WMAC_RESP_ANTA_8812F)
#define BIT_SET_WMAC_RESP_ANTA_8812F(x, v)                                     \
	(BIT_CLEAR_WMAC_RESP_ANTA_8812F(x) | BIT_WMAC_RESP_ANTA_8812F(v))

/* 2 REG_CSI_PTR_8812F */

#define BIT_SHIFT_CSI_RADDR_LATCH_V2_8812F 16
#define BIT_MASK_CSI_RADDR_LATCH_V2_8812F 0xffff
#define BIT_CSI_RADDR_LATCH_V2_8812F(x)                                        \
	(((x) & BIT_MASK_CSI_RADDR_LATCH_V2_8812F)                             \
	 << BIT_SHIFT_CSI_RADDR_LATCH_V2_8812F)
#define BITS_CSI_RADDR_LATCH_V2_8812F                                          \
	(BIT_MASK_CSI_RADDR_LATCH_V2_8812F                                     \
	 << BIT_SHIFT_CSI_RADDR_LATCH_V2_8812F)
#define BIT_CLEAR_CSI_RADDR_LATCH_V2_8812F(x)                                  \
	((x) & (~BITS_CSI_RADDR_LATCH_V2_8812F))
#define BIT_GET_CSI_RADDR_LATCH_V2_8812F(x)                                    \
	(((x) >> BIT_SHIFT_CSI_RADDR_LATCH_V2_8812F) &                         \
	 BIT_MASK_CSI_RADDR_LATCH_V2_8812F)
#define BIT_SET_CSI_RADDR_LATCH_V2_8812F(x, v)                                 \
	(BIT_CLEAR_CSI_RADDR_LATCH_V2_8812F(x) |                               \
	 BIT_CSI_RADDR_LATCH_V2_8812F(v))

#define BIT_SHIFT_CSI_WADDR_LATCH_V2_8812F 0
#define BIT_MASK_CSI_WADDR_LATCH_V2_8812F 0xffff
#define BIT_CSI_WADDR_LATCH_V2_8812F(x)                                        \
	(((x) & BIT_MASK_CSI_WADDR_LATCH_V2_8812F)                             \
	 << BIT_SHIFT_CSI_WADDR_LATCH_V2_8812F)
#define BITS_CSI_WADDR_LATCH_V2_8812F                                          \
	(BIT_MASK_CSI_WADDR_LATCH_V2_8812F                                     \
	 << BIT_SHIFT_CSI_WADDR_LATCH_V2_8812F)
#define BIT_CLEAR_CSI_WADDR_LATCH_V2_8812F(x)                                  \
	((x) & (~BITS_CSI_WADDR_LATCH_V2_8812F))
#define BIT_GET_CSI_WADDR_LATCH_V2_8812F(x)                                    \
	(((x) >> BIT_SHIFT_CSI_WADDR_LATCH_V2_8812F) &                         \
	 BIT_MASK_CSI_WADDR_LATCH_V2_8812F)
#define BIT_SET_CSI_WADDR_LATCH_V2_8812F(x, v)                                 \
	(BIT_CLEAR_CSI_WADDR_LATCH_V2_8812F(x) |                               \
	 BIT_CSI_WADDR_LATCH_V2_8812F(v))

/* 2 REG_BCN_PSR_RPT2_8812F (BEACON PARSER REPORT REGISTER2) */

#define BIT_SHIFT_DTIM_CNT2_8812F 24
#define BIT_MASK_DTIM_CNT2_8812F 0xff
#define BIT_DTIM_CNT2_8812F(x)                                                 \
	(((x) & BIT_MASK_DTIM_CNT2_8812F) << BIT_SHIFT_DTIM_CNT2_8812F)
#define BITS_DTIM_CNT2_8812F                                                   \
	(BIT_MASK_DTIM_CNT2_8812F << BIT_SHIFT_DTIM_CNT2_8812F)
#define BIT_CLEAR_DTIM_CNT2_8812F(x) ((x) & (~BITS_DTIM_CNT2_8812F))
#define BIT_GET_DTIM_CNT2_8812F(x)                                             \
	(((x) >> BIT_SHIFT_DTIM_CNT2_8812F) & BIT_MASK_DTIM_CNT2_8812F)
#define BIT_SET_DTIM_CNT2_8812F(x, v)                                          \
	(BIT_CLEAR_DTIM_CNT2_8812F(x) | BIT_DTIM_CNT2_8812F(v))

#define BIT_SHIFT_DTIM_PERIOD2_8812F 16
#define BIT_MASK_DTIM_PERIOD2_8812F 0xff
#define BIT_DTIM_PERIOD2_8812F(x)                                              \
	(((x) & BIT_MASK_DTIM_PERIOD2_8812F) << BIT_SHIFT_DTIM_PERIOD2_8812F)
#define BITS_DTIM_PERIOD2_8812F                                                \
	(BIT_MASK_DTIM_PERIOD2_8812F << BIT_SHIFT_DTIM_PERIOD2_8812F)
#define BIT_CLEAR_DTIM_PERIOD2_8812F(x) ((x) & (~BITS_DTIM_PERIOD2_8812F))
#define BIT_GET_DTIM_PERIOD2_8812F(x)                                          \
	(((x) >> BIT_SHIFT_DTIM_PERIOD2_8812F) & BIT_MASK_DTIM_PERIOD2_8812F)
#define BIT_SET_DTIM_PERIOD2_8812F(x, v)                                       \
	(BIT_CLEAR_DTIM_PERIOD2_8812F(x) | BIT_DTIM_PERIOD2_8812F(v))

#define BIT_DTIM2_8812F BIT(15)
#define BIT_TIM2_8812F BIT(14)
#define BIT_RPT_VALID_8812F BIT(13)

#define BIT_SHIFT_PS_AID_2_8812F 0
#define BIT_MASK_PS_AID_2_8812F 0x7ff
#define BIT_PS_AID_2_8812F(x)                                                  \
	(((x) & BIT_MASK_PS_AID_2_8812F) << BIT_SHIFT_PS_AID_2_8812F)
#define BITS_PS_AID_2_8812F                                                    \
	(BIT_MASK_PS_AID_2_8812F << BIT_SHIFT_PS_AID_2_8812F)
#define BIT_CLEAR_PS_AID_2_8812F(x) ((x) & (~BITS_PS_AID_2_8812F))
#define BIT_GET_PS_AID_2_8812F(x)                                              \
	(((x) >> BIT_SHIFT_PS_AID_2_8812F) & BIT_MASK_PS_AID_2_8812F)
#define BIT_SET_PS_AID_2_8812F(x, v)                                           \
	(BIT_CLEAR_PS_AID_2_8812F(x) | BIT_PS_AID_2_8812F(v))

/* 2 REG_BCN_PSR_RPT3_8812F (BEACON PARSER REPORT REGISTER3) */

#define BIT_SHIFT_DTIM_CNT3_8812F 24
#define BIT_MASK_DTIM_CNT3_8812F 0xff
#define BIT_DTIM_CNT3_8812F(x)                                                 \
	(((x) & BIT_MASK_DTIM_CNT3_8812F) << BIT_SHIFT_DTIM_CNT3_8812F)
#define BITS_DTIM_CNT3_8812F                                                   \
	(BIT_MASK_DTIM_CNT3_8812F << BIT_SHIFT_DTIM_CNT3_8812F)
#define BIT_CLEAR_DTIM_CNT3_8812F(x) ((x) & (~BITS_DTIM_CNT3_8812F))
#define BIT_GET_DTIM_CNT3_8812F(x)                                             \
	(((x) >> BIT_SHIFT_DTIM_CNT3_8812F) & BIT_MASK_DTIM_CNT3_8812F)
#define BIT_SET_DTIM_CNT3_8812F(x, v)                                          \
	(BIT_CLEAR_DTIM_CNT3_8812F(x) | BIT_DTIM_CNT3_8812F(v))

#define BIT_SHIFT_DTIM_PERIOD3_8812F 16
#define BIT_MASK_DTIM_PERIOD3_8812F 0xff
#define BIT_DTIM_PERIOD3_8812F(x)                                              \
	(((x) & BIT_MASK_DTIM_PERIOD3_8812F) << BIT_SHIFT_DTIM_PERIOD3_8812F)
#define BITS_DTIM_PERIOD3_8812F                                                \
	(BIT_MASK_DTIM_PERIOD3_8812F << BIT_SHIFT_DTIM_PERIOD3_8812F)
#define BIT_CLEAR_DTIM_PERIOD3_8812F(x) ((x) & (~BITS_DTIM_PERIOD3_8812F))
#define BIT_GET_DTIM_PERIOD3_8812F(x)                                          \
	(((x) >> BIT_SHIFT_DTIM_PERIOD3_8812F) & BIT_MASK_DTIM_PERIOD3_8812F)
#define BIT_SET_DTIM_PERIOD3_8812F(x, v)                                       \
	(BIT_CLEAR_DTIM_PERIOD3_8812F(x) | BIT_DTIM_PERIOD3_8812F(v))

#define BIT_DTIM3_8812F BIT(15)
#define BIT_TIM3_8812F BIT(14)
#define BIT_RPT_VALID_8812F BIT(13)

#define BIT_SHIFT_PS_AID_3_8812F 0
#define BIT_MASK_PS_AID_3_8812F 0x7ff
#define BIT_PS_AID_3_8812F(x)                                                  \
	(((x) & BIT_MASK_PS_AID_3_8812F) << BIT_SHIFT_PS_AID_3_8812F)
#define BITS_PS_AID_3_8812F                                                    \
	(BIT_MASK_PS_AID_3_8812F << BIT_SHIFT_PS_AID_3_8812F)
#define BIT_CLEAR_PS_AID_3_8812F(x) ((x) & (~BITS_PS_AID_3_8812F))
#define BIT_GET_PS_AID_3_8812F(x)                                              \
	(((x) >> BIT_SHIFT_PS_AID_3_8812F) & BIT_MASK_PS_AID_3_8812F)
#define BIT_SET_PS_AID_3_8812F(x, v)                                           \
	(BIT_CLEAR_PS_AID_3_8812F(x) | BIT_PS_AID_3_8812F(v))

/* 2 REG_BCN_PSR_RPT4_8812F (BEACON PARSER REPORT REGISTER4) */

#define BIT_SHIFT_DTIM_CNT4_8812F 24
#define BIT_MASK_DTIM_CNT4_8812F 0xff
#define BIT_DTIM_CNT4_8812F(x)                                                 \
	(((x) & BIT_MASK_DTIM_CNT4_8812F) << BIT_SHIFT_DTIM_CNT4_8812F)
#define BITS_DTIM_CNT4_8812F                                                   \
	(BIT_MASK_DTIM_CNT4_8812F << BIT_SHIFT_DTIM_CNT4_8812F)
#define BIT_CLEAR_DTIM_CNT4_8812F(x) ((x) & (~BITS_DTIM_CNT4_8812F))
#define BIT_GET_DTIM_CNT4_8812F(x)                                             \
	(((x) >> BIT_SHIFT_DTIM_CNT4_8812F) & BIT_MASK_DTIM_CNT4_8812F)
#define BIT_SET_DTIM_CNT4_8812F(x, v)                                          \
	(BIT_CLEAR_DTIM_CNT4_8812F(x) | BIT_DTIM_CNT4_8812F(v))

#define BIT_SHIFT_DTIM_PERIOD4_8812F 16
#define BIT_MASK_DTIM_PERIOD4_8812F 0xff
#define BIT_DTIM_PERIOD4_8812F(x)                                              \
	(((x) & BIT_MASK_DTIM_PERIOD4_8812F) << BIT_SHIFT_DTIM_PERIOD4_8812F)
#define BITS_DTIM_PERIOD4_8812F                                                \
	(BIT_MASK_DTIM_PERIOD4_8812F << BIT_SHIFT_DTIM_PERIOD4_8812F)
#define BIT_CLEAR_DTIM_PERIOD4_8812F(x) ((x) & (~BITS_DTIM_PERIOD4_8812F))
#define BIT_GET_DTIM_PERIOD4_8812F(x)                                          \
	(((x) >> BIT_SHIFT_DTIM_PERIOD4_8812F) & BIT_MASK_DTIM_PERIOD4_8812F)
#define BIT_SET_DTIM_PERIOD4_8812F(x, v)                                       \
	(BIT_CLEAR_DTIM_PERIOD4_8812F(x) | BIT_DTIM_PERIOD4_8812F(v))

#define BIT_DTIM4_8812F BIT(15)
#define BIT_TIM4_8812F BIT(14)
#define BIT_RPT_VALID_8812F BIT(13)

#define BIT_SHIFT_PS_AID_4_8812F 0
#define BIT_MASK_PS_AID_4_8812F 0x7ff
#define BIT_PS_AID_4_8812F(x)                                                  \
	(((x) & BIT_MASK_PS_AID_4_8812F) << BIT_SHIFT_PS_AID_4_8812F)
#define BITS_PS_AID_4_8812F                                                    \
	(BIT_MASK_PS_AID_4_8812F << BIT_SHIFT_PS_AID_4_8812F)
#define BIT_CLEAR_PS_AID_4_8812F(x) ((x) & (~BITS_PS_AID_4_8812F))
#define BIT_GET_PS_AID_4_8812F(x)                                              \
	(((x) >> BIT_SHIFT_PS_AID_4_8812F) & BIT_MASK_PS_AID_4_8812F)
#define BIT_SET_PS_AID_4_8812F(x, v)                                           \
	(BIT_CLEAR_PS_AID_4_8812F(x) | BIT_PS_AID_4_8812F(v))

/* 2 REG_A1_ADDR_MASK_8812F (A1 ADDR MASK REGISTER) */

#define BIT_SHIFT_A1_ADDR_MASK_8812F 0
#define BIT_MASK_A1_ADDR_MASK_8812F 0xffffffffL
#define BIT_A1_ADDR_MASK_8812F(x)                                              \
	(((x) & BIT_MASK_A1_ADDR_MASK_8812F) << BIT_SHIFT_A1_ADDR_MASK_8812F)
#define BITS_A1_ADDR_MASK_8812F                                                \
	(BIT_MASK_A1_ADDR_MASK_8812F << BIT_SHIFT_A1_ADDR_MASK_8812F)
#define BIT_CLEAR_A1_ADDR_MASK_8812F(x) ((x) & (~BITS_A1_ADDR_MASK_8812F))
#define BIT_GET_A1_ADDR_MASK_8812F(x)                                          \
	(((x) >> BIT_SHIFT_A1_ADDR_MASK_8812F) & BIT_MASK_A1_ADDR_MASK_8812F)
#define BIT_SET_A1_ADDR_MASK_8812F(x, v)                                       \
	(BIT_CLEAR_A1_ADDR_MASK_8812F(x) | BIT_A1_ADDR_MASK_8812F(v))

/* 2 REG_RXPSF_CTRL_8812F */
#define BIT_RXGCK_FIFOTHR_EN_8812F BIT(28)

#define BIT_SHIFT_RXGCK_VHT_FIFOTHR_8812F 26
#define BIT_MASK_RXGCK_VHT_FIFOTHR_8812F 0x3
#define BIT_RXGCK_VHT_FIFOTHR_8812F(x)                                         \
	(((x) & BIT_MASK_RXGCK_VHT_FIFOTHR_8812F)                              \
	 << BIT_SHIFT_RXGCK_VHT_FIFOTHR_8812F)
#define BITS_RXGCK_VHT_FIFOTHR_8812F                                           \
	(BIT_MASK_RXGCK_VHT_FIFOTHR_8812F << BIT_SHIFT_RXGCK_VHT_FIFOTHR_8812F)
#define BIT_CLEAR_RXGCK_VHT_FIFOTHR_8812F(x)                                   \
	((x) & (~BITS_RXGCK_VHT_FIFOTHR_8812F))
#define BIT_GET_RXGCK_VHT_FIFOTHR_8812F(x)                                     \
	(((x) >> BIT_SHIFT_RXGCK_VHT_FIFOTHR_8812F) &                          \
	 BIT_MASK_RXGCK_VHT_FIFOTHR_8812F)
#define BIT_SET_RXGCK_VHT_FIFOTHR_8812F(x, v)                                  \
	(BIT_CLEAR_RXGCK_VHT_FIFOTHR_8812F(x) | BIT_RXGCK_VHT_FIFOTHR_8812F(v))

#define BIT_SHIFT_RXGCK_HT_FIFOTHR_8812F 24
#define BIT_MASK_RXGCK_HT_FIFOTHR_8812F 0x3
#define BIT_RXGCK_HT_FIFOTHR_8812F(x)                                          \
	(((x) & BIT_MASK_RXGCK_HT_FIFOTHR_8812F)                               \
	 << BIT_SHIFT_RXGCK_HT_FIFOTHR_8812F)
#define BITS_RXGCK_HT_FIFOTHR_8812F                                            \
	(BIT_MASK_RXGCK_HT_FIFOTHR_8812F << BIT_SHIFT_RXGCK_HT_FIFOTHR_8812F)
#define BIT_CLEAR_RXGCK_HT_FIFOTHR_8812F(x)                                    \
	((x) & (~BITS_RXGCK_HT_FIFOTHR_8812F))
#define BIT_GET_RXGCK_HT_FIFOTHR_8812F(x)                                      \
	(((x) >> BIT_SHIFT_RXGCK_HT_FIFOTHR_8812F) &                           \
	 BIT_MASK_RXGCK_HT_FIFOTHR_8812F)
#define BIT_SET_RXGCK_HT_FIFOTHR_8812F(x, v)                                   \
	(BIT_CLEAR_RXGCK_HT_FIFOTHR_8812F(x) | BIT_RXGCK_HT_FIFOTHR_8812F(v))

#define BIT_SHIFT_RXGCK_OFDM_FIFOTHR_8812F 22
#define BIT_MASK_RXGCK_OFDM_FIFOTHR_8812F 0x3
#define BIT_RXGCK_OFDM_FIFOTHR_8812F(x)                                        \
	(((x) & BIT_MASK_RXGCK_OFDM_FIFOTHR_8812F)                             \
	 << BIT_SHIFT_RXGCK_OFDM_FIFOTHR_8812F)
#define BITS_RXGCK_OFDM_FIFOTHR_8812F                                          \
	(BIT_MASK_RXGCK_OFDM_FIFOTHR_8812F                                     \
	 << BIT_SHIFT_RXGCK_OFDM_FIFOTHR_8812F)
#define BIT_CLEAR_RXGCK_OFDM_FIFOTHR_8812F(x)                                  \
	((x) & (~BITS_RXGCK_OFDM_FIFOTHR_8812F))
#define BIT_GET_RXGCK_OFDM_FIFOTHR_8812F(x)                                    \
	(((x) >> BIT_SHIFT_RXGCK_OFDM_FIFOTHR_8812F) &                         \
	 BIT_MASK_RXGCK_OFDM_FIFOTHR_8812F)
#define BIT_SET_RXGCK_OFDM_FIFOTHR_8812F(x, v)                                 \
	(BIT_CLEAR_RXGCK_OFDM_FIFOTHR_8812F(x) |                               \
	 BIT_RXGCK_OFDM_FIFOTHR_8812F(v))

#define BIT_SHIFT_RXGCK_CCK_FIFOTHR_8812F 20
#define BIT_MASK_RXGCK_CCK_FIFOTHR_8812F 0x3
#define BIT_RXGCK_CCK_FIFOTHR_8812F(x)                                         \
	(((x) & BIT_MASK_RXGCK_CCK_FIFOTHR_8812F)                              \
	 << BIT_SHIFT_RXGCK_CCK_FIFOTHR_8812F)
#define BITS_RXGCK_CCK_FIFOTHR_8812F                                           \
	(BIT_MASK_RXGCK_CCK_FIFOTHR_8812F << BIT_SHIFT_RXGCK_CCK_FIFOTHR_8812F)
#define BIT_CLEAR_RXGCK_CCK_FIFOTHR_8812F(x)                                   \
	((x) & (~BITS_RXGCK_CCK_FIFOTHR_8812F))
#define BIT_GET_RXGCK_CCK_FIFOTHR_8812F(x)                                     \
	(((x) >> BIT_SHIFT_RXGCK_CCK_FIFOTHR_8812F) &                          \
	 BIT_MASK_RXGCK_CCK_FIFOTHR_8812F)
#define BIT_SET_RXGCK_CCK_FIFOTHR_8812F(x, v)                                  \
	(BIT_CLEAR_RXGCK_CCK_FIFOTHR_8812F(x) | BIT_RXGCK_CCK_FIFOTHR_8812F(v))

#define BIT_SHIFT_RXGCK_ENTRY_DELAY_8812F 17
#define BIT_MASK_RXGCK_ENTRY_DELAY_8812F 0x7
#define BIT_RXGCK_ENTRY_DELAY_8812F(x)                                         \
	(((x) & BIT_MASK_RXGCK_ENTRY_DELAY_8812F)                              \
	 << BIT_SHIFT_RXGCK_ENTRY_DELAY_8812F)
#define BITS_RXGCK_ENTRY_DELAY_8812F                                           \
	(BIT_MASK_RXGCK_ENTRY_DELAY_8812F << BIT_SHIFT_RXGCK_ENTRY_DELAY_8812F)
#define BIT_CLEAR_RXGCK_ENTRY_DELAY_8812F(x)                                   \
	((x) & (~BITS_RXGCK_ENTRY_DELAY_8812F))
#define BIT_GET_RXGCK_ENTRY_DELAY_8812F(x)                                     \
	(((x) >> BIT_SHIFT_RXGCK_ENTRY_DELAY_8812F) &                          \
	 BIT_MASK_RXGCK_ENTRY_DELAY_8812F)
#define BIT_SET_RXGCK_ENTRY_DELAY_8812F(x, v)                                  \
	(BIT_CLEAR_RXGCK_ENTRY_DELAY_8812F(x) | BIT_RXGCK_ENTRY_DELAY_8812F(v))

#define BIT_RXGCK_OFDMCCA_EN_8812F BIT(16)

#define BIT_SHIFT_RXPSF_PKTLENTHR_8812F 13
#define BIT_MASK_RXPSF_PKTLENTHR_8812F 0x7
#define BIT_RXPSF_PKTLENTHR_8812F(x)                                           \
	(((x) & BIT_MASK_RXPSF_PKTLENTHR_8812F)                                \
	 << BIT_SHIFT_RXPSF_PKTLENTHR_8812F)
#define BITS_RXPSF_PKTLENTHR_8812F                                             \
	(BIT_MASK_RXPSF_PKTLENTHR_8812F << BIT_SHIFT_RXPSF_PKTLENTHR_8812F)
#define BIT_CLEAR_RXPSF_PKTLENTHR_8812F(x) ((x) & (~BITS_RXPSF_PKTLENTHR_8812F))
#define BIT_GET_RXPSF_PKTLENTHR_8812F(x)                                       \
	(((x) >> BIT_SHIFT_RXPSF_PKTLENTHR_8812F) &                            \
	 BIT_MASK_RXPSF_PKTLENTHR_8812F)
#define BIT_SET_RXPSF_PKTLENTHR_8812F(x, v)                                    \
	(BIT_CLEAR_RXPSF_PKTLENTHR_8812F(x) | BIT_RXPSF_PKTLENTHR_8812F(v))

#define BIT_RXPSF_CTRLEN_8812F BIT(12)
#define BIT_RXPSF_VHTCHKEN_8812F BIT(11)
#define BIT_RXPSF_HTCHKEN_8812F BIT(10)
#define BIT_RXPSF_OFDMCHKEN_8812F BIT(9)
#define BIT_RXPSF_CCKCHKEN_8812F BIT(8)
#define BIT_RXPSF_OFDMRST_8812F BIT(7)
#define BIT_RXPSF_CCKRST_8812F BIT(6)
#define BIT_RXPSF_MHCHKEN_8812F BIT(5)
#define BIT_RXPSF_CONT_ERRCHKEN_8812F BIT(4)
#define BIT_RXPSF_ALL_ERRCHKEN_8812F BIT(3)

#define BIT_SHIFT_RXPSF_ERRTHR_8812F 0
#define BIT_MASK_RXPSF_ERRTHR_8812F 0x7
#define BIT_RXPSF_ERRTHR_8812F(x)                                              \
	(((x) & BIT_MASK_RXPSF_ERRTHR_8812F) << BIT_SHIFT_RXPSF_ERRTHR_8812F)
#define BITS_RXPSF_ERRTHR_8812F                                                \
	(BIT_MASK_RXPSF_ERRTHR_8812F << BIT_SHIFT_RXPSF_ERRTHR_8812F)
#define BIT_CLEAR_RXPSF_ERRTHR_8812F(x) ((x) & (~BITS_RXPSF_ERRTHR_8812F))
#define BIT_GET_RXPSF_ERRTHR_8812F(x)                                          \
	(((x) >> BIT_SHIFT_RXPSF_ERRTHR_8812F) & BIT_MASK_RXPSF_ERRTHR_8812F)
#define BIT_SET_RXPSF_ERRTHR_8812F(x, v)                                       \
	(BIT_CLEAR_RXPSF_ERRTHR_8812F(x) | BIT_RXPSF_ERRTHR_8812F(v))

/* 2 REG_RXPSF_TYPE_CTRL_8812F */
#define BIT_RXPSF_DATA15EN_8812F BIT(31)
#define BIT_RXPSF_DATA14EN_8812F BIT(30)
#define BIT_RXPSF_DATA13EN_8812F BIT(29)
#define BIT_RXPSF_DATA12EN_8812F BIT(28)
#define BIT_RXPSF_DATA11EN_8812F BIT(27)
#define BIT_RXPSF_DATA10EN_8812F BIT(26)
#define BIT_RXPSF_DATA9EN_8812F BIT(25)
#define BIT_RXPSF_DATA8EN_8812F BIT(24)
#define BIT_RXPSF_DATA7EN_8812F BIT(23)
#define BIT_RXPSF_DATA6EN_8812F BIT(22)
#define BIT_RXPSF_DATA5EN_8812F BIT(21)
#define BIT_RXPSF_DATA4EN_8812F BIT(20)
#define BIT_RXPSF_DATA3EN_8812F BIT(19)
#define BIT_RXPSF_DATA2EN_8812F BIT(18)
#define BIT_RXPSF_DATA1EN_8812F BIT(17)
#define BIT_RXPSF_DATA0EN_8812F BIT(16)
#define BIT_RXPSF_MGT15EN_8812F BIT(15)
#define BIT_RXPSF_MGT14EN_8812F BIT(14)
#define BIT_RXPSF_MGT13EN_8812F BIT(13)
#define BIT_RXPSF_MGT12EN_8812F BIT(12)
#define BIT_RXPSF_MGT11EN_8812F BIT(11)
#define BIT_RXPSF_MGT10EN_8812F BIT(10)
#define BIT_RXPSF_MGT9EN_8812F BIT(9)
#define BIT_RXPSF_MGT8EN_8812F BIT(8)
#define BIT_RXPSF_MGT7EN_8812F BIT(7)
#define BIT_RXPSF_MGT6EN_8812F BIT(6)
#define BIT_RXPSF_MGT5EN_8812F BIT(5)
#define BIT_RXPSF_MGT4EN_8812F BIT(4)
#define BIT_RXPSF_MGT3EN_8812F BIT(3)
#define BIT_RXPSF_MGT2EN_8812F BIT(2)
#define BIT_RXPSF_MGT1EN_8812F BIT(1)
#define BIT_RXPSF_MGT0EN_8812F BIT(0)

/* 2 REG_CAM_ACCESS_CTRL_8812F */
#define BIT_INDIRECT_ERR_8812F BIT(6)
#define BIT_DIRECT_ERR_8812F BIT(5)
#define BIT_DIR_ACCESS_EN_RX_BA_8812F BIT(4)
#define BIT_DIR_ACCESS_EN_MBSSIDCAM_8812F BIT(3)
#define BIT_DIR_ACCESS_EN_KEY_8812F BIT(2)
#define BIT_DIR_ACCESS_EN_WOWLAN_8812F BIT(1)
#define BIT_DIR_ACCESS_EN_FW_FILTER_8812F BIT(0)

/* 2 REG_HT_SND_REF_RATE_8812F */

#define BIT_SHIFT_WMAC_HT_CSI_RATE_8812F 0
#define BIT_MASK_WMAC_HT_CSI_RATE_8812F 0x3f
#define BIT_WMAC_HT_CSI_RATE_8812F(x)                                          \
	(((x) & BIT_MASK_WMAC_HT_CSI_RATE_8812F)                               \
	 << BIT_SHIFT_WMAC_HT_CSI_RATE_8812F)
#define BITS_WMAC_HT_CSI_RATE_8812F                                            \
	(BIT_MASK_WMAC_HT_CSI_RATE_8812F << BIT_SHIFT_WMAC_HT_CSI_RATE_8812F)
#define BIT_CLEAR_WMAC_HT_CSI_RATE_8812F(x)                                    \
	((x) & (~BITS_WMAC_HT_CSI_RATE_8812F))
#define BIT_GET_WMAC_HT_CSI_RATE_8812F(x)                                      \
	(((x) >> BIT_SHIFT_WMAC_HT_CSI_RATE_8812F) &                           \
	 BIT_MASK_WMAC_HT_CSI_RATE_8812F)
#define BIT_SET_WMAC_HT_CSI_RATE_8812F(x, v)                                   \
	(BIT_CLEAR_WMAC_HT_CSI_RATE_8812F(x) | BIT_WMAC_HT_CSI_RATE_8812F(v))

/* 2 REG_RSVD_8812F */

/* 2 REG_MACID2_8812F (MAC ID2 REGISTER) */

#define BIT_SHIFT_MACID2_V1_8812F 0
#define BIT_MASK_MACID2_V1_8812F 0xffffffffL
#define BIT_MACID2_V1_8812F(x)                                                 \
	(((x) & BIT_MASK_MACID2_V1_8812F) << BIT_SHIFT_MACID2_V1_8812F)
#define BITS_MACID2_V1_8812F                                                   \
	(BIT_MASK_MACID2_V1_8812F << BIT_SHIFT_MACID2_V1_8812F)
#define BIT_CLEAR_MACID2_V1_8812F(x) ((x) & (~BITS_MACID2_V1_8812F))
#define BIT_GET_MACID2_V1_8812F(x)                                             \
	(((x) >> BIT_SHIFT_MACID2_V1_8812F) & BIT_MASK_MACID2_V1_8812F)
#define BIT_SET_MACID2_V1_8812F(x, v)                                          \
	(BIT_CLEAR_MACID2_V1_8812F(x) | BIT_MACID2_V1_8812F(v))

/* 2 REG_MACID2_H_8812F (MAC ID2 REGISTER) */

#define BIT_SHIFT_MACID2_H_V1_8812F 0
#define BIT_MASK_MACID2_H_V1_8812F 0xffff
#define BIT_MACID2_H_V1_8812F(x)                                               \
	(((x) & BIT_MASK_MACID2_H_V1_8812F) << BIT_SHIFT_MACID2_H_V1_8812F)
#define BITS_MACID2_H_V1_8812F                                                 \
	(BIT_MASK_MACID2_H_V1_8812F << BIT_SHIFT_MACID2_H_V1_8812F)
#define BIT_CLEAR_MACID2_H_V1_8812F(x) ((x) & (~BITS_MACID2_H_V1_8812F))
#define BIT_GET_MACID2_H_V1_8812F(x)                                           \
	(((x) >> BIT_SHIFT_MACID2_H_V1_8812F) & BIT_MASK_MACID2_H_V1_8812F)
#define BIT_SET_MACID2_H_V1_8812F(x, v)                                        \
	(BIT_CLEAR_MACID2_H_V1_8812F(x) | BIT_MACID2_H_V1_8812F(v))

/* 2 REG_BSSID2_8812F (BSSID2 REGISTER) */

#define BIT_SHIFT_BSSID2_V1_8812F 0
#define BIT_MASK_BSSID2_V1_8812F 0xffffffffL
#define BIT_BSSID2_V1_8812F(x)                                                 \
	(((x) & BIT_MASK_BSSID2_V1_8812F) << BIT_SHIFT_BSSID2_V1_8812F)
#define BITS_BSSID2_V1_8812F                                                   \
	(BIT_MASK_BSSID2_V1_8812F << BIT_SHIFT_BSSID2_V1_8812F)
#define BIT_CLEAR_BSSID2_V1_8812F(x) ((x) & (~BITS_BSSID2_V1_8812F))
#define BIT_GET_BSSID2_V1_8812F(x)                                             \
	(((x) >> BIT_SHIFT_BSSID2_V1_8812F) & BIT_MASK_BSSID2_V1_8812F)
#define BIT_SET_BSSID2_V1_8812F(x, v)                                          \
	(BIT_CLEAR_BSSID2_V1_8812F(x) | BIT_BSSID2_V1_8812F(v))

/* 2 REG_BSSID2_H_8812F (BSSID2 REGISTER) */

#define BIT_SHIFT_BSSID2_H_V1_8812F 0
#define BIT_MASK_BSSID2_H_V1_8812F 0xffff
#define BIT_BSSID2_H_V1_8812F(x)                                               \
	(((x) & BIT_MASK_BSSID2_H_V1_8812F) << BIT_SHIFT_BSSID2_H_V1_8812F)
#define BITS_BSSID2_H_V1_8812F                                                 \
	(BIT_MASK_BSSID2_H_V1_8812F << BIT_SHIFT_BSSID2_H_V1_8812F)
#define BIT_CLEAR_BSSID2_H_V1_8812F(x) ((x) & (~BITS_BSSID2_H_V1_8812F))
#define BIT_GET_BSSID2_H_V1_8812F(x)                                           \
	(((x) >> BIT_SHIFT_BSSID2_H_V1_8812F) & BIT_MASK_BSSID2_H_V1_8812F)
#define BIT_SET_BSSID2_H_V1_8812F(x, v)                                        \
	(BIT_CLEAR_BSSID2_H_V1_8812F(x) | BIT_BSSID2_H_V1_8812F(v))

/* 2 REG_MACID3_8812F (MAC ID3 REGISTER) */

#define BIT_SHIFT_MACID3_V1_8812F 0
#define BIT_MASK_MACID3_V1_8812F 0xffffffffL
#define BIT_MACID3_V1_8812F(x)                                                 \
	(((x) & BIT_MASK_MACID3_V1_8812F) << BIT_SHIFT_MACID3_V1_8812F)
#define BITS_MACID3_V1_8812F                                                   \
	(BIT_MASK_MACID3_V1_8812F << BIT_SHIFT_MACID3_V1_8812F)
#define BIT_CLEAR_MACID3_V1_8812F(x) ((x) & (~BITS_MACID3_V1_8812F))
#define BIT_GET_MACID3_V1_8812F(x)                                             \
	(((x) >> BIT_SHIFT_MACID3_V1_8812F) & BIT_MASK_MACID3_V1_8812F)
#define BIT_SET_MACID3_V1_8812F(x, v)                                          \
	(BIT_CLEAR_MACID3_V1_8812F(x) | BIT_MACID3_V1_8812F(v))

/* 2 REG_MACID3_H_8812F (MAC ID3 REGISTER) */

#define BIT_SHIFT_MACID3_H_V1_8812F 0
#define BIT_MASK_MACID3_H_V1_8812F 0xffff
#define BIT_MACID3_H_V1_8812F(x)                                               \
	(((x) & BIT_MASK_MACID3_H_V1_8812F) << BIT_SHIFT_MACID3_H_V1_8812F)
#define BITS_MACID3_H_V1_8812F                                                 \
	(BIT_MASK_MACID3_H_V1_8812F << BIT_SHIFT_MACID3_H_V1_8812F)
#define BIT_CLEAR_MACID3_H_V1_8812F(x) ((x) & (~BITS_MACID3_H_V1_8812F))
#define BIT_GET_MACID3_H_V1_8812F(x)                                           \
	(((x) >> BIT_SHIFT_MACID3_H_V1_8812F) & BIT_MASK_MACID3_H_V1_8812F)
#define BIT_SET_MACID3_H_V1_8812F(x, v)                                        \
	(BIT_CLEAR_MACID3_H_V1_8812F(x) | BIT_MACID3_H_V1_8812F(v))

/* 2 REG_BSSID3_8812F (BSSID3 REGISTER) */

#define BIT_SHIFT_BSSID3_V1_8812F 0
#define BIT_MASK_BSSID3_V1_8812F 0xffffffffL
#define BIT_BSSID3_V1_8812F(x)                                                 \
	(((x) & BIT_MASK_BSSID3_V1_8812F) << BIT_SHIFT_BSSID3_V1_8812F)
#define BITS_BSSID3_V1_8812F                                                   \
	(BIT_MASK_BSSID3_V1_8812F << BIT_SHIFT_BSSID3_V1_8812F)
#define BIT_CLEAR_BSSID3_V1_8812F(x) ((x) & (~BITS_BSSID3_V1_8812F))
#define BIT_GET_BSSID3_V1_8812F(x)                                             \
	(((x) >> BIT_SHIFT_BSSID3_V1_8812F) & BIT_MASK_BSSID3_V1_8812F)
#define BIT_SET_BSSID3_V1_8812F(x, v)                                          \
	(BIT_CLEAR_BSSID3_V1_8812F(x) | BIT_BSSID3_V1_8812F(v))

/* 2 REG_BSSID3_H_8812F (BSSID3 REGISTER) */

#define BIT_SHIFT_BSSID3_H_V1_8812F 0
#define BIT_MASK_BSSID3_H_V1_8812F 0xffff
#define BIT_BSSID3_H_V1_8812F(x)                                               \
	(((x) & BIT_MASK_BSSID3_H_V1_8812F) << BIT_SHIFT_BSSID3_H_V1_8812F)
#define BITS_BSSID3_H_V1_8812F                                                 \
	(BIT_MASK_BSSID3_H_V1_8812F << BIT_SHIFT_BSSID3_H_V1_8812F)
#define BIT_CLEAR_BSSID3_H_V1_8812F(x) ((x) & (~BITS_BSSID3_H_V1_8812F))
#define BIT_GET_BSSID3_H_V1_8812F(x)                                           \
	(((x) >> BIT_SHIFT_BSSID3_H_V1_8812F) & BIT_MASK_BSSID3_H_V1_8812F)
#define BIT_SET_BSSID3_H_V1_8812F(x, v)                                        \
	(BIT_CLEAR_BSSID3_H_V1_8812F(x) | BIT_BSSID3_H_V1_8812F(v))

/* 2 REG_MACID4_8812F (MAC ID4 REGISTER) */

#define BIT_SHIFT_MACID4_V1_8812F 0
#define BIT_MASK_MACID4_V1_8812F 0xffffffffL
#define BIT_MACID4_V1_8812F(x)                                                 \
	(((x) & BIT_MASK_MACID4_V1_8812F) << BIT_SHIFT_MACID4_V1_8812F)
#define BITS_MACID4_V1_8812F                                                   \
	(BIT_MASK_MACID4_V1_8812F << BIT_SHIFT_MACID4_V1_8812F)
#define BIT_CLEAR_MACID4_V1_8812F(x) ((x) & (~BITS_MACID4_V1_8812F))
#define BIT_GET_MACID4_V1_8812F(x)                                             \
	(((x) >> BIT_SHIFT_MACID4_V1_8812F) & BIT_MASK_MACID4_V1_8812F)
#define BIT_SET_MACID4_V1_8812F(x, v)                                          \
	(BIT_CLEAR_MACID4_V1_8812F(x) | BIT_MACID4_V1_8812F(v))

/* 2 REG_MACID4_H_8812F (MAC ID4 REGISTER) */

#define BIT_SHIFT_MACID4_H_V1_8812F 0
#define BIT_MASK_MACID4_H_V1_8812F 0xffff
#define BIT_MACID4_H_V1_8812F(x)                                               \
	(((x) & BIT_MASK_MACID4_H_V1_8812F) << BIT_SHIFT_MACID4_H_V1_8812F)
#define BITS_MACID4_H_V1_8812F                                                 \
	(BIT_MASK_MACID4_H_V1_8812F << BIT_SHIFT_MACID4_H_V1_8812F)
#define BIT_CLEAR_MACID4_H_V1_8812F(x) ((x) & (~BITS_MACID4_H_V1_8812F))
#define BIT_GET_MACID4_H_V1_8812F(x)                                           \
	(((x) >> BIT_SHIFT_MACID4_H_V1_8812F) & BIT_MASK_MACID4_H_V1_8812F)
#define BIT_SET_MACID4_H_V1_8812F(x, v)                                        \
	(BIT_CLEAR_MACID4_H_V1_8812F(x) | BIT_MACID4_H_V1_8812F(v))

/* 2 REG_BSSID4_8812F (BSSID4 REGISTER) */

#define BIT_SHIFT_BSSID4_V1_8812F 0
#define BIT_MASK_BSSID4_V1_8812F 0xffffffffL
#define BIT_BSSID4_V1_8812F(x)                                                 \
	(((x) & BIT_MASK_BSSID4_V1_8812F) << BIT_SHIFT_BSSID4_V1_8812F)
#define BITS_BSSID4_V1_8812F                                                   \
	(BIT_MASK_BSSID4_V1_8812F << BIT_SHIFT_BSSID4_V1_8812F)
#define BIT_CLEAR_BSSID4_V1_8812F(x) ((x) & (~BITS_BSSID4_V1_8812F))
#define BIT_GET_BSSID4_V1_8812F(x)                                             \
	(((x) >> BIT_SHIFT_BSSID4_V1_8812F) & BIT_MASK_BSSID4_V1_8812F)
#define BIT_SET_BSSID4_V1_8812F(x, v)                                          \
	(BIT_CLEAR_BSSID4_V1_8812F(x) | BIT_BSSID4_V1_8812F(v))

/* 2 REG_BSSID4_H_8812F (BSSID4 REGISTER) */

#define BIT_SHIFT_BSSID4_H_V1_8812F 0
#define BIT_MASK_BSSID4_H_V1_8812F 0xffff
#define BIT_BSSID4_H_V1_8812F(x)                                               \
	(((x) & BIT_MASK_BSSID4_H_V1_8812F) << BIT_SHIFT_BSSID4_H_V1_8812F)
#define BITS_BSSID4_H_V1_8812F                                                 \
	(BIT_MASK_BSSID4_H_V1_8812F << BIT_SHIFT_BSSID4_H_V1_8812F)
#define BIT_CLEAR_BSSID4_H_V1_8812F(x) ((x) & (~BITS_BSSID4_H_V1_8812F))
#define BIT_GET_BSSID4_H_V1_8812F(x)                                           \
	(((x) >> BIT_SHIFT_BSSID4_H_V1_8812F) & BIT_MASK_BSSID4_H_V1_8812F)
#define BIT_SET_BSSID4_H_V1_8812F(x, v)                                        \
	(BIT_CLEAR_BSSID4_H_V1_8812F(x) | BIT_BSSID4_H_V1_8812F(v))

/* 2 REG_NOA_REPORT_8812F */

/* 2 REG_NOA_REPORT_1_8812F */

/* 2 REG_NOA_REPORT_2_8812F */

/* 2 REG_NOA_REPORT_3_8812F */

/* 2 REG_PWRBIT_SETTING_8812F */
#define BIT_CLI3_WMAC_TCRPWRMGT_HWCTL_EN_8812F BIT(15)
#define BIT_CLI3_WMAC_TCRPWRMGT_HWDATA_EN_8812F BIT(14)
#define BIT_CLI3_WMAC_TCRPWRMGT_HWACT_EN_8812F BIT(13)
#define BIT_CLI3_PWR_ST_V1_8812F BIT(12)
#define BIT_CLI2_WMAC_TCRPWRMGT_HWCTL_EN_8812F BIT(11)
#define BIT_CLI2_WMAC_TCRPWRMGT_HWDATA_EN_8812F BIT(10)
#define BIT_CLI2_WMAC_TCRPWRMGT_HWACT_EN_8812F BIT(9)
#define BIT_CLI2_PWR_ST_V1_8812F BIT(8)
#define BIT_CLI1_WMAC_TCRPWRMGT_HWCTL_EN_8812F BIT(7)
#define BIT_CLI1_WMAC_TCRPWRMGT_HWDATA_EN_8812F BIT(6)
#define BIT_CLI1_WMAC_TCRPWRMGT_HWACT_EN_8812F BIT(5)
#define BIT_CLI1_PWR_ST_V1_8812F BIT(4)
#define BIT_CLI0_WMAC_TCRPWRMGT_HWCTL_EN_8812F BIT(3)
#define BIT_CLI0_WMAC_TCRPWRMGT_HWDATA_EN_8812F BIT(2)
#define BIT_CLI0_WMAC_TCRPWRMGT_HWACT_EN_8812F BIT(1)
#define BIT_CLI0_PWR_ST_V1_8812F BIT(0)

/* 2 REG_GENERAL_OPTION_8812F */
#define BIT_WMAC_EXT_DBG_SEL_V1_8812F BIT(6)
#define BIT_WMAC_FIX_FIRST_MPDU_WITH_PHYSTS_8812F BIT(5)
#define BIT_RX_DMA_BYPASS_CHECK_DATABYPASS_CHECK_DATA_8812F BIT(4)
#define BIT_RX_DMA_BYPASS_CHECK_MGTBIT_RX_DMA_BYPASS_CHECK_MGT_8812F BIT(3)
#define BIT_TXSERV_FIELD_SEL_8812F BIT(2)
#define BIT_RXVHT_LEN_SEL_8812F BIT(1)
#define BIT_RXMIC_PROTECT_EN_8812F BIT(0)

/* 2 REG_RXAI_CTRL_8812F */
#define BIT_RXAI_INFO_RST_8812F BIT(7)
#define BIT_RXAI_PRTCT_REL_8812F BIT(6)
#define BIT_RXAI_PRTCT_VIO_8812F BIT(5)
#define BIT_RXAI_PRTCT_SEL_8812F BIT(2)
#define BIT_RXAI_AGG_CHKEN_8812F BIT(1)
#define BIT_RXAI_ADDR_CHKEN_8812F BIT(0)

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_CSI_RRSR_8812F */
#define BIT_CSI_LDPC_EN_8812F BIT(29)
#define BIT_CSI_STBC_EN_8812F BIT(28)

#define BIT_SHIFT_CSI_RRSC_BITMAP_8812F 4
#define BIT_MASK_CSI_RRSC_BITMAP_8812F 0xffffff
#define BIT_CSI_RRSC_BITMAP_8812F(x)                                           \
	(((x) & BIT_MASK_CSI_RRSC_BITMAP_8812F)                                \
	 << BIT_SHIFT_CSI_RRSC_BITMAP_8812F)
#define BITS_CSI_RRSC_BITMAP_8812F                                             \
	(BIT_MASK_CSI_RRSC_BITMAP_8812F << BIT_SHIFT_CSI_RRSC_BITMAP_8812F)
#define BIT_CLEAR_CSI_RRSC_BITMAP_8812F(x) ((x) & (~BITS_CSI_RRSC_BITMAP_8812F))
#define BIT_GET_CSI_RRSC_BITMAP_8812F(x)                                       \
	(((x) >> BIT_SHIFT_CSI_RRSC_BITMAP_8812F) &                            \
	 BIT_MASK_CSI_RRSC_BITMAP_8812F)
#define BIT_SET_CSI_RRSC_BITMAP_8812F(x, v)                                    \
	(BIT_CLEAR_CSI_RRSC_BITMAP_8812F(x) | BIT_CSI_RRSC_BITMAP_8812F(v))

#define BIT_SHIFT_OFDM_LEN_TH_8812F 0
#define BIT_MASK_OFDM_LEN_TH_8812F 0xf
#define BIT_OFDM_LEN_TH_8812F(x)                                               \
	(((x) & BIT_MASK_OFDM_LEN_TH_8812F) << BIT_SHIFT_OFDM_LEN_TH_8812F)
#define BITS_OFDM_LEN_TH_8812F                                                 \
	(BIT_MASK_OFDM_LEN_TH_8812F << BIT_SHIFT_OFDM_LEN_TH_8812F)
#define BIT_CLEAR_OFDM_LEN_TH_8812F(x) ((x) & (~BITS_OFDM_LEN_TH_8812F))
#define BIT_GET_OFDM_LEN_TH_8812F(x)                                           \
	(((x) >> BIT_SHIFT_OFDM_LEN_TH_8812F) & BIT_MASK_OFDM_LEN_TH_8812F)
#define BIT_SET_OFDM_LEN_TH_8812F(x, v)                                        \
	(BIT_CLEAR_OFDM_LEN_TH_8812F(x) | BIT_OFDM_LEN_TH_8812F(v))

/* 2 REG_MU_BF_OPTION_8812F */
#define BIT_WMAC_RESP_NONSTA1_DIS_8812F BIT(7)
#define BIT_WMAC_TXMU_ACKPOLICY_EN_8812F BIT(6)

#define BIT_SHIFT_WMAC_TXMU_ACKPOLICY_8812F 4
#define BIT_MASK_WMAC_TXMU_ACKPOLICY_8812F 0x3
#define BIT_WMAC_TXMU_ACKPOLICY_8812F(x)                                       \
	(((x) & BIT_MASK_WMAC_TXMU_ACKPOLICY_8812F)                            \
	 << BIT_SHIFT_WMAC_TXMU_ACKPOLICY_8812F)
#define BITS_WMAC_TXMU_ACKPOLICY_8812F                                         \
	(BIT_MASK_WMAC_TXMU_ACKPOLICY_8812F                                    \
	 << BIT_SHIFT_WMAC_TXMU_ACKPOLICY_8812F)
#define BIT_CLEAR_WMAC_TXMU_ACKPOLICY_8812F(x)                                 \
	((x) & (~BITS_WMAC_TXMU_ACKPOLICY_8812F))
#define BIT_GET_WMAC_TXMU_ACKPOLICY_8812F(x)                                   \
	(((x) >> BIT_SHIFT_WMAC_TXMU_ACKPOLICY_8812F) &                        \
	 BIT_MASK_WMAC_TXMU_ACKPOLICY_8812F)
#define BIT_SET_WMAC_TXMU_ACKPOLICY_8812F(x, v)                                \
	(BIT_CLEAR_WMAC_TXMU_ACKPOLICY_8812F(x) |                              \
	 BIT_WMAC_TXMU_ACKPOLICY_8812F(v))

#define BIT_SHIFT_WMAC_MU_BFEE_PORT_SEL_8812F 1
#define BIT_MASK_WMAC_MU_BFEE_PORT_SEL_8812F 0x7
#define BIT_WMAC_MU_BFEE_PORT_SEL_8812F(x)                                     \
	(((x) & BIT_MASK_WMAC_MU_BFEE_PORT_SEL_8812F)                          \
	 << BIT_SHIFT_WMAC_MU_BFEE_PORT_SEL_8812F)
#define BITS_WMAC_MU_BFEE_PORT_SEL_8812F                                       \
	(BIT_MASK_WMAC_MU_BFEE_PORT_SEL_8812F                                  \
	 << BIT_SHIFT_WMAC_MU_BFEE_PORT_SEL_8812F)
#define BIT_CLEAR_WMAC_MU_BFEE_PORT_SEL_8812F(x)                               \
	((x) & (~BITS_WMAC_MU_BFEE_PORT_SEL_8812F))
#define BIT_GET_WMAC_MU_BFEE_PORT_SEL_8812F(x)                                 \
	(((x) >> BIT_SHIFT_WMAC_MU_BFEE_PORT_SEL_8812F) &                      \
	 BIT_MASK_WMAC_MU_BFEE_PORT_SEL_8812F)
#define BIT_SET_WMAC_MU_BFEE_PORT_SEL_8812F(x, v)                              \
	(BIT_CLEAR_WMAC_MU_BFEE_PORT_SEL_8812F(x) |                            \
	 BIT_WMAC_MU_BFEE_PORT_SEL_8812F(v))

#define BIT_WMAC_MU_BFEE_DIS_8812F BIT(0)

/* 2 REG_WMAC_PAUSE_BB_CLR_TH_8812F */

#define BIT_SHIFT_WMAC_PAUSE_BB_CLR_TH_8812F 0
#define BIT_MASK_WMAC_PAUSE_BB_CLR_TH_8812F 0xff
#define BIT_WMAC_PAUSE_BB_CLR_TH_8812F(x)                                      \
	(((x) & BIT_MASK_WMAC_PAUSE_BB_CLR_TH_8812F)                           \
	 << BIT_SHIFT_WMAC_PAUSE_BB_CLR_TH_8812F)
#define BITS_WMAC_PAUSE_BB_CLR_TH_8812F                                        \
	(BIT_MASK_WMAC_PAUSE_BB_CLR_TH_8812F                                   \
	 << BIT_SHIFT_WMAC_PAUSE_BB_CLR_TH_8812F)
#define BIT_CLEAR_WMAC_PAUSE_BB_CLR_TH_8812F(x)                                \
	((x) & (~BITS_WMAC_PAUSE_BB_CLR_TH_8812F))
#define BIT_GET_WMAC_PAUSE_BB_CLR_TH_8812F(x)                                  \
	(((x) >> BIT_SHIFT_WMAC_PAUSE_BB_CLR_TH_8812F) &                       \
	 BIT_MASK_WMAC_PAUSE_BB_CLR_TH_8812F)
#define BIT_SET_WMAC_PAUSE_BB_CLR_TH_8812F(x, v)                               \
	(BIT_CLEAR_WMAC_PAUSE_BB_CLR_TH_8812F(x) |                             \
	 BIT_WMAC_PAUSE_BB_CLR_TH_8812F(v))

/* 2 REG__WMAC_MULBK_BUF_8812F */

#define BIT_SHIFT_WMAC_MULBK_PAGE_SIZE_8812F 0
#define BIT_MASK_WMAC_MULBK_PAGE_SIZE_8812F 0xff
#define BIT_WMAC_MULBK_PAGE_SIZE_8812F(x)                                      \
	(((x) & BIT_MASK_WMAC_MULBK_PAGE_SIZE_8812F)                           \
	 << BIT_SHIFT_WMAC_MULBK_PAGE_SIZE_8812F)
#define BITS_WMAC_MULBK_PAGE_SIZE_8812F                                        \
	(BIT_MASK_WMAC_MULBK_PAGE_SIZE_8812F                                   \
	 << BIT_SHIFT_WMAC_MULBK_PAGE_SIZE_8812F)
#define BIT_CLEAR_WMAC_MULBK_PAGE_SIZE_8812F(x)                                \
	((x) & (~BITS_WMAC_MULBK_PAGE_SIZE_8812F))
#define BIT_GET_WMAC_MULBK_PAGE_SIZE_8812F(x)                                  \
	(((x) >> BIT_SHIFT_WMAC_MULBK_PAGE_SIZE_8812F) &                       \
	 BIT_MASK_WMAC_MULBK_PAGE_SIZE_8812F)
#define BIT_SET_WMAC_MULBK_PAGE_SIZE_8812F(x, v)                               \
	(BIT_CLEAR_WMAC_MULBK_PAGE_SIZE_8812F(x) |                             \
	 BIT_WMAC_MULBK_PAGE_SIZE_8812F(v))

/* 2 REG_WMAC_MU_OPTION_8812F */

/* 2 REG_WMAC_MU_BF_CTL_8812F */
#define BIT_WMAC_INVLD_BFPRT_CHK_8812F BIT(15)
#define BIT_WMAC_RETXBFRPTSEQ_UPD_8812F BIT(14)

#define BIT_SHIFT_WMAC_MU_BFRPTSEG_SEL_8812F 12
#define BIT_MASK_WMAC_MU_BFRPTSEG_SEL_8812F 0x3
#define BIT_WMAC_MU_BFRPTSEG_SEL_8812F(x)                                      \
	(((x) & BIT_MASK_WMAC_MU_BFRPTSEG_SEL_8812F)                           \
	 << BIT_SHIFT_WMAC_MU_BFRPTSEG_SEL_8812F)
#define BITS_WMAC_MU_BFRPTSEG_SEL_8812F                                        \
	(BIT_MASK_WMAC_MU_BFRPTSEG_SEL_8812F                                   \
	 << BIT_SHIFT_WMAC_MU_BFRPTSEG_SEL_8812F)
#define BIT_CLEAR_WMAC_MU_BFRPTSEG_SEL_8812F(x)                                \
	((x) & (~BITS_WMAC_MU_BFRPTSEG_SEL_8812F))
#define BIT_GET_WMAC_MU_BFRPTSEG_SEL_8812F(x)                                  \
	(((x) >> BIT_SHIFT_WMAC_MU_BFRPTSEG_SEL_8812F) &                       \
	 BIT_MASK_WMAC_MU_BFRPTSEG_SEL_8812F)
#define BIT_SET_WMAC_MU_BFRPTSEG_SEL_8812F(x, v)                               \
	(BIT_CLEAR_WMAC_MU_BFRPTSEG_SEL_8812F(x) |                             \
	 BIT_WMAC_MU_BFRPTSEG_SEL_8812F(v))

#define BIT_SHIFT_WMAC_MU_BF_MYAID_8812F 0
#define BIT_MASK_WMAC_MU_BF_MYAID_8812F 0xfff
#define BIT_WMAC_MU_BF_MYAID_8812F(x)                                          \
	(((x) & BIT_MASK_WMAC_MU_BF_MYAID_8812F)                               \
	 << BIT_SHIFT_WMAC_MU_BF_MYAID_8812F)
#define BITS_WMAC_MU_BF_MYAID_8812F                                            \
	(BIT_MASK_WMAC_MU_BF_MYAID_8812F << BIT_SHIFT_WMAC_MU_BF_MYAID_8812F)
#define BIT_CLEAR_WMAC_MU_BF_MYAID_8812F(x)                                    \
	((x) & (~BITS_WMAC_MU_BF_MYAID_8812F))
#define BIT_GET_WMAC_MU_BF_MYAID_8812F(x)                                      \
	(((x) >> BIT_SHIFT_WMAC_MU_BF_MYAID_8812F) &                           \
	 BIT_MASK_WMAC_MU_BF_MYAID_8812F)
#define BIT_SET_WMAC_MU_BF_MYAID_8812F(x, v)                                   \
	(BIT_CLEAR_WMAC_MU_BF_MYAID_8812F(x) | BIT_WMAC_MU_BF_MYAID_8812F(v))

/* 2 REG_WMAC_MU_BFRPT_PARA_8812F */

#define BIT_SHIFT_BFRPT_PARA_USERID_SEL_V1_8812F 13
#define BIT_MASK_BFRPT_PARA_USERID_SEL_V1_8812F 0x7
#define BIT_BFRPT_PARA_USERID_SEL_V1_8812F(x)                                  \
	(((x) & BIT_MASK_BFRPT_PARA_USERID_SEL_V1_8812F)                       \
	 << BIT_SHIFT_BFRPT_PARA_USERID_SEL_V1_8812F)
#define BITS_BFRPT_PARA_USERID_SEL_V1_8812F                                    \
	(BIT_MASK_BFRPT_PARA_USERID_SEL_V1_8812F                               \
	 << BIT_SHIFT_BFRPT_PARA_USERID_SEL_V1_8812F)
#define BIT_CLEAR_BFRPT_PARA_USERID_SEL_V1_8812F(x)                            \
	((x) & (~BITS_BFRPT_PARA_USERID_SEL_V1_8812F))
#define BIT_GET_BFRPT_PARA_USERID_SEL_V1_8812F(x)                              \
	(((x) >> BIT_SHIFT_BFRPT_PARA_USERID_SEL_V1_8812F) &                   \
	 BIT_MASK_BFRPT_PARA_USERID_SEL_V1_8812F)
#define BIT_SET_BFRPT_PARA_USERID_SEL_V1_8812F(x, v)                           \
	(BIT_CLEAR_BFRPT_PARA_USERID_SEL_V1_8812F(x) |                         \
	 BIT_BFRPT_PARA_USERID_SEL_V1_8812F(v))

#define BIT_SHIFT_BFRPT_PARA_V1_8812F 0
#define BIT_MASK_BFRPT_PARA_V1_8812F 0x1fff
#define BIT_BFRPT_PARA_V1_8812F(x)                                             \
	(((x) & BIT_MASK_BFRPT_PARA_V1_8812F) << BIT_SHIFT_BFRPT_PARA_V1_8812F)
#define BITS_BFRPT_PARA_V1_8812F                                               \
	(BIT_MASK_BFRPT_PARA_V1_8812F << BIT_SHIFT_BFRPT_PARA_V1_8812F)
#define BIT_CLEAR_BFRPT_PARA_V1_8812F(x) ((x) & (~BITS_BFRPT_PARA_V1_8812F))
#define BIT_GET_BFRPT_PARA_V1_8812F(x)                                         \
	(((x) >> BIT_SHIFT_BFRPT_PARA_V1_8812F) & BIT_MASK_BFRPT_PARA_V1_8812F)
#define BIT_SET_BFRPT_PARA_V1_8812F(x, v)                                      \
	(BIT_CLEAR_BFRPT_PARA_V1_8812F(x) | BIT_BFRPT_PARA_V1_8812F(v))

/* 2 REG_WMAC_ASSOCIATED_MU_BFMEE2_8812F */
#define BIT_STATUS_BFEE2_8812F BIT(10)
#define BIT_WMAC_MU_BFEE2_EN_8812F BIT(9)

#define BIT_SHIFT_WMAC_MU_BFEE2_AID_8812F 0
#define BIT_MASK_WMAC_MU_BFEE2_AID_8812F 0x1ff
#define BIT_WMAC_MU_BFEE2_AID_8812F(x)                                         \
	(((x) & BIT_MASK_WMAC_MU_BFEE2_AID_8812F)                              \
	 << BIT_SHIFT_WMAC_MU_BFEE2_AID_8812F)
#define BITS_WMAC_MU_BFEE2_AID_8812F                                           \
	(BIT_MASK_WMAC_MU_BFEE2_AID_8812F << BIT_SHIFT_WMAC_MU_BFEE2_AID_8812F)
#define BIT_CLEAR_WMAC_MU_BFEE2_AID_8812F(x)                                   \
	((x) & (~BITS_WMAC_MU_BFEE2_AID_8812F))
#define BIT_GET_WMAC_MU_BFEE2_AID_8812F(x)                                     \
	(((x) >> BIT_SHIFT_WMAC_MU_BFEE2_AID_8812F) &                          \
	 BIT_MASK_WMAC_MU_BFEE2_AID_8812F)
#define BIT_SET_WMAC_MU_BFEE2_AID_8812F(x, v)                                  \
	(BIT_CLEAR_WMAC_MU_BFEE2_AID_8812F(x) | BIT_WMAC_MU_BFEE2_AID_8812F(v))

/* 2 REG_WMAC_ASSOCIATED_MU_BFMEE3_8812F */
#define BIT_STATUS_BFEE3_8812F BIT(10)
#define BIT_WMAC_MU_BFEE3_EN_8812F BIT(9)

#define BIT_SHIFT_WMAC_MU_BFEE3_AID_8812F 0
#define BIT_MASK_WMAC_MU_BFEE3_AID_8812F 0x1ff
#define BIT_WMAC_MU_BFEE3_AID_8812F(x)                                         \
	(((x) & BIT_MASK_WMAC_MU_BFEE3_AID_8812F)                              \
	 << BIT_SHIFT_WMAC_MU_BFEE3_AID_8812F)
#define BITS_WMAC_MU_BFEE3_AID_8812F                                           \
	(BIT_MASK_WMAC_MU_BFEE3_AID_8812F << BIT_SHIFT_WMAC_MU_BFEE3_AID_8812F)
#define BIT_CLEAR_WMAC_MU_BFEE3_AID_8812F(x)                                   \
	((x) & (~BITS_WMAC_MU_BFEE3_AID_8812F))
#define BIT_GET_WMAC_MU_BFEE3_AID_8812F(x)                                     \
	(((x) >> BIT_SHIFT_WMAC_MU_BFEE3_AID_8812F) &                          \
	 BIT_MASK_WMAC_MU_BFEE3_AID_8812F)
#define BIT_SET_WMAC_MU_BFEE3_AID_8812F(x, v)                                  \
	(BIT_CLEAR_WMAC_MU_BFEE3_AID_8812F(x) | BIT_WMAC_MU_BFEE3_AID_8812F(v))

/* 2 REG_WMAC_ASSOCIATED_MU_BFMEE4_8812F */
#define BIT_STATUS_BFEE4_8812F BIT(10)
#define BIT_WMAC_MU_BFEE4_EN_8812F BIT(9)

#define BIT_SHIFT_WMAC_MU_BFEE4_AID_8812F 0
#define BIT_MASK_WMAC_MU_BFEE4_AID_8812F 0x1ff
#define BIT_WMAC_MU_BFEE4_AID_8812F(x)                                         \
	(((x) & BIT_MASK_WMAC_MU_BFEE4_AID_8812F)                              \
	 << BIT_SHIFT_WMAC_MU_BFEE4_AID_8812F)
#define BITS_WMAC_MU_BFEE4_AID_8812F                                           \
	(BIT_MASK_WMAC_MU_BFEE4_AID_8812F << BIT_SHIFT_WMAC_MU_BFEE4_AID_8812F)
#define BIT_CLEAR_WMAC_MU_BFEE4_AID_8812F(x)                                   \
	((x) & (~BITS_WMAC_MU_BFEE4_AID_8812F))
#define BIT_GET_WMAC_MU_BFEE4_AID_8812F(x)                                     \
	(((x) >> BIT_SHIFT_WMAC_MU_BFEE4_AID_8812F) &                          \
	 BIT_MASK_WMAC_MU_BFEE4_AID_8812F)
#define BIT_SET_WMAC_MU_BFEE4_AID_8812F(x, v)                                  \
	(BIT_CLEAR_WMAC_MU_BFEE4_AID_8812F(x) | BIT_WMAC_MU_BFEE4_AID_8812F(v))

/* 2 REG_WMAC_ASSOCIATED_MU_BFMEE5_8812F */
#define BIT_BIT_STATUS_BFEE5_8812F BIT(10)
#define BIT_WMAC_MU_BFEE5_EN_8812F BIT(9)

#define BIT_SHIFT_WMAC_MU_BFEE5_AID_8812F 0
#define BIT_MASK_WMAC_MU_BFEE5_AID_8812F 0x1ff
#define BIT_WMAC_MU_BFEE5_AID_8812F(x)                                         \
	(((x) & BIT_MASK_WMAC_MU_BFEE5_AID_8812F)                              \
	 << BIT_SHIFT_WMAC_MU_BFEE5_AID_8812F)
#define BITS_WMAC_MU_BFEE5_AID_8812F                                           \
	(BIT_MASK_WMAC_MU_BFEE5_AID_8812F << BIT_SHIFT_WMAC_MU_BFEE5_AID_8812F)
#define BIT_CLEAR_WMAC_MU_BFEE5_AID_8812F(x)                                   \
	((x) & (~BITS_WMAC_MU_BFEE5_AID_8812F))
#define BIT_GET_WMAC_MU_BFEE5_AID_8812F(x)                                     \
	(((x) >> BIT_SHIFT_WMAC_MU_BFEE5_AID_8812F) &                          \
	 BIT_MASK_WMAC_MU_BFEE5_AID_8812F)
#define BIT_SET_WMAC_MU_BFEE5_AID_8812F(x, v)                                  \
	(BIT_CLEAR_WMAC_MU_BFEE5_AID_8812F(x) | BIT_WMAC_MU_BFEE5_AID_8812F(v))

/* 2 REG_WMAC_ASSOCIATED_MU_BFMEE6_8812F */
#define BIT_STATUS_BFEE6_8812F BIT(10)
#define BIT_WMAC_MU_BFEE6_EN_8812F BIT(9)

#define BIT_SHIFT_WMAC_MU_BFEE6_AID_8812F 0
#define BIT_MASK_WMAC_MU_BFEE6_AID_8812F 0x1ff
#define BIT_WMAC_MU_BFEE6_AID_8812F(x)                                         \
	(((x) & BIT_MASK_WMAC_MU_BFEE6_AID_8812F)                              \
	 << BIT_SHIFT_WMAC_MU_BFEE6_AID_8812F)
#define BITS_WMAC_MU_BFEE6_AID_8812F                                           \
	(BIT_MASK_WMAC_MU_BFEE6_AID_8812F << BIT_SHIFT_WMAC_MU_BFEE6_AID_8812F)
#define BIT_CLEAR_WMAC_MU_BFEE6_AID_8812F(x)                                   \
	((x) & (~BITS_WMAC_MU_BFEE6_AID_8812F))
#define BIT_GET_WMAC_MU_BFEE6_AID_8812F(x)                                     \
	(((x) >> BIT_SHIFT_WMAC_MU_BFEE6_AID_8812F) &                          \
	 BIT_MASK_WMAC_MU_BFEE6_AID_8812F)
#define BIT_SET_WMAC_MU_BFEE6_AID_8812F(x, v)                                  \
	(BIT_CLEAR_WMAC_MU_BFEE6_AID_8812F(x) | BIT_WMAC_MU_BFEE6_AID_8812F(v))

/* 2 REG_WMAC_ASSOCIATED_MU_BFMEE7_8812F */
#define BIT_STATUS_BFEE7_8812F BIT(10)
#define BIT_WMAC_MU_BFEE7_EN_8812F BIT(9)

#define BIT_SHIFT_WMAC_MU_BFEE7_AID_8812F 0
#define BIT_MASK_WMAC_MU_BFEE7_AID_8812F 0x1ff
#define BIT_WMAC_MU_BFEE7_AID_8812F(x)                                         \
	(((x) & BIT_MASK_WMAC_MU_BFEE7_AID_8812F)                              \
	 << BIT_SHIFT_WMAC_MU_BFEE7_AID_8812F)
#define BITS_WMAC_MU_BFEE7_AID_8812F                                           \
	(BIT_MASK_WMAC_MU_BFEE7_AID_8812F << BIT_SHIFT_WMAC_MU_BFEE7_AID_8812F)
#define BIT_CLEAR_WMAC_MU_BFEE7_AID_8812F(x)                                   \
	((x) & (~BITS_WMAC_MU_BFEE7_AID_8812F))
#define BIT_GET_WMAC_MU_BFEE7_AID_8812F(x)                                     \
	(((x) >> BIT_SHIFT_WMAC_MU_BFEE7_AID_8812F) &                          \
	 BIT_MASK_WMAC_MU_BFEE7_AID_8812F)
#define BIT_SET_WMAC_MU_BFEE7_AID_8812F(x, v)                                  \
	(BIT_CLEAR_WMAC_MU_BFEE7_AID_8812F(x) | BIT_WMAC_MU_BFEE7_AID_8812F(v))

/* 2 REG_WMAC_BB_STOP_RX_COUNTER_8812F */
#define BIT_RST_ALL_COUNTER_8812F BIT(31)

#define BIT_SHIFT_ABORT_RX_VBON_COUNTER_8812F 16
#define BIT_MASK_ABORT_RX_VBON_COUNTER_8812F 0xff
#define BIT_ABORT_RX_VBON_COUNTER_8812F(x)                                     \
	(((x) & BIT_MASK_ABORT_RX_VBON_COUNTER_8812F)                          \
	 << BIT_SHIFT_ABORT_RX_VBON_COUNTER_8812F)
#define BITS_ABORT_RX_VBON_COUNTER_8812F                                       \
	(BIT_MASK_ABORT_RX_VBON_COUNTER_8812F                                  \
	 << BIT_SHIFT_ABORT_RX_VBON_COUNTER_8812F)
#define BIT_CLEAR_ABORT_RX_VBON_COUNTER_8812F(x)                               \
	((x) & (~BITS_ABORT_RX_VBON_COUNTER_8812F))
#define BIT_GET_ABORT_RX_VBON_COUNTER_8812F(x)                                 \
	(((x) >> BIT_SHIFT_ABORT_RX_VBON_COUNTER_8812F) &                      \
	 BIT_MASK_ABORT_RX_VBON_COUNTER_8812F)
#define BIT_SET_ABORT_RX_VBON_COUNTER_8812F(x, v)                              \
	(BIT_CLEAR_ABORT_RX_VBON_COUNTER_8812F(x) |                            \
	 BIT_ABORT_RX_VBON_COUNTER_8812F(v))

#define BIT_SHIFT_ABORT_RX_RDRDY_COUNTER_8812F 8
#define BIT_MASK_ABORT_RX_RDRDY_COUNTER_8812F 0xff
#define BIT_ABORT_RX_RDRDY_COUNTER_8812F(x)                                    \
	(((x) & BIT_MASK_ABORT_RX_RDRDY_COUNTER_8812F)                         \
	 << BIT_SHIFT_ABORT_RX_RDRDY_COUNTER_8812F)
#define BITS_ABORT_RX_RDRDY_COUNTER_8812F                                      \
	(BIT_MASK_ABORT_RX_RDRDY_COUNTER_8812F                                 \
	 << BIT_SHIFT_ABORT_RX_RDRDY_COUNTER_8812F)
#define BIT_CLEAR_ABORT_RX_RDRDY_COUNTER_8812F(x)                              \
	((x) & (~BITS_ABORT_RX_RDRDY_COUNTER_8812F))
#define BIT_GET_ABORT_RX_RDRDY_COUNTER_8812F(x)                                \
	(((x) >> BIT_SHIFT_ABORT_RX_RDRDY_COUNTER_8812F) &                     \
	 BIT_MASK_ABORT_RX_RDRDY_COUNTER_8812F)
#define BIT_SET_ABORT_RX_RDRDY_COUNTER_8812F(x, v)                             \
	(BIT_CLEAR_ABORT_RX_RDRDY_COUNTER_8812F(x) |                           \
	 BIT_ABORT_RX_RDRDY_COUNTER_8812F(v))

#define BIT_SHIFT_VBON_EARLY_FALLING_COUNTER_8812F 0
#define BIT_MASK_VBON_EARLY_FALLING_COUNTER_8812F 0xff
#define BIT_VBON_EARLY_FALLING_COUNTER_8812F(x)                                \
	(((x) & BIT_MASK_VBON_EARLY_FALLING_COUNTER_8812F)                     \
	 << BIT_SHIFT_VBON_EARLY_FALLING_COUNTER_8812F)
#define BITS_VBON_EARLY_FALLING_COUNTER_8812F                                  \
	(BIT_MASK_VBON_EARLY_FALLING_COUNTER_8812F                             \
	 << BIT_SHIFT_VBON_EARLY_FALLING_COUNTER_8812F)
#define BIT_CLEAR_VBON_EARLY_FALLING_COUNTER_8812F(x)                          \
	((x) & (~BITS_VBON_EARLY_FALLING_COUNTER_8812F))
#define BIT_GET_VBON_EARLY_FALLING_COUNTER_8812F(x)                            \
	(((x) >> BIT_SHIFT_VBON_EARLY_FALLING_COUNTER_8812F) &                 \
	 BIT_MASK_VBON_EARLY_FALLING_COUNTER_8812F)
#define BIT_SET_VBON_EARLY_FALLING_COUNTER_8812F(x, v)                         \
	(BIT_CLEAR_VBON_EARLY_FALLING_COUNTER_8812F(x) |                       \
	 BIT_VBON_EARLY_FALLING_COUNTER_8812F(v))

/* 2 REG_WMAC_PLCP_MONITOR_8812F */
#define BIT_WMAC_PLCP_TRX_SEL_8812F BIT(31)

#define BIT_SHIFT_WMAC_PLCP_RDSIG_SEL_8812F 28
#define BIT_MASK_WMAC_PLCP_RDSIG_SEL_8812F 0x7
#define BIT_WMAC_PLCP_RDSIG_SEL_8812F(x)                                       \
	(((x) & BIT_MASK_WMAC_PLCP_RDSIG_SEL_8812F)                            \
	 << BIT_SHIFT_WMAC_PLCP_RDSIG_SEL_8812F)
#define BITS_WMAC_PLCP_RDSIG_SEL_8812F                                         \
	(BIT_MASK_WMAC_PLCP_RDSIG_SEL_8812F                                    \
	 << BIT_SHIFT_WMAC_PLCP_RDSIG_SEL_8812F)
#define BIT_CLEAR_WMAC_PLCP_RDSIG_SEL_8812F(x)                                 \
	((x) & (~BITS_WMAC_PLCP_RDSIG_SEL_8812F))
#define BIT_GET_WMAC_PLCP_RDSIG_SEL_8812F(x)                                   \
	(((x) >> BIT_SHIFT_WMAC_PLCP_RDSIG_SEL_8812F) &                        \
	 BIT_MASK_WMAC_PLCP_RDSIG_SEL_8812F)
#define BIT_SET_WMAC_PLCP_RDSIG_SEL_8812F(x, v)                                \
	(BIT_CLEAR_WMAC_PLCP_RDSIG_SEL_8812F(x) |                              \
	 BIT_WMAC_PLCP_RDSIG_SEL_8812F(v))

#define BIT_SHIFT_WMAC_RATE_IDX_8812F 24
#define BIT_MASK_WMAC_RATE_IDX_8812F 0xf
#define BIT_WMAC_RATE_IDX_8812F(x)                                             \
	(((x) & BIT_MASK_WMAC_RATE_IDX_8812F) << BIT_SHIFT_WMAC_RATE_IDX_8812F)
#define BITS_WMAC_RATE_IDX_8812F                                               \
	(BIT_MASK_WMAC_RATE_IDX_8812F << BIT_SHIFT_WMAC_RATE_IDX_8812F)
#define BIT_CLEAR_WMAC_RATE_IDX_8812F(x) ((x) & (~BITS_WMAC_RATE_IDX_8812F))
#define BIT_GET_WMAC_RATE_IDX_8812F(x)                                         \
	(((x) >> BIT_SHIFT_WMAC_RATE_IDX_8812F) & BIT_MASK_WMAC_RATE_IDX_8812F)
#define BIT_SET_WMAC_RATE_IDX_8812F(x, v)                                      \
	(BIT_CLEAR_WMAC_RATE_IDX_8812F(x) | BIT_WMAC_RATE_IDX_8812F(v))

#define BIT_SHIFT_WMAC_PLCP_RDSIG_8812F 0
#define BIT_MASK_WMAC_PLCP_RDSIG_8812F 0xffffff
#define BIT_WMAC_PLCP_RDSIG_8812F(x)                                           \
	(((x) & BIT_MASK_WMAC_PLCP_RDSIG_8812F)                                \
	 << BIT_SHIFT_WMAC_PLCP_RDSIG_8812F)
#define BITS_WMAC_PLCP_RDSIG_8812F                                             \
	(BIT_MASK_WMAC_PLCP_RDSIG_8812F << BIT_SHIFT_WMAC_PLCP_RDSIG_8812F)
#define BIT_CLEAR_WMAC_PLCP_RDSIG_8812F(x) ((x) & (~BITS_WMAC_PLCP_RDSIG_8812F))
#define BIT_GET_WMAC_PLCP_RDSIG_8812F(x)                                       \
	(((x) >> BIT_SHIFT_WMAC_PLCP_RDSIG_8812F) &                            \
	 BIT_MASK_WMAC_PLCP_RDSIG_8812F)
#define BIT_SET_WMAC_PLCP_RDSIG_8812F(x, v)                                    \
	(BIT_CLEAR_WMAC_PLCP_RDSIG_8812F(x) | BIT_WMAC_PLCP_RDSIG_8812F(v))

/* 2 REG_WMAC_PLCP_MONITOR_MUTX_8812F */
#define BIT_WMAC_MUTX_IDX_8812F BIT(24)

#define BIT_SHIFT_WMAC_PLCP_RDSIG_8812F 0
#define BIT_MASK_WMAC_PLCP_RDSIG_8812F 0xffffff
#define BIT_WMAC_PLCP_RDSIG_8812F(x)                                           \
	(((x) & BIT_MASK_WMAC_PLCP_RDSIG_8812F)                                \
	 << BIT_SHIFT_WMAC_PLCP_RDSIG_8812F)
#define BITS_WMAC_PLCP_RDSIG_8812F                                             \
	(BIT_MASK_WMAC_PLCP_RDSIG_8812F << BIT_SHIFT_WMAC_PLCP_RDSIG_8812F)
#define BIT_CLEAR_WMAC_PLCP_RDSIG_8812F(x) ((x) & (~BITS_WMAC_PLCP_RDSIG_8812F))
#define BIT_GET_WMAC_PLCP_RDSIG_8812F(x)                                       \
	(((x) >> BIT_SHIFT_WMAC_PLCP_RDSIG_8812F) &                            \
	 BIT_MASK_WMAC_PLCP_RDSIG_8812F)
#define BIT_SET_WMAC_PLCP_RDSIG_8812F(x, v)                                    \
	(BIT_CLEAR_WMAC_PLCP_RDSIG_8812F(x) | BIT_WMAC_PLCP_RDSIG_8812F(v))

/* 2 REG_WMAC_CSIDMA_CFG_8812F */

#define BIT_SHIFT_CSI_SEG_SIZE_8812F 16
#define BIT_MASK_CSI_SEG_SIZE_8812F 0xfff
#define BIT_CSI_SEG_SIZE_8812F(x)                                              \
	(((x) & BIT_MASK_CSI_SEG_SIZE_8812F) << BIT_SHIFT_CSI_SEG_SIZE_8812F)
#define BITS_CSI_SEG_SIZE_8812F                                                \
	(BIT_MASK_CSI_SEG_SIZE_8812F << BIT_SHIFT_CSI_SEG_SIZE_8812F)
#define BIT_CLEAR_CSI_SEG_SIZE_8812F(x) ((x) & (~BITS_CSI_SEG_SIZE_8812F))
#define BIT_GET_CSI_SEG_SIZE_8812F(x)                                          \
	(((x) >> BIT_SHIFT_CSI_SEG_SIZE_8812F) & BIT_MASK_CSI_SEG_SIZE_8812F)
#define BIT_SET_CSI_SEG_SIZE_8812F(x, v)                                       \
	(BIT_CLEAR_CSI_SEG_SIZE_8812F(x) | BIT_CSI_SEG_SIZE_8812F(v))

#define BIT_SHIFT_CSI_START_PAGE_8812F 0
#define BIT_MASK_CSI_START_PAGE_8812F 0xfff
#define BIT_CSI_START_PAGE_8812F(x)                                            \
	(((x) & BIT_MASK_CSI_START_PAGE_8812F)                                 \
	 << BIT_SHIFT_CSI_START_PAGE_8812F)
#define BITS_CSI_START_PAGE_8812F                                              \
	(BIT_MASK_CSI_START_PAGE_8812F << BIT_SHIFT_CSI_START_PAGE_8812F)
#define BIT_CLEAR_CSI_START_PAGE_8812F(x) ((x) & (~BITS_CSI_START_PAGE_8812F))
#define BIT_GET_CSI_START_PAGE_8812F(x)                                        \
	(((x) >> BIT_SHIFT_CSI_START_PAGE_8812F) &                             \
	 BIT_MASK_CSI_START_PAGE_8812F)
#define BIT_SET_CSI_START_PAGE_8812F(x, v)                                     \
	(BIT_CLEAR_CSI_START_PAGE_8812F(x) | BIT_CSI_START_PAGE_8812F(v))

/* 2 REG_TRANSMIT_ADDRSS_0_8812F (TA0 REGISTER) */

#define BIT_SHIFT_TA0_V1_8812F 0
#define BIT_MASK_TA0_V1_8812F 0xffffffffL
#define BIT_TA0_V1_8812F(x)                                                    \
	(((x) & BIT_MASK_TA0_V1_8812F) << BIT_SHIFT_TA0_V1_8812F)
#define BITS_TA0_V1_8812F (BIT_MASK_TA0_V1_8812F << BIT_SHIFT_TA0_V1_8812F)
#define BIT_CLEAR_TA0_V1_8812F(x) ((x) & (~BITS_TA0_V1_8812F))
#define BIT_GET_TA0_V1_8812F(x)                                                \
	(((x) >> BIT_SHIFT_TA0_V1_8812F) & BIT_MASK_TA0_V1_8812F)
#define BIT_SET_TA0_V1_8812F(x, v)                                             \
	(BIT_CLEAR_TA0_V1_8812F(x) | BIT_TA0_V1_8812F(v))

/* 2 REG_TRANSMIT_ADDRSS_0_H_8812F (TA0 REGISTER) */

#define BIT_SHIFT_TA0_H_V1_8812F 0
#define BIT_MASK_TA0_H_V1_8812F 0xffff
#define BIT_TA0_H_V1_8812F(x)                                                  \
	(((x) & BIT_MASK_TA0_H_V1_8812F) << BIT_SHIFT_TA0_H_V1_8812F)
#define BITS_TA0_H_V1_8812F                                                    \
	(BIT_MASK_TA0_H_V1_8812F << BIT_SHIFT_TA0_H_V1_8812F)
#define BIT_CLEAR_TA0_H_V1_8812F(x) ((x) & (~BITS_TA0_H_V1_8812F))
#define BIT_GET_TA0_H_V1_8812F(x)                                              \
	(((x) >> BIT_SHIFT_TA0_H_V1_8812F) & BIT_MASK_TA0_H_V1_8812F)
#define BIT_SET_TA0_H_V1_8812F(x, v)                                           \
	(BIT_CLEAR_TA0_H_V1_8812F(x) | BIT_TA0_H_V1_8812F(v))

/* 2 REG_TRANSMIT_ADDRSS_1_8812F (TA1 REGISTER) */

#define BIT_SHIFT_TA1_V1_8812F 0
#define BIT_MASK_TA1_V1_8812F 0xffffffffL
#define BIT_TA1_V1_8812F(x)                                                    \
	(((x) & BIT_MASK_TA1_V1_8812F) << BIT_SHIFT_TA1_V1_8812F)
#define BITS_TA1_V1_8812F (BIT_MASK_TA1_V1_8812F << BIT_SHIFT_TA1_V1_8812F)
#define BIT_CLEAR_TA1_V1_8812F(x) ((x) & (~BITS_TA1_V1_8812F))
#define BIT_GET_TA1_V1_8812F(x)                                                \
	(((x) >> BIT_SHIFT_TA1_V1_8812F) & BIT_MASK_TA1_V1_8812F)
#define BIT_SET_TA1_V1_8812F(x, v)                                             \
	(BIT_CLEAR_TA1_V1_8812F(x) | BIT_TA1_V1_8812F(v))

/* 2 REG_TRANSMIT_ADDRSS_1_H_8812F (TA1 REGISTER) */

#define BIT_SHIFT_TA1_H_V1_8812F 0
#define BIT_MASK_TA1_H_V1_8812F 0xffff
#define BIT_TA1_H_V1_8812F(x)                                                  \
	(((x) & BIT_MASK_TA1_H_V1_8812F) << BIT_SHIFT_TA1_H_V1_8812F)
#define BITS_TA1_H_V1_8812F                                                    \
	(BIT_MASK_TA1_H_V1_8812F << BIT_SHIFT_TA1_H_V1_8812F)
#define BIT_CLEAR_TA1_H_V1_8812F(x) ((x) & (~BITS_TA1_H_V1_8812F))
#define BIT_GET_TA1_H_V1_8812F(x)                                              \
	(((x) >> BIT_SHIFT_TA1_H_V1_8812F) & BIT_MASK_TA1_H_V1_8812F)
#define BIT_SET_TA1_H_V1_8812F(x, v)                                           \
	(BIT_CLEAR_TA1_H_V1_8812F(x) | BIT_TA1_H_V1_8812F(v))

/* 2 REG_TRANSMIT_ADDRSS_2_8812F (TA2 REGISTER) */

#define BIT_SHIFT_TA2_V1_8812F 0
#define BIT_MASK_TA2_V1_8812F 0xffffffffL
#define BIT_TA2_V1_8812F(x)                                                    \
	(((x) & BIT_MASK_TA2_V1_8812F) << BIT_SHIFT_TA2_V1_8812F)
#define BITS_TA2_V1_8812F (BIT_MASK_TA2_V1_8812F << BIT_SHIFT_TA2_V1_8812F)
#define BIT_CLEAR_TA2_V1_8812F(x) ((x) & (~BITS_TA2_V1_8812F))
#define BIT_GET_TA2_V1_8812F(x)                                                \
	(((x) >> BIT_SHIFT_TA2_V1_8812F) & BIT_MASK_TA2_V1_8812F)
#define BIT_SET_TA2_V1_8812F(x, v)                                             \
	(BIT_CLEAR_TA2_V1_8812F(x) | BIT_TA2_V1_8812F(v))

/* 2 REG_TRANSMIT_ADDRSS_2_H_8812F (TA2 REGISTER) */

#define BIT_SHIFT_TA2_H_V1_8812F 0
#define BIT_MASK_TA2_H_V1_8812F 0xffff
#define BIT_TA2_H_V1_8812F(x)                                                  \
	(((x) & BIT_MASK_TA2_H_V1_8812F) << BIT_SHIFT_TA2_H_V1_8812F)
#define BITS_TA2_H_V1_8812F                                                    \
	(BIT_MASK_TA2_H_V1_8812F << BIT_SHIFT_TA2_H_V1_8812F)
#define BIT_CLEAR_TA2_H_V1_8812F(x) ((x) & (~BITS_TA2_H_V1_8812F))
#define BIT_GET_TA2_H_V1_8812F(x)                                              \
	(((x) >> BIT_SHIFT_TA2_H_V1_8812F) & BIT_MASK_TA2_H_V1_8812F)
#define BIT_SET_TA2_H_V1_8812F(x, v)                                           \
	(BIT_CLEAR_TA2_H_V1_8812F(x) | BIT_TA2_H_V1_8812F(v))

/* 2 REG_TRANSMIT_ADDRSS_3_8812F (TA3 REGISTER) */

#define BIT_SHIFT_TA2_V1_8812F 0
#define BIT_MASK_TA2_V1_8812F 0xffffffffL
#define BIT_TA2_V1_8812F(x)                                                    \
	(((x) & BIT_MASK_TA2_V1_8812F) << BIT_SHIFT_TA2_V1_8812F)
#define BITS_TA2_V1_8812F (BIT_MASK_TA2_V1_8812F << BIT_SHIFT_TA2_V1_8812F)
#define BIT_CLEAR_TA2_V1_8812F(x) ((x) & (~BITS_TA2_V1_8812F))
#define BIT_GET_TA2_V1_8812F(x)                                                \
	(((x) >> BIT_SHIFT_TA2_V1_8812F) & BIT_MASK_TA2_V1_8812F)
#define BIT_SET_TA2_V1_8812F(x, v)                                             \
	(BIT_CLEAR_TA2_V1_8812F(x) | BIT_TA2_V1_8812F(v))

/* 2 REG_TRANSMIT_ADDRSS_3_H_8812F (TA3 REGISTER) */

#define BIT_SHIFT_TA3_H_V1_8812F 0
#define BIT_MASK_TA3_H_V1_8812F 0xffff
#define BIT_TA3_H_V1_8812F(x)                                                  \
	(((x) & BIT_MASK_TA3_H_V1_8812F) << BIT_SHIFT_TA3_H_V1_8812F)
#define BITS_TA3_H_V1_8812F                                                    \
	(BIT_MASK_TA3_H_V1_8812F << BIT_SHIFT_TA3_H_V1_8812F)
#define BIT_CLEAR_TA3_H_V1_8812F(x) ((x) & (~BITS_TA3_H_V1_8812F))
#define BIT_GET_TA3_H_V1_8812F(x)                                              \
	(((x) >> BIT_SHIFT_TA3_H_V1_8812F) & BIT_MASK_TA3_H_V1_8812F)
#define BIT_SET_TA3_H_V1_8812F(x, v)                                           \
	(BIT_CLEAR_TA3_H_V1_8812F(x) | BIT_TA3_H_V1_8812F(v))

/* 2 REG_TRANSMIT_ADDRSS_4_8812F (TA4 REGISTER) */

#define BIT_SHIFT_TA4_V1_8812F 0
#define BIT_MASK_TA4_V1_8812F 0xffffffffL
#define BIT_TA4_V1_8812F(x)                                                    \
	(((x) & BIT_MASK_TA4_V1_8812F) << BIT_SHIFT_TA4_V1_8812F)
#define BITS_TA4_V1_8812F (BIT_MASK_TA4_V1_8812F << BIT_SHIFT_TA4_V1_8812F)
#define BIT_CLEAR_TA4_V1_8812F(x) ((x) & (~BITS_TA4_V1_8812F))
#define BIT_GET_TA4_V1_8812F(x)                                                \
	(((x) >> BIT_SHIFT_TA4_V1_8812F) & BIT_MASK_TA4_V1_8812F)
#define BIT_SET_TA4_V1_8812F(x, v)                                             \
	(BIT_CLEAR_TA4_V1_8812F(x) | BIT_TA4_V1_8812F(v))

/* 2 REG_TRANSMIT_ADDRSS_4_H_8812F (TA4 REGISTER) */

#define BIT_SHIFT_TA4_H_V1_8812F 0
#define BIT_MASK_TA4_H_V1_8812F 0xffff
#define BIT_TA4_H_V1_8812F(x)                                                  \
	(((x) & BIT_MASK_TA4_H_V1_8812F) << BIT_SHIFT_TA4_H_V1_8812F)
#define BITS_TA4_H_V1_8812F                                                    \
	(BIT_MASK_TA4_H_V1_8812F << BIT_SHIFT_TA4_H_V1_8812F)
#define BIT_CLEAR_TA4_H_V1_8812F(x) ((x) & (~BITS_TA4_H_V1_8812F))
#define BIT_GET_TA4_H_V1_8812F(x)                                              \
	(((x) >> BIT_SHIFT_TA4_H_V1_8812F) & BIT_MASK_TA4_H_V1_8812F)
#define BIT_SET_TA4_H_V1_8812F(x, v)                                           \
	(BIT_CLEAR_TA4_H_V1_8812F(x) | BIT_TA4_H_V1_8812F(v))

/* 2 REG_RSVD_8812F */

/* 2 REG_RSVD_8812F */

/* 2 REG_SND_AID12_8812F */

#define BIT_SHIFT_USERID_SEL_8812F 12
#define BIT_MASK_USERID_SEL_8812F 0x7
#define BIT_USERID_SEL_8812F(x)                                                \
	(((x) & BIT_MASK_USERID_SEL_8812F) << BIT_SHIFT_USERID_SEL_8812F)
#define BITS_USERID_SEL_8812F                                                  \
	(BIT_MASK_USERID_SEL_8812F << BIT_SHIFT_USERID_SEL_8812F)
#define BIT_CLEAR_USERID_SEL_8812F(x) ((x) & (~BITS_USERID_SEL_8812F))
#define BIT_GET_USERID_SEL_8812F(x)                                            \
	(((x) >> BIT_SHIFT_USERID_SEL_8812F) & BIT_MASK_USERID_SEL_8812F)
#define BIT_SET_USERID_SEL_8812F(x, v)                                         \
	(BIT_CLEAR_USERID_SEL_8812F(x) | BIT_USERID_SEL_8812F(v))

#define BIT_SHIFT_USERID_AID12_8812F 0
#define BIT_MASK_USERID_AID12_8812F 0xfff
#define BIT_USERID_AID12_8812F(x)                                              \
	(((x) & BIT_MASK_USERID_AID12_8812F) << BIT_SHIFT_USERID_AID12_8812F)
#define BITS_USERID_AID12_8812F                                                \
	(BIT_MASK_USERID_AID12_8812F << BIT_SHIFT_USERID_AID12_8812F)
#define BIT_CLEAR_USERID_AID12_8812F(x) ((x) & (~BITS_USERID_AID12_8812F))
#define BIT_GET_USERID_AID12_8812F(x)                                          \
	(((x) >> BIT_SHIFT_USERID_AID12_8812F) & BIT_