/******************************************************************************
*
* Copyright(c) 2007 - 2011 Realtek Corporation. All rights reserved.
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of version 2 of the GNU General Public License as
* published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful, but WITHOUT
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
* more details.
*
* You should have received a copy of the GNU General Public License along with
* this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA
*
*
******************************************************************************/

/*Image2HeaderVersion: 2.22*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

#if (RTL8821C_SUPPORT == 1)
static boolean
check_positive(
	struct PHY_DM_STRUCT     *p_dm_odm,
	const u32  condition1,
	const u32  condition2,
	const u32  condition3,
	const u32  condition4
)
{
	u8    _board_type = ((p_dm_odm->board_type & BIT(4)) >> 4) << 0 | /* _GLNA*/
		    ((p_dm_odm->board_type & BIT(3)) >> 3) << 1 | /* _GPA*/
		    ((p_dm_odm->board_type & BIT(7)) >> 7) << 2 | /* _ALNA*/
		    ((p_dm_odm->board_type & BIT(6)) >> 6) << 3 | /* _APA */
		    ((p_dm_odm->board_type & BIT(2)) >> 2) << 4;  /* _BT*/

	u32	cond1   = condition1, cond2 = condition2, cond3 = condition3, cond4 = condition4;
	u32    driver1 = p_dm_odm->cut_version       << 24 |
			 (p_dm_odm->support_interface & 0xF0) << 16 |
			 p_dm_odm->support_platform  << 16 |
			 p_dm_odm->package_type      << 12 |
			 (p_dm_odm->support_interface & 0x0F) << 8  |
			 _board_type;

	u32    driver2 = (p_dm_odm->type_glna & 0xFF) <<  0 |
			 (p_dm_odm->type_gpa & 0xFF)  <<  8 |
			 (p_dm_odm->type_alna & 0xFF) << 16 |
			 (p_dm_odm->type_apa & 0xFF)  << 24;

	u32    driver3 = 0;

	u32    driver4 = (p_dm_odm->type_glna & 0xFF00) >>  8 |
			 (p_dm_odm->type_gpa & 0xFF00) |
			 (p_dm_odm->type_alna & 0xFF00) << 8 |
			 (p_dm_odm->type_apa & 0xFF00)  << 16;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
		("===> check_positive (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n", cond1, cond2, cond3, cond4));
	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
		("===> check_positive (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n", driver1, driver2, driver3, driver4));

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
		("	(Platform, Interface) = (0x%X, 0x%X)\n", p_dm_odm->support_platform, p_dm_odm->support_interface));
	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
		("	(Board, Package) = (0x%X, 0x%X)\n", p_dm_odm->board_type, p_dm_odm->package_type));


	/*============== value Defined Check ===============*/
	/*QFN type [15:12] and cut version [27:24] need to do value check*/

	if (((cond1 & 0x0000F000) != 0) && ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;
	if (((cond1 & 0x0F000000) != 0) && ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1   &= 0x00FF0FFF;
	driver1 &= 0x00FF0FFF;

	if ((cond1 & driver1) == cond1) {
		u32 bit_mask = 0;

		if ((cond1 & 0x0F) == 0) /* board_type is DONTCARE*/
			return true;

		if ((cond1 & BIT(0)) != 0) /*GLNA*/
			bit_mask |= 0x000000FF;
		if ((cond1 & BIT(1)) != 0) /*GPA*/
			bit_mask |= 0x0000FF00;
		if ((cond1 & BIT(2)) != 0) /*ALNA*/
			bit_mask |= 0x00FF0000;
		if ((cond1 & BIT(3)) != 0) /*APA*/
			bit_mask |= 0xFF000000;

		if (((cond2 & bit_mask) == (driver2 & bit_mask)) && ((cond4 & bit_mask) == (driver4 & bit_mask)))  /* board_type of each RF path is matched*/
			return true;
		else
			return false;
	} else
		return false;
}
static boolean
check_negative(
	struct PHY_DM_STRUCT     *p_dm_odm,
	const u32  condition1,
	const u32  condition2
)
{
	return true;
}

/******************************************************************************
*                           AGC_TAB.TXT
******************************************************************************/

u32 array_tc_8821c_agc_tab[] = {
	0x81C, 0xFB000003,
	0x81C, 0xFA020003,
	0x81C, 0xF9040003,
	0x81C, 0xF8060003,
	0x81C, 0xF7080003,
	0x81C, 0xF60A0003,
	0x81C, 0xF50C0003,
	0x81C, 0xF40E0003,
	0x81C, 0xF3100003,
	0x81C, 0xF2120003,
	0x81C, 0xF1140003,
	0x81C, 0xF0160003,
	0x81C, 0xEF180003,
	0x81C, 0xEE1A0003,
	0x81C, 0xED1C0003,
	0x81C, 0xEC1E0003,
	0x81C, 0xEB200003,
	0x81C, 0xEA220003,
	0x81C, 0xE9240003,
	0x81C, 0xE8260003,
	0x81C, 0xE7280003,
	0x81C, 0xE62A0003,
	0x81C, 0xCA2C0003,
	0x81C, 0xC92E0003,
	0x81C, 0xC8300003,
	0x81C, 0xC7320003,
	0x81C, 0xC6340003,
	0x81C, 0xC5360003,
	0x81C, 0xC4380003,
	0x81C, 0xC33A0003,
	0x81C, 0xC23C0003,
	0x81C, 0xC13E0003,
	0x81C, 0x88400003,
	0x81C, 0x87420003,
	0x81C, 0x86440003,
	0x81C, 0x85460003,
	0x81C, 0x84480003,
	0x81C, 0x834A0003,
	0x81C, 0x674C0003,
	0x81C, 0x664E0003,
	0x81C, 0x65500003,
	0x81C, 0x64520003,
	0x81C, 0x63540003,
	0x81C, 0x62560003,
	0x81C, 0x61580003,
	0x81C, 0x455A0003,
	0x81C, 0x445C0003,
	0x81C, 0x435E0003,
	0x81C, 0x42600003,
	0x81C, 0x41620003,
	0x81C, 0x25640003,
	0x81C, 0x24660003,
	0x81C, 0x23680003,
	0x81C, 0x226A0003,
	0x81C, 0x216C0003,
	0x81C, 0x016E0003,
	0x81C, 0x01700003,
	0x81C, 0x01720003,
	0x81C, 0x01740003,
	0x81C, 0x01760003,
	0x81C, 0x01780003,
	0x81C, 0x017A0003,
	0x81C, 0x017C0003,
	0x81C, 0x017E0003,
	0x81C, 0xFF000103,
	0x81C, 0xFF020103,
	0x81C, 0xFF040103,
	0x81C, 0xFE060103,
	0x81C, 0xFD080103,
	0x81C, 0xFC0A0103,
	0x81C, 0xFB0C0103,
	0x81C, 0xFA0E0103,
	0x81C, 0xF9100103,
	0x81C, 0xF8120103,
	0x81C, 0xF7140103,
	0x81C, 0xF6160103,
	0x81C, 0xF5180103,
	0x81C, 0xF41A0103,
	0x81C, 0xF31C0103,
	0x81C, 0xF21E0103,
	0x81C, 0xF1200103,
	0x81C, 0xF0220103,
	0x81C, 0xEF240103,
	0x81C, 0xEE260103,
	0x81C, 0xED280103,
	0x81C, 0xEC2A0103,
	0x81C, 0xEB2C0103,
	0x81C, 0xEA2E0103,
	0x81C, 0xE9300103,
	0x81C, 0xE8320103,
	0x81C, 0xE7340103,
	0x81C, 0xE6360103,
	0x81C, 0xE5380103,
	0x81C, 0xE43A0103,
	0x81C, 0xC63C0103,
	0x81C, 0xC53E0103,
	0x81C, 0xC4400103,
	0x81C, 0xC3420103,
	0x81C, 0xC2440103,
	0x81C, 0xC1460103,
	0x81C, 0xA3480103,
	0x81C, 0xA24A0103,
	0x81C, 0xA14C0103,
	0x81C, 0x834E0103,
	0x81C, 0x82500103,
	0x81C, 0x81520103,
	0x81C, 0x64540103,
	0x81C, 0x63560103,
	0x81C, 0x62580103,
	0x81C, 0x615A0103,
	0x81C, 0x425C0103,
	0x81C, 0x415E0103,
	0x81C, 0x24600103,
	0x81C, 0x23620103,
	0x81C, 0x22640103,
	0x81C, 0x21660103,
	0x81C, 0x03680103,
	0x81C, 0x026A0103,
	0x81C, 0x016C0103,
	0x81C, 0x016E0103,
	0x81C, 0x01700103,
	0x81C, 0x01720103,
	0x81C, 0x01740103,
	0x81C, 0x01760103,
	0x81C, 0x01780103,
	0x81C, 0x017A0103,
	0x81C, 0x017C0103,
	0x81C, 0x017E0103,
	0x81C, 0xFF000203,
	0x81C, 0xFF020203,
	0x81C, 0xFE040203,
	0x81C, 0xFD060203,
	0x81C, 0xFC080203,
	0x81C, 0xFB0A0203,
	0x81C, 0xFA0C0203,
	0x81C, 0xF90E0203,
	0x81C, 0xF8100203,
	0x81C, 0xF7120203,
	0x81C, 0xF6140203,
	0x81C, 0xF5160203,
	0x81C, 0xF4180203,
	0x81C, 0xF31A0203,
	0x81C, 0xF21C0203,
	0x81C, 0xF11E0203,
	0x81C, 0xF0200203,
	0x81C, 0xEF220203,
	0x81C, 0xEE240203,
	0x81C, 0xED260203,
	0x81C, 0xEC280203,
	0x81C, 0xEB2A0203,
	0x81C, 0xEA2C0203,
	0x81C, 0xE92E0203,
	0x81C, 0xE8300203,
	0x81C, 0xE7320203,
	0x81C, 0xE6340203,
	0x81C, 0xE5360203,
	0x81C, 0xE4380203,
	0x81C, 0xE33A0203,
	0x81C, 0xE23C0203,
	0x81C, 0xE13E0203,
	0x81C, 0xC4400203,
	0x81C, 0xC3420203,
	0x81C, 0xC2440203,
	0x81C, 0xC1460203,
	0x81C, 0xA3480203,
	0x81C, 0xA24A0203,
	0x81C, 0xA14C0203,
	0x81C, 0x834E0203,
	0x81C, 0x82500203,
	0x81C, 0x81520203,
	0x81C, 0x64540203,
	0x81C, 0x63560203,
	0x81C, 0x62580203,
	0x81C, 0x615A0203,
	0x81C, 0x425C0203,
	0x81C, 0x415E0203,
	0x81C, 0x22600203,
	0x81C, 0x21620203,
	0x81C, 0x04640203,
	0x81C, 0x03660203,
	0x81C, 0x02680203,
	0x81C, 0x016A0203,
	0x81C, 0x016C0203,
	0x81C, 0x016E0203,
	0x81C, 0x01700203,
	0x81C, 0x01720203,
	0x81C, 0x01740203,
	0x81C, 0x01760203,
	0x81C, 0x01780203,
	0x81C, 0x017A0203,
	0x81C, 0x017C0203,
	0x81C, 0x017E0203,
	0x81C, 0xFF000303,
	0x81C, 0xFF020303,
	0x81C, 0xFE040303,
	0x81C, 0xFD060303,
	0x81C, 0xFC080303,
	0x81C, 0xFB0A0303,
	0x81C, 0xFA0C0303,
	0x81C, 0xF90E0303,
	0x81C, 0xF8100303,
	0x81C, 0xF7120303,
	0x81C, 0xF6140303,
	0x81C, 0xF5160303,
	0x81C, 0xF4180303,
	0x81C, 0xF31A0303,
	0x81C, 0xF21C0303,
	0x81C, 0xF11E0303,
	0x81C, 0xF0200303,
	0x81C, 0xEF220303,
	0x81C, 0xEE240303,
	0x81C, 0xED260303,
	0x81C, 0xEC280303,
	0x81C, 0xEB2A0303,
	0x81C, 0xEA2C0303,
	0x81C, 0xE92E0303,
	0x81C, 0xE8300303,
	0x81C, 0xE7320303,
	0x81C, 0xE6340303,
	0x81C, 0xE5360303,
	0x81C, 0xE4380303,
	0x81C, 0xE33A0303,
	0x81C, 0xE23C0303,
	0x81C, 0xE13E0303,
	0x81C, 0xC4400303,
	0x81C, 0xC3420303,
	0x81C, 0xC2440303,
	0x81C, 0xC1460303,
	0x81C, 0xA4480303,
	0x81C, 0xA34A0303,
	0x81C, 0xA24C0303,
	0x81C, 0xA14E0303,
	0x81C, 0x83500303,
	0x81C, 0x82520303,
	0x81C, 0x81540303,
	0x81C, 0x64560303,
	0x81C, 0x63580303,
	0x81C, 0x625A0303,
	0x81C, 0x615C0303,
	0x81C, 0x425E0303,
	0x81C, 0x41600303,
	0x81C, 0x23620303,
	0x81C, 0x22640303,
	0x81C, 0x21660303,
	0x81C, 0x03680303,
	0x81C, 0x026A0303,
	0x81C, 0x016C0303,
	0x81C, 0x016E0303,
	0x81C, 0x01700303,
	0x81C, 0x01720303,
	0x81C, 0x01740303,
	0x81C, 0x01760303,
	0x81C, 0x01780303,
	0x81C, 0x017A0303,
	0x81C, 0x017C0303,
	0x81C, 0x017E0303,
	0x81C, 0xFB000403,
	0x81C, 0xFA020403,
	0x81C, 0xF9040403,
	0x81C, 0xF8060403,
	0x81C, 0xF7080403,
	0x81C, 0xF60A0403,
	0x81C, 0xF50C0403,
	0x81C, 0xF40E0403,
	0x81C, 0xF3100403,
	0x81C, 0xF2120403,
	0x81C, 0xF1140403,
	0x81C, 0xF0160403,
	0x81C, 0xEF180403,
	0x81C, 0xEE1A0403,
	0x81C, 0xED1C0403,
	0x81C, 0xB61E0403,
	0x81C, 0xB5200403,
	0x81C, 0xB4220403,
	0x81C, 0xB3240403,
	0x81C, 0xB2260403,
	0x81C, 0xB1280403,
	0x81C, 0xAF2A0403,
	0x81C, 0xAE2C0403,
	0x81C, 0xAD2E0403,
	0x81C, 0xAC300403,
	0x81C, 0xAB320403,
	0x81C, 0xAA340403,
	0x81C, 0xA9360403,
	0x81C, 0xA8380403,
	0x81C, 0xA73A0403,
	0x81C, 0xA63C0403,
	0x81C, 0xA53E0403,
	0x81C, 0x88400403,
	0x81C, 0x87420403,
	0x81C, 0x86440403,
	0x81C, 0x85460403,
	0x81C, 0x84480403,
	0x81C, 0x834A0403,
	0x81C, 0x674C0403,
	0x81C, 0x664E0403,
	0x81C, 0x65500403,
	0x81C, 0x64520403,
	0x81C, 0x63540403,
	0x81C, 0x62560403,
	0x81C, 0x61580403,
	0x81C, 0x455A0403,
	0x81C, 0x445C0403,
	0x81C, 0x435E0403,
	0x81C, 0x42600403,
	0x81C, 0x41620403,
	0x81C, 0x25640403,
	0x81C, 0x24660403,
	0x81C, 0x23680403,
	0x81C, 0x226A0403,
	0x81C, 0x216C0403,
	0x81C, 0x016E0403,
	0x81C, 0x01700403,
	0x81C, 0x01720403,
	0x81C, 0x01740403,
	0x81C, 0x01760403,
	0x81C, 0x01780403,
	0x81C, 0x017A0403,
	0x81C, 0x017C0403,
	0x81C, 0x017E0403,
	0xC50, 0x00000022,
	0xC50, 0x00000020,

};

void
odm_read_and_config_tc_8821c_agc_tab(
	struct PHY_DM_STRUCT  *p_dm_odm
)
{
	u32     i         = 0;
	u8     c_cond;
	boolean is_matched = true, is_skipped = false;
	u32     array_len    = sizeof(array_tc_8821c_agc_tab) / sizeof(u32);
	u32    *array       = array_tc_8821c_agc_tab;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> odm_read_and_config_tc_8821c_agc_tab\n"));

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT30)) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  = (u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ELSE\n"));
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (is_skipped == false) {
					if (check_positive(p_dm_odm, pre_v1, pre_v2, v1, v2)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else
					is_matched = false;
			}
		} else {
			if (is_matched)
				odm_config_bb_agc_8821c(p_dm_odm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_tc_8821c_agc_tab(void)
{
	return 9;
}

/******************************************************************************
*                           PHY_REG.TXT
******************************************************************************/

u32 array_tc_8821c_phy_reg[] = {
	0x800, 0x9020D010,
	0x804, 0x80018180,
	0x808, 0x04028211,
	0x80C, 0x13D10011,
	0x810, 0x21101263,
	0x814, 0x020C3D10,
	0x818, 0x84A10385,
	0x81C, 0x1E1E081F,
	0x820, 0x0001AAAA,
	0x824, 0x00030FE0,
	0x828, 0x0000CCCC,
	0x82C, 0x75CB7010,
	0x830, 0x79A0EA2A,
	0x834, 0x072E6986,
	0x838, 0x87766461,
	0x83C, 0x9194B2B6,
	0x840, 0x171740E0,
	0x844, 0x4D3D7CDB,
	0x848, 0x4AD0408B,
	0x84C, 0x6AFBF7A5,
	0x850, 0x28A74706,
	0x854, 0x0001520C,
	0x858, 0x4060C000,
	0x85C, 0x74010360,
	0x860, 0x68A7C321,
	0x864, 0x79F27432,
	0x868, 0x8CA7A314,
	0x86C, 0x778C2878,
	0x870, 0x77777777,
	0x874, 0x27612C2E,
	0x878, 0xC0003152,
	0x87C, 0x5C8FC000,
	0x880, 0x00000000,
	0x884, 0x00000000,
	0x888, 0x00000000,
	0x88C, 0x00000000,
	0x890, 0x00000000,
	0x894, 0x00000000,
	0x898, 0x00000000,
	0x89C, 0x00000000,
	0x8A0, 0x00000013,
	0x8A4, 0x7F7F7F7F,
	0x8A8, 0x2202033E,
	0x8AC, 0xF00F000A,
	0x8B0, 0x00000600,
	0x8B4, 0x000FC080,
	0x8B8, 0xEC0057FF,
	0x8BC, 0xACB520A3,
	0x8C0, 0xFFE04020,
	0x8C4, 0x47C00000,
	0x8C8, 0x000251A5,
	0x8CC, 0x08108492,
	0x8D0, 0x0000B800,
	0x8D4, 0x860308A0,
	0x8D8, 0x290B5612,
	0x8DC, 0x00000000,
	0x8E0, 0x32D16777,
	0x8E4, 0x49092925,
	0x8E8, 0xFFFFC42C,
	0x8EC, 0x99999999,
	0x8F0, 0x00009999,
	0x8F4, 0x00D80FA1,
	0x8F8, 0x400000C0,
	0x8FC, 0x00000130,
	0x900, 0x00C00000,
	0x904, 0x0FFF0FFF,
	0x908, 0x00000000,
	0x90C, 0x13000000,
	0x910, 0x0000FC00,
	0x914, 0xC6380000,
	0x918, 0x1C1028C0,
	0x91C, 0x64B11A1C,
	0x920, 0xE0767233,
	0x924, 0x055A2500,
	0x928, 0x4AB0E4E4,
	0x92C, 0xFFFEB200,
	0x930, 0xFFFFFFFE,
	0x934, 0x001FFFFF,
	0x938, 0x00008480,
	0x93C, 0xE41C0642,
	0x940, 0x0E470430,
	0x944, 0x00000000,
	0x948, 0xAC000000,
	0x94C, 0x10000083,
	0x950, 0xF2010080,
	0x954, 0x86510080,
	0x958, 0x00000001,
	0x95C, 0x04248000,
	0x960, 0x00000000,
	0x964, 0x00000000,
	0x968, 0x00000000,
	0x96C, 0x00000000,
	0x970, 0x00001FFF,
	0x974, 0x04000FFF,
	0x978, 0x00000000,
	0x97C, 0x00000000,
	0x980, 0x00000000,
	0x984, 0x00000000,
	0x988, 0x00000000,
	0x98C, 0x23440000,
	0x990, 0x27100000,
	0x994, 0xFFFF0100,
	0x998, 0xFFFFFF5C,
	0x99C, 0xFFFFFFFF,
	0x9A0, 0x000000FF,
	0x9A4, 0x80000088,
	0x9A8, 0x0C2F0000,
	0x9AC, 0x01560000,
	0x9B0, 0x70000000,
	0x9B4, 0x00000000,
	0x9B8, 0x00000000,
	0x9BC, 0x00000000,
	0x9C0, 0x00000000,
	0x9C4, 0x00000000,
	0x9C8, 0x00000000,
	0x9CC, 0x00000000,
	0x9D0, 0x00000000,
	0x9D4, 0x00000000,
	0x9D8, 0x00000000,
	0x9DC, 0x00000000,
	0x9E0, 0x00000000,
	0x9E4, 0x02000402,
	0x9E8, 0x000022D4,
	0x9EC, 0x00000000,
	0x9F0, 0x00000000,
	0x9F4, 0x00000000,
	0x9F8, 0x00000000,
	0x9FC, 0xEFFFF7FF,
	0xA00, 0x00D047C8,
	0xA04, 0x80FF800C,
	0xA08, 0x9C838300,
	0xA0C, 0x2E20200F,
	0xA10, 0x9500BB78,
	0xA14, 0x1114D028,
	0xA18, 0x00881117,
	0xA1C, 0x89140F00,
	0xA20, 0xE82C0000,
	0xA24, 0x64B80C1C,
	0xA28, 0x00008810,
	0xA2C, 0x00D20000,
	0xA70, 0x101FBF00,
	0xA74, 0x00000107,
	0xA78, 0x00008900,
	0xA7C, 0x225B0606,
	0xA80, 0x21807532,
	0xA84, 0x80200000,
	0xA88, 0x048C0000,
	0xA8C, 0x12345678,
	0xA90, 0xABCDEF00,
	0xA94, 0x001B1B89,
	0xA98, 0x00000000,
	0xA9C, 0x00060000,
	0xAA0, 0x00000000,
	0xAA4, 0x00040000,
	0xAA8, 0xEACF0004,
	0xAAC, 0x01235667,
	0xAB0, 0x00000000,
	0xB00, 0xE1000440,
	0xB04, 0x00800000,
	0xB08, 0xFF02030B,
	0xB0C, 0x01EAA406,
	0xB10, 0x00030690,
	0xB14, 0x006000FA,
	0xB18, 0x00000002,
	0xB1C, 0x00000002,
	0xB20, 0x4B00001F,
	0xB24, 0x4E8E3E40,
	0xB28, 0x03020100,
	0xB2C, 0x07060504,
	0xB30, 0x0B0A0908,
	0xB34, 0x0F0E0D0C,
	0xB38, 0x13121110,
	0xB3C, 0x0000003A,
	0xB40, 0x00000000,
	0xB44, 0x80000000,
	0xB48, 0x3F0000FA,
	0xB4C, 0x88C80020,
	0xB50, 0x00000000,
	0xB54, 0x00004241,
	0xB58, 0xE0008208,
	0xB5C, 0x41EFFFF9,
	0xB60, 0x00000000,
	0xB64, 0x00200063,
	0xB68, 0x0000003A,
	0xB6C, 0x00000102,
	0xB70, 0x4E6D1870,
	0xB74, 0x03020100,
	0xB78, 0x07060504,
	0xB7C, 0x0B0A0908,
	0xB80, 0x0F0E0D0C,
	0xB84, 0x13121110,
	0xB88, 0x00000000,
	0xB8C, 0x00000000,
	0xC00, 0x00000007,
	0xC04, 0x03000020,
	0xC08, 0x60403231,
	0xC0C, 0x00012345,
	0xC10, 0x00000100,
	0xC14, 0x01000000,
	0xC18, 0x00000000,
	0xC1C, 0x40040053,
	0xC20, 0x000503A3,
	0xC24, 0x00000000,
	0xC28, 0x00000000,
	0xC2C, 0x00000000,
	0xC30, 0x00000000,
	0xC34, 0x00000000,
	0xC38, 0x00000000,
	0xC3C, 0x00000000,
	0xC40, 0x00000000,
	0xC44, 0x00000000,
	0xC48, 0x00000000,
	0xC4C, 0x00000000,
	0xC50, 0x00000020,
	0xC54, 0x00000000,
	0xC58, 0xD8020402,
	0xC5C, 0xDE000120,
	0xC68, 0x00000179,
	0xC6C, 0x0000122A,
	0xC70, 0x00000000,
	0xC74, 0x00000000,
	0xC78, 0x00000000,
	0xC7C, 0x00000000,
	0xC80, 0x00000000,
	0xC84, 0x00000000,
	0xC88, 0x00000000,
	0xC8C, 0x07000000,
	0xC94, 0x01000100,
	0xC98, 0x201C8000,
	0xC9C, 0x00000000,
	0xCA0, 0x0000A555,
	0xCA4, 0x08040201,
	0xCA8, 0x80402010,
	0xCAC, 0x00000000,
	0xCB0, 0x98543210,
	0xCB4, 0x10000077,
	0xCB8, 0x00000000,
	0xCBC, 0x00000000,
	0xCC0, 0x00000000,
	0xCC4, 0x00000000,
	0xCC8, 0x00000000,
	0xCCC, 0x00000000,
	0xCD0, 0x00000000,
	0xCD4, 0x00000000,
	0xCD8, 0x00000000,
	0xCDC, 0x00000000,
	0xCE0, 0x00000000,
	0xCE4, 0x00000000,
	0xCE8, 0x00000000,
	0xCEC, 0x00000000,
	0xE00, 0x00000007,
	0xE04, 0x00000020,
	0xE08, 0x60403231,
	0xE0C, 0x00012345,
	0xE10, 0x00000100,
	0xE14, 0x01000000,
	0xE18, 0x00000000,
	0xE1C, 0x40040053,
	0xE20, 0x00020103,
	0xE24, 0x00000000,
	0xE28, 0x00000000,
	0xE2C, 0x00000000,
	0xE30, 0x00000000,
	0xE34, 0x00000000,
	0xE38, 0x00000000,
	0xE3C, 0x00000000,
	0xE40, 0x00000000,
	0xE44, 0x00000000,
	0xE48, 0x00000000,
	0xE4C, 0x00000000,
	0xE50, 0x00000020,
	0xE54, 0x00000000,
	0xE58, 0xD8020402,
	0xE5C, 0xDE000120,
	0xE68, 0x59799979,
	0xE6C, 0x0000122A,
	0xE70, 0x99795979,
	0xE74, 0x99795979,
	0xE78, 0x99799979,
	0xE7C, 0x99791979,
	0xE80, 0x19791979,
	0xE84, 0x19791979,
	0xE88, 0x00000000,
	0xE8C, 0x07000000,
	0xE94, 0x01000100,
	0xE98, 0x201C8000,
	0xE9C, 0x00000000,
	0xEA0, 0x0000A555,
	0xEA4, 0x08040201,
	0xEA8, 0x80402010,
	0xEAC, 0x00000000,
	0xEB0, 0x98543210,
	0xEB4, 0x000000BA,
	0xEB8, 0x00000000,
	0xEBC, 0x00000000,
	0xEC0, 0x00000000,
	0xEC4, 0x00000000,
	0xEC8, 0x00000000,
	0xECC, 0x00000000,
	0xED0, 0x00000000,
	0xED4, 0x00000000,
	0xED8, 0x00000000,
	0xEDC, 0x00000000,
	0xEE0, 0x00000000,
	0xEE4, 0x00000000,
	0xEE8, 0x00000000,
	0xEEC, 0x00000000,
	0x1900, 0x00000000,
	0x1904, 0x00238000,
	0x1908, 0x00000000,
	0x190C, 0x00000000,
	0x1910, 0x00000000,
	0x1914, 0x00000000,
	0x1918, 0x00000000,
	0x191C, 0x00000000,
	0x1920, 0x00000000,
	0x1924, 0x00000000,
	0x1928, 0x00000000,
	0x192C, 0x00000000,
	0x1930, 0x00000000,
	0x1934, 0x00000000,
	0x1938, 0x00000000,
	0x193C, 0x00000000,
	0x1940, 0x00000000,
	0x1944, 0x00000000,
	0x1948, 0x00000000,
	0x194C, 0x00000000,
	0x1950, 0x00000000,
	0x1954, 0x00000000,
	0x1958, 0x00000000,
	0x195C, 0x00000000,
	0x1960, 0x00000000,
	0x1964, 0x00000000,
	0x1968, 0x00000000,
	0x196C, 0x00000000,
	0x1970, 0x00000000,
	0x1974, 0x00000000,
	0x1978, 0x00000000,
	0x197C, 0x00000000,
	0x1980, 0x00000000,
	0x1984, 0x03000000,
	0x1988, 0x21401E88,
	0x198C, 0x00004000,
	0x1990, 0x00000000,
	0x1994, 0x00000000,
	0x1998, 0x00000053,
	0x199C, 0x00000000,
	0x19A0, 0x00000000,
	0x19A4, 0x00000000,
	0x19A8, 0x00000000,
	0x19AC, 0x0E47E47F,
	0x19B0, 0x00000000,
	0x19B4, 0x0E47E47F,
	0x19B8, 0x00000000,
	0x19BC, 0x00000000,
	0x19C0, 0x00000000,
	0x19C4, 0x00000000,
	0x19C8, 0x00000000,
	0x19CC, 0x00000000,
	0x19D0, 0x00000000,
	0x19D4, 0x77777777,
	0x19D8, 0x00000777,
	0x19DC, 0x133E0F37,
	0x19E0, 0x00000000,
	0x19E4, 0x00000000,
	0x19E8, 0x00000000,
	0x19EC, 0x00000000,
	0x19F0, 0x00000000,
	0x19F4, 0x00000000,
	0x19F8, 0x01A00000,
	0x19FC, 0x00000000,
	0x1C00, 0x00000100,
	0x1C04, 0x01000000,
	0x1C08, 0x00000100,
	0x1C0C, 0x01000000,
	0x1C10, 0x00000100,
	0x1C14, 0x01000000,
	0x1C18, 0x00000100,
	0x1C1C, 0x01000000,
	0x1C20, 0x00000100,
	0x1C24, 0x01000000,
	0x1C28, 0x00000100,
	0x1C2C, 0x01000000,
	0x1C30, 0x00000100,
	0x1C34, 0x01000000,
	0x1C38, 0x00000000,
	0x1C3C, 0x00000000,
	0x1C40, 0x000C0100,
	0x1C44, 0x000000F3,
	0x1C48, 0x1A8249A8,
	0x1C4C, 0x1461C826,
	0x1C50, 0x0001469E,
	0x1C54, 0x58D158D1,
	0x1C58, 0x04490088,
	0x1C5C, 0x04004400,
	0x1C60, 0x00000000,
	0x1C64, 0x04004400,
	0x1C68, 0x00000100,
	0x1C6C, 0x01000000,
	0x1C70, 0x00A018C6,
	0x1C74, 0x2080E0C0,
	0x1C78, 0x00000000,
	0x1C7C, 0x00000010,
	0x1C80, 0x00000100,
	0x1C84, 0x01000000,
	0x1C88, 0x00000100,
	0x1C8C, 0x01000000,
	0x1C90, 0x00000100,
	0x1C94, 0x01000000,
	0x1C98, 0x00000100,
	0x1C9C, 0x01000000,
	0x1CA0, 0x00000100,
	0x1CA4, 0x01000000,
	0x1CA8, 0x00000100,
	0x1CAC, 0x01000000,
	0x1CB0, 0x00000100,
	0x1CB4, 0x01000000,
	0x1CB8, 0x00000000,
	0x1CBC, 0x00000000,
	0x1CC0, 0x50055100,
	0x1CC4, 0x06318000,
	0x1CC8, 0x5B75B6EB,
	0x1CCC, 0x01000000,
	0x1CD0, 0x00000100,
	0x1CD4, 0x01000014,
	0x1CD8, 0x00000100,
	0x1CDC, 0x01000000,
	0x1CE0, 0x02050205,
	0x1CE4, 0x7B780003,
	0x1CE8, 0x00000100,
	0x1CEC, 0x01000000,
	0x1CF0, 0x00000100,
	0x1CF4, 0x01000000,
	0x1CF8, 0x01B8ADEB,
	0x1CFC, 0x00000000,
	0xC60, 0x700B8040,
	0xC60, 0x700B8040,
	0xC60, 0x70146040,
	0xC60, 0x70246040,
	0xC60, 0x70346040,
	0xC60, 0x70446040,
	0xC60, 0x705B2040,
	0xC60, 0x70646040,
	0xC60, 0x707B8040,
	0xC60, 0x708B8040,
	0xC60, 0x709B8040,
	0xC60, 0x70AB8040,
	0xC60, 0x70BB6040,
	0xC60, 0x70C06040,
	0xC60, 0x70D06040,
	0xC60, 0x70EF6040,
	0xC60, 0x70F06040,
	0xE60, 0x700B8040,
	0xE60, 0x700B8040,
	0xE60, 0x70146040,
	0xE60, 0x70246040,
	0xE60, 0x70346040,
	0xE60, 0x70446040,
	0xE60, 0x705B2040,
	0xE60, 0x70646040,
	0xE60, 0x707B8040,
	0xE60, 0x708B8040,
	0xE60, 0x709B8040,
	0xE60, 0x70AB8040,
	0xE60, 0x70BB6040,
	0xE60, 0x70C06040,
	0xE60, 0x70D06040,
	0xE60, 0x70EF6040,
	0xE60, 0x70F06040,
	0xC64, 0x00800000,
	0xC64, 0x08800001,
	0xC64, 0x00800002,
	0xC64, 0x00800003,
	0xC64, 0x00800004,
	0xC64, 0x00800005,
	0xC64, 0x00800006,
	0xC64, 0x08800007,
	0xC64, 0x00004000,
	0xE64, 0x00800000,
	0xE64, 0x08800001,
	0xE64, 0x00800002,
	0xE64, 0x00800003,
	0xE64, 0x00800004,
	0xE64, 0x00800005,
	0xE64, 0x00800006,
	0xE64, 0x08800007,
	0xE64, 0x00004000,
	0x1B00, 0xF8000008,
	0x1B00, 0xF80A7008,
	0x1B00, 0xF8015008,
	0x1B00, 0xF8000008,
	0x1B04, 0xE24629D2,
	0x1B08, 0x00000080,
	0x1B0C, 0x00000000,
	0x1B10, 0x00010C00,
	0x1B14, 0x00000000,
	0x1B18, 0x00292903,
	0x1B1C, 0xA2193C32,
	0x1B20, 0x01840008,
	0x1B24, 0x01860008,
	0x1B28, 0x80060300,
	0x1B2C, 0x00000003,
	0x1B30, 0x20000000,
	0x1B34, 0x00000800,
	0x1B3C, 0x20000000,
	0x1BC0, 0x01000000,
	0x1BCC, 0x00000000,
	0x1B00, 0xF800000A,
	0x1B1C, 0xA2193C32,
	0x1B20, 0x01840008,
	0x1B24, 0x01860008,
	0x1B28, 0x80060300,
	0x1B2C, 0x00000003,
	0x1B30, 0x20000000,
	0x1B34, 0x00000800,
	0x1B3C, 0x20000000,
	0x1BC0, 0x01000000,
	0x1BCC, 0x00000000,
	0x1B00, 0xF8000008,
	0x1B80, 0x00000007,
	0x1B80, 0x090A0005,
	0x1B80, 0x090A0007,
	0x1B80, 0x0FFE0015,
	0x1B80, 0x0FFE0017,
	0x1B80, 0x00220025,
	0x1B80, 0x00220027,
	0x1B80, 0x00040035,
	0x1B80, 0x00040037,
	0x1B80, 0x05C00045,
	0x1B80, 0x05C00047,
	0x1B80, 0x00070055,
	0x1B80, 0x00070057,
	0x1B80, 0x64000065,
	0x1B80, 0x64000067,
	0x1B80, 0x00020075,
	0x1B80, 0x00020077,
	0x1B80, 0x00080085,
	0x1B80, 0x00080087,
	0x1B80, 0x80000095,
	0x1B80, 0x80000097,
	0x1B80, 0x090800A5,
	0x1B80, 0x090800A7,
	0x1B80, 0x0F0200B5,
	0x1B80, 0x0F0200B7,
	0x1B80, 0x002200C5,
	0x1B80, 0x002200C7,
	0x1B80, 0x000400D5,
	0x1B80, 0x000400D7,
	0x1B80, 0x05C000E5,
	0x1B80, 0x05C000E7,
	0x1B80, 0x000700F5,
	0x1B80, 0x000700F7,
	0x1B80, 0x64020105,
	0x1B80, 0x64020107,
	0x1B80, 0x00020115,
	0x1B80, 0x00020117,
	0x1B80, 0x00040125,
	0x1B80, 0x00040127,
	0x1B80, 0x4A000135,
	0x1B80, 0x4A000137,
	0x1B80, 0x4B040145,
	0x1B80, 0x4B040147,
	0x1B80, 0x85030155,
	0x1B80, 0x85030157,
	0x1B80, 0x40090165,
	0x1B80, 0x40090167,
	0x1B80, 0xE0210175,
	0x1B80, 0xE0210177,
	0x1B80, 0x4B050185,
	0x1B80, 0x4B050187,
	0x1B80, 0x86030195,
	0x1B80, 0x86030197,
	0x1B80, 0x400B01A5,
	0x1B80, 0x400B01A7,
	0x1B80, 0xE02101B5,
	0x1B80, 0xE02101B7,
	0x1B80, 0x4B0001C5,
	0x1B80, 0x4B0001C7,
	0x1B80, 0x000701D5,
	0x1B80, 0x000701D7,
	0x1B80, 0x4C0001E5,
	0x1B80, 0x4C0001E7,
	0x1B80, 0x000401F5,
	0x1B80, 0x000401F7,
	0x1B80, 0x30000205,
	0x1B80, 0x30000207,
	0x1B80, 0xFE160215,
	0x1B80, 0xFE160217,
	0x1B80, 0xFF160225,
	0x1B80, 0xFF160227,
	0x1B80, 0xE1670235,
	0x1B80, 0xE1670237,
	0x1B80, 0xF00A0245,
	0x1B80, 0xF00A0247,
	0x1B80, 0xF10A0255,
	0x1B80, 0xF10A0257,
	0x1B80, 0xF20A0265,
	0x1B80, 0xF20A0267,
	0x1B80, 0xF30A0275,
	0x1B80, 0xF30A0277,
	0x1B80, 0xF40A0285,
	0x1B80, 0xF40A0287,
	0x1B80, 0xF50A0295,
	0x1B80, 0xF50A0297,
	0x1B80, 0xF60A02A5,
	0x1B80, 0xF60A02A7,
	0x1B80, 0xF70A02B5,
	0x1B80, 0xF70A02B7,
	0x1B80, 0xF80A02C5,
	0x1B80, 0xF80A02C7,
	0x1B80, 0x000102D5,
	0x1B80, 0x000102D7,
	0x1B80, 0x303902E5,
	0x1B80, 0x303902E7,
	0x1B80, 0x305102F5,
	0x1B80, 0x305102F7,
	0x1B80, 0x309C0305,
	0x1B80, 0x309C0307,
	0x1B80, 0x30530315,
	0x1B80, 0x30530317,
	0x1B80, 0x305E0325,
	0x1B80, 0x305E0327,
	0x1B80, 0x30690335,
	0x1B80, 0x30690337,
	0x1B80, 0x30A00345,
	0x1B80, 0x30A00347,
	0x1B80, 0x30AF0355,
	0x1B80, 0x30AF0357,
	0x1B80, 0x30BA0365,
	0x1B80, 0x30BA0367,
	0x1B80, 0x30ED0375,
	0x1B80, 0x30ED0377,
	0x1B80, 0x30F00385,
	0x1B80, 0x30F00387,
	0x1B80, 0xE1060395,
	0x1B80, 0xE1060397,
	0x1B80, 0x4D0403A5,
	0x1B80, 0x4D0403A7,
	0x1B80, 0x208003B5,
	0x1B80, 0x208003B7,
	0x1B80, 0x000003C5,
	0x1B80, 0x000003C7,
	0x1B80, 0x4D0003D5,
	0x1B80, 0x4D0003D7,
	0x1B80, 0x550703E5,
	0x1B80, 0x550703E7,
	0x1B80, 0xE0FE03F5,
	0x1B80, 0xE0FE03F7,
	0x1B80, 0xE0FE0405,
	0x1B80, 0xE0FE0407,
	0x1B80, 0x4D040415,
	0x1B80, 0x4D040417,
	0x1B80, 0x20880425,
	0x1B80, 0x20880427,
	0x1B80, 0x02000435,
	0x1B80, 0x02000437,
	0x1B80, 0x4D000445,
	0x1B80, 0x4D000447,
	0x1B80, 0x550F0455,
	0x1B80, 0x550F0457,
	0x1B80, 0xE0FE0465,
	0x1B80, 0xE0FE0467,
	0x1B80, 0x4F020475,
	0x1B80, 0x4F020477,
	0x1B80, 0x4E000485,
	0x1B80, 0x4E000487,
	0x1B80, 0x53020495,
	0x1B80, 0x53020497,
	0x1B80, 0x520104A5,
	0x1B80, 0x520104A7,
	0x1B80, 0xE10204B5,
	0x1B80, 0xE10204B7,
	0x1B80, 0x4D0804C5,
	0x1B80, 0x4D0804C7,
	0x1B80, 0x571004D5,
	0x1B80, 0x571004D7,
	0x1B80, 0x570004E5,
	0x1B80, 0x570004E7,
	0x1B80, 0x4D0004F5,
	0x1B80, 0x4D0004F7,
	0x1B80, 0x00010505,
	0x1B80, 0x00010507,
	0x1B80, 0xE1060515,
	0x1B80, 0xE1060517,
	0x1B80, 0x00010525,
	0x1B80, 0x00010527,
	0x1B80, 0x30730535,
	0x1B80, 0x30730537,
	0x1B80, 0x00230545,
	0x1B80, 0x00230547,
	0x1B80, 0xE15A0555,
	0x1B80, 0xE15A0557,
	0x1B80, 0x00020565,
	0x1B80, 0x00020567,
	0x1B80, 0x54E90575,
	0x1B80, 0x54E90577,
	0x1B80, 0x0BA60585,
	0x1B80, 0x0BA60587,
	0x1B80, 0x00230595,
	0x1B80, 0x00230597,
	0x1B80, 0xE15A05A5,
	0x1B80, 0xE15A05A7,
	0x1B80, 0x000205B5,
	0x1B80, 0x000205B7,
	0x1B80, 0x4D3005C5,
	0x1B80, 0x4D3005C7,
	0x1B80, 0x308C05D5,
	0x1B80, 0x308C05D7,
	0x1B80, 0x306F05E5,
	0x1B80, 0x306F05E7,
	0x1B80, 0x002205F5,
	0x1B80, 0x002205F7,
	0x1B80, 0xE15A0605,
	0x1B80, 0xE15A0607,
	0x1B80, 0x00020615,
	0x1B80, 0x00020617,
	0x1B80, 0x54E80625,
	0x1B80, 0x54E80627,
	0x1B80, 0x0BA60635,
	0x1B80, 0x0BA60637,
	0x1B80, 0x00220645,
	0x1B80, 0x00220647,
	0x1B80, 0xE15A0655,
	0x1B80, 0xE15A0657,
	0x1B80, 0x00020665,
	0x1B80, 0x00020667,
	0x1B80, 0x4D300675,
	0x1B80, 0x4D300677,
	0x1B80, 0x308C0685,
	0x1B80, 0x308C0687,
	0x1B80, 0x63F10695,
	0x1B80, 0x63F10697,
	0x1B80, 0xE10606A5,
	0x1B80, 0xE10606A7,
	0x1B80, 0xE15A06B5,
	0x1B80, 0xE15A06B7,
	0x1B80, 0x63F406C5,
	0x1B80, 0x63F406C7,
	0x1B80, 0xE10606D5,
	0x1B80, 0xE10606D7,
	0x1B80, 0xE15A06E5,
	0x1B80, 0xE15A06E7,
	0x1B80, 0x0BA806F5,
	0x1B80, 0x0BA806F7,
	0x1B80, 0x63F80705,
	0x1B80, 0x63F80707,
	0x1B80, 0xE1060715,
	0x1B80, 0xE1060717,
	0x1B80, 0xE15A0725,
	0x1B80, 0xE15A0727,
	0x1B80, 0x0BA90735,
	0x1B80, 0x0BA90737,
	0x1B80, 0x63FC0745,
	0x1B80, 0x63FC0747,
	0x1B80, 0xE1060755,
	0x1B80, 0xE1060757,
	0x1B80, 0xE15A0765,
	0x1B80, 0xE15A0767,
	0x1B80, 0x63FF0775,
	0x1B80, 0x63FF0777,
	0x1B80, 0xE1060785,
	0x1B80, 0xE1060787,
	0x1B80, 0xE15A0795,
	0x1B80, 0xE15A0797,
	0x1B80, 0x630007A5,
	0x1B80, 0x630007A7,
	0x1B80, 0xE10607B5,
	0x1B80, 0xE10607B7,
	0x1B80, 0xE15A07C5,
	0x1B80, 0xE15A07C7,
	0x1B80, 0x630307D5,
	0x1B80, 0x630307D7,
	0x1B80, 0xE10607E5,
	0x1B80, 0xE10607E7,
	0x1B80, 0xE15A07F5,
	0x1B80, 0xE15A07F7,
	0x1B80, 0xF3D40805,
	0x1B80, 0xF3D40807,
	0x1B80, 0x63070815,
	0x1B80, 0x63070817,
	0x1B80, 0xE1060825,
	0x1B80, 0xE1060827,
	0x1B80, 0xE15A0835,
	0x1B80, 0xE15A0837,
	0x1B80, 0xF4DB0845,
	0x1B80, 0xF4DB0847,
	0x1B80, 0x630B0855,
	0x1B80, 0x630B0857,
	0x1B80, 0xE1060865,
	0x1B80, 0xE1060867,
	0x1B80, 0xE15A0875,
	0x1B80, 0xE15A0877,
	0x1B80, 0x630E0885,
	0x1B80, 0x630E0887,
	0x1B80, 0xE1060895,
	0x1B80, 0xE1060897,
	0x1B80, 0xE15A08A5,
	0x1B80, 0xE15A08A7,
	0x1B80, 0x4D3008B5,
	0x1B80, 0x4D3008B7,
	0x1B80, 0x550108C5,
	0x1B80, 0x550108C7,
	0x1B80, 0x570408D5,
	0x1B80, 0x570408D7,
	0x1B80, 0x570008E5,
	0x1B80, 0x570008E7,
	0x1B80, 0x960008F5,
	0x1B80, 0x960008F7,
	0x1B80, 0x57080905,
	0x1B80, 0x57080907,
	0x1B80, 0x57000915,
	0x1B80, 0x57000917,
	0x1B80, 0x95000925,
	0x1B80, 0x95000927,
	0x1B80, 0x4D000935,
	0x1B80, 0x4D000937,
	0x1B80, 0x6C070945,
	0x1B80, 0x6C070947,
	0x1B80, 0x7B200955,
	0x1B80, 0x7B200957,
	0x1B80, 0x7A000965,
	0x1B80, 0x7A000967,
	0x1B80, 0x79000975,
	0x1B80, 0x79000977,
	0x1B80, 0x7F200985,
	0x1B80, 0x7F200987,
	0x1B80, 0x7E000995,
	0x1B80, 0x7E000997,
	0x1B80, 0x7D0009A5,
	0x1B80, 0x7D0009A7,
	0x1B80, 0x000109B5,
	0x1B80, 0x000109B7,
	0x1B80, 0x628509C5,
	0x1B80, 0x628509C7,
	0x1B80, 0xE10609D5,
	0x1B80, 0xE10609D7,
	0x1B80, 0xE13409E5,
	0x1B80, 0xE13409E7,
	0x1B80, 0x000109F5,
	0x1B80, 0x000109F7,
	0x1B80, 0x5C320A05,
	0x1B80, 0x5C320A07,
	0x1B80, 0x63FC0A15,
	0x1B80, 0x63FC0A17,
	0x1B80, 0x62850A25,
	0x1B80, 0x62850A27,
	0x1B80, 0xE1060A35,
	0x1B80, 0xE1060A37,
	0x1B80, 0x30CC0A45,
	0x1B80, 0x30CC0A47,
	0x1B80, 0x00230A55,
	0x1B80, 0x00230A57,
	0x1B80, 0xE15F0A65,
	0x1B80, 0xE15F0A67,
	0x1B80, 0x00020A75,
	0x1B80, 0x00020A77,
	0x1B80, 0x54E90A85,
	0x1B80, 0x54E90A87,
	0x1B80, 0x0BA60A95,
	0x1B80, 0x0BA60A97,
	0x1B80, 0x00230AA5,
	0x1B80, 0x00230AA7,
	0x1B80, 0xE15F0AB5,
	0x1B80, 0xE15F0AB7,
	0x1B80, 0x00020AC5,
	0x1B80, 0x00020AC7,
	0x1B80, 0x4D100AD5,
	0x1B80, 0x4D100AD7,
	0x1B80, 0x308C0AE5,
	0x1B80, 0x308C0AE7,
	0x1B80, 0x30C40AF5,
	0x1B80, 0x30C40AF7,
	0x1B80, 0x00220B05,
	0x1B80, 0x00220B07,
	0x1B80, 0xE15F0B15,
	0x1B80, 0xE15F0B17,
	0x1B80, 0x00020B25,
	0x1B80, 0x00020B27,
	0x1B80, 0x54E80B35,
	0x1B80, 0x54E80B37,
	0x1B80, 0x0BA60B45,
	0x1B80, 0x0BA60B47,
	0x1B80, 0x00220B55,
	0x1B80, 0x00220B57,
	0x1B80, 0xE15F0B65,
	0x1B80, 0xE15F0B67,
	0x1B80, 0x00020B75,
	0x1B80, 0x00020B77,
	0x1B80, 0x4D100B85,
	0x1B80, 0x4D100B87,
	0x1B80, 0x308C0B95,
	0x1B80, 0x308C0B97,
	0x1B80, 0x5C320BA5,
	0x1B80, 0x5C320BA7,
	0x1B80, 0x63F40BB5,
	0x1B80, 0x63F40BB7,
	0x1B80, 0x62850BC5,
	0x1B80, 0x62850BC7,
	0x1B80, 0xE1060BD5,
	0x1B80, 0xE1060BD7,
	0x1B80, 0x67F10BE5,
	0x1B80, 0x67F10BE7,
	0x1B80, 0xE1340BF5,
	0x1B80, 0xE1340BF7,
	0x1B80, 0xE15F0C05,
	0x1B80, 0xE15F0C07,
	0x1B80, 0x67F40C15,
	0x1B80, 0x67F40C17,
	0x1B80, 0xE1340C25,
	0x1B80, 0xE1340C27,
	0x1B80, 0xE15F0C35,
	0x1B80, 0xE15F0C37,
	0x1B80, 0x5C320C45,
	0x1B80, 0x5C320C47,
	0x1B80, 0x63FC0C55,
	0x1B80, 0x63FC0C57,
	0x1B80, 0x62850C65,
	0x1B80, 0x62850C67,
	0x1B80, 0xE1060C75,
	0x1B80, 0xE1060C77,
	0x1B80, 0x0BA80C85,
	0x1B80, 0x0BA80C87,
	0x1B80, 0x67F80C95,
	0x1B80, 0x67F80C97,
	0x1B80, 0xE1340CA5,
	0x1B80, 0xE1340CA7,
	0x1B80, 0xE15F0CB5,
	0x1B80, 0xE15F0CB7,
	0x1B80, 0x0BA90CC5,
	0x1B80, 0x0BA90CC7,
	0x1B80, 0x67FC0CD5,
	0x1B80, 0x67FC0CD7,
	0x1B80, 0xE1340CE5,
	0x1B80, 0xE1340CE7,
	0x1B80, 0xE15F0CF5,
	0x1B80, 0xE15F0CF7,
	0x1B80, 0x67FF0D05,
	0x1B80, 0x67FF0D07,
	0x1B80, 0xE1340D15,
	0x1B80, 0xE1340D17,
	0x1B80, 0xE15F0D25,
	0x1B80, 0xE15F0D27,
	0x1B80, 0x5C320D35,
	0x1B80, 0x5C320D37,
	0x1B80, 0x63030D45,
	0x1B80, 0x63030D47,
	0x1B80, 0xE1060D55,
	0x1B80, 0xE1060D57,
	0x1B80, 0x67000D65,
	0x1B80, 0x67000D67,
	0x1B80, 0xE1340D75,
	0x1B80, 0xE1340D77,
	0x1B80, 0xE15F0D85,
	0x1B80, 0xE15F0D87,
	0x1B80, 0x67030D95,
	0x1B80, 0x67030D97,
	0x1B80, 0xE1340DA5,
	0x1B80, 0xE1340DA7,
	0x1B80, 0xE15F0DB5,
	0x1B80, 0xE15F0DB7,
	0x1B80, 0xF6C90DC5,
	0x1B80, 0xF6C90DC7,
	0x1B80, 0x67070DD5,
	0x1B80, 0x67070DD7,
	0x1B80, 0xE1340DE5,
	0x1B80, 0xE1340DE7,
	0x1B80, 0xE15F0DF5,
	0x1B80, 0xE15F0DF7,
	0x1B80, 0xF7D00E05,
	0x1B80, 0xF7D00E07,
	0x1B80, 0x5C320E15,
	0x1B80, 0x5C320E17,
	0x1B80, 0x630B0E25,
	0x1B80, 0x630B0E27,
	0x1B80, 0xE1060E35,
	0x1B80, 0xE1060E37,
	0x1B80, 0x670B0E45,
	0x1B80, 0x670B0E47,
	0x1B80, 0xE1340E55,
	0x1B80, 0xE1340E57,
	0x1B80, 0xE15F0E65,
	0x1B80, 0xE15F0E67,
	0x1B80, 0x670E0E75,
	0x1B80, 0x670E0E77,
	0x1B80, 0xE1340E85,
	0x1B80, 0xE1340E87,
	0x1B80, 0xE15F0E95,
	0x1B80, 0xE15F0E97,
	0x1B80, 0x4D100EA5,
	0x1B80, 0x4D100EA7,
	0x1B80, 0x308C0EB5,
	0x1B80, 0x308C0EB7,
	0x1B80, 0x00010EC5,
	0x1B80, 0x00010EC7,
	0x1B80, 0x62850ED5,
	0x1B80, 0x62850ED7,
	0x1B80, 0xE1060EE5,
	0x1B80, 0xE1060EE7,
	0x1B80, 0x00010EF5,
	0x1B80, 0x00010EF7,
	0x1B80, 0xE1340F05,
	0x1B80, 0xE1340F07,
	0x1B80, 0x00010F15,
	0x1B80, 0x00010F17,
	0x1B80, 0x7B240F25,
	0x1B80, 0x7B240F27,
	0x1B80, 0x7A400F35,
	0x1B80, 0x7A400F37,
	0x1B80, 0x79000F45,
	0x1B80, 0x79000F47,
	0x1B80, 0x55030F55,
	0x1B80, 0x55030F57,
	0x1B80, 0x30FE0F65,
	0x1B80, 0x30FE0F67,
	0x1B80, 0x7B1C0F75,
	0x1B80, 0x7B1C0F77,
	0x1B80, 0x7A400F85,
	0x1B80, 0x7A400F87,
	0x1B80, 0x550B0F95,
	0x1B80, 0x550B0F97,
	0x1B80, 0x30FE0FA5,
	0x1B80, 0x30FE0FA7,
	0x1B80, 0x7B200FB5,
	0x1B80, 0x7B200FB7,
	0x1B80, 0x7A000FC5,
	0x1B80, 0x7A000FC7,
	0x1B80, 0x55130FD5,
	0x1B80, 0x55130FD7,
	0x1B80, 0x74010FE5,
	0x1B80, 0x74010FE7,
	0x1B80, 0x74000FF5,
	0x1B80, 0x74000FF7,
	0x1B80, 0x8E001005,
	0x1B80, 0x8E001007,
	0x1B80, 0x00011015,
	0x1B80, 0x00011017,
	0x1B80, 0x57021025,
	0x1B80, 0x57021027,
	0x1B80, 0x57001035,
	0x1B80, 0x57001037,
	0x1B80, 0x97001045,
	0x1B80, 0x97001047,
	0x1B80, 0x00011055,
	0x1B80, 0x00011057,
	0x1B80, 0x4F781065,
	0x1B80, 0x4F781067,
	0x1B80, 0x53881075,
	0x1B80, 0x53881077,
	0x1B80, 0xE1141085,
	0x1B80, 0xE1141087,
	0x1B80, 0x54801095,
	0x1B80, 0x54801097,
	0x1B80, 0x540010A5,
	0x1B80, 0x540010A7,
	0x1B80, 0xE11410B5,
	0x1B80, 0xE11410B7,
	0x1B80, 0x548110C5,
	0x1B80, 0x548110C7,
	0x1B80, 0x540010D5,
	0x1B80, 0x540010D7,
	0x1B80, 0xE11410E5,
	0x1B80, 0xE11410E7,
	0x1B80, 0x548210F5,
	0x1B80, 0x548210F7,
	0x1B80, 0x54001105,
	0x1B80, 0x54001107,
	0x1B80, 0xE11F1115,
	0x1B80, 0xE11F1117,
	0x1B80, 0xBF1D1125,
	0x1B80, 0xBF1D1127,
	0x1B80, 0x301D1135,
	0x1B80, 0x301D1137,
	0x1B80, 0xE0F21145,
	0x1B80, 0xE0F21147,
	0x1B80, 0xE0F71155,
	0x1B80, 0xE0F71157,
	0x1B80, 0xE0FB1165,
	0x1B80, 0xE0FB1167,
	0x1B80, 0xE1021175,
	0x1B80, 0xE1021177,
	0x1B80, 0xE1561185,
	0x1B80, 0xE1561187,
	0x1B80, 0x55131195,
	0x1B80, 0x55131197,
	0x1B80, 0xE0FE11A5,
	0x1B80, 0xE0FE11A7,
	0x1B80, 0x551511B5,
	0x1B80, 0x551511B7,
	0x1B80, 0xE10211C5,
	0x1B80, 0xE10211C7,
	0x1B80, 0xE15611D5,
	0x1B80, 0xE15611D7,
	0x1B80, 0x000111E5,
	0x1B80, 0x000111E7,
	0x1B80, 0x54BF11F5,
	0x1B80, 0x54BF11F7,
	0x1B80, 0x54C01205,
	0x1B80, 0x54C01207,
	0x1B80, 0x54A31215,
	0x1B80, 0x54A31217,
	0x1B80, 0x54C11225,
	0x1B80, 0x54C11227,
	0x1B80, 0x54A41235,
	0x1B80, 0x54A41237,
	0x1B80, 0x4C181245,
	0x1B80, 0x4C181247,
	0x1B80, 0xBF071255,
	0x1B80, 0xBF071257,
	0x1B80, 0x54C21265,
	0x1B80, 0x54C21267,
	0x1B80, 0x54A41275,
	0x1B80, 0x54A41277,
	0x1B80, 0xBF041285,
	0x1B80, 0xBF041287,
	0x1B80, 0x54C11295,
	0x1B80, 0x54C11297,
	0x1B80, 0x54A312A5,
	0x1B80, 0x54A312A7,
	0x1B80, 0xBF0112B5,
	0x1B80, 0xBF0112B7,
	0x1B80, 0xE16412C5,
	0x1B80, 0xE16412C7,
	0x1B80, 0x54DF12D5,
	0x1B80, 0x54DF12D7,
	0x1B80, 0x000112E5,
	0x1B80, 0x000112E7,
	0x1B80, 0x54BF12F5,
	0x1B80, 0x54BF12F7,
	0x1B80, 0x54E51305,
	0x1B80, 0x54E51307,
	0x1B80, 0x050A1315,
	0x1B80, 0x050A1317,
	0x1B80, 0x54DF1325,
	0x1B80, 0x54DF1327,
	0x1B80, 0x00011335,
	0x1B80, 0x00011337,
	0x1B80, 0x7F201345,
	0x1B80, 0x7F201347,
	0x1B80, 0x7E001355,
	0x1B80, 0x7E001357,
	0x1B80, 0x7D001365,
	0x1B80, 0x7D001367,
	0x1B80, 0x55011375,
	0x1B80, 0x55011377,
	0x1B80, 0x5C311385,
	0x1B80, 0x5C311387,
	0x1B80, 0xE0FE1395,
	0x1B80, 0xE0FE1397,
	0x1B80, 0xE10213A5,
	0x1B80, 0xE10213A7,
	0x1B80, 0x548013B5,
	0x1B80, 0x548013B7,
	0x1B80, 0x540013C5,
	0x1B80, 0x540013C7,
	0x1B80, 0xE0FE13D5,
	0x1B80, 0xE0FE13D7,
	0x1B80, 0xE10213E5,
	0x1B80, 0xE10213E7,
	0x1B80, 0x548113F5,
	0x1B80, 0x548113F7,
	0x1B80, 0x54001405,
	0x1B80, 0x54001407,
	0x1B80, 0xE0FE1415,
	0x1B80, 0xE0FE1417,
	0x1B80, 0xE1021425,
	0x1B80, 0xE1021427,
	0x1B80, 0x54821435,
	0x1B80, 0x54821437,
	0x1B80, 0x54001445,
	0x1B80, 0x54001447,
	0x1B80, 0xE11F1455,
	0x1B80, 0xE11F1457,
	0x1B80, 0xBFE91465,
	0x1B80, 0xBFE91467,
	0x1B80, 0x301D1475,
	0x1B80, 0x301D1477,
	0x1B80, 0x00231485,
	0x1B80, 0x00231487,
	0x1B80, 0x7B201495,
	0x1B80, 0x7B201497,
	0x1B80, 0x7A0014A5,
	0x1B80, 0x7A0014A7,
	0x1B80, 0x790014B5,
	0x1B80, 0x790014B7,
	0x1B80, 0xE15A14C5,
	0x1B80, 0xE15A14C7,
	0x1B80, 0x000214D5,
	0x1B80, 0x000214D7,
	0x1B80, 0x000114E5,
	0x1B80, 0x000114E7,
	0x1B80, 0x002214F5,
	0x1B80, 0x002214F7,
	0x1B80, 0x7B201505,
	0x1B80, 0x7B201507,
	0x1B80, 0x7A001515,
	0x1B80, 0x7A001517,
	0x1B80, 0x79001525,
	0x1B80, 0x79001527,
	0x1B80, 0xE15A1535,
	0x1B80, 0xE15A1537,
	0x1B80, 0x00021545,
	0x1B80, 0x00021547,
	0x1B80, 0x00011555,
	0x1B80, 0x00011557,
	0x1B80, 0x549F1565,
	0x1B80, 0x549F1567,
	0x1B80, 0x54FF1575,
	0x1B80, 0x54FF1577,
	0x1B80, 0x54001585,
	0x1B80, 0x54001587,
	0x1B80, 0x00011595,
	0x1B80, 0x00011597,
	0x1B80, 0x5C3115A5,
	0x1B80, 0x5C3115A7,
	0x1B80, 0x071415B5,
	0x1B80, 0x071415B7,
	0x1B80, 0x540015C5,
	0x1B80, 0x540015C7,
	0x1B80, 0x5C3215D5,
	0x1B80, 0x5C3215D7,
	0x1B80, 0x000115E5,
	0x1B80, 0x000115E7,
	0x1B80, 0x5C3215F5,
	0x1B80, 0x5C3215F7,
	0x1B80, 0x07141605,
	0x1B80, 0x07141607,
	0x1B80, 0x54001615,
	0x1B80, 0x54001617,
	0x1B80, 0x5C311625,
	0x1B80, 0x5C311627,
	0x1B80, 0x00011635,
	0x1B80, 0x00011637,
	0x1B80, 0x4C981645,
	0x1B80, 0x4C981647,
	0x1B80, 0x4C181655,
	0x1B80, 0x4C181657,
	0x1B80, 0x00011665,
	0x1B80, 0x00011667,
	0x1B80, 0x5C321675,
	0x1B80, 0x5C321677,
	0x1B80, 0x62841685,
	0x1B80, 0x62841687,
	0x1B80, 0x66861695,
	0x1B80, 0x66861697,
	0x1B80, 0x6C0316A5,
	0x1B80, 0x6C0316A7,
	0x1B80, 0x7B2016B5,
	0x1B80, 0x7B2016B7,
	0x1B80, 0x7A0016C5,
	0x1B80, 0x7A0016C7,
	0x1B80, 0x790016D5,
	0x1B80, 0x790016D7,
	0x1B80, 0x7F2016E5,
	0x1B80, 0x7F2016E7,
	0x1B80, 0x7E0016F5,
	0x1B80, 0x7E0016F7,
	0x1B80, 0x7D001705,
	0x1B80, 0x7D001707,
	0x1B80, 0x09011715,
	0x1B80, 0x09011717,
	0x1B80, 0x0C011725,
	0x1B80, 0x0C011727,
	0x1B80, 0x0BA61735,
	0x1B80, 0x0BA61737,
	0x1B80, 0x00011745,
	0x1B80, 0x00011747,
	0x1B80, 0x00000006,
	0x1B80, 0x00000002,

};

void
odm_read_and_config_tc_8821c_phy_reg(
	struct PHY_DM_STRUCT  *p_dm_odm
)
{
	u32     i         = 0;
	u8     c_cond;
	boolean is_matched = true, is_skipped = false;
	u32     array_len    = sizeof(array_tc_8821c_phy_reg) / sizeof(u32);
	u32    *array       = array_tc_8821c_phy_reg;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> odm_read_and_config_tc_8821c_phy_reg\n"));

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT30)) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  = (u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ELSE\n"));
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (is_skipped == false) {
					if (check_positive(p_dm_odm, pre_v1, pre_v2, v1, v2)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else
					is_matched = false;
			}
		} else {
			if (is_matched)
				odm_config_bb_phy_8821c(p_dm_odm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_tc_8821c_phy_reg(void)
{
	return 9;
}

/******************************************************************************
*                           PHY_REG_PG.TXT
******************************************************************************/

u32 array_tc_8821c_phy_reg_pg[] = {
	0, 0, 0, 0x00000c20, 0xffffffff, 0x34363840,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x42424444,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x30323638,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x40424444,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x28303236,
	0, 0, 1, 0x00000c34, 0xffffffff, 0x38404242,
	0, 0, 1, 0x00000c38, 0xffffffff, 0x26283034,
	0, 0, 2, 0x00000cd8, 0xffffffff, 0x36384040,
	0, 0, 2, 0x00000cdc, 0xffffffff, 0x24262832,
	0, 0, 0, 0x00000c3c, 0xffffffff, 0x40424444,
	0, 0, 0, 0x00000c40, 0xffffffff, 0x28303236,
	0, 0, 0, 0x00000c44, 0xffffffff, 0x42422426,
	0, 0, 1, 0x00000c48, 0xffffffff, 0x30343840,
	0, 0, 1, 0x00000c4c, 0xffffffff, 0x22242628,
	0, 0, 2, 0x00000ce0, 0xffffffff, 0x36384040,
	0, 0, 2, 0x00000ce4, 0xffffffff, 0x24262832,
	0, 0, 2, 0x00000ce8, 0x0000ffff, 0x20202022,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x42424444,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x30323640,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x40424444,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x28303236,
	1, 0, 1, 0x00000c34, 0xffffffff, 0x38404242,
	1, 0, 1, 0x00000c38, 0xffffffff, 0x26283034,
	1, 0, 2, 0x00000cd8, 0xffffffff, 0x36384040,
	1, 0, 2, 0x00000cdc, 0xffffffff, 0x24262832,
	1, 0, 0, 0x00000c3c, 0xffffffff, 0x40424444,
	1, 0, 0, 0x00000c40, 0xffffffff, 0x28303236,
	1, 0, 0, 0x00000c44, 0xffffffff, 0x42422426,
	1, 0, 1, 0x00000c48, 0xffffffff, 0x30343840,
	1, 0, 1, 0x00000c4c, 0xffffffff, 0x22242628,
	1, 0, 2, 0x00000ce0, 0xffffffff, 0x36384040,
	1, 0, 2, 0x00000ce4, 0xffffffff, 0x24262832,
	1, 0, 2, 0x00000ce8, 0x0000ffff, 0x20202022
};

void
odm_read_and_config_tc_8821c_phy_reg_pg(
	struct PHY_DM_STRUCT  *p_dm_odm
)
{
	u32     i         = 0;
	u32     array_len    = sizeof(array_tc_8821c_phy_reg_pg) / sizeof(u32);
	u32    *array       = array_tc_8821c_phy_reg_pg;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	struct _ADAPTER		*adapter = p_dm_odm->adapter;
	HAL_DATA_TYPE	*p_hal_data = GET_HAL_DATA(adapter);

	PlatformZeroMemory(p_hal_data->BufOfLinesPwrByRate, MAX_LINES_HWCONFIG_TXT * MAX_BYTES_LINE_HWCONFIG_TXT);
	p_hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> odm_read_and_config_tc_8821c_phy_reg_pg\n"));

	p_dm_odm->phy_reg_pg_version = 1;
	p_dm_odm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32 v1 = array[i];
		u32 v2 = array[i + 1];
		u32 v3 = array[i + 2];
		u32 v4 = array[i + 3];
		u32 v5 = array[i + 4];
		u32 v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8821c(p_dm_odm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)p_hal_data->BufOfLinesPwrByRate[i / 6], 100, "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
			(v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"), (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
}



#endif /* end of HWIMG_SUPPORT*/
