/*
	QMPlay2 is a video and audio player.
	Copyright (C) 2010-2016  Błażej Szczygieł

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published
	by the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <SubsDec.hpp>
#include <QMPlay2Core.hpp>
#include <Module.hpp>

SubsDec *SubsDec::create(const QString &type)
{
	if (type.isEmpty())
		return NULL;
	foreach (Module *module, QMPlay2Core.getPluginsInstance())
		foreach (const Module::Info &mod, module->getModulesInfo())
			if (mod.type == Module::SUBSDEC && mod.extensions.contains(type))
			{
				SubsDec *subsdec = (SubsDec *)module->createInstance(mod.name);
				if (!subsdec)
					continue;
				return subsdec;
			}
	return NULL;
}
QStringList SubsDec::extensions()
{
	QStringList extensions;
	foreach (const Module *module, QMPlay2Core.getPluginsInstance())
		foreach (const Module::Info &mod, module->getModulesInfo())
			if (mod.type == Module::SUBSDEC)
				extensions << mod.extensions;
	return extensions;
}

SubsDec::~SubsDec()
{}
