/*
	QMPlay2 is a video and audio player.
	Copyright (C) 2010-2016  Błażej Szczygieł

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published
	by the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef OPENGLWIDGET_HPP
#define OPENGLWIDGET_HPP

#include <OpenGL2CommonQt5.hpp>

#include <QOpenGLWindow>
#include <QWidget>

#if defined Q_OS_MAC || defined Q_OS_WIN //QTBUG-50505
	#define PASS_EVENTS_TO_PARENT
#endif

class OpenGL2Window : private QOpenGLWindow, public OpenGL2CommonQt5
{
	Q_OBJECT
public:
	OpenGL2Window();

	void deleteMe();

	QWidget *widget();

	bool setVSync(bool enable);
	void updateGL(bool requestDelayed);

	void initializeGL();
	void paintGL();

private slots:
	void doUpdateGL(bool queued = false);
	void videoVisible1(bool v);
	void videoVisible2(bool v);
private:
	bool eventFilter(QObject *o, QEvent *e);

#ifdef PASS_EVENTS_TO_PARENT
	bool event(QEvent *e);
#endif

	QWidget *container;
	bool visible;
};

#endif // OPENGLWIDGET_HPP
