/* -*- indent-tabs-mode: nil; js-indent-level: 2 -*- */
/* Any copyright is dedicated to the Public Domain.
 * http://creativecommons.org/publicdomain/zero/1.0/ */

/**
 * Tests that the function searching works with pretty printed sources.
 */

const TAB_URL = EXAMPLE_URL + "doc_pretty-print.html";

function test() {
  // Wait for debugger panel to be fully set and break on debugger statement
  let options = {
    source: EXAMPLE_URL + "code_ugly.js",
    line: 2
  };
  initDebugger(TAB_URL, options).then(([aTab,, aPanel]) => {
    const gTab = aTab;
    const gPanel = aPanel;
    const gDebugger = gPanel.panelWin;
    const gSearchBox = gDebugger.DebuggerView.Filtering._searchbox;

    Task.spawn(function* () {
      let popupShown = promise.defer();
      once(gDebugger, "popupshown").then(() => {
        ok(isCaretPos(gPanel, 2, 10),
           "The bar function's non-pretty-printed location should be shown.");
        popupShown.resolve();
      });
      setText(gSearchBox, "@bar");
      yield popupShown.promise;

      const finished = waitForSourceShown(gPanel, "code_ugly.js");
      gDebugger.document.getElementById("pretty-print").click();
      yield finished;

      popupShown = promise.defer();
      once(gDebugger, "popupshown").then(() => {
        ok(isCaretPos(gPanel, 6, 10),
           "The bar function's pretty printed location should be shown.");
        popupShown.resolve();
      });
      setText(gSearchBox, "@bar");
      yield popupShown.promise;

      resumeDebuggerThenCloseAndFinish(gPanel);
    });
  });
}
