#!/bin/sh
#Variables
HEADERGUARD="IMAGES_BIN2C"
FILENAME="bitmaps"
IFS=$(echo -en "\n\b")
SAVEIFS=$IFS

cc -c bin2c.c
cc -o bin2c bin2c.c

rm -f bin2c.o
rm -f *.htemp
rm -f $FILENAME.cpp

# Header file
for file in *.png ; do 
	#echo ./bin2c $file ${file%.*}.htemp
	./bin2c $file ${file%.*}.htemp
done
rm -f /_$FILENAME.htemp
rm -f $FILENAME.h
echo // >> _$FILENAME.htemp
echo // File Autogenerated by SaltyPaw\'s  PNG conversion script>> _$FILENAME.htemp
echo // >> _$FILENAME.htemp
echo // >> _$FILENAME.htemp

echo \#ifndef \_$HEADERGUARD\_H\_ >> _$FILENAME.htemp
echo \#define \_$HEADERGUARD\_H\_ >> _$FILENAME.htemp

echo \#include '<wx/wxprec.h>' >> _$FILENAME.htemp
echo \#ifndef WX_PRECOMP >> _$FILENAME.htemp
echo \#	include '<wx/wx.h>' >> _$FILENAME.htemp
echo \#endif >> _$FILENAME.htemp
echo \#include '<wx/mstream.h>' >> _$FILENAME.htemp
echo // >> _$FILENAME.htemp
echo 'extern void initialize_bitmaps(void);' >> _$FILENAME.htemp
echo // >> _$FILENAME.htemp
for file in *.png ; do 
	#echo ./bin2c $file ${file%.*}.htemp
	echo extern wxBitmap '*_img_'${file%.*}';' >> _$FILENAME.htemp
done

#cat *.htemp >> $FILENAME.h
mv \_$FILENAME.htemp $FILENAME.h


echo // >> $FILENAME.h
echo \#endif // \_$HEADERGUARD\_H\_ >> $FILENAME.h
IFS=$SAVEIFS





#C++ File
echo // >> $FILENAME.cpp
echo // File Autogenerated by SaltyPaw\'s  PNG conversion script>> $FILENAME.cpp
echo // >> $FILENAME.cpp
echo // >> $FILENAME.cpp


echo \#include '"'$FILENAME.h'"' >> $FILENAME.cpp
echo // >> $FILENAME.cpp

for file in *.png ; do 
	#echo ./bin2c $file ${file%.*}.htemp
	echo wxBitmap '*_img_'${file%.*}';' >> $FILENAME.cpp
done
echo // >> $FILENAME.cpp

echo 'void initialize_bitmaps(void)' >> $FILENAME.cpp
echo '{' >> $FILENAME.cpp


for file in *.png ; do 
	echo '	{' >> $FILENAME.cpp
	#echo 'INSERT!!!!!!!!!!!!!!!!!!!!!!!!!!!11' >> $FILENAME.cpp
	cat ${file%.*}.htemp >> $FILENAME.cpp
	echo '	wxMemoryInputStream sm('${file%.*}'_png, sizeof('${file%.*}'_png));' >> $FILENAME.cpp
	echo '	_img_'${file%.*}' = new wxBitmap(wxImage(sm));' >> $FILENAME.cpp
	echo '	}' >> $FILENAME.cpp
done


echo '	return;' >> $FILENAME.cpp
echo '}' >> $FILENAME.cpp

cp $FILENAME.cpp ..
cp $FILENAME.h ..

rm *.htemp
rm $FILENAME.cpp
rm $FILENAME.h
rm bin2c

