/**************************************************************************
 * 
 * Project:  OpenCPN
 * Purpose:  HyperLink Support
 * Author:   Jon Gough
 *
 ***************************************************************************
 *   Copyright (C) 2010 by David S. Register                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,  USA.         *
 **************************************************************************/

#ifndef __ODLinkPropertiesDialogImpl__
#define __ODLinkPropertiesDialogImpl__

/**
@file
Subclass of ODLinkPropertiesDialogDef, which is generated by wxFormBuilder.
*/

#include "ODLinkPropertiesDialogDef.h"

//// end generated include

#include "ODPoint.h"

/** Implementing ODLinkPropertiesDialogDef */
class ODLinkPropertiesDialogImpl : public ODLinkPropertiesDialogDef
{
	public:
		/** Constructor */
		ODLinkPropertiesDialogImpl( wxWindow* parent );
	//// end generated class members
        
        void SetODPoint(ODPoint *pODPoint);
        void AddURL(void);
        wxString GetLinkDescription(void) {return m_textCtrlLinkDescription->GetValue();}
        wxString GetLinkURL(void) {return m_textCtrlURL->GetValue();}
        void SetLinkDescription(wxString lDesc);
        void SetLinkURL(wxString lURL);
        void OnFileChanged( wxFileDirPickerEvent& event );
        
    protected:
        void OnOKClick( wxCommandEvent& event );
        void OnCancelClick( wxCommandEvent& event );
    
    private:
        ODPoint     *m_pODPoint;

};

#endif // __ODLinkPropertiesDialogImpl__
