/***************************************************************************
 *
 * Project:  OpenCPN
 * Purpose:  OCPN Draw Parallel Index Line Properties Dialog support
 * Author:   Jon Gough
 *
 ***************************************************************************
 *   Copyright (C) 2010 by David S. Register                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,  USA.         *
 **************************************************************************/

#ifndef __PILPropertiesDialogImpl__
#define __PILPropertiesDialogImpl__

/**
@file
Subclass of PILPropertiesDialog, which is generated by wxFormBuilder.
*/

#include "PILPropertiesDialogDef.h"

class PIL;

/** Implementing ODPointPropertiesDialog */
class PILPropertiesDialogImpl : public PILPropertiesDialogDef
{
    public:
        /** Constructor */
        PILPropertiesDialogImpl( wxWindow* parent );
        virtual ~PILPropertiesDialogImpl();
        void SaveChanges( void );
        void UpdateProperties( PIL *pPIL, int iID );

    protected:
        void OnRightClick( wxMouseEvent& event );
        void OnOK( wxCommandEvent& event );
        void OnCancel( wxCommandEvent& event );
        void OnClose( wxCloseEvent& event );

        PIL     *m_pPIL;
        int     m_iID;

    private:
        double  m_dPILOffsetValidator;

};
#endif // __PILPropertiesDialogImpl__