#!/usr/bin/perl -w

use strict;
use Spreadsheet::ParseExcel;

my @FunctionArray=('m_ShortDesc','m_LongDesc','m_Category','m_Units','m_Source','m_Formula','m_Result_Unit','m_Input_parameter','m_Input_unit','m_Input_parameter1','m_Input_unit1','m_Input_parameter2','m_Input_unit2','m_Input_parameter3','m_Input_unit3','m_Input_parameter4','m_Input_unit4','m_Input_parameter5','m_Input_unit5','m_Input_parameter6','m_Input_unit6','m_Input_parameter7','m_Input_unit7','m_Input_parameter8','m_Input_unit8','m_Input_parameter9','m_Input_unit9'
);

my @UnitArray=('test','m_blaat','m_etc');

my $header = q|

/* WARNING - DO NOT EDIT FILE - FILE IS AUTO GENERATED BY FUNCTIONS2CPP.PL*/

/***************************************************************************
 *
 * Project:  OpenCPN
 * Purpose:  ROUTE Plugin
 * Author:   SaltyPaws
 *
 ***************************************************************************
 *   Copyright (C) 2012 by Brazil BrokeTail                                *
 *   $EMAIL$                                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************
 */

#include "functions.h"

 CFormula::CFormula(void)
{
    this->Selected_Formula = 1;
|;

my $footer = q|
}
|;

my $filename='functions.cpp';
my $parser = Spreadsheet::ParseExcel->new();
my $workbook = $parser->parse('functions.xls');

my $empty_line="yes";
my $FunctionSheet="0";
my $FunctionRow="0";
#my $FunctionEndRow="0";
my $UnitSheet="0";
my $UnitRow="0";
#my $UnitEndRow="0";

my ( $row_min, $row_max ) = (1,1);
my ( $col_min, $col_max ) = (1,1);


open(my $fh, '>', "$filename");

if ( !defined $workbook ) {
	die $parser->error(), ".\n";
	}

#my $Startrow_found="No";
print $fh "$header\n";

#Look for starting rows
for my $worksheet ( $workbook->worksheets() ) {
print "Worksheet: ",$worksheet,"\n";
        ( $row_min, $row_max ) = $worksheet->row_range();
        ( $col_min, $col_max ) = $worksheet->col_range();

        for my $row ( $row_min .. $row_max ) {
            for my $col ( $col_min .. $col_max ) {

                my $cell = $worksheet->get_cell( $row, $col );
                next unless $cell;
		$a=$cell->unformatted();

		if ($a =~ /Start Functions --------------------------->/)
			{
			print "Found Functions Tab, starting on row: ",$row,"\n";
			$FunctionRow=$row+3;
			#$FunctionEndRow=$row_max;
			$FunctionSheet=$worksheet;
			print "FunctionSheet: ",$FunctionSheet,"\n";

			#$Startrow_found="yes";
			#last;
			}
		if ($a =~ /Start Units --------------------------->/)
			{
			print "Found Units Tab, starting on row: ",$row,"\n";
			$UnitRow=$row+3;
			$UnitSheet=$worksheet;

			#$Startrow_found="yes";
			#last;
			}
                #print "\n";
            }
        }
}

#Add Functions
print "adding function. FunctionRow: ", $FunctionRow, " Row Max: ",$row_max,"\n";
( $row_min, $row_max ) = $FunctionSheet->row_range();
( $col_min, $col_max ) = $FunctionSheet->col_range();
for my $row ( $FunctionRow .. $row_max )
	{
	for my $col ( $col_min .. $col_max )
		{
			print "Row, Col    = ($row, $col)\n";
		my $cell = $FunctionSheet->get_cell( $row, $col );
		#next unless $cell;
		if ($cell and $col==0) {$empty_line="no";} 
		if (!$cell and $col==0) {$empty_line="yes";print "Empty:"} 
		if ($cell)
			{
			print "Row, Col    = ($row, $col)\n";
			print "Value       = ", $cell->value(),       "\n";
			#print "Unformatted = ", $cell->unformatted(), "\n";
			$a=$cell->unformatted();
			$a=~ s/\R/\\n/g; #Re~ s/\R//g; #remove line feed, page feed, CR
			$a =~ s/[^\w @.:+-=\*()\^\/\\]//g;
			$a=~ s/ {3,}/\\t/g; #replace double space with single space
			$a=~ s/\t* {2}/ /g; #replace double space with single space
			}
		else
			{
				$a="";
			}

		if ($empty_line =~ /no/ and $col<@FunctionArray)
			{
			print $fh "this->$FunctionArray[$col].Add(_(\"$a\"))\;\n"; 
			print  "this->$FunctionArray[$col].Add(_(\"$a\"))\;\n"; 
			}    
	    	}
		$empty_line="yes"; 
		print $fh "\n";
	}

#Add units
( $row_min, $row_max ) = $UnitSheet->row_range();
( $col_min, $col_max ) = $UnitSheet->col_range();

for my $row ( $UnitRow .. $row_max )
	{
	for my $col ( $col_min .. $col_max )
		{
		my $cell = $UnitSheet->get_cell( $row, $col );
		#next unless $cell;
		if ($cell and $col==0) {$empty_line="no";} 
		if (!$cell and $col==0) {$empty_line="yes";print "Empty:"} 
		if ($cell)
			{
			#print "Row, Col    = ($row, $col)\n";
			#print "Value       = ", $cell->value(),       "\n";
			#print "Unformatted = ", $cell->unformatted(), "\n";
			$a=$cell->unformatted();
			$a=~ s/\R/\\n/g; #Re~ s/\R//g; #remove line feed, page feed, CR
			$a =~ s/[^\w @.:+-=\*()\^\/\\]//g;
			$a=~ s/ {3,}/\\t/g; #replace double space with single space
			$a=~ s/\t* {2}/ /g; #replace double space with single space
			}
		else
			{
				$a="";
			}

		if ($empty_line =~ /no/ and $col<@UnitArray)
			{
			print $fh "this->$UnitArray[$col].Add(_(\"$a\"))\;\n"; 
			print  "this->$UnitArray[$col].Add(_(\"$a\"))\;\n"; 
			}    
	    	}
		$empty_line="yes"; 
		print $fh "\n";
	}
		


print $fh "$footer\n";
close ($fh); 
