/*
 * Generated with the genpubsuffix tool.
 *  From file public_suffix_list.dat
 *  Converted on Tue Aug 21 21:53:07 2018
 */

/**
 * Public suffix list graph node
 */
union pnode {
    struct {
        unsigned int idx:24; /**< index of domain element in string table */
        unsigned int len:6; /**< length of domain element in string table */
        unsigned int children:1; /**< has children */
    } label;
    struct {
        uint16_t index; /**< index of first child node */
        uint16_t count; /**< number of children of this node */
    } child;
};

enum stab_entities {
    STAB_WILDCARD = 0,
    STAB_EXCEPTION = 11
};

/**
 * Huffman coding node
 */
struct hnode {
    uint8_t term:1; /**< non zero if the node terminates a code */
    uint8_t value:7; /**< value in node */
};

/**
 * Huffman decoding table
 *
 * nodes are in pairs even nodes are for 0bit odd for 1
 */
static const struct hnode htable[76] = {
    { 0, 2 },
    { 0, 54 },
    { 0, 4 },
    { 0, 42 },
    { 0, 6 },
    { 0, 18 },
    { 0, 8 },
    { 1, 't' }, /* 't': 0001 */
    { 0, 10 },
    { 1, 'g' }, /* 'g': 00001 */
    { 0, 12 },
    { 1, 'w' }, /* 'w': 000001 */
    { 0, 14 },
    { 0, 16 },
    { 1, '0' }, /* '0': 00000000 */
    { 1, '2' }, /* '2': 00000001 */
    { 1, '3' }, /* '3': 00000010 */
    { 1, 'q' }, /* 'q': 00000011 */
    { 0, 20 },
    { 0, 40 },
    { 0, 22 },
    { 1, 'c' }, /* 'c': 00101 */
    { 0, 24 },
    { 1, 'v' }, /* 'v': 001001 */
    { 0, 26 },
    { 0, 30 },
    { 0, 28 },
    { 1, '1' }, /* '1': 00100001 */
    { 1, '6' }, /* '6': 001000000 */
    { 1, '8' }, /* '8': 001000001 */
    { 0, 32 },
    { 0, 38 },
    { 0, 34 },
    { 1, '7' }, /* '7': 001000101 */
    { 0, 36 },
    { 1, '9' }, /* '9': 0010001001 */
    { 1, '!' }, /* '!': 00100010000 */
    { 1, '*' }, /* '*': 00100010001 */
    { 1, '5' }, /* '5': 001000110 */
    { 1, '4' }, /* '4': 001000111 */
    { 1, 'd' }, /* 'd': 00110 */
    { 1, 'h' }, /* 'h': 00111 */
    { 0, 44 },
    { 1, 'a' }, /* 'a': 011 */
    { 1, 'r' }, /* 'r': 0100 */
    { 0, 46 },
    { 0, 48 },
    { 0, 52 },
    { 1, 'f' }, /* 'f': 010100 */
    { 0, 50 },
    { 1, 'j' }, /* 'j': 0101010 */
    { 1, 'z' }, /* 'z': 0101011 */
    { 1, 'x' }, /* 'x': 010110 */
    { 1, 'p' }, /* 'p': 010111 */
    { 0, 56 },
    { 0, 64 },
    { 0, 58 },
    { 0, 62 },
    { 1, 's' }, /* 's': 1000 */
    { 0, 60 },
    { 1, 'k' }, /* 'k': 10010 */
    { 1, 'm' }, /* 'm': 10011 */
    { 1, 'o' }, /* 'o': 1010 */
    { 1, 'e' }, /* 'e': 1011 */
    { 0, 66 },
    { 0, 70 },
    { 1, 'n' }, /* 'n': 1100 */
    { 0, 68 },
    { 1, 'u' }, /* 'u': 11010 */
    { 1, 'l' }, /* 'l': 11011 */
    { 1, 'i' }, /* 'i': 1110 */
    { 0, 72 },
    { 0, 74 },
    { 1, '-' }, /* '-': 11111 */
    { 1, 'y' }, /* 'y': 111100 */
    { 1, 'b' }, /* 'b': 111101 */
};

/**
 * Domain label string table huffman encoded.
 * 6191 labels(359496 bits) reduced to 4346 labels(169632 bits)
 */
static const uint32_t stab[5301] = {
    0x36822444, 0xE912D3FF, 0xB1FDF8AB, 0x6BCAD377, 0x43E3BA8E, 0x3489014E,
    0xE04B27E5, 0x3D67C4F5, 0xBF1D8178, 0xA1E22BE7, 0x7C6057AD, 0xBBD8FB0F,
    0xE6BCE569, 0x426AF1A8, 0x7A51FF9B, 0xB07EA6F0, 0x3FB5278F, 0xC87B7A05,
    0x83DC9A93, 0x5A26B4DE, 0x04D5E348, 0x8DFB07D0, 0xFFD6FEC3, 0x076F2094,
    0xFA00C27E, 0xD871BF60, 0x5A8FFADF, 0x9F81DBC8, 0xD83E8030, 0xB7F61C6F,
    0xF216A3FE, 0xD407E076, 0x1E947FE6, 0x3EC1F9BC, 0xA2FED49E, 0x1FF9B57E,
    0xEA6F07A5, 0xDA93C307, 0x36AFD43F, 0xE0F4A3FF, 0x78FB054D, 0xFA8BFB52,
    0xB27FE6D5, 0x789EC325, 0xE06B8C5B, 0x9757C1D7, 0x6EA78D23, 0x6FC8DEDE,
    0xB6878962, 0xF4A3FF36, 0x860FCDE0, 0x513FB527, 0x7FE6D5F2, 0xA9BC1E94,
    0xFB527860, 0x6D5F2513, 0xC1E947FE, 0x4F1F609B, 0xE4027F6A, 0x64FFCDAB,
    0xF13D864B, 0x3E5B18B6, 0x1E94D7C5, 0x437FC1EB, 0xE341E076, 0x3FF368D5,
    0x04DE0F4A, 0x7FDA93C3, 0xFFE6D5E2, 0x3F3C3BD7, 0xFED49E18, 0xFF36AF13,
    0xE7876BBF, 0xDA93C307, 0xE6D5E27F, 0x309540FF, 0xD1DEE0EF, 0xD5F803F3,
    0xFD2CFFE6, 0x1CA97E0B, 0x0303FBCC, 0x4FFCDABF, 0xA014E537, 0x4202F00D,
    0x29091340, 0x03D11DD3, 0x8A23BE5B, 0x146AF19E, 0x93EFB5B9, 0x7F3EAD3D,
    0xB59F6B78, 0xDEF49FF9, 0x0577D9FD, 0x7AFE6FF6, 0x6BFF9C98, 0x8FE88DD9,
    0x930F39E2, 0xDCF147F3, 0x11BB2D7F, 0x23765AFD, 0xEE78A3FA, 0xB59C987B,
    0x752DFFF9, 0x27860FCF, 0xBD603FB5, 0xDFED46B9, 0xFEDEF59F, 0x6D479CAF,
    0x0F7DCF14, 0x2D7FF393, 0xE28D11BB, 0x765AFFB9, 0x987BFA23, 0xDFF9B59C,
    0xFC15224B, 0x57D87B7C, 0xFFCDABCD, 0x4D543B93, 0x1FD7CEAE, 0xFA00EBE9,
    0x57F1E9CA, 0x07E4587C, 0x5E13F03B, 0xC6E57F7C, 0x8CDBCF43, 0xE45128BC,
    0xF64FBED6, 0x6F0CFAB4, 0xB722B3ED, 0xAD3D91F6, 0x6B787F3E, 0x9AED699F,
    0xEF6F06F3, 0x09778E73, 0x5A7FE6D4, 0x7751CD79, 0x0180927C, 0xBC4B8C6B,
    0x3C9605F9, 0xACAF4579, 0xA04FFFCD, 0x4C7D8FF4, 0xABD52FFA, 0xD119FFCD,
    0xCA95149F, 0x2B5113F8, 0x120FFCDA, 0x7AC48217, 0x22F85413, 0x401C46C6,
    0x0E37EC1F, 0xEDF8AFFB, 0x40184FC0, 0x0E37EC1F, 0x60F8AFFB, 0x00C27E07,
    0x71BF60FA, 0x07C57FD8, 0x0603F03B, 0x8DFB07D0, 0x3EBDFEC3, 0x309F81D8,
    0x6FD83E80, 0xFF0FF61C, 0x7C27E076, 0xFF7BD22D, 0x029A7E52, 0x17D83377,
    0x896F5FDF, 0xDF146F1A, 0xB533C4B4, 0x5D9F3E0B, 0xD5E340A4, 0x3D63D298,
    0xB26975F8, 0x27C6AF07, 0x728AC51F, 0x941AD3F4, 0xDADC8ADA, 0xFAB4F647,
    0x33ED6F0C, 0xD4DE0F4A, 0x66FAC6F7, 0x07A51B07, 0x6AC7EA6F, 0xB6A4F1F6,
    0xDE93FF36, 0xB02BBFBB, 0x36AFBF7F, 0xBBDE93FF, 0x7FB02B99, 0xC987AFBF,
    0x46ECB5F9, 0x3CE78A34, 0x9E28CE4C, 0x11BB2D7B, 0xB4FFCDAD, 0x295FC7A3,
    0x57D33FD9, 0x9295FF9B, 0x8F4769FD, 0x145F42BF, 0x9C9879CF, 0x446ECB5F,
    0xB5EE78A3, 0x87B446EC, 0x3B3739C9, 0xC0BF0DF5, 0x3BCA0B92, 0x8096B8C6,
    0xB9413D8D, 0x9B47BD75, 0xA6C3C3FF, 0xBF3D5423, 0xFFCDABE0, 0xE4D4A72F,
    0x44FF1C2A, 0x0FFCDAD4, 0xE4BBC9A1, 0x7131F04F, 0xFF9B5CA2, 0xB4A2CE79,
    0xB883FD03, 0xA7FF36A9, 0xFA12ABDA, 0x8C4C7D13, 0xFFE6D728, 0xC9E2AA24,
    0x897E839F, 0xE6D2A913, 0x5A4F90FF, 0x43E5B03C, 0x3FF36AF8, 0x76AB1DA7,
    0x818FA27D, 0xFCDABD88, 0xA2DBE19F, 0x46313713, 0x428904DC, 0xF0CFFE6D,
    0x510FDE05, 0x4402600A, 0x16BE9795, 0xF94BFDE9, 0xCDDC0A69, 0xB7A6B760,
    0x595A7C60, 0x03BBBF47, 0x7E6F07A5, 0x4F1F66AC, 0xE0F4A36A, 0x2C6F7D4D,
    0xD28D83B3, 0x63F53783, 0xB5278FB1, 0xA6F07A51, 0x7866AC7E, 0x07A51B52,
    0xEB1BCA6F, 0x946C1D9B, 0x58A9BC1E, 0xD49E3ECD, 0xD27FE6D6, 0xB02BB77B,
    0x36B5137F, 0x1E8ED3FF, 0x1FFB252B, 0xBFF36B41, 0x4769B252, 0xE8253F8F,
    0xB376A35C, 0x9CAFDBDE, 0x216E6D47, 0xEEF6903B, 0x13578C57, 0x7B687AF4,
    0x815B0DD8, 0x1EBD04F2, 0x25C631DA, 0x368777BD, 0xF332BFFF, 0x33F61AC4,
    0xFE6D5341, 0x4DE2DB7F, 0x21FF74F2, 0x7FFE6D6E, 0x0AB93539, 0x5B883FC7,
    0xA785FF9B, 0xD6AA42D4, 0xA2B42007, 0x0DBBFFCD, 0x7F25DE4D, 0x36AF8062,
    0x246DE7FF, 0x7EF9E957, 0xFF36B710, 0x8F649333, 0x43FFA04A, 0x1FFCDADC,
    0xB0B1FD28, 0xABE9ABE7, 0x4C31FFCD, 0xFB0F6FFA, 0xE6D5F400, 0x1F5F0CFF,
    0xA4D62691, 0x29DE0001, 0x60760E41, 0xCB85E4CB, 0xEF64C51B, 0x2589B896,
    0x6D6FDA1E, 0x37581FB6, 0x2DE40A70, 0xE9FDF17D, 0xFEEE8F7A, 0x6EB64DB1,
    0xB377A1D8, 0x53EDEF5C, 0xD90B44B7, 0x4B60D6B4, 0x946A5CA0, 0xB1F9BC1E,
    0xDA93C7D8, 0xF3783D28, 0x93C33563, 0x783D28DA, 0xC3163F53, 0x3D28DA93,
    0x58DE5378, 0xA51B0766, 0x162A6F07, 0x1B5278FB, 0x2A6F07A5, 0xA93C3356,
    0x3783D28D, 0x3C7D9AB1, 0x56D6FDA9, 0x637BEA7B, 0x6A6C1D99, 0xFFCE6B79,
    0xC738EEE0, 0x8E71DDC1, 0xCD6F2D4F, 0xF0741F99, 0xC158C6CB, 0x605F9B2F,
    0x28EF51C9, 0x18CF8D7A, 0x2C0BF097, 0x23BCA0B9, 0xF6D0F5E8, 0x25817E30,
    0x54EEF60F, 0x64B9AF39, 0xFE6D1ABC, 0x3EE7B26F, 0x0801B000, 0x9FF9B5A1,
    0xD02B7EC3, 0x6B2043EC, 0x16127FF3, 0x67ECC5BC, 0x7FE6D682, 0xA5F7FA52,
    0x5A089F96, 0x92F5FF9B, 0x1A07EB80, 0xCDA28090, 0x4BDF21FF, 0x04DFF798,
    0x64FFCDAD, 0xF9F09207, 0x694099A7, 0x2896BFF3, 0x2640DB20, 0xB5C00DD6,
    0xD7C33FF9, 0x10D5A447, 0xD2A02758, 0xDF0CFFE6, 0x89B89D16, 0x6D16E231,
    0x602A07FE, 0x26E48242, 0x01100FA8, 0xB13FF36B, 0x55C44058, 0x78110244,
    0xFE6D4061, 0x7C22697F, 0x26313489, 0xD0069C4D, 0x04A7FEB7, 0x13F03B79,
    0xFEB7D006, 0x3B7904A7, 0xD00603F0, 0x16A3FEB7, 0x27E076F2, 0xFD6FA00C,
    0xEDE42D47, 0x4AF80FC0, 0x5612D181, 0x496C9F1A, 0xD69FDF17, 0x3C690B44,
    0xBFBE2FB2, 0x8A0B0BCE, 0xF172DE75, 0x5B07BF3D, 0xF02D37D0, 0x4577AF90,
    0x1EC1AD0B, 0xFC8DEDE4, 0x2B4B4B53, 0xA63F3925, 0x93B36478, 0x78F258A6,
    0x3F3FDCEB, 0xEE9D63C0, 0x3F27CC5A, 0x7B7D9096, 0x75F3687B, 0x55F2D711,
    0x2B68F02B, 0x27DF6B72, 0xFB5BC3FB, 0x3783D28C, 0x93C3163F, 0x783D28DA,
    0xECDFDF53, 0xE0F4A360, 0x78F8FD4D, 0x07A51B52, 0xC3162A6F, 0x3D28DA93,
    0x7D8B1378, 0xD28DA93C, 0x9AB13783, 0xD7ED49E1, 0x563F3C3B, 0xFDA93C33,
    0x1F9E1DAE, 0xD49E19AB, 0xE6B796A6, 0x9C77707C, 0x38EEE0E3, 0x35BCB507,
    0xC1D07E67, 0x9389F82F, 0x0E83F341, 0x82A4FC7E, 0xE83F365F, 0xDF2B17E0,
    0x1F8FC153, 0xC6CBF074, 0x9DB38F58, 0x3C7A8E5B, 0xE3ABC078, 0xC07B0F15,
    0x77BD269B, 0x4B02FC3F, 0x5E82529E, 0xA2BCED0F, 0x7A5B2657, 0x31C0DE0E,
    0x72B78D5E, 0x631C96D2, 0xDE6F1ABC, 0x3AD86872, 0x5BD66DBF, 0x7B4B67E7,
    0x625A6B05, 0x182DB23C, 0x12AFFCDA, 0x7D87B7BD, 0xCDADC462, 0xCC3559FF,
    0x2013E7BB, 0xDFFE6D6E, 0x5AA66DE6, 0x6D63E89F, 0x14317FFE, 0x44FB0955,
    0xFFCDADAA, 0x48EB36F0, 0x6B0043FB, 0x0F127FF3, 0x0BFFA9E4, 0xE7FE6D60,
    0xC6B0F6CF, 0xB5B88C4F, 0xE3913FF9, 0x013F3D81, 0xE1FF9B58, 0xFC70AB91,
    0xE6D63E09, 0x913D2DFF, 0xC4627E0A, 0x64FFCDAD, 0xF7DE0943, 0xF9B58029,
    0xD0144B5F, 0x0D3F881B, 0xCFFE6D68, 0x0FDE05F0, 0x115A4A51, 0x0427FE6D,
    0x814005A4, 0x5A4DE25E, 0xF515FF9B, 0x01190413, 0xB3091722, 0xF867FF36,
    0x7805289A, 0x6F7001DF, 0xDB7D1E07, 0x029DE813, 0xB0F8AFE8, 0xE0760FC8,
    0xA561EC27, 0x6C1BEF20, 0xFC0EC699, 0xBBBFE6B9, 0x1725EAE0, 0xD85B9FDF,
    0xCB524B07, 0xF7DFF7C5, 0x3CE5A0B6, 0x4DF3DF17, 0x0F41AD69, 0xAC1BFC5E,
    0x35582D4F, 0xF0A7F171, 0xE53C16D3, 0xB6445D9A, 0xCF720B60, 0x764C2B53,
    0x41FDE47C, 0x2531DDEE, 0xDAB27FC8, 0x947A0789, 0x51BE2566, 0x62D774C4,
    0x7AE516B4, 0xB914B1A1, 0xD344FC8E, 0x750F8725, 0xD272B16E, 0xD0FEF7A0,
    0x2C1FA0D8, 0xF8C1A670, 0x50378681, 0xA52DFF9B, 0x1F7FE097, 0x28DCAEC3,
    0x5BD35BFD, 0x33FF9B50, 0xE2640D7C, 0x2B01210A, 0x27DF6B72, 0xCFB5BC3F,
    0xF7DADC8A, 0xF6B786C9, 0xFB5B9159, 0xD6F0FEC8, 0xE0F4A33E, 0x1D9B7D4D,
    0xBC1E946C, 0x52781FA9, 0x6F07A51B, 0x60ECDFCA, 0x4DE0F4A3, 0xDA93C7C5,
    0x13783D28, 0xED49E18B, 0x3F3C3BD7, 0xDA93C316, 0x7E7BA96F, 0x527866AC,
    0x3C3B5DFB, 0x93C3163F, 0x3F59D4DA, 0x9B9FA9E6, 0x5766E55D, 0xC7EB3A9F,
    0xE10D253C, 0x7EDEA7D5, 0xFFCDACE5, 0xF6A4F0C1, 0x953F401F, 0xE6BDF82A,
    0x0FC72C97, 0x1A19F83A, 0x1BE76563, 0x1D9C7BE7, 0x41F8A4FC, 0x58A7BF07,
    0x07E68341, 0x3F28FC1D, 0xFC5DEFCA, 0x5E5F83A0, 0x79D9C7E2, 0x5E5F8385,
    0xCAD9C7E2, 0x68325D52, 0x54BF28B8, 0xA8E7A16F, 0x9EB0B437, 0x382F0E57,
    0x7BF2BDAD, 0x9336FCA6, 0xD616809E, 0x98976B43, 0xED8DBE95, 0x0BEB2B45,
    0x9605F85B, 0x3B06B43C, 0xC79625EB, 0xFBF3BC82, 0xC94A1640, 0x718D86BB,
    0xEBD07789, 0xDB451DA1, 0xF3AC5053, 0xF41D5E03, 0xE57F687A, 0xA04D5E28,
    0xBD614BB1, 0x057A5A0D, 0x4F2835AD, 0xC57B1A07, 0xF206F23E, 0x40792C0B,
    0xC3DFE523, 0x9345DD3E, 0x6927FF36, 0x699F3CEE, 0x3E7FE6D6, 0x07C454AD,
    0xFF36B426, 0x126C0F6F, 0x40E6957E, 0x0EF30955, 0xDA3D1DEE, 0xECB6FFFC,
    0x6957E126, 0x97FFE6D6, 0x59FAA631, 0x5526B2FC, 0x5E7E0BFD, 0x4B91D332,
    0x52FC17FA, 0x36B79839, 0xB8DAF3FF, 0xACD73E7B, 0xF1FCFFCD, 0x4C0F96C0,
    0x4FFE6D68, 0x612AA2A4, 0xF36B347F, 0x70AB90FF, 0x6D6839FC, 0x06ECDFFE,
    0x42607CF6, 0x20FFF36B, 0x7DFF3CB6, 0x5FFCDADC, 0xD850DEBA, 0xFCDACD3F,
    0xEB0B40FF, 0xB5A13AF9, 0xA67A5FF9, 0xA124F9E3, 0xF65FF9B5, 0x59F9EC0D,
    0x47FF36B3, 0xCF90B552, 0xCDAD0927, 0x7B6691FF, 0x6B3457D8, 0x4AA07FF3,
    0x420FF798, 0xC87FF36B, 0x03E6A457, 0xFF9B5A13, 0xEF317E43, 0x6D684C0F,
    0xBE910FFE, 0xB42607F0, 0xC0A3FF36, 0x842FB340, 0x9C7FE6D6, 0x07E05B78,
    0xFAB27426, 0x3FA8B5F2, 0xAA4F3DAB, 0x2B78D79C, 0x761AEF25, 0x22BEA7A4,
    0x2464749E, 0xF0DFFE6D, 0x66848D7D, 0xFCDA5504, 0x014BE19F, 0x14D5A44C,
    0x213FF36A, 0xE08E5520, 0xEDC12F69, 0xD3D472DC, 0x911D2E9A, 0xA5D1E45A,
    0x8EBC16F4, 0x12F230F0, 0x41ECA92D, 0xC23FFE6D, 0x684BC097, 0x6D6C0602,
    0x34544FFE, 0xA11944A2, 0xFCDADC46, 0x276BE19F, 0x8A91944A, 0x300FFF36,
    0x00095449, 0xA00ECE80, 0x0F69FD4F, 0x0C27F78A, 0xD3EBDFA0, 0x4FEF141E,
    0x462D7748, 0xEF6A506B, 0x62D77466, 0xB6A506B4, 0xE0579D75, 0xAF74FC0D,
    0x8CF616C0, 0x1DE505F3, 0xE0744D9F, 0xD9FEDFF7, 0xF81D3517, 0x767FB7FD,
    0x1AB28D5C, 0x639905B1, 0xDF17D51A, 0xA94AADFF, 0xF8B96F5B, 0x1E37B4FE,
    0xF173C50D, 0x0587B7FD, 0xF172DEB5, 0xD2CDF7FD, 0x8B968AFE, 0xAFAD2FEF,
    0x5CF51F77, 0x58F7CF7C, 0x8BC0BF28, 0x8FF21E0F, 0x6B0F5FBC, 0xB564FE07,
    0xF0F40F13, 0x974D1DCA, 0x34D93E1C, 0x7C392E9A, 0x468F14D0, 0xB0278C2D,
    0x8B5DD073, 0x7E7F26B1, 0xDD3AC780, 0x5A9418B5, 0xED87B8C3, 0xFFCDA81B,
    0x3206BE19, 0xF9DC4571, 0x654BF9F6, 0xB722B1C3, 0xDE127DF6, 0x6E4567DA,
    0xBC3F23ED, 0xDC8ACFB5, 0xBC3647DA, 0x3D28CFB5, 0x3B365378, 0x783D28D8,
    0xB5278153, 0xFDDDEF49, 0xF60577D9, 0x1F9EEA5B, 0x6D49E18B, 0xF31FACEA,
    0xC5766E54, 0x705FEF7A, 0xB9C5039F, 0xD67515D9, 0x1A4A798F, 0xEDEA2BC2,
    0xFCDACE57, 0x441254CF, 0xF5811901, 0x60FFF368, 0x6B01C014, 0x7FE6D640,
    0x24980C46, 0x944826AA, 0xCE37CD00, 0x2D07E0E7, 0xFC1D07E6, 0x537E0A9E,
    0x52B1B38F, 0x4ECE3DC9, 0xC3271E87, 0xCA2D2B15, 0x93B1FB8F, 0xF947C9C3,
    0x17CE8325, 0xEE50B2C6, 0xA8F05DAE, 0xF5987537, 0x6669AE76, 0xCF02E5CA,
    0x4812EF13, 0xACDE81CB, 0x74DA1E95, 0x4DE25C6D, 0xF785B07B, 0xB61AE365,
    0x0BF0F4B8, 0x6BCA392C, 0x135A4745, 0x8EB186B8, 0x23C63383, 0xA8E5B9DB,
    0xD0F5E827, 0x12D83DA6, 0x3687AF41, 0x2792C0BF, 0x30F30D6A, 0xB46AE2F2,
    0xF6489FF9, 0x024377F2, 0x3FF9B4EC, 0x7E7AA857, 0xFFE6D63F, 0x7D86B1DD,
    0x9125ECBE, 0xDB5E7E0A, 0xFFF9B4C3, 0xF9663155, 0xFF9B5A3A, 0x3D25955F,
    0xCDAC795F, 0x3CCCAFFF, 0xDAA65C1F, 0x5AC37FFC, 0xD63CAF9E, 0x0ED57FE6,
    0x63EFF96C, 0x624FFE6D, 0x63E1F2D8, 0xE44FFE6D, 0x795F3C61, 0x49FFCDAC,
    0x7FB09551, 0x9FFCDACB, 0x4FCB525B, 0x9FFCDACB, 0x57F53A4B, 0x2863E72D,
    0x66D7A1FD, 0x9FFCDADE, 0xFF26F477, 0x3B9D8F2D, 0xCEAE4D54, 0xBFFCDAD7,
    0x5FD02546, 0x5FFCDAD0, 0x57CF2D81, 0xBFF36B1E, 0xFF0548E4, 0xFF9B58FB,
    0xD2F211E5, 0xF36B1F7F, 0x216BA47F, 0xF36B42FF, 0x9B52887F, 0x36B1F7FD,
    0x210293FF, 0x4CD80D7E, 0x1849FF9B, 0x032E07CF, 0x3FF9B4A8, 0x3ECDA950,
    0xB8C79A91, 0x029595E4, 0xB4D8793E, 0x4A37A52E, 0x9CD89191, 0x4A37A52E,
    0xF9B49191, 0xCED7C33F, 0x6B904D44, 0xE2313FF3, 0x0D05512F, 0xFF36A940,
    0x1A57C073, 0xDAD93502, 0x25242FFC, 0xA067006C, 0x0CFFE6D6, 0x9A1397DF,
    0xF36B6128, 0x1FAF867F, 0xD6EA144E, 0x5F0CFFE6, 0x0065388D, 0xDF38AD7E,
    0xDD65687E, 0x1CB738F3, 0xB7CE28F5, 0xB1E3D79F, 0x7DDEBEB4, 0x8B687A94,
    0x7285B474, 0x206E955A, 0x9DE99EE5, 0x05D9E45A, 0x8068F02F, 0x942DE46D,
    0x36B7A67B, 0x060013FF, 0x81209226, 0xDADB4817, 0xC0104FFC, 0x10994DC0,
    0x5FFF9B5A, 0x000120E2, 0xD30B4A62, 0x80E57FE6, 0x52090101, 0xF9B43C62,
    0x0981B55F, 0x41222E10, 0xFF36AFA2, 0xC81AF867, 0x6D42AD40, 0x7DF0CFFE,
    0xBD5E5489, 0xCFFE6D5E, 0xCA26A5F0, 0xF9B4ACD4, 0x88F7C33F, 0xB74D6D37,
    0x7904A7FE, 0x9103F03B, 0x37BAB827, 0xEC37DCAB, 0x8DF13619, 0xF66E579F,
    0xC6F89B0C, 0x8BA4960F, 0x50B1EFEF, 0xDF17817E, 0x137595FF, 0xFBE2E78A,
    0xF8EF6BBF, 0xFBE2E78A, 0x663B0F53, 0x3FEF8BEC, 0x3C516A0E, 0x8A3FDF17,
    0x5E05F79E, 0x2DE47F7C, 0xE2F02FD6, 0xBC0F7E7B, 0xBDE896E9, 0x7F252BE3,
    0x87280477, 0xDE2FC81D, 0xEE57905D, 0x2D1BF60F, 0x40E28B64, 0x2D1F8F52,
    0xB5DD0B64, 0xE286B298, 0x49BEC4D5, 0xBA7D858F, 0x97AB316B, 0xDF41AD34,
    0x8CB9BCB4, 0x0F73CA68, 0xE06F1B46, 0xA39E812F, 0xD34772BC, 0x4E8F8725,
    0x7CEC85A3, 0x20AC54D3, 0x8E53C16D, 0x1E86AF1A, 0x19E4DB79, 0x5B07A6AF,
    0x07B937D0, 0xC6E4BDF5, 0xA9BC6AF4, 0x28637EB3, 0x6F9DD61E, 0xE1B2A59F,
    0xFB5B9158, 0x9F6B7848, 0x9FDDEF49, 0x1DA0577D, 0xFD7DF6B4, 0x6F514F68,
    0x23445CF4, 0xE2C45A9A, 0xD6611D9F, 0xE7DC177B, 0x84767140, 0xC588B53F,
    0xFFED46B9, 0xCED479CA, 0x2BF76A35, 0xEF5B51E7, 0xF25FD4B0, 0x843494DE,
    0xEDF3BF57, 0xA6F792F3, 0x2961DEBE, 0xA4FADEF2, 0xB59E0F77, 0x05001FF9,
    0x744EA898, 0xF0741F86, 0x2E8ACB1B, 0xE27E0BE7, 0x71BE5630, 0xD4FCA6BE,
    0x9E6FC13D, 0xF9587E0A, 0x3A05EA7C, 0x55631B39, 0x3E725D38, 0x83F365D5,
    0x70C97E0E, 0xF9A1D389, 0x6CBF0549, 0x3DD4B4B9, 0x3F3464E8, 0x0C97E0E8,
    0xB18C3A0D, 0xF987A3B2, 0x85F38DF2, 0xE0AD2E47, 0x0725F947, 0x8BA5695F,
    0xC15A5652, 0xE5F83B2F, 0x9C7E874A, 0xF29A0C9D, 0xF14F431B, 0x697E0E83,
    0x0FCDCAC9, 0xCE3DF83A, 0x7E531AC6, 0x896B18C9, 0x461E182D, 0x23860AC5,
    0xBC63711C, 0xB37BB79A, 0x1D7BD81E, 0x473D0B7B, 0x50F585A1, 0x9DBD61DE,
    0x58A3F5FA, 0xD3AF0372, 0x365E0F73, 0x5A8B0F6C, 0xC09AD2C3, 0x0D7BCE70,
    0x829EDA2C, 0x8D1F9D62, 0xA5A9C85A, 0x23418DF6, 0x77461EE5, 0xFFCDA4D1,
    0x7AFB0A1B, 0x3FF36A99, 0x83E9D793, 0x5FFCDACB, 0x707D48F1, 0x85FF9B59,
    0xC59FC6D7, 0xAE459A91, 0xDA8D1254, 0x4AA8AFFC, 0x6D62DFD8, 0xEF168FFE,
    0xFCDAC5BF, 0xF9E5B26F, 0xFF36B2CF, 0x13E4C7BF, 0xFE6D531B, 0xFC49AF7F,
    0xE6D6C000, 0x9E66E57F, 0xF36B2CFF, 0x9791543F, 0xCDACB83E, 0x2DCDFCFF,
    0x36B6035F, 0x9F3D73FF, 0xDAD80D7C, 0xF92C9FFC, 0x5C32CFF9, 0xF6C33245,
    0x9AF059B1, 0xC655C9A3, 0xEFFF36B1, 0x001F8BF2, 0xBFFCDAD8, 0x5D7C586F,
    0x9BFFCDAC, 0x0D7DFAEB, 0xBFFCDAD8, 0x10FF7985, 0x8E7FF36B, 0x006DAFE7,
    0x79FFCDAE, 0x0007E055, 0x2FF494F6, 0xBCC917F8, 0xE47FF9B5, 0x3136CFF9,
    0x29FFCDA8, 0x65AFE3A6, 0xED97FE6D, 0x6B2D7F61, 0x2A44BFF3, 0x3D72D7F8,
    0xF63FD281, 0xFE6D6931, 0x7CF52797, 0xFF9B5972, 0xFF9EC3C3, 0x7FF36B2C,
    0x0FFC39A4, 0x3FF9B5B0, 0xC47FD1C6, 0xA4FE88D9, 0xB232A545, 0x6798CDEB,
    0xF369C895, 0xF9E78A3F, 0xFF36B2CF, 0xAF8E54A3, 0x2247665E, 0x3855C83A,
    0x7C7FE6D6, 0x8A4F9482, 0xFE940EC9, 0x6B498FB1, 0xCF293FF3, 0xC189B67F,
    0x794596B9, 0xDA7A0AE5, 0x5F01CFFC, 0x09491151, 0x57FE6D52, 0x222A2A74,
    0xE6D31029, 0x014D457F, 0x480D9129, 0x81FFF9B5, 0x673A01EF, 0x1FFF9B4D,
    0x11F88A45, 0xFCDA5A20, 0x0948084F, 0x45780695, 0x1039FF9B, 0xC844EA5D,
    0xC65B06EE, 0xFBDE3578, 0x2589BE94, 0x4BA1DA1E, 0x788DBD9B, 0xF64C5103,
    0xBD33DCA6, 0x12D8DAC1, 0x45B02F69, 0x269BFF9B, 0x92252192, 0x1E3FF369,
    0x35227130, 0x401547E0, 0x5A8FFADF, 0x00613FC8, 0x65B0D6FD, 0xD6A13FBC,
    0xB1AF5D63, 0x1A07497A, 0xDA537E8F, 0x3619EC11, 0x8E514BF1, 0x4D867B36,
    0xD85CE97C, 0xF13619EC, 0xE96C85A3, 0x60DCA561, 0xE07634CB, 0xA375FDDF,
    0xFE96F0D4, 0x25CFC94A, 0x59FDF17D, 0xBC62A2E7, 0xE3ACFEF8, 0x7C5CB4E0,
    0xE8E2BCFF, 0xBFBE2E79, 0x96814D14, 0xA6F9EF8B, 0xF1711D28, 0xE7BEB06F,
    0x1BFC5F72, 0x3B9D0FAC, 0xF2D93E2E, 0xF1BB00FC, 0x4D179FC2, 0x52C2CCFD,
    0x6BFDA394, 0x2A0EF23E, 0x1F96F5D6, 0x77BD1D87, 0x5784B53C, 0xFB4DD0EE,
    0x41E97D63, 0x08CAF714, 0x3F3ACC5B, 0x68FF72BC, 0x66945B21, 0x54A5D625,
    0xB859514D, 0xDE0579A4, 0x92E16540, 0x037DBECE, 0x60D25EAD, 0xA1D871BF,
    0xECF1D078, 0x2D1D5C36, 0xB946B764, 0x159AF607, 0x896F5BCB, 0x9B21689A,
    0x94FB2B7B, 0x7B16BBA6, 0x2D815EE8, 0xF6FDEF60, 0x34D7540D, 0xD5FACEE5,
    0x2C1D3F04, 0x4A103749, 0xE815DD2D, 0x7EEF7A4F, 0x9FDDEF48, 0x7A4D02B9,
    0x15DF66EF, 0x777BD268, 0x9360577F, 0xB99BBBDE, 0x6B41DB02, 0xA7B47E9F,
    0xCE2C45A8, 0xE8ED308E, 0xF64A57F1, 0x3EFB2529, 0x7671E8ED, 0x2C45A984,
    0xBF6A35CE, 0x6BB51E72, 0x9D8FE7BF, 0xC3BD2BF5, 0x9BDE4B52, 0xAAF08692,
    0x7633EDF3, 0xED7EAFD6, 0xBDE4BCF7, 0x52C3BD29, 0x7A45BDE4, 0x9B59E0F7,
    0x802289FF, 0xA7100901, 0xAFC1D0E9, 0x93938B5E, 0x8B7341F3, 0xE9D13755,
    0xEE1EC152, 0x1B79AC6C, 0x8BE72563, 0x9D068635, 0xC6365496, 0x71BE5F1A,
    0xA789653E, 0x8C61C9C6, 0x3271BE35, 0x631B7E56, 0x7E09BF05, 0x1F8B1853,
    0x7CABF29A, 0xDF82E78F, 0xE6C2E554, 0x30FC1D07, 0x71BE54D6, 0xA0537CBE,
    0x2A78DF83, 0x7E0BF29B, 0x160F9C93, 0x74BE7256, 0x8FD9C7E8, 0xC9D0B1B3,
    0xF9C6F9CC, 0x9ECACD56, 0x9D067E0B, 0x741F9896, 0x3270ABF0, 0x7EBF30D6,
    0x9630FC1C, 0x97E0E82C, 0xF83A0FCD, 0x9AE57A9D, 0xC1537E0B, 0x2B1C7B2F,
    0x716BD5F8, 0x158C6CAA, 0x82E7B2FC, 0x12C6325F, 0xE94B907B, 0x163E0BB5,
    0xE29B0FCA, 0x87A0B692, 0x63838EB1, 0x1A8B66C1, 0x93F286AF, 0x8F14C5D2,
    0x5F6F23D2, 0x1E86AF18, 0xC6D4FB79, 0x0FA1E9AB, 0x3B37A5DD, 0xBE6094AA,
    0x8ADB5A88, 0xC917D478, 0xAF7B72D3, 0xCD5E3140, 0xF58F3B0D, 0xEC3717DA,
    0x1A92D93C, 0x3EF7B06F, 0x177B43D8, 0x5817E6F5, 0xBD15E4F2, 0x96C1ED32,
    0xEB3B9069, 0x975A4FC1, 0x78D2168E, 0x5AC57235, 0x0A93E9E5, 0x84ACD26F,
    0x14785F79, 0x5A0BD0F1, 0x96BF41E1, 0x2470E2D7, 0x7A0DE523, 0x71DDF282,
    0xA0477941, 0xEF12D8DE, 0x604B1812, 0xDEF704D7, 0x40DF83A0, 0x9B5461AC,
    0xF25D95FF, 0x9524E255, 0x937ACD02, 0x0C628E9E, 0x3C27B03D, 0x55423A6C,
    0xEFFCDA3D, 0xB13FCF61, 0xF30BFF36, 0x9B597AFE, 0xF9E91DFF, 0xFFE6D627,
    0x97AF8E98, 0xDDFFF9B5, 0x7DFB7BF8, 0xB93529CD, 0xFCDAC70A, 0x9FCACAFF,
    0xFFF36B2C, 0x287D779B, 0xF67FE6D6, 0xAC4FF3C8, 0xC66CFFCD, 0xF9B58A1F,
    0x07F1915F, 0xAFFCDACB, 0xC5CFE3C8, 0x08AFFCDA, 0xDCC50FEB, 0x76945B39,
    0x1511B9A0, 0xBCCDEF55, 0xB79FF9B5, 0xDAC4FF3C, 0xDDEBCFFC, 0xFCDAC4FF,
    0xDEFC770F, 0x9FFCDAA6, 0x583EBBF6, 0xE781724E, 0x724B0F09, 0x3589E781,
    0xF7FF9B4C, 0x589FE792, 0xF637FF9B, 0xE6D6287C, 0xF9FBDCFF, 0xEA76DE27,
    0x6BE75720, 0x0B97FE6D, 0x6D63627F, 0x7F4097FE, 0xFFCDAC45, 0x13FCF662,
    0x5CBFF36B, 0x36B13FC8, 0x3E7B0BFF, 0xE6D5F8C0, 0x0F8A917F, 0x1FFCDAC5,
    0xBF6F7F1B, 0xDB1FFCDA, 0xB58D89F8, 0x2A923FF9, 0xF36B28FD, 0xCFEDE47F,
    0x1FFCDAC5, 0xD652FE13, 0xD380FFE6, 0xF9B58A1F, 0x43F8F23F, 0xD27C9471,
    0xDA2D81E2, 0xF2B21FFC, 0xFE6D6287, 0xCFEE5547, 0x8FFCDAC5, 0x9960FE32,
    0x720E891D, 0xF36B1B15, 0x5F16693F, 0x7FE6D625, 0x4ABEC2D2, 0xF4A0764C,
    0x6D1EC2C7, 0xE7A127FE, 0xF9B59703, 0x1F2DDC9F, 0xFFCDACB8, 0x703EE4B9,
    0xE7BBD558, 0x038961FC, 0x07F40BBD, 0x62D03B6B, 0xDA3C0BCA, 0x56AFFCDA,
    0x88045C00, 0x7BDCF13B, 0x93DD230E, 0x0F3DEE78, 0x6D4E7A46, 0x5CD4E4BD,
    0xFCDACFCD, 0x2BD89C4F, 0xB5B3E8C4, 0x17C33FF9, 0xD680822E, 0x06A07FE6,
    0x10028978, 0xCFFE6D6D, 0xE0D225F0, 0x7FF368AB, 0x01BEAF86, 0xFFCDAE15,
    0x215D5F05, 0xFE6D6CA8, 0x8545F0CF, 0xF9B5B2A0, 0x0E51033F, 0x36B202A0,
    0x02F867FF, 0x6B41D632, 0xBC516502, 0xE56FAD9A, 0x3BCF43C6, 0x096DAF28,
    0x2D907A7E, 0xACB79471, 0x4FFCDA81, 0xE34CC010, 0x9FF9B429, 0x39A38020,
    0x9FF9B57B, 0x006003E0, 0xE6D64002, 0x0093487F, 0x368A0029, 0xFAF867FF,
    0x36997C05, 0x22F867FF, 0x9B4CE310, 0x7C2273FF, 0x54E27117, 0xBE07FF9B,
    0x4CD59894, 0xBE07FF9B, 0x5803644D, 0x6981FF9B, 0x699EA132, 0x1F5EFD00,
    0x184FC0EC, 0x07D7BF40, 0x0603F03B, 0xC1F5EFD0, 0x0140FC0E, 0x1DBFC3F4,
    0xE80309F8, 0xC0EDF8AF, 0x7F40180F, 0xF03B07C5, 0x5FD00613, 0xFC0EC1F1,
    0xD269AF80, 0xEBADA7B7, 0xAF4D36EF, 0x286CA317, 0x7F44A21B, 0x37D25D34,
    0x9F8D32D8, 0x6769304D, 0x612D815E, 0x7D87AFFC, 0xE773ACEA, 0xBF57662F,
    0xFFEF8BF4, 0xE5B082EE, 0x6353FBE2, 0xF7C5CB4B, 0x78B6F7DF, 0xDD7F7C5F,
    0xF172D837, 0x286375FD, 0x1FEF8B9E, 0x5E0F58B8, 0x536C7F7C, 0x3DF172DE,
    0x781782DF, 0x9E0B69F1, 0xFE2ECD72, 0x96A7D60D, 0xCB64F8B8, 0x7DBC9BF3,
    0xE796C9F1, 0xF1762AC3, 0xCFE796C9, 0x8A5C0ED1, 0xF0FF89F2, 0xDE536C6E,
    0x56829FF1, 0xEF58959A, 0xFB2B77D2, 0x7815E199, 0xEEF5F503, 0x694BAE0B,
    0xEDEBA6CF, 0x8B642D1F, 0xE7FA4BD5, 0xEDF76F7A, 0xDED69B22, 0xC85A3B0D,
    0x64750B0E, 0xBC5D24B0, 0x37503725, 0xD06A456C, 0x907BAEBA, 0x361C4D77,
    0x77BD3AF0, 0xE90C1EE7, 0xBC3409B8, 0x5E09F981, 0xA68BBBFA, 0xE99BBD08,
    0xF2169C16, 0x5FF79704, 0x103DC2D1, 0x303763EE, 0x3C7B06FB, 0x298B75B4,
    0x7503785F, 0x763EE18B, 0xDE956903, 0xBAD23C62, 0x3571D294, 0x5B7AE1DE,
    0x6C8AC2C6, 0x49F1B96C, 0x483FF36B, 0x640400C9, 0x29BFFCDA, 0x4C804029,
    0x0661FF9B, 0x70062006, 0x0C5FFCDA, 0xAF40C0C0, 0x0A2FFF36, 0x5DB887E0,
    0x77BD2681, 0x67F7A43F, 0xD26815DF, 0x0577F77B, 0xCDDEF49A, 0xBD26815C,
    0xB02BB777, 0xC3C23BBD, 0x7A3B4CE4, 0x53EC94AC, 0x8ED1F64A, 0xCF7ED71E,
    0xC2BF59D8, 0xED55FACE, 0xFFCDACF7, 0x01C45C24, 0xFF36A900, 0x3580042B,
    0xE6D64062, 0x808175FF, 0xFF9B5C80, 0x9C459273, 0x3FF369D8, 0x00428DC1,
    0x3FF36930, 0x426E2660, 0xFFCDAD62, 0x0EA48040, 0xF9B5C004, 0x5121F89F,
    0x6D268922, 0xC0DC27FE, 0x69909441, 0x41313FF3, 0x5491389D, 0xA989FF9B,
    0x31388002, 0xCDFFCDA6, 0x08C4D581, 0x13FF368C, 0x0000E06E, 0x07FE6D1A,
    0x42460606, 0xFFCDACC2, 0x0202C47A, 0x3FFCDADA, 0x4484C018, 0xCFFF36A1,
    0xB1202021, 0x6BFFCDA4, 0x41188B81, 0xFABFF36B, 0x890000D5, 0xEFFE6D31,
    0x484C0C0D, 0x3FF36B80, 0x024243F1, 0xFF369904, 0x09448DA7, 0xFCDA6512,
    0x18104C4F, 0xE6D27888, 0x19F444FF, 0x36B58922, 0x210963FF, 0x53716110,
    0xE8D0527E, 0x2D2A97E0, 0x938D57CA, 0x68341631, 0xC7EBF634, 0x631B8FC1,
    0x47E51F25, 0x7AFAE9F9, 0x83F1631B, 0xA0C97E0E, 0x3F05F393, 0xC173525E,
    0x7AE952AF, 0xF725BD4F, 0x0B92C636, 0x52CA727E, 0x3E71BE5D, 0x5CDD5683,
    0xF7CA9BF0, 0xF29A1F98, 0xC727271B, 0xC4BD07CA, 0x958C6CE8, 0x53F05C96,
    0xF82EB4AF, 0x5F838561, 0xCE4AF53E, 0xC2B4ECE7, 0x0AF9C6F9, 0xA56539AE,
    0xCE3DF945, 0x741B529E, 0x0724F44D, 0xA76AD03F, 0x42C0D77B, 0x1BE73327,
    0xAC3E63E7, 0x1F87270A, 0x553F0767, 0x3F63418D, 0xA0A6FC15, 0x371F2AE5,
    0xE13D97E5, 0xC637CBE4, 0x5DCF271A, 0x97E0E832, 0x9D3A2A6B, 0x54F754B2,
    0x37CE63F0, 0xF5BDF7CE, 0x9B25B9D0, 0xCA184F5E, 0x4971B5D1, 0xF51CB73B,
    0xB942D058, 0x87C176BB, 0xAA7A2372, 0x5E8969A0, 0xD61ABC62, 0x92F0F73B,
    0x1A8B66C0, 0x915BC6AF, 0x91A8ECEE, 0x5DAE7607, 0x1437A8F0, 0xC7EB130F,
    0x4C5B06E2, 0x2D56C8F1, 0xF6CB40F6, 0xDFFE6D30, 0x7B781F13, 0x6F917837,
    0xCC7C96EF, 0xB4783DB8, 0x8A0D61A4, 0x39DEEB6F, 0xA181B974, 0x6282C2F3,
    0xF6FA3F9D, 0xE56E5A34, 0x5E7ABCA0, 0x79413359, 0x3D66DAA5, 0xB753B978,
    0xDAC9037E, 0x61AD27A9, 0xD4CD4AFD, 0x22986B13, 0xA052E4CD, 0x4D115919,
    0x368F607A, 0xFBFC6FFF, 0x3FF9B54C, 0xADB8FBEF, 0xF0B9FFCD, 0x16DBF6E3,
    0x9D3CD26F, 0xC5BFFF36, 0x35F8E03E, 0xE15726A7, 0x529DD958, 0xC612AA2B,
    0x140EE76B, 0x30354B0F, 0x22D81BC8, 0x98B529E6, 0x1EDDAD54, 0x792EF268,
    0x9DCDDEDF, 0x36F64B73, 0x7CF4AB92, 0xF7FA4CD3, 0x612996A5, 0x37984BDF,
    0xA8F64933, 0xC253D02C, 0xB0F6FFA4, 0x58FE940A, 0xFFCDA3D8, 0x8F57CB4F,
    0x025FF9B5, 0x9B58C03F, 0x5FF585FF, 0xBF2581DB, 0xA3BCC937, 0xEDFF4986,
    0xEB364861, 0x6D30F140, 0x7FE127FE, 0xBB5BEFCE, 0xA6BC1B63, 0x52D4DE01,
    0xE6D6BD05, 0x1016AA7F, 0xB6ABE090, 0xAE6A725E, 0xFFCDADE6, 0x2120022A,
    0x9B504091, 0x8A8301FF, 0xCDAA488A, 0x8A9C40FF, 0xCDAA488A, 0xA8A9B0FF,
    0xFCDAA488, 0xA2BE441F, 0xF36A9222, 0xAF62713F, 0xDAA488A8, 0x8BE19FFC,
    0xCDABE01A, 0x5C0104FF, 0xE6D68480, 0x411A7CFF, 0x6D150922, 0x01A7CFFE,
    0xB4540410, 0xE880BFF9, 0x9B5A01A3, 0x06F875FF, 0xFCDAE300, 0x8879749F,
    0xFCDA6511, 0x0901749F, 0xFF369881, 0x044068CF, 0xD694DA09, 0xBC60F41A,
    0x50FDBA16, 0x69B77B0B, 0x9F98E452, 0xEF4D1777, 0xE5796C0A, 0x9AC0EC18,
    0x4DE4DEA6, 0x6B437DDA, 0x24B14C50, 0x5C3B34A8, 0xF03D3573, 0x606E5BA6,
    0x72E8B60F, 0xB154A1D1, 0xD24B0469, 0xB981D90D, 0xC8B52307, 0xC77B0BC3,
    0x204B7E76, 0x585CB9BF, 0x3BBA1F42, 0x40F1FB6A, 0xDBEBA5A9, 0x6AF1A04F,
    0x28B62974, 0x52E84D5E, 0xC8E23A50, 0xBF2B6696, 0x0E5B7BD2, 0xCAF23472,
    0xE7DEDE0D, 0x6D6F6FCC, 0x7C2427FE, 0xA6205389, 0x3484FFCD, 0xABE13601,
    0xC084FFCD, 0x902020C0, 0xE81FF9B5, 0xC800040D, 0xC40FFCDA, 0x20713882,
    0xC4FFCDA8, 0x23202901, 0x4FFCDAD2, 0x4830188C, 0xF36A101C, 0xD445013F,
    0x36A10104, 0x049913FF, 0xCDAC0001, 0xC02694FF, 0xE6D5E817, 0x0216AA7F,
    0xB57F1244, 0x9A119FF9, 0x6D5E80AA, 0x7C856FFE, 0xDAE41208, 0x2481DFFC,
    0x9B506251, 0xC48A15FF, 0xDA4C8901, 0x80A8AFFC, 0x58020289, 0x0D95FF9B,
    0x6C231102, 0x8087FE6D, 0x209C469A, 0x987FE6D5, 0xAD848C80, 0x435CFFCD,
    0x5BC48482, 0x0B2FFF9B, 0xD1A04231, 0x29157FE6, 0xCC890484, 0xF49FFCDA,
    0x80909445, 0xF3FFCDA2, 0x04803F00, 0x85FFCDAC, 0x0491288B, 0xEBFF3698,
    0x9449122F, 0x7FE6D528, 0xCF552260, 0xF36A9C4B, 0x926070BF, 0x9B500248,
    0x45C8A5FF, 0xCDABE090, 0x8C41D1FF, 0xCDA87118, 0xE00048FF, 0xDAC04625,
    0x602E4FFC, 0x5F080482, 0x8907FE6D, 0xD807104B, 0x71AFFCDA, 0x84806260,
    0xABFF36AF, 0x40242115, 0x1BB00DFC, 0x16F5D6F5, 0x53316BBA, 0x19EC11DA,
    0x4D9FA3E7, 0xAC747950, 0x3D947CA9, 0xBBFE26C3, 0xD867B20B, 0x9BA457C4,
    0x3E26C33D, 0x19ECDCAF, 0x6FB3F136, 0xC4D867B3, 0x7B068FD7, 0xF07C4D86,
    0xD867B1D2, 0xD24B07C4, 0x1F2D88DB, 0xC75587B9, 0x08176B60, 0x0B47FB9D,
    0x91F372D9, 0xEC3D7FF7, 0xA2B3FBE2, 0xFDF17258, 0xB96C1AF9, 0x0E69FEF8,
    0xFEF8BC72, 0x72D3E0DB, 0xEDF5FDF1, 0xFBE2E5A7, 0xE78A6947, 0x5363FBE2,
    0x3DF17D7E, 0x2E4B14DF, 0x765B7AFE, 0xB27C5E37, 0xD9AFF9E5, 0xFC4FB0F6,
    0x0BE77787, 0x68ACA35A, 0x7C77BD16, 0xB02FE4A5, 0xD276695F, 0x766DC914,
    0xDAB264C9, 0xF607B892, 0xFBD1848E, 0x5198A0A6, 0xC1DE99EE, 0xFA4E5148,
    0x5D75B475, 0x91D66E91, 0x90F074B0, 0xBD70B53F, 0x5DEC9ACD, 0x34C1EE7A,
    0x75EA3907, 0x9E25AF83, 0xAFD37D9A, 0x83DA1E25, 0x07B0D92D, 0x373B0E2B,
    0xACA0F69A, 0x7B7D4B9C, 0xF5215FFB, 0x62E7FBBB, 0xE521D99D, 0x3D392D4F,
    0x2BE6C85A, 0xA5C092D7, 0x66D25828, 0x452E8E05, 0x85816B1E, 0xD77907BA,
    0x6B0DC748, 0xE7E768F2, 0x7A0D272B, 0xE0D6B7EF, 0x37B595F3, 0xA8E5158A,
    0x678B5BBE, 0x3E7C176A, 0x9704F20B, 0x9F168AF7, 0x8E5158A0, 0x6ABBDEBE,
    0x51AD206E, 0xD3687A5A, 0x3D1B589A, 0x6D626B48, 0xB34A81BC, 0xC0D5E316,
    0xF7265B22, 0x8C96AAA0, 0xA3E605F7, 0xC720FB52, 0x78D07931, 0xDA54D235,
    0x58523578, 0xB20AC542, 0xF4C545CE, 0x7CBC8B9C, 0x74D8583D, 0xA33C176A,
    0xC12F4278, 0x5B3A0F0E, 0xF2C1E1CE, 0xFE6D6930, 0x580C4627, 0xF9B4C623,
    0x44C00AFF, 0x8BFF9B4F, 0xDD437801, 0x07B9CFB2, 0x6B3FF9B5, 0xB5984C08,
    0x60661FF9, 0xF9B59890, 0x9800AD5F, 0x3FF9B4D4, 0xA76B0027, 0x028BFFCD,
    0x71D7C918, 0xA4D1A8FB, 0x40AE67F7, 0xBBECDE93, 0xEF7A4D02, 0x3A9A0576,
    0xA23AF5EB, 0x029FF9B4, 0xACF12105, 0x7504FFCD, 0x6D2F8852, 0x1C856FFE,
    0xFF9B4322, 0x44C02BD3, 0xD7FF9B4B, 0x6A081A85, 0x17813FF3, 0xE6D66241,
    0x1A25027F, 0xBFF368A0, 0xD8402470, 0x1C2FFCDA, 0xB5AA8901, 0xF0A99FF9,
    0xF9B49E21, 0x887C6D3F, 0x9FFCDA69, 0x5A446A36, 0x46D3FF9B, 0xE6D3289D,
    0x8807997F, 0xA743A790, 0xFC5F0567, 0x12DF83A0, 0x9537E51F, 0x968171EF,
    0x38DF9873, 0x5CB65599, 0xA6FCA3F0, 0xF38F7378, 0x37CE8341, 0xD456F7CE,
    0x71FA5A18, 0x47C953F6, 0x0A7EBDF9, 0xAB1F2563, 0xDCD1A0C7, 0x5A5F94D9,
    0xA7CA6FC1, 0x58C2F95E, 0xFC1D0637, 0xF3A192A4, 0x4E8BF05D, 0x1E2DCD07,
    0x8B714F43, 0x4B29F393, 0x164E853C, 0x3F3257AB, 0xE857E534, 0x68625A70,
    0x172FC1D0, 0xCA3ECAC6, 0x5D3A2A6F, 0x387434F2, 0x625A765D, 0x1BE5D3B5,
    0x874F43E7, 0x8B71F3A1, 0x05629EE7, 0xC631FA0D, 0x63527E0A, 0x4F4E4AE8,
    0xCA9BF05D, 0x3A0C974E, 0xBE5F38DF, 0x54A6A9C7, 0xCF9C6F95, 0x38DF2E97,
    0xC7BA765F, 0xF28B53D9, 0x9BF28B4B, 0xD06858C2, 0x58585CE2, 0x958AE0F9,
    0xB3F05CD6, 0x631B3A1C, 0x61F82BBD, 0x1B5292A5, 0xE0E83F34, 0xDD2AF957,
    0x56CBF054, 0xF2A6EA96, 0x374ECE3D, 0xCE4E2DC5, 0x3A0C9537, 0x71EB1C59,
    0x85CBF076, 0x93A352B1, 0xBD06D5A7, 0xBE54D630, 0x2B18D9C7, 0xC64EC1F8,
    0x392FC158, 0xE0AF52D5, 0x2DCE3D97, 0x393A0C97, 0xECE3D4DF, 0xA0A4BCEC,
    0x1ECE3F41, 0x20B2A727, 0x8F2DDEF4, 0x3C2E5617, 0xE413DFB2, 0xEA6D36FA,
    0x9CC94A7D, 0xA57EF5A9, 0xB05A86B1, 0x79482C6A, 0xCEE1EC6F, 0x8CDE86F4,
    0xDDED68F1, 0x9686AF14, 0x7B0DC3DE, 0xE45681DA, 0x3D937BA8, 0xCEEF7A4C,
    0x96B1D4AF, 0xD72B07A7, 0xC6B4F82E, 0x1ABC3DEF, 0xE330D6A5, 0x5DEF70D5,
    0x7CDCE28A, 0x75E1CF65, 0x78C96AA8, 0x6AD5645F, 0x47794176, 0xB87B7EAA,
    0xEA1ED9C9, 0x2BBD27E0, 0xC777B03C, 0xB7E75A5E, 0xA1ECC096, 0xB25B03BC,
    0x497CD9E5, 0xA3C1AE60, 0x87E977BD, 0xC812EF18, 0xE341EDF5, 0xB825E8D5,
    0x74A341F7, 0x7687A05C, 0xAD7706F8, 0x19E9308B, 0xC468E873, 0x8307B9DD,
    0x9552BCB7, 0x25AFB03A, 0xE536125B, 0x83E0BB53, 0xB8BC9BBD, 0xB647359A,
    0xC2B3E1C4, 0x3ABC0783, 0xEDF096C8, 0x7B6E41DD, 0xBA8F4B58, 0xEA3C176A,
    0x9CFFCDAD, 0xF2B90DD0, 0xDEF1D4EC, 0x79595FBB, 0xA1DE630D, 0x93277AAB,
    0x0EEF5E97, 0xE6D30F14, 0xF57F657F, 0xC9A07A19, 0x9CEE64BB, 0x740E945B,
    0x12ABDA9A, 0xE77AAB9A, 0x0DC61EDE, 0xB340ADFB, 0x8AA87164, 0xAC2F2727,
    0xA49537D4, 0xB316F058, 0x6F0CDE44, 0xC9266331, 0xECE63B8E, 0xAC255450,
    0x77999C67, 0x8E71B1F4, 0x453D0548, 0xD4BEFF4A, 0x8AD61E12, 0xDCC584AA,
    0x84AA8ADE, 0xAB907655, 0xDF251C70, 0xDAF7984B, 0x5A9C27BB, 0x413DDED6,
    0xA735207A, 0x9176AB1D, 0xAA8ACC37, 0x777B4984, 0xBF5FB1A0, 0xFC4B0FE7,
    0xD781779E, 0xA1D7BF6A, 0x27B36AA6, 0xEA2D7BD5, 0x89AA7687, 0x676D6054,
    0x476BD2EF, 0x814A0572, 0x2EBA4EE0, 0x47817945, 0xB7EBC03B, 0x2D06FA98,
    0x1BA8AF53, 0x4732DE52, 0x2DE51C62, 0x93C62453, 0x282C8A4E, 0x03AFD166,
    0x4D1DAF4B, 0xDAF4B03A, 0x10FFFCDA, 0x6B032069, 0xC072BFF3, 0xF9B43041,
    0x3560395F, 0xFFCDA191, 0x21397C20, 0x227FE6D5, 0xAA640C01, 0x7C20FFCD,
    0xF36B0137, 0x9051017F, 0xC16EB738, 0x88E183DC, 0x78EC67A2, 0xF5F1A91D,
    0xBAE8EFDE, 0x5BC75EE5, 0xB606E5CD, 0xDE87EB50, 0xD9A54D35, 0xBA30B521,
    0x6F7A6E2E, 0x2F2292F7, 0x1435A6AE, 0xBCDA6E87, 0x4B5391BD, 0xDEF5CE5F,
    0xB61B9EBE, 0xB23AE502, 0x0F73B0C7, 0xEF58C3E6, 0x5E31BF05, 0xA7AC780D,
    0x7B7B5E41, 0xEC86B4D8, 0x3CD629A4, 0xB58E24B5, 0xF14D852E, 0xAC59746A,
    0x3A5BCF07, 0x183C4BD0, 0x6515BB94, 0x0A7804B7, 0xD05B22D2, 0x12585CE8,
    0x9A95BBD8, 0xD02F26A3, 0x5920DCBA, 0xD868053B, 0x40FFCDA3, 0x1F442200,
    0xD207FE6D, 0x693045B5, 0x62713FF3, 0x548484C0, 0xC389FF9B, 0xF36B2E57,
    0x6754313F, 0xFF9B5062, 0x40380209, 0x44FFCDA8, 0xD01817B2, 0x644FFCDA,
    0xA5C03123, 0xF014FFCD, 0x9B50A215, 0xFE2429FF, 0x7FE6D3A6, 0x400096AA,
    0x6AA7FE6D, 0x9B4C8059, 0x260395FF, 0xE6D5FC40, 0x042FA4FF, 0xD7FE6D3A,
    0xA5C01E23, 0x966BFFCD, 0x06F1FC4E, 0x9A3304FD, 0x914C5AEE, 0xA7F3A41A,
    0xAC27F904, 0xDEF1D6F9, 0x6FA36FDD, 0x774696FC, 0xF5D62D93, 0x24D67500,
    0xD818B5DD, 0x1BC0AF2F, 0xCE9626C8, 0xB4692D8C, 0x0B642D1F, 0xA2ED6233,
    0x2588CCDE, 0x67B0FDBD, 0xFB07C4D8, 0xBC13D77D, 0x67B07456, 0x12F0FD7E,
    0x8DBFE4A5, 0x52A502D8, 0xBC17E47C, 0x71F9F7DE, 0x1FDF17D8, 0x7C5CF74A,
    0x7D9DBDFF, 0x4967FDF1, 0x0DF605F4, 0x0A694EEC, 0xBDEF438C, 0xD3CBC5FB,
    0xB87DDEA8, 0xBECF4606, 0xEC3D41D4, 0xFBC8F9A9, 0x9B4AFD83, 0x05DDE7E5,
    0xFBBEB2E3, 0x4960D92F, 0xD9EE47F4, 0x92D4FD15, 0x78C7F5D3, 0x139224B0,
    0x89BDEB3E, 0xEBCB7564, 0x07B27953, 0x93B7C13E, 0x696FDD22, 0xEE5782BF,
    0x0DA39452, 0xEB6EE0AB, 0xEE0AB017, 0x3C1AC5A6, 0xEE0AB0E4, 0xFE258EE6,
    0x37DCF5D6, 0xC485A2FF, 0x2D17FC0E, 0x9B27EA64, 0x37DE9BF2, 0x476AB0E9,
    0x2168B9BE, 0xD7C3DE5B, 0xBD0D577B, 0x3B48A5A0, 0x61BBDAD1, 0x3CE61E2B,
    0xB0B642D1, 0x93748B89, 0xA09DD81E, 0x1A67B5B7, 0x14ED22BF, 0x2020DD7A,
    0x75E00BF2, 0x1D83C534, 0xADFF66D2, 0xF0B4014A, 0x4875E1F6, 0x98A693B3,
    0x06C85A3B, 0x7A5D4E5E, 0xB61CD78B, 0x494A8DBE, 0x2F5A4E0E, 0x0B16BBA1,
    0xEA552BCA, 0xD0F9F914, 0xFC9FA0D8, 0x7A0D2728, 0xAB89E8EF, 0xF4F26C38,
    0x1D75B1B8, 0xCF9ACA7D, 0x7CDF7226, 0x5B8960F2, 0x751E35EA, 0xDCA9314B,
    0x1EDAEFCE, 0x3A2BCEDA, 0x16E760F7, 0x5E1F43D8, 0x1B75DFB9, 0xFBDEB173,
    0x1EBD0606, 0x0F48C0BC, 0xDE06F23B, 0x672815B0, 0xC7A696EB, 0xF21BAAAC,
    0x7AB96EF6, 0x728B43C5, 0x4E50D7E7, 0x01E9FF9B, 0xFFCDA3EB, 0xBB860038,
    0x67616BF2, 0x02B99BD2, 0x7B07286D, 0x269EDEB0, 0xD1A8B07B, 0x2294B6A3,
    0xBD353715, 0xF56F43FD, 0x3D612F59, 0x2B0C9D35, 0xA56365F8, 0x1FB2FC15,
    0xF945C367, 0x071ECE3D, 0x27FE6D3F, 0x685A93AE, 0x45213FF3, 0x5FF9B4B0,
    0xE0B10238, 0x0A4FC137, 0x97E0BDEB, 0x7714F58D, 0x97CE4BF0, 0xD0E973CA,
    0x25CE874E, 0x7BF054F7, 0x51AF1C96, 0x37E53715, 0x8FD0FBC5, 0x3594F0C7,
    0xF2FC1D7E, 0x836A58C2, 0xDF838B1E, 0xA5CBF054, 0x6B1470AC, 0x4C7E25E8,
    0xD3A365F9, 0x7B054ECA, 0xE3D63192, 0x67E5346C, 0x2D2B3DF1, 0x53E7E0EE,
    0xFB03D7AF, 0xDA9F2BD4, 0x9F82E6E9, 0x671EBD4F, 0xE4B92C63, 0x4AC63670,
    0x71BF0746, 0x32577BF0, 0x6B97E0E8, 0xD2B18D0E, 0x70E5353D, 0x68BE71BE,
    0x73F05CF1, 0x68325F98, 0x31B7BF07, 0xE4A92F16, 0x7CE81DF1, 0x974E836A,
    0x958C6DEB, 0x53E5F82A, 0x69BAC2AF, 0x69725F5D, 0xC2B18DBD, 0xB18594B2,
    0x76765F82, 0x2B97E0BA, 0x13F07419, 0x7E0E4ACF, 0xC3F28B72, 0xD0C97E0E,
    0xB2A9D958, 0x83A5630F, 0xF0742F46, 0xA1B39F1B, 0x4192E9C3, 0xB9BF05CF,
    0x5D3A07E0, 0xE89A9BF0, 0x82EA9651, 0x0B3C949F, 0xF82E9C3A, 0x0EC662E5,
    0x2C61527E, 0x2DF9458C, 0xA9F13F31, 0x8C6CBE57, 0xF28B0B95, 0xE3A70E83,
    0xC958C627, 0x2B0FC173, 0xB8FC173C, 0xF429E9C5, 0x9C7AEDF8, 0xA5BA76AD,
    0xF168343A, 0x37E0ECE3, 0xE158C6CE, 0x7CE37CE4, 0x4A54FD17, 0xF82FCA3E,
    0x4BF05D49, 0xF071FAF5, 0xB18525CB, 0x5F82E792, 0x97E5316E, 0x92B4AF16,
    0xA0DA9D65, 0x325631B3, 0x9F945CE8, 0x7E0BA57A, 0x468162B9, 0x31BF0763,
    0xC15A7416, 0xBF65F82F, 0x3F072716, 0xC632716E, 0x7E0BC312, 0x3BF28EB9,
    0x76A5CAF5, 0x6CE4AC3A, 0xEE5F8FCA, 0xFDCD97E0, 0xA765F838, 0xE97E0E25,
    0xC1DCC9D0, 0x97E0AE0F, 0x9A1D2F9C, 0x92B0B0F9, 0x653A5F83, 0x8B58EEA9,
    0x15F2BD4F, 0xCAF53AC6, 0x0E4A9E17, 0xE9C5A07E, 0xE6681F82, 0x5AF58C6C,
    0x2E0E4B9C, 0x65F82FCA, 0x2742C2E7, 0xC974AC63, 0xF2BD4EF9, 0xD07E0AA5,
    0x0E3DF38F, 0x054F527E, 0x73D064BF, 0x1F6ACFC1, 0x65F8393A, 0x63676773,
    0xA9AF53AC, 0x4192E6B4, 0x6C9AF34F, 0xBA76A58C, 0xA77CE37C, 0xB2E4B95E,
    0xE0B9BF29, 0x8F0E8C97, 0xC17E5161, 0x75A5F82F, 0x97E0E82E, 0x77AD2A9D,
    0x9AD2EA8D, 0x797E5343, 0x54DF8385, 0x8B418741, 0x1A18DF83, 0x4BF29A34,
    0xB4ACAD06, 0x652C61F2, 0x9F83B98D, 0x41A198E5, 0x5CBF0773, 0xB0F9C958,
    0xE0AD3986, 0xF82B0B97, 0xF9B3B989, 0xE9BF0741, 0x0C97E0B9, 0xD58F5EBA,
    0xC4FC1D06, 0x98B4E4E8, 0x38D631B3, 0x07E51F39, 0xEF81AE9F, 0x1AE9F04A,
    0x81CECE38, 0x33D9CC2D, 0x592788AD, 0x95C692DE, 0xB07B482D, 0x535281C5,
    0x140AF1F9, 0x8DEBF3EF, 0xB5FA4B97, 0x7E35DED0, 0x60B34BDB, 0xD46652BC,
    0xAD2CAF81, 0xCEA0EEF7, 0x4D831CAF, 0xC6DAD179, 0x9AF395A6, 0xE78A87C3,
    0x2EC4AA95, 0x4F2D9168, 0x0396903B, 0x35E7A2FB, 0xB53E469F, 0x258A3E0B,
    0x7299B607, 0xACFBD8DB, 0x82582094, 0xF50F115C, 0x49E22B45, 0x965412CA,
    0x8692E1CC, 0xA1BC9BDD, 0x297762E9, 0x456AA3D9, 0x551A8969, 0xCEEF0ACB,
    0xB82F06AA, 0x92E59305, 0x30EE4971, 0xDF3AC2D9, 0xA7A1474C, 0xF44B5541,
    0xD6E60D33, 0x1834D68E, 0x5996F5BA, 0xC0B6F32D, 0x6DF9D259, 0xCB59BA81,
    0xBF3A325B, 0x48FDEC6D, 0x2D81DE51, 0x595341E1, 0x1C85A8EA, 0xCB40C0EC,
    0xB0302DBC, 0x73B5E268, 0x168442E0, 0xC6D7415C, 0x5F82BD25, 0x7603C960,
    0xF3DDE2A0, 0x27E0A494, 0xFD4ED4AD, 0x9E55BBDE, 0xA8F4FD9F, 0x1EDEF44A,
    0xCC355596, 0xBFD727BB, 0x1A071E2F, 0xDADDEF79, 0xA13FBFFC, 0x7340EF62,
    0xDE6DE82F, 0x61E5AA66, 0xB4BB558E, 0xA13E3FF9, 0xCD362F62, 0xB02BC7BC,
    0x2BDBDAC9, 0x7E5F7850, 0xF607B7BD, 0xA8A1DEBC, 0x6AABD84A, 0x5F97D249,
    0x2D81ECE9, 0x7EFFFCDA, 0x31AFD062, 0x63095514, 0xBCCD81E2, 0xAC4B60FB,
    0x7A36CA61, 0xCDBC0B60, 0x1437923A, 0x24F607A3, 0xD4F207B1, 0xAC760BDC,
    0x6E64BC61, 0xF67F3798, 0x5E3340EE, 0x46B0F6CF, 0x1FE7FE6D, 0x81AA7150,
    0x44C0B6F1, 0xEF3074DE, 0xF4761E44, 0x3C7A44B1, 0xC8FA07B0, 0x7DDE3855,
    0x765B03C9, 0x12AA289F, 0x0EEF6FB6, 0xAC37DB0F, 0x49763A63, 0xD982A44F,
    0x3DE61632, 0xB340E99E, 0x915F6129, 0xBF61299A, 0x3094F798, 0x12F30BE9,
    0x4561EDE6, 0x6DEF70B6, 0xB03C24BD, 0x28092F45, 0x529C466B, 0x87899A07,
    0x72816DF9, 0xB52E5B03, 0x6A70C0DC, 0xC0F1E709, 0xF1E8B096, 0x81A8C096,
    0xF427BBCC, 0x02DBF587, 0x607A4D03, 0x24DF604B, 0x89604B55, 0xF1612AA2,
    0xB26CF4A4, 0x59BD5507, 0x352861AC, 0xB265F78C, 0x1F7825A1, 0x61A481D9,
    0xBD93643D, 0xC970CD03, 0x0724F813, 0xAC102A5A, 0xC09FBCF7, 0x60C3EF4A,
    0xD9AA9A85, 0x2776B05E, 0x8AF5DAA7, 0x4A0561BA, 0x40AE4EED, 0xEA9AF029,
    0x478153B5, 0x125CAF5B, 0x75175AE9, 0xA2912583, 0xA6BC0A62, 0xEA2BF7A0,
    0x17707287, 0x813B06DD, 0xDB17D4C5, 0xEB94DAA0, 0xB0D44B95, 0x29BBDD44,
    0xCDB589AD, 0xD3EBF3AA, 0x4B794CCC, 0x7943C472, 0x922C1CCB, 0x7E3996F2,
    0x0F337924, 0xDF33D9C6, 0x0E8096F2, 0xB5063D8E, 0x00489FF9, 0x7FF3685F,
    0xD5389A13, 0xE8467FE6, 0xFFF368AD, 0xDAA53426, 0x4D094FFC, 0x27FE6D42,
    0xAE6AC012, 0x6845FFCD, 0x5FF9B5CA, 0x4DCCE845, 0x692E0F69, 0xB952C56F,
    0x372B7BCB, 0xFBC7B51E, 0xE061A3C1, 0xFBBDE965, 0x6DF955DD, 0x05CB9481,
    0x13E28766, 0x728586F0, 0xAD3581D2, 0xADCF4748, 0x5906A450, 0x754B2895,
    0xB0694B5A, 0x06EBD336, 0x1EE31561, 0xF9C2FC16, 0xDCAF1630, 0x5E42F5AC,
    0x0B1561B9, 0x27A3B95E, 0x03F4D79A, 0x8137DEF6, 0xAD3B0B87, 0xE96A504A,
    0x4A95ECDB, 0x1D43DB1D, 0x4C3DB2D8, 0xA7D96C8A, 0x3BB3E074, 0x0DE3525B,
    0xDEE096CC, 0xB7EF723B, 0xA3E74C96, 0xEA0A5152, 0x51CD471E, 0x3D8611DD,
    0xCB738BA1, 0x6E51CB51, 0xAA82FB61, 0x04D44F8A, 0xEDB940F7, 0x6AF0BDA8,
    0xAFD8D022, 0x5B1A0527, 0xD4D264B1, 0xCDA13578, 0xFB7F0AFF, 0x455FF9B4,
    0xF9B456E8, 0x9A2BE07F, 0x84EBFF36, 0xFF368AA6, 0x6B604D23, 0x81C93FF3,
    0xAB14F917, 0xD9CFC1D7, 0x41831AEA, 0xFB0BEB2B, 0x1DE5B213, 0xE3F29A68,
    0x2A258158, 0xB5DD24D6, 0x94436518, 0x74D88FE8, 0xF87D62D7, 0xFE1F5FEC,
    0x7A8BB3FB, 0xCF640AF3, 0x3A7F89B0, 0x2ED6C1AB, 0xE4633D90, 0xDD415B95,
    0x74047694, 0x102BCFEE, 0xC8F8A54A, 0x7DEE579B, 0xF673B4B3, 0xF8BECEDE,
    0x72B794FE, 0x7761FDF1, 0x70FEF8BA, 0x53474AC9, 0x4BEC477C, 0x0EBF5F1D,
    0x1BF5D62A, 0x43642D18, 0x60DE46E7, 0x29A9D249, 0xFCEA08ED, 0x393A783A,
    0x87A18B27, 0x47277139, 0xA638939C, 0xEE0B0598, 0x0E29E233, 0x15BD3DD4,
    0xAB4B7EE9, 0x692E1650, 0x54B7839A, 0xDE75D65A, 0xEC456952, 0x1EC988FC,
    0x09AAE6F6, 0xF0F0DDEA, 0x4115EB4B, 0x2BD697CE, 0x58976372, 0x30D6A3D7,
    0xB0FCC0EA, 0xFCC1E88B, 0x9D6766E4, 0xF06F20D6, 0xB2168B94, 0x16896EDF,
    0x305DDFB2, 0x88E6C85A, 0xAD90B47A, 0x7BD28D1F, 0xFCC158A8, 0x2D85A97C,
    0x66C14FC1, 0x206FC887, 0xB2FB815B, 0x707C3D3F, 0xEDF38A69, 0xA12DBD67,
    0x8A5BB69B, 0x84FAF5EE, 0xC6A4158A, 0x6CD81B96, 0x36496351, 0xA3A6FAB4,
    0x11DA3C85, 0x696820A5, 0xE7CEB353, 0x9E0BB5A6, 0x3E54D69B, 0x3D83B0DF,
    0xDE8ECDCE, 0x9E8F0A78, 0x787DAF43, 0xBC996FD4, 0xFD675340, 0xD06B41C6,
    0x725D33B0, 0x0D77AF78, 0xBDCB1B93, 0x2B92E27D, 0x5C2B1A5D, 0x4A3A86B0,
    0x5BB5FA8A, 0x29C12F4A, 0x0DC749F4, 0xAA4F6E34, 0x45DEC879, 0x79CF759D,
    0xEC2D7E57, 0xAE59AFD1, 0xD73AFD41, 0x35858760, 0xDD85871C, 0xDEF64D9C,
    0x0DCAF537, 0xB86A38BB, 0x2ECA72CF, 0xA50DA1E9, 0x3B6B1A22, 0xB39F56F4,
    0x25D18B69, 0xFD29E817, 0x8ED47B4C, 0x2615D313, 0x99CF5E5B, 0xF7BDA16C,
    0xC7C94AF1, 0x0D0C792A, 0x5CECAD3A, 0xAB1EF958, 0x1D0C6E9D, 0xD4FC174E,
    0x274192AB, 0x9C7ECE3F, 0x064E8D0D, 0x54F74E1D, 0xE86CEE2A, 0xE872586C,
    0xAC6CEE64, 0x58DCE354, 0x5683254F, 0x58C2EA96, 0x7CE868C9, 0xE9C2A4FC,
    0xE0BA92D2, 0x14D69527, 0xB8FCA3EF, 0xD0D9C9C5, 0x4173938F, 0x16174E83,
    0xAA5A57AB, 0x1A1C9695, 0x163671FB, 0x585E0A9F, 0xE358C2F9, 0xCA68C97C,
    0x0F752D2F, 0xD064A93F, 0xB38FC2FC, 0xD2B18C6F, 0x3A0C7BE5, 0x657A9F39,
    0x9C6BCBA7, 0x43271E8C, 0xE1870E83, 0x863C7B92, 0x592CAD06, 0xA792A6AC,
    0x8327671F, 0x43A746CE, 0xB9C3A327, 0x4AC741A1, 0xCE8D0686, 0x1E8D064E,
    0x0E4E25C3, 0xA1D38B73, 0xA6F9D1A1, 0x53E57392, 0x70BE71AF, 0xA0782F32,
    0x97E516A7, 0x5F83AFDD, 0xBE7271BE, 0xAA94F271, 0x74E1C9D0, 0xC4BCECE8,
    0xD61B2B18, 0x2AFC153D, 0x3D695959, 0x7CA9AECE, 0x9BF05F94, 0xA9D0FCA3,
    0x1D7EC5B9, 0x13DEE4FC, 0x2B29C963, 0xB2B41A19, 0xE627BD64, 0xCD8CC54E,
    0x58C6DE6B, 0xDEA6A4BC, 0x2C97E0BE, 0x192F9C97, 0x1EAE7274, 0x2EFCEA5F,
    0x53DD2FCA, 0x66B4AC61, 0x5A57D75A, 0xB3B38F72, 0xE7765631, 0xAC636FCA,
    0xF82BD15C, 0xAEB25DCD, 0x0AA4F12F, 0x0A9DC17E, 0x6DEFC13D, 0x06FC1DCA,
    0xBA742D2B, 0x74E8D064, 0x9EB1AB53, 0xB187CAC2, 0xA058C6DE, 0x94F8F253,
    0x5D385695, 0xD0682A72, 0xC960F9C9, 0xB38FC385, 0x5861C9D1, 0xD15A5F94,
    0x97E0E377, 0x1A1B9C6E, 0x86E64E8D, 0x6E3F28B7, 0x6D58F271, 0xD3A0C9D0,
    0x53C9C7A1, 0x47535358, 0x6FCA2DF9, 0xD52CACCC, 0xE81F4185, 0xC97CAF53,
    0xD2FC17D9, 0xA5F393A1, 0xE9D95EA5, 0x1857A9F2, 0x1B8A7A34, 0x9F8B0A9D,
    0x74165B38, 0xBF0571EE, 0x4DF945EC, 0x60F753E5, 0x8325D52C, 0x4E3DBF1E,
    0x65A34F46, 0xE4AF53E5, 0xE9C4B4EC, 0x3D064A9E, 0x71EF9537, 0xD064AF38,
    0x958AA54F, 0xD0682CFC, 0x686874E2, 0x1EB0B9D0, 0xF3938F67, 0x162B3F12,
    0x38DF38B7, 0xCE4E8D1B, 0xBE569725, 0x29E9D9C7, 0x9E9D7E74, 0xE4AC0F42,
    0xD3B38FDC, 0x2DD38545, 0xA537E0E9, 0xA0C9592C, 0x92E565B3, 0x9D057E0B,
    0x173B38FD, 0x682B3256, 0x61CD69D0, 0xFCA39BE5, 0x06FC13C6, 0x993A1F2B,
    0x793A165B, 0x593A36FC, 0x9D8674ED, 0xA1D2B18D, 0x6552E97D, 0xBF074F43,
    0x365C9D52, 0xB4E25AC6, 0xA6E9D0A4, 0xA341A1A2, 0x0EE4B193, 0xE741A0EB,
    0x17CE4E25, 0xF4192E9D, 0x4D5606BB, 0x58C3E725, 0x385CD69D, 0x5169C39D,
    0xF9D0C97E, 0x47BDD2A6, 0xAC68AAF9, 0xF05DF945, 0x56974E83, 0xA765D56E,
    0x0F9D0735, 0xDF2B1A9D, 0xB2D7E353, 0x35C31A9E, 0xBA5EFDC7, 0x64E27E29,
    0x58D95A74, 0xA18FD372, 0x2F93A341, 0x353D61F8, 0x5A56564E, 0x6771F2AC,
    0xF393B3A3, 0x874E9BE5, 0x4B2B46E6, 0xB8A6F975, 0x731FA0B1, 0x3ECE3D63,
    0x5D2B18D0, 0x5630BE72, 0xB7E4AC72, 0x2EAB4193, 0x173A1D3B, 0xD0D95A56,
    0x3D49738F, 0x63431ECE, 0x43738D49, 0xE27E0E83, 0x074AC64A, 0xDC973A0D,
    0x3431ECE3, 0x1614F677, 0x312C6834, 0x4F58DCBF, 0xD392B185, 0xB4ABA54D,
    0x2572BD4E, 0x9D0686A7, 0xD0682D2E, 0xD4EFC173, 0xED5BB2AB, 0xA0D1C574,
    0xFC174EC5, 0xBF29B9B2, 0x29BF1D52, 0x5FA1F16E, 0x3468BF07, 0x37E0E3F4,
    0x2C5695AA, 0xC97CE378, 0xC9C5B9A0, 0xE3F28EF9, 0x3A0D0527, 0xE83254DD,
    0x83436A54, 0xE3D58B4E, 0xA18D656C, 0xC7E4E3D1, 0xD0D4E1D9, 0xDCC9D1A0,
    0xAB258C68, 0x4F671F92, 0xB4D4FDBD, 0xD2B1A0DA, 0xFDCD9C7A, 0x58F41938,
    0x9CF41856, 0xFD0E9C38, 0xEAF671FA, 0xE5316E29, 0x12BBE06B, 0x38E06BE5,
    0x206BA7C3, 0x65C09F3C, 0x965E0661, 0x8D91D95B, 0xFD1D7C16, 0xF7B7EF7A,
    0xDBF5726E, 0xF3F77A92, 0x1DE88ACA, 0x6ECDBAEF, 0xF0333520, 0xDE47A0EA,
    0xF6B42D06, 0x5A0AEFCA, 0x33623642, 0xB3475FA3, 0x612F0A9B, 0x6E781535,
    0x9E78E8F8, 0x1EB76FD6, 0xB570728F, 0x6D372874, 0x87B650C1, 0x7D2284B5,
    0xC8A812EF, 0x2A04B5BD, 0x15E9986B, 0xFD132D5C, 0x9371DEF0, 0x9D605F8E,
    0x5DA92F34, 0x78F5D9F0, 0xDEF6605F, 0x13D9D425, 0x72D91357, 0xE5B3B978,
    0xCB6572F0, 0x772C3DB3, 0x7CEF392E, 0xE4F41F94, 0x279687DB, 0xC85AE4D7,
    0x7B4A0D73, 0x7943D5E7, 0x813D5E4F, 0x5E6D792D, 0xF2BC7A2B, 0xBF4E04BB,
    0x1DD648E2, 0xB9D63D66, 0x7A3E9B25, 0xD30F6E09, 0x95D8E3A5, 0x5994B6F8,
    0x25DFAB78, 0x1AEC3C30, 0xEDC2D056, 0xBB88D161, 0x5FBD0225, 0x6A79044F,
    0xF4B18B75, 0x359F05DA, 0x2BDA25AC, 0x90F585A0, 0x0CE6F027, 0x6B9AEF7A,
    0xA7DB36F0, 0xF2C37834, 0xA4960DED, 0x153FA5E0, 0x483B0F9D, 0x9CC2D7EF,
    0x34F3B9A4, 0x8C35896C, 0x86B14A57, 0x2A569AF1, 0xBC11D542, 0xD493A72F,
    0x6F4A91D3, 0x0F6D2F21, 0x24B0D26C, 0x7A0B6079, 0x6DE5B03C, 0xBE1A4DD9,
    0xE3A7A927, 0x2A633335, 0x96CEEF63, 0x7B6C2534, 0x54531F58, 0xC58FAC25,
    0x58FB02DB, 0x0F77B590, 0x4DDE616C, 0x94E238F6, 0xA66814ED, 0x05B78EEC,
    0x30748F2A, 0x616AA86F, 0xB55432B2, 0xB9419A04, 0xCB66681C, 0x3BCD825B,
    0xAE6F3347, 0xE6F320B2, 0x87BBD1B5, 0x2D81E3D7, 0xA9C726AA, 0xAA1C5925,
    0x8EF4894A, 0x56912C35, 0x4C6C2554, 0x36F1C2AE, 0xBB3D81E9, 0xD96C0F49,
    0x4F606EC5, 0x1D3D48AE, 0x92EF2163, 0x79902BC7, 0x5F04B53B, 0x2D48AEF1,
    0x31474D8B, 0xD11733D6, 0xB10E7BCC, 0xB094F799, 0xC29F5D64, 0x0A67AC62,
    0xD29EA5B1, 0x561686F5, 0x1EB0B40F, 0x703C24BD, 0xEEF30F49, 0xA8E99E91,
    0x606FBC47, 0x607B784F, 0x4A81D90F, 0xBC5E166D, 0xE9D22CC5, 0x52463648,
    0x44F590B5, 0x8B0F6CF2, 0x161EDC12, 0x3BCCC64B, 0x3522BE4A, 0x798BF251,
    0x85F48947, 0xB59206F1, 0xD8794A37, 0x40C14A0D, 0x51427C33, 0x89AC3095,
    0x9E9205B7, 0x643D9367, 0xA76C74CF, 0xE8DB589A, 0x81605705, 0xEA25832A,
    0xF02C64A9, 0x9ECBEF68, 0x2EAD9D02, 0x053DD430, 0x5EB3165A, 0x75AE3B6C,
    0x054EA159, 0x6CFF418A, 0x5A05A075, 0xE6C78058, 0xD54D43A8, 0x4D426F4D,
    0x814E0FD5, 0xB41B5096, 0xF4F4372E, 0x3925BCA6, 0xDAA4FC9E, 0xD52E723E,
    0x32D89376, 0x6A5EDFA5, 0xA98A4B0E, 0x13E561F9, 0xF2B07F35, 0x4FFCDA23,
    0x9B5B8024, 0x6B58A7FF, 0xE6B03FF3, 0x8CFFCDAC, 0xFFCDA8D0, 0xB4BC0104,
    0xF4275FF9, 0xFB8C5DF9, 0x25289F3D, 0xA077BDB4, 0x32588DB1, 0xBA16BCFD,
    0x696BC4FD, 0x0B5F0AA5, 0xB5BC4DF4, 0xBF5780F0, 0xEB41D662, 0xFD033295,
    0xEF598BBC, 0x66DD77C0, 0xB8AEF12D, 0xBD6A08E9, 0x46A1C0B1, 0xE528FB5E,
    0xA16EC4F2, 0x8E79CBA7, 0x0C6D3E1E, 0x0373DBBA, 0xE039BEE9, 0xF21774D5,
    0xE72B481B, 0xEF5893D7, 0xD61E5B23, 0xD9B10EBB, 0x60B0D739, 0x20D6B417,
    0x9976702B, 0xA88D1CB5, 0xA1E258E9, 0x6DE178DD, 0xF5E5B26C, 0xBD9BA524,
    0xD63949A6, 0x4E51F0FB, 0xA56EF332, 0xADEF5F0A, 0x0B5E0D48, 0x5B4F62AC,
    0xB606F8A0, 0xE76165C0, 0xAFA14CE1, 0xECDAF127, 0xD0AF0606, 0x946FBD0F,
    0xFD3BC39B, 0x817D03C4, 0x956D779E, 0x67A04B9E, 0x0378E41F, 0x36F61AF7,
    0x5722D94D, 0x62D1D988, 0x4DD34CBC, 0x685B93F4, 0x0972C1CA, 0x45CEC342,
    0xDEA5A05E, 0x745B2168, 0xE84B4E0B, 0x87497147, 0x6F7E57BE, 0xB7A52EA0,
    0x02CD23E0, 0x9F7A5A6B, 0xB2D87687, 0x839C2C3D, 0x2F06F5EE, 0xC181BF5D,
    0x1DCBC40B, 0x49EBE0A5, 0x2D4A1481, 0xEFAE963D, 0x7B2788EB, 0x6EF629B0,
    0xF8A0F87A, 0x5A2E06E6, 0xF4914D33, 0x646165C0, 0x20E92E0F, 0x0E0E2E5B,
    0x58E2C558, 0xD206D023, 0xCBF50401, 0xA45683D7, 0xE95B0E3B, 0x33A7FEC0,
    0x2FD81623, 0x4D8C3F13, 0x1C60BBBC, 0xFA952BF6, 0xEF09B21F, 0xBC67B073,
    0xFC94A1CF, 0x72BCDCA8, 0xE2ED39AF, 0x17DD53FB, 0xEC35A95F, 0x66C987E2,
    0xD1F63F17, 0xBB0FE174, 0xBE896E53, 0xBCE8FCE9, 0xF8DA62B0, 0xBDE8EC97,
    0x0B461FE3, 0xD11BEFD9, 0x7A82B642, 0x8D34D370, 0x96F165C8, 0xD3FCCF66,
    0x56B38901, 0x4D9B2E6E, 0x633698A0, 0x33748A13, 0x53BB0136, 0xB6ED707E,
    0xE560574E, 0xA67B2696, 0xFB27E758, 0xEC330B76, 0xCEF24F40, 0x15A73A4F,
    0x12E5F1E8, 0xDC99E456, 0xFC4F9766, 0xD9F56E26, 0xB35FA1C1, 0x8BC1DBD7,
    0xEA72FCA4, 0x7B24BCC1, 0xA495E922, 0xE0E848C8, 0x071507A9, 0xCABF67EE,
    0x516D86ED, 0xD7C333F6, 0xA371825B, 0x860BBBD4, 0x758B485E, 0xC1DC85E8,
    0xADE40F5F, 0xF5B0252B, 0x54DF6AD3, 0x56514DE8, 0x93947ECE, 0x316BBA40,
    0x13633AEB, 0xCFCEC8FB, 0xA902BCE9, 0xF81BC158, 0x60F182EE, 0x7DB8E2BF,
    0x4A2B4FCE, 0xB2168C53, 0xADFD4075, 0x3373B435, 0x606E9136, 0x427D90B4,
    0xACEC85A3, 0x4A9DA903, 0x852EB4F7, 0x9A628D35, 0x1E1DD5B2, 0x5D618D46,
    0x67D4FCA7, 0xEA37DF5D, 0xD3B4DD0B, 0x3FD67621, 0x6F9C509B, 0x7EC02C3F,
    0x146D3743, 0x4CD92C4F, 0x91367CFC, 0x2C1E4F9F, 0xBEB59B01, 0x85CE91EB,
    0xF805B20D, 0x52EF5177, 0xFDE7A394, 0x361C76D4, 0x26FBDCAF, 0xB4DF64F9,
    0xA412F44F, 0xB42D82DC, 0x8ADBD0D6, 0xBB8E41F4, 0x5A50371D, 0x283D8B7F,
    0xE6F03766, 0x2D79319B, 0xED6F5ED2, 0x7AF4CF23, 0x5EB599E8, 0x9759DD82,
    0x17934B0E, 0x5AB2D7E8, 0xA725D94E, 0xCE79D61B, 0x3D0372D9, 0x9D752D87,
    0x470EC176, 0x9B9A3B34, 0x2969BD35, 0xC296EA3C, 0x4B2BF64B, 0x707DAEAD,
    0xEA2F79C9, 0xDBD1C739, 0x1EA0AC67, 0x79EA0AE3, 0x4D7BDEDE, 0xB9D02DBD,
    0xC705DADE, 0x33D074AF, 0xA9A0B475, 0x15A673D1, 0xE9536A3D, 0x852A635C,
    0x88B4AD35, 0x8F49CAC5, 0xA9C961BA, 0x96F597CF, 0x9CCB45F3, 0x6DD781B7,
    0xA64B23EF, 0x748B07B2, 0xEB1B88EE, 0xF4B92DDE, 0x7ACF0596, 0xBF58B507,
    0x85EB3AC0, 0xC98B6A3D, 0xB778719E, 0x2C23854C, 0xAE4C3517, 0x42C1E2D0,
    0x9439EEB1, 0xE50A2F26, 0xA3C9B03A, 0x87936A3D, 0x2B296F2D, 0xD7BE4AAD,
    0x077374E2, 0x6374AE8D, 0x6743E1D0, 0x69ECBF07, 0x1E0FCA2C, 0x85C96216,
    0x78A4BD75, 0x8DCF1BA7, 0xB37D06D5, 0x045F671E, 0x3A0774BF, 0x2C72712D,
    0xE08B9BE8, 0x76AC9537, 0x1687E0BA, 0xD4E53D63, 0x792AF9C9, 0x4549F82A,
    0xE2D2B7E7, 0x785F1E27, 0x2C6378A6, 0x4B185968, 0x3E5D3A16, 0xB18D958C,
    0x683E5558, 0x9C4FC1D0, 0xC71F896A, 0x3DF94C7A, 0xE5AFD975, 0xD4D631B2,
    0x2F6771DC, 0xEECBAAD0, 0xA3AA7DE3, 0x4582D2FC, 0x2AA5A5F9, 0x594FB566,
    0x2E9D0C95, 0xB1A0D07C, 0x0E58C29E, 0x17CE8327, 0x82E7B2FC, 0x85CAAC1F,
    0xE5F82B0D, 0xE0BE8582, 0xA7C78F37, 0x94DD1E5E, 0x2FCA3F1F, 0x0683DEEA,
    0xC53DF94D, 0x55D52CAC, 0xD38745F2, 0x712D3A1D, 0x358C615A, 0x61695C9E,
    0x46E4ABE5, 0x783B2EAB, 0xDEFB16BD, 0x7E4E58C6, 0x3A94EC4F, 0x587E51F8,
    0xC6DF9DD1, 0x92D2BC58, 0xF2765D67, 0xE354BA74, 0x49F82B4B, 0x7B9485A5,
    0xEA5F83B2, 0x33C4A4BC, 0xEAA4BD1E, 0x85527E3D, 0xC1D4ACA5, 0xE0EDF92F,
    0xFC175C97, 0x6F5175C4, 0xA7AC2C63, 0x93897896, 0x708E8341, 0x5F82B05E,
    0x9AC6343A, 0x92AA7AC2, 0x1B3A1F2B, 0xDAF5A563, 0xC5EA7CE3, 0x3078569D,
    0xC6346BD6, 0x592F0592, 0x92E5F656, 0xD652E4AB, 0x6A792B18, 0x85668754,
    0x82A6B0B1, 0x38F5AA57, 0xC5B9A2FB, 0xB98B18D9, 0xC78B4198, 0xF82D2A93,
    0xE9585A54, 0xB2FCA2D2, 0xE4BA5F83, 0x7D9C95DC, 0x9C6B25EA, 0x064A9F0C,
    0xA341AB0D, 0x67A077C5, 0xD7BF0765, 0x9C97E0E8, 0xC4BD0E9D, 0xB2576F53,
    0x14DF2BD5, 0xF65697E5, 0xAE4E15A5, 0x8FC97E0A, 0xE5325563, 0x17D03AA7,
    0x058C7EE6, 0xB25D630F, 0xC9E4E82C, 0xFC1C974E, 0x12D3875E, 0x8324F61F,
    0xAEAD9C7E, 0x52B187CE, 0xB9D7AC63, 0x6A9AA553, 0xBE56958C, 0xA72570E4,
    0x613C7B95, 0x6F05E0AC, 0xF770F40A, 0x74E3596B, 0x97E09BAA, 0xE54F754B,
    0xA9F24F43, 0xB99A3257, 0xED479392, 0x8C62C974, 0x4AF16A95, 0x0C4B3D2B,
    0xD064E2CF, 0xAC54D6A9, 0x5A0D0D4A, 0xF7CE4A9E, 0x97CBF054, 0x18C5AF7D,
    0x63D4F40B, 0x2CAC958C, 0xB2B335D5, 0x583A92D2, 0xF735F9D8, 0xCF2716BD,
    0xCBF05F38, 0x2FCA3E66, 0xB2B40EF9, 0xBA92D3A6, 0x97E0ECA8, 0x4D64E9CA,
    0xD0682B35, 0xAA9F94DC, 0x389F3152, 0x65F4F415, 0x95CC7E53, 0xF83B3A16,
    0x2A71EBBD, 0x274625AC, 0xAB1AF257, 0xE0BABA57, 0xD3A07CC7, 0x2B56539A,
    0xAB731D2B, 0x207A06BA, 0x0F410358, 0xCA1BAD54, 0x35D546BB, 0xAEAA4AEF,
    0xB3536719, 0x5FB78FCE, 0x35905B67, 0xA0F6E32D, 0x4AAB335F, 0x66721AFD,
    0xD7C0B6F6, 0x16613DEB, 0x6B02E57C, 0x2F204BBF, 0x5AE45A85, 0x83A503A8,
    0x4586A3F2, 0xD0D60DF7, 0xD0B40CDA, 0x6907B21A, 0xACDCAE05, 0x6B125B27,
    0x81EC3A94, 0x4B14C3DB, 0x66E5096E, 0x4BB2987B, 0xED76198E, 0x12EC0F82,
    0x11D78678, 0x5DF9DC3D, 0x4587B902, 0xA2F9CA8D, 0x6F60D546, 0xF98B5479,
    0xB555B7A8, 0xA225B7B7, 0xDAD0DF66, 0x996D17B3, 0x097796CE, 0x7A8ECDCC,
    0xDDB88BE7, 0x825EA0D3, 0x9253E0D3, 0x9DA944A6, 0x5572D06A, 0x744F8F7A,
    0xEA8E53D3, 0x134E7ABC, 0x48FD06DF, 0xF0C164D1, 0xCA0E95A0, 0xB4753EC1,
    0x7B8C12F5, 0xED452E7B, 0x1AD8D382, 0x6DE46EDE, 0xBDA9416C, 0x815941FB,
    0xF2F82BDD, 0x0DBDBC99, 0xD5C13C9B, 0x37DEE41B, 0x0BB55D50, 0x5E72A93E,
    0xAC634AD3, 0xC84FBB61, 0x5542B94B, 0xB88DB13D, 0x96C9A072, 0x1D3D6431,
    0x986B1DDE, 0x5925B3A5, 0x23B7987A, 0x97B7B591, 0xAD7B0F6C, 0xAAF2CC62,
    0x779EA92C, 0xD6A956B1, 0x61EDC0FB, 0x4F739C4C, 0xB0548B1F, 0x72B2D937,
    0xA94EBF4F, 0x2B799A71, 0x94C35896, 0x94A91155, 0x29691755, 0x56F337B5,
    0x14C3C24A, 0xD061EDA9, 0x5437982B, 0xA80E9E75, 0x70DE60EA, 0x40F7AE97,
    0xDC3790F1, 0xB70F52D9, 0xDBDD9A04, 0xAC376681, 0x7B239EA5, 0x76AA987B,
    0xECB24B60, 0x618927A8, 0x30F2254B, 0x545649EA, 0x349B6C25, 0x76FDD8BC,
    0x14EECFBC, 0x0CFDA5E4, 0xC5B9DE64, 0xA59725A9, 0xB163E753, 0xDE62E586,
    0x7A3BD93D, 0xFD11D393, 0x16546B3E, 0xCC6129E8, 0x96CB379B, 0xF52D8154,
    0xBBF4CF48, 0xBBF606E4, 0x82A472A4, 0x97908F52, 0xA76F7AE2, 0x1DE646F0,
    0x2C2555BD, 0x8E90B5D2, 0xA3BCC382, 0xC0EF30D2, 0x5813D83E, 0xC503BCC2,
    0x866B1CC3, 0x9BD90779, 0x4A2514BC, 0x9125866D, 0x60A7487A, 0x4205A4DE,
    0x81EB6923, 0x74E0764D, 0x9B52A054, 0xC8B92D61, 0xF63A476F, 0xA0DBD7BC,
    0x9FA875E9, 0x66DEEAA1, 0xEAD7386A, 0x8FB25829, 0x1AAB1436, 0x4DD164AC,
    0x4B82C9D5, 0x7A8724FD, 0x146A4FBD, 0x176933F5, 0x0DDAA753, 0xAB77A8E7,
    0xBD948AAD, 0xC59492DF, 0x1DAAC0B0, 0xF4A67C6A, 0x0AA9EAA2, 0x8BD66294,
    0x2BD6EF71, 0xD45BA897, 0x2302EA1D, 0x18175515, 0x074EF40B, 0x037CAED6,
    0x306DD14A, 0xDE4A5655, 0x36E56170, 0xD6469B94, 0xAB344F4A, 0xD594737C,
    0xDC4A4634, 0xDC4C8E92, 0xBC4C8A92, 0x82F66A25, 0x6D7A489E, 0x66F26934,
    0x0D4A1A8E, 0x682DF8B3, 0xDC4E8656, 0x5FAF7DE3, 0x31D4987B, 0xF68DDF23,
    0x5E3578A2, 0x5EDDDEEC, 0xC9A057A1, 0x1EBF50F3, 0x2F5ED6E7, 0x0F6F15EE,
    0x0EDE7EEE, 0x56F3D77C, 0x4AF81BA5, 0x17796F21, 0x8B51E234, 0x74B50F49,
    0x5E0B504B, 0xC396E50B, 0xF41BF287, 0xDEB343D1, 0x3737AF74, 0x4E0BB5A3,
    0x81D4CAD3, 0x696EB2B4, 0x48A6835A, 0x69A8E24B, 0x6826BD2D, 0x2A0E892D,
    0x95235347, 0x0EC1D175, 0xCAB37A1E, 0xF4D689BE, 0x838A668A, 0x22D28D5F,
    0xA45A5396, 0x0F1B94A5, 0xDF82E56D, 0x3A70E540, 0x3907D942, 0x2E4BB286,
    0xB605D950, 0xDE125284, 0x4F4148AD, 0x18754B28, 0x0DE0F60B, 0xD8CCC584,
    0xCB68A503, 0x25A1D703, 0x42D607B8, 0x1F98FB5E, 0x83BBD85E, 0xE6DF6617,
    0xBBE61ACF, 0x2F14DDE8, 0x6A9F6FB2, 0xE92DE9CD, 0x6D9EF290, 0x3DBCD3EA,
    0x8F6F72B4, 0xE1DB11D6, 0xA51B7BBD, 0x774DDEDE, 0x8BE7DD0B, 0xB0F97D9A,
    0xC6A4B659, 0x94FB8DC8, 0x2D8135CE, 0xD27AF8D3, 0xB4FB2A34, 0xA96815E9,
    0x53E4C6CD, 0x7426F072, 0xE74F8B4F, 0xFD0F4FB7, 0xAF45BA6A, 0xED2D787D,
    0xF4D2258D, 0x41E90EF4, 0xAF2690EF, 0xA4D690C1, 0xAC738790, 0x3E794181,
    0x68394186, 0x14BF0751, 0xC4E5C1DC, 0xEEE06E39, 0xF61AFD08, 0x3BBEB40E,
    0xBD7C2D02, 0x1DBAC681, 0xB1D86258, 0x6304BD74, 0xB0796C09, 0xF213A3B3,
    0xD1E34A36, 0x8A7818D4, 0x82B079E2, 0x3BD06BDF, 0x40F4105B, 0x52340B58,
    0x633601DE, 0x15E41037, 0x86F02F20, 0xCDE01815, 0xDCA684B4, 0xB38F3E1C,
    0xD5EA35B5, 0x75EB9472, 0x85E8D4A4, 0x51F92D86, 0x96FD50E4, 0x00E8ACA6,
    0xFA26965E, 0x19B4DBEA, 0x850CC16D, 0x008C5AEE, 0xB16BBA01, 0x6C715A09,
    0x3A9D2E82, 0x11987E75, 0xCAF04D8B, 0xF5261F9D, 0xB1345B16, 0x64177789,
    0x3F29B413, 0x4AC13669, 0xFE3AAC55, 0x6CCAAB21, 0xB5F92942, 0xC8F92944,
    0xDFCA915B, 0xDFCA9149, 0xDFCA915B, 0x6FE548A2, 0x3F9522B5, 0x3F9522B5,
    0x7F2A452D, 0xFE548A8A, 0xF9522A8C, 0xF2A456B3, 0x9522B657, 0x9522B43F,
    0x2A453F3F, 0x9522B3FF, 0x2A4531FF, 0x548ADBFF, 0x548A37FE, 0xA91429FE,
    0x48A3D3FC, 0x48ADBFE5, 0x48AD9FE5, 0x22999FE5, 0x456E7F95, 0x8A7CFF2A,
    0x1479FE54, 0x2973FCA9, 0x50E7F952, 0xA8CFF2A4, 0x543FE548, 0x987FCA91,
    0xB4FF9522, 0x70FF9522, 0x51FF2A45, 0x4FF95229, 0x1FF2A456, 0x7FCA9152,
    0xFF2A451E, 0xFE548AE2, 0xFCA91495, 0xFCA9144B, 0xF9522B75, 0xE548A2EB,
    0xE548A72F, 0xCA91541F, 0x9522983F, 0x95228E3F, 0x548A6A3F, 0xA9150BFE,
    0x522B49FC, 0x48A893F9, 0x915A0FE5, 0x453C1FCA, 0x54907F2A, 0x1F07F2A4,
    0xD39F98D8, 0x43FC6361, 0xC4D9B95E, 0x7D3587C5, 0x5E3777F1, 0x17815DFC,
    0x2F46FB98, 0xF669AEA6, 0xA4209B0C, 0xB367530E, 0xF1E3F607, 0x2592FCA6,
    0x795F9CF7, 0x95DE913C, 0x7A47C5B8, 0x3164AC8A, 0xBD2C9DAD, 0x4DCEF5CF,
    0x8C3A9424, 0xC82ED644, 0xEE3748AC, 0x0D1E3408, 0x85E87AEB, 0xF3529FA7,
    0x81BB0F6C, 0xDBECB374, 0x794FB8D3, 0x2168FF86, 0x815E0947, 0x1367E053,
    0x216899EC, 0xB5E985A7, 0xF1456D61, 0x583782EC, 0xD620DD7A, 0xC20B6B14,
    0x16D1E07D, 0xC62D774E, 0x11DA3C9A, 0xBA689E54, 0x66C1EC10, 0xC62D7741,
    0x20E33F22, 0x0AF7D1F5, 0xBB631E08, 0xE06F03B1, 0x39A34BBB, 0x1361F898,
    0xEA4F99EC, 0x67D4CF13, 0xFB656601, 0x52817A0D, 0xE183D863, 0x95E4BC85,
    0x66282D4A, 0x51C5792D, 0x5A57E54F, 0x5F59CA37, 0x1222EEFD, 0xAD45D32E,
    0xF3AE839D, 0xBD04A56B, 0x6775A9B3, 0x1ECABED3, 0x3D25C8AF, 0xD2D070AE,
    0x9A43B3BD, 0x74BAD29E, 0x6A2C9B44, 0x83AB5934, 0x554A6E3A, 0x4E96A1D0,
    0x1D4B19DB, 0xED5A17AC, 0x3BCA16C8, 0x7D68BED7, 0xA38E7DC1, 0x5F959FB7,
    0x8D3D9339, 0xB635A1E5, 0xEF5D5AB4, 0xFCA6DEF5, 0x08294F1A, 0x48A7B0CF,
    0xB38DE36F, 0xB6F9C5B1, 0x1EB172A7, 0x31DDF58F, 0x9BAC5A45, 0x5C316915,
    0x737CB961, 0x0AC1E452, 0x16C63593, 0x9B92C2E7, 0x22C1E942, 0xF64D1D2D,
    0xA5B26D1C, 0x725CAEC6, 0x1BC31EF9, 0xF94C7AC3, 0xE592B3C9, 0x2A7BA71E,
    0x74ECAA56, 0x87E51705, 0x31FA14F5, 0x8BE63E56, 0xCAAA581E, 0xB5EBADCD,
    0xA9EA8D78, 0x4A9AF564, 0x4B9E4E15, 0x2A54F5E6, 0xBC53586C, 0x4F4185F3,
    0x9D5D56F1, 0x0DF83A38, 0xCCD02C2C, 0x2878D794, 0xBCA3E8AF, 0x10B29F82,
    0x3B52A563, 0x3C6A7A5D, 0xE5C958F9, 0x431E2D7A, 0xE872C78B, 0x2B4AD51A,
    0x2C3AC5F8, 0xBC74E9E8, 0xA70ECAD2, 0xE61C9D03, 0xA9DF464E, 0xAC727257,
    0xC5A0C9C7, 0xD27A2FA9, 0x25A76312, 0x9C9C6F05, 0x0E8D053D, 0xF057037E,
    0xBAC61F1A, 0x99B38F74, 0x29F30F5F, 0x7B9AFD0B, 0xD49F9A0C, 0x3B1A1DD4,
    0xF97CB9AD, 0x7E3D65B8, 0xD064BA57, 0xC56173AB, 0x1F2EAB42, 0xC7E4BE56,
    0xE33CB185, 0xAFD064E4, 0xD3A36567, 0xF0729ECA, 0xDF847292, 0x92B29EF5,
    0xD525E3DF, 0x0EAC636F, 0xB7EE3F07, 0x2731F8A4, 0xEB0B4AF3, 0xF92F8F40,
    0xD0E9DBF1, 0x494FC6F9, 0x1525E74D, 0x2746CA96, 0x96CAC2C7, 0x6A9C7AC3,
    0xC7AC5789, 0xEA7AE569, 0x74173F28, 0x6CB96E3A, 0x1755B97E, 0xE560F19E,
    0x8E4B1B7A, 0x697E0AF5, 0x562D063D, 0x9BAA5BD5, 0x2B1DE29B, 0xF731FA1F,
    0x4F587CEB, 0x4BA56785, 0x8C6C7A9E, 0x799B8F05, 0x74D53B8A, 0xC61F45F2,
    0x5F60EB4A, 0x8525E5F4, 0x2B96E635, 0x562E958C, 0x8562B95A, 0xC58E3DD3,
    0xD3594F9C, 0xF958E863, 0x78D7AB1E, 0xBD5A03D0, 0x9AE55392, 0x38F40B4A,
    0xE3782C5F, 0xD4B172D7, 0x9D9D192B, 0x3A312F2E, 0x1A34DF3A, 0xD3A0555A,
    0x2D1A0C7A, 0x3A392B07, 0xF83A365F, 0xB4EE6BDD, 0x3F13F35E, 0xF65D53BE,
    0x3BECE3DD, 0xCAA71AF5, 0x31EF9525, 0xD0A7BE73, 0x55517863, 0x270E8169,
    0xC5A70BA7, 0xC9DA962B, 0x587864E8, 0x871F8970, 0xF9C3B993, 0x855989F8,
    0xD1C2F92F, 0x4B86F16F, 0xD4E3DF2E, 0xA5546FC1, 0xC958C6AA, 0x4FA3A072,
    0x7C6FA16A, 0x3D5F9458, 0x59EA97E6, 0x0EE6836A, 0xA353A367, 0xB3A07C9D,
    0x0BE740E7, 0x4F6743A7, 0x0D864E3D, 0x7E6D4A6F, 0x6561F162, 0x71EB324F,
    0xA177AC2E, 0xE358D9C5, 0xD51C4B74, 0xE3E7676A, 0xA324F19E, 0x3C67A2A7,
    0xD0B188D1, 0x7AC393AA, 0x4E72CA6A, 0x4F927B0D, 0xB98FC959, 0x1BE73163,
    0xED47894F, 0x8AB32709, 0xB40B0F05, 0xC1C7BDF8, 0xA54A9EAF, 0xA6A97E6E,
    0xF999B3B9, 0x1D97CBA5, 0x631B398B, 0x59FB3A35, 0x4BC1638F, 0xB35EAD06,
    0x562BD5B2, 0xACF254D4, 0xF0D85CEC, 0x4E3D5F82, 0x658CF1BE, 0x5D568161,
    0x7E53333A, 0x14F49AEF, 0x7E625E77, 0x3DD3AC53, 0x2E1B9D15, 0xC5EA7CA9,
    0x3B2E5A6B, 0xD4FC385F, 0xB8AA9618, 0xBD4969C7, 0xF752CF3D, 0x5537CBA4,
    0x38712D3C, 0x8D7C1D19, 0xE8AEFD07, 0xE760B154, 0xB7977A9B, 0x1711D923,
    0xCCB57AF7, 0xDE6FB2DB, 0xADEBAFDB, 0xD0B79AC0, 0xA6B2BCF3, 0xF782BBF7,
    0xA6663D43, 0x6F4DDC0E, 0xD09E9B3A, 0xE0D6B415, 0x83B7BCC3, 0xBDCEE12D,
    0xB5B025DF, 0xD06E16C6, 0x76F7BC77, 0xB7B18B24, 0x3DB25ADF, 0xB0D763AC,
    0x948B5D9A, 0x32DD4BDE, 0xE58E4CD9, 0x37C8E96E, 0x6E6F912D, 0x32D62E60,
    0x981682B9, 0xBCEBD0D7, 0x5AE71BA2, 0x529A5DA7, 0xD36F74C2, 0x86176FD6,
    0x7A183DBE, 0xAF037A09, 0x8ACA9B7E, 0x55E50738, 0x7C55503B, 0xC7445D62,
    0xC027E912, 0xB0F13D66, 0x058567E9, 0x4DA0F483, 0xC781BA5E, 0xD49911A4,
    0x8F5154EB, 0x46D79894, 0x78FBCF14, 0xD1CBBF58, 0xA5B26DE2, 0xDDF9D79E,
    0xAD85B6FD, 0xAF32CFB7, 0x16DE598F, 0x30DEF3D8, 0x349AF7EF, 0xA1D3D936,
    0xE56A4578, 0x0E51EA66, 0xE5451655, 0x4C54A2DD, 0x68152287, 0x825E4CE8,
    0x5502DB5E, 0x66E25E45, 0xB37B9BD1, 0xB737EE1E, 0x84F9EB70, 0x7718FA5B,
    0xE7789790, 0xD825E0E9, 0x6F3097C3, 0x24B77A4E, 0x5B67AE4B, 0xFCBB4BC8,
    0x790F771A, 0xF4CB5F69, 0x6D8E61BE, 0xD7B7EBAE, 0x067ECB4C, 0xF30B6CF6,
    0x3BCC2DDE, 0xF6630AAF, 0x496CEF30, 0xF337B92D, 0x8AF9BDCE, 0x725E415C,
    0x9C7AE4AB, 0xE42C62A3, 0xC688E9A5, 0xA51D314A, 0x24BBCCEB, 0x45596F31,
    0x7986E51A, 0x286DED4B, 0xF09EA4F5, 0x20E27AB0, 0x2ADB8EF3, 0xEF309C4F,
    0x1D54C548, 0x531873C9, 0xD1D8C70E, 0x0B0D7B51, 0xAC0EC0F4, 0x66D63A94,
    0xB38DACDE, 0xA0F53C50, 0xA9428E54, 0xE279461C, 0x8D133E36, 0xE074C4F8,
    0x6165A413, 0x616C989C, 0x788B64DE, 0x1F7C0EC8, 0xA48D0CB2, 0xCF93D461,
    0x3C0BD681, 0x6D53A863, 0x0B7CEA83, 0x6FA99B7C, 0x10DBBF7A, 0x260582EE,
    0xEEF50BEF, 0x02ED24B7, 0xD5B3AA8F, 0xBD7C9E4B, 0x3DEBE69B, 0xAA69BB55,
    0x5A8569DA, 0x23E0DB5F, 0x62973BCF, 0x68123D2F, 0xA1B067C9, 0xEF5E0814,
    0xB932A935, 0xEF79EDB4, 0x31A6B66D, 0x54CAD0DF, 0x758BB72E, 0x47DAF584,
    0xE514B75B, 0xFDC82D7E, 0xF7E885BE, 0x7B0DAF25, 0x7793E3E8, 0xB7B04F85,
    0xBC7EE9F7, 0x03BDB4C3, 0x97807B2B, 0xEB4CE2C7, 0x6F32D3F5, 0x72F3E17B,
    0x3DBBDE0B, 0xBC0ADEB4, 0x9C7D1D44, 0xCA6F4F72, 0xBE5372A5, 0x427A7284,
    0xCBEDD377, 0x51CDF741, 0x4DD28A5A, 0x5A53472B, 0xF1982AC3, 0xAC633206,
    0xC2DDED61, 0xEB374A1A, 0x66B66F41, 0x5E96CE97, 0xEBC96C83, 0x5342DCE9,
    0x9A7C0B4F, 0xF650C1EC, 0xC2CA24D1, 0xDEF436B7, 0x025D874B, 0x03791E1B,
    0x1BD7AEE1, 0xB782F18A, 0x3A7E0EE4, 0xC82F9D2F, 0x1B3B2E3B, 0xDF49626F,
    0x19543AE0, 0xDEAA8B2E, 0x1AB55025, 0xA52F2456, 0x96B0DD27, 0xA776C374,
    0x3DB2DE0A, 0x378DBCF4, 0xA7115BB5, 0xECB5345D, 0xB2792DA5, 0x1B3D2F53,
    0xF7AE77B1, 0x1C6B93F6, 0x9AE4973C, 0x5CCF08B9, 0xC1299F84, 0x9650299A,
    0x7774C4BA, 0xAEB60789, 0xE745BA9C, 0x67E95C4F, 0xC51FA8D8, 0x81BD3146,
    0x48F8DED2, 0xEB48F45F, 0x4BD6913E, 0x16F28A50, 0xF212D829, 0xF0ACF4AC,
    0xF9417294, 0x96BC1DDA, 0x6D28A2EA, 0x0E769409, 0x962AEC5C, 0x9627EFAE,
    0xD00BA57A, 0xF4FA3948, 0x2EBD743E, 0x3446C0B4, 0xCCF61562, 0x330F5E05,
    0x0D35B2AA, 0xADA6B653, 0x3C995A39, 0xDBC83AAB, 0xDE1641DB, 0xC31EB240,
    0x0AEF5726, 0x405B1BD0, 0xFD80F64B, 0xF8ED6752, 0x1CA63CF2, 0xD6B0F1E3,
    0x8AF5D6D4, 0x336F2AB7, 0xF59AFBEB, 0x0A461E7B, 0x604A509B, 0x13642C21,
    0x9E9F72BC, 0xA231BD1F, 0xD83A72B7, 0xEE1D2F2F, 0x6753756E, 0xC07E4A46,
    0x630FCE93, 0x47353D13, 0x0DBECC11, 0x64F3D4A5, 0x9CAB4DCB, 0xEF2767DF,
    0x40969D05, 0x56E4B60F, 0x2BF6AF2B, 0x03D61AD2, 0xFCDFB70F, 0xE50A6EA8,
    0x4F5546B0, 0x17B4AE0F, 0x1A39DC8C, 0x41080001, 0x564A5410, 0xB0FA9356,
    0x750A4609, 0x3C55FBCE, 0x8CF15B39, 0xF0CF15B2, 0x687478AD, 0xAA14B3C5,
    0x15389278, 0x3C7A97A8, 0x57EC1F35, 0xD8AF7D47, 0xC0F4EB05, 0x799015DA,
    0xCCF64122, 0x53485D99, 0x609B3EC6, 0xE4FA90CF, 0xF21E83E7, 0x05A528DF,
    0xC53DEF71, 0x605A902B, 0x78749605, 0x8C29862F, 0x4ACEEF6F, 0xACE5589F,
    0xE1DE8C7B, 0xA34A1BAC, 0x4346D6CD, 0x07276CB1, 0x5B6BAC79, 0x74D7457D,
    0x6EF29EC1, 0x4A2F7B4A, 0x74A4AB3D, 0x92DD65B3, 0xEB3C9BAD, 0xC6B92C62,
    0xB631EB8B, 0x9B92E1CC, 0x595A6EC5, 0x935C1D69, 0x95829FCD, 0x4F4BF28A,
    0xA7A56161, 0xAC73E17C, 0x9CC3DCD4, 0xC6A9D73C, 0xD2B2DC53, 0xF40BA053,
    0xF2A53A1C, 0xD46EA97B, 0x877270BE, 0xF7D1554F, 0xAE66A5D4, 0xD7E1D9D7,
    0x4F752EFD, 0xBCAB92C1, 0xBCCD51D0, 0x078F71D2, 0x8D02F056, 0xC6F07D3D,
    0xC9759683, 0xCF274E23, 0x95A07DCA, 0x35E2F945, 0x5D0F92B0, 0xBDEFD4E8,
    0x35CB96BE, 0xC6A5771E, 0xFD2CB42A, 0xBF497D74, 0x0E5B826B, 0x78B0E97D,
    0x83987876, 0x61EBD45F, 0x0EB07CC5, 0xBE2CAA9D, 0xEE2CA758, 0x2E3C6EB4,
    0x325F3165, 0xF5685BE8, 0xFCD35A72, 0x49BA5D2A, 0xE758ACF5, 0xDEFDD1C7,
    0xAF12DF38, 0x5E51D56C, 0x53D3854F, 0xE37C97D1, 0x29BDFBB7, 0xF0E82CFE,
    0xB873E561, 0x979572D0, 0xADF8FA38, 0x92A4F751, 0x5629EAA7, 0x3D8581E1,
    0x27A2B072, 0x4FCE4BAF, 0x3DD52AA5, 0x9EAA8F0E, 0xBADBF43A, 0x6E97C2BE,
    0x9EF74AC5, 0xF2EE67BA, 0xA7C7EF1D, 0x5478F1EE, 0x2DF2F055, 0x3B8FD959,
    0x254F6FDA, 0xA67B878F, 0x2759E7B8, 0xD4EE7B2B, 0x61D1582E, 0xD0625EC4,
    0x2F9DC94F, 0x3E8AA578, 0x6792C439, 0xB1858715, 0x40E78CD6, 0xAA52E7A3,
    0xC7EBBAA5, 0x14F43E87, 0x652CA5E5, 0xF0C6F845, 0xFA376552, 0xAEF3C6B0,
    0xFA36FC7A, 0x359A07C4, 0x2CF754FA, 0x37D0C787, 0xD0C2A79E, 0xB16B0F9D,
    0x82A97E0A, 0x2B86E62F, 0x1D7ED6BA, 0x8F235FBD, 0xF4DDDEF7, 0x93E85B79,
    0x3BDAB165, 0xE535A23A, 0x1DB8337A, 0x6F604B01, 0xA6B925BF, 0x3DE9319F,
    0x9B2A3ABD, 0x74B0D0BB, 0x72DD2EEF, 0xADAB6FA1, 0xF076B7AF, 0xED523BDE,
    0x6C676C0E, 0x777A01CD, 0xBF90B53C, 0xBB2B4CF2, 0xC5A91CA4, 0x523B2E91,
    0xFC495E3D, 0x557AD85A, 0xA4FBCE0B, 0xE565AFDD, 0x562EF2B7, 0xA47B34A4,
    0x5633561E, 0xD95AA99A, 0xE0A45625, 0x22B1E228, 0x612958F5, 0x43522F0D,
    0x1A9434F1, 0xE1EED708, 0x52DE61DE, 0xF3143F0F, 0x25F36B7A, 0x70EF432B,
    0x69EBADDA, 0x43BB5DFB, 0xEEBA5DE5, 0x5D9EA4BD, 0xD77B93D8, 0x9CAD8B93,
    0x5F16B36B, 0x94F52C78, 0xEACC5A04, 0x5CB08B91, 0x6103C894, 0xA47AB14B,
    0x98BC22A4, 0xA2BBF7A3, 0x7923AAB7, 0x89EBA44D, 0x5C8A72A4, 0x070E31DB,
    0xF64133CA, 0x8E9C1455, 0x5928E3CA, 0x1B955519, 0x78A3436B, 0x897936BC,
    0x2D228B34, 0x6256C8AC, 0xB2634BC8, 0xA9693336, 0xC0F43487, 0xBB48E37C,
    0x4BC0B475, 0xE93D0F59, 0xD409E87A, 0xAC1F7F43, 0x781DD54C, 0xB055A0DB,
    0xA9F5A9C4, 0x16937354, 0x6ACAED4E, 0xECDEF5EF, 0xA71C0A95, 0xBA0DB55D,
    0x662DDAF4, 0xF355A395, 0x842476C4, 0xE92E0F25, 0xCFE50F84, 0x1B564C0A,
    0x0296D47A, 0xD2C4B0D5, 0xDBDBE394, 0xEDE0B74B, 0xC8E49185, 0x8A722969,
    0xE3CCFDAC, 0x8D636E8D, 0x8ACEC71B, 0x5B51F3B3, 0xB17B77D7, 0xD6C7D7AB,
    0x6F78C6DB, 0x8C65BD60, 0xEA7282B7, 0x1616A1A9, 0xF29A3B94, 0x8F0F4EB6,
    0xD1347DD2, 0x0A54E532, 0x0977E61C, 0xED66D0F3, 0x9A37AC1D, 0xE4CD8315,
    0xF5EB66C8, 0xB37905B5, 0x6A3D6E4E, 0xA5721F14, 0x8DCA6B59, 0x1AD252B7,
    0x1E03053C, 0x59B701D9, 0x416F5DC3, 0xA2E1BD39, 0xD63AE0F4, 0x979986BC,
    0x88C7F344, 0xC8FC1727, 0x546AA5A6, 0xEF476EE3, 0xB5BBDE86, 0x7EF6FB15,
    0xECF1E9F6, 0xF2EF6ED3, 0x62BA2EC4, 0x42EF6217, 0x9BF4BDAC, 0xF644FA6C,
    0x7CE7CAC0, 0x2E4B74B9, 0x5ACC7AF2, 0xCC56D69B, 0x51B99AA5, 0xB2440A79,
    0x16EB4372, 0x8F82DD0C, 0x3F5A6BCE, 0xA57ADAB5, 0x9DAC5D16, 0x975B972E,
    0x3ABC05CA, 0x95FB9A50, 0xE0B25D62, 0x4D7784FB, 0xB704B4F4, 0x23ABC1E8,
    0xEC77A3D2, 0x76F9181B, 0xE04B6D47, 0x9A2C4F62, 0xC08BC022, 0xC4B07E62,
    0x637A160F, 0xD35C092D, 0x5AF82B81, 0x0D9127AF, 0x64B1641D, 0x605936B2,
    0xDF602DBF, 0x66C9605B, 0xFA95798F, 0x69BCBD74, 0x24D64187, 0xC5CCF66B,
    0x26C61F7F, 0x3BA9DE02, 0x2AC0BA95, 0x0CF61EB8, 0xE3794049, 0x1783F2D5,
    0xEEE34DAD, 0xD64C7059, 0x476A3DE9, 0xB70A7E51, 0x56AF2BAE, 0xF12A5031,
    0xCE05CEA3, 0x6F6C83E9, 0xF62C75B5, 0x1D2F04CC, 0x687A3F2B, 0xFCF4FF53,
    0x87E7A828, 0xD8681A1C, 0x1D656C53, 0xA3F3052A, 0xCC0BAEB7, 0x209B3A12,
    0x28F5D64C, 0xBEF890BD, 0x3F5E6D6C, 0x53CD73AC, 0x0D2A2DF9, 0xACAD4832,
    0x80484DDE, 0x2A45AC38, 0x0BB920BB, 0x080CE5C2, 0xD6F00000, 0xF4FB58C6,
    0x8DEAAB0B, 0x2B2B6F54, 0xB0BD5B8A, 0xC160B0FA, 0xA4B4AAA5, 0x8F951555,
    0xB4E81457, 0xBD4E9754, 0x356AA9D2, 0x1594B3F3, 0xEA740ABC, 0x25457564,
    0xCE2E4AA7, 0x535DEF9C, 0x97A956F0, 0x11CB55AA, 0x6FDEDEF3, 0x0F62D0CD,
    0x0C4FAB14, 0xA4A75AAC, 0xDA3D9163, 0xEDC4F33C, 0x2DFCD0B4, 0x81A56F56,
    0xEED79AB2, 0x091F3A44, 0xD3122C17, 0x92460781, 0xBD2F2F05, 0x45A23D40,
    0x8EF0410D, 0x7EAF3783, 0x0C8782F3, 0x2AE081CA, 0x6DE49D75, 0x5B6FD1FD,
    0x529B50BF, 0x19247854, 0x9D4F7EC1, 0x4F24C9AE, 0x9B91CF4E, 0x1472923C,
    0xFBDE3627, 0xEF3EFD79, 0xABDDFA4B, 0x2EFC52DF, 0x695A9AB5, 0x2BE9BDEA,
    0x7D36AB4D, 0x13BA316A, 0x345646BB, 0x35B37158, 0xC54348C1, 0x2A3395B0,
    0x27D94AC7, 0x84353DF0, 0x1CBF30DD, 0x27DCD82E, 0xE3C9221C, 0x7A5F47A5,
    0xBD997DDD, 0x7556932A, 0x225D2AEB, 0x692619E9, 0xFB8BE1B6, 0x60A5DED8,
    0xB9DCC6EE, 0x37CACF73, 0x4E977B58, 0x24DFA829, 0x4BD6F8BD, 0x11AF5806,
    0x943E931F, 0xEA412CAA, 0x6584B8B2, 0x704F6B47, 0x89543183, 0x9E6A2BE2,
    0xE9E0A258, 0x7904F581, 0x8B23C9A4, 0xB0B26C2C, 0xDED13EC0, 0x5943F2D2,
    0xFA3A75A1, 0x261A9F43, 0xC49AE18B, 0x3EBD599E, 0xD40FAF60, 0xF15F13EB,
    0xC07C5709, 0xC5681F15, 0x7B6B8E27, 0xBDC33D67, 0x23F47E60, 0x205FF024,
    0x2012FFC0, 0x3AA45FFE, 0x71388D71, 0x39E9F7A0, 0xF9E22040, 0xC8084161,
    0x20204275, 0x007B74A2, 0x9E088001, 0x6AE5E04E, 0x0619597A, 0x54210109,
    0xC7021D74, 0xAB630D8E, 0x4EA02113, 0xB3B231E2, 0xA2842428, 0xBB202137,
    0x515490E7, 0xA4F5955D, 0xC0A41D70, 0x82910524, 0xA1F4A8A8, 0x7F000804,
    0x3604710F, 0x007B1060, 0x0000034F,
};

/**
 * PSL represented as a directed acyclic graph
 * There are 8755 labels in 9329 nodes
 */
static const union pnode pnodes[9329] = {
    /* root entry */
    { .label = { 0, 0, 1 } }, { .child = { 2, 1551 } },
    /* entries 2 to 1828 */
    { .label = {    103,  2, 1 } }, { .child = { 1829, 6 } }, /* ac */
    { .label = {   3989,  2, 1 } }, { .child = { 1835, 1 } }, /* ad */
    { .label = {     99,  2, 1 } }, { .child = { 1836, 9 } }, /* ae */
    { .label = {  79798,  4, 1 } }, { .child = { 1845, 87 } }, /* aero */
    { .label = {    109,  2, 1 } }, { .child = { 1932, 6 } }, /* af */
    { .label = {   1191,  2, 1 } }, { .child = { 1938, 5 } }, /* ag */
    { .label = {     60,  2, 1 } }, { .child = { 1943, 5 } }, /* ai */
    { .label = {     94,  2, 1 } }, { .child = { 1948, 8 } }, /* al */
    { .label = {    396,  2, 1 } }, { .child = { 1956, 1 } }, /* am */
    { .label = {   1422,  2, 1 } }, { .child = { 1957, 6 } }, /* ao */
    { .label = {   1428,  2, 0 } }, /* aq */
    { .label = {     45,  2, 1 } }, { .child = { 1963, 10 } }, /* ar */
    { .label = { 114098,  4, 1 } }, { .child = { 1975, 6 } }, /* arpa */
    { .label = {    128,  2, 1 } }, { .child = { 1981, 1 } }, /* as */
    { .label = {  10956,  4, 1 } }, { .child = { 1982, 1 } }, /* asia */
    { .label = {    340,  2, 1 } }, { .child = { 1983, 15 } }, /* at */
    { .label = {    117,  2, 1 } }, { .child = { 2015, 18 } }, /* au */
    { .label = {   4232,  2, 1 } }, { .child = { 2050, 1 } }, /* aw */
    { .label = {    619,  2, 0 } }, /* ax */
    { .label = {   2857,  2, 1 } }, { .child = { 2051, 12 } }, /* az */
    { .label = {    118,  2, 1 } }, { .child = { 2063, 7 } }, /* ba */
    { .label = {   6026,  2, 1 } }, { .child = { 2070, 10 } }, /* bb */
    { .label = {  11070,  2, 1 } }, { .child = { 2080, 1 } }, /* bd */
    { .label = {    555,  2, 1 } }, { .child = { 2081, 4 } }, /* be */
    { .label = {     62,  2, 1 } }, { .child = { 2087, 1 } }, /* bf */
    { .label = {   9229,  2, 1 } }, { .child = { 2088, 38 } }, /* bg */
    { .label = {   6880,  2, 1 } }, { .child = { 2126, 5 } }, /* bh */
    { .label = {    282,  2, 1 } }, { .child = { 2131, 5 } }, /* bi */
    { .label = {  54555,  3, 1 } }, { .child = { 2136, 12 } }, /* biz */
    { .label = {   7174,  2, 1 } }, { .child = { 2148, 4 } }, /* bj */
    { .label = {   1058,  2, 1 } }, { .child = { 2152, 5 } }, /* bm */
    { .label = {   2214,  2, 1 } }, { .child = { 2157, 1 } }, /* bn */
    { .label = {    716,  2, 1 } }, { .child = { 2158, 41 } }, /* bo */
    { .label = {    294,  2, 1 } }, { .child = { 2199, 127 } }, /* br */
    { .label = {    693,  2, 1 } }, { .child = { 2386, 6 } }, /* bs */
    { .label = {   1108,  2, 1 } }, { .child = { 2392, 5 } }, /* bt */
    { .label = {   3646,  2, 0 } }, /* bv */
    { .label = {   2526,  2, 1 } }, { .child = { 2397, 2 } }, /* bw */
    { .label = {   2832,  2, 1 } }, { .child = { 2399, 5 } }, /* by */
    { .label = {   3703,  2, 1 } }, { .child = { 2406, 7 } }, /* bz */
    { .label = {    133,  2, 1 } }, { .child = { 2413, 19 } }, /* ca */
    { .label = {    417,  3, 0 } }, /* cat */
    { .label = {    466,  2, 1 } }, { .child = { 2434, 7 } }, /* cc */
    { .label = {   2713,  2, 1 } }, { .child = { 2441, 1 } }, /* cd */
    { .label = {   2412,  2, 1 } }, { .child = { 2442, 1 } }, /* cf */
    { .label = {   7637,  2, 0 } }, /* cg */
    { .label = {    190,  2, 1 } }, { .child = { 2443, 9 } }, /* ch */
    { .label = {    471,  2, 1 } }, { .child = { 2452, 15 } }, /* ci */
    { .label = {    184,  2, 1 } }, { .child = { 2467, 2 } }, /* ck */
    { .label = {   2620,  2, 1 } }, { .child = { 2471, 6 } }, /* cl */
    { .label = {  11546,  2, 1 } }, { .child = { 2477, 4 } }, /* cm */
    { .label = {   6811,  2, 1 } }, { .child = { 2481, 44 } }, /* cn */
    { .label = {     42,  2, 1 } }, { .child = { 2540, 17 } }, /* co */
    { .label = {    106,  3, 1 } }, { .child = { 2561, 303 } }, /* com */
    { .label = {  51529,  4, 0 } }, /* coop */
    { .label = {   1284,  2, 1 } }, { .child = { 3028, 7 } }, /* cr */
    { .label = {  10105,  2, 1 } }, { .child = { 3035, 6 } }, /* cu */
    { .label = {   1658,  2, 1 } }, { .child = { 3041, 1 } }, /* cv */
    { .label = {  16731,  2, 1 } }, { .child = { 3042, 4 } }, /* cw */
    { .label = {   7137,  2, 1 } }, { .child = { 3046, 3 } }, /* cx */
    { .label = {    674,  2, 1 } }, { .child = { 3049, 13 } }, /* cy */
    { .label = {   3760,  2, 1 } }, { .child = { 3064, 6 } }, /* cz */
    { .label = {    243,  2, 1 } }, { .child = { 3078, 54 } }, /* de */
    { .label = {  15439,  2, 0 } }, /* dj */
    { .label = {    206,  2, 1 } }, { .child = { 3143, 6 } }, /* dk */
    { .label = {   8056,  2, 1 } }, { .child = { 3149, 5 } }, /* dm */
    { .label = {   4106,  2, 1 } }, { .child = { 3154, 10 } }, /* do */
    { .label = {   5458,  2, 1 } }, { .child = { 3164, 8 } }, /* dz */
    { .label = {    102,  2, 1 } }, { .child = { 3172, 12 } }, /* ec */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {     98,  2, 1 } }, { .child = { 3184, 10 } }, /* ee */
    { .label = {   2038,  2, 1 } }, { .child = { 3196, 9 } }, /* eg */
    { .label = {     44,  2, 1 } }, { .child = { 3207, 1 } }, /* er */
    { .label = {    141,  2, 1 } }, { .child = { 3208, 5 } }, /* es */
    { .label = {    421,  2, 1 } }, { .child = { 3215, 8 } }, /* et */
    { .label = {    325,  2, 1 } }, { .child = { 3223, 7 } }, /* eu */
    { .label = {    391,  2, 1 } }, { .child = { 3232, 4 } }, /* fi */
    { .label = {   4617,  2, 1 } }, { .child = { 3236, 1 } }, /* fj */
    { .label = {  13343,  2, 1 } }, { .child = { 3237, 1 } }, /* fk */
    { .label = {   1659,  2, 0 } }, /* fm */
    { .label = {   4625,  2, 0 } }, /* fo */
    { .label = {    298,  2, 1 } }, { .child = { 3238, 30 } }, /* fr */
    { .label = {     19,  2, 0 } }, /* ga */
    { .label = {   1450,  2, 0 } }, /* gb */
    { .label = {   2042,  2, 1 } }, { .child = { 3268, 1 } }, /* gd */
    { .label = {    267,  2, 1 } }, { .child = { 3269, 8 } }, /* ge */
    { .label = {   4742,  2, 0 } }, /* gf */
    { .label = {   2677,  2, 1 } }, { .child = { 3277, 4 } }, /* gg */
    { .label = {    154,  2, 1 } }, { .child = { 3281, 5 } }, /* gh */
    { .label = {    217,  2, 1 } }, { .child = { 3286, 6 } }, /* gi */
    { .label = {   2441,  2, 1 } }, { .child = { 3292, 6 } }, /* gl */
    { .label = {   2424,  2, 0 } }, /* gm */
    { .label = {   6918,  2, 1 } }, { .child = { 3298, 6 } }, /* gn */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   1222,  2, 1 } }, { .child = { 3304, 6 } }, /* gp */
    { .label = {  12152,  2, 0 } }, /* gq */
    { .label = {   4505,  2, 1 } }, { .child = { 3310, 7 } }, /* gr */
    { .label = {    337,  2, 0 } }, /* gs */
    { .label = {   7123,  2, 1 } }, { .child = { 3317, 8 } }, /* gt */
    { .label = {   9907,  2, 1 } }, { .child = { 3325, 8 } }, /* gu */
    { .label = {   4709,  2, 0 } }, /* gw */
    { .label = {   5477,  2, 1 } }, { .child = { 3333, 7 } }, /* gy */
    { .label = {    517,  2, 1 } }, { .child = { 3340, 24 } }, /* hk */
    { .label = {   2224,  2, 0 } }, /* hm */
    { .label = {    147,  2, 1 } }, { .child = { 3364, 7 } }, /* hn */
    { .label = {   4397,  2, 1 } }, { .child = { 3371, 5 } }, /* hr */
    { .label = {    127,  2, 1 } }, { .child = { 3376, 17 } }, /* ht */
    { .label = {    291,  2, 1 } }, { .child = { 3393, 32 } }, /* hu */
    { .label = {     86,  2, 1 } }, { .child = { 3425, 12 } }, /* id */
    { .label = {    119,  2, 1 } }, { .child = { 3439, 3 } }, /* ie */
    { .label = {    556,  2, 1 } }, { .child = { 3442, 8 } }, /* il */
    { .label = {   1464,  2, 1 } }, { .child = { 3452, 9 } }, /* im */
    { .label = {    100,  2, 1 } }, { .child = { 3464, 15 } }, /* in */
    { .label = {  28720,  4, 1 } }, { .child = { 3479, 20 } }, /* info */
    { .label = {   4229,  3, 1 } }, { .child = { 3499, 1 } }, /* int */
    { .label = {     63,  2, 1 } }, { .child = { 3500, 34 } }, /* io */
    { .label = {   3339,  2, 1 } }, { .child = { 3559, 6 } }, /* iq */
    { .label = {    200,  2, 1 } }, { .child = { 3565, 9 } }, /* ir */
    { .label = {    260,  2, 1 } }, { .child = { 3574, 8 } }, /* is */
    { .label = {    151,  2, 1 } }, { .child = { 3582, 410 } }, /* it */
    { .label = {   3761,  2, 1 } }, { .child = { 3992, 3 } }, /* je */
    { .label = {   7741,  2, 1 } }, { .child = { 3995, 1 } }, /* jm */
    { .label = {   7272,  2, 1 } }, { .child = { 3996, 8 } }, /* jo */
    { .label = { 165706,  4, 0 } }, /* jobs */
    { .label = {   9443,  2, 1 } }, { .child = { 4004, 111 } }, /* jp */
    { .label = {    490,  2, 1 } }, { .child = { 5870, 10 } }, /* ke */
    { .label = {    740,  2, 1 } }, { .child = { 5882, 6 } }, /* kg */
    { .label = {    231,  2, 1 } }, { .child = { 5888, 1 } }, /* kh */
    { .label = {   2619,  2, 1 } }, { .child = { 5889, 7 } }, /* ki */
    { .label = {    189,  2, 1 } }, { .child = { 5896, 17 } }, /* km */
    { .label = {    183,  2, 1 } }, { .child = { 5913, 4 } }, /* kn */
    { .label = {   2924,  2, 1 } }, { .child = { 5917, 6 } }, /* kp */
    { .label = {   3651,  2, 1 } }, { .child = { 5923, 30 } }, /* kr */
    { .label = {    211,  2, 1 } }, { .child = { 5953, 7 } }, /* kw */
    { .label = {    470,  2, 1 } }, { .child = { 5960, 5 } }, /* ky */
    { .label = {    522,  2, 1 } }, { .child = { 5965, 7 } }, /* kz */
    { .label = {    557,  2, 1 } }, { .child = { 5972, 11 } }, /* la */
    { .label = {    688,  2, 1 } }, { .child = { 5983, 5 } }, /* lb */
    { .label = {    101,  2, 1 } }, { .child = { 5988, 8 } }, /* lc */
    { .label = {    360,  2, 1 } }, { .child = { 5996, 3 } }, /* li */
    { .label = {   6616,  2, 1 } }, { .child = { 5999, 15 } }, /* lk */
    { .label = {   1372,  2, 1 } }, { .child = { 6014, 5 } }, /* lr */
    { .label = {    140,  2, 1 } }, { .child = { 6019, 2 } }, /* ls */
    { .label = {    695,  2, 1 } }, { .child = { 6021, 3 } }, /* lt */
    { .label = {   3643,  2, 1 } }, { .child = { 6024, 2 } }, /* lu */
    { .label = {   9079,  2, 1 } }, { .child = { 6026, 9 } }, /* lv */
    { .label = {   7691,  2, 1 } }, { .child = { 6035, 9 } }, /* ly */
    { .label = {   1369,  2, 1 } }, { .child = { 6044, 6 } }, /* ma */
    { .label = {   2717,  2, 1 } }, { .child = { 6050, 2 } }, /* mc */
    { .label = {   8061,  2, 1 } }, { .child = { 6052, 1 } }, /* md */
    { .label = {    591,  2, 1 } }, { .child = { 6053, 31 } }, /* me */
    { .label = {   1381,  2, 1 } }, { .child = { 6086, 9 } }, /* mg */
    { .label = {   6080,  2, 0 } }, /* mh */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {    158,  2, 1 } }, { .child = { 6095, 9 } }, /* mk */
    { .label = {    749,  2, 1 } }, { .child = { 6104, 7 } }, /* ml */
    { .label = {    394,  2, 1 } }, { .child = { 6111, 1 } }, /* mm */
    { .label = {    571,  2, 1 } }, { .child = { 6112, 5 } }, /* mn */
    { .label = {   3360,  2, 1 } }, { .child = { 6117, 5 } }, /* mo */
    { .label = {  10207,  4, 1 } }, { .child = { 6122, 2 } }, /* mobi */
    { .label = {    242,  2, 0 } }, /* mp */
    { .label = {  51862,  2, 0 } }, /* mq */
    { .label = {    205,  2, 1 } }, { .child = { 6124, 2 } }, /* mr */
    { .label = {    126,  2, 1 } }, { .child = { 6126, 5 } }, /* ms */
    { .label = {   2788,  2, 1 } }, { .child = { 6131, 4 } }, /* mt */
    { .label = {    115,  2, 1 } }, { .child = { 6137, 7 } }, /* mu */
    { .label = {   4448,  6, 1 } }, { .child = { 6144, 548 } }, /* museum */
    { .label = {   9509,  2, 1 } }, { .child = { 6692, 14 } }, /* mv */
    { .label = {   5353,  2, 1 } }, { .child = { 6706, 11 } }, /* mw */
    { .label = {   2900,  2, 1 } }, { .child = { 6717, 7 } }, /* mx */
    { .label = {    194,  2, 1 } }, { .child = { 6724, 8 } }, /* my */
    { .label = {  17361,  2, 1 } }, { .child = { 6732, 8 } }, /* mz */
    { .label = {     87,  2, 1 } }, { .child = { 6740, 17 } }, /* na */
    { .label = {  29414,  4, 1 } }, { .child = { 6757, 2 } }, /* name */
    { .label = {    311,  2, 1 } }, { .child = { 6763, 2 } }, /* nc */
    { .label = {     40,  2, 0 } }, /* ne */
    { .label = {  16771,  3, 1 } }, { .child = { 6765, 106 } }, /* net */
    { .label = {    463,  2, 1 } }, { .child = { 6889, 10 } }, /* nf */
    { .label = {    761,  2, 1 } }, { .child = { 6899, 10 } }, /* ng */
    { .label = {    125,  2, 1 } }, { .child = { 6911, 14 } }, /* ni */
    { .label = {   2951,  2, 1 } }, { .child = { 6925, 8 } }, /* nl */
    { .label = {    162,  2, 1 } }, { .child = { 6935, 726 } }, /* no */
    { .label = {   2455,  2, 1 } }, { .child = { 7733, 1 } }, /* np */
    { .label = {   1472,  2, 1 } }, { .child = { 7734, 7 } }, /* nr */
    { .label = {    241,  2, 1 } }, { .child = { 7741, 4 } }, /* nu */
    { .label = {    130,  2, 1 } }, { .child = { 7745, 17 } }, /* nz */
    { .label = {    111,  2, 1 } }, { .child = { 7764, 9 } }, /* om */
    { .label = {  47410,  5, 0 } }, /* onion */
    { .label = {    209,  3, 1 } }, { .child = { 7773, 106 } }, /* org */
    { .label = {    136,  2, 1 } }, { .child = { 7957, 11 } }, /* pa */
    { .label = {    552,  2, 1 } }, { .child = { 7968, 9 } }, /* pe */
    { .label = {  47823,  2, 1 } }, { .child = { 7977, 3 } }, /* pf */
    { .label = {  25981,  2, 1 } }, { .child = { 7980, 1 } }, /* pg */
    { .label = {   3782,  2, 1 } }, { .child = { 7981, 8 } }, /* ph */
    { .label = {    225,  2, 1 } }, { .child = { 7989, 14 } }, /* pk */
    { .label = {   5819,  2, 1 } }, { .child = { 8003, 166 } }, /* pl */
    { .label = {   2459,  2, 1 } }, { .child = { 8217, 1 } }, /* pm */
    { .label = {    675,  2, 1 } }, { .child = { 8218, 5 } }, /* pn */
    { .label = {    324,  4, 0 } }, /* post */
    { .label = {   1461,  2, 1 } }, { .child = { 8223, 13 } }, /* pr */
    { .label = {  22835,  3, 1 } }, { .child = { 8236, 14 } }, /* pro */
    { .label = {    247,  2, 1 } }, { .child = { 8252, 7 } }, /* ps */
    { .label = {   6812,  2, 1 } }, { .child = { 8259, 10 } }, /* pt */
    { .label = {   1443,  2, 1 } }, { .child = { 8269, 9 } }, /* pw */
    { .label = {   3058,  2, 1 } }, { .child = { 8278, 7 } }, /* py */
    { .label = {    265,  2, 1 } }, { .child = { 8285, 10 } }, /* qa */
    { .label = {     55,  2, 1 } }, { .child = { 8295, 4 } }, /* re */
    { .label = {    524,  2, 1 } }, { .child = { 8299, 14 } }, /* ro */
    { .label = {      9,  2, 1 } }, { .child = { 8313, 9 } }, /* rs */
    { .label = {    204,  2, 1 } }, { .child = { 8322, 32 } }, /* ru */
    { .label = {    167,  2, 1 } }, { .child = { 8369, 9 } }, /* rw */
    { .label = {    355,  2, 1 } }, { .child = { 8378, 8 } }, /* sa */
    { .label = {    424,  2, 1 } }, { .child = { 8386, 5 } }, /* sb */
    { .label = {     17,  2, 1 } }, { .child = { 8391, 5 } }, /* sc */
    { .label = {    502,  2, 1 } }, { .child = { 8396, 8 } }, /* sd */
    { .label = {    629,  2, 1 } }, { .child = { 8404, 41 } }, /* se */
    { .label = {    168,  2, 1 } }, { .child = { 8445, 7 } }, /* sg */
    { .label = {    253,  2, 1 } }, { .child = { 8452, 9 } }, /* sh */
    { .label = {    699,  2, 1 } }, { .child = { 8463, 2 } }, /* si */
    { .label = {   3757,  2, 0 } }, /* sj */
    { .label = {      6,  2, 1 } }, { .child = { 8465, 2 } }, /* sk */
    { .label = {     88,  2, 1 } }, { .child = { 8467, 5 } }, /* sl */
    { .label = {   1519,  2, 0 } }, /* sm */
    { .label = {   1414,  2, 1 } }, { .child = { 8472, 8 } }, /* sn */
    { .label = {    131,  2, 1 } }, { .child = { 8480, 3 } }, /* so */
    { .label = {    153,  2, 0 } }, /* sr */
    { .label = {    214,  2, 1 } }, { .child = { 8483, 14 } }, /* st */
    { .label = {   1537,  2, 1 } }, { .child = { 8497, 53 } }, /* su */
    { .label = {    743,  2, 1 } }, { .child = { 8550, 5 } }, /* sv */
    { .label = {    312,  2, 1 } }, { .child = { 8555, 2 } }, /* sx */
    { .label = {    305,  2, 1 } }, { .child = { 8557, 6 } }, /* sy */
    { .label = {   1221,  2, 1 } }, { .child = { 8563, 3 } }, /* sz */
    { .label = {     53,  2, 0 } }, /* tc */
    { .label = {   2043,  2, 1 } }, { .child = { 8566, 1 } }, /* td */
    { .label = {     89,  3, 0 } }, /* tel */
    { .label = {   4621,  2, 0 } }, /* tf */
    { .label = {   2678,  2, 0 } }, /* tg */
    { .label = {    155,  2, 1 } }, { .child = { 8567, 7 } }, /* th */
    { .label = {   2411,  2, 1 } }, { .child = { 8574, 16 } }, /* tj */
    { .label = {   3008,  2, 0 } }, /* tk */
    { .label = {   2442,  2, 1 } }, { .child = { 8590, 1 } }, /* tl */
    { .label = {   2425,  2, 1 } }, { .child = { 8591, 8 } }, /* tm */
    { .label = {    700,  2, 1 } }, { .child = { 8599, 20 } }, /* tn */
    { .label = {   1538,  2, 1 } }, { .child = { 8619, 7 } }, /* to */
    { .label = {    465,  2, 1 } }, { .child = { 8626, 21 } }, /* tr */
    { .label = {      3,  2, 1 } }, { .child = { 8651, 17 } }, /* tt */
    { .label = {   9431,  2, 1 } }, { .child = { 8668, 4 } }, /* tv */
    { .label = {     14,  2, 1 } }, { .child = { 8672, 16 } }, /* tw */
    { .label = {  23877,  2, 1 } }, { .child = { 8690, 12 } }, /* tz */
    { .label = {   1465,  2, 1 } }, { .child = { 8702, 82 } }, /* ua */
    { .label = {   2528,  2, 1 } }, { .child = { 8784, 10 } }, /* ug */
    { .label = {   6323,  2, 1 } }, { .child = { 8794, 12 } }, /* uk */
    { .label = {    296,  2, 1 } }, { .child = { 8823, 69 } }, /* us */
    { .label = {    223,  2, 1 } }, { .child = { 9119, 7 } }, /* uy */
    { .label = {   3282,  2, 1 } }, { .child = { 9128, 4 } }, /* uz */
    { .label = {     54,  2, 0 } }, /* va */
    { .label = {  16908,  2, 1 } }, { .child = { 9132, 7 } }, /* vc */
    { .label = {   1367,  2, 1 } }, { .child = { 9139, 17 } }, /* ve */
    { .label = {   2702,  2, 1 } }, { .child = { 9156, 1 } }, /* vg */
    { .label = {    569,  2, 1 } }, { .child = { 9157, 5 } }, /* vi */
    { .label = {    156,  2, 1 } }, { .child = { 9162, 13 } }, /* vn */
    { .label = {   3772,  2, 1 } }, { .child = { 9175, 4 } }, /* vu */
    { .label = {   4741,  2, 0 } }, /* wf */
    { .label = {    336,  2, 1 } }, { .child = { 9179, 9 } }, /* ws */
    { .label = {    250,  2, 0 } }, /* yt */
    { .label = {  28817, 14, 0 } }, /* xn--mgbaam7a8h */
    { .label = {  74176, 10, 0 } }, /* xn--y9a3aq */
    { .label = {  28890, 14, 0 } }, /* xn--54b7fta0cc */
    { .label = { 111912,  8, 0 } }, /* xn--90ae */
    { .label = {  92089,  9, 0 } }, /* xn--90ais */
    { .label = {  74234, 10, 0 } }, /* xn--fiqs8s */
    { .label = {  74289, 10, 0 } }, /* xn--fiqz9s */
    { .label = {  22495, 15, 0 } }, /* xn--lgbbat1ad8j */
    { .label = {  74348, 10, 0 } }, /* xn--wgbh1c */
    { .label = {  92138,  9, 0 } }, /* xn--e1a4c */
    { .label = { 111957,  8, 0 } }, /* xn--node */
    { .label = { 111994,  8, 0 } }, /* xn--qxam */
    { .label = {  58508, 11, 1 } }, { .child = { 9190, 6 } }, /* xn--j6w193g */
    { .label = {  58581, 11, 0 } }, /* xn--2scrj9c */
    { .label = {  58644, 11, 0 } }, /* xn--3hcrj9c */
    { .label = {  47440, 12, 0 } }, /* xn--45br5cyl */
    { .label = {  28974, 14, 0 } }, /* xn--h2breg3eve */
    { .label = {  37304, 13, 0 } }, /* xn--h2brj9c8c */
    { .label = {  47513, 12, 0 } }, /* xn--mgbgu82a */
    { .label = {  29048, 14, 0 } }, /* xn--rvc1e0am3e */
    { .label = {  37304, 11, 0 } }, /* xn--h2brj9c */
    { .label = {  29123, 11, 0 } }, /* xn--mgbbh1a */
    { .label = {  29123, 14, 0 } }, /* xn--mgbbh1a71e */
    { .label = {  37383, 13, 0 } }, /* xn--fpcrj9c3d */
    { .label = {  58708, 11, 0 } }, /* xn--gecrj9c */
    { .label = {  58768, 11, 0 } }, /* xn--s9brj9c */
    { .label = {  58834, 11, 0 } }, /* xn--45brj9c */
    { .label = {  11994, 17, 0 } }, /* xn--xkc2dl3a5ee0h */
    { .label = {  17893, 15, 0 } }, /* xn--mgba3a4f16a */
    { .label = {  24748, 14, 0 } }, /* xn--mgba3a4fra */
    { .label = {  58904, 11, 0 } }, /* xn--mgbtx2b */
    { .label = {  29202, 14, 0 } }, /* xn--mgbayh7gpa */
    { .label = {  47579, 12, 0 } }, /* xn--3e0b707e */
    { .label = {  58964, 11, 0 } }, /* xn--80ao21a */
    { .label = {  37459, 13, 0 } }, /* xn--fzc2c9e2c */
    { .label = {  16113, 16, 0 } }, /* xn--xkc2al3hye2a */
    { .label = {  22576, 15, 0 } }, /* xn--mgbc0a9azcg */
    { .label = {  92187,  9, 0 } }, /* xn--d1alf */
    { .label = {  92234,  9, 0 } }, /* xn--l1acc */
    { .label = {  59027, 11, 0 } }, /* xn--mix891f */
    { .label = {  59095, 11, 0 } }, /* xn--mix082f */
    { .label = {  29275, 14, 0 } }, /* xn--mgbx4cd0ab */
    { .label = {  47655, 12, 0 } }, /* xn--mgb9awbf */
    { .label = {  12089, 17, 0 } }, /* xn--mgbai9azgqp6j */
    { .label = {   9747, 18, 0 } }, /* xn--mgbai9a5eva00b */
    { .label = {  37537, 13, 0 } }, /* xn--ygbi2ammx */
    { .label = {  74403, 10, 1 } }, { .child = { 9196, 6 } }, /* xn--90a3ac */
    { .label = { 112121,  8, 0 } }, /* xn--p1ai */
    { .label = {  74460, 10, 0 } }, /* xn--wgbl6a */
    { .label = {  12187, 17, 0 } }, /* xn--mgberp4a5d4ar */
    { .label = {   7536, 19, 0 } }, /* xn--mgberp4a5d4a87g */
    { .label = {   7647, 19, 0 } }, /* xn--mgbqly7c0a67fbc */
    { .label = {  16199, 16, 0 } }, /* xn--mgbqly7cvafr */
    { .label = {  47722, 12, 0 } }, /* xn--mgbpl2fh */
    { .label = {  37605, 13, 0 } }, /* xn--yfro4i67o */
    { .label = {   2600, 22, 0 } }, /* xn--clchc0ea0b2g2a9gcd */
    { .label = {  47788, 12, 0 } }, /* xn--ogbpf8fl */
    { .label = {  47855, 12, 0 } }, /* xn--mgbtf8fl */
    { .label = {  74514, 10, 1 } }, { .child = { 9202, 6 } }, /* xn--o3cw4h */
    { .label = {  59221, 11, 0 } }, /* xn--pgbs0dh */
    { .label = {  59280, 11, 0 } }, /* xn--kpry57d */
    { .label = {  59344, 11, 0 } }, /* xn--kprw13d */
    { .label = {  59406, 11, 0 } }, /* xn--nnx388a */
    { .label = {  92425,  9, 0 } }, /* xn--j1amh */
    { .label = {  47990, 12, 0 } }, /* xn--mgb2ddes */
    { .label = { 115691,  3, 0 } }, /* xxx */
    { .label = {     38,  2, 1 } }, { .child = { 9208, 1 } }, /* ye */
    { .label = {    527,  2, 1 } }, { .child = { 9209, 17 } }, /* za */
    { .label = {   3780,  2, 1 } }, { .child = { 9228, 11 } }, /* zm */
    { .label = {  50992,  2, 1 } }, { .child = { 9239, 5 } }, /* zw */
    { .label = {   8820,  3, 0 } }, /* aaa */
    { .label = {   7570,  4, 0 } }, /* aarp */
    { .label = { 150752,  6, 0 } }, /* abarth */
    { .label = {   6023,  3, 0 } }, /* abb */
    { .label = { 150777,  6, 0 } }, /* abbott */
    { .label = { 150804,  6, 0 } }, /* abbvie */
    { .label = {   2536,  3, 0 } }, /* abc */
    { .label = {   7911,  4, 0 } }, /* able */
    { .label = { 131178,  7, 0 } }, /* abogado */
    { .label = { 112162,  8, 0 } }, /* abudhabi */
    { .label = { 125583,  7, 1 } }, { .child = { 9244, 1 } }, /* academy */
    { .label = {  92473,  9, 0 } }, /* accenture */
    { .label = {  17017, 10, 0 } }, /* accountant */
    { .label = {  59469, 11, 0 } }, /* accountants */
    { .label = {    103,  3, 0 } }, /* aco */
    { .label = {  13368,  6, 0 } }, /* active */
    { .label = {  13408,  5, 0 } }, /* actor */
    { .label = {  26260,  4, 0 } }, /* adac */
    { .label = {  34986,  3, 0 } }, /* ads */
    { .label = { 155585,  5, 0 } }, /* adult */
    { .label = {   8837,  3, 0 } }, /* aeg */
    { .label = { 162110,  5, 0 } }, /* aetna */
    { .label = {  29353, 14, 0 } }, /* afamilycompany */
    { .label = {  19076,  3, 0 } }, /* afl */
    { .label = {  70768,  6, 0 } }, /* africa */
    { .label = { 131208,  7, 0 } }, /* agakhan */
    { .label = { 150833,  6, 0 } }, /* agency */
    { .label = {    677,  3, 0 } }, /* aig */
    { .label = {  16893,  4, 0 } }, /* aigo */
    { .label = { 150860,  6, 0 } }, /* airbus */
    { .label = { 112199,  8, 0 } }, /* airforce */
    { .label = { 150886,  6, 0 } }, /* airtel */
    { .label = { 167039,  4, 0 } }, /* akdn */
    { .label = {  92511,  9, 0 } }, /* alfaromeo */
    { .label = { 131236,  7, 0 } }, /* alibaba */
    { .label = { 150910,  6, 0 } }, /* alipay */
    { .label = {  92549,  9, 0 } }, /* allfinanz */
    { .label = { 112233,  8, 0 } }, /* allstate */
    { .label = { 167056,  4, 0 } }, /* ally */
    { .label = { 150937,  6, 0 } }, /* alsace */
    { .label = { 150961,  6, 0 } }, /* alstom */
    { .label = {  22748, 15, 0 } }, /* americanexpress */
    { .label = {  29418, 14, 0 } }, /* americanfamily */
    { .label = { 131455,  4, 0 } }, /* amex */
    { .label = { 162128,  5, 0 } }, /* amfam */
    { .label = { 162150,  5, 0 } }, /* amica */
    { .label = {  86416,  9, 0 } }, /* amsterdam */
    { .label = {  92590,  9, 0 } }, /* analytics */
    { .label = { 131266,  7, 0 } }, /* android */
    { .label = { 150986,  6, 0 } }, /* anquan */
    { .label = {   3438,  3, 0 } }, /* anz */
    { .label = {   2310,  3, 0 } }, /* aol */
    { .label = {  74571, 10, 0 } }, /* apartments */
    { .label = {   6750,  3, 1 } }, { .child = { 9245, 1 } }, /* app */
    { .label = { 162170,  5, 0 } }, /* apple */
    { .label = {  92628,  9, 0 } }, /* aquarelle */
    { .label = {  20826,  4, 0 } }, /* arab */
    { .label = { 151013,  6, 0 } }, /* aramco */
    { .label = {  24250,  5, 0 } }, /* archi */
    { .label = {  35633,  4, 0 } }, /* army */
    { .label = {   7867,  3, 0 } }, /* art */
    { .label = {  17211,  4, 0 } }, /* arte */
    { .label = {   2553,  4, 0 } }, /* asda */
    { .label = {  74612, 10, 0 } }, /* associates */
    { .label = { 131295,  7, 0 } }, /* athleta */
    { .label = { 112265,  8, 0 } }, /* attorney */
    { .label = { 131323,  7, 0 } }, /* auction */
    { .label = { 128801,  4, 0 } }, /* audi */
    { .label = { 131352,  7, 0 } }, /* audible */
    { .label = { 162194,  5, 0 } }, /* audio */
    { .label = { 131384,  7, 0 } }, /* auspost */
    { .label = { 138780,  6, 0 } }, /* author */
    { .label = {  13093,  4, 0 } }, /* auto */
    { .label = { 115513,  5, 0 } }, /* autos */
    { .label = { 131414,  7, 0 } }, /* avianca */
    { .label = {  17710,  3, 0 } }, /* aws */
    { .label = {  10919,  3, 0 } }, /* axa */
    { .label = {  31631,  5, 0 } }, /* azure */
    { .label = { 167075,  4, 0 } }, /* baby */
    { .label = { 162215,  5, 0 } }, /* baidu */
    { .label = { 131442,  7, 0 } }, /* banamex */
    { .label = {  29479, 14, 0 } }, /* bananarepublic */
    { .label = {   2996,  4, 0 } }, /* band */
    { .label = {  93912,  4, 0 } }, /* bank */
    { .label = {   3030,  3, 0 } }, /* bar */
    { .label = {  86677,  9, 0 } }, /* barcelona */
    { .label = {  59514, 11, 0 } }, /* barclaycard */
    { .label = { 112298,  8, 0 } }, /* barclays */
    { .label = { 112334,  8, 0 } }, /* barefoot */
    { .label = { 112369,  8, 0 } }, /* bargains */
    { .label = { 106315,  8, 0 } }, /* baseball */
    { .label = {  74651, 10, 0 } }, /* basketball */
    { .label = { 131473,  7, 0 } }, /* bauhaus */
    { .label = { 151037,  6, 0 } }, /* bayern */
    { .label = {  11695,  3, 0 } }, /* bbc */
    { .label = {  49883,  3, 0 } }, /* bbt */
    { .label = { 167096,  4, 0 } }, /* bbva */
    { .label = { 125880,  3, 0 } }, /* bcg */
    { .label = {  38595,  3, 0 } }, /* bcn */
    { .label = { 162238,  5, 0 } }, /* beats */
    { .label = { 151064,  6, 0 } }, /* beauty */
    { .label = {  96161,  4, 0 } }, /* beer */
    { .label = { 131504,  7, 0 } }, /* bentley */
    { .label = { 146334,  6, 0 } }, /* berlin */
    { .label = {    752,  4, 0 } }, /* best */
    { .label = { 131537,  7, 0 } }, /* bestbuy */
    { .label = {   9421,  3, 0 } }, /* bet */
    { .label = { 151092,  6, 0 } }, /* bharti */
    { .label = { 159103,  5, 0 } }, /* bible */
    { .label = {  24239,  3, 0 } }, /* bid */
    { .label = { 146913,  4, 0 } }, /* bike */
    { .label = {  53752,  4, 0 } }, /* bing */
    { .label = { 162259,  5, 0 } }, /* bingo */
    { .label = {  43283,  3, 0 } }, /* bio */
    { .label = {  49408,  5, 0 } }, /* black */
    { .label = {  59563, 11, 0 } }, /* blackfriday */
    { .label = { 151118,  6, 0 } }, /* blanco */
    { .label = {  59615, 11, 0 } }, /* blockbuster */
    { .label = {  16818,  4, 0 } }, /* blog */
    { .label = {  92669,  9, 0 } }, /* bloomberg */
    { .label = { 167117,  4, 0 } }, /* blue */
    { .label = {  53237,  3, 0 } }, /* bms */
    { .label = { 159235,  3, 0 } }, /* bmw */
    { .label = { 134326,  3, 0 } }, /* bnl */
    { .label = {  74696, 10, 0 } }, /* bnpparibas */
    { .label = { 162282,  5, 0 } }, /* boats */
    { .label = {  74742, 10, 0 } }, /* boehringer */
    { .label = { 167137,  4, 0 } }, /* bofa */
    { .label = {  14991,  3, 0 } }, /* bom */
    { .label = {  38340,  4, 0 } }, /* bond */
    { .label = {  23909,  3, 0 } }, /* boo */
    { .label = {  23909,  4, 0 } }, /* book */
    { .label = { 131572,  7, 0 } }, /* booking */
    { .label = { 162303,  5, 0 } }, /* bosch */
    { .label = { 151145,  6, 0 } }, /* bostik */
    { .label = { 146389,  6, 0 } }, /* boston */
    { .label = {  19488,  3, 0 } }, /* bot */
    { .label = { 112402,  8, 0 } }, /* boutique */
    { .label = {  76900,  3, 0 } }, /* box */
    { .label = { 112442,  8, 0 } }, /* bradesco */
    { .label = {  59667, 11, 0 } }, /* bridgestone */
    { .label = { 112477,  8, 0 } }, /* broadway */
    { .label = { 138805,  6, 0 } }, /* broker */
    { .label = { 131604,  7, 0 } }, /* brother */
    { .label = { 106428,  8, 0 } }, /* brussels */
    { .label = { 112514,  8, 0 } }, /* budapest */
    { .label = { 131635,  7, 0 } }, /* bugatti */
    { .label = { 106464,  5, 0 } }, /* build */
    { .label = { 112551,  8, 0 } }, /* builders */
    { .label = { 112588,  8, 0 } }, /* business */
    { .label = {  77283,  3, 0 } }, /* buy */
    { .label = { 167156,  4, 0 } }, /* buzz */
    { .label = {   3703,  3, 0 } }, /* bzh */
    { .label = {   1115,  3, 0 } }, /* cab */
    { .label = { 167181,  4, 0 } }, /* cafe */
    { .label = {  11146,  3, 0 } }, /* cal */
    { .label = { 167199,  4, 0 } }, /* call */
    { .label = {  59715, 11, 0 } }, /* calvinklein */
    { .label = {  17590,  3, 0 } }, /* cam */
    { .label = {  17590,  6, 0 } }, /* camera */
    { .label = {  18696,  4, 0 } }, /* camp */
    { .label = {  29541, 14, 0 } }, /* cancerresearch */
    { .label = { 162327,  5, 0 } }, /* canon */
    { .label = { 112623,  8, 0 } }, /* capetown */
    { .label = {  74786,  7, 0 } }, /* capital */
    { .label = {  74786, 10, 0 } }, /* capitalone */
    { .label = {    853,  3, 0 } }, /* car */
    { .label = { 131666,  7, 0 } }, /* caravan */
    { .label = { 162347,  5, 0 } }, /* cards */
    { .label = {  13314,  4, 0 } }, /* care */
    { .label = { 131694,  6, 0 } }, /* career */
    { .label = { 131694,  7, 0 } }, /* careers */
    { .label = {  39494,  4, 0 } }, /* cars */
    { .label = { 131722,  7, 0 } }, /* cartier */
    { .label = {  26214,  4, 0 } }, /* casa */
    { .label = { 119102,  4, 0 } }, /* case */
    { .label = { 151172,  6, 0 } }, /* caseih */
    { .label = {  71255,  4, 0 } }, /* cash */
    { .label = { 139325,  6, 0 } }, /* casino */
    { .label = {  96659,  8, 0 } }, /* catering */
    { .label = { 112659,  8, 0 } }, /* catholic */
    { .label = {   3809,  3, 0 } }, /* cba */
    { .label = { 141260,  3, 0 } }, /* cbn */
    { .label = { 167217,  4, 0 } }, /* cbre */
    { .label = {  49522,  3, 0 } }, /* cbs */
    { .label = {   9991,  3, 0 } }, /* ceb */
    { .label = {  26428,  6, 0 } }, /* center */
    { .label = { 115278,  3, 0 } }, /* ceo */
    { .label = { 126638,  4, 0 } }, /* cern */
    { .label = {  59952,  3, 0 } }, /* cfa */
    { .label = { 122226,  3, 0 } }, /* cfd */
    { .label = { 151197,  6, 0 } }, /* chanel */
    { .label = {  29630,  7, 0 } }, /* channel */
    { .label = { 131750,  7, 0 } }, /* charity */
    { .label = { 162368,  5, 0 } }, /* chase */
    { .label = {  55933,  4, 0 } }, /* chat */
    { .label = { 162389,  5, 0 } }, /* cheap */
    { .label = { 131781,  7, 0 } }, /* chintai */
    { .label = {  92712,  9, 0 } }, /* christmas */
    { .label = { 151223,  6, 0 } }, /* chrome */
    { .label = { 112694,  8, 0 } }, /* chrysler */
    { .label = { 151250,  6, 0 } }, /* church */
    { .label = { 112731,  8, 0 } }, /* cipriani */
    { .label = { 151279,  6, 0 } }, /* circle */
    { .label = {  43818,  5, 0 } }, /* cisco */
    { .label = { 131810,  7, 0 } }, /* citadel */
    { .label = {  24400,  4, 0 } }, /* citi */
    { .label = { 162412,  5, 0 } }, /* citic */
    { .label = {  96486,  4, 0 } }, /* city */
    { .label = { 112765,  8, 0 } }, /* cityeats */
    { .label = { 151306,  6, 0 } }, /* claims */
    { .label = { 112799,  8, 0 } }, /* cleaning */
    { .label = { 162434,  5, 0 } }, /* click */
    { .label = { 151332,  6, 0 } }, /* clinic */
    { .label = { 112833,  8, 0 } }, /* clinique */
    { .label = { 112872,  8, 0 } }, /* clothing */
    { .label = {  13493,  5, 1 } }, { .child = { 9246, 6 } }, /* cloud */
    { .label = {  96605,  4, 1 } }, { .child = { 9258, 2 } }, /* club */
    { .label = { 131840,  7, 0 } }, /* clubmed */
    { .label = { 162458,  5, 0 } }, /* coach */
    { .label = { 116684,  5, 0 } }, /* codes */
    { .label = { 151359,  6, 0 } }, /* coffee */
    { .label = {  50829,  7, 0 } }, /* college */
    { .label = { 131875,  7, 0 } }, /* cologne */
    { .label = { 131906,  7, 0 } }, /* comcast */
    { .label = { 112908,  8, 0 } }, /* commbank */
    { .label = {  86915,  9, 1 } }, { .child = { 9260, 1 } }, /* community */
    { .label = {  29385,  7, 0 } }, /* company */
    { .label = { 131936,  7, 0 } }, /* compare */
    { .label = {  19748,  8, 0 } }, /* computer */
    { .label = { 151388,  6, 0 } }, /* comsec */
    { .label = { 151415,  6, 0 } }, /* condos */
    { .label = {  48052, 12, 0 } }, /* construction */
    { .label = {  65764, 10, 0 } }, /* consulting */
    { .label = { 131967,  7, 0 } }, /* contact */
    { .label = {  59764, 11, 0 } }, /* contractors */
    { .label = {  29599,  7, 0 } }, /* cooking */
    { .label = {  29599, 14, 0 } }, /* cookingchannel */
    { .label = { 167236,  4, 1 } }, { .child = { 9261, 1 } }, /* cool */
    { .label = { 131996,  7, 0 } }, /* corsica */
    { .label = {  20222,  7, 0 } }, /* country */
    { .label = { 132025,  6, 0 } }, /* coupon */
    { .label = { 132025,  7, 0 } }, /* coupons */
    { .label = { 132057,  7, 0 } }, /* courses */
    { .label = {  59809,  6, 0 } }, /* credit */
    { .label = {  74828, 10, 0 } }, /* creditcard */
    { .label = {  59809, 11, 0 } }, /* creditunion */
    { .label = { 132087,  7, 0 } }, /* cricket */
    { .label = { 162480,  5, 0 } }, /* crown */
    { .label = {   9533,  3, 0 } }, /* crs */
    { .label = { 132118,  6, 0 } }, /* cruise */
    { .label = { 132118,  7, 0 } }, /* cruises */
    { .label = {  17626,  3, 0 } }, /* csc */
    { .label = {  74871, 10, 0 } }, /* cuisinella */
    { .label = { 159153,  5, 0 } }, /* cymru */
    { .label = { 167254,  4, 0 } }, /* cyou */
    { .label = { 162503,  5, 0 } }, /* dabur */
    { .label = {  91840,  3, 0 } }, /* dad */
    { .label = { 162526,  5, 0 } }, /* dance */
    { .label = {  76718,  4, 0 } }, /* data */
    { .label = {  30999,  4, 0 } }, /* date */
    { .label = { 151441,  6, 0 } }, /* dating */
    { .label = { 151466,  6, 0 } }, /* datsun */
    { .label = {  11041,  3, 0 } }, /* day */
    { .label = { 167274,  4, 0 } }, /* dclk */
    { .label = {  41833,  3, 0 } }, /* dds */
    { .label = {  65421,  4, 0 } }, /* deal */
    { .label = { 151491,  6, 0 } }, /* dealer */
    { .label = { 162547,  5, 0 } }, /* deals */
    { .label = { 151516,  6, 0 } }, /* degree */
    { .label = { 112945,  8, 0 } }, /* delivery */
    { .label = {   3397,  4, 0 } }, /* dell */
    { .label = { 112983,  8, 0 } }, /* deloitte */
    { .label = { 162568,  5, 0 } }, /* delta */
    { .label = {  38873,  8, 0 } }, /* democrat */
    { .label = { 151542,  6, 0 } }, /* dental */
    { .label = {    243,  7, 0 } }, /* dentist */
    { .label = {  26610,  4, 0 } }, /* desi */
    { .label = {  26610,  6, 0 } }, /* design */
    { .label = {   9807,  3, 0 } }, /* dev */
    { .label = {    339,  3, 0 } }, /* dhl */
    { .label = { 113017,  8, 0 } }, /* diamonds */
    { .label = { 167294,  4, 0 } }, /* diet */
    { .label = { 132148,  7, 0 } }, /* digital */
    { .label = {  13394,  6, 1 } }, { .child = { 9262, 1 } }, /* direct */
    { .label = {  13394,  9, 0 } }, /* directory */
    { .label = { 113051,  8, 0 } }, /* discount */
    { .label = {  86996,  8, 0 } }, /* discover */
    { .label = {  29681,  4, 0 } }, /* dish */
    { .label = { 169334,  3, 0 } }, /* diy */
    { .label = {  81611,  3, 0 } }, /* dnp */
    { .label = { 167311,  4, 0 } }, /* docs */
    { .label = {  63634,  6, 0 } }, /* doctor */
    { .label = { 162589,  5, 0 } }, /* dodge */
    { .label = {  11089,  3, 0 } }, /* dog */
    { .label = { 167329,  4, 0 } }, /* doha */
    { .label = { 132178,  7, 0 } }, /* domains */
    { .label = {  54947,  3, 0 } }, /* dot */
    { .label = { 113086,  8, 0 } }, /* download */
    { .label = { 162612,  5, 0 } }, /* drive */
    { .label = {  58179,  3, 0 } }, /* dtv */
    { .label = { 162635,  5, 0 } }, /* dubai */
    { .label = { 135110,  4, 0 } }, /* duck */
    { .label = { 151567,  6, 0 } }, /* dunlop */
    { .label = { 167346,  4, 0 } }, /* duns */
    { .label = { 151596,  6, 0 } }, /* dupont */
    { .label = { 151624,  6, 0 } }, /* durban */
    { .label = { 167364,  4, 0 } }, /* dvag */
    { .label = {  43902,  3, 0 } }, /* dvr */
    { .label = { 162658,  5, 0 } }, /* earth */
    { .label = {   3448,  3, 0 } }, /* eat */
    { .label = {    102,  3, 0 } }, /* eco */
    { .label = { 162678,  5, 0 } }, /* edeka */
    { .label = {  42919,  9, 0 } }, /* education */
    { .label = {  39839,  5, 0 } }, /* email */
    { .label = { 151651,  6, 0 } }, /* emerck */
    { .label = { 151678,  6, 0 } }, /* energy */
    { .label = {  31214,  8, 0 } }, /* engineer */
    { .label = {  59856, 11, 0 } }, /* engineering */
    { .label = {  59902, 11, 0 } }, /* enterprises */
    { .label = {    320,  5, 0 } }, /* epost */
    { .label = { 162699,  5, 0 } }, /* epson */
    { .label = {  34406,  9, 0 } }, /* equipment */
    { .label = { 113122,  8, 0 } }, /* ericsson */
    { .label = {  73964,  4, 0 } }, /* erni */
    { .label = { 134771,  3, 0 } }, /* esq */
    { .label = {  20254,  6, 1 } }, { .child = { 9263, 1 } }, /* estate */
    { .label = { 113155,  8, 0 } }, /* esurance */
    { .label = { 113188,  8, 0 } }, /* etisalat */
    { .label = {  74914, 10, 0 } }, /* eurovision */
    { .label = {    325,  3, 1 } }, { .child = { 9266, 1 } }, /* eus */
    { .label = { 151705,  6, 0 } }, /* events */
    { .label = { 113219,  8, 0 } }, /* everbank */
    { .label = {  40010,  8, 0 } }, /* exchange */
    { .label = {   7850,  6, 0 } }, /* expert */
    { .label = { 132207,  7, 0 } }, /* exposed */
    { .label = {  22780,  7, 0 } }, /* express */
    { .label = {  74957, 10, 0 } }, /* extraspace */
    { .label = { 167383,  4, 0 } }, /* fage */
    { .label = {  56536,  4, 0 } }, /* fail */
    { .label = {  92750,  9, 0 } }, /* fairwinds */
    { .label = { 162721,  5, 1 } }, { .child = { 9269, 1 } }, /* faith */
    { .label = {  29356,  6, 0 } }, /* family */
    { .label = {   3070,  3, 0 } }, /* fan */
    { .label = {  66236,  4, 0 } }, /* fans */
    { .label = {  13412,  4, 1 } }, { .child = { 9270, 1 } }, /* farm */
    { .label = { 126193,  7, 0 } }, /* farmers */
    { .label = { 132240,  7, 0 } }, /* fashion */
    { .label = {  31438,  4, 0 } }, /* fast */
    { .label = { 162743,  5, 0 } }, /* fedex */
    { .label = { 113255,  8, 0 } }, /* feedback */
    { .label = { 132270,  7, 0 } }, /* ferrari */
    { .label = { 132299,  7, 0 } }, /* ferrero */
    { .label = { 167401,  4, 0 } }, /* fiat */
    { .label = { 113293,  8, 0 } }, /* fidelity */
    { .label = { 167418,  4, 0 } }, /* fido */
    { .label = {  79860,  4, 0 } }, /* film */
    { .label = { 162768,  5, 0 } }, /* final */
    { .label = { 132329,  7, 0 } }, /* finance */
    { .label = {   3951,  9, 0 } }, /* financial */
    { .label = {  14998,  4, 0 } }, /* fire */
    { .label = {  92790,  9, 0 } }, /* firestone */
    { .label = { 113331,  8, 0 } }, /* firmdale */
    { .label = { 132359,  4, 0 } }, /* fish */
    { .label = { 132359,  7, 0 } }, /* fishing */
    { .label = {  19555,  3, 1 } }, { .child = { 9271, 1 } }, /* fit */
    { .label = { 132391,  7, 0 } }, /* fitness */
    { .label = { 151731,  6, 0 } }, /* flickr */
    { .label = { 132421,  7, 0 } }, /* flights */
    { .label = { 167437,  4, 0 } }, /* flir */
    { .label = { 132454,  7, 0 } }, /* florist */
    { .label = { 132485,  7, 0 } }, /* flowers */
    { .label = {  50578,  3, 0 } }, /* fly */
    { .label = {  18969,  3, 0 } }, /* foo */
    { .label = {  59948,  4, 0 } }, /* food */
    { .label = {  59948, 11, 0 } }, /* foodnetwork */
    { .label = { 113367,  8, 0 } }, /* football */
    { .label = { 147190,  4, 0 } }, /* ford */
    { .label = { 162790,  5, 0 } }, /* forex */
    { .label = { 132518,  7, 0 } }, /* forsale */
    { .label = { 154699,  5, 0 } }, /* forum */
    { .label = {  70975, 10, 0 } }, /* foundation */
    { .label = { 155306,  3, 0 } }, /* fox */
    { .label = {  56117,  4, 0 } }, /* free */
    { .label = {  92828,  9, 0 } }, /* fresenius */
    { .label = {  51664,  3, 0 } }, /* frl */
    { .label = { 132548,  7, 0 } }, /* frogans */
    { .label = {  92867,  9, 0 } }, /* frontdoor */
    { .label = { 113404,  8, 0 } }, /* frontier */
    { .label = {  20035,  3, 0 } }, /* ftr */
    { .label = { 132578,  7, 0 } }, /* fujitsu */
    { .label = {  92906,  9, 0 } }, /* fujixerox */
    { .label = {  31526,  3, 0 } }, /* fun */
    { .label = { 107002,  4, 0 } }, /* fund */
    { .label = {  87347,  9, 0 } }, /* furniture */
    { .label = { 151760,  6, 0 } }, /* futbol */
    { .label = {  31720,  3, 0 } }, /* fyi */
    { .label = {    549,  3, 0 } }, /* gal */
    { .label = {  70334,  7, 0 } }, /* gallery */
    { .label = { 108253,  5, 0 } }, /* gallo */
    { .label = { 151790,  6, 0 } }, /* gallup */
    { .label = {  39212,  4, 0 } }, /* game */
    { .label = {  39212,  5, 0 } }, /* games */
    { .label = {  51000,  3, 0 } }, /* gap */
    { .label = {  19526,  6, 0 } }, /* garden */
    { .label = { 167456,  4, 0 } }, /* gbiz */
    { .label = {  10260,  3, 1 } }, { .child = { 9272, 1 } }, /* gdn */
    { .label = {  24723,  3, 0 } }, /* gea */
    { .label = {  13266,  4, 0 } }, /* gent */
    { .label = { 132613,  7, 0 } }, /* genting */
    { .label = { 151819,  6, 0 } }, /* george */
    { .label = { 167478,  4, 0 } }, /* ggee */
    { .label = {  75567,  4, 0 } }, /* gift */
    { .label = { 162814,  5, 0 } }, /* gifts */
    { .label = { 162837,  5, 0 } }, /* gives */
    { .label = { 151845,  6, 0 } }, /* giving */
    { .label = { 162860,  5, 0 } }, /* glade */
    { .label = { 159247,  5, 0 } }, /* glass */
    { .label = {   5340,  3, 0 } }, /* gle */
    { .label = { 151873,  6, 0 } }, /* global */
    { .label = { 162882,  5, 0 } }, /* globo */
    { .label = { 132837,  5, 0 } }, /* gmail */
    { .label = { 167496,  4, 0 } }, /* gmbh */
    { .label = {  71457,  3, 0 } }, /* gmo */
    { .label = {  16468,  3, 0 } }, /* gmx */
    { .label = { 132643,  7, 0 } }, /* godaddy */
    { .label = {  92952,  4, 0 } }, /* gold */
    { .label = {  92952,  9, 0 } }, /* goldpoint */
    { .label = { 138113,  4, 0 } }, /* golf */
    { .label = {  17103,  3, 0 } }, /* goo */
    { .label = {  92993,  9, 0 } }, /* goodhands */
    { .label = { 113438,  8, 0 } }, /* goodyear */
    { .label = {  78364,  4, 1 } }, { .child = { 9273, 1 } }, /* goog */
    { .label = {  78364,  6, 0 } }, /* google */
    { .label = {  64576,  3, 0 } }, /* gop */
    { .label = {  42133,  3, 0 } }, /* got */
    { .label = { 113473,  8, 0 } }, /* grainger */
    { .label = {  34587,  8, 0 } }, /* graphics */
    { .label = { 151901,  6, 0 } }, /* gratis */
    { .label = {  77533,  5, 0 } }, /* green */
    { .label = { 162906,  5, 0 } }, /* gripe */
    { .label = { 132676,  7, 0 } }, /* grocery */
    { .label = {  40373,  5, 0 } }, /* group */
    { .label = { 113506,  8, 0 } }, /* guardian */
    { .label = { 162929,  5, 0 } }, /* gucci */
    { .label = { 167517,  4, 0 } }, /* guge */
    { .label = { 162953,  5, 0 } }, /* guide */
    { .label = { 132708,  7, 0 } }, /* guitars */
    { .label = {  95128,  4, 0 } }, /* guru */
    { .label = { 167536,  4, 0 } }, /* hair */
    { .label = { 126376,  7, 0 } }, /* hamburg */
    { .label = { 132737,  7, 0 } }, /* hangout */
    { .label = { 131487,  4, 0 } }, /* haus */
    { .label = {  78519,  3, 0 } }, /* hbo */
    { .label = { 113539,  4, 0 } }, /* hdfc */
    { .label = { 113539,  8, 0 } }, /* hdfcbank */
    { .label = {   1503,  6, 0 } }, /* health */
    { .label = {  75000, 10, 0 } }, /* healthcare */
    { .label = {  32930,  4, 0 } }, /* help */
    { .label = { 107074,  8, 0 } }, /* helsinki */
    { .label = {  10067,  4, 0 } }, /* here */
    { .label = { 151925,  6, 0 } }, /* hermes */
    { .label = { 167552,  4, 0 } }, /* hgtv */
    { .label = { 151951,  6, 0 } }, /* hiphop */
    { .label = {  93032,  9, 0 } }, /* hisamitsu */
    { .label = {  41845,  7, 0 } }, /* hitachi */
    { .label = {  91959,  3, 0 } }, /* hiv */
    { .label = {  45435,  3, 0 } }, /* hkt */
    { .label = {  39309,  6, 0 } }, /* hockey */
    { .label = { 113578,  8, 0 } }, /* holdings */
    { .label = { 132767,  7, 0 } }, /* holiday */
    { .label = {  93070,  9, 0 } }, /* homedepot */
    { .label = {  93111,  9, 0 } }, /* homegoods */
    { .label = {  24410,  5, 0 } }, /* homes */
    { .label = {  93151,  9, 0 } }, /* homesense */
    { .label = { 162976,  5, 0 } }, /* honda */
    { .label = {  93189,  9, 0 } }, /* honeywell */
    { .label = { 162997,  5, 0 } }, /* horse */
    { .label = { 113614,  8, 0 } }, /* hospital */
    { .label = {  23565,  4, 1 } }, { .child = { 9274, 4 } }, /* host */
    { .label = {  23565,  7, 1 } }, { .child = { 9278, 1 } }, /* hosting */
    { .label = {   9899,  3, 0 } }, /* hot */
    { .label = { 132799,  7, 0 } }, /* hoteles */
    { .label = {  60068,  6, 0 } }, /* hotels */
    { .label = { 132829,  7, 0 } }, /* hotmail */
    { .label = {  26548,  5, 0 } }, /* house */
    { .label = {    257,  3, 0 } }, /* how */
    { .label = { 167572,  4, 0 } }, /* hsbc */
    { .label = { 151981,  6, 0 } }, /* hughes */
    { .label = { 163018,  5, 0 } }, /* hyatt */
    { .label = { 132859,  7, 0 } }, /* hyundai */
    { .label = {  30611,  3, 0 } }, /* ibm */
    { .label = { 167592,  4, 0 } }, /* icbc */
    { .label = {   6768,  3, 0 } }, /* ice */
    { .label = {  22830,  3, 0 } }, /* icu */
    { .label = { 167612,  4, 0 } }, /* ieee */
    { .label = { 101151,  3, 0 } }, /* ifm */
    { .label = { 142903,  5, 0 } }, /* ikano */
    { .label = { 152009,  6, 0 } }, /* imamat */
    { .label = { 167628,  4, 0 } }, /* imdb */
    { .label = {  75042,  4, 0 } }, /* immo */
    { .label = {  75042, 10, 0 } }, /* immobilien */
    { .label = {  19520,  3, 0 } }, /* inc */
    { .label = {  75087, 10, 0 } }, /* industries */
    { .label = { 113649,  8, 0 } }, /* infiniti */
    { .label = {  10040,  3, 0 } }, /* ing */
    { .label = {   9078,  3, 0 } }, /* ink */
    { .label = {  93232,  9, 0 } }, /* institute */
    { .label = {   1529,  9, 0 } }, /* insurance */
    { .label = { 152033,  6, 0 } }, /* insure */
    { .label = {  43425,  5, 0 } }, /* intel */
    { .label = {  37829, 13, 0 } }, /* international */
    { .label = { 152058,  6, 0 } }, /* intuit */
    { .label = {  59998, 11, 0 } }, /* investments */
    { .label = { 113683,  8, 0 } }, /* ipiranga */
    { .label = { 163040,  5, 0 } }, /* irish */
    { .label = { 132891,  7, 0 } }, /* iselect */
    { .label = { 132921,  7, 0 } }, /* ismaili */
    { .label = {    260,  3, 0 } }, /* ist */
    { .label = { 113716,  8, 0 } }, /* istanbul */
    { .label = {  27846,  4, 0 } }, /* itau */
    { .label = { 169349,  3, 0 } }, /* itv */
    { .label = { 163061,  5, 0 } }, /* iveco */
    { .label = { 152083,  6, 0 } }, /* jaguar */
    { .label = { 167648,  4, 0 } }, /* java */
    { .label = { 156395,  3, 0 } }, /* jcb */
    { .label = { 169363,  3, 0 } }, /* jcp */
    { .label = { 167667,  4, 0 } }, /* jeep */
    { .label = { 163084,  5, 0 } }, /* jetzt */
    { .label = { 126469,  7, 0 } }, /* jewelry */
    { .label = { 121583,  3, 0 } }, /* jio */
    { .label = {  91684,  3, 0 } }, /* jlc */
    { .label = { 126549,  3, 0 } }, /* jll */
    { .label = { 169381,  3, 0 } }, /* jmp */
    { .label = { 163086,  3, 0 } }, /* jnj */
    { .label = { 152110,  6, 0 } }, /* joburg */
    { .label = {  99958,  3, 0 } }, /* jot */
    { .label = {  44343,  3, 0 } }, /* joy */
    { .label = { 113751,  8, 0 } }, /* jpmorgan */
    { .label = { 167688,  4, 0 } }, /* jprs */
    { .label = { 152141,  6, 0 } }, /* juegos */
    { .label = { 132950,  7, 0 } }, /* juniper */
    { .label = { 152170,  6, 0 } }, /* kaufen */
    { .label = { 141377,  4, 0 } }, /* kddi */
    { .label = {  60045, 11, 0 } }, /* kerryhotels */
    { .label = {  29660, 14, 0 } }, /* kerrylogistics */
    { .label = {  22812, 15, 0 } }, /* kerryproperties */
    { .label = { 169399,  3, 0 } }, /* kfh */
    { .label = {  38600,  3, 0 } }, /* kia */
    { .label = {  59303,  3, 0 } }, /* kim */
    { .label = { 152197,  6, 0 } }, /* kinder */
    { .label = { 152223,  6, 0 } }, /* kindle */
    { .label = { 132984,  7, 0 } }, /* kitchen */
    { .label = { 166553,  4, 0 } }, /* kiwi */
    { .label = { 122194,  5, 0 } }, /* koeln */
    { .label = {  42654,  7, 0 } }, /* komatsu */
    { .label = { 152250,  6, 0 } }, /* kosher */
    { .label = { 167709,  4, 0 } }, /* kpmg */
    { .label = { 168009,  3, 0 } }, /* kpn */
    { .label = {  11598,  3, 1 } }, { .child = { 9279, 2 } }, /* krd */
    { .label = { 167730,  4, 0 } }, /* kred */
    { .label = {  93269,  9, 0 } }, /* kuokgroup */
    { .label = { 156083,  5, 0 } }, /* kyoto */
    { .label = { 133015,  7, 0 } }, /* lacaixa */
    { .label = {  93312,  9, 0 } }, /* ladbrokes */
    { .label = {  60094, 11, 0 } }, /* lamborghini */
    { .label = {  14676,  5, 0 } }, /* lamer */
    { .label = {  93352,  9, 0 } }, /* lancaster */
    { .label = { 152276,  6, 0 } }, /* lancia */
    { .label = { 133044,  7, 0 } }, /* lancome */
    { .label = {   3685,  4, 1 } }, { .child = { 9281, 1 } }, /* land */
    { .label = {  93388,  9, 0 } }, /* landrover */
    { .label = { 133074,  7, 0 } }, /* lanxess */
    { .label = { 133104,  7, 0 } }, /* lasalle */
    { .label = {   9423,  3, 0 } }, /* lat */
    { .label = { 152300,  6, 0 } }, /* latino */
    { .label = { 133133,  7, 0 } }, /* latrobe */
    { .label = {  20188,  3, 0 } }, /* law */
    { .label = {  63776,  6, 0 } }, /* lawyer */
    { .label = {  35716,  3, 0 } }, /* lds */
    { .label = { 163110,  5, 0 } }, /* lease */
    { .label = { 133163,  7, 0 } }, /* leclerc */
    { .label = { 152324,  6, 0 } }, /* lefrak */
    { .label = { 163130,  5, 0 } }, /* legal */
    { .label = { 128557,  4, 0 } }, /* lego */
    { .label = { 163152,  5, 0 } }, /* lexus */
    { .label = { 167748,  4, 0 } }, /* lgbt */
    { .label = { 133195,  7, 0 } }, /* liaison */
    { .label = { 167768,  4, 0 } }, /* lidl */
    { .label = {  37880,  4, 0 } }, /* life */
    { .label = {  37880, 13, 0 } }, /* lifeinsurance */
    { .label = {  93427,  9, 0 } }, /* lifestyle */
    { .label = { 113789,  8, 0 } }, /* lighting */
    { .label = {  11697,  4, 0 } }, /* like */
    { .label = { 163176,  5, 0 } }, /* lilly */
    { .label = { 133223,  7, 0 } }, /* limited */
    { .label = { 122761,  4, 0 } }, /* limo */
    { .label = { 126597,  7, 0 } }, /* lincoln */
    { .label = {  89963,  5, 0 } }, /* linde */
    { .label = {  31566,  4, 1 } }, { .child = { 9285, 2 } }, /* link */
    { .label = { 163201,  5, 0 } }, /* lipsy */
    { .label = {   4129,  4, 0 } }, /* live */
    { .label = {  20286,  6, 0 } }, /* living */
    { .label = { 163226,  5, 0 } }, /* lixil */
    { .label = {  32798,  3, 0 } }, /* llc */
    { .label = { 163250,  4, 0 } }, /* loan */
    { .label = { 163250,  5, 0 } }, /* loans */
    { .label = { 152351,  6, 0 } }, /* locker */
    { .label = { 163270,  5, 0 } }, /* locus */
    { .label = { 167787,  4, 0 } }, /* loft */
    { .label = {   2308,  3, 0 } }, /* lol */
    { .label = { 146861,  6, 0 } }, /* london */
    { .label = { 163293,  5, 0 } }, /* lotte */
    { .label = { 163314,  5, 0 } }, /* lotto */
    { .label = {  50810,  4, 0 } }, /* love */
    { .label = {  48103,  3, 0 } }, /* lpl */
    { .label = {  48103, 12, 0 } }, /* lplfinancial */
    { .label = { 129382,  3, 0 } }, /* ltd */
    { .label = { 129382,  4, 0 } }, /* ltda */
    { .label = { 113825,  8, 0 } }, /* lundbeck */
    { .label = { 163335,  5, 0 } }, /* lupin */
    { .label = {  71326,  4, 0 } }, /* luxe */
    { .label = { 152378,  6, 0 } }, /* luxury */
    { .label = { 163359,  5, 0 } }, /* macys */
    { .label = { 146944,  6, 0 } }, /* madrid */
    { .label = {  40141,  4, 0 } }, /* maif */
    { .label = {  23736,  6, 0 } }, /* maison */
    { .label = { 152409,  6, 0 } }, /* makeup */
    { .label = {   2844,  3, 0 } }, /* man */
    { .label = {  75129, 10, 1 } }, { .child = { 9287, 1 } }, /* management */
    { .label = { 163382,  5, 0 } }, /* mango */
    { .label = {  10158,  3, 0 } }, /* map */
    { .label = {  43400,  6, 0 } }, /* market */
    { .label = {  93469,  9, 0 } }, /* marketing */
    { .label = { 133254,  7, 0 } }, /* markets */
    { .label = { 113864,  8, 0 } }, /* marriott */
    { .label = {  93507,  9, 0 } }, /* marshalls */
    { .label = { 113896,  8, 0 } }, /* maserati */
    { .label = { 152437,  6, 0 } }, /* mattel */
    { .label = {   6144,  3, 0 } }, /* mba */
    { .label = { 113927,  8, 0 } }, /* mckinsey */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = {  96066,  5, 0 } }, /* media */
    { .label = { 167806,  4, 0 } }, /* meet */
    { .label = {  93545,  9, 0 } }, /* melbourne */
    { .label = { 167823,  4, 0 } }, /* meme */
    { .label = { 107381,  8, 0 } }, /* memorial */
    { .label = {    591,  3, 0 } }, /* men */
    { .label = { 167841,  4, 1 } }, { .child = { 9288, 1 } }, /* menu */
    { .label = { 113964,  8, 0 } }, /* merckmsd */
    { .label = { 133283,  7, 0 } }, /* metlife */
    { .label = { 163403,  5, 0 } }, /* miami */
    { .label = {  93586,  9, 0 } }, /* microsoft */
    { .label = {  78718,  4, 0 } }, /* mini */
    { .label = { 167859,  4, 0 } }, /* mint */
    { .label = {   7410,  3, 0 } }, /* mit */
    { .label = {  75170, 10, 0 } }, /* mitsubishi */
    { .label = {  24319,  3, 0 } }, /* mlb */
    { .label = {   2429,  3, 0 } }, /* mls */
    { .label = {  33312,  3, 0 } }, /* mma */
    { .label = {  50778,  6, 0 } }, /* mobile */
    { .label = { 152462,  6, 0 } }, /* mobily */
    { .label = {  83106,  4, 0 } }, /* moda */
    { .label = {   3774,  3, 0 } }, /* moe */
    { .label = {  17528,  3, 0 } }, /* moi */
    { .label = {  72240,  3, 0 } }, /* mom */
    { .label = { 152492,  6, 0 } }, /* monash */
    { .label = { 159312,  5, 0 } }, /* money */
    { .label = { 133315,  7, 0 } }, /* monster */
    { .label = { 163424,  5, 0 } }, /* mopar */
    { .label = { 152517,  6, 0 } }, /* mormon */
    { .label = { 114001,  8, 0 } }, /* mortgage */
    { .label = { 147072,  6, 0 } }, /* moscow */
    { .label = {  60143,  4, 0 } }, /* moto */
    { .label = {  60143, 11, 0 } }, /* motorcycles */
    { .label = {  16453,  3, 0 } }, /* mov */
    { .label = { 163446,  5, 0 } }, /* movie */
    { .label = { 114035,  8, 0 } }, /* movistar */
    { .label = {   2551,  3, 0 } }, /* msd */
    { .label = {  23639,  3, 0 } }, /* mtn */
    { .label = {   5785,  3, 0 } }, /* mtr */
    { .label = {   9898,  6, 0 } }, /* mutual */
    { .label = {    275,  3, 0 } }, /* nab */
    { .label = { 163469,  5, 0 } }, /* nadex */
    { .label = { 140251,  6, 0 } }, /* nagoya */
    { .label = {  75215, 10, 0 } }, /* nationwide */
    { .label = {   4389,  6, 0 } }, /* natura */
    { .label = {  35241,  4, 0 } }, /* navy */
    { .label = {    398,  3, 0 } }, /* nba */
    { .label = {   5325,  3, 0 } }, /* nec */
    { .label = { 133344,  7, 0 } }, /* netbank */
    { .label = { 133374,  7, 0 } }, /* netflix */
    { .label = {  59967,  7, 1 } }, { .child = { 9289, 1 } }, /* network */
    { .label = { 133407,  7, 0 } }, /* neustar */
    { .label = {  17705,  3, 0 } }, /* new */
    { .label = {  75257, 10, 0 } }, /* newholland */
    { .label = {  17705,  4, 0 } }, /* news */
    { .label = {  74953,  4, 0 } }, /* next */
    { .label = {  75302, 10, 0 } }, /* nextdirect */
    { .label = { 163491,  5, 0 } }, /* nexus */
    { .label = {  49448,  3, 0 } }, /* nfl */
    { .label = {  10027,  3, 0 } }, /* ngo */
    { .label = {   1192,  3, 0 } }, /* nhk */
    { .label = { 153471,  4, 0 } }, /* nico */
    { .label = {  64931,  4, 0 } }, /* nike */
    { .label = { 163514,  5, 0 } }, /* nikon */
    { .label = { 163535,  5, 0 } }, /* ninja */
    { .label = { 152543,  6, 0 } }, /* nissan */
    { .label = { 152566,  6, 0 } }, /* nissay */
    { .label = { 119184,  5, 0 } }, /* nokia */
    { .label = {   9847, 18, 0 } }, /* northwesternmutual */
    { .label = { 152591,  6, 0 } }, /* norton */
    { .label = {    540,  3, 0 } }, /* now */
    { .label = { 152615,  6, 0 } }, /* nowruz */
    { .label = { 163557,  5, 0 } }, /* nowtv */
    { .label = {   4777,  3, 0 } }, /* nra */
    { .label = {  62569,  3, 0 } }, /* nrw */
    { .label = {   7120,  3, 0 } }, /* ntt */
    { .label = { 114299,  3, 0 } }, /* nyc */
    { .label = {   3400,  3, 0 } }, /* obi */
    { .label = { 114069,  8, 0 } }, /* observer */
    { .label = {  38537,  3, 0 } }, /* off */
    { .label = {  38537,  6, 0 } }, /* office */
    { .label = { 120043,  7, 0 } }, /* okinawa */
    { .label = {  60193,  6, 0 } }, /* olayan */
    { .label = {  60193, 11, 0 } }, /* olayangroup */
    { .label = { 133435,  7, 0 } }, /* oldnavy */
    { .label = { 167876,  4, 0 } }, /* ollo */
    { .label = { 163581,  5, 0 } }, /* omega */
    { .label = {   7853,  3, 1 } }, { .child = { 9292, 1 } }, /* one */
    { .label = {   1425,  3, 0 } }, /* ong */
    { .label = {   5913,  3, 0 } }, /* onl */
    { .label = {  64767,  6, 1 } }, { .child = { 9293, 1 } }, /* online */
    { .label = {  75346, 10, 0 } }, /* onyourside */
    { .label = {  20638,  3, 0 } }, /* ooo */
    { .label = {  70714,  4, 0 } }, /* open */
    { .label = { 152645,  6, 0 } }, /* oracle */
    { .label = { 152670,  6, 0 } }, /* orange */
    { .label = {  31779,  7, 0 } }, /* organic */
    { .label = { 133468,  7, 0 } }, /* origins */
    { .label = {  42379,  5, 0 } }, /* osaka */
    { .label = {  68249,  6, 0 } }, /* otsuka */
    { .label = {  47483,  3, 0 } }, /* ott */
    { .label = {  43250,  3, 1 } }, { .child = { 9294, 1 } }, /* ovh */
    { .label = {  10166,  4, 0 } }, /* page */
    { .label = {  93626,  9, 0 } }, /* panasonic */
    { .label = { 133497,  7, 0 } }, /* panerai */
    { .label = { 159439,  5, 0 } }, /* paris */
    { .label = {  10237,  4, 0 } }, /* pars */
    { .label = { 114105,  8, 0 } }, /* partners */
    { .label = { 163602,  5, 0 } }, /* parts */
    { .label = { 163623,  5, 1 } }, { .child = { 9295, 1 } }, /* party */
    { .label = {  93663,  9, 0 } }, /* passagens */
    { .label = { 150922,  3, 0 } }, /* pay */
    { .label = { 167894,  4, 0 } }, /* pccw */
    { .label = {  28716,  3, 0 } }, /* pet */
    { .label = { 152694,  6, 0 } }, /* pfizer */
    { .label = { 107763,  8, 0 } }, /* pharmacy */
    { .label = {  37584,  3, 0 } }, /* phd */
    { .label = { 133525,  7, 0 } }, /* philips */
    { .label = { 163646,  5, 0 } }, /* phone */
    { .label = {  13086,  5, 0 } }, /* photo */
    { .label = {  56604, 11, 0 } }, /* photography */
    { .label = { 115506,  6, 0 } }, /* photos */
    { .label = { 152725,  6, 0 } }, /* physio */
    { .label = { 152754,  6, 0 } }, /* piaget */
    { .label = {  63299,  4, 0 } }, /* pics */
    { .label = { 152780,  6, 0 } }, /* pictet */
    { .label = { 114138,  8, 1 } }, { .child = { 9296, 1 } }, /* pictures */
    { .label = {   5898,  3, 0 } }, /* pid */
    { .label = {  32166,  3, 0 } }, /* pin */
    { .label = {  56830,  4, 0 } }, /* ping */
    { .label = { 167916,  4, 0 } }, /* pink */
    { .label = { 133559,  7, 0 } }, /* pioneer */
    { .label = { 163669,  5, 0 } }, /* pizza */
    { .label = {  70432,  5, 0 } }, /* place */
    { .label = {  60242,  4, 0 } }, /* play */
    { .label = {  60242, 11, 0 } }, /* playstation */
    { .label = { 114174,  8, 0 } }, /* plumbing */
    { .label = { 138475,  4, 0 } }, /* plus */
    { .label = {  39204,  3, 0 } }, /* pnc */
    { .label = { 167935,  4, 0 } }, /* pohl */
    { .label = { 163696,  5, 0 } }, /* poker */
    { .label = { 133589,  7, 0 } }, /* politie */
    { .label = { 167955,  4, 0 } }, /* porn */
    { .label = {  93700,  9, 0 } }, /* pramerica */
    { .label = { 163719,  5, 0 } }, /* praxi */
    { .label = {  22790,  5, 0 } }, /* press */
    { .label = { 163742,  5, 0 } }, /* prime */
    { .label = {  60289,  4, 0 } }, /* prod */
    { .label = {  60289, 11, 0 } }, /* productions */
    { .label = {  51576,  4, 0 } }, /* prof */
    { .label = {  60338, 11, 0 } }, /* progressive */
    { .label = { 163765,  5, 0 } }, /* promo */
    { .label = {  22835, 10, 0 } }, /* properties */
    { .label = { 114214,  8, 0 } }, /* property */
    { .label = {  75390, 10, 0 } }, /* protection */
    { .label = {  75433,  3, 0 } }, /* pru */
    { .label = {  75433, 10, 0 } }, /* prudential */
    { .label = {  24180,  3, 1 } }, { .child = { 9297, 1 } }, /* pub */
    { .label = { 169415,  3, 0 } }, /* pwc */
    { .label = { 167973,  4, 0 } }, /* qpon */
    { .label = { 147314,  6, 0 } }, /* quebec */
    { .label = { 163788,  5, 0 } }, /* quest */
    { .label = { 169432,  3, 0 } }, /* qvc */
    { .label = { 152807,  6, 0 } }, /* racing */
    { .label = {  49700,  5, 0 } }, /* radio */
    { .label = { 167995,  4, 0 } }, /* raid */
    { .label = {  37946,  4, 0 } }, /* read */
    { .label = {  73450, 10, 0 } }, /* realestate */
    { .label = { 133620,  7, 0 } }, /* realtor */
    { .label = { 152832,  6, 0 } }, /* realty */
    { .label = { 133648,  7, 0 } }, /* recipes */
    { .label = {  17403,  3, 0 } }, /* red */
    { .label = { 114252,  8, 0 } }, /* redstone */
    { .label = {  60387, 11, 0 } }, /* redumbrella */
    { .label = { 163813,  5, 0 } }, /* rehab */
    { .label = { 152858,  5, 0 } }, /* reise */
    { .label = { 152858,  6, 0 } }, /* reisen */
    { .label = { 168011,  4, 0 } }, /* reit */
    { .label = { 114285,  8, 0 } }, /* reliance */
    { .label = {    469,  3, 0 } }, /* ren */
    { .label = {    469,  4, 0 } }, /* rent */
    { .label = { 133679,  7, 0 } }, /* rentals */
    { .label = { 152882,  6, 0 } }, /* repair */
    { .label = { 152907,  6, 0 } }, /* report */
    { .label = {  24172, 10, 0 } }, /* republican */
    { .label = {  38442,  4, 0 } }, /* rest */
    { .label = {  75477, 10, 0 } }, /* restaurant */
    { .label = { 133707,  6, 1 } }, { .child = { 9298, 1 } }, /* review */
    { .label = { 133707,  7, 0 } }, /* reviews */
    { .label = { 133739,  7, 0 } }, /* rexroth */
    { .label = {  26535,  4, 0 } }, /* rich */
    { .label = {  93738,  9, 0 } }, /* richardli */
    { .label = { 147762,  5, 0 } }, /* ricoh */
    { .label = {  60437, 11, 0 } }, /* rightathome */
    { .label = {  43272,  3, 0 } }, /* ril */
    { .label = {   3773,  3, 0 } }, /* rio */
    { .label = {   3842,  3, 1 } }, { .child = { 9299, 1 } }, /* rip */
    { .label = { 156808,  4, 0 } }, /* rmit */
    { .label = { 152933,  6, 0 } }, /* rocher */
    { .label = {  39038,  5, 1 } }, { .child = { 9300, 3 } }, /* rocks */
    { .label = { 163835,  5, 0 } }, /* rodeo */
    { .label = { 152959,  6, 0 } }, /* rogers */
    { .label = { 168027,  4, 0 } }, /* room */
    { .label = { 168044,  4, 0 } }, /* rsvp */
    { .label = { 163856,  5, 0 } }, /* rugby */
    { .label = { 168064,  4, 0 } }, /* ruhr */
    { .label = {  20840,  3, 1 } }, { .child = { 9303, 2 } }, /* run */
    { .label = {   6710,  3, 0 } }, /* rwe */
    { .label = { 152984,  6, 0 } }, /* ryukyu */
    { .label = { 114318,  8, 0 } }, /* saarland */
    { .label = {  12948,  4, 0 } }, /* safe */
    { .label = {  12948,  6, 0 } }, /* safety */
    { .label = {  68703,  6, 0 } }, /* sakura */
    { .label = {  50455,  4, 0 } }, /* sale */
    { .label = { 163882,  5, 0 } }, /* salon */
    { .label = { 114349,  8, 0 } }, /* samsclub */
    { .label = { 133770,  7, 0 } }, /* samsung */
    { .label = {  22879,  7, 0 } }, /* sandvik */
    { .label = {  22879, 15, 0 } }, /* sandvikcoromant */
    { .label = { 153015,  6, 0 } }, /* sanofi */
    { .label = {  19535,  3, 0 } }, /* sap */
    { .label = { 168082,  4, 0 } }, /* sarl */
    { .label = {   6917,  3, 0 } }, /* sas */
    { .label = {  17261,  4, 0 } }, /* save */
    { .label = {  73100,  4, 0 } }, /* saxo */
    { .label = {  37869,  3, 0 } }, /* sbi */
    { .label = {   5412,  3, 0 } }, /* sbs */
    { .label = {  12349,  3, 0 } }, /* sca */
    { .label = {  13182,  3, 0 } }, /* scb */
    { .label = {  75516, 10, 0 } }, /* schaeffler */
    { .label = { 133800,  7, 0 } }, /* schmidt */
    { .label = {  48157, 12, 0 } }, /* scholarships */
    { .label = { 147370,  6, 0 } }, /* school */
    { .label = { 153040,  6, 0 } }, /* schule */
    { .label = { 133832,  7, 0 } }, /* schwarz */
    { .label = {   8796,  7, 1 } }, { .child = { 9305, 1 } }, /* science */
    { .label = {  93777,  9, 0 } }, /* scjohnson */
    { .label = { 106611,  4, 0 } }, /* scor */
    { .label = {  55878,  4, 0 } }, /* scot */
    { .label = {  29574,  6, 0 } }, /* search */
    { .label = {  31746,  4, 0 } }, /* seat */
    { .label = {  49502,  6, 0 } }, /* secure */
    { .label = {  17554,  8, 0 } }, /* security */
    { .label = { 167277,  4, 0 } }, /* seek */
    { .label = { 132895,  6, 0 } }, /* select */
    { .label = { 163902,  5, 0 } }, /* sener */
    { .label = {  96761,  8, 0 } }, /* services */
    { .label = {  23694,  3, 0 } }, /* ses */
    { .label = { 140140,  5, 0 } }, /* seven */
    { .label = {  63307,  3, 0 } }, /* sew */
    { .label = {   6268,  3, 0 } }, /* sex */
    { .label = { 168098,  4, 0 } }, /* sexy */
    { .label = {  61484,  3, 0 } }, /* sfr */
    { .label = {  93818,  9, 0 } }, /* shangrila */
    { .label = { 163922,  5, 0 } }, /* sharp */
    { .label = { 168118,  4, 0 } }, /* shaw */
    { .label = { 159510,  5, 0 } }, /* shell */
    { .label = {   3668,  4, 0 } }, /* shia */
    { .label = { 133866,  7, 0 } }, /* shiksha */
    { .label = { 163944,  5, 0 } }, /* shoes */
    { .label = {  51187,  4, 1 } }, { .child = { 9306, 1 } }, /* shop */
    { .label = { 114386,  8, 0 } }, /* shopping */
    { .label = { 153068,  6, 0 } }, /* shouji */
    { .label = {    253,  4, 0 } }, /* show */
    { .label = { 114424,  8, 0 } }, /* showtime */
    { .label = { 133896,  7, 0 } }, /* shriram */
    { .label = { 166386,  4, 0 } }, /* silk */
    { .label = {  34184,  4, 0 } }, /* sina */
    { .label = { 133925,  7, 0 } }, /* singles */
    { .label = {    699,  4, 1 } }, { .child = { 9307, 4 } }, /* site */
    { .label = {  28294,  3, 0 } }, /* ski */
    { .label = {  63150,  4, 0 } }, /* skin */
    { .label = {  22430,  3, 0 } }, /* sky */
    { .label = { 163965,  5, 0 } }, /* skype */
    { .label = { 163990,  5, 0 } }, /* sling */
    { .label = {  17202,  5, 0 } }, /* smart */
    { .label = { 164012,  5, 0 } }, /* smile */
    { .label = { 168136,  4, 0 } }, /* sncf */
    { .label = { 153097,  6, 0 } }, /* soccer */
    { .label = {  31093,  6, 0 } }, /* social */
    { .label = { 114460,  8, 0 } }, /* softbank */
    { .label = {  96796,  8, 0 } }, /* software */
    { .label = { 168155,  4, 0 } }, /* sohu */
    { .label = { 164034,  5, 0 } }, /* solar */
    { .label = {  93855,  9, 0 } }, /* solutions */
    { .label = {  90607,  4, 0 } }, /* song */
    { .label = { 168173,  4, 0 } }, /* sony */
    { .label = {  14699,  3, 0 } }, /* soy */
    { .label = {  39527,  5, 1 } }, { .child = { 9313, 3 } }, /* space */
    { .label = { 133955,  7, 0 } }, /* spiegel */
    { .label = {  66249,  5, 0 } }, /* sport */
    { .label = { 116666,  4, 0 } }, /* spot */
    { .label = {  37936, 13, 0 } }, /* spreadbetting */
    { .label = {   2041,  3, 0 } }, /* srl */
    { .label = {   4708,  3, 0 } }, /* srt */
    { .label = {  84812,  5, 0 } }, /* stada */
    { .label = { 133987,  7, 0 } }, /* staples */
    { .label = {  21511,  4, 0 } }, /* star */
    { .label = { 134017,  7, 0 } }, /* starhub */
    { .label = {  93893,  9, 0 } }, /* statebank */
    { .label = {  93930,  9, 0 } }, /* statefarm */
    { .label = { 134048,  7, 0 } }, /* statoil */
    { .label = {   8741,  3, 0 } }, /* stc */
    { .label = { 114496,  8, 0 } }, /* stcgroup */
    { .label = {  88149,  9, 0 } }, /* stockholm */
    { .label = { 134076,  7, 0 } }, /* storage */
    { .label = { 155394,  5, 0 } }, /* store */
    { .label = { 153123,  6, 0 } }, /* stream */
    { .label = { 153147,  6, 0 } }, /* studio */
    { .label = { 164054,  5, 0 } }, /* study */
    { .label = {  93446,  5, 0 } }, /* style */
    { .label = { 164078,  5, 0 } }, /* sucks */
    { .label = { 114533,  8, 0 } }, /* supplies */
    { .label = { 153173,  6, 0 } }, /* supply */
    { .label = { 134104,  7, 1 } }, { .child = { 9316, 1 } }, /* support */
    { .label = { 168191,  4, 0 } }, /* surf */
    { .label = { 134137,  7, 0 } }, /* surgery */
    { .label = { 153205,  6, 0 } }, /* suzuki */
    { .label = { 153235,  6, 0 } }, /* swatch */
    { .label = {  75562, 10, 0 } }, /* swiftcover */
    { .label = { 164101,  5, 0 } }, /* swiss */
    { .label = { 147504,  6, 0 } }, /* sydney */
    { .label = { 114571,  8, 0 } }, /* symantec */
    { .label = {  24555,  7, 1 } }, { .child = { 9317, 1 } }, /* systems */
    { .label = {   3165,  3, 0 } }, /* tab */
    { .label = { 153262,  6, 0 } }, /* taipei */
    { .label = {  16616,  4, 0 } }, /* talk */
    { .label = { 153287,  6, 0 } }, /* taobao */
    { .label = { 153311,  6, 0 } }, /* target */
    { .label = {  75609, 10, 0 } }, /* tatamotors */
    { .label = { 117307,  5, 0 } }, /* tatar */
    { .label = { 153335,  6, 0 } }, /* tattoo */
    { .label = {   6269,  3, 0 } }, /* tax */
    { .label = {  19683,  4, 0 } }, /* taxi */
    { .label = {   5286,  3, 0 } }, /* tci */
    { .label = { 119434,  3, 0 } }, /* tdk */
    { .label = {  60091,  4, 0 } }, /* team */
    { .label = {  63922,  4, 0 } }, /* tech */
    { .label = {  71886, 10, 0 } }, /* technology */
    { .label = { 114606,  8, 0 } }, /* telecity */
    { .label = {  75648, 10, 0 } }, /* telefonica */
    { .label = { 134169,  7, 0 } }, /* temasek */
    { .label = { 153358,  6, 0 } }, /* tennis */
    { .label = {  40594,  4, 0 } }, /* teva */
    { .label = { 125742,  3, 0 } }, /* thd */
    { .label = { 127215,  7, 0 } }, /* theater */
    { .label = { 134198,  7, 0 } }, /* theatre */
    { .label = {  39953,  4, 0 } }, /* tiaa */
    { .label = { 134226,  7, 0 } }, /* tickets */
    { .label = { 153382,  6, 0 } }, /* tienda */
    { .label = { 134256,  7, 0 } }, /* tiffany */
    { .label = { 168210,  4, 0 } }, /* tips */
    { .label = {  22462,  5, 0 } }, /* tires */
    { .label = {    516,  5, 0 } }, /* tirol */
    { .label = { 153406,  6, 0 } }, /* tjmaxx */
    { .label = {  22565,  3, 0 } }, /* tjx */
    { .label = { 153437,  6, 0 } }, /* tkmaxx */
    { .label = { 107210,  5, 0 } }, /* tmall */
    { .label = { 164123,  5, 0 } }, /* today */
    { .label = { 156106,  5, 0 } }, /* tokyo */
    { .label = {  78697,  5, 0 } }, /* tools */
    { .label = {  64577,  3, 1 } }, { .child = { 9318, 2 } }, /* top */
    { .label = { 164145,  5, 0 } }, /* toray */
    { .label = { 134289,  7, 0 } }, /* toshiba */
    { .label = { 164166,  5, 0 } }, /* total */
    { .label = { 164186,  5, 0 } }, /* tours */
    { .label = {  17687,  4, 0 } }, /* town */
    { .label = { 140412,  6, 0 } }, /* toyota */
    { .label = { 168228,  4, 0 } }, /* toys */
    { .label = { 138832,  5, 1 } }, { .child = { 9320, 1 } }, /* trade */
    { .label = { 118264,  7, 0 } }, /* trading */
    { .label = { 114642,  8, 0 } }, /* training */
    { .label = {   9925,  6, 0 } }, /* travel */
    { .label = {  37993, 13, 0 } }, /* travelchannel */
    { .label = {   9925,  9, 0 } }, /* travelers */
    { .label = {   9925, 18, 0 } }, /* travelersinsurance */
    { .label = { 127275,  5, 0 } }, /* trust */
    { .label = { 169280,  3, 0 } }, /* trv */
    { .label = {  51626,  4, 0 } }, /* tube */
    { .label = {  50662,  3, 0 } }, /* tui */
    { .label = { 164207,  5, 0 } }, /* tunes */
    { .label = { 164228,  5, 0 } }, /* tushu */
    { .label = {  38142,  3, 0 } }, /* tvs */
    { .label = { 164251,  5, 0 } }, /* ubank */
    { .label = {  21444,  3, 0 } }, /* ubs */
    { .label = { 114674,  8, 0 } }, /* uconnect */
    { .label = { 153466,  6, 0 } }, /* unicom */
    { .label = {  71975, 10, 0 } }, /* university */
    { .label = {   1993,  3, 0 } }, /* uno */
    { .label = {   7472,  3, 0 } }, /* uol */
    { .label = {  26500,  3, 0 } }, /* ups */
    { .label = {  93967,  9, 0 } }, /* vacations */
    { .label = {  31577,  4, 0 } }, /* vana */
    { .label = { 114709,  8, 0 } }, /* vanguard */
    { .label = { 164274,  5, 0 } }, /* vegas */
    { .label = { 114744,  8, 0 } }, /* ventures */
    { .label = { 114779,  8, 0 } }, /* verisign */
    { .label = {  48210, 12, 0 } }, /* versicherung */
    { .label = {  51669,  3, 0 } }, /* vet */
    { .label = { 153493,  6, 0 } }, /* viajes */
    { .label = { 155646,  5, 0 } }, /* video */
    { .label = {  11323,  3, 0 } }, /* vig */
    { .label = { 147580,  6, 0 } }, /* viking */
    { .label = { 153521,  6, 0 } }, /* villas */
    { .label = {  20295,  3, 0 } }, /* vin */
    { .label = {   9087,  3, 0 } }, /* vip */
    { .label = { 108218,  6, 0 } }, /* virgin */
    { .label = {   9896,  4, 0 } }, /* visa */
    { .label = {  26847,  6, 0 } }, /* vision */
    { .label = {  75691,  5, 0 } }, /* vista */
    { .label = {  75691, 10, 0 } }, /* vistaprint */
    { .label = { 168246,  4, 0 } }, /* viva */
    { .label = { 168265,  4, 0 } }, /* vivo */
    { .label = {  72108, 10, 0 } }, /* vlaanderen */
    { .label = { 164296,  5, 0 } }, /* vodka */
    { .label = {  75734, 10, 0 } }, /* volkswagen */
    { .label = { 164319,  5, 0 } }, /* volvo */
    { .label = { 168285,  4, 0 } }, /* vote */
    { .label = { 153548,  6, 0 } }, /* voting */
    { .label = { 168303,  4, 0 } }, /* voto */
    { .label = { 153575,  6, 0 } }, /* voyage */
    { .label = { 153603,  6, 0 } }, /* vuelos */
    { .label = { 159596,  5, 0 } }, /* wales */
    { .label = { 134319,  7, 0 } }, /* walmart */
    { .label = { 153631,  6, 0 } }, /* walter */
    { .label = { 125420,  4, 0 } }, /* wang */
    { .label = { 134349,  7, 0 } }, /* wanggou */
    { .label = { 153657,  6, 0 } }, /* warman */
    { .label = {  20345,  5, 0 } }, /* watch */
    { .label = { 134381,  7, 0 } }, /* watches */
    { .label = {  29722,  7, 0 } }, /* weather */
    { .label = {  29722, 14, 0 } }, /* weatherchannel */
    { .label = { 153682,  6, 0 } }, /* webcam */
    { .label = { 164344,  5, 0 } }, /* weber */
    { .label = {    683,  7, 0 } }, /* website */
    { .label = {  28462,  3, 0 } }, /* wed */
    { .label = { 134412,  7, 0 } }, /* wedding */
    { .label = { 164368,  5, 0 } }, /* weibo */
    { .label = { 168321,  4, 0 } }, /* weir */
    { .label = { 134445,  7, 0 } }, /* whoswho */
    { .label = {    216,  4, 0 } }, /* wien */
    { .label = {  63351,  4, 0 } }, /* wiki */
    { .label = {  60484, 11, 0 } }, /* williamhill */
    { .label = {    479,  3, 0 } }, /* win */
    { .label = { 134479,  7, 0 } }, /* windows */
    { .label = {  14777,  4, 0 } }, /* wine */
    { .label = { 134512,  7, 0 } }, /* winners */
    { .label = {  60018,  3, 0 } }, /* wme */
    { .label = {  38049, 13, 0 } }, /* wolterskluwer */
    { .label = { 114814,  8, 0 } }, /* woodside */
    { .label = {  16899,  4, 0 } }, /* work */
    { .label = { 108364,  5, 0 } }, /* works */
    { .label = { 164392,  5, 0 } }, /* world */
    { .label = {  17685,  3, 0 } }, /* wow */
    { .label = { 169451,  3, 0 } }, /* wtc */
    { .label = { 169466,  3, 0 } }, /* wtf */
    { .label = { 168339,  4, 0 } }, /* xbox */
    { .label = {  92928,  5, 0 } }, /* xerox */
    { .label = { 134542,  7, 0 } }, /* xfinity */
    { .label = { 153711,  6, 0 } }, /* xihuan */
    { .label = {   8654,  3, 0 } }, /* xin */
    { .label = {  60535, 11, 0 } }, /* xn--11b4c3d */
    { .label = {  60604, 11, 0 } }, /* xn--1ck2e1b */
    { .label = {  60668, 11, 0 } }, /* xn--1qqw23a */
    { .label = {  75780, 10, 0 } }, /* xn--30rr7y */
    { .label = {  60737, 11, 0 } }, /* xn--3bst00m */
    { .label = {  60800, 11, 0 } }, /* xn--3ds443g */
    { .label = {  12279, 17, 0 } }, /* xn--3oq18vl8pn36a */
    { .label = {  75839, 10, 0 } }, /* xn--3pxu8k */
    { .label = {  60868, 11, 0 } }, /* xn--42c2d9a */
    { .label = {  75898, 10, 0 } }, /* xn--45q11c */
    { .label = {  75965, 10, 0 } }, /* xn--4gbrim */
    { .label = {  60936, 11, 0 } }, /* xn--55qw42g */
    { .label = {  66351, 10, 0 } }, /* xn--55qx5d */
    { .label = {  12386, 17, 0 } }, /* xn--5su34j936bgsg */
    { .label = {  76018, 10, 0 } }, /* xn--5tzm5g */
    { .label = {  61010, 11, 0 } }, /* xn--6frz82g */
    { .label = {  29782, 14, 0 } }, /* xn--6qq986b3xl */
    { .label = {  48264, 12, 0 } }, /* xn--80adxhks */
    { .label = {  29880, 14, 0 } }, /* xn--80aqecdr1a */
    { .label = {  48329, 12, 0 } }, /* xn--80asehdb */
    { .label = {  76077, 10, 0 } }, /* xn--80aswg */
    { .label = {  48393, 12, 0 } }, /* xn--8y0a063a */
    { .label = {  76132, 10, 0 } }, /* xn--9dbq2a */
    { .label = {  76192, 10, 0 } }, /* xn--9et52u */
    { .label = {  61078, 11, 0 } }, /* xn--9krt00a */
    { .label = {  29957, 14, 0 } }, /* xn--b4w605ferd */
    { .label = {  12495, 17, 0 } }, /* xn--bck1b9a5dre4c */
    { .label = {  92280,  9, 0 } }, /* xn--c1avg */
    { .label = {  76252, 10, 0 } }, /* xn--c2br7g */
    { .label = {  61140, 11, 0 } }, /* xn--cck2b3b */
    { .label = {  76309, 10, 0 } }, /* xn--cg4bki */
    { .label = {  61203, 11, 0 } }, /* xn--czr694b */
    { .label = {  76363, 10, 0 } }, /* xn--czrs0t */
    { .label = {  76415, 10, 0 } }, /* xn--czru2d */
    { .label = {  61273, 11, 0 } }, /* xn--d1acj3b */
    { .label = {  38109, 13, 0 } }, /* xn--eckvdtc9d */
    { .label = {  61335, 11, 0 } }, /* xn--efvy88h */
    { .label = {  61400, 11, 0 } }, /* xn--estv75g */
    { .label = {  61461, 11, 0 } }, /* xn--fct429k */
    { .label = {  94004,  9, 0 } }, /* xn--fhbei */
    { .label = {  30043, 14, 0 } }, /* xn--fiq228c5hs */
    { .label = {  76469, 10, 0 } }, /* xn--fiq64b */
    { .label = {  61528, 11, 0 } }, /* xn--fjq720a */
    { .label = {  61597, 11, 0 } }, /* xn--flw351e */
    { .label = {  16381, 16, 0 } }, /* xn--fzys8d69uvgm */
    { .label = {  61663, 11, 0 } }, /* xn--g2xx48c */
    { .label = {  48467, 12, 0 } }, /* xn--gckr3f0f */
    { .label = {  61731, 11, 0 } }, /* xn--gk3at1e */
    { .label = {  61788, 11, 0 } }, /* xn--hxt814e */
    { .label = {  22943, 15, 0 } }, /* xn--i1b6b1a6a2e */
    { .label = {  61853, 11, 0 } }, /* xn--imr513n */
    { .label = {  66417, 10, 0 } }, /* xn--io0a7i */
    { .label = {  94049,  9, 0 } }, /* xn--j1aef */
    { .label = {  30129, 14, 0 } }, /* xn--jlq61u9w7b */
    { .label = {  61915, 11, 0 } }, /* xn--jvr189m */
    { .label = {  23031, 15, 0 } }, /* xn--kcrx77d1x4a */
    { .label = {  61984, 11, 0 } }, /* xn--kpu716f */
    { .label = {  76531, 10, 0 } }, /* xn--kput3i */
    { .label = {  30222, 14, 0 } }, /* xn--mgba3a3ejt */
    { .label = {  16478, 16, 0 } }, /* xn--mgba7c0bbn0a */
    { .label = {  23120, 15, 0 } }, /* xn--mgbaakc7dvf */
    { .label = {  48534, 12, 0 } }, /* xn--mgbab2bd */
    { .label = {  30295, 14, 0 } }, /* xn--mgbb9fbpob */
    { .label = {  30375, 14, 0 } }, /* xn--mgbca7dzdo */
    { .label = {  30449, 14, 0 } }, /* xn--mgbi4ecexp */
    { .label = {  48598, 12, 0 } }, /* xn--mgbt3dhd */
    { .label = {  48661, 12, 0 } }, /* xn--mk1bu44c */
    { .label = {  66561, 10, 0 } }, /* xn--mxtq1m */
    { .label = {  48733, 12, 0 } }, /* xn--ngbc5azd */
    { .label = {  48797, 12, 0 } }, /* xn--ngbe9e0a */
    { .label = {  94097,  9, 0 } }, /* xn--ngbrx */
    { .label = {  23198,  9, 0 } }, /* xn--nqv7f */
    { .label = {  23198, 15, 0 } }, /* xn--nqv7fs00ema */
    { .label = {  62052, 11, 0 } }, /* xn--nyqy26a */
    { .label = {  62116, 11, 0 } }, /* xn--otu796d */
    { .label = {  94142,  9, 0 } }, /* xn--p1acf */
    { .label = {  62182, 11, 0 } }, /* xn--pbt977c */
    { .label = {  76583, 10, 0 } }, /* xn--pssy2u */
    { .label = {  62251, 11, 0 } }, /* xn--q9jyb4c */
    { .label = {  48861, 12, 0 } }, /* xn--qcka1pmc */
    { .label = {  62322, 11, 0 } }, /* xn--rhqv96g */
    { .label = {  62389, 11, 0 } }, /* xn--rovu88b */
    { .label = {  62452, 11, 0 } }, /* xn--ses554g */
    { .label = {  62516, 11, 0 } }, /* xn--t60b56a */
    { .label = {  94190,  9, 0 } }, /* xn--tckwe */
    { .label = {  38178, 13, 0 } }, /* xn--tiq49xqyj */
    { .label = {  76636, 10, 0 } }, /* xn--unup4y */
    { .label = {   1892, 23, 0 } }, /* xn--vermgensberater-ctb */
    { .label = {   1347, 24, 0 } }, /* xn--vermgensberatung-pwb */
    { .label = {  94234,  9, 0 } }, /* xn--vhquv */
    { .label = {  62584, 11, 0 } }, /* xn--vuq861b */
    { .label = {   4672, 20, 0 } }, /* xn--w4r85el8fhu5dnra */
    { .label = {  62655, 11, 0 } }, /* xn--w4rs40l */
    { .label = {  62720, 11, 0 } }, /* xn--xhq521b */
    { .label = {  62790, 11, 0 } }, /* xn--zfr164b */
    { .label = {  97989,  3, 1 } }, { .child = { 9321, 4 } }, /* xyz */
    { .label = { 153738,  6, 0 } }, /* yachts */
    { .label = { 164416,  5, 0 } }, /* yahoo */
    { .label = { 134576,  7, 0 } }, /* yamaxun */
    { .label = { 153765,  6, 0 } }, /* yandex */
    { .label = {  94284,  9, 0 } }, /* yodobashi */
    { .label = {  50505,  4, 0 } }, /* yoga */
    { .label = {  98420,  8, 0 } }, /* yokohama */
    { .label = {  11008,  3, 0 } }, /* you */
    { .label = {  64610,  7, 0 } }, /* youtube */
    { .label = {  21685,  3, 0 } }, /* yun */
    { .label = { 153793,  6, 0 } }, /* zappos */
    { .label = { 119656,  4, 0 } }, /* zara */
    { .label = {  79831,  4, 0 } }, /* zero */
    { .label = { 164438,  3, 0 } }, /* zip */
    { .label = { 164438,  5, 0 } }, /* zippo */
    { .label = {  40267,  4, 1 } }, { .child = { 9325, 2 } }, /* zone */
    { .label = { 134608,  7, 0 } }, /* zuerich */

    /* entries 1829 to 1834 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {    209,  3, 0 } }, /* org */

    /* entry 1835 */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entries 1836 to 1844 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   6667,  3, 0 } }, /* sch */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entries 1845 to 1931 */
    { .label = {   1997, 22, 0 } }, /* accident-investigation */
    { .label = {   5538, 19, 0 } }, /* accident-prevention */
    { .label = {  79798,  9, 0 } }, /* aerobatic */
    { .label = {  96590,  8, 0 } }, /* aeroclub */
    { .label = {  79835,  9, 0 } }, /* aerodrome */
    { .label = { 138756,  6, 0 } }, /* agents */
    { .label = {  96626,  8, 0 } }, /* aircraft */
    { .label = { 118050,  7, 0 } }, /* airline */
    { .label = { 118078,  7, 0 } }, /* airport */
    { .label = {  13517, 16, 0 } }, /* air-surveillance */
    { .label = {  65591, 10, 0 } }, /* airtraffic */
    { .label = {   5621, 19, 0 } }, /* air-traffic-control */
    { .label = {  79872,  9, 0 } }, /* ambulance */
    { .label = {  79912,  9, 0 } }, /* amusement */
    { .label = {   2766, 11, 0 } }, /* association */
    { .label = { 138780,  6, 0 } }, /* author */
    { .label = {  65634, 10, 0 } }, /* ballooning */
    { .label = { 138805,  6, 0 } }, /* broker */
    { .label = {    526,  3, 0 } }, /* caa */
    { .label = { 155373,  5, 0 } }, /* cargo */
    { .label = {  96659,  8, 0 } }, /* catering */
    { .label = {  31934, 13, 0 } }, /* certification */
    { .label = {  40286, 12, 0 } }, /* championship */
    { .label = { 118107,  7, 0 } }, /* charter */
    { .label = {  31989, 13, 0 } }, /* civilaviation */
    { .label = {  96605,  4, 0 } }, /* club */
    { .label = {  65678, 10, 0 } }, /* conference */
    { .label = {  65722, 10, 0 } }, /* consultant */
    { .label = {  65764, 10, 0 } }, /* consulting */
    { .label = {   5674,  7, 0 } }, /* control */
    { .label = { 118136,  7, 0 } }, /* council */
    { .label = { 165455,  4, 0 } }, /* crew */
    { .label = {  26610,  6, 0 } }, /* design */
    { .label = { 165474,  4, 0 } }, /* dgca */
    { .label = {  96692,  8, 0 } }, /* educator */
    { .label = {  79950,  9, 0 } }, /* emergency */
    { .label = {  31214,  6, 0 } }, /* engine */
    { .label = {  31214,  8, 0 } }, /* engineer */
    { .label = {  32045, 13, 0 } }, /* entertainment */
    { .label = {  34406,  9, 0 } }, /* equipment */
    { .label = {  40010,  8, 0 } }, /* exchange */
    { .label = {  22780,  7, 0 } }, /* express */
    { .label = {  65808, 10, 0 } }, /* federation */
    { .label = { 132421,  6, 0 } }, /* flight */
    { .label = { 118168,  7, 0 } }, /* freight */
    { .label = { 165492,  4, 0 } }, /* fuel */
    { .label = {  51357,  7, 0 } }, /* gliding */
    { .label = {  65850, 10, 0 } }, /* government */
    { .label = {  24686, 14, 0 } }, /* groundhandling */
    { .label = {  40373,  5, 0 } }, /* group */
    { .label = {  51340, 11, 0 } }, /* hanggliding */
    { .label = {  79991,  9, 0 } }, /* homebuilt */
    { .label = {   1529,  9, 0 } }, /* insurance */
    { .label = {  65894,  7, 0 } }, /* journal */
    { .label = {  65894, 10, 0 } }, /* journalist */
    { .label = { 118200,  7, 0 } }, /* leasing */
    { .label = {  29683,  9, 0 } }, /* logistics */
    { .label = {  96726,  8, 0 } }, /* magazine */
    { .label = {  51389, 11, 0 } }, /* maintenance */
    { .label = {  96066,  5, 0 } }, /* media */
    { .label = {  65938, 10, 0 } }, /* microlight */
    { .label = {  80033,  9, 0 } }, /* modelling */
    { .label = {  65983, 10, 0 } }, /* navigation */
    { .label = {  51433, 11, 0 } }, /* parachuting */
    { .label = {  51481, 11, 0 } }, /* paragliding */
    { .label = {   2723, 21, 0 } }, /* passenger-association */
    { .label = { 147235,  5, 0 } }, /* pilot */
    { .label = {  22790,  5, 0 } }, /* press */
    { .label = {  60289, 10, 0 } }, /* production */
    { .label = {  66024, 10, 0 } }, /* recreation */
    { .label = { 118229,  7, 0 } }, /* repbody */
    { .label = {  22470,  3, 0 } }, /* res */
    { .label = {  29566,  8, 0 } }, /* research */
    { .label = {  66064, 10, 0 } }, /* rotorcraft */
    { .label = {  12948,  6, 0 } }, /* safety */
    { .label = {  80074,  9, 0 } }, /* scientist */
    { .label = {  96761,  8, 0 } }, /* services */
    { .label = {    253,  4, 0 } }, /* show */
    { .label = {  80111,  9, 0 } }, /* skydiving */
    { .label = {  96796,  8, 0 } }, /* software */
    { .label = {  50012,  7, 0 } }, /* student */
    { .label = { 138832,  6, 0 } }, /* trader */
    { .label = { 118264,  7, 0 } }, /* trading */
    { .label = {   5423,  7, 0 } }, /* trainer */
    { .label = {  59835,  5, 0 } }, /* union */
    { .label = {  40341, 12, 0 } }, /* workinggroup */
    { .label = { 108364,  5, 0 } }, /* works */

    /* entries 1932 to 1937 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entries 1938 to 1942 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entries 1943 to 1947 */
    { .label = {  38537,  3, 0 } }, /* off */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entries 1948 to 1955 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entry 1956 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 1957 to 1962 */
    { .label = {   3988,  2, 0 } }, /* ed */
    { .label = {  11941,  2, 0 } }, /* gv */
    { .label = {   1288,  2, 0 } }, /* og */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   3592,  2, 0 } }, /* pb */
    { .label = {    151,  2, 0 } }, /* it */

    /* entries 1963 to 1973 */
    { .label = {    106,  3, 1 } }, { .child = { 1974, 1 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = { 138856,  6, 0 } }, /* musica */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   4396,  3, 0 } }, /* tur */

    /* entry 1974 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 1975 to 1980 */
    { .label = { 165512,  4, 0 } }, /* e164 */
    { .label = { 118293,  7, 0 } }, /* in-addr */
    { .label = { 169050,  3, 0 } }, /* ip6 */
    { .label = {  62601,  4, 0 } }, /* iris */
    { .label = {   6654,  3, 0 } }, /* uri */
    { .label = {   1375,  3, 0 } }, /* urn */

    /* entry 1981 */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entry 1982 */
    { .label = { 134919,  7, 0 } }, /* cloudns */

    /* entries 1983 to 2000 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 1 } }, { .child = { 2001, 1 } }, /* co */
    { .label = {  11941,  2, 0 } }, /* gv */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {  95651,  9, 1 } }, { .child = { 2002, 3 } }, /* futurecms */
    { .label = {  39757, 13, 0 } }, /* futurehosting */
    { .label = {  39815, 13, 0 } }, /* futuremailing */
    { .label = { 116612,  8, 1 } }, { .child = { 2009, 2 } }, /* ortsinfo */
    { .label = {  54555,  3, 0 } }, /* biz */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {   1461,  4, 0 } }, /* priv */
    { .label = { 168940,  4, 0 } }, /* 12hp */
    { .label = { 169593,  3, 0 } }, /* 2ix */
    { .label = { 165357,  5, 0 } }, /* 4lima */
    { .label = {  96464,  9, 0 } }, /* lima-city */

    /* entry 2001 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 2002 to 2006 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {    618,  2, 1 } }, { .child = { 2007, 1 } }, /* ex */
    { .label = {    100,  2, 1 } }, { .child = { 2008, 1 } }, /* in */

    /* entry 2007 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 2008 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2009 to 2012 */
    { .label = {    618,  2, 1 } }, { .child = { 2013, 1 } }, /* ex */
    { .label = { 154465,  6, 1 } }, { .child = { 2014, 1 } }, /* kunden */

    /* entry 2013 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 2014 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2015 to 2035 */
    { .label = {    106,  3, 1 } }, { .child = { 2036, 1 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  42919,  3, 1 } }, { .child = { 2037, 8 } }, /* edu */
    { .label = {   3879,  3, 1 } }, { .child = { 2045, 5 } }, /* gov */
    { .label = {   6682,  3, 0 } }, /* asn */
    { .label = {     86,  2, 0 } }, /* id */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {  64159,  4, 0 } }, /* conf */
    { .label = {   3283,  2, 0 } }, /* oz */
    { .label = {  13368,  3, 0 } }, /* act */
    { .label = {   1869,  3, 0 } }, /* nsw */
    { .label = {    252,  2, 0 } }, /* nt */
    { .label = { 134511,  3, 0 } }, /* qld */
    { .label = {    355,  2, 0 } }, /* sa */
    { .label = {  11055,  3, 0 } }, /* tas */
    { .label = {  22824,  3, 0 } }, /* vic */
    { .label = {     18,  2, 0 } }, /* wa */

    /* entry 2036 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 2037 to 2044 */
    { .label = {  13368,  3, 0 } }, /* act */
    { .label = {   1869,  3, 0 } }, /* nsw */
    { .label = {    252,  2, 0 } }, /* nt */
    { .label = { 134511,  3, 0 } }, /* qld */
    { .label = {    355,  2, 0 } }, /* sa */
    { .label = {  11055,  3, 0 } }, /* tas */
    { .label = {  22824,  3, 0 } }, /* vic */
    { .label = {     18,  2, 0 } }, /* wa */

    /* entries 2045 to 2049 */
    { .label = { 134511,  3, 0 } }, /* qld */
    { .label = {    355,  2, 0 } }, /* sa */
    { .label = {  11055,  3, 0 } }, /* tas */
    { .label = {  22824,  3, 0 } }, /* vic */
    { .label = {     18,  2, 0 } }, /* wa */

    /* entry 2050 */
    { .label = {    106,  3, 0 } }, /* com */

    /* entries 2051 to 2062 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {   6753,  2, 0 } }, /* pp */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  29414,  4, 0 } }, /* name */
    { .label = {  22835,  3, 0 } }, /* pro */
    { .label = {  54555,  3, 0 } }, /* biz */

    /* entries 2063 to 2069 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 2070 to 2079 */
    { .label = {  54555,  3, 0 } }, /* biz */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 155394,  5, 0 } }, /* store */
    { .label = {   9431,  2, 0 } }, /* tv */

    /* entry 2080 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2081 to 2085 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  77014, 10, 0 } }, /* webhosting */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = { 117719,  8, 1 } }, { .child = { 2086, 1 } }, /* transurl */

    /* entry 2086 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 2087 */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entries 2088 to 2125 */
    { .label = {     24,  1, 0 } }, /* a */
    { .label = {     62,  1, 0 } }, /* b */
    { .label = {     21,  1, 0 } }, /* c */
    { .label = {     90,  1, 0 } }, /* d */
    { .label = {     23,  1, 0 } }, /* e */
    { .label = {     68,  1, 0 } }, /* f */
    { .label = {     19,  1, 0 } }, /* g */
    { .label = {     30,  1, 0 } }, /* h */
    { .label = {     39,  1, 0 } }, /* i */
    { .label = {     66,  1, 0 } }, /* j */
    { .label = {     10,  1, 0 } }, /* k */
    { .label = {     25,  1, 0 } }, /* l */
    { .label = {     29,  1, 0 } }, /* m */
    { .label = {     28,  1, 0 } }, /* n */
    { .label = {     47,  1, 0 } }, /* o */
    { .label = {     58,  1, 0 } }, /* p */
    { .label = {    215,  1, 0 } }, /* q */
    { .label = {      1,  1, 0 } }, /* r */
    { .label = {      2,  1, 0 } }, /* s */
    { .label = {      3,  1, 0 } }, /* t */
    { .label = {     46,  1, 0 } }, /* u */
    { .label = {      8,  1, 0 } }, /* v */
    { .label = {     18,  1, 0 } }, /* w */
    { .label = {     22,  1, 0 } }, /* x */
    { .label = {     38,  1, 0 } }, /* y */
    { .label = {    134,  1, 0 } }, /* z */
    { .label = {    667,  1, 0 } }, /* 0 */
    { .label = {    439,  1, 0 } }, /* 1 */
    { .label = {    169,  1, 0 } }, /* 2 */
    { .label = {    170,  1, 0 } }, /* 3 */
    { .label = {    232,  1, 0 } }, /* 4 */
    { .label = {   1535,  1, 0 } }, /* 5 */
    { .label = {    212,  1, 0 } }, /* 6 */
    { .label = {    627,  1, 0 } }, /* 7 */
    { .label = {     15,  1, 0 } }, /* 8 */
    { .label = {      4,  1, 0 } }, /* 9 */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  64744,  5, 0 } }, /* barsy */

    /* entries 2126 to 2130 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entries 2131 to 2135 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 2136 to 2147 */
    { .label = { 134919,  7, 0 } }, /* cloudns */
    { .label = {  30648,  6, 0 } }, /* dyndns */
    { .label = {  77375, 10, 0 } }, /* for-better */
    { .label = {  38816,  8, 0 } }, /* for-more */
    { .label = { 115212,  8, 0 } }, /* for-some */
    { .label = { 135333,  7, 0 } }, /* for-the */
    { .label = { 154041,  6, 0 } }, /* selfip */
    { .label = { 154070,  6, 0 } }, /* webhop */
    { .label = { 154816,  6, 0 } }, /* mmafan */
    { .label = { 165111,  5, 0 } }, /* myftp */
    { .label = { 165088,  5, 0 } }, /* no-ip */
    { .label = { 138395,  7, 0 } }, /* dscloud */

    /* entries 2148 to 2151 */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = { 118323,  7, 0 } }, /* barreau */
    { .label = { 165542,  4, 0 } }, /* gouv */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 2152 to 2156 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entry 2157 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2158 to 2198 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {   9431,  2, 0 } }, /* tv */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = {  96831,  8, 0 } }, /* academia */
    { .label = {  90892,  4, 0 } }, /* agro */
    { .label = {  17211,  4, 0 } }, /* arte */
    { .label = {  16818,  4, 0 } }, /* blog */
    { .label = { 118352,  7, 0 } }, /* bolivia */
    { .label = { 118384,  7, 0 } }, /* ciencia */
    { .label = {  51529, 11, 0 } }, /* cooperativa */
    { .label = {  66106, 10, 0 } }, /* democracia */
    { .label = { 118413,  7, 0 } }, /* deporte */
    { .label = {  96863,  8, 0 } }, /* ecologia */
    { .label = {  96897,  8, 0 } }, /* economia */
    { .label = { 118444,  7, 0 } }, /* empresa */
    { .label = {  96930,  8, 0 } }, /* indigena */
    { .label = {  80154,  9, 0 } }, /* industria */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {  96963,  8, 0 } }, /* medicina */
    { .label = {  66148, 10, 0 } }, /* movimiento */
    { .label = { 138856,  6, 0 } }, /* musica */
    { .label = {   4389,  7, 0 } }, /* natural */
    { .label = { 138882,  6, 0 } }, /* nombre */
    { .label = {  96997,  8, 0 } }, /* noticias */
    { .label = { 138909,  6, 0 } }, /* patria */
    { .label = {  97029,  8, 0 } }, /* politica */
    { .label = {  51576, 11, 0 } }, /* profesional */
    { .label = {  32097, 13, 0 } }, /* plurinacional */
    { .label = { 138933,  6, 0 } }, /* pueblo */
    { .label = { 118474,  7, 0 } }, /* revista */
    { .label = { 155414,  5, 0 } }, /* salud */
    { .label = {  66192, 10, 0 } }, /* tecnologia */
    { .label = { 155436,  5, 0 } }, /* tksat */
    { .label = {  66234, 10, 0 } }, /* transporte */
    { .label = {  63351,  4, 0 } }, /* wiki */

    /* entries 2199 to 2329 */
    { .label = { 138963,  6, 0 } }, /* 9guacu */
    { .label = {   2536,  3, 0 } }, /* abc */
    { .label = {  10199,  3, 0 } }, /* adm */
    { .label = {   3989,  3, 0 } }, /* adv */
    { .label = {  15507,  3, 0 } }, /* agr */
    { .label = {  56304,  3, 0 } }, /* aju */
    { .label = {    396,  2, 0 } }, /* am */
    { .label = {  41887,  5, 0 } }, /* anani */
    { .label = {  80191,  9, 0 } }, /* aparecida */
    { .label = { 111458,  3, 0 } }, /* arq */
    { .label = {   7867,  3, 0 } }, /* art */
    { .label = {   5832,  3, 0 } }, /* ato */
    { .label = {     62,  1, 0 } }, /* b */
    { .label = { 118503,  7, 0 } }, /* barueri */
    { .label = { 155456,  5, 0 } }, /* belem */
    { .label = { 169069,  3, 0 } }, /* bhz */
    { .label = {  43283,  3, 0 } }, /* bio */
    { .label = {  16818,  4, 0 } }, /* blog */
    { .label = {  57783,  3, 0 } }, /* bmd */
    { .label = {  97064,  8, 0 } }, /* boavista */
    { .label = {  86645,  3, 0 } }, /* bsb */
    { .label = {  32153, 13, 0 } }, /* campinagrande */
    { .label = {  97098,  8, 0 } }, /* campinas */
    { .label = { 138996,  6, 0 } }, /* caxias */
    { .label = { 169087,  3, 0 } }, /* cim */
    { .label = {  20252,  3, 0 } }, /* cng */
    { .label = {  11056,  3, 0 } }, /* cnt */
    { .label = {    106,  3, 1 } }, { .child = { 2330, 1 } }, /* com */
    { .label = {  97132,  8, 0 } }, /* contagem */
    { .label = {  51529,  4, 0 } }, /* coop */
    { .label = {   2545,  3, 0 } }, /* cri */
    { .label = { 139021,  6, 0 } }, /* cuiaba */
    { .label = {  97166,  8, 0 } }, /* curitiba */
    { .label = {  26360,  3, 0 } }, /* def */
    { .label = {   6807,  3, 0 } }, /* ecn */
    { .label = {    102,  3, 0 } }, /* eco */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  18700,  3, 0 } }, /* emp */
    { .label = {   2740,  3, 0 } }, /* eng */
    { .label = {  10180,  3, 0 } }, /* esp */
    { .label = {  20350,  3, 0 } }, /* etc */
    { .label = {    421,  3, 0 } }, /* eti */
    { .label = {  10642,  3, 0 } }, /* far */
    { .label = { 155480,  5, 0 } }, /* feira */
    { .label = { 165562,  4, 0 } }, /* flog */
    { .label = { 118533,  7, 0 } }, /* floripa */
    { .label = {   1659,  2, 0 } }, /* fm */
    { .label = { 169101,  3, 0 } }, /* fnd */
    { .label = { 139047,  6, 0 } }, /* fortal */
    { .label = { 119218,  3, 0 } }, /* fot */
    { .label = {  23920,  3, 0 } }, /* foz */
    { .label = {   9536,  3, 0 } }, /* fst */
    { .label = { 169116,  3, 0 } }, /* g12 */
    { .label = { 169137,  3, 0 } }, /* ggf */
    { .label = { 118565,  7, 0 } }, /* goiania */
    { .label = {   3879,  3, 1 } }, { .child = { 2331, 27 } }, /* gov */
    { .label = {  48068,  3, 0 } }, /* gru */
    { .label = {  35805,  3, 0 } }, /* imb */
    { .label = {   8838,  3, 0 } }, /* ind */
    { .label = {   5417,  3, 0 } }, /* inf */
    { .label = {  92683,  3, 0 } }, /* jab */
    { .label = { 155501,  5, 0 } }, /* jampa */
    { .label = {  91516,  3, 0 } }, /* jdf */
    { .label = {  80228,  9, 0 } }, /* joinville */
    { .label = {  15519,  3, 0 } }, /* jor */
    { .label = {  13625,  3, 0 } }, /* jus */
    { .label = {   8835,  3, 1 } }, { .child = { 2358, 27 } }, /* leg */
    { .label = {  34220,  3, 0 } }, /* lel */
    { .label = {  97201,  8, 0 } }, /* londrina */
    { .label = { 139073,  6, 0 } }, /* macapa */
    { .label = { 139098,  6, 0 } }, /* maceio */
    { .label = { 139123,  6, 0 } }, /* manaus */
    { .label = { 118592,  7, 0 } }, /* maringa */
    { .label = {  11075,  3, 0 } }, /* mat */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = { 139147,  6, 0 } }, /* morena */
    { .label = {    242,  2, 0 } }, /* mp */
    { .label = {   4448,  3, 0 } }, /* mus */
    { .label = { 155525,  5, 0 } }, /* natal */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = { 118620,  7, 0 } }, /* niteroi */
    { .label = {  25342,  3, 1 } }, { .child = { 2385, 1 } }, /* nom */
    { .label = {  17137,  3, 0 } }, /* not */
    { .label = {   5683,  3, 0 } }, /* ntr */
    { .label = {   5640,  3, 0 } }, /* odo */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 139171,  6, 0 } }, /* osasco */
    { .label = { 139195,  6, 0 } }, /* palmas */
    { .label = {  34776,  3, 0 } }, /* poa */
    { .label = { 169153,  3, 0 } }, /* ppg */
    { .label = {  22835,  3, 0 } }, /* pro */
    { .label = { 114915,  3, 0 } }, /* psc */
    { .label = {  14661,  3, 0 } }, /* psi */
    { .label = { 166791,  3, 0 } }, /* pvh */
    { .label = { 169170,  3, 0 } }, /* qsl */
    { .label = {  49700,  5, 0 } }, /* radio */
    { .label = {    182,  3, 0 } }, /* rec */
    { .label = { 139221,  6, 0 } }, /* recife */
    { .label = {  97234,  8, 0 } }, /* ribeirao */
    { .label = {   3773,  3, 0 } }, /* rio */
    { .label = {  80271,  9, 0 } }, /* riobranco */
    { .label = {  97267,  8, 0 } }, /* riopreto */
    { .label = {  43739,  8, 0 } }, /* salvador */
    { .label = { 155544,  5, 0 } }, /* sampa */
    { .label = {  66275, 10, 0 } }, /* santamaria */
    { .label = {  66312, 10, 0 } }, /* santoandre */
    { .label = {  51624, 11, 0 } }, /* saobernardo */
    { .label = {  97301,  8, 0 } }, /* saogonca */
    { .label = {  59083,  3, 0 } }, /* sjc */
    { .label = { 169187,  3, 0 } }, /* slg */
    { .label = { 169201,  3, 0 } }, /* slz */
    { .label = {  97333,  8, 0 } }, /* sorocaba */
    { .label = {  17955,  3, 0 } }, /* srv */
    { .label = {  19683,  4, 0 } }, /* taxi */
    { .label = {  17827,  3, 0 } }, /* teo */
    { .label = {    746,  3, 0 } }, /* the */
    { .label = {  26224,  3, 0 } }, /* tmp */
    { .label = {  21457,  3, 0 } }, /* trd */
    { .label = {   4396,  3, 0 } }, /* tur */
    { .label = {   9431,  2, 0 } }, /* tv */
    { .label = {  87430,  3, 0 } }, /* udi */
    { .label = {  51669,  3, 0 } }, /* vet */
    { .label = {  43257,  3, 0 } }, /* vix */
    { .label = { 165582,  4, 0 } }, /* vlog */
    { .label = {  63351,  4, 0 } }, /* wiki */
    { .label = {  19514,  3, 0 } }, /* zlg */

    /* entry 2330 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 2331 to 2357 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     94,  2, 0 } }, /* al */
    { .label = {    396,  2, 0 } }, /* am */
    { .label = {    244,  2, 0 } }, /* ap */
    { .label = {    118,  2, 0 } }, /* ba */
    { .label = {     21,  2, 0 } }, /* ce */
    { .label = {   5537,  2, 0 } }, /* df */
    { .label = {    141,  2, 0 } }, /* es */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {   1369,  2, 0 } }, /* ma */
    { .label = {   1381,  2, 0 } }, /* mg */
    { .label = {    126,  2, 0 } }, /* ms */
    { .label = {   2788,  2, 0 } }, /* mt */
    { .label = {    136,  2, 0 } }, /* pa */
    { .label = {   3592,  2, 0 } }, /* pb */
    { .label = {    552,  2, 0 } }, /* pe */
    { .label = {    494,  2, 0 } }, /* pi */
    { .label = {   1461,  2, 0 } }, /* pr */
    { .label = {   4619,  2, 0 } }, /* rj */
    { .label = {   1380,  2, 0 } }, /* rn */
    { .label = {    524,  2, 0 } }, /* ro */
    { .label = {      1,  2, 0 } }, /* rr */
    { .label = {      9,  2, 0 } }, /* rs */
    { .label = {     17,  2, 0 } }, /* sc */
    { .label = {    629,  2, 0 } }, /* se */
    { .label = {   3969,  2, 0 } }, /* sp */
    { .label = {   1538,  2, 0 } }, /* to */

    /* entries 2358 to 2384 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     94,  2, 0 } }, /* al */
    { .label = {    396,  2, 0 } }, /* am */
    { .label = {    244,  2, 0 } }, /* ap */
    { .label = {    118,  2, 0 } }, /* ba */
    { .label = {     21,  2, 0 } }, /* ce */
    { .label = {   5537,  2, 0 } }, /* df */
    { .label = {    141,  2, 0 } }, /* es */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {   1369,  2, 0 } }, /* ma */
    { .label = {   1381,  2, 0 } }, /* mg */
    { .label = {    126,  2, 0 } }, /* ms */
    { .label = {   2788,  2, 0 } }, /* mt */
    { .label = {    136,  2, 0 } }, /* pa */
    { .label = {   3592,  2, 0 } }, /* pb */
    { .label = {    552,  2, 0 } }, /* pe */
    { .label = {    494,  2, 0 } }, /* pi */
    { .label = {   1461,  2, 0 } }, /* pr */
    { .label = {   4619,  2, 0 } }, /* rj */
    { .label = {   1380,  2, 0 } }, /* rn */
    { .label = {    524,  2, 0 } }, /* ro */
    { .label = {      1,  2, 0 } }, /* rr */
    { .label = {      9,  2, 0 } }, /* rs */
    { .label = {     17,  2, 0 } }, /* sc */
    { .label = {    629,  2, 0 } }, /* se */
    { .label = {   3969,  2, 0 } }, /* sp */
    { .label = {   1538,  2, 0 } }, /* to */

    /* entry 2385 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2386 to 2391 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    266,  2, 0 } }, /* we */

    /* entries 2392 to 2396 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 2397 to 2398 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 2399 to 2404 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {    106,  3, 1 } }, { .child = { 2405, 1 } }, /* com */
    { .label = {   5311,  2, 0 } }, /* of */
    { .label = {  43390,  3, 0 } }, /* nym */

    /* entry 2405 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 2406 to 2412 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    527,  2, 0 } }, /* za */
    { .label = {  43390,  3, 0 } }, /* nym */

    /* entries 2413 to 2432 */
    { .label = {     74,  2, 0 } }, /* ab */
    { .label = {   2539,  2, 0 } }, /* bc */
    { .label = {   1523,  2, 0 } }, /* mb */
    { .label = {    398,  2, 0 } }, /* nb */
    { .label = {    463,  2, 0 } }, /* nf */
    { .label = {   2951,  2, 0 } }, /* nl */
    { .label = {    230,  2, 0 } }, /* ns */
    { .label = {    252,  2, 0 } }, /* nt */
    { .label = {    241,  2, 0 } }, /* nu */
    { .label = {    121,  2, 0 } }, /* on */
    { .label = {    552,  2, 0 } }, /* pe */
    { .label = {  48881,  2, 0 } }, /* qc */
    { .label = {      6,  2, 0 } }, /* sk */
    { .label = {    519,  2, 0 } }, /* yk */
    { .label = {    639,  2, 0 } }, /* gc */
    { .label = { 164486,  5, 1 } }, { .child = { 2433, 1 } }, /* awdev */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = { 165088,  5, 0 } }, /* no-ip */

    /* entry 2433 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2434 to 2440 */
    { .label = { 134919,  7, 0 } }, /* cloudns */
    { .label = {  94829,  9, 0 } }, /* ftpaccess */
    { .label = {  63516, 11, 0 } }, /* game-server */
    { .label = { 115495,  8, 0 } }, /* myphotos */
    { .label = {  95227,  9, 0 } }, /* scrapping */
    { .label = { 154241,  6, 0 } }, /* twmail */
    { .label = {  39932, 13, 0 } }, /* fantasyleague */

    /* entry 2441 */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entry 2442 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 2443 to 2451 */
    { .label = { 134775,  7, 0 } }, /* square7 */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  31566, 14, 0 } }, /* linkyard-cloud */
    { .label = { 117247,  7, 0 } }, /* dnsking */
    { .label = { 153958,  6, 0 } }, /* gotdns */
    { .label = { 168940,  4, 0 } }, /* 12hp */
    { .label = { 169593,  3, 0 } }, /* 2ix */
    { .label = { 165357,  5, 0 } }, /* 4lima */
    { .label = {  96464,  9, 0 } }, /* lima-city */

    /* entries 2452 to 2466 */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3988,  2, 0 } }, /* ed */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = {  17757, 15, 0 } }, /* xn--aroport-bya */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = { 139248,  6, 0 } }, /* presse */
    { .label = {   8061,  2, 0 } }, /* md */
    { .label = { 165542,  4, 0 } }, /* gouv */

    /* entries 2467 to 2469 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = { 154681,  3, 1 } }, { .child = { 2470, 1 } }, /* www */

    /* entry 2470 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 2471 to 2476 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entries 2477 to 2480 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  16771,  3, 0 } }, /* net */

    /* entries 2481 to 2525 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {    106,  3, 1 } }, { .child = { 2526, 1 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  66351, 10, 0 } }, /* xn--55qx5d */
    { .label = {  66417, 10, 0 } }, /* xn--io0a7i */
    { .label = {  66469, 10, 0 } }, /* xn--od0alg */
    { .label = {     27,  2, 0 } }, /* ah */
    { .label = {   7174,  2, 0 } }, /* bj */
    { .label = {   5333,  2, 0 } }, /* cq */
    { .label = {   4617,  2, 0 } }, /* fj */
    { .label = {   2042,  2, 0 } }, /* gd */
    { .label = {    337,  2, 0 } }, /* gs */
    { .label = {  40262,  2, 0 } }, /* gz */
    { .label = {   1014,  2, 0 } }, /* gx */
    { .label = {    592,  2, 0 } }, /* ha */
    { .label = {   2991,  2, 0 } }, /* hb */
    { .label = {    482,  2, 0 } }, /* he */
    { .label = {     73,  2, 0 } }, /* hi */
    { .label = {    344,  2, 0 } }, /* hl */
    { .label = {    147,  2, 0 } }, /* hn */
    { .label = {   7138,  2, 0 } }, /* jl */
    { .label = {   7274,  2, 0 } }, /* js */
    { .label = {   7340,  2, 0 } }, /* jx */
    { .label = {    284,  2, 0 } }, /* ln */
    { .label = {    201,  2, 0 } }, /* nm */
    { .label = {   2086,  2, 0 } }, /* nx */
    { .label = {  51169,  2, 0 } }, /* qh */
    { .label = {     17,  2, 0 } }, /* sc */
    { .label = {    502,  2, 0 } }, /* sd */
    { .label = {    253,  2, 0 } }, /* sh */
    { .label = {   1414,  2, 0 } }, /* sn */
    { .label = {    312,  2, 0 } }, /* sx */
    { .label = {   2411,  2, 0 } }, /* tj */
    { .label = {   9029,  2, 0 } }, /* xj */
    { .label = {  32480,  2, 0 } }, /* xz */
    { .label = {   2785,  2, 0 } }, /* yn */
    { .label = {  30277,  2, 0 } }, /* zj */
    { .label = {    517,  2, 0 } }, /* hk */
    { .label = {   3360,  2, 0 } }, /* mo */
    { .label = {     14,  2, 0 } }, /* tw */

    /* entries 2526 to 2527 */
    { .label = {  94325,  9, 1 } }, { .child = { 2528, 4 } }, /* amazonaws */

    /* entries 2528 to 2535 */
    { .label = {  19748,  7, 1 } }, { .child = { 2536, 1 } }, /* compute */
    { .label = {    689,  2, 1 } }, { .child = { 2537, 1 } }, /* eb */
    { .label = {  40235,  3, 1 } }, { .child = { 2538, 1 } }, /* elb */
    { .label = {  76779, 10, 1 } }, { .child = { 2539, 1 } }, /* cn-north-1 */

    /* entry 2536 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 2537 */
    { .label = {  76779, 10, 0 } }, /* cn-north-1 */

    /* entry 2538 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 2539 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 2540 to 2558 */
    { .label = {   7867,  4, 0 } }, /* arts */
    { .label = {    106,  3, 1 } }, { .child = { 2559, 1 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = { 113331,  4, 0 } }, /* firm */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {  25342,  3, 0 } }, /* nom */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    182,  3, 0 } }, /* rec */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = { 168382,  4, 1 } }, { .child = { 2560, 1 } }, /* otap */
    { .label = { 168710,  4, 0 } }, /* mypi */
    { .label = { 169538,  3, 0 } }, /* n4t */
    { .label = { 165184,  5, 0 } }, /* nodum */

    /* entry 2559 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entry 2560 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2561 to 2875 */
    { .label = {  94325,  9, 1 } }, { .child = { 2876, 42 } }, /* amazonaws */
    { .label = {  16566, 16, 1 } }, { .child = { 2990, 17 } }, /* elasticbeanstalk */
    { .label = {  76827, 10, 0 } }, /* on-aptible */
    { .label = {  94449,  9, 0 } }, /* myasustor */
    { .label = {  76872, 10, 0 } }, /* betainabox */
    { .label = { 134812,  7, 0 } }, /* bplaced */
    { .label = {     45,  2, 0 } }, /* ar */
    { .label = {    294,  2, 0 } }, /* br */
    { .label = {   6811,  2, 0 } }, /* cn */
    { .label = {    243,  2, 0 } }, /* de */
    { .label = {    325,  2, 0 } }, /* eu */
    { .label = {   1450,  2, 0 } }, /* gb */
    { .label = {    291,  2, 0 } }, /* hu */
    { .label = { 169482,  3, 0 } }, /* jpn */
    { .label = {   3651,  2, 0 } }, /* kr */
    { .label = {   2816,  3, 0 } }, /* mex */
    { .label = {    162,  2, 0 } }, /* no */
    { .label = {  48881,  2, 0 } }, /* qc */
    { .label = {    204,  2, 0 } }, /* ru */
    { .label = {    355,  2, 0 } }, /* sa */
    { .label = {   6323,  2, 0 } }, /* uk */
    { .label = {    296,  2, 0 } }, /* us */
    { .label = {    223,  2, 0 } }, /* uy */
    { .label = {    527,  2, 0 } }, /* za */
    { .label = {  70768,  6, 0 } }, /* africa */
    { .label = {   4505,  2, 0 } }, /* gr */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  38390, 13, 0 } }, /* xenapponazure */
    { .label = {  94488,  9, 0 } }, /* jdevcloud */
    { .label = {  76963, 10, 0 } }, /* wpdevcloud */
    { .label = {  23428, 15, 0 } }, /* cloudcontrolled */
    { .label = {  23496, 15, 0 } }, /* cloudcontrolapp */
    { .label = {  77150, 10, 0 } }, /* dattolocal */
    { .label = {  77192, 10, 0 } }, /* dattorelay */
    { .label = { 115002,  8, 0 } }, /* dattoweb */
    { .label = { 135014,  7, 0 } }, /* mydatto */
    { .label = { 115038,  8, 0 } }, /* drayddns */
    { .label = {  49578, 12, 0 } }, /* dreamhosters */
    { .label = { 135076,  7, 0 } }, /* mydrobo */
    { .label = {  30648, 14, 0 } }, /* dyndns-at-home */
    { .label = {  30711, 14, 0 } }, /* dyndns-at-work */
    { .label = {  63061, 11, 0 } }, /* dyndns-blog */
    { .label = {  63114, 11, 0 } }, /* dyndns-free */
    { .label = {  63165, 11, 0 } }, /* dyndns-home */
    { .label = {  94707,  9, 0 } }, /* dyndns-ip */
    { .label = {  63216, 11, 0 } }, /* dyndns-mail */
    { .label = {  38504, 13, 0 } }, /* dyndns-office */
    { .label = {  63266, 11, 0 } }, /* dyndns-pics */
    { .label = {  38566, 13, 0 } }, /* dyndns-remote */
    { .label = {  38624, 13, 0 } }, /* dyndns-server */
    { .label = {  77234, 10, 0 } }, /* dyndns-web */
    { .label = {  63318, 11, 0 } }, /* dyndns-wiki */
    { .label = {  63370, 11, 0 } }, /* dyndns-work */
    { .label = { 135143,  7, 0 } }, /* blogdns */
    { .label = { 135176,  7, 0 } }, /* cechire */
    { .label = { 115146,  8, 0 } }, /* dnsalias */
    { .label = { 135207,  7, 0 } }, /* dnsdojo */
    { .label = {  63469, 11, 0 } }, /* doesntexist */
    { .label = {  94750,  9, 0 } }, /* dontexist */
    { .label = { 135270,  7, 0 } }, /* doomdns */
    { .label = {  77330, 10, 0 } }, /* dyn-o-saur */
    { .label = { 115178,  8, 0 } }, /* dynalias */
    { .label = {  23698, 15, 0 } }, /* est-a-la-maison */
    { .label = {  23760, 15, 0 } }, /* est-a-la-masion */
    { .label = {  38738, 13, 0 } }, /* est-le-patron */
    { .label = {  16783, 16, 0 } }, /* est-mon-blogueur */
    { .label = { 135365,  7, 0 } }, /* from-ak */
    { .label = { 135397,  7, 0 } }, /* from-al */
    { .label = { 135429,  7, 0 } }, /* from-ar */
    { .label = { 135494,  7, 0 } }, /* from-ca */
    { .label = { 135559,  7, 0 } }, /* from-ct */
    { .label = { 135592,  7, 0 } }, /* from-dc */
    { .label = { 135626,  7, 0 } }, /* from-de */
    { .label = { 135659,  7, 0 } }, /* from-fl */
    { .label = { 135694,  7, 0 } }, /* from-ga */
    { .label = { 135726,  7, 0 } }, /* from-hi */
    { .label = { 135759,  7, 0 } }, /* from-ia */
    { .label = { 135790,  7, 0 } }, /* from-id */
    { .label = { 135823,  7, 0 } }, /* from-il */
    { .label = { 135856,  7, 0 } }, /* from-in */
    { .label = { 135888,  7, 0 } }, /* from-ks */
    { .label = { 135921,  7, 0 } }, /* from-ky */
    { .label = { 135988,  7, 0 } }, /* from-ma */
    { .label = { 136020,  7, 0 } }, /* from-md */
    { .label = { 136087,  7, 0 } }, /* from-mi */
    { .label = { 136120,  7, 0 } }, /* from-mn */
    { .label = { 136153,  7, 0 } }, /* from-mo */
    { .label = { 136186,  7, 0 } }, /* from-ms */
    { .label = { 136219,  7, 0 } }, /* from-mt */
    { .label = { 136252,  7, 0 } }, /* from-nc */
    { .label = { 136285,  7, 0 } }, /* from-nd */
    { .label = { 136318,  7, 0 } }, /* from-ne */
    { .label = { 136350,  7, 0 } }, /* from-nh */
    { .label = { 136383,  7, 0 } }, /* from-nj */
    { .label = { 136418,  7, 0 } }, /* from-nm */
    { .label = { 136451,  7, 0 } }, /* from-nv */
    { .label = { 136519,  7, 0 } }, /* from-oh */
    { .label = { 136552,  7, 0 } }, /* from-ok */
    { .label = { 136585,  7, 0 } }, /* from-or */
    { .label = { 136617,  7, 0 } }, /* from-pa */
    { .label = { 136650,  7, 0 } }, /* from-pr */
    { .label = { 136684,  7, 0 } }, /* from-ri */
    { .label = { 136716,  7, 0 } }, /* from-sc */
    { .label = { 136749,  7, 0 } }, /* from-sd */
    { .label = { 136782,  7, 0 } }, /* from-tn */
    { .label = { 136814,  7, 0 } }, /* from-tx */
    { .label = { 136848,  7, 0 } }, /* from-ut */
    { .label = { 136881,  7, 0 } }, /* from-va */
    { .label = { 136914,  7, 0 } }, /* from-vt */
    { .label = { 136948,  7, 0 } }, /* from-wa */
    { .label = { 136981,  7, 0 } }, /* from-wi */
    { .label = { 137015,  7, 0 } }, /* from-wv */
    { .label = { 137051,  7, 0 } }, /* from-wy */
    { .label = { 137087,  7, 0 } }, /* getmyip */
    { .label = { 153958,  6, 0 } }, /* gotdns */
    { .label = {  77464, 10, 0 } }, /* hobby-site */
    { .label = {  94949,  9, 0 } }, /* homelinux */
    { .label = { 115248,  8, 0 } }, /* homeunix */
    { .label = {  94991,  9, 0 } }, /* iamallama */
    { .label = {  30775, 14, 0 } }, /* is-a-anarchist */
    { .label = {  49735, 12, 0 } }, /* is-a-blogger */
    { .label = {  23888, 15, 0 } }, /* is-a-bookkeeper */
    { .label = {  30893, 14, 0 } }, /* is-a-bulls-fan */
    { .label = {  49789, 12, 0 } }, /* is-a-caterer */
    { .label = {  95027,  9, 0 } }, /* is-a-chef */
    { .label = {  12992, 17, 0 } }, /* is-a-conservative */
    { .label = { 115285,  8, 0 } }, /* is-a-cpa */
    { .label = {  10084, 18, 0 } }, /* is-a-cubicle-slave */
    { .label = {  38852, 13, 0 } }, /* is-a-democrat */
    { .label = {  38907, 13, 0 } }, /* is-a-designer */
    { .label = {  63613, 11, 0 } }, /* is-a-doctor */
    { .label = {   3930, 21, 0 } }, /* is-a-financialadvisor */
    { .label = {  95068,  9, 0 } }, /* is-a-geek */
    { .label = {  77512, 10, 0 } }, /* is-a-green */
    { .label = {  95107,  9, 0 } }, /* is-a-guru */
    { .label = {  16856, 16, 0 } }, /* is-a-hard-worker */
    { .label = {  63660, 11, 0 } }, /* is-a-hunter */
    { .label = {  24020, 15, 0 } }, /* is-a-landscaper */
    { .label = {  63755, 11, 0 } }, /* is-a-lawyer */
    { .label = {  49838, 12, 0 } }, /* is-a-liberal */
    { .label = {  16926, 16, 0 } }, /* is-a-libertarian */
    { .label = {  77554, 10, 0 } }, /* is-a-llama */
    { .label = {  38962, 13, 0 } }, /* is-a-musician */
    { .label = {  31015, 14, 0 } }, /* is-a-nascarfan */
    { .label = {  77596, 10, 0 } }, /* is-a-nurse */
    { .label = {  49890, 12, 0 } }, /* is-a-painter */
    { .label = {   5368, 20, 0 } }, /* is-a-personaltrainer */
    { .label = {  13065, 17, 0 } }, /* is-a-photographer */
    { .label = {  63804, 11, 0 } }, /* is-a-player */
    { .label = {  24151, 15, 0 } }, /* is-a-republican */
    { .label = {  39017, 13, 0 } }, /* is-a-rockstar */
    { .label = {  31072, 14, 0 } }, /* is-a-socialist */
    { .label = {  49991, 12, 0 } }, /* is-a-student */
    { .label = {  50042, 12, 0 } }, /* is-a-teacher */
    { .label = {  63901, 11, 0 } }, /* is-a-techie */
    { .label = {  31130, 14, 0 } }, /* is-a-therapist */
    { .label = {  16992, 16, 0 } }, /* is-an-accountant */
    { .label = {  63948, 11, 0 } }, /* is-an-actor */
    { .label = {  39071, 13, 0 } }, /* is-an-actress */
    { .label = {  24218, 15, 0 } }, /* is-an-anarchist */
    { .label = {  50092, 12, 0 } }, /* is-an-artist */
    { .label = {  31189, 14, 0 } }, /* is-an-engineer */
    { .label = {  13140, 17, 0 } }, /* is-an-entertainer */
    { .label = {  50140, 12, 0 } }, /* is-certified */
    { .label = { 137182,  7, 0 } }, /* is-gone */
    { .label = {  39124, 13, 0 } }, /* is-into-anime */
    { .label = {  50193, 12, 0 } }, /* is-into-cars */
    { .label = {  17058, 16, 0 } }, /* is-into-cartoons */
    { .label = {  39178, 13, 0 } }, /* is-into-games */
    { .label = { 137212,  7, 0 } }, /* is-leet */
    { .label = {  17124, 16, 0 } }, /* is-not-certified */
    { .label = { 115392,  8, 0 } }, /* is-slick */
    { .label = {  63993, 11, 0 } }, /* is-uberleet */
    { .label = {  24279, 15, 0 } }, /* is-with-theband */
    { .label = { 115428,  8, 0 } }, /* isa-geek */
    { .label = {  39293, 13, 0 } }, /* isa-hockeynut */
    { .label = {  17194, 16, 0 } }, /* issmarterthanyou */
    { .label = {  95186,  9, 0 } }, /* likes-pie */
    { .label = {  77814, 10, 0 } }, /* likescandy */
    { .label = { 115533,  8, 0 } }, /* neat-url */
    { .label = {  17261, 16, 0 } }, /* saves-the-whales */
    { .label = { 154041,  6, 0 } }, /* selfip */
    { .label = {  31247, 14, 0 } }, /* sells-for-less */
    { .label = {  64196, 11, 0 } }, /* sells-for-u */
    { .label = { 115602,  8, 0 } }, /* servebbs */
    { .label = {  77953, 10, 0 } }, /* simple-url */
    { .label = {  39527, 13, 0 } }, /* space-to-rent */
    { .label = {  50471, 12, 0 } }, /* teaches-yoga */
    { .label = {  31310, 14, 0 } }, /* writesthisblog */
    { .label = { 115862,  8, 0 } }, /* ddnsfree */
    { .label = { 115898,  8, 0 } }, /* ddnsgeek */
    { .label = { 164581,  5, 0 } }, /* giize */
    { .label = { 154101,  6, 0 } }, /* gleeze */
    { .label = { 164605,  5, 0 } }, /* kozow */
    { .label = {  78043, 10, 0 } }, /* loseyourip */
    { .label = { 164631,  5, 0 } }, /* ooguy */
    { .label = {  95307,  9, 0 } }, /* theworkpc */
    { .label = { 115934,  8, 0 } }, /* mytuleap */
    { .label = { 116007,  8, 1 } }, { .child = { 3007, 8 } }, /* evennode */
    { .label = { 164685,  5, 1 } }, { .child = { 3015, 1 } }, /* fbsbx */
    { .label = {  31438, 14, 0 } }, /* fastvps-server */
    { .label = {  64491, 11, 0 } }, /* firebaseapp */
    { .label = { 116571,  8, 0 } }, /* flynnhub */
    { .label = {  78270, 10, 0 } }, /* freebox-os */
    { .label = {  95609,  9, 0 } }, /* freeboxos */
    { .label = {  13208, 17, 0 } }, /* githubusercontent */
    { .label = {  37577,  4, 1 } }, { .child = { 3016, 1 } }, /* 0emm */
    { .label = { 137791,  7, 0 } }, /* appspot */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = { 116684,  8, 0 } }, /* codespot */
    { .label = {  78364, 10, 0 } }, /* googleapis */
    { .label = {  78408, 10, 0 } }, /* googlecode */
    { .label = {  10166, 18, 0 } }, /* pagespeedmobilizer */
    { .label = {  50633, 12, 0 } }, /* publishproxy */
    { .label = {  78453, 10, 0 } }, /* withgoogle */
    { .label = {  64591, 11, 0 } }, /* withyoutube */
    { .label = {  95693,  9, 0 } }, /* herokuapp */
    { .label = {  95735,  9, 0 } }, /* herokussl */
    { .label = {  95775,  9, 0 } }, /* myravendb */
    { .label = { 116793,  8, 0 } }, /* pixolino */
    { .label = { 154573,  6, 1 } }, { .child = { 3017, 1 } }, /* joyent */
    { .label = { 168669,  4, 1 } }, { .child = { 3020, 1 } }, /* lmpm */
    { .label = {  64792, 11, 0 } }, /* barsycenter */
    { .label = {  64744, 11, 0 } }, /* barsyonline */
    { .label = {  78718, 10, 0 } }, /* miniserver */
    { .label = {  95937,  9, 1 } }, { .child = { 3021, 1 } }, /* meteorapp */
    { .label = {  78761, 10, 0 } }, /* bitballoon */
    { .label = { 137920,  7, 0 } }, /* netlify */
    { .label = {  38588,  2, 0 } }, /* 4u */
    { .label = { 137985,  7, 0 } }, /* nfshost */
    { .label = { 154657,  6, 0 } }, /* 001www */
    { .label = { 116942,  8, 0 } }, /* ddnslive */
    { .label = { 116979,  8, 0 } }, /* myiphost */
    { .label = { 117052,  8, 0 } }, /* blogsyte */
    { .label = {  78806, 10, 0 } }, /* ciscofreak */
    { .label = {  78895, 10, 0 } }, /* damnserver */
    { .label = {  65033, 11, 0 } }, /* ditchyourip */
    { .label = {  78938, 10, 0 } }, /* dnsiskinky */
    { .label = { 165015,  5, 0 } }, /* dynns */
    { .label = {  78983, 10, 0 } }, /* geekgalaxy */
    { .label = {  13283, 17, 0 } }, /* health-carereform */
    { .label = {  24410, 15, 0 } }, /* homesecuritymac */
    { .label = {  31808, 14, 0 } }, /* homesecuritypc */
    { .label = {  13357, 17, 0 } }, /* myactivedirectory */
    { .label = {  17543, 16, 0 } }, /* mysecuritycamera */
    { .label = {  79029, 10, 0 } }, /* net-freaks */
    { .label = {  96098,  9, 0 } }, /* onthewifi */
    { .label = {  79072, 10, 0 } }, /* point2this */
    { .label = {  79119, 10, 0 } }, /* quicksytes */
    { .label = {  24477, 15, 0 } }, /* securitytactics */
    { .label = {  39988, 13, 0 } }, /* serveexchange */
    { .label = {  65085, 11, 0 } }, /* servehumour */
    { .label = { 117163,  8, 0 } }, /* servep2p */
    { .label = {  50861, 12, 0 } }, /* servesarcasm */
    { .label = {  65135, 11, 0 } }, /* stufftoread */
    { .label = {  40046, 13, 0 } }, /* unusualperson */
    { .label = {  50911, 12, 0 } }, /* workisboring */
    { .label = {  79212, 10, 0 } }, /* 3utilities */
    { .label = { 117242,  8, 0 } }, /* ddnsking */
    { .label = { 165138,  5, 0 } }, /* myvnc */
    { .label = {  96139,  9, 0 } }, /* servebeer */
    { .label = {  10250, 18, 0 } }, /* servecounterstrike */
    { .label = { 115640,  8, 0 } }, /* serveftp */
    { .label = {  95268,  9, 0 } }, /* servegame */
    { .label = {  40103, 13, 0 } }, /* servehalflife */
    { .label = {  96221,  9, 0 } }, /* servehttp */
    { .label = { 117278,  8, 0 } }, /* serveirc */
    { .label = { 117313,  8, 0 } }, /* servemp3 */
    { .label = {  96262,  9, 0 } }, /* servepics */
    { .label = {  79301, 10, 0 } }, /* servequake */
    { .label = {  79348, 10, 0 } }, /* operaunite */
    { .label = {  24542, 15, 0 } }, /* outsystemscloud */
    { .label = {  65184, 11, 0 } }, /* ownprovider */
    { .label = { 165207,  5, 0 } }, /* pgfog */
    { .label = {  50965, 12, 0 } }, /* pagefrontapp */
    { .label = {  65235, 11, 0 } }, /* gotpantheon */
    { .label = { 165260,  5, 1 } }, { .child = { 3022, 1 } }, /* prgmr */
    { .label = { 169555,  3, 0 } }, /* qa2 */
    { .label = {  24610, 15, 0 } }, /* dev-myqnapcloud */
    { .label = {  13434, 17, 0 } }, /* alpha-myqnapcloud */
    { .label = {  13461, 11, 0 } }, /* myqnapcloud */
    { .label = {  51070, 12, 1 } }, { .child = { 3023, 1 } }, /* quipelements */
    { .label = { 117424,  8, 0 } }, /* rackmaze */
    { .label = { 138267,  7, 0 } }, /* rhcloud */
    { .label = { 155067,  6, 0 } }, /* logoip */
    { .label = { 138332,  7, 0 } }, /* scrysec */
    { .label = {  17614, 16, 0 } }, /* firewall-gateway */
    { .label = {  51176, 12, 0 } }, /* myshopblocks */
    { .label = { 165307,  5, 0 } }, /* 1kapp */
    { .label = { 117492,  8, 0 } }, /* appchizi */
    { .label = { 117532,  8, 0 } }, /* applinzi */
    { .label = {  79679,  7, 0 } }, /* sinaapp */
    { .label = {  79663, 10, 0 } }, /* vipsinaapp */
    { .label = {  65383, 11, 1 } }, { .child = { 3024, 2 } }, /* bounty-full */
    { .label = { 117606,  8, 0 } }, /* temp-dns */
    { .label = { 138428,  7, 0 } }, /* dsmynas */
    { .label = { 117643,  8, 0 } }, /* familyds */
    { .label = { 138558,  7, 0 } }, /* bloxcms */
    { .label = {  17687, 16, 0 } }, /* townnews-staging */
    { .label = {    517,  2, 0 } }, /* hk */
    { .label = { 117867,  8, 0 } }, /* remotewd */
    { .label = { 165383,  5, 1 } }, { .child = { 3026, 2 } }, /* xnbay */
    { .label = { 117980,  8, 0 } }, /* yolasite */

    /* entries 2876 to 2933 */
    { .label = {  19748,  7, 1 } }, { .child = { 2934, 1 } }, /* compute */
    { .label = {  94364,  9, 1 } }, { .child = { 2935, 1 } }, /* compute-1 */
    { .label = {   4842,  9, 1 } }, { .child = { 2936, 1 } }, /* us-east-1 */
    { .label = {  40235,  3, 1 } }, { .child = { 2939, 1 } }, /* elb */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  12594, 17, 0 } }, /* s3-ap-northeast-1 */
    { .label = {  12674, 17, 0 } }, /* s3-ap-northeast-2 */
    { .label = {  38260, 13, 0 } }, /* s3-ap-south-1 */
    { .label = {  12754, 17, 0 } }, /* s3-ap-southeast-1 */
    { .label = {  12835, 17, 0 } }, /* s3-ap-southeast-2 */
    { .label = {  23283, 15, 0 } }, /* s3-ca-central-1 */
    { .label = {  23355, 15, 0 } }, /* s3-eu-central-1 */
    { .label = {  48926, 12, 0 } }, /* s3-eu-west-1 */
    { .label = {  48988, 12, 0 } }, /* s3-eu-west-2 */
    { .label = {  49050, 12, 0 } }, /* s3-eu-west-3 */
    { .label = {  38326, 13, 0 } }, /* s3-external-1 */
    { .label = {   3823, 21, 0 } }, /* s3-fips-us-gov-west-1 */
    { .label = {  49112, 12, 0 } }, /* s3-sa-east-1 */
    { .label = {  16633, 16, 0 } }, /* s3-us-gov-west-1 */
    { .label = {  49169, 12, 0 } }, /* s3-us-east-2 */
    { .label = {  49228, 12, 0 } }, /* s3-us-west-1 */
    { .label = {  49290, 12, 0 } }, /* s3-us-west-2 */
    { .label = {  12691, 14, 1 } }, { .child = { 2940, 3 } }, /* ap-northeast-2 */
    { .label = {  38277, 10, 1 } }, { .child = { 2945, 3 } }, /* ap-south-1 */
    { .label = {  23300, 12, 1 } }, { .child = { 2950, 3 } }, /* ca-central-1 */
    { .label = {  23372, 12, 1 } }, { .child = { 2955, 3 } }, /* eu-central-1 */
    { .label = {  49005,  9, 1 } }, { .child = { 2960, 3 } }, /* eu-west-2 */
    { .label = {  49067,  9, 1 } }, { .child = { 2965, 3 } }, /* eu-west-3 */
    { .label = {  49186,  9, 1 } }, { .child = { 2970, 3 } }, /* us-east-2 */
    { .label = {    720, 14, 1 } }, { .child = { 2975, 1 } }, /* ap-northeast-1 */
    { .label = {    837, 14, 1 } }, { .child = { 2978, 1 } }, /* ap-southeast-1 */
    { .label = {    955, 14, 1 } }, { .child = { 2981, 1 } }, /* ap-southeast-2 */
    { .label = {   5136,  9, 1 } }, { .child = { 2984, 1 } }, /* eu-west-1 */
    { .label = {   5235,  9, 1 } }, { .child = { 2987, 1 } }, /* sa-east-1 */
    { .label = {   4788, 20, 0 } }, /* s3-website-us-east-1 */
    { .label = {   4884, 20, 0 } }, /* s3-website-us-west-1 */
    { .label = {   4983, 20, 0 } }, /* s3-website-us-west-2 */
    { .label = {    666, 25, 0 } }, /* s3-website-ap-northeast-1 */
    { .label = {    783, 25, 0 } }, /* s3-website-ap-southeast-1 */
    { .label = {    901, 25, 0 } }, /* s3-website-ap-southeast-2 */
    { .label = {   5082, 20, 0 } }, /* s3-website-eu-west-1 */
    { .label = {   5181, 20, 0 } }, /* s3-website-sa-east-1 */

    /* entry 2934 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 2935 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2936 to 2937 */
    { .label = {  94410,  9, 1 } }, { .child = { 2938, 1 } }, /* dualstack */

    /* entry 2938 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entry 2939 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2940 to 2943 */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  94410,  9, 1 } }, { .child = { 2944, 1 } }, /* dualstack */
    { .label = {    666, 10, 0 } }, /* s3-website */

    /* entry 2944 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 2945 to 2948 */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  94410,  9, 1 } }, { .child = { 2949, 1 } }, /* dualstack */
    { .label = {    666, 10, 0 } }, /* s3-website */

    /* entry 2949 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 2950 to 2953 */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  94410,  9, 1 } }, { .child = { 2954, 1 } }, /* dualstack */
    { .label = {    666, 10, 0 } }, /* s3-website */

    /* entry 2954 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 2955 to 2958 */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  94410,  9, 1 } }, { .child = { 2959, 1 } }, /* dualstack */
    { .label = {    666, 10, 0 } }, /* s3-website */

    /* entry 2959 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 2960 to 2963 */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  94410,  9, 1 } }, { .child = { 2964, 1 } }, /* dualstack */
    { .label = {    666, 10, 0 } }, /* s3-website */

    /* entry 2964 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 2965 to 2968 */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  94410,  9, 1 } }, { .child = { 2969, 1 } }, /* dualstack */
    { .label = {    666, 10, 0 } }, /* s3-website */

    /* entry 2969 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 2970 to 2973 */
    { .label = {    666,  2, 0 } }, /* s3 */
    { .label = {  94410,  9, 1 } }, { .child = { 2974, 1 } }, /* dualstack */
    { .label = {    666, 10, 0 } }, /* s3-website */

    /* entry 2974 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 2975 to 2976 */
    { .label = {  94410,  9, 1 } }, { .child = { 2977, 1 } }, /* dualstack */

    /* entry 2977 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 2978 to 2979 */
    { .label = {  94410,  9, 1 } }, { .child = { 2980, 1 } }, /* dualstack */

    /* entry 2980 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 2981 to 2982 */
    { .label = {  94410,  9, 1 } }, { .child = { 2983, 1 } }, /* dualstack */

    /* entry 2983 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 2984 to 2985 */
    { .label = {  94410,  9, 1 } }, { .child = { 2986, 1 } }, /* dualstack */

    /* entry 2986 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 2987 to 2988 */
    { .label = {  94410,  9, 1 } }, { .child = { 2989, 1 } }, /* dualstack */

    /* entry 2989 */
    { .label = {    666,  2, 0 } }, /* s3 */

    /* entries 2990 to 3006 */
    { .label = {    720, 14, 0 } }, /* ap-northeast-1 */
    { .label = {  12691, 14, 0 } }, /* ap-northeast-2 */
    { .label = {  30523, 14, 0 } }, /* ap-northeast-3 */
    { .label = {  38277, 10, 0 } }, /* ap-south-1 */
    { .label = {    837, 14, 0 } }, /* ap-southeast-1 */
    { .label = {    955, 14, 0 } }, /* ap-southeast-2 */
    { .label = {  23300, 12, 0 } }, /* ca-central-1 */
    { .label = {  23372, 12, 0 } }, /* eu-central-1 */
    { .label = {   5136,  9, 0 } }, /* eu-west-1 */
    { .label = {  49005,  9, 0 } }, /* eu-west-2 */
    { .label = {  49067,  9, 0 } }, /* eu-west-3 */
    { .label = {   5235,  9, 0 } }, /* sa-east-1 */
    { .label = {   4842,  9, 0 } }, /* us-east-1 */
    { .label = {  49186,  9, 0 } }, /* us-east-2 */
    { .label = {   3865, 13, 0 } }, /* us-gov-west-1 */
    { .label = {   4938,  9, 0 } }, /* us-west-1 */
    { .label = {   5037,  9, 0 } }, /* us-west-2 */

    /* entries 3007 to 3014 */
    { .label = {  96618,  4, 0 } }, /* eu-1 */
    { .label = { 168496,  4, 0 } }, /* eu-2 */
    { .label = { 168518,  4, 0 } }, /* eu-3 */
    { .label = { 168540,  4, 0 } }, /* eu-4 */
    { .label = { 168563,  4, 0 } }, /* us-1 */
    { .label = { 168585,  4, 0 } }, /* us-2 */
    { .label = { 168607,  4, 0 } }, /* us-3 */
    { .label = { 168629,  4, 0 } }, /* us-4 */

    /* entry 3015 */
    { .label = {  76944,  4, 0 } }, /* apps */

    /* entry 3016 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3017 to 3018 */
    { .label = {   7579,  3, 1 } }, { .child = { 3019, 1 } }, /* cns */

    /* entry 3019 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 3020 */
    { .label = {   6750,  3, 0 } }, /* app */

    /* entry 3021 */
    { .label = {    325,  2, 0 } }, /* eu */

    /* entry 3022 */
    { .label = {  38390,  3, 0 } }, /* xen */

    /* entry 3023 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3024 to 3025 */
    { .label = {  13434,  5, 0 } }, /* alpha */
    { .label = {  76872,  4, 0 } }, /* beta */

    /* entries 3026 to 3027 */
    { .label = {  59003,  2, 0 } }, /* u2 */
    { .label = { 117903,  8, 0 } }, /* u2-local */

    /* entries 3028 to 3034 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   3988,  2, 0 } }, /* ed */
    { .label = {    391,  2, 0 } }, /* fi */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {    355,  2, 0 } }, /* sa */

    /* entries 3035 to 3040 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   5417,  3, 0 } }, /* inf */

    /* entry 3041 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 3042 to 3045 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 3046 to 3048 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   1517,  3, 0 } }, /* ath */
    { .label = {  28720,  4, 0 } }, /* info */

    /* entries 3049 to 3062 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  54555,  3, 0 } }, /* biz */
    { .label = {    106,  3, 1 } }, { .child = { 3063, 1 } }, /* com */
    { .label = { 118648,  7, 0 } }, /* ekloges */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 129382,  3, 0 } }, /* ltd */
    { .label = {  29414,  4, 0 } }, /* name */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  66519, 10, 0 } }, /* parliament */
    { .label = {  22790,  5, 0 } }, /* press */
    { .label = {  22835,  3, 0 } }, /* pro */
    { .label = {   2425,  2, 0 } }, /* tm */

    /* entry 3063 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 3064 to 3071 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = { 107538,  5, 0 } }, /* realm */
    { .label = {  12576,  2, 0 } }, /* e4 */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  64885, 11, 1 } }, { .child = { 3072, 2 } }, /* metacentrum */
    { .label = {    115,  4, 1 } }, { .child = { 3074, 1 } }, /* muni */

    /* entries 3072 to 3073 */
    { .label = {  13493,  5, 0 } }, /* cloud */
    { .label = { 115972,  6, 0 } }, /* custom */

    /* entries 3074 to 3075 */
    { .label = {  13493,  5, 1 } }, { .child = { 3076, 2 } }, /* cloud */

    /* entries 3076 to 3077 */
    { .label = {  41611,  3, 0 } }, /* flt */
    { .label = {  17950,  3, 0 } }, /* usr */

    /* entries 3078 to 3136 */
    { .label = { 134812,  7, 0 } }, /* bplaced */
    { .label = { 134775,  7, 0 } }, /* square7 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 134951,  7, 1 } }, { .child = { 3137, 1 } }, /* cosidns */
    { .label = {  23631, 15, 0 } }, /* dynamisches-dns */
    { .label = {  77060, 10, 0 } }, /* dnsupdater */
    { .label = {  49528, 12, 0 } }, /* internet-dns */
    { .label = {  94626,  9, 0 } }, /* l-o-g-i-n */
    { .label = { 135045,  7, 0 } }, /* dnshome */
    { .label = {  23822, 15, 0 } }, /* fuettertdasnetz */
    { .label = {  77638, 10, 0 } }, /* isteingeek */
    { .label = { 137272,  7, 0 } }, /* istmein */
    { .label = {  77724, 10, 0 } }, /* lebtimnetz */
    { .label = {  77771, 10, 0 } }, /* leitungsen */
    { .label = {  39583, 13, 0 } }, /* traeumtgerade */
    { .label = { 164559,  5, 1 } }, { .child = { 3138, 2 } }, /* ddnss */
    { .label = { 137335,  7, 0 } }, /* dyndns1 */
    { .label = { 115747,  8, 0 } }, /* dyn-ip24 */
    { .label = {  31373, 14, 1 } }, { .child = { 3140, 1 } }, /* home-webserver */
    { .label = {  39637, 13, 0 } }, /* myhome-server */
    { .label = { 155076,  4, 0 } }, /* goip */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  78543, 10, 0 } }, /* mein-iserv */
    { .label = {  78587, 10, 0 } }, /* test-iserv */
    { .label = {  78630, 10, 0 } }, /* keymachine */
    { .label = {  95856,  9, 0 } }, /* git-repos */
    { .label = {  50694, 12, 0 } }, /* lcube-server */
    { .label = {  95896,  9, 0 } }, /* svn-repos */
    { .label = {  64744,  5, 0 } }, /* barsy */
    { .label = { 155067,  6, 0 } }, /* logoip */
    { .label = {  17614, 16, 0 } }, /* firewall-gateway */
    { .label = {  79528, 10, 0 } }, /* my-gateway */
    { .label = {  96343,  9, 0 } }, /* my-router */
    { .label = { 165284,  5, 0 } }, /* spdns */
    { .label = {  51235, 12, 1 } }, { .child = { 3141, 1 } }, /* speedpartner */
    { .label = {  79709, 10, 0 } }, /* taifun-dns */
    { .label = { 168940,  4, 0 } }, /* 12hp */
    { .label = { 169593,  3, 0 } }, /* 2ix */
    { .label = { 165357,  5, 0 } }, /* 4lima */
    { .label = {  96464,  9, 0 } }, /* lima-city */
    { .label = { 155199,  6, 0 } }, /* dd-dns */
    { .label = { 117752,  8, 0 } }, /* dray-dns */
    { .label = { 138593,  7, 0 } }, /* draydns */
    { .label = { 138624,  7, 0 } }, /* dyn-vpn */
    { .label = { 155227,  6, 0 } }, /* dynvpn */
    { .label = {  79753, 10, 0 } }, /* mein-vigor */
    { .label = { 117788,  8, 0 } }, /* my-vigor */
    { .label = { 155258,  6, 0 } }, /* my-wan */
    { .label = { 138660,  7, 0 } }, /* syno-ds */
    { .label = {   5450, 20, 0 } }, /* synology-diskstation */
    { .label = {  65491, 11, 0 } }, /* synology-ds */
    { .label = {  96549,  9, 1 } }, { .child = { 3142, 1 } }, /* uberspace */
    { .label = {  65543, 11, 0 } }, /* virtualuser */
    { .label = {  51287, 12, 0 } }, /* virtual-user */

    /* entry 3137 */
    { .label = {  23631,  3, 0 } }, /* dyn */

    /* entries 3138 to 3139 */
    { .label = {  23631,  3, 0 } }, /* dyn */
    { .label = {  30648,  6, 0 } }, /* dyndns */

    /* entry 3140 */
    { .label = {  23631,  3, 0 } }, /* dyn */

    /* entry 3141 */
    { .label = { 115972,  8, 0 } }, /* customer */

    /* entry 3142 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3143 to 3148 */
    { .label = {  54555,  3, 0 } }, /* biz */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = { 113331,  4, 0 } }, /* firm */
    { .label = {  18828,  3, 0 } }, /* reg */
    { .label = { 155394,  5, 0 } }, /* store */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 3149 to 3153 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entries 3154 to 3163 */
    { .label = {   7867,  3, 0 } }, /* art */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  35712,  3, 0 } }, /* sld */
    { .label = {    683,  3, 0 } }, /* web */

    /* entries 3164 to 3171 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = {  27852,  3, 0 } }, /* pol */
    { .label = {   7867,  3, 0 } }, /* art */

    /* entries 3172 to 3183 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {   3951,  3, 0 } }, /* fin */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = {  22835,  3, 0 } }, /* pro */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {   3679,  3, 0 } }, /* mil */

    /* entries 3184 to 3194 */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  78325,  4, 0 } }, /* riik */
    { .label = {  16947,  3, 0 } }, /* lib */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = {    106,  3, 1 } }, { .child = { 3195, 1 } }, /* com */
    { .label = {   1461,  3, 0 } }, /* pri */
    { .label = {  20384,  3, 0 } }, /* aip */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   7044,  3, 0 } }, /* fie */

    /* entry 3195 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 3196 to 3205 */
    { .label = {    106,  3, 1 } }, { .child = { 3206, 1 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  11169,  3, 0 } }, /* eun */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  29414,  4, 0 } }, /* name */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    601,  3, 0 } }, /* sci */

    /* entry 3206 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entry 3207 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3208 to 3213 */
    { .label = {    106,  3, 1 } }, { .child = { 3214, 1 } }, /* com */
    { .label = {  25342,  3, 0 } }, /* nom */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {  42919,  3, 0 } }, /* edu */

    /* entry 3214 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 3215 to 3222 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  54555,  3, 0 } }, /* biz */
    { .label = {  29414,  4, 0 } }, /* name */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {  16771,  3, 0 } }, /* net */

    /* entries 3223 to 3230 */
    { .label = { 168361,  4, 0 } }, /* mycd */
    { .label = { 134919,  7, 0 } }, /* cloudns */
    { .label = {  64744,  5, 0 } }, /* barsy */
    { .label = {  40224, 13, 0 } }, /* wellbeingzone */
    { .label = { 165284,  5, 0 } }, /* spdns */
    { .label = { 117719,  8, 1 } }, { .child = { 3231, 1 } }, /* transurl */
    { .label = {   5493, 11, 0 } }, /* diskstation */

    /* entry 3231 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3232 to 3235 */
    { .label = {  15270,  5, 0 } }, /* aland */
    { .label = {   1388,  2, 0 } }, /* dy */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  21434,  3, 0 } }, /* iki */

    /* entry 3236 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 3237 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3238 to 3267 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = {  25342,  3, 0 } }, /* nom */
    { .label = {  98602,  3, 0 } }, /* prd */
    { .label = { 139248,  6, 0 } }, /* presse */
    { .label = {   2425,  2, 0 } }, /* tm */
    { .label = {  97366,  8, 0 } }, /* aeroport */
    { .label = { 118679,  7, 0 } }, /* assedic */
    { .label = { 139274,  6, 0 } }, /* avocat */
    { .label = { 139299,  6, 0 } }, /* avoues */
    { .label = {    466,  3, 0 } }, /* cci */
    { .label = {  80309,  9, 0 } }, /* chambagri */
    { .label = {    190, 21, 0 } }, /* chirurgiens-dentistes */
    { .label = {   7850, 18, 0 } }, /* experts-comptables */
    { .label = {  17826, 15, 0 } }, /* geometre-expert */
    { .label = { 165542,  4, 0 } }, /* gouv */
    { .label = { 155565,  5, 0 } }, /* greta */
    { .label = {  13586, 16, 0 } }, /* huissier-justice */
    { .label = { 118708,  7, 0 } }, /* medecin */
    { .label = {  97399,  8, 0 } }, /* notaires */
    { .label = {  55747, 10, 0 } }, /* pharmacien */
    { .label = {  17788,  4, 0 } }, /* port */
    { .label = {  51669, 11, 0 } }, /* veterinaire */
    { .label = { 154434,  6, 0 } }, /* fbx-os */
    { .label = { 164874,  5, 0 } }, /* fbxos */
    { .label = {  78270, 10, 0 } }, /* freebox-os */
    { .label = {  95609,  9, 0 } }, /* freeboxos */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = { 155008,  6, 0 } }, /* on-web */
    { .label = {    190, 31, 0 } }, /* chirurgiens-dentistes-en-france */

    /* entry 3268 */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entries 3269 to 3276 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = { 169238,  3, 0 } }, /* pvt */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entries 3277 to 3280 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   7206,  3, 0 } }, /* cya */

    /* entries 3281 to 3285 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3679,  3, 0 } }, /* mil */

    /* entries 3286 to 3291 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 129382,  3, 0 } }, /* ltd */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  45011,  3, 0 } }, /* mod */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 3292 to 3297 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entries 3298 to 3303 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  16771,  3, 0 } }, /* net */

    /* entries 3304 to 3309 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {  10207,  4, 0 } }, /* mobi */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   2766,  4, 0 } }, /* asso */

    /* entries 3310 to 3316 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  43390,  3, 0 } }, /* nym */

    /* entries 3317 to 3324 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {   8838,  3, 0 } }, /* ind */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entries 3325 to 3332 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 165602,  4, 0 } }, /* guam */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    683,  3, 0 } }, /* web */

    /* entries 3333 to 3339 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  43390,  3, 0 } }, /* nym */

    /* entries 3340 to 3363 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 169254,  3, 0 } }, /* idv */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  66351, 10, 0 } }, /* xn--55qx5d */
    { .label = {  51714, 11, 0 } }, /* xn--wcvs22d */
    { .label = {  51776, 11, 0 } }, /* xn--lcvr32d */
    { .label = {  66561, 10, 0 } }, /* xn--mxtq1m */
    { .label = {  66617, 10, 0 } }, /* xn--gmqw5a */
    { .label = {  80349,  9, 0 } }, /* xn--ciqpn */
    { .label = {  51837, 11, 0 } }, /* xn--gmq050i */
    { .label = {  66673, 10, 0 } }, /* xn--zf0avx */
    { .label = {  66417, 10, 0 } }, /* xn--io0a7i */
    { .label = {  66729, 10, 0 } }, /* xn--mk0axi */
    { .label = {  66469, 10, 0 } }, /* xn--od0alg */
    { .label = {  51904, 11, 0 } }, /* xn--od0aq3b */
    { .label = {  80396,  9, 0 } }, /* xn--tn0ag */
    { .label = {  66780, 10, 0 } }, /* xn--uc0atv */
    { .label = {  51966, 11, 0 } }, /* xn--uc0ay4a */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = { 129382,  3, 0 } }, /* ltd */
    { .label = {  19520,  3, 0 } }, /* inc */

    /* entries 3364 to 3370 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entries 3371 to 3375 */
    { .label = {   1488,  2, 0 } }, /* iz */
    { .label = { 135365,  4, 0 } }, /* from */
    { .label = {  29414,  4, 0 } }, /* name */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 3376 to 3392 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  51187,  4, 0 } }, /* shop */
    { .label = { 113331,  4, 0 } }, /* firm */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = { 155585,  5, 0 } }, /* adult */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {  22835,  3, 0 } }, /* pro */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = {   7867,  3, 0 } }, /* art */
    { .label = {  51529,  4, 0 } }, /* coop */
    { .label = {  27852,  3, 0 } }, /* pol */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   2926,  3, 0 } }, /* rel */
    { .label = { 165542,  4, 0 } }, /* gouv */
    { .label = {   5389,  5, 0 } }, /* perso */

    /* entries 3393 to 3424 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   1461,  4, 0 } }, /* priv */
    { .label = {  66249,  5, 0 } }, /* sport */
    { .label = {   2425,  2, 0 } }, /* tm */
    { .label = { 165620,  4, 0 } }, /* 2000 */
    { .label = { 155607,  5, 0 } }, /* agrar */
    { .label = { 165652,  4, 0 } }, /* bolt */
    { .label = { 139325,  6, 0 } }, /* casino */
    { .label = {  96486,  4, 0 } }, /* city */
    { .label = { 118739,  7, 0 } }, /* erotica */
    { .label = { 118767,  7, 0 } }, /* erotika */
    { .label = {  79860,  4, 0 } }, /* film */
    { .label = { 154699,  5, 0 } }, /* forum */
    { .label = {  39212,  5, 0 } }, /* games */
    { .label = {  60068,  5, 0 } }, /* hotel */
    { .label = {  97430,  8, 0 } }, /* ingatlan */
    { .label = { 139349,  6, 0 } }, /* jogasz */
    { .label = {  97462,  8, 0 } }, /* konyvelo */
    { .label = { 155626,  5, 0 } }, /* lakas */
    { .label = {  96066,  5, 0 } }, /* media */
    { .label = {  17705,  4, 0 } }, /* news */
    { .label = { 139379,  6, 0 } }, /* reklam */
    { .label = {   6268,  3, 0 } }, /* sex */
    { .label = {  51187,  4, 0 } }, /* shop */
    { .label = { 165671,  4, 0 } }, /* suli */
    { .label = {  29260,  4, 0 } }, /* szex */
    { .label = { 139405,  6, 0 } }, /* tozsde */
    { .label = { 139433,  6, 0 } }, /* utazas */
    { .label = { 155646,  5, 0 } }, /* video */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 3425 to 3437 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  54555,  3, 0 } }, /* biz */
    { .label = {     42,  2, 1 } }, { .child = { 3438, 1 } }, /* co */
    { .label = { 141132,  4, 0 } }, /* desa */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {    194,  2, 0 } }, /* my */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {   6667,  3, 0 } }, /* sch */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = {  40267,  4, 0 } }, /* zone */

    /* entry 3438 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 3439 to 3441 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  43390,  3, 0 } }, /* nym */

    /* entries 3442 to 3450 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 1 } }, { .child = { 3451, 1 } }, /* co */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13363,  3, 0 } }, /* idf */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    115,  4, 0 } }, /* muni */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entry 3451 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 3452 to 3461 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 1 } }, { .child = { 3462, 2 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {      3,  2, 0 } }, /* tt */
    { .label = {   9431,  2, 0 } }, /* tv */
    { .label = {    524,  2, 0 } }, /* ro */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entries 3462 to 3463 */
    { .label = { 129382,  3, 0 } }, /* ltd */
    { .label = {  13187,  3, 0 } }, /* plc */

    /* entries 3464 to 3478 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = { 113331,  4, 0 } }, /* firm */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   1386,  3, 0 } }, /* gen */
    { .label = {   8838,  3, 0 } }, /* ind */
    { .label = {    125,  3, 0 } }, /* nic */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  22470,  3, 0 } }, /* res */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = { 134919,  7, 0 } }, /* cloudns */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  64744,  5, 0 } }, /* barsy */

    /* entries 3479 to 3498 */
    { .label = { 134919,  7, 0 } }, /* cloudns */
    { .label = {  62960, 11, 0 } }, /* dynamic-dns */
    { .label = {  30648,  6, 0 } }, /* dyndns */
    { .label = {   7762, 19, 0 } }, /* barrel-of-knowledge */
    { .label = {   5275, 20, 0 } }, /* barrell-of-knowledge */
    { .label = { 135301,  7, 0 } }, /* for-our */
    { .label = {  94909,  9, 0 } }, /* groks-the */
    { .label = {  77420, 10, 0 } }, /* groks-this */
    { .label = {  38794, 13, 0 } }, /* here-for-more */
    { .label = {  77680, 10, 0 } }, /* knowsitall */
    { .label = { 154041,  6, 0 } }, /* selfip */
    { .label = { 154070,  6, 0 } }, /* webhop */
    { .label = {  64744,  5, 0 } }, /* barsy */
    { .label = { 116867,  8, 0 } }, /* mayfirst */
    { .label = { 154699,  6, 0 } }, /* forumz */
    { .label = {  77065,  8, 0 } }, /* nsupdate */
    { .label = { 154759,  6, 0 } }, /* dvrcam */
    { .label = {  50806, 12, 0 } }, /* ilovecollege */
    { .label = { 165088,  5, 0 } }, /* no-ip */
    { .label = { 155287,  6, 0 } }, /* v-info */

    /* entry 3499 */
    { .label = {    325,  2, 0 } }, /* eu */

    /* entries 3500 to 3540 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  49352, 12, 0 } }, /* backplaneapp */
    { .label = { 134740,  7, 0 } }, /* boxfuse */
    { .label = {  12916, 17, 0 } }, /* browsersafetymark */
    { .label = {  76916, 10, 0 } }, /* cleverapps */
    { .label = { 164510,  5, 0 } }, /* dedyn */
    { .label = { 168439,  4, 0 } }, /* drud */
    { .label = { 115794,  8, 0 } }, /* definima */
    { .label = { 154216,  6, 1 } }, { .child = { 3541, 1 } }, /* enonic */
    { .label = {  13208,  6, 0 } }, /* github */
    { .label = { 154492,  6, 0 } }, /* gitlab */
    { .label = {  78499, 10, 0 } }, /* hasura-app */
    { .label = {  64744,  5, 0 } }, /* barsy */
    { .label = {  31631, 14, 0 } }, /* azurecontainer */
    { .label = { 164900,  5, 0 } }, /* ngrok */
    { .label = { 138206,  7, 1 } }, { .child = { 3542, 1 } }, /* nodeart */
    { .label = { 165184,  5, 0 } }, /* nodum */
    { .label = {  23859,  3, 0 } }, /* nid */
    { .label = {  51020, 12, 0 } }, /* pantheonsite */
    { .label = { 117390,  8, 0 } }, /* protonet */
    { .label = {  79436, 10, 0 } }, /* vaporcloud */
    { .label = {  65282, 11, 0 } }, /* resindevice */
    { .label = {  51127, 12, 1 } }, { .child = { 3543, 1 } }, /* resinstaging */
    { .label = {  59842,  3, 0 } }, /* hzc */
    { .label = { 117460,  8, 0 } }, /* sandcats */
    { .label = { 169574,  3, 1 } }, { .child = { 3544, 1 } }, /* s5y */
    { .label = {  96384,  9, 0 } }, /* shiftedit */
    { .label = {  97244,  4, 1 } }, { .child = { 3545, 1 } }, /* lair */
    { .label = { 155095,  6, 1 } }, { .child = { 3546, 1 } }, /* stolos */
    { .label = { 117571,  8, 0 } }, /* spacekit */
    { .label = { 138364,  7, 0 } }, /* utwente */
    { .label = {  96424,  9, 1 } }, { .child = { 3547, 4 } }, /* thingdust */
    { .label = { 169017,  4, 0 } }, /* 2038 */
    { .label = { 117827,  8, 0 } }, /* wedeploy */

    /* entry 3541 */
    { .label = { 115972,  8, 0 } }, /* customer */

    /* entry 3542 */
    { .label = { 165164,  5, 0 } }, /* stage */

    /* entry 3543 */
    { .label = { 138300,  7, 0 } }, /* devices */

    /* entry 3544 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 3545 */
    { .label = {  76944,  4, 0 } }, /* apps */

    /* entry 3546 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3547 to 3554 */
    { .label = {   9807,  3, 1 } }, { .child = { 3555, 1 } }, /* dev */
    { .label = { 155173,  6, 1 } }, { .child = { 3556, 1 } }, /* disrec */
    { .label = {  60289,  4, 1 } }, { .child = { 3557, 1 } }, /* prod */
    { .label = { 138529,  7, 1 } }, { .child = { 3558, 1 } }, /* testing */

    /* entry 3555 */
    { .label = { 115972,  4, 0 } }, /* cust */

    /* entry 3556 */
    { .label = { 115972,  4, 0 } }, /* cust */

    /* entry 3557 */
    { .label = { 115972,  4, 0 } }, /* cust */

    /* entry 3558 */
    { .label = { 115972,  4, 0 } }, /* cust */

    /* entries 3559 to 3564 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  16771,  3, 0 } }, /* net */

    /* entries 3565 to 3573 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {     86,  2, 0 } }, /* id */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   6667,  3, 0 } }, /* sch */
    { .label = {  17893, 15, 0 } }, /* xn--mgba3a4f16a */
    { .label = {  24748, 14, 0 } }, /* xn--mgba3a4fra */

    /* entries 3574 to 3581 */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = { 134981,  7, 0 } }, /* cupcake */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 3582 to 3991 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   8685,  3, 0 } }, /* abr */
    { .label = { 118795,  7, 0 } }, /* abruzzo */
    { .label = {  40397, 12, 0 } }, /* aosta-valley */
    { .label = {  52025, 11, 0 } }, /* aostavalley */
    { .label = {   1439,  3, 0 } }, /* bas */
    { .label = {  66831, 10, 0 } }, /* basilicata */
    { .label = {  11146,  3, 0 } }, /* cal */
    { .label = {  18859,  8, 0 } }, /* calabria */
    { .label = {  17590,  3, 0 } }, /* cam */
    { .label = {  97500,  8, 0 } }, /* campania */
    { .label = {  24820, 14, 0 } }, /* emilia-romagna */
    { .label = {  32208, 13, 0 } }, /* emiliaromagna */
    { .label = { 169269,  3, 0 } }, /* emr */
    { .label = {  17978, 15, 0 } }, /* friuli-v-giulia */
    { .label = {  13658, 16, 0 } }, /* friuli-ve-giulia */
    { .label = {  18048, 15, 0 } }, /* friuli-vegiulia */
    { .label = {   2809, 21, 0 } }, /* friuli-venezia-giulia */
    { .label = {   4019, 20, 0 } }, /* friuli-veneziagiulia */
    { .label = {  24878, 14, 0 } }, /* friuli-vgiulia */
    { .label = {  24943, 14, 0 } }, /* friuliv-giulia */
    { .label = {  18117, 15, 0 } }, /* friulive-giulia */
    { .label = {  25008, 14, 0 } }, /* friulivegiulia */
    { .label = {   4110, 20, 0 } }, /* friulivenezia-giulia */
    { .label = {   5704, 19, 0 } }, /* friuliveneziagiulia */
    { .label = {  32261, 13, 0 } }, /* friulivgiulia */
    { .label = { 169282,  3, 0 } }, /* fvg */
    { .label = { 155669,  3, 0 } }, /* laz */
    { .label = { 155669,  5, 0 } }, /* lazio */
    { .label = {  16891,  3, 0 } }, /* lig */
    { .label = { 118831,  7, 0 } }, /* liguria */
    { .label = {  17830,  3, 0 } }, /* lom */
    { .label = {  80440,  9, 0 } }, /* lombardia */
    { .label = {  97533,  8, 0 } }, /* lombardy */
    { .label = { 118861,  7, 0 } }, /* lucania */
    { .label = {   1369,  3, 0 } }, /* mar */
    { .label = { 139459,  6, 0 } }, /* marche */
    { .label = {   7047,  3, 0 } }, /* mol */
    { .label = { 139485,  6, 0 } }, /* molise */
    { .label = {  97571,  8, 0 } }, /* piedmont */
    { .label = {  97607,  8, 0 } }, /* piemonte */
    { .label = {  39002,  3, 0 } }, /* pmn */
    { .label = { 121390,  3, 0 } }, /* pug */
    { .label = { 139511,  6, 0 } }, /* puglia */
    { .label = {   3878,  3, 0 } }, /* sar */
    { .label = {  97642,  8, 0 } }, /* sardegna */
    { .label = {  97674,  8, 0 } }, /* sardinia */
    { .label = {  36738,  3, 0 } }, /* sic */
    { .label = { 118890,  7, 0 } }, /* sicilia */
    { .label = { 139539,  6, 0 } }, /* sicily */
    { .label = {     20,  3, 0 } }, /* taa */
    { .label = {   5643,  3, 0 } }, /* tos */
    { .label = { 118919,  7, 0 } }, /* toscana */
    { .label = {  10327, 17, 0 } }, /* trentin-sud-tirol */
    { .label = {   1019, 24, 0 } }, /* xn--trentin-sd-tirol-rzb */
    { .label = {  13732, 16, 0 } }, /* trentin-sudtirol */
    { .label = {   1566, 23, 0 } }, /* xn--trentin-sdtirol-7vb */
    { .label = {   7933, 18, 0 } }, /* trentin-sued-tirol */
    { .label = {  10400, 17, 0 } }, /* trentin-suedtirol */
    { .label = {  13800, 16, 0 } }, /* trentino-a-adige */
    { .label = {  18186, 15, 0 } }, /* trentino-aadige */
    { .label = {   5790, 19, 0 } }, /* trentino-alto-adige */
    { .label = {   8010, 18, 0 } }, /* trentino-altoadige */
    { .label = {  13866, 16, 0 } }, /* trentino-s-tirol */
    { .label = {  18247, 15, 0 } }, /* trentino-stirol */
    { .label = {   8084, 18, 0 } }, /* trentino-sud-tirol */
    { .label = {    445, 25, 0 } }, /* xn--trentino-sd-tirol-c3b */
    { .label = {  10472, 17, 0 } }, /* trentino-sudtirol */
    { .label = {   1129, 24, 0 } }, /* xn--trentino-sdtirol-szb */
    { .label = {   5869, 19, 0 } }, /* trentino-sued-tirol */
    { .label = {   8161, 18, 0 } }, /* trentino-suedtirol */
    { .label = {    465,  8, 0 } }, /* trentino */
    { .label = {  18309, 15, 0 } }, /* trentinoa-adige */
    { .label = {  25072, 14, 0 } }, /* trentinoaadige */
    { .label = {   8237, 18, 0 } }, /* trentinoalto-adige */
    { .label = {  10544, 17, 0 } }, /* trentinoaltoadige */
    { .label = {  18370, 15, 0 } }, /* trentinos-tirol */
    { .label = {  25128, 14, 0 } }, /* trentinostirol */
    { .label = {  10613, 17, 0 } }, /* trentinosud-tirol */
    { .label = {   1238, 24, 0 } }, /* xn--trentinosd-tirol-rzb */
    { .label = {  13933, 16, 0 } }, /* trentinosudtirol */
    { .label = {   1675, 23, 0 } }, /* xn--trentinosdtirol-7vb */
    { .label = {   8311, 18, 0 } }, /* trentinosued-tirol */
    { .label = {  10685, 17, 0 } }, /* trentinosuedtirol */
    { .label = {  14000, 16, 0 } }, /* trentinsud-tirol */
    { .label = {   1783, 23, 0 } }, /* xn--trentinsd-tirol-6vb */
    { .label = {  18432, 15, 0 } }, /* trentinsudtirol */
    { .label = {   2090, 22, 0 } }, /* xn--trentinsdtirol-nsb */
    { .label = {  10756, 17, 0 } }, /* trentinsued-tirol */
    { .label = {  14068, 16, 0 } }, /* trentinsuedtirol */
    { .label = { 118946,  7, 0 } }, /* tuscany */
    { .label = {  19596,  3, 0 } }, /* umb */
    { .label = { 139567,  6, 0 } }, /* umbria */
    { .label = {  52072, 11, 0 } }, /* val-d-aosta */
    { .label = {  66872, 10, 0 } }, /* val-daosta */
    { .label = {  66914, 10, 0 } }, /* vald-aosta */
    { .label = {  80479,  9, 0 } }, /* valdaosta */
    { .label = {  52119, 11, 0 } }, /* valle-aosta */
    { .label = {  32321, 13, 0 } }, /* valle-d-aosta */
    { .label = {  40449, 12, 0 } }, /* valle-daosta */
    { .label = {  66956, 10, 0 } }, /* valleaosta */
    { .label = {  40500, 12, 0 } }, /* valled-aosta */
    { .label = {  52165, 11, 0 } }, /* valledaosta */
    { .label = {  40551, 12, 0 } }, /* vallee-aoste */
    { .label = {   5950, 19, 0 } }, /* xn--valle-aoste-ebb */
    { .label = {  25185, 14, 0 } }, /* vallee-d-aoste */
    { .label = {   2905, 21, 0 } }, /* xn--valle-d-aoste-ehb */
    { .label = {  52211, 11, 0 } }, /* valleeaoste */
    { .label = {   8387, 18, 0 } }, /* xn--valleaoste-e7a */
    { .label = {  40602, 12, 0 } }, /* valleedaoste */
    { .label = {   6038, 19, 0 } }, /* xn--valledaoste-ebb */
    { .label = {  12985,  3, 0 } }, /* vao */
    { .label = {  35684,  3, 0 } }, /* vda */
    { .label = {   2842,  3, 0 } }, /* ven */
    { .label = { 139594,  6, 0 } }, /* veneto */
    { .label = {   1191,  2, 0 } }, /* ag */
    { .label = {  80516,  9, 0 } }, /* agrigento */
    { .label = {     94,  2, 0 } }, /* al */
    { .label = {  52257, 11, 0 } }, /* alessandria */
    { .label = {   5827, 10, 0 } }, /* alto-adige */
    { .label = {   8047,  9, 0 } }, /* altoadige */
    { .label = {    227,  2, 0 } }, /* an */
    { .label = { 139620,  6, 0 } }, /* ancona */
    { .label = {   3002, 21, 0 } }, /* andria-barletta-trani */
    { .label = {   3087, 21, 0 } }, /* andria-trani-barletta */
    { .label = {   6126, 19, 0 } }, /* andriabarlettatrani */
    { .label = {   6201, 19, 0 } }, /* andriatranibarletta */
    { .label = {   1422,  2, 0 } }, /* ao */
    { .label = {  32359,  5, 0 } }, /* aosta */
    { .label = {   2963,  5, 0 } }, /* aoste */
    { .label = {    244,  2, 0 } }, /* ap */
    { .label = {   1428,  2, 0 } }, /* aq */
    { .label = { 119398,  6, 0 } }, /* aquila */
    { .label = {     45,  2, 0 } }, /* ar */
    { .label = { 139643,  6, 0 } }, /* arezzo */
    { .label = {  32377, 13, 0 } }, /* ascoli-piceno */
    { .label = {  40653, 12, 0 } }, /* ascolipiceno */
    { .label = {   2051,  4, 0 } }, /* asti */
    { .label = {    340,  2, 0 } }, /* at */
    { .label = {    586,  2, 0 } }, /* av */
    { .label = {  97705,  8, 0 } }, /* avellino */
    { .label = {    118,  2, 0 } }, /* ba */
    { .label = {  18495, 15, 0 } }, /* balsan-sudtirol */
    { .label = {   2187, 22, 0 } }, /* xn--balsan-sdtirol-nsb */
    { .label = {  14135, 16, 0 } }, /* balsan-suedtirol */
    { .label = {   2207,  6, 0 } }, /* balsan */
    { .label = {  36455,  4, 0 } }, /* bari */
    { .label = {   3172, 21, 0 } }, /* barletta-trani-andria */
    { .label = {   6149, 19, 0 } }, /* barlettatraniandria */
    { .label = { 118977,  7, 0 } }, /* belluno */
    { .label = {  80553,  9, 0 } }, /* benevento */
    { .label = { 119010,  7, 0 } }, /* bergamo */
    { .label = {   9229,  2, 0 } }, /* bg */
    { .label = {    282,  2, 0 } }, /* bi */
    { .label = { 139672,  6, 0 } }, /* biella */
    { .label = {     95,  2, 0 } }, /* bl */
    { .label = {   2214,  2, 0 } }, /* bn */
    { .label = {    716,  2, 0 } }, /* bo */
    { .label = { 119041,  7, 0 } }, /* bologna */
    { .label = {  10828, 17, 0 } }, /* bolzano-altoadige */
    { .label = {  10828,  7, 0 } }, /* bolzano */
    { .label = {  25246, 14, 0 } }, /* bozen-sudtirol */
    { .label = {   3257, 21, 0 } }, /* xn--bozen-sdtirol-2ob */
    { .label = {  18560, 15, 0 } }, /* bozen-suedtirol */
    { .label = {   3277,  5, 0 } }, /* bozen */
    { .label = {    294,  2, 0 } }, /* br */
    { .label = { 119072,  7, 0 } }, /* brescia */
    { .label = {  97740,  8, 0 } }, /* brindisi */
    { .label = {    693,  2, 0 } }, /* bs */
    { .label = {   1108,  2, 0 } }, /* bt */
    { .label = {  18629, 15, 0 } }, /* bulsan-sudtirol */
    { .label = {   2286, 22, 0 } }, /* xn--bulsan-sdtirol-nsb */
    { .label = {  14204, 16, 0 } }, /* bulsan-suedtirol */
    { .label = {   2306,  6, 0 } }, /* bulsan */
    { .label = {   3703,  2, 0 } }, /* bz */
    { .label = {    133,  2, 0 } }, /* ca */
    { .label = {  97775,  8, 0 } }, /* cagliari */
    { .label = {  32434, 13, 0 } }, /* caltanissetta */
    { .label = {  18696, 15, 0 } }, /* campidano-medio */
    { .label = {  25311, 14, 0 } }, /* campidanomedio */
    { .label = {  66997, 10, 0 } }, /* campobasso */
    { .label = {  10903, 17, 0 } }, /* carbonia-iglesias */
    { .label = {  14275, 16, 0 } }, /* carboniaiglesias */
    { .label = {  32485, 13, 0 } }, /* carrara-massa */
    { .label = {  40705, 12, 0 } }, /* carraramassa */
    { .label = { 119102,  7, 0 } }, /* caserta */
    { .label = { 119129,  7, 0 } }, /* catania */
    { .label = {  80593,  9, 0 } }, /* catanzaro */
    { .label = {     57,  2, 0 } }, /* cb */
    { .label = {     21,  2, 0 } }, /* ce */
    { .label = {  40750, 12, 0 } }, /* cesena-forli */
    { .label = {   6276, 19, 0 } }, /* xn--cesena-forl-mcb */
    { .label = {  52300, 11, 0 } }, /* cesenaforli */
    { .label = {   8470, 18, 0 } }, /* xn--cesenaforl-i8a */
    { .label = {    190,  2, 0 } }, /* ch */
    { .label = { 139699,  6, 0 } }, /* chieti */
    { .label = {    471,  2, 0 } }, /* ci */
    { .label = {   2620,  2, 0 } }, /* cl */
    { .label = {   6811,  2, 0 } }, /* cn */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = { 142497,  4, 0 } }, /* como */
    { .label = { 119155,  7, 0 } }, /* cosenza */
    { .label = {   1284,  2, 0 } }, /* cr */
    { .label = { 119186,  7, 0 } }, /* cremona */
    { .label = { 119215,  7, 0 } }, /* crotone */
    { .label = {    644,  2, 0 } }, /* cs */
    { .label = {   1982,  2, 0 } }, /* ct */
    { .label = { 155692,  5, 0 } }, /* cuneo */
    { .label = {   3760,  2, 0 } }, /* cz */
    { .label = {  25372, 14, 0 } }, /* dell-ogliastra */
    { .label = {  32535, 13, 0 } }, /* dellogliastra */
    { .label = {    226,  2, 0 } }, /* en */
    { .label = {   2783,  4, 0 } }, /* enna */
    { .label = {   6438,  2, 0 } }, /* fc */
    { .label = {    467,  2, 0 } }, /* fe */
    { .label = {  54873,  5, 0 } }, /* fermo */
    { .label = { 119244,  7, 0 } }, /* ferrara */
    { .label = {    331,  2, 0 } }, /* fg */
    { .label = {    391,  2, 0 } }, /* fi */
    { .label = { 119272,  7, 0 } }, /* firenze */
    { .label = {  97808,  8, 0 } }, /* florence */
    { .label = {   1659,  2, 0 } }, /* fm */
    { .label = { 139725,  6, 0 } }, /* foggia */
    { .label = {  40802, 12, 0 } }, /* forli-cesena */
    { .label = {   6365, 19, 0 } }, /* xn--forl-cesena-fcb */
    { .label = {  52347, 11, 0 } }, /* forlicesena */
    { .label = {   8554, 18, 0 } }, /* xn--forlcesena-c8a */
    { .label = {    298,  2, 0 } }, /* fr */
    { .label = {  80630,  9, 0 } }, /* frosinone */
    { .label = {    267,  2, 0 } }, /* ge */
    { .label = { 155714,  5, 0 } }, /* genoa */
    { .label = { 139752,  6, 0 } }, /* genova */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = { 119305,  7, 0 } }, /* gorizia */
    { .label = {   4505,  2, 0 } }, /* gr */
    { .label = {  97844,  8, 0 } }, /* grosseto */
    { .label = {  10974, 17, 0 } }, /* iglesias-carbonia */
    { .label = {  14341, 16, 0 } }, /* iglesiascarbonia */
    { .label = {   1464,  2, 0 } }, /* im */
    { .label = { 119336,  7, 0 } }, /* imperia */
    { .label = {    260,  2, 0 } }, /* is */
    { .label = { 119366,  7, 0 } }, /* isernia */
    { .label = {   3651,  2, 0 } }, /* kr */
    { .label = {  80668,  9, 0 } }, /* la-spezia */
    { .label = { 119393,  7, 0 } }, /* laquila */
    { .label = {  97877,  8, 0 } }, /* laspezia */
    { .label = { 139778,  6, 0 } }, /* latina */
    { .label = {    101,  2, 0 } }, /* lc */
    { .label = {     97,  2, 0 } }, /* le */
    { .label = { 155734,  5, 0 } }, /* lecce */
    { .label = {  91760,  5, 0 } }, /* lecco */
    { .label = {    360,  2, 0 } }, /* li */
    { .label = { 119426,  7, 0 } }, /* livorno */
    { .label = {   2308,  2, 0 } }, /* lo */
    { .label = { 109819,  4, 0 } }, /* lodi */
    { .label = {    695,  2, 0 } }, /* lt */
    { .label = {   3643,  2, 0 } }, /* lu */
    { .label = { 155757,  5, 0 } }, /* lucca */
    { .label = {  97913,  8, 0 } }, /* macerata */
    { .label = { 119457,  7, 0 } }, /* mantova */
    { .label = {  32590, 13, 0 } }, /* massa-carrara */
    { .label = {  40854, 12, 0 } }, /* massacarrara */
    { .label = { 139801,  6, 0 } }, /* matera */
    { .label = {   1523,  2, 0 } }, /* mb */
    { .label = {   2717,  2, 0 } }, /* mc */
    { .label = {    591,  2, 0 } }, /* me */
    { .label = {  18762, 15, 0 } }, /* medio-campidano */
    { .label = {  25432, 14, 0 } }, /* mediocampidano */
    { .label = { 119486,  7, 0 } }, /* messina */
    { .label = {    290,  2, 0 } }, /* mi */
    { .label = { 139824,  5, 0 } }, /* milan */
    { .label = { 139824,  6, 0 } }, /* milano */
    { .label = {    571,  2, 0 } }, /* mn */
    { .label = {   3360,  2, 0 } }, /* mo */
    { .label = { 139849,  6, 0 } }, /* modena */
    { .label = {  32640, 13, 0 } }, /* monza-brianza */
    { .label = {   3360, 21, 0 } }, /* monza-e-della-brianza */
    { .label = {   3360,  5, 0 } }, /* monza */
    { .label = {  40899, 12, 0 } }, /* monzabrianza */
    { .label = {  32699, 13, 0 } }, /* monzaebrianza */
    { .label = {   8639, 18, 0 } }, /* monzaedellabrianza */
    { .label = {    126,  2, 0 } }, /* ms */
    { .label = {   2788,  2, 0 } }, /* mt */
    { .label = {     87,  2, 0 } }, /* na */
    { .label = { 139874,  6, 0 } }, /* naples */
    { .label = {  43346,  6, 0 } }, /* napoli */
    { .label = {    162,  2, 0 } }, /* no */
    { .label = { 139900,  6, 0 } }, /* novara */
    { .label = {    241,  2, 0 } }, /* nu */
    { .label = { 155780,  5, 0 } }, /* nuoro */
    { .label = {   1288,  2, 0 } }, /* og */
    { .label = {  25396,  9, 0 } }, /* ogliastra */
    { .label = {  40953, 12, 0 } }, /* olbia-tempio */
    { .label = {  52394, 11, 0 } }, /* olbiatempio */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {  97944,  8, 0 } }, /* oristano */
    { .label = {    636,  2, 0 } }, /* ot */
    { .label = {    136,  2, 0 } }, /* pa */
    { .label = { 139924,  6, 0 } }, /* padova */
    { .label = { 155801,  5, 0 } }, /* padua */
    { .label = { 119514,  7, 0 } }, /* palermo */
    { .label = { 155823,  5, 0 } }, /* parma */
    { .label = { 155844,  5, 0 } }, /* pavia */
    { .label = {  13487,  2, 0 } }, /* pc */
    { .label = {  18699,  2, 0 } }, /* pd */
    { .label = {    552,  2, 0 } }, /* pe */
    { .label = { 119545,  7, 0 } }, /* perugia */
    { .label = {  32757, 13, 0 } }, /* pesaro-urbino */
    { .label = {  41007, 12, 0 } }, /* pesarourbino */
    { .label = { 119576,  7, 0 } }, /* pescara */
    { .label = {  25981,  2, 0 } }, /* pg */
    { .label = {    494,  2, 0 } }, /* pi */
    { .label = {  97975,  8, 0 } }, /* piacenza */
    { .label = { 165689,  4, 0 } }, /* pisa */
    { .label = { 119605,  7, 0 } }, /* pistoia */
    { .label = {    675,  2, 0 } }, /* pn */
    { .label = {    324,  2, 0 } }, /* po */
    { .label = {  80709,  9, 0 } }, /* pordenone */
    { .label = { 119634,  7, 0 } }, /* potenza */
    { .label = {   1461,  2, 0 } }, /* pr */
    { .label = { 155866,  5, 0 } }, /* prato */
    { .label = {   6812,  2, 0 } }, /* pt */
    { .label = {     58,  2, 0 } }, /* pu */
    { .label = {  22281,  2, 0 } }, /* pv */
    { .label = { 123862,  2, 0 } }, /* pz */
    { .label = {     70,  2, 0 } }, /* ra */
    { .label = { 139951,  6, 0 } }, /* ragusa */
    { .label = { 119666,  7, 0 } }, /* ravenna */
    { .label = {    440,  2, 0 } }, /* rc */
    { .label = {     55,  2, 0 } }, /* re */
    { .label = {  18828, 15, 0 } }, /* reggio-calabria */
    { .label = {  32814, 13, 0 } }, /* reggio-emilia */
    { .label = {  25493, 14, 0 } }, /* reggiocalabria */
    { .label = {  41059, 12, 0 } }, /* reggioemilia */
    { .label = {    213,  2, 0 } }, /* rg */
    { .label = {    157,  2, 0 } }, /* ri */
    { .label = { 155887,  5, 0 } }, /* rieti */
    { .label = { 139975,  6, 0 } }, /* rimini */
    { .label = {   1377,  2, 0 } }, /* rm */
    { .label = {   1380,  2, 0 } }, /* rn */
    { .label = {    524,  2, 0 } }, /* ro */
    { .label = {  22919,  4, 0 } }, /* roma */
    { .label = {  79855,  4, 0 } }, /* rome */
    { .label = { 140000,  6, 0 } }, /* rovigo */
    { .label = {    355,  2, 0 } }, /* sa */
    { .label = { 119694,  7, 0 } }, /* salerno */
    { .label = { 119722,  7, 0 } }, /* sassari */
    { .label = { 140027,  6, 0 } }, /* savona */
    { .label = {    699,  2, 0 } }, /* si */
    { .label = { 155907,  5, 0 } }, /* siena */
    { .label = {  98011,  8, 0 } }, /* siracusa */
    { .label = {    131,  2, 0 } }, /* so */
    { .label = { 119748,  7, 0 } }, /* sondrio */
    { .label = {   3969,  2, 0 } }, /* sp */
    { .label = {    153,  2, 0 } }, /* sr */
    { .label = {      2,  2, 0 } }, /* ss */
    { .label = {   8198,  9, 0 } }, /* suedtirol */
    { .label = {  18892, 15, 0 } }, /* xn--sdtirol-n2a */
    { .label = {    743,  2, 0 } }, /* sv */
    { .label = {     20,  2, 0 } }, /* ta */
    { .label = { 119777,  7, 0 } }, /* taranto */
    { .label = {     89,  2, 0 } }, /* te */
    { .label = {  41110, 12, 0 } }, /* tempio-olbia */
    { .label = {  52443, 11, 0 } }, /* tempioolbia */
    { .label = { 140051,  6, 0 } }, /* teramo */
    { .label = { 155926,  5, 0 } }, /* terni */
    { .label = {    700,  2, 0 } }, /* tn */
    { .label = {   1538,  2, 0 } }, /* to */
    { .label = { 140075,  6, 0 } }, /* torino */
    { .label = {    132,  2, 0 } }, /* tp */
    { .label = {    465,  2, 0 } }, /* tr */
    { .label = {   3455, 21, 0 } }, /* trani-andria-barletta */
    { .label = {   3540, 21, 0 } }, /* trani-barletta-andria */
    { .label = {   6455, 19, 0 } }, /* traniandriabarletta */
    { .label = {   6530, 19, 0 } }, /* tranibarlettaandria */
    { .label = { 119803,  7, 0 } }, /* trapani */
    { .label = { 140099,  6, 0 } }, /* trento */
    { .label = { 119831,  7, 0 } }, /* treviso */
    { .label = { 119861,  7, 0 } }, /* trieste */
    { .label = {    338,  2, 0 } }, /* ts */
    { .label = { 155946,  5, 0 } }, /* turin */
    { .label = {   9431,  2, 0 } }, /* tv */
    { .label = {   1411,  2, 0 } }, /* ud */
    { .label = { 155967,  5, 0 } }, /* udine */
    { .label = {  32870, 13, 0 } }, /* urbino-pesaro */
    { .label = {  41164, 12, 0 } }, /* urbinopesaro */
    { .label = {     54,  2, 0 } }, /* va */
    { .label = { 140123,  6, 0 } }, /* varese */
    { .label = {   1663,  2, 0 } }, /* vb */
    { .label = {  16908,  2, 0 } }, /* vc */
    { .label = {   1367,  2, 0 } }, /* ve */
    { .label = {   2842,  7, 0 } }, /* venezia */
    { .label = { 140148,  6, 0 } }, /* venice */
    { .label = {  98043,  8, 0 } }, /* verbania */
    { .label = {  98077,  8, 0 } }, /* vercelli */
    { .label = { 140175,  6, 0 } }, /* verona */
    { .label = {    569,  2, 0 } }, /* vi */
    { .label = {  32927, 13, 0 } }, /* vibo-valentia */
    { .label = {  41216, 12, 0 } }, /* vibovalentia */
    { .label = { 119889,  7, 0 } }, /* vicenza */
    { .label = { 119922,  7, 0 } }, /* viterbo */
    { .label = {   2710,  2, 0 } }, /* vr */
    { .label = {   1379,  2, 0 } }, /* vs */
    { .label = {      8,  2, 0 } }, /* vt */
    { .label = {   9514,  2, 0 } }, /* vv */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = { 168731,  4, 0 } }, /* 16-b */
    { .label = { 168759,  4, 0 } }, /* 32-b */
    { .label = { 168786,  4, 0 } }, /* 64-b */

    /* entries 3992 to 3994 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entry 3995 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3996 to 4003 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   6667,  3, 0 } }, /* sch */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  29414,  4, 0 } }, /* name */

    /* entries 4004 to 4168 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3989,  2, 0 } }, /* ad */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   3988,  2, 0 } }, /* ed */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {   4505,  2, 0 } }, /* gr */
    { .label = {   2037,  2, 0 } }, /* lg */
    { .label = {     40,  2, 0 } }, /* ne */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {  26093,  5, 1 } }, { .child = { 4169, 52 } }, /* aichi */
    { .label = {  25976,  5, 1 } }, { .child = { 4221, 28 } }, /* akita */
    { .label = { 140200,  6, 1 } }, { .child = { 4249, 22 } }, /* aomori */
    { .label = {  68220,  5, 1 } }, { .child = { 4271, 58 } }, /* chiba */
    { .label = { 142587,  5, 1 } }, { .child = { 4329, 22 } }, /* ehime */
    { .label = { 155989,  5, 1 } }, { .child = { 4351, 15 } }, /* fukui */
    { .label = { 119954,  7, 1 } }, { .child = { 4366, 63 } }, /* fukuoka */
    { .label = {  33795,  9, 1 } }, { .child = { 4429, 51 } }, /* fukushima */
    { .label = {  81384,  4, 1 } }, { .child = { 4480, 38 } }, /* gifu */
    { .label = { 156014,  5, 1 } }, { .child = { 4518, 36 } }, /* gunma */
    { .label = {  14504,  9, 1 } }, { .child = { 4554, 25 } }, /* hiroshima */
    { .label = {  98114,  8, 1 } }, { .child = { 4579, 142 } }, /* hokkaido */
    { .label = { 156036,  5, 1 } }, { .child = { 4721, 46 } }, /* hyogo */
    { .label = { 119987,  7, 1 } }, { .child = { 4767, 51 } }, /* ibaraki */
    { .label = {  86147,  8, 1 } }, { .child = { 4818, 19 } }, /* ishikawa */
    { .label = {  20256,  5, 1 } }, { .child = { 4837, 34 } }, /* iwate */
    { .label = {  33588,  6, 1 } }, { .child = { 4871, 15 } }, /* kagawa */
    { .label = {  80748,  9, 1 } }, { .child = { 4886, 20 } }, /* kagoshima */
    { .label = {  98149,  8, 1 } }, { .child = { 4906, 30 } }, /* kanagawa */
    { .label = { 156060,  5, 1 } }, { .child = { 4936, 31 } }, /* kochi */
    { .label = {  98181,  8, 1 } }, { .child = { 4967, 23 } }, /* kumamoto */
    { .label = { 156083,  5, 1 } }, { .child = { 4990, 31 } }, /* kyoto */
    { .label = {   3787,  3, 1 } }, { .child = { 5021, 30 } }, /* mie */
    { .label = { 140224,  6, 1 } }, { .child = { 5051, 32 } }, /* miyagi */
    { .label = {  98216,  8, 1 } }, { .child = { 5083, 27 } }, /* miyazaki */
    { .label = {  33923,  6, 1 } }, { .child = { 5110, 75 } }, /* nagano */
    { .label = {  98253,  8, 1 } }, { .child = { 5185, 22 } }, /* nagasaki */
    { .label = {   8120,  4, 1 } }, { .child = { 5207, 38 } }, /* nara */
    { .label = { 120016,  7, 1 } }, { .child = { 5245, 34 } }, /* niigata */
    { .label = {  83519,  4, 1 } }, { .child = { 5279, 19 } }, /* oita */
    { .label = { 105821,  7, 1 } }, { .child = { 5298, 26 } }, /* okayama */
    { .label = { 120043,  7, 1 } }, { .child = { 5324, 42 } }, /* okinawa */
    { .label = {  42379,  5, 1 } }, { .child = { 5366, 50 } }, /* osaka */
    { .label = {  68954,  4, 1 } }, { .child = { 5416, 26 } }, /* saga */
    { .label = { 120072,  7, 1 } }, { .child = { 5442, 69 } }, /* saitama */
    { .label = {  25831,  5, 1 } }, { .child = { 5511, 23 } }, /* shiga */
    { .label = { 120098,  7, 1 } }, { .child = { 5534, 23 } }, /* shimane */
    { .label = {  98284,  8, 1 } }, { .child = { 5557, 36 } }, /* shizuoka */
    { .label = { 120127,  7, 1 } }, { .child = { 5593, 31 } }, /* tochigi */
    { .label = {  80786,  9, 1 } }, { .child = { 5624, 17 } }, /* tokushima */
    { .label = { 156106,  5, 1 } }, { .child = { 5641, 57 } }, /* tokyo */
    { .label = { 120158,  7, 1 } }, { .child = { 5698, 13 } }, /* tottori */
    { .label = {  14656,  6, 1 } }, { .child = { 5711, 24 } }, /* toyama */
    { .label = {  98321,  8, 1 } }, { .child = { 5735, 29 } }, /* wakayama */
    { .label = {  98355,  8, 1 } }, { .child = { 5764, 34 } }, /* yamagata */
    { .label = {  80825,  9, 1 } }, { .child = { 5798, 16 } }, /* yamaguchi */
    { .label = {  80866,  9, 1 } }, { .child = { 5814, 28 } }, /* yamanashi */
    { .label = {  80903,  9, 0 } }, /* xn--4pvxs */
    { .label = {  52492, 11, 0 } }, /* xn--vgu402c */
    { .label = {  67041, 10, 0 } }, /* xn--c3s14m */
    { .label = {  52558, 11, 0 } }, /* xn--f6qx53a */
    { .label = {  67100, 10, 0 } }, /* xn--8pvr4u */
    { .label = {  52627, 11, 0 } }, /* xn--uist22h */
    { .label = {  25552, 14, 0 } }, /* xn--djrs72d6uy */
    { .label = {  52685, 11, 0 } }, /* xn--mkru45i */
    { .label = {  32985, 13, 0 } }, /* xn--0trq7p7nn */
    { .label = {  52746, 11, 0 } }, /* xn--8ltr62k */
    { .label = {  52810, 11, 0 } }, /* xn--2m4a15e */
    { .label = {  67159, 10, 0 } }, /* xn--efvn9s */
    { .label = {  52876, 11, 0 } }, /* xn--32vp30h */
    { .label = {  52945, 11, 0 } }, /* xn--4it797k */
    { .label = {  53015, 11, 0 } }, /* xn--1lqs71d */
    { .label = {  53082, 11, 0 } }, /* xn--5rtp49c */
    { .label = {  53149, 11, 0 } }, /* xn--5js045d */
    { .label = {  53220, 11, 0 } }, /* xn--ehqz56n */
    { .label = {  53286, 11, 0 } }, /* xn--1lqs03n */
    { .label = {  53351, 11, 0 } }, /* xn--qqqt11m */
    { .label = {  67213, 10, 0 } }, /* xn--kbrq7o */
    { .label = {  53420, 11, 0 } }, /* xn--pssu33l */
    { .label = {  53480, 11, 0 } }, /* xn--ntsq17g */
    { .label = {  67269, 10, 0 } }, /* xn--uisz3g */
    { .label = {  67322, 10, 0 } }, /* xn--6btw5a */
    { .label = {  80954,  9, 0 } }, /* xn--1ctwo */
    { .label = {  67379, 10, 0 } }, /* xn--6orx2r */
    { .label = {  67434, 10, 0 } }, /* xn--rht61e */
    { .label = {  67488, 10, 0 } }, /* xn--rht27z */
    { .label = {  67545, 10, 0 } }, /* xn--djty4k */
    { .label = {  53542, 11, 0 } }, /* xn--nit225k */
    { .label = {  81001,  9, 0 } }, /* xn--rht3d */
    { .label = {  67601, 10, 0 } }, /* xn--klty5x */
    { .label = {  67656, 10, 0 } }, /* xn--kltx9a */
    { .label = {  67709, 10, 0 } }, /* xn--kltp7d */
    { .label = {  53604, 11, 0 } }, /* xn--uuwu58a */
    { .label = {  53666, 11, 0 } }, /* xn--zbx025d */
    { .label = {  25634, 14, 0 } }, /* xn--ntso0iqx3a */
    { .label = {  53735, 11, 0 } }, /* xn--elqq16h */
    { .label = {  53802, 11, 0 } }, /* xn--4it168d */
    { .label = {  53870, 11, 0 } }, /* xn--klt787d */
    { .label = {  67763, 10, 0 } }, /* xn--rny31h */
    { .label = {  41269, 12, 0 } }, /* xn--7t0a264c */
    { .label = {  53936, 11, 0 } }, /* xn--5rtq34k */
    { .label = {  54003, 11, 0 } }, /* xn--k7yn95e */
    { .label = {  54070, 11, 0 } }, /* xn--tor131o */
    { .label = {  25707, 14, 0 } }, /* xn--d5qv7z876c */
    { .label = {  98387,  8, 1 } }, { .child = { 5842, 2 } }, /* kawasaki */
    { .label = {  67818, 10, 1 } }, { .child = { 5846, 2 } }, /* kitakyushu */
    { .label = { 165727,  4, 1 } }, { .child = { 5850, 2 } }, /* kobe */
    { .label = { 140251,  6, 1 } }, { .child = { 5854, 2 } }, /* nagoya */
    { .label = { 120186,  7, 1 } }, { .child = { 5858, 2 } }, /* sapporo */
    { .label = {  33641,  6, 1 } }, { .child = { 5862, 2 } }, /* sendai */
    { .label = {  98420,  8, 1 } }, { .child = { 5866, 2 } }, /* yokohama */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 4169 to 4220 */
    { .label = { 156129,  5, 0 } }, /* aisai */
    { .label = {  14670,  3, 0 } }, /* ama */
    { .label = {  88467,  4, 0 } }, /* anjo */
    { .label = { 156147,  5, 0 } }, /* asuke */
    { .label = { 140276,  6, 0 } }, /* chiryu */
    { .label = { 100195,  5, 0 } }, /* chita */
    { .label = { 165746,  4, 0 } }, /* fuso */
    { .label = {  98455,  8, 0 } }, /* gamagori */
    { .label = { 156168,  5, 0 } }, /* handa */
    { .label = { 165765,  4, 0 } }, /* hazu */
    { .label = { 120217,  7, 0 } }, /* hekinan */
    { .label = {  67864, 10, 0 } }, /* higashiura */
    { .label = {  67906, 10, 0 } }, /* ichinomiya */
    { .label = { 120246,  7, 0 } }, /* inazawa */
    { .label = { 120276,  7, 0 } }, /* inuyama */
    { .label = { 120306,  7, 0 } }, /* isshiki */
    { .label = { 120336,  7, 0 } }, /* iwakura */
    { .label = { 156188,  5, 0 } }, /* kanie */
    { .label = { 140305,  6, 0 } }, /* kariya */
    { .label = { 120366,  7, 0 } }, /* kasugai */
    { .label = {  76668,  4, 0 } }, /* kira */
    { .label = { 140330,  6, 0 } }, /* kiyosu */
    { .label = { 140358,  6, 0 } }, /* komaki */
    { .label = { 156208,  5, 0 } }, /* konan */
    { .label = { 100916,  4, 0 } }, /* kota */
    { .label = { 104233,  6, 0 } }, /* mihama */
    { .label = {  14581,  7, 0 } }, /* miyoshi */
    { .label = {  54512,  6, 0 } }, /* nishio */
    { .label = { 120395,  7, 0 } }, /* nisshin */
    { .label = {  13227,  3, 0 } }, /* obu */
    { .label = { 140384,  6, 0 } }, /* oguchi */
    { .label = { 156228,  5, 0 } }, /* oharu */
    { .label = { 120424,  7, 0 } }, /* okazaki */
    { .label = {  67950, 10, 0 } }, /* owariasahi */
    { .label = {  97861,  4, 0 } }, /* seto */
    { .label = {  42713,  8, 0 } }, /* shikatsu */
    { .label = {  81047,  9, 0 } }, /* shinshiro */
    { .label = { 120455,  7, 0 } }, /* shitara */
    { .label = {  41419,  6, 0 } }, /* tahara */
    { .label = {  98488,  8, 0 } }, /* takahama */
    { .label = {  81085,  9, 0 } }, /* tobishima */
    { .label = { 165785,  4, 0 } }, /* toei */
    { .label = { 165801,  4, 0 } }, /* togo */
    { .label = {  54330,  5, 0 } }, /* tokai */
    { .label = {  98519,  8, 0 } }, /* tokoname */
    { .label = { 120482,  7, 0 } }, /* toyoake */
    { .label = {  81124,  9, 0 } }, /* toyohashi */
    { .label = {  98552,  8, 0 } }, /* toyokawa */
    { .label = {  80722,  6, 0 } }, /* toyone */
    { .label = { 140412,  6, 0 } }, /* toyota */
    { .label = {  11083,  8, 0 } }, /* tsushima */
    { .label = { 140437,  6, 0 } }, /* yatomi */

    /* entries 4221 to 4248 */
    { .label = {  25976,  5, 0 } }, /* akita */
    { .label = { 140463,  6, 0 } }, /* daisen */
    { .label = {  98587,  8, 0 } }, /* fujisato */
    { .label = { 140487,  6, 0 } }, /* gojome */
    { .label = {  54130, 11, 0 } }, /* hachirogata */
    { .label = { 140516,  6, 0 } }, /* happou */
    { .label = {  33061, 13, 0 } }, /* higashinaruse */
    { .label = {  81294,  5, 0 } }, /* honjo */
    { .label = { 140545,  6, 0 } }, /* honjyo */
    { .label = {  19434,  5, 0 } }, /* ikawa */
    { .label = {  81163,  9, 0 } }, /* kamikoani */
    { .label = { 120512,  7, 0 } }, /* kamioka */
    { .label = {  98624,  8, 0 } }, /* katagami */
    { .label = { 140575,  6, 0 } }, /* kazuno */
    { .label = {  81200,  9, 0 } }, /* kitaakita */
    { .label = { 140603,  6, 0 } }, /* kosaka */
    { .label = { 156249,  5, 0 } }, /* kyowa */
    { .label = {  26131,  6, 0 } }, /* misato */
    { .label = {  68930,  6, 0 } }, /* mitane */
    { .label = {  81235,  9, 0 } }, /* moriyoshi */
    { .label = { 140627,  6, 0 } }, /* nikaho */
    { .label = { 120541,  7, 0 } }, /* noshiro */
    { .label = {  83111,  5, 0 } }, /* odate */
    { .label = {  13180,  3, 0 } }, /* oga */
    { .label = {  54156,  5, 0 } }, /* ogata */
    { .label = { 120570,  7, 0 } }, /* semboku */
    { .label = { 140652,  6, 0 } }, /* yokote */
    { .label = {  81275,  9, 0 } }, /* yurihonjo */

    /* entries 4249 to 4270 */
    { .label = { 140200,  6, 0 } }, /* aomori */
    { .label = { 140679,  6, 0 } }, /* gonohe */
    { .label = {  81318,  9, 0 } }, /* hachinohe */
    { .label = {  81142,  9, 0 } }, /* hashikami */
    { .label = { 120603,  7, 0 } }, /* hiranai */
    { .label = {  98656,  8, 0 } }, /* hirosaki */
    { .label = {  81357,  9, 0 } }, /* itayanagi */
    { .label = {  98689,  8, 0 } }, /* kuroishi */
    { .label = { 140705,  6, 0 } }, /* misawa */
    { .label = {  81433,  5, 0 } }, /* mutsu */
    { .label = {  67990, 10, 0 } }, /* nakadomari */
    { .label = { 140730,  6, 0 } }, /* noheji */
    { .label = { 140758,  6, 0 } }, /* oirase */
    { .label = { 156273,  5, 0 } }, /* owani */
    { .label = {  98724,  8, 0 } }, /* rokunohe */
    { .label = { 120630,  7, 0 } }, /* sannohe */
    { .label = {  68030, 10, 0 } }, /* shichinohe */
    { .label = { 140781,  6, 0 } }, /* shingo */
    { .label = { 156294,  5, 0 } }, /* takko */
    { .label = { 140807,  6, 0 } }, /* towada */
    { .label = { 120658,  7, 0 } }, /* tsugaru */
    { .label = { 120688,  7, 0 } }, /* tsuruta */

    /* entries 4271 to 4328 */
    { .label = { 156315,  5, 0 } }, /* abiko */
    { .label = {  67971,  5, 0 } }, /* asahi */
    { .label = { 140832,  6, 0 } }, /* chonan */
    { .label = { 140857,  6, 0 } }, /* chosei */
    { .label = { 140883,  6, 0 } }, /* choshi */
    { .label = {  54207,  4, 0 } }, /* chuo */
    { .label = {  81393,  9, 0 } }, /* funabashi */
    { .label = { 140910,  6, 0 } }, /* futtsu */
    { .label = {  68074, 10, 0 } }, /* hanamigawa */
    { .label = {  98759,  8, 0 } }, /* ichihara */
    { .label = {  26096,  8, 0 } }, /* ichikawa */
    { .label = {  67906, 10, 0 } }, /* ichinomiya */
    { .label = { 156337,  5, 0 } }, /* inzai */
    { .label = {  14568,  5, 0 } }, /* isumi */
    { .label = {  98792,  8, 0 } }, /* kamagaya */
    { .label = {  98825,  8, 0 } }, /* kamogawa */
    { .label = {  55186,  7, 0 } }, /* kashiwa */
    { .label = { 103425,  6, 0 } }, /* katori */
    { .label = {  34080,  8, 0 } }, /* katsuura */
    { .label = { 120717,  7, 0 } }, /* kimitsu */
    { .label = {  98859,  8, 0 } }, /* kisarazu */
    { .label = { 140938,  6, 0 } }, /* kozaki */
    { .label = {  98894,  8, 0 } }, /* kujukuri */
    { .label = { 140966,  6, 0 } }, /* kyonan */
    { .label = { 120748,  7, 0 } }, /* matsudo */
    { .label = { 140992,  6, 0 } }, /* midori */
    { .label = { 104233,  6, 0 } }, /* mihama */
    { .label = {  68115, 10, 0 } }, /* minamiboso */
    { .label = { 141018,  6, 0 } }, /* mobara */
    { .label = {  81433,  9, 0 } }, /* mutsuzawa */
    { .label = { 141043,  6, 0 } }, /* nagara */
    { .label = {  68158, 10, 0 } }, /* nagareyama */
    { .label = {  81475,  9, 0 } }, /* narashino */
    { .label = { 141065,  6, 0 } }, /* narita */
    { .label = {  79281,  4, 0 } }, /* noda */
    { .label = {  33115, 13, 0 } }, /* oamishirasato */
    { .label = { 120778,  7, 0 } }, /* omigawa */
    { .label = { 141087,  6, 0 } }, /* onjuku */
    { .label = { 101003,  5, 0 } }, /* otaki */
    { .label = { 156359,  5, 0 } }, /* sakae */
    { .label = {  68703,  6, 0 } }, /* sakura */
    { .label = {  81510,  9, 0 } }, /* shimofusa */
    { .label = { 120808,  7, 0 } }, /* shirako */
    { .label = {  83701,  6, 0 } }, /* shiroi */
    { .label = { 141117,  6, 0 } }, /* shisui */
    { .label = {  81550,  9, 0 } }, /* sodegaura */
    { .label = { 102754,  4, 0 } }, /* sosa */
    { .label = {  37407,  4, 0 } }, /* tako */
    { .label = {  98934,  8, 0 } }, /* tateyama */
    { .label = { 141143,  6, 0 } }, /* togane */
    { .label = {  98966,  8, 0 } }, /* tohnosho */
    { .label = {  99000,  8, 0 } }, /* tomisato */
    { .label = { 120837,  7, 0 } }, /* urayasu */
    { .label = {  81587,  9, 0 } }, /* yachimata */
    { .label = { 120867,  7, 0 } }, /* yachiyo */
    { .label = {  68198, 10, 0 } }, /* yokaichiba */
    { .label = {  18962, 15, 0 } }, /* yokoshibahikari */
    { .label = {  68243, 10, 0 } }, /* yotsukaido */

    /* entries 4329 to 4350 */
    { .label = { 145140,  5, 0 } }, /* ainan */
    { .label = { 141498,  5, 0 } }, /* honai */
    { .label = {  85472,  5, 0 } }, /* ikata */
    { .label = { 120900,  7, 0 } }, /* imabari */
    { .label = {  14586,  3, 0 } }, /* iyo */
    { .label = {  33358,  8, 0 } }, /* kamijima */
    { .label = { 141167,  6, 0 } }, /* kihoku */
    { .label = {  81625,  9, 0 } }, /* kumakogen */
    { .label = { 141195,  6, 0 } }, /* masaki */
    { .label = { 120929,  7, 0 } }, /* matsuno */
    { .label = {  14643,  9, 0 } }, /* matsuyama */
    { .label = {  99032,  8, 0 } }, /* namikata */
    { .label = { 120958,  7, 0 } }, /* niihama */
    { .label = {  70119,  3, 0 } }, /* ozu */
    { .label = { 156378,  5, 0 } }, /* saijo */
    { .label = { 156400,  5, 0 } }, /* seiyo */
    { .label = {  54175, 11, 0 } }, /* shikokuchuo */
    { .label = {  20178,  4, 0 } }, /* tobe */
    { .label = {  17104,  4, 0 } }, /* toon */
    { .label = {  19460,  6, 0 } }, /* uchiko */
    { .label = { 120986,  7, 0 } }, /* uwajima */
    { .label = {  68287, 10, 0 } }, /* yawatahama */

    /* entries 4351 to 4365 */
    { .label = {  33191,  7, 0 } }, /* echizen */
    { .label = { 121019,  7, 0 } }, /* eiheiji */
    { .label = { 155989,  5, 0 } }, /* fukui */
    { .label = { 156422,  5, 0 } }, /* ikeda */
    { .label = {  81665,  9, 0 } }, /* katsuyama */
    { .label = { 104233,  6, 0 } }, /* mihama */
    { .label = {  33166, 13, 0 } }, /* minamiechizen */
    { .label = { 156443,  5, 0 } }, /* obama */
    { .label = {     69,  3, 0 } }, /* ohi */
    { .label = {   1994,  3, 0 } }, /* ono */
    { .label = { 156464,  5, 0 } }, /* sabae */
    { .label = {  26081,  5, 0 } }, /* sakai */
    { .label = {  98488,  8, 0 } }, /* takahama */
    { .label = {  42449,  7, 0 } }, /* tsuruga */
    { .label = { 141219,  6, 0 } }, /* wakasa */

    /* entries 4366 to 4428 */
    { .label = {  34018,  6, 0 } }, /* ashiya */
    { .label = { 156484,  5, 0 } }, /* buzen */
    { .label = { 121051,  7, 0 } }, /* chikugo */
    { .label = {  83854,  7, 0 } }, /* chikuho */
    { .label = { 121084,  7, 0 } }, /* chikujo */
    { .label = {  68328, 10, 0 } }, /* chikushino */
    { .label = {  99063,  8, 0 } }, /* chikuzen */
    { .label = {  54207,  4, 0 } }, /* chuo */
    { .label = { 121119,  7, 0 } }, /* dazaifu */
    { .label = {  55087,  7, 0 } }, /* fukuchi */
    { .label = { 141243,  6, 0 } }, /* hakata */
    { .label = {  11045,  7, 0 } }, /* higashi */
    { .label = {  99102,  8, 0 } }, /* hirokawa */
    { .label = {  99136,  8, 0 } }, /* hisayama */
    { .label = { 141266,  6, 0 } }, /* iizuka */
    { .label = {  99169,  8, 0 } }, /* inatsuki */
    { .label = {  99806,  4, 0 } }, /* kaho */
    { .label = { 120366,  6, 0 } }, /* kasuga */
    { .label = { 141294,  6, 0 } }, /* kasuya */
    { .label = { 141320,  6, 0 } }, /* kawara */
    { .label = { 141344,  6, 0 } }, /* keisen */
    { .label = {  73027,  4, 0 } }, /* koga */
    { .label = { 141369,  6, 0 } }, /* kurate */
    { .label = { 141394,  6, 0 } }, /* kurogi */
    { .label = {  33976,  6, 0 } }, /* kurume */
    { .label = {  19090,  6, 0 } }, /* minami */
    { .label = {  69206,  6, 0 } }, /* miyako */
    { .label = {  19106,  6, 0 } }, /* miyama */
    { .label = {  99202,  8, 0 } }, /* miyawaka */
    { .label = {  99237,  8, 0 } }, /* mizumaki */
    { .label = {  99275,  8, 0 } }, /* munakata */
    { .label = {  99307,  8, 0 } }, /* nakagawa */
    { .label = { 141421,  6, 0 } }, /* nakama */
    { .label = {  41897,  5, 0 } }, /* nishi */
    { .label = { 141444,  6, 0 } }, /* nogata */
    { .label = { 156510,  5, 0 } }, /* ogori */
    { .label = { 121152,  7, 0 } }, /* okagaki */
    { .label = {  69832,  5, 0 } }, /* okawa */
    { .label = {  29608,  3, 0 } }, /* oki */
    { .label = { 156531,  5, 0 } }, /* omuta */
    { .label = { 125413,  4, 0 } }, /* onga */
    { .label = {  69229,  5, 0 } }, /* onojo */
    { .label = {  13097,  3, 0 } }, /* oto */
    { .label = { 121181,  7, 0 } }, /* saigawa */
    { .label = {  99339,  8, 0 } }, /* sasaguri */
    { .label = { 141467,  6, 0 } }, /* shingu */
    { .label = {  33224, 13, 0 } }, /* shinyoshitomi */
    { .label = { 141494,  6, 0 } }, /* shonai */
    { .label = { 156552,  5, 0 } }, /* soeda */
    { .label = {   5906,  3, 0 } }, /* sue */
    { .label = {  81703,  9, 0 } }, /* tachiarai */
    { .label = { 102416,  6, 0 } }, /* tagawa */
    { .label = {  33536,  6, 0 } }, /* takata */
    { .label = {  82270,  4, 0 } }, /* toho */
    { .label = { 121209,  7, 0 } }, /* toyotsu */
    { .label = { 141518,  6, 0 } }, /* tsuiki */
    { .label = { 156572,  5, 0 } }, /* ukiha */
    { .label = {  14576,  3, 0 } }, /* umi */
    { .label = { 157386,  4, 0 } }, /* usui */
    { .label = { 141544,  6, 0 } }, /* yamada */
    { .label = {  29412,  4, 0 } }, /* yame */
    { .label = {  99371,  8, 0 } }, /* yanagawa */
    { .label = {  81738,  9, 0 } }, /* yukuhashi */

    /* entries 4429 to 4479 */
    { .label = {  81780,  9, 0 } }, /* aizubange */
    { .label = {  68373, 10, 0 } }, /* aizumisato */
    { .label = {  33281, 13, 0 } }, /* aizuwakamatsu */
    { .label = { 121240,  7, 0 } }, /* asakawa */
    { .label = { 141569,  6, 0 } }, /* bandai */
    { .label = {  30999,  4, 0 } }, /* date */
    { .label = {  33795,  9, 0 } }, /* fukushima */
    { .label = {  99404,  8, 0 } }, /* furudono */
    { .label = { 141594,  6, 0 } }, /* futaba */
    { .label = { 141621,  6, 0 } }, /* hanawa */
    { .label = {  11045,  7, 0 } }, /* higashi */
    { .label = {  86224,  6, 0 } }, /* hirata */
    { .label = { 141645,  6, 0 } }, /* hirono */
    { .label = { 141670,  6, 0 } }, /* iitate */
    { .label = {  68416, 10, 0 } }, /* inawashiro */
    { .label = {  86147,  8, 0 } }, /* ishikawa */
    { .label = {  82952,  5, 0 } }, /* iwaki */
    { .label = {  81821,  9, 0 } }, /* izumizaki */
    { .label = {  68457, 10, 0 } }, /* kagamiishi */
    { .label = {  99441,  8, 0 } }, /* kaneyama */
    { .label = {  99474,  8, 0 } }, /* kawamata */
    { .label = {  99506,  8, 0 } }, /* kitakata */
    { .label = {  41344, 12, 0 } }, /* kitashiobara */
    { .label = { 122542,  5, 0 } }, /* koori */
    { .label = {  25945,  8, 0 } }, /* koriyama */
    { .label = { 141693,  6, 0 } }, /* kunimi */
    { .label = { 141720,  6, 0 } }, /* miharu */
    { .label = { 121267,  7, 0 } }, /* mishima */
    { .label = {  33175,  5, 0 } }, /* namie */
    { .label = { 156594,  5, 0 } }, /* nango */
    { .label = {  81865,  9, 0 } }, /* nishiaizu */
    { .label = { 121297,  7, 0 } }, /* nishigo */
    { .label = { 104610,  5, 0 } }, /* okuma */
    { .label = { 121327,  7, 0 } }, /* omotego */
    { .label = {   1994,  3, 0 } }, /* ono */
    { .label = { 125154,  5, 0 } }, /* otama */
    { .label = {  99537,  8, 0 } }, /* samegawa */
    { .label = { 121357,  7, 0 } }, /* shimogo */
    { .label = {  14437,  9, 0 } }, /* shirakawa */
    { .label = { 156614,  5, 0 } }, /* showa */
    { .label = { 124927,  4, 0 } }, /* soma */
    { .label = {  99570,  8, 0 } }, /* sukagawa */
    { .label = { 121388,  7, 0 } }, /* taishin */
    { .label = {  99604,  8, 0 } }, /* tamakawa */
    { .label = {  99636,  8, 0 } }, /* tanagura */
    { .label = { 156636,  5, 0 } }, /* tenei */
    { .label = { 141746,  6, 0 } }, /* yabuki */
    { .label = {  25920,  6, 0 } }, /* yamato */
    { .label = {  81905,  9, 0 } }, /* yamatsuri */
    { .label = { 121416,  7, 0 } }, /* yanaizu */
    { .label = { 102372,  6, 0 } }, /* yugawa */

    /* entries 4480 to 4517 */
    { .label = { 121448,  7, 0 } }, /* anpachi */
    { .label = {   2007,  3, 0 } }, /* ena */
    { .label = {  81384,  4, 0 } }, /* gifu */
    { .label = { 156656,  5, 0 } }, /* ginan */
    { .label = {  98869,  4, 0 } }, /* godo */
    { .label = { 165818,  4, 0 } }, /* gujo */
    { .label = {  84375,  7, 0 } }, /* hashima */
    { .label = { 121478,  7, 0 } }, /* hichiso */
    { .label = {  55682,  4, 0 } }, /* hida */
    { .label = {  14407, 16, 0 } }, /* higashishirakawa */
    { .label = { 121509,  7, 0 } }, /* ibigawa */
    { .label = { 156422,  5, 0 } }, /* ikeda */
    { .label = {  41393, 12, 0 } }, /* kakamigahara */
    { .label = {  55562,  4, 0 } }, /* kani */
    { .label = {  99667,  8, 0 } }, /* kasahara */
    { .label = {  81943,  9, 0 } }, /* kasamatsu */
    { .label = { 141775,  6, 0 } }, /* kawaue */
    { .label = {  99697,  8, 0 } }, /* kitagata */
    { .label = {  17009,  4, 0 } }, /* mino */
    { .label = {  99728,  8, 0 } }, /* minokamo */
    { .label = { 103892,  6, 0 } }, /* mitake */
    { .label = {  99762,  8, 0 } }, /* mizunami */
    { .label = { 141801,  6, 0 } }, /* motosu */
    { .label = {  54226, 11, 0 } }, /* nakatsugawa */
    { .label = { 142546,  5, 0 } }, /* ogaki */
    { .label = {  99799,  8, 0 } }, /* sakahogi */
    { .label = {  41456,  4, 0 } }, /* seki */
    { .label = {  68499, 10, 0 } }, /* sekigahara */
    { .label = {  14437,  9, 0 } }, /* shirakawa */
    { .label = { 141827,  6, 0 } }, /* tajimi */
    { .label = {  98323,  8, 0 } }, /* takayama */
    { .label = { 156676,  5, 0 } }, /* tarui */
    { .label = {  82097,  4, 0 } }, /* toki */
    { .label = { 141854,  6, 0 } }, /* tomika */
    { .label = {  99832,  8, 0 } }, /* wanouchi */
    { .label = {  98355,  8, 0 } }, /* yamagata */
    { .label = { 141879,  6, 0 } }, /* yaotsu */
    { .label = { 142320,  4, 0 } }, /* yoro */

    /* entries 4518 to 4553 */
    { .label = { 141905,  6, 0 } }, /* annaka */
    { .label = { 121540,  7, 0 } }, /* chiyoda */
    { .label = { 121572,  7, 0 } }, /* fujioka */
    { .label = {  19028, 15, 0 } }, /* higashiagatsuma */
    { .label = { 121606,  7, 0 } }, /* isesaki */
    { .label = { 121634,  7, 0 } }, /* itakura */
    { .label = {  32015,  5, 0 } }, /* kanna */
    { .label = { 156696,  5, 0 } }, /* kanra */
    { .label = {  81979,  9, 0 } }, /* katashina */
    { .label = { 141927,  6, 0 } }, /* kawaba */
    { .label = { 156715,  5, 0 } }, /* kiryu */
    { .label = { 121662,  7, 0 } }, /* kusatsu */
    { .label = {  99868,  8, 0 } }, /* maebashi */
    { .label = { 156739,  5, 0 } }, /* meiwa */
    { .label = { 140992,  6, 0 } }, /* midori */
    { .label = {  99902,  8, 0 } }, /* minakami */
    { .label = {  68539, 10, 0 } }, /* naganohara */
    { .label = {  99935,  8, 0 } }, /* nakanojo */
    { .label = { 121692,  7, 0 } }, /* nanmoku */
    { .label = { 141953,  6, 0 } }, /* numata */
    { .label = {  84711,  6, 0 } }, /* oizumi */
    { .label = {   1542,  3, 0 } }, /* ora */
    { .label = {   6439,  3, 0 } }, /* ota */
    { .label = {  82014,  9, 0 } }, /* shibukawa */
    { .label = {  82055,  9, 0 } }, /* shimonita */
    { .label = { 100972,  6, 0 } }, /* shinto */
    { .label = { 156614,  5, 0 } }, /* showa */
    { .label = {  99969,  8, 0 } }, /* takasaki */
    { .label = {  98323,  8, 0 } }, /* takayama */
    { .label = { 100000,  8, 0 } }, /* tamamura */
    { .label = {  54271, 11, 0 } }, /* tatebayashi */
    { .label = { 121722,  7, 0 } }, /* tomioka */
    { .label = {  82092,  9, 0 } }, /* tsukiyono */
    { .label = { 100032,  8, 0 } }, /* tsumagoi */
    { .label = { 106070,  4, 0 } }, /* ueno */
    { .label = { 100066,  8, 0 } }, /* yoshioka */

    /* entries 4554 to 4578 */
    { .label = {  82132,  9, 0 } }, /* asaminami */
    { .label = { 125316,  5, 0 } }, /* daiwa */
    { .label = { 121751,  7, 0 } }, /* etajima */
    { .label = { 156761,  5, 0 } }, /* fuchu */
    { .label = { 100101,  8, 0 } }, /* fukuyama */
    { .label = {  54317, 11, 0 } }, /* hatsukaichi */
    { .label = {  14474, 16, 0 } }, /* higashihiroshima */
    { .label = { 156787,  5, 0 } }, /* hongo */
    { .label = {  41441, 12, 0 } }, /* jinsekikogen */
    { .label = { 156809,  5, 0 } }, /* kaita */
    { .label = {  28695,  3, 0 } }, /* kui */
    { .label = { 141977,  6, 0 } }, /* kumano */
    { .label = { 165839,  4, 0 } }, /* kure */
    { .label = {  68969,  6, 0 } }, /* mihara */
    { .label = {  14581,  7, 0 } }, /* miyoshi */
    { .label = {  25995,  4, 0 } }, /* naka */
    { .label = { 100139,  8, 0 } }, /* onomichi */
    { .label = {  33338, 13, 0 } }, /* osakikamijima */
    { .label = { 156828,  5, 0 } }, /* otake */
    { .label = {  26081,  4, 0 } }, /* saka */
    { .label = {  35115,  4, 0 } }, /* sera */
    { .label = {  82167,  9, 0 } }, /* seranishi */
    { .label = { 100174,  8, 0 } }, /* shinichi */
    { .label = { 121781,  7, 0 } }, /* shobara */
    { .label = { 100209,  8, 0 } }, /* takehara */

    /* entries 4579 to 4720 */
    { .label = { 100240,  8, 0 } }, /* abashiri */
    { .label = { 121848,  5, 0 } }, /* abira */
    { .label = { 121810,  7, 0 } }, /* aibetsu */
    { .label = { 121840,  7, 0 } }, /* akabira */
    { .label = { 121868,  7, 0 } }, /* akkeshi */
    { .label = {  82203,  9, 0 } }, /* asahikawa */
    { .label = {  82239,  9, 0 } }, /* ashibetsu */
    { .label = { 142003,  6, 0 } }, /* ashoro */
    { .label = { 142027,  6, 0 } }, /* assabu */
    { .label = {  19066,  6, 0 } }, /* atsuma */
    { .label = { 156848,  5, 0 } }, /* bibai */
    { .label = {   5133,  4, 0 } }, /* biei */
    { .label = { 142052,  6, 0 } }, /* bifuka */
    { .label = { 142081,  6, 0 } }, /* bihoro */
    { .label = { 100273,  8, 0 } }, /* biratori */
    { .label = {  54364, 11, 0 } }, /* chippubetsu */
    { .label = { 121898,  7, 0 } }, /* chitose */
    { .label = {  30999,  4, 0 } }, /* date */
    { .label = { 142108,  6, 0 } }, /* ebetsu */
    { .label = { 121928,  7, 0 } }, /* embetsu */
    { .label = { 144573,  5, 0 } }, /* eniwa */
    { .label = { 156871,  5, 0 } }, /* erimo */
    { .label = {   2217,  4, 0 } }, /* esan */
    { .label = { 142135,  6, 0 } }, /* esashi */
    { .label = { 100306,  8, 0 } }, /* fukagawa */
    { .label = {  33795,  9, 0 } }, /* fukushima */
    { .label = {  41671,  6, 0 } }, /* furano */
    { .label = { 100342,  8, 0 } }, /* furubira */
    { .label = { 142159,  6, 0 } }, /* haboro */
    { .label = { 100379,  8, 0 } }, /* hakodate */
    { .label = {  41495, 12, 0 } }, /* hamatonbetsu */
    { .label = { 142185,  6, 0 } }, /* hidaka */
    { .label = {  33394, 13, 0 } }, /* higashikagura */
    { .label = {  54418, 11, 0 } }, /* higashikawa */
    { .label = { 122215,  5, 0 } }, /* hiroo */
    { .label = { 121960,  7, 0 } }, /* hokuryu */
    { .label = { 142210,  6, 0 } }, /* hokuto */
    { .label = { 100412,  8, 0 } }, /* honbetsu */
    { .label = {  82278,  9, 0 } }, /* horokanai */
    { .label = { 100448,  8, 0 } }, /* horonobe */
    { .label = { 156422,  5, 0 } }, /* ikeda */
    { .label = { 121994,  7, 0 } }, /* imakane */
    { .label = { 100483,  8, 0 } }, /* ishikari */
    { .label = {  82314,  9, 0 } }, /* iwamizawa */
    { .label = { 142237,  6, 0 } }, /* iwanai */
    { .label = {  68577, 10, 0 } }, /* kamifurano */
    { .label = { 100516,  8, 0 } }, /* kamikawa */
    { .label = {  54465, 11, 0 } }, /* kamishihoro */
    { .label = {  41546, 12, 0 } }, /* kamisunagawa */
    { .label = { 100550,  8, 0 } }, /* kamoenai */
    { .label = { 142261,  6, 0 } }, /* kayabe */
    { .label = { 100582,  8, 0 } }, /* kembuchi */
    { .label = { 122022,  7, 0 } }, /* kikonai */
    { .label = {  82355,  9, 0 } }, /* kimobetsu */
    { .label = {  33449, 13, 0 } }, /* kitahiroshima */
    { .label = { 142288,  6, 0 } }, /* kitami */
    { .label = { 100621,  8, 0 } }, /* kiyosato */
    { .label = {  82396,  9, 0 } }, /* koshimizu */
    { .label = { 100655,  8, 0 } }, /* kunneppu */
    { .label = { 100694,  8, 0 } }, /* kuriyama */
    { .label = {  41596, 12, 0 } }, /* kuromatsunai */
    { .label = { 122051,  7, 0 } }, /* kushiro */
    { .label = { 122082,  7, 0 } }, /* kutchan */
    { .label = { 156249,  5, 0 } }, /* kyowa */
    { .label = { 122113,  7, 0 } }, /* mashike */
    { .label = { 100729,  8, 0 } }, /* matsumae */
    { .label = { 123990,  6, 0 } }, /* mikasa */
    { .label = {  41646, 12, 0 } }, /* minamifurano */
    { .label = { 100762,  8, 0 } }, /* mombetsu */
    { .label = { 100799,  8, 0 } }, /* moseushi */
    { .label = { 102309,  6, 0 } }, /* mukawa */
    { .label = { 122143,  7, 0 } }, /* muroran */
    { .label = {  44554,  4, 0 } }, /* naie */
    { .label = {  99307,  8, 0 } }, /* nakagawa */
    { .label = {  41697, 12, 0 } }, /* nakasatsunai */
    { .label = {  41743, 12, 0 } }, /* nakatombetsu */
    { .label = { 156892,  5, 0 } }, /* nanae */
    { .label = { 122172,  7, 0 } }, /* nanporo */
    { .label = { 142313,  6, 0 } }, /* nayoro */
    { .label = { 142338,  6, 0 } }, /* nemuro */
    { .label = { 100834,  8, 0 } }, /* niikappu */
    { .label = {  81192,  4, 0 } }, /* niki */
    { .label = {  54512, 11, 0 } }, /* nishiokoppe */
    { .label = {  54562, 11, 0 } }, /* noboribetsu */
    { .label = { 141953,  6, 0 } }, /* numata */
    { .label = { 122201,  7, 0 } }, /* obihiro */
    { .label = { 100358,  5, 0 } }, /* obira */
    { .label = { 156910,  5, 0 } }, /* oketo */
    { .label = {  54533,  6, 0 } }, /* okoppe */
    { .label = { 156931,  5, 0 } }, /* otaru */
    { .label = {  20174,  5, 0 } }, /* otobe */
    { .label = { 122232,  7, 0 } }, /* otofuke */
    { .label = {  82439,  9, 0 } }, /* otoineppu */
    { .label = { 154428,  4, 0 } }, /* oumu */
    { .label = { 152634,  5, 0 } }, /* ozora */
    { .label = { 156951,  5, 0 } }, /* pippu */
    { .label = { 100871,  8, 0 } }, /* rankoshi */
    { .label = { 156978,  5, 0 } }, /* rebun */
    { .label = {  82480,  9, 0 } }, /* rikubetsu */
    { .label = {  54611,  7, 0 } }, /* rishiri */
    { .label = {  54611, 11, 0 } }, /* rishirifuji */
    { .label = { 142364,  6, 0 } }, /* saroma */
    { .label = {  82521,  9, 0 } }, /* sarufutsu */
    { .label = { 100904,  8, 0 } }, /* shakotan */
    { .label = { 157001,  5, 0 } }, /* shari */
    { .label = { 100936,  8, 0 } }, /* shibecha */
    { .label = {  82242,  8, 0 } }, /* shibetsu */
    { .label = { 122264,  7, 0 } }, /* shikabe */
    { .label = { 122295,  7, 0 } }, /* shikaoi */
    { .label = {  82561,  9, 0 } }, /* shimamaki */
    { .label = {  54961,  7, 0 } }, /* shimizu */
    { .label = {  82599,  9, 0 } }, /* shimokawa */
    { .label = {  41794, 12, 0 } }, /* shinshinotsu */
    { .label = { 100972,  8, 0 } }, /* shintoku */
    { .label = {  82638,  9, 0 } }, /* shiranuka */
    { .label = { 122324,  7, 0 } }, /* shiraoi */
    { .label = {  82675,  9, 0 } }, /* shiriuchi */
    { .label = { 122352,  7, 0 } }, /* sobetsu */
    { .label = {  41563,  8, 0 } }, /* sunagawa */
    { .label = { 157021,  5, 0 } }, /* taiki */
    { .label = { 142387,  6, 0 } }, /* takasu */
    { .label = { 101007,  8, 0 } }, /* takikawa */
    { .label = { 101040,  8, 0 } }, /* takinoue */
    { .label = {  82715,  9, 0 } }, /* teshikaga */
    { .label = { 101113,  7, 0 } }, /* tobetsu */
    { .label = { 157041,  5, 0 } }, /* tohma */
    { .label = {  82752,  9, 0 } }, /* tomakomai */
    { .label = { 142411,  6, 0 } }, /* tomari */
    { .label = {  14656,  4, 0 } }, /* toya */
    { .label = { 142435,  6, 0 } }, /* toyako */
    { .label = { 101073,  8, 0 } }, /* toyotomi */
    { .label = { 122383,  7, 0 } }, /* toyoura */
    { .label = { 101108,  8, 0 } }, /* tsubetsu */
    { .label = {  82789,  9, 0 } }, /* tsukigata */
    { .label = { 122413,  7, 0 } }, /* urakawa */
    { .label = { 142461,  6, 0 } }, /* urausu */
    { .label = { 121974,  4, 0 } }, /* uryu */
    { .label = {  82826,  9, 0 } }, /* utashinai */
    { .label = { 101144,  8, 0 } }, /* wakkanai */
    { .label = { 122442,  7, 0 } }, /* wassamu */
    { .label = { 142487,  6, 0 } }, /* yakumo */
    { .label = { 142515,  6, 0 } }, /* yoichi */

    /* entries 4721 to 4766 */
    { .label = {   1453,  4, 0 } }, /* aioi */
    { .label = {  84167,  6, 0 } }, /* akashi */
    { .label = {  11348,  3, 0 } }, /* ako */
    { .label = {  82862,  9, 0 } }, /* amagasaki */
    { .label = { 142543,  6, 0 } }, /* aogaki */
    { .label = { 101325,  5, 0 } }, /* asago */
    { .label = {  34018,  6, 0 } }, /* ashiya */
    { .label = {  54687,  5, 0 } }, /* awaji */
    { .label = { 101177,  8, 0 } }, /* fukusaki */
    { .label = { 122472,  7, 0 } }, /* goshiki */
    { .label = { 142567,  6, 0 } }, /* harima */
    { .label = { 142591,  6, 0 } }, /* himeji */
    { .label = {  26096,  8, 0 } }, /* ichikawa */
    { .label = {  85770,  7, 0 } }, /* inagawa */
    { .label = { 142293,  5, 0 } }, /* itami */
    { .label = { 101214,  8, 0 } }, /* kakogawa */
    { .label = { 101248,  8, 0 } }, /* kamigori */
    { .label = { 100516,  8, 0 } }, /* kamikawa */
    { .label = {  17570,  5, 0 } }, /* kasai */
    { .label = { 120366,  6, 0 } }, /* kasuga */
    { .label = {  82897,  9, 0 } }, /* kawanishi */
    { .label = {  42158,  4, 0 } }, /* miki */
    { .label = {  54662, 11, 0 } }, /* minamiawaji */
    { .label = {  54710, 11, 0 } }, /* nishinomiya */
    { .label = {  82935,  9, 0 } }, /* nishiwaki */
    { .label = {   1994,  3, 0 } }, /* ono */
    { .label = { 157062,  5, 0 } }, /* sanda */
    { .label = { 142620,  6, 0 } }, /* sannan */
    { .label = { 101282,  8, 0 } }, /* sasayama */
    { .label = { 145965,  4, 0 } }, /* sayo */
    { .label = { 141467,  6, 0 } }, /* shingu */
    { .label = {  82974,  9, 0 } }, /* shinonsen */
    { .label = { 157081,  5, 0 } }, /* shiso */
    { .label = {  83259,  6, 0 } }, /* sumoto */
    { .label = { 121388,  6, 0 } }, /* taishi */
    { .label = {  22279,  4, 0 } }, /* taka */
    { .label = {  68620, 10, 0 } }, /* takarazuka */
    { .label = { 101313,  8, 0 } }, /* takasago */
    { .label = { 101040,  6, 0 } }, /* takino */
    { .label = { 102655,  5, 0 } }, /* tamba */
    { .label = { 122503,  7, 0 } }, /* tatsuno */
    { .label = { 122531,  7, 0 } }, /* toyooka */
    { .label = { 141746,  4, 0 } }, /* yabu */
    { .label = {  85074,  7, 0 } }, /* yashiro */
    { .label = {  68198,  4, 0 } }, /* yoka */
    { .label = {  98560,  6, 0 } }, /* yokawa */

    /* entries 4767 to 4817 */
    { .label = {   3784,  3, 0 } }, /* ami */
    { .label = {  67971,  5, 0 } }, /* asahi */
    { .label = { 157102,  5, 0 } }, /* bando */
    { .label = { 101344,  8, 0 } }, /* chikusei */
    { .label = { 157124,  5, 0 } }, /* daigo */
    { .label = {  83011,  9, 0 } }, /* fujishiro */
    { .label = {  41845,  7, 0 } }, /* hitachi */
    { .label = {  54757, 11, 0 } }, /* hitachinaka */
    { .label = {  41845, 12, 0 } }, /* hitachiomiya */
    { .label = {  68662, 10, 0 } }, /* hitachiota */
    { .label = { 119987,  7, 0 } }, /* ibaraki */
    { .label = {    694,  3, 0 } }, /* ina */
    { .label = { 101380,  8, 0 } }, /* inashiki */
    { .label = { 157145,  5, 0 } }, /* itako */
    { .label = { 144556,  5, 0 } }, /* iwama */
    { .label = { 165857,  4, 0 } }, /* joso */
    { .label = {  41546,  6, 0 } }, /* kamisu */
    { .label = {  81943,  6, 0 } }, /* kasama */
    { .label = {  85189,  7, 0 } }, /* kashima */
    { .label = {  54802, 11, 0 } }, /* kasumigaura */
    { .label = {  73027,  4, 0 } }, /* koga */
    { .label = { 165876,  4, 0 } }, /* miho */
    { .label = {  50330,  4, 0 } }, /* mito */
    { .label = { 104813,  6, 0 } }, /* moriya */
    { .label = {  25995,  4, 0 } }, /* naka */
    { .label = { 101413,  8, 0 } }, /* namegata */
    { .label = { 157165,  5, 0 } }, /* oarai */
    { .label = {  19198,  5, 0 } }, /* ogawa */
    { .label = { 122561,  7, 0 } }, /* omitama */
    { .label = {  83054,  9, 0 } }, /* ryugasaki */
    { .label = {  26081,  5, 0 } }, /* sakai */
    { .label = {  68703, 10, 0 } }, /* sakuragawa */
    { .label = {  83093,  9, 0 } }, /* shimodate */
    { .label = {  68744, 10, 0 } }, /* shimotsuma */
    { .label = {  83131,  9, 0 } }, /* shirosato */
    { .label = { 165894,  4, 0 } }, /* sowa */
    { .label = { 157183,  5, 0 } }, /* suifu */
    { .label = { 101444,  8, 0 } }, /* takahagi */
    { .label = {  54848, 11, 0 } }, /* tamatsukuri */
    { .label = {  54330,  5, 0 } }, /* tokai */
    { .label = { 142642,  6, 0 } }, /* tomobe */
    { .label = {  15173,  4, 0 } }, /* tone */
    { .label = { 142669,  6, 0 } }, /* toride */
    { .label = {  83167,  9, 0 } }, /* tsuchiura */
    { .label = { 122589,  7, 0 } }, /* tsukuba */
    { .label = { 101476,  8, 0 } }, /* uchihara */
    { .label = { 142694,  6, 0 } }, /* ushiku */
    { .label = { 120867,  7, 0 } }, /* yachiyo */
    { .label = {  98355,  8, 0 } }, /* yamagata */
    { .label = { 142722,  6, 0 } }, /* yawara */
    { .label = { 142887,  4, 0 } }, /* yuki */

    /* entries 4818 to 4836 */
    { .label = { 122621,  7, 0 } }, /* anamizu */
    { .label = { 157207,  5, 0 } }, /* hakui */
    { .label = { 122652,  7, 0 } }, /* hakusan */
    { .label = {  33588,  4, 0 } }, /* kaga */
    { .label = { 142202,  6, 0 } }, /* kahoku */
    { .label = { 101510,  8, 0 } }, /* kanazawa */
    { .label = { 101544,  8, 0 } }, /* kawakita */
    { .label = {  42654,  7, 0 } }, /* komatsu */
    { .label = { 101577,  8, 0 } }, /* nakanoto */
    { .label = { 157229,  5, 0 } }, /* nanao */
    { .label = {  41990,  4, 0 } }, /* nomi */
    { .label = { 101608,  8, 0 } }, /* nonoichi */
    { .label = { 101083,  4, 0 } }, /* noto */
    { .label = {  33411,  5, 0 } }, /* shika */
    { .label = { 143472,  4, 0 } }, /* suzu */
    { .label = { 122681,  7, 0 } }, /* tsubata */
    { .label = { 122710,  7, 0 } }, /* tsurugi */
    { .label = { 101642,  8, 0 } }, /* uchinada */
    { .label = { 104553,  6, 0 } }, /* wajima */

    /* entries 4837 to 4870 */
    { .label = { 157247,  5, 0 } }, /* fudai */
    { .label = { 101676,  8, 0 } }, /* fujisawa */
    { .label = {  25956,  8, 0 } }, /* hanamaki */
    { .label = {  83206,  9, 0 } }, /* hiraizumi */
    { .label = { 141645,  6, 0 } }, /* hirono */
    { .label = {  68039,  8, 0 } }, /* ichinohe */
    { .label = {  68787, 10, 0 } }, /* ichinoseki */
    { .label = { 101714,  8, 0 } }, /* iwaizumi */
    { .label = {  20256,  5, 0 } }, /* iwate */
    { .label = { 142747,  6, 0 } }, /* joboji */
    { .label = { 101752,  8, 0 } }, /* kamaishi */
    { .label = {  68830, 10, 0 } }, /* kanegasaki */
    { .label = { 122741,  7, 0 } }, /* karumai */
    { .label = { 157270,  5, 0 } }, /* kawai */
    { .label = { 101785,  8, 0 } }, /* kitakami */
    { .label = { 165911,  4, 0 } }, /* kuji */
    { .label = {  98732,  6, 0 } }, /* kunohe */
    { .label = { 101818,  8, 0 } }, /* kuzumaki */
    { .label = {  69206,  6, 0 } }, /* miyako */
    { .label = { 101857,  8, 0 } }, /* mizusawa */
    { .label = { 122770,  7, 0 } }, /* morioka */
    { .label = { 142779,  6, 0 } }, /* ninohe */
    { .label = {  79281,  4, 0 } }, /* noda */
    { .label = { 122799,  7, 0 } }, /* ofunato */
    { .label = {  67846,  4, 0 } }, /* oshu */
    { .label = {  83163,  7, 0 } }, /* otsuchi */
    { .label = {  33503, 13, 0 } }, /* rikuzentakata */
    { .label = {  55194,  5, 0 } }, /* shiwa */
    { .label = {  54894, 11, 0 } }, /* shizukuishi */
    { .label = { 142804,  6, 0 } }, /* sumita */
    { .label = { 101894,  8, 0 } }, /* tanohata */
    { .label = {  41982,  4, 0 } }, /* tono */
    { .label = { 142829,  6, 0 } }, /* yahaba */
    { .label = { 141544,  6, 0 } }, /* yamada */

    /* entries 4871 to 4885 */
    { .label = { 104109,  7, 0 } }, /* ayagawa */
    { .label = {  33558, 13, 0 } }, /* higashikagawa */
    { .label = { 122829,  7, 0 } }, /* kanonji */
    { .label = { 101924,  8, 0 } }, /* kotohira */
    { .label = { 116013,  5, 0 } }, /* manno */
    { .label = { 101957,  8, 0 } }, /* marugame */
    { .label = { 142855,  6, 0 } }, /* mitoyo */
    { .label = { 101991,  8, 0 } }, /* naoshima */
    { .label = { 142882,  6, 0 } }, /* sanuki */
    { .label = { 122860,  7, 0 } }, /* tadotsu */
    { .label = {  33302,  9, 0 } }, /* takamatsu */
    { .label = { 122889,  7, 0 } }, /* tonosho */
    { .label = { 102023,  8, 0 } }, /* uchinomi */
    { .label = { 157291,  5, 0 } }, /* utazu */
    { .label = { 102059,  8, 0 } }, /* zentsuji */

    /* entries 4886 to 4905 */
    { .label = { 157315,  5, 0 } }, /* akune */
    { .label = { 144871,  5, 0 } }, /* amami */
    { .label = { 157336,  5, 0 } }, /* hioki */
    { .label = {   9230,  3, 0 } }, /* isa */
    { .label = {  87077,  4, 0 } }, /* isen */
    { .label = {  68376,  5, 0 } }, /* izumi */
    { .label = {  80748,  9, 0 } }, /* kagoshima */
    { .label = { 142907,  6, 0 } }, /* kanoya */
    { .label = { 102098,  8, 0 } }, /* kawanabe */
    { .label = { 157358,  5, 0 } }, /* kinko */
    { .label = { 122918,  7, 0 } }, /* kouyama */
    { .label = {  68870, 10, 0 } }, /* makurazaki */
    { .label = {  83247,  9, 0 } }, /* matsumoto */
    { .label = {  68914, 10, 0 } }, /* minamitane */
    { .label = { 102132,  8, 0 } }, /* nakatane */
    { .label = {  41897, 12, 0 } }, /* nishinoomote */
    { .label = {  33613, 13, 0 } }, /* satsumasendai */
    { .label = {   7269,  3, 0 } }, /* soo */
    { .label = { 102162,  8, 0 } }, /* tarumizu */
    { .label = { 157380,  5, 0 } }, /* yusui */

    /* entries 4906 to 4935 */
    { .label = { 100526,  6, 0 } }, /* aikawa */
    { .label = { 142932,  6, 0 } }, /* atsugi */
    { .label = { 157404,  5, 0 } }, /* ayase */
    { .label = {  83285,  9, 0 } }, /* chigasaki */
    { .label = { 157424,  5, 0 } }, /* ebina */
    { .label = { 101676,  8, 0 } }, /* fujisawa */
    { .label = { 142957,  6, 0 } }, /* hadano */
    { .label = { 142981,  6, 0 } }, /* hakone */
    { .label = {  83323,  9, 0 } }, /* hiratsuka */
    { .label = { 122949,  7, 0 } }, /* isehara */
    { .label = { 143006,  6, 0 } }, /* kaisei */
    { .label = { 102199,  8, 0 } }, /* kamakura */
    { .label = { 102232,  8, 0 } }, /* kiyokawa */
    { .label = { 122976,  7, 0 } }, /* matsuda */
    { .label = {  25803, 14, 0 } }, /* minamiashigara */
    { .label = { 157445,  5, 0 } }, /* miura */
    { .label = { 145652,  5, 0 } }, /* nakai */
    { .label = { 102268,  8, 0 } }, /* ninomiya */
    { .label = { 123005,  7, 0 } }, /* odawara */
    { .label = {    135,  2, 0 } }, /* oi */
    { .label = {  91468,  4, 0 } }, /* oiso */
    { .label = {  68954, 10, 0 } }, /* sagamihara */
    { .label = { 102302,  8, 0 } }, /* samukawa */
    { .label = { 143030,  6, 0 } }, /* tsukui */
    { .label = {  25962,  8, 0 } }, /* yamakita */
    { .label = {  25920,  6, 0 } }, /* yamato */
    { .label = { 102336,  8, 0 } }, /* yokosuka */
    { .label = { 102372,  8, 0 } }, /* yugawara */
    { .label = { 144864,  4, 0 } }, /* zama */
    { .label = {  70123,  5, 0 } }, /* zushi */

    /* entries 4936 to 4966 */
    { .label = {  13489,  3, 0 } }, /* aki */
    { .label = { 143057,  6, 0 } }, /* geisei */
    { .label = { 142185,  6, 0 } }, /* hidaka */
    { .label = {  41947, 12, 0 } }, /* higashitsuno */
    { .label = {    485,  3, 0 } }, /* ino */
    { .label = {  68457,  6, 0 } }, /* kagami */
    { .label = {  33358,  4, 0 } }, /* kami */
    { .label = { 102407,  8, 0 } }, /* kitagawa */
    { .label = { 156060,  5, 0 } }, /* kochi */
    { .label = {  68969,  6, 0 } }, /* mihara */
    { .label = { 102440,  8, 0 } }, /* motoyama */
    { .label = { 143082,  6, 0 } }, /* muroto */
    { .label = { 143108,  6, 0 } }, /* nahari */
    { .label = { 102474,  8, 0 } }, /* nakamura */
    { .label = { 123033,  7, 0 } }, /* nankoku */
    { .label = {  83360,  9, 0 } }, /* nishitosa */
    { .label = {  68993, 10, 0 } }, /* niyodogawa */
    { .label = {  19461,  4, 0 } }, /* ochi */
    { .label = {  69832,  5, 0 } }, /* okawa */
    { .label = { 122379,  5, 0 } }, /* otoyo */
    { .label = { 143131,  6, 0 } }, /* otsuki */
    { .label = { 121243,  6, 0 } }, /* sakawa */
    { .label = { 143157,  6, 0 } }, /* sukumo */
    { .label = { 143185,  6, 0 } }, /* susaki */
    { .label = {  54946,  4, 0 } }, /* tosa */
    { .label = {  54946, 11, 0 } }, /* tosashimizu */
    { .label = {  80722,  4, 0 } }, /* toyo */
    { .label = {  41977,  5, 0 } }, /* tsuno */
    { .label = { 157466,  5, 0 } }, /* umaji */
    { .label = { 143210,  6, 0 } }, /* yasuda */
    { .label = { 102506,  8, 0 } }, /* yusuhara */

    /* entries 4967 to 4989 */
    { .label = {  55012,  7, 0 } }, /* amakusa */
    { .label = {  26491,  4, 0 } }, /* arao */
    { .label = {    128,  3, 0 } }, /* aso */
    { .label = { 157490,  5, 0 } }, /* choyo */
    { .label = { 123063,  7, 0 } }, /* gyokuto */
    { .label = {  54995, 11, 0 } }, /* kamiamakusa */
    { .label = { 123096,  7, 0 } }, /* kikuchi */
    { .label = {  98181,  8, 0 } }, /* kumamoto */
    { .label = { 123129,  7, 0 } }, /* mashiki */
    { .label = { 143236,  6, 0 } }, /* mifune */
    { .label = { 102541,  8, 0 } }, /* minamata */
    { .label = {  55040, 11, 0 } }, /* minamioguni */
    { .label = { 143264,  6, 0 } }, /* nagasu */
    { .label = {  83396,  9, 0 } }, /* nishihara */
    { .label = {  55065,  5, 0 } }, /* oguni */
    { .label = {  70119,  3, 0 } }, /* ozu */
    { .label = {  83259,  6, 0 } }, /* sumoto */
    { .label = { 102572,  8, 0 } }, /* takamori */
    { .label = {  33773,  3, 0 } }, /* uki */
    { .label = {  13096,  3, 0 } }, /* uto */
    { .label = {  98355,  6, 0 } }, /* yamaga */
    { .label = {  25920,  6, 0 } }, /* yamato */
    { .label = {  69037, 10, 0 } }, /* yatsushiro */

    /* entries 4990 to 5020 */
    { .label = { 142266,  5, 0 } }, /* ayabe */
    { .label = {  55087, 11, 0 } }, /* fukuchiyama */
    { .label = {  34004, 11, 0 } }, /* higashiyama */
    { .label = {   2010,  3, 0 } }, /* ide */
    { .label = {    100,  3, 0 } }, /* ine */
    { .label = { 157934,  4, 0 } }, /* joyo */
    { .label = { 123159,  7, 0 } }, /* kameoka */
    { .label = {  98825,  4, 0 } }, /* kamo */
    { .label = {  25979,  4, 0 } }, /* kita */
    { .label = { 165932,  4, 0 } }, /* kizu */
    { .label = { 102604,  8, 0 } }, /* kumiyama */
    { .label = { 102640,  8, 0 } }, /* kyotamba */
    { .label = {  83432,  9, 0 } }, /* kyotanabe */
    { .label = { 102676,  8, 0 } }, /* kyotango */
    { .label = { 123188,  7, 0 } }, /* maizuru */
    { .label = {  19090,  6, 0 } }, /* minami */
    { .label = {  19090, 15, 0 } }, /* minamiyamashiro */
    { .label = { 143288,  6, 0 } }, /* miyazu */
    { .label = {  56760,  4, 0 } }, /* muko */
    { .label = {  69080, 10, 0 } }, /* nagaokakyo */
    { .label = { 123221,  7, 0 } }, /* nakagyo */
    { .label = { 143318,  6, 0 } }, /* nantan */
    { .label = {  83471,  9, 0 } }, /* oyamazaki */
    { .label = { 157514,  5, 0 } }, /* sakyo */
    { .label = { 157536,  5, 0 } }, /* seika */
    { .label = {  83447,  6, 0 } }, /* tanabe */
    { .label = {  19422,  3, 0 } }, /* uji */
    { .label = {  83511,  9, 0 } }, /* ujitawara */
    { .label = { 143340,  6, 0 } }, /* wazuka */
    { .label = {  83550,  9, 0 } }, /* yamashina */
    { .label = {  68287,  6, 0 } }, /* yawata */

    /* entries 5021 to 5050 */
    { .label = {  67971,  5, 0 } }, /* asahi */
    { .label = { 157556,  5, 0 } }, /* inabe */
    { .label = {  19742,  3, 0 } }, /* ise */
    { .label = { 102711,  8, 0 } }, /* kameyama */
    { .label = { 123251,  7, 0 } }, /* kawagoe */
    { .label = { 108882,  4, 0 } }, /* kiho */
    { .label = { 102745,  8, 0 } }, /* kisosaki */
    { .label = {  20251,  4, 0 } }, /* kiwa */
    { .label = { 143369,  6, 0 } }, /* komono */
    { .label = { 141977,  6, 0 } }, /* kumano */
    { .label = { 143395,  6, 0 } }, /* kuwana */
    { .label = {  83587,  9, 0 } }, /* matsusaka */
    { .label = { 156739,  5, 0 } }, /* meiwa */
    { .label = { 104233,  6, 0 } }, /* mihama */
    { .label = {  83623,  9, 0 } }, /* minamiise */
    { .label = { 143421,  6, 0 } }, /* misugi */
    { .label = {  19106,  6, 0 } }, /* miyama */
    { .label = { 143448,  6, 0 } }, /* nabari */
    { .label = {  11062,  5, 0 } }, /* shima */
    { .label = { 143472,  6, 0 } }, /* suzuka */
    { .label = { 122860,  4, 0 } }, /* tado */
    { .label = { 157021,  5, 0 } }, /* taiki */
    { .label = {  41457,  4, 0 } }, /* taki */
    { .label = { 143501,  6, 0 } }, /* tamaki */
    { .label = {  43348,  4, 0 } }, /* toba */
    { .label = {  11083,  3, 0 } }, /* tsu */
    { .label = {  99419,  5, 0 } }, /* udono */
    { .label = { 102778,  8, 0 } }, /* ureshino */
    { .label = { 123281,  7, 0 } }, /* watarai */
    { .label = {  83660,  9, 0 } }, /* yokkaichi */

    /* entries 5051 to 5082 */
    { .label = { 102812,  8, 0 } }, /* furukawa */
    { .label = {  11045, 17, 0 } }, /* higashimatsushima */
    { .label = {  69122, 10, 0 } }, /* ishinomaki */
    { .label = { 123308,  7, 0 } }, /* iwanuma */
    { .label = {  86247,  6, 0 } }, /* kakuda */
    { .label = {  33358,  4, 0 } }, /* kami */
    { .label = {  98387,  8, 0 } }, /* kawasaki */
    { .label = { 102849,  8, 0 } }, /* marumori */
    { .label = {  11075, 10, 0 } }, /* matsushima */
    { .label = {  33665, 13, 0 } }, /* minamisanriku */
    { .label = {  26131,  6, 0 } }, /* misato */
    { .label = { 143525,  6, 0 } }, /* murata */
    { .label = {  54596,  6, 0 } }, /* natori */
    { .label = { 102379,  7, 0 } }, /* ogawara */
    { .label = { 101937,  5, 0 } }, /* ohira */
    { .label = {  41568,  7, 0 } }, /* onagawa */
    { .label = {  33338,  5, 0 } }, /* osaki */
    { .label = {  54632,  4, 0 } }, /* rifu */
    { .label = { 143549,  6, 0 } }, /* semine */
    { .label = { 123338,  7, 0 } }, /* shibata */
    { .label = {  33719, 13, 0 } }, /* shichikashuku */
    { .label = { 123367,  7, 0 } }, /* shikama */
    { .label = { 102883,  8, 0 } }, /* shiogama */
    { .label = {  83701,  9, 0 } }, /* shiroishi */
    { .label = { 143574,  6, 0 } }, /* tagajo */
    { .label = { 101707,  5, 0 } }, /* taiwa */
    { .label = { 115986,  4, 0 } }, /* tome */
    { .label = {  98208,  6, 0 } }, /* tomiya */
    { .label = { 143600,  6, 0 } }, /* wakuya */
    { .label = { 143628,  6, 0 } }, /* watari */
    { .label = { 102916,  8, 0 } }, /* yamamoto */
    { .label = {   5463,  3, 0 } }, /* zao */

    /* entries 5083 to 5109 */
    { .label = {   5900,  3, 0 } }, /* aya */
    { .label = { 157577,  5, 0 } }, /* ebino */
    { .label = { 143652,  6, 0 } }, /* gokase */
    { .label = { 157599,  5, 0 } }, /* hyuga */
    { .label = { 102950,  8, 0 } }, /* kadogawa */
    { .label = {  69164, 10, 0 } }, /* kawaminami */
    { .label = { 165953,  4, 0 } }, /* kijo */
    { .label = { 102407,  8, 0 } }, /* kitagawa */
    { .label = {  99506,  8, 0 } }, /* kitakata */
    { .label = { 123396,  7, 0 } }, /* kitaura */
    { .label = {  83739,  9, 0 } }, /* kobayashi */
    { .label = { 102984,  8, 0 } }, /* kunitomi */
    { .label = {  33806,  7, 0 } }, /* kushima */
    { .label = { 143677,  6, 0 } }, /* mimata */
    { .label = {  69206, 10, 0 } }, /* miyakonojo */
    { .label = {  98216,  8, 0 } }, /* miyazaki */
    { .label = {  83779,  9, 0 } }, /* morotsuka */
    { .label = { 103019,  8, 0 } }, /* nichinan */
    { .label = {  83817,  9, 0 } }, /* nishimera */
    { .label = { 123424,  7, 0 } }, /* nobeoka */
    { .label = { 157623,  5, 0 } }, /* saito */
    { .label = { 143701,  6, 0 } }, /* shiiba */
    { .label = { 103052,  8, 0 } }, /* shintomi */
    { .label = { 103086,  8, 0 } }, /* takaharu */
    { .label = { 103118,  8, 0 } }, /* takanabe */
    { .label = { 103150,  8, 0 } }, /* takazaki */
    { .label = {  41977,  5, 0 } }, /* tsuno */

    /* entries 5110 to 5184 */
    { .label = {    187,  4, 0 } }, /* achi */
    { .label = { 103184,  8, 0 } }, /* agematsu */
    { .label = {  14706,  4, 0 } }, /* anan */
    { .label = {  33852,  4, 0 } }, /* aoki */
    { .label = {  67971,  5, 0 } }, /* asahi */
    { .label = { 123454,  7, 0 } }, /* azumino */
    { .label = {  83854,  9, 0 } }, /* chikuhoku */
    { .label = { 123486,  7, 0 } }, /* chikuma */
    { .label = {  67910,  5, 0 } }, /* chino */
    { .label = {  54640,  6, 0 } }, /* fujimi */
    { .label = { 143727,  6, 0 } }, /* hakuba */
    { .label = {  17599,  4, 0 } }, /* hara */
    { .label = { 143754,  6, 0 } }, /* hiraya */
    { .label = {  72903,  4, 0 } }, /* iida */
    { .label = { 143779,  6, 0 } }, /* iijima */
    { .label = { 143806,  6, 0 } }, /* iiyama */
    { .label = { 143831,  6, 0 } }, /* iizuna */
    { .label = { 156422,  5, 0 } }, /* ikeda */
    { .label = { 123518,  7, 0 } }, /* ikusaka */
    { .label = {    694,  3, 0 } }, /* ina */
    { .label = {  83897,  9, 0 } }, /* karuizawa */
    { .label = {  54448,  8, 0 } }, /* kawakami */
    { .label = {  33778,  4, 0 } }, /* kiso */
    { .label = {  33778, 13, 0 } }, /* kisofukushima */
    { .label = { 103217,  8, 0 } }, /* kitaaiki */
    { .label = { 103249,  8, 0 } }, /* komagane */
    { .label = { 143858,  6, 0 } }, /* komoro */
    { .label = {  83937,  9, 0 } }, /* matsukawa */
    { .label = {  83247,  9, 0 } }, /* matsumoto */
    { .label = { 157642,  5, 0 } }, /* miasa */
    { .label = {  69252, 10, 0 } }, /* minamiaiki */
    { .label = {  69293, 10, 0 } }, /* minamimaki */
    { .label = {  41998, 12, 0 } }, /* minamiminowa */
    { .label = {  42023,  6, 0 } }, /* minowa */
    { .label = { 143884,  6, 0 } }, /* miyada */
    { .label = { 143910,  6, 0 } }, /* miyota */
    { .label = {  83975,  9, 0 } }, /* mochizuki */
    { .label = {  33923,  6, 0 } }, /* nagano */
    { .label = {  41572,  6, 0 } }, /* nagawa */
    { .label = { 143936,  6, 0 } }, /* nagiso */
    { .label = {  99307,  8, 0 } }, /* nakagawa */
    { .label = {  99935,  6, 0 } }, /* nakano */
    { .label = {  55139, 11, 0 } }, /* nozawaonsen */
    { .label = {  13227,  5, 0 } }, /* obuse */
    { .label = {  19198,  5, 0 } }, /* ogawa */
    { .label = { 105821,  5, 0 } }, /* okaya */
    { .label = {  42073,  6, 0 } }, /* omachi */
    { .label = {  14577,  3, 0 } }, /* omi */
    { .label = { 143960,  6, 0 } }, /* ookuwa */
    { .label = { 123547,  7, 0 } }, /* ooshika */
    { .label = { 101003,  5, 0 } }, /* otaki */
    { .label = { 157661,  5, 0 } }, /* otari */
    { .label = { 156359,  5, 0 } }, /* sakae */
    { .label = { 143987,  6, 0 } }, /* sakaki */
    { .label = {  68703,  4, 0 } }, /* saku */
    { .label = { 144011,  6, 0 } }, /* sakuho */
    { .label = {  84019,  9, 0 } }, /* shimosuwa */
    { .label = {  42049, 12, 0 } }, /* shinanomachi */
    { .label = { 103282,  8, 0 } }, /* shiojiri */
    { .label = {  84041,  4, 0 } }, /* suwa */
    { .label = { 144037,  6, 0 } }, /* suzaka */
    { .label = { 144064,  6, 0 } }, /* takagi */
    { .label = { 102572,  8, 0 } }, /* takamori */
    { .label = {  98323,  8, 0 } }, /* takayama */
    { .label = {  84059,  9, 0 } }, /* tateshina */
    { .label = { 122503,  7, 0 } }, /* tatsuno */
    { .label = {  84094,  9, 0 } }, /* togakushi */
    { .label = { 144088,  6, 0 } }, /* togura */
    { .label = {  14573,  4, 0 } }, /* tomi */
    { .label = { 165973,  4, 0 } }, /* ueda */
    { .label = {  84814,  4, 0 } }, /* wada */
    { .label = {  98355,  8, 0 } }, /* yamagata */
    { .label = {  69335, 10, 0 } }, /* yamanouchi */
    { .label = { 144113,  6, 0 } }, /* yasaka */
    { .label = { 123576,  7, 0 } }, /* yasuoka */

    /* entries 5185 to 5206 */
    { .label = { 123606,  7, 0 } }, /* chijiwa */
    { .label = {  82537,  5, 0 } }, /* futsu */
    { .label = {  42133,  4, 0 } }, /* goto */
    { .label = { 144137,  6, 0 } }, /* hasami */
    { .label = { 144161,  6, 0 } }, /* hirado */
    { .label = {  21434,  3, 0 } }, /* iki */
    { .label = { 123640,  7, 0 } }, /* isahaya */
    { .label = {  99619,  8, 0 } }, /* kawatana */
    { .label = {  69379, 10, 0 } }, /* kuchinotsu */
    { .label = { 103318,  8, 0 } }, /* matsuura */
    { .label = {  98253,  8, 0 } }, /* nagasaki */
    { .label = { 156443,  5, 0 } }, /* obama */
    { .label = { 157680,  5, 0 } }, /* omura */
    { .label = { 103755,  5, 0 } }, /* oseto */
    { .label = { 144186,  6, 0 } }, /* saikai */
    { .label = { 144209,  6, 0 } }, /* sasebo */
    { .label = { 157701,  5, 0 } }, /* seihi */
    { .label = {  84133,  9, 0 } }, /* shimabara */
    { .label = {  42099, 12, 0 } }, /* shinkamigoto */
    { .label = { 123668,  7, 0 } }, /* togitsu */
    { .label = {  11083,  8, 0 } }, /* tsushima */
    { .label = { 157722,  5, 0 } }, /* unzen */

    /* entries 5207 to 5244 */
    { .label = {  16716,  4, 0 } }, /* ando */
    { .label = { 121911,  4, 0 } }, /* gose */
    { .label = { 144234,  6, 0 } }, /* heguri */
    { .label = {  25859, 14, 0 } }, /* higashiyoshino */
    { .label = { 123698,  7, 0 } }, /* ikaruga */
    { .label = { 103245,  5, 0 } }, /* ikoma */
    { .label = {  42150, 12, 0 } }, /* kamikitayama */
    { .label = { 123727,  7, 0 } }, /* kanmaki */
    { .label = { 123756,  7, 0 } }, /* kashiba */
    { .label = {  84170,  9, 0 } }, /* kashihara */
    { .label = {  84206,  9, 0 } }, /* katsuragi */
    { .label = { 157270,  5, 0 } }, /* kawai */
    { .label = {  54448,  8, 0 } }, /* kawakami */
    { .label = {  82897,  9, 0 } }, /* kawanishi */
    { .label = { 157746,  5, 0 } }, /* koryo */
    { .label = { 103351,  8, 0 } }, /* kurotaki */
    { .label = { 103594,  6, 0 } }, /* mitsue */
    { .label = { 144261,  6, 0 } }, /* miyake */
    { .label = {   8120,  4, 0 } }, /* nara */
    { .label = { 103385,  8, 0 } }, /* nosegawa */
    { .label = {  19423,  3, 0 } }, /* oji */
    { .label = {  13503,  4, 0 } }, /* ouda */
    { .label = { 157769,  5, 0 } }, /* oyodo */
    { .label = { 123786,  7, 0 } }, /* sakurai */
    { .label = { 157792,  5, 0 } }, /* sango */
    { .label = {  84243,  9, 0 } }, /* shimoichi */
    { .label = {  33837, 13, 0 } }, /* shimokitayama */
    { .label = { 144288,  6, 0 } }, /* shinjo */
    { .label = {  93642,  4, 0 } }, /* soni */
    { .label = { 103418,  8, 0 } }, /* takatori */
    { .label = {  69424, 10, 0 } }, /* tawaramoto */
    { .label = { 123814,  7, 0 } }, /* tenkawa */
    { .label = { 157812,  5, 0 } }, /* tenri */
    { .label = {  11623,  3, 0 } }, /* uda */
    { .label = {  25920, 14, 0 } }, /* yamatokoriyama */
    { .label = {  42200, 12, 0 } }, /* yamatotakada */
    { .label = { 123843,  7, 0 } }, /* yamazoe */
    { .label = {  25889,  7, 0 } }, /* yoshino */

    /* entries 5245 to 5278 */
    { .label = {   9337,  3, 0 } }, /* aga */
    { .label = {  33927,  5, 0 } }, /* agano */
    { .label = { 157832,  5, 0 } }, /* gosen */
    { .label = { 103449,  8, 0 } }, /* itoigawa */
    { .label = {  84283,  9, 0 } }, /* izumozaki */
    { .label = { 144316,  6, 0 } }, /* joetsu */
    { .label = {  98825,  4, 0 } }, /* kamo */
    { .label = { 144344,  6, 0 } }, /* kariwa */
    { .label = {  55186, 11, 0 } }, /* kashiwazaki */
    { .label = {  42248, 12, 0 } }, /* minamiuonuma */
    { .label = { 123875,  7, 0 } }, /* mitsuke */
    { .label = { 157853,  5, 0 } }, /* muika */
    { .label = { 103482,  8, 0 } }, /* murakami */
    { .label = { 157875,  5, 0 } }, /* myoko */
    { .label = {  69080,  7, 0 } }, /* nagaoka */
    { .label = { 120016,  7, 0 } }, /* niigata */
    { .label = { 157899,  5, 0 } }, /* ojiya */
    { .label = {  14577,  3, 0 } }, /* omi */
    { .label = {  73413,  4, 0 } }, /* sado */
    { .label = { 157923,  5, 0 } }, /* sanjo */
    { .label = { 144369,  5, 0 } }, /* seiro */
    { .label = { 144369,  6, 0 } }, /* seirou */
    { .label = { 103516,  8, 0 } }, /* sekikawa */
    { .label = { 123338,  7, 0 } }, /* shibata */
    { .label = {  98632,  6, 0 } }, /* tagami */
    { .label = { 144394,  6, 0 } }, /* tainai */
    { .label = { 144416,  6, 0 } }, /* tochio */
    { .label = {  84327,  9, 0 } }, /* tokamachi */
    { .label = { 123906,  7, 0 } }, /* tsubame */
    { .label = { 121679,  6, 0 } }, /* tsunan */
    { .label = {  42273,  6, 0 } }, /* uonuma */
    { .label = { 144442,  6, 0 } }, /* yahiko */
    { .label = { 157945,  5, 0 } }, /* yoita */
    { .label = { 144469,  6, 0 } }, /* yuzawa */

    /* entries 5279 to 5297 */
    { .label = { 157966,  5, 0 } }, /* beppu */
    { .label = { 103550,  8, 0 } }, /* bungoono */
    { .label = {  55235, 11, 0 } }, /* bungotakada */
    { .label = { 144499,  6, 0 } }, /* hasama */
    { .label = { 123611,  4, 0 } }, /* hiji */
    { .label = {  84365,  9, 0 } }, /* himeshima */
    { .label = {  41845,  4, 0 } }, /* hita */
    { .label = { 103586,  8, 0 } }, /* kamitsue */
    { .label = { 123937,  7, 0 } }, /* kokonoe */
    { .label = {  98894,  4, 0 } }, /* kuju */
    { .label = { 103620,  8, 0 } }, /* kunisaki */
    { .label = { 105420,  4, 0 } }, /* kusu */
    { .label = {  83519,  4, 0 } }, /* oita */
    { .label = { 157993,  5, 0 } }, /* saiki */
    { .label = { 144522,  6, 0 } }, /* taketa */
    { .label = { 123967,  7, 0 } }, /* tsukumi */
    { .label = {  17256,  3, 0 } }, /* usa */
    { .label = { 158013,  5, 0 } }, /* usuki */
    { .label = { 165990,  4, 0 } }, /* yufu */

    /* entries 5298 to 5323 */
    { .label = { 144545,  6, 0 } }, /* akaiwa */
    { .label = { 103654,  8, 0 } }, /* asakuchi */
    { .label = { 158036,  5, 0 } }, /* bizen */
    { .label = {  84404,  9, 0 } }, /* hayashima */
    { .label = { 119987,  5, 0 } }, /* ibara */
    { .label = { 103688,  8, 0 } }, /* kagamino */
    { .label = { 123999,  7, 0 } }, /* kasaoka */
    { .label = { 103721,  8, 0 } }, /* kibichuo */
    { .label = { 124026,  7, 0 } }, /* kumenan */
    { .label = {  84442,  9, 0 } }, /* kurashiki */
    { .label = { 144569,  6, 0 } }, /* maniwa */
    { .label = { 144594,  6, 0 } }, /* misaki */
    { .label = {  81377,  4, 0 } }, /* nagi */
    { .label = { 158061,  5, 0 } }, /* niimi */
    { .label = {  42299, 12, 0 } }, /* nishiawakura */
    { .label = { 105821,  7, 0 } }, /* okayama */
    { .label = { 124056,  7, 0 } }, /* satosho */
    { .label = { 103759,  8, 0 } }, /* setouchi */
    { .label = { 144288,  6, 0 } }, /* shinjo */
    { .label = { 166012,  4, 0 } }, /* shoo */
    { .label = {  36961,  4, 0 } }, /* soja */
    { .label = {  84481,  9, 0 } }, /* takahashi */
    { .label = { 144619,  6, 0 } }, /* tamano */
    { .label = {  14651,  7, 0 } }, /* tsuyama */
    { .label = { 166029,  4, 0 } }, /* wake */
    { .label = { 144642,  6, 0 } }, /* yakage */

    /* entries 5324 to 5365 */
    { .label = { 103983,  5, 0 } }, /* aguni */
    { .label = { 124084,  7, 0 } }, /* ginowan */
    { .label = { 144668,  6, 0 } }, /* ginoza */
    { .label = {  84517,  9, 0 } }, /* gushikami */
    { .label = { 124114,  7, 0 } }, /* haebaru */
    { .label = {  11045,  7, 0 } }, /* higashi */
    { .label = { 144695,  6, 0 } }, /* hirara */
    { .label = { 158082,  5, 0 } }, /* iheya */
    { .label = { 103794,  8, 0 } }, /* ishigaki */
    { .label = {  86147,  8, 0 } }, /* ishikawa */
    { .label = { 144718,  6, 0 } }, /* itoman */
    { .label = { 158104,  5, 0 } }, /* izena */
    { .label = { 144742,  6, 0 } }, /* kadena */
    { .label = {   2619,  3, 0 } }, /* kin */
    { .label = {  84557,  9, 0 } }, /* kitadaito */
    { .label = {  25979, 14, 0 } }, /* kitanakagusuku */
    { .label = { 103828,  8, 0 } }, /* kumejima */
    { .label = { 103866,  8, 0 } }, /* kunigami */
    { .label = {  55282, 11, 0 } }, /* minamidaito */
    { .label = { 144766,  6, 0 } }, /* motobu */
    { .label = {  85498,  4, 0 } }, /* nago */
    { .label = {  85890,  4, 0 } }, /* naha */
    { .label = {  25995, 10, 0 } }, /* nakagusuku */
    { .label = { 124144,  7, 0 } }, /* nakijin */
    { .label = { 158126,  5, 0 } }, /* nanjo */
    { .label = {  83396,  9, 0 } }, /* nishihara */
    { .label = { 158148,  5, 0 } }, /* ogimi */
    { .label = { 120043,  7, 0 } }, /* okinawa */
    { .label = { 125563,  4, 0 } }, /* onna */
    { .label = { 124175,  7, 0 } }, /* shimoji */
    { .label = { 103901,  8, 0 } }, /* taketomi */
    { .label = { 144794,  6, 0 } }, /* tarama */
    { .label = {  84593,  9, 0 } }, /* tokashiki */
    { .label = {  69464, 10, 0 } }, /* tomigusuku */
    { .label = { 144816,  6, 0 } }, /* tonaki */
    { .label = { 144840,  6, 0 } }, /* urasoe */
    { .label = { 158170,  5, 0 } }, /* uruma */
    { .label = { 158192,  5, 0 } }, /* yaese */
    { .label = { 124208,  7, 0 } }, /* yomitan */
    { .label = { 103934,  8, 0 } }, /* yonabaru */
    { .label = { 103969,  8, 0 } }, /* yonaguni */
    { .label = { 144864,  6, 0 } }, /* zamami */

    /* entries 5366 to 5415 */
    { .label = { 158213,  5, 0 } }, /* abeno */
    { .label = {  26039, 14, 0 } }, /* chihayaakasaka */
    { .label = {  54207,  4, 0 } }, /* chuo */
    { .label = {  55307,  5, 0 } }, /* daito */
    { .label = {  84631,  9, 0 } }, /* fujiidera */
    { .label = { 104004,  8, 0 } }, /* habikino */
    { .label = { 144891,  6, 0 } }, /* hannan */
    { .label = {  42349, 12, 0 } }, /* higashiosaka */
    { .label = {  14542, 16, 0 } }, /* higashisumiyoshi */
    { .label = {  19153, 15, 0 } }, /* higashiyodogawa */
    { .label = { 104039,  8, 0 } }, /* hirakata */
    { .label = { 119987,  7, 0 } }, /* ibaraki */
    { .label = { 156422,  5, 0 } }, /* ikeda */
    { .label = {  68376,  5, 0 } }, /* izumi */
    { .label = {  84673,  9, 0 } }, /* izumiotsu */
    { .label = {  84715,  9, 0 } }, /* izumisano */
    { .label = {  67997,  6, 0 } }, /* kadoma */
    { .label = { 124238,  7, 0 } }, /* kaizuka */
    { .label = { 158234,  5, 0 } }, /* kanan */
    { .label = {  84755,  9, 0 } }, /* kashiwara */
    { .label = { 144914,  6, 0 } }, /* katano */
    { .label = {  33892, 13, 0 } }, /* kawachinagano */
    { .label = {  84792,  9, 0 } }, /* kishiwada */
    { .label = {  25979,  4, 0 } }, /* kita */
    { .label = { 104070,  8, 0 } }, /* kumatori */
    { .label = {  84831,  9, 0 } }, /* matsubara */
    { .label = {  55531,  6, 0 } }, /* minato */
    { .label = { 104360,  5, 0 } }, /* minoh */
    { .label = { 144594,  6, 0 } }, /* misaki */
    { .label = {  84868,  9, 0 } }, /* moriguchi */
    { .label = { 104104,  8, 0 } }, /* neyagawa */
    { .label = {  41897,  5, 0 } }, /* nishi */
    { .label = {  55621,  4, 0 } }, /* nose */
    { .label = {  55327, 11, 0 } }, /* osakasayama */
    { .label = {  26081,  5, 0 } }, /* sakai */
    { .label = {  55346,  6, 0 } }, /* sayama */
    { .label = { 144937,  6, 0 } }, /* sennan */
    { .label = { 144960,  6, 0 } }, /* settsu */
    { .label = {  55370, 11, 0 } }, /* shijonawate */
    { .label = {  84909,  9, 0 } }, /* shimamoto */
    { .label = { 116691,  5, 0 } }, /* suita */
    { .label = { 124270,  7, 0 } }, /* tadaoka */
    { .label = { 121388,  6, 0 } }, /* taishi */
    { .label = { 144985,  6, 0 } }, /* tajiri */
    { .label = { 104138,  8, 0 } }, /* takaishi */
    { .label = {  84947,  9, 0 } }, /* takatsuki */
    { .label = {  42398, 12, 0 } }, /* tondabayashi */
    { .label = { 104170,  8, 0 } }, /* toyonaka */
    { .label = { 145011,  6, 0 } }, /* toyono */
    { .label = {  52385,  3, 0 } }, /* yao */

    /* entries 5416 to 5441 */
    { .label = { 145037,  6, 0 } }, /* ariake */
    { .label = {  15069,  5, 0 } }, /* arita */
    { .label = { 104203,  8, 0 } }, /* fukudomi */
    { .label = { 145060,  6, 0 } }, /* genkai */
    { .label = { 104242,  8, 0 } }, /* hamatama */
    { .label = {  33200,  5, 0 } }, /* hizen */
    { .label = {  33491,  5, 0 } }, /* imari */
    { .label = { 104273,  8, 0 } }, /* kamimine */
    { .label = { 124297,  7, 0 } }, /* kanzaki */
    { .label = { 124328,  7, 0 } }, /* karatsu */
    { .label = {  85189,  7, 0 } }, /* kashima */
    { .label = {  99697,  8, 0 } }, /* kitagata */
    { .label = { 104307,  8, 0 } }, /* kitahata */
    { .label = {  69326,  6, 0 } }, /* kiyama */
    { .label = { 124356,  7, 0 } }, /* kouhoku */
    { .label = { 124389,  7, 0 } }, /* kyuragi */
    { .label = {  69510, 10, 0 } }, /* nishiarita */
    { .label = {  11610,  3, 0 } }, /* ogi */
    { .label = {  42073,  6, 0 } }, /* omachi */
    { .label = {  69356,  5, 0 } }, /* ouchi */
    { .label = {  68954,  4, 0 } }, /* saga */
    { .label = {  83701,  9, 0 } }, /* shiroishi */
    { .label = {  41589,  4, 0 } }, /* taku */
    { .label = {  25845,  4, 0 } }, /* tara */
    { .label = { 141810,  4, 0 } }, /* tosu */
    { .label = {  55418, 11, 0 } }, /* yoshinogari */

    /* entries 5442 to 5510 */
    { .label = { 124421,  7, 0 } }, /* arakawa */
    { .label = {  26078,  5, 0 } }, /* asaka */
    { .label = {  19249,  8, 0 } }, /* chichibu */
    { .label = {  54640,  6, 0 } }, /* fujimi */
    { .label = { 104338,  8, 0 } }, /* fujimino */
    { .label = { 145085,  6, 0 } }, /* fukaya */
    { .label = { 158253,  5, 0 } }, /* hanno */
    { .label = { 158273,  5, 0 } }, /* hanyu */
    { .label = { 145113,  6, 0 } }, /* hasuda */
    { .label = { 104377,  8, 0 } }, /* hatogaya */
    { .label = { 104410,  8, 0 } }, /* hatoyama */
    { .label = { 142185,  6, 0 } }, /* hidaka */
    { .label = {  19219, 15, 0 } }, /* higashichichibu */
    { .label = {  14613, 16, 0 } }, /* higashimatsuyama */
    { .label = {  81294,  5, 0 } }, /* honjo */
    { .label = {    694,  3, 0 } }, /* ina */
    { .label = { 158296,  5, 0 } }, /* iruma */
    { .label = { 104443,  8, 0 } }, /* iwatsuki */
    { .label = {  84984,  9, 0 } }, /* kamiizumi */
    { .label = { 100516,  8, 0 } }, /* kamikawa */
    { .label = { 104478,  8, 0 } }, /* kamisato */
    { .label = { 104510,  8, 0 } }, /* kasukabe */
    { .label = { 123251,  7, 0 } }, /* kawagoe */
    { .label = {  19438,  9, 0 } }, /* kawaguchi */
    { .label = { 104545,  8, 0 } }, /* kawajima */
    { .label = { 166047,  4, 0 } }, /* kazo */
    { .label = { 104581,  8, 0 } }, /* kitamoto */
    { .label = {  85026,  9, 0 } }, /* koshigaya */
    { .label = { 124448,  7, 0 } }, /* kounosu */
    { .label = {  33768,  4, 0 } }, /* kuki */
    { .label = { 104614,  8, 0 } }, /* kumagaya */
    { .label = {  69549, 10, 0 } }, /* matsubushi */
    { .label = { 145138,  6, 0 } }, /* minano */
    { .label = {  26131,  6, 0 } }, /* misato */
    { .label = {  85065,  9, 0 } }, /* miyashiro */
    { .label = {  14581,  7, 0 } }, /* miyoshi */
    { .label = { 104649,  8, 0 } }, /* moroyama */
    { .label = { 104683,  8, 0 } }, /* nagatoro */
    { .label = { 104714,  8, 0 } }, /* namegawa */
    { .label = { 158317,  5, 0 } }, /* niiza */
    { .label = {  73032,  5, 0 } }, /* ogano */
    { .label = {  19198,  5, 0 } }, /* ogawa */
    { .label = { 158339,  5, 0 } }, /* ogose */
    { .label = { 124479,  7, 0 } }, /* okegawa */
    { .label = {  41875,  5, 0 } }, /* omiya */
    { .label = { 101003,  5, 0 } }, /* otaki */
    { .label = { 145162,  6, 0 } }, /* ranzan */
    { .label = { 124509,  7, 0 } }, /* ryokami */
    { .label = { 120072,  7, 0 } }, /* saitama */
    { .label = { 145187,  6, 0 } }, /* sakado */
    { .label = { 158360,  5, 0 } }, /* satte */
    { .label = {  55346,  6, 0 } }, /* sayama */
    { .label = {  84459,  5, 0 } }, /* shiki */
    { .label = { 104747,  8, 0 } }, /* shiraoka */
    { .label = { 166066,  4, 0 } }, /* soka */
    { .label = { 145211,  6, 0 } }, /* sugito */
    { .label = {  73132,  4, 0 } }, /* toda */
    { .label = { 104779,  8, 0 } }, /* tokigawa */
    { .label = {  69594, 10, 0 } }, /* tokorozawa */
    { .label = {  42449, 12, 0 } }, /* tsurugashima */
    { .label = { 158379,  5, 0 } }, /* urawa */
    { .label = { 145237,  6, 0 } }, /* warabi */
    { .label = { 145263,  6, 0 } }, /* yashio */
    { .label = { 145289,  6, 0 } }, /* yokoze */
    { .label = {  82114,  4, 0 } }, /* yono */
    { .label = { 158400,  5, 0 } }, /* yorii */
    { .label = {  55668,  7, 0 } }, /* yoshida */
    { .label = {  85104,  9, 0 } }, /* yoshikawa */
    { .label = { 124540,  7, 0 } }, /* yoshimi */

    /* entries 5511 to 5533 */
    { .label = { 158422,  5, 0 } }, /* aisho */
    { .label = {   8631,  4, 0 } }, /* gamo */
    { .label = {  69638, 10, 0 } }, /* higashiomi */
    { .label = { 145319,  6, 0 } }, /* hikone */
    { .label = { 166082,  4, 0 } }, /* koka */
    { .label = { 156208,  5, 0 } }, /* konan */
    { .label = { 158442,  5, 0 } }, /* kosei */
    { .label = { 101924,  4, 0 } }, /* koto */
    { .label = { 121662,  7, 0 } }, /* kusatsu */
    { .label = { 124572,  7, 0 } }, /* maibara */
    { .label = { 104813,  8, 0 } }, /* moriyama */
    { .label = { 104847,  8, 0 } }, /* nagahama */
    { .label = {  85144,  9, 0 } }, /* nishiazai */
    { .label = { 104878,  8, 0 } }, /* notogawa */
    { .label = {  55465, 11, 0 } }, /* omihachiman */
    { .label = {  26138,  4, 0 } }, /* otsu */
    { .label = { 158463,  5, 0 } }, /* ritto */
    { .label = { 158483,  5, 0 } }, /* ryuoh */
    { .label = {  85182,  9, 0 } }, /* takashima */
    { .label = {  84947,  9, 0 } }, /* takatsuki */
    { .label = { 104911,  8, 0 } }, /* torahime */
    { .label = { 104944,  8, 0 } }, /* toyosato */
    { .label = {  42603,  4, 0 } }, /* yasu */

    /* entries 5534 to 5556 */
    { .label = { 144068,  5, 0 } }, /* akagi */
    { .label = {  14670,  3, 0 } }, /* ama */
    { .label = { 158507,  5, 0 } }, /* gotsu */
    { .label = { 145345,  6, 0 } }, /* hamada */
    { .label = {  42500, 12, 0 } }, /* higashiizumo */
    { .label = {  26105,  6, 0 } }, /* hikawa */
    { .label = { 145369,  6, 0 } }, /* hikimi */
    { .label = {  42530,  5, 0 } }, /* izumo */
    { .label = { 104977,  8, 0 } }, /* kakinoki */
    { .label = { 145396,  6, 0 } }, /* masuda */
    { .label = { 145421,  6, 0 } }, /* matsue */
    { .label = {  26131,  6, 0 } }, /* misato */
    { .label = {  42555, 12, 0 } }, /* nishinoshima */
    { .label = { 166099,  4, 0 } }, /* ohda */
    { .label = {  69681, 10, 0 } }, /* okinoshima */
    { .label = { 105011,  8, 0 } }, /* okuizumo */
    { .label = { 120098,  7, 0 } }, /* shimane */
    { .label = { 145446,  6, 0 } }, /* tamayu */
    { .label = { 124600,  7, 0 } }, /* tsuwano */
    { .label = { 158529,  5, 0 } }, /* unnan */
    { .label = { 142487,  6, 0 } }, /* yakumo */
    { .label = { 145472,  6, 0 } }, /* yasugi */
    { .label = { 124630,  7, 0 } }, /* yatsuka */

    /* entries 5557 to 5592 */
    { .label = {  35882,  4, 0 } }, /* arai */
    { .label = {  99718,  5, 0 } }, /* atami */
    { .label = {  19416,  4, 0 } }, /* fuji */
    { .label = { 124660,  7, 0 } }, /* fujieda */
    { .label = {  19416,  8, 0 } }, /* fujikawa */
    { .label = {  69723, 10, 0 } }, /* fujinomiya */
    { .label = { 124694,  7, 0 } }, /* fukuroi */
    { .label = { 124727,  7, 0 } }, /* gotemba */
    { .label = { 124758,  7, 0 } }, /* haibara */
    { .label = {  85218,  9, 0 } }, /* hamamatsu */
    { .label = {  42500, 10, 0 } }, /* higashiizu */
    { .label = {   3876,  3, 0 } }, /* ito */
    { .label = { 158549,  5, 0 } }, /* iwata */
    { .label = {  33284,  3, 0 } }, /* izu */
    { .label = {  85255,  9, 0 } }, /* izunokuni */
    { .label = { 105050,  8, 0 } }, /* kakegawa */
    { .label = { 124786,  7, 0 } }, /* kannami */
    { .label = {  85297,  9, 0 } }, /* kawanehon */
    { .label = { 145499,  6, 0 } }, /* kawazu */
    { .label = { 105084,  8, 0 } }, /* kikugawa */
    { .label = { 112354,  5, 0 } }, /* kosai */
    { .label = {  69771, 10, 0 } }, /* makinohara */
    { .label = {  85335,  9, 0 } }, /* matsuzaki */
    { .label = {  85375,  9, 0 } }, /* minamiizu */
    { .label = { 121267,  7, 0 } }, /* mishima */
    { .label = {  85416,  9, 0 } }, /* morimachi */
    { .label = { 105120,  8, 0 } }, /* nishiizu */
    { .label = { 145528,  6, 0 } }, /* numazu */
    { .label = { 105157,  8, 0 } }, /* omaezaki */
    { .label = { 124814,  7, 0 } }, /* shimada */
    { .label = {  54961,  7, 0 } }, /* shimizu */
    { .label = {  83093,  7, 0 } }, /* shimoda */
    { .label = {  98284,  8, 0 } }, /* shizuoka */
    { .label = { 145557,  6, 0 } }, /* susono */
    { .label = { 121423,  5, 0 } }, /* yaizu */
    { .label = {  55668,  7, 0 } }, /* yoshida */

    /* entries 5593 to 5623 */
    { .label = {  33572,  8, 0 } }, /* ashikaga */
    { .label = {  38416,  4, 0 } }, /* bato */
    { .label = {  99545,  4, 0 } }, /* haga */
    { .label = { 124843,  7, 0 } }, /* ichikai */
    { .label = { 124873,  7, 0 } }, /* iwafune */
    { .label = {  69811, 10, 0 } }, /* kaminokawa */
    { .label = { 145582,  6, 0 } }, /* kanuma */
    { .label = {  69853, 10, 0 } }, /* karasuyama */
    { .label = { 124905,  7, 0 } }, /* kuroiso */
    { .label = { 124935,  7, 0 } }, /* mashiko */
    { .label = { 166116,  4, 0 } }, /* mibu */
    { .label = {  82612,  4, 0 } }, /* moka */
    { .label = { 145607,  6, 0 } }, /* motegi */
    { .label = {  35769,  4, 0 } }, /* nasu */
    { .label = {  42605, 12, 0 } }, /* nasushiobara */
    { .label = { 158569,  5, 0 } }, /* nikko */
    { .label = {  85455,  9, 0 } }, /* nishikata */
    { .label = { 166136,  4, 0 } }, /* nogi */
    { .label = { 101937,  5, 0 } }, /* ohira */
    { .label = { 105192,  8, 0 } }, /* ohtawara */
    { .label = {  14660,  5, 0 } }, /* oyama */
    { .label = {  68703,  6, 0 } }, /* sakura */
    { .label = {   9234,  4, 0 } }, /* sano */
    { .label = {  69894, 10, 0 } }, /* shimotsuke */
    { .label = { 145633,  6, 0 } }, /* shioya */
    { .label = {  69938, 10, 0 } }, /* takanezawa */
    { .label = { 120127,  7, 0 } }, /* tochigi */
    { .label = {  54241,  5, 0 } }, /* tsuga */
    { .label = { 158591,  5, 0 } }, /* ujiie */
    { .label = {  69980, 10, 0 } }, /* utsunomiya */
    { .label = { 158615,  5, 0 } }, /* yaita */

    /* entries 5624 to 5640 */
    { .label = {  68373,  6, 0 } }, /* aizumi */
    { .label = {  14706,  4, 0 } }, /* anan */
    { .label = {  68216,  6, 0 } }, /* ichiba */
    { .label = { 158635,  5, 0 } }, /* itano */
    { .label = { 145659,  6, 0 } }, /* kainan */
    { .label = {  42654, 12, 0 } }, /* komatsushima */
    { .label = {  70024, 10, 0 } }, /* matsushige */
    { .label = {  27070,  4, 0 } }, /* mima */
    { .label = {  19090,  6, 0 } }, /* minami */
    { .label = {  14581,  7, 0 } }, /* miyoshi */
    { .label = {  99813,  4, 0 } }, /* mugi */
    { .label = {  99307,  8, 0 } }, /* nakagawa */
    { .label = { 145682,  6, 0 } }, /* naruto */
    { .label = {  85491,  9, 0 } }, /* sanagochi */
    { .label = {  85528,  9, 0 } }, /* shishikui */
    { .label = {  80786,  9, 0 } }, /* tokushima */
    { .label = { 145706,  6, 0 } }, /* wajiki */

    /* entries 5641 to 5697 */
    { .label = { 145735,  6, 0 } }, /* adachi */
    { .label = { 124965,  7, 0 } }, /* akiruno */
    { .label = { 105224,  8, 0 } }, /* akishima */
    { .label = {  85568,  9, 0 } }, /* aogashima */
    { .label = { 124421,  7, 0 } }, /* arakawa */
    { .label = { 145760,  6, 0 } }, /* bunkyo */
    { .label = { 121540,  7, 0 } }, /* chiyoda */
    { .label = { 158654,  5, 0 } }, /* chofu */
    { .label = {  54207,  4, 0 } }, /* chuo */
    { .label = { 124994,  7, 0 } }, /* edogawa */
    { .label = { 156761,  5, 0 } }, /* fuchu */
    { .label = { 158679,  5, 0 } }, /* fussa */
    { .label = { 125024,  7, 0 } }, /* hachijo */
    { .label = { 105257,  8, 0 } }, /* hachioji */
    { .label = { 145790,  6, 0 } }, /* hamura */
    { .label = {  33946, 13, 0 } }, /* higashikurume */
    { .label = {  19288, 15, 0 } }, /* higashimurayama */
    { .label = {  34004, 13, 0 } }, /* higashiyamato */
    { .label = {  25903,  4, 0 } }, /* hino */
    { .label = { 145815,  6, 0 } }, /* hinode */
    { .label = { 105294,  8, 0 } }, /* hinohara */
    { .label = { 158701,  5, 0 } }, /* inagi */
    { .label = { 105326,  8, 0 } }, /* itabashi */
    { .label = {  70067, 10, 0 } }, /* katsushika */
    { .label = {  25979,  4, 0 } }, /* kita */
    { .label = { 145841,  6, 0 } }, /* kiyose */
    { .label = { 125057,  7, 0 } }, /* kodaira */
    { .label = { 125085,  7, 0 } }, /* koganei */
    { .label = {  85604,  9, 0 } }, /* kokubunji */
    { .label = { 158721,  5, 0 } }, /* komae */
    { .label = { 101924,  4, 0 } }, /* koto */
    { .label = {  70109, 10, 0 } }, /* kouzushima */
    { .label = {  85649,  9, 0 } }, /* kunitachi */
    { .label = { 125114,  7, 0 } }, /* machida */
    { .label = { 145868,  6, 0 } }, /* meguro */
    { .label = {  55531,  6, 0 } }, /* minato */
    { .label = { 103077,  6, 0 } }, /* mitaka */
    { .label = { 145895,  6, 0 } }, /* mizuho */
    { .label = {  19352, 15, 0 } }, /* musashimurayama */
    { .label = {  85688,  9, 0 } }, /* musashino */
    { .label = {  99935,  6, 0 } }, /* nakano */
    { .label = { 145925,  6, 0 } }, /* nerima */
    { .label = {  85726,  9, 0 } }, /* ogasawara */
    { .label = { 125144,  7, 0 } }, /* okutama */
    { .label = {   3950,  3, 0 } }, /* ome */
    { .label = {  11092,  6, 0 } }, /* oshima */
    { .label = {   6439,  3, 0 } }, /* ota */
    { .label = { 105359,  8, 0 } }, /* setagaya */
    { .label = { 125173,  7, 0 } }, /* shibuya */
    { .label = {  85761,  9, 0 } }, /* shinagawa */
    { .label = { 105391,  8, 0 } }, /* shinjuku */
    { .label = { 105430,  8, 0 } }, /* suginami */
    { .label = { 140445,  6, 0 } }, /* sumida */
    { .label = {  85798,  9, 0 } }, /* tachikawa */
    { .label = { 158742,  5, 0 } }, /* taito */
    { .label = {  23268,  4, 0 } }, /* tama */
    { .label = {  11088,  7, 0 } }, /* toshima */

    /* entries 5698 to 5710 */
    { .label = {  83984,  5, 0 } }, /* chizu */
    { .label = {  25903,  4, 0 } }, /* hino */
    { .label = { 105464,  8, 0 } }, /* kawahara */
    { .label = {   1283,  4, 0 } }, /* koge */
    { .label = { 125206,  7, 0 } }, /* kotoura */
    { .label = { 145949,  6, 0 } }, /* misasa */
    { .label = { 158761,  5, 0 } }, /* nanbu */
    { .label = { 103019,  8, 0 } }, /* nichinan */
    { .label = {  55512, 11, 0 } }, /* sakaiminato */
    { .label = { 120158,  7, 0 } }, /* tottori */
    { .label = { 141219,  6, 0 } }, /* wakasa */
    { .label = { 143297,  4, 0 } }, /* yazu */
    { .label = { 145972,  6, 0 } }, /* yonago */

    /* entries 5711 to 5734 */
    { .label = {  67971,  5, 0 } }, /* asahi */
    { .label = { 156761,  5, 0 } }, /* fuchu */
    { .label = {  85836,  9, 0 } }, /* fukumitsu */
    { .label = {  85879,  9, 0 } }, /* funahashi */
    { .label = {  54965,  4, 0 } }, /* himi */
    { .label = {  54970,  5, 0 } }, /* imizu */
    { .label = {  19095,  5, 0 } }, /* inami */
    { .label = { 145998,  6, 0 } }, /* johana */
    { .label = { 105496,  8, 0 } }, /* kamiichi */
    { .label = { 146024,  6, 0 } }, /* kurobe */
    { .label = {  55555, 11, 0 } }, /* nakaniikawa */
    { .label = {  70156, 10, 0 } }, /* namerikawa */
    { .label = {  78102,  5, 0 } }, /* nanto */
    { .label = { 146052,  6, 0 } }, /* nyuzen */
    { .label = { 158783,  5, 0 } }, /* oyabe */
    { .label = { 158806,  5, 0 } }, /* taira */
    { .label = { 125235,  7, 0 } }, /* takaoka */
    { .label = {  98934,  8, 0 } }, /* tateyama */
    { .label = {  54246,  4, 0 } }, /* toga */
    { .label = {  99024,  6, 0 } }, /* tonami */
    { .label = {  14656,  6, 0 } }, /* toyama */
    { .label = { 125262,  7, 0 } }, /* unazuki */
    { .label = { 166153,  4, 0 } }, /* uozu */
    { .label = { 141544,  6, 0 } }, /* yamada */

    /* entries 5735 to 5763 */
    { .label = {  85918,  5, 0 } }, /* arida */
    { .label = {  85918,  9, 0 } }, /* aridagawa */
    { .label = { 162273,  4, 0 } }, /* gobo */
    { .label = {  85954,  9, 0 } }, /* hashimoto */
    { .label = { 142185,  6, 0 } }, /* hidaka */
    { .label = { 105531,  8, 0 } }, /* hirogawa */
    { .label = {  19095,  5, 0 } }, /* inami */
    { .label = { 158824,  5, 0 } }, /* iwade */
    { .label = { 145659,  6, 0 } }, /* kainan */
    { .label = {  85992,  9, 0 } }, /* kamitonda */
    { .label = {  84206,  9, 0 } }, /* katsuragi */
    { .label = { 146082,  6, 0 } }, /* kimino */
    { .label = { 105565,  8, 0 } }, /* kinokawa */
    { .label = {  33859,  8, 0 } }, /* kitayama */
    { .label = { 159737,  4, 0 } }, /* koya */
    { .label = { 105599,  4, 0 } }, /* koza */
    { .label = { 105599,  8, 0 } }, /* kozagawa */
    { .label = { 105635,  8, 0 } }, /* kudoyama */
    { .label = {  86029,  9, 0 } }, /* kushimoto */
    { .label = { 104233,  6, 0 } }, /* mihama */
    { .label = {  26131,  6, 0 } }, /* misato */
    { .label = {  34059, 13, 0 } }, /* nachikatsuura */
    { .label = { 141467,  6, 0 } }, /* shingu */
    { .label = {  86069,  9, 0 } }, /* shirahama */
    { .label = { 158846,  5, 0 } }, /* taiji */
    { .label = {  83447,  6, 0 } }, /* tanabe */
    { .label = {  98321,  8, 0 } }, /* wakayama */
    { .label = { 158868,  5, 0 } }, /* yuasa */
    { .label = { 124394,  4, 0 } }, /* yura */

    /* entries 5764 to 5797 */
    { .label = {  67971,  5, 0 } }, /* asahi */
    { .label = { 105671,  8, 0 } }, /* funagata */
    { .label = {  86105,  9, 0 } }, /* higashine */
    { .label = {  27042,  4, 0 } }, /* iide */
    { .label = { 142202,  6, 0 } }, /* kahoku */
    { .label = {  70197, 10, 0 } }, /* kaminoyama */
    { .label = {  99441,  8, 0 } }, /* kaneyama */
    { .label = {  82897,  9, 0 } }, /* kawanishi */
    { .label = {  70239, 10, 0 } }, /* mamurogawa */
    { .label = { 100524,  6, 0 } }, /* mikawa */
    { .label = {  19318,  8, 0 } }, /* murayama */
    { .label = { 158889,  5, 0 } }, /* nagai */
    { .label = { 105704,  8, 0 } }, /* nakayama */
    { .label = { 158908,  5, 0 } }, /* nanyo */
    { .label = {  86143,  9, 0 } }, /* nishikawa */
    { .label = {  86181,  9, 0 } }, /* obanazawa */
    { .label = {    431,  2, 0 } }, /* oe */
    { .label = {  55065,  5, 0 } }, /* oguni */
    { .label = { 146108,  6, 0 } }, /* ohkura */
    { .label = { 125295,  7, 0 } }, /* oishida */
    { .label = { 158929,  5, 0 } }, /* sagae */
    { .label = { 146134,  6, 0 } }, /* sakata */
    { .label = { 105736,  8, 0 } }, /* sakegawa */
    { .label = { 144288,  6, 0 } }, /* shinjo */
    { .label = {  86220,  9, 0 } }, /* shirataka */
    { .label = { 141494,  6, 0 } }, /* shonai */
    { .label = { 105769,  8, 0 } }, /* takahata */
    { .label = {  16711,  5, 0 } }, /* tendo */
    { .label = {  81448,  6, 0 } }, /* tozawa */
    { .label = { 105799,  8, 0 } }, /* tsuruoka */
    { .label = {  98355,  8, 0 } }, /* yamagata */
    { .label = { 105833,  8, 0 } }, /* yamanobe */
    { .label = { 105868,  8, 0 } }, /* yonezawa */
    { .label = { 144469,  4, 0 } }, /* yuza */

    /* entries 5798 to 5813 */
    { .label = {  14201,  3, 0 } }, /* abu */
    { .label = { 101459,  4, 0 } }, /* hagi */
    { .label = {  19003,  6, 0 } }, /* hikari */
    { .label = { 158659,  4, 0 } }, /* hofu */
    { .label = { 125324,  7, 0 } }, /* iwakuni */
    { .label = {  86255,  9, 0 } }, /* kudamatsu */
    { .label = { 158948,  5, 0 } }, /* mitou */
    { .label = { 104683,  6, 0 } }, /* nagato */
    { .label = {  11092,  6, 0 } }, /* oshima */
    { .label = {  55599, 11, 0 } }, /* shimonoseki */
    { .label = { 146156,  6, 0 } }, /* shunan */
    { .label = { 146181,  6, 0 } }, /* tabuse */
    { .label = { 105905,  8, 0 } }, /* tokuyama */
    { .label = { 140412,  6, 0 } }, /* toyota */
    { .label = {  20181,  3, 0 } }, /* ube */
    { .label = { 135646,  3, 0 } }, /* yuu */

    /* entries 5814 to 5841 */
    { .label = {  54207,  4, 0 } }, /* chuo */
    { .label = { 158970,  5, 0 } }, /* doshi */
    { .label = { 125355,  7, 0 } }, /* fuefuki */
    { .label = {  19416,  8, 0 } }, /* fujikawa */
    { .label = {  19416, 15, 0 } }, /* fujikawaguchiko */
    { .label = {  55646, 11, 0 } }, /* fujiyoshida */
    { .label = { 105940,  8, 0 } }, /* hayakawa */
    { .label = { 142210,  6, 0 } }, /* hokuto */
    { .label = {  26096, 14, 0 } }, /* ichikawamisato */
    { .label = {   1662,  3, 0 } }, /* kai */
    { .label = { 128176,  4, 0 } }, /* kofu */
    { .label = { 158992,  5, 0 } }, /* koshu */
    { .label = { 146207,  6, 0 } }, /* kosuge */
    { .label = {  55699, 11, 0 } }, /* minami-alps */
    { .label = { 146234,  6, 0 } }, /* minobu */
    { .label = {  86294,  9, 0 } }, /* nakamichi */
    { .label = { 158761,  5, 0 } }, /* nanbu */
    { .label = { 105974,  8, 0 } }, /* narusawa */
    { .label = { 106006,  8, 0 } }, /* nirasaki */
    { .label = {  42705, 12, 0 } }, /* nishikatsura */
    { .label = {  25895,  6, 0 } }, /* oshino */
    { .label = { 143131,  6, 0 } }, /* otsuki */
    { .label = { 156614,  5, 0 } }, /* showa */
    { .label = { 106037,  8, 0 } }, /* tabayama */
    { .label = {  42449,  5, 0 } }, /* tsuru */
    { .label = { 106070,  8, 0 } }, /* uenohara */
    { .label = {  70282, 10, 0 } }, /* yamanakako */
    { .label = {  80866,  9, 0 } }, /* yamanashi */

    /* entries 5842 to 5844 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {  96486,  4, 1 } }, { .child = { 5845, 1 } }, /* city */

    /* entry 5845 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 5846 to 5848 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {  96486,  4, 1 } }, { .child = { 5849, 1 } }, /* city */

    /* entry 5849 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 5850 to 5852 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {  96486,  4, 1 } }, { .child = { 5853, 1 } }, /* city */

    /* entry 5853 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 5854 to 5856 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {  96486,  4, 1 } }, { .child = { 5857, 1 } }, /* city */

    /* entry 5857 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 5858 to 5860 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {  96486,  4, 1 } }, { .child = { 5861, 1 } }, /* city */

    /* entry 5861 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 5862 to 5864 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {  96486,  4, 1 } }, { .child = { 5865, 1 } }, /* city */

    /* entry 5865 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 5866 to 5868 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {  96486,  4, 1 } }, { .child = { 5869, 1 } }, /* city */

    /* entry 5869 */
    { .label = {     11,  1, 0 } }, /* ! */

    /* entries 5870 to 5880 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 1 } }, { .child = { 5881, 1 } }, /* co */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {    591,  2, 0 } }, /* me */
    { .label = {  10207,  4, 0 } }, /* mobi */
    { .label = {     40,  2, 0 } }, /* ne */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {     17,  2, 0 } }, /* sc */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entry 5881 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 5882 to 5887 */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3679,  3, 0 } }, /* mil */

    /* entry 5888 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 5889 to 5895 */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  54555,  3, 0 } }, /* biz */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {    106,  3, 0 } }, /* com */

    /* entries 5896 to 5912 */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  25342,  3, 0 } }, /* nom */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  98602,  3, 0 } }, /* prd */
    { .label = {   2425,  2, 0 } }, /* tm */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {   2729,  3, 0 } }, /* ass */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  51529,  4, 0 } }, /* coop */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = { 139248,  6, 0 } }, /* presse */
    { .label = { 118708,  7, 0 } }, /* medecin */
    { .label = {  97399,  8, 0 } }, /* notaires */
    { .label = {  55747, 11, 0 } }, /* pharmaciens */
    { .label = {  51669, 11, 0 } }, /* veterinaire */
    { .label = { 165542,  4, 0 } }, /* gouv */

    /* entries 5913 to 5916 */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entries 5917 to 5922 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  24172,  3, 0 } }, /* rep */
    { .label = {   3068,  3, 0 } }, /* tra */

    /* entries 5923 to 5952 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    141,  2, 0 } }, /* es */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {    307,  2, 0 } }, /* hs */
    { .label = {    740,  2, 0 } }, /* kg */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {    126,  2, 0 } }, /* ms */
    { .label = {     40,  2, 0 } }, /* ne */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {    552,  2, 0 } }, /* pe */
    { .label = {     55,  2, 0 } }, /* re */
    { .label = {     17,  2, 0 } }, /* sc */
    { .label = {  71282,  5, 0 } }, /* busan */
    { .label = { 106102,  8, 0 } }, /* chungbuk */
    { .label = { 106142,  8, 0 } }, /* chungnam */
    { .label = { 159015,  5, 0 } }, /* daegu */
    { .label = { 125390,  7, 0 } }, /* daejeon */
    { .label = { 125421,  7, 0 } }, /* gangwon */
    { .label = { 125452,  7, 0 } }, /* gwangju */
    { .label = {  86332,  9, 0 } }, /* gyeongbuk */
    { .label = { 106178,  8, 0 } }, /* gyeonggi */
    { .label = {  86376,  9, 0 } }, /* gyeongnam */
    { .label = { 125487,  7, 0 } }, /* incheon */
    { .label = { 166174,  4, 0 } }, /* jeju */
    { .label = { 125517,  7, 0 } }, /* jeonbuk */
    { .label = { 125552,  7, 0 } }, /* jeonnam */
    { .label = { 159037,  5, 0 } }, /* seoul */
    { .label = {   2312,  5, 0 } }, /* ulsan */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 5953 to 5959 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  15097,  3, 0 } }, /* emb */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   8838,  3, 0 } }, /* ind */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 5960 to 5964 */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  16771,  3, 0 } }, /* net */

    /* entries 5965 to 5971 */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  43390,  3, 0 } }, /* nym */

    /* entries 5972 to 5982 */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   5389,  3, 0 } }, /* per */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   2762,  3, 0 } }, /* bnr */
    { .label = {     21,  1, 0 } }, /* c */
    { .label = {  43390,  3, 0 } }, /* nym */

    /* entries 5983 to 5987 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 5988 to 5995 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  43390,  3, 0 } }, /* nym */
    { .label = {    224,  2, 0 } }, /* oy */

    /* entries 5996 to 5998 */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  25342,  3, 0 } }, /* nom */
    { .label = {  43390,  3, 0 } }, /* nym */

    /* entries 5999 to 6013 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   6667,  3, 0 } }, /* sch */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  10027,  3, 0 } }, /* ngo */
    { .label = {   2773,  3, 0 } }, /* soc */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = { 129382,  3, 0 } }, /* ltd */
    { .label = { 166197,  4, 0 } }, /* assn */
    { .label = { 169299,  3, 0 } }, /* grp */
    { .label = {  60068,  5, 0 } }, /* hotel */
    { .label = {    103,  2, 0 } }, /* ac */

    /* entries 6014 to 6018 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  16771,  3, 0 } }, /* net */

    /* entries 6019 to 6020 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 6021 to 6023 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  43390,  3, 0 } }, /* nym */

    /* entries 6024 to 6025 */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  43390,  3, 0 } }, /* nym */

    /* entries 6026 to 6034 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {     86,  2, 0 } }, /* id */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {   6682,  3, 0 } }, /* asn */
    { .label = {  64159,  4, 0 } }, /* conf */

    /* entries 6035 to 6043 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  13187,  3, 0 } }, /* plc */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   6667,  3, 0 } }, /* sch */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {     86,  2, 0 } }, /* id */

    /* entries 6044 to 6049 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  22790,  5, 0 } }, /* press */

    /* entries 6050 to 6051 */
    { .label = {   2425,  2, 0 } }, /* tm */
    { .label = {   2766,  4, 0 } }, /* asso */

    /* entry 6052 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 6053 to 6084 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  11293,  3, 0 } }, /* its */
    { .label = {   1461,  4, 0 } }, /* priv */
    { .label = { 169499,  3, 0 } }, /* c66 */
    { .label = { 153850,  6, 1 } }, { .child = { 6085, 1 } }, /* daplie */
    { .label = { 116536,  8, 0 } }, /* filegear */
    { .label = {  95786,  7, 0 } }, /* ravendb */
    { .label = {  64744,  5, 0 } }, /* barsy */
    { .label = {  95977,  9, 0 } }, /* soundcast */
    { .label = { 168815,  4, 0 } }, /* tcp4 */
    { .label = { 117090,  8, 0 } }, /* brasilia */
    { .label = { 115056,  4, 0 } }, /* ddns */
    { .label = { 135288,  6, 0 } }, /* dnsfor */
    { .label = { 165038,  5, 0 } }, /* hopto */
    { .label = { 138146,  7, 0 } }, /* loginto */
    { .label = { 166930,  4, 0 } }, /* noip */
    { .label = { 154070,  6, 0 } }, /* webhop */
    { .label = {  43390,  3, 0 } }, /* nym */
    { .label = {   5493, 11, 0 } }, /* diskstation */
    { .label = { 138395,  7, 0 } }, /* dscloud */
    { .label = { 168891,  4, 0 } }, /* i234 */
    { .label = { 168920,  4, 0 } }, /* myds */
    { .label = {   5450,  8, 0 } }, /* synology */
    { .label = { 117827,  8, 0 } }, /* wedeploy */
    { .label = { 165430,  5, 0 } }, /* yombo */
    { .label = { 155348,  6, 0 } }, /* nohost */

    /* entry 6085 */
    { .label = {  94668,  9, 0 } }, /* localhost */

    /* entries 6086 to 6094 */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  25342,  3, 0 } }, /* nom */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  98602,  3, 0 } }, /* prd */
    { .label = {   2425,  2, 0 } }, /* tm */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {     42,  2, 0 } }, /* co */

    /* entries 6095 to 6103 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   5417,  3, 0 } }, /* inf */
    { .label = {  29414,  4, 0 } }, /* name */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entries 6104 to 6110 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = { 165542,  4, 0 } }, /* gouv */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 139248,  6, 0 } }, /* presse */

    /* entry 6111 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 6112 to 6116 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 114299,  3, 0 } }, /* nyc */
    { .label = {  43390,  3, 0 } }, /* nym */

    /* entries 6117 to 6121 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entries 6122 to 6123 */
    { .label = {  64744,  5, 0 } }, /* barsy */
    { .label = { 138395,  7, 0 } }, /* dscloud */

    /* entries 6124 to 6125 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 6126 to 6130 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 6131 to 6135 */
    { .label = {    106,  3, 1 } }, { .child = { 6136, 1 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entry 6136 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 6137 to 6143 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {     47,  2, 0 } }, /* or */

    /* entries 6144 to 6691 */
    { .label = { 125583,  7, 0 } }, /* academy */
    { .label = {  55794, 11, 0 } }, /* agriculture */
    { .label = {   2836,  3, 0 } }, /* air */
    { .label = { 106215,  8, 0 } }, /* airguard */
    { .label = { 125614,  7, 0 } }, /* alabama */
    { .label = { 146262,  6, 0 } }, /* alaska */
    { .label = {  87885,  5, 0 } }, /* amber */
    { .label = {  79872,  9, 0 } }, /* ambulance */
    { .label = {  14681,  8, 0 } }, /* american */
    { .label = {  14681,  9, 0 } }, /* americana */
    { .label = {  14681, 16, 0 } }, /* americanantiques */
    { .label = {  55842, 11, 0 } }, /* americanart */
    { .label = {  86416,  9, 0 } }, /* amsterdam */
    { .label = {    351,  3, 0 } }, /* and */
    { .label = {  86453,  9, 0 } }, /* annefrank */
    { .label = {  42754,  6, 0 } }, /* anthro */
    { .label = {  42754, 12, 0 } }, /* anthropology */
    { .label = {  14713,  8, 0 } }, /* antiques */
    { .label = { 106248,  8, 0 } }, /* aquarium */
    { .label = {  86490,  9, 0 } }, /* arboretum */
    { .label = {  26155, 14, 0 } }, /* archaeological */
    { .label = {  55885, 11, 0 } }, /* archaeology */
    { .label = {  42808, 12, 0 } }, /* architecture */
    { .label = {   7867,  3, 0 } }, /* art */
    { .label = {  42859, 12, 0 } }, /* artanddesign */
    { .label = {  86529,  9, 0 } }, /* artcenter */
    { .label = { 125642,  7, 0 } }, /* artdeco */
    { .label = {  42908, 12, 0 } }, /* arteducation */
    { .label = {  70323, 10, 0 } }, /* artgallery */
    { .label = {   7867,  4, 0 } }, /* arts */
    { .label = {  34113, 13, 0 } }, /* artsandcrafts */
    { .label = { 106285,  8, 0 } }, /* asmatart */
    { .label = {  34166, 13, 0 } }, /* assassination */
    { .label = { 146285,  6, 0 } }, /* assisi */
    { .label = {   2766, 11, 0 } }, /* association */
    { .label = {  86565,  9, 0 } }, /* astronomy */
    { .label = { 125671,  7, 0 } }, /* atlanta */
    { .label = {  23566,  6, 0 } }, /* austin */
    { .label = {  86603,  9, 0 } }, /* australia */
    { .label = {  70366, 10, 0 } }, /* automotive */
    { .label = {  32013,  8, 0 } }, /* aviation */
    { .label = {  63495,  4, 0 } }, /* axis */
    { .label = { 125697,  7, 0 } }, /* badajoz */
    { .label = { 125732,  7, 0 } }, /* baghdad */
    { .label = {  39382,  4, 0 } }, /* bahn */
    { .label = {  24184,  4, 0 } }, /* bale */
    { .label = {  86638,  9, 0 } }, /* baltimore */
    { .label = {  86677,  9, 0 } }, /* barcelona */
    { .label = { 106315,  8, 0 } }, /* baseball */
    { .label = { 159059,  5, 0 } }, /* basel */
    { .label = { 159081,  5, 0 } }, /* baths */
    { .label = { 146308,  6, 0 } }, /* bauern */
    { .label = {  86715,  9, 0 } }, /* beauxarts */
    { .label = {  34215, 13, 0 } }, /* beeldengeluid */
    { .label = { 106351,  8, 0 } }, /* bellevue */
    { .label = { 125764,  7, 0 } }, /* bergbau */
    { .label = { 106390,  8, 0 } }, /* berkeley */
    { .label = { 146334,  6, 0 } }, /* berlin */
    { .label = {  51635,  4, 0 } }, /* bern */
    { .label = { 159103,  5, 0 } }, /* bible */
    { .label = { 146361,  6, 0 } }, /* bilbao */
    { .label = { 166212,  4, 0 } }, /* bill */
    { .label = { 125797,  7, 0 } }, /* birdart */
    { .label = {  70409, 10, 0 } }, /* birthplace */
    { .label = { 166232,  4, 0 } }, /* bonn */
    { .label = { 146389,  6, 0 } }, /* boston */
    { .label = {  19488,  9, 0 } }, /* botanical */
    { .label = {  19488, 15, 0 } }, /* botanicalgarden */
    { .label = {  34275, 13, 0 } }, /* botanicgarden */
    { .label = { 146415,  6, 0 } }, /* botany */
    { .label = {  14749, 16, 0 } }, /* brandywinevalley */
    { .label = { 117090,  6, 0 } }, /* brasil */
    { .label = { 125827,  7, 0 } }, /* bristol */
    { .label = {  19551,  7, 0 } }, /* british */
    { .label = {  19551, 15, 0 } }, /* britishcolumbia */
    { .label = {  86754,  9, 0 } }, /* broadcast */
    { .label = { 146442,  6, 0 } }, /* brunel */
    { .label = { 106428,  7, 0 } }, /* brussel */
    { .label = { 106428,  8, 0 } }, /* brussels */
    { .label = {  86792,  9, 0 } }, /* bruxelles */
    { .label = { 106464,  8, 0 } }, /* building */
    { .label = { 125858,  7, 0 } }, /* burghof */
    { .label = {   2959,  3, 0 } }, /* bus */
    { .label = { 146470,  6, 0 } }, /* bushey */
    { .label = { 106502,  8, 0 } }, /* cadaques */
    { .label = {  70455, 10, 0 } }, /* california */
    { .label = {  86835,  9, 0 } }, /* cambridge */
    { .label = {  14701,  3, 0 } }, /* can */
    { .label = { 146500,  6, 0 } }, /* canada */
    { .label = {  70497, 10, 0 } }, /* capebreton */
    { .label = { 125893,  7, 0 } }, /* carrier */
    { .label = {  70541, 10, 0 } }, /* cartoonart */
    { .label = {  26214, 14, 0 } }, /* casadelamoneda */
    { .label = { 146523,  6, 0 } }, /* castle */
    { .label = { 125921,  7, 0 } }, /* castres */
    { .label = {  23976,  6, 0 } }, /* celtic */
    { .label = {  26428,  6, 0 } }, /* center */
    { .label = {  55933, 11, 0 } }, /* chattanooga */
    { .label = {  70580, 10, 0 } }, /* cheltenham */
    { .label = {  34330, 13, 0 } }, /* chesapeakebay */
    { .label = { 125949,  7, 0 } }, /* chicago */
    { .label = {  19619,  8, 0 } }, /* children */
    { .label = {  19619,  9, 0 } }, /* childrens */
    { .label = {  19619, 15, 0 } }, /* childrensgarden */
    { .label = {  42957, 12, 0 } }, /* chiropractic */
    { .label = {  86876,  9, 0 } }, /* chocolate */
    { .label = {  26271, 14, 0 } }, /* christiansburg */
    { .label = {  70624, 10, 0 } }, /* cincinnati */
    { .label = { 146548,  6, 0 } }, /* cinema */
    { .label = { 146573,  6, 0 } }, /* circus */
    { .label = {  43010, 12, 0 } }, /* civilisation */
    { .label = {  43061, 12, 0 } }, /* civilization */
    { .label = { 106539,  8, 0 } }, /* civilwar */
    { .label = { 125980,  7, 0 } }, /* clinton */
    { .label = {  20390,  5, 0 } }, /* clock */
    { .label = {  31680,  4, 0 } }, /* coal */
    { .label = {  26332, 14, 0 } }, /* coastaldefence */
    { .label = { 166250,  4, 0 } }, /* cody */
    { .label = { 126010,  7, 0 } }, /* coldwar */
    { .label = {  70665, 10, 0 } }, /* collection */
    { .label = {   4201, 20, 0 } }, /* colonialwilliamsburg */
    { .label = {  19684, 15, 0 } }, /* coloradoplateau */
    { .label = {  19582,  8, 0 } }, /* columbia */
    { .label = { 106576,  8, 0 } }, /* columbus */
    { .label = {    385, 13, 0 } }, /* communication */
    { .label = {    385, 14, 0 } }, /* communications */
    { .label = {  86915,  9, 0 } }, /* community */
    { .label = {  19748,  8, 0 } }, /* computer */
    { .label = {  19748, 15, 0 } }, /* computerhistory */
    { .label = {   4291, 20, 0 } }, /* xn--comunicaes-v6a2o */
    { .label = {  19816, 12, 0 } }, /* contemporary */
    { .label = {  19816, 15, 0 } }, /* contemporaryart */
    { .label = { 126042,  7, 0 } }, /* convent */
    { .label = {  70709, 10, 0 } }, /* copenhagen */
    { .label = {  55977, 11, 0 } }, /* corporation */
    { .label = {     22, 36, 0 } }, /* xn--correios-e-telecomunicaes-ghc29a */
    { .label = { 106615,  8, 0 } }, /* corvette */
    { .label = { 126073,  7, 0 } }, /* costume */
    { .label = {  20222, 13, 0 } }, /* countryestate */
    { .label = { 146600,  6, 0 } }, /* county */
    { .label = {  34140,  6, 0 } }, /* crafts */
    { .label = {  86957,  9, 0 } }, /* cranbrook */
    { .label = {  66032,  8, 0 } }, /* creation */
    { .label = {  26392,  8, 0 } }, /* cultural */
    { .label = {  26392, 14, 0 } }, /* culturalcenter */
    { .label = {  55810,  7, 0 } }, /* culture */
    { .label = { 159128,  5, 0 } }, /* cyber */
    { .label = { 159153,  5, 0 } }, /* cymru */
    { .label = {  43773,  4, 0 } }, /* dali */
    { .label = { 146628,  6, 0 } }, /* dallas */
    { .label = { 106650,  8, 0 } }, /* database */
    { .label = {  12562,  3, 0 } }, /* ddr */
    { .label = {  15174, 14, 0 } }, /* decorativearts */
    { .label = {  20179,  8, 0 } }, /* delaware */
    { .label = {  56023, 11, 0 } }, /* delmenhorst */
    { .label = { 126104,  7, 0 } }, /* denmark */
    { .label = {  93088,  5, 0 } }, /* depot */
    { .label = {  26610,  6, 0 } }, /* design */
    { .label = { 126134,  7, 0 } }, /* detroit */
    { .label = { 106682,  8, 0 } }, /* dinosaur */
    { .label = {  86996,  9, 0 } }, /* discovery */
    { .label = { 159178,  5, 0 } }, /* dolls */
    { .label = { 106715,  8, 0 } }, /* donostia */
    { .label = { 146653,  6, 0 } }, /* durham */
    { .label = {  70753, 10, 0 } }, /* eastafrica */
    { .label = {  87038,  9, 0 } }, /* eastcoast */
    { .label = {  42919,  9, 0 } }, /* education */
    { .label = {  56071, 11, 0 } }, /* educational */
    { .label = { 106747,  8, 0 } }, /* egyptian */
    { .label = {  87073,  9, 0 } }, /* eisenbahn */
    { .label = { 146680,  6, 0 } }, /* elburg */
    { .label = {  70793, 10, 0 } }, /* elvendrell */
    { .label = {  70839, 10, 0 } }, /* embroidery */
    { .label = {  43115, 12, 0 } }, /* encyclopedic */
    { .label = { 126163,  7, 0 } }, /* england */
    { .label = {  70885, 10, 0 } }, /* entomology */
    { .label = {    561, 11, 0 } }, /* environment */
    { .label = {    561, 25, 0 } }, /* environmentalconservation */
    { .label = { 106783,  8, 0 } }, /* epilepsy */
    { .label = { 159201,  5, 0 } }, /* essex */
    { .label = {  20254,  6, 0 } }, /* estate */
    { .label = {  87111,  9, 0 } }, /* ethnology */
    { .label = { 146709,  6, 0 } }, /* exeter */
    { .label = {  70930, 10, 0 } }, /* exhibition */
    { .label = {  29356,  6, 0 } }, /* family */
    { .label = {  13412,  4, 0 } }, /* farm */
    { .label = {  34388, 13, 0 } }, /* farmequipment */
    { .label = { 126193,  7, 0 } }, /* farmers */
    { .label = {  87152,  9, 0 } }, /* farmstead */
    { .label = { 159223,  5, 0 } }, /* field */
    { .label = { 106822,  8, 0 } }, /* figueres */
    { .label = {  87190,  9, 0 } }, /* filatelia */
    { .label = {  79860,  4, 0 } }, /* film */
    { .label = { 106858,  7, 0 } }, /* fineart */
    { .label = { 106858,  8, 0 } }, /* finearts */
    { .label = { 126223,  7, 0 } }, /* finland */
    { .label = { 106891,  8, 0 } }, /* flanders */
    { .label = { 126254,  7, 0 } }, /* florida */
    { .label = { 112210,  5, 0 } }, /* force */
    { .label = {  43172, 12, 0 } }, /* fortmissoula */
    { .label = {  87228,  9, 0 } }, /* fortworth */
    { .label = {  70975, 10, 0 } }, /* foundation */
    { .label = {  87269,  9, 0 } }, /* francaise */
    { .label = {  87306,  9, 0 } }, /* frankfurt */
    { .label = {  43224, 12, 0 } }, /* franziskaner */
    { .label = {  56117, 11, 0 } }, /* freemasonry */
    { .label = { 106926,  8, 0 } }, /* freiburg */
    { .label = { 106964,  8, 0 } }, /* fribourg */
    { .label = { 132548,  4, 0 } }, /* frog */
    { .label = { 107002,  8, 0 } }, /* fundacio */
    { .label = {  87347,  9, 0 } }, /* furniture */
    { .label = {  70334,  7, 0 } }, /* gallery */
    { .label = {  19526,  6, 0 } }, /* garden */
    { .label = {  17656,  7, 0 } }, /* gateway */
    { .label = {  87387,  9, 0 } }, /* geelvinck */
    { .label = {  56165, 11, 0 } }, /* gemological */
    { .label = { 126285,  7, 0 } }, /* geology */
    { .label = { 126318,  7, 0 } }, /* georgia */
    { .label = { 126347,  7, 0 } }, /* giessen */
    { .label = { 159247,  4, 0 } }, /* glas */
    { .label = { 159247,  5, 0 } }, /* glass */
    { .label = { 159268,  5, 0 } }, /* gorge */
    { .label = {  56214, 11, 0 } }, /* grandrapids */
    { .label = { 166270,  4, 0 } }, /* graz */
    { .label = { 107038,  8, 0 } }, /* guernsey */
    { .label = {  71018, 10, 0 } }, /* halloffame */
    { .label = { 126376,  7, 0 } }, /* hamburg */
    { .label = { 126409,  7, 0 } }, /* handson */
    { .label = {   8719, 18, 0 } }, /* harvestcelebration */
    { .label = { 146735,  6, 0 } }, /* hawaii */
    { .label = {   1503,  6, 0 } }, /* health */
    { .label = {  26453, 14, 0 } }, /* heimatunduhren */
    { .label = { 146760,  6, 0 } }, /* hellas */
    { .label = { 107074,  8, 0 } }, /* helsinki */
    { .label = {  19880, 15, 0 } }, /* hembygdsforbund */
    { .label = {  15063,  8, 0 } }, /* heritage */
    { .label = { 107109,  8, 0 } }, /* histoire */
    { .label = {  11117, 10, 0 } }, /* historical */
    { .label = {  11117, 17, 0 } }, /* historicalsociety */
    { .label = {  26514, 14, 0 } }, /* historichouses */
    { .label = {   6638, 10, 0 } }, /* historisch */
    { .label = {   6638, 12, 0 } }, /* historisches */
    { .label = {   4417,  7, 0 } }, /* history */
    { .label = {  14824, 16, 0 } }, /* historyofscience */
    { .label = { 107142,  8, 0 } }, /* horology */
    { .label = {  26548,  5, 0 } }, /* house */
    { .label = {  71064, 10, 0 } }, /* humanities */
    { .label = {  43276, 12, 0 } }, /* illustration */
    { .label = {  34450, 13, 0 } }, /* imageandsound */
    { .label = {  43326,  6, 0 } }, /* indian */
    { .label = {  43326,  7, 0 } }, /* indiana */
    { .label = {  43326, 12, 0 } }, /* indianapolis */
    { .label = {  43376, 12, 0 } }, /* indianmarket */
    { .label = {  43425, 12, 0 } }, /* intelligence */
    { .label = {  56261, 11, 0 } }, /* interactive */
    { .label = { 166289,  4, 0 } }, /* iraq */
    { .label = {    575,  4, 0 } }, /* iron */
    { .label = {  87429,  9, 0 } }, /* isleofman */
    { .label = { 126438,  7, 0 } }, /* jamison */
    { .label = {  87468,  9, 0 } }, /* jefferson */
    { .label = {  87511,  9, 0 } }, /* jerusalem */
    { .label = { 126469,  7, 0 } }, /* jewelry */
    { .label = {  87552,  6, 0 } }, /* jewish */
    { .label = {  87552,  9, 0 } }, /* jewishart */
    { .label = {  79406,  3, 0 } }, /* jfk */
    { .label = {  71106, 10, 0 } }, /* journalism */
    { .label = { 126505,  7, 0 } }, /* judaica */
    { .label = {  56307, 11, 0 } }, /* judygarland */
    { .label = {  71151, 10, 0 } }, /* juedisches */
    { .label = { 166308,  4, 0 } }, /* juif */
    { .label = { 146786,  6, 0 } }, /* karate */
    { .label = {  87593,  9, 0 } }, /* karikatur */
    { .label = { 166330,  4, 0 } }, /* kids */
    { .label = {  71198, 10, 0 } }, /* koebenhavn */
    { .label = { 122194,  5, 0 } }, /* koeln */
    { .label = {  26574,  5, 0 } }, /* kunst */
    { .label = {  34505, 13, 0 } }, /* kunstsammlung */
    { .label = {  26574, 14, 0 } }, /* kunstunddesign */
    { .label = { 159290,  5, 0 } }, /* labor */
    { .label = { 146809,  6, 0 } }, /* labour */
    { .label = { 126537,  7, 0 } }, /* lajolla */
    { .label = {  71243, 10, 0 } }, /* lancashire */
    { .label = { 146836,  6, 0 } }, /* landes */
    { .label = {  16600,  4, 0 } }, /* lans */
    { .label = {  56359, 11, 0 } }, /* xn--lns-qla */
    { .label = { 126569,  7, 0 } }, /* larsson */
    { .label = {  56413, 11, 0 } }, /* lewismiller */
    { .label = { 126597,  7, 0 } }, /* lincoln */
    { .label = { 117547,  4, 0 } }, /* linz */
    { .label = {  20286,  6, 0 } }, /* living */
    { .label = {  20286, 13, 0 } }, /* livinghistory */
    { .label = {  43477, 12, 0 } }, /* localhistory */
    { .label = { 146861,  6, 0 } }, /* london */
    { .label = {  71284, 10, 0 } }, /* losangeles */
    { .label = { 146887,  6, 0 } }, /* louvre */
    { .label = { 107179,  8, 0 } }, /* loyalist */
    { .label = { 126628,  7, 0 } }, /* lucerne */
    { .label = {  71326, 10, 0 } }, /* luxembourg */
    { .label = { 146915,  6, 0 } }, /* luzern */
    { .label = {  13386,  3, 0 } }, /* mad */
    { .label = { 146944,  6, 0 } }, /* madrid */
    { .label = { 107214,  8, 0 } }, /* mallorca */
    { .label = {  71375, 10, 0 } }, /* manchester */
    { .label = { 107248,  7, 0 } }, /* mansion */
    { .label = { 107248,  8, 0 } }, /* mansions */
    { .label = { 166348,  4, 0 } }, /* manx */
    { .label = { 126659,  7, 0 } }, /* marburg */
    { .label = { 107280,  8, 0 } }, /* maritime */
    { .label = { 107313,  8, 0 } }, /* maritimo */
    { .label = { 107346,  8, 0 } }, /* maryland */
    { .label = {  71417, 10, 0 } }, /* marylhurst */
    { .label = {  96066,  5, 0 } }, /* media */
    { .label = { 126691,  7, 0 } }, /* medical */
    { .label = {   6605, 19, 0 } }, /* medizinhistorisches */
    { .label = { 146970,  6, 0 } }, /* meeres */
    { .label = { 107381,  8, 0 } }, /* memorial */
    { .label = {  87630,  9, 0 } }, /* mesaverde */
    { .label = { 107415,  8, 0 } }, /* michigan */
    { .label = {  56463, 11, 0 } }, /* midatlantic */
    { .label = { 107450,  8, 0 } }, /* military */
    { .label = {  56436,  4, 0 } }, /* mill */
    { .label = { 146995,  6, 0 } }, /* miners */
    { .label = { 147020,  6, 0 } }, /* mining */
    { .label = {  87669,  9, 0 } }, /* minnesota */
    { .label = { 126722,  7, 0 } }, /* missile */
    { .label = {  43190,  8, 0 } }, /* missoula */
    { .label = { 147046,  6, 0 } }, /* modern */
    { .label = { 107337,  4, 0 } }, /* moma */
    { .label = { 159312,  5, 0 } }, /* money */
    { .label = { 107485,  8, 0 } }, /* monmouth */
    { .label = {  71462, 10, 0 } }, /* monticello */
    { .label = { 107521,  8, 0 } }, /* montreal */
    { .label = { 147072,  6, 0 } }, /* moscow */
    { .label = {  60143, 10, 0 } }, /* motorcycle */
    { .label = { 107554,  8, 0 } }, /* muenchen */
    { .label = { 107590,  8, 0 } }, /* muenster */
    { .label = { 107624,  8, 0 } }, /* mulhouse */
    { .label = { 147100,  6, 0 } }, /* muncie */
    { .label = { 147127,  6, 0 } }, /* museet */
    { .label = {  43530, 12, 0 } }, /* museumcenter */
    { .label = {  14895, 16, 0 } }, /* museumvereniging */
    { .label = {  38983,  5, 0 } }, /* music */
    { .label = {  14967,  8, 0 } }, /* national */
    { .label = {  14967, 16, 0 } }, /* nationalfirearms */
    { .label = {  15032, 16, 0 } }, /* nationalheritage */
    { .label = {  26636, 14, 0 } }, /* nativeamerican */
    { .label = {   4389, 14, 0 } }, /* naturalhistory */
    { .label = {   4389, 20, 0 } }, /* naturalhistorymuseum */
    { .label = {  19954, 15, 0 } }, /* naturalsciences */
    { .label = {   8908,  6, 0 } }, /* nature */
    { .label = {  11190, 17, 0 } }, /* naturhistorisches */
    { .label = {   6689, 19, 0 } }, /* natuurwetenschappen */
    { .label = { 107661,  8, 0 } }, /* naumburg */
    { .label = { 159335,  5, 0 } }, /* naval */
    { .label = { 107698,  8, 0 } }, /* nebraska */
    { .label = { 159356,  5, 0 } }, /* neues */
    { .label = {  43583, 12, 0 } }, /* newhampshire */
    { .label = {  87705,  9, 0 } }, /* newjersey */
    { .label = {  87748,  9, 0 } }, /* newmexico */
    { .label = { 126752,  7, 0 } }, /* newport */
    { .label = {  87790,  9, 0 } }, /* newspaper */
    { .label = { 126784,  7, 0 } }, /* newyork */
    { .label = { 147153,  6, 0 } }, /* niepce */
    { .label = { 126817,  7, 0 } }, /* norfolk */
    { .label = {    734,  5, 0 } }, /* north */
    { .label = {  62569,  3, 0 } }, /* nrw */
    { .label = {  87831,  9, 0 } }, /* nuernberg */
    { .label = {  87871,  9, 0 } }, /* nuremberg */
    { .label = { 114299,  3, 0 } }, /* nyc */
    { .label = { 166366,  4, 0 } }, /* nyny */
    { .label = {  34563, 13, 0 } }, /* oceanographic */
    { .label = {  20016, 15, 0 } }, /* oceanographique */
    { .label = { 159377,  5, 0 } }, /* omaha */
    { .label = {  64767,  6, 0 } }, /* online */
    { .label = { 126849,  7, 0 } }, /* ontario */
    { .label = { 126876,  7, 0 } }, /* openair */
    { .label = {  56509,  6, 0 } }, /* oregon */
    { .label = {  56509, 11, 0 } }, /* oregontrail */
    { .label = { 159397,  5, 0 } }, /* otago */
    { .label = { 147180,  6, 0 } }, /* oxford */
    { .label = { 126905,  7, 0 } }, /* pacific */
    { .label = {  87912,  9, 0 } }, /* paderborn */
    { .label = { 147209,  6, 0 } }, /* palace */
    { .label = { 159417,  5, 0 } }, /* paleo */
    { .label = {  56554, 11, 0 } }, /* palmsprings */
    { .label = {  69328,  6, 0 } }, /* panama */
    { .label = { 159439,  5, 0 } }, /* paris */
    { .label = { 107731,  8, 0 } }, /* pasadena */
    { .label = { 107763,  8, 0 } }, /* pharmacy */
    { .label = {  15096, 12, 0 } }, /* philadelphia */
    { .label = {  15096, 16, 0 } }, /* philadelphiaarea */
    { .label = {  87952,  9, 0 } }, /* philately */
    { .label = { 126938,  7, 0 } }, /* phoenix */
    { .label = {  56604, 11, 0 } }, /* photography */
    { .label = { 147235,  6, 0 } }, /* pilots */
    { .label = {  71506, 10, 0 } }, /* pittsburgh */
    { .label = {  56656, 11, 0 } }, /* planetarium */
    { .label = {  71553, 10, 0 } }, /* plantation */
    { .label = { 147262,  6, 0 } }, /* plants */
    { .label = { 159460,  5, 0 } }, /* plaza */
    { .label = { 147288,  6, 0 } }, /* portal */
    { .label = { 107800,  8, 0 } }, /* portland */
    { .label = {  71594, 10, 0 } }, /* portlligat */
    { .label = {    324, 28, 0 } }, /* posts-and-telecommunications */
    { .label = {  43637, 12, 0 } }, /* preservation */
    { .label = { 107835,  8, 0 } }, /* presidio */
    { .label = {  22790,  5, 0 } }, /* press */
    { .label = {  39723,  7, 0 } }, /* project */
    { .label = {  24180,  6, 0 } }, /* public */
    { .label = { 159484,  5, 0 } }, /* pubol */
    { .label = { 147314,  6, 0 } }, /* quebec */
    { .label = { 107870,  8, 0 } }, /* railroad */
    { .label = { 126971,  7, 0 } }, /* railway */
    { .label = {  29566,  8, 0 } }, /* research */
    { .label = {  71638, 10, 0 } }, /* resistance */
    { .label = {  43688, 12, 0 } }, /* riodejaneiro */
    { .label = {  87994,  9, 0 } }, /* rochester */
    { .label = { 127002,  7, 0 } }, /* rockart */
    { .label = {  22919,  4, 0 } }, /* roma */
    { .label = { 147346,  6, 0 } }, /* russia */
    { .label = {  71678, 10, 0 } }, /* saintlouis */
    { .label = {  64130,  5, 0 } }, /* salem */
    { .label = {  43739, 12, 0 } }, /* salvadordali */
    { .label = { 107902,  8, 0 } }, /* salzburg */
    { .label = { 107941,  8, 0 } }, /* sandiego */
    { .label = {  43790, 12, 0 } }, /* sanfrancisco */
    { .label = {  43840, 12, 0 } }, /* santabarbara */
    { .label = {  88032,  9, 0 } }, /* santacruz */
    { .label = { 127031,  7, 0 } }, /* santafe */
    { .label = {  43887, 12, 0 } }, /* saskatchewan */
    { .label = { 117468,  4, 0 } }, /* satx */
    { .label = {  71719, 10, 0 } }, /* savannahga */
    { .label = {  43937, 12, 0 } }, /* schlesisches */
    { .label = {  56703, 11, 0 } }, /* schoenbrunn */
    { .label = {  56752, 11, 0 } }, /* schokoladen */
    { .label = { 147370,  6, 0 } }, /* school */
    { .label = { 127059,  7, 0 } }, /* schweiz */
    { .label = {   8796,  7, 0 } }, /* science */
    { .label = {  11261, 17, 0 } }, /* scienceandhistory */
    { .label = {   8796, 18, 0 } }, /* scienceandindustry */
    { .label = {  26693, 13, 0 } }, /* sciencecenter */
    { .label = {  26693, 14, 0 } }, /* sciencecenters */
    { .label = {  20084, 15, 0 } }, /* science-fiction */
    { .label = {  26752, 14, 0 } }, /* sciencehistory */
    { .label = {   8874,  8, 0 } }, /* sciences */
    { .label = {   8874, 18, 0 } }, /* sciencesnaturelles */
    { .label = { 107974,  8, 0 } }, /* scotland */
    { .label = { 127094,  7, 0 } }, /* seaport */
    { .label = {  71759, 10, 0 } }, /* settlement */
    { .label = { 108008,  8, 0 } }, /* settlers */
    { .label = { 159510,  5, 0 } }, /* shell */
    { .label = {  71801, 10, 0 } }, /* sherbrooke */
    { .label = { 127123,  7, 0 } }, /* sibenik */
    { .label = { 166386,  4, 0 } }, /* silk */
    { .label = {  28294,  3, 0 } }, /* ski */
    { .label = { 159533,  5, 0 } }, /* skole */
    { .label = {  11159,  7, 0 } }, /* society */
    { .label = { 127154,  7, 0 } }, /* sologne */
    { .label = {  26813, 14, 0 } }, /* soundandvision */
    { .label = {  34619, 13, 0 } }, /* southcarolina */
    { .label = {  88071,  9, 0 } }, /* southwest */
    { .label = {  39527,  5, 0 } }, /* space */
    { .label = {   7188,  3, 0 } }, /* spy */
    { .label = { 134775,  6, 0 } }, /* square */
    { .label = {  91041,  5, 0 } }, /* stadt */
    { .label = { 108041,  8, 0 } }, /* stalbans */
    { .label = {  88111,  9, 0 } }, /* starnberg */
    { .label = {  20150,  5, 0 } }, /* state */
    { .label = {  20150, 15, 0 } }, /* stateofdelaware */
    { .label = {   5511,  7, 0 } }, /* station */
    { .label = { 159555,  5, 0 } }, /* steam */
    { .label = {  71845, 10, 0 } }, /* steiermark */
    { .label = { 147397,  6, 0 } }, /* stjohn */
    { .label = {  88149,  9, 0 } }, /* stockholm */
    { .label = {  43990, 12, 0 } }, /* stpetersburg */
    { .label = {  88190,  9, 0 } }, /* stuttgart */
    { .label = { 147425,  6, 0 } }, /* suisse */
    { .label = {  44044, 12, 0 } }, /* surgeonshall */
    { .label = { 147450,  6, 0 } }, /* surrey */
    { .label = { 108074,  8, 0 } }, /* svizzera */
    { .label = { 147477,  6, 0 } }, /* sweden */
    { .label = { 147504,  6, 0 } }, /* sydney */
    { .label = {  55175,  4, 0 } }, /* tank */
    { .label = {  21801,  3, 0 } }, /* tcm */
    { .label = {  71886, 10, 0 } }, /* technology */
    { .label = {  11334, 17, 0 } }, /* telekommunikation */
    { .label = {  71932, 10, 0 } }, /* television */
    { .label = { 159575,  5, 0 } }, /* texas */
    { .label = { 127184,  7, 0 } }, /* textile */
    { .label = { 127215,  7, 0 } }, /* theater */
    { .label = {  56800,  4, 0 } }, /* time */
    { .label = {  56800, 11, 0 } }, /* timekeeping */
    { .label = { 108113,  8, 0 } }, /* topology */
    { .label = { 140075,  6, 0 } }, /* torino */
    { .label = { 103767,  5, 0 } }, /* touch */
    { .label = {  17687,  4, 0 } }, /* town */
    { .label = {  66234,  9, 0 } }, /* transport */
    { .label = {  77534,  4, 0 } }, /* tree */
    { .label = { 127243,  7, 0 } }, /* trolley */
    { .label = { 127275,  5, 0 } }, /* trust */
    { .label = { 127275,  7, 0 } }, /* trustee */
    { .label = {  26492,  5, 0 } }, /* uhren */
    { .label = {  28849,  3, 0 } }, /* ulm */
    { .label = { 108151,  8, 0 } }, /* undersea */
    { .label = {  71975, 10, 0 } }, /* university */
    { .label = {  17256,  3, 0 } }, /* usa */
    { .label = {  72020, 10, 0 } }, /* usantiques */
    { .label = { 147533,  6, 0 } }, /* usarts */
    { .label = {  20213, 15, 0 } }, /* uscountryestate */
    { .label = {  88227,  9, 0 } }, /* usculture */
    { .label = {  15165, 16, 0 } }, /* usdecorativearts */
    { .label = { 108184,  8, 0 } }, /* usgarden */
    { .label = {  88268,  9, 0 } }, /* ushistory */
    { .label = { 127304,  7, 0 } }, /* ushuaia */
    { .label = {  20277, 15, 0 } }, /* uslivinghistory */
    { .label = { 166404,  4, 0 } }, /* utah */
    { .label = {  22819,  4, 0 } }, /* uvic */
    { .label = {  14795,  6, 0 } }, /* valley */
    { .label = { 147557,  6, 0 } }, /* vantaa */
    { .label = {  72065, 10, 0 } }, /* versailles */
    { .label = { 147580,  6, 0 } }, /* viking */
    { .label = { 127333,  7, 0 } }, /* village */
    { .label = { 108218,  8, 0 } }, /* virginia */
    { .label = {  51287,  7, 0 } }, /* virtual */
    { .label = { 127365,  7, 0 } }, /* virtuel */
    { .label = {  72108, 10, 0 } }, /* vlaanderen */
    { .label = {  56849, 11, 0 } }, /* volkenkunde */
    { .label = { 159596,  5, 0 } }, /* wales */
    { .label = { 108252,  8, 0 } }, /* wallonie */
    { .label = {  16968,  3, 0 } }, /* war */
    { .label = {  44096, 12, 0 } }, /* washingtondc */
    { .label = {  34673, 13, 0 } }, /* watchandclock */
    { .label = {  20345, 15, 0 } }, /* watch-and-clock */
    { .label = {   9868,  7, 0 } }, /* western */
    { .label = {  88308,  9, 0 } }, /* westfalen */
    { .label = { 127397,  7, 0 } }, /* whaling */
    { .label = { 108287,  8, 0 } }, /* wildlife */
    { .label = {   4235, 12, 0 } }, /* williamsburg */
    { .label = { 108326,  8, 0 } }, /* windmill */
    { .label = { 108364,  8, 0 } }, /* workshop */
    { .label = {  88348,  4, 0 } }, /* york */
    { .label = {  88348,  9, 0 } }, /* yorkshire */
    { .label = { 108402,  8, 0 } }, /* yosemite */
    { .label = { 159618,  5, 0 } }, /* youth */
    { .label = {  72150, 10, 0 } }, /* zoological */
    { .label = { 127429,  7, 0 } }, /* zoology */
    { .label = {  26873, 14, 0 } }, /* xn--9dbhblg6di */
    { .label = {  72196, 10, 0 } }, /* xn--h1aegh */

    /* entries 6692 to 6705 */
    { .label = {  79798,  4, 0 } }, /* aero */
    { .label = {  54555,  3, 0 } }, /* biz */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  51529,  4, 0 } }, /* coop */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {   4448,  6, 0 } }, /* museum */
    { .label = {  29414,  4, 0 } }, /* name */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  22835,  3, 0 } }, /* pro */

    /* entries 6706 to 6716 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  54555,  3, 0 } }, /* biz */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  51529,  4, 0 } }, /* coop */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {   4448,  6, 0 } }, /* museum */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 6717 to 6723 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  43390,  3, 0 } }, /* nym */

    /* entries 6724 to 6731 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  29414,  4, 0 } }, /* name */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 6732 to 6739 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3989,  3, 0 } }, /* adv */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 6740 to 6756 */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {  22835,  3, 0 } }, /* pro */
    { .label = {  29414,  4, 0 } }, /* name */
    { .label = { 147370,  6, 0 } }, /* school */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {   3009,  2, 0 } }, /* dr */
    { .label = {    296,  2, 0 } }, /* us */
    { .label = {   2900,  2, 0 } }, /* mx */
    { .label = {    133,  2, 0 } }, /* ca */
    { .label = {    100,  2, 0 } }, /* in */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {   9431,  2, 0 } }, /* tv */
    { .label = {    336,  2, 0 } }, /* ws */
    { .label = {  10207,  4, 0 } }, /* mobi */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 6757 to 6760 */
    { .label = {  10067,  3, 1 } }, { .child = { 6761, 1 } }, /* her */
    { .label = {   4417,  3, 1 } }, { .child = { 6762, 1 } }, /* his */

    /* entry 6761 */
    { .label = { 153931,  6, 0 } }, /* forgot */

    /* entry 6762 */
    { .label = { 153931,  6, 0 } }, /* forgot */

    /* entries 6763 to 6764 */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entries 6765 to 6874 */
    { .label = {  76691, 10, 0 } }, /* alwaysdata */
    { .label = {  76733, 10, 0 } }, /* cloudfront */
    { .label = { 114850,  8, 0 } }, /* t3l3p0rt */
    { .label = { 134704,  7, 0 } }, /* myfritz */
    { .label = {  49408, 12, 0 } }, /* blackbaudcdn */
    { .label = { 153823,  6, 0 } }, /* boomla */
    { .label = { 134812,  7, 0 } }, /* bplaced */
    { .label = { 134775,  7, 0 } }, /* square7 */
    { .label = {   1450,  2, 0 } }, /* gb */
    { .label = {    291,  2, 0 } }, /* hu */
    { .label = {   9443,  2, 0 } }, /* jp */
    { .label = {    629,  2, 0 } }, /* se */
    { .label = {   6323,  2, 0 } }, /* uk */
    { .label = {    100,  2, 0 } }, /* in */
    { .label = {  62911, 11, 0 } }, /* cloudaccess */
    { .label = {  94534,  9, 0 } }, /* cdn77-ssl */
    { .label = {  49465,  5, 1 } }, { .child = { 6875, 1 } }, /* cdn77 */
    { .label = {  94584,  9, 0 } }, /* cloudeity */
    { .label = { 114965,  8, 0 } }, /* feste-ip */
    { .label = {  77104, 10, 0 } }, /* knx-server */
    { .label = {  38450, 13, 0 } }, /* static-access */
    { .label = {  63010, 11, 1 } }, { .child = { 6876, 1 } }, /* cryptonomic */
    { .label = {  77150, 10, 0 } }, /* dattolocal */
    { .label = { 135014,  7, 0 } }, /* mydatto */
    { .label = { 153877,  6, 0 } }, /* debian */
    { .label = {  49628, 12, 0 } }, /* at-band-camp */
    { .label = { 135143,  7, 0 } }, /* blogdns */
    { .label = { 115110,  8, 0 } }, /* broke-it */
    { .label = {  77283, 10, 0 } }, /* buyshouses */
    { .label = { 115146,  8, 0 } }, /* dnsalias */
    { .label = { 135207,  7, 0 } }, /* dnsdojo */
    { .label = { 135240,  7, 0 } }, /* does-it */
    { .label = {  94750,  9, 0 } }, /* dontexist */
    { .label = { 115178,  8, 0 } }, /* dynalias */
    { .label = {  94789,  9, 0 } }, /* dynathome */
    { .label = {  38683, 13, 0 } }, /* endofinternet */
    { .label = { 135460,  7, 0 } }, /* from-az */
    { .label = { 135526,  7, 0 } }, /* from-co */
    { .label = { 135956,  7, 0 } }, /* from-la */
    { .label = { 136485,  7, 0 } }, /* from-ny */
    { .label = { 137121,  7, 0 } }, /* gets-it */
    { .label = {  49682, 12, 0 } }, /* ham-radio-op */
    { .label = {  94811,  7, 0 } }, /* homeftp */
    { .label = { 153984,  6, 0 } }, /* homeip */
    { .label = {  94949,  9, 0 } }, /* homelinux */
    { .label = { 115248,  8, 0 } }, /* homeunix */
    { .label = {  63564, 11, 0 } }, /* in-the-band */
    { .label = {  95027,  9, 0 } }, /* is-a-chef */
    { .label = {  95068,  9, 0 } }, /* is-a-geek */
    { .label = { 115428,  8, 0 } }, /* isa-geek */
    { .label = {  95147,  9, 0 } }, /* kicks-ass */
    { .label = {  39351, 13, 0 } }, /* office-on-the */
    { .label = { 137301,  7, 0 } }, /* podzone */
    { .label = {  39411, 13, 0 } }, /* scrapper-site */
    { .label = { 154041,  6, 0 } }, /* selfip */
    { .label = { 115567,  8, 0 } }, /* sells-it */
    { .label = { 115602,  8, 0 } }, /* servebbs */
    { .label = { 115640,  8, 0 } }, /* serveftp */
    { .label = { 115712,  8, 0 } }, /* thruhere */
    { .label = { 154070,  6, 0 } }, /* webhop */
    { .label = { 115794,  8, 0 } }, /* definima */
    { .label = { 137371,  7, 0 } }, /* casacam */
    { .label = { 168476,  4, 0 } }, /* dynu */
    { .label = { 164655,  5, 0 } }, /* dynv6 */
    { .label = { 154241,  6, 0 } }, /* twmail */
    { .label = {    204,  2, 0 } }, /* ru */
    { .label = {  64442, 11, 0 } }, /* channelsdvr */
    { .label = { 116497,  8, 1 } }, { .child = { 6877, 1 } }, /* fastlylb */
    { .label = { 116497,  6, 1 } }, { .child = { 6878, 4 } }, /* fastly */
    { .label = {  50578, 12, 0 } }, /* flynnhosting */
    { .label = {  31502, 14, 0 } }, /* cloudfunctions */
    { .label = {  95818,  9, 0 } }, /* moonscale */
    { .label = { 137824,  7, 0 } }, /* ipifony */
    { .label = {  64744,  5, 0 } }, /* barsy */
    { .label = { 154631,  6, 0 } }, /* memset */
    { .label = {  39873, 13, 0 } }, /* azurewebsites */
    { .label = {  50750, 12, 0 } }, /* azure-mobile */
    { .label = { 116903,  8, 0 } }, /* cloudapp */
    { .label = {  77060,  5, 0 } }, /* dnsup */
    { .label = { 164922,  5, 0 } }, /* hicam */
    { .label = { 138016,  7, 0 } }, /* now-dns */
    { .label = { 164944,  5, 0 } }, /* ownip */
    { .label = { 154730,  6, 0 } }, /* vpndns */
    { .label = {  31750, 14, 0 } }, /* eating-organic */
    { .label = {  96015,  9, 0 } }, /* mydissent */
    { .label = { 117123,  8, 0 } }, /* myeffect */
    { .label = {  96055,  9, 0 } }, /* mymediapc */
    { .label = { 165061,  5, 0 } }, /* mypsx */
    { .label = {  17543, 16, 0 } }, /* mysecuritycamera */
    { .label = { 154870,  6, 0 } }, /* nhlfan */
    { .label = { 165088,  5, 0 } }, /* no-ip */
    { .label = { 154897,  6, 0 } }, /* pgafan */
    { .label = {   1461, 24, 0 } }, /* privatizehealthinsurance */
    { .label = { 117205,  8, 0 } }, /* bounceme */
    { .label = { 115056,  4, 0 } }, /* ddns */
    { .label = {  79258, 10, 0 } }, /* redirectme */
    { .label = {  96179,  9, 0 } }, /* serveblog */
    { .label = {  31873, 14, 0 } }, /* serveminecraft */
    { .label = {  79146,  5, 0 } }, /* sytes */
    { .label = {  40163, 13, 0 } }, /* cloudycluster */
    { .label = { 117424,  8, 0 } }, /* rackmaze */
    { .label = {  79483, 10, 0 } }, /* schokokeks */
    { .label = {  17614, 16, 0 } }, /* firewall-gateway */
    { .label = { 138428,  7, 0 } }, /* dsmynas */
    { .label = { 117643,  8, 0 } }, /* familyds */
    { .label = {    527,  2, 0 } }, /* za */

    /* entry 6875 */
    { .label = {      1,  1, 0 } }, /* r */

    /* entry 6876 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 6877 */
    { .label = {  10158,  3, 0 } }, /* map */

    /* entries 6878 to 6883 */
    { .label = { 137732,  7, 0 } }, /* freetls */
    { .label = {  10158,  3, 0 } }, /* map */
    { .label = {  60289,  4, 1 } }, { .child = { 6884, 2 } }, /* prod */
    { .label = {   7519,  3, 1 } }, { .child = { 6886, 3 } }, /* ssl */

    /* entries 6884 to 6885 */
    { .label = {     24,  1, 0 } }, /* a */
    { .label = { 151873,  6, 0 } }, /* global */

    /* entries 6886 to 6888 */
    { .label = {     24,  1, 0 } }, /* a */
    { .label = {     62,  1, 0 } }, /* b */
    { .label = { 151873,  6, 0 } }, /* global */

    /* entries 6889 to 6898 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {   5389,  3, 0 } }, /* per */
    { .label = {    182,  3, 0 } }, /* rec */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = {   7867,  4, 0 } }, /* arts */
    { .label = { 113331,  4, 0 } }, /* firm */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = { 131614,  5, 0 } }, /* other */
    { .label = { 155394,  5, 0 } }, /* store */

    /* entries 6899 to 6909 */
    { .label = {    106,  3, 1 } }, { .child = { 6910, 1 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {     39,  1, 0 } }, /* i */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  10207,  4, 0 } }, /* mobi */
    { .label = {  29414,  4, 0 } }, /* name */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   6667,  3, 0 } }, /* sch */

    /* entry 6910 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 6911 to 6924 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  54555,  3, 0 } }, /* biz */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {    100,  2, 0 } }, /* in */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {  25342,  3, 0 } }, /* nom */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    683,  3, 0 } }, /* web */

    /* entries 6925 to 6933 */
    { .label = {   3646,  2, 0 } }, /* bv */
    { .label = {  30586, 14, 0 } }, /* virtueeldomein */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  23565, 15, 0 } }, /* hosting-cluster */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = { 117719,  8, 1 } }, { .child = { 6934, 1 } }, /* transurl */
    { .label = { 138727,  7, 0 } }, /* cistron */
    { .label = { 165408,  5, 0 } }, /* demon */

    /* entry 6934 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 6935 to 7692 */
    { .label = {  43837,  3, 0 } }, /* fhs */
    { .label = {  28497,  3, 0 } }, /* vgs */
    { .label = {  72246, 10, 0 } }, /* fylkesbibl */
    { .label = {  88388,  9, 0 } }, /* folkebibl */
    { .label = {   4448,  6, 0 } }, /* museum */
    { .label = { 147608,  6, 0 } }, /* idrett */
    { .label = {   1461,  4, 0 } }, /* priv */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {   5511,  4, 0 } }, /* stat */
    { .label = {  75381,  3, 0 } }, /* dep */
    { .label = { 127464,  7, 0 } }, /* kommune */
    { .label = {  11616,  5, 0 } }, /* herad */
    { .label = {     24,  2, 1 } }, { .child = { 7693, 1 } }, /* aa */
    { .label = {     27,  2, 1 } }, { .child = { 7694, 1 } }, /* ah */
    { .label = {   2306,  2, 1 } }, { .child = { 7695, 1 } }, /* bu */
    { .label = {   1659,  2, 1 } }, { .child = { 7696, 1 } }, /* fm */
    { .label = {    344,  2, 1 } }, { .child = { 7697, 1 } }, /* hl */
    { .label = {   2224,  2, 1 } }, { .child = { 7698, 1 } }, /* hm */
    { .label = {  88433,  9, 1 } }, { .child = { 7699, 1 } }, /* jan-mayen */
    { .label = {    205,  2, 1 } }, { .child = { 7700, 1 } }, /* mr */
    { .label = {   2951,  2, 1 } }, { .child = { 7701, 1 } }, /* nl */
    { .label = {    252,  2, 1 } }, { .child = { 7702, 1 } }, /* nt */
    { .label = {   5311,  2, 1 } }, { .child = { 7703, 1 } }, /* of */
    { .label = {    528,  2, 1 } }, { .child = { 7704, 1 } }, /* ol */
    { .label = {  50345,  4, 1 } }, { .child = { 7705, 1 } }, /* oslo */
    { .label = {   1368,  2, 1 } }, { .child = { 7706, 1 } }, /* rl */
    { .label = {  15509,  2, 1 } }, { .child = { 7707, 1 } }, /* sf */
    { .label = {    214,  2, 1 } }, { .child = { 7708, 1 } }, /* st */
    { .label = { 108437,  8, 1 } }, { .child = { 7709, 1 } }, /* svalbard */
    { .label = {   2425,  2, 1 } }, { .child = { 7710, 1 } }, /* tm */
    { .label = {    465,  2, 1 } }, { .child = { 7711, 1 } }, /* tr */
    { .label = {     54,  2, 1 } }, { .child = { 7712, 1 } }, /* va */
    { .label = {   3659,  2, 1 } }, { .child = { 7713, 1 } }, /* vf */
    { .label = { 108473,  8, 0 } }, /* akrehamn */
    { .label = {  20414, 15, 0 } }, /* xn--krehamn-dxa */
    { .label = {  19518,  6, 0 } }, /* algard */
    { .label = {  34732, 13, 0 } }, /* xn--lgrd-poac */
    { .label = {  37842,  4, 0 } }, /* arna */
    { .label = {  72297, 10, 0 } }, /* brumunddal */
    { .label = { 159642,  5, 0 } }, /* bryne */
    { .label = {  56900, 11, 0 } }, /* bronnoysund */
    { .label = {   8950, 18, 0 } }, /* xn--brnnysund-m8ac */
    { .label = { 147633,  6, 0 } }, /* drobak */
    { .label = {  34794, 13, 0 } }, /* xn--drbak-wua */
    { .label = { 108506,  8, 0 } }, /* egersund */
    { .label = { 127496,  7, 0 } }, /* fetsund */
    { .label = { 159666,  5, 0 } }, /* floro */
    { .label = {  44149, 12, 0 } }, /* xn--flor-jra */
    { .label = {  56950, 11, 0 } }, /* fredrikstad */
    { .label = { 108541,  8, 0 } }, /* hokksund */
    { .label = { 108578,  8, 0 } }, /* honefoss */
    { .label = {  20483, 15, 0 } }, /* xn--hnefoss-q1a */
    { .label = { 108613,  8, 0 } }, /* jessheim */
    { .label = {  88474,  9, 0 } }, /* jorpeland */
    { .label = {  15232, 16, 0 } }, /* xn--jrpeland-54a */
    { .label = { 108650,  8, 0 } }, /* kirkenes */
    { .label = { 108684,  8, 0 } }, /* kopervik */
    { .label = {  44207, 12, 0 } }, /* krokstadelva */
    { .label = { 108722,  8, 0 } }, /* langevag */
    { .label = {  20558, 15, 0 } }, /* xn--langevg-jxa */
    { .label = { 127528,  7, 0 } }, /* leirvik */
    { .label = {  88516,  9, 0 } }, /* mjondalen */
    { .label = {  15316, 16, 0 } }, /* xn--mjndalen-64a */
    { .label = {  88557,  9, 0 } }, /* mo-i-rana */
    { .label = { 127560,  7, 0 } }, /* mosjoen */
    { .label = {  26953, 14, 0 } }, /* xn--mosjen-eya */
    { .label = {  44259, 12, 0 } }, /* nesoddtangen */
    { .label = { 108757,  8, 0 } }, /* orkanger */
    { .label = { 147660,  6, 0 } }, /* osoyro */
    { .label = {  34856, 13, 0 } }, /* xn--osyro-wua */
    { .label = { 147686,  6, 0 } }, /* raholt */
    { .label = {  34917, 13, 0 } }, /* xn--rholt-mra */
    { .label = {  44309, 12, 0 } }, /* sandnessjoen */
    { .label = {   6773, 19, 0 } }, /* xn--sandnessjen-ogb */
    { .label = {  34976, 13, 0 } }, /* skedsmokorset */
    { .label = { 127592,  7, 0 } }, /* slattum */
    { .label = {  72344, 10, 0 } }, /* spjelkavik */
    { .label = {  88594,  9, 0 } }, /* stathelle */
    { .label = { 127622,  7, 0 } }, /* stavern */
    { .label = {  20631, 15, 0 } }, /* stjordalshalsen */
    { .label = {   2387, 22, 0 } }, /* xn--stjrdalshalsen-sqb */
    { .label = { 108790,  8, 0 } }, /* tananger */
    { .label = { 147711,  6, 0 } }, /* tranby */
    { .label = {  56998, 11, 0 } }, /* vossevangen */
    { .label = {  57375,  6, 0 } }, /* afjord */
    { .label = {  35032, 13, 0 } }, /* xn--fjord-lra */
    { .label = { 127651,  7, 0 } }, /* agdenes */
    { .label = {     94,  2, 0 } }, /* al */
    { .label = {  88632,  9, 0 } }, /* xn--l-1fa */
    { .label = { 127680,  7, 0 } }, /* alesund */
    { .label = {  27019, 14, 0 } }, /* xn--lesund-hua */
    { .label = {  88679,  9, 0 } }, /* alstahaug */
    { .label = {  32439,  4, 0 } }, /* alta */
    { .label = {  57046, 11, 0 } }, /* xn--lt-liac */
    { .label = {  88716,  9, 0 } }, /* alaheadju */
    { .label = {  15399, 16, 0 } }, /* xn--laheadju-7ya */
    { .label = {  58110,  6, 0 } }, /* alvdal */
    { .label = { 159816,  4, 0 } }, /* amli */
    { .label = {  57097, 11, 0 } }, /* xn--mli-tla */
    { .label = {  38604,  4, 0 } }, /* amot */
    { .label = {  57148, 11, 0 } }, /* xn--mot-tla */
    { .label = { 147738,  6, 0 } }, /* andebu */
    { .label = { 149275,  5, 0 } }, /* andoy */
    { .label = {  44360, 12, 0 } }, /* xn--andy-ira */
    { .label = {  88756,  9, 0 } }, /* andasuolo */
    { .label = {  35998,  5, 0 } }, /* ardal */
    { .label = {  44414, 12, 0 } }, /* xn--rdal-poa */
    { .label = { 127710,  7, 0 } }, /* aremark */
    { .label = { 127738,  7, 0 } }, /* arendal */
    { .label = {  88793,  9, 0 } }, /* xn--s-1fa */
    { .label = { 147765,  6, 0 } }, /* aseral */
    { .label = {  35095, 13, 0 } }, /* xn--seral-lra */
    { .label = { 159689,  5, 0 } }, /* asker */
    { .label = { 159709,  5, 0 } }, /* askim */
    { .label = { 127766,  7, 0 } }, /* askvoll */
    { .label = { 159730,  5, 0 } }, /* askoy */
    { .label = {  44469, 12, 0 } }, /* xn--asky-ira */
    { .label = {  89982,  5, 0 } }, /* asnes */
    { .label = {  44523, 12, 0 } }, /* xn--snes-poa */
    { .label = {  88839,  9, 0 } }, /* audnedaln */
    { .label = { 159752,  5, 0 } }, /* aukra */
    { .label = {  31638,  4, 0 } }, /* aure */
    { .label = { 127798,  7, 0 } }, /* aurland */
    { .label = {  27084, 14, 0 } }, /* aurskog-holand */
    { .label = {   3625, 21, 0 } }, /* xn--aurskog-hland-jnb */
    { .label = {  88877,  9, 0 } }, /* austevoll */
    { .label = {  88917,  9, 0 } }, /* austrheim */
    { .label = { 147788,  6, 0 } }, /* averoy */
    { .label = {  35152, 13, 0 } }, /* xn--avery-yua */
    { .label = {  72393, 10, 0 } }, /* balestrand */
    { .label = {  88955,  9, 0 } }, /* ballangen */
    { .label = {  54388,  5, 0 } }, /* balat */
    { .label = {  44577, 12, 0 } }, /* xn--blt-elab */
    { .label = {  88994,  9, 0 } }, /* balsfjord */
    { .label = {  44635, 12, 0 } }, /* bahccavuotna */
    { .label = {   6860, 19, 0 } }, /* xn--bhccavuotna-k7a */
    { .label = { 147815,  6, 0 } }, /* bamble */
    { .label = { 159772,  5, 0 } }, /* bardu */
    { .label = { 147844,  6, 0 } }, /* beardu */
    { .label = { 147871,  6, 0 } }, /* beiarn */
    { .label = { 127827,  7, 0 } }, /* bajddar */
    { .label = {  27145, 14, 0 } }, /* xn--bjddar-pta */
    { .label = { 147896,  6, 0 } }, /* baidar */
    { .label = {  35214, 13, 0 } }, /* xn--bidr-5nac */
    { .label = {  22243,  4, 0 } }, /* berg */
    { .label = { 147921,  6, 0 } }, /* bergen */
    { .label = { 108821,  8, 0 } }, /* berlevag */
    { .label = {  20696, 15, 0 } }, /* xn--berlevg-jxa */
    { .label = {  57198, 11, 0 } }, /* bearalvahki */
    { .label = {   9039, 18, 0 } }, /* xn--bearalvhki-y4a */
    { .label = { 147948,  6, 0 } }, /* bindal */
    { .label = { 108858,  8, 0 } }, /* birkenes */
    { .label = { 127860,  7, 0 } }, /* bjarkoy */
    { .label = {  27213, 14, 0 } }, /* xn--bjarky-fya */
    { .label = {  89038,  9, 0 } }, /* bjerkreim */
    { .label = { 159795,  5, 0 } }, /* bjugn */
    { .label = { 166421,  4, 0 } }, /* bodo */
    { .label = {  57246, 11, 0 } }, /* xn--bod-2na */
    { .label = { 108893,  8, 0 } }, /* badaddja */
    { .label = {  20771, 15, 0 } }, /* xn--bdddj-mrabd */
    { .label = { 127895,  7, 0 } }, /* budejju */
    { .label = { 166440,  4, 0 } }, /* bokn */
    { .label = {  89081,  9, 0 } }, /* bremanger */
    { .label = {  56900,  7, 0 } }, /* bronnoy */
    { .label = {  27284, 14, 0 } }, /* xn--brnny-wuac */
    { .label = { 127934,  7, 0 } }, /* bygland */
    { .label = { 159822,  5, 0 } }, /* bykle */
    { .label = { 159848,  5, 0 } }, /* barum */
    { .label = {  44688, 12, 0 } }, /* xn--brum-voa */
    { .label = { 108930,  8, 1 } }, { .child = { 7714, 2 } }, /* telemark */
    { .label = { 108964,  8, 1 } }, { .child = { 7716, 4 } }, /* nordland */
    { .label = { 147975,  6, 0 } }, /* bievat */
    { .label = {  35279, 13, 0 } }, /* xn--bievt-0qa */
    { .label = { 159871,  5, 0 } }, /* bomlo */
    { .label = {  44746, 12, 0 } }, /* xn--bmlo-gra */
    { .label = {  89168,  9, 0 } }, /* batsfjord */
    { .label = {  15479, 16, 0 } }, /* xn--btsfjord-9za */
    { .label = {  57301, 11, 0 } }, /* bahcavuotna */
    { .label = {   9127, 18, 0 } }, /* xn--bhcavuotna-s4a */
    { .label = { 159895,  5, 0 } }, /* dovre */
    { .label = { 127968,  7, 0 } }, /* drammen */
    { .label = {  89211,  9, 0 } }, /* drangedal */
    { .label = { 159918,  5, 0 } }, /* dyroy */
    { .label = {  44803, 12, 0 } }, /* xn--dyry-ira */
    { .label = { 159943,  5, 0 } }, /* donna */
    { .label = {  44860, 12, 0 } }, /* xn--dnna-gra */
    { .label = {    361,  3, 0 } }, /* eid */
    { .label = { 108998,  8, 0 } }, /* eidfjord */
    { .label = { 109037,  8, 0 } }, /* eidsberg */
    { .label = { 127998,  7, 0 } }, /* eidskog */
    { .label = { 109073,  8, 0 } }, /* eidsvoll */
    { .label = {  89249,  9, 0 } }, /* eigersund */
    { .label = { 128029,  7, 0 } }, /* elverum */
    { .label = { 128062,  7, 0 } }, /* enebakk */
    { .label = { 109110,  8, 0 } }, /* engerdal */
    { .label = { 124142,  4, 0 } }, /* etne */
    { .label = { 128093,  7, 0 } }, /* etnedal */
    { .label = { 148002,  6, 0 } }, /* evenes */
    { .label = { 109144,  8, 0 } }, /* evenassi */
    { .label = {  11407, 17, 0 } }, /* xn--eveni-0qa01ga */
    { .label = {  20847, 15, 0 } }, /* evje-og-hornnes */
    { .label = { 128122,  7, 0 } }, /* farsund */
    { .label = { 148028,  6, 0 } }, /* fauske */
    { .label = { 128153,  7, 0 } }, /* fuossko */
    { .label = { 128185,  7, 0 } }, /* fuoisku */
    { .label = { 159963,  5, 0 } }, /* fedje */
    { .label = {  12955,  3, 0 } }, /* fet */
    { .label = { 148055,  6, 0 } }, /* finnoy */
    { .label = {  35347, 13, 0 } }, /* xn--finny-yua */
    { .label = { 148083,  6, 0 } }, /* fitjar */
    { .label = { 148111,  6, 0 } }, /* fjaler */
    { .label = {  45145,  5, 0 } }, /* fjell */
    { .label = { 109177,  8, 0 } }, /* flakstad */
    { .label = {  89288,  9, 0 } }, /* flatanger */
    { .label = {  57349, 11, 0 } }, /* flekkefjord */
    { .label = { 109212,  8, 0 } }, /* flesberg */
    { .label = { 159989,  5, 0 } }, /* flora */
    { .label = {  89288,  3, 0 } }, /* fla */
    { .label = {  72435, 10, 0 } }, /* xn--fl-zia */
    { .label = { 128218,  7, 0 } }, /* folldal */
    { .label = { 128251,  7, 0 } }, /* forsand */
    { .label = { 148140,  6, 0 } }, /* fosnes */
    { .label = { 106926,  4, 0 } }, /* frei */
    { .label = { 160011,  5, 0 } }, /* frogn */
    { .label = { 128281,  7, 0 } }, /* froland */
    { .label = { 148166,  6, 0 } }, /* frosta */
    { .label = { 160034,  5, 0 } }, /* frana */
    { .label = {  44913, 12, 0 } }, /* xn--frna-woa */
    { .label = { 160054,  5, 0 } }, /* froya */
    { .label = {  44968, 12, 0 } }, /* xn--frya-hra */
    { .label = {  81532,  4, 0 } }, /* fusa */
    { .label = { 109250,  8, 0 } }, /* fyresdal */
    { .label = { 160077,  5, 0 } }, /* forde */
    { .label = {  45024, 12, 0 } }, /* xn--frde-gra */
    { .label = { 148191,  6, 0 } }, /* gamvik */
    { .label = {  72485, 10, 0 } }, /* gangaviika */
    { .label = {   6952, 19, 0 } }, /* xn--ggaviika-8ya47h */
    { .label = { 148219,  6, 0 } }, /* gaular */
    { .label = { 128312,  7, 0 } }, /* gausdal */
    { .label = {  89326,  9, 0 } }, /* gildeskal */
    { .label = {  15564, 16, 0 } }, /* xn--gildeskl-g0a */
    { .label = { 160100,  5, 0 } }, /* giske */
    { .label = { 128342,  7, 0 } }, /* gjemnes */
    { .label = { 109287,  8, 0 } }, /* gjerdrum */
    { .label = { 109326,  8, 0 } }, /* gjerstad */
    { .label = { 128375,  7, 0 } }, /* gjesdal */
    { .label = { 148244,  6, 0 } }, /* gjovik */
    { .label = {  35410, 13, 0 } }, /* xn--gjvik-wua */
    { .label = { 128408,  7, 0 } }, /* gloppen */
    { .label = {  12380,  3, 0 } }, /* gol */
    { .label = {  24004,  4, 0 } }, /* gran */
    { .label = { 160122,  5, 0 } }, /* grane */
    { .label = { 128442,  7, 0 } }, /* granvin */
    { .label = {  89366,  9, 0 } }, /* gratangen */
    { .label = { 109362,  8, 0 } }, /* grimstad */
    { .label = { 160142,  5, 0 } }, /* grong */
    { .label = {  89402,  9, 0 } }, /* kraanghke */
    { .label = {  15642, 16, 0 } }, /* xn--kranghke-b0a */
    { .label = { 166459,  4, 0 } }, /* grue */
    { .label = { 160164,  5, 0 } }, /* gulen */
    { .label = { 148275,  6, 0 } }, /* hadsel */
    { .label = { 148301,  6, 0 } }, /* halden */
    { .label = { 160187,  5, 0 } }, /* halsa */
    { .label = { 107305,  5, 0 } }, /* hamar */
    { .label = { 128472,  7, 0 } }, /* hamaroy */
    { .label = { 148327,  6, 0 } }, /* habmer */
    { .label = {  35476, 13, 0 } }, /* xn--hbmer-xqa */
    { .label = { 148354,  6, 0 } }, /* hapmir */
    { .label = {  35542, 13, 0 } }, /* xn--hpmir-xqa */
    { .label = {  72527, 10, 0 } }, /* hammerfest */
    { .label = {  45080, 12, 0 } }, /* hammarfeasta */
    { .label = {   7053, 19, 0 } }, /* xn--hmmrfeasta-s4ac */
    { .label = { 102526,  5, 0 } }, /* haram */
    { .label = { 148381,  6, 0 } }, /* hareid */
    { .label = { 128502,  7, 0 } }, /* harstad */
    { .label = { 148406,  6, 0 } }, /* hasvik */
    { .label = {  72571, 10, 0 } }, /* aknoluokta */
    { .label = {   7142, 19, 0 } }, /* xn--koluokta-7ya57h */
    { .label = {  45129, 12, 0 } }, /* hattfjelldal */
    { .label = { 109396,  8, 0 } }, /* aarborte */
    { .label = {  89440,  9, 0 } }, /* haugesund */
    { .label = { 148433,  5, 0 } }, /* hemne */
    { .label = { 148433,  6, 0 } }, /* hemnes */
    { .label = { 109428,  8, 0 } }, /* hemsedal */
    { .label = {  20916, 15, 1 } }, { .child = { 7720, 2 } }, /* more-og-romsdal */
    { .label = {   2491, 22, 1 } }, { .child = { 7722, 2 } }, /* xn--mre-og-romsdal-qqb */
    { .label = { 160230,  5, 0 } }, /* hitra */
    { .label = { 109463,  8, 0 } }, /* hjartdal */
    { .label = {  72613, 10, 0 } }, /* hjelmeland */
    { .label = { 160250,  5, 0 } }, /* hobol */
    { .label = {  45240, 12, 0 } }, /* xn--hobl-ira */
    { .label = { 125878,  3, 0 } }, /* hof */
    { .label = {  21002,  3, 0 } }, /* hol */
    { .label = { 166477,  4, 0 } }, /* hole */
    { .label = {  57404, 11, 0 } }, /* holmestrand */
    { .label = { 109499,  8, 0 } }, /* holtalen */
    { .label = {  20982, 15, 0 } }, /* xn--holtlen-hxa */
    { .label = {  89480,  9, 0 } }, /* hornindal */
    { .label = { 148459,  6, 0 } }, /* horten */
    { .label = { 148484,  6, 0 } }, /* hurdal */
    { .label = { 160274,  5, 0 } }, /* hurum */
    { .label = { 148511,  6, 0 } }, /* hvaler */
    { .label = {  89518,  9, 0 } }, /* hyllestad */
    { .label = {  72660, 10, 0 } }, /* hagebostad */
    { .label = {  11497, 17, 0 } }, /* xn--hgebostad-g3a */
    { .label = { 109533,  8, 0 } }, /* hoyanger */
    { .label = {  21052, 15, 0 } }, /* xn--hyanger-q1a */
    { .label = {  89559,  9, 0 } }, /* hoylandet */
    { .label = {  15719, 16, 0 } }, /* xn--hylandet-54a */
    { .label = {    592,  2, 0 } }, /* ha */
    { .label = {  89599,  9, 0 } }, /* xn--h-2fa */
    { .label = { 128530,  7, 0 } }, /* ibestad */
    { .label = { 128560,  7, 0 } }, /* inderoy */
    { .label = {  27352, 14, 0 } }, /* xn--indery-fya */
    { .label = { 128591,  7, 0 } }, /* iveland */
    { .label = { 109568,  8, 0 } }, /* jevnaker */
    { .label = {  88521,  6, 0 } }, /* jondal */
    { .label = { 128622,  7, 0 } }, /* jolster */
    { .label = {  27419, 14, 0 } }, /* xn--jlster-bya */
    { .label = { 109605,  8, 0 } }, /* karasjok */
    { .label = {  72703, 10, 0 } }, /* karasjohka */
    { .label = {   7243, 19, 0 } }, /* xn--krjohka-hwab49j */
    { .label = { 128654,  7, 0 } }, /* karlsoy */
    { .label = { 160298,  5, 0 } }, /* galsa */
    { .label = {  45296, 12, 0 } }, /* xn--gls-elac */
    { .label = { 148538,  6, 0 } }, /* karmoy */
    { .label = {  35608, 13, 0 } }, /* xn--karmy-yua */
    { .label = {  72746, 10, 0 } }, /* kautokeino */
    { .label = {  35670, 13, 0 } }, /* guovdageaidnu */
    { .label = { 160318,  5, 0 } }, /* klepp */
    { .label = { 160344,  5, 0 } }, /* klabu */
    { .label = {  45352, 12, 0 } }, /* xn--klbu-woa */
    { .label = {  89646,  9, 0 } }, /* kongsberg */
    { .label = {  57451, 11, 0 } }, /* kongsvinger */
    { .label = { 128685,  7, 0 } }, /* kragero */
    { .label = {  27487, 14, 0 } }, /* xn--krager-gya */
    { .label = {  45411, 12, 0 } }, /* kristiansand */
    { .label = {  45459, 12, 0 } }, /* kristiansund */
    { .label = {  72788, 10, 0 } }, /* krodsherad */
    { .label = {  11578, 17, 0 } }, /* xn--krdsherad-m8a */
    { .label = { 109640,  8, 0 } }, /* kvalsund */
    { .label = {  57500, 11, 0 } }, /* rahkkeravju */
    { .label = {   9213, 18, 0 } }, /* xn--rhkkervju-01af */
    { .label = { 166495,  4, 0 } }, /* kvam */
    { .label = {  89687,  9, 0 } }, /* kvinesdal */
    { .label = {  72831, 10, 0 } }, /* kvinnherad */
    { .label = {  89727,  9, 0 } }, /* kviteseid */
    { .label = { 128714,  7, 0 } }, /* kvitsoy */
    { .label = {  27551, 14, 0 } }, /* xn--kvitsy-fya */
    { .label = { 109677,  8, 0 } }, /* kvafjord */
    { .label = {  21127, 15, 0 } }, /* xn--kvfjord-nxa */
    { .label = {  35728, 13, 0 } }, /* giehtavuoatna */
    { .label = {  89767,  9, 0 } }, /* kvanangen */
    { .label = {  15801, 16, 0 } }, /* xn--kvnangen-k0a */
    { .label = { 109717,  8, 0 } }, /* navuotna */
    { .label = {  21202, 15, 0 } }, /* xn--nvuotna-hwa */
    { .label = { 128747,  7, 0 } }, /* kafjord */
    { .label = {  27620, 14, 0 } }, /* xn--kfjord-iua */
    { .label = {  89805,  9, 0 } }, /* gaivuotna */
    { .label = {  15877, 16, 0 } }, /* xn--givuotna-8ya */
    { .label = { 148565,  6, 0 } }, /* larvik */
    { .label = { 109750,  8, 0 } }, /* lavangen */
    { .label = { 128781,  7, 0 } }, /* lavagis */
    { .label = { 148592,  6, 0 } }, /* loabat */
    { .label = {  35782, 13, 0 } }, /* xn--loabt-0qa */
    { .label = { 128811,  7, 0 } }, /* lebesby */
    { .label = {  72875, 10, 0 } }, /* davvesiida */
    { .label = {  89843,  9, 0 } }, /* leikanger */
    { .label = {  89881,  9, 0 } }, /* leirfjord */
    { .label = {  91249,  4, 0 } }, /* leka */
    { .label = { 128846,  7, 0 } }, /* leksvik */
    { .label = { 148617,  6, 0 } }, /* lenvik */
    { .label = {  57551, 11, 0 } }, /* leangaviika */
    { .label = {   9308, 18, 0 } }, /* xn--leagaviika-52b */
    { .label = { 160368,  5, 0 } }, /* lesja */
    { .label = { 109784,  8, 0 } }, /* levanger */
    { .label = {  71852,  4, 0 } }, /* lier */
    { .label = { 148645,  6, 0 } }, /* lierne */
    { .label = {  57597, 11, 0 } }, /* lillehammer */
    { .label = {  89924,  9, 0 } }, /* lillesand */
    { .label = {  89963,  9, 0 } }, /* lindesnes */
    { .label = { 148670,  6, 0 } }, /* lindas */
    { .label = {  35848, 13, 0 } }, /* xn--linds-pra */
    { .label = {  17830,  3, 0 } }, /* lom */
    { .label = { 160391,  5, 0 } }, /* loppa */
    { .label = { 148695,  6, 0 } }, /* lahppi */
    { .label = {  35908, 13, 0 } }, /* xn--lhppi-xqa */
    { .label = { 113825,  4, 0 } }, /* lund */
    { .label = { 148724,  6, 0 } }, /* lunner */
    { .label = { 160415,  5, 0 } }, /* luroy */
    { .label = {  45509, 12, 0 } }, /* xn--lury-ira */
    { .label = {  23605,  6, 0 } }, /* luster */
    { .label = { 128879,  7, 0 } }, /* lyngdal */
    { .label = { 148750,  6, 0 } }, /* lyngen */
    { .label = { 166514,  4, 0 } }, /* ivgu */
    { .label = { 148778,  6, 0 } }, /* lardal */
    { .label = { 148803,  6, 0 } }, /* lerdal */
    { .label = {  35976, 13, 0 } }, /* xn--lrdal-sra */
    { .label = { 109819,  8, 0 } }, /* lodingen */
    { .label = {  21271, 15, 0 } }, /* xn--ldingen-q1a */
    { .label = {  90001,  9, 0 } }, /* lorenskog */
    { .label = {  15955, 16, 0 } }, /* xn--lrenskog-54a */
    { .label = { 160439,  5, 0 } }, /* loten */
    { .label = {  45565, 12, 0 } }, /* xn--lten-gra */
    { .label = { 129648,  6, 0 } }, /* malvik */
    { .label = { 128663,  5, 0 } }, /* masoy */
    { .label = {  36034, 13, 0 } }, /* xn--msy-ula0h */
    { .label = { 148829,  6, 0 } }, /* muosat */
    { .label = {  36100, 13, 0 } }, /* xn--muost-0qa */
    { .label = { 148854,  6, 0 } }, /* mandal */
    { .label = { 148879,  6, 0 } }, /* marker */
    { .label = {  90040,  9, 0 } }, /* marnardal */
    { .label = {  72919, 10, 0 } }, /* masfjorden */
    { .label = {  72634,  6, 0 } }, /* meland */
    { .label = { 148904,  6, 0 } }, /* meldal */
    { .label = { 148931,  6, 0 } }, /* melhus */
    { .label = { 160460,  5, 0 } }, /* meloy */
    { .label = {  45619, 12, 0 } }, /* xn--mely-ira */
    { .label = { 128912,  7, 0 } }, /* meraker */
    { .label = {  27688, 14, 0 } }, /* xn--merker-kua */
    { .label = { 128941,  7, 0 } }, /* moareke */
    { .label = {  27752, 14, 0 } }, /* xn--moreke-jua */
    { .label = { 128970,  7, 0 } }, /* midsund */
    { .label = {  27818, 14, 0 } }, /* midtre-gauldal */
    { .label = { 129002,  7, 0 } }, /* modalen */
    { .label = { 160484,  5, 0 } }, /* modum */
    { .label = { 160508,  5, 0 } }, /* molde */
    { .label = { 109854,  8, 0 } }, /* moskenes */
    { .label = {  87263,  4, 0 } }, /* moss */
    { .label = { 148959,  6, 0 } }, /* mosvik */
    { .label = { 129032,  7, 0 } }, /* malselv */
    { .label = {  27880, 14, 0 } }, /* xn--mlselv-iua */
    { .label = {  57646, 11, 0 } }, /* malatvuopmi */
    { .label = {   9398, 18, 0 } }, /* xn--mlatvuopmi-s4a */
    { .label = {  72965, 10, 0 } }, /* namdalseid */
    { .label = { 148987,  6, 0 } }, /* aejrie */
    { .label = { 149013,  6, 0 } }, /* namsos */
    { .label = {  73007, 10, 0 } }, /* namsskogan */
    { .label = {  27946, 14, 0 } }, /* naamesjevuemie */
    { .label = {   3724, 21, 0 } }, /* xn--nmesjevuemie-tcba */
    { .label = {  45675, 12, 0 } }, /* laakesvuemie */
    { .label = {  90076,  9, 0 } }, /* nannestad */
    { .label = { 149037,  6, 0 } }, /* narvik */
    { .label = { 109888,  8, 0 } }, /* narviika */
    { .label = { 109921,  8, 0 } }, /* naustdal */
    { .label = {  57696, 11, 0 } }, /* nedre-eiker */
    { .label = { 109954,  8, 1 } }, { .child = { 7724, 1 } }, /* akershus */
    { .label = { 109988,  8, 1 } }, { .child = { 7725, 1 } }, /* buskerud */
    { .label = { 109876,  5, 0 } }, /* nesna */
    { .label = { 110026,  8, 0 } }, /* nesodden */
    { .label = { 129064,  7, 0 } }, /* nesseby */
    { .label = { 129096,  7, 0 } }, /* unjarga */
    { .label = {  28008, 14, 0 } }, /* xn--unjrga-rta */
    { .label = { 149063,  6, 0 } }, /* nesset */
    { .label = { 110060,  8, 0 } }, /* nissedal */
    { .label = { 110093,  8, 0 } }, /* nittedal */
    { .label = {  57743, 11, 0 } }, /* nord-aurdal */
    { .label = {  90111,  9, 0 } }, /* nord-fron */
    { .label = {  90151,  9, 0 } }, /* nord-odal */
    { .label = { 129127,  7, 0 } }, /* norddal */
    { .label = { 110126,  8, 0 } }, /* nordkapp */
    { .label = {  57790, 11, 0 } }, /* davvenjarga */
    { .label = {   9486, 18, 0 } }, /* xn--davvenjrga-y4a */
    { .label = {  57840, 11, 0 } }, /* nordre-land */
    { .label = {  90190,  9, 0 } }, /* nordreisa */
    { .label = { 160531,  5, 0 } }, /* raisa */
    { .label = {  45727, 12, 0 } }, /* xn--risa-5na */
    { .label = {  36166, 13, 0 } }, /* nore-og-uvdal */
    { .label = { 110163,  8, 0 } }, /* notodden */
    { .label = { 160549,  5, 0 } }, /* naroy */
    { .label = {  36225, 13, 0 } }, /* xn--nry-yla5g */
    { .label = { 110197,  8, 0 } }, /* notteroy */
    { .label = {  21346, 15, 0 } }, /* xn--nttery-byae */
    { .label = {  27174,  4, 0 } }, /* odda */
    { .label = { 149087,  6, 0 } }, /* oksnes */
    { .label = {  36292, 13, 0 } }, /* xn--ksnes-uua */
    { .label = { 149112,  6, 0 } }, /* oppdal */
    { .label = { 110231,  8, 0 } }, /* oppegard */
    { .label = {  21416, 15, 0 } }, /* xn--oppegrd-ixa */
    { .label = { 149141,  6, 0 } }, /* orkdal */
    { .label = { 127802,  6, 0 } }, /* orland */
    { .label = {  36351, 13, 0 } }, /* xn--rland-uua */
    { .label = {   3649,  6, 0 } }, /* orskog */
    { .label = {  36410, 13, 0 } }, /* xn--rskog-uua */
    { .label = { 160570,  5, 0 } }, /* orsta */
    { .label = {  45783, 12, 0 } }, /* xn--rsta-fra */
    { .label = { 129157,  7, 1 } }, { .child = { 7726, 3 } }, /* hedmark */
    { .label = {  90226,  9, 1 } }, { .child = { 7729, 1 } }, /* hordaland */
    { .label = { 107649,  4, 0 } }, /* osen */
    { .label = { 129188,  7, 0 } }, /* osteroy */
    { .label = {  28072, 14, 0 } }, /* xn--ostery-fya */
    { .label = {  57887, 11, 0 } }, /* ostre-toten */
    { .label = {   9576, 18, 0 } }, /* xn--stre-toten-zcb */
    { .label = {  90264,  9, 0 } }, /* overhalla */
    { .label = {  73048, 10, 0 } }, /* ovre-eiker */
    { .label = {  11659, 17, 0 } }, /* xn--vre-eiker-k8a */
    { .label = { 151676,  4, 0 } }, /* oyer */
    { .label = {  57932, 11, 0 } }, /* xn--yer-zna */
    { .label = { 110268,  8, 0 } }, /* oygarden */
    { .label = {  21488, 15, 0 } }, /* xn--ygarden-p1a */
    { .label = {  36470, 13, 0 } }, /* oystre-slidre */
    { .label = {   4476, 20, 0 } }, /* xn--ystre-slidre-ujb */
    { .label = {  90303,  9, 0 } }, /* porsanger */
    { .label = { 110303,  8, 0 } }, /* porsangu */
    { .label = {  11741, 17, 0 } }, /* xn--porsgu-sta26f */
    { .label = {  90341,  9, 0 } }, /* porsgrunn */
    { .label = { 160589,  5, 0 } }, /* radoy */
    { .label = {  45836, 12, 0 } }, /* xn--rady-ira */
    { .label = {  90381,  9, 0 } }, /* rakkestad */
    { .label = {  68532,  4, 0 } }, /* rana */
    { .label = { 149167,  6, 0 } }, /* ruovat */
    { .label = {  90418,  9, 0 } }, /* randaberg */
    { .label = { 157459,  5, 0 } }, /* rauma */
    { .label = { 110338,  8, 0 } }, /* rendalen */
    { .label = { 129218,  7, 0 } }, /* rennebu */
    { .label = { 110371,  8, 0 } }, /* rennesoy */
    { .label = {  21561, 15, 0 } }, /* xn--rennesy-v1a */
    { .label = { 149193,  6, 0 } }, /* rindal */
    { .label = { 129249,  7, 0 } }, /* ringebu */
    { .label = {  90456,  9, 0 } }, /* ringerike */
    { .label = {  90494,  9, 0 } }, /* ringsaker */
    { .label = { 160611,  5, 0 } }, /* rissa */
    { .label = { 160630,  5, 0 } }, /* risor */
    { .label = {  45890, 12, 0 } }, /* xn--risr-ira */
    { .label = {  37199,  4, 0 } }, /* roan */
    { .label = { 149218,  6, 0 } }, /* rollag */
    { .label = { 160650,  5, 0 } }, /* rygge */
    { .label = { 110405,  8, 0 } }, /* ralingen */
    { .label = {  21633, 15, 0 } }, /* xn--rlingen-mxa */
    { .label = { 160674,  5, 0 } }, /* rodoy */
    { .label = {  45942, 12, 0 } }, /* xn--rdy-0nab */
    { .label = { 129281,  7, 0 } }, /* romskog */
    { .label = {  28138, 14, 0 } }, /* xn--rmskog-bya */
    { .label = { 160697,  5, 0 } }, /* roros */
    { .label = {  46003, 12, 0 } }, /* xn--rros-gra */
    { .label = {  73694,  4, 0 } }, /* rost */
    { .label = {  57985, 11, 0 } }, /* xn--rst-0na */
    { .label = { 149244,  6, 0 } }, /* royken */
    { .label = {  36527, 13, 0 } }, /* xn--ryken-vua */
    { .label = { 129312,  7, 0 } }, /* royrvik */
    { .label = {  28205, 14, 0 } }, /* xn--ryrvik-bya */
    { .label = {  39621,  4, 0 } }, /* rade */
    { .label = {  58037, 11, 0 } }, /* xn--rde-ula */
    { .label = { 110438,  8, 0 } }, /* salangen */
    { .label = { 129345,  7, 0 } }, /* siellak */
    { .label = { 129375,  7, 0 } }, /* saltdal */
    { .label = { 113200,  5, 0 } }, /* salat */
    { .label = {  46056, 12, 0 } }, /* xn--slt-elab */
    { .label = {  46112, 12, 0 } }, /* xn--slat-5na */
    { .label = {  90531,  9, 0 } }, /* samnanger */
    { .label = { 110470,  8, 1 } }, { .child = { 7730, 1 } }, /* vestfold */
    { .label = {  73092, 10, 0 } }, /* sandefjord */
    { .label = {   6793,  7, 0 } }, /* sandnes */
    { .label = { 149271,  6, 0 } }, /* sandoy */
    { .label = {  36589, 13, 0 } }, /* xn--sandy-yua */
    { .label = {  90567,  9, 0 } }, /* sarpsborg */
    { .label = { 160717,  5, 0 } }, /* sauda */
    { .label = { 110508,  8, 0 } }, /* sauherad */
    { .label = {  15260,  3, 0 } }, /* sel */
    { .label = { 160737,  5, 0 } }, /* selbu */
    { .label = { 160761,  5, 0 } }, /* selje */
    { .label = { 129404,  7, 0 } }, /* seljord */
    { .label = { 149297,  6, 0 } }, /* sigdal */
    { .label = { 149323,  6, 0 } }, /* siljan */
    { .label = { 149350,  6, 0 } }, /* sirdal */
    { .label = { 160785,  5, 0 } }, /* skaun */
    { .label = {  34976,  7, 0 } }, /* skedsmo */
    { .label = {  28294,  3, 0 } }, /* ski */
    { .label = { 160806,  5, 0 } }, /* skien */
    { .label = { 110541,  8, 0 } }, /* skiptvet */
    { .label = { 110578,  8, 0 } }, /* skjervoy */
    { .label = {  21702, 15, 0 } }, /* xn--skjervy-v1a */
    { .label = { 129437,  7, 0 } }, /* skierva */
    { .label = {  28274, 14, 0 } }, /* xn--skierv-uta */
    { .label = { 160827,  5, 0 } }, /* skjak */
    { .label = {  46169, 12, 0 } }, /* xn--skjk-soa */
    { .label = { 149375,  6, 0 } }, /* skodje */
    { .label = { 110618,  8, 0 } }, /* skanland */
    { .label = {  21780, 15, 0 } }, /* xn--sknland-fxa */
    { .label = { 149404,  6, 0 } }, /* skanit */
    { .label = {  36650, 13, 0 } }, /* xn--sknit-yqa */
    { .label = { 160851,  5, 0 } }, /* smola */
    { .label = {  46226, 12, 0 } }, /* xn--smla-hra */
    { .label = {  73138, 10, 0 } }, /* snillfjord */
    { .label = { 160872,  5, 0 } }, /* snasa */
    { .label = {  46280, 12, 0 } }, /* xn--snsa-roa */
    { .label = { 149428,  6, 0 } }, /* snoasa */
    { .label = { 149450,  6, 0 } }, /* snaase */
    { .label = {  36713, 13, 0 } }, /* xn--snase-nra */
    { .label = { 129467,  7, 0 } }, /* sogndal */
    { .label = { 129497,  7, 0 } }, /* sokndal */
    { .label = {  60189,  4, 0 } }, /* sola */
    { .label = { 149472,  6, 0 } }, /* solund */
    { .label = {  90607,  9, 0 } }, /* songdalen */
    { .label = { 110651,  8, 0 } }, /* sortland */
    { .label = {  90645,  9, 0 } }, /* spydeberg */
    { .label = { 149499,  6, 0 } }, /* stange */
    { .label = {  90689,  9, 0 } }, /* stavanger */
    { .label = { 129527,  7, 0 } }, /* steigen */
    { .label = {  90726,  9, 0 } }, /* steinkjer */
    { .label = {  20631,  8, 0 } }, /* stjordal */
    { .label = {  21850, 15, 0 } }, /* xn--stjrdal-s1a */
    { .label = { 149523,  6, 0 } }, /* stokke */
    { .label = {  58088, 11, 0 } }, /* stor-elvdal */
    { .label = { 129556,  5, 0 } }, /* stord */
    { .label = { 129556,  7, 0 } }, /* stordal */
    { .label = {  90766,  9, 0 } }, /* storfjord */
    { .label = {  73186, 10, 0 } }, /* omasvuotna */
    { .label = {  57427,  6, 0 } }, /* strand */
    { .label = { 129585,  7, 0 } }, /* stranda */
    { .label = { 160890,  5, 0 } }, /* stryn */
    { .label = {  91787,  4, 0 } }, /* sula */
    { .label = { 149549,  6, 0 } }, /* suldal */
    { .label = {   8994,  4, 0 } }, /* sund */
    { .label = { 129612,  7, 0 } }, /* sunndal */
    { .label = { 110684,  8, 0 } }, /* surnadal */
    { .label = { 160912,  5, 0 } }, /* sveio */
    { .label = { 129642,  7, 0 } }, /* svelvik */
    { .label = {  90808,  9, 0 } }, /* sykkylven */
    { .label = { 160934,  5, 0 } }, /* sogne */
    { .label = {  46331, 12, 0 } }, /* xn--sgne-gra */
    { .label = { 160955,  5, 0 } }, /* somna */
    { .label = {  46385, 12, 0 } }, /* xn--smna-gra */
    { .label = {  58137, 11, 0 } }, /* sondre-land */
    { .label = {   9660, 18, 0 } }, /* xn--sndre-land-0cb */
    { .label = {  73228, 10, 0 } }, /* sor-aurdal */
    { .label = {  11828, 17, 0 } }, /* xn--sr-aurdal-l8a */
    { .label = { 110717,  8, 0 } }, /* sor-fron */
    { .label = {  21922, 15, 0 } }, /* xn--sr-fron-q1a */
    { .label = { 110752,  8, 0 } }, /* sor-odal */
    { .label = {  21997, 15, 0 } }, /* xn--sr-odal-q1a */
    { .label = {  46438, 12, 0 } }, /* sor-varanger */
    { .label = {   7347, 19, 0 } }, /* xn--sr-varanger-ggb */
    { .label = {  36768, 13, 0 } }, /* matta-varjjat */
    { .label = {   4572, 20, 0 } }, /* xn--mtta-vrjjat-k7af */
    { .label = { 129676,  7, 0 } }, /* sorfold */
    { .label = {  28338, 14, 0 } }, /* xn--srfold-bya */
    { .label = { 110786,  8, 0 } }, /* sorreisa */
    { .label = {  22071, 15, 0 } }, /* xn--srreisa-q1a */
    { .label = { 160975,  5, 0 } }, /* sorum */
    { .label = {  46488, 12, 0 } }, /* xn--srum-gra */
    { .label = {   6306,  4, 0 } }, /* tana */
    { .label = { 149576,  6, 0 } }, /* deatnu */
    { .label = {  56800,  4, 0 } }, /* time */
    { .label = { 110817,  8, 0 } }, /* tingvoll */
    { .label = { 134514,  4, 0 } }, /* tinn */
    { .label = {  90853,  9, 0 } }, /* tjeldsund */
    { .label = {  36826, 13, 0 } }, /* dielddanuorri */
    { .label = { 160997,  5, 0 } }, /* tjome */
    { .label = {  46543, 12, 0 } }, /* xn--tjme-hra */
    { .label = { 149527,  5, 0 } }, /* tokke */
    { .label = { 161021,  5, 0 } }, /* tolga */
    { .label = { 129708,  7, 0 } }, /* torsken */
    { .label = { 149601,  6, 0 } }, /* tranoy */
    { .label = {  36882, 13, 0 } }, /* xn--trany-yua */
    { .label = { 149626,  6, 0 } }, /* tromso */
    { .label = {  36942, 13, 0 } }, /* xn--troms-zua */
    { .label = { 149651,  6, 0 } }, /* tromsa */
    { .label = { 149655,  5, 0 } }, /* romsa */
    { .label = {  90896,  9, 0 } }, /* trondheim */
    { .label = { 110854,  8, 0 } }, /* troandin */
    { .label = { 149675,  6, 0 } }, /* trysil */
    { .label = { 161042,  5, 0 } }, /* trana */
    { .label = {  46600, 12, 0 } }, /* xn--trna-woa */
    { .label = { 110886,  8, 0 } }, /* trogstad */
    { .label = {  22142, 15, 0 } }, /* xn--trgstad-r1a */
    { .label = {  58184, 11, 0 } }, /* tvedestrand */
    { .label = { 146618,  5, 0 } }, /* tydal */
    { .label = { 149702,  6, 0 } }, /* tynset */
    { .label = { 110919,  8, 0 } }, /* tysfjord */
    { .label = {  46653, 12, 0 } }, /* divtasvuodna */
    { .label = {  37003, 13, 0 } }, /* divttasvuotna */
    { .label = { 149728,  6, 0 } }, /* tysnes */
    { .label = { 149754,  6, 0 } }, /* tysvar */
    { .label = {  37059, 13, 0 } }, /* xn--tysvr-vra */
    { .label = { 110959,  8, 0 } }, /* tonsberg */
    { .label = {  22211, 15, 0 } }, /* xn--tnsberg-q1a */
    { .label = {  73270, 10, 0 } }, /* ullensaker */
    { .label = {  73313, 10, 0 } }, /* ullensvang */
    { .label = { 161060,  5, 0 } }, /* ulvik */
    { .label = { 149781,  6, 0 } }, /* utsira */
    { .label = { 161085,  5, 0 } }, /* vadso */
    { .label = {  46706, 12, 0 } }, /* xn--vads-jra */
    { .label = {  73358, 10, 0 } }, /* cahcesuolo */
    { .label = {   7434, 19, 0 } }, /* xn--hcesuolo-7ya35b */
    { .label = { 129737,  7, 0 } }, /* vaksdal */
    { .label = {   2925,  5, 0 } }, /* valle */
    { .label = {  57020,  4, 0 } }, /* vang */
    { .label = { 110994,  8, 0 } }, /* vanylven */
    { .label = { 161107,  5, 0 } }, /* vardo */
    { .label = {  46763, 12, 0 } }, /* xn--vard-jra */
    { .label = { 129768,  7, 0 } }, /* varggat */
    { .label = {  28406, 14, 0 } }, /* xn--vrggt-xqad */
    { .label = { 161129,  5, 0 } }, /* vefsn */
    { .label = { 129798,  7, 0 } }, /* vaapste */
    { .label = {  90935,  4, 0 } }, /* vega */
    { .label = {  90935,  9, 0 } }, /* vegarshei */
    { .label = {  16036, 16, 0 } }, /* xn--vegrshei-c0a */
    { .label = { 111032,  8, 0 } }, /* vennesla */
    { .label = { 149805,  6, 0 } }, /* verdal */
    { .label = { 149832,  6, 0 } }, /* verran */
    { .label = { 149857,  6, 0 } }, /* vestby */
    { .label = { 129828,  7, 0 } }, /* vestnes */
    { .label = {  37121, 13, 0 } }, /* vestre-slidre */
    { .label = {  46820, 12, 0 } }, /* vestre-toten */
    { .label = {  90974,  9, 0 } }, /* vestvagoy */
    { .label = {  11908, 17, 0 } }, /* xn--vestvgy-ixa6o */
    { .label = {  91016,  9, 0 } }, /* vevelstad */
    { .label = {  22895,  3, 0 } }, /* vik */
    { .label = { 161153,  5, 0 } }, /* vikna */
    { .label = {  73402, 10, 0 } }, /* vindafjord */
    { .label = { 161175,  5, 0 } }, /* volda */
    { .label = {  56998,  4, 0 } }, /* voss */
    { .label = { 161198,  5, 0 } }, /* varoy */
    { .label = {  37178, 13, 0 } }, /* xn--vry-yla5g */
    { .label = { 161221,  5, 0 } }, /* vagan */
    { .label = {  46871, 12, 0 } }, /* xn--vgan-qoa */
    { .label = { 149887,  6, 0 } }, /* voagat */
    { .label = { 149912,  6, 0 } }, /* vagsoy */
    { .label = {  28477, 14, 0 } }, /* xn--vgsy-qoa0j */
    { .label = { 161221,  4, 0 } }, /* vaga */
    { .label = {  58231, 11, 0 } }, /* xn--vg-yiab */
    { .label = { 129858,  7, 1 } }, { .child = { 7731, 1 } }, /* ostfold */
    { .label = {  28553, 14, 1 } }, { .child = { 7732, 1 } }, /* xn--stfold-9xa */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entry 7693 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7694 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7695 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7696 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7697 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7698 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7699 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7700 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7701 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7702 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7703 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7704 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7705 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7706 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7707 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7708 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7709 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7710 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7711 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7712 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entry 7713 */
    { .label = {    337,  2, 0 } }, /* gs */

    /* entries 7714 to 7715 */
    { .label = {    716,  2, 0 } }, /* bo */
    { .label = {  89120,  9, 0 } }, /* xn--b-5ga */

    /* entries 7716 to 7719 */
    { .label = {    716,  2, 0 } }, /* bo */
    { .label = {  89120,  9, 0 } }, /* xn--b-5ga */
    { .label = { 160207,  5, 0 } }, /* heroy */
    { .label = {  45185, 12, 0 } }, /* xn--hery-ira */

    /* entries 7720 to 7721 */
    { .label = { 160207,  5, 0 } }, /* heroy */
    { .label = {  73092,  5, 0 } }, /* sande */

    /* entries 7722 to 7723 */
    { .label = {  45185, 12, 0 } }, /* xn--hery-ira */
    { .label = {  73092,  5, 0 } }, /* sande */

    /* entry 7724 */
    { .label = {   6809,  3, 0 } }, /* nes */

    /* entry 7725 */
    { .label = {   6809,  3, 0 } }, /* nes */

    /* entries 7726 to 7728 */
    { .label = {     67,  2, 0 } }, /* os */
    { .label = { 148516,  5, 0 } }, /* valer */
    { .label = {  46929, 12, 0 } }, /* xn--vler-qoa */

    /* entry 7729 */
    { .label = {     67,  2, 0 } }, /* os */

    /* entry 7730 */
    { .label = {  73092,  5, 0 } }, /* sande */

    /* entry 7731 */
    { .label = { 148516,  5, 0 } }, /* valer */

    /* entry 7732 */
    { .label = {  46929, 12, 0 } }, /* xn--vler-qoa */

    /* entry 7733 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 7734 to 7740 */
    { .label = {  54555,  3, 0 } }, /* biz */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    106,  3, 0 } }, /* com */

    /* entries 7741 to 7744 */
    { .label = { 115462,  8, 0 } }, /* merseine */
    { .label = {  31895,  4, 0 } }, /* mine */
    { .label = { 115678,  8, 0 } }, /* shacknet */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entries 7745 to 7762 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 1 } }, { .child = { 7763, 1 } }, /* co */
    { .label = {   2545,  3, 0 } }, /* cri */
    { .label = {  77662,  4, 0 } }, /* geek */
    { .label = {   1386,  3, 0 } }, /* gen */
    { .label = { 166534,  4, 0 } }, /* govt */
    { .label = {   1503,  6, 0 } }, /* health */
    { .label = {   2052,  3, 0 } }, /* iwi */
    { .label = { 166553,  4, 0 } }, /* kiwi */
    { .label = { 118536,  5, 0 } }, /* maori */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  46988, 12, 0 } }, /* xn--mori-qsa */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  66519, 10, 0 } }, /* parliament */
    { .label = { 147370,  6, 0 } }, /* school */
    { .label = {  43390,  3, 0 } }, /* nym */

    /* entry 7763 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 7764 to 7772 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = {   4448,  6, 0 } }, /* museum */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  22835,  3, 0 } }, /* pro */

    /* entries 7773 to 7884 */
    { .label = { 127475,  5, 1 } }, { .child = { 7885, 1 } }, /* amune */
    { .label = { 114897,  8, 0 } }, /* pimienta */
    { .label = { 134642,  7, 0 } }, /* poivron */
    { .label = { 134674,  7, 0 } }, /* potager */
    { .label = {  62859, 11, 0 } }, /* sweetpepper */
    { .label = {     99,  2, 0 } }, /* ae */
    { .label = {    296,  2, 0 } }, /* us */
    { .label = { 134846,  7, 0 } }, /* certmgr */
    { .label = {  49465,  5, 1 } }, { .child = { 7886, 2 } }, /* cdn77 */
    { .label = {  49465, 12, 1 } }, { .child = { 7888, 1 } }, /* cdn77-secure */
    { .label = { 134919,  7, 0 } }, /* cloudns */
    { .label = { 135110,  7, 0 } }, /* duckdns */
    { .label = { 168458,  4, 0 } }, /* tunk */
    { .label = {  30648,  6, 1 } }, { .child = { 7891, 2 } }, /* dyndns */
    { .label = { 135143,  7, 0 } }, /* blogdns */
    { .label = { 115074,  8, 0 } }, /* blogsite */
    { .label = {  10000, 18, 0 } }, /* boldlygoingnowhere */
    { .label = { 115146,  8, 0 } }, /* dnsalias */
    { .label = { 135207,  7, 0 } }, /* dnsdojo */
    { .label = {  63469, 11, 0 } }, /* doesntexist */
    { .label = {  94750,  9, 0 } }, /* dontexist */
    { .label = { 135270,  7, 0 } }, /* doomdns */
    { .label = { 153903,  6, 0 } }, /* dvrdns */
    { .label = { 115178,  8, 0 } }, /* dynalias */
    { .label = {  38683, 13, 0 } }, /* endofinternet */
    { .label = {  16715, 16, 0 } }, /* endoftheinternet */
    { .label = { 136054,  7, 0 } }, /* from-me */
    { .label = {  94870,  9, 0 } }, /* game-host */
    { .label = { 153958,  6, 0 } }, /* gotdns */
    { .label = {  77464, 10, 0 } }, /* hobby-site */
    { .label = { 137151,  7, 0 } }, /* homedns */
    { .label = {  94811,  7, 0 } }, /* homeftp */
    { .label = {  94949,  9, 0 } }, /* homelinux */
    { .label = { 115248,  8, 0 } }, /* homeunix */
    { .label = {  30832, 14, 0 } }, /* is-a-bruinsfan */
    { .label = {  30957, 14, 0 } }, /* is-a-candidate */
    { .label = {  23955, 15, 0 } }, /* is-a-celticsfan */
    { .label = {  95027,  9, 0 } }, /* is-a-chef */
    { .label = {  95068,  9, 0 } }, /* is-a-geek */
    { .label = {  63707, 11, 0 } }, /* is-a-knight */
    { .label = {  24084, 15, 0 } }, /* is-a-linux-user */
    { .label = {  49940, 12, 0 } }, /* is-a-patsfan */
    { .label = {  63853, 11, 0 } }, /* is-a-soxfan */
    { .label = { 115320,  8, 0 } }, /* is-found */
    { .label = { 137242,  7, 0 } }, /* is-lost */
    { .label = { 115357,  8, 0 } }, /* is-saved */
    { .label = {  64042, 11, 0 } }, /* is-very-bad */
    { .label = {  50243, 12, 0 } }, /* is-very-evil */
    { .label = {  50300, 12, 0 } }, /* is-very-good */
    { .label = {  50356, 12, 0 } }, /* is-very-nice */
    { .label = {  39233, 13, 0 } }, /* is-very-sweet */
    { .label = { 115428,  8, 0 } }, /* isa-geek */
    { .label = {  95147,  9, 0 } }, /* kicks-ass */
    { .label = {  64146, 11, 0 } }, /* misconfused */
    { .label = { 137301,  7, 0 } }, /* podzone */
    { .label = {  77906, 10, 0 } }, /* readmyblog */
    { .label = { 154041,  6, 0 } }, /* selfip */
    { .label = {  39468, 13, 0 } }, /* sellsyourhome */
    { .label = { 115602,  8, 0 } }, /* servebbs */
    { .label = { 115640,  8, 0 } }, /* serveftp */
    { .label = {  95268,  9, 0 } }, /* servegame */
    { .label = {  50411, 12, 0 } }, /* stuff-4-sale */
    { .label = { 154070,  6, 0 } }, /* webhop */
    { .label = { 164559,  5, 0 } }, /* ddnss */
    { .label = {  95350,  9, 0 } }, /* accesscam */
    { .label = { 154130,  6, 0 } }, /* camdvr */
    { .label = { 115880,  8, 0 } }, /* freeddns */
    { .label = { 154158,  6, 0 } }, /* mywire */
    { .label = {  64247, 11, 0 } }, /* webredirect */
    { .label = {    325,  2, 1 } }, { .child = { 7893, 55 } }, /* eu */
    { .label = { 154241,  6, 0 } }, /* twmail */
    { .label = {  17401, 16, 0 } }, /* fedorainfracloud */
    { .label = {  50523, 12, 0 } }, /* fedorapeople */
    { .label = {  39697, 13, 1 } }, { .child = { 7948, 3 } }, /* fedoraproject */
    { .label = {  64541, 11, 0 } }, /* freedesktop */
    { .label = { 116755,  8, 0 } }, /* hepforge */
    { .label = {   7274,  2, 0 } }, /* js */
    { .label = { 154602,  6, 0 } }, /* uklugs */
    { .label = {  64744,  5, 0 } }, /* barsy */
    { .label = { 116867,  8, 0 } }, /* mayfirst */
    { .label = {  64932, 11, 0 } }, /* mozilla-iot */
    { .label = {  31690, 14, 0 } }, /* bmoattachments */
    { .label = { 138048,  7, 0 } }, /* dynserv */
    { .label = { 138016,  7, 0 } }, /* now-dns */
    { .label = {  64982, 11, 0 } }, /* cable-modem */
    { .label = {  78850, 10, 0 } }, /* collegefan */
    { .label = {  17472, 16, 0 } }, /* couchpotatofries */
    { .label = { 154787,  6, 0 } }, /* mlbfan */
    { .label = {  17543, 16, 0 } }, /* mysecuritycamera */
    { .label = { 154842,  6, 0 } }, /* nflfan */
    { .label = {  79168, 10, 0 } }, /* read-books */
    { .label = { 154924,  6, 0 } }, /* ufcfan */
    { .label = { 165038,  5, 0 } }, /* hopto */
    { .label = { 165111,  5, 0 } }, /* myftp */
    { .label = { 165088,  5, 0 } }, /* no-ip */
    { .label = { 164991,  5, 0 } }, /* zapto */
    { .label = {  65330, 11, 0 } }, /* my-firewall */
    { .label = {  79575, 10, 0 } }, /* myfirewall */
    { .label = { 165284,  5, 0 } }, /* spdns */
    { .label = { 138428,  7, 0 } }, /* dsmynas */
    { .label = { 117643,  8, 0 } }, /* familyds */
    { .label = {  96505,  9, 0 } }, /* tuxfamily */
    { .label = {   5493, 11, 0 } }, /* diskstation */
    { .label = {    517,  2, 0 } }, /* hk */
    { .label = { 138692,  7, 0 } }, /* wmflabs */
    { .label = {    527,  2, 0 } }, /* za */

    /* entry 7885 */
    { .label = {     89,  4, 0 } }, /* tele */

    /* entries 7886 to 7887 */
    { .label = {     21,  1, 0 } }, /* c */
    { .label = {   8625,  3, 0 } }, /* rsc */

    /* entries 7888 to 7889 */
    { .label = { 133468,  6, 1 } }, { .child = { 7890, 1 } }, /* origin */

    /* entry 7890 */
    { .label = {   7519,  3, 0 } }, /* ssl */

    /* entries 7891 to 7892 */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {  24410,  4, 0 } }, /* home */

    /* entries 7893 to 7947 */
    { .label = {     94,  2, 0 } }, /* al */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = {    340,  2, 0 } }, /* at */
    { .label = {    117,  2, 0 } }, /* au */
    { .label = {    555,  2, 0 } }, /* be */
    { .label = {   9229,  2, 0 } }, /* bg */
    { .label = {    133,  2, 0 } }, /* ca */
    { .label = {   2713,  2, 0 } }, /* cd */
    { .label = {    190,  2, 0 } }, /* ch */
    { .label = {   6811,  2, 0 } }, /* cn */
    { .label = {    674,  2, 0 } }, /* cy */
    { .label = {   3760,  2, 0 } }, /* cz */
    { .label = {    243,  2, 0 } }, /* de */
    { .label = {    206,  2, 0 } }, /* dk */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {     98,  2, 0 } }, /* ee */
    { .label = {    141,  2, 0 } }, /* es */
    { .label = {    391,  2, 0 } }, /* fi */
    { .label = {    298,  2, 0 } }, /* fr */
    { .label = {   4505,  2, 0 } }, /* gr */
    { .label = {   4397,  2, 0 } }, /* hr */
    { .label = {    291,  2, 0 } }, /* hu */
    { .label = {    119,  2, 0 } }, /* ie */
    { .label = {    556,  2, 0 } }, /* il */
    { .label = {    100,  2, 0 } }, /* in */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {    260,  2, 0 } }, /* is */
    { .label = {    151,  2, 0 } }, /* it */
    { .label = {   9443,  2, 0 } }, /* jp */
    { .label = {   3651,  2, 0 } }, /* kr */
    { .label = {    695,  2, 0 } }, /* lt */
    { .label = {   3643,  2, 0 } }, /* lu */
    { .label = {   9079,  2, 0 } }, /* lv */
    { .label = {   2717,  2, 0 } }, /* mc */
    { .label = {    591,  2, 0 } }, /* me */
    { .label = {    158,  2, 0 } }, /* mk */
    { .label = {   2788,  2, 0 } }, /* mt */
    { .label = {    194,  2, 0 } }, /* my */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    761,  2, 0 } }, /* ng */
    { .label = {   2951,  2, 0 } }, /* nl */
    { .label = {    162,  2, 0 } }, /* no */
    { .label = {    130,  2, 0 } }, /* nz */
    { .label = { 159439,  5, 0 } }, /* paris */
    { .label = {   5819,  2, 0 } }, /* pl */
    { .label = {   6812,  2, 0 } }, /* pt */
    { .label = { 169522,  3, 0 } }, /* q-a */
    { .label = {    524,  2, 0 } }, /* ro */
    { .label = {    204,  2, 0 } }, /* ru */
    { .label = {    629,  2, 0 } }, /* se */
    { .label = {    699,  2, 0 } }, /* si */
    { .label = {      6,  2, 0 } }, /* sk */
    { .label = {    465,  2, 0 } }, /* tr */
    { .label = {   6323,  2, 0 } }, /* uk */
    { .label = {    296,  2, 0 } }, /* us */

    /* entries 7948 to 7952 */
    { .label = {  13493,  5, 0 } }, /* cloud */
    { .label = {     67,  2, 1 } }, { .child = { 7953, 1 } }, /* os */
    { .label = {  28433,  3, 1 } }, { .child = { 7954, 1 } }, /* stg */

    /* entry 7953 */
    { .label = {   6750,  3, 0 } }, /* app */

    /* entries 7954 to 7955 */
    { .label = {     67,  2, 1 } }, { .child = { 7956, 1 } }, /* os */

    /* entry 7956 */
    { .label = {   6750,  3, 0 } }, /* app */

    /* entries 7957 to 7967 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  35712,  3, 0 } }, /* sld */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {  10040,  3, 0 } }, /* ing */
    { .label = {   9997,  3, 0 } }, /* abo */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entries 7968 to 7976 */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {  25342,  3, 0 } }, /* nom */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  43390,  3, 0 } }, /* nym */

    /* entries 7977 to 7979 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  42919,  3, 0 } }, /* edu */

    /* entry 7980 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 7981 to 7988 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  10027,  3, 0 } }, /* ngo */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {     39,  1, 0 } }, /* i */

    /* entries 7989 to 8002 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  25423,  3, 0 } }, /* fam */
    { .label = {  54555,  3, 0 } }, /* biz */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {  12949,  3, 0 } }, /* gok */
    { .label = {   4380,  3, 0 } }, /* gon */
    { .label = {  64576,  3, 0 } }, /* gop */
    { .label = {  17972,  3, 0 } }, /* gos */
    { .label = {  28720,  4, 0 } }, /* info */

    /* entries 8003 to 8169 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    362,  3, 0 } }, /* aid */
    { .label = {  90892,  4, 0 } }, /* agro */
    { .label = {  27179,  3, 0 } }, /* atm */
    { .label = {  13093,  4, 0 } }, /* auto */
    { .label = {  54555,  3, 0 } }, /* biz */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = { 161242,  5, 0 } }, /* gmina */
    { .label = {  22888,  3, 0 } }, /* gsm */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {  13548,  4, 0 } }, /* mail */
    { .label = { 149940,  6, 0 } }, /* miasta */
    { .label = {  96066,  5, 0 } }, /* media */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  37247, 13, 0 } }, /* nieruchomosci */
    { .label = {  25342,  3, 0 } }, /* nom */
    { .label = {  13487,  2, 0 } }, /* pc */
    { .label = { 149963,  6, 0 } }, /* powiat */
    { .label = {   1461,  4, 0 } }, /* priv */
    { .label = {  73450, 10, 0 } }, /* realestate */
    { .label = {   2926,  3, 0 } }, /* rel */
    { .label = {   6268,  3, 0 } }, /* sex */
    { .label = {  51187,  4, 0 } }, /* shop */
    { .label = { 161263,  5, 0 } }, /* sklep */
    { .label = {  23054,  3, 0 } }, /* sos */
    { .label = { 149990,  6, 0 } }, /* szkola */
    { .label = { 161287,  5, 0 } }, /* targi */
    { .label = {   2425,  2, 0 } }, /* tm */
    { .label = { 129890,  7, 0 } }, /* tourism */
    { .label = {   9925,  6, 0 } }, /* travel */
    { .label = {  91057,  9, 0 } }, /* turystyka */
    { .label = {   3879,  3, 1 } }, { .child = { 8170, 47 } }, /* gov */
    { .label = { 111100,  8, 0 } }, /* augustow */
    { .label = {  73489, 10, 0 } }, /* babia-gora */
    { .label = { 150051,  6, 0 } }, /* bedzin */
    { .label = { 129920,  7, 0 } }, /* beskidy */
    { .label = {  73532, 10, 0 } }, /* bialowieza */
    { .label = {  91135,  9, 0 } }, /* bialystok */
    { .label = { 129954,  7, 0 } }, /* bielawa */
    { .label = {  73578, 10, 0 } }, /* bieszczady */
    { .label = {  58286, 11, 0 } }, /* boleslawiec */
    { .label = {  91176,  9, 0 } }, /* bydgoszcz */
    { .label = { 161387,  5, 0 } }, /* bytom */
    { .label = { 129985,  7, 0 } }, /* cieszyn */
    { .label = { 130019,  7, 0 } }, /* czeladz */
    { .label = { 161412,  5, 0 } }, /* czest */
    { .label = {  91225,  9, 0 } }, /* dlugoleka */
    { .label = { 150081,  6, 0 } }, /* elblag */
    { .label = {  16619,  3, 0 } }, /* elk */
    { .label = { 150109,  6, 0 } }, /* glogow */
    { .label = { 130055,  7, 0 } }, /* gniezno */
    { .label = { 130087,  7, 0 } }, /* gorlice */
    { .label = { 130118,  7, 0 } }, /* grajewo */
    { .label = { 161436,  5, 0 } }, /* ilawa */
    { .label = { 111136,  8, 0 } }, /* jaworzno */
    { .label = {  47045, 12, 0 } }, /* jelenia-gora */
    { .label = { 161457,  5, 0 } }, /* jgora */
    { .label = { 150138,  6, 0 } }, /* kalisz */
    { .label = {  22286, 15, 0 } }, /* kazimierz-dolny */
    { .label = { 130151,  7, 0 } }, /* karpacz */
    { .label = { 130184,  7, 0 } }, /* kartuzy */
    { .label = { 130218,  7, 0 } }, /* kaszuby */
    { .label = { 111175,  8, 0 } }, /* katowice */
    { .label = { 161480,  5, 0 } }, /* kepno */
    { .label = { 130254,  7, 0 } }, /* ketrzyn */
    { .label = { 130288,  7, 0 } }, /* klodzko */
    { .label = {  73629, 10, 0 } }, /* kobierzyce */
    { .label = {  91266,  9, 0 } }, /* kolobrzeg */
    { .label = { 161503,  5, 0 } }, /* konin */
    { .label = {  73678, 10, 0 } }, /* konskowola */
    { .label = { 161524,  5, 0 } }, /* kutno */
    { .label = { 166807,  4, 0 } }, /* lapy */
    { .label = { 150166,  6, 0 } }, /* lebork */
    { .label = { 130323,  7, 0 } }, /* legnica */
    { .label = { 130353,  7, 0 } }, /* lezajsk */
    { .label = { 111210,  8, 0 } }, /* limanowa */
    { .label = { 161546,  5, 0 } }, /* lomza */
    { .label = { 150194,  6, 0 } }, /* lowicz */
    { .label = { 161570,  5, 0 } }, /* lubin */
    { .label = { 161594,  5, 0 } }, /* lukow */
    { .label = { 130388,  7, 0 } }, /* malbork */
    { .label = {  73722, 10, 0 } }, /* malopolska */
    { .label = { 111244,  8, 0 } }, /* mazowsze */
    { .label = { 150225,  6, 0 } }, /* mazury */
    { .label = { 150255,  6, 0 } }, /* mielec */
    { .label = { 150282,  6, 0 } }, /* mielno */
    { .label = { 130420,  7, 0 } }, /* mragowo */
    { .label = { 161619,  5, 0 } }, /* naklo */
    { .label = { 111284,  8, 0 } }, /* nowaruda */
    { .label = {  45433,  4, 0 } }, /* nysa */
    { .label = { 161640,  5, 0 } }, /* olawa */
    { .label = { 150308,  6, 0 } }, /* olecko */
    { .label = { 150335,  6, 0 } }, /* olkusz */
    { .label = { 130451,  7, 0 } }, /* olsztyn */
    { .label = { 130485,  7, 0 } }, /* opoczno */
    { .label = { 161661,  5, 0 } }, /* opole */
    { .label = { 130519,  7, 0 } }, /* ostroda */
    { .label = {  91310,  9, 0 } }, /* ostroleka */
    { .label = {  91347,  9, 0 } }, /* ostrowiec */
    { .label = {  73766, 10, 0 } }, /* ostrowwlkp */
    { .label = { 166827,  4, 0 } }, /* pila */
    { .label = { 166845,  4, 0 } }, /* pisz */
    { .label = { 130547,  7, 0 } }, /* podhale */
    { .label = { 111318,  8, 0 } }, /* podlasie */
    { .label = {  91386,  9, 0 } }, /* polkowice */
    { .label = { 130579,  7, 0 } }, /* pomorze */
    { .label = {  91429,  9, 0 } }, /* pomorskie */
    { .label = {  73814, 10, 0 } }, /* prochowice */
    { .label = { 111353,  8, 0 } }, /* pruszkow */
    { .label = {  91469,  9, 0 } }, /* przeworsk */
    { .label = { 150365,  6, 0 } }, /* pulawy */
    { .label = { 161684,  5, 0 } }, /* radom */
    { .label = { 111394,  8, 0 } }, /* rawa-maz */
    { .label = { 150396,  6, 0 } }, /* rybnik */
    { .label = { 130613,  7, 0 } }, /* rzeszow */
    { .label = {  84740,  5, 0 } }, /* sanok */
    { .label = { 161705,  5, 0 } }, /* sejny */
    { .label = { 161730,  5, 0 } }, /* slask */
    { .label = { 150425,  6, 0 } }, /* slupsk */
    { .label = {  91513,  9, 0 } }, /* sosnowiec */
    { .label = {  47097, 12, 0 } }, /* stalowa-wola */
    { .label = { 130649,  7, 0 } }, /* skoczow */
    { .label = {  47149, 12, 0 } }, /* starachowice */
    { .label = { 111430,  8, 0 } }, /* stargard */
    { .label = { 130684,  7, 0 } }, /* suwalki */
    { .label = { 111462,  8, 0 } }, /* swidnica */
    { .label = {  73861, 10, 0 } }, /* swiebodzin */
    { .label = {  58336, 11, 0 } }, /* swinoujscie */
    { .label = { 111497,  8, 0 } }, /* szczecin */
    { .label = { 111537,  8, 0 } }, /* szczytno */
    { .label = {  73909, 10, 0 } }, /* tarnobrzeg */
    { .label = { 161751,  5, 0 } }, /* tgory */
    { .label = { 161774,  5, 0 } }, /* turek */
    { .label = { 161796,  5, 0 } }, /* tychy */
    { .label = { 161822,  5, 0 } }, /* ustka */
    { .label = {  91552,  9, 0 } }, /* walbrzych */
    { .label = { 150454,  6, 0 } }, /* warmia */
    { .label = { 111578,  8, 0 } }, /* warszawa */
    { .label = {  19201,  3, 0 } }, /* waw */
    { .label = { 150479,  6, 0 } }, /* wegrow */
    { .label = { 150508,  6, 0 } }, /* wielun */
    { .label = {  91599,  5, 0 } }, /* wlocl */
    { .label = {  91599,  9, 0 } }, /* wloclawek */
    { .label = {  91642,  9, 0 } }, /* wodzislaw */
    { .label = { 130716,  7, 0 } }, /* wolomin */
    { .label = { 130748,  7, 0 } }, /* wroclaw */
    { .label = {  91686,  9, 0 } }, /* zachpomor */
    { .label = { 161843,  5, 0 } }, /* zagan */
    { .label = { 161865,  5, 0 } }, /* zarow */
    { .label = { 161889,  5, 0 } }, /* zgora */
    { .label = {  91729,  9, 0 } }, /* zgorzelec */
    { .label = { 106792,  4, 0 } }, /* beep */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   7867,  3, 0 } }, /* art */
    { .label = { 138234,  7, 0 } }, /* gliwice */
    { .label = { 154953,  6, 0 } }, /* krakow */
    { .label = { 154980,  6, 0 } }, /* poznan */
    { .label = { 130748,  4, 0 } }, /* wroc */
    { .label = { 117354,  8, 0 } }, /* zakopane */
    { .label = {  23852,  3, 0 } }, /* gda */
    { .label = { 155120,  6, 0 } }, /* gdansk */
    { .label = { 155146,  6, 0 } }, /* gdynia */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = { 165335,  5, 0 } }, /* sopot */

    /* entries 8170 to 8216 */
    { .label = {    244,  2, 0 } }, /* ap */
    { .label = {    129,  2, 0 } }, /* ic */
    { .label = {    260,  2, 0 } }, /* is */
    { .label = {    296,  2, 0 } }, /* us */
    { .label = { 161307,  5, 0 } }, /* kmpsp */
    { .label = { 161333,  5, 0 } }, /* kppsp */
    { .label = { 161360,  5, 0 } }, /* kwpsp */
    { .label = {  43114,  3, 0 } }, /* psp */
    { .label = { 166572,  4, 0 } }, /* wskr */
    { .label = { 161360,  3, 0 } }, /* kwp */
    { .label = {   5353,  2, 0 } }, /* mw */
    { .label = {   2528,  2, 0 } }, /* ug */
    { .label = {    110,  2, 0 } }, /* um */
    { .label = {  54814,  4, 0 } }, /* umig */
    { .label = { 166591,  4, 0 } }, /* ugim */
    { .label = { 166610,  4, 0 } }, /* upow */
    { .label = {    261,  2, 0 } }, /* uw */
    { .label = {  91098,  9, 0 } }, /* starostwo */
    { .label = {    136,  2, 0 } }, /* pa */
    { .label = {    324,  2, 0 } }, /* po */
    { .label = { 166631,  4, 0 } }, /* psse */
    { .label = {  39559,  3, 0 } }, /* pup */
    { .label = { 166649,  4, 0 } }, /* rzgw */
    { .label = {    355,  2, 0 } }, /* sa */
    { .label = {    131,  2, 0 } }, /* so */
    { .label = {    153,  2, 0 } }, /* sr */
    { .label = {   1187,  3, 0 } }, /* wsa */
    { .label = {   3657,  3, 0 } }, /* sko */
    { .label = {  77820,  3, 0 } }, /* uzs */
    { .label = { 166671,  4, 0 } }, /* wiih */
    { .label = { 166690,  4, 0 } }, /* winb */
    { .label = { 166710,  4, 0 } }, /* pinb */
    { .label = { 166013,  4, 0 } }, /* wios */
    { .label = { 166730,  4, 0 } }, /* witd */
    { .label = { 150018,  6, 0 } }, /* wzmiuw */
    { .label = {  11786,  3, 0 } }, /* piw */
    { .label = {  99822,  3, 0 } }, /* wiw */
    { .label = { 166749,  4, 0 } }, /* griw */
    { .label = {  17165,  3, 0 } }, /* wif */
    { .label = { 115797,  3, 0 } }, /* oum */
    { .label = {   5858,  3, 0 } }, /* sdn */
    { .label = {   9268,  2, 0 } }, /* zp */
    { .label = { 134108,  4, 0 } }, /* uppo */
    { .label = {   7748,  3, 0 } }, /* mup */
    { .label = { 166768,  4, 0 } }, /* wuoz */
    { .label = { 111066,  8, 0 } }, /* konsulat */
    { .label = { 166790,  4, 0 } }, /* oirm */

    /* entry 8217 */
    { .label = {  17691,  3, 0 } }, /* own */

    /* entries 8218 to 8222 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  16771,  3, 0 } }, /* net */

    /* entries 8223 to 8235 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  91664,  4, 0 } }, /* isla */
    { .label = {  22835,  3, 0 } }, /* pro */
    { .label = {  54555,  3, 0 } }, /* biz */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {  29414,  4, 0 } }, /* name */
    { .label = {    758,  3, 0 } }, /* est */
    { .label = {  51576,  4, 0 } }, /* prof */
    { .label = {    103,  2, 0 } }, /* ac */

    /* entries 8236 to 8250 */
    { .label = {   8820,  3, 0 } }, /* aaa */
    { .label = {    488,  3, 0 } }, /* aca */
    { .label = { 166866,  4, 0 } }, /* acct */
    { .label = { 139274,  6, 0 } }, /* avocat */
    { .label = {   3030,  3, 0 } }, /* bar */
    { .label = {  55656,  3, 0 } }, /* cpa */
    { .label = {   2740,  3, 0 } }, /* eng */
    { .label = {  65898,  3, 0 } }, /* jur */
    { .label = {  20188,  3, 0 } }, /* law */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = { 161912,  5, 0 } }, /* recht */
    { .label = { 134919,  7, 0 } }, /* cloudns */
    { .label = { 115829,  8, 1 } }, { .child = { 8251, 1 } }, /* dnstrace */
    { .label = {  64744,  5, 0 } }, /* barsy */

    /* entry 8251 */
    { .label = {  21577,  3, 0 } }, /* bci */

    /* entries 8252 to 8258 */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  17554,  3, 0 } }, /* sec */
    { .label = { 117846,  3, 0 } }, /* plo */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  16771,  3, 0 } }, /* net */

    /* entries 8259 to 8268 */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {  24180,  4, 0 } }, /* publ */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  25342,  4, 0 } }, /* nome */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  43390,  3, 0 } }, /* nym */

    /* entries 8269 to 8277 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {     40,  2, 0 } }, /* ne */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {   3988,  2, 0 } }, /* ed */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = { 161934,  5, 0 } }, /* belau */
    { .label = { 134919,  7, 0 } }, /* cloudns */
    { .label = { 168839,  4, 0 } }, /* x443 */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entries 8278 to 8284 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  51529,  4, 0 } }, /* coop */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 8285 to 8294 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  29414,  4, 0 } }, /* name */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   6667,  3, 0 } }, /* sch */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entries 8295 to 8298 */
    { .label = {   2766,  4, 0 } }, /* asso */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  25342,  3, 0 } }, /* nom */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 8299 to 8312 */
    { .label = {   7867,  4, 0 } }, /* arts */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 113331,  4, 0 } }, /* firm */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {  25342,  3, 0 } }, /* nom */
    { .label = {    252,  2, 0 } }, /* nt */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    182,  3, 0 } }, /* rec */
    { .label = { 155394,  5, 0 } }, /* store */
    { .label = {   2425,  2, 0 } }, /* tm */
    { .label = { 154681,  3, 0 } }, /* www */
    { .label = {  51187,  4, 0 } }, /* shop */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  43390,  3, 0 } }, /* nym */

    /* entries 8313 to 8321 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    100,  2, 0 } }, /* in */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  25342,  3, 0 } }, /* nom */
    { .label = {   5582,  2, 0 } }, /* ox */

    /* entries 8322 to 8355 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {   3901,  4, 0 } }, /* test */
    { .label = { 137399,  7, 0 } }, /* adygeya */
    { .label = {  95388,  9, 0 } }, /* bashkiria */
    { .label = {  56377,  3, 0 } }, /* bir */
    { .label = {  22101,  3, 0 } }, /* cbg */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 116078,  8, 0 } }, /* dagestan */
    { .label = { 154268,  6, 0 } }, /* grozny */
    { .label = { 116110,  8, 0 } }, /* kalmykia */
    { .label = { 116146,  8, 0 } }, /* kustanai */
    { .label = { 154298,  6, 0 } }, /* marine */
    { .label = { 116178,  8, 0 } }, /* mordovia */
    { .label = {   1468,  3, 0 } }, /* msk */
    { .label = { 164713,  5, 0 } }, /* mytis */
    { .label = { 137431,  7, 0 } }, /* nalchik */
    { .label = {  56947,  3, 0 } }, /* nov */
    { .label = {  78089, 10, 0 } }, /* pyatigorsk */
    { .label = { 161377,  3, 0 } }, /* spb */
    { .label = {  64297, 11, 0 } }, /* vladikavkaz */
    { .label = { 116213,  8, 0 } }, /* vladimir */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = { 154519,  6, 1 } }, { .child = { 8356, 4 } }, /* myjino */
    { .label = { 137888,  7, 1 } }, { .child = { 8368, 1 } }, /* cldmail */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   6753,  2, 0 } }, /* pp */
    { .label = {   4781,  3, 0 } }, /* ras */

    /* entries 8356 to 8363 */
    { .label = {  23565,  7, 1 } }, { .child = { 8364, 1 } }, /* hosting */
    { .label = { 137858,  7, 1 } }, { .child = { 8365, 1 } }, /* landing */
    { .label = { 116830,  8, 1 } }, { .child = { 8366, 1 } }, /* spectrum */
    { .label = {  31455,  3, 1 } }, { .child = { 8367, 1 } }, /* vps */

    /* entry 8364 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 8365 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 8366 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 8367 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 8368 */
    { .label = {   2991,  2, 0 } }, /* hb */

    /* entries 8369 to 8377 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = { 165542,  4, 0 } }, /* gouv */

    /* entries 8378 to 8385 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = {  24180,  3, 0 } }, /* pub */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   6667,  3, 0 } }, /* sch */

    /* entries 8386 to 8390 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 8391 to 8395 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  42919,  3, 0 } }, /* edu */

    /* entries 8396 to 8403 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   6605,  3, 0 } }, /* med */
    { .label = {   9431,  2, 0 } }, /* tv */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  28720,  4, 0 } }, /* info */

    /* entries 8404 to 8444 */
    { .label = {     24,  1, 0 } }, /* a */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     62,  1, 0 } }, /* b */
    { .label = {  11070,  2, 0 } }, /* bd */
    { .label = {  14749,  5, 0 } }, /* brand */
    { .label = {     21,  1, 0 } }, /* c */
    { .label = {     90,  1, 0 } }, /* d */
    { .label = {     23,  1, 0 } }, /* e */
    { .label = {     68,  1, 0 } }, /* f */
    { .label = {   4747,  2, 0 } }, /* fh */
    { .label = { 166883,  4, 0 } }, /* fhsk */
    { .label = {  42380,  3, 0 } }, /* fhv */
    { .label = {     19,  1, 0 } }, /* g */
    { .label = {     30,  1, 0 } }, /* h */
    { .label = {     39,  1, 0 } }, /* i */
    { .label = {     10,  1, 0 } }, /* k */
    { .label = { 130781,  7, 0 } }, /* komforb */
    { .label = {  22358, 15, 0 } }, /* kommunalforbund */
    { .label = { 150536,  6, 0 } }, /* komvux */
    { .label = {     25,  1, 0 } }, /* l */
    { .label = { 150567,  6, 0 } }, /* lanbib */
    { .label = {     29,  1, 0 } }, /* m */
    { .label = {     28,  1, 0 } }, /* n */
    { .label = {  28625, 14, 0 } }, /* naturbruksgymn */
    { .label = {     47,  1, 0 } }, /* o */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {     58,  1, 0 } }, /* p */
    { .label = { 161957,  5, 0 } }, /* parti */
    { .label = {   6753,  2, 0 } }, /* pp */
    { .label = {  22790,  5, 0 } }, /* press */
    { .label = {      1,  1, 0 } }, /* r */
    { .label = {      2,  1, 0 } }, /* s */
    { .label = {      3,  1, 0 } }, /* t */
    { .label = {   2425,  2, 0 } }, /* tm */
    { .label = {     46,  1, 0 } }, /* u */
    { .label = {     18,  1, 0 } }, /* w */
    { .label = {     22,  1, 0 } }, /* x */
    { .label = {     38,  1, 0 } }, /* y */
    { .label = {    134,  1, 0 } }, /* z */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 8445 to 8451 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   5389,  3, 0 } }, /* per */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 8452 to 8461 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = { 116720,  8, 0 } }, /* hashbang */
    { .label = {  79390,  8, 1 } }, { .child = { 8462, 1 } }, /* platform */
    { .label = { 117827,  8, 0 } }, /* wedeploy */
    { .label = {    540,  3, 0 } }, /* now */

    /* entry 8462 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 8463 to 8464 */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entries 8465 to 8466 */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  43390,  3, 0 } }, /* nym */

    /* entries 8467 to 8471 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 8472 to 8479 */
    { .label = {   7867,  3, 0 } }, /* art */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = { 165542,  4, 0 } }, /* gouv */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   5389,  5, 0 } }, /* perso */
    { .label = {  71975,  4, 0 } }, /* univ */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 8480 to 8482 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 8483 to 8496 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  91774,  9, 0 } }, /* consulado */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  91813,  9, 0 } }, /* embaixada */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 111614,  8, 0 } }, /* principe */
    { .label = { 130815,  7, 0 } }, /* saotome */
    { .label = { 155394,  5, 0 } }, /* store */
    { .label = {  25342,  3, 0 } }, /* nom */
    { .label = {  70686,  4, 0 } }, /* noho */

    /* entries 8497 to 8549 */
    { .label = { 116249,  8, 0 } }, /* abkhazia */
    { .label = { 137399,  7, 0 } }, /* adygeya */
    { .label = {  78134, 10, 0 } }, /* aktyubinsk */
    { .label = {  64349, 11, 0 } }, /* arkhangelsk */
    { .label = { 137462,  7, 0 } }, /* armenia */
    { .label = { 116285,  8, 0 } }, /* ashgabad */
    { .label = {  78180, 10, 0 } }, /* azerbaijan */
    { .label = { 116319,  8, 0 } }, /* balashov */
    { .label = {  95388,  9, 0 } }, /* bashkiria */
    { .label = { 137489,  7, 0 } }, /* bryansk */
    { .label = { 137521,  7, 0 } }, /* bukhara */
    { .label = { 116355,  8, 0 } }, /* chimkent */
    { .label = { 116078,  8, 0 } }, /* dagestan */
    { .label = {  24347, 15, 0 } }, /* east-kazakhstan */
    { .label = { 164736,  5, 0 } }, /* exnet */
    { .label = { 126318,  7, 0 } }, /* georgia */
    { .label = { 154268,  6, 0 } }, /* grozny */
    { .label = { 137552,  7, 0 } }, /* ivanovo */
    { .label = { 154322,  6, 0 } }, /* jambyl */
    { .label = { 116110,  8, 0 } }, /* kalmykia */
    { .label = { 154354,  6, 0 } }, /* kaluga */
    { .label = { 137583,  7, 0 } }, /* karacol */
    { .label = {  95426,  9, 0 } }, /* karaganda */
    { .label = { 137612,  7, 0 } }, /* karelia */
    { .label = {  95461,  9, 0 } }, /* khakassia */
    { .label = {  95497,  9, 0 } }, /* krasnodar */
    { .label = { 154380,  6, 0 } }, /* kurgan */
    { .label = { 116146,  8, 0 } }, /* kustanai */
    { .label = { 164758,  5, 0 } }, /* lenug */
    { .label = {  78225, 10, 0 } }, /* mangyshlak */
    { .label = { 116178,  8, 0 } }, /* mordovia */
    { .label = {   1468,  3, 0 } }, /* msk */
    { .label = { 116391,  8, 0 } }, /* murmansk */
    { .label = { 137431,  7, 0 } }, /* nalchik */
    { .label = { 164781,  5, 0 } }, /* navoi */
    { .label = {  17332, 16, 0 } }, /* north-kazakhstan */
    { .label = {  56947,  3, 0 } }, /* nov */
    { .label = { 137640,  7, 0 } }, /* obninsk */
    { .label = { 164802,  5, 0 } }, /* penza */
    { .label = { 116426,  8, 0 } }, /* pokrovsk */
    { .label = { 164826,  5, 0 } }, /* sochi */
    { .label = { 161377,  3, 0 } }, /* spb */
    { .label = { 116464,  8, 0 } }, /* tashkent */
    { .label = { 154406,  6, 0 } }, /* termez */
    { .label = {  95533,  9, 0 } }, /* togliatti */
    { .label = { 137671,  7, 0 } }, /* troitsk */
    { .label = {  64396, 11, 0 } }, /* tselinograd */
    { .label = { 168652,  4, 0 } }, /* tula */
    { .label = {  78948,  4, 0 } }, /* tuva */
    { .label = {  64297, 11, 0 } }, /* vladikavkaz */
    { .label = { 116213,  8, 0 } }, /* vladimir */
    { .label = { 137700,  7, 0 } }, /* vologda */
    { .label = {  43390,  3, 0 } }, /* nym */

    /* entries 8550 to 8554 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  17403,  3, 0 } }, /* red */

    /* entries 8555 to 8556 */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  43390,  3, 0 } }, /* nym */

    /* entries 8557 to 8562 */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 8563 to 8565 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {    209,  3, 0 } }, /* org */

    /* entry 8566 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 8567 to 8573 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {    100,  2, 0 } }, /* in */
    { .label = {    290,  2, 0 } }, /* mi */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {     47,  2, 0 } }, /* or */

    /* entries 8574 to 8589 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  54555,  3, 0 } }, /* biz */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  29414,  4, 0 } }, /* name */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    125,  3, 0 } }, /* nic */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3901,  4, 0 } }, /* test */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entry 8590 */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entries 8591 to 8598 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {  25342,  3, 0 } }, /* nom */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  42919,  3, 0 } }, /* edu */

    /* entries 8599 to 8618 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    226,  3, 0 } }, /* ens */
    { .label = {   3951,  3, 0 } }, /* fin */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   8838,  3, 0 } }, /* ind */
    { .label = {  71685,  4, 0 } }, /* intl */
    { .label = {   4389,  3, 0 } }, /* nat */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {   5389,  5, 0 } }, /* perso */
    { .label = { 129890,  7, 0 } }, /* tourism */
    { .label = { 150595,  6, 0 } }, /* edunet */
    { .label = { 166903,  4, 0 } }, /* rnrt */
    { .label = {  12053,  3, 0 } }, /* rns */
    { .label = {  61974,  3, 0 } }, /* rnu */
    { .label = { 150621,  6, 0 } }, /* mincom */
    { .label = { 130843,  7, 0 } }, /* agrinet */
    { .label = { 130871,  7, 0 } }, /* defense */
    { .label = { 110329,  5, 0 } }, /* turen */

    /* entries 8619 to 8625 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = { 138459,  7, 0 } }, /* vpnplus */

    /* entries 8626 to 8648 */
    { .label = {    106,  3, 1 } }, { .child = { 8649, 1 } }, /* com */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {  54555,  3, 0 } }, /* biz */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    683,  3, 0 } }, /* web */
    { .label = {   1386,  3, 0 } }, /* gen */
    { .label = {   9431,  2, 0 } }, /* tv */
    { .label = {    586,  2, 0 } }, /* av */
    { .label = {   3009,  2, 0 } }, /* dr */
    { .label = {  16744,  3, 0 } }, /* bbs */
    { .label = {  29414,  4, 0 } }, /* name */
    { .label = {     89,  3, 0 } }, /* tel */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   1505,  3, 0 } }, /* bel */
    { .label = {  27852,  3, 0 } }, /* pol */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  70496,  3, 0 } }, /* kep */
    { .label = {    311,  2, 1 } }, { .child = { 8650, 1 } }, /* nc */

    /* entry 8649 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entry 8650 */
    { .label = {   3879,  3, 0 } }, /* gov */

    /* entries 8651 to 8667 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {  54555,  3, 0 } }, /* biz */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {  22835,  3, 0 } }, /* pro */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {  51529,  4, 0 } }, /* coop */
    { .label = { 165706,  4, 0 } }, /* jobs */
    { .label = {  10207,  4, 0 } }, /* mobi */
    { .label = {   9925,  6, 0 } }, /* travel */
    { .label = {   4448,  6, 0 } }, /* museum */
    { .label = {  79798,  4, 0 } }, /* aero */
    { .label = {  29414,  4, 0 } }, /* name */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  42919,  3, 0 } }, /* edu */

    /* entries 8668 to 8671 */
    { .label = {  30648,  6, 0 } }, /* dyndns */
    { .label = {  63422, 11, 0 } }, /* better-than */
    { .label = {  77859, 10, 0 } }, /* on-the-web */
    { .label = {  78000, 10, 0 } }, /* worse-than */

    /* entries 8672 to 8688 */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {    106,  3, 1 } }, { .child = { 8689, 1 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 169254,  3, 0 } }, /* idv */
    { .label = {  39212,  4, 0 } }, /* game */
    { .label = { 166919,  4, 0 } }, /* ebiz */
    { .label = {  96605,  4, 0 } }, /* club */
    { .label = {  47200, 12, 0 } }, /* xn--zf0ao64a */
    { .label = {  66780, 10, 0 } }, /* xn--uc0atv */
    { .label = {  58387, 11, 0 } }, /* xn--czrw28b */
    { .label = {  55759,  3, 0 } }, /* url */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  43390,  3, 0 } }, /* nym */

    /* entry 8689 */
    { .label = { 116042,  8, 0 } }, /* mymailer */

    /* entries 8690 to 8701 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {  60068,  5, 0 } }, /* hotel */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {    591,  2, 0 } }, /* me */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  10207,  4, 0 } }, /* mobi */
    { .label = {     40,  2, 0 } }, /* ne */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {     17,  2, 0 } }, /* sc */
    { .label = {   9431,  2, 0 } }, /* tv */

    /* entries 8702 to 8783 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {    100,  2, 0 } }, /* in */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  91852,  9, 0 } }, /* cherkassy */
    { .label = { 111651,  8, 0 } }, /* cherkasy */
    { .label = {  91892,  9, 0 } }, /* chernigov */
    { .label = {  91933,  9, 0 } }, /* chernihiv */
    { .label = {  73954, 10, 0 } }, /* chernivtsi */
    { .label = {  73998, 10, 0 } }, /* chernovtsy */
    { .label = {    184,  2, 0 } }, /* ck */
    { .label = {   6811,  2, 0 } }, /* cn */
    { .label = {   1284,  2, 0 } }, /* cr */
    { .label = { 150648,  6, 0 } }, /* crimea */
    { .label = {   1658,  2, 0 } }, /* cv */
    { .label = {   4772,  2, 0 } }, /* dn */
    { .label = {  28689, 14, 0 } }, /* dnepropetrovsk */
    { .label = {  28753, 14, 0 } }, /* dnipropetrovsk */
    { .label = { 130902,  7, 0 } }, /* dominic */
    { .label = { 130933,  7, 0 } }, /* donetsk */
    { .label = {   2718,  2, 0 } }, /* dp */
    { .label = {    161,  2, 0 } }, /* if */
    { .label = {  22428, 15, 0 } }, /* ivano-frankivsk */
    { .label = {    231,  2, 0 } }, /* kh */
    { .label = { 130963,  7, 0 } }, /* kharkiv */
    { .label = { 130995,  7, 0 } }, /* kharkov */
    { .label = { 131027,  7, 0 } }, /* kherson */
    { .label = {  47269, 12, 0 } }, /* khmelnitskiy */
    { .label = {  47324, 12, 0 } }, /* khmelnytskyi */
    { .label = { 166940,  4, 0 } }, /* kiev */
    { .label = {  74044, 10, 0 } }, /* kirovograd */
    { .label = {    189,  2, 0 } }, /* km */
    { .label = {   3651,  2, 0 } }, /* kr */
    { .label = { 166959,  4, 0 } }, /* krym */
    { .label = {    163,  2, 0 } }, /* ks */
    { .label = {     49,  2, 0 } }, /* kv */
    { .label = { 166979,  4, 0 } }, /* kyiv */
    { .label = {   2037,  2, 0 } }, /* lg */
    { .label = {    695,  2, 0 } }, /* lt */
    { .label = { 131057,  7, 0 } }, /* lugansk */
    { .label = { 161978,  5, 0 } }, /* lutsk */
    { .label = {   9079,  2, 0 } }, /* lv */
    { .label = { 167000,  4, 0 } }, /* lviv */
    { .label = {    158,  2, 0 } }, /* mk */
    { .label = { 111687,  8, 0 } }, /* mykolaiv */
    { .label = { 111725,  8, 0 } }, /* nikolaev */
    { .label = {   1412,  2, 0 } }, /* od */
    { .label = { 141128,  5, 0 } }, /* odesa */
    { .label = { 150673,  6, 0 } }, /* odessa */
    { .label = {   5819,  2, 0 } }, /* pl */
    { .label = { 131088,  7, 0 } }, /* poltava */
    { .label = { 162001,  5, 0 } }, /* rivne */
    { .label = { 162023,  5, 0 } }, /* rovno */
    { .label = {    637,  2, 0 } }, /* rv */
    { .label = {    424,  2, 0 } }, /* sb */
    { .label = {  74088, 10, 0 } }, /* sebastopol */
    { .label = {  74132, 10, 0 } }, /* sevastopol */
    { .label = {   1519,  2, 0 } }, /* sm */
    { .label = { 165052,  4, 0 } }, /* sumy */
    { .label = {     89,  2, 0 } }, /* te */
    { .label = { 111760,  8, 0 } }, /* ternopil */
    { .label = {   3282,  2, 0 } }, /* uz */
    { .label = { 111795,  8, 0 } }, /* uzhgorod */
    { .label = { 131119,  7, 0 } }, /* vinnica */
    { .label = {  91974,  9, 0 } }, /* vinnytsia */
    { .label = {    156,  2, 0 } }, /* vn */
    { .label = { 162045,  5, 0 } }, /* volyn */
    { .label = { 162070,  5, 0 } }, /* yalta */
    { .label = {  58452, 11, 0 } }, /* zaporizhzhe */
    { .label = {  47381, 12, 0 } }, /* zaporizhzhia */
    { .label = { 111834,  8, 0 } }, /* zhitomir */
    { .label = { 111871,  8, 0 } }, /* zhytomyr */
    { .label = {   9268,  2, 0 } }, /* zp */
    { .label = {    418,  2, 0 } }, /* zt */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {   5417,  3, 0 } }, /* inf */
    { .label = { 129382,  3, 0 } }, /* ltd */
    { .label = {  54555,  3, 0 } }, /* biz */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   6753,  2, 0 } }, /* pp */

    /* entries 8784 to 8793 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {     47,  2, 0 } }, /* or */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     17,  2, 0 } }, /* sc */
    { .label = {   3345,  2, 0 } }, /* go */
    { .label = {     40,  2, 0 } }, /* ne */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entries 8794 to 8809 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 1 } }, { .child = { 8810, 7 } }, /* co */
    { .label = {   3879,  3, 1 } }, { .child = { 8817, 2 } }, /* gov */
    { .label = { 129382,  3, 0 } }, /* ltd */
    { .label = {    591,  2, 0 } }, /* me */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {   6792,  3, 0 } }, /* nhs */
    { .label = {    209,  3, 1 } }, { .child = { 8819, 3 } }, /* org */
    { .label = {  13187,  3, 0 } }, /* plc */
    { .label = { 150697,  6, 0 } }, /* police */
    { .label = {   6667,  3, 1 } }, { .child = { 8822, 1 } }, /* sch */
    { .label = {  64744,  5, 0 } }, /* barsy */

    /* entries 8810 to 8816 */
    { .label = { 116646,  8, 0 } }, /* blogspot */
    { .label = {  64744,  5, 0 } }, /* barsy */
    { .label = {  64744, 11, 0 } }, /* barsyonline */
    { .label = { 137953,  7, 0 } }, /* nh-serv */
    { .label = { 165088,  5, 0 } }, /* no-ip */
    { .label = {  40224, 13, 0 } }, /* wellbeingzone */
    { .label = { 138495,  7, 0 } }, /* gwiddle */

    /* entries 8817 to 8818 */
    { .label = {  96761,  7, 0 } }, /* service */
    { .label = {  78317, 10, 0 } }, /* homeoffice */

    /* entries 8819 to 8821 */
    { .label = { 168690,  4, 0 } }, /* glug */
    { .label = {  75194,  3, 0 } }, /* lug */
    { .label = { 154612,  4, 0 } }, /* lugs */

    /* entry 8822 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 8823 to 8946 */
    { .label = {  28753,  3, 0 } }, /* dni */
    { .label = {  17401,  3, 0 } }, /* fed */
    { .label = {   9230,  3, 0 } }, /* isa */
    { .label = { 166330,  4, 0 } }, /* kids */
    { .label = {   7218,  3, 0 } }, /* nsn */
    { .label = {    160,  2, 1 } }, { .child = { 8947, 3 } }, /* ak */
    { .label = {     94,  2, 1 } }, { .child = { 8950, 3 } }, /* al */
    { .label = {     45,  2, 1 } }, { .child = { 8953, 3 } }, /* ar */
    { .label = {    128,  2, 1 } }, { .child = { 8956, 3 } }, /* as */
    { .label = {   2857,  2, 1 } }, { .child = { 8959, 3 } }, /* az */
    { .label = {    133,  2, 1 } }, { .child = { 8962, 3 } }, /* ca */
    { .label = {     42,  2, 1 } }, { .child = { 8965, 3 } }, /* co */
    { .label = {   1982,  2, 1 } }, { .child = { 8968, 3 } }, /* ct */
    { .label = {   5786,  2, 1 } }, { .child = { 8971, 3 } }, /* dc */
    { .label = {    243,  2, 1 } }, { .child = { 8974, 3 } }, /* de */
    { .label = {  19079,  2, 1 } }, { .child = { 8977, 3 } }, /* fl */
    { .label = {     19,  2, 1 } }, { .child = { 8980, 3 } }, /* ga */
    { .label = {   9907,  2, 1 } }, { .child = { 8983, 3 } }, /* gu */
    { .label = {     73,  2, 1 } }, { .child = { 8986, 2 } }, /* hi */
    { .label = {    240,  2, 1 } }, { .child = { 8988, 3 } }, /* ia */
    { .label = {     86,  2, 1 } }, { .child = { 8991, 3 } }, /* id */
    { .label = {    556,  2, 1 } }, { .child = { 8994, 3 } }, /* il */
    { .label = {    100,  2, 1 } }, { .child = { 8997, 3 } }, /* in */
    { .label = {    163,  2, 1 } }, { .child = { 9000, 3 } }, /* ks */
    { .label = {    470,  2, 1 } }, { .child = { 9003, 3 } }, /* ky */
    { .label = {    557,  2, 1 } }, { .child = { 9006, 3 } }, /* la */
    { .label = {   1369,  2, 1 } }, { .child = { 9009, 3 } }, /* ma */
    { .label = {   8061,  2, 1 } }, { .child = { 9016, 3 } }, /* md */
    { .label = {    591,  2, 1 } }, { .child = { 9019, 3 } }, /* me */
    { .label = {    290,  2, 1 } }, { .child = { 9022, 11 } }, /* mi */
    { .label = {    571,  2, 1 } }, { .child = { 9033, 3 } }, /* mn */
    { .label = {   3360,  2, 1 } }, { .child = { 9036, 3 } }, /* mo */
    { .label = {    126,  2, 1 } }, { .child = { 9039, 3 } }, /* ms */
    { .label = {   2788,  2, 1 } }, { .child = { 9042, 3 } }, /* mt */
    { .label = {    311,  2, 1 } }, { .child = { 9045, 3 } }, /* nc */
    { .label = {    354,  2, 1 } }, { .child = { 9048, 2 } }, /* nd */
    { .label = {     40,  2, 1 } }, { .child = { 9050, 3 } }, /* ne */
    { .label = {   1192,  2, 1 } }, { .child = { 9053, 3 } }, /* nh */
    { .label = {   9530,  2, 1 } }, { .child = { 9056, 3 } }, /* nj */
    { .label = {    201,  2, 1 } }, { .child = { 9059, 3 } }, /* nm */
    { .label = {    152,  2, 1 } }, { .child = { 9062, 3 } }, /* nv */
    { .label = {   3084,  2, 1 } }, { .child = { 9065, 3 } }, /* ny */
    { .label = {     69,  2, 1 } }, { .child = { 9068, 3 } }, /* oh */
    { .label = {   2416,  2, 1 } }, { .child = { 9071, 3 } }, /* ok */
    { .label = {     47,  2, 1 } }, { .child = { 9074, 3 } }, /* or */
    { .label = {    136,  2, 1 } }, { .child = { 9077, 3 } }, /* pa */
    { .label = {   1461,  2, 1 } }, { .child = { 9080, 3 } }, /* pr */
    { .label = {    157,  2, 1 } }, { .child = { 9083, 3 } }, /* ri */
    { .label = {     17,  2, 1 } }, { .child = { 9086, 3 } }, /* sc */
    { .label = {    502,  2, 1 } }, { .child = { 9089, 2 } }, /* sd */
    { .label = {    700,  2, 1 } }, { .child = { 9091, 3 } }, /* tn */
    { .label = {    416,  2, 1 } }, { .child = { 9094, 3 } }, /* tx */
    { .label = {    635,  2, 1 } }, { .child = { 9097, 3 } }, /* ut */
    { .label = {    569,  2, 1 } }, { .child = { 9100, 3 } }, /* vi */
    { .label = {      8,  2, 1 } }, { .child = { 9103, 3 } }, /* vt */
    { .label = {     54,  2, 1 } }, { .child = { 9106, 3 } }, /* va */
    { .label = {     18,  2, 1 } }, { .child = { 9109, 3 } }, /* wa */
    { .label = {    216,  2, 1 } }, { .child = { 9112, 3 } }, /* wi */
    { .label = {  11940,  2, 1 } }, { .child = { 9115, 1 } }, /* wv */
    { .label = {   5476,  2, 1 } }, { .child = { 9116, 3 } }, /* wy */
    { .label = { 134919,  7, 0 } }, /* cloudns */
    { .label = { 168439,  4, 0 } }, /* drud */
    { .label = { 164534,  5, 0 } }, /* is-by */
    { .label = {  64094, 11, 0 } }, /* land-4-sale */
    { .label = {  50411, 12, 0 } }, /* stuff-4-sale */
    { .label = { 115880,  8, 0 } }, /* freeddns */
    { .label = { 138113,  7, 0 } }, /* golffan */
    { .label = { 166930,  4, 0 } }, /* noip */
    { .label = { 138176,  7, 0 } }, /* pointto */

    /* entries 8947 to 8949 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 8950 to 8952 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 8953 to 8955 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 8956 to 8958 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 8959 to 8961 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 8962 to 8964 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 8965 to 8967 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 8968 to 8970 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 8971 to 8973 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 8974 to 8976 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 8977 to 8979 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 8980 to 8982 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 8983 to 8985 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 8986 to 8987 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 8988 to 8990 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 8991 to 8993 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 8994 to 8996 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 8997 to 8999 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9000 to 9002 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9003 to 9005 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9006 to 9008 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9009 to 9012 */
    { .label = { 169217,  3, 1 } }, { .child = { 9013, 3 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9013 to 9015 */
    { .label = { 169238,  3, 0 } }, /* pvt */
    { .label = { 167021,  4, 0 } }, /* chtr */
    { .label = { 150725,  6, 0 } }, /* paroch */

    /* entries 9016 to 9018 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9019 to 9021 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9022 to 9032 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */
    { .label = {  92013,  9, 0 } }, /* ann-arbor */
    { .label = {  88213,  3, 0 } }, /* cog */
    { .label = {  17688,  3, 0 } }, /* dst */
    { .label = { 162091,  5, 0 } }, /* eaton */
    { .label = {   1386,  3, 0 } }, /* gen */
    { .label = {   4448,  3, 0 } }, /* mus */
    { .label = {   6803,  3, 0 } }, /* tec */
    { .label = {  92050,  9, 0 } }, /* washtenaw */

    /* entries 9033 to 9035 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9036 to 9038 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9039 to 9041 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9042 to 9044 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9045 to 9047 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9048 to 9049 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9050 to 9052 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9053 to 9055 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9056 to 9058 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9059 to 9061 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9062 to 9064 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9065 to 9067 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9068 to 9070 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9071 to 9073 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9074 to 9076 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9077 to 9079 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9080 to 9082 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9083 to 9085 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9086 to 9088 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9089 to 9090 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9091 to 9093 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9094 to 9096 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9097 to 9099 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9100 to 9102 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9103 to 9105 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9106 to 9108 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9109 to 9111 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9112 to 9114 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entry 9115 */
    { .label = {    466,  2, 0 } }, /* cc */

    /* entries 9116 to 9118 */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {    466,  2, 0 } }, /* cc */
    { .label = {  16947,  3, 0 } }, /* lib */

    /* entries 9119 to 9126 */
    { .label = {    106,  3, 1 } }, { .child = { 9127, 1 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  51625,  3, 0 } }, /* gub */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entry 9127 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 9128 to 9131 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 9132 to 9138 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entries 9139 to 9155 */
    { .label = {   7867,  4, 0 } }, /* arts */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 169314,  3, 0 } }, /* e12 */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = { 113331,  4, 0 } }, /* firm */
    { .label = {   3345,  3, 0 } }, /* gob */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {    182,  3, 0 } }, /* rec */
    { .label = { 155394,  5, 0 } }, /* store */
    { .label = {   6803,  3, 0 } }, /* tec */
    { .label = {    683,  3, 0 } }, /* web */

    /* entry 9156 */
    { .label = {  25342,  3, 0 } }, /* nom */

    /* entries 9157 to 9161 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = { 169217,  3, 0 } }, /* k12 */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 9162 to 9174 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   4229,  3, 0 } }, /* int */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  54555,  3, 0 } }, /* biz */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {  29414,  4, 0 } }, /* name */
    { .label = {  22835,  3, 0 } }, /* pro */
    { .label = {   1503,  6, 0 } }, /* health */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 9175 to 9178 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */

    /* entries 9179 to 9188 */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3989,  7, 1 } }, { .child = { 9189, 1 } }, /* advisor */
    { .label = { 134877,  7, 0 } }, /* cloud66 */
    { .label = {  30648,  6, 0 } }, /* dyndns */
    { .label = { 154012,  6, 0 } }, /* mypets */

    /* entry 9189 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9190 to 9195 */
    { .label = {  66351, 10, 0 } }, /* xn--55qx5d */
    { .label = {  51714, 11, 0 } }, /* xn--wcvs22d */
    { .label = {  66561, 10, 0 } }, /* xn--mxtq1m */
    { .label = {  66617, 10, 0 } }, /* xn--gmqw5a */
    { .label = {  66469, 10, 0 } }, /* xn--od0alg */
    { .label = {  66780, 10, 0 } }, /* xn--uc0atv */

    /* entries 9196 to 9201 */
    { .label = {  92380,  8, 0 } }, /* xn--o1ac */
    { .label = {  92280,  9, 0 } }, /* xn--c1avg */
    { .label = {  92327,  9, 0 } }, /* xn--90azh */
    { .label = { 112036,  8, 0 } }, /* xn--d1at */
    { .label = {  92380,  9, 0 } }, /* xn--o1ach */
    { .label = { 112076,  8, 0 } }, /* xn--80au */

    /* entries 9202 to 9207 */
    { .label = {  37680, 13, 0 } }, /* xn--12c1fe0br */
    { .label = {  16287, 16, 0 } }, /* xn--12co0c3b4eva */
    { .label = {  37757, 13, 0 } }, /* xn--h3cuzk1di */
    { .label = {  59161, 11, 0 } }, /* xn--o3cyx2a */
    { .label = {  47921, 12, 0 } }, /* xn--m3ch0j3a */
    { .label = {  22658, 15, 0 } }, /* xn--12cfi8ixb8l */

    /* entry 9208 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9209 to 9226 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  55794,  5, 0 } }, /* agric */
    { .label = {   1512,  3, 0 } }, /* alt */
    { .label = {     42,  2, 1 } }, { .child = { 9227, 1 } }, /* co */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = { 131149,  7, 0 } }, /* grondar */
    { .label = {  20188,  3, 0 } }, /* law */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {  10027,  3, 0 } }, /* ngo */
    { .label = {  16988,  3, 0 } }, /* nis */
    { .label = {  25342,  3, 0 } }, /* nom */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = { 147370,  6, 0 } }, /* school */
    { .label = {   2425,  2, 0 } }, /* tm */
    { .label = {    683,  3, 0 } }, /* web */

    /* entry 9227 */
    { .label = { 116646,  8, 0 } }, /* blogspot */

    /* entries 9228 to 9238 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {  54555,  3, 0 } }, /* biz */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {    106,  3, 0 } }, /* com */
    { .label = {  42919,  3, 0 } }, /* edu */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {  28720,  4, 0 } }, /* info */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {  16771,  3, 0 } }, /* net */
    { .label = {    209,  3, 0 } }, /* org */
    { .label = {   6667,  3, 0 } }, /* sch */

    /* entries 9239 to 9243 */
    { .label = {    103,  2, 0 } }, /* ac */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {   3879,  3, 0 } }, /* gov */
    { .label = {   3679,  3, 0 } }, /* mil */
    { .label = {    209,  3, 0 } }, /* org */

    /* entry 9244 */
    { .label = { 117943,  8, 0 } }, /* official */

    /* entry 9245 */
    { .label = {  78499,  6, 0 } }, /* hasura */

    /* entries 9246 to 9254 */
    { .label = { 137763,  7, 1 } }, { .child = { 9255, 1 } }, /* statics */
    { .label = {  31566,  8, 0 } }, /* linkyard */
    { .label = {  64840, 11, 1 } }, { .child = { 9256, 1 } }, /* magentosite */
    { .label = {  79436,  5, 0 } }, /* vapor */
    { .label = {  79623, 10, 1 } }, { .child = { 9257, 1 } }, /* sensiosite */
    { .label = {  65438, 11, 0 } }, /* trafficplex */

    /* entry 9255 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 9256 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 9257 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9258 to 9259 */
    { .label = { 134919,  7, 0 } }, /* cloudns */
    { .label = {  64744,  5, 0 } }, /* barsy */

    /* entry 9260 */
    { .label = {  95786,  7, 0 } }, /* ravendb */

    /* entry 9261 */
    { .label = {    243,  2, 0 } }, /* de */

    /* entry 9262 */
    { .label = {  95570,  9, 0 } }, /* fastpanel */

    /* entries 9263 to 9264 */
    { .label = {  19748,  7, 1 } }, { .child = { 9265, 1 } }, /* compute */

    /* entry 9265 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9266 to 9267 */
    { .label = { 163623,  5, 1 } }, { .child = { 9268, 1 } }, /* party */

    /* entry 9268 */
    { .label = {  13237,  4, 0 } }, /* user */

    /* entry 9269 */
    { .label = {  45201,  3, 0 } }, /* ybo */

    /* entry 9270 */
    { .label = {  94472,  5, 0 } }, /* storj */

    /* entry 9271 */
    { .label = { 155037,  6, 0 } }, /* ptplus */

    /* entry 9272 */
    { .label = { 168399,  4, 0 } }, /* cnpy */

    /* entry 9273 */
    { .label = {  13493,  5, 0 } }, /* cloud */

    /* entries 9274 to 9277 */
    { .label = {  62911, 11, 0 } }, /* cloudaccess */
    { .label = { 114931,  8, 0 } }, /* freesite */
    { .label = {  13487,  6, 0 } }, /* pcloud */
    { .label = {  40125,  4, 0 } }, /* half */

    /* entry 9278 */
    { .label = {  96303,  9, 0 } }, /* opencraft */

    /* entries 9279 to 9280 */
    { .label = {     42,  2, 0 } }, /* co */
    { .label = {  42919,  3, 0 } }, /* edu */

    /* entries 9281 to 9282 */
    { .label = {  38450,  6, 1 } }, { .child = { 9283, 2 } }, /* static */

    /* entries 9283 to 9284 */
    { .label = {   9807,  3, 0 } }, /* dev */
    { .label = {  39452,  5, 0 } }, /* sites */

    /* entries 9285 to 9286 */
    { .label = { 168420,  4, 0 } }, /* cyon */
    { .label = { 165233,  5, 0 } }, /* mypep */

    /* entry 9287 */
    { .label = {  96359,  6, 0 } }, /* router */

    /* entry 9288 */
    { .label = {  64744,  5, 0 } }, /* barsy */

    /* entries 9289 to 9290 */
    { .label = { 164465,  5, 1 } }, { .child = { 9291, 1 } }, /* alces */

    /* entry 9291 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 9292 */
    { .label = { 118014,  8, 0 } }, /* homelink */

    /* entry 9293 */
    { .label = {  64744,  5, 0 } }, /* barsy */

    /* entry 9294 */
    { .label = { 138081,  7, 0 } }, /* nerdpol */

    /* entry 9295 */
    { .label = {  45201,  3, 0 } }, /* ybo */

    /* entry 9296 */
    { .label = { 168967,  4, 0 } }, /* 1337 */

    /* entry 9297 */
    { .label = {  64744,  5, 0 } }, /* barsy */

    /* entry 9298 */
    { .label = {  45201,  3, 0 } }, /* ybo */

    /* entry 9299 */
    { .label = { 169000,  4, 0 } }, /* clan */

    /* entries 9300 to 9302 */
    { .label = { 154187,  6, 0 } }, /* myddns */
    { .label = {  96464,  9, 0 } }, /* lima-city */
    { .label = { 117681,  8, 0 } }, /* webspace */

    /* entries 9303 to 9304 */
    { .label = {  64644, 11, 0 } }, /* development */
    { .label = {  95786,  7, 0 } }, /* ravendb */

    /* entry 9305 */
    { .label = {  45201,  3, 0 } }, /* ybo */

    /* entry 9306 */
    { .label = {  64744,  5, 0 } }, /* barsy */

    /* entries 9307 to 9311 */
    { .label = { 168420,  4, 0 } }, /* cyon */
    { .label = {  64744,  5, 0 } }, /* barsy */
    { .label = {  79390, 10, 1 } }, { .child = { 9312, 1 } }, /* platformsh */
    { .label = { 168871,  4, 0 } }, /* byen */

    /* entry 9312 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 9313 to 9315 */
    { .label = {  78675, 10, 0 } }, /* linkitools */
    { .label = {  51630,  4, 0 } }, /* uber */
    { .label = { 155316,  6, 0 } }, /* xs4all */

    /* entry 9316 */
    { .label = {  64744,  5, 0 } }, /* barsy */

    /* entry 9317 */
    { .label = {  64695, 11, 0 } }, /* knightpoint */

    /* entries 9318 to 9319 */
    { .label = { 138016,  7, 0 } }, /* now-dns */
    { .label = { 164968,  5, 0 } }, /* ntdll */

    /* entry 9320 */
    { .label = {  45201,  3, 0 } }, /* ybo */

    /* entries 9321 to 9324 */
    { .label = { 115074,  8, 0 } }, /* blogsite */
    { .label = { 164848,  5, 0 } }, /* fhapp */
    { .label = { 117017,  8, 0 } }, /* crafting */
    { .label = { 164991,  5, 0 } }, /* zapto */

    /* entries 9325 to 9327 */
    { .label = { 154549,  6, 1 } }, { .child = { 9328, 1 } }, /* triton */
    { .label = {  26457,  4, 0 } }, /* lima */

    /* entry 9328 */
    { .label = {      0,  1, 0 } }, /* * */

};

