/**
*** \file informationitem.h
*** \brief Information item classes.
*** \details Classes for information items.
**/

/*
** This file is part of moonphase.
** Copyright (C) 2014-2018 by Alan Wise <awisesoftware@gmail.com>.
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef   INFORMATIONITEM_H
/**
*** \brief informationitem.h identifier.
*** \details Identifier for informationitem.h.
**/
#define   INFORMATIONITEM_H


/****
*****
***** INCLUDES
*****
****/

#include  "informationitemoptions.h"


/****
*****
***** DEFINES
*****
****/


/****
*****
***** DATA TYPES
*****
****/

/**
*** \brief Information item base class.
*** \details Base class for information items.
**/
class INFORMATIONITEM_C
{
  public:
    /**
    *** \brief Constructor.
    *** \details Constructor.
    **/
    INFORMATIONITEM_C(void);

    /**
    *** \brief Destructor.
    *** \details Destructor.
    **/
    ~INFORMATIONITEM_C(void);

    /**
    *** \brief Return information index.
    *** \details Returns the index into the information table.
    *** \returns Index into the information table.
    **/
    int GetInformationIndex(void);

    /**
    *** \brief Return unit or format index.
    *** \details Returns the index into the unit table or the index of the
    ***   date/time format.
    *** \returns Index into the unit table.
    **/
    int GetUnitFormatIndex(void);

    /**
    *** \brief Set information index.
    *** \details Sets the index into the information table.
    *** \param Index Index into the information table.
    **/
    void SetInformationIndex(int Index);

    /**
    *** \brief Set unit or format index.
    *** \details Sets the index into the unit table or the index of the
    ***   date/time format.
    *** \param Index into the unit table.
    **/
    void SetUnitFormatIndex(int Index);

  private:
    /**
    *** \brief Information index.
    *** \details The index into the information table.
    **/
    int m_InformationIndex;

    /**
    *** \brief Item options.
    *** \details Options for this item.
    **/
    INFORMATIONITEMOPTIONS_C m_Options;
};

/**
*** \brief Information panel information item class.
*** \details Class for information panel information items.
**/
class INFORMATIONPANELITEM_C : public INFORMATIONITEM_C
{
  public:
    /**
    *** \brief Constructor.
    *** \details Constructor.
    **/
    INFORMATIONPANELITEM_C(void);

    /**
    *** \brief Destructor.
    *** \details Destructor.
    **/
    ~INFORMATIONPANELITEM_C(void);

    /**
    *** \brief Return item options.
    *** \details Returns the options for this item.
    *** \returns Options for this line.
    **/
    INFORMATIONPANELITEMOPTIONS_C const & GetOptions(void);

    /**
    *** \brief Set item options.
    *** \details Sets the options for this item.
    *** \param Options Line Options.
    **/
    void SetOptions(INFORMATIONPANELITEMOPTIONS_C const &Options);

  private:
    /**
    *** \brief Item options.
    *** \details Options for this item.
    **/
    INFORMATIONPANELITEMOPTIONS_C m_Options;
};


/****
*****
***** DATA
*****
****/


/****
*****
***** VARIABLES
*****
****/


/****
*****
***** PROTOTYPES
*****
****/


#endif    /* INFORMATIONITEM_H */


/**
*** informationitem.h
**/
