/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core;

import sharpen.core.NamingStrategy;
import sharpen.core.PascalCaseIdentifiersNamingStrategy;

public class PascalCaseNamingStrategy
extends PascalCaseIdentifiersNamingStrategy {
    public static final NamingStrategy DEFAULT = new PascalCaseNamingStrategy();

    @Override
    public String identifier(String name) {
        if (this.isAllUpper(name)) {
            return name;
        }
        return super.identifier(name);
    }

    private boolean isAllUpper(String name) {
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            if (Character.isLetter(ch) && Character.isLowerCase(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String fromJavaConstantName(String name) {
        String[] parts = name.split("_");
        StringBuilder buffer = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            buffer.append(this.title(part));
            ++n2;
        }
        return buffer.toString();
    }

    private String title(String name) {
        return name.length() > 1 ? String.valueOf(name.substring(0, 1)) + name.substring(1).toLowerCase() : name;
    }

    @Override
    protected String namespacePart(String part) {
        return part.length() < 3 ? part.toUpperCase() : this.toPascalCase(part);
    }
}

