/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2017 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Msltoe Donut formula
 * @reference
 * http://www.fractalforums.com/new-theories-and-research/
 * low-hanging-dessert-an-escape-time-donut-fractal/msg90171/#msg90171

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "MsltoeDonutIteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 MsltoeDonutIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL radius2 = fractal->donut.ringThickness;
	REAL nSect = native_divide(M_PI_2x, fractal->donut.number);
	REAL fact = fractal->donut.factor;

	REAL R = native_sqrt(mad(z.x, z.x, z.y * z.y));
	REAL R2 = fractal->donut.ringRadius - R;
	REAL t = mad(-radius2, radius2, mad(R2, R2, z.z * z.z));

	REAL theta = atan2(z.y, z.x);
	REAL theta2 = nSect * round(native_divide(theta, nSect));

	if (t > 0.03f)
	{
		REAL c1 = native_cos(theta2);
		REAL s1 = native_sin(theta2);

		REAL x1 = mad(c1, z.x, s1 * z.y);
		REAL y1 = mad(-s1, z.x, c1 * z.y);
		REAL z1 = z.z;

		x1 = x1 - fractal->donut.ringRadius;

		z.x = fact * x1;
		z.y = fact * z1;
		z.z = fact * y1;
	}
	else
	{
		z /= t;
	}
	aux->color += theta2;
	return z;
}