/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2018 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * poly fold sym DarkBeam's version
 * @reference
 * DarkBeam (luca) http://www.fractalforums.com/mandelbulber/
 * _polyfold_sym-and-polyfoldsymifs-in-mandelbulber-2/msg98162/#msg98162

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "TransfPolyFoldSymIteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfPolyFoldSymIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	Q_UNUSED(aux);

	int order = fractal->transformCommon.int6;
	REAL div2PI = (REAL)native_divide(order, M_PI_2x);

	bool cy = false;
	int sector = (int)(-div2PI * atan(native_divide(z.x, z.y)));
	if (sector & 1) cy = true; // parity   if (sector & 1) is a "bit check", true = odd
	REAL angle = (REAL)(native_divide(sector, div2PI));
	// z.xy = rotate(z.xy,angle); // sin
	REAL tempZx = z.x;
	z.x = mad(z.x, native_cos(angle), -z.y * native_sin(angle));
	z.y = mad(tempZx, native_sin(angle), z.y * native_cos(angle));
	if (cy) z.y = -z.y;
	// if ((order&1) && (sector == 0)) z.y = fabs(z.y); // more continuous?
	return z;
}