/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2018 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Adds c constant to z vector

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "TransfAddConstantMod1Iteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfAddConstantMod1Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	Q_UNUSED(aux);
	// std offset
	z += fractal->transformCommon.additionConstantA000;
	// polynomial
	if (fractal->transformCommon.functionEnabledBx
			&& aux->i >= fractal->transformCommon.startIterationsX
			&& aux->i < fractal->transformCommon.stopIterationsX)
	{
		REAL4 temp = fractal->transformCommon.additionConstant000;
		REAL4 temp2 = temp * temp;
		REAL4 temp3 = z * z * fractal->transformCommon.scaleA1;
		z.x -= (native_divide((temp.x * temp2.x), (temp3.x + temp2.x)) - 2.0f * temp.x)
					 * fractal->transformCommon.scale1;
		z.y -= (native_divide((temp.y * temp2.y), (temp3.y + temp2.y)) - 2.0f * temp.y)
					 * fractal->transformCommon.scale1;
		z.z -= (native_divide((temp.z * temp2.z), (temp3.z + temp2.z)) - 2.0f * temp.z)
					 * fractal->transformCommon.scale1;
	}
	else if (fractal->transformCommon.functionEnabledByFalse
					 && aux->i >= fractal->transformCommon.startIterationsX
					 && aux->i < fractal->transformCommon.stopIterationsX)
	{
		REAL4 temp = fractal->transformCommon.additionConstant000;
		REAL4 temp2 = temp * temp;
		REAL4 temp3 = z * z * fractal->transformCommon.scaleA1;
		z.x -= (native_divide((temp2.x), (temp3.x + temp2.x)) - 2.0f * temp.x)
					 * fractal->transformCommon.scale1; // * sign(z.x);
		z.y -= (native_divide((temp2.y), (temp3.y + temp2.y)) - 2.0f * temp.y)
					 * fractal->transformCommon.scale1; // * sign(z.y);
		z.z -= (native_divide((temp2.z), (temp3.z + temp2.z)) - 2.0f * temp.z)
					 * fractal->transformCommon.scale1; // * sign(z.z);
	}
	return z;
}