/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2018 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * spherical invert (modes updated v2.15)
 * from M3D. Formula by Luca GN 2011, updated May 2012.
 * @reference
 * http://www.fractalforums.com/mandelbulb-3d/custom-formulas-and-transforms-release-t17106/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "TransfSphericalInvIteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfSphericalInvIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	z += fractal->mandelbox.offset;
	z *= fractal->transformCommon.scale;
	aux->DE = mad(aux->DE, fabs(fractal->transformCommon.scale), 1.0f);

	if (!fractal->transformCommon.functionEnabledzFalse)
	{
		REAL r2Inv = native_recip(dot(z, z));
		z *= r2Inv;
		aux->DE *= r2Inv;
	}
	else // conditional
	{
		REAL rr = dot(z, z);
		if (rr < fractal->mandelbox.foldingSphericalFixed)
		{
			REAL mode = 0.0f;
			if (fractal->transformCommon.functionEnabledFalse) // Mode 1 minR0
			{
				if (rr < fractal->transformCommon.minR0) mode = fractal->transformCommon.minR0;
			}
			if (fractal->transformCommon.functionEnabledxFalse) // Mode 2
			{
				if (rr < fractal->transformCommon.minR0)
					mode = mad(2.0f, fractal->transformCommon.minR0, -rr);
			}
			mode = native_recip(mode);
			z *= mode;
			aux->DE *= fabs(mode);
		}
	}
	z -= fractal->mandelbox.offset + fractal->transformCommon.additionConstant000;
	if (fractal->analyticDE.enabledFalse)
	{
		aux->DE = mad(aux->DE, fractal->analyticDE.scale1, fractal->analyticDE.offset0);
	}
	return z;
}