/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2018 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * benesiFastPwr2PineTree 3D
 * @reference
 * http://www.fractalforums.com/new-theories-and-research/
 * do-m3d-formula-have-to-be-distance-estimation-formulas/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "BenesiPineTreeIteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 BenesiPineTreeIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	aux->DE = mad(aux->r * aux->DE, 2.0f, 1.0f);

	REAL4 c = aux->const_c;
	REAL4 temp = z;

	z *= z;
	REAL t = 2.0f * temp.x;
	if (z.y + z.z > 0.0f)
		t = native_divide(t, native_sqrt(z.y + z.z));
	else
		t = 1.0f;

	z.x = mad(fractal->transformCommon.constantMultiplier100.x, c.x, (z.x - z.y - z.z));
	z.z = mad(fractal->transformCommon.constantMultiplier100.y, c.y, (t * (z.y - z.z)));
	z.y = mad(fractal->transformCommon.constantMultiplier100.z, c.z, (2.0f * t * temp.y * temp.z));

	if (fractal->transformCommon.angle0 != 0)
	{
		REAL tempY = z.y;
		REAL beta = fractal->transformCommon.angle0 * M_PI_180;
		z.y = mad(z.y, native_cos(beta), z.z * native_sin(beta));
		z.z = mad(tempY, -native_sin(beta), z.z * native_cos(beta));
	}
	return z;
}