/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.test;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterFactory;
import javax.media.jai.SourcelessOpImage;

final class RampOpImage
extends SourcelessOpImage {
    public RampOpImage(int minX, int minY, int width, int height, SampleModel sampleModel, Map configuration, ImageLayout layout) {
        super(layout, configuration, sampleModel, minX, minY, width, height);
    }

    @Override
    public Raster computeTile(int tileX, int tileY) {
        int orgX = this.tileXToX(tileX);
        int orgY = this.tileYToY(tileY);
        WritableRaster dst = RasterFactory.createWritableRaster(this.sampleModel, new Point(orgX, orgY));
        Rectangle rect = new Rectangle(orgX, orgY, this.sampleModel.getWidth(), this.sampleModel.getHeight());
        rect = rect.intersection(this.getBounds());
        int numBands = this.sampleModel.getNumBands();
        int[] p = new int[numBands];
        for (int y = rect.y; y < rect.y + rect.height; ++y) {
            for (int x = rect.x; x < rect.x + rect.width; ++x) {
                int value = Math.max(x & 0xFF, y & 0xFF);
                for (int i = 0; i < numBands; ++i) {
                    p[i] = value;
                }
                dst.setPixel(x, y, p);
            }
        }
        return dst;
    }
}

