/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PasswordView;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.jvnet.lafwidget.utils.FadeStateListener;
import org.jvnet.substance.SubstanceBorder;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class SubstancePasswordFieldUI
extends BasicPasswordFieldUI {
    protected FadeStateListener substanceFadeStateListener;
    protected JPasswordField passwordField;
    private static SubstanceFillBackgroundDelegate bgDelegate = new SubstanceFillBackgroundDelegate(0.6f);

    public static ComponentUI createUI(JComponent c) {
        return new SubstancePasswordFieldUI(c);
    }

    public SubstancePasswordFieldUI(JComponent c) {
        this.passwordField = (JPasswordField)c;
    }

    public View create(Element elem) {
        return new SubstancePasswordView(elem);
    }

    protected void installListeners() {
        super.installListeners();
        this.substanceFadeStateListener = new FadeStateListener(this.passwordField, null, null);
        this.substanceFadeStateListener.registerListeners(false);
    }

    protected void uninstallListeners() {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        super.uninstallListeners();
    }

    protected void paintBackground(Graphics g) {
        if (this.getComponent().getBorder() instanceof SubstanceBorder) {
            g.fillRect(1, 1, this.getComponent().getWidth() - 2, this.getComponent().getHeight() - 2);
        } else {
            super.paintBackground(g);
        }
        if (SubstanceCoreUtilities.toBleedWatermark(this.passwordField)) {
            bgDelegate.update(g, this.passwordField);
        }
    }

    private static class SubstancePasswordView
    extends PasswordView {
        public SubstancePasswordView(Element element) {
            super(element);
        }

        protected int drawEchoCharacter(Graphics g, int x, int y, char c) {
            Container container = this.getContainer();
            if (!(container instanceof JPasswordField)) {
                return super.drawEchoCharacter(g, x, y, c);
            }
            Graphics2D graphics = (Graphics2D)g;
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            JPasswordField field = (JPasswordField)container;
            int dotDiameter = SubstanceSizeUtils.getPasswordDotDiameter();
            int dotGap = SubstanceSizeUtils.getPasswordDotGap();
            boolean isDark = SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme());
            ColorScheme colorScheme = field.isEnabled() ? SubstanceCoreUtilities.getActiveScheme(field) : SubstanceCoreUtilities.getDefaultScheme(field);
            Color topColor = isDark ? colorScheme.getExtraLightColor().brighter() : colorScheme.getUltraDarkColor();
            Color bottomColor = isDark ? colorScheme.getUltraLightColor().brighter() : colorScheme.getDarkColor();
            graphics.setPaint(new GradientPaint(x, y - dotDiameter, topColor, x, y, bottomColor));
            int echoPerChar = SubstanceCoreUtilities.getEchoPerChar(field);
            for (int i = 0; i < echoPerChar; ++i) {
                graphics.fillOval(x, y - dotDiameter, dotDiameter, dotDiameter);
                x += dotDiameter + dotGap;
            }
            return x;
        }

        protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
            return super.drawSelectedText(g, x, y, p0, p1);
        }

        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            Container c = this.getContainer();
            if (c instanceof JPasswordField) {
                JPasswordField f = (JPasswordField)c;
                if (!f.echoCharIsSet()) {
                    return super.modelToView(pos, a, b);
                }
                Rectangle alloc = this.adjustAllocation(a).getBounds();
                int echoPerChar = SubstanceCoreUtilities.getEchoPerChar(f);
                int dotWidth = SubstanceSizeUtils.getPasswordDotDiameter() + SubstanceSizeUtils.getPasswordDotGap();
                int dx = (pos - this.getStartOffset()) * echoPerChar * dotWidth;
                alloc.x += dx;
                alloc.width = 1;
                return alloc;
            }
            return null;
        }

        public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
            bias[0] = Position.Bias.Forward;
            int n = 0;
            Container c = this.getContainer();
            if (c instanceof JPasswordField) {
                int dotWidth;
                JPasswordField f = (JPasswordField)c;
                if (!f.echoCharIsSet()) {
                    return super.viewToModel(fx, fy, a, bias);
                }
                Rectangle alloc = (a = this.adjustAllocation(a)) instanceof Rectangle ? (Rectangle)a : a.getBounds();
                int echoPerChar = SubstanceCoreUtilities.getEchoPerChar(f);
                n = ((int)fx - alloc.x) / (echoPerChar * (dotWidth = SubstanceSizeUtils.getPasswordDotDiameter() + SubstanceSizeUtils.getPasswordDotGap()));
                if (n < 0) {
                    n = 0;
                } else if (n > this.getStartOffset() + this.getDocument().getLength()) {
                    n = this.getDocument().getLength() - this.getStartOffset();
                }
            }
            return this.getStartOffset() + n;
        }

        public float getPreferredSpan(int axis) {
            switch (axis) {
                case 0: {
                    JPasswordField f;
                    Container c = this.getContainer();
                    if (!(c instanceof JPasswordField) || !(f = (JPasswordField)c).echoCharIsSet()) break;
                    int echoPerChar = SubstanceCoreUtilities.getEchoPerChar(f);
                    int dotWidth = SubstanceSizeUtils.getPasswordDotDiameter() + SubstanceSizeUtils.getPasswordDotGap();
                    return echoPerChar * dotWidth * this.getDocument().getLength();
                }
            }
            return super.getPreferredSpan(axis);
        }
    }
}

