
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQVariant.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQVariant_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QVariant

//  Constructor QVariant::QVariant()


static void _init_ctor_QVariant_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QVariant *> (new QVariant ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVariant::QVariant()\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_0, &_call_ctor_QVariant_0);
}

//  Constructor QVariant::QVariant(QVariant::Type type)


static void _init_ctor_QVariant_1776 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<QVariant::Type>::target_type & > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_1776 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QVariant::Type>::target_type & arg1 = args.read<const qt_gsi::Converter<QVariant::Type>::target_type & > ();
  ret.write<QVariant *> (new QVariant (qt_gsi::QtToCppAdaptor<QVariant::Type>(arg1).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_1776 ()
{
  return new qt_gsi::GenericStaticMethod ("new_type", "@brief Constructor QVariant::QVariant(QVariant::Type type)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_1776, &_call_ctor_QVariant_1776);
}

//  Constructor QVariant::QVariant(const QVariant &other)


static void _init_ctor_QVariant_2119 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QVariant & > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_2119 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVariant &arg1 = args.read<const QVariant & > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_2119 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVariant::QVariant(const QVariant &other)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_2119, &_call_ctor_QVariant_2119);
}

//  Constructor QVariant::QVariant(QDataStream &s)


static void _init_ctor_QVariant_1697 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<QDataStream & > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_1697 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDataStream &arg1 = args.read<QDataStream & > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_1697 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVariant::QVariant(QDataStream &s)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_1697, &_call_ctor_QVariant_1697);
}

//  Constructor QVariant::QVariant(int i)


static void _init_ctor_QVariant_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<int > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_767 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_767 ()
{
  return new qt_gsi::GenericStaticMethod ("new|new_i", "@brief Constructor QVariant::QVariant(int i)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_767, &_call_ctor_QVariant_767);
}

//  Constructor QVariant::QVariant(unsigned int ui)


static void _init_ctor_QVariant_1772 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ui");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_1772 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_1772 ()
{
  return new qt_gsi::GenericStaticMethod ("new_ui", "@brief Constructor QVariant::QVariant(unsigned int ui)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_1772, &_call_ctor_QVariant_1772);
}

//  Constructor QVariant::QVariant(qlonglong ll)


static void _init_ctor_QVariant_1413 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ll");
  decl->add_arg<qlonglong > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_1413 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  qlonglong arg1 = args.read<qlonglong > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_1413 ()
{
  return new qt_gsi::GenericStaticMethod ("new_ll", "@brief Constructor QVariant::QVariant(qlonglong ll)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_1413, &_call_ctor_QVariant_1413);
}

//  Constructor QVariant::QVariant(qulonglong ull)


static void _init_ctor_QVariant_1530 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ull");
  decl->add_arg<qulonglong > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_1530 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  qulonglong arg1 = args.read<qulonglong > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_1530 ()
{
  return new qt_gsi::GenericStaticMethod ("new_ull", "@brief Constructor QVariant::QVariant(qulonglong ull)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_1530, &_call_ctor_QVariant_1530);
}

//  Constructor QVariant::QVariant(bool b)


static void _init_ctor_QVariant_864 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_864 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_864 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVariant::QVariant(bool b)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_864, &_call_ctor_QVariant_864);
}

//  Constructor QVariant::QVariant(double d)


static void _init_ctor_QVariant_1071 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("d");
  decl->add_arg<double > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_1071 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_1071 ()
{
  return new qt_gsi::GenericStaticMethod ("new|new_d", "@brief Constructor QVariant::QVariant(double d)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_1071, &_call_ctor_QVariant_1071);
}

//  Constructor QVariant::QVariant(float f)


static void _init_ctor_QVariant_970 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("f");
  decl->add_arg<float > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_970 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  float arg1 = args.read<float > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_970 ()
{
  return new qt_gsi::GenericStaticMethod ("new_f", "@brief Constructor QVariant::QVariant(float f)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_970, &_call_ctor_QVariant_970);
}

//  Constructor QVariant::QVariant(const QString &string)


static void _init_ctor_QVariant_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVariant::QVariant(const QString &string)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_2025, &_call_ctor_QVariant_2025);
}

//  Constructor QVariant::QVariant(const QStringList &stringlist)


static void _init_ctor_QVariant_2437 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stringlist");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_2437 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStringList>::target_type & arg1 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  ret.write<QVariant *> (new QVariant (qt_gsi::QtToCppAdaptor<QStringList>(arg1).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_2437 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVariant::QVariant(const QStringList &stringlist)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_2437, &_call_ctor_QVariant_2437);
}

//  Constructor QVariant::QVariant(const QChar &qchar)


static void _init_ctor_QVariant_1776u1 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("qchar");
  decl->add_arg<const qt_gsi::Converter<QChar>::target_type & > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_1776u1 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QChar>::target_type & arg1 = args.read<const qt_gsi::Converter<QChar>::target_type & > ();
  ret.write<QVariant *> (new QVariant (qt_gsi::QtToCppAdaptor<QChar>(arg1).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_1776u1 ()
{
  return new qt_gsi::GenericStaticMethod ("new_c", "@brief Constructor QVariant::QVariant(const QChar &qchar)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_1776u1, &_call_ctor_QVariant_1776u1);
}

//  Constructor QVariant::QVariant(const QDate &date)


static void _init_ctor_QVariant_1776u2 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<const QDate & > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_1776u2 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDate &arg1 = args.read<const QDate & > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_1776u2 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVariant::QVariant(const QDate &date)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_1776u2, &_call_ctor_QVariant_1776u2);
}

//  Constructor QVariant::QVariant(const QTime &time)


static void _init_ctor_QVariant_1793 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("time");
  decl->add_arg<const QTime & > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_1793 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTime &arg1 = args.read<const QTime & > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_1793 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVariant::QVariant(const QTime &time)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_1793, &_call_ctor_QVariant_1793);
}

//  Constructor QVariant::QVariant(const QDateTime &datetime)


static void _init_ctor_QVariant_2175 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("datetime");
  decl->add_arg<const QDateTime & > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_2175 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDateTime &arg1 = args.read<const QDateTime & > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_2175 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVariant::QVariant(const QDateTime &datetime)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_2175, &_call_ctor_QVariant_2175);
}

//  Constructor QVariant::QVariant(const QList<QVariant> &list)


static void _init_ctor_QVariant_2734 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("list");
  decl->add_arg<const qt_gsi::Converter<QList<QVariant> >::target_type & > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_2734 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QVariant> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QVariant> >::target_type & > ();
  ret.write<QVariant *> (new QVariant (qt_gsi::QtToCppAdaptor<QList<QVariant> >(arg1).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_2734 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVariant::QVariant(const QList<QVariant> &list)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_2734, &_call_ctor_QVariant_2734);
}

//  Constructor QVariant::QVariant(const QSize &size)


static void _init_ctor_QVariant_1805 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_1805 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_1805 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVariant::QVariant(const QSize &size)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_1805, &_call_ctor_QVariant_1805);
}

//  Constructor QVariant::QVariant(const QSizeF &size)


static void _init_ctor_QVariant_1875 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSizeF & > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_1875 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSizeF &arg1 = args.read<const QSizeF & > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_1875 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVariant::QVariant(const QSizeF &size)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_1875, &_call_ctor_QVariant_1875);
}

//  Constructor QVariant::QVariant(const QPoint &pt)


static void _init_ctor_QVariant_1916 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pt");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_1916 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_1916 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVariant::QVariant(const QPoint &pt)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_1916, &_call_ctor_QVariant_1916);
}

//  Constructor QVariant::QVariant(const QPointF &pt)


static void _init_ctor_QVariant_1986 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pt");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_1986 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_1986 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVariant::QVariant(const QPointF &pt)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_1986, &_call_ctor_QVariant_1986);
}

//  Constructor QVariant::QVariant(const QLine &line)


static void _init_ctor_QVariant_1786 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("line");
  decl->add_arg<const QLine & > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_1786 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QLine &arg1 = args.read<const QLine & > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_1786 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVariant::QVariant(const QLine &line)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_1786, &_call_ctor_QVariant_1786);
}

//  Constructor QVariant::QVariant(const QLineF &line)


static void _init_ctor_QVariant_1856 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("line");
  decl->add_arg<const QLineF & > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_1856 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QLineF &arg1 = args.read<const QLineF & > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_1856 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVariant::QVariant(const QLineF &line)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_1856, &_call_ctor_QVariant_1856);
}

//  Constructor QVariant::QVariant(const QRect &rect)


static void _init_ctor_QVariant_1792 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_1792 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_1792 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVariant::QVariant(const QRect &rect)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_1792, &_call_ctor_QVariant_1792);
}

//  Constructor QVariant::QVariant(const QRectF &rect)


static void _init_ctor_QVariant_1862 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_1862 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_1862 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVariant::QVariant(const QRectF &rect)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_1862, &_call_ctor_QVariant_1862);
}

//  Constructor QVariant::QVariant(const QUrl &url)


static void _init_ctor_QVariant_1701 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_1701 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QUrl &arg1 = args.read<const QUrl & > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_1701 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVariant::QVariant(const QUrl &url)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_1701, &_call_ctor_QVariant_1701);
}

//  Constructor QVariant::QVariant(const QLocale &locale)


static void _init_ctor_QVariant_1986u1 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("locale");
  decl->add_arg<const QLocale & > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_1986u1 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QLocale &arg1 = args.read<const QLocale & > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_1986u1 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVariant::QVariant(const QLocale &locale)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_1986u1, &_call_ctor_QVariant_1986u1);
}

//  Constructor QVariant::QVariant(const QRegExp &regExp)


static void _init_ctor_QVariant_1981 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("regExp");
  decl->add_arg<const QRegExp & > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_1981 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRegExp &arg1 = args.read<const QRegExp & > ();
  ret.write<QVariant *> (new QVariant (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_1981 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVariant::QVariant(const QRegExp &regExp)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_1981, &_call_ctor_QVariant_1981);
}

//  Constructor QVariant::QVariant(Qt::GlobalColor color)


static void _init_ctor_QVariant_1853 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("color");
  decl->add_arg<const qt_gsi::Converter<Qt::GlobalColor>::target_type & > (argspec_0);
  decl->set_return_new<QVariant *> ();
}

static void _call_ctor_QVariant_1853 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::GlobalColor>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::GlobalColor>::target_type & > ();
  ret.write<QVariant *> (new QVariant (qt_gsi::QtToCppAdaptor<Qt::GlobalColor>(arg1).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVariant_1853 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVariant::QVariant(Qt::GlobalColor color)\nThis method creates an object of class QVariant.", &_init_ctor_QVariant_1853, &_call_ctor_QVariant_1853);
}

// bool QVariant::canConvert(QVariant::Type t)


static void _init_f_canConvert_c1776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("t");
  decl->add_arg<const qt_gsi::Converter<QVariant::Type>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_canConvert_c1776 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QVariant::Type>::target_type & arg1 = args.read<const qt_gsi::Converter<QVariant::Type>::target_type & > ();
  ret.write<bool > ((bool)((QVariant *)cls)->canConvert (qt_gsi::QtToCppAdaptor<QVariant::Type>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_canConvert_c1776 ()
{
  return new qt_gsi::GenericMethod ("canConvert", "@brief Method bool QVariant::canConvert(QVariant::Type t)\n", true, &_init_f_canConvert_c1776, &_call_f_canConvert_c1776);
}

// void QVariant::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QVariant *)cls)->clear ();
}

static qt_gsi::GenericMethod *_create_f_clear_0 ()
{
  return new qt_gsi::GenericMethod ("clear", "@brief Method void QVariant::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
}

// const void *QVariant::constData()


static void _init_f_constData_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const void * > ();
}

static void _call_f_constData_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const void * > ((const void *)((QVariant *)cls)->constData ());
}

static qt_gsi::GenericMethod *_create_f_constData_c0 ()
{
  return new qt_gsi::GenericMethod ("constData", "@brief Method const void *QVariant::constData()\n", true, &_init_f_constData_c0, &_call_f_constData_c0);
}

// bool QVariant::convert(QVariant::Type t)


static void _init_f_convert_1776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("t");
  decl->add_arg<const qt_gsi::Converter<QVariant::Type>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_convert_1776 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QVariant::Type>::target_type & arg1 = args.read<const qt_gsi::Converter<QVariant::Type>::target_type & > ();
  ret.write<bool > ((bool)((QVariant *)cls)->convert (qt_gsi::QtToCppAdaptor<QVariant::Type>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_convert_1776 ()
{
  return new qt_gsi::GenericMethod ("convert", "@brief Method bool QVariant::convert(QVariant::Type t)\n", false, &_init_f_convert_1776, &_call_f_convert_1776);
}

// void *QVariant::data()


static void _init_f_data_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void * > ();
}

static void _call_f_data_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<void * > ((void *)((QVariant *)cls)->data ());
}

static qt_gsi::GenericMethod *_create_f_data_0 ()
{
  return new qt_gsi::GenericMethod ("data", "@brief Method void *QVariant::data()\n", false, &_init_f_data_0, &_call_f_data_0);
}

// const void *QVariant::data()


static void _init_f_data_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const void * > ();
}

static void _call_f_data_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const void * > ((const void *)((QVariant *)cls)->data ());
}

static qt_gsi::GenericMethod *_create_f_data_c0 ()
{
  return new qt_gsi::GenericMethod ("data", "@brief Method const void *QVariant::data()\n", true, &_init_f_data_c0, &_call_f_data_c0);
}

// void QVariant::detach()


static void _init_f_detach_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_detach_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QVariant *)cls)->detach ();
}

static qt_gsi::GenericMethod *_create_f_detach_0 ()
{
  return new qt_gsi::GenericMethod ("detach", "@brief Method void QVariant::detach()\n", false, &_init_f_detach_0, &_call_f_detach_0);
}

// bool QVariant::isDetached()


static void _init_f_isDetached_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDetached_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QVariant *)cls)->isDetached ());
}

static qt_gsi::GenericMethod *_create_f_isDetached_c0 ()
{
  return new qt_gsi::GenericMethod ("isDetached?", "@brief Method bool QVariant::isDetached()\n", true, &_init_f_isDetached_c0, &_call_f_isDetached_c0);
}

// bool QVariant::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QVariant *)cls)->isNull ());
}

static qt_gsi::GenericMethod *_create_f_isNull_c0 ()
{
  return new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QVariant::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
}

// bool QVariant::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QVariant *)cls)->isValid ());
}

static qt_gsi::GenericMethod *_create_f_isValid_c0 ()
{
  return new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QVariant::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
}

// void QVariant::load(QDataStream &ds)


static void _init_f_load_1697 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ds");
  decl->add_arg<QDataStream & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_load_1697 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDataStream &arg1 = args.read<QDataStream & > ();
  ((QVariant *)cls)->load (arg1);
}

static qt_gsi::GenericMethod *_create_f_load_1697 ()
{
  return new qt_gsi::GenericMethod ("load", "@brief Method void QVariant::load(QDataStream &ds)\n", false, &_init_f_load_1697, &_call_f_load_1697);
}

// bool QVariant::operator!=(const QVariant &v)


static void _init_f_operator_excl__eq__c2119 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("v");
  decl->add_arg<const QVariant & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c2119 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVariant &arg1 = args.read<const QVariant & > ();
  ret.write<bool > ((bool)((QVariant *)cls)->operator!= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__c2119 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QVariant::operator!=(const QVariant &v)\n", true, &_init_f_operator_excl__eq__c2119, &_call_f_operator_excl__eq__c2119);
}

// QVariant &QVariant::operator=(const QVariant &other)


static void _init_f_operator_eq__2119 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QVariant & > (argspec_0);
  decl->set_return<QVariant & > ();
}

static void _call_f_operator_eq__2119 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVariant &arg1 = args.read<const QVariant & > ();
  ret.write<QVariant & > ((QVariant &)((QVariant *)cls)->operator= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__2119 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QVariant &QVariant::operator=(const QVariant &other)\n", false, &_init_f_operator_eq__2119, &_call_f_operator_eq__2119);
}

// bool QVariant::operator==(const QVariant &v)


static void _init_f_operator_eq__eq__c2119 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("v");
  decl->add_arg<const QVariant & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2119 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVariant &arg1 = args.read<const QVariant & > ();
  ret.write<bool > ((bool)((QVariant *)cls)->operator== (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__c2119 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QVariant::operator==(const QVariant &v)\n", true, &_init_f_operator_eq__eq__c2119, &_call_f_operator_eq__eq__c2119);
}

// void QVariant::save(QDataStream &ds)


static void _init_f_save_c1697 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ds");
  decl->add_arg<QDataStream & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_save_c1697 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDataStream &arg1 = args.read<QDataStream & > ();
  ((QVariant *)cls)->save (arg1);
}

static qt_gsi::GenericMethod *_create_f_save_c1697 ()
{
  return new qt_gsi::GenericMethod ("save", "@brief Method void QVariant::save(QDataStream &ds)\n", true, &_init_f_save_c1697, &_call_f_save_c1697);
}

// bool QVariant::toBool()


static void _init_f_toBool_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_toBool_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QVariant *)cls)->toBool ());
}

static qt_gsi::GenericMethod *_create_f_toBool_c0 ()
{
  return new qt_gsi::GenericMethod ("toBool", "@brief Method bool QVariant::toBool()\n", true, &_init_f_toBool_c0, &_call_f_toBool_c0);
}

// QByteArray QVariant::toByteArray()


static void _init_f_toByteArray_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_toByteArray_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray > ((QByteArray)((QVariant *)cls)->toByteArray ());
}

static qt_gsi::GenericMethod *_create_f_toByteArray_c0 ()
{
  return new qt_gsi::GenericMethod ("toByteArray", "@brief Method QByteArray QVariant::toByteArray()\n", true, &_init_f_toByteArray_c0, &_call_f_toByteArray_c0);
}

// QChar QVariant::toChar()


static void _init_f_toChar_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_toChar_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QVariant *)cls)->toChar ()));
}

static qt_gsi::GenericMethod *_create_f_toChar_c0 ()
{
  return new qt_gsi::GenericMethod ("toChar", "@brief Method QChar QVariant::toChar()\n", true, &_init_f_toChar_c0, &_call_f_toChar_c0);
}

// QDate QVariant::toDate()


static void _init_f_toDate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDate > ();
}

static void _call_f_toDate_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDate > ((QDate)((QVariant *)cls)->toDate ());
}

static qt_gsi::GenericMethod *_create_f_toDate_c0 ()
{
  return new qt_gsi::GenericMethod ("toDate", "@brief Method QDate QVariant::toDate()\n", true, &_init_f_toDate_c0, &_call_f_toDate_c0);
}

// QDateTime QVariant::toDateTime()


static void _init_f_toDateTime_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDateTime > ();
}

static void _call_f_toDateTime_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDateTime > ((QDateTime)((QVariant *)cls)->toDateTime ());
}

static qt_gsi::GenericMethod *_create_f_toDateTime_c0 ()
{
  return new qt_gsi::GenericMethod ("toDateTime", "@brief Method QDateTime QVariant::toDateTime()\n", true, &_init_f_toDateTime_c0, &_call_f_toDateTime_c0);
}

// double QVariant::toDouble(bool *ok)


static void _init_f_toDouble_c1050 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_toDouble_c1050 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool *arg1 = args ? args.read<bool * > () : (bool *)(0);
  ret.write<double > ((double)((QVariant *)cls)->toDouble (arg1));
}

static qt_gsi::GenericMethod *_create_f_toDouble_c1050 ()
{
  return new qt_gsi::GenericMethod ("toDouble", "@brief Method double QVariant::toDouble(bool *ok)\n", true, &_init_f_toDouble_c1050, &_call_f_toDouble_c1050);
}

// float QVariant::toFloat(bool *ok)


static void _init_f_toFloat_c1050 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_0);
  decl->set_return<float > ();
}

static void _call_f_toFloat_c1050 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool *arg1 = args ? args.read<bool * > () : (bool *)(0);
  ret.write<float > ((float)((QVariant *)cls)->toFloat (arg1));
}

static qt_gsi::GenericMethod *_create_f_toFloat_c1050 ()
{
  return new qt_gsi::GenericMethod ("toFloat", "@brief Method float QVariant::toFloat(bool *ok)\n", true, &_init_f_toFloat_c1050, &_call_f_toFloat_c1050);
}

// int QVariant::toInt(bool *ok)


static void _init_f_toInt_c1050 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_toInt_c1050 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool *arg1 = args ? args.read<bool * > () : (bool *)(0);
  ret.write<int > ((int)((QVariant *)cls)->toInt (arg1));
}

static qt_gsi::GenericMethod *_create_f_toInt_c1050 ()
{
  return new qt_gsi::GenericMethod ("toInt", "@brief Method int QVariant::toInt(bool *ok)\n", true, &_init_f_toInt_c1050, &_call_f_toInt_c1050);
}

// QLine QVariant::toLine()


static void _init_f_toLine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLine > ();
}

static void _call_f_toLine_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QLine > ((QLine)((QVariant *)cls)->toLine ());
}

static qt_gsi::GenericMethod *_create_f_toLine_c0 ()
{
  return new qt_gsi::GenericMethod ("toLine", "@brief Method QLine QVariant::toLine()\n", true, &_init_f_toLine_c0, &_call_f_toLine_c0);
}

// QLineF QVariant::toLineF()


static void _init_f_toLineF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLineF > ();
}

static void _call_f_toLineF_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QLineF > ((QLineF)((QVariant *)cls)->toLineF ());
}

static qt_gsi::GenericMethod *_create_f_toLineF_c0 ()
{
  return new qt_gsi::GenericMethod ("toLineF", "@brief Method QLineF QVariant::toLineF()\n", true, &_init_f_toLineF_c0, &_call_f_toLineF_c0);
}

// QList<QVariant> QVariant::toList()


static void _init_f_toList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QVariant> >::target_type > ();
}

static void _call_f_toList_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QVariant> >::target_type > ((qt_gsi::Converter<QList<QVariant> >::target_type)qt_gsi::CppToQtAdaptor<QList<QVariant> >(((QVariant *)cls)->toList ()));
}

static qt_gsi::GenericMethod *_create_f_toList_c0 ()
{
  return new qt_gsi::GenericMethod ("toList", "@brief Method QList<QVariant> QVariant::toList()\n", true, &_init_f_toList_c0, &_call_f_toList_c0);
}

// QLocale QVariant::toLocale()


static void _init_f_toLocale_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLocale > ();
}

static void _call_f_toLocale_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QLocale > ((QLocale)((QVariant *)cls)->toLocale ());
}

static qt_gsi::GenericMethod *_create_f_toLocale_c0 ()
{
  return new qt_gsi::GenericMethod ("toLocale", "@brief Method QLocale QVariant::toLocale()\n", true, &_init_f_toLocale_c0, &_call_f_toLocale_c0);
}

// qlonglong QVariant::toLongLong(bool *ok)


static void _init_f_toLongLong_c1050 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_0);
  decl->set_return<qlonglong > ();
}

static void _call_f_toLongLong_c1050 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool *arg1 = args ? args.read<bool * > () : (bool *)(0);
  ret.write<qlonglong > ((qlonglong)((QVariant *)cls)->toLongLong (arg1));
}

static qt_gsi::GenericMethod *_create_f_toLongLong_c1050 ()
{
  return new qt_gsi::GenericMethod ("toLongLong", "@brief Method qlonglong QVariant::toLongLong(bool *ok)\n", true, &_init_f_toLongLong_c1050, &_call_f_toLongLong_c1050);
}

// QPoint QVariant::toPoint()


static void _init_f_toPoint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_f_toPoint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPoint > ((QPoint)((QVariant *)cls)->toPoint ());
}

static qt_gsi::GenericMethod *_create_f_toPoint_c0 ()
{
  return new qt_gsi::GenericMethod ("toPoint", "@brief Method QPoint QVariant::toPoint()\n", true, &_init_f_toPoint_c0, &_call_f_toPoint_c0);
}

// QPointF QVariant::toPointF()


static void _init_f_toPointF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_toPointF_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPointF > ((QPointF)((QVariant *)cls)->toPointF ());
}

static qt_gsi::GenericMethod *_create_f_toPointF_c0 ()
{
  return new qt_gsi::GenericMethod ("toPointF", "@brief Method QPointF QVariant::toPointF()\n", true, &_init_f_toPointF_c0, &_call_f_toPointF_c0);
}

// double QVariant::toReal(bool *ok)


static void _init_f_toReal_c1050 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_toReal_c1050 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool *arg1 = args ? args.read<bool * > () : (bool *)(0);
  ret.write<double > ((double)((QVariant *)cls)->toReal (arg1));
}

static qt_gsi::GenericMethod *_create_f_toReal_c1050 ()
{
  return new qt_gsi::GenericMethod ("toReal", "@brief Method double QVariant::toReal(bool *ok)\n", true, &_init_f_toReal_c1050, &_call_f_toReal_c1050);
}

// QRect QVariant::toRect()


static void _init_f_toRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_toRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QVariant *)cls)->toRect ());
}

static qt_gsi::GenericMethod *_create_f_toRect_c0 ()
{
  return new qt_gsi::GenericMethod ("toRect", "@brief Method QRect QVariant::toRect()\n", true, &_init_f_toRect_c0, &_call_f_toRect_c0);
}

// QRectF QVariant::toRectF()


static void _init_f_toRectF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_toRectF_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRectF > ((QRectF)((QVariant *)cls)->toRectF ());
}

static qt_gsi::GenericMethod *_create_f_toRectF_c0 ()
{
  return new qt_gsi::GenericMethod ("toRectF", "@brief Method QRectF QVariant::toRectF()\n", true, &_init_f_toRectF_c0, &_call_f_toRectF_c0);
}

// QRegExp QVariant::toRegExp()


static void _init_f_toRegExp_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRegExp > ();
}

static void _call_f_toRegExp_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRegExp > ((QRegExp)((QVariant *)cls)->toRegExp ());
}

static qt_gsi::GenericMethod *_create_f_toRegExp_c0 ()
{
  return new qt_gsi::GenericMethod ("toRegExp", "@brief Method QRegExp QVariant::toRegExp()\n", true, &_init_f_toRegExp_c0, &_call_f_toRegExp_c0);
}

// QSize QVariant::toSize()


static void _init_f_toSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_toSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QVariant *)cls)->toSize ());
}

static qt_gsi::GenericMethod *_create_f_toSize_c0 ()
{
  return new qt_gsi::GenericMethod ("toSize", "@brief Method QSize QVariant::toSize()\n", true, &_init_f_toSize_c0, &_call_f_toSize_c0);
}

// QSizeF QVariant::toSizeF()


static void _init_f_toSizeF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizeF > ();
}

static void _call_f_toSizeF_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSizeF > ((QSizeF)((QVariant *)cls)->toSizeF ());
}

static qt_gsi::GenericMethod *_create_f_toSizeF_c0 ()
{
  return new qt_gsi::GenericMethod ("toSizeF", "@brief Method QSizeF QVariant::toSizeF()\n", true, &_init_f_toSizeF_c0, &_call_f_toSizeF_c0);
}

// QString QVariant::toString()


static void _init_f_toString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toString_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QVariant *)cls)->toString ());
}

static qt_gsi::GenericMethod *_create_f_toString_c0 ()
{
  return new qt_gsi::GenericMethod ("toString|to_s", "@brief Method QString QVariant::toString()\n", true, &_init_f_toString_c0, &_call_f_toString_c0);
}

// QStringList QVariant::toStringList()


static void _init_f_toStringList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_toStringList_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QVariant *)cls)->toStringList ()));
}

static qt_gsi::GenericMethod *_create_f_toStringList_c0 ()
{
  return new qt_gsi::GenericMethod ("toStringList", "@brief Method QStringList QVariant::toStringList()\n", true, &_init_f_toStringList_c0, &_call_f_toStringList_c0);
}

// QTime QVariant::toTime()


static void _init_f_toTime_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTime > ();
}

static void _call_f_toTime_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTime > ((QTime)((QVariant *)cls)->toTime ());
}

static qt_gsi::GenericMethod *_create_f_toTime_c0 ()
{
  return new qt_gsi::GenericMethod ("toTime", "@brief Method QTime QVariant::toTime()\n", true, &_init_f_toTime_c0, &_call_f_toTime_c0);
}

// unsigned int QVariant::toUInt(bool *ok)


static void _init_f_toUInt_c1050 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_0);
  decl->set_return<unsigned int > ();
}

static void _call_f_toUInt_c1050 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool *arg1 = args ? args.read<bool * > () : (bool *)(0);
  ret.write<unsigned int > ((unsigned int)((QVariant *)cls)->toUInt (arg1));
}

static qt_gsi::GenericMethod *_create_f_toUInt_c1050 ()
{
  return new qt_gsi::GenericMethod ("toUInt", "@brief Method unsigned int QVariant::toUInt(bool *ok)\n", true, &_init_f_toUInt_c1050, &_call_f_toUInt_c1050);
}

// qulonglong QVariant::toULongLong(bool *ok)


static void _init_f_toULongLong_c1050 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_0);
  decl->set_return<qulonglong > ();
}

static void _call_f_toULongLong_c1050 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool *arg1 = args ? args.read<bool * > () : (bool *)(0);
  ret.write<qulonglong > ((qulonglong)((QVariant *)cls)->toULongLong (arg1));
}

static qt_gsi::GenericMethod *_create_f_toULongLong_c1050 ()
{
  return new qt_gsi::GenericMethod ("toULongLong", "@brief Method qulonglong QVariant::toULongLong(bool *ok)\n", true, &_init_f_toULongLong_c1050, &_call_f_toULongLong_c1050);
}

// QUrl QVariant::toUrl()


static void _init_f_toUrl_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QUrl > ();
}

static void _call_f_toUrl_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QUrl > ((QUrl)((QVariant *)cls)->toUrl ());
}

static qt_gsi::GenericMethod *_create_f_toUrl_c0 ()
{
  return new qt_gsi::GenericMethod ("toUrl", "@brief Method QUrl QVariant::toUrl()\n", true, &_init_f_toUrl_c0, &_call_f_toUrl_c0);
}

// QVariant::Type QVariant::type()


static void _init_f_type_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QVariant::Type>::target_type > ();
}

static void _call_f_type_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QVariant::Type>::target_type > ((qt_gsi::Converter<QVariant::Type>::target_type)qt_gsi::CppToQtAdaptor<QVariant::Type>(((QVariant *)cls)->type ()));
}

static qt_gsi::GenericMethod *_create_f_type_c0 ()
{
  return new qt_gsi::GenericMethod ("type", "@brief Method QVariant::Type QVariant::type()\n", true, &_init_f_type_c0, &_call_f_type_c0);
}

// const char *QVariant::typeName()


static void _init_f_typeName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const char * > ();
}

static void _call_f_typeName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const char * > ((const char *)((QVariant *)cls)->typeName ());
}

static qt_gsi::GenericMethod *_create_f_typeName_c0 ()
{
  return new qt_gsi::GenericMethod ("typeName", "@brief Method const char *QVariant::typeName()\n", true, &_init_f_typeName_c0, &_call_f_typeName_c0);
}

// int QVariant::userType()


static void _init_f_userType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_userType_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QVariant *)cls)->userType ());
}

static qt_gsi::GenericMethod *_create_f_userType_c0 ()
{
  return new qt_gsi::GenericMethod ("userType", "@brief Method int QVariant::userType()\n", true, &_init_f_userType_c0, &_call_f_userType_c0);
}

// static QVariant::Type QVariant::nameToType(const char *name)


static void _init_f_nameToType_1731 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<qt_gsi::Converter<QVariant::Type>::target_type > ();
}

static void _call_f_nameToType_1731 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<qt_gsi::Converter<QVariant::Type>::target_type > ((qt_gsi::Converter<QVariant::Type>::target_type)qt_gsi::CppToQtAdaptor<QVariant::Type>(QVariant::nameToType (arg1)));
}

static qt_gsi::GenericStaticMethod *_create_f_nameToType_1731 ()
{
  return new qt_gsi::GenericStaticMethod ("nameToType", "@brief Static method QVariant::Type QVariant::nameToType(const char *name)\nThis method is static and can be called without an instance.", &_init_f_nameToType_1731, &_call_f_nameToType_1731);
}

// static const char *QVariant::typeToName(QVariant::Type type)


static void _init_f_typeToName_1776 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<QVariant::Type>::target_type & > (argspec_0);
  decl->set_return<const char * > ();
}

static void _call_f_typeToName_1776 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QVariant::Type>::target_type & arg1 = args.read<const qt_gsi::Converter<QVariant::Type>::target_type & > ();
  ret.write<const char * > ((const char *)QVariant::typeToName (qt_gsi::QtToCppAdaptor<QVariant::Type>(arg1).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_typeToName_1776 ()
{
  return new qt_gsi::GenericStaticMethod ("typeToName", "@brief Static method const char *QVariant::typeToName(QVariant::Type type)\nThis method is static and can be called without an instance.", &_init_f_typeToName_1776, &_call_f_typeToName_1776);
}


namespace gsi
{
gsi::Class<QVariant> decl_QVariant ("QVariant",
  gsi::Methods(_create_ctor_QVariant_0 ()) +
  gsi::Methods(_create_ctor_QVariant_1776 ()) +
  gsi::Methods(_create_ctor_QVariant_2119 ()) +
  gsi::Methods(_create_ctor_QVariant_1697 ()) +
  gsi::Methods(_create_ctor_QVariant_767 ()) +
  gsi::Methods(_create_ctor_QVariant_1772 ()) +
  gsi::Methods(_create_ctor_QVariant_1413 ()) +
  gsi::Methods(_create_ctor_QVariant_1530 ()) +
  gsi::Methods(_create_ctor_QVariant_864 ()) +
  gsi::Methods(_create_ctor_QVariant_1071 ()) +
  gsi::Methods(_create_ctor_QVariant_970 ()) +
  gsi::Methods(_create_ctor_QVariant_2025 ()) +
  gsi::Methods(_create_ctor_QVariant_2437 ()) +
  gsi::Methods(_create_ctor_QVariant_1776u1 ()) +
  gsi::Methods(_create_ctor_QVariant_1776u2 ()) +
  gsi::Methods(_create_ctor_QVariant_1793 ()) +
  gsi::Methods(_create_ctor_QVariant_2175 ()) +
  gsi::Methods(_create_ctor_QVariant_2734 ()) +
  gsi::Methods(_create_ctor_QVariant_1805 ()) +
  gsi::Methods(_create_ctor_QVariant_1875 ()) +
  gsi::Methods(_create_ctor_QVariant_1916 ()) +
  gsi::Methods(_create_ctor_QVariant_1986 ()) +
  gsi::Methods(_create_ctor_QVariant_1786 ()) +
  gsi::Methods(_create_ctor_QVariant_1856 ()) +
  gsi::Methods(_create_ctor_QVariant_1792 ()) +
  gsi::Methods(_create_ctor_QVariant_1862 ()) +
  gsi::Methods(_create_ctor_QVariant_1701 ()) +
  gsi::Methods(_create_ctor_QVariant_1986u1 ()) +
  gsi::Methods(_create_ctor_QVariant_1981 ()) +
  gsi::Methods(_create_ctor_QVariant_1853 ()) +
  gsi::Methods(_create_f_canConvert_c1776 ()) +
  gsi::Methods(_create_f_clear_0 ()) +
  gsi::Methods(_create_f_constData_c0 ()) +
  gsi::Methods(_create_f_convert_1776 ()) +
  gsi::Methods(_create_f_data_0 ()) +
  gsi::Methods(_create_f_data_c0 ()) +
  gsi::Methods(_create_f_detach_0 ()) +
  gsi::Methods(_create_f_isDetached_c0 ()) +
  gsi::Methods(_create_f_isNull_c0 ()) +
  gsi::Methods(_create_f_isValid_c0 ()) +
  gsi::Methods(_create_f_load_1697 ()) +
  gsi::Methods(_create_f_operator_excl__eq__c2119 ()) +
  gsi::Methods(_create_f_operator_eq__2119 ()) +
  gsi::Methods(_create_f_operator_eq__eq__c2119 ()) +
  gsi::Methods(_create_f_save_c1697 ()) +
  gsi::Methods(_create_f_toBool_c0 ()) +
  gsi::Methods(_create_f_toByteArray_c0 ()) +
  gsi::Methods(_create_f_toChar_c0 ()) +
  gsi::Methods(_create_f_toDate_c0 ()) +
  gsi::Methods(_create_f_toDateTime_c0 ()) +
  gsi::Methods(_create_f_toDouble_c1050 ()) +
  gsi::Methods(_create_f_toFloat_c1050 ()) +
  gsi::Methods(_create_f_toInt_c1050 ()) +
  gsi::Methods(_create_f_toLine_c0 ()) +
  gsi::Methods(_create_f_toLineF_c0 ()) +
  gsi::Methods(_create_f_toList_c0 ()) +
  gsi::Methods(_create_f_toLocale_c0 ()) +
  gsi::Methods(_create_f_toLongLong_c1050 ()) +
  gsi::Methods(_create_f_toPoint_c0 ()) +
  gsi::Methods(_create_f_toPointF_c0 ()) +
  gsi::Methods(_create_f_toReal_c1050 ()) +
  gsi::Methods(_create_f_toRect_c0 ()) +
  gsi::Methods(_create_f_toRectF_c0 ()) +
  gsi::Methods(_create_f_toRegExp_c0 ()) +
  gsi::Methods(_create_f_toSize_c0 ()) +
  gsi::Methods(_create_f_toSizeF_c0 ()) +
  gsi::Methods(_create_f_toString_c0 ()) +
  gsi::Methods(_create_f_toStringList_c0 ()) +
  gsi::Methods(_create_f_toTime_c0 ()) +
  gsi::Methods(_create_f_toUInt_c1050 ()) +
  gsi::Methods(_create_f_toULongLong_c1050 ()) +
  gsi::Methods(_create_f_toUrl_c0 ()) +
  gsi::Methods(_create_f_type_c0 ()) +
  gsi::Methods(_create_f_typeName_c0 ()) +
  gsi::Methods(_create_f_userType_c0 ()) +
  gsi::Methods(_create_f_nameToType_1731 ()) +
  gsi::Methods(_create_f_typeToName_1776 ()),
  "@qt\n@brief Binding of QVariant");

}


//  Implementation of the enum wrapper class for QVariant::Type
namespace qt_gsi
{

static QVariant_Type_Enum *c_1_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Invalid); }
static QVariant_Type_Enum *c_2_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Bool); }
static QVariant_Type_Enum *c_3_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Int); }
static QVariant_Type_Enum *c_4_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::UInt); }
static QVariant_Type_Enum *c_5_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::LongLong); }
static QVariant_Type_Enum *c_6_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::ULongLong); }
static QVariant_Type_Enum *c_7_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Double); }
static QVariant_Type_Enum *c_8_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Char); }
static QVariant_Type_Enum *c_9_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Map); }
static QVariant_Type_Enum *c_10_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::List); }
static QVariant_Type_Enum *c_11_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::String); }
static QVariant_Type_Enum *c_12_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::StringList); }
static QVariant_Type_Enum *c_13_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::ByteArray); }
static QVariant_Type_Enum *c_14_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::BitArray); }
static QVariant_Type_Enum *c_15_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Date); }
static QVariant_Type_Enum *c_16_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Time); }
static QVariant_Type_Enum *c_17_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::DateTime); }
static QVariant_Type_Enum *c_18_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Url); }
static QVariant_Type_Enum *c_19_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Locale); }
static QVariant_Type_Enum *c_20_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Rect); }
static QVariant_Type_Enum *c_21_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::RectF); }
static QVariant_Type_Enum *c_22_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Size); }
static QVariant_Type_Enum *c_23_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::SizeF); }
static QVariant_Type_Enum *c_24_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Line); }
static QVariant_Type_Enum *c_25_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::LineF); }
static QVariant_Type_Enum *c_26_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Point); }
static QVariant_Type_Enum *c_27_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::PointF); }
static QVariant_Type_Enum *c_28_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::RegExp); }
static QVariant_Type_Enum *c_29_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Hash); }
static QVariant_Type_Enum *c_30_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::LastCoreType); }
static QVariant_Type_Enum *c_31_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Font); }
static QVariant_Type_Enum *c_32_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Pixmap); }
static QVariant_Type_Enum *c_33_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Brush); }
static QVariant_Type_Enum *c_34_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Color); }
static QVariant_Type_Enum *c_35_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Palette); }
static QVariant_Type_Enum *c_36_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Icon); }
static QVariant_Type_Enum *c_37_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Image); }
static QVariant_Type_Enum *c_38_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Polygon); }
static QVariant_Type_Enum *c_39_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Region); }
static QVariant_Type_Enum *c_40_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Bitmap); }
static QVariant_Type_Enum *c_41_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Cursor); }
static QVariant_Type_Enum *c_42_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::SizePolicy); }
static QVariant_Type_Enum *c_43_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::KeySequence); }
static QVariant_Type_Enum *c_44_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Pen); }
static QVariant_Type_Enum *c_45_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::TextLength); }
static QVariant_Type_Enum *c_46_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::TextFormat); }
static QVariant_Type_Enum *c_47_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Matrix); }
static QVariant_Type_Enum *c_48_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Transform); }
static QVariant_Type_Enum *c_49_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Matrix4x4); }
static QVariant_Type_Enum *c_50_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Vector2D); }
static QVariant_Type_Enum *c_51_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Vector3D); }
static QVariant_Type_Enum *c_52_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Vector4D); }
static QVariant_Type_Enum *c_53_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::Quaternion); }
static QVariant_Type_Enum *c_54_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::LastGuiType); }
static QVariant_Type_Enum *c_55_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::UserType); }
static QVariant_Type_Enum *c_56_QVariant_Type_Enum () { return new QVariant_Type_Enum (QVariant::LastType); }

static gsi::Methods mkdefs_QVariant_Type () {
  return
    gsi::constant ("Invalid", &qt_gsi::c_1_QVariant_Type_Enum, "@brief Enum constant QVariant::Invalid") +
    gsi::constant ("Bool", &qt_gsi::c_2_QVariant_Type_Enum, "@brief Enum constant QVariant::Bool") +
    gsi::constant ("Int", &qt_gsi::c_3_QVariant_Type_Enum, "@brief Enum constant QVariant::Int") +
    gsi::constant ("UInt", &qt_gsi::c_4_QVariant_Type_Enum, "@brief Enum constant QVariant::UInt") +
    gsi::constant ("LongLong", &qt_gsi::c_5_QVariant_Type_Enum, "@brief Enum constant QVariant::LongLong") +
    gsi::constant ("ULongLong", &qt_gsi::c_6_QVariant_Type_Enum, "@brief Enum constant QVariant::ULongLong") +
    gsi::constant ("Double", &qt_gsi::c_7_QVariant_Type_Enum, "@brief Enum constant QVariant::Double") +
    gsi::constant ("Char", &qt_gsi::c_8_QVariant_Type_Enum, "@brief Enum constant QVariant::Char") +
    gsi::constant ("Map", &qt_gsi::c_9_QVariant_Type_Enum, "@brief Enum constant QVariant::Map") +
    gsi::constant ("List", &qt_gsi::c_10_QVariant_Type_Enum, "@brief Enum constant QVariant::List") +
    gsi::constant ("String", &qt_gsi::c_11_QVariant_Type_Enum, "@brief Enum constant QVariant::String") +
    gsi::constant ("StringList", &qt_gsi::c_12_QVariant_Type_Enum, "@brief Enum constant QVariant::StringList") +
    gsi::constant ("ByteArray", &qt_gsi::c_13_QVariant_Type_Enum, "@brief Enum constant QVariant::ByteArray") +
    gsi::constant ("BitArray", &qt_gsi::c_14_QVariant_Type_Enum, "@brief Enum constant QVariant::BitArray") +
    gsi::constant ("Date", &qt_gsi::c_15_QVariant_Type_Enum, "@brief Enum constant QVariant::Date") +
    gsi::constant ("Time", &qt_gsi::c_16_QVariant_Type_Enum, "@brief Enum constant QVariant::Time") +
    gsi::constant ("DateTime", &qt_gsi::c_17_QVariant_Type_Enum, "@brief Enum constant QVariant::DateTime") +
    gsi::constant ("Url", &qt_gsi::c_18_QVariant_Type_Enum, "@brief Enum constant QVariant::Url") +
    gsi::constant ("Locale", &qt_gsi::c_19_QVariant_Type_Enum, "@brief Enum constant QVariant::Locale") +
    gsi::constant ("Rect", &qt_gsi::c_20_QVariant_Type_Enum, "@brief Enum constant QVariant::Rect") +
    gsi::constant ("RectF", &qt_gsi::c_21_QVariant_Type_Enum, "@brief Enum constant QVariant::RectF") +
    gsi::constant ("Size", &qt_gsi::c_22_QVariant_Type_Enum, "@brief Enum constant QVariant::Size") +
    gsi::constant ("SizeF", &qt_gsi::c_23_QVariant_Type_Enum, "@brief Enum constant QVariant::SizeF") +
    gsi::constant ("Line", &qt_gsi::c_24_QVariant_Type_Enum, "@brief Enum constant QVariant::Line") +
    gsi::constant ("LineF", &qt_gsi::c_25_QVariant_Type_Enum, "@brief Enum constant QVariant::LineF") +
    gsi::constant ("Point", &qt_gsi::c_26_QVariant_Type_Enum, "@brief Enum constant QVariant::Point") +
    gsi::constant ("PointF", &qt_gsi::c_27_QVariant_Type_Enum, "@brief Enum constant QVariant::PointF") +
    gsi::constant ("RegExp", &qt_gsi::c_28_QVariant_Type_Enum, "@brief Enum constant QVariant::RegExp") +
    gsi::constant ("Hash", &qt_gsi::c_29_QVariant_Type_Enum, "@brief Enum constant QVariant::Hash") +
    gsi::constant ("LastCoreType", &qt_gsi::c_30_QVariant_Type_Enum, "@brief Enum constant QVariant::LastCoreType") +
    gsi::constant ("Font", &qt_gsi::c_31_QVariant_Type_Enum, "@brief Enum constant QVariant::Font") +
    gsi::constant ("Pixmap", &qt_gsi::c_32_QVariant_Type_Enum, "@brief Enum constant QVariant::Pixmap") +
    gsi::constant ("Brush", &qt_gsi::c_33_QVariant_Type_Enum, "@brief Enum constant QVariant::Brush") +
    gsi::constant ("Color", &qt_gsi::c_34_QVariant_Type_Enum, "@brief Enum constant QVariant::Color") +
    gsi::constant ("Palette", &qt_gsi::c_35_QVariant_Type_Enum, "@brief Enum constant QVariant::Palette") +
    gsi::constant ("Icon", &qt_gsi::c_36_QVariant_Type_Enum, "@brief Enum constant QVariant::Icon") +
    gsi::constant ("Image", &qt_gsi::c_37_QVariant_Type_Enum, "@brief Enum constant QVariant::Image") +
    gsi::constant ("Polygon", &qt_gsi::c_38_QVariant_Type_Enum, "@brief Enum constant QVariant::Polygon") +
    gsi::constant ("Region", &qt_gsi::c_39_QVariant_Type_Enum, "@brief Enum constant QVariant::Region") +
    gsi::constant ("Bitmap", &qt_gsi::c_40_QVariant_Type_Enum, "@brief Enum constant QVariant::Bitmap") +
    gsi::constant ("Cursor", &qt_gsi::c_41_QVariant_Type_Enum, "@brief Enum constant QVariant::Cursor") +
    gsi::constant ("SizePolicy", &qt_gsi::c_42_QVariant_Type_Enum, "@brief Enum constant QVariant::SizePolicy") +
    gsi::constant ("KeySequence", &qt_gsi::c_43_QVariant_Type_Enum, "@brief Enum constant QVariant::KeySequence") +
    gsi::constant ("Pen", &qt_gsi::c_44_QVariant_Type_Enum, "@brief Enum constant QVariant::Pen") +
    gsi::constant ("TextLength", &qt_gsi::c_45_QVariant_Type_Enum, "@brief Enum constant QVariant::TextLength") +
    gsi::constant ("TextFormat", &qt_gsi::c_46_QVariant_Type_Enum, "@brief Enum constant QVariant::TextFormat") +
    gsi::constant ("Matrix", &qt_gsi::c_47_QVariant_Type_Enum, "@brief Enum constant QVariant::Matrix") +
    gsi::constant ("Transform", &qt_gsi::c_48_QVariant_Type_Enum, "@brief Enum constant QVariant::Transform") +
    gsi::constant ("Matrix4x4", &qt_gsi::c_49_QVariant_Type_Enum, "@brief Enum constant QVariant::Matrix4x4") +
    gsi::constant ("Vector2D", &qt_gsi::c_50_QVariant_Type_Enum, "@brief Enum constant QVariant::Vector2D") +
    gsi::constant ("Vector3D", &qt_gsi::c_51_QVariant_Type_Enum, "@brief Enum constant QVariant::Vector3D") +
    gsi::constant ("Vector4D", &qt_gsi::c_52_QVariant_Type_Enum, "@brief Enum constant QVariant::Vector4D") +
    gsi::constant ("Quaternion", &qt_gsi::c_53_QVariant_Type_Enum, "@brief Enum constant QVariant::Quaternion") +
    gsi::constant ("LastGuiType", &qt_gsi::c_54_QVariant_Type_Enum, "@brief Enum constant QVariant::LastGuiType") +
    gsi::constant ("UserType", &qt_gsi::c_55_QVariant_Type_Enum, "@brief Enum constant QVariant::UserType") +
    gsi::constant ("LastType", &qt_gsi::c_56_QVariant_Type_Enum, "@brief Enum constant QVariant::LastType");
}

static std::string to_s_QVariant_Type_Enum (const QVariant_Type_Enum *e)
{
  if (e->value () == QVariant::Invalid) { return tl::sprintf ("Invalid (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Bool) { return tl::sprintf ("Bool (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Int) { return tl::sprintf ("Int (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::UInt) { return tl::sprintf ("UInt (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::LongLong) { return tl::sprintf ("LongLong (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::ULongLong) { return tl::sprintf ("ULongLong (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Double) { return tl::sprintf ("Double (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Char) { return tl::sprintf ("Char (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Map) { return tl::sprintf ("Map (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::List) { return tl::sprintf ("List (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::String) { return tl::sprintf ("String (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::StringList) { return tl::sprintf ("StringList (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::ByteArray) { return tl::sprintf ("ByteArray (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::BitArray) { return tl::sprintf ("BitArray (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Date) { return tl::sprintf ("Date (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Time) { return tl::sprintf ("Time (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::DateTime) { return tl::sprintf ("DateTime (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Url) { return tl::sprintf ("Url (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Locale) { return tl::sprintf ("Locale (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Rect) { return tl::sprintf ("Rect (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::RectF) { return tl::sprintf ("RectF (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Size) { return tl::sprintf ("Size (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::SizeF) { return tl::sprintf ("SizeF (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Line) { return tl::sprintf ("Line (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::LineF) { return tl::sprintf ("LineF (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Point) { return tl::sprintf ("Point (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::PointF) { return tl::sprintf ("PointF (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::RegExp) { return tl::sprintf ("RegExp (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Hash) { return tl::sprintf ("Hash (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::LastCoreType) { return tl::sprintf ("LastCoreType (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Font) { return tl::sprintf ("Font (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Pixmap) { return tl::sprintf ("Pixmap (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Brush) { return tl::sprintf ("Brush (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Color) { return tl::sprintf ("Color (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Palette) { return tl::sprintf ("Palette (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Icon) { return tl::sprintf ("Icon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Image) { return tl::sprintf ("Image (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Polygon) { return tl::sprintf ("Polygon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Region) { return tl::sprintf ("Region (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Bitmap) { return tl::sprintf ("Bitmap (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Cursor) { return tl::sprintf ("Cursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::SizePolicy) { return tl::sprintf ("SizePolicy (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::KeySequence) { return tl::sprintf ("KeySequence (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Pen) { return tl::sprintf ("Pen (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::TextLength) { return tl::sprintf ("TextLength (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::TextFormat) { return tl::sprintf ("TextFormat (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Matrix) { return tl::sprintf ("Matrix (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Transform) { return tl::sprintf ("Transform (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Matrix4x4) { return tl::sprintf ("Matrix4x4 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Vector2D) { return tl::sprintf ("Vector2D (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Vector3D) { return tl::sprintf ("Vector3D (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Vector4D) { return tl::sprintf ("Vector4D (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::Quaternion) { return tl::sprintf ("Quaternion (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::LastGuiType) { return tl::sprintf ("LastGuiType (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::UserType) { return tl::sprintf ("UserType (%u)", (unsigned int) e->value ()); }
  if (e->value () == QVariant::LastType) { return tl::sprintf ("LastType (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QVariant_Type_Enum (const QVariant_Type_Enum *e)
{
  return (unsigned int) e->value ();
}

static QVariant_Type_Enum *from_i_QVariant_Type_Enum (unsigned int i)
{
  return new QVariant_Type_Enum ((QVariant::Type) i);
}

static bool equalQVariant_Type_Enum (const QVariant_Type_Enum *e, QVariant_Type_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QVariant_Type_Enum (const QVariant_Type_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QVariant_Type_Enums oropQVariant_Type_Enums (const QVariant_Type_Enums *e, const QVariant_Type_Enums &d)
{
  return e->flags () | d.flags ();
}

static QVariant_Type_Enums andopQVariant_Type_Enums (const QVariant_Type_Enums *e, const QVariant_Type_Enums &d)
{
  return e->flags () & d.flags ();
}

static QVariant_Type_Enums xoropQVariant_Type_Enums (const QVariant_Type_Enums *e, const QVariant_Type_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QVariant_Type_Enums (const QVariant_Type_Enums *e)
{
  std::string l;
  if (e->testFlag (QVariant::Invalid)) { if (!l.empty ()) l += "|"; l += "Invalid"; }
  if (e->testFlag (QVariant::Bool)) { if (!l.empty ()) l += "|"; l += "Bool"; }
  if (e->testFlag (QVariant::Int)) { if (!l.empty ()) l += "|"; l += "Int"; }
  if (e->testFlag (QVariant::UInt)) { if (!l.empty ()) l += "|"; l += "UInt"; }
  if (e->testFlag (QVariant::LongLong)) { if (!l.empty ()) l += "|"; l += "LongLong"; }
  if (e->testFlag (QVariant::ULongLong)) { if (!l.empty ()) l += "|"; l += "ULongLong"; }
  if (e->testFlag (QVariant::Double)) { if (!l.empty ()) l += "|"; l += "Double"; }
  if (e->testFlag (QVariant::Char)) { if (!l.empty ()) l += "|"; l += "Char"; }
  if (e->testFlag (QVariant::Map)) { if (!l.empty ()) l += "|"; l += "Map"; }
  if (e->testFlag (QVariant::List)) { if (!l.empty ()) l += "|"; l += "List"; }
  if (e->testFlag (QVariant::String)) { if (!l.empty ()) l += "|"; l += "String"; }
  if (e->testFlag (QVariant::StringList)) { if (!l.empty ()) l += "|"; l += "StringList"; }
  if (e->testFlag (QVariant::ByteArray)) { if (!l.empty ()) l += "|"; l += "ByteArray"; }
  if (e->testFlag (QVariant::BitArray)) { if (!l.empty ()) l += "|"; l += "BitArray"; }
  if (e->testFlag (QVariant::Date)) { if (!l.empty ()) l += "|"; l += "Date"; }
  if (e->testFlag (QVariant::Time)) { if (!l.empty ()) l += "|"; l += "Time"; }
  if (e->testFlag (QVariant::DateTime)) { if (!l.empty ()) l += "|"; l += "DateTime"; }
  if (e->testFlag (QVariant::Url)) { if (!l.empty ()) l += "|"; l += "Url"; }
  if (e->testFlag (QVariant::Locale)) { if (!l.empty ()) l += "|"; l += "Locale"; }
  if (e->testFlag (QVariant::Rect)) { if (!l.empty ()) l += "|"; l += "Rect"; }
  if (e->testFlag (QVariant::RectF)) { if (!l.empty ()) l += "|"; l += "RectF"; }
  if (e->testFlag (QVariant::Size)) { if (!l.empty ()) l += "|"; l += "Size"; }
  if (e->testFlag (QVariant::SizeF)) { if (!l.empty ()) l += "|"; l += "SizeF"; }
  if (e->testFlag (QVariant::Line)) { if (!l.empty ()) l += "|"; l += "Line"; }
  if (e->testFlag (QVariant::LineF)) { if (!l.empty ()) l += "|"; l += "LineF"; }
  if (e->testFlag (QVariant::Point)) { if (!l.empty ()) l += "|"; l += "Point"; }
  if (e->testFlag (QVariant::PointF)) { if (!l.empty ()) l += "|"; l += "PointF"; }
  if (e->testFlag (QVariant::RegExp)) { if (!l.empty ()) l += "|"; l += "RegExp"; }
  if (e->testFlag (QVariant::Hash)) { if (!l.empty ()) l += "|"; l += "Hash"; }
  if (e->testFlag (QVariant::LastCoreType)) { if (!l.empty ()) l += "|"; l += "LastCoreType"; }
  if (e->testFlag (QVariant::Font)) { if (!l.empty ()) l += "|"; l += "Font"; }
  if (e->testFlag (QVariant::Pixmap)) { if (!l.empty ()) l += "|"; l += "Pixmap"; }
  if (e->testFlag (QVariant::Brush)) { if (!l.empty ()) l += "|"; l += "Brush"; }
  if (e->testFlag (QVariant::Color)) { if (!l.empty ()) l += "|"; l += "Color"; }
  if (e->testFlag (QVariant::Palette)) { if (!l.empty ()) l += "|"; l += "Palette"; }
  if (e->testFlag (QVariant::Icon)) { if (!l.empty ()) l += "|"; l += "Icon"; }
  if (e->testFlag (QVariant::Image)) { if (!l.empty ()) l += "|"; l += "Image"; }
  if (e->testFlag (QVariant::Polygon)) { if (!l.empty ()) l += "|"; l += "Polygon"; }
  if (e->testFlag (QVariant::Region)) { if (!l.empty ()) l += "|"; l += "Region"; }
  if (e->testFlag (QVariant::Bitmap)) { if (!l.empty ()) l += "|"; l += "Bitmap"; }
  if (e->testFlag (QVariant::Cursor)) { if (!l.empty ()) l += "|"; l += "Cursor"; }
  if (e->testFlag (QVariant::SizePolicy)) { if (!l.empty ()) l += "|"; l += "SizePolicy"; }
  if (e->testFlag (QVariant::KeySequence)) { if (!l.empty ()) l += "|"; l += "KeySequence"; }
  if (e->testFlag (QVariant::Pen)) { if (!l.empty ()) l += "|"; l += "Pen"; }
  if (e->testFlag (QVariant::TextLength)) { if (!l.empty ()) l += "|"; l += "TextLength"; }
  if (e->testFlag (QVariant::TextFormat)) { if (!l.empty ()) l += "|"; l += "TextFormat"; }
  if (e->testFlag (QVariant::Matrix)) { if (!l.empty ()) l += "|"; l += "Matrix"; }
  if (e->testFlag (QVariant::Transform)) { if (!l.empty ()) l += "|"; l += "Transform"; }
  if (e->testFlag (QVariant::Matrix4x4)) { if (!l.empty ()) l += "|"; l += "Matrix4x4"; }
  if (e->testFlag (QVariant::Vector2D)) { if (!l.empty ()) l += "|"; l += "Vector2D"; }
  if (e->testFlag (QVariant::Vector3D)) { if (!l.empty ()) l += "|"; l += "Vector3D"; }
  if (e->testFlag (QVariant::Vector4D)) { if (!l.empty ()) l += "|"; l += "Vector4D"; }
  if (e->testFlag (QVariant::Quaternion)) { if (!l.empty ()) l += "|"; l += "Quaternion"; }
  if (e->testFlag (QVariant::LastGuiType)) { if (!l.empty ()) l += "|"; l += "LastGuiType"; }
  if (e->testFlag (QVariant::UserType)) { if (!l.empty ()) l += "|"; l += "UserType"; }
  if (e->testFlag (QVariant::LastType)) { if (!l.empty ()) l += "|"; l += "LastType"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QVariant_Type_Enums (const QVariant_Type_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QVariant_Type_Enums (const QVariant_Type_Enums *e, const QVariant_Type_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QVariant_Type_Enums> decl_QVariant_Type_Enums ("QVariant_QFlags_Type",
  gsi::method_ext ("|", &qt_gsi::oropQVariant_Type_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQVariant_Type_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQVariant_Type_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QVariant_Type_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QVariant_Type_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QVariant_Type_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QVariant::Type> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QVariant_Type_Enum> decl_QVariant_Type_Enum (decl_QVariant_Type_Enums, "QVariant_Type",
  qt_gsi::mkdefs_QVariant_Type () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QVariant_Type_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QVariant_Type_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQVariant_Type_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QVariant_Type_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QVariant_Type_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QVariant::Type enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QVariant> inject_QVariant_Type_Enum_in_parent (qt_gsi::mkdefs_QVariant_Type ());
static gsi::ClassExt<QVariant> decl_QVariant_Type_Enum_as_child (decl_QVariant_Type_Enum, "Type");

}

