
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQVBoxLayout.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQVBoxLayout_EventAdaptor.h"
#include "gsiDeclQVBoxLayout_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QVBoxLayout

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QVBoxLayout::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// static QString QVBoxLayout::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QVBoxLayout::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QVBoxLayout::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QVBoxLayout::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QVBoxLayout::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QVBoxLayout::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QVBoxLayout::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QVBoxLayout::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QVBoxLayout::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QVBoxLayout::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QVBoxLayout::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QVBoxLayout::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QVBoxLayout, QVBoxLayout_EventAdaptor> ea_QVBoxLayout;

namespace gsi
{
extern gsi::Class<QBoxLayout> decl_QBoxLayout;

gsi::Class<QVBoxLayout> decl_QVBoxLayout (ea_QVBoxLayout, decl_QBoxLayout, "QVBoxLayout_Native",
  gsi::Methods(_create_smo ()) +
  qt_gsi::qt_signal<QVBoxLayout, QVBoxLayout_EventAdaptor, QObject *> ("destroyed", &QVBoxLayout_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QVBoxLayout::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QVBoxLayout");
}


class QVBoxLayout_Adaptor : public QVBoxLayout, public qt_gsi::QtObjectBase
{
public:

  virtual ~QVBoxLayout_Adaptor();

  //  [adaptor ctor] QVBoxLayout::QVBoxLayout()
  QVBoxLayout_Adaptor() : QVBoxLayout()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QVBoxLayout::QVBoxLayout(QWidget *parent)
  QVBoxLayout_Adaptor(QWidget *parent) : QVBoxLayout(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QVBoxLayout::addChildLayout(QLayout *l)
  void fp_QVBoxLayout_addChildLayout_1341 (QLayout *l) {
    QVBoxLayout::addChildLayout(l);
  }

  //  void QVBoxLayout::addChildWidget(QWidget *w)
  void fp_QVBoxLayout_addChildWidget_1315 (QWidget *w) {
    QVBoxLayout::addChildWidget(w);
  }

  //  QRect QVBoxLayout::alignmentRect(const QRect &)
  QRect fp_QVBoxLayout_alignmentRect_c1792 (const QRect &arg1) const {
    return QVBoxLayout::alignmentRect(arg1);
  }

  //  void QVBoxLayout::insertItem(int index, QLayoutItem *)
  void fp_QVBoxLayout_insertItem_2399 (int index, QLayoutItem *arg2) {
    QVBoxLayout::insertItem(index, arg2);
  }

  //  int QVBoxLayout::receivers(const char *signal)
  int fp_QVBoxLayout_receivers_c1731 (const char *signal) const {
    return QVBoxLayout::receivers(signal);
  }

  //  QObject *QVBoxLayout::sender()
  QObject * fp_QVBoxLayout_sender_c0 () const {
    return QVBoxLayout::sender();
  }

  //  void QVBoxLayout::widgetEvent(QEvent *)
  void fp_QVBoxLayout_widgetEvent_1217 (QEvent *arg1) {
    QVBoxLayout::widgetEvent(arg1);
  }

  //  [adaptor impl] void QVBoxLayout::addItem(QLayoutItem *)
  void cbs_addItem_1740_0(QLayoutItem *arg1)
  {
    QVBoxLayout::addItem(arg1);
  }

  virtual void addItem(QLayoutItem *arg1)
  {
    if (cb_addItem_1740_0.can_issue()) {
      cb_addItem_1740_0.issue<QVBoxLayout_Adaptor, QLayoutItem *>(&QVBoxLayout_Adaptor::cbs_addItem_1740_0, arg1);
    } else {
      QVBoxLayout::addItem(arg1);
    }
  }

  //  [adaptor impl] int QVBoxLayout::count()
  int cbs_count_c0_0() const
  {
    return QVBoxLayout::count();
  }

  virtual int count() const
  {
    if (cb_count_c0_0.can_issue()) {
      return cb_count_c0_0.issue<QVBoxLayout_Adaptor, int>(&QVBoxLayout_Adaptor::cbs_count_c0_0);
    } else {
      return QVBoxLayout::count();
    }
  }

  //  [adaptor impl] bool QVBoxLayout::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QVBoxLayout::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QVBoxLayout_Adaptor, bool, QEvent *>(&QVBoxLayout_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QVBoxLayout::event(arg1);
    }
  }

  //  [adaptor impl] bool QVBoxLayout::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QVBoxLayout::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QVBoxLayout_Adaptor, bool, QObject *, QEvent *>(&QVBoxLayout_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QVBoxLayout::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] QFlags<Qt::Orientation> QVBoxLayout::expandingDirections()
  qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type cbs_expandingDirections_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QFlags<Qt::Orientation> >(QVBoxLayout::expandingDirections());
  }

  virtual QFlags<Qt::Orientation> expandingDirections() const
  {
    if (cb_expandingDirections_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QFlags<Qt::Orientation> >(cb_expandingDirections_c0_0.issue<QVBoxLayout_Adaptor, qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type>(&QVBoxLayout_Adaptor::cbs_expandingDirections_c0_0)).cref();
    } else {
      return QVBoxLayout::expandingDirections();
    }
  }

  //  [adaptor impl] QRect QVBoxLayout::geometry()
  QRect cbs_geometry_c0_0() const
  {
    return QVBoxLayout::geometry();
  }

  virtual QRect geometry() const
  {
    if (cb_geometry_c0_0.can_issue()) {
      return cb_geometry_c0_0.issue<QVBoxLayout_Adaptor, QRect>(&QVBoxLayout_Adaptor::cbs_geometry_c0_0);
    } else {
      return QVBoxLayout::geometry();
    }
  }

  //  [adaptor impl] bool QVBoxLayout::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QVBoxLayout::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QVBoxLayout_Adaptor, bool>(&QVBoxLayout_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QVBoxLayout::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QVBoxLayout::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QVBoxLayout::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QVBoxLayout_Adaptor, int, int>(&QVBoxLayout_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QVBoxLayout::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] int QVBoxLayout::indexOf(QWidget *)
  int cbs_indexOf_c1315_0(QWidget *arg1) const
  {
    return QVBoxLayout::indexOf(arg1);
  }

  virtual int indexOf(QWidget *arg1) const
  {
    if (cb_indexOf_c1315_0.can_issue()) {
      return cb_indexOf_c1315_0.issue<QVBoxLayout_Adaptor, int, QWidget *>(&QVBoxLayout_Adaptor::cbs_indexOf_c1315_0, arg1);
    } else {
      return QVBoxLayout::indexOf(arg1);
    }
  }

  //  [adaptor impl] void QVBoxLayout::invalidate()
  void cbs_invalidate_0_0()
  {
    QVBoxLayout::invalidate();
  }

  virtual void invalidate()
  {
    if (cb_invalidate_0_0.can_issue()) {
      cb_invalidate_0_0.issue<QVBoxLayout_Adaptor>(&QVBoxLayout_Adaptor::cbs_invalidate_0_0);
    } else {
      QVBoxLayout::invalidate();
    }
  }

  //  [adaptor impl] bool QVBoxLayout::isEmpty()
  bool cbs_isEmpty_c0_0() const
  {
    return QVBoxLayout::isEmpty();
  }

  virtual bool isEmpty() const
  {
    if (cb_isEmpty_c0_0.can_issue()) {
      return cb_isEmpty_c0_0.issue<QVBoxLayout_Adaptor, bool>(&QVBoxLayout_Adaptor::cbs_isEmpty_c0_0);
    } else {
      return QVBoxLayout::isEmpty();
    }
  }

  //  [adaptor impl] QLayoutItem *QVBoxLayout::itemAt(int)
  QLayoutItem * cbs_itemAt_c767_0(int arg1) const
  {
    return QVBoxLayout::itemAt(arg1);
  }

  virtual QLayoutItem * itemAt(int arg1) const
  {
    if (cb_itemAt_c767_0.can_issue()) {
      return cb_itemAt_c767_0.issue<QVBoxLayout_Adaptor, QLayoutItem *, int>(&QVBoxLayout_Adaptor::cbs_itemAt_c767_0, arg1);
    } else {
      return QVBoxLayout::itemAt(arg1);
    }
  }

  //  [adaptor impl] QLayout *QVBoxLayout::layout()
  QLayout * cbs_layout_0_0()
  {
    return QVBoxLayout::layout();
  }

  virtual QLayout * layout()
  {
    if (cb_layout_0_0.can_issue()) {
      return cb_layout_0_0.issue<QVBoxLayout_Adaptor, QLayout *>(&QVBoxLayout_Adaptor::cbs_layout_0_0);
    } else {
      return QVBoxLayout::layout();
    }
  }

  //  [adaptor impl] QSize QVBoxLayout::maximumSize()
  QSize cbs_maximumSize_c0_0() const
  {
    return QVBoxLayout::maximumSize();
  }

  virtual QSize maximumSize() const
  {
    if (cb_maximumSize_c0_0.can_issue()) {
      return cb_maximumSize_c0_0.issue<QVBoxLayout_Adaptor, QSize>(&QVBoxLayout_Adaptor::cbs_maximumSize_c0_0);
    } else {
      return QVBoxLayout::maximumSize();
    }
  }

  //  [adaptor impl] int QVBoxLayout::minimumHeightForWidth(int)
  int cbs_minimumHeightForWidth_c767_0(int arg1) const
  {
    return QVBoxLayout::minimumHeightForWidth(arg1);
  }

  virtual int minimumHeightForWidth(int arg1) const
  {
    if (cb_minimumHeightForWidth_c767_0.can_issue()) {
      return cb_minimumHeightForWidth_c767_0.issue<QVBoxLayout_Adaptor, int, int>(&QVBoxLayout_Adaptor::cbs_minimumHeightForWidth_c767_0, arg1);
    } else {
      return QVBoxLayout::minimumHeightForWidth(arg1);
    }
  }

  //  [adaptor impl] QSize QVBoxLayout::minimumSize()
  QSize cbs_minimumSize_c0_0() const
  {
    return QVBoxLayout::minimumSize();
  }

  virtual QSize minimumSize() const
  {
    if (cb_minimumSize_c0_0.can_issue()) {
      return cb_minimumSize_c0_0.issue<QVBoxLayout_Adaptor, QSize>(&QVBoxLayout_Adaptor::cbs_minimumSize_c0_0);
    } else {
      return QVBoxLayout::minimumSize();
    }
  }

  //  [adaptor impl] void QVBoxLayout::setGeometry(const QRect &)
  void cbs_setGeometry_1792_0(const QRect &arg1)
  {
    QVBoxLayout::setGeometry(arg1);
  }

  virtual void setGeometry(const QRect &arg1)
  {
    if (cb_setGeometry_1792_0.can_issue()) {
      cb_setGeometry_1792_0.issue<QVBoxLayout_Adaptor, const QRect &>(&QVBoxLayout_Adaptor::cbs_setGeometry_1792_0, arg1);
    } else {
      QVBoxLayout::setGeometry(arg1);
    }
  }

  //  [adaptor impl] QSize QVBoxLayout::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QVBoxLayout::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QVBoxLayout_Adaptor, QSize>(&QVBoxLayout_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QVBoxLayout::sizeHint();
    }
  }

  //  [adaptor impl] QSpacerItem *QVBoxLayout::spacerItem()
  QSpacerItem * cbs_spacerItem_0_0()
  {
    return QVBoxLayout::spacerItem();
  }

  virtual QSpacerItem * spacerItem()
  {
    if (cb_spacerItem_0_0.can_issue()) {
      return cb_spacerItem_0_0.issue<QVBoxLayout_Adaptor, QSpacerItem *>(&QVBoxLayout_Adaptor::cbs_spacerItem_0_0);
    } else {
      return QVBoxLayout::spacerItem();
    }
  }

  //  [adaptor impl] QLayoutItem *QVBoxLayout::takeAt(int)
  QLayoutItem * cbs_takeAt_767_0(int arg1)
  {
    return QVBoxLayout::takeAt(arg1);
  }

  virtual QLayoutItem * takeAt(int arg1)
  {
    if (cb_takeAt_767_0.can_issue()) {
      return cb_takeAt_767_0.issue<QVBoxLayout_Adaptor, QLayoutItem *, int>(&QVBoxLayout_Adaptor::cbs_takeAt_767_0, arg1);
    } else {
      return QVBoxLayout::takeAt(arg1);
    }
  }

  //  [adaptor impl] QWidget *QVBoxLayout::widget()
  QWidget * cbs_widget_0_0()
  {
    return QVBoxLayout::widget();
  }

  virtual QWidget * widget()
  {
    if (cb_widget_0_0.can_issue()) {
      return cb_widget_0_0.issue<QVBoxLayout_Adaptor, QWidget *>(&QVBoxLayout_Adaptor::cbs_widget_0_0);
    } else {
      return QVBoxLayout::widget();
    }
  }

  //  [adaptor impl] void QVBoxLayout::childEvent(QChildEvent *e)
  void cbs_childEvent_1701_0(QChildEvent *e)
  {
    QVBoxLayout::childEvent(e);
  }

  virtual void childEvent(QChildEvent *e)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QVBoxLayout_Adaptor, QChildEvent *>(&QVBoxLayout_Adaptor::cbs_childEvent_1701_0, e);
    } else {
      QVBoxLayout::childEvent(e);
    }
  }

  //  [adaptor impl] void QVBoxLayout::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QVBoxLayout::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QVBoxLayout_Adaptor, QEvent *>(&QVBoxLayout_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QVBoxLayout::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QVBoxLayout::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QVBoxLayout::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QVBoxLayout_Adaptor, const char *>(&QVBoxLayout_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QVBoxLayout::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QVBoxLayout::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QVBoxLayout::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QVBoxLayout_Adaptor, QTimerEvent *>(&QVBoxLayout_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QVBoxLayout::timerEvent(arg1);
    }
  }

  gsi::Callback cb_addItem_1740_0;
  gsi::Callback cb_count_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_expandingDirections_c0_0;
  gsi::Callback cb_geometry_c0_0;
  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_indexOf_c1315_0;
  gsi::Callback cb_invalidate_0_0;
  gsi::Callback cb_isEmpty_c0_0;
  gsi::Callback cb_itemAt_c767_0;
  gsi::Callback cb_layout_0_0;
  gsi::Callback cb_maximumSize_c0_0;
  gsi::Callback cb_minimumHeightForWidth_c767_0;
  gsi::Callback cb_minimumSize_c0_0;
  gsi::Callback cb_setGeometry_1792_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_spacerItem_0_0;
  gsi::Callback cb_takeAt_767_0;
  gsi::Callback cb_widget_0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QVBoxLayout_Adaptor::~QVBoxLayout_Adaptor() { }

//  Constructor QVBoxLayout::QVBoxLayout() (adaptor class)

static void _init_ctor_QVBoxLayout_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QVBoxLayout_Adaptor *> ();
}

static void _call_ctor_QVBoxLayout_Adaptor_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QVBoxLayout_Adaptor *> (new QVBoxLayout_Adaptor ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVBoxLayout_Adaptor_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVBoxLayout::QVBoxLayout()\nThis method creates an object of class QVBoxLayout.", &_init_ctor_QVBoxLayout_Adaptor_0, &_call_ctor_QVBoxLayout_Adaptor_0);
}

//  Constructor QVBoxLayout::QVBoxLayout(QWidget *parent) (adaptor class)

static void _init_ctor_QVBoxLayout_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QVBoxLayout_Adaptor *> ();
}

static void _call_ctor_QVBoxLayout_Adaptor_1315 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ret.write<QVBoxLayout_Adaptor *> (new QVBoxLayout_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVBoxLayout_Adaptor_1315 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVBoxLayout::QVBoxLayout(QWidget *parent)\nThis method creates an object of class QVBoxLayout.", &_init_ctor_QVBoxLayout_Adaptor_1315, &_call_ctor_QVBoxLayout_Adaptor_1315);
}

// void QVBoxLayout::addChildLayout(QLayout *l)

static void _init_fp_addChildLayout_1341 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("l");
  decl->add_arg<QLayout * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addChildLayout_1341 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLayout *arg1 = args.read<QLayout * > ();
  qt_gsi::qt_keep (arg1);
  ((QVBoxLayout_Adaptor *)cls)->fp_QVBoxLayout_addChildLayout_1341 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_addChildLayout_1341 ()
{
  return new qt_gsi::GenericMethod("*addChildLayout", "@brief Method void QVBoxLayout::addChildLayout(QLayout *l)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addChildLayout_1341, &_call_fp_addChildLayout_1341);
}


// void QVBoxLayout::addChildWidget(QWidget *w)

static void _init_fp_addChildWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addChildWidget_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QVBoxLayout_Adaptor *)cls)->fp_QVBoxLayout_addChildWidget_1315 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_addChildWidget_1315 ()
{
  return new qt_gsi::GenericMethod("*addChildWidget", "@brief Method void QVBoxLayout::addChildWidget(QWidget *w)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addChildWidget_1315, &_call_fp_addChildWidget_1315);
}


// QRect QVBoxLayout::alignmentRect(const QRect &)

static void _init_fp_alignmentRect_c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_fp_alignmentRect_c1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ret.write<QRect > ((QRect)((QVBoxLayout_Adaptor *)cls)->fp_QVBoxLayout_alignmentRect_c1792 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_alignmentRect_c1792 ()
{
  return new qt_gsi::GenericMethod("*alignmentRect", "@brief Method QRect QVBoxLayout::alignmentRect(const QRect &)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_alignmentRect_c1792, &_call_fp_alignmentRect_c1792);
}


// void QVBoxLayout::insertItem(int index, QLayoutItem *)

static void _init_fp_insertItem_2399 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QLayoutItem * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_insertItem_2399 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QLayoutItem *arg2 = args.read<QLayoutItem * > ();
  ((QVBoxLayout_Adaptor *)cls)->fp_QVBoxLayout_insertItem_2399 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_insertItem_2399 ()
{
  return new qt_gsi::GenericMethod("*insertItem", "@brief Method void QVBoxLayout::insertItem(int index, QLayoutItem *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_insertItem_2399, &_call_fp_insertItem_2399);
}


// int QVBoxLayout::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QVBoxLayout_Adaptor *)cls)->fp_QVBoxLayout_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QVBoxLayout::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QVBoxLayout::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QVBoxLayout_Adaptor *)cls)->fp_QVBoxLayout_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QVBoxLayout::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QVBoxLayout::widgetEvent(QEvent *)

static void _init_fp_widgetEvent_1217 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_widgetEvent_1217 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QVBoxLayout_Adaptor *)cls)->fp_QVBoxLayout_widgetEvent_1217 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_widgetEvent_1217 ()
{
  return new qt_gsi::GenericMethod("*widgetEvent", "@brief Method void QVBoxLayout::widgetEvent(QEvent *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_widgetEvent_1217, &_call_fp_widgetEvent_1217);
}


// void QVBoxLayout::addItem(QLayoutItem *)

static void _init_cbs_addItem_1740_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QLayoutItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_addItem_1740_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLayoutItem *arg1 = args.read<QLayoutItem * > ();
  ((QVBoxLayout_Adaptor *)cls)->cbs_addItem_1740_0 (arg1);
}

static void _set_callback_cbs_addItem_1740_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_addItem_1740_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_addItem_1740_0 ()
{
  return new qt_gsi::GenericMethod ("addItem", "@hide", false, &_init_cbs_addItem_1740_0, &_call_cbs_addItem_1740_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_addItem_1740_0 ()
{
  return new qt_gsi::GenericMethod ("addItem", "@brief Virtual method void QVBoxLayout::addItem(QLayoutItem *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_addItem_1740_0, &_call_cbs_addItem_1740_0, &_set_callback_cbs_addItem_1740_0);
}


// int QVBoxLayout::count()

static void _init_cbs_count_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_count_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QVBoxLayout_Adaptor *)cls)->cbs_count_c0_0 ());
}

static void _set_callback_cbs_count_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_count_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_count_c0_0 ()
{
  return new qt_gsi::GenericMethod ("count", "@hide", true, &_init_cbs_count_c0_0, &_call_cbs_count_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_count_c0_0 ()
{
  return new qt_gsi::GenericMethod ("count", "@brief Virtual method int QVBoxLayout::count()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_count_c0_0, &_call_cbs_count_c0_0, &_set_callback_cbs_count_c0_0);
}


// bool QVBoxLayout::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QVBoxLayout_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QVBoxLayout::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QVBoxLayout::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QVBoxLayout_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QVBoxLayout::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// QFlags<Qt::Orientation> QVBoxLayout::expandingDirections()

static void _init_cbs_expandingDirections_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type > ();
}

static void _call_cbs_expandingDirections_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type > ((qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type)((QVBoxLayout_Adaptor *)cls)->cbs_expandingDirections_c0_0 ());
}

static void _set_callback_cbs_expandingDirections_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_expandingDirections_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_expandingDirections_c0_0 ()
{
  return new qt_gsi::GenericMethod ("expandingDirections", "@hide", true, &_init_cbs_expandingDirections_c0_0, &_call_cbs_expandingDirections_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_expandingDirections_c0_0 ()
{
  return new qt_gsi::GenericMethod ("expandingDirections", "@brief Virtual method QFlags<Qt::Orientation> QVBoxLayout::expandingDirections()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_expandingDirections_c0_0, &_call_cbs_expandingDirections_c0_0, &_set_callback_cbs_expandingDirections_c0_0);
}


// QRect QVBoxLayout::geometry()

static void _init_cbs_geometry_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_cbs_geometry_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QVBoxLayout_Adaptor *)cls)->cbs_geometry_c0_0 ());
}

static void _set_callback_cbs_geometry_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_geometry_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_geometry_c0_0 ()
{
  return new qt_gsi::GenericMethod ("geometry", "@hide", true, &_init_cbs_geometry_c0_0, &_call_cbs_geometry_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_geometry_c0_0 ()
{
  return new qt_gsi::GenericMethod ("geometry", "@brief Virtual method QRect QVBoxLayout::geometry()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_geometry_c0_0, &_call_cbs_geometry_c0_0, &_set_callback_cbs_geometry_c0_0);
}


// bool QVBoxLayout::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QVBoxLayout_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hasHeightForWidth_c0_0 ()
{
  return new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hasHeightForWidth_c0_0 ()
{
  return new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QVBoxLayout::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
}


// int QVBoxLayout::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QVBoxLayout_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QVBoxLayout::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// int QVBoxLayout::indexOf(QWidget *)

static void _init_cbs_indexOf_c1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_indexOf_c1315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ret.write<int > ((int)((QVBoxLayout_Adaptor *)cls)->cbs_indexOf_c1315_0 (arg1));
}

static void _set_callback_cbs_indexOf_c1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_indexOf_c1315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_indexOf_c1315_0 ()
{
  return new qt_gsi::GenericMethod ("indexOf", "@hide", true, &_init_cbs_indexOf_c1315_0, &_call_cbs_indexOf_c1315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_indexOf_c1315_0 ()
{
  return new qt_gsi::GenericMethod ("indexOf", "@brief Virtual method int QVBoxLayout::indexOf(QWidget *)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_indexOf_c1315_0, &_call_cbs_indexOf_c1315_0, &_set_callback_cbs_indexOf_c1315_0);
}


// void QVBoxLayout::invalidate()

static void _init_cbs_invalidate_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_invalidate_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QVBoxLayout_Adaptor *)cls)->cbs_invalidate_0_0 ();
}

static void _set_callback_cbs_invalidate_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_invalidate_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_invalidate_0_0 ()
{
  return new qt_gsi::GenericMethod ("invalidate", "@hide", false, &_init_cbs_invalidate_0_0, &_call_cbs_invalidate_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_invalidate_0_0 ()
{
  return new qt_gsi::GenericMethod ("invalidate", "@brief Virtual method void QVBoxLayout::invalidate()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_invalidate_0_0, &_call_cbs_invalidate_0_0, &_set_callback_cbs_invalidate_0_0);
}


// bool QVBoxLayout::isEmpty()

static void _init_cbs_isEmpty_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isEmpty_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QVBoxLayout_Adaptor *)cls)->cbs_isEmpty_c0_0 ());
}

static void _set_callback_cbs_isEmpty_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_isEmpty_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_isEmpty_c0_0 ()
{
  return new qt_gsi::GenericMethod ("isEmpty", "@hide", true, &_init_cbs_isEmpty_c0_0, &_call_cbs_isEmpty_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_isEmpty_c0_0 ()
{
  return new qt_gsi::GenericMethod ("isEmpty", "@brief Virtual method bool QVBoxLayout::isEmpty()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isEmpty_c0_0, &_call_cbs_isEmpty_c0_0, &_set_callback_cbs_isEmpty_c0_0);
}


// QLayoutItem *QVBoxLayout::itemAt(int)

static void _init_cbs_itemAt_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_cbs_itemAt_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QLayoutItem * > ((QLayoutItem *)((QVBoxLayout_Adaptor *)cls)->cbs_itemAt_c767_0 (arg1));
}

static void _set_callback_cbs_itemAt_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_itemAt_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_itemAt_c767_0 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@hide", true, &_init_cbs_itemAt_c767_0, &_call_cbs_itemAt_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_itemAt_c767_0 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@brief Virtual method QLayoutItem *QVBoxLayout::itemAt(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemAt_c767_0, &_call_cbs_itemAt_c767_0, &_set_callback_cbs_itemAt_c767_0);
}


// QLayout *QVBoxLayout::layout()

static void _init_cbs_layout_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLayout * > ();
}

static void _call_cbs_layout_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QLayout * > ((QLayout *)((QVBoxLayout_Adaptor *)cls)->cbs_layout_0_0 ());
}

static void _set_callback_cbs_layout_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_layout_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_layout_0_0 ()
{
  return new qt_gsi::GenericMethod ("layout", "@hide", false, &_init_cbs_layout_0_0, &_call_cbs_layout_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_layout_0_0 ()
{
  return new qt_gsi::GenericMethod ("layout", "@brief Virtual method QLayout *QVBoxLayout::layout()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_layout_0_0, &_call_cbs_layout_0_0, &_set_callback_cbs_layout_0_0);
}


// QSize QVBoxLayout::maximumSize()

static void _init_cbs_maximumSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_maximumSize_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QVBoxLayout_Adaptor *)cls)->cbs_maximumSize_c0_0 ());
}

static void _set_callback_cbs_maximumSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_maximumSize_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_maximumSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("maximumSize", "@hide", true, &_init_cbs_maximumSize_c0_0, &_call_cbs_maximumSize_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_maximumSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("maximumSize", "@brief Virtual method QSize QVBoxLayout::maximumSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_maximumSize_c0_0, &_call_cbs_maximumSize_c0_0, &_set_callback_cbs_maximumSize_c0_0);
}


// int QVBoxLayout::minimumHeightForWidth(int)

static void _init_cbs_minimumHeightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_minimumHeightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QVBoxLayout_Adaptor *)cls)->cbs_minimumHeightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_minimumHeightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_minimumHeightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumHeightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("minimumHeightForWidth", "@hide", true, &_init_cbs_minimumHeightForWidth_c767_0, &_call_cbs_minimumHeightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumHeightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("minimumHeightForWidth", "@brief Virtual method int QVBoxLayout::minimumHeightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumHeightForWidth_c767_0, &_call_cbs_minimumHeightForWidth_c767_0, &_set_callback_cbs_minimumHeightForWidth_c767_0);
}


// QSize QVBoxLayout::minimumSize()

static void _init_cbs_minimumSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSize_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QVBoxLayout_Adaptor *)cls)->cbs_minimumSize_c0_0 ());
}

static void _set_callback_cbs_minimumSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_minimumSize_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSize", "@hide", true, &_init_cbs_minimumSize_c0_0, &_call_cbs_minimumSize_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSize", "@brief Virtual method QSize QVBoxLayout::minimumSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSize_c0_0, &_call_cbs_minimumSize_c0_0, &_set_callback_cbs_minimumSize_c0_0);
}


// void QVBoxLayout::setGeometry(const QRect &)

static void _init_cbs_setGeometry_1792_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setGeometry_1792_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ((QVBoxLayout_Adaptor *)cls)->cbs_setGeometry_1792_0 (arg1);
}

static void _set_callback_cbs_setGeometry_1792_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_setGeometry_1792_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setGeometry_1792_0 ()
{
  return new qt_gsi::GenericMethod ("setGeometry", "@hide", false, &_init_cbs_setGeometry_1792_0, &_call_cbs_setGeometry_1792_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setGeometry_1792_0 ()
{
  return new qt_gsi::GenericMethod ("setGeometry", "@brief Virtual method void QVBoxLayout::setGeometry(const QRect &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setGeometry_1792_0, &_call_cbs_setGeometry_1792_0, &_set_callback_cbs_setGeometry_1792_0);
}


// QSize QVBoxLayout::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QVBoxLayout_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QVBoxLayout::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// QSpacerItem *QVBoxLayout::spacerItem()

static void _init_cbs_spacerItem_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSpacerItem * > ();
}

static void _call_cbs_spacerItem_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSpacerItem * > ((QSpacerItem *)((QVBoxLayout_Adaptor *)cls)->cbs_spacerItem_0_0 ());
}

static void _set_callback_cbs_spacerItem_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_spacerItem_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_spacerItem_0_0 ()
{
  return new qt_gsi::GenericMethod ("spacerItem", "@hide", false, &_init_cbs_spacerItem_0_0, &_call_cbs_spacerItem_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_spacerItem_0_0 ()
{
  return new qt_gsi::GenericMethod ("spacerItem", "@brief Virtual method QSpacerItem *QVBoxLayout::spacerItem()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_spacerItem_0_0, &_call_cbs_spacerItem_0_0, &_set_callback_cbs_spacerItem_0_0);
}


// QLayoutItem *QVBoxLayout::takeAt(int)

static void _init_cbs_takeAt_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_cbs_takeAt_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QLayoutItem * > ((QLayoutItem *)((QVBoxLayout_Adaptor *)cls)->cbs_takeAt_767_0 (arg1));
}

static void _set_callback_cbs_takeAt_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_takeAt_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_takeAt_767_0 ()
{
  return new qt_gsi::GenericMethod ("takeAt", "@hide", false, &_init_cbs_takeAt_767_0, &_call_cbs_takeAt_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_takeAt_767_0 ()
{
  return new qt_gsi::GenericMethod ("takeAt", "@brief Virtual method QLayoutItem *QVBoxLayout::takeAt(int)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_takeAt_767_0, &_call_cbs_takeAt_767_0, &_set_callback_cbs_takeAt_767_0);
}


// QWidget *QVBoxLayout::widget()

static void _init_cbs_widget_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_cbs_widget_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)((QVBoxLayout_Adaptor *)cls)->cbs_widget_0_0 ());
}

static void _set_callback_cbs_widget_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_widget_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_widget_0_0 ()
{
  return new qt_gsi::GenericMethod ("widget", "@hide", false, &_init_cbs_widget_0_0, &_call_cbs_widget_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_widget_0_0 ()
{
  return new qt_gsi::GenericMethod ("widget", "@brief Virtual method QWidget *QVBoxLayout::widget()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_widget_0_0, &_call_cbs_widget_0_0, &_set_callback_cbs_widget_0_0);
}


// void QVBoxLayout::childEvent(QChildEvent *e)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QVBoxLayout_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QVBoxLayout::childEvent(QChildEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QVBoxLayout::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QVBoxLayout_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QVBoxLayout::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QVBoxLayout::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QVBoxLayout_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QVBoxLayout::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QVBoxLayout::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QVBoxLayout_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QVBoxLayout_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QVBoxLayout::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QVBoxLayout> decl_QVBoxLayout;

gsi::Class<QVBoxLayout_Adaptor> decl_QVBoxLayout_Adaptor (decl_QVBoxLayout, "QVBoxLayout",
  gsi::Methods(_create_fp_addChildLayout_1341 ()) +
  gsi::Methods(_create_fp_addChildWidget_1315 ()) +
  gsi::Methods(_create_fp_alignmentRect_c1792 ()) +
  gsi::Methods(_create_fp_insertItem_2399 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_widgetEvent_1217 ()) +
  gsi::Methods(_create_cbs_addItem_1740_0 ()) +
  gsi::Methods(_create_callback_cbs_addItem_1740_0 ()) +
  gsi::Methods(_create_cbs_count_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_count_c0_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_expandingDirections_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_expandingDirections_c0_0 ()) +
  gsi::Methods(_create_cbs_geometry_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_geometry_c0_0 ()) +
  gsi::Methods(_create_cbs_hasHeightForWidth_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_hasHeightForWidth_c0_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_indexOf_c1315_0 ()) +
  gsi::Methods(_create_callback_cbs_indexOf_c1315_0 ()) +
  gsi::Methods(_create_cbs_invalidate_0_0 ()) +
  gsi::Methods(_create_callback_cbs_invalidate_0_0 ()) +
  gsi::Methods(_create_cbs_isEmpty_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_isEmpty_c0_0 ()) +
  gsi::Methods(_create_cbs_itemAt_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_itemAt_c767_0 ()) +
  gsi::Methods(_create_cbs_layout_0_0 ()) +
  gsi::Methods(_create_callback_cbs_layout_0_0 ()) +
  gsi::Methods(_create_cbs_maximumSize_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_maximumSize_c0_0 ()) +
  gsi::Methods(_create_cbs_minimumHeightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumHeightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_minimumSize_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSize_c0_0 ()) +
  gsi::Methods(_create_cbs_setGeometry_1792_0 ()) +
  gsi::Methods(_create_callback_cbs_setGeometry_1792_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_spacerItem_0_0 ()) +
  gsi::Methods(_create_callback_cbs_spacerItem_0_0 ()) +
  gsi::Methods(_create_cbs_takeAt_767_0 ()) +
  gsi::Methods(_create_callback_cbs_takeAt_767_0 ()) +
  gsi::Methods(_create_cbs_widget_0_0 ()) +
  gsi::Methods(_create_callback_cbs_widget_0_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QVBoxLayout_Adaptor_0 ()) +
  gsi::Methods(_create_ctor_QVBoxLayout_Adaptor_1315 ()),
  "@qt\n@brief Binding of QVBoxLayout");

}

