
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQUrl.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQUrl_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QUrl

//  Constructor QUrl::QUrl()


static void _init_ctor_QUrl_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QUrl *> ();
}

static void _call_ctor_QUrl_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QUrl *> (new QUrl ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QUrl_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QUrl::QUrl()\nThis method creates an object of class QUrl.", &_init_ctor_QUrl_0, &_call_ctor_QUrl_0);
}

//  Constructor QUrl::QUrl(const QString &url)


static void _init_ctor_QUrl_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return_new<QUrl *> ();
}

static void _call_ctor_QUrl_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QUrl *> (new QUrl (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QUrl_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QUrl::QUrl(const QString &url)\nThis method creates an object of class QUrl.", &_init_ctor_QUrl_2025, &_call_ctor_QUrl_2025);
}

//  Constructor QUrl::QUrl(const QString &url, QUrl::ParsingMode mode)


static void _init_ctor_QUrl_3970 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (argspec_1);
  decl->set_return_new<QUrl *> ();
}

static void _call_ctor_QUrl_3970 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const qt_gsi::Converter<QUrl::ParsingMode>::target_type & arg2 = args.read<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > ();
  ret.write<QUrl *> (new QUrl (arg1, qt_gsi::QtToCppAdaptor<QUrl::ParsingMode>(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QUrl_3970 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QUrl::QUrl(const QString &url, QUrl::ParsingMode mode)\nThis method creates an object of class QUrl.", &_init_ctor_QUrl_3970, &_call_ctor_QUrl_3970);
}

//  Constructor QUrl::QUrl(const QUrl &copy)


static void _init_ctor_QUrl_1701 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("copy");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return_new<QUrl *> ();
}

static void _call_ctor_QUrl_1701 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QUrl &arg1 = args.read<const QUrl & > ();
  ret.write<QUrl *> (new QUrl (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QUrl_1701 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QUrl::QUrl(const QUrl &copy)\nThis method creates an object of class QUrl.", &_init_ctor_QUrl_1701, &_call_ctor_QUrl_1701);
}

// void QUrl::addEncodedQueryItem(const QByteArray &key, const QByteArray &value)


static void _init_f_addEncodedQueryItem_4510 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QByteArray & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addEncodedQueryItem_4510 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  const QByteArray &arg2 = args.read<const QByteArray & > ();
  ((QUrl *)cls)->addEncodedQueryItem (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_addEncodedQueryItem_4510 ()
{
  return new qt_gsi::GenericMethod ("addEncodedQueryItem", "@brief Method void QUrl::addEncodedQueryItem(const QByteArray &key, const QByteArray &value)\n", false, &_init_f_addEncodedQueryItem_4510, &_call_f_addEncodedQueryItem_4510);
}

// void QUrl::addQueryItem(const QString &key, const QString &value)


static void _init_f_addQueryItem_3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addQueryItem_3942 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  ((QUrl *)cls)->addQueryItem (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_addQueryItem_3942 ()
{
  return new qt_gsi::GenericMethod ("addQueryItem", "@brief Method void QUrl::addQueryItem(const QString &key, const QString &value)\n", false, &_init_f_addQueryItem_3942, &_call_f_addQueryItem_3942);
}

// QList<QByteArray> QUrl::allEncodedQueryItemValues(const QByteArray &key)


static void _init_f_allEncodedQueryItemValues_c2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QList<QByteArray> >::target_type > ();
}

static void _call_f_allEncodedQueryItemValues_c2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ret.write<qt_gsi::Converter<QList<QByteArray> >::target_type > ((qt_gsi::Converter<QList<QByteArray> >::target_type)qt_gsi::CppToQtAdaptor<QList<QByteArray> >(((QUrl *)cls)->allEncodedQueryItemValues (arg1)));
}

static qt_gsi::GenericMethod *_create_f_allEncodedQueryItemValues_c2309 ()
{
  return new qt_gsi::GenericMethod ("allEncodedQueryItemValues", "@brief Method QList<QByteArray> QUrl::allEncodedQueryItemValues(const QByteArray &key)\n", true, &_init_f_allEncodedQueryItemValues_c2309, &_call_f_allEncodedQueryItemValues_c2309);
}

// QStringList QUrl::allQueryItemValues(const QString &key)


static void _init_f_allQueryItemValues_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_allQueryItemValues_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QUrl *)cls)->allQueryItemValues (arg1)));
}

static qt_gsi::GenericMethod *_create_f_allQueryItemValues_c2025 ()
{
  return new qt_gsi::GenericMethod ("allQueryItemValues", "@brief Method QStringList QUrl::allQueryItemValues(const QString &key)\n", true, &_init_f_allQueryItemValues_c2025, &_call_f_allQueryItemValues_c2025);
}

// QString QUrl::authority()


static void _init_f_authority_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_authority_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QUrl *)cls)->authority ());
}

static qt_gsi::GenericMethod *_create_f_authority_c0 ()
{
  return new qt_gsi::GenericMethod (":authority", "@brief Method QString QUrl::authority()\n", true, &_init_f_authority_c0, &_call_f_authority_c0);
}

// void QUrl::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QUrl *)cls)->clear ();
}

static qt_gsi::GenericMethod *_create_f_clear_0 ()
{
  return new qt_gsi::GenericMethod ("clear", "@brief Method void QUrl::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
}

// void QUrl::detach()


static void _init_f_detach_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_detach_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QUrl *)cls)->detach ();
}

static qt_gsi::GenericMethod *_create_f_detach_0 ()
{
  return new qt_gsi::GenericMethod ("detach", "@brief Method void QUrl::detach()\n", false, &_init_f_detach_0, &_call_f_detach_0);
}

// QByteArray QUrl::encodedFragment()


static void _init_f_encodedFragment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_encodedFragment_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray > ((QByteArray)((QUrl *)cls)->encodedFragment ());
}

static qt_gsi::GenericMethod *_create_f_encodedFragment_c0 ()
{
  return new qt_gsi::GenericMethod (":encodedFragment", "@brief Method QByteArray QUrl::encodedFragment()\n", true, &_init_f_encodedFragment_c0, &_call_f_encodedFragment_c0);
}

// QByteArray QUrl::encodedHost()


static void _init_f_encodedHost_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_encodedHost_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray > ((QByteArray)((QUrl *)cls)->encodedHost ());
}

static qt_gsi::GenericMethod *_create_f_encodedHost_c0 ()
{
  return new qt_gsi::GenericMethod (":encodedHost", "@brief Method QByteArray QUrl::encodedHost()\n", true, &_init_f_encodedHost_c0, &_call_f_encodedHost_c0);
}

// QByteArray QUrl::encodedPassword()


static void _init_f_encodedPassword_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_encodedPassword_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray > ((QByteArray)((QUrl *)cls)->encodedPassword ());
}

static qt_gsi::GenericMethod *_create_f_encodedPassword_c0 ()
{
  return new qt_gsi::GenericMethod (":encodedPassword", "@brief Method QByteArray QUrl::encodedPassword()\n", true, &_init_f_encodedPassword_c0, &_call_f_encodedPassword_c0);
}

// QByteArray QUrl::encodedPath()


static void _init_f_encodedPath_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_encodedPath_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray > ((QByteArray)((QUrl *)cls)->encodedPath ());
}

static qt_gsi::GenericMethod *_create_f_encodedPath_c0 ()
{
  return new qt_gsi::GenericMethod (":encodedPath", "@brief Method QByteArray QUrl::encodedPath()\n", true, &_init_f_encodedPath_c0, &_call_f_encodedPath_c0);
}

// QByteArray QUrl::encodedQuery()


static void _init_f_encodedQuery_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_encodedQuery_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray > ((QByteArray)((QUrl *)cls)->encodedQuery ());
}

static qt_gsi::GenericMethod *_create_f_encodedQuery_c0 ()
{
  return new qt_gsi::GenericMethod (":encodedQuery", "@brief Method QByteArray QUrl::encodedQuery()\n", true, &_init_f_encodedQuery_c0, &_call_f_encodedQuery_c0);
}

// QByteArray QUrl::encodedQueryItemValue(const QByteArray &key)


static void _init_f_encodedQueryItemValue_c2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_encodedQueryItemValue_c2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ret.write<QByteArray > ((QByteArray)((QUrl *)cls)->encodedQueryItemValue (arg1));
}

static qt_gsi::GenericMethod *_create_f_encodedQueryItemValue_c2309 ()
{
  return new qt_gsi::GenericMethod ("encodedQueryItemValue", "@brief Method QByteArray QUrl::encodedQueryItemValue(const QByteArray &key)\n", true, &_init_f_encodedQueryItemValue_c2309, &_call_f_encodedQueryItemValue_c2309);
}

// QList<QPair<QByteArray, QByteArray> > QUrl::encodedQueryItems()


static void _init_f_encodedQueryItems_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QPair<QByteArray, QByteArray> > >::target_type > ();
}

static void _call_f_encodedQueryItems_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QPair<QByteArray, QByteArray> > >::target_type > ((qt_gsi::Converter<QList<QPair<QByteArray, QByteArray> > >::target_type)qt_gsi::CppToQtAdaptor<QList<QPair<QByteArray, QByteArray> > >(((QUrl *)cls)->encodedQueryItems ()));
}

static qt_gsi::GenericMethod *_create_f_encodedQueryItems_c0 ()
{
  return new qt_gsi::GenericMethod (":encodedQueryItems", "@brief Method QList<QPair<QByteArray, QByteArray> > QUrl::encodedQueryItems()\n", true, &_init_f_encodedQueryItems_c0, &_call_f_encodedQueryItems_c0);
}

// QByteArray QUrl::encodedUserName()


static void _init_f_encodedUserName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_encodedUserName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray > ((QByteArray)((QUrl *)cls)->encodedUserName ());
}

static qt_gsi::GenericMethod *_create_f_encodedUserName_c0 ()
{
  return new qt_gsi::GenericMethod (":encodedUserName", "@brief Method QByteArray QUrl::encodedUserName()\n", true, &_init_f_encodedUserName_c0, &_call_f_encodedUserName_c0);
}

// QString QUrl::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QUrl *)cls)->errorString ());
}

static qt_gsi::GenericMethod *_create_f_errorString_c0 ()
{
  return new qt_gsi::GenericMethod ("errorString", "@brief Method QString QUrl::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
}

// QString QUrl::fragment()


static void _init_f_fragment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_fragment_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QUrl *)cls)->fragment ());
}

static qt_gsi::GenericMethod *_create_f_fragment_c0 ()
{
  return new qt_gsi::GenericMethod (":fragment", "@brief Method QString QUrl::fragment()\n", true, &_init_f_fragment_c0, &_call_f_fragment_c0);
}

// bool QUrl::hasEncodedQueryItem(const QByteArray &key)


static void _init_f_hasEncodedQueryItem_c2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasEncodedQueryItem_c2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ret.write<bool > ((bool)((QUrl *)cls)->hasEncodedQueryItem (arg1));
}

static qt_gsi::GenericMethod *_create_f_hasEncodedQueryItem_c2309 ()
{
  return new qt_gsi::GenericMethod ("hasEncodedQueryItem", "@brief Method bool QUrl::hasEncodedQueryItem(const QByteArray &key)\n", true, &_init_f_hasEncodedQueryItem_c2309, &_call_f_hasEncodedQueryItem_c2309);
}

// bool QUrl::hasFragment()


static void _init_f_hasFragment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasFragment_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QUrl *)cls)->hasFragment ());
}

static qt_gsi::GenericMethod *_create_f_hasFragment_c0 ()
{
  return new qt_gsi::GenericMethod ("hasFragment", "@brief Method bool QUrl::hasFragment()\n", true, &_init_f_hasFragment_c0, &_call_f_hasFragment_c0);
}

// bool QUrl::hasQuery()


static void _init_f_hasQuery_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasQuery_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QUrl *)cls)->hasQuery ());
}

static qt_gsi::GenericMethod *_create_f_hasQuery_c0 ()
{
  return new qt_gsi::GenericMethod ("hasQuery", "@brief Method bool QUrl::hasQuery()\n", true, &_init_f_hasQuery_c0, &_call_f_hasQuery_c0);
}

// bool QUrl::hasQueryItem(const QString &key)


static void _init_f_hasQueryItem_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasQueryItem_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QUrl *)cls)->hasQueryItem (arg1));
}

static qt_gsi::GenericMethod *_create_f_hasQueryItem_c2025 ()
{
  return new qt_gsi::GenericMethod ("hasQueryItem", "@brief Method bool QUrl::hasQueryItem(const QString &key)\n", true, &_init_f_hasQueryItem_c2025, &_call_f_hasQueryItem_c2025);
}

// QString QUrl::host()


static void _init_f_host_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_host_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QUrl *)cls)->host ());
}

static qt_gsi::GenericMethod *_create_f_host_c0 ()
{
  return new qt_gsi::GenericMethod (":host", "@brief Method QString QUrl::host()\n", true, &_init_f_host_c0, &_call_f_host_c0);
}

// bool QUrl::isDetached()


static void _init_f_isDetached_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDetached_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QUrl *)cls)->isDetached ());
}

static qt_gsi::GenericMethod *_create_f_isDetached_c0 ()
{
  return new qt_gsi::GenericMethod ("isDetached?", "@brief Method bool QUrl::isDetached()\n", true, &_init_f_isDetached_c0, &_call_f_isDetached_c0);
}

// bool QUrl::isEmpty()


static void _init_f_isEmpty_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEmpty_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QUrl *)cls)->isEmpty ());
}

static qt_gsi::GenericMethod *_create_f_isEmpty_c0 ()
{
  return new qt_gsi::GenericMethod ("isEmpty?", "@brief Method bool QUrl::isEmpty()\n", true, &_init_f_isEmpty_c0, &_call_f_isEmpty_c0);
}

// bool QUrl::isParentOf(const QUrl &url)


static void _init_f_isParentOf_c1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isParentOf_c1701 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QUrl &arg1 = args.read<const QUrl & > ();
  ret.write<bool > ((bool)((QUrl *)cls)->isParentOf (arg1));
}

static qt_gsi::GenericMethod *_create_f_isParentOf_c1701 ()
{
  return new qt_gsi::GenericMethod ("isParentOf?", "@brief Method bool QUrl::isParentOf(const QUrl &url)\n", true, &_init_f_isParentOf_c1701, &_call_f_isParentOf_c1701);
}

// bool QUrl::isRelative()


static void _init_f_isRelative_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRelative_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QUrl *)cls)->isRelative ());
}

static qt_gsi::GenericMethod *_create_f_isRelative_c0 ()
{
  return new qt_gsi::GenericMethod ("isRelative?", "@brief Method bool QUrl::isRelative()\n", true, &_init_f_isRelative_c0, &_call_f_isRelative_c0);
}

// bool QUrl::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QUrl *)cls)->isValid ());
}

static qt_gsi::GenericMethod *_create_f_isValid_c0 ()
{
  return new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QUrl::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
}

// bool QUrl::operator !=(const QUrl &url)


static void _init_f_operator_excl__eq__c1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c1701 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QUrl &arg1 = args.read<const QUrl & > ();
  ret.write<bool > ((bool)((QUrl *)cls)->operator != (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__c1701 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QUrl::operator !=(const QUrl &url)\n", true, &_init_f_operator_excl__eq__c1701, &_call_f_operator_excl__eq__c1701);
}

// bool QUrl::operator <(const QUrl &url)


static void _init_f_operator_lt__c1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_lt__c1701 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QUrl &arg1 = args.read<const QUrl & > ();
  ret.write<bool > ((bool)((QUrl *)cls)->operator < (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_lt__c1701 ()
{
  return new qt_gsi::GenericMethod ("<", "@brief Method bool QUrl::operator <(const QUrl &url)\n", true, &_init_f_operator_lt__c1701, &_call_f_operator_lt__c1701);
}

// QUrl &QUrl::operator =(const QUrl &copy)


static void _init_f_operator_eq__1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("copy");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<QUrl & > ();
}

static void _call_f_operator_eq__1701 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QUrl &arg1 = args.read<const QUrl & > ();
  ret.write<QUrl & > ((QUrl &)((QUrl *)cls)->operator = (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__1701 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QUrl &QUrl::operator =(const QUrl &copy)\n", false, &_init_f_operator_eq__1701, &_call_f_operator_eq__1701);
}

// QUrl &QUrl::operator =(const QString &url)


static void _init_f_operator_eq__2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QUrl & > ();
}

static void _call_f_operator_eq__2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QUrl & > ((QUrl &)((QUrl *)cls)->operator = (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__2025 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QUrl &QUrl::operator =(const QString &url)\n", false, &_init_f_operator_eq__2025, &_call_f_operator_eq__2025);
}

// bool QUrl::operator ==(const QUrl &url)


static void _init_f_operator_eq__eq__c1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c1701 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QUrl &arg1 = args.read<const QUrl & > ();
  ret.write<bool > ((bool)((QUrl *)cls)->operator == (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__c1701 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QUrl::operator ==(const QUrl &url)\n", true, &_init_f_operator_eq__eq__c1701, &_call_f_operator_eq__eq__c1701);
}

// QString QUrl::password()


static void _init_f_password_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_password_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QUrl *)cls)->password ());
}

static qt_gsi::GenericMethod *_create_f_password_c0 ()
{
  return new qt_gsi::GenericMethod (":password", "@brief Method QString QUrl::password()\n", true, &_init_f_password_c0, &_call_f_password_c0);
}

// QString QUrl::path()


static void _init_f_path_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_path_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QUrl *)cls)->path ());
}

static qt_gsi::GenericMethod *_create_f_path_c0 ()
{
  return new qt_gsi::GenericMethod (":path", "@brief Method QString QUrl::path()\n", true, &_init_f_path_c0, &_call_f_path_c0);
}

// int QUrl::port()


static void _init_f_port_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_port_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QUrl *)cls)->port ());
}

static qt_gsi::GenericMethod *_create_f_port_c0 ()
{
  return new qt_gsi::GenericMethod (":port", "@brief Method int QUrl::port()\n", true, &_init_f_port_c0, &_call_f_port_c0);
}

// int QUrl::port(int defaultPort)


static void _init_f_port_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("defaultPort");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_port_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QUrl *)cls)->port (arg1));
}

static qt_gsi::GenericMethod *_create_f_port_c767 ()
{
  return new qt_gsi::GenericMethod ("port", "@brief Method int QUrl::port(int defaultPort)\n", true, &_init_f_port_c767, &_call_f_port_c767);
}

// QString QUrl::queryItemValue(const QString &key)


static void _init_f_queryItemValue_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_queryItemValue_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QString > ((QString)((QUrl *)cls)->queryItemValue (arg1));
}

static qt_gsi::GenericMethod *_create_f_queryItemValue_c2025 ()
{
  return new qt_gsi::GenericMethod ("queryItemValue", "@brief Method QString QUrl::queryItemValue(const QString &key)\n", true, &_init_f_queryItemValue_c2025, &_call_f_queryItemValue_c2025);
}

// QList<QPair<QString, QString> > QUrl::queryItems()


static void _init_f_queryItems_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QPair<QString, QString> > >::target_type > ();
}

static void _call_f_queryItems_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QPair<QString, QString> > >::target_type > ((qt_gsi::Converter<QList<QPair<QString, QString> > >::target_type)qt_gsi::CppToQtAdaptor<QList<QPair<QString, QString> > >(((QUrl *)cls)->queryItems ()));
}

static qt_gsi::GenericMethod *_create_f_queryItems_c0 ()
{
  return new qt_gsi::GenericMethod (":queryItems", "@brief Method QList<QPair<QString, QString> > QUrl::queryItems()\n", true, &_init_f_queryItems_c0, &_call_f_queryItems_c0);
}

// char QUrl::queryPairDelimiter()


static void _init_f_queryPairDelimiter_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<char > ();
}

static void _call_f_queryPairDelimiter_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<char > ((char)((QUrl *)cls)->queryPairDelimiter ());
}

static qt_gsi::GenericMethod *_create_f_queryPairDelimiter_c0 ()
{
  return new qt_gsi::GenericMethod ("queryPairDelimiter", "@brief Method char QUrl::queryPairDelimiter()\n", true, &_init_f_queryPairDelimiter_c0, &_call_f_queryPairDelimiter_c0);
}

// char QUrl::queryValueDelimiter()


static void _init_f_queryValueDelimiter_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<char > ();
}

static void _call_f_queryValueDelimiter_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<char > ((char)((QUrl *)cls)->queryValueDelimiter ());
}

static qt_gsi::GenericMethod *_create_f_queryValueDelimiter_c0 ()
{
  return new qt_gsi::GenericMethod ("queryValueDelimiter", "@brief Method char QUrl::queryValueDelimiter()\n", true, &_init_f_queryValueDelimiter_c0, &_call_f_queryValueDelimiter_c0);
}

// void QUrl::removeAllEncodedQueryItems(const QByteArray &key)


static void _init_f_removeAllEncodedQueryItems_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeAllEncodedQueryItems_2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ((QUrl *)cls)->removeAllEncodedQueryItems (arg1);
}

static qt_gsi::GenericMethod *_create_f_removeAllEncodedQueryItems_2309 ()
{
  return new qt_gsi::GenericMethod ("removeAllEncodedQueryItems", "@brief Method void QUrl::removeAllEncodedQueryItems(const QByteArray &key)\n", false, &_init_f_removeAllEncodedQueryItems_2309, &_call_f_removeAllEncodedQueryItems_2309);
}

// void QUrl::removeAllQueryItems(const QString &key)


static void _init_f_removeAllQueryItems_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeAllQueryItems_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QUrl *)cls)->removeAllQueryItems (arg1);
}

static qt_gsi::GenericMethod *_create_f_removeAllQueryItems_2025 ()
{
  return new qt_gsi::GenericMethod ("removeAllQueryItems", "@brief Method void QUrl::removeAllQueryItems(const QString &key)\n", false, &_init_f_removeAllQueryItems_2025, &_call_f_removeAllQueryItems_2025);
}

// void QUrl::removeEncodedQueryItem(const QByteArray &key)


static void _init_f_removeEncodedQueryItem_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeEncodedQueryItem_2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ((QUrl *)cls)->removeEncodedQueryItem (arg1);
}

static qt_gsi::GenericMethod *_create_f_removeEncodedQueryItem_2309 ()
{
  return new qt_gsi::GenericMethod ("removeEncodedQueryItem", "@brief Method void QUrl::removeEncodedQueryItem(const QByteArray &key)\n", false, &_init_f_removeEncodedQueryItem_2309, &_call_f_removeEncodedQueryItem_2309);
}

// void QUrl::removeQueryItem(const QString &key)


static void _init_f_removeQueryItem_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeQueryItem_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QUrl *)cls)->removeQueryItem (arg1);
}

static qt_gsi::GenericMethod *_create_f_removeQueryItem_2025 ()
{
  return new qt_gsi::GenericMethod ("removeQueryItem", "@brief Method void QUrl::removeQueryItem(const QString &key)\n", false, &_init_f_removeQueryItem_2025, &_call_f_removeQueryItem_2025);
}

// QUrl QUrl::resolved(const QUrl &relative)


static void _init_f_resolved_c1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("relative");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<QUrl > ();
}

static void _call_f_resolved_c1701 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QUrl &arg1 = args.read<const QUrl & > ();
  ret.write<QUrl > ((QUrl)((QUrl *)cls)->resolved (arg1));
}

static qt_gsi::GenericMethod *_create_f_resolved_c1701 ()
{
  return new qt_gsi::GenericMethod ("resolved", "@brief Method QUrl QUrl::resolved(const QUrl &relative)\n", true, &_init_f_resolved_c1701, &_call_f_resolved_c1701);
}

// QString QUrl::scheme()


static void _init_f_scheme_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_scheme_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QUrl *)cls)->scheme ());
}

static qt_gsi::GenericMethod *_create_f_scheme_c0 ()
{
  return new qt_gsi::GenericMethod (":scheme", "@brief Method QString QUrl::scheme()\n", true, &_init_f_scheme_c0, &_call_f_scheme_c0);
}

// void QUrl::setAuthority(const QString &authority)


static void _init_f_setAuthority_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("authority");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAuthority_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QUrl *)cls)->setAuthority (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAuthority_2025 ()
{
  return new qt_gsi::GenericMethod ("setAuthority|authority=", "@brief Method void QUrl::setAuthority(const QString &authority)\n", false, &_init_f_setAuthority_2025, &_call_f_setAuthority_2025);
}

// void QUrl::setEncodedFragment(const QByteArray &fragment)


static void _init_f_setEncodedFragment_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fragment");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEncodedFragment_2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ((QUrl *)cls)->setEncodedFragment (arg1);
}

static qt_gsi::GenericMethod *_create_f_setEncodedFragment_2309 ()
{
  return new qt_gsi::GenericMethod ("setEncodedFragment|encodedFragment=", "@brief Method void QUrl::setEncodedFragment(const QByteArray &fragment)\n", false, &_init_f_setEncodedFragment_2309, &_call_f_setEncodedFragment_2309);
}

// void QUrl::setEncodedHost(const QByteArray &host)


static void _init_f_setEncodedHost_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("host");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEncodedHost_2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ((QUrl *)cls)->setEncodedHost (arg1);
}

static qt_gsi::GenericMethod *_create_f_setEncodedHost_2309 ()
{
  return new qt_gsi::GenericMethod ("setEncodedHost|encodedHost=", "@brief Method void QUrl::setEncodedHost(const QByteArray &host)\n", false, &_init_f_setEncodedHost_2309, &_call_f_setEncodedHost_2309);
}

// void QUrl::setEncodedPassword(const QByteArray &password)


static void _init_f_setEncodedPassword_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("password");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEncodedPassword_2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ((QUrl *)cls)->setEncodedPassword (arg1);
}

static qt_gsi::GenericMethod *_create_f_setEncodedPassword_2309 ()
{
  return new qt_gsi::GenericMethod ("setEncodedPassword|encodedPassword=", "@brief Method void QUrl::setEncodedPassword(const QByteArray &password)\n", false, &_init_f_setEncodedPassword_2309, &_call_f_setEncodedPassword_2309);
}

// void QUrl::setEncodedPath(const QByteArray &path)


static void _init_f_setEncodedPath_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEncodedPath_2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ((QUrl *)cls)->setEncodedPath (arg1);
}

static qt_gsi::GenericMethod *_create_f_setEncodedPath_2309 ()
{
  return new qt_gsi::GenericMethod ("setEncodedPath|encodedPath=", "@brief Method void QUrl::setEncodedPath(const QByteArray &path)\n", false, &_init_f_setEncodedPath_2309, &_call_f_setEncodedPath_2309);
}

// void QUrl::setEncodedQuery(const QByteArray &query)


static void _init_f_setEncodedQuery_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEncodedQuery_2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ((QUrl *)cls)->setEncodedQuery (arg1);
}

static qt_gsi::GenericMethod *_create_f_setEncodedQuery_2309 ()
{
  return new qt_gsi::GenericMethod ("setEncodedQuery|encodedQuery=", "@brief Method void QUrl::setEncodedQuery(const QByteArray &query)\n", false, &_init_f_setEncodedQuery_2309, &_call_f_setEncodedQuery_2309);
}

// void QUrl::setEncodedQueryItems(const QList<QPair<QByteArray, QByteArray> > &query)


static void _init_f_setEncodedQueryItems_4851 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<QList<QPair<QByteArray, QByteArray> > >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEncodedQueryItems_4851 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QPair<QByteArray, QByteArray> > >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QPair<QByteArray, QByteArray> > >::target_type & > ();
  ((QUrl *)cls)->setEncodedQueryItems (qt_gsi::QtToCppAdaptor<QList<QPair<QByteArray, QByteArray> > >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setEncodedQueryItems_4851 ()
{
  return new qt_gsi::GenericMethod ("setEncodedQueryItems|encodedQueryItems=", "@brief Method void QUrl::setEncodedQueryItems(const QList<QPair<QByteArray, QByteArray> > &query)\n", false, &_init_f_setEncodedQueryItems_4851, &_call_f_setEncodedQueryItems_4851);
}

// void QUrl::setEncodedUrl(const QByteArray &url)


static void _init_f_setEncodedUrl_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEncodedUrl_2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ((QUrl *)cls)->setEncodedUrl (arg1);
}

static qt_gsi::GenericMethod *_create_f_setEncodedUrl_2309 ()
{
  return new qt_gsi::GenericMethod ("setEncodedUrl", "@brief Method void QUrl::setEncodedUrl(const QByteArray &url)\n", false, &_init_f_setEncodedUrl_2309, &_call_f_setEncodedUrl_2309);
}

// void QUrl::setEncodedUrl(const QByteArray &url, QUrl::ParsingMode mode)


static void _init_f_setEncodedUrl_4254 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setEncodedUrl_4254 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  const qt_gsi::Converter<QUrl::ParsingMode>::target_type & arg2 = args.read<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > ();
  ((QUrl *)cls)->setEncodedUrl (arg1, qt_gsi::QtToCppAdaptor<QUrl::ParsingMode>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setEncodedUrl_4254 ()
{
  return new qt_gsi::GenericMethod ("setEncodedUrl", "@brief Method void QUrl::setEncodedUrl(const QByteArray &url, QUrl::ParsingMode mode)\n", false, &_init_f_setEncodedUrl_4254, &_call_f_setEncodedUrl_4254);
}

// void QUrl::setEncodedUserName(const QByteArray &userName)


static void _init_f_setEncodedUserName_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("userName");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEncodedUserName_2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ((QUrl *)cls)->setEncodedUserName (arg1);
}

static qt_gsi::GenericMethod *_create_f_setEncodedUserName_2309 ()
{
  return new qt_gsi::GenericMethod ("setEncodedUserName|encodedUserName=", "@brief Method void QUrl::setEncodedUserName(const QByteArray &userName)\n", false, &_init_f_setEncodedUserName_2309, &_call_f_setEncodedUserName_2309);
}

// void QUrl::setFragment(const QString &fragment)


static void _init_f_setFragment_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fragment");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFragment_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QUrl *)cls)->setFragment (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFragment_2025 ()
{
  return new qt_gsi::GenericMethod ("setFragment|fragment=", "@brief Method void QUrl::setFragment(const QString &fragment)\n", false, &_init_f_setFragment_2025, &_call_f_setFragment_2025);
}

// void QUrl::setHost(const QString &host)


static void _init_f_setHost_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("host");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHost_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QUrl *)cls)->setHost (arg1);
}

static qt_gsi::GenericMethod *_create_f_setHost_2025 ()
{
  return new qt_gsi::GenericMethod ("setHost|host=", "@brief Method void QUrl::setHost(const QString &host)\n", false, &_init_f_setHost_2025, &_call_f_setHost_2025);
}

// void QUrl::setPassword(const QString &password)


static void _init_f_setPassword_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("password");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPassword_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QUrl *)cls)->setPassword (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPassword_2025 ()
{
  return new qt_gsi::GenericMethod ("setPassword|password=", "@brief Method void QUrl::setPassword(const QString &password)\n", false, &_init_f_setPassword_2025, &_call_f_setPassword_2025);
}

// void QUrl::setPath(const QString &path)


static void _init_f_setPath_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPath_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QUrl *)cls)->setPath (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPath_2025 ()
{
  return new qt_gsi::GenericMethod ("setPath|path=", "@brief Method void QUrl::setPath(const QString &path)\n", false, &_init_f_setPath_2025, &_call_f_setPath_2025);
}

// void QUrl::setPort(int port)


static void _init_f_setPort_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("port");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPort_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QUrl *)cls)->setPort (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPort_767 ()
{
  return new qt_gsi::GenericMethod ("setPort|port=", "@brief Method void QUrl::setPort(int port)\n", false, &_init_f_setPort_767, &_call_f_setPort_767);
}

// void QUrl::setQueryDelimiters(char valueDelimiter, char pairDelimiter)


static void _init_f_setQueryDelimiters_1592 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("valueDelimiter");
  decl->add_arg<char > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pairDelimiter");
  decl->add_arg<char > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setQueryDelimiters_1592 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  char arg1 = args.read<char > ();
  char arg2 = args.read<char > ();
  ((QUrl *)cls)->setQueryDelimiters (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setQueryDelimiters_1592 ()
{
  return new qt_gsi::GenericMethod ("setQueryDelimiters", "@brief Method void QUrl::setQueryDelimiters(char valueDelimiter, char pairDelimiter)\n", false, &_init_f_setQueryDelimiters_1592, &_call_f_setQueryDelimiters_1592);
}

// void QUrl::setQueryItems(const QList<QPair<QString, QString> > &query)


static void _init_f_setQueryItems_4283 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<QList<QPair<QString, QString> > >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setQueryItems_4283 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QPair<QString, QString> > >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QPair<QString, QString> > >::target_type & > ();
  ((QUrl *)cls)->setQueryItems (qt_gsi::QtToCppAdaptor<QList<QPair<QString, QString> > >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setQueryItems_4283 ()
{
  return new qt_gsi::GenericMethod ("setQueryItems|queryItems=", "@brief Method void QUrl::setQueryItems(const QList<QPair<QString, QString> > &query)\n", false, &_init_f_setQueryItems_4283, &_call_f_setQueryItems_4283);
}

// void QUrl::setScheme(const QString &scheme)


static void _init_f_setScheme_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("scheme");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setScheme_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QUrl *)cls)->setScheme (arg1);
}

static qt_gsi::GenericMethod *_create_f_setScheme_2025 ()
{
  return new qt_gsi::GenericMethod ("setScheme|scheme=", "@brief Method void QUrl::setScheme(const QString &scheme)\n", false, &_init_f_setScheme_2025, &_call_f_setScheme_2025);
}

// void QUrl::setUrl(const QString &url)


static void _init_f_setUrl_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUrl_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QUrl *)cls)->setUrl (arg1);
}

static qt_gsi::GenericMethod *_create_f_setUrl_2025 ()
{
  return new qt_gsi::GenericMethod ("setUrl", "@brief Method void QUrl::setUrl(const QString &url)\n", false, &_init_f_setUrl_2025, &_call_f_setUrl_2025);
}

// void QUrl::setUrl(const QString &url, QUrl::ParsingMode mode)


static void _init_f_setUrl_3970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setUrl_3970 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const qt_gsi::Converter<QUrl::ParsingMode>::target_type & arg2 = args.read<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > ();
  ((QUrl *)cls)->setUrl (arg1, qt_gsi::QtToCppAdaptor<QUrl::ParsingMode>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setUrl_3970 ()
{
  return new qt_gsi::GenericMethod ("setUrl", "@brief Method void QUrl::setUrl(const QString &url, QUrl::ParsingMode mode)\n", false, &_init_f_setUrl_3970, &_call_f_setUrl_3970);
}

// void QUrl::setUserInfo(const QString &userInfo)


static void _init_f_setUserInfo_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("userInfo");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUserInfo_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QUrl *)cls)->setUserInfo (arg1);
}

static qt_gsi::GenericMethod *_create_f_setUserInfo_2025 ()
{
  return new qt_gsi::GenericMethod ("setUserInfo|userInfo=", "@brief Method void QUrl::setUserInfo(const QString &userInfo)\n", false, &_init_f_setUserInfo_2025, &_call_f_setUserInfo_2025);
}

// void QUrl::setUserName(const QString &userName)


static void _init_f_setUserName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("userName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUserName_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QUrl *)cls)->setUserName (arg1);
}

static qt_gsi::GenericMethod *_create_f_setUserName_2025 ()
{
  return new qt_gsi::GenericMethod ("setUserName|userName=", "@brief Method void QUrl::setUserName(const QString &userName)\n", false, &_init_f_setUserName_2025, &_call_f_setUserName_2025);
}

// QByteArray QUrl::toEncoded(QFlags<QUrl::FormattingOption> options)


static void _init_f_toEncoded_c3320 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options", true, "QUrl::None");
  decl->add_arg<const qt_gsi::Converter<QFlags<QUrl::FormattingOption> >::target_type & > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_toEncoded_c3320 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QUrl::FormattingOption> >::target_type & arg1 = args ? args.read<const qt_gsi::Converter<QFlags<QUrl::FormattingOption> >::target_type & > () : (const qt_gsi::Converter<QFlags<QUrl::FormattingOption> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QUrl::FormattingOption> >(heap, QUrl::None));
  ret.write<QByteArray > ((QByteArray)((QUrl *)cls)->toEncoded (qt_gsi::QtToCppAdaptor<QFlags<QUrl::FormattingOption> >(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_toEncoded_c3320 ()
{
  return new qt_gsi::GenericMethod ("toEncoded", "@brief Method QByteArray QUrl::toEncoded(QFlags<QUrl::FormattingOption> options)\n", true, &_init_f_toEncoded_c3320, &_call_f_toEncoded_c3320);
}

// QString QUrl::toLocalFile()


static void _init_f_toLocalFile_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toLocalFile_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QUrl *)cls)->toLocalFile ());
}

static qt_gsi::GenericMethod *_create_f_toLocalFile_c0 ()
{
  return new qt_gsi::GenericMethod ("toLocalFile", "@brief Method QString QUrl::toLocalFile()\n", true, &_init_f_toLocalFile_c0, &_call_f_toLocalFile_c0);
}

// QString QUrl::toString(QFlags<QUrl::FormattingOption> options)


static void _init_f_toString_c3320 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options", true, "QUrl::None");
  decl->add_arg<const qt_gsi::Converter<QFlags<QUrl::FormattingOption> >::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c3320 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QUrl::FormattingOption> >::target_type & arg1 = args ? args.read<const qt_gsi::Converter<QFlags<QUrl::FormattingOption> >::target_type & > () : (const qt_gsi::Converter<QFlags<QUrl::FormattingOption> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QUrl::FormattingOption> >(heap, QUrl::None));
  ret.write<QString > ((QString)((QUrl *)cls)->toString (qt_gsi::QtToCppAdaptor<QFlags<QUrl::FormattingOption> >(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_toString_c3320 ()
{
  return new qt_gsi::GenericMethod ("toString", "@brief Method QString QUrl::toString(QFlags<QUrl::FormattingOption> options)\n", true, &_init_f_toString_c3320, &_call_f_toString_c3320);
}

// QString QUrl::userInfo()


static void _init_f_userInfo_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_userInfo_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QUrl *)cls)->userInfo ());
}

static qt_gsi::GenericMethod *_create_f_userInfo_c0 ()
{
  return new qt_gsi::GenericMethod (":userInfo", "@brief Method QString QUrl::userInfo()\n", true, &_init_f_userInfo_c0, &_call_f_userInfo_c0);
}

// QString QUrl::userName()


static void _init_f_userName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_userName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QUrl *)cls)->userName ());
}

static qt_gsi::GenericMethod *_create_f_userName_c0 ()
{
  return new qt_gsi::GenericMethod (":userName", "@brief Method QString QUrl::userName()\n", true, &_init_f_userName_c0, &_call_f_userName_c0);
}

// static QString QUrl::fromAce(const QByteArray &)


static void _init_f_fromAce_2309 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_fromAce_2309 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ret.write<QString > ((QString)QUrl::fromAce (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_fromAce_2309 ()
{
  return new qt_gsi::GenericStaticMethod ("fromAce", "@brief Static method QString QUrl::fromAce(const QByteArray &)\nThis method is static and can be called without an instance.", &_init_f_fromAce_2309, &_call_f_fromAce_2309);
}

// static QUrl QUrl::fromEncoded(const QByteArray &url)


static void _init_f_fromEncoded_2309 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<QUrl > ();
}

static void _call_f_fromEncoded_2309 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ret.write<QUrl > ((QUrl)QUrl::fromEncoded (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_fromEncoded_2309 ()
{
  return new qt_gsi::GenericStaticMethod ("fromEncoded", "@brief Static method QUrl QUrl::fromEncoded(const QByteArray &url)\nThis method is static and can be called without an instance.", &_init_f_fromEncoded_2309, &_call_f_fromEncoded_2309);
}

// static QUrl QUrl::fromEncoded(const QByteArray &url, QUrl::ParsingMode mode)


static void _init_f_fromEncoded_4254 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (argspec_1);
  decl->set_return<QUrl > ();
}

static void _call_f_fromEncoded_4254 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  const qt_gsi::Converter<QUrl::ParsingMode>::target_type & arg2 = args.read<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > ();
  ret.write<QUrl > ((QUrl)QUrl::fromEncoded (arg1, qt_gsi::QtToCppAdaptor<QUrl::ParsingMode>(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_fromEncoded_4254 ()
{
  return new qt_gsi::GenericStaticMethod ("fromEncoded", "@brief Static method QUrl QUrl::fromEncoded(const QByteArray &url, QUrl::ParsingMode mode)\nThis method is static and can be called without an instance.", &_init_f_fromEncoded_4254, &_call_f_fromEncoded_4254);
}

// static QUrl QUrl::fromLocalFile(const QString &localfile)


static void _init_f_fromLocalFile_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("localfile");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QUrl > ();
}

static void _call_f_fromLocalFile_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QUrl > ((QUrl)QUrl::fromLocalFile (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_fromLocalFile_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("fromLocalFile", "@brief Static method QUrl QUrl::fromLocalFile(const QString &localfile)\nThis method is static and can be called without an instance.", &_init_f_fromLocalFile_2025, &_call_f_fromLocalFile_2025);
}

// static QString QUrl::fromPercentEncoding(const QByteArray &)


static void _init_f_fromPercentEncoding_2309 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_fromPercentEncoding_2309 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ret.write<QString > ((QString)QUrl::fromPercentEncoding (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_fromPercentEncoding_2309 ()
{
  return new qt_gsi::GenericStaticMethod ("fromPercentEncoding", "@brief Static method QString QUrl::fromPercentEncoding(const QByteArray &)\nThis method is static and can be called without an instance.", &_init_f_fromPercentEncoding_2309, &_call_f_fromPercentEncoding_2309);
}

// static QString QUrl::fromPunycode(const QByteArray &)


static void _init_f_fromPunycode_2309 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_fromPunycode_2309 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ret.write<QString > ((QString)QUrl::fromPunycode (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_fromPunycode_2309 ()
{
  return new qt_gsi::GenericStaticMethod ("fromPunycode", "@brief Static method QString QUrl::fromPunycode(const QByteArray &)\nThis method is static and can be called without an instance.", &_init_f_fromPunycode_2309, &_call_f_fromPunycode_2309);
}

// static QUrl QUrl::fromUserInput(const QString &userInput)


static void _init_f_fromUserInput_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("userInput");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QUrl > ();
}

static void _call_f_fromUserInput_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QUrl > ((QUrl)QUrl::fromUserInput (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_fromUserInput_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("fromUserInput", "@brief Static method QUrl QUrl::fromUserInput(const QString &userInput)\nThis method is static and can be called without an instance.", &_init_f_fromUserInput_2025, &_call_f_fromUserInput_2025);
}

// static QStringList QUrl::idnWhitelist()


static void _init_f_idnWhitelist_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_idnWhitelist_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(QUrl::idnWhitelist ()));
}

static qt_gsi::GenericStaticMethod *_create_f_idnWhitelist_0 ()
{
  return new qt_gsi::GenericStaticMethod (":idnWhitelist", "@brief Static method QStringList QUrl::idnWhitelist()\nThis method is static and can be called without an instance.", &_init_f_idnWhitelist_0, &_call_f_idnWhitelist_0);
}

// static void QUrl::setIdnWhitelist(const QStringList &)


static void _init_f_setIdnWhitelist_2437 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIdnWhitelist_2437 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStringList>::target_type & arg1 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  QUrl::setIdnWhitelist (qt_gsi::QtToCppAdaptor<QStringList>(arg1).cref());
}

static qt_gsi::GenericStaticMethod *_create_f_setIdnWhitelist_2437 ()
{
  return new qt_gsi::GenericStaticMethod ("setIdnWhitelist|idnWhitelist=", "@brief Static method void QUrl::setIdnWhitelist(const QStringList &)\nThis method is static and can be called without an instance.", &_init_f_setIdnWhitelist_2437, &_call_f_setIdnWhitelist_2437);
}

// static QByteArray QUrl::toAce(const QString &)


static void _init_f_toAce_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_toAce_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QByteArray > ((QByteArray)QUrl::toAce (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_toAce_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("toAce", "@brief Static method QByteArray QUrl::toAce(const QString &)\nThis method is static and can be called without an instance.", &_init_f_toAce_2025, &_call_f_toAce_2025);
}

// static QByteArray QUrl::toPercentEncoding(const QString &, const QByteArray &exclude, const QByteArray &include)


static void _init_f_toPercentEncoding_6427 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("exclude", true, "QByteArray()");
  decl->add_arg<const QByteArray & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("include", true, "QByteArray()");
  decl->add_arg<const QByteArray & > (argspec_2);
  decl->set_return<QByteArray > ();
}

static void _call_f_toPercentEncoding_6427 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QByteArray &arg2 = args ? args.read<const QByteArray & > () : (const QByteArray &)(QByteArray());
  const QByteArray &arg3 = args ? args.read<const QByteArray & > () : (const QByteArray &)(QByteArray());
  ret.write<QByteArray > ((QByteArray)QUrl::toPercentEncoding (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_toPercentEncoding_6427 ()
{
  return new qt_gsi::GenericStaticMethod ("toPercentEncoding", "@brief Static method QByteArray QUrl::toPercentEncoding(const QString &, const QByteArray &exclude, const QByteArray &include)\nThis method is static and can be called without an instance.", &_init_f_toPercentEncoding_6427, &_call_f_toPercentEncoding_6427);
}

// static QByteArray QUrl::toPunycode(const QString &)


static void _init_f_toPunycode_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_toPunycode_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QByteArray > ((QByteArray)QUrl::toPunycode (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_toPunycode_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("toPunycode", "@brief Static method QByteArray QUrl::toPunycode(const QString &)\nThis method is static and can be called without an instance.", &_init_f_toPunycode_2025, &_call_f_toPunycode_2025);
}


namespace gsi
{
gsi::Class<QUrl> decl_QUrl ("QUrl",
  gsi::Methods(_create_ctor_QUrl_0 ()) +
  gsi::Methods(_create_ctor_QUrl_2025 ()) +
  gsi::Methods(_create_ctor_QUrl_3970 ()) +
  gsi::Methods(_create_ctor_QUrl_1701 ()) +
  gsi::Methods(_create_f_addEncodedQueryItem_4510 ()) +
  gsi::Methods(_create_f_addQueryItem_3942 ()) +
  gsi::Methods(_create_f_allEncodedQueryItemValues_c2309 ()) +
  gsi::Methods(_create_f_allQueryItemValues_c2025 ()) +
  gsi::Methods(_create_f_authority_c0 ()) +
  gsi::Methods(_create_f_clear_0 ()) +
  gsi::Methods(_create_f_detach_0 ()) +
  gsi::Methods(_create_f_encodedFragment_c0 ()) +
  gsi::Methods(_create_f_encodedHost_c0 ()) +
  gsi::Methods(_create_f_encodedPassword_c0 ()) +
  gsi::Methods(_create_f_encodedPath_c0 ()) +
  gsi::Methods(_create_f_encodedQuery_c0 ()) +
  gsi::Methods(_create_f_encodedQueryItemValue_c2309 ()) +
  gsi::Methods(_create_f_encodedQueryItems_c0 ()) +
  gsi::Methods(_create_f_encodedUserName_c0 ()) +
  gsi::Methods(_create_f_errorString_c0 ()) +
  gsi::Methods(_create_f_fragment_c0 ()) +
  gsi::Methods(_create_f_hasEncodedQueryItem_c2309 ()) +
  gsi::Methods(_create_f_hasFragment_c0 ()) +
  gsi::Methods(_create_f_hasQuery_c0 ()) +
  gsi::Methods(_create_f_hasQueryItem_c2025 ()) +
  gsi::Methods(_create_f_host_c0 ()) +
  gsi::Methods(_create_f_isDetached_c0 ()) +
  gsi::Methods(_create_f_isEmpty_c0 ()) +
  gsi::Methods(_create_f_isParentOf_c1701 ()) +
  gsi::Methods(_create_f_isRelative_c0 ()) +
  gsi::Methods(_create_f_isValid_c0 ()) +
  gsi::Methods(_create_f_operator_excl__eq__c1701 ()) +
  gsi::Methods(_create_f_operator_lt__c1701 ()) +
  gsi::Methods(_create_f_operator_eq__1701 ()) +
  gsi::Methods(_create_f_operator_eq__2025 ()) +
  gsi::Methods(_create_f_operator_eq__eq__c1701 ()) +
  gsi::Methods(_create_f_password_c0 ()) +
  gsi::Methods(_create_f_path_c0 ()) +
  gsi::Methods(_create_f_port_c0 ()) +
  gsi::Methods(_create_f_port_c767 ()) +
  gsi::Methods(_create_f_queryItemValue_c2025 ()) +
  gsi::Methods(_create_f_queryItems_c0 ()) +
  gsi::Methods(_create_f_queryPairDelimiter_c0 ()) +
  gsi::Methods(_create_f_queryValueDelimiter_c0 ()) +
  gsi::Methods(_create_f_removeAllEncodedQueryItems_2309 ()) +
  gsi::Methods(_create_f_removeAllQueryItems_2025 ()) +
  gsi::Methods(_create_f_removeEncodedQueryItem_2309 ()) +
  gsi::Methods(_create_f_removeQueryItem_2025 ()) +
  gsi::Methods(_create_f_resolved_c1701 ()) +
  gsi::Methods(_create_f_scheme_c0 ()) +
  gsi::Methods(_create_f_setAuthority_2025 ()) +
  gsi::Methods(_create_f_setEncodedFragment_2309 ()) +
  gsi::Methods(_create_f_setEncodedHost_2309 ()) +
  gsi::Methods(_create_f_setEncodedPassword_2309 ()) +
  gsi::Methods(_create_f_setEncodedPath_2309 ()) +
  gsi::Methods(_create_f_setEncodedQuery_2309 ()) +
  gsi::Methods(_create_f_setEncodedQueryItems_4851 ()) +
  gsi::Methods(_create_f_setEncodedUrl_2309 ()) +
  gsi::Methods(_create_f_setEncodedUrl_4254 ()) +
  gsi::Methods(_create_f_setEncodedUserName_2309 ()) +
  gsi::Methods(_create_f_setFragment_2025 ()) +
  gsi::Methods(_create_f_setHost_2025 ()) +
  gsi::Methods(_create_f_setPassword_2025 ()) +
  gsi::Methods(_create_f_setPath_2025 ()) +
  gsi::Methods(_create_f_setPort_767 ()) +
  gsi::Methods(_create_f_setQueryDelimiters_1592 ()) +
  gsi::Methods(_create_f_setQueryItems_4283 ()) +
  gsi::Methods(_create_f_setScheme_2025 ()) +
  gsi::Methods(_create_f_setUrl_2025 ()) +
  gsi::Methods(_create_f_setUrl_3970 ()) +
  gsi::Methods(_create_f_setUserInfo_2025 ()) +
  gsi::Methods(_create_f_setUserName_2025 ()) +
  gsi::Methods(_create_f_toEncoded_c3320 ()) +
  gsi::Methods(_create_f_toLocalFile_c0 ()) +
  gsi::Methods(_create_f_toString_c3320 ()) +
  gsi::Methods(_create_f_userInfo_c0 ()) +
  gsi::Methods(_create_f_userName_c0 ()) +
  gsi::Methods(_create_f_fromAce_2309 ()) +
  gsi::Methods(_create_f_fromEncoded_2309 ()) +
  gsi::Methods(_create_f_fromEncoded_4254 ()) +
  gsi::Methods(_create_f_fromLocalFile_2025 ()) +
  gsi::Methods(_create_f_fromPercentEncoding_2309 ()) +
  gsi::Methods(_create_f_fromPunycode_2309 ()) +
  gsi::Methods(_create_f_fromUserInput_2025 ()) +
  gsi::Methods(_create_f_idnWhitelist_0 ()) +
  gsi::Methods(_create_f_setIdnWhitelist_2437 ()) +
  gsi::Methods(_create_f_toAce_2025 ()) +
  gsi::Methods(_create_f_toPercentEncoding_6427 ()) +
  gsi::Methods(_create_f_toPunycode_2025 ()),
  "@qt\n@brief Binding of QUrl");

}


//  Implementation of the enum wrapper class for QUrl::FormattingOption
namespace qt_gsi
{

static QUrl_FormattingOption_Enum *c_1_QUrl_FormattingOption_Enum () { return new QUrl_FormattingOption_Enum (QUrl::None); }
static QUrl_FormattingOption_Enum *c_2_QUrl_FormattingOption_Enum () { return new QUrl_FormattingOption_Enum (QUrl::RemoveScheme); }
static QUrl_FormattingOption_Enum *c_3_QUrl_FormattingOption_Enum () { return new QUrl_FormattingOption_Enum (QUrl::RemovePassword); }
static QUrl_FormattingOption_Enum *c_4_QUrl_FormattingOption_Enum () { return new QUrl_FormattingOption_Enum (QUrl::RemoveUserInfo); }
static QUrl_FormattingOption_Enum *c_5_QUrl_FormattingOption_Enum () { return new QUrl_FormattingOption_Enum (QUrl::RemovePort); }
static QUrl_FormattingOption_Enum *c_6_QUrl_FormattingOption_Enum () { return new QUrl_FormattingOption_Enum (QUrl::RemoveAuthority); }
static QUrl_FormattingOption_Enum *c_7_QUrl_FormattingOption_Enum () { return new QUrl_FormattingOption_Enum (QUrl::RemovePath); }
static QUrl_FormattingOption_Enum *c_8_QUrl_FormattingOption_Enum () { return new QUrl_FormattingOption_Enum (QUrl::RemoveQuery); }
static QUrl_FormattingOption_Enum *c_9_QUrl_FormattingOption_Enum () { return new QUrl_FormattingOption_Enum (QUrl::RemoveFragment); }
static QUrl_FormattingOption_Enum *c_10_QUrl_FormattingOption_Enum () { return new QUrl_FormattingOption_Enum (QUrl::StripTrailingSlash); }

static gsi::Methods mkdefs_QUrl_FormattingOption () {
  return
    gsi::constant ("None", &qt_gsi::c_1_QUrl_FormattingOption_Enum, "@brief Enum constant QUrl::None") +
    gsi::constant ("RemoveScheme", &qt_gsi::c_2_QUrl_FormattingOption_Enum, "@brief Enum constant QUrl::RemoveScheme") +
    gsi::constant ("RemovePassword", &qt_gsi::c_3_QUrl_FormattingOption_Enum, "@brief Enum constant QUrl::RemovePassword") +
    gsi::constant ("RemoveUserInfo", &qt_gsi::c_4_QUrl_FormattingOption_Enum, "@brief Enum constant QUrl::RemoveUserInfo") +
    gsi::constant ("RemovePort", &qt_gsi::c_5_QUrl_FormattingOption_Enum, "@brief Enum constant QUrl::RemovePort") +
    gsi::constant ("RemoveAuthority", &qt_gsi::c_6_QUrl_FormattingOption_Enum, "@brief Enum constant QUrl::RemoveAuthority") +
    gsi::constant ("RemovePath", &qt_gsi::c_7_QUrl_FormattingOption_Enum, "@brief Enum constant QUrl::RemovePath") +
    gsi::constant ("RemoveQuery", &qt_gsi::c_8_QUrl_FormattingOption_Enum, "@brief Enum constant QUrl::RemoveQuery") +
    gsi::constant ("RemoveFragment", &qt_gsi::c_9_QUrl_FormattingOption_Enum, "@brief Enum constant QUrl::RemoveFragment") +
    gsi::constant ("StripTrailingSlash", &qt_gsi::c_10_QUrl_FormattingOption_Enum, "@brief Enum constant QUrl::StripTrailingSlash");
}

static std::string to_s_QUrl_FormattingOption_Enum (const QUrl_FormattingOption_Enum *e)
{
  if (e->value () == QUrl::None) { return tl::sprintf ("None (%u)", (unsigned int) e->value ()); }
  if (e->value () == QUrl::RemoveScheme) { return tl::sprintf ("RemoveScheme (%u)", (unsigned int) e->value ()); }
  if (e->value () == QUrl::RemovePassword) { return tl::sprintf ("RemovePassword (%u)", (unsigned int) e->value ()); }
  if (e->value () == QUrl::RemoveUserInfo) { return tl::sprintf ("RemoveUserInfo (%u)", (unsigned int) e->value ()); }
  if (e->value () == QUrl::RemovePort) { return tl::sprintf ("RemovePort (%u)", (unsigned int) e->value ()); }
  if (e->value () == QUrl::RemoveAuthority) { return tl::sprintf ("RemoveAuthority (%u)", (unsigned int) e->value ()); }
  if (e->value () == QUrl::RemovePath) { return tl::sprintf ("RemovePath (%u)", (unsigned int) e->value ()); }
  if (e->value () == QUrl::RemoveQuery) { return tl::sprintf ("RemoveQuery (%u)", (unsigned int) e->value ()); }
  if (e->value () == QUrl::RemoveFragment) { return tl::sprintf ("RemoveFragment (%u)", (unsigned int) e->value ()); }
  if (e->value () == QUrl::StripTrailingSlash) { return tl::sprintf ("StripTrailingSlash (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QUrl_FormattingOption_Enum (const QUrl_FormattingOption_Enum *e)
{
  return (unsigned int) e->value ();
}

static QUrl_FormattingOption_Enum *from_i_QUrl_FormattingOption_Enum (unsigned int i)
{
  return new QUrl_FormattingOption_Enum ((QUrl::FormattingOption) i);
}

static bool equalQUrl_FormattingOption_Enum (const QUrl_FormattingOption_Enum *e, QUrl_FormattingOption_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QUrl_FormattingOption_Enum (const QUrl_FormattingOption_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QUrl_FormattingOption_Enums oropQUrl_FormattingOption_Enums (const QUrl_FormattingOption_Enums *e, const QUrl_FormattingOption_Enums &d)
{
  return e->flags () | d.flags ();
}

static QUrl_FormattingOption_Enums andopQUrl_FormattingOption_Enums (const QUrl_FormattingOption_Enums *e, const QUrl_FormattingOption_Enums &d)
{
  return e->flags () & d.flags ();
}

static QUrl_FormattingOption_Enums xoropQUrl_FormattingOption_Enums (const QUrl_FormattingOption_Enums *e, const QUrl_FormattingOption_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QUrl_FormattingOption_Enums (const QUrl_FormattingOption_Enums *e)
{
  std::string l;
  if (e->testFlag (QUrl::None)) { if (!l.empty ()) l += "|"; l += "None"; }
  if (e->testFlag (QUrl::RemoveScheme)) { if (!l.empty ()) l += "|"; l += "RemoveScheme"; }
  if (e->testFlag (QUrl::RemovePassword)) { if (!l.empty ()) l += "|"; l += "RemovePassword"; }
  if (e->testFlag (QUrl::RemoveUserInfo)) { if (!l.empty ()) l += "|"; l += "RemoveUserInfo"; }
  if (e->testFlag (QUrl::RemovePort)) { if (!l.empty ()) l += "|"; l += "RemovePort"; }
  if (e->testFlag (QUrl::RemoveAuthority)) { if (!l.empty ()) l += "|"; l += "RemoveAuthority"; }
  if (e->testFlag (QUrl::RemovePath)) { if (!l.empty ()) l += "|"; l += "RemovePath"; }
  if (e->testFlag (QUrl::RemoveQuery)) { if (!l.empty ()) l += "|"; l += "RemoveQuery"; }
  if (e->testFlag (QUrl::RemoveFragment)) { if (!l.empty ()) l += "|"; l += "RemoveFragment"; }
  if (e->testFlag (QUrl::StripTrailingSlash)) { if (!l.empty ()) l += "|"; l += "StripTrailingSlash"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QUrl_FormattingOption_Enums (const QUrl_FormattingOption_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QUrl_FormattingOption_Enums (const QUrl_FormattingOption_Enums *e, const QUrl_FormattingOption_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QUrl_FormattingOption_Enums> decl_QUrl_FormattingOption_Enums ("QUrl_QFlags_FormattingOption",
  gsi::method_ext ("|", &qt_gsi::oropQUrl_FormattingOption_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQUrl_FormattingOption_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQUrl_FormattingOption_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QUrl_FormattingOption_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QUrl_FormattingOption_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QUrl_FormattingOption_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QUrl::FormattingOption> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QUrl_FormattingOption_Enum> decl_QUrl_FormattingOption_Enum (decl_QUrl_FormattingOption_Enums, "QUrl_FormattingOption",
  qt_gsi::mkdefs_QUrl_FormattingOption () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QUrl_FormattingOption_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QUrl_FormattingOption_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQUrl_FormattingOption_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QUrl_FormattingOption_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QUrl_FormattingOption_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QUrl::FormattingOption enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QUrl> inject_QUrl_FormattingOption_Enum_in_parent (qt_gsi::mkdefs_QUrl_FormattingOption ());
static gsi::ClassExt<QUrl> decl_QUrl_FormattingOption_Enum_as_child (decl_QUrl_FormattingOption_Enum, "FormattingOption");

}


//  Implementation of the enum wrapper class for QUrl::ParsingMode
namespace qt_gsi
{

static QUrl_ParsingMode_Enum *c_1_QUrl_ParsingMode_Enum () { return new QUrl_ParsingMode_Enum (QUrl::TolerantMode); }
static QUrl_ParsingMode_Enum *c_2_QUrl_ParsingMode_Enum () { return new QUrl_ParsingMode_Enum (QUrl::StrictMode); }

static gsi::Methods mkdefs_QUrl_ParsingMode () {
  return
    gsi::constant ("TolerantMode", &qt_gsi::c_1_QUrl_ParsingMode_Enum, "@brief Enum constant QUrl::TolerantMode") +
    gsi::constant ("StrictMode", &qt_gsi::c_2_QUrl_ParsingMode_Enum, "@brief Enum constant QUrl::StrictMode");
}

static std::string to_s_QUrl_ParsingMode_Enum (const QUrl_ParsingMode_Enum *e)
{
  if (e->value () == QUrl::TolerantMode) { return tl::sprintf ("TolerantMode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QUrl::StrictMode) { return tl::sprintf ("StrictMode (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QUrl_ParsingMode_Enum (const QUrl_ParsingMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QUrl_ParsingMode_Enum *from_i_QUrl_ParsingMode_Enum (unsigned int i)
{
  return new QUrl_ParsingMode_Enum ((QUrl::ParsingMode) i);
}

static bool equalQUrl_ParsingMode_Enum (const QUrl_ParsingMode_Enum *e, QUrl_ParsingMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QUrl_ParsingMode_Enum (const QUrl_ParsingMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QUrl_ParsingMode_Enums oropQUrl_ParsingMode_Enums (const QUrl_ParsingMode_Enums *e, const QUrl_ParsingMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QUrl_ParsingMode_Enums andopQUrl_ParsingMode_Enums (const QUrl_ParsingMode_Enums *e, const QUrl_ParsingMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QUrl_ParsingMode_Enums xoropQUrl_ParsingMode_Enums (const QUrl_ParsingMode_Enums *e, const QUrl_ParsingMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QUrl_ParsingMode_Enums (const QUrl_ParsingMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QUrl::TolerantMode)) { if (!l.empty ()) l += "|"; l += "TolerantMode"; }
  if (e->testFlag (QUrl::StrictMode)) { if (!l.empty ()) l += "|"; l += "StrictMode"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QUrl_ParsingMode_Enums (const QUrl_ParsingMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QUrl_ParsingMode_Enums (const QUrl_ParsingMode_Enums *e, const QUrl_ParsingMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QUrl_ParsingMode_Enums> decl_QUrl_ParsingMode_Enums ("QUrl_QFlags_ParsingMode",
  gsi::method_ext ("|", &qt_gsi::oropQUrl_ParsingMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQUrl_ParsingMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQUrl_ParsingMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QUrl_ParsingMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QUrl_ParsingMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QUrl_ParsingMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QUrl::ParsingMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QUrl_ParsingMode_Enum> decl_QUrl_ParsingMode_Enum (decl_QUrl_ParsingMode_Enums, "QUrl_ParsingMode",
  qt_gsi::mkdefs_QUrl_ParsingMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QUrl_ParsingMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QUrl_ParsingMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQUrl_ParsingMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QUrl_ParsingMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QUrl_ParsingMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QUrl::ParsingMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QUrl> inject_QUrl_ParsingMode_Enum_in_parent (qt_gsi::mkdefs_QUrl_ParsingMode ());
static gsi::ClassExt<QUrl> decl_QUrl_ParsingMode_Enum_as_child (decl_QUrl_ParsingMode_Enum, "ParsingMode");

}

