
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTextLayout.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQTextLayout_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTextLayout

//  Constructor QTextLayout::QTextLayout()


static void _init_ctor_QTextLayout_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QTextLayout *> ();
}

static void _call_ctor_QTextLayout_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextLayout *> (new QTextLayout ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTextLayout_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextLayout::QTextLayout()\nThis method creates an object of class QTextLayout.", &_init_ctor_QTextLayout_0, &_call_ctor_QTextLayout_0);
}

//  Constructor QTextLayout::QTextLayout(const QString &text)


static void _init_ctor_QTextLayout_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return_new<QTextLayout *> ();
}

static void _call_ctor_QTextLayout_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QTextLayout *> (new QTextLayout (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTextLayout_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextLayout::QTextLayout(const QString &text)\nThis method creates an object of class QTextLayout.", &_init_ctor_QTextLayout_2025, &_call_ctor_QTextLayout_2025);
}

//  Constructor QTextLayout::QTextLayout(const QString &text, const QFont &font, QPaintDevice *paintdevice)


static void _init_ctor_QTextLayout_5413 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("font");
  decl->add_arg<const QFont & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("paintdevice", true, "0");
  decl->add_arg<QPaintDevice * > (argspec_2);
  decl->set_return_new<QTextLayout *> ();
}

static void _call_ctor_QTextLayout_5413 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QFont &arg2 = args.read<const QFont & > ();
  QPaintDevice *arg3 = args ? args.read<QPaintDevice * > () : (QPaintDevice *)(0);
  ret.write<QTextLayout *> (new QTextLayout (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTextLayout_5413 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextLayout::QTextLayout(const QString &text, const QFont &font, QPaintDevice *paintdevice)\nThis method creates an object of class QTextLayout.", &_init_ctor_QTextLayout_5413, &_call_ctor_QTextLayout_5413);
}

//  Constructor QTextLayout::QTextLayout(const QTextBlock &b)


static void _init_ctor_QTextLayout_2306 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return_new<QTextLayout *> ();
}

static void _call_ctor_QTextLayout_2306 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextBlock &arg1 = args.read<const QTextBlock & > ();
  ret.write<QTextLayout *> (new QTextLayout (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTextLayout_2306 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextLayout::QTextLayout(const QTextBlock &b)\nThis method creates an object of class QTextLayout.", &_init_ctor_QTextLayout_2306, &_call_ctor_QTextLayout_2306);
}

// QList<QTextLayout::FormatRange> QTextLayout::additionalFormats()


static void _init_f_additionalFormats_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QTextLayout::FormatRange> >::target_type > ();
}

static void _call_f_additionalFormats_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QTextLayout::FormatRange> >::target_type > ((qt_gsi::Converter<QList<QTextLayout::FormatRange> >::target_type)qt_gsi::CppToQtAdaptor<QList<QTextLayout::FormatRange> >(((QTextLayout *)cls)->additionalFormats ()));
}

static qt_gsi::GenericMethod *_create_f_additionalFormats_c0 ()
{
  return new qt_gsi::GenericMethod (":additionalFormats", "@brief Method QList<QTextLayout::FormatRange> QTextLayout::additionalFormats()\n", true, &_init_f_additionalFormats_c0, &_call_f_additionalFormats_c0);
}

// void QTextLayout::beginLayout()


static void _init_f_beginLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_beginLayout_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTextLayout *)cls)->beginLayout ();
}

static qt_gsi::GenericMethod *_create_f_beginLayout_0 ()
{
  return new qt_gsi::GenericMethod ("beginLayout", "@brief Method void QTextLayout::beginLayout()\n", false, &_init_f_beginLayout_0, &_call_f_beginLayout_0);
}

// QRectF QTextLayout::boundingRect()


static void _init_f_boundingRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_boundingRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRectF > ((QRectF)((QTextLayout *)cls)->boundingRect ());
}

static qt_gsi::GenericMethod *_create_f_boundingRect_c0 ()
{
  return new qt_gsi::GenericMethod ("boundingRect", "@brief Method QRectF QTextLayout::boundingRect()\n", true, &_init_f_boundingRect_c0, &_call_f_boundingRect_c0);
}

// bool QTextLayout::cacheEnabled()


static void _init_f_cacheEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_cacheEnabled_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextLayout *)cls)->cacheEnabled ());
}

static qt_gsi::GenericMethod *_create_f_cacheEnabled_c0 ()
{
  return new qt_gsi::GenericMethod (":cacheEnabled", "@brief Method bool QTextLayout::cacheEnabled()\n", true, &_init_f_cacheEnabled_c0, &_call_f_cacheEnabled_c0);
}

// void QTextLayout::clearAdditionalFormats()


static void _init_f_clearAdditionalFormats_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearAdditionalFormats_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTextLayout *)cls)->clearAdditionalFormats ();
}

static qt_gsi::GenericMethod *_create_f_clearAdditionalFormats_0 ()
{
  return new qt_gsi::GenericMethod ("clearAdditionalFormats", "@brief Method void QTextLayout::clearAdditionalFormats()\n", false, &_init_f_clearAdditionalFormats_0, &_call_f_clearAdditionalFormats_0);
}

// void QTextLayout::clearLayout()


static void _init_f_clearLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearLayout_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTextLayout *)cls)->clearLayout ();
}

static qt_gsi::GenericMethod *_create_f_clearLayout_0 ()
{
  return new qt_gsi::GenericMethod ("clearLayout", "@brief Method void QTextLayout::clearLayout()\n", false, &_init_f_clearLayout_0, &_call_f_clearLayout_0);
}

// QTextLine QTextLayout::createLine()


static void _init_f_createLine_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextLine > ();
}

static void _call_f_createLine_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextLine > ((QTextLine)((QTextLayout *)cls)->createLine ());
}

static qt_gsi::GenericMethod *_create_f_createLine_0 ()
{
  return new qt_gsi::GenericMethod ("createLine", "@brief Method QTextLine QTextLayout::createLine()\n", false, &_init_f_createLine_0, &_call_f_createLine_0);
}

// void QTextLayout::draw(QPainter *p, const QPointF &pos, const QVector<QTextLayout::FormatRange> &selections, const QRectF &clip)


static void _init_f_draw_c9459 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pos");
  decl->add_arg<const QPointF & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("selections", true, "QVector<QTextLayout::FormatRange>()");
  decl->add_arg<const qt_gsi::Converter<QVector<QTextLayout::FormatRange> >::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("clip", true, "QRectF()");
  decl->add_arg<const QRectF & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_draw_c9459 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QPointF &arg2 = args.read<const QPointF & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QVector<QTextLayout::FormatRange> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QVector<QTextLayout::FormatRange> >::target_type & > () : (const qt_gsi::Converter<QVector<QTextLayout::FormatRange> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QVector<QTextLayout::FormatRange> >(heap, QVector<QTextLayout::FormatRange>()));
  const QRectF &arg4 = args ? args.read<const QRectF & > () : (const QRectF &)(QRectF());
  ((QTextLayout *)cls)->draw (arg1, arg2, qt_gsi::QtToCppAdaptor<QVector<QTextLayout::FormatRange> >(arg3).cref(), arg4);
}

static qt_gsi::GenericMethod *_create_f_draw_c9459 ()
{
  return new qt_gsi::GenericMethod ("draw", "@brief Method void QTextLayout::draw(QPainter *p, const QPointF &pos, const QVector<QTextLayout::FormatRange> &selections, const QRectF &clip)\n", true, &_init_f_draw_c9459, &_call_f_draw_c9459);
}

// void QTextLayout::drawCursor(QPainter *p, const QPointF &pos, int cursorPosition)


static void _init_f_drawCursor_c3963 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pos");
  decl->add_arg<const QPointF & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("cursorPosition");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawCursor_c3963 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QPointF &arg2 = args.read<const QPointF & > ();
  int arg3 = args.read<int > ();
  ((QTextLayout *)cls)->drawCursor (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawCursor_c3963 ()
{
  return new qt_gsi::GenericMethod ("drawCursor", "@brief Method void QTextLayout::drawCursor(QPainter *p, const QPointF &pos, int cursorPosition)\n", true, &_init_f_drawCursor_c3963, &_call_f_drawCursor_c3963);
}

// void QTextLayout::drawCursor(QPainter *p, const QPointF &pos, int cursorPosition, int width)


static void _init_f_drawCursor_c4622 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pos");
  decl->add_arg<const QPointF & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("cursorPosition");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("width");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawCursor_c4622 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QPointF &arg2 = args.read<const QPointF & > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ((QTextLayout *)cls)->drawCursor (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_drawCursor_c4622 ()
{
  return new qt_gsi::GenericMethod ("drawCursor", "@brief Method void QTextLayout::drawCursor(QPainter *p, const QPointF &pos, int cursorPosition, int width)\n", true, &_init_f_drawCursor_c4622, &_call_f_drawCursor_c4622);
}

// void QTextLayout::endLayout()


static void _init_f_endLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_endLayout_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTextLayout *)cls)->endLayout ();
}

static qt_gsi::GenericMethod *_create_f_endLayout_0 ()
{
  return new qt_gsi::GenericMethod ("endLayout", "@brief Method void QTextLayout::endLayout()\n", false, &_init_f_endLayout_0, &_call_f_endLayout_0);
}

// QFont QTextLayout::font()


static void _init_f_font_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFont > ();
}

static void _call_f_font_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QFont > ((QFont)((QTextLayout *)cls)->font ());
}

static qt_gsi::GenericMethod *_create_f_font_c0 ()
{
  return new qt_gsi::GenericMethod (":font", "@brief Method QFont QTextLayout::font()\n", true, &_init_f_font_c0, &_call_f_font_c0);
}

// bool QTextLayout::isValidCursorPosition(int pos)


static void _init_f_isValidCursorPosition_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isValidCursorPosition_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<bool > ((bool)((QTextLayout *)cls)->isValidCursorPosition (arg1));
}

static qt_gsi::GenericMethod *_create_f_isValidCursorPosition_c767 ()
{
  return new qt_gsi::GenericMethod ("isValidCursorPosition?", "@brief Method bool QTextLayout::isValidCursorPosition(int pos)\n", true, &_init_f_isValidCursorPosition_c767, &_call_f_isValidCursorPosition_c767);
}

// QTextLine QTextLayout::lineAt(int i)


static void _init_f_lineAt_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTextLine > ();
}

static void _call_f_lineAt_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QTextLine > ((QTextLine)((QTextLayout *)cls)->lineAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_lineAt_c767 ()
{
  return new qt_gsi::GenericMethod ("lineAt", "@brief Method QTextLine QTextLayout::lineAt(int i)\n", true, &_init_f_lineAt_c767, &_call_f_lineAt_c767);
}

// int QTextLayout::lineCount()


static void _init_f_lineCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_lineCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextLayout *)cls)->lineCount ());
}

static qt_gsi::GenericMethod *_create_f_lineCount_c0 ()
{
  return new qt_gsi::GenericMethod ("lineCount", "@brief Method int QTextLayout::lineCount()\n", true, &_init_f_lineCount_c0, &_call_f_lineCount_c0);
}

// QTextLine QTextLayout::lineForTextPosition(int pos)


static void _init_f_lineForTextPosition_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTextLine > ();
}

static void _call_f_lineForTextPosition_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QTextLine > ((QTextLine)((QTextLayout *)cls)->lineForTextPosition (arg1));
}

static qt_gsi::GenericMethod *_create_f_lineForTextPosition_c767 ()
{
  return new qt_gsi::GenericMethod ("lineForTextPosition", "@brief Method QTextLine QTextLayout::lineForTextPosition(int pos)\n", true, &_init_f_lineForTextPosition_c767, &_call_f_lineForTextPosition_c767);
}

// double QTextLayout::maximumWidth()


static void _init_f_maximumWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_maximumWidth_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTextLayout *)cls)->maximumWidth ());
}

static qt_gsi::GenericMethod *_create_f_maximumWidth_c0 ()
{
  return new qt_gsi::GenericMethod ("maximumWidth", "@brief Method double QTextLayout::maximumWidth()\n", true, &_init_f_maximumWidth_c0, &_call_f_maximumWidth_c0);
}

// double QTextLayout::minimumWidth()


static void _init_f_minimumWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_minimumWidth_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTextLayout *)cls)->minimumWidth ());
}

static qt_gsi::GenericMethod *_create_f_minimumWidth_c0 ()
{
  return new qt_gsi::GenericMethod ("minimumWidth", "@brief Method double QTextLayout::minimumWidth()\n", true, &_init_f_minimumWidth_c0, &_call_f_minimumWidth_c0);
}

// int QTextLayout::nextCursorPosition(int oldPos, QTextLayout::CursorMode mode)


static void _init_f_nextCursorPosition_c3378 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("oldPos");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QTextLayout::SkipCharacters");
  decl->add_arg<const qt_gsi::Converter<QTextLayout::CursorMode>::target_type & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_nextCursorPosition_c3378 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<QTextLayout::CursorMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QTextLayout::CursorMode>::target_type & > () : (const qt_gsi::Converter<QTextLayout::CursorMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<QTextLayout::CursorMode>(heap, QTextLayout::SkipCharacters));
  ret.write<int > ((int)((QTextLayout *)cls)->nextCursorPosition (arg1, qt_gsi::QtToCppAdaptor<QTextLayout::CursorMode>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_nextCursorPosition_c3378 ()
{
  return new qt_gsi::GenericMethod ("nextCursorPosition", "@brief Method int QTextLayout::nextCursorPosition(int oldPos, QTextLayout::CursorMode mode)\n", true, &_init_f_nextCursorPosition_c3378, &_call_f_nextCursorPosition_c3378);
}

// QPointF QTextLayout::position()


static void _init_f_position_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_position_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPointF > ((QPointF)((QTextLayout *)cls)->position ());
}

static qt_gsi::GenericMethod *_create_f_position_c0 ()
{
  return new qt_gsi::GenericMethod (":position", "@brief Method QPointF QTextLayout::position()\n", true, &_init_f_position_c0, &_call_f_position_c0);
}

// int QTextLayout::preeditAreaPosition()


static void _init_f_preeditAreaPosition_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_preeditAreaPosition_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextLayout *)cls)->preeditAreaPosition ());
}

static qt_gsi::GenericMethod *_create_f_preeditAreaPosition_c0 ()
{
  return new qt_gsi::GenericMethod ("preeditAreaPosition", "@brief Method int QTextLayout::preeditAreaPosition()\n", true, &_init_f_preeditAreaPosition_c0, &_call_f_preeditAreaPosition_c0);
}

// QString QTextLayout::preeditAreaText()


static void _init_f_preeditAreaText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_preeditAreaText_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QTextLayout *)cls)->preeditAreaText ());
}

static qt_gsi::GenericMethod *_create_f_preeditAreaText_c0 ()
{
  return new qt_gsi::GenericMethod ("preeditAreaText", "@brief Method QString QTextLayout::preeditAreaText()\n", true, &_init_f_preeditAreaText_c0, &_call_f_preeditAreaText_c0);
}

// int QTextLayout::previousCursorPosition(int oldPos, QTextLayout::CursorMode mode)


static void _init_f_previousCursorPosition_c3378 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("oldPos");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QTextLayout::SkipCharacters");
  decl->add_arg<const qt_gsi::Converter<QTextLayout::CursorMode>::target_type & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_previousCursorPosition_c3378 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<QTextLayout::CursorMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QTextLayout::CursorMode>::target_type & > () : (const qt_gsi::Converter<QTextLayout::CursorMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<QTextLayout::CursorMode>(heap, QTextLayout::SkipCharacters));
  ret.write<int > ((int)((QTextLayout *)cls)->previousCursorPosition (arg1, qt_gsi::QtToCppAdaptor<QTextLayout::CursorMode>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_previousCursorPosition_c3378 ()
{
  return new qt_gsi::GenericMethod ("previousCursorPosition", "@brief Method int QTextLayout::previousCursorPosition(int oldPos, QTextLayout::CursorMode mode)\n", true, &_init_f_previousCursorPosition_c3378, &_call_f_previousCursorPosition_c3378);
}

// void QTextLayout::setAdditionalFormats(const QList<QTextLayout::FormatRange> &overrides)


static void _init_f_setAdditionalFormats_4294 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("overrides");
  decl->add_arg<const qt_gsi::Converter<QList<QTextLayout::FormatRange> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAdditionalFormats_4294 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QTextLayout::FormatRange> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QTextLayout::FormatRange> >::target_type & > ();
  ((QTextLayout *)cls)->setAdditionalFormats (qt_gsi::QtToCppAdaptor<QList<QTextLayout::FormatRange> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setAdditionalFormats_4294 ()
{
  return new qt_gsi::GenericMethod ("setAdditionalFormats|additionalFormats=", "@brief Method void QTextLayout::setAdditionalFormats(const QList<QTextLayout::FormatRange> &overrides)\n", false, &_init_f_setAdditionalFormats_4294, &_call_f_setAdditionalFormats_4294);
}

// void QTextLayout::setCacheEnabled(bool enable)


static void _init_f_setCacheEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCacheEnabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QTextLayout *)cls)->setCacheEnabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCacheEnabled_864 ()
{
  return new qt_gsi::GenericMethod ("setCacheEnabled|cacheEnabled=", "@brief Method void QTextLayout::setCacheEnabled(bool enable)\n", false, &_init_f_setCacheEnabled_864, &_call_f_setCacheEnabled_864);
}

// void QTextLayout::setFlags(int flags)


static void _init_f_setFlags_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFlags_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTextLayout *)cls)->setFlags (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFlags_767 ()
{
  return new qt_gsi::GenericMethod ("setFlags", "@brief Method void QTextLayout::setFlags(int flags)\n", false, &_init_f_setFlags_767, &_call_f_setFlags_767);
}

// void QTextLayout::setFont(const QFont &f)


static void _init_f_setFont_1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("f");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFont_1801 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QTextLayout *)cls)->setFont (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFont_1801 ()
{
  return new qt_gsi::GenericMethod ("setFont|font=", "@brief Method void QTextLayout::setFont(const QFont &f)\n", false, &_init_f_setFont_1801, &_call_f_setFont_1801);
}

// void QTextLayout::setPosition(const QPointF &p)


static void _init_f_setPosition_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPosition_1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ((QTextLayout *)cls)->setPosition (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPosition_1986 ()
{
  return new qt_gsi::GenericMethod ("setPosition|position=", "@brief Method void QTextLayout::setPosition(const QPointF &p)\n", false, &_init_f_setPosition_1986, &_call_f_setPosition_1986);
}

// void QTextLayout::setPreeditArea(int position, const QString &text)


static void _init_f_setPreeditArea_2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPreeditArea_2684 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QString &arg2 = args.read<const QString & > ();
  ((QTextLayout *)cls)->setPreeditArea (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setPreeditArea_2684 ()
{
  return new qt_gsi::GenericMethod ("setPreeditArea", "@brief Method void QTextLayout::setPreeditArea(int position, const QString &text)\n", false, &_init_f_setPreeditArea_2684, &_call_f_setPreeditArea_2684);
}

// void QTextLayout::setText(const QString &string)


static void _init_f_setText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setText_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QTextLayout *)cls)->setText (arg1);
}

static qt_gsi::GenericMethod *_create_f_setText_2025 ()
{
  return new qt_gsi::GenericMethod ("setText|text=", "@brief Method void QTextLayout::setText(const QString &string)\n", false, &_init_f_setText_2025, &_call_f_setText_2025);
}

// void QTextLayout::setTextOption(const QTextOption &option)


static void _init_f_setTextOption_2448 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const QTextOption & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextOption_2448 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextOption &arg1 = args.read<const QTextOption & > ();
  ((QTextLayout *)cls)->setTextOption (arg1);
}

static qt_gsi::GenericMethod *_create_f_setTextOption_2448 ()
{
  return new qt_gsi::GenericMethod ("setTextOption|textOption=", "@brief Method void QTextLayout::setTextOption(const QTextOption &option)\n", false, &_init_f_setTextOption_2448, &_call_f_setTextOption_2448);
}

// QString QTextLayout::text()


static void _init_f_text_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_text_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QTextLayout *)cls)->text ());
}

static qt_gsi::GenericMethod *_create_f_text_c0 ()
{
  return new qt_gsi::GenericMethod (":text", "@brief Method QString QTextLayout::text()\n", true, &_init_f_text_c0, &_call_f_text_c0);
}

// QTextOption QTextLayout::textOption()


static void _init_f_textOption_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextOption > ();
}

static void _call_f_textOption_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextOption > ((QTextOption)((QTextLayout *)cls)->textOption ());
}

static qt_gsi::GenericMethod *_create_f_textOption_c0 ()
{
  return new qt_gsi::GenericMethod (":textOption", "@brief Method QTextOption QTextLayout::textOption()\n", true, &_init_f_textOption_c0, &_call_f_textOption_c0);
}


namespace gsi
{
gsi::Class<QTextLayout> decl_QTextLayout ("QTextLayout",
  gsi::Methods(_create_ctor_QTextLayout_0 ()) +
  gsi::Methods(_create_ctor_QTextLayout_2025 ()) +
  gsi::Methods(_create_ctor_QTextLayout_5413 ()) +
  gsi::Methods(_create_ctor_QTextLayout_2306 ()) +
  gsi::Methods(_create_f_additionalFormats_c0 ()) +
  gsi::Methods(_create_f_beginLayout_0 ()) +
  gsi::Methods(_create_f_boundingRect_c0 ()) +
  gsi::Methods(_create_f_cacheEnabled_c0 ()) +
  gsi::Methods(_create_f_clearAdditionalFormats_0 ()) +
  gsi::Methods(_create_f_clearLayout_0 ()) +
  gsi::Methods(_create_f_createLine_0 ()) +
  gsi::Methods(_create_f_draw_c9459 ()) +
  gsi::Methods(_create_f_drawCursor_c3963 ()) +
  gsi::Methods(_create_f_drawCursor_c4622 ()) +
  gsi::Methods(_create_f_endLayout_0 ()) +
  gsi::Methods(_create_f_font_c0 ()) +
  gsi::Methods(_create_f_isValidCursorPosition_c767 ()) +
  gsi::Methods(_create_f_lineAt_c767 ()) +
  gsi::Methods(_create_f_lineCount_c0 ()) +
  gsi::Methods(_create_f_lineForTextPosition_c767 ()) +
  gsi::Methods(_create_f_maximumWidth_c0 ()) +
  gsi::Methods(_create_f_minimumWidth_c0 ()) +
  gsi::Methods(_create_f_nextCursorPosition_c3378 ()) +
  gsi::Methods(_create_f_position_c0 ()) +
  gsi::Methods(_create_f_preeditAreaPosition_c0 ()) +
  gsi::Methods(_create_f_preeditAreaText_c0 ()) +
  gsi::Methods(_create_f_previousCursorPosition_c3378 ()) +
  gsi::Methods(_create_f_setAdditionalFormats_4294 ()) +
  gsi::Methods(_create_f_setCacheEnabled_864 ()) +
  gsi::Methods(_create_f_setFlags_767 ()) +
  gsi::Methods(_create_f_setFont_1801 ()) +
  gsi::Methods(_create_f_setPosition_1986 ()) +
  gsi::Methods(_create_f_setPreeditArea_2684 ()) +
  gsi::Methods(_create_f_setText_2025 ()) +
  gsi::Methods(_create_f_setTextOption_2448 ()) +
  gsi::Methods(_create_f_text_c0 ()) +
  gsi::Methods(_create_f_textOption_c0 ()),
  "@qt\n@brief Binding of QTextLayout");

}


//  Implementation of the enum wrapper class for QTextLayout::CursorMode
namespace qt_gsi
{

static QTextLayout_CursorMode_Enum *c_1_QTextLayout_CursorMode_Enum () { return new QTextLayout_CursorMode_Enum (QTextLayout::SkipCharacters); }
static QTextLayout_CursorMode_Enum *c_2_QTextLayout_CursorMode_Enum () { return new QTextLayout_CursorMode_Enum (QTextLayout::SkipWords); }

static gsi::Methods mkdefs_QTextLayout_CursorMode () {
  return
    gsi::constant ("SkipCharacters", &qt_gsi::c_1_QTextLayout_CursorMode_Enum, "@brief Enum constant QTextLayout::SkipCharacters") +
    gsi::constant ("SkipWords", &qt_gsi::c_2_QTextLayout_CursorMode_Enum, "@brief Enum constant QTextLayout::SkipWords");
}

static std::string to_s_QTextLayout_CursorMode_Enum (const QTextLayout_CursorMode_Enum *e)
{
  if (e->value () == QTextLayout::SkipCharacters) { return tl::sprintf ("SkipCharacters (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextLayout::SkipWords) { return tl::sprintf ("SkipWords (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QTextLayout_CursorMode_Enum (const QTextLayout_CursorMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QTextLayout_CursorMode_Enum *from_i_QTextLayout_CursorMode_Enum (unsigned int i)
{
  return new QTextLayout_CursorMode_Enum ((QTextLayout::CursorMode) i);
}

static bool equalQTextLayout_CursorMode_Enum (const QTextLayout_CursorMode_Enum *e, QTextLayout_CursorMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QTextLayout_CursorMode_Enum (const QTextLayout_CursorMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QTextLayout_CursorMode_Enums oropQTextLayout_CursorMode_Enums (const QTextLayout_CursorMode_Enums *e, const QTextLayout_CursorMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QTextLayout_CursorMode_Enums andopQTextLayout_CursorMode_Enums (const QTextLayout_CursorMode_Enums *e, const QTextLayout_CursorMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QTextLayout_CursorMode_Enums xoropQTextLayout_CursorMode_Enums (const QTextLayout_CursorMode_Enums *e, const QTextLayout_CursorMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QTextLayout_CursorMode_Enums (const QTextLayout_CursorMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QTextLayout::SkipCharacters)) { if (!l.empty ()) l += "|"; l += "SkipCharacters"; }
  if (e->testFlag (QTextLayout::SkipWords)) { if (!l.empty ()) l += "|"; l += "SkipWords"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QTextLayout_CursorMode_Enums (const QTextLayout_CursorMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QTextLayout_CursorMode_Enums (const QTextLayout_CursorMode_Enums *e, const QTextLayout_CursorMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QTextLayout_CursorMode_Enums> decl_QTextLayout_CursorMode_Enums ("QTextLayout_QFlags_CursorMode",
  gsi::method_ext ("|", &qt_gsi::oropQTextLayout_CursorMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQTextLayout_CursorMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQTextLayout_CursorMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextLayout_CursorMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextLayout_CursorMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QTextLayout_CursorMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QTextLayout::CursorMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QTextLayout_CursorMode_Enum> decl_QTextLayout_CursorMode_Enum (decl_QTextLayout_CursorMode_Enums, "QTextLayout_CursorMode",
  qt_gsi::mkdefs_QTextLayout_CursorMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextLayout_CursorMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextLayout_CursorMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQTextLayout_CursorMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QTextLayout_CursorMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QTextLayout_CursorMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QTextLayout::CursorMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextLayout> inject_QTextLayout_CursorMode_Enum_in_parent (qt_gsi::mkdefs_QTextLayout_CursorMode ());
static gsi::ClassExt<QTextLayout> decl_QTextLayout_CursorMode_Enum_as_child (decl_QTextLayout_CursorMode_Enum, "CursorMode");

}

