
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQStandardItemModel.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQStandardItemModel_EventAdaptor.h"
#include "gsiDeclQStandardItemModel_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QStandardItemModel

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QStandardItemModel::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// void QStandardItemModel::appendColumn(const QList<QStandardItem *> &items)


static void _init_f_appendColumn_3411 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("items");
  decl->add_arg<const qt_gsi::Converter<QList<QStandardItem *> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_appendColumn_3411 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QStandardItem *> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QStandardItem *> >::target_type & > ();
  ((QStandardItemModel *)cls)->appendColumn (qt_gsi::QtToCppAdaptor<QList<QStandardItem *> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_appendColumn_3411 ()
{
  return new qt_gsi::GenericMethod ("appendColumn", "@brief Method void QStandardItemModel::appendColumn(const QList<QStandardItem *> &items)\n", false, &_init_f_appendColumn_3411, &_call_f_appendColumn_3411);
}

// void QStandardItemModel::appendRow(const QList<QStandardItem *> &items)


static void _init_f_appendRow_3411 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("items");
  decl->add_arg<const qt_gsi::Converter<QList<QStandardItem *> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_appendRow_3411 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QStandardItem *> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QStandardItem *> >::target_type & > ();
  ((QStandardItemModel *)cls)->appendRow (qt_gsi::QtToCppAdaptor<QList<QStandardItem *> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_appendRow_3411 ()
{
  return new qt_gsi::GenericMethod ("appendRow", "@brief Method void QStandardItemModel::appendRow(const QList<QStandardItem *> &items)\n", false, &_init_f_appendRow_3411, &_call_f_appendRow_3411);
}

// void QStandardItemModel::appendRow(QStandardItem *item)


static void _init_f_appendRow_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QStandardItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_appendRow_1919 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStandardItem *arg1 = args.read<QStandardItem * > ();
  ((QStandardItemModel *)cls)->appendRow (arg1);
}

static qt_gsi::GenericMethod *_create_f_appendRow_1919 ()
{
  return new qt_gsi::GenericMethod ("appendRow", "@brief Method void QStandardItemModel::appendRow(QStandardItem *item)\n", false, &_init_f_appendRow_1919, &_call_f_appendRow_1919);
}

// void QStandardItemModel::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QStandardItemModel *)cls)->clear ();
}

static qt_gsi::GenericMethod *_create_f_clear_0 ()
{
  return new qt_gsi::GenericMethod ("clear", "@brief Method void QStandardItemModel::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
}

// int QStandardItemModel::columnCount(const QModelIndex &parent)


static void _init_f_columnCount_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_columnCount_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<int > ((int)((QStandardItemModel *)cls)->columnCount (arg1));
}

static qt_gsi::GenericMethod *_create_f_columnCount_c2395 ()
{
  return new qt_gsi::GenericMethod ("columnCount", "@brief Method int QStandardItemModel::columnCount(const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::columnCount", true, &_init_f_columnCount_c2395, &_call_f_columnCount_c2395);
}

// QVariant QStandardItemModel::data(const QModelIndex &index, int role)


static void _init_f_data_c3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role", true, "Qt::DisplayRole");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_f_data_c3054 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args ? args.read<int > () : (int)(Qt::DisplayRole);
  ret.write<QVariant > ((QVariant)((QStandardItemModel *)cls)->data (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_data_c3054 ()
{
  return new qt_gsi::GenericMethod ("data", "@brief Method QVariant QStandardItemModel::data(const QModelIndex &index, int role)\nThis is a reimplementation of QAbstractItemModel::data", true, &_init_f_data_c3054, &_call_f_data_c3054);
}

// bool QStandardItemModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)


static void _init_f_dropMimeData_7425 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_f_dropMimeData_7425 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMimeData *arg1 = args.read<const QMimeData * > ();
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  const QModelIndex &arg5 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QStandardItemModel *)cls)->dropMimeData (arg1, qt_gsi::QtToCppAdaptor<Qt::DropAction>(arg2).cref(), arg3, arg4, arg5));
}

static qt_gsi::GenericMethod *_create_f_dropMimeData_7425 ()
{
  return new qt_gsi::GenericMethod ("dropMimeData", "@brief Method bool QStandardItemModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::dropMimeData", false, &_init_f_dropMimeData_7425, &_call_f_dropMimeData_7425);
}

// QList<QStandardItem *> QStandardItemModel::findItems(const QString &text, QFlags<Qt::MatchFlag> flags, int column)


static void _init_f_findItems_c4892 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "Qt::MatchExactly");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("column", true, "0");
  decl->add_arg<int > (argspec_2);
  decl->set_return<qt_gsi::Converter<QList<QStandardItem *> >::target_type > ();
}

static void _call_f_findItems_c4892 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::MatchFlag> >(heap, Qt::MatchExactly));
  int arg3 = args ? args.read<int > () : (int)(0);
  ret.write<qt_gsi::Converter<QList<QStandardItem *> >::target_type > ((qt_gsi::Converter<QList<QStandardItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QStandardItem *> >(((QStandardItemModel *)cls)->findItems (arg1, qt_gsi::QtToCppAdaptor<QFlags<Qt::MatchFlag> >(arg2).cref(), arg3)));
}

static qt_gsi::GenericMethod *_create_f_findItems_c4892 ()
{
  return new qt_gsi::GenericMethod ("findItems", "@brief Method QList<QStandardItem *> QStandardItemModel::findItems(const QString &text, QFlags<Qt::MatchFlag> flags, int column)\n", true, &_init_f_findItems_c4892, &_call_f_findItems_c4892);
}

// QFlags<Qt::ItemFlag> QStandardItemModel::flags(const QModelIndex &index)


static void _init_f_flags_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type > ();
}

static void _call_f_flags_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type > ((qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::ItemFlag> >(((QStandardItemModel *)cls)->flags (arg1)));
}

static qt_gsi::GenericMethod *_create_f_flags_c2395 ()
{
  return new qt_gsi::GenericMethod ("flags", "@brief Method QFlags<Qt::ItemFlag> QStandardItemModel::flags(const QModelIndex &index)\nThis is a reimplementation of QAbstractItemModel::flags", true, &_init_f_flags_c2395, &_call_f_flags_c2395);
}

// bool QStandardItemModel::hasChildren(const QModelIndex &parent)


static void _init_f_hasChildren_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasChildren_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<bool > ((bool)((QStandardItemModel *)cls)->hasChildren (arg1));
}

static qt_gsi::GenericMethod *_create_f_hasChildren_c2395 ()
{
  return new qt_gsi::GenericMethod ("hasChildren", "@brief Method bool QStandardItemModel::hasChildren(const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::hasChildren", true, &_init_f_hasChildren_c2395, &_call_f_hasChildren_c2395);
}

// QVariant QStandardItemModel::headerData(int section, Qt::Orientation orientation, int role)


static void _init_f_headerData_c3231 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role", true, "Qt::DisplayRole");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_f_headerData_c3231 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  int arg3 = args ? args.read<int > () : (int)(Qt::DisplayRole);
  ret.write<QVariant > ((QVariant)((QStandardItemModel *)cls)->headerData (arg1, qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg2).cref(), arg3));
}

static qt_gsi::GenericMethod *_create_f_headerData_c3231 ()
{
  return new qt_gsi::GenericMethod ("headerData", "@brief Method QVariant QStandardItemModel::headerData(int section, Qt::Orientation orientation, int role)\nThis is a reimplementation of QAbstractItemModel::headerData", true, &_init_f_headerData_c3231, &_call_f_headerData_c3231);
}

// QStandardItem *QStandardItemModel::horizontalHeaderItem(int column)


static void _init_f_horizontalHeaderItem_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QStandardItem * > ();
}

static void _call_f_horizontalHeaderItem_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QStandardItem * > ((QStandardItem *)((QStandardItemModel *)cls)->horizontalHeaderItem (arg1));
}

static qt_gsi::GenericMethod *_create_f_horizontalHeaderItem_c767 ()
{
  return new qt_gsi::GenericMethod ("horizontalHeaderItem", "@brief Method QStandardItem *QStandardItemModel::horizontalHeaderItem(int column)\n", true, &_init_f_horizontalHeaderItem_c767, &_call_f_horizontalHeaderItem_c767);
}

// QModelIndex QStandardItemModel::index(int row, int column, const QModelIndex &parent)


static void _init_f_index_c3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_f_index_c3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<QModelIndex > ((QModelIndex)((QStandardItemModel *)cls)->index (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_index_c3713 ()
{
  return new qt_gsi::GenericMethod ("index", "@brief Method QModelIndex QStandardItemModel::index(int row, int column, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::index", true, &_init_f_index_c3713, &_call_f_index_c3713);
}

// QModelIndex QStandardItemModel::indexFromItem(const QStandardItem *item)


static void _init_f_indexFromItem_c2614 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QStandardItem * > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_indexFromItem_c2614 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QStandardItem *arg1 = args.read<const QStandardItem * > ();
  ret.write<QModelIndex > ((QModelIndex)((QStandardItemModel *)cls)->indexFromItem (arg1));
}

static qt_gsi::GenericMethod *_create_f_indexFromItem_c2614 ()
{
  return new qt_gsi::GenericMethod ("indexFromItem", "@brief Method QModelIndex QStandardItemModel::indexFromItem(const QStandardItem *item)\n", true, &_init_f_indexFromItem_c2614, &_call_f_indexFromItem_c2614);
}

// void QStandardItemModel::insertColumn(int column, const QList<QStandardItem *> &items)


static void _init_f_insertColumn_4070 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("items");
  decl->add_arg<const qt_gsi::Converter<QList<QStandardItem *> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertColumn_4070 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<QList<QStandardItem *> >::target_type & arg2 = args.read<const qt_gsi::Converter<QList<QStandardItem *> >::target_type & > ();
  ((QStandardItemModel *)cls)->insertColumn (arg1, qt_gsi::QtToCppAdaptor<QList<QStandardItem *> >(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_insertColumn_4070 ()
{
  return new qt_gsi::GenericMethod ("insertColumn", "@brief Method void QStandardItemModel::insertColumn(int column, const QList<QStandardItem *> &items)\n", false, &_init_f_insertColumn_4070, &_call_f_insertColumn_4070);
}

// bool QStandardItemModel::insertColumn(int column, const QModelIndex &parent)


static void _init_f_insertColumn_3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_insertColumn_3054 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QModelIndex &arg2 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<bool > ((bool)((QStandardItemModel *)cls)->insertColumn (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_insertColumn_3054 ()
{
  return new qt_gsi::GenericMethod ("insertColumn", "@brief Method bool QStandardItemModel::insertColumn(int column, const QModelIndex &parent)\n", false, &_init_f_insertColumn_3054, &_call_f_insertColumn_3054);
}

// bool QStandardItemModel::insertColumns(int column, int count, const QModelIndex &parent)


static void _init_f_insertColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_insertColumns_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<bool > ((bool)((QStandardItemModel *)cls)->insertColumns (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_insertColumns_3713 ()
{
  return new qt_gsi::GenericMethod ("insertColumns", "@brief Method bool QStandardItemModel::insertColumns(int column, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::insertColumns", false, &_init_f_insertColumns_3713, &_call_f_insertColumns_3713);
}

// void QStandardItemModel::insertRow(int row, const QList<QStandardItem *> &items)


static void _init_f_insertRow_4070 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("items");
  decl->add_arg<const qt_gsi::Converter<QList<QStandardItem *> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertRow_4070 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<QList<QStandardItem *> >::target_type & arg2 = args.read<const qt_gsi::Converter<QList<QStandardItem *> >::target_type & > ();
  ((QStandardItemModel *)cls)->insertRow (arg1, qt_gsi::QtToCppAdaptor<QList<QStandardItem *> >(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_insertRow_4070 ()
{
  return new qt_gsi::GenericMethod ("insertRow", "@brief Method void QStandardItemModel::insertRow(int row, const QList<QStandardItem *> &items)\n", false, &_init_f_insertRow_4070, &_call_f_insertRow_4070);
}

// void QStandardItemModel::insertRow(int row, QStandardItem *item)


static void _init_f_insertRow_2578 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("item");
  decl->add_arg<QStandardItem * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertRow_2578 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QStandardItem *arg2 = args.read<QStandardItem * > ();
  ((QStandardItemModel *)cls)->insertRow (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_insertRow_2578 ()
{
  return new qt_gsi::GenericMethod ("insertRow", "@brief Method void QStandardItemModel::insertRow(int row, QStandardItem *item)\n", false, &_init_f_insertRow_2578, &_call_f_insertRow_2578);
}

// bool QStandardItemModel::insertRow(int row, const QModelIndex &parent)


static void _init_f_insertRow_3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_insertRow_3054 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QModelIndex &arg2 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<bool > ((bool)((QStandardItemModel *)cls)->insertRow (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_insertRow_3054 ()
{
  return new qt_gsi::GenericMethod ("insertRow", "@brief Method bool QStandardItemModel::insertRow(int row, const QModelIndex &parent)\n", false, &_init_f_insertRow_3054, &_call_f_insertRow_3054);
}

// bool QStandardItemModel::insertRows(int row, int count, const QModelIndex &parent)


static void _init_f_insertRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_insertRows_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<bool > ((bool)((QStandardItemModel *)cls)->insertRows (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_insertRows_3713 ()
{
  return new qt_gsi::GenericMethod ("insertRows", "@brief Method bool QStandardItemModel::insertRows(int row, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::insertRows", false, &_init_f_insertRows_3713, &_call_f_insertRows_3713);
}

// QStandardItem *QStandardItemModel::invisibleRootItem()


static void _init_f_invisibleRootItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStandardItem * > ();
}

static void _call_f_invisibleRootItem_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QStandardItem * > ((QStandardItem *)((QStandardItemModel *)cls)->invisibleRootItem ());
}

static qt_gsi::GenericMethod *_create_f_invisibleRootItem_c0 ()
{
  return new qt_gsi::GenericMethod ("invisibleRootItem", "@brief Method QStandardItem *QStandardItemModel::invisibleRootItem()\n", true, &_init_f_invisibleRootItem_c0, &_call_f_invisibleRootItem_c0);
}

// QStandardItem *QStandardItemModel::item(int row, int column)


static void _init_f_item_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column", true, "0");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QStandardItem * > ();
}

static void _call_f_item_c1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args ? args.read<int > () : (int)(0);
  ret.write<QStandardItem * > ((QStandardItem *)((QStandardItemModel *)cls)->item (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_item_c1426 ()
{
  return new qt_gsi::GenericMethod ("item", "@brief Method QStandardItem *QStandardItemModel::item(int row, int column)\n", true, &_init_f_item_c1426, &_call_f_item_c1426);
}

// QStandardItem *QStandardItemModel::itemFromIndex(const QModelIndex &index)


static void _init_f_itemFromIndex_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QStandardItem * > ();
}

static void _call_f_itemFromIndex_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QStandardItem * > ((QStandardItem *)((QStandardItemModel *)cls)->itemFromIndex (arg1));
}

static qt_gsi::GenericMethod *_create_f_itemFromIndex_c2395 ()
{
  return new qt_gsi::GenericMethod ("itemFromIndex", "@brief Method QStandardItem *QStandardItemModel::itemFromIndex(const QModelIndex &index)\n", true, &_init_f_itemFromIndex_c2395, &_call_f_itemFromIndex_c2395);
}

// const QStandardItem *QStandardItemModel::itemPrototype()


static void _init_f_itemPrototype_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QStandardItem * > ();
}

static void _call_f_itemPrototype_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QStandardItem * > ((const QStandardItem *)((QStandardItemModel *)cls)->itemPrototype ());
}

static qt_gsi::GenericMethod *_create_f_itemPrototype_c0 ()
{
  return new qt_gsi::GenericMethod (":itemPrototype", "@brief Method const QStandardItem *QStandardItemModel::itemPrototype()\n", true, &_init_f_itemPrototype_c0, &_call_f_itemPrototype_c0);
}

// QMimeData *QStandardItemModel::mimeData(const QList<QModelIndex> &indexes)


static void _init_f_mimeData_c3010 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > (argspec_0);
  decl->set_return<QMimeData * > ();
}

static void _call_f_mimeData_c3010 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QModelIndex> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > ();
  ret.write<QMimeData * > ((QMimeData *)((QStandardItemModel *)cls)->mimeData (qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_mimeData_c3010 ()
{
  return new qt_gsi::GenericMethod ("mimeData", "@brief Method QMimeData *QStandardItemModel::mimeData(const QList<QModelIndex> &indexes)\nThis is a reimplementation of QAbstractItemModel::mimeData", true, &_init_f_mimeData_c3010, &_call_f_mimeData_c3010);
}

// QStringList QStandardItemModel::mimeTypes()


static void _init_f_mimeTypes_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_mimeTypes_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QStandardItemModel *)cls)->mimeTypes ()));
}

static qt_gsi::GenericMethod *_create_f_mimeTypes_c0 ()
{
  return new qt_gsi::GenericMethod ("mimeTypes", "@brief Method QStringList QStandardItemModel::mimeTypes()\nThis is a reimplementation of QAbstractItemModel::mimeTypes", true, &_init_f_mimeTypes_c0, &_call_f_mimeTypes_c0);
}

// QModelIndex QStandardItemModel::parent(const QModelIndex &child)


static void _init_f_parent_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("child");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_parent_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QModelIndex > ((QModelIndex)((QStandardItemModel *)cls)->parent (arg1));
}

static qt_gsi::GenericMethod *_create_f_parent_c2395 ()
{
  return new qt_gsi::GenericMethod ("parent", "@brief Method QModelIndex QStandardItemModel::parent(const QModelIndex &child)\nThis is a reimplementation of QAbstractItemModel::parent", true, &_init_f_parent_c2395, &_call_f_parent_c2395);
}

// QObject *QStandardItemModel::parent()


static void _init_f_parent_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_f_parent_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QStandardItemModel *)cls)->parent ());
}

static qt_gsi::GenericMethod *_create_f_parent_c0 ()
{
  return new qt_gsi::GenericMethod (":parent", "@brief Method QObject *QStandardItemModel::parent()\n", true, &_init_f_parent_c0, &_call_f_parent_c0);
}

// bool QStandardItemModel::removeColumns(int column, int count, const QModelIndex &parent)


static void _init_f_removeColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_removeColumns_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<bool > ((bool)((QStandardItemModel *)cls)->removeColumns (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_removeColumns_3713 ()
{
  return new qt_gsi::GenericMethod ("removeColumns", "@brief Method bool QStandardItemModel::removeColumns(int column, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::removeColumns", false, &_init_f_removeColumns_3713, &_call_f_removeColumns_3713);
}

// bool QStandardItemModel::removeRows(int row, int count, const QModelIndex &parent)


static void _init_f_removeRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_removeRows_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<bool > ((bool)((QStandardItemModel *)cls)->removeRows (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_removeRows_3713 ()
{
  return new qt_gsi::GenericMethod ("removeRows", "@brief Method bool QStandardItemModel::removeRows(int row, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::removeRows", false, &_init_f_removeRows_3713, &_call_f_removeRows_3713);
}

// int QStandardItemModel::rowCount(const QModelIndex &parent)


static void _init_f_rowCount_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_rowCount_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<int > ((int)((QStandardItemModel *)cls)->rowCount (arg1));
}

static qt_gsi::GenericMethod *_create_f_rowCount_c2395 ()
{
  return new qt_gsi::GenericMethod ("rowCount", "@brief Method int QStandardItemModel::rowCount(const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::rowCount", true, &_init_f_rowCount_c2395, &_call_f_rowCount_c2395);
}

// void QStandardItemModel::setColumnCount(int columns)


static void _init_f_setColumnCount_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("columns");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setColumnCount_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QStandardItemModel *)cls)->setColumnCount (arg1);
}

static qt_gsi::GenericMethod *_create_f_setColumnCount_767 ()
{
  return new qt_gsi::GenericMethod ("setColumnCount|columnCount=", "@brief Method void QStandardItemModel::setColumnCount(int columns)\n", false, &_init_f_setColumnCount_767, &_call_f_setColumnCount_767);
}

// bool QStandardItemModel::setData(const QModelIndex &index, const QVariant &value, int role)


static void _init_f_setData_5065 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role", true, "Qt::EditRole");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_setData_5065 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  int arg3 = args ? args.read<int > () : (int)(Qt::EditRole);
  ret.write<bool > ((bool)((QStandardItemModel *)cls)->setData (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_setData_5065 ()
{
  return new qt_gsi::GenericMethod ("setData", "@brief Method bool QStandardItemModel::setData(const QModelIndex &index, const QVariant &value, int role)\nThis is a reimplementation of QAbstractItemModel::setData", false, &_init_f_setData_5065, &_call_f_setData_5065);
}

// bool QStandardItemModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)


static void _init_f_setHeaderData_5242 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("role", true, "Qt::EditRole");
  decl->add_arg<int > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_setHeaderData_5242 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  const QVariant &arg3 = args.read<const QVariant & > ();
  int arg4 = args ? args.read<int > () : (int)(Qt::EditRole);
  ret.write<bool > ((bool)((QStandardItemModel *)cls)->setHeaderData (arg1, qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg2).cref(), arg3, arg4));
}

static qt_gsi::GenericMethod *_create_f_setHeaderData_5242 ()
{
  return new qt_gsi::GenericMethod ("setHeaderData", "@brief Method bool QStandardItemModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)\nThis is a reimplementation of QAbstractItemModel::setHeaderData", false, &_init_f_setHeaderData_5242, &_call_f_setHeaderData_5242);
}

// void QStandardItemModel::setHorizontalHeaderItem(int column, QStandardItem *item)


static void _init_f_setHorizontalHeaderItem_2578 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("item");
  decl->add_arg<QStandardItem * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setHorizontalHeaderItem_2578 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QStandardItem *arg2 = args.read<QStandardItem * > ();
  ((QStandardItemModel *)cls)->setHorizontalHeaderItem (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setHorizontalHeaderItem_2578 ()
{
  return new qt_gsi::GenericMethod ("setHorizontalHeaderItem", "@brief Method void QStandardItemModel::setHorizontalHeaderItem(int column, QStandardItem *item)\n", false, &_init_f_setHorizontalHeaderItem_2578, &_call_f_setHorizontalHeaderItem_2578);
}

// void QStandardItemModel::setHorizontalHeaderLabels(const QStringList &labels)


static void _init_f_setHorizontalHeaderLabels_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("labels");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHorizontalHeaderLabels_2437 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStringList>::target_type & arg1 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  ((QStandardItemModel *)cls)->setHorizontalHeaderLabels (qt_gsi::QtToCppAdaptor<QStringList>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setHorizontalHeaderLabels_2437 ()
{
  return new qt_gsi::GenericMethod ("setHorizontalHeaderLabels", "@brief Method void QStandardItemModel::setHorizontalHeaderLabels(const QStringList &labels)\n", false, &_init_f_setHorizontalHeaderLabels_2437, &_call_f_setHorizontalHeaderLabels_2437);
}

// void QStandardItemModel::setItem(int row, int column, QStandardItem *item)


static void _init_f_setItem_3237 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("item");
  decl->add_arg<QStandardItem * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setItem_3237 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  QStandardItem *arg3 = args.read<QStandardItem * > ();
  ((QStandardItemModel *)cls)->setItem (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_setItem_3237 ()
{
  return new qt_gsi::GenericMethod ("setItem", "@brief Method void QStandardItemModel::setItem(int row, int column, QStandardItem *item)\n", false, &_init_f_setItem_3237, &_call_f_setItem_3237);
}

// void QStandardItemModel::setItem(int row, QStandardItem *item)


static void _init_f_setItem_2578 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("item");
  decl->add_arg<QStandardItem * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setItem_2578 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QStandardItem *arg2 = args.read<QStandardItem * > ();
  ((QStandardItemModel *)cls)->setItem (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setItem_2578 ()
{
  return new qt_gsi::GenericMethod ("setItem", "@brief Method void QStandardItemModel::setItem(int row, QStandardItem *item)\n", false, &_init_f_setItem_2578, &_call_f_setItem_2578);
}

// void QStandardItemModel::setItemPrototype(const QStandardItem *item)


static void _init_f_setItemPrototype_2614 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QStandardItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setItemPrototype_2614 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QStandardItem *arg1 = args.read<const QStandardItem * > ();
  ((QStandardItemModel *)cls)->setItemPrototype (arg1);
}

static qt_gsi::GenericMethod *_create_f_setItemPrototype_2614 ()
{
  return new qt_gsi::GenericMethod ("setItemPrototype|itemPrototype=", "@brief Method void QStandardItemModel::setItemPrototype(const QStandardItem *item)\n", false, &_init_f_setItemPrototype_2614, &_call_f_setItemPrototype_2614);
}

// void QStandardItemModel::setRowCount(int rows)


static void _init_f_setRowCount_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rows");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRowCount_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QStandardItemModel *)cls)->setRowCount (arg1);
}

static qt_gsi::GenericMethod *_create_f_setRowCount_767 ()
{
  return new qt_gsi::GenericMethod ("setRowCount|rowCount=", "@brief Method void QStandardItemModel::setRowCount(int rows)\n", false, &_init_f_setRowCount_767, &_call_f_setRowCount_767);
}

// void QStandardItemModel::setSortRole(int role)


static void _init_f_setSortRole_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("role");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSortRole_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QStandardItemModel *)cls)->setSortRole (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSortRole_767 ()
{
  return new qt_gsi::GenericMethod ("setSortRole|sortRole=", "@brief Method void QStandardItemModel::setSortRole(int role)\n", false, &_init_f_setSortRole_767, &_call_f_setSortRole_767);
}

// void QStandardItemModel::setVerticalHeaderItem(int row, QStandardItem *item)


static void _init_f_setVerticalHeaderItem_2578 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("item");
  decl->add_arg<QStandardItem * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setVerticalHeaderItem_2578 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QStandardItem *arg2 = args.read<QStandardItem * > ();
  ((QStandardItemModel *)cls)->setVerticalHeaderItem (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setVerticalHeaderItem_2578 ()
{
  return new qt_gsi::GenericMethod ("setVerticalHeaderItem", "@brief Method void QStandardItemModel::setVerticalHeaderItem(int row, QStandardItem *item)\n", false, &_init_f_setVerticalHeaderItem_2578, &_call_f_setVerticalHeaderItem_2578);
}

// void QStandardItemModel::setVerticalHeaderLabels(const QStringList &labels)


static void _init_f_setVerticalHeaderLabels_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("labels");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVerticalHeaderLabels_2437 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStringList>::target_type & arg1 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  ((QStandardItemModel *)cls)->setVerticalHeaderLabels (qt_gsi::QtToCppAdaptor<QStringList>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setVerticalHeaderLabels_2437 ()
{
  return new qt_gsi::GenericMethod ("setVerticalHeaderLabels", "@brief Method void QStandardItemModel::setVerticalHeaderLabels(const QStringList &labels)\n", false, &_init_f_setVerticalHeaderLabels_2437, &_call_f_setVerticalHeaderLabels_2437);
}

// void QStandardItemModel::sort(int column, Qt::SortOrder order)


static void _init_f_sort_2340 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order", true, "Qt::AscendingOrder");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_sort_2340 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > () : (const qt_gsi::Converter<Qt::SortOrder>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::SortOrder>(heap, Qt::AscendingOrder));
  ((QStandardItemModel *)cls)->sort (arg1, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_sort_2340 ()
{
  return new qt_gsi::GenericMethod ("sort", "@brief Method void QStandardItemModel::sort(int column, Qt::SortOrder order)\nThis is a reimplementation of QAbstractItemModel::sort", false, &_init_f_sort_2340, &_call_f_sort_2340);
}

// int QStandardItemModel::sortRole()


static void _init_f_sortRole_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_sortRole_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QStandardItemModel *)cls)->sortRole ());
}

static qt_gsi::GenericMethod *_create_f_sortRole_c0 ()
{
  return new qt_gsi::GenericMethod (":sortRole", "@brief Method int QStandardItemModel::sortRole()\n", true, &_init_f_sortRole_c0, &_call_f_sortRole_c0);
}

// QFlags<Qt::DropAction> QStandardItemModel::supportedDropActions()


static void _init_f_supportedDropActions_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ();
}

static void _call_f_supportedDropActions_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ((qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::DropAction> >(((QStandardItemModel *)cls)->supportedDropActions ()));
}

static qt_gsi::GenericMethod *_create_f_supportedDropActions_c0 ()
{
  return new qt_gsi::GenericMethod ("supportedDropActions", "@brief Method QFlags<Qt::DropAction> QStandardItemModel::supportedDropActions()\nThis is a reimplementation of QAbstractItemModel::supportedDropActions", true, &_init_f_supportedDropActions_c0, &_call_f_supportedDropActions_c0);
}

// QList<QStandardItem *> QStandardItemModel::takeColumn(int column)


static void _init_f_takeColumn_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return_new<qt_gsi::Converter<QList<QStandardItem *> >::target_type > ();
}

static void _call_f_takeColumn_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<qt_gsi::Converter<QList<QStandardItem *> >::target_type > ((qt_gsi::Converter<QList<QStandardItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QStandardItem *> >(((QStandardItemModel *)cls)->takeColumn (arg1)));
}

static qt_gsi::GenericMethod *_create_f_takeColumn_767 ()
{
  return new qt_gsi::GenericMethod ("takeColumn", "@brief Method QList<QStandardItem *> QStandardItemModel::takeColumn(int column)\n", false, &_init_f_takeColumn_767, &_call_f_takeColumn_767);
}

// QStandardItem *QStandardItemModel::takeHorizontalHeaderItem(int column)


static void _init_f_takeHorizontalHeaderItem_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return_new<QStandardItem * > ();
}

static void _call_f_takeHorizontalHeaderItem_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QStandardItem * > ((QStandardItem *)((QStandardItemModel *)cls)->takeHorizontalHeaderItem (arg1));
}

static qt_gsi::GenericMethod *_create_f_takeHorizontalHeaderItem_767 ()
{
  return new qt_gsi::GenericMethod ("takeHorizontalHeaderItem", "@brief Method QStandardItem *QStandardItemModel::takeHorizontalHeaderItem(int column)\n", false, &_init_f_takeHorizontalHeaderItem_767, &_call_f_takeHorizontalHeaderItem_767);
}

// QStandardItem *QStandardItemModel::takeItem(int row, int column)


static void _init_f_takeItem_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column", true, "0");
  decl->add_arg<int > (argspec_1);
  decl->set_return_new<QStandardItem * > ();
}

static void _call_f_takeItem_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args ? args.read<int > () : (int)(0);
  ret.write<QStandardItem * > ((QStandardItem *)((QStandardItemModel *)cls)->takeItem (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_takeItem_1426 ()
{
  return new qt_gsi::GenericMethod ("takeItem", "@brief Method QStandardItem *QStandardItemModel::takeItem(int row, int column)\n", false, &_init_f_takeItem_1426, &_call_f_takeItem_1426);
}

// QList<QStandardItem *> QStandardItemModel::takeRow(int row)


static void _init_f_takeRow_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return_new<qt_gsi::Converter<QList<QStandardItem *> >::target_type > ();
}

static void _call_f_takeRow_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<qt_gsi::Converter<QList<QStandardItem *> >::target_type > ((qt_gsi::Converter<QList<QStandardItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QStandardItem *> >(((QStandardItemModel *)cls)->takeRow (arg1)));
}

static qt_gsi::GenericMethod *_create_f_takeRow_767 ()
{
  return new qt_gsi::GenericMethod ("takeRow", "@brief Method QList<QStandardItem *> QStandardItemModel::takeRow(int row)\n", false, &_init_f_takeRow_767, &_call_f_takeRow_767);
}

// QStandardItem *QStandardItemModel::takeVerticalHeaderItem(int row)


static void _init_f_takeVerticalHeaderItem_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return_new<QStandardItem * > ();
}

static void _call_f_takeVerticalHeaderItem_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QStandardItem * > ((QStandardItem *)((QStandardItemModel *)cls)->takeVerticalHeaderItem (arg1));
}

static qt_gsi::GenericMethod *_create_f_takeVerticalHeaderItem_767 ()
{
  return new qt_gsi::GenericMethod ("takeVerticalHeaderItem", "@brief Method QStandardItem *QStandardItemModel::takeVerticalHeaderItem(int row)\n", false, &_init_f_takeVerticalHeaderItem_767, &_call_f_takeVerticalHeaderItem_767);
}

// QStandardItem *QStandardItemModel::verticalHeaderItem(int row)


static void _init_f_verticalHeaderItem_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QStandardItem * > ();
}

static void _call_f_verticalHeaderItem_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QStandardItem * > ((QStandardItem *)((QStandardItemModel *)cls)->verticalHeaderItem (arg1));
}

static qt_gsi::GenericMethod *_create_f_verticalHeaderItem_c767 ()
{
  return new qt_gsi::GenericMethod ("verticalHeaderItem", "@brief Method QStandardItem *QStandardItemModel::verticalHeaderItem(int row)\n", true, &_init_f_verticalHeaderItem_c767, &_call_f_verticalHeaderItem_c767);
}

// static QString QStandardItemModel::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QStandardItemModel::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QStandardItemModel::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QStandardItemModel::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QStandardItemModel::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QStandardItemModel::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QStandardItemModel::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QStandardItemModel::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QStandardItemModel::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QStandardItemModel::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QStandardItemModel::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QStandardItemModel::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QStandardItemModel, QStandardItemModel_EventAdaptor> ea_QStandardItemModel;

namespace gsi
{
extern gsi::Class<QAbstractItemModel> decl_QAbstractItemModel;

gsi::Class<QStandardItemModel> decl_QStandardItemModel (ea_QStandardItemModel, decl_QAbstractItemModel, "QStandardItemModel_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_appendColumn_3411 ()) +
  gsi::Methods(_create_f_appendRow_3411 ()) +
  gsi::Methods(_create_f_appendRow_1919 ()) +
  gsi::Methods(_create_f_clear_0 ()) +
  gsi::Methods(_create_f_columnCount_c2395 ()) +
  gsi::Methods(_create_f_data_c3054 ()) +
  gsi::Methods(_create_f_dropMimeData_7425 ()) +
  gsi::Methods(_create_f_findItems_c4892 ()) +
  gsi::Methods(_create_f_flags_c2395 ()) +
  gsi::Methods(_create_f_hasChildren_c2395 ()) +
  gsi::Methods(_create_f_headerData_c3231 ()) +
  gsi::Methods(_create_f_horizontalHeaderItem_c767 ()) +
  gsi::Methods(_create_f_index_c3713 ()) +
  gsi::Methods(_create_f_indexFromItem_c2614 ()) +
  gsi::Methods(_create_f_insertColumn_4070 ()) +
  gsi::Methods(_create_f_insertColumn_3054 ()) +
  gsi::Methods(_create_f_insertColumns_3713 ()) +
  gsi::Methods(_create_f_insertRow_4070 ()) +
  gsi::Methods(_create_f_insertRow_2578 ()) +
  gsi::Methods(_create_f_insertRow_3054 ()) +
  gsi::Methods(_create_f_insertRows_3713 ()) +
  gsi::Methods(_create_f_invisibleRootItem_c0 ()) +
  gsi::Methods(_create_f_item_c1426 ()) +
  gsi::Methods(_create_f_itemFromIndex_c2395 ()) +
  gsi::Methods(_create_f_itemPrototype_c0 ()) +
  gsi::Methods(_create_f_mimeData_c3010 ()) +
  gsi::Methods(_create_f_mimeTypes_c0 ()) +
  gsi::Methods(_create_f_parent_c2395 ()) +
  gsi::Methods(_create_f_parent_c0 ()) +
  gsi::Methods(_create_f_removeColumns_3713 ()) +
  gsi::Methods(_create_f_removeRows_3713 ()) +
  gsi::Methods(_create_f_rowCount_c2395 ()) +
  gsi::Methods(_create_f_setColumnCount_767 ()) +
  gsi::Methods(_create_f_setData_5065 ()) +
  gsi::Methods(_create_f_setHeaderData_5242 ()) +
  gsi::Methods(_create_f_setHorizontalHeaderItem_2578 ()) +
  gsi::Methods(_create_f_setHorizontalHeaderLabels_2437 ()) +
  gsi::Methods(_create_f_setItem_3237 ()) +
  gsi::Methods(_create_f_setItem_2578 ()) +
  gsi::Methods(_create_f_setItemPrototype_2614 ()) +
  gsi::Methods(_create_f_setRowCount_767 ()) +
  gsi::Methods(_create_f_setSortRole_767 ()) +
  gsi::Methods(_create_f_setVerticalHeaderItem_2578 ()) +
  gsi::Methods(_create_f_setVerticalHeaderLabels_2437 ()) +
  gsi::Methods(_create_f_sort_2340 ()) +
  gsi::Methods(_create_f_sortRole_c0 ()) +
  gsi::Methods(_create_f_supportedDropActions_c0 ()) +
  gsi::Methods(_create_f_takeColumn_767 ()) +
  gsi::Methods(_create_f_takeHorizontalHeaderItem_767 ()) +
  gsi::Methods(_create_f_takeItem_1426 ()) +
  gsi::Methods(_create_f_takeRow_767 ()) +
  gsi::Methods(_create_f_takeVerticalHeaderItem_767 ()) +
  gsi::Methods(_create_f_verticalHeaderItem_c767 ()) +
  qt_gsi::qt_signal<QStandardItemModel, QStandardItemModel_EventAdaptor, const QModelIndex &, const QModelIndex &> ("dataChanged", &QStandardItemModel_EventAdaptor::dataChanged_e_4682, gsi::arg("topLeft"), gsi::arg("bottomRight"), "@brief Signal declaration for QStandardItemModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QStandardItemModel, QStandardItemModel_EventAdaptor, QObject *> ("destroyed", &QStandardItemModel_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QStandardItemModel::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QStandardItemModel, QStandardItemModel_EventAdaptor, const qt_gsi::Converter<Qt::Orientation>::target_type &, int, int> ("headerDataChanged", &QStandardItemModel_EventAdaptor::headerDataChanged_e_3231, gsi::arg("orientation"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QStandardItemModel::headerDataChanged(Qt::Orientation orientation, int first, int last)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QStandardItemModel, QStandardItemModel_EventAdaptor, QStandardItem *> ("itemChanged", &QStandardItemModel_EventAdaptor::itemChanged_e_1919, gsi::arg("item"), "@brief Signal declaration for QStandardItemModel::itemChanged(QStandardItem *item)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QStandardItemModel, QStandardItemModel_EventAdaptor> ("layoutAboutToBeChanged", &QStandardItemModel_EventAdaptor::layoutAboutToBeChanged_e_0, "@brief Signal declaration for QStandardItemModel::layoutAboutToBeChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QStandardItemModel, QStandardItemModel_EventAdaptor> ("layoutChanged", &QStandardItemModel_EventAdaptor::layoutChanged_e_0, "@brief Signal declaration for QStandardItemModel::layoutChanged()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QStandardItemModel");
}


class QStandardItemModel_Adaptor : public QStandardItemModel, public qt_gsi::QtObjectBase
{
public:

  virtual ~QStandardItemModel_Adaptor();

  //  [adaptor ctor] QStandardItemModel::QStandardItemModel(QObject *parent)
  QStandardItemModel_Adaptor() : QStandardItemModel()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QStandardItemModel::QStandardItemModel(QObject *parent)
  QStandardItemModel_Adaptor(QObject *parent) : QStandardItemModel(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QStandardItemModel::QStandardItemModel(int rows, int columns, QObject *parent)
  QStandardItemModel_Adaptor(int rows, int columns) : QStandardItemModel(rows, columns)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QStandardItemModel::QStandardItemModel(int rows, int columns, QObject *parent)
  QStandardItemModel_Adaptor(int rows, int columns, QObject *parent) : QStandardItemModel(rows, columns, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QStandardItemModel::beginInsertColumns(const QModelIndex &parent, int first, int last)
  void fp_QStandardItemModel_beginInsertColumns_3713 (const QModelIndex &parent, int first, int last) {
    QStandardItemModel::beginInsertColumns(parent, first, last);
  }

  //  void QStandardItemModel::beginInsertRows(const QModelIndex &parent, int first, int last)
  void fp_QStandardItemModel_beginInsertRows_3713 (const QModelIndex &parent, int first, int last) {
    QStandardItemModel::beginInsertRows(parent, first, last);
  }

  //  bool QStandardItemModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)
  bool fp_QStandardItemModel_beginMoveColumns_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn) {
    return QStandardItemModel::beginMoveColumns(sourceParent, sourceFirst, sourceLast, destinationParent, destinationColumn);
  }

  //  bool QStandardItemModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)
  bool fp_QStandardItemModel_beginMoveRows_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow) {
    return QStandardItemModel::beginMoveRows(sourceParent, sourceFirst, sourceLast, destinationParent, destinationRow);
  }

  //  void QStandardItemModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)
  void fp_QStandardItemModel_beginRemoveColumns_3713 (const QModelIndex &parent, int first, int last) {
    QStandardItemModel::beginRemoveColumns(parent, first, last);
  }

  //  void QStandardItemModel::beginRemoveRows(const QModelIndex &parent, int first, int last)
  void fp_QStandardItemModel_beginRemoveRows_3713 (const QModelIndex &parent, int first, int last) {
    QStandardItemModel::beginRemoveRows(parent, first, last);
  }

  //  void QStandardItemModel::beginResetModel()
  void fp_QStandardItemModel_beginResetModel_0 () {
    QStandardItemModel::beginResetModel();
  }

  //  void QStandardItemModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)
  void fp_QStandardItemModel_changePersistentIndex_4682 (const QModelIndex &from, const QModelIndex &to) {
    QStandardItemModel::changePersistentIndex(from, to);
  }

  //  void QStandardItemModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)
  void fp_QStandardItemModel_changePersistentIndexList_5912 (const qt_gsi::Converter<QList<QModelIndex> >::target_type & from, const qt_gsi::Converter<QList<QModelIndex> >::target_type & to) {
    QStandardItemModel::changePersistentIndexList(qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(from).cref(), qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(to).cref());
  }

  //  QModelIndex QStandardItemModel::createIndex(int row, int column, void *data)
  QModelIndex fp_QStandardItemModel_createIndex_c2374 (int row, int column, void *data) const {
    return QStandardItemModel::createIndex(row, column, data);
  }

  //  QModelIndex QStandardItemModel::createIndex(int row, int column, int id)
  QModelIndex fp_QStandardItemModel_createIndex_c2085 (int row, int column, int id) const {
    return QStandardItemModel::createIndex(row, column, id);
  }

  //  QModelIndex QStandardItemModel::createIndex(int row, int column, quint32 id)
  QModelIndex fp_QStandardItemModel_createIndex_c2416 (int row, int column, quint32 id) const {
    return QStandardItemModel::createIndex(row, column, id);
  }

  //  bool QStandardItemModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)
  bool fp_QStandardItemModel_decodeData_5302 (int row, int column, const QModelIndex &parent, QDataStream &stream) {
    return QStandardItemModel::decodeData(row, column, parent, stream);
  }

  //  void QStandardItemModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)
  void fp_QStandardItemModel_encodeData_c4599 (const qt_gsi::Converter<QList<QModelIndex> >::target_type & indexes, QDataStream &stream) const {
    QStandardItemModel::encodeData(qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(indexes).cref(), stream);
  }

  //  void QStandardItemModel::endInsertColumns()
  void fp_QStandardItemModel_endInsertColumns_0 () {
    QStandardItemModel::endInsertColumns();
  }

  //  void QStandardItemModel::endInsertRows()
  void fp_QStandardItemModel_endInsertRows_0 () {
    QStandardItemModel::endInsertRows();
  }

  //  void QStandardItemModel::endMoveColumns()
  void fp_QStandardItemModel_endMoveColumns_0 () {
    QStandardItemModel::endMoveColumns();
  }

  //  void QStandardItemModel::endMoveRows()
  void fp_QStandardItemModel_endMoveRows_0 () {
    QStandardItemModel::endMoveRows();
  }

  //  void QStandardItemModel::endRemoveColumns()
  void fp_QStandardItemModel_endRemoveColumns_0 () {
    QStandardItemModel::endRemoveColumns();
  }

  //  void QStandardItemModel::endRemoveRows()
  void fp_QStandardItemModel_endRemoveRows_0 () {
    QStandardItemModel::endRemoveRows();
  }

  //  void QStandardItemModel::endResetModel()
  void fp_QStandardItemModel_endResetModel_0 () {
    QStandardItemModel::endResetModel();
  }

  //  QList<QModelIndex> QStandardItemModel::persistentIndexList()
  qt_gsi::Converter<QList<QModelIndex> >::target_type fp_QStandardItemModel_persistentIndexList_c0 () const {
    return qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(QStandardItemModel::persistentIndexList());
  }

  //  int QStandardItemModel::receivers(const char *signal)
  int fp_QStandardItemModel_receivers_c1731 (const char *signal) const {
    return QStandardItemModel::receivers(signal);
  }

  //  void QStandardItemModel::reset()
  void fp_QStandardItemModel_reset_0 () {
    QStandardItemModel::reset();
  }

  //  QObject *QStandardItemModel::sender()
  QObject * fp_QStandardItemModel_sender_c0 () const {
    return QStandardItemModel::sender();
  }

  //  [adaptor impl] QModelIndex QStandardItemModel::buddy(const QModelIndex &index)
  QModelIndex cbs_buddy_c2395_0(const QModelIndex &index) const
  {
    return QStandardItemModel::buddy(index);
  }

  virtual QModelIndex buddy(const QModelIndex &index) const
  {
    if (cb_buddy_c2395_0.can_issue()) {
      return cb_buddy_c2395_0.issue<QStandardItemModel_Adaptor, QModelIndex, const QModelIndex &>(&QStandardItemModel_Adaptor::cbs_buddy_c2395_0, index);
    } else {
      return QStandardItemModel::buddy(index);
    }
  }

  //  [adaptor impl] bool QStandardItemModel::canFetchMore(const QModelIndex &parent)
  bool cbs_canFetchMore_c2395_0(const QModelIndex &parent) const
  {
    return QStandardItemModel::canFetchMore(parent);
  }

  virtual bool canFetchMore(const QModelIndex &parent) const
  {
    if (cb_canFetchMore_c2395_0.can_issue()) {
      return cb_canFetchMore_c2395_0.issue<QStandardItemModel_Adaptor, bool, const QModelIndex &>(&QStandardItemModel_Adaptor::cbs_canFetchMore_c2395_0, parent);
    } else {
      return QStandardItemModel::canFetchMore(parent);
    }
  }

  //  [adaptor impl] int QStandardItemModel::columnCount(const QModelIndex &parent)
  int cbs_columnCount_c2395_1(const QModelIndex &parent) const
  {
    return QStandardItemModel::columnCount(parent);
  }

  virtual int columnCount(const QModelIndex &parent) const
  {
    if (cb_columnCount_c2395_1.can_issue()) {
      return cb_columnCount_c2395_1.issue<QStandardItemModel_Adaptor, int, const QModelIndex &>(&QStandardItemModel_Adaptor::cbs_columnCount_c2395_1, parent);
    } else {
      return QStandardItemModel::columnCount(parent);
    }
  }

  //  [adaptor impl] QVariant QStandardItemModel::data(const QModelIndex &index, int role)
  QVariant cbs_data_c3054_1(const QModelIndex &index, int role) const
  {
    return QStandardItemModel::data(index, role);
  }

  virtual QVariant data(const QModelIndex &index, int role) const
  {
    if (cb_data_c3054_1.can_issue()) {
      return cb_data_c3054_1.issue<QStandardItemModel_Adaptor, QVariant, const QModelIndex &, int>(&QStandardItemModel_Adaptor::cbs_data_c3054_1, index, role);
    } else {
      return QStandardItemModel::data(index, role);
    }
  }

  //  [adaptor impl] bool QStandardItemModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  bool cbs_dropMimeData_7425_0(const QMimeData *data, const qt_gsi::Converter<Qt::DropAction>::target_type & action, int row, int column, const QModelIndex &parent)
  {
    return QStandardItemModel::dropMimeData(data, qt_gsi::QtToCppAdaptor<Qt::DropAction>(action).cref(), row, column, parent);
  }

  virtual bool dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  {
    if (cb_dropMimeData_7425_0.can_issue()) {
      return cb_dropMimeData_7425_0.issue<QStandardItemModel_Adaptor, bool, const QMimeData *, const qt_gsi::Converter<Qt::DropAction>::target_type &, int, int, const QModelIndex &>(&QStandardItemModel_Adaptor::cbs_dropMimeData_7425_0, data, qt_gsi::CppToQtAdaptor<Qt::DropAction>(action), row, column, parent);
    } else {
      return QStandardItemModel::dropMimeData(data, action, row, column, parent);
    }
  }

  //  [adaptor impl] bool QStandardItemModel::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QStandardItemModel::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QStandardItemModel_Adaptor, bool, QEvent *>(&QStandardItemModel_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QStandardItemModel::event(arg1);
    }
  }

  //  [adaptor impl] bool QStandardItemModel::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QStandardItemModel::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QStandardItemModel_Adaptor, bool, QObject *, QEvent *>(&QStandardItemModel_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QStandardItemModel::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QStandardItemModel::fetchMore(const QModelIndex &parent)
  void cbs_fetchMore_2395_0(const QModelIndex &parent)
  {
    QStandardItemModel::fetchMore(parent);
  }

  virtual void fetchMore(const QModelIndex &parent)
  {
    if (cb_fetchMore_2395_0.can_issue()) {
      cb_fetchMore_2395_0.issue<QStandardItemModel_Adaptor, const QModelIndex &>(&QStandardItemModel_Adaptor::cbs_fetchMore_2395_0, parent);
    } else {
      QStandardItemModel::fetchMore(parent);
    }
  }

  //  [adaptor impl] QFlags<Qt::ItemFlag> QStandardItemModel::flags(const QModelIndex &index)
  qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type cbs_flags_c2395_0(const QModelIndex &index) const
  {
    return qt_gsi::CppToQtAdaptor<QFlags<Qt::ItemFlag> >(QStandardItemModel::flags(index));
  }

  virtual QFlags<Qt::ItemFlag> flags(const QModelIndex &index) const
  {
    if (cb_flags_c2395_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QFlags<Qt::ItemFlag> >(cb_flags_c2395_0.issue<QStandardItemModel_Adaptor, qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type, const QModelIndex &>(&QStandardItemModel_Adaptor::cbs_flags_c2395_0, index)).cref();
    } else {
      return QStandardItemModel::flags(index);
    }
  }

  //  [adaptor impl] bool QStandardItemModel::hasChildren(const QModelIndex &parent)
  bool cbs_hasChildren_c2395_1(const QModelIndex &parent) const
  {
    return QStandardItemModel::hasChildren(parent);
  }

  virtual bool hasChildren(const QModelIndex &parent) const
  {
    if (cb_hasChildren_c2395_1.can_issue()) {
      return cb_hasChildren_c2395_1.issue<QStandardItemModel_Adaptor, bool, const QModelIndex &>(&QStandardItemModel_Adaptor::cbs_hasChildren_c2395_1, parent);
    } else {
      return QStandardItemModel::hasChildren(parent);
    }
  }

  //  [adaptor impl] QVariant QStandardItemModel::headerData(int section, Qt::Orientation orientation, int role)
  QVariant cbs_headerData_c3231_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, int role) const
  {
    return QStandardItemModel::headerData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), role);
  }

  virtual QVariant headerData(int section, Qt::Orientation orientation, int role) const
  {
    if (cb_headerData_c3231_1.can_issue()) {
      return cb_headerData_c3231_1.issue<QStandardItemModel_Adaptor, QVariant, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, int>(&QStandardItemModel_Adaptor::cbs_headerData_c3231_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), role);
    } else {
      return QStandardItemModel::headerData(section, orientation, role);
    }
  }

  //  [adaptor impl] QModelIndex QStandardItemModel::index(int row, int column, const QModelIndex &parent)
  QModelIndex cbs_index_c3713_1(int row, int column, const QModelIndex &parent) const
  {
    return QStandardItemModel::index(row, column, parent);
  }

  virtual QModelIndex index(int row, int column, const QModelIndex &parent) const
  {
    if (cb_index_c3713_1.can_issue()) {
      return cb_index_c3713_1.issue<QStandardItemModel_Adaptor, QModelIndex, int, int, const QModelIndex &>(&QStandardItemModel_Adaptor::cbs_index_c3713_1, row, column, parent);
    } else {
      return QStandardItemModel::index(row, column, parent);
    }
  }

  //  [adaptor impl] bool QStandardItemModel::insertColumns(int column, int count, const QModelIndex &parent)
  bool cbs_insertColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QStandardItemModel::insertColumns(column, count, parent);
  }

  virtual bool insertColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_insertColumns_3713_1.can_issue()) {
      return cb_insertColumns_3713_1.issue<QStandardItemModel_Adaptor, bool, int, int, const QModelIndex &>(&QStandardItemModel_Adaptor::cbs_insertColumns_3713_1, column, count, parent);
    } else {
      return QStandardItemModel::insertColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QStandardItemModel::insertRows(int row, int count, const QModelIndex &parent)
  bool cbs_insertRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QStandardItemModel::insertRows(row, count, parent);
  }

  virtual bool insertRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_insertRows_3713_1.can_issue()) {
      return cb_insertRows_3713_1.issue<QStandardItemModel_Adaptor, bool, int, int, const QModelIndex &>(&QStandardItemModel_Adaptor::cbs_insertRows_3713_1, row, count, parent);
    } else {
      return QStandardItemModel::insertRows(row, count, parent);
    }
  }

  //  [adaptor impl] QList<QModelIndex> QStandardItemModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)
  qt_gsi::Converter<QList<QModelIndex> >::target_type cbs_match_c7932_2(const QModelIndex &start, int role, const QVariant &value, int hits, const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & flags) const
  {
    return qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(QStandardItemModel::match(start, role, value, hits, qt_gsi::QtToCppAdaptor<QFlags<Qt::MatchFlag> >(flags).cref()));
  }

  virtual QList<QModelIndex> match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags) const
  {
    if (cb_match_c7932_2.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(cb_match_c7932_2.issue<QStandardItemModel_Adaptor, qt_gsi::Converter<QList<QModelIndex> >::target_type, const QModelIndex &, int, const QVariant &, int, const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type &>(&QStandardItemModel_Adaptor::cbs_match_c7932_2, start, role, value, hits, qt_gsi::CppToQtAdaptor<QFlags<Qt::MatchFlag> >(flags))).cref();
    } else {
      return QStandardItemModel::match(start, role, value, hits, flags);
    }
  }

  //  [adaptor impl] QMimeData *QStandardItemModel::mimeData(const QList<QModelIndex> &indexes)
  QMimeData * cbs_mimeData_c3010_0(const qt_gsi::Converter<QList<QModelIndex> >::target_type & indexes) const
  {
    return QStandardItemModel::mimeData(qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(indexes).cref());
  }

  virtual QMimeData * mimeData(const QList<QModelIndex> &indexes) const
  {
    if (cb_mimeData_c3010_0.can_issue()) {
      return cb_mimeData_c3010_0.issue<QStandardItemModel_Adaptor, QMimeData *, const qt_gsi::Converter<QList<QModelIndex> >::target_type &>(&QStandardItemModel_Adaptor::cbs_mimeData_c3010_0, qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(indexes));
    } else {
      return QStandardItemModel::mimeData(indexes);
    }
  }

  //  [adaptor impl] QStringList QStandardItemModel::mimeTypes()
  qt_gsi::Converter<QStringList>::target_type cbs_mimeTypes_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QStringList>(QStandardItemModel::mimeTypes());
  }

  virtual QStringList mimeTypes() const
  {
    if (cb_mimeTypes_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QStringList>(cb_mimeTypes_c0_0.issue<QStandardItemModel_Adaptor, qt_gsi::Converter<QStringList>::target_type>(&QStandardItemModel_Adaptor::cbs_mimeTypes_c0_0)).cref();
    } else {
      return QStandardItemModel::mimeTypes();
    }
  }

  //  [adaptor impl] QModelIndex QStandardItemModel::parent(const QModelIndex &child)
  QModelIndex cbs_parent_c2395_0(const QModelIndex &child) const
  {
    return QStandardItemModel::parent(child);
  }

  virtual QModelIndex parent(const QModelIndex &child) const
  {
    if (cb_parent_c2395_0.can_issue()) {
      return cb_parent_c2395_0.issue<QStandardItemModel_Adaptor, QModelIndex, const QModelIndex &>(&QStandardItemModel_Adaptor::cbs_parent_c2395_0, child);
    } else {
      return QStandardItemModel::parent(child);
    }
  }

  //  [adaptor impl] bool QStandardItemModel::removeColumns(int column, int count, const QModelIndex &parent)
  bool cbs_removeColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QStandardItemModel::removeColumns(column, count, parent);
  }

  virtual bool removeColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_removeColumns_3713_1.can_issue()) {
      return cb_removeColumns_3713_1.issue<QStandardItemModel_Adaptor, bool, int, int, const QModelIndex &>(&QStandardItemModel_Adaptor::cbs_removeColumns_3713_1, column, count, parent);
    } else {
      return QStandardItemModel::removeColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QStandardItemModel::removeRows(int row, int count, const QModelIndex &parent)
  bool cbs_removeRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QStandardItemModel::removeRows(row, count, parent);
  }

  virtual bool removeRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_removeRows_3713_1.can_issue()) {
      return cb_removeRows_3713_1.issue<QStandardItemModel_Adaptor, bool, int, int, const QModelIndex &>(&QStandardItemModel_Adaptor::cbs_removeRows_3713_1, row, count, parent);
    } else {
      return QStandardItemModel::removeRows(row, count, parent);
    }
  }

  //  [adaptor impl] void QStandardItemModel::revert()
  void cbs_revert_0_0()
  {
    QStandardItemModel::revert();
  }

  virtual void revert()
  {
    if (cb_revert_0_0.can_issue()) {
      cb_revert_0_0.issue<QStandardItemModel_Adaptor>(&QStandardItemModel_Adaptor::cbs_revert_0_0);
    } else {
      QStandardItemModel::revert();
    }
  }

  //  [adaptor impl] int QStandardItemModel::rowCount(const QModelIndex &parent)
  int cbs_rowCount_c2395_1(const QModelIndex &parent) const
  {
    return QStandardItemModel::rowCount(parent);
  }

  virtual int rowCount(const QModelIndex &parent) const
  {
    if (cb_rowCount_c2395_1.can_issue()) {
      return cb_rowCount_c2395_1.issue<QStandardItemModel_Adaptor, int, const QModelIndex &>(&QStandardItemModel_Adaptor::cbs_rowCount_c2395_1, parent);
    } else {
      return QStandardItemModel::rowCount(parent);
    }
  }

  //  [adaptor impl] bool QStandardItemModel::setData(const QModelIndex &index, const QVariant &value, int role)
  bool cbs_setData_5065_1(const QModelIndex &index, const QVariant &value, int role)
  {
    return QStandardItemModel::setData(index, value, role);
  }

  virtual bool setData(const QModelIndex &index, const QVariant &value, int role)
  {
    if (cb_setData_5065_1.can_issue()) {
      return cb_setData_5065_1.issue<QStandardItemModel_Adaptor, bool, const QModelIndex &, const QVariant &, int>(&QStandardItemModel_Adaptor::cbs_setData_5065_1, index, value, role);
    } else {
      return QStandardItemModel::setData(index, value, role);
    }
  }

  //  [adaptor impl] bool QStandardItemModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  bool cbs_setHeaderData_5242_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, const QVariant &value, int role)
  {
    return QStandardItemModel::setHeaderData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), value, role);
  }

  virtual bool setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  {
    if (cb_setHeaderData_5242_1.can_issue()) {
      return cb_setHeaderData_5242_1.issue<QStandardItemModel_Adaptor, bool, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, const QVariant &, int>(&QStandardItemModel_Adaptor::cbs_setHeaderData_5242_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), value, role);
    } else {
      return QStandardItemModel::setHeaderData(section, orientation, value, role);
    }
  }

  //  [adaptor impl] void QStandardItemModel::sort(int column, Qt::SortOrder order)
  void cbs_sort_2340_1(int column, const qt_gsi::Converter<Qt::SortOrder>::target_type & order)
  {
    QStandardItemModel::sort(column, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(order).cref());
  }

  virtual void sort(int column, Qt::SortOrder order)
  {
    if (cb_sort_2340_1.can_issue()) {
      cb_sort_2340_1.issue<QStandardItemModel_Adaptor, int, const qt_gsi::Converter<Qt::SortOrder>::target_type &>(&QStandardItemModel_Adaptor::cbs_sort_2340_1, column, qt_gsi::CppToQtAdaptor<Qt::SortOrder>(order));
    } else {
      QStandardItemModel::sort(column, order);
    }
  }

  //  [adaptor impl] QSize QStandardItemModel::span(const QModelIndex &index)
  QSize cbs_span_c2395_0(const QModelIndex &index) const
  {
    return QStandardItemModel::span(index);
  }

  virtual QSize span(const QModelIndex &index) const
  {
    if (cb_span_c2395_0.can_issue()) {
      return cb_span_c2395_0.issue<QStandardItemModel_Adaptor, QSize, const QModelIndex &>(&QStandardItemModel_Adaptor::cbs_span_c2395_0, index);
    } else {
      return QStandardItemModel::span(index);
    }
  }

  //  [adaptor impl] bool QStandardItemModel::submit()
  bool cbs_submit_0_0()
  {
    return QStandardItemModel::submit();
  }

  virtual bool submit()
  {
    if (cb_submit_0_0.can_issue()) {
      return cb_submit_0_0.issue<QStandardItemModel_Adaptor, bool>(&QStandardItemModel_Adaptor::cbs_submit_0_0);
    } else {
      return QStandardItemModel::submit();
    }
  }

  //  [adaptor impl] QFlags<Qt::DropAction> QStandardItemModel::supportedDropActions()
  qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type cbs_supportedDropActions_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QFlags<Qt::DropAction> >(QStandardItemModel::supportedDropActions());
  }

  virtual QFlags<Qt::DropAction> supportedDropActions() const
  {
    if (cb_supportedDropActions_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QFlags<Qt::DropAction> >(cb_supportedDropActions_c0_0.issue<QStandardItemModel_Adaptor, qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type>(&QStandardItemModel_Adaptor::cbs_supportedDropActions_c0_0)).cref();
    } else {
      return QStandardItemModel::supportedDropActions();
    }
  }

  //  [adaptor impl] void QStandardItemModel::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QStandardItemModel::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QStandardItemModel_Adaptor, QChildEvent *>(&QStandardItemModel_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QStandardItemModel::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QStandardItemModel::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QStandardItemModel::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QStandardItemModel_Adaptor, QEvent *>(&QStandardItemModel_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QStandardItemModel::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QStandardItemModel::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QStandardItemModel::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QStandardItemModel_Adaptor, const char *>(&QStandardItemModel_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QStandardItemModel::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QStandardItemModel::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QStandardItemModel::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QStandardItemModel_Adaptor, QTimerEvent *>(&QStandardItemModel_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QStandardItemModel::timerEvent(arg1);
    }
  }

  gsi::Callback cb_buddy_c2395_0;
  gsi::Callback cb_canFetchMore_c2395_0;
  gsi::Callback cb_columnCount_c2395_1;
  gsi::Callback cb_data_c3054_1;
  gsi::Callback cb_dropMimeData_7425_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_fetchMore_2395_0;
  gsi::Callback cb_flags_c2395_0;
  gsi::Callback cb_hasChildren_c2395_1;
  gsi::Callback cb_headerData_c3231_1;
  gsi::Callback cb_index_c3713_1;
  gsi::Callback cb_insertColumns_3713_1;
  gsi::Callback cb_insertRows_3713_1;
  gsi::Callback cb_match_c7932_2;
  gsi::Callback cb_mimeData_c3010_0;
  gsi::Callback cb_mimeTypes_c0_0;
  gsi::Callback cb_parent_c2395_0;
  gsi::Callback cb_removeColumns_3713_1;
  gsi::Callback cb_removeRows_3713_1;
  gsi::Callback cb_revert_0_0;
  gsi::Callback cb_rowCount_c2395_1;
  gsi::Callback cb_setData_5065_1;
  gsi::Callback cb_setHeaderData_5242_1;
  gsi::Callback cb_sort_2340_1;
  gsi::Callback cb_span_c2395_0;
  gsi::Callback cb_submit_0_0;
  gsi::Callback cb_supportedDropActions_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QStandardItemModel_Adaptor::~QStandardItemModel_Adaptor() { }

//  Constructor QStandardItemModel::QStandardItemModel(QObject *parent) (adaptor class)

static void _init_ctor_QStandardItemModel_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QStandardItemModel_Adaptor *> ();
}

static void _call_ctor_QStandardItemModel_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QStandardItemModel_Adaptor *> (new QStandardItemModel_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QStandardItemModel_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QStandardItemModel::QStandardItemModel(QObject *parent)\nThis method creates an object of class QStandardItemModel.", &_init_ctor_QStandardItemModel_Adaptor_1302, &_call_ctor_QStandardItemModel_Adaptor_1302);
}

//  Constructor QStandardItemModel::QStandardItemModel(int rows, int columns, QObject *parent) (adaptor class)

static void _init_ctor_QStandardItemModel_Adaptor_2620 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rows");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("columns");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_2);
  decl->set_return_new<QStandardItemModel_Adaptor *> ();
}

static void _call_ctor_QStandardItemModel_Adaptor_2620 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  QObject *arg3 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QStandardItemModel_Adaptor *> (new QStandardItemModel_Adaptor (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QStandardItemModel_Adaptor_2620 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QStandardItemModel::QStandardItemModel(int rows, int columns, QObject *parent)\nThis method creates an object of class QStandardItemModel.", &_init_ctor_QStandardItemModel_Adaptor_2620, &_call_ctor_QStandardItemModel_Adaptor_2620);
}

// void QStandardItemModel::beginInsertColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertColumns_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_beginInsertColumns_3713 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_beginInsertColumns_3713 ()
{
  return new qt_gsi::GenericMethod("*beginInsertColumns", "@brief Method void QStandardItemModel::beginInsertColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertColumns_3713, &_call_fp_beginInsertColumns_3713);
}


// void QStandardItemModel::beginInsertRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertRows_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_beginInsertRows_3713 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_beginInsertRows_3713 ()
{
  return new qt_gsi::GenericMethod("*beginInsertRows", "@brief Method void QStandardItemModel::beginInsertRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertRows_3713, &_call_fp_beginInsertRows_3713);
}


// bool QStandardItemModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)

static void _init_fp_beginMoveColumns_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationColumn");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveColumns_6659 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  const QModelIndex &arg4 = args.read<const QModelIndex & > ();
  int arg5 = args.read<int > ();
  ret.write<bool > ((bool)((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_beginMoveColumns_6659 (arg1, arg2, arg3, arg4, arg5));
}

static qt_gsi::GenericMethod*_create_fp_beginMoveColumns_6659 ()
{
  return new qt_gsi::GenericMethod("*beginMoveColumns", "@brief Method bool QStandardItemModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveColumns_6659, &_call_fp_beginMoveColumns_6659);
}


// bool QStandardItemModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)

static void _init_fp_beginMoveRows_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationRow");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveRows_6659 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  const QModelIndex &arg4 = args.read<const QModelIndex & > ();
  int arg5 = args.read<int > ();
  ret.write<bool > ((bool)((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_beginMoveRows_6659 (arg1, arg2, arg3, arg4, arg5));
}

static qt_gsi::GenericMethod*_create_fp_beginMoveRows_6659 ()
{
  return new qt_gsi::GenericMethod("*beginMoveRows", "@brief Method bool QStandardItemModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveRows_6659, &_call_fp_beginMoveRows_6659);
}


// void QStandardItemModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveColumns_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_beginRemoveColumns_3713 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_beginRemoveColumns_3713 ()
{
  return new qt_gsi::GenericMethod("*beginRemoveColumns", "@brief Method void QStandardItemModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveColumns_3713, &_call_fp_beginRemoveColumns_3713);
}


// void QStandardItemModel::beginRemoveRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveRows_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_beginRemoveRows_3713 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_beginRemoveRows_3713 ()
{
  return new qt_gsi::GenericMethod("*beginRemoveRows", "@brief Method void QStandardItemModel::beginRemoveRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveRows_3713, &_call_fp_beginRemoveRows_3713);
}


// void QStandardItemModel::beginResetModel()

static void _init_fp_beginResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_beginResetModel_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_beginResetModel_0 ();
}

static qt_gsi::GenericMethod*_create_fp_beginResetModel_0 ()
{
  return new qt_gsi::GenericMethod("*beginResetModel", "@brief Method void QStandardItemModel::beginResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginResetModel_0, &_call_fp_beginResetModel_0);
}


// void QStandardItemModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)

static void _init_fp_changePersistentIndex_4682 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndex_4682 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_changePersistentIndex_4682 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_changePersistentIndex_4682 ()
{
  return new qt_gsi::GenericMethod("*changePersistentIndex", "@brief Method void QStandardItemModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndex_4682, &_call_fp_changePersistentIndex_4682);
}


// void QStandardItemModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)

static void _init_fp_changePersistentIndexList_5912 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndexList_5912 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QModelIndex> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > ();
  const qt_gsi::Converter<QList<QModelIndex> >::target_type & arg2 = args.read<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > ();
  ((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_changePersistentIndexList_5912 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_changePersistentIndexList_5912 ()
{
  return new qt_gsi::GenericMethod("*changePersistentIndexList", "@brief Method void QStandardItemModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndexList_5912, &_call_fp_changePersistentIndexList_5912);
}


// QModelIndex QStandardItemModel::createIndex(int row, int column, void *data)

static void _init_fp_createIndex_c2374 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("data", true, "0");
  decl->add_arg<void * > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2374 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  void *arg3 = args ? args.read<void * > () : (void *)(0);
  ret.write<QModelIndex > ((QModelIndex)((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_createIndex_c2374 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_createIndex_c2374 ()
{
  return new qt_gsi::GenericMethod("*createIndex", "@brief Method QModelIndex QStandardItemModel::createIndex(int row, int column, void *data)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2374, &_call_fp_createIndex_c2374);
}


// QModelIndex QStandardItemModel::createIndex(int row, int column, int id)

static void _init_fp_createIndex_c2085 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("id");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2085 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ret.write<QModelIndex > ((QModelIndex)((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_createIndex_c2085 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_createIndex_c2085 ()
{
  return new qt_gsi::GenericMethod("*createIndex", "@brief Method QModelIndex QStandardItemModel::createIndex(int row, int column, int id)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2085, &_call_fp_createIndex_c2085);
}


// QModelIndex QStandardItemModel::createIndex(int row, int column, quint32 id)

static void _init_fp_createIndex_c2416 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("id");
  decl->add_arg<quint32 > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2416 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  quint32 arg3 = args.read<quint32 > ();
  ret.write<QModelIndex > ((QModelIndex)((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_createIndex_c2416 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_createIndex_c2416 ()
{
  return new qt_gsi::GenericMethod("*createIndex", "@brief Method QModelIndex QStandardItemModel::createIndex(int row, int column, quint32 id)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2416, &_call_fp_createIndex_c2416);
}


// bool QStandardItemModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)

static void _init_fp_decodeData_5302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("stream");
  decl->add_arg<QDataStream & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_fp_decodeData_5302 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  QDataStream &arg4 = args.read<QDataStream & > ();
  ret.write<bool > ((bool)((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_decodeData_5302 (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericMethod*_create_fp_decodeData_5302 ()
{
  return new qt_gsi::GenericMethod("*decodeData", "@brief Method bool QStandardItemModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_decodeData_5302, &_call_fp_decodeData_5302);
}


// void QStandardItemModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)

static void _init_fp_encodeData_c4599 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stream");
  decl->add_arg<QDataStream & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_encodeData_c4599 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QModelIndex> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > ();
  QDataStream &arg2 = args.read<QDataStream & > ();
  ((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_encodeData_c4599 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_encodeData_c4599 ()
{
  return new qt_gsi::GenericMethod("*encodeData", "@brief Method void QStandardItemModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_encodeData_c4599, &_call_fp_encodeData_c4599);
}


// void QStandardItemModel::endInsertColumns()

static void _init_fp_endInsertColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertColumns_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_endInsertColumns_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endInsertColumns_0 ()
{
  return new qt_gsi::GenericMethod("*endInsertColumns", "@brief Method void QStandardItemModel::endInsertColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertColumns_0, &_call_fp_endInsertColumns_0);
}


// void QStandardItemModel::endInsertRows()

static void _init_fp_endInsertRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertRows_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_endInsertRows_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endInsertRows_0 ()
{
  return new qt_gsi::GenericMethod("*endInsertRows", "@brief Method void QStandardItemModel::endInsertRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertRows_0, &_call_fp_endInsertRows_0);
}


// void QStandardItemModel::endMoveColumns()

static void _init_fp_endMoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveColumns_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_endMoveColumns_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endMoveColumns_0 ()
{
  return new qt_gsi::GenericMethod("*endMoveColumns", "@brief Method void QStandardItemModel::endMoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveColumns_0, &_call_fp_endMoveColumns_0);
}


// void QStandardItemModel::endMoveRows()

static void _init_fp_endMoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveRows_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_endMoveRows_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endMoveRows_0 ()
{
  return new qt_gsi::GenericMethod("*endMoveRows", "@brief Method void QStandardItemModel::endMoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveRows_0, &_call_fp_endMoveRows_0);
}


// void QStandardItemModel::endRemoveColumns()

static void _init_fp_endRemoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveColumns_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_endRemoveColumns_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endRemoveColumns_0 ()
{
  return new qt_gsi::GenericMethod("*endRemoveColumns", "@brief Method void QStandardItemModel::endRemoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveColumns_0, &_call_fp_endRemoveColumns_0);
}


// void QStandardItemModel::endRemoveRows()

static void _init_fp_endRemoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveRows_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_endRemoveRows_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endRemoveRows_0 ()
{
  return new qt_gsi::GenericMethod("*endRemoveRows", "@brief Method void QStandardItemModel::endRemoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveRows_0, &_call_fp_endRemoveRows_0);
}


// void QStandardItemModel::endResetModel()

static void _init_fp_endResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endResetModel_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_endResetModel_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endResetModel_0 ()
{
  return new qt_gsi::GenericMethod("*endResetModel", "@brief Method void QStandardItemModel::endResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endResetModel_0, &_call_fp_endResetModel_0);
}


// QList<QModelIndex> QStandardItemModel::persistentIndexList()

static void _init_fp_persistentIndexList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QModelIndex> >::target_type > ();
}

static void _call_fp_persistentIndexList_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QModelIndex> >::target_type > ((qt_gsi::Converter<QList<QModelIndex> >::target_type)((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_persistentIndexList_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_persistentIndexList_c0 ()
{
  return new qt_gsi::GenericMethod("*persistentIndexList", "@brief Method QList<QModelIndex> QStandardItemModel::persistentIndexList()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_persistentIndexList_c0, &_call_fp_persistentIndexList_c0);
}


// int QStandardItemModel::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QStandardItemModel::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QStandardItemModel::reset()

static void _init_fp_reset_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_reset_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_reset_0 ();
}

static qt_gsi::GenericMethod*_create_fp_reset_0 ()
{
  return new qt_gsi::GenericMethod("*reset", "@brief Method void QStandardItemModel::reset()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_reset_0, &_call_fp_reset_0);
}


// QObject *QStandardItemModel::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QStandardItemModel_Adaptor *)cls)->fp_QStandardItemModel_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QStandardItemModel::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// QModelIndex QStandardItemModel::buddy(const QModelIndex &index)

static void _init_cbs_buddy_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_buddy_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QModelIndex > ((QModelIndex)((QStandardItemModel_Adaptor *)cls)->cbs_buddy_c2395_0 (arg1));
}

static void _set_callback_cbs_buddy_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_buddy_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_buddy_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("buddy", "@hide", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_buddy_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("buddy", "@brief Virtual method QModelIndex QStandardItemModel::buddy(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0, &_set_callback_cbs_buddy_c2395_0);
}


// bool QStandardItemModel::canFetchMore(const QModelIndex &parent)

static void _init_cbs_canFetchMore_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_canFetchMore_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QStandardItemModel_Adaptor *)cls)->cbs_canFetchMore_c2395_0 (arg1));
}

static void _set_callback_cbs_canFetchMore_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_canFetchMore_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_canFetchMore_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("canFetchMore", "@hide", true, &_init_cbs_canFetchMore_c2395_0, &_call_cbs_canFetchMore_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_canFetchMore_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("canFetchMore", "@brief Virtual method bool QStandardItemModel::canFetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canFetchMore_c2395_0, &_call_cbs_canFetchMore_c2395_0, &_set_callback_cbs_canFetchMore_c2395_0);
}


// int QStandardItemModel::columnCount(const QModelIndex &parent)

static void _init_cbs_columnCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_columnCount_c2395_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<int > ((int)((QStandardItemModel_Adaptor *)cls)->cbs_columnCount_c2395_1 (arg1));
}

static void _set_callback_cbs_columnCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_columnCount_c2395_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_columnCount_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("columnCount", "@hide", true, &_init_cbs_columnCount_c2395_1, &_call_cbs_columnCount_c2395_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_columnCount_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("columnCount", "@brief Virtual method int QStandardItemModel::columnCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_columnCount_c2395_1, &_call_cbs_columnCount_c2395_1, &_set_callback_cbs_columnCount_c2395_1);
}


// QVariant QStandardItemModel::data(const QModelIndex &index, int role)

static void _init_cbs_data_c3054_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_data_c3054_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  ret.write<QVariant > ((QVariant)((QStandardItemModel_Adaptor *)cls)->cbs_data_c3054_1 (arg1, arg2));
}

static void _set_callback_cbs_data_c3054_1 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_data_c3054_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_data_c3054_1 ()
{
  return new qt_gsi::GenericMethod ("data", "@hide", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_data_c3054_1 ()
{
  return new qt_gsi::GenericMethod ("data", "@brief Virtual method QVariant QStandardItemModel::data(const QModelIndex &index, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1, &_set_callback_cbs_data_c3054_1);
}


// bool QStandardItemModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)

static void _init_cbs_dropMimeData_7425_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_dropMimeData_7425_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMimeData *arg1 = args.read<const QMimeData * > ();
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  const QModelIndex &arg5 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QStandardItemModel_Adaptor *)cls)->cbs_dropMimeData_7425_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_dropMimeData_7425_0 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_dropMimeData_7425_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropMimeData_7425_0 ()
{
  return new qt_gsi::GenericMethod ("dropMimeData", "@hide", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropMimeData_7425_0 ()
{
  return new qt_gsi::GenericMethod ("dropMimeData", "@brief Virtual method bool QStandardItemModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0, &_set_callback_cbs_dropMimeData_7425_0);
}


// bool QStandardItemModel::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QStandardItemModel_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QStandardItemModel::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QStandardItemModel::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QStandardItemModel_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QStandardItemModel::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QStandardItemModel::fetchMore(const QModelIndex &parent)

static void _init_cbs_fetchMore_2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fetchMore_2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ((QStandardItemModel_Adaptor *)cls)->cbs_fetchMore_2395_0 (arg1);
}

static void _set_callback_cbs_fetchMore_2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_fetchMore_2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fetchMore_2395_0 ()
{
  return new qt_gsi::GenericMethod ("fetchMore", "@hide", false, &_init_cbs_fetchMore_2395_0, &_call_cbs_fetchMore_2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fetchMore_2395_0 ()
{
  return new qt_gsi::GenericMethod ("fetchMore", "@brief Virtual method void QStandardItemModel::fetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fetchMore_2395_0, &_call_cbs_fetchMore_2395_0, &_set_callback_cbs_fetchMore_2395_0);
}


// QFlags<Qt::ItemFlag> QStandardItemModel::flags(const QModelIndex &index)

static void _init_cbs_flags_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type > ();
}

static void _call_cbs_flags_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type > ((qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type)((QStandardItemModel_Adaptor *)cls)->cbs_flags_c2395_0 (arg1));
}

static void _set_callback_cbs_flags_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_flags_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_flags_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("flags", "@hide", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_flags_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("flags", "@brief Virtual method QFlags<Qt::ItemFlag> QStandardItemModel::flags(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0, &_set_callback_cbs_flags_c2395_0);
}


// bool QStandardItemModel::hasChildren(const QModelIndex &parent)

static void _init_cbs_hasChildren_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_hasChildren_c2395_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QStandardItemModel_Adaptor *)cls)->cbs_hasChildren_c2395_1 (arg1));
}

static void _set_callback_cbs_hasChildren_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_hasChildren_c2395_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hasChildren_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("hasChildren", "@hide", true, &_init_cbs_hasChildren_c2395_1, &_call_cbs_hasChildren_c2395_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hasChildren_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("hasChildren", "@brief Virtual method bool QStandardItemModel::hasChildren(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasChildren_c2395_1, &_call_cbs_hasChildren_c2395_1, &_set_callback_cbs_hasChildren_c2395_1);
}


// QVariant QStandardItemModel::headerData(int section, Qt::Orientation orientation, int role)

static void _init_cbs_headerData_c3231_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_cbs_headerData_c3231_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  int arg3 = args.read<int > ();
  ret.write<QVariant > ((QVariant)((QStandardItemModel_Adaptor *)cls)->cbs_headerData_c3231_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_headerData_c3231_1 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_headerData_c3231_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_headerData_c3231_1 ()
{
  return new qt_gsi::GenericMethod ("headerData", "@hide", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_headerData_c3231_1 ()
{
  return new qt_gsi::GenericMethod ("headerData", "@brief Virtual method QVariant QStandardItemModel::headerData(int section, Qt::Orientation orientation, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1, &_set_callback_cbs_headerData_c3231_1);
}


// QModelIndex QStandardItemModel::index(int row, int column, const QModelIndex &parent)

static void _init_cbs_index_c3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_index_c3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<QModelIndex > ((QModelIndex)((QStandardItemModel_Adaptor *)cls)->cbs_index_c3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_index_c3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_index_c3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_index_c3713_1 ()
{
  return new qt_gsi::GenericMethod ("index", "@hide", true, &_init_cbs_index_c3713_1, &_call_cbs_index_c3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_index_c3713_1 ()
{
  return new qt_gsi::GenericMethod ("index", "@brief Virtual method QModelIndex QStandardItemModel::index(int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_index_c3713_1, &_call_cbs_index_c3713_1, &_set_callback_cbs_index_c3713_1);
}


// bool QStandardItemModel::insertColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_insertColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertColumns_3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QStandardItemModel_Adaptor *)cls)->cbs_insertColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_insertColumns_3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_insertColumns_3713_1 ()
{
  return new qt_gsi::GenericMethod ("insertColumns", "@hide", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_insertColumns_3713_1 ()
{
  return new qt_gsi::GenericMethod ("insertColumns", "@brief Virtual method bool QStandardItemModel::insertColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1, &_set_callback_cbs_insertColumns_3713_1);
}


// bool QStandardItemModel::insertRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_insertRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertRows_3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QStandardItemModel_Adaptor *)cls)->cbs_insertRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_insertRows_3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_insertRows_3713_1 ()
{
  return new qt_gsi::GenericMethod ("insertRows", "@hide", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_insertRows_3713_1 ()
{
  return new qt_gsi::GenericMethod ("insertRows", "@brief Virtual method bool QStandardItemModel::insertRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1, &_set_callback_cbs_insertRows_3713_1);
}


// QList<QModelIndex> QStandardItemModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)

static void _init_cbs_match_c7932_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("start");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("hits");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("flags");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & > (argspec_4);
  decl->set_return<qt_gsi::Converter<QList<QModelIndex> >::target_type > ();
}

static void _call_cbs_match_c7932_2 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  const QVariant &arg3 = args.read<const QVariant & > ();
  int arg4 = args.read<int > ();
  const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & arg5 = args.read<const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & > ();
  ret.write<qt_gsi::Converter<QList<QModelIndex> >::target_type > ((qt_gsi::Converter<QList<QModelIndex> >::target_type)((QStandardItemModel_Adaptor *)cls)->cbs_match_c7932_2 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_match_c7932_2 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_match_c7932_2 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_match_c7932_2 ()
{
  return new qt_gsi::GenericMethod ("match", "@hide", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2);
}

static qt_gsi::GenericMethod *_create_callback_cbs_match_c7932_2 ()
{
  return new qt_gsi::GenericMethod ("match", "@brief Virtual method QList<QModelIndex> QStandardItemModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2, &_set_callback_cbs_match_c7932_2);
}


// QMimeData *QStandardItemModel::mimeData(const QList<QModelIndex> &indexes)

static void _init_cbs_mimeData_c3010_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > (argspec_0);
  decl->set_return<QMimeData * > ();
}

static void _call_cbs_mimeData_c3010_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QModelIndex> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > ();
  ret.write<QMimeData * > ((QMimeData *)((QStandardItemModel_Adaptor *)cls)->cbs_mimeData_c3010_0 (arg1));
}

static void _set_callback_cbs_mimeData_c3010_0 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_mimeData_c3010_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mimeData_c3010_0 ()
{
  return new qt_gsi::GenericMethod ("mimeData", "@hide", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mimeData_c3010_0 ()
{
  return new qt_gsi::GenericMethod ("mimeData", "@brief Virtual method QMimeData *QStandardItemModel::mimeData(const QList<QModelIndex> &indexes)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0, &_set_callback_cbs_mimeData_c3010_0);
}


// QStringList QStandardItemModel::mimeTypes()

static void _init_cbs_mimeTypes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_cbs_mimeTypes_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)((QStandardItemModel_Adaptor *)cls)->cbs_mimeTypes_c0_0 ());
}

static void _set_callback_cbs_mimeTypes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_mimeTypes_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mimeTypes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("mimeTypes", "@hide", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mimeTypes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("mimeTypes", "@brief Virtual method QStringList QStandardItemModel::mimeTypes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0, &_set_callback_cbs_mimeTypes_c0_0);
}


// QModelIndex QStandardItemModel::parent(const QModelIndex &child)

static void _init_cbs_parent_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("child");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_parent_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QModelIndex > ((QModelIndex)((QStandardItemModel_Adaptor *)cls)->cbs_parent_c2395_0 (arg1));
}

static void _set_callback_cbs_parent_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_parent_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_parent_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("parent", "@hide", true, &_init_cbs_parent_c2395_0, &_call_cbs_parent_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_parent_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("parent", "@brief Virtual method QModelIndex QStandardItemModel::parent(const QModelIndex &child)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_parent_c2395_0, &_call_cbs_parent_c2395_0, &_set_callback_cbs_parent_c2395_0);
}


// bool QStandardItemModel::removeColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_removeColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeColumns_3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QStandardItemModel_Adaptor *)cls)->cbs_removeColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_removeColumns_3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_removeColumns_3713_1 ()
{
  return new qt_gsi::GenericMethod ("removeColumns", "@hide", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_removeColumns_3713_1 ()
{
  return new qt_gsi::GenericMethod ("removeColumns", "@brief Virtual method bool QStandardItemModel::removeColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1, &_set_callback_cbs_removeColumns_3713_1);
}


// bool QStandardItemModel::removeRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_removeRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeRows_3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QStandardItemModel_Adaptor *)cls)->cbs_removeRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_removeRows_3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_removeRows_3713_1 ()
{
  return new qt_gsi::GenericMethod ("removeRows", "@hide", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_removeRows_3713_1 ()
{
  return new qt_gsi::GenericMethod ("removeRows", "@brief Virtual method bool QStandardItemModel::removeRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1, &_set_callback_cbs_removeRows_3713_1);
}


// void QStandardItemModel::revert()

static void _init_cbs_revert_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_revert_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QStandardItemModel_Adaptor *)cls)->cbs_revert_0_0 ();
}

static void _set_callback_cbs_revert_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_revert_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_revert_0_0 ()
{
  return new qt_gsi::GenericMethod ("revert", "@hide", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_revert_0_0 ()
{
  return new qt_gsi::GenericMethod ("revert", "@brief Virtual method void QStandardItemModel::revert()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0, &_set_callback_cbs_revert_0_0);
}


// int QStandardItemModel::rowCount(const QModelIndex &parent)

static void _init_cbs_rowCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_rowCount_c2395_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<int > ((int)((QStandardItemModel_Adaptor *)cls)->cbs_rowCount_c2395_1 (arg1));
}

static void _set_callback_cbs_rowCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_rowCount_c2395_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_rowCount_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("rowCount", "@hide", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_rowCount_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("rowCount", "@brief Virtual method int QStandardItemModel::rowCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1, &_set_callback_cbs_rowCount_c2395_1);
}


// bool QStandardItemModel::setData(const QModelIndex &index, const QVariant &value, int role)

static void _init_cbs_setData_5065_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_setData_5065_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  int arg3 = args.read<int > ();
  ret.write<bool > ((bool)((QStandardItemModel_Adaptor *)cls)->cbs_setData_5065_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_setData_5065_1 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_setData_5065_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setData_5065_1 ()
{
  return new qt_gsi::GenericMethod ("setData", "@hide", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setData_5065_1 ()
{
  return new qt_gsi::GenericMethod ("setData", "@brief Virtual method bool QStandardItemModel::setData(const QModelIndex &index, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1, &_set_callback_cbs_setData_5065_1);
}


// bool QStandardItemModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)

static void _init_cbs_setHeaderData_5242_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("role");
  decl->add_arg<int > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_cbs_setHeaderData_5242_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  const QVariant &arg3 = args.read<const QVariant & > ();
  int arg4 = args.read<int > ();
  ret.write<bool > ((bool)((QStandardItemModel_Adaptor *)cls)->cbs_setHeaderData_5242_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_setHeaderData_5242_1 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_setHeaderData_5242_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setHeaderData_5242_1 ()
{
  return new qt_gsi::GenericMethod ("setHeaderData", "@hide", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setHeaderData_5242_1 ()
{
  return new qt_gsi::GenericMethod ("setHeaderData", "@brief Virtual method bool QStandardItemModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1, &_set_callback_cbs_setHeaderData_5242_1);
}


// void QStandardItemModel::sort(int column, Qt::SortOrder order)

static void _init_cbs_sort_2340_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_sort_2340_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > ();
  ((QStandardItemModel_Adaptor *)cls)->cbs_sort_2340_1 (arg1, arg2);
}

static void _set_callback_cbs_sort_2340_1 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_sort_2340_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sort_2340_1 ()
{
  return new qt_gsi::GenericMethod ("sort", "@hide", false, &_init_cbs_sort_2340_1, &_call_cbs_sort_2340_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sort_2340_1 ()
{
  return new qt_gsi::GenericMethod ("sort", "@brief Virtual method void QStandardItemModel::sort(int column, Qt::SortOrder order)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sort_2340_1, &_call_cbs_sort_2340_1, &_set_callback_cbs_sort_2340_1);
}


// QSize QStandardItemModel::span(const QModelIndex &index)

static void _init_cbs_span_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QSize > ();
}

static void _call_cbs_span_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QSize > ((QSize)((QStandardItemModel_Adaptor *)cls)->cbs_span_c2395_0 (arg1));
}

static void _set_callback_cbs_span_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_span_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_span_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("span", "@hide", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_span_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("span", "@brief Virtual method QSize QStandardItemModel::span(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0, &_set_callback_cbs_span_c2395_0);
}


// bool QStandardItemModel::submit()

static void _init_cbs_submit_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_submit_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QStandardItemModel_Adaptor *)cls)->cbs_submit_0_0 ());
}

static void _set_callback_cbs_submit_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_submit_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_submit_0_0 ()
{
  return new qt_gsi::GenericMethod ("submit", "@hide", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_submit_0_0 ()
{
  return new qt_gsi::GenericMethod ("submit", "@brief Virtual method bool QStandardItemModel::submit()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0, &_set_callback_cbs_submit_0_0);
}


// QFlags<Qt::DropAction> QStandardItemModel::supportedDropActions()

static void _init_cbs_supportedDropActions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ();
}

static void _call_cbs_supportedDropActions_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ((qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type)((QStandardItemModel_Adaptor *)cls)->cbs_supportedDropActions_c0_0 ());
}

static void _set_callback_cbs_supportedDropActions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_supportedDropActions_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_supportedDropActions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("supportedDropActions", "@hide", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_supportedDropActions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("supportedDropActions", "@brief Virtual method QFlags<Qt::DropAction> QStandardItemModel::supportedDropActions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0, &_set_callback_cbs_supportedDropActions_c0_0);
}


// void QStandardItemModel::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QStandardItemModel_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QStandardItemModel::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QStandardItemModel::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QStandardItemModel_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QStandardItemModel::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QStandardItemModel::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QStandardItemModel_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QStandardItemModel::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QStandardItemModel::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QStandardItemModel_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItemModel_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QStandardItemModel::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QStandardItemModel> decl_QStandardItemModel;

gsi::Class<QStandardItemModel_Adaptor> decl_QStandardItemModel_Adaptor (decl_QStandardItemModel, "QStandardItemModel",
  gsi::Methods(_create_fp_beginInsertColumns_3713 ()) +
  gsi::Methods(_create_fp_beginInsertRows_3713 ()) +
  gsi::Methods(_create_fp_beginMoveColumns_6659 ()) +
  gsi::Methods(_create_fp_beginMoveRows_6659 ()) +
  gsi::Methods(_create_fp_beginRemoveColumns_3713 ()) +
  gsi::Methods(_create_fp_beginRemoveRows_3713 ()) +
  gsi::Methods(_create_fp_beginResetModel_0 ()) +
  gsi::Methods(_create_fp_changePersistentIndex_4682 ()) +
  gsi::Methods(_create_fp_changePersistentIndexList_5912 ()) +
  gsi::Methods(_create_fp_createIndex_c2374 ()) +
  gsi::Methods(_create_fp_createIndex_c2085 ()) +
  gsi::Methods(_create_fp_createIndex_c2416 ()) +
  gsi::Methods(_create_fp_decodeData_5302 ()) +
  gsi::Methods(_create_fp_encodeData_c4599 ()) +
  gsi::Methods(_create_fp_endInsertColumns_0 ()) +
  gsi::Methods(_create_fp_endInsertRows_0 ()) +
  gsi::Methods(_create_fp_endMoveColumns_0 ()) +
  gsi::Methods(_create_fp_endMoveRows_0 ()) +
  gsi::Methods(_create_fp_endRemoveColumns_0 ()) +
  gsi::Methods(_create_fp_endRemoveRows_0 ()) +
  gsi::Methods(_create_fp_endResetModel_0 ()) +
  gsi::Methods(_create_fp_persistentIndexList_c0 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_reset_0 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_buddy_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_buddy_c2395_0 ()) +
  gsi::Methods(_create_cbs_canFetchMore_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_canFetchMore_c2395_0 ()) +
  gsi::Methods(_create_cbs_columnCount_c2395_1 ()) +
  gsi::Methods(_create_callback_cbs_columnCount_c2395_1 ()) +
  gsi::Methods(_create_cbs_data_c3054_1 ()) +
  gsi::Methods(_create_callback_cbs_data_c3054_1 ()) +
  gsi::Methods(_create_cbs_dropMimeData_7425_0 ()) +
  gsi::Methods(_create_callback_cbs_dropMimeData_7425_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_fetchMore_2395_0 ()) +
  gsi::Methods(_create_callback_cbs_fetchMore_2395_0 ()) +
  gsi::Methods(_create_cbs_flags_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_flags_c2395_0 ()) +
  gsi::Methods(_create_cbs_hasChildren_c2395_1 ()) +
  gsi::Methods(_create_callback_cbs_hasChildren_c2395_1 ()) +
  gsi::Methods(_create_cbs_headerData_c3231_1 ()) +
  gsi::Methods(_create_callback_cbs_headerData_c3231_1 ()) +
  gsi::Methods(_create_cbs_index_c3713_1 ()) +
  gsi::Methods(_create_callback_cbs_index_c3713_1 ()) +
  gsi::Methods(_create_cbs_insertColumns_3713_1 ()) +
  gsi::Methods(_create_callback_cbs_insertColumns_3713_1 ()) +
  gsi::Methods(_create_cbs_insertRows_3713_1 ()) +
  gsi::Methods(_create_callback_cbs_insertRows_3713_1 ()) +
  gsi::Methods(_create_cbs_match_c7932_2 ()) +
  gsi::Methods(_create_callback_cbs_match_c7932_2 ()) +
  gsi::Methods(_create_cbs_mimeData_c3010_0 ()) +
  gsi::Methods(_create_callback_cbs_mimeData_c3010_0 ()) +
  gsi::Methods(_create_cbs_mimeTypes_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_mimeTypes_c0_0 ()) +
  gsi::Methods(_create_cbs_parent_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_parent_c2395_0 ()) +
  gsi::Methods(_create_cbs_removeColumns_3713_1 ()) +
  gsi::Methods(_create_callback_cbs_removeColumns_3713_1 ()) +
  gsi::Methods(_create_cbs_removeRows_3713_1 ()) +
  gsi::Methods(_create_callback_cbs_removeRows_3713_1 ()) +
  gsi::Methods(_create_cbs_revert_0_0 ()) +
  gsi::Methods(_create_callback_cbs_revert_0_0 ()) +
  gsi::Methods(_create_cbs_rowCount_c2395_1 ()) +
  gsi::Methods(_create_callback_cbs_rowCount_c2395_1 ()) +
  gsi::Methods(_create_cbs_setData_5065_1 ()) +
  gsi::Methods(_create_callback_cbs_setData_5065_1 ()) +
  gsi::Methods(_create_cbs_setHeaderData_5242_1 ()) +
  gsi::Methods(_create_callback_cbs_setHeaderData_5242_1 ()) +
  gsi::Methods(_create_cbs_sort_2340_1 ()) +
  gsi::Methods(_create_callback_cbs_sort_2340_1 ()) +
  gsi::Methods(_create_cbs_span_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_span_c2395_0 ()) +
  gsi::Methods(_create_cbs_submit_0_0 ()) +
  gsi::Methods(_create_callback_cbs_submit_0_0 ()) +
  gsi::Methods(_create_cbs_supportedDropActions_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_supportedDropActions_c0_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QStandardItemModel_Adaptor_1302 ()) +
  gsi::Methods(_create_ctor_QStandardItemModel_Adaptor_2620 ()),
  "@qt\n@brief Binding of QStandardItemModel");

}

