
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSqlQuery.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtSql.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQSqlQuery_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSqlQuery

//  Constructor QSqlQuery::QSqlQuery(QSqlResult *r)


static void _init_ctor_QSqlQuery_1646 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<QSqlResult * > (argspec_0);
  decl->set_return_new<QSqlQuery *> ();
}

static void _call_ctor_QSqlQuery_1646 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QSqlResult *arg1 = args.read<QSqlResult * > ();
  ret.write<QSqlQuery *> (new QSqlQuery (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QSqlQuery_1646 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSqlQuery::QSqlQuery(QSqlResult *r)\nThis method creates an object of class QSqlQuery.", &_init_ctor_QSqlQuery_1646, &_call_ctor_QSqlQuery_1646);
}

//  Constructor QSqlQuery::QSqlQuery(const QString &query, QSqlDatabase db)


static void _init_ctor_QSqlQuery_3527 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query", true, "QString()");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("db", true, "QSqlDatabase()");
  decl->add_arg<QSqlDatabase > (argspec_1);
  decl->set_return_new<QSqlQuery *> ();
}

static void _call_ctor_QSqlQuery_3527 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args ? args.read<const QString & > () : (const QString &)(QString());
  QSqlDatabase arg2 = args ? args.read<QSqlDatabase > () : (QSqlDatabase)(QSqlDatabase());
  ret.write<QSqlQuery *> (new QSqlQuery (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QSqlQuery_3527 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSqlQuery::QSqlQuery(const QString &query, QSqlDatabase db)\nThis method creates an object of class QSqlQuery.", &_init_ctor_QSqlQuery_3527, &_call_ctor_QSqlQuery_3527);
}

//  Constructor QSqlQuery::QSqlQuery(QSqlDatabase db)


static void _init_ctor_QSqlQuery_1610 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("db");
  decl->add_arg<QSqlDatabase > (argspec_0);
  decl->set_return_new<QSqlQuery *> ();
}

static void _call_ctor_QSqlQuery_1610 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QSqlDatabase arg1 = args.read<QSqlDatabase > ();
  ret.write<QSqlQuery *> (new QSqlQuery (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QSqlQuery_1610 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSqlQuery::QSqlQuery(QSqlDatabase db)\nThis method creates an object of class QSqlQuery.", &_init_ctor_QSqlQuery_1610, &_call_ctor_QSqlQuery_1610);
}

//  Constructor QSqlQuery::QSqlQuery(const QSqlQuery &other)


static void _init_ctor_QSqlQuery_2232 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QSqlQuery & > (argspec_0);
  decl->set_return_new<QSqlQuery *> ();
}

static void _call_ctor_QSqlQuery_2232 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSqlQuery &arg1 = args.read<const QSqlQuery & > ();
  ret.write<QSqlQuery *> (new QSqlQuery (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QSqlQuery_2232 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSqlQuery::QSqlQuery(const QSqlQuery &other)\nThis method creates an object of class QSqlQuery.", &_init_ctor_QSqlQuery_2232, &_call_ctor_QSqlQuery_2232);
}

// void QSqlQuery::addBindValue(const QVariant &val, QFlags<QSql::ParamTypeFlag> type)


static void _init_f_addBindValue_4937 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("val");
  decl->add_arg<const QVariant & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type", true, "QSql::In");
  decl->add_arg<const qt_gsi::Converter<QFlags<QSql::ParamTypeFlag> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addBindValue_4937 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVariant &arg1 = args.read<const QVariant & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QSql::ParamTypeFlag> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<QSql::ParamTypeFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QSql::ParamTypeFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QSql::ParamTypeFlag> >(heap, QSql::In));
  ((QSqlQuery *)cls)->addBindValue (arg1, qt_gsi::QtToCppAdaptor<QFlags<QSql::ParamTypeFlag> >(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_addBindValue_4937 ()
{
  return new qt_gsi::GenericMethod ("addBindValue", "@brief Method void QSqlQuery::addBindValue(const QVariant &val, QFlags<QSql::ParamTypeFlag> type)\n", false, &_init_f_addBindValue_4937, &_call_f_addBindValue_4937);
}

// int QSqlQuery::at()


static void _init_f_at_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_at_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QSqlQuery *)cls)->at ());
}

static qt_gsi::GenericMethod *_create_f_at_c0 ()
{
  return new qt_gsi::GenericMethod ("at", "@brief Method int QSqlQuery::at()\n", true, &_init_f_at_c0, &_call_f_at_c0);
}

// void QSqlQuery::bindValue(const QString &placeholder, const QVariant &val, QFlags<QSql::ParamTypeFlag> type)


static void _init_f_bindValue_6854 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("placeholder");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("val");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("type", true, "QSql::In");
  decl->add_arg<const qt_gsi::Converter<QFlags<QSql::ParamTypeFlag> >::target_type & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_bindValue_6854 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QSql::ParamTypeFlag> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<QSql::ParamTypeFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QSql::ParamTypeFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QSql::ParamTypeFlag> >(heap, QSql::In));
  ((QSqlQuery *)cls)->bindValue (arg1, arg2, qt_gsi::QtToCppAdaptor<QFlags<QSql::ParamTypeFlag> >(arg3).cref());
}

static qt_gsi::GenericMethod *_create_f_bindValue_6854 ()
{
  return new qt_gsi::GenericMethod ("bindValue", "@brief Method void QSqlQuery::bindValue(const QString &placeholder, const QVariant &val, QFlags<QSql::ParamTypeFlag> type)\n", false, &_init_f_bindValue_6854, &_call_f_bindValue_6854);
}

// void QSqlQuery::bindValue(int pos, const QVariant &val, QFlags<QSql::ParamTypeFlag> type)


static void _init_f_bindValue_5596 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("val");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("type", true, "QSql::In");
  decl->add_arg<const qt_gsi::Converter<QFlags<QSql::ParamTypeFlag> >::target_type & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_bindValue_5596 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QSql::ParamTypeFlag> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<QSql::ParamTypeFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QSql::ParamTypeFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QSql::ParamTypeFlag> >(heap, QSql::In));
  ((QSqlQuery *)cls)->bindValue (arg1, arg2, qt_gsi::QtToCppAdaptor<QFlags<QSql::ParamTypeFlag> >(arg3).cref());
}

static qt_gsi::GenericMethod *_create_f_bindValue_5596 ()
{
  return new qt_gsi::GenericMethod ("bindValue", "@brief Method void QSqlQuery::bindValue(int pos, const QVariant &val, QFlags<QSql::ParamTypeFlag> type)\n", false, &_init_f_bindValue_5596, &_call_f_bindValue_5596);
}

// QVariant QSqlQuery::boundValue(const QString &placeholder)


static void _init_f_boundValue_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("placeholder");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_boundValue_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QVariant > ((QVariant)((QSqlQuery *)cls)->boundValue (arg1));
}

static qt_gsi::GenericMethod *_create_f_boundValue_c2025 ()
{
  return new qt_gsi::GenericMethod ("boundValue", "@brief Method QVariant QSqlQuery::boundValue(const QString &placeholder)\n", true, &_init_f_boundValue_c2025, &_call_f_boundValue_c2025);
}

// QVariant QSqlQuery::boundValue(int pos)


static void _init_f_boundValue_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_boundValue_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QVariant > ((QVariant)((QSqlQuery *)cls)->boundValue (arg1));
}

static qt_gsi::GenericMethod *_create_f_boundValue_c767 ()
{
  return new qt_gsi::GenericMethod ("boundValue", "@brief Method QVariant QSqlQuery::boundValue(int pos)\n", true, &_init_f_boundValue_c767, &_call_f_boundValue_c767);
}

// void QSqlQuery::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QSqlQuery *)cls)->clear ();
}

static qt_gsi::GenericMethod *_create_f_clear_0 ()
{
  return new qt_gsi::GenericMethod ("clear", "@brief Method void QSqlQuery::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
}

// const QSqlDriver *QSqlQuery::driver()


static void _init_f_driver_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QSqlDriver * > ();
}

static void _call_f_driver_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QSqlDriver * > ((const QSqlDriver *)((QSqlQuery *)cls)->driver ());
}

static qt_gsi::GenericMethod *_create_f_driver_c0 ()
{
  return new qt_gsi::GenericMethod ("driver", "@brief Method const QSqlDriver *QSqlQuery::driver()\n", true, &_init_f_driver_c0, &_call_f_driver_c0);
}

// bool QSqlQuery::exec(const QString &query)


static void _init_f_exec_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_exec_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QSqlQuery *)cls)->exec (arg1));
}

static qt_gsi::GenericMethod *_create_f_exec_2025 ()
{
  return new qt_gsi::GenericMethod ("exec", "@brief Method bool QSqlQuery::exec(const QString &query)\n", false, &_init_f_exec_2025, &_call_f_exec_2025);
}

// bool QSqlQuery::exec()


static void _init_f_exec_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_exec_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSqlQuery *)cls)->exec ());
}

static qt_gsi::GenericMethod *_create_f_exec_0 ()
{
  return new qt_gsi::GenericMethod ("exec", "@brief Method bool QSqlQuery::exec()\n", false, &_init_f_exec_0, &_call_f_exec_0);
}

// bool QSqlQuery::execBatch(QSqlQuery::BatchExecutionMode mode)


static void _init_f_execBatch_3290 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode", true, "QSqlQuery::ValuesAsRows");
  decl->add_arg<const qt_gsi::Converter<QSqlQuery::BatchExecutionMode>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_execBatch_3290 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<QSqlQuery::BatchExecutionMode>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<QSqlQuery::BatchExecutionMode>::target_type & > () : (const qt_gsi::Converter<QSqlQuery::BatchExecutionMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<QSqlQuery::BatchExecutionMode>(heap, QSqlQuery::ValuesAsRows));
  ret.write<bool > ((bool)((QSqlQuery *)cls)->execBatch (qt_gsi::QtToCppAdaptor<QSqlQuery::BatchExecutionMode>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_execBatch_3290 ()
{
  return new qt_gsi::GenericMethod ("execBatch", "@brief Method bool QSqlQuery::execBatch(QSqlQuery::BatchExecutionMode mode)\n", false, &_init_f_execBatch_3290, &_call_f_execBatch_3290);
}

// QString QSqlQuery::executedQuery()


static void _init_f_executedQuery_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_executedQuery_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QSqlQuery *)cls)->executedQuery ());
}

static qt_gsi::GenericMethod *_create_f_executedQuery_c0 ()
{
  return new qt_gsi::GenericMethod ("executedQuery", "@brief Method QString QSqlQuery::executedQuery()\n", true, &_init_f_executedQuery_c0, &_call_f_executedQuery_c0);
}

// void QSqlQuery::finish()


static void _init_f_finish_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_finish_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QSqlQuery *)cls)->finish ();
}

static qt_gsi::GenericMethod *_create_f_finish_0 ()
{
  return new qt_gsi::GenericMethod ("finish", "@brief Method void QSqlQuery::finish()\n", false, &_init_f_finish_0, &_call_f_finish_0);
}

// bool QSqlQuery::first()


static void _init_f_first_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_first_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSqlQuery *)cls)->first ());
}

static qt_gsi::GenericMethod *_create_f_first_0 ()
{
  return new qt_gsi::GenericMethod ("first", "@brief Method bool QSqlQuery::first()\n", false, &_init_f_first_0, &_call_f_first_0);
}

// bool QSqlQuery::isActive()


static void _init_f_isActive_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isActive_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSqlQuery *)cls)->isActive ());
}

static qt_gsi::GenericMethod *_create_f_isActive_c0 ()
{
  return new qt_gsi::GenericMethod ("isActive?", "@brief Method bool QSqlQuery::isActive()\n", true, &_init_f_isActive_c0, &_call_f_isActive_c0);
}

// bool QSqlQuery::isForwardOnly()


static void _init_f_isForwardOnly_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isForwardOnly_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSqlQuery *)cls)->isForwardOnly ());
}

static qt_gsi::GenericMethod *_create_f_isForwardOnly_c0 ()
{
  return new qt_gsi::GenericMethod ("isForwardOnly?|:forwardOnly", "@brief Method bool QSqlQuery::isForwardOnly()\n", true, &_init_f_isForwardOnly_c0, &_call_f_isForwardOnly_c0);
}

// bool QSqlQuery::isNull(int field)


static void _init_f_isNull_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("field");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isNull_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<bool > ((bool)((QSqlQuery *)cls)->isNull (arg1));
}

static qt_gsi::GenericMethod *_create_f_isNull_c767 ()
{
  return new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QSqlQuery::isNull(int field)\n", true, &_init_f_isNull_c767, &_call_f_isNull_c767);
}

// bool QSqlQuery::isSelect()


static void _init_f_isSelect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSelect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSqlQuery *)cls)->isSelect ());
}

static qt_gsi::GenericMethod *_create_f_isSelect_c0 ()
{
  return new qt_gsi::GenericMethod ("isSelect?", "@brief Method bool QSqlQuery::isSelect()\n", true, &_init_f_isSelect_c0, &_call_f_isSelect_c0);
}

// bool QSqlQuery::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSqlQuery *)cls)->isValid ());
}

static qt_gsi::GenericMethod *_create_f_isValid_c0 ()
{
  return new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QSqlQuery::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
}

// bool QSqlQuery::last()


static void _init_f_last_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_last_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSqlQuery *)cls)->last ());
}

static qt_gsi::GenericMethod *_create_f_last_0 ()
{
  return new qt_gsi::GenericMethod ("last", "@brief Method bool QSqlQuery::last()\n", false, &_init_f_last_0, &_call_f_last_0);
}

// QSqlError QSqlQuery::lastError()


static void _init_f_lastError_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSqlError > ();
}

static void _call_f_lastError_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSqlError > ((QSqlError)((QSqlQuery *)cls)->lastError ());
}

static qt_gsi::GenericMethod *_create_f_lastError_c0 ()
{
  return new qt_gsi::GenericMethod ("lastError", "@brief Method QSqlError QSqlQuery::lastError()\n", true, &_init_f_lastError_c0, &_call_f_lastError_c0);
}

// QVariant QSqlQuery::lastInsertId()


static void _init_f_lastInsertId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVariant > ();
}

static void _call_f_lastInsertId_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QVariant > ((QVariant)((QSqlQuery *)cls)->lastInsertId ());
}

static qt_gsi::GenericMethod *_create_f_lastInsertId_c0 ()
{
  return new qt_gsi::GenericMethod ("lastInsertId", "@brief Method QVariant QSqlQuery::lastInsertId()\n", true, &_init_f_lastInsertId_c0, &_call_f_lastInsertId_c0);
}

// QString QSqlQuery::lastQuery()


static void _init_f_lastQuery_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_lastQuery_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QSqlQuery *)cls)->lastQuery ());
}

static qt_gsi::GenericMethod *_create_f_lastQuery_c0 ()
{
  return new qt_gsi::GenericMethod ("lastQuery", "@brief Method QString QSqlQuery::lastQuery()\n", true, &_init_f_lastQuery_c0, &_call_f_lastQuery_c0);
}

// bool QSqlQuery::next()


static void _init_f_next_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_next_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSqlQuery *)cls)->next ());
}

static qt_gsi::GenericMethod *_create_f_next_0 ()
{
  return new qt_gsi::GenericMethod ("next", "@brief Method bool QSqlQuery::next()\n", false, &_init_f_next_0, &_call_f_next_0);
}

// bool QSqlQuery::nextResult()


static void _init_f_nextResult_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_nextResult_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSqlQuery *)cls)->nextResult ());
}

static qt_gsi::GenericMethod *_create_f_nextResult_0 ()
{
  return new qt_gsi::GenericMethod ("nextResult", "@brief Method bool QSqlQuery::nextResult()\n", false, &_init_f_nextResult_0, &_call_f_nextResult_0);
}

// int QSqlQuery::numRowsAffected()


static void _init_f_numRowsAffected_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_numRowsAffected_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QSqlQuery *)cls)->numRowsAffected ());
}

static qt_gsi::GenericMethod *_create_f_numRowsAffected_c0 ()
{
  return new qt_gsi::GenericMethod ("numRowsAffected", "@brief Method int QSqlQuery::numRowsAffected()\n", true, &_init_f_numRowsAffected_c0, &_call_f_numRowsAffected_c0);
}

// QSql::NumericalPrecisionPolicy QSqlQuery::numericalPrecisionPolicy()


static void _init_f_numericalPrecisionPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type > ();
}

static void _call_f_numericalPrecisionPolicy_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type > ((qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type)qt_gsi::CppToQtAdaptor<QSql::NumericalPrecisionPolicy>(((QSqlQuery *)cls)->numericalPrecisionPolicy ()));
}

static qt_gsi::GenericMethod *_create_f_numericalPrecisionPolicy_c0 ()
{
  return new qt_gsi::GenericMethod (":numericalPrecisionPolicy", "@brief Method QSql::NumericalPrecisionPolicy QSqlQuery::numericalPrecisionPolicy()\n", true, &_init_f_numericalPrecisionPolicy_c0, &_call_f_numericalPrecisionPolicy_c0);
}

// QSqlQuery &QSqlQuery::operator=(const QSqlQuery &other)


static void _init_f_operator_eq__2232 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QSqlQuery & > (argspec_0);
  decl->set_return<QSqlQuery & > ();
}

static void _call_f_operator_eq__2232 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSqlQuery &arg1 = args.read<const QSqlQuery & > ();
  ret.write<QSqlQuery & > ((QSqlQuery &)((QSqlQuery *)cls)->operator= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__2232 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QSqlQuery &QSqlQuery::operator=(const QSqlQuery &other)\n", false, &_init_f_operator_eq__2232, &_call_f_operator_eq__2232);
}

// bool QSqlQuery::prepare(const QString &query)


static void _init_f_prepare_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_prepare_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QSqlQuery *)cls)->prepare (arg1));
}

static qt_gsi::GenericMethod *_create_f_prepare_2025 ()
{
  return new qt_gsi::GenericMethod ("prepare", "@brief Method bool QSqlQuery::prepare(const QString &query)\n", false, &_init_f_prepare_2025, &_call_f_prepare_2025);
}

// bool QSqlQuery::previous()


static void _init_f_previous_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_previous_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSqlQuery *)cls)->previous ());
}

static qt_gsi::GenericMethod *_create_f_previous_0 ()
{
  return new qt_gsi::GenericMethod ("previous", "@brief Method bool QSqlQuery::previous()\n", false, &_init_f_previous_0, &_call_f_previous_0);
}

// QSqlRecord QSqlQuery::record()


static void _init_f_record_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSqlRecord > ();
}

static void _call_f_record_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSqlRecord > ((QSqlRecord)((QSqlQuery *)cls)->record ());
}

static qt_gsi::GenericMethod *_create_f_record_c0 ()
{
  return new qt_gsi::GenericMethod ("record", "@brief Method QSqlRecord QSqlQuery::record()\n", true, &_init_f_record_c0, &_call_f_record_c0);
}

// const QSqlResult *QSqlQuery::result()


static void _init_f_result_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QSqlResult * > ();
}

static void _call_f_result_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QSqlResult * > ((const QSqlResult *)((QSqlQuery *)cls)->result ());
}

static qt_gsi::GenericMethod *_create_f_result_c0 ()
{
  return new qt_gsi::GenericMethod ("result", "@brief Method const QSqlResult *QSqlQuery::result()\n", true, &_init_f_result_c0, &_call_f_result_c0);
}

// bool QSqlQuery::seek(int i, bool relative)


static void _init_f_seek_1523 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("relative", true, "false");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_seek_1523 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  bool arg2 = args ? args.read<bool > () : (bool)(false);
  ret.write<bool > ((bool)((QSqlQuery *)cls)->seek (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_seek_1523 ()
{
  return new qt_gsi::GenericMethod ("seek", "@brief Method bool QSqlQuery::seek(int i, bool relative)\n", false, &_init_f_seek_1523, &_call_f_seek_1523);
}

// void QSqlQuery::setForwardOnly(bool forward)


static void _init_f_setForwardOnly_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("forward");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setForwardOnly_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QSqlQuery *)cls)->setForwardOnly (arg1);
}

static qt_gsi::GenericMethod *_create_f_setForwardOnly_864 ()
{
  return new qt_gsi::GenericMethod ("setForwardOnly|forwardOnly=", "@brief Method void QSqlQuery::setForwardOnly(bool forward)\n", false, &_init_f_setForwardOnly_864, &_call_f_setForwardOnly_864);
}

// void QSqlQuery::setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy precisionPolicy)


static void _init_f_setNumericalPrecisionPolicy_3429 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("precisionPolicy");
  decl->add_arg<const qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNumericalPrecisionPolicy_3429 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type & arg1 = args.read<const qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type & > ();
  ((QSqlQuery *)cls)->setNumericalPrecisionPolicy (qt_gsi::QtToCppAdaptor<QSql::NumericalPrecisionPolicy>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setNumericalPrecisionPolicy_3429 ()
{
  return new qt_gsi::GenericMethod ("setNumericalPrecisionPolicy|numericalPrecisionPolicy=", "@brief Method void QSqlQuery::setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy precisionPolicy)\n", false, &_init_f_setNumericalPrecisionPolicy_3429, &_call_f_setNumericalPrecisionPolicy_3429);
}

// int QSqlQuery::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QSqlQuery *)cls)->size ());
}

static qt_gsi::GenericMethod *_create_f_size_c0 ()
{
  return new qt_gsi::GenericMethod ("size", "@brief Method int QSqlQuery::size()\n", true, &_init_f_size_c0, &_call_f_size_c0);
}

// QVariant QSqlQuery::value(int i)


static void _init_f_value_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_value_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QVariant > ((QVariant)((QSqlQuery *)cls)->value (arg1));
}

static qt_gsi::GenericMethod *_create_f_value_c767 ()
{
  return new qt_gsi::GenericMethod ("value", "@brief Method QVariant QSqlQuery::value(int i)\n", true, &_init_f_value_c767, &_call_f_value_c767);
}


namespace gsi
{
gsi::Class<QSqlQuery> decl_QSqlQuery ("QSqlQuery",
  gsi::Methods(_create_ctor_QSqlQuery_1646 ()) +
  gsi::Methods(_create_ctor_QSqlQuery_3527 ()) +
  gsi::Methods(_create_ctor_QSqlQuery_1610 ()) +
  gsi::Methods(_create_ctor_QSqlQuery_2232 ()) +
  gsi::Methods(_create_f_addBindValue_4937 ()) +
  gsi::Methods(_create_f_at_c0 ()) +
  gsi::Methods(_create_f_bindValue_6854 ()) +
  gsi::Methods(_create_f_bindValue_5596 ()) +
  gsi::Methods(_create_f_boundValue_c2025 ()) +
  gsi::Methods(_create_f_boundValue_c767 ()) +
  gsi::Methods(_create_f_clear_0 ()) +
  gsi::Methods(_create_f_driver_c0 ()) +
  gsi::Methods(_create_f_exec_2025 ()) +
  gsi::Methods(_create_f_exec_0 ()) +
  gsi::Methods(_create_f_execBatch_3290 ()) +
  gsi::Methods(_create_f_executedQuery_c0 ()) +
  gsi::Methods(_create_f_finish_0 ()) +
  gsi::Methods(_create_f_first_0 ()) +
  gsi::Methods(_create_f_isActive_c0 ()) +
  gsi::Methods(_create_f_isForwardOnly_c0 ()) +
  gsi::Methods(_create_f_isNull_c767 ()) +
  gsi::Methods(_create_f_isSelect_c0 ()) +
  gsi::Methods(_create_f_isValid_c0 ()) +
  gsi::Methods(_create_f_last_0 ()) +
  gsi::Methods(_create_f_lastError_c0 ()) +
  gsi::Methods(_create_f_lastInsertId_c0 ()) +
  gsi::Methods(_create_f_lastQuery_c0 ()) +
  gsi::Methods(_create_f_next_0 ()) +
  gsi::Methods(_create_f_nextResult_0 ()) +
  gsi::Methods(_create_f_numRowsAffected_c0 ()) +
  gsi::Methods(_create_f_numericalPrecisionPolicy_c0 ()) +
  gsi::Methods(_create_f_operator_eq__2232 ()) +
  gsi::Methods(_create_f_prepare_2025 ()) +
  gsi::Methods(_create_f_previous_0 ()) +
  gsi::Methods(_create_f_record_c0 ()) +
  gsi::Methods(_create_f_result_c0 ()) +
  gsi::Methods(_create_f_seek_1523 ()) +
  gsi::Methods(_create_f_setForwardOnly_864 ()) +
  gsi::Methods(_create_f_setNumericalPrecisionPolicy_3429 ()) +
  gsi::Methods(_create_f_size_c0 ()) +
  gsi::Methods(_create_f_value_c767 ()),
  "@qt\n@brief Binding of QSqlQuery");

}


//  Implementation of the enum wrapper class for QSqlQuery::BatchExecutionMode
namespace qt_gsi
{

static QSqlQuery_BatchExecutionMode_Enum *c_1_QSqlQuery_BatchExecutionMode_Enum () { return new QSqlQuery_BatchExecutionMode_Enum (QSqlQuery::ValuesAsRows); }
static QSqlQuery_BatchExecutionMode_Enum *c_2_QSqlQuery_BatchExecutionMode_Enum () { return new QSqlQuery_BatchExecutionMode_Enum (QSqlQuery::ValuesAsColumns); }

static gsi::Methods mkdefs_QSqlQuery_BatchExecutionMode () {
  return
    gsi::constant ("ValuesAsRows", &qt_gsi::c_1_QSqlQuery_BatchExecutionMode_Enum, "@brief Enum constant QSqlQuery::ValuesAsRows") +
    gsi::constant ("ValuesAsColumns", &qt_gsi::c_2_QSqlQuery_BatchExecutionMode_Enum, "@brief Enum constant QSqlQuery::ValuesAsColumns");
}

static std::string to_s_QSqlQuery_BatchExecutionMode_Enum (const QSqlQuery_BatchExecutionMode_Enum *e)
{
  if (e->value () == QSqlQuery::ValuesAsRows) { return tl::sprintf ("ValuesAsRows (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSqlQuery::ValuesAsColumns) { return tl::sprintf ("ValuesAsColumns (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QSqlQuery_BatchExecutionMode_Enum (const QSqlQuery_BatchExecutionMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QSqlQuery_BatchExecutionMode_Enum *from_i_QSqlQuery_BatchExecutionMode_Enum (unsigned int i)
{
  return new QSqlQuery_BatchExecutionMode_Enum ((QSqlQuery::BatchExecutionMode) i);
}

static bool equalQSqlQuery_BatchExecutionMode_Enum (const QSqlQuery_BatchExecutionMode_Enum *e, QSqlQuery_BatchExecutionMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QSqlQuery_BatchExecutionMode_Enum (const QSqlQuery_BatchExecutionMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QSqlQuery_BatchExecutionMode_Enums oropQSqlQuery_BatchExecutionMode_Enums (const QSqlQuery_BatchExecutionMode_Enums *e, const QSqlQuery_BatchExecutionMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QSqlQuery_BatchExecutionMode_Enums andopQSqlQuery_BatchExecutionMode_Enums (const QSqlQuery_BatchExecutionMode_Enums *e, const QSqlQuery_BatchExecutionMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QSqlQuery_BatchExecutionMode_Enums xoropQSqlQuery_BatchExecutionMode_Enums (const QSqlQuery_BatchExecutionMode_Enums *e, const QSqlQuery_BatchExecutionMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QSqlQuery_BatchExecutionMode_Enums (const QSqlQuery_BatchExecutionMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QSqlQuery::ValuesAsRows)) { if (!l.empty ()) l += "|"; l += "ValuesAsRows"; }
  if (e->testFlag (QSqlQuery::ValuesAsColumns)) { if (!l.empty ()) l += "|"; l += "ValuesAsColumns"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QSqlQuery_BatchExecutionMode_Enums (const QSqlQuery_BatchExecutionMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QSqlQuery_BatchExecutionMode_Enums (const QSqlQuery_BatchExecutionMode_Enums *e, const QSqlQuery_BatchExecutionMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QSqlQuery_BatchExecutionMode_Enums> decl_QSqlQuery_BatchExecutionMode_Enums ("QSqlQuery_QFlags_BatchExecutionMode",
  gsi::method_ext ("|", &qt_gsi::oropQSqlQuery_BatchExecutionMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQSqlQuery_BatchExecutionMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQSqlQuery_BatchExecutionMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSqlQuery_BatchExecutionMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSqlQuery_BatchExecutionMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QSqlQuery_BatchExecutionMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QSqlQuery::BatchExecutionMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QSqlQuery_BatchExecutionMode_Enum> decl_QSqlQuery_BatchExecutionMode_Enum (decl_QSqlQuery_BatchExecutionMode_Enums, "QSqlQuery_BatchExecutionMode",
  qt_gsi::mkdefs_QSqlQuery_BatchExecutionMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSqlQuery_BatchExecutionMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSqlQuery_BatchExecutionMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQSqlQuery_BatchExecutionMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QSqlQuery_BatchExecutionMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QSqlQuery_BatchExecutionMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QSqlQuery::BatchExecutionMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QSqlQuery> inject_QSqlQuery_BatchExecutionMode_Enum_in_parent (qt_gsi::mkdefs_QSqlQuery_BatchExecutionMode ());
static gsi::ClassExt<QSqlQuery> decl_QSqlQuery_BatchExecutionMode_Enum_as_child (decl_QSqlQuery_BatchExecutionMode_Enum, "BatchExecutionMode");

}

