
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQRegExp.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQRegExp_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QRegExp

//  Constructor QRegExp::QRegExp()


static void _init_ctor_QRegExp_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QRegExp *> ();
}

static void _call_ctor_QRegExp_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRegExp *> (new QRegExp ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QRegExp_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRegExp::QRegExp()\nThis method creates an object of class QRegExp.", &_init_ctor_QRegExp_0, &_call_ctor_QRegExp_0);
}

//  Constructor QRegExp::QRegExp(const QString &pattern, Qt::CaseSensitivity cs, QRegExp::PatternSyntax syntax)


static void _init_ctor_QRegExp_6734 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pattern");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cs", true, "Qt::CaseSensitive");
  decl->add_arg<const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("syntax", true, "QRegExp::RegExp");
  decl->add_arg<const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & > (argspec_2);
  decl->set_return_new<QRegExp *> ();
}

static void _call_ctor_QRegExp_6734 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & > () : (const qt_gsi::Converter<Qt::CaseSensitivity>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::CaseSensitivity>(heap, Qt::CaseSensitive));
  const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & > () : (const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type &)(qt_gsi::CppToQtReadAdaptor<QRegExp::PatternSyntax>(heap, QRegExp::RegExp));
  ret.write<QRegExp *> (new QRegExp (arg1, qt_gsi::QtToCppAdaptor<Qt::CaseSensitivity>(arg2).cref(), qt_gsi::QtToCppAdaptor<QRegExp::PatternSyntax>(arg3).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QRegExp_6734 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRegExp::QRegExp(const QString &pattern, Qt::CaseSensitivity cs, QRegExp::PatternSyntax syntax)\nThis method creates an object of class QRegExp.", &_init_ctor_QRegExp_6734, &_call_ctor_QRegExp_6734);
}

//  Constructor QRegExp::QRegExp(const QRegExp &rx)


static void _init_ctor_QRegExp_1981 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rx");
  decl->add_arg<const QRegExp & > (argspec_0);
  decl->set_return_new<QRegExp *> ();
}

static void _call_ctor_QRegExp_1981 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRegExp &arg1 = args.read<const QRegExp & > ();
  ret.write<QRegExp *> (new QRegExp (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QRegExp_1981 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRegExp::QRegExp(const QRegExp &rx)\nThis method creates an object of class QRegExp.", &_init_ctor_QRegExp_1981, &_call_ctor_QRegExp_1981);
}

// QString QRegExp::cap(int nth)


static void _init_f_cap_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("nth", true, "0");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_cap_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(0);
  ret.write<QString > ((QString)((QRegExp *)cls)->cap (arg1));
}

static qt_gsi::GenericMethod *_create_f_cap_c767 ()
{
  return new qt_gsi::GenericMethod ("cap", "@brief Method QString QRegExp::cap(int nth)\n", true, &_init_f_cap_c767, &_call_f_cap_c767);
}

// QString QRegExp::cap(int nth)


static void _init_f_cap_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("nth", true, "0");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_cap_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(0);
  ret.write<QString > ((QString)((QRegExp *)cls)->cap (arg1));
}

static qt_gsi::GenericMethod *_create_f_cap_767 ()
{
  return new qt_gsi::GenericMethod ("cap", "@brief Method QString QRegExp::cap(int nth)\n", false, &_init_f_cap_767, &_call_f_cap_767);
}

// int QRegExp::captureCount()


static void _init_f_captureCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_captureCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QRegExp *)cls)->captureCount ());
}

static qt_gsi::GenericMethod *_create_f_captureCount_c0 ()
{
  return new qt_gsi::GenericMethod ("captureCount", "@brief Method int QRegExp::captureCount()\n", true, &_init_f_captureCount_c0, &_call_f_captureCount_c0);
}

// QStringList QRegExp::capturedTexts()


static void _init_f_capturedTexts_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_capturedTexts_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QRegExp *)cls)->capturedTexts ()));
}

static qt_gsi::GenericMethod *_create_f_capturedTexts_c0 ()
{
  return new qt_gsi::GenericMethod ("capturedTexts", "@brief Method QStringList QRegExp::capturedTexts()\n", true, &_init_f_capturedTexts_c0, &_call_f_capturedTexts_c0);
}

// QStringList QRegExp::capturedTexts()


static void _init_f_capturedTexts_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_capturedTexts_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QRegExp *)cls)->capturedTexts ()));
}

static qt_gsi::GenericMethod *_create_f_capturedTexts_0 ()
{
  return new qt_gsi::GenericMethod ("capturedTexts", "@brief Method QStringList QRegExp::capturedTexts()\n", false, &_init_f_capturedTexts_0, &_call_f_capturedTexts_0);
}

// Qt::CaseSensitivity QRegExp::caseSensitivity()


static void _init_f_caseSensitivity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::CaseSensitivity>::target_type > ();
}

static void _call_f_caseSensitivity_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::CaseSensitivity>::target_type > ((qt_gsi::Converter<Qt::CaseSensitivity>::target_type)qt_gsi::CppToQtAdaptor<Qt::CaseSensitivity>(((QRegExp *)cls)->caseSensitivity ()));
}

static qt_gsi::GenericMethod *_create_f_caseSensitivity_c0 ()
{
  return new qt_gsi::GenericMethod (":caseSensitivity", "@brief Method Qt::CaseSensitivity QRegExp::caseSensitivity()\n", true, &_init_f_caseSensitivity_c0, &_call_f_caseSensitivity_c0);
}

// QString QRegExp::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QRegExp *)cls)->errorString ());
}

static qt_gsi::GenericMethod *_create_f_errorString_c0 ()
{
  return new qt_gsi::GenericMethod ("errorString", "@brief Method QString QRegExp::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
}

// QString QRegExp::errorString()


static void _init_f_errorString_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QRegExp *)cls)->errorString ());
}

static qt_gsi::GenericMethod *_create_f_errorString_0 ()
{
  return new qt_gsi::GenericMethod ("errorString", "@brief Method QString QRegExp::errorString()\n", false, &_init_f_errorString_0, &_call_f_errorString_0);
}

// bool QRegExp::exactMatch(const QString &str)


static void _init_f_exactMatch_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("str");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_exactMatch_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QRegExp *)cls)->exactMatch (arg1));
}

static qt_gsi::GenericMethod *_create_f_exactMatch_c2025 ()
{
  return new qt_gsi::GenericMethod ("exactMatch", "@brief Method bool QRegExp::exactMatch(const QString &str)\n", true, &_init_f_exactMatch_c2025, &_call_f_exactMatch_c2025);
}

// int QRegExp::indexIn(const QString &str, int offset, QRegExp::CaretMode caretMode)


static void _init_f_indexIn_c4680 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("str");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("offset", true, "0");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("caretMode", true, "QRegExp::CaretAtZero");
  decl->add_arg<const qt_gsi::Converter<QRegExp::CaretMode>::target_type & > (argspec_2);
  decl->set_return<int > ();
}

static void _call_f_indexIn_c4680 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  int arg2 = args ? args.read<int > () : (int)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QRegExp::CaretMode>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QRegExp::CaretMode>::target_type & > () : (const qt_gsi::Converter<QRegExp::CaretMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<QRegExp::CaretMode>(heap, QRegExp::CaretAtZero));
  ret.write<int > ((int)((QRegExp *)cls)->indexIn (arg1, arg2, qt_gsi::QtToCppAdaptor<QRegExp::CaretMode>(arg3).cref()));
}

static qt_gsi::GenericMethod *_create_f_indexIn_c4680 ()
{
  return new qt_gsi::GenericMethod ("indexIn", "@brief Method int QRegExp::indexIn(const QString &str, int offset, QRegExp::CaretMode caretMode)\n", true, &_init_f_indexIn_c4680, &_call_f_indexIn_c4680);
}

// bool QRegExp::isEmpty()


static void _init_f_isEmpty_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEmpty_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QRegExp *)cls)->isEmpty ());
}

static qt_gsi::GenericMethod *_create_f_isEmpty_c0 ()
{
  return new qt_gsi::GenericMethod ("isEmpty?", "@brief Method bool QRegExp::isEmpty()\n", true, &_init_f_isEmpty_c0, &_call_f_isEmpty_c0);
}

// bool QRegExp::isMinimal()


static void _init_f_isMinimal_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isMinimal_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QRegExp *)cls)->isMinimal ());
}

static qt_gsi::GenericMethod *_create_f_isMinimal_c0 ()
{
  return new qt_gsi::GenericMethod ("isMinimal?|:minimal", "@brief Method bool QRegExp::isMinimal()\n", true, &_init_f_isMinimal_c0, &_call_f_isMinimal_c0);
}

// bool QRegExp::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QRegExp *)cls)->isValid ());
}

static qt_gsi::GenericMethod *_create_f_isValid_c0 ()
{
  return new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QRegExp::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
}

// int QRegExp::lastIndexIn(const QString &str, int offset, QRegExp::CaretMode caretMode)


static void _init_f_lastIndexIn_c4680 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("str");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("offset", true, "-1");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("caretMode", true, "QRegExp::CaretAtZero");
  decl->add_arg<const qt_gsi::Converter<QRegExp::CaretMode>::target_type & > (argspec_2);
  decl->set_return<int > ();
}

static void _call_f_lastIndexIn_c4680 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  int arg2 = args ? args.read<int > () : (int)(-1);
  tl::Heap heap;
  const qt_gsi::Converter<QRegExp::CaretMode>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QRegExp::CaretMode>::target_type & > () : (const qt_gsi::Converter<QRegExp::CaretMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<QRegExp::CaretMode>(heap, QRegExp::CaretAtZero));
  ret.write<int > ((int)((QRegExp *)cls)->lastIndexIn (arg1, arg2, qt_gsi::QtToCppAdaptor<QRegExp::CaretMode>(arg3).cref()));
}

static qt_gsi::GenericMethod *_create_f_lastIndexIn_c4680 ()
{
  return new qt_gsi::GenericMethod ("lastIndexIn", "@brief Method int QRegExp::lastIndexIn(const QString &str, int offset, QRegExp::CaretMode caretMode)\n", true, &_init_f_lastIndexIn_c4680, &_call_f_lastIndexIn_c4680);
}

// int QRegExp::matchedLength()


static void _init_f_matchedLength_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_matchedLength_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QRegExp *)cls)->matchedLength ());
}

static qt_gsi::GenericMethod *_create_f_matchedLength_c0 ()
{
  return new qt_gsi::GenericMethod ("matchedLength", "@brief Method int QRegExp::matchedLength()\n", true, &_init_f_matchedLength_c0, &_call_f_matchedLength_c0);
}

// int QRegExp::numCaptures()


static void _init_f_numCaptures_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_numCaptures_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QRegExp *)cls)->numCaptures ());
}

static qt_gsi::GenericMethod *_create_f_numCaptures_c0 ()
{
  return new qt_gsi::GenericMethod ("numCaptures", "@brief Method int QRegExp::numCaptures()\n", true, &_init_f_numCaptures_c0, &_call_f_numCaptures_c0);
}

// bool QRegExp::operator!=(const QRegExp &rx)


static void _init_f_operator_excl__eq__c1981 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rx");
  decl->add_arg<const QRegExp & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c1981 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRegExp &arg1 = args.read<const QRegExp & > ();
  ret.write<bool > ((bool)((QRegExp *)cls)->operator!= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__c1981 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QRegExp::operator!=(const QRegExp &rx)\n", true, &_init_f_operator_excl__eq__c1981, &_call_f_operator_excl__eq__c1981);
}

// QRegExp &QRegExp::operator=(const QRegExp &rx)


static void _init_f_operator_eq__1981 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rx");
  decl->add_arg<const QRegExp & > (argspec_0);
  decl->set_return<QRegExp & > ();
}

static void _call_f_operator_eq__1981 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRegExp &arg1 = args.read<const QRegExp & > ();
  ret.write<QRegExp & > ((QRegExp &)((QRegExp *)cls)->operator= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__1981 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QRegExp &QRegExp::operator=(const QRegExp &rx)\n", false, &_init_f_operator_eq__1981, &_call_f_operator_eq__1981);
}

// bool QRegExp::operator==(const QRegExp &rx)


static void _init_f_operator_eq__eq__c1981 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rx");
  decl->add_arg<const QRegExp & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c1981 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRegExp &arg1 = args.read<const QRegExp & > ();
  ret.write<bool > ((bool)((QRegExp *)cls)->operator== (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__c1981 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QRegExp::operator==(const QRegExp &rx)\n", true, &_init_f_operator_eq__eq__c1981, &_call_f_operator_eq__eq__c1981);
}

// QString QRegExp::pattern()


static void _init_f_pattern_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_pattern_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QRegExp *)cls)->pattern ());
}

static qt_gsi::GenericMethod *_create_f_pattern_c0 ()
{
  return new qt_gsi::GenericMethod (":pattern", "@brief Method QString QRegExp::pattern()\n", true, &_init_f_pattern_c0, &_call_f_pattern_c0);
}

// QRegExp::PatternSyntax QRegExp::patternSyntax()


static void _init_f_patternSyntax_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRegExp::PatternSyntax>::target_type > ();
}

static void _call_f_patternSyntax_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QRegExp::PatternSyntax>::target_type > ((qt_gsi::Converter<QRegExp::PatternSyntax>::target_type)qt_gsi::CppToQtAdaptor<QRegExp::PatternSyntax>(((QRegExp *)cls)->patternSyntax ()));
}

static qt_gsi::GenericMethod *_create_f_patternSyntax_c0 ()
{
  return new qt_gsi::GenericMethod (":patternSyntax", "@brief Method QRegExp::PatternSyntax QRegExp::patternSyntax()\n", true, &_init_f_patternSyntax_c0, &_call_f_patternSyntax_c0);
}

// int QRegExp::pos(int nth)


static void _init_f_pos_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("nth", true, "0");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_pos_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(0);
  ret.write<int > ((int)((QRegExp *)cls)->pos (arg1));
}

static qt_gsi::GenericMethod *_create_f_pos_c767 ()
{
  return new qt_gsi::GenericMethod ("pos", "@brief Method int QRegExp::pos(int nth)\n", true, &_init_f_pos_c767, &_call_f_pos_c767);
}

// int QRegExp::pos(int nth)


static void _init_f_pos_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("nth", true, "0");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_pos_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(0);
  ret.write<int > ((int)((QRegExp *)cls)->pos (arg1));
}

static qt_gsi::GenericMethod *_create_f_pos_767 ()
{
  return new qt_gsi::GenericMethod ("pos", "@brief Method int QRegExp::pos(int nth)\n", false, &_init_f_pos_767, &_call_f_pos_767);
}

// void QRegExp::setCaseSensitivity(Qt::CaseSensitivity cs)


static void _init_f_setCaseSensitivity_2324 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cs");
  decl->add_arg<const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCaseSensitivity_2324 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & > ();
  ((QRegExp *)cls)->setCaseSensitivity (qt_gsi::QtToCppAdaptor<Qt::CaseSensitivity>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setCaseSensitivity_2324 ()
{
  return new qt_gsi::GenericMethod ("setCaseSensitivity|caseSensitivity=", "@brief Method void QRegExp::setCaseSensitivity(Qt::CaseSensitivity cs)\n", false, &_init_f_setCaseSensitivity_2324, &_call_f_setCaseSensitivity_2324);
}

// void QRegExp::setMinimal(bool minimal)


static void _init_f_setMinimal_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("minimal");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMinimal_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QRegExp *)cls)->setMinimal (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMinimal_864 ()
{
  return new qt_gsi::GenericMethod ("setMinimal|minimal=", "@brief Method void QRegExp::setMinimal(bool minimal)\n", false, &_init_f_setMinimal_864, &_call_f_setMinimal_864);
}

// void QRegExp::setPattern(const QString &pattern)


static void _init_f_setPattern_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pattern");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPattern_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QRegExp *)cls)->setPattern (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPattern_2025 ()
{
  return new qt_gsi::GenericMethod ("setPattern|pattern=", "@brief Method void QRegExp::setPattern(const QString &pattern)\n", false, &_init_f_setPattern_2025, &_call_f_setPattern_2025);
}

// void QRegExp::setPatternSyntax(QRegExp::PatternSyntax syntax)


static void _init_f_setPatternSyntax_2601 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("syntax");
  decl->add_arg<const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPatternSyntax_2601 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & arg1 = args.read<const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & > ();
  ((QRegExp *)cls)->setPatternSyntax (qt_gsi::QtToCppAdaptor<QRegExp::PatternSyntax>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setPatternSyntax_2601 ()
{
  return new qt_gsi::GenericMethod ("setPatternSyntax|patternSyntax=", "@brief Method void QRegExp::setPatternSyntax(QRegExp::PatternSyntax syntax)\n", false, &_init_f_setPatternSyntax_2601, &_call_f_setPatternSyntax_2601);
}

// static QString QRegExp::escape(const QString &str)


static void _init_f_escape_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("str");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_escape_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QString > ((QString)QRegExp::escape (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_escape_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("escape", "@brief Static method QString QRegExp::escape(const QString &str)\nThis method is static and can be called without an instance.", &_init_f_escape_2025, &_call_f_escape_2025);
}


namespace gsi
{
gsi::Class<QRegExp> decl_QRegExp ("QRegExp",
  gsi::Methods(_create_ctor_QRegExp_0 ()) +
  gsi::Methods(_create_ctor_QRegExp_6734 ()) +
  gsi::Methods(_create_ctor_QRegExp_1981 ()) +
  gsi::Methods(_create_f_cap_c767 ()) +
  gsi::Methods(_create_f_cap_767 ()) +
  gsi::Methods(_create_f_captureCount_c0 ()) +
  gsi::Methods(_create_f_capturedTexts_c0 ()) +
  gsi::Methods(_create_f_capturedTexts_0 ()) +
  gsi::Methods(_create_f_caseSensitivity_c0 ()) +
  gsi::Methods(_create_f_errorString_c0 ()) +
  gsi::Methods(_create_f_errorString_0 ()) +
  gsi::Methods(_create_f_exactMatch_c2025 ()) +
  gsi::Methods(_create_f_indexIn_c4680 ()) +
  gsi::Methods(_create_f_isEmpty_c0 ()) +
  gsi::Methods(_create_f_isMinimal_c0 ()) +
  gsi::Methods(_create_f_isValid_c0 ()) +
  gsi::Methods(_create_f_lastIndexIn_c4680 ()) +
  gsi::Methods(_create_f_matchedLength_c0 ()) +
  gsi::Methods(_create_f_numCaptures_c0 ()) +
  gsi::Methods(_create_f_operator_excl__eq__c1981 ()) +
  gsi::Methods(_create_f_operator_eq__1981 ()) +
  gsi::Methods(_create_f_operator_eq__eq__c1981 ()) +
  gsi::Methods(_create_f_pattern_c0 ()) +
  gsi::Methods(_create_f_patternSyntax_c0 ()) +
  gsi::Methods(_create_f_pos_c767 ()) +
  gsi::Methods(_create_f_pos_767 ()) +
  gsi::Methods(_create_f_setCaseSensitivity_2324 ()) +
  gsi::Methods(_create_f_setMinimal_864 ()) +
  gsi::Methods(_create_f_setPattern_2025 ()) +
  gsi::Methods(_create_f_setPatternSyntax_2601 ()) +
  gsi::Methods(_create_f_escape_2025 ()),
  "@qt\n@brief Binding of QRegExp");

}


//  Implementation of the enum wrapper class for QRegExp::CaretMode
namespace qt_gsi
{

static QRegExp_CaretMode_Enum *c_1_QRegExp_CaretMode_Enum () { return new QRegExp_CaretMode_Enum (QRegExp::CaretAtZero); }
static QRegExp_CaretMode_Enum *c_2_QRegExp_CaretMode_Enum () { return new QRegExp_CaretMode_Enum (QRegExp::CaretAtOffset); }
static QRegExp_CaretMode_Enum *c_3_QRegExp_CaretMode_Enum () { return new QRegExp_CaretMode_Enum (QRegExp::CaretWontMatch); }

static gsi::Methods mkdefs_QRegExp_CaretMode () {
  return
    gsi::constant ("CaretAtZero", &qt_gsi::c_1_QRegExp_CaretMode_Enum, "@brief Enum constant QRegExp::CaretAtZero") +
    gsi::constant ("CaretAtOffset", &qt_gsi::c_2_QRegExp_CaretMode_Enum, "@brief Enum constant QRegExp::CaretAtOffset") +
    gsi::constant ("CaretWontMatch", &qt_gsi::c_3_QRegExp_CaretMode_Enum, "@brief Enum constant QRegExp::CaretWontMatch");
}

static std::string to_s_QRegExp_CaretMode_Enum (const QRegExp_CaretMode_Enum *e)
{
  if (e->value () == QRegExp::CaretAtZero) { return tl::sprintf ("CaretAtZero (%u)", (unsigned int) e->value ()); }
  if (e->value () == QRegExp::CaretAtOffset) { return tl::sprintf ("CaretAtOffset (%u)", (unsigned int) e->value ()); }
  if (e->value () == QRegExp::CaretWontMatch) { return tl::sprintf ("CaretWontMatch (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QRegExp_CaretMode_Enum (const QRegExp_CaretMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QRegExp_CaretMode_Enum *from_i_QRegExp_CaretMode_Enum (unsigned int i)
{
  return new QRegExp_CaretMode_Enum ((QRegExp::CaretMode) i);
}

static bool equalQRegExp_CaretMode_Enum (const QRegExp_CaretMode_Enum *e, QRegExp_CaretMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QRegExp_CaretMode_Enum (const QRegExp_CaretMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QRegExp_CaretMode_Enums oropQRegExp_CaretMode_Enums (const QRegExp_CaretMode_Enums *e, const QRegExp_CaretMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QRegExp_CaretMode_Enums andopQRegExp_CaretMode_Enums (const QRegExp_CaretMode_Enums *e, const QRegExp_CaretMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QRegExp_CaretMode_Enums xoropQRegExp_CaretMode_Enums (const QRegExp_CaretMode_Enums *e, const QRegExp_CaretMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QRegExp_CaretMode_Enums (const QRegExp_CaretMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QRegExp::CaretAtZero)) { if (!l.empty ()) l += "|"; l += "CaretAtZero"; }
  if (e->testFlag (QRegExp::CaretAtOffset)) { if (!l.empty ()) l += "|"; l += "CaretAtOffset"; }
  if (e->testFlag (QRegExp::CaretWontMatch)) { if (!l.empty ()) l += "|"; l += "CaretWontMatch"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QRegExp_CaretMode_Enums (const QRegExp_CaretMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QRegExp_CaretMode_Enums (const QRegExp_CaretMode_Enums *e, const QRegExp_CaretMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QRegExp_CaretMode_Enums> decl_QRegExp_CaretMode_Enums ("QRegExp_QFlags_CaretMode",
  gsi::method_ext ("|", &qt_gsi::oropQRegExp_CaretMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQRegExp_CaretMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQRegExp_CaretMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QRegExp_CaretMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QRegExp_CaretMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QRegExp_CaretMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QRegExp::CaretMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QRegExp_CaretMode_Enum> decl_QRegExp_CaretMode_Enum (decl_QRegExp_CaretMode_Enums, "QRegExp_CaretMode",
  qt_gsi::mkdefs_QRegExp_CaretMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QRegExp_CaretMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QRegExp_CaretMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQRegExp_CaretMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QRegExp_CaretMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QRegExp_CaretMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QRegExp::CaretMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QRegExp> inject_QRegExp_CaretMode_Enum_in_parent (qt_gsi::mkdefs_QRegExp_CaretMode ());
static gsi::ClassExt<QRegExp> decl_QRegExp_CaretMode_Enum_as_child (decl_QRegExp_CaretMode_Enum, "CaretMode");

}


//  Implementation of the enum wrapper class for QRegExp::PatternSyntax
namespace qt_gsi
{

static QRegExp_PatternSyntax_Enum *c_1_QRegExp_PatternSyntax_Enum () { return new QRegExp_PatternSyntax_Enum (QRegExp::RegExp); }
static QRegExp_PatternSyntax_Enum *c_2_QRegExp_PatternSyntax_Enum () { return new QRegExp_PatternSyntax_Enum (QRegExp::Wildcard); }
static QRegExp_PatternSyntax_Enum *c_3_QRegExp_PatternSyntax_Enum () { return new QRegExp_PatternSyntax_Enum (QRegExp::FixedString); }
static QRegExp_PatternSyntax_Enum *c_4_QRegExp_PatternSyntax_Enum () { return new QRegExp_PatternSyntax_Enum (QRegExp::RegExp2); }
static QRegExp_PatternSyntax_Enum *c_5_QRegExp_PatternSyntax_Enum () { return new QRegExp_PatternSyntax_Enum (QRegExp::WildcardUnix); }
static QRegExp_PatternSyntax_Enum *c_6_QRegExp_PatternSyntax_Enum () { return new QRegExp_PatternSyntax_Enum (QRegExp::W3CXmlSchema11); }

static gsi::Methods mkdefs_QRegExp_PatternSyntax () {
  return
    gsi::constant ("RegExp", &qt_gsi::c_1_QRegExp_PatternSyntax_Enum, "@brief Enum constant QRegExp::RegExp") +
    gsi::constant ("Wildcard", &qt_gsi::c_2_QRegExp_PatternSyntax_Enum, "@brief Enum constant QRegExp::Wildcard") +
    gsi::constant ("FixedString", &qt_gsi::c_3_QRegExp_PatternSyntax_Enum, "@brief Enum constant QRegExp::FixedString") +
    gsi::constant ("RegExp2", &qt_gsi::c_4_QRegExp_PatternSyntax_Enum, "@brief Enum constant QRegExp::RegExp2") +
    gsi::constant ("WildcardUnix", &qt_gsi::c_5_QRegExp_PatternSyntax_Enum, "@brief Enum constant QRegExp::WildcardUnix") +
    gsi::constant ("W3CXmlSchema11", &qt_gsi::c_6_QRegExp_PatternSyntax_Enum, "@brief Enum constant QRegExp::W3CXmlSchema11");
}

static std::string to_s_QRegExp_PatternSyntax_Enum (const QRegExp_PatternSyntax_Enum *e)
{
  if (e->value () == QRegExp::RegExp) { return tl::sprintf ("RegExp (%u)", (unsigned int) e->value ()); }
  if (e->value () == QRegExp::Wildcard) { return tl::sprintf ("Wildcard (%u)", (unsigned int) e->value ()); }
  if (e->value () == QRegExp::FixedString) { return tl::sprintf ("FixedString (%u)", (unsigned int) e->value ()); }
  if (e->value () == QRegExp::RegExp2) { return tl::sprintf ("RegExp2 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QRegExp::WildcardUnix) { return tl::sprintf ("WildcardUnix (%u)", (unsigned int) e->value ()); }
  if (e->value () == QRegExp::W3CXmlSchema11) { return tl::sprintf ("W3CXmlSchema11 (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QRegExp_PatternSyntax_Enum (const QRegExp_PatternSyntax_Enum *e)
{
  return (unsigned int) e->value ();
}

static QRegExp_PatternSyntax_Enum *from_i_QRegExp_PatternSyntax_Enum (unsigned int i)
{
  return new QRegExp_PatternSyntax_Enum ((QRegExp::PatternSyntax) i);
}

static bool equalQRegExp_PatternSyntax_Enum (const QRegExp_PatternSyntax_Enum *e, QRegExp_PatternSyntax_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QRegExp_PatternSyntax_Enum (const QRegExp_PatternSyntax_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QRegExp_PatternSyntax_Enums oropQRegExp_PatternSyntax_Enums (const QRegExp_PatternSyntax_Enums *e, const QRegExp_PatternSyntax_Enums &d)
{
  return e->flags () | d.flags ();
}

static QRegExp_PatternSyntax_Enums andopQRegExp_PatternSyntax_Enums (const QRegExp_PatternSyntax_Enums *e, const QRegExp_PatternSyntax_Enums &d)
{
  return e->flags () & d.flags ();
}

static QRegExp_PatternSyntax_Enums xoropQRegExp_PatternSyntax_Enums (const QRegExp_PatternSyntax_Enums *e, const QRegExp_PatternSyntax_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QRegExp_PatternSyntax_Enums (const QRegExp_PatternSyntax_Enums *e)
{
  std::string l;
  if (e->testFlag (QRegExp::RegExp)) { if (!l.empty ()) l += "|"; l += "RegExp"; }
  if (e->testFlag (QRegExp::Wildcard)) { if (!l.empty ()) l += "|"; l += "Wildcard"; }
  if (e->testFlag (QRegExp::FixedString)) { if (!l.empty ()) l += "|"; l += "FixedString"; }
  if (e->testFlag (QRegExp::RegExp2)) { if (!l.empty ()) l += "|"; l += "RegExp2"; }
  if (e->testFlag (QRegExp::WildcardUnix)) { if (!l.empty ()) l += "|"; l += "WildcardUnix"; }
  if (e->testFlag (QRegExp::W3CXmlSchema11)) { if (!l.empty ()) l += "|"; l += "W3CXmlSchema11"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QRegExp_PatternSyntax_Enums (const QRegExp_PatternSyntax_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QRegExp_PatternSyntax_Enums (const QRegExp_PatternSyntax_Enums *e, const QRegExp_PatternSyntax_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QRegExp_PatternSyntax_Enums> decl_QRegExp_PatternSyntax_Enums ("QRegExp_QFlags_PatternSyntax",
  gsi::method_ext ("|", &qt_gsi::oropQRegExp_PatternSyntax_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQRegExp_PatternSyntax_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQRegExp_PatternSyntax_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QRegExp_PatternSyntax_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QRegExp_PatternSyntax_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QRegExp_PatternSyntax_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QRegExp::PatternSyntax> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QRegExp_PatternSyntax_Enum> decl_QRegExp_PatternSyntax_Enum (decl_QRegExp_PatternSyntax_Enums, "QRegExp_PatternSyntax",
  qt_gsi::mkdefs_QRegExp_PatternSyntax () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QRegExp_PatternSyntax_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QRegExp_PatternSyntax_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQRegExp_PatternSyntax_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QRegExp_PatternSyntax_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QRegExp_PatternSyntax_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QRegExp::PatternSyntax enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QRegExp> inject_QRegExp_PatternSyntax_Enum_in_parent (qt_gsi::mkdefs_QRegExp_PatternSyntax ());
static gsi::ClassExt<QRegExp> decl_QRegExp_PatternSyntax_Enum_as_child (decl_QRegExp_PatternSyntax_Enum, "PatternSyntax");

}

