
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPainterPath.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQPainterPath_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPainterPath

//  Constructor QPainterPath::QPainterPath()


static void _init_ctor_QPainterPath_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QPainterPath *> ();
}

static void _call_ctor_QPainterPath_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPainterPath *> (new QPainterPath ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPainterPath_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPainterPath::QPainterPath()\nThis method creates an object of class QPainterPath.", &_init_ctor_QPainterPath_0, &_call_ctor_QPainterPath_0);
}

//  Constructor QPainterPath::QPainterPath(const QPointF &startPoint)


static void _init_ctor_QPainterPath_1986 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("startPoint");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return_new<QPainterPath *> ();
}

static void _call_ctor_QPainterPath_1986 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ret.write<QPainterPath *> (new QPainterPath (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPainterPath_1986 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPainterPath::QPainterPath(const QPointF &startPoint)\nThis method creates an object of class QPainterPath.", &_init_ctor_QPainterPath_1986, &_call_ctor_QPainterPath_1986);
}

//  Constructor QPainterPath::QPainterPath(const QPainterPath &other)


static void _init_ctor_QPainterPath_2514 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return_new<QPainterPath *> ();
}

static void _call_ctor_QPainterPath_2514 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<QPainterPath *> (new QPainterPath (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPainterPath_2514 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPainterPath::QPainterPath(const QPainterPath &other)\nThis method creates an object of class QPainterPath.", &_init_ctor_QPainterPath_2514, &_call_ctor_QPainterPath_2514);
}

// void QPainterPath::addEllipse(const QRectF &rect)


static void _init_f_addEllipse_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addEllipse_1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ((QPainterPath *)cls)->addEllipse (arg1);
}

static qt_gsi::GenericMethod *_create_f_addEllipse_1862 ()
{
  return new qt_gsi::GenericMethod ("addEllipse", "@brief Method void QPainterPath::addEllipse(const QRectF &rect)\n", false, &_init_f_addEllipse_1862, &_call_f_addEllipse_1862);
}

// void QPainterPath::addEllipse(double x, double y, double w, double h)


static void _init_f_addEllipse_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_addEllipse_3960 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  ((QPainterPath *)cls)->addEllipse (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_addEllipse_3960 ()
{
  return new qt_gsi::GenericMethod ("addEllipse", "@brief Method void QPainterPath::addEllipse(double x, double y, double w, double h)\n", false, &_init_f_addEllipse_3960, &_call_f_addEllipse_3960);
}

// void QPainterPath::addEllipse(const QPointF &center, double rx, double ry)


static void _init_f_addEllipse_3912 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("center");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rx");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("ry");
  decl->add_arg<double > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_addEllipse_3912 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  ((QPainterPath *)cls)->addEllipse (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_addEllipse_3912 ()
{
  return new qt_gsi::GenericMethod ("addEllipse", "@brief Method void QPainterPath::addEllipse(const QPointF &center, double rx, double ry)\n", false, &_init_f_addEllipse_3912, &_call_f_addEllipse_3912);
}

// void QPainterPath::addPath(const QPainterPath &path)


static void _init_f_addPath_2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addPath_2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ((QPainterPath *)cls)->addPath (arg1);
}

static qt_gsi::GenericMethod *_create_f_addPath_2514 ()
{
  return new qt_gsi::GenericMethod ("addPath", "@brief Method void QPainterPath::addPath(const QPainterPath &path)\n", false, &_init_f_addPath_2514, &_call_f_addPath_2514);
}

// void QPainterPath::addPolygon(const QPolygonF &polygon)


static void _init_f_addPolygon_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addPolygon_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygonF &arg1 = args.read<const QPolygonF & > ();
  ((QPainterPath *)cls)->addPolygon (arg1);
}

static qt_gsi::GenericMethod *_create_f_addPolygon_2208 ()
{
  return new qt_gsi::GenericMethod ("addPolygon", "@brief Method void QPainterPath::addPolygon(const QPolygonF &polygon)\n", false, &_init_f_addPolygon_2208, &_call_f_addPolygon_2208);
}

// void QPainterPath::addRect(const QRectF &rect)


static void _init_f_addRect_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addRect_1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ((QPainterPath *)cls)->addRect (arg1);
}

static qt_gsi::GenericMethod *_create_f_addRect_1862 ()
{
  return new qt_gsi::GenericMethod ("addRect", "@brief Method void QPainterPath::addRect(const QRectF &rect)\n", false, &_init_f_addRect_1862, &_call_f_addRect_1862);
}

// void QPainterPath::addRect(double x, double y, double w, double h)


static void _init_f_addRect_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_addRect_3960 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  ((QPainterPath *)cls)->addRect (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_addRect_3960 ()
{
  return new qt_gsi::GenericMethod ("addRect", "@brief Method void QPainterPath::addRect(double x, double y, double w, double h)\n", false, &_init_f_addRect_3960, &_call_f_addRect_3960);
}

// void QPainterPath::addRegion(const QRegion &region)


static void _init_f_addRegion_2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("region");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addRegion_2006 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRegion &arg1 = args.read<const QRegion & > ();
  ((QPainterPath *)cls)->addRegion (arg1);
}

static qt_gsi::GenericMethod *_create_f_addRegion_2006 ()
{
  return new qt_gsi::GenericMethod ("addRegion", "@brief Method void QPainterPath::addRegion(const QRegion &region)\n", false, &_init_f_addRegion_2006, &_call_f_addRegion_2006);
}

// void QPainterPath::addRoundRect(const QRectF &rect, int xRnd, int yRnd)


static void _init_f_addRoundRect_3180 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("xRnd");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("yRnd");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_addRoundRect_3180 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QPainterPath *)cls)->addRoundRect (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_addRoundRect_3180 ()
{
  return new qt_gsi::GenericMethod ("addRoundRect", "@brief Method void QPainterPath::addRoundRect(const QRectF &rect, int xRnd, int yRnd)\n", false, &_init_f_addRoundRect_3180, &_call_f_addRoundRect_3180);
}

// void QPainterPath::addRoundRect(double x, double y, double w, double h, int xRnd, int yRnd)


static void _init_f_addRoundRect_5278 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("xRnd");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("yRnd");
  decl->add_arg<int > (argspec_5);
  decl->set_return<void > ();
}

static void _call_f_addRoundRect_5278 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  int arg5 = args.read<int > ();
  int arg6 = args.read<int > ();
  ((QPainterPath *)cls)->addRoundRect (arg1, arg2, arg3, arg4, arg5, arg6);
}

static qt_gsi::GenericMethod *_create_f_addRoundRect_5278 ()
{
  return new qt_gsi::GenericMethod ("addRoundRect", "@brief Method void QPainterPath::addRoundRect(double x, double y, double w, double h, int xRnd, int yRnd)\n", false, &_init_f_addRoundRect_5278, &_call_f_addRoundRect_5278);
}

// void QPainterPath::addRoundRect(const QRectF &rect, int roundness)


static void _init_f_addRoundRect_2521 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("roundness");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addRoundRect_2521 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  int arg2 = args.read<int > ();
  ((QPainterPath *)cls)->addRoundRect (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_addRoundRect_2521 ()
{
  return new qt_gsi::GenericMethod ("addRoundRect", "@brief Method void QPainterPath::addRoundRect(const QRectF &rect, int roundness)\n", false, &_init_f_addRoundRect_2521, &_call_f_addRoundRect_2521);
}

// void QPainterPath::addRoundRect(double x, double y, double w, double h, int roundness)


static void _init_f_addRoundRect_4619 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("roundness");
  decl->add_arg<int > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_addRoundRect_4619 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  int arg5 = args.read<int > ();
  ((QPainterPath *)cls)->addRoundRect (arg1, arg2, arg3, arg4, arg5);
}

static qt_gsi::GenericMethod *_create_f_addRoundRect_4619 ()
{
  return new qt_gsi::GenericMethod ("addRoundRect", "@brief Method void QPainterPath::addRoundRect(double x, double y, double w, double h, int roundness)\n", false, &_init_f_addRoundRect_4619, &_call_f_addRoundRect_4619);
}

// void QPainterPath::addRoundedRect(const QRectF &rect, double xRadius, double yRadius, Qt::SizeMode mode)


static void _init_f_addRoundedRect_5229 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("xRadius");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("yRadius");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("mode", true, "Qt::AbsoluteSize");
  decl->add_arg<const qt_gsi::Converter<Qt::SizeMode>::target_type & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_addRoundedRect_5229 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::SizeMode>::target_type & arg4 = args ? args.read<const qt_gsi::Converter<Qt::SizeMode>::target_type & > () : (const qt_gsi::Converter<Qt::SizeMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::SizeMode>(heap, Qt::AbsoluteSize));
  ((QPainterPath *)cls)->addRoundedRect (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<Qt::SizeMode>(arg4).cref());
}

static qt_gsi::GenericMethod *_create_f_addRoundedRect_5229 ()
{
  return new qt_gsi::GenericMethod ("addRoundedRect", "@brief Method void QPainterPath::addRoundedRect(const QRectF &rect, double xRadius, double yRadius, Qt::SizeMode mode)\n", false, &_init_f_addRoundedRect_5229, &_call_f_addRoundedRect_5229);
}

// void QPainterPath::addRoundedRect(double x, double y, double w, double h, double xRadius, double yRadius, Qt::SizeMode mode)


static void _init_f_addRoundedRect_7327 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("xRadius");
  decl->add_arg<double > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("yRadius");
  decl->add_arg<double > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("mode", true, "Qt::AbsoluteSize");
  decl->add_arg<const qt_gsi::Converter<Qt::SizeMode>::target_type & > (argspec_6);
  decl->set_return<void > ();
}

static void _call_f_addRoundedRect_7327 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  double arg5 = args.read<double > ();
  double arg6 = args.read<double > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::SizeMode>::target_type & arg7 = args ? args.read<const qt_gsi::Converter<Qt::SizeMode>::target_type & > () : (const qt_gsi::Converter<Qt::SizeMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::SizeMode>(heap, Qt::AbsoluteSize));
  ((QPainterPath *)cls)->addRoundedRect (arg1, arg2, arg3, arg4, arg5, arg6, qt_gsi::QtToCppAdaptor<Qt::SizeMode>(arg7).cref());
}

static qt_gsi::GenericMethod *_create_f_addRoundedRect_7327 ()
{
  return new qt_gsi::GenericMethod ("addRoundedRect", "@brief Method void QPainterPath::addRoundedRect(double x, double y, double w, double h, double xRadius, double yRadius, Qt::SizeMode mode)\n", false, &_init_f_addRoundedRect_7327, &_call_f_addRoundedRect_7327);
}

// void QPainterPath::addText(const QPointF &point, const QFont &f, const QString &text)


static void _init_f_addText_5596 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("f");
  decl->add_arg<const QFont & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_addText_5596 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  const QFont &arg2 = args.read<const QFont & > ();
  const QString &arg3 = args.read<const QString & > ();
  ((QPainterPath *)cls)->addText (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_addText_5596 ()
{
  return new qt_gsi::GenericMethod ("addText", "@brief Method void QPainterPath::addText(const QPointF &point, const QFont &f, const QString &text)\n", false, &_init_f_addText_5596, &_call_f_addText_5596);
}

// void QPainterPath::addText(double x, double y, const QFont &f, const QString &text)


static void _init_f_addText_5644 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("f");
  decl->add_arg<const QFont & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("text");
  decl->add_arg<const QString & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_addText_5644 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  const QFont &arg3 = args.read<const QFont & > ();
  const QString &arg4 = args.read<const QString & > ();
  ((QPainterPath *)cls)->addText (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_addText_5644 ()
{
  return new qt_gsi::GenericMethod ("addText", "@brief Method void QPainterPath::addText(double x, double y, const QFont &f, const QString &text)\n", false, &_init_f_addText_5644, &_call_f_addText_5644);
}

// double QPainterPath::angleAtPercent(double t)


static void _init_f_angleAtPercent_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("t");
  decl->add_arg<double > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_angleAtPercent_c1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<double > ((double)((QPainterPath *)cls)->angleAtPercent (arg1));
}

static qt_gsi::GenericMethod *_create_f_angleAtPercent_c1071 ()
{
  return new qt_gsi::GenericMethod ("angleAtPercent", "@brief Method double QPainterPath::angleAtPercent(double t)\n", true, &_init_f_angleAtPercent_c1071, &_call_f_angleAtPercent_c1071);
}

// void QPainterPath::arcMoveTo(const QRectF &rect, double angle)


static void _init_f_arcMoveTo_2825 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("angle");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_arcMoveTo_2825 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  double arg2 = args.read<double > ();
  ((QPainterPath *)cls)->arcMoveTo (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_arcMoveTo_2825 ()
{
  return new qt_gsi::GenericMethod ("arcMoveTo", "@brief Method void QPainterPath::arcMoveTo(const QRectF &rect, double angle)\n", false, &_init_f_arcMoveTo_2825, &_call_f_arcMoveTo_2825);
}

// void QPainterPath::arcMoveTo(double x, double y, double w, double h, double angle)


static void _init_f_arcMoveTo_4923 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("angle");
  decl->add_arg<double > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_arcMoveTo_4923 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  double arg5 = args.read<double > ();
  ((QPainterPath *)cls)->arcMoveTo (arg1, arg2, arg3, arg4, arg5);
}

static qt_gsi::GenericMethod *_create_f_arcMoveTo_4923 ()
{
  return new qt_gsi::GenericMethod ("arcMoveTo", "@brief Method void QPainterPath::arcMoveTo(double x, double y, double w, double h, double angle)\n", false, &_init_f_arcMoveTo_4923, &_call_f_arcMoveTo_4923);
}

// void QPainterPath::arcTo(const QRectF &rect, double startAngle, double arcLength)


static void _init_f_arcTo_3788 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("startAngle");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("arcLength");
  decl->add_arg<double > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_arcTo_3788 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  ((QPainterPath *)cls)->arcTo (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_arcTo_3788 ()
{
  return new qt_gsi::GenericMethod ("arcTo", "@brief Method void QPainterPath::arcTo(const QRectF &rect, double startAngle, double arcLength)\n", false, &_init_f_arcTo_3788, &_call_f_arcTo_3788);
}

// void QPainterPath::arcTo(double x, double y, double w, double h, double startAngle, double arcLength)


static void _init_f_arcTo_5886 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("startAngle");
  decl->add_arg<double > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("arcLength");
  decl->add_arg<double > (argspec_5);
  decl->set_return<void > ();
}

static void _call_f_arcTo_5886 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  double arg5 = args.read<double > ();
  double arg6 = args.read<double > ();
  ((QPainterPath *)cls)->arcTo (arg1, arg2, arg3, arg4, arg5, arg6);
}

static qt_gsi::GenericMethod *_create_f_arcTo_5886 ()
{
  return new qt_gsi::GenericMethod ("arcTo", "@brief Method void QPainterPath::arcTo(double x, double y, double w, double h, double startAngle, double arcLength)\n", false, &_init_f_arcTo_5886, &_call_f_arcTo_5886);
}

// QRectF QPainterPath::boundingRect()


static void _init_f_boundingRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_boundingRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRectF > ((QRectF)((QPainterPath *)cls)->boundingRect ());
}

static qt_gsi::GenericMethod *_create_f_boundingRect_c0 ()
{
  return new qt_gsi::GenericMethod ("boundingRect", "@brief Method QRectF QPainterPath::boundingRect()\n", true, &_init_f_boundingRect_c0, &_call_f_boundingRect_c0);
}

// void QPainterPath::closeSubpath()


static void _init_f_closeSubpath_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_closeSubpath_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPainterPath *)cls)->closeSubpath ();
}

static qt_gsi::GenericMethod *_create_f_closeSubpath_0 ()
{
  return new qt_gsi::GenericMethod ("closeSubpath", "@brief Method void QPainterPath::closeSubpath()\n", false, &_init_f_closeSubpath_0, &_call_f_closeSubpath_0);
}

// void QPainterPath::connectPath(const QPainterPath &path)


static void _init_f_connectPath_2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_connectPath_2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ((QPainterPath *)cls)->connectPath (arg1);
}

static qt_gsi::GenericMethod *_create_f_connectPath_2514 ()
{
  return new qt_gsi::GenericMethod ("connectPath", "@brief Method void QPainterPath::connectPath(const QPainterPath &path)\n", false, &_init_f_connectPath_2514, &_call_f_connectPath_2514);
}

// bool QPainterPath::contains(const QPointF &pt)


static void _init_f_contains_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pt");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_contains_c1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ret.write<bool > ((bool)((QPainterPath *)cls)->contains (arg1));
}

static qt_gsi::GenericMethod *_create_f_contains_c1986 ()
{
  return new qt_gsi::GenericMethod ("contains", "@brief Method bool QPainterPath::contains(const QPointF &pt)\n", true, &_init_f_contains_c1986, &_call_f_contains_c1986);
}

// bool QPainterPath::contains(const QRectF &rect)


static void _init_f_contains_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_contains_c1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ret.write<bool > ((bool)((QPainterPath *)cls)->contains (arg1));
}

static qt_gsi::GenericMethod *_create_f_contains_c1862 ()
{
  return new qt_gsi::GenericMethod ("contains", "@brief Method bool QPainterPath::contains(const QRectF &rect)\n", true, &_init_f_contains_c1862, &_call_f_contains_c1862);
}

// bool QPainterPath::contains(const QPainterPath &p)


static void _init_f_contains_c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_contains_c2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<bool > ((bool)((QPainterPath *)cls)->contains (arg1));
}

static qt_gsi::GenericMethod *_create_f_contains_c2514 ()
{
  return new qt_gsi::GenericMethod ("contains", "@brief Method bool QPainterPath::contains(const QPainterPath &p)\n", true, &_init_f_contains_c2514, &_call_f_contains_c2514);
}

// QRectF QPainterPath::controlPointRect()


static void _init_f_controlPointRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_controlPointRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRectF > ((QRectF)((QPainterPath *)cls)->controlPointRect ());
}

static qt_gsi::GenericMethod *_create_f_controlPointRect_c0 ()
{
  return new qt_gsi::GenericMethod ("controlPointRect", "@brief Method QRectF QPainterPath::controlPointRect()\n", true, &_init_f_controlPointRect_c0, &_call_f_controlPointRect_c0);
}

// void QPainterPath::cubicTo(const QPointF &ctrlPt1, const QPointF &ctrlPt2, const QPointF &endPt)


static void _init_f_cubicTo_5742 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ctrlPt1");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ctrlPt2");
  decl->add_arg<const QPointF & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("endPt");
  decl->add_arg<const QPointF & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_cubicTo_5742 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  const QPointF &arg2 = args.read<const QPointF & > ();
  const QPointF &arg3 = args.read<const QPointF & > ();
  ((QPainterPath *)cls)->cubicTo (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_cubicTo_5742 ()
{
  return new qt_gsi::GenericMethod ("cubicTo", "@brief Method void QPainterPath::cubicTo(const QPointF &ctrlPt1, const QPointF &ctrlPt2, const QPointF &endPt)\n", false, &_init_f_cubicTo_5742, &_call_f_cubicTo_5742);
}

// void QPainterPath::cubicTo(double ctrlPt1x, double ctrlPt1y, double ctrlPt2x, double ctrlPt2y, double endPtx, double endPty)


static void _init_f_cubicTo_5886 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ctrlPt1x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ctrlPt1y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("ctrlPt2x");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("ctrlPt2y");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("endPtx");
  decl->add_arg<double > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("endPty");
  decl->add_arg<double > (argspec_5);
  decl->set_return<void > ();
}

static void _call_f_cubicTo_5886 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  double arg5 = args.read<double > ();
  double arg6 = args.read<double > ();
  ((QPainterPath *)cls)->cubicTo (arg1, arg2, arg3, arg4, arg5, arg6);
}

static qt_gsi::GenericMethod *_create_f_cubicTo_5886 ()
{
  return new qt_gsi::GenericMethod ("cubicTo", "@brief Method void QPainterPath::cubicTo(double ctrlPt1x, double ctrlPt1y, double ctrlPt2x, double ctrlPt2y, double endPtx, double endPty)\n", false, &_init_f_cubicTo_5886, &_call_f_cubicTo_5886);
}

// QPointF QPainterPath::currentPosition()


static void _init_f_currentPosition_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_currentPosition_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPointF > ((QPointF)((QPainterPath *)cls)->currentPosition ());
}

static qt_gsi::GenericMethod *_create_f_currentPosition_c0 ()
{
  return new qt_gsi::GenericMethod ("currentPosition", "@brief Method QPointF QPainterPath::currentPosition()\n", true, &_init_f_currentPosition_c0, &_call_f_currentPosition_c0);
}

// const QPainterPath::Element &QPainterPath::elementAt(int i)


static void _init_f_elementAt_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<int > (argspec_0);
  decl->set_return<const QPainterPath::Element & > ();
}

static void _call_f_elementAt_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<const QPainterPath::Element & > ((const QPainterPath::Element &)((QPainterPath *)cls)->elementAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_elementAt_c767 ()
{
  return new qt_gsi::GenericMethod ("elementAt", "@brief Method const QPainterPath::Element &QPainterPath::elementAt(int i)\n", true, &_init_f_elementAt_c767, &_call_f_elementAt_c767);
}

// int QPainterPath::elementCount()


static void _init_f_elementCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_elementCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QPainterPath *)cls)->elementCount ());
}

static qt_gsi::GenericMethod *_create_f_elementCount_c0 ()
{
  return new qt_gsi::GenericMethod ("elementCount", "@brief Method int QPainterPath::elementCount()\n", true, &_init_f_elementCount_c0, &_call_f_elementCount_c0);
}

// Qt::FillRule QPainterPath::fillRule()


static void _init_f_fillRule_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::FillRule>::target_type > ();
}

static void _call_f_fillRule_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::FillRule>::target_type > ((qt_gsi::Converter<Qt::FillRule>::target_type)qt_gsi::CppToQtAdaptor<Qt::FillRule>(((QPainterPath *)cls)->fillRule ()));
}

static qt_gsi::GenericMethod *_create_f_fillRule_c0 ()
{
  return new qt_gsi::GenericMethod (":fillRule", "@brief Method Qt::FillRule QPainterPath::fillRule()\n", true, &_init_f_fillRule_c0, &_call_f_fillRule_c0);
}

// QPainterPath QPainterPath::intersected(const QPainterPath &r)


static void _init_f_intersected_c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_intersected_c2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<QPainterPath > ((QPainterPath)((QPainterPath *)cls)->intersected (arg1));
}

static qt_gsi::GenericMethod *_create_f_intersected_c2514 ()
{
  return new qt_gsi::GenericMethod ("intersected", "@brief Method QPainterPath QPainterPath::intersected(const QPainterPath &r)\n", true, &_init_f_intersected_c2514, &_call_f_intersected_c2514);
}

// bool QPainterPath::intersects(const QRectF &rect)


static void _init_f_intersects_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_intersects_c1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ret.write<bool > ((bool)((QPainterPath *)cls)->intersects (arg1));
}

static qt_gsi::GenericMethod *_create_f_intersects_c1862 ()
{
  return new qt_gsi::GenericMethod ("intersects", "@brief Method bool QPainterPath::intersects(const QRectF &rect)\n", true, &_init_f_intersects_c1862, &_call_f_intersects_c1862);
}

// bool QPainterPath::intersects(const QPainterPath &p)


static void _init_f_intersects_c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_intersects_c2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<bool > ((bool)((QPainterPath *)cls)->intersects (arg1));
}

static qt_gsi::GenericMethod *_create_f_intersects_c2514 ()
{
  return new qt_gsi::GenericMethod ("intersects", "@brief Method bool QPainterPath::intersects(const QPainterPath &p)\n", true, &_init_f_intersects_c2514, &_call_f_intersects_c2514);
}

// bool QPainterPath::isEmpty()


static void _init_f_isEmpty_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEmpty_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPainterPath *)cls)->isEmpty ());
}

static qt_gsi::GenericMethod *_create_f_isEmpty_c0 ()
{
  return new qt_gsi::GenericMethod ("isEmpty?", "@brief Method bool QPainterPath::isEmpty()\n", true, &_init_f_isEmpty_c0, &_call_f_isEmpty_c0);
}

// double QPainterPath::length()


static void _init_f_length_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_length_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QPainterPath *)cls)->length ());
}

static qt_gsi::GenericMethod *_create_f_length_c0 ()
{
  return new qt_gsi::GenericMethod ("length", "@brief Method double QPainterPath::length()\n", true, &_init_f_length_c0, &_call_f_length_c0);
}

// void QPainterPath::lineTo(const QPointF &p)


static void _init_f_lineTo_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_lineTo_1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ((QPainterPath *)cls)->lineTo (arg1);
}

static qt_gsi::GenericMethod *_create_f_lineTo_1986 ()
{
  return new qt_gsi::GenericMethod ("lineTo", "@brief Method void QPainterPath::lineTo(const QPointF &p)\n", false, &_init_f_lineTo_1986, &_call_f_lineTo_1986);
}

// void QPainterPath::lineTo(double x, double y)


static void _init_f_lineTo_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_lineTo_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ((QPainterPath *)cls)->lineTo (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_lineTo_2034 ()
{
  return new qt_gsi::GenericMethod ("lineTo", "@brief Method void QPainterPath::lineTo(double x, double y)\n", false, &_init_f_lineTo_2034, &_call_f_lineTo_2034);
}

// void QPainterPath::moveTo(const QPointF &p)


static void _init_f_moveTo_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_moveTo_1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ((QPainterPath *)cls)->moveTo (arg1);
}

static qt_gsi::GenericMethod *_create_f_moveTo_1986 ()
{
  return new qt_gsi::GenericMethod ("moveTo", "@brief Method void QPainterPath::moveTo(const QPointF &p)\n", false, &_init_f_moveTo_1986, &_call_f_moveTo_1986);
}

// void QPainterPath::moveTo(double x, double y)


static void _init_f_moveTo_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_moveTo_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ((QPainterPath *)cls)->moveTo (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_moveTo_2034 ()
{
  return new qt_gsi::GenericMethod ("moveTo", "@brief Method void QPainterPath::moveTo(double x, double y)\n", false, &_init_f_moveTo_2034, &_call_f_moveTo_2034);
}

// bool QPainterPath::operator!=(const QPainterPath &other)


static void _init_f_operator_excl__eq__c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<bool > ((bool)((QPainterPath *)cls)->operator!= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__c2514 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QPainterPath::operator!=(const QPainterPath &other)\n", true, &_init_f_operator_excl__eq__c2514, &_call_f_operator_excl__eq__c2514);
}

// QPainterPath QPainterPath::operator&(const QPainterPath &other)


static void _init_f_operator_amp__c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_operator_amp__c2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<QPainterPath > ((QPainterPath)((QPainterPath *)cls)->operator& (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_amp__c2514 ()
{
  return new qt_gsi::GenericMethod ("&", "@brief Method QPainterPath QPainterPath::operator&(const QPainterPath &other)\n", true, &_init_f_operator_amp__c2514, &_call_f_operator_amp__c2514);
}

// QPainterPath &QPainterPath::operator&=(const QPainterPath &other)


static void _init_f_operator_amp__eq__2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath & > ();
}

static void _call_f_operator_amp__eq__2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<QPainterPath & > ((QPainterPath &)((QPainterPath *)cls)->operator&= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_amp__eq__2514 ()
{
  return new qt_gsi::GenericMethod ("&=", "@brief Method QPainterPath &QPainterPath::operator&=(const QPainterPath &other)\n", false, &_init_f_operator_amp__eq__2514, &_call_f_operator_amp__eq__2514);
}

// QPainterPath QPainterPath::operator+(const QPainterPath &other)


static void _init_f_operator_plus__c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_operator_plus__c2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<QPainterPath > ((QPainterPath)((QPainterPath *)cls)->operator+ (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_plus__c2514 ()
{
  return new qt_gsi::GenericMethod ("+", "@brief Method QPainterPath QPainterPath::operator+(const QPainterPath &other)\n", true, &_init_f_operator_plus__c2514, &_call_f_operator_plus__c2514);
}

// QPainterPath &QPainterPath::operator+=(const QPainterPath &other)


static void _init_f_operator_plus__eq__2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath & > ();
}

static void _call_f_operator_plus__eq__2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<QPainterPath & > ((QPainterPath &)((QPainterPath *)cls)->operator+= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_plus__eq__2514 ()
{
  return new qt_gsi::GenericMethod ("+=", "@brief Method QPainterPath &QPainterPath::operator+=(const QPainterPath &other)\n", false, &_init_f_operator_plus__eq__2514, &_call_f_operator_plus__eq__2514);
}

// QPainterPath QPainterPath::operator-(const QPainterPath &other)


static void _init_f_operator_minus__c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_operator_minus__c2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<QPainterPath > ((QPainterPath)((QPainterPath *)cls)->operator- (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_minus__c2514 ()
{
  return new qt_gsi::GenericMethod ("-", "@brief Method QPainterPath QPainterPath::operator-(const QPainterPath &other)\n", true, &_init_f_operator_minus__c2514, &_call_f_operator_minus__c2514);
}

// QPainterPath &QPainterPath::operator-=(const QPainterPath &other)


static void _init_f_operator_minus__eq__2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath & > ();
}

static void _call_f_operator_minus__eq__2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<QPainterPath & > ((QPainterPath &)((QPainterPath *)cls)->operator-= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_minus__eq__2514 ()
{
  return new qt_gsi::GenericMethod ("-=", "@brief Method QPainterPath &QPainterPath::operator-=(const QPainterPath &other)\n", false, &_init_f_operator_minus__eq__2514, &_call_f_operator_minus__eq__2514);
}

// QPainterPath &QPainterPath::operator=(const QPainterPath &other)


static void _init_f_operator_eq__2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath & > ();
}

static void _call_f_operator_eq__2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<QPainterPath & > ((QPainterPath &)((QPainterPath *)cls)->operator= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__2514 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QPainterPath &QPainterPath::operator=(const QPainterPath &other)\n", false, &_init_f_operator_eq__2514, &_call_f_operator_eq__2514);
}

// bool QPainterPath::operator==(const QPainterPath &other)


static void _init_f_operator_eq__eq__c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<bool > ((bool)((QPainterPath *)cls)->operator== (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__c2514 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QPainterPath::operator==(const QPainterPath &other)\n", true, &_init_f_operator_eq__eq__c2514, &_call_f_operator_eq__eq__c2514);
}

// QPainterPath QPainterPath::operator|(const QPainterPath &other)


static void _init_f_operator_pipe__c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_operator_pipe__c2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<QPainterPath > ((QPainterPath)((QPainterPath *)cls)->operator| (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_pipe__c2514 ()
{
  return new qt_gsi::GenericMethod ("|", "@brief Method QPainterPath QPainterPath::operator|(const QPainterPath &other)\n", true, &_init_f_operator_pipe__c2514, &_call_f_operator_pipe__c2514);
}

// QPainterPath &QPainterPath::operator|=(const QPainterPath &other)


static void _init_f_operator_pipe__eq__2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath & > ();
}

static void _call_f_operator_pipe__eq__2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<QPainterPath & > ((QPainterPath &)((QPainterPath *)cls)->operator|= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_pipe__eq__2514 ()
{
  return new qt_gsi::GenericMethod ("|=", "@brief Method QPainterPath &QPainterPath::operator|=(const QPainterPath &other)\n", false, &_init_f_operator_pipe__eq__2514, &_call_f_operator_pipe__eq__2514);
}

// double QPainterPath::percentAtLength(double t)


static void _init_f_percentAtLength_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("t");
  decl->add_arg<double > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_percentAtLength_c1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<double > ((double)((QPainterPath *)cls)->percentAtLength (arg1));
}

static qt_gsi::GenericMethod *_create_f_percentAtLength_c1071 ()
{
  return new qt_gsi::GenericMethod ("percentAtLength", "@brief Method double QPainterPath::percentAtLength(double t)\n", true, &_init_f_percentAtLength_c1071, &_call_f_percentAtLength_c1071);
}

// QPointF QPainterPath::pointAtPercent(double t)


static void _init_f_pointAtPercent_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("t");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QPointF > ();
}

static void _call_f_pointAtPercent_c1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<QPointF > ((QPointF)((QPainterPath *)cls)->pointAtPercent (arg1));
}

static qt_gsi::GenericMethod *_create_f_pointAtPercent_c1071 ()
{
  return new qt_gsi::GenericMethod ("pointAtPercent", "@brief Method QPointF QPainterPath::pointAtPercent(double t)\n", true, &_init_f_pointAtPercent_c1071, &_call_f_pointAtPercent_c1071);
}

// void QPainterPath::quadTo(const QPointF &ctrlPt, const QPointF &endPt)


static void _init_f_quadTo_3864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ctrlPt");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("endPt");
  decl->add_arg<const QPointF & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_quadTo_3864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  const QPointF &arg2 = args.read<const QPointF & > ();
  ((QPainterPath *)cls)->quadTo (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_quadTo_3864 ()
{
  return new qt_gsi::GenericMethod ("quadTo", "@brief Method void QPainterPath::quadTo(const QPointF &ctrlPt, const QPointF &endPt)\n", false, &_init_f_quadTo_3864, &_call_f_quadTo_3864);
}

// void QPainterPath::quadTo(double ctrlPtx, double ctrlPty, double endPtx, double endPty)


static void _init_f_quadTo_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ctrlPtx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ctrlPty");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("endPtx");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("endPty");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_quadTo_3960 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  ((QPainterPath *)cls)->quadTo (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_quadTo_3960 ()
{
  return new qt_gsi::GenericMethod ("quadTo", "@brief Method void QPainterPath::quadTo(double ctrlPtx, double ctrlPty, double endPtx, double endPty)\n", false, &_init_f_quadTo_3960, &_call_f_quadTo_3960);
}

// void QPainterPath::setElementPositionAt(int i, double x, double y)


static void _init_f_setElementPositionAt_2693 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("x");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y");
  decl->add_arg<double > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setElementPositionAt_2693 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  ((QPainterPath *)cls)->setElementPositionAt (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_setElementPositionAt_2693 ()
{
  return new qt_gsi::GenericMethod ("setElementPositionAt", "@brief Method void QPainterPath::setElementPositionAt(int i, double x, double y)\n", false, &_init_f_setElementPositionAt_2693, &_call_f_setElementPositionAt_2693);
}

// void QPainterPath::setFillRule(Qt::FillRule fillRule)


static void _init_f_setFillRule_1548 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fillRule");
  decl->add_arg<const qt_gsi::Converter<Qt::FillRule>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFillRule_1548 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::FillRule>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::FillRule>::target_type & > ();
  ((QPainterPath *)cls)->setFillRule (qt_gsi::QtToCppAdaptor<Qt::FillRule>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setFillRule_1548 ()
{
  return new qt_gsi::GenericMethod ("setFillRule|fillRule=", "@brief Method void QPainterPath::setFillRule(Qt::FillRule fillRule)\n", false, &_init_f_setFillRule_1548, &_call_f_setFillRule_1548);
}

// QPainterPath QPainterPath::simplified()


static void _init_f_simplified_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_f_simplified_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPainterPath > ((QPainterPath)((QPainterPath *)cls)->simplified ());
}

static qt_gsi::GenericMethod *_create_f_simplified_c0 ()
{
  return new qt_gsi::GenericMethod ("simplified", "@brief Method QPainterPath QPainterPath::simplified()\n", true, &_init_f_simplified_c0, &_call_f_simplified_c0);
}

// double QPainterPath::slopeAtPercent(double t)


static void _init_f_slopeAtPercent_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("t");
  decl->add_arg<double > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_slopeAtPercent_c1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<double > ((double)((QPainterPath *)cls)->slopeAtPercent (arg1));
}

static qt_gsi::GenericMethod *_create_f_slopeAtPercent_c1071 ()
{
  return new qt_gsi::GenericMethod ("slopeAtPercent", "@brief Method double QPainterPath::slopeAtPercent(double t)\n", true, &_init_f_slopeAtPercent_c1071, &_call_f_slopeAtPercent_c1071);
}

// QPainterPath QPainterPath::subtracted(const QPainterPath &r)


static void _init_f_subtracted_c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_subtracted_c2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<QPainterPath > ((QPainterPath)((QPainterPath *)cls)->subtracted (arg1));
}

static qt_gsi::GenericMethod *_create_f_subtracted_c2514 ()
{
  return new qt_gsi::GenericMethod ("subtracted", "@brief Method QPainterPath QPainterPath::subtracted(const QPainterPath &r)\n", true, &_init_f_subtracted_c2514, &_call_f_subtracted_c2514);
}

// QPainterPath QPainterPath::subtractedInverted(const QPainterPath &r)


static void _init_f_subtractedInverted_c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_subtractedInverted_c2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<QPainterPath > ((QPainterPath)((QPainterPath *)cls)->subtractedInverted (arg1));
}

static qt_gsi::GenericMethod *_create_f_subtractedInverted_c2514 ()
{
  return new qt_gsi::GenericMethod ("subtractedInverted", "@brief Method QPainterPath QPainterPath::subtractedInverted(const QPainterPath &r)\n", true, &_init_f_subtractedInverted_c2514, &_call_f_subtractedInverted_c2514);
}

// QPolygonF QPainterPath::toFillPolygon(const QMatrix &matrix)


static void _init_f_toFillPolygon_c2023 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix", true, "QMatrix()");
  decl->add_arg<const QMatrix & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_toFillPolygon_c2023 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMatrix &arg1 = args ? args.read<const QMatrix & > () : (const QMatrix &)(QMatrix());
  ret.write<QPolygonF > ((QPolygonF)((QPainterPath *)cls)->toFillPolygon (arg1));
}

static qt_gsi::GenericMethod *_create_f_toFillPolygon_c2023 ()
{
  return new qt_gsi::GenericMethod ("toFillPolygon", "@brief Method QPolygonF QPainterPath::toFillPolygon(const QMatrix &matrix)\n", true, &_init_f_toFillPolygon_c2023, &_call_f_toFillPolygon_c2023);
}

// QPolygonF QPainterPath::toFillPolygon(const QTransform &matrix)


static void _init_f_toFillPolygon_c2350 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix");
  decl->add_arg<const QTransform & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_toFillPolygon_c2350 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTransform &arg1 = args.read<const QTransform & > ();
  ret.write<QPolygonF > ((QPolygonF)((QPainterPath *)cls)->toFillPolygon (arg1));
}

static qt_gsi::GenericMethod *_create_f_toFillPolygon_c2350 ()
{
  return new qt_gsi::GenericMethod ("toFillPolygon", "@brief Method QPolygonF QPainterPath::toFillPolygon(const QTransform &matrix)\n", true, &_init_f_toFillPolygon_c2350, &_call_f_toFillPolygon_c2350);
}

// QList<QPolygonF> QPainterPath::toFillPolygons(const QMatrix &matrix)


static void _init_f_toFillPolygons_c2023 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix", true, "QMatrix()");
  decl->add_arg<const QMatrix & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QList<QPolygonF> >::target_type > ();
}

static void _call_f_toFillPolygons_c2023 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMatrix &arg1 = args ? args.read<const QMatrix & > () : (const QMatrix &)(QMatrix());
  ret.write<qt_gsi::Converter<QList<QPolygonF> >::target_type > ((qt_gsi::Converter<QList<QPolygonF> >::target_type)qt_gsi::CppToQtAdaptor<QList<QPolygonF> >(((QPainterPath *)cls)->toFillPolygons (arg1)));
}

static qt_gsi::GenericMethod *_create_f_toFillPolygons_c2023 ()
{
  return new qt_gsi::GenericMethod ("toFillPolygons", "@brief Method QList<QPolygonF> QPainterPath::toFillPolygons(const QMatrix &matrix)\n", true, &_init_f_toFillPolygons_c2023, &_call_f_toFillPolygons_c2023);
}

// QList<QPolygonF> QPainterPath::toFillPolygons(const QTransform &matrix)


static void _init_f_toFillPolygons_c2350 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix");
  decl->add_arg<const QTransform & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QList<QPolygonF> >::target_type > ();
}

static void _call_f_toFillPolygons_c2350 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTransform &arg1 = args.read<const QTransform & > ();
  ret.write<qt_gsi::Converter<QList<QPolygonF> >::target_type > ((qt_gsi::Converter<QList<QPolygonF> >::target_type)qt_gsi::CppToQtAdaptor<QList<QPolygonF> >(((QPainterPath *)cls)->toFillPolygons (arg1)));
}

static qt_gsi::GenericMethod *_create_f_toFillPolygons_c2350 ()
{
  return new qt_gsi::GenericMethod ("toFillPolygons", "@brief Method QList<QPolygonF> QPainterPath::toFillPolygons(const QTransform &matrix)\n", true, &_init_f_toFillPolygons_c2350, &_call_f_toFillPolygons_c2350);
}

// QPainterPath QPainterPath::toReversed()


static void _init_f_toReversed_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_f_toReversed_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPainterPath > ((QPainterPath)((QPainterPath *)cls)->toReversed ());
}

static qt_gsi::GenericMethod *_create_f_toReversed_c0 ()
{
  return new qt_gsi::GenericMethod ("toReversed", "@brief Method QPainterPath QPainterPath::toReversed()\n", true, &_init_f_toReversed_c0, &_call_f_toReversed_c0);
}

// QList<QPolygonF> QPainterPath::toSubpathPolygons(const QMatrix &matrix)


static void _init_f_toSubpathPolygons_c2023 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix", true, "QMatrix()");
  decl->add_arg<const QMatrix & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QList<QPolygonF> >::target_type > ();
}

static void _call_f_toSubpathPolygons_c2023 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMatrix &arg1 = args ? args.read<const QMatrix & > () : (const QMatrix &)(QMatrix());
  ret.write<qt_gsi::Converter<QList<QPolygonF> >::target_type > ((qt_gsi::Converter<QList<QPolygonF> >::target_type)qt_gsi::CppToQtAdaptor<QList<QPolygonF> >(((QPainterPath *)cls)->toSubpathPolygons (arg1)));
}

static qt_gsi::GenericMethod *_create_f_toSubpathPolygons_c2023 ()
{
  return new qt_gsi::GenericMethod ("toSubpathPolygons", "@brief Method QList<QPolygonF> QPainterPath::toSubpathPolygons(const QMatrix &matrix)\n", true, &_init_f_toSubpathPolygons_c2023, &_call_f_toSubpathPolygons_c2023);
}

// QList<QPolygonF> QPainterPath::toSubpathPolygons(const QTransform &matrix)


static void _init_f_toSubpathPolygons_c2350 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix");
  decl->add_arg<const QTransform & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QList<QPolygonF> >::target_type > ();
}

static void _call_f_toSubpathPolygons_c2350 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTransform &arg1 = args.read<const QTransform & > ();
  ret.write<qt_gsi::Converter<QList<QPolygonF> >::target_type > ((qt_gsi::Converter<QList<QPolygonF> >::target_type)qt_gsi::CppToQtAdaptor<QList<QPolygonF> >(((QPainterPath *)cls)->toSubpathPolygons (arg1)));
}

static qt_gsi::GenericMethod *_create_f_toSubpathPolygons_c2350 ()
{
  return new qt_gsi::GenericMethod ("toSubpathPolygons", "@brief Method QList<QPolygonF> QPainterPath::toSubpathPolygons(const QTransform &matrix)\n", true, &_init_f_toSubpathPolygons_c2350, &_call_f_toSubpathPolygons_c2350);
}

// void QPainterPath::translate(double dx, double dy)


static void _init_f_translate_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_translate_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ((QPainterPath *)cls)->translate (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_translate_2034 ()
{
  return new qt_gsi::GenericMethod ("translate", "@brief Method void QPainterPath::translate(double dx, double dy)\n", false, &_init_f_translate_2034, &_call_f_translate_2034);
}

// void QPainterPath::translate(const QPointF &offset)


static void _init_f_translate_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_translate_1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ((QPainterPath *)cls)->translate (arg1);
}

static qt_gsi::GenericMethod *_create_f_translate_1986 ()
{
  return new qt_gsi::GenericMethod ("translate", "@brief Method void QPainterPath::translate(const QPointF &offset)\n", false, &_init_f_translate_1986, &_call_f_translate_1986);
}

// QPainterPath QPainterPath::translated(double dx, double dy)


static void _init_f_translated_c2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QPainterPath > ();
}

static void _call_f_translated_c2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ret.write<QPainterPath > ((QPainterPath)((QPainterPath *)cls)->translated (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_translated_c2034 ()
{
  return new qt_gsi::GenericMethod ("translated", "@brief Method QPainterPath QPainterPath::translated(double dx, double dy)\n", true, &_init_f_translated_c2034, &_call_f_translated_c2034);
}

// QPainterPath QPainterPath::translated(const QPointF &offset)


static void _init_f_translated_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_translated_c1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ret.write<QPainterPath > ((QPainterPath)((QPainterPath *)cls)->translated (arg1));
}

static qt_gsi::GenericMethod *_create_f_translated_c1986 ()
{
  return new qt_gsi::GenericMethod ("translated", "@brief Method QPainterPath QPainterPath::translated(const QPointF &offset)\n", true, &_init_f_translated_c1986, &_call_f_translated_c1986);
}

// QPainterPath QPainterPath::united(const QPainterPath &r)


static void _init_f_united_c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_united_c2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<QPainterPath > ((QPainterPath)((QPainterPath *)cls)->united (arg1));
}

static qt_gsi::GenericMethod *_create_f_united_c2514 ()
{
  return new qt_gsi::GenericMethod ("united", "@brief Method QPainterPath QPainterPath::united(const QPainterPath &r)\n", true, &_init_f_united_c2514, &_call_f_united_c2514);
}

//  QPainterPath ::operator *(const QPainterPath &p, const QMatrix &m)
static QPainterPath op_QPainterPath_operator_star__4429(const QPainterPath *_self, const QMatrix &m) {
  return ::operator *(*_self, m);
}

//  QPainterPath ::operator *(const QPainterPath &p, const QTransform &m)
static QPainterPath op_QPainterPath_operator_star__4756(const QPainterPath *_self, const QTransform &m) {
  return ::operator *(*_self, m);
}


namespace gsi
{
gsi::Class<QPainterPath> decl_QPainterPath ("QPainterPath",
  gsi::Methods(_create_ctor_QPainterPath_0 ()) +
  gsi::Methods(_create_ctor_QPainterPath_1986 ()) +
  gsi::Methods(_create_ctor_QPainterPath_2514 ()) +
  gsi::Methods(_create_f_addEllipse_1862 ()) +
  gsi::Methods(_create_f_addEllipse_3960 ()) +
  gsi::Methods(_create_f_addEllipse_3912 ()) +
  gsi::Methods(_create_f_addPath_2514 ()) +
  gsi::Methods(_create_f_addPolygon_2208 ()) +
  gsi::Methods(_create_f_addRect_1862 ()) +
  gsi::Methods(_create_f_addRect_3960 ()) +
  gsi::Methods(_create_f_addRegion_2006 ()) +
  gsi::Methods(_create_f_addRoundRect_3180 ()) +
  gsi::Methods(_create_f_addRoundRect_5278 ()) +
  gsi::Methods(_create_f_addRoundRect_2521 ()) +
  gsi::Methods(_create_f_addRoundRect_4619 ()) +
  gsi::Methods(_create_f_addRoundedRect_5229 ()) +
  gsi::Methods(_create_f_addRoundedRect_7327 ()) +
  gsi::Methods(_create_f_addText_5596 ()) +
  gsi::Methods(_create_f_addText_5644 ()) +
  gsi::Methods(_create_f_angleAtPercent_c1071 ()) +
  gsi::Methods(_create_f_arcMoveTo_2825 ()) +
  gsi::Methods(_create_f_arcMoveTo_4923 ()) +
  gsi::Methods(_create_f_arcTo_3788 ()) +
  gsi::Methods(_create_f_arcTo_5886 ()) +
  gsi::Methods(_create_f_boundingRect_c0 ()) +
  gsi::Methods(_create_f_closeSubpath_0 ()) +
  gsi::Methods(_create_f_connectPath_2514 ()) +
  gsi::Methods(_create_f_contains_c1986 ()) +
  gsi::Methods(_create_f_contains_c1862 ()) +
  gsi::Methods(_create_f_contains_c2514 ()) +
  gsi::Methods(_create_f_controlPointRect_c0 ()) +
  gsi::Methods(_create_f_cubicTo_5742 ()) +
  gsi::Methods(_create_f_cubicTo_5886 ()) +
  gsi::Methods(_create_f_currentPosition_c0 ()) +
  gsi::Methods(_create_f_elementAt_c767 ()) +
  gsi::Methods(_create_f_elementCount_c0 ()) +
  gsi::Methods(_create_f_fillRule_c0 ()) +
  gsi::Methods(_create_f_intersected_c2514 ()) +
  gsi::Methods(_create_f_intersects_c1862 ()) +
  gsi::Methods(_create_f_intersects_c2514 ()) +
  gsi::Methods(_create_f_isEmpty_c0 ()) +
  gsi::Methods(_create_f_length_c0 ()) +
  gsi::Methods(_create_f_lineTo_1986 ()) +
  gsi::Methods(_create_f_lineTo_2034 ()) +
  gsi::Methods(_create_f_moveTo_1986 ()) +
  gsi::Methods(_create_f_moveTo_2034 ()) +
  gsi::Methods(_create_f_operator_excl__eq__c2514 ()) +
  gsi::Methods(_create_f_operator_amp__c2514 ()) +
  gsi::Methods(_create_f_operator_amp__eq__2514 ()) +
  gsi::Methods(_create_f_operator_plus__c2514 ()) +
  gsi::Methods(_create_f_operator_plus__eq__2514 ()) +
  gsi::Methods(_create_f_operator_minus__c2514 ()) +
  gsi::Methods(_create_f_operator_minus__eq__2514 ()) +
  gsi::Methods(_create_f_operator_eq__2514 ()) +
  gsi::Methods(_create_f_operator_eq__eq__c2514 ()) +
  gsi::Methods(_create_f_operator_pipe__c2514 ()) +
  gsi::Methods(_create_f_operator_pipe__eq__2514 ()) +
  gsi::Methods(_create_f_percentAtLength_c1071 ()) +
  gsi::Methods(_create_f_pointAtPercent_c1071 ()) +
  gsi::Methods(_create_f_quadTo_3864 ()) +
  gsi::Methods(_create_f_quadTo_3960 ()) +
  gsi::Methods(_create_f_setElementPositionAt_2693 ()) +
  gsi::Methods(_create_f_setFillRule_1548 ()) +
  gsi::Methods(_create_f_simplified_c0 ()) +
  gsi::Methods(_create_f_slopeAtPercent_c1071 ()) +
  gsi::Methods(_create_f_subtracted_c2514 ()) +
  gsi::Methods(_create_f_subtractedInverted_c2514 ()) +
  gsi::Methods(_create_f_toFillPolygon_c2023 ()) +
  gsi::Methods(_create_f_toFillPolygon_c2350 ()) +
  gsi::Methods(_create_f_toFillPolygons_c2023 ()) +
  gsi::Methods(_create_f_toFillPolygons_c2350 ()) +
  gsi::Methods(_create_f_toReversed_c0 ()) +
  gsi::Methods(_create_f_toSubpathPolygons_c2023 ()) +
  gsi::Methods(_create_f_toSubpathPolygons_c2350 ()) +
  gsi::Methods(_create_f_translate_2034 ()) +
  gsi::Methods(_create_f_translate_1986 ()) +
  gsi::Methods(_create_f_translated_c2034 ()) +
  gsi::Methods(_create_f_translated_c1986 ()) +
  gsi::Methods(_create_f_united_c2514 ()) +
  gsi::method_ext("*", &::op_QPainterPath_operator_star__4429, gsi::arg ("m"), "@brief Operator QPainterPath ::operator *(const QPainterPath &p, const QMatrix &m)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("*", &::op_QPainterPath_operator_star__4756, gsi::arg ("m"), "@brief Operator QPainterPath ::operator *(const QPainterPath &p, const QTransform &m)\nThis is the mapping of the global operator to the instance method."),
  "@qt\n@brief Binding of QPainterPath");

}

