
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMovie.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQMovie_EventAdaptor.h"
#include "gsiDeclQMovie_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMovie

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QMovie::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QColor QMovie::backgroundColor()


static void _init_f_backgroundColor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QColor > ();
}

static void _call_f_backgroundColor_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QColor > ((QColor)((QMovie *)cls)->backgroundColor ());
}

static qt_gsi::GenericMethod *_create_f_backgroundColor_c0 ()
{
  return new qt_gsi::GenericMethod (":backgroundColor", "@brief Method QColor QMovie::backgroundColor()\n", true, &_init_f_backgroundColor_c0, &_call_f_backgroundColor_c0);
}

// QMovie::CacheMode QMovie::cacheMode()


static void _init_f_cacheMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMovie::CacheMode>::target_type > ();
}

static void _call_f_cacheMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QMovie::CacheMode>::target_type > ((qt_gsi::Converter<QMovie::CacheMode>::target_type)qt_gsi::CppToQtAdaptor<QMovie::CacheMode>(((QMovie *)cls)->cacheMode ()));
}

static qt_gsi::GenericMethod *_create_f_cacheMode_c0 ()
{
  return new qt_gsi::GenericMethod (":cacheMode", "@brief Method QMovie::CacheMode QMovie::cacheMode()\n", true, &_init_f_cacheMode_c0, &_call_f_cacheMode_c0);
}

// QMovie::CacheMode QMovie::cacheMode()


static void _init_f_cacheMode_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMovie::CacheMode>::target_type > ();
}

static void _call_f_cacheMode_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QMovie::CacheMode>::target_type > ((qt_gsi::Converter<QMovie::CacheMode>::target_type)qt_gsi::CppToQtAdaptor<QMovie::CacheMode>(((QMovie *)cls)->cacheMode ()));
}

static qt_gsi::GenericMethod *_create_f_cacheMode_0 ()
{
  return new qt_gsi::GenericMethod (":cacheMode", "@brief Method QMovie::CacheMode QMovie::cacheMode()\n", false, &_init_f_cacheMode_0, &_call_f_cacheMode_0);
}

// int QMovie::currentFrameNumber()


static void _init_f_currentFrameNumber_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentFrameNumber_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QMovie *)cls)->currentFrameNumber ());
}

static qt_gsi::GenericMethod *_create_f_currentFrameNumber_c0 ()
{
  return new qt_gsi::GenericMethod ("currentFrameNumber", "@brief Method int QMovie::currentFrameNumber()\n", true, &_init_f_currentFrameNumber_c0, &_call_f_currentFrameNumber_c0);
}

// QImage QMovie::currentImage()


static void _init_f_currentImage_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QImage > ();
}

static void _call_f_currentImage_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QImage > ((QImage)((QMovie *)cls)->currentImage ());
}

static qt_gsi::GenericMethod *_create_f_currentImage_c0 ()
{
  return new qt_gsi::GenericMethod ("currentImage", "@brief Method QImage QMovie::currentImage()\n", true, &_init_f_currentImage_c0, &_call_f_currentImage_c0);
}

// QPixmap QMovie::currentPixmap()


static void _init_f_currentPixmap_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPixmap > ();
}

static void _call_f_currentPixmap_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPixmap > ((QPixmap)((QMovie *)cls)->currentPixmap ());
}

static qt_gsi::GenericMethod *_create_f_currentPixmap_c0 ()
{
  return new qt_gsi::GenericMethod ("currentPixmap", "@brief Method QPixmap QMovie::currentPixmap()\n", true, &_init_f_currentPixmap_c0, &_call_f_currentPixmap_c0);
}

// QIODevice *QMovie::device()


static void _init_f_device_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIODevice * > ();
}

static void _call_f_device_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QIODevice * > ((QIODevice *)((QMovie *)cls)->device ());
}

static qt_gsi::GenericMethod *_create_f_device_c0 ()
{
  return new qt_gsi::GenericMethod (":device", "@brief Method QIODevice *QMovie::device()\n", true, &_init_f_device_c0, &_call_f_device_c0);
}

// QString QMovie::fileName()


static void _init_f_fileName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_fileName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QMovie *)cls)->fileName ());
}

static qt_gsi::GenericMethod *_create_f_fileName_c0 ()
{
  return new qt_gsi::GenericMethod (":fileName", "@brief Method QString QMovie::fileName()\n", true, &_init_f_fileName_c0, &_call_f_fileName_c0);
}

// QByteArray QMovie::format()


static void _init_f_format_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_format_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray > ((QByteArray)((QMovie *)cls)->format ());
}

static qt_gsi::GenericMethod *_create_f_format_c0 ()
{
  return new qt_gsi::GenericMethod (":format", "@brief Method QByteArray QMovie::format()\n", true, &_init_f_format_c0, &_call_f_format_c0);
}

// int QMovie::frameCount()


static void _init_f_frameCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_frameCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QMovie *)cls)->frameCount ());
}

static qt_gsi::GenericMethod *_create_f_frameCount_c0 ()
{
  return new qt_gsi::GenericMethod ("frameCount", "@brief Method int QMovie::frameCount()\n", true, &_init_f_frameCount_c0, &_call_f_frameCount_c0);
}

// QRect QMovie::frameRect()


static void _init_f_frameRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_frameRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QMovie *)cls)->frameRect ());
}

static qt_gsi::GenericMethod *_create_f_frameRect_c0 ()
{
  return new qt_gsi::GenericMethod ("frameRect", "@brief Method QRect QMovie::frameRect()\n", true, &_init_f_frameRect_c0, &_call_f_frameRect_c0);
}

// bool QMovie::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QMovie *)cls)->isValid ());
}

static qt_gsi::GenericMethod *_create_f_isValid_c0 ()
{
  return new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QMovie::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
}

// bool QMovie::jumpToFrame(int frameNumber)


static void _init_f_jumpToFrame_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("frameNumber");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_jumpToFrame_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<bool > ((bool)((QMovie *)cls)->jumpToFrame (arg1));
}

static qt_gsi::GenericMethod *_create_f_jumpToFrame_767 ()
{
  return new qt_gsi::GenericMethod ("jumpToFrame", "@brief Method bool QMovie::jumpToFrame(int frameNumber)\n", false, &_init_f_jumpToFrame_767, &_call_f_jumpToFrame_767);
}

// bool QMovie::jumpToNextFrame()


static void _init_f_jumpToNextFrame_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_jumpToNextFrame_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QMovie *)cls)->jumpToNextFrame ());
}

static qt_gsi::GenericMethod *_create_f_jumpToNextFrame_0 ()
{
  return new qt_gsi::GenericMethod ("jumpToNextFrame", "@brief Method bool QMovie::jumpToNextFrame()\n", false, &_init_f_jumpToNextFrame_0, &_call_f_jumpToNextFrame_0);
}

// int QMovie::loopCount()


static void _init_f_loopCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_loopCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QMovie *)cls)->loopCount ());
}

static qt_gsi::GenericMethod *_create_f_loopCount_c0 ()
{
  return new qt_gsi::GenericMethod ("loopCount", "@brief Method int QMovie::loopCount()\n", true, &_init_f_loopCount_c0, &_call_f_loopCount_c0);
}

// int QMovie::nextFrameDelay()


static void _init_f_nextFrameDelay_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_nextFrameDelay_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QMovie *)cls)->nextFrameDelay ());
}

static qt_gsi::GenericMethod *_create_f_nextFrameDelay_c0 ()
{
  return new qt_gsi::GenericMethod ("nextFrameDelay", "@brief Method int QMovie::nextFrameDelay()\n", true, &_init_f_nextFrameDelay_c0, &_call_f_nextFrameDelay_c0);
}

// QSize QMovie::scaledSize()


static void _init_f_scaledSize_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_scaledSize_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QMovie *)cls)->scaledSize ());
}

static qt_gsi::GenericMethod *_create_f_scaledSize_0 ()
{
  return new qt_gsi::GenericMethod (":scaledSize", "@brief Method QSize QMovie::scaledSize()\n", false, &_init_f_scaledSize_0, &_call_f_scaledSize_0);
}

// void QMovie::setBackgroundColor(const QColor &color)


static void _init_f_setBackgroundColor_1905 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("color");
  decl->add_arg<const QColor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBackgroundColor_1905 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QColor &arg1 = args.read<const QColor & > ();
  ((QMovie *)cls)->setBackgroundColor (arg1);
}

static qt_gsi::GenericMethod *_create_f_setBackgroundColor_1905 ()
{
  return new qt_gsi::GenericMethod ("setBackgroundColor|backgroundColor=", "@brief Method void QMovie::setBackgroundColor(const QColor &color)\n", false, &_init_f_setBackgroundColor_1905, &_call_f_setBackgroundColor_1905);
}

// void QMovie::setCacheMode(QMovie::CacheMode mode)


static void _init_f_setCacheMode_2002 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QMovie::CacheMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCacheMode_2002 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QMovie::CacheMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QMovie::CacheMode>::target_type & > ();
  ((QMovie *)cls)->setCacheMode (qt_gsi::QtToCppAdaptor<QMovie::CacheMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setCacheMode_2002 ()
{
  return new qt_gsi::GenericMethod ("setCacheMode|cacheMode=", "@brief Method void QMovie::setCacheMode(QMovie::CacheMode mode)\n", false, &_init_f_setCacheMode_2002, &_call_f_setCacheMode_2002);
}

// void QMovie::setDevice(QIODevice *device)


static void _init_f_setDevice_1447 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDevice_1447 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QIODevice *arg1 = args.read<QIODevice * > ();
  ((QMovie *)cls)->setDevice (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDevice_1447 ()
{
  return new qt_gsi::GenericMethod ("setDevice|device=", "@brief Method void QMovie::setDevice(QIODevice *device)\n", false, &_init_f_setDevice_1447, &_call_f_setDevice_1447);
}

// void QMovie::setFileName(const QString &fileName)


static void _init_f_setFileName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFileName_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QMovie *)cls)->setFileName (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFileName_2025 ()
{
  return new qt_gsi::GenericMethod ("setFileName|fileName=", "@brief Method void QMovie::setFileName(const QString &fileName)\n", false, &_init_f_setFileName_2025, &_call_f_setFileName_2025);
}

// void QMovie::setFormat(const QByteArray &format)


static void _init_f_setFormat_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFormat_2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ((QMovie *)cls)->setFormat (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFormat_2309 ()
{
  return new qt_gsi::GenericMethod ("setFormat|format=", "@brief Method void QMovie::setFormat(const QByteArray &format)\n", false, &_init_f_setFormat_2309, &_call_f_setFormat_2309);
}

// void QMovie::setPaused(bool paused)


static void _init_f_setPaused_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("paused");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPaused_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QMovie *)cls)->setPaused (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPaused_864 ()
{
  return new qt_gsi::GenericMethod ("setPaused", "@brief Method void QMovie::setPaused(bool paused)\n", false, &_init_f_setPaused_864, &_call_f_setPaused_864);
}

// void QMovie::setScaledSize(const QSize &size)


static void _init_f_setScaledSize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setScaledSize_1805 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  ((QMovie *)cls)->setScaledSize (arg1);
}

static qt_gsi::GenericMethod *_create_f_setScaledSize_1805 ()
{
  return new qt_gsi::GenericMethod ("setScaledSize|scaledSize=", "@brief Method void QMovie::setScaledSize(const QSize &size)\n", false, &_init_f_setScaledSize_1805, &_call_f_setScaledSize_1805);
}

// void QMovie::setSpeed(int percentSpeed)


static void _init_f_setSpeed_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("percentSpeed");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSpeed_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QMovie *)cls)->setSpeed (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSpeed_767 ()
{
  return new qt_gsi::GenericMethod ("setSpeed|speed=", "@brief Method void QMovie::setSpeed(int percentSpeed)\n", false, &_init_f_setSpeed_767, &_call_f_setSpeed_767);
}

// int QMovie::speed()


static void _init_f_speed_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_speed_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QMovie *)cls)->speed ());
}

static qt_gsi::GenericMethod *_create_f_speed_c0 ()
{
  return new qt_gsi::GenericMethod (":speed", "@brief Method int QMovie::speed()\n", true, &_init_f_speed_c0, &_call_f_speed_c0);
}

// void QMovie::start()


static void _init_f_start_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_start_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMovie *)cls)->start ();
}

static qt_gsi::GenericMethod *_create_f_start_0 ()
{
  return new qt_gsi::GenericMethod ("start", "@brief Method void QMovie::start()\n", false, &_init_f_start_0, &_call_f_start_0);
}

// QMovie::MovieState QMovie::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMovie::MovieState>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QMovie::MovieState>::target_type > ((qt_gsi::Converter<QMovie::MovieState>::target_type)qt_gsi::CppToQtAdaptor<QMovie::MovieState>(((QMovie *)cls)->state ()));
}

static qt_gsi::GenericMethod *_create_f_state_c0 ()
{
  return new qt_gsi::GenericMethod ("state", "@brief Method QMovie::MovieState QMovie::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
}

// void QMovie::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMovie *)cls)->stop ();
}

static qt_gsi::GenericMethod *_create_f_stop_0 ()
{
  return new qt_gsi::GenericMethod ("stop", "@brief Method void QMovie::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
}

// static QList<QByteArray> QMovie::supportedFormats()


static void _init_f_supportedFormats_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QByteArray> >::target_type > ();
}

static void _call_f_supportedFormats_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QByteArray> >::target_type > ((qt_gsi::Converter<QList<QByteArray> >::target_type)qt_gsi::CppToQtAdaptor<QList<QByteArray> >(QMovie::supportedFormats ()));
}

static qt_gsi::GenericStaticMethod *_create_f_supportedFormats_0 ()
{
  return new qt_gsi::GenericStaticMethod ("supportedFormats", "@brief Static method QList<QByteArray> QMovie::supportedFormats()\nThis method is static and can be called without an instance.", &_init_f_supportedFormats_0, &_call_f_supportedFormats_0);
}

// static QString QMovie::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QMovie::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMovie::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QMovie::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QMovie::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMovie::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QMovie::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QMovie::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QMovie::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QMovie::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QMovie::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QMovie::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QMovie, QMovie_EventAdaptor> ea_QMovie;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QMovie> decl_QMovie (ea_QMovie, decl_QObject, "QMovie_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_backgroundColor_c0 ()) +
  gsi::Methods(_create_f_cacheMode_c0 ()) +
  gsi::Methods(_create_f_cacheMode_0 ()) +
  gsi::Methods(_create_f_currentFrameNumber_c0 ()) +
  gsi::Methods(_create_f_currentImage_c0 ()) +
  gsi::Methods(_create_f_currentPixmap_c0 ()) +
  gsi::Methods(_create_f_device_c0 ()) +
  gsi::Methods(_create_f_fileName_c0 ()) +
  gsi::Methods(_create_f_format_c0 ()) +
  gsi::Methods(_create_f_frameCount_c0 ()) +
  gsi::Methods(_create_f_frameRect_c0 ()) +
  gsi::Methods(_create_f_isValid_c0 ()) +
  gsi::Methods(_create_f_jumpToFrame_767 ()) +
  gsi::Methods(_create_f_jumpToNextFrame_0 ()) +
  gsi::Methods(_create_f_loopCount_c0 ()) +
  gsi::Methods(_create_f_nextFrameDelay_c0 ()) +
  gsi::Methods(_create_f_scaledSize_0 ()) +
  gsi::Methods(_create_f_setBackgroundColor_1905 ()) +
  gsi::Methods(_create_f_setCacheMode_2002 ()) +
  gsi::Methods(_create_f_setDevice_1447 ()) +
  gsi::Methods(_create_f_setFileName_2025 ()) +
  gsi::Methods(_create_f_setFormat_2309 ()) +
  gsi::Methods(_create_f_setPaused_864 ()) +
  gsi::Methods(_create_f_setScaledSize_1805 ()) +
  gsi::Methods(_create_f_setSpeed_767 ()) +
  gsi::Methods(_create_f_speed_c0 ()) +
  gsi::Methods(_create_f_start_0 ()) +
  gsi::Methods(_create_f_state_c0 ()) +
  gsi::Methods(_create_f_stop_0 ()) +
  qt_gsi::qt_signal<QMovie, QMovie_EventAdaptor, QObject *> ("destroyed", &QMovie_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QMovie::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QMovie, QMovie_EventAdaptor, const qt_gsi::Converter<QImageReader::ImageReaderError>::target_type &> ("error", &QMovie_EventAdaptor::error_e_3311, gsi::arg("error"), "@brief Signal declaration for QMovie::error(QImageReader::ImageReaderError error)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QMovie, QMovie_EventAdaptor> ("finished", &QMovie_EventAdaptor::finished_e_0, "@brief Signal declaration for QMovie::finished()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QMovie, QMovie_EventAdaptor, int> ("frameChanged", &QMovie_EventAdaptor::frameChanged_e_767, gsi::arg("frameNumber"), "@brief Signal declaration for QMovie::frameChanged(int frameNumber)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QMovie, QMovie_EventAdaptor, const QSize &> ("resized", &QMovie_EventAdaptor::resized_e_1805, gsi::arg("size"), "@brief Signal declaration for QMovie::resized(const QSize &size)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QMovie, QMovie_EventAdaptor> ("started", &QMovie_EventAdaptor::started_e_0, "@brief Signal declaration for QMovie::started()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QMovie, QMovie_EventAdaptor, const qt_gsi::Converter<QMovie::MovieState>::target_type &> ("stateChanged", &QMovie_EventAdaptor::stateChanged_e_2170, gsi::arg("state"), "@brief Signal declaration for QMovie::stateChanged(QMovie::MovieState state)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QMovie, QMovie_EventAdaptor, const QRect &> ("updated", &QMovie_EventAdaptor::updated_e_1792, gsi::arg("rect"), "@brief Signal declaration for QMovie::updated(const QRect &rect)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_supportedFormats_0 ()) +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QMovie");
}


class QMovie_Adaptor : public QMovie, public qt_gsi::QtObjectBase
{
public:

  virtual ~QMovie_Adaptor();

  //  [adaptor ctor] QMovie::QMovie(QObject *parent)
  QMovie_Adaptor() : QMovie()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMovie::QMovie(QObject *parent)
  QMovie_Adaptor(QObject *parent) : QMovie(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMovie::QMovie(QIODevice *device, const QByteArray &format, QObject *parent)
  QMovie_Adaptor(QIODevice *device) : QMovie(device)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMovie::QMovie(QIODevice *device, const QByteArray &format, QObject *parent)
  QMovie_Adaptor(QIODevice *device, const QByteArray &format) : QMovie(device, format)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMovie::QMovie(QIODevice *device, const QByteArray &format, QObject *parent)
  QMovie_Adaptor(QIODevice *device, const QByteArray &format, QObject *parent) : QMovie(device, format, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMovie::QMovie(const QString &fileName, const QByteArray &format, QObject *parent)
  QMovie_Adaptor(const QString &fileName) : QMovie(fileName)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMovie::QMovie(const QString &fileName, const QByteArray &format, QObject *parent)
  QMovie_Adaptor(const QString &fileName, const QByteArray &format) : QMovie(fileName, format)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMovie::QMovie(const QString &fileName, const QByteArray &format, QObject *parent)
  QMovie_Adaptor(const QString &fileName, const QByteArray &format, QObject *parent) : QMovie(fileName, format, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QMovie::receivers(const char *signal)
  int fp_QMovie_receivers_c1731 (const char *signal) const {
    return QMovie::receivers(signal);
  }

  //  QObject *QMovie::sender()
  QObject * fp_QMovie_sender_c0 () const {
    return QMovie::sender();
  }

  //  [adaptor impl] bool QMovie::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QMovie::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QMovie_Adaptor, bool, QEvent *>(&QMovie_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QMovie::event(arg1);
    }
  }

  //  [adaptor impl] bool QMovie::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QMovie::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QMovie_Adaptor, bool, QObject *, QEvent *>(&QMovie_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QMovie::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QMovie::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QMovie::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QMovie_Adaptor, QChildEvent *>(&QMovie_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QMovie::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QMovie::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QMovie::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QMovie_Adaptor, QEvent *>(&QMovie_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QMovie::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QMovie::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QMovie::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QMovie_Adaptor, const char *>(&QMovie_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QMovie::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QMovie::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QMovie::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QMovie_Adaptor, QTimerEvent *>(&QMovie_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QMovie::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QMovie_Adaptor::~QMovie_Adaptor() { }

//  Constructor QMovie::QMovie(QObject *parent) (adaptor class)

static void _init_ctor_QMovie_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QMovie_Adaptor *> ();
}

static void _call_ctor_QMovie_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QMovie_Adaptor *> (new QMovie_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QMovie_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMovie::QMovie(QObject *parent)\nThis method creates an object of class QMovie.", &_init_ctor_QMovie_Adaptor_1302, &_call_ctor_QMovie_Adaptor_1302);
}

//  Constructor QMovie::QMovie(QIODevice *device, const QByteArray &format, QObject *parent) (adaptor class)

static void _init_ctor_QMovie_Adaptor_4842 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QByteArray()");
  decl->add_arg<const QByteArray & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_2);
  decl->set_return_new<QMovie_Adaptor *> ();
}

static void _call_ctor_QMovie_Adaptor_4842 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QIODevice *arg1 = args.read<QIODevice * > ();
  const QByteArray &arg2 = args ? args.read<const QByteArray & > () : (const QByteArray &)(QByteArray());
  QObject *arg3 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QMovie_Adaptor *> (new QMovie_Adaptor (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QMovie_Adaptor_4842 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMovie::QMovie(QIODevice *device, const QByteArray &format, QObject *parent)\nThis method creates an object of class QMovie.", &_init_ctor_QMovie_Adaptor_4842, &_call_ctor_QMovie_Adaptor_4842);
}

//  Constructor QMovie::QMovie(const QString &fileName, const QByteArray &format, QObject *parent) (adaptor class)

static void _init_ctor_QMovie_Adaptor_5420 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QByteArray()");
  decl->add_arg<const QByteArray & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_2);
  decl->set_return_new<QMovie_Adaptor *> ();
}

static void _call_ctor_QMovie_Adaptor_5420 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QByteArray &arg2 = args ? args.read<const QByteArray & > () : (const QByteArray &)(QByteArray());
  QObject *arg3 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QMovie_Adaptor *> (new QMovie_Adaptor (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QMovie_Adaptor_5420 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMovie::QMovie(const QString &fileName, const QByteArray &format, QObject *parent)\nThis method creates an object of class QMovie.", &_init_ctor_QMovie_Adaptor_5420, &_call_ctor_QMovie_Adaptor_5420);
}

// int QMovie::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QMovie_Adaptor *)cls)->fp_QMovie_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QMovie::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QMovie::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QMovie_Adaptor *)cls)->fp_QMovie_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QMovie::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// bool QMovie::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QMovie_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMovie_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QMovie::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QMovie::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QMovie_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QMovie_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QMovie::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QMovie::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QMovie_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QMovie_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QMovie::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QMovie::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QMovie_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMovie_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QMovie::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QMovie::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QMovie_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QMovie_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QMovie::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QMovie::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QMovie_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QMovie_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QMovie::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QMovie> decl_QMovie;

gsi::Class<QMovie_Adaptor> decl_QMovie_Adaptor (decl_QMovie, "QMovie",
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QMovie_Adaptor_1302 ()) +
  gsi::Methods(_create_ctor_QMovie_Adaptor_4842 ()) +
  gsi::Methods(_create_ctor_QMovie_Adaptor_5420 ()),
  "@qt\n@brief Binding of QMovie");

}


//  Implementation of the enum wrapper class for QMovie::CacheMode
namespace qt_gsi
{

static QMovie_CacheMode_Enum *c_1_QMovie_CacheMode_Enum () { return new QMovie_CacheMode_Enum (QMovie::CacheNone); }
static QMovie_CacheMode_Enum *c_2_QMovie_CacheMode_Enum () { return new QMovie_CacheMode_Enum (QMovie::CacheAll); }

static gsi::Methods mkdefs_QMovie_CacheMode () {
  return
    gsi::constant ("CacheNone", &qt_gsi::c_1_QMovie_CacheMode_Enum, "@brief Enum constant QMovie::CacheNone") +
    gsi::constant ("CacheAll", &qt_gsi::c_2_QMovie_CacheMode_Enum, "@brief Enum constant QMovie::CacheAll");
}

static std::string to_s_QMovie_CacheMode_Enum (const QMovie_CacheMode_Enum *e)
{
  if (e->value () == QMovie::CacheNone) { return tl::sprintf ("CacheNone (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMovie::CacheAll) { return tl::sprintf ("CacheAll (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QMovie_CacheMode_Enum (const QMovie_CacheMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QMovie_CacheMode_Enum *from_i_QMovie_CacheMode_Enum (unsigned int i)
{
  return new QMovie_CacheMode_Enum ((QMovie::CacheMode) i);
}

static bool equalQMovie_CacheMode_Enum (const QMovie_CacheMode_Enum *e, QMovie_CacheMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QMovie_CacheMode_Enum (const QMovie_CacheMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QMovie_CacheMode_Enums oropQMovie_CacheMode_Enums (const QMovie_CacheMode_Enums *e, const QMovie_CacheMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QMovie_CacheMode_Enums andopQMovie_CacheMode_Enums (const QMovie_CacheMode_Enums *e, const QMovie_CacheMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QMovie_CacheMode_Enums xoropQMovie_CacheMode_Enums (const QMovie_CacheMode_Enums *e, const QMovie_CacheMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QMovie_CacheMode_Enums (const QMovie_CacheMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QMovie::CacheNone)) { if (!l.empty ()) l += "|"; l += "CacheNone"; }
  if (e->testFlag (QMovie::CacheAll)) { if (!l.empty ()) l += "|"; l += "CacheAll"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QMovie_CacheMode_Enums (const QMovie_CacheMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QMovie_CacheMode_Enums (const QMovie_CacheMode_Enums *e, const QMovie_CacheMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QMovie_CacheMode_Enums> decl_QMovie_CacheMode_Enums ("QMovie_QFlags_CacheMode",
  gsi::method_ext ("|", &qt_gsi::oropQMovie_CacheMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQMovie_CacheMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQMovie_CacheMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QMovie_CacheMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QMovie_CacheMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QMovie_CacheMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QMovie::CacheMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QMovie_CacheMode_Enum> decl_QMovie_CacheMode_Enum (decl_QMovie_CacheMode_Enums, "QMovie_CacheMode",
  qt_gsi::mkdefs_QMovie_CacheMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QMovie_CacheMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QMovie_CacheMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQMovie_CacheMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QMovie_CacheMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QMovie_CacheMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QMovie::CacheMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QMovie> inject_QMovie_CacheMode_Enum_in_parent (qt_gsi::mkdefs_QMovie_CacheMode ());
static gsi::ClassExt<QMovie> decl_QMovie_CacheMode_Enum_as_child (decl_QMovie_CacheMode_Enum, "CacheMode");

}


//  Implementation of the enum wrapper class for QMovie::MovieState
namespace qt_gsi
{

static QMovie_MovieState_Enum *c_1_QMovie_MovieState_Enum () { return new QMovie_MovieState_Enum (QMovie::NotRunning); }
static QMovie_MovieState_Enum *c_2_QMovie_MovieState_Enum () { return new QMovie_MovieState_Enum (QMovie::Paused); }
static QMovie_MovieState_Enum *c_3_QMovie_MovieState_Enum () { return new QMovie_MovieState_Enum (QMovie::Running); }

static gsi::Methods mkdefs_QMovie_MovieState () {
  return
    gsi::constant ("NotRunning", &qt_gsi::c_1_QMovie_MovieState_Enum, "@brief Enum constant QMovie::NotRunning") +
    gsi::constant ("Paused", &qt_gsi::c_2_QMovie_MovieState_Enum, "@brief Enum constant QMovie::Paused") +
    gsi::constant ("Running", &qt_gsi::c_3_QMovie_MovieState_Enum, "@brief Enum constant QMovie::Running");
}

static std::string to_s_QMovie_MovieState_Enum (const QMovie_MovieState_Enum *e)
{
  if (e->value () == QMovie::NotRunning) { return tl::sprintf ("NotRunning (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMovie::Paused) { return tl::sprintf ("Paused (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMovie::Running) { return tl::sprintf ("Running (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QMovie_MovieState_Enum (const QMovie_MovieState_Enum *e)
{
  return (unsigned int) e->value ();
}

static QMovie_MovieState_Enum *from_i_QMovie_MovieState_Enum (unsigned int i)
{
  return new QMovie_MovieState_Enum ((QMovie::MovieState) i);
}

static bool equalQMovie_MovieState_Enum (const QMovie_MovieState_Enum *e, QMovie_MovieState_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QMovie_MovieState_Enum (const QMovie_MovieState_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QMovie_MovieState_Enums oropQMovie_MovieState_Enums (const QMovie_MovieState_Enums *e, const QMovie_MovieState_Enums &d)
{
  return e->flags () | d.flags ();
}

static QMovie_MovieState_Enums andopQMovie_MovieState_Enums (const QMovie_MovieState_Enums *e, const QMovie_MovieState_Enums &d)
{
  return e->flags () & d.flags ();
}

static QMovie_MovieState_Enums xoropQMovie_MovieState_Enums (const QMovie_MovieState_Enums *e, const QMovie_MovieState_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QMovie_MovieState_Enums (const QMovie_MovieState_Enums *e)
{
  std::string l;
  if (e->testFlag (QMovie::NotRunning)) { if (!l.empty ()) l += "|"; l += "NotRunning"; }
  if (e->testFlag (QMovie::Paused)) { if (!l.empty ()) l += "|"; l += "Paused"; }
  if (e->testFlag (QMovie::Running)) { if (!l.empty ()) l += "|"; l += "Running"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QMovie_MovieState_Enums (const QMovie_MovieState_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QMovie_MovieState_Enums (const QMovie_MovieState_Enums *e, const QMovie_MovieState_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QMovie_MovieState_Enums> decl_QMovie_MovieState_Enums ("QMovie_QFlags_MovieState",
  gsi::method_ext ("|", &qt_gsi::oropQMovie_MovieState_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQMovie_MovieState_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQMovie_MovieState_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QMovie_MovieState_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QMovie_MovieState_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QMovie_MovieState_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QMovie::MovieState> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QMovie_MovieState_Enum> decl_QMovie_MovieState_Enum (decl_QMovie_MovieState_Enums, "QMovie_MovieState",
  qt_gsi::mkdefs_QMovie_MovieState () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QMovie_MovieState_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QMovie_MovieState_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQMovie_MovieState_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QMovie_MovieState_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QMovie_MovieState_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QMovie::MovieState enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QMovie> inject_QMovie_MovieState_Enum_in_parent (qt_gsi::mkdefs_QMovie_MovieState ());
static gsi::ClassExt<QMovie> decl_QMovie_MovieState_Enum_as_child (decl_QMovie_MovieState_Enum, "MovieState");

}

