
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMainWindow.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQMainWindow_EventAdaptor.h"
#include "gsiDeclQMainWindow_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMainWindow

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QMainWindow::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// void QMainWindow::addDockWidget(Qt::DockWidgetArea area, QDockWidget *dockwidget)


static void _init_f_addDockWidget_3715 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("area");
  decl->add_arg<const qt_gsi::Converter<Qt::DockWidgetArea>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dockwidget");
  decl->add_arg<QDockWidget * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addDockWidget_3715 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::DockWidgetArea>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::DockWidgetArea>::target_type & > ();
  QDockWidget *arg2 = args.read<QDockWidget * > ();
  ((QMainWindow *)cls)->addDockWidget (qt_gsi::QtToCppAdaptor<Qt::DockWidgetArea>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_addDockWidget_3715 ()
{
  return new qt_gsi::GenericMethod ("addDockWidget", "@brief Method void QMainWindow::addDockWidget(Qt::DockWidgetArea area, QDockWidget *dockwidget)\n", false, &_init_f_addDockWidget_3715, &_call_f_addDockWidget_3715);
}

// void QMainWindow::addDockWidget(Qt::DockWidgetArea area, QDockWidget *dockwidget, Qt::Orientation orientation)


static void _init_f_addDockWidget_5520 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("area");
  decl->add_arg<const qt_gsi::Converter<Qt::DockWidgetArea>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dockwidget");
  decl->add_arg<QDockWidget * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_addDockWidget_5520 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::DockWidgetArea>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::DockWidgetArea>::target_type & > ();
  QDockWidget *arg2 = args.read<QDockWidget * > ();
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg3 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  ((QMainWindow *)cls)->addDockWidget (qt_gsi::QtToCppAdaptor<Qt::DockWidgetArea>(arg1).cref(), arg2, qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg3).cref());
}

static qt_gsi::GenericMethod *_create_f_addDockWidget_5520 ()
{
  return new qt_gsi::GenericMethod ("addDockWidget", "@brief Method void QMainWindow::addDockWidget(Qt::DockWidgetArea area, QDockWidget *dockwidget, Qt::Orientation orientation)\n", false, &_init_f_addDockWidget_5520, &_call_f_addDockWidget_5520);
}

// void QMainWindow::addToolBar(Qt::ToolBarArea area, QToolBar *toolbar)


static void _init_f_addToolBar_3103 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("area");
  decl->add_arg<const qt_gsi::Converter<Qt::ToolBarArea>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("toolbar");
  decl->add_arg<QToolBar * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addToolBar_3103 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::ToolBarArea>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::ToolBarArea>::target_type & > ();
  QToolBar *arg2 = args.read<QToolBar * > ();
  ((QMainWindow *)cls)->addToolBar (qt_gsi::QtToCppAdaptor<Qt::ToolBarArea>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_addToolBar_3103 ()
{
  return new qt_gsi::GenericMethod ("addToolBar", "@brief Method void QMainWindow::addToolBar(Qt::ToolBarArea area, QToolBar *toolbar)\n", false, &_init_f_addToolBar_3103, &_call_f_addToolBar_3103);
}

// void QMainWindow::addToolBar(QToolBar *toolbar)


static void _init_f_addToolBar_1394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("toolbar");
  decl->add_arg<QToolBar * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addToolBar_1394 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QToolBar *arg1 = args.read<QToolBar * > ();
  ((QMainWindow *)cls)->addToolBar (arg1);
}

static qt_gsi::GenericMethod *_create_f_addToolBar_1394 ()
{
  return new qt_gsi::GenericMethod ("addToolBar", "@brief Method void QMainWindow::addToolBar(QToolBar *toolbar)\n", false, &_init_f_addToolBar_1394, &_call_f_addToolBar_1394);
}

// QToolBar *QMainWindow::addToolBar(const QString &title)


static void _init_f_addToolBar_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QToolBar * > ();
}

static void _call_f_addToolBar_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QToolBar * > ((QToolBar *)((QMainWindow *)cls)->addToolBar (arg1));
}

static qt_gsi::GenericMethod *_create_f_addToolBar_2025 ()
{
  return new qt_gsi::GenericMethod ("addToolBar", "@brief Method QToolBar *QMainWindow::addToolBar(const QString &title)\n", false, &_init_f_addToolBar_2025, &_call_f_addToolBar_2025);
}

// void QMainWindow::addToolBarBreak(Qt::ToolBarArea area)


static void _init_f_addToolBarBreak_1817 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("area", true, "Qt::TopToolBarArea");
  decl->add_arg<const qt_gsi::Converter<Qt::ToolBarArea>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addToolBarBreak_1817 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ToolBarArea>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<Qt::ToolBarArea>::target_type & > () : (const qt_gsi::Converter<Qt::ToolBarArea>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::ToolBarArea>(heap, Qt::TopToolBarArea));
  ((QMainWindow *)cls)->addToolBarBreak (qt_gsi::QtToCppAdaptor<Qt::ToolBarArea>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_addToolBarBreak_1817 ()
{
  return new qt_gsi::GenericMethod ("addToolBarBreak", "@brief Method void QMainWindow::addToolBarBreak(Qt::ToolBarArea area)\n", false, &_init_f_addToolBarBreak_1817, &_call_f_addToolBarBreak_1817);
}

// QWidget *QMainWindow::centralWidget()


static void _init_f_centralWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_centralWidget_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)((QMainWindow *)cls)->centralWidget ());
}

static qt_gsi::GenericMethod *_create_f_centralWidget_c0 ()
{
  return new qt_gsi::GenericMethod (":centralWidget", "@brief Method QWidget *QMainWindow::centralWidget()\n", true, &_init_f_centralWidget_c0, &_call_f_centralWidget_c0);
}

// Qt::DockWidgetArea QMainWindow::corner(Qt::Corner corner)


static void _init_f_corner_c1366 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("corner");
  decl->add_arg<const qt_gsi::Converter<Qt::Corner>::target_type & > (argspec_0);
  decl->set_return<qt_gsi::Converter<Qt::DockWidgetArea>::target_type > ();
}

static void _call_f_corner_c1366 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::Corner>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::Corner>::target_type & > ();
  ret.write<qt_gsi::Converter<Qt::DockWidgetArea>::target_type > ((qt_gsi::Converter<Qt::DockWidgetArea>::target_type)qt_gsi::CppToQtAdaptor<Qt::DockWidgetArea>(((QMainWindow *)cls)->corner (qt_gsi::QtToCppAdaptor<Qt::Corner>(arg1).cref())));
}

static qt_gsi::GenericMethod *_create_f_corner_c1366 ()
{
  return new qt_gsi::GenericMethod ("corner", "@brief Method Qt::DockWidgetArea QMainWindow::corner(Qt::Corner corner)\n", true, &_init_f_corner_c1366, &_call_f_corner_c1366);
}

// QMenu *QMainWindow::createPopupMenu()


static void _init_f_createPopupMenu_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMenu * > ();
}

static void _call_f_createPopupMenu_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QMenu * > ((QMenu *)((QMainWindow *)cls)->createPopupMenu ());
}

static qt_gsi::GenericMethod *_create_f_createPopupMenu_0 ()
{
  return new qt_gsi::GenericMethod ("createPopupMenu", "@brief Method QMenu *QMainWindow::createPopupMenu()\n", false, &_init_f_createPopupMenu_0, &_call_f_createPopupMenu_0);
}

// QFlags<QMainWindow::DockOption> QMainWindow::dockOptions()


static void _init_f_dockOptions_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QMainWindow::DockOption> >::target_type > ();
}

static void _call_f_dockOptions_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QMainWindow::DockOption> >::target_type > ((qt_gsi::Converter<QFlags<QMainWindow::DockOption> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QMainWindow::DockOption> >(((QMainWindow *)cls)->dockOptions ()));
}

static qt_gsi::GenericMethod *_create_f_dockOptions_c0 ()
{
  return new qt_gsi::GenericMethod (":dockOptions", "@brief Method QFlags<QMainWindow::DockOption> QMainWindow::dockOptions()\n", true, &_init_f_dockOptions_c0, &_call_f_dockOptions_c0);
}

// Qt::DockWidgetArea QMainWindow::dockWidgetArea(QDockWidget *dockwidget)


static void _init_f_dockWidgetArea_c1700 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dockwidget");
  decl->add_arg<QDockWidget * > (argspec_0);
  decl->set_return<qt_gsi::Converter<Qt::DockWidgetArea>::target_type > ();
}

static void _call_f_dockWidgetArea_c1700 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDockWidget *arg1 = args.read<QDockWidget * > ();
  ret.write<qt_gsi::Converter<Qt::DockWidgetArea>::target_type > ((qt_gsi::Converter<Qt::DockWidgetArea>::target_type)qt_gsi::CppToQtAdaptor<Qt::DockWidgetArea>(((QMainWindow *)cls)->dockWidgetArea (arg1)));
}

static qt_gsi::GenericMethod *_create_f_dockWidgetArea_c1700 ()
{
  return new qt_gsi::GenericMethod ("dockWidgetArea", "@brief Method Qt::DockWidgetArea QMainWindow::dockWidgetArea(QDockWidget *dockwidget)\n", true, &_init_f_dockWidgetArea_c1700, &_call_f_dockWidgetArea_c1700);
}

// bool QMainWindow::documentMode()


static void _init_f_documentMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_documentMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QMainWindow *)cls)->documentMode ());
}

static qt_gsi::GenericMethod *_create_f_documentMode_c0 ()
{
  return new qt_gsi::GenericMethod (":documentMode", "@brief Method bool QMainWindow::documentMode()\n", true, &_init_f_documentMode_c0, &_call_f_documentMode_c0);
}

// QSize QMainWindow::iconSize()


static void _init_f_iconSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_iconSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QMainWindow *)cls)->iconSize ());
}

static qt_gsi::GenericMethod *_create_f_iconSize_c0 ()
{
  return new qt_gsi::GenericMethod (":iconSize", "@brief Method QSize QMainWindow::iconSize()\n", true, &_init_f_iconSize_c0, &_call_f_iconSize_c0);
}

// void QMainWindow::insertToolBar(QToolBar *before, QToolBar *toolbar)


static void _init_f_insertToolBar_2680 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("before");
  decl->add_arg<QToolBar * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("toolbar");
  decl->add_arg<QToolBar * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertToolBar_2680 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QToolBar *arg1 = args.read<QToolBar * > ();
  QToolBar *arg2 = args.read<QToolBar * > ();
  ((QMainWindow *)cls)->insertToolBar (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_insertToolBar_2680 ()
{
  return new qt_gsi::GenericMethod ("insertToolBar", "@brief Method void QMainWindow::insertToolBar(QToolBar *before, QToolBar *toolbar)\n", false, &_init_f_insertToolBar_2680, &_call_f_insertToolBar_2680);
}

// void QMainWindow::insertToolBarBreak(QToolBar *before)


static void _init_f_insertToolBarBreak_1394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("before");
  decl->add_arg<QToolBar * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_insertToolBarBreak_1394 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QToolBar *arg1 = args.read<QToolBar * > ();
  ((QMainWindow *)cls)->insertToolBarBreak (arg1);
}

static qt_gsi::GenericMethod *_create_f_insertToolBarBreak_1394 ()
{
  return new qt_gsi::GenericMethod ("insertToolBarBreak", "@brief Method void QMainWindow::insertToolBarBreak(QToolBar *before)\n", false, &_init_f_insertToolBarBreak_1394, &_call_f_insertToolBarBreak_1394);
}

// bool QMainWindow::isAnimated()


static void _init_f_isAnimated_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAnimated_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QMainWindow *)cls)->isAnimated ());
}

static qt_gsi::GenericMethod *_create_f_isAnimated_c0 ()
{
  return new qt_gsi::GenericMethod ("isAnimated?|:animated", "@brief Method bool QMainWindow::isAnimated()\n", true, &_init_f_isAnimated_c0, &_call_f_isAnimated_c0);
}

// bool QMainWindow::isDockNestingEnabled()


static void _init_f_isDockNestingEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDockNestingEnabled_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QMainWindow *)cls)->isDockNestingEnabled ());
}

static qt_gsi::GenericMethod *_create_f_isDockNestingEnabled_c0 ()
{
  return new qt_gsi::GenericMethod ("isDockNestingEnabled?|:dockNestingEnabled", "@brief Method bool QMainWindow::isDockNestingEnabled()\n", true, &_init_f_isDockNestingEnabled_c0, &_call_f_isDockNestingEnabled_c0);
}

// bool QMainWindow::isSeparator(const QPoint &pos)


static void _init_f_isSeparator_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isSeparator_c1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<bool > ((bool)((QMainWindow *)cls)->isSeparator (arg1));
}

static qt_gsi::GenericMethod *_create_f_isSeparator_c1916 ()
{
  return new qt_gsi::GenericMethod ("isSeparator?", "@brief Method bool QMainWindow::isSeparator(const QPoint &pos)\n", true, &_init_f_isSeparator_c1916, &_call_f_isSeparator_c1916);
}

// QMenuBar *QMainWindow::menuBar()


static void _init_f_menuBar_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMenuBar * > ();
}

static void _call_f_menuBar_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QMenuBar * > ((QMenuBar *)((QMainWindow *)cls)->menuBar ());
}

static qt_gsi::GenericMethod *_create_f_menuBar_c0 ()
{
  return new qt_gsi::GenericMethod (":menuBar", "@brief Method QMenuBar *QMainWindow::menuBar()\n", true, &_init_f_menuBar_c0, &_call_f_menuBar_c0);
}

// QWidget *QMainWindow::menuWidget()


static void _init_f_menuWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_menuWidget_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)((QMainWindow *)cls)->menuWidget ());
}

static qt_gsi::GenericMethod *_create_f_menuWidget_c0 ()
{
  return new qt_gsi::GenericMethod (":menuWidget", "@brief Method QWidget *QMainWindow::menuWidget()\n", true, &_init_f_menuWidget_c0, &_call_f_menuWidget_c0);
}

// void QMainWindow::removeDockWidget(QDockWidget *dockwidget)


static void _init_f_removeDockWidget_1700 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dockwidget");
  decl->add_arg<QDockWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeDockWidget_1700 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDockWidget *arg1 = args.read<QDockWidget * > ();
  ((QMainWindow *)cls)->removeDockWidget (arg1);
}

static qt_gsi::GenericMethod *_create_f_removeDockWidget_1700 ()
{
  return new qt_gsi::GenericMethod ("removeDockWidget", "@brief Method void QMainWindow::removeDockWidget(QDockWidget *dockwidget)\n", false, &_init_f_removeDockWidget_1700, &_call_f_removeDockWidget_1700);
}

// void QMainWindow::removeToolBar(QToolBar *toolbar)


static void _init_f_removeToolBar_1394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("toolbar");
  decl->add_arg<QToolBar * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeToolBar_1394 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QToolBar *arg1 = args.read<QToolBar * > ();
  ((QMainWindow *)cls)->removeToolBar (arg1);
}

static qt_gsi::GenericMethod *_create_f_removeToolBar_1394 ()
{
  return new qt_gsi::GenericMethod ("removeToolBar", "@brief Method void QMainWindow::removeToolBar(QToolBar *toolbar)\n", false, &_init_f_removeToolBar_1394, &_call_f_removeToolBar_1394);
}

// void QMainWindow::removeToolBarBreak(QToolBar *before)


static void _init_f_removeToolBarBreak_1394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("before");
  decl->add_arg<QToolBar * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeToolBarBreak_1394 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QToolBar *arg1 = args.read<QToolBar * > ();
  ((QMainWindow *)cls)->removeToolBarBreak (arg1);
}

static qt_gsi::GenericMethod *_create_f_removeToolBarBreak_1394 ()
{
  return new qt_gsi::GenericMethod ("removeToolBarBreak", "@brief Method void QMainWindow::removeToolBarBreak(QToolBar *before)\n", false, &_init_f_removeToolBarBreak_1394, &_call_f_removeToolBarBreak_1394);
}

// bool QMainWindow::restoreDockWidget(QDockWidget *dockwidget)


static void _init_f_restoreDockWidget_1700 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dockwidget");
  decl->add_arg<QDockWidget * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_restoreDockWidget_1700 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDockWidget *arg1 = args.read<QDockWidget * > ();
  ret.write<bool > ((bool)((QMainWindow *)cls)->restoreDockWidget (arg1));
}

static qt_gsi::GenericMethod *_create_f_restoreDockWidget_1700 ()
{
  return new qt_gsi::GenericMethod ("restoreDockWidget", "@brief Method bool QMainWindow::restoreDockWidget(QDockWidget *dockwidget)\n", false, &_init_f_restoreDockWidget_1700, &_call_f_restoreDockWidget_1700);
}

// bool QMainWindow::restoreState(const QByteArray &state, int version)


static void _init_f_restoreState_2968 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("version", true, "0");
  decl->add_arg<int > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_restoreState_2968 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  int arg2 = args ? args.read<int > () : (int)(0);
  ret.write<bool > ((bool)((QMainWindow *)cls)->restoreState (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_restoreState_2968 ()
{
  return new qt_gsi::GenericMethod ("restoreState", "@brief Method bool QMainWindow::restoreState(const QByteArray &state, int version)\n", false, &_init_f_restoreState_2968, &_call_f_restoreState_2968);
}

// QByteArray QMainWindow::saveState(int version)


static void _init_f_saveState_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("version", true, "0");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_saveState_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(0);
  ret.write<QByteArray > ((QByteArray)((QMainWindow *)cls)->saveState (arg1));
}

static qt_gsi::GenericMethod *_create_f_saveState_c767 ()
{
  return new qt_gsi::GenericMethod ("saveState", "@brief Method QByteArray QMainWindow::saveState(int version)\n", true, &_init_f_saveState_c767, &_call_f_saveState_c767);
}

// void QMainWindow::setAnimated(bool enabled)


static void _init_f_setAnimated_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAnimated_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QMainWindow *)cls)->setAnimated (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAnimated_864 ()
{
  return new qt_gsi::GenericMethod ("setAnimated|animated=", "@brief Method void QMainWindow::setAnimated(bool enabled)\n", false, &_init_f_setAnimated_864, &_call_f_setAnimated_864);
}

// void QMainWindow::setCentralWidget(QWidget *widget)


static void _init_f_setCentralWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCentralWidget_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QMainWindow *)cls)->setCentralWidget (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCentralWidget_1315 ()
{
  return new qt_gsi::GenericMethod ("setCentralWidget|centralWidget=", "@brief Method void QMainWindow::setCentralWidget(QWidget *widget)\n", false, &_init_f_setCentralWidget_1315, &_call_f_setCentralWidget_1315);
}

// void QMainWindow::setCorner(Qt::Corner corner, Qt::DockWidgetArea area)


static void _init_f_setCorner_3381 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("corner");
  decl->add_arg<const qt_gsi::Converter<Qt::Corner>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("area");
  decl->add_arg<const qt_gsi::Converter<Qt::DockWidgetArea>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setCorner_3381 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::Corner>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::Corner>::target_type & > ();
  const qt_gsi::Converter<Qt::DockWidgetArea>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DockWidgetArea>::target_type & > ();
  ((QMainWindow *)cls)->setCorner (qt_gsi::QtToCppAdaptor<Qt::Corner>(arg1).cref(), qt_gsi::QtToCppAdaptor<Qt::DockWidgetArea>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setCorner_3381 ()
{
  return new qt_gsi::GenericMethod ("setCorner", "@brief Method void QMainWindow::setCorner(Qt::Corner corner, Qt::DockWidgetArea area)\n", false, &_init_f_setCorner_3381, &_call_f_setCorner_3381);
}

// void QMainWindow::setDockNestingEnabled(bool enabled)


static void _init_f_setDockNestingEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDockNestingEnabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QMainWindow *)cls)->setDockNestingEnabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDockNestingEnabled_864 ()
{
  return new qt_gsi::GenericMethod ("setDockNestingEnabled|dockNestingEnabled=", "@brief Method void QMainWindow::setDockNestingEnabled(bool enabled)\n", false, &_init_f_setDockNestingEnabled_864, &_call_f_setDockNestingEnabled_864);
}

// void QMainWindow::setDockOptions(QFlags<QMainWindow::DockOption> options)


static void _init_f_setDockOptions_3368 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options");
  decl->add_arg<const qt_gsi::Converter<QFlags<QMainWindow::DockOption> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDockOptions_3368 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QMainWindow::DockOption> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QMainWindow::DockOption> >::target_type & > ();
  ((QMainWindow *)cls)->setDockOptions (qt_gsi::QtToCppAdaptor<QFlags<QMainWindow::DockOption> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setDockOptions_3368 ()
{
  return new qt_gsi::GenericMethod ("setDockOptions|dockOptions=", "@brief Method void QMainWindow::setDockOptions(QFlags<QMainWindow::DockOption> options)\n", false, &_init_f_setDockOptions_3368, &_call_f_setDockOptions_3368);
}

// void QMainWindow::setDocumentMode(bool enabled)


static void _init_f_setDocumentMode_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDocumentMode_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QMainWindow *)cls)->setDocumentMode (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDocumentMode_864 ()
{
  return new qt_gsi::GenericMethod ("setDocumentMode|documentMode=", "@brief Method void QMainWindow::setDocumentMode(bool enabled)\n", false, &_init_f_setDocumentMode_864, &_call_f_setDocumentMode_864);
}

// void QMainWindow::setIconSize(const QSize &iconSize)


static void _init_f_setIconSize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconSize");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIconSize_1805 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  ((QMainWindow *)cls)->setIconSize (arg1);
}

static qt_gsi::GenericMethod *_create_f_setIconSize_1805 ()
{
  return new qt_gsi::GenericMethod ("setIconSize|iconSize=", "@brief Method void QMainWindow::setIconSize(const QSize &iconSize)\n", false, &_init_f_setIconSize_1805, &_call_f_setIconSize_1805);
}

// void QMainWindow::setMenuBar(QMenuBar *menubar)


static void _init_f_setMenuBar_1385 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("menubar");
  decl->add_arg<QMenuBar * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMenuBar_1385 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMenuBar *arg1 = args.read<QMenuBar * > ();
  ((QMainWindow *)cls)->setMenuBar (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMenuBar_1385 ()
{
  return new qt_gsi::GenericMethod ("setMenuBar|menuBar=", "@brief Method void QMainWindow::setMenuBar(QMenuBar *menubar)\n", false, &_init_f_setMenuBar_1385, &_call_f_setMenuBar_1385);
}

// void QMainWindow::setMenuWidget(QWidget *menubar)


static void _init_f_setMenuWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("menubar");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMenuWidget_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QMainWindow *)cls)->setMenuWidget (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMenuWidget_1315 ()
{
  return new qt_gsi::GenericMethod ("setMenuWidget|menuWidget=", "@brief Method void QMainWindow::setMenuWidget(QWidget *menubar)\n", false, &_init_f_setMenuWidget_1315, &_call_f_setMenuWidget_1315);
}

// void QMainWindow::setStatusBar(QStatusBar *statusbar)


static void _init_f_setStatusBar_1624 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("statusbar");
  decl->add_arg<QStatusBar * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStatusBar_1624 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStatusBar *arg1 = args.read<QStatusBar * > ();
  ((QMainWindow *)cls)->setStatusBar (arg1);
}

static qt_gsi::GenericMethod *_create_f_setStatusBar_1624 ()
{
  return new qt_gsi::GenericMethod ("setStatusBar|statusBar=", "@brief Method void QMainWindow::setStatusBar(QStatusBar *statusbar)\n", false, &_init_f_setStatusBar_1624, &_call_f_setStatusBar_1624);
}

// void QMainWindow::setTabPosition(QFlags<Qt::DockWidgetArea> areas, QTabWidget::TabPosition tabPosition)


static void _init_f_setTabPosition_5367 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("areas");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::DockWidgetArea> >::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("tabPosition");
  decl->add_arg<const qt_gsi::Converter<QTabWidget::TabPosition>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setTabPosition_5367 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<Qt::DockWidgetArea> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<Qt::DockWidgetArea> >::target_type & > ();
  const qt_gsi::Converter<QTabWidget::TabPosition>::target_type & arg2 = args.read<const qt_gsi::Converter<QTabWidget::TabPosition>::target_type & > ();
  ((QMainWindow *)cls)->setTabPosition (qt_gsi::QtToCppAdaptor<QFlags<Qt::DockWidgetArea> >(arg1).cref(), qt_gsi::QtToCppAdaptor<QTabWidget::TabPosition>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setTabPosition_5367 ()
{
  return new qt_gsi::GenericMethod ("setTabPosition", "@brief Method void QMainWindow::setTabPosition(QFlags<Qt::DockWidgetArea> areas, QTabWidget::TabPosition tabPosition)\n", false, &_init_f_setTabPosition_5367, &_call_f_setTabPosition_5367);
}

// void QMainWindow::setTabShape(QTabWidget::TabShape tabShape)


static void _init_f_setTabShape_2300 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tabShape");
  decl->add_arg<const qt_gsi::Converter<QTabWidget::TabShape>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTabShape_2300 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QTabWidget::TabShape>::target_type & arg1 = args.read<const qt_gsi::Converter<QTabWidget::TabShape>::target_type & > ();
  ((QMainWindow *)cls)->setTabShape (qt_gsi::QtToCppAdaptor<QTabWidget::TabShape>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setTabShape_2300 ()
{
  return new qt_gsi::GenericMethod ("setTabShape|tabShape=", "@brief Method void QMainWindow::setTabShape(QTabWidget::TabShape tabShape)\n", false, &_init_f_setTabShape_2300, &_call_f_setTabShape_2300);
}

// void QMainWindow::setToolButtonStyle(Qt::ToolButtonStyle toolButtonStyle)


static void _init_f_setToolButtonStyle_2328 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("toolButtonStyle");
  decl->add_arg<const qt_gsi::Converter<Qt::ToolButtonStyle>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setToolButtonStyle_2328 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::ToolButtonStyle>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::ToolButtonStyle>::target_type & > ();
  ((QMainWindow *)cls)->setToolButtonStyle (qt_gsi::QtToCppAdaptor<Qt::ToolButtonStyle>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setToolButtonStyle_2328 ()
{
  return new qt_gsi::GenericMethod ("setToolButtonStyle|toolButtonStyle=", "@brief Method void QMainWindow::setToolButtonStyle(Qt::ToolButtonStyle toolButtonStyle)\n", false, &_init_f_setToolButtonStyle_2328, &_call_f_setToolButtonStyle_2328);
}

// void QMainWindow::setUnifiedTitleAndToolBarOnMac(bool set)


static void _init_f_setUnifiedTitleAndToolBarOnMac_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("set");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUnifiedTitleAndToolBarOnMac_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QMainWindow *)cls)->setUnifiedTitleAndToolBarOnMac (arg1);
}

static qt_gsi::GenericMethod *_create_f_setUnifiedTitleAndToolBarOnMac_864 ()
{
  return new qt_gsi::GenericMethod ("setUnifiedTitleAndToolBarOnMac|unifiedTitleAndToolBarOnMac=", "@brief Method void QMainWindow::setUnifiedTitleAndToolBarOnMac(bool set)\n", false, &_init_f_setUnifiedTitleAndToolBarOnMac_864, &_call_f_setUnifiedTitleAndToolBarOnMac_864);
}

// void QMainWindow::splitDockWidget(QDockWidget *after, QDockWidget *dockwidget, Qt::Orientation orientation)


static void _init_f_splitDockWidget_5097 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("after");
  decl->add_arg<QDockWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dockwidget");
  decl->add_arg<QDockWidget * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_splitDockWidget_5097 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDockWidget *arg1 = args.read<QDockWidget * > ();
  QDockWidget *arg2 = args.read<QDockWidget * > ();
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg3 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  ((QMainWindow *)cls)->splitDockWidget (arg1, arg2, qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg3).cref());
}

static qt_gsi::GenericMethod *_create_f_splitDockWidget_5097 ()
{
  return new qt_gsi::GenericMethod ("splitDockWidget", "@brief Method void QMainWindow::splitDockWidget(QDockWidget *after, QDockWidget *dockwidget, Qt::Orientation orientation)\n", false, &_init_f_splitDockWidget_5097, &_call_f_splitDockWidget_5097);
}

// QStatusBar *QMainWindow::statusBar()


static void _init_f_statusBar_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStatusBar * > ();
}

static void _call_f_statusBar_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QStatusBar * > ((QStatusBar *)((QMainWindow *)cls)->statusBar ());
}

static qt_gsi::GenericMethod *_create_f_statusBar_c0 ()
{
  return new qt_gsi::GenericMethod (":statusBar", "@brief Method QStatusBar *QMainWindow::statusBar()\n", true, &_init_f_statusBar_c0, &_call_f_statusBar_c0);
}

// QTabWidget::TabPosition QMainWindow::tabPosition(Qt::DockWidgetArea area)


static void _init_f_tabPosition_c2123 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("area");
  decl->add_arg<const qt_gsi::Converter<Qt::DockWidgetArea>::target_type & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QTabWidget::TabPosition>::target_type > ();
}

static void _call_f_tabPosition_c2123 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::DockWidgetArea>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::DockWidgetArea>::target_type & > ();
  ret.write<qt_gsi::Converter<QTabWidget::TabPosition>::target_type > ((qt_gsi::Converter<QTabWidget::TabPosition>::target_type)qt_gsi::CppToQtAdaptor<QTabWidget::TabPosition>(((QMainWindow *)cls)->tabPosition (qt_gsi::QtToCppAdaptor<Qt::DockWidgetArea>(arg1).cref())));
}

static qt_gsi::GenericMethod *_create_f_tabPosition_c2123 ()
{
  return new qt_gsi::GenericMethod ("tabPosition", "@brief Method QTabWidget::TabPosition QMainWindow::tabPosition(Qt::DockWidgetArea area)\n", true, &_init_f_tabPosition_c2123, &_call_f_tabPosition_c2123);
}

// QTabWidget::TabShape QMainWindow::tabShape()


static void _init_f_tabShape_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTabWidget::TabShape>::target_type > ();
}

static void _call_f_tabShape_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QTabWidget::TabShape>::target_type > ((qt_gsi::Converter<QTabWidget::TabShape>::target_type)qt_gsi::CppToQtAdaptor<QTabWidget::TabShape>(((QMainWindow *)cls)->tabShape ()));
}

static qt_gsi::GenericMethod *_create_f_tabShape_c0 ()
{
  return new qt_gsi::GenericMethod (":tabShape", "@brief Method QTabWidget::TabShape QMainWindow::tabShape()\n", true, &_init_f_tabShape_c0, &_call_f_tabShape_c0);
}

// QList<QDockWidget *> QMainWindow::tabifiedDockWidgets(QDockWidget *dockwidget)


static void _init_f_tabifiedDockWidgets_c1700 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dockwidget");
  decl->add_arg<QDockWidget * > (argspec_0);
  decl->set_return<qt_gsi::Converter<QList<QDockWidget *> >::target_type > ();
}

static void _call_f_tabifiedDockWidgets_c1700 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDockWidget *arg1 = args.read<QDockWidget * > ();
  ret.write<qt_gsi::Converter<QList<QDockWidget *> >::target_type > ((qt_gsi::Converter<QList<QDockWidget *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QDockWidget *> >(((QMainWindow *)cls)->tabifiedDockWidgets (arg1)));
}

static qt_gsi::GenericMethod *_create_f_tabifiedDockWidgets_c1700 ()
{
  return new qt_gsi::GenericMethod ("tabifiedDockWidgets", "@brief Method QList<QDockWidget *> QMainWindow::tabifiedDockWidgets(QDockWidget *dockwidget)\n", true, &_init_f_tabifiedDockWidgets_c1700, &_call_f_tabifiedDockWidgets_c1700);
}

// void QMainWindow::tabifyDockWidget(QDockWidget *first, QDockWidget *second)


static void _init_f_tabifyDockWidget_3292 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("first");
  decl->add_arg<QDockWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("second");
  decl->add_arg<QDockWidget * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_tabifyDockWidget_3292 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDockWidget *arg1 = args.read<QDockWidget * > ();
  QDockWidget *arg2 = args.read<QDockWidget * > ();
  ((QMainWindow *)cls)->tabifyDockWidget (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_tabifyDockWidget_3292 ()
{
  return new qt_gsi::GenericMethod ("tabifyDockWidget", "@brief Method void QMainWindow::tabifyDockWidget(QDockWidget *first, QDockWidget *second)\n", false, &_init_f_tabifyDockWidget_3292, &_call_f_tabifyDockWidget_3292);
}

// Qt::ToolBarArea QMainWindow::toolBarArea(QToolBar *toolbar)


static void _init_f_toolBarArea_c1394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("toolbar");
  decl->add_arg<QToolBar * > (argspec_0);
  decl->set_return<qt_gsi::Converter<Qt::ToolBarArea>::target_type > ();
}

static void _call_f_toolBarArea_c1394 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QToolBar *arg1 = args.read<QToolBar * > ();
  ret.write<qt_gsi::Converter<Qt::ToolBarArea>::target_type > ((qt_gsi::Converter<Qt::ToolBarArea>::target_type)qt_gsi::CppToQtAdaptor<Qt::ToolBarArea>(((QMainWindow *)cls)->toolBarArea (arg1)));
}

static qt_gsi::GenericMethod *_create_f_toolBarArea_c1394 ()
{
  return new qt_gsi::GenericMethod ("toolBarArea", "@brief Method Qt::ToolBarArea QMainWindow::toolBarArea(QToolBar *toolbar)\n", true, &_init_f_toolBarArea_c1394, &_call_f_toolBarArea_c1394);
}

// bool QMainWindow::toolBarBreak(QToolBar *toolbar)


static void _init_f_toolBarBreak_c1394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("toolbar");
  decl->add_arg<QToolBar * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_toolBarBreak_c1394 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QToolBar *arg1 = args.read<QToolBar * > ();
  ret.write<bool > ((bool)((QMainWindow *)cls)->toolBarBreak (arg1));
}

static qt_gsi::GenericMethod *_create_f_toolBarBreak_c1394 ()
{
  return new qt_gsi::GenericMethod ("toolBarBreak", "@brief Method bool QMainWindow::toolBarBreak(QToolBar *toolbar)\n", true, &_init_f_toolBarBreak_c1394, &_call_f_toolBarBreak_c1394);
}

// Qt::ToolButtonStyle QMainWindow::toolButtonStyle()


static void _init_f_toolButtonStyle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::ToolButtonStyle>::target_type > ();
}

static void _call_f_toolButtonStyle_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::ToolButtonStyle>::target_type > ((qt_gsi::Converter<Qt::ToolButtonStyle>::target_type)qt_gsi::CppToQtAdaptor<Qt::ToolButtonStyle>(((QMainWindow *)cls)->toolButtonStyle ()));
}

static qt_gsi::GenericMethod *_create_f_toolButtonStyle_c0 ()
{
  return new qt_gsi::GenericMethod (":toolButtonStyle", "@brief Method Qt::ToolButtonStyle QMainWindow::toolButtonStyle()\n", true, &_init_f_toolButtonStyle_c0, &_call_f_toolButtonStyle_c0);
}

// bool QMainWindow::unifiedTitleAndToolBarOnMac()


static void _init_f_unifiedTitleAndToolBarOnMac_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_unifiedTitleAndToolBarOnMac_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QMainWindow *)cls)->unifiedTitleAndToolBarOnMac ());
}

static qt_gsi::GenericMethod *_create_f_unifiedTitleAndToolBarOnMac_c0 ()
{
  return new qt_gsi::GenericMethod (":unifiedTitleAndToolBarOnMac", "@brief Method bool QMainWindow::unifiedTitleAndToolBarOnMac()\n", true, &_init_f_unifiedTitleAndToolBarOnMac_c0, &_call_f_unifiedTitleAndToolBarOnMac_c0);
}

// static QString QMainWindow::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QMainWindow::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMainWindow::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QMainWindow::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QMainWindow::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMainWindow::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QMainWindow::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QMainWindow::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QMainWindow::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QMainWindow::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QMainWindow::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QMainWindow::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QMainWindow, QMainWindow_EventAdaptor> ea_QMainWindow;

namespace gsi
{
extern gsi::Class<QWidget> decl_QWidget;

gsi::Class<QMainWindow> decl_QMainWindow (ea_QMainWindow, decl_QWidget, "QMainWindow_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_addDockWidget_3715 ()) +
  gsi::Methods(_create_f_addDockWidget_5520 ()) +
  gsi::Methods(_create_f_addToolBar_3103 ()) +
  gsi::Methods(_create_f_addToolBar_1394 ()) +
  gsi::Methods(_create_f_addToolBar_2025 ()) +
  gsi::Methods(_create_f_addToolBarBreak_1817 ()) +
  gsi::Methods(_create_f_centralWidget_c0 ()) +
  gsi::Methods(_create_f_corner_c1366 ()) +
  gsi::Methods(_create_f_createPopupMenu_0 ()) +
  gsi::Methods(_create_f_dockOptions_c0 ()) +
  gsi::Methods(_create_f_dockWidgetArea_c1700 ()) +
  gsi::Methods(_create_f_documentMode_c0 ()) +
  gsi::Methods(_create_f_iconSize_c0 ()) +
  gsi::Methods(_create_f_insertToolBar_2680 ()) +
  gsi::Methods(_create_f_insertToolBarBreak_1394 ()) +
  gsi::Methods(_create_f_isAnimated_c0 ()) +
  gsi::Methods(_create_f_isDockNestingEnabled_c0 ()) +
  gsi::Methods(_create_f_isSeparator_c1916 ()) +
  gsi::Methods(_create_f_menuBar_c0 ()) +
  gsi::Methods(_create_f_menuWidget_c0 ()) +
  gsi::Methods(_create_f_removeDockWidget_1700 ()) +
  gsi::Methods(_create_f_removeToolBar_1394 ()) +
  gsi::Methods(_create_f_removeToolBarBreak_1394 ()) +
  gsi::Methods(_create_f_restoreDockWidget_1700 ()) +
  gsi::Methods(_create_f_restoreState_2968 ()) +
  gsi::Methods(_create_f_saveState_c767 ()) +
  gsi::Methods(_create_f_setAnimated_864 ()) +
  gsi::Methods(_create_f_setCentralWidget_1315 ()) +
  gsi::Methods(_create_f_setCorner_3381 ()) +
  gsi::Methods(_create_f_setDockNestingEnabled_864 ()) +
  gsi::Methods(_create_f_setDockOptions_3368 ()) +
  gsi::Methods(_create_f_setDocumentMode_864 ()) +
  gsi::Methods(_create_f_setIconSize_1805 ()) +
  gsi::Methods(_create_f_setMenuBar_1385 ()) +
  gsi::Methods(_create_f_setMenuWidget_1315 ()) +
  gsi::Methods(_create_f_setStatusBar_1624 ()) +
  gsi::Methods(_create_f_setTabPosition_5367 ()) +
  gsi::Methods(_create_f_setTabShape_2300 ()) +
  gsi::Methods(_create_f_setToolButtonStyle_2328 ()) +
  gsi::Methods(_create_f_setUnifiedTitleAndToolBarOnMac_864 ()) +
  gsi::Methods(_create_f_splitDockWidget_5097 ()) +
  gsi::Methods(_create_f_statusBar_c0 ()) +
  gsi::Methods(_create_f_tabPosition_c2123 ()) +
  gsi::Methods(_create_f_tabShape_c0 ()) +
  gsi::Methods(_create_f_tabifiedDockWidgets_c1700 ()) +
  gsi::Methods(_create_f_tabifyDockWidget_3292 ()) +
  gsi::Methods(_create_f_toolBarArea_c1394 ()) +
  gsi::Methods(_create_f_toolBarBreak_c1394 ()) +
  gsi::Methods(_create_f_toolButtonStyle_c0 ()) +
  gsi::Methods(_create_f_unifiedTitleAndToolBarOnMac_c0 ()) +
  qt_gsi::qt_signal<QMainWindow, QMainWindow_EventAdaptor, const QPoint &> ("customContextMenuRequested", &QMainWindow_EventAdaptor::customContextMenuRequested_e_1916, gsi::arg("pos"), "@brief Signal declaration for QMainWindow::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QMainWindow, QMainWindow_EventAdaptor, QObject *> ("destroyed", &QMainWindow_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QMainWindow::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QMainWindow, QMainWindow_EventAdaptor, const QSize &> ("iconSizeChanged", &QMainWindow_EventAdaptor::iconSizeChanged_e_1805, gsi::arg("iconSize"), "@brief Signal declaration for QMainWindow::iconSizeChanged(const QSize &iconSize)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QMainWindow, QMainWindow_EventAdaptor, const qt_gsi::Converter<Qt::ToolButtonStyle>::target_type &> ("toolButtonStyleChanged", &QMainWindow_EventAdaptor::toolButtonStyleChanged_e_2328, gsi::arg("toolButtonStyle"), "@brief Signal declaration for QMainWindow::toolButtonStyleChanged(Qt::ToolButtonStyle toolButtonStyle)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QMainWindow");
}


class QMainWindow_Adaptor : public QMainWindow, public qt_gsi::QtObjectBase
{
public:

  virtual ~QMainWindow_Adaptor();

  //  [adaptor ctor] QMainWindow::QMainWindow(QWidget *parent, QFlags<Qt::WindowType> flags)
  QMainWindow_Adaptor() : QMainWindow()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMainWindow::QMainWindow(QWidget *parent, QFlags<Qt::WindowType> flags)
  QMainWindow_Adaptor(QWidget *parent) : QMainWindow(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMainWindow::QMainWindow(QWidget *parent, QFlags<Qt::WindowType> flags)
  QMainWindow_Adaptor(QWidget *parent, QFlags<Qt::WindowType> flags) : QMainWindow(parent, flags)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QMainWindow::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QMainWindow_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QMainWindow::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  void QMainWindow::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QMainWindow_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QMainWindow::destroy(destroyWindow, destroySubWindows);
  }

  //  bool QMainWindow::focusNextChild()
  bool fp_QMainWindow_focusNextChild_0 () {
    return QMainWindow::focusNextChild();
  }

  //  bool QMainWindow::focusPreviousChild()
  bool fp_QMainWindow_focusPreviousChild_0 () {
    return QMainWindow::focusPreviousChild();
  }

  //  int QMainWindow::receivers(const char *signal)
  int fp_QMainWindow_receivers_c1731 (const char *signal) const {
    return QMainWindow::receivers(signal);
  }

  //  void QMainWindow::resetInputContext()
  void fp_QMainWindow_resetInputContext_0 () {
    QMainWindow::resetInputContext();
  }

  //  QObject *QMainWindow::sender()
  QObject * fp_QMainWindow_sender_c0 () const {
    return QMainWindow::sender();
  }

  //  void QMainWindow::updateMicroFocus()
  void fp_QMainWindow_updateMicroFocus_0 () {
    QMainWindow::updateMicroFocus();
  }

  //  [adaptor impl] QMenu *QMainWindow::createPopupMenu()
  QMenu * cbs_createPopupMenu_0_0()
  {
    return QMainWindow::createPopupMenu();
  }

  virtual QMenu * createPopupMenu()
  {
    if (cb_createPopupMenu_0_0.can_issue()) {
      return cb_createPopupMenu_0_0.issue<QMainWindow_Adaptor, QMenu *>(&QMainWindow_Adaptor::cbs_createPopupMenu_0_0);
    } else {
      return QMainWindow::createPopupMenu();
    }
  }

  //  [adaptor impl] bool QMainWindow::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QMainWindow::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QMainWindow_Adaptor, bool, QObject *, QEvent *>(&QMainWindow_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QMainWindow::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] int QMainWindow::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QMainWindow::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QMainWindow_Adaptor, int, int>(&QMainWindow_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QMainWindow::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QMainWindow::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QMainWindow::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QMainWindow_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QMainWindow_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QMainWindow::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QMainWindow::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QMainWindow::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QMainWindow_Adaptor, QSize>(&QMainWindow_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QMainWindow::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QMainWindow::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QMainWindow::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QMainWindow_Adaptor, QPaintEngine *>(&QMainWindow_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QMainWindow::paintEngine();
    }
  }

  //  [adaptor impl] void QMainWindow::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QMainWindow::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QMainWindow_Adaptor, bool>(&QMainWindow_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QMainWindow::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QMainWindow::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QMainWindow::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QMainWindow_Adaptor, QSize>(&QMainWindow_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QMainWindow::sizeHint();
    }
  }

  //  [adaptor impl] void QMainWindow::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QMainWindow::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QMainWindow_Adaptor, QActionEvent *>(&QMainWindow_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QMainWindow::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QMainWindow::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QMainWindow_Adaptor, QEvent *>(&QMainWindow_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QMainWindow::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QMainWindow::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QMainWindow_Adaptor, QChildEvent *>(&QMainWindow_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QMainWindow::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QMainWindow::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QMainWindow_Adaptor, QCloseEvent *>(&QMainWindow_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QMainWindow::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::contextMenuEvent(QContextMenuEvent *event)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *event)
  {
    QMainWindow::contextMenuEvent(event);
  }

  virtual void contextMenuEvent(QContextMenuEvent *event)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QMainWindow_Adaptor, QContextMenuEvent *>(&QMainWindow_Adaptor::cbs_contextMenuEvent_2363_0, event);
    } else {
      QMainWindow::contextMenuEvent(event);
    }
  }

  //  [adaptor impl] void QMainWindow::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QMainWindow::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QMainWindow_Adaptor, QEvent *>(&QMainWindow_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QMainWindow::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QMainWindow::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QMainWindow_Adaptor, const char *>(&QMainWindow_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QMainWindow::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QMainWindow::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QMainWindow::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QMainWindow_Adaptor, QDragEnterEvent *>(&QMainWindow_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QMainWindow::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QMainWindow::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QMainWindow_Adaptor, QDragLeaveEvent *>(&QMainWindow_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QMainWindow::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QMainWindow::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QMainWindow_Adaptor, QDragMoveEvent *>(&QMainWindow_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QMainWindow::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QMainWindow::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QMainWindow_Adaptor, QDropEvent *>(&QMainWindow_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QMainWindow::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QMainWindow::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QMainWindow_Adaptor, bool>(&QMainWindow_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QMainWindow::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QMainWindow::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QMainWindow_Adaptor, QEvent *>(&QMainWindow_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QMainWindow::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QMainWindow::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QMainWindow::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QMainWindow_Adaptor, bool, QEvent *>(&QMainWindow_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QMainWindow::event(_event);
    }
  }

  //  [adaptor impl] void QMainWindow::focusInEvent(QFocusEvent *)
  void cbs_focusInEvent_1729_0(QFocusEvent *arg1)
  {
    QMainWindow::focusInEvent(arg1);
  }

  virtual void focusInEvent(QFocusEvent *arg1)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QMainWindow_Adaptor, QFocusEvent *>(&QMainWindow_Adaptor::cbs_focusInEvent_1729_0, arg1);
    } else {
      QMainWindow::focusInEvent(arg1);
    }
  }

  //  [adaptor impl] bool QMainWindow::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QMainWindow::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QMainWindow_Adaptor, bool, bool>(&QMainWindow_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QMainWindow::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QMainWindow::focusOutEvent(QFocusEvent *)
  void cbs_focusOutEvent_1729_0(QFocusEvent *arg1)
  {
    QMainWindow::focusOutEvent(arg1);
  }

  virtual void focusOutEvent(QFocusEvent *arg1)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QMainWindow_Adaptor, QFocusEvent *>(&QMainWindow_Adaptor::cbs_focusOutEvent_1729_0, arg1);
    } else {
      QMainWindow::focusOutEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QMainWindow::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QMainWindow_Adaptor, const QFont &>(&QMainWindow_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QMainWindow::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QMainWindow::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QMainWindow_Adaptor, QHideEvent *>(&QMainWindow_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QMainWindow::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QMainWindow::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QMainWindow_Adaptor, QInputMethodEvent *>(&QMainWindow_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QMainWindow::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QMainWindow::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QMainWindow_Adaptor, QKeyEvent *>(&QMainWindow_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QMainWindow::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QMainWindow::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QMainWindow_Adaptor, QKeyEvent *>(&QMainWindow_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QMainWindow::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::languageChange()
  void cbs_languageChange_0_0()
  {
    QMainWindow::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QMainWindow_Adaptor>(&QMainWindow_Adaptor::cbs_languageChange_0_0);
    } else {
      QMainWindow::languageChange();
    }
  }

  //  [adaptor impl] void QMainWindow::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QMainWindow::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QMainWindow_Adaptor, QEvent *>(&QMainWindow_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QMainWindow::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QMainWindow::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QMainWindow::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QMainWindow_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QMainWindow_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QMainWindow::metric(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QMainWindow::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QMainWindow_Adaptor, QMouseEvent *>(&QMainWindow_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QMainWindow::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QMainWindow::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QMainWindow_Adaptor, QMouseEvent *>(&QMainWindow_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QMainWindow::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QMainWindow::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QMainWindow_Adaptor, QMouseEvent *>(&QMainWindow_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QMainWindow::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QMainWindow::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QMainWindow_Adaptor, QMouseEvent *>(&QMainWindow_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QMainWindow::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QMainWindow::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QMainWindow_Adaptor, QMoveEvent *>(&QMainWindow_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QMainWindow::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::paintEvent(QPaintEvent *)
  void cbs_paintEvent_1725_0(QPaintEvent *arg1)
  {
    QMainWindow::paintEvent(arg1);
  }

  virtual void paintEvent(QPaintEvent *arg1)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QMainWindow_Adaptor, QPaintEvent *>(&QMainWindow_Adaptor::cbs_paintEvent_1725_0, arg1);
    } else {
      QMainWindow::paintEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QMainWindow::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QMainWindow_Adaptor, const QPalette &>(&QMainWindow_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QMainWindow::paletteChange(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::resizeEvent(QResizeEvent *)
  void cbs_resizeEvent_1843_0(QResizeEvent *arg1)
  {
    QMainWindow::resizeEvent(arg1);
  }

  virtual void resizeEvent(QResizeEvent *arg1)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QMainWindow_Adaptor, QResizeEvent *>(&QMainWindow_Adaptor::cbs_resizeEvent_1843_0, arg1);
    } else {
      QMainWindow::resizeEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QMainWindow::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QMainWindow_Adaptor, QShowEvent *>(&QMainWindow_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QMainWindow::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QMainWindow::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QMainWindow_Adaptor, QStyle &>(&QMainWindow_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QMainWindow::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QMainWindow::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QMainWindow_Adaptor, QTabletEvent *>(&QMainWindow_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QMainWindow::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QMainWindow::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QMainWindow_Adaptor, QTimerEvent *>(&QMainWindow_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QMainWindow::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QMainWindow::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QMainWindow_Adaptor, QWheelEvent *>(&QMainWindow_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QMainWindow::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QMainWindow::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QMainWindow::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QMainWindow_Adaptor, bool>(&QMainWindow_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QMainWindow::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_createPopupMenu_0_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QMainWindow_Adaptor::~QMainWindow_Adaptor() { }

//  Constructor QMainWindow::QMainWindow(QWidget *parent, QFlags<Qt::WindowType> flags) (adaptor class)

static void _init_ctor_QMainWindow_Adaptor_3702 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > (argspec_1);
  decl->set_return_new<QMainWindow_Adaptor *> ();
}

static void _call_ctor_QMainWindow_Adaptor_3702 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::WindowType> >(heap, 0));
  ret.write<QMainWindow_Adaptor *> (new QMainWindow_Adaptor (arg1, qt_gsi::QtToCppAdaptor<QFlags<Qt::WindowType> >(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QMainWindow_Adaptor_3702 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMainWindow::QMainWindow(QWidget *parent, QFlags<Qt::WindowType> flags)\nThis method creates an object of class QMainWindow.", &_init_ctor_QMainWindow_Adaptor_3702, &_call_ctor_QMainWindow_Adaptor_3702);
}

// void QMainWindow::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<WId>::target_type & > () : (const qt_gsi::Converter<WId>::target_type &)(qt_gsi::CppToQtReadAdaptor<WId>(heap, 0));
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  bool arg3 = args ? args.read<bool > () : (bool)(true);
  ((QMainWindow_Adaptor *)cls)->fp_QMainWindow_create_2208 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_create_2208 ()
{
  return new qt_gsi::GenericMethod("*qt_create", "@brief Method void QMainWindow::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
}


// void QMainWindow::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QMainWindow_Adaptor *)cls)->fp_QMainWindow_destroy_1620 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_destroy_1620 ()
{
  return new qt_gsi::GenericMethod("*qt_destroy", "@brief Method void QMainWindow::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
}


// bool QMainWindow::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QMainWindow_Adaptor *)cls)->fp_QMainWindow_focusNextChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusNextChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusNextChild", "@brief Method bool QMainWindow::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
}


// bool QMainWindow::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QMainWindow_Adaptor *)cls)->fp_QMainWindow_focusPreviousChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusPreviousChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusPreviousChild", "@brief Method bool QMainWindow::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
}


// int QMainWindow::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QMainWindow_Adaptor *)cls)->fp_QMainWindow_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QMainWindow::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QMainWindow::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMainWindow_Adaptor *)cls)->fp_QMainWindow_resetInputContext_0 ();
}

static qt_gsi::GenericMethod*_create_fp_resetInputContext_0 ()
{
  return new qt_gsi::GenericMethod("*resetInputContext", "@brief Method void QMainWindow::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
}


// QObject *QMainWindow::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QMainWindow_Adaptor *)cls)->fp_QMainWindow_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QMainWindow::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QMainWindow::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMainWindow_Adaptor *)cls)->fp_QMainWindow_updateMicroFocus_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateMicroFocus_0 ()
{
  return new qt_gsi::GenericMethod("*updateMicroFocus", "@brief Method void QMainWindow::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
}


// QMenu *QMainWindow::createPopupMenu()

static void _init_cbs_createPopupMenu_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMenu * > ();
}

static void _call_cbs_createPopupMenu_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QMenu * > ((QMenu *)((QMainWindow_Adaptor *)cls)->cbs_createPopupMenu_0_0 ());
}

static void _set_callback_cbs_createPopupMenu_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_createPopupMenu_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_createPopupMenu_0_0 ()
{
  return new qt_gsi::GenericMethod ("createPopupMenu", "@hide", false, &_init_cbs_createPopupMenu_0_0, &_call_cbs_createPopupMenu_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_createPopupMenu_0_0 ()
{
  return new qt_gsi::GenericMethod ("createPopupMenu", "@brief Virtual method QMenu *QMainWindow::createPopupMenu()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_createPopupMenu_0_0, &_call_cbs_createPopupMenu_0_0, &_set_callback_cbs_createPopupMenu_0_0);
}


// bool QMainWindow::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QMainWindow_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QMainWindow::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// int QMainWindow::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QMainWindow_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QMainWindow::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// QVariant QMainWindow::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QMainWindow_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QMainWindow::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// QSize QMainWindow::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QMainWindow_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QMainWindow::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
}


// QPaintEngine *QMainWindow::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QMainWindow_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QMainWindow::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
}


// void QMainWindow::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QMainWindow_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QMainWindow::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
}


// QSize QMainWindow::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QMainWindow_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QMainWindow::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// void QMainWindow::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QActionEvent *arg1 = args.read<QActionEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QMainWindow::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
}


// void QMainWindow::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QMainWindow::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
}


// void QMainWindow::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QMainWindow::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QMainWindow::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCloseEvent *arg1 = args.read<QCloseEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QMainWindow::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
}


// void QMainWindow::contextMenuEvent(QContextMenuEvent *event)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QMainWindow::contextMenuEvent(QContextMenuEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
}


// void QMainWindow::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QMainWindow::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QMainWindow::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QMainWindow::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QMainWindow::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QMainWindow::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
}


// void QMainWindow::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QMainWindow::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
}


// void QMainWindow::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QMainWindow::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
}


// void QMainWindow::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDropEvent *arg1 = args.read<QDropEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QMainWindow::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
}


// void QMainWindow::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QMainWindow_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QMainWindow::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
}


// void QMainWindow::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QMainWindow::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
}


// bool QMainWindow::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QMainWindow_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QMainWindow::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// void QMainWindow::focusInEvent(QFocusEvent *)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QMainWindow::focusInEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// bool QMainWindow::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<bool > ((bool)((QMainWindow_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QMainWindow::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
}


// void QMainWindow::focusOutEvent(QFocusEvent *)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QMainWindow::focusOutEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QMainWindow::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QMainWindow_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QMainWindow::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
}


// void QMainWindow::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QHideEvent *arg1 = args.read<QHideEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QMainWindow::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
}


// void QMainWindow::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QMainWindow::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// void QMainWindow::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QMainWindow::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QMainWindow::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QMainWindow::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QMainWindow::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMainWindow_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QMainWindow::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
}


// void QMainWindow::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QMainWindow::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
}


// int QMainWindow::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QMainWindow_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QMainWindow::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
}


// void QMainWindow::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QMainWindow::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
}


// void QMainWindow::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QMainWindow::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
}


// void QMainWindow::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QMainWindow::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
}


// void QMainWindow::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QMainWindow::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
}


// void QMainWindow::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMoveEvent *arg1 = args.read<QMoveEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QMainWindow::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
}


// void QMainWindow::paintEvent(QPaintEvent *)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintEvent *arg1 = args.read<QPaintEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QMainWindow::paintEvent(QPaintEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
}


// void QMainWindow::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ((QMainWindow_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QMainWindow::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
}


// void QMainWindow::resizeEvent(QResizeEvent *)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QResizeEvent *arg1 = args.read<QResizeEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QMainWindow::resizeEvent(QResizeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
}


// void QMainWindow::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QShowEvent *arg1 = args.read<QShowEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QMainWindow::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
}


// void QMainWindow::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle &arg1 = args.read<QStyle & > ();
  ((QMainWindow_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QMainWindow::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
}


// void QMainWindow::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTabletEvent *arg1 = args.read<QTabletEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QMainWindow::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
}


// void QMainWindow::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QMainWindow::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


// void QMainWindow::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWheelEvent *arg1 = args.read<QWheelEvent * > ();
  ((QMainWindow_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QMainWindow::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
}


// void QMainWindow::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QMainWindow_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMainWindow_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QMainWindow::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
}


namespace gsi
{

extern gsi::Class<QMainWindow> decl_QMainWindow;

gsi::Class<QMainWindow_Adaptor> decl_QMainWindow_Adaptor (decl_QMainWindow, "QMainWindow",
  gsi::Methods(_create_fp_create_2208 ()) +
  gsi::Methods(_create_fp_destroy_1620 ()) +
  gsi::Methods(_create_fp_focusNextChild_0 ()) +
  gsi::Methods(_create_fp_focusPreviousChild_0 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_resetInputContext_0 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_updateMicroFocus_0 ()) +
  gsi::Methods(_create_cbs_createPopupMenu_0_0 ()) +
  gsi::Methods(_create_callback_cbs_createPopupMenu_0_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_callback_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_callback_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_callback_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_callback_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_callback_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_callback_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_callback_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_callback_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_callback_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_callback_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_callback_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_ctor_QMainWindow_Adaptor_3702 ()),
  "@qt\n@brief Binding of QMainWindow");

}


//  Implementation of the enum wrapper class for QMainWindow::DockOption
namespace qt_gsi
{

static QMainWindow_DockOption_Enum *c_1_QMainWindow_DockOption_Enum () { return new QMainWindow_DockOption_Enum (QMainWindow::AnimatedDocks); }
static QMainWindow_DockOption_Enum *c_2_QMainWindow_DockOption_Enum () { return new QMainWindow_DockOption_Enum (QMainWindow::AllowNestedDocks); }
static QMainWindow_DockOption_Enum *c_3_QMainWindow_DockOption_Enum () { return new QMainWindow_DockOption_Enum (QMainWindow::AllowTabbedDocks); }
static QMainWindow_DockOption_Enum *c_4_QMainWindow_DockOption_Enum () { return new QMainWindow_DockOption_Enum (QMainWindow::ForceTabbedDocks); }
static QMainWindow_DockOption_Enum *c_5_QMainWindow_DockOption_Enum () { return new QMainWindow_DockOption_Enum (QMainWindow::VerticalTabs); }

static gsi::Methods mkdefs_QMainWindow_DockOption () {
  return
    gsi::constant ("AnimatedDocks", &qt_gsi::c_1_QMainWindow_DockOption_Enum, "@brief Enum constant QMainWindow::AnimatedDocks") +
    gsi::constant ("AllowNestedDocks", &qt_gsi::c_2_QMainWindow_DockOption_Enum, "@brief Enum constant QMainWindow::AllowNestedDocks") +
    gsi::constant ("AllowTabbedDocks", &qt_gsi::c_3_QMainWindow_DockOption_Enum, "@brief Enum constant QMainWindow::AllowTabbedDocks") +
    gsi::constant ("ForceTabbedDocks", &qt_gsi::c_4_QMainWindow_DockOption_Enum, "@brief Enum constant QMainWindow::ForceTabbedDocks") +
    gsi::constant ("VerticalTabs", &qt_gsi::c_5_QMainWindow_DockOption_Enum, "@brief Enum constant QMainWindow::VerticalTabs");
}

static std::string to_s_QMainWindow_DockOption_Enum (const QMainWindow_DockOption_Enum *e)
{
  if (e->value () == QMainWindow::AnimatedDocks) { return tl::sprintf ("AnimatedDocks (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMainWindow::AllowNestedDocks) { return tl::sprintf ("AllowNestedDocks (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMainWindow::AllowTabbedDocks) { return tl::sprintf ("AllowTabbedDocks (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMainWindow::ForceTabbedDocks) { return tl::sprintf ("ForceTabbedDocks (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMainWindow::VerticalTabs) { return tl::sprintf ("VerticalTabs (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QMainWindow_DockOption_Enum (const QMainWindow_DockOption_Enum *e)
{
  return (unsigned int) e->value ();
}

static QMainWindow_DockOption_Enum *from_i_QMainWindow_DockOption_Enum (unsigned int i)
{
  return new QMainWindow_DockOption_Enum ((QMainWindow::DockOption) i);
}

static bool equalQMainWindow_DockOption_Enum (const QMainWindow_DockOption_Enum *e, QMainWindow_DockOption_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QMainWindow_DockOption_Enum (const QMainWindow_DockOption_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QMainWindow_DockOption_Enums oropQMainWindow_DockOption_Enums (const QMainWindow_DockOption_Enums *e, const QMainWindow_DockOption_Enums &d)
{
  return e->flags () | d.flags ();
}

static QMainWindow_DockOption_Enums andopQMainWindow_DockOption_Enums (const QMainWindow_DockOption_Enums *e, const QMainWindow_DockOption_Enums &d)
{
  return e->flags () & d.flags ();
}

static QMainWindow_DockOption_Enums xoropQMainWindow_DockOption_Enums (const QMainWindow_DockOption_Enums *e, const QMainWindow_DockOption_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QMainWindow_DockOption_Enums (const QMainWindow_DockOption_Enums *e)
{
  std::string l;
  if (e->testFlag (QMainWindow::AnimatedDocks)) { if (!l.empty ()) l += "|"; l += "AnimatedDocks"; }
  if (e->testFlag (QMainWindow::AllowNestedDocks)) { if (!l.empty ()) l += "|"; l += "AllowNestedDocks"; }
  if (e->testFlag (QMainWindow::AllowTabbedDocks)) { if (!l.empty ()) l += "|"; l += "AllowTabbedDocks"; }
  if (e->testFlag (QMainWindow::ForceTabbedDocks)) { if (!l.empty ()) l += "|"; l += "ForceTabbedDocks"; }
  if (e->testFlag (QMainWindow::VerticalTabs)) { if (!l.empty ()) l += "|"; l += "VerticalTabs"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QMainWindow_DockOption_Enums (const QMainWindow_DockOption_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QMainWindow_DockOption_Enums (const QMainWindow_DockOption_Enums *e, const QMainWindow_DockOption_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QMainWindow_DockOption_Enums> decl_QMainWindow_DockOption_Enums ("QMainWindow_QFlags_DockOption",
  gsi::method_ext ("|", &qt_gsi::oropQMainWindow_DockOption_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQMainWindow_DockOption_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQMainWindow_DockOption_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QMainWindow_DockOption_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QMainWindow_DockOption_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QMainWindow_DockOption_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QMainWindow::DockOption> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QMainWindow_DockOption_Enum> decl_QMainWindow_DockOption_Enum (decl_QMainWindow_DockOption_Enums, "QMainWindow_DockOption",
  qt_gsi::mkdefs_QMainWindow_DockOption () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QMainWindow_DockOption_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QMainWindow_DockOption_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQMainWindow_DockOption_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QMainWindow_DockOption_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QMainWindow_DockOption_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QMainWindow::DockOption enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QMainWindow> inject_QMainWindow_DockOption_Enum_in_parent (qt_gsi::mkdefs_QMainWindow_DockOption ());
static gsi::ClassExt<QMainWindow> decl_QMainWindow_DockOption_Enum_as_child (decl_QMainWindow_DockOption_Enum, "DockOption");

}

