
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file generated/gsiDeclQLocalSocket_EventAdaptor.cc
*  @brief Event adaptor implementations for QLocalSocket
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtNetwork.h"
#include "gsiDeclQLocalSocket_EventAdaptor.h"

// -----------------------------------------------------------------------
// class QLocalSocket_EventAdaptor

QLocalSocket_EventAdaptor::QLocalSocket_EventAdaptor (QObject *host)
  : QObject ()
{
  connect (host, SIGNAL(aboutToClose()), this, SLOT(aboutToClose()));
  connect (host, SIGNAL(bytesWritten(qint64)), this, SLOT(bytesWritten(qint64)));
  connect (host, SIGNAL(connected()), this, SLOT(connected()));
  connect (host, SIGNAL(destroyed(QObject *)), this, SLOT(destroyed(QObject *)));
  connect (host, SIGNAL(disconnected()), this, SLOT(disconnected()));
  connect (host, SIGNAL(error(QLocalSocket::LocalSocketError)), this, SLOT(error(QLocalSocket::LocalSocketError)));
  connect (host, SIGNAL(readChannelFinished()), this, SLOT(readChannelFinished()));
  connect (host, SIGNAL(readyRead()), this, SLOT(readyRead()));
  connect (host, SIGNAL(stateChanged(QLocalSocket::LocalSocketState)), this, SLOT(stateChanged(QLocalSocket::LocalSocketState)));
}

//  Event QLocalSocket::aboutToClose()
void QLocalSocket_EventAdaptor::aboutToClose() {
BEGIN_PROTECTED
  aboutToClose_e_0();
END_PROTECTED
}

//  Event QLocalSocket::bytesWritten(qint64 bytes)
void QLocalSocket_EventAdaptor::bytesWritten(qint64 bytes) {
BEGIN_PROTECTED
  bytesWritten_e_986(bytes);
END_PROTECTED
}

//  Event QLocalSocket::connected()
void QLocalSocket_EventAdaptor::connected() {
BEGIN_PROTECTED
  connected_e_0();
END_PROTECTED
}

//  Event QLocalSocket::destroyed(QObject *arg1)
void QLocalSocket_EventAdaptor::destroyed(QObject *arg1) {
BEGIN_PROTECTED
  destroyed_e_1302(arg1);
END_PROTECTED
}

//  Event QLocalSocket::disconnected()
void QLocalSocket_EventAdaptor::disconnected() {
BEGIN_PROTECTED
  disconnected_e_0();
END_PROTECTED
}

//  Event QLocalSocket::error(QLocalSocket::LocalSocketError socketError)
void QLocalSocket_EventAdaptor::error(QLocalSocket::LocalSocketError socketError) {
BEGIN_PROTECTED
  error_e_3371(qt_gsi::CppToQtAdaptor<QLocalSocket::LocalSocketError>(socketError));
END_PROTECTED
}

//  Event QLocalSocket::readChannelFinished()
void QLocalSocket_EventAdaptor::readChannelFinished() {
BEGIN_PROTECTED
  readChannelFinished_e_0();
END_PROTECTED
}

//  Event QLocalSocket::readyRead()
void QLocalSocket_EventAdaptor::readyRead() {
BEGIN_PROTECTED
  readyRead_e_0();
END_PROTECTED
}

//  Event QLocalSocket::stateChanged(QLocalSocket::LocalSocketState socketState)
void QLocalSocket_EventAdaptor::stateChanged(QLocalSocket::LocalSocketState socketState) {
BEGIN_PROTECTED
  stateChanged_e_3362(qt_gsi::CppToQtAdaptor<QLocalSocket::LocalSocketState>(socketState));
END_PROTECTED
}
