
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQIODevice.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQIODevice_EventAdaptor.h"
#include "gsiDeclQIODevice_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QIODevice

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QIODevice::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// bool QIODevice::atEnd()


static void _init_f_atEnd_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_atEnd_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QIODevice *)cls)->atEnd ());
}

static qt_gsi::GenericMethod *_create_f_atEnd_c0 ()
{
  return new qt_gsi::GenericMethod ("atEnd", "@brief Method bool QIODevice::atEnd()\n", true, &_init_f_atEnd_c0, &_call_f_atEnd_c0);
}

// qint64 QIODevice::bytesAvailable()


static void _init_f_bytesAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_bytesAvailable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QIODevice *)cls)->bytesAvailable ());
}

static qt_gsi::GenericMethod *_create_f_bytesAvailable_c0 ()
{
  return new qt_gsi::GenericMethod ("bytesAvailable", "@brief Method qint64 QIODevice::bytesAvailable()\n", true, &_init_f_bytesAvailable_c0, &_call_f_bytesAvailable_c0);
}

// qint64 QIODevice::bytesToWrite()


static void _init_f_bytesToWrite_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_bytesToWrite_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QIODevice *)cls)->bytesToWrite ());
}

static qt_gsi::GenericMethod *_create_f_bytesToWrite_c0 ()
{
  return new qt_gsi::GenericMethod ("bytesToWrite", "@brief Method qint64 QIODevice::bytesToWrite()\n", true, &_init_f_bytesToWrite_c0, &_call_f_bytesToWrite_c0);
}

// bool QIODevice::canReadLine()


static void _init_f_canReadLine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_canReadLine_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QIODevice *)cls)->canReadLine ());
}

static qt_gsi::GenericMethod *_create_f_canReadLine_c0 ()
{
  return new qt_gsi::GenericMethod ("canReadLine", "@brief Method bool QIODevice::canReadLine()\n", true, &_init_f_canReadLine_c0, &_call_f_canReadLine_c0);
}

// void QIODevice::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QIODevice *)cls)->close ();
}

static qt_gsi::GenericMethod *_create_f_close_0 ()
{
  return new qt_gsi::GenericMethod ("close", "@brief Method void QIODevice::close()\n", false, &_init_f_close_0, &_call_f_close_0);
}

// QString QIODevice::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QIODevice *)cls)->errorString ());
}

static qt_gsi::GenericMethod *_create_f_errorString_c0 ()
{
  return new qt_gsi::GenericMethod ("errorString", "@brief Method QString QIODevice::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
}

// bool QIODevice::isOpen()


static void _init_f_isOpen_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isOpen_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QIODevice *)cls)->isOpen ());
}

static qt_gsi::GenericMethod *_create_f_isOpen_c0 ()
{
  return new qt_gsi::GenericMethod ("isOpen?", "@brief Method bool QIODevice::isOpen()\n", true, &_init_f_isOpen_c0, &_call_f_isOpen_c0);
}

// bool QIODevice::isReadable()


static void _init_f_isReadable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isReadable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QIODevice *)cls)->isReadable ());
}

static qt_gsi::GenericMethod *_create_f_isReadable_c0 ()
{
  return new qt_gsi::GenericMethod ("isReadable?", "@brief Method bool QIODevice::isReadable()\n", true, &_init_f_isReadable_c0, &_call_f_isReadable_c0);
}

// bool QIODevice::isSequential()


static void _init_f_isSequential_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSequential_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QIODevice *)cls)->isSequential ());
}

static qt_gsi::GenericMethod *_create_f_isSequential_c0 ()
{
  return new qt_gsi::GenericMethod ("isSequential?", "@brief Method bool QIODevice::isSequential()\n", true, &_init_f_isSequential_c0, &_call_f_isSequential_c0);
}

// bool QIODevice::isTextModeEnabled()


static void _init_f_isTextModeEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isTextModeEnabled_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QIODevice *)cls)->isTextModeEnabled ());
}

static qt_gsi::GenericMethod *_create_f_isTextModeEnabled_c0 ()
{
  return new qt_gsi::GenericMethod ("isTextModeEnabled?|:textModeEnabled", "@brief Method bool QIODevice::isTextModeEnabled()\n", true, &_init_f_isTextModeEnabled_c0, &_call_f_isTextModeEnabled_c0);
}

// bool QIODevice::isWritable()


static void _init_f_isWritable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isWritable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QIODevice *)cls)->isWritable ());
}

static qt_gsi::GenericMethod *_create_f_isWritable_c0 ()
{
  return new qt_gsi::GenericMethod ("isWritable?", "@brief Method bool QIODevice::isWritable()\n", true, &_init_f_isWritable_c0, &_call_f_isWritable_c0);
}

// bool QIODevice::open(QFlags<QIODevice::OpenModeFlag> mode)


static void _init_f_open_3242 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_open_3242 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > ();
  ret.write<bool > ((bool)((QIODevice *)cls)->open (qt_gsi::QtToCppAdaptor<QFlags<QIODevice::OpenModeFlag> >(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_open_3242 ()
{
  return new qt_gsi::GenericMethod ("open", "@brief Method bool QIODevice::open(QFlags<QIODevice::OpenModeFlag> mode)\n", false, &_init_f_open_3242, &_call_f_open_3242);
}

// QFlags<QIODevice::OpenModeFlag> QIODevice::openMode()


static void _init_f_openMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type > ();
}

static void _call_f_openMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type > ((qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QIODevice::OpenModeFlag> >(((QIODevice *)cls)->openMode ()));
}

static qt_gsi::GenericMethod *_create_f_openMode_c0 ()
{
  return new qt_gsi::GenericMethod ("openMode", "@brief Method QFlags<QIODevice::OpenModeFlag> QIODevice::openMode()\n", true, &_init_f_openMode_c0, &_call_f_openMode_c0);
}

// QByteArray QIODevice::peek(qint64 maxlen)


static void _init_f_peek_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maxlen");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_peek_986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  qint64 arg1 = args.read<qint64 > ();
  ret.write<QByteArray > ((QByteArray)((QIODevice *)cls)->peek (arg1));
}

static qt_gsi::GenericMethod *_create_f_peek_986 ()
{
  return new qt_gsi::GenericMethod ("peek", "@brief Method QByteArray QIODevice::peek(qint64 maxlen)\n", false, &_init_f_peek_986, &_call_f_peek_986);
}

// qint64 QIODevice::pos()


static void _init_f_pos_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_pos_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QIODevice *)cls)->pos ());
}

static qt_gsi::GenericMethod *_create_f_pos_c0 ()
{
  return new qt_gsi::GenericMethod ("pos", "@brief Method qint64 QIODevice::pos()\n", true, &_init_f_pos_c0, &_call_f_pos_c0);
}

// bool QIODevice::putChar(char c)


static void _init_f_putChar_850 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<char > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_putChar_850 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  char arg1 = args.read<char > ();
  ret.write<bool > ((bool)((QIODevice *)cls)->putChar (arg1));
}

static qt_gsi::GenericMethod *_create_f_putChar_850 ()
{
  return new qt_gsi::GenericMethod ("putChar", "@brief Method bool QIODevice::putChar(char c)\n", false, &_init_f_putChar_850, &_call_f_putChar_850);
}

// QByteArray QIODevice::read(qint64 maxlen)


static void _init_f_read_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maxlen");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_read_986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  qint64 arg1 = args.read<qint64 > ();
  ret.write<QByteArray > ((QByteArray)((QIODevice *)cls)->read (arg1));
}

static qt_gsi::GenericMethod *_create_f_read_986 ()
{
  return new qt_gsi::GenericMethod ("read", "@brief Method QByteArray QIODevice::read(qint64 maxlen)\n", false, &_init_f_read_986, &_call_f_read_986);
}

// QByteArray QIODevice::readAll()


static void _init_f_readAll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_readAll_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray > ((QByteArray)((QIODevice *)cls)->readAll ());
}

static qt_gsi::GenericMethod *_create_f_readAll_0 ()
{
  return new qt_gsi::GenericMethod ("readAll", "@brief Method QByteArray QIODevice::readAll()\n", false, &_init_f_readAll_0, &_call_f_readAll_0);
}

// QByteArray QIODevice::readLine(qint64 maxlen)


static void _init_f_readLine_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maxlen", true, "0");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_readLine_986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  qint64 arg1 = args ? args.read<qint64 > () : (qint64)(0);
  ret.write<QByteArray > ((QByteArray)((QIODevice *)cls)->readLine (arg1));
}

static qt_gsi::GenericMethod *_create_f_readLine_986 ()
{
  return new qt_gsi::GenericMethod ("readLine", "@brief Method QByteArray QIODevice::readLine(qint64 maxlen)\n", false, &_init_f_readLine_986, &_call_f_readLine_986);
}

// bool QIODevice::reset()


static void _init_f_reset_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_reset_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QIODevice *)cls)->reset ());
}

static qt_gsi::GenericMethod *_create_f_reset_0 ()
{
  return new qt_gsi::GenericMethod ("reset", "@brief Method bool QIODevice::reset()\n", false, &_init_f_reset_0, &_call_f_reset_0);
}

// bool QIODevice::seek(qint64 pos)


static void _init_f_seek_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_seek_986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  qint64 arg1 = args.read<qint64 > ();
  ret.write<bool > ((bool)((QIODevice *)cls)->seek (arg1));
}

static qt_gsi::GenericMethod *_create_f_seek_986 ()
{
  return new qt_gsi::GenericMethod ("seek", "@brief Method bool QIODevice::seek(qint64 pos)\n", false, &_init_f_seek_986, &_call_f_seek_986);
}

// void QIODevice::setTextModeEnabled(bool enabled)


static void _init_f_setTextModeEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextModeEnabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QIODevice *)cls)->setTextModeEnabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setTextModeEnabled_864 ()
{
  return new qt_gsi::GenericMethod ("setTextModeEnabled|textModeEnabled=", "@brief Method void QIODevice::setTextModeEnabled(bool enabled)\n", false, &_init_f_setTextModeEnabled_864, &_call_f_setTextModeEnabled_864);
}

// qint64 QIODevice::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QIODevice *)cls)->size ());
}

static qt_gsi::GenericMethod *_create_f_size_c0 ()
{
  return new qt_gsi::GenericMethod ("size", "@brief Method qint64 QIODevice::size()\n", true, &_init_f_size_c0, &_call_f_size_c0);
}

// void QIODevice::ungetChar(char c)


static void _init_f_ungetChar_850 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<char > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_ungetChar_850 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  char arg1 = args.read<char > ();
  ((QIODevice *)cls)->ungetChar (arg1);
}

static qt_gsi::GenericMethod *_create_f_ungetChar_850 ()
{
  return new qt_gsi::GenericMethod ("ungetChar", "@brief Method void QIODevice::ungetChar(char c)\n", false, &_init_f_ungetChar_850, &_call_f_ungetChar_850);
}

// bool QIODevice::waitForBytesWritten(int msecs)


static void _init_f_waitForBytesWritten_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForBytesWritten_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<bool > ((bool)((QIODevice *)cls)->waitForBytesWritten (arg1));
}

static qt_gsi::GenericMethod *_create_f_waitForBytesWritten_767 ()
{
  return new qt_gsi::GenericMethod ("waitForBytesWritten", "@brief Method bool QIODevice::waitForBytesWritten(int msecs)\n", false, &_init_f_waitForBytesWritten_767, &_call_f_waitForBytesWritten_767);
}

// bool QIODevice::waitForReadyRead(int msecs)


static void _init_f_waitForReadyRead_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForReadyRead_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<bool > ((bool)((QIODevice *)cls)->waitForReadyRead (arg1));
}

static qt_gsi::GenericMethod *_create_f_waitForReadyRead_767 ()
{
  return new qt_gsi::GenericMethod ("waitForReadyRead", "@brief Method bool QIODevice::waitForReadyRead(int msecs)\n", false, &_init_f_waitForReadyRead_767, &_call_f_waitForReadyRead_767);
}

// qint64 QIODevice::write(const char *data, qint64 len)


static void _init_f_write_2609 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("len");
  decl->add_arg<qint64 > (argspec_1);
  decl->set_return<qint64 > ();
}

static void _call_f_write_2609 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  qint64 arg2 = args.read<qint64 > ();
  ret.write<qint64 > ((qint64)((QIODevice *)cls)->write (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_write_2609 ()
{
  return new qt_gsi::GenericMethod ("write", "@brief Method qint64 QIODevice::write(const char *data, qint64 len)\n", false, &_init_f_write_2609, &_call_f_write_2609);
}

// qint64 QIODevice::write(const QByteArray &data)


static void _init_f_write_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<qint64 > ();
}

static void _call_f_write_2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ret.write<qint64 > ((qint64)((QIODevice *)cls)->write (arg1));
}

static qt_gsi::GenericMethod *_create_f_write_2309 ()
{
  return new qt_gsi::GenericMethod ("write", "@brief Method qint64 QIODevice::write(const QByteArray &data)\n", false, &_init_f_write_2309, &_call_f_write_2309);
}

// static QString QIODevice::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QIODevice::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QIODevice::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QIODevice::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QIODevice::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QIODevice::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QIODevice::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QIODevice::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QIODevice::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QIODevice::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QIODevice::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QIODevice::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QIODevice, QIODevice_EventAdaptor> ea_QIODevice;


namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QIODevice> decl_QIODevice (ea_QIODevice, decl_QObject, "QIODevice",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_atEnd_c0 ()) +
  gsi::Methods(_create_f_bytesAvailable_c0 ()) +
  gsi::Methods(_create_f_bytesToWrite_c0 ()) +
  gsi::Methods(_create_f_canReadLine_c0 ()) +
  gsi::Methods(_create_f_close_0 ()) +
  gsi::Methods(_create_f_errorString_c0 ()) +
  gsi::Methods(_create_f_isOpen_c0 ()) +
  gsi::Methods(_create_f_isReadable_c0 ()) +
  gsi::Methods(_create_f_isSequential_c0 ()) +
  gsi::Methods(_create_f_isTextModeEnabled_c0 ()) +
  gsi::Methods(_create_f_isWritable_c0 ()) +
  gsi::Methods(_create_f_open_3242 ()) +
  gsi::Methods(_create_f_openMode_c0 ()) +
  gsi::Methods(_create_f_peek_986 ()) +
  gsi::Methods(_create_f_pos_c0 ()) +
  gsi::Methods(_create_f_putChar_850 ()) +
  gsi::Methods(_create_f_read_986 ()) +
  gsi::Methods(_create_f_readAll_0 ()) +
  gsi::Methods(_create_f_readLine_986 ()) +
  gsi::Methods(_create_f_reset_0 ()) +
  gsi::Methods(_create_f_seek_986 ()) +
  gsi::Methods(_create_f_setTextModeEnabled_864 ()) +
  gsi::Methods(_create_f_size_c0 ()) +
  gsi::Methods(_create_f_ungetChar_850 ()) +
  gsi::Methods(_create_f_waitForBytesWritten_767 ()) +
  gsi::Methods(_create_f_waitForReadyRead_767 ()) +
  gsi::Methods(_create_f_write_2609 ()) +
  gsi::Methods(_create_f_write_2309 ()) +
  qt_gsi::qt_signal<QIODevice, QIODevice_EventAdaptor> ("aboutToClose", &QIODevice_EventAdaptor::aboutToClose_e_0, "@brief Signal declaration for QIODevice::aboutToClose()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QIODevice, QIODevice_EventAdaptor, qint64> ("bytesWritten", &QIODevice_EventAdaptor::bytesWritten_e_986, gsi::arg("bytes"), "@brief Signal declaration for QIODevice::bytesWritten(qint64 bytes)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QIODevice, QIODevice_EventAdaptor, QObject *> ("destroyed", &QIODevice_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QIODevice::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QIODevice, QIODevice_EventAdaptor> ("readChannelFinished", &QIODevice_EventAdaptor::readChannelFinished_e_0, "@brief Signal declaration for QIODevice::readChannelFinished()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QIODevice, QIODevice_EventAdaptor> ("readyRead", &QIODevice_EventAdaptor::readyRead_e_0, "@brief Signal declaration for QIODevice::readyRead()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@qt\n@brief Binding of QIODevice");

}


//  Implementation of the enum wrapper class for QIODevice::OpenModeFlag
namespace qt_gsi
{

static QIODevice_OpenModeFlag_Enum *c_1_QIODevice_OpenModeFlag_Enum () { return new QIODevice_OpenModeFlag_Enum (QIODevice::NotOpen); }
static QIODevice_OpenModeFlag_Enum *c_2_QIODevice_OpenModeFlag_Enum () { return new QIODevice_OpenModeFlag_Enum (QIODevice::ReadOnly); }
static QIODevice_OpenModeFlag_Enum *c_3_QIODevice_OpenModeFlag_Enum () { return new QIODevice_OpenModeFlag_Enum (QIODevice::WriteOnly); }
static QIODevice_OpenModeFlag_Enum *c_4_QIODevice_OpenModeFlag_Enum () { return new QIODevice_OpenModeFlag_Enum (QIODevice::ReadWrite); }
static QIODevice_OpenModeFlag_Enum *c_5_QIODevice_OpenModeFlag_Enum () { return new QIODevice_OpenModeFlag_Enum (QIODevice::Append); }
static QIODevice_OpenModeFlag_Enum *c_6_QIODevice_OpenModeFlag_Enum () { return new QIODevice_OpenModeFlag_Enum (QIODevice::Truncate); }
static QIODevice_OpenModeFlag_Enum *c_7_QIODevice_OpenModeFlag_Enum () { return new QIODevice_OpenModeFlag_Enum (QIODevice::Text); }
static QIODevice_OpenModeFlag_Enum *c_8_QIODevice_OpenModeFlag_Enum () { return new QIODevice_OpenModeFlag_Enum (QIODevice::Unbuffered); }

static gsi::Methods mkdefs_QIODevice_OpenModeFlag () {
  return
    gsi::constant ("NotOpen", &qt_gsi::c_1_QIODevice_OpenModeFlag_Enum, "@brief Enum constant QIODevice::NotOpen") +
    gsi::constant ("ReadOnly", &qt_gsi::c_2_QIODevice_OpenModeFlag_Enum, "@brief Enum constant QIODevice::ReadOnly") +
    gsi::constant ("WriteOnly", &qt_gsi::c_3_QIODevice_OpenModeFlag_Enum, "@brief Enum constant QIODevice::WriteOnly") +
    gsi::constant ("ReadWrite", &qt_gsi::c_4_QIODevice_OpenModeFlag_Enum, "@brief Enum constant QIODevice::ReadWrite") +
    gsi::constant ("Append", &qt_gsi::c_5_QIODevice_OpenModeFlag_Enum, "@brief Enum constant QIODevice::Append") +
    gsi::constant ("Truncate", &qt_gsi::c_6_QIODevice_OpenModeFlag_Enum, "@brief Enum constant QIODevice::Truncate") +
    gsi::constant ("Text", &qt_gsi::c_7_QIODevice_OpenModeFlag_Enum, "@brief Enum constant QIODevice::Text") +
    gsi::constant ("Unbuffered", &qt_gsi::c_8_QIODevice_OpenModeFlag_Enum, "@brief Enum constant QIODevice::Unbuffered");
}

static std::string to_s_QIODevice_OpenModeFlag_Enum (const QIODevice_OpenModeFlag_Enum *e)
{
  if (e->value () == QIODevice::NotOpen) { return tl::sprintf ("NotOpen (%u)", (unsigned int) e->value ()); }
  if (e->value () == QIODevice::ReadOnly) { return tl::sprintf ("ReadOnly (%u)", (unsigned int) e->value ()); }
  if (e->value () == QIODevice::WriteOnly) { return tl::sprintf ("WriteOnly (%u)", (unsigned int) e->value ()); }
  if (e->value () == QIODevice::ReadWrite) { return tl::sprintf ("ReadWrite (%u)", (unsigned int) e->value ()); }
  if (e->value () == QIODevice::Append) { return tl::sprintf ("Append (%u)", (unsigned int) e->value ()); }
  if (e->value () == QIODevice::Truncate) { return tl::sprintf ("Truncate (%u)", (unsigned int) e->value ()); }
  if (e->value () == QIODevice::Text) { return tl::sprintf ("Text (%u)", (unsigned int) e->value ()); }
  if (e->value () == QIODevice::Unbuffered) { return tl::sprintf ("Unbuffered (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QIODevice_OpenModeFlag_Enum (const QIODevice_OpenModeFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static QIODevice_OpenModeFlag_Enum *from_i_QIODevice_OpenModeFlag_Enum (unsigned int i)
{
  return new QIODevice_OpenModeFlag_Enum ((QIODevice::OpenModeFlag) i);
}

static bool equalQIODevice_OpenModeFlag_Enum (const QIODevice_OpenModeFlag_Enum *e, QIODevice_OpenModeFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QIODevice_OpenModeFlag_Enum (const QIODevice_OpenModeFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QIODevice_OpenModeFlag_Enums oropQIODevice_OpenModeFlag_Enums (const QIODevice_OpenModeFlag_Enums *e, const QIODevice_OpenModeFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static QIODevice_OpenModeFlag_Enums andopQIODevice_OpenModeFlag_Enums (const QIODevice_OpenModeFlag_Enums *e, const QIODevice_OpenModeFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static QIODevice_OpenModeFlag_Enums xoropQIODevice_OpenModeFlag_Enums (const QIODevice_OpenModeFlag_Enums *e, const QIODevice_OpenModeFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QIODevice_OpenModeFlag_Enums (const QIODevice_OpenModeFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (QIODevice::NotOpen)) { if (!l.empty ()) l += "|"; l += "NotOpen"; }
  if (e->testFlag (QIODevice::ReadOnly)) { if (!l.empty ()) l += "|"; l += "ReadOnly"; }
  if (e->testFlag (QIODevice::WriteOnly)) { if (!l.empty ()) l += "|"; l += "WriteOnly"; }
  if (e->testFlag (QIODevice::ReadWrite)) { if (!l.empty ()) l += "|"; l += "ReadWrite"; }
  if (e->testFlag (QIODevice::Append)) { if (!l.empty ()) l += "|"; l += "Append"; }
  if (e->testFlag (QIODevice::Truncate)) { if (!l.empty ()) l += "|"; l += "Truncate"; }
  if (e->testFlag (QIODevice::Text)) { if (!l.empty ()) l += "|"; l += "Text"; }
  if (e->testFlag (QIODevice::Unbuffered)) { if (!l.empty ()) l += "|"; l += "Unbuffered"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QIODevice_OpenModeFlag_Enums (const QIODevice_OpenModeFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QIODevice_OpenModeFlag_Enums (const QIODevice_OpenModeFlag_Enums *e, const QIODevice_OpenModeFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QIODevice_OpenModeFlag_Enums> decl_QIODevice_OpenModeFlag_Enums ("QIODevice_QFlags_OpenModeFlag",
  gsi::method_ext ("|", &qt_gsi::oropQIODevice_OpenModeFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQIODevice_OpenModeFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQIODevice_OpenModeFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QIODevice_OpenModeFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QIODevice_OpenModeFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QIODevice_OpenModeFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QIODevice::OpenModeFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QIODevice_OpenModeFlag_Enum> decl_QIODevice_OpenModeFlag_Enum (decl_QIODevice_OpenModeFlag_Enums, "QIODevice_OpenModeFlag",
  qt_gsi::mkdefs_QIODevice_OpenModeFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QIODevice_OpenModeFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QIODevice_OpenModeFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQIODevice_OpenModeFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QIODevice_OpenModeFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QIODevice_OpenModeFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QIODevice::OpenModeFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QIODevice> inject_QIODevice_OpenModeFlag_Enum_in_parent (qt_gsi::mkdefs_QIODevice_OpenModeFlag ());
static gsi::ClassExt<QIODevice> decl_QIODevice_OpenModeFlag_Enum_as_child (decl_QIODevice_OpenModeFlag_Enum, "OpenModeFlag");

}

