
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQFileDialog.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQFileDialog_EventAdaptor.h"
#include "gsiDeclQFileDialog_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QFileDialog

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QFileDialog::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QFileDialog::AcceptMode QFileDialog::acceptMode()


static void _init_f_acceptMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFileDialog::AcceptMode>::target_type > ();
}

static void _call_f_acceptMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFileDialog::AcceptMode>::target_type > ((qt_gsi::Converter<QFileDialog::AcceptMode>::target_type)qt_gsi::CppToQtAdaptor<QFileDialog::AcceptMode>(((QFileDialog *)cls)->acceptMode ()));
}

static qt_gsi::GenericMethod *_create_f_acceptMode_c0 ()
{
  return new qt_gsi::GenericMethod (":acceptMode", "@brief Method QFileDialog::AcceptMode QFileDialog::acceptMode()\n", true, &_init_f_acceptMode_c0, &_call_f_acceptMode_c0);
}

// bool QFileDialog::confirmOverwrite()


static void _init_f_confirmOverwrite_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_confirmOverwrite_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileDialog *)cls)->confirmOverwrite ());
}

static qt_gsi::GenericMethod *_create_f_confirmOverwrite_c0 ()
{
  return new qt_gsi::GenericMethod (":confirmOverwrite", "@brief Method bool QFileDialog::confirmOverwrite()\n", true, &_init_f_confirmOverwrite_c0, &_call_f_confirmOverwrite_c0);
}

// QString QFileDialog::defaultSuffix()


static void _init_f_defaultSuffix_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_defaultSuffix_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFileDialog *)cls)->defaultSuffix ());
}

static qt_gsi::GenericMethod *_create_f_defaultSuffix_c0 ()
{
  return new qt_gsi::GenericMethod (":defaultSuffix", "@brief Method QString QFileDialog::defaultSuffix()\n", true, &_init_f_defaultSuffix_c0, &_call_f_defaultSuffix_c0);
}

// QDir QFileDialog::directory()


static void _init_f_directory_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDir > ();
}

static void _call_f_directory_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDir > ((QDir)((QFileDialog *)cls)->directory ());
}

static qt_gsi::GenericMethod *_create_f_directory_c0 ()
{
  return new qt_gsi::GenericMethod ("directory", "@brief Method QDir QFileDialog::directory()\n", true, &_init_f_directory_c0, &_call_f_directory_c0);
}

// QFileDialog::FileMode QFileDialog::fileMode()


static void _init_f_fileMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFileDialog::FileMode>::target_type > ();
}

static void _call_f_fileMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFileDialog::FileMode>::target_type > ((qt_gsi::Converter<QFileDialog::FileMode>::target_type)qt_gsi::CppToQtAdaptor<QFileDialog::FileMode>(((QFileDialog *)cls)->fileMode ()));
}

static qt_gsi::GenericMethod *_create_f_fileMode_c0 ()
{
  return new qt_gsi::GenericMethod (":fileMode", "@brief Method QFileDialog::FileMode QFileDialog::fileMode()\n", true, &_init_f_fileMode_c0, &_call_f_fileMode_c0);
}

// QFlags<QDir::Filter> QFileDialog::filter()


static void _init_f_filter_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QDir::Filter> >::target_type > ();
}

static void _call_f_filter_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QDir::Filter> >::target_type > ((qt_gsi::Converter<QFlags<QDir::Filter> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QDir::Filter> >(((QFileDialog *)cls)->filter ()));
}

static qt_gsi::GenericMethod *_create_f_filter_c0 ()
{
  return new qt_gsi::GenericMethod ("filter", "@brief Method QFlags<QDir::Filter> QFileDialog::filter()\n", true, &_init_f_filter_c0, &_call_f_filter_c0);
}

// QStringList QFileDialog::filters()


static void _init_f_filters_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_filters_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QFileDialog *)cls)->filters ()));
}

static qt_gsi::GenericMethod *_create_f_filters_c0 ()
{
  return new qt_gsi::GenericMethod (":filters", "@brief Method QStringList QFileDialog::filters()\n", true, &_init_f_filters_c0, &_call_f_filters_c0);
}

// QStringList QFileDialog::history()


static void _init_f_history_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_history_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QFileDialog *)cls)->history ()));
}

static qt_gsi::GenericMethod *_create_f_history_c0 ()
{
  return new qt_gsi::GenericMethod (":history", "@brief Method QStringList QFileDialog::history()\n", true, &_init_f_history_c0, &_call_f_history_c0);
}

// QFileIconProvider *QFileDialog::iconProvider()


static void _init_f_iconProvider_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFileIconProvider * > ();
}

static void _call_f_iconProvider_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QFileIconProvider * > ((QFileIconProvider *)((QFileDialog *)cls)->iconProvider ());
}

static qt_gsi::GenericMethod *_create_f_iconProvider_c0 ()
{
  return new qt_gsi::GenericMethod (":iconProvider", "@brief Method QFileIconProvider *QFileDialog::iconProvider()\n", true, &_init_f_iconProvider_c0, &_call_f_iconProvider_c0);
}

// bool QFileDialog::isNameFilterDetailsVisible()


static void _init_f_isNameFilterDetailsVisible_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNameFilterDetailsVisible_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileDialog *)cls)->isNameFilterDetailsVisible ());
}

static qt_gsi::GenericMethod *_create_f_isNameFilterDetailsVisible_c0 ()
{
  return new qt_gsi::GenericMethod ("isNameFilterDetailsVisible?|:nameFilterDetailsVisible", "@brief Method bool QFileDialog::isNameFilterDetailsVisible()\n", true, &_init_f_isNameFilterDetailsVisible_c0, &_call_f_isNameFilterDetailsVisible_c0);
}

// bool QFileDialog::isReadOnly()


static void _init_f_isReadOnly_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isReadOnly_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileDialog *)cls)->isReadOnly ());
}

static qt_gsi::GenericMethod *_create_f_isReadOnly_c0 ()
{
  return new qt_gsi::GenericMethod ("isReadOnly?|:readOnly", "@brief Method bool QFileDialog::isReadOnly()\n", true, &_init_f_isReadOnly_c0, &_call_f_isReadOnly_c0);
}

// QAbstractItemDelegate *QFileDialog::itemDelegate()


static void _init_f_itemDelegate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractItemDelegate * > ();
}

static void _call_f_itemDelegate_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QAbstractItemDelegate * > ((QAbstractItemDelegate *)((QFileDialog *)cls)->itemDelegate ());
}

static qt_gsi::GenericMethod *_create_f_itemDelegate_c0 ()
{
  return new qt_gsi::GenericMethod (":itemDelegate", "@brief Method QAbstractItemDelegate *QFileDialog::itemDelegate()\n", true, &_init_f_itemDelegate_c0, &_call_f_itemDelegate_c0);
}

// QString QFileDialog::labelText(QFileDialog::DialogLabel label)


static void _init_f_labelText_c2681 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("label");
  decl->add_arg<const qt_gsi::Converter<QFileDialog::DialogLabel>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_labelText_c2681 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFileDialog::DialogLabel>::target_type & arg1 = args.read<const qt_gsi::Converter<QFileDialog::DialogLabel>::target_type & > ();
  ret.write<QString > ((QString)((QFileDialog *)cls)->labelText (qt_gsi::QtToCppAdaptor<QFileDialog::DialogLabel>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_labelText_c2681 ()
{
  return new qt_gsi::GenericMethod ("labelText", "@brief Method QString QFileDialog::labelText(QFileDialog::DialogLabel label)\n", true, &_init_f_labelText_c2681, &_call_f_labelText_c2681);
}

// QStringList QFileDialog::nameFilters()


static void _init_f_nameFilters_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_nameFilters_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QFileDialog *)cls)->nameFilters ()));
}

static qt_gsi::GenericMethod *_create_f_nameFilters_c0 ()
{
  return new qt_gsi::GenericMethod (":nameFilters", "@brief Method QStringList QFileDialog::nameFilters()\n", true, &_init_f_nameFilters_c0, &_call_f_nameFilters_c0);
}

// void QFileDialog::open()


static void _init_f_open_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_open_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFileDialog *)cls)->open ();
}

static qt_gsi::GenericMethod *_create_f_open_0 ()
{
  return new qt_gsi::GenericMethod ("open", "@brief Method void QFileDialog::open()\n", false, &_init_f_open_0, &_call_f_open_0);
}

// void QFileDialog::open(QObject *receiver, const char *member)


static void _init_f_open_2925 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("receiver");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("member");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_open_2925 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  const char *arg2 = args.read<const char * > ();
  ((QFileDialog *)cls)->open (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_open_2925 ()
{
  return new qt_gsi::GenericMethod ("open", "@brief Method void QFileDialog::open(QObject *receiver, const char *member)\n", false, &_init_f_open_2925, &_call_f_open_2925);
}

// QFlags<QFileDialog::Option> QFileDialog::options()


static void _init_f_options_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QFileDialog::Option> >::target_type > ();
}

static void _call_f_options_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QFileDialog::Option> >::target_type > ((qt_gsi::Converter<QFlags<QFileDialog::Option> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QFileDialog::Option> >(((QFileDialog *)cls)->options ()));
}

static qt_gsi::GenericMethod *_create_f_options_c0 ()
{
  return new qt_gsi::GenericMethod (":options", "@brief Method QFlags<QFileDialog::Option> QFileDialog::options()\n", true, &_init_f_options_c0, &_call_f_options_c0);
}

// QAbstractProxyModel *QFileDialog::proxyModel()


static void _init_f_proxyModel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractProxyModel * > ();
}

static void _call_f_proxyModel_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QAbstractProxyModel * > ((QAbstractProxyModel *)((QFileDialog *)cls)->proxyModel ());
}

static qt_gsi::GenericMethod *_create_f_proxyModel_c0 ()
{
  return new qt_gsi::GenericMethod (":proxyModel", "@brief Method QAbstractProxyModel *QFileDialog::proxyModel()\n", true, &_init_f_proxyModel_c0, &_call_f_proxyModel_c0);
}

// bool QFileDialog::resolveSymlinks()


static void _init_f_resolveSymlinks_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_resolveSymlinks_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileDialog *)cls)->resolveSymlinks ());
}

static qt_gsi::GenericMethod *_create_f_resolveSymlinks_c0 ()
{
  return new qt_gsi::GenericMethod (":resolveSymlinks", "@brief Method bool QFileDialog::resolveSymlinks()\n", true, &_init_f_resolveSymlinks_c0, &_call_f_resolveSymlinks_c0);
}

// bool QFileDialog::restoreState(const QByteArray &state)


static void _init_f_restoreState_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_restoreState_2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ret.write<bool > ((bool)((QFileDialog *)cls)->restoreState (arg1));
}

static qt_gsi::GenericMethod *_create_f_restoreState_2309 ()
{
  return new qt_gsi::GenericMethod ("restoreState", "@brief Method bool QFileDialog::restoreState(const QByteArray &state)\n", false, &_init_f_restoreState_2309, &_call_f_restoreState_2309);
}

// QByteArray QFileDialog::saveState()


static void _init_f_saveState_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_saveState_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray > ((QByteArray)((QFileDialog *)cls)->saveState ());
}

static qt_gsi::GenericMethod *_create_f_saveState_c0 ()
{
  return new qt_gsi::GenericMethod ("saveState", "@brief Method QByteArray QFileDialog::saveState()\n", true, &_init_f_saveState_c0, &_call_f_saveState_c0);
}

// void QFileDialog::selectFile(const QString &filename)


static void _init_f_selectFile_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filename");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_selectFile_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QFileDialog *)cls)->selectFile (arg1);
}

static qt_gsi::GenericMethod *_create_f_selectFile_2025 ()
{
  return new qt_gsi::GenericMethod ("selectFile", "@brief Method void QFileDialog::selectFile(const QString &filename)\n", false, &_init_f_selectFile_2025, &_call_f_selectFile_2025);
}

// void QFileDialog::selectFilter(const QString &filter)


static void _init_f_selectFilter_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filter");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_selectFilter_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QFileDialog *)cls)->selectFilter (arg1);
}

static qt_gsi::GenericMethod *_create_f_selectFilter_2025 ()
{
  return new qt_gsi::GenericMethod ("selectFilter", "@brief Method void QFileDialog::selectFilter(const QString &filter)\n", false, &_init_f_selectFilter_2025, &_call_f_selectFilter_2025);
}

// void QFileDialog::selectNameFilter(const QString &filter)


static void _init_f_selectNameFilter_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filter");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_selectNameFilter_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QFileDialog *)cls)->selectNameFilter (arg1);
}

static qt_gsi::GenericMethod *_create_f_selectNameFilter_2025 ()
{
  return new qt_gsi::GenericMethod ("selectNameFilter", "@brief Method void QFileDialog::selectNameFilter(const QString &filter)\n", false, &_init_f_selectNameFilter_2025, &_call_f_selectNameFilter_2025);
}

// QStringList QFileDialog::selectedFiles()


static void _init_f_selectedFiles_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_selectedFiles_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QFileDialog *)cls)->selectedFiles ()));
}

static qt_gsi::GenericMethod *_create_f_selectedFiles_c0 ()
{
  return new qt_gsi::GenericMethod ("selectedFiles", "@brief Method QStringList QFileDialog::selectedFiles()\n", true, &_init_f_selectedFiles_c0, &_call_f_selectedFiles_c0);
}

// QString QFileDialog::selectedFilter()


static void _init_f_selectedFilter_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_selectedFilter_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFileDialog *)cls)->selectedFilter ());
}

static qt_gsi::GenericMethod *_create_f_selectedFilter_c0 ()
{
  return new qt_gsi::GenericMethod ("selectedFilter", "@brief Method QString QFileDialog::selectedFilter()\n", true, &_init_f_selectedFilter_c0, &_call_f_selectedFilter_c0);
}

// QString QFileDialog::selectedNameFilter()


static void _init_f_selectedNameFilter_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_selectedNameFilter_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFileDialog *)cls)->selectedNameFilter ());
}

static qt_gsi::GenericMethod *_create_f_selectedNameFilter_c0 ()
{
  return new qt_gsi::GenericMethod ("selectedNameFilter", "@brief Method QString QFileDialog::selectedNameFilter()\n", true, &_init_f_selectedNameFilter_c0, &_call_f_selectedNameFilter_c0);
}

// void QFileDialog::setAcceptMode(QFileDialog::AcceptMode mode)


static void _init_f_setAcceptMode_2590 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QFileDialog::AcceptMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAcceptMode_2590 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFileDialog::AcceptMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QFileDialog::AcceptMode>::target_type & > ();
  ((QFileDialog *)cls)->setAcceptMode (qt_gsi::QtToCppAdaptor<QFileDialog::AcceptMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setAcceptMode_2590 ()
{
  return new qt_gsi::GenericMethod ("setAcceptMode|acceptMode=", "@brief Method void QFileDialog::setAcceptMode(QFileDialog::AcceptMode mode)\n", false, &_init_f_setAcceptMode_2590, &_call_f_setAcceptMode_2590);
}

// void QFileDialog::setConfirmOverwrite(bool enabled)


static void _init_f_setConfirmOverwrite_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setConfirmOverwrite_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QFileDialog *)cls)->setConfirmOverwrite (arg1);
}

static qt_gsi::GenericMethod *_create_f_setConfirmOverwrite_864 ()
{
  return new qt_gsi::GenericMethod ("setConfirmOverwrite|confirmOverwrite=", "@brief Method void QFileDialog::setConfirmOverwrite(bool enabled)\n", false, &_init_f_setConfirmOverwrite_864, &_call_f_setConfirmOverwrite_864);
}

// void QFileDialog::setDefaultSuffix(const QString &suffix)


static void _init_f_setDefaultSuffix_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("suffix");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultSuffix_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QFileDialog *)cls)->setDefaultSuffix (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDefaultSuffix_2025 ()
{
  return new qt_gsi::GenericMethod ("setDefaultSuffix|defaultSuffix=", "@brief Method void QFileDialog::setDefaultSuffix(const QString &suffix)\n", false, &_init_f_setDefaultSuffix_2025, &_call_f_setDefaultSuffix_2025);
}

// void QFileDialog::setDirectory(const QString &directory)


static void _init_f_setDirectory_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("directory");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDirectory_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QFileDialog *)cls)->setDirectory (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDirectory_2025 ()
{
  return new qt_gsi::GenericMethod ("setDirectory", "@brief Method void QFileDialog::setDirectory(const QString &directory)\n", false, &_init_f_setDirectory_2025, &_call_f_setDirectory_2025);
}

// void QFileDialog::setDirectory(const QDir &directory)


static void _init_f_setDirectory_1681 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("directory");
  decl->add_arg<const QDir & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDirectory_1681 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDir &arg1 = args.read<const QDir & > ();
  ((QFileDialog *)cls)->setDirectory (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDirectory_1681 ()
{
  return new qt_gsi::GenericMethod ("setDirectory", "@brief Method void QFileDialog::setDirectory(const QDir &directory)\n", false, &_init_f_setDirectory_1681, &_call_f_setDirectory_1681);
}

// void QFileDialog::setFileMode(QFileDialog::FileMode mode)


static void _init_f_setFileMode_2382 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QFileDialog::FileMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFileMode_2382 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFileDialog::FileMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QFileDialog::FileMode>::target_type & > ();
  ((QFileDialog *)cls)->setFileMode (qt_gsi::QtToCppAdaptor<QFileDialog::FileMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setFileMode_2382 ()
{
  return new qt_gsi::GenericMethod ("setFileMode|fileMode=", "@brief Method void QFileDialog::setFileMode(QFileDialog::FileMode mode)\n", false, &_init_f_setFileMode_2382, &_call_f_setFileMode_2382);
}

// void QFileDialog::setFilter(const QString &filter)


static void _init_f_setFilter_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filter");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFilter_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QFileDialog *)cls)->setFilter (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFilter_2025 ()
{
  return new qt_gsi::GenericMethod ("setFilter", "@brief Method void QFileDialog::setFilter(const QString &filter)\n", false, &_init_f_setFilter_2025, &_call_f_setFilter_2025);
}

// void QFileDialog::setFilter(QFlags<QDir::Filter> filters)


static void _init_f_setFilter_2230 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filters");
  decl->add_arg<const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFilter_2230 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & > ();
  ((QFileDialog *)cls)->setFilter (qt_gsi::QtToCppAdaptor<QFlags<QDir::Filter> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setFilter_2230 ()
{
  return new qt_gsi::GenericMethod ("setFilter", "@brief Method void QFileDialog::setFilter(QFlags<QDir::Filter> filters)\n", false, &_init_f_setFilter_2230, &_call_f_setFilter_2230);
}

// void QFileDialog::setFilters(const QStringList &filters)


static void _init_f_setFilters_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filters");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFilters_2437 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStringList>::target_type & arg1 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  ((QFileDialog *)cls)->setFilters (qt_gsi::QtToCppAdaptor<QStringList>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setFilters_2437 ()
{
  return new qt_gsi::GenericMethod ("setFilters|filters=", "@brief Method void QFileDialog::setFilters(const QStringList &filters)\n", false, &_init_f_setFilters_2437, &_call_f_setFilters_2437);
}

// void QFileDialog::setHistory(const QStringList &paths)


static void _init_f_setHistory_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("paths");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHistory_2437 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStringList>::target_type & arg1 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  ((QFileDialog *)cls)->setHistory (qt_gsi::QtToCppAdaptor<QStringList>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setHistory_2437 ()
{
  return new qt_gsi::GenericMethod ("setHistory|history=", "@brief Method void QFileDialog::setHistory(const QStringList &paths)\n", false, &_init_f_setHistory_2437, &_call_f_setHistory_2437);
}

// void QFileDialog::setIconProvider(QFileIconProvider *provider)


static void _init_f_setIconProvider_2323 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("provider");
  decl->add_arg<QFileIconProvider * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIconProvider_2323 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFileIconProvider *arg1 = args.read<QFileIconProvider * > ();
  ((QFileDialog *)cls)->setIconProvider (arg1);
}

static qt_gsi::GenericMethod *_create_f_setIconProvider_2323 ()
{
  return new qt_gsi::GenericMethod ("setIconProvider|iconProvider=", "@brief Method void QFileDialog::setIconProvider(QFileIconProvider *provider)\n", false, &_init_f_setIconProvider_2323, &_call_f_setIconProvider_2323);
}

// void QFileDialog::setItemDelegate(QAbstractItemDelegate *delegate)


static void _init_f_setItemDelegate_2717 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("delegate");
  decl->add_arg<QAbstractItemDelegate * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setItemDelegate_2717 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractItemDelegate *arg1 = args.read<QAbstractItemDelegate * > ();
  ((QFileDialog *)cls)->setItemDelegate (arg1);
}

static qt_gsi::GenericMethod *_create_f_setItemDelegate_2717 ()
{
  return new qt_gsi::GenericMethod ("setItemDelegate|itemDelegate=", "@brief Method void QFileDialog::setItemDelegate(QAbstractItemDelegate *delegate)\n", false, &_init_f_setItemDelegate_2717, &_call_f_setItemDelegate_2717);
}

// void QFileDialog::setLabelText(QFileDialog::DialogLabel label, const QString &text)


static void _init_f_setLabelText_4598 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("label");
  decl->add_arg<const qt_gsi::Converter<QFileDialog::DialogLabel>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setLabelText_4598 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFileDialog::DialogLabel>::target_type & arg1 = args.read<const qt_gsi::Converter<QFileDialog::DialogLabel>::target_type & > ();
  const QString &arg2 = args.read<const QString & > ();
  ((QFileDialog *)cls)->setLabelText (qt_gsi::QtToCppAdaptor<QFileDialog::DialogLabel>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setLabelText_4598 ()
{
  return new qt_gsi::GenericMethod ("setLabelText", "@brief Method void QFileDialog::setLabelText(QFileDialog::DialogLabel label, const QString &text)\n", false, &_init_f_setLabelText_4598, &_call_f_setLabelText_4598);
}

// void QFileDialog::setNameFilter(const QString &filter)


static void _init_f_setNameFilter_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filter");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNameFilter_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QFileDialog *)cls)->setNameFilter (arg1);
}

static qt_gsi::GenericMethod *_create_f_setNameFilter_2025 ()
{
  return new qt_gsi::GenericMethod ("setNameFilter", "@brief Method void QFileDialog::setNameFilter(const QString &filter)\n", false, &_init_f_setNameFilter_2025, &_call_f_setNameFilter_2025);
}

// void QFileDialog::setNameFilterDetailsVisible(bool enabled)


static void _init_f_setNameFilterDetailsVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNameFilterDetailsVisible_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QFileDialog *)cls)->setNameFilterDetailsVisible (arg1);
}

static qt_gsi::GenericMethod *_create_f_setNameFilterDetailsVisible_864 ()
{
  return new qt_gsi::GenericMethod ("setNameFilterDetailsVisible|nameFilterDetailsVisible=", "@brief Method void QFileDialog::setNameFilterDetailsVisible(bool enabled)\n", false, &_init_f_setNameFilterDetailsVisible_864, &_call_f_setNameFilterDetailsVisible_864);
}

// void QFileDialog::setNameFilters(const QStringList &filters)


static void _init_f_setNameFilters_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filters");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNameFilters_2437 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStringList>::target_type & arg1 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  ((QFileDialog *)cls)->setNameFilters (qt_gsi::QtToCppAdaptor<QStringList>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setNameFilters_2437 ()
{
  return new qt_gsi::GenericMethod ("setNameFilters|nameFilters=", "@brief Method void QFileDialog::setNameFilters(const QStringList &filters)\n", false, &_init_f_setNameFilters_2437, &_call_f_setNameFilters_2437);
}

// void QFileDialog::setOption(QFileDialog::Option option, bool on)


static void _init_f_setOption_2998 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QFileDialog::Option>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("on", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setOption_2998 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFileDialog::Option>::target_type & arg1 = args.read<const qt_gsi::Converter<QFileDialog::Option>::target_type & > ();
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QFileDialog *)cls)->setOption (qt_gsi::QtToCppAdaptor<QFileDialog::Option>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setOption_2998 ()
{
  return new qt_gsi::GenericMethod ("setOption", "@brief Method void QFileDialog::setOption(QFileDialog::Option option, bool on)\n", false, &_init_f_setOption_2998, &_call_f_setOption_2998);
}

// void QFileDialog::setOptions(QFlags<QFileDialog::Option> options)


static void _init_f_setOptions_2938 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options");
  decl->add_arg<const qt_gsi::Converter<QFlags<QFileDialog::Option> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOptions_2938 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QFileDialog::Option> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QFileDialog::Option> >::target_type & > ();
  ((QFileDialog *)cls)->setOptions (qt_gsi::QtToCppAdaptor<QFlags<QFileDialog::Option> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setOptions_2938 ()
{
  return new qt_gsi::GenericMethod ("setOptions|options=", "@brief Method void QFileDialog::setOptions(QFlags<QFileDialog::Option> options)\n", false, &_init_f_setOptions_2938, &_call_f_setOptions_2938);
}

// void QFileDialog::setProxyModel(QAbstractProxyModel *model)


static void _init_f_setProxyModel_2566 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model");
  decl->add_arg<QAbstractProxyModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setProxyModel_2566 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractProxyModel *arg1 = args.read<QAbstractProxyModel * > ();
  ((QFileDialog *)cls)->setProxyModel (arg1);
}

static qt_gsi::GenericMethod *_create_f_setProxyModel_2566 ()
{
  return new qt_gsi::GenericMethod ("setProxyModel|proxyModel=", "@brief Method void QFileDialog::setProxyModel(QAbstractProxyModel *model)\n", false, &_init_f_setProxyModel_2566, &_call_f_setProxyModel_2566);
}

// void QFileDialog::setReadOnly(bool enabled)


static void _init_f_setReadOnly_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setReadOnly_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QFileDialog *)cls)->setReadOnly (arg1);
}

static qt_gsi::GenericMethod *_create_f_setReadOnly_864 ()
{
  return new qt_gsi::GenericMethod ("setReadOnly|readOnly=", "@brief Method void QFileDialog::setReadOnly(bool enabled)\n", false, &_init_f_setReadOnly_864, &_call_f_setReadOnly_864);
}

// void QFileDialog::setResolveSymlinks(bool enabled)


static void _init_f_setResolveSymlinks_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setResolveSymlinks_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QFileDialog *)cls)->setResolveSymlinks (arg1);
}

static qt_gsi::GenericMethod *_create_f_setResolveSymlinks_864 ()
{
  return new qt_gsi::GenericMethod ("setResolveSymlinks|resolveSymlinks=", "@brief Method void QFileDialog::setResolveSymlinks(bool enabled)\n", false, &_init_f_setResolveSymlinks_864, &_call_f_setResolveSymlinks_864);
}

// void QFileDialog::setSidebarUrls(const QList<QUrl> &urls)


static void _init_f_setSidebarUrls_2316 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("urls");
  decl->add_arg<const qt_gsi::Converter<QList<QUrl> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSidebarUrls_2316 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QUrl> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QUrl> >::target_type & > ();
  ((QFileDialog *)cls)->setSidebarUrls (qt_gsi::QtToCppAdaptor<QList<QUrl> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setSidebarUrls_2316 ()
{
  return new qt_gsi::GenericMethod ("setSidebarUrls|sidebarUrls=", "@brief Method void QFileDialog::setSidebarUrls(const QList<QUrl> &urls)\n", false, &_init_f_setSidebarUrls_2316, &_call_f_setSidebarUrls_2316);
}

// void QFileDialog::setViewMode(QFileDialog::ViewMode mode)


static void _init_f_setViewMode_2409 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QFileDialog::ViewMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setViewMode_2409 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFileDialog::ViewMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QFileDialog::ViewMode>::target_type & > ();
  ((QFileDialog *)cls)->setViewMode (qt_gsi::QtToCppAdaptor<QFileDialog::ViewMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setViewMode_2409 ()
{
  return new qt_gsi::GenericMethod ("setViewMode|viewMode=", "@brief Method void QFileDialog::setViewMode(QFileDialog::ViewMode mode)\n", false, &_init_f_setViewMode_2409, &_call_f_setViewMode_2409);
}

// void QFileDialog::setVisible(bool visible)


static void _init_f_setVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVisible_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QFileDialog *)cls)->setVisible (arg1);
}

static qt_gsi::GenericMethod *_create_f_setVisible_864 ()
{
  return new qt_gsi::GenericMethod ("setVisible|visible=", "@brief Method void QFileDialog::setVisible(bool visible)\nThis is a reimplementation of QDialog::setVisible", false, &_init_f_setVisible_864, &_call_f_setVisible_864);
}

// QList<QUrl> QFileDialog::sidebarUrls()


static void _init_f_sidebarUrls_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QUrl> >::target_type > ();
}

static void _call_f_sidebarUrls_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QUrl> >::target_type > ((qt_gsi::Converter<QList<QUrl> >::target_type)qt_gsi::CppToQtAdaptor<QList<QUrl> >(((QFileDialog *)cls)->sidebarUrls ()));
}

static qt_gsi::GenericMethod *_create_f_sidebarUrls_c0 ()
{
  return new qt_gsi::GenericMethod (":sidebarUrls", "@brief Method QList<QUrl> QFileDialog::sidebarUrls()\n", true, &_init_f_sidebarUrls_c0, &_call_f_sidebarUrls_c0);
}

// bool QFileDialog::testOption(QFileDialog::Option option)


static void _init_f_testOption_c2242 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QFileDialog::Option>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_testOption_c2242 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFileDialog::Option>::target_type & arg1 = args.read<const qt_gsi::Converter<QFileDialog::Option>::target_type & > ();
  ret.write<bool > ((bool)((QFileDialog *)cls)->testOption (qt_gsi::QtToCppAdaptor<QFileDialog::Option>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_testOption_c2242 ()
{
  return new qt_gsi::GenericMethod ("testOption", "@brief Method bool QFileDialog::testOption(QFileDialog::Option option)\n", true, &_init_f_testOption_c2242, &_call_f_testOption_c2242);
}

// QFileDialog::ViewMode QFileDialog::viewMode()


static void _init_f_viewMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFileDialog::ViewMode>::target_type > ();
}

static void _call_f_viewMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFileDialog::ViewMode>::target_type > ((qt_gsi::Converter<QFileDialog::ViewMode>::target_type)qt_gsi::CppToQtAdaptor<QFileDialog::ViewMode>(((QFileDialog *)cls)->viewMode ()));
}

static qt_gsi::GenericMethod *_create_f_viewMode_c0 ()
{
  return new qt_gsi::GenericMethod (":viewMode", "@brief Method QFileDialog::ViewMode QFileDialog::viewMode()\n", true, &_init_f_viewMode_c0, &_call_f_viewMode_c0);
}

// static QString QFileDialog::getExistingDirectory(QWidget *parent, const QString &caption, const QString &dir, QFlags<QFileDialog::Option> options)


static void _init_f_getExistingDirectory_7979 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("caption", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("dir", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("options", true, "QFileDialog::ShowDirsOnly");
  decl->add_arg<const qt_gsi::Converter<QFlags<QFileDialog::Option> >::target_type & > (argspec_3);
  decl->set_return<QString > ();
}

static void _call_f_getExistingDirectory_7979 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  const QString &arg2 = args ? args.read<const QString & > () : (const QString &)(QString());
  const QString &arg3 = args ? args.read<const QString & > () : (const QString &)(QString());
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QFileDialog::Option> >::target_type & arg4 = args ? args.read<const qt_gsi::Converter<QFlags<QFileDialog::Option> >::target_type & > () : (const qt_gsi::Converter<QFlags<QFileDialog::Option> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QFileDialog::Option> >(heap, QFileDialog::ShowDirsOnly));
  ret.write<QString > ((QString)QFileDialog::getExistingDirectory (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QFlags<QFileDialog::Option> >(arg4).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_getExistingDirectory_7979 ()
{
  return new qt_gsi::GenericStaticMethod ("getExistingDirectory", "@brief Static method QString QFileDialog::getExistingDirectory(QWidget *parent, const QString &caption, const QString &dir, QFlags<QFileDialog::Option> options)\nThis method is static and can be called without an instance.", &_init_f_getExistingDirectory_7979, &_call_f_getExistingDirectory_7979);
}

// static QString QFileDialog::getOpenFileName(QWidget *parent, const QString &caption, const QString &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options)


static void _init_f_getOpenFileName_11122 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("caption", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("dir", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("filter", true, "QString()");
  decl->add_arg<const QString & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("selectedFilter", true, "0");
  decl->add_arg<QString * > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("options", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<QFileDialog::Option> >::target_type & > (argspec_5);
  decl->set_return<QString > ();
}

static void _call_f_getOpenFileName_11122 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  const QString &arg2 = args ? args.read<const QString & > () : (const QString &)(QString());
  const QString &arg3 = args ? args.read<const QString & > () : (const QString &)(QString());
  const QString &arg4 = args ? args.read<const QString & > () : (const QString &)(QString());
  QString *arg5 = args ? args.read<QString * > () : (QString *)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QFileDialog::Option> >::target_type & arg6 = args ? args.read<const qt_gsi::Converter<QFlags<QFileDialog::Option> >::target_type & > () : (const qt_gsi::Converter<QFlags<QFileDialog::Option> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QFileDialog::Option> >(heap, 0));
  ret.write<QString > ((QString)QFileDialog::getOpenFileName (arg1, arg2, arg3, arg4, arg5, qt_gsi::QtToCppAdaptor<QFlags<QFileDialog::Option> >(arg6).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_getOpenFileName_11122 ()
{
  return new qt_gsi::GenericStaticMethod ("getOpenFileName", "@brief Static method QString QFileDialog::getOpenFileName(QWidget *parent, const QString &caption, const QString &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options)\nThis method is static and can be called without an instance.", &_init_f_getOpenFileName_11122, &_call_f_getOpenFileName_11122);
}

// static QStringList QFileDialog::getOpenFileNames(QWidget *parent, const QString &caption, const QString &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options)


static void _init_f_getOpenFileNames_11122 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("caption", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("dir", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("filter", true, "QString()");
  decl->add_arg<const QString & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("selectedFilter", true, "0");
  decl->add_arg<QString * > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("options", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<QFileDialog::Option> >::target_type & > (argspec_5);
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_getOpenFileNames_11122 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  const QString &arg2 = args ? args.read<const QString & > () : (const QString &)(QString());
  const QString &arg3 = args ? args.read<const QString & > () : (const QString &)(QString());
  const QString &arg4 = args ? args.read<const QString & > () : (const QString &)(QString());
  QString *arg5 = args ? args.read<QString * > () : (QString *)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QFileDialog::Option> >::target_type & arg6 = args ? args.read<const qt_gsi::Converter<QFlags<QFileDialog::Option> >::target_type & > () : (const qt_gsi::Converter<QFlags<QFileDialog::Option> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QFileDialog::Option> >(heap, 0));
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(QFileDialog::getOpenFileNames (arg1, arg2, arg3, arg4, arg5, qt_gsi::QtToCppAdaptor<QFlags<QFileDialog::Option> >(arg6).cref())));
}

static qt_gsi::GenericStaticMethod *_create_f_getOpenFileNames_11122 ()
{
  return new qt_gsi::GenericStaticMethod ("getOpenFileNames", "@brief Static method QStringList QFileDialog::getOpenFileNames(QWidget *parent, const QString &caption, const QString &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options)\nThis method is static and can be called without an instance.", &_init_f_getOpenFileNames_11122, &_call_f_getOpenFileNames_11122);
}

// static QString QFileDialog::getSaveFileName(QWidget *parent, const QString &caption, const QString &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options)


static void _init_f_getSaveFileName_11122 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("caption", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("dir", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("filter", true, "QString()");
  decl->add_arg<const QString & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("selectedFilter", true, "0");
  decl->add_arg<QString * > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("options", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<QFileDialog::Option> >::target_type & > (argspec_5);
  decl->set_return<QString > ();
}

static void _call_f_getSaveFileName_11122 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  const QString &arg2 = args ? args.read<const QString & > () : (const QString &)(QString());
  const QString &arg3 = args ? args.read<const QString & > () : (const QString &)(QString());
  const QString &arg4 = args ? args.read<const QString & > () : (const QString &)(QString());
  QString *arg5 = args ? args.read<QString * > () : (QString *)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QFileDialog::Option> >::target_type & arg6 = args ? args.read<const qt_gsi::Converter<QFlags<QFileDialog::Option> >::target_type & > () : (const qt_gsi::Converter<QFlags<QFileDialog::Option> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QFileDialog::Option> >(heap, 0));
  ret.write<QString > ((QString)QFileDialog::getSaveFileName (arg1, arg2, arg3, arg4, arg5, qt_gsi::QtToCppAdaptor<QFlags<QFileDialog::Option> >(arg6).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_getSaveFileName_11122 ()
{
  return new qt_gsi::GenericStaticMethod ("getSaveFileName", "@brief Static method QString QFileDialog::getSaveFileName(QWidget *parent, const QString &caption, const QString &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options)\nThis method is static and can be called without an instance.", &_init_f_getSaveFileName_11122, &_call_f_getSaveFileName_11122);
}

// static QString QFileDialog::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QFileDialog::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QFileDialog::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QFileDialog::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QFileDialog::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QFileDialog::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QFileDialog::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QFileDialog::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QFileDialog::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QFileDialog::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QFileDialog::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QFileDialog::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QFileDialog, QFileDialog_EventAdaptor> ea_QFileDialog;

namespace gsi
{
extern gsi::Class<QDialog> decl_QDialog;

gsi::Class<QFileDialog> decl_QFileDialog (ea_QFileDialog, decl_QDialog, "QFileDialog_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_acceptMode_c0 ()) +
  gsi::Methods(_create_f_confirmOverwrite_c0 ()) +
  gsi::Methods(_create_f_defaultSuffix_c0 ()) +
  gsi::Methods(_create_f_directory_c0 ()) +
  gsi::Methods(_create_f_fileMode_c0 ()) +
  gsi::Methods(_create_f_filter_c0 ()) +
  gsi::Methods(_create_f_filters_c0 ()) +
  gsi::Methods(_create_f_history_c0 ()) +
  gsi::Methods(_create_f_iconProvider_c0 ()) +
  gsi::Methods(_create_f_isNameFilterDetailsVisible_c0 ()) +
  gsi::Methods(_create_f_isReadOnly_c0 ()) +
  gsi::Methods(_create_f_itemDelegate_c0 ()) +
  gsi::Methods(_create_f_labelText_c2681 ()) +
  gsi::Methods(_create_f_nameFilters_c0 ()) +
  gsi::Methods(_create_f_open_0 ()) +
  gsi::Methods(_create_f_open_2925 ()) +
  gsi::Methods(_create_f_options_c0 ()) +
  gsi::Methods(_create_f_proxyModel_c0 ()) +
  gsi::Methods(_create_f_resolveSymlinks_c0 ()) +
  gsi::Methods(_create_f_restoreState_2309 ()) +
  gsi::Methods(_create_f_saveState_c0 ()) +
  gsi::Methods(_create_f_selectFile_2025 ()) +
  gsi::Methods(_create_f_selectFilter_2025 ()) +
  gsi::Methods(_create_f_selectNameFilter_2025 ()) +
  gsi::Methods(_create_f_selectedFiles_c0 ()) +
  gsi::Methods(_create_f_selectedFilter_c0 ()) +
  gsi::Methods(_create_f_selectedNameFilter_c0 ()) +
  gsi::Methods(_create_f_setAcceptMode_2590 ()) +
  gsi::Methods(_create_f_setConfirmOverwrite_864 ()) +
  gsi::Methods(_create_f_setDefaultSuffix_2025 ()) +
  gsi::Methods(_create_f_setDirectory_2025 ()) +
  gsi::Methods(_create_f_setDirectory_1681 ()) +
  gsi::Methods(_create_f_setFileMode_2382 ()) +
  gsi::Methods(_create_f_setFilter_2025 ()) +
  gsi::Methods(_create_f_setFilter_2230 ()) +
  gsi::Methods(_create_f_setFilters_2437 ()) +
  gsi::Methods(_create_f_setHistory_2437 ()) +
  gsi::Methods(_create_f_setIconProvider_2323 ()) +
  gsi::Methods(_create_f_setItemDelegate_2717 ()) +
  gsi::Methods(_create_f_setLabelText_4598 ()) +
  gsi::Methods(_create_f_setNameFilter_2025 ()) +
  gsi::Methods(_create_f_setNameFilterDetailsVisible_864 ()) +
  gsi::Methods(_create_f_setNameFilters_2437 ()) +
  gsi::Methods(_create_f_setOption_2998 ()) +
  gsi::Methods(_create_f_setOptions_2938 ()) +
  gsi::Methods(_create_f_setProxyModel_2566 ()) +
  gsi::Methods(_create_f_setReadOnly_864 ()) +
  gsi::Methods(_create_f_setResolveSymlinks_864 ()) +
  gsi::Methods(_create_f_setSidebarUrls_2316 ()) +
  gsi::Methods(_create_f_setViewMode_2409 ()) +
  gsi::Methods(_create_f_setVisible_864 ()) +
  gsi::Methods(_create_f_sidebarUrls_c0 ()) +
  gsi::Methods(_create_f_testOption_c2242 ()) +
  gsi::Methods(_create_f_viewMode_c0 ()) +
  qt_gsi::qt_signal<QFileDialog, QFileDialog_EventAdaptor> ("accepted", &QFileDialog_EventAdaptor::accepted_e_0, "@brief Signal declaration for QFileDialog::accepted()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFileDialog, QFileDialog_EventAdaptor, const QString &> ("currentChanged", &QFileDialog_EventAdaptor::currentChanged_e_2025, gsi::arg("path"), "@brief Signal declaration for QFileDialog::currentChanged(const QString &path)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFileDialog, QFileDialog_EventAdaptor, const QPoint &> ("customContextMenuRequested", &QFileDialog_EventAdaptor::customContextMenuRequested_e_1916, gsi::arg("pos"), "@brief Signal declaration for QFileDialog::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFileDialog, QFileDialog_EventAdaptor, QObject *> ("destroyed", &QFileDialog_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QFileDialog::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFileDialog, QFileDialog_EventAdaptor, const QString &> ("directoryEntered", &QFileDialog_EventAdaptor::directoryEntered_e_2025, gsi::arg("directory"), "@brief Signal declaration for QFileDialog::directoryEntered(const QString &directory)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFileDialog, QFileDialog_EventAdaptor, const QString &> ("fileSelected", &QFileDialog_EventAdaptor::fileSelected_e_2025, gsi::arg("file"), "@brief Signal declaration for QFileDialog::fileSelected(const QString &file)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFileDialog, QFileDialog_EventAdaptor, const qt_gsi::Converter<QStringList>::target_type &> ("filesSelected", &QFileDialog_EventAdaptor::filesSelected_e_2437, gsi::arg("files"), "@brief Signal declaration for QFileDialog::filesSelected(const QStringList &files)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFileDialog, QFileDialog_EventAdaptor, const QString &> ("filterSelected", &QFileDialog_EventAdaptor::filterSelected_e_2025, gsi::arg("filter"), "@brief Signal declaration for QFileDialog::filterSelected(const QString &filter)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFileDialog, QFileDialog_EventAdaptor, int> ("finished", &QFileDialog_EventAdaptor::finished_e_767, gsi::arg("result"), "@brief Signal declaration for QFileDialog::finished(int result)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFileDialog, QFileDialog_EventAdaptor> ("rejected", &QFileDialog_EventAdaptor::rejected_e_0, "@brief Signal declaration for QFileDialog::rejected()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_getExistingDirectory_7979 ()) +
  gsi::Methods(_create_f_getOpenFileName_11122 ()) +
  gsi::Methods(_create_f_getOpenFileNames_11122 ()) +
  gsi::Methods(_create_f_getSaveFileName_11122 ()) +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QFileDialog");
}


class QFileDialog_Adaptor : public QFileDialog, public qt_gsi::QtObjectBase
{
public:

  virtual ~QFileDialog_Adaptor();

  //  [adaptor ctor] QFileDialog::QFileDialog(QWidget *parent, QFlags<Qt::WindowType> f)
  QFileDialog_Adaptor(QWidget *parent, QFlags<Qt::WindowType> f) : QFileDialog(parent, f)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QFileDialog::QFileDialog(QWidget *parent, const QString &caption, const QString &directory, const QString &filter)
  QFileDialog_Adaptor() : QFileDialog()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QFileDialog::QFileDialog(QWidget *parent, const QString &caption, const QString &directory, const QString &filter)
  QFileDialog_Adaptor(QWidget *parent) : QFileDialog(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QFileDialog::QFileDialog(QWidget *parent, const QString &caption, const QString &directory, const QString &filter)
  QFileDialog_Adaptor(QWidget *parent, const QString &caption) : QFileDialog(parent, caption)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QFileDialog::QFileDialog(QWidget *parent, const QString &caption, const QString &directory, const QString &filter)
  QFileDialog_Adaptor(QWidget *parent, const QString &caption, const QString &directory) : QFileDialog(parent, caption, directory)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QFileDialog::QFileDialog(QWidget *parent, const QString &caption, const QString &directory, const QString &filter)
  QFileDialog_Adaptor(QWidget *parent, const QString &caption, const QString &directory, const QString &filter) : QFileDialog(parent, caption, directory, filter)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QFileDialog::adjustPosition(QWidget *)
  void fp_QFileDialog_adjustPosition_1315 (QWidget *arg1) {
    QFileDialog::adjustPosition(arg1);
  }

  //  void QFileDialog::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QFileDialog_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QFileDialog::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  void QFileDialog::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QFileDialog_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QFileDialog::destroy(destroyWindow, destroySubWindows);
  }

  //  bool QFileDialog::focusNextChild()
  bool fp_QFileDialog_focusNextChild_0 () {
    return QFileDialog::focusNextChild();
  }

  //  bool QFileDialog::focusPreviousChild()
  bool fp_QFileDialog_focusPreviousChild_0 () {
    return QFileDialog::focusPreviousChild();
  }

  //  int QFileDialog::receivers(const char *signal)
  int fp_QFileDialog_receivers_c1731 (const char *signal) const {
    return QFileDialog::receivers(signal);
  }

  //  void QFileDialog::resetInputContext()
  void fp_QFileDialog_resetInputContext_0 () {
    QFileDialog::resetInputContext();
  }

  //  QObject *QFileDialog::sender()
  QObject * fp_QFileDialog_sender_c0 () const {
    return QFileDialog::sender();
  }

  //  void QFileDialog::updateMicroFocus()
  void fp_QFileDialog_updateMicroFocus_0 () {
    QFileDialog::updateMicroFocus();
  }

  //  [adaptor impl] int QFileDialog::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QFileDialog::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QFileDialog_Adaptor, int, int>(&QFileDialog_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QFileDialog::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QFileDialog::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QFileDialog::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QFileDialog_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QFileDialog_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QFileDialog::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QFileDialog::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QFileDialog::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QFileDialog_Adaptor, QSize>(&QFileDialog_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QFileDialog::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QFileDialog::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QFileDialog::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QFileDialog_Adaptor, QPaintEngine *>(&QFileDialog_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QFileDialog::paintEngine();
    }
  }

  //  [adaptor impl] void QFileDialog::reject()
  void cbs_reject_0_0()
  {
    QFileDialog::reject();
  }

  virtual void reject()
  {
    if (cb_reject_0_0.can_issue()) {
      cb_reject_0_0.issue<QFileDialog_Adaptor>(&QFileDialog_Adaptor::cbs_reject_0_0);
    } else {
      QFileDialog::reject();
    }
  }

  //  [adaptor impl] void QFileDialog::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QFileDialog::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QFileDialog_Adaptor, bool>(&QFileDialog_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QFileDialog::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QFileDialog::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QFileDialog::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QFileDialog_Adaptor, QSize>(&QFileDialog_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QFileDialog::sizeHint();
    }
  }

  //  [adaptor impl] void QFileDialog::accept()
  void cbs_accept_0_0()
  {
    QFileDialog::accept();
  }

  virtual void accept()
  {
    if (cb_accept_0_0.can_issue()) {
      cb_accept_0_0.issue<QFileDialog_Adaptor>(&QFileDialog_Adaptor::cbs_accept_0_0);
    } else {
      QFileDialog::accept();
    }
  }

  //  [adaptor impl] void QFileDialog::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QFileDialog::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QFileDialog_Adaptor, QActionEvent *>(&QFileDialog_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QFileDialog::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::changeEvent(QEvent *e)
  void cbs_changeEvent_1217_0(QEvent *e)
  {
    QFileDialog::changeEvent(e);
  }

  virtual void changeEvent(QEvent *e)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QFileDialog_Adaptor, QEvent *>(&QFileDialog_Adaptor::cbs_changeEvent_1217_0, e);
    } else {
      QFileDialog::changeEvent(e);
    }
  }

  //  [adaptor impl] void QFileDialog::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QFileDialog::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QFileDialog_Adaptor, QChildEvent *>(&QFileDialog_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QFileDialog::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QFileDialog::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QFileDialog_Adaptor, QCloseEvent *>(&QFileDialog_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QFileDialog::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QFileDialog::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QFileDialog_Adaptor, QContextMenuEvent *>(&QFileDialog_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QFileDialog::contextMenuEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QFileDialog::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QFileDialog_Adaptor, QEvent *>(&QFileDialog_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QFileDialog::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QFileDialog::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QFileDialog_Adaptor, const char *>(&QFileDialog_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QFileDialog::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QFileDialog::done(int result)
  void cbs_done_767_0(int result)
  {
    QFileDialog::done(result);
  }

  virtual void done(int result)
  {
    if (cb_done_767_0.can_issue()) {
      cb_done_767_0.issue<QFileDialog_Adaptor, int>(&QFileDialog_Adaptor::cbs_done_767_0, result);
    } else {
      QFileDialog::done(result);
    }
  }

  //  [adaptor impl] void QFileDialog::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QFileDialog::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QFileDialog_Adaptor, QDragEnterEvent *>(&QFileDialog_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QFileDialog::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QFileDialog::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QFileDialog_Adaptor, QDragLeaveEvent *>(&QFileDialog_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QFileDialog::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QFileDialog::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QFileDialog_Adaptor, QDragMoveEvent *>(&QFileDialog_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QFileDialog::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QFileDialog::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QFileDialog_Adaptor, QDropEvent *>(&QFileDialog_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QFileDialog::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QFileDialog::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QFileDialog_Adaptor, bool>(&QFileDialog_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QFileDialog::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QFileDialog::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QFileDialog_Adaptor, QEvent *>(&QFileDialog_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QFileDialog::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QFileDialog::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QFileDialog::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QFileDialog_Adaptor, bool, QEvent *>(&QFileDialog_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QFileDialog::event(arg1);
    }
  }

  //  [adaptor impl] bool QFileDialog::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QFileDialog::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QFileDialog_Adaptor, bool, QObject *, QEvent *>(&QFileDialog_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QFileDialog::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QFileDialog::focusInEvent(QFocusEvent *)
  void cbs_focusInEvent_1729_0(QFocusEvent *arg1)
  {
    QFileDialog::focusInEvent(arg1);
  }

  virtual void focusInEvent(QFocusEvent *arg1)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QFileDialog_Adaptor, QFocusEvent *>(&QFileDialog_Adaptor::cbs_focusInEvent_1729_0, arg1);
    } else {
      QFileDialog::focusInEvent(arg1);
    }
  }

  //  [adaptor impl] bool QFileDialog::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QFileDialog::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QFileDialog_Adaptor, bool, bool>(&QFileDialog_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QFileDialog::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QFileDialog::focusOutEvent(QFocusEvent *)
  void cbs_focusOutEvent_1729_0(QFocusEvent *arg1)
  {
    QFileDialog::focusOutEvent(arg1);
  }

  virtual void focusOutEvent(QFocusEvent *arg1)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QFileDialog_Adaptor, QFocusEvent *>(&QFileDialog_Adaptor::cbs_focusOutEvent_1729_0, arg1);
    } else {
      QFileDialog::focusOutEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QFileDialog::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QFileDialog_Adaptor, const QFont &>(&QFileDialog_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QFileDialog::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QFileDialog::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QFileDialog_Adaptor, QHideEvent *>(&QFileDialog_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QFileDialog::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QFileDialog::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QFileDialog_Adaptor, QInputMethodEvent *>(&QFileDialog_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QFileDialog::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QFileDialog::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QFileDialog_Adaptor, QKeyEvent *>(&QFileDialog_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QFileDialog::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QFileDialog::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QFileDialog_Adaptor, QKeyEvent *>(&QFileDialog_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QFileDialog::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::languageChange()
  void cbs_languageChange_0_0()
  {
    QFileDialog::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QFileDialog_Adaptor>(&QFileDialog_Adaptor::cbs_languageChange_0_0);
    } else {
      QFileDialog::languageChange();
    }
  }

  //  [adaptor impl] void QFileDialog::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QFileDialog::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QFileDialog_Adaptor, QEvent *>(&QFileDialog_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QFileDialog::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QFileDialog::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QFileDialog::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QFileDialog_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QFileDialog_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QFileDialog::metric(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QFileDialog::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QFileDialog_Adaptor, QMouseEvent *>(&QFileDialog_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QFileDialog::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QFileDialog::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QFileDialog_Adaptor, QMouseEvent *>(&QFileDialog_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QFileDialog::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QFileDialog::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QFileDialog_Adaptor, QMouseEvent *>(&QFileDialog_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QFileDialog::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QFileDialog::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QFileDialog_Adaptor, QMouseEvent *>(&QFileDialog_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QFileDialog::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QFileDialog::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QFileDialog_Adaptor, QMoveEvent *>(&QFileDialog_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QFileDialog::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::paintEvent(QPaintEvent *)
  void cbs_paintEvent_1725_0(QPaintEvent *arg1)
  {
    QFileDialog::paintEvent(arg1);
  }

  virtual void paintEvent(QPaintEvent *arg1)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QFileDialog_Adaptor, QPaintEvent *>(&QFileDialog_Adaptor::cbs_paintEvent_1725_0, arg1);
    } else {
      QFileDialog::paintEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QFileDialog::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QFileDialog_Adaptor, const QPalette &>(&QFileDialog_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QFileDialog::paletteChange(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::resizeEvent(QResizeEvent *)
  void cbs_resizeEvent_1843_0(QResizeEvent *arg1)
  {
    QFileDialog::resizeEvent(arg1);
  }

  virtual void resizeEvent(QResizeEvent *arg1)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QFileDialog_Adaptor, QResizeEvent *>(&QFileDialog_Adaptor::cbs_resizeEvent_1843_0, arg1);
    } else {
      QFileDialog::resizeEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QFileDialog::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QFileDialog_Adaptor, QShowEvent *>(&QFileDialog_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QFileDialog::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QFileDialog::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QFileDialog_Adaptor, QStyle &>(&QFileDialog_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QFileDialog::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QFileDialog::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QFileDialog_Adaptor, QTabletEvent *>(&QFileDialog_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QFileDialog::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QFileDialog::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QFileDialog_Adaptor, QTimerEvent *>(&QFileDialog_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QFileDialog::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QFileDialog::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QFileDialog_Adaptor, QWheelEvent *>(&QFileDialog_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QFileDialog::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QFileDialog::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QFileDialog_Adaptor, bool>(&QFileDialog_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QFileDialog::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_reject_0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_accept_0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_done_767_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QFileDialog_Adaptor::~QFileDialog_Adaptor() { }

//  Constructor QFileDialog::QFileDialog(QWidget *parent, QFlags<Qt::WindowType> f) (adaptor class)

static void _init_ctor_QFileDialog_Adaptor_3702 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("f");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > (argspec_1);
  decl->set_return_new<QFileDialog_Adaptor *> ();
}

static void _call_ctor_QFileDialog_Adaptor_3702 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > ();
  ret.write<QFileDialog_Adaptor *> (new QFileDialog_Adaptor (arg1, qt_gsi::QtToCppAdaptor<QFlags<Qt::WindowType> >(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QFileDialog_Adaptor_3702 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFileDialog::QFileDialog(QWidget *parent, QFlags<Qt::WindowType> f)\nThis method creates an object of class QFileDialog.", &_init_ctor_QFileDialog_Adaptor_3702, &_call_ctor_QFileDialog_Adaptor_3702);
}

//  Constructor QFileDialog::QFileDialog(QWidget *parent, const QString &caption, const QString &directory, const QString &filter) (adaptor class)

static void _init_ctor_QFileDialog_Adaptor_7066 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("caption", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("directory", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("filter", true, "QString()");
  decl->add_arg<const QString & > (argspec_3);
  decl->set_return_new<QFileDialog_Adaptor *> ();
}

static void _call_ctor_QFileDialog_Adaptor_7066 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  const QString &arg2 = args ? args.read<const QString & > () : (const QString &)(QString());
  const QString &arg3 = args ? args.read<const QString & > () : (const QString &)(QString());
  const QString &arg4 = args ? args.read<const QString & > () : (const QString &)(QString());
  ret.write<QFileDialog_Adaptor *> (new QFileDialog_Adaptor (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QFileDialog_Adaptor_7066 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFileDialog::QFileDialog(QWidget *parent, const QString &caption, const QString &directory, const QString &filter)\nThis method creates an object of class QFileDialog.", &_init_ctor_QFileDialog_Adaptor_7066, &_call_ctor_QFileDialog_Adaptor_7066);
}

// void QFileDialog::adjustPosition(QWidget *)

static void _init_fp_adjustPosition_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_adjustPosition_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QFileDialog_Adaptor *)cls)->fp_QFileDialog_adjustPosition_1315 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_adjustPosition_1315 ()
{
  return new qt_gsi::GenericMethod("*adjustPosition", "@brief Method void QFileDialog::adjustPosition(QWidget *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_adjustPosition_1315, &_call_fp_adjustPosition_1315);
}


// void QFileDialog::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<WId>::target_type & > () : (const qt_gsi::Converter<WId>::target_type &)(qt_gsi::CppToQtReadAdaptor<WId>(heap, 0));
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  bool arg3 = args ? args.read<bool > () : (bool)(true);
  ((QFileDialog_Adaptor *)cls)->fp_QFileDialog_create_2208 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_create_2208 ()
{
  return new qt_gsi::GenericMethod("*qt_create", "@brief Method void QFileDialog::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
}


// void QFileDialog::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QFileDialog_Adaptor *)cls)->fp_QFileDialog_destroy_1620 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_destroy_1620 ()
{
  return new qt_gsi::GenericMethod("*qt_destroy", "@brief Method void QFileDialog::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
}


// bool QFileDialog::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileDialog_Adaptor *)cls)->fp_QFileDialog_focusNextChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusNextChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusNextChild", "@brief Method bool QFileDialog::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
}


// bool QFileDialog::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileDialog_Adaptor *)cls)->fp_QFileDialog_focusPreviousChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusPreviousChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusPreviousChild", "@brief Method bool QFileDialog::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
}


// int QFileDialog::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QFileDialog_Adaptor *)cls)->fp_QFileDialog_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QFileDialog::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QFileDialog::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFileDialog_Adaptor *)cls)->fp_QFileDialog_resetInputContext_0 ();
}

static qt_gsi::GenericMethod*_create_fp_resetInputContext_0 ()
{
  return new qt_gsi::GenericMethod("*resetInputContext", "@brief Method void QFileDialog::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
}


// QObject *QFileDialog::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QFileDialog_Adaptor *)cls)->fp_QFileDialog_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QFileDialog::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QFileDialog::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFileDialog_Adaptor *)cls)->fp_QFileDialog_updateMicroFocus_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateMicroFocus_0 ()
{
  return new qt_gsi::GenericMethod("*updateMicroFocus", "@brief Method void QFileDialog::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
}


// int QFileDialog::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QFileDialog_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QFileDialog::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// QVariant QFileDialog::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QFileDialog_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QFileDialog::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// QSize QFileDialog::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QFileDialog_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QFileDialog::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
}


// QPaintEngine *QFileDialog::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QFileDialog_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QFileDialog::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
}


// void QFileDialog::reject()

static void _init_cbs_reject_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reject_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFileDialog_Adaptor *)cls)->cbs_reject_0_0 ();
}

static void _set_callback_cbs_reject_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_reject_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_reject_0_0 ()
{
  return new qt_gsi::GenericMethod ("reject", "@hide", false, &_init_cbs_reject_0_0, &_call_cbs_reject_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_reject_0_0 ()
{
  return new qt_gsi::GenericMethod ("reject", "@brief Virtual method void QFileDialog::reject()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reject_0_0, &_call_cbs_reject_0_0, &_set_callback_cbs_reject_0_0);
}


// void QFileDialog::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QFileDialog_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QFileDialog::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
}


// QSize QFileDialog::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QFileDialog_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QFileDialog::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// void QFileDialog::accept()

static void _init_cbs_accept_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_accept_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFileDialog_Adaptor *)cls)->cbs_accept_0_0 ();
}

static void _set_callback_cbs_accept_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_accept_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_accept_0_0 ()
{
  return new qt_gsi::GenericMethod ("*accept", "@hide", false, &_init_cbs_accept_0_0, &_call_cbs_accept_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_accept_0_0 ()
{
  return new qt_gsi::GenericMethod ("*accept", "@brief Virtual method void QFileDialog::accept()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_accept_0_0, &_call_cbs_accept_0_0, &_set_callback_cbs_accept_0_0);
}


// void QFileDialog::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QActionEvent *arg1 = args.read<QActionEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QFileDialog::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
}


// void QFileDialog::changeEvent(QEvent *e)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QFileDialog::changeEvent(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
}


// void QFileDialog::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QFileDialog::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QFileDialog::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCloseEvent *arg1 = args.read<QCloseEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QFileDialog::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
}


// void QFileDialog::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QFileDialog::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
}


// void QFileDialog::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QFileDialog::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QFileDialog::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QFileDialog::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QFileDialog::done(int result)

static void _init_cbs_done_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("result");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_done_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QFileDialog_Adaptor *)cls)->cbs_done_767_0 (arg1);
}

static void _set_callback_cbs_done_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_done_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_done_767_0 ()
{
  return new qt_gsi::GenericMethod ("*done", "@hide", false, &_init_cbs_done_767_0, &_call_cbs_done_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_done_767_0 ()
{
  return new qt_gsi::GenericMethod ("*done", "@brief Virtual method void QFileDialog::done(int result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_done_767_0, &_call_cbs_done_767_0, &_set_callback_cbs_done_767_0);
}


// void QFileDialog::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QFileDialog::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
}


// void QFileDialog::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QFileDialog::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
}


// void QFileDialog::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QFileDialog::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
}


// void QFileDialog::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDropEvent *arg1 = args.read<QDropEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QFileDialog::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
}


// void QFileDialog::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QFileDialog_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QFileDialog::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
}


// void QFileDialog::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QFileDialog::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
}


// bool QFileDialog::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QFileDialog_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QFileDialog::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QFileDialog::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QFileDialog_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QFileDialog::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QFileDialog::focusInEvent(QFocusEvent *)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QFileDialog::focusInEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// bool QFileDialog::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<bool > ((bool)((QFileDialog_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QFileDialog::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
}


// void QFileDialog::focusOutEvent(QFocusEvent *)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QFileDialog::focusOutEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QFileDialog::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QFileDialog_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QFileDialog::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
}


// void QFileDialog::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QHideEvent *arg1 = args.read<QHideEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QFileDialog::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
}


// void QFileDialog::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QFileDialog::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// void QFileDialog::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QFileDialog::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QFileDialog::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QFileDialog::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QFileDialog::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFileDialog_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QFileDialog::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
}


// void QFileDialog::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QFileDialog::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
}


// int QFileDialog::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QFileDialog_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QFileDialog::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
}


// void QFileDialog::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QFileDialog::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
}


// void QFileDialog::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QFileDialog::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
}


// void QFileDialog::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QFileDialog::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
}


// void QFileDialog::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QFileDialog::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
}


// void QFileDialog::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMoveEvent *arg1 = args.read<QMoveEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QFileDialog::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
}


// void QFileDialog::paintEvent(QPaintEvent *)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintEvent *arg1 = args.read<QPaintEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QFileDialog::paintEvent(QPaintEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
}


// void QFileDialog::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ((QFileDialog_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QFileDialog::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
}


// void QFileDialog::resizeEvent(QResizeEvent *)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QResizeEvent *arg1 = args.read<QResizeEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QFileDialog::resizeEvent(QResizeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
}


// void QFileDialog::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QShowEvent *arg1 = args.read<QShowEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QFileDialog::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
}


// void QFileDialog::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle &arg1 = args.read<QStyle & > ();
  ((QFileDialog_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QFileDialog::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
}


// void QFileDialog::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTabletEvent *arg1 = args.read<QTabletEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QFileDialog::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
}


// void QFileDialog::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QFileDialog::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


// void QFileDialog::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWheelEvent *arg1 = args.read<QWheelEvent * > ();
  ((QFileDialog_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QFileDialog::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
}


// void QFileDialog::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QFileDialog_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QFileDialog::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
}


namespace gsi
{

extern gsi::Class<QFileDialog> decl_QFileDialog;

gsi::Class<QFileDialog_Adaptor> decl_QFileDialog_Adaptor (decl_QFileDialog, "QFileDialog",
  gsi::Methods(_create_fp_adjustPosition_1315 ()) +
  gsi::Methods(_create_fp_create_2208 ()) +
  gsi::Methods(_create_fp_destroy_1620 ()) +
  gsi::Methods(_create_fp_focusNextChild_0 ()) +
  gsi::Methods(_create_fp_focusPreviousChild_0 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_resetInputContext_0 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_updateMicroFocus_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_cbs_reject_0_0 ()) +
  gsi::Methods(_create_callback_cbs_reject_0_0 ()) +
  gsi::Methods(_create_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_accept_0_0 ()) +
  gsi::Methods(_create_callback_cbs_accept_0_0 ()) +
  gsi::Methods(_create_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_callback_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_done_767_0 ()) +
  gsi::Methods(_create_callback_cbs_done_767_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_callback_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_callback_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_callback_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_callback_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_callback_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_callback_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_callback_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_callback_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_callback_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_callback_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_ctor_QFileDialog_Adaptor_3702 ()) +
  gsi::Methods(_create_ctor_QFileDialog_Adaptor_7066 ()),
  "@qt\n@brief Binding of QFileDialog");

}


//  Implementation of the enum wrapper class for QFileDialog::AcceptMode
namespace qt_gsi
{

static QFileDialog_AcceptMode_Enum *c_1_QFileDialog_AcceptMode_Enum () { return new QFileDialog_AcceptMode_Enum (QFileDialog::AcceptOpen); }
static QFileDialog_AcceptMode_Enum *c_2_QFileDialog_AcceptMode_Enum () { return new QFileDialog_AcceptMode_Enum (QFileDialog::AcceptSave); }

static gsi::Methods mkdefs_QFileDialog_AcceptMode () {
  return
    gsi::constant ("AcceptOpen", &qt_gsi::c_1_QFileDialog_AcceptMode_Enum, "@brief Enum constant QFileDialog::AcceptOpen") +
    gsi::constant ("AcceptSave", &qt_gsi::c_2_QFileDialog_AcceptMode_Enum, "@brief Enum constant QFileDialog::AcceptSave");
}

static std::string to_s_QFileDialog_AcceptMode_Enum (const QFileDialog_AcceptMode_Enum *e)
{
  if (e->value () == QFileDialog::AcceptOpen) { return tl::sprintf ("AcceptOpen (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFileDialog::AcceptSave) { return tl::sprintf ("AcceptSave (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QFileDialog_AcceptMode_Enum (const QFileDialog_AcceptMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QFileDialog_AcceptMode_Enum *from_i_QFileDialog_AcceptMode_Enum (unsigned int i)
{
  return new QFileDialog_AcceptMode_Enum ((QFileDialog::AcceptMode) i);
}

static bool equalQFileDialog_AcceptMode_Enum (const QFileDialog_AcceptMode_Enum *e, QFileDialog_AcceptMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QFileDialog_AcceptMode_Enum (const QFileDialog_AcceptMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QFileDialog_AcceptMode_Enums oropQFileDialog_AcceptMode_Enums (const QFileDialog_AcceptMode_Enums *e, const QFileDialog_AcceptMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QFileDialog_AcceptMode_Enums andopQFileDialog_AcceptMode_Enums (const QFileDialog_AcceptMode_Enums *e, const QFileDialog_AcceptMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QFileDialog_AcceptMode_Enums xoropQFileDialog_AcceptMode_Enums (const QFileDialog_AcceptMode_Enums *e, const QFileDialog_AcceptMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QFileDialog_AcceptMode_Enums (const QFileDialog_AcceptMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QFileDialog::AcceptOpen)) { if (!l.empty ()) l += "|"; l += "AcceptOpen"; }
  if (e->testFlag (QFileDialog::AcceptSave)) { if (!l.empty ()) l += "|"; l += "AcceptSave"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QFileDialog_AcceptMode_Enums (const QFileDialog_AcceptMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QFileDialog_AcceptMode_Enums (const QFileDialog_AcceptMode_Enums *e, const QFileDialog_AcceptMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QFileDialog_AcceptMode_Enums> decl_QFileDialog_AcceptMode_Enums ("QFileDialog_QFlags_AcceptMode",
  gsi::method_ext ("|", &qt_gsi::oropQFileDialog_AcceptMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQFileDialog_AcceptMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQFileDialog_AcceptMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFileDialog_AcceptMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFileDialog_AcceptMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QFileDialog_AcceptMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QFileDialog::AcceptMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QFileDialog_AcceptMode_Enum> decl_QFileDialog_AcceptMode_Enum (decl_QFileDialog_AcceptMode_Enums, "QFileDialog_AcceptMode",
  qt_gsi::mkdefs_QFileDialog_AcceptMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFileDialog_AcceptMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFileDialog_AcceptMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQFileDialog_AcceptMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QFileDialog_AcceptMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QFileDialog_AcceptMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QFileDialog::AcceptMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QFileDialog> inject_QFileDialog_AcceptMode_Enum_in_parent (qt_gsi::mkdefs_QFileDialog_AcceptMode ());
static gsi::ClassExt<QFileDialog> decl_QFileDialog_AcceptMode_Enum_as_child (decl_QFileDialog_AcceptMode_Enum, "AcceptMode");

}


//  Implementation of the enum wrapper class for QFileDialog::DialogLabel
namespace qt_gsi
{

static QFileDialog_DialogLabel_Enum *c_1_QFileDialog_DialogLabel_Enum () { return new QFileDialog_DialogLabel_Enum (QFileDialog::LookIn); }
static QFileDialog_DialogLabel_Enum *c_2_QFileDialog_DialogLabel_Enum () { return new QFileDialog_DialogLabel_Enum (QFileDialog::FileName); }
static QFileDialog_DialogLabel_Enum *c_3_QFileDialog_DialogLabel_Enum () { return new QFileDialog_DialogLabel_Enum (QFileDialog::FileType); }
static QFileDialog_DialogLabel_Enum *c_4_QFileDialog_DialogLabel_Enum () { return new QFileDialog_DialogLabel_Enum (QFileDialog::Accept); }
static QFileDialog_DialogLabel_Enum *c_5_QFileDialog_DialogLabel_Enum () { return new QFileDialog_DialogLabel_Enum (QFileDialog::Reject); }

static gsi::Methods mkdefs_QFileDialog_DialogLabel () {
  return
    gsi::constant ("LookIn", &qt_gsi::c_1_QFileDialog_DialogLabel_Enum, "@brief Enum constant QFileDialog::LookIn") +
    gsi::constant ("FileName", &qt_gsi::c_2_QFileDialog_DialogLabel_Enum, "@brief Enum constant QFileDialog::FileName") +
    gsi::constant ("FileType", &qt_gsi::c_3_QFileDialog_DialogLabel_Enum, "@brief Enum constant QFileDialog::FileType") +
    gsi::constant ("Accept", &qt_gsi::c_4_QFileDialog_DialogLabel_Enum, "@brief Enum constant QFileDialog::Accept") +
    gsi::constant ("Reject", &qt_gsi::c_5_QFileDialog_DialogLabel_Enum, "@brief Enum constant QFileDialog::Reject");
}

static std::string to_s_QFileDialog_DialogLabel_Enum (const QFileDialog_DialogLabel_Enum *e)
{
  if (e->value () == QFileDialog::LookIn) { return tl::sprintf ("LookIn (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFileDialog::FileName) { return tl::sprintf ("FileName (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFileDialog::FileType) { return tl::sprintf ("FileType (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFileDialog::Accept) { return tl::sprintf ("Accept (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFileDialog::Reject) { return tl::sprintf ("Reject (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QFileDialog_DialogLabel_Enum (const QFileDialog_DialogLabel_Enum *e)
{
  return (unsigned int) e->value ();
}

static QFileDialog_DialogLabel_Enum *from_i_QFileDialog_DialogLabel_Enum (unsigned int i)
{
  return new QFileDialog_DialogLabel_Enum ((QFileDialog::DialogLabel) i);
}

static bool equalQFileDialog_DialogLabel_Enum (const QFileDialog_DialogLabel_Enum *e, QFileDialog_DialogLabel_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QFileDialog_DialogLabel_Enum (const QFileDialog_DialogLabel_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QFileDialog_DialogLabel_Enums oropQFileDialog_DialogLabel_Enums (const QFileDialog_DialogLabel_Enums *e, const QFileDialog_DialogLabel_Enums &d)
{
  return e->flags () | d.flags ();
}

static QFileDialog_DialogLabel_Enums andopQFileDialog_DialogLabel_Enums (const QFileDialog_DialogLabel_Enums *e, const QFileDialog_DialogLabel_Enums &d)
{
  return e->flags () & d.flags ();
}

static QFileDialog_DialogLabel_Enums xoropQFileDialog_DialogLabel_Enums (const QFileDialog_DialogLabel_Enums *e, const QFileDialog_DialogLabel_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QFileDialog_DialogLabel_Enums (const QFileDialog_DialogLabel_Enums *e)
{
  std::string l;
  if (e->testFlag (QFileDialog::LookIn)) { if (!l.empty ()) l += "|"; l += "LookIn"; }
  if (e->testFlag (QFileDialog::FileName)) { if (!l.empty ()) l += "|"; l += "FileName"; }
  if (e->testFlag (QFileDialog::FileType)) { if (!l.empty ()) l += "|"; l += "FileType"; }
  if (e->testFlag (QFileDialog::Accept)) { if (!l.empty ()) l += "|"; l += "Accept"; }
  if (e->testFlag (QFileDialog::Reject)) { if (!l.empty ()) l += "|"; l += "Reject"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QFileDialog_DialogLabel_Enums (const QFileDialog_DialogLabel_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QFileDialog_DialogLabel_Enums (const QFileDialog_DialogLabel_Enums *e, const QFileDialog_DialogLabel_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QFileDialog_DialogLabel_Enums> decl_QFileDialog_DialogLabel_Enums ("QFileDialog_QFlags_DialogLabel",
  gsi::method_ext ("|", &qt_gsi::oropQFileDialog_DialogLabel_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQFileDialog_DialogLabel_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQFileDialog_DialogLabel_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFileDialog_DialogLabel_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFileDialog_DialogLabel_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QFileDialog_DialogLabel_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QFileDialog::DialogLabel> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QFileDialog_DialogLabel_Enum> decl_QFileDialog_DialogLabel_Enum (decl_QFileDialog_DialogLabel_Enums, "QFileDialog_DialogLabel",
  qt_gsi::mkdefs_QFileDialog_DialogLabel () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFileDialog_DialogLabel_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFileDialog_DialogLabel_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQFileDialog_DialogLabel_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QFileDialog_DialogLabel_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QFileDialog_DialogLabel_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QFileDialog::DialogLabel enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QFileDialog> inject_QFileDialog_DialogLabel_Enum_in_parent (qt_gsi::mkdefs_QFileDialog_DialogLabel ());
static gsi::ClassExt<QFileDialog> decl_QFileDialog_DialogLabel_Enum_as_child (decl_QFileDialog_DialogLabel_Enum, "DialogLabel");

}


//  Implementation of the enum wrapper class for QFileDialog::FileMode
namespace qt_gsi
{

static QFileDialog_FileMode_Enum *c_1_QFileDialog_FileMode_Enum () { return new QFileDialog_FileMode_Enum (QFileDialog::AnyFile); }
static QFileDialog_FileMode_Enum *c_2_QFileDialog_FileMode_Enum () { return new QFileDialog_FileMode_Enum (QFileDialog::ExistingFile); }
static QFileDialog_FileMode_Enum *c_3_QFileDialog_FileMode_Enum () { return new QFileDialog_FileMode_Enum (QFileDialog::Directory); }
static QFileDialog_FileMode_Enum *c_4_QFileDialog_FileMode_Enum () { return new QFileDialog_FileMode_Enum (QFileDialog::ExistingFiles); }
static QFileDialog_FileMode_Enum *c_5_QFileDialog_FileMode_Enum () { return new QFileDialog_FileMode_Enum (QFileDialog::DirectoryOnly); }

static gsi::Methods mkdefs_QFileDialog_FileMode () {
  return
    gsi::constant ("AnyFile", &qt_gsi::c_1_QFileDialog_FileMode_Enum, "@brief Enum constant QFileDialog::AnyFile") +
    gsi::constant ("ExistingFile", &qt_gsi::c_2_QFileDialog_FileMode_Enum, "@brief Enum constant QFileDialog::ExistingFile") +
    gsi::constant ("Directory", &qt_gsi::c_3_QFileDialog_FileMode_Enum, "@brief Enum constant QFileDialog::Directory") +
    gsi::constant ("ExistingFiles", &qt_gsi::c_4_QFileDialog_FileMode_Enum, "@brief Enum constant QFileDialog::ExistingFiles") +
    gsi::constant ("DirectoryOnly", &qt_gsi::c_5_QFileDialog_FileMode_Enum, "@brief Enum constant QFileDialog::DirectoryOnly");
}

static std::string to_s_QFileDialog_FileMode_Enum (const QFileDialog_FileMode_Enum *e)
{
  if (e->value () == QFileDialog::AnyFile) { return tl::sprintf ("AnyFile (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFileDialog::ExistingFile) { return tl::sprintf ("ExistingFile (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFileDialog::Directory) { return tl::sprintf ("Directory (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFileDialog::ExistingFiles) { return tl::sprintf ("ExistingFiles (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFileDialog::DirectoryOnly) { return tl::sprintf ("DirectoryOnly (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QFileDialog_FileMode_Enum (const QFileDialog_FileMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QFileDialog_FileMode_Enum *from_i_QFileDialog_FileMode_Enum (unsigned int i)
{
  return new QFileDialog_FileMode_Enum ((QFileDialog::FileMode) i);
}

static bool equalQFileDialog_FileMode_Enum (const QFileDialog_FileMode_Enum *e, QFileDialog_FileMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QFileDialog_FileMode_Enum (const QFileDialog_FileMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QFileDialog_FileMode_Enums oropQFileDialog_FileMode_Enums (const QFileDialog_FileMode_Enums *e, const QFileDialog_FileMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QFileDialog_FileMode_Enums andopQFileDialog_FileMode_Enums (const QFileDialog_FileMode_Enums *e, const QFileDialog_FileMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QFileDialog_FileMode_Enums xoropQFileDialog_FileMode_Enums (const QFileDialog_FileMode_Enums *e, const QFileDialog_FileMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QFileDialog_FileMode_Enums (const QFileDialog_FileMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QFileDialog::AnyFile)) { if (!l.empty ()) l += "|"; l += "AnyFile"; }
  if (e->testFlag (QFileDialog::ExistingFile)) { if (!l.empty ()) l += "|"; l += "ExistingFile"; }
  if (e->testFlag (QFileDialog::Directory)) { if (!l.empty ()) l += "|"; l += "Directory"; }
  if (e->testFlag (QFileDialog::ExistingFiles)) { if (!l.empty ()) l += "|"; l += "ExistingFiles"; }
  if (e->testFlag (QFileDialog::DirectoryOnly)) { if (!l.empty ()) l += "|"; l += "DirectoryOnly"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QFileDialog_FileMode_Enums (const QFileDialog_FileMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QFileDialog_FileMode_Enums (const QFileDialog_FileMode_Enums *e, const QFileDialog_FileMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QFileDialog_FileMode_Enums> decl_QFileDialog_FileMode_Enums ("QFileDialog_QFlags_FileMode",
  gsi::method_ext ("|", &qt_gsi::oropQFileDialog_FileMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQFileDialog_FileMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQFileDialog_FileMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFileDialog_FileMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFileDialog_FileMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QFileDialog_FileMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QFileDialog::FileMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QFileDialog_FileMode_Enum> decl_QFileDialog_FileMode_Enum (decl_QFileDialog_FileMode_Enums, "QFileDialog_FileMode",
  qt_gsi::mkdefs_QFileDialog_FileMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFileDialog_FileMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFileDialog_FileMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQFileDialog_FileMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QFileDialog_FileMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QFileDialog_FileMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QFileDialog::FileMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QFileDialog> inject_QFileDialog_FileMode_Enum_in_parent (qt_gsi::mkdefs_QFileDialog_FileMode ());
static gsi::ClassExt<QFileDialog> decl_QFileDialog_FileMode_Enum_as_child (decl_QFileDialog_FileMode_Enum, "FileMode");

}


//  Implementation of the enum wrapper class for QFileDialog::Option
namespace qt_gsi
{

static QFileDialog_Option_Enum *c_1_QFileDialog_Option_Enum () { return new QFileDialog_Option_Enum (QFileDialog::ShowDirsOnly); }
static QFileDialog_Option_Enum *c_2_QFileDialog_Option_Enum () { return new QFileDialog_Option_Enum (QFileDialog::DontResolveSymlinks); }
static QFileDialog_Option_Enum *c_3_QFileDialog_Option_Enum () { return new QFileDialog_Option_Enum (QFileDialog::DontConfirmOverwrite); }
static QFileDialog_Option_Enum *c_4_QFileDialog_Option_Enum () { return new QFileDialog_Option_Enum (QFileDialog::DontUseSheet); }
static QFileDialog_Option_Enum *c_5_QFileDialog_Option_Enum () { return new QFileDialog_Option_Enum (QFileDialog::DontUseNativeDialog); }
static QFileDialog_Option_Enum *c_6_QFileDialog_Option_Enum () { return new QFileDialog_Option_Enum (QFileDialog::ReadOnly); }
static QFileDialog_Option_Enum *c_7_QFileDialog_Option_Enum () { return new QFileDialog_Option_Enum (QFileDialog::HideNameFilterDetails); }

static gsi::Methods mkdefs_QFileDialog_Option () {
  return
    gsi::constant ("ShowDirsOnly", &qt_gsi::c_1_QFileDialog_Option_Enum, "@brief Enum constant QFileDialog::ShowDirsOnly") +
    gsi::constant ("DontResolveSymlinks", &qt_gsi::c_2_QFileDialog_Option_Enum, "@brief Enum constant QFileDialog::DontResolveSymlinks") +
    gsi::constant ("DontConfirmOverwrite", &qt_gsi::c_3_QFileDialog_Option_Enum, "@brief Enum constant QFileDialog::DontConfirmOverwrite") +
    gsi::constant ("DontUseSheet", &qt_gsi::c_4_QFileDialog_Option_Enum, "@brief Enum constant QFileDialog::DontUseSheet") +
    gsi::constant ("DontUseNativeDialog", &qt_gsi::c_5_QFileDialog_Option_Enum, "@brief Enum constant QFileDialog::DontUseNativeDialog") +
    gsi::constant ("ReadOnly", &qt_gsi::c_6_QFileDialog_Option_Enum, "@brief Enum constant QFileDialog::ReadOnly") +
    gsi::constant ("HideNameFilterDetails", &qt_gsi::c_7_QFileDialog_Option_Enum, "@brief Enum constant QFileDialog::HideNameFilterDetails");
}

static std::string to_s_QFileDialog_Option_Enum (const QFileDialog_Option_Enum *e)
{
  if (e->value () == QFileDialog::ShowDirsOnly) { return tl::sprintf ("ShowDirsOnly (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFileDialog::DontResolveSymlinks) { return tl::sprintf ("DontResolveSymlinks (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFileDialog::DontConfirmOverwrite) { return tl::sprintf ("DontConfirmOverwrite (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFileDialog::DontUseSheet) { return tl::sprintf ("DontUseSheet (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFileDialog::DontUseNativeDialog) { return tl::sprintf ("DontUseNativeDialog (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFileDialog::ReadOnly) { return tl::sprintf ("ReadOnly (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFileDialog::HideNameFilterDetails) { return tl::sprintf ("HideNameFilterDetails (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QFileDialog_Option_Enum (const QFileDialog_Option_Enum *e)
{
  return (unsigned int) e->value ();
}

static QFileDialog_Option_Enum *from_i_QFileDialog_Option_Enum (unsigned int i)
{
  return new QFileDialog_Option_Enum ((QFileDialog::Option) i);
}

static bool equalQFileDialog_Option_Enum (const QFileDialog_Option_Enum *e, QFileDialog_Option_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QFileDialog_Option_Enum (const QFileDialog_Option_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QFileDialog_Option_Enums oropQFileDialog_Option_Enums (const QFileDialog_Option_Enums *e, const QFileDialog_Option_Enums &d)
{
  return e->flags () | d.flags ();
}

static QFileDialog_Option_Enums andopQFileDialog_Option_Enums (const QFileDialog_Option_Enums *e, const QFileDialog_Option_Enums &d)
{
  return e->flags () & d.flags ();
}

static QFileDialog_Option_Enums xoropQFileDialog_Option_Enums (const QFileDialog_Option_Enums *e, const QFileDialog_Option_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QFileDialog_Option_Enums (const QFileDialog_Option_Enums *e)
{
  std::string l;
  if (e->testFlag (QFileDialog::ShowDirsOnly)) { if (!l.empty ()) l += "|"; l += "ShowDirsOnly"; }
  if (e->testFlag (QFileDialog::DontResolveSymlinks)) { if (!l.empty ()) l += "|"; l += "DontResolveSymlinks"; }
  if (e->testFlag (QFileDialog::DontConfirmOverwrite)) { if (!l.empty ()) l += "|"; l += "DontConfirmOverwrite"; }
  if (e->testFlag (QFileDialog::DontUseSheet)) { if (!l.empty ()) l += "|"; l += "DontUseSheet"; }
  if (e->testFlag (QFileDialog::DontUseNativeDialog)) { if (!l.empty ()) l += "|"; l += "DontUseNativeDialog"; }
  if (e->testFlag (QFileDialog::ReadOnly)) { if (!l.empty ()) l += "|"; l += "ReadOnly"; }
  if (e->testFlag (QFileDialog::HideNameFilterDetails)) { if (!l.empty ()) l += "|"; l += "HideNameFilterDetails"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QFileDialog_Option_Enums (const QFileDialog_Option_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QFileDialog_Option_Enums (const QFileDialog_Option_Enums *e, const QFileDialog_Option_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QFileDialog_Option_Enums> decl_QFileDialog_Option_Enums ("QFileDialog_QFlags_Option",
  gsi::method_ext ("|", &qt_gsi::oropQFileDialog_Option_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQFileDialog_Option_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQFileDialog_Option_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFileDialog_Option_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFileDialog_Option_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QFileDialog_Option_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QFileDialog::Option> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QFileDialog_Option_Enum> decl_QFileDialog_Option_Enum (decl_QFileDialog_Option_Enums, "QFileDialog_Option",
  qt_gsi::mkdefs_QFileDialog_Option () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFileDialog_Option_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFileDialog_Option_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQFileDialog_Option_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QFileDialog_Option_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QFileDialog_Option_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QFileDialog::Option enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QFileDialog> inject_QFileDialog_Option_Enum_in_parent (qt_gsi::mkdefs_QFileDialog_Option ());
static gsi::ClassExt<QFileDialog> decl_QFileDialog_Option_Enum_as_child (decl_QFileDialog_Option_Enum, "Option");

}


//  Implementation of the enum wrapper class for QFileDialog::ViewMode
namespace qt_gsi
{

static QFileDialog_ViewMode_Enum *c_1_QFileDialog_ViewMode_Enum () { return new QFileDialog_ViewMode_Enum (QFileDialog::Detail); }
static QFileDialog_ViewMode_Enum *c_2_QFileDialog_ViewMode_Enum () { return new QFileDialog_ViewMode_Enum (QFileDialog::List); }

static gsi::Methods mkdefs_QFileDialog_ViewMode () {
  return
    gsi::constant ("Detail", &qt_gsi::c_1_QFileDialog_ViewMode_Enum, "@brief Enum constant QFileDialog::Detail") +
    gsi::constant ("List", &qt_gsi::c_2_QFileDialog_ViewMode_Enum, "@brief Enum constant QFileDialog::List");
}

static std::string to_s_QFileDialog_ViewMode_Enum (const QFileDialog_ViewMode_Enum *e)
{
  if (e->value () == QFileDialog::Detail) { return tl::sprintf ("Detail (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFileDialog::List) { return tl::sprintf ("List (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QFileDialog_ViewMode_Enum (const QFileDialog_ViewMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QFileDialog_ViewMode_Enum *from_i_QFileDialog_ViewMode_Enum (unsigned int i)
{
  return new QFileDialog_ViewMode_Enum ((QFileDialog::ViewMode) i);
}

static bool equalQFileDialog_ViewMode_Enum (const QFileDialog_ViewMode_Enum *e, QFileDialog_ViewMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QFileDialog_ViewMode_Enum (const QFileDialog_ViewMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QFileDialog_ViewMode_Enums oropQFileDialog_ViewMode_Enums (const QFileDialog_ViewMode_Enums *e, const QFileDialog_ViewMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QFileDialog_ViewMode_Enums andopQFileDialog_ViewMode_Enums (const QFileDialog_ViewMode_Enums *e, const QFileDialog_ViewMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QFileDialog_ViewMode_Enums xoropQFileDialog_ViewMode_Enums (const QFileDialog_ViewMode_Enums *e, const QFileDialog_ViewMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QFileDialog_ViewMode_Enums (const QFileDialog_ViewMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QFileDialog::Detail)) { if (!l.empty ()) l += "|"; l += "Detail"; }
  if (e->testFlag (QFileDialog::List)) { if (!l.empty ()) l += "|"; l += "List"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QFileDialog_ViewMode_Enums (const QFileDialog_ViewMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QFileDialog_ViewMode_Enums (const QFileDialog_ViewMode_Enums *e, const QFileDialog_ViewMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QFileDialog_ViewMode_Enums> decl_QFileDialog_ViewMode_Enums ("QFileDialog_QFlags_ViewMode",
  gsi::method_ext ("|", &qt_gsi::oropQFileDialog_ViewMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQFileDialog_ViewMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQFileDialog_ViewMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFileDialog_ViewMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFileDialog_ViewMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QFileDialog_ViewMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QFileDialog::ViewMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QFileDialog_ViewMode_Enum> decl_QFileDialog_ViewMode_Enum (decl_QFileDialog_ViewMode_Enums, "QFileDialog_ViewMode",
  qt_gsi::mkdefs_QFileDialog_ViewMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFileDialog_ViewMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFileDialog_ViewMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQFileDialog_ViewMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QFileDialog_ViewMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QFileDialog_ViewMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QFileDialog::ViewMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QFileDialog> inject_QFileDialog_ViewMode_Enum_in_parent (qt_gsi::mkdefs_QFileDialog_ViewMode ());
static gsi::ClassExt<QFileDialog> decl_QFileDialog_ViewMode_Enum_as_child (decl_QFileDialog_ViewMode_Enum, "ViewMode");

}

