
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQDialogButtonBox.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQDialogButtonBox_EventAdaptor.h"
#include "gsiDeclQDialogButtonBox_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QDialogButtonBox

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QDialogButtonBox::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// void QDialogButtonBox::addButton(QAbstractButton *button, QDialogButtonBox::ButtonRole role)


static void _init_f_addButton_5247 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<QAbstractButton * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<const qt_gsi::Converter<QDialogButtonBox::ButtonRole>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addButton_5247 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractButton *arg1 = args.read<QAbstractButton * > ();
  const qt_gsi::Converter<QDialogButtonBox::ButtonRole>::target_type & arg2 = args.read<const qt_gsi::Converter<QDialogButtonBox::ButtonRole>::target_type & > ();
  ((QDialogButtonBox *)cls)->addButton (arg1, qt_gsi::QtToCppAdaptor<QDialogButtonBox::ButtonRole>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_addButton_5247 ()
{
  return new qt_gsi::GenericMethod ("addButton", "@brief Method void QDialogButtonBox::addButton(QAbstractButton *button, QDialogButtonBox::ButtonRole role)\n", false, &_init_f_addButton_5247, &_call_f_addButton_5247);
}

// QPushButton *QDialogButtonBox::addButton(const QString &text, QDialogButtonBox::ButtonRole role)


static void _init_f_addButton_5113 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<const qt_gsi::Converter<QDialogButtonBox::ButtonRole>::target_type & > (argspec_1);
  decl->set_return<QPushButton * > ();
}

static void _call_f_addButton_5113 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const qt_gsi::Converter<QDialogButtonBox::ButtonRole>::target_type & arg2 = args.read<const qt_gsi::Converter<QDialogButtonBox::ButtonRole>::target_type & > ();
  ret.write<QPushButton * > ((QPushButton *)((QDialogButtonBox *)cls)->addButton (arg1, qt_gsi::QtToCppAdaptor<QDialogButtonBox::ButtonRole>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_addButton_5113 ()
{
  return new qt_gsi::GenericMethod ("addButton", "@brief Method QPushButton *QDialogButtonBox::addButton(const QString &text, QDialogButtonBox::ButtonRole role)\n", false, &_init_f_addButton_5113, &_call_f_addButton_5113);
}

// QPushButton *QDialogButtonBox::addButton(QDialogButtonBox::StandardButton button)


static void _init_f_addButton_3611 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<const qt_gsi::Converter<QDialogButtonBox::StandardButton>::target_type & > (argspec_0);
  decl->set_return<QPushButton * > ();
}

static void _call_f_addButton_3611 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QDialogButtonBox::StandardButton>::target_type & arg1 = args.read<const qt_gsi::Converter<QDialogButtonBox::StandardButton>::target_type & > ();
  ret.write<QPushButton * > ((QPushButton *)((QDialogButtonBox *)cls)->addButton (qt_gsi::QtToCppAdaptor<QDialogButtonBox::StandardButton>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_addButton_3611 ()
{
  return new qt_gsi::GenericMethod ("addButton", "@brief Method QPushButton *QDialogButtonBox::addButton(QDialogButtonBox::StandardButton button)\n", false, &_init_f_addButton_3611, &_call_f_addButton_3611);
}

// QPushButton *QDialogButtonBox::button(QDialogButtonBox::StandardButton which)


static void _init_f_button_c3611 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<QDialogButtonBox::StandardButton>::target_type & > (argspec_0);
  decl->set_return<QPushButton * > ();
}

static void _call_f_button_c3611 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QDialogButtonBox::StandardButton>::target_type & arg1 = args.read<const qt_gsi::Converter<QDialogButtonBox::StandardButton>::target_type & > ();
  ret.write<QPushButton * > ((QPushButton *)((QDialogButtonBox *)cls)->button (qt_gsi::QtToCppAdaptor<QDialogButtonBox::StandardButton>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_button_c3611 ()
{
  return new qt_gsi::GenericMethod ("button", "@brief Method QPushButton *QDialogButtonBox::button(QDialogButtonBox::StandardButton which)\n", true, &_init_f_button_c3611, &_call_f_button_c3611);
}

// QDialogButtonBox::ButtonRole QDialogButtonBox::buttonRole(QAbstractButton *button)


static void _init_f_buttonRole_c2159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<QAbstractButton * > (argspec_0);
  decl->set_return<qt_gsi::Converter<QDialogButtonBox::ButtonRole>::target_type > ();
}

static void _call_f_buttonRole_c2159 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractButton *arg1 = args.read<QAbstractButton * > ();
  ret.write<qt_gsi::Converter<QDialogButtonBox::ButtonRole>::target_type > ((qt_gsi::Converter<QDialogButtonBox::ButtonRole>::target_type)qt_gsi::CppToQtAdaptor<QDialogButtonBox::ButtonRole>(((QDialogButtonBox *)cls)->buttonRole (arg1)));
}

static qt_gsi::GenericMethod *_create_f_buttonRole_c2159 ()
{
  return new qt_gsi::GenericMethod ("buttonRole", "@brief Method QDialogButtonBox::ButtonRole QDialogButtonBox::buttonRole(QAbstractButton *button)\n", true, &_init_f_buttonRole_c2159, &_call_f_buttonRole_c2159);
}

// QList<QAbstractButton *> QDialogButtonBox::buttons()


static void _init_f_buttons_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QAbstractButton *> >::target_type > ();
}

static void _call_f_buttons_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QAbstractButton *> >::target_type > ((qt_gsi::Converter<QList<QAbstractButton *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QAbstractButton *> >(((QDialogButtonBox *)cls)->buttons ()));
}

static qt_gsi::GenericMethod *_create_f_buttons_c0 ()
{
  return new qt_gsi::GenericMethod ("buttons", "@brief Method QList<QAbstractButton *> QDialogButtonBox::buttons()\n", true, &_init_f_buttons_c0, &_call_f_buttons_c0);
}

// bool QDialogButtonBox::centerButtons()


static void _init_f_centerButtons_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_centerButtons_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDialogButtonBox *)cls)->centerButtons ());
}

static qt_gsi::GenericMethod *_create_f_centerButtons_c0 ()
{
  return new qt_gsi::GenericMethod (":centerButtons", "@brief Method bool QDialogButtonBox::centerButtons()\n", true, &_init_f_centerButtons_c0, &_call_f_centerButtons_c0);
}

// void QDialogButtonBox::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QDialogButtonBox *)cls)->clear ();
}

static qt_gsi::GenericMethod *_create_f_clear_0 ()
{
  return new qt_gsi::GenericMethod ("clear", "@brief Method void QDialogButtonBox::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
}

// Qt::Orientation QDialogButtonBox::orientation()


static void _init_f_orientation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::Orientation>::target_type > ();
}

static void _call_f_orientation_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::Orientation>::target_type > ((qt_gsi::Converter<Qt::Orientation>::target_type)qt_gsi::CppToQtAdaptor<Qt::Orientation>(((QDialogButtonBox *)cls)->orientation ()));
}

static qt_gsi::GenericMethod *_create_f_orientation_c0 ()
{
  return new qt_gsi::GenericMethod (":orientation", "@brief Method Qt::Orientation QDialogButtonBox::orientation()\n", true, &_init_f_orientation_c0, &_call_f_orientation_c0);
}

// void QDialogButtonBox::removeButton(QAbstractButton *button)


static void _init_f_removeButton_2159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<QAbstractButton * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeButton_2159 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractButton *arg1 = args.read<QAbstractButton * > ();
  ((QDialogButtonBox *)cls)->removeButton (arg1);
}

static qt_gsi::GenericMethod *_create_f_removeButton_2159 ()
{
  return new qt_gsi::GenericMethod ("removeButton", "@brief Method void QDialogButtonBox::removeButton(QAbstractButton *button)\n", false, &_init_f_removeButton_2159, &_call_f_removeButton_2159);
}

// void QDialogButtonBox::setCenterButtons(bool center)


static void _init_f_setCenterButtons_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("center");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCenterButtons_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QDialogButtonBox *)cls)->setCenterButtons (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCenterButtons_864 ()
{
  return new qt_gsi::GenericMethod ("setCenterButtons|centerButtons=", "@brief Method void QDialogButtonBox::setCenterButtons(bool center)\n", false, &_init_f_setCenterButtons_864, &_call_f_setCenterButtons_864);
}

// void QDialogButtonBox::setOrientation(Qt::Orientation orientation)


static void _init_f_setOrientation_1913 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOrientation_1913 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  ((QDialogButtonBox *)cls)->setOrientation (qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setOrientation_1913 ()
{
  return new qt_gsi::GenericMethod ("setOrientation|orientation=", "@brief Method void QDialogButtonBox::setOrientation(Qt::Orientation orientation)\n", false, &_init_f_setOrientation_1913, &_call_f_setOrientation_1913);
}

// void QDialogButtonBox::setStandardButtons(QFlags<QDialogButtonBox::StandardButton> buttons)


static void _init_f_setStandardButtons_4307 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("buttons");
  decl->add_arg<const qt_gsi::Converter<QFlags<QDialogButtonBox::StandardButton> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStandardButtons_4307 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QDialogButtonBox::StandardButton> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QDialogButtonBox::StandardButton> >::target_type & > ();
  ((QDialogButtonBox *)cls)->setStandardButtons (qt_gsi::QtToCppAdaptor<QFlags<QDialogButtonBox::StandardButton> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setStandardButtons_4307 ()
{
  return new qt_gsi::GenericMethod ("setStandardButtons|standardButtons=", "@brief Method void QDialogButtonBox::setStandardButtons(QFlags<QDialogButtonBox::StandardButton> buttons)\n", false, &_init_f_setStandardButtons_4307, &_call_f_setStandardButtons_4307);
}

// QDialogButtonBox::StandardButton QDialogButtonBox::standardButton(QAbstractButton *button)


static void _init_f_standardButton_c2159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<QAbstractButton * > (argspec_0);
  decl->set_return<qt_gsi::Converter<QDialogButtonBox::StandardButton>::target_type > ();
}

static void _call_f_standardButton_c2159 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractButton *arg1 = args.read<QAbstractButton * > ();
  ret.write<qt_gsi::Converter<QDialogButtonBox::StandardButton>::target_type > ((qt_gsi::Converter<QDialogButtonBox::StandardButton>::target_type)qt_gsi::CppToQtAdaptor<QDialogButtonBox::StandardButton>(((QDialogButtonBox *)cls)->standardButton (arg1)));
}

static qt_gsi::GenericMethod *_create_f_standardButton_c2159 ()
{
  return new qt_gsi::GenericMethod ("standardButton", "@brief Method QDialogButtonBox::StandardButton QDialogButtonBox::standardButton(QAbstractButton *button)\n", true, &_init_f_standardButton_c2159, &_call_f_standardButton_c2159);
}

// QFlags<QDialogButtonBox::StandardButton> QDialogButtonBox::standardButtons()


static void _init_f_standardButtons_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QDialogButtonBox::StandardButton> >::target_type > ();
}

static void _call_f_standardButtons_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QDialogButtonBox::StandardButton> >::target_type > ((qt_gsi::Converter<QFlags<QDialogButtonBox::StandardButton> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QDialogButtonBox::StandardButton> >(((QDialogButtonBox *)cls)->standardButtons ()));
}

static qt_gsi::GenericMethod *_create_f_standardButtons_c0 ()
{
  return new qt_gsi::GenericMethod (":standardButtons", "@brief Method QFlags<QDialogButtonBox::StandardButton> QDialogButtonBox::standardButtons()\n", true, &_init_f_standardButtons_c0, &_call_f_standardButtons_c0);
}

// static QString QDialogButtonBox::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QDialogButtonBox::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QDialogButtonBox::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QDialogButtonBox::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QDialogButtonBox::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QDialogButtonBox::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QDialogButtonBox::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QDialogButtonBox::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QDialogButtonBox::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QDialogButtonBox::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QDialogButtonBox::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QDialogButtonBox::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QDialogButtonBox, QDialogButtonBox_EventAdaptor> ea_QDialogButtonBox;

namespace gsi
{
extern gsi::Class<QWidget> decl_QWidget;

gsi::Class<QDialogButtonBox> decl_QDialogButtonBox (ea_QDialogButtonBox, decl_QWidget, "QDialogButtonBox_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_addButton_5247 ()) +
  gsi::Methods(_create_f_addButton_5113 ()) +
  gsi::Methods(_create_f_addButton_3611 ()) +
  gsi::Methods(_create_f_button_c3611 ()) +
  gsi::Methods(_create_f_buttonRole_c2159 ()) +
  gsi::Methods(_create_f_buttons_c0 ()) +
  gsi::Methods(_create_f_centerButtons_c0 ()) +
  gsi::Methods(_create_f_clear_0 ()) +
  gsi::Methods(_create_f_orientation_c0 ()) +
  gsi::Methods(_create_f_removeButton_2159 ()) +
  gsi::Methods(_create_f_setCenterButtons_864 ()) +
  gsi::Methods(_create_f_setOrientation_1913 ()) +
  gsi::Methods(_create_f_setStandardButtons_4307 ()) +
  gsi::Methods(_create_f_standardButton_c2159 ()) +
  gsi::Methods(_create_f_standardButtons_c0 ()) +
  qt_gsi::qt_signal<QDialogButtonBox, QDialogButtonBox_EventAdaptor> ("accepted", &QDialogButtonBox_EventAdaptor::accepted_e_0, "@brief Signal declaration for QDialogButtonBox::accepted()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QDialogButtonBox, QDialogButtonBox_EventAdaptor, QAbstractButton *> ("clicked", &QDialogButtonBox_EventAdaptor::clicked_e_2159, gsi::arg("button"), "@brief Signal declaration for QDialogButtonBox::clicked(QAbstractButton *button)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QDialogButtonBox, QDialogButtonBox_EventAdaptor, const QPoint &> ("customContextMenuRequested", &QDialogButtonBox_EventAdaptor::customContextMenuRequested_e_1916, gsi::arg("pos"), "@brief Signal declaration for QDialogButtonBox::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QDialogButtonBox, QDialogButtonBox_EventAdaptor, QObject *> ("destroyed", &QDialogButtonBox_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QDialogButtonBox::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QDialogButtonBox, QDialogButtonBox_EventAdaptor> ("helpRequested", &QDialogButtonBox_EventAdaptor::helpRequested_e_0, "@brief Signal declaration for QDialogButtonBox::helpRequested()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QDialogButtonBox, QDialogButtonBox_EventAdaptor> ("rejected", &QDialogButtonBox_EventAdaptor::rejected_e_0, "@brief Signal declaration for QDialogButtonBox::rejected()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QDialogButtonBox");
}


class QDialogButtonBox_Adaptor : public QDialogButtonBox, public qt_gsi::QtObjectBase
{
public:

  virtual ~QDialogButtonBox_Adaptor();

  //  [adaptor ctor] QDialogButtonBox::QDialogButtonBox(QWidget *parent)
  QDialogButtonBox_Adaptor() : QDialogButtonBox()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QDialogButtonBox::QDialogButtonBox(QWidget *parent)
  QDialogButtonBox_Adaptor(QWidget *parent) : QDialogButtonBox(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QDialogButtonBox::QDialogButtonBox(Qt::Orientation orientation, QWidget *parent)
  QDialogButtonBox_Adaptor(Qt::Orientation orientation) : QDialogButtonBox(orientation)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QDialogButtonBox::QDialogButtonBox(Qt::Orientation orientation, QWidget *parent)
  QDialogButtonBox_Adaptor(Qt::Orientation orientation, QWidget *parent) : QDialogButtonBox(orientation, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QDialogButtonBox::QDialogButtonBox(QFlags<QDialogButtonBox::StandardButton> buttons, Qt::Orientation orientation, QWidget *parent)
  QDialogButtonBox_Adaptor(QFlags<QDialogButtonBox::StandardButton> buttons) : QDialogButtonBox(buttons)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QDialogButtonBox::QDialogButtonBox(QFlags<QDialogButtonBox::StandardButton> buttons, Qt::Orientation orientation, QWidget *parent)
  QDialogButtonBox_Adaptor(QFlags<QDialogButtonBox::StandardButton> buttons, Qt::Orientation orientation) : QDialogButtonBox(buttons, orientation)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QDialogButtonBox::QDialogButtonBox(QFlags<QDialogButtonBox::StandardButton> buttons, Qt::Orientation orientation, QWidget *parent)
  QDialogButtonBox_Adaptor(QFlags<QDialogButtonBox::StandardButton> buttons, Qt::Orientation orientation, QWidget *parent) : QDialogButtonBox(buttons, orientation, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QDialogButtonBox::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QDialogButtonBox_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QDialogButtonBox::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  void QDialogButtonBox::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QDialogButtonBox_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QDialogButtonBox::destroy(destroyWindow, destroySubWindows);
  }

  //  bool QDialogButtonBox::focusNextChild()
  bool fp_QDialogButtonBox_focusNextChild_0 () {
    return QDialogButtonBox::focusNextChild();
  }

  //  bool QDialogButtonBox::focusPreviousChild()
  bool fp_QDialogButtonBox_focusPreviousChild_0 () {
    return QDialogButtonBox::focusPreviousChild();
  }

  //  int QDialogButtonBox::receivers(const char *signal)
  int fp_QDialogButtonBox_receivers_c1731 (const char *signal) const {
    return QDialogButtonBox::receivers(signal);
  }

  //  void QDialogButtonBox::resetInputContext()
  void fp_QDialogButtonBox_resetInputContext_0 () {
    QDialogButtonBox::resetInputContext();
  }

  //  QObject *QDialogButtonBox::sender()
  QObject * fp_QDialogButtonBox_sender_c0 () const {
    return QDialogButtonBox::sender();
  }

  //  void QDialogButtonBox::updateMicroFocus()
  void fp_QDialogButtonBox_updateMicroFocus_0 () {
    QDialogButtonBox::updateMicroFocus();
  }

  //  [adaptor impl] bool QDialogButtonBox::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QDialogButtonBox::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QDialogButtonBox_Adaptor, bool, QObject *, QEvent *>(&QDialogButtonBox_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QDialogButtonBox::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] int QDialogButtonBox::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QDialogButtonBox::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QDialogButtonBox_Adaptor, int, int>(&QDialogButtonBox_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QDialogButtonBox::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QDialogButtonBox::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QDialogButtonBox::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QDialogButtonBox_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QDialogButtonBox_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QDialogButtonBox::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QDialogButtonBox::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QDialogButtonBox::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QDialogButtonBox_Adaptor, QSize>(&QDialogButtonBox_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QDialogButtonBox::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QDialogButtonBox::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QDialogButtonBox::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QDialogButtonBox_Adaptor, QPaintEngine *>(&QDialogButtonBox_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QDialogButtonBox::paintEngine();
    }
  }

  //  [adaptor impl] void QDialogButtonBox::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QDialogButtonBox::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QDialogButtonBox_Adaptor, bool>(&QDialogButtonBox_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QDialogButtonBox::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QDialogButtonBox::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QDialogButtonBox::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QDialogButtonBox_Adaptor, QSize>(&QDialogButtonBox_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QDialogButtonBox::sizeHint();
    }
  }

  //  [adaptor impl] void QDialogButtonBox::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QDialogButtonBox::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QDialogButtonBox_Adaptor, QActionEvent *>(&QDialogButtonBox_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QDialogButtonBox::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::changeEvent(QEvent *event)
  void cbs_changeEvent_1217_0(QEvent *event)
  {
    QDialogButtonBox::changeEvent(event);
  }

  virtual void changeEvent(QEvent *event)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QDialogButtonBox_Adaptor, QEvent *>(&QDialogButtonBox_Adaptor::cbs_changeEvent_1217_0, event);
    } else {
      QDialogButtonBox::changeEvent(event);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QDialogButtonBox::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QDialogButtonBox_Adaptor, QChildEvent *>(&QDialogButtonBox_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QDialogButtonBox::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QDialogButtonBox::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QDialogButtonBox_Adaptor, QCloseEvent *>(&QDialogButtonBox_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QDialogButtonBox::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QDialogButtonBox::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QDialogButtonBox_Adaptor, QContextMenuEvent *>(&QDialogButtonBox_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QDialogButtonBox::contextMenuEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QDialogButtonBox::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QDialogButtonBox_Adaptor, QEvent *>(&QDialogButtonBox_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QDialogButtonBox::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QDialogButtonBox::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QDialogButtonBox_Adaptor, const char *>(&QDialogButtonBox_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QDialogButtonBox::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QDialogButtonBox::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QDialogButtonBox_Adaptor, QDragEnterEvent *>(&QDialogButtonBox_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QDialogButtonBox::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QDialogButtonBox::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QDialogButtonBox_Adaptor, QDragLeaveEvent *>(&QDialogButtonBox_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QDialogButtonBox::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QDialogButtonBox::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QDialogButtonBox_Adaptor, QDragMoveEvent *>(&QDialogButtonBox_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QDialogButtonBox::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QDialogButtonBox::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QDialogButtonBox_Adaptor, QDropEvent *>(&QDialogButtonBox_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QDialogButtonBox::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QDialogButtonBox::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QDialogButtonBox_Adaptor, bool>(&QDialogButtonBox_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QDialogButtonBox::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QDialogButtonBox::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QDialogButtonBox_Adaptor, QEvent *>(&QDialogButtonBox_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QDialogButtonBox::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QDialogButtonBox::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QDialogButtonBox::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QDialogButtonBox_Adaptor, bool, QEvent *>(&QDialogButtonBox_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QDialogButtonBox::event(_event);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::focusInEvent(QFocusEvent *)
  void cbs_focusInEvent_1729_0(QFocusEvent *arg1)
  {
    QDialogButtonBox::focusInEvent(arg1);
  }

  virtual void focusInEvent(QFocusEvent *arg1)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QDialogButtonBox_Adaptor, QFocusEvent *>(&QDialogButtonBox_Adaptor::cbs_focusInEvent_1729_0, arg1);
    } else {
      QDialogButtonBox::focusInEvent(arg1);
    }
  }

  //  [adaptor impl] bool QDialogButtonBox::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QDialogButtonBox::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QDialogButtonBox_Adaptor, bool, bool>(&QDialogButtonBox_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QDialogButtonBox::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::focusOutEvent(QFocusEvent *)
  void cbs_focusOutEvent_1729_0(QFocusEvent *arg1)
  {
    QDialogButtonBox::focusOutEvent(arg1);
  }

  virtual void focusOutEvent(QFocusEvent *arg1)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QDialogButtonBox_Adaptor, QFocusEvent *>(&QDialogButtonBox_Adaptor::cbs_focusOutEvent_1729_0, arg1);
    } else {
      QDialogButtonBox::focusOutEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QDialogButtonBox::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QDialogButtonBox_Adaptor, const QFont &>(&QDialogButtonBox_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QDialogButtonBox::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QDialogButtonBox::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QDialogButtonBox_Adaptor, QHideEvent *>(&QDialogButtonBox_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QDialogButtonBox::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QDialogButtonBox::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QDialogButtonBox_Adaptor, QInputMethodEvent *>(&QDialogButtonBox_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QDialogButtonBox::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QDialogButtonBox::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QDialogButtonBox_Adaptor, QKeyEvent *>(&QDialogButtonBox_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QDialogButtonBox::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QDialogButtonBox::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QDialogButtonBox_Adaptor, QKeyEvent *>(&QDialogButtonBox_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QDialogButtonBox::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::languageChange()
  void cbs_languageChange_0_0()
  {
    QDialogButtonBox::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QDialogButtonBox_Adaptor>(&QDialogButtonBox_Adaptor::cbs_languageChange_0_0);
    } else {
      QDialogButtonBox::languageChange();
    }
  }

  //  [adaptor impl] void QDialogButtonBox::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QDialogButtonBox::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QDialogButtonBox_Adaptor, QEvent *>(&QDialogButtonBox_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QDialogButtonBox::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QDialogButtonBox::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QDialogButtonBox::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QDialogButtonBox_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QDialogButtonBox_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QDialogButtonBox::metric(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QDialogButtonBox::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QDialogButtonBox_Adaptor, QMouseEvent *>(&QDialogButtonBox_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QDialogButtonBox::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QDialogButtonBox::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QDialogButtonBox_Adaptor, QMouseEvent *>(&QDialogButtonBox_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QDialogButtonBox::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QDialogButtonBox::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QDialogButtonBox_Adaptor, QMouseEvent *>(&QDialogButtonBox_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QDialogButtonBox::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QDialogButtonBox::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QDialogButtonBox_Adaptor, QMouseEvent *>(&QDialogButtonBox_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QDialogButtonBox::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QDialogButtonBox::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QDialogButtonBox_Adaptor, QMoveEvent *>(&QDialogButtonBox_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QDialogButtonBox::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::paintEvent(QPaintEvent *)
  void cbs_paintEvent_1725_0(QPaintEvent *arg1)
  {
    QDialogButtonBox::paintEvent(arg1);
  }

  virtual void paintEvent(QPaintEvent *arg1)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QDialogButtonBox_Adaptor, QPaintEvent *>(&QDialogButtonBox_Adaptor::cbs_paintEvent_1725_0, arg1);
    } else {
      QDialogButtonBox::paintEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QDialogButtonBox::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QDialogButtonBox_Adaptor, const QPalette &>(&QDialogButtonBox_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QDialogButtonBox::paletteChange(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::resizeEvent(QResizeEvent *)
  void cbs_resizeEvent_1843_0(QResizeEvent *arg1)
  {
    QDialogButtonBox::resizeEvent(arg1);
  }

  virtual void resizeEvent(QResizeEvent *arg1)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QDialogButtonBox_Adaptor, QResizeEvent *>(&QDialogButtonBox_Adaptor::cbs_resizeEvent_1843_0, arg1);
    } else {
      QDialogButtonBox::resizeEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QDialogButtonBox::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QDialogButtonBox_Adaptor, QShowEvent *>(&QDialogButtonBox_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QDialogButtonBox::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QDialogButtonBox::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QDialogButtonBox_Adaptor, QStyle &>(&QDialogButtonBox_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QDialogButtonBox::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QDialogButtonBox::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QDialogButtonBox_Adaptor, QTabletEvent *>(&QDialogButtonBox_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QDialogButtonBox::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QDialogButtonBox::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QDialogButtonBox_Adaptor, QTimerEvent *>(&QDialogButtonBox_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QDialogButtonBox::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QDialogButtonBox::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QDialogButtonBox_Adaptor, QWheelEvent *>(&QDialogButtonBox_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QDialogButtonBox::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QDialogButtonBox::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QDialogButtonBox_Adaptor, bool>(&QDialogButtonBox_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QDialogButtonBox::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QDialogButtonBox_Adaptor::~QDialogButtonBox_Adaptor() { }

//  Constructor QDialogButtonBox::QDialogButtonBox(QWidget *parent) (adaptor class)

static void _init_ctor_QDialogButtonBox_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QDialogButtonBox_Adaptor *> ();
}

static void _call_ctor_QDialogButtonBox_Adaptor_1315 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QDialogButtonBox_Adaptor *> (new QDialogButtonBox_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QDialogButtonBox_Adaptor_1315 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDialogButtonBox::QDialogButtonBox(QWidget *parent)\nThis method creates an object of class QDialogButtonBox.", &_init_ctor_QDialogButtonBox_Adaptor_1315, &_call_ctor_QDialogButtonBox_Adaptor_1315);
}

//  Constructor QDialogButtonBox::QDialogButtonBox(Qt::Orientation orientation, QWidget *parent) (adaptor class)

static void _init_ctor_QDialogButtonBox_Adaptor_3120 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return_new<QDialogButtonBox_Adaptor *> ();
}

static void _call_ctor_QDialogButtonBox_Adaptor_3120 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  QWidget *arg2 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QDialogButtonBox_Adaptor *> (new QDialogButtonBox_Adaptor (qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg1).cref(), arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QDialogButtonBox_Adaptor_3120 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDialogButtonBox::QDialogButtonBox(Qt::Orientation orientation, QWidget *parent)\nThis method creates an object of class QDialogButtonBox.", &_init_ctor_QDialogButtonBox_Adaptor_3120, &_call_ctor_QDialogButtonBox_Adaptor_3120);
}

//  Constructor QDialogButtonBox::QDialogButtonBox(QFlags<QDialogButtonBox::StandardButton> buttons, Qt::Orientation orientation, QWidget *parent) (adaptor class)

static void _init_ctor_QDialogButtonBox_Adaptor_7319 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("buttons");
  decl->add_arg<const qt_gsi::Converter<QFlags<QDialogButtonBox::StandardButton> >::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation", true, "Qt::Horizontal");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return_new<QDialogButtonBox_Adaptor *> ();
}

static void _call_ctor_QDialogButtonBox_Adaptor_7319 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QDialogButtonBox::StandardButton> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QDialogButtonBox::StandardButton> >::target_type & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > () : (const qt_gsi::Converter<Qt::Orientation>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::Orientation>(heap, Qt::Horizontal));
  QWidget *arg3 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QDialogButtonBox_Adaptor *> (new QDialogButtonBox_Adaptor (qt_gsi::QtToCppAdaptor<QFlags<QDialogButtonBox::StandardButton> >(arg1).cref(), qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg2).cref(), arg3));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QDialogButtonBox_Adaptor_7319 ()
{
  return new qt_gsi::GenericStaticMethod ("new_buttons", "@brief Constructor QDialogButtonBox::QDialogButtonBox(QFlags<QDialogButtonBox::StandardButton> buttons, Qt::Orientation orientation, QWidget *parent)\nThis method creates an object of class QDialogButtonBox.", &_init_ctor_QDialogButtonBox_Adaptor_7319, &_call_ctor_QDialogButtonBox_Adaptor_7319);
}

// void QDialogButtonBox::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<WId>::target_type & > () : (const qt_gsi::Converter<WId>::target_type &)(qt_gsi::CppToQtReadAdaptor<WId>(heap, 0));
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  bool arg3 = args ? args.read<bool > () : (bool)(true);
  ((QDialogButtonBox_Adaptor *)cls)->fp_QDialogButtonBox_create_2208 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_create_2208 ()
{
  return new qt_gsi::GenericMethod("*qt_create", "@brief Method void QDialogButtonBox::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
}


// void QDialogButtonBox::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QDialogButtonBox_Adaptor *)cls)->fp_QDialogButtonBox_destroy_1620 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_destroy_1620 ()
{
  return new qt_gsi::GenericMethod("*qt_destroy", "@brief Method void QDialogButtonBox::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
}


// bool QDialogButtonBox::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDialogButtonBox_Adaptor *)cls)->fp_QDialogButtonBox_focusNextChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusNextChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusNextChild", "@brief Method bool QDialogButtonBox::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
}


// bool QDialogButtonBox::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDialogButtonBox_Adaptor *)cls)->fp_QDialogButtonBox_focusPreviousChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusPreviousChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusPreviousChild", "@brief Method bool QDialogButtonBox::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
}


// int QDialogButtonBox::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QDialogButtonBox_Adaptor *)cls)->fp_QDialogButtonBox_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QDialogButtonBox::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QDialogButtonBox::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QDialogButtonBox_Adaptor *)cls)->fp_QDialogButtonBox_resetInputContext_0 ();
}

static qt_gsi::GenericMethod*_create_fp_resetInputContext_0 ()
{
  return new qt_gsi::GenericMethod("*resetInputContext", "@brief Method void QDialogButtonBox::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
}


// QObject *QDialogButtonBox::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QDialogButtonBox_Adaptor *)cls)->fp_QDialogButtonBox_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QDialogButtonBox::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QDialogButtonBox::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QDialogButtonBox_Adaptor *)cls)->fp_QDialogButtonBox_updateMicroFocus_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateMicroFocus_0 ()
{
  return new qt_gsi::GenericMethod("*updateMicroFocus", "@brief Method void QDialogButtonBox::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
}


// bool QDialogButtonBox::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QDialogButtonBox_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QDialogButtonBox::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// int QDialogButtonBox::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QDialogButtonBox_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QDialogButtonBox::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// QVariant QDialogButtonBox::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QDialogButtonBox_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QDialogButtonBox::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// QSize QDialogButtonBox::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QDialogButtonBox_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QDialogButtonBox::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
}


// QPaintEngine *QDialogButtonBox::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QDialogButtonBox_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QDialogButtonBox::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
}


// void QDialogButtonBox::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QDialogButtonBox::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
}


// QSize QDialogButtonBox::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QDialogButtonBox_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QDialogButtonBox::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// void QDialogButtonBox::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QActionEvent *arg1 = args.read<QActionEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QDialogButtonBox::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
}


// void QDialogButtonBox::changeEvent(QEvent *event)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QDialogButtonBox::changeEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
}


// void QDialogButtonBox::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QDialogButtonBox::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QDialogButtonBox::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCloseEvent *arg1 = args.read<QCloseEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QDialogButtonBox::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
}


// void QDialogButtonBox::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QDialogButtonBox::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
}


// void QDialogButtonBox::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QDialogButtonBox::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QDialogButtonBox::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QDialogButtonBox::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QDialogButtonBox::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QDialogButtonBox::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
}


// void QDialogButtonBox::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QDialogButtonBox::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
}


// void QDialogButtonBox::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QDialogButtonBox::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
}


// void QDialogButtonBox::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDropEvent *arg1 = args.read<QDropEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QDialogButtonBox::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
}


// void QDialogButtonBox::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QDialogButtonBox::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
}


// void QDialogButtonBox::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QDialogButtonBox::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
}


// bool QDialogButtonBox::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QDialogButtonBox_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QDialogButtonBox::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// void QDialogButtonBox::focusInEvent(QFocusEvent *)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QDialogButtonBox::focusInEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// bool QDialogButtonBox::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<bool > ((bool)((QDialogButtonBox_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QDialogButtonBox::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
}


// void QDialogButtonBox::focusOutEvent(QFocusEvent *)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QDialogButtonBox::focusOutEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QDialogButtonBox::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QDialogButtonBox::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
}


// void QDialogButtonBox::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QHideEvent *arg1 = args.read<QHideEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QDialogButtonBox::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
}


// void QDialogButtonBox::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QDialogButtonBox::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// void QDialogButtonBox::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QDialogButtonBox::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QDialogButtonBox::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QDialogButtonBox::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QDialogButtonBox::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QDialogButtonBox_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QDialogButtonBox::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
}


// void QDialogButtonBox::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QDialogButtonBox::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
}


// int QDialogButtonBox::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QDialogButtonBox_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QDialogButtonBox::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
}


// void QDialogButtonBox::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QDialogButtonBox::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
}


// void QDialogButtonBox::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QDialogButtonBox::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
}


// void QDialogButtonBox::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QDialogButtonBox::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
}


// void QDialogButtonBox::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QDialogButtonBox::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
}


// void QDialogButtonBox::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMoveEvent *arg1 = args.read<QMoveEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QDialogButtonBox::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
}


// void QDialogButtonBox::paintEvent(QPaintEvent *)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintEvent *arg1 = args.read<QPaintEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QDialogButtonBox::paintEvent(QPaintEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
}


// void QDialogButtonBox::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QDialogButtonBox::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
}


// void QDialogButtonBox::resizeEvent(QResizeEvent *)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QResizeEvent *arg1 = args.read<QResizeEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QDialogButtonBox::resizeEvent(QResizeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
}


// void QDialogButtonBox::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QShowEvent *arg1 = args.read<QShowEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QDialogButtonBox::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
}


// void QDialogButtonBox::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle &arg1 = args.read<QStyle & > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QDialogButtonBox::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
}


// void QDialogButtonBox::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTabletEvent *arg1 = args.read<QTabletEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QDialogButtonBox::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
}


// void QDialogButtonBox::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QDialogButtonBox::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


// void QDialogButtonBox::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWheelEvent *arg1 = args.read<QWheelEvent * > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QDialogButtonBox::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
}


// void QDialogButtonBox::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QDialogButtonBox_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QDialogButtonBox::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
}


namespace gsi
{

extern gsi::Class<QDialogButtonBox> decl_QDialogButtonBox;

gsi::Class<QDialogButtonBox_Adaptor> decl_QDialogButtonBox_Adaptor (decl_QDialogButtonBox, "QDialogButtonBox",
  gsi::Methods(_create_fp_create_2208 ()) +
  gsi::Methods(_create_fp_destroy_1620 ()) +
  gsi::Methods(_create_fp_focusNextChild_0 ()) +
  gsi::Methods(_create_fp_focusPreviousChild_0 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_resetInputContext_0 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_updateMicroFocus_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_callback_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_callback_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_callback_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_callback_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_callback_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_callback_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_callback_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_callback_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_callback_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_callback_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_callback_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_ctor_QDialogButtonBox_Adaptor_1315 ()) +
  gsi::Methods(_create_ctor_QDialogButtonBox_Adaptor_3120 ()) +
  gsi::Methods(_create_ctor_QDialogButtonBox_Adaptor_7319 ()),
  "@qt\n@brief Binding of QDialogButtonBox");

}


//  Implementation of the enum wrapper class for QDialogButtonBox::ButtonRole
namespace qt_gsi
{

static QDialogButtonBox_ButtonRole_Enum *c_1_QDialogButtonBox_ButtonRole_Enum () { return new QDialogButtonBox_ButtonRole_Enum (QDialogButtonBox::InvalidRole); }
static QDialogButtonBox_ButtonRole_Enum *c_2_QDialogButtonBox_ButtonRole_Enum () { return new QDialogButtonBox_ButtonRole_Enum (QDialogButtonBox::AcceptRole); }
static QDialogButtonBox_ButtonRole_Enum *c_3_QDialogButtonBox_ButtonRole_Enum () { return new QDialogButtonBox_ButtonRole_Enum (QDialogButtonBox::RejectRole); }
static QDialogButtonBox_ButtonRole_Enum *c_4_QDialogButtonBox_ButtonRole_Enum () { return new QDialogButtonBox_ButtonRole_Enum (QDialogButtonBox::DestructiveRole); }
static QDialogButtonBox_ButtonRole_Enum *c_5_QDialogButtonBox_ButtonRole_Enum () { return new QDialogButtonBox_ButtonRole_Enum (QDialogButtonBox::ActionRole); }
static QDialogButtonBox_ButtonRole_Enum *c_6_QDialogButtonBox_ButtonRole_Enum () { return new QDialogButtonBox_ButtonRole_Enum (QDialogButtonBox::HelpRole); }
static QDialogButtonBox_ButtonRole_Enum *c_7_QDialogButtonBox_ButtonRole_Enum () { return new QDialogButtonBox_ButtonRole_Enum (QDialogButtonBox::YesRole); }
static QDialogButtonBox_ButtonRole_Enum *c_8_QDialogButtonBox_ButtonRole_Enum () { return new QDialogButtonBox_ButtonRole_Enum (QDialogButtonBox::NoRole); }
static QDialogButtonBox_ButtonRole_Enum *c_9_QDialogButtonBox_ButtonRole_Enum () { return new QDialogButtonBox_ButtonRole_Enum (QDialogButtonBox::ResetRole); }
static QDialogButtonBox_ButtonRole_Enum *c_10_QDialogButtonBox_ButtonRole_Enum () { return new QDialogButtonBox_ButtonRole_Enum (QDialogButtonBox::ApplyRole); }
static QDialogButtonBox_ButtonRole_Enum *c_11_QDialogButtonBox_ButtonRole_Enum () { return new QDialogButtonBox_ButtonRole_Enum (QDialogButtonBox::NRoles); }

static gsi::Methods mkdefs_QDialogButtonBox_ButtonRole () {
  return
    gsi::constant ("InvalidRole", &qt_gsi::c_1_QDialogButtonBox_ButtonRole_Enum, "@brief Enum constant QDialogButtonBox::InvalidRole") +
    gsi::constant ("AcceptRole", &qt_gsi::c_2_QDialogButtonBox_ButtonRole_Enum, "@brief Enum constant QDialogButtonBox::AcceptRole") +
    gsi::constant ("RejectRole", &qt_gsi::c_3_QDialogButtonBox_ButtonRole_Enum, "@brief Enum constant QDialogButtonBox::RejectRole") +
    gsi::constant ("DestructiveRole", &qt_gsi::c_4_QDialogButtonBox_ButtonRole_Enum, "@brief Enum constant QDialogButtonBox::DestructiveRole") +
    gsi::constant ("ActionRole", &qt_gsi::c_5_QDialogButtonBox_ButtonRole_Enum, "@brief Enum constant QDialogButtonBox::ActionRole") +
    gsi::constant ("HelpRole", &qt_gsi::c_6_QDialogButtonBox_ButtonRole_Enum, "@brief Enum constant QDialogButtonBox::HelpRole") +
    gsi::constant ("YesRole", &qt_gsi::c_7_QDialogButtonBox_ButtonRole_Enum, "@brief Enum constant QDialogButtonBox::YesRole") +
    gsi::constant ("NoRole", &qt_gsi::c_8_QDialogButtonBox_ButtonRole_Enum, "@brief Enum constant QDialogButtonBox::NoRole") +
    gsi::constant ("ResetRole", &qt_gsi::c_9_QDialogButtonBox_ButtonRole_Enum, "@brief Enum constant QDialogButtonBox::ResetRole") +
    gsi::constant ("ApplyRole", &qt_gsi::c_10_QDialogButtonBox_ButtonRole_Enum, "@brief Enum constant QDialogButtonBox::ApplyRole") +
    gsi::constant ("NRoles", &qt_gsi::c_11_QDialogButtonBox_ButtonRole_Enum, "@brief Enum constant QDialogButtonBox::NRoles");
}

static std::string to_s_QDialogButtonBox_ButtonRole_Enum (const QDialogButtonBox_ButtonRole_Enum *e)
{
  if (e->value () == QDialogButtonBox::InvalidRole) { return tl::sprintf ("InvalidRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::AcceptRole) { return tl::sprintf ("AcceptRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::RejectRole) { return tl::sprintf ("RejectRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::DestructiveRole) { return tl::sprintf ("DestructiveRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::ActionRole) { return tl::sprintf ("ActionRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::HelpRole) { return tl::sprintf ("HelpRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::YesRole) { return tl::sprintf ("YesRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::NoRole) { return tl::sprintf ("NoRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::ResetRole) { return tl::sprintf ("ResetRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::ApplyRole) { return tl::sprintf ("ApplyRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::NRoles) { return tl::sprintf ("NRoles (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QDialogButtonBox_ButtonRole_Enum (const QDialogButtonBox_ButtonRole_Enum *e)
{
  return (unsigned int) e->value ();
}

static QDialogButtonBox_ButtonRole_Enum *from_i_QDialogButtonBox_ButtonRole_Enum (unsigned int i)
{
  return new QDialogButtonBox_ButtonRole_Enum ((QDialogButtonBox::ButtonRole) i);
}

static bool equalQDialogButtonBox_ButtonRole_Enum (const QDialogButtonBox_ButtonRole_Enum *e, QDialogButtonBox_ButtonRole_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QDialogButtonBox_ButtonRole_Enum (const QDialogButtonBox_ButtonRole_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QDialogButtonBox_ButtonRole_Enums oropQDialogButtonBox_ButtonRole_Enums (const QDialogButtonBox_ButtonRole_Enums *e, const QDialogButtonBox_ButtonRole_Enums &d)
{
  return e->flags () | d.flags ();
}

static QDialogButtonBox_ButtonRole_Enums andopQDialogButtonBox_ButtonRole_Enums (const QDialogButtonBox_ButtonRole_Enums *e, const QDialogButtonBox_ButtonRole_Enums &d)
{
  return e->flags () & d.flags ();
}

static QDialogButtonBox_ButtonRole_Enums xoropQDialogButtonBox_ButtonRole_Enums (const QDialogButtonBox_ButtonRole_Enums *e, const QDialogButtonBox_ButtonRole_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QDialogButtonBox_ButtonRole_Enums (const QDialogButtonBox_ButtonRole_Enums *e)
{
  std::string l;
  if (e->testFlag (QDialogButtonBox::InvalidRole)) { if (!l.empty ()) l += "|"; l += "InvalidRole"; }
  if (e->testFlag (QDialogButtonBox::AcceptRole)) { if (!l.empty ()) l += "|"; l += "AcceptRole"; }
  if (e->testFlag (QDialogButtonBox::RejectRole)) { if (!l.empty ()) l += "|"; l += "RejectRole"; }
  if (e->testFlag (QDialogButtonBox::DestructiveRole)) { if (!l.empty ()) l += "|"; l += "DestructiveRole"; }
  if (e->testFlag (QDialogButtonBox::ActionRole)) { if (!l.empty ()) l += "|"; l += "ActionRole"; }
  if (e->testFlag (QDialogButtonBox::HelpRole)) { if (!l.empty ()) l += "|"; l += "HelpRole"; }
  if (e->testFlag (QDialogButtonBox::YesRole)) { if (!l.empty ()) l += "|"; l += "YesRole"; }
  if (e->testFlag (QDialogButtonBox::NoRole)) { if (!l.empty ()) l += "|"; l += "NoRole"; }
  if (e->testFlag (QDialogButtonBox::ResetRole)) { if (!l.empty ()) l += "|"; l += "ResetRole"; }
  if (e->testFlag (QDialogButtonBox::ApplyRole)) { if (!l.empty ()) l += "|"; l += "ApplyRole"; }
  if (e->testFlag (QDialogButtonBox::NRoles)) { if (!l.empty ()) l += "|"; l += "NRoles"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QDialogButtonBox_ButtonRole_Enums (const QDialogButtonBox_ButtonRole_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QDialogButtonBox_ButtonRole_Enums (const QDialogButtonBox_ButtonRole_Enums *e, const QDialogButtonBox_ButtonRole_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QDialogButtonBox_ButtonRole_Enums> decl_QDialogButtonBox_ButtonRole_Enums ("QDialogButtonBox_QFlags_ButtonRole",
  gsi::method_ext ("|", &qt_gsi::oropQDialogButtonBox_ButtonRole_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQDialogButtonBox_ButtonRole_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQDialogButtonBox_ButtonRole_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QDialogButtonBox_ButtonRole_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QDialogButtonBox_ButtonRole_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QDialogButtonBox_ButtonRole_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QDialogButtonBox::ButtonRole> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QDialogButtonBox_ButtonRole_Enum> decl_QDialogButtonBox_ButtonRole_Enum (decl_QDialogButtonBox_ButtonRole_Enums, "QDialogButtonBox_ButtonRole",
  qt_gsi::mkdefs_QDialogButtonBox_ButtonRole () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QDialogButtonBox_ButtonRole_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QDialogButtonBox_ButtonRole_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQDialogButtonBox_ButtonRole_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QDialogButtonBox_ButtonRole_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QDialogButtonBox_ButtonRole_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QDialogButtonBox::ButtonRole enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QDialogButtonBox> inject_QDialogButtonBox_ButtonRole_Enum_in_parent (qt_gsi::mkdefs_QDialogButtonBox_ButtonRole ());
static gsi::ClassExt<QDialogButtonBox> decl_QDialogButtonBox_ButtonRole_Enum_as_child (decl_QDialogButtonBox_ButtonRole_Enum, "ButtonRole");

}


//  Implementation of the enum wrapper class for QDialogButtonBox::StandardButton
namespace qt_gsi
{

static QDialogButtonBox_StandardButton_Enum *c_1_QDialogButtonBox_StandardButton_Enum () { return new QDialogButtonBox_StandardButton_Enum (QDialogButtonBox::NoButton); }
static QDialogButtonBox_StandardButton_Enum *c_2_QDialogButtonBox_StandardButton_Enum () { return new QDialogButtonBox_StandardButton_Enum (QDialogButtonBox::Ok); }
static QDialogButtonBox_StandardButton_Enum *c_3_QDialogButtonBox_StandardButton_Enum () { return new QDialogButtonBox_StandardButton_Enum (QDialogButtonBox::Save); }
static QDialogButtonBox_StandardButton_Enum *c_4_QDialogButtonBox_StandardButton_Enum () { return new QDialogButtonBox_StandardButton_Enum (QDialogButtonBox::SaveAll); }
static QDialogButtonBox_StandardButton_Enum *c_5_QDialogButtonBox_StandardButton_Enum () { return new QDialogButtonBox_StandardButton_Enum (QDialogButtonBox::Open); }
static QDialogButtonBox_StandardButton_Enum *c_6_QDialogButtonBox_StandardButton_Enum () { return new QDialogButtonBox_StandardButton_Enum (QDialogButtonBox::Yes); }
static QDialogButtonBox_StandardButton_Enum *c_7_QDialogButtonBox_StandardButton_Enum () { return new QDialogButtonBox_StandardButton_Enum (QDialogButtonBox::YesToAll); }
static QDialogButtonBox_StandardButton_Enum *c_8_QDialogButtonBox_StandardButton_Enum () { return new QDialogButtonBox_StandardButton_Enum (QDialogButtonBox::No); }
static QDialogButtonBox_StandardButton_Enum *c_9_QDialogButtonBox_StandardButton_Enum () { return new QDialogButtonBox_StandardButton_Enum (QDialogButtonBox::NoToAll); }
static QDialogButtonBox_StandardButton_Enum *c_10_QDialogButtonBox_StandardButton_Enum () { return new QDialogButtonBox_StandardButton_Enum (QDialogButtonBox::Abort); }
static QDialogButtonBox_StandardButton_Enum *c_11_QDialogButtonBox_StandardButton_Enum () { return new QDialogButtonBox_StandardButton_Enum (QDialogButtonBox::Retry); }
static QDialogButtonBox_StandardButton_Enum *c_12_QDialogButtonBox_StandardButton_Enum () { return new QDialogButtonBox_StandardButton_Enum (QDialogButtonBox::Ignore); }
static QDialogButtonBox_StandardButton_Enum *c_13_QDialogButtonBox_StandardButton_Enum () { return new QDialogButtonBox_StandardButton_Enum (QDialogButtonBox::Close); }
static QDialogButtonBox_StandardButton_Enum *c_14_QDialogButtonBox_StandardButton_Enum () { return new QDialogButtonBox_StandardButton_Enum (QDialogButtonBox::Cancel); }
static QDialogButtonBox_StandardButton_Enum *c_15_QDialogButtonBox_StandardButton_Enum () { return new QDialogButtonBox_StandardButton_Enum (QDialogButtonBox::Discard); }
static QDialogButtonBox_StandardButton_Enum *c_16_QDialogButtonBox_StandardButton_Enum () { return new QDialogButtonBox_StandardButton_Enum (QDialogButtonBox::Help); }
static QDialogButtonBox_StandardButton_Enum *c_17_QDialogButtonBox_StandardButton_Enum () { return new QDialogButtonBox_StandardButton_Enum (QDialogButtonBox::Apply); }
static QDialogButtonBox_StandardButton_Enum *c_18_QDialogButtonBox_StandardButton_Enum () { return new QDialogButtonBox_StandardButton_Enum (QDialogButtonBox::Reset); }
static QDialogButtonBox_StandardButton_Enum *c_19_QDialogButtonBox_StandardButton_Enum () { return new QDialogButtonBox_StandardButton_Enum (QDialogButtonBox::RestoreDefaults); }
static QDialogButtonBox_StandardButton_Enum *c_20_QDialogButtonBox_StandardButton_Enum () { return new QDialogButtonBox_StandardButton_Enum (QDialogButtonBox::FirstButton); }
static QDialogButtonBox_StandardButton_Enum *c_21_QDialogButtonBox_StandardButton_Enum () { return new QDialogButtonBox_StandardButton_Enum (QDialogButtonBox::LastButton); }

static gsi::Methods mkdefs_QDialogButtonBox_StandardButton () {
  return
    gsi::constant ("NoButton", &qt_gsi::c_1_QDialogButtonBox_StandardButton_Enum, "@brief Enum constant QDialogButtonBox::NoButton") +
    gsi::constant ("Ok", &qt_gsi::c_2_QDialogButtonBox_StandardButton_Enum, "@brief Enum constant QDialogButtonBox::Ok") +
    gsi::constant ("Save", &qt_gsi::c_3_QDialogButtonBox_StandardButton_Enum, "@brief Enum constant QDialogButtonBox::Save") +
    gsi::constant ("SaveAll", &qt_gsi::c_4_QDialogButtonBox_StandardButton_Enum, "@brief Enum constant QDialogButtonBox::SaveAll") +
    gsi::constant ("Open", &qt_gsi::c_5_QDialogButtonBox_StandardButton_Enum, "@brief Enum constant QDialogButtonBox::Open") +
    gsi::constant ("Yes", &qt_gsi::c_6_QDialogButtonBox_StandardButton_Enum, "@brief Enum constant QDialogButtonBox::Yes") +
    gsi::constant ("YesToAll", &qt_gsi::c_7_QDialogButtonBox_StandardButton_Enum, "@brief Enum constant QDialogButtonBox::YesToAll") +
    gsi::constant ("No", &qt_gsi::c_8_QDialogButtonBox_StandardButton_Enum, "@brief Enum constant QDialogButtonBox::No") +
    gsi::constant ("NoToAll", &qt_gsi::c_9_QDialogButtonBox_StandardButton_Enum, "@brief Enum constant QDialogButtonBox::NoToAll") +
    gsi::constant ("Abort", &qt_gsi::c_10_QDialogButtonBox_StandardButton_Enum, "@brief Enum constant QDialogButtonBox::Abort") +
    gsi::constant ("Retry", &qt_gsi::c_11_QDialogButtonBox_StandardButton_Enum, "@brief Enum constant QDialogButtonBox::Retry") +
    gsi::constant ("Ignore", &qt_gsi::c_12_QDialogButtonBox_StandardButton_Enum, "@brief Enum constant QDialogButtonBox::Ignore") +
    gsi::constant ("Close", &qt_gsi::c_13_QDialogButtonBox_StandardButton_Enum, "@brief Enum constant QDialogButtonBox::Close") +
    gsi::constant ("Cancel", &qt_gsi::c_14_QDialogButtonBox_StandardButton_Enum, "@brief Enum constant QDialogButtonBox::Cancel") +
    gsi::constant ("Discard", &qt_gsi::c_15_QDialogButtonBox_StandardButton_Enum, "@brief Enum constant QDialogButtonBox::Discard") +
    gsi::constant ("Help", &qt_gsi::c_16_QDialogButtonBox_StandardButton_Enum, "@brief Enum constant QDialogButtonBox::Help") +
    gsi::constant ("Apply", &qt_gsi::c_17_QDialogButtonBox_StandardButton_Enum, "@brief Enum constant QDialogButtonBox::Apply") +
    gsi::constant ("Reset", &qt_gsi::c_18_QDialogButtonBox_StandardButton_Enum, "@brief Enum constant QDialogButtonBox::Reset") +
    gsi::constant ("RestoreDefaults", &qt_gsi::c_19_QDialogButtonBox_StandardButton_Enum, "@brief Enum constant QDialogButtonBox::RestoreDefaults") +
    gsi::constant ("FirstButton", &qt_gsi::c_20_QDialogButtonBox_StandardButton_Enum, "@brief Enum constant QDialogButtonBox::FirstButton") +
    gsi::constant ("LastButton", &qt_gsi::c_21_QDialogButtonBox_StandardButton_Enum, "@brief Enum constant QDialogButtonBox::LastButton");
}

static std::string to_s_QDialogButtonBox_StandardButton_Enum (const QDialogButtonBox_StandardButton_Enum *e)
{
  if (e->value () == QDialogButtonBox::NoButton) { return tl::sprintf ("NoButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::Ok) { return tl::sprintf ("Ok (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::Save) { return tl::sprintf ("Save (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::SaveAll) { return tl::sprintf ("SaveAll (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::Open) { return tl::sprintf ("Open (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::Yes) { return tl::sprintf ("Yes (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::YesToAll) { return tl::sprintf ("YesToAll (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::No) { return tl::sprintf ("No (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::NoToAll) { return tl::sprintf ("NoToAll (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::Abort) { return tl::sprintf ("Abort (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::Retry) { return tl::sprintf ("Retry (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::Ignore) { return tl::sprintf ("Ignore (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::Close) { return tl::sprintf ("Close (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::Cancel) { return tl::sprintf ("Cancel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::Discard) { return tl::sprintf ("Discard (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::Help) { return tl::sprintf ("Help (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::Apply) { return tl::sprintf ("Apply (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::Reset) { return tl::sprintf ("Reset (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::RestoreDefaults) { return tl::sprintf ("RestoreDefaults (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::FirstButton) { return tl::sprintf ("FirstButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDialogButtonBox::LastButton) { return tl::sprintf ("LastButton (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QDialogButtonBox_StandardButton_Enum (const QDialogButtonBox_StandardButton_Enum *e)
{
  return (unsigned int) e->value ();
}

static QDialogButtonBox_StandardButton_Enum *from_i_QDialogButtonBox_StandardButton_Enum (unsigned int i)
{
  return new QDialogButtonBox_StandardButton_Enum ((QDialogButtonBox::StandardButton) i);
}

static bool equalQDialogButtonBox_StandardButton_Enum (const QDialogButtonBox_StandardButton_Enum *e, QDialogButtonBox_StandardButton_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QDialogButtonBox_StandardButton_Enum (const QDialogButtonBox_StandardButton_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QDialogButtonBox_StandardButton_Enums oropQDialogButtonBox_StandardButton_Enums (const QDialogButtonBox_StandardButton_Enums *e, const QDialogButtonBox_StandardButton_Enums &d)
{
  return e->flags () | d.flags ();
}

static QDialogButtonBox_StandardButton_Enums andopQDialogButtonBox_StandardButton_Enums (const QDialogButtonBox_StandardButton_Enums *e, const QDialogButtonBox_StandardButton_Enums &d)
{
  return e->flags () & d.flags ();
}

static QDialogButtonBox_StandardButton_Enums xoropQDialogButtonBox_StandardButton_Enums (const QDialogButtonBox_StandardButton_Enums *e, const QDialogButtonBox_StandardButton_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QDialogButtonBox_StandardButton_Enums (const QDialogButtonBox_StandardButton_Enums *e)
{
  std::string l;
  if (e->testFlag (QDialogButtonBox::NoButton)) { if (!l.empty ()) l += "|"; l += "NoButton"; }
  if (e->testFlag (QDialogButtonBox::Ok)) { if (!l.empty ()) l += "|"; l += "Ok"; }
  if (e->testFlag (QDialogButtonBox::Save)) { if (!l.empty ()) l += "|"; l += "Save"; }
  if (e->testFlag (QDialogButtonBox::SaveAll)) { if (!l.empty ()) l += "|"; l += "SaveAll"; }
  if (e->testFlag (QDialogButtonBox::Open)) { if (!l.empty ()) l += "|"; l += "Open"; }
  if (e->testFlag (QDialogButtonBox::Yes)) { if (!l.empty ()) l += "|"; l += "Yes"; }
  if (e->testFlag (QDialogButtonBox::YesToAll)) { if (!l.empty ()) l += "|"; l += "YesToAll"; }
  if (e->testFlag (QDialogButtonBox::No)) { if (!l.empty ()) l += "|"; l += "No"; }
  if (e->testFlag (QDialogButtonBox::NoToAll)) { if (!l.empty ()) l += "|"; l += "NoToAll"; }
  if (e->testFlag (QDialogButtonBox::Abort)) { if (!l.empty ()) l += "|"; l += "Abort"; }
  if (e->testFlag (QDialogButtonBox::Retry)) { if (!l.empty ()) l += "|"; l += "Retry"; }
  if (e->testFlag (QDialogButtonBox::Ignore)) { if (!l.empty ()) l += "|"; l += "Ignore"; }
  if (e->testFlag (QDialogButtonBox::Close)) { if (!l.empty ()) l += "|"; l += "Close"; }
  if (e->testFlag (QDialogButtonBox::Cancel)) { if (!l.empty ()) l += "|"; l += "Cancel"; }
  if (e->testFlag (QDialogButtonBox::Discard)) { if (!l.empty ()) l += "|"; l += "Discard"; }
  if (e->testFlag (QDialogButtonBox::Help)) { if (!l.empty ()) l += "|"; l += "Help"; }
  if (e->testFlag (QDialogButtonBox::Apply)) { if (!l.empty ()) l += "|"; l += "Apply"; }
  if (e->testFlag (QDialogButtonBox::Reset)) { if (!l.empty ()) l += "|"; l += "Reset"; }
  if (e->testFlag (QDialogButtonBox::RestoreDefaults)) { if (!l.empty ()) l += "|"; l += "RestoreDefaults"; }
  if (e->testFlag (QDialogButtonBox::FirstButton)) { if (!l.empty ()) l += "|"; l += "FirstButton"; }
  if (e->testFlag (QDialogButtonBox::LastButton)) { if (!l.empty ()) l += "|"; l += "LastButton"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QDialogButtonBox_StandardButton_Enums (const QDialogButtonBox_StandardButton_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QDialogButtonBox_StandardButton_Enums (const QDialogButtonBox_StandardButton_Enums *e, const QDialogButtonBox_StandardButton_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QDialogButtonBox_StandardButton_Enums> decl_QDialogButtonBox_StandardButton_Enums ("QDialogButtonBox_QFlags_StandardButton",
  gsi::method_ext ("|", &qt_gsi::oropQDialogButtonBox_StandardButton_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQDialogButtonBox_StandardButton_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQDialogButtonBox_StandardButton_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QDialogButtonBox_StandardButton_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QDialogButtonBox_StandardButton_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QDialogButtonBox_StandardButton_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QDialogButtonBox::StandardButton> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QDialogButtonBox_StandardButton_Enum> decl_QDialogButtonBox_StandardButton_Enum (decl_QDialogButtonBox_StandardButton_Enums, "QDialogButtonBox_StandardButton",
  qt_gsi::mkdefs_QDialogButtonBox_StandardButton () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QDialogButtonBox_StandardButton_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QDialogButtonBox_StandardButton_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQDialogButtonBox_StandardButton_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QDialogButtonBox_StandardButton_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QDialogButtonBox_StandardButton_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QDialogButtonBox::StandardButton enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QDialogButtonBox> inject_QDialogButtonBox_StandardButton_Enum_in_parent (qt_gsi::mkdefs_QDialogButtonBox_StandardButton ());
static gsi::ClassExt<QDialogButtonBox> decl_QDialogButtonBox_StandardButton_Enum_as_child (decl_QDialogButtonBox_StandardButton_Enum, "StandardButton");

}

