
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQComboBox.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQComboBox_EventAdaptor.h"
#include "gsiDeclQComboBox_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QComboBox

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QComboBox::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// void QComboBox::addItem(const QString &text, const QVariant &userData)


static void _init_f_addItem_4036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("userData", true, "QVariant()");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addItem_4036 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QVariant &arg2 = args ? args.read<const QVariant & > () : (const QVariant &)(QVariant());
  ((QComboBox *)cls)->addItem (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_addItem_4036 ()
{
  return new qt_gsi::GenericMethod ("addItem", "@brief Method void QComboBox::addItem(const QString &text, const QVariant &userData)\n", false, &_init_f_addItem_4036, &_call_f_addItem_4036);
}

// void QComboBox::addItem(const QIcon &icon, const QString &text, const QVariant &userData)


static void _init_f_addItem_5715 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("userData", true, "QVariant()");
  decl->add_arg<const QVariant & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_addItem_5715 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QIcon &arg1 = args.read<const QIcon & > ();
  const QString &arg2 = args.read<const QString & > ();
  const QVariant &arg3 = args ? args.read<const QVariant & > () : (const QVariant &)(QVariant());
  ((QComboBox *)cls)->addItem (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_addItem_5715 ()
{
  return new qt_gsi::GenericMethod ("addItem", "@brief Method void QComboBox::addItem(const QIcon &icon, const QString &text, const QVariant &userData)\n", false, &_init_f_addItem_5715, &_call_f_addItem_5715);
}

// void QComboBox::addItems(const QStringList &texts)


static void _init_f_addItems_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("texts");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addItems_2437 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStringList>::target_type & arg1 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  ((QComboBox *)cls)->addItems (qt_gsi::QtToCppAdaptor<QStringList>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_addItems_2437 ()
{
  return new qt_gsi::GenericMethod ("addItems", "@brief Method void QComboBox::addItems(const QStringList &texts)\n", false, &_init_f_addItems_2437, &_call_f_addItems_2437);
}

// bool QComboBox::autoCompletion()


static void _init_f_autoCompletion_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_autoCompletion_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QComboBox *)cls)->autoCompletion ());
}

static qt_gsi::GenericMethod *_create_f_autoCompletion_c0 ()
{
  return new qt_gsi::GenericMethod (":autoCompletion", "@brief Method bool QComboBox::autoCompletion()\n", true, &_init_f_autoCompletion_c0, &_call_f_autoCompletion_c0);
}

// Qt::CaseSensitivity QComboBox::autoCompletionCaseSensitivity()


static void _init_f_autoCompletionCaseSensitivity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::CaseSensitivity>::target_type > ();
}

static void _call_f_autoCompletionCaseSensitivity_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::CaseSensitivity>::target_type > ((qt_gsi::Converter<Qt::CaseSensitivity>::target_type)qt_gsi::CppToQtAdaptor<Qt::CaseSensitivity>(((QComboBox *)cls)->autoCompletionCaseSensitivity ()));
}

static qt_gsi::GenericMethod *_create_f_autoCompletionCaseSensitivity_c0 ()
{
  return new qt_gsi::GenericMethod (":autoCompletionCaseSensitivity", "@brief Method Qt::CaseSensitivity QComboBox::autoCompletionCaseSensitivity()\n", true, &_init_f_autoCompletionCaseSensitivity_c0, &_call_f_autoCompletionCaseSensitivity_c0);
}

// void QComboBox::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QComboBox *)cls)->clear ();
}

static qt_gsi::GenericMethod *_create_f_clear_0 ()
{
  return new qt_gsi::GenericMethod ("clear", "@brief Method void QComboBox::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
}

// void QComboBox::clearEditText()


static void _init_f_clearEditText_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearEditText_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QComboBox *)cls)->clearEditText ();
}

static qt_gsi::GenericMethod *_create_f_clearEditText_0 ()
{
  return new qt_gsi::GenericMethod ("clearEditText", "@brief Method void QComboBox::clearEditText()\n", false, &_init_f_clearEditText_0, &_call_f_clearEditText_0);
}

// QCompleter *QComboBox::completer()


static void _init_f_completer_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QCompleter * > ();
}

static void _call_f_completer_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QCompleter * > ((QCompleter *)((QComboBox *)cls)->completer ());
}

static qt_gsi::GenericMethod *_create_f_completer_c0 ()
{
  return new qt_gsi::GenericMethod (":completer", "@brief Method QCompleter *QComboBox::completer()\n", true, &_init_f_completer_c0, &_call_f_completer_c0);
}

// int QComboBox::count()


static void _init_f_count_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_count_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QComboBox *)cls)->count ());
}

static qt_gsi::GenericMethod *_create_f_count_c0 ()
{
  return new qt_gsi::GenericMethod (":count", "@brief Method int QComboBox::count()\n", true, &_init_f_count_c0, &_call_f_count_c0);
}

// int QComboBox::currentIndex()


static void _init_f_currentIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentIndex_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QComboBox *)cls)->currentIndex ());
}

static qt_gsi::GenericMethod *_create_f_currentIndex_c0 ()
{
  return new qt_gsi::GenericMethod (":currentIndex", "@brief Method int QComboBox::currentIndex()\n", true, &_init_f_currentIndex_c0, &_call_f_currentIndex_c0);
}

// QString QComboBox::currentText()


static void _init_f_currentText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_currentText_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QComboBox *)cls)->currentText ());
}

static qt_gsi::GenericMethod *_create_f_currentText_c0 ()
{
  return new qt_gsi::GenericMethod (":currentText", "@brief Method QString QComboBox::currentText()\n", true, &_init_f_currentText_c0, &_call_f_currentText_c0);
}

// bool QComboBox::duplicatesEnabled()


static void _init_f_duplicatesEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_duplicatesEnabled_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QComboBox *)cls)->duplicatesEnabled ());
}

static qt_gsi::GenericMethod *_create_f_duplicatesEnabled_c0 ()
{
  return new qt_gsi::GenericMethod (":duplicatesEnabled", "@brief Method bool QComboBox::duplicatesEnabled()\n", true, &_init_f_duplicatesEnabled_c0, &_call_f_duplicatesEnabled_c0);
}

// bool QComboBox::event(QEvent *event)


static void _init_f_event_1217 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_event_1217 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QComboBox *)cls)->event (arg1));
}

static qt_gsi::GenericMethod *_create_f_event_1217 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Method bool QComboBox::event(QEvent *event)\nThis is a reimplementation of QWidget::event", false, &_init_f_event_1217, &_call_f_event_1217);
}

// int QComboBox::findData(const QVariant &data, int role, QFlags<Qt::MatchFlag> flags)


static void _init_f_findData_c4986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QVariant & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role", true, "Qt::UserRole");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags", true, "Qt::MatchExactly|Qt::MatchCaseSensitive");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & > (argspec_2);
  decl->set_return<int > ();
}

static void _call_f_findData_c4986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVariant &arg1 = args.read<const QVariant & > ();
  int arg2 = args ? args.read<int > () : (int)(Qt::UserRole);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::MatchFlag> >(heap, Qt::MatchExactly|Qt::MatchCaseSensitive));
  ret.write<int > ((int)((QComboBox *)cls)->findData (arg1, arg2, qt_gsi::QtToCppAdaptor<QFlags<Qt::MatchFlag> >(arg3).cref()));
}

static qt_gsi::GenericMethod *_create_f_findData_c4986 ()
{
  return new qt_gsi::GenericMethod ("findData", "@brief Method int QComboBox::findData(const QVariant &data, int role, QFlags<Qt::MatchFlag> flags)\n", true, &_init_f_findData_c4986, &_call_f_findData_c4986);
}

// int QComboBox::findText(const QString &text, QFlags<Qt::MatchFlag> flags)


static void _init_f_findText_c4233 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "Qt::MatchExactly|Qt::MatchCaseSensitive");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_findText_c4233 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::MatchFlag> >(heap, Qt::MatchExactly|Qt::MatchCaseSensitive));
  ret.write<int > ((int)((QComboBox *)cls)->findText (arg1, qt_gsi::QtToCppAdaptor<QFlags<Qt::MatchFlag> >(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_findText_c4233 ()
{
  return new qt_gsi::GenericMethod ("findText", "@brief Method int QComboBox::findText(const QString &text, QFlags<Qt::MatchFlag> flags)\n", true, &_init_f_findText_c4233, &_call_f_findText_c4233);
}

// bool QComboBox::hasFrame()


static void _init_f_hasFrame_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasFrame_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QComboBox *)cls)->hasFrame ());
}

static qt_gsi::GenericMethod *_create_f_hasFrame_c0 ()
{
  return new qt_gsi::GenericMethod ("hasFrame|:frame", "@brief Method bool QComboBox::hasFrame()\n", true, &_init_f_hasFrame_c0, &_call_f_hasFrame_c0);
}

// void QComboBox::hidePopup()


static void _init_f_hidePopup_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_hidePopup_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QComboBox *)cls)->hidePopup ();
}

static qt_gsi::GenericMethod *_create_f_hidePopup_0 ()
{
  return new qt_gsi::GenericMethod ("hidePopup", "@brief Method void QComboBox::hidePopup()\n", false, &_init_f_hidePopup_0, &_call_f_hidePopup_0);
}

// QSize QComboBox::iconSize()


static void _init_f_iconSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_iconSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QComboBox *)cls)->iconSize ());
}

static qt_gsi::GenericMethod *_create_f_iconSize_c0 ()
{
  return new qt_gsi::GenericMethod (":iconSize", "@brief Method QSize QComboBox::iconSize()\n", true, &_init_f_iconSize_c0, &_call_f_iconSize_c0);
}

// void QComboBox::insertItem(int index, const QString &text, const QVariant &userData)


static void _init_f_insertItem_4695 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("userData", true, "QVariant()");
  decl->add_arg<const QVariant & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_insertItem_4695 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QString &arg2 = args.read<const QString & > ();
  const QVariant &arg3 = args ? args.read<const QVariant & > () : (const QVariant &)(QVariant());
  ((QComboBox *)cls)->insertItem (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_insertItem_4695 ()
{
  return new qt_gsi::GenericMethod ("insertItem", "@brief Method void QComboBox::insertItem(int index, const QString &text, const QVariant &userData)\n", false, &_init_f_insertItem_4695, &_call_f_insertItem_4695);
}

// void QComboBox::insertItem(int index, const QIcon &icon, const QString &text, const QVariant &userData)


static void _init_f_insertItem_6374 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("icon");
  decl->add_arg<const QIcon & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("userData", true, "QVariant()");
  decl->add_arg<const QVariant & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_insertItem_6374 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QIcon &arg2 = args.read<const QIcon & > ();
  const QString &arg3 = args.read<const QString & > ();
  const QVariant &arg4 = args ? args.read<const QVariant & > () : (const QVariant &)(QVariant());
  ((QComboBox *)cls)->insertItem (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_insertItem_6374 ()
{
  return new qt_gsi::GenericMethod ("insertItem", "@brief Method void QComboBox::insertItem(int index, const QIcon &icon, const QString &text, const QVariant &userData)\n", false, &_init_f_insertItem_6374, &_call_f_insertItem_6374);
}

// void QComboBox::insertItems(int index, const QStringList &texts)


static void _init_f_insertItems_3096 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("texts");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertItems_3096 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<QStringList>::target_type & arg2 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  ((QComboBox *)cls)->insertItems (arg1, qt_gsi::QtToCppAdaptor<QStringList>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_insertItems_3096 ()
{
  return new qt_gsi::GenericMethod ("insertItems", "@brief Method void QComboBox::insertItems(int index, const QStringList &texts)\n", false, &_init_f_insertItems_3096, &_call_f_insertItems_3096);
}

// QComboBox::InsertPolicy QComboBox::insertPolicy()


static void _init_f_insertPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QComboBox::InsertPolicy>::target_type > ();
}

static void _call_f_insertPolicy_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QComboBox::InsertPolicy>::target_type > ((qt_gsi::Converter<QComboBox::InsertPolicy>::target_type)qt_gsi::CppToQtAdaptor<QComboBox::InsertPolicy>(((QComboBox *)cls)->insertPolicy ()));
}

static qt_gsi::GenericMethod *_create_f_insertPolicy_c0 ()
{
  return new qt_gsi::GenericMethod (":insertPolicy", "@brief Method QComboBox::InsertPolicy QComboBox::insertPolicy()\n", true, &_init_f_insertPolicy_c0, &_call_f_insertPolicy_c0);
}

// void QComboBox::insertSeparator(int index)


static void _init_f_insertSeparator_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_insertSeparator_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QComboBox *)cls)->insertSeparator (arg1);
}

static qt_gsi::GenericMethod *_create_f_insertSeparator_767 ()
{
  return new qt_gsi::GenericMethod ("insertSeparator", "@brief Method void QComboBox::insertSeparator(int index)\n", false, &_init_f_insertSeparator_767, &_call_f_insertSeparator_767);
}

// bool QComboBox::isEditable()


static void _init_f_isEditable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEditable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QComboBox *)cls)->isEditable ());
}

static qt_gsi::GenericMethod *_create_f_isEditable_c0 ()
{
  return new qt_gsi::GenericMethod ("isEditable?|:editable", "@brief Method bool QComboBox::isEditable()\n", true, &_init_f_isEditable_c0, &_call_f_isEditable_c0);
}

// QVariant QComboBox::itemData(int index, int role)


static void _init_f_itemData_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role", true, "Qt::UserRole");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_f_itemData_c1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args ? args.read<int > () : (int)(Qt::UserRole);
  ret.write<QVariant > ((QVariant)((QComboBox *)cls)->itemData (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_itemData_c1426 ()
{
  return new qt_gsi::GenericMethod ("itemData", "@brief Method QVariant QComboBox::itemData(int index, int role)\n", true, &_init_f_itemData_c1426, &_call_f_itemData_c1426);
}

// QAbstractItemDelegate *QComboBox::itemDelegate()


static void _init_f_itemDelegate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractItemDelegate * > ();
}

static void _call_f_itemDelegate_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QAbstractItemDelegate * > ((QAbstractItemDelegate *)((QComboBox *)cls)->itemDelegate ());
}

static qt_gsi::GenericMethod *_create_f_itemDelegate_c0 ()
{
  return new qt_gsi::GenericMethod (":itemDelegate", "@brief Method QAbstractItemDelegate *QComboBox::itemDelegate()\n", true, &_init_f_itemDelegate_c0, &_call_f_itemDelegate_c0);
}

// QIcon QComboBox::itemIcon(int index)


static void _init_f_itemIcon_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QIcon > ();
}

static void _call_f_itemIcon_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QIcon > ((QIcon)((QComboBox *)cls)->itemIcon (arg1));
}

static qt_gsi::GenericMethod *_create_f_itemIcon_c767 ()
{
  return new qt_gsi::GenericMethod ("itemIcon", "@brief Method QIcon QComboBox::itemIcon(int index)\n", true, &_init_f_itemIcon_c767, &_call_f_itemIcon_c767);
}

// QString QComboBox::itemText(int index)


static void _init_f_itemText_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_itemText_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QString > ((QString)((QComboBox *)cls)->itemText (arg1));
}

static qt_gsi::GenericMethod *_create_f_itemText_c767 ()
{
  return new qt_gsi::GenericMethod ("itemText", "@brief Method QString QComboBox::itemText(int index)\n", true, &_init_f_itemText_c767, &_call_f_itemText_c767);
}

// QLineEdit *QComboBox::lineEdit()


static void _init_f_lineEdit_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLineEdit * > ();
}

static void _call_f_lineEdit_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QLineEdit * > ((QLineEdit *)((QComboBox *)cls)->lineEdit ());
}

static qt_gsi::GenericMethod *_create_f_lineEdit_c0 ()
{
  return new qt_gsi::GenericMethod (":lineEdit", "@brief Method QLineEdit *QComboBox::lineEdit()\n", true, &_init_f_lineEdit_c0, &_call_f_lineEdit_c0);
}

// int QComboBox::maxCount()


static void _init_f_maxCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_maxCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QComboBox *)cls)->maxCount ());
}

static qt_gsi::GenericMethod *_create_f_maxCount_c0 ()
{
  return new qt_gsi::GenericMethod (":maxCount", "@brief Method int QComboBox::maxCount()\n", true, &_init_f_maxCount_c0, &_call_f_maxCount_c0);
}

// int QComboBox::maxVisibleItems()


static void _init_f_maxVisibleItems_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_maxVisibleItems_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QComboBox *)cls)->maxVisibleItems ());
}

static qt_gsi::GenericMethod *_create_f_maxVisibleItems_c0 ()
{
  return new qt_gsi::GenericMethod (":maxVisibleItems", "@brief Method int QComboBox::maxVisibleItems()\n", true, &_init_f_maxVisibleItems_c0, &_call_f_maxVisibleItems_c0);
}

// int QComboBox::minimumContentsLength()


static void _init_f_minimumContentsLength_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_minimumContentsLength_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QComboBox *)cls)->minimumContentsLength ());
}

static qt_gsi::GenericMethod *_create_f_minimumContentsLength_c0 ()
{
  return new qt_gsi::GenericMethod (":minimumContentsLength", "@brief Method int QComboBox::minimumContentsLength()\n", true, &_init_f_minimumContentsLength_c0, &_call_f_minimumContentsLength_c0);
}

// QSize QComboBox::minimumSizeHint()


static void _init_f_minimumSizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSizeHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QComboBox *)cls)->minimumSizeHint ());
}

static qt_gsi::GenericMethod *_create_f_minimumSizeHint_c0 ()
{
  return new qt_gsi::GenericMethod (":minimumSizeHint", "@brief Method QSize QComboBox::minimumSizeHint()\nThis is a reimplementation of QWidget::minimumSizeHint", true, &_init_f_minimumSizeHint_c0, &_call_f_minimumSizeHint_c0);
}

// QAbstractItemModel *QComboBox::model()


static void _init_f_model_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractItemModel * > ();
}

static void _call_f_model_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QAbstractItemModel * > ((QAbstractItemModel *)((QComboBox *)cls)->model ());
}

static qt_gsi::GenericMethod *_create_f_model_c0 ()
{
  return new qt_gsi::GenericMethod (":model", "@brief Method QAbstractItemModel *QComboBox::model()\n", true, &_init_f_model_c0, &_call_f_model_c0);
}

// int QComboBox::modelColumn()


static void _init_f_modelColumn_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_modelColumn_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QComboBox *)cls)->modelColumn ());
}

static qt_gsi::GenericMethod *_create_f_modelColumn_c0 ()
{
  return new qt_gsi::GenericMethod (":modelColumn", "@brief Method int QComboBox::modelColumn()\n", true, &_init_f_modelColumn_c0, &_call_f_modelColumn_c0);
}

// void QComboBox::removeItem(int index)


static void _init_f_removeItem_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeItem_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QComboBox *)cls)->removeItem (arg1);
}

static qt_gsi::GenericMethod *_create_f_removeItem_767 ()
{
  return new qt_gsi::GenericMethod ("removeItem", "@brief Method void QComboBox::removeItem(int index)\n", false, &_init_f_removeItem_767, &_call_f_removeItem_767);
}

// QModelIndex QComboBox::rootModelIndex()


static void _init_f_rootModelIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QModelIndex > ();
}

static void _call_f_rootModelIndex_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QModelIndex > ((QModelIndex)((QComboBox *)cls)->rootModelIndex ());
}

static qt_gsi::GenericMethod *_create_f_rootModelIndex_c0 ()
{
  return new qt_gsi::GenericMethod (":rootModelIndex", "@brief Method QModelIndex QComboBox::rootModelIndex()\n", true, &_init_f_rootModelIndex_c0, &_call_f_rootModelIndex_c0);
}

// void QComboBox::setAutoCompletion(bool enable)


static void _init_f_setAutoCompletion_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAutoCompletion_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QComboBox *)cls)->setAutoCompletion (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAutoCompletion_864 ()
{
  return new qt_gsi::GenericMethod ("setAutoCompletion|autoCompletion=", "@brief Method void QComboBox::setAutoCompletion(bool enable)\n", false, &_init_f_setAutoCompletion_864, &_call_f_setAutoCompletion_864);
}

// void QComboBox::setAutoCompletionCaseSensitivity(Qt::CaseSensitivity sensitivity)


static void _init_f_setAutoCompletionCaseSensitivity_2324 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sensitivity");
  decl->add_arg<const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAutoCompletionCaseSensitivity_2324 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & > ();
  ((QComboBox *)cls)->setAutoCompletionCaseSensitivity (qt_gsi::QtToCppAdaptor<Qt::CaseSensitivity>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setAutoCompletionCaseSensitivity_2324 ()
{
  return new qt_gsi::GenericMethod ("setAutoCompletionCaseSensitivity|autoCompletionCaseSensitivity=", "@brief Method void QComboBox::setAutoCompletionCaseSensitivity(Qt::CaseSensitivity sensitivity)\n", false, &_init_f_setAutoCompletionCaseSensitivity_2324, &_call_f_setAutoCompletionCaseSensitivity_2324);
}

// void QComboBox::setCompleter(QCompleter *c)


static void _init_f_setCompleter_1642 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<QCompleter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCompleter_1642 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCompleter *arg1 = args.read<QCompleter * > ();
  ((QComboBox *)cls)->setCompleter (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCompleter_1642 ()
{
  return new qt_gsi::GenericMethod ("setCompleter|completer=", "@brief Method void QComboBox::setCompleter(QCompleter *c)\n", false, &_init_f_setCompleter_1642, &_call_f_setCompleter_1642);
}

// void QComboBox::setCurrentIndex(int index)


static void _init_f_setCurrentIndex_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentIndex_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QComboBox *)cls)->setCurrentIndex (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCurrentIndex_767 ()
{
  return new qt_gsi::GenericMethod ("setCurrentIndex|currentIndex=", "@brief Method void QComboBox::setCurrentIndex(int index)\n", false, &_init_f_setCurrentIndex_767, &_call_f_setCurrentIndex_767);
}

// void QComboBox::setDuplicatesEnabled(bool enable)


static void _init_f_setDuplicatesEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDuplicatesEnabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QComboBox *)cls)->setDuplicatesEnabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDuplicatesEnabled_864 ()
{
  return new qt_gsi::GenericMethod ("setDuplicatesEnabled|duplicatesEnabled=", "@brief Method void QComboBox::setDuplicatesEnabled(bool enable)\n", false, &_init_f_setDuplicatesEnabled_864, &_call_f_setDuplicatesEnabled_864);
}

// void QComboBox::setEditText(const QString &text)


static void _init_f_setEditText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEditText_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QComboBox *)cls)->setEditText (arg1);
}

static qt_gsi::GenericMethod *_create_f_setEditText_2025 ()
{
  return new qt_gsi::GenericMethod ("setEditText", "@brief Method void QComboBox::setEditText(const QString &text)\n", false, &_init_f_setEditText_2025, &_call_f_setEditText_2025);
}

// void QComboBox::setEditable(bool editable)


static void _init_f_setEditable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEditable_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QComboBox *)cls)->setEditable (arg1);
}

static qt_gsi::GenericMethod *_create_f_setEditable_864 ()
{
  return new qt_gsi::GenericMethod ("setEditable|editable=", "@brief Method void QComboBox::setEditable(bool editable)\n", false, &_init_f_setEditable_864, &_call_f_setEditable_864);
}

// void QComboBox::setFrame(bool)


static void _init_f_setFrame_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFrame_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QComboBox *)cls)->setFrame (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFrame_864 ()
{
  return new qt_gsi::GenericMethod ("setFrame|frame=", "@brief Method void QComboBox::setFrame(bool)\n", false, &_init_f_setFrame_864, &_call_f_setFrame_864);
}

// void QComboBox::setIconSize(const QSize &size)


static void _init_f_setIconSize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIconSize_1805 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  ((QComboBox *)cls)->setIconSize (arg1);
}

static qt_gsi::GenericMethod *_create_f_setIconSize_1805 ()
{
  return new qt_gsi::GenericMethod ("setIconSize|iconSize=", "@brief Method void QComboBox::setIconSize(const QSize &size)\n", false, &_init_f_setIconSize_1805, &_call_f_setIconSize_1805);
}

// void QComboBox::setInsertPolicy(QComboBox::InsertPolicy policy)


static void _init_f_setInsertPolicy_2679 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("policy");
  decl->add_arg<const qt_gsi::Converter<QComboBox::InsertPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setInsertPolicy_2679 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QComboBox::InsertPolicy>::target_type & arg1 = args.read<const qt_gsi::Converter<QComboBox::InsertPolicy>::target_type & > ();
  ((QComboBox *)cls)->setInsertPolicy (qt_gsi::QtToCppAdaptor<QComboBox::InsertPolicy>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setInsertPolicy_2679 ()
{
  return new qt_gsi::GenericMethod ("setInsertPolicy|insertPolicy=", "@brief Method void QComboBox::setInsertPolicy(QComboBox::InsertPolicy policy)\n", false, &_init_f_setInsertPolicy_2679, &_call_f_setInsertPolicy_2679);
}

// void QComboBox::setItemData(int index, const QVariant &value, int role)


static void _init_f_setItemData_3437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role", true, "Qt::UserRole");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setItemData_3437 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  int arg3 = args ? args.read<int > () : (int)(Qt::UserRole);
  ((QComboBox *)cls)->setItemData (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_setItemData_3437 ()
{
  return new qt_gsi::GenericMethod ("setItemData", "@brief Method void QComboBox::setItemData(int index, const QVariant &value, int role)\n", false, &_init_f_setItemData_3437, &_call_f_setItemData_3437);
}

// void QComboBox::setItemDelegate(QAbstractItemDelegate *delegate)


static void _init_f_setItemDelegate_2717 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("delegate");
  decl->add_arg<QAbstractItemDelegate * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setItemDelegate_2717 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractItemDelegate *arg1 = args.read<QAbstractItemDelegate * > ();
  ((QComboBox *)cls)->setItemDelegate (arg1);
}

static qt_gsi::GenericMethod *_create_f_setItemDelegate_2717 ()
{
  return new qt_gsi::GenericMethod ("setItemDelegate|itemDelegate=", "@brief Method void QComboBox::setItemDelegate(QAbstractItemDelegate *delegate)\n", false, &_init_f_setItemDelegate_2717, &_call_f_setItemDelegate_2717);
}

// void QComboBox::setItemIcon(int index, const QIcon &icon)


static void _init_f_setItemIcon_2446 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("icon");
  decl->add_arg<const QIcon & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setItemIcon_2446 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QIcon &arg2 = args.read<const QIcon & > ();
  ((QComboBox *)cls)->setItemIcon (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setItemIcon_2446 ()
{
  return new qt_gsi::GenericMethod ("setItemIcon", "@brief Method void QComboBox::setItemIcon(int index, const QIcon &icon)\n", false, &_init_f_setItemIcon_2446, &_call_f_setItemIcon_2446);
}

// void QComboBox::setItemText(int index, const QString &text)


static void _init_f_setItemText_2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setItemText_2684 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QString &arg2 = args.read<const QString & > ();
  ((QComboBox *)cls)->setItemText (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setItemText_2684 ()
{
  return new qt_gsi::GenericMethod ("setItemText", "@brief Method void QComboBox::setItemText(int index, const QString &text)\n", false, &_init_f_setItemText_2684, &_call_f_setItemText_2684);
}

// void QComboBox::setLineEdit(QLineEdit *edit)


static void _init_f_setLineEdit_1485 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("edit");
  decl->add_arg<QLineEdit * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLineEdit_1485 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLineEdit *arg1 = args.read<QLineEdit * > ();
  ((QComboBox *)cls)->setLineEdit (arg1);
}

static qt_gsi::GenericMethod *_create_f_setLineEdit_1485 ()
{
  return new qt_gsi::GenericMethod ("setLineEdit|lineEdit=", "@brief Method void QComboBox::setLineEdit(QLineEdit *edit)\n", false, &_init_f_setLineEdit_1485, &_call_f_setLineEdit_1485);
}

// void QComboBox::setMaxCount(int max)


static void _init_f_setMaxCount_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("max");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaxCount_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QComboBox *)cls)->setMaxCount (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMaxCount_767 ()
{
  return new qt_gsi::GenericMethod ("setMaxCount|maxCount=", "@brief Method void QComboBox::setMaxCount(int max)\n", false, &_init_f_setMaxCount_767, &_call_f_setMaxCount_767);
}

// void QComboBox::setMaxVisibleItems(int maxItems)


static void _init_f_setMaxVisibleItems_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maxItems");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaxVisibleItems_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QComboBox *)cls)->setMaxVisibleItems (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMaxVisibleItems_767 ()
{
  return new qt_gsi::GenericMethod ("setMaxVisibleItems|maxVisibleItems=", "@brief Method void QComboBox::setMaxVisibleItems(int maxItems)\n", false, &_init_f_setMaxVisibleItems_767, &_call_f_setMaxVisibleItems_767);
}

// void QComboBox::setMinimumContentsLength(int characters)


static void _init_f_setMinimumContentsLength_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("characters");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMinimumContentsLength_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QComboBox *)cls)->setMinimumContentsLength (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMinimumContentsLength_767 ()
{
  return new qt_gsi::GenericMethod ("setMinimumContentsLength|minimumContentsLength=", "@brief Method void QComboBox::setMinimumContentsLength(int characters)\n", false, &_init_f_setMinimumContentsLength_767, &_call_f_setMinimumContentsLength_767);
}

// void QComboBox::setModel(QAbstractItemModel *model)


static void _init_f_setModel_2419 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setModel_2419 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractItemModel *arg1 = args.read<QAbstractItemModel * > ();
  ((QComboBox *)cls)->setModel (arg1);
}

static qt_gsi::GenericMethod *_create_f_setModel_2419 ()
{
  return new qt_gsi::GenericMethod ("setModel|model=", "@brief Method void QComboBox::setModel(QAbstractItemModel *model)\n", false, &_init_f_setModel_2419, &_call_f_setModel_2419);
}

// void QComboBox::setModelColumn(int visibleColumn)


static void _init_f_setModelColumn_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visibleColumn");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setModelColumn_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QComboBox *)cls)->setModelColumn (arg1);
}

static qt_gsi::GenericMethod *_create_f_setModelColumn_767 ()
{
  return new qt_gsi::GenericMethod ("setModelColumn|modelColumn=", "@brief Method void QComboBox::setModelColumn(int visibleColumn)\n", false, &_init_f_setModelColumn_767, &_call_f_setModelColumn_767);
}

// void QComboBox::setRootModelIndex(const QModelIndex &index)


static void _init_f_setRootModelIndex_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRootModelIndex_2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ((QComboBox *)cls)->setRootModelIndex (arg1);
}

static qt_gsi::GenericMethod *_create_f_setRootModelIndex_2395 ()
{
  return new qt_gsi::GenericMethod ("setRootModelIndex|rootModelIndex=", "@brief Method void QComboBox::setRootModelIndex(const QModelIndex &index)\n", false, &_init_f_setRootModelIndex_2395, &_call_f_setRootModelIndex_2395);
}

// void QComboBox::setSizeAdjustPolicy(QComboBox::SizeAdjustPolicy policy)


static void _init_f_setSizeAdjustPolicy_3080 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("policy");
  decl->add_arg<const qt_gsi::Converter<QComboBox::SizeAdjustPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSizeAdjustPolicy_3080 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QComboBox::SizeAdjustPolicy>::target_type & arg1 = args.read<const qt_gsi::Converter<QComboBox::SizeAdjustPolicy>::target_type & > ();
  ((QComboBox *)cls)->setSizeAdjustPolicy (qt_gsi::QtToCppAdaptor<QComboBox::SizeAdjustPolicy>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setSizeAdjustPolicy_3080 ()
{
  return new qt_gsi::GenericMethod ("setSizeAdjustPolicy|sizeAdjustPolicy=", "@brief Method void QComboBox::setSizeAdjustPolicy(QComboBox::SizeAdjustPolicy policy)\n", false, &_init_f_setSizeAdjustPolicy_3080, &_call_f_setSizeAdjustPolicy_3080);
}

// void QComboBox::setValidator(const QValidator *v)


static void _init_f_setValidator_2332 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("v");
  decl->add_arg<const QValidator * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setValidator_2332 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QValidator *arg1 = args.read<const QValidator * > ();
  ((QComboBox *)cls)->setValidator (arg1);
}

static qt_gsi::GenericMethod *_create_f_setValidator_2332 ()
{
  return new qt_gsi::GenericMethod ("setValidator|validator=", "@brief Method void QComboBox::setValidator(const QValidator *v)\n", false, &_init_f_setValidator_2332, &_call_f_setValidator_2332);
}

// void QComboBox::setView(QAbstractItemView *itemView)


static void _init_f_setView_2333 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("itemView");
  decl->add_arg<QAbstractItemView * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setView_2333 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractItemView *arg1 = args.read<QAbstractItemView * > ();
  ((QComboBox *)cls)->setView (arg1);
}

static qt_gsi::GenericMethod *_create_f_setView_2333 ()
{
  return new qt_gsi::GenericMethod ("setView|view=", "@brief Method void QComboBox::setView(QAbstractItemView *itemView)\n", false, &_init_f_setView_2333, &_call_f_setView_2333);
}

// void QComboBox::showPopup()


static void _init_f_showPopup_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showPopup_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QComboBox *)cls)->showPopup ();
}

static qt_gsi::GenericMethod *_create_f_showPopup_0 ()
{
  return new qt_gsi::GenericMethod ("showPopup", "@brief Method void QComboBox::showPopup()\n", false, &_init_f_showPopup_0, &_call_f_showPopup_0);
}

// QComboBox::SizeAdjustPolicy QComboBox::sizeAdjustPolicy()


static void _init_f_sizeAdjustPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QComboBox::SizeAdjustPolicy>::target_type > ();
}

static void _call_f_sizeAdjustPolicy_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QComboBox::SizeAdjustPolicy>::target_type > ((qt_gsi::Converter<QComboBox::SizeAdjustPolicy>::target_type)qt_gsi::CppToQtAdaptor<QComboBox::SizeAdjustPolicy>(((QComboBox *)cls)->sizeAdjustPolicy ()));
}

static qt_gsi::GenericMethod *_create_f_sizeAdjustPolicy_c0 ()
{
  return new qt_gsi::GenericMethod (":sizeAdjustPolicy", "@brief Method QComboBox::SizeAdjustPolicy QComboBox::sizeAdjustPolicy()\n", true, &_init_f_sizeAdjustPolicy_c0, &_call_f_sizeAdjustPolicy_c0);
}

// QSize QComboBox::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QComboBox *)cls)->sizeHint ());
}

static qt_gsi::GenericMethod *_create_f_sizeHint_c0 ()
{
  return new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QComboBox::sizeHint()\nThis is a reimplementation of QWidget::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
}

// const QValidator *QComboBox::validator()


static void _init_f_validator_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QValidator * > ();
}

static void _call_f_validator_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QValidator * > ((const QValidator *)((QComboBox *)cls)->validator ());
}

static qt_gsi::GenericMethod *_create_f_validator_c0 ()
{
  return new qt_gsi::GenericMethod (":validator", "@brief Method const QValidator *QComboBox::validator()\n", true, &_init_f_validator_c0, &_call_f_validator_c0);
}

// QAbstractItemView *QComboBox::view()


static void _init_f_view_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractItemView * > ();
}

static void _call_f_view_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QAbstractItemView * > ((QAbstractItemView *)((QComboBox *)cls)->view ());
}

static qt_gsi::GenericMethod *_create_f_view_c0 ()
{
  return new qt_gsi::GenericMethod (":view", "@brief Method QAbstractItemView *QComboBox::view()\n", true, &_init_f_view_c0, &_call_f_view_c0);
}

// static QString QComboBox::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QComboBox::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QComboBox::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QComboBox::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QComboBox::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QComboBox::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QComboBox::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QComboBox::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QComboBox::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QComboBox::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QComboBox::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QComboBox::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QComboBox, QComboBox_EventAdaptor> ea_QComboBox;

namespace gsi
{
extern gsi::Class<QWidget> decl_QWidget;

gsi::Class<QComboBox> decl_QComboBox (ea_QComboBox, decl_QWidget, "QComboBox_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_addItem_4036 ()) +
  gsi::Methods(_create_f_addItem_5715 ()) +
  gsi::Methods(_create_f_addItems_2437 ()) +
  gsi::Methods(_create_f_autoCompletion_c0 ()) +
  gsi::Methods(_create_f_autoCompletionCaseSensitivity_c0 ()) +
  gsi::Methods(_create_f_clear_0 ()) +
  gsi::Methods(_create_f_clearEditText_0 ()) +
  gsi::Methods(_create_f_completer_c0 ()) +
  gsi::Methods(_create_f_count_c0 ()) +
  gsi::Methods(_create_f_currentIndex_c0 ()) +
  gsi::Methods(_create_f_currentText_c0 ()) +
  gsi::Methods(_create_f_duplicatesEnabled_c0 ()) +
  gsi::Methods(_create_f_event_1217 ()) +
  gsi::Methods(_create_f_findData_c4986 ()) +
  gsi::Methods(_create_f_findText_c4233 ()) +
  gsi::Methods(_create_f_hasFrame_c0 ()) +
  gsi::Methods(_create_f_hidePopup_0 ()) +
  gsi::Methods(_create_f_iconSize_c0 ()) +
  gsi::Methods(_create_f_insertItem_4695 ()) +
  gsi::Methods(_create_f_insertItem_6374 ()) +
  gsi::Methods(_create_f_insertItems_3096 ()) +
  gsi::Methods(_create_f_insertPolicy_c0 ()) +
  gsi::Methods(_create_f_insertSeparator_767 ()) +
  gsi::Methods(_create_f_isEditable_c0 ()) +
  gsi::Methods(_create_f_itemData_c1426 ()) +
  gsi::Methods(_create_f_itemDelegate_c0 ()) +
  gsi::Methods(_create_f_itemIcon_c767 ()) +
  gsi::Methods(_create_f_itemText_c767 ()) +
  gsi::Methods(_create_f_lineEdit_c0 ()) +
  gsi::Methods(_create_f_maxCount_c0 ()) +
  gsi::Methods(_create_f_maxVisibleItems_c0 ()) +
  gsi::Methods(_create_f_minimumContentsLength_c0 ()) +
  gsi::Methods(_create_f_minimumSizeHint_c0 ()) +
  gsi::Methods(_create_f_model_c0 ()) +
  gsi::Methods(_create_f_modelColumn_c0 ()) +
  gsi::Methods(_create_f_removeItem_767 ()) +
  gsi::Methods(_create_f_rootModelIndex_c0 ()) +
  gsi::Methods(_create_f_setAutoCompletion_864 ()) +
  gsi::Methods(_create_f_setAutoCompletionCaseSensitivity_2324 ()) +
  gsi::Methods(_create_f_setCompleter_1642 ()) +
  gsi::Methods(_create_f_setCurrentIndex_767 ()) +
  gsi::Methods(_create_f_setDuplicatesEnabled_864 ()) +
  gsi::Methods(_create_f_setEditText_2025 ()) +
  gsi::Methods(_create_f_setEditable_864 ()) +
  gsi::Methods(_create_f_setFrame_864 ()) +
  gsi::Methods(_create_f_setIconSize_1805 ()) +
  gsi::Methods(_create_f_setInsertPolicy_2679 ()) +
  gsi::Methods(_create_f_setItemData_3437 ()) +
  gsi::Methods(_create_f_setItemDelegate_2717 ()) +
  gsi::Methods(_create_f_setItemIcon_2446 ()) +
  gsi::Methods(_create_f_setItemText_2684 ()) +
  gsi::Methods(_create_f_setLineEdit_1485 ()) +
  gsi::Methods(_create_f_setMaxCount_767 ()) +
  gsi::Methods(_create_f_setMaxVisibleItems_767 ()) +
  gsi::Methods(_create_f_setMinimumContentsLength_767 ()) +
  gsi::Methods(_create_f_setModel_2419 ()) +
  gsi::Methods(_create_f_setModelColumn_767 ()) +
  gsi::Methods(_create_f_setRootModelIndex_2395 ()) +
  gsi::Methods(_create_f_setSizeAdjustPolicy_3080 ()) +
  gsi::Methods(_create_f_setValidator_2332 ()) +
  gsi::Methods(_create_f_setView_2333 ()) +
  gsi::Methods(_create_f_showPopup_0 ()) +
  gsi::Methods(_create_f_sizeAdjustPolicy_c0 ()) +
  gsi::Methods(_create_f_sizeHint_c0 ()) +
  gsi::Methods(_create_f_validator_c0 ()) +
  gsi::Methods(_create_f_view_c0 ()) +
  qt_gsi::qt_signal<QComboBox, QComboBox_EventAdaptor, int> ("activated", &QComboBox_EventAdaptor::activated_e_767, gsi::arg("index"), "@brief Signal declaration for QComboBox::activated(int index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QComboBox, QComboBox_EventAdaptor, const QString &> ("activated_qs", &QComboBox_EventAdaptor::activated_e_2025, gsi::arg("arg1"), "@brief Signal declaration for QComboBox::activated(const QString &)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QComboBox, QComboBox_EventAdaptor, int> ("currentIndexChanged", &QComboBox_EventAdaptor::currentIndexChanged_e_767, gsi::arg("index"), "@brief Signal declaration for QComboBox::currentIndexChanged(int index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QComboBox, QComboBox_EventAdaptor, const QString &> ("currentIndexChanged_qs", &QComboBox_EventAdaptor::currentIndexChanged_e_2025, gsi::arg("arg1"), "@brief Signal declaration for QComboBox::currentIndexChanged(const QString &)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QComboBox, QComboBox_EventAdaptor, const QPoint &> ("customContextMenuRequested", &QComboBox_EventAdaptor::customContextMenuRequested_e_1916, gsi::arg("pos"), "@brief Signal declaration for QComboBox::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QComboBox, QComboBox_EventAdaptor, QObject *> ("destroyed", &QComboBox_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QComboBox::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QComboBox, QComboBox_EventAdaptor, const QString &> ("editTextChanged", &QComboBox_EventAdaptor::editTextChanged_e_2025, gsi::arg("arg1"), "@brief Signal declaration for QComboBox::editTextChanged(const QString &)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QComboBox, QComboBox_EventAdaptor, int> ("highlighted", &QComboBox_EventAdaptor::highlighted_e_767, gsi::arg("index"), "@brief Signal declaration for QComboBox::highlighted(int index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QComboBox, QComboBox_EventAdaptor, const QString &> ("highlighted_qs", &QComboBox_EventAdaptor::highlighted_e_2025, gsi::arg("arg1"), "@brief Signal declaration for QComboBox::highlighted(const QString &)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QComboBox");
}


class QComboBox_Adaptor : public QComboBox, public qt_gsi::QtObjectBase
{
public:

  virtual ~QComboBox_Adaptor();

  //  [adaptor ctor] QComboBox::QComboBox(QWidget *parent)
  QComboBox_Adaptor() : QComboBox()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QComboBox::QComboBox(QWidget *parent)
  QComboBox_Adaptor(QWidget *parent) : QComboBox(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QComboBox::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QComboBox_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QComboBox::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  void QComboBox::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QComboBox_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QComboBox::destroy(destroyWindow, destroySubWindows);
  }

  //  bool QComboBox::focusNextChild()
  bool fp_QComboBox_focusNextChild_0 () {
    return QComboBox::focusNextChild();
  }

  //  bool QComboBox::focusPreviousChild()
  bool fp_QComboBox_focusPreviousChild_0 () {
    return QComboBox::focusPreviousChild();
  }

  //  void QComboBox::initStyleOption(QStyleOptionComboBox *option)
  void fp_QComboBox_initStyleOption_c2658 (QStyleOptionComboBox *option) const {
    QComboBox::initStyleOption(option);
  }

  //  int QComboBox::receivers(const char *signal)
  int fp_QComboBox_receivers_c1731 (const char *signal) const {
    return QComboBox::receivers(signal);
  }

  //  void QComboBox::resetInputContext()
  void fp_QComboBox_resetInputContext_0 () {
    QComboBox::resetInputContext();
  }

  //  QObject *QComboBox::sender()
  QObject * fp_QComboBox_sender_c0 () const {
    return QComboBox::sender();
  }

  //  void QComboBox::updateMicroFocus()
  void fp_QComboBox_updateMicroFocus_0 () {
    QComboBox::updateMicroFocus();
  }

  //  [adaptor impl] bool QComboBox::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QComboBox::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QComboBox_Adaptor, bool, QEvent *>(&QComboBox_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QComboBox::event(_event);
    }
  }

  //  [adaptor impl] bool QComboBox::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QComboBox::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QComboBox_Adaptor, bool, QObject *, QEvent *>(&QComboBox_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QComboBox::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] int QComboBox::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QComboBox::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QComboBox_Adaptor, int, int>(&QComboBox_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QComboBox::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::hidePopup()
  void cbs_hidePopup_0_0()
  {
    QComboBox::hidePopup();
  }

  virtual void hidePopup()
  {
    if (cb_hidePopup_0_0.can_issue()) {
      cb_hidePopup_0_0.issue<QComboBox_Adaptor>(&QComboBox_Adaptor::cbs_hidePopup_0_0);
    } else {
      QComboBox::hidePopup();
    }
  }

  //  [adaptor impl] QSize QComboBox::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QComboBox::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QComboBox_Adaptor, QSize>(&QComboBox_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QComboBox::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QComboBox::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QComboBox::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QComboBox_Adaptor, QPaintEngine *>(&QComboBox_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QComboBox::paintEngine();
    }
  }

  //  [adaptor impl] void QComboBox::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QComboBox::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QComboBox_Adaptor, bool>(&QComboBox_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QComboBox::setVisible(visible);
    }
  }

  //  [adaptor impl] void QComboBox::showPopup()
  void cbs_showPopup_0_0()
  {
    QComboBox::showPopup();
  }

  virtual void showPopup()
  {
    if (cb_showPopup_0_0.can_issue()) {
      cb_showPopup_0_0.issue<QComboBox_Adaptor>(&QComboBox_Adaptor::cbs_showPopup_0_0);
    } else {
      QComboBox::showPopup();
    }
  }

  //  [adaptor impl] QSize QComboBox::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QComboBox::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QComboBox_Adaptor, QSize>(&QComboBox_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QComboBox::sizeHint();
    }
  }

  //  [adaptor impl] void QComboBox::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QComboBox::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QComboBox_Adaptor, QActionEvent *>(&QComboBox_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QComboBox::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::changeEvent(QEvent *e)
  void cbs_changeEvent_1217_0(QEvent *e)
  {
    QComboBox::changeEvent(e);
  }

  virtual void changeEvent(QEvent *e)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QComboBox_Adaptor, QEvent *>(&QComboBox_Adaptor::cbs_changeEvent_1217_0, e);
    } else {
      QComboBox::changeEvent(e);
    }
  }

  //  [adaptor impl] void QComboBox::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QComboBox::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QComboBox_Adaptor, QChildEvent *>(&QComboBox_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QComboBox::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QComboBox::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QComboBox_Adaptor, QCloseEvent *>(&QComboBox_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QComboBox::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::contextMenuEvent(QContextMenuEvent *e)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *e)
  {
    QComboBox::contextMenuEvent(e);
  }

  virtual void contextMenuEvent(QContextMenuEvent *e)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QComboBox_Adaptor, QContextMenuEvent *>(&QComboBox_Adaptor::cbs_contextMenuEvent_2363_0, e);
    } else {
      QComboBox::contextMenuEvent(e);
    }
  }

  //  [adaptor impl] void QComboBox::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QComboBox::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QComboBox_Adaptor, QEvent *>(&QComboBox_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QComboBox::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QComboBox::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QComboBox_Adaptor, const char *>(&QComboBox_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QComboBox::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QComboBox::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QComboBox::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QComboBox_Adaptor, QDragEnterEvent *>(&QComboBox_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QComboBox::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QComboBox::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QComboBox_Adaptor, QDragLeaveEvent *>(&QComboBox_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QComboBox::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QComboBox::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QComboBox_Adaptor, QDragMoveEvent *>(&QComboBox_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QComboBox::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QComboBox::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QComboBox_Adaptor, QDropEvent *>(&QComboBox_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QComboBox::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QComboBox::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QComboBox_Adaptor, bool>(&QComboBox_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QComboBox::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QComboBox::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QComboBox_Adaptor, QEvent *>(&QComboBox_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QComboBox::enterEvent(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::focusInEvent(QFocusEvent *e)
  void cbs_focusInEvent_1729_0(QFocusEvent *e)
  {
    QComboBox::focusInEvent(e);
  }

  virtual void focusInEvent(QFocusEvent *e)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QComboBox_Adaptor, QFocusEvent *>(&QComboBox_Adaptor::cbs_focusInEvent_1729_0, e);
    } else {
      QComboBox::focusInEvent(e);
    }
  }

  //  [adaptor impl] bool QComboBox::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QComboBox::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QComboBox_Adaptor, bool, bool>(&QComboBox_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QComboBox::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QComboBox::focusOutEvent(QFocusEvent *e)
  void cbs_focusOutEvent_1729_0(QFocusEvent *e)
  {
    QComboBox::focusOutEvent(e);
  }

  virtual void focusOutEvent(QFocusEvent *e)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QComboBox_Adaptor, QFocusEvent *>(&QComboBox_Adaptor::cbs_focusOutEvent_1729_0, e);
    } else {
      QComboBox::focusOutEvent(e);
    }
  }

  //  [adaptor impl] void QComboBox::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QComboBox::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QComboBox_Adaptor, const QFont &>(&QComboBox_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QComboBox::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::hideEvent(QHideEvent *e)
  void cbs_hideEvent_1595_0(QHideEvent *e)
  {
    QComboBox::hideEvent(e);
  }

  virtual void hideEvent(QHideEvent *e)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QComboBox_Adaptor, QHideEvent *>(&QComboBox_Adaptor::cbs_hideEvent_1595_0, e);
    } else {
      QComboBox::hideEvent(e);
    }
  }

  //  [adaptor impl] void QComboBox::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QComboBox::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QComboBox_Adaptor, QInputMethodEvent *>(&QComboBox_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QComboBox::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] QVariant QComboBox::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QComboBox::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QComboBox_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QComboBox_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QComboBox::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::keyPressEvent(QKeyEvent *e)
  void cbs_keyPressEvent_1514_0(QKeyEvent *e)
  {
    QComboBox::keyPressEvent(e);
  }

  virtual void keyPressEvent(QKeyEvent *e)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QComboBox_Adaptor, QKeyEvent *>(&QComboBox_Adaptor::cbs_keyPressEvent_1514_0, e);
    } else {
      QComboBox::keyPressEvent(e);
    }
  }

  //  [adaptor impl] void QComboBox::keyReleaseEvent(QKeyEvent *e)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *e)
  {
    QComboBox::keyReleaseEvent(e);
  }

  virtual void keyReleaseEvent(QKeyEvent *e)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QComboBox_Adaptor, QKeyEvent *>(&QComboBox_Adaptor::cbs_keyReleaseEvent_1514_0, e);
    } else {
      QComboBox::keyReleaseEvent(e);
    }
  }

  //  [adaptor impl] void QComboBox::languageChange()
  void cbs_languageChange_0_0()
  {
    QComboBox::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QComboBox_Adaptor>(&QComboBox_Adaptor::cbs_languageChange_0_0);
    } else {
      QComboBox::languageChange();
    }
  }

  //  [adaptor impl] void QComboBox::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QComboBox::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QComboBox_Adaptor, QEvent *>(&QComboBox_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QComboBox::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QComboBox::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QComboBox::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QComboBox_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QComboBox_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QComboBox::metric(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QComboBox::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QComboBox_Adaptor, QMouseEvent *>(&QComboBox_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QComboBox::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QComboBox::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QComboBox_Adaptor, QMouseEvent *>(&QComboBox_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QComboBox::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::mousePressEvent(QMouseEvent *e)
  void cbs_mousePressEvent_1738_0(QMouseEvent *e)
  {
    QComboBox::mousePressEvent(e);
  }

  virtual void mousePressEvent(QMouseEvent *e)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QComboBox_Adaptor, QMouseEvent *>(&QComboBox_Adaptor::cbs_mousePressEvent_1738_0, e);
    } else {
      QComboBox::mousePressEvent(e);
    }
  }

  //  [adaptor impl] void QComboBox::mouseReleaseEvent(QMouseEvent *e)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *e)
  {
    QComboBox::mouseReleaseEvent(e);
  }

  virtual void mouseReleaseEvent(QMouseEvent *e)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QComboBox_Adaptor, QMouseEvent *>(&QComboBox_Adaptor::cbs_mouseReleaseEvent_1738_0, e);
    } else {
      QComboBox::mouseReleaseEvent(e);
    }
  }

  //  [adaptor impl] void QComboBox::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QComboBox::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QComboBox_Adaptor, QMoveEvent *>(&QComboBox_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QComboBox::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::paintEvent(QPaintEvent *e)
  void cbs_paintEvent_1725_0(QPaintEvent *e)
  {
    QComboBox::paintEvent(e);
  }

  virtual void paintEvent(QPaintEvent *e)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QComboBox_Adaptor, QPaintEvent *>(&QComboBox_Adaptor::cbs_paintEvent_1725_0, e);
    } else {
      QComboBox::paintEvent(e);
    }
  }

  //  [adaptor impl] void QComboBox::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QComboBox::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QComboBox_Adaptor, const QPalette &>(&QComboBox_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QComboBox::paletteChange(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::resizeEvent(QResizeEvent *e)
  void cbs_resizeEvent_1843_0(QResizeEvent *e)
  {
    QComboBox::resizeEvent(e);
  }

  virtual void resizeEvent(QResizeEvent *e)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QComboBox_Adaptor, QResizeEvent *>(&QComboBox_Adaptor::cbs_resizeEvent_1843_0, e);
    } else {
      QComboBox::resizeEvent(e);
    }
  }

  //  [adaptor impl] void QComboBox::showEvent(QShowEvent *e)
  void cbs_showEvent_1634_0(QShowEvent *e)
  {
    QComboBox::showEvent(e);
  }

  virtual void showEvent(QShowEvent *e)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QComboBox_Adaptor, QShowEvent *>(&QComboBox_Adaptor::cbs_showEvent_1634_0, e);
    } else {
      QComboBox::showEvent(e);
    }
  }

  //  [adaptor impl] void QComboBox::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QComboBox::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QComboBox_Adaptor, QStyle &>(&QComboBox_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QComboBox::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QComboBox::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QComboBox_Adaptor, QTabletEvent *>(&QComboBox_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QComboBox::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QComboBox::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QComboBox_Adaptor, QTimerEvent *>(&QComboBox_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QComboBox::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QComboBox::wheelEvent(QWheelEvent *e)
  void cbs_wheelEvent_1718_0(QWheelEvent *e)
  {
    QComboBox::wheelEvent(e);
  }

  virtual void wheelEvent(QWheelEvent *e)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QComboBox_Adaptor, QWheelEvent *>(&QComboBox_Adaptor::cbs_wheelEvent_1718_0, e);
    } else {
      QComboBox::wheelEvent(e);
    }
  }

  //  [adaptor impl] void QComboBox::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QComboBox::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QComboBox_Adaptor, bool>(&QComboBox_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QComboBox::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_hidePopup_0_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_showPopup_0_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QComboBox_Adaptor::~QComboBox_Adaptor() { }

//  Constructor QComboBox::QComboBox(QWidget *parent) (adaptor class)

static void _init_ctor_QComboBox_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QComboBox_Adaptor *> ();
}

static void _call_ctor_QComboBox_Adaptor_1315 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QComboBox_Adaptor *> (new QComboBox_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QComboBox_Adaptor_1315 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QComboBox::QComboBox(QWidget *parent)\nThis method creates an object of class QComboBox.", &_init_ctor_QComboBox_Adaptor_1315, &_call_ctor_QComboBox_Adaptor_1315);
}

// void QComboBox::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<WId>::target_type & > () : (const qt_gsi::Converter<WId>::target_type &)(qt_gsi::CppToQtReadAdaptor<WId>(heap, 0));
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  bool arg3 = args ? args.read<bool > () : (bool)(true);
  ((QComboBox_Adaptor *)cls)->fp_QComboBox_create_2208 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_create_2208 ()
{
  return new qt_gsi::GenericMethod("*qt_create", "@brief Method void QComboBox::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
}


// void QComboBox::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QComboBox_Adaptor *)cls)->fp_QComboBox_destroy_1620 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_destroy_1620 ()
{
  return new qt_gsi::GenericMethod("*qt_destroy", "@brief Method void QComboBox::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
}


// bool QComboBox::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QComboBox_Adaptor *)cls)->fp_QComboBox_focusNextChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusNextChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusNextChild", "@brief Method bool QComboBox::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
}


// bool QComboBox::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QComboBox_Adaptor *)cls)->fp_QComboBox_focusPreviousChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusPreviousChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusPreviousChild", "@brief Method bool QComboBox::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
}


// void QComboBox::initStyleOption(QStyleOptionComboBox *option)

static void _init_fp_initStyleOption_c2658 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOptionComboBox * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_initStyleOption_c2658 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyleOptionComboBox *arg1 = args.read<QStyleOptionComboBox * > ();
  ((QComboBox_Adaptor *)cls)->fp_QComboBox_initStyleOption_c2658 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_initStyleOption_c2658 ()
{
  return new qt_gsi::GenericMethod("*initStyleOption", "@brief Method void QComboBox::initStyleOption(QStyleOptionComboBox *option)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_initStyleOption_c2658, &_call_fp_initStyleOption_c2658);
}


// int QComboBox::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QComboBox_Adaptor *)cls)->fp_QComboBox_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QComboBox::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QComboBox::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QComboBox_Adaptor *)cls)->fp_QComboBox_resetInputContext_0 ();
}

static qt_gsi::GenericMethod*_create_fp_resetInputContext_0 ()
{
  return new qt_gsi::GenericMethod("*resetInputContext", "@brief Method void QComboBox::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
}


// QObject *QComboBox::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QComboBox_Adaptor *)cls)->fp_QComboBox_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QComboBox::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QComboBox::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QComboBox_Adaptor *)cls)->fp_QComboBox_updateMicroFocus_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateMicroFocus_0 ()
{
  return new qt_gsi::GenericMethod("*updateMicroFocus", "@brief Method void QComboBox::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
}


// bool QComboBox::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QComboBox_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QComboBox::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QComboBox::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QComboBox_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QComboBox::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// int QComboBox::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QComboBox_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QComboBox::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// void QComboBox::hidePopup()

static void _init_cbs_hidePopup_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_hidePopup_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QComboBox_Adaptor *)cls)->cbs_hidePopup_0_0 ();
}

static void _set_callback_cbs_hidePopup_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_hidePopup_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hidePopup_0_0 ()
{
  return new qt_gsi::GenericMethod ("hidePopup", "@hide", false, &_init_cbs_hidePopup_0_0, &_call_cbs_hidePopup_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hidePopup_0_0 ()
{
  return new qt_gsi::GenericMethod ("hidePopup", "@brief Virtual method void QComboBox::hidePopup()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hidePopup_0_0, &_call_cbs_hidePopup_0_0, &_set_callback_cbs_hidePopup_0_0);
}


// QSize QComboBox::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QComboBox_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QComboBox::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
}


// QPaintEngine *QComboBox::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QComboBox_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QComboBox::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
}


// void QComboBox::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QComboBox_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QComboBox::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
}


// void QComboBox::showPopup()

static void _init_cbs_showPopup_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_showPopup_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QComboBox_Adaptor *)cls)->cbs_showPopup_0_0 ();
}

static void _set_callback_cbs_showPopup_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_showPopup_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_showPopup_0_0 ()
{
  return new qt_gsi::GenericMethod ("showPopup", "@hide", false, &_init_cbs_showPopup_0_0, &_call_cbs_showPopup_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_showPopup_0_0 ()
{
  return new qt_gsi::GenericMethod ("showPopup", "@brief Virtual method void QComboBox::showPopup()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showPopup_0_0, &_call_cbs_showPopup_0_0, &_set_callback_cbs_showPopup_0_0);
}


// QSize QComboBox::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QComboBox_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QComboBox::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// void QComboBox::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QActionEvent *arg1 = args.read<QActionEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QComboBox::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
}


// void QComboBox::changeEvent(QEvent *e)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QComboBox::changeEvent(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
}


// void QComboBox::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QComboBox::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QComboBox::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCloseEvent *arg1 = args.read<QCloseEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QComboBox::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
}


// void QComboBox::contextMenuEvent(QContextMenuEvent *e)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QComboBox::contextMenuEvent(QContextMenuEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
}


// void QComboBox::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QComboBox::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QComboBox::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QComboBox_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QComboBox::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QComboBox::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QComboBox::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
}


// void QComboBox::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QComboBox::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
}


// void QComboBox::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QComboBox::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
}


// void QComboBox::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDropEvent *arg1 = args.read<QDropEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QComboBox::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
}


// void QComboBox::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QComboBox_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QComboBox::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
}


// void QComboBox::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QComboBox::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
}


// void QComboBox::focusInEvent(QFocusEvent *e)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QComboBox::focusInEvent(QFocusEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// bool QComboBox::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<bool > ((bool)((QComboBox_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QComboBox::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
}


// void QComboBox::focusOutEvent(QFocusEvent *e)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QComboBox::focusOutEvent(QFocusEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QComboBox::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QComboBox_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QComboBox::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
}


// void QComboBox::hideEvent(QHideEvent *e)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QHideEvent *arg1 = args.read<QHideEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QComboBox::hideEvent(QHideEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
}


// void QComboBox::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QComboBox::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// QVariant QComboBox::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QComboBox_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodQuery", "@brief Virtual method QVariant QComboBox::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// void QComboBox::keyPressEvent(QKeyEvent *e)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QComboBox::keyPressEvent(QKeyEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QComboBox::keyReleaseEvent(QKeyEvent *e)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QComboBox::keyReleaseEvent(QKeyEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QComboBox::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QComboBox_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QComboBox::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
}


// void QComboBox::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QComboBox::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
}


// int QComboBox::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QComboBox_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QComboBox::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
}


// void QComboBox::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QComboBox::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
}


// void QComboBox::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QComboBox::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
}


// void QComboBox::mousePressEvent(QMouseEvent *e)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QComboBox::mousePressEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
}


// void QComboBox::mouseReleaseEvent(QMouseEvent *e)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QComboBox::mouseReleaseEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
}


// void QComboBox::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMoveEvent *arg1 = args.read<QMoveEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QComboBox::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
}


// void QComboBox::paintEvent(QPaintEvent *e)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintEvent *arg1 = args.read<QPaintEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QComboBox::paintEvent(QPaintEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
}


// void QComboBox::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ((QComboBox_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QComboBox::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
}


// void QComboBox::resizeEvent(QResizeEvent *e)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QResizeEvent *arg1 = args.read<QResizeEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QComboBox::resizeEvent(QResizeEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
}


// void QComboBox::showEvent(QShowEvent *e)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QShowEvent *arg1 = args.read<QShowEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QComboBox::showEvent(QShowEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
}


// void QComboBox::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle &arg1 = args.read<QStyle & > ();
  ((QComboBox_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QComboBox::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
}


// void QComboBox::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTabletEvent *arg1 = args.read<QTabletEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QComboBox::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
}


// void QComboBox::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QComboBox::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


// void QComboBox::wheelEvent(QWheelEvent *e)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWheelEvent *arg1 = args.read<QWheelEvent * > ();
  ((QComboBox_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QComboBox::wheelEvent(QWheelEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
}


// void QComboBox::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QComboBox_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QComboBox_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QComboBox::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
}


namespace gsi
{

extern gsi::Class<QComboBox> decl_QComboBox;

gsi::Class<QComboBox_Adaptor> decl_QComboBox_Adaptor (decl_QComboBox, "QComboBox",
  gsi::Methods(_create_fp_create_2208 ()) +
  gsi::Methods(_create_fp_destroy_1620 ()) +
  gsi::Methods(_create_fp_focusNextChild_0 ()) +
  gsi::Methods(_create_fp_focusPreviousChild_0 ()) +
  gsi::Methods(_create_fp_initStyleOption_c2658 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_resetInputContext_0 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_updateMicroFocus_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_hidePopup_0_0 ()) +
  gsi::Methods(_create_callback_cbs_hidePopup_0_0 ()) +
  gsi::Methods(_create_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_cbs_showPopup_0_0 ()) +
  gsi::Methods(_create_callback_cbs_showPopup_0_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_callback_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_callback_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_callback_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_callback_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_callback_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_callback_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_callback_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_callback_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_callback_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_callback_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_callback_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_ctor_QComboBox_Adaptor_1315 ()),
  "@qt\n@brief Binding of QComboBox");

}


//  Implementation of the enum wrapper class for QComboBox::InsertPolicy
namespace qt_gsi
{

static QComboBox_InsertPolicy_Enum *c_1_QComboBox_InsertPolicy_Enum () { return new QComboBox_InsertPolicy_Enum (QComboBox::NoInsert); }
static QComboBox_InsertPolicy_Enum *c_2_QComboBox_InsertPolicy_Enum () { return new QComboBox_InsertPolicy_Enum (QComboBox::InsertAtTop); }
static QComboBox_InsertPolicy_Enum *c_3_QComboBox_InsertPolicy_Enum () { return new QComboBox_InsertPolicy_Enum (QComboBox::InsertAtCurrent); }
static QComboBox_InsertPolicy_Enum *c_4_QComboBox_InsertPolicy_Enum () { return new QComboBox_InsertPolicy_Enum (QComboBox::InsertAtBottom); }
static QComboBox_InsertPolicy_Enum *c_5_QComboBox_InsertPolicy_Enum () { return new QComboBox_InsertPolicy_Enum (QComboBox::InsertAfterCurrent); }
static QComboBox_InsertPolicy_Enum *c_6_QComboBox_InsertPolicy_Enum () { return new QComboBox_InsertPolicy_Enum (QComboBox::InsertBeforeCurrent); }
static QComboBox_InsertPolicy_Enum *c_7_QComboBox_InsertPolicy_Enum () { return new QComboBox_InsertPolicy_Enum (QComboBox::InsertAlphabetically); }

static gsi::Methods mkdefs_QComboBox_InsertPolicy () {
  return
    gsi::constant ("NoInsert", &qt_gsi::c_1_QComboBox_InsertPolicy_Enum, "@brief Enum constant QComboBox::NoInsert") +
    gsi::constant ("InsertAtTop", &qt_gsi::c_2_QComboBox_InsertPolicy_Enum, "@brief Enum constant QComboBox::InsertAtTop") +
    gsi::constant ("InsertAtCurrent", &qt_gsi::c_3_QComboBox_InsertPolicy_Enum, "@brief Enum constant QComboBox::InsertAtCurrent") +
    gsi::constant ("InsertAtBottom", &qt_gsi::c_4_QComboBox_InsertPolicy_Enum, "@brief Enum constant QComboBox::InsertAtBottom") +
    gsi::constant ("InsertAfterCurrent", &qt_gsi::c_5_QComboBox_InsertPolicy_Enum, "@brief Enum constant QComboBox::InsertAfterCurrent") +
    gsi::constant ("InsertBeforeCurrent", &qt_gsi::c_6_QComboBox_InsertPolicy_Enum, "@brief Enum constant QComboBox::InsertBeforeCurrent") +
    gsi::constant ("InsertAlphabetically", &qt_gsi::c_7_QComboBox_InsertPolicy_Enum, "@brief Enum constant QComboBox::InsertAlphabetically");
}

static std::string to_s_QComboBox_InsertPolicy_Enum (const QComboBox_InsertPolicy_Enum *e)
{
  if (e->value () == QComboBox::NoInsert) { return tl::sprintf ("NoInsert (%u)", (unsigned int) e->value ()); }
  if (e->value () == QComboBox::InsertAtTop) { return tl::sprintf ("InsertAtTop (%u)", (unsigned int) e->value ()); }
  if (e->value () == QComboBox::InsertAtCurrent) { return tl::sprintf ("InsertAtCurrent (%u)", (unsigned int) e->value ()); }
  if (e->value () == QComboBox::InsertAtBottom) { return tl::sprintf ("InsertAtBottom (%u)", (unsigned int) e->value ()); }
  if (e->value () == QComboBox::InsertAfterCurrent) { return tl::sprintf ("InsertAfterCurrent (%u)", (unsigned int) e->value ()); }
  if (e->value () == QComboBox::InsertBeforeCurrent) { return tl::sprintf ("InsertBeforeCurrent (%u)", (unsigned int) e->value ()); }
  if (e->value () == QComboBox::InsertAlphabetically) { return tl::sprintf ("InsertAlphabetically (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QComboBox_InsertPolicy_Enum (const QComboBox_InsertPolicy_Enum *e)
{
  return (unsigned int) e->value ();
}

static QComboBox_InsertPolicy_Enum *from_i_QComboBox_InsertPolicy_Enum (unsigned int i)
{
  return new QComboBox_InsertPolicy_Enum ((QComboBox::InsertPolicy) i);
}

static bool equalQComboBox_InsertPolicy_Enum (const QComboBox_InsertPolicy_Enum *e, QComboBox_InsertPolicy_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QComboBox_InsertPolicy_Enum (const QComboBox_InsertPolicy_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QComboBox_InsertPolicy_Enums oropQComboBox_InsertPolicy_Enums (const QComboBox_InsertPolicy_Enums *e, const QComboBox_InsertPolicy_Enums &d)
{
  return e->flags () | d.flags ();
}

static QComboBox_InsertPolicy_Enums andopQComboBox_InsertPolicy_Enums (const QComboBox_InsertPolicy_Enums *e, const QComboBox_InsertPolicy_Enums &d)
{
  return e->flags () & d.flags ();
}

static QComboBox_InsertPolicy_Enums xoropQComboBox_InsertPolicy_Enums (const QComboBox_InsertPolicy_Enums *e, const QComboBox_InsertPolicy_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QComboBox_InsertPolicy_Enums (const QComboBox_InsertPolicy_Enums *e)
{
  std::string l;
  if (e->testFlag (QComboBox::NoInsert)) { if (!l.empty ()) l += "|"; l += "NoInsert"; }
  if (e->testFlag (QComboBox::InsertAtTop)) { if (!l.empty ()) l += "|"; l += "InsertAtTop"; }
  if (e->testFlag (QComboBox::InsertAtCurrent)) { if (!l.empty ()) l += "|"; l += "InsertAtCurrent"; }
  if (e->testFlag (QComboBox::InsertAtBottom)) { if (!l.empty ()) l += "|"; l += "InsertAtBottom"; }
  if (e->testFlag (QComboBox::InsertAfterCurrent)) { if (!l.empty ()) l += "|"; l += "InsertAfterCurrent"; }
  if (e->testFlag (QComboBox::InsertBeforeCurrent)) { if (!l.empty ()) l += "|"; l += "InsertBeforeCurrent"; }
  if (e->testFlag (QComboBox::InsertAlphabetically)) { if (!l.empty ()) l += "|"; l += "InsertAlphabetically"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QComboBox_InsertPolicy_Enums (const QComboBox_InsertPolicy_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QComboBox_InsertPolicy_Enums (const QComboBox_InsertPolicy_Enums *e, const QComboBox_InsertPolicy_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QComboBox_InsertPolicy_Enums> decl_QComboBox_InsertPolicy_Enums ("QComboBox_QFlags_InsertPolicy",
  gsi::method_ext ("|", &qt_gsi::oropQComboBox_InsertPolicy_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQComboBox_InsertPolicy_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQComboBox_InsertPolicy_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QComboBox_InsertPolicy_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QComboBox_InsertPolicy_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QComboBox_InsertPolicy_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QComboBox::InsertPolicy> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QComboBox_InsertPolicy_Enum> decl_QComboBox_InsertPolicy_Enum (decl_QComboBox_InsertPolicy_Enums, "QComboBox_InsertPolicy",
  qt_gsi::mkdefs_QComboBox_InsertPolicy () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QComboBox_InsertPolicy_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QComboBox_InsertPolicy_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQComboBox_InsertPolicy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QComboBox_InsertPolicy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QComboBox_InsertPolicy_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QComboBox::InsertPolicy enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QComboBox> inject_QComboBox_InsertPolicy_Enum_in_parent (qt_gsi::mkdefs_QComboBox_InsertPolicy ());
static gsi::ClassExt<QComboBox> decl_QComboBox_InsertPolicy_Enum_as_child (decl_QComboBox_InsertPolicy_Enum, "InsertPolicy");

}


//  Implementation of the enum wrapper class for QComboBox::SizeAdjustPolicy
namespace qt_gsi
{

static QComboBox_SizeAdjustPolicy_Enum *c_1_QComboBox_SizeAdjustPolicy_Enum () { return new QComboBox_SizeAdjustPolicy_Enum (QComboBox::AdjustToContents); }
static QComboBox_SizeAdjustPolicy_Enum *c_2_QComboBox_SizeAdjustPolicy_Enum () { return new QComboBox_SizeAdjustPolicy_Enum (QComboBox::AdjustToContentsOnFirstShow); }
static QComboBox_SizeAdjustPolicy_Enum *c_3_QComboBox_SizeAdjustPolicy_Enum () { return new QComboBox_SizeAdjustPolicy_Enum (QComboBox::AdjustToMinimumContentsLength); }
static QComboBox_SizeAdjustPolicy_Enum *c_4_QComboBox_SizeAdjustPolicy_Enum () { return new QComboBox_SizeAdjustPolicy_Enum (QComboBox::AdjustToMinimumContentsLengthWithIcon); }

static gsi::Methods mkdefs_QComboBox_SizeAdjustPolicy () {
  return
    gsi::constant ("AdjustToContents", &qt_gsi::c_1_QComboBox_SizeAdjustPolicy_Enum, "@brief Enum constant QComboBox::AdjustToContents") +
    gsi::constant ("AdjustToContentsOnFirstShow", &qt_gsi::c_2_QComboBox_SizeAdjustPolicy_Enum, "@brief Enum constant QComboBox::AdjustToContentsOnFirstShow") +
    gsi::constant ("AdjustToMinimumContentsLength", &qt_gsi::c_3_QComboBox_SizeAdjustPolicy_Enum, "@brief Enum constant QComboBox::AdjustToMinimumContentsLength") +
    gsi::constant ("AdjustToMinimumContentsLengthWithIcon", &qt_gsi::c_4_QComboBox_SizeAdjustPolicy_Enum, "@brief Enum constant QComboBox::AdjustToMinimumContentsLengthWithIcon");
}

static std::string to_s_QComboBox_SizeAdjustPolicy_Enum (const QComboBox_SizeAdjustPolicy_Enum *e)
{
  if (e->value () == QComboBox::AdjustToContents) { return tl::sprintf ("AdjustToContents (%u)", (unsigned int) e->value ()); }
  if (e->value () == QComboBox::AdjustToContentsOnFirstShow) { return tl::sprintf ("AdjustToContentsOnFirstShow (%u)", (unsigned int) e->value ()); }
  if (e->value () == QComboBox::AdjustToMinimumContentsLength) { return tl::sprintf ("AdjustToMinimumContentsLength (%u)", (unsigned int) e->value ()); }
  if (e->value () == QComboBox::AdjustToMinimumContentsLengthWithIcon) { return tl::sprintf ("AdjustToMinimumContentsLengthWithIcon (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QComboBox_SizeAdjustPolicy_Enum (const QComboBox_SizeAdjustPolicy_Enum *e)
{
  return (unsigned int) e->value ();
}

static QComboBox_SizeAdjustPolicy_Enum *from_i_QComboBox_SizeAdjustPolicy_Enum (unsigned int i)
{
  return new QComboBox_SizeAdjustPolicy_Enum ((QComboBox::SizeAdjustPolicy) i);
}

static bool equalQComboBox_SizeAdjustPolicy_Enum (const QComboBox_SizeAdjustPolicy_Enum *e, QComboBox_SizeAdjustPolicy_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QComboBox_SizeAdjustPolicy_Enum (const QComboBox_SizeAdjustPolicy_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QComboBox_SizeAdjustPolicy_Enums oropQComboBox_SizeAdjustPolicy_Enums (const QComboBox_SizeAdjustPolicy_Enums *e, const QComboBox_SizeAdjustPolicy_Enums &d)
{
  return e->flags () | d.flags ();
}

static QComboBox_SizeAdjustPolicy_Enums andopQComboBox_SizeAdjustPolicy_Enums (const QComboBox_SizeAdjustPolicy_Enums *e, const QComboBox_SizeAdjustPolicy_Enums &d)
{
  return e->flags () & d.flags ();
}

static QComboBox_SizeAdjustPolicy_Enums xoropQComboBox_SizeAdjustPolicy_Enums (const QComboBox_SizeAdjustPolicy_Enums *e, const QComboBox_SizeAdjustPolicy_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QComboBox_SizeAdjustPolicy_Enums (const QComboBox_SizeAdjustPolicy_Enums *e)
{
  std::string l;
  if (e->testFlag (QComboBox::AdjustToContents)) { if (!l.empty ()) l += "|"; l += "AdjustToContents"; }
  if (e->testFlag (QComboBox::AdjustToContentsOnFirstShow)) { if (!l.empty ()) l += "|"; l += "AdjustToContentsOnFirstShow"; }
  if (e->testFlag (QComboBox::AdjustToMinimumContentsLength)) { if (!l.empty ()) l += "|"; l += "AdjustToMinimumContentsLength"; }
  if (e->testFlag (QComboBox::AdjustToMinimumContentsLengthWithIcon)) { if (!l.empty ()) l += "|"; l += "AdjustToMinimumContentsLengthWithIcon"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QComboBox_SizeAdjustPolicy_Enums (const QComboBox_SizeAdjustPolicy_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QComboBox_SizeAdjustPolicy_Enums (const QComboBox_SizeAdjustPolicy_Enums *e, const QComboBox_SizeAdjustPolicy_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QComboBox_SizeAdjustPolicy_Enums> decl_QComboBox_SizeAdjustPolicy_Enums ("QComboBox_QFlags_SizeAdjustPolicy",
  gsi::method_ext ("|", &qt_gsi::oropQComboBox_SizeAdjustPolicy_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQComboBox_SizeAdjustPolicy_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQComboBox_SizeAdjustPolicy_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QComboBox_SizeAdjustPolicy_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QComboBox_SizeAdjustPolicy_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QComboBox_SizeAdjustPolicy_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QComboBox::SizeAdjustPolicy> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QComboBox_SizeAdjustPolicy_Enum> decl_QComboBox_SizeAdjustPolicy_Enum (decl_QComboBox_SizeAdjustPolicy_Enums, "QComboBox_SizeAdjustPolicy",
  qt_gsi::mkdefs_QComboBox_SizeAdjustPolicy () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QComboBox_SizeAdjustPolicy_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QComboBox_SizeAdjustPolicy_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQComboBox_SizeAdjustPolicy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QComboBox_SizeAdjustPolicy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QComboBox_SizeAdjustPolicy_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QComboBox::SizeAdjustPolicy enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QComboBox> inject_QComboBox_SizeAdjustPolicy_Enum_in_parent (qt_gsi::mkdefs_QComboBox_SizeAdjustPolicy ());
static gsi::ClassExt<QComboBox> decl_QComboBox_SizeAdjustPolicy_Enum_as_child (decl_QComboBox_SizeAdjustPolicy_Enum, "SizeAdjustPolicy");

}

