
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAction.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQAction_EventAdaptor.h"
#include "gsiDeclQAction_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAction

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAction::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QActionGroup *QAction::actionGroup()


static void _init_f_actionGroup_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QActionGroup * > ();
}

static void _call_f_actionGroup_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QActionGroup * > ((QActionGroup *)((QAction *)cls)->actionGroup ());
}

static qt_gsi::GenericMethod *_create_f_actionGroup_c0 ()
{
  return new qt_gsi::GenericMethod (":actionGroup", "@brief Method QActionGroup *QAction::actionGroup()\n", true, &_init_f_actionGroup_c0, &_call_f_actionGroup_c0);
}

// void QAction::activate(QAction::ActionEvent event)


static void _init_f_activate_2359 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<const qt_gsi::Converter<QAction::ActionEvent>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_activate_2359 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QAction::ActionEvent>::target_type & arg1 = args.read<const qt_gsi::Converter<QAction::ActionEvent>::target_type & > ();
  ((QAction *)cls)->activate (qt_gsi::QtToCppAdaptor<QAction::ActionEvent>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_activate_2359 ()
{
  return new qt_gsi::GenericMethod ("activate", "@brief Method void QAction::activate(QAction::ActionEvent event)\n", false, &_init_f_activate_2359, &_call_f_activate_2359);
}

// QList<QGraphicsWidget *> QAction::associatedGraphicsWidgets()


static void _init_f_associatedGraphicsWidgets_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QGraphicsWidget *> >::target_type > ();
}

static void _call_f_associatedGraphicsWidgets_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QGraphicsWidget *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsWidget *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsWidget *> >(((QAction *)cls)->associatedGraphicsWidgets ()));
}

static qt_gsi::GenericMethod *_create_f_associatedGraphicsWidgets_c0 ()
{
  return new qt_gsi::GenericMethod ("associatedGraphicsWidgets", "@brief Method QList<QGraphicsWidget *> QAction::associatedGraphicsWidgets()\n", true, &_init_f_associatedGraphicsWidgets_c0, &_call_f_associatedGraphicsWidgets_c0);
}

// QList<QWidget *> QAction::associatedWidgets()


static void _init_f_associatedWidgets_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QWidget *> >::target_type > ();
}

static void _call_f_associatedWidgets_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QWidget *> >::target_type > ((qt_gsi::Converter<QList<QWidget *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QWidget *> >(((QAction *)cls)->associatedWidgets ()));
}

static qt_gsi::GenericMethod *_create_f_associatedWidgets_c0 ()
{
  return new qt_gsi::GenericMethod ("associatedWidgets", "@brief Method QList<QWidget *> QAction::associatedWidgets()\n", true, &_init_f_associatedWidgets_c0, &_call_f_associatedWidgets_c0);
}

// bool QAction::autoRepeat()


static void _init_f_autoRepeat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_autoRepeat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QAction *)cls)->autoRepeat ());
}

static qt_gsi::GenericMethod *_create_f_autoRepeat_c0 ()
{
  return new qt_gsi::GenericMethod (":autoRepeat", "@brief Method bool QAction::autoRepeat()\n", true, &_init_f_autoRepeat_c0, &_call_f_autoRepeat_c0);
}

// QVariant QAction::data()


static void _init_f_data_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVariant > ();
}

static void _call_f_data_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QVariant > ((QVariant)((QAction *)cls)->data ());
}

static qt_gsi::GenericMethod *_create_f_data_c0 ()
{
  return new qt_gsi::GenericMethod (":data", "@brief Method QVariant QAction::data()\n", true, &_init_f_data_c0, &_call_f_data_c0);
}

// QFont QAction::font()


static void _init_f_font_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFont > ();
}

static void _call_f_font_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QFont > ((QFont)((QAction *)cls)->font ());
}

static qt_gsi::GenericMethod *_create_f_font_c0 ()
{
  return new qt_gsi::GenericMethod (":font", "@brief Method QFont QAction::font()\n", true, &_init_f_font_c0, &_call_f_font_c0);
}

// void QAction::hover()


static void _init_f_hover_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_hover_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAction *)cls)->hover ();
}

static qt_gsi::GenericMethod *_create_f_hover_0 ()
{
  return new qt_gsi::GenericMethod ("hover", "@brief Method void QAction::hover()\n", false, &_init_f_hover_0, &_call_f_hover_0);
}

// QIcon QAction::icon()


static void _init_f_icon_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIcon > ();
}

static void _call_f_icon_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QIcon > ((QIcon)((QAction *)cls)->icon ());
}

static qt_gsi::GenericMethod *_create_f_icon_c0 ()
{
  return new qt_gsi::GenericMethod (":icon", "@brief Method QIcon QAction::icon()\n", true, &_init_f_icon_c0, &_call_f_icon_c0);
}

// QString QAction::iconText()


static void _init_f_iconText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_iconText_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QAction *)cls)->iconText ());
}

static qt_gsi::GenericMethod *_create_f_iconText_c0 ()
{
  return new qt_gsi::GenericMethod (":iconText", "@brief Method QString QAction::iconText()\n", true, &_init_f_iconText_c0, &_call_f_iconText_c0);
}

// bool QAction::isCheckable()


static void _init_f_isCheckable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isCheckable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QAction *)cls)->isCheckable ());
}

static qt_gsi::GenericMethod *_create_f_isCheckable_c0 ()
{
  return new qt_gsi::GenericMethod ("isCheckable?|:checkable", "@brief Method bool QAction::isCheckable()\n", true, &_init_f_isCheckable_c0, &_call_f_isCheckable_c0);
}

// bool QAction::isChecked()


static void _init_f_isChecked_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isChecked_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QAction *)cls)->isChecked ());
}

static qt_gsi::GenericMethod *_create_f_isChecked_c0 ()
{
  return new qt_gsi::GenericMethod ("isChecked?|:checked", "@brief Method bool QAction::isChecked()\n", true, &_init_f_isChecked_c0, &_call_f_isChecked_c0);
}

// bool QAction::isEnabled()


static void _init_f_isEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEnabled_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QAction *)cls)->isEnabled ());
}

static qt_gsi::GenericMethod *_create_f_isEnabled_c0 ()
{
  return new qt_gsi::GenericMethod ("isEnabled?|:enabled", "@brief Method bool QAction::isEnabled()\n", true, &_init_f_isEnabled_c0, &_call_f_isEnabled_c0);
}

// bool QAction::isIconVisibleInMenu()


static void _init_f_isIconVisibleInMenu_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isIconVisibleInMenu_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QAction *)cls)->isIconVisibleInMenu ());
}

static qt_gsi::GenericMethod *_create_f_isIconVisibleInMenu_c0 ()
{
  return new qt_gsi::GenericMethod ("isIconVisibleInMenu?|:iconVisibleInMenu", "@brief Method bool QAction::isIconVisibleInMenu()\n", true, &_init_f_isIconVisibleInMenu_c0, &_call_f_isIconVisibleInMenu_c0);
}

// bool QAction::isSeparator()


static void _init_f_isSeparator_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSeparator_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QAction *)cls)->isSeparator ());
}

static qt_gsi::GenericMethod *_create_f_isSeparator_c0 ()
{
  return new qt_gsi::GenericMethod ("isSeparator?|:separator", "@brief Method bool QAction::isSeparator()\n", true, &_init_f_isSeparator_c0, &_call_f_isSeparator_c0);
}

// bool QAction::isVisible()


static void _init_f_isVisible_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isVisible_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QAction *)cls)->isVisible ());
}

static qt_gsi::GenericMethod *_create_f_isVisible_c0 ()
{
  return new qt_gsi::GenericMethod ("isVisible?|:visible", "@brief Method bool QAction::isVisible()\n", true, &_init_f_isVisible_c0, &_call_f_isVisible_c0);
}

// QMenu *QAction::menu()


static void _init_f_menu_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMenu * > ();
}

static void _call_f_menu_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QMenu * > ((QMenu *)((QAction *)cls)->menu ());
}

static qt_gsi::GenericMethod *_create_f_menu_c0 ()
{
  return new qt_gsi::GenericMethod (":menu", "@brief Method QMenu *QAction::menu()\n", true, &_init_f_menu_c0, &_call_f_menu_c0);
}

// QAction::MenuRole QAction::menuRole()


static void _init_f_menuRole_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAction::MenuRole>::target_type > ();
}

static void _call_f_menuRole_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QAction::MenuRole>::target_type > ((qt_gsi::Converter<QAction::MenuRole>::target_type)qt_gsi::CppToQtAdaptor<QAction::MenuRole>(((QAction *)cls)->menuRole ()));
}

static qt_gsi::GenericMethod *_create_f_menuRole_c0 ()
{
  return new qt_gsi::GenericMethod (":menuRole", "@brief Method QAction::MenuRole QAction::menuRole()\n", true, &_init_f_menuRole_c0, &_call_f_menuRole_c0);
}

// QWidget *QAction::parentWidget()


static void _init_f_parentWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_parentWidget_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)((QAction *)cls)->parentWidget ());
}

static qt_gsi::GenericMethod *_create_f_parentWidget_c0 ()
{
  return new qt_gsi::GenericMethod ("parentWidget", "@brief Method QWidget *QAction::parentWidget()\n", true, &_init_f_parentWidget_c0, &_call_f_parentWidget_c0);
}

// QAction::Priority QAction::priority()


static void _init_f_priority_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAction::Priority>::target_type > ();
}

static void _call_f_priority_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QAction::Priority>::target_type > ((qt_gsi::Converter<QAction::Priority>::target_type)qt_gsi::CppToQtAdaptor<QAction::Priority>(((QAction *)cls)->priority ()));
}

static qt_gsi::GenericMethod *_create_f_priority_c0 ()
{
  return new qt_gsi::GenericMethod (":priority", "@brief Method QAction::Priority QAction::priority()\n", true, &_init_f_priority_c0, &_call_f_priority_c0);
}

// void QAction::setActionGroup(QActionGroup *group)


static void _init_f_setActionGroup_1834 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("group");
  decl->add_arg<QActionGroup * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActionGroup_1834 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QActionGroup *arg1 = args.read<QActionGroup * > ();
  ((QAction *)cls)->setActionGroup (arg1);
}

static qt_gsi::GenericMethod *_create_f_setActionGroup_1834 ()
{
  return new qt_gsi::GenericMethod ("setActionGroup|actionGroup=", "@brief Method void QAction::setActionGroup(QActionGroup *group)\n", false, &_init_f_setActionGroup_1834, &_call_f_setActionGroup_1834);
}

// void QAction::setAutoRepeat(bool)


static void _init_f_setAutoRepeat_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAutoRepeat_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QAction *)cls)->setAutoRepeat (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAutoRepeat_864 ()
{
  return new qt_gsi::GenericMethod ("setAutoRepeat|autoRepeat=", "@brief Method void QAction::setAutoRepeat(bool)\n", false, &_init_f_setAutoRepeat_864, &_call_f_setAutoRepeat_864);
}

// void QAction::setCheckable(bool)


static void _init_f_setCheckable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCheckable_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QAction *)cls)->setCheckable (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCheckable_864 ()
{
  return new qt_gsi::GenericMethod ("setCheckable|checkable=", "@brief Method void QAction::setCheckable(bool)\n", false, &_init_f_setCheckable_864, &_call_f_setCheckable_864);
}

// void QAction::setChecked(bool)


static void _init_f_setChecked_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setChecked_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QAction *)cls)->setChecked (arg1);
}

static qt_gsi::GenericMethod *_create_f_setChecked_864 ()
{
  return new qt_gsi::GenericMethod ("setChecked|checked=", "@brief Method void QAction::setChecked(bool)\n", false, &_init_f_setChecked_864, &_call_f_setChecked_864);
}

// void QAction::setData(const QVariant &var)


static void _init_f_setData_2119 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("var");
  decl->add_arg<const QVariant & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setData_2119 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVariant &arg1 = args.read<const QVariant & > ();
  ((QAction *)cls)->setData (arg1);
}

static qt_gsi::GenericMethod *_create_f_setData_2119 ()
{
  return new qt_gsi::GenericMethod ("setData|data=", "@brief Method void QAction::setData(const QVariant &var)\n", false, &_init_f_setData_2119, &_call_f_setData_2119);
}

// void QAction::setDisabled(bool b)


static void _init_f_setDisabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDisabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QAction *)cls)->setDisabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDisabled_864 ()
{
  return new qt_gsi::GenericMethod ("setDisabled", "@brief Method void QAction::setDisabled(bool b)\n", false, &_init_f_setDisabled_864, &_call_f_setDisabled_864);
}

// void QAction::setEnabled(bool)


static void _init_f_setEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEnabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QAction *)cls)->setEnabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setEnabled_864 ()
{
  return new qt_gsi::GenericMethod ("setEnabled|enabled=", "@brief Method void QAction::setEnabled(bool)\n", false, &_init_f_setEnabled_864, &_call_f_setEnabled_864);
}

// void QAction::setFont(const QFont &font)


static void _init_f_setFont_1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("font");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFont_1801 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QAction *)cls)->setFont (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFont_1801 ()
{
  return new qt_gsi::GenericMethod ("setFont|font=", "@brief Method void QAction::setFont(const QFont &font)\n", false, &_init_f_setFont_1801, &_call_f_setFont_1801);
}

// void QAction::setIcon(const QIcon &icon)


static void _init_f_setIcon_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIcon_1787 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QIcon &arg1 = args.read<const QIcon & > ();
  ((QAction *)cls)->setIcon (arg1);
}

static qt_gsi::GenericMethod *_create_f_setIcon_1787 ()
{
  return new qt_gsi::GenericMethod ("setIcon|icon=", "@brief Method void QAction::setIcon(const QIcon &icon)\n", false, &_init_f_setIcon_1787, &_call_f_setIcon_1787);
}

// void QAction::setIconText(const QString &text)


static void _init_f_setIconText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIconText_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QAction *)cls)->setIconText (arg1);
}

static qt_gsi::GenericMethod *_create_f_setIconText_2025 ()
{
  return new qt_gsi::GenericMethod ("setIconText|iconText=", "@brief Method void QAction::setIconText(const QString &text)\n", false, &_init_f_setIconText_2025, &_call_f_setIconText_2025);
}

// void QAction::setIconVisibleInMenu(bool visible)


static void _init_f_setIconVisibleInMenu_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIconVisibleInMenu_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QAction *)cls)->setIconVisibleInMenu (arg1);
}

static qt_gsi::GenericMethod *_create_f_setIconVisibleInMenu_864 ()
{
  return new qt_gsi::GenericMethod ("setIconVisibleInMenu|iconVisibleInMenu=", "@brief Method void QAction::setIconVisibleInMenu(bool visible)\n", false, &_init_f_setIconVisibleInMenu_864, &_call_f_setIconVisibleInMenu_864);
}

// void QAction::setMenu(QMenu *menu)


static void _init_f_setMenu_1108 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("menu");
  decl->add_arg<QMenu * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMenu_1108 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMenu *arg1 = args.read<QMenu * > ();
  ((QAction *)cls)->setMenu (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMenu_1108 ()
{
  return new qt_gsi::GenericMethod ("setMenu|menu=", "@brief Method void QAction::setMenu(QMenu *menu)\n", false, &_init_f_setMenu_1108, &_call_f_setMenu_1108);
}

// void QAction::setMenuRole(QAction::MenuRole menuRole)


static void _init_f_setMenuRole_2046 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("menuRole");
  decl->add_arg<const qt_gsi::Converter<QAction::MenuRole>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMenuRole_2046 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QAction::MenuRole>::target_type & arg1 = args.read<const qt_gsi::Converter<QAction::MenuRole>::target_type & > ();
  ((QAction *)cls)->setMenuRole (qt_gsi::QtToCppAdaptor<QAction::MenuRole>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setMenuRole_2046 ()
{
  return new qt_gsi::GenericMethod ("setMenuRole|menuRole=", "@brief Method void QAction::setMenuRole(QAction::MenuRole menuRole)\n", false, &_init_f_setMenuRole_2046, &_call_f_setMenuRole_2046);
}

// void QAction::setPriority(QAction::Priority priority)


static void _init_f_setPriority_2105 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("priority");
  decl->add_arg<const qt_gsi::Converter<QAction::Priority>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPriority_2105 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QAction::Priority>::target_type & arg1 = args.read<const qt_gsi::Converter<QAction::Priority>::target_type & > ();
  ((QAction *)cls)->setPriority (qt_gsi::QtToCppAdaptor<QAction::Priority>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setPriority_2105 ()
{
  return new qt_gsi::GenericMethod ("setPriority|priority=", "@brief Method void QAction::setPriority(QAction::Priority priority)\n", false, &_init_f_setPriority_2105, &_call_f_setPriority_2105);
}

// void QAction::setSeparator(bool b)


static void _init_f_setSeparator_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSeparator_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QAction *)cls)->setSeparator (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSeparator_864 ()
{
  return new qt_gsi::GenericMethod ("setSeparator|separator=", "@brief Method void QAction::setSeparator(bool b)\n", false, &_init_f_setSeparator_864, &_call_f_setSeparator_864);
}

// void QAction::setShortcut(const QKeySequence &shortcut)


static void _init_f_setShortcut_2516 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("shortcut");
  decl->add_arg<const QKeySequence & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setShortcut_2516 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QKeySequence &arg1 = args.read<const QKeySequence & > ();
  ((QAction *)cls)->setShortcut (arg1);
}

static qt_gsi::GenericMethod *_create_f_setShortcut_2516 ()
{
  return new qt_gsi::GenericMethod ("setShortcut|shortcut=", "@brief Method void QAction::setShortcut(const QKeySequence &shortcut)\n", false, &_init_f_setShortcut_2516, &_call_f_setShortcut_2516);
}

// void QAction::setShortcutContext(Qt::ShortcutContext context)


static void _init_f_setShortcutContext_2350 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("context");
  decl->add_arg<const qt_gsi::Converter<Qt::ShortcutContext>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setShortcutContext_2350 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::ShortcutContext>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::ShortcutContext>::target_type & > ();
  ((QAction *)cls)->setShortcutContext (qt_gsi::QtToCppAdaptor<Qt::ShortcutContext>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setShortcutContext_2350 ()
{
  return new qt_gsi::GenericMethod ("setShortcutContext|shortcutContext=", "@brief Method void QAction::setShortcutContext(Qt::ShortcutContext context)\n", false, &_init_f_setShortcutContext_2350, &_call_f_setShortcutContext_2350);
}

// void QAction::setShortcuts(const QList<QKeySequence> &shortcuts)


static void _init_f_setShortcuts_3131 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("shortcuts");
  decl->add_arg<const qt_gsi::Converter<QList<QKeySequence> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setShortcuts_3131 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QKeySequence> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QKeySequence> >::target_type & > ();
  ((QAction *)cls)->setShortcuts (qt_gsi::QtToCppAdaptor<QList<QKeySequence> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setShortcuts_3131 ()
{
  return new qt_gsi::GenericMethod ("setShortcuts|shortcuts=", "@brief Method void QAction::setShortcuts(const QList<QKeySequence> &shortcuts)\n", false, &_init_f_setShortcuts_3131, &_call_f_setShortcuts_3131);
}

// void QAction::setShortcuts(QKeySequence::StandardKey)


static void _init_f_setShortcuts_2869 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QKeySequence::StandardKey>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setShortcuts_2869 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QKeySequence::StandardKey>::target_type & arg1 = args.read<const qt_gsi::Converter<QKeySequence::StandardKey>::target_type & > ();
  ((QAction *)cls)->setShortcuts (qt_gsi::QtToCppAdaptor<QKeySequence::StandardKey>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setShortcuts_2869 ()
{
  return new qt_gsi::GenericMethod ("setShortcuts|shortcuts=", "@brief Method void QAction::setShortcuts(QKeySequence::StandardKey)\n", false, &_init_f_setShortcuts_2869, &_call_f_setShortcuts_2869);
}

// void QAction::setSoftKeyRole(QAction::SoftKeyRole softKeyRole)


static void _init_f_setSoftKeyRole_2350 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("softKeyRole");
  decl->add_arg<const qt_gsi::Converter<QAction::SoftKeyRole>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSoftKeyRole_2350 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QAction::SoftKeyRole>::target_type & arg1 = args.read<const qt_gsi::Converter<QAction::SoftKeyRole>::target_type & > ();
  ((QAction *)cls)->setSoftKeyRole (qt_gsi::QtToCppAdaptor<QAction::SoftKeyRole>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setSoftKeyRole_2350 ()
{
  return new qt_gsi::GenericMethod ("setSoftKeyRole|softKeyRole=", "@brief Method void QAction::setSoftKeyRole(QAction::SoftKeyRole softKeyRole)\n", false, &_init_f_setSoftKeyRole_2350, &_call_f_setSoftKeyRole_2350);
}

// void QAction::setStatusTip(const QString &statusTip)


static void _init_f_setStatusTip_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("statusTip");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStatusTip_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QAction *)cls)->setStatusTip (arg1);
}

static qt_gsi::GenericMethod *_create_f_setStatusTip_2025 ()
{
  return new qt_gsi::GenericMethod ("setStatusTip|statusTip=", "@brief Method void QAction::setStatusTip(const QString &statusTip)\n", false, &_init_f_setStatusTip_2025, &_call_f_setStatusTip_2025);
}

// void QAction::setText(const QString &text)


static void _init_f_setText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setText_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QAction *)cls)->setText (arg1);
}

static qt_gsi::GenericMethod *_create_f_setText_2025 ()
{
  return new qt_gsi::GenericMethod ("setText|text=", "@brief Method void QAction::setText(const QString &text)\n", false, &_init_f_setText_2025, &_call_f_setText_2025);
}

// void QAction::setToolTip(const QString &tip)


static void _init_f_setToolTip_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tip");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setToolTip_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QAction *)cls)->setToolTip (arg1);
}

static qt_gsi::GenericMethod *_create_f_setToolTip_2025 ()
{
  return new qt_gsi::GenericMethod ("setToolTip|toolTip=", "@brief Method void QAction::setToolTip(const QString &tip)\n", false, &_init_f_setToolTip_2025, &_call_f_setToolTip_2025);
}

// void QAction::setVisible(bool)


static void _init_f_setVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVisible_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QAction *)cls)->setVisible (arg1);
}

static qt_gsi::GenericMethod *_create_f_setVisible_864 ()
{
  return new qt_gsi::GenericMethod ("setVisible|visible=", "@brief Method void QAction::setVisible(bool)\n", false, &_init_f_setVisible_864, &_call_f_setVisible_864);
}

// void QAction::setWhatsThis(const QString &what)


static void _init_f_setWhatsThis_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("what");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWhatsThis_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QAction *)cls)->setWhatsThis (arg1);
}

static qt_gsi::GenericMethod *_create_f_setWhatsThis_2025 ()
{
  return new qt_gsi::GenericMethod ("setWhatsThis|whatsThis=", "@brief Method void QAction::setWhatsThis(const QString &what)\n", false, &_init_f_setWhatsThis_2025, &_call_f_setWhatsThis_2025);
}

// QKeySequence QAction::shortcut()


static void _init_f_shortcut_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QKeySequence > ();
}

static void _call_f_shortcut_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QKeySequence > ((QKeySequence)((QAction *)cls)->shortcut ());
}

static qt_gsi::GenericMethod *_create_f_shortcut_c0 ()
{
  return new qt_gsi::GenericMethod (":shortcut", "@brief Method QKeySequence QAction::shortcut()\n", true, &_init_f_shortcut_c0, &_call_f_shortcut_c0);
}

// Qt::ShortcutContext QAction::shortcutContext()


static void _init_f_shortcutContext_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::ShortcutContext>::target_type > ();
}

static void _call_f_shortcutContext_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::ShortcutContext>::target_type > ((qt_gsi::Converter<Qt::ShortcutContext>::target_type)qt_gsi::CppToQtAdaptor<Qt::ShortcutContext>(((QAction *)cls)->shortcutContext ()));
}

static qt_gsi::GenericMethod *_create_f_shortcutContext_c0 ()
{
  return new qt_gsi::GenericMethod (":shortcutContext", "@brief Method Qt::ShortcutContext QAction::shortcutContext()\n", true, &_init_f_shortcutContext_c0, &_call_f_shortcutContext_c0);
}

// QList<QKeySequence> QAction::shortcuts()


static void _init_f_shortcuts_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QKeySequence> >::target_type > ();
}

static void _call_f_shortcuts_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QKeySequence> >::target_type > ((qt_gsi::Converter<QList<QKeySequence> >::target_type)qt_gsi::CppToQtAdaptor<QList<QKeySequence> >(((QAction *)cls)->shortcuts ()));
}

static qt_gsi::GenericMethod *_create_f_shortcuts_c0 ()
{
  return new qt_gsi::GenericMethod (":shortcuts", "@brief Method QList<QKeySequence> QAction::shortcuts()\n", true, &_init_f_shortcuts_c0, &_call_f_shortcuts_c0);
}

// bool QAction::showStatusText(QWidget *widget)


static void _init_f_showStatusText_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_showStatusText_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<bool > ((bool)((QAction *)cls)->showStatusText (arg1));
}

static qt_gsi::GenericMethod *_create_f_showStatusText_1315 ()
{
  return new qt_gsi::GenericMethod ("showStatusText", "@brief Method bool QAction::showStatusText(QWidget *widget)\n", false, &_init_f_showStatusText_1315, &_call_f_showStatusText_1315);
}

// QAction::SoftKeyRole QAction::softKeyRole()


static void _init_f_softKeyRole_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAction::SoftKeyRole>::target_type > ();
}

static void _call_f_softKeyRole_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QAction::SoftKeyRole>::target_type > ((qt_gsi::Converter<QAction::SoftKeyRole>::target_type)qt_gsi::CppToQtAdaptor<QAction::SoftKeyRole>(((QAction *)cls)->softKeyRole ()));
}

static qt_gsi::GenericMethod *_create_f_softKeyRole_c0 ()
{
  return new qt_gsi::GenericMethod (":softKeyRole", "@brief Method QAction::SoftKeyRole QAction::softKeyRole()\n", true, &_init_f_softKeyRole_c0, &_call_f_softKeyRole_c0);
}

// QString QAction::statusTip()


static void _init_f_statusTip_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_statusTip_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QAction *)cls)->statusTip ());
}

static qt_gsi::GenericMethod *_create_f_statusTip_c0 ()
{
  return new qt_gsi::GenericMethod (":statusTip", "@brief Method QString QAction::statusTip()\n", true, &_init_f_statusTip_c0, &_call_f_statusTip_c0);
}

// QString QAction::text()


static void _init_f_text_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_text_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QAction *)cls)->text ());
}

static qt_gsi::GenericMethod *_create_f_text_c0 ()
{
  return new qt_gsi::GenericMethod (":text", "@brief Method QString QAction::text()\n", true, &_init_f_text_c0, &_call_f_text_c0);
}

// void QAction::toggle()


static void _init_f_toggle_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_toggle_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAction *)cls)->toggle ();
}

static qt_gsi::GenericMethod *_create_f_toggle_0 ()
{
  return new qt_gsi::GenericMethod ("toggle", "@brief Method void QAction::toggle()\n", false, &_init_f_toggle_0, &_call_f_toggle_0);
}

// QString QAction::toolTip()


static void _init_f_toolTip_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toolTip_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QAction *)cls)->toolTip ());
}

static qt_gsi::GenericMethod *_create_f_toolTip_c0 ()
{
  return new qt_gsi::GenericMethod (":toolTip", "@brief Method QString QAction::toolTip()\n", true, &_init_f_toolTip_c0, &_call_f_toolTip_c0);
}

// void QAction::trigger()


static void _init_f_trigger_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_trigger_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAction *)cls)->trigger ();
}

static qt_gsi::GenericMethod *_create_f_trigger_0 ()
{
  return new qt_gsi::GenericMethod ("trigger", "@brief Method void QAction::trigger()\n", false, &_init_f_trigger_0, &_call_f_trigger_0);
}

// QString QAction::whatsThis()


static void _init_f_whatsThis_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_whatsThis_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QAction *)cls)->whatsThis ());
}

static qt_gsi::GenericMethod *_create_f_whatsThis_c0 ()
{
  return new qt_gsi::GenericMethod (":whatsThis", "@brief Method QString QAction::whatsThis()\n", true, &_init_f_whatsThis_c0, &_call_f_whatsThis_c0);
}

// static QString QAction::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QAction::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAction::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QAction::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QAction::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAction::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QAction::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QAction::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAction::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QAction::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QAction::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAction::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QAction, QAction_EventAdaptor> ea_QAction;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QAction> decl_QAction (ea_QAction, decl_QObject, "QAction_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_actionGroup_c0 ()) +
  gsi::Methods(_create_f_activate_2359 ()) +
  gsi::Methods(_create_f_associatedGraphicsWidgets_c0 ()) +
  gsi::Methods(_create_f_associatedWidgets_c0 ()) +
  gsi::Methods(_create_f_autoRepeat_c0 ()) +
  gsi::Methods(_create_f_data_c0 ()) +
  gsi::Methods(_create_f_font_c0 ()) +
  gsi::Methods(_create_f_hover_0 ()) +
  gsi::Methods(_create_f_icon_c0 ()) +
  gsi::Methods(_create_f_iconText_c0 ()) +
  gsi::Methods(_create_f_isCheckable_c0 ()) +
  gsi::Methods(_create_f_isChecked_c0 ()) +
  gsi::Methods(_create_f_isEnabled_c0 ()) +
  gsi::Methods(_create_f_isIconVisibleInMenu_c0 ()) +
  gsi::Methods(_create_f_isSeparator_c0 ()) +
  gsi::Methods(_create_f_isVisible_c0 ()) +
  gsi::Methods(_create_f_menu_c0 ()) +
  gsi::Methods(_create_f_menuRole_c0 ()) +
  gsi::Methods(_create_f_parentWidget_c0 ()) +
  gsi::Methods(_create_f_priority_c0 ()) +
  gsi::Methods(_create_f_setActionGroup_1834 ()) +
  gsi::Methods(_create_f_setAutoRepeat_864 ()) +
  gsi::Methods(_create_f_setCheckable_864 ()) +
  gsi::Methods(_create_f_setChecked_864 ()) +
  gsi::Methods(_create_f_setData_2119 ()) +
  gsi::Methods(_create_f_setDisabled_864 ()) +
  gsi::Methods(_create_f_setEnabled_864 ()) +
  gsi::Methods(_create_f_setFont_1801 ()) +
  gsi::Methods(_create_f_setIcon_1787 ()) +
  gsi::Methods(_create_f_setIconText_2025 ()) +
  gsi::Methods(_create_f_setIconVisibleInMenu_864 ()) +
  gsi::Methods(_create_f_setMenu_1108 ()) +
  gsi::Methods(_create_f_setMenuRole_2046 ()) +
  gsi::Methods(_create_f_setPriority_2105 ()) +
  gsi::Methods(_create_f_setSeparator_864 ()) +
  gsi::Methods(_create_f_setShortcut_2516 ()) +
  gsi::Methods(_create_f_setShortcutContext_2350 ()) +
  gsi::Methods(_create_f_setShortcuts_3131 ()) +
  gsi::Methods(_create_f_setShortcuts_2869 ()) +
  gsi::Methods(_create_f_setSoftKeyRole_2350 ()) +
  gsi::Methods(_create_f_setStatusTip_2025 ()) +
  gsi::Methods(_create_f_setText_2025 ()) +
  gsi::Methods(_create_f_setToolTip_2025 ()) +
  gsi::Methods(_create_f_setVisible_864 ()) +
  gsi::Methods(_create_f_setWhatsThis_2025 ()) +
  gsi::Methods(_create_f_shortcut_c0 ()) +
  gsi::Methods(_create_f_shortcutContext_c0 ()) +
  gsi::Methods(_create_f_shortcuts_c0 ()) +
  gsi::Methods(_create_f_showStatusText_1315 ()) +
  gsi::Methods(_create_f_softKeyRole_c0 ()) +
  gsi::Methods(_create_f_statusTip_c0 ()) +
  gsi::Methods(_create_f_text_c0 ()) +
  gsi::Methods(_create_f_toggle_0 ()) +
  gsi::Methods(_create_f_toolTip_c0 ()) +
  gsi::Methods(_create_f_trigger_0 ()) +
  gsi::Methods(_create_f_whatsThis_c0 ()) +
  qt_gsi::qt_signal<QAction, QAction_EventAdaptor> ("changed", &QAction_EventAdaptor::changed_e_0, "@brief Signal declaration for QAction::changed()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAction, QAction_EventAdaptor, QObject *> ("destroyed", &QAction_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QAction::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAction, QAction_EventAdaptor> ("hovered", &QAction_EventAdaptor::hovered_e_0, "@brief Signal declaration for QAction::hovered()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAction, QAction_EventAdaptor, bool> ("toggled", &QAction_EventAdaptor::toggled_e_864, gsi::arg("arg1"), "@brief Signal declaration for QAction::toggled(bool)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAction, QAction_EventAdaptor, bool> ("triggered", &QAction_EventAdaptor::triggered_e_864, gsi::arg("checked"), "@brief Signal declaration for QAction::triggered(bool checked)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QAction");
}


class QAction_Adaptor : public QAction, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAction_Adaptor();

  //  [adaptor ctor] QAction::QAction(QObject *parent)
  QAction_Adaptor(QObject *parent) : QAction(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QAction::QAction(const QString &text, QObject *parent)
  QAction_Adaptor(const QString &text, QObject *parent) : QAction(text, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QAction::QAction(const QIcon &icon, const QString &text, QObject *parent)
  QAction_Adaptor(const QIcon &icon, const QString &text, QObject *parent) : QAction(icon, text, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QAction::receivers(const char *signal)
  int fp_QAction_receivers_c1731 (const char *signal) const {
    return QAction::receivers(signal);
  }

  //  QObject *QAction::sender()
  QObject * fp_QAction_sender_c0 () const {
    return QAction::sender();
  }

  //  [adaptor impl] bool QAction::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QAction::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QAction_Adaptor, bool, QObject *, QEvent *>(&QAction_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QAction::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QAction::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QAction::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QAction_Adaptor, QChildEvent *>(&QAction_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QAction::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QAction::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QAction::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QAction_Adaptor, QEvent *>(&QAction_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QAction::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QAction::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QAction::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QAction_Adaptor, const char *>(&QAction_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QAction::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QAction::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QAction::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QAction_Adaptor, bool, QEvent *>(&QAction_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QAction::event(arg1);
    }
  }

  //  [adaptor impl] void QAction::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QAction::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QAction_Adaptor, QTimerEvent *>(&QAction_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QAction::timerEvent(arg1);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QAction_Adaptor::~QAction_Adaptor() { }

//  Constructor QAction::QAction(QObject *parent) (adaptor class)

static void _init_ctor_QAction_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QAction_Adaptor *> ();
}

static void _call_ctor_QAction_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  ret.write<QAction_Adaptor *> (new QAction_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QAction_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAction::QAction(QObject *parent)\nThis method creates an object of class QAction.", &_init_ctor_QAction_Adaptor_1302, &_call_ctor_QAction_Adaptor_1302);
}

//  Constructor QAction::QAction(const QString &text, QObject *parent) (adaptor class)

static void _init_ctor_QAction_Adaptor_3219 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QAction_Adaptor *> ();
}

static void _call_ctor_QAction_Adaptor_3219 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  QObject *arg2 = args.read<QObject * > ();
  ret.write<QAction_Adaptor *> (new QAction_Adaptor (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QAction_Adaptor_3219 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAction::QAction(const QString &text, QObject *parent)\nThis method creates an object of class QAction.", &_init_ctor_QAction_Adaptor_3219, &_call_ctor_QAction_Adaptor_3219);
}

//  Constructor QAction::QAction(const QIcon &icon, const QString &text, QObject *parent) (adaptor class)

static void _init_ctor_QAction_Adaptor_4898 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<QObject * > (argspec_2);
  decl->set_return_new<QAction_Adaptor *> ();
}

static void _call_ctor_QAction_Adaptor_4898 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QIcon &arg1 = args.read<const QIcon & > ();
  const QString &arg2 = args.read<const QString & > ();
  QObject *arg3 = args.read<QObject * > ();
  ret.write<QAction_Adaptor *> (new QAction_Adaptor (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QAction_Adaptor_4898 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAction::QAction(const QIcon &icon, const QString &text, QObject *parent)\nThis method creates an object of class QAction.", &_init_ctor_QAction_Adaptor_4898, &_call_ctor_QAction_Adaptor_4898);
}

// int QAction::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QAction_Adaptor *)cls)->fp_QAction_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QAction::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QAction::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QAction_Adaptor *)cls)->fp_QAction_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QAction::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// bool QAction::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QAction_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QAction_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QAction::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QAction::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QAction_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAction_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QAction::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QAction::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QAction_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAction_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QAction::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QAction::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QAction_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QAction_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QAction::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// bool QAction::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QAction_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAction_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QAction::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// void QAction::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QAction_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QAction_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QAction::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QAction> decl_QAction;

gsi::Class<QAction_Adaptor> decl_QAction_Adaptor (decl_QAction, "QAction",
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QAction_Adaptor_1302 ()) +
  gsi::Methods(_create_ctor_QAction_Adaptor_3219 ()) +
  gsi::Methods(_create_ctor_QAction_Adaptor_4898 ()),
  "@qt\n@brief Binding of QAction");

}


//  Implementation of the enum wrapper class for QAction::ActionEvent
namespace qt_gsi
{

static QAction_ActionEvent_Enum *c_1_QAction_ActionEvent_Enum () { return new QAction_ActionEvent_Enum (QAction::Trigger); }
static QAction_ActionEvent_Enum *c_2_QAction_ActionEvent_Enum () { return new QAction_ActionEvent_Enum (QAction::Hover); }

static gsi::Methods mkdefs_QAction_ActionEvent () {
  return
    gsi::constant ("Trigger", &qt_gsi::c_1_QAction_ActionEvent_Enum, "@brief Enum constant QAction::Trigger") +
    gsi::constant ("Hover", &qt_gsi::c_2_QAction_ActionEvent_Enum, "@brief Enum constant QAction::Hover");
}

static std::string to_s_QAction_ActionEvent_Enum (const QAction_ActionEvent_Enum *e)
{
  if (e->value () == QAction::Trigger) { return tl::sprintf ("Trigger (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAction::Hover) { return tl::sprintf ("Hover (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QAction_ActionEvent_Enum (const QAction_ActionEvent_Enum *e)
{
  return (unsigned int) e->value ();
}

static QAction_ActionEvent_Enum *from_i_QAction_ActionEvent_Enum (unsigned int i)
{
  return new QAction_ActionEvent_Enum ((QAction::ActionEvent) i);
}

static bool equalQAction_ActionEvent_Enum (const QAction_ActionEvent_Enum *e, QAction_ActionEvent_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QAction_ActionEvent_Enum (const QAction_ActionEvent_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QAction_ActionEvent_Enums oropQAction_ActionEvent_Enums (const QAction_ActionEvent_Enums *e, const QAction_ActionEvent_Enums &d)
{
  return e->flags () | d.flags ();
}

static QAction_ActionEvent_Enums andopQAction_ActionEvent_Enums (const QAction_ActionEvent_Enums *e, const QAction_ActionEvent_Enums &d)
{
  return e->flags () & d.flags ();
}

static QAction_ActionEvent_Enums xoropQAction_ActionEvent_Enums (const QAction_ActionEvent_Enums *e, const QAction_ActionEvent_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QAction_ActionEvent_Enums (const QAction_ActionEvent_Enums *e)
{
  std::string l;
  if (e->testFlag (QAction::Trigger)) { if (!l.empty ()) l += "|"; l += "Trigger"; }
  if (e->testFlag (QAction::Hover)) { if (!l.empty ()) l += "|"; l += "Hover"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QAction_ActionEvent_Enums (const QAction_ActionEvent_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QAction_ActionEvent_Enums (const QAction_ActionEvent_Enums *e, const QAction_ActionEvent_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QAction_ActionEvent_Enums> decl_QAction_ActionEvent_Enums ("QAction_QFlags_ActionEvent",
  gsi::method_ext ("|", &qt_gsi::oropQAction_ActionEvent_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQAction_ActionEvent_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQAction_ActionEvent_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAction_ActionEvent_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAction_ActionEvent_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QAction_ActionEvent_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QAction::ActionEvent> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QAction_ActionEvent_Enum> decl_QAction_ActionEvent_Enum (decl_QAction_ActionEvent_Enums, "QAction_ActionEvent",
  qt_gsi::mkdefs_QAction_ActionEvent () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAction_ActionEvent_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAction_ActionEvent_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQAction_ActionEvent_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QAction_ActionEvent_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QAction_ActionEvent_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QAction::ActionEvent enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QAction> inject_QAction_ActionEvent_Enum_in_parent (qt_gsi::mkdefs_QAction_ActionEvent ());
static gsi::ClassExt<QAction> decl_QAction_ActionEvent_Enum_as_child (decl_QAction_ActionEvent_Enum, "ActionEvent");

}


//  Implementation of the enum wrapper class for QAction::MenuRole
namespace qt_gsi
{

static QAction_MenuRole_Enum *c_1_QAction_MenuRole_Enum () { return new QAction_MenuRole_Enum (QAction::NoRole); }
static QAction_MenuRole_Enum *c_2_QAction_MenuRole_Enum () { return new QAction_MenuRole_Enum (QAction::TextHeuristicRole); }
static QAction_MenuRole_Enum *c_3_QAction_MenuRole_Enum () { return new QAction_MenuRole_Enum (QAction::ApplicationSpecificRole); }
static QAction_MenuRole_Enum *c_4_QAction_MenuRole_Enum () { return new QAction_MenuRole_Enum (QAction::AboutQtRole); }
static QAction_MenuRole_Enum *c_5_QAction_MenuRole_Enum () { return new QAction_MenuRole_Enum (QAction::AboutRole); }
static QAction_MenuRole_Enum *c_6_QAction_MenuRole_Enum () { return new QAction_MenuRole_Enum (QAction::PreferencesRole); }
static QAction_MenuRole_Enum *c_7_QAction_MenuRole_Enum () { return new QAction_MenuRole_Enum (QAction::QuitRole); }

static gsi::Methods mkdefs_QAction_MenuRole () {
  return
    gsi::constant ("NoRole", &qt_gsi::c_1_QAction_MenuRole_Enum, "@brief Enum constant QAction::NoRole") +
    gsi::constant ("TextHeuristicRole", &qt_gsi::c_2_QAction_MenuRole_Enum, "@brief Enum constant QAction::TextHeuristicRole") +
    gsi::constant ("ApplicationSpecificRole", &qt_gsi::c_3_QAction_MenuRole_Enum, "@brief Enum constant QAction::ApplicationSpecificRole") +
    gsi::constant ("AboutQtRole", &qt_gsi::c_4_QAction_MenuRole_Enum, "@brief Enum constant QAction::AboutQtRole") +
    gsi::constant ("AboutRole", &qt_gsi::c_5_QAction_MenuRole_Enum, "@brief Enum constant QAction::AboutRole") +
    gsi::constant ("PreferencesRole", &qt_gsi::c_6_QAction_MenuRole_Enum, "@brief Enum constant QAction::PreferencesRole") +
    gsi::constant ("QuitRole", &qt_gsi::c_7_QAction_MenuRole_Enum, "@brief Enum constant QAction::QuitRole");
}

static std::string to_s_QAction_MenuRole_Enum (const QAction_MenuRole_Enum *e)
{
  if (e->value () == QAction::NoRole) { return tl::sprintf ("NoRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAction::TextHeuristicRole) { return tl::sprintf ("TextHeuristicRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAction::ApplicationSpecificRole) { return tl::sprintf ("ApplicationSpecificRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAction::AboutQtRole) { return tl::sprintf ("AboutQtRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAction::AboutRole) { return tl::sprintf ("AboutRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAction::PreferencesRole) { return tl::sprintf ("PreferencesRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAction::QuitRole) { return tl::sprintf ("QuitRole (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QAction_MenuRole_Enum (const QAction_MenuRole_Enum *e)
{
  return (unsigned int) e->value ();
}

static QAction_MenuRole_Enum *from_i_QAction_MenuRole_Enum (unsigned int i)
{
  return new QAction_MenuRole_Enum ((QAction::MenuRole) i);
}

static bool equalQAction_MenuRole_Enum (const QAction_MenuRole_Enum *e, QAction_MenuRole_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QAction_MenuRole_Enum (const QAction_MenuRole_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QAction_MenuRole_Enums oropQAction_MenuRole_Enums (const QAction_MenuRole_Enums *e, const QAction_MenuRole_Enums &d)
{
  return e->flags () | d.flags ();
}

static QAction_MenuRole_Enums andopQAction_MenuRole_Enums (const QAction_MenuRole_Enums *e, const QAction_MenuRole_Enums &d)
{
  return e->flags () & d.flags ();
}

static QAction_MenuRole_Enums xoropQAction_MenuRole_Enums (const QAction_MenuRole_Enums *e, const QAction_MenuRole_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QAction_MenuRole_Enums (const QAction_MenuRole_Enums *e)
{
  std::string l;
  if (e->testFlag (QAction::NoRole)) { if (!l.empty ()) l += "|"; l += "NoRole"; }
  if (e->testFlag (QAction::TextHeuristicRole)) { if (!l.empty ()) l += "|"; l += "TextHeuristicRole"; }
  if (e->testFlag (QAction::ApplicationSpecificRole)) { if (!l.empty ()) l += "|"; l += "ApplicationSpecificRole"; }
  if (e->testFlag (QAction::AboutQtRole)) { if (!l.empty ()) l += "|"; l += "AboutQtRole"; }
  if (e->testFlag (QAction::AboutRole)) { if (!l.empty ()) l += "|"; l += "AboutRole"; }
  if (e->testFlag (QAction::PreferencesRole)) { if (!l.empty ()) l += "|"; l += "PreferencesRole"; }
  if (e->testFlag (QAction::QuitRole)) { if (!l.empty ()) l += "|"; l += "QuitRole"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QAction_MenuRole_Enums (const QAction_MenuRole_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QAction_MenuRole_Enums (const QAction_MenuRole_Enums *e, const QAction_MenuRole_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QAction_MenuRole_Enums> decl_QAction_MenuRole_Enums ("QAction_QFlags_MenuRole",
  gsi::method_ext ("|", &qt_gsi::oropQAction_MenuRole_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQAction_MenuRole_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQAction_MenuRole_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAction_MenuRole_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAction_MenuRole_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QAction_MenuRole_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QAction::MenuRole> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QAction_MenuRole_Enum> decl_QAction_MenuRole_Enum (decl_QAction_MenuRole_Enums, "QAction_MenuRole",
  qt_gsi::mkdefs_QAction_MenuRole () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAction_MenuRole_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAction_MenuRole_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQAction_MenuRole_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QAction_MenuRole_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QAction_MenuRole_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QAction::MenuRole enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QAction> inject_QAction_MenuRole_Enum_in_parent (qt_gsi::mkdefs_QAction_MenuRole ());
static gsi::ClassExt<QAction> decl_QAction_MenuRole_Enum_as_child (decl_QAction_MenuRole_Enum, "MenuRole");

}


//  Implementation of the enum wrapper class for QAction::Priority
namespace qt_gsi
{

static QAction_Priority_Enum *c_1_QAction_Priority_Enum () { return new QAction_Priority_Enum (QAction::LowPriority); }
static QAction_Priority_Enum *c_2_QAction_Priority_Enum () { return new QAction_Priority_Enum (QAction::NormalPriority); }
static QAction_Priority_Enum *c_3_QAction_Priority_Enum () { return new QAction_Priority_Enum (QAction::HighPriority); }

static gsi::Methods mkdefs_QAction_Priority () {
  return
    gsi::constant ("LowPriority", &qt_gsi::c_1_QAction_Priority_Enum, "@brief Enum constant QAction::LowPriority") +
    gsi::constant ("NormalPriority", &qt_gsi::c_2_QAction_Priority_Enum, "@brief Enum constant QAction::NormalPriority") +
    gsi::constant ("HighPriority", &qt_gsi::c_3_QAction_Priority_Enum, "@brief Enum constant QAction::HighPriority");
}

static std::string to_s_QAction_Priority_Enum (const QAction_Priority_Enum *e)
{
  if (e->value () == QAction::LowPriority) { return tl::sprintf ("LowPriority (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAction::NormalPriority) { return tl::sprintf ("NormalPriority (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAction::HighPriority) { return tl::sprintf ("HighPriority (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QAction_Priority_Enum (const QAction_Priority_Enum *e)
{
  return (unsigned int) e->value ();
}

static QAction_Priority_Enum *from_i_QAction_Priority_Enum (unsigned int i)
{
  return new QAction_Priority_Enum ((QAction::Priority) i);
}

static bool equalQAction_Priority_Enum (const QAction_Priority_Enum *e, QAction_Priority_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QAction_Priority_Enum (const QAction_Priority_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QAction_Priority_Enums oropQAction_Priority_Enums (const QAction_Priority_Enums *e, const QAction_Priority_Enums &d)
{
  return e->flags () | d.flags ();
}

static QAction_Priority_Enums andopQAction_Priority_Enums (const QAction_Priority_Enums *e, const QAction_Priority_Enums &d)
{
  return e->flags () & d.flags ();
}

static QAction_Priority_Enums xoropQAction_Priority_Enums (const QAction_Priority_Enums *e, const QAction_Priority_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QAction_Priority_Enums (const QAction_Priority_Enums *e)
{
  std::string l;
  if (e->testFlag (QAction::LowPriority)) { if (!l.empty ()) l += "|"; l += "LowPriority"; }
  if (e->testFlag (QAction::NormalPriority)) { if (!l.empty ()) l += "|"; l += "NormalPriority"; }
  if (e->testFlag (QAction::HighPriority)) { if (!l.empty ()) l += "|"; l += "HighPriority"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QAction_Priority_Enums (const QAction_Priority_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QAction_Priority_Enums (const QAction_Priority_Enums *e, const QAction_Priority_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QAction_Priority_Enums> decl_QAction_Priority_Enums ("QAction_QFlags_Priority",
  gsi::method_ext ("|", &qt_gsi::oropQAction_Priority_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQAction_Priority_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQAction_Priority_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAction_Priority_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAction_Priority_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QAction_Priority_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QAction::Priority> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QAction_Priority_Enum> decl_QAction_Priority_Enum (decl_QAction_Priority_Enums, "QAction_Priority",
  qt_gsi::mkdefs_QAction_Priority () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAction_Priority_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAction_Priority_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQAction_Priority_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QAction_Priority_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QAction_Priority_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QAction::Priority enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QAction> inject_QAction_Priority_Enum_in_parent (qt_gsi::mkdefs_QAction_Priority ());
static gsi::ClassExt<QAction> decl_QAction_Priority_Enum_as_child (decl_QAction_Priority_Enum, "Priority");

}


//  Implementation of the enum wrapper class for QAction::SoftKeyRole
namespace qt_gsi
{

static QAction_SoftKeyRole_Enum *c_1_QAction_SoftKeyRole_Enum () { return new QAction_SoftKeyRole_Enum (QAction::NoSoftKey); }
static QAction_SoftKeyRole_Enum *c_2_QAction_SoftKeyRole_Enum () { return new QAction_SoftKeyRole_Enum (QAction::PositiveSoftKey); }
static QAction_SoftKeyRole_Enum *c_3_QAction_SoftKeyRole_Enum () { return new QAction_SoftKeyRole_Enum (QAction::NegativeSoftKey); }
static QAction_SoftKeyRole_Enum *c_4_QAction_SoftKeyRole_Enum () { return new QAction_SoftKeyRole_Enum (QAction::SelectSoftKey); }

static gsi::Methods mkdefs_QAction_SoftKeyRole () {
  return
    gsi::constant ("NoSoftKey", &qt_gsi::c_1_QAction_SoftKeyRole_Enum, "@brief Enum constant QAction::NoSoftKey") +
    gsi::constant ("PositiveSoftKey", &qt_gsi::c_2_QAction_SoftKeyRole_Enum, "@brief Enum constant QAction::PositiveSoftKey") +
    gsi::constant ("NegativeSoftKey", &qt_gsi::c_3_QAction_SoftKeyRole_Enum, "@brief Enum constant QAction::NegativeSoftKey") +
    gsi::constant ("SelectSoftKey", &qt_gsi::c_4_QAction_SoftKeyRole_Enum, "@brief Enum constant QAction::SelectSoftKey");
}

static std::string to_s_QAction_SoftKeyRole_Enum (const QAction_SoftKeyRole_Enum *e)
{
  if (e->value () == QAction::NoSoftKey) { return tl::sprintf ("NoSoftKey (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAction::PositiveSoftKey) { return tl::sprintf ("PositiveSoftKey (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAction::NegativeSoftKey) { return tl::sprintf ("NegativeSoftKey (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAction::SelectSoftKey) { return tl::sprintf ("SelectSoftKey (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QAction_SoftKeyRole_Enum (const QAction_SoftKeyRole_Enum *e)
{
  return (unsigned int) e->value ();
}

static QAction_SoftKeyRole_Enum *from_i_QAction_SoftKeyRole_Enum (unsigned int i)
{
  return new QAction_SoftKeyRole_Enum ((QAction::SoftKeyRole) i);
}

static bool equalQAction_SoftKeyRole_Enum (const QAction_SoftKeyRole_Enum *e, QAction_SoftKeyRole_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QAction_SoftKeyRole_Enum (const QAction_SoftKeyRole_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QAction_SoftKeyRole_Enums oropQAction_SoftKeyRole_Enums (const QAction_SoftKeyRole_Enums *e, const QAction_SoftKeyRole_Enums &d)
{
  return e->flags () | d.flags ();
}

static QAction_SoftKeyRole_Enums andopQAction_SoftKeyRole_Enums (const QAction_SoftKeyRole_Enums *e, const QAction_SoftKeyRole_Enums &d)
{
  return e->flags () & d.flags ();
}

static QAction_SoftKeyRole_Enums xoropQAction_SoftKeyRole_Enums (const QAction_SoftKeyRole_Enums *e, const QAction_SoftKeyRole_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QAction_SoftKeyRole_Enums (const QAction_SoftKeyRole_Enums *e)
{
  std::string l;
  if (e->testFlag (QAction::NoSoftKey)) { if (!l.empty ()) l += "|"; l += "NoSoftKey"; }
  if (e->testFlag (QAction::PositiveSoftKey)) { if (!l.empty ()) l += "|"; l += "PositiveSoftKey"; }
  if (e->testFlag (QAction::NegativeSoftKey)) { if (!l.empty ()) l += "|"; l += "NegativeSoftKey"; }
  if (e->testFlag (QAction::SelectSoftKey)) { if (!l.empty ()) l += "|"; l += "SelectSoftKey"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QAction_SoftKeyRole_Enums (const QAction_SoftKeyRole_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QAction_SoftKeyRole_Enums (const QAction_SoftKeyRole_Enums *e, const QAction_SoftKeyRole_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QAction_SoftKeyRole_Enums> decl_QAction_SoftKeyRole_Enums ("QAction_QFlags_SoftKeyRole",
  gsi::method_ext ("|", &qt_gsi::oropQAction_SoftKeyRole_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQAction_SoftKeyRole_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQAction_SoftKeyRole_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAction_SoftKeyRole_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAction_SoftKeyRole_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QAction_SoftKeyRole_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QAction::SoftKeyRole> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QAction_SoftKeyRole_Enum> decl_QAction_SoftKeyRole_Enum (decl_QAction_SoftKeyRole_Enums, "QAction_SoftKeyRole",
  qt_gsi::mkdefs_QAction_SoftKeyRole () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAction_SoftKeyRole_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAction_SoftKeyRole_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQAction_SoftKeyRole_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QAction_SoftKeyRole_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QAction_SoftKeyRole_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QAction::SoftKeyRole enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QAction> inject_QAction_SoftKeyRole_Enum_in_parent (qt_gsi::mkdefs_QAction_SoftKeyRole ());
static gsi::ClassExt<QAction> decl_QAction_SoftKeyRole_Enum_as_child (decl_QAction_SoftKeyRole_Enum, "SoftKeyRole");

}

