
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAbstractItemView.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQAbstractItemView_EventAdaptor.h"
#include "gsiDeclQAbstractItemView_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAbstractItemView

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAbstractItemView::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// bool QAbstractItemView::alternatingRowColors()


static void _init_f_alternatingRowColors_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_alternatingRowColors_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QAbstractItemView *)cls)->alternatingRowColors ());
}

static qt_gsi::GenericMethod *_create_f_alternatingRowColors_c0 ()
{
  return new qt_gsi::GenericMethod (":alternatingRowColors", "@brief Method bool QAbstractItemView::alternatingRowColors()\n", true, &_init_f_alternatingRowColors_c0, &_call_f_alternatingRowColors_c0);
}

// int QAbstractItemView::autoScrollMargin()


static void _init_f_autoScrollMargin_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_autoScrollMargin_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QAbstractItemView *)cls)->autoScrollMargin ());
}

static qt_gsi::GenericMethod *_create_f_autoScrollMargin_c0 ()
{
  return new qt_gsi::GenericMethod (":autoScrollMargin", "@brief Method int QAbstractItemView::autoScrollMargin()\n", true, &_init_f_autoScrollMargin_c0, &_call_f_autoScrollMargin_c0);
}

// void QAbstractItemView::clearSelection()


static void _init_f_clearSelection_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearSelection_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemView *)cls)->clearSelection ();
}

static qt_gsi::GenericMethod *_create_f_clearSelection_0 ()
{
  return new qt_gsi::GenericMethod ("clearSelection", "@brief Method void QAbstractItemView::clearSelection()\n", false, &_init_f_clearSelection_0, &_call_f_clearSelection_0);
}

// void QAbstractItemView::closePersistentEditor(const QModelIndex &index)


static void _init_f_closePersistentEditor_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_closePersistentEditor_2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ((QAbstractItemView *)cls)->closePersistentEditor (arg1);
}

static qt_gsi::GenericMethod *_create_f_closePersistentEditor_2395 ()
{
  return new qt_gsi::GenericMethod ("closePersistentEditor", "@brief Method void QAbstractItemView::closePersistentEditor(const QModelIndex &index)\n", false, &_init_f_closePersistentEditor_2395, &_call_f_closePersistentEditor_2395);
}

// QModelIndex QAbstractItemView::currentIndex()


static void _init_f_currentIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QModelIndex > ();
}

static void _call_f_currentIndex_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QModelIndex > ((QModelIndex)((QAbstractItemView *)cls)->currentIndex ());
}

static qt_gsi::GenericMethod *_create_f_currentIndex_c0 ()
{
  return new qt_gsi::GenericMethod (":currentIndex", "@brief Method QModelIndex QAbstractItemView::currentIndex()\n", true, &_init_f_currentIndex_c0, &_call_f_currentIndex_c0);
}

// Qt::DropAction QAbstractItemView::defaultDropAction()


static void _init_f_defaultDropAction_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::DropAction>::target_type > ();
}

static void _call_f_defaultDropAction_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::DropAction>::target_type > ((qt_gsi::Converter<Qt::DropAction>::target_type)qt_gsi::CppToQtAdaptor<Qt::DropAction>(((QAbstractItemView *)cls)->defaultDropAction ()));
}

static qt_gsi::GenericMethod *_create_f_defaultDropAction_c0 ()
{
  return new qt_gsi::GenericMethod (":defaultDropAction", "@brief Method Qt::DropAction QAbstractItemView::defaultDropAction()\n", true, &_init_f_defaultDropAction_c0, &_call_f_defaultDropAction_c0);
}

// void QAbstractItemView::doItemsLayout()


static void _init_f_doItemsLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_doItemsLayout_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemView *)cls)->doItemsLayout ();
}

static qt_gsi::GenericMethod *_create_f_doItemsLayout_0 ()
{
  return new qt_gsi::GenericMethod ("doItemsLayout", "@brief Method void QAbstractItemView::doItemsLayout()\n", false, &_init_f_doItemsLayout_0, &_call_f_doItemsLayout_0);
}

// QAbstractItemView::DragDropMode QAbstractItemView::dragDropMode()


static void _init_f_dragDropMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAbstractItemView::DragDropMode>::target_type > ();
}

static void _call_f_dragDropMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QAbstractItemView::DragDropMode>::target_type > ((qt_gsi::Converter<QAbstractItemView::DragDropMode>::target_type)qt_gsi::CppToQtAdaptor<QAbstractItemView::DragDropMode>(((QAbstractItemView *)cls)->dragDropMode ()));
}

static qt_gsi::GenericMethod *_create_f_dragDropMode_c0 ()
{
  return new qt_gsi::GenericMethod (":dragDropMode", "@brief Method QAbstractItemView::DragDropMode QAbstractItemView::dragDropMode()\n", true, &_init_f_dragDropMode_c0, &_call_f_dragDropMode_c0);
}

// bool QAbstractItemView::dragDropOverwriteMode()


static void _init_f_dragDropOverwriteMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_dragDropOverwriteMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QAbstractItemView *)cls)->dragDropOverwriteMode ());
}

static qt_gsi::GenericMethod *_create_f_dragDropOverwriteMode_c0 ()
{
  return new qt_gsi::GenericMethod (":dragDropOverwriteMode", "@brief Method bool QAbstractItemView::dragDropOverwriteMode()\n", true, &_init_f_dragDropOverwriteMode_c0, &_call_f_dragDropOverwriteMode_c0);
}

// bool QAbstractItemView::dragEnabled()


static void _init_f_dragEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_dragEnabled_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QAbstractItemView *)cls)->dragEnabled ());
}

static qt_gsi::GenericMethod *_create_f_dragEnabled_c0 ()
{
  return new qt_gsi::GenericMethod (":dragEnabled", "@brief Method bool QAbstractItemView::dragEnabled()\n", true, &_init_f_dragEnabled_c0, &_call_f_dragEnabled_c0);
}

// void QAbstractItemView::edit(const QModelIndex &index)


static void _init_f_edit_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_edit_2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ((QAbstractItemView *)cls)->edit (arg1);
}

static qt_gsi::GenericMethod *_create_f_edit_2395 ()
{
  return new qt_gsi::GenericMethod ("edit", "@brief Method void QAbstractItemView::edit(const QModelIndex &index)\n", false, &_init_f_edit_2395, &_call_f_edit_2395);
}

// QFlags<QAbstractItemView::EditTrigger> QAbstractItemView::editTriggers()


static void _init_f_editTriggers_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QAbstractItemView::EditTrigger> >::target_type > ();
}

static void _call_f_editTriggers_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QAbstractItemView::EditTrigger> >::target_type > ((qt_gsi::Converter<QFlags<QAbstractItemView::EditTrigger> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QAbstractItemView::EditTrigger> >(((QAbstractItemView *)cls)->editTriggers ()));
}

static qt_gsi::GenericMethod *_create_f_editTriggers_c0 ()
{
  return new qt_gsi::GenericMethod (":editTriggers", "@brief Method QFlags<QAbstractItemView::EditTrigger> QAbstractItemView::editTriggers()\n", true, &_init_f_editTriggers_c0, &_call_f_editTriggers_c0);
}

// bool QAbstractItemView::hasAutoScroll()


static void _init_f_hasAutoScroll_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasAutoScroll_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QAbstractItemView *)cls)->hasAutoScroll ());
}

static qt_gsi::GenericMethod *_create_f_hasAutoScroll_c0 ()
{
  return new qt_gsi::GenericMethod ("hasAutoScroll|:autoScroll", "@brief Method bool QAbstractItemView::hasAutoScroll()\n", true, &_init_f_hasAutoScroll_c0, &_call_f_hasAutoScroll_c0);
}

// QAbstractItemView::ScrollMode QAbstractItemView::horizontalScrollMode()


static void _init_f_horizontalScrollMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAbstractItemView::ScrollMode>::target_type > ();
}

static void _call_f_horizontalScrollMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QAbstractItemView::ScrollMode>::target_type > ((qt_gsi::Converter<QAbstractItemView::ScrollMode>::target_type)qt_gsi::CppToQtAdaptor<QAbstractItemView::ScrollMode>(((QAbstractItemView *)cls)->horizontalScrollMode ()));
}

static qt_gsi::GenericMethod *_create_f_horizontalScrollMode_c0 ()
{
  return new qt_gsi::GenericMethod (":horizontalScrollMode", "@brief Method QAbstractItemView::ScrollMode QAbstractItemView::horizontalScrollMode()\n", true, &_init_f_horizontalScrollMode_c0, &_call_f_horizontalScrollMode_c0);
}

// QSize QAbstractItemView::iconSize()


static void _init_f_iconSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_iconSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QAbstractItemView *)cls)->iconSize ());
}

static qt_gsi::GenericMethod *_create_f_iconSize_c0 ()
{
  return new qt_gsi::GenericMethod (":iconSize", "@brief Method QSize QAbstractItemView::iconSize()\n", true, &_init_f_iconSize_c0, &_call_f_iconSize_c0);
}

// QModelIndex QAbstractItemView::indexAt(const QPoint &point)


static void _init_f_indexAt_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_indexAt_c1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QModelIndex > ((QModelIndex)((QAbstractItemView *)cls)->indexAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_indexAt_c1916 ()
{
  return new qt_gsi::GenericMethod ("indexAt", "@brief Method QModelIndex QAbstractItemView::indexAt(const QPoint &point)\n", true, &_init_f_indexAt_c1916, &_call_f_indexAt_c1916);
}

// QWidget *QAbstractItemView::indexWidget(const QModelIndex &index)


static void _init_f_indexWidget_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QWidget * > ();
}

static void _call_f_indexWidget_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QWidget * > ((QWidget *)((QAbstractItemView *)cls)->indexWidget (arg1));
}

static qt_gsi::GenericMethod *_create_f_indexWidget_c2395 ()
{
  return new qt_gsi::GenericMethod ("indexWidget", "@brief Method QWidget *QAbstractItemView::indexWidget(const QModelIndex &index)\n", true, &_init_f_indexWidget_c2395, &_call_f_indexWidget_c2395);
}

// QVariant QAbstractItemView::inputMethodQuery(Qt::InputMethodQuery query)


static void _init_f_inputMethodQuery_c2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_inputMethodQuery_c2420 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QAbstractItemView *)cls)->inputMethodQuery (qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_inputMethodQuery_c2420 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Method QVariant QAbstractItemView::inputMethodQuery(Qt::InputMethodQuery query)\nThis is a reimplementation of QWidget::inputMethodQuery", true, &_init_f_inputMethodQuery_c2420, &_call_f_inputMethodQuery_c2420);
}

// QAbstractItemDelegate *QAbstractItemView::itemDelegate()


static void _init_f_itemDelegate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractItemDelegate * > ();
}

static void _call_f_itemDelegate_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QAbstractItemDelegate * > ((QAbstractItemDelegate *)((QAbstractItemView *)cls)->itemDelegate ());
}

static qt_gsi::GenericMethod *_create_f_itemDelegate_c0 ()
{
  return new qt_gsi::GenericMethod (":itemDelegate", "@brief Method QAbstractItemDelegate *QAbstractItemView::itemDelegate()\n", true, &_init_f_itemDelegate_c0, &_call_f_itemDelegate_c0);
}

// QAbstractItemDelegate *QAbstractItemView::itemDelegate(const QModelIndex &index)


static void _init_f_itemDelegate_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QAbstractItemDelegate * > ();
}

static void _call_f_itemDelegate_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QAbstractItemDelegate * > ((QAbstractItemDelegate *)((QAbstractItemView *)cls)->itemDelegate (arg1));
}

static qt_gsi::GenericMethod *_create_f_itemDelegate_c2395 ()
{
  return new qt_gsi::GenericMethod ("itemDelegate", "@brief Method QAbstractItemDelegate *QAbstractItemView::itemDelegate(const QModelIndex &index)\n", true, &_init_f_itemDelegate_c2395, &_call_f_itemDelegate_c2395);
}

// QAbstractItemDelegate *QAbstractItemView::itemDelegateForColumn(int column)


static void _init_f_itemDelegateForColumn_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QAbstractItemDelegate * > ();
}

static void _call_f_itemDelegateForColumn_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QAbstractItemDelegate * > ((QAbstractItemDelegate *)((QAbstractItemView *)cls)->itemDelegateForColumn (arg1));
}

static qt_gsi::GenericMethod *_create_f_itemDelegateForColumn_c767 ()
{
  return new qt_gsi::GenericMethod ("itemDelegateForColumn", "@brief Method QAbstractItemDelegate *QAbstractItemView::itemDelegateForColumn(int column)\n", true, &_init_f_itemDelegateForColumn_c767, &_call_f_itemDelegateForColumn_c767);
}

// QAbstractItemDelegate *QAbstractItemView::itemDelegateForRow(int row)


static void _init_f_itemDelegateForRow_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QAbstractItemDelegate * > ();
}

static void _call_f_itemDelegateForRow_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QAbstractItemDelegate * > ((QAbstractItemDelegate *)((QAbstractItemView *)cls)->itemDelegateForRow (arg1));
}

static qt_gsi::GenericMethod *_create_f_itemDelegateForRow_c767 ()
{
  return new qt_gsi::GenericMethod ("itemDelegateForRow", "@brief Method QAbstractItemDelegate *QAbstractItemView::itemDelegateForRow(int row)\n", true, &_init_f_itemDelegateForRow_c767, &_call_f_itemDelegateForRow_c767);
}

// void QAbstractItemView::keyboardSearch(const QString &search)


static void _init_f_keyboardSearch_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("search");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_keyboardSearch_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QAbstractItemView *)cls)->keyboardSearch (arg1);
}

static qt_gsi::GenericMethod *_create_f_keyboardSearch_2025 ()
{
  return new qt_gsi::GenericMethod ("keyboardSearch", "@brief Method void QAbstractItemView::keyboardSearch(const QString &search)\n", false, &_init_f_keyboardSearch_2025, &_call_f_keyboardSearch_2025);
}

// QAbstractItemModel *QAbstractItemView::model()


static void _init_f_model_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractItemModel * > ();
}

static void _call_f_model_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QAbstractItemModel * > ((QAbstractItemModel *)((QAbstractItemView *)cls)->model ());
}

static qt_gsi::GenericMethod *_create_f_model_c0 ()
{
  return new qt_gsi::GenericMethod (":model", "@brief Method QAbstractItemModel *QAbstractItemView::model()\n", true, &_init_f_model_c0, &_call_f_model_c0);
}

// void QAbstractItemView::openPersistentEditor(const QModelIndex &index)


static void _init_f_openPersistentEditor_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_openPersistentEditor_2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ((QAbstractItemView *)cls)->openPersistentEditor (arg1);
}

static qt_gsi::GenericMethod *_create_f_openPersistentEditor_2395 ()
{
  return new qt_gsi::GenericMethod ("openPersistentEditor", "@brief Method void QAbstractItemView::openPersistentEditor(const QModelIndex &index)\n", false, &_init_f_openPersistentEditor_2395, &_call_f_openPersistentEditor_2395);
}

// void QAbstractItemView::reset()


static void _init_f_reset_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_reset_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemView *)cls)->reset ();
}

static qt_gsi::GenericMethod *_create_f_reset_0 ()
{
  return new qt_gsi::GenericMethod ("reset", "@brief Method void QAbstractItemView::reset()\n", false, &_init_f_reset_0, &_call_f_reset_0);
}

// QModelIndex QAbstractItemView::rootIndex()


static void _init_f_rootIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QModelIndex > ();
}

static void _call_f_rootIndex_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QModelIndex > ((QModelIndex)((QAbstractItemView *)cls)->rootIndex ());
}

static qt_gsi::GenericMethod *_create_f_rootIndex_c0 ()
{
  return new qt_gsi::GenericMethod (":rootIndex", "@brief Method QModelIndex QAbstractItemView::rootIndex()\n", true, &_init_f_rootIndex_c0, &_call_f_rootIndex_c0);
}

// void QAbstractItemView::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)


static void _init_f_scrollTo_5576 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint", true, "QAbstractItemView::EnsureVisible");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_scrollTo_5576 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > () : (const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type &)(qt_gsi::CppToQtReadAdaptor<QAbstractItemView::ScrollHint>(heap, QAbstractItemView::EnsureVisible));
  ((QAbstractItemView *)cls)->scrollTo (arg1, qt_gsi::QtToCppAdaptor<QAbstractItemView::ScrollHint>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_scrollTo_5576 ()
{
  return new qt_gsi::GenericMethod ("scrollTo", "@brief Method void QAbstractItemView::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)\n", false, &_init_f_scrollTo_5576, &_call_f_scrollTo_5576);
}

// void QAbstractItemView::scrollToBottom()


static void _init_f_scrollToBottom_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_scrollToBottom_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemView *)cls)->scrollToBottom ();
}

static qt_gsi::GenericMethod *_create_f_scrollToBottom_0 ()
{
  return new qt_gsi::GenericMethod ("scrollToBottom", "@brief Method void QAbstractItemView::scrollToBottom()\n", false, &_init_f_scrollToBottom_0, &_call_f_scrollToBottom_0);
}

// void QAbstractItemView::scrollToTop()


static void _init_f_scrollToTop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_scrollToTop_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemView *)cls)->scrollToTop ();
}

static qt_gsi::GenericMethod *_create_f_scrollToTop_0 ()
{
  return new qt_gsi::GenericMethod ("scrollToTop", "@brief Method void QAbstractItemView::scrollToTop()\n", false, &_init_f_scrollToTop_0, &_call_f_scrollToTop_0);
}

// void QAbstractItemView::selectAll()


static void _init_f_selectAll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_selectAll_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemView *)cls)->selectAll ();
}

static qt_gsi::GenericMethod *_create_f_selectAll_0 ()
{
  return new qt_gsi::GenericMethod ("selectAll", "@brief Method void QAbstractItemView::selectAll()\n", false, &_init_f_selectAll_0, &_call_f_selectAll_0);
}

// QAbstractItemView::SelectionBehavior QAbstractItemView::selectionBehavior()


static void _init_f_selectionBehavior_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAbstractItemView::SelectionBehavior>::target_type > ();
}

static void _call_f_selectionBehavior_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QAbstractItemView::SelectionBehavior>::target_type > ((qt_gsi::Converter<QAbstractItemView::SelectionBehavior>::target_type)qt_gsi::CppToQtAdaptor<QAbstractItemView::SelectionBehavior>(((QAbstractItemView *)cls)->selectionBehavior ()));
}

static qt_gsi::GenericMethod *_create_f_selectionBehavior_c0 ()
{
  return new qt_gsi::GenericMethod (":selectionBehavior", "@brief Method QAbstractItemView::SelectionBehavior QAbstractItemView::selectionBehavior()\n", true, &_init_f_selectionBehavior_c0, &_call_f_selectionBehavior_c0);
}

// QAbstractItemView::SelectionMode QAbstractItemView::selectionMode()


static void _init_f_selectionMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAbstractItemView::SelectionMode>::target_type > ();
}

static void _call_f_selectionMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QAbstractItemView::SelectionMode>::target_type > ((qt_gsi::Converter<QAbstractItemView::SelectionMode>::target_type)qt_gsi::CppToQtAdaptor<QAbstractItemView::SelectionMode>(((QAbstractItemView *)cls)->selectionMode ()));
}

static qt_gsi::GenericMethod *_create_f_selectionMode_c0 ()
{
  return new qt_gsi::GenericMethod (":selectionMode", "@brief Method QAbstractItemView::SelectionMode QAbstractItemView::selectionMode()\n", true, &_init_f_selectionMode_c0, &_call_f_selectionMode_c0);
}

// QItemSelectionModel *QAbstractItemView::selectionModel()


static void _init_f_selectionModel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QItemSelectionModel * > ();
}

static void _call_f_selectionModel_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QItemSelectionModel * > ((QItemSelectionModel *)((QAbstractItemView *)cls)->selectionModel ());
}

static qt_gsi::GenericMethod *_create_f_selectionModel_c0 ()
{
  return new qt_gsi::GenericMethod (":selectionModel", "@brief Method QItemSelectionModel *QAbstractItemView::selectionModel()\n", true, &_init_f_selectionModel_c0, &_call_f_selectionModel_c0);
}

// void QAbstractItemView::setAlternatingRowColors(bool enable)


static void _init_f_setAlternatingRowColors_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAlternatingRowColors_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QAbstractItemView *)cls)->setAlternatingRowColors (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAlternatingRowColors_864 ()
{
  return new qt_gsi::GenericMethod ("setAlternatingRowColors|alternatingRowColors=", "@brief Method void QAbstractItemView::setAlternatingRowColors(bool enable)\n", false, &_init_f_setAlternatingRowColors_864, &_call_f_setAlternatingRowColors_864);
}

// void QAbstractItemView::setAutoScroll(bool enable)


static void _init_f_setAutoScroll_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAutoScroll_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QAbstractItemView *)cls)->setAutoScroll (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAutoScroll_864 ()
{
  return new qt_gsi::GenericMethod ("setAutoScroll|autoScroll=", "@brief Method void QAbstractItemView::setAutoScroll(bool enable)\n", false, &_init_f_setAutoScroll_864, &_call_f_setAutoScroll_864);
}

// void QAbstractItemView::setAutoScrollMargin(int margin)


static void _init_f_setAutoScrollMargin_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margin");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAutoScrollMargin_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QAbstractItemView *)cls)->setAutoScrollMargin (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAutoScrollMargin_767 ()
{
  return new qt_gsi::GenericMethod ("setAutoScrollMargin|autoScrollMargin=", "@brief Method void QAbstractItemView::setAutoScrollMargin(int margin)\n", false, &_init_f_setAutoScrollMargin_767, &_call_f_setAutoScrollMargin_767);
}

// void QAbstractItemView::setCurrentIndex(const QModelIndex &index)


static void _init_f_setCurrentIndex_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentIndex_2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ((QAbstractItemView *)cls)->setCurrentIndex (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCurrentIndex_2395 ()
{
  return new qt_gsi::GenericMethod ("setCurrentIndex|currentIndex=", "@brief Method void QAbstractItemView::setCurrentIndex(const QModelIndex &index)\n", false, &_init_f_setCurrentIndex_2395, &_call_f_setCurrentIndex_2395);
}

// void QAbstractItemView::setDefaultDropAction(Qt::DropAction dropAction)


static void _init_f_setDefaultDropAction_1760 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dropAction");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultDropAction_1760 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > ();
  ((QAbstractItemView *)cls)->setDefaultDropAction (qt_gsi::QtToCppAdaptor<Qt::DropAction>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setDefaultDropAction_1760 ()
{
  return new qt_gsi::GenericMethod ("setDefaultDropAction|defaultDropAction=", "@brief Method void QAbstractItemView::setDefaultDropAction(Qt::DropAction dropAction)\n", false, &_init_f_setDefaultDropAction_1760, &_call_f_setDefaultDropAction_1760);
}

// void QAbstractItemView::setDragDropMode(QAbstractItemView::DragDropMode behavior)


static void _init_f_setDragDropMode_3439 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("behavior");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::DragDropMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDragDropMode_3439 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QAbstractItemView::DragDropMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractItemView::DragDropMode>::target_type & > ();
  ((QAbstractItemView *)cls)->setDragDropMode (qt_gsi::QtToCppAdaptor<QAbstractItemView::DragDropMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setDragDropMode_3439 ()
{
  return new qt_gsi::GenericMethod ("setDragDropMode|dragDropMode=", "@brief Method void QAbstractItemView::setDragDropMode(QAbstractItemView::DragDropMode behavior)\n", false, &_init_f_setDragDropMode_3439, &_call_f_setDragDropMode_3439);
}

// void QAbstractItemView::setDragDropOverwriteMode(bool overwrite)


static void _init_f_setDragDropOverwriteMode_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("overwrite");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDragDropOverwriteMode_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QAbstractItemView *)cls)->setDragDropOverwriteMode (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDragDropOverwriteMode_864 ()
{
  return new qt_gsi::GenericMethod ("setDragDropOverwriteMode|dragDropOverwriteMode=", "@brief Method void QAbstractItemView::setDragDropOverwriteMode(bool overwrite)\n", false, &_init_f_setDragDropOverwriteMode_864, &_call_f_setDragDropOverwriteMode_864);
}

// void QAbstractItemView::setDragEnabled(bool enable)


static void _init_f_setDragEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDragEnabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QAbstractItemView *)cls)->setDragEnabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDragEnabled_864 ()
{
  return new qt_gsi::GenericMethod ("setDragEnabled|dragEnabled=", "@brief Method void QAbstractItemView::setDragEnabled(bool enable)\n", false, &_init_f_setDragEnabled_864, &_call_f_setDragEnabled_864);
}

// void QAbstractItemView::setDropIndicatorShown(bool enable)


static void _init_f_setDropIndicatorShown_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDropIndicatorShown_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QAbstractItemView *)cls)->setDropIndicatorShown (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDropIndicatorShown_864 ()
{
  return new qt_gsi::GenericMethod ("setDropIndicatorShown", "@brief Method void QAbstractItemView::setDropIndicatorShown(bool enable)\n", false, &_init_f_setDropIndicatorShown_864, &_call_f_setDropIndicatorShown_864);
}

// void QAbstractItemView::setEditTriggers(QFlags<QAbstractItemView::EditTrigger> triggers)


static void _init_f_setEditTriggers_4073 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("triggers");
  decl->add_arg<const qt_gsi::Converter<QFlags<QAbstractItemView::EditTrigger> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEditTriggers_4073 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QAbstractItemView::EditTrigger> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QAbstractItemView::EditTrigger> >::target_type & > ();
  ((QAbstractItemView *)cls)->setEditTriggers (qt_gsi::QtToCppAdaptor<QFlags<QAbstractItemView::EditTrigger> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setEditTriggers_4073 ()
{
  return new qt_gsi::GenericMethod ("setEditTriggers|editTriggers=", "@brief Method void QAbstractItemView::setEditTriggers(QFlags<QAbstractItemView::EditTrigger> triggers)\n", false, &_init_f_setEditTriggers_4073, &_call_f_setEditTriggers_4073);
}

// void QAbstractItemView::setHorizontalScrollMode(QAbstractItemView::ScrollMode mode)


static void _init_f_setHorizontalScrollMode_3275 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::ScrollMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHorizontalScrollMode_3275 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QAbstractItemView::ScrollMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractItemView::ScrollMode>::target_type & > ();
  ((QAbstractItemView *)cls)->setHorizontalScrollMode (qt_gsi::QtToCppAdaptor<QAbstractItemView::ScrollMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setHorizontalScrollMode_3275 ()
{
  return new qt_gsi::GenericMethod ("setHorizontalScrollMode|horizontalScrollMode=", "@brief Method void QAbstractItemView::setHorizontalScrollMode(QAbstractItemView::ScrollMode mode)\n", false, &_init_f_setHorizontalScrollMode_3275, &_call_f_setHorizontalScrollMode_3275);
}

// void QAbstractItemView::setIconSize(const QSize &size)


static void _init_f_setIconSize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIconSize_1805 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  ((QAbstractItemView *)cls)->setIconSize (arg1);
}

static qt_gsi::GenericMethod *_create_f_setIconSize_1805 ()
{
  return new qt_gsi::GenericMethod ("setIconSize|iconSize=", "@brief Method void QAbstractItemView::setIconSize(const QSize &size)\n", false, &_init_f_setIconSize_1805, &_call_f_setIconSize_1805);
}

// void QAbstractItemView::setIndexWidget(const QModelIndex &index, QWidget *widget)


static void _init_f_setIndexWidget_3602 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("widget");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setIndexWidget_3602 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  QWidget *arg2 = args.read<QWidget * > ();
  ((QAbstractItemView *)cls)->setIndexWidget (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setIndexWidget_3602 ()
{
  return new qt_gsi::GenericMethod ("setIndexWidget", "@brief Method void QAbstractItemView::setIndexWidget(const QModelIndex &index, QWidget *widget)\n", false, &_init_f_setIndexWidget_3602, &_call_f_setIndexWidget_3602);
}

// void QAbstractItemView::setItemDelegate(QAbstractItemDelegate *delegate)


static void _init_f_setItemDelegate_2717 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("delegate");
  decl->add_arg<QAbstractItemDelegate * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setItemDelegate_2717 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractItemDelegate *arg1 = args.read<QAbstractItemDelegate * > ();
  ((QAbstractItemView *)cls)->setItemDelegate (arg1);
}

static qt_gsi::GenericMethod *_create_f_setItemDelegate_2717 ()
{
  return new qt_gsi::GenericMethod ("setItemDelegate|itemDelegate=", "@brief Method void QAbstractItemView::setItemDelegate(QAbstractItemDelegate *delegate)\n", false, &_init_f_setItemDelegate_2717, &_call_f_setItemDelegate_2717);
}

// void QAbstractItemView::setItemDelegateForColumn(int column, QAbstractItemDelegate *delegate)


static void _init_f_setItemDelegateForColumn_3376 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("delegate");
  decl->add_arg<QAbstractItemDelegate * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setItemDelegateForColumn_3376 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QAbstractItemDelegate *arg2 = args.read<QAbstractItemDelegate * > ();
  ((QAbstractItemView *)cls)->setItemDelegateForColumn (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setItemDelegateForColumn_3376 ()
{
  return new qt_gsi::GenericMethod ("setItemDelegateForColumn", "@brief Method void QAbstractItemView::setItemDelegateForColumn(int column, QAbstractItemDelegate *delegate)\n", false, &_init_f_setItemDelegateForColumn_3376, &_call_f_setItemDelegateForColumn_3376);
}

// void QAbstractItemView::setItemDelegateForRow(int row, QAbstractItemDelegate *delegate)


static void _init_f_setItemDelegateForRow_3376 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("delegate");
  decl->add_arg<QAbstractItemDelegate * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setItemDelegateForRow_3376 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QAbstractItemDelegate *arg2 = args.read<QAbstractItemDelegate * > ();
  ((QAbstractItemView *)cls)->setItemDelegateForRow (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setItemDelegateForRow_3376 ()
{
  return new qt_gsi::GenericMethod ("setItemDelegateForRow", "@brief Method void QAbstractItemView::setItemDelegateForRow(int row, QAbstractItemDelegate *delegate)\n", false, &_init_f_setItemDelegateForRow_3376, &_call_f_setItemDelegateForRow_3376);
}

// void QAbstractItemView::setModel(QAbstractItemModel *model)


static void _init_f_setModel_2419 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setModel_2419 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractItemModel *arg1 = args.read<QAbstractItemModel * > ();
  ((QAbstractItemView *)cls)->setModel (arg1);
}

static qt_gsi::GenericMethod *_create_f_setModel_2419 ()
{
  return new qt_gsi::GenericMethod ("setModel|model=", "@brief Method void QAbstractItemView::setModel(QAbstractItemModel *model)\n", false, &_init_f_setModel_2419, &_call_f_setModel_2419);
}

// void QAbstractItemView::setRootIndex(const QModelIndex &index)


static void _init_f_setRootIndex_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRootIndex_2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ((QAbstractItemView *)cls)->setRootIndex (arg1);
}

static qt_gsi::GenericMethod *_create_f_setRootIndex_2395 ()
{
  return new qt_gsi::GenericMethod ("setRootIndex|rootIndex=", "@brief Method void QAbstractItemView::setRootIndex(const QModelIndex &index)\n", false, &_init_f_setRootIndex_2395, &_call_f_setRootIndex_2395);
}

// void QAbstractItemView::setSelectionBehavior(QAbstractItemView::SelectionBehavior behavior)


static void _init_f_setSelectionBehavior_4013 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("behavior");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::SelectionBehavior>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSelectionBehavior_4013 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QAbstractItemView::SelectionBehavior>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractItemView::SelectionBehavior>::target_type & > ();
  ((QAbstractItemView *)cls)->setSelectionBehavior (qt_gsi::QtToCppAdaptor<QAbstractItemView::SelectionBehavior>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setSelectionBehavior_4013 ()
{
  return new qt_gsi::GenericMethod ("setSelectionBehavior|selectionBehavior=", "@brief Method void QAbstractItemView::setSelectionBehavior(QAbstractItemView::SelectionBehavior behavior)\n", false, &_init_f_setSelectionBehavior_4013, &_call_f_setSelectionBehavior_4013);
}

// void QAbstractItemView::setSelectionMode(QAbstractItemView::SelectionMode mode)


static void _init_f_setSelectionMode_3586 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::SelectionMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSelectionMode_3586 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QAbstractItemView::SelectionMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractItemView::SelectionMode>::target_type & > ();
  ((QAbstractItemView *)cls)->setSelectionMode (qt_gsi::QtToCppAdaptor<QAbstractItemView::SelectionMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setSelectionMode_3586 ()
{
  return new qt_gsi::GenericMethod ("setSelectionMode|selectionMode=", "@brief Method void QAbstractItemView::setSelectionMode(QAbstractItemView::SelectionMode mode)\n", false, &_init_f_setSelectionMode_3586, &_call_f_setSelectionMode_3586);
}

// void QAbstractItemView::setSelectionModel(QItemSelectionModel *selectionModel)


static void _init_f_setSelectionModel_2533 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selectionModel");
  decl->add_arg<QItemSelectionModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSelectionModel_2533 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QItemSelectionModel *arg1 = args.read<QItemSelectionModel * > ();
  ((QAbstractItemView *)cls)->setSelectionModel (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSelectionModel_2533 ()
{
  return new qt_gsi::GenericMethod ("setSelectionModel|selectionModel=", "@brief Method void QAbstractItemView::setSelectionModel(QItemSelectionModel *selectionModel)\n", false, &_init_f_setSelectionModel_2533, &_call_f_setSelectionModel_2533);
}

// void QAbstractItemView::setTabKeyNavigation(bool enable)


static void _init_f_setTabKeyNavigation_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTabKeyNavigation_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QAbstractItemView *)cls)->setTabKeyNavigation (arg1);
}

static qt_gsi::GenericMethod *_create_f_setTabKeyNavigation_864 ()
{
  return new qt_gsi::GenericMethod ("setTabKeyNavigation|tabKeyNavigation=", "@brief Method void QAbstractItemView::setTabKeyNavigation(bool enable)\n", false, &_init_f_setTabKeyNavigation_864, &_call_f_setTabKeyNavigation_864);
}

// void QAbstractItemView::setTextElideMode(Qt::TextElideMode mode)


static void _init_f_setTextElideMode_2042 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::TextElideMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextElideMode_2042 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::TextElideMode>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::TextElideMode>::target_type & > ();
  ((QAbstractItemView *)cls)->setTextElideMode (qt_gsi::QtToCppAdaptor<Qt::TextElideMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setTextElideMode_2042 ()
{
  return new qt_gsi::GenericMethod ("setTextElideMode|textElideMode=", "@brief Method void QAbstractItemView::setTextElideMode(Qt::TextElideMode mode)\n", false, &_init_f_setTextElideMode_2042, &_call_f_setTextElideMode_2042);
}

// void QAbstractItemView::setVerticalScrollMode(QAbstractItemView::ScrollMode mode)


static void _init_f_setVerticalScrollMode_3275 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::ScrollMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVerticalScrollMode_3275 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QAbstractItemView::ScrollMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractItemView::ScrollMode>::target_type & > ();
  ((QAbstractItemView *)cls)->setVerticalScrollMode (qt_gsi::QtToCppAdaptor<QAbstractItemView::ScrollMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setVerticalScrollMode_3275 ()
{
  return new qt_gsi::GenericMethod ("setVerticalScrollMode|verticalScrollMode=", "@brief Method void QAbstractItemView::setVerticalScrollMode(QAbstractItemView::ScrollMode mode)\n", false, &_init_f_setVerticalScrollMode_3275, &_call_f_setVerticalScrollMode_3275);
}

// bool QAbstractItemView::showDropIndicator()


static void _init_f_showDropIndicator_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_showDropIndicator_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QAbstractItemView *)cls)->showDropIndicator ());
}

static qt_gsi::GenericMethod *_create_f_showDropIndicator_c0 ()
{
  return new qt_gsi::GenericMethod (":showDropIndicator", "@brief Method bool QAbstractItemView::showDropIndicator()\n", true, &_init_f_showDropIndicator_c0, &_call_f_showDropIndicator_c0);
}

// int QAbstractItemView::sizeHintForColumn(int column)


static void _init_f_sizeHintForColumn_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_sizeHintForColumn_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QAbstractItemView *)cls)->sizeHintForColumn (arg1));
}

static qt_gsi::GenericMethod *_create_f_sizeHintForColumn_c767 ()
{
  return new qt_gsi::GenericMethod ("sizeHintForColumn", "@brief Method int QAbstractItemView::sizeHintForColumn(int column)\n", true, &_init_f_sizeHintForColumn_c767, &_call_f_sizeHintForColumn_c767);
}

// QSize QAbstractItemView::sizeHintForIndex(const QModelIndex &index)


static void _init_f_sizeHintForIndex_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QSize > ();
}

static void _call_f_sizeHintForIndex_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QSize > ((QSize)((QAbstractItemView *)cls)->sizeHintForIndex (arg1));
}

static qt_gsi::GenericMethod *_create_f_sizeHintForIndex_c2395 ()
{
  return new qt_gsi::GenericMethod ("sizeHintForIndex", "@brief Method QSize QAbstractItemView::sizeHintForIndex(const QModelIndex &index)\n", true, &_init_f_sizeHintForIndex_c2395, &_call_f_sizeHintForIndex_c2395);
}

// int QAbstractItemView::sizeHintForRow(int row)


static void _init_f_sizeHintForRow_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_sizeHintForRow_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QAbstractItemView *)cls)->sizeHintForRow (arg1));
}

static qt_gsi::GenericMethod *_create_f_sizeHintForRow_c767 ()
{
  return new qt_gsi::GenericMethod ("sizeHintForRow", "@brief Method int QAbstractItemView::sizeHintForRow(int row)\n", true, &_init_f_sizeHintForRow_c767, &_call_f_sizeHintForRow_c767);
}

// bool QAbstractItemView::tabKeyNavigation()


static void _init_f_tabKeyNavigation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_tabKeyNavigation_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QAbstractItemView *)cls)->tabKeyNavigation ());
}

static qt_gsi::GenericMethod *_create_f_tabKeyNavigation_c0 ()
{
  return new qt_gsi::GenericMethod (":tabKeyNavigation", "@brief Method bool QAbstractItemView::tabKeyNavigation()\n", true, &_init_f_tabKeyNavigation_c0, &_call_f_tabKeyNavigation_c0);
}

// Qt::TextElideMode QAbstractItemView::textElideMode()


static void _init_f_textElideMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::TextElideMode>::target_type > ();
}

static void _call_f_textElideMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::TextElideMode>::target_type > ((qt_gsi::Converter<Qt::TextElideMode>::target_type)qt_gsi::CppToQtAdaptor<Qt::TextElideMode>(((QAbstractItemView *)cls)->textElideMode ()));
}

static qt_gsi::GenericMethod *_create_f_textElideMode_c0 ()
{
  return new qt_gsi::GenericMethod (":textElideMode", "@brief Method Qt::TextElideMode QAbstractItemView::textElideMode()\n", true, &_init_f_textElideMode_c0, &_call_f_textElideMode_c0);
}

// void QAbstractItemView::update(const QRegion &)


static void _init_f_update_2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_update_2006 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRegion &arg1 = args.read<const QRegion & > ();
  ((QAbstractItemView *)cls)->update (arg1);
}

static qt_gsi::GenericMethod *_create_f_update_2006 ()
{
  return new qt_gsi::GenericMethod ("update", "@brief Method void QAbstractItemView::update(const QRegion &)\n", false, &_init_f_update_2006, &_call_f_update_2006);
}

// void QAbstractItemView::update(const QModelIndex &index)


static void _init_f_update_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_update_2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ((QAbstractItemView *)cls)->update (arg1);
}

static qt_gsi::GenericMethod *_create_f_update_2395 ()
{
  return new qt_gsi::GenericMethod ("update", "@brief Method void QAbstractItemView::update(const QModelIndex &index)\n", false, &_init_f_update_2395, &_call_f_update_2395);
}

// QAbstractItemView::ScrollMode QAbstractItemView::verticalScrollMode()


static void _init_f_verticalScrollMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAbstractItemView::ScrollMode>::target_type > ();
}

static void _call_f_verticalScrollMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QAbstractItemView::ScrollMode>::target_type > ((qt_gsi::Converter<QAbstractItemView::ScrollMode>::target_type)qt_gsi::CppToQtAdaptor<QAbstractItemView::ScrollMode>(((QAbstractItemView *)cls)->verticalScrollMode ()));
}

static qt_gsi::GenericMethod *_create_f_verticalScrollMode_c0 ()
{
  return new qt_gsi::GenericMethod (":verticalScrollMode", "@brief Method QAbstractItemView::ScrollMode QAbstractItemView::verticalScrollMode()\n", true, &_init_f_verticalScrollMode_c0, &_call_f_verticalScrollMode_c0);
}

// QRect QAbstractItemView::visualRect(const QModelIndex &index)


static void _init_f_visualRect_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_f_visualRect_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QRect > ((QRect)((QAbstractItemView *)cls)->visualRect (arg1));
}

static qt_gsi::GenericMethod *_create_f_visualRect_c2395 ()
{
  return new qt_gsi::GenericMethod ("visualRect", "@brief Method QRect QAbstractItemView::visualRect(const QModelIndex &index)\n", true, &_init_f_visualRect_c2395, &_call_f_visualRect_c2395);
}

// static QString QAbstractItemView::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QAbstractItemView::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractItemView::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QAbstractItemView::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QAbstractItemView::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractItemView::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QAbstractItemView::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QAbstractItemView::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAbstractItemView::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QAbstractItemView::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QAbstractItemView::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAbstractItemView::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QAbstractItemView, QAbstractItemView_EventAdaptor> ea_QAbstractItemView;

namespace gsi
{
extern gsi::Class<QAbstractScrollArea> decl_QAbstractScrollArea;

gsi::Class<QAbstractItemView> decl_QAbstractItemView (ea_QAbstractItemView, decl_QAbstractScrollArea, "QAbstractItemView_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_alternatingRowColors_c0 ()) +
  gsi::Methods(_create_f_autoScrollMargin_c0 ()) +
  gsi::Methods(_create_f_clearSelection_0 ()) +
  gsi::Methods(_create_f_closePersistentEditor_2395 ()) +
  gsi::Methods(_create_f_currentIndex_c0 ()) +
  gsi::Methods(_create_f_defaultDropAction_c0 ()) +
  gsi::Methods(_create_f_doItemsLayout_0 ()) +
  gsi::Methods(_create_f_dragDropMode_c0 ()) +
  gsi::Methods(_create_f_dragDropOverwriteMode_c0 ()) +
  gsi::Methods(_create_f_dragEnabled_c0 ()) +
  gsi::Methods(_create_f_edit_2395 ()) +
  gsi::Methods(_create_f_editTriggers_c0 ()) +
  gsi::Methods(_create_f_hasAutoScroll_c0 ()) +
  gsi::Methods(_create_f_horizontalScrollMode_c0 ()) +
  gsi::Methods(_create_f_iconSize_c0 ()) +
  gsi::Methods(_create_f_indexAt_c1916 ()) +
  gsi::Methods(_create_f_indexWidget_c2395 ()) +
  gsi::Methods(_create_f_inputMethodQuery_c2420 ()) +
  gsi::Methods(_create_f_itemDelegate_c0 ()) +
  gsi::Methods(_create_f_itemDelegate_c2395 ()) +
  gsi::Methods(_create_f_itemDelegateForColumn_c767 ()) +
  gsi::Methods(_create_f_itemDelegateForRow_c767 ()) +
  gsi::Methods(_create_f_keyboardSearch_2025 ()) +
  gsi::Methods(_create_f_model_c0 ()) +
  gsi::Methods(_create_f_openPersistentEditor_2395 ()) +
  gsi::Methods(_create_f_reset_0 ()) +
  gsi::Methods(_create_f_rootIndex_c0 ()) +
  gsi::Methods(_create_f_scrollTo_5576 ()) +
  gsi::Methods(_create_f_scrollToBottom_0 ()) +
  gsi::Methods(_create_f_scrollToTop_0 ()) +
  gsi::Methods(_create_f_selectAll_0 ()) +
  gsi::Methods(_create_f_selectionBehavior_c0 ()) +
  gsi::Methods(_create_f_selectionMode_c0 ()) +
  gsi::Methods(_create_f_selectionModel_c0 ()) +
  gsi::Methods(_create_f_setAlternatingRowColors_864 ()) +
  gsi::Methods(_create_f_setAutoScroll_864 ()) +
  gsi::Methods(_create_f_setAutoScrollMargin_767 ()) +
  gsi::Methods(_create_f_setCurrentIndex_2395 ()) +
  gsi::Methods(_create_f_setDefaultDropAction_1760 ()) +
  gsi::Methods(_create_f_setDragDropMode_3439 ()) +
  gsi::Methods(_create_f_setDragDropOverwriteMode_864 ()) +
  gsi::Methods(_create_f_setDragEnabled_864 ()) +
  gsi::Methods(_create_f_setDropIndicatorShown_864 ()) +
  gsi::Methods(_create_f_setEditTriggers_4073 ()) +
  gsi::Methods(_create_f_setHorizontalScrollMode_3275 ()) +
  gsi::Methods(_create_f_setIconSize_1805 ()) +
  gsi::Methods(_create_f_setIndexWidget_3602 ()) +
  gsi::Methods(_create_f_setItemDelegate_2717 ()) +
  gsi::Methods(_create_f_setItemDelegateForColumn_3376 ()) +
  gsi::Methods(_create_f_setItemDelegateForRow_3376 ()) +
  gsi::Methods(_create_f_setModel_2419 ()) +
  gsi::Methods(_create_f_setRootIndex_2395 ()) +
  gsi::Methods(_create_f_setSelectionBehavior_4013 ()) +
  gsi::Methods(_create_f_setSelectionMode_3586 ()) +
  gsi::Methods(_create_f_setSelectionModel_2533 ()) +
  gsi::Methods(_create_f_setTabKeyNavigation_864 ()) +
  gsi::Methods(_create_f_setTextElideMode_2042 ()) +
  gsi::Methods(_create_f_setVerticalScrollMode_3275 ()) +
  gsi::Methods(_create_f_showDropIndicator_c0 ()) +
  gsi::Methods(_create_f_sizeHintForColumn_c767 ()) +
  gsi::Methods(_create_f_sizeHintForIndex_c2395 ()) +
  gsi::Methods(_create_f_sizeHintForRow_c767 ()) +
  gsi::Methods(_create_f_tabKeyNavigation_c0 ()) +
  gsi::Methods(_create_f_textElideMode_c0 ()) +
  gsi::Methods(_create_f_update_2006 ()) +
  gsi::Methods(_create_f_update_2395 ()) +
  gsi::Methods(_create_f_verticalScrollMode_c0 ()) +
  gsi::Methods(_create_f_visualRect_c2395 ()) +
  qt_gsi::qt_signal<QAbstractItemView, QAbstractItemView_EventAdaptor, const QModelIndex &> ("activated", &QAbstractItemView_EventAdaptor::activated_e_2395, gsi::arg("index"), "@brief Signal declaration for QAbstractItemView::activated(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractItemView, QAbstractItemView_EventAdaptor, const QModelIndex &> ("clicked", &QAbstractItemView_EventAdaptor::clicked_e_2395, gsi::arg("index"), "@brief Signal declaration for QAbstractItemView::clicked(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractItemView, QAbstractItemView_EventAdaptor, const QPoint &> ("customContextMenuRequested", &QAbstractItemView_EventAdaptor::customContextMenuRequested_e_1916, gsi::arg("pos"), "@brief Signal declaration for QAbstractItemView::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractItemView, QAbstractItemView_EventAdaptor, QObject *> ("destroyed", &QAbstractItemView_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QAbstractItemView::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractItemView, QAbstractItemView_EventAdaptor, const QModelIndex &> ("doubleClicked", &QAbstractItemView_EventAdaptor::doubleClicked_e_2395, gsi::arg("index"), "@brief Signal declaration for QAbstractItemView::doubleClicked(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractItemView, QAbstractItemView_EventAdaptor, const QModelIndex &> ("entered", &QAbstractItemView_EventAdaptor::entered_e_2395, gsi::arg("index"), "@brief Signal declaration for QAbstractItemView::entered(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractItemView, QAbstractItemView_EventAdaptor, const QModelIndex &> ("pressed", &QAbstractItemView_EventAdaptor::pressed_e_2395, gsi::arg("index"), "@brief Signal declaration for QAbstractItemView::pressed(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractItemView, QAbstractItemView_EventAdaptor> ("viewportEntered", &QAbstractItemView_EventAdaptor::viewportEntered_e_0, "@brief Signal declaration for QAbstractItemView::viewportEntered()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QAbstractItemView");
}


class QAbstractItemView_Adaptor : public QAbstractItemView, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAbstractItemView_Adaptor();

  //  [adaptor ctor] QAbstractItemView::QAbstractItemView(QWidget *parent)
  QAbstractItemView_Adaptor() : QAbstractItemView()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QAbstractItemView::QAbstractItemView(QWidget *parent)
  QAbstractItemView_Adaptor(QWidget *parent) : QAbstractItemView(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QAbstractItemView::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QAbstractItemView_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QAbstractItemView::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  void QAbstractItemView::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QAbstractItemView_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QAbstractItemView::destroy(destroyWindow, destroySubWindows);
  }

  //  QPoint QAbstractItemView::dirtyRegionOffset()
  QPoint fp_QAbstractItemView_dirtyRegionOffset_c0 () const {
    return QAbstractItemView::dirtyRegionOffset();
  }

  //  void QAbstractItemView::doAutoScroll()
  void fp_QAbstractItemView_doAutoScroll_0 () {
    QAbstractItemView::doAutoScroll();
  }

  //  void QAbstractItemView::drawFrame(QPainter *)
  void fp_QAbstractItemView_drawFrame_1426 (QPainter *arg1) {
    QAbstractItemView::drawFrame(arg1);
  }

  //  QAbstractItemView::DropIndicatorPosition QAbstractItemView::dropIndicatorPosition()
  unsigned int fp_QAbstractItemView_dropIndicatorPosition_c0 () const {
    return (unsigned int)(QAbstractItemView::dropIndicatorPosition());
  }

  //  void QAbstractItemView::executeDelayedItemsLayout()
  void fp_QAbstractItemView_executeDelayedItemsLayout_0 () {
    QAbstractItemView::executeDelayedItemsLayout();
  }

  //  bool QAbstractItemView::focusNextChild()
  bool fp_QAbstractItemView_focusNextChild_0 () {
    return QAbstractItemView::focusNextChild();
  }

  //  bool QAbstractItemView::focusPreviousChild()
  bool fp_QAbstractItemView_focusPreviousChild_0 () {
    return QAbstractItemView::focusPreviousChild();
  }

  //  int QAbstractItemView::horizontalStepsPerItem()
  int fp_QAbstractItemView_horizontalStepsPerItem_c0 () const {
    return QAbstractItemView::horizontalStepsPerItem();
  }

  //  int QAbstractItemView::receivers(const char *signal)
  int fp_QAbstractItemView_receivers_c1731 (const char *signal) const {
    return QAbstractItemView::receivers(signal);
  }

  //  void QAbstractItemView::resetInputContext()
  void fp_QAbstractItemView_resetInputContext_0 () {
    QAbstractItemView::resetInputContext();
  }

  //  void QAbstractItemView::scheduleDelayedItemsLayout()
  void fp_QAbstractItemView_scheduleDelayedItemsLayout_0 () {
    QAbstractItemView::scheduleDelayedItemsLayout();
  }

  //  void QAbstractItemView::scrollDirtyRegion(int dx, int dy)
  void fp_QAbstractItemView_scrollDirtyRegion_1426 (int dx, int dy) {
    QAbstractItemView::scrollDirtyRegion(dx, dy);
  }

  //  QObject *QAbstractItemView::sender()
  QObject * fp_QAbstractItemView_sender_c0 () const {
    return QAbstractItemView::sender();
  }

  //  void QAbstractItemView::setDirtyRegion(const QRegion &region)
  void fp_QAbstractItemView_setDirtyRegion_2006 (const QRegion &region) {
    QAbstractItemView::setDirtyRegion(region);
  }

  //  void QAbstractItemView::setHorizontalStepsPerItem(int steps)
  void fp_QAbstractItemView_setHorizontalStepsPerItem_767 (int steps) {
    QAbstractItemView::setHorizontalStepsPerItem(steps);
  }

  //  void QAbstractItemView::setState(QAbstractItemView::State state)
  void fp_QAbstractItemView_setState_2776 (unsigned int state) {
    QAbstractItemView::setState(QAbstractItemView::State(state));
  }

  //  void QAbstractItemView::setVerticalStepsPerItem(int steps)
  void fp_QAbstractItemView_setVerticalStepsPerItem_767 (int steps) {
    QAbstractItemView::setVerticalStepsPerItem(steps);
  }

  //  void QAbstractItemView::setViewportMargins(int left, int top, int right, int bottom)
  void fp_QAbstractItemView_setViewportMargins_2744 (int left, int top, int right, int bottom) {
    QAbstractItemView::setViewportMargins(left, top, right, bottom);
  }

  //  void QAbstractItemView::setViewportMargins(const QMargins &margins)
  void fp_QAbstractItemView_setViewportMargins_2115 (const QMargins &margins) {
    QAbstractItemView::setViewportMargins(margins);
  }

  //  void QAbstractItemView::setupViewport(QWidget *viewport)
  void fp_QAbstractItemView_setupViewport_1315 (QWidget *viewport) {
    QAbstractItemView::setupViewport(viewport);
  }

  //  void QAbstractItemView::startAutoScroll()
  void fp_QAbstractItemView_startAutoScroll_0 () {
    QAbstractItemView::startAutoScroll();
  }

  //  QAbstractItemView::State QAbstractItemView::state()
  unsigned int fp_QAbstractItemView_state_c0 () const {
    return (unsigned int)(QAbstractItemView::state());
  }

  //  void QAbstractItemView::stopAutoScroll()
  void fp_QAbstractItemView_stopAutoScroll_0 () {
    QAbstractItemView::stopAutoScroll();
  }

  //  void QAbstractItemView::updateMicroFocus()
  void fp_QAbstractItemView_updateMicroFocus_0 () {
    QAbstractItemView::updateMicroFocus();
  }

  //  int QAbstractItemView::verticalStepsPerItem()
  int fp_QAbstractItemView_verticalStepsPerItem_c0 () const {
    return QAbstractItemView::verticalStepsPerItem();
  }

  //  [adaptor impl] void QAbstractItemView::doItemsLayout()
  void cbs_doItemsLayout_0_0()
  {
    QAbstractItemView::doItemsLayout();
  }

  virtual void doItemsLayout()
  {
    if (cb_doItemsLayout_0_0.can_issue()) {
      cb_doItemsLayout_0_0.issue<QAbstractItemView_Adaptor>(&QAbstractItemView_Adaptor::cbs_doItemsLayout_0_0);
    } else {
      QAbstractItemView::doItemsLayout();
    }
  }

  //  [adaptor impl] bool QAbstractItemView::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QAbstractItemView::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QAbstractItemView_Adaptor, bool, QObject *, QEvent *>(&QAbstractItemView_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QAbstractItemView::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] int QAbstractItemView::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QAbstractItemView::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QAbstractItemView_Adaptor, int, int>(&QAbstractItemView_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QAbstractItemView::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QModelIndex QAbstractItemView::indexAt(const QPoint &point)
  QModelIndex cbs_indexAt_c1916_0(const QPoint &point) const
  {
    throw qt_gsi::AbstractMethodCalledException("indexAt");
  }

  virtual QModelIndex indexAt(const QPoint &point) const
  {
    if (cb_indexAt_c1916_0.can_issue()) {
      return cb_indexAt_c1916_0.issue<QAbstractItemView_Adaptor, QModelIndex, const QPoint &>(&QAbstractItemView_Adaptor::cbs_indexAt_c1916_0, point);
    } else {
      throw qt_gsi::AbstractMethodCalledException("indexAt");
    }
  }

  //  [adaptor impl] QVariant QAbstractItemView::inputMethodQuery(Qt::InputMethodQuery query)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) const
  {
    return QAbstractItemView::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery query) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QAbstractItemView_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QAbstractItemView_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(query));
    } else {
      return QAbstractItemView::inputMethodQuery(query);
    }
  }

  //  [adaptor impl] void QAbstractItemView::keyboardSearch(const QString &search)
  void cbs_keyboardSearch_2025_0(const QString &search)
  {
    QAbstractItemView::keyboardSearch(search);
  }

  virtual void keyboardSearch(const QString &search)
  {
    if (cb_keyboardSearch_2025_0.can_issue()) {
      cb_keyboardSearch_2025_0.issue<QAbstractItemView_Adaptor, const QString &>(&QAbstractItemView_Adaptor::cbs_keyboardSearch_2025_0, search);
    } else {
      QAbstractItemView::keyboardSearch(search);
    }
  }

  //  [adaptor impl] QSize QAbstractItemView::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QAbstractItemView::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QAbstractItemView_Adaptor, QSize>(&QAbstractItemView_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QAbstractItemView::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QAbstractItemView::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QAbstractItemView::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QAbstractItemView_Adaptor, QPaintEngine *>(&QAbstractItemView_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QAbstractItemView::paintEngine();
    }
  }

  //  [adaptor impl] void QAbstractItemView::reset()
  void cbs_reset_0_0()
  {
    QAbstractItemView::reset();
  }

  virtual void reset()
  {
    if (cb_reset_0_0.can_issue()) {
      cb_reset_0_0.issue<QAbstractItemView_Adaptor>(&QAbstractItemView_Adaptor::cbs_reset_0_0);
    } else {
      QAbstractItemView::reset();
    }
  }

  //  [adaptor impl] void QAbstractItemView::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)
  void cbs_scrollTo_5576_1(const QModelIndex &index, const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & hint)
  {
    throw qt_gsi::AbstractMethodCalledException("scrollTo");
  }

  virtual void scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)
  {
    if (cb_scrollTo_5576_1.can_issue()) {
      cb_scrollTo_5576_1.issue<QAbstractItemView_Adaptor, const QModelIndex &, const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type &>(&QAbstractItemView_Adaptor::cbs_scrollTo_5576_1, index, qt_gsi::CppToQtAdaptor<QAbstractItemView::ScrollHint>(hint));
    } else {
      throw qt_gsi::AbstractMethodCalledException("scrollTo");
    }
  }

  //  [adaptor impl] void QAbstractItemView::selectAll()
  void cbs_selectAll_0_0()
  {
    QAbstractItemView::selectAll();
  }

  virtual void selectAll()
  {
    if (cb_selectAll_0_0.can_issue()) {
      cb_selectAll_0_0.issue<QAbstractItemView_Adaptor>(&QAbstractItemView_Adaptor::cbs_selectAll_0_0);
    } else {
      QAbstractItemView::selectAll();
    }
  }

  //  [adaptor impl] void QAbstractItemView::setModel(QAbstractItemModel *model)
  void cbs_setModel_2419_0(QAbstractItemModel *model)
  {
    QAbstractItemView::setModel(model);
  }

  virtual void setModel(QAbstractItemModel *model)
  {
    if (cb_setModel_2419_0.can_issue()) {
      cb_setModel_2419_0.issue<QAbstractItemView_Adaptor, QAbstractItemModel *>(&QAbstractItemView_Adaptor::cbs_setModel_2419_0, model);
    } else {
      QAbstractItemView::setModel(model);
    }
  }

  //  [adaptor impl] void QAbstractItemView::setRootIndex(const QModelIndex &index)
  void cbs_setRootIndex_2395_0(const QModelIndex &index)
  {
    QAbstractItemView::setRootIndex(index);
  }

  virtual void setRootIndex(const QModelIndex &index)
  {
    if (cb_setRootIndex_2395_0.can_issue()) {
      cb_setRootIndex_2395_0.issue<QAbstractItemView_Adaptor, const QModelIndex &>(&QAbstractItemView_Adaptor::cbs_setRootIndex_2395_0, index);
    } else {
      QAbstractItemView::setRootIndex(index);
    }
  }

  //  [adaptor impl] void QAbstractItemView::setSelectionModel(QItemSelectionModel *selectionModel)
  void cbs_setSelectionModel_2533_0(QItemSelectionModel *selectionModel)
  {
    QAbstractItemView::setSelectionModel(selectionModel);
  }

  virtual void setSelectionModel(QItemSelectionModel *selectionModel)
  {
    if (cb_setSelectionModel_2533_0.can_issue()) {
      cb_setSelectionModel_2533_0.issue<QAbstractItemView_Adaptor, QItemSelectionModel *>(&QAbstractItemView_Adaptor::cbs_setSelectionModel_2533_0, selectionModel);
    } else {
      QAbstractItemView::setSelectionModel(selectionModel);
    }
  }

  //  [adaptor impl] void QAbstractItemView::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QAbstractItemView::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QAbstractItemView_Adaptor, bool>(&QAbstractItemView_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QAbstractItemView::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QAbstractItemView::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QAbstractItemView::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QAbstractItemView_Adaptor, QSize>(&QAbstractItemView_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QAbstractItemView::sizeHint();
    }
  }

  //  [adaptor impl] int QAbstractItemView::sizeHintForColumn(int column)
  int cbs_sizeHintForColumn_c767_0(int column) const
  {
    return QAbstractItemView::sizeHintForColumn(column);
  }

  virtual int sizeHintForColumn(int column) const
  {
    if (cb_sizeHintForColumn_c767_0.can_issue()) {
      return cb_sizeHintForColumn_c767_0.issue<QAbstractItemView_Adaptor, int, int>(&QAbstractItemView_Adaptor::cbs_sizeHintForColumn_c767_0, column);
    } else {
      return QAbstractItemView::sizeHintForColumn(column);
    }
  }

  //  [adaptor impl] int QAbstractItemView::sizeHintForRow(int row)
  int cbs_sizeHintForRow_c767_0(int row) const
  {
    return QAbstractItemView::sizeHintForRow(row);
  }

  virtual int sizeHintForRow(int row) const
  {
    if (cb_sizeHintForRow_c767_0.can_issue()) {
      return cb_sizeHintForRow_c767_0.issue<QAbstractItemView_Adaptor, int, int>(&QAbstractItemView_Adaptor::cbs_sizeHintForRow_c767_0, row);
    } else {
      return QAbstractItemView::sizeHintForRow(row);
    }
  }

  //  [adaptor impl] QRect QAbstractItemView::visualRect(const QModelIndex &index)
  QRect cbs_visualRect_c2395_0(const QModelIndex &index) const
  {
    throw qt_gsi::AbstractMethodCalledException("visualRect");
  }

  virtual QRect visualRect(const QModelIndex &index) const
  {
    if (cb_visualRect_c2395_0.can_issue()) {
      return cb_visualRect_c2395_0.issue<QAbstractItemView_Adaptor, QRect, const QModelIndex &>(&QAbstractItemView_Adaptor::cbs_visualRect_c2395_0, index);
    } else {
      throw qt_gsi::AbstractMethodCalledException("visualRect");
    }
  }

  //  [adaptor impl] void QAbstractItemView::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QAbstractItemView::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QAbstractItemView_Adaptor, QActionEvent *>(&QAbstractItemView_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QAbstractItemView::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractItemView::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QAbstractItemView::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QAbstractItemView_Adaptor, QEvent *>(&QAbstractItemView_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QAbstractItemView::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractItemView::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QAbstractItemView::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QAbstractItemView_Adaptor, QChildEvent *>(&QAbstractItemView_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QAbstractItemView::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractItemView::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)
  void cbs_closeEditor_4926_0(QWidget *editor, const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & hint)
  {
    QAbstractItemView::closeEditor(editor, qt_gsi::QtToCppAdaptor<QAbstractItemDelegate::EndEditHint>(hint).cref());
  }

  virtual void closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)
  {
    if (cb_closeEditor_4926_0.can_issue()) {
      cb_closeEditor_4926_0.issue<QAbstractItemView_Adaptor, QWidget *, const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type &>(&QAbstractItemView_Adaptor::cbs_closeEditor_4926_0, editor, qt_gsi::CppToQtAdaptor<QAbstractItemDelegate::EndEditHint>(hint));
    } else {
      QAbstractItemView::closeEditor(editor, hint);
    }
  }

  //  [adaptor impl] void QAbstractItemView::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QAbstractItemView::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QAbstractItemView_Adaptor, QCloseEvent *>(&QAbstractItemView_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QAbstractItemView::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractItemView::commitData(QWidget *editor)
  void cbs_commitData_1315_0(QWidget *editor)
  {
    QAbstractItemView::commitData(editor);
  }

  virtual void commitData(QWidget *editor)
  {
    if (cb_commitData_1315_0.can_issue()) {
      cb_commitData_1315_0.issue<QAbstractItemView_Adaptor, QWidget *>(&QAbstractItemView_Adaptor::cbs_commitData_1315_0, editor);
    } else {
      QAbstractItemView::commitData(editor);
    }
  }

  //  [adaptor impl] void QAbstractItemView::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QAbstractItemView::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QAbstractItemView_Adaptor, QContextMenuEvent *>(&QAbstractItemView_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QAbstractItemView::contextMenuEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractItemView::currentChanged(const QModelIndex &current, const QModelIndex &previous)
  void cbs_currentChanged_4682_0(const QModelIndex &current, const QModelIndex &previous)
  {
    QAbstractItemView::currentChanged(current, previous);
  }

  virtual void currentChanged(const QModelIndex &current, const QModelIndex &previous)
  {
    if (cb_currentChanged_4682_0.can_issue()) {
      cb_currentChanged_4682_0.issue<QAbstractItemView_Adaptor, const QModelIndex &, const QModelIndex &>(&QAbstractItemView_Adaptor::cbs_currentChanged_4682_0, current, previous);
    } else {
      QAbstractItemView::currentChanged(current, previous);
    }
  }

  //  [adaptor impl] void QAbstractItemView::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QAbstractItemView::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QAbstractItemView_Adaptor, QEvent *>(&QAbstractItemView_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QAbstractItemView::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractItemView::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)
  void cbs_dataChanged_4682_0(const QModelIndex &topLeft, const QModelIndex &bottomRight)
  {
    QAbstractItemView::dataChanged(topLeft, bottomRight);
  }

  virtual void dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)
  {
    if (cb_dataChanged_4682_0.can_issue()) {
      cb_dataChanged_4682_0.issue<QAbstractItemView_Adaptor, const QModelIndex &, const QModelIndex &>(&QAbstractItemView_Adaptor::cbs_dataChanged_4682_0, topLeft, bottomRight);
    } else {
      QAbstractItemView::dataChanged(topLeft, bottomRight);
    }
  }

  //  [adaptor impl] void QAbstractItemView::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QAbstractItemView::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QAbstractItemView_Adaptor, const char *>(&QAbstractItemView_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QAbstractItemView::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QAbstractItemView::dragEnterEvent(QDragEnterEvent *event)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *event)
  {
    QAbstractItemView::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QDragEnterEvent *event)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QAbstractItemView_Adaptor, QDragEnterEvent *>(&QAbstractItemView_Adaptor::cbs_dragEnterEvent_2109_0, event);
    } else {
      QAbstractItemView::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractItemView::dragLeaveEvent(QDragLeaveEvent *event)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *event)
  {
    QAbstractItemView::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *event)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QAbstractItemView_Adaptor, QDragLeaveEvent *>(&QAbstractItemView_Adaptor::cbs_dragLeaveEvent_2092_0, event);
    } else {
      QAbstractItemView::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractItemView::dragMoveEvent(QDragMoveEvent *event)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *event)
  {
    QAbstractItemView::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QDragMoveEvent *event)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QAbstractItemView_Adaptor, QDragMoveEvent *>(&QAbstractItemView_Adaptor::cbs_dragMoveEvent_2006_0, event);
    } else {
      QAbstractItemView::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractItemView::dropEvent(QDropEvent *event)
  void cbs_dropEvent_1622_0(QDropEvent *event)
  {
    QAbstractItemView::dropEvent(event);
  }

  virtual void dropEvent(QDropEvent *event)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QAbstractItemView_Adaptor, QDropEvent *>(&QAbstractItemView_Adaptor::cbs_dropEvent_1622_0, event);
    } else {
      QAbstractItemView::dropEvent(event);
    }
  }

  //  [adaptor impl] bool QAbstractItemView::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)
  bool cbs_edit_6773_0(const QModelIndex &index, const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & trigger, QEvent *event)
  {
    return QAbstractItemView::edit(index, qt_gsi::QtToCppAdaptor<QAbstractItemView::EditTrigger>(trigger).cref(), event);
  }

  virtual bool edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)
  {
    if (cb_edit_6773_0.can_issue()) {
      return cb_edit_6773_0.issue<QAbstractItemView_Adaptor, bool, const QModelIndex &, const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type &, QEvent *>(&QAbstractItemView_Adaptor::cbs_edit_6773_0, index, qt_gsi::CppToQtAdaptor<QAbstractItemView::EditTrigger>(trigger), event);
    } else {
      return QAbstractItemView::edit(index, trigger, event);
    }
  }

  //  [adaptor impl] void QAbstractItemView::editorDestroyed(QObject *editor)
  void cbs_editorDestroyed_1302_0(QObject *editor)
  {
    QAbstractItemView::editorDestroyed(editor);
  }

  virtual void editorDestroyed(QObject *editor)
  {
    if (cb_editorDestroyed_1302_0.can_issue()) {
      cb_editorDestroyed_1302_0.issue<QAbstractItemView_Adaptor, QObject *>(&QAbstractItemView_Adaptor::cbs_editorDestroyed_1302_0, editor);
    } else {
      QAbstractItemView::editorDestroyed(editor);
    }
  }

  //  [adaptor impl] void QAbstractItemView::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QAbstractItemView::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QAbstractItemView_Adaptor, bool>(&QAbstractItemView_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QAbstractItemView::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QAbstractItemView::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QAbstractItemView::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QAbstractItemView_Adaptor, QEvent *>(&QAbstractItemView_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QAbstractItemView::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QAbstractItemView::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QAbstractItemView::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QAbstractItemView_Adaptor, bool, QEvent *>(&QAbstractItemView_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QAbstractItemView::event(_event);
    }
  }

  //  [adaptor impl] void QAbstractItemView::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QAbstractItemView::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QAbstractItemView_Adaptor, QFocusEvent *>(&QAbstractItemView_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QAbstractItemView::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QAbstractItemView::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QAbstractItemView::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QAbstractItemView_Adaptor, bool, bool>(&QAbstractItemView_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QAbstractItemView::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QAbstractItemView::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QAbstractItemView::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QAbstractItemView_Adaptor, QFocusEvent *>(&QAbstractItemView_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QAbstractItemView::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractItemView::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QAbstractItemView::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QAbstractItemView_Adaptor, const QFont &>(&QAbstractItemView_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QAbstractItemView::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QAbstractItemView::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QAbstractItemView::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QAbstractItemView_Adaptor, QHideEvent *>(&QAbstractItemView_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QAbstractItemView::hideEvent(arg1);
    }
  }

  //  [adaptor impl] int QAbstractItemView::horizontalOffset()
  int cbs_horizontalOffset_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("horizontalOffset");
  }

  virtual int horizontalOffset() const
  {
    if (cb_horizontalOffset_c0_0.can_issue()) {
      return cb_horizontalOffset_c0_0.issue<QAbstractItemView_Adaptor, int>(&QAbstractItemView_Adaptor::cbs_horizontalOffset_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("horizontalOffset");
    }
  }

  //  [adaptor impl] void QAbstractItemView::horizontalScrollbarAction(int action)
  void cbs_horizontalScrollbarAction_767_0(int action)
  {
    QAbstractItemView::horizontalScrollbarAction(action);
  }

  virtual void horizontalScrollbarAction(int action)
  {
    if (cb_horizontalScrollbarAction_767_0.can_issue()) {
      cb_horizontalScrollbarAction_767_0.issue<QAbstractItemView_Adaptor, int>(&QAbstractItemView_Adaptor::cbs_horizontalScrollbarAction_767_0, action);
    } else {
      QAbstractItemView::horizontalScrollbarAction(action);
    }
  }

  //  [adaptor impl] void QAbstractItemView::horizontalScrollbarValueChanged(int value)
  void cbs_horizontalScrollbarValueChanged_767_0(int value)
  {
    QAbstractItemView::horizontalScrollbarValueChanged(value);
  }

  virtual void horizontalScrollbarValueChanged(int value)
  {
    if (cb_horizontalScrollbarValueChanged_767_0.can_issue()) {
      cb_horizontalScrollbarValueChanged_767_0.issue<QAbstractItemView_Adaptor, int>(&QAbstractItemView_Adaptor::cbs_horizontalScrollbarValueChanged_767_0, value);
    } else {
      QAbstractItemView::horizontalScrollbarValueChanged(value);
    }
  }

  //  [adaptor impl] void QAbstractItemView::inputMethodEvent(QInputMethodEvent *event)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *event)
  {
    QAbstractItemView::inputMethodEvent(event);
  }

  virtual void inputMethodEvent(QInputMethodEvent *event)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QAbstractItemView_Adaptor, QInputMethodEvent *>(&QAbstractItemView_Adaptor::cbs_inputMethodEvent_2354_0, event);
    } else {
      QAbstractItemView::inputMethodEvent(event);
    }
  }

  //  [adaptor impl] bool QAbstractItemView::isIndexHidden(const QModelIndex &index)
  bool cbs_isIndexHidden_c2395_0(const QModelIndex &index) const
  {
    throw qt_gsi::AbstractMethodCalledException("isIndexHidden");
  }

  virtual bool isIndexHidden(const QModelIndex &index) const
  {
    if (cb_isIndexHidden_c2395_0.can_issue()) {
      return cb_isIndexHidden_c2395_0.issue<QAbstractItemView_Adaptor, bool, const QModelIndex &>(&QAbstractItemView_Adaptor::cbs_isIndexHidden_c2395_0, index);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isIndexHidden");
    }
  }

  //  [adaptor impl] void QAbstractItemView::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QAbstractItemView::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QAbstractItemView_Adaptor, QKeyEvent *>(&QAbstractItemView_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QAbstractItemView::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractItemView::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QAbstractItemView::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QAbstractItemView_Adaptor, QKeyEvent *>(&QAbstractItemView_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QAbstractItemView::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractItemView::languageChange()
  void cbs_languageChange_0_0()
  {
    QAbstractItemView::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QAbstractItemView_Adaptor>(&QAbstractItemView_Adaptor::cbs_languageChange_0_0);
    } else {
      QAbstractItemView::languageChange();
    }
  }

  //  [adaptor impl] void QAbstractItemView::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QAbstractItemView::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QAbstractItemView_Adaptor, QEvent *>(&QAbstractItemView_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QAbstractItemView::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QAbstractItemView::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QAbstractItemView::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QAbstractItemView_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QAbstractItemView_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QAbstractItemView::metric(arg1);
    }
  }

  //  [adaptor impl] void QAbstractItemView::mouseDoubleClickEvent(QMouseEvent *event)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *event)
  {
    QAbstractItemView::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QAbstractItemView_Adaptor, QMouseEvent *>(&QAbstractItemView_Adaptor::cbs_mouseDoubleClickEvent_1738_0, event);
    } else {
      QAbstractItemView::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractItemView::mouseMoveEvent(QMouseEvent *event)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *event)
  {
    QAbstractItemView::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QMouseEvent *event)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QAbstractItemView_Adaptor, QMouseEvent *>(&QAbstractItemView_Adaptor::cbs_mouseMoveEvent_1738_0, event);
    } else {
      QAbstractItemView::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractItemView::mousePressEvent(QMouseEvent *event)
  void cbs_mousePressEvent_1738_0(QMouseEvent *event)
  {
    QAbstractItemView::mousePressEvent(event);
  }

  virtual void mousePressEvent(QMouseEvent *event)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QAbstractItemView_Adaptor, QMouseEvent *>(&QAbstractItemView_Adaptor::cbs_mousePressEvent_1738_0, event);
    } else {
      QAbstractItemView::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractItemView::mouseReleaseEvent(QMouseEvent *event)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *event)
  {
    QAbstractItemView::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QAbstractItemView_Adaptor, QMouseEvent *>(&QAbstractItemView_Adaptor::cbs_mouseReleaseEvent_1738_0, event);
    } else {
      QAbstractItemView::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] QModelIndex QAbstractItemView::moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)
  QModelIndex cbs_moveCursor_6476_0(unsigned int cursorAction, const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type & modifiers)
  {
    throw qt_gsi::AbstractMethodCalledException("moveCursor");
  }

  virtual QModelIndex moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)
  {
    if (cb_moveCursor_6476_0.can_issue()) {
      return cb_moveCursor_6476_0.issue<QAbstractItemView_Adaptor, QModelIndex, unsigned int, const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type &>(&QAbstractItemView_Adaptor::cbs_moveCursor_6476_0, (unsigned int)(cursorAction), qt_gsi::CppToQtAdaptor<QFlags<Qt::KeyboardModifier> >(modifiers));
    } else {
      throw qt_gsi::AbstractMethodCalledException("moveCursor");
    }
  }

  //  [adaptor impl] void QAbstractItemView::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QAbstractItemView::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QAbstractItemView_Adaptor, QMoveEvent *>(&QAbstractItemView_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QAbstractItemView::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractItemView::paintEvent(QPaintEvent *)
  void cbs_paintEvent_1725_0(QPaintEvent *arg1)
  {
    QAbstractItemView::paintEvent(arg1);
  }

  virtual void paintEvent(QPaintEvent *arg1)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QAbstractItemView_Adaptor, QPaintEvent *>(&QAbstractItemView_Adaptor::cbs_paintEvent_1725_0, arg1);
    } else {
      QAbstractItemView::paintEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractItemView::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QAbstractItemView::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QAbstractItemView_Adaptor, const QPalette &>(&QAbstractItemView_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QAbstractItemView::paletteChange(arg1);
    }
  }

  //  [adaptor impl] void QAbstractItemView::resizeEvent(QResizeEvent *event)
  void cbs_resizeEvent_1843_0(QResizeEvent *event)
  {
    QAbstractItemView::resizeEvent(event);
  }

  virtual void resizeEvent(QResizeEvent *event)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QAbstractItemView_Adaptor, QResizeEvent *>(&QAbstractItemView_Adaptor::cbs_resizeEvent_1843_0, event);
    } else {
      QAbstractItemView::resizeEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractItemView::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)
  void cbs_rowsAboutToBeRemoved_3713_0(const QModelIndex &parent, int start, int end)
  {
    QAbstractItemView::rowsAboutToBeRemoved(parent, start, end);
  }

  virtual void rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)
  {
    if (cb_rowsAboutToBeRemoved_3713_0.can_issue()) {
      cb_rowsAboutToBeRemoved_3713_0.issue<QAbstractItemView_Adaptor, const QModelIndex &, int, int>(&QAbstractItemView_Adaptor::cbs_rowsAboutToBeRemoved_3713_0, parent, start, end);
    } else {
      QAbstractItemView::rowsAboutToBeRemoved(parent, start, end);
    }
  }

  //  [adaptor impl] void QAbstractItemView::rowsInserted(const QModelIndex &parent, int start, int end)
  void cbs_rowsInserted_3713_0(const QModelIndex &parent, int start, int end)
  {
    QAbstractItemView::rowsInserted(parent, start, end);
  }

  virtual void rowsInserted(const QModelIndex &parent, int start, int end)
  {
    if (cb_rowsInserted_3713_0.can_issue()) {
      cb_rowsInserted_3713_0.issue<QAbstractItemView_Adaptor, const QModelIndex &, int, int>(&QAbstractItemView_Adaptor::cbs_rowsInserted_3713_0, parent, start, end);
    } else {
      QAbstractItemView::rowsInserted(parent, start, end);
    }
  }

  //  [adaptor impl] void QAbstractItemView::scrollContentsBy(int dx, int dy)
  void cbs_scrollContentsBy_1426_0(int dx, int dy)
  {
    QAbstractItemView::scrollContentsBy(dx, dy);
  }

  virtual void scrollContentsBy(int dx, int dy)
  {
    if (cb_scrollContentsBy_1426_0.can_issue()) {
      cb_scrollContentsBy_1426_0.issue<QAbstractItemView_Adaptor, int, int>(&QAbstractItemView_Adaptor::cbs_scrollContentsBy_1426_0, dx, dy);
    } else {
      QAbstractItemView::scrollContentsBy(dx, dy);
    }
  }

  //  [adaptor impl] QList<QModelIndex> QAbstractItemView::selectedIndexes()
  qt_gsi::Converter<QList<QModelIndex> >::target_type cbs_selectedIndexes_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(QAbstractItemView::selectedIndexes());
  }

  virtual QList<QModelIndex> selectedIndexes() const
  {
    if (cb_selectedIndexes_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(cb_selectedIndexes_c0_0.issue<QAbstractItemView_Adaptor, qt_gsi::Converter<QList<QModelIndex> >::target_type>(&QAbstractItemView_Adaptor::cbs_selectedIndexes_c0_0)).cref();
    } else {
      return QAbstractItemView::selectedIndexes();
    }
  }

  //  [adaptor impl] void QAbstractItemView::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)
  void cbs_selectionChanged_5346_0(const QItemSelection &selected, const QItemSelection &deselected)
  {
    QAbstractItemView::selectionChanged(selected, deselected);
  }

  virtual void selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)
  {
    if (cb_selectionChanged_5346_0.can_issue()) {
      cb_selectionChanged_5346_0.issue<QAbstractItemView_Adaptor, const QItemSelection &, const QItemSelection &>(&QAbstractItemView_Adaptor::cbs_selectionChanged_5346_0, selected, deselected);
    } else {
      QAbstractItemView::selectionChanged(selected, deselected);
    }
  }

  //  [adaptor impl] QFlags<QItemSelectionModel::SelectionFlag> QAbstractItemView::selectionCommand(const QModelIndex &index, const QEvent *event)
  qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type cbs_selectionCommand_c4199_1(const QModelIndex &index, const QEvent *event) const
  {
    return qt_gsi::CppToQtAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(QAbstractItemView::selectionCommand(index, event));
  }

  virtual QFlags<QItemSelectionModel::SelectionFlag> selectionCommand(const QModelIndex &index, const QEvent *event) const
  {
    if (cb_selectionCommand_c4199_1.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(cb_selectionCommand_c4199_1.issue<QAbstractItemView_Adaptor, qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type, const QModelIndex &, const QEvent *>(&QAbstractItemView_Adaptor::cbs_selectionCommand_c4199_1, index, event)).cref();
    } else {
      return QAbstractItemView::selectionCommand(index, event);
    }
  }

  //  [adaptor impl] void QAbstractItemView::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)
  void cbs_setSelection_6155_0(const QRect &rect, const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & command)
  {
    throw qt_gsi::AbstractMethodCalledException("setSelection");
  }

  virtual void setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)
  {
    if (cb_setSelection_6155_0.can_issue()) {
      cb_setSelection_6155_0.issue<QAbstractItemView_Adaptor, const QRect &, const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type &>(&QAbstractItemView_Adaptor::cbs_setSelection_6155_0, rect, qt_gsi::CppToQtAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(command));
    } else {
      throw qt_gsi::AbstractMethodCalledException("setSelection");
    }
  }

  //  [adaptor impl] void QAbstractItemView::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QAbstractItemView::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QAbstractItemView_Adaptor, QShowEvent *>(&QAbstractItemView_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QAbstractItemView::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractItemView::startDrag(QFlags<Qt::DropAction> supportedActions)
  void cbs_startDrag_2456_0(const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & supportedActions)
  {
    QAbstractItemView::startDrag(qt_gsi::QtToCppAdaptor<QFlags<Qt::DropAction> >(supportedActions).cref());
  }

  virtual void startDrag(QFlags<Qt::DropAction> supportedActions)
  {
    if (cb_startDrag_2456_0.can_issue()) {
      cb_startDrag_2456_0.issue<QAbstractItemView_Adaptor, const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type &>(&QAbstractItemView_Adaptor::cbs_startDrag_2456_0, qt_gsi::CppToQtAdaptor<QFlags<Qt::DropAction> >(supportedActions));
    } else {
      QAbstractItemView::startDrag(supportedActions);
    }
  }

  //  [adaptor impl] void QAbstractItemView::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QAbstractItemView::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QAbstractItemView_Adaptor, QStyle &>(&QAbstractItemView_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QAbstractItemView::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QAbstractItemView::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QAbstractItemView::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QAbstractItemView_Adaptor, QTabletEvent *>(&QAbstractItemView_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QAbstractItemView::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractItemView::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QAbstractItemView::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QAbstractItemView_Adaptor, QTimerEvent *>(&QAbstractItemView_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QAbstractItemView::timerEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractItemView::updateEditorData()
  void cbs_updateEditorData_0_0()
  {
    QAbstractItemView::updateEditorData();
  }

  virtual void updateEditorData()
  {
    if (cb_updateEditorData_0_0.can_issue()) {
      cb_updateEditorData_0_0.issue<QAbstractItemView_Adaptor>(&QAbstractItemView_Adaptor::cbs_updateEditorData_0_0);
    } else {
      QAbstractItemView::updateEditorData();
    }
  }

  //  [adaptor impl] void QAbstractItemView::updateEditorGeometries()
  void cbs_updateEditorGeometries_0_0()
  {
    QAbstractItemView::updateEditorGeometries();
  }

  virtual void updateEditorGeometries()
  {
    if (cb_updateEditorGeometries_0_0.can_issue()) {
      cb_updateEditorGeometries_0_0.issue<QAbstractItemView_Adaptor>(&QAbstractItemView_Adaptor::cbs_updateEditorGeometries_0_0);
    } else {
      QAbstractItemView::updateEditorGeometries();
    }
  }

  //  [adaptor impl] void QAbstractItemView::updateGeometries()
  void cbs_updateGeometries_0_0()
  {
    QAbstractItemView::updateGeometries();
  }

  virtual void updateGeometries()
  {
    if (cb_updateGeometries_0_0.can_issue()) {
      cb_updateGeometries_0_0.issue<QAbstractItemView_Adaptor>(&QAbstractItemView_Adaptor::cbs_updateGeometries_0_0);
    } else {
      QAbstractItemView::updateGeometries();
    }
  }

  //  [adaptor impl] int QAbstractItemView::verticalOffset()
  int cbs_verticalOffset_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("verticalOffset");
  }

  virtual int verticalOffset() const
  {
    if (cb_verticalOffset_c0_0.can_issue()) {
      return cb_verticalOffset_c0_0.issue<QAbstractItemView_Adaptor, int>(&QAbstractItemView_Adaptor::cbs_verticalOffset_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("verticalOffset");
    }
  }

  //  [adaptor impl] void QAbstractItemView::verticalScrollbarAction(int action)
  void cbs_verticalScrollbarAction_767_0(int action)
  {
    QAbstractItemView::verticalScrollbarAction(action);
  }

  virtual void verticalScrollbarAction(int action)
  {
    if (cb_verticalScrollbarAction_767_0.can_issue()) {
      cb_verticalScrollbarAction_767_0.issue<QAbstractItemView_Adaptor, int>(&QAbstractItemView_Adaptor::cbs_verticalScrollbarAction_767_0, action);
    } else {
      QAbstractItemView::verticalScrollbarAction(action);
    }
  }

  //  [adaptor impl] void QAbstractItemView::verticalScrollbarValueChanged(int value)
  void cbs_verticalScrollbarValueChanged_767_0(int value)
  {
    QAbstractItemView::verticalScrollbarValueChanged(value);
  }

  virtual void verticalScrollbarValueChanged(int value)
  {
    if (cb_verticalScrollbarValueChanged_767_0.can_issue()) {
      cb_verticalScrollbarValueChanged_767_0.issue<QAbstractItemView_Adaptor, int>(&QAbstractItemView_Adaptor::cbs_verticalScrollbarValueChanged_767_0, value);
    } else {
      QAbstractItemView::verticalScrollbarValueChanged(value);
    }
  }

  //  [adaptor impl] QStyleOptionViewItem QAbstractItemView::viewOptions()
  QStyleOptionViewItem cbs_viewOptions_c0_0() const
  {
    return QAbstractItemView::viewOptions();
  }

  virtual QStyleOptionViewItem viewOptions() const
  {
    if (cb_viewOptions_c0_0.can_issue()) {
      return cb_viewOptions_c0_0.issue<QAbstractItemView_Adaptor, QStyleOptionViewItem>(&QAbstractItemView_Adaptor::cbs_viewOptions_c0_0);
    } else {
      return QAbstractItemView::viewOptions();
    }
  }

  //  [adaptor impl] bool QAbstractItemView::viewportEvent(QEvent *event)
  bool cbs_viewportEvent_1217_0(QEvent *event)
  {
    return QAbstractItemView::viewportEvent(event);
  }

  virtual bool viewportEvent(QEvent *event)
  {
    if (cb_viewportEvent_1217_0.can_issue()) {
      return cb_viewportEvent_1217_0.issue<QAbstractItemView_Adaptor, bool, QEvent *>(&QAbstractItemView_Adaptor::cbs_viewportEvent_1217_0, event);
    } else {
      return QAbstractItemView::viewportEvent(event);
    }
  }

  //  [adaptor impl] QRegion QAbstractItemView::visualRegionForSelection(const QItemSelection &selection)
  QRegion cbs_visualRegionForSelection_c2727_0(const QItemSelection &selection) const
  {
    throw qt_gsi::AbstractMethodCalledException("visualRegionForSelection");
  }

  virtual QRegion visualRegionForSelection(const QItemSelection &selection) const
  {
    if (cb_visualRegionForSelection_c2727_0.can_issue()) {
      return cb_visualRegionForSelection_c2727_0.issue<QAbstractItemView_Adaptor, QRegion, const QItemSelection &>(&QAbstractItemView_Adaptor::cbs_visualRegionForSelection_c2727_0, selection);
    } else {
      throw qt_gsi::AbstractMethodCalledException("visualRegionForSelection");
    }
  }

  //  [adaptor impl] void QAbstractItemView::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QAbstractItemView::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QAbstractItemView_Adaptor, QWheelEvent *>(&QAbstractItemView_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QAbstractItemView::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractItemView::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QAbstractItemView::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QAbstractItemView_Adaptor, bool>(&QAbstractItemView_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QAbstractItemView::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_doItemsLayout_0_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_indexAt_c1916_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_keyboardSearch_2025_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_reset_0_0;
  gsi::Callback cb_scrollTo_5576_1;
  gsi::Callback cb_selectAll_0_0;
  gsi::Callback cb_setModel_2419_0;
  gsi::Callback cb_setRootIndex_2395_0;
  gsi::Callback cb_setSelectionModel_2533_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_sizeHintForColumn_c767_0;
  gsi::Callback cb_sizeHintForRow_c767_0;
  gsi::Callback cb_visualRect_c2395_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEditor_4926_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_commitData_1315_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_currentChanged_4682_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_dataChanged_4682_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_edit_6773_0;
  gsi::Callback cb_editorDestroyed_1302_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_horizontalOffset_c0_0;
  gsi::Callback cb_horizontalScrollbarAction_767_0;
  gsi::Callback cb_horizontalScrollbarValueChanged_767_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_isIndexHidden_c2395_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveCursor_6476_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_rowsAboutToBeRemoved_3713_0;
  gsi::Callback cb_rowsInserted_3713_0;
  gsi::Callback cb_scrollContentsBy_1426_0;
  gsi::Callback cb_selectedIndexes_c0_0;
  gsi::Callback cb_selectionChanged_5346_0;
  gsi::Callback cb_selectionCommand_c4199_1;
  gsi::Callback cb_setSelection_6155_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_startDrag_2456_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_updateEditorData_0_0;
  gsi::Callback cb_updateEditorGeometries_0_0;
  gsi::Callback cb_updateGeometries_0_0;
  gsi::Callback cb_verticalOffset_c0_0;
  gsi::Callback cb_verticalScrollbarAction_767_0;
  gsi::Callback cb_verticalScrollbarValueChanged_767_0;
  gsi::Callback cb_viewOptions_c0_0;
  gsi::Callback cb_viewportEvent_1217_0;
  gsi::Callback cb_visualRegionForSelection_c2727_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QAbstractItemView_Adaptor::~QAbstractItemView_Adaptor() { }

//  Constructor QAbstractItemView::QAbstractItemView(QWidget *parent) (adaptor class)

static void _init_ctor_QAbstractItemView_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QAbstractItemView_Adaptor *> ();
}

static void _call_ctor_QAbstractItemView_Adaptor_1315 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QAbstractItemView_Adaptor *> (new QAbstractItemView_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QAbstractItemView_Adaptor_1315 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAbstractItemView::QAbstractItemView(QWidget *parent)\nThis method creates an object of class QAbstractItemView.", &_init_ctor_QAbstractItemView_Adaptor_1315, &_call_ctor_QAbstractItemView_Adaptor_1315);
}

// void QAbstractItemView::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<WId>::target_type & > () : (const qt_gsi::Converter<WId>::target_type &)(qt_gsi::CppToQtReadAdaptor<WId>(heap, 0));
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  bool arg3 = args ? args.read<bool > () : (bool)(true);
  ((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_create_2208 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_create_2208 ()
{
  return new qt_gsi::GenericMethod("*qt_create", "@brief Method void QAbstractItemView::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
}


// void QAbstractItemView::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_destroy_1620 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_destroy_1620 ()
{
  return new qt_gsi::GenericMethod("*qt_destroy", "@brief Method void QAbstractItemView::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
}


// QPoint QAbstractItemView::dirtyRegionOffset()

static void _init_fp_dirtyRegionOffset_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_fp_dirtyRegionOffset_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPoint > ((QPoint)((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_dirtyRegionOffset_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_dirtyRegionOffset_c0 ()
{
  return new qt_gsi::GenericMethod("*dirtyRegionOffset", "@brief Method QPoint QAbstractItemView::dirtyRegionOffset()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_dirtyRegionOffset_c0, &_call_fp_dirtyRegionOffset_c0);
}


// void QAbstractItemView::doAutoScroll()

static void _init_fp_doAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_doAutoScroll_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_doAutoScroll_0 ();
}

static qt_gsi::GenericMethod*_create_fp_doAutoScroll_0 ()
{
  return new qt_gsi::GenericMethod("*doAutoScroll", "@brief Method void QAbstractItemView::doAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_doAutoScroll_0, &_call_fp_doAutoScroll_0);
}


// void QAbstractItemView::drawFrame(QPainter *)

static void _init_fp_drawFrame_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawFrame_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  ((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_drawFrame_1426 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_drawFrame_1426 ()
{
  return new qt_gsi::GenericMethod("*drawFrame", "@brief Method void QAbstractItemView::drawFrame(QPainter *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawFrame_1426, &_call_fp_drawFrame_1426);
}


// QAbstractItemView::DropIndicatorPosition QAbstractItemView::dropIndicatorPosition()

static void _init_fp_dropIndicatorPosition_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_fp_dropIndicatorPosition_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<unsigned int > ((unsigned int)((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_dropIndicatorPosition_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_dropIndicatorPosition_c0 ()
{
  return new qt_gsi::GenericMethod("*dropIndicatorPosition", "@brief Method QAbstractItemView::DropIndicatorPosition QAbstractItemView::dropIndicatorPosition()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_dropIndicatorPosition_c0, &_call_fp_dropIndicatorPosition_c0);
}


// void QAbstractItemView::executeDelayedItemsLayout()

static void _init_fp_executeDelayedItemsLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_executeDelayedItemsLayout_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_executeDelayedItemsLayout_0 ();
}

static qt_gsi::GenericMethod*_create_fp_executeDelayedItemsLayout_0 ()
{
  return new qt_gsi::GenericMethod("*executeDelayedItemsLayout", "@brief Method void QAbstractItemView::executeDelayedItemsLayout()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_executeDelayedItemsLayout_0, &_call_fp_executeDelayedItemsLayout_0);
}


// bool QAbstractItemView::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_focusNextChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusNextChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusNextChild", "@brief Method bool QAbstractItemView::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
}


// bool QAbstractItemView::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_focusPreviousChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusPreviousChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusPreviousChild", "@brief Method bool QAbstractItemView::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
}


// int QAbstractItemView::horizontalStepsPerItem()

static void _init_fp_horizontalStepsPerItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_horizontalStepsPerItem_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_horizontalStepsPerItem_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_horizontalStepsPerItem_c0 ()
{
  return new qt_gsi::GenericMethod("*horizontalStepsPerItem", "@brief Method int QAbstractItemView::horizontalStepsPerItem()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_horizontalStepsPerItem_c0, &_call_fp_horizontalStepsPerItem_c0);
}


// int QAbstractItemView::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QAbstractItemView::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QAbstractItemView::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_resetInputContext_0 ();
}

static qt_gsi::GenericMethod*_create_fp_resetInputContext_0 ()
{
  return new qt_gsi::GenericMethod("*resetInputContext", "@brief Method void QAbstractItemView::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
}


// void QAbstractItemView::scheduleDelayedItemsLayout()

static void _init_fp_scheduleDelayedItemsLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_scheduleDelayedItemsLayout_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_scheduleDelayedItemsLayout_0 ();
}

static qt_gsi::GenericMethod*_create_fp_scheduleDelayedItemsLayout_0 ()
{
  return new qt_gsi::GenericMethod("*scheduleDelayedItemsLayout", "@brief Method void QAbstractItemView::scheduleDelayedItemsLayout()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_scheduleDelayedItemsLayout_0, &_call_fp_scheduleDelayedItemsLayout_0);
}


// void QAbstractItemView::scrollDirtyRegion(int dx, int dy)

static void _init_fp_scrollDirtyRegion_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_scrollDirtyRegion_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_scrollDirtyRegion_1426 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_scrollDirtyRegion_1426 ()
{
  return new qt_gsi::GenericMethod("*scrollDirtyRegion", "@brief Method void QAbstractItemView::scrollDirtyRegion(int dx, int dy)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_scrollDirtyRegion_1426, &_call_fp_scrollDirtyRegion_1426);
}


// QObject *QAbstractItemView::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QAbstractItemView::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QAbstractItemView::setDirtyRegion(const QRegion &region)

static void _init_fp_setDirtyRegion_2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("region");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setDirtyRegion_2006 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRegion &arg1 = args.read<const QRegion & > ();
  ((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_setDirtyRegion_2006 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setDirtyRegion_2006 ()
{
  return new qt_gsi::GenericMethod("*setDirtyRegion", "@brief Method void QAbstractItemView::setDirtyRegion(const QRegion &region)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setDirtyRegion_2006, &_call_fp_setDirtyRegion_2006);
}


// void QAbstractItemView::setHorizontalStepsPerItem(int steps)

static void _init_fp_setHorizontalStepsPerItem_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("steps");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setHorizontalStepsPerItem_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_setHorizontalStepsPerItem_767 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setHorizontalStepsPerItem_767 ()
{
  return new qt_gsi::GenericMethod("*setHorizontalStepsPerItem", "@brief Method void QAbstractItemView::setHorizontalStepsPerItem(int steps)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setHorizontalStepsPerItem_767, &_call_fp_setHorizontalStepsPerItem_767);
}


// void QAbstractItemView::setState(QAbstractItemView::State state)

static void _init_fp_setState_2776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setState_2776 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  ((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_setState_2776 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setState_2776 ()
{
  return new qt_gsi::GenericMethod("*setState", "@brief Method void QAbstractItemView::setState(QAbstractItemView::State state)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setState_2776, &_call_fp_setState_2776);
}


// void QAbstractItemView::setVerticalStepsPerItem(int steps)

static void _init_fp_setVerticalStepsPerItem_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("steps");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setVerticalStepsPerItem_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_setVerticalStepsPerItem_767 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setVerticalStepsPerItem_767 ()
{
  return new qt_gsi::GenericMethod("*setVerticalStepsPerItem", "@brief Method void QAbstractItemView::setVerticalStepsPerItem(int steps)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setVerticalStepsPerItem_767, &_call_fp_setVerticalStepsPerItem_767);
}


// void QAbstractItemView::setViewportMargins(int left, int top, int right, int bottom)

static void _init_fp_setViewportMargins_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_setViewportMargins_2744 (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod*_create_fp_setViewportMargins_2744 ()
{
  return new qt_gsi::GenericMethod("*setViewportMargins", "@brief Method void QAbstractItemView::setViewportMargins(int left, int top, int right, int bottom)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2744, &_call_fp_setViewportMargins_2744);
}


// void QAbstractItemView::setViewportMargins(const QMargins &margins)

static void _init_fp_setViewportMargins_2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2115 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMargins &arg1 = args.read<const QMargins & > ();
  ((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_setViewportMargins_2115 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setViewportMargins_2115 ()
{
  return new qt_gsi::GenericMethod("*setViewportMargins", "@brief Method void QAbstractItemView::setViewportMargins(const QMargins &margins)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2115, &_call_fp_setViewportMargins_2115);
}


// void QAbstractItemView::setupViewport(QWidget *viewport)

static void _init_fp_setupViewport_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewport");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setupViewport_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_setupViewport_1315 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setupViewport_1315 ()
{
  return new qt_gsi::GenericMethod("*setupViewport", "@brief Method void QAbstractItemView::setupViewport(QWidget *viewport)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setupViewport_1315, &_call_fp_setupViewport_1315);
}


// void QAbstractItemView::startAutoScroll()

static void _init_fp_startAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_startAutoScroll_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_startAutoScroll_0 ();
}

static qt_gsi::GenericMethod*_create_fp_startAutoScroll_0 ()
{
  return new qt_gsi::GenericMethod("*startAutoScroll", "@brief Method void QAbstractItemView::startAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_startAutoScroll_0, &_call_fp_startAutoScroll_0);
}


// QAbstractItemView::State QAbstractItemView::state()

static void _init_fp_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_fp_state_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<unsigned int > ((unsigned int)((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_state_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_state_c0 ()
{
  return new qt_gsi::GenericMethod("*state", "@brief Method QAbstractItemView::State QAbstractItemView::state()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_state_c0, &_call_fp_state_c0);
}


// void QAbstractItemView::stopAutoScroll()

static void _init_fp_stopAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_stopAutoScroll_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_stopAutoScroll_0 ();
}

static qt_gsi::GenericMethod*_create_fp_stopAutoScroll_0 ()
{
  return new qt_gsi::GenericMethod("*stopAutoScroll", "@brief Method void QAbstractItemView::stopAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_stopAutoScroll_0, &_call_fp_stopAutoScroll_0);
}


// void QAbstractItemView::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_updateMicroFocus_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateMicroFocus_0 ()
{
  return new qt_gsi::GenericMethod("*updateMicroFocus", "@brief Method void QAbstractItemView::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
}


// int QAbstractItemView::verticalStepsPerItem()

static void _init_fp_verticalStepsPerItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_verticalStepsPerItem_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QAbstractItemView_Adaptor *)cls)->fp_QAbstractItemView_verticalStepsPerItem_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_verticalStepsPerItem_c0 ()
{
  return new qt_gsi::GenericMethod("*verticalStepsPerItem", "@brief Method int QAbstractItemView::verticalStepsPerItem()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_verticalStepsPerItem_c0, &_call_fp_verticalStepsPerItem_c0);
}


// void QAbstractItemView::doItemsLayout()

static void _init_cbs_doItemsLayout_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_doItemsLayout_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemView_Adaptor *)cls)->cbs_doItemsLayout_0_0 ();
}

static void _set_callback_cbs_doItemsLayout_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_doItemsLayout_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_doItemsLayout_0_0 ()
{
  return new qt_gsi::GenericMethod ("doItemsLayout", "@hide", false, &_init_cbs_doItemsLayout_0_0, &_call_cbs_doItemsLayout_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_doItemsLayout_0_0 ()
{
  return new qt_gsi::GenericMethod ("doItemsLayout", "@brief Virtual method void QAbstractItemView::doItemsLayout()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_doItemsLayout_0_0, &_call_cbs_doItemsLayout_0_0, &_set_callback_cbs_doItemsLayout_0_0);
}


// bool QAbstractItemView::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QAbstractItemView_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QAbstractItemView::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// int QAbstractItemView::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QAbstractItemView_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QAbstractItemView::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// QModelIndex QAbstractItemView::indexAt(const QPoint &point)

static void _init_cbs_indexAt_c1916_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_indexAt_c1916_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QModelIndex > ((QModelIndex)((QAbstractItemView_Adaptor *)cls)->cbs_indexAt_c1916_0 (arg1));
}

static void _set_callback_cbs_indexAt_c1916_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_indexAt_c1916_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_indexAt_c1916_0 ()
{
  return new qt_gsi::GenericMethod ("indexAt", "@hide", true, &_init_cbs_indexAt_c1916_0, &_call_cbs_indexAt_c1916_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_indexAt_c1916_0 ()
{
  return new qt_gsi::GenericMethod ("indexAt", "@brief Virtual method QModelIndex QAbstractItemView::indexAt(const QPoint &point)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_indexAt_c1916_0, &_call_cbs_indexAt_c1916_0, &_set_callback_cbs_indexAt_c1916_0);
}


// QVariant QAbstractItemView::inputMethodQuery(Qt::InputMethodQuery query)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QAbstractItemView_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QAbstractItemView::inputMethodQuery(Qt::InputMethodQuery query)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// void QAbstractItemView::keyboardSearch(const QString &search)

static void _init_cbs_keyboardSearch_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("search");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyboardSearch_2025_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_keyboardSearch_2025_0 (arg1);
}

static void _set_callback_cbs_keyboardSearch_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_keyboardSearch_2025_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyboardSearch_2025_0 ()
{
  return new qt_gsi::GenericMethod ("keyboardSearch", "@hide", false, &_init_cbs_keyboardSearch_2025_0, &_call_cbs_keyboardSearch_2025_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyboardSearch_2025_0 ()
{
  return new qt_gsi::GenericMethod ("keyboardSearch", "@brief Virtual method void QAbstractItemView::keyboardSearch(const QString &search)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyboardSearch_2025_0, &_call_cbs_keyboardSearch_2025_0, &_set_callback_cbs_keyboardSearch_2025_0);
}


// QSize QAbstractItemView::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QAbstractItemView_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QAbstractItemView::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
}


// QPaintEngine *QAbstractItemView::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QAbstractItemView_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QAbstractItemView::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
}


// void QAbstractItemView::reset()

static void _init_cbs_reset_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reset_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemView_Adaptor *)cls)->cbs_reset_0_0 ();
}

static void _set_callback_cbs_reset_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_reset_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_reset_0_0 ()
{
  return new qt_gsi::GenericMethod ("reset", "@hide", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_reset_0_0 ()
{
  return new qt_gsi::GenericMethod ("reset", "@brief Virtual method void QAbstractItemView::reset()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0, &_set_callback_cbs_reset_0_0);
}


// void QAbstractItemView::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)

static void _init_cbs_scrollTo_5576_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollTo_5576_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_scrollTo_5576_1 (arg1, arg2);
}

static void _set_callback_cbs_scrollTo_5576_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_scrollTo_5576_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_scrollTo_5576_1 ()
{
  return new qt_gsi::GenericMethod ("scrollTo", "@hide", false, &_init_cbs_scrollTo_5576_1, &_call_cbs_scrollTo_5576_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_scrollTo_5576_1 ()
{
  return new qt_gsi::GenericMethod ("scrollTo", "@brief Virtual method void QAbstractItemView::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollTo_5576_1, &_call_cbs_scrollTo_5576_1, &_set_callback_cbs_scrollTo_5576_1);
}


// void QAbstractItemView::selectAll()

static void _init_cbs_selectAll_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_selectAll_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemView_Adaptor *)cls)->cbs_selectAll_0_0 ();
}

static void _set_callback_cbs_selectAll_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_selectAll_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_selectAll_0_0 ()
{
  return new qt_gsi::GenericMethod ("selectAll", "@hide", false, &_init_cbs_selectAll_0_0, &_call_cbs_selectAll_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_selectAll_0_0 ()
{
  return new qt_gsi::GenericMethod ("selectAll", "@brief Virtual method void QAbstractItemView::selectAll()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_selectAll_0_0, &_call_cbs_selectAll_0_0, &_set_callback_cbs_selectAll_0_0);
}


// void QAbstractItemView::setModel(QAbstractItemModel *model)

static void _init_cbs_setModel_2419_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setModel_2419_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractItemModel *arg1 = args.read<QAbstractItemModel * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_setModel_2419_0 (arg1);
}

static void _set_callback_cbs_setModel_2419_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_setModel_2419_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setModel_2419_0 ()
{
  return new qt_gsi::GenericMethod ("setModel", "@hide", false, &_init_cbs_setModel_2419_0, &_call_cbs_setModel_2419_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setModel_2419_0 ()
{
  return new qt_gsi::GenericMethod ("setModel", "@brief Virtual method void QAbstractItemView::setModel(QAbstractItemModel *model)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setModel_2419_0, &_call_cbs_setModel_2419_0, &_set_callback_cbs_setModel_2419_0);
}


// void QAbstractItemView::setRootIndex(const QModelIndex &index)

static void _init_cbs_setRootIndex_2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setRootIndex_2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_setRootIndex_2395_0 (arg1);
}

static void _set_callback_cbs_setRootIndex_2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_setRootIndex_2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setRootIndex_2395_0 ()
{
  return new qt_gsi::GenericMethod ("setRootIndex", "@hide", false, &_init_cbs_setRootIndex_2395_0, &_call_cbs_setRootIndex_2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setRootIndex_2395_0 ()
{
  return new qt_gsi::GenericMethod ("setRootIndex", "@brief Virtual method void QAbstractItemView::setRootIndex(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setRootIndex_2395_0, &_call_cbs_setRootIndex_2395_0, &_set_callback_cbs_setRootIndex_2395_0);
}


// void QAbstractItemView::setSelectionModel(QItemSelectionModel *selectionModel)

static void _init_cbs_setSelectionModel_2533_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selectionModel");
  decl->add_arg<QItemSelectionModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setSelectionModel_2533_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QItemSelectionModel *arg1 = args.read<QItemSelectionModel * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_setSelectionModel_2533_0 (arg1);
}

static void _set_callback_cbs_setSelectionModel_2533_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_setSelectionModel_2533_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setSelectionModel_2533_0 ()
{
  return new qt_gsi::GenericMethod ("setSelectionModel", "@hide", false, &_init_cbs_setSelectionModel_2533_0, &_call_cbs_setSelectionModel_2533_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setSelectionModel_2533_0 ()
{
  return new qt_gsi::GenericMethod ("setSelectionModel", "@brief Virtual method void QAbstractItemView::setSelectionModel(QItemSelectionModel *selectionModel)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSelectionModel_2533_0, &_call_cbs_setSelectionModel_2533_0, &_set_callback_cbs_setSelectionModel_2533_0);
}


// void QAbstractItemView::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QAbstractItemView::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
}


// QSize QAbstractItemView::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QAbstractItemView_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QAbstractItemView::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// int QAbstractItemView::sizeHintForColumn(int column)

static void _init_cbs_sizeHintForColumn_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_sizeHintForColumn_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QAbstractItemView_Adaptor *)cls)->cbs_sizeHintForColumn_c767_0 (arg1));
}

static void _set_callback_cbs_sizeHintForColumn_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_sizeHintForColumn_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHintForColumn_c767_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHintForColumn", "@hide", true, &_init_cbs_sizeHintForColumn_c767_0, &_call_cbs_sizeHintForColumn_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHintForColumn_c767_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHintForColumn", "@brief Virtual method int QAbstractItemView::sizeHintForColumn(int column)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHintForColumn_c767_0, &_call_cbs_sizeHintForColumn_c767_0, &_set_callback_cbs_sizeHintForColumn_c767_0);
}


// int QAbstractItemView::sizeHintForRow(int row)

static void _init_cbs_sizeHintForRow_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_sizeHintForRow_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QAbstractItemView_Adaptor *)cls)->cbs_sizeHintForRow_c767_0 (arg1));
}

static void _set_callback_cbs_sizeHintForRow_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_sizeHintForRow_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHintForRow_c767_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHintForRow", "@hide", true, &_init_cbs_sizeHintForRow_c767_0, &_call_cbs_sizeHintForRow_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHintForRow_c767_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHintForRow", "@brief Virtual method int QAbstractItemView::sizeHintForRow(int row)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHintForRow_c767_0, &_call_cbs_sizeHintForRow_c767_0, &_set_callback_cbs_sizeHintForRow_c767_0);
}


// QRect QAbstractItemView::visualRect(const QModelIndex &index)

static void _init_cbs_visualRect_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_cbs_visualRect_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QRect > ((QRect)((QAbstractItemView_Adaptor *)cls)->cbs_visualRect_c2395_0 (arg1));
}

static void _set_callback_cbs_visualRect_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_visualRect_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_visualRect_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("visualRect", "@hide", true, &_init_cbs_visualRect_c2395_0, &_call_cbs_visualRect_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_visualRect_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("visualRect", "@brief Virtual method QRect QAbstractItemView::visualRect(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_visualRect_c2395_0, &_call_cbs_visualRect_c2395_0, &_set_callback_cbs_visualRect_c2395_0);
}


// void QAbstractItemView::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QActionEvent *arg1 = args.read<QActionEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QAbstractItemView::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
}


// void QAbstractItemView::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QAbstractItemView::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
}


// void QAbstractItemView::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QAbstractItemView::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QAbstractItemView::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)

static void _init_cbs_closeEditor_4926_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_closeEditor_4926_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_closeEditor_4926_0 (arg1, arg2);
}

static void _set_callback_cbs_closeEditor_4926_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_closeEditor_4926_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEditor_4926_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEditor", "@hide", false, &_init_cbs_closeEditor_4926_0, &_call_cbs_closeEditor_4926_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEditor_4926_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEditor", "@brief Virtual method void QAbstractItemView::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEditor_4926_0, &_call_cbs_closeEditor_4926_0, &_set_callback_cbs_closeEditor_4926_0);
}


// void QAbstractItemView::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCloseEvent *arg1 = args.read<QCloseEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QAbstractItemView::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
}


// void QAbstractItemView::commitData(QWidget *editor)

static void _init_cbs_commitData_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_commitData_1315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_commitData_1315_0 (arg1);
}

static void _set_callback_cbs_commitData_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_commitData_1315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_commitData_1315_0 ()
{
  return new qt_gsi::GenericMethod ("*commitData", "@hide", false, &_init_cbs_commitData_1315_0, &_call_cbs_commitData_1315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_commitData_1315_0 ()
{
  return new qt_gsi::GenericMethod ("*commitData", "@brief Virtual method void QAbstractItemView::commitData(QWidget *editor)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_commitData_1315_0, &_call_cbs_commitData_1315_0, &_set_callback_cbs_commitData_1315_0);
}


// void QAbstractItemView::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QAbstractItemView::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
}


// void QAbstractItemView::currentChanged(const QModelIndex &current, const QModelIndex &previous)

static void _init_cbs_currentChanged_4682_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("current");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("previous");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_currentChanged_4682_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_currentChanged_4682_0 (arg1, arg2);
}

static void _set_callback_cbs_currentChanged_4682_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_currentChanged_4682_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_currentChanged_4682_0 ()
{
  return new qt_gsi::GenericMethod ("*currentChanged", "@hide", false, &_init_cbs_currentChanged_4682_0, &_call_cbs_currentChanged_4682_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_currentChanged_4682_0 ()
{
  return new qt_gsi::GenericMethod ("*currentChanged", "@brief Virtual method void QAbstractItemView::currentChanged(const QModelIndex &current, const QModelIndex &previous)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_currentChanged_4682_0, &_call_cbs_currentChanged_4682_0, &_set_callback_cbs_currentChanged_4682_0);
}


// void QAbstractItemView::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QAbstractItemView::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QAbstractItemView::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)

static void _init_cbs_dataChanged_4682_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("topLeft");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("bottomRight");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_dataChanged_4682_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_dataChanged_4682_0 (arg1, arg2);
}

static void _set_callback_cbs_dataChanged_4682_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_dataChanged_4682_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dataChanged_4682_0 ()
{
  return new qt_gsi::GenericMethod ("*dataChanged", "@hide", false, &_init_cbs_dataChanged_4682_0, &_call_cbs_dataChanged_4682_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dataChanged_4682_0 ()
{
  return new qt_gsi::GenericMethod ("*dataChanged", "@brief Virtual method void QAbstractItemView::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dataChanged_4682_0, &_call_cbs_dataChanged_4682_0, &_set_callback_cbs_dataChanged_4682_0);
}


// void QAbstractItemView::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QAbstractItemView::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QAbstractItemView::dragEnterEvent(QDragEnterEvent *event)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QAbstractItemView::dragEnterEvent(QDragEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
}


// void QAbstractItemView::dragLeaveEvent(QDragLeaveEvent *event)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QAbstractItemView::dragLeaveEvent(QDragLeaveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
}


// void QAbstractItemView::dragMoveEvent(QDragMoveEvent *event)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QAbstractItemView::dragMoveEvent(QDragMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
}


// void QAbstractItemView::dropEvent(QDropEvent *event)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDropEvent *arg1 = args.read<QDropEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QAbstractItemView::dropEvent(QDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
}


// bool QAbstractItemView::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)

static void _init_cbs_edit_6773_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("trigger");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("event");
  decl->add_arg<QEvent * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_edit_6773_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & > ();
  QEvent *arg3 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QAbstractItemView_Adaptor *)cls)->cbs_edit_6773_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_edit_6773_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_edit_6773_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_edit_6773_0 ()
{
  return new qt_gsi::GenericMethod ("*edit", "@hide", false, &_init_cbs_edit_6773_0, &_call_cbs_edit_6773_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_edit_6773_0 ()
{
  return new qt_gsi::GenericMethod ("*edit", "@brief Virtual method bool QAbstractItemView::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_edit_6773_0, &_call_cbs_edit_6773_0, &_set_callback_cbs_edit_6773_0);
}


// void QAbstractItemView::editorDestroyed(QObject *editor)

static void _init_cbs_editorDestroyed_1302_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_editorDestroyed_1302_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_editorDestroyed_1302_0 (arg1);
}

static void _set_callback_cbs_editorDestroyed_1302_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_editorDestroyed_1302_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_editorDestroyed_1302_0 ()
{
  return new qt_gsi::GenericMethod ("*editorDestroyed", "@hide", false, &_init_cbs_editorDestroyed_1302_0, &_call_cbs_editorDestroyed_1302_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_editorDestroyed_1302_0 ()
{
  return new qt_gsi::GenericMethod ("*editorDestroyed", "@brief Virtual method void QAbstractItemView::editorDestroyed(QObject *editor)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_editorDestroyed_1302_0, &_call_cbs_editorDestroyed_1302_0, &_set_callback_cbs_editorDestroyed_1302_0);
}


// void QAbstractItemView::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QAbstractItemView::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
}


// void QAbstractItemView::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QAbstractItemView::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
}


// bool QAbstractItemView::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QAbstractItemView_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QAbstractItemView::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// void QAbstractItemView::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QAbstractItemView::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// bool QAbstractItemView::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<bool > ((bool)((QAbstractItemView_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QAbstractItemView::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
}


// void QAbstractItemView::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QAbstractItemView::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QAbstractItemView::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QAbstractItemView::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
}


// void QAbstractItemView::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QHideEvent *arg1 = args.read<QHideEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QAbstractItemView::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
}


// int QAbstractItemView::horizontalOffset()

static void _init_cbs_horizontalOffset_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_horizontalOffset_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QAbstractItemView_Adaptor *)cls)->cbs_horizontalOffset_c0_0 ());
}

static void _set_callback_cbs_horizontalOffset_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_horizontalOffset_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_horizontalOffset_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalOffset", "@hide", true, &_init_cbs_horizontalOffset_c0_0, &_call_cbs_horizontalOffset_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_horizontalOffset_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalOffset", "@brief Virtual method int QAbstractItemView::horizontalOffset()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_horizontalOffset_c0_0, &_call_cbs_horizontalOffset_c0_0, &_set_callback_cbs_horizontalOffset_c0_0);
}


// void QAbstractItemView::horizontalScrollbarAction(int action)

static void _init_cbs_horizontalScrollbarAction_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_horizontalScrollbarAction_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_horizontalScrollbarAction_767_0 (arg1);
}

static void _set_callback_cbs_horizontalScrollbarAction_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_horizontalScrollbarAction_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_horizontalScrollbarAction_767_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalScrollbarAction", "@hide", false, &_init_cbs_horizontalScrollbarAction_767_0, &_call_cbs_horizontalScrollbarAction_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_horizontalScrollbarAction_767_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalScrollbarAction", "@brief Virtual method void QAbstractItemView::horizontalScrollbarAction(int action)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_horizontalScrollbarAction_767_0, &_call_cbs_horizontalScrollbarAction_767_0, &_set_callback_cbs_horizontalScrollbarAction_767_0);
}


// void QAbstractItemView::horizontalScrollbarValueChanged(int value)

static void _init_cbs_horizontalScrollbarValueChanged_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_horizontalScrollbarValueChanged_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_horizontalScrollbarValueChanged_767_0 (arg1);
}

static void _set_callback_cbs_horizontalScrollbarValueChanged_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_horizontalScrollbarValueChanged_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_horizontalScrollbarValueChanged_767_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalScrollbarValueChanged", "@hide", false, &_init_cbs_horizontalScrollbarValueChanged_767_0, &_call_cbs_horizontalScrollbarValueChanged_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_horizontalScrollbarValueChanged_767_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalScrollbarValueChanged", "@brief Virtual method void QAbstractItemView::horizontalScrollbarValueChanged(int value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_horizontalScrollbarValueChanged_767_0, &_call_cbs_horizontalScrollbarValueChanged_767_0, &_set_callback_cbs_horizontalScrollbarValueChanged_767_0);
}


// void QAbstractItemView::inputMethodEvent(QInputMethodEvent *event)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QAbstractItemView::inputMethodEvent(QInputMethodEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// bool QAbstractItemView::isIndexHidden(const QModelIndex &index)

static void _init_cbs_isIndexHidden_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isIndexHidden_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QAbstractItemView_Adaptor *)cls)->cbs_isIndexHidden_c2395_0 (arg1));
}

static void _set_callback_cbs_isIndexHidden_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_isIndexHidden_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_isIndexHidden_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("*isIndexHidden", "@hide", true, &_init_cbs_isIndexHidden_c2395_0, &_call_cbs_isIndexHidden_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_isIndexHidden_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("*isIndexHidden", "@brief Virtual method bool QAbstractItemView::isIndexHidden(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isIndexHidden_c2395_0, &_call_cbs_isIndexHidden_c2395_0, &_set_callback_cbs_isIndexHidden_c2395_0);
}


// void QAbstractItemView::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QAbstractItemView::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QAbstractItemView::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QAbstractItemView::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QAbstractItemView::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemView_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QAbstractItemView::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
}


// void QAbstractItemView::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QAbstractItemView::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
}


// int QAbstractItemView::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QAbstractItemView_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QAbstractItemView::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
}


// void QAbstractItemView::mouseDoubleClickEvent(QMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QAbstractItemView::mouseDoubleClickEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
}


// void QAbstractItemView::mouseMoveEvent(QMouseEvent *event)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QAbstractItemView::mouseMoveEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
}


// void QAbstractItemView::mousePressEvent(QMouseEvent *event)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QAbstractItemView::mousePressEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
}


// void QAbstractItemView::mouseReleaseEvent(QMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QAbstractItemView::mouseReleaseEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
}


// QModelIndex QAbstractItemView::moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)

static void _init_cbs_moveCursor_6476_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursorAction");
  decl->add_arg<unsigned int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("modifiers");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type & > (argspec_1);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_moveCursor_6476_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type & > ();
  ret.write<QModelIndex > ((QModelIndex)((QAbstractItemView_Adaptor *)cls)->cbs_moveCursor_6476_0 (arg1, arg2));
}

static void _set_callback_cbs_moveCursor_6476_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_moveCursor_6476_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveCursor_6476_0 ()
{
  return new qt_gsi::GenericMethod ("*moveCursor", "@hide", false, &_init_cbs_moveCursor_6476_0, &_call_cbs_moveCursor_6476_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveCursor_6476_0 ()
{
  return new qt_gsi::GenericMethod ("*moveCursor", "@brief Virtual method QModelIndex QAbstractItemView::moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveCursor_6476_0, &_call_cbs_moveCursor_6476_0, &_set_callback_cbs_moveCursor_6476_0);
}


// void QAbstractItemView::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMoveEvent *arg1 = args.read<QMoveEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QAbstractItemView::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
}


// void QAbstractItemView::paintEvent(QPaintEvent *)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintEvent *arg1 = args.read<QPaintEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QAbstractItemView::paintEvent(QPaintEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
}


// void QAbstractItemView::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QAbstractItemView::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
}


// void QAbstractItemView::resizeEvent(QResizeEvent *event)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QResizeEvent *arg1 = args.read<QResizeEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QAbstractItemView::resizeEvent(QResizeEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
}


// void QAbstractItemView::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)

static void _init_cbs_rowsAboutToBeRemoved_3713_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_rowsAboutToBeRemoved_3713_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_rowsAboutToBeRemoved_3713_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_rowsAboutToBeRemoved_3713_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_rowsAboutToBeRemoved_3713_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_rowsAboutToBeRemoved_3713_0 ()
{
  return new qt_gsi::GenericMethod ("*rowsAboutToBeRemoved", "@hide", false, &_init_cbs_rowsAboutToBeRemoved_3713_0, &_call_cbs_rowsAboutToBeRemoved_3713_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_rowsAboutToBeRemoved_3713_0 ()
{
  return new qt_gsi::GenericMethod ("*rowsAboutToBeRemoved", "@brief Virtual method void QAbstractItemView::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_rowsAboutToBeRemoved_3713_0, &_call_cbs_rowsAboutToBeRemoved_3713_0, &_set_callback_cbs_rowsAboutToBeRemoved_3713_0);
}


// void QAbstractItemView::rowsInserted(const QModelIndex &parent, int start, int end)

static void _init_cbs_rowsInserted_3713_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_rowsInserted_3713_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_rowsInserted_3713_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_rowsInserted_3713_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_rowsInserted_3713_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_rowsInserted_3713_0 ()
{
  return new qt_gsi::GenericMethod ("*rowsInserted", "@hide", false, &_init_cbs_rowsInserted_3713_0, &_call_cbs_rowsInserted_3713_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_rowsInserted_3713_0 ()
{
  return new qt_gsi::GenericMethod ("*rowsInserted", "@brief Virtual method void QAbstractItemView::rowsInserted(const QModelIndex &parent, int start, int end)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_rowsInserted_3713_0, &_call_cbs_rowsInserted_3713_0, &_set_callback_cbs_rowsInserted_3713_0);
}


// void QAbstractItemView::scrollContentsBy(int dx, int dy)

static void _init_cbs_scrollContentsBy_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollContentsBy_1426_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_scrollContentsBy_1426_0 (arg1, arg2);
}

static void _set_callback_cbs_scrollContentsBy_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_scrollContentsBy_1426_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_scrollContentsBy_1426_0 ()
{
  return new qt_gsi::GenericMethod ("*scrollContentsBy", "@hide", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_scrollContentsBy_1426_0 ()
{
  return new qt_gsi::GenericMethod ("*scrollContentsBy", "@brief Virtual method void QAbstractItemView::scrollContentsBy(int dx, int dy)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0, &_set_callback_cbs_scrollContentsBy_1426_0);
}


// QList<QModelIndex> QAbstractItemView::selectedIndexes()

static void _init_cbs_selectedIndexes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QModelIndex> >::target_type > ();
}

static void _call_cbs_selectedIndexes_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QModelIndex> >::target_type > ((qt_gsi::Converter<QList<QModelIndex> >::target_type)((QAbstractItemView_Adaptor *)cls)->cbs_selectedIndexes_c0_0 ());
}

static void _set_callback_cbs_selectedIndexes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_selectedIndexes_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_selectedIndexes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*selectedIndexes", "@hide", true, &_init_cbs_selectedIndexes_c0_0, &_call_cbs_selectedIndexes_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_selectedIndexes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*selectedIndexes", "@brief Virtual method QList<QModelIndex> QAbstractItemView::selectedIndexes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectedIndexes_c0_0, &_call_cbs_selectedIndexes_c0_0, &_set_callback_cbs_selectedIndexes_c0_0);
}


// void QAbstractItemView::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)

static void _init_cbs_selectionChanged_5346_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selected");
  decl->add_arg<const QItemSelection & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("deselected");
  decl->add_arg<const QItemSelection & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_selectionChanged_5346_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QItemSelection &arg1 = args.read<const QItemSelection & > ();
  const QItemSelection &arg2 = args.read<const QItemSelection & > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_selectionChanged_5346_0 (arg1, arg2);
}

static void _set_callback_cbs_selectionChanged_5346_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_selectionChanged_5346_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_selectionChanged_5346_0 ()
{
  return new qt_gsi::GenericMethod ("*selectionChanged", "@hide", false, &_init_cbs_selectionChanged_5346_0, &_call_cbs_selectionChanged_5346_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_selectionChanged_5346_0 ()
{
  return new qt_gsi::GenericMethod ("*selectionChanged", "@brief Virtual method void QAbstractItemView::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_selectionChanged_5346_0, &_call_cbs_selectionChanged_5346_0, &_set_callback_cbs_selectionChanged_5346_0);
}


// QFlags<QItemSelectionModel::SelectionFlag> QAbstractItemView::selectionCommand(const QModelIndex &index, const QEvent *event)

static void _init_cbs_selectionCommand_c4199_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<const QEvent * > (argspec_1);
  decl->set_return<qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type > ();
}

static void _call_cbs_selectionCommand_c4199_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QEvent *arg2 = args.read<const QEvent * > ();
  ret.write<qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type > ((qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type)((QAbstractItemView_Adaptor *)cls)->cbs_selectionCommand_c4199_1 (arg1, arg2));
}

static void _set_callback_cbs_selectionCommand_c4199_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_selectionCommand_c4199_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_selectionCommand_c4199_1 ()
{
  return new qt_gsi::GenericMethod ("*selectionCommand", "@hide", true, &_init_cbs_selectionCommand_c4199_1, &_call_cbs_selectionCommand_c4199_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_selectionCommand_c4199_1 ()
{
  return new qt_gsi::GenericMethod ("*selectionCommand", "@brief Virtual method QFlags<QItemSelectionModel::SelectionFlag> QAbstractItemView::selectionCommand(const QModelIndex &index, const QEvent *event)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectionCommand_c4199_1, &_call_cbs_selectionCommand_c4199_1, &_set_callback_cbs_selectionCommand_c4199_1);
}


// void QAbstractItemView::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)

static void _init_cbs_setSelection_6155_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("command");
  decl->add_arg<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setSelection_6155_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_setSelection_6155_0 (arg1, arg2);
}

static void _set_callback_cbs_setSelection_6155_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_setSelection_6155_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setSelection_6155_0 ()
{
  return new qt_gsi::GenericMethod ("*setSelection", "@hide", false, &_init_cbs_setSelection_6155_0, &_call_cbs_setSelection_6155_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setSelection_6155_0 ()
{
  return new qt_gsi::GenericMethod ("*setSelection", "@brief Virtual method void QAbstractItemView::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSelection_6155_0, &_call_cbs_setSelection_6155_0, &_set_callback_cbs_setSelection_6155_0);
}


// void QAbstractItemView::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QShowEvent *arg1 = args.read<QShowEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QAbstractItemView::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
}


// void QAbstractItemView::startDrag(QFlags<Qt::DropAction> supportedActions)

static void _init_cbs_startDrag_2456_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("supportedActions");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_startDrag_2456_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_startDrag_2456_0 (arg1);
}

static void _set_callback_cbs_startDrag_2456_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_startDrag_2456_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_startDrag_2456_0 ()
{
  return new qt_gsi::GenericMethod ("*startDrag", "@hide", false, &_init_cbs_startDrag_2456_0, &_call_cbs_startDrag_2456_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_startDrag_2456_0 ()
{
  return new qt_gsi::GenericMethod ("*startDrag", "@brief Virtual method void QAbstractItemView::startDrag(QFlags<Qt::DropAction> supportedActions)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_startDrag_2456_0, &_call_cbs_startDrag_2456_0, &_set_callback_cbs_startDrag_2456_0);
}


// void QAbstractItemView::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle &arg1 = args.read<QStyle & > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QAbstractItemView::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
}


// void QAbstractItemView::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTabletEvent *arg1 = args.read<QTabletEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QAbstractItemView::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
}


// void QAbstractItemView::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QAbstractItemView::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


// void QAbstractItemView::updateEditorData()

static void _init_cbs_updateEditorData_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateEditorData_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemView_Adaptor *)cls)->cbs_updateEditorData_0_0 ();
}

static void _set_callback_cbs_updateEditorData_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_updateEditorData_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_updateEditorData_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateEditorData", "@hide", false, &_init_cbs_updateEditorData_0_0, &_call_cbs_updateEditorData_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_updateEditorData_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateEditorData", "@brief Virtual method void QAbstractItemView::updateEditorData()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateEditorData_0_0, &_call_cbs_updateEditorData_0_0, &_set_callback_cbs_updateEditorData_0_0);
}


// void QAbstractItemView::updateEditorGeometries()

static void _init_cbs_updateEditorGeometries_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateEditorGeometries_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemView_Adaptor *)cls)->cbs_updateEditorGeometries_0_0 ();
}

static void _set_callback_cbs_updateEditorGeometries_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_updateEditorGeometries_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_updateEditorGeometries_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateEditorGeometries", "@hide", false, &_init_cbs_updateEditorGeometries_0_0, &_call_cbs_updateEditorGeometries_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_updateEditorGeometries_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateEditorGeometries", "@brief Virtual method void QAbstractItemView::updateEditorGeometries()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateEditorGeometries_0_0, &_call_cbs_updateEditorGeometries_0_0, &_set_callback_cbs_updateEditorGeometries_0_0);
}


// void QAbstractItemView::updateGeometries()

static void _init_cbs_updateGeometries_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateGeometries_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemView_Adaptor *)cls)->cbs_updateGeometries_0_0 ();
}

static void _set_callback_cbs_updateGeometries_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_updateGeometries_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_updateGeometries_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateGeometries", "@hide", false, &_init_cbs_updateGeometries_0_0, &_call_cbs_updateGeometries_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_updateGeometries_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateGeometries", "@brief Virtual method void QAbstractItemView::updateGeometries()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateGeometries_0_0, &_call_cbs_updateGeometries_0_0, &_set_callback_cbs_updateGeometries_0_0);
}


// int QAbstractItemView::verticalOffset()

static void _init_cbs_verticalOffset_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_verticalOffset_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QAbstractItemView_Adaptor *)cls)->cbs_verticalOffset_c0_0 ());
}

static void _set_callback_cbs_verticalOffset_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_verticalOffset_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_verticalOffset_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalOffset", "@hide", true, &_init_cbs_verticalOffset_c0_0, &_call_cbs_verticalOffset_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_verticalOffset_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalOffset", "@brief Virtual method int QAbstractItemView::verticalOffset()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_verticalOffset_c0_0, &_call_cbs_verticalOffset_c0_0, &_set_callback_cbs_verticalOffset_c0_0);
}


// void QAbstractItemView::verticalScrollbarAction(int action)

static void _init_cbs_verticalScrollbarAction_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_verticalScrollbarAction_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_verticalScrollbarAction_767_0 (arg1);
}

static void _set_callback_cbs_verticalScrollbarAction_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_verticalScrollbarAction_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_verticalScrollbarAction_767_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalScrollbarAction", "@hide", false, &_init_cbs_verticalScrollbarAction_767_0, &_call_cbs_verticalScrollbarAction_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_verticalScrollbarAction_767_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalScrollbarAction", "@brief Virtual method void QAbstractItemView::verticalScrollbarAction(int action)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_verticalScrollbarAction_767_0, &_call_cbs_verticalScrollbarAction_767_0, &_set_callback_cbs_verticalScrollbarAction_767_0);
}


// void QAbstractItemView::verticalScrollbarValueChanged(int value)

static void _init_cbs_verticalScrollbarValueChanged_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_verticalScrollbarValueChanged_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_verticalScrollbarValueChanged_767_0 (arg1);
}

static void _set_callback_cbs_verticalScrollbarValueChanged_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_verticalScrollbarValueChanged_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_verticalScrollbarValueChanged_767_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalScrollbarValueChanged", "@hide", false, &_init_cbs_verticalScrollbarValueChanged_767_0, &_call_cbs_verticalScrollbarValueChanged_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_verticalScrollbarValueChanged_767_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalScrollbarValueChanged", "@brief Virtual method void QAbstractItemView::verticalScrollbarValueChanged(int value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_verticalScrollbarValueChanged_767_0, &_call_cbs_verticalScrollbarValueChanged_767_0, &_set_callback_cbs_verticalScrollbarValueChanged_767_0);
}


// QStyleOptionViewItem QAbstractItemView::viewOptions()

static void _init_cbs_viewOptions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStyleOptionViewItem > ();
}

static void _call_cbs_viewOptions_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QStyleOptionViewItem > ((QStyleOptionViewItem)((QAbstractItemView_Adaptor *)cls)->cbs_viewOptions_c0_0 ());
}

static void _set_callback_cbs_viewOptions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_viewOptions_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_viewOptions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*viewOptions", "@hide", true, &_init_cbs_viewOptions_c0_0, &_call_cbs_viewOptions_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_viewOptions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*viewOptions", "@brief Virtual method QStyleOptionViewItem QAbstractItemView::viewOptions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_viewOptions_c0_0, &_call_cbs_viewOptions_c0_0, &_set_callback_cbs_viewOptions_c0_0);
}


// bool QAbstractItemView::viewportEvent(QEvent *event)

static void _init_cbs_viewportEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_viewportEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QAbstractItemView_Adaptor *)cls)->cbs_viewportEvent_1217_0 (arg1));
}

static void _set_callback_cbs_viewportEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_viewportEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_viewportEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*viewportEvent", "@hide", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_viewportEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*viewportEvent", "@brief Virtual method bool QAbstractItemView::viewportEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0, &_set_callback_cbs_viewportEvent_1217_0);
}


// QRegion QAbstractItemView::visualRegionForSelection(const QItemSelection &selection)

static void _init_cbs_visualRegionForSelection_c2727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  decl->set_return<QRegion > ();
}

static void _call_cbs_visualRegionForSelection_c2727_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QItemSelection &arg1 = args.read<const QItemSelection & > ();
  ret.write<QRegion > ((QRegion)((QAbstractItemView_Adaptor *)cls)->cbs_visualRegionForSelection_c2727_0 (arg1));
}

static void _set_callback_cbs_visualRegionForSelection_c2727_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_visualRegionForSelection_c2727_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_visualRegionForSelection_c2727_0 ()
{
  return new qt_gsi::GenericMethod ("*visualRegionForSelection", "@hide", true, &_init_cbs_visualRegionForSelection_c2727_0, &_call_cbs_visualRegionForSelection_c2727_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_visualRegionForSelection_c2727_0 ()
{
  return new qt_gsi::GenericMethod ("*visualRegionForSelection", "@brief Virtual method QRegion QAbstractItemView::visualRegionForSelection(const QItemSelection &selection)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_visualRegionForSelection_c2727_0, &_call_cbs_visualRegionForSelection_c2727_0, &_set_callback_cbs_visualRegionForSelection_c2727_0);
}


// void QAbstractItemView::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWheelEvent *arg1 = args.read<QWheelEvent * > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QAbstractItemView::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
}


// void QAbstractItemView::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QAbstractItemView_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemView_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QAbstractItemView::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
}


namespace gsi
{

extern gsi::Class<QAbstractItemView> decl_QAbstractItemView;

gsi::Class<QAbstractItemView_Adaptor> decl_QAbstractItemView_Adaptor (decl_QAbstractItemView, "QAbstractItemView",
  gsi::Methods(_create_fp_create_2208 ()) +
  gsi::Methods(_create_fp_destroy_1620 ()) +
  gsi::Methods(_create_fp_dirtyRegionOffset_c0 ()) +
  gsi::Methods(_create_fp_doAutoScroll_0 ()) +
  gsi::Methods(_create_fp_drawFrame_1426 ()) +
  gsi::Methods(_create_fp_dropIndicatorPosition_c0 ()) +
  gsi::Methods(_create_fp_executeDelayedItemsLayout_0 ()) +
  gsi::Methods(_create_fp_focusNextChild_0 ()) +
  gsi::Methods(_create_fp_focusPreviousChild_0 ()) +
  gsi::Methods(_create_fp_horizontalStepsPerItem_c0 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_resetInputContext_0 ()) +
  gsi::Methods(_create_fp_scheduleDelayedItemsLayout_0 ()) +
  gsi::Methods(_create_fp_scrollDirtyRegion_1426 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_setDirtyRegion_2006 ()) +
  gsi::Methods(_create_fp_setHorizontalStepsPerItem_767 ()) +
  gsi::Methods(_create_fp_setState_2776 ()) +
  gsi::Methods(_create_fp_setVerticalStepsPerItem_767 ()) +
  gsi::Methods(_create_fp_setViewportMargins_2744 ()) +
  gsi::Methods(_create_fp_setViewportMargins_2115 ()) +
  gsi::Methods(_create_fp_setupViewport_1315 ()) +
  gsi::Methods(_create_fp_startAutoScroll_0 ()) +
  gsi::Methods(_create_fp_state_c0 ()) +
  gsi::Methods(_create_fp_stopAutoScroll_0 ()) +
  gsi::Methods(_create_fp_updateMicroFocus_0 ()) +
  gsi::Methods(_create_fp_verticalStepsPerItem_c0 ()) +
  gsi::Methods(_create_cbs_doItemsLayout_0_0 ()) +
  gsi::Methods(_create_callback_cbs_doItemsLayout_0_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_indexAt_c1916_0 ()) +
  gsi::Methods(_create_callback_cbs_indexAt_c1916_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_keyboardSearch_2025_0 ()) +
  gsi::Methods(_create_callback_cbs_keyboardSearch_2025_0 ()) +
  gsi::Methods(_create_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_cbs_reset_0_0 ()) +
  gsi::Methods(_create_callback_cbs_reset_0_0 ()) +
  gsi::Methods(_create_cbs_scrollTo_5576_1 ()) +
  gsi::Methods(_create_callback_cbs_scrollTo_5576_1 ()) +
  gsi::Methods(_create_cbs_selectAll_0_0 ()) +
  gsi::Methods(_create_callback_cbs_selectAll_0_0 ()) +
  gsi::Methods(_create_cbs_setModel_2419_0 ()) +
  gsi::Methods(_create_callback_cbs_setModel_2419_0 ()) +
  gsi::Methods(_create_cbs_setRootIndex_2395_0 ()) +
  gsi::Methods(_create_callback_cbs_setRootIndex_2395_0 ()) +
  gsi::Methods(_create_cbs_setSelectionModel_2533_0 ()) +
  gsi::Methods(_create_callback_cbs_setSelectionModel_2533_0 ()) +
  gsi::Methods(_create_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_sizeHintForColumn_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHintForColumn_c767_0 ()) +
  gsi::Methods(_create_cbs_sizeHintForRow_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHintForRow_c767_0 ()) +
  gsi::Methods(_create_cbs_visualRect_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_visualRect_c2395_0 ()) +
  gsi::Methods(_create_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_callback_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_closeEditor_4926_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEditor_4926_0 ()) +
  gsi::Methods(_create_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_cbs_commitData_1315_0 ()) +
  gsi::Methods(_create_callback_cbs_commitData_1315_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_cbs_currentChanged_4682_0 ()) +
  gsi::Methods(_create_callback_cbs_currentChanged_4682_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_dataChanged_4682_0 ()) +
  gsi::Methods(_create_callback_cbs_dataChanged_4682_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_cbs_edit_6773_0 ()) +
  gsi::Methods(_create_callback_cbs_edit_6773_0 ()) +
  gsi::Methods(_create_cbs_editorDestroyed_1302_0 ()) +
  gsi::Methods(_create_callback_cbs_editorDestroyed_1302_0 ()) +
  gsi::Methods(_create_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_callback_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_callback_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_callback_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_cbs_horizontalOffset_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_horizontalOffset_c0_0 ()) +
  gsi::Methods(_create_cbs_horizontalScrollbarAction_767_0 ()) +
  gsi::Methods(_create_callback_cbs_horizontalScrollbarAction_767_0 ()) +
  gsi::Methods(_create_cbs_horizontalScrollbarValueChanged_767_0 ()) +
  gsi::Methods(_create_callback_cbs_horizontalScrollbarValueChanged_767_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_isIndexHidden_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_isIndexHidden_c2395_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_callback_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_callback_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_moveCursor_6476_0 ()) +
  gsi::Methods(_create_callback_cbs_moveCursor_6476_0 ()) +
  gsi::Methods(_create_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_callback_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_callback_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_cbs_rowsAboutToBeRemoved_3713_0 ()) +
  gsi::Methods(_create_callback_cbs_rowsAboutToBeRemoved_3713_0 ()) +
  gsi::Methods(_create_cbs_rowsInserted_3713_0 ()) +
  gsi::Methods(_create_callback_cbs_rowsInserted_3713_0 ()) +
  gsi::Methods(_create_cbs_scrollContentsBy_1426_0 ()) +
  gsi::Methods(_create_callback_cbs_scrollContentsBy_1426_0 ()) +
  gsi::Methods(_create_cbs_selectedIndexes_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_selectedIndexes_c0_0 ()) +
  gsi::Methods(_create_cbs_selectionChanged_5346_0 ()) +
  gsi::Methods(_create_callback_cbs_selectionChanged_5346_0 ()) +
  gsi::Methods(_create_cbs_selectionCommand_c4199_1 ()) +
  gsi::Methods(_create_callback_cbs_selectionCommand_c4199_1 ()) +
  gsi::Methods(_create_cbs_setSelection_6155_0 ()) +
  gsi::Methods(_create_callback_cbs_setSelection_6155_0 ()) +
  gsi::Methods(_create_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_callback_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_cbs_startDrag_2456_0 ()) +
  gsi::Methods(_create_callback_cbs_startDrag_2456_0 ()) +
  gsi::Methods(_create_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_callback_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_callback_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_cbs_updateEditorData_0_0 ()) +
  gsi::Methods(_create_callback_cbs_updateEditorData_0_0 ()) +
  gsi::Methods(_create_cbs_updateEditorGeometries_0_0 ()) +
  gsi::Methods(_create_callback_cbs_updateEditorGeometries_0_0 ()) +
  gsi::Methods(_create_cbs_updateGeometries_0_0 ()) +
  gsi::Methods(_create_callback_cbs_updateGeometries_0_0 ()) +
  gsi::Methods(_create_cbs_verticalOffset_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_verticalOffset_c0_0 ()) +
  gsi::Methods(_create_cbs_verticalScrollbarAction_767_0 ()) +
  gsi::Methods(_create_callback_cbs_verticalScrollbarAction_767_0 ()) +
  gsi::Methods(_create_cbs_verticalScrollbarValueChanged_767_0 ()) +
  gsi::Methods(_create_callback_cbs_verticalScrollbarValueChanged_767_0 ()) +
  gsi::Methods(_create_cbs_viewOptions_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_viewOptions_c0_0 ()) +
  gsi::Methods(_create_cbs_viewportEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_viewportEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_visualRegionForSelection_c2727_0 ()) +
  gsi::Methods(_create_callback_cbs_visualRegionForSelection_c2727_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_ctor_QAbstractItemView_Adaptor_1315 ()),
  "@qt\n@brief Binding of QAbstractItemView");

}


//  Implementation of the enum wrapper class for QAbstractItemView::DragDropMode
namespace qt_gsi
{

static QAbstractItemView_DragDropMode_Enum *c_1_QAbstractItemView_DragDropMode_Enum () { return new QAbstractItemView_DragDropMode_Enum (QAbstractItemView::NoDragDrop); }
static QAbstractItemView_DragDropMode_Enum *c_2_QAbstractItemView_DragDropMode_Enum () { return new QAbstractItemView_DragDropMode_Enum (QAbstractItemView::DragOnly); }
static QAbstractItemView_DragDropMode_Enum *c_3_QAbstractItemView_DragDropMode_Enum () { return new QAbstractItemView_DragDropMode_Enum (QAbstractItemView::DropOnly); }
static QAbstractItemView_DragDropMode_Enum *c_4_QAbstractItemView_DragDropMode_Enum () { return new QAbstractItemView_DragDropMode_Enum (QAbstractItemView::DragDrop); }
static QAbstractItemView_DragDropMode_Enum *c_5_QAbstractItemView_DragDropMode_Enum () { return new QAbstractItemView_DragDropMode_Enum (QAbstractItemView::InternalMove); }

static gsi::Methods mkdefs_QAbstractItemView_DragDropMode () {
  return
    gsi::constant ("NoDragDrop", &qt_gsi::c_1_QAbstractItemView_DragDropMode_Enum, "@brief Enum constant QAbstractItemView::NoDragDrop") +
    gsi::constant ("DragOnly", &qt_gsi::c_2_QAbstractItemView_DragDropMode_Enum, "@brief Enum constant QAbstractItemView::DragOnly") +
    gsi::constant ("DropOnly", &qt_gsi::c_3_QAbstractItemView_DragDropMode_Enum, "@brief Enum constant QAbstractItemView::DropOnly") +
    gsi::constant ("DragDrop", &qt_gsi::c_4_QAbstractItemView_DragDropMode_Enum, "@brief Enum constant QAbstractItemView::DragDrop") +
    gsi::constant ("InternalMove", &qt_gsi::c_5_QAbstractItemView_DragDropMode_Enum, "@brief Enum constant QAbstractItemView::InternalMove");
}

static std::string to_s_QAbstractItemView_DragDropMode_Enum (const QAbstractItemView_DragDropMode_Enum *e)
{
  if (e->value () == QAbstractItemView::NoDragDrop) { return tl::sprintf ("NoDragDrop (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractItemView::DragOnly) { return tl::sprintf ("DragOnly (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractItemView::DropOnly) { return tl::sprintf ("DropOnly (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractItemView::DragDrop) { return tl::sprintf ("DragDrop (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractItemView::InternalMove) { return tl::sprintf ("InternalMove (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QAbstractItemView_DragDropMode_Enum (const QAbstractItemView_DragDropMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QAbstractItemView_DragDropMode_Enum *from_i_QAbstractItemView_DragDropMode_Enum (unsigned int i)
{
  return new QAbstractItemView_DragDropMode_Enum ((QAbstractItemView::DragDropMode) i);
}

static bool equalQAbstractItemView_DragDropMode_Enum (const QAbstractItemView_DragDropMode_Enum *e, QAbstractItemView_DragDropMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QAbstractItemView_DragDropMode_Enum (const QAbstractItemView_DragDropMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QAbstractItemView_DragDropMode_Enums oropQAbstractItemView_DragDropMode_Enums (const QAbstractItemView_DragDropMode_Enums *e, const QAbstractItemView_DragDropMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QAbstractItemView_DragDropMode_Enums andopQAbstractItemView_DragDropMode_Enums (const QAbstractItemView_DragDropMode_Enums *e, const QAbstractItemView_DragDropMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QAbstractItemView_DragDropMode_Enums xoropQAbstractItemView_DragDropMode_Enums (const QAbstractItemView_DragDropMode_Enums *e, const QAbstractItemView_DragDropMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QAbstractItemView_DragDropMode_Enums (const QAbstractItemView_DragDropMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QAbstractItemView::NoDragDrop)) { if (!l.empty ()) l += "|"; l += "NoDragDrop"; }
  if (e->testFlag (QAbstractItemView::DragOnly)) { if (!l.empty ()) l += "|"; l += "DragOnly"; }
  if (e->testFlag (QAbstractItemView::DropOnly)) { if (!l.empty ()) l += "|"; l += "DropOnly"; }
  if (e->testFlag (QAbstractItemView::DragDrop)) { if (!l.empty ()) l += "|"; l += "DragDrop"; }
  if (e->testFlag (QAbstractItemView::InternalMove)) { if (!l.empty ()) l += "|"; l += "InternalMove"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QAbstractItemView_DragDropMode_Enums (const QAbstractItemView_DragDropMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QAbstractItemView_DragDropMode_Enums (const QAbstractItemView_DragDropMode_Enums *e, const QAbstractItemView_DragDropMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QAbstractItemView_DragDropMode_Enums> decl_QAbstractItemView_DragDropMode_Enums ("QAbstractItemView_QFlags_DragDropMode",
  gsi::method_ext ("|", &qt_gsi::oropQAbstractItemView_DragDropMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQAbstractItemView_DragDropMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQAbstractItemView_DragDropMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAbstractItemView_DragDropMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAbstractItemView_DragDropMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QAbstractItemView_DragDropMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QAbstractItemView::DragDropMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QAbstractItemView_DragDropMode_Enum> decl_QAbstractItemView_DragDropMode_Enum (decl_QAbstractItemView_DragDropMode_Enums, "QAbstractItemView_DragDropMode",
  qt_gsi::mkdefs_QAbstractItemView_DragDropMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAbstractItemView_DragDropMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAbstractItemView_DragDropMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQAbstractItemView_DragDropMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QAbstractItemView_DragDropMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QAbstractItemView_DragDropMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QAbstractItemView::DragDropMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractItemView> inject_QAbstractItemView_DragDropMode_Enum_in_parent (qt_gsi::mkdefs_QAbstractItemView_DragDropMode ());
static gsi::ClassExt<QAbstractItemView> decl_QAbstractItemView_DragDropMode_Enum_as_child (decl_QAbstractItemView_DragDropMode_Enum, "DragDropMode");

}


//  Implementation of the enum wrapper class for QAbstractItemView::EditTrigger
namespace qt_gsi
{

static QAbstractItemView_EditTrigger_Enum *c_1_QAbstractItemView_EditTrigger_Enum () { return new QAbstractItemView_EditTrigger_Enum (QAbstractItemView::NoEditTriggers); }
static QAbstractItemView_EditTrigger_Enum *c_2_QAbstractItemView_EditTrigger_Enum () { return new QAbstractItemView_EditTrigger_Enum (QAbstractItemView::CurrentChanged); }
static QAbstractItemView_EditTrigger_Enum *c_3_QAbstractItemView_EditTrigger_Enum () { return new QAbstractItemView_EditTrigger_Enum (QAbstractItemView::DoubleClicked); }
static QAbstractItemView_EditTrigger_Enum *c_4_QAbstractItemView_EditTrigger_Enum () { return new QAbstractItemView_EditTrigger_Enum (QAbstractItemView::SelectedClicked); }
static QAbstractItemView_EditTrigger_Enum *c_5_QAbstractItemView_EditTrigger_Enum () { return new QAbstractItemView_EditTrigger_Enum (QAbstractItemView::EditKeyPressed); }
static QAbstractItemView_EditTrigger_Enum *c_6_QAbstractItemView_EditTrigger_Enum () { return new QAbstractItemView_EditTrigger_Enum (QAbstractItemView::AnyKeyPressed); }
static QAbstractItemView_EditTrigger_Enum *c_7_QAbstractItemView_EditTrigger_Enum () { return new QAbstractItemView_EditTrigger_Enum (QAbstractItemView::AllEditTriggers); }

static gsi::Methods mkdefs_QAbstractItemView_EditTrigger () {
  return
    gsi::constant ("NoEditTriggers", &qt_gsi::c_1_QAbstractItemView_EditTrigger_Enum, "@brief Enum constant QAbstractItemView::NoEditTriggers") +
    gsi::constant ("CurrentChanged", &qt_gsi::c_2_QAbstractItemView_EditTrigger_Enum, "@brief Enum constant QAbstractItemView::CurrentChanged") +
    gsi::constant ("DoubleClicked", &qt_gsi::c_3_QAbstractItemView_EditTrigger_Enum, "@brief Enum constant QAbstractItemView::DoubleClicked") +
    gsi::constant ("SelectedClicked", &qt_gsi::c_4_QAbstractItemView_EditTrigger_Enum, "@brief Enum constant QAbstractItemView::SelectedClicked") +
    gsi::constant ("EditKeyPressed", &qt_gsi::c_5_QAbstractItemView_EditTrigger_Enum, "@brief Enum constant QAbstractItemView::EditKeyPressed") +
    gsi::constant ("AnyKeyPressed", &qt_gsi::c_6_QAbstractItemView_EditTrigger_Enum, "@brief Enum constant QAbstractItemView::AnyKeyPressed") +
    gsi::constant ("AllEditTriggers", &qt_gsi::c_7_QAbstractItemView_EditTrigger_Enum, "@brief Enum constant QAbstractItemView::AllEditTriggers");
}

static std::string to_s_QAbstractItemView_EditTrigger_Enum (const QAbstractItemView_EditTrigger_Enum *e)
{
  if (e->value () == QAbstractItemView::NoEditTriggers) { return tl::sprintf ("NoEditTriggers (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractItemView::CurrentChanged) { return tl::sprintf ("CurrentChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractItemView::DoubleClicked) { return tl::sprintf ("DoubleClicked (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractItemView::SelectedClicked) { return tl::sprintf ("SelectedClicked (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractItemView::EditKeyPressed) { return tl::sprintf ("EditKeyPressed (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractItemView::AnyKeyPressed) { return tl::sprintf ("AnyKeyPressed (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractItemView::AllEditTriggers) { return tl::sprintf ("AllEditTriggers (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QAbstractItemView_EditTrigger_Enum (const QAbstractItemView_EditTrigger_Enum *e)
{
  return (unsigned int) e->value ();
}

static QAbstractItemView_EditTrigger_Enum *from_i_QAbstractItemView_EditTrigger_Enum (unsigned int i)
{
  return new QAbstractItemView_EditTrigger_Enum ((QAbstractItemView::EditTrigger) i);
}

static bool equalQAbstractItemView_EditTrigger_Enum (const QAbstractItemView_EditTrigger_Enum *e, QAbstractItemView_EditTrigger_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QAbstractItemView_EditTrigger_Enum (const QAbstractItemView_EditTrigger_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QAbstractItemView_EditTrigger_Enums oropQAbstractItemView_EditTrigger_Enums (const QAbstractItemView_EditTrigger_Enums *e, const QAbstractItemView_EditTrigger_Enums &d)
{
  return e->flags () | d.flags ();
}

static QAbstractItemView_EditTrigger_Enums andopQAbstractItemView_EditTrigger_Enums (const QAbstractItemView_EditTrigger_Enums *e, const QAbstractItemView_EditTrigger_Enums &d)
{
  return e->flags () & d.flags ();
}

static QAbstractItemView_EditTrigger_Enums xoropQAbstractItemView_EditTrigger_Enums (const QAbstractItemView_EditTrigger_Enums *e, const QAbstractItemView_EditTrigger_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QAbstractItemView_EditTrigger_Enums (const QAbstractItemView_EditTrigger_Enums *e)
{
  std::string l;
  if (e->testFlag (QAbstractItemView::NoEditTriggers)) { if (!l.empty ()) l += "|"; l += "NoEditTriggers"; }
  if (e->testFlag (QAbstractItemView::CurrentChanged)) { if (!l.empty ()) l += "|"; l += "CurrentChanged"; }
  if (e->testFlag (QAbstractItemView::DoubleClicked)) { if (!l.empty ()) l += "|"; l += "DoubleClicked"; }
  if (e->testFlag (QAbstractItemView::SelectedClicked)) { if (!l.empty ()) l += "|"; l += "SelectedClicked"; }
  if (e->testFlag (QAbstractItemView::EditKeyPressed)) { if (!l.empty ()) l += "|"; l += "EditKeyPressed"; }
  if (e->testFlag (QAbstractItemView::AnyKeyPressed)) { if (!l.empty ()) l += "|"; l += "AnyKeyPressed"; }
  if (e->testFlag (QAbstractItemView::AllEditTriggers)) { if (!l.empty ()) l += "|"; l += "AllEditTriggers"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QAbstractItemView_EditTrigger_Enums (const QAbstractItemView_EditTrigger_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QAbstractItemView_EditTrigger_Enums (const QAbstractItemView_EditTrigger_Enums *e, const QAbstractItemView_EditTrigger_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QAbstractItemView_EditTrigger_Enums> decl_QAbstractItemView_EditTrigger_Enums ("QAbstractItemView_QFlags_EditTrigger",
  gsi::method_ext ("|", &qt_gsi::oropQAbstractItemView_EditTrigger_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQAbstractItemView_EditTrigger_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQAbstractItemView_EditTrigger_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAbstractItemView_EditTrigger_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAbstractItemView_EditTrigger_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QAbstractItemView_EditTrigger_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QAbstractItemView::EditTrigger> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QAbstractItemView_EditTrigger_Enum> decl_QAbstractItemView_EditTrigger_Enum (decl_QAbstractItemView_EditTrigger_Enums, "QAbstractItemView_EditTrigger",
  qt_gsi::mkdefs_QAbstractItemView_EditTrigger () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAbstractItemView_EditTrigger_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAbstractItemView_EditTrigger_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQAbstractItemView_EditTrigger_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QAbstractItemView_EditTrigger_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QAbstractItemView_EditTrigger_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QAbstractItemView::EditTrigger enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractItemView> inject_QAbstractItemView_EditTrigger_Enum_in_parent (qt_gsi::mkdefs_QAbstractItemView_EditTrigger ());
static gsi::ClassExt<QAbstractItemView> decl_QAbstractItemView_EditTrigger_Enum_as_child (decl_QAbstractItemView_EditTrigger_Enum, "EditTrigger");

}


//  Implementation of the enum wrapper class for QAbstractItemView::ScrollHint
namespace qt_gsi
{

static QAbstractItemView_ScrollHint_Enum *c_1_QAbstractItemView_ScrollHint_Enum () { return new QAbstractItemView_ScrollHint_Enum (QAbstractItemView::EnsureVisible); }
static QAbstractItemView_ScrollHint_Enum *c_2_QAbstractItemView_ScrollHint_Enum () { return new QAbstractItemView_ScrollHint_Enum (QAbstractItemView::PositionAtTop); }
static QAbstractItemView_ScrollHint_Enum *c_3_QAbstractItemView_ScrollHint_Enum () { return new QAbstractItemView_ScrollHint_Enum (QAbstractItemView::PositionAtBottom); }
static QAbstractItemView_ScrollHint_Enum *c_4_QAbstractItemView_ScrollHint_Enum () { return new QAbstractItemView_ScrollHint_Enum (QAbstractItemView::PositionAtCenter); }

static gsi::Methods mkdefs_QAbstractItemView_ScrollHint () {
  return
    gsi::constant ("EnsureVisible", &qt_gsi::c_1_QAbstractItemView_ScrollHint_Enum, "@brief Enum constant QAbstractItemView::EnsureVisible") +
    gsi::constant ("PositionAtTop", &qt_gsi::c_2_QAbstractItemView_ScrollHint_Enum, "@brief Enum constant QAbstractItemView::PositionAtTop") +
    gsi::constant ("PositionAtBottom", &qt_gsi::c_3_QAbstractItemView_ScrollHint_Enum, "@brief Enum constant QAbstractItemView::PositionAtBottom") +
    gsi::constant ("PositionAtCenter", &qt_gsi::c_4_QAbstractItemView_ScrollHint_Enum, "@brief Enum constant QAbstractItemView::PositionAtCenter");
}

static std::string to_s_QAbstractItemView_ScrollHint_Enum (const QAbstractItemView_ScrollHint_Enum *e)
{
  if (e->value () == QAbstractItemView::EnsureVisible) { return tl::sprintf ("EnsureVisible (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractItemView::PositionAtTop) { return tl::sprintf ("PositionAtTop (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractItemView::PositionAtBottom) { return tl::sprintf ("PositionAtBottom (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractItemView::PositionAtCenter) { return tl::sprintf ("PositionAtCenter (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QAbstractItemView_ScrollHint_Enum (const QAbstractItemView_ScrollHint_Enum *e)
{
  return (unsigned int) e->value ();
}

static QAbstractItemView_ScrollHint_Enum *from_i_QAbstractItemView_ScrollHint_Enum (unsigned int i)
{
  return new QAbstractItemView_ScrollHint_Enum ((QAbstractItemView::ScrollHint) i);
}

static bool equalQAbstractItemView_ScrollHint_Enum (const QAbstractItemView_ScrollHint_Enum *e, QAbstractItemView_ScrollHint_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QAbstractItemView_ScrollHint_Enum (const QAbstractItemView_ScrollHint_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QAbstractItemView_ScrollHint_Enums oropQAbstractItemView_ScrollHint_Enums (const QAbstractItemView_ScrollHint_Enums *e, const QAbstractItemView_ScrollHint_Enums &d)
{
  return e->flags () | d.flags ();
}

static QAbstractItemView_ScrollHint_Enums andopQAbstractItemView_ScrollHint_Enums (const QAbstractItemView_ScrollHint_Enums *e, const QAbstractItemView_ScrollHint_Enums &d)
{
  return e->flags () & d.flags ();
}

static QAbstractItemView_ScrollHint_Enums xoropQAbstractItemView_ScrollHint_Enums (const QAbstractItemView_ScrollHint_Enums *e, const QAbstractItemView_ScrollHint_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QAbstractItemView_ScrollHint_Enums (const QAbstractItemView_ScrollHint_Enums *e)
{
  std::string l;
  if (e->testFlag (QAbstractItemView::EnsureVisible)) { if (!l.empty ()) l += "|"; l += "EnsureVisible"; }
  if (e->testFlag (QAbstractItemView::PositionAtTop)) { if (!l.empty ()) l += "|"; l += "PositionAtTop"; }
  if (e->testFlag (QAbstractItemView::PositionAtBottom)) { if (!l.empty ()) l += "|"; l += "PositionAtBottom"; }
  if (e->testFlag (QAbstractItemView::PositionAtCenter)) { if (!l.empty ()) l += "|"; l += "PositionAtCenter"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QAbstractItemView_ScrollHint_Enums (const QAbstractItemView_ScrollHint_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QAbstractItemView_ScrollHint_Enums (const QAbstractItemView_ScrollHint_Enums *e, const QAbstractItemView_ScrollHint_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QAbstractItemView_ScrollHint_Enums> decl_QAbstractItemView_ScrollHint_Enums ("QAbstractItemView_QFlags_ScrollHint",
  gsi::method_ext ("|", &qt_gsi::oropQAbstractItemView_ScrollHint_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQAbstractItemView_ScrollHint_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQAbstractItemView_ScrollHint_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAbstractItemView_ScrollHint_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAbstractItemView_ScrollHint_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QAbstractItemView_ScrollHint_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QAbstractItemView::ScrollHint> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QAbstractItemView_ScrollHint_Enum> decl_QAbstractItemView_ScrollHint_Enum (decl_QAbstractItemView_ScrollHint_Enums, "QAbstractItemView_ScrollHint",
  qt_gsi::mkdefs_QAbstractItemView_ScrollHint () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAbstractItemView_ScrollHint_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAbstractItemView_ScrollHint_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQAbstractItemView_ScrollHint_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QAbstractItemView_ScrollHint_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QAbstractItemView_ScrollHint_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QAbstractItemView::ScrollHint enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractItemView> inject_QAbstractItemView_ScrollHint_Enum_in_parent (qt_gsi::mkdefs_QAbstractItemView_ScrollHint ());
static gsi::ClassExt<QAbstractItemView> decl_QAbstractItemView_ScrollHint_Enum_as_child (decl_QAbstractItemView_ScrollHint_Enum, "ScrollHint");

}


//  Implementation of the enum wrapper class for QAbstractItemView::ScrollMode
namespace qt_gsi
{

static QAbstractItemView_ScrollMode_Enum *c_1_QAbstractItemView_ScrollMode_Enum () { return new QAbstractItemView_ScrollMode_Enum (QAbstractItemView::ScrollPerItem); }
static QAbstractItemView_ScrollMode_Enum *c_2_QAbstractItemView_ScrollMode_Enum () { return new QAbstractItemView_ScrollMode_Enum (QAbstractItemView::ScrollPerPixel); }

static gsi::Methods mkdefs_QAbstractItemView_ScrollMode () {
  return
    gsi::constant ("ScrollPerItem", &qt_gsi::c_1_QAbstractItemView_ScrollMode_Enum, "@brief Enum constant QAbstractItemView::ScrollPerItem") +
    gsi::constant ("ScrollPerPixel", &qt_gsi::c_2_QAbstractItemView_ScrollMode_Enum, "@brief Enum constant QAbstractItemView::ScrollPerPixel");
}

static std::string to_s_QAbstractItemView_ScrollMode_Enum (const QAbstractItemView_ScrollMode_Enum *e)
{
  if (e->value () == QAbstractItemView::ScrollPerItem) { return tl::sprintf ("ScrollPerItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractItemView::ScrollPerPixel) { return tl::sprintf ("ScrollPerPixel (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QAbstractItemView_ScrollMode_Enum (const QAbstractItemView_ScrollMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QAbstractItemView_ScrollMode_Enum *from_i_QAbstractItemView_ScrollMode_Enum (unsigned int i)
{
  return new QAbstractItemView_ScrollMode_Enum ((QAbstractItemView::ScrollMode) i);
}

static bool equalQAbstractItemView_ScrollMode_Enum (const QAbstractItemView_ScrollMode_Enum *e, QAbstractItemView_ScrollMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QAbstractItemView_ScrollMode_Enum (const QAbstractItemView_ScrollMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QAbstractItemView_ScrollMode_Enums oropQAbstractItemView_ScrollMode_Enums (const QAbstractItemView_ScrollMode_Enums *e, const QAbstractItemView_ScrollMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QAbstractItemView_ScrollMode_Enums andopQAbstractItemView_ScrollMode_Enums (const QAbstractItemView_ScrollMode_Enums *e, const QAbstractItemView_ScrollMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QAbstractItemView_ScrollMode_Enums xoropQAbstractItemView_ScrollMode_Enums (const QAbstractItemView_ScrollMode_Enums *e, const QAbstractItemView_ScrollMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QAbstractItemView_ScrollMode_Enums (const QAbstractItemView_ScrollMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QAbstractItemView::ScrollPerItem)) { if (!l.empty ()) l += "|"; l += "ScrollPerItem"; }
  if (e->testFlag (QAbstractItemView::ScrollPerPixel)) { if (!l.empty ()) l += "|"; l += "ScrollPerPixel"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QAbstractItemView_ScrollMode_Enums (const QAbstractItemView_ScrollMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QAbstractItemView_ScrollMode_Enums (const QAbstractItemView_ScrollMode_Enums *e, const QAbstractItemView_ScrollMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QAbstractItemView_ScrollMode_Enums> decl_QAbstractItemView_ScrollMode_Enums ("QAbstractItemView_QFlags_ScrollMode",
  gsi::method_ext ("|", &qt_gsi::oropQAbstractItemView_ScrollMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQAbstractItemView_ScrollMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQAbstractItemView_ScrollMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAbstractItemView_ScrollMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAbstractItemView_ScrollMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QAbstractItemView_ScrollMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QAbstractItemView::ScrollMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QAbstractItemView_ScrollMode_Enum> decl_QAbstractItemView_ScrollMode_Enum (decl_QAbstractItemView_ScrollMode_Enums, "QAbstractItemView_ScrollMode",
  qt_gsi::mkdefs_QAbstractItemView_ScrollMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAbstractItemView_ScrollMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAbstractItemView_ScrollMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQAbstractItemView_ScrollMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QAbstractItemView_ScrollMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QAbstractItemView_ScrollMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QAbstractItemView::ScrollMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractItemView> inject_QAbstractItemView_ScrollMode_Enum_in_parent (qt_gsi::mkdefs_QAbstractItemView_ScrollMode ());
static gsi::ClassExt<QAbstractItemView> decl_QAbstractItemView_ScrollMode_Enum_as_child (decl_QAbstractItemView_ScrollMode_Enum, "ScrollMode");

}


//  Implementation of the enum wrapper class for QAbstractItemView::SelectionBehavior
namespace qt_gsi
{

static QAbstractItemView_SelectionBehavior_Enum *c_1_QAbstractItemView_SelectionBehavior_Enum () { return new QAbstractItemView_SelectionBehavior_Enum (QAbstractItemView::SelectItems); }
static QAbstractItemView_SelectionBehavior_Enum *c_2_QAbstractItemView_SelectionBehavior_Enum () { return new QAbstractItemView_SelectionBehavior_Enum (QAbstractItemView::SelectRows); }
static QAbstractItemView_SelectionBehavior_Enum *c_3_QAbstractItemView_SelectionBehavior_Enum () { return new QAbstractItemView_SelectionBehavior_Enum (QAbstractItemView::SelectColumns); }

static gsi::Methods mkdefs_QAbstractItemView_SelectionBehavior () {
  return
    gsi::constant ("SelectItems", &qt_gsi::c_1_QAbstractItemView_SelectionBehavior_Enum, "@brief Enum constant QAbstractItemView::SelectItems") +
    gsi::constant ("SelectRows", &qt_gsi::c_2_QAbstractItemView_SelectionBehavior_Enum, "@brief Enum constant QAbstractItemView::SelectRows") +
    gsi::constant ("SelectColumns", &qt_gsi::c_3_QAbstractItemView_SelectionBehavior_Enum, "@brief Enum constant QAbstractItemView::SelectColumns");
}

static std::string to_s_QAbstractItemView_SelectionBehavior_Enum (const QAbstractItemView_SelectionBehavior_Enum *e)
{
  if (e->value () == QAbstractItemView::SelectItems) { return tl::sprintf ("SelectItems (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractItemView::SelectRows) { return tl::sprintf ("SelectRows (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractItemView::SelectColumns) { return tl::sprintf ("SelectColumns (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QAbstractItemView_SelectionBehavior_Enum (const QAbstractItemView_SelectionBehavior_Enum *e)
{
  return (unsigned int) e->value ();
}

static QAbstractItemView_SelectionBehavior_Enum *from_i_QAbstractItemView_SelectionBehavior_Enum (unsigned int i)
{
  return new QAbstractItemView_SelectionBehavior_Enum ((QAbstractItemView::SelectionBehavior) i);
}

static bool equalQAbstractItemView_SelectionBehavior_Enum (const QAbstractItemView_SelectionBehavior_Enum *e, QAbstractItemView_SelectionBehavior_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QAbstractItemView_SelectionBehavior_Enum (const QAbstractItemView_SelectionBehavior_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QAbstractItemView_SelectionBehavior_Enums oropQAbstractItemView_SelectionBehavior_Enums (const QAbstractItemView_SelectionBehavior_Enums *e, const QAbstractItemView_SelectionBehavior_Enums &d)
{
  return e->flags () | d.flags ();
}

static QAbstractItemView_SelectionBehavior_Enums andopQAbstractItemView_SelectionBehavior_Enums (const QAbstractItemView_SelectionBehavior_Enums *e, const QAbstractItemView_SelectionBehavior_Enums &d)
{
  return e->flags () & d.flags ();
}

static QAbstractItemView_SelectionBehavior_Enums xoropQAbstractItemView_SelectionBehavior_Enums (const QAbstractItemView_SelectionBehavior_Enums *e, const QAbstractItemView_SelectionBehavior_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QAbstractItemView_SelectionBehavior_Enums (const QAbstractItemView_SelectionBehavior_Enums *e)
{
  std::string l;
  if (e->testFlag (QAbstractItemView::SelectItems)) { if (!l.empty ()) l += "|"; l += "SelectItems"; }
  if (e->testFlag (QAbstractItemView::SelectRows)) { if (!l.empty ()) l += "|"; l += "SelectRows"; }
  if (e->testFlag (QAbstractItemView::SelectColumns)) { if (!l.empty ()) l += "|"; l += "SelectColumns"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QAbstractItemView_SelectionBehavior_Enums (const QAbstractItemView_SelectionBehavior_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QAbstractItemView_SelectionBehavior_Enums (const QAbstractItemView_SelectionBehavior_Enums *e, const QAbstractItemView_SelectionBehavior_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QAbstractItemView_SelectionBehavior_Enums> decl_QAbstractItemView_SelectionBehavior_Enums ("QAbstractItemView_QFlags_SelectionBehavior",
  gsi::method_ext ("|", &qt_gsi::oropQAbstractItemView_SelectionBehavior_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQAbstractItemView_SelectionBehavior_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQAbstractItemView_SelectionBehavior_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAbstractItemView_SelectionBehavior_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAbstractItemView_SelectionBehavior_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QAbstractItemView_SelectionBehavior_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QAbstractItemView::SelectionBehavior> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QAbstractItemView_SelectionBehavior_Enum> decl_QAbstractItemView_SelectionBehavior_Enum (decl_QAbstractItemView_SelectionBehavior_Enums, "QAbstractItemView_SelectionBehavior",
  qt_gsi::mkdefs_QAbstractItemView_SelectionBehavior () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAbstractItemView_SelectionBehavior_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAbstractItemView_SelectionBehavior_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQAbstractItemView_SelectionBehavior_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QAbstractItemView_SelectionBehavior_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QAbstractItemView_SelectionBehavior_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QAbstractItemView::SelectionBehavior enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractItemView> inject_QAbstractItemView_SelectionBehavior_Enum_in_parent (qt_gsi::mkdefs_QAbstractItemView_SelectionBehavior ());
static gsi::ClassExt<QAbstractItemView> decl_QAbstractItemView_SelectionBehavior_Enum_as_child (decl_QAbstractItemView_SelectionBehavior_Enum, "SelectionBehavior");

}


//  Implementation of the enum wrapper class for QAbstractItemView::SelectionMode
namespace qt_gsi
{

static QAbstractItemView_SelectionMode_Enum *c_1_QAbstractItemView_SelectionMode_Enum () { return new QAbstractItemView_SelectionMode_Enum (QAbstractItemView::NoSelection); }
static QAbstractItemView_SelectionMode_Enum *c_2_QAbstractItemView_SelectionMode_Enum () { return new QAbstractItemView_SelectionMode_Enum (QAbstractItemView::SingleSelection); }
static QAbstractItemView_SelectionMode_Enum *c_3_QAbstractItemView_SelectionMode_Enum () { return new QAbstractItemView_SelectionMode_Enum (QAbstractItemView::MultiSelection); }
static QAbstractItemView_SelectionMode_Enum *c_4_QAbstractItemView_SelectionMode_Enum () { return new QAbstractItemView_SelectionMode_Enum (QAbstractItemView::ExtendedSelection); }
static QAbstractItemView_SelectionMode_Enum *c_5_QAbstractItemView_SelectionMode_Enum () { return new QAbstractItemView_SelectionMode_Enum (QAbstractItemView::ContiguousSelection); }

static gsi::Methods mkdefs_QAbstractItemView_SelectionMode () {
  return
    gsi::constant ("NoSelection", &qt_gsi::c_1_QAbstractItemView_SelectionMode_Enum, "@brief Enum constant QAbstractItemView::NoSelection") +
    gsi::constant ("SingleSelection", &qt_gsi::c_2_QAbstractItemView_SelectionMode_Enum, "@brief Enum constant QAbstractItemView::SingleSelection") +
    gsi::constant ("MultiSelection", &qt_gsi::c_3_QAbstractItemView_SelectionMode_Enum, "@brief Enum constant QAbstractItemView::MultiSelection") +
    gsi::constant ("ExtendedSelection", &qt_gsi::c_4_QAbstractItemView_SelectionMode_Enum, "@brief Enum constant QAbstractItemView::ExtendedSelection") +
    gsi::constant ("ContiguousSelection", &qt_gsi::c_5_QAbstractItemView_SelectionMode_Enum, "@brief Enum constant QAbstractItemView::ContiguousSelection");
}

static std::string to_s_QAbstractItemView_SelectionMode_Enum (const QAbstractItemView_SelectionMode_Enum *e)
{
  if (e->value () == QAbstractItemView::NoSelection) { return tl::sprintf ("NoSelection (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractItemView::SingleSelection) { return tl::sprintf ("SingleSelection (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractItemView::MultiSelection) { return tl::sprintf ("MultiSelection (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractItemView::ExtendedSelection) { return tl::sprintf ("ExtendedSelection (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractItemView::ContiguousSelection) { return tl::sprintf ("ContiguousSelection (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QAbstractItemView_SelectionMode_Enum (const QAbstractItemView_SelectionMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QAbstractItemView_SelectionMode_Enum *from_i_QAbstractItemView_SelectionMode_Enum (unsigned int i)
{
  return new QAbstractItemView_SelectionMode_Enum ((QAbstractItemView::SelectionMode) i);
}

static bool equalQAbstractItemView_SelectionMode_Enum (const QAbstractItemView_SelectionMode_Enum *e, QAbstractItemView_SelectionMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QAbstractItemView_SelectionMode_Enum (const QAbstractItemView_SelectionMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QAbstractItemView_SelectionMode_Enums oropQAbstractItemView_SelectionMode_Enums (const QAbstractItemView_SelectionMode_Enums *e, const QAbstractItemView_SelectionMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QAbstractItemView_SelectionMode_Enums andopQAbstractItemView_SelectionMode_Enums (const QAbstractItemView_SelectionMode_Enums *e, const QAbstractItemView_SelectionMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QAbstractItemView_SelectionMode_Enums xoropQAbstractItemView_SelectionMode_Enums (const QAbstractItemView_SelectionMode_Enums *e, const QAbstractItemView_SelectionMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QAbstractItemView_SelectionMode_Enums (const QAbstractItemView_SelectionMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QAbstractItemView::NoSelection)) { if (!l.empty ()) l += "|"; l += "NoSelection"; }
  if (e->testFlag (QAbstractItemView::SingleSelection)) { if (!l.empty ()) l += "|"; l += "SingleSelection"; }
  if (e->testFlag (QAbstractItemView::MultiSelection)) { if (!l.empty ()) l += "|"; l += "MultiSelection"; }
  if (e->testFlag (QAbstractItemView::ExtendedSelection)) { if (!l.empty ()) l += "|"; l += "ExtendedSelection"; }
  if (e->testFlag (QAbstractItemView::ContiguousSelection)) { if (!l.empty ()) l += "|"; l += "ContiguousSelection"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QAbstractItemView_SelectionMode_Enums (const QAbstractItemView_SelectionMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QAbstractItemView_SelectionMode_Enums (const QAbstractItemView_SelectionMode_Enums *e, const QAbstractItemView_SelectionMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QAbstractItemView_SelectionMode_Enums> decl_QAbstractItemView_SelectionMode_Enums ("QAbstractItemView_QFlags_SelectionMode",
  gsi::method_ext ("|", &qt_gsi::oropQAbstractItemView_SelectionMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQAbstractItemView_SelectionMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQAbstractItemView_SelectionMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAbstractItemView_SelectionMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAbstractItemView_SelectionMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QAbstractItemView_SelectionMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QAbstractItemView::SelectionMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QAbstractItemView_SelectionMode_Enum> decl_QAbstractItemView_SelectionMode_Enum (decl_QAbstractItemView_SelectionMode_Enums, "QAbstractItemView_SelectionMode",
  qt_gsi::mkdefs_QAbstractItemView_SelectionMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAbstractItemView_SelectionMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAbstractItemView_SelectionMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQAbstractItemView_SelectionMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QAbstractItemView_SelectionMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QAbstractItemView_SelectionMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QAbstractItemView::SelectionMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractItemView> inject_QAbstractItemView_SelectionMode_Enum_in_parent (qt_gsi::mkdefs_QAbstractItemView_SelectionMode ());
static gsi::ClassExt<QAbstractItemView> decl_QAbstractItemView_SelectionMode_Enum_as_child (decl_QAbstractItemView_SelectionMode_Enum, "SelectionMode");

}

