
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAbstractItemModel.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQAbstractItemModel_EventAdaptor.h"
#include "gsiDeclQAbstractItemModel_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAbstractItemModel

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAbstractItemModel::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QModelIndex QAbstractItemModel::buddy(const QModelIndex &index)


static void _init_f_buddy_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_buddy_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QModelIndex > ((QModelIndex)((QAbstractItemModel *)cls)->buddy (arg1));
}

static qt_gsi::GenericMethod *_create_f_buddy_c2395 ()
{
  return new qt_gsi::GenericMethod ("buddy", "@brief Method QModelIndex QAbstractItemModel::buddy(const QModelIndex &index)\n", true, &_init_f_buddy_c2395, &_call_f_buddy_c2395);
}

// bool QAbstractItemModel::canFetchMore(const QModelIndex &parent)


static void _init_f_canFetchMore_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_canFetchMore_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QAbstractItemModel *)cls)->canFetchMore (arg1));
}

static qt_gsi::GenericMethod *_create_f_canFetchMore_c2395 ()
{
  return new qt_gsi::GenericMethod ("canFetchMore", "@brief Method bool QAbstractItemModel::canFetchMore(const QModelIndex &parent)\n", true, &_init_f_canFetchMore_c2395, &_call_f_canFetchMore_c2395);
}

// int QAbstractItemModel::columnCount(const QModelIndex &parent)


static void _init_f_columnCount_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_columnCount_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<int > ((int)((QAbstractItemModel *)cls)->columnCount (arg1));
}

static qt_gsi::GenericMethod *_create_f_columnCount_c2395 ()
{
  return new qt_gsi::GenericMethod ("columnCount", "@brief Method int QAbstractItemModel::columnCount(const QModelIndex &parent)\n", true, &_init_f_columnCount_c2395, &_call_f_columnCount_c2395);
}

// QVariant QAbstractItemModel::data(const QModelIndex &index, int role)


static void _init_f_data_c3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role", true, "Qt::DisplayRole");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_f_data_c3054 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args ? args.read<int > () : (int)(Qt::DisplayRole);
  ret.write<QVariant > ((QVariant)((QAbstractItemModel *)cls)->data (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_data_c3054 ()
{
  return new qt_gsi::GenericMethod ("data", "@brief Method QVariant QAbstractItemModel::data(const QModelIndex &index, int role)\n", true, &_init_f_data_c3054, &_call_f_data_c3054);
}

// bool QAbstractItemModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)


static void _init_f_dropMimeData_7425 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_f_dropMimeData_7425 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMimeData *arg1 = args.read<const QMimeData * > ();
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  const QModelIndex &arg5 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QAbstractItemModel *)cls)->dropMimeData (arg1, qt_gsi::QtToCppAdaptor<Qt::DropAction>(arg2).cref(), arg3, arg4, arg5));
}

static qt_gsi::GenericMethod *_create_f_dropMimeData_7425 ()
{
  return new qt_gsi::GenericMethod ("dropMimeData", "@brief Method bool QAbstractItemModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\n", false, &_init_f_dropMimeData_7425, &_call_f_dropMimeData_7425);
}

// void QAbstractItemModel::fetchMore(const QModelIndex &parent)


static void _init_f_fetchMore_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_fetchMore_2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ((QAbstractItemModel *)cls)->fetchMore (arg1);
}

static qt_gsi::GenericMethod *_create_f_fetchMore_2395 ()
{
  return new qt_gsi::GenericMethod ("fetchMore", "@brief Method void QAbstractItemModel::fetchMore(const QModelIndex &parent)\n", false, &_init_f_fetchMore_2395, &_call_f_fetchMore_2395);
}

// QFlags<Qt::ItemFlag> QAbstractItemModel::flags(const QModelIndex &index)


static void _init_f_flags_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type > ();
}

static void _call_f_flags_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type > ((qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::ItemFlag> >(((QAbstractItemModel *)cls)->flags (arg1)));
}

static qt_gsi::GenericMethod *_create_f_flags_c2395 ()
{
  return new qt_gsi::GenericMethod ("flags", "@brief Method QFlags<Qt::ItemFlag> QAbstractItemModel::flags(const QModelIndex &index)\n", true, &_init_f_flags_c2395, &_call_f_flags_c2395);
}

// bool QAbstractItemModel::hasChildren(const QModelIndex &parent)


static void _init_f_hasChildren_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasChildren_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<bool > ((bool)((QAbstractItemModel *)cls)->hasChildren (arg1));
}

static qt_gsi::GenericMethod *_create_f_hasChildren_c2395 ()
{
  return new qt_gsi::GenericMethod ("hasChildren", "@brief Method bool QAbstractItemModel::hasChildren(const QModelIndex &parent)\n", true, &_init_f_hasChildren_c2395, &_call_f_hasChildren_c2395);
}

// bool QAbstractItemModel::hasIndex(int row, int column, const QModelIndex &parent)


static void _init_f_hasIndex_c3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_hasIndex_c3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<bool > ((bool)((QAbstractItemModel *)cls)->hasIndex (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_hasIndex_c3713 ()
{
  return new qt_gsi::GenericMethod ("hasIndex", "@brief Method bool QAbstractItemModel::hasIndex(int row, int column, const QModelIndex &parent)\n", true, &_init_f_hasIndex_c3713, &_call_f_hasIndex_c3713);
}

// QVariant QAbstractItemModel::headerData(int section, Qt::Orientation orientation, int role)


static void _init_f_headerData_c3231 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role", true, "Qt::DisplayRole");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_f_headerData_c3231 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  int arg3 = args ? args.read<int > () : (int)(Qt::DisplayRole);
  ret.write<QVariant > ((QVariant)((QAbstractItemModel *)cls)->headerData (arg1, qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg2).cref(), arg3));
}

static qt_gsi::GenericMethod *_create_f_headerData_c3231 ()
{
  return new qt_gsi::GenericMethod ("headerData", "@brief Method QVariant QAbstractItemModel::headerData(int section, Qt::Orientation orientation, int role)\n", true, &_init_f_headerData_c3231, &_call_f_headerData_c3231);
}

// QModelIndex QAbstractItemModel::index(int row, int column, const QModelIndex &parent)


static void _init_f_index_c3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_f_index_c3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<QModelIndex > ((QModelIndex)((QAbstractItemModel *)cls)->index (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_index_c3713 ()
{
  return new qt_gsi::GenericMethod ("index", "@brief Method QModelIndex QAbstractItemModel::index(int row, int column, const QModelIndex &parent)\n", true, &_init_f_index_c3713, &_call_f_index_c3713);
}

// bool QAbstractItemModel::insertColumn(int column, const QModelIndex &parent)


static void _init_f_insertColumn_3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_insertColumn_3054 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QModelIndex &arg2 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<bool > ((bool)((QAbstractItemModel *)cls)->insertColumn (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_insertColumn_3054 ()
{
  return new qt_gsi::GenericMethod ("insertColumn", "@brief Method bool QAbstractItemModel::insertColumn(int column, const QModelIndex &parent)\n", false, &_init_f_insertColumn_3054, &_call_f_insertColumn_3054);
}

// bool QAbstractItemModel::insertColumns(int column, int count, const QModelIndex &parent)


static void _init_f_insertColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_insertColumns_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<bool > ((bool)((QAbstractItemModel *)cls)->insertColumns (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_insertColumns_3713 ()
{
  return new qt_gsi::GenericMethod ("insertColumns", "@brief Method bool QAbstractItemModel::insertColumns(int column, int count, const QModelIndex &parent)\n", false, &_init_f_insertColumns_3713, &_call_f_insertColumns_3713);
}

// bool QAbstractItemModel::insertRow(int row, const QModelIndex &parent)


static void _init_f_insertRow_3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_insertRow_3054 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QModelIndex &arg2 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<bool > ((bool)((QAbstractItemModel *)cls)->insertRow (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_insertRow_3054 ()
{
  return new qt_gsi::GenericMethod ("insertRow", "@brief Method bool QAbstractItemModel::insertRow(int row, const QModelIndex &parent)\n", false, &_init_f_insertRow_3054, &_call_f_insertRow_3054);
}

// bool QAbstractItemModel::insertRows(int row, int count, const QModelIndex &parent)


static void _init_f_insertRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_insertRows_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<bool > ((bool)((QAbstractItemModel *)cls)->insertRows (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_insertRows_3713 ()
{
  return new qt_gsi::GenericMethod ("insertRows", "@brief Method bool QAbstractItemModel::insertRows(int row, int count, const QModelIndex &parent)\n", false, &_init_f_insertRows_3713, &_call_f_insertRows_3713);
}

// QList<QModelIndex> QAbstractItemModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)


static void _init_f_match_c7932 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("start");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("hits", true, "1");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("flags", true, "Qt::MatchFlags(Qt::MatchStartsWith|Qt::MatchWrap)");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & > (argspec_4);
  decl->set_return<qt_gsi::Converter<QList<QModelIndex> >::target_type > ();
}

static void _call_f_match_c7932 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  const QVariant &arg3 = args.read<const QVariant & > ();
  int arg4 = args ? args.read<int > () : (int)(1);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & arg5 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::MatchFlag> >(heap, Qt::MatchFlags(Qt::MatchStartsWith|Qt::MatchWrap)));
  ret.write<qt_gsi::Converter<QList<QModelIndex> >::target_type > ((qt_gsi::Converter<QList<QModelIndex> >::target_type)qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(((QAbstractItemModel *)cls)->match (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<QFlags<Qt::MatchFlag> >(arg5).cref())));
}

static qt_gsi::GenericMethod *_create_f_match_c7932 ()
{
  return new qt_gsi::GenericMethod ("match", "@brief Method QList<QModelIndex> QAbstractItemModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)\n", true, &_init_f_match_c7932, &_call_f_match_c7932);
}

// QMimeData *QAbstractItemModel::mimeData(const QList<QModelIndex> &indexes)


static void _init_f_mimeData_c3010 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > (argspec_0);
  decl->set_return<QMimeData * > ();
}

static void _call_f_mimeData_c3010 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QModelIndex> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > ();
  ret.write<QMimeData * > ((QMimeData *)((QAbstractItemModel *)cls)->mimeData (qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_mimeData_c3010 ()
{
  return new qt_gsi::GenericMethod ("mimeData", "@brief Method QMimeData *QAbstractItemModel::mimeData(const QList<QModelIndex> &indexes)\n", true, &_init_f_mimeData_c3010, &_call_f_mimeData_c3010);
}

// QStringList QAbstractItemModel::mimeTypes()


static void _init_f_mimeTypes_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_mimeTypes_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QAbstractItemModel *)cls)->mimeTypes ()));
}

static qt_gsi::GenericMethod *_create_f_mimeTypes_c0 ()
{
  return new qt_gsi::GenericMethod ("mimeTypes", "@brief Method QStringList QAbstractItemModel::mimeTypes()\n", true, &_init_f_mimeTypes_c0, &_call_f_mimeTypes_c0);
}

// QModelIndex QAbstractItemModel::parent(const QModelIndex &child)


static void _init_f_parent_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("child");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_parent_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QModelIndex > ((QModelIndex)((QAbstractItemModel *)cls)->parent (arg1));
}

static qt_gsi::GenericMethod *_create_f_parent_c2395 ()
{
  return new qt_gsi::GenericMethod ("parent", "@brief Method QModelIndex QAbstractItemModel::parent(const QModelIndex &child)\n", true, &_init_f_parent_c2395, &_call_f_parent_c2395);
}

// QObject *QAbstractItemModel::parent()


static void _init_f_parent_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_f_parent_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QAbstractItemModel *)cls)->parent ());
}

static qt_gsi::GenericMethod *_create_f_parent_c0 ()
{
  return new qt_gsi::GenericMethod (":parent", "@brief Method QObject *QAbstractItemModel::parent()\n", true, &_init_f_parent_c0, &_call_f_parent_c0);
}

// bool QAbstractItemModel::removeColumn(int column, const QModelIndex &parent)


static void _init_f_removeColumn_3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_removeColumn_3054 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QModelIndex &arg2 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<bool > ((bool)((QAbstractItemModel *)cls)->removeColumn (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_removeColumn_3054 ()
{
  return new qt_gsi::GenericMethod ("removeColumn", "@brief Method bool QAbstractItemModel::removeColumn(int column, const QModelIndex &parent)\n", false, &_init_f_removeColumn_3054, &_call_f_removeColumn_3054);
}

// bool QAbstractItemModel::removeColumns(int column, int count, const QModelIndex &parent)


static void _init_f_removeColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_removeColumns_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<bool > ((bool)((QAbstractItemModel *)cls)->removeColumns (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_removeColumns_3713 ()
{
  return new qt_gsi::GenericMethod ("removeColumns", "@brief Method bool QAbstractItemModel::removeColumns(int column, int count, const QModelIndex &parent)\n", false, &_init_f_removeColumns_3713, &_call_f_removeColumns_3713);
}

// bool QAbstractItemModel::removeRow(int row, const QModelIndex &parent)


static void _init_f_removeRow_3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_removeRow_3054 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QModelIndex &arg2 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<bool > ((bool)((QAbstractItemModel *)cls)->removeRow (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_removeRow_3054 ()
{
  return new qt_gsi::GenericMethod ("removeRow", "@brief Method bool QAbstractItemModel::removeRow(int row, const QModelIndex &parent)\n", false, &_init_f_removeRow_3054, &_call_f_removeRow_3054);
}

// bool QAbstractItemModel::removeRows(int row, int count, const QModelIndex &parent)


static void _init_f_removeRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_removeRows_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<bool > ((bool)((QAbstractItemModel *)cls)->removeRows (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_removeRows_3713 ()
{
  return new qt_gsi::GenericMethod ("removeRows", "@brief Method bool QAbstractItemModel::removeRows(int row, int count, const QModelIndex &parent)\n", false, &_init_f_removeRows_3713, &_call_f_removeRows_3713);
}

// void QAbstractItemModel::revert()


static void _init_f_revert_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_revert_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemModel *)cls)->revert ();
}

static qt_gsi::GenericMethod *_create_f_revert_0 ()
{
  return new qt_gsi::GenericMethod ("revert", "@brief Method void QAbstractItemModel::revert()\n", false, &_init_f_revert_0, &_call_f_revert_0);
}

// int QAbstractItemModel::rowCount(const QModelIndex &parent)


static void _init_f_rowCount_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_rowCount_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<int > ((int)((QAbstractItemModel *)cls)->rowCount (arg1));
}

static qt_gsi::GenericMethod *_create_f_rowCount_c2395 ()
{
  return new qt_gsi::GenericMethod ("rowCount", "@brief Method int QAbstractItemModel::rowCount(const QModelIndex &parent)\n", true, &_init_f_rowCount_c2395, &_call_f_rowCount_c2395);
}

// bool QAbstractItemModel::setData(const QModelIndex &index, const QVariant &value, int role)


static void _init_f_setData_5065 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role", true, "Qt::EditRole");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_setData_5065 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  int arg3 = args ? args.read<int > () : (int)(Qt::EditRole);
  ret.write<bool > ((bool)((QAbstractItemModel *)cls)->setData (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_setData_5065 ()
{
  return new qt_gsi::GenericMethod ("setData", "@brief Method bool QAbstractItemModel::setData(const QModelIndex &index, const QVariant &value, int role)\n", false, &_init_f_setData_5065, &_call_f_setData_5065);
}

// bool QAbstractItemModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)


static void _init_f_setHeaderData_5242 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("role", true, "Qt::EditRole");
  decl->add_arg<int > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_setHeaderData_5242 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  const QVariant &arg3 = args.read<const QVariant & > ();
  int arg4 = args ? args.read<int > () : (int)(Qt::EditRole);
  ret.write<bool > ((bool)((QAbstractItemModel *)cls)->setHeaderData (arg1, qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg2).cref(), arg3, arg4));
}

static qt_gsi::GenericMethod *_create_f_setHeaderData_5242 ()
{
  return new qt_gsi::GenericMethod ("setHeaderData", "@brief Method bool QAbstractItemModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)\n", false, &_init_f_setHeaderData_5242, &_call_f_setHeaderData_5242);
}

// void QAbstractItemModel::setSupportedDragActions(QFlags<Qt::DropAction>)


static void _init_f_setSupportedDragActions_2456 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSupportedDragActions_2456 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & > ();
  ((QAbstractItemModel *)cls)->setSupportedDragActions (qt_gsi::QtToCppAdaptor<QFlags<Qt::DropAction> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setSupportedDragActions_2456 ()
{
  return new qt_gsi::GenericMethod ("setSupportedDragActions|supportedDragActions=", "@brief Method void QAbstractItemModel::setSupportedDragActions(QFlags<Qt::DropAction>)\n", false, &_init_f_setSupportedDragActions_2456, &_call_f_setSupportedDragActions_2456);
}

// QModelIndex QAbstractItemModel::sibling(int row, int column, const QModelIndex &idx)


static void _init_f_sibling_c3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("idx");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_f_sibling_c3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<QModelIndex > ((QModelIndex)((QAbstractItemModel *)cls)->sibling (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_sibling_c3713 ()
{
  return new qt_gsi::GenericMethod ("sibling", "@brief Method QModelIndex QAbstractItemModel::sibling(int row, int column, const QModelIndex &idx)\n", true, &_init_f_sibling_c3713, &_call_f_sibling_c3713);
}

// void QAbstractItemModel::sort(int column, Qt::SortOrder order)


static void _init_f_sort_2340 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order", true, "Qt::AscendingOrder");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_sort_2340 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > () : (const qt_gsi::Converter<Qt::SortOrder>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::SortOrder>(heap, Qt::AscendingOrder));
  ((QAbstractItemModel *)cls)->sort (arg1, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_sort_2340 ()
{
  return new qt_gsi::GenericMethod ("sort", "@brief Method void QAbstractItemModel::sort(int column, Qt::SortOrder order)\n", false, &_init_f_sort_2340, &_call_f_sort_2340);
}

// QSize QAbstractItemModel::span(const QModelIndex &index)


static void _init_f_span_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QSize > ();
}

static void _call_f_span_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QSize > ((QSize)((QAbstractItemModel *)cls)->span (arg1));
}

static qt_gsi::GenericMethod *_create_f_span_c2395 ()
{
  return new qt_gsi::GenericMethod ("span", "@brief Method QSize QAbstractItemModel::span(const QModelIndex &index)\n", true, &_init_f_span_c2395, &_call_f_span_c2395);
}

// bool QAbstractItemModel::submit()


static void _init_f_submit_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_submit_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QAbstractItemModel *)cls)->submit ());
}

static qt_gsi::GenericMethod *_create_f_submit_0 ()
{
  return new qt_gsi::GenericMethod ("submit", "@brief Method bool QAbstractItemModel::submit()\n", false, &_init_f_submit_0, &_call_f_submit_0);
}

// QFlags<Qt::DropAction> QAbstractItemModel::supportedDragActions()


static void _init_f_supportedDragActions_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ();
}

static void _call_f_supportedDragActions_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ((qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::DropAction> >(((QAbstractItemModel *)cls)->supportedDragActions ()));
}

static qt_gsi::GenericMethod *_create_f_supportedDragActions_c0 ()
{
  return new qt_gsi::GenericMethod (":supportedDragActions", "@brief Method QFlags<Qt::DropAction> QAbstractItemModel::supportedDragActions()\n", true, &_init_f_supportedDragActions_c0, &_call_f_supportedDragActions_c0);
}

// QFlags<Qt::DropAction> QAbstractItemModel::supportedDropActions()


static void _init_f_supportedDropActions_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ();
}

static void _call_f_supportedDropActions_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ((qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::DropAction> >(((QAbstractItemModel *)cls)->supportedDropActions ()));
}

static qt_gsi::GenericMethod *_create_f_supportedDropActions_c0 ()
{
  return new qt_gsi::GenericMethod ("supportedDropActions", "@brief Method QFlags<Qt::DropAction> QAbstractItemModel::supportedDropActions()\n", true, &_init_f_supportedDropActions_c0, &_call_f_supportedDropActions_c0);
}

// static QString QAbstractItemModel::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QAbstractItemModel::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractItemModel::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QAbstractItemModel::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QAbstractItemModel::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractItemModel::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QAbstractItemModel::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QAbstractItemModel::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAbstractItemModel::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QAbstractItemModel::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QAbstractItemModel::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAbstractItemModel::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QAbstractItemModel, QAbstractItemModel_EventAdaptor> ea_QAbstractItemModel;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QAbstractItemModel> decl_QAbstractItemModel (ea_QAbstractItemModel, decl_QObject, "QAbstractItemModel_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_buddy_c2395 ()) +
  gsi::Methods(_create_f_canFetchMore_c2395 ()) +
  gsi::Methods(_create_f_columnCount_c2395 ()) +
  gsi::Methods(_create_f_data_c3054 ()) +
  gsi::Methods(_create_f_dropMimeData_7425 ()) +
  gsi::Methods(_create_f_fetchMore_2395 ()) +
  gsi::Methods(_create_f_flags_c2395 ()) +
  gsi::Methods(_create_f_hasChildren_c2395 ()) +
  gsi::Methods(_create_f_hasIndex_c3713 ()) +
  gsi::Methods(_create_f_headerData_c3231 ()) +
  gsi::Methods(_create_f_index_c3713 ()) +
  gsi::Methods(_create_f_insertColumn_3054 ()) +
  gsi::Methods(_create_f_insertColumns_3713 ()) +
  gsi::Methods(_create_f_insertRow_3054 ()) +
  gsi::Methods(_create_f_insertRows_3713 ()) +
  gsi::Methods(_create_f_match_c7932 ()) +
  gsi::Methods(_create_f_mimeData_c3010 ()) +
  gsi::Methods(_create_f_mimeTypes_c0 ()) +
  gsi::Methods(_create_f_parent_c2395 ()) +
  gsi::Methods(_create_f_parent_c0 ()) +
  gsi::Methods(_create_f_removeColumn_3054 ()) +
  gsi::Methods(_create_f_removeColumns_3713 ()) +
  gsi::Methods(_create_f_removeRow_3054 ()) +
  gsi::Methods(_create_f_removeRows_3713 ()) +
  gsi::Methods(_create_f_revert_0 ()) +
  gsi::Methods(_create_f_rowCount_c2395 ()) +
  gsi::Methods(_create_f_setData_5065 ()) +
  gsi::Methods(_create_f_setHeaderData_5242 ()) +
  gsi::Methods(_create_f_setSupportedDragActions_2456 ()) +
  gsi::Methods(_create_f_sibling_c3713 ()) +
  gsi::Methods(_create_f_sort_2340 ()) +
  gsi::Methods(_create_f_span_c2395 ()) +
  gsi::Methods(_create_f_submit_0 ()) +
  gsi::Methods(_create_f_supportedDragActions_c0 ()) +
  gsi::Methods(_create_f_supportedDropActions_c0 ()) +
  qt_gsi::qt_signal<QAbstractItemModel, QAbstractItemModel_EventAdaptor, const QModelIndex &, const QModelIndex &> ("dataChanged", &QAbstractItemModel_EventAdaptor::dataChanged_e_4682, gsi::arg("topLeft"), gsi::arg("bottomRight"), "@brief Signal declaration for QAbstractItemModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractItemModel, QAbstractItemModel_EventAdaptor, QObject *> ("destroyed", &QAbstractItemModel_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QAbstractItemModel::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractItemModel, QAbstractItemModel_EventAdaptor, const qt_gsi::Converter<Qt::Orientation>::target_type &, int, int> ("headerDataChanged", &QAbstractItemModel_EventAdaptor::headerDataChanged_e_3231, gsi::arg("orientation"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QAbstractItemModel::headerDataChanged(Qt::Orientation orientation, int first, int last)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractItemModel, QAbstractItemModel_EventAdaptor> ("layoutAboutToBeChanged", &QAbstractItemModel_EventAdaptor::layoutAboutToBeChanged_e_0, "@brief Signal declaration for QAbstractItemModel::layoutAboutToBeChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractItemModel, QAbstractItemModel_EventAdaptor> ("layoutChanged", &QAbstractItemModel_EventAdaptor::layoutChanged_e_0, "@brief Signal declaration for QAbstractItemModel::layoutChanged()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QAbstractItemModel");
}


class QAbstractItemModel_Adaptor : public QAbstractItemModel, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAbstractItemModel_Adaptor();

  //  [adaptor ctor] QAbstractItemModel::QAbstractItemModel(QObject *parent)
  QAbstractItemModel_Adaptor() : QAbstractItemModel()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QAbstractItemModel::QAbstractItemModel(QObject *parent)
  QAbstractItemModel_Adaptor(QObject *parent) : QAbstractItemModel(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QAbstractItemModel::beginInsertColumns(const QModelIndex &parent, int first, int last)
  void fp_QAbstractItemModel_beginInsertColumns_3713 (const QModelIndex &parent, int first, int last) {
    QAbstractItemModel::beginInsertColumns(parent, first, last);
  }

  //  void QAbstractItemModel::beginInsertRows(const QModelIndex &parent, int first, int last)
  void fp_QAbstractItemModel_beginInsertRows_3713 (const QModelIndex &parent, int first, int last) {
    QAbstractItemModel::beginInsertRows(parent, first, last);
  }

  //  bool QAbstractItemModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)
  bool fp_QAbstractItemModel_beginMoveColumns_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn) {
    return QAbstractItemModel::beginMoveColumns(sourceParent, sourceFirst, sourceLast, destinationParent, destinationColumn);
  }

  //  bool QAbstractItemModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)
  bool fp_QAbstractItemModel_beginMoveRows_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow) {
    return QAbstractItemModel::beginMoveRows(sourceParent, sourceFirst, sourceLast, destinationParent, destinationRow);
  }

  //  void QAbstractItemModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)
  void fp_QAbstractItemModel_beginRemoveColumns_3713 (const QModelIndex &parent, int first, int last) {
    QAbstractItemModel::beginRemoveColumns(parent, first, last);
  }

  //  void QAbstractItemModel::beginRemoveRows(const QModelIndex &parent, int first, int last)
  void fp_QAbstractItemModel_beginRemoveRows_3713 (const QModelIndex &parent, int first, int last) {
    QAbstractItemModel::beginRemoveRows(parent, first, last);
  }

  //  void QAbstractItemModel::beginResetModel()
  void fp_QAbstractItemModel_beginResetModel_0 () {
    QAbstractItemModel::beginResetModel();
  }

  //  void QAbstractItemModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)
  void fp_QAbstractItemModel_changePersistentIndex_4682 (const QModelIndex &from, const QModelIndex &to) {
    QAbstractItemModel::changePersistentIndex(from, to);
  }

  //  void QAbstractItemModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)
  void fp_QAbstractItemModel_changePersistentIndexList_5912 (const qt_gsi::Converter<QList<QModelIndex> >::target_type & from, const qt_gsi::Converter<QList<QModelIndex> >::target_type & to) {
    QAbstractItemModel::changePersistentIndexList(qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(from).cref(), qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(to).cref());
  }

  //  QModelIndex QAbstractItemModel::createIndex(int row, int column, void *data)
  QModelIndex fp_QAbstractItemModel_createIndex_c2374 (int row, int column, void *data) const {
    return QAbstractItemModel::createIndex(row, column, data);
  }

  //  QModelIndex QAbstractItemModel::createIndex(int row, int column, int id)
  QModelIndex fp_QAbstractItemModel_createIndex_c2085 (int row, int column, int id) const {
    return QAbstractItemModel::createIndex(row, column, id);
  }

  //  QModelIndex QAbstractItemModel::createIndex(int row, int column, quint32 id)
  QModelIndex fp_QAbstractItemModel_createIndex_c2416 (int row, int column, quint32 id) const {
    return QAbstractItemModel::createIndex(row, column, id);
  }

  //  bool QAbstractItemModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)
  bool fp_QAbstractItemModel_decodeData_5302 (int row, int column, const QModelIndex &parent, QDataStream &stream) {
    return QAbstractItemModel::decodeData(row, column, parent, stream);
  }

  //  void QAbstractItemModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)
  void fp_QAbstractItemModel_encodeData_c4599 (const qt_gsi::Converter<QList<QModelIndex> >::target_type & indexes, QDataStream &stream) const {
    QAbstractItemModel::encodeData(qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(indexes).cref(), stream);
  }

  //  void QAbstractItemModel::endInsertColumns()
  void fp_QAbstractItemModel_endInsertColumns_0 () {
    QAbstractItemModel::endInsertColumns();
  }

  //  void QAbstractItemModel::endInsertRows()
  void fp_QAbstractItemModel_endInsertRows_0 () {
    QAbstractItemModel::endInsertRows();
  }

  //  void QAbstractItemModel::endMoveColumns()
  void fp_QAbstractItemModel_endMoveColumns_0 () {
    QAbstractItemModel::endMoveColumns();
  }

  //  void QAbstractItemModel::endMoveRows()
  void fp_QAbstractItemModel_endMoveRows_0 () {
    QAbstractItemModel::endMoveRows();
  }

  //  void QAbstractItemModel::endRemoveColumns()
  void fp_QAbstractItemModel_endRemoveColumns_0 () {
    QAbstractItemModel::endRemoveColumns();
  }

  //  void QAbstractItemModel::endRemoveRows()
  void fp_QAbstractItemModel_endRemoveRows_0 () {
    QAbstractItemModel::endRemoveRows();
  }

  //  void QAbstractItemModel::endResetModel()
  void fp_QAbstractItemModel_endResetModel_0 () {
    QAbstractItemModel::endResetModel();
  }

  //  QList<QModelIndex> QAbstractItemModel::persistentIndexList()
  qt_gsi::Converter<QList<QModelIndex> >::target_type fp_QAbstractItemModel_persistentIndexList_c0 () const {
    return qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(QAbstractItemModel::persistentIndexList());
  }

  //  int QAbstractItemModel::receivers(const char *signal)
  int fp_QAbstractItemModel_receivers_c1731 (const char *signal) const {
    return QAbstractItemModel::receivers(signal);
  }

  //  void QAbstractItemModel::reset()
  void fp_QAbstractItemModel_reset_0 () {
    QAbstractItemModel::reset();
  }

  //  QObject *QAbstractItemModel::sender()
  QObject * fp_QAbstractItemModel_sender_c0 () const {
    return QAbstractItemModel::sender();
  }

  //  [adaptor impl] QModelIndex QAbstractItemModel::buddy(const QModelIndex &index)
  QModelIndex cbs_buddy_c2395_0(const QModelIndex &index) const
  {
    return QAbstractItemModel::buddy(index);
  }

  virtual QModelIndex buddy(const QModelIndex &index) const
  {
    if (cb_buddy_c2395_0.can_issue()) {
      return cb_buddy_c2395_0.issue<QAbstractItemModel_Adaptor, QModelIndex, const QModelIndex &>(&QAbstractItemModel_Adaptor::cbs_buddy_c2395_0, index);
    } else {
      return QAbstractItemModel::buddy(index);
    }
  }

  //  [adaptor impl] bool QAbstractItemModel::canFetchMore(const QModelIndex &parent)
  bool cbs_canFetchMore_c2395_0(const QModelIndex &parent) const
  {
    return QAbstractItemModel::canFetchMore(parent);
  }

  virtual bool canFetchMore(const QModelIndex &parent) const
  {
    if (cb_canFetchMore_c2395_0.can_issue()) {
      return cb_canFetchMore_c2395_0.issue<QAbstractItemModel_Adaptor, bool, const QModelIndex &>(&QAbstractItemModel_Adaptor::cbs_canFetchMore_c2395_0, parent);
    } else {
      return QAbstractItemModel::canFetchMore(parent);
    }
  }

  //  [adaptor impl] int QAbstractItemModel::columnCount(const QModelIndex &parent)
  int cbs_columnCount_c2395_1(const QModelIndex &parent) const
  {
    throw qt_gsi::AbstractMethodCalledException("columnCount");
  }

  virtual int columnCount(const QModelIndex &parent) const
  {
    if (cb_columnCount_c2395_1.can_issue()) {
      return cb_columnCount_c2395_1.issue<QAbstractItemModel_Adaptor, int, const QModelIndex &>(&QAbstractItemModel_Adaptor::cbs_columnCount_c2395_1, parent);
    } else {
      throw qt_gsi::AbstractMethodCalledException("columnCount");
    }
  }

  //  [adaptor impl] QVariant QAbstractItemModel::data(const QModelIndex &index, int role)
  QVariant cbs_data_c3054_1(const QModelIndex &index, int role) const
  {
    throw qt_gsi::AbstractMethodCalledException("data");
  }

  virtual QVariant data(const QModelIndex &index, int role) const
  {
    if (cb_data_c3054_1.can_issue()) {
      return cb_data_c3054_1.issue<QAbstractItemModel_Adaptor, QVariant, const QModelIndex &, int>(&QAbstractItemModel_Adaptor::cbs_data_c3054_1, index, role);
    } else {
      throw qt_gsi::AbstractMethodCalledException("data");
    }
  }

  //  [adaptor impl] bool QAbstractItemModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  bool cbs_dropMimeData_7425_0(const QMimeData *data, const qt_gsi::Converter<Qt::DropAction>::target_type & action, int row, int column, const QModelIndex &parent)
  {
    return QAbstractItemModel::dropMimeData(data, qt_gsi::QtToCppAdaptor<Qt::DropAction>(action).cref(), row, column, parent);
  }

  virtual bool dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  {
    if (cb_dropMimeData_7425_0.can_issue()) {
      return cb_dropMimeData_7425_0.issue<QAbstractItemModel_Adaptor, bool, const QMimeData *, const qt_gsi::Converter<Qt::DropAction>::target_type &, int, int, const QModelIndex &>(&QAbstractItemModel_Adaptor::cbs_dropMimeData_7425_0, data, qt_gsi::CppToQtAdaptor<Qt::DropAction>(action), row, column, parent);
    } else {
      return QAbstractItemModel::dropMimeData(data, action, row, column, parent);
    }
  }

  //  [adaptor impl] bool QAbstractItemModel::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QAbstractItemModel::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QAbstractItemModel_Adaptor, bool, QEvent *>(&QAbstractItemModel_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QAbstractItemModel::event(arg1);
    }
  }

  //  [adaptor impl] bool QAbstractItemModel::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QAbstractItemModel::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QAbstractItemModel_Adaptor, bool, QObject *, QEvent *>(&QAbstractItemModel_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QAbstractItemModel::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QAbstractItemModel::fetchMore(const QModelIndex &parent)
  void cbs_fetchMore_2395_0(const QModelIndex &parent)
  {
    QAbstractItemModel::fetchMore(parent);
  }

  virtual void fetchMore(const QModelIndex &parent)
  {
    if (cb_fetchMore_2395_0.can_issue()) {
      cb_fetchMore_2395_0.issue<QAbstractItemModel_Adaptor, const QModelIndex &>(&QAbstractItemModel_Adaptor::cbs_fetchMore_2395_0, parent);
    } else {
      QAbstractItemModel::fetchMore(parent);
    }
  }

  //  [adaptor impl] QFlags<Qt::ItemFlag> QAbstractItemModel::flags(const QModelIndex &index)
  qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type cbs_flags_c2395_0(const QModelIndex &index) const
  {
    return qt_gsi::CppToQtAdaptor<QFlags<Qt::ItemFlag> >(QAbstractItemModel::flags(index));
  }

  virtual QFlags<Qt::ItemFlag> flags(const QModelIndex &index) const
  {
    if (cb_flags_c2395_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QFlags<Qt::ItemFlag> >(cb_flags_c2395_0.issue<QAbstractItemModel_Adaptor, qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type, const QModelIndex &>(&QAbstractItemModel_Adaptor::cbs_flags_c2395_0, index)).cref();
    } else {
      return QAbstractItemModel::flags(index);
    }
  }

  //  [adaptor impl] bool QAbstractItemModel::hasChildren(const QModelIndex &parent)
  bool cbs_hasChildren_c2395_1(const QModelIndex &parent) const
  {
    return QAbstractItemModel::hasChildren(parent);
  }

  virtual bool hasChildren(const QModelIndex &parent) const
  {
    if (cb_hasChildren_c2395_1.can_issue()) {
      return cb_hasChildren_c2395_1.issue<QAbstractItemModel_Adaptor, bool, const QModelIndex &>(&QAbstractItemModel_Adaptor::cbs_hasChildren_c2395_1, parent);
    } else {
      return QAbstractItemModel::hasChildren(parent);
    }
  }

  //  [adaptor impl] QVariant QAbstractItemModel::headerData(int section, Qt::Orientation orientation, int role)
  QVariant cbs_headerData_c3231_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, int role) const
  {
    return QAbstractItemModel::headerData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), role);
  }

  virtual QVariant headerData(int section, Qt::Orientation orientation, int role) const
  {
    if (cb_headerData_c3231_1.can_issue()) {
      return cb_headerData_c3231_1.issue<QAbstractItemModel_Adaptor, QVariant, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, int>(&QAbstractItemModel_Adaptor::cbs_headerData_c3231_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), role);
    } else {
      return QAbstractItemModel::headerData(section, orientation, role);
    }
  }

  //  [adaptor impl] QModelIndex QAbstractItemModel::index(int row, int column, const QModelIndex &parent)
  QModelIndex cbs_index_c3713_1(int row, int column, const QModelIndex &parent) const
  {
    throw qt_gsi::AbstractMethodCalledException("index");
  }

  virtual QModelIndex index(int row, int column, const QModelIndex &parent) const
  {
    if (cb_index_c3713_1.can_issue()) {
      return cb_index_c3713_1.issue<QAbstractItemModel_Adaptor, QModelIndex, int, int, const QModelIndex &>(&QAbstractItemModel_Adaptor::cbs_index_c3713_1, row, column, parent);
    } else {
      throw qt_gsi::AbstractMethodCalledException("index");
    }
  }

  //  [adaptor impl] bool QAbstractItemModel::insertColumns(int column, int count, const QModelIndex &parent)
  bool cbs_insertColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QAbstractItemModel::insertColumns(column, count, parent);
  }

  virtual bool insertColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_insertColumns_3713_1.can_issue()) {
      return cb_insertColumns_3713_1.issue<QAbstractItemModel_Adaptor, bool, int, int, const QModelIndex &>(&QAbstractItemModel_Adaptor::cbs_insertColumns_3713_1, column, count, parent);
    } else {
      return QAbstractItemModel::insertColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QAbstractItemModel::insertRows(int row, int count, const QModelIndex &parent)
  bool cbs_insertRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QAbstractItemModel::insertRows(row, count, parent);
  }

  virtual bool insertRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_insertRows_3713_1.can_issue()) {
      return cb_insertRows_3713_1.issue<QAbstractItemModel_Adaptor, bool, int, int, const QModelIndex &>(&QAbstractItemModel_Adaptor::cbs_insertRows_3713_1, row, count, parent);
    } else {
      return QAbstractItemModel::insertRows(row, count, parent);
    }
  }

  //  [adaptor impl] QList<QModelIndex> QAbstractItemModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)
  qt_gsi::Converter<QList<QModelIndex> >::target_type cbs_match_c7932_2(const QModelIndex &start, int role, const QVariant &value, int hits, const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & flags) const
  {
    return qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(QAbstractItemModel::match(start, role, value, hits, qt_gsi::QtToCppAdaptor<QFlags<Qt::MatchFlag> >(flags).cref()));
  }

  virtual QList<QModelIndex> match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags) const
  {
    if (cb_match_c7932_2.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(cb_match_c7932_2.issue<QAbstractItemModel_Adaptor, qt_gsi::Converter<QList<QModelIndex> >::target_type, const QModelIndex &, int, const QVariant &, int, const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type &>(&QAbstractItemModel_Adaptor::cbs_match_c7932_2, start, role, value, hits, qt_gsi::CppToQtAdaptor<QFlags<Qt::MatchFlag> >(flags))).cref();
    } else {
      return QAbstractItemModel::match(start, role, value, hits, flags);
    }
  }

  //  [adaptor impl] QMimeData *QAbstractItemModel::mimeData(const QList<QModelIndex> &indexes)
  QMimeData * cbs_mimeData_c3010_0(const qt_gsi::Converter<QList<QModelIndex> >::target_type & indexes) const
  {
    return QAbstractItemModel::mimeData(qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(indexes).cref());
  }

  virtual QMimeData * mimeData(const QList<QModelIndex> &indexes) const
  {
    if (cb_mimeData_c3010_0.can_issue()) {
      return cb_mimeData_c3010_0.issue<QAbstractItemModel_Adaptor, QMimeData *, const qt_gsi::Converter<QList<QModelIndex> >::target_type &>(&QAbstractItemModel_Adaptor::cbs_mimeData_c3010_0, qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(indexes));
    } else {
      return QAbstractItemModel::mimeData(indexes);
    }
  }

  //  [adaptor impl] QStringList QAbstractItemModel::mimeTypes()
  qt_gsi::Converter<QStringList>::target_type cbs_mimeTypes_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QStringList>(QAbstractItemModel::mimeTypes());
  }

  virtual QStringList mimeTypes() const
  {
    if (cb_mimeTypes_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QStringList>(cb_mimeTypes_c0_0.issue<QAbstractItemModel_Adaptor, qt_gsi::Converter<QStringList>::target_type>(&QAbstractItemModel_Adaptor::cbs_mimeTypes_c0_0)).cref();
    } else {
      return QAbstractItemModel::mimeTypes();
    }
  }

  //  [adaptor impl] QModelIndex QAbstractItemModel::parent(const QModelIndex &child)
  QModelIndex cbs_parent_c2395_0(const QModelIndex &child) const
  {
    throw qt_gsi::AbstractMethodCalledException("parent");
  }

  virtual QModelIndex parent(const QModelIndex &child) const
  {
    if (cb_parent_c2395_0.can_issue()) {
      return cb_parent_c2395_0.issue<QAbstractItemModel_Adaptor, QModelIndex, const QModelIndex &>(&QAbstractItemModel_Adaptor::cbs_parent_c2395_0, child);
    } else {
      throw qt_gsi::AbstractMethodCalledException("parent");
    }
  }

  //  [adaptor impl] bool QAbstractItemModel::removeColumns(int column, int count, const QModelIndex &parent)
  bool cbs_removeColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QAbstractItemModel::removeColumns(column, count, parent);
  }

  virtual bool removeColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_removeColumns_3713_1.can_issue()) {
      return cb_removeColumns_3713_1.issue<QAbstractItemModel_Adaptor, bool, int, int, const QModelIndex &>(&QAbstractItemModel_Adaptor::cbs_removeColumns_3713_1, column, count, parent);
    } else {
      return QAbstractItemModel::removeColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QAbstractItemModel::removeRows(int row, int count, const QModelIndex &parent)
  bool cbs_removeRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QAbstractItemModel::removeRows(row, count, parent);
  }

  virtual bool removeRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_removeRows_3713_1.can_issue()) {
      return cb_removeRows_3713_1.issue<QAbstractItemModel_Adaptor, bool, int, int, const QModelIndex &>(&QAbstractItemModel_Adaptor::cbs_removeRows_3713_1, row, count, parent);
    } else {
      return QAbstractItemModel::removeRows(row, count, parent);
    }
  }

  //  [adaptor impl] void QAbstractItemModel::revert()
  void cbs_revert_0_0()
  {
    QAbstractItemModel::revert();
  }

  virtual void revert()
  {
    if (cb_revert_0_0.can_issue()) {
      cb_revert_0_0.issue<QAbstractItemModel_Adaptor>(&QAbstractItemModel_Adaptor::cbs_revert_0_0);
    } else {
      QAbstractItemModel::revert();
    }
  }

  //  [adaptor impl] int QAbstractItemModel::rowCount(const QModelIndex &parent)
  int cbs_rowCount_c2395_1(const QModelIndex &parent) const
  {
    throw qt_gsi::AbstractMethodCalledException("rowCount");
  }

  virtual int rowCount(const QModelIndex &parent) const
  {
    if (cb_rowCount_c2395_1.can_issue()) {
      return cb_rowCount_c2395_1.issue<QAbstractItemModel_Adaptor, int, const QModelIndex &>(&QAbstractItemModel_Adaptor::cbs_rowCount_c2395_1, parent);
    } else {
      throw qt_gsi::AbstractMethodCalledException("rowCount");
    }
  }

  //  [adaptor impl] bool QAbstractItemModel::setData(const QModelIndex &index, const QVariant &value, int role)
  bool cbs_setData_5065_1(const QModelIndex &index, const QVariant &value, int role)
  {
    return QAbstractItemModel::setData(index, value, role);
  }

  virtual bool setData(const QModelIndex &index, const QVariant &value, int role)
  {
    if (cb_setData_5065_1.can_issue()) {
      return cb_setData_5065_1.issue<QAbstractItemModel_Adaptor, bool, const QModelIndex &, const QVariant &, int>(&QAbstractItemModel_Adaptor::cbs_setData_5065_1, index, value, role);
    } else {
      return QAbstractItemModel::setData(index, value, role);
    }
  }

  //  [adaptor impl] bool QAbstractItemModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  bool cbs_setHeaderData_5242_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, const QVariant &value, int role)
  {
    return QAbstractItemModel::setHeaderData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), value, role);
  }

  virtual bool setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  {
    if (cb_setHeaderData_5242_1.can_issue()) {
      return cb_setHeaderData_5242_1.issue<QAbstractItemModel_Adaptor, bool, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, const QVariant &, int>(&QAbstractItemModel_Adaptor::cbs_setHeaderData_5242_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), value, role);
    } else {
      return QAbstractItemModel::setHeaderData(section, orientation, value, role);
    }
  }

  //  [adaptor impl] void QAbstractItemModel::sort(int column, Qt::SortOrder order)
  void cbs_sort_2340_1(int column, const qt_gsi::Converter<Qt::SortOrder>::target_type & order)
  {
    QAbstractItemModel::sort(column, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(order).cref());
  }

  virtual void sort(int column, Qt::SortOrder order)
  {
    if (cb_sort_2340_1.can_issue()) {
      cb_sort_2340_1.issue<QAbstractItemModel_Adaptor, int, const qt_gsi::Converter<Qt::SortOrder>::target_type &>(&QAbstractItemModel_Adaptor::cbs_sort_2340_1, column, qt_gsi::CppToQtAdaptor<Qt::SortOrder>(order));
    } else {
      QAbstractItemModel::sort(column, order);
    }
  }

  //  [adaptor impl] QSize QAbstractItemModel::span(const QModelIndex &index)
  QSize cbs_span_c2395_0(const QModelIndex &index) const
  {
    return QAbstractItemModel::span(index);
  }

  virtual QSize span(const QModelIndex &index) const
  {
    if (cb_span_c2395_0.can_issue()) {
      return cb_span_c2395_0.issue<QAbstractItemModel_Adaptor, QSize, const QModelIndex &>(&QAbstractItemModel_Adaptor::cbs_span_c2395_0, index);
    } else {
      return QAbstractItemModel::span(index);
    }
  }

  //  [adaptor impl] bool QAbstractItemModel::submit()
  bool cbs_submit_0_0()
  {
    return QAbstractItemModel::submit();
  }

  virtual bool submit()
  {
    if (cb_submit_0_0.can_issue()) {
      return cb_submit_0_0.issue<QAbstractItemModel_Adaptor, bool>(&QAbstractItemModel_Adaptor::cbs_submit_0_0);
    } else {
      return QAbstractItemModel::submit();
    }
  }

  //  [adaptor impl] QFlags<Qt::DropAction> QAbstractItemModel::supportedDropActions()
  qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type cbs_supportedDropActions_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QFlags<Qt::DropAction> >(QAbstractItemModel::supportedDropActions());
  }

  virtual QFlags<Qt::DropAction> supportedDropActions() const
  {
    if (cb_supportedDropActions_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QFlags<Qt::DropAction> >(cb_supportedDropActions_c0_0.issue<QAbstractItemModel_Adaptor, qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type>(&QAbstractItemModel_Adaptor::cbs_supportedDropActions_c0_0)).cref();
    } else {
      return QAbstractItemModel::supportedDropActions();
    }
  }

  //  [adaptor impl] void QAbstractItemModel::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QAbstractItemModel::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QAbstractItemModel_Adaptor, QChildEvent *>(&QAbstractItemModel_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QAbstractItemModel::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractItemModel::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QAbstractItemModel::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QAbstractItemModel_Adaptor, QEvent *>(&QAbstractItemModel_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QAbstractItemModel::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractItemModel::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QAbstractItemModel::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QAbstractItemModel_Adaptor, const char *>(&QAbstractItemModel_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QAbstractItemModel::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QAbstractItemModel::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QAbstractItemModel::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QAbstractItemModel_Adaptor, QTimerEvent *>(&QAbstractItemModel_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QAbstractItemModel::timerEvent(arg1);
    }
  }

  gsi::Callback cb_buddy_c2395_0;
  gsi::Callback cb_canFetchMore_c2395_0;
  gsi::Callback cb_columnCount_c2395_1;
  gsi::Callback cb_data_c3054_1;
  gsi::Callback cb_dropMimeData_7425_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_fetchMore_2395_0;
  gsi::Callback cb_flags_c2395_0;
  gsi::Callback cb_hasChildren_c2395_1;
  gsi::Callback cb_headerData_c3231_1;
  gsi::Callback cb_index_c3713_1;
  gsi::Callback cb_insertColumns_3713_1;
  gsi::Callback cb_insertRows_3713_1;
  gsi::Callback cb_match_c7932_2;
  gsi::Callback cb_mimeData_c3010_0;
  gsi::Callback cb_mimeTypes_c0_0;
  gsi::Callback cb_parent_c2395_0;
  gsi::Callback cb_removeColumns_3713_1;
  gsi::Callback cb_removeRows_3713_1;
  gsi::Callback cb_revert_0_0;
  gsi::Callback cb_rowCount_c2395_1;
  gsi::Callback cb_setData_5065_1;
  gsi::Callback cb_setHeaderData_5242_1;
  gsi::Callback cb_sort_2340_1;
  gsi::Callback cb_span_c2395_0;
  gsi::Callback cb_submit_0_0;
  gsi::Callback cb_supportedDropActions_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QAbstractItemModel_Adaptor::~QAbstractItemModel_Adaptor() { }

//  Constructor QAbstractItemModel::QAbstractItemModel(QObject *parent) (adaptor class)

static void _init_ctor_QAbstractItemModel_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QAbstractItemModel_Adaptor *> ();
}

static void _call_ctor_QAbstractItemModel_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QAbstractItemModel_Adaptor *> (new QAbstractItemModel_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QAbstractItemModel_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAbstractItemModel::QAbstractItemModel(QObject *parent)\nThis method creates an object of class QAbstractItemModel.", &_init_ctor_QAbstractItemModel_Adaptor_1302, &_call_ctor_QAbstractItemModel_Adaptor_1302);
}

// void QAbstractItemModel::beginInsertColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertColumns_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_beginInsertColumns_3713 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_beginInsertColumns_3713 ()
{
  return new qt_gsi::GenericMethod("*beginInsertColumns", "@brief Method void QAbstractItemModel::beginInsertColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertColumns_3713, &_call_fp_beginInsertColumns_3713);
}


// void QAbstractItemModel::beginInsertRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertRows_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_beginInsertRows_3713 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_beginInsertRows_3713 ()
{
  return new qt_gsi::GenericMethod("*beginInsertRows", "@brief Method void QAbstractItemModel::beginInsertRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertRows_3713, &_call_fp_beginInsertRows_3713);
}


// bool QAbstractItemModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)

static void _init_fp_beginMoveColumns_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationColumn");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveColumns_6659 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  const QModelIndex &arg4 = args.read<const QModelIndex & > ();
  int arg5 = args.read<int > ();
  ret.write<bool > ((bool)((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_beginMoveColumns_6659 (arg1, arg2, arg3, arg4, arg5));
}

static qt_gsi::GenericMethod*_create_fp_beginMoveColumns_6659 ()
{
  return new qt_gsi::GenericMethod("*beginMoveColumns", "@brief Method bool QAbstractItemModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveColumns_6659, &_call_fp_beginMoveColumns_6659);
}


// bool QAbstractItemModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)

static void _init_fp_beginMoveRows_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationRow");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveRows_6659 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  const QModelIndex &arg4 = args.read<const QModelIndex & > ();
  int arg5 = args.read<int > ();
  ret.write<bool > ((bool)((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_beginMoveRows_6659 (arg1, arg2, arg3, arg4, arg5));
}

static qt_gsi::GenericMethod*_create_fp_beginMoveRows_6659 ()
{
  return new qt_gsi::GenericMethod("*beginMoveRows", "@brief Method bool QAbstractItemModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveRows_6659, &_call_fp_beginMoveRows_6659);
}


// void QAbstractItemModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveColumns_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_beginRemoveColumns_3713 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_beginRemoveColumns_3713 ()
{
  return new qt_gsi::GenericMethod("*beginRemoveColumns", "@brief Method void QAbstractItemModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveColumns_3713, &_call_fp_beginRemoveColumns_3713);
}


// void QAbstractItemModel::beginRemoveRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveRows_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_beginRemoveRows_3713 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_beginRemoveRows_3713 ()
{
  return new qt_gsi::GenericMethod("*beginRemoveRows", "@brief Method void QAbstractItemModel::beginRemoveRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveRows_3713, &_call_fp_beginRemoveRows_3713);
}


// void QAbstractItemModel::beginResetModel()

static void _init_fp_beginResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_beginResetModel_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_beginResetModel_0 ();
}

static qt_gsi::GenericMethod*_create_fp_beginResetModel_0 ()
{
  return new qt_gsi::GenericMethod("*beginResetModel", "@brief Method void QAbstractItemModel::beginResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginResetModel_0, &_call_fp_beginResetModel_0);
}


// void QAbstractItemModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)

static void _init_fp_changePersistentIndex_4682 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndex_4682 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_changePersistentIndex_4682 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_changePersistentIndex_4682 ()
{
  return new qt_gsi::GenericMethod("*changePersistentIndex", "@brief Method void QAbstractItemModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndex_4682, &_call_fp_changePersistentIndex_4682);
}


// void QAbstractItemModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)

static void _init_fp_changePersistentIndexList_5912 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndexList_5912 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QModelIndex> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > ();
  const qt_gsi::Converter<QList<QModelIndex> >::target_type & arg2 = args.read<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > ();
  ((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_changePersistentIndexList_5912 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_changePersistentIndexList_5912 ()
{
  return new qt_gsi::GenericMethod("*changePersistentIndexList", "@brief Method void QAbstractItemModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndexList_5912, &_call_fp_changePersistentIndexList_5912);
}


// QModelIndex QAbstractItemModel::createIndex(int row, int column, void *data)

static void _init_fp_createIndex_c2374 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("data", true, "0");
  decl->add_arg<void * > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2374 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  void *arg3 = args ? args.read<void * > () : (void *)(0);
  ret.write<QModelIndex > ((QModelIndex)((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_createIndex_c2374 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_createIndex_c2374 ()
{
  return new qt_gsi::GenericMethod("*createIndex", "@brief Method QModelIndex QAbstractItemModel::createIndex(int row, int column, void *data)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2374, &_call_fp_createIndex_c2374);
}


// QModelIndex QAbstractItemModel::createIndex(int row, int column, int id)

static void _init_fp_createIndex_c2085 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("id");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2085 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ret.write<QModelIndex > ((QModelIndex)((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_createIndex_c2085 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_createIndex_c2085 ()
{
  return new qt_gsi::GenericMethod("*createIndex", "@brief Method QModelIndex QAbstractItemModel::createIndex(int row, int column, int id)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2085, &_call_fp_createIndex_c2085);
}


// QModelIndex QAbstractItemModel::createIndex(int row, int column, quint32 id)

static void _init_fp_createIndex_c2416 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("id");
  decl->add_arg<quint32 > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2416 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  quint32 arg3 = args.read<quint32 > ();
  ret.write<QModelIndex > ((QModelIndex)((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_createIndex_c2416 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_createIndex_c2416 ()
{
  return new qt_gsi::GenericMethod("*createIndex", "@brief Method QModelIndex QAbstractItemModel::createIndex(int row, int column, quint32 id)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2416, &_call_fp_createIndex_c2416);
}


// bool QAbstractItemModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)

static void _init_fp_decodeData_5302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("stream");
  decl->add_arg<QDataStream & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_fp_decodeData_5302 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  QDataStream &arg4 = args.read<QDataStream & > ();
  ret.write<bool > ((bool)((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_decodeData_5302 (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericMethod*_create_fp_decodeData_5302 ()
{
  return new qt_gsi::GenericMethod("*decodeData", "@brief Method bool QAbstractItemModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_decodeData_5302, &_call_fp_decodeData_5302);
}


// void QAbstractItemModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)

static void _init_fp_encodeData_c4599 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stream");
  decl->add_arg<QDataStream & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_encodeData_c4599 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QModelIndex> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > ();
  QDataStream &arg2 = args.read<QDataStream & > ();
  ((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_encodeData_c4599 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_encodeData_c4599 ()
{
  return new qt_gsi::GenericMethod("*encodeData", "@brief Method void QAbstractItemModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_encodeData_c4599, &_call_fp_encodeData_c4599);
}


// void QAbstractItemModel::endInsertColumns()

static void _init_fp_endInsertColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertColumns_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_endInsertColumns_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endInsertColumns_0 ()
{
  return new qt_gsi::GenericMethod("*endInsertColumns", "@brief Method void QAbstractItemModel::endInsertColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertColumns_0, &_call_fp_endInsertColumns_0);
}


// void QAbstractItemModel::endInsertRows()

static void _init_fp_endInsertRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertRows_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_endInsertRows_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endInsertRows_0 ()
{
  return new qt_gsi::GenericMethod("*endInsertRows", "@brief Method void QAbstractItemModel::endInsertRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertRows_0, &_call_fp_endInsertRows_0);
}


// void QAbstractItemModel::endMoveColumns()

static void _init_fp_endMoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveColumns_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_endMoveColumns_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endMoveColumns_0 ()
{
  return new qt_gsi::GenericMethod("*endMoveColumns", "@brief Method void QAbstractItemModel::endMoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveColumns_0, &_call_fp_endMoveColumns_0);
}


// void QAbstractItemModel::endMoveRows()

static void _init_fp_endMoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveRows_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_endMoveRows_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endMoveRows_0 ()
{
  return new qt_gsi::GenericMethod("*endMoveRows", "@brief Method void QAbstractItemModel::endMoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveRows_0, &_call_fp_endMoveRows_0);
}


// void QAbstractItemModel::endRemoveColumns()

static void _init_fp_endRemoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveColumns_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_endRemoveColumns_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endRemoveColumns_0 ()
{
  return new qt_gsi::GenericMethod("*endRemoveColumns", "@brief Method void QAbstractItemModel::endRemoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveColumns_0, &_call_fp_endRemoveColumns_0);
}


// void QAbstractItemModel::endRemoveRows()

static void _init_fp_endRemoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveRows_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_endRemoveRows_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endRemoveRows_0 ()
{
  return new qt_gsi::GenericMethod("*endRemoveRows", "@brief Method void QAbstractItemModel::endRemoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveRows_0, &_call_fp_endRemoveRows_0);
}


// void QAbstractItemModel::endResetModel()

static void _init_fp_endResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endResetModel_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_endResetModel_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endResetModel_0 ()
{
  return new qt_gsi::GenericMethod("*endResetModel", "@brief Method void QAbstractItemModel::endResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endResetModel_0, &_call_fp_endResetModel_0);
}


// QList<QModelIndex> QAbstractItemModel::persistentIndexList()

static void _init_fp_persistentIndexList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QModelIndex> >::target_type > ();
}

static void _call_fp_persistentIndexList_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QModelIndex> >::target_type > ((qt_gsi::Converter<QList<QModelIndex> >::target_type)((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_persistentIndexList_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_persistentIndexList_c0 ()
{
  return new qt_gsi::GenericMethod("*persistentIndexList", "@brief Method QList<QModelIndex> QAbstractItemModel::persistentIndexList()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_persistentIndexList_c0, &_call_fp_persistentIndexList_c0);
}


// int QAbstractItemModel::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QAbstractItemModel::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QAbstractItemModel::reset()

static void _init_fp_reset_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_reset_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_reset_0 ();
}

static qt_gsi::GenericMethod*_create_fp_reset_0 ()
{
  return new qt_gsi::GenericMethod("*reset", "@brief Method void QAbstractItemModel::reset()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_reset_0, &_call_fp_reset_0);
}


// QObject *QAbstractItemModel::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QAbstractItemModel_Adaptor *)cls)->fp_QAbstractItemModel_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QAbstractItemModel::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// QModelIndex QAbstractItemModel::buddy(const QModelIndex &index)

static void _init_cbs_buddy_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_buddy_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QModelIndex > ((QModelIndex)((QAbstractItemModel_Adaptor *)cls)->cbs_buddy_c2395_0 (arg1));
}

static void _set_callback_cbs_buddy_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_buddy_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_buddy_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("buddy", "@hide", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_buddy_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("buddy", "@brief Virtual method QModelIndex QAbstractItemModel::buddy(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0, &_set_callback_cbs_buddy_c2395_0);
}


// bool QAbstractItemModel::canFetchMore(const QModelIndex &parent)

static void _init_cbs_canFetchMore_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_canFetchMore_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QAbstractItemModel_Adaptor *)cls)->cbs_canFetchMore_c2395_0 (arg1));
}

static void _set_callback_cbs_canFetchMore_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_canFetchMore_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_canFetchMore_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("canFetchMore", "@hide", true, &_init_cbs_canFetchMore_c2395_0, &_call_cbs_canFetchMore_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_canFetchMore_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("canFetchMore", "@brief Virtual method bool QAbstractItemModel::canFetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canFetchMore_c2395_0, &_call_cbs_canFetchMore_c2395_0, &_set_callback_cbs_canFetchMore_c2395_0);
}


// int QAbstractItemModel::columnCount(const QModelIndex &parent)

static void _init_cbs_columnCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_columnCount_c2395_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<int > ((int)((QAbstractItemModel_Adaptor *)cls)->cbs_columnCount_c2395_1 (arg1));
}

static void _set_callback_cbs_columnCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_columnCount_c2395_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_columnCount_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("columnCount", "@hide", true, &_init_cbs_columnCount_c2395_1, &_call_cbs_columnCount_c2395_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_columnCount_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("columnCount", "@brief Virtual method int QAbstractItemModel::columnCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_columnCount_c2395_1, &_call_cbs_columnCount_c2395_1, &_set_callback_cbs_columnCount_c2395_1);
}


// QVariant QAbstractItemModel::data(const QModelIndex &index, int role)

static void _init_cbs_data_c3054_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_data_c3054_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  ret.write<QVariant > ((QVariant)((QAbstractItemModel_Adaptor *)cls)->cbs_data_c3054_1 (arg1, arg2));
}

static void _set_callback_cbs_data_c3054_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_data_c3054_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_data_c3054_1 ()
{
  return new qt_gsi::GenericMethod ("data", "@hide", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_data_c3054_1 ()
{
  return new qt_gsi::GenericMethod ("data", "@brief Virtual method QVariant QAbstractItemModel::data(const QModelIndex &index, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1, &_set_callback_cbs_data_c3054_1);
}


// bool QAbstractItemModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)

static void _init_cbs_dropMimeData_7425_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_dropMimeData_7425_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMimeData *arg1 = args.read<const QMimeData * > ();
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  const QModelIndex &arg5 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QAbstractItemModel_Adaptor *)cls)->cbs_dropMimeData_7425_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_dropMimeData_7425_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_dropMimeData_7425_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropMimeData_7425_0 ()
{
  return new qt_gsi::GenericMethod ("dropMimeData", "@hide", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropMimeData_7425_0 ()
{
  return new qt_gsi::GenericMethod ("dropMimeData", "@brief Virtual method bool QAbstractItemModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0, &_set_callback_cbs_dropMimeData_7425_0);
}


// bool QAbstractItemModel::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QAbstractItemModel_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QAbstractItemModel::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QAbstractItemModel::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QAbstractItemModel_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QAbstractItemModel::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QAbstractItemModel::fetchMore(const QModelIndex &parent)

static void _init_cbs_fetchMore_2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fetchMore_2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ((QAbstractItemModel_Adaptor *)cls)->cbs_fetchMore_2395_0 (arg1);
}

static void _set_callback_cbs_fetchMore_2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_fetchMore_2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fetchMore_2395_0 ()
{
  return new qt_gsi::GenericMethod ("fetchMore", "@hide", false, &_init_cbs_fetchMore_2395_0, &_call_cbs_fetchMore_2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fetchMore_2395_0 ()
{
  return new qt_gsi::GenericMethod ("fetchMore", "@brief Virtual method void QAbstractItemModel::fetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fetchMore_2395_0, &_call_cbs_fetchMore_2395_0, &_set_callback_cbs_fetchMore_2395_0);
}


// QFlags<Qt::ItemFlag> QAbstractItemModel::flags(const QModelIndex &index)

static void _init_cbs_flags_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type > ();
}

static void _call_cbs_flags_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type > ((qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type)((QAbstractItemModel_Adaptor *)cls)->cbs_flags_c2395_0 (arg1));
}

static void _set_callback_cbs_flags_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_flags_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_flags_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("flags", "@hide", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_flags_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("flags", "@brief Virtual method QFlags<Qt::ItemFlag> QAbstractItemModel::flags(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0, &_set_callback_cbs_flags_c2395_0);
}


// bool QAbstractItemModel::hasChildren(const QModelIndex &parent)

static void _init_cbs_hasChildren_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_hasChildren_c2395_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QAbstractItemModel_Adaptor *)cls)->cbs_hasChildren_c2395_1 (arg1));
}

static void _set_callback_cbs_hasChildren_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_hasChildren_c2395_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hasChildren_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("hasChildren", "@hide", true, &_init_cbs_hasChildren_c2395_1, &_call_cbs_hasChildren_c2395_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hasChildren_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("hasChildren", "@brief Virtual method bool QAbstractItemModel::hasChildren(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasChildren_c2395_1, &_call_cbs_hasChildren_c2395_1, &_set_callback_cbs_hasChildren_c2395_1);
}


// QVariant QAbstractItemModel::headerData(int section, Qt::Orientation orientation, int role)

static void _init_cbs_headerData_c3231_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_cbs_headerData_c3231_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  int arg3 = args.read<int > ();
  ret.write<QVariant > ((QVariant)((QAbstractItemModel_Adaptor *)cls)->cbs_headerData_c3231_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_headerData_c3231_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_headerData_c3231_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_headerData_c3231_1 ()
{
  return new qt_gsi::GenericMethod ("headerData", "@hide", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_headerData_c3231_1 ()
{
  return new qt_gsi::GenericMethod ("headerData", "@brief Virtual method QVariant QAbstractItemModel::headerData(int section, Qt::Orientation orientation, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1, &_set_callback_cbs_headerData_c3231_1);
}


// QModelIndex QAbstractItemModel::index(int row, int column, const QModelIndex &parent)

static void _init_cbs_index_c3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_index_c3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<QModelIndex > ((QModelIndex)((QAbstractItemModel_Adaptor *)cls)->cbs_index_c3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_index_c3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_index_c3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_index_c3713_1 ()
{
  return new qt_gsi::GenericMethod ("index", "@hide", true, &_init_cbs_index_c3713_1, &_call_cbs_index_c3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_index_c3713_1 ()
{
  return new qt_gsi::GenericMethod ("index", "@brief Virtual method QModelIndex QAbstractItemModel::index(int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_index_c3713_1, &_call_cbs_index_c3713_1, &_set_callback_cbs_index_c3713_1);
}


// bool QAbstractItemModel::insertColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_insertColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertColumns_3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QAbstractItemModel_Adaptor *)cls)->cbs_insertColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_insertColumns_3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_insertColumns_3713_1 ()
{
  return new qt_gsi::GenericMethod ("insertColumns", "@hide", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_insertColumns_3713_1 ()
{
  return new qt_gsi::GenericMethod ("insertColumns", "@brief Virtual method bool QAbstractItemModel::insertColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1, &_set_callback_cbs_insertColumns_3713_1);
}


// bool QAbstractItemModel::insertRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_insertRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertRows_3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QAbstractItemModel_Adaptor *)cls)->cbs_insertRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_insertRows_3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_insertRows_3713_1 ()
{
  return new qt_gsi::GenericMethod ("insertRows", "@hide", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_insertRows_3713_1 ()
{
  return new qt_gsi::GenericMethod ("insertRows", "@brief Virtual method bool QAbstractItemModel::insertRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1, &_set_callback_cbs_insertRows_3713_1);
}


// QList<QModelIndex> QAbstractItemModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)

static void _init_cbs_match_c7932_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("start");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("hits");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("flags");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & > (argspec_4);
  decl->set_return<qt_gsi::Converter<QList<QModelIndex> >::target_type > ();
}

static void _call_cbs_match_c7932_2 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  const QVariant &arg3 = args.read<const QVariant & > ();
  int arg4 = args.read<int > ();
  const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & arg5 = args.read<const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & > ();
  ret.write<qt_gsi::Converter<QList<QModelIndex> >::target_type > ((qt_gsi::Converter<QList<QModelIndex> >::target_type)((QAbstractItemModel_Adaptor *)cls)->cbs_match_c7932_2 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_match_c7932_2 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_match_c7932_2 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_match_c7932_2 ()
{
  return new qt_gsi::GenericMethod ("match", "@hide", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2);
}

static qt_gsi::GenericMethod *_create_callback_cbs_match_c7932_2 ()
{
  return new qt_gsi::GenericMethod ("match", "@brief Virtual method QList<QModelIndex> QAbstractItemModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2, &_set_callback_cbs_match_c7932_2);
}


// QMimeData *QAbstractItemModel::mimeData(const QList<QModelIndex> &indexes)

static void _init_cbs_mimeData_c3010_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > (argspec_0);
  decl->set_return<QMimeData * > ();
}

static void _call_cbs_mimeData_c3010_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QModelIndex> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > ();
  ret.write<QMimeData * > ((QMimeData *)((QAbstractItemModel_Adaptor *)cls)->cbs_mimeData_c3010_0 (arg1));
}

static void _set_callback_cbs_mimeData_c3010_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_mimeData_c3010_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mimeData_c3010_0 ()
{
  return new qt_gsi::GenericMethod ("mimeData", "@hide", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mimeData_c3010_0 ()
{
  return new qt_gsi::GenericMethod ("mimeData", "@brief Virtual method QMimeData *QAbstractItemModel::mimeData(const QList<QModelIndex> &indexes)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0, &_set_callback_cbs_mimeData_c3010_0);
}


// QStringList QAbstractItemModel::mimeTypes()

static void _init_cbs_mimeTypes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_cbs_mimeTypes_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)((QAbstractItemModel_Adaptor *)cls)->cbs_mimeTypes_c0_0 ());
}

static void _set_callback_cbs_mimeTypes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_mimeTypes_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mimeTypes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("mimeTypes", "@hide", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mimeTypes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("mimeTypes", "@brief Virtual method QStringList QAbstractItemModel::mimeTypes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0, &_set_callback_cbs_mimeTypes_c0_0);
}


// QModelIndex QAbstractItemModel::parent(const QModelIndex &child)

static void _init_cbs_parent_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("child");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_parent_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QModelIndex > ((QModelIndex)((QAbstractItemModel_Adaptor *)cls)->cbs_parent_c2395_0 (arg1));
}

static void _set_callback_cbs_parent_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_parent_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_parent_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("parent", "@hide", true, &_init_cbs_parent_c2395_0, &_call_cbs_parent_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_parent_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("parent", "@brief Virtual method QModelIndex QAbstractItemModel::parent(const QModelIndex &child)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_parent_c2395_0, &_call_cbs_parent_c2395_0, &_set_callback_cbs_parent_c2395_0);
}


// bool QAbstractItemModel::removeColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_removeColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeColumns_3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QAbstractItemModel_Adaptor *)cls)->cbs_removeColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_removeColumns_3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_removeColumns_3713_1 ()
{
  return new qt_gsi::GenericMethod ("removeColumns", "@hide", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_removeColumns_3713_1 ()
{
  return new qt_gsi::GenericMethod ("removeColumns", "@brief Virtual method bool QAbstractItemModel::removeColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1, &_set_callback_cbs_removeColumns_3713_1);
}


// bool QAbstractItemModel::removeRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_removeRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeRows_3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QAbstractItemModel_Adaptor *)cls)->cbs_removeRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_removeRows_3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_removeRows_3713_1 ()
{
  return new qt_gsi::GenericMethod ("removeRows", "@hide", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_removeRows_3713_1 ()
{
  return new qt_gsi::GenericMethod ("removeRows", "@brief Virtual method bool QAbstractItemModel::removeRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1, &_set_callback_cbs_removeRows_3713_1);
}


// void QAbstractItemModel::revert()

static void _init_cbs_revert_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_revert_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractItemModel_Adaptor *)cls)->cbs_revert_0_0 ();
}

static void _set_callback_cbs_revert_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_revert_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_revert_0_0 ()
{
  return new qt_gsi::GenericMethod ("revert", "@hide", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_revert_0_0 ()
{
  return new qt_gsi::GenericMethod ("revert", "@brief Virtual method void QAbstractItemModel::revert()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0, &_set_callback_cbs_revert_0_0);
}


// int QAbstractItemModel::rowCount(const QModelIndex &parent)

static void _init_cbs_rowCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_rowCount_c2395_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<int > ((int)((QAbstractItemModel_Adaptor *)cls)->cbs_rowCount_c2395_1 (arg1));
}

static void _set_callback_cbs_rowCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_rowCount_c2395_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_rowCount_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("rowCount", "@hide", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_rowCount_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("rowCount", "@brief Virtual method int QAbstractItemModel::rowCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1, &_set_callback_cbs_rowCount_c2395_1);
}


// bool QAbstractItemModel::setData(const QModelIndex &index, const QVariant &value, int role)

static void _init_cbs_setData_5065_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_setData_5065_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  int arg3 = args.read<int > ();
  ret.write<bool > ((bool)((QAbstractItemModel_Adaptor *)cls)->cbs_setData_5065_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_setData_5065_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_setData_5065_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setData_5065_1 ()
{
  return new qt_gsi::GenericMethod ("setData", "@hide", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setData_5065_1 ()
{
  return new qt_gsi::GenericMethod ("setData", "@brief Virtual method bool QAbstractItemModel::setData(const QModelIndex &index, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1, &_set_callback_cbs_setData_5065_1);
}


// bool QAbstractItemModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)

static void _init_cbs_setHeaderData_5242_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("role");
  decl->add_arg<int > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_cbs_setHeaderData_5242_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  const QVariant &arg3 = args.read<const QVariant & > ();
  int arg4 = args.read<int > ();
  ret.write<bool > ((bool)((QAbstractItemModel_Adaptor *)cls)->cbs_setHeaderData_5242_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_setHeaderData_5242_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_setHeaderData_5242_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setHeaderData_5242_1 ()
{
  return new qt_gsi::GenericMethod ("setHeaderData", "@hide", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setHeaderData_5242_1 ()
{
  return new qt_gsi::GenericMethod ("setHeaderData", "@brief Virtual method bool QAbstractItemModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1, &_set_callback_cbs_setHeaderData_5242_1);
}


// void QAbstractItemModel::sort(int column, Qt::SortOrder order)

static void _init_cbs_sort_2340_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_sort_2340_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > ();
  ((QAbstractItemModel_Adaptor *)cls)->cbs_sort_2340_1 (arg1, arg2);
}

static void _set_callback_cbs_sort_2340_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_sort_2340_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sort_2340_1 ()
{
  return new qt_gsi::GenericMethod ("sort", "@hide", false, &_init_cbs_sort_2340_1, &_call_cbs_sort_2340_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sort_2340_1 ()
{
  return new qt_gsi::GenericMethod ("sort", "@brief Virtual method void QAbstractItemModel::sort(int column, Qt::SortOrder order)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sort_2340_1, &_call_cbs_sort_2340_1, &_set_callback_cbs_sort_2340_1);
}


// QSize QAbstractItemModel::span(const QModelIndex &index)

static void _init_cbs_span_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QSize > ();
}

static void _call_cbs_span_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QSize > ((QSize)((QAbstractItemModel_Adaptor *)cls)->cbs_span_c2395_0 (arg1));
}

static void _set_callback_cbs_span_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_span_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_span_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("span", "@hide", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_span_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("span", "@brief Virtual method QSize QAbstractItemModel::span(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0, &_set_callback_cbs_span_c2395_0);
}


// bool QAbstractItemModel::submit()

static void _init_cbs_submit_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_submit_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QAbstractItemModel_Adaptor *)cls)->cbs_submit_0_0 ());
}

static void _set_callback_cbs_submit_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_submit_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_submit_0_0 ()
{
  return new qt_gsi::GenericMethod ("submit", "@hide", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_submit_0_0 ()
{
  return new qt_gsi::GenericMethod ("submit", "@brief Virtual method bool QAbstractItemModel::submit()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0, &_set_callback_cbs_submit_0_0);
}


// QFlags<Qt::DropAction> QAbstractItemModel::supportedDropActions()

static void _init_cbs_supportedDropActions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ();
}

static void _call_cbs_supportedDropActions_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ((qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type)((QAbstractItemModel_Adaptor *)cls)->cbs_supportedDropActions_c0_0 ());
}

static void _set_callback_cbs_supportedDropActions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_supportedDropActions_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_supportedDropActions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("supportedDropActions", "@hide", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_supportedDropActions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("supportedDropActions", "@brief Virtual method QFlags<Qt::DropAction> QAbstractItemModel::supportedDropActions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0, &_set_callback_cbs_supportedDropActions_c0_0);
}


// void QAbstractItemModel::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QAbstractItemModel_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QAbstractItemModel::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QAbstractItemModel::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QAbstractItemModel_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QAbstractItemModel::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QAbstractItemModel::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QAbstractItemModel_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QAbstractItemModel::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QAbstractItemModel::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QAbstractItemModel_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractItemModel_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QAbstractItemModel::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QAbstractItemModel> decl_QAbstractItemModel;

gsi::Class<QAbstractItemModel_Adaptor> decl_QAbstractItemModel_Adaptor (decl_QAbstractItemModel, "QAbstractItemModel",
  gsi::Methods(_create_fp_beginInsertColumns_3713 ()) +
  gsi::Methods(_create_fp_beginInsertRows_3713 ()) +
  gsi::Methods(_create_fp_beginMoveColumns_6659 ()) +
  gsi::Methods(_create_fp_beginMoveRows_6659 ()) +
  gsi::Methods(_create_fp_beginRemoveColumns_3713 ()) +
  gsi::Methods(_create_fp_beginRemoveRows_3713 ()) +
  gsi::Methods(_create_fp_beginResetModel_0 ()) +
  gsi::Methods(_create_fp_changePersistentIndex_4682 ()) +
  gsi::Methods(_create_fp_changePersistentIndexList_5912 ()) +
  gsi::Methods(_create_fp_createIndex_c2374 ()) +
  gsi::Methods(_create_fp_createIndex_c2085 ()) +
  gsi::Methods(_create_fp_createIndex_c2416 ()) +
  gsi::Methods(_create_fp_decodeData_5302 ()) +
  gsi::Methods(_create_fp_encodeData_c4599 ()) +
  gsi::Methods(_create_fp_endInsertColumns_0 ()) +
  gsi::Methods(_create_fp_endInsertRows_0 ()) +
  gsi::Methods(_create_fp_endMoveColumns_0 ()) +
  gsi::Methods(_create_fp_endMoveRows_0 ()) +
  gsi::Methods(_create_fp_endRemoveColumns_0 ()) +
  gsi::Methods(_create_fp_endRemoveRows_0 ()) +
  gsi::Methods(_create_fp_endResetModel_0 ()) +
  gsi::Methods(_create_fp_persistentIndexList_c0 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_reset_0 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_buddy_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_buddy_c2395_0 ()) +
  gsi::Methods(_create_cbs_canFetchMore_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_canFetchMore_c2395_0 ()) +
  gsi::Methods(_create_cbs_columnCount_c2395_1 ()) +
  gsi::Methods(_create_callback_cbs_columnCount_c2395_1 ()) +
  gsi::Methods(_create_cbs_data_c3054_1 ()) +
  gsi::Methods(_create_callback_cbs_data_c3054_1 ()) +
  gsi::Methods(_create_cbs_dropMimeData_7425_0 ()) +
  gsi::Methods(_create_callback_cbs_dropMimeData_7425_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_fetchMore_2395_0 ()) +
  gsi::Methods(_create_callback_cbs_fetchMore_2395_0 ()) +
  gsi::Methods(_create_cbs_flags_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_flags_c2395_0 ()) +
  gsi::Methods(_create_cbs_hasChildren_c2395_1 ()) +
  gsi::Methods(_create_callback_cbs_hasChildren_c2395_1 ()) +
  gsi::Methods(_create_cbs_headerData_c3231_1 ()) +
  gsi::Methods(_create_callback_cbs_headerData_c3231_1 ()) +
  gsi::Methods(_create_cbs_index_c3713_1 ()) +
  gsi::Methods(_create_callback_cbs_index_c3713_1 ()) +
  gsi::Methods(_create_cbs_insertColumns_3713_1 ()) +
  gsi::Methods(_create_callback_cbs_insertColumns_3713_1 ()) +
  gsi::Methods(_create_cbs_insertRows_3713_1 ()) +
  gsi::Methods(_create_callback_cbs_insertRows_3713_1 ()) +
  gsi::Methods(_create_cbs_match_c7932_2 ()) +
  gsi::Methods(_create_callback_cbs_match_c7932_2 ()) +
  gsi::Methods(_create_cbs_mimeData_c3010_0 ()) +
  gsi::Methods(_create_callback_cbs_mimeData_c3010_0 ()) +
  gsi::Methods(_create_cbs_mimeTypes_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_mimeTypes_c0_0 ()) +
  gsi::Methods(_create_cbs_parent_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_parent_c2395_0 ()) +
  gsi::Methods(_create_cbs_removeColumns_3713_1 ()) +
  gsi::Methods(_create_callback_cbs_removeColumns_3713_1 ()) +
  gsi::Methods(_create_cbs_removeRows_3713_1 ()) +
  gsi::Methods(_create_callback_cbs_removeRows_3713_1 ()) +
  gsi::Methods(_create_cbs_revert_0_0 ()) +
  gsi::Methods(_create_callback_cbs_revert_0_0 ()) +
  gsi::Methods(_create_cbs_rowCount_c2395_1 ()) +
  gsi::Methods(_create_callback_cbs_rowCount_c2395_1 ()) +
  gsi::Methods(_create_cbs_setData_5065_1 ()) +
  gsi::Methods(_create_callback_cbs_setData_5065_1 ()) +
  gsi::Methods(_create_cbs_setHeaderData_5242_1 ()) +
  gsi::Methods(_create_callback_cbs_setHeaderData_5242_1 ()) +
  gsi::Methods(_create_cbs_sort_2340_1 ()) +
  gsi::Methods(_create_callback_cbs_sort_2340_1 ()) +
  gsi::Methods(_create_cbs_span_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_span_c2395_0 ()) +
  gsi::Methods(_create_cbs_submit_0_0 ()) +
  gsi::Methods(_create_callback_cbs_submit_0_0 ()) +
  gsi::Methods(_create_cbs_supportedDropActions_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_supportedDropActions_c0_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QAbstractItemModel_Adaptor_1302 ()),
  "@qt\n@brief Binding of QAbstractItemModel");

}

