
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTextCodec.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQTextCodec_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTextCodec

// QList<QByteArray> QTextCodec::aliases()


static void _init_f_aliases_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QByteArray> >::target_type > ();
}

static void _call_f_aliases_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QByteArray> >::target_type > ((qt_gsi::Converter<QList<QByteArray> >::target_type)qt_gsi::CppToQtAdaptor<QList<QByteArray> >(((QTextCodec *)cls)->aliases ()));
}

static qt_gsi::GenericMethod *_create_f_aliases_c0 ()
{
  return new qt_gsi::GenericMethod ("aliases", "@brief Method QList<QByteArray> QTextCodec::aliases()\n", true, &_init_f_aliases_c0, &_call_f_aliases_c0);
}

// bool QTextCodec::canEncode(QChar)


static void _init_f_canEncode_c899 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QChar>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_canEncode_c899 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QChar>::target_type & arg1 = args.read<const qt_gsi::Converter<QChar>::target_type & > ();
  ret.write<bool > ((bool)((QTextCodec *)cls)->canEncode (qt_gsi::QtToCppAdaptor<QChar>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_canEncode_c899 ()
{
  return new qt_gsi::GenericMethod ("canEncode", "@brief Method bool QTextCodec::canEncode(QChar)\n", true, &_init_f_canEncode_c899, &_call_f_canEncode_c899);
}

// bool QTextCodec::canEncode(const QString &)


static void _init_f_canEncode_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_canEncode_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QTextCodec *)cls)->canEncode (arg1));
}

static qt_gsi::GenericMethod *_create_f_canEncode_c2025 ()
{
  return new qt_gsi::GenericMethod ("canEncode", "@brief Method bool QTextCodec::canEncode(const QString &)\n", true, &_init_f_canEncode_c2025, &_call_f_canEncode_c2025);
}

// QByteArray QTextCodec::fromUnicode(const QString &uc)


static void _init_f_fromUnicode_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("uc");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_fromUnicode_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QByteArray > ((QByteArray)((QTextCodec *)cls)->fromUnicode (arg1));
}

static qt_gsi::GenericMethod *_create_f_fromUnicode_c2025 ()
{
  return new qt_gsi::GenericMethod ("fromUnicode", "@brief Method QByteArray QTextCodec::fromUnicode(const QString &uc)\n", true, &_init_f_fromUnicode_c2025, &_call_f_fromUnicode_c2025);
}

// QTextDecoder *QTextCodec::makeDecoder()


static void _init_f_makeDecoder_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextDecoder * > ();
}

static void _call_f_makeDecoder_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextDecoder * > ((QTextDecoder *)((QTextCodec *)cls)->makeDecoder ());
}

static qt_gsi::GenericMethod *_create_f_makeDecoder_c0 ()
{
  return new qt_gsi::GenericMethod ("makeDecoder", "@brief Method QTextDecoder *QTextCodec::makeDecoder()\n", true, &_init_f_makeDecoder_c0, &_call_f_makeDecoder_c0);
}

// QTextEncoder *QTextCodec::makeEncoder()


static void _init_f_makeEncoder_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextEncoder * > ();
}

static void _call_f_makeEncoder_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextEncoder * > ((QTextEncoder *)((QTextCodec *)cls)->makeEncoder ());
}

static qt_gsi::GenericMethod *_create_f_makeEncoder_c0 ()
{
  return new qt_gsi::GenericMethod ("makeEncoder", "@brief Method QTextEncoder *QTextCodec::makeEncoder()\n", true, &_init_f_makeEncoder_c0, &_call_f_makeEncoder_c0);
}

// int QTextCodec::mibEnum()


static void _init_f_mibEnum_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_mibEnum_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextCodec *)cls)->mibEnum ());
}

static qt_gsi::GenericMethod *_create_f_mibEnum_c0 ()
{
  return new qt_gsi::GenericMethod ("mibEnum", "@brief Method int QTextCodec::mibEnum()\n", true, &_init_f_mibEnum_c0, &_call_f_mibEnum_c0);
}

// QByteArray QTextCodec::name()


static void _init_f_name_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_name_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray > ((QByteArray)((QTextCodec *)cls)->name ());
}

static qt_gsi::GenericMethod *_create_f_name_c0 ()
{
  return new qt_gsi::GenericMethod ("name", "@brief Method QByteArray QTextCodec::name()\n", true, &_init_f_name_c0, &_call_f_name_c0);
}

// QString QTextCodec::toUnicode(const char *chars)


static void _init_f_toUnicode_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("chars");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toUnicode_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<QString > ((QString)((QTextCodec *)cls)->toUnicode (arg1));
}

static qt_gsi::GenericMethod *_create_f_toUnicode_c1731 ()
{
  return new qt_gsi::GenericMethod ("toUnicode", "@brief Method QString QTextCodec::toUnicode(const char *chars)\n", true, &_init_f_toUnicode_c1731, &_call_f_toUnicode_c1731);
}

// QString QTextCodec::toUnicode(const char *in, int length, QTextCodec::ConverterState *state)


static void _init_f_toUnicode_c5465 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("in");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("length");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("state", true, "0");
  decl->add_arg<QTextCodec::ConverterState * > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_toUnicode_c5465 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  int arg2 = args.read<int > ();
  QTextCodec::ConverterState *arg3 = args ? args.read<QTextCodec::ConverterState * > () : (QTextCodec::ConverterState *)(0);
  ret.write<QString > ((QString)((QTextCodec *)cls)->toUnicode (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_toUnicode_c5465 ()
{
  return new qt_gsi::GenericMethod ("toUnicode", "@brief Method QString QTextCodec::toUnicode(const char *in, int length, QTextCodec::ConverterState *state)\n", true, &_init_f_toUnicode_c5465, &_call_f_toUnicode_c5465);
}

// static QList<QByteArray> QTextCodec::availableCodecs()


static void _init_f_availableCodecs_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QByteArray> >::target_type > ();
}

static void _call_f_availableCodecs_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QByteArray> >::target_type > ((qt_gsi::Converter<QList<QByteArray> >::target_type)qt_gsi::CppToQtAdaptor<QList<QByteArray> >(QTextCodec::availableCodecs ()));
}

static qt_gsi::GenericStaticMethod *_create_f_availableCodecs_0 ()
{
  return new qt_gsi::GenericStaticMethod ("availableCodecs", "@brief Static method QList<QByteArray> QTextCodec::availableCodecs()\nThis method is static and can be called without an instance.", &_init_f_availableCodecs_0, &_call_f_availableCodecs_0);
}

// static QList<int> QTextCodec::availableMibs()


static void _init_f_availableMibs_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<int> >::target_type > ();
}

static void _call_f_availableMibs_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<int> >::target_type > ((qt_gsi::Converter<QList<int> >::target_type)qt_gsi::CppToQtAdaptor<QList<int> >(QTextCodec::availableMibs ()));
}

static qt_gsi::GenericStaticMethod *_create_f_availableMibs_0 ()
{
  return new qt_gsi::GenericStaticMethod ("availableMibs", "@brief Static method QList<int> QTextCodec::availableMibs()\nThis method is static and can be called without an instance.", &_init_f_availableMibs_0, &_call_f_availableMibs_0);
}

// static QTextCodec *QTextCodec::codecForCStrings()


static void _init_f_codecForCStrings_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QTextCodec * > ();
}

static void _call_f_codecForCStrings_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextCodec * > ((QTextCodec *)QTextCodec::codecForCStrings ());
}

static qt_gsi::GenericStaticMethod *_create_f_codecForCStrings_0 ()
{
  return new qt_gsi::GenericStaticMethod (":codecForCStrings", "@brief Static method QTextCodec *QTextCodec::codecForCStrings()\nThis method is static and can be called without an instance.", &_init_f_codecForCStrings_0, &_call_f_codecForCStrings_0);
}

// static QTextCodec *QTextCodec::codecForHtml(const QByteArray &ba)


static void _init_f_codecForHtml_2309 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ba");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<QTextCodec * > ();
}

static void _call_f_codecForHtml_2309 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ret.write<QTextCodec * > ((QTextCodec *)QTextCodec::codecForHtml (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_codecForHtml_2309 ()
{
  return new qt_gsi::GenericStaticMethod ("codecForHtml", "@brief Static method QTextCodec *QTextCodec::codecForHtml(const QByteArray &ba)\nThis method is static and can be called without an instance.", &_init_f_codecForHtml_2309, &_call_f_codecForHtml_2309);
}

// static QTextCodec *QTextCodec::codecForHtml(const QByteArray &ba, QTextCodec *defaultCodec)


static void _init_f_codecForHtml_3803 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ba");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("defaultCodec");
  decl->add_arg<QTextCodec * > (argspec_1);
  decl->set_return<QTextCodec * > ();
}

static void _call_f_codecForHtml_3803 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  QTextCodec *arg2 = args.read<QTextCodec * > ();
  ret.write<QTextCodec * > ((QTextCodec *)QTextCodec::codecForHtml (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_codecForHtml_3803 ()
{
  return new qt_gsi::GenericStaticMethod ("codecForHtml", "@brief Static method QTextCodec *QTextCodec::codecForHtml(const QByteArray &ba, QTextCodec *defaultCodec)\nThis method is static and can be called without an instance.", &_init_f_codecForHtml_3803, &_call_f_codecForHtml_3803);
}

// static QTextCodec *QTextCodec::codecForLocale()


static void _init_f_codecForLocale_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QTextCodec * > ();
}

static void _call_f_codecForLocale_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextCodec * > ((QTextCodec *)QTextCodec::codecForLocale ());
}

static qt_gsi::GenericStaticMethod *_create_f_codecForLocale_0 ()
{
  return new qt_gsi::GenericStaticMethod (":codecForLocale", "@brief Static method QTextCodec *QTextCodec::codecForLocale()\nThis method is static and can be called without an instance.", &_init_f_codecForLocale_0, &_call_f_codecForLocale_0);
}

// static QTextCodec *QTextCodec::codecForMib(int mib)


static void _init_f_codecForMib_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mib");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTextCodec * > ();
}

static void _call_f_codecForMib_767 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QTextCodec * > ((QTextCodec *)QTextCodec::codecForMib (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_codecForMib_767 ()
{
  return new qt_gsi::GenericStaticMethod ("codecForMib", "@brief Static method QTextCodec *QTextCodec::codecForMib(int mib)\nThis method is static and can be called without an instance.", &_init_f_codecForMib_767, &_call_f_codecForMib_767);
}

// static QTextCodec *QTextCodec::codecForName(const char *name)


static void _init_f_codecForName_1731 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<QTextCodec * > ();
}

static void _call_f_codecForName_1731 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<QTextCodec * > ((QTextCodec *)QTextCodec::codecForName (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_codecForName_1731 ()
{
  return new qt_gsi::GenericStaticMethod ("codecForName", "@brief Static method QTextCodec *QTextCodec::codecForName(const char *name)\nThis method is static and can be called without an instance.", &_init_f_codecForName_1731, &_call_f_codecForName_1731);
}

// static QTextCodec *QTextCodec::codecForTr()


static void _init_f_codecForTr_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QTextCodec * > ();
}

static void _call_f_codecForTr_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextCodec * > ((QTextCodec *)QTextCodec::codecForTr ());
}

static qt_gsi::GenericStaticMethod *_create_f_codecForTr_0 ()
{
  return new qt_gsi::GenericStaticMethod (":codecForTr", "@brief Static method QTextCodec *QTextCodec::codecForTr()\nThis method is static and can be called without an instance.", &_init_f_codecForTr_0, &_call_f_codecForTr_0);
}

// static QTextCodec *QTextCodec::codecForUtfText(const QByteArray &ba)


static void _init_f_codecForUtfText_2309 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ba");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<QTextCodec * > ();
}

static void _call_f_codecForUtfText_2309 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ret.write<QTextCodec * > ((QTextCodec *)QTextCodec::codecForUtfText (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_codecForUtfText_2309 ()
{
  return new qt_gsi::GenericStaticMethod ("codecForUtfText", "@brief Static method QTextCodec *QTextCodec::codecForUtfText(const QByteArray &ba)\nThis method is static and can be called without an instance.", &_init_f_codecForUtfText_2309, &_call_f_codecForUtfText_2309);
}

// static QTextCodec *QTextCodec::codecForUtfText(const QByteArray &ba, QTextCodec *defaultCodec)


static void _init_f_codecForUtfText_3803 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ba");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("defaultCodec");
  decl->add_arg<QTextCodec * > (argspec_1);
  decl->set_return<QTextCodec * > ();
}

static void _call_f_codecForUtfText_3803 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  QTextCodec *arg2 = args.read<QTextCodec * > ();
  ret.write<QTextCodec * > ((QTextCodec *)QTextCodec::codecForUtfText (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_codecForUtfText_3803 ()
{
  return new qt_gsi::GenericStaticMethod ("codecForUtfText", "@brief Static method QTextCodec *QTextCodec::codecForUtfText(const QByteArray &ba, QTextCodec *defaultCodec)\nThis method is static and can be called without an instance.", &_init_f_codecForUtfText_3803, &_call_f_codecForUtfText_3803);
}

// static void QTextCodec::setCodecForCStrings(QTextCodec *c)


static void _init_f_setCodecForCStrings_1602 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<QTextCodec * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCodecForCStrings_1602 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTextCodec *arg1 = args.read<QTextCodec * > ();
  QTextCodec::setCodecForCStrings (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setCodecForCStrings_1602 ()
{
  return new qt_gsi::GenericStaticMethod ("setCodecForCStrings|codecForCStrings=", "@brief Static method void QTextCodec::setCodecForCStrings(QTextCodec *c)\nThis method is static and can be called without an instance.", &_init_f_setCodecForCStrings_1602, &_call_f_setCodecForCStrings_1602);
}

// static void QTextCodec::setCodecForLocale(QTextCodec *c)


static void _init_f_setCodecForLocale_1602 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<QTextCodec * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCodecForLocale_1602 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTextCodec *arg1 = args.read<QTextCodec * > ();
  QTextCodec::setCodecForLocale (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setCodecForLocale_1602 ()
{
  return new qt_gsi::GenericStaticMethod ("setCodecForLocale|codecForLocale=", "@brief Static method void QTextCodec::setCodecForLocale(QTextCodec *c)\nThis method is static and can be called without an instance.", &_init_f_setCodecForLocale_1602, &_call_f_setCodecForLocale_1602);
}

// static void QTextCodec::setCodecForTr(QTextCodec *c)


static void _init_f_setCodecForTr_1602 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<QTextCodec * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCodecForTr_1602 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTextCodec *arg1 = args.read<QTextCodec * > ();
  QTextCodec::setCodecForTr (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setCodecForTr_1602 ()
{
  return new qt_gsi::GenericStaticMethod ("setCodecForTr|codecForTr=", "@brief Static method void QTextCodec::setCodecForTr(QTextCodec *c)\nThis method is static and can be called without an instance.", &_init_f_setCodecForTr_1602, &_call_f_setCodecForTr_1602);
}

namespace gsi
{
gsi::Class<QTextCodec> decl_QTextCodec ("QTextCodec_Native",
  gsi::Methods(_create_f_aliases_c0 ()) +
  gsi::Methods(_create_f_canEncode_c899 ()) +
  gsi::Methods(_create_f_canEncode_c2025 ()) +
  gsi::Methods(_create_f_fromUnicode_c2025 ()) +
  gsi::Methods(_create_f_makeDecoder_c0 ()) +
  gsi::Methods(_create_f_makeEncoder_c0 ()) +
  gsi::Methods(_create_f_mibEnum_c0 ()) +
  gsi::Methods(_create_f_name_c0 ()) +
  gsi::Methods(_create_f_toUnicode_c1731 ()) +
  gsi::Methods(_create_f_toUnicode_c5465 ()) +
  gsi::Methods(_create_f_availableCodecs_0 ()) +
  gsi::Methods(_create_f_availableMibs_0 ()) +
  gsi::Methods(_create_f_codecForCStrings_0 ()) +
  gsi::Methods(_create_f_codecForHtml_2309 ()) +
  gsi::Methods(_create_f_codecForHtml_3803 ()) +
  gsi::Methods(_create_f_codecForLocale_0 ()) +
  gsi::Methods(_create_f_codecForMib_767 ()) +
  gsi::Methods(_create_f_codecForName_1731 ()) +
  gsi::Methods(_create_f_codecForTr_0 ()) +
  gsi::Methods(_create_f_codecForUtfText_2309 ()) +
  gsi::Methods(_create_f_codecForUtfText_3803 ()) +
  gsi::Methods(_create_f_setCodecForCStrings_1602 ()) +
  gsi::Methods(_create_f_setCodecForLocale_1602 ()) +
  gsi::Methods(_create_f_setCodecForTr_1602 ()),
  "@hide\n@alias QTextCodec");
}


class QTextCodec_Adaptor : public QTextCodec, public qt_gsi::QtObjectBase
{
public:

  virtual ~QTextCodec_Adaptor();

  //  [adaptor impl] QList<QByteArray> QTextCodec::aliases()
  qt_gsi::Converter<QList<QByteArray> >::target_type cbs_aliases_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QList<QByteArray> >(QTextCodec::aliases());
  }

  virtual QList<QByteArray> aliases() const
  {
    if (cb_aliases_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QList<QByteArray> >(cb_aliases_c0_0.issue<QTextCodec_Adaptor, qt_gsi::Converter<QList<QByteArray> >::target_type>(&QTextCodec_Adaptor::cbs_aliases_c0_0)).cref();
    } else {
      return QTextCodec::aliases();
    }
  }

  //  [adaptor impl] int QTextCodec::mibEnum()
  int cbs_mibEnum_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("mibEnum");
  }

  virtual int mibEnum() const
  {
    if (cb_mibEnum_c0_0.can_issue()) {
      return cb_mibEnum_c0_0.issue<QTextCodec_Adaptor, int>(&QTextCodec_Adaptor::cbs_mibEnum_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("mibEnum");
    }
  }

  //  [adaptor impl] QByteArray QTextCodec::name()
  QByteArray cbs_name_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("name");
  }

  virtual QByteArray name() const
  {
    if (cb_name_c0_0.can_issue()) {
      return cb_name_c0_0.issue<QTextCodec_Adaptor, QByteArray>(&QTextCodec_Adaptor::cbs_name_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("name");
    }
  }

  //  [adaptor impl] QByteArray QTextCodec::convertFromUnicode(const QChar *in, int length, QTextCodec::ConverterState *state)
  QByteArray cbs_convertFromUnicode_c5514_0(const qt_gsi::Converter<QChar>::target_type * in, int length, QTextCodec::ConverterState *state) const
  {
    throw qt_gsi::AbstractMethodCalledException("convertFromUnicode");
  }

  virtual QByteArray convertFromUnicode(const QChar *in, int length, QTextCodec::ConverterState *state) const
  {
    if (cb_convertFromUnicode_c5514_0.can_issue()) {
      return cb_convertFromUnicode_c5514_0.issue<QTextCodec_Adaptor, QByteArray, const qt_gsi::Converter<QChar>::target_type *, int, QTextCodec::ConverterState *>(&QTextCodec_Adaptor::cbs_convertFromUnicode_c5514_0, qt_gsi::CppToQtAdaptor<QChar>(*in), length, state);
    } else {
      throw qt_gsi::AbstractMethodCalledException("convertFromUnicode");
    }
  }

  //  [adaptor impl] QString QTextCodec::convertToUnicode(const char *in, int length, QTextCodec::ConverterState *state)
  QString cbs_convertToUnicode_c5465_0(const char *in, int length, QTextCodec::ConverterState *state) const
  {
    throw qt_gsi::AbstractMethodCalledException("convertToUnicode");
  }

  virtual QString convertToUnicode(const char *in, int length, QTextCodec::ConverterState *state) const
  {
    if (cb_convertToUnicode_c5465_0.can_issue()) {
      return cb_convertToUnicode_c5465_0.issue<QTextCodec_Adaptor, QString, const char *, int, QTextCodec::ConverterState *>(&QTextCodec_Adaptor::cbs_convertToUnicode_c5465_0, in, length, state);
    } else {
      throw qt_gsi::AbstractMethodCalledException("convertToUnicode");
    }
  }

  gsi::Callback cb_aliases_c0_0;
  gsi::Callback cb_mibEnum_c0_0;
  gsi::Callback cb_name_c0_0;
  gsi::Callback cb_convertFromUnicode_c5514_0;
  gsi::Callback cb_convertToUnicode_c5465_0;
};

QTextCodec_Adaptor::~QTextCodec_Adaptor() { }

// QList<QByteArray> QTextCodec::aliases()

static void _init_cbs_aliases_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QByteArray> >::target_type > ();
}

static void _call_cbs_aliases_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QByteArray> >::target_type > ((qt_gsi::Converter<QList<QByteArray> >::target_type)((QTextCodec_Adaptor *)cls)->cbs_aliases_c0_0 ());
}

static void _set_callback_cbs_aliases_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextCodec_Adaptor *)cls)->cb_aliases_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_aliases_c0_0 ()
{
  return new qt_gsi::GenericMethod ("aliases", "@hide", true, &_init_cbs_aliases_c0_0, &_call_cbs_aliases_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_aliases_c0_0 ()
{
  return new qt_gsi::GenericMethod ("aliases", "@brief Virtual method QList<QByteArray> QTextCodec::aliases()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_aliases_c0_0, &_call_cbs_aliases_c0_0, &_set_callback_cbs_aliases_c0_0);
}


// int QTextCodec::mibEnum()

static void _init_cbs_mibEnum_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_mibEnum_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextCodec_Adaptor *)cls)->cbs_mibEnum_c0_0 ());
}

static void _set_callback_cbs_mibEnum_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextCodec_Adaptor *)cls)->cb_mibEnum_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mibEnum_c0_0 ()
{
  return new qt_gsi::GenericMethod ("mibEnum", "@hide", true, &_init_cbs_mibEnum_c0_0, &_call_cbs_mibEnum_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mibEnum_c0_0 ()
{
  return new qt_gsi::GenericMethod ("mibEnum", "@brief Virtual method int QTextCodec::mibEnum()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mibEnum_c0_0, &_call_cbs_mibEnum_c0_0, &_set_callback_cbs_mibEnum_c0_0);
}


// QByteArray QTextCodec::name()

static void _init_cbs_name_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_cbs_name_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray > ((QByteArray)((QTextCodec_Adaptor *)cls)->cbs_name_c0_0 ());
}

static void _set_callback_cbs_name_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextCodec_Adaptor *)cls)->cb_name_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_name_c0_0 ()
{
  return new qt_gsi::GenericMethod ("name", "@hide", true, &_init_cbs_name_c0_0, &_call_cbs_name_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_name_c0_0 ()
{
  return new qt_gsi::GenericMethod ("name", "@brief Virtual method QByteArray QTextCodec::name()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_name_c0_0, &_call_cbs_name_c0_0, &_set_callback_cbs_name_c0_0);
}


// QByteArray QTextCodec::convertFromUnicode(const QChar *in, int length, QTextCodec::ConverterState *state)

static void _init_cbs_convertFromUnicode_c5514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("in");
  decl->add_arg<const qt_gsi::Converter<QChar>::target_type * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("length");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("state");
  decl->add_arg<QTextCodec::ConverterState * > (argspec_2);
  decl->set_return<QByteArray > ();
}

static void _call_cbs_convertFromUnicode_c5514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QChar>::target_type * arg1 = args.read<const qt_gsi::Converter<QChar>::target_type * > ();
  int arg2 = args.read<int > ();
  QTextCodec::ConverterState *arg3 = args.read<QTextCodec::ConverterState * > ();
  ret.write<QByteArray > ((QByteArray)((QTextCodec_Adaptor *)cls)->cbs_convertFromUnicode_c5514_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_convertFromUnicode_c5514_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextCodec_Adaptor *)cls)->cb_convertFromUnicode_c5514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_convertFromUnicode_c5514_0 ()
{
  return new qt_gsi::GenericMethod ("*convertFromUnicode", "@hide", true, &_init_cbs_convertFromUnicode_c5514_0, &_call_cbs_convertFromUnicode_c5514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_convertFromUnicode_c5514_0 ()
{
  return new qt_gsi::GenericMethod ("*convertFromUnicode", "@brief Virtual method QByteArray QTextCodec::convertFromUnicode(const QChar *in, int length, QTextCodec::ConverterState *state)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_convertFromUnicode_c5514_0, &_call_cbs_convertFromUnicode_c5514_0, &_set_callback_cbs_convertFromUnicode_c5514_0);
}


// QString QTextCodec::convertToUnicode(const char *in, int length, QTextCodec::ConverterState *state)

static void _init_cbs_convertToUnicode_c5465_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("in");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("length");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("state");
  decl->add_arg<QTextCodec::ConverterState * > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_cbs_convertToUnicode_c5465_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  int arg2 = args.read<int > ();
  QTextCodec::ConverterState *arg3 = args.read<QTextCodec::ConverterState * > ();
  ret.write<QString > ((QString)((QTextCodec_Adaptor *)cls)->cbs_convertToUnicode_c5465_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_convertToUnicode_c5465_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextCodec_Adaptor *)cls)->cb_convertToUnicode_c5465_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_convertToUnicode_c5465_0 ()
{
  return new qt_gsi::GenericMethod ("*convertToUnicode", "@hide", true, &_init_cbs_convertToUnicode_c5465_0, &_call_cbs_convertToUnicode_c5465_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_convertToUnicode_c5465_0 ()
{
  return new qt_gsi::GenericMethod ("*convertToUnicode", "@brief Virtual method QString QTextCodec::convertToUnicode(const char *in, int length, QTextCodec::ConverterState *state)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_convertToUnicode_c5465_0, &_call_cbs_convertToUnicode_c5465_0, &_set_callback_cbs_convertToUnicode_c5465_0);
}


namespace gsi
{

extern gsi::Class<QTextCodec> decl_QTextCodec;

gsi::Class<QTextCodec_Adaptor> decl_QTextCodec_Adaptor (decl_QTextCodec, "QTextCodec",
  gsi::Methods(_create_cbs_aliases_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_aliases_c0_0 ()) +
  gsi::Methods(_create_cbs_mibEnum_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_mibEnum_c0_0 ()) +
  gsi::Methods(_create_cbs_name_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_name_c0_0 ()) +
  gsi::Methods(_create_cbs_convertFromUnicode_c5514_0 ()) +
  gsi::Methods(_create_callback_cbs_convertFromUnicode_c5514_0 ()) +
  gsi::Methods(_create_cbs_convertToUnicode_c5465_0 ()) +
  gsi::Methods(_create_callback_cbs_convertToUnicode_c5465_0 ()),
  "@qt\n@brief Binding of QTextCodec");

}


//  Implementation of the enum wrapper class for QTextCodec::ConversionFlag
namespace qt_gsi
{

static QTextCodec_ConversionFlag_Enum *c_1_QTextCodec_ConversionFlag_Enum () { return new QTextCodec_ConversionFlag_Enum (QTextCodec::DefaultConversion); }
static QTextCodec_ConversionFlag_Enum *c_2_QTextCodec_ConversionFlag_Enum () { return new QTextCodec_ConversionFlag_Enum (QTextCodec::ConvertInvalidToNull); }
static QTextCodec_ConversionFlag_Enum *c_3_QTextCodec_ConversionFlag_Enum () { return new QTextCodec_ConversionFlag_Enum (QTextCodec::IgnoreHeader); }
static QTextCodec_ConversionFlag_Enum *c_4_QTextCodec_ConversionFlag_Enum () { return new QTextCodec_ConversionFlag_Enum (QTextCodec::FreeFunction); }

static gsi::Methods mkdefs_QTextCodec_ConversionFlag () {
  return
    gsi::constant ("DefaultConversion", &qt_gsi::c_1_QTextCodec_ConversionFlag_Enum, "@brief Enum constant QTextCodec::DefaultConversion") +
    gsi::constant ("ConvertInvalidToNull", &qt_gsi::c_2_QTextCodec_ConversionFlag_Enum, "@brief Enum constant QTextCodec::ConvertInvalidToNull") +
    gsi::constant ("IgnoreHeader", &qt_gsi::c_3_QTextCodec_ConversionFlag_Enum, "@brief Enum constant QTextCodec::IgnoreHeader") +
    gsi::constant ("FreeFunction", &qt_gsi::c_4_QTextCodec_ConversionFlag_Enum, "@brief Enum constant QTextCodec::FreeFunction");
}

static std::string to_s_QTextCodec_ConversionFlag_Enum (const QTextCodec_ConversionFlag_Enum *e)
{
  if (e->value () == QTextCodec::DefaultConversion) { return tl::sprintf ("DefaultConversion (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCodec::ConvertInvalidToNull) { return tl::sprintf ("ConvertInvalidToNull (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCodec::IgnoreHeader) { return tl::sprintf ("IgnoreHeader (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCodec::FreeFunction) { return tl::sprintf ("FreeFunction (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QTextCodec_ConversionFlag_Enum (const QTextCodec_ConversionFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static QTextCodec_ConversionFlag_Enum *from_i_QTextCodec_ConversionFlag_Enum (unsigned int i)
{
  return new QTextCodec_ConversionFlag_Enum ((QTextCodec::ConversionFlag) i);
}

static bool equalQTextCodec_ConversionFlag_Enum (const QTextCodec_ConversionFlag_Enum *e, QTextCodec_ConversionFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QTextCodec_ConversionFlag_Enum (const QTextCodec_ConversionFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QTextCodec_ConversionFlag_Enums oropQTextCodec_ConversionFlag_Enums (const QTextCodec_ConversionFlag_Enums *e, const QTextCodec_ConversionFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static QTextCodec_ConversionFlag_Enums andopQTextCodec_ConversionFlag_Enums (const QTextCodec_ConversionFlag_Enums *e, const QTextCodec_ConversionFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static QTextCodec_ConversionFlag_Enums xoropQTextCodec_ConversionFlag_Enums (const QTextCodec_ConversionFlag_Enums *e, const QTextCodec_ConversionFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QTextCodec_ConversionFlag_Enums (const QTextCodec_ConversionFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (QTextCodec::DefaultConversion)) { if (!l.empty ()) l += "|"; l += "DefaultConversion"; }
  if (e->testFlag (QTextCodec::ConvertInvalidToNull)) { if (!l.empty ()) l += "|"; l += "ConvertInvalidToNull"; }
  if (e->testFlag (QTextCodec::IgnoreHeader)) { if (!l.empty ()) l += "|"; l += "IgnoreHeader"; }
  if (e->testFlag (QTextCodec::FreeFunction)) { if (!l.empty ()) l += "|"; l += "FreeFunction"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QTextCodec_ConversionFlag_Enums (const QTextCodec_ConversionFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QTextCodec_ConversionFlag_Enums (const QTextCodec_ConversionFlag_Enums *e, const QTextCodec_ConversionFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QTextCodec_ConversionFlag_Enums> decl_QTextCodec_ConversionFlag_Enums ("QTextCodec_QFlags_ConversionFlag",
  gsi::method_ext ("|", &qt_gsi::oropQTextCodec_ConversionFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQTextCodec_ConversionFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQTextCodec_ConversionFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextCodec_ConversionFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextCodec_ConversionFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QTextCodec_ConversionFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QTextCodec::ConversionFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QTextCodec_ConversionFlag_Enum> decl_QTextCodec_ConversionFlag_Enum (decl_QTextCodec_ConversionFlag_Enums, "QTextCodec_ConversionFlag",
  qt_gsi::mkdefs_QTextCodec_ConversionFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextCodec_ConversionFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextCodec_ConversionFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQTextCodec_ConversionFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QTextCodec_ConversionFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QTextCodec_ConversionFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QTextCodec::ConversionFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextCodec> inject_QTextCodec_ConversionFlag_Enum_in_parent (qt_gsi::mkdefs_QTextCodec_ConversionFlag ());
static gsi::ClassExt<QTextCodec> decl_QTextCodec_ConversionFlag_Enum_as_child (decl_QTextCodec_ConversionFlag_Enum, "ConversionFlag");

}

