
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSignalMapper.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQSignalMapper_EventAdaptor.h"
#include "gsiDeclQSignalMapper_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSignalMapper

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QSignalMapper::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// void QSignalMapper::map()


static void _init_f_map_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_map_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QSignalMapper *)cls)->map ();
}

static qt_gsi::GenericMethod *_create_f_map_0 ()
{
  return new qt_gsi::GenericMethod ("map", "@brief Method void QSignalMapper::map()\n", false, &_init_f_map_0, &_call_f_map_0);
}

// void QSignalMapper::map(QObject *sender)


static void _init_f_map_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sender");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_map_1302 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  ((QSignalMapper *)cls)->map (arg1);
}

static qt_gsi::GenericMethod *_create_f_map_1302 ()
{
  return new qt_gsi::GenericMethod ("map", "@brief Method void QSignalMapper::map(QObject *sender)\n", false, &_init_f_map_1302, &_call_f_map_1302);
}

// QObject *QSignalMapper::mapping(int id)


static void _init_f_mapping_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QObject * > ();
}

static void _call_f_mapping_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QObject * > ((QObject *)((QSignalMapper *)cls)->mapping (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapping_c767 ()
{
  return new qt_gsi::GenericMethod ("mapping", "@brief Method QObject *QSignalMapper::mapping(int id)\n", true, &_init_f_mapping_c767, &_call_f_mapping_c767);
}

// QObject *QSignalMapper::mapping(const QString &text)


static void _init_f_mapping_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QObject * > ();
}

static void _call_f_mapping_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QObject * > ((QObject *)((QSignalMapper *)cls)->mapping (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapping_c2025 ()
{
  return new qt_gsi::GenericMethod ("mapping", "@brief Method QObject *QSignalMapper::mapping(const QString &text)\n", true, &_init_f_mapping_c2025, &_call_f_mapping_c2025);
}

// QObject *QSignalMapper::mapping(QWidget *widget)


static void _init_f_mapping_c1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<QObject * > ();
}

static void _call_f_mapping_c1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ret.write<QObject * > ((QObject *)((QSignalMapper *)cls)->mapping (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapping_c1315 ()
{
  return new qt_gsi::GenericMethod ("mapping", "@brief Method QObject *QSignalMapper::mapping(QWidget *widget)\n", true, &_init_f_mapping_c1315, &_call_f_mapping_c1315);
}

// QObject *QSignalMapper::mapping(QObject *object)


static void _init_f_mapping_c1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("object");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<QObject * > ();
}

static void _call_f_mapping_c1302 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  ret.write<QObject * > ((QObject *)((QSignalMapper *)cls)->mapping (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapping_c1302 ()
{
  return new qt_gsi::GenericMethod ("mapping", "@brief Method QObject *QSignalMapper::mapping(QObject *object)\n", true, &_init_f_mapping_c1302, &_call_f_mapping_c1302);
}

// void QSignalMapper::removeMappings(QObject *sender)


static void _init_f_removeMappings_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sender");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeMappings_1302 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  ((QSignalMapper *)cls)->removeMappings (arg1);
}

static qt_gsi::GenericMethod *_create_f_removeMappings_1302 ()
{
  return new qt_gsi::GenericMethod ("removeMappings", "@brief Method void QSignalMapper::removeMappings(QObject *sender)\n", false, &_init_f_removeMappings_1302, &_call_f_removeMappings_1302);
}

// void QSignalMapper::setMapping(QObject *sender, int id)


static void _init_f_setMapping_1961 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sender");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("id");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setMapping_1961 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  int arg2 = args.read<int > ();
  ((QSignalMapper *)cls)->setMapping (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setMapping_1961 ()
{
  return new qt_gsi::GenericMethod ("setMapping", "@brief Method void QSignalMapper::setMapping(QObject *sender, int id)\n", false, &_init_f_setMapping_1961, &_call_f_setMapping_1961);
}

// void QSignalMapper::setMapping(QObject *sender, const QString &text)


static void _init_f_setMapping_3219 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sender");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setMapping_3219 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  const QString &arg2 = args.read<const QString & > ();
  ((QSignalMapper *)cls)->setMapping (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setMapping_3219 ()
{
  return new qt_gsi::GenericMethod ("setMapping", "@brief Method void QSignalMapper::setMapping(QObject *sender, const QString &text)\n", false, &_init_f_setMapping_3219, &_call_f_setMapping_3219);
}

// void QSignalMapper::setMapping(QObject *sender, QWidget *widget)


static void _init_f_setMapping_2509 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sender");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("widget");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setMapping_2509 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QWidget *arg2 = args.read<QWidget * > ();
  ((QSignalMapper *)cls)->setMapping (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setMapping_2509 ()
{
  return new qt_gsi::GenericMethod ("setMapping", "@brief Method void QSignalMapper::setMapping(QObject *sender, QWidget *widget)\n", false, &_init_f_setMapping_2509, &_call_f_setMapping_2509);
}

// void QSignalMapper::setMapping(QObject *sender, QObject *object)


static void _init_f_setMapping_2496 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sender");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("object");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setMapping_2496 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QObject *arg2 = args.read<QObject * > ();
  ((QSignalMapper *)cls)->setMapping (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setMapping_2496 ()
{
  return new qt_gsi::GenericMethod ("setMapping", "@brief Method void QSignalMapper::setMapping(QObject *sender, QObject *object)\n", false, &_init_f_setMapping_2496, &_call_f_setMapping_2496);
}

// static QString QSignalMapper::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QSignalMapper::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSignalMapper::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QSignalMapper::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QSignalMapper::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSignalMapper::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QSignalMapper::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QSignalMapper::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSignalMapper::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QSignalMapper::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QSignalMapper::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSignalMapper::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QSignalMapper, QSignalMapper_EventAdaptor> ea_QSignalMapper;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QSignalMapper> decl_QSignalMapper (ea_QSignalMapper, decl_QObject, "QSignalMapper_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_map_0 ()) +
  gsi::Methods(_create_f_map_1302 ()) +
  gsi::Methods(_create_f_mapping_c767 ()) +
  gsi::Methods(_create_f_mapping_c2025 ()) +
  gsi::Methods(_create_f_mapping_c1315 ()) +
  gsi::Methods(_create_f_mapping_c1302 ()) +
  gsi::Methods(_create_f_removeMappings_1302 ()) +
  gsi::Methods(_create_f_setMapping_1961 ()) +
  gsi::Methods(_create_f_setMapping_3219 ()) +
  gsi::Methods(_create_f_setMapping_2509 ()) +
  gsi::Methods(_create_f_setMapping_2496 ()) +
  qt_gsi::qt_signal<QSignalMapper, QSignalMapper_EventAdaptor, QObject *> ("destroyed", &QSignalMapper_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QSignalMapper::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSignalMapper, QSignalMapper_EventAdaptor, int> ("mapped", &QSignalMapper_EventAdaptor::mapped_e_767, gsi::arg("arg1"), "@brief Signal declaration for QSignalMapper::mapped(int)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSignalMapper, QSignalMapper_EventAdaptor, const QString &> ("mapped_qs", &QSignalMapper_EventAdaptor::mapped_e_2025, gsi::arg("arg1"), "@brief Signal declaration for QSignalMapper::mapped(const QString &)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSignalMapper, QSignalMapper_EventAdaptor, QWidget *> ("mapped_qw", &QSignalMapper_EventAdaptor::mapped_e_1315, gsi::arg("arg1"), "@brief Signal declaration for QSignalMapper::mapped(QWidget *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSignalMapper, QSignalMapper_EventAdaptor, QObject *> ("mapped_qo", &QSignalMapper_EventAdaptor::mapped_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QSignalMapper::mapped(QObject *)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QSignalMapper");
}


class QSignalMapper_Adaptor : public QSignalMapper, public qt_gsi::QtObjectBase
{
public:

  virtual ~QSignalMapper_Adaptor();

  //  [adaptor ctor] QSignalMapper::QSignalMapper(QObject *parent)
  QSignalMapper_Adaptor() : QSignalMapper()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSignalMapper::QSignalMapper(QObject *parent)
  QSignalMapper_Adaptor(QObject *parent) : QSignalMapper(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QSignalMapper::receivers(const char *signal)
  int fp_QSignalMapper_receivers_c1731 (const char *signal) const {
    return QSignalMapper::receivers(signal);
  }

  //  QObject *QSignalMapper::sender()
  QObject * fp_QSignalMapper_sender_c0 () const {
    return QSignalMapper::sender();
  }

  //  [adaptor impl] bool QSignalMapper::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QSignalMapper::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QSignalMapper_Adaptor, bool, QEvent *>(&QSignalMapper_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QSignalMapper::event(arg1);
    }
  }

  //  [adaptor impl] bool QSignalMapper::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QSignalMapper::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QSignalMapper_Adaptor, bool, QObject *, QEvent *>(&QSignalMapper_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QSignalMapper::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QSignalMapper::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QSignalMapper::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QSignalMapper_Adaptor, QChildEvent *>(&QSignalMapper_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QSignalMapper::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QSignalMapper::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QSignalMapper::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QSignalMapper_Adaptor, QEvent *>(&QSignalMapper_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QSignalMapper::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QSignalMapper::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QSignalMapper::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QSignalMapper_Adaptor, const char *>(&QSignalMapper_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QSignalMapper::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QSignalMapper::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QSignalMapper::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QSignalMapper_Adaptor, QTimerEvent *>(&QSignalMapper_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QSignalMapper::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QSignalMapper_Adaptor::~QSignalMapper_Adaptor() { }

//  Constructor QSignalMapper::QSignalMapper(QObject *parent) (adaptor class)

static void _init_ctor_QSignalMapper_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QSignalMapper_Adaptor *> ();
}

static void _call_ctor_QSignalMapper_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QSignalMapper_Adaptor *> (new QSignalMapper_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QSignalMapper_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSignalMapper::QSignalMapper(QObject *parent)\nThis method creates an object of class QSignalMapper.", &_init_ctor_QSignalMapper_Adaptor_1302, &_call_ctor_QSignalMapper_Adaptor_1302);
}

// int QSignalMapper::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QSignalMapper_Adaptor *)cls)->fp_QSignalMapper_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QSignalMapper::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QSignalMapper::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QSignalMapper_Adaptor *)cls)->fp_QSignalMapper_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QSignalMapper::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// bool QSignalMapper::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QSignalMapper_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSignalMapper_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QSignalMapper::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QSignalMapper::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QSignalMapper_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QSignalMapper_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QSignalMapper::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QSignalMapper::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QSignalMapper_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QSignalMapper_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QSignalMapper::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QSignalMapper::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QSignalMapper_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSignalMapper_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QSignalMapper::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QSignalMapper::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QSignalMapper_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QSignalMapper_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QSignalMapper::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QSignalMapper::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QSignalMapper_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QSignalMapper_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QSignalMapper::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QSignalMapper> decl_QSignalMapper;

gsi::Class<QSignalMapper_Adaptor> decl_QSignalMapper_Adaptor (decl_QSignalMapper, "QSignalMapper",
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QSignalMapper_Adaptor_1302 ()),
  "@qt\n@brief Binding of QSignalMapper");

}

