
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPaintEngine.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQPaintEngine_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPaintEngine

// bool QPaintEngine::begin(QPaintDevice *pdev)


static void _init_f_begin_1803 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pdev");
  decl->add_arg<QPaintDevice * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_begin_1803 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintDevice *arg1 = args.read<QPaintDevice * > ();
  ret.write<bool > ((bool)((QPaintEngine *)cls)->begin (arg1));
}

static qt_gsi::GenericMethod *_create_f_begin_1803 ()
{
  return new qt_gsi::GenericMethod ("begin", "@brief Method bool QPaintEngine::begin(QPaintDevice *pdev)\n", false, &_init_f_begin_1803, &_call_f_begin_1803);
}

// void QPaintEngine::clearDirty(QFlags<QPaintEngine::DirtyFlag> df)


static void _init_f_clearDirty_3337 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("df");
  decl->add_arg<const qt_gsi::Converter<QFlags<QPaintEngine::DirtyFlag> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_clearDirty_3337 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QPaintEngine::DirtyFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QPaintEngine::DirtyFlag> >::target_type & > ();
  ((QPaintEngine *)cls)->clearDirty (qt_gsi::QtToCppAdaptor<QFlags<QPaintEngine::DirtyFlag> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_clearDirty_3337 ()
{
  return new qt_gsi::GenericMethod ("clearDirty", "@brief Method void QPaintEngine::clearDirty(QFlags<QPaintEngine::DirtyFlag> df)\n", false, &_init_f_clearDirty_3337, &_call_f_clearDirty_3337);
}

// QPoint QPaintEngine::coordinateOffset()


static void _init_f_coordinateOffset_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_f_coordinateOffset_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPoint > ((QPoint)((QPaintEngine *)cls)->coordinateOffset ());
}

static qt_gsi::GenericMethod *_create_f_coordinateOffset_c0 ()
{
  return new qt_gsi::GenericMethod ("coordinateOffset", "@brief Method QPoint QPaintEngine::coordinateOffset()\n", true, &_init_f_coordinateOffset_c0, &_call_f_coordinateOffset_c0);
}

// void QPaintEngine::drawEllipse(const QRectF &r)


static void _init_f_drawEllipse_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawEllipse_1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ((QPaintEngine *)cls)->drawEllipse (arg1);
}

static qt_gsi::GenericMethod *_create_f_drawEllipse_1862 ()
{
  return new qt_gsi::GenericMethod ("drawEllipse", "@brief Method void QPaintEngine::drawEllipse(const QRectF &r)\n", false, &_init_f_drawEllipse_1862, &_call_f_drawEllipse_1862);
}

// void QPaintEngine::drawEllipse(const QRect &r)


static void _init_f_drawEllipse_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawEllipse_1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ((QPaintEngine *)cls)->drawEllipse (arg1);
}

static qt_gsi::GenericMethod *_create_f_drawEllipse_1792 ()
{
  return new qt_gsi::GenericMethod ("drawEllipse", "@brief Method void QPaintEngine::drawEllipse(const QRect &r)\n", false, &_init_f_drawEllipse_1792, &_call_f_drawEllipse_1792);
}

// void QPaintEngine::drawImage(const QRectF &r, const QImage &pm, const QRectF &sr, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_drawImage_8645 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pm");
  decl->add_arg<const QImage & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sr");
  decl->add_arg<const QRectF & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("flags", true, "Qt::AutoColor");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawImage_8645 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  const QImage &arg2 = args.read<const QImage & > ();
  const QRectF &arg3 = args.read<const QRectF & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & arg4 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::ImageConversionFlag> >(heap, Qt::AutoColor));
  ((QPaintEngine *)cls)->drawImage (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QFlags<Qt::ImageConversionFlag> >(arg4).cref());
}

static qt_gsi::GenericMethod *_create_f_drawImage_8645 ()
{
  return new qt_gsi::GenericMethod ("drawImage", "@brief Method void QPaintEngine::drawImage(const QRectF &r, const QImage &pm, const QRectF &sr, QFlags<Qt::ImageConversionFlag> flags)\n", false, &_init_f_drawImage_8645, &_call_f_drawImage_8645);
}

// void QPaintEngine::drawPath(const QPainterPath &path)


static void _init_f_drawPath_2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawPath_2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ((QPaintEngine *)cls)->drawPath (arg1);
}

static qt_gsi::GenericMethod *_create_f_drawPath_2514 ()
{
  return new qt_gsi::GenericMethod ("drawPath", "@brief Method void QPaintEngine::drawPath(const QPainterPath &path)\n", false, &_init_f_drawPath_2514, &_call_f_drawPath_2514);
}

// void QPaintEngine::drawPixmap(const QRectF &r, const QPixmap &pm, const QRectF &sr)


static void _init_f_drawPixmap_5525 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pm");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sr");
  decl->add_arg<const QRectF & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_5525 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  const QPixmap &arg2 = args.read<const QPixmap & > ();
  const QRectF &arg3 = args.read<const QRectF & > ();
  ((QPaintEngine *)cls)->drawPixmap (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawPixmap_5525 ()
{
  return new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPaintEngine::drawPixmap(const QRectF &r, const QPixmap &pm, const QRectF &sr)\n", false, &_init_f_drawPixmap_5525, &_call_f_drawPixmap_5525);
}

// void QPaintEngine::drawTextItem(const QPointF &p, const QTextItem &textItem)


static void _init_f_drawTextItem_4092 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("textItem");
  decl->add_arg<const QTextItem & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawTextItem_4092 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  const QTextItem &arg2 = args.read<const QTextItem & > ();
  ((QPaintEngine *)cls)->drawTextItem (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_drawTextItem_4092 ()
{
  return new qt_gsi::GenericMethod ("drawTextItem", "@brief Method void QPaintEngine::drawTextItem(const QPointF &p, const QTextItem &textItem)\n", false, &_init_f_drawTextItem_4092, &_call_f_drawTextItem_4092);
}

// void QPaintEngine::drawTiledPixmap(const QRectF &r, const QPixmap &pixmap, const QPointF &s)


static void _init_f_drawTiledPixmap_5649 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("s");
  decl->add_arg<const QPointF & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawTiledPixmap_5649 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  const QPixmap &arg2 = args.read<const QPixmap & > ();
  const QPointF &arg3 = args.read<const QPointF & > ();
  ((QPaintEngine *)cls)->drawTiledPixmap (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawTiledPixmap_5649 ()
{
  return new qt_gsi::GenericMethod ("drawTiledPixmap", "@brief Method void QPaintEngine::drawTiledPixmap(const QRectF &r, const QPixmap &pixmap, const QPointF &s)\n", false, &_init_f_drawTiledPixmap_5649, &_call_f_drawTiledPixmap_5649);
}

// bool QPaintEngine::end()


static void _init_f_end_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_end_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPaintEngine *)cls)->end ());
}

static qt_gsi::GenericMethod *_create_f_end_0 ()
{
  return new qt_gsi::GenericMethod ("end", "@brief Method bool QPaintEngine::end()\n", false, &_init_f_end_0, &_call_f_end_0);
}

// bool QPaintEngine::hasFeature(QFlags<QPaintEngine::PaintEngineFeature> feature)


static void _init_f_hasFeature_c4257 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("feature");
  decl->add_arg<const qt_gsi::Converter<QFlags<QPaintEngine::PaintEngineFeature> >::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasFeature_c4257 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QPaintEngine::PaintEngineFeature> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QPaintEngine::PaintEngineFeature> >::target_type & > ();
  ret.write<bool > ((bool)((QPaintEngine *)cls)->hasFeature (qt_gsi::QtToCppAdaptor<QFlags<QPaintEngine::PaintEngineFeature> >(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_hasFeature_c4257 ()
{
  return new qt_gsi::GenericMethod ("hasFeature", "@brief Method bool QPaintEngine::hasFeature(QFlags<QPaintEngine::PaintEngineFeature> feature)\n", true, &_init_f_hasFeature_c4257, &_call_f_hasFeature_c4257);
}

// bool QPaintEngine::isActive()


static void _init_f_isActive_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isActive_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPaintEngine *)cls)->isActive ());
}

static qt_gsi::GenericMethod *_create_f_isActive_c0 ()
{
  return new qt_gsi::GenericMethod ("isActive?|:active", "@brief Method bool QPaintEngine::isActive()\n", true, &_init_f_isActive_c0, &_call_f_isActive_c0);
}

// bool QPaintEngine::isExtended()


static void _init_f_isExtended_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isExtended_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPaintEngine *)cls)->isExtended ());
}

static qt_gsi::GenericMethod *_create_f_isExtended_c0 ()
{
  return new qt_gsi::GenericMethod ("isExtended?", "@brief Method bool QPaintEngine::isExtended()\n", true, &_init_f_isExtended_c0, &_call_f_isExtended_c0);
}

// QPaintDevice *QPaintEngine::paintDevice()


static void _init_f_paintDevice_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintDevice * > ();
}

static void _call_f_paintDevice_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintDevice * > ((QPaintDevice *)((QPaintEngine *)cls)->paintDevice ());
}

static qt_gsi::GenericMethod *_create_f_paintDevice_c0 ()
{
  return new qt_gsi::GenericMethod (":paintDevice", "@brief Method QPaintDevice *QPaintEngine::paintDevice()\n", true, &_init_f_paintDevice_c0, &_call_f_paintDevice_c0);
}

// QPainter *QPaintEngine::painter()


static void _init_f_painter_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_f_painter_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPainter * > ((QPainter *)((QPaintEngine *)cls)->painter ());
}

static qt_gsi::GenericMethod *_create_f_painter_c0 ()
{
  return new qt_gsi::GenericMethod ("painter", "@brief Method QPainter *QPaintEngine::painter()\n", true, &_init_f_painter_c0, &_call_f_painter_c0);
}

// void QPaintEngine::setActive(bool newState)


static void _init_f_setActive_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newState");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActive_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QPaintEngine *)cls)->setActive (arg1);
}

static qt_gsi::GenericMethod *_create_f_setActive_864 ()
{
  return new qt_gsi::GenericMethod ("setActive|active=", "@brief Method void QPaintEngine::setActive(bool newState)\n", false, &_init_f_setActive_864, &_call_f_setActive_864);
}

// void QPaintEngine::setDirty(QFlags<QPaintEngine::DirtyFlag> df)


static void _init_f_setDirty_3337 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("df");
  decl->add_arg<const qt_gsi::Converter<QFlags<QPaintEngine::DirtyFlag> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDirty_3337 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QPaintEngine::DirtyFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QPaintEngine::DirtyFlag> >::target_type & > ();
  ((QPaintEngine *)cls)->setDirty (qt_gsi::QtToCppAdaptor<QFlags<QPaintEngine::DirtyFlag> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setDirty_3337 ()
{
  return new qt_gsi::GenericMethod ("setDirty", "@brief Method void QPaintEngine::setDirty(QFlags<QPaintEngine::DirtyFlag> df)\n", false, &_init_f_setDirty_3337, &_call_f_setDirty_3337);
}

// void QPaintEngine::setPaintDevice(QPaintDevice *device)


static void _init_f_setPaintDevice_1803 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QPaintDevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPaintDevice_1803 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintDevice *arg1 = args.read<QPaintDevice * > ();
  ((QPaintEngine *)cls)->setPaintDevice (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPaintDevice_1803 ()
{
  return new qt_gsi::GenericMethod ("setPaintDevice|paintDevice=", "@brief Method void QPaintEngine::setPaintDevice(QPaintDevice *device)\n", false, &_init_f_setPaintDevice_1803, &_call_f_setPaintDevice_1803);
}

// void QPaintEngine::setSystemClip(const QRegion &baseClip)


static void _init_f_setSystemClip_2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("baseClip");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSystemClip_2006 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRegion &arg1 = args.read<const QRegion & > ();
  ((QPaintEngine *)cls)->setSystemClip (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSystemClip_2006 ()
{
  return new qt_gsi::GenericMethod ("setSystemClip|systemClip=", "@brief Method void QPaintEngine::setSystemClip(const QRegion &baseClip)\n", false, &_init_f_setSystemClip_2006, &_call_f_setSystemClip_2006);
}

// void QPaintEngine::setSystemRect(const QRect &rect)


static void _init_f_setSystemRect_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSystemRect_1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ((QPaintEngine *)cls)->setSystemRect (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSystemRect_1792 ()
{
  return new qt_gsi::GenericMethod ("setSystemRect|systemRect=", "@brief Method void QPaintEngine::setSystemRect(const QRect &rect)\n", false, &_init_f_setSystemRect_1792, &_call_f_setSystemRect_1792);
}

// void QPaintEngine::syncState()


static void _init_f_syncState_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_syncState_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPaintEngine *)cls)->syncState ();
}

static qt_gsi::GenericMethod *_create_f_syncState_0 ()
{
  return new qt_gsi::GenericMethod ("syncState", "@brief Method void QPaintEngine::syncState()\n", false, &_init_f_syncState_0, &_call_f_syncState_0);
}

// QRegion QPaintEngine::systemClip()


static void _init_f_systemClip_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRegion > ();
}

static void _call_f_systemClip_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRegion > ((QRegion)((QPaintEngine *)cls)->systemClip ());
}

static qt_gsi::GenericMethod *_create_f_systemClip_c0 ()
{
  return new qt_gsi::GenericMethod (":systemClip", "@brief Method QRegion QPaintEngine::systemClip()\n", true, &_init_f_systemClip_c0, &_call_f_systemClip_c0);
}

// QRect QPaintEngine::systemRect()


static void _init_f_systemRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_systemRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QPaintEngine *)cls)->systemRect ());
}

static qt_gsi::GenericMethod *_create_f_systemRect_c0 ()
{
  return new qt_gsi::GenericMethod (":systemRect", "@brief Method QRect QPaintEngine::systemRect()\n", true, &_init_f_systemRect_c0, &_call_f_systemRect_c0);
}

// bool QPaintEngine::testDirty(QFlags<QPaintEngine::DirtyFlag> df)


static void _init_f_testDirty_3337 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("df");
  decl->add_arg<const qt_gsi::Converter<QFlags<QPaintEngine::DirtyFlag> >::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_testDirty_3337 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QPaintEngine::DirtyFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QPaintEngine::DirtyFlag> >::target_type & > ();
  ret.write<bool > ((bool)((QPaintEngine *)cls)->testDirty (qt_gsi::QtToCppAdaptor<QFlags<QPaintEngine::DirtyFlag> >(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_testDirty_3337 ()
{
  return new qt_gsi::GenericMethod ("testDirty", "@brief Method bool QPaintEngine::testDirty(QFlags<QPaintEngine::DirtyFlag> df)\n", false, &_init_f_testDirty_3337, &_call_f_testDirty_3337);
}

// QPaintEngine::Type QPaintEngine::type()


static void _init_f_type_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPaintEngine::Type>::target_type > ();
}

static void _call_f_type_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QPaintEngine::Type>::target_type > ((qt_gsi::Converter<QPaintEngine::Type>::target_type)qt_gsi::CppToQtAdaptor<QPaintEngine::Type>(((QPaintEngine *)cls)->type ()));
}

static qt_gsi::GenericMethod *_create_f_type_c0 ()
{
  return new qt_gsi::GenericMethod ("type", "@brief Method QPaintEngine::Type QPaintEngine::type()\n", true, &_init_f_type_c0, &_call_f_type_c0);
}

// void QPaintEngine::updateState(const QPaintEngineState &state)


static void _init_f_updateState_3013 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const QPaintEngineState & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_updateState_3013 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPaintEngineState &arg1 = args.read<const QPaintEngineState & > ();
  ((QPaintEngine *)cls)->updateState (arg1);
}

static qt_gsi::GenericMethod *_create_f_updateState_3013 ()
{
  return new qt_gsi::GenericMethod ("updateState", "@brief Method void QPaintEngine::updateState(const QPaintEngineState &state)\n", false, &_init_f_updateState_3013, &_call_f_updateState_3013);
}

namespace gsi
{
gsi::Class<QPaintEngine> decl_QPaintEngine ("QPaintEngine_Native",
  gsi::Methods(_create_f_begin_1803 ()) +
  gsi::Methods(_create_f_clearDirty_3337 ()) +
  gsi::Methods(_create_f_coordinateOffset_c0 ()) +
  gsi::Methods(_create_f_drawEllipse_1862 ()) +
  gsi::Methods(_create_f_drawEllipse_1792 ()) +
  gsi::Methods(_create_f_drawImage_8645 ()) +
  gsi::Methods(_create_f_drawPath_2514 ()) +
  gsi::Methods(_create_f_drawPixmap_5525 ()) +
  gsi::Methods(_create_f_drawTextItem_4092 ()) +
  gsi::Methods(_create_f_drawTiledPixmap_5649 ()) +
  gsi::Methods(_create_f_end_0 ()) +
  gsi::Methods(_create_f_hasFeature_c4257 ()) +
  gsi::Methods(_create_f_isActive_c0 ()) +
  gsi::Methods(_create_f_isExtended_c0 ()) +
  gsi::Methods(_create_f_paintDevice_c0 ()) +
  gsi::Methods(_create_f_painter_c0 ()) +
  gsi::Methods(_create_f_setActive_864 ()) +
  gsi::Methods(_create_f_setDirty_3337 ()) +
  gsi::Methods(_create_f_setPaintDevice_1803 ()) +
  gsi::Methods(_create_f_setSystemClip_2006 ()) +
  gsi::Methods(_create_f_setSystemRect_1792 ()) +
  gsi::Methods(_create_f_syncState_0 ()) +
  gsi::Methods(_create_f_systemClip_c0 ()) +
  gsi::Methods(_create_f_systemRect_c0 ()) +
  gsi::Methods(_create_f_testDirty_3337 ()) +
  gsi::Methods(_create_f_type_c0 ()) +
  gsi::Methods(_create_f_updateState_3013 ()),
  "@hide\n@alias QPaintEngine");
}


class QPaintEngine_Adaptor : public QPaintEngine, public qt_gsi::QtObjectBase
{
public:

  virtual ~QPaintEngine_Adaptor();

  //  [adaptor ctor] QPaintEngine::QPaintEngine(QFlags<QPaintEngine::PaintEngineFeature> features)
  QPaintEngine_Adaptor() : QPaintEngine()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPaintEngine::QPaintEngine(QFlags<QPaintEngine::PaintEngineFeature> features)
  QPaintEngine_Adaptor(QFlags<QPaintEngine::PaintEngineFeature> features) : QPaintEngine(features)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor impl] bool QPaintEngine::begin(QPaintDevice *pdev)
  bool cbs_begin_1803_0(QPaintDevice *pdev)
  {
    throw qt_gsi::AbstractMethodCalledException("begin");
  }

  virtual bool begin(QPaintDevice *pdev)
  {
    if (cb_begin_1803_0.can_issue()) {
      return cb_begin_1803_0.issue<QPaintEngine_Adaptor, bool, QPaintDevice *>(&QPaintEngine_Adaptor::cbs_begin_1803_0, pdev);
    } else {
      throw qt_gsi::AbstractMethodCalledException("begin");
    }
  }

  //  [adaptor impl] QPoint QPaintEngine::coordinateOffset()
  QPoint cbs_coordinateOffset_c0_0() const
  {
    return QPaintEngine::coordinateOffset();
  }

  virtual QPoint coordinateOffset() const
  {
    if (cb_coordinateOffset_c0_0.can_issue()) {
      return cb_coordinateOffset_c0_0.issue<QPaintEngine_Adaptor, QPoint>(&QPaintEngine_Adaptor::cbs_coordinateOffset_c0_0);
    } else {
      return QPaintEngine::coordinateOffset();
    }
  }

  //  [adaptor impl] void QPaintEngine::drawEllipse(const QRectF &r)
  void cbs_drawEllipse_1862_0(const QRectF &r)
  {
    QPaintEngine::drawEllipse(r);
  }

  virtual void drawEllipse(const QRectF &r)
  {
    if (cb_drawEllipse_1862_0.can_issue()) {
      cb_drawEllipse_1862_0.issue<QPaintEngine_Adaptor, const QRectF &>(&QPaintEngine_Adaptor::cbs_drawEllipse_1862_0, r);
    } else {
      QPaintEngine::drawEllipse(r);
    }
  }

  //  [adaptor impl] void QPaintEngine::drawEllipse(const QRect &r)
  void cbs_drawEllipse_1792_0(const QRect &r)
  {
    QPaintEngine::drawEllipse(r);
  }

  virtual void drawEllipse(const QRect &r)
  {
    if (cb_drawEllipse_1792_0.can_issue()) {
      cb_drawEllipse_1792_0.issue<QPaintEngine_Adaptor, const QRect &>(&QPaintEngine_Adaptor::cbs_drawEllipse_1792_0, r);
    } else {
      QPaintEngine::drawEllipse(r);
    }
  }

  //  [adaptor impl] void QPaintEngine::drawImage(const QRectF &r, const QImage &pm, const QRectF &sr, QFlags<Qt::ImageConversionFlag> flags)
  void cbs_drawImage_8645_1(const QRectF &r, const QImage &pm, const QRectF &sr, const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & flags)
  {
    QPaintEngine::drawImage(r, pm, sr, qt_gsi::QtToCppAdaptor<QFlags<Qt::ImageConversionFlag> >(flags).cref());
  }

  virtual void drawImage(const QRectF &r, const QImage &pm, const QRectF &sr, QFlags<Qt::ImageConversionFlag> flags)
  {
    if (cb_drawImage_8645_1.can_issue()) {
      cb_drawImage_8645_1.issue<QPaintEngine_Adaptor, const QRectF &, const QImage &, const QRectF &, const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type &>(&QPaintEngine_Adaptor::cbs_drawImage_8645_1, r, pm, sr, qt_gsi::CppToQtAdaptor<QFlags<Qt::ImageConversionFlag> >(flags));
    } else {
      QPaintEngine::drawImage(r, pm, sr, flags);
    }
  }

  //  [adaptor impl] void QPaintEngine::drawPath(const QPainterPath &path)
  void cbs_drawPath_2514_0(const QPainterPath &path)
  {
    QPaintEngine::drawPath(path);
  }

  virtual void drawPath(const QPainterPath &path)
  {
    if (cb_drawPath_2514_0.can_issue()) {
      cb_drawPath_2514_0.issue<QPaintEngine_Adaptor, const QPainterPath &>(&QPaintEngine_Adaptor::cbs_drawPath_2514_0, path);
    } else {
      QPaintEngine::drawPath(path);
    }
  }

  //  [adaptor impl] void QPaintEngine::drawPixmap(const QRectF &r, const QPixmap &pm, const QRectF &sr)
  void cbs_drawPixmap_5525_0(const QRectF &r, const QPixmap &pm, const QRectF &sr)
  {
    throw qt_gsi::AbstractMethodCalledException("drawPixmap");
  }

  virtual void drawPixmap(const QRectF &r, const QPixmap &pm, const QRectF &sr)
  {
    if (cb_drawPixmap_5525_0.can_issue()) {
      cb_drawPixmap_5525_0.issue<QPaintEngine_Adaptor, const QRectF &, const QPixmap &, const QRectF &>(&QPaintEngine_Adaptor::cbs_drawPixmap_5525_0, r, pm, sr);
    } else {
      throw qt_gsi::AbstractMethodCalledException("drawPixmap");
    }
  }

  //  [adaptor impl] void QPaintEngine::drawTextItem(const QPointF &p, const QTextItem &textItem)
  void cbs_drawTextItem_4092_0(const QPointF &p, const QTextItem &textItem)
  {
    QPaintEngine::drawTextItem(p, textItem);
  }

  virtual void drawTextItem(const QPointF &p, const QTextItem &textItem)
  {
    if (cb_drawTextItem_4092_0.can_issue()) {
      cb_drawTextItem_4092_0.issue<QPaintEngine_Adaptor, const QPointF &, const QTextItem &>(&QPaintEngine_Adaptor::cbs_drawTextItem_4092_0, p, textItem);
    } else {
      QPaintEngine::drawTextItem(p, textItem);
    }
  }

  //  [adaptor impl] void QPaintEngine::drawTiledPixmap(const QRectF &r, const QPixmap &pixmap, const QPointF &s)
  void cbs_drawTiledPixmap_5649_0(const QRectF &r, const QPixmap &pixmap, const QPointF &s)
  {
    QPaintEngine::drawTiledPixmap(r, pixmap, s);
  }

  virtual void drawTiledPixmap(const QRectF &r, const QPixmap &pixmap, const QPointF &s)
  {
    if (cb_drawTiledPixmap_5649_0.can_issue()) {
      cb_drawTiledPixmap_5649_0.issue<QPaintEngine_Adaptor, const QRectF &, const QPixmap &, const QPointF &>(&QPaintEngine_Adaptor::cbs_drawTiledPixmap_5649_0, r, pixmap, s);
    } else {
      QPaintEngine::drawTiledPixmap(r, pixmap, s);
    }
  }

  //  [adaptor impl] bool QPaintEngine::end()
  bool cbs_end_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("end");
  }

  virtual bool end()
  {
    if (cb_end_0_0.can_issue()) {
      return cb_end_0_0.issue<QPaintEngine_Adaptor, bool>(&QPaintEngine_Adaptor::cbs_end_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("end");
    }
  }

  //  [adaptor impl] QPaintEngine::Type QPaintEngine::type()
  qt_gsi::Converter<QPaintEngine::Type>::target_type cbs_type_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("type");
  }

  virtual QPaintEngine::Type type() const
  {
    if (cb_type_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QPaintEngine::Type>(cb_type_c0_0.issue<QPaintEngine_Adaptor, qt_gsi::Converter<QPaintEngine::Type>::target_type>(&QPaintEngine_Adaptor::cbs_type_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("type");
    }
  }

  //  [adaptor impl] void QPaintEngine::updateState(const QPaintEngineState &state)
  void cbs_updateState_3013_0(const QPaintEngineState &state)
  {
    throw qt_gsi::AbstractMethodCalledException("updateState");
  }

  virtual void updateState(const QPaintEngineState &state)
  {
    if (cb_updateState_3013_0.can_issue()) {
      cb_updateState_3013_0.issue<QPaintEngine_Adaptor, const QPaintEngineState &>(&QPaintEngine_Adaptor::cbs_updateState_3013_0, state);
    } else {
      throw qt_gsi::AbstractMethodCalledException("updateState");
    }
  }

  gsi::Callback cb_begin_1803_0;
  gsi::Callback cb_coordinateOffset_c0_0;
  gsi::Callback cb_drawEllipse_1862_0;
  gsi::Callback cb_drawEllipse_1792_0;
  gsi::Callback cb_drawImage_8645_1;
  gsi::Callback cb_drawPath_2514_0;
  gsi::Callback cb_drawPixmap_5525_0;
  gsi::Callback cb_drawTextItem_4092_0;
  gsi::Callback cb_drawTiledPixmap_5649_0;
  gsi::Callback cb_end_0_0;
  gsi::Callback cb_type_c0_0;
  gsi::Callback cb_updateState_3013_0;
};

QPaintEngine_Adaptor::~QPaintEngine_Adaptor() { }

//  Constructor QPaintEngine::QPaintEngine(QFlags<QPaintEngine::PaintEngineFeature> features) (adaptor class)

static void _init_ctor_QPaintEngine_Adaptor_4257 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("features", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<QPaintEngine::PaintEngineFeature> >::target_type & > (argspec_0);
  decl->set_return_new<QPaintEngine_Adaptor *> ();
}

static void _call_ctor_QPaintEngine_Adaptor_4257 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QPaintEngine::PaintEngineFeature> >::target_type & arg1 = args ? args.read<const qt_gsi::Converter<QFlags<QPaintEngine::PaintEngineFeature> >::target_type & > () : (const qt_gsi::Converter<QFlags<QPaintEngine::PaintEngineFeature> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QPaintEngine::PaintEngineFeature> >(heap, 0));
  ret.write<QPaintEngine_Adaptor *> (new QPaintEngine_Adaptor (qt_gsi::QtToCppAdaptor<QFlags<QPaintEngine::PaintEngineFeature> >(arg1).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPaintEngine_Adaptor_4257 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPaintEngine::QPaintEngine(QFlags<QPaintEngine::PaintEngineFeature> features)\nThis method creates an object of class QPaintEngine.", &_init_ctor_QPaintEngine_Adaptor_4257, &_call_ctor_QPaintEngine_Adaptor_4257);
}

// bool QPaintEngine::begin(QPaintDevice *pdev)

static void _init_cbs_begin_1803_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pdev");
  decl->add_arg<QPaintDevice * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_begin_1803_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintDevice *arg1 = args.read<QPaintDevice * > ();
  ret.write<bool > ((bool)((QPaintEngine_Adaptor *)cls)->cbs_begin_1803_0 (arg1));
}

static void _set_callback_cbs_begin_1803_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_begin_1803_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_begin_1803_0 ()
{
  return new qt_gsi::GenericMethod ("begin", "@hide", false, &_init_cbs_begin_1803_0, &_call_cbs_begin_1803_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_begin_1803_0 ()
{
  return new qt_gsi::GenericMethod ("begin", "@brief Virtual method bool QPaintEngine::begin(QPaintDevice *pdev)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_begin_1803_0, &_call_cbs_begin_1803_0, &_set_callback_cbs_begin_1803_0);
}


// QPoint QPaintEngine::coordinateOffset()

static void _init_cbs_coordinateOffset_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_cbs_coordinateOffset_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPoint > ((QPoint)((QPaintEngine_Adaptor *)cls)->cbs_coordinateOffset_c0_0 ());
}

static void _set_callback_cbs_coordinateOffset_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_coordinateOffset_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_coordinateOffset_c0_0 ()
{
  return new qt_gsi::GenericMethod ("coordinateOffset", "@hide", true, &_init_cbs_coordinateOffset_c0_0, &_call_cbs_coordinateOffset_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_coordinateOffset_c0_0 ()
{
  return new qt_gsi::GenericMethod ("coordinateOffset", "@brief Virtual method QPoint QPaintEngine::coordinateOffset()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_coordinateOffset_c0_0, &_call_cbs_coordinateOffset_c0_0, &_set_callback_cbs_coordinateOffset_c0_0);
}


// void QPaintEngine::drawEllipse(const QRectF &r)

static void _init_cbs_drawEllipse_1862_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_drawEllipse_1862_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ((QPaintEngine_Adaptor *)cls)->cbs_drawEllipse_1862_0 (arg1);
}

static void _set_callback_cbs_drawEllipse_1862_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_drawEllipse_1862_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawEllipse_1862_0 ()
{
  return new qt_gsi::GenericMethod ("drawEllipse", "@hide", false, &_init_cbs_drawEllipse_1862_0, &_call_cbs_drawEllipse_1862_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawEllipse_1862_0 ()
{
  return new qt_gsi::GenericMethod ("drawEllipse", "@brief Virtual method void QPaintEngine::drawEllipse(const QRectF &r)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawEllipse_1862_0, &_call_cbs_drawEllipse_1862_0, &_set_callback_cbs_drawEllipse_1862_0);
}


// void QPaintEngine::drawEllipse(const QRect &r)

static void _init_cbs_drawEllipse_1792_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_drawEllipse_1792_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ((QPaintEngine_Adaptor *)cls)->cbs_drawEllipse_1792_0 (arg1);
}

static void _set_callback_cbs_drawEllipse_1792_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_drawEllipse_1792_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawEllipse_1792_0 ()
{
  return new qt_gsi::GenericMethod ("drawEllipse", "@hide", false, &_init_cbs_drawEllipse_1792_0, &_call_cbs_drawEllipse_1792_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawEllipse_1792_0 ()
{
  return new qt_gsi::GenericMethod ("drawEllipse", "@brief Virtual method void QPaintEngine::drawEllipse(const QRect &r)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawEllipse_1792_0, &_call_cbs_drawEllipse_1792_0, &_set_callback_cbs_drawEllipse_1792_0);
}


// void QPaintEngine::drawImage(const QRectF &r, const QImage &pm, const QRectF &sr, QFlags<Qt::ImageConversionFlag> flags)

static void _init_cbs_drawImage_8645_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pm");
  decl->add_arg<const QImage & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sr");
  decl->add_arg<const QRectF & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("flags");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawImage_8645_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  const QImage &arg2 = args.read<const QImage & > ();
  const QRectF &arg3 = args.read<const QRectF & > ();
  const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & arg4 = args.read<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > ();
  ((QPaintEngine_Adaptor *)cls)->cbs_drawImage_8645_1 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawImage_8645_1 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_drawImage_8645_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawImage_8645_1 ()
{
  return new qt_gsi::GenericMethod ("drawImage", "@hide", false, &_init_cbs_drawImage_8645_1, &_call_cbs_drawImage_8645_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawImage_8645_1 ()
{
  return new qt_gsi::GenericMethod ("drawImage", "@brief Virtual method void QPaintEngine::drawImage(const QRectF &r, const QImage &pm, const QRectF &sr, QFlags<Qt::ImageConversionFlag> flags)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawImage_8645_1, &_call_cbs_drawImage_8645_1, &_set_callback_cbs_drawImage_8645_1);
}


// void QPaintEngine::drawPath(const QPainterPath &path)

static void _init_cbs_drawPath_2514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_drawPath_2514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ((QPaintEngine_Adaptor *)cls)->cbs_drawPath_2514_0 (arg1);
}

static void _set_callback_cbs_drawPath_2514_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_drawPath_2514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawPath_2514_0 ()
{
  return new qt_gsi::GenericMethod ("drawPath", "@hide", false, &_init_cbs_drawPath_2514_0, &_call_cbs_drawPath_2514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawPath_2514_0 ()
{
  return new qt_gsi::GenericMethod ("drawPath", "@brief Virtual method void QPaintEngine::drawPath(const QPainterPath &path)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawPath_2514_0, &_call_cbs_drawPath_2514_0, &_set_callback_cbs_drawPath_2514_0);
}


// void QPaintEngine::drawPixmap(const QRectF &r, const QPixmap &pm, const QRectF &sr)

static void _init_cbs_drawPixmap_5525_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pm");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sr");
  decl->add_arg<const QRectF & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_drawPixmap_5525_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  const QPixmap &arg2 = args.read<const QPixmap & > ();
  const QRectF &arg3 = args.read<const QRectF & > ();
  ((QPaintEngine_Adaptor *)cls)->cbs_drawPixmap_5525_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_drawPixmap_5525_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_drawPixmap_5525_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawPixmap_5525_0 ()
{
  return new qt_gsi::GenericMethod ("drawPixmap", "@hide", false, &_init_cbs_drawPixmap_5525_0, &_call_cbs_drawPixmap_5525_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawPixmap_5525_0 ()
{
  return new qt_gsi::GenericMethod ("drawPixmap", "@brief Virtual method void QPaintEngine::drawPixmap(const QRectF &r, const QPixmap &pm, const QRectF &sr)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawPixmap_5525_0, &_call_cbs_drawPixmap_5525_0, &_set_callback_cbs_drawPixmap_5525_0);
}


// void QPaintEngine::drawTextItem(const QPointF &p, const QTextItem &textItem)

static void _init_cbs_drawTextItem_4092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("textItem");
  decl->add_arg<const QTextItem & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_drawTextItem_4092_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  const QTextItem &arg2 = args.read<const QTextItem & > ();
  ((QPaintEngine_Adaptor *)cls)->cbs_drawTextItem_4092_0 (arg1, arg2);
}

static void _set_callback_cbs_drawTextItem_4092_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_drawTextItem_4092_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawTextItem_4092_0 ()
{
  return new qt_gsi::GenericMethod ("drawTextItem", "@hide", false, &_init_cbs_drawTextItem_4092_0, &_call_cbs_drawTextItem_4092_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawTextItem_4092_0 ()
{
  return new qt_gsi::GenericMethod ("drawTextItem", "@brief Virtual method void QPaintEngine::drawTextItem(const QPointF &p, const QTextItem &textItem)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawTextItem_4092_0, &_call_cbs_drawTextItem_4092_0, &_set_callback_cbs_drawTextItem_4092_0);
}


// void QPaintEngine::drawTiledPixmap(const QRectF &r, const QPixmap &pixmap, const QPointF &s)

static void _init_cbs_drawTiledPixmap_5649_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("s");
  decl->add_arg<const QPointF & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_drawTiledPixmap_5649_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  const QPixmap &arg2 = args.read<const QPixmap & > ();
  const QPointF &arg3 = args.read<const QPointF & > ();
  ((QPaintEngine_Adaptor *)cls)->cbs_drawTiledPixmap_5649_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_drawTiledPixmap_5649_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_drawTiledPixmap_5649_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawTiledPixmap_5649_0 ()
{
  return new qt_gsi::GenericMethod ("drawTiledPixmap", "@hide", false, &_init_cbs_drawTiledPixmap_5649_0, &_call_cbs_drawTiledPixmap_5649_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawTiledPixmap_5649_0 ()
{
  return new qt_gsi::GenericMethod ("drawTiledPixmap", "@brief Virtual method void QPaintEngine::drawTiledPixmap(const QRectF &r, const QPixmap &pixmap, const QPointF &s)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawTiledPixmap_5649_0, &_call_cbs_drawTiledPixmap_5649_0, &_set_callback_cbs_drawTiledPixmap_5649_0);
}


// bool QPaintEngine::end()

static void _init_cbs_end_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_end_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPaintEngine_Adaptor *)cls)->cbs_end_0_0 ());
}

static void _set_callback_cbs_end_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_end_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_end_0_0 ()
{
  return new qt_gsi::GenericMethod ("end", "@hide", false, &_init_cbs_end_0_0, &_call_cbs_end_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_end_0_0 ()
{
  return new qt_gsi::GenericMethod ("end", "@brief Virtual method bool QPaintEngine::end()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_end_0_0, &_call_cbs_end_0_0, &_set_callback_cbs_end_0_0);
}


// QPaintEngine::Type QPaintEngine::type()

static void _init_cbs_type_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPaintEngine::Type>::target_type > ();
}

static void _call_cbs_type_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QPaintEngine::Type>::target_type > ((qt_gsi::Converter<QPaintEngine::Type>::target_type)((QPaintEngine_Adaptor *)cls)->cbs_type_c0_0 ());
}

static void _set_callback_cbs_type_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_type_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_type_c0_0 ()
{
  return new qt_gsi::GenericMethod ("type", "@hide", true, &_init_cbs_type_c0_0, &_call_cbs_type_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_type_c0_0 ()
{
  return new qt_gsi::GenericMethod ("type", "@brief Virtual method QPaintEngine::Type QPaintEngine::type()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_type_c0_0, &_call_cbs_type_c0_0, &_set_callback_cbs_type_c0_0);
}


// void QPaintEngine::updateState(const QPaintEngineState &state)

static void _init_cbs_updateState_3013_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const QPaintEngineState & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_updateState_3013_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPaintEngineState &arg1 = args.read<const QPaintEngineState & > ();
  ((QPaintEngine_Adaptor *)cls)->cbs_updateState_3013_0 (arg1);
}

static void _set_callback_cbs_updateState_3013_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_updateState_3013_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_updateState_3013_0 ()
{
  return new qt_gsi::GenericMethod ("updateState", "@hide", false, &_init_cbs_updateState_3013_0, &_call_cbs_updateState_3013_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_updateState_3013_0 ()
{
  return new qt_gsi::GenericMethod ("updateState", "@brief Virtual method void QPaintEngine::updateState(const QPaintEngineState &state)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateState_3013_0, &_call_cbs_updateState_3013_0, &_set_callback_cbs_updateState_3013_0);
}


namespace gsi
{

extern gsi::Class<QPaintEngine> decl_QPaintEngine;

gsi::Class<QPaintEngine_Adaptor> decl_QPaintEngine_Adaptor (decl_QPaintEngine, "QPaintEngine",
  gsi::Methods(_create_cbs_begin_1803_0 ()) +
  gsi::Methods(_create_callback_cbs_begin_1803_0 ()) +
  gsi::Methods(_create_cbs_coordinateOffset_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_coordinateOffset_c0_0 ()) +
  gsi::Methods(_create_cbs_drawEllipse_1862_0 ()) +
  gsi::Methods(_create_callback_cbs_drawEllipse_1862_0 ()) +
  gsi::Methods(_create_cbs_drawEllipse_1792_0 ()) +
  gsi::Methods(_create_callback_cbs_drawEllipse_1792_0 ()) +
  gsi::Methods(_create_cbs_drawImage_8645_1 ()) +
  gsi::Methods(_create_callback_cbs_drawImage_8645_1 ()) +
  gsi::Methods(_create_cbs_drawPath_2514_0 ()) +
  gsi::Methods(_create_callback_cbs_drawPath_2514_0 ()) +
  gsi::Methods(_create_cbs_drawPixmap_5525_0 ()) +
  gsi::Methods(_create_callback_cbs_drawPixmap_5525_0 ()) +
  gsi::Methods(_create_cbs_drawTextItem_4092_0 ()) +
  gsi::Methods(_create_callback_cbs_drawTextItem_4092_0 ()) +
  gsi::Methods(_create_cbs_drawTiledPixmap_5649_0 ()) +
  gsi::Methods(_create_callback_cbs_drawTiledPixmap_5649_0 ()) +
  gsi::Methods(_create_cbs_end_0_0 ()) +
  gsi::Methods(_create_callback_cbs_end_0_0 ()) +
  gsi::Methods(_create_cbs_type_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_type_c0_0 ()) +
  gsi::Methods(_create_cbs_updateState_3013_0 ()) +
  gsi::Methods(_create_callback_cbs_updateState_3013_0 ()) +
  gsi::Methods(_create_ctor_QPaintEngine_Adaptor_4257 ()),
  "@qt\n@brief Binding of QPaintEngine");

}


//  Implementation of the enum wrapper class for QPaintEngine::DirtyFlag
namespace qt_gsi
{

static QPaintEngine_DirtyFlag_Enum *c_1_QPaintEngine_DirtyFlag_Enum () { return new QPaintEngine_DirtyFlag_Enum (QPaintEngine::DirtyPen); }
static QPaintEngine_DirtyFlag_Enum *c_2_QPaintEngine_DirtyFlag_Enum () { return new QPaintEngine_DirtyFlag_Enum (QPaintEngine::DirtyBrush); }
static QPaintEngine_DirtyFlag_Enum *c_3_QPaintEngine_DirtyFlag_Enum () { return new QPaintEngine_DirtyFlag_Enum (QPaintEngine::DirtyBrushOrigin); }
static QPaintEngine_DirtyFlag_Enum *c_4_QPaintEngine_DirtyFlag_Enum () { return new QPaintEngine_DirtyFlag_Enum (QPaintEngine::DirtyFont); }
static QPaintEngine_DirtyFlag_Enum *c_5_QPaintEngine_DirtyFlag_Enum () { return new QPaintEngine_DirtyFlag_Enum (QPaintEngine::DirtyBackground); }
static QPaintEngine_DirtyFlag_Enum *c_6_QPaintEngine_DirtyFlag_Enum () { return new QPaintEngine_DirtyFlag_Enum (QPaintEngine::DirtyBackgroundMode); }
static QPaintEngine_DirtyFlag_Enum *c_7_QPaintEngine_DirtyFlag_Enum () { return new QPaintEngine_DirtyFlag_Enum (QPaintEngine::DirtyTransform); }
static QPaintEngine_DirtyFlag_Enum *c_8_QPaintEngine_DirtyFlag_Enum () { return new QPaintEngine_DirtyFlag_Enum (QPaintEngine::DirtyClipRegion); }
static QPaintEngine_DirtyFlag_Enum *c_9_QPaintEngine_DirtyFlag_Enum () { return new QPaintEngine_DirtyFlag_Enum (QPaintEngine::DirtyClipPath); }
static QPaintEngine_DirtyFlag_Enum *c_10_QPaintEngine_DirtyFlag_Enum () { return new QPaintEngine_DirtyFlag_Enum (QPaintEngine::DirtyHints); }
static QPaintEngine_DirtyFlag_Enum *c_11_QPaintEngine_DirtyFlag_Enum () { return new QPaintEngine_DirtyFlag_Enum (QPaintEngine::DirtyCompositionMode); }
static QPaintEngine_DirtyFlag_Enum *c_12_QPaintEngine_DirtyFlag_Enum () { return new QPaintEngine_DirtyFlag_Enum (QPaintEngine::DirtyClipEnabled); }
static QPaintEngine_DirtyFlag_Enum *c_13_QPaintEngine_DirtyFlag_Enum () { return new QPaintEngine_DirtyFlag_Enum (QPaintEngine::DirtyOpacity); }
static QPaintEngine_DirtyFlag_Enum *c_14_QPaintEngine_DirtyFlag_Enum () { return new QPaintEngine_DirtyFlag_Enum (QPaintEngine::AllDirty); }

static gsi::Methods mkdefs_QPaintEngine_DirtyFlag () {
  return
    gsi::constant ("DirtyPen", &qt_gsi::c_1_QPaintEngine_DirtyFlag_Enum, "@brief Enum constant QPaintEngine::DirtyPen") +
    gsi::constant ("DirtyBrush", &qt_gsi::c_2_QPaintEngine_DirtyFlag_Enum, "@brief Enum constant QPaintEngine::DirtyBrush") +
    gsi::constant ("DirtyBrushOrigin", &qt_gsi::c_3_QPaintEngine_DirtyFlag_Enum, "@brief Enum constant QPaintEngine::DirtyBrushOrigin") +
    gsi::constant ("DirtyFont", &qt_gsi::c_4_QPaintEngine_DirtyFlag_Enum, "@brief Enum constant QPaintEngine::DirtyFont") +
    gsi::constant ("DirtyBackground", &qt_gsi::c_5_QPaintEngine_DirtyFlag_Enum, "@brief Enum constant QPaintEngine::DirtyBackground") +
    gsi::constant ("DirtyBackgroundMode", &qt_gsi::c_6_QPaintEngine_DirtyFlag_Enum, "@brief Enum constant QPaintEngine::DirtyBackgroundMode") +
    gsi::constant ("DirtyTransform", &qt_gsi::c_7_QPaintEngine_DirtyFlag_Enum, "@brief Enum constant QPaintEngine::DirtyTransform") +
    gsi::constant ("DirtyClipRegion", &qt_gsi::c_8_QPaintEngine_DirtyFlag_Enum, "@brief Enum constant QPaintEngine::DirtyClipRegion") +
    gsi::constant ("DirtyClipPath", &qt_gsi::c_9_QPaintEngine_DirtyFlag_Enum, "@brief Enum constant QPaintEngine::DirtyClipPath") +
    gsi::constant ("DirtyHints", &qt_gsi::c_10_QPaintEngine_DirtyFlag_Enum, "@brief Enum constant QPaintEngine::DirtyHints") +
    gsi::constant ("DirtyCompositionMode", &qt_gsi::c_11_QPaintEngine_DirtyFlag_Enum, "@brief Enum constant QPaintEngine::DirtyCompositionMode") +
    gsi::constant ("DirtyClipEnabled", &qt_gsi::c_12_QPaintEngine_DirtyFlag_Enum, "@brief Enum constant QPaintEngine::DirtyClipEnabled") +
    gsi::constant ("DirtyOpacity", &qt_gsi::c_13_QPaintEngine_DirtyFlag_Enum, "@brief Enum constant QPaintEngine::DirtyOpacity") +
    gsi::constant ("AllDirty", &qt_gsi::c_14_QPaintEngine_DirtyFlag_Enum, "@brief Enum constant QPaintEngine::AllDirty");
}

static std::string to_s_QPaintEngine_DirtyFlag_Enum (const QPaintEngine_DirtyFlag_Enum *e)
{
  if (e->value () == QPaintEngine::DirtyPen) { return tl::sprintf ("DirtyPen (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::DirtyBrush) { return tl::sprintf ("DirtyBrush (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::DirtyBrushOrigin) { return tl::sprintf ("DirtyBrushOrigin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::DirtyFont) { return tl::sprintf ("DirtyFont (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::DirtyBackground) { return tl::sprintf ("DirtyBackground (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::DirtyBackgroundMode) { return tl::sprintf ("DirtyBackgroundMode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::DirtyTransform) { return tl::sprintf ("DirtyTransform (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::DirtyClipRegion) { return tl::sprintf ("DirtyClipRegion (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::DirtyClipPath) { return tl::sprintf ("DirtyClipPath (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::DirtyHints) { return tl::sprintf ("DirtyHints (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::DirtyCompositionMode) { return tl::sprintf ("DirtyCompositionMode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::DirtyClipEnabled) { return tl::sprintf ("DirtyClipEnabled (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::DirtyOpacity) { return tl::sprintf ("DirtyOpacity (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::AllDirty) { return tl::sprintf ("AllDirty (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QPaintEngine_DirtyFlag_Enum (const QPaintEngine_DirtyFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static QPaintEngine_DirtyFlag_Enum *from_i_QPaintEngine_DirtyFlag_Enum (unsigned int i)
{
  return new QPaintEngine_DirtyFlag_Enum ((QPaintEngine::DirtyFlag) i);
}

static bool equalQPaintEngine_DirtyFlag_Enum (const QPaintEngine_DirtyFlag_Enum *e, QPaintEngine_DirtyFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QPaintEngine_DirtyFlag_Enum (const QPaintEngine_DirtyFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QPaintEngine_DirtyFlag_Enums oropQPaintEngine_DirtyFlag_Enums (const QPaintEngine_DirtyFlag_Enums *e, const QPaintEngine_DirtyFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static QPaintEngine_DirtyFlag_Enums andopQPaintEngine_DirtyFlag_Enums (const QPaintEngine_DirtyFlag_Enums *e, const QPaintEngine_DirtyFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static QPaintEngine_DirtyFlag_Enums xoropQPaintEngine_DirtyFlag_Enums (const QPaintEngine_DirtyFlag_Enums *e, const QPaintEngine_DirtyFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QPaintEngine_DirtyFlag_Enums (const QPaintEngine_DirtyFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (QPaintEngine::DirtyPen)) { if (!l.empty ()) l += "|"; l += "DirtyPen"; }
  if (e->testFlag (QPaintEngine::DirtyBrush)) { if (!l.empty ()) l += "|"; l += "DirtyBrush"; }
  if (e->testFlag (QPaintEngine::DirtyBrushOrigin)) { if (!l.empty ()) l += "|"; l += "DirtyBrushOrigin"; }
  if (e->testFlag (QPaintEngine::DirtyFont)) { if (!l.empty ()) l += "|"; l += "DirtyFont"; }
  if (e->testFlag (QPaintEngine::DirtyBackground)) { if (!l.empty ()) l += "|"; l += "DirtyBackground"; }
  if (e->testFlag (QPaintEngine::DirtyBackgroundMode)) { if (!l.empty ()) l += "|"; l += "DirtyBackgroundMode"; }
  if (e->testFlag (QPaintEngine::DirtyTransform)) { if (!l.empty ()) l += "|"; l += "DirtyTransform"; }
  if (e->testFlag (QPaintEngine::DirtyClipRegion)) { if (!l.empty ()) l += "|"; l += "DirtyClipRegion"; }
  if (e->testFlag (QPaintEngine::DirtyClipPath)) { if (!l.empty ()) l += "|"; l += "DirtyClipPath"; }
  if (e->testFlag (QPaintEngine::DirtyHints)) { if (!l.empty ()) l += "|"; l += "DirtyHints"; }
  if (e->testFlag (QPaintEngine::DirtyCompositionMode)) { if (!l.empty ()) l += "|"; l += "DirtyCompositionMode"; }
  if (e->testFlag (QPaintEngine::DirtyClipEnabled)) { if (!l.empty ()) l += "|"; l += "DirtyClipEnabled"; }
  if (e->testFlag (QPaintEngine::DirtyOpacity)) { if (!l.empty ()) l += "|"; l += "DirtyOpacity"; }
  if (e->testFlag (QPaintEngine::AllDirty)) { if (!l.empty ()) l += "|"; l += "AllDirty"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QPaintEngine_DirtyFlag_Enums (const QPaintEngine_DirtyFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QPaintEngine_DirtyFlag_Enums (const QPaintEngine_DirtyFlag_Enums *e, const QPaintEngine_DirtyFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QPaintEngine_DirtyFlag_Enums> decl_QPaintEngine_DirtyFlag_Enums ("QPaintEngine_QFlags_DirtyFlag",
  gsi::method_ext ("|", &qt_gsi::oropQPaintEngine_DirtyFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQPaintEngine_DirtyFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQPaintEngine_DirtyFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QPaintEngine_DirtyFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QPaintEngine_DirtyFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QPaintEngine_DirtyFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QPaintEngine::DirtyFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QPaintEngine_DirtyFlag_Enum> decl_QPaintEngine_DirtyFlag_Enum (decl_QPaintEngine_DirtyFlag_Enums, "QPaintEngine_DirtyFlag",
  qt_gsi::mkdefs_QPaintEngine_DirtyFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QPaintEngine_DirtyFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QPaintEngine_DirtyFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQPaintEngine_DirtyFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QPaintEngine_DirtyFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QPaintEngine_DirtyFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QPaintEngine::DirtyFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QPaintEngine> inject_QPaintEngine_DirtyFlag_Enum_in_parent (qt_gsi::mkdefs_QPaintEngine_DirtyFlag ());
static gsi::ClassExt<QPaintEngine> decl_QPaintEngine_DirtyFlag_Enum_as_child (decl_QPaintEngine_DirtyFlag_Enum, "DirtyFlag");

}


//  Implementation of the enum wrapper class for QPaintEngine::PaintEngineFeature
namespace qt_gsi
{

static QPaintEngine_PaintEngineFeature_Enum *c_1_QPaintEngine_PaintEngineFeature_Enum () { return new QPaintEngine_PaintEngineFeature_Enum (QPaintEngine::PrimitiveTransform); }
static QPaintEngine_PaintEngineFeature_Enum *c_2_QPaintEngine_PaintEngineFeature_Enum () { return new QPaintEngine_PaintEngineFeature_Enum (QPaintEngine::PatternTransform); }
static QPaintEngine_PaintEngineFeature_Enum *c_3_QPaintEngine_PaintEngineFeature_Enum () { return new QPaintEngine_PaintEngineFeature_Enum (QPaintEngine::PixmapTransform); }
static QPaintEngine_PaintEngineFeature_Enum *c_4_QPaintEngine_PaintEngineFeature_Enum () { return new QPaintEngine_PaintEngineFeature_Enum (QPaintEngine::PatternBrush); }
static QPaintEngine_PaintEngineFeature_Enum *c_5_QPaintEngine_PaintEngineFeature_Enum () { return new QPaintEngine_PaintEngineFeature_Enum (QPaintEngine::LinearGradientFill); }
static QPaintEngine_PaintEngineFeature_Enum *c_6_QPaintEngine_PaintEngineFeature_Enum () { return new QPaintEngine_PaintEngineFeature_Enum (QPaintEngine::RadialGradientFill); }
static QPaintEngine_PaintEngineFeature_Enum *c_7_QPaintEngine_PaintEngineFeature_Enum () { return new QPaintEngine_PaintEngineFeature_Enum (QPaintEngine::ConicalGradientFill); }
static QPaintEngine_PaintEngineFeature_Enum *c_8_QPaintEngine_PaintEngineFeature_Enum () { return new QPaintEngine_PaintEngineFeature_Enum (QPaintEngine::AlphaBlend); }
static QPaintEngine_PaintEngineFeature_Enum *c_9_QPaintEngine_PaintEngineFeature_Enum () { return new QPaintEngine_PaintEngineFeature_Enum (QPaintEngine::PorterDuff); }
static QPaintEngine_PaintEngineFeature_Enum *c_10_QPaintEngine_PaintEngineFeature_Enum () { return new QPaintEngine_PaintEngineFeature_Enum (QPaintEngine::PainterPaths); }
static QPaintEngine_PaintEngineFeature_Enum *c_11_QPaintEngine_PaintEngineFeature_Enum () { return new QPaintEngine_PaintEngineFeature_Enum (QPaintEngine::Antialiasing); }
static QPaintEngine_PaintEngineFeature_Enum *c_12_QPaintEngine_PaintEngineFeature_Enum () { return new QPaintEngine_PaintEngineFeature_Enum (QPaintEngine::BrushStroke); }
static QPaintEngine_PaintEngineFeature_Enum *c_13_QPaintEngine_PaintEngineFeature_Enum () { return new QPaintEngine_PaintEngineFeature_Enum (QPaintEngine::ConstantOpacity); }
static QPaintEngine_PaintEngineFeature_Enum *c_14_QPaintEngine_PaintEngineFeature_Enum () { return new QPaintEngine_PaintEngineFeature_Enum (QPaintEngine::MaskedBrush); }
static QPaintEngine_PaintEngineFeature_Enum *c_15_QPaintEngine_PaintEngineFeature_Enum () { return new QPaintEngine_PaintEngineFeature_Enum (QPaintEngine::PerspectiveTransform); }
static QPaintEngine_PaintEngineFeature_Enum *c_16_QPaintEngine_PaintEngineFeature_Enum () { return new QPaintEngine_PaintEngineFeature_Enum (QPaintEngine::BlendModes); }
static QPaintEngine_PaintEngineFeature_Enum *c_17_QPaintEngine_PaintEngineFeature_Enum () { return new QPaintEngine_PaintEngineFeature_Enum (QPaintEngine::ObjectBoundingModeGradients); }
static QPaintEngine_PaintEngineFeature_Enum *c_18_QPaintEngine_PaintEngineFeature_Enum () { return new QPaintEngine_PaintEngineFeature_Enum (QPaintEngine::RasterOpModes); }
static QPaintEngine_PaintEngineFeature_Enum *c_19_QPaintEngine_PaintEngineFeature_Enum () { return new QPaintEngine_PaintEngineFeature_Enum (QPaintEngine::PaintOutsidePaintEvent); }
static QPaintEngine_PaintEngineFeature_Enum *c_20_QPaintEngine_PaintEngineFeature_Enum () { return new QPaintEngine_PaintEngineFeature_Enum (QPaintEngine::AllFeatures); }

static gsi::Methods mkdefs_QPaintEngine_PaintEngineFeature () {
  return
    gsi::constant ("PrimitiveTransform", &qt_gsi::c_1_QPaintEngine_PaintEngineFeature_Enum, "@brief Enum constant QPaintEngine::PrimitiveTransform") +
    gsi::constant ("PatternTransform", &qt_gsi::c_2_QPaintEngine_PaintEngineFeature_Enum, "@brief Enum constant QPaintEngine::PatternTransform") +
    gsi::constant ("PixmapTransform", &qt_gsi::c_3_QPaintEngine_PaintEngineFeature_Enum, "@brief Enum constant QPaintEngine::PixmapTransform") +
    gsi::constant ("PatternBrush", &qt_gsi::c_4_QPaintEngine_PaintEngineFeature_Enum, "@brief Enum constant QPaintEngine::PatternBrush") +
    gsi::constant ("LinearGradientFill", &qt_gsi::c_5_QPaintEngine_PaintEngineFeature_Enum, "@brief Enum constant QPaintEngine::LinearGradientFill") +
    gsi::constant ("RadialGradientFill", &qt_gsi::c_6_QPaintEngine_PaintEngineFeature_Enum, "@brief Enum constant QPaintEngine::RadialGradientFill") +
    gsi::constant ("ConicalGradientFill", &qt_gsi::c_7_QPaintEngine_PaintEngineFeature_Enum, "@brief Enum constant QPaintEngine::ConicalGradientFill") +
    gsi::constant ("AlphaBlend", &qt_gsi::c_8_QPaintEngine_PaintEngineFeature_Enum, "@brief Enum constant QPaintEngine::AlphaBlend") +
    gsi::constant ("PorterDuff", &qt_gsi::c_9_QPaintEngine_PaintEngineFeature_Enum, "@brief Enum constant QPaintEngine::PorterDuff") +
    gsi::constant ("PainterPaths", &qt_gsi::c_10_QPaintEngine_PaintEngineFeature_Enum, "@brief Enum constant QPaintEngine::PainterPaths") +
    gsi::constant ("Antialiasing", &qt_gsi::c_11_QPaintEngine_PaintEngineFeature_Enum, "@brief Enum constant QPaintEngine::Antialiasing") +
    gsi::constant ("BrushStroke", &qt_gsi::c_12_QPaintEngine_PaintEngineFeature_Enum, "@brief Enum constant QPaintEngine::BrushStroke") +
    gsi::constant ("ConstantOpacity", &qt_gsi::c_13_QPaintEngine_PaintEngineFeature_Enum, "@brief Enum constant QPaintEngine::ConstantOpacity") +
    gsi::constant ("MaskedBrush", &qt_gsi::c_14_QPaintEngine_PaintEngineFeature_Enum, "@brief Enum constant QPaintEngine::MaskedBrush") +
    gsi::constant ("PerspectiveTransform", &qt_gsi::c_15_QPaintEngine_PaintEngineFeature_Enum, "@brief Enum constant QPaintEngine::PerspectiveTransform") +
    gsi::constant ("BlendModes", &qt_gsi::c_16_QPaintEngine_PaintEngineFeature_Enum, "@brief Enum constant QPaintEngine::BlendModes") +
    gsi::constant ("ObjectBoundingModeGradients", &qt_gsi::c_17_QPaintEngine_PaintEngineFeature_Enum, "@brief Enum constant QPaintEngine::ObjectBoundingModeGradients") +
    gsi::constant ("RasterOpModes", &qt_gsi::c_18_QPaintEngine_PaintEngineFeature_Enum, "@brief Enum constant QPaintEngine::RasterOpModes") +
    gsi::constant ("PaintOutsidePaintEvent", &qt_gsi::c_19_QPaintEngine_PaintEngineFeature_Enum, "@brief Enum constant QPaintEngine::PaintOutsidePaintEvent") +
    gsi::constant ("AllFeatures", &qt_gsi::c_20_QPaintEngine_PaintEngineFeature_Enum, "@brief Enum constant QPaintEngine::AllFeatures");
}

static std::string to_s_QPaintEngine_PaintEngineFeature_Enum (const QPaintEngine_PaintEngineFeature_Enum *e)
{
  if (e->value () == QPaintEngine::PrimitiveTransform) { return tl::sprintf ("PrimitiveTransform (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::PatternTransform) { return tl::sprintf ("PatternTransform (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::PixmapTransform) { return tl::sprintf ("PixmapTransform (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::PatternBrush) { return tl::sprintf ("PatternBrush (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::LinearGradientFill) { return tl::sprintf ("LinearGradientFill (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::RadialGradientFill) { return tl::sprintf ("RadialGradientFill (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::ConicalGradientFill) { return tl::sprintf ("ConicalGradientFill (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::AlphaBlend) { return tl::sprintf ("AlphaBlend (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::PorterDuff) { return tl::sprintf ("PorterDuff (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::PainterPaths) { return tl::sprintf ("PainterPaths (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::Antialiasing) { return tl::sprintf ("Antialiasing (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::BrushStroke) { return tl::sprintf ("BrushStroke (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::ConstantOpacity) { return tl::sprintf ("ConstantOpacity (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::MaskedBrush) { return tl::sprintf ("MaskedBrush (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::PerspectiveTransform) { return tl::sprintf ("PerspectiveTransform (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::BlendModes) { return tl::sprintf ("BlendModes (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::ObjectBoundingModeGradients) { return tl::sprintf ("ObjectBoundingModeGradients (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::RasterOpModes) { return tl::sprintf ("RasterOpModes (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::PaintOutsidePaintEvent) { return tl::sprintf ("PaintOutsidePaintEvent (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::AllFeatures) { return tl::sprintf ("AllFeatures (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QPaintEngine_PaintEngineFeature_Enum (const QPaintEngine_PaintEngineFeature_Enum *e)
{
  return (unsigned int) e->value ();
}

static QPaintEngine_PaintEngineFeature_Enum *from_i_QPaintEngine_PaintEngineFeature_Enum (unsigned int i)
{
  return new QPaintEngine_PaintEngineFeature_Enum ((QPaintEngine::PaintEngineFeature) i);
}

static bool equalQPaintEngine_PaintEngineFeature_Enum (const QPaintEngine_PaintEngineFeature_Enum *e, QPaintEngine_PaintEngineFeature_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QPaintEngine_PaintEngineFeature_Enum (const QPaintEngine_PaintEngineFeature_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QPaintEngine_PaintEngineFeature_Enums oropQPaintEngine_PaintEngineFeature_Enums (const QPaintEngine_PaintEngineFeature_Enums *e, const QPaintEngine_PaintEngineFeature_Enums &d)
{
  return e->flags () | d.flags ();
}

static QPaintEngine_PaintEngineFeature_Enums andopQPaintEngine_PaintEngineFeature_Enums (const QPaintEngine_PaintEngineFeature_Enums *e, const QPaintEngine_PaintEngineFeature_Enums &d)
{
  return e->flags () & d.flags ();
}

static QPaintEngine_PaintEngineFeature_Enums xoropQPaintEngine_PaintEngineFeature_Enums (const QPaintEngine_PaintEngineFeature_Enums *e, const QPaintEngine_PaintEngineFeature_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QPaintEngine_PaintEngineFeature_Enums (const QPaintEngine_PaintEngineFeature_Enums *e)
{
  std::string l;
  if (e->testFlag (QPaintEngine::PrimitiveTransform)) { if (!l.empty ()) l += "|"; l += "PrimitiveTransform"; }
  if (e->testFlag (QPaintEngine::PatternTransform)) { if (!l.empty ()) l += "|"; l += "PatternTransform"; }
  if (e->testFlag (QPaintEngine::PixmapTransform)) { if (!l.empty ()) l += "|"; l += "PixmapTransform"; }
  if (e->testFlag (QPaintEngine::PatternBrush)) { if (!l.empty ()) l += "|"; l += "PatternBrush"; }
  if (e->testFlag (QPaintEngine::LinearGradientFill)) { if (!l.empty ()) l += "|"; l += "LinearGradientFill"; }
  if (e->testFlag (QPaintEngine::RadialGradientFill)) { if (!l.empty ()) l += "|"; l += "RadialGradientFill"; }
  if (e->testFlag (QPaintEngine::ConicalGradientFill)) { if (!l.empty ()) l += "|"; l += "ConicalGradientFill"; }
  if (e->testFlag (QPaintEngine::AlphaBlend)) { if (!l.empty ()) l += "|"; l += "AlphaBlend"; }
  if (e->testFlag (QPaintEngine::PorterDuff)) { if (!l.empty ()) l += "|"; l += "PorterDuff"; }
  if (e->testFlag (QPaintEngine::PainterPaths)) { if (!l.empty ()) l += "|"; l += "PainterPaths"; }
  if (e->testFlag (QPaintEngine::Antialiasing)) { if (!l.empty ()) l += "|"; l += "Antialiasing"; }
  if (e->testFlag (QPaintEngine::BrushStroke)) { if (!l.empty ()) l += "|"; l += "BrushStroke"; }
  if (e->testFlag (QPaintEngine::ConstantOpacity)) { if (!l.empty ()) l += "|"; l += "ConstantOpacity"; }
  if (e->testFlag (QPaintEngine::MaskedBrush)) { if (!l.empty ()) l += "|"; l += "MaskedBrush"; }
  if (e->testFlag (QPaintEngine::PerspectiveTransform)) { if (!l.empty ()) l += "|"; l += "PerspectiveTransform"; }
  if (e->testFlag (QPaintEngine::BlendModes)) { if (!l.empty ()) l += "|"; l += "BlendModes"; }
  if (e->testFlag (QPaintEngine::ObjectBoundingModeGradients)) { if (!l.empty ()) l += "|"; l += "ObjectBoundingModeGradients"; }
  if (e->testFlag (QPaintEngine::RasterOpModes)) { if (!l.empty ()) l += "|"; l += "RasterOpModes"; }
  if (e->testFlag (QPaintEngine::PaintOutsidePaintEvent)) { if (!l.empty ()) l += "|"; l += "PaintOutsidePaintEvent"; }
  if (e->testFlag (QPaintEngine::AllFeatures)) { if (!l.empty ()) l += "|"; l += "AllFeatures"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QPaintEngine_PaintEngineFeature_Enums (const QPaintEngine_PaintEngineFeature_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QPaintEngine_PaintEngineFeature_Enums (const QPaintEngine_PaintEngineFeature_Enums *e, const QPaintEngine_PaintEngineFeature_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QPaintEngine_PaintEngineFeature_Enums> decl_QPaintEngine_PaintEngineFeature_Enums ("QPaintEngine_QFlags_PaintEngineFeature",
  gsi::method_ext ("|", &qt_gsi::oropQPaintEngine_PaintEngineFeature_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQPaintEngine_PaintEngineFeature_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQPaintEngine_PaintEngineFeature_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QPaintEngine_PaintEngineFeature_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QPaintEngine_PaintEngineFeature_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QPaintEngine_PaintEngineFeature_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QPaintEngine::PaintEngineFeature> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QPaintEngine_PaintEngineFeature_Enum> decl_QPaintEngine_PaintEngineFeature_Enum (decl_QPaintEngine_PaintEngineFeature_Enums, "QPaintEngine_PaintEngineFeature",
  qt_gsi::mkdefs_QPaintEngine_PaintEngineFeature () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QPaintEngine_PaintEngineFeature_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QPaintEngine_PaintEngineFeature_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQPaintEngine_PaintEngineFeature_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QPaintEngine_PaintEngineFeature_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QPaintEngine_PaintEngineFeature_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QPaintEngine::PaintEngineFeature enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QPaintEngine> inject_QPaintEngine_PaintEngineFeature_Enum_in_parent (qt_gsi::mkdefs_QPaintEngine_PaintEngineFeature ());
static gsi::ClassExt<QPaintEngine> decl_QPaintEngine_PaintEngineFeature_Enum_as_child (decl_QPaintEngine_PaintEngineFeature_Enum, "PaintEngineFeature");

}


//  Implementation of the enum wrapper class for QPaintEngine::Type
namespace qt_gsi
{

static QPaintEngine_Type_Enum *c_1_QPaintEngine_Type_Enum () { return new QPaintEngine_Type_Enum (QPaintEngine::X11); }
static QPaintEngine_Type_Enum *c_2_QPaintEngine_Type_Enum () { return new QPaintEngine_Type_Enum (QPaintEngine::Windows); }
static QPaintEngine_Type_Enum *c_3_QPaintEngine_Type_Enum () { return new QPaintEngine_Type_Enum (QPaintEngine::QuickDraw); }
static QPaintEngine_Type_Enum *c_4_QPaintEngine_Type_Enum () { return new QPaintEngine_Type_Enum (QPaintEngine::CoreGraphics); }
static QPaintEngine_Type_Enum *c_5_QPaintEngine_Type_Enum () { return new QPaintEngine_Type_Enum (QPaintEngine::MacPrinter); }
static QPaintEngine_Type_Enum *c_6_QPaintEngine_Type_Enum () { return new QPaintEngine_Type_Enum (QPaintEngine::QWindowSystem); }
static QPaintEngine_Type_Enum *c_7_QPaintEngine_Type_Enum () { return new QPaintEngine_Type_Enum (QPaintEngine::PostScript); }
static QPaintEngine_Type_Enum *c_8_QPaintEngine_Type_Enum () { return new QPaintEngine_Type_Enum (QPaintEngine::OpenGL); }
static QPaintEngine_Type_Enum *c_9_QPaintEngine_Type_Enum () { return new QPaintEngine_Type_Enum (QPaintEngine::Picture); }
static QPaintEngine_Type_Enum *c_10_QPaintEngine_Type_Enum () { return new QPaintEngine_Type_Enum (QPaintEngine::SVG); }
static QPaintEngine_Type_Enum *c_11_QPaintEngine_Type_Enum () { return new QPaintEngine_Type_Enum (QPaintEngine::Raster); }
static QPaintEngine_Type_Enum *c_12_QPaintEngine_Type_Enum () { return new QPaintEngine_Type_Enum (QPaintEngine::Direct3D); }
static QPaintEngine_Type_Enum *c_13_QPaintEngine_Type_Enum () { return new QPaintEngine_Type_Enum (QPaintEngine::Pdf); }
static QPaintEngine_Type_Enum *c_14_QPaintEngine_Type_Enum () { return new QPaintEngine_Type_Enum (QPaintEngine::OpenVG); }
static QPaintEngine_Type_Enum *c_15_QPaintEngine_Type_Enum () { return new QPaintEngine_Type_Enum (QPaintEngine::OpenGL2); }
static QPaintEngine_Type_Enum *c_16_QPaintEngine_Type_Enum () { return new QPaintEngine_Type_Enum (QPaintEngine::PaintBuffer); }
static QPaintEngine_Type_Enum *c_17_QPaintEngine_Type_Enum () { return new QPaintEngine_Type_Enum (QPaintEngine::User); }
static QPaintEngine_Type_Enum *c_18_QPaintEngine_Type_Enum () { return new QPaintEngine_Type_Enum (QPaintEngine::MaxUser); }

static gsi::Methods mkdefs_QPaintEngine_Type () {
  return
    gsi::constant ("X11", &qt_gsi::c_1_QPaintEngine_Type_Enum, "@brief Enum constant QPaintEngine::X11") +
    gsi::constant ("Windows", &qt_gsi::c_2_QPaintEngine_Type_Enum, "@brief Enum constant QPaintEngine::Windows") +
    gsi::constant ("QuickDraw", &qt_gsi::c_3_QPaintEngine_Type_Enum, "@brief Enum constant QPaintEngine::QuickDraw") +
    gsi::constant ("CoreGraphics", &qt_gsi::c_4_QPaintEngine_Type_Enum, "@brief Enum constant QPaintEngine::CoreGraphics") +
    gsi::constant ("MacPrinter", &qt_gsi::c_5_QPaintEngine_Type_Enum, "@brief Enum constant QPaintEngine::MacPrinter") +
    gsi::constant ("QWindowSystem", &qt_gsi::c_6_QPaintEngine_Type_Enum, "@brief Enum constant QPaintEngine::QWindowSystem") +
    gsi::constant ("PostScript", &qt_gsi::c_7_QPaintEngine_Type_Enum, "@brief Enum constant QPaintEngine::PostScript") +
    gsi::constant ("OpenGL", &qt_gsi::c_8_QPaintEngine_Type_Enum, "@brief Enum constant QPaintEngine::OpenGL") +
    gsi::constant ("Picture", &qt_gsi::c_9_QPaintEngine_Type_Enum, "@brief Enum constant QPaintEngine::Picture") +
    gsi::constant ("SVG", &qt_gsi::c_10_QPaintEngine_Type_Enum, "@brief Enum constant QPaintEngine::SVG") +
    gsi::constant ("Raster", &qt_gsi::c_11_QPaintEngine_Type_Enum, "@brief Enum constant QPaintEngine::Raster") +
    gsi::constant ("Direct3D", &qt_gsi::c_12_QPaintEngine_Type_Enum, "@brief Enum constant QPaintEngine::Direct3D") +
    gsi::constant ("Pdf", &qt_gsi::c_13_QPaintEngine_Type_Enum, "@brief Enum constant QPaintEngine::Pdf") +
    gsi::constant ("OpenVG", &qt_gsi::c_14_QPaintEngine_Type_Enum, "@brief Enum constant QPaintEngine::OpenVG") +
    gsi::constant ("OpenGL2", &qt_gsi::c_15_QPaintEngine_Type_Enum, "@brief Enum constant QPaintEngine::OpenGL2") +
    gsi::constant ("PaintBuffer", &qt_gsi::c_16_QPaintEngine_Type_Enum, "@brief Enum constant QPaintEngine::PaintBuffer") +
    gsi::constant ("User", &qt_gsi::c_17_QPaintEngine_Type_Enum, "@brief Enum constant QPaintEngine::User") +
    gsi::constant ("MaxUser", &qt_gsi::c_18_QPaintEngine_Type_Enum, "@brief Enum constant QPaintEngine::MaxUser");
}

static std::string to_s_QPaintEngine_Type_Enum (const QPaintEngine_Type_Enum *e)
{
  if (e->value () == QPaintEngine::X11) { return tl::sprintf ("X11 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::Windows) { return tl::sprintf ("Windows (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::QuickDraw) { return tl::sprintf ("QuickDraw (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::CoreGraphics) { return tl::sprintf ("CoreGraphics (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::MacPrinter) { return tl::sprintf ("MacPrinter (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::QWindowSystem) { return tl::sprintf ("QWindowSystem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::PostScript) { return tl::sprintf ("PostScript (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::OpenGL) { return tl::sprintf ("OpenGL (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::Picture) { return tl::sprintf ("Picture (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::SVG) { return tl::sprintf ("SVG (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::Raster) { return tl::sprintf ("Raster (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::Direct3D) { return tl::sprintf ("Direct3D (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::Pdf) { return tl::sprintf ("Pdf (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::OpenVG) { return tl::sprintf ("OpenVG (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::OpenGL2) { return tl::sprintf ("OpenGL2 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::PaintBuffer) { return tl::sprintf ("PaintBuffer (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::User) { return tl::sprintf ("User (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPaintEngine::MaxUser) { return tl::sprintf ("MaxUser (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QPaintEngine_Type_Enum (const QPaintEngine_Type_Enum *e)
{
  return (unsigned int) e->value ();
}

static QPaintEngine_Type_Enum *from_i_QPaintEngine_Type_Enum (unsigned int i)
{
  return new QPaintEngine_Type_Enum ((QPaintEngine::Type) i);
}

static bool equalQPaintEngine_Type_Enum (const QPaintEngine_Type_Enum *e, QPaintEngine_Type_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QPaintEngine_Type_Enum (const QPaintEngine_Type_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QPaintEngine_Type_Enums oropQPaintEngine_Type_Enums (const QPaintEngine_Type_Enums *e, const QPaintEngine_Type_Enums &d)
{
  return e->flags () | d.flags ();
}

static QPaintEngine_Type_Enums andopQPaintEngine_Type_Enums (const QPaintEngine_Type_Enums *e, const QPaintEngine_Type_Enums &d)
{
  return e->flags () & d.flags ();
}

static QPaintEngine_Type_Enums xoropQPaintEngine_Type_Enums (const QPaintEngine_Type_Enums *e, const QPaintEngine_Type_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QPaintEngine_Type_Enums (const QPaintEngine_Type_Enums *e)
{
  std::string l;
  if (e->testFlag (QPaintEngine::X11)) { if (!l.empty ()) l += "|"; l += "X11"; }
  if (e->testFlag (QPaintEngine::Windows)) { if (!l.empty ()) l += "|"; l += "Windows"; }
  if (e->testFlag (QPaintEngine::QuickDraw)) { if (!l.empty ()) l += "|"; l += "QuickDraw"; }
  if (e->testFlag (QPaintEngine::CoreGraphics)) { if (!l.empty ()) l += "|"; l += "CoreGraphics"; }
  if (e->testFlag (QPaintEngine::MacPrinter)) { if (!l.empty ()) l += "|"; l += "MacPrinter"; }
  if (e->testFlag (QPaintEngine::QWindowSystem)) { if (!l.empty ()) l += "|"; l += "QWindowSystem"; }
  if (e->testFlag (QPaintEngine::PostScript)) { if (!l.empty ()) l += "|"; l += "PostScript"; }
  if (e->testFlag (QPaintEngine::OpenGL)) { if (!l.empty ()) l += "|"; l += "OpenGL"; }
  if (e->testFlag (QPaintEngine::Picture)) { if (!l.empty ()) l += "|"; l += "Picture"; }
  if (e->testFlag (QPaintEngine::SVG)) { if (!l.empty ()) l += "|"; l += "SVG"; }
  if (e->testFlag (QPaintEngine::Raster)) { if (!l.empty ()) l += "|"; l += "Raster"; }
  if (e->testFlag (QPaintEngine::Direct3D)) { if (!l.empty ()) l += "|"; l += "Direct3D"; }
  if (e->testFlag (QPaintEngine::Pdf)) { if (!l.empty ()) l += "|"; l += "Pdf"; }
  if (e->testFlag (QPaintEngine::OpenVG)) { if (!l.empty ()) l += "|"; l += "OpenVG"; }
  if (e->testFlag (QPaintEngine::OpenGL2)) { if (!l.empty ()) l += "|"; l += "OpenGL2"; }
  if (e->testFlag (QPaintEngine::PaintBuffer)) { if (!l.empty ()) l += "|"; l += "PaintBuffer"; }
  if (e->testFlag (QPaintEngine::User)) { if (!l.empty ()) l += "|"; l += "User"; }
  if (e->testFlag (QPaintEngine::MaxUser)) { if (!l.empty ()) l += "|"; l += "MaxUser"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QPaintEngine_Type_Enums (const QPaintEngine_Type_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QPaintEngine_Type_Enums (const QPaintEngine_Type_Enums *e, const QPaintEngine_Type_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QPaintEngine_Type_Enums> decl_QPaintEngine_Type_Enums ("QPaintEngine_QFlags_Type",
  gsi::method_ext ("|", &qt_gsi::oropQPaintEngine_Type_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQPaintEngine_Type_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQPaintEngine_Type_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QPaintEngine_Type_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QPaintEngine_Type_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QPaintEngine_Type_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QPaintEngine::Type> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QPaintEngine_Type_Enum> decl_QPaintEngine_Type_Enum (decl_QPaintEngine_Type_Enums, "QPaintEngine_Type",
  qt_gsi::mkdefs_QPaintEngine_Type () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QPaintEngine_Type_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QPaintEngine_Type_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQPaintEngine_Type_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QPaintEngine_Type_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QPaintEngine_Type_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QPaintEngine::Type enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QPaintEngine> inject_QPaintEngine_Type_Enum_in_parent (qt_gsi::mkdefs_QPaintEngine_Type ());
static gsi::ClassExt<QPaintEngine> decl_QPaintEngine_Type_Enum_as_child (decl_QPaintEngine_Type_Enum, "Type");

}

