
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQObject.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQObject_EventAdaptor.h"
#include "gsiDeclQObject_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QObject

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QObject::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}
  QObject *find_child_impl (QObject *object, const QString &name) { return object->findChild<QObject *> (name); }

// bool QObject::blockSignals(bool b)


static void _init_f_blockSignals_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_blockSignals_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<bool > ((bool)((QObject *)cls)->blockSignals (arg1));
}

static qt_gsi::GenericMethod *_create_f_blockSignals_864 ()
{
  return new qt_gsi::GenericMethod ("blockSignals", "@brief Method bool QObject::blockSignals(bool b)\n", false, &_init_f_blockSignals_864, &_call_f_blockSignals_864);
}

// const QList<QObject *> &QObject::children()


static void _init_f_children_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QObject *> >::target_type > ();
}

static void _call_f_children_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QObject *> >::target_type > ((qt_gsi::Converter<QList<QObject *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QObject *> >(((QObject *)cls)->children ()));
}

static qt_gsi::GenericMethod *_create_f_children_c0 ()
{
  return new qt_gsi::GenericMethod ("children", "@brief Method const QList<QObject *> &QObject::children()\n", true, &_init_f_children_c0, &_call_f_children_c0);
}

// bool QObject::connect(const QObject *sender, const char *signal, const char *member, Qt::ConnectionType type)


static void _init_f_connect_c7342 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sender");
  decl->add_arg<const QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("signal");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("member");
  decl->add_arg<const char * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("type", true, "Qt::AutoConnection");
  decl->add_arg<const qt_gsi::Converter<Qt::ConnectionType>::target_type & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_connect_c7342 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QObject *arg1 = args.read<const QObject * > ();
  const char *arg2 = args.read<const char * > ();
  const char *arg3 = args.read<const char * > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ConnectionType>::target_type & arg4 = args ? args.read<const qt_gsi::Converter<Qt::ConnectionType>::target_type & > () : (const qt_gsi::Converter<Qt::ConnectionType>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::ConnectionType>(heap, Qt::AutoConnection));
  ret.write<bool > ((bool)((QObject *)cls)->connect (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<Qt::ConnectionType>(arg4).cref()));
}

static qt_gsi::GenericMethod *_create_f_connect_c7342 ()
{
  return new qt_gsi::GenericMethod ("connect", "@brief Method bool QObject::connect(const QObject *sender, const char *signal, const char *member, Qt::ConnectionType type)\n", true, &_init_f_connect_c7342, &_call_f_connect_c7342);
}

// void QObject::deleteLater()


static void _init_f_deleteLater_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_deleteLater_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QObject *)cls)->deleteLater ();
}

static qt_gsi::GenericMethod *_create_f_deleteLater_0 ()
{
  return new qt_gsi::GenericMethod ("deleteLater", "@brief Method void QObject::deleteLater()\n", false, &_init_f_deleteLater_0, &_call_f_deleteLater_0);
}

// bool QObject::disconnect(const char *signal, const QObject *receiver, const char *member)


static void _init_f_disconnect_5243 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal", true, "0");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("receiver", true, "0");
  decl->add_arg<const QObject * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("member", true, "0");
  decl->add_arg<const char * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_disconnect_5243 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args ? args.read<const char * > () : (const char *)(0);
  const QObject *arg2 = args ? args.read<const QObject * > () : (const QObject *)(0);
  const char *arg3 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<bool > ((bool)((QObject *)cls)->disconnect (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_disconnect_5243 ()
{
  return new qt_gsi::GenericMethod ("disconnect", "@brief Method bool QObject::disconnect(const char *signal, const QObject *receiver, const char *member)\n", false, &_init_f_disconnect_5243, &_call_f_disconnect_5243);
}

// bool QObject::disconnect(const QObject *receiver, const char *member)


static void _init_f_disconnect_3620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("receiver");
  decl->add_arg<const QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("member", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_disconnect_3620 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QObject *arg1 = args.read<const QObject * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<bool > ((bool)((QObject *)cls)->disconnect (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_disconnect_3620 ()
{
  return new qt_gsi::GenericMethod ("disconnect", "@brief Method bool QObject::disconnect(const QObject *receiver, const char *member)\n", false, &_init_f_disconnect_3620, &_call_f_disconnect_3620);
}

// void QObject::dumpObjectInfo()


static void _init_f_dumpObjectInfo_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_dumpObjectInfo_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QObject *)cls)->dumpObjectInfo ();
}

static qt_gsi::GenericMethod *_create_f_dumpObjectInfo_0 ()
{
  return new qt_gsi::GenericMethod ("dumpObjectInfo", "@brief Method void QObject::dumpObjectInfo()\n", false, &_init_f_dumpObjectInfo_0, &_call_f_dumpObjectInfo_0);
}

// void QObject::dumpObjectTree()


static void _init_f_dumpObjectTree_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_dumpObjectTree_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QObject *)cls)->dumpObjectTree ();
}

static qt_gsi::GenericMethod *_create_f_dumpObjectTree_0 ()
{
  return new qt_gsi::GenericMethod ("dumpObjectTree", "@brief Method void QObject::dumpObjectTree()\n", false, &_init_f_dumpObjectTree_0, &_call_f_dumpObjectTree_0);
}

// QList<QByteArray> QObject::dynamicPropertyNames()


static void _init_f_dynamicPropertyNames_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QByteArray> >::target_type > ();
}

static void _call_f_dynamicPropertyNames_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QByteArray> >::target_type > ((qt_gsi::Converter<QList<QByteArray> >::target_type)qt_gsi::CppToQtAdaptor<QList<QByteArray> >(((QObject *)cls)->dynamicPropertyNames ()));
}

static qt_gsi::GenericMethod *_create_f_dynamicPropertyNames_c0 ()
{
  return new qt_gsi::GenericMethod ("dynamicPropertyNames", "@brief Method QList<QByteArray> QObject::dynamicPropertyNames()\n", true, &_init_f_dynamicPropertyNames_c0, &_call_f_dynamicPropertyNames_c0);
}

// bool QObject::event(QEvent *)


static void _init_f_event_1217 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_event_1217 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QObject *)cls)->event (arg1));
}

static qt_gsi::GenericMethod *_create_f_event_1217 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Method bool QObject::event(QEvent *)\n", false, &_init_f_event_1217, &_call_f_event_1217);
}

// bool QObject::eventFilter(QObject *, QEvent *)


static void _init_f_eventFilter_2411 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_eventFilter_2411 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QObject *)cls)->eventFilter (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_eventFilter_2411 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Method bool QObject::eventFilter(QObject *, QEvent *)\n", false, &_init_f_eventFilter_2411, &_call_f_eventFilter_2411);
}

// bool QObject::inherits(const char *classname)


static void _init_f_inherits_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("classname");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_inherits_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<bool > ((bool)((QObject *)cls)->inherits (arg1));
}

static qt_gsi::GenericMethod *_create_f_inherits_c1731 ()
{
  return new qt_gsi::GenericMethod ("inherits", "@brief Method bool QObject::inherits(const char *classname)\n", true, &_init_f_inherits_c1731, &_call_f_inherits_c1731);
}

// void QObject::installEventFilter(QObject *)


static void _init_f_installEventFilter_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_installEventFilter_1302 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  ((QObject *)cls)->installEventFilter (arg1);
}

static qt_gsi::GenericMethod *_create_f_installEventFilter_1302 ()
{
  return new qt_gsi::GenericMethod ("installEventFilter", "@brief Method void QObject::installEventFilter(QObject *)\n", false, &_init_f_installEventFilter_1302, &_call_f_installEventFilter_1302);
}

// bool QObject::isWidgetType()


static void _init_f_isWidgetType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isWidgetType_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QObject *)cls)->isWidgetType ());
}

static qt_gsi::GenericMethod *_create_f_isWidgetType_c0 ()
{
  return new qt_gsi::GenericMethod ("isWidgetType?", "@brief Method bool QObject::isWidgetType()\n", true, &_init_f_isWidgetType_c0, &_call_f_isWidgetType_c0);
}

// void QObject::killTimer(int id)


static void _init_f_killTimer_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_killTimer_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QObject *)cls)->killTimer (arg1);
}

static qt_gsi::GenericMethod *_create_f_killTimer_767 ()
{
  return new qt_gsi::GenericMethod ("killTimer", "@brief Method void QObject::killTimer(int id)\n", false, &_init_f_killTimer_767, &_call_f_killTimer_767);
}

// void QObject::moveToThread(QThread *thread)


static void _init_f_moveToThread_1303 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("thread");
  decl->add_arg<QThread * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_moveToThread_1303 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QThread *arg1 = args.read<QThread * > ();
  ((QObject *)cls)->moveToThread (arg1);
}

static qt_gsi::GenericMethod *_create_f_moveToThread_1303 ()
{
  return new qt_gsi::GenericMethod ("moveToThread", "@brief Method void QObject::moveToThread(QThread *thread)\n", false, &_init_f_moveToThread_1303, &_call_f_moveToThread_1303);
}

// QString QObject::objectName()


static void _init_f_objectName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_objectName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QObject *)cls)->objectName ());
}

static qt_gsi::GenericMethod *_create_f_objectName_c0 ()
{
  return new qt_gsi::GenericMethod (":objectName", "@brief Method QString QObject::objectName()\n", true, &_init_f_objectName_c0, &_call_f_objectName_c0);
}

// QObject *QObject::parent()


static void _init_f_parent_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_f_parent_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QObject *)cls)->parent ());
}

static qt_gsi::GenericMethod *_create_f_parent_c0 ()
{
  return new qt_gsi::GenericMethod (":parent", "@brief Method QObject *QObject::parent()\n", true, &_init_f_parent_c0, &_call_f_parent_c0);
}

// QVariant QObject::property(const char *name)


static void _init_f_property_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_property_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<QVariant > ((QVariant)((QObject *)cls)->property (arg1));
}

static qt_gsi::GenericMethod *_create_f_property_c1731 ()
{
  return new qt_gsi::GenericMethod ("property", "@brief Method QVariant QObject::property(const char *name)\n", true, &_init_f_property_c1731, &_call_f_property_c1731);
}

// void QObject::removeEventFilter(QObject *)


static void _init_f_removeEventFilter_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeEventFilter_1302 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  ((QObject *)cls)->removeEventFilter (arg1);
}

static qt_gsi::GenericMethod *_create_f_removeEventFilter_1302 ()
{
  return new qt_gsi::GenericMethod ("removeEventFilter", "@brief Method void QObject::removeEventFilter(QObject *)\n", false, &_init_f_removeEventFilter_1302, &_call_f_removeEventFilter_1302);
}

// void QObject::setObjectName(const QString &name)


static void _init_f_setObjectName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setObjectName_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QObject *)cls)->setObjectName (arg1);
}

static qt_gsi::GenericMethod *_create_f_setObjectName_2025 ()
{
  return new qt_gsi::GenericMethod ("setObjectName|objectName=", "@brief Method void QObject::setObjectName(const QString &name)\n", false, &_init_f_setObjectName_2025, &_call_f_setObjectName_2025);
}

// void QObject::setParent(QObject *)


static void _init_f_setParent_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setParent_1302 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  ((QObject *)cls)->setParent (arg1);
}

static qt_gsi::GenericMethod *_create_f_setParent_1302 ()
{
  return new qt_gsi::GenericMethod ("setParent|parent=", "@brief Method void QObject::setParent(QObject *)\n", false, &_init_f_setParent_1302, &_call_f_setParent_1302);
}

// bool QObject::setProperty(const char *name, const QVariant &value)


static void _init_f_setProperty_3742 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_setProperty_3742 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  ret.write<bool > ((bool)((QObject *)cls)->setProperty (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_setProperty_3742 ()
{
  return new qt_gsi::GenericMethod ("setProperty", "@brief Method bool QObject::setProperty(const char *name, const QVariant &value)\n", false, &_init_f_setProperty_3742, &_call_f_setProperty_3742);
}

// bool QObject::signalsBlocked()


static void _init_f_signalsBlocked_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_signalsBlocked_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QObject *)cls)->signalsBlocked ());
}

static qt_gsi::GenericMethod *_create_f_signalsBlocked_c0 ()
{
  return new qt_gsi::GenericMethod ("signalsBlocked", "@brief Method bool QObject::signalsBlocked()\n", true, &_init_f_signalsBlocked_c0, &_call_f_signalsBlocked_c0);
}

// int QObject::startTimer(int interval)


static void _init_f_startTimer_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("interval");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_startTimer_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QObject *)cls)->startTimer (arg1));
}

static qt_gsi::GenericMethod *_create_f_startTimer_767 ()
{
  return new qt_gsi::GenericMethod ("startTimer", "@brief Method int QObject::startTimer(int interval)\n", false, &_init_f_startTimer_767, &_call_f_startTimer_767);
}

// QThread *QObject::thread()


static void _init_f_thread_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QThread * > ();
}

static void _call_f_thread_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QThread * > ((QThread *)((QObject *)cls)->thread ());
}

static qt_gsi::GenericMethod *_create_f_thread_c0 ()
{
  return new qt_gsi::GenericMethod ("thread", "@brief Method QThread *QObject::thread()\n", true, &_init_f_thread_c0, &_call_f_thread_c0);
}

// static bool QObject::connect(const QObject *sender, const char *signal, const QObject *receiver, const char *member, Qt::ConnectionType)


static void _init_f_connect_9231 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sender");
  decl->add_arg<const QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("signal");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("receiver");
  decl->add_arg<const QObject * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("member");
  decl->add_arg<const char * > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("arg5", true, "Qt::AutoConnection");
  decl->add_arg<const qt_gsi::Converter<Qt::ConnectionType>::target_type & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_f_connect_9231 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QObject *arg1 = args.read<const QObject * > ();
  const char *arg2 = args.read<const char * > ();
  const QObject *arg3 = args.read<const QObject * > ();
  const char *arg4 = args.read<const char * > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ConnectionType>::target_type & arg5 = args ? args.read<const qt_gsi::Converter<Qt::ConnectionType>::target_type & > () : (const qt_gsi::Converter<Qt::ConnectionType>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::ConnectionType>(heap, Qt::AutoConnection));
  ret.write<bool > ((bool)QObject::connect (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<Qt::ConnectionType>(arg5).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_connect_9231 ()
{
  return new qt_gsi::GenericStaticMethod ("connect", "@brief Static method bool QObject::connect(const QObject *sender, const char *signal, const QObject *receiver, const char *member, Qt::ConnectionType)\nThis method is static and can be called without an instance.", &_init_f_connect_9231, &_call_f_connect_9231);
}

// static bool QObject::disconnect(const QObject *sender, const char *signal, const QObject *receiver, const char *member)


static void _init_f_disconnect_7132 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sender");
  decl->add_arg<const QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("signal");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("receiver");
  decl->add_arg<const QObject * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("member");
  decl->add_arg<const char * > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_disconnect_7132 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QObject *arg1 = args.read<const QObject * > ();
  const char *arg2 = args.read<const char * > ();
  const QObject *arg3 = args.read<const QObject * > ();
  const char *arg4 = args.read<const char * > ();
  ret.write<bool > ((bool)QObject::disconnect (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericStaticMethod *_create_f_disconnect_7132 ()
{
  return new qt_gsi::GenericStaticMethod ("disconnect", "@brief Static method bool QObject::disconnect(const QObject *sender, const char *signal, const QObject *receiver, const char *member)\nThis method is static and can be called without an instance.", &_init_f_disconnect_7132, &_call_f_disconnect_7132);
}

// static unsigned int QObject::registerUserData()


static void _init_f_registerUserData_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_f_registerUserData_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<unsigned int > ((unsigned int)QObject::registerUserData ());
}

static qt_gsi::GenericStaticMethod *_create_f_registerUserData_0 ()
{
  return new qt_gsi::GenericStaticMethod ("registerUserData", "@brief Static method unsigned int QObject::registerUserData()\nThis method is static and can be called without an instance.", &_init_f_registerUserData_0, &_call_f_registerUserData_0);
}

// static QString QObject::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QObject::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QObject::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QObject::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QObject::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QObject::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QObject::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QObject::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QObject::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QObject::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QObject::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QObject::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QObject, QObject_EventAdaptor> ea_QObject;

namespace gsi
{
gsi::Class<QObject> decl_QObject (ea_QObject, "QObject_Native",
  gsi::method_ext("findChild", &find_child_impl, "@brief Specialisation for findChild (uses QObject as T).") 
+
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_blockSignals_864 ()) +
  gsi::Methods(_create_f_children_c0 ()) +
  gsi::Methods(_create_f_connect_c7342 ()) +
  gsi::Methods(_create_f_deleteLater_0 ()) +
  gsi::Methods(_create_f_disconnect_5243 ()) +
  gsi::Methods(_create_f_disconnect_3620 ()) +
  gsi::Methods(_create_f_dumpObjectInfo_0 ()) +
  gsi::Methods(_create_f_dumpObjectTree_0 ()) +
  gsi::Methods(_create_f_dynamicPropertyNames_c0 ()) +
  gsi::Methods(_create_f_event_1217 ()) +
  gsi::Methods(_create_f_eventFilter_2411 ()) +
  gsi::Methods(_create_f_inherits_c1731 ()) +
  gsi::Methods(_create_f_installEventFilter_1302 ()) +
  gsi::Methods(_create_f_isWidgetType_c0 ()) +
  gsi::Methods(_create_f_killTimer_767 ()) +
  gsi::Methods(_create_f_moveToThread_1303 ()) +
  gsi::Methods(_create_f_objectName_c0 ()) +
  gsi::Methods(_create_f_parent_c0 ()) +
  gsi::Methods(_create_f_property_c1731 ()) +
  gsi::Methods(_create_f_removeEventFilter_1302 ()) +
  gsi::Methods(_create_f_setObjectName_2025 ()) +
  gsi::Methods(_create_f_setParent_1302 ()) +
  gsi::Methods(_create_f_setProperty_3742 ()) +
  gsi::Methods(_create_f_signalsBlocked_c0 ()) +
  gsi::Methods(_create_f_startTimer_767 ()) +
  gsi::Methods(_create_f_thread_c0 ()) +
  gsi::Methods(_create_f_connect_9231 ()) +
  gsi::Methods(_create_f_disconnect_7132 ()) +
  gsi::Methods(_create_f_registerUserData_0 ()) +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QObject");
}


class QObject_Adaptor : public QObject, public qt_gsi::QtObjectBase
{
public:

  virtual ~QObject_Adaptor();

  //  [adaptor ctor] QObject::QObject(QObject *parent)
  QObject_Adaptor() : QObject()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QObject::QObject(QObject *parent)
  QObject_Adaptor(QObject *parent) : QObject(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QObject::destroyed(QObject *)
  void fp_QObject_destroyed_1302 (QObject *arg1) {
    QObject::destroyed(arg1);
  }

  //  int QObject::receivers(const char *signal)
  int fp_QObject_receivers_c1731 (const char *signal) const {
    return QObject::receivers(signal);
  }

  //  QObject *QObject::sender()
  QObject * fp_QObject_sender_c0 () const {
    return QObject::sender();
  }

  //  [adaptor impl] bool QObject::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QObject::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QObject_Adaptor, bool, QEvent *>(&QObject_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QObject::event(arg1);
    }
  }

  //  [adaptor impl] bool QObject::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QObject::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QObject_Adaptor, bool, QObject *, QEvent *>(&QObject_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QObject::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QObject::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QObject::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QObject_Adaptor, QChildEvent *>(&QObject_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QObject::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QObject::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QObject::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QObject_Adaptor, QEvent *>(&QObject_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QObject::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QObject::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QObject::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QObject_Adaptor, const char *>(&QObject_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QObject::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QObject::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QObject::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QObject_Adaptor, QTimerEvent *>(&QObject_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QObject::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QObject_Adaptor::~QObject_Adaptor() { }

//  Constructor QObject::QObject(QObject *parent) (adaptor class)

static void _init_ctor_QObject_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QObject_Adaptor *> ();
}

static void _call_ctor_QObject_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QObject_Adaptor *> (new QObject_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QObject_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QObject::QObject(QObject *parent)\nThis method creates an object of class QObject.", &_init_ctor_QObject_Adaptor_1302, &_call_ctor_QObject_Adaptor_1302);
}

// void QObject::destroyed(QObject *)

static void _init_fp_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_destroyed_1302 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ((QObject_Adaptor *)cls)->fp_QObject_destroyed_1302 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_destroyed_1302 ()
{
  return new qt_gsi::GenericMethod("*destroyed", "@brief Method void QObject::destroyed(QObject *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroyed_1302, &_call_fp_destroyed_1302);
}


// int QObject::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QObject_Adaptor *)cls)->fp_QObject_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QObject::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QObject::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QObject_Adaptor *)cls)->fp_QObject_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QObject::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// bool QObject::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QObject_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QObject_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QObject::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QObject::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QObject_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QObject_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QObject::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QObject::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QObject_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QObject_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QObject::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QObject::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QObject_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QObject_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QObject::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QObject::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QObject_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QObject_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QObject::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QObject::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QObject_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QObject_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QObject::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QObject> decl_QObject;

gsi::Class<QObject_Adaptor> decl_QObject_Adaptor (decl_QObject, "QObject",
  gsi::Methods(_create_fp_destroyed_1302 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QObject_Adaptor_1302 ()),
  "@qt\n@brief Binding of QObject");

}

