
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQNetworkRequest.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtNetwork.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQNetworkRequest_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QNetworkRequest

//  Constructor QNetworkRequest::QNetworkRequest(const QUrl &url)


static void _init_ctor_QNetworkRequest_1701 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url", true, "QUrl()");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return_new<QNetworkRequest *> ();
}

static void _call_ctor_QNetworkRequest_1701 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QUrl &arg1 = args ? args.read<const QUrl & > () : (const QUrl &)(QUrl());
  ret.write<QNetworkRequest *> (new QNetworkRequest (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QNetworkRequest_1701 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QNetworkRequest::QNetworkRequest(const QUrl &url)\nThis method creates an object of class QNetworkRequest.", &_init_ctor_QNetworkRequest_1701, &_call_ctor_QNetworkRequest_1701);
}

//  Constructor QNetworkRequest::QNetworkRequest(const QNetworkRequest &other)


static void _init_ctor_QNetworkRequest_2885 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  decl->set_return_new<QNetworkRequest *> ();
}

static void _call_ctor_QNetworkRequest_2885 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QNetworkRequest &arg1 = args.read<const QNetworkRequest & > ();
  ret.write<QNetworkRequest *> (new QNetworkRequest (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QNetworkRequest_2885 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QNetworkRequest::QNetworkRequest(const QNetworkRequest &other)\nThis method creates an object of class QNetworkRequest.", &_init_ctor_QNetworkRequest_2885, &_call_ctor_QNetworkRequest_2885);
}

// QVariant QNetworkRequest::attribute(QNetworkRequest::Attribute code, const QVariant &defaultValue)


static void _init_f_attribute_c5083 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("code");
  decl->add_arg<const qt_gsi::Converter<QNetworkRequest::Attribute>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("defaultValue", true, "QVariant()");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_f_attribute_c5083 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QNetworkRequest::Attribute>::target_type & arg1 = args.read<const qt_gsi::Converter<QNetworkRequest::Attribute>::target_type & > ();
  const QVariant &arg2 = args ? args.read<const QVariant & > () : (const QVariant &)(QVariant());
  ret.write<QVariant > ((QVariant)((QNetworkRequest *)cls)->attribute (qt_gsi::QtToCppAdaptor<QNetworkRequest::Attribute>(arg1).cref(), arg2));
}

static qt_gsi::GenericMethod *_create_f_attribute_c5083 ()
{
  return new qt_gsi::GenericMethod ("attribute", "@brief Method QVariant QNetworkRequest::attribute(QNetworkRequest::Attribute code, const QVariant &defaultValue)\n", true, &_init_f_attribute_c5083, &_call_f_attribute_c5083);
}

// bool QNetworkRequest::hasRawHeader(const QByteArray &headerName)


static void _init_f_hasRawHeader_c2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("headerName");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasRawHeader_c2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ret.write<bool > ((bool)((QNetworkRequest *)cls)->hasRawHeader (arg1));
}

static qt_gsi::GenericMethod *_create_f_hasRawHeader_c2309 ()
{
  return new qt_gsi::GenericMethod ("hasRawHeader", "@brief Method bool QNetworkRequest::hasRawHeader(const QByteArray &headerName)\n", true, &_init_f_hasRawHeader_c2309, &_call_f_hasRawHeader_c2309);
}

// QVariant QNetworkRequest::header(QNetworkRequest::KnownHeaders header)


static void _init_f_header_c3349 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("header");
  decl->add_arg<const qt_gsi::Converter<QNetworkRequest::KnownHeaders>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_header_c3349 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QNetworkRequest::KnownHeaders>::target_type & arg1 = args.read<const qt_gsi::Converter<QNetworkRequest::KnownHeaders>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QNetworkRequest *)cls)->header (qt_gsi::QtToCppAdaptor<QNetworkRequest::KnownHeaders>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_header_c3349 ()
{
  return new qt_gsi::GenericMethod ("header", "@brief Method QVariant QNetworkRequest::header(QNetworkRequest::KnownHeaders header)\n", true, &_init_f_header_c3349, &_call_f_header_c3349);
}

// bool QNetworkRequest::operator!=(const QNetworkRequest &other)


static void _init_f_operator_excl__eq__c2885 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c2885 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QNetworkRequest &arg1 = args.read<const QNetworkRequest & > ();
  ret.write<bool > ((bool)((QNetworkRequest *)cls)->operator!= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__c2885 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QNetworkRequest::operator!=(const QNetworkRequest &other)\n", true, &_init_f_operator_excl__eq__c2885, &_call_f_operator_excl__eq__c2885);
}

// QNetworkRequest &QNetworkRequest::operator=(const QNetworkRequest &other)


static void _init_f_operator_eq__2885 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  decl->set_return<QNetworkRequest & > ();
}

static void _call_f_operator_eq__2885 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QNetworkRequest &arg1 = args.read<const QNetworkRequest & > ();
  ret.write<QNetworkRequest & > ((QNetworkRequest &)((QNetworkRequest *)cls)->operator= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__2885 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QNetworkRequest &QNetworkRequest::operator=(const QNetworkRequest &other)\n", false, &_init_f_operator_eq__2885, &_call_f_operator_eq__2885);
}

// bool QNetworkRequest::operator==(const QNetworkRequest &other)


static void _init_f_operator_eq__eq__c2885 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2885 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QNetworkRequest &arg1 = args.read<const QNetworkRequest & > ();
  ret.write<bool > ((bool)((QNetworkRequest *)cls)->operator== (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__c2885 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QNetworkRequest::operator==(const QNetworkRequest &other)\n", true, &_init_f_operator_eq__eq__c2885, &_call_f_operator_eq__eq__c2885);
}

// QObject *QNetworkRequest::originatingObject()


static void _init_f_originatingObject_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_f_originatingObject_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QNetworkRequest *)cls)->originatingObject ());
}

static qt_gsi::GenericMethod *_create_f_originatingObject_c0 ()
{
  return new qt_gsi::GenericMethod (":originatingObject", "@brief Method QObject *QNetworkRequest::originatingObject()\n", true, &_init_f_originatingObject_c0, &_call_f_originatingObject_c0);
}

// QByteArray QNetworkRequest::rawHeader(const QByteArray &headerName)


static void _init_f_rawHeader_c2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("headerName");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_rawHeader_c2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ret.write<QByteArray > ((QByteArray)((QNetworkRequest *)cls)->rawHeader (arg1));
}

static qt_gsi::GenericMethod *_create_f_rawHeader_c2309 ()
{
  return new qt_gsi::GenericMethod ("rawHeader", "@brief Method QByteArray QNetworkRequest::rawHeader(const QByteArray &headerName)\n", true, &_init_f_rawHeader_c2309, &_call_f_rawHeader_c2309);
}

// QList<QByteArray> QNetworkRequest::rawHeaderList()


static void _init_f_rawHeaderList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QByteArray> >::target_type > ();
}

static void _call_f_rawHeaderList_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QByteArray> >::target_type > ((qt_gsi::Converter<QList<QByteArray> >::target_type)qt_gsi::CppToQtAdaptor<QList<QByteArray> >(((QNetworkRequest *)cls)->rawHeaderList ()));
}

static qt_gsi::GenericMethod *_create_f_rawHeaderList_c0 ()
{
  return new qt_gsi::GenericMethod ("rawHeaderList", "@brief Method QList<QByteArray> QNetworkRequest::rawHeaderList()\n", true, &_init_f_rawHeaderList_c0, &_call_f_rawHeaderList_c0);
}

// void QNetworkRequest::setAttribute(QNetworkRequest::Attribute code, const QVariant &value)


static void _init_f_setAttribute_5083 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("code");
  decl->add_arg<const qt_gsi::Converter<QNetworkRequest::Attribute>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setAttribute_5083 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QNetworkRequest::Attribute>::target_type & arg1 = args.read<const qt_gsi::Converter<QNetworkRequest::Attribute>::target_type & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  ((QNetworkRequest *)cls)->setAttribute (qt_gsi::QtToCppAdaptor<QNetworkRequest::Attribute>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setAttribute_5083 ()
{
  return new qt_gsi::GenericMethod ("setAttribute", "@brief Method void QNetworkRequest::setAttribute(QNetworkRequest::Attribute code, const QVariant &value)\n", false, &_init_f_setAttribute_5083, &_call_f_setAttribute_5083);
}

// void QNetworkRequest::setHeader(QNetworkRequest::KnownHeaders header, const QVariant &value)


static void _init_f_setHeader_5360 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("header");
  decl->add_arg<const qt_gsi::Converter<QNetworkRequest::KnownHeaders>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setHeader_5360 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QNetworkRequest::KnownHeaders>::target_type & arg1 = args.read<const qt_gsi::Converter<QNetworkRequest::KnownHeaders>::target_type & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  ((QNetworkRequest *)cls)->setHeader (qt_gsi::QtToCppAdaptor<QNetworkRequest::KnownHeaders>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setHeader_5360 ()
{
  return new qt_gsi::GenericMethod ("setHeader", "@brief Method void QNetworkRequest::setHeader(QNetworkRequest::KnownHeaders header, const QVariant &value)\n", false, &_init_f_setHeader_5360, &_call_f_setHeader_5360);
}

// void QNetworkRequest::setOriginatingObject(QObject *object)


static void _init_f_setOriginatingObject_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("object");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOriginatingObject_1302 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  ((QNetworkRequest *)cls)->setOriginatingObject (arg1);
}

static qt_gsi::GenericMethod *_create_f_setOriginatingObject_1302 ()
{
  return new qt_gsi::GenericMethod ("setOriginatingObject|originatingObject=", "@brief Method void QNetworkRequest::setOriginatingObject(QObject *object)\n", false, &_init_f_setOriginatingObject_1302, &_call_f_setOriginatingObject_1302);
}

// void QNetworkRequest::setRawHeader(const QByteArray &headerName, const QByteArray &value)


static void _init_f_setRawHeader_4510 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("headerName");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QByteArray & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setRawHeader_4510 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  const QByteArray &arg2 = args.read<const QByteArray & > ();
  ((QNetworkRequest *)cls)->setRawHeader (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setRawHeader_4510 ()
{
  return new qt_gsi::GenericMethod ("setRawHeader", "@brief Method void QNetworkRequest::setRawHeader(const QByteArray &headerName, const QByteArray &value)\n", false, &_init_f_setRawHeader_4510, &_call_f_setRawHeader_4510);
}

// void QNetworkRequest::setSslConfiguration(const QSslConfiguration &configuration)


static void _init_f_setSslConfiguration_3068 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("configuration");
  decl->add_arg<const QSslConfiguration & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSslConfiguration_3068 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSslConfiguration &arg1 = args.read<const QSslConfiguration & > ();
  ((QNetworkRequest *)cls)->setSslConfiguration (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSslConfiguration_3068 ()
{
  return new qt_gsi::GenericMethod ("setSslConfiguration|sslConfiguration=", "@brief Method void QNetworkRequest::setSslConfiguration(const QSslConfiguration &configuration)\n", false, &_init_f_setSslConfiguration_3068, &_call_f_setSslConfiguration_3068);
}

// void QNetworkRequest::setUrl(const QUrl &url)


static void _init_f_setUrl_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUrl_1701 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QUrl &arg1 = args.read<const QUrl & > ();
  ((QNetworkRequest *)cls)->setUrl (arg1);
}

static qt_gsi::GenericMethod *_create_f_setUrl_1701 ()
{
  return new qt_gsi::GenericMethod ("setUrl|url=", "@brief Method void QNetworkRequest::setUrl(const QUrl &url)\n", false, &_init_f_setUrl_1701, &_call_f_setUrl_1701);
}

// QSslConfiguration QNetworkRequest::sslConfiguration()


static void _init_f_sslConfiguration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSslConfiguration > ();
}

static void _call_f_sslConfiguration_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSslConfiguration > ((QSslConfiguration)((QNetworkRequest *)cls)->sslConfiguration ());
}

static qt_gsi::GenericMethod *_create_f_sslConfiguration_c0 ()
{
  return new qt_gsi::GenericMethod (":sslConfiguration", "@brief Method QSslConfiguration QNetworkRequest::sslConfiguration()\n", true, &_init_f_sslConfiguration_c0, &_call_f_sslConfiguration_c0);
}

// QUrl QNetworkRequest::url()


static void _init_f_url_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QUrl > ();
}

static void _call_f_url_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QUrl > ((QUrl)((QNetworkRequest *)cls)->url ());
}

static qt_gsi::GenericMethod *_create_f_url_c0 ()
{
  return new qt_gsi::GenericMethod (":url", "@brief Method QUrl QNetworkRequest::url()\n", true, &_init_f_url_c0, &_call_f_url_c0);
}


namespace gsi
{
gsi::Class<QNetworkRequest> decl_QNetworkRequest ("QNetworkRequest",
  gsi::Methods(_create_ctor_QNetworkRequest_1701 ()) +
  gsi::Methods(_create_ctor_QNetworkRequest_2885 ()) +
  gsi::Methods(_create_f_attribute_c5083 ()) +
  gsi::Methods(_create_f_hasRawHeader_c2309 ()) +
  gsi::Methods(_create_f_header_c3349 ()) +
  gsi::Methods(_create_f_operator_excl__eq__c2885 ()) +
  gsi::Methods(_create_f_operator_eq__2885 ()) +
  gsi::Methods(_create_f_operator_eq__eq__c2885 ()) +
  gsi::Methods(_create_f_originatingObject_c0 ()) +
  gsi::Methods(_create_f_rawHeader_c2309 ()) +
  gsi::Methods(_create_f_rawHeaderList_c0 ()) +
  gsi::Methods(_create_f_setAttribute_5083 ()) +
  gsi::Methods(_create_f_setHeader_5360 ()) +
  gsi::Methods(_create_f_setOriginatingObject_1302 ()) +
  gsi::Methods(_create_f_setRawHeader_4510 ()) +
  gsi::Methods(_create_f_setSslConfiguration_3068 ()) +
  gsi::Methods(_create_f_setUrl_1701 ()) +
  gsi::Methods(_create_f_sslConfiguration_c0 ()) +
  gsi::Methods(_create_f_url_c0 ()),
  "@qt\n@brief Binding of QNetworkRequest");

}


//  Implementation of the enum wrapper class for QNetworkRequest::Attribute
namespace qt_gsi
{

static QNetworkRequest_Attribute_Enum *c_1_QNetworkRequest_Attribute_Enum () { return new QNetworkRequest_Attribute_Enum (QNetworkRequest::HttpStatusCodeAttribute); }
static QNetworkRequest_Attribute_Enum *c_2_QNetworkRequest_Attribute_Enum () { return new QNetworkRequest_Attribute_Enum (QNetworkRequest::HttpReasonPhraseAttribute); }
static QNetworkRequest_Attribute_Enum *c_3_QNetworkRequest_Attribute_Enum () { return new QNetworkRequest_Attribute_Enum (QNetworkRequest::RedirectionTargetAttribute); }
static QNetworkRequest_Attribute_Enum *c_4_QNetworkRequest_Attribute_Enum () { return new QNetworkRequest_Attribute_Enum (QNetworkRequest::ConnectionEncryptedAttribute); }
static QNetworkRequest_Attribute_Enum *c_5_QNetworkRequest_Attribute_Enum () { return new QNetworkRequest_Attribute_Enum (QNetworkRequest::CacheLoadControlAttribute); }
static QNetworkRequest_Attribute_Enum *c_6_QNetworkRequest_Attribute_Enum () { return new QNetworkRequest_Attribute_Enum (QNetworkRequest::CacheSaveControlAttribute); }
static QNetworkRequest_Attribute_Enum *c_7_QNetworkRequest_Attribute_Enum () { return new QNetworkRequest_Attribute_Enum (QNetworkRequest::SourceIsFromCacheAttribute); }
static QNetworkRequest_Attribute_Enum *c_8_QNetworkRequest_Attribute_Enum () { return new QNetworkRequest_Attribute_Enum (QNetworkRequest::DoNotBufferUploadDataAttribute); }
static QNetworkRequest_Attribute_Enum *c_9_QNetworkRequest_Attribute_Enum () { return new QNetworkRequest_Attribute_Enum (QNetworkRequest::HttpPipeliningAllowedAttribute); }
static QNetworkRequest_Attribute_Enum *c_10_QNetworkRequest_Attribute_Enum () { return new QNetworkRequest_Attribute_Enum (QNetworkRequest::HttpPipeliningWasUsedAttribute); }
static QNetworkRequest_Attribute_Enum *c_11_QNetworkRequest_Attribute_Enum () { return new QNetworkRequest_Attribute_Enum (QNetworkRequest::User); }
static QNetworkRequest_Attribute_Enum *c_12_QNetworkRequest_Attribute_Enum () { return new QNetworkRequest_Attribute_Enum (QNetworkRequest::UserMax); }

static gsi::Methods mkdefs_QNetworkRequest_Attribute () {
  return
    gsi::constant ("HttpStatusCodeAttribute", &qt_gsi::c_1_QNetworkRequest_Attribute_Enum, "@brief Enum constant QNetworkRequest::HttpStatusCodeAttribute") +
    gsi::constant ("HttpReasonPhraseAttribute", &qt_gsi::c_2_QNetworkRequest_Attribute_Enum, "@brief Enum constant QNetworkRequest::HttpReasonPhraseAttribute") +
    gsi::constant ("RedirectionTargetAttribute", &qt_gsi::c_3_QNetworkRequest_Attribute_Enum, "@brief Enum constant QNetworkRequest::RedirectionTargetAttribute") +
    gsi::constant ("ConnectionEncryptedAttribute", &qt_gsi::c_4_QNetworkRequest_Attribute_Enum, "@brief Enum constant QNetworkRequest::ConnectionEncryptedAttribute") +
    gsi::constant ("CacheLoadControlAttribute", &qt_gsi::c_5_QNetworkRequest_Attribute_Enum, "@brief Enum constant QNetworkRequest::CacheLoadControlAttribute") +
    gsi::constant ("CacheSaveControlAttribute", &qt_gsi::c_6_QNetworkRequest_Attribute_Enum, "@brief Enum constant QNetworkRequest::CacheSaveControlAttribute") +
    gsi::constant ("SourceIsFromCacheAttribute", &qt_gsi::c_7_QNetworkRequest_Attribute_Enum, "@brief Enum constant QNetworkRequest::SourceIsFromCacheAttribute") +
    gsi::constant ("DoNotBufferUploadDataAttribute", &qt_gsi::c_8_QNetworkRequest_Attribute_Enum, "@brief Enum constant QNetworkRequest::DoNotBufferUploadDataAttribute") +
    gsi::constant ("HttpPipeliningAllowedAttribute", &qt_gsi::c_9_QNetworkRequest_Attribute_Enum, "@brief Enum constant QNetworkRequest::HttpPipeliningAllowedAttribute") +
    gsi::constant ("HttpPipeliningWasUsedAttribute", &qt_gsi::c_10_QNetworkRequest_Attribute_Enum, "@brief Enum constant QNetworkRequest::HttpPipeliningWasUsedAttribute") +
    gsi::constant ("User", &qt_gsi::c_11_QNetworkRequest_Attribute_Enum, "@brief Enum constant QNetworkRequest::User") +
    gsi::constant ("UserMax", &qt_gsi::c_12_QNetworkRequest_Attribute_Enum, "@brief Enum constant QNetworkRequest::UserMax");
}

static std::string to_s_QNetworkRequest_Attribute_Enum (const QNetworkRequest_Attribute_Enum *e)
{
  if (e->value () == QNetworkRequest::HttpStatusCodeAttribute) { return tl::sprintf ("HttpStatusCodeAttribute (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkRequest::HttpReasonPhraseAttribute) { return tl::sprintf ("HttpReasonPhraseAttribute (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkRequest::RedirectionTargetAttribute) { return tl::sprintf ("RedirectionTargetAttribute (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkRequest::ConnectionEncryptedAttribute) { return tl::sprintf ("ConnectionEncryptedAttribute (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkRequest::CacheLoadControlAttribute) { return tl::sprintf ("CacheLoadControlAttribute (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkRequest::CacheSaveControlAttribute) { return tl::sprintf ("CacheSaveControlAttribute (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkRequest::SourceIsFromCacheAttribute) { return tl::sprintf ("SourceIsFromCacheAttribute (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkRequest::DoNotBufferUploadDataAttribute) { return tl::sprintf ("DoNotBufferUploadDataAttribute (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkRequest::HttpPipeliningAllowedAttribute) { return tl::sprintf ("HttpPipeliningAllowedAttribute (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkRequest::HttpPipeliningWasUsedAttribute) { return tl::sprintf ("HttpPipeliningWasUsedAttribute (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkRequest::User) { return tl::sprintf ("User (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkRequest::UserMax) { return tl::sprintf ("UserMax (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QNetworkRequest_Attribute_Enum (const QNetworkRequest_Attribute_Enum *e)
{
  return (unsigned int) e->value ();
}

static QNetworkRequest_Attribute_Enum *from_i_QNetworkRequest_Attribute_Enum (unsigned int i)
{
  return new QNetworkRequest_Attribute_Enum ((QNetworkRequest::Attribute) i);
}

static bool equalQNetworkRequest_Attribute_Enum (const QNetworkRequest_Attribute_Enum *e, QNetworkRequest_Attribute_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QNetworkRequest_Attribute_Enum (const QNetworkRequest_Attribute_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QNetworkRequest_Attribute_Enums oropQNetworkRequest_Attribute_Enums (const QNetworkRequest_Attribute_Enums *e, const QNetworkRequest_Attribute_Enums &d)
{
  return e->flags () | d.flags ();
}

static QNetworkRequest_Attribute_Enums andopQNetworkRequest_Attribute_Enums (const QNetworkRequest_Attribute_Enums *e, const QNetworkRequest_Attribute_Enums &d)
{
  return e->flags () & d.flags ();
}

static QNetworkRequest_Attribute_Enums xoropQNetworkRequest_Attribute_Enums (const QNetworkRequest_Attribute_Enums *e, const QNetworkRequest_Attribute_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QNetworkRequest_Attribute_Enums (const QNetworkRequest_Attribute_Enums *e)
{
  std::string l;
  if (e->testFlag (QNetworkRequest::HttpStatusCodeAttribute)) { if (!l.empty ()) l += "|"; l += "HttpStatusCodeAttribute"; }
  if (e->testFlag (QNetworkRequest::HttpReasonPhraseAttribute)) { if (!l.empty ()) l += "|"; l += "HttpReasonPhraseAttribute"; }
  if (e->testFlag (QNetworkRequest::RedirectionTargetAttribute)) { if (!l.empty ()) l += "|"; l += "RedirectionTargetAttribute"; }
  if (e->testFlag (QNetworkRequest::ConnectionEncryptedAttribute)) { if (!l.empty ()) l += "|"; l += "ConnectionEncryptedAttribute"; }
  if (e->testFlag (QNetworkRequest::CacheLoadControlAttribute)) { if (!l.empty ()) l += "|"; l += "CacheLoadControlAttribute"; }
  if (e->testFlag (QNetworkRequest::CacheSaveControlAttribute)) { if (!l.empty ()) l += "|"; l += "CacheSaveControlAttribute"; }
  if (e->testFlag (QNetworkRequest::SourceIsFromCacheAttribute)) { if (!l.empty ()) l += "|"; l += "SourceIsFromCacheAttribute"; }
  if (e->testFlag (QNetworkRequest::DoNotBufferUploadDataAttribute)) { if (!l.empty ()) l += "|"; l += "DoNotBufferUploadDataAttribute"; }
  if (e->testFlag (QNetworkRequest::HttpPipeliningAllowedAttribute)) { if (!l.empty ()) l += "|"; l += "HttpPipeliningAllowedAttribute"; }
  if (e->testFlag (QNetworkRequest::HttpPipeliningWasUsedAttribute)) { if (!l.empty ()) l += "|"; l += "HttpPipeliningWasUsedAttribute"; }
  if (e->testFlag (QNetworkRequest::User)) { if (!l.empty ()) l += "|"; l += "User"; }
  if (e->testFlag (QNetworkRequest::UserMax)) { if (!l.empty ()) l += "|"; l += "UserMax"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QNetworkRequest_Attribute_Enums (const QNetworkRequest_Attribute_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QNetworkRequest_Attribute_Enums (const QNetworkRequest_Attribute_Enums *e, const QNetworkRequest_Attribute_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QNetworkRequest_Attribute_Enums> decl_QNetworkRequest_Attribute_Enums ("QNetworkRequest_QFlags_Attribute",
  gsi::method_ext ("|", &qt_gsi::oropQNetworkRequest_Attribute_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQNetworkRequest_Attribute_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQNetworkRequest_Attribute_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QNetworkRequest_Attribute_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QNetworkRequest_Attribute_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QNetworkRequest_Attribute_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QNetworkRequest::Attribute> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QNetworkRequest_Attribute_Enum> decl_QNetworkRequest_Attribute_Enum (decl_QNetworkRequest_Attribute_Enums, "QNetworkRequest_Attribute",
  qt_gsi::mkdefs_QNetworkRequest_Attribute () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QNetworkRequest_Attribute_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QNetworkRequest_Attribute_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQNetworkRequest_Attribute_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QNetworkRequest_Attribute_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QNetworkRequest_Attribute_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QNetworkRequest::Attribute enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QNetworkRequest> inject_QNetworkRequest_Attribute_Enum_in_parent (qt_gsi::mkdefs_QNetworkRequest_Attribute ());
static gsi::ClassExt<QNetworkRequest> decl_QNetworkRequest_Attribute_Enum_as_child (decl_QNetworkRequest_Attribute_Enum, "Attribute");

}


//  Implementation of the enum wrapper class for QNetworkRequest::KnownHeaders
namespace qt_gsi
{

static QNetworkRequest_KnownHeaders_Enum *c_1_QNetworkRequest_KnownHeaders_Enum () { return new QNetworkRequest_KnownHeaders_Enum (QNetworkRequest::ContentTypeHeader); }
static QNetworkRequest_KnownHeaders_Enum *c_2_QNetworkRequest_KnownHeaders_Enum () { return new QNetworkRequest_KnownHeaders_Enum (QNetworkRequest::ContentLengthHeader); }
static QNetworkRequest_KnownHeaders_Enum *c_3_QNetworkRequest_KnownHeaders_Enum () { return new QNetworkRequest_KnownHeaders_Enum (QNetworkRequest::LocationHeader); }
static QNetworkRequest_KnownHeaders_Enum *c_4_QNetworkRequest_KnownHeaders_Enum () { return new QNetworkRequest_KnownHeaders_Enum (QNetworkRequest::LastModifiedHeader); }
static QNetworkRequest_KnownHeaders_Enum *c_5_QNetworkRequest_KnownHeaders_Enum () { return new QNetworkRequest_KnownHeaders_Enum (QNetworkRequest::CookieHeader); }
static QNetworkRequest_KnownHeaders_Enum *c_6_QNetworkRequest_KnownHeaders_Enum () { return new QNetworkRequest_KnownHeaders_Enum (QNetworkRequest::SetCookieHeader); }

static gsi::Methods mkdefs_QNetworkRequest_KnownHeaders () {
  return
    gsi::constant ("ContentTypeHeader", &qt_gsi::c_1_QNetworkRequest_KnownHeaders_Enum, "@brief Enum constant QNetworkRequest::ContentTypeHeader") +
    gsi::constant ("ContentLengthHeader", &qt_gsi::c_2_QNetworkRequest_KnownHeaders_Enum, "@brief Enum constant QNetworkRequest::ContentLengthHeader") +
    gsi::constant ("LocationHeader", &qt_gsi::c_3_QNetworkRequest_KnownHeaders_Enum, "@brief Enum constant QNetworkRequest::LocationHeader") +
    gsi::constant ("LastModifiedHeader", &qt_gsi::c_4_QNetworkRequest_KnownHeaders_Enum, "@brief Enum constant QNetworkRequest::LastModifiedHeader") +
    gsi::constant ("CookieHeader", &qt_gsi::c_5_QNetworkRequest_KnownHeaders_Enum, "@brief Enum constant QNetworkRequest::CookieHeader") +
    gsi::constant ("SetCookieHeader", &qt_gsi::c_6_QNetworkRequest_KnownHeaders_Enum, "@brief Enum constant QNetworkRequest::SetCookieHeader");
}

static std::string to_s_QNetworkRequest_KnownHeaders_Enum (const QNetworkRequest_KnownHeaders_Enum *e)
{
  if (e->value () == QNetworkRequest::ContentTypeHeader) { return tl::sprintf ("ContentTypeHeader (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkRequest::ContentLengthHeader) { return tl::sprintf ("ContentLengthHeader (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkRequest::LocationHeader) { return tl::sprintf ("LocationHeader (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkRequest::LastModifiedHeader) { return tl::sprintf ("LastModifiedHeader (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkRequest::CookieHeader) { return tl::sprintf ("CookieHeader (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkRequest::SetCookieHeader) { return tl::sprintf ("SetCookieHeader (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QNetworkRequest_KnownHeaders_Enum (const QNetworkRequest_KnownHeaders_Enum *e)
{
  return (unsigned int) e->value ();
}

static QNetworkRequest_KnownHeaders_Enum *from_i_QNetworkRequest_KnownHeaders_Enum (unsigned int i)
{
  return new QNetworkRequest_KnownHeaders_Enum ((QNetworkRequest::KnownHeaders) i);
}

static bool equalQNetworkRequest_KnownHeaders_Enum (const QNetworkRequest_KnownHeaders_Enum *e, QNetworkRequest_KnownHeaders_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QNetworkRequest_KnownHeaders_Enum (const QNetworkRequest_KnownHeaders_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QNetworkRequest_KnownHeaders_Enums oropQNetworkRequest_KnownHeaders_Enums (const QNetworkRequest_KnownHeaders_Enums *e, const QNetworkRequest_KnownHeaders_Enums &d)
{
  return e->flags () | d.flags ();
}

static QNetworkRequest_KnownHeaders_Enums andopQNetworkRequest_KnownHeaders_Enums (const QNetworkRequest_KnownHeaders_Enums *e, const QNetworkRequest_KnownHeaders_Enums &d)
{
  return e->flags () & d.flags ();
}

static QNetworkRequest_KnownHeaders_Enums xoropQNetworkRequest_KnownHeaders_Enums (const QNetworkRequest_KnownHeaders_Enums *e, const QNetworkRequest_KnownHeaders_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QNetworkRequest_KnownHeaders_Enums (const QNetworkRequest_KnownHeaders_Enums *e)
{
  std::string l;
  if (e->testFlag (QNetworkRequest::ContentTypeHeader)) { if (!l.empty ()) l += "|"; l += "ContentTypeHeader"; }
  if (e->testFlag (QNetworkRequest::ContentLengthHeader)) { if (!l.empty ()) l += "|"; l += "ContentLengthHeader"; }
  if (e->testFlag (QNetworkRequest::LocationHeader)) { if (!l.empty ()) l += "|"; l += "LocationHeader"; }
  if (e->testFlag (QNetworkRequest::LastModifiedHeader)) { if (!l.empty ()) l += "|"; l += "LastModifiedHeader"; }
  if (e->testFlag (QNetworkRequest::CookieHeader)) { if (!l.empty ()) l += "|"; l += "CookieHeader"; }
  if (e->testFlag (QNetworkRequest::SetCookieHeader)) { if (!l.empty ()) l += "|"; l += "SetCookieHeader"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QNetworkRequest_KnownHeaders_Enums (const QNetworkRequest_KnownHeaders_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QNetworkRequest_KnownHeaders_Enums (const QNetworkRequest_KnownHeaders_Enums *e, const QNetworkRequest_KnownHeaders_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QNetworkRequest_KnownHeaders_Enums> decl_QNetworkRequest_KnownHeaders_Enums ("QNetworkRequest_QFlags_KnownHeaders",
  gsi::method_ext ("|", &qt_gsi::oropQNetworkRequest_KnownHeaders_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQNetworkRequest_KnownHeaders_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQNetworkRequest_KnownHeaders_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QNetworkRequest_KnownHeaders_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QNetworkRequest_KnownHeaders_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QNetworkRequest_KnownHeaders_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QNetworkRequest::KnownHeaders> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QNetworkRequest_KnownHeaders_Enum> decl_QNetworkRequest_KnownHeaders_Enum (decl_QNetworkRequest_KnownHeaders_Enums, "QNetworkRequest_KnownHeaders",
  qt_gsi::mkdefs_QNetworkRequest_KnownHeaders () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QNetworkRequest_KnownHeaders_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QNetworkRequest_KnownHeaders_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQNetworkRequest_KnownHeaders_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QNetworkRequest_KnownHeaders_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QNetworkRequest_KnownHeaders_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QNetworkRequest::KnownHeaders enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QNetworkRequest> inject_QNetworkRequest_KnownHeaders_Enum_in_parent (qt_gsi::mkdefs_QNetworkRequest_KnownHeaders ());
static gsi::ClassExt<QNetworkRequest> decl_QNetworkRequest_KnownHeaders_Enum_as_child (decl_QNetworkRequest_KnownHeaders_Enum, "KnownHeaders");

}

