
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsObject.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQGraphicsObject_EventAdaptor.h"
#include "gsiDeclQGraphicsObject_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsObject

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QGraphicsObject::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// const QList<QObject *> &QGraphicsObject::children()


static void _init_f_children_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QObject *> >::target_type > ();
}

static void _call_f_children_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QObject *> >::target_type > ((qt_gsi::Converter<QList<QObject *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QObject *> >(((QGraphicsObject *)cls)->children ()));
}

static qt_gsi::GenericMethod *_create_f_children_c0 ()
{
  return new qt_gsi::GenericMethod ("children", "@brief Method const QList<QObject *> &QGraphicsObject::children()\n", true, &_init_f_children_c0, &_call_f_children_c0);
}

// void QGraphicsObject::grabGesture(Qt::GestureType type, QFlags<Qt::GestureFlag> flags)


static void _init_f_grabGesture_4352 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<Qt::GestureType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "Qt::GestureFlags()");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::GestureFlag> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_grabGesture_4352 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::GestureType>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::GestureType>::target_type & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::GestureFlag> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::GestureFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::GestureFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::GestureFlag> >(heap, Qt::GestureFlags()));
  ((QGraphicsObject *)cls)->grabGesture (qt_gsi::QtToCppAdaptor<Qt::GestureType>(arg1).cref(), qt_gsi::QtToCppAdaptor<QFlags<Qt::GestureFlag> >(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_grabGesture_4352 ()
{
  return new qt_gsi::GenericMethod ("grabGesture", "@brief Method void QGraphicsObject::grabGesture(Qt::GestureType type, QFlags<Qt::GestureFlag> flags)\n", false, &_init_f_grabGesture_4352, &_call_f_grabGesture_4352);
}

// void QGraphicsObject::ungrabGesture(Qt::GestureType type)


static void _init_f_ungrabGesture_1902 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<Qt::GestureType>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_ungrabGesture_1902 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::GestureType>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::GestureType>::target_type & > ();
  ((QGraphicsObject *)cls)->ungrabGesture (qt_gsi::QtToCppAdaptor<Qt::GestureType>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_ungrabGesture_1902 ()
{
  return new qt_gsi::GenericMethod ("ungrabGesture", "@brief Method void QGraphicsObject::ungrabGesture(Qt::GestureType type)\n", false, &_init_f_ungrabGesture_1902, &_call_f_ungrabGesture_1902);
}

// static QString QGraphicsObject::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QGraphicsObject::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsObject::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QGraphicsObject::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QGraphicsObject::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsObject::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QGraphicsObject::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QGraphicsObject::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsObject::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QGraphicsObject::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QGraphicsObject::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsObject::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QGraphicsObject, QGraphicsObject_EventAdaptor> ea_QGraphicsObject;

//  base class cast for QObject

static void _init_f_QGraphicsObject_as_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject *> ();
}

static void _call_f_QGraphicsObject_as_QObject (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject *> ((QObject *)(QGraphicsObject *)cls);
}

static qt_gsi::GenericMethod *_create_f_QGraphicsObject_as_QObject ()
{
  return new qt_gsi::GenericMethod ("asQObject", "@brief Delivers the base class interface QObject of QGraphicsObject\nClass QGraphicsObject is derived from multiple base classes. This method delivers the QObject base class aspect.", false, &_init_f_QGraphicsObject_as_QObject, &_call_f_QGraphicsObject_as_QObject);
}

static void _init_f_QGraphicsObject_as_const_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QObject *> ();
}

static void _call_f_QGraphicsObject_as_const_QObject (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QObject *> ((const QObject *)(const QGraphicsObject *)cls);
}

static qt_gsi::GenericMethod *_create_f_QGraphicsObject_as_const_QObject ()
{
  return new qt_gsi::GenericMethod ("asConstQObject", "@brief Delivers the base class interface QObject of QGraphicsObject\nClass QGraphicsObject is derived from multiple base classes. This method delivers the QObject base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QGraphicsObject_as_const_QObject, &_call_f_QGraphicsObject_as_const_QObject);
}

//  base class cast for QGraphicsItem

static void _init_f_QGraphicsObject_as_QGraphicsItem (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItem *> ();
}

static void _call_f_QGraphicsObject_as_QGraphicsItem (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsItem *> ((QGraphicsItem *)(QGraphicsObject *)cls);
}

static qt_gsi::GenericMethod *_create_f_QGraphicsObject_as_QGraphicsItem ()
{
  return new qt_gsi::GenericMethod ("asQGraphicsItem", "@brief Delivers the base class interface QGraphicsItem of QGraphicsObject\nClass QGraphicsObject is derived from multiple base classes. This method delivers the QGraphicsItem base class aspect.", false, &_init_f_QGraphicsObject_as_QGraphicsItem, &_call_f_QGraphicsObject_as_QGraphicsItem);
}

static void _init_f_QGraphicsObject_as_const_QGraphicsItem (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QGraphicsItem *> ();
}

static void _call_f_QGraphicsObject_as_const_QGraphicsItem (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QGraphicsItem *> ((const QGraphicsItem *)(const QGraphicsObject *)cls);
}

static qt_gsi::GenericMethod *_create_f_QGraphicsObject_as_const_QGraphicsItem ()
{
  return new qt_gsi::GenericMethod ("asConstQGraphicsItem", "@brief Delivers the base class interface QGraphicsItem of QGraphicsObject\nClass QGraphicsObject is derived from multiple base classes. This method delivers the QGraphicsItem base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QGraphicsObject_as_const_QGraphicsItem, &_call_f_QGraphicsObject_as_const_QGraphicsItem);
}


namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QGraphicsObject> decl_QGraphicsObject (ea_QGraphicsObject, decl_QObject, "QGraphicsObject_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_children_c0 ()) +
  gsi::Methods(_create_f_grabGesture_4352 ()) +
  gsi::Methods(_create_f_ungrabGesture_1902 ()) +
  qt_gsi::qt_signal<QGraphicsObject, QGraphicsObject_EventAdaptor, QObject *> ("destroyed", &QGraphicsObject_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QGraphicsObject::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsObject, QGraphicsObject_EventAdaptor> ("enabledChanged", &QGraphicsObject_EventAdaptor::enabledChanged_e_0, "@brief Signal declaration for QGraphicsObject::enabledChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsObject, QGraphicsObject_EventAdaptor> ("opacityChanged", &QGraphicsObject_EventAdaptor::opacityChanged_e_0, "@brief Signal declaration for QGraphicsObject::opacityChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsObject, QGraphicsObject_EventAdaptor> ("parentChanged", &QGraphicsObject_EventAdaptor::parentChanged_e_0, "@brief Signal declaration for QGraphicsObject::parentChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsObject, QGraphicsObject_EventAdaptor> ("rotationChanged", &QGraphicsObject_EventAdaptor::rotationChanged_e_0, "@brief Signal declaration for QGraphicsObject::rotationChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsObject, QGraphicsObject_EventAdaptor> ("scaleChanged", &QGraphicsObject_EventAdaptor::scaleChanged_e_0, "@brief Signal declaration for QGraphicsObject::scaleChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsObject, QGraphicsObject_EventAdaptor> ("visibleChanged", &QGraphicsObject_EventAdaptor::visibleChanged_e_0, "@brief Signal declaration for QGraphicsObject::visibleChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsObject, QGraphicsObject_EventAdaptor> ("xChanged", &QGraphicsObject_EventAdaptor::xChanged_e_0, "@brief Signal declaration for QGraphicsObject::xChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsObject, QGraphicsObject_EventAdaptor> ("yChanged", &QGraphicsObject_EventAdaptor::yChanged_e_0, "@brief Signal declaration for QGraphicsObject::yChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsObject, QGraphicsObject_EventAdaptor> ("zChanged", &QGraphicsObject_EventAdaptor::zChanged_e_0, "@brief Signal declaration for QGraphicsObject::zChanged()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()) +
  gsi::Methods(_create_f_QGraphicsObject_as_QObject ()) +
  gsi::Methods(_create_f_QGraphicsObject_as_const_QObject ()) +
  gsi::Methods(_create_f_QGraphicsObject_as_QGraphicsItem ()) +
  gsi::Methods(_create_f_QGraphicsObject_as_const_QGraphicsItem ()),
  "@hide\n@alias QGraphicsObject");
}


class QGraphicsObject_Adaptor : public QGraphicsObject, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsObject_Adaptor();

  //  [adaptor ctor] QGraphicsObject::QGraphicsObject(QGraphicsItem *parent)
  QGraphicsObject_Adaptor() : QGraphicsObject()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsObject::QGraphicsObject(QGraphicsItem *parent)
  QGraphicsObject_Adaptor(QGraphicsItem *parent) : QGraphicsObject(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QGraphicsObject::addToIndex()
  void fp_QGraphicsObject_addToIndex_0 () {
    QGraphicsObject::addToIndex();
  }

  //  void QGraphicsObject::prepareGeometryChange()
  void fp_QGraphicsObject_prepareGeometryChange_0 () {
    QGraphicsObject::prepareGeometryChange();
  }

  //  int QGraphicsObject::receivers(const char *signal)
  int fp_QGraphicsObject_receivers_c1731 (const char *signal) const {
    return QGraphicsObject::receivers(signal);
  }

  //  void QGraphicsObject::removeFromIndex()
  void fp_QGraphicsObject_removeFromIndex_0 () {
    QGraphicsObject::removeFromIndex();
  }

  //  QObject *QGraphicsObject::sender()
  QObject * fp_QGraphicsObject_sender_c0 () const {
    return QGraphicsObject::sender();
  }

  //  [adaptor impl] void QGraphicsObject::advance(int phase)
  void cbs_advance_767_0(int phase)
  {
    QGraphicsObject::advance(phase);
  }

  virtual void advance(int phase)
  {
    if (cb_advance_767_0.can_issue()) {
      cb_advance_767_0.issue<QGraphicsObject_Adaptor, int>(&QGraphicsObject_Adaptor::cbs_advance_767_0, phase);
    } else {
      QGraphicsObject::advance(phase);
    }
  }

  //  [adaptor impl] QRectF QGraphicsObject::boundingRect()
  QRectF cbs_boundingRect_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("boundingRect");
  }

  virtual QRectF boundingRect() const
  {
    if (cb_boundingRect_c0_0.can_issue()) {
      return cb_boundingRect_c0_0.issue<QGraphicsObject_Adaptor, QRectF>(&QGraphicsObject_Adaptor::cbs_boundingRect_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("boundingRect");
    }
  }

  //  [adaptor impl] bool QGraphicsObject::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)
  bool cbs_collidesWithItem_c4977_1(const QGraphicsItem *other, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & mode) const
  {
    return QGraphicsObject::collidesWithItem(other, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(mode).cref());
  }

  virtual bool collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode) const
  {
    if (cb_collidesWithItem_c4977_1.can_issue()) {
      return cb_collidesWithItem_c4977_1.issue<QGraphicsObject_Adaptor, bool, const QGraphicsItem *, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &>(&QGraphicsObject_Adaptor::cbs_collidesWithItem_c4977_1, other, qt_gsi::CppToQtAdaptor<Qt::ItemSelectionMode>(mode));
    } else {
      return QGraphicsObject::collidesWithItem(other, mode);
    }
  }

  //  [adaptor impl] bool QGraphicsObject::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)
  bool cbs_collidesWithPath_c4877_1(const QPainterPath &path, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & mode) const
  {
    return QGraphicsObject::collidesWithPath(path, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(mode).cref());
  }

  virtual bool collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode) const
  {
    if (cb_collidesWithPath_c4877_1.can_issue()) {
      return cb_collidesWithPath_c4877_1.issue<QGraphicsObject_Adaptor, bool, const QPainterPath &, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &>(&QGraphicsObject_Adaptor::cbs_collidesWithPath_c4877_1, path, qt_gsi::CppToQtAdaptor<Qt::ItemSelectionMode>(mode));
    } else {
      return QGraphicsObject::collidesWithPath(path, mode);
    }
  }

  //  [adaptor impl] bool QGraphicsObject::contains(const QPointF &point)
  bool cbs_contains_c1986_0(const QPointF &point) const
  {
    return QGraphicsObject::contains(point);
  }

  virtual bool contains(const QPointF &point) const
  {
    if (cb_contains_c1986_0.can_issue()) {
      return cb_contains_c1986_0.issue<QGraphicsObject_Adaptor, bool, const QPointF &>(&QGraphicsObject_Adaptor::cbs_contains_c1986_0, point);
    } else {
      return QGraphicsObject::contains(point);
    }
  }

  //  [adaptor impl] bool QGraphicsObject::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QGraphicsObject::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QGraphicsObject_Adaptor, bool, QEvent *>(&QGraphicsObject_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QGraphicsObject::event(arg1);
    }
  }

  //  [adaptor impl] bool QGraphicsObject::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QGraphicsObject::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QGraphicsObject_Adaptor, bool, QObject *, QEvent *>(&QGraphicsObject_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QGraphicsObject::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] bool QGraphicsObject::isObscuredBy(const QGraphicsItem *item)
  bool cbs_isObscuredBy_c2614_0(const QGraphicsItem *item) const
  {
    return QGraphicsObject::isObscuredBy(item);
  }

  virtual bool isObscuredBy(const QGraphicsItem *item) const
  {
    if (cb_isObscuredBy_c2614_0.can_issue()) {
      return cb_isObscuredBy_c2614_0.issue<QGraphicsObject_Adaptor, bool, const QGraphicsItem *>(&QGraphicsObject_Adaptor::cbs_isObscuredBy_c2614_0, item);
    } else {
      return QGraphicsObject::isObscuredBy(item);
    }
  }

  //  [adaptor impl] QPainterPath QGraphicsObject::opaqueArea()
  QPainterPath cbs_opaqueArea_c0_0() const
  {
    return QGraphicsObject::opaqueArea();
  }

  virtual QPainterPath opaqueArea() const
  {
    if (cb_opaqueArea_c0_0.can_issue()) {
      return cb_opaqueArea_c0_0.issue<QGraphicsObject_Adaptor, QPainterPath>(&QGraphicsObject_Adaptor::cbs_opaqueArea_c0_0);
    } else {
      return QGraphicsObject::opaqueArea();
    }
  }

  //  [adaptor impl] void QGraphicsObject::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  void cbs_paint_6301_1(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  {
    throw qt_gsi::AbstractMethodCalledException("paint");
  }

  virtual void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  {
    if (cb_paint_6301_1.can_issue()) {
      cb_paint_6301_1.issue<QGraphicsObject_Adaptor, QPainter *, const QStyleOptionGraphicsItem *, QWidget *>(&QGraphicsObject_Adaptor::cbs_paint_6301_1, painter, option, widget);
    } else {
      throw qt_gsi::AbstractMethodCalledException("paint");
    }
  }

  //  [adaptor impl] QPainterPath QGraphicsObject::shape()
  QPainterPath cbs_shape_c0_0() const
  {
    return QGraphicsObject::shape();
  }

  virtual QPainterPath shape() const
  {
    if (cb_shape_c0_0.can_issue()) {
      return cb_shape_c0_0.issue<QGraphicsObject_Adaptor, QPainterPath>(&QGraphicsObject_Adaptor::cbs_shape_c0_0);
    } else {
      return QGraphicsObject::shape();
    }
  }

  //  [adaptor impl] int QGraphicsObject::type()
  int cbs_type_c0_0() const
  {
    return QGraphicsObject::type();
  }

  virtual int type() const
  {
    if (cb_type_c0_0.can_issue()) {
      return cb_type_c0_0.issue<QGraphicsObject_Adaptor, int>(&QGraphicsObject_Adaptor::cbs_type_c0_0);
    } else {
      return QGraphicsObject::type();
    }
  }

  //  [adaptor impl] void QGraphicsObject::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QGraphicsObject::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QGraphicsObject_Adaptor, QChildEvent *>(&QGraphicsObject_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QGraphicsObject::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsObject::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)
  void cbs_contextMenuEvent_3674_0(QGraphicsSceneContextMenuEvent *event)
  {
    QGraphicsObject::contextMenuEvent(event);
  }

  virtual void contextMenuEvent(QGraphicsSceneContextMenuEvent *event)
  {
    if (cb_contextMenuEvent_3674_0.can_issue()) {
      cb_contextMenuEvent_3674_0.issue<QGraphicsObject_Adaptor, QGraphicsSceneContextMenuEvent *>(&QGraphicsObject_Adaptor::cbs_contextMenuEvent_3674_0, event);
    } else {
      QGraphicsObject::contextMenuEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsObject::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QGraphicsObject::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QGraphicsObject_Adaptor, QEvent *>(&QGraphicsObject_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QGraphicsObject::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsObject::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QGraphicsObject::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QGraphicsObject_Adaptor, const char *>(&QGraphicsObject_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QGraphicsObject::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QGraphicsObject::dragEnterEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragEnterEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsObject::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragEnterEvent_3315_0.can_issue()) {
      cb_dragEnterEvent_3315_0.issue<QGraphicsObject_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsObject_Adaptor::cbs_dragEnterEvent_3315_0, event);
    } else {
      QGraphicsObject::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsObject::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragLeaveEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsObject::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragLeaveEvent_3315_0.can_issue()) {
      cb_dragLeaveEvent_3315_0.issue<QGraphicsObject_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsObject_Adaptor::cbs_dragLeaveEvent_3315_0, event);
    } else {
      QGraphicsObject::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsObject::dragMoveEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragMoveEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsObject::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragMoveEvent_3315_0.can_issue()) {
      cb_dragMoveEvent_3315_0.issue<QGraphicsObject_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsObject_Adaptor::cbs_dragMoveEvent_3315_0, event);
    } else {
      QGraphicsObject::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsObject::dropEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dropEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsObject::dropEvent(event);
  }

  virtual void dropEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dropEvent_3315_0.can_issue()) {
      cb_dropEvent_3315_0.issue<QGraphicsObject_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsObject_Adaptor::cbs_dropEvent_3315_0, event);
    } else {
      QGraphicsObject::dropEvent(event);
    }
  }

  //  [adaptor impl] QVariant QGraphicsObject::extension(const QVariant &variant)
  QVariant cbs_extension_c2119_0(const QVariant &variant) const
  {
    return QGraphicsObject::extension(variant);
  }

  virtual QVariant extension(const QVariant &variant) const
  {
    if (cb_extension_c2119_0.can_issue()) {
      return cb_extension_c2119_0.issue<QGraphicsObject_Adaptor, QVariant, const QVariant &>(&QGraphicsObject_Adaptor::cbs_extension_c2119_0, variant);
    } else {
      return QGraphicsObject::extension(variant);
    }
  }

  //  [adaptor impl] void QGraphicsObject::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QGraphicsObject::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QGraphicsObject_Adaptor, QFocusEvent *>(&QGraphicsObject_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QGraphicsObject::focusInEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsObject::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QGraphicsObject::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QGraphicsObject_Adaptor, QFocusEvent *>(&QGraphicsObject_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QGraphicsObject::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsObject::hoverEnterEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverEnterEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QGraphicsObject::hoverEnterEvent(event);
  }

  virtual void hoverEnterEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverEnterEvent_3044_0.can_issue()) {
      cb_hoverEnterEvent_3044_0.issue<QGraphicsObject_Adaptor, QGraphicsSceneHoverEvent *>(&QGraphicsObject_Adaptor::cbs_hoverEnterEvent_3044_0, event);
    } else {
      QGraphicsObject::hoverEnterEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsObject::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverLeaveEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QGraphicsObject::hoverLeaveEvent(event);
  }

  virtual void hoverLeaveEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverLeaveEvent_3044_0.can_issue()) {
      cb_hoverLeaveEvent_3044_0.issue<QGraphicsObject_Adaptor, QGraphicsSceneHoverEvent *>(&QGraphicsObject_Adaptor::cbs_hoverLeaveEvent_3044_0, event);
    } else {
      QGraphicsObject::hoverLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsObject::hoverMoveEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverMoveEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QGraphicsObject::hoverMoveEvent(event);
  }

  virtual void hoverMoveEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverMoveEvent_3044_0.can_issue()) {
      cb_hoverMoveEvent_3044_0.issue<QGraphicsObject_Adaptor, QGraphicsSceneHoverEvent *>(&QGraphicsObject_Adaptor::cbs_hoverMoveEvent_3044_0, event);
    } else {
      QGraphicsObject::hoverMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsObject::inputMethodEvent(QInputMethodEvent *event)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *event)
  {
    QGraphicsObject::inputMethodEvent(event);
  }

  virtual void inputMethodEvent(QInputMethodEvent *event)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QGraphicsObject_Adaptor, QInputMethodEvent *>(&QGraphicsObject_Adaptor::cbs_inputMethodEvent_2354_0, event);
    } else {
      QGraphicsObject::inputMethodEvent(event);
    }
  }

  //  [adaptor impl] QVariant QGraphicsObject::inputMethodQuery(Qt::InputMethodQuery query)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) const
  {
    return QGraphicsObject::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery query) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QGraphicsObject_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QGraphicsObject_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(query));
    } else {
      return QGraphicsObject::inputMethodQuery(query);
    }
  }

  //  [adaptor impl] QVariant QGraphicsObject::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)
  QVariant cbs_itemChange_5658_0(const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & change, const QVariant &value)
  {
    return QGraphicsObject::itemChange(qt_gsi::QtToCppAdaptor<QGraphicsItem::GraphicsItemChange>(change).cref(), value);
  }

  virtual QVariant itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)
  {
    if (cb_itemChange_5658_0.can_issue()) {
      return cb_itemChange_5658_0.issue<QGraphicsObject_Adaptor, QVariant, const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type &, const QVariant &>(&QGraphicsObject_Adaptor::cbs_itemChange_5658_0, qt_gsi::CppToQtAdaptor<QGraphicsItem::GraphicsItemChange>(change), value);
    } else {
      return QGraphicsObject::itemChange(change, value);
    }
  }

  //  [adaptor impl] void QGraphicsObject::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QGraphicsObject::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QGraphicsObject_Adaptor, QKeyEvent *>(&QGraphicsObject_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QGraphicsObject::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsObject::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QGraphicsObject::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QGraphicsObject_Adaptor, QKeyEvent *>(&QGraphicsObject_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QGraphicsObject::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsObject::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseDoubleClickEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsObject::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_3049_0.can_issue()) {
      cb_mouseDoubleClickEvent_3049_0.issue<QGraphicsObject_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsObject_Adaptor::cbs_mouseDoubleClickEvent_3049_0, event);
    } else {
      QGraphicsObject::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsObject::mouseMoveEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseMoveEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsObject::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseMoveEvent_3049_0.can_issue()) {
      cb_mouseMoveEvent_3049_0.issue<QGraphicsObject_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsObject_Adaptor::cbs_mouseMoveEvent_3049_0, event);
    } else {
      QGraphicsObject::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsObject::mousePressEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mousePressEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsObject::mousePressEvent(event);
  }

  virtual void mousePressEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mousePressEvent_3049_0.can_issue()) {
      cb_mousePressEvent_3049_0.issue<QGraphicsObject_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsObject_Adaptor::cbs_mousePressEvent_3049_0, event);
    } else {
      QGraphicsObject::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsObject::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseReleaseEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsObject::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_3049_0.can_issue()) {
      cb_mouseReleaseEvent_3049_0.issue<QGraphicsObject_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsObject_Adaptor::cbs_mouseReleaseEvent_3049_0, event);
    } else {
      QGraphicsObject::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsObject::sceneEvent(QEvent *event)
  bool cbs_sceneEvent_1217_0(QEvent *event)
  {
    return QGraphicsObject::sceneEvent(event);
  }

  virtual bool sceneEvent(QEvent *event)
  {
    if (cb_sceneEvent_1217_0.can_issue()) {
      return cb_sceneEvent_1217_0.issue<QGraphicsObject_Adaptor, bool, QEvent *>(&QGraphicsObject_Adaptor::cbs_sceneEvent_1217_0, event);
    } else {
      return QGraphicsObject::sceneEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsObject::sceneEventFilter(QGraphicsItem *watched, QEvent *event)
  bool cbs_sceneEventFilter_3028_0(QGraphicsItem *watched, QEvent *event)
  {
    return QGraphicsObject::sceneEventFilter(watched, event);
  }

  virtual bool sceneEventFilter(QGraphicsItem *watched, QEvent *event)
  {
    if (cb_sceneEventFilter_3028_0.can_issue()) {
      return cb_sceneEventFilter_3028_0.issue<QGraphicsObject_Adaptor, bool, QGraphicsItem *, QEvent *>(&QGraphicsObject_Adaptor::cbs_sceneEventFilter_3028_0, watched, event);
    } else {
      return QGraphicsObject::sceneEventFilter(watched, event);
    }
  }

  //  [adaptor impl] void QGraphicsObject::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)
  void cbs_setExtension_4817_0(unsigned int extension, const QVariant &variant)
  {
    QGraphicsObject::setExtension(QGraphicsItem::Extension(extension), variant);
  }

  virtual void setExtension(QGraphicsItem::Extension extension, const QVariant &variant)
  {
    if (cb_setExtension_4817_0.can_issue()) {
      cb_setExtension_4817_0.issue<QGraphicsObject_Adaptor, unsigned int, const QVariant &>(&QGraphicsObject_Adaptor::cbs_setExtension_4817_0, (unsigned int)(extension), variant);
    } else {
      QGraphicsObject::setExtension(extension, variant);
    }
  }

  //  [adaptor impl] bool QGraphicsObject::supportsExtension(QGraphicsItem::Extension extension)
  bool cbs_supportsExtension_c2806_0(unsigned int extension) const
  {
    return QGraphicsObject::supportsExtension(QGraphicsItem::Extension(extension));
  }

  virtual bool supportsExtension(QGraphicsItem::Extension extension) const
  {
    if (cb_supportsExtension_c2806_0.can_issue()) {
      return cb_supportsExtension_c2806_0.issue<QGraphicsObject_Adaptor, bool, unsigned int>(&QGraphicsObject_Adaptor::cbs_supportsExtension_c2806_0, (unsigned int)(extension));
    } else {
      return QGraphicsObject::supportsExtension(extension);
    }
  }

  //  [adaptor impl] void QGraphicsObject::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QGraphicsObject::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QGraphicsObject_Adaptor, QTimerEvent *>(&QGraphicsObject_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QGraphicsObject::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsObject::wheelEvent(QGraphicsSceneWheelEvent *event)
  void cbs_wheelEvent_3029_0(QGraphicsSceneWheelEvent *event)
  {
    QGraphicsObject::wheelEvent(event);
  }

  virtual void wheelEvent(QGraphicsSceneWheelEvent *event)
  {
    if (cb_wheelEvent_3029_0.can_issue()) {
      cb_wheelEvent_3029_0.issue<QGraphicsObject_Adaptor, QGraphicsSceneWheelEvent *>(&QGraphicsObject_Adaptor::cbs_wheelEvent_3029_0, event);
    } else {
      QGraphicsObject::wheelEvent(event);
    }
  }

  gsi::Callback cb_advance_767_0;
  gsi::Callback cb_boundingRect_c0_0;
  gsi::Callback cb_collidesWithItem_c4977_1;
  gsi::Callback cb_collidesWithPath_c4877_1;
  gsi::Callback cb_contains_c1986_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_isObscuredBy_c2614_0;
  gsi::Callback cb_opaqueArea_c0_0;
  gsi::Callback cb_paint_6301_1;
  gsi::Callback cb_shape_c0_0;
  gsi::Callback cb_type_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_contextMenuEvent_3674_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_3315_0;
  gsi::Callback cb_dragLeaveEvent_3315_0;
  gsi::Callback cb_dragMoveEvent_3315_0;
  gsi::Callback cb_dropEvent_3315_0;
  gsi::Callback cb_extension_c2119_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hoverEnterEvent_3044_0;
  gsi::Callback cb_hoverLeaveEvent_3044_0;
  gsi::Callback cb_hoverMoveEvent_3044_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_itemChange_5658_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_mouseDoubleClickEvent_3049_0;
  gsi::Callback cb_mouseMoveEvent_3049_0;
  gsi::Callback cb_mousePressEvent_3049_0;
  gsi::Callback cb_mouseReleaseEvent_3049_0;
  gsi::Callback cb_sceneEvent_1217_0;
  gsi::Callback cb_sceneEventFilter_3028_0;
  gsi::Callback cb_setExtension_4817_0;
  gsi::Callback cb_supportsExtension_c2806_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_3029_0;
};

QGraphicsObject_Adaptor::~QGraphicsObject_Adaptor() { }

//  Constructor QGraphicsObject::QGraphicsObject(QGraphicsItem *parent) (adaptor class)

static void _init_ctor_QGraphicsObject_Adaptor_1919 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return_new<QGraphicsObject_Adaptor *> ();
}

static void _call_ctor_QGraphicsObject_Adaptor_1919 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsItem *arg1 = args ? args.read<QGraphicsItem * > () : (QGraphicsItem *)(0);
  ret.write<QGraphicsObject_Adaptor *> (new QGraphicsObject_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QGraphicsObject_Adaptor_1919 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsObject::QGraphicsObject(QGraphicsItem *parent)\nThis method creates an object of class QGraphicsObject.", &_init_ctor_QGraphicsObject_Adaptor_1919, &_call_ctor_QGraphicsObject_Adaptor_1919);
}

// void QGraphicsObject::addToIndex()

static void _init_fp_addToIndex_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_addToIndex_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsObject_Adaptor *)cls)->fp_QGraphicsObject_addToIndex_0 ();
}

static qt_gsi::GenericMethod*_create_fp_addToIndex_0 ()
{
  return new qt_gsi::GenericMethod("*addToIndex", "@brief Method void QGraphicsObject::addToIndex()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addToIndex_0, &_call_fp_addToIndex_0);
}


// void QGraphicsObject::prepareGeometryChange()

static void _init_fp_prepareGeometryChange_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_prepareGeometryChange_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsObject_Adaptor *)cls)->fp_QGraphicsObject_prepareGeometryChange_0 ();
}

static qt_gsi::GenericMethod*_create_fp_prepareGeometryChange_0 ()
{
  return new qt_gsi::GenericMethod("*prepareGeometryChange", "@brief Method void QGraphicsObject::prepareGeometryChange()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_prepareGeometryChange_0, &_call_fp_prepareGeometryChange_0);
}


// int QGraphicsObject::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QGraphicsObject_Adaptor *)cls)->fp_QGraphicsObject_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QGraphicsObject::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QGraphicsObject::removeFromIndex()

static void _init_fp_removeFromIndex_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_removeFromIndex_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsObject_Adaptor *)cls)->fp_QGraphicsObject_removeFromIndex_0 ();
}

static qt_gsi::GenericMethod*_create_fp_removeFromIndex_0 ()
{
  return new qt_gsi::GenericMethod("*removeFromIndex", "@brief Method void QGraphicsObject::removeFromIndex()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_removeFromIndex_0, &_call_fp_removeFromIndex_0);
}


// QObject *QGraphicsObject::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QGraphicsObject_Adaptor *)cls)->fp_QGraphicsObject_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QGraphicsObject::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QGraphicsObject::advance(int phase)

static void _init_cbs_advance_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("phase");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_advance_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_advance_767_0 (arg1);
}

static void _set_callback_cbs_advance_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_advance_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_advance_767_0 ()
{
  return new qt_gsi::GenericMethod ("advance", "@hide", false, &_init_cbs_advance_767_0, &_call_cbs_advance_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_advance_767_0 ()
{
  return new qt_gsi::GenericMethod ("advance", "@brief Virtual method void QGraphicsObject::advance(int phase)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_advance_767_0, &_call_cbs_advance_767_0, &_set_callback_cbs_advance_767_0);
}


// QRectF QGraphicsObject::boundingRect()

static void _init_cbs_boundingRect_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_cbs_boundingRect_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRectF > ((QRectF)((QGraphicsObject_Adaptor *)cls)->cbs_boundingRect_c0_0 ());
}

static void _set_callback_cbs_boundingRect_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_boundingRect_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_boundingRect_c0_0 ()
{
  return new qt_gsi::GenericMethod ("boundingRect", "@hide", true, &_init_cbs_boundingRect_c0_0, &_call_cbs_boundingRect_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_boundingRect_c0_0 ()
{
  return new qt_gsi::GenericMethod ("boundingRect", "@brief Virtual method QRectF QGraphicsObject::boundingRect()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_boundingRect_c0_0, &_call_cbs_boundingRect_c0_0, &_set_callback_cbs_boundingRect_c0_0);
}


// bool QGraphicsObject::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)

static void _init_cbs_collidesWithItem_c4977_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_collidesWithItem_c4977_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > ();
  ret.write<bool > ((bool)((QGraphicsObject_Adaptor *)cls)->cbs_collidesWithItem_c4977_1 (arg1, arg2));
}

static void _set_callback_cbs_collidesWithItem_c4977_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_collidesWithItem_c4977_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_collidesWithItem_c4977_1 ()
{
  return new qt_gsi::GenericMethod ("collidesWithItem", "@hide", true, &_init_cbs_collidesWithItem_c4977_1, &_call_cbs_collidesWithItem_c4977_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_collidesWithItem_c4977_1 ()
{
  return new qt_gsi::GenericMethod ("collidesWithItem", "@brief Virtual method bool QGraphicsObject::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_collidesWithItem_c4977_1, &_call_cbs_collidesWithItem_c4977_1, &_set_callback_cbs_collidesWithItem_c4977_1);
}


// bool QGraphicsObject::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)

static void _init_cbs_collidesWithPath_c4877_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_collidesWithPath_c4877_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > ();
  ret.write<bool > ((bool)((QGraphicsObject_Adaptor *)cls)->cbs_collidesWithPath_c4877_1 (arg1, arg2));
}

static void _set_callback_cbs_collidesWithPath_c4877_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_collidesWithPath_c4877_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_collidesWithPath_c4877_1 ()
{
  return new qt_gsi::GenericMethod ("collidesWithPath", "@hide", true, &_init_cbs_collidesWithPath_c4877_1, &_call_cbs_collidesWithPath_c4877_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_collidesWithPath_c4877_1 ()
{
  return new qt_gsi::GenericMethod ("collidesWithPath", "@brief Virtual method bool QGraphicsObject::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_collidesWithPath_c4877_1, &_call_cbs_collidesWithPath_c4877_1, &_set_callback_cbs_collidesWithPath_c4877_1);
}


// bool QGraphicsObject::contains(const QPointF &point)

static void _init_cbs_contains_c1986_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_contains_c1986_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ret.write<bool > ((bool)((QGraphicsObject_Adaptor *)cls)->cbs_contains_c1986_0 (arg1));
}

static void _set_callback_cbs_contains_c1986_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_contains_c1986_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contains_c1986_0 ()
{
  return new qt_gsi::GenericMethod ("contains", "@hide", true, &_init_cbs_contains_c1986_0, &_call_cbs_contains_c1986_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contains_c1986_0 ()
{
  return new qt_gsi::GenericMethod ("contains", "@brief Virtual method bool QGraphicsObject::contains(const QPointF &point)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_contains_c1986_0, &_call_cbs_contains_c1986_0, &_set_callback_cbs_contains_c1986_0);
}


// bool QGraphicsObject::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsObject_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QGraphicsObject::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QGraphicsObject::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsObject_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QGraphicsObject::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// bool QGraphicsObject::isObscuredBy(const QGraphicsItem *item)

static void _init_cbs_isObscuredBy_c2614_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isObscuredBy_c2614_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  ret.write<bool > ((bool)((QGraphicsObject_Adaptor *)cls)->cbs_isObscuredBy_c2614_0 (arg1));
}

static void _set_callback_cbs_isObscuredBy_c2614_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_isObscuredBy_c2614_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_isObscuredBy_c2614_0 ()
{
  return new qt_gsi::GenericMethod ("isObscuredBy", "@hide", true, &_init_cbs_isObscuredBy_c2614_0, &_call_cbs_isObscuredBy_c2614_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_isObscuredBy_c2614_0 ()
{
  return new qt_gsi::GenericMethod ("isObscuredBy", "@brief Virtual method bool QGraphicsObject::isObscuredBy(const QGraphicsItem *item)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isObscuredBy_c2614_0, &_call_cbs_isObscuredBy_c2614_0, &_set_callback_cbs_isObscuredBy_c2614_0);
}


// QPainterPath QGraphicsObject::opaqueArea()

static void _init_cbs_opaqueArea_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_cbs_opaqueArea_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsObject_Adaptor *)cls)->cbs_opaqueArea_c0_0 ());
}

static void _set_callback_cbs_opaqueArea_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_opaqueArea_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_opaqueArea_c0_0 ()
{
  return new qt_gsi::GenericMethod ("opaqueArea", "@hide", true, &_init_cbs_opaqueArea_c0_0, &_call_cbs_opaqueArea_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_opaqueArea_c0_0 ()
{
  return new qt_gsi::GenericMethod ("opaqueArea", "@brief Virtual method QPainterPath QGraphicsObject::opaqueArea()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_opaqueArea_c0_0, &_call_cbs_opaqueArea_c0_0, &_set_callback_cbs_opaqueArea_c0_0);
}


// void QGraphicsObject::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)

static void _init_cbs_paint_6301_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionGraphicsItem * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_paint_6301_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QStyleOptionGraphicsItem *arg2 = args.read<const QStyleOptionGraphicsItem * > ();
  QWidget *arg3 = args.read<QWidget * > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_paint_6301_1 (arg1, arg2, arg3);
}

static void _set_callback_cbs_paint_6301_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_paint_6301_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paint_6301_1 ()
{
  return new qt_gsi::GenericMethod ("paint", "@hide", false, &_init_cbs_paint_6301_1, &_call_cbs_paint_6301_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paint_6301_1 ()
{
  return new qt_gsi::GenericMethod ("paint", "@brief Virtual method void QGraphicsObject::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paint_6301_1, &_call_cbs_paint_6301_1, &_set_callback_cbs_paint_6301_1);
}


// QPainterPath QGraphicsObject::shape()

static void _init_cbs_shape_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_cbs_shape_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsObject_Adaptor *)cls)->cbs_shape_c0_0 ());
}

static void _set_callback_cbs_shape_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_shape_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_shape_c0_0 ()
{
  return new qt_gsi::GenericMethod ("shape", "@hide", true, &_init_cbs_shape_c0_0, &_call_cbs_shape_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_shape_c0_0 ()
{
  return new qt_gsi::GenericMethod ("shape", "@brief Virtual method QPainterPath QGraphicsObject::shape()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_shape_c0_0, &_call_cbs_shape_c0_0, &_set_callback_cbs_shape_c0_0);
}


// int QGraphicsObject::type()

static void _init_cbs_type_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_type_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QGraphicsObject_Adaptor *)cls)->cbs_type_c0_0 ());
}

static void _set_callback_cbs_type_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_type_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_type_c0_0 ()
{
  return new qt_gsi::GenericMethod ("type", "@hide", true, &_init_cbs_type_c0_0, &_call_cbs_type_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_type_c0_0 ()
{
  return new qt_gsi::GenericMethod ("type", "@brief Virtual method int QGraphicsObject::type()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_type_c0_0, &_call_cbs_type_c0_0, &_set_callback_cbs_type_c0_0);
}


// void QGraphicsObject::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QGraphicsObject::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QGraphicsObject::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)

static void _init_cbs_contextMenuEvent_3674_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_3674_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneContextMenuEvent *arg1 = args.read<QGraphicsSceneContextMenuEvent * > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_contextMenuEvent_3674_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_3674_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_contextMenuEvent_3674_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_3674_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_3674_0, &_call_cbs_contextMenuEvent_3674_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_3674_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QGraphicsObject::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_3674_0, &_call_cbs_contextMenuEvent_3674_0, &_set_callback_cbs_contextMenuEvent_3674_0);
}


// void QGraphicsObject::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QGraphicsObject::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QGraphicsObject::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QGraphicsObject::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QGraphicsObject::dragEnterEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragEnterEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_3315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_dragEnterEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_dragEnterEvent_3315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_3315_0, &_call_cbs_dragEnterEvent_3315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QGraphicsObject::dragEnterEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_3315_0, &_call_cbs_dragEnterEvent_3315_0, &_set_callback_cbs_dragEnterEvent_3315_0);
}


// void QGraphicsObject::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragLeaveEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_3315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_dragLeaveEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_dragLeaveEvent_3315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_3315_0, &_call_cbs_dragLeaveEvent_3315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QGraphicsObject::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_3315_0, &_call_cbs_dragLeaveEvent_3315_0, &_set_callback_cbs_dragLeaveEvent_3315_0);
}


// void QGraphicsObject::dragMoveEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragMoveEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_3315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_dragMoveEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_dragMoveEvent_3315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_3315_0, &_call_cbs_dragMoveEvent_3315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QGraphicsObject::dragMoveEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_3315_0, &_call_cbs_dragMoveEvent_3315_0, &_set_callback_cbs_dragMoveEvent_3315_0);
}


// void QGraphicsObject::dropEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dropEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_3315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_dropEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dropEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_dropEvent_3315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_3315_0, &_call_cbs_dropEvent_3315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QGraphicsObject::dropEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_3315_0, &_call_cbs_dropEvent_3315_0, &_set_callback_cbs_dropEvent_3315_0);
}


// QVariant QGraphicsObject::extension(const QVariant &variant)

static void _init_cbs_extension_c2119_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("variant");
  decl->add_arg<const QVariant & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_extension_c2119_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVariant &arg1 = args.read<const QVariant & > ();
  ret.write<QVariant > ((QVariant)((QGraphicsObject_Adaptor *)cls)->cbs_extension_c2119_0 (arg1));
}

static void _set_callback_cbs_extension_c2119_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_extension_c2119_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_extension_c2119_0 ()
{
  return new qt_gsi::GenericMethod ("*extension", "@hide", true, &_init_cbs_extension_c2119_0, &_call_cbs_extension_c2119_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_extension_c2119_0 ()
{
  return new qt_gsi::GenericMethod ("*extension", "@brief Virtual method QVariant QGraphicsObject::extension(const QVariant &variant)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_extension_c2119_0, &_call_cbs_extension_c2119_0, &_set_callback_cbs_extension_c2119_0);
}


// void QGraphicsObject::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QGraphicsObject::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// void QGraphicsObject::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QGraphicsObject::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QGraphicsObject::hoverEnterEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverEnterEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverEnterEvent_3044_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_hoverEnterEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverEnterEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_hoverEnterEvent_3044_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hoverEnterEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverEnterEvent", "@hide", false, &_init_cbs_hoverEnterEvent_3044_0, &_call_cbs_hoverEnterEvent_3044_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hoverEnterEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverEnterEvent", "@brief Virtual method void QGraphicsObject::hoverEnterEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverEnterEvent_3044_0, &_call_cbs_hoverEnterEvent_3044_0, &_set_callback_cbs_hoverEnterEvent_3044_0);
}


// void QGraphicsObject::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverLeaveEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverLeaveEvent_3044_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_hoverLeaveEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverLeaveEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_hoverLeaveEvent_3044_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hoverLeaveEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverLeaveEvent", "@hide", false, &_init_cbs_hoverLeaveEvent_3044_0, &_call_cbs_hoverLeaveEvent_3044_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hoverLeaveEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverLeaveEvent", "@brief Virtual method void QGraphicsObject::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverLeaveEvent_3044_0, &_call_cbs_hoverLeaveEvent_3044_0, &_set_callback_cbs_hoverLeaveEvent_3044_0);
}


// void QGraphicsObject::hoverMoveEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverMoveEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverMoveEvent_3044_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_hoverMoveEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverMoveEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_hoverMoveEvent_3044_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hoverMoveEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverMoveEvent", "@hide", false, &_init_cbs_hoverMoveEvent_3044_0, &_call_cbs_hoverMoveEvent_3044_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hoverMoveEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverMoveEvent", "@brief Virtual method void QGraphicsObject::hoverMoveEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverMoveEvent_3044_0, &_call_cbs_hoverMoveEvent_3044_0, &_set_callback_cbs_hoverMoveEvent_3044_0);
}


// void QGraphicsObject::inputMethodEvent(QInputMethodEvent *event)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QGraphicsObject::inputMethodEvent(QInputMethodEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// QVariant QGraphicsObject::inputMethodQuery(Qt::InputMethodQuery query)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QGraphicsObject_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodQuery", "@brief Virtual method QVariant QGraphicsObject::inputMethodQuery(Qt::InputMethodQuery query)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// QVariant QGraphicsObject::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)

static void _init_cbs_itemChange_5658_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("change");
  decl->add_arg<const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_itemChange_5658_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & arg1 = args.read<const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  ret.write<QVariant > ((QVariant)((QGraphicsObject_Adaptor *)cls)->cbs_itemChange_5658_0 (arg1, arg2));
}

static void _set_callback_cbs_itemChange_5658_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_itemChange_5658_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_itemChange_5658_0 ()
{
  return new qt_gsi::GenericMethod ("*itemChange", "@hide", false, &_init_cbs_itemChange_5658_0, &_call_cbs_itemChange_5658_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_itemChange_5658_0 ()
{
  return new qt_gsi::GenericMethod ("*itemChange", "@brief Virtual method QVariant QGraphicsObject::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_itemChange_5658_0, &_call_cbs_itemChange_5658_0, &_set_callback_cbs_itemChange_5658_0);
}


// void QGraphicsObject::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QGraphicsObject::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QGraphicsObject::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QGraphicsObject::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QGraphicsObject::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_3049_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_mouseDoubleClickEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_mouseDoubleClickEvent_3049_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_3049_0, &_call_cbs_mouseDoubleClickEvent_3049_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QGraphicsObject::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_3049_0, &_call_cbs_mouseDoubleClickEvent_3049_0, &_set_callback_cbs_mouseDoubleClickEvent_3049_0);
}


// void QGraphicsObject::mouseMoveEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseMoveEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_3049_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_mouseMoveEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_mouseMoveEvent_3049_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_3049_0, &_call_cbs_mouseMoveEvent_3049_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QGraphicsObject::mouseMoveEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_3049_0, &_call_cbs_mouseMoveEvent_3049_0, &_set_callback_cbs_mouseMoveEvent_3049_0);
}


// void QGraphicsObject::mousePressEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mousePressEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_3049_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_mousePressEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_mousePressEvent_3049_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_3049_0, &_call_cbs_mousePressEvent_3049_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QGraphicsObject::mousePressEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_3049_0, &_call_cbs_mousePressEvent_3049_0, &_set_callback_cbs_mousePressEvent_3049_0);
}


// void QGraphicsObject::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_3049_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_mouseReleaseEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_mouseReleaseEvent_3049_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_3049_0, &_call_cbs_mouseReleaseEvent_3049_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QGraphicsObject::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_3049_0, &_call_cbs_mouseReleaseEvent_3049_0, &_set_callback_cbs_mouseReleaseEvent_3049_0);
}


// bool QGraphicsObject::sceneEvent(QEvent *event)

static void _init_cbs_sceneEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_sceneEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsObject_Adaptor *)cls)->cbs_sceneEvent_1217_0 (arg1));
}

static void _set_callback_cbs_sceneEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_sceneEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sceneEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*sceneEvent", "@hide", false, &_init_cbs_sceneEvent_1217_0, &_call_cbs_sceneEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sceneEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*sceneEvent", "@brief Virtual method bool QGraphicsObject::sceneEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sceneEvent_1217_0, &_call_cbs_sceneEvent_1217_0, &_set_callback_cbs_sceneEvent_1217_0);
}


// bool QGraphicsObject::sceneEventFilter(QGraphicsItem *watched, QEvent *event)

static void _init_cbs_sceneEventFilter_3028_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_sceneEventFilter_3028_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsItem *arg1 = args.read<QGraphicsItem * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsObject_Adaptor *)cls)->cbs_sceneEventFilter_3028_0 (arg1, arg2));
}

static void _set_callback_cbs_sceneEventFilter_3028_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_sceneEventFilter_3028_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sceneEventFilter_3028_0 ()
{
  return new qt_gsi::GenericMethod ("*sceneEventFilter", "@hide", false, &_init_cbs_sceneEventFilter_3028_0, &_call_cbs_sceneEventFilter_3028_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sceneEventFilter_3028_0 ()
{
  return new qt_gsi::GenericMethod ("*sceneEventFilter", "@brief Virtual method bool QGraphicsObject::sceneEventFilter(QGraphicsItem *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sceneEventFilter_3028_0, &_call_cbs_sceneEventFilter_3028_0, &_set_callback_cbs_sceneEventFilter_3028_0);
}


// void QGraphicsObject::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)

static void _init_cbs_setExtension_4817_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("extension");
  decl->add_arg<unsigned int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("variant");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setExtension_4817_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_setExtension_4817_0 (arg1, arg2);
}

static void _set_callback_cbs_setExtension_4817_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_setExtension_4817_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setExtension_4817_0 ()
{
  return new qt_gsi::GenericMethod ("*setExtension", "@hide", false, &_init_cbs_setExtension_4817_0, &_call_cbs_setExtension_4817_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setExtension_4817_0 ()
{
  return new qt_gsi::GenericMethod ("*setExtension", "@brief Virtual method void QGraphicsObject::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setExtension_4817_0, &_call_cbs_setExtension_4817_0, &_set_callback_cbs_setExtension_4817_0);
}


// bool QGraphicsObject::supportsExtension(QGraphicsItem::Extension extension)

static void _init_cbs_supportsExtension_c2806_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("extension");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_supportsExtension_c2806_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  ret.write<bool > ((bool)((QGraphicsObject_Adaptor *)cls)->cbs_supportsExtension_c2806_0 (arg1));
}

static void _set_callback_cbs_supportsExtension_c2806_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_supportsExtension_c2806_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_supportsExtension_c2806_0 ()
{
  return new qt_gsi::GenericMethod ("*supportsExtension", "@hide", true, &_init_cbs_supportsExtension_c2806_0, &_call_cbs_supportsExtension_c2806_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_supportsExtension_c2806_0 ()
{
  return new qt_gsi::GenericMethod ("*supportsExtension", "@brief Virtual method bool QGraphicsObject::supportsExtension(QGraphicsItem::Extension extension)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportsExtension_c2806_0, &_call_cbs_supportsExtension_c2806_0, &_set_callback_cbs_supportsExtension_c2806_0);
}


// void QGraphicsObject::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QGraphicsObject::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


// void QGraphicsObject::wheelEvent(QGraphicsSceneWheelEvent *event)

static void _init_cbs_wheelEvent_3029_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_3029_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneWheelEvent *arg1 = args.read<QGraphicsSceneWheelEvent * > ();
  ((QGraphicsObject_Adaptor *)cls)->cbs_wheelEvent_3029_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_3029_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsObject_Adaptor *)cls)->cb_wheelEvent_3029_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_3029_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_3029_0, &_call_cbs_wheelEvent_3029_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_3029_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QGraphicsObject::wheelEvent(QGraphicsSceneWheelEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_3029_0, &_call_cbs_wheelEvent_3029_0, &_set_callback_cbs_wheelEvent_3029_0);
}


namespace gsi
{

extern gsi::Class<QGraphicsObject> decl_QGraphicsObject;

gsi::Class<QGraphicsObject_Adaptor> decl_QGraphicsObject_Adaptor (decl_QGraphicsObject, "QGraphicsObject",
  gsi::Methods(_create_fp_addToIndex_0 ()) +
  gsi::Methods(_create_fp_prepareGeometryChange_0 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_removeFromIndex_0 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_advance_767_0 ()) +
  gsi::Methods(_create_callback_cbs_advance_767_0 ()) +
  gsi::Methods(_create_cbs_boundingRect_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_boundingRect_c0_0 ()) +
  gsi::Methods(_create_cbs_collidesWithItem_c4977_1 ()) +
  gsi::Methods(_create_callback_cbs_collidesWithItem_c4977_1 ()) +
  gsi::Methods(_create_cbs_collidesWithPath_c4877_1 ()) +
  gsi::Methods(_create_callback_cbs_collidesWithPath_c4877_1 ()) +
  gsi::Methods(_create_cbs_contains_c1986_0 ()) +
  gsi::Methods(_create_callback_cbs_contains_c1986_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_isObscuredBy_c2614_0 ()) +
  gsi::Methods(_create_callback_cbs_isObscuredBy_c2614_0 ()) +
  gsi::Methods(_create_cbs_opaqueArea_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_opaqueArea_c0_0 ()) +
  gsi::Methods(_create_cbs_paint_6301_1 ()) +
  gsi::Methods(_create_callback_cbs_paint_6301_1 ()) +
  gsi::Methods(_create_cbs_shape_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_shape_c0_0 ()) +
  gsi::Methods(_create_cbs_type_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_type_c0_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_3674_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_3674_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_3315_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_3315_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_3315_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_3315_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_3315_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_3315_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_3315_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_3315_0 ()) +
  gsi::Methods(_create_cbs_extension_c2119_0 ()) +
  gsi::Methods(_create_callback_cbs_extension_c2119_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_hoverEnterEvent_3044_0 ()) +
  gsi::Methods(_create_callback_cbs_hoverEnterEvent_3044_0 ()) +
  gsi::Methods(_create_cbs_hoverLeaveEvent_3044_0 ()) +
  gsi::Methods(_create_callback_cbs_hoverLeaveEvent_3044_0 ()) +
  gsi::Methods(_create_cbs_hoverMoveEvent_3044_0 ()) +
  gsi::Methods(_create_callback_cbs_hoverMoveEvent_3044_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_itemChange_5658_0 ()) +
  gsi::Methods(_create_callback_cbs_itemChange_5658_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_3049_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_3049_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_3049_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_3049_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_3049_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_3049_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_3049_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_3049_0 ()) +
  gsi::Methods(_create_cbs_sceneEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_sceneEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_sceneEventFilter_3028_0 ()) +
  gsi::Methods(_create_callback_cbs_sceneEventFilter_3028_0 ()) +
  gsi::Methods(_create_cbs_setExtension_4817_0 ()) +
  gsi::Methods(_create_callback_cbs_setExtension_4817_0 ()) +
  gsi::Methods(_create_cbs_supportsExtension_c2806_0 ()) +
  gsi::Methods(_create_callback_cbs_supportsExtension_c2806_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_3029_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_3029_0 ()) +
  gsi::Methods(_create_ctor_QGraphicsObject_Adaptor_1919 ()),
  "@qt\n@brief Binding of QGraphicsObject");

}

