
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQFormLayout.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQFormLayout_EventAdaptor.h"
#include "gsiDeclQFormLayout_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QFormLayout

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QFormLayout::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// void QFormLayout::addItem(QLayoutItem *item)


static void _init_f_addItem_1740 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QLayoutItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addItem_1740 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLayoutItem *arg1 = args.read<QLayoutItem * > ();
  ((QFormLayout *)cls)->addItem (arg1);
}

static qt_gsi::GenericMethod *_create_f_addItem_1740 ()
{
  return new qt_gsi::GenericMethod ("addItem", "@brief Method void QFormLayout::addItem(QLayoutItem *item)\nThis is a reimplementation of QLayout::addItem", false, &_init_f_addItem_1740, &_call_f_addItem_1740);
}

// void QFormLayout::addRow(QWidget *label, QWidget *field)


static void _init_f_addRow_2522 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("label");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("field");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addRow_2522 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  QWidget *arg2 = args.read<QWidget * > ();
  ((QFormLayout *)cls)->addRow (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_addRow_2522 ()
{
  return new qt_gsi::GenericMethod ("addRow", "@brief Method void QFormLayout::addRow(QWidget *label, QWidget *field)\n", false, &_init_f_addRow_2522, &_call_f_addRow_2522);
}

// void QFormLayout::addRow(QWidget *label, QLayout *field)


static void _init_f_addRow_2548 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("label");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("field");
  decl->add_arg<QLayout * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addRow_2548 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  QLayout *arg2 = args.read<QLayout * > ();
  ((QFormLayout *)cls)->addRow (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_addRow_2548 ()
{
  return new qt_gsi::GenericMethod ("addRow", "@brief Method void QFormLayout::addRow(QWidget *label, QLayout *field)\n", false, &_init_f_addRow_2548, &_call_f_addRow_2548);
}

// void QFormLayout::addRow(const QString &labelText, QWidget *field)


static void _init_f_addRow_3232 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("labelText");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("field");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addRow_3232 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  QWidget *arg2 = args.read<QWidget * > ();
  ((QFormLayout *)cls)->addRow (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_addRow_3232 ()
{
  return new qt_gsi::GenericMethod ("addRow", "@brief Method void QFormLayout::addRow(const QString &labelText, QWidget *field)\n", false, &_init_f_addRow_3232, &_call_f_addRow_3232);
}

// void QFormLayout::addRow(const QString &labelText, QLayout *field)


static void _init_f_addRow_3258 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("labelText");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("field");
  decl->add_arg<QLayout * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addRow_3258 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  QLayout *arg2 = args.read<QLayout * > ();
  ((QFormLayout *)cls)->addRow (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_addRow_3258 ()
{
  return new qt_gsi::GenericMethod ("addRow", "@brief Method void QFormLayout::addRow(const QString &labelText, QLayout *field)\n", false, &_init_f_addRow_3258, &_call_f_addRow_3258);
}

// void QFormLayout::addRow(QWidget *widget)


static void _init_f_addRow_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addRow_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QFormLayout *)cls)->addRow (arg1);
}

static qt_gsi::GenericMethod *_create_f_addRow_1315 ()
{
  return new qt_gsi::GenericMethod ("addRow", "@brief Method void QFormLayout::addRow(QWidget *widget)\n", false, &_init_f_addRow_1315, &_call_f_addRow_1315);
}

// void QFormLayout::addRow(QLayout *layout)


static void _init_f_addRow_1341 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("layout");
  decl->add_arg<QLayout * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addRow_1341 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLayout *arg1 = args.read<QLayout * > ();
  ((QFormLayout *)cls)->addRow (arg1);
}

static qt_gsi::GenericMethod *_create_f_addRow_1341 ()
{
  return new qt_gsi::GenericMethod ("addRow", "@brief Method void QFormLayout::addRow(QLayout *layout)\n", false, &_init_f_addRow_1341, &_call_f_addRow_1341);
}

// int QFormLayout::count()


static void _init_f_count_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_count_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QFormLayout *)cls)->count ());
}

static qt_gsi::GenericMethod *_create_f_count_c0 ()
{
  return new qt_gsi::GenericMethod ("count", "@brief Method int QFormLayout::count()\nThis is a reimplementation of QLayout::count", true, &_init_f_count_c0, &_call_f_count_c0);
}

// QFlags<Qt::Orientation> QFormLayout::expandingDirections()


static void _init_f_expandingDirections_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type > ();
}

static void _call_f_expandingDirections_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type > ((qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::Orientation> >(((QFormLayout *)cls)->expandingDirections ()));
}

static qt_gsi::GenericMethod *_create_f_expandingDirections_c0 ()
{
  return new qt_gsi::GenericMethod ("expandingDirections", "@brief Method QFlags<Qt::Orientation> QFormLayout::expandingDirections()\nThis is a reimplementation of QLayout::expandingDirections", true, &_init_f_expandingDirections_c0, &_call_f_expandingDirections_c0);
}

// QFormLayout::FieldGrowthPolicy QFormLayout::fieldGrowthPolicy()


static void _init_f_fieldGrowthPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFormLayout::FieldGrowthPolicy>::target_type > ();
}

static void _call_f_fieldGrowthPolicy_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFormLayout::FieldGrowthPolicy>::target_type > ((qt_gsi::Converter<QFormLayout::FieldGrowthPolicy>::target_type)qt_gsi::CppToQtAdaptor<QFormLayout::FieldGrowthPolicy>(((QFormLayout *)cls)->fieldGrowthPolicy ()));
}

static qt_gsi::GenericMethod *_create_f_fieldGrowthPolicy_c0 ()
{
  return new qt_gsi::GenericMethod (":fieldGrowthPolicy", "@brief Method QFormLayout::FieldGrowthPolicy QFormLayout::fieldGrowthPolicy()\n", true, &_init_f_fieldGrowthPolicy_c0, &_call_f_fieldGrowthPolicy_c0);
}

// QFlags<Qt::AlignmentFlag> QFormLayout::formAlignment()


static void _init_f_formAlignment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type > ();
}

static void _call_f_formAlignment_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type > ((qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::AlignmentFlag> >(((QFormLayout *)cls)->formAlignment ()));
}

static qt_gsi::GenericMethod *_create_f_formAlignment_c0 ()
{
  return new qt_gsi::GenericMethod (":formAlignment", "@brief Method QFlags<Qt::AlignmentFlag> QFormLayout::formAlignment()\n", true, &_init_f_formAlignment_c0, &_call_f_formAlignment_c0);
}

// void QFormLayout::getItemPosition(int index, int *rowPtr, QFormLayout::ItemRole *rolePtr)


static void _init_f_getItemPosition_c4166 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rowPtr");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rolePtr");
  decl->add_arg<qt_gsi::Converter<QFormLayout::ItemRole>::target_type * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_getItemPosition_c4166 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int *arg2 = args.read<int * > ();
  qt_gsi::Converter<QFormLayout::ItemRole>::target_type * arg3 = args.read<qt_gsi::Converter<QFormLayout::ItemRole>::target_type * > ();
  ((QFormLayout *)cls)->getItemPosition (arg1, arg2, qt_gsi::QtToCppAdaptor<QFormLayout::ItemRole>(arg3).ptr());
}

static qt_gsi::GenericMethod *_create_f_getItemPosition_c4166 ()
{
  return new qt_gsi::GenericMethod ("getItemPosition", "@brief Method void QFormLayout::getItemPosition(int index, int *rowPtr, QFormLayout::ItemRole *rolePtr)\n", true, &_init_f_getItemPosition_c4166, &_call_f_getItemPosition_c4166);
}

// void QFormLayout::getLayoutPosition(QLayout *layout, int *rowPtr, QFormLayout::ItemRole *rolePtr)


static void _init_f_getLayoutPosition_c4740 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("layout");
  decl->add_arg<QLayout * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rowPtr");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rolePtr");
  decl->add_arg<qt_gsi::Converter<QFormLayout::ItemRole>::target_type * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_getLayoutPosition_c4740 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLayout *arg1 = args.read<QLayout * > ();
  int *arg2 = args.read<int * > ();
  qt_gsi::Converter<QFormLayout::ItemRole>::target_type * arg3 = args.read<qt_gsi::Converter<QFormLayout::ItemRole>::target_type * > ();
  ((QFormLayout *)cls)->getLayoutPosition (arg1, arg2, qt_gsi::QtToCppAdaptor<QFormLayout::ItemRole>(arg3).ptr());
}

static qt_gsi::GenericMethod *_create_f_getLayoutPosition_c4740 ()
{
  return new qt_gsi::GenericMethod ("getLayoutPosition", "@brief Method void QFormLayout::getLayoutPosition(QLayout *layout, int *rowPtr, QFormLayout::ItemRole *rolePtr)\n", true, &_init_f_getLayoutPosition_c4740, &_call_f_getLayoutPosition_c4740);
}

// void QFormLayout::getWidgetPosition(QWidget *widget, int *rowPtr, QFormLayout::ItemRole *rolePtr)


static void _init_f_getWidgetPosition_c4714 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rowPtr");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rolePtr");
  decl->add_arg<qt_gsi::Converter<QFormLayout::ItemRole>::target_type * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_getWidgetPosition_c4714 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  int *arg2 = args.read<int * > ();
  qt_gsi::Converter<QFormLayout::ItemRole>::target_type * arg3 = args.read<qt_gsi::Converter<QFormLayout::ItemRole>::target_type * > ();
  ((QFormLayout *)cls)->getWidgetPosition (arg1, arg2, qt_gsi::QtToCppAdaptor<QFormLayout::ItemRole>(arg3).ptr());
}

static qt_gsi::GenericMethod *_create_f_getWidgetPosition_c4714 ()
{
  return new qt_gsi::GenericMethod ("getWidgetPosition", "@brief Method void QFormLayout::getWidgetPosition(QWidget *widget, int *rowPtr, QFormLayout::ItemRole *rolePtr)\n", true, &_init_f_getWidgetPosition_c4714, &_call_f_getWidgetPosition_c4714);
}

// bool QFormLayout::hasHeightForWidth()


static void _init_f_hasHeightForWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasHeightForWidth_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFormLayout *)cls)->hasHeightForWidth ());
}

static qt_gsi::GenericMethod *_create_f_hasHeightForWidth_c0 ()
{
  return new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Method bool QFormLayout::hasHeightForWidth()\nThis is a reimplementation of QLayoutItem::hasHeightForWidth", true, &_init_f_hasHeightForWidth_c0, &_call_f_hasHeightForWidth_c0);
}

// int QFormLayout::heightForWidth(int width)


static void _init_f_heightForWidth_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_heightForWidth_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QFormLayout *)cls)->heightForWidth (arg1));
}

static qt_gsi::GenericMethod *_create_f_heightForWidth_c767 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Method int QFormLayout::heightForWidth(int width)\nThis is a reimplementation of QLayoutItem::heightForWidth", true, &_init_f_heightForWidth_c767, &_call_f_heightForWidth_c767);
}

// int QFormLayout::horizontalSpacing()


static void _init_f_horizontalSpacing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_horizontalSpacing_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QFormLayout *)cls)->horizontalSpacing ());
}

static qt_gsi::GenericMethod *_create_f_horizontalSpacing_c0 ()
{
  return new qt_gsi::GenericMethod (":horizontalSpacing", "@brief Method int QFormLayout::horizontalSpacing()\n", true, &_init_f_horizontalSpacing_c0, &_call_f_horizontalSpacing_c0);
}

// void QFormLayout::insertRow(int row, QWidget *label, QWidget *field)


static void _init_f_insertRow_3181 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("label");
  decl->add_arg<QWidget * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("field");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_insertRow_3181 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QWidget *arg2 = args.read<QWidget * > ();
  QWidget *arg3 = args.read<QWidget * > ();
  ((QFormLayout *)cls)->insertRow (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_insertRow_3181 ()
{
  return new qt_gsi::GenericMethod ("insertRow", "@brief Method void QFormLayout::insertRow(int row, QWidget *label, QWidget *field)\n", false, &_init_f_insertRow_3181, &_call_f_insertRow_3181);
}

// void QFormLayout::insertRow(int row, QWidget *label, QLayout *field)


static void _init_f_insertRow_3207 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("label");
  decl->add_arg<QWidget * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("field");
  decl->add_arg<QLayout * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_insertRow_3207 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QWidget *arg2 = args.read<QWidget * > ();
  QLayout *arg3 = args.read<QLayout * > ();
  ((QFormLayout *)cls)->insertRow (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_insertRow_3207 ()
{
  return new qt_gsi::GenericMethod ("insertRow", "@brief Method void QFormLayout::insertRow(int row, QWidget *label, QLayout *field)\n", false, &_init_f_insertRow_3207, &_call_f_insertRow_3207);
}

// void QFormLayout::insertRow(int row, const QString &labelText, QWidget *field)


static void _init_f_insertRow_3891 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("labelText");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("field");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_insertRow_3891 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QString &arg2 = args.read<const QString & > ();
  QWidget *arg3 = args.read<QWidget * > ();
  ((QFormLayout *)cls)->insertRow (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_insertRow_3891 ()
{
  return new qt_gsi::GenericMethod ("insertRow", "@brief Method void QFormLayout::insertRow(int row, const QString &labelText, QWidget *field)\n", false, &_init_f_insertRow_3891, &_call_f_insertRow_3891);
}

// void QFormLayout::insertRow(int row, const QString &labelText, QLayout *field)


static void _init_f_insertRow_3917 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("labelText");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("field");
  decl->add_arg<QLayout * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_insertRow_3917 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QString &arg2 = args.read<const QString & > ();
  QLayout *arg3 = args.read<QLayout * > ();
  ((QFormLayout *)cls)->insertRow (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_insertRow_3917 ()
{
  return new qt_gsi::GenericMethod ("insertRow", "@brief Method void QFormLayout::insertRow(int row, const QString &labelText, QLayout *field)\n", false, &_init_f_insertRow_3917, &_call_f_insertRow_3917);
}

// void QFormLayout::insertRow(int row, QWidget *widget)


static void _init_f_insertRow_1974 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("widget");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertRow_1974 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QWidget *arg2 = args.read<QWidget * > ();
  ((QFormLayout *)cls)->insertRow (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_insertRow_1974 ()
{
  return new qt_gsi::GenericMethod ("insertRow", "@brief Method void QFormLayout::insertRow(int row, QWidget *widget)\n", false, &_init_f_insertRow_1974, &_call_f_insertRow_1974);
}

// void QFormLayout::insertRow(int row, QLayout *layout)


static void _init_f_insertRow_2000 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("layout");
  decl->add_arg<QLayout * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertRow_2000 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QLayout *arg2 = args.read<QLayout * > ();
  ((QFormLayout *)cls)->insertRow (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_insertRow_2000 ()
{
  return new qt_gsi::GenericMethod ("insertRow", "@brief Method void QFormLayout::insertRow(int row, QLayout *layout)\n", false, &_init_f_insertRow_2000, &_call_f_insertRow_2000);
}

// void QFormLayout::invalidate()


static void _init_f_invalidate_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_invalidate_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFormLayout *)cls)->invalidate ();
}

static qt_gsi::GenericMethod *_create_f_invalidate_0 ()
{
  return new qt_gsi::GenericMethod ("invalidate", "@brief Method void QFormLayout::invalidate()\nThis is a reimplementation of QLayout::invalidate", false, &_init_f_invalidate_0, &_call_f_invalidate_0);
}

// QLayoutItem *QFormLayout::itemAt(int row, QFormLayout::ItemRole role)


static void _init_f_itemAt_c3135 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & > (argspec_1);
  decl->set_return<QLayoutItem * > ();
}

static void _call_f_itemAt_c3135 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & arg2 = args.read<const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & > ();
  ret.write<QLayoutItem * > ((QLayoutItem *)((QFormLayout *)cls)->itemAt (arg1, qt_gsi::QtToCppAdaptor<QFormLayout::ItemRole>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_itemAt_c3135 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@brief Method QLayoutItem *QFormLayout::itemAt(int row, QFormLayout::ItemRole role)\n", true, &_init_f_itemAt_c3135, &_call_f_itemAt_c3135);
}

// QLayoutItem *QFormLayout::itemAt(int index)


static void _init_f_itemAt_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_f_itemAt_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QLayoutItem * > ((QLayoutItem *)((QFormLayout *)cls)->itemAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_itemAt_c767 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@brief Method QLayoutItem *QFormLayout::itemAt(int index)\nThis is a reimplementation of QLayout::itemAt", true, &_init_f_itemAt_c767, &_call_f_itemAt_c767);
}

// QFlags<Qt::AlignmentFlag> QFormLayout::labelAlignment()


static void _init_f_labelAlignment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type > ();
}

static void _call_f_labelAlignment_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type > ((qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::AlignmentFlag> >(((QFormLayout *)cls)->labelAlignment ()));
}

static qt_gsi::GenericMethod *_create_f_labelAlignment_c0 ()
{
  return new qt_gsi::GenericMethod (":labelAlignment", "@brief Method QFlags<Qt::AlignmentFlag> QFormLayout::labelAlignment()\n", true, &_init_f_labelAlignment_c0, &_call_f_labelAlignment_c0);
}

// QWidget *QFormLayout::labelForField(QWidget *field)


static void _init_f_labelForField_c1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("field");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<QWidget * > ();
}

static void _call_f_labelForField_c1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ret.write<QWidget * > ((QWidget *)((QFormLayout *)cls)->labelForField (arg1));
}

static qt_gsi::GenericMethod *_create_f_labelForField_c1315 ()
{
  return new qt_gsi::GenericMethod ("labelForField", "@brief Method QWidget *QFormLayout::labelForField(QWidget *field)\n", true, &_init_f_labelForField_c1315, &_call_f_labelForField_c1315);
}

// QWidget *QFormLayout::labelForField(QLayout *field)


static void _init_f_labelForField_c1341 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("field");
  decl->add_arg<QLayout * > (argspec_0);
  decl->set_return<QWidget * > ();
}

static void _call_f_labelForField_c1341 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLayout *arg1 = args.read<QLayout * > ();
  ret.write<QWidget * > ((QWidget *)((QFormLayout *)cls)->labelForField (arg1));
}

static qt_gsi::GenericMethod *_create_f_labelForField_c1341 ()
{
  return new qt_gsi::GenericMethod ("labelForField", "@brief Method QWidget *QFormLayout::labelForField(QLayout *field)\n", true, &_init_f_labelForField_c1341, &_call_f_labelForField_c1341);
}

// QSize QFormLayout::minimumSize()


static void _init_f_minimumSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QFormLayout *)cls)->minimumSize ());
}

static qt_gsi::GenericMethod *_create_f_minimumSize_c0 ()
{
  return new qt_gsi::GenericMethod ("minimumSize", "@brief Method QSize QFormLayout::minimumSize()\nThis is a reimplementation of QLayout::minimumSize", true, &_init_f_minimumSize_c0, &_call_f_minimumSize_c0);
}

// int QFormLayout::rowCount()


static void _init_f_rowCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_rowCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QFormLayout *)cls)->rowCount ());
}

static qt_gsi::GenericMethod *_create_f_rowCount_c0 ()
{
  return new qt_gsi::GenericMethod ("rowCount", "@brief Method int QFormLayout::rowCount()\n", true, &_init_f_rowCount_c0, &_call_f_rowCount_c0);
}

// QFormLayout::RowWrapPolicy QFormLayout::rowWrapPolicy()


static void _init_f_rowWrapPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFormLayout::RowWrapPolicy>::target_type > ();
}

static void _call_f_rowWrapPolicy_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFormLayout::RowWrapPolicy>::target_type > ((qt_gsi::Converter<QFormLayout::RowWrapPolicy>::target_type)qt_gsi::CppToQtAdaptor<QFormLayout::RowWrapPolicy>(((QFormLayout *)cls)->rowWrapPolicy ()));
}

static qt_gsi::GenericMethod *_create_f_rowWrapPolicy_c0 ()
{
  return new qt_gsi::GenericMethod (":rowWrapPolicy", "@brief Method QFormLayout::RowWrapPolicy QFormLayout::rowWrapPolicy()\n", true, &_init_f_rowWrapPolicy_c0, &_call_f_rowWrapPolicy_c0);
}

// void QFormLayout::setFieldGrowthPolicy(QFormLayout::FieldGrowthPolicy policy)


static void _init_f_setFieldGrowthPolicy_3418 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("policy");
  decl->add_arg<const qt_gsi::Converter<QFormLayout::FieldGrowthPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFieldGrowthPolicy_3418 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFormLayout::FieldGrowthPolicy>::target_type & arg1 = args.read<const qt_gsi::Converter<QFormLayout::FieldGrowthPolicy>::target_type & > ();
  ((QFormLayout *)cls)->setFieldGrowthPolicy (qt_gsi::QtToCppAdaptor<QFormLayout::FieldGrowthPolicy>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setFieldGrowthPolicy_3418 ()
{
  return new qt_gsi::GenericMethod ("setFieldGrowthPolicy|fieldGrowthPolicy=", "@brief Method void QFormLayout::setFieldGrowthPolicy(QFormLayout::FieldGrowthPolicy policy)\n", false, &_init_f_setFieldGrowthPolicy_3418, &_call_f_setFieldGrowthPolicy_3418);
}

// void QFormLayout::setFormAlignment(QFlags<Qt::AlignmentFlag> alignment)


static void _init_f_setFormAlignment_2750 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("alignment");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFormAlignment_2750 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > ();
  ((QFormLayout *)cls)->setFormAlignment (qt_gsi::QtToCppAdaptor<QFlags<Qt::AlignmentFlag> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setFormAlignment_2750 ()
{
  return new qt_gsi::GenericMethod ("setFormAlignment|formAlignment=", "@brief Method void QFormLayout::setFormAlignment(QFlags<Qt::AlignmentFlag> alignment)\n", false, &_init_f_setFormAlignment_2750, &_call_f_setFormAlignment_2750);
}

// void QFormLayout::setGeometry(const QRect &rect)


static void _init_f_setGeometry_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGeometry_1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ((QFormLayout *)cls)->setGeometry (arg1);
}

static qt_gsi::GenericMethod *_create_f_setGeometry_1792 ()
{
  return new qt_gsi::GenericMethod ("setGeometry|geometry=", "@brief Method void QFormLayout::setGeometry(const QRect &rect)\nThis is a reimplementation of QLayout::setGeometry", false, &_init_f_setGeometry_1792, &_call_f_setGeometry_1792);
}

// void QFormLayout::setHorizontalSpacing(int spacing)


static void _init_f_setHorizontalSpacing_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("spacing");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHorizontalSpacing_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QFormLayout *)cls)->setHorizontalSpacing (arg1);
}

static qt_gsi::GenericMethod *_create_f_setHorizontalSpacing_767 ()
{
  return new qt_gsi::GenericMethod ("setHorizontalSpacing|horizontalSpacing=", "@brief Method void QFormLayout::setHorizontalSpacing(int spacing)\n", false, &_init_f_setHorizontalSpacing_767, &_call_f_setHorizontalSpacing_767);
}

// void QFormLayout::setItem(int row, QFormLayout::ItemRole role, QLayoutItem *item)


static void _init_f_setItem_4767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("item");
  decl->add_arg<QLayoutItem * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setItem_4767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & arg2 = args.read<const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & > ();
  QLayoutItem *arg3 = args.read<QLayoutItem * > ();
  ((QFormLayout *)cls)->setItem (arg1, qt_gsi::QtToCppAdaptor<QFormLayout::ItemRole>(arg2).cref(), arg3);
}

static qt_gsi::GenericMethod *_create_f_setItem_4767 ()
{
  return new qt_gsi::GenericMethod ("setItem", "@brief Method void QFormLayout::setItem(int row, QFormLayout::ItemRole role, QLayoutItem *item)\n", false, &_init_f_setItem_4767, &_call_f_setItem_4767);
}

// void QFormLayout::setLabelAlignment(QFlags<Qt::AlignmentFlag> alignment)


static void _init_f_setLabelAlignment_2750 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("alignment");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLabelAlignment_2750 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > ();
  ((QFormLayout *)cls)->setLabelAlignment (qt_gsi::QtToCppAdaptor<QFlags<Qt::AlignmentFlag> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setLabelAlignment_2750 ()
{
  return new qt_gsi::GenericMethod ("setLabelAlignment|labelAlignment=", "@brief Method void QFormLayout::setLabelAlignment(QFlags<Qt::AlignmentFlag> alignment)\n", false, &_init_f_setLabelAlignment_2750, &_call_f_setLabelAlignment_2750);
}

// void QFormLayout::setLayout(int row, QFormLayout::ItemRole role, QLayout *layout)


static void _init_f_setLayout_4368 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("layout");
  decl->add_arg<QLayout * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setLayout_4368 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & arg2 = args.read<const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & > ();
  QLayout *arg3 = args.read<QLayout * > ();
  ((QFormLayout *)cls)->setLayout (arg1, qt_gsi::QtToCppAdaptor<QFormLayout::ItemRole>(arg2).cref(), arg3);
}

static qt_gsi::GenericMethod *_create_f_setLayout_4368 ()
{
  return new qt_gsi::GenericMethod ("setLayout", "@brief Method void QFormLayout::setLayout(int row, QFormLayout::ItemRole role, QLayout *layout)\n", false, &_init_f_setLayout_4368, &_call_f_setLayout_4368);
}

// void QFormLayout::setRowWrapPolicy(QFormLayout::RowWrapPolicy policy)


static void _init_f_setRowWrapPolicy_3021 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("policy");
  decl->add_arg<const qt_gsi::Converter<QFormLayout::RowWrapPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRowWrapPolicy_3021 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFormLayout::RowWrapPolicy>::target_type & arg1 = args.read<const qt_gsi::Converter<QFormLayout::RowWrapPolicy>::target_type & > ();
  ((QFormLayout *)cls)->setRowWrapPolicy (qt_gsi::QtToCppAdaptor<QFormLayout::RowWrapPolicy>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setRowWrapPolicy_3021 ()
{
  return new qt_gsi::GenericMethod ("setRowWrapPolicy|rowWrapPolicy=", "@brief Method void QFormLayout::setRowWrapPolicy(QFormLayout::RowWrapPolicy policy)\n", false, &_init_f_setRowWrapPolicy_3021, &_call_f_setRowWrapPolicy_3021);
}

// void QFormLayout::setSpacing(int)


static void _init_f_setSpacing_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSpacing_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QFormLayout *)cls)->setSpacing (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSpacing_767 ()
{
  return new qt_gsi::GenericMethod ("setSpacing|spacing=", "@brief Method void QFormLayout::setSpacing(int)\n", false, &_init_f_setSpacing_767, &_call_f_setSpacing_767);
}

// void QFormLayout::setVerticalSpacing(int spacing)


static void _init_f_setVerticalSpacing_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("spacing");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVerticalSpacing_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QFormLayout *)cls)->setVerticalSpacing (arg1);
}

static qt_gsi::GenericMethod *_create_f_setVerticalSpacing_767 ()
{
  return new qt_gsi::GenericMethod ("setVerticalSpacing|verticalSpacing=", "@brief Method void QFormLayout::setVerticalSpacing(int spacing)\n", false, &_init_f_setVerticalSpacing_767, &_call_f_setVerticalSpacing_767);
}

// void QFormLayout::setWidget(int row, QFormLayout::ItemRole role, QWidget *widget)


static void _init_f_setWidget_4342 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setWidget_4342 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & arg2 = args.read<const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & > ();
  QWidget *arg3 = args.read<QWidget * > ();
  ((QFormLayout *)cls)->setWidget (arg1, qt_gsi::QtToCppAdaptor<QFormLayout::ItemRole>(arg2).cref(), arg3);
}

static qt_gsi::GenericMethod *_create_f_setWidget_4342 ()
{
  return new qt_gsi::GenericMethod ("setWidget", "@brief Method void QFormLayout::setWidget(int row, QFormLayout::ItemRole role, QWidget *widget)\n", false, &_init_f_setWidget_4342, &_call_f_setWidget_4342);
}

// QSize QFormLayout::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QFormLayout *)cls)->sizeHint ());
}

static qt_gsi::GenericMethod *_create_f_sizeHint_c0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Method QSize QFormLayout::sizeHint()\nThis is a reimplementation of QLayoutItem::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
}

// int QFormLayout::spacing()


static void _init_f_spacing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_spacing_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QFormLayout *)cls)->spacing ());
}

static qt_gsi::GenericMethod *_create_f_spacing_c0 ()
{
  return new qt_gsi::GenericMethod (":spacing", "@brief Method int QFormLayout::spacing()\n", true, &_init_f_spacing_c0, &_call_f_spacing_c0);
}

// QLayoutItem *QFormLayout::takeAt(int index)


static void _init_f_takeAt_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return_new<QLayoutItem * > ();
}

static void _call_f_takeAt_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QLayoutItem * > ((QLayoutItem *)((QFormLayout *)cls)->takeAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_takeAt_767 ()
{
  return new qt_gsi::GenericMethod ("takeAt", "@brief Method QLayoutItem *QFormLayout::takeAt(int index)\nThis is a reimplementation of QLayout::takeAt", false, &_init_f_takeAt_767, &_call_f_takeAt_767);
}

// int QFormLayout::verticalSpacing()


static void _init_f_verticalSpacing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_verticalSpacing_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QFormLayout *)cls)->verticalSpacing ());
}

static qt_gsi::GenericMethod *_create_f_verticalSpacing_c0 ()
{
  return new qt_gsi::GenericMethod (":verticalSpacing", "@brief Method int QFormLayout::verticalSpacing()\n", true, &_init_f_verticalSpacing_c0, &_call_f_verticalSpacing_c0);
}

// static QString QFormLayout::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QFormLayout::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QFormLayout::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QFormLayout::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QFormLayout::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QFormLayout::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QFormLayout::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QFormLayout::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QFormLayout::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QFormLayout::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QFormLayout::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QFormLayout::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QFormLayout, QFormLayout_EventAdaptor> ea_QFormLayout;

namespace gsi
{
extern gsi::Class<QLayout> decl_QLayout;

gsi::Class<QFormLayout> decl_QFormLayout (ea_QFormLayout, decl_QLayout, "QFormLayout_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_addItem_1740 ()) +
  gsi::Methods(_create_f_addRow_2522 ()) +
  gsi::Methods(_create_f_addRow_2548 ()) +
  gsi::Methods(_create_f_addRow_3232 ()) +
  gsi::Methods(_create_f_addRow_3258 ()) +
  gsi::Methods(_create_f_addRow_1315 ()) +
  gsi::Methods(_create_f_addRow_1341 ()) +
  gsi::Methods(_create_f_count_c0 ()) +
  gsi::Methods(_create_f_expandingDirections_c0 ()) +
  gsi::Methods(_create_f_fieldGrowthPolicy_c0 ()) +
  gsi::Methods(_create_f_formAlignment_c0 ()) +
  gsi::Methods(_create_f_getItemPosition_c4166 ()) +
  gsi::Methods(_create_f_getLayoutPosition_c4740 ()) +
  gsi::Methods(_create_f_getWidgetPosition_c4714 ()) +
  gsi::Methods(_create_f_hasHeightForWidth_c0 ()) +
  gsi::Methods(_create_f_heightForWidth_c767 ()) +
  gsi::Methods(_create_f_horizontalSpacing_c0 ()) +
  gsi::Methods(_create_f_insertRow_3181 ()) +
  gsi::Methods(_create_f_insertRow_3207 ()) +
  gsi::Methods(_create_f_insertRow_3891 ()) +
  gsi::Methods(_create_f_insertRow_3917 ()) +
  gsi::Methods(_create_f_insertRow_1974 ()) +
  gsi::Methods(_create_f_insertRow_2000 ()) +
  gsi::Methods(_create_f_invalidate_0 ()) +
  gsi::Methods(_create_f_itemAt_c3135 ()) +
  gsi::Methods(_create_f_itemAt_c767 ()) +
  gsi::Methods(_create_f_labelAlignment_c0 ()) +
  gsi::Methods(_create_f_labelForField_c1315 ()) +
  gsi::Methods(_create_f_labelForField_c1341 ()) +
  gsi::Methods(_create_f_minimumSize_c0 ()) +
  gsi::Methods(_create_f_rowCount_c0 ()) +
  gsi::Methods(_create_f_rowWrapPolicy_c0 ()) +
  gsi::Methods(_create_f_setFieldGrowthPolicy_3418 ()) +
  gsi::Methods(_create_f_setFormAlignment_2750 ()) +
  gsi::Methods(_create_f_setGeometry_1792 ()) +
  gsi::Methods(_create_f_setHorizontalSpacing_767 ()) +
  gsi::Methods(_create_f_setItem_4767 ()) +
  gsi::Methods(_create_f_setLabelAlignment_2750 ()) +
  gsi::Methods(_create_f_setLayout_4368 ()) +
  gsi::Methods(_create_f_setRowWrapPolicy_3021 ()) +
  gsi::Methods(_create_f_setSpacing_767 ()) +
  gsi::Methods(_create_f_setVerticalSpacing_767 ()) +
  gsi::Methods(_create_f_setWidget_4342 ()) +
  gsi::Methods(_create_f_sizeHint_c0 ()) +
  gsi::Methods(_create_f_spacing_c0 ()) +
  gsi::Methods(_create_f_takeAt_767 ()) +
  gsi::Methods(_create_f_verticalSpacing_c0 ()) +
  qt_gsi::qt_signal<QFormLayout, QFormLayout_EventAdaptor, QObject *> ("destroyed", &QFormLayout_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QFormLayout::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QFormLayout");
}


class QFormLayout_Adaptor : public QFormLayout, public qt_gsi::QtObjectBase
{
public:

  virtual ~QFormLayout_Adaptor();

  //  [adaptor ctor] QFormLayout::QFormLayout(QWidget *parent)
  QFormLayout_Adaptor() : QFormLayout()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QFormLayout::QFormLayout(QWidget *parent)
  QFormLayout_Adaptor(QWidget *parent) : QFormLayout(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QFormLayout::addChildLayout(QLayout *l)
  void fp_QFormLayout_addChildLayout_1341 (QLayout *l) {
    QFormLayout::addChildLayout(l);
  }

  //  void QFormLayout::addChildWidget(QWidget *w)
  void fp_QFormLayout_addChildWidget_1315 (QWidget *w) {
    QFormLayout::addChildWidget(w);
  }

  //  QRect QFormLayout::alignmentRect(const QRect &)
  QRect fp_QFormLayout_alignmentRect_c1792 (const QRect &arg1) const {
    return QFormLayout::alignmentRect(arg1);
  }

  //  int QFormLayout::receivers(const char *signal)
  int fp_QFormLayout_receivers_c1731 (const char *signal) const {
    return QFormLayout::receivers(signal);
  }

  //  QObject *QFormLayout::sender()
  QObject * fp_QFormLayout_sender_c0 () const {
    return QFormLayout::sender();
  }

  //  void QFormLayout::widgetEvent(QEvent *)
  void fp_QFormLayout_widgetEvent_1217 (QEvent *arg1) {
    QFormLayout::widgetEvent(arg1);
  }

  //  [adaptor impl] void QFormLayout::addItem(QLayoutItem *item)
  void cbs_addItem_1740_0(QLayoutItem *item)
  {
    QFormLayout::addItem(item);
  }

  virtual void addItem(QLayoutItem *item)
  {
    if (cb_addItem_1740_0.can_issue()) {
      cb_addItem_1740_0.issue<QFormLayout_Adaptor, QLayoutItem *>(&QFormLayout_Adaptor::cbs_addItem_1740_0, item);
    } else {
      QFormLayout::addItem(item);
    }
  }

  //  [adaptor impl] int QFormLayout::count()
  int cbs_count_c0_0() const
  {
    return QFormLayout::count();
  }

  virtual int count() const
  {
    if (cb_count_c0_0.can_issue()) {
      return cb_count_c0_0.issue<QFormLayout_Adaptor, int>(&QFormLayout_Adaptor::cbs_count_c0_0);
    } else {
      return QFormLayout::count();
    }
  }

  //  [adaptor impl] bool QFormLayout::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QFormLayout::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QFormLayout_Adaptor, bool, QEvent *>(&QFormLayout_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QFormLayout::event(arg1);
    }
  }

  //  [adaptor impl] bool QFormLayout::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QFormLayout::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QFormLayout_Adaptor, bool, QObject *, QEvent *>(&QFormLayout_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QFormLayout::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] QFlags<Qt::Orientation> QFormLayout::expandingDirections()
  qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type cbs_expandingDirections_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QFlags<Qt::Orientation> >(QFormLayout::expandingDirections());
  }

  virtual QFlags<Qt::Orientation> expandingDirections() const
  {
    if (cb_expandingDirections_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QFlags<Qt::Orientation> >(cb_expandingDirections_c0_0.issue<QFormLayout_Adaptor, qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type>(&QFormLayout_Adaptor::cbs_expandingDirections_c0_0)).cref();
    } else {
      return QFormLayout::expandingDirections();
    }
  }

  //  [adaptor impl] QRect QFormLayout::geometry()
  QRect cbs_geometry_c0_0() const
  {
    return QFormLayout::geometry();
  }

  virtual QRect geometry() const
  {
    if (cb_geometry_c0_0.can_issue()) {
      return cb_geometry_c0_0.issue<QFormLayout_Adaptor, QRect>(&QFormLayout_Adaptor::cbs_geometry_c0_0);
    } else {
      return QFormLayout::geometry();
    }
  }

  //  [adaptor impl] bool QFormLayout::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QFormLayout::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QFormLayout_Adaptor, bool>(&QFormLayout_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QFormLayout::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QFormLayout::heightForWidth(int width)
  int cbs_heightForWidth_c767_0(int width) const
  {
    return QFormLayout::heightForWidth(width);
  }

  virtual int heightForWidth(int width) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QFormLayout_Adaptor, int, int>(&QFormLayout_Adaptor::cbs_heightForWidth_c767_0, width);
    } else {
      return QFormLayout::heightForWidth(width);
    }
  }

  //  [adaptor impl] int QFormLayout::indexOf(QWidget *)
  int cbs_indexOf_c1315_0(QWidget *arg1) const
  {
    return QFormLayout::indexOf(arg1);
  }

  virtual int indexOf(QWidget *arg1) const
  {
    if (cb_indexOf_c1315_0.can_issue()) {
      return cb_indexOf_c1315_0.issue<QFormLayout_Adaptor, int, QWidget *>(&QFormLayout_Adaptor::cbs_indexOf_c1315_0, arg1);
    } else {
      return QFormLayout::indexOf(arg1);
    }
  }

  //  [adaptor impl] void QFormLayout::invalidate()
  void cbs_invalidate_0_0()
  {
    QFormLayout::invalidate();
  }

  virtual void invalidate()
  {
    if (cb_invalidate_0_0.can_issue()) {
      cb_invalidate_0_0.issue<QFormLayout_Adaptor>(&QFormLayout_Adaptor::cbs_invalidate_0_0);
    } else {
      QFormLayout::invalidate();
    }
  }

  //  [adaptor impl] bool QFormLayout::isEmpty()
  bool cbs_isEmpty_c0_0() const
  {
    return QFormLayout::isEmpty();
  }

  virtual bool isEmpty() const
  {
    if (cb_isEmpty_c0_0.can_issue()) {
      return cb_isEmpty_c0_0.issue<QFormLayout_Adaptor, bool>(&QFormLayout_Adaptor::cbs_isEmpty_c0_0);
    } else {
      return QFormLayout::isEmpty();
    }
  }

  //  [adaptor impl] QLayoutItem *QFormLayout::itemAt(int index)
  QLayoutItem * cbs_itemAt_c767_0(int index) const
  {
    return QFormLayout::itemAt(index);
  }

  virtual QLayoutItem * itemAt(int index) const
  {
    if (cb_itemAt_c767_0.can_issue()) {
      return cb_itemAt_c767_0.issue<QFormLayout_Adaptor, QLayoutItem *, int>(&QFormLayout_Adaptor::cbs_itemAt_c767_0, index);
    } else {
      return QFormLayout::itemAt(index);
    }
  }

  //  [adaptor impl] QLayout *QFormLayout::layout()
  QLayout * cbs_layout_0_0()
  {
    return QFormLayout::layout();
  }

  virtual QLayout * layout()
  {
    if (cb_layout_0_0.can_issue()) {
      return cb_layout_0_0.issue<QFormLayout_Adaptor, QLayout *>(&QFormLayout_Adaptor::cbs_layout_0_0);
    } else {
      return QFormLayout::layout();
    }
  }

  //  [adaptor impl] QSize QFormLayout::maximumSize()
  QSize cbs_maximumSize_c0_0() const
  {
    return QFormLayout::maximumSize();
  }

  virtual QSize maximumSize() const
  {
    if (cb_maximumSize_c0_0.can_issue()) {
      return cb_maximumSize_c0_0.issue<QFormLayout_Adaptor, QSize>(&QFormLayout_Adaptor::cbs_maximumSize_c0_0);
    } else {
      return QFormLayout::maximumSize();
    }
  }

  //  [adaptor impl] int QFormLayout::minimumHeightForWidth(int)
  int cbs_minimumHeightForWidth_c767_0(int arg1) const
  {
    return QFormLayout::minimumHeightForWidth(arg1);
  }

  virtual int minimumHeightForWidth(int arg1) const
  {
    if (cb_minimumHeightForWidth_c767_0.can_issue()) {
      return cb_minimumHeightForWidth_c767_0.issue<QFormLayout_Adaptor, int, int>(&QFormLayout_Adaptor::cbs_minimumHeightForWidth_c767_0, arg1);
    } else {
      return QFormLayout::minimumHeightForWidth(arg1);
    }
  }

  //  [adaptor impl] QSize QFormLayout::minimumSize()
  QSize cbs_minimumSize_c0_0() const
  {
    return QFormLayout::minimumSize();
  }

  virtual QSize minimumSize() const
  {
    if (cb_minimumSize_c0_0.can_issue()) {
      return cb_minimumSize_c0_0.issue<QFormLayout_Adaptor, QSize>(&QFormLayout_Adaptor::cbs_minimumSize_c0_0);
    } else {
      return QFormLayout::minimumSize();
    }
  }

  //  [adaptor impl] void QFormLayout::setGeometry(const QRect &rect)
  void cbs_setGeometry_1792_0(const QRect &rect)
  {
    QFormLayout::setGeometry(rect);
  }

  virtual void setGeometry(const QRect &rect)
  {
    if (cb_setGeometry_1792_0.can_issue()) {
      cb_setGeometry_1792_0.issue<QFormLayout_Adaptor, const QRect &>(&QFormLayout_Adaptor::cbs_setGeometry_1792_0, rect);
    } else {
      QFormLayout::setGeometry(rect);
    }
  }

  //  [adaptor impl] QSize QFormLayout::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QFormLayout::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QFormLayout_Adaptor, QSize>(&QFormLayout_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QFormLayout::sizeHint();
    }
  }

  //  [adaptor impl] QSpacerItem *QFormLayout::spacerItem()
  QSpacerItem * cbs_spacerItem_0_0()
  {
    return QFormLayout::spacerItem();
  }

  virtual QSpacerItem * spacerItem()
  {
    if (cb_spacerItem_0_0.can_issue()) {
      return cb_spacerItem_0_0.issue<QFormLayout_Adaptor, QSpacerItem *>(&QFormLayout_Adaptor::cbs_spacerItem_0_0);
    } else {
      return QFormLayout::spacerItem();
    }
  }

  //  [adaptor impl] QLayoutItem *QFormLayout::takeAt(int index)
  QLayoutItem * cbs_takeAt_767_0(int index)
  {
    return QFormLayout::takeAt(index);
  }

  virtual QLayoutItem * takeAt(int index)
  {
    if (cb_takeAt_767_0.can_issue()) {
      return cb_takeAt_767_0.issue<QFormLayout_Adaptor, QLayoutItem *, int>(&QFormLayout_Adaptor::cbs_takeAt_767_0, index);
    } else {
      return QFormLayout::takeAt(index);
    }
  }

  //  [adaptor impl] QWidget *QFormLayout::widget()
  QWidget * cbs_widget_0_0()
  {
    return QFormLayout::widget();
  }

  virtual QWidget * widget()
  {
    if (cb_widget_0_0.can_issue()) {
      return cb_widget_0_0.issue<QFormLayout_Adaptor, QWidget *>(&QFormLayout_Adaptor::cbs_widget_0_0);
    } else {
      return QFormLayout::widget();
    }
  }

  //  [adaptor impl] void QFormLayout::childEvent(QChildEvent *e)
  void cbs_childEvent_1701_0(QChildEvent *e)
  {
    QFormLayout::childEvent(e);
  }

  virtual void childEvent(QChildEvent *e)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QFormLayout_Adaptor, QChildEvent *>(&QFormLayout_Adaptor::cbs_childEvent_1701_0, e);
    } else {
      QFormLayout::childEvent(e);
    }
  }

  //  [adaptor impl] void QFormLayout::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QFormLayout::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QFormLayout_Adaptor, QEvent *>(&QFormLayout_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QFormLayout::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QFormLayout::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QFormLayout::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QFormLayout_Adaptor, const char *>(&QFormLayout_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QFormLayout::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QFormLayout::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QFormLayout::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QFormLayout_Adaptor, QTimerEvent *>(&QFormLayout_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QFormLayout::timerEvent(arg1);
    }
  }

  gsi::Callback cb_addItem_1740_0;
  gsi::Callback cb_count_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_expandingDirections_c0_0;
  gsi::Callback cb_geometry_c0_0;
  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_indexOf_c1315_0;
  gsi::Callback cb_invalidate_0_0;
  gsi::Callback cb_isEmpty_c0_0;
  gsi::Callback cb_itemAt_c767_0;
  gsi::Callback cb_layout_0_0;
  gsi::Callback cb_maximumSize_c0_0;
  gsi::Callback cb_minimumHeightForWidth_c767_0;
  gsi::Callback cb_minimumSize_c0_0;
  gsi::Callback cb_setGeometry_1792_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_spacerItem_0_0;
  gsi::Callback cb_takeAt_767_0;
  gsi::Callback cb_widget_0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QFormLayout_Adaptor::~QFormLayout_Adaptor() { }

//  Constructor QFormLayout::QFormLayout(QWidget *parent) (adaptor class)

static void _init_ctor_QFormLayout_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QFormLayout_Adaptor *> ();
}

static void _call_ctor_QFormLayout_Adaptor_1315 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QFormLayout_Adaptor *> (new QFormLayout_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QFormLayout_Adaptor_1315 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFormLayout::QFormLayout(QWidget *parent)\nThis method creates an object of class QFormLayout.", &_init_ctor_QFormLayout_Adaptor_1315, &_call_ctor_QFormLayout_Adaptor_1315);
}

// void QFormLayout::addChildLayout(QLayout *l)

static void _init_fp_addChildLayout_1341 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("l");
  decl->add_arg<QLayout * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addChildLayout_1341 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLayout *arg1 = args.read<QLayout * > ();
  qt_gsi::qt_keep (arg1);
  ((QFormLayout_Adaptor *)cls)->fp_QFormLayout_addChildLayout_1341 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_addChildLayout_1341 ()
{
  return new qt_gsi::GenericMethod("*addChildLayout", "@brief Method void QFormLayout::addChildLayout(QLayout *l)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addChildLayout_1341, &_call_fp_addChildLayout_1341);
}


// void QFormLayout::addChildWidget(QWidget *w)

static void _init_fp_addChildWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addChildWidget_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QFormLayout_Adaptor *)cls)->fp_QFormLayout_addChildWidget_1315 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_addChildWidget_1315 ()
{
  return new qt_gsi::GenericMethod("*addChildWidget", "@brief Method void QFormLayout::addChildWidget(QWidget *w)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addChildWidget_1315, &_call_fp_addChildWidget_1315);
}


// QRect QFormLayout::alignmentRect(const QRect &)

static void _init_fp_alignmentRect_c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_fp_alignmentRect_c1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ret.write<QRect > ((QRect)((QFormLayout_Adaptor *)cls)->fp_QFormLayout_alignmentRect_c1792 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_alignmentRect_c1792 ()
{
  return new qt_gsi::GenericMethod("*alignmentRect", "@brief Method QRect QFormLayout::alignmentRect(const QRect &)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_alignmentRect_c1792, &_call_fp_alignmentRect_c1792);
}


// int QFormLayout::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QFormLayout_Adaptor *)cls)->fp_QFormLayout_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QFormLayout::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QFormLayout::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QFormLayout_Adaptor *)cls)->fp_QFormLayout_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QFormLayout::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QFormLayout::widgetEvent(QEvent *)

static void _init_fp_widgetEvent_1217 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_widgetEvent_1217 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QFormLayout_Adaptor *)cls)->fp_QFormLayout_widgetEvent_1217 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_widgetEvent_1217 ()
{
  return new qt_gsi::GenericMethod("*widgetEvent", "@brief Method void QFormLayout::widgetEvent(QEvent *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_widgetEvent_1217, &_call_fp_widgetEvent_1217);
}


// void QFormLayout::addItem(QLayoutItem *item)

static void _init_cbs_addItem_1740_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QLayoutItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_addItem_1740_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLayoutItem *arg1 = args.read<QLayoutItem * > ();
  ((QFormLayout_Adaptor *)cls)->cbs_addItem_1740_0 (arg1);
}

static void _set_callback_cbs_addItem_1740_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_addItem_1740_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_addItem_1740_0 ()
{
  return new qt_gsi::GenericMethod ("addItem", "@hide", false, &_init_cbs_addItem_1740_0, &_call_cbs_addItem_1740_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_addItem_1740_0 ()
{
  return new qt_gsi::GenericMethod ("addItem", "@brief Virtual method void QFormLayout::addItem(QLayoutItem *item)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_addItem_1740_0, &_call_cbs_addItem_1740_0, &_set_callback_cbs_addItem_1740_0);
}


// int QFormLayout::count()

static void _init_cbs_count_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_count_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QFormLayout_Adaptor *)cls)->cbs_count_c0_0 ());
}

static void _set_callback_cbs_count_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_count_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_count_c0_0 ()
{
  return new qt_gsi::GenericMethod ("count", "@hide", true, &_init_cbs_count_c0_0, &_call_cbs_count_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_count_c0_0 ()
{
  return new qt_gsi::GenericMethod ("count", "@brief Virtual method int QFormLayout::count()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_count_c0_0, &_call_cbs_count_c0_0, &_set_callback_cbs_count_c0_0);
}


// bool QFormLayout::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QFormLayout_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QFormLayout::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QFormLayout::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QFormLayout_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QFormLayout::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// QFlags<Qt::Orientation> QFormLayout::expandingDirections()

static void _init_cbs_expandingDirections_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type > ();
}

static void _call_cbs_expandingDirections_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type > ((qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type)((QFormLayout_Adaptor *)cls)->cbs_expandingDirections_c0_0 ());
}

static void _set_callback_cbs_expandingDirections_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_expandingDirections_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_expandingDirections_c0_0 ()
{
  return new qt_gsi::GenericMethod ("expandingDirections", "@hide", true, &_init_cbs_expandingDirections_c0_0, &_call_cbs_expandingDirections_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_expandingDirections_c0_0 ()
{
  return new qt_gsi::GenericMethod ("expandingDirections", "@brief Virtual method QFlags<Qt::Orientation> QFormLayout::expandingDirections()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_expandingDirections_c0_0, &_call_cbs_expandingDirections_c0_0, &_set_callback_cbs_expandingDirections_c0_0);
}


// QRect QFormLayout::geometry()

static void _init_cbs_geometry_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_cbs_geometry_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QFormLayout_Adaptor *)cls)->cbs_geometry_c0_0 ());
}

static void _set_callback_cbs_geometry_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_geometry_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_geometry_c0_0 ()
{
  return new qt_gsi::GenericMethod ("geometry", "@hide", true, &_init_cbs_geometry_c0_0, &_call_cbs_geometry_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_geometry_c0_0 ()
{
  return new qt_gsi::GenericMethod ("geometry", "@brief Virtual method QRect QFormLayout::geometry()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_geometry_c0_0, &_call_cbs_geometry_c0_0, &_set_callback_cbs_geometry_c0_0);
}


// bool QFormLayout::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFormLayout_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hasHeightForWidth_c0_0 ()
{
  return new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hasHeightForWidth_c0_0 ()
{
  return new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QFormLayout::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
}


// int QFormLayout::heightForWidth(int width)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QFormLayout_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QFormLayout::heightForWidth(int width)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// int QFormLayout::indexOf(QWidget *)

static void _init_cbs_indexOf_c1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_indexOf_c1315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ret.write<int > ((int)((QFormLayout_Adaptor *)cls)->cbs_indexOf_c1315_0 (arg1));
}

static void _set_callback_cbs_indexOf_c1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_indexOf_c1315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_indexOf_c1315_0 ()
{
  return new qt_gsi::GenericMethod ("indexOf", "@hide", true, &_init_cbs_indexOf_c1315_0, &_call_cbs_indexOf_c1315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_indexOf_c1315_0 ()
{
  return new qt_gsi::GenericMethod ("indexOf", "@brief Virtual method int QFormLayout::indexOf(QWidget *)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_indexOf_c1315_0, &_call_cbs_indexOf_c1315_0, &_set_callback_cbs_indexOf_c1315_0);
}


// void QFormLayout::invalidate()

static void _init_cbs_invalidate_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_invalidate_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFormLayout_Adaptor *)cls)->cbs_invalidate_0_0 ();
}

static void _set_callback_cbs_invalidate_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_invalidate_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_invalidate_0_0 ()
{
  return new qt_gsi::GenericMethod ("invalidate", "@hide", false, &_init_cbs_invalidate_0_0, &_call_cbs_invalidate_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_invalidate_0_0 ()
{
  return new qt_gsi::GenericMethod ("invalidate", "@brief Virtual method void QFormLayout::invalidate()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_invalidate_0_0, &_call_cbs_invalidate_0_0, &_set_callback_cbs_invalidate_0_0);
}


// bool QFormLayout::isEmpty()

static void _init_cbs_isEmpty_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isEmpty_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFormLayout_Adaptor *)cls)->cbs_isEmpty_c0_0 ());
}

static void _set_callback_cbs_isEmpty_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_isEmpty_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_isEmpty_c0_0 ()
{
  return new qt_gsi::GenericMethod ("isEmpty", "@hide", true, &_init_cbs_isEmpty_c0_0, &_call_cbs_isEmpty_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_isEmpty_c0_0 ()
{
  return new qt_gsi::GenericMethod ("isEmpty", "@brief Virtual method bool QFormLayout::isEmpty()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isEmpty_c0_0, &_call_cbs_isEmpty_c0_0, &_set_callback_cbs_isEmpty_c0_0);
}


// QLayoutItem *QFormLayout::itemAt(int index)

static void _init_cbs_itemAt_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_cbs_itemAt_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QLayoutItem * > ((QLayoutItem *)((QFormLayout_Adaptor *)cls)->cbs_itemAt_c767_0 (arg1));
}

static void _set_callback_cbs_itemAt_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_itemAt_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_itemAt_c767_0 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@hide", true, &_init_cbs_itemAt_c767_0, &_call_cbs_itemAt_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_itemAt_c767_0 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@brief Virtual method QLayoutItem *QFormLayout::itemAt(int index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemAt_c767_0, &_call_cbs_itemAt_c767_0, &_set_callback_cbs_itemAt_c767_0);
}


// QLayout *QFormLayout::layout()

static void _init_cbs_layout_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLayout * > ();
}

static void _call_cbs_layout_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QLayout * > ((QLayout *)((QFormLayout_Adaptor *)cls)->cbs_layout_0_0 ());
}

static void _set_callback_cbs_layout_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_layout_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_layout_0_0 ()
{
  return new qt_gsi::GenericMethod ("layout", "@hide", false, &_init_cbs_layout_0_0, &_call_cbs_layout_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_layout_0_0 ()
{
  return new qt_gsi::GenericMethod ("layout", "@brief Virtual method QLayout *QFormLayout::layout()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_layout_0_0, &_call_cbs_layout_0_0, &_set_callback_cbs_layout_0_0);
}


// QSize QFormLayout::maximumSize()

static void _init_cbs_maximumSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_maximumSize_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QFormLayout_Adaptor *)cls)->cbs_maximumSize_c0_0 ());
}

static void _set_callback_cbs_maximumSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_maximumSize_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_maximumSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("maximumSize", "@hide", true, &_init_cbs_maximumSize_c0_0, &_call_cbs_maximumSize_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_maximumSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("maximumSize", "@brief Virtual method QSize QFormLayout::maximumSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_maximumSize_c0_0, &_call_cbs_maximumSize_c0_0, &_set_callback_cbs_maximumSize_c0_0);
}


// int QFormLayout::minimumHeightForWidth(int)

static void _init_cbs_minimumHeightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_minimumHeightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QFormLayout_Adaptor *)cls)->cbs_minimumHeightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_minimumHeightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_minimumHeightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumHeightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("minimumHeightForWidth", "@hide", true, &_init_cbs_minimumHeightForWidth_c767_0, &_call_cbs_minimumHeightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumHeightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("minimumHeightForWidth", "@brief Virtual method int QFormLayout::minimumHeightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumHeightForWidth_c767_0, &_call_cbs_minimumHeightForWidth_c767_0, &_set_callback_cbs_minimumHeightForWidth_c767_0);
}


// QSize QFormLayout::minimumSize()

static void _init_cbs_minimumSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSize_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QFormLayout_Adaptor *)cls)->cbs_minimumSize_c0_0 ());
}

static void _set_callback_cbs_minimumSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_minimumSize_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSize", "@hide", true, &_init_cbs_minimumSize_c0_0, &_call_cbs_minimumSize_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSize", "@brief Virtual method QSize QFormLayout::minimumSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSize_c0_0, &_call_cbs_minimumSize_c0_0, &_set_callback_cbs_minimumSize_c0_0);
}


// void QFormLayout::setGeometry(const QRect &rect)

static void _init_cbs_setGeometry_1792_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setGeometry_1792_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ((QFormLayout_Adaptor *)cls)->cbs_setGeometry_1792_0 (arg1);
}

static void _set_callback_cbs_setGeometry_1792_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_setGeometry_1792_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setGeometry_1792_0 ()
{
  return new qt_gsi::GenericMethod ("setGeometry", "@hide", false, &_init_cbs_setGeometry_1792_0, &_call_cbs_setGeometry_1792_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setGeometry_1792_0 ()
{
  return new qt_gsi::GenericMethod ("setGeometry", "@brief Virtual method void QFormLayout::setGeometry(const QRect &rect)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setGeometry_1792_0, &_call_cbs_setGeometry_1792_0, &_set_callback_cbs_setGeometry_1792_0);
}


// QSize QFormLayout::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QFormLayout_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QFormLayout::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// QSpacerItem *QFormLayout::spacerItem()

static void _init_cbs_spacerItem_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSpacerItem * > ();
}

static void _call_cbs_spacerItem_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSpacerItem * > ((QSpacerItem *)((QFormLayout_Adaptor *)cls)->cbs_spacerItem_0_0 ());
}

static void _set_callback_cbs_spacerItem_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_spacerItem_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_spacerItem_0_0 ()
{
  return new qt_gsi::GenericMethod ("spacerItem", "@hide", false, &_init_cbs_spacerItem_0_0, &_call_cbs_spacerItem_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_spacerItem_0_0 ()
{
  return new qt_gsi::GenericMethod ("spacerItem", "@brief Virtual method QSpacerItem *QFormLayout::spacerItem()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_spacerItem_0_0, &_call_cbs_spacerItem_0_0, &_set_callback_cbs_spacerItem_0_0);
}


// QLayoutItem *QFormLayout::takeAt(int index)

static void _init_cbs_takeAt_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_cbs_takeAt_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QLayoutItem * > ((QLayoutItem *)((QFormLayout_Adaptor *)cls)->cbs_takeAt_767_0 (arg1));
}

static void _set_callback_cbs_takeAt_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_takeAt_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_takeAt_767_0 ()
{
  return new qt_gsi::GenericMethod ("takeAt", "@hide", false, &_init_cbs_takeAt_767_0, &_call_cbs_takeAt_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_takeAt_767_0 ()
{
  return new qt_gsi::GenericMethod ("takeAt", "@brief Virtual method QLayoutItem *QFormLayout::takeAt(int index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_takeAt_767_0, &_call_cbs_takeAt_767_0, &_set_callback_cbs_takeAt_767_0);
}


// QWidget *QFormLayout::widget()

static void _init_cbs_widget_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_cbs_widget_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)((QFormLayout_Adaptor *)cls)->cbs_widget_0_0 ());
}

static void _set_callback_cbs_widget_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_widget_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_widget_0_0 ()
{
  return new qt_gsi::GenericMethod ("widget", "@hide", false, &_init_cbs_widget_0_0, &_call_cbs_widget_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_widget_0_0 ()
{
  return new qt_gsi::GenericMethod ("widget", "@brief Virtual method QWidget *QFormLayout::widget()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_widget_0_0, &_call_cbs_widget_0_0, &_set_callback_cbs_widget_0_0);
}


// void QFormLayout::childEvent(QChildEvent *e)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QFormLayout_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QFormLayout::childEvent(QChildEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QFormLayout::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QFormLayout_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QFormLayout::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QFormLayout::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QFormLayout_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QFormLayout::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QFormLayout::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QFormLayout_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QFormLayout::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QFormLayout> decl_QFormLayout;

gsi::Class<QFormLayout_Adaptor> decl_QFormLayout_Adaptor (decl_QFormLayout, "QFormLayout",
  gsi::Methods(_create_fp_addChildLayout_1341 ()) +
  gsi::Methods(_create_fp_addChildWidget_1315 ()) +
  gsi::Methods(_create_fp_alignmentRect_c1792 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_widgetEvent_1217 ()) +
  gsi::Methods(_create_cbs_addItem_1740_0 ()) +
  gsi::Methods(_create_callback_cbs_addItem_1740_0 ()) +
  gsi::Methods(_create_cbs_count_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_count_c0_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_expandingDirections_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_expandingDirections_c0_0 ()) +
  gsi::Methods(_create_cbs_geometry_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_geometry_c0_0 ()) +
  gsi::Methods(_create_cbs_hasHeightForWidth_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_hasHeightForWidth_c0_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_indexOf_c1315_0 ()) +
  gsi::Methods(_create_callback_cbs_indexOf_c1315_0 ()) +
  gsi::Methods(_create_cbs_invalidate_0_0 ()) +
  gsi::Methods(_create_callback_cbs_invalidate_0_0 ()) +
  gsi::Methods(_create_cbs_isEmpty_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_isEmpty_c0_0 ()) +
  gsi::Methods(_create_cbs_itemAt_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_itemAt_c767_0 ()) +
  gsi::Methods(_create_cbs_layout_0_0 ()) +
  gsi::Methods(_create_callback_cbs_layout_0_0 ()) +
  gsi::Methods(_create_cbs_maximumSize_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_maximumSize_c0_0 ()) +
  gsi::Methods(_create_cbs_minimumHeightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumHeightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_minimumSize_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSize_c0_0 ()) +
  gsi::Methods(_create_cbs_setGeometry_1792_0 ()) +
  gsi::Methods(_create_callback_cbs_setGeometry_1792_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_spacerItem_0_0 ()) +
  gsi::Methods(_create_callback_cbs_spacerItem_0_0 ()) +
  gsi::Methods(_create_cbs_takeAt_767_0 ()) +
  gsi::Methods(_create_callback_cbs_takeAt_767_0 ()) +
  gsi::Methods(_create_cbs_widget_0_0 ()) +
  gsi::Methods(_create_callback_cbs_widget_0_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QFormLayout_Adaptor_1315 ()),
  "@qt\n@brief Binding of QFormLayout");

}


//  Implementation of the enum wrapper class for QFormLayout::FieldGrowthPolicy
namespace qt_gsi
{

static QFormLayout_FieldGrowthPolicy_Enum *c_1_QFormLayout_FieldGrowthPolicy_Enum () { return new QFormLayout_FieldGrowthPolicy_Enum (QFormLayout::FieldsStayAtSizeHint); }
static QFormLayout_FieldGrowthPolicy_Enum *c_2_QFormLayout_FieldGrowthPolicy_Enum () { return new QFormLayout_FieldGrowthPolicy_Enum (QFormLayout::ExpandingFieldsGrow); }
static QFormLayout_FieldGrowthPolicy_Enum *c_3_QFormLayout_FieldGrowthPolicy_Enum () { return new QFormLayout_FieldGrowthPolicy_Enum (QFormLayout::AllNonFixedFieldsGrow); }

static gsi::Methods mkdefs_QFormLayout_FieldGrowthPolicy () {
  return
    gsi::constant ("FieldsStayAtSizeHint", &qt_gsi::c_1_QFormLayout_FieldGrowthPolicy_Enum, "@brief Enum constant QFormLayout::FieldsStayAtSizeHint") +
    gsi::constant ("ExpandingFieldsGrow", &qt_gsi::c_2_QFormLayout_FieldGrowthPolicy_Enum, "@brief Enum constant QFormLayout::ExpandingFieldsGrow") +
    gsi::constant ("AllNonFixedFieldsGrow", &qt_gsi::c_3_QFormLayout_FieldGrowthPolicy_Enum, "@brief Enum constant QFormLayout::AllNonFixedFieldsGrow");
}

static std::string to_s_QFormLayout_FieldGrowthPolicy_Enum (const QFormLayout_FieldGrowthPolicy_Enum *e)
{
  if (e->value () == QFormLayout::FieldsStayAtSizeHint) { return tl::sprintf ("FieldsStayAtSizeHint (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFormLayout::ExpandingFieldsGrow) { return tl::sprintf ("ExpandingFieldsGrow (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFormLayout::AllNonFixedFieldsGrow) { return tl::sprintf ("AllNonFixedFieldsGrow (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QFormLayout_FieldGrowthPolicy_Enum (const QFormLayout_FieldGrowthPolicy_Enum *e)
{
  return (unsigned int) e->value ();
}

static QFormLayout_FieldGrowthPolicy_Enum *from_i_QFormLayout_FieldGrowthPolicy_Enum (unsigned int i)
{
  return new QFormLayout_FieldGrowthPolicy_Enum ((QFormLayout::FieldGrowthPolicy) i);
}

static bool equalQFormLayout_FieldGrowthPolicy_Enum (const QFormLayout_FieldGrowthPolicy_Enum *e, QFormLayout_FieldGrowthPolicy_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QFormLayout_FieldGrowthPolicy_Enum (const QFormLayout_FieldGrowthPolicy_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QFormLayout_FieldGrowthPolicy_Enums oropQFormLayout_FieldGrowthPolicy_Enums (const QFormLayout_FieldGrowthPolicy_Enums *e, const QFormLayout_FieldGrowthPolicy_Enums &d)
{
  return e->flags () | d.flags ();
}

static QFormLayout_FieldGrowthPolicy_Enums andopQFormLayout_FieldGrowthPolicy_Enums (const QFormLayout_FieldGrowthPolicy_Enums *e, const QFormLayout_FieldGrowthPolicy_Enums &d)
{
  return e->flags () & d.flags ();
}

static QFormLayout_FieldGrowthPolicy_Enums xoropQFormLayout_FieldGrowthPolicy_Enums (const QFormLayout_FieldGrowthPolicy_Enums *e, const QFormLayout_FieldGrowthPolicy_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QFormLayout_FieldGrowthPolicy_Enums (const QFormLayout_FieldGrowthPolicy_Enums *e)
{
  std::string l;
  if (e->testFlag (QFormLayout::FieldsStayAtSizeHint)) { if (!l.empty ()) l += "|"; l += "FieldsStayAtSizeHint"; }
  if (e->testFlag (QFormLayout::ExpandingFieldsGrow)) { if (!l.empty ()) l += "|"; l += "ExpandingFieldsGrow"; }
  if (e->testFlag (QFormLayout::AllNonFixedFieldsGrow)) { if (!l.empty ()) l += "|"; l += "AllNonFixedFieldsGrow"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QFormLayout_FieldGrowthPolicy_Enums (const QFormLayout_FieldGrowthPolicy_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QFormLayout_FieldGrowthPolicy_Enums (const QFormLayout_FieldGrowthPolicy_Enums *e, const QFormLayout_FieldGrowthPolicy_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QFormLayout_FieldGrowthPolicy_Enums> decl_QFormLayout_FieldGrowthPolicy_Enums ("QFormLayout_QFlags_FieldGrowthPolicy",
  gsi::method_ext ("|", &qt_gsi::oropQFormLayout_FieldGrowthPolicy_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQFormLayout_FieldGrowthPolicy_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQFormLayout_FieldGrowthPolicy_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFormLayout_FieldGrowthPolicy_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFormLayout_FieldGrowthPolicy_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QFormLayout_FieldGrowthPolicy_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QFormLayout::FieldGrowthPolicy> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QFormLayout_FieldGrowthPolicy_Enum> decl_QFormLayout_FieldGrowthPolicy_Enum (decl_QFormLayout_FieldGrowthPolicy_Enums, "QFormLayout_FieldGrowthPolicy",
  qt_gsi::mkdefs_QFormLayout_FieldGrowthPolicy () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFormLayout_FieldGrowthPolicy_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFormLayout_FieldGrowthPolicy_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQFormLayout_FieldGrowthPolicy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QFormLayout_FieldGrowthPolicy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QFormLayout_FieldGrowthPolicy_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QFormLayout::FieldGrowthPolicy enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QFormLayout> inject_QFormLayout_FieldGrowthPolicy_Enum_in_parent (qt_gsi::mkdefs_QFormLayout_FieldGrowthPolicy ());
static gsi::ClassExt<QFormLayout> decl_QFormLayout_FieldGrowthPolicy_Enum_as_child (decl_QFormLayout_FieldGrowthPolicy_Enum, "FieldGrowthPolicy");

}


//  Implementation of the enum wrapper class for QFormLayout::ItemRole
namespace qt_gsi
{

static QFormLayout_ItemRole_Enum *c_1_QFormLayout_ItemRole_Enum () { return new QFormLayout_ItemRole_Enum (QFormLayout::LabelRole); }
static QFormLayout_ItemRole_Enum *c_2_QFormLayout_ItemRole_Enum () { return new QFormLayout_ItemRole_Enum (QFormLayout::FieldRole); }
static QFormLayout_ItemRole_Enum *c_3_QFormLayout_ItemRole_Enum () { return new QFormLayout_ItemRole_Enum (QFormLayout::SpanningRole); }

static gsi::Methods mkdefs_QFormLayout_ItemRole () {
  return
    gsi::constant ("LabelRole", &qt_gsi::c_1_QFormLayout_ItemRole_Enum, "@brief Enum constant QFormLayout::LabelRole") +
    gsi::constant ("FieldRole", &qt_gsi::c_2_QFormLayout_ItemRole_Enum, "@brief Enum constant QFormLayout::FieldRole") +
    gsi::constant ("SpanningRole", &qt_gsi::c_3_QFormLayout_ItemRole_Enum, "@brief Enum constant QFormLayout::SpanningRole");
}

static std::string to_s_QFormLayout_ItemRole_Enum (const QFormLayout_ItemRole_Enum *e)
{
  if (e->value () == QFormLayout::LabelRole) { return tl::sprintf ("LabelRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFormLayout::FieldRole) { return tl::sprintf ("FieldRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFormLayout::SpanningRole) { return tl::sprintf ("SpanningRole (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QFormLayout_ItemRole_Enum (const QFormLayout_ItemRole_Enum *e)
{
  return (unsigned int) e->value ();
}

static QFormLayout_ItemRole_Enum *from_i_QFormLayout_ItemRole_Enum (unsigned int i)
{
  return new QFormLayout_ItemRole_Enum ((QFormLayout::ItemRole) i);
}

static bool equalQFormLayout_ItemRole_Enum (const QFormLayout_ItemRole_Enum *e, QFormLayout_ItemRole_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QFormLayout_ItemRole_Enum (const QFormLayout_ItemRole_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QFormLayout_ItemRole_Enums oropQFormLayout_ItemRole_Enums (const QFormLayout_ItemRole_Enums *e, const QFormLayout_ItemRole_Enums &d)
{
  return e->flags () | d.flags ();
}

static QFormLayout_ItemRole_Enums andopQFormLayout_ItemRole_Enums (const QFormLayout_ItemRole_Enums *e, const QFormLayout_ItemRole_Enums &d)
{
  return e->flags () & d.flags ();
}

static QFormLayout_ItemRole_Enums xoropQFormLayout_ItemRole_Enums (const QFormLayout_ItemRole_Enums *e, const QFormLayout_ItemRole_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QFormLayout_ItemRole_Enums (const QFormLayout_ItemRole_Enums *e)
{
  std::string l;
  if (e->testFlag (QFormLayout::LabelRole)) { if (!l.empty ()) l += "|"; l += "LabelRole"; }
  if (e->testFlag (QFormLayout::FieldRole)) { if (!l.empty ()) l += "|"; l += "FieldRole"; }
  if (e->testFlag (QFormLayout::SpanningRole)) { if (!l.empty ()) l += "|"; l += "SpanningRole"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QFormLayout_ItemRole_Enums (const QFormLayout_ItemRole_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QFormLayout_ItemRole_Enums (const QFormLayout_ItemRole_Enums *e, const QFormLayout_ItemRole_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QFormLayout_ItemRole_Enums> decl_QFormLayout_ItemRole_Enums ("QFormLayout_QFlags_ItemRole",
  gsi::method_ext ("|", &qt_gsi::oropQFormLayout_ItemRole_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQFormLayout_ItemRole_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQFormLayout_ItemRole_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFormLayout_ItemRole_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFormLayout_ItemRole_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QFormLayout_ItemRole_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QFormLayout::ItemRole> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QFormLayout_ItemRole_Enum> decl_QFormLayout_ItemRole_Enum (decl_QFormLayout_ItemRole_Enums, "QFormLayout_ItemRole",
  qt_gsi::mkdefs_QFormLayout_ItemRole () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFormLayout_ItemRole_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFormLayout_ItemRole_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQFormLayout_ItemRole_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QFormLayout_ItemRole_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QFormLayout_ItemRole_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QFormLayout::ItemRole enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QFormLayout> inject_QFormLayout_ItemRole_Enum_in_parent (qt_gsi::mkdefs_QFormLayout_ItemRole ());
static gsi::ClassExt<QFormLayout> decl_QFormLayout_ItemRole_Enum_as_child (decl_QFormLayout_ItemRole_Enum, "ItemRole");

}


//  Implementation of the enum wrapper class for QFormLayout::RowWrapPolicy
namespace qt_gsi
{

static QFormLayout_RowWrapPolicy_Enum *c_1_QFormLayout_RowWrapPolicy_Enum () { return new QFormLayout_RowWrapPolicy_Enum (QFormLayout::DontWrapRows); }
static QFormLayout_RowWrapPolicy_Enum *c_2_QFormLayout_RowWrapPolicy_Enum () { return new QFormLayout_RowWrapPolicy_Enum (QFormLayout::WrapLongRows); }
static QFormLayout_RowWrapPolicy_Enum *c_3_QFormLayout_RowWrapPolicy_Enum () { return new QFormLayout_RowWrapPolicy_Enum (QFormLayout::WrapAllRows); }

static gsi::Methods mkdefs_QFormLayout_RowWrapPolicy () {
  return
    gsi::constant ("DontWrapRows", &qt_gsi::c_1_QFormLayout_RowWrapPolicy_Enum, "@brief Enum constant QFormLayout::DontWrapRows") +
    gsi::constant ("WrapLongRows", &qt_gsi::c_2_QFormLayout_RowWrapPolicy_Enum, "@brief Enum constant QFormLayout::WrapLongRows") +
    gsi::constant ("WrapAllRows", &qt_gsi::c_3_QFormLayout_RowWrapPolicy_Enum, "@brief Enum constant QFormLayout::WrapAllRows");
}

static std::string to_s_QFormLayout_RowWrapPolicy_Enum (const QFormLayout_RowWrapPolicy_Enum *e)
{
  if (e->value () == QFormLayout::DontWrapRows) { return tl::sprintf ("DontWrapRows (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFormLayout::WrapLongRows) { return tl::sprintf ("WrapLongRows (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFormLayout::WrapAllRows) { return tl::sprintf ("WrapAllRows (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QFormLayout_RowWrapPolicy_Enum (const QFormLayout_RowWrapPolicy_Enum *e)
{
  return (unsigned int) e->value ();
}

static QFormLayout_RowWrapPolicy_Enum *from_i_QFormLayout_RowWrapPolicy_Enum (unsigned int i)
{
  return new QFormLayout_RowWrapPolicy_Enum ((QFormLayout::RowWrapPolicy) i);
}

static bool equalQFormLayout_RowWrapPolicy_Enum (const QFormLayout_RowWrapPolicy_Enum *e, QFormLayout_RowWrapPolicy_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QFormLayout_RowWrapPolicy_Enum (const QFormLayout_RowWrapPolicy_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QFormLayout_RowWrapPolicy_Enums oropQFormLayout_RowWrapPolicy_Enums (const QFormLayout_RowWrapPolicy_Enums *e, const QFormLayout_RowWrapPolicy_Enums &d)
{
  return e->flags () | d.flags ();
}

static QFormLayout_RowWrapPolicy_Enums andopQFormLayout_RowWrapPolicy_Enums (const QFormLayout_RowWrapPolicy_Enums *e, const QFormLayout_RowWrapPolicy_Enums &d)
{
  return e->flags () & d.flags ();
}

static QFormLayout_RowWrapPolicy_Enums xoropQFormLayout_RowWrapPolicy_Enums (const QFormLayout_RowWrapPolicy_Enums *e, const QFormLayout_RowWrapPolicy_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QFormLayout_RowWrapPolicy_Enums (const QFormLayout_RowWrapPolicy_Enums *e)
{
  std::string l;
  if (e->testFlag (QFormLayout::DontWrapRows)) { if (!l.empty ()) l += "|"; l += "DontWrapRows"; }
  if (e->testFlag (QFormLayout::WrapLongRows)) { if (!l.empty ()) l += "|"; l += "WrapLongRows"; }
  if (e->testFlag (QFormLayout::WrapAllRows)) { if (!l.empty ()) l += "|"; l += "WrapAllRows"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QFormLayout_RowWrapPolicy_Enums (const QFormLayout_RowWrapPolicy_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QFormLayout_RowWrapPolicy_Enums (const QFormLayout_RowWrapPolicy_Enums *e, const QFormLayout_RowWrapPolicy_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QFormLayout_RowWrapPolicy_Enums> decl_QFormLayout_RowWrapPolicy_Enums ("QFormLayout_QFlags_RowWrapPolicy",
  gsi::method_ext ("|", &qt_gsi::oropQFormLayout_RowWrapPolicy_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQFormLayout_RowWrapPolicy_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQFormLayout_RowWrapPolicy_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFormLayout_RowWrapPolicy_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFormLayout_RowWrapPolicy_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QFormLayout_RowWrapPolicy_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QFormLayout::RowWrapPolicy> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QFormLayout_RowWrapPolicy_Enum> decl_QFormLayout_RowWrapPolicy_Enum (decl_QFormLayout_RowWrapPolicy_Enums, "QFormLayout_RowWrapPolicy",
  qt_gsi::mkdefs_QFormLayout_RowWrapPolicy () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFormLayout_RowWrapPolicy_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFormLayout_RowWrapPolicy_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQFormLayout_RowWrapPolicy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QFormLayout_RowWrapPolicy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QFormLayout_RowWrapPolicy_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QFormLayout::RowWrapPolicy enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QFormLayout> inject_QFormLayout_RowWrapPolicy_Enum_in_parent (qt_gsi::mkdefs_QFormLayout_RowWrapPolicy ());
static gsi::ClassExt<QFormLayout> decl_QFormLayout_RowWrapPolicy_Enum_as_child (decl_QFormLayout_RowWrapPolicy_Enum, "RowWrapPolicy");

}

