
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQFileSystemModel.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQFileSystemModel_EventAdaptor.h"
#include "gsiDeclQFileSystemModel_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QFileSystemModel

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QFileSystemModel::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// bool QFileSystemModel::canFetchMore(const QModelIndex &parent)


static void _init_f_canFetchMore_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_canFetchMore_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QFileSystemModel *)cls)->canFetchMore (arg1));
}

static qt_gsi::GenericMethod *_create_f_canFetchMore_c2395 ()
{
  return new qt_gsi::GenericMethod ("canFetchMore", "@brief Method bool QFileSystemModel::canFetchMore(const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::canFetchMore", true, &_init_f_canFetchMore_c2395, &_call_f_canFetchMore_c2395);
}

// int QFileSystemModel::columnCount(const QModelIndex &parent)


static void _init_f_columnCount_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_columnCount_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<int > ((int)((QFileSystemModel *)cls)->columnCount (arg1));
}

static qt_gsi::GenericMethod *_create_f_columnCount_c2395 ()
{
  return new qt_gsi::GenericMethod ("columnCount", "@brief Method int QFileSystemModel::columnCount(const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::columnCount", true, &_init_f_columnCount_c2395, &_call_f_columnCount_c2395);
}

// QVariant QFileSystemModel::data(const QModelIndex &index, int role)


static void _init_f_data_c3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role", true, "Qt::DisplayRole");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_f_data_c3054 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args ? args.read<int > () : (int)(Qt::DisplayRole);
  ret.write<QVariant > ((QVariant)((QFileSystemModel *)cls)->data (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_data_c3054 ()
{
  return new qt_gsi::GenericMethod ("data", "@brief Method QVariant QFileSystemModel::data(const QModelIndex &index, int role)\nThis is a reimplementation of QAbstractItemModel::data", true, &_init_f_data_c3054, &_call_f_data_c3054);
}

// bool QFileSystemModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)


static void _init_f_dropMimeData_7425 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_f_dropMimeData_7425 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMimeData *arg1 = args.read<const QMimeData * > ();
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  const QModelIndex &arg5 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QFileSystemModel *)cls)->dropMimeData (arg1, qt_gsi::QtToCppAdaptor<Qt::DropAction>(arg2).cref(), arg3, arg4, arg5));
}

static qt_gsi::GenericMethod *_create_f_dropMimeData_7425 ()
{
  return new qt_gsi::GenericMethod ("dropMimeData", "@brief Method bool QFileSystemModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::dropMimeData", false, &_init_f_dropMimeData_7425, &_call_f_dropMimeData_7425);
}

// void QFileSystemModel::fetchMore(const QModelIndex &parent)


static void _init_f_fetchMore_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_fetchMore_2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ((QFileSystemModel *)cls)->fetchMore (arg1);
}

static qt_gsi::GenericMethod *_create_f_fetchMore_2395 ()
{
  return new qt_gsi::GenericMethod ("fetchMore", "@brief Method void QFileSystemModel::fetchMore(const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::fetchMore", false, &_init_f_fetchMore_2395, &_call_f_fetchMore_2395);
}

// QIcon QFileSystemModel::fileIcon(const QModelIndex &index)


static void _init_f_fileIcon_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QIcon > ();
}

static void _call_f_fileIcon_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QIcon > ((QIcon)((QFileSystemModel *)cls)->fileIcon (arg1));
}

static qt_gsi::GenericMethod *_create_f_fileIcon_c2395 ()
{
  return new qt_gsi::GenericMethod ("fileIcon", "@brief Method QIcon QFileSystemModel::fileIcon(const QModelIndex &index)\n", true, &_init_f_fileIcon_c2395, &_call_f_fileIcon_c2395);
}

// QFileInfo QFileSystemModel::fileInfo(const QModelIndex &index)


static void _init_f_fileInfo_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QFileInfo > ();
}

static void _call_f_fileInfo_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QFileInfo > ((QFileInfo)((QFileSystemModel *)cls)->fileInfo (arg1));
}

static qt_gsi::GenericMethod *_create_f_fileInfo_c2395 ()
{
  return new qt_gsi::GenericMethod ("fileInfo", "@brief Method QFileInfo QFileSystemModel::fileInfo(const QModelIndex &index)\n", true, &_init_f_fileInfo_c2395, &_call_f_fileInfo_c2395);
}

// QString QFileSystemModel::fileName(const QModelIndex &index)


static void _init_f_fileName_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_fileName_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QString > ((QString)((QFileSystemModel *)cls)->fileName (arg1));
}

static qt_gsi::GenericMethod *_create_f_fileName_c2395 ()
{
  return new qt_gsi::GenericMethod ("fileName", "@brief Method QString QFileSystemModel::fileName(const QModelIndex &index)\n", true, &_init_f_fileName_c2395, &_call_f_fileName_c2395);
}

// QString QFileSystemModel::filePath(const QModelIndex &index)


static void _init_f_filePath_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_filePath_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QString > ((QString)((QFileSystemModel *)cls)->filePath (arg1));
}

static qt_gsi::GenericMethod *_create_f_filePath_c2395 ()
{
  return new qt_gsi::GenericMethod ("filePath", "@brief Method QString QFileSystemModel::filePath(const QModelIndex &index)\n", true, &_init_f_filePath_c2395, &_call_f_filePath_c2395);
}

// QFlags<QDir::Filter> QFileSystemModel::filter()


static void _init_f_filter_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QDir::Filter> >::target_type > ();
}

static void _call_f_filter_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QDir::Filter> >::target_type > ((qt_gsi::Converter<QFlags<QDir::Filter> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QDir::Filter> >(((QFileSystemModel *)cls)->filter ()));
}

static qt_gsi::GenericMethod *_create_f_filter_c0 ()
{
  return new qt_gsi::GenericMethod (":filter", "@brief Method QFlags<QDir::Filter> QFileSystemModel::filter()\n", true, &_init_f_filter_c0, &_call_f_filter_c0);
}

// QFlags<Qt::ItemFlag> QFileSystemModel::flags(const QModelIndex &index)


static void _init_f_flags_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type > ();
}

static void _call_f_flags_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type > ((qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::ItemFlag> >(((QFileSystemModel *)cls)->flags (arg1)));
}

static qt_gsi::GenericMethod *_create_f_flags_c2395 ()
{
  return new qt_gsi::GenericMethod ("flags", "@brief Method QFlags<Qt::ItemFlag> QFileSystemModel::flags(const QModelIndex &index)\nThis is a reimplementation of QAbstractItemModel::flags", true, &_init_f_flags_c2395, &_call_f_flags_c2395);
}

// bool QFileSystemModel::hasChildren(const QModelIndex &parent)


static void _init_f_hasChildren_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasChildren_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<bool > ((bool)((QFileSystemModel *)cls)->hasChildren (arg1));
}

static qt_gsi::GenericMethod *_create_f_hasChildren_c2395 ()
{
  return new qt_gsi::GenericMethod ("hasChildren", "@brief Method bool QFileSystemModel::hasChildren(const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::hasChildren", true, &_init_f_hasChildren_c2395, &_call_f_hasChildren_c2395);
}

// QVariant QFileSystemModel::headerData(int section, Qt::Orientation orientation, int role)


static void _init_f_headerData_c3231 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role", true, "Qt::DisplayRole");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_f_headerData_c3231 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  int arg3 = args ? args.read<int > () : (int)(Qt::DisplayRole);
  ret.write<QVariant > ((QVariant)((QFileSystemModel *)cls)->headerData (arg1, qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg2).cref(), arg3));
}

static qt_gsi::GenericMethod *_create_f_headerData_c3231 ()
{
  return new qt_gsi::GenericMethod ("headerData", "@brief Method QVariant QFileSystemModel::headerData(int section, Qt::Orientation orientation, int role)\nThis is a reimplementation of QAbstractItemModel::headerData", true, &_init_f_headerData_c3231, &_call_f_headerData_c3231);
}

// QFileIconProvider *QFileSystemModel::iconProvider()


static void _init_f_iconProvider_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFileIconProvider * > ();
}

static void _call_f_iconProvider_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QFileIconProvider * > ((QFileIconProvider *)((QFileSystemModel *)cls)->iconProvider ());
}

static qt_gsi::GenericMethod *_create_f_iconProvider_c0 ()
{
  return new qt_gsi::GenericMethod (":iconProvider", "@brief Method QFileIconProvider *QFileSystemModel::iconProvider()\n", true, &_init_f_iconProvider_c0, &_call_f_iconProvider_c0);
}

// QModelIndex QFileSystemModel::index(int row, int column, const QModelIndex &parent)


static void _init_f_index_c3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_f_index_c3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<QModelIndex > ((QModelIndex)((QFileSystemModel *)cls)->index (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_index_c3713 ()
{
  return new qt_gsi::GenericMethod ("index", "@brief Method QModelIndex QFileSystemModel::index(int row, int column, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::index", true, &_init_f_index_c3713, &_call_f_index_c3713);
}

// QModelIndex QFileSystemModel::index(const QString &path, int column)


static void _init_f_index_c2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column", true, "0");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QModelIndex > ();
}

static void _call_f_index_c2684 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  int arg2 = args ? args.read<int > () : (int)(0);
  ret.write<QModelIndex > ((QModelIndex)((QFileSystemModel *)cls)->index (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_index_c2684 ()
{
  return new qt_gsi::GenericMethod ("index", "@brief Method QModelIndex QFileSystemModel::index(const QString &path, int column)\n", true, &_init_f_index_c2684, &_call_f_index_c2684);
}

// bool QFileSystemModel::isDir(const QModelIndex &index)


static void _init_f_isDir_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isDir_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QFileSystemModel *)cls)->isDir (arg1));
}

static qt_gsi::GenericMethod *_create_f_isDir_c2395 ()
{
  return new qt_gsi::GenericMethod ("isDir?", "@brief Method bool QFileSystemModel::isDir(const QModelIndex &index)\n", true, &_init_f_isDir_c2395, &_call_f_isDir_c2395);
}

// bool QFileSystemModel::isReadOnly()


static void _init_f_isReadOnly_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isReadOnly_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileSystemModel *)cls)->isReadOnly ());
}

static qt_gsi::GenericMethod *_create_f_isReadOnly_c0 ()
{
  return new qt_gsi::GenericMethod ("isReadOnly?|:readOnly", "@brief Method bool QFileSystemModel::isReadOnly()\n", true, &_init_f_isReadOnly_c0, &_call_f_isReadOnly_c0);
}

// QDateTime QFileSystemModel::lastModified(const QModelIndex &index)


static void _init_f_lastModified_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QDateTime > ();
}

static void _call_f_lastModified_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QDateTime > ((QDateTime)((QFileSystemModel *)cls)->lastModified (arg1));
}

static qt_gsi::GenericMethod *_create_f_lastModified_c2395 ()
{
  return new qt_gsi::GenericMethod ("lastModified", "@brief Method QDateTime QFileSystemModel::lastModified(const QModelIndex &index)\n", true, &_init_f_lastModified_c2395, &_call_f_lastModified_c2395);
}

// QMimeData *QFileSystemModel::mimeData(const QList<QModelIndex> &indexes)


static void _init_f_mimeData_c3010 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > (argspec_0);
  decl->set_return<QMimeData * > ();
}

static void _call_f_mimeData_c3010 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QModelIndex> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > ();
  ret.write<QMimeData * > ((QMimeData *)((QFileSystemModel *)cls)->mimeData (qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_mimeData_c3010 ()
{
  return new qt_gsi::GenericMethod ("mimeData", "@brief Method QMimeData *QFileSystemModel::mimeData(const QList<QModelIndex> &indexes)\nThis is a reimplementation of QAbstractItemModel::mimeData", true, &_init_f_mimeData_c3010, &_call_f_mimeData_c3010);
}

// QStringList QFileSystemModel::mimeTypes()


static void _init_f_mimeTypes_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_mimeTypes_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QFileSystemModel *)cls)->mimeTypes ()));
}

static qt_gsi::GenericMethod *_create_f_mimeTypes_c0 ()
{
  return new qt_gsi::GenericMethod ("mimeTypes", "@brief Method QStringList QFileSystemModel::mimeTypes()\nThis is a reimplementation of QAbstractItemModel::mimeTypes", true, &_init_f_mimeTypes_c0, &_call_f_mimeTypes_c0);
}

// QModelIndex QFileSystemModel::mkdir(const QModelIndex &parent, const QString &name)


static void _init_f_mkdir_4312 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("name");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QModelIndex > ();
}

static void _call_f_mkdir_4312 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QString &arg2 = args.read<const QString & > ();
  ret.write<QModelIndex > ((QModelIndex)((QFileSystemModel *)cls)->mkdir (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_mkdir_4312 ()
{
  return new qt_gsi::GenericMethod ("mkdir", "@brief Method QModelIndex QFileSystemModel::mkdir(const QModelIndex &parent, const QString &name)\n", false, &_init_f_mkdir_4312, &_call_f_mkdir_4312);
}

// QVariant QFileSystemModel::myComputer(int role)


static void _init_f_myComputer_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("role", true, "Qt::DisplayRole");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_myComputer_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(Qt::DisplayRole);
  ret.write<QVariant > ((QVariant)((QFileSystemModel *)cls)->myComputer (arg1));
}

static qt_gsi::GenericMethod *_create_f_myComputer_c767 ()
{
  return new qt_gsi::GenericMethod ("myComputer", "@brief Method QVariant QFileSystemModel::myComputer(int role)\n", true, &_init_f_myComputer_c767, &_call_f_myComputer_c767);
}

// bool QFileSystemModel::nameFilterDisables()


static void _init_f_nameFilterDisables_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_nameFilterDisables_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileSystemModel *)cls)->nameFilterDisables ());
}

static qt_gsi::GenericMethod *_create_f_nameFilterDisables_c0 ()
{
  return new qt_gsi::GenericMethod (":nameFilterDisables", "@brief Method bool QFileSystemModel::nameFilterDisables()\n", true, &_init_f_nameFilterDisables_c0, &_call_f_nameFilterDisables_c0);
}

// QStringList QFileSystemModel::nameFilters()


static void _init_f_nameFilters_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_nameFilters_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QFileSystemModel *)cls)->nameFilters ()));
}

static qt_gsi::GenericMethod *_create_f_nameFilters_c0 ()
{
  return new qt_gsi::GenericMethod (":nameFilters", "@brief Method QStringList QFileSystemModel::nameFilters()\n", true, &_init_f_nameFilters_c0, &_call_f_nameFilters_c0);
}

// QModelIndex QFileSystemModel::parent(const QModelIndex &child)


static void _init_f_parent_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("child");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_parent_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QModelIndex > ((QModelIndex)((QFileSystemModel *)cls)->parent (arg1));
}

static qt_gsi::GenericMethod *_create_f_parent_c2395 ()
{
  return new qt_gsi::GenericMethod ("parent", "@brief Method QModelIndex QFileSystemModel::parent(const QModelIndex &child)\nThis is a reimplementation of QAbstractItemModel::parent", true, &_init_f_parent_c2395, &_call_f_parent_c2395);
}

// QFlags<QFile::Permission> QFileSystemModel::permissions(const QModelIndex &index)


static void _init_f_permissions_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QFlags<QFile::Permission> >::target_type > ();
}

static void _call_f_permissions_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<qt_gsi::Converter<QFlags<QFile::Permission> >::target_type > ((qt_gsi::Converter<QFlags<QFile::Permission> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QFile::Permission> >(((QFileSystemModel *)cls)->permissions (arg1)));
}

static qt_gsi::GenericMethod *_create_f_permissions_c2395 ()
{
  return new qt_gsi::GenericMethod ("permissions", "@brief Method QFlags<QFile::Permission> QFileSystemModel::permissions(const QModelIndex &index)\n", true, &_init_f_permissions_c2395, &_call_f_permissions_c2395);
}

// bool QFileSystemModel::remove(const QModelIndex &index)


static void _init_f_remove_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_remove_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QFileSystemModel *)cls)->remove (arg1));
}

static qt_gsi::GenericMethod *_create_f_remove_c2395 ()
{
  return new qt_gsi::GenericMethod ("remove", "@brief Method bool QFileSystemModel::remove(const QModelIndex &index)\n", true, &_init_f_remove_c2395, &_call_f_remove_c2395);
}

// bool QFileSystemModel::resolveSymlinks()


static void _init_f_resolveSymlinks_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_resolveSymlinks_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileSystemModel *)cls)->resolveSymlinks ());
}

static qt_gsi::GenericMethod *_create_f_resolveSymlinks_c0 ()
{
  return new qt_gsi::GenericMethod (":resolveSymlinks", "@brief Method bool QFileSystemModel::resolveSymlinks()\n", true, &_init_f_resolveSymlinks_c0, &_call_f_resolveSymlinks_c0);
}

// bool QFileSystemModel::rmdir(const QModelIndex &index)


static void _init_f_rmdir_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_rmdir_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QFileSystemModel *)cls)->rmdir (arg1));
}

static qt_gsi::GenericMethod *_create_f_rmdir_c2395 ()
{
  return new qt_gsi::GenericMethod ("rmdir", "@brief Method bool QFileSystemModel::rmdir(const QModelIndex &index)\n", true, &_init_f_rmdir_c2395, &_call_f_rmdir_c2395);
}

// QDir QFileSystemModel::rootDirectory()


static void _init_f_rootDirectory_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDir > ();
}

static void _call_f_rootDirectory_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDir > ((QDir)((QFileSystemModel *)cls)->rootDirectory ());
}

static qt_gsi::GenericMethod *_create_f_rootDirectory_c0 ()
{
  return new qt_gsi::GenericMethod ("rootDirectory", "@brief Method QDir QFileSystemModel::rootDirectory()\n", true, &_init_f_rootDirectory_c0, &_call_f_rootDirectory_c0);
}

// QString QFileSystemModel::rootPath()


static void _init_f_rootPath_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_rootPath_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFileSystemModel *)cls)->rootPath ());
}

static qt_gsi::GenericMethod *_create_f_rootPath_c0 ()
{
  return new qt_gsi::GenericMethod ("rootPath", "@brief Method QString QFileSystemModel::rootPath()\n", true, &_init_f_rootPath_c0, &_call_f_rootPath_c0);
}

// int QFileSystemModel::rowCount(const QModelIndex &parent)


static void _init_f_rowCount_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_rowCount_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<int > ((int)((QFileSystemModel *)cls)->rowCount (arg1));
}

static qt_gsi::GenericMethod *_create_f_rowCount_c2395 ()
{
  return new qt_gsi::GenericMethod ("rowCount", "@brief Method int QFileSystemModel::rowCount(const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::rowCount", true, &_init_f_rowCount_c2395, &_call_f_rowCount_c2395);
}

// bool QFileSystemModel::setData(const QModelIndex &index, const QVariant &value, int role)


static void _init_f_setData_5065 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role", true, "Qt::EditRole");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_setData_5065 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  int arg3 = args ? args.read<int > () : (int)(Qt::EditRole);
  ret.write<bool > ((bool)((QFileSystemModel *)cls)->setData (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_setData_5065 ()
{
  return new qt_gsi::GenericMethod ("setData", "@brief Method bool QFileSystemModel::setData(const QModelIndex &index, const QVariant &value, int role)\nThis is a reimplementation of QAbstractItemModel::setData", false, &_init_f_setData_5065, &_call_f_setData_5065);
}

// void QFileSystemModel::setFilter(QFlags<QDir::Filter> filters)


static void _init_f_setFilter_2230 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filters");
  decl->add_arg<const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFilter_2230 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & > ();
  ((QFileSystemModel *)cls)->setFilter (qt_gsi::QtToCppAdaptor<QFlags<QDir::Filter> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setFilter_2230 ()
{
  return new qt_gsi::GenericMethod ("setFilter|filter=", "@brief Method void QFileSystemModel::setFilter(QFlags<QDir::Filter> filters)\n", false, &_init_f_setFilter_2230, &_call_f_setFilter_2230);
}

// void QFileSystemModel::setIconProvider(QFileIconProvider *provider)


static void _init_f_setIconProvider_2323 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("provider");
  decl->add_arg<QFileIconProvider * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIconProvider_2323 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFileIconProvider *arg1 = args.read<QFileIconProvider * > ();
  ((QFileSystemModel *)cls)->setIconProvider (arg1);
}

static qt_gsi::GenericMethod *_create_f_setIconProvider_2323 ()
{
  return new qt_gsi::GenericMethod ("setIconProvider|iconProvider=", "@brief Method void QFileSystemModel::setIconProvider(QFileIconProvider *provider)\n", false, &_init_f_setIconProvider_2323, &_call_f_setIconProvider_2323);
}

// void QFileSystemModel::setNameFilterDisables(bool enable)


static void _init_f_setNameFilterDisables_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNameFilterDisables_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QFileSystemModel *)cls)->setNameFilterDisables (arg1);
}

static qt_gsi::GenericMethod *_create_f_setNameFilterDisables_864 ()
{
  return new qt_gsi::GenericMethod ("setNameFilterDisables|nameFilterDisables=", "@brief Method void QFileSystemModel::setNameFilterDisables(bool enable)\n", false, &_init_f_setNameFilterDisables_864, &_call_f_setNameFilterDisables_864);
}

// void QFileSystemModel::setNameFilters(const QStringList &filters)


static void _init_f_setNameFilters_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filters");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNameFilters_2437 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStringList>::target_type & arg1 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  ((QFileSystemModel *)cls)->setNameFilters (qt_gsi::QtToCppAdaptor<QStringList>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setNameFilters_2437 ()
{
  return new qt_gsi::GenericMethod ("setNameFilters|nameFilters=", "@brief Method void QFileSystemModel::setNameFilters(const QStringList &filters)\n", false, &_init_f_setNameFilters_2437, &_call_f_setNameFilters_2437);
}

// void QFileSystemModel::setReadOnly(bool enable)


static void _init_f_setReadOnly_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setReadOnly_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QFileSystemModel *)cls)->setReadOnly (arg1);
}

static qt_gsi::GenericMethod *_create_f_setReadOnly_864 ()
{
  return new qt_gsi::GenericMethod ("setReadOnly|readOnly=", "@brief Method void QFileSystemModel::setReadOnly(bool enable)\n", false, &_init_f_setReadOnly_864, &_call_f_setReadOnly_864);
}

// void QFileSystemModel::setResolveSymlinks(bool enable)


static void _init_f_setResolveSymlinks_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setResolveSymlinks_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QFileSystemModel *)cls)->setResolveSymlinks (arg1);
}

static qt_gsi::GenericMethod *_create_f_setResolveSymlinks_864 ()
{
  return new qt_gsi::GenericMethod ("setResolveSymlinks|resolveSymlinks=", "@brief Method void QFileSystemModel::setResolveSymlinks(bool enable)\n", false, &_init_f_setResolveSymlinks_864, &_call_f_setResolveSymlinks_864);
}

// QModelIndex QFileSystemModel::setRootPath(const QString &path)


static void _init_f_setRootPath_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_setRootPath_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QModelIndex > ((QModelIndex)((QFileSystemModel *)cls)->setRootPath (arg1));
}

static qt_gsi::GenericMethod *_create_f_setRootPath_2025 ()
{
  return new qt_gsi::GenericMethod ("setRootPath", "@brief Method QModelIndex QFileSystemModel::setRootPath(const QString &path)\n", false, &_init_f_setRootPath_2025, &_call_f_setRootPath_2025);
}

// qint64 QFileSystemModel::size(const QModelIndex &index)


static void _init_f_size_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<qint64 > ();
}

static void _call_f_size_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<qint64 > ((qint64)((QFileSystemModel *)cls)->size (arg1));
}

static qt_gsi::GenericMethod *_create_f_size_c2395 ()
{
  return new qt_gsi::GenericMethod ("size", "@brief Method qint64 QFileSystemModel::size(const QModelIndex &index)\n", true, &_init_f_size_c2395, &_call_f_size_c2395);
}

// void QFileSystemModel::sort(int column, Qt::SortOrder order)


static void _init_f_sort_2340 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order", true, "Qt::AscendingOrder");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_sort_2340 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > () : (const qt_gsi::Converter<Qt::SortOrder>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::SortOrder>(heap, Qt::AscendingOrder));
  ((QFileSystemModel *)cls)->sort (arg1, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_sort_2340 ()
{
  return new qt_gsi::GenericMethod ("sort", "@brief Method void QFileSystemModel::sort(int column, Qt::SortOrder order)\nThis is a reimplementation of QAbstractItemModel::sort", false, &_init_f_sort_2340, &_call_f_sort_2340);
}

// QFlags<Qt::DropAction> QFileSystemModel::supportedDropActions()


static void _init_f_supportedDropActions_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ();
}

static void _call_f_supportedDropActions_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ((qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::DropAction> >(((QFileSystemModel *)cls)->supportedDropActions ()));
}

static qt_gsi::GenericMethod *_create_f_supportedDropActions_c0 ()
{
  return new qt_gsi::GenericMethod ("supportedDropActions", "@brief Method QFlags<Qt::DropAction> QFileSystemModel::supportedDropActions()\nThis is a reimplementation of QAbstractItemModel::supportedDropActions", true, &_init_f_supportedDropActions_c0, &_call_f_supportedDropActions_c0);
}

// QString QFileSystemModel::type(const QModelIndex &index)


static void _init_f_type_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_type_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QString > ((QString)((QFileSystemModel *)cls)->type (arg1));
}

static qt_gsi::GenericMethod *_create_f_type_c2395 ()
{
  return new qt_gsi::GenericMethod ("type", "@brief Method QString QFileSystemModel::type(const QModelIndex &index)\n", true, &_init_f_type_c2395, &_call_f_type_c2395);
}

// static QString QFileSystemModel::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QFileSystemModel::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QFileSystemModel::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QFileSystemModel::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QFileSystemModel::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QFileSystemModel::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QFileSystemModel::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QFileSystemModel::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QFileSystemModel::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QFileSystemModel::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QFileSystemModel::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QFileSystemModel::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QFileSystemModel, QFileSystemModel_EventAdaptor> ea_QFileSystemModel;

namespace gsi
{
extern gsi::Class<QAbstractItemModel> decl_QAbstractItemModel;

gsi::Class<QFileSystemModel> decl_QFileSystemModel (ea_QFileSystemModel, decl_QAbstractItemModel, "QFileSystemModel_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_canFetchMore_c2395 ()) +
  gsi::Methods(_create_f_columnCount_c2395 ()) +
  gsi::Methods(_create_f_data_c3054 ()) +
  gsi::Methods(_create_f_dropMimeData_7425 ()) +
  gsi::Methods(_create_f_fetchMore_2395 ()) +
  gsi::Methods(_create_f_fileIcon_c2395 ()) +
  gsi::Methods(_create_f_fileInfo_c2395 ()) +
  gsi::Methods(_create_f_fileName_c2395 ()) +
  gsi::Methods(_create_f_filePath_c2395 ()) +
  gsi::Methods(_create_f_filter_c0 ()) +
  gsi::Methods(_create_f_flags_c2395 ()) +
  gsi::Methods(_create_f_hasChildren_c2395 ()) +
  gsi::Methods(_create_f_headerData_c3231 ()) +
  gsi::Methods(_create_f_iconProvider_c0 ()) +
  gsi::Methods(_create_f_index_c3713 ()) +
  gsi::Methods(_create_f_index_c2684 ()) +
  gsi::Methods(_create_f_isDir_c2395 ()) +
  gsi::Methods(_create_f_isReadOnly_c0 ()) +
  gsi::Methods(_create_f_lastModified_c2395 ()) +
  gsi::Methods(_create_f_mimeData_c3010 ()) +
  gsi::Methods(_create_f_mimeTypes_c0 ()) +
  gsi::Methods(_create_f_mkdir_4312 ()) +
  gsi::Methods(_create_f_myComputer_c767 ()) +
  gsi::Methods(_create_f_nameFilterDisables_c0 ()) +
  gsi::Methods(_create_f_nameFilters_c0 ()) +
  gsi::Methods(_create_f_parent_c2395 ()) +
  gsi::Methods(_create_f_permissions_c2395 ()) +
  gsi::Methods(_create_f_remove_c2395 ()) +
  gsi::Methods(_create_f_resolveSymlinks_c0 ()) +
  gsi::Methods(_create_f_rmdir_c2395 ()) +
  gsi::Methods(_create_f_rootDirectory_c0 ()) +
  gsi::Methods(_create_f_rootPath_c0 ()) +
  gsi::Methods(_create_f_rowCount_c2395 ()) +
  gsi::Methods(_create_f_setData_5065 ()) +
  gsi::Methods(_create_f_setFilter_2230 ()) +
  gsi::Methods(_create_f_setIconProvider_2323 ()) +
  gsi::Methods(_create_f_setNameFilterDisables_864 ()) +
  gsi::Methods(_create_f_setNameFilters_2437 ()) +
  gsi::Methods(_create_f_setReadOnly_864 ()) +
  gsi::Methods(_create_f_setResolveSymlinks_864 ()) +
  gsi::Methods(_create_f_setRootPath_2025 ()) +
  gsi::Methods(_create_f_size_c2395 ()) +
  gsi::Methods(_create_f_sort_2340 ()) +
  gsi::Methods(_create_f_supportedDropActions_c0 ()) +
  gsi::Methods(_create_f_type_c2395 ()) +
  qt_gsi::qt_signal<QFileSystemModel, QFileSystemModel_EventAdaptor, const QModelIndex &, const QModelIndex &> ("dataChanged", &QFileSystemModel_EventAdaptor::dataChanged_e_4682, gsi::arg("topLeft"), gsi::arg("bottomRight"), "@brief Signal declaration for QFileSystemModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFileSystemModel, QFileSystemModel_EventAdaptor, QObject *> ("destroyed", &QFileSystemModel_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QFileSystemModel::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFileSystemModel, QFileSystemModel_EventAdaptor, const QString &, const QString &, const QString &> ("fileRenamed", &QFileSystemModel_EventAdaptor::fileRenamed_e_5859, gsi::arg("path"), gsi::arg("oldName"), gsi::arg("newName"), "@brief Signal declaration for QFileSystemModel::fileRenamed(const QString &path, const QString &oldName, const QString &newName)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFileSystemModel, QFileSystemModel_EventAdaptor, const qt_gsi::Converter<Qt::Orientation>::target_type &, int, int> ("headerDataChanged", &QFileSystemModel_EventAdaptor::headerDataChanged_e_3231, gsi::arg("orientation"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QFileSystemModel::headerDataChanged(Qt::Orientation orientation, int first, int last)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFileSystemModel, QFileSystemModel_EventAdaptor> ("layoutAboutToBeChanged", &QFileSystemModel_EventAdaptor::layoutAboutToBeChanged_e_0, "@brief Signal declaration for QFileSystemModel::layoutAboutToBeChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFileSystemModel, QFileSystemModel_EventAdaptor> ("layoutChanged", &QFileSystemModel_EventAdaptor::layoutChanged_e_0, "@brief Signal declaration for QFileSystemModel::layoutChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFileSystemModel, QFileSystemModel_EventAdaptor, const QString &> ("rootPathChanged", &QFileSystemModel_EventAdaptor::rootPathChanged_e_2025, gsi::arg("newPath"), "@brief Signal declaration for QFileSystemModel::rootPathChanged(const QString &newPath)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QFileSystemModel");
}


class QFileSystemModel_Adaptor : public QFileSystemModel, public qt_gsi::QtObjectBase
{
public:

  virtual ~QFileSystemModel_Adaptor();

  //  [adaptor ctor] QFileSystemModel::QFileSystemModel(QObject *parent)
  QFileSystemModel_Adaptor() : QFileSystemModel()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QFileSystemModel::QFileSystemModel(QObject *parent)
  QFileSystemModel_Adaptor(QObject *parent) : QFileSystemModel(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QFileSystemModel::beginInsertColumns(const QModelIndex &parent, int first, int last)
  void fp_QFileSystemModel_beginInsertColumns_3713 (const QModelIndex &parent, int first, int last) {
    QFileSystemModel::beginInsertColumns(parent, first, last);
  }

  //  void QFileSystemModel::beginInsertRows(const QModelIndex &parent, int first, int last)
  void fp_QFileSystemModel_beginInsertRows_3713 (const QModelIndex &parent, int first, int last) {
    QFileSystemModel::beginInsertRows(parent, first, last);
  }

  //  bool QFileSystemModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)
  bool fp_QFileSystemModel_beginMoveColumns_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn) {
    return QFileSystemModel::beginMoveColumns(sourceParent, sourceFirst, sourceLast, destinationParent, destinationColumn);
  }

  //  bool QFileSystemModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)
  bool fp_QFileSystemModel_beginMoveRows_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow) {
    return QFileSystemModel::beginMoveRows(sourceParent, sourceFirst, sourceLast, destinationParent, destinationRow);
  }

  //  void QFileSystemModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)
  void fp_QFileSystemModel_beginRemoveColumns_3713 (const QModelIndex &parent, int first, int last) {
    QFileSystemModel::beginRemoveColumns(parent, first, last);
  }

  //  void QFileSystemModel::beginRemoveRows(const QModelIndex &parent, int first, int last)
  void fp_QFileSystemModel_beginRemoveRows_3713 (const QModelIndex &parent, int first, int last) {
    QFileSystemModel::beginRemoveRows(parent, first, last);
  }

  //  void QFileSystemModel::beginResetModel()
  void fp_QFileSystemModel_beginResetModel_0 () {
    QFileSystemModel::beginResetModel();
  }

  //  void QFileSystemModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)
  void fp_QFileSystemModel_changePersistentIndex_4682 (const QModelIndex &from, const QModelIndex &to) {
    QFileSystemModel::changePersistentIndex(from, to);
  }

  //  void QFileSystemModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)
  void fp_QFileSystemModel_changePersistentIndexList_5912 (const qt_gsi::Converter<QList<QModelIndex> >::target_type & from, const qt_gsi::Converter<QList<QModelIndex> >::target_type & to) {
    QFileSystemModel::changePersistentIndexList(qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(from).cref(), qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(to).cref());
  }

  //  QModelIndex QFileSystemModel::createIndex(int row, int column, void *data)
  QModelIndex fp_QFileSystemModel_createIndex_c2374 (int row, int column, void *data) const {
    return QFileSystemModel::createIndex(row, column, data);
  }

  //  QModelIndex QFileSystemModel::createIndex(int row, int column, int id)
  QModelIndex fp_QFileSystemModel_createIndex_c2085 (int row, int column, int id) const {
    return QFileSystemModel::createIndex(row, column, id);
  }

  //  QModelIndex QFileSystemModel::createIndex(int row, int column, quint32 id)
  QModelIndex fp_QFileSystemModel_createIndex_c2416 (int row, int column, quint32 id) const {
    return QFileSystemModel::createIndex(row, column, id);
  }

  //  bool QFileSystemModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)
  bool fp_QFileSystemModel_decodeData_5302 (int row, int column, const QModelIndex &parent, QDataStream &stream) {
    return QFileSystemModel::decodeData(row, column, parent, stream);
  }

  //  void QFileSystemModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)
  void fp_QFileSystemModel_encodeData_c4599 (const qt_gsi::Converter<QList<QModelIndex> >::target_type & indexes, QDataStream &stream) const {
    QFileSystemModel::encodeData(qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(indexes).cref(), stream);
  }

  //  void QFileSystemModel::endInsertColumns()
  void fp_QFileSystemModel_endInsertColumns_0 () {
    QFileSystemModel::endInsertColumns();
  }

  //  void QFileSystemModel::endInsertRows()
  void fp_QFileSystemModel_endInsertRows_0 () {
    QFileSystemModel::endInsertRows();
  }

  //  void QFileSystemModel::endMoveColumns()
  void fp_QFileSystemModel_endMoveColumns_0 () {
    QFileSystemModel::endMoveColumns();
  }

  //  void QFileSystemModel::endMoveRows()
  void fp_QFileSystemModel_endMoveRows_0 () {
    QFileSystemModel::endMoveRows();
  }

  //  void QFileSystemModel::endRemoveColumns()
  void fp_QFileSystemModel_endRemoveColumns_0 () {
    QFileSystemModel::endRemoveColumns();
  }

  //  void QFileSystemModel::endRemoveRows()
  void fp_QFileSystemModel_endRemoveRows_0 () {
    QFileSystemModel::endRemoveRows();
  }

  //  void QFileSystemModel::endResetModel()
  void fp_QFileSystemModel_endResetModel_0 () {
    QFileSystemModel::endResetModel();
  }

  //  QList<QModelIndex> QFileSystemModel::persistentIndexList()
  qt_gsi::Converter<QList<QModelIndex> >::target_type fp_QFileSystemModel_persistentIndexList_c0 () const {
    return qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(QFileSystemModel::persistentIndexList());
  }

  //  int QFileSystemModel::receivers(const char *signal)
  int fp_QFileSystemModel_receivers_c1731 (const char *signal) const {
    return QFileSystemModel::receivers(signal);
  }

  //  void QFileSystemModel::reset()
  void fp_QFileSystemModel_reset_0 () {
    QFileSystemModel::reset();
  }

  //  QObject *QFileSystemModel::sender()
  QObject * fp_QFileSystemModel_sender_c0 () const {
    return QFileSystemModel::sender();
  }

  //  [adaptor impl] QModelIndex QFileSystemModel::buddy(const QModelIndex &index)
  QModelIndex cbs_buddy_c2395_0(const QModelIndex &index) const
  {
    return QFileSystemModel::buddy(index);
  }

  virtual QModelIndex buddy(const QModelIndex &index) const
  {
    if (cb_buddy_c2395_0.can_issue()) {
      return cb_buddy_c2395_0.issue<QFileSystemModel_Adaptor, QModelIndex, const QModelIndex &>(&QFileSystemModel_Adaptor::cbs_buddy_c2395_0, index);
    } else {
      return QFileSystemModel::buddy(index);
    }
  }

  //  [adaptor impl] bool QFileSystemModel::canFetchMore(const QModelIndex &parent)
  bool cbs_canFetchMore_c2395_0(const QModelIndex &parent) const
  {
    return QFileSystemModel::canFetchMore(parent);
  }

  virtual bool canFetchMore(const QModelIndex &parent) const
  {
    if (cb_canFetchMore_c2395_0.can_issue()) {
      return cb_canFetchMore_c2395_0.issue<QFileSystemModel_Adaptor, bool, const QModelIndex &>(&QFileSystemModel_Adaptor::cbs_canFetchMore_c2395_0, parent);
    } else {
      return QFileSystemModel::canFetchMore(parent);
    }
  }

  //  [adaptor impl] int QFileSystemModel::columnCount(const QModelIndex &parent)
  int cbs_columnCount_c2395_1(const QModelIndex &parent) const
  {
    return QFileSystemModel::columnCount(parent);
  }

  virtual int columnCount(const QModelIndex &parent) const
  {
    if (cb_columnCount_c2395_1.can_issue()) {
      return cb_columnCount_c2395_1.issue<QFileSystemModel_Adaptor, int, const QModelIndex &>(&QFileSystemModel_Adaptor::cbs_columnCount_c2395_1, parent);
    } else {
      return QFileSystemModel::columnCount(parent);
    }
  }

  //  [adaptor impl] QVariant QFileSystemModel::data(const QModelIndex &index, int role)
  QVariant cbs_data_c3054_1(const QModelIndex &index, int role) const
  {
    return QFileSystemModel::data(index, role);
  }

  virtual QVariant data(const QModelIndex &index, int role) const
  {
    if (cb_data_c3054_1.can_issue()) {
      return cb_data_c3054_1.issue<QFileSystemModel_Adaptor, QVariant, const QModelIndex &, int>(&QFileSystemModel_Adaptor::cbs_data_c3054_1, index, role);
    } else {
      return QFileSystemModel::data(index, role);
    }
  }

  //  [adaptor impl] bool QFileSystemModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  bool cbs_dropMimeData_7425_0(const QMimeData *data, const qt_gsi::Converter<Qt::DropAction>::target_type & action, int row, int column, const QModelIndex &parent)
  {
    return QFileSystemModel::dropMimeData(data, qt_gsi::QtToCppAdaptor<Qt::DropAction>(action).cref(), row, column, parent);
  }

  virtual bool dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  {
    if (cb_dropMimeData_7425_0.can_issue()) {
      return cb_dropMimeData_7425_0.issue<QFileSystemModel_Adaptor, bool, const QMimeData *, const qt_gsi::Converter<Qt::DropAction>::target_type &, int, int, const QModelIndex &>(&QFileSystemModel_Adaptor::cbs_dropMimeData_7425_0, data, qt_gsi::CppToQtAdaptor<Qt::DropAction>(action), row, column, parent);
    } else {
      return QFileSystemModel::dropMimeData(data, action, row, column, parent);
    }
  }

  //  [adaptor impl] bool QFileSystemModel::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QFileSystemModel::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QFileSystemModel_Adaptor, bool, QObject *, QEvent *>(&QFileSystemModel_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QFileSystemModel::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QFileSystemModel::fetchMore(const QModelIndex &parent)
  void cbs_fetchMore_2395_0(const QModelIndex &parent)
  {
    QFileSystemModel::fetchMore(parent);
  }

  virtual void fetchMore(const QModelIndex &parent)
  {
    if (cb_fetchMore_2395_0.can_issue()) {
      cb_fetchMore_2395_0.issue<QFileSystemModel_Adaptor, const QModelIndex &>(&QFileSystemModel_Adaptor::cbs_fetchMore_2395_0, parent);
    } else {
      QFileSystemModel::fetchMore(parent);
    }
  }

  //  [adaptor impl] QFlags<Qt::ItemFlag> QFileSystemModel::flags(const QModelIndex &index)
  qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type cbs_flags_c2395_0(const QModelIndex &index) const
  {
    return qt_gsi::CppToQtAdaptor<QFlags<Qt::ItemFlag> >(QFileSystemModel::flags(index));
  }

  virtual QFlags<Qt::ItemFlag> flags(const QModelIndex &index) const
  {
    if (cb_flags_c2395_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QFlags<Qt::ItemFlag> >(cb_flags_c2395_0.issue<QFileSystemModel_Adaptor, qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type, const QModelIndex &>(&QFileSystemModel_Adaptor::cbs_flags_c2395_0, index)).cref();
    } else {
      return QFileSystemModel::flags(index);
    }
  }

  //  [adaptor impl] bool QFileSystemModel::hasChildren(const QModelIndex &parent)
  bool cbs_hasChildren_c2395_1(const QModelIndex &parent) const
  {
    return QFileSystemModel::hasChildren(parent);
  }

  virtual bool hasChildren(const QModelIndex &parent) const
  {
    if (cb_hasChildren_c2395_1.can_issue()) {
      return cb_hasChildren_c2395_1.issue<QFileSystemModel_Adaptor, bool, const QModelIndex &>(&QFileSystemModel_Adaptor::cbs_hasChildren_c2395_1, parent);
    } else {
      return QFileSystemModel::hasChildren(parent);
    }
  }

  //  [adaptor impl] QVariant QFileSystemModel::headerData(int section, Qt::Orientation orientation, int role)
  QVariant cbs_headerData_c3231_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, int role) const
  {
    return QFileSystemModel::headerData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), role);
  }

  virtual QVariant headerData(int section, Qt::Orientation orientation, int role) const
  {
    if (cb_headerData_c3231_1.can_issue()) {
      return cb_headerData_c3231_1.issue<QFileSystemModel_Adaptor, QVariant, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, int>(&QFileSystemModel_Adaptor::cbs_headerData_c3231_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), role);
    } else {
      return QFileSystemModel::headerData(section, orientation, role);
    }
  }

  //  [adaptor impl] QModelIndex QFileSystemModel::index(int row, int column, const QModelIndex &parent)
  QModelIndex cbs_index_c3713_1(int row, int column, const QModelIndex &parent) const
  {
    return QFileSystemModel::index(row, column, parent);
  }

  virtual QModelIndex index(int row, int column, const QModelIndex &parent) const
  {
    if (cb_index_c3713_1.can_issue()) {
      return cb_index_c3713_1.issue<QFileSystemModel_Adaptor, QModelIndex, int, int, const QModelIndex &>(&QFileSystemModel_Adaptor::cbs_index_c3713_1, row, column, parent);
    } else {
      return QFileSystemModel::index(row, column, parent);
    }
  }

  //  [adaptor impl] bool QFileSystemModel::insertColumns(int column, int count, const QModelIndex &parent)
  bool cbs_insertColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QFileSystemModel::insertColumns(column, count, parent);
  }

  virtual bool insertColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_insertColumns_3713_1.can_issue()) {
      return cb_insertColumns_3713_1.issue<QFileSystemModel_Adaptor, bool, int, int, const QModelIndex &>(&QFileSystemModel_Adaptor::cbs_insertColumns_3713_1, column, count, parent);
    } else {
      return QFileSystemModel::insertColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QFileSystemModel::insertRows(int row, int count, const QModelIndex &parent)
  bool cbs_insertRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QFileSystemModel::insertRows(row, count, parent);
  }

  virtual bool insertRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_insertRows_3713_1.can_issue()) {
      return cb_insertRows_3713_1.issue<QFileSystemModel_Adaptor, bool, int, int, const QModelIndex &>(&QFileSystemModel_Adaptor::cbs_insertRows_3713_1, row, count, parent);
    } else {
      return QFileSystemModel::insertRows(row, count, parent);
    }
  }

  //  [adaptor impl] QList<QModelIndex> QFileSystemModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)
  qt_gsi::Converter<QList<QModelIndex> >::target_type cbs_match_c7932_2(const QModelIndex &start, int role, const QVariant &value, int hits, const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & flags) const
  {
    return qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(QFileSystemModel::match(start, role, value, hits, qt_gsi::QtToCppAdaptor<QFlags<Qt::MatchFlag> >(flags).cref()));
  }

  virtual QList<QModelIndex> match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags) const
  {
    if (cb_match_c7932_2.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(cb_match_c7932_2.issue<QFileSystemModel_Adaptor, qt_gsi::Converter<QList<QModelIndex> >::target_type, const QModelIndex &, int, const QVariant &, int, const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type &>(&QFileSystemModel_Adaptor::cbs_match_c7932_2, start, role, value, hits, qt_gsi::CppToQtAdaptor<QFlags<Qt::MatchFlag> >(flags))).cref();
    } else {
      return QFileSystemModel::match(start, role, value, hits, flags);
    }
  }

  //  [adaptor impl] QMimeData *QFileSystemModel::mimeData(const QList<QModelIndex> &indexes)
  QMimeData * cbs_mimeData_c3010_0(const qt_gsi::Converter<QList<QModelIndex> >::target_type & indexes) const
  {
    return QFileSystemModel::mimeData(qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(indexes).cref());
  }

  virtual QMimeData * mimeData(const QList<QModelIndex> &indexes) const
  {
    if (cb_mimeData_c3010_0.can_issue()) {
      return cb_mimeData_c3010_0.issue<QFileSystemModel_Adaptor, QMimeData *, const qt_gsi::Converter<QList<QModelIndex> >::target_type &>(&QFileSystemModel_Adaptor::cbs_mimeData_c3010_0, qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(indexes));
    } else {
      return QFileSystemModel::mimeData(indexes);
    }
  }

  //  [adaptor impl] QStringList QFileSystemModel::mimeTypes()
  qt_gsi::Converter<QStringList>::target_type cbs_mimeTypes_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QStringList>(QFileSystemModel::mimeTypes());
  }

  virtual QStringList mimeTypes() const
  {
    if (cb_mimeTypes_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QStringList>(cb_mimeTypes_c0_0.issue<QFileSystemModel_Adaptor, qt_gsi::Converter<QStringList>::target_type>(&QFileSystemModel_Adaptor::cbs_mimeTypes_c0_0)).cref();
    } else {
      return QFileSystemModel::mimeTypes();
    }
  }

  //  [adaptor impl] QModelIndex QFileSystemModel::parent(const QModelIndex &child)
  QModelIndex cbs_parent_c2395_0(const QModelIndex &child) const
  {
    return QFileSystemModel::parent(child);
  }

  virtual QModelIndex parent(const QModelIndex &child) const
  {
    if (cb_parent_c2395_0.can_issue()) {
      return cb_parent_c2395_0.issue<QFileSystemModel_Adaptor, QModelIndex, const QModelIndex &>(&QFileSystemModel_Adaptor::cbs_parent_c2395_0, child);
    } else {
      return QFileSystemModel::parent(child);
    }
  }

  //  [adaptor impl] bool QFileSystemModel::removeColumns(int column, int count, const QModelIndex &parent)
  bool cbs_removeColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QFileSystemModel::removeColumns(column, count, parent);
  }

  virtual bool removeColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_removeColumns_3713_1.can_issue()) {
      return cb_removeColumns_3713_1.issue<QFileSystemModel_Adaptor, bool, int, int, const QModelIndex &>(&QFileSystemModel_Adaptor::cbs_removeColumns_3713_1, column, count, parent);
    } else {
      return QFileSystemModel::removeColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QFileSystemModel::removeRows(int row, int count, const QModelIndex &parent)
  bool cbs_removeRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QFileSystemModel::removeRows(row, count, parent);
  }

  virtual bool removeRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_removeRows_3713_1.can_issue()) {
      return cb_removeRows_3713_1.issue<QFileSystemModel_Adaptor, bool, int, int, const QModelIndex &>(&QFileSystemModel_Adaptor::cbs_removeRows_3713_1, row, count, parent);
    } else {
      return QFileSystemModel::removeRows(row, count, parent);
    }
  }

  //  [adaptor impl] void QFileSystemModel::revert()
  void cbs_revert_0_0()
  {
    QFileSystemModel::revert();
  }

  virtual void revert()
  {
    if (cb_revert_0_0.can_issue()) {
      cb_revert_0_0.issue<QFileSystemModel_Adaptor>(&QFileSystemModel_Adaptor::cbs_revert_0_0);
    } else {
      QFileSystemModel::revert();
    }
  }

  //  [adaptor impl] int QFileSystemModel::rowCount(const QModelIndex &parent)
  int cbs_rowCount_c2395_1(const QModelIndex &parent) const
  {
    return QFileSystemModel::rowCount(parent);
  }

  virtual int rowCount(const QModelIndex &parent) const
  {
    if (cb_rowCount_c2395_1.can_issue()) {
      return cb_rowCount_c2395_1.issue<QFileSystemModel_Adaptor, int, const QModelIndex &>(&QFileSystemModel_Adaptor::cbs_rowCount_c2395_1, parent);
    } else {
      return QFileSystemModel::rowCount(parent);
    }
  }

  //  [adaptor impl] bool QFileSystemModel::setData(const QModelIndex &index, const QVariant &value, int role)
  bool cbs_setData_5065_1(const QModelIndex &index, const QVariant &value, int role)
  {
    return QFileSystemModel::setData(index, value, role);
  }

  virtual bool setData(const QModelIndex &index, const QVariant &value, int role)
  {
    if (cb_setData_5065_1.can_issue()) {
      return cb_setData_5065_1.issue<QFileSystemModel_Adaptor, bool, const QModelIndex &, const QVariant &, int>(&QFileSystemModel_Adaptor::cbs_setData_5065_1, index, value, role);
    } else {
      return QFileSystemModel::setData(index, value, role);
    }
  }

  //  [adaptor impl] bool QFileSystemModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  bool cbs_setHeaderData_5242_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, const QVariant &value, int role)
  {
    return QFileSystemModel::setHeaderData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), value, role);
  }

  virtual bool setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  {
    if (cb_setHeaderData_5242_1.can_issue()) {
      return cb_setHeaderData_5242_1.issue<QFileSystemModel_Adaptor, bool, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, const QVariant &, int>(&QFileSystemModel_Adaptor::cbs_setHeaderData_5242_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), value, role);
    } else {
      return QFileSystemModel::setHeaderData(section, orientation, value, role);
    }
  }

  //  [adaptor impl] void QFileSystemModel::sort(int column, Qt::SortOrder order)
  void cbs_sort_2340_1(int column, const qt_gsi::Converter<Qt::SortOrder>::target_type & order)
  {
    QFileSystemModel::sort(column, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(order).cref());
  }

  virtual void sort(int column, Qt::SortOrder order)
  {
    if (cb_sort_2340_1.can_issue()) {
      cb_sort_2340_1.issue<QFileSystemModel_Adaptor, int, const qt_gsi::Converter<Qt::SortOrder>::target_type &>(&QFileSystemModel_Adaptor::cbs_sort_2340_1, column, qt_gsi::CppToQtAdaptor<Qt::SortOrder>(order));
    } else {
      QFileSystemModel::sort(column, order);
    }
  }

  //  [adaptor impl] QSize QFileSystemModel::span(const QModelIndex &index)
  QSize cbs_span_c2395_0(const QModelIndex &index) const
  {
    return QFileSystemModel::span(index);
  }

  virtual QSize span(const QModelIndex &index) const
  {
    if (cb_span_c2395_0.can_issue()) {
      return cb_span_c2395_0.issue<QFileSystemModel_Adaptor, QSize, const QModelIndex &>(&QFileSystemModel_Adaptor::cbs_span_c2395_0, index);
    } else {
      return QFileSystemModel::span(index);
    }
  }

  //  [adaptor impl] bool QFileSystemModel::submit()
  bool cbs_submit_0_0()
  {
    return QFileSystemModel::submit();
  }

  virtual bool submit()
  {
    if (cb_submit_0_0.can_issue()) {
      return cb_submit_0_0.issue<QFileSystemModel_Adaptor, bool>(&QFileSystemModel_Adaptor::cbs_submit_0_0);
    } else {
      return QFileSystemModel::submit();
    }
  }

  //  [adaptor impl] QFlags<Qt::DropAction> QFileSystemModel::supportedDropActions()
  qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type cbs_supportedDropActions_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QFlags<Qt::DropAction> >(QFileSystemModel::supportedDropActions());
  }

  virtual QFlags<Qt::DropAction> supportedDropActions() const
  {
    if (cb_supportedDropActions_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QFlags<Qt::DropAction> >(cb_supportedDropActions_c0_0.issue<QFileSystemModel_Adaptor, qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type>(&QFileSystemModel_Adaptor::cbs_supportedDropActions_c0_0)).cref();
    } else {
      return QFileSystemModel::supportedDropActions();
    }
  }

  //  [adaptor impl] void QFileSystemModel::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QFileSystemModel::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QFileSystemModel_Adaptor, QChildEvent *>(&QFileSystemModel_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QFileSystemModel::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileSystemModel::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QFileSystemModel::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QFileSystemModel_Adaptor, QEvent *>(&QFileSystemModel_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QFileSystemModel::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileSystemModel::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QFileSystemModel::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QFileSystemModel_Adaptor, const char *>(&QFileSystemModel_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QFileSystemModel::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QFileSystemModel::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QFileSystemModel::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QFileSystemModel_Adaptor, bool, QEvent *>(&QFileSystemModel_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QFileSystemModel::event(_event);
    }
  }

  //  [adaptor impl] void QFileSystemModel::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QFileSystemModel::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QFileSystemModel_Adaptor, QTimerEvent *>(&QFileSystemModel_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QFileSystemModel::timerEvent(event);
    }
  }

  gsi::Callback cb_buddy_c2395_0;
  gsi::Callback cb_canFetchMore_c2395_0;
  gsi::Callback cb_columnCount_c2395_1;
  gsi::Callback cb_data_c3054_1;
  gsi::Callback cb_dropMimeData_7425_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_fetchMore_2395_0;
  gsi::Callback cb_flags_c2395_0;
  gsi::Callback cb_hasChildren_c2395_1;
  gsi::Callback cb_headerData_c3231_1;
  gsi::Callback cb_index_c3713_1;
  gsi::Callback cb_insertColumns_3713_1;
  gsi::Callback cb_insertRows_3713_1;
  gsi::Callback cb_match_c7932_2;
  gsi::Callback cb_mimeData_c3010_0;
  gsi::Callback cb_mimeTypes_c0_0;
  gsi::Callback cb_parent_c2395_0;
  gsi::Callback cb_removeColumns_3713_1;
  gsi::Callback cb_removeRows_3713_1;
  gsi::Callback cb_revert_0_0;
  gsi::Callback cb_rowCount_c2395_1;
  gsi::Callback cb_setData_5065_1;
  gsi::Callback cb_setHeaderData_5242_1;
  gsi::Callback cb_sort_2340_1;
  gsi::Callback cb_span_c2395_0;
  gsi::Callback cb_submit_0_0;
  gsi::Callback cb_supportedDropActions_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QFileSystemModel_Adaptor::~QFileSystemModel_Adaptor() { }

//  Constructor QFileSystemModel::QFileSystemModel(QObject *parent) (adaptor class)

static void _init_ctor_QFileSystemModel_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QFileSystemModel_Adaptor *> ();
}

static void _call_ctor_QFileSystemModel_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QFileSystemModel_Adaptor *> (new QFileSystemModel_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QFileSystemModel_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFileSystemModel::QFileSystemModel(QObject *parent)\nThis method creates an object of class QFileSystemModel.", &_init_ctor_QFileSystemModel_Adaptor_1302, &_call_ctor_QFileSystemModel_Adaptor_1302);
}

// void QFileSystemModel::beginInsertColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertColumns_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_beginInsertColumns_3713 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_beginInsertColumns_3713 ()
{
  return new qt_gsi::GenericMethod("*beginInsertColumns", "@brief Method void QFileSystemModel::beginInsertColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertColumns_3713, &_call_fp_beginInsertColumns_3713);
}


// void QFileSystemModel::beginInsertRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertRows_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_beginInsertRows_3713 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_beginInsertRows_3713 ()
{
  return new qt_gsi::GenericMethod("*beginInsertRows", "@brief Method void QFileSystemModel::beginInsertRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertRows_3713, &_call_fp_beginInsertRows_3713);
}


// bool QFileSystemModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)

static void _init_fp_beginMoveColumns_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationColumn");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveColumns_6659 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  const QModelIndex &arg4 = args.read<const QModelIndex & > ();
  int arg5 = args.read<int > ();
  ret.write<bool > ((bool)((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_beginMoveColumns_6659 (arg1, arg2, arg3, arg4, arg5));
}

static qt_gsi::GenericMethod*_create_fp_beginMoveColumns_6659 ()
{
  return new qt_gsi::GenericMethod("*beginMoveColumns", "@brief Method bool QFileSystemModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveColumns_6659, &_call_fp_beginMoveColumns_6659);
}


// bool QFileSystemModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)

static void _init_fp_beginMoveRows_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationRow");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveRows_6659 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  const QModelIndex &arg4 = args.read<const QModelIndex & > ();
  int arg5 = args.read<int > ();
  ret.write<bool > ((bool)((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_beginMoveRows_6659 (arg1, arg2, arg3, arg4, arg5));
}

static qt_gsi::GenericMethod*_create_fp_beginMoveRows_6659 ()
{
  return new qt_gsi::GenericMethod("*beginMoveRows", "@brief Method bool QFileSystemModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveRows_6659, &_call_fp_beginMoveRows_6659);
}


// void QFileSystemModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveColumns_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_beginRemoveColumns_3713 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_beginRemoveColumns_3713 ()
{
  return new qt_gsi::GenericMethod("*beginRemoveColumns", "@brief Method void QFileSystemModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveColumns_3713, &_call_fp_beginRemoveColumns_3713);
}


// void QFileSystemModel::beginRemoveRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveRows_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_beginRemoveRows_3713 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_beginRemoveRows_3713 ()
{
  return new qt_gsi::GenericMethod("*beginRemoveRows", "@brief Method void QFileSystemModel::beginRemoveRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveRows_3713, &_call_fp_beginRemoveRows_3713);
}


// void QFileSystemModel::beginResetModel()

static void _init_fp_beginResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_beginResetModel_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_beginResetModel_0 ();
}

static qt_gsi::GenericMethod*_create_fp_beginResetModel_0 ()
{
  return new qt_gsi::GenericMethod("*beginResetModel", "@brief Method void QFileSystemModel::beginResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginResetModel_0, &_call_fp_beginResetModel_0);
}


// void QFileSystemModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)

static void _init_fp_changePersistentIndex_4682 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndex_4682 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_changePersistentIndex_4682 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_changePersistentIndex_4682 ()
{
  return new qt_gsi::GenericMethod("*changePersistentIndex", "@brief Method void QFileSystemModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndex_4682, &_call_fp_changePersistentIndex_4682);
}


// void QFileSystemModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)

static void _init_fp_changePersistentIndexList_5912 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndexList_5912 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QModelIndex> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > ();
  const qt_gsi::Converter<QList<QModelIndex> >::target_type & arg2 = args.read<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > ();
  ((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_changePersistentIndexList_5912 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_changePersistentIndexList_5912 ()
{
  return new qt_gsi::GenericMethod("*changePersistentIndexList", "@brief Method void QFileSystemModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndexList_5912, &_call_fp_changePersistentIndexList_5912);
}


// QModelIndex QFileSystemModel::createIndex(int row, int column, void *data)

static void _init_fp_createIndex_c2374 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("data", true, "0");
  decl->add_arg<void * > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2374 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  void *arg3 = args ? args.read<void * > () : (void *)(0);
  ret.write<QModelIndex > ((QModelIndex)((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_createIndex_c2374 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_createIndex_c2374 ()
{
  return new qt_gsi::GenericMethod("*createIndex", "@brief Method QModelIndex QFileSystemModel::createIndex(int row, int column, void *data)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2374, &_call_fp_createIndex_c2374);
}


// QModelIndex QFileSystemModel::createIndex(int row, int column, int id)

static void _init_fp_createIndex_c2085 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("id");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2085 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ret.write<QModelIndex > ((QModelIndex)((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_createIndex_c2085 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_createIndex_c2085 ()
{
  return new qt_gsi::GenericMethod("*createIndex", "@brief Method QModelIndex QFileSystemModel::createIndex(int row, int column, int id)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2085, &_call_fp_createIndex_c2085);
}


// QModelIndex QFileSystemModel::createIndex(int row, int column, quint32 id)

static void _init_fp_createIndex_c2416 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("id");
  decl->add_arg<quint32 > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2416 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  quint32 arg3 = args.read<quint32 > ();
  ret.write<QModelIndex > ((QModelIndex)((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_createIndex_c2416 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_createIndex_c2416 ()
{
  return new qt_gsi::GenericMethod("*createIndex", "@brief Method QModelIndex QFileSystemModel::createIndex(int row, int column, quint32 id)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2416, &_call_fp_createIndex_c2416);
}


// bool QFileSystemModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)

static void _init_fp_decodeData_5302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("stream");
  decl->add_arg<QDataStream & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_fp_decodeData_5302 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  QDataStream &arg4 = args.read<QDataStream & > ();
  ret.write<bool > ((bool)((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_decodeData_5302 (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericMethod*_create_fp_decodeData_5302 ()
{
  return new qt_gsi::GenericMethod("*decodeData", "@brief Method bool QFileSystemModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_decodeData_5302, &_call_fp_decodeData_5302);
}


// void QFileSystemModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)

static void _init_fp_encodeData_c4599 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stream");
  decl->add_arg<QDataStream & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_encodeData_c4599 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QModelIndex> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > ();
  QDataStream &arg2 = args.read<QDataStream & > ();
  ((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_encodeData_c4599 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_encodeData_c4599 ()
{
  return new qt_gsi::GenericMethod("*encodeData", "@brief Method void QFileSystemModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_encodeData_c4599, &_call_fp_encodeData_c4599);
}


// void QFileSystemModel::endInsertColumns()

static void _init_fp_endInsertColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertColumns_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_endInsertColumns_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endInsertColumns_0 ()
{
  return new qt_gsi::GenericMethod("*endInsertColumns", "@brief Method void QFileSystemModel::endInsertColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertColumns_0, &_call_fp_endInsertColumns_0);
}


// void QFileSystemModel::endInsertRows()

static void _init_fp_endInsertRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertRows_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_endInsertRows_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endInsertRows_0 ()
{
  return new qt_gsi::GenericMethod("*endInsertRows", "@brief Method void QFileSystemModel::endInsertRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertRows_0, &_call_fp_endInsertRows_0);
}


// void QFileSystemModel::endMoveColumns()

static void _init_fp_endMoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveColumns_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_endMoveColumns_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endMoveColumns_0 ()
{
  return new qt_gsi::GenericMethod("*endMoveColumns", "@brief Method void QFileSystemModel::endMoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveColumns_0, &_call_fp_endMoveColumns_0);
}


// void QFileSystemModel::endMoveRows()

static void _init_fp_endMoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveRows_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_endMoveRows_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endMoveRows_0 ()
{
  return new qt_gsi::GenericMethod("*endMoveRows", "@brief Method void QFileSystemModel::endMoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveRows_0, &_call_fp_endMoveRows_0);
}


// void QFileSystemModel::endRemoveColumns()

static void _init_fp_endRemoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveColumns_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_endRemoveColumns_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endRemoveColumns_0 ()
{
  return new qt_gsi::GenericMethod("*endRemoveColumns", "@brief Method void QFileSystemModel::endRemoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveColumns_0, &_call_fp_endRemoveColumns_0);
}


// void QFileSystemModel::endRemoveRows()

static void _init_fp_endRemoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveRows_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_endRemoveRows_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endRemoveRows_0 ()
{
  return new qt_gsi::GenericMethod("*endRemoveRows", "@brief Method void QFileSystemModel::endRemoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveRows_0, &_call_fp_endRemoveRows_0);
}


// void QFileSystemModel::endResetModel()

static void _init_fp_endResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endResetModel_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_endResetModel_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endResetModel_0 ()
{
  return new qt_gsi::GenericMethod("*endResetModel", "@brief Method void QFileSystemModel::endResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endResetModel_0, &_call_fp_endResetModel_0);
}


// QList<QModelIndex> QFileSystemModel::persistentIndexList()

static void _init_fp_persistentIndexList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QModelIndex> >::target_type > ();
}

static void _call_fp_persistentIndexList_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QModelIndex> >::target_type > ((qt_gsi::Converter<QList<QModelIndex> >::target_type)((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_persistentIndexList_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_persistentIndexList_c0 ()
{
  return new qt_gsi::GenericMethod("*persistentIndexList", "@brief Method QList<QModelIndex> QFileSystemModel::persistentIndexList()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_persistentIndexList_c0, &_call_fp_persistentIndexList_c0);
}


// int QFileSystemModel::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QFileSystemModel::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QFileSystemModel::reset()

static void _init_fp_reset_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_reset_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_reset_0 ();
}

static qt_gsi::GenericMethod*_create_fp_reset_0 ()
{
  return new qt_gsi::GenericMethod("*reset", "@brief Method void QFileSystemModel::reset()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_reset_0, &_call_fp_reset_0);
}


// QObject *QFileSystemModel::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QFileSystemModel_Adaptor *)cls)->fp_QFileSystemModel_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QFileSystemModel::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// QModelIndex QFileSystemModel::buddy(const QModelIndex &index)

static void _init_cbs_buddy_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_buddy_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QModelIndex > ((QModelIndex)((QFileSystemModel_Adaptor *)cls)->cbs_buddy_c2395_0 (arg1));
}

static void _set_callback_cbs_buddy_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_buddy_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_buddy_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("buddy", "@hide", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_buddy_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("buddy", "@brief Virtual method QModelIndex QFileSystemModel::buddy(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0, &_set_callback_cbs_buddy_c2395_0);
}


// bool QFileSystemModel::canFetchMore(const QModelIndex &parent)

static void _init_cbs_canFetchMore_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_canFetchMore_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QFileSystemModel_Adaptor *)cls)->cbs_canFetchMore_c2395_0 (arg1));
}

static void _set_callback_cbs_canFetchMore_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_canFetchMore_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_canFetchMore_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("canFetchMore", "@hide", true, &_init_cbs_canFetchMore_c2395_0, &_call_cbs_canFetchMore_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_canFetchMore_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("canFetchMore", "@brief Virtual method bool QFileSystemModel::canFetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canFetchMore_c2395_0, &_call_cbs_canFetchMore_c2395_0, &_set_callback_cbs_canFetchMore_c2395_0);
}


// int QFileSystemModel::columnCount(const QModelIndex &parent)

static void _init_cbs_columnCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_columnCount_c2395_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<int > ((int)((QFileSystemModel_Adaptor *)cls)->cbs_columnCount_c2395_1 (arg1));
}

static void _set_callback_cbs_columnCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_columnCount_c2395_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_columnCount_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("columnCount", "@hide", true, &_init_cbs_columnCount_c2395_1, &_call_cbs_columnCount_c2395_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_columnCount_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("columnCount", "@brief Virtual method int QFileSystemModel::columnCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_columnCount_c2395_1, &_call_cbs_columnCount_c2395_1, &_set_callback_cbs_columnCount_c2395_1);
}


// QVariant QFileSystemModel::data(const QModelIndex &index, int role)

static void _init_cbs_data_c3054_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_data_c3054_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  ret.write<QVariant > ((QVariant)((QFileSystemModel_Adaptor *)cls)->cbs_data_c3054_1 (arg1, arg2));
}

static void _set_callback_cbs_data_c3054_1 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_data_c3054_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_data_c3054_1 ()
{
  return new qt_gsi::GenericMethod ("data", "@hide", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_data_c3054_1 ()
{
  return new qt_gsi::GenericMethod ("data", "@brief Virtual method QVariant QFileSystemModel::data(const QModelIndex &index, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1, &_set_callback_cbs_data_c3054_1);
}


// bool QFileSystemModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)

static void _init_cbs_dropMimeData_7425_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_dropMimeData_7425_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMimeData *arg1 = args.read<const QMimeData * > ();
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  const QModelIndex &arg5 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QFileSystemModel_Adaptor *)cls)->cbs_dropMimeData_7425_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_dropMimeData_7425_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_dropMimeData_7425_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropMimeData_7425_0 ()
{
  return new qt_gsi::GenericMethod ("dropMimeData", "@hide", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropMimeData_7425_0 ()
{
  return new qt_gsi::GenericMethod ("dropMimeData", "@brief Virtual method bool QFileSystemModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0, &_set_callback_cbs_dropMimeData_7425_0);
}


// bool QFileSystemModel::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QFileSystemModel_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QFileSystemModel::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QFileSystemModel::fetchMore(const QModelIndex &parent)

static void _init_cbs_fetchMore_2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fetchMore_2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ((QFileSystemModel_Adaptor *)cls)->cbs_fetchMore_2395_0 (arg1);
}

static void _set_callback_cbs_fetchMore_2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_fetchMore_2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fetchMore_2395_0 ()
{
  return new qt_gsi::GenericMethod ("fetchMore", "@hide", false, &_init_cbs_fetchMore_2395_0, &_call_cbs_fetchMore_2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fetchMore_2395_0 ()
{
  return new qt_gsi::GenericMethod ("fetchMore", "@brief Virtual method void QFileSystemModel::fetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fetchMore_2395_0, &_call_cbs_fetchMore_2395_0, &_set_callback_cbs_fetchMore_2395_0);
}


// QFlags<Qt::ItemFlag> QFileSystemModel::flags(const QModelIndex &index)

static void _init_cbs_flags_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type > ();
}

static void _call_cbs_flags_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type > ((qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type)((QFileSystemModel_Adaptor *)cls)->cbs_flags_c2395_0 (arg1));
}

static void _set_callback_cbs_flags_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_flags_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_flags_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("flags", "@hide", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_flags_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("flags", "@brief Virtual method QFlags<Qt::ItemFlag> QFileSystemModel::flags(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0, &_set_callback_cbs_flags_c2395_0);
}


// bool QFileSystemModel::hasChildren(const QModelIndex &parent)

static void _init_cbs_hasChildren_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_hasChildren_c2395_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QFileSystemModel_Adaptor *)cls)->cbs_hasChildren_c2395_1 (arg1));
}

static void _set_callback_cbs_hasChildren_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_hasChildren_c2395_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hasChildren_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("hasChildren", "@hide", true, &_init_cbs_hasChildren_c2395_1, &_call_cbs_hasChildren_c2395_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hasChildren_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("hasChildren", "@brief Virtual method bool QFileSystemModel::hasChildren(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasChildren_c2395_1, &_call_cbs_hasChildren_c2395_1, &_set_callback_cbs_hasChildren_c2395_1);
}


// QVariant QFileSystemModel::headerData(int section, Qt::Orientation orientation, int role)

static void _init_cbs_headerData_c3231_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_cbs_headerData_c3231_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  int arg3 = args.read<int > ();
  ret.write<QVariant > ((QVariant)((QFileSystemModel_Adaptor *)cls)->cbs_headerData_c3231_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_headerData_c3231_1 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_headerData_c3231_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_headerData_c3231_1 ()
{
  return new qt_gsi::GenericMethod ("headerData", "@hide", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_headerData_c3231_1 ()
{
  return new qt_gsi::GenericMethod ("headerData", "@brief Virtual method QVariant QFileSystemModel::headerData(int section, Qt::Orientation orientation, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1, &_set_callback_cbs_headerData_c3231_1);
}


// QModelIndex QFileSystemModel::index(int row, int column, const QModelIndex &parent)

static void _init_cbs_index_c3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_index_c3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<QModelIndex > ((QModelIndex)((QFileSystemModel_Adaptor *)cls)->cbs_index_c3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_index_c3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_index_c3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_index_c3713_1 ()
{
  return new qt_gsi::GenericMethod ("index", "@hide", true, &_init_cbs_index_c3713_1, &_call_cbs_index_c3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_index_c3713_1 ()
{
  return new qt_gsi::GenericMethod ("index", "@brief Virtual method QModelIndex QFileSystemModel::index(int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_index_c3713_1, &_call_cbs_index_c3713_1, &_set_callback_cbs_index_c3713_1);
}


// bool QFileSystemModel::insertColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_insertColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertColumns_3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QFileSystemModel_Adaptor *)cls)->cbs_insertColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_insertColumns_3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_insertColumns_3713_1 ()
{
  return new qt_gsi::GenericMethod ("insertColumns", "@hide", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_insertColumns_3713_1 ()
{
  return new qt_gsi::GenericMethod ("insertColumns", "@brief Virtual method bool QFileSystemModel::insertColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1, &_set_callback_cbs_insertColumns_3713_1);
}


// bool QFileSystemModel::insertRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_insertRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertRows_3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QFileSystemModel_Adaptor *)cls)->cbs_insertRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_insertRows_3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_insertRows_3713_1 ()
{
  return new qt_gsi::GenericMethod ("insertRows", "@hide", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_insertRows_3713_1 ()
{
  return new qt_gsi::GenericMethod ("insertRows", "@brief Virtual method bool QFileSystemModel::insertRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1, &_set_callback_cbs_insertRows_3713_1);
}


// QList<QModelIndex> QFileSystemModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)

static void _init_cbs_match_c7932_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("start");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("hits");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("flags");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & > (argspec_4);
  decl->set_return<qt_gsi::Converter<QList<QModelIndex> >::target_type > ();
}

static void _call_cbs_match_c7932_2 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  const QVariant &arg3 = args.read<const QVariant & > ();
  int arg4 = args.read<int > ();
  const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & arg5 = args.read<const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & > ();
  ret.write<qt_gsi::Converter<QList<QModelIndex> >::target_type > ((qt_gsi::Converter<QList<QModelIndex> >::target_type)((QFileSystemModel_Adaptor *)cls)->cbs_match_c7932_2 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_match_c7932_2 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_match_c7932_2 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_match_c7932_2 ()
{
  return new qt_gsi::GenericMethod ("match", "@hide", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2);
}

static qt_gsi::GenericMethod *_create_callback_cbs_match_c7932_2 ()
{
  return new qt_gsi::GenericMethod ("match", "@brief Virtual method QList<QModelIndex> QFileSystemModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2, &_set_callback_cbs_match_c7932_2);
}


// QMimeData *QFileSystemModel::mimeData(const QList<QModelIndex> &indexes)

static void _init_cbs_mimeData_c3010_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > (argspec_0);
  decl->set_return<QMimeData * > ();
}

static void _call_cbs_mimeData_c3010_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QModelIndex> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > ();
  ret.write<QMimeData * > ((QMimeData *)((QFileSystemModel_Adaptor *)cls)->cbs_mimeData_c3010_0 (arg1));
}

static void _set_callback_cbs_mimeData_c3010_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_mimeData_c3010_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mimeData_c3010_0 ()
{
  return new qt_gsi::GenericMethod ("mimeData", "@hide", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mimeData_c3010_0 ()
{
  return new qt_gsi::GenericMethod ("mimeData", "@brief Virtual method QMimeData *QFileSystemModel::mimeData(const QList<QModelIndex> &indexes)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0, &_set_callback_cbs_mimeData_c3010_0);
}


// QStringList QFileSystemModel::mimeTypes()

static void _init_cbs_mimeTypes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_cbs_mimeTypes_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)((QFileSystemModel_Adaptor *)cls)->cbs_mimeTypes_c0_0 ());
}

static void _set_callback_cbs_mimeTypes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_mimeTypes_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mimeTypes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("mimeTypes", "@hide", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mimeTypes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("mimeTypes", "@brief Virtual method QStringList QFileSystemModel::mimeTypes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0, &_set_callback_cbs_mimeTypes_c0_0);
}


// QModelIndex QFileSystemModel::parent(const QModelIndex &child)

static void _init_cbs_parent_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("child");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_parent_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QModelIndex > ((QModelIndex)((QFileSystemModel_Adaptor *)cls)->cbs_parent_c2395_0 (arg1));
}

static void _set_callback_cbs_parent_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_parent_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_parent_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("parent", "@hide", true, &_init_cbs_parent_c2395_0, &_call_cbs_parent_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_parent_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("parent", "@brief Virtual method QModelIndex QFileSystemModel::parent(const QModelIndex &child)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_parent_c2395_0, &_call_cbs_parent_c2395_0, &_set_callback_cbs_parent_c2395_0);
}


// bool QFileSystemModel::removeColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_removeColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeColumns_3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QFileSystemModel_Adaptor *)cls)->cbs_removeColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_removeColumns_3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_removeColumns_3713_1 ()
{
  return new qt_gsi::GenericMethod ("removeColumns", "@hide", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_removeColumns_3713_1 ()
{
  return new qt_gsi::GenericMethod ("removeColumns", "@brief Virtual method bool QFileSystemModel::removeColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1, &_set_callback_cbs_removeColumns_3713_1);
}


// bool QFileSystemModel::removeRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_removeRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeRows_3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QFileSystemModel_Adaptor *)cls)->cbs_removeRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_removeRows_3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_removeRows_3713_1 ()
{
  return new qt_gsi::GenericMethod ("removeRows", "@hide", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_removeRows_3713_1 ()
{
  return new qt_gsi::GenericMethod ("removeRows", "@brief Virtual method bool QFileSystemModel::removeRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1, &_set_callback_cbs_removeRows_3713_1);
}


// void QFileSystemModel::revert()

static void _init_cbs_revert_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_revert_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFileSystemModel_Adaptor *)cls)->cbs_revert_0_0 ();
}

static void _set_callback_cbs_revert_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_revert_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_revert_0_0 ()
{
  return new qt_gsi::GenericMethod ("revert", "@hide", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_revert_0_0 ()
{
  return new qt_gsi::GenericMethod ("revert", "@brief Virtual method void QFileSystemModel::revert()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0, &_set_callback_cbs_revert_0_0);
}


// int QFileSystemModel::rowCount(const QModelIndex &parent)

static void _init_cbs_rowCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_rowCount_c2395_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<int > ((int)((QFileSystemModel_Adaptor *)cls)->cbs_rowCount_c2395_1 (arg1));
}

static void _set_callback_cbs_rowCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_rowCount_c2395_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_rowCount_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("rowCount", "@hide", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_rowCount_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("rowCount", "@brief Virtual method int QFileSystemModel::rowCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1, &_set_callback_cbs_rowCount_c2395_1);
}


// bool QFileSystemModel::setData(const QModelIndex &index, const QVariant &value, int role)

static void _init_cbs_setData_5065_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_setData_5065_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  int arg3 = args.read<int > ();
  ret.write<bool > ((bool)((QFileSystemModel_Adaptor *)cls)->cbs_setData_5065_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_setData_5065_1 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_setData_5065_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setData_5065_1 ()
{
  return new qt_gsi::GenericMethod ("setData", "@hide", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setData_5065_1 ()
{
  return new qt_gsi::GenericMethod ("setData", "@brief Virtual method bool QFileSystemModel::setData(const QModelIndex &index, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1, &_set_callback_cbs_setData_5065_1);
}


// bool QFileSystemModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)

static void _init_cbs_setHeaderData_5242_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("role");
  decl->add_arg<int > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_cbs_setHeaderData_5242_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  const QVariant &arg3 = args.read<const QVariant & > ();
  int arg4 = args.read<int > ();
  ret.write<bool > ((bool)((QFileSystemModel_Adaptor *)cls)->cbs_setHeaderData_5242_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_setHeaderData_5242_1 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_setHeaderData_5242_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setHeaderData_5242_1 ()
{
  return new qt_gsi::GenericMethod ("setHeaderData", "@hide", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setHeaderData_5242_1 ()
{
  return new qt_gsi::GenericMethod ("setHeaderData", "@brief Virtual method bool QFileSystemModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1, &_set_callback_cbs_setHeaderData_5242_1);
}


// void QFileSystemModel::sort(int column, Qt::SortOrder order)

static void _init_cbs_sort_2340_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_sort_2340_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > ();
  ((QFileSystemModel_Adaptor *)cls)->cbs_sort_2340_1 (arg1, arg2);
}

static void _set_callback_cbs_sort_2340_1 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_sort_2340_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sort_2340_1 ()
{
  return new qt_gsi::GenericMethod ("sort", "@hide", false, &_init_cbs_sort_2340_1, &_call_cbs_sort_2340_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sort_2340_1 ()
{
  return new qt_gsi::GenericMethod ("sort", "@brief Virtual method void QFileSystemModel::sort(int column, Qt::SortOrder order)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sort_2340_1, &_call_cbs_sort_2340_1, &_set_callback_cbs_sort_2340_1);
}


// QSize QFileSystemModel::span(const QModelIndex &index)

static void _init_cbs_span_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QSize > ();
}

static void _call_cbs_span_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QSize > ((QSize)((QFileSystemModel_Adaptor *)cls)->cbs_span_c2395_0 (arg1));
}

static void _set_callback_cbs_span_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_span_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_span_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("span", "@hide", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_span_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("span", "@brief Virtual method QSize QFileSystemModel::span(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0, &_set_callback_cbs_span_c2395_0);
}


// bool QFileSystemModel::submit()

static void _init_cbs_submit_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_submit_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileSystemModel_Adaptor *)cls)->cbs_submit_0_0 ());
}

static void _set_callback_cbs_submit_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_submit_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_submit_0_0 ()
{
  return new qt_gsi::GenericMethod ("submit", "@hide", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_submit_0_0 ()
{
  return new qt_gsi::GenericMethod ("submit", "@brief Virtual method bool QFileSystemModel::submit()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0, &_set_callback_cbs_submit_0_0);
}


// QFlags<Qt::DropAction> QFileSystemModel::supportedDropActions()

static void _init_cbs_supportedDropActions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ();
}

static void _call_cbs_supportedDropActions_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ((qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type)((QFileSystemModel_Adaptor *)cls)->cbs_supportedDropActions_c0_0 ());
}

static void _set_callback_cbs_supportedDropActions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_supportedDropActions_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_supportedDropActions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("supportedDropActions", "@hide", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_supportedDropActions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("supportedDropActions", "@brief Virtual method QFlags<Qt::DropAction> QFileSystemModel::supportedDropActions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0, &_set_callback_cbs_supportedDropActions_c0_0);
}


// void QFileSystemModel::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QFileSystemModel_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QFileSystemModel::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QFileSystemModel::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QFileSystemModel_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QFileSystemModel::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QFileSystemModel::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QFileSystemModel_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QFileSystemModel::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// bool QFileSystemModel::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QFileSystemModel_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QFileSystemModel::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// void QFileSystemModel::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QFileSystemModel_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileSystemModel_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QFileSystemModel::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QFileSystemModel> decl_QFileSystemModel;

gsi::Class<QFileSystemModel_Adaptor> decl_QFileSystemModel_Adaptor (decl_QFileSystemModel, "QFileSystemModel",
  gsi::Methods(_create_fp_beginInsertColumns_3713 ()) +
  gsi::Methods(_create_fp_beginInsertRows_3713 ()) +
  gsi::Methods(_create_fp_beginMoveColumns_6659 ()) +
  gsi::Methods(_create_fp_beginMoveRows_6659 ()) +
  gsi::Methods(_create_fp_beginRemoveColumns_3713 ()) +
  gsi::Methods(_create_fp_beginRemoveRows_3713 ()) +
  gsi::Methods(_create_fp_beginResetModel_0 ()) +
  gsi::Methods(_create_fp_changePersistentIndex_4682 ()) +
  gsi::Methods(_create_fp_changePersistentIndexList_5912 ()) +
  gsi::Methods(_create_fp_createIndex_c2374 ()) +
  gsi::Methods(_create_fp_createIndex_c2085 ()) +
  gsi::Methods(_create_fp_createIndex_c2416 ()) +
  gsi::Methods(_create_fp_decodeData_5302 ()) +
  gsi::Methods(_create_fp_encodeData_c4599 ()) +
  gsi::Methods(_create_fp_endInsertColumns_0 ()) +
  gsi::Methods(_create_fp_endInsertRows_0 ()) +
  gsi::Methods(_create_fp_endMoveColumns_0 ()) +
  gsi::Methods(_create_fp_endMoveRows_0 ()) +
  gsi::Methods(_create_fp_endRemoveColumns_0 ()) +
  gsi::Methods(_create_fp_endRemoveRows_0 ()) +
  gsi::Methods(_create_fp_endResetModel_0 ()) +
  gsi::Methods(_create_fp_persistentIndexList_c0 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_reset_0 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_buddy_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_buddy_c2395_0 ()) +
  gsi::Methods(_create_cbs_canFetchMore_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_canFetchMore_c2395_0 ()) +
  gsi::Methods(_create_cbs_columnCount_c2395_1 ()) +
  gsi::Methods(_create_callback_cbs_columnCount_c2395_1 ()) +
  gsi::Methods(_create_cbs_data_c3054_1 ()) +
  gsi::Methods(_create_callback_cbs_data_c3054_1 ()) +
  gsi::Methods(_create_cbs_dropMimeData_7425_0 ()) +
  gsi::Methods(_create_callback_cbs_dropMimeData_7425_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_fetchMore_2395_0 ()) +
  gsi::Methods(_create_callback_cbs_fetchMore_2395_0 ()) +
  gsi::Methods(_create_cbs_flags_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_flags_c2395_0 ()) +
  gsi::Methods(_create_cbs_hasChildren_c2395_1 ()) +
  gsi::Methods(_create_callback_cbs_hasChildren_c2395_1 ()) +
  gsi::Methods(_create_cbs_headerData_c3231_1 ()) +
  gsi::Methods(_create_callback_cbs_headerData_c3231_1 ()) +
  gsi::Methods(_create_cbs_index_c3713_1 ()) +
  gsi::Methods(_create_callback_cbs_index_c3713_1 ()) +
  gsi::Methods(_create_cbs_insertColumns_3713_1 ()) +
  gsi::Methods(_create_callback_cbs_insertColumns_3713_1 ()) +
  gsi::Methods(_create_cbs_insertRows_3713_1 ()) +
  gsi::Methods(_create_callback_cbs_insertRows_3713_1 ()) +
  gsi::Methods(_create_cbs_match_c7932_2 ()) +
  gsi::Methods(_create_callback_cbs_match_c7932_2 ()) +
  gsi::Methods(_create_cbs_mimeData_c3010_0 ()) +
  gsi::Methods(_create_callback_cbs_mimeData_c3010_0 ()) +
  gsi::Methods(_create_cbs_mimeTypes_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_mimeTypes_c0_0 ()) +
  gsi::Methods(_create_cbs_parent_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_parent_c2395_0 ()) +
  gsi::Methods(_create_cbs_removeColumns_3713_1 ()) +
  gsi::Methods(_create_callback_cbs_removeColumns_3713_1 ()) +
  gsi::Methods(_create_cbs_removeRows_3713_1 ()) +
  gsi::Methods(_create_callback_cbs_removeRows_3713_1 ()) +
  gsi::Methods(_create_cbs_revert_0_0 ()) +
  gsi::Methods(_create_callback_cbs_revert_0_0 ()) +
  gsi::Methods(_create_cbs_rowCount_c2395_1 ()) +
  gsi::Methods(_create_callback_cbs_rowCount_c2395_1 ()) +
  gsi::Methods(_create_cbs_setData_5065_1 ()) +
  gsi::Methods(_create_callback_cbs_setData_5065_1 ()) +
  gsi::Methods(_create_cbs_setHeaderData_5242_1 ()) +
  gsi::Methods(_create_callback_cbs_setHeaderData_5242_1 ()) +
  gsi::Methods(_create_cbs_sort_2340_1 ()) +
  gsi::Methods(_create_callback_cbs_sort_2340_1 ()) +
  gsi::Methods(_create_cbs_span_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_span_c2395_0 ()) +
  gsi::Methods(_create_cbs_submit_0_0 ()) +
  gsi::Methods(_create_callback_cbs_submit_0_0 ()) +
  gsi::Methods(_create_cbs_supportedDropActions_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_supportedDropActions_c0_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QFileSystemModel_Adaptor_1302 ()),
  "@qt\n@brief Binding of QFileSystemModel");

}

