
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQDir.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQDir_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QDir

//  Constructor QDir::QDir(const QDir &)


static void _init_ctor_QDir_1681 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QDir & > (argspec_0);
  decl->set_return_new<QDir *> ();
}

static void _call_ctor_QDir_1681 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDir &arg1 = args.read<const QDir & > ();
  ret.write<QDir *> (new QDir (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QDir_1681 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDir::QDir(const QDir &)\nThis method creates an object of class QDir.", &_init_ctor_QDir_1681, &_call_ctor_QDir_1681);
}

//  Constructor QDir::QDir(const QString &path)


static void _init_ctor_QDir_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path", true, "QString()");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return_new<QDir *> ();
}

static void _call_ctor_QDir_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args ? args.read<const QString & > () : (const QString &)(QString());
  ret.write<QDir *> (new QDir (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QDir_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDir::QDir(const QString &path)\nThis method creates an object of class QDir.", &_init_ctor_QDir_2025, &_call_ctor_QDir_2025);
}

//  Constructor QDir::QDir(const QString &path, const QString &nameFilter, QFlags<QDir::SortFlag> sort, QFlags<QDir::Filter> filter)


static void _init_ctor_QDir_8374 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("nameFilter");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sort", true, "QDir::SortFlags(QDir::Name | QDir::IgnoreCase)");
  decl->add_arg<const qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("filter", true, "QDir::AllEntries");
  decl->add_arg<const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & > (argspec_3);
  decl->set_return_new<QDir *> ();
}

static void _call_ctor_QDir_8374 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QDir::SortFlag> >(heap, QDir::SortFlags(QDir::Name | QDir::IgnoreCase)));
  const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & arg4 = args ? args.read<const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & > () : (const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QDir::Filter> >(heap, QDir::AllEntries));
  ret.write<QDir *> (new QDir (arg1, arg2, qt_gsi::QtToCppAdaptor<QFlags<QDir::SortFlag> >(arg3).cref(), qt_gsi::QtToCppAdaptor<QFlags<QDir::Filter> >(arg4).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QDir_8374 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDir::QDir(const QString &path, const QString &nameFilter, QFlags<QDir::SortFlag> sort, QFlags<QDir::Filter> filter)\nThis method creates an object of class QDir.", &_init_ctor_QDir_8374, &_call_ctor_QDir_8374);
}

// QString QDir::absoluteFilePath(const QString &fileName)


static void _init_f_absoluteFilePath_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_absoluteFilePath_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QString > ((QString)((QDir *)cls)->absoluteFilePath (arg1));
}

static qt_gsi::GenericMethod *_create_f_absoluteFilePath_c2025 ()
{
  return new qt_gsi::GenericMethod ("absoluteFilePath", "@brief Method QString QDir::absoluteFilePath(const QString &fileName)\n", true, &_init_f_absoluteFilePath_c2025, &_call_f_absoluteFilePath_c2025);
}

// QString QDir::absolutePath()


static void _init_f_absolutePath_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_absolutePath_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QDir *)cls)->absolutePath ());
}

static qt_gsi::GenericMethod *_create_f_absolutePath_c0 ()
{
  return new qt_gsi::GenericMethod ("absolutePath", "@brief Method QString QDir::absolutePath()\n", true, &_init_f_absolutePath_c0, &_call_f_absolutePath_c0);
}

// QString QDir::canonicalPath()


static void _init_f_canonicalPath_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_canonicalPath_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QDir *)cls)->canonicalPath ());
}

static qt_gsi::GenericMethod *_create_f_canonicalPath_c0 ()
{
  return new qt_gsi::GenericMethod ("canonicalPath", "@brief Method QString QDir::canonicalPath()\n", true, &_init_f_canonicalPath_c0, &_call_f_canonicalPath_c0);
}

// bool QDir::cd(const QString &dirName)


static void _init_f_cd_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dirName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_cd_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QDir *)cls)->cd (arg1));
}

static qt_gsi::GenericMethod *_create_f_cd_2025 ()
{
  return new qt_gsi::GenericMethod ("cd", "@brief Method bool QDir::cd(const QString &dirName)\n", false, &_init_f_cd_2025, &_call_f_cd_2025);
}

// bool QDir::cdUp()


static void _init_f_cdUp_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_cdUp_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDir *)cls)->cdUp ());
}

static qt_gsi::GenericMethod *_create_f_cdUp_0 ()
{
  return new qt_gsi::GenericMethod ("cdUp", "@brief Method bool QDir::cdUp()\n", false, &_init_f_cdUp_0, &_call_f_cdUp_0);
}

// unsigned int QDir::count()


static void _init_f_count_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_f_count_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<unsigned int > ((unsigned int)((QDir *)cls)->count ());
}

static qt_gsi::GenericMethod *_create_f_count_c0 ()
{
  return new qt_gsi::GenericMethod ("count", "@brief Method unsigned int QDir::count()\n", true, &_init_f_count_c0, &_call_f_count_c0);
}

// QString QDir::dirName()


static void _init_f_dirName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_dirName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QDir *)cls)->dirName ());
}

static qt_gsi::GenericMethod *_create_f_dirName_c0 ()
{
  return new qt_gsi::GenericMethod ("dirName", "@brief Method QString QDir::dirName()\n", true, &_init_f_dirName_c0, &_call_f_dirName_c0);
}

// QList<QFileInfo> QDir::entryInfoList(QFlags<QDir::Filter> filters, QFlags<QDir::SortFlag> sort)


static void _init_f_entryInfoList_c4540 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filters", true, "QDir::NoFilter");
  decl->add_arg<const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sort", true, "QDir::NoSort");
  decl->add_arg<const qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type & > (argspec_1);
  decl->set_return<qt_gsi::Converter<QList<QFileInfo> >::target_type > ();
}

static void _call_f_entryInfoList_c4540 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & arg1 = args ? args.read<const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & > () : (const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QDir::Filter> >(heap, QDir::NoFilter));
  const qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QDir::SortFlag> >(heap, QDir::NoSort));
  ret.write<qt_gsi::Converter<QList<QFileInfo> >::target_type > ((qt_gsi::Converter<QList<QFileInfo> >::target_type)qt_gsi::CppToQtAdaptor<QList<QFileInfo> >(((QDir *)cls)->entryInfoList (qt_gsi::QtToCppAdaptor<QFlags<QDir::Filter> >(arg1).cref(), qt_gsi::QtToCppAdaptor<QFlags<QDir::SortFlag> >(arg2).cref())));
}

static qt_gsi::GenericMethod *_create_f_entryInfoList_c4540 ()
{
  return new qt_gsi::GenericMethod ("entryInfoList", "@brief Method QList<QFileInfo> QDir::entryInfoList(QFlags<QDir::Filter> filters, QFlags<QDir::SortFlag> sort)\n", true, &_init_f_entryInfoList_c4540, &_call_f_entryInfoList_c4540);
}

// QList<QFileInfo> QDir::entryInfoList(const QStringList &nameFilters, QFlags<QDir::Filter> filters, QFlags<QDir::SortFlag> sort)


static void _init_f_entryInfoList_c6869 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("nameFilters");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("filters", true, "QDir::NoFilter");
  decl->add_arg<const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sort", true, "QDir::NoSort");
  decl->add_arg<const qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type & > (argspec_2);
  decl->set_return<qt_gsi::Converter<QList<QFileInfo> >::target_type > ();
}

static void _call_f_entryInfoList_c6869 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStringList>::target_type & arg1 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & > () : (const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QDir::Filter> >(heap, QDir::NoFilter));
  const qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QDir::SortFlag> >(heap, QDir::NoSort));
  ret.write<qt_gsi::Converter<QList<QFileInfo> >::target_type > ((qt_gsi::Converter<QList<QFileInfo> >::target_type)qt_gsi::CppToQtAdaptor<QList<QFileInfo> >(((QDir *)cls)->entryInfoList (qt_gsi::QtToCppAdaptor<QStringList>(arg1).cref(), qt_gsi::QtToCppAdaptor<QFlags<QDir::Filter> >(arg2).cref(), qt_gsi::QtToCppAdaptor<QFlags<QDir::SortFlag> >(arg3).cref())));
}

static qt_gsi::GenericMethod *_create_f_entryInfoList_c6869 ()
{
  return new qt_gsi::GenericMethod ("entryInfoList", "@brief Method QList<QFileInfo> QDir::entryInfoList(const QStringList &nameFilters, QFlags<QDir::Filter> filters, QFlags<QDir::SortFlag> sort)\n", true, &_init_f_entryInfoList_c6869, &_call_f_entryInfoList_c6869);
}

// QStringList QDir::entryList(QFlags<QDir::Filter> filters, QFlags<QDir::SortFlag> sort)


static void _init_f_entryList_c4540 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filters", true, "QDir::NoFilter");
  decl->add_arg<const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sort", true, "QDir::NoSort");
  decl->add_arg<const qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type & > (argspec_1);
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_entryList_c4540 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & arg1 = args ? args.read<const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & > () : (const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QDir::Filter> >(heap, QDir::NoFilter));
  const qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QDir::SortFlag> >(heap, QDir::NoSort));
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QDir *)cls)->entryList (qt_gsi::QtToCppAdaptor<QFlags<QDir::Filter> >(arg1).cref(), qt_gsi::QtToCppAdaptor<QFlags<QDir::SortFlag> >(arg2).cref())));
}

static qt_gsi::GenericMethod *_create_f_entryList_c4540 ()
{
  return new qt_gsi::GenericMethod ("entryList", "@brief Method QStringList QDir::entryList(QFlags<QDir::Filter> filters, QFlags<QDir::SortFlag> sort)\n", true, &_init_f_entryList_c4540, &_call_f_entryList_c4540);
}

// QStringList QDir::entryList(const QStringList &nameFilters, QFlags<QDir::Filter> filters, QFlags<QDir::SortFlag> sort)


static void _init_f_entryList_c6869 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("nameFilters");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("filters", true, "QDir::NoFilter");
  decl->add_arg<const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sort", true, "QDir::NoSort");
  decl->add_arg<const qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type & > (argspec_2);
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_entryList_c6869 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStringList>::target_type & arg1 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & > () : (const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QDir::Filter> >(heap, QDir::NoFilter));
  const qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QDir::SortFlag> >(heap, QDir::NoSort));
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QDir *)cls)->entryList (qt_gsi::QtToCppAdaptor<QStringList>(arg1).cref(), qt_gsi::QtToCppAdaptor<QFlags<QDir::Filter> >(arg2).cref(), qt_gsi::QtToCppAdaptor<QFlags<QDir::SortFlag> >(arg3).cref())));
}

static qt_gsi::GenericMethod *_create_f_entryList_c6869 ()
{
  return new qt_gsi::GenericMethod ("entryList", "@brief Method QStringList QDir::entryList(const QStringList &nameFilters, QFlags<QDir::Filter> filters, QFlags<QDir::SortFlag> sort)\n", true, &_init_f_entryList_c6869, &_call_f_entryList_c6869);
}

// bool QDir::exists()


static void _init_f_exists_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_exists_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDir *)cls)->exists ());
}

static qt_gsi::GenericMethod *_create_f_exists_c0 ()
{
  return new qt_gsi::GenericMethod ("exists", "@brief Method bool QDir::exists()\n", true, &_init_f_exists_c0, &_call_f_exists_c0);
}

// bool QDir::exists(const QString &name)


static void _init_f_exists_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_exists_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QDir *)cls)->exists (arg1));
}

static qt_gsi::GenericMethod *_create_f_exists_c2025 ()
{
  return new qt_gsi::GenericMethod ("exists", "@brief Method bool QDir::exists(const QString &name)\n", true, &_init_f_exists_c2025, &_call_f_exists_c2025);
}

// QString QDir::filePath(const QString &fileName)


static void _init_f_filePath_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_filePath_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QString > ((QString)((QDir *)cls)->filePath (arg1));
}

static qt_gsi::GenericMethod *_create_f_filePath_c2025 ()
{
  return new qt_gsi::GenericMethod ("filePath", "@brief Method QString QDir::filePath(const QString &fileName)\n", true, &_init_f_filePath_c2025, &_call_f_filePath_c2025);
}

// QFlags<QDir::Filter> QDir::filter()


static void _init_f_filter_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QDir::Filter> >::target_type > ();
}

static void _call_f_filter_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QDir::Filter> >::target_type > ((qt_gsi::Converter<QFlags<QDir::Filter> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QDir::Filter> >(((QDir *)cls)->filter ()));
}

static qt_gsi::GenericMethod *_create_f_filter_c0 ()
{
  return new qt_gsi::GenericMethod (":filter", "@brief Method QFlags<QDir::Filter> QDir::filter()\n", true, &_init_f_filter_c0, &_call_f_filter_c0);
}

// bool QDir::isAbsolute()


static void _init_f_isAbsolute_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAbsolute_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDir *)cls)->isAbsolute ());
}

static qt_gsi::GenericMethod *_create_f_isAbsolute_c0 ()
{
  return new qt_gsi::GenericMethod ("isAbsolute?", "@brief Method bool QDir::isAbsolute()\n", true, &_init_f_isAbsolute_c0, &_call_f_isAbsolute_c0);
}

// bool QDir::isReadable()


static void _init_f_isReadable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isReadable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDir *)cls)->isReadable ());
}

static qt_gsi::GenericMethod *_create_f_isReadable_c0 ()
{
  return new qt_gsi::GenericMethod ("isReadable?", "@brief Method bool QDir::isReadable()\n", true, &_init_f_isReadable_c0, &_call_f_isReadable_c0);
}

// bool QDir::isRelative()


static void _init_f_isRelative_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRelative_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDir *)cls)->isRelative ());
}

static qt_gsi::GenericMethod *_create_f_isRelative_c0 ()
{
  return new qt_gsi::GenericMethod ("isRelative?", "@brief Method bool QDir::isRelative()\n", true, &_init_f_isRelative_c0, &_call_f_isRelative_c0);
}

// bool QDir::isRoot()


static void _init_f_isRoot_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRoot_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDir *)cls)->isRoot ());
}

static qt_gsi::GenericMethod *_create_f_isRoot_c0 ()
{
  return new qt_gsi::GenericMethod ("isRoot?", "@brief Method bool QDir::isRoot()\n", true, &_init_f_isRoot_c0, &_call_f_isRoot_c0);
}

// bool QDir::makeAbsolute()


static void _init_f_makeAbsolute_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_makeAbsolute_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDir *)cls)->makeAbsolute ());
}

static qt_gsi::GenericMethod *_create_f_makeAbsolute_0 ()
{
  return new qt_gsi::GenericMethod ("makeAbsolute", "@brief Method bool QDir::makeAbsolute()\n", false, &_init_f_makeAbsolute_0, &_call_f_makeAbsolute_0);
}

// bool QDir::mkdir(const QString &dirName)


static void _init_f_mkdir_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dirName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_mkdir_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QDir *)cls)->mkdir (arg1));
}

static qt_gsi::GenericMethod *_create_f_mkdir_c2025 ()
{
  return new qt_gsi::GenericMethod ("mkdir", "@brief Method bool QDir::mkdir(const QString &dirName)\n", true, &_init_f_mkdir_c2025, &_call_f_mkdir_c2025);
}

// bool QDir::mkpath(const QString &dirPath)


static void _init_f_mkpath_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dirPath");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_mkpath_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QDir *)cls)->mkpath (arg1));
}

static qt_gsi::GenericMethod *_create_f_mkpath_c2025 ()
{
  return new qt_gsi::GenericMethod ("mkpath", "@brief Method bool QDir::mkpath(const QString &dirPath)\n", true, &_init_f_mkpath_c2025, &_call_f_mkpath_c2025);
}

// QStringList QDir::nameFilters()


static void _init_f_nameFilters_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_nameFilters_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QDir *)cls)->nameFilters ()));
}

static qt_gsi::GenericMethod *_create_f_nameFilters_c0 ()
{
  return new qt_gsi::GenericMethod (":nameFilters", "@brief Method QStringList QDir::nameFilters()\n", true, &_init_f_nameFilters_c0, &_call_f_nameFilters_c0);
}

// bool QDir::operator!=(const QDir &dir)


static void _init_f_operator_excl__eq__c1681 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dir");
  decl->add_arg<const QDir & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c1681 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDir &arg1 = args.read<const QDir & > ();
  ret.write<bool > ((bool)((QDir *)cls)->operator!= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__c1681 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QDir::operator!=(const QDir &dir)\n", true, &_init_f_operator_excl__eq__c1681, &_call_f_operator_excl__eq__c1681);
}

// QDir &QDir::operator=(const QDir &)


static void _init_f_operator_eq__1681 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QDir & > (argspec_0);
  decl->set_return<QDir & > ();
}

static void _call_f_operator_eq__1681 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDir &arg1 = args.read<const QDir & > ();
  ret.write<QDir & > ((QDir &)((QDir *)cls)->operator= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__1681 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QDir &QDir::operator=(const QDir &)\n", false, &_init_f_operator_eq__1681, &_call_f_operator_eq__1681);
}

// QDir &QDir::operator=(const QString &path)


static void _init_f_operator_eq__2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QDir & > ();
}

static void _call_f_operator_eq__2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QDir & > ((QDir &)((QDir *)cls)->operator= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__2025 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QDir &QDir::operator=(const QString &path)\n", false, &_init_f_operator_eq__2025, &_call_f_operator_eq__2025);
}

// bool QDir::operator==(const QDir &dir)


static void _init_f_operator_eq__eq__c1681 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dir");
  decl->add_arg<const QDir & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c1681 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDir &arg1 = args.read<const QDir & > ();
  ret.write<bool > ((bool)((QDir *)cls)->operator== (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__c1681 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QDir::operator==(const QDir &dir)\n", true, &_init_f_operator_eq__eq__c1681, &_call_f_operator_eq__eq__c1681);
}

// QString QDir::operator[](int)


static void _init_f_operator_index__c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_operator_index__c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QString > ((QString)((QDir *)cls)->operator[] (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_index__c767 ()
{
  return new qt_gsi::GenericMethod ("[]", "@brief Method QString QDir::operator[](int)\n", true, &_init_f_operator_index__c767, &_call_f_operator_index__c767);
}

// QString QDir::path()


static void _init_f_path_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_path_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QDir *)cls)->path ());
}

static qt_gsi::GenericMethod *_create_f_path_c0 ()
{
  return new qt_gsi::GenericMethod (":path", "@brief Method QString QDir::path()\n", true, &_init_f_path_c0, &_call_f_path_c0);
}

// void QDir::refresh()


static void _init_f_refresh_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_refresh_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QDir *)cls)->refresh ();
}

static qt_gsi::GenericMethod *_create_f_refresh_c0 ()
{
  return new qt_gsi::GenericMethod ("refresh", "@brief Method void QDir::refresh()\n", true, &_init_f_refresh_c0, &_call_f_refresh_c0);
}

// QString QDir::relativeFilePath(const QString &fileName)


static void _init_f_relativeFilePath_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_relativeFilePath_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QString > ((QString)((QDir *)cls)->relativeFilePath (arg1));
}

static qt_gsi::GenericMethod *_create_f_relativeFilePath_c2025 ()
{
  return new qt_gsi::GenericMethod ("relativeFilePath", "@brief Method QString QDir::relativeFilePath(const QString &fileName)\n", true, &_init_f_relativeFilePath_c2025, &_call_f_relativeFilePath_c2025);
}

// bool QDir::remove(const QString &fileName)


static void _init_f_remove_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_remove_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QDir *)cls)->remove (arg1));
}

static qt_gsi::GenericMethod *_create_f_remove_2025 ()
{
  return new qt_gsi::GenericMethod ("remove", "@brief Method bool QDir::remove(const QString &fileName)\n", false, &_init_f_remove_2025, &_call_f_remove_2025);
}

// bool QDir::rename(const QString &oldName, const QString &newName)


static void _init_f_rename_3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("oldName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("newName");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_rename_3942 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QDir *)cls)->rename (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_rename_3942 ()
{
  return new qt_gsi::GenericMethod ("rename", "@brief Method bool QDir::rename(const QString &oldName, const QString &newName)\n", false, &_init_f_rename_3942, &_call_f_rename_3942);
}

// bool QDir::rmdir(const QString &dirName)


static void _init_f_rmdir_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dirName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_rmdir_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QDir *)cls)->rmdir (arg1));
}

static qt_gsi::GenericMethod *_create_f_rmdir_c2025 ()
{
  return new qt_gsi::GenericMethod ("rmdir", "@brief Method bool QDir::rmdir(const QString &dirName)\n", true, &_init_f_rmdir_c2025, &_call_f_rmdir_c2025);
}

// bool QDir::rmpath(const QString &dirPath)


static void _init_f_rmpath_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dirPath");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_rmpath_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QDir *)cls)->rmpath (arg1));
}

static qt_gsi::GenericMethod *_create_f_rmpath_c2025 ()
{
  return new qt_gsi::GenericMethod ("rmpath", "@brief Method bool QDir::rmpath(const QString &dirPath)\n", true, &_init_f_rmpath_c2025, &_call_f_rmpath_c2025);
}

// void QDir::setFilter(QFlags<QDir::Filter> filter)


static void _init_f_setFilter_2230 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filter");
  decl->add_arg<const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFilter_2230 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QDir::Filter> >::target_type & > ();
  ((QDir *)cls)->setFilter (qt_gsi::QtToCppAdaptor<QFlags<QDir::Filter> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setFilter_2230 ()
{
  return new qt_gsi::GenericMethod ("setFilter|filter=", "@brief Method void QDir::setFilter(QFlags<QDir::Filter> filter)\n", false, &_init_f_setFilter_2230, &_call_f_setFilter_2230);
}

// void QDir::setNameFilters(const QStringList &nameFilters)


static void _init_f_setNameFilters_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("nameFilters");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNameFilters_2437 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStringList>::target_type & arg1 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  ((QDir *)cls)->setNameFilters (qt_gsi::QtToCppAdaptor<QStringList>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setNameFilters_2437 ()
{
  return new qt_gsi::GenericMethod ("setNameFilters|nameFilters=", "@brief Method void QDir::setNameFilters(const QStringList &nameFilters)\n", false, &_init_f_setNameFilters_2437, &_call_f_setNameFilters_2437);
}

// void QDir::setPath(const QString &path)


static void _init_f_setPath_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPath_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QDir *)cls)->setPath (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPath_2025 ()
{
  return new qt_gsi::GenericMethod ("setPath|path=", "@brief Method void QDir::setPath(const QString &path)\n", false, &_init_f_setPath_2025, &_call_f_setPath_2025);
}

// void QDir::setSorting(QFlags<QDir::SortFlag> sort)


static void _init_f_setSorting_2418 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sort");
  decl->add_arg<const qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSorting_2418 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type & > ();
  ((QDir *)cls)->setSorting (qt_gsi::QtToCppAdaptor<QFlags<QDir::SortFlag> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setSorting_2418 ()
{
  return new qt_gsi::GenericMethod ("setSorting|sorting=", "@brief Method void QDir::setSorting(QFlags<QDir::SortFlag> sort)\n", false, &_init_f_setSorting_2418, &_call_f_setSorting_2418);
}

// QFlags<QDir::SortFlag> QDir::sorting()


static void _init_f_sorting_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type > ();
}

static void _call_f_sorting_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type > ((qt_gsi::Converter<QFlags<QDir::SortFlag> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QDir::SortFlag> >(((QDir *)cls)->sorting ()));
}

static qt_gsi::GenericMethod *_create_f_sorting_c0 ()
{
  return new qt_gsi::GenericMethod (":sorting", "@brief Method QFlags<QDir::SortFlag> QDir::sorting()\n", true, &_init_f_sorting_c0, &_call_f_sorting_c0);
}

// static void QDir::addResourceSearchPath(const QString &path)


static void _init_f_addResourceSearchPath_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addResourceSearchPath_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  QDir::addResourceSearchPath (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_addResourceSearchPath_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("addResourceSearchPath", "@brief Static method void QDir::addResourceSearchPath(const QString &path)\nThis method is static and can be called without an instance.", &_init_f_addResourceSearchPath_2025, &_call_f_addResourceSearchPath_2025);
}

// static void QDir::addSearchPath(const QString &prefix, const QString &path)


static void _init_f_addSearchPath_3942 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("prefix");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("path");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addSearchPath_3942 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  QDir::addSearchPath (arg1, arg2);
}

static qt_gsi::GenericStaticMethod *_create_f_addSearchPath_3942 ()
{
  return new qt_gsi::GenericStaticMethod ("addSearchPath", "@brief Static method void QDir::addSearchPath(const QString &prefix, const QString &path)\nThis method is static and can be called without an instance.", &_init_f_addSearchPath_3942, &_call_f_addSearchPath_3942);
}

// static QString QDir::cleanPath(const QString &path)


static void _init_f_cleanPath_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_cleanPath_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QString > ((QString)QDir::cleanPath (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_cleanPath_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("cleanPath", "@brief Static method QString QDir::cleanPath(const QString &path)\nThis method is static and can be called without an instance.", &_init_f_cleanPath_2025, &_call_f_cleanPath_2025);
}

// static QString QDir::convertSeparators(const QString &pathName)


static void _init_f_convertSeparators_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pathName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_convertSeparators_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QString > ((QString)QDir::convertSeparators (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_convertSeparators_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("convertSeparators", "@brief Static method QString QDir::convertSeparators(const QString &pathName)\nThis method is static and can be called without an instance.", &_init_f_convertSeparators_2025, &_call_f_convertSeparators_2025);
}

// static QDir QDir::current()


static void _init_f_current_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QDir > ();
}

static void _call_f_current_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDir > ((QDir)QDir::current ());
}

static qt_gsi::GenericStaticMethod *_create_f_current_0 ()
{
  return new qt_gsi::GenericStaticMethod ("current", "@brief Static method QDir QDir::current()\nThis method is static and can be called without an instance.", &_init_f_current_0, &_call_f_current_0);
}

// static QString QDir::currentPath()


static void _init_f_currentPath_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_currentPath_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)QDir::currentPath ());
}

static qt_gsi::GenericStaticMethod *_create_f_currentPath_0 ()
{
  return new qt_gsi::GenericStaticMethod ("currentPath", "@brief Static method QString QDir::currentPath()\nThis method is static and can be called without an instance.", &_init_f_currentPath_0, &_call_f_currentPath_0);
}

// static QList<QFileInfo> QDir::drives()


static void _init_f_drives_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QFileInfo> >::target_type > ();
}

static void _call_f_drives_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QFileInfo> >::target_type > ((qt_gsi::Converter<QList<QFileInfo> >::target_type)qt_gsi::CppToQtAdaptor<QList<QFileInfo> >(QDir::drives ()));
}

static qt_gsi::GenericStaticMethod *_create_f_drives_0 ()
{
  return new qt_gsi::GenericStaticMethod ("drives", "@brief Static method QList<QFileInfo> QDir::drives()\nThis method is static and can be called without an instance.", &_init_f_drives_0, &_call_f_drives_0);
}

// static QString QDir::fromNativeSeparators(const QString &pathName)


static void _init_f_fromNativeSeparators_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pathName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_fromNativeSeparators_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QString > ((QString)QDir::fromNativeSeparators (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_fromNativeSeparators_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("fromNativeSeparators", "@brief Static method QString QDir::fromNativeSeparators(const QString &pathName)\nThis method is static and can be called without an instance.", &_init_f_fromNativeSeparators_2025, &_call_f_fromNativeSeparators_2025);
}

// static QDir QDir::home()


static void _init_f_home_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QDir > ();
}

static void _call_f_home_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDir > ((QDir)QDir::home ());
}

static qt_gsi::GenericStaticMethod *_create_f_home_0 ()
{
  return new qt_gsi::GenericStaticMethod ("home", "@brief Static method QDir QDir::home()\nThis method is static and can be called without an instance.", &_init_f_home_0, &_call_f_home_0);
}

// static QString QDir::homePath()


static void _init_f_homePath_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_homePath_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)QDir::homePath ());
}

static qt_gsi::GenericStaticMethod *_create_f_homePath_0 ()
{
  return new qt_gsi::GenericStaticMethod ("homePath", "@brief Static method QString QDir::homePath()\nThis method is static and can be called without an instance.", &_init_f_homePath_0, &_call_f_homePath_0);
}

// static bool QDir::isAbsolutePath(const QString &path)


static void _init_f_isAbsolutePath_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isAbsolutePath_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)QDir::isAbsolutePath (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_isAbsolutePath_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("isAbsolutePath?", "@brief Static method bool QDir::isAbsolutePath(const QString &path)\nThis method is static and can be called without an instance.", &_init_f_isAbsolutePath_2025, &_call_f_isAbsolutePath_2025);
}

// static bool QDir::isRelativePath(const QString &path)


static void _init_f_isRelativePath_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isRelativePath_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)QDir::isRelativePath (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_isRelativePath_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("isRelativePath?", "@brief Static method bool QDir::isRelativePath(const QString &path)\nThis method is static and can be called without an instance.", &_init_f_isRelativePath_2025, &_call_f_isRelativePath_2025);
}

// static bool QDir::match(const QStringList &filters, const QString &fileName)


static void _init_f_match_4354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filters");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("fileName");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_match_4354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStringList>::target_type & arg1 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  const QString &arg2 = args.read<const QString & > ();
  ret.write<bool > ((bool)QDir::match (qt_gsi::QtToCppAdaptor<QStringList>(arg1).cref(), arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_match_4354 ()
{
  return new qt_gsi::GenericStaticMethod ("match", "@brief Static method bool QDir::match(const QStringList &filters, const QString &fileName)\nThis method is static and can be called without an instance.", &_init_f_match_4354, &_call_f_match_4354);
}

// static bool QDir::match(const QString &filter, const QString &fileName)


static void _init_f_match_3942 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filter");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("fileName");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_match_3942 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  ret.write<bool > ((bool)QDir::match (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_match_3942 ()
{
  return new qt_gsi::GenericStaticMethod ("match", "@brief Static method bool QDir::match(const QString &filter, const QString &fileName)\nThis method is static and can be called without an instance.", &_init_f_match_3942, &_call_f_match_3942);
}

// static QStringList QDir::nameFiltersFromString(const QString &nameFilter)


static void _init_f_nameFiltersFromString_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("nameFilter");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_nameFiltersFromString_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(QDir::nameFiltersFromString (arg1)));
}

static qt_gsi::GenericStaticMethod *_create_f_nameFiltersFromString_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("nameFiltersFromString", "@brief Static method QStringList QDir::nameFiltersFromString(const QString &nameFilter)\nThis method is static and can be called without an instance.", &_init_f_nameFiltersFromString_2025, &_call_f_nameFiltersFromString_2025);
}

// static QDir QDir::root()


static void _init_f_root_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QDir > ();
}

static void _call_f_root_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDir > ((QDir)QDir::root ());
}

static qt_gsi::GenericStaticMethod *_create_f_root_0 ()
{
  return new qt_gsi::GenericStaticMethod ("root", "@brief Static method QDir QDir::root()\nThis method is static and can be called without an instance.", &_init_f_root_0, &_call_f_root_0);
}

// static QString QDir::rootPath()


static void _init_f_rootPath_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_rootPath_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)QDir::rootPath ());
}

static qt_gsi::GenericStaticMethod *_create_f_rootPath_0 ()
{
  return new qt_gsi::GenericStaticMethod ("rootPath", "@brief Static method QString QDir::rootPath()\nThis method is static and can be called without an instance.", &_init_f_rootPath_0, &_call_f_rootPath_0);
}

// static QStringList QDir::searchPaths(const QString &prefix)


static void _init_f_searchPaths_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("prefix");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_searchPaths_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(QDir::searchPaths (arg1)));
}

static qt_gsi::GenericStaticMethod *_create_f_searchPaths_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("searchPaths", "@brief Static method QStringList QDir::searchPaths(const QString &prefix)\nThis method is static and can be called without an instance.", &_init_f_searchPaths_2025, &_call_f_searchPaths_2025);
}

// static QChar QDir::separator()


static void _init_f_separator_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_separator_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(QDir::separator ()));
}

static qt_gsi::GenericStaticMethod *_create_f_separator_0 ()
{
  return new qt_gsi::GenericStaticMethod ("separator", "@brief Static method QChar QDir::separator()\nThis method is static and can be called without an instance.", &_init_f_separator_0, &_call_f_separator_0);
}

// static bool QDir::setCurrent(const QString &path)


static void _init_f_setCurrent_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_setCurrent_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)QDir::setCurrent (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_setCurrent_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("setCurrent", "@brief Static method bool QDir::setCurrent(const QString &path)\nThis method is static and can be called without an instance.", &_init_f_setCurrent_2025, &_call_f_setCurrent_2025);
}

// static void QDir::setSearchPaths(const QString &prefix, const QStringList &searchPaths)


static void _init_f_setSearchPaths_4354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("prefix");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("searchPaths");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setSearchPaths_4354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const qt_gsi::Converter<QStringList>::target_type & arg2 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  QDir::setSearchPaths (arg1, qt_gsi::QtToCppAdaptor<QStringList>(arg2).cref());
}

static qt_gsi::GenericStaticMethod *_create_f_setSearchPaths_4354 ()
{
  return new qt_gsi::GenericStaticMethod ("setSearchPaths", "@brief Static method void QDir::setSearchPaths(const QString &prefix, const QStringList &searchPaths)\nThis method is static and can be called without an instance.", &_init_f_setSearchPaths_4354, &_call_f_setSearchPaths_4354);
}

// static QDir QDir::temp()


static void _init_f_temp_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QDir > ();
}

static void _call_f_temp_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDir > ((QDir)QDir::temp ());
}

static qt_gsi::GenericStaticMethod *_create_f_temp_0 ()
{
  return new qt_gsi::GenericStaticMethod ("temp", "@brief Static method QDir QDir::temp()\nThis method is static and can be called without an instance.", &_init_f_temp_0, &_call_f_temp_0);
}

// static QString QDir::tempPath()


static void _init_f_tempPath_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_tempPath_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)QDir::tempPath ());
}

static qt_gsi::GenericStaticMethod *_create_f_tempPath_0 ()
{
  return new qt_gsi::GenericStaticMethod ("tempPath", "@brief Static method QString QDir::tempPath()\nThis method is static and can be called without an instance.", &_init_f_tempPath_0, &_call_f_tempPath_0);
}

// static QString QDir::toNativeSeparators(const QString &pathName)


static void _init_f_toNativeSeparators_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pathName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toNativeSeparators_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QString > ((QString)QDir::toNativeSeparators (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_toNativeSeparators_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("toNativeSeparators", "@brief Static method QString QDir::toNativeSeparators(const QString &pathName)\nThis method is static and can be called without an instance.", &_init_f_toNativeSeparators_2025, &_call_f_toNativeSeparators_2025);
}


namespace gsi
{
gsi::Class<QDir> decl_QDir ("QDir",
  gsi::Methods(_create_ctor_QDir_1681 ()) +
  gsi::Methods(_create_ctor_QDir_2025 ()) +
  gsi::Methods(_create_ctor_QDir_8374 ()) +
  gsi::Methods(_create_f_absoluteFilePath_c2025 ()) +
  gsi::Methods(_create_f_absolutePath_c0 ()) +
  gsi::Methods(_create_f_canonicalPath_c0 ()) +
  gsi::Methods(_create_f_cd_2025 ()) +
  gsi::Methods(_create_f_cdUp_0 ()) +
  gsi::Methods(_create_f_count_c0 ()) +
  gsi::Methods(_create_f_dirName_c0 ()) +
  gsi::Methods(_create_f_entryInfoList_c4540 ()) +
  gsi::Methods(_create_f_entryInfoList_c6869 ()) +
  gsi::Methods(_create_f_entryList_c4540 ()) +
  gsi::Methods(_create_f_entryList_c6869 ()) +
  gsi::Methods(_create_f_exists_c0 ()) +
  gsi::Methods(_create_f_exists_c2025 ()) +
  gsi::Methods(_create_f_filePath_c2025 ()) +
  gsi::Methods(_create_f_filter_c0 ()) +
  gsi::Methods(_create_f_isAbsolute_c0 ()) +
  gsi::Methods(_create_f_isReadable_c0 ()) +
  gsi::Methods(_create_f_isRelative_c0 ()) +
  gsi::Methods(_create_f_isRoot_c0 ()) +
  gsi::Methods(_create_f_makeAbsolute_0 ()) +
  gsi::Methods(_create_f_mkdir_c2025 ()) +
  gsi::Methods(_create_f_mkpath_c2025 ()) +
  gsi::Methods(_create_f_nameFilters_c0 ()) +
  gsi::Methods(_create_f_operator_excl__eq__c1681 ()) +
  gsi::Methods(_create_f_operator_eq__1681 ()) +
  gsi::Methods(_create_f_operator_eq__2025 ()) +
  gsi::Methods(_create_f_operator_eq__eq__c1681 ()) +
  gsi::Methods(_create_f_operator_index__c767 ()) +
  gsi::Methods(_create_f_path_c0 ()) +
  gsi::Methods(_create_f_refresh_c0 ()) +
  gsi::Methods(_create_f_relativeFilePath_c2025 ()) +
  gsi::Methods(_create_f_remove_2025 ()) +
  gsi::Methods(_create_f_rename_3942 ()) +
  gsi::Methods(_create_f_rmdir_c2025 ()) +
  gsi::Methods(_create_f_rmpath_c2025 ()) +
  gsi::Methods(_create_f_setFilter_2230 ()) +
  gsi::Methods(_create_f_setNameFilters_2437 ()) +
  gsi::Methods(_create_f_setPath_2025 ()) +
  gsi::Methods(_create_f_setSorting_2418 ()) +
  gsi::Methods(_create_f_sorting_c0 ()) +
  gsi::Methods(_create_f_addResourceSearchPath_2025 ()) +
  gsi::Methods(_create_f_addSearchPath_3942 ()) +
  gsi::Methods(_create_f_cleanPath_2025 ()) +
  gsi::Methods(_create_f_convertSeparators_2025 ()) +
  gsi::Methods(_create_f_current_0 ()) +
  gsi::Methods(_create_f_currentPath_0 ()) +
  gsi::Methods(_create_f_drives_0 ()) +
  gsi::Methods(_create_f_fromNativeSeparators_2025 ()) +
  gsi::Methods(_create_f_home_0 ()) +
  gsi::Methods(_create_f_homePath_0 ()) +
  gsi::Methods(_create_f_isAbsolutePath_2025 ()) +
  gsi::Methods(_create_f_isRelativePath_2025 ()) +
  gsi::Methods(_create_f_match_4354 ()) +
  gsi::Methods(_create_f_match_3942 ()) +
  gsi::Methods(_create_f_nameFiltersFromString_2025 ()) +
  gsi::Methods(_create_f_root_0 ()) +
  gsi::Methods(_create_f_rootPath_0 ()) +
  gsi::Methods(_create_f_searchPaths_2025 ()) +
  gsi::Methods(_create_f_separator_0 ()) +
  gsi::Methods(_create_f_setCurrent_2025 ()) +
  gsi::Methods(_create_f_setSearchPaths_4354 ()) +
  gsi::Methods(_create_f_temp_0 ()) +
  gsi::Methods(_create_f_tempPath_0 ()) +
  gsi::Methods(_create_f_toNativeSeparators_2025 ()),
  "@qt\n@brief Binding of QDir");

}


//  Implementation of the enum wrapper class for QDir::Filter
namespace qt_gsi
{

static QDir_Filter_Enum *c_1_QDir_Filter_Enum () { return new QDir_Filter_Enum (QDir::Dirs); }
static QDir_Filter_Enum *c_2_QDir_Filter_Enum () { return new QDir_Filter_Enum (QDir::Files); }
static QDir_Filter_Enum *c_3_QDir_Filter_Enum () { return new QDir_Filter_Enum (QDir::Drives); }
static QDir_Filter_Enum *c_4_QDir_Filter_Enum () { return new QDir_Filter_Enum (QDir::NoSymLinks); }
static QDir_Filter_Enum *c_5_QDir_Filter_Enum () { return new QDir_Filter_Enum (QDir::AllEntries); }
static QDir_Filter_Enum *c_6_QDir_Filter_Enum () { return new QDir_Filter_Enum (QDir::TypeMask); }
static QDir_Filter_Enum *c_7_QDir_Filter_Enum () { return new QDir_Filter_Enum (QDir::Readable); }
static QDir_Filter_Enum *c_8_QDir_Filter_Enum () { return new QDir_Filter_Enum (QDir::Writable); }
static QDir_Filter_Enum *c_9_QDir_Filter_Enum () { return new QDir_Filter_Enum (QDir::Executable); }
static QDir_Filter_Enum *c_10_QDir_Filter_Enum () { return new QDir_Filter_Enum (QDir::PermissionMask); }
static QDir_Filter_Enum *c_11_QDir_Filter_Enum () { return new QDir_Filter_Enum (QDir::Modified); }
static QDir_Filter_Enum *c_12_QDir_Filter_Enum () { return new QDir_Filter_Enum (QDir::Hidden); }
static QDir_Filter_Enum *c_13_QDir_Filter_Enum () { return new QDir_Filter_Enum (QDir::System); }
static QDir_Filter_Enum *c_14_QDir_Filter_Enum () { return new QDir_Filter_Enum (QDir::AccessMask); }
static QDir_Filter_Enum *c_15_QDir_Filter_Enum () { return new QDir_Filter_Enum (QDir::AllDirs); }
static QDir_Filter_Enum *c_16_QDir_Filter_Enum () { return new QDir_Filter_Enum (QDir::CaseSensitive); }
static QDir_Filter_Enum *c_17_QDir_Filter_Enum () { return new QDir_Filter_Enum (QDir::NoDotAndDotDot); }
static QDir_Filter_Enum *c_18_QDir_Filter_Enum () { return new QDir_Filter_Enum (QDir::NoFilter); }

static gsi::Methods mkdefs_QDir_Filter () {
  return
    gsi::constant ("Dirs", &qt_gsi::c_1_QDir_Filter_Enum, "@brief Enum constant QDir::Dirs") +
    gsi::constant ("Files", &qt_gsi::c_2_QDir_Filter_Enum, "@brief Enum constant QDir::Files") +
    gsi::constant ("Drives", &qt_gsi::c_3_QDir_Filter_Enum, "@brief Enum constant QDir::Drives") +
    gsi::constant ("NoSymLinks", &qt_gsi::c_4_QDir_Filter_Enum, "@brief Enum constant QDir::NoSymLinks") +
    gsi::constant ("AllEntries", &qt_gsi::c_5_QDir_Filter_Enum, "@brief Enum constant QDir::AllEntries") +
    gsi::constant ("TypeMask", &qt_gsi::c_6_QDir_Filter_Enum, "@brief Enum constant QDir::TypeMask") +
    gsi::constant ("Readable", &qt_gsi::c_7_QDir_Filter_Enum, "@brief Enum constant QDir::Readable") +
    gsi::constant ("Writable", &qt_gsi::c_8_QDir_Filter_Enum, "@brief Enum constant QDir::Writable") +
    gsi::constant ("Executable", &qt_gsi::c_9_QDir_Filter_Enum, "@brief Enum constant QDir::Executable") +
    gsi::constant ("PermissionMask", &qt_gsi::c_10_QDir_Filter_Enum, "@brief Enum constant QDir::PermissionMask") +
    gsi::constant ("Modified", &qt_gsi::c_11_QDir_Filter_Enum, "@brief Enum constant QDir::Modified") +
    gsi::constant ("Hidden", &qt_gsi::c_12_QDir_Filter_Enum, "@brief Enum constant QDir::Hidden") +
    gsi::constant ("System", &qt_gsi::c_13_QDir_Filter_Enum, "@brief Enum constant QDir::System") +
    gsi::constant ("AccessMask", &qt_gsi::c_14_QDir_Filter_Enum, "@brief Enum constant QDir::AccessMask") +
    gsi::constant ("AllDirs", &qt_gsi::c_15_QDir_Filter_Enum, "@brief Enum constant QDir::AllDirs") +
    gsi::constant ("CaseSensitive", &qt_gsi::c_16_QDir_Filter_Enum, "@brief Enum constant QDir::CaseSensitive") +
    gsi::constant ("NoDotAndDotDot", &qt_gsi::c_17_QDir_Filter_Enum, "@brief Enum constant QDir::NoDotAndDotDot") +
    gsi::constant ("NoFilter", &qt_gsi::c_18_QDir_Filter_Enum, "@brief Enum constant QDir::NoFilter");
}

static std::string to_s_QDir_Filter_Enum (const QDir_Filter_Enum *e)
{
  if (e->value () == QDir::Dirs) { return tl::sprintf ("Dirs (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::Files) { return tl::sprintf ("Files (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::Drives) { return tl::sprintf ("Drives (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::NoSymLinks) { return tl::sprintf ("NoSymLinks (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::AllEntries) { return tl::sprintf ("AllEntries (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::TypeMask) { return tl::sprintf ("TypeMask (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::Readable) { return tl::sprintf ("Readable (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::Writable) { return tl::sprintf ("Writable (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::Executable) { return tl::sprintf ("Executable (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::PermissionMask) { return tl::sprintf ("PermissionMask (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::Modified) { return tl::sprintf ("Modified (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::Hidden) { return tl::sprintf ("Hidden (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::System) { return tl::sprintf ("System (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::AccessMask) { return tl::sprintf ("AccessMask (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::AllDirs) { return tl::sprintf ("AllDirs (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::CaseSensitive) { return tl::sprintf ("CaseSensitive (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::NoDotAndDotDot) { return tl::sprintf ("NoDotAndDotDot (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::NoFilter) { return tl::sprintf ("NoFilter (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QDir_Filter_Enum (const QDir_Filter_Enum *e)
{
  return (unsigned int) e->value ();
}

static QDir_Filter_Enum *from_i_QDir_Filter_Enum (unsigned int i)
{
  return new QDir_Filter_Enum ((QDir::Filter) i);
}

static bool equalQDir_Filter_Enum (const QDir_Filter_Enum *e, QDir_Filter_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QDir_Filter_Enum (const QDir_Filter_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QDir_Filter_Enums oropQDir_Filter_Enums (const QDir_Filter_Enums *e, const QDir_Filter_Enums &d)
{
  return e->flags () | d.flags ();
}

static QDir_Filter_Enums andopQDir_Filter_Enums (const QDir_Filter_Enums *e, const QDir_Filter_Enums &d)
{
  return e->flags () & d.flags ();
}

static QDir_Filter_Enums xoropQDir_Filter_Enums (const QDir_Filter_Enums *e, const QDir_Filter_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QDir_Filter_Enums (const QDir_Filter_Enums *e)
{
  std::string l;
  if (e->testFlag (QDir::Dirs)) { if (!l.empty ()) l += "|"; l += "Dirs"; }
  if (e->testFlag (QDir::Files)) { if (!l.empty ()) l += "|"; l += "Files"; }
  if (e->testFlag (QDir::Drives)) { if (!l.empty ()) l += "|"; l += "Drives"; }
  if (e->testFlag (QDir::NoSymLinks)) { if (!l.empty ()) l += "|"; l += "NoSymLinks"; }
  if (e->testFlag (QDir::AllEntries)) { if (!l.empty ()) l += "|"; l += "AllEntries"; }
  if (e->testFlag (QDir::TypeMask)) { if (!l.empty ()) l += "|"; l += "TypeMask"; }
  if (e->testFlag (QDir::Readable)) { if (!l.empty ()) l += "|"; l += "Readable"; }
  if (e->testFlag (QDir::Writable)) { if (!l.empty ()) l += "|"; l += "Writable"; }
  if (e->testFlag (QDir::Executable)) { if (!l.empty ()) l += "|"; l += "Executable"; }
  if (e->testFlag (QDir::PermissionMask)) { if (!l.empty ()) l += "|"; l += "PermissionMask"; }
  if (e->testFlag (QDir::Modified)) { if (!l.empty ()) l += "|"; l += "Modified"; }
  if (e->testFlag (QDir::Hidden)) { if (!l.empty ()) l += "|"; l += "Hidden"; }
  if (e->testFlag (QDir::System)) { if (!l.empty ()) l += "|"; l += "System"; }
  if (e->testFlag (QDir::AccessMask)) { if (!l.empty ()) l += "|"; l += "AccessMask"; }
  if (e->testFlag (QDir::AllDirs)) { if (!l.empty ()) l += "|"; l += "AllDirs"; }
  if (e->testFlag (QDir::CaseSensitive)) { if (!l.empty ()) l += "|"; l += "CaseSensitive"; }
  if (e->testFlag (QDir::NoDotAndDotDot)) { if (!l.empty ()) l += "|"; l += "NoDotAndDotDot"; }
  if (e->testFlag (QDir::NoFilter)) { if (!l.empty ()) l += "|"; l += "NoFilter"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QDir_Filter_Enums (const QDir_Filter_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QDir_Filter_Enums (const QDir_Filter_Enums *e, const QDir_Filter_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QDir_Filter_Enums> decl_QDir_Filter_Enums ("QDir_QFlags_Filter",
  gsi::method_ext ("|", &qt_gsi::oropQDir_Filter_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQDir_Filter_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQDir_Filter_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QDir_Filter_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QDir_Filter_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QDir_Filter_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QDir::Filter> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QDir_Filter_Enum> decl_QDir_Filter_Enum (decl_QDir_Filter_Enums, "QDir_Filter",
  qt_gsi::mkdefs_QDir_Filter () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QDir_Filter_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QDir_Filter_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQDir_Filter_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QDir_Filter_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QDir_Filter_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QDir::Filter enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QDir> inject_QDir_Filter_Enum_in_parent (qt_gsi::mkdefs_QDir_Filter ());
static gsi::ClassExt<QDir> decl_QDir_Filter_Enum_as_child (decl_QDir_Filter_Enum, "Filter");

}


//  Implementation of the enum wrapper class for QDir::SortFlag
namespace qt_gsi
{

static QDir_SortFlag_Enum *c_1_QDir_SortFlag_Enum () { return new QDir_SortFlag_Enum (QDir::Name); }
static QDir_SortFlag_Enum *c_2_QDir_SortFlag_Enum () { return new QDir_SortFlag_Enum (QDir::Time); }
static QDir_SortFlag_Enum *c_3_QDir_SortFlag_Enum () { return new QDir_SortFlag_Enum (QDir::Size); }
static QDir_SortFlag_Enum *c_4_QDir_SortFlag_Enum () { return new QDir_SortFlag_Enum (QDir::Unsorted); }
static QDir_SortFlag_Enum *c_5_QDir_SortFlag_Enum () { return new QDir_SortFlag_Enum (QDir::SortByMask); }
static QDir_SortFlag_Enum *c_6_QDir_SortFlag_Enum () { return new QDir_SortFlag_Enum (QDir::DirsFirst); }
static QDir_SortFlag_Enum *c_7_QDir_SortFlag_Enum () { return new QDir_SortFlag_Enum (QDir::Reversed); }
static QDir_SortFlag_Enum *c_8_QDir_SortFlag_Enum () { return new QDir_SortFlag_Enum (QDir::IgnoreCase); }
static QDir_SortFlag_Enum *c_9_QDir_SortFlag_Enum () { return new QDir_SortFlag_Enum (QDir::DirsLast); }
static QDir_SortFlag_Enum *c_10_QDir_SortFlag_Enum () { return new QDir_SortFlag_Enum (QDir::LocaleAware); }
static QDir_SortFlag_Enum *c_11_QDir_SortFlag_Enum () { return new QDir_SortFlag_Enum (QDir::Type); }
static QDir_SortFlag_Enum *c_12_QDir_SortFlag_Enum () { return new QDir_SortFlag_Enum (QDir::NoSort); }

static gsi::Methods mkdefs_QDir_SortFlag () {
  return
    gsi::constant ("Name", &qt_gsi::c_1_QDir_SortFlag_Enum, "@brief Enum constant QDir::Name") +
    gsi::constant ("Time", &qt_gsi::c_2_QDir_SortFlag_Enum, "@brief Enum constant QDir::Time") +
    gsi::constant ("Size", &qt_gsi::c_3_QDir_SortFlag_Enum, "@brief Enum constant QDir::Size") +
    gsi::constant ("Unsorted", &qt_gsi::c_4_QDir_SortFlag_Enum, "@brief Enum constant QDir::Unsorted") +
    gsi::constant ("SortByMask", &qt_gsi::c_5_QDir_SortFlag_Enum, "@brief Enum constant QDir::SortByMask") +
    gsi::constant ("DirsFirst", &qt_gsi::c_6_QDir_SortFlag_Enum, "@brief Enum constant QDir::DirsFirst") +
    gsi::constant ("Reversed", &qt_gsi::c_7_QDir_SortFlag_Enum, "@brief Enum constant QDir::Reversed") +
    gsi::constant ("IgnoreCase", &qt_gsi::c_8_QDir_SortFlag_Enum, "@brief Enum constant QDir::IgnoreCase") +
    gsi::constant ("DirsLast", &qt_gsi::c_9_QDir_SortFlag_Enum, "@brief Enum constant QDir::DirsLast") +
    gsi::constant ("LocaleAware", &qt_gsi::c_10_QDir_SortFlag_Enum, "@brief Enum constant QDir::LocaleAware") +
    gsi::constant ("Type", &qt_gsi::c_11_QDir_SortFlag_Enum, "@brief Enum constant QDir::Type") +
    gsi::constant ("NoSort", &qt_gsi::c_12_QDir_SortFlag_Enum, "@brief Enum constant QDir::NoSort");
}

static std::string to_s_QDir_SortFlag_Enum (const QDir_SortFlag_Enum *e)
{
  if (e->value () == QDir::Name) { return tl::sprintf ("Name (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::Time) { return tl::sprintf ("Time (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::Size) { return tl::sprintf ("Size (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::Unsorted) { return tl::sprintf ("Unsorted (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::SortByMask) { return tl::sprintf ("SortByMask (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::DirsFirst) { return tl::sprintf ("DirsFirst (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::Reversed) { return tl::sprintf ("Reversed (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::IgnoreCase) { return tl::sprintf ("IgnoreCase (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::DirsLast) { return tl::sprintf ("DirsLast (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::LocaleAware) { return tl::sprintf ("LocaleAware (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::Type) { return tl::sprintf ("Type (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDir::NoSort) { return tl::sprintf ("NoSort (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QDir_SortFlag_Enum (const QDir_SortFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static QDir_SortFlag_Enum *from_i_QDir_SortFlag_Enum (unsigned int i)
{
  return new QDir_SortFlag_Enum ((QDir::SortFlag) i);
}

static bool equalQDir_SortFlag_Enum (const QDir_SortFlag_Enum *e, QDir_SortFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QDir_SortFlag_Enum (const QDir_SortFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QDir_SortFlag_Enums oropQDir_SortFlag_Enums (const QDir_SortFlag_Enums *e, const QDir_SortFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static QDir_SortFlag_Enums andopQDir_SortFlag_Enums (const QDir_SortFlag_Enums *e, const QDir_SortFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static QDir_SortFlag_Enums xoropQDir_SortFlag_Enums (const QDir_SortFlag_Enums *e, const QDir_SortFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QDir_SortFlag_Enums (const QDir_SortFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (QDir::Name)) { if (!l.empty ()) l += "|"; l += "Name"; }
  if (e->testFlag (QDir::Time)) { if (!l.empty ()) l += "|"; l += "Time"; }
  if (e->testFlag (QDir::Size)) { if (!l.empty ()) l += "|"; l += "Size"; }
  if (e->testFlag (QDir::Unsorted)) { if (!l.empty ()) l += "|"; l += "Unsorted"; }
  if (e->testFlag (QDir::SortByMask)) { if (!l.empty ()) l += "|"; l += "SortByMask"; }
  if (e->testFlag (QDir::DirsFirst)) { if (!l.empty ()) l += "|"; l += "DirsFirst"; }
  if (e->testFlag (QDir::Reversed)) { if (!l.empty ()) l += "|"; l += "Reversed"; }
  if (e->testFlag (QDir::IgnoreCase)) { if (!l.empty ()) l += "|"; l += "IgnoreCase"; }
  if (e->testFlag (QDir::DirsLast)) { if (!l.empty ()) l += "|"; l += "DirsLast"; }
  if (e->testFlag (QDir::LocaleAware)) { if (!l.empty ()) l += "|"; l += "LocaleAware"; }
  if (e->testFlag (QDir::Type)) { if (!l.empty ()) l += "|"; l += "Type"; }
  if (e->testFlag (QDir::NoSort)) { if (!l.empty ()) l += "|"; l += "NoSort"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QDir_SortFlag_Enums (const QDir_SortFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QDir_SortFlag_Enums (const QDir_SortFlag_Enums *e, const QDir_SortFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QDir_SortFlag_Enums> decl_QDir_SortFlag_Enums ("QDir_QFlags_SortFlag",
  gsi::method_ext ("|", &qt_gsi::oropQDir_SortFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQDir_SortFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQDir_SortFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QDir_SortFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QDir_SortFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QDir_SortFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QDir::SortFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QDir_SortFlag_Enum> decl_QDir_SortFlag_Enum (decl_QDir_SortFlag_Enums, "QDir_SortFlag",
  qt_gsi::mkdefs_QDir_SortFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QDir_SortFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QDir_SortFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQDir_SortFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QDir_SortFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QDir_SortFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QDir::SortFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QDir> inject_QDir_SortFlag_Enum_in_parent (qt_gsi::mkdefs_QDir_SortFlag ());
static gsi::ClassExt<QDir> decl_QDir_SortFlag_Enum_as_child (decl_QDir_SortFlag_Enum, "SortFlag");

}

