
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQDate.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQDate_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QDate

//  Constructor QDate::QDate()


static void _init_ctor_QDate_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QDate *> ();
}

static void _call_ctor_QDate_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDate *> (new QDate ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QDate_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDate::QDate()\nThis method creates an object of class QDate.", &_init_ctor_QDate_0, &_call_ctor_QDate_0);
}

//  Constructor QDate::QDate(int y, int m, int d)


static void _init_ctor_QDate_2085 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("y");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("m");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("d");
  decl->add_arg<int > (argspec_2);
  decl->set_return_new<QDate *> ();
}

static void _call_ctor_QDate_2085 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ret.write<QDate *> (new QDate (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QDate_2085 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDate::QDate(int y, int m, int d)\nThis method creates an object of class QDate.", &_init_ctor_QDate_2085, &_call_ctor_QDate_2085);
}

// QDate QDate::addDays(int days)


static void _init_f_addDays_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("days");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QDate > ();
}

static void _call_f_addDays_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QDate > ((QDate)((QDate *)cls)->addDays (arg1));
}

static qt_gsi::GenericMethod *_create_f_addDays_c767 ()
{
  return new qt_gsi::GenericMethod ("addDays", "@brief Method QDate QDate::addDays(int days)\n", true, &_init_f_addDays_c767, &_call_f_addDays_c767);
}

// QDate QDate::addMonths(int months)


static void _init_f_addMonths_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("months");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QDate > ();
}

static void _call_f_addMonths_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QDate > ((QDate)((QDate *)cls)->addMonths (arg1));
}

static qt_gsi::GenericMethod *_create_f_addMonths_c767 ()
{
  return new qt_gsi::GenericMethod ("addMonths", "@brief Method QDate QDate::addMonths(int months)\n", true, &_init_f_addMonths_c767, &_call_f_addMonths_c767);
}

// QDate QDate::addYears(int years)


static void _init_f_addYears_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("years");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QDate > ();
}

static void _call_f_addYears_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QDate > ((QDate)((QDate *)cls)->addYears (arg1));
}

static qt_gsi::GenericMethod *_create_f_addYears_c767 ()
{
  return new qt_gsi::GenericMethod ("addYears", "@brief Method QDate QDate::addYears(int years)\n", true, &_init_f_addYears_c767, &_call_f_addYears_c767);
}

// int QDate::day()


static void _init_f_day_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_day_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QDate *)cls)->day ());
}

static qt_gsi::GenericMethod *_create_f_day_c0 ()
{
  return new qt_gsi::GenericMethod ("day", "@brief Method int QDate::day()\n", true, &_init_f_day_c0, &_call_f_day_c0);
}

// int QDate::dayOfWeek()


static void _init_f_dayOfWeek_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_dayOfWeek_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QDate *)cls)->dayOfWeek ());
}

static qt_gsi::GenericMethod *_create_f_dayOfWeek_c0 ()
{
  return new qt_gsi::GenericMethod ("dayOfWeek", "@brief Method int QDate::dayOfWeek()\n", true, &_init_f_dayOfWeek_c0, &_call_f_dayOfWeek_c0);
}

// int QDate::dayOfYear()


static void _init_f_dayOfYear_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_dayOfYear_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QDate *)cls)->dayOfYear ());
}

static qt_gsi::GenericMethod *_create_f_dayOfYear_c0 ()
{
  return new qt_gsi::GenericMethod ("dayOfYear", "@brief Method int QDate::dayOfYear()\n", true, &_init_f_dayOfYear_c0, &_call_f_dayOfYear_c0);
}

// int QDate::daysInMonth()


static void _init_f_daysInMonth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_daysInMonth_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QDate *)cls)->daysInMonth ());
}

static qt_gsi::GenericMethod *_create_f_daysInMonth_c0 ()
{
  return new qt_gsi::GenericMethod ("daysInMonth", "@brief Method int QDate::daysInMonth()\n", true, &_init_f_daysInMonth_c0, &_call_f_daysInMonth_c0);
}

// int QDate::daysInYear()


static void _init_f_daysInYear_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_daysInYear_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QDate *)cls)->daysInYear ());
}

static qt_gsi::GenericMethod *_create_f_daysInYear_c0 ()
{
  return new qt_gsi::GenericMethod ("daysInYear", "@brief Method int QDate::daysInYear()\n", true, &_init_f_daysInYear_c0, &_call_f_daysInYear_c0);
}

// int QDate::daysTo(const QDate &)


static void _init_f_daysTo_c1776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QDate & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_daysTo_c1776 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDate &arg1 = args.read<const QDate & > ();
  ret.write<int > ((int)((QDate *)cls)->daysTo (arg1));
}

static qt_gsi::GenericMethod *_create_f_daysTo_c1776 ()
{
  return new qt_gsi::GenericMethod ("daysTo", "@brief Method int QDate::daysTo(const QDate &)\n", true, &_init_f_daysTo_c1776, &_call_f_daysTo_c1776);
}

// void QDate::getDate(int *year, int *month, int *day)


static void _init_f_getDate_2643 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("year");
  decl->add_arg<int * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("month");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("day");
  decl->add_arg<int * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_getDate_2643 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int *arg1 = args.read<int * > ();
  int *arg2 = args.read<int * > ();
  int *arg3 = args.read<int * > ();
  ((QDate *)cls)->getDate (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_getDate_2643 ()
{
  return new qt_gsi::GenericMethod ("getDate", "@brief Method void QDate::getDate(int *year, int *month, int *day)\n", false, &_init_f_getDate_2643, &_call_f_getDate_2643);
}

// bool QDate::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDate *)cls)->isNull ());
}

static qt_gsi::GenericMethod *_create_f_isNull_c0 ()
{
  return new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QDate::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
}

// bool QDate::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDate *)cls)->isValid ());
}

static qt_gsi::GenericMethod *_create_f_isValid_c0 ()
{
  return new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QDate::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
}

// int QDate::month()


static void _init_f_month_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_month_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QDate *)cls)->month ());
}

static qt_gsi::GenericMethod *_create_f_month_c0 ()
{
  return new qt_gsi::GenericMethod ("month", "@brief Method int QDate::month()\n", true, &_init_f_month_c0, &_call_f_month_c0);
}

// bool QDate::operator!=(const QDate &other)


static void _init_f_operator_excl__eq__c1776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QDate & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c1776 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDate &arg1 = args.read<const QDate & > ();
  ret.write<bool > ((bool)((QDate *)cls)->operator!= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__c1776 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QDate::operator!=(const QDate &other)\n", true, &_init_f_operator_excl__eq__c1776, &_call_f_operator_excl__eq__c1776);
}

// bool QDate::operator<(const QDate &other)


static void _init_f_operator_lt__c1776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QDate & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_lt__c1776 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDate &arg1 = args.read<const QDate & > ();
  ret.write<bool > ((bool)((QDate *)cls)->operator< (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_lt__c1776 ()
{
  return new qt_gsi::GenericMethod ("<", "@brief Method bool QDate::operator<(const QDate &other)\n", true, &_init_f_operator_lt__c1776, &_call_f_operator_lt__c1776);
}

// bool QDate::operator<=(const QDate &other)


static void _init_f_operator_lt__eq__c1776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QDate & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_lt__eq__c1776 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDate &arg1 = args.read<const QDate & > ();
  ret.write<bool > ((bool)((QDate *)cls)->operator<= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_lt__eq__c1776 ()
{
  return new qt_gsi::GenericMethod ("<=", "@brief Method bool QDate::operator<=(const QDate &other)\n", true, &_init_f_operator_lt__eq__c1776, &_call_f_operator_lt__eq__c1776);
}

// bool QDate::operator==(const QDate &other)


static void _init_f_operator_eq__eq__c1776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QDate & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c1776 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDate &arg1 = args.read<const QDate & > ();
  ret.write<bool > ((bool)((QDate *)cls)->operator== (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__c1776 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QDate::operator==(const QDate &other)\n", true, &_init_f_operator_eq__eq__c1776, &_call_f_operator_eq__eq__c1776);
}

// bool QDate::operator>(const QDate &other)


static void _init_f_operator_gt__c1776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QDate & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_gt__c1776 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDate &arg1 = args.read<const QDate & > ();
  ret.write<bool > ((bool)((QDate *)cls)->operator> (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_gt__c1776 ()
{
  return new qt_gsi::GenericMethod (">", "@brief Method bool QDate::operator>(const QDate &other)\n", true, &_init_f_operator_gt__c1776, &_call_f_operator_gt__c1776);
}

// bool QDate::operator>=(const QDate &other)


static void _init_f_operator_gt__eq__c1776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QDate & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_gt__eq__c1776 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDate &arg1 = args.read<const QDate & > ();
  ret.write<bool > ((bool)((QDate *)cls)->operator>= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_gt__eq__c1776 ()
{
  return new qt_gsi::GenericMethod (">=", "@brief Method bool QDate::operator>=(const QDate &other)\n", true, &_init_f_operator_gt__eq__c1776, &_call_f_operator_gt__eq__c1776);
}

// bool QDate::setDate(int year, int month, int day)


static void _init_f_setDate_2085 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("year");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("month");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("day");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_setDate_2085 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ret.write<bool > ((bool)((QDate *)cls)->setDate (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_setDate_2085 ()
{
  return new qt_gsi::GenericMethod ("setDate", "@brief Method bool QDate::setDate(int year, int month, int day)\n", false, &_init_f_setDate_2085, &_call_f_setDate_2085);
}

// bool QDate::setYMD(int y, int m, int d)


static void _init_f_setYMD_2085 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("y");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("m");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("d");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_setYMD_2085 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ret.write<bool > ((bool)((QDate *)cls)->setYMD (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_setYMD_2085 ()
{
  return new qt_gsi::GenericMethod ("setYMD", "@brief Method bool QDate::setYMD(int y, int m, int d)\n", false, &_init_f_setYMD_2085, &_call_f_setYMD_2085);
}

// int QDate::toJulianDay()


static void _init_f_toJulianDay_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_toJulianDay_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QDate *)cls)->toJulianDay ());
}

static qt_gsi::GenericMethod *_create_f_toJulianDay_c0 ()
{
  return new qt_gsi::GenericMethod ("toJulianDay", "@brief Method int QDate::toJulianDay()\n", true, &_init_f_toJulianDay_c0, &_call_f_toJulianDay_c0);
}

// QString QDate::toString(Qt::DateFormat f)


static void _init_f_toString_c1748 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("f", true, "Qt::TextDate");
  decl->add_arg<const qt_gsi::Converter<Qt::DateFormat>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c1748 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<Qt::DateFormat>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<Qt::DateFormat>::target_type & > () : (const qt_gsi::Converter<Qt::DateFormat>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::DateFormat>(heap, Qt::TextDate));
  ret.write<QString > ((QString)((QDate *)cls)->toString (qt_gsi::QtToCppAdaptor<Qt::DateFormat>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_toString_c1748 ()
{
  return new qt_gsi::GenericMethod ("toString", "@brief Method QString QDate::toString(Qt::DateFormat f)\n", true, &_init_f_toString_c1748, &_call_f_toString_c1748);
}

// QString QDate::toString(const QString &format)


static void _init_f_toString_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QString > ((QString)((QDate *)cls)->toString (arg1));
}

static qt_gsi::GenericMethod *_create_f_toString_c2025 ()
{
  return new qt_gsi::GenericMethod ("toString", "@brief Method QString QDate::toString(const QString &format)\n", true, &_init_f_toString_c2025, &_call_f_toString_c2025);
}

// int QDate::weekNumber(int *yearNum)


static void _init_f_weekNumber_c953 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("yearNum", true, "0");
  decl->add_arg<int * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_weekNumber_c953 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int *arg1 = args ? args.read<int * > () : (int *)(0);
  ret.write<int > ((int)((QDate *)cls)->weekNumber (arg1));
}

static qt_gsi::GenericMethod *_create_f_weekNumber_c953 ()
{
  return new qt_gsi::GenericMethod ("weekNumber", "@brief Method int QDate::weekNumber(int *yearNum)\n", true, &_init_f_weekNumber_c953, &_call_f_weekNumber_c953);
}

// int QDate::year()


static void _init_f_year_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_year_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QDate *)cls)->year ());
}

static qt_gsi::GenericMethod *_create_f_year_c0 ()
{
  return new qt_gsi::GenericMethod ("year", "@brief Method int QDate::year()\n", true, &_init_f_year_c0, &_call_f_year_c0);
}

// static QDate QDate::currentDate()


static void _init_f_currentDate_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QDate > ();
}

static void _call_f_currentDate_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDate > ((QDate)QDate::currentDate ());
}

static qt_gsi::GenericStaticMethod *_create_f_currentDate_0 ()
{
  return new qt_gsi::GenericStaticMethod ("currentDate", "@brief Static method QDate QDate::currentDate()\nThis method is static and can be called without an instance.", &_init_f_currentDate_0, &_call_f_currentDate_0);
}

// static QDate QDate::fromJulianDay(int jd)


static void _init_f_fromJulianDay_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("jd");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QDate > ();
}

static void _call_f_fromJulianDay_767 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QDate > ((QDate)QDate::fromJulianDay (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_fromJulianDay_767 ()
{
  return new qt_gsi::GenericStaticMethod ("fromJulianDay", "@brief Static method QDate QDate::fromJulianDay(int jd)\nThis method is static and can be called without an instance.", &_init_f_fromJulianDay_767, &_call_f_fromJulianDay_767);
}

// static QDate QDate::fromString(const QString &s, Qt::DateFormat f)


static void _init_f_fromString_3665 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("f", true, "Qt::TextDate");
  decl->add_arg<const qt_gsi::Converter<Qt::DateFormat>::target_type & > (argspec_1);
  decl->set_return<QDate > ();
}

static void _call_f_fromString_3665 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::DateFormat>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::DateFormat>::target_type & > () : (const qt_gsi::Converter<Qt::DateFormat>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::DateFormat>(heap, Qt::TextDate));
  ret.write<QDate > ((QDate)QDate::fromString (arg1, qt_gsi::QtToCppAdaptor<Qt::DateFormat>(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_fromString_3665 ()
{
  return new qt_gsi::GenericStaticMethod ("fromString", "@brief Static method QDate QDate::fromString(const QString &s, Qt::DateFormat f)\nThis method is static and can be called without an instance.", &_init_f_fromString_3665, &_call_f_fromString_3665);
}

// static QDate QDate::fromString(const QString &s, const QString &format)


static void _init_f_fromString_3942 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QDate > ();
}

static void _call_f_fromString_3942 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  ret.write<QDate > ((QDate)QDate::fromString (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_fromString_3942 ()
{
  return new qt_gsi::GenericStaticMethod ("fromString", "@brief Static method QDate QDate::fromString(const QString &s, const QString &format)\nThis method is static and can be called without an instance.", &_init_f_fromString_3942, &_call_f_fromString_3942);
}

// static unsigned int QDate::gregorianToJulian(int y, int m, int d)


static void _init_f_gregorianToJulian_2085 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("y");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("m");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("d");
  decl->add_arg<int > (argspec_2);
  decl->set_return<unsigned int > ();
}

static void _call_f_gregorianToJulian_2085 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ret.write<unsigned int > ((unsigned int)QDate::gregorianToJulian (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_gregorianToJulian_2085 ()
{
  return new qt_gsi::GenericStaticMethod ("gregorianToJulian", "@brief Static method unsigned int QDate::gregorianToJulian(int y, int m, int d)\nThis method is static and can be called without an instance.", &_init_f_gregorianToJulian_2085, &_call_f_gregorianToJulian_2085);
}

// static bool QDate::isLeapYear(int year)


static void _init_f_isLeapYear_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("year");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isLeapYear_767 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<bool > ((bool)QDate::isLeapYear (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_isLeapYear_767 ()
{
  return new qt_gsi::GenericStaticMethod ("isLeapYear?", "@brief Static method bool QDate::isLeapYear(int year)\nThis method is static and can be called without an instance.", &_init_f_isLeapYear_767, &_call_f_isLeapYear_767);
}

// static bool QDate::isValid(int y, int m, int d)


static void _init_f_isValid_2085 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("y");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("m");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("d");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_isValid_2085 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ret.write<bool > ((bool)QDate::isValid (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_isValid_2085 ()
{
  return new qt_gsi::GenericStaticMethod ("isValid?", "@brief Static method bool QDate::isValid(int y, int m, int d)\nThis method is static and can be called without an instance.", &_init_f_isValid_2085, &_call_f_isValid_2085);
}

// static void QDate::julianToGregorian(unsigned int jd, int &y, int &m, int &d)


static void _init_f_julianToGregorian_4295 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("jd");
  decl->add_arg<unsigned int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("m");
  decl->add_arg<int & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("d");
  decl->add_arg<int & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_julianToGregorian_4295 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  int &arg2 = args.read<int & > ();
  int &arg3 = args.read<int & > ();
  int &arg4 = args.read<int & > ();
  QDate::julianToGregorian (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericStaticMethod *_create_f_julianToGregorian_4295 ()
{
  return new qt_gsi::GenericStaticMethod ("julianToGregorian", "@brief Static method void QDate::julianToGregorian(unsigned int jd, int &y, int &m, int &d)\nThis method is static and can be called without an instance.", &_init_f_julianToGregorian_4295, &_call_f_julianToGregorian_4295);
}

// static QString QDate::longDayName(int weekday)


static void _init_f_longDayName_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("weekday");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_longDayName_767 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QString > ((QString)QDate::longDayName (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_longDayName_767 ()
{
  return new qt_gsi::GenericStaticMethod ("longDayName", "@brief Static method QString QDate::longDayName(int weekday)\nThis method is static and can be called without an instance.", &_init_f_longDayName_767, &_call_f_longDayName_767);
}

// static QString QDate::longDayName(int weekday, QDate::MonthNameType type)


static void _init_f_longDayName_2995 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("weekday");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type");
  decl->add_arg<const qt_gsi::Converter<QDate::MonthNameType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_longDayName_2995 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<QDate::MonthNameType>::target_type & arg2 = args.read<const qt_gsi::Converter<QDate::MonthNameType>::target_type & > ();
  ret.write<QString > ((QString)QDate::longDayName (arg1, qt_gsi::QtToCppAdaptor<QDate::MonthNameType>(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_longDayName_2995 ()
{
  return new qt_gsi::GenericStaticMethod ("longDayName", "@brief Static method QString QDate::longDayName(int weekday, QDate::MonthNameType type)\nThis method is static and can be called without an instance.", &_init_f_longDayName_2995, &_call_f_longDayName_2995);
}

// static QString QDate::longMonthName(int month)


static void _init_f_longMonthName_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("month");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_longMonthName_767 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QString > ((QString)QDate::longMonthName (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_longMonthName_767 ()
{
  return new qt_gsi::GenericStaticMethod ("longMonthName", "@brief Static method QString QDate::longMonthName(int month)\nThis method is static and can be called without an instance.", &_init_f_longMonthName_767, &_call_f_longMonthName_767);
}

// static QString QDate::longMonthName(int month, QDate::MonthNameType type)


static void _init_f_longMonthName_2995 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("month");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type");
  decl->add_arg<const qt_gsi::Converter<QDate::MonthNameType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_longMonthName_2995 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<QDate::MonthNameType>::target_type & arg2 = args.read<const qt_gsi::Converter<QDate::MonthNameType>::target_type & > ();
  ret.write<QString > ((QString)QDate::longMonthName (arg1, qt_gsi::QtToCppAdaptor<QDate::MonthNameType>(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_longMonthName_2995 ()
{
  return new qt_gsi::GenericStaticMethod ("longMonthName", "@brief Static method QString QDate::longMonthName(int month, QDate::MonthNameType type)\nThis method is static and can be called without an instance.", &_init_f_longMonthName_2995, &_call_f_longMonthName_2995);
}

// static QString QDate::shortDayName(int weekday)


static void _init_f_shortDayName_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("weekday");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_shortDayName_767 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QString > ((QString)QDate::shortDayName (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_shortDayName_767 ()
{
  return new qt_gsi::GenericStaticMethod ("shortDayName", "@brief Static method QString QDate::shortDayName(int weekday)\nThis method is static and can be called without an instance.", &_init_f_shortDayName_767, &_call_f_shortDayName_767);
}

// static QString QDate::shortDayName(int weekday, QDate::MonthNameType type)


static void _init_f_shortDayName_2995 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("weekday");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type");
  decl->add_arg<const qt_gsi::Converter<QDate::MonthNameType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_shortDayName_2995 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<QDate::MonthNameType>::target_type & arg2 = args.read<const qt_gsi::Converter<QDate::MonthNameType>::target_type & > ();
  ret.write<QString > ((QString)QDate::shortDayName (arg1, qt_gsi::QtToCppAdaptor<QDate::MonthNameType>(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_shortDayName_2995 ()
{
  return new qt_gsi::GenericStaticMethod ("shortDayName", "@brief Static method QString QDate::shortDayName(int weekday, QDate::MonthNameType type)\nThis method is static and can be called without an instance.", &_init_f_shortDayName_2995, &_call_f_shortDayName_2995);
}

// static QString QDate::shortMonthName(int month)


static void _init_f_shortMonthName_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("month");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_shortMonthName_767 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QString > ((QString)QDate::shortMonthName (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_shortMonthName_767 ()
{
  return new qt_gsi::GenericStaticMethod ("shortMonthName", "@brief Static method QString QDate::shortMonthName(int month)\nThis method is static and can be called without an instance.", &_init_f_shortMonthName_767, &_call_f_shortMonthName_767);
}

// static QString QDate::shortMonthName(int month, QDate::MonthNameType type)


static void _init_f_shortMonthName_2995 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("month");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type");
  decl->add_arg<const qt_gsi::Converter<QDate::MonthNameType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_shortMonthName_2995 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<QDate::MonthNameType>::target_type & arg2 = args.read<const qt_gsi::Converter<QDate::MonthNameType>::target_type & > ();
  ret.write<QString > ((QString)QDate::shortMonthName (arg1, qt_gsi::QtToCppAdaptor<QDate::MonthNameType>(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_shortMonthName_2995 ()
{
  return new qt_gsi::GenericStaticMethod ("shortMonthName", "@brief Static method QString QDate::shortMonthName(int month, QDate::MonthNameType type)\nThis method is static and can be called without an instance.", &_init_f_shortMonthName_2995, &_call_f_shortMonthName_2995);
}


namespace gsi
{
gsi::Class<QDate> decl_QDate ("QDate",
  gsi::Methods(_create_ctor_QDate_0 ()) +
  gsi::Methods(_create_ctor_QDate_2085 ()) +
  gsi::Methods(_create_f_addDays_c767 ()) +
  gsi::Methods(_create_f_addMonths_c767 ()) +
  gsi::Methods(_create_f_addYears_c767 ()) +
  gsi::Methods(_create_f_day_c0 ()) +
  gsi::Methods(_create_f_dayOfWeek_c0 ()) +
  gsi::Methods(_create_f_dayOfYear_c0 ()) +
  gsi::Methods(_create_f_daysInMonth_c0 ()) +
  gsi::Methods(_create_f_daysInYear_c0 ()) +
  gsi::Methods(_create_f_daysTo_c1776 ()) +
  gsi::Methods(_create_f_getDate_2643 ()) +
  gsi::Methods(_create_f_isNull_c0 ()) +
  gsi::Methods(_create_f_isValid_c0 ()) +
  gsi::Methods(_create_f_month_c0 ()) +
  gsi::Methods(_create_f_operator_excl__eq__c1776 ()) +
  gsi::Methods(_create_f_operator_lt__c1776 ()) +
  gsi::Methods(_create_f_operator_lt__eq__c1776 ()) +
  gsi::Methods(_create_f_operator_eq__eq__c1776 ()) +
  gsi::Methods(_create_f_operator_gt__c1776 ()) +
  gsi::Methods(_create_f_operator_gt__eq__c1776 ()) +
  gsi::Methods(_create_f_setDate_2085 ()) +
  gsi::Methods(_create_f_setYMD_2085 ()) +
  gsi::Methods(_create_f_toJulianDay_c0 ()) +
  gsi::Methods(_create_f_toString_c1748 ()) +
  gsi::Methods(_create_f_toString_c2025 ()) +
  gsi::Methods(_create_f_weekNumber_c953 ()) +
  gsi::Methods(_create_f_year_c0 ()) +
  gsi::Methods(_create_f_currentDate_0 ()) +
  gsi::Methods(_create_f_fromJulianDay_767 ()) +
  gsi::Methods(_create_f_fromString_3665 ()) +
  gsi::Methods(_create_f_fromString_3942 ()) +
  gsi::Methods(_create_f_gregorianToJulian_2085 ()) +
  gsi::Methods(_create_f_isLeapYear_767 ()) +
  gsi::Methods(_create_f_isValid_2085 ()) +
  gsi::Methods(_create_f_julianToGregorian_4295 ()) +
  gsi::Methods(_create_f_longDayName_767 ()) +
  gsi::Methods(_create_f_longDayName_2995 ()) +
  gsi::Methods(_create_f_longMonthName_767 ()) +
  gsi::Methods(_create_f_longMonthName_2995 ()) +
  gsi::Methods(_create_f_shortDayName_767 ()) +
  gsi::Methods(_create_f_shortDayName_2995 ()) +
  gsi::Methods(_create_f_shortMonthName_767 ()) +
  gsi::Methods(_create_f_shortMonthName_2995 ()),
  "@qt\n@brief Binding of QDate");

}


//  Implementation of the enum wrapper class for QDate::MonthNameType
namespace qt_gsi
{

static QDate_MonthNameType_Enum *c_1_QDate_MonthNameType_Enum () { return new QDate_MonthNameType_Enum (QDate::DateFormat); }
static QDate_MonthNameType_Enum *c_2_QDate_MonthNameType_Enum () { return new QDate_MonthNameType_Enum (QDate::StandaloneFormat); }

static gsi::Methods mkdefs_QDate_MonthNameType () {
  return
    gsi::constant ("DateFormat", &qt_gsi::c_1_QDate_MonthNameType_Enum, "@brief Enum constant QDate::DateFormat") +
    gsi::constant ("StandaloneFormat", &qt_gsi::c_2_QDate_MonthNameType_Enum, "@brief Enum constant QDate::StandaloneFormat");
}

static std::string to_s_QDate_MonthNameType_Enum (const QDate_MonthNameType_Enum *e)
{
  if (e->value () == QDate::DateFormat) { return tl::sprintf ("DateFormat (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDate::StandaloneFormat) { return tl::sprintf ("StandaloneFormat (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QDate_MonthNameType_Enum (const QDate_MonthNameType_Enum *e)
{
  return (unsigned int) e->value ();
}

static QDate_MonthNameType_Enum *from_i_QDate_MonthNameType_Enum (unsigned int i)
{
  return new QDate_MonthNameType_Enum ((QDate::MonthNameType) i);
}

static bool equalQDate_MonthNameType_Enum (const QDate_MonthNameType_Enum *e, QDate_MonthNameType_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QDate_MonthNameType_Enum (const QDate_MonthNameType_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QDate_MonthNameType_Enums oropQDate_MonthNameType_Enums (const QDate_MonthNameType_Enums *e, const QDate_MonthNameType_Enums &d)
{
  return e->flags () | d.flags ();
}

static QDate_MonthNameType_Enums andopQDate_MonthNameType_Enums (const QDate_MonthNameType_Enums *e, const QDate_MonthNameType_Enums &d)
{
  return e->flags () & d.flags ();
}

static QDate_MonthNameType_Enums xoropQDate_MonthNameType_Enums (const QDate_MonthNameType_Enums *e, const QDate_MonthNameType_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QDate_MonthNameType_Enums (const QDate_MonthNameType_Enums *e)
{
  std::string l;
  if (e->testFlag (QDate::DateFormat)) { if (!l.empty ()) l += "|"; l += "DateFormat"; }
  if (e->testFlag (QDate::StandaloneFormat)) { if (!l.empty ()) l += "|"; l += "StandaloneFormat"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QDate_MonthNameType_Enums (const QDate_MonthNameType_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QDate_MonthNameType_Enums (const QDate_MonthNameType_Enums *e, const QDate_MonthNameType_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QDate_MonthNameType_Enums> decl_QDate_MonthNameType_Enums ("QDate_QFlags_MonthNameType",
  gsi::method_ext ("|", &qt_gsi::oropQDate_MonthNameType_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQDate_MonthNameType_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQDate_MonthNameType_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QDate_MonthNameType_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QDate_MonthNameType_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QDate_MonthNameType_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QDate::MonthNameType> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QDate_MonthNameType_Enum> decl_QDate_MonthNameType_Enum (decl_QDate_MonthNameType_Enums, "QDate_MonthNameType",
  qt_gsi::mkdefs_QDate_MonthNameType () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QDate_MonthNameType_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QDate_MonthNameType_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQDate_MonthNameType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QDate_MonthNameType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QDate_MonthNameType_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QDate::MonthNameType enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QDate> inject_QDate_MonthNameType_Enum_in_parent (qt_gsi::mkdefs_QDate_MonthNameType ());
static gsi::ClassExt<QDate> decl_QDate_MonthNameType_Enum_as_child (decl_QDate_MonthNameType_Enum, "MonthNameType");

}

